/*
 * Decompiled with CFR 0.152.
 */
package org.openjsse.sun.security.ssl;

import java.security.AlgorithmConstraints;
import java.security.CryptoPrimitive;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.openjsse.sun.security.ssl.JsseJce;
import org.openjsse.sun.security.ssl.ProtocolVersion;
import org.openjsse.sun.security.ssl.SSLConfiguration;
import org.openjsse.sun.security.ssl.SSLLogger;
import org.openjsse.sun.security.ssl.SupportedGroupsExtension;
import org.openjsse.sun.security.ssl.X509Authentication;
import sun.security.util.KeyUtil;

enum SignatureScheme {
    ED25519(2055, "ed25519", "ed25519", "ed25519", ProtocolVersion.PROTOCOLS_OF_13),
    ED448(2056, "ed448", "ed448", "ed448", ProtocolVersion.PROTOCOLS_OF_13),
    ECDSA_SECP256R1_SHA256(1027, "ecdsa_secp256r1_sha256", "SHA256withECDSA", "EC", SupportedGroupsExtension.NamedGroup.SECP256_R1, ProtocolVersion.PROTOCOLS_TO_13),
    ECDSA_SECP384R1_SHA384(1283, "ecdsa_secp384r1_sha384", "SHA384withECDSA", "EC", SupportedGroupsExtension.NamedGroup.SECP384_R1, ProtocolVersion.PROTOCOLS_TO_13),
    ECDSA_SECP512R1_SHA512(1539, "ecdsa_secp521r1_sha512", "SHA512withECDSA", "EC", SupportedGroupsExtension.NamedGroup.SECP521_R1, ProtocolVersion.PROTOCOLS_TO_13),
    RSA_PSS_RSAE_SHA256(2052, "rsa_pss_rsae_sha256", "RSASSA-PSS", "RSA", SigAlgParamSpec.RSA_PSS_SHA256, 528, ProtocolVersion.PROTOCOLS_12_13),
    RSA_PSS_RSAE_SHA384(2053, "rsa_pss_rsae_sha384", "RSASSA-PSS", "RSA", SigAlgParamSpec.RSA_PSS_SHA384, 784, ProtocolVersion.PROTOCOLS_12_13),
    RSA_PSS_RSAE_SHA512(2054, "rsa_pss_rsae_sha512", "RSASSA-PSS", "RSA", SigAlgParamSpec.RSA_PSS_SHA512, 1040, ProtocolVersion.PROTOCOLS_12_13),
    RSA_PSS_PSS_SHA256(2057, "rsa_pss_pss_sha256", "RSASSA-PSS", "RSASSA-PSS", SigAlgParamSpec.RSA_PSS_SHA256, 528, ProtocolVersion.PROTOCOLS_12_13),
    RSA_PSS_PSS_SHA384(2058, "rsa_pss_pss_sha384", "RSASSA-PSS", "RSASSA-PSS", SigAlgParamSpec.RSA_PSS_SHA384, 784, ProtocolVersion.PROTOCOLS_12_13),
    RSA_PSS_PSS_SHA512(2059, "rsa_pss_pss_sha512", "RSASSA-PSS", "RSASSA-PSS", SigAlgParamSpec.RSA_PSS_SHA512, 1040, ProtocolVersion.PROTOCOLS_12_13),
    RSA_PKCS1_SHA256(1025, "rsa_pkcs1_sha256", "SHA256withRSA", "RSA", null, null, 511, ProtocolVersion.PROTOCOLS_TO_13, ProtocolVersion.PROTOCOLS_TO_12),
    RSA_PKCS1_SHA384(1281, "rsa_pkcs1_sha384", "SHA384withRSA", "RSA", null, null, 768, ProtocolVersion.PROTOCOLS_TO_13, ProtocolVersion.PROTOCOLS_TO_12),
    RSA_PKCS1_SHA512(1537, "rsa_pkcs1_sha512", "SHA512withRSA", "RSA", null, null, 768, ProtocolVersion.PROTOCOLS_TO_13, ProtocolVersion.PROTOCOLS_TO_12),
    DSA_SHA256(1026, "dsa_sha256", "SHA256withDSA", "DSA", ProtocolVersion.PROTOCOLS_TO_12),
    ECDSA_SHA224(771, "ecdsa_sha224", "SHA224withECDSA", "EC", ProtocolVersion.PROTOCOLS_TO_12),
    RSA_SHA224(769, "rsa_sha224", "SHA224withRSA", "RSA", 511, ProtocolVersion.PROTOCOLS_TO_12),
    DSA_SHA224(770, "dsa_sha224", "SHA224withDSA", "DSA", ProtocolVersion.PROTOCOLS_TO_12),
    ECDSA_SHA1(515, "ecdsa_sha1", "SHA1withECDSA", "EC", ProtocolVersion.PROTOCOLS_TO_13),
    RSA_PKCS1_SHA1(513, "rsa_pkcs1_sha1", "SHA1withRSA", "RSA", null, null, 511, ProtocolVersion.PROTOCOLS_TO_13, ProtocolVersion.PROTOCOLS_TO_12),
    DSA_SHA1(514, "dsa_sha1", "SHA1withDSA", "DSA", ProtocolVersion.PROTOCOLS_TO_12),
    RSA_MD5(257, "rsa_md5", "MD5withRSA", "RSA", 511, ProtocolVersion.PROTOCOLS_TO_12);

    final int id;
    final String name;
    private final String algorithm;
    final String keyAlgorithm;
    private final AlgorithmParameterSpec signAlgParameter;
    private final SupportedGroupsExtension.NamedGroup namedGroup;
    final int minimalKeySize;
    final List<ProtocolVersion> supportedProtocols;
    final List<ProtocolVersion> handshakeSupportedProtocols;
    final boolean isAvailable;
    private static final String[] hashAlgorithms;
    private static final String[] signatureAlgorithms;
    private static final Set<CryptoPrimitive> SIGNATURE_PRIMITIVE_SET;

    private SignatureScheme(int id, String name, String algorithm, String keyAlgorithm, ProtocolVersion[] supportedProtocols) {
        this(id, name, algorithm, keyAlgorithm, -1, supportedProtocols);
    }

    private SignatureScheme(int id, String name, String algorithm, String keyAlgorithm, int minimalKeySize, ProtocolVersion[] supportedProtocols) {
        this(id, name, algorithm, keyAlgorithm, null, minimalKeySize, supportedProtocols);
    }

    private SignatureScheme(int id, String name, String algorithm, String keyAlgorithm, SigAlgParamSpec signAlgParamSpec, int minimalKeySize, ProtocolVersion[] supportedProtocols) {
        this(id, name, algorithm, keyAlgorithm, signAlgParamSpec, null, minimalKeySize, supportedProtocols, supportedProtocols);
    }

    private SignatureScheme(int id, String name, String algorithm, String keyAlgorithm, SupportedGroupsExtension.NamedGroup namedGroup, ProtocolVersion[] supportedProtocols) {
        this(id, name, algorithm, keyAlgorithm, null, namedGroup, -1, supportedProtocols, supportedProtocols);
    }

    private SignatureScheme(int id, String name, String algorithm, String keyAlgorithm, SigAlgParamSpec signAlgParamSpec, SupportedGroupsExtension.NamedGroup namedGroup, int minimalKeySize, ProtocolVersion[] supportedProtocols, ProtocolVersion[] handshakeSupportedProtocols) {
        boolean mediator;
        block7: {
            this.id = id;
            this.name = name;
            this.algorithm = algorithm;
            this.keyAlgorithm = keyAlgorithm;
            this.signAlgParameter = signAlgParamSpec != null ? signAlgParamSpec.parameterSpec : null;
            this.namedGroup = namedGroup;
            this.minimalKeySize = minimalKeySize;
            this.supportedProtocols = Arrays.asList(supportedProtocols);
            this.handshakeSupportedProtocols = Arrays.asList(handshakeSupportedProtocols);
            mediator = true;
            if ("EC".equals(keyAlgorithm)) {
                mediator = JsseJce.isEcAvailable();
            }
            if (mediator) {
                if (signAlgParamSpec != null) {
                    mediator = signAlgParamSpec.isAvailable;
                } else {
                    try {
                        JsseJce.getSignature(algorithm);
                    }
                    catch (Exception e) {
                        mediator = false;
                        if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) break block7;
                        SSLLogger.warning("Signature algorithm, " + algorithm + ", is not supported by the underlying providers", new Object[0]);
                    }
                }
            }
        }
        if (mediator && (id >> 8 & 0xFF) == 3 && Security.getProvider("SunMSCAPI") != null) {
            mediator = false;
        }
        this.isAvailable = mediator;
    }

    static SignatureScheme valueOf(int id) {
        for (SignatureScheme ss : SignatureScheme.values()) {
            if (ss.id != id) continue;
            return ss;
        }
        return null;
    }

    static String nameOf(int id) {
        for (SignatureScheme ss : SignatureScheme.values()) {
            if (ss.id != id) continue;
            return ss.name;
        }
        int hashId = id >> 8 & 0xFF;
        int signId = id & 0xFF;
        String hashName = hashId >= hashAlgorithms.length ? "UNDEFINED-HASH(" + hashId + ")" : hashAlgorithms[hashId];
        String signName = signId >= signatureAlgorithms.length ? "UNDEFINED-SIGNATURE(" + signId + ")" : signatureAlgorithms[signId];
        return signName + "_" + hashName;
    }

    static SignatureScheme nameOf(String signatureSchemeName) {
        for (SignatureScheme ss : SignatureScheme.values()) {
            if (!ss.name.equalsIgnoreCase(signatureSchemeName)) continue;
            return ss;
        }
        return null;
    }

    static int sizeInRecord() {
        return 2;
    }

    static List<SignatureScheme> getSupportedAlgorithms(SSLConfiguration config, AlgorithmConstraints constraints, List<ProtocolVersion> activeProtocols) {
        LinkedList<SignatureScheme> supported = new LinkedList<SignatureScheme>();
        for (SignatureScheme ss : SignatureScheme.values()) {
            if (!ss.isAvailable || !config.signatureSchemes.isEmpty() && !config.signatureSchemes.contains((Object)ss)) {
                if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake,verbose")) continue;
                SSLLogger.finest("Ignore unsupported signature scheme: " + ss.name, new Object[0]);
                continue;
            }
            boolean isMatch = false;
            for (ProtocolVersion pv : activeProtocols) {
                if (!ss.supportedProtocols.contains((Object)pv)) continue;
                isMatch = true;
                break;
            }
            if (isMatch) {
                if (constraints.permits(SIGNATURE_PRIMITIVE_SET, ss.algorithm, null)) {
                    supported.add(ss);
                    continue;
                }
                if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake,verbose")) continue;
                SSLLogger.finest("Ignore disabled signature scheme: " + ss.name, new Object[0]);
                continue;
            }
            if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake,verbose")) continue;
            SSLLogger.finest("Ignore inactive signature scheme: " + ss.name, new Object[0]);
        }
        return supported;
    }

    static List<SignatureScheme> getSupportedAlgorithms(SSLConfiguration config, AlgorithmConstraints constraints, ProtocolVersion protocolVersion, int[] algorithmIds) {
        LinkedList<SignatureScheme> supported = new LinkedList<SignatureScheme>();
        for (int ssid : algorithmIds) {
            SignatureScheme ss = SignatureScheme.valueOf(ssid);
            if (ss == null) {
                if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) continue;
                SSLLogger.warning("Unsupported signature scheme: " + SignatureScheme.nameOf(ssid), new Object[0]);
                continue;
            }
            if (ss.isAvailable && ss.supportedProtocols.contains((Object)protocolVersion) && (config.signatureSchemes.isEmpty() || config.signatureSchemes.contains((Object)ss)) && constraints.permits(SIGNATURE_PRIMITIVE_SET, ss.algorithm, null)) {
                supported.add(ss);
                continue;
            }
            if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) continue;
            SSLLogger.warning("Unsupported signature scheme: " + ss.name, new Object[0]);
        }
        return supported;
    }

    static SignatureScheme getPreferableAlgorithm(List<SignatureScheme> schemes, SignatureScheme certScheme, ProtocolVersion version) {
        for (SignatureScheme ss : schemes) {
            if (!ss.isAvailable || !ss.handshakeSupportedProtocols.contains((Object)version) || !certScheme.keyAlgorithm.equalsIgnoreCase(ss.keyAlgorithm)) continue;
            return ss;
        }
        return null;
    }

    static SignatureScheme getPreferableAlgorithm(List<SignatureScheme> schemes, X509Authentication.X509Possession x509Possession, ProtocolVersion version) {
        PrivateKey signingKey = x509Possession.popPrivateKey;
        String keyAlgorithm = signingKey.getAlgorithm();
        int keySize = keyAlgorithm.equalsIgnoreCase("RSA") || keyAlgorithm.equalsIgnoreCase("RSASSA-PSS") ? KeyUtil.getKeySize(signingKey) : Integer.MAX_VALUE;
        for (SignatureScheme ss : schemes) {
            if (!ss.isAvailable || keySize < ss.minimalKeySize || !ss.handshakeSupportedProtocols.contains((Object)version) || !keyAlgorithm.equalsIgnoreCase(ss.keyAlgorithm)) continue;
            if (ss.namedGroup != null && ss.namedGroup.type == SupportedGroupsExtension.NamedGroupType.NAMED_GROUP_ECDHE) {
                ECParameterSpec params = x509Possession.getECParameterSpec();
                if (params == null || ss.namedGroup != SupportedGroupsExtension.NamedGroup.valueOf(params)) continue;
                return ss;
            }
            return ss;
        }
        return null;
    }

    static String[] getAlgorithmNames(Collection<SignatureScheme> schemes) {
        if (schemes != null) {
            ArrayList<String> names = new ArrayList<String>(schemes.size());
            for (SignatureScheme scheme : schemes) {
                names.add(scheme.algorithm);
            }
            return names.toArray(new String[0]);
        }
        return new String[0];
    }

    Signature getSignature(Key key) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException {
        if (!this.isAvailable) {
            return null;
        }
        Signature signer = JsseJce.getSignature(this.algorithm);
        if (key instanceof PublicKey) {
            signer.initVerify((PublicKey)key);
        } else {
            signer.initSign((PrivateKey)key);
        }
        if (this.signAlgParameter != null) {
            signer.setParameter(this.signAlgParameter);
        }
        return signer;
    }

    static {
        hashAlgorithms = new String[]{"none", "md5", "sha1", "sha224", "sha256", "sha384", "sha512"};
        signatureAlgorithms = new String[]{"anonymous", "rsa", "dsa", "ecdsa"};
        SIGNATURE_PRIMITIVE_SET = Collections.unmodifiableSet(EnumSet.of(CryptoPrimitive.SIGNATURE));
    }

    static enum SigAlgParamSpec {
        RSA_PSS_SHA256("SHA-256", 32),
        RSA_PSS_SHA384("SHA-384", 48),
        RSA_PSS_SHA512("SHA-512", 64);

        private final AlgorithmParameterSpec parameterSpec;
        final boolean isAvailable;

        private SigAlgParamSpec(String hash, int saltLength) {
            boolean mediator;
            PSSParameterSpec pssParamSpec;
            block2: {
                pssParamSpec = new PSSParameterSpec(hash, "MGF1", new MGF1ParameterSpec(hash), saltLength, 1);
                mediator = true;
                try {
                    Signature signer = JsseJce.getSignature("RSASSA-PSS");
                    signer.setParameter(pssParamSpec);
                }
                catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException exp) {
                    mediator = false;
                    if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) break block2;
                    SSLLogger.warning("RSASSA-PSS signature with " + hash + " is not supported by the underlying providers", exp);
                }
            }
            this.isAvailable = mediator;
            this.parameterSpec = mediator ? pssParamSpec : null;
        }

        AlgorithmParameterSpec getParameterSpec() {
            return this.parameterSpec;
        }
    }
}

