/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.X509Data;
import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509Certificate;
import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509IssuerSerial;
import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509SKI;
import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509SubjectName;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.utils.SignatureElementProxy;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import org.w3c.dom.Element;

public class PrivateKeyResolver
extends KeyResolverSpi {
    private static final Logger LOG = Logger.getLogger(PrivateKeyResolver.class.getName());
    private KeyStore keyStore;
    private char[] password;

    public PrivateKeyResolver(KeyStore keyStore, char[] cArray) {
        this.keyStore = keyStore;
        this.password = cArray;
    }

    @Override
    public boolean engineCanResolve(Element element, String string, StorageResolver storageResolver) {
        return XMLUtils.elementIsInSignatureSpace(element, "X509Data") || XMLUtils.elementIsInSignatureSpace(element, "KeyName");
    }

    @Override
    public PublicKey engineLookupAndResolvePublicKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        return null;
    }

    @Override
    public X509Certificate engineLookupResolveX509Certificate(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        return null;
    }

    @Override
    public SecretKey engineResolveSecretKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        return null;
    }

    @Override
    public PrivateKey engineLookupAndResolvePrivateKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        LOG.log(Level.FINE, "Can I resolve " + element.getTagName() + "?");
        if (XMLUtils.elementIsInSignatureSpace(element, "X509Data")) {
            PrivateKey privateKey = this.resolveX509Data(element, string);
            if (privateKey != null) {
                return privateKey;
            }
        } else if (XMLUtils.elementIsInSignatureSpace(element, "KeyName")) {
            LOG.log(Level.FINE, "Can I resolve KeyName?");
            String string2 = element.getFirstChild().getNodeValue();
            try {
                Key key = this.keyStore.getKey(string2, this.password);
                if (key instanceof PrivateKey) {
                    return (PrivateKey)key;
                }
            }
            catch (Exception exception) {
                LOG.log(Level.FINE, "Cannot recover the key", exception);
            }
        }
        LOG.log(Level.FINE, "I can't");
        return null;
    }

    private PrivateKey resolveX509Data(Element element, String string) {
        LOG.log(Level.FINE, "Can I resolve X509Data?");
        try {
            PrivateKey privateKey;
            SignatureElementProxy signatureElementProxy;
            int n;
            X509Data x509Data = new X509Data(element, string);
            int n2 = x509Data.lengthSKI();
            for (n = 0; n < n2; ++n) {
                signatureElementProxy = x509Data.itemSKI(n);
                privateKey = this.resolveX509SKI((XMLX509SKI)signatureElementProxy);
                if (privateKey == null) continue;
                return privateKey;
            }
            n2 = x509Data.lengthIssuerSerial();
            for (n = 0; n < n2; ++n) {
                signatureElementProxy = x509Data.itemIssuerSerial(n);
                privateKey = this.resolveX509IssuerSerial((XMLX509IssuerSerial)signatureElementProxy);
                if (privateKey == null) continue;
                return privateKey;
            }
            n2 = x509Data.lengthSubjectName();
            for (n = 0; n < n2; ++n) {
                signatureElementProxy = x509Data.itemSubjectName(n);
                privateKey = this.resolveX509SubjectName((XMLX509SubjectName)signatureElementProxy);
                if (privateKey == null) continue;
                return privateKey;
            }
            n2 = x509Data.lengthCertificate();
            for (n = 0; n < n2; ++n) {
                signatureElementProxy = x509Data.itemCertificate(n);
                privateKey = this.resolveX509Certificate((XMLX509Certificate)signatureElementProxy);
                if (privateKey == null) continue;
                return privateKey;
            }
        }
        catch (XMLSecurityException xMLSecurityException) {
            LOG.log(Level.FINE, "XMLSecurityException", xMLSecurityException);
        }
        catch (KeyStoreException keyStoreException) {
            LOG.log(Level.FINE, "KeyStoreException", keyStoreException);
        }
        return null;
    }

    private PrivateKey resolveX509SKI(XMLX509SKI xMLX509SKI) throws XMLSecurityException, KeyStoreException {
        LOG.log(Level.FINE, "Can I resolve X509SKI?");
        Enumeration<String> enumeration = this.keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            XMLX509SKI xMLX509SKI2;
            Certificate certificate;
            String string = enumeration.nextElement();
            if (!this.keyStore.isKeyEntry(string) || !((certificate = this.keyStore.getCertificate(string)) instanceof X509Certificate) || !(xMLX509SKI2 = new XMLX509SKI(xMLX509SKI.getDocument(), (X509Certificate)certificate)).equals(xMLX509SKI)) continue;
            LOG.log(Level.FINE, "match !!! ");
            try {
                Key key = this.keyStore.getKey(string, this.password);
                if (!(key instanceof PrivateKey)) continue;
                return (PrivateKey)key;
            }
            catch (Exception exception) {
                LOG.log(Level.FINE, "Cannot recover the key", exception);
            }
        }
        return null;
    }

    private PrivateKey resolveX509IssuerSerial(XMLX509IssuerSerial xMLX509IssuerSerial) throws KeyStoreException {
        LOG.log(Level.FINE, "Can I resolve X509IssuerSerial?");
        Enumeration<String> enumeration = this.keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            XMLX509IssuerSerial xMLX509IssuerSerial2;
            Certificate certificate;
            String string = enumeration.nextElement();
            if (!this.keyStore.isKeyEntry(string) || !((certificate = this.keyStore.getCertificate(string)) instanceof X509Certificate) || !(xMLX509IssuerSerial2 = new XMLX509IssuerSerial(xMLX509IssuerSerial.getDocument(), (X509Certificate)certificate)).equals(xMLX509IssuerSerial)) continue;
            LOG.log(Level.FINE, "match !!! ");
            try {
                Key key = this.keyStore.getKey(string, this.password);
                if (!(key instanceof PrivateKey)) continue;
                return (PrivateKey)key;
            }
            catch (Exception exception) {
                LOG.log(Level.FINE, "Cannot recover the key", exception);
            }
        }
        return null;
    }

    private PrivateKey resolveX509SubjectName(XMLX509SubjectName xMLX509SubjectName) throws KeyStoreException {
        LOG.log(Level.FINE, "Can I resolve X509SubjectName?");
        Enumeration<String> enumeration = this.keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            XMLX509SubjectName xMLX509SubjectName2;
            Certificate certificate;
            String string = enumeration.nextElement();
            if (!this.keyStore.isKeyEntry(string) || !((certificate = this.keyStore.getCertificate(string)) instanceof X509Certificate) || !(xMLX509SubjectName2 = new XMLX509SubjectName(xMLX509SubjectName.getDocument(), (X509Certificate)certificate)).equals(xMLX509SubjectName)) continue;
            LOG.log(Level.FINE, "match !!! ");
            try {
                Key key = this.keyStore.getKey(string, this.password);
                if (!(key instanceof PrivateKey)) continue;
                return (PrivateKey)key;
            }
            catch (Exception exception) {
                LOG.log(Level.FINE, "Cannot recover the key", exception);
            }
        }
        return null;
    }

    private PrivateKey resolveX509Certificate(XMLX509Certificate xMLX509Certificate) throws XMLSecurityException, KeyStoreException {
        LOG.log(Level.FINE, "Can I resolve X509Certificate?");
        byte[] byArray = xMLX509Certificate.getCertificateBytes();
        Enumeration<String> enumeration = this.keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            Certificate certificate;
            String string = enumeration.nextElement();
            if (!this.keyStore.isKeyEntry(string) || !((certificate = this.keyStore.getCertificate(string)) instanceof X509Certificate)) continue;
            byte[] byArray2 = null;
            try {
                byArray2 = certificate.getEncoded();
            }
            catch (CertificateEncodingException certificateEncodingException) {
                LOG.log(Level.FINE, "Cannot recover the key", certificateEncodingException);
            }
            if (byArray2 == null || !Arrays.equals(byArray2, byArray)) continue;
            LOG.log(Level.FINE, "match !!! ");
            try {
                Key key = this.keyStore.getKey(string, this.password);
                if (!(key instanceof PrivateKey)) continue;
                return (PrivateKey)key;
            }
            catch (Exception exception) {
                LOG.log(Level.FINE, "Cannot recover the key", exception);
            }
        }
        return null;
    }
}

