/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.content.x509;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509DataContent;
import com.sun.org.apache.xml.internal.security.utils.RFC2253Parser;
import com.sun.org.apache.xml.internal.security.utils.SignatureElementProxy;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLX509IssuerSerial
extends SignatureElementProxy
implements XMLX509DataContent {
    private static final Logger LOG = Logger.getLogger(XMLX509IssuerSerial.class.getName());

    public XMLX509IssuerSerial(Element element, String string) throws XMLSecurityException {
        super(element, string);
    }

    public XMLX509IssuerSerial(Document document, String string, BigInteger bigInteger) {
        super(document);
        this.addReturnToSelf();
        this.addTextElement(string, "X509IssuerName");
        this.addTextElement(bigInteger.toString(), "X509SerialNumber");
    }

    public XMLX509IssuerSerial(Document document, String string, String string2) {
        this(document, string, new BigInteger(string2));
    }

    public XMLX509IssuerSerial(Document document, String string, int n) {
        this(document, string, new BigInteger(Integer.toString(n)));
    }

    public XMLX509IssuerSerial(Document document, X509Certificate x509Certificate) {
        this(document, x509Certificate.getIssuerX500Principal().getName(), x509Certificate.getSerialNumber());
    }

    public BigInteger getSerialNumber() {
        String string = this.getTextFromChildElement("X509SerialNumber", "http://www.w3.org/2000/09/xmldsig#");
        LOG.log(Level.FINE, "X509SerialNumber text: " + string + "");
        return new BigInteger(string);
    }

    public int getSerialNumberInteger() {
        return this.getSerialNumber().intValue();
    }

    public String getIssuerName() {
        return RFC2253Parser.normalize(this.getTextFromChildElement("X509IssuerName", "http://www.w3.org/2000/09/xmldsig#"));
    }

    public boolean equals(Object object) {
        if (!(object instanceof XMLX509IssuerSerial)) {
            return false;
        }
        XMLX509IssuerSerial xMLX509IssuerSerial = (XMLX509IssuerSerial)object;
        return this.getSerialNumber().equals(xMLX509IssuerSerial.getSerialNumber()) && this.getIssuerName().equals(xMLX509IssuerSerial.getIssuerName());
    }

    public int hashCode() {
        int n = 17;
        n = 31 * n + this.getSerialNumber().hashCode();
        n = 31 * n + this.getIssuerName().hashCode();
        return n;
    }

    @Override
    public String getBaseLocalName() {
        return "X509IssuerSerial";
    }
}

