/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.content.x509;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509DataContent;
import com.sun.org.apache.xml.internal.security.utils.SignatureElementProxy;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.logging.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLX509Certificate
extends SignatureElementProxy
implements XMLX509DataContent {
    public static final String JCA_CERT_ID = "X.509";

    public XMLX509Certificate(Element element, String string) throws XMLSecurityException {
        super(element, string);
    }

    public XMLX509Certificate(Document document, byte[] byArray) {
        super(document);
        this.addBase64Text(byArray);
    }

    public XMLX509Certificate(Document document, X509Certificate x509Certificate) throws XMLSecurityException {
        super(document);
        try {
            this.addBase64Text(x509Certificate.getEncoded());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new XMLSecurityException(certificateEncodingException);
        }
    }

    public byte[] getCertificateBytes() throws XMLSecurityException {
        return this.getBytesFromTextChild();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public X509Certificate getX509Certificate() throws XMLSecurityException {
        byte[] byArray = this.getCertificateBytes();
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);){
            CertificateFactory certificateFactory = CertificateFactory.getInstance(JCA_CERT_ID);
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
            if (x509Certificate != null) {
                X509Certificate x509Certificate2 = x509Certificate;
                return x509Certificate2;
            }
            X509Certificate x509Certificate3 = null;
            return x509Certificate3;
        }
        catch (IOException | CertificateException exception) {
            throw new XMLSecurityException(exception);
        }
    }

    public PublicKey getPublicKey() throws XMLSecurityException, IOException {
        X509Certificate x509Certificate = this.getX509Certificate();
        if (x509Certificate != null) {
            return x509Certificate.getPublicKey();
        }
        return null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof XMLX509Certificate)) {
            return false;
        }
        XMLX509Certificate xMLX509Certificate = (XMLX509Certificate)object;
        try {
            return Arrays.equals(xMLX509Certificate.getCertificateBytes(), this.getCertificateBytes());
        }
        catch (XMLSecurityException xMLSecurityException) {
            return false;
        }
    }

    public int hashCode() {
        int n = 17;
        try {
            byte[] byArray = this.getCertificateBytes();
            for (int i = 0; i < byArray.length; ++i) {
                n = 31 * n + byArray[i];
            }
        }
        catch (XMLSecurityException xMLSecurityException) {
            LOG.log(Level.FINE, xMLSecurityException.getMessage(), xMLSecurityException);
        }
        return n;
    }

    @Override
    public String getBaseLocalName() {
        return "X509Certificate";
    }
}

