/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.marlin;

import java.awt.geom.Path2D;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicInteger;
import sun.java2d.ReentrantContext;
import sun.java2d.marlin.ArrayCacheConst;
import sun.java2d.marlin.ByteArrayCache;
import sun.java2d.marlin.CollinearSimplifier;
import sun.java2d.marlin.Curve;
import sun.java2d.marlin.Dasher;
import sun.java2d.marlin.FloatArrayCache;
import sun.java2d.marlin.IntArrayCache;
import sun.java2d.marlin.MarlinCache;
import sun.java2d.marlin.MarlinConst;
import sun.java2d.marlin.MarlinRenderingEngine;
import sun.java2d.marlin.MarlinTileGenerator;
import sun.java2d.marlin.MarlinUtils;
import sun.java2d.marlin.OffHeapArray;
import sun.java2d.marlin.Renderer;
import sun.java2d.marlin.RendererStats;
import sun.java2d.marlin.Stroker;
import sun.java2d.marlin.TransformingPathConsumer2D;

final class RendererContext
extends ReentrantContext
implements MarlinConst {
    private static final AtomicInteger CTX_COUNT = new AtomicInteger(1);
    private final Object cleanerObj;
    boolean dirty = false;
    final float[] float6 = new float[6];
    final Curve curve = new Curve();
    final MarlinRenderingEngine.NormalizingPathIterator nPCPathIterator;
    final MarlinRenderingEngine.NormalizingPathIterator nPQPathIterator;
    final TransformingPathConsumer2D transformerPC2D;
    private WeakReference<Path2D.Float> refPath2D = null;
    final Renderer renderer;
    final Stroker stroker;
    final CollinearSimplifier simplifier = new CollinearSimplifier();
    final Dasher dasher;
    final MarlinTileGenerator ptg;
    final MarlinCache cache;
    int stroking = 0;
    private final IntArrayCache cleanIntCache = new IntArrayCache(true, 5);
    private final IntArrayCache dirtyIntCache = new IntArrayCache(false, 4);
    private final FloatArrayCache dirtyFloatCache = new FloatArrayCache(false, 3);
    private final ByteArrayCache dirtyByteCache = new ByteArrayCache(false, 1);
    final RendererStats stats;

    static RendererContext createContext() {
        return new RendererContext("ctx" + Integer.toString(CTX_COUNT.getAndIncrement()));
    }

    RendererContext(String string) {
        if (LOG_CREATE_CONTEXT) {
            MarlinUtils.logInfo("new RendererContext = " + string);
        }
        this.cleanerObj = new Object();
        if (DO_STATS) {
            this.stats = RendererStats.createInstance(this.cleanerObj, string);
            this.stats.cacheStats = new ArrayCacheConst.CacheStats[]{this.cleanIntCache.stats, this.dirtyIntCache.stats, this.dirtyFloatCache.stats, this.dirtyByteCache.stats};
        } else {
            this.stats = null;
        }
        this.nPCPathIterator = new MarlinRenderingEngine.NormalizingPathIterator.NearestPixelCenter(this.float6);
        this.nPQPathIterator = new MarlinRenderingEngine.NormalizingPathIterator.NearestPixelQuarter(this.float6);
        this.transformerPC2D = new TransformingPathConsumer2D();
        this.cache = new MarlinCache(this);
        this.renderer = new Renderer(this);
        this.ptg = new MarlinTileGenerator(this.renderer);
        this.stroker = new Stroker(this);
        this.dasher = new Dasher(this);
    }

    void dispose() {
        if (DO_STATS) {
            if (this.stats.totalOffHeap > this.stats.totalOffHeapMax) {
                this.stats.totalOffHeapMax = this.stats.totalOffHeap;
            }
            this.stats.totalOffHeap = 0L;
        }
        this.stroking = 0;
        if (this.dirty) {
            this.nPCPathIterator.dispose();
            this.nPQPathIterator.dispose();
            this.dasher.dispose();
            this.stroker.dispose();
            this.dirty = false;
        }
    }

    Path2D.Float getPath2D() {
        Path2D.Float float_;
        Path2D.Float float_2 = float_ = this.refPath2D != null ? (Path2D.Float)this.refPath2D.get() : null;
        if (float_ == null) {
            float_ = new Path2D.Float(1, INITIAL_EDGES_COUNT);
            this.refPath2D = new WeakReference<Path2D.Float>(float_);
        }
        float_.reset();
        return float_;
    }

    OffHeapArray newOffHeapArray(long l) {
        if (DO_STATS) {
            this.stats.totalOffHeapInitial += l;
        }
        return new OffHeapArray(this.cleanerObj, l);
    }

    IntArrayCache.Reference newCleanIntArrayRef(int n) {
        return this.cleanIntCache.createRef(n);
    }

    IntArrayCache.Reference newDirtyIntArrayRef(int n) {
        return this.dirtyIntCache.createRef(n);
    }

    FloatArrayCache.Reference newDirtyFloatArrayRef(int n) {
        return this.dirtyFloatCache.createRef(n);
    }

    ByteArrayCache.Reference newDirtyByteArrayRef(int n) {
        return this.dirtyByteCache.createRef(n);
    }
}

