/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.marlin;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.security.AccessController;
import sun.awt.geom.PathConsumer2D;
import sun.java2d.ReentrantContextProvider;
import sun.java2d.ReentrantContextProviderCLQ;
import sun.java2d.ReentrantContextProviderTL;
import sun.java2d.marlin.FloatMath;
import sun.java2d.marlin.MarlinCache;
import sun.java2d.marlin.MarlinConst;
import sun.java2d.marlin.MarlinProperties;
import sun.java2d.marlin.MarlinTileGenerator;
import sun.java2d.marlin.MarlinUtils;
import sun.java2d.marlin.Renderer;
import sun.java2d.marlin.RendererContext;
import sun.java2d.marlin.TransformingPathConsumer2D;
import sun.java2d.marlin.Version;
import sun.java2d.pipe.AATileGenerator;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.RenderingEngine;
import sun.security.action.GetPropertyAction;

public class MarlinRenderingEngine
extends RenderingEngine
implements MarlinConst {
    private static final float MIN_PEN_SIZE;
    static final float UPPER_BND = 1.7014117E38f;
    static final float LOWER_BND = -1.7014117E38f;
    private static final boolean USE_THREAD_LOCAL;
    static final int REF_TYPE;
    private static final ReentrantContextProvider<RendererContext> RDR_CTX_PROVIDER;
    private static boolean SETTINGS_LOGGED;

    public MarlinRenderingEngine() {
        MarlinRenderingEngine.logSettings(MarlinRenderingEngine.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Shape createStrokedShape(Shape shape, float f, int n, int n2, float f2, float[] fArray, float f3) {
        RendererContext rendererContext = MarlinRenderingEngine.getRendererContext();
        try {
            Path2D.Float float_ = rendererContext.getPath2D();
            this.strokeTo(rendererContext, shape, null, f, NormMode.OFF, n, n2, f2, fArray, f3, rendererContext.transformerPC2D.wrapPath2d(float_));
            Path2D.Float float_2 = new Path2D.Float(float_);
            return float_2;
        }
        finally {
            MarlinRenderingEngine.returnRendererContext(rendererContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void strokeTo(Shape shape, AffineTransform affineTransform, BasicStroke basicStroke, boolean bl, boolean bl2, boolean bl3, PathConsumer2D pathConsumer2D) {
        NormMode normMode = bl2 ? (bl3 ? NormMode.ON_WITH_AA : NormMode.ON_NO_AA) : NormMode.OFF;
        RendererContext rendererContext = MarlinRenderingEngine.getRendererContext();
        try {
            this.strokeTo(rendererContext, shape, affineTransform, basicStroke, bl, normMode, bl3, pathConsumer2D);
        }
        finally {
            MarlinRenderingEngine.returnRendererContext(rendererContext);
        }
    }

    final void strokeTo(RendererContext rendererContext, Shape shape, AffineTransform affineTransform, BasicStroke basicStroke, boolean bl, NormMode normMode, boolean bl2, PathConsumer2D pathConsumer2D) {
        float f = bl ? (bl2 ? this.userSpaceLineWidth(affineTransform, MIN_PEN_SIZE) : this.userSpaceLineWidth(affineTransform, 1.0f)) : basicStroke.getLineWidth();
        this.strokeTo(rendererContext, shape, affineTransform, f, normMode, basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), basicStroke.getDashArray(), basicStroke.getDashPhase(), pathConsumer2D);
    }

    private final float userSpaceLineWidth(AffineTransform affineTransform, float f) {
        float f2;
        if (affineTransform == null) {
            f2 = 1.0f;
        } else if ((affineTransform.getType() & 0x24) != 0) {
            f2 = (float)Math.sqrt(affineTransform.getDeterminant());
        } else {
            double d = affineTransform.getScaleX();
            double d2 = affineTransform.getShearX();
            double d3 = affineTransform.getShearY();
            double d4 = affineTransform.getScaleY();
            double d5 = d * d + d3 * d3;
            double d6 = 2.0 * (d * d2 + d3 * d4);
            double d7 = d2 * d2 + d4 * d4;
            double d8 = Math.sqrt(d6 * d6 + (d5 - d7) * (d5 - d7));
            double d9 = (d5 + d7 + d8) / 2.0;
            f2 = (float)Math.sqrt(d9);
        }
        return f / f2;
    }

    final void strokeTo(RendererContext rendererContext, Shape shape, AffineTransform affineTransform, float f, NormMode normMode, int n, int n2, float f2, float[] fArray, float f3, PathConsumer2D pathConsumer2D) {
        AffineTransform affineTransform2 = null;
        int n3 = -1;
        boolean bl = false;
        if (affineTransform != null && !affineTransform.isIdentity()) {
            double d = affineTransform.getScaleX();
            double d2 = affineTransform.getShearX();
            double d3 = affineTransform.getShearY();
            double d4 = affineTransform.getScaleY();
            double d5 = d * d4 - d3 * d2;
            if (Math.abs(d5) <= (double)2.8E-45f) {
                pathConsumer2D.moveTo(0.0f, 0.0f);
                pathConsumer2D.pathDone();
                return;
            }
            if (MarlinRenderingEngine.nearZero(d * d2 + d3 * d4) && MarlinRenderingEngine.nearZero(d * d + d3 * d3 - (d2 * d2 + d4 * d4))) {
                float f4 = (float)Math.sqrt(d * d + d3 * d3);
                if (fArray != null) {
                    float[] fArray2;
                    bl = true;
                    n3 = fArray.length;
                    if (n3 <= 256) {
                        fArray2 = rendererContext.dasher.dashes_ref.initial;
                    } else {
                        if (DO_STATS) {
                            rendererContext.stats.stat_array_dasher_dasher.add(n3);
                        }
                        fArray2 = rendererContext.dasher.dashes_ref.getArray(n3);
                    }
                    System.arraycopy(fArray, 0, fArray2, 0, n3);
                    fArray = fArray2;
                    int n4 = 0;
                    while (n4 < n3) {
                        int n5 = n4++;
                        fArray[n5] = fArray[n5] * f4;
                    }
                    f3 *= f4;
                }
                f *= f4;
            } else {
                affineTransform2 = affineTransform;
            }
        } else {
            affineTransform = null;
        }
        if (USE_SIMPLIFIER) {
            pathConsumer2D = rendererContext.simplifier.init(pathConsumer2D);
        }
        TransformingPathConsumer2D transformingPathConsumer2D = rendererContext.transformerPC2D;
        pathConsumer2D = transformingPathConsumer2D.deltaTransformConsumer(pathConsumer2D, affineTransform2);
        pathConsumer2D = rendererContext.stroker.init(pathConsumer2D, f, n, n2, f2);
        if (fArray != null) {
            if (!bl) {
                n3 = fArray.length;
            }
            pathConsumer2D = rendererContext.dasher.init(pathConsumer2D, fArray, n3, f3, bl);
        }
        pathConsumer2D = transformingPathConsumer2D.inverseDeltaTransformConsumer(pathConsumer2D, affineTransform2);
        PathIterator pathIterator = normMode.getNormalizingPathIterator(rendererContext, shape.getPathIterator(affineTransform));
        MarlinRenderingEngine.pathTo(rendererContext, pathIterator, pathConsumer2D);
    }

    private static boolean nearZero(double d) {
        return Math.abs(d) < 2.0 * Math.ulp(d);
    }

    private static void pathTo(RendererContext rendererContext, PathIterator pathIterator, PathConsumer2D pathConsumer2D) {
        rendererContext.dirty = true;
        float[] fArray = rendererContext.float6;
        MarlinRenderingEngine.pathToLoop(fArray, pathIterator, pathConsumer2D);
        rendererContext.dirty = false;
    }

    private static void pathToLoop(float[] fArray, PathIterator pathIterator, PathConsumer2D pathConsumer2D) {
        boolean bl = false;
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    if (!(fArray[0] < 1.7014117E38f) || !(fArray[0] > -1.7014117E38f) || !(fArray[1] < 1.7014117E38f) || !(fArray[1] > -1.7014117E38f)) break;
                    pathConsumer2D.moveTo(fArray[0], fArray[1]);
                    bl = true;
                    break;
                }
                case 1: {
                    if (!(fArray[0] < 1.7014117E38f) || !(fArray[0] > -1.7014117E38f) || !(fArray[1] < 1.7014117E38f) || !(fArray[1] > -1.7014117E38f)) break;
                    if (bl) {
                        pathConsumer2D.lineTo(fArray[0], fArray[1]);
                        break;
                    }
                    pathConsumer2D.moveTo(fArray[0], fArray[1]);
                    bl = true;
                    break;
                }
                case 2: {
                    if (!(fArray[2] < 1.7014117E38f) || !(fArray[2] > -1.7014117E38f) || !(fArray[3] < 1.7014117E38f) || !(fArray[3] > -1.7014117E38f)) break;
                    if (bl) {
                        if (fArray[0] < 1.7014117E38f && fArray[0] > -1.7014117E38f && fArray[1] < 1.7014117E38f && fArray[1] > -1.7014117E38f) {
                            pathConsumer2D.quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
                            break;
                        }
                        pathConsumer2D.lineTo(fArray[2], fArray[3]);
                        break;
                    }
                    pathConsumer2D.moveTo(fArray[2], fArray[3]);
                    bl = true;
                    break;
                }
                case 3: {
                    if (!(fArray[4] < 1.7014117E38f) || !(fArray[4] > -1.7014117E38f) || !(fArray[5] < 1.7014117E38f) || !(fArray[5] > -1.7014117E38f)) break;
                    if (bl) {
                        if (fArray[0] < 1.7014117E38f && fArray[0] > -1.7014117E38f && fArray[1] < 1.7014117E38f && fArray[1] > -1.7014117E38f && fArray[2] < 1.7014117E38f && fArray[2] > -1.7014117E38f && fArray[3] < 1.7014117E38f && fArray[3] > -1.7014117E38f) {
                            pathConsumer2D.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                            break;
                        }
                        pathConsumer2D.lineTo(fArray[4], fArray[5]);
                        break;
                    }
                    pathConsumer2D.moveTo(fArray[4], fArray[5]);
                    bl = true;
                    break;
                }
                case 4: {
                    if (!bl) break;
                    pathConsumer2D.closePath();
                    break;
                }
            }
            pathIterator.next();
        }
        pathConsumer2D.pathDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AATileGenerator getAATileGenerator(Shape shape, AffineTransform affineTransform, Region region, BasicStroke basicStroke, boolean bl, boolean bl2, int[] nArray) {
        MarlinTileGenerator marlinTileGenerator = null;
        Renderer renderer = null;
        RendererContext rendererContext = MarlinRenderingEngine.getRendererContext();
        try {
            NormMode normMode;
            AffineTransform affineTransform2 = affineTransform != null && !affineTransform.isIdentity() ? affineTransform : null;
            NormMode normMode2 = normMode = bl2 ? NormMode.ON_WITH_AA : NormMode.OFF;
            if (basicStroke == null) {
                PathIterator pathIterator = normMode.getNormalizingPathIterator(rendererContext, shape.getPathIterator(affineTransform2));
                renderer = rendererContext.renderer.init(region.getLoX(), region.getLoY(), region.getWidth(), region.getHeight(), pathIterator.getWindingRule());
                MarlinRenderingEngine.pathTo(rendererContext, pathIterator, renderer);
            } else {
                renderer = rendererContext.renderer.init(region.getLoX(), region.getLoY(), region.getWidth(), region.getHeight(), 1);
                this.strokeTo(rendererContext, shape, affineTransform2, basicStroke, bl, normMode, true, renderer);
            }
            if (renderer.endRendering()) {
                marlinTileGenerator = rendererContext.ptg.init();
                marlinTileGenerator.getBbox(nArray);
                renderer = null;
            }
        }
        finally {
            if (renderer != null) {
                renderer.dispose();
                MarlinRenderingEngine.returnRendererContext(rendererContext);
            }
        }
        return marlinTileGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final AATileGenerator getAATileGenerator(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, Region region, int[] nArray) {
        double d9;
        double d10;
        double d11;
        double d12;
        boolean bl;
        boolean bl2 = bl = d7 > 0.0 && d8 > 0.0;
        if (bl) {
            d12 = d3 * d7;
            d11 = d4 * d7;
            d10 = d5 * d8;
            d9 = d6 * d8;
            d -= (d12 + d10) / 2.0;
            d2 -= (d11 + d9) / 2.0;
            d3 += d12;
            d4 += d11;
            d5 += d10;
            d6 += d9;
            if (d7 > 1.0 && d8 > 1.0) {
                bl = false;
            }
        } else {
            d9 = 0.0;
            d10 = 0.0;
            d11 = 0.0;
            d12 = 0.0;
        }
        MarlinTileGenerator marlinTileGenerator = null;
        Renderer renderer = null;
        RendererContext rendererContext = MarlinRenderingEngine.getRendererContext();
        try {
            renderer = rendererContext.renderer.init(region.getLoX(), region.getLoY(), region.getWidth(), region.getHeight(), 0);
            renderer.moveTo((float)d, (float)d2);
            renderer.lineTo((float)(d + d3), (float)(d2 + d4));
            renderer.lineTo((float)(d + d3 + d5), (float)(d2 + d4 + d6));
            renderer.lineTo((float)(d + d5), (float)(d2 + d6));
            renderer.closePath();
            if (bl) {
                renderer.moveTo((float)(d += d12 + d10), (float)(d2 += d11 + d9));
                renderer.lineTo((float)(d + (d3 -= 2.0 * d12)), (float)(d2 + (d4 -= 2.0 * d11)));
                renderer.lineTo((float)(d + d3 + (d5 -= 2.0 * d10)), (float)(d2 + d4 + (d6 -= 2.0 * d9)));
                renderer.lineTo((float)(d + d5), (float)(d2 + d6));
                renderer.closePath();
            }
            renderer.pathDone();
            if (renderer.endRendering()) {
                marlinTileGenerator = rendererContext.ptg.init();
                marlinTileGenerator.getBbox(nArray);
                renderer = null;
            }
        }
        finally {
            if (renderer != null) {
                renderer.dispose();
                MarlinRenderingEngine.returnRendererContext(rendererContext);
            }
        }
        return marlinTileGenerator;
    }

    @Override
    public float getMinimumAAPenSize() {
        return MIN_PEN_SIZE;
    }

    private static void logSettings(String string) {
        String string2;
        if (SETTINGS_LOGGED) {
            return;
        }
        SETTINGS_LOGGED = true;
        switch (REF_TYPE) {
            default: {
                string2 = "hard";
                break;
            }
            case 1: {
                string2 = "soft";
                break;
            }
            case 2: {
                string2 = "weak";
            }
        }
        MarlinUtils.logInfo("===============================================================================");
        MarlinUtils.logInfo("Marlin software rasterizer           = ENABLED");
        MarlinUtils.logInfo("Version                              = [" + Version.getVersion() + "]");
        MarlinUtils.logInfo("sun.java2d.renderer                  = " + string);
        MarlinUtils.logInfo("sun.java2d.renderer.useThreadLocal   = " + USE_THREAD_LOCAL);
        MarlinUtils.logInfo("sun.java2d.renderer.useRef           = " + string2);
        MarlinUtils.logInfo("sun.java2d.renderer.edges            = " + MarlinConst.INITIAL_EDGES_COUNT);
        MarlinUtils.logInfo("sun.java2d.renderer.pixelsize        = " + MarlinConst.INITIAL_PIXEL_DIM);
        MarlinUtils.logInfo("sun.java2d.renderer.subPixel_log2_X  = " + MarlinConst.SUBPIXEL_LG_POSITIONS_X);
        MarlinUtils.logInfo("sun.java2d.renderer.subPixel_log2_Y  = " + MarlinConst.SUBPIXEL_LG_POSITIONS_Y);
        MarlinUtils.logInfo("sun.java2d.renderer.tileSize_log2    = " + MarlinConst.TILE_SIZE_LG);
        MarlinUtils.logInfo("sun.java2d.renderer.blockSize_log2   = " + MarlinConst.BLOCK_SIZE_LG);
        MarlinUtils.logInfo("sun.java2d.renderer.blockSize_log2   = " + MarlinConst.BLOCK_SIZE_LG);
        MarlinUtils.logInfo("sun.java2d.renderer.forceRLE         = " + MarlinProperties.isForceRLE());
        MarlinUtils.logInfo("sun.java2d.renderer.forceNoRLE       = " + MarlinProperties.isForceNoRLE());
        MarlinUtils.logInfo("sun.java2d.renderer.useTileFlags     = " + MarlinProperties.isUseTileFlags());
        MarlinUtils.logInfo("sun.java2d.renderer.useTileFlags.useHeuristics = " + MarlinProperties.isUseTileFlagsWithHeuristics());
        MarlinUtils.logInfo("sun.java2d.renderer.rleMinWidth      = " + MarlinCache.RLE_MIN_WIDTH);
        MarlinUtils.logInfo("sun.java2d.renderer.useSimplifier    = " + MarlinConst.USE_SIMPLIFIER);
        MarlinUtils.logInfo("sun.java2d.renderer.doStats          = " + MarlinConst.DO_STATS);
        MarlinUtils.logInfo("sun.java2d.renderer.doMonitors       = false");
        MarlinUtils.logInfo("sun.java2d.renderer.doChecks         = " + MarlinConst.DO_CHECKS);
        MarlinUtils.logInfo("sun.java2d.renderer.useLogger        = " + MarlinConst.USE_LOGGER);
        MarlinUtils.logInfo("sun.java2d.renderer.logCreateContext = " + MarlinConst.LOG_CREATE_CONTEXT);
        MarlinUtils.logInfo("sun.java2d.renderer.logUnsafeMalloc  = " + MarlinConst.LOG_UNSAFE_MALLOC);
        MarlinUtils.logInfo("Renderer settings:");
        MarlinUtils.logInfo("CUB_COUNT_LG = 2");
        MarlinUtils.logInfo("CUB_DEC_BND  = " + Renderer.CUB_DEC_BND);
        MarlinUtils.logInfo("CUB_INC_BND  = " + Renderer.CUB_INC_BND);
        MarlinUtils.logInfo("QUAD_DEC_BND = " + Renderer.QUAD_DEC_BND);
        MarlinUtils.logInfo("INITIAL_EDGES_CAPACITY               = " + MarlinConst.INITIAL_EDGES_CAPACITY);
        MarlinUtils.logInfo("INITIAL_CROSSING_COUNT               = " + Renderer.INITIAL_CROSSING_COUNT);
        MarlinUtils.logInfo("===============================================================================");
    }

    static RendererContext getRendererContext() {
        RendererContext rendererContext = RDR_CTX_PROVIDER.acquire();
        return rendererContext;
    }

    static void returnRendererContext(RendererContext rendererContext) {
        rendererContext.dispose();
        RDR_CTX_PROVIDER.release(rendererContext);
    }

    static {
        String string;
        MIN_PEN_SIZE = 1.0f / NORM_SUBPIXELS;
        USE_THREAD_LOCAL = MarlinProperties.isUseThreadLocal();
        switch (string = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.renderer.useRef", "soft"))) {
            default: {
                REF_TYPE = 1;
                break;
            }
            case "weak": {
                REF_TYPE = 2;
                break;
            }
            case "hard": {
                REF_TYPE = 0;
            }
        }
        RDR_CTX_PROVIDER = USE_THREAD_LOCAL ? new ReentrantContextProviderTL<RendererContext>(REF_TYPE){

            @Override
            protected RendererContext newContext() {
                return RendererContext.createContext();
            }
        } : new ReentrantContextProviderCLQ<RendererContext>(REF_TYPE){

            @Override
            protected RendererContext newContext() {
                return RendererContext.createContext();
            }
        };
        SETTINGS_LOGGED = !ENABLE_LOGS;
    }

    static abstract class NormalizingPathIterator
    implements PathIterator {
        private PathIterator src;
        private float curx_adjust;
        private float cury_adjust;
        private float movx_adjust;
        private float movy_adjust;
        private final float[] tmp;

        NormalizingPathIterator(float[] fArray) {
            this.tmp = fArray;
        }

        final NormalizingPathIterator init(PathIterator pathIterator) {
            this.src = pathIterator;
            return this;
        }

        final void dispose() {
            this.src = null;
        }

        @Override
        public final int currentSegment(float[] fArray) {
            float f;
            float f2;
            int n;
            int n2 = this.src.currentSegment(fArray);
            switch (n2) {
                case 0: 
                case 1: {
                    n = 0;
                    break;
                }
                case 2: {
                    n = 2;
                    break;
                }
                case 3: {
                    n = 4;
                    break;
                }
                case 4: {
                    this.curx_adjust = this.movx_adjust;
                    this.cury_adjust = this.movy_adjust;
                    return n2;
                }
                default: {
                    throw new InternalError("Unrecognized curve type");
                }
            }
            float f3 = fArray[n];
            fArray[n] = f2 = this.normCoord(f3);
            f2 -= f3;
            f3 = fArray[n + 1];
            fArray[n + 1] = f = this.normCoord(f3);
            f -= f3;
            switch (n2) {
                case 0: {
                    this.movx_adjust = f2;
                    this.movy_adjust = f;
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    fArray[0] = fArray[0] + (this.curx_adjust + f2) / 2.0f;
                    fArray[1] = fArray[1] + (this.cury_adjust + f) / 2.0f;
                    break;
                }
                case 3: {
                    fArray[0] = fArray[0] + this.curx_adjust;
                    fArray[1] = fArray[1] + this.cury_adjust;
                    fArray[2] = fArray[2] + f2;
                    fArray[3] = fArray[3] + f;
                    break;
                }
            }
            this.curx_adjust = f2;
            this.cury_adjust = f;
            return n2;
        }

        abstract float normCoord(float var1);

        @Override
        public final int currentSegment(double[] dArray) {
            float[] fArray = this.tmp;
            int n = this.currentSegment(fArray);
            for (int i = 0; i < 6; ++i) {
                dArray[i] = fArray[i];
            }
            return n;
        }

        @Override
        public final int getWindingRule() {
            return this.src.getWindingRule();
        }

        @Override
        public final boolean isDone() {
            if (this.src.isDone()) {
                this.dispose();
                return true;
            }
            return false;
        }

        @Override
        public final void next() {
            this.src.next();
        }

        static final class NearestPixelQuarter
        extends NormalizingPathIterator {
            NearestPixelQuarter(float[] fArray) {
                super(fArray);
            }

            @Override
            float normCoord(float f) {
                return FloatMath.floor_f(f + 0.25f) + 0.25f;
            }
        }

        static final class NearestPixelCenter
        extends NormalizingPathIterator {
            NearestPixelCenter(float[] fArray) {
                super(fArray);
            }

            @Override
            float normCoord(float f) {
                return FloatMath.floor_f(f) + 0.5f;
            }
        }
    }

    private static enum NormMode {
        ON_WITH_AA{

            @Override
            PathIterator getNormalizingPathIterator(RendererContext rendererContext, PathIterator pathIterator) {
                return rendererContext.nPCPathIterator.init(pathIterator);
            }
        }
        ,
        ON_NO_AA{

            @Override
            PathIterator getNormalizingPathIterator(RendererContext rendererContext, PathIterator pathIterator) {
                return rendererContext.nPQPathIterator.init(pathIterator);
            }
        }
        ,
        OFF{

            @Override
            PathIterator getNormalizingPathIterator(RendererContext rendererContext, PathIterator pathIterator) {
                return pathIterator;
            }
        };


        abstract PathIterator getNormalizingPathIterator(RendererContext var1, PathIterator var2);
    }
}

