/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.marlin;

import java.security.AccessController;
import sun.java2d.marlin.FloatMath;
import sun.java2d.marlin.MarlinUtils;
import sun.security.action.GetPropertyAction;

public final class MarlinProperties {
    private MarlinProperties() {
    }

    public static boolean isUseThreadLocal() {
        return MarlinProperties.getBoolean("sun.java2d.renderer.useThreadLocal", "true");
    }

    public static int getInitialEdges() {
        return MarlinProperties.align(MarlinProperties.getInteger("sun.java2d.renderer.edges", 4096, 64, 65536), 64);
    }

    public static int getInitialImageSize() {
        return MarlinProperties.align(MarlinProperties.getInteger("sun.java2d.renderer.pixelsize", 2048, 64, 32768), 64);
    }

    public static int getSubPixel_Log2_X() {
        return MarlinProperties.getInteger("sun.java2d.renderer.subPixel_log2_X", 3, 1, 8);
    }

    public static int getSubPixel_Log2_Y() {
        return MarlinProperties.getInteger("sun.java2d.renderer.subPixel_log2_Y", 3, 1, 8);
    }

    public static int getTileSize_Log2() {
        return MarlinProperties.getInteger("sun.java2d.renderer.tileSize_log2", 5, 3, 8);
    }

    public static int getBlockSize_Log2() {
        return MarlinProperties.getInteger("sun.java2d.renderer.blockSize_log2", 5, 3, 8);
    }

    public static boolean isForceRLE() {
        return MarlinProperties.getBoolean("sun.java2d.renderer.forceRLE", "false");
    }

    public static boolean isForceNoRLE() {
        return MarlinProperties.getBoolean("sun.java2d.renderer.forceNoRLE", "false");
    }

    public static boolean isUseTileFlags() {
        return MarlinProperties.getBoolean("sun.java2d.renderer.useTileFlags", "true");
    }

    public static boolean isUseTileFlagsWithHeuristics() {
        return MarlinProperties.isUseTileFlags() && MarlinProperties.getBoolean("sun.java2d.renderer.useTileFlags.useHeuristics", "true");
    }

    public static int getRLEMinWidth() {
        return MarlinProperties.getInteger("sun.java2d.renderer.rleMinWidth", 64, 0, Integer.MAX_VALUE);
    }

    public static boolean isUseSimplifier() {
        return MarlinProperties.getBoolean("sun.java2d.renderer.useSimplifier", "false");
    }

    public static boolean isDoStats() {
        return MarlinProperties.getBoolean("sun.java2d.renderer.doStats", "false");
    }

    public static boolean isDoMonitors() {
        return MarlinProperties.getBoolean("sun.java2d.renderer.doMonitors", "false");
    }

    public static boolean isDoChecks() {
        return MarlinProperties.getBoolean("sun.java2d.renderer.doChecks", "false");
    }

    public static boolean isLoggingEnabled() {
        return MarlinProperties.getBoolean("sun.java2d.renderer.log", "false");
    }

    public static boolean isUseLogger() {
        return MarlinProperties.getBoolean("sun.java2d.renderer.useLogger", "false");
    }

    public static boolean isLogCreateContext() {
        return MarlinProperties.getBoolean("sun.java2d.renderer.logCreateContext", "false");
    }

    public static boolean isLogUnsafeMalloc() {
        return MarlinProperties.getBoolean("sun.java2d.renderer.logUnsafeMalloc", "false");
    }

    static boolean getBoolean(String string, String string2) {
        return Boolean.valueOf(AccessController.doPrivileged(new GetPropertyAction(string, string2)));
    }

    static int getInteger(String string, int n, int n2, int n3) {
        String string2 = AccessController.doPrivileged(new GetPropertyAction(string));
        int n4 = n;
        if (string2 != null) {
            try {
                n4 = Integer.decode(string2);
            }
            catch (NumberFormatException numberFormatException) {
                MarlinUtils.logInfo("Invalid integer value for " + string + " = " + string2);
            }
        }
        if (n4 < n2 || n4 > n3) {
            MarlinUtils.logInfo("Invalid value for " + string + " = " + n4 + "; expected value in range[" + n2 + ", " + n3 + "] !");
            n4 = n;
        }
        return n4;
    }

    static int align(int n, int n2) {
        int n3 = FloatMath.ceil_int((float)n / (float)n2);
        return n3 * n2;
    }
}

