#  tests for opencv-3.4.4-py37hb76ac4c_1204 (this is a generated file);
print('===== testing package: opencv-3.4.4-py37hb76ac4c_1204 =====');
print('running run_test.py');
#  --- run_test.py (begin) ---
import unittest
import tempfile
import os.path as op
import platform
import shutil
import requests
import cv2


OPENCV_AVI_URL = 'https://github.com/opencv/opencv_extra/raw/master/testdata/highgui/video/VID00003-20100701-2204.avi'


@unittest.skipIf(platform.system() == 'Windows',
                 'FFMPEG currently not built on Windows')
class TestVideoRead(unittest.TestCase):

    @classmethod
    def setUpClass(cls):
        cls.temp_dir = tempfile.mkdtemp()
        cls.avi_path = op.join(cls.temp_dir, 'test.avi')
        req = requests.get(OPENCV_AVI_URL, stream=True)
        with open(cls.avi_path, 'wb') as f:
            shutil.copyfileobj(req.raw, f)

    @classmethod
    def tearDownClass(cls):
        shutil.rmtree(cls.avi_path, ignore_errors=True)

    def test_load_avi(self):
        cap = cv2.VideoCapture(self.avi_path)
        assert cap.read()[0]


if __name__ == '__main__':
    unittest.main()
#  --- run_test.py (end) ---

print('===== opencv-3.4.4-py37hb76ac4c_1204 OK =====');
print("import: 'cv2'")
import cv2

print("import: 'cv2.xfeatures2d'")
import cv2.xfeatures2d

