#  tests for openbabel-3.1.1-py39hfc62d72_3 (this is a generated file);
print('===== testing package: openbabel-3.1.1-py39hfc62d72_3 =====');
print('running run_test.py');
#  --- run_test.py (begin) ---
import subprocess
from sys import stderr

mol2_res = subprocess.run(
    ["obabel", "-:c1ccccc1", "--gen3d", "-omol2"],
    stdout=subprocess.PIPE,
    stderr=subprocess.PIPE,
    encoding="utf8",
)
mol2_success = "1 molecule converted" in mol2_res.stderr

inchi_res = subprocess.run(
    ["obabel", "-:c1ccccc1", "-oinchi"],
    stdout=subprocess.PIPE,
    stderr=subprocess.PIPE,
    encoding="utf8",
)
inchi_success = "1 molecule converted" in inchi_res.stderr
inchi_success = inchi_success and ("InChI=1S" in inchi_res.stdout)

png_res = subprocess.run(
    ["obabel", "-:c1ccccc1", "-opng"], stdout=subprocess.PIPE, stderr=subprocess.PIPE
)
png_success = "1 molecule converted" in str(png_res.stderr)
png_success = png_success and (png_res.stdout[:4] == b"\x89PNG")

logp_res = subprocess.run(
    ["obabel", "-:c1ccccc1", "-osmi", "-xt", "--append", "logP"],
    stdout=subprocess.PIPE,
    stderr=subprocess.PIPE,
    encoding="utf8",
)
logp_success = "Could not find contribution data file" not in logp_res.stderr

if not mol2_success:
    print("Failed converting SMILES to mol2 format", file=stderr)
if not inchi_success:
    print("Failed converting SMILES to InChI format", file=stderr)
if not png_success:
    print("Failed converting SMILES to png format", file=stderr)
if not logp_success:
    print("Failed to find data files", file=stderr)
if not (mol2_success and inchi_success and png_success and logp_success):
    raise RuntimeError("Tests failed, see stderr")
#  --- run_test.py (end) ---

print('===== openbabel-3.1.1-py39hfc62d72_3 OK =====');
print("import: 'openbabel.openbabel'")
import openbabel.openbabel

print("import: 'openbabel.pybel'")
import openbabel.pybel

