#!/bin/bash
if [ `uname` == Linux ]; then
    CMAKE_SHARED_LINKER_FLAGS_INIT='-pthread -lrt -lutil'
fi

PYTHON_INCLUDE_DIR=$($PYTHON -c 'import distutils.sysconfig, sys; sys.stdout.write(distutils.sysconfig.get_python_inc())')
PYTHON_LIBRARY=$($PYTHON -c 'from distutils.sysconfig import get_config_var; import os, sys; sys.stdout.write(os.path.join(get_config_var("LIBDIR"),get_config_var("LDLIBRARY")))')

cmake -DCMAKE_INSTALL_PREFIX=$PREFIX \
      -DCMAKE_BUILD_TYPE=RELEASE \
      -DWITH_INCHI=ON \
      -DPYTHON_LIBRARY=$PYTHON_LIBRARY \
      -DPYTHON_EXECUTABLE=$PYTHON \
      -DPYTHON_INCLUDE_DIR=$PYTHON_INCLUDE_DIR \
      -DPYTHON_BINDINGS=ON \
      -DLIBXML2_INCLUDE_DIR=$PREFIX/include \
      -DLIBXML2_LIBRARIES=$PREFIX/lib/libxml2${SHLIB_EXT} \
      -DZLIB_INCLUDE_DIR=$PREFIX/include \
      -DZLIB_LIBRARY=$PREFIX/lib/libz${SHLIB_EXT} \
      -DRUN_SWIG=ON \
      -DCMAKE_SHARED_LINKER_FLAGS_INIT="$CMAKE_SHARED_LINKER_FLAGS_INIT"


make -j${CPU_COUNT}
make install
