/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef UA_CONFIG_H_
#define UA_CONFIG_H_

/**
 * open62541 Version
 * ----------------- */
#define UA_OPEN62541_VER_MAJOR 1
#define UA_OPEN62541_VER_MINOR 2
#define UA_OPEN62541_VER_PATCH 4
#define UA_OPEN62541_VER_LABEL "" /* Release candidate label, etc. */
#define UA_OPEN62541_VER_COMMIT "v1.2.4"

/**
 * Feature Options
 * ---------------
 * Changing the feature options has no effect on a pre-compiled library. */

#define UA_LOGLEVEL 300
#ifndef UA_ENABLE_AMALGAMATION
/* #undef UA_ENABLE_AMALGAMATION */
#endif
#define UA_ENABLE_METHODCALLS
#define UA_ENABLE_NODEMANAGEMENT
#define UA_ENABLE_SUBSCRIPTIONS
/* #undef UA_ENABLE_PUBSUB */
/* #undef UA_ENABLE_PUBSUB_FILE_CONFIG */
/* #undef UA_ENABLE_PUBSUB_ETH_UADP */
/* #undef UA_ENABLE_PUBSUB_ETH_UADP_ETF */
/* #undef UA_ENABLE_PUBSUB_ETH_UADP_XDP */
/* #undef UA_ENABLE_PUBSUB_DELTAFRAMES */
/* #undef UA_ENABLE_PUBSUB_INFORMATIONMODEL */
/* #undef UA_ENABLE_PUBSUB_INFORMATIONMODEL_METHODS */
#define UA_ENABLE_DA
#define UA_ENABLE_ENCRYPTION
#define UA_ENABLE_HISTORIZING
#define UA_ENABLE_PARSING
/* #undef UA_ENABLE_MICRO_EMB_DEV_PROFILE */
/* #undef UA_ENABLE_EXPERIMENTAL_HISTORIZING */
/* #undef UA_ENABLE_SUBSCRIPTIONS_EVENTS */
/* #undef UA_ENABLE_JSON_ENCODING */
/* #undef UA_ENABLE_PUBSUB_MQTT */
/* #undef UA_ENABLE_ENCRYPTION_MBEDTLS */
#define UA_ENABLE_ENCRYPTION_OPENSSL
/* #undef UA_ENABLE_SUBSCRIPTIONS_ALARMS_CONDITIONS */

/* Multithreading */
/* #undef UA_ENABLE_IMMUTABLE_NODES */
#define UA_MULTITHREADING 0

/* Advanced Options */
#define UA_ENABLE_STATUSCODE_DESCRIPTIONS
#define UA_ENABLE_TYPEDESCRIPTION
#define UA_ENABLE_NODESET_COMPILER_DESCRIPTIONS
/* #undef UA_ENABLE_DETERMINISTIC_RNG */
/* #undef UA_ENABLE_DISCOVERY */
/* #undef UA_ENABLE_DISCOVERY_MULTICAST */
/* #undef UA_ENABLE_WEBSOCKET_SERVER */
/* #undef UA_ENABLE_QUERY */
/* #undef UA_ENABLE_MALLOC_SINGLETON */
#define UA_ENABLE_DISCOVERY_SEMAPHORE
/* #undef UA_ENABLE_UNIT_TEST_FAILURE_HOOKS */
/* #undef UA_ENABLE_VALGRIND_INTERACTIVE */
#define UA_VALGRIND_INTERACTIVE_INTERVAL 1000
#define UA_GENERATED_NAMESPACE_ZERO
/* #undef UA_GENERATED_NAMESPACE_ZERO_FULL */
/* #undef UA_ENABLE_PUBSUB_MONITORING */

/* #undef UA_PACK_DEBIAN */

/* Options for Debugging */
/* #undef UA_DEBUG */
/* #undef UA_DEBUG_DUMP_PKGS */

/**
 * Function Export
 * ---------------
 * On Win32: Define ``UA_DYNAMIC_LINKING`` and ``UA_DYNAMIC_LINKING_EXPORT`` in
 * order to export symbols for a DLL. Define ``UA_DYNAMIC_LINKING`` only to
 * import symbols from a DLL.*/
#define UA_DYNAMIC_LINKING

/* Shortcuts for extern "C" declarations */
#if !defined(_UA_BEGIN_DECLS)
# ifdef __cplusplus
#  define _UA_BEGIN_DECLS extern "C" {
# else
#  define _UA_BEGIN_DECLS
# endif
#endif
#if !defined(_UA_END_DECLS)
# ifdef __cplusplus
#  define _UA_END_DECLS }
# else
#  define _UA_END_DECLS
# endif
#endif

/* Select default architecture if non is selected through CMake or compiler define */
#if 1  && !defined(UA_ARCHITECTURE_ECOS) && !defined(UA_ARCHITECTURE_FREERTOSLWIP) && !defined(UA_ARCHITECTURE_POSIX) && !defined(UA_ARCHITECTURE_VXWORKS) && !defined(UA_ARCHITECTURE_WEC7) && !defined(UA_ARCHITECTURE_WIN32)
# ifdef _WIN32
#  define UA_ARCHITECTURE_WIN32
# else
#  define UA_ARCHITECTURE_POSIX
# endif
#endif

// specific architectures can undef this
#define UA_HAS_GETIFADDR

#include "win32/ua_architecture.h"

#endif /* UA_CONFIG_H_ */
