# -*- coding: utf-8 -*-

from opbeat.transport.exceptions import InvalidScheme


class TransportException(Exception):
    def __init__(self, message, data=None, print_trace=True):
        super(TransportException, self).__init__(message)
        self.data = data
        self.print_trace = print_trace


class Transport(object):
    """
    All transport implementations need to subclass this class

    You must implement a send method..
    """
    async_mode = False
    scheme = []

    def check_scheme(self, url):
        if url.scheme not in self.scheme:
            raise InvalidScheme()

    def send(self, data, headers):
        """
        You need to override this to do something with the actual
        data. Usually - this is sending to a server
        """
        raise NotImplementedError

    def close(self):
        """
        Cleans up resources and closes connection
        :return:
        """
        pass


class AsyncTransport(Transport):
    async_mode = True

    def send_async(self, data, headers, success_callback=None, fail_callback=None):
        raise NotImplementedError
