try:
    import urlparse
except ImportError:
    import urllib.parse as urlparse

from opbeat.utils.wsgi import get_environ, get_headers


def get_data_from_request(request):
    urlparts = urlparse.urlsplit(request.url)

    return {
        'http': {
            'url': '%s://%s%s' % (urlparts.scheme, urlparts.netloc, urlparts.path),
            'query_string': urlparts.query,
            'method': request.method,
            'data': request.form,
            'headers': dict(get_headers(request.environ)),
            'env': dict(get_environ(request.environ)),
        }
    }
