/* FILE: xpport.h             -*-Mode: c++-*-
 *
 * Platform specific #define's and typedef's for Xp extension,
 * generated by build_port.
 *
 * This is a machine-generated file.  DO NOT EDIT!
 *
 * This file based on compiler command:
 *   Platform CompileCmd C++ -valuesafeopt 1 -inc D:/bld/oommf_1649683620814/work/oommf/pkg/xp -def XP_USE_MPFR=0   -out build_port -src build_port.cc
 */

#ifndef _XP_PORT_H
#define _XP_PORT_H

#include <cassert>
#include <cfloat>
#include <cmath>
#include <cstdio>
#include <cstdlib>
#include <string>
#include <limits>

#define XP_USE_ALT_DOUBLEDOUBLE 0
#define XP_FLT_RADIX 2
#define XP_HAVE_COPYSIGN 1
#define XP_USE_FMA 1

// Floating point type information:
//  XP_DDFLOAT_MANTISSA_PRECISION is XP_DDFLOAT mantissa width in bits
//  XP_DDFLOAT_DECIMAL_DIGITS is C macro DECIMAL_DIG value for XP_DDFLOAT
//  XP_DDFLOAT_HUGE_EXP is smallest n such that 2^n is not finite
//  XP_DDFLOAT_TINY_EXP is smallest n such that 2^n is normal
//  XP_DDFLOAT_VERYTINY_EXP is smallest n such that 2^n is non-zero
//   Note: If gradual underflow is not supported then tiny == verytiny
//  XP_DDFLOAT_MAX is largest finite value
//  XP_DDFLOAT_MIN is smallest positive normal value
//  XP_DDFLOAT_CUBEROOT_VERYTINY is XP_DDFLOAT_VERYTINY^(1/3)
//  XP_DDFLOAT_VERYTINY is smallest positive value (denormal)
//  XP_DDFLOAT_POW_2_MANTISSA is pow(2,mantissa precision)
//  XP_DDFLOAT_POW_2_MANTISSAHALF is pow(2,(mantissa precision+1)/2)
//  XP_DDFLOAT_EPSILON is ULP(1), i.e., 2^(1-mantissa_precision)
#define XP_FLOAT_TYPE 1
#define XP_DOUBLE_TYPE 2
#define XP_LONGDOUBLE_TYPE 3
#define XP_MPFR_TYPE 4
#define XP_USE_FLOAT_TYPE XP_DOUBLE_TYPE
#define XP_USE_FLOAT_TYPE_INFO "double"
typedef double XP_DDFLOAT_TYPE;

#define XP_DDFLOAT_MANTISSA_PRECISION 53
#define XP_DDFLOAT_DECIMAL_DIGITS 17
#define XP_DDFLOAT_HUGE_EXP 1024
#define XP_DDFLOAT_TINY_EXP -1022
#define XP_DDFLOAT_VERYTINY_EXP -1074
#define XP_DDFLOAT_MAX 1.7976931348623157e+308
#define XP_DDFLOAT_MIN 2.2250738585072014e-308
#define XP_DDFLOAT_CUBEROOT_VERYTINY 1.7031839360032603e-108
#define XP_DDFLOAT_VERYTINY 4.9406564584124654e-324
#define XP_DDFLOAT_POW_2_MANTISSA 9.0071992547409920e+15
#define XP_DDFLOAT_POW_2_MANTISSAHALF 1.3421772800000000e+08
#define XP_DDFLOAT_EPSILON 2.2204460492503131e-16

// Special constants for Xp_DoubleDouble class
// XP_DD_TINY is smallest non-denormal double-double.
// XP_DD_SPLITMAX is a lower bound on the largest import to
//   ::Split that won't overflow.
#define XP_DD_TINY 4.0083367200179456e-292
#define XP_DD_SPLITMAX 6.6969287949141708e+299
#define XP_DD_EPS 1.2325951644078309e-32
#define XP_DD_SQRT_EPS 1.1102230246251565e-16
#define XP_DD_4RT_EPS 1.0536712127723509e-08

// Wrappers for frexp, floor and ceil
inline XP_DDFLOAT_TYPE XP_FREXP(XP_DDFLOAT_TYPE x,int* exp)
 { return std::frexp(x,exp); }
inline XP_DDFLOAT_TYPE XP_FLOOR(XP_DDFLOAT_TYPE x)
 { return std::floor(x); }
inline XP_DDFLOAT_TYPE XP_CEIL(XP_DDFLOAT_TYPE x)
 { return std::ceil(x); }

// Infinity, NaN support
const XP_DDFLOAT_TYPE XP_INFINITY =
 std::numeric_limits<double>::infinity();
const XP_DDFLOAT_TYPE XP_NAN =
 std::numeric_limits<double>::quiet_NaN();

#endif // _XP_PORT_H
