/* FILE: scriptscalarfield.h      -*-Mode: c++-*-
 *
 * Tcl script scalar field object, derived from Oxs_ScalarField
 * class.
 *
 */

#ifndef _OXS_SCRIPTSCALARFIELD
#define _OXS_SCRIPTSCALARFIELD

#include <vector>

#include "oc.h"
#include "nb.h"

#include "scalarfield.h"
#include "threevector.h"
#include "vectorfield.h"

OC_USE_STD_NAMESPACE;

/* End includes */

class Oxs_ScriptScalarField:public Oxs_ScalarField {
private:
  OC_REAL8m multiplier;
  Oxs_ThreeVector basept;
  Oxs_ThreeVector scale;
  Nb_ArrayWrapper< Oxs_OwnedPointer<Oxs_ScalarField> > scalarfields;
  Nb_ArrayWrapper< Oxs_OwnedPointer<Oxs_VectorField> > vectorfields;
  vector<Nb_TclCommandLineOption> command_options;
  Nb_TclCommand cmd;
public:
  virtual const char* ClassName() const; // ClassName() is
  /// automatically generated by the OXS_EXT_REGISTER macro.

  Oxs_ScriptScalarField
  (const char* name,     // Child instance id
   Oxs_Director* newdtr, // App director
   const char* argstr);  // MIF input block parameters

  virtual ~Oxs_ScriptScalarField();

  virtual OC_REAL8m Value(const ThreeVector& pt) const;

  virtual void FillMeshValue(const Oxs_Mesh* mesh,
			     Oxs_MeshValue<OC_REAL8m>& array) const;
  virtual void IncrMeshValue(const Oxs_Mesh* mesh,
			     Oxs_MeshValue<OC_REAL8m>& array) const;
  virtual void MultMeshValue(const Oxs_Mesh* mesh,
			     Oxs_MeshValue<OC_REAL8m>& array) const;
};


#endif // _OXS_SCRIPTSCALARFIELD
