/* FILE: yy_fixedmel.h            -*-Mode: c++-*-
 *
 * OOMMF magnetoelastic coupling extension module.
 * YY_FixedMEL class.
 * Calculates fixed MEL field/energy for a simulation.
 *
 * Release ver. 1.0.1 (2015-03-03)
 * 
 */

#ifndef _OXS_FIXEDMEL
#define _OXS_FIXEDMEL

#include "oc.h"
#include "director.h"
#include "threevector.h"
#include "energy.h"
#include "simstate.h"
#include "mesh.h"
#include "meshvalue.h"
#include "vectorfield.h"
#include "scalarfield.h"

#include "yy_mel_util.h"

/* End includes */

class YY_FixedMEL : public Oxs_Energy {
private:
  // magnetoelastic coefficient MELCoef1,2 = B1,2 (J/m^3)
  Oxs_OwnedPointer<Oxs_ScalarField> MELCoef1_init, MELCoef2_init;
  mutable YY_MELField MELField;

  mutable OC_UINT4m mesh_id;
  OC_REAL8m field_mult;
  Oxs_OwnedPointer<Oxs_VectorField> fixedu_init;          // displacement
  Oxs_OwnedPointer<Oxs_VectorField> fixede_diag_init;     // strain diagonal
  Oxs_OwnedPointer<Oxs_VectorField> fixede_offdiag_init;  // strain offdiagonal
  mutable ThreeVector max_field;

  // Member function to determine the way of specifying
  // strain. Whether directly using strain or indirectly by
  // specifying displacement and calculating strain with it.
  // It sets use_u and use_e (== !use_u).
  void SelectElasticityInputType();
  OC_BOOL use_u, use_e;

protected:
  virtual void GetEnergy(const Oxs_SimState& state,
			 Oxs_EnergyData& oed) const;

public:
  virtual const char* ClassName() const; // ClassName() is
  /// automatically generated by the OXS_EXT_REGISTER macro.
  YY_FixedMEL(const char* name,  // Child instance id
		  Oxs_Director* newdtr, // App director
		  const char* argstr);  // MIF input block parameters

  virtual ~YY_FixedMEL() {}
  virtual OC_BOOL Init();
};

#endif // _YY_FIXEDMEL
