/* FILE: DMI_C2v.h            -*-Mode: c++-*-
 *
 * Dzyaloshinskii-Moriya energy for the C2v crystallographic class [1]:
 *
 * $w_\text{dmi} = Dx L_{xz}^{(x)} + Dy L_{yz}^{(y)}
 *
 * This extension works both with and without periodic boundary conditions.
 *
 * Extension and modification by Dmitry Tatarskiy (Institute of physics for microstructres RAS, Russia) of Oxs_DMexchange6ngbr.h [2].
 *
 * Developed as a part of RSCF project
 *
 *
 * [1] A. N. Bogdanov and D. A. Yablonskii. Zh. Eksp. Teor. Fiz. 95, 178-182 (1989).
 * [2] Rohart, S., & Thiaville, A. Physical Review B, 88, 184422 (2013).
 *
 */

#ifndef _OXS_DMI_C2V
#define _OXS_DMI_C2V

#include "atlas.h"
#include "key.h"
#include "energy.h"
#include "mesh.h"
#include "meshvalue.h"
#include "simstate.h"
#include "threevector.h"
#include "rectangularmesh.h"

/* End includes */

class Oxs_DMI_C2v:public Oxs_Energy {
private:
  OC_INT4m A_size;
  OC_REAL8m** Dx;
  OC_REAL8m** Dy;  
  Oxs_Key<Oxs_Atlas> atlaskey;  
  Oxs_OwnedPointer<Oxs_Atlas> atlas;
  mutable OC_INT4m mesh_id;
  mutable Oxs_MeshValue<OC_INT4m> region_id;

  // Periodic boundaries?
  mutable int xperiodic;
  mutable int yperiodic;
  mutable int zperiodic;

protected:
  virtual void GetEnergy(const Oxs_SimState& state,
			 Oxs_EnergyData& oed) const;

public:
  virtual const char* ClassName() const; // ClassName() is
  /// automatically generated by the OXS_EXT_REGISTER macro.
  Oxs_DMI_C2v(const char* name,     // Child instance id
		    Oxs_Director* newdtr, // App director
		    const char* argstr);  // MIF input block parameters
  virtual ~Oxs_DMI_C2v();
  virtual OC_BOOL Init();
};


#endif // _OXS_DMI_C2V
