/* FILE: scriptorientvectorfield.h      -*-Mode: c++-*-
 *
 * Vector field object, derived from Oxs_VectorField class,
 * that applies an script orientation (pre-)transformation
 * to another vector field object.
 *
 */

#ifndef _OXS_SCRIPTORIENTVECTORFIELD
#define _OXS_SCRIPTORIENTVECTORFIELD

#include <vector>

#include "oc.h"
#include "nb.h"

#include "threevector.h"
#include "util.h"
#include "vectorfield.h"

OC_USE_STD_NAMESPACE;

/* End includes */

class Oxs_ScriptOrientVectorField:public Oxs_VectorField {
private:
  Oxs_ThreeVector basept;
  Oxs_ThreeVector scale;
  vector<Nb_TclCommandLineOption> command_options;
  Nb_TclCommand cmd;
  Oxs_OwnedPointer<Oxs_VectorField> field;
public:
  virtual const char* ClassName() const; // ClassName() is
  /// automatically generated by the OXS_EXT_REGISTER macro.

  Oxs_ScriptOrientVectorField
  (const char* name,     // Child instance id
   Oxs_Director* newdtr, // App director
   const char* argstr);  // MIF input block parameters

  virtual ~Oxs_ScriptOrientVectorField();

  virtual void Value(const ThreeVector& pt,ThreeVector& value) const;

  virtual void FillMeshValue(const Oxs_Mesh* mesh,
			     Oxs_MeshValue<ThreeVector>& array) const;
};


#endif // _OXS_SCRIPTORIENTVECTORFIELD
