/* FILE: scriptorientscalarfield.h      -*-Mode: c++-*-
 *
 * Scalar field object, derived from Oxs_ScalarField class,
 * that applies an script orientation (pre-)transformation
 * to another scalar field object.
 *
 */

#ifndef _OXS_SCRIPTORIENTSCALARFIELD
#define _OXS_SCRIPTORIENTSCALARFIELD

#include <vector>

#include "oc.h"
#include "nb.h"

#include "threevector.h"
#include "util.h"
#include "scalarfield.h"

OC_USE_STD_NAMESPACE;

/* End includes */

class Oxs_ScriptOrientScalarField:public Oxs_ScalarField {
private:
  Oxs_ThreeVector basept;
  Oxs_ThreeVector scale;
  vector<Nb_TclCommandLineOption> command_options;
  Nb_TclCommand cmd;
  Oxs_OwnedPointer<Oxs_ScalarField> field;
public:
  virtual const char* ClassName() const; // ClassName() is
  /// automatically generated by the OXS_EXT_REGISTER macro.

  Oxs_ScriptOrientScalarField
  (const char* name,     // Child instance id
   Oxs_Director* newdtr, // App director
   const char* argstr);  // MIF input block parameters

  virtual ~Oxs_ScriptOrientScalarField();

  virtual OC_REAL8m Value(const ThreeVector& pt) const;

  virtual void FillMeshValue(const Oxs_Mesh* mesh,
			     Oxs_MeshValue<OC_REAL8m>& array) const;
  virtual void IncrMeshValue(const Oxs_Mesh* mesh,
			     Oxs_MeshValue<OC_REAL8m>& array) const;
  virtual void MultMeshValue(const Oxs_Mesh* mesh,
			     Oxs_MeshValue<OC_REAL8m>& array) const;

};


#endif // _OXS_SCRIPTORIENTSCALARFIELD
