/* FILE: affineorientvectorfield.h      -*-Mode: c++-*-
 *
 * Vector field object, derived from Oxs_VectorField class,
 * that applies an affine orientation (pre-)transformation
 * to another vector field object.
 *
 */

#ifndef _OXS_AFFINEORIENTVECTORFIELD
#define _OXS_AFFINEORIENTVECTORFIELD

#include <vector>

#include "oc.h"

#include "threevector.h"
#include "util.h"
#include "vectorfield.h"

/* End includes */

class Oxs_AffineOrientVectorField:public Oxs_VectorField {
private:
  Oxs_ThreeVector offset;
  Oxs_ThreeVector row1,row2,row3;
  Oxs_OwnedPointer<Oxs_VectorField> field;
  static void InvertMatrix(Oxs_Ext* obj,
			   Oxs_ThreeVector& A1,
			   Oxs_ThreeVector& A2,
			   Oxs_ThreeVector& A3,
			   OC_REAL8m checkslack);
                           /// Ai's are matrix rows
public:
  virtual const char* ClassName() const; // ClassName() is
  /// automatically generated by the OXS_EXT_REGISTER macro.

  Oxs_AffineOrientVectorField
  (const char* name,     // Child instance id
   Oxs_Director* newdtr, // App director
   const char* argstr);  // MIF input block parameters

  virtual ~Oxs_AffineOrientVectorField();

  virtual void Value(const ThreeVector& pt,ThreeVector& value) const;

  virtual void FillMeshValue(const Oxs_Mesh* mesh,
			     Oxs_MeshValue<ThreeVector>& array) const;
};


#endif // _OXS_AFFINEORIENTVECTORFIELD
