/*            -*-Mode: c++-*-
 *
 * Uniform, periodic 6 neighbor exchange energy on rectangular mesh,
 * derived from Oxs_Energy class.
 * 
 */

#ifndef _PBC_Exchange_2D
#define _PBC_Exchange_2D

#include "oc.h"
#include "director.h"
#include "energy.h"
#include "meshvalue.h"
#include "simstate.h"
#include "threevector.h"
#include "util.h"

/* End includes */

class PBC_Exchange_2D:public Oxs_Energy {
private:
  OC_REAL8m A;

  void CalcEnergy6NgbrPBC_2D
  (const Oxs_MeshValue<ThreeVector>& spin,
   const Oxs_MeshValue<OC_REAL8m>& Ms_inverse,
   const Oxs_RectangularMesh* mesh,
   Oxs_MeshValue<OC_REAL8m>& energy,
   Oxs_MeshValue<ThreeVector>& field) const;

protected:
  virtual void GetEnergy(const Oxs_SimState& state,
			 Oxs_EnergyData& oed) const;

public:
  virtual const char* ClassName() const; // ClassName() is
  /// automatically generated by the OXS_EXT_REGISTER macro.
  PBC_Exchange_2D(const char* name,     // Child instance id
		    Oxs_Director* newdtr, // App director
		    const char* argstr);  // MIF input block parameters
  virtual ~PBC_Exchange_2D();
  virtual OC_BOOL Init();
};


#endif // _PBC_Exchange_2D
