/* FILE: randomvectorfield.h      -*-Mode: c++-*-
 *
 * Random vector field object, derived from Oxs_VectorField class.
 *
 */

#ifndef _OXS_RANDOMVECTORFIELD
#define _OXS_RANDOMVECTORFIELD

#include <map>

#include "oc.h"

#include "threevector.h"
#include "vectorfield.h"

/* End includes */

class Oxs_RandomVectorField:public Oxs_VectorField {
private:
  OC_REAL8m min_norm;
  OC_REAL8m max_norm;
  OC_REAL8m mincubed;
  OC_REAL8m maxcubed;
  /// The cube weights are necessary to get a uniform sampling
  /// by volume.  They are computed up front for convenience.

  // Caching
  Oxs_OwnedPointer<Oxs_Mesh> cache_mesh;
  std::vector<ThreeVector> results_cache;
  OC_BOOL use_cache;

public:
  virtual const char* ClassName() const; // ClassName() is
  /// automatically generated by the OXS_EXT_REGISTER macro.

  Oxs_RandomVectorField
  (const char* name,     // Child instance id
   Oxs_Director* newdtr, // App director
   const char* argstr);  // MIF input block parameters

  virtual ~Oxs_RandomVectorField() {}

  virtual void Value(const ThreeVector& pt,ThreeVector& value) const;

  virtual void FillMeshValue(const Oxs_Mesh* mesh,
			     Oxs_MeshValue<ThreeVector>& array) const {
    DefaultFillMeshValue(mesh,array);
  }
};


#endif // _OXS_RANDOMVECTORFIELD

