/* FILE: DMexchange6ngbr.h            -*-Mode: c++-*-
 *
 * Dzyaloshinsky-Moriya 6 neighbor exchange energy on rectangular mesh,
 * derived from Oxs_Energy class.
 * Modification from Oxs_exchange6ngbr.h by S. ROHART (LPS, Univ. Paris Sud, FRANCE) june 2012
 *
 * Please quote S. ROHART and A. THIAVILLE Phys. Rev. B 88, 184422 (2013) when using
 *
 * This is the up-to-date version for OOMMF 1.2.a.5.
 */

#ifndef _OXS_DMEXCHANGE6NGBR
#define _OXS_DMEXCHANGE6NGBR

#include "atlas.h"
#include "key.h"
#include "energy.h"
#include "mesh.h"
#include "meshvalue.h"
#include "simstate.h"
#include "threevector.h"
#include "rectangularmesh.h"

/* End includes */

class Oxs_DMExchange6Ngbr:public Oxs_Energy {
private:
  OC_INT4m A_size;
  OC_REAL8m** D;
  Oxs_Key<Oxs_Atlas> atlaskey;  
  Oxs_OwnedPointer<Oxs_Atlas> atlas;
  mutable OC_INT4m mesh_id;
  mutable Oxs_MeshValue<OC_INT4m> region_id;

protected:
  virtual void GetEnergy(const Oxs_SimState& state,
			 Oxs_EnergyData& oed) const;

public:
  virtual const char* ClassName() const; // ClassName() is
  /// automatically generated by the OXS_EXT_REGISTER macro.
  Oxs_DMExchange6Ngbr(const char* name,     // Child instance id
		    Oxs_Director* newdtr, // App director
		    const char* argstr);  // MIF input block parameters
  virtual ~Oxs_DMExchange6Ngbr();
  virtual OC_BOOL Init();
};


#endif // _OXS_DMEXCHANGE6NGBR
