/* FILE: vecmagscalarfield.h      -*-Mode: c++-*-
 *
 * Scalar field constructed from a vector field.
 * This class is derived from Oxs_ScalarField class.
 *
 */

#ifndef _OXS_VECMAGSCALARFIELD
#define _OXS_VECMAGSCALARFIELD

#include "oc.h"

#include "scalarfield.h"
#include "vectorfield.h"

/* End includes */

class Oxs_VecMagScalarField:public Oxs_ScalarField {
private:
  OC_REAL8m offset;
  OC_REAL8m multiplier;
  Oxs_OwnedPointer<Oxs_VectorField> vecfield;
public:
  virtual const char* ClassName() const; // ClassName() is
  /// automatically generated by the OXS_EXT_REGISTER macro.

  Oxs_VecMagScalarField
  (const char* name,     // Child instance id
   Oxs_Director* newdtr, // App director
   const char* argstr);  // MIF input block parameters

  virtual ~Oxs_VecMagScalarField() {}

  virtual OC_REAL8m Value(const ThreeVector& pt) const;

  virtual void FillMeshValue(const Oxs_Mesh* mesh,
			     Oxs_MeshValue<OC_REAL8m>& array) const;
  virtual void IncrMeshValue(const Oxs_Mesh* mesh,
			     Oxs_MeshValue<OC_REAL8m>& array) const;
  virtual void MultMeshValue(const Oxs_Mesh* mesh,
			     Oxs_MeshValue<OC_REAL8m>& array) const;
};

#endif // _OXS_VECMAGSCALARFIELD
