/* FILE: atlasscalarfield.h      -*-Mode: c++-*-
 *
 * Atlas scalar field object, derived from Oxs_ScalarField
 * class.
 *
 */

#ifndef _OXS_ATLASSCALARFIELD
#define _OXS_ATLASSCALARFIELD

#include "oc.h"
#include "nb.h"

#include "atlas.h"
#include "scalarfield.h"

OC_USE_STD_NAMESPACE;

/* End includes */

// Struct for use inside Oxs_AtlasScalarField class only.
// Defined outside that class to please MSVC++ 5.0.
struct OxsASFSpecifiedValue {
  OC_BOOL value_is_set;
  Oxs_OwnedPointer<Oxs_ScalarField> value_init;
  OxsASFSpecifiedValue() : value_is_set(0) {}
};
// The next 3 operators are defined so MSVC++ 5.0 will accept
// vector<OxsASFSpecifiedValue>, but are left undefined because
// they aren't needed.
OC_BOOL operator<(const OxsASFSpecifiedValue&,const OxsASFSpecifiedValue&);
OC_BOOL operator>(const OxsASFSpecifiedValue&,const OxsASFSpecifiedValue&);
OC_BOOL operator==(const OxsASFSpecifiedValue&,const OxsASFSpecifiedValue&);

class Oxs_AtlasScalarField:public Oxs_ScalarField {
private:
  OC_REAL8m multiplier;
  Oxs_OwnedPointer<Oxs_Atlas> atlas_obj; // Atlas basket
  Oxs_Key<Oxs_Atlas> atlas_key;
  Nb_ArrayWrapper<OxsASFSpecifiedValue> values;
  OxsASFSpecifiedValue default_value;
public:
  virtual const char* ClassName() const; // ClassName() is
  /// automatically generated by the OXS_EXT_REGISTER macro.
  Oxs_AtlasScalarField
  (const char* name,     // Child instance id
   Oxs_Director* newdtr, // App director
   const char* argstr);  // MIF input block parameters

  virtual ~Oxs_AtlasScalarField() {}

  virtual OC_REAL8m Value(const ThreeVector& pt) const;

  virtual void FillMeshValue(const Oxs_Mesh* mesh,
			     Oxs_MeshValue<OC_REAL8m>& array) const {
    DefaultFillMeshValue(mesh,array);
  }
  virtual void IncrMeshValue(const Oxs_Mesh* mesh,
			     Oxs_MeshValue<OC_REAL8m>& array) const {
    DefaultIncrMeshValue(mesh,array);
  }
  virtual void MultMeshValue(const Oxs_Mesh* mesh,
			     Oxs_MeshValue<OC_REAL8m>& array) const {
    DefaultMultMeshValue(mesh,array);
  }

};

#endif // _OXS_ATLASSCALARFIELD
