/* FILE: ocport.h             -*-Mode: c++-*-
 *
 * Machine specific #define's and typedef's, generated by [Oc_MakePortHeader]
 *
 * This is a machine-generated file.  DO NOT EDIT!
 *
 */

#ifndef _OC_PORT
#define _OC_PORT

#define OOMMF_API_INDEX 20170916

#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <cfloat>
#include <cmath>

/* See Stroustrup, Section 16.1.3. */
#include <exception>         /* The base class std::exception and the  */
                             /*  standard exception std::bad_exception */
#include <new>               /* The standard exception std::bad_alloc  */
#include <typeinfo>          /* The standard exceptions std::bad_cast  */
                             /*  and std::bad_typeid                   */
#define OC_THROW(x) throw x


/* getpid() prototype for Windows*/
#include <process.h>

/* Windows header file.  NB: This defines a lot of stuff we      */
/* don't need or really want, like macros min(x,y) and max(x,y). */
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#undef WIN32_LEAN_AND_MEAN

/* End includes */

#define CONFIG_TCL_PATCH_LEVEL "8.6.6"
#define CONFIG_TCL_MAJOR_VERSION 8
#define CONFIG_TCL_MINOR_VERSION 6
#define CONFIG_TCL_RELEASE_SERIAL 6
#define CONFIG_TCL_RELEASE_LEVEL 2

#define OC_USE_TK 1
#define CONFIG_TK_PATCH_LEVEL "8.6.6"
#define CONFIG_TK_MAJOR_VERSION 8
#define CONFIG_TK_MINOR_VERSION 6
#define CONFIG_TK_RELEASE_SERIAL 6
#define CONFIG_TK_RELEASE_LEVEL 2

#define OC_USE_STD_NAMESPACE using namespace std
#define OC_USE_EXCEPTION typedef std::exception EXCEPTION
#define OC_USE_BAD_ALLOC typedef std::bad_alloc BAD_ALLOC
#define OC_USE_STRING typedef std::string String

/* Substitute domain checked atan2 */
#define OC_DOMAIN_CHECK_ATAN2 1
#define atan2(y,x) Oc_Atan2((y),(x))

/* Use OOMMF provided error function */
#define erf(x) Oc_Erf((x))

/* Use _hypot in place of hypot */
#define hypot(x,y) _hypot((x),(y))

/* Wrapper for system getpid call; use _getpid in place of getpid */
inline int Oc_GetPid() { return _getpid(); }

/* Dummy wrapper for ansi-compliant sprintf */
#define OC_SPRINTF_WRAP(x) (x)

/* Platform supports vsnprintf */
#define OC_HAS_VSNPRINTF 1

/* Integer variable type declarations.  The       */
/* '****#m' types are at *least* '#' bytes wide.  */
typedef  int                OC_BOOL;
typedef  unsigned char      OC_BYTE;
typedef  char               OC_CHAR;
typedef  unsigned char      OC_UCHAR;
typedef  char               OC_SCHAR;

typedef  short              OC_INT2;
typedef  unsigned short     OC_UINT2;
typedef  int                OC_INT4;
typedef  unsigned int       OC_UINT4;
typedef  __int64            OC_INT8;
typedef  unsigned __int64   OC_UINT8;
typedef  int                OC_INT2m;
typedef  unsigned int       OC_UINT2m;
typedef  int                OC_INT4m;
typedef  unsigned int       OC_UINT4m;
typedef  __int64            OC_INT8m;
typedef  unsigned __int64   OC_UINT8m;

#define OC_HAS_INT2 1
#define OC_HAS_INT4 1
#define OC_HAS_INT8 1
#define OC_HAS_INT16 0

/* Width of integer types */
#define OC_INT_WIDTH 4
#define OC_LONG_WIDTH 4
#define OC_INT4m_WIDTH 4
#define OC_INT8m_WIDTH 8

/* printf format modifiers for integer types */
/* unsigned types use corresponding signed modifier */
#define OC_INT2_MOD "h"
#define OC_INT4_MOD ""
#define OC_INT8_MOD "I64"
#define OC_INT2m_MOD ""
#define OC_INT4m_MOD ""
#define OC_INT8m_MOD "I64"


/* Floating point variable type declarations.  The */
/* '****#m' types are at *least* '#' bytes wide.   */
typedef  float              OC_REAL4;
typedef  double             OC_REAL8;
typedef  float              OC_REAL4m;
typedef  double             OC_REAL8m;
typedef  double             OC_REALWIDE;  /* Widest native float */

#define OC_REAL4m_WIDTH 4
#define OC_TWO_VECTOR_REAL4m_WIDTH 8
#define OC_THREE_VECTOR_REAL4m_WIDTH 12

#define OC_REAL8m_WIDTH 8
#define OC_TWO_VECTOR_REAL8m_WIDTH 16
#define OC_THREE_VECTOR_REAL8m_WIDTH 24

#define OC_REALWIDE_WIDTH 8
#define OC_TWO_VECTOR_REALWIDE_WIDTH 16
#define OC_THREE_VECTOR_REALWIDE_WIDTH 24
#define OC_REALWIDE_INTRINSIC_WIDTH 8

#define OC_REAL8m_IS_DOUBLE 1

#define OC_REAL8m_IS_LONG_DOUBLE 0
#define OC_REAL8m_IS_REAL8 1
#define OC_REALWIDE_IS_REAL8 1

/* printf format modifiers for floating point types */
#define OC_REAL4_MOD ""
#define OC_REAL8_MOD ""
#define OC_REAL4m_MOD ""
#define OC_REAL8m_MOD ""
#define OC_REALWIDE_MOD OC_REAL8m_MOD

/* Smallest value eps such that 1 + eps != 1 */
#define OC_REAL4_EPSILON    1.19209290e-07
#define OC_REAL4m_EPSILON   1.19209290e-07
#define OC_REAL8_EPSILON    2.2204460492503131e-16
#define OC_REAL8m_EPSILON   2.2204460492503131e-16
#define OC_REALWIDE_EPSILON 2.2204460492503131e-16

#define OC_SQRT_REAL4_EPSILON    3.45266983e-04
#define OC_SQRT_REAL4m_EPSILON   3.45266983e-04
#define OC_SQRT_REAL8_EPSILON    1.4901161193847656e-08
#define OC_SQRT_REAL8m_EPSILON   1.4901161193847656e-08
#define OC_SQRT_REALWIDE_EPSILON 1.4901161193847656e-08

#define OC_CUBE_ROOT_REAL4_EPSILON    4.92156660e-03
#define OC_CUBE_ROOT_REAL4m_EPSILON   4.92156660e-03
#define OC_CUBE_ROOT_REAL8_EPSILON    6.0554544523933429e-06
#define OC_CUBE_ROOT_REAL8m_EPSILON   6.0554544523933429e-06
#define OC_CUBE_ROOT_REALWIDE_EPSILON 6.0554544523933429e-06

/* Range limits, analogous to C language DBL_MIN and DBL_MAX macros */
#define OC_REAL4_MIN      1.17549435e-38
#define OC_SQRT_REAL4_MIN 1.08420217e-19
#define OC_REAL4_MAX      3.40282347e+38
#define OC_SQRT_REAL4_MAX 1.84467435e+19
#define OC_REAL4m_MIN     1.17549435e-38
#define OC_REAL4m_MAX     3.40282347e+38
#define OC_REAL8_MIN      2.2250738585072014e-308
#define OC_SQRT_REAL8_MIN 1.4916681462400413e-154
#define OC_REAL8_MAX      1.7976931348623157e+308
#define OC_SQRT_REAL8_MAX 1.3407807929942596e+154
#define OC_REAL8m_MIN     2.2250738585072014e-308
#define OC_REAL8m_MAX     1.7976931348623157e+308
#define OC_REALWIDE_MIN   2.2250738585072014e-308
#define OC_REALWIDE_MAX   1.7976931348623157e+308

#define OC_FP_DOUBLE_EXTRA_PRECISION 0
#define OC_FP_LONG_DOUBLE_EXTRA_PRECISION 0


/* Use legacy x86 floating point */
#define OC_USE_X87 1

/* Use SSE intrinsics, level 2 and lower */
/* Macro OC_USE_SSE is similar to OC_SSE_LEVEL, but is only true
 * if SSE level is at least 2, and the OC_REAL8m type is 8 bytes wide
 * (and therefore agrees with the SSE double precision type.)
 */
#define OC_SSE_LEVEL 2
#if OC_SSE_LEVEL>1 && OC_REAL8m_IS_REAL8 && OC_HAS_INT8
# define OC_USE_SSE OC_SSE_LEVEL
  union OC_SSE_MASK {
     OC_UINT8 imask;
     OC_REAL8 dval;
  };
#else
# error Configuration error (ocport.h: OC_USE_SSE)
#endif

/* SSE intrinsic _mm_cvtsd_f64 provided by compiler */
#define OC_COMPILER_HAS_MM_CVTSD_F54 1

/* No fused multiply-add (FMA) support */
#define OC_FMA_TYPE 0

/* Width of pointer type */
#define OC_POINTER_WIDTH 8

/* OC_INDEX is the suggested type for array indices.  */
/*   It is a signed int type that is at least 4 bytes */
/*   wide and not narrower than the pointer type.     */
/* OC_UINDEX is the unsigned version of OC_INDEX.  It */
/*   is intended for special-purpose use only; use    */
/*   OC_INDEX where possible.                         */
typedef __int64 OC_INDEX;
typedef unsigned __int64 OC_UINDEX;
#define OC_INDEX_WIDTH 8
#define OC_INDEX_MAX 9223372036854775807
#define OC_UINDEX_MAX (2*OC_UINDEX(9223372036854775807)+1)
#define OC_INDEX_MOD OC_INT8_MOD
#define OC_INDEX_CHECKS 0

#define OC_BYTEORDER 4321

/* Build in thread (multi-processing) support */
#define OOMMF_THREADS 1

/* Child threads need to have floating point */
/* control word explicitly set.              */
#define OC_CHILD_COPY_FPU_CONTROL_WORD 1

/* Don't use NUMA (non-uniform memory access) libraries */
#define OC_USE_NUMA 0

#define OC_PAGESIZE 4096 /* Natural system memory blocksize, in bytes. */
#define OC_CACHE_LINESIZE 64 /* L1 data cache line size, in bytes. */

/* System type info */
#define OC_UNIX 1
#define OC_WINDOWS 2
#define OC_VANILLA 4
#define OC_DARWIN 5
#define OC_CYGWIN 6
#define OC_WINNT 7
#define OC_SYSTEM_TYPE OC_WINDOWS
#define OC_SYSTEM_SUBTYPE OC_WINNT
#define OC_TCL_TYPE OC_WINDOWS

/* Set task bar identifiers to group together all OOMMF apps */
#define OC_SET_TASKBAR_ID 1

/* Random number generator.  Default is Oc_Random, which is an   */
/* implementation of the GLIBC random() function with default    */
/* state size.  You can replace this with your own random number */
/* generator if desired.                                         */
/* NB: Any code that uses the default macro settings (involving  */
/*     Oc_Random), must also #include "oc.h" in order to get the */
/*     definition of the Oc_Random class.                        */
#define OMF_RANDOM_IS_DEFAULT 1
#define OMF_SRANDOM(seed)  Oc_Random::Srandom(seed)
#define OMF_RANDOM()       Oc_Random::Random()
#define OMF_RANDOM_MAX     Oc_Random::MaxValue()

/* Signal handler prototype, to work around some non-ANSI header files */
extern "C" {
typedef void(*omf_sighandler)(int);             /* ANSI version */
/* typedef void(*omf_sighandler)(int, ...); */  /* Not ANSI */
}

/* For Windows */
#define rint(x) (floor(x+0.5))
 
/* NICE_DEFAULT is the priority level passed to SetPriorityClass() */
/* inside MakeNice().                                              */
#define NICE_DEFAULT IDLE_PRIORITY_CLASS
#define NICE_THREAD_DEFAULT THREAD_PRIORITY_NORMAL

/* Directory path separator; Unix uses '/', DOS uses '\'. */
#define DIRSEPCHAR '\\'
#define DIRSEPSTR  "\\"
#define PATHSPLITSTR ";"

/* Definitions for Oc_TimeVal class */
#define OC_HAS_GETPROCESSTIMES
typedef OC_UINT8 OC_TIMEVAL_TICK_TYPE;
#define OC_TIMEVAL_TICK_TYPE_MOD OC_INT8_MOD
#define OC_TIMEVAL_TO_DOUBLE(x) double(x)

#endif /* _OC_PORT_H */
