/* FILE: exchange6ngbr.h            -*-Mode: c++-*-
 *
 * 6 neighbor exchange energy on rectangular mesh,
 * derived from Oxs_Energy class.
 *
 */

#ifndef _PBC_Exchange6Ngbr_2D
#define _PBC_Exchange6Ngbr_2D

#include "atlas.h"
#include "key.h"
#include "energy.h"
#include "mesh.h"
#include "meshvalue.h"
#include "simstate.h"
#include "threevector.h"
#include "rectangularmesh.h"

/* End includes */

class PBC_Exchange6Ngbr_2D:public Oxs_Energy {
private:
  OC_INDEX A_size;
  OC_REAL8m** A;
  Oxs_Key<Oxs_Atlas> atlaskey;  
  Oxs_OwnedPointer<Oxs_Atlas> atlas;
  mutable OC_INDEX mesh_id;
  mutable Oxs_MeshValue<OC_INT4m> region_id;

protected:
  virtual void GetEnergy(const Oxs_SimState& state,
			 Oxs_EnergyData& oed) const;

public:
  virtual const char* ClassName() const; // ClassName() is
  /// automatically generated by the OXS_EXT_REGISTER macro.
  PBC_Exchange6Ngbr_2D(const char* name,     // Child instance id
		    Oxs_Director* newdtr, // App director
		    const char* argstr);  // MIF input block parameters
  virtual ~PBC_Exchange6Ngbr_2D();
  virtual OC_BOOL Init();
};


#endif // _PBC_Exchange6Ngbr_2D
