/* FILE: filevectorfield.h      -*-Mode: c++-*-
 *
 * File vector field object, derived from Oxs_VectorField class.
 *
 */

#ifndef _OXS_FILEVECTORFIELD
#define _OXS_FILEVECTORFIELD

#include "oc.h"

#include "vectorfield.h"

/* End includes */

class Oxs_FileVectorField:public Oxs_VectorField {
private:
  Vf_Mesh* file_mesh;
  Nb_BoundingBox<OC_REAL8> file_box;  // mesh range
  OC_BOOL set_norm;
  OC_REAL8m norm;
  OC_REAL8m multiplier;
  ThreeVector scale,offset;
  OC_REAL8m valuescale;
  enum Exterior_Handling {
    EXTERIOR_ERROR, EXTERIOR_BOUNDARY, EXTERIOR_DEFAULT
  } exterior;
  ThreeVector default_value;
public:
  virtual const char* ClassName() const; // ClassName() is
  /// automatically generated by the OXS_EXT_REGISTER macro.

  Oxs_FileVectorField
  (const char* name,     // Child instance id
   Oxs_Director* newdtr, // App director
   const char* argstr);  // MIF input block parameters

  virtual ~Oxs_FileVectorField();

  virtual void Value(const ThreeVector& pt,ThreeVector& value) const;

  virtual void FillMeshValue(const Oxs_Mesh* mesh,
			     Oxs_MeshValue<ThreeVector>& array) const;
};


#endif // _OXS_FILEVECTORFIELD
