/* FILE: labelvalue.h                 -*-Mode: c++-*-
 *
 * Concrete label-value class, derived from OXS extension class.
 * A wrapper around an STL map object, using the OXS initialization
 * paradigm.
 *
 */

#ifndef _OXS_LABELVALUE
#define _OXS_LABELVALUE

#include <string>
#include <vector>
#include <map>

#include "ext.h"

OC_USE_STRING;

/* End includes */

class Oxs_LabelValue:public Oxs_Ext {
private:
  // Uses parent "init_strings" map.

  // Oxs_Ext parent can't be copied, so this class can't either.
  // So disable copy constructor and assignment operators by declaring
  // them without providing definitions.
  Oxs_LabelValue(const Oxs_LabelValue&);
  Oxs_LabelValue& operator=(const Oxs_LabelValue&);

public:
  virtual const char* ClassName() const; // ClassName() is
  /// automatically generated by the OXS_EXT_REGISTER macro.
  Oxs_LabelValue(const char* name,     // Child instance id
		 Oxs_Director* newdtr, // App director
		 const char* argstr);  // MIF input block parameters

  virtual ~Oxs_LabelValue() {}

  // Read access
  void GetLabels(vector<String>& labels) const;

  OC_BOOL HasLabel(const String& label) const;  // Returns 1 if label is
  /// a valid key into init_strings, 0 otherwise.

  String GetValue(const String& label) const; // Throws an exception if
  /// "label" is not a key in init_strings.

  // Write access
  void SetLabel(const String& label,const String& value);
  /// Unconditionally sets/adds the pair label,value to init_strings.

  OC_BOOL InitializeLabel(const String& label,const String& value);
  /// If 'label' is not in init_strings, then adds it with associated
  /// value 'value', and returns 1.  If 'label' is already in
  /// init_strings, then the value is unchanged and 0 is returned.

};

#endif // _OXS_LABELVALUE
