/* FILE: randomscalarfield.h      -*-Mode: c++-*-
 *
 * Random scalar field object, derived from Oxs_ScalarField class.
 *
 */

#ifndef _OXS_RANDOMSCALARFIELD
#define _OXS_RANDOMSCALARFIELD

#include <map>

#include "oc.h"

#include "scalarfield.h"
#include "threevector.h"

/* End includes */

class Oxs_RandomScalarField:public Oxs_ScalarField {
private:
  OC_REAL8m range_min;
  OC_REAL8m range_max;

  // Caching
  Oxs_OwnedPointer<Oxs_Mesh> cache_mesh;
  std::vector<OC_REAL8m> results_cache;
  OC_BOOL use_cache;

public:
  virtual const char* ClassName() const; // ClassName() is
  /// automatically generated by the OXS_EXT_REGISTER macro.

  Oxs_RandomScalarField
  (const char* name,     // Child instance id
   Oxs_Director* newdtr, // App director
   const char* argstr);  // MIF input block parameters

  virtual ~Oxs_RandomScalarField() {}

  virtual OC_REAL8m Value(const ThreeVector& pt) const;

  virtual void FillMeshValue(const Oxs_Mesh* mesh,
			     Oxs_MeshValue<OC_REAL8m>& array) const;
  virtual void IncrMeshValue(const Oxs_Mesh* mesh,
			     Oxs_MeshValue<OC_REAL8m>& array) const;
  virtual void MultMeshValue(const Oxs_Mesh* mesh,
			     Oxs_MeshValue<OC_REAL8m>& array) const;
};

#endif // _OXS_RANDOMSCALARFIELD

