/* FILE: linearscalarfield.h      -*-Mode: c++-*-
 *
 * Linear scalar field, derived from Oxs_ScalarField class.
 *
 */

#ifndef _OXS_LINEARSCALARFIELD
#define _OXS_LINEARSCALARFIELD

#include "oc.h"

#include "scalarfield.h"

/* End includes */

class Oxs_LinearScalarField:public Oxs_ScalarField {
private:
  OC_REAL8m off;
  ThreeVector vec;
public:
  virtual const char* ClassName() const; // ClassName() is
  /// automatically generated by the OXS_EXT_REGISTER macro.

  Oxs_LinearScalarField
  (const char* name,     // Child instance id
   Oxs_Director* newdtr, // App director
   const char* argstr);  // MIF input block parameters

  virtual ~Oxs_LinearScalarField() {}

  virtual OC_REAL8m Value(const ThreeVector& pt) const;

  virtual void FillMeshValue(const Oxs_Mesh* mesh,
			     Oxs_MeshValue<OC_REAL8m>& array) const;
  virtual void IncrMeshValue(const Oxs_Mesh* mesh,
			     Oxs_MeshValue<OC_REAL8m>& array) const;
  virtual void MultMeshValue(const Oxs_Mesh* mesh,
			     Oxs_MeshValue<OC_REAL8m>& array) const;
};

#endif // _OXS_LINEARSCALARFIELD
