/* FILE: fixedzeeman.h            -*-Mode: c++-*-
 *
 * Fixed (in time) Zeeman energy/field, derived from Oxs_Energy class.
 *
 */

#ifndef _OXS_FIXEDZEEMAN
#define _OXS_FIXEDZEEMAN

#include "oc.h"
#include "director.h"
#include "threevector.h"
#include "chunkenergy.h"
#include "energy.h"
#include "simstate.h"
#include "mesh.h"
#include "meshvalue.h"
#include "vectorfield.h"

/* End includes */

class Oxs_FixedZeeman
  : public Oxs_ChunkEnergy, public Oxs_EnergyPreconditionerSupport  {
private:
  mutable OC_UINT4m mesh_id;
  OC_REAL8m field_mult;
  Oxs_OwnedPointer<Oxs_VectorField> fixedfield_init;
  mutable Oxs_MeshValue<ThreeVector> fixedfield;
  /// fixedfield is a cached value filled by
  /// fixedfield_init when a change in mesh is
  /// detected.

protected:
  virtual void GetEnergy(const Oxs_SimState& state,
			 Oxs_EnergyData& oed) const {
    GetEnergyAlt(state,oed);
  }

  virtual void ComputeEnergy(const Oxs_SimState& state,
                             Oxs_ComputeEnergyData& oced) const {
    ComputeEnergyAlt(state,oced);
  }

  virtual void ComputeEnergyChunkInitialize
  (const Oxs_SimState& state,
   const Oxs_ComputeEnergyDataThreaded& ocedt,
   vector<Oxs_ComputeEnergyDataThreadedAux>& thread_ocedtaux,
   int number_of_threads) const;

  virtual void ComputeEnergyChunk(const Oxs_SimState& state,
                                  const Oxs_ComputeEnergyDataThreaded& ocedt,
                                  Oxs_ComputeEnergyDataThreadedAux& ocedtaux,
                                  OC_INDEX node_start,OC_INDEX node_stop,
                                  int threadnumber) const;

public:
  virtual const char* ClassName() const; // ClassName() is
  /// automatically generated by the OXS_EXT_REGISTER macro.
  Oxs_FixedZeeman(const char* name,  // Child instance id
		  Oxs_Director* newdtr, // App director
		  const char* argstr);  // MIF input block parameters

  virtual ~Oxs_FixedZeeman() {}
  virtual OC_BOOL Init();

  // Optional interface for conjugate-gradient evolver.
  virtual OC_INT4m IncrementPreconditioner(PreconditionerData& pcd);
};


#endif // _OXS_FIXEDZEEMAN
