/* FILE: scriptatlas.h                 -*-Mode: c++-*-
 *
 * Script atlas class, derived from Oxs_Atlas class.
 *
 */

#ifndef _OXS_SCRIPTATLAS
#define _OXS_SCRIPTATLAS

#include <string>
#include <vector>

#include "nb.h"

#include "atlas.h"
#include "ext.h"
#include "threevector.h"
#include "util.h"

OC_USE_STD_NAMESPACE;
OC_USE_STRING;

/* End includes */

class Oxs_ScriptAtlas:public Oxs_Atlas {
private:
  vector<String> region_name_list;
  Oxs_Box bounding_box;
  Oxs_ThreeVector scale;
  vector<Nb_TclCommandLineOption> command_options;
  Nb_TclCommand cmd;
public:
  virtual const char* ClassName() const; // ClassName() is
  /// automatically generated by the OXS_EXT_REGISTER macro.

  Oxs_ScriptAtlas(const char* name,
		  Oxs_Director* newdtr,
		  const char* argstr);   // MIF block argument string

  ~Oxs_ScriptAtlas();

  void GetWorldExtents(Oxs_Box &mybox) const {
    mybox = bounding_box;
  }

  OC_BOOL GetRegionExtents(OC_INDEX id,Oxs_Box &mybox) const;
  /// Fills mybox with a bounding box for region with specified
  /// id number.  Return value is 0 iff id is invalid.  At present,
  /// given a valid id number, just returns the world bounding
  /// box.  In the future, we might want to add support for refined
  /// region bounding boxes.

  OC_INDEX GetRegionId(const ThreeVector& point) const;
  /// Returns the id number for the region
  /// containing the point, as determined by the
  /// script.  The return value is 0 if the
  /// point is not contained in the atlas, i.e,
  /// belongs to the "universe".

  OC_INDEX GetRegionId(const String& name) const;
  /// Given a region id string (name), returns
  /// the corresponding region id index.  If
  /// "name" is not included in the atlas, then
  /// -1 is returned.  Note: If name == "universe",
  /// then the return value will be 0.

  OC_BOOL GetRegionName(OC_INDEX id,String& name) const;
  /// Given an id number, fills in "name" with
  /// the corresponding region id string.  Returns
  /// 1 on success, 0 if id is invalid.  If id is 0,
  /// then name is set to "universe", and the return
  /// value is 1.

  OC_INDEX GetRegionCount() const {
    return static_cast<OC_INDEX>(region_name_list.size());
  }
  /// Valid RegionId numbers range from 0 to GetRegionCount() - 1,
  /// inclusive, where 0 is the special "universe" region.

};

#endif // _OXS_SCRIPTATLAS
