/* FILE: cubicanisotropy8.h            -*-Mode: c++-*-
 *
 * Cubic Anisotropy, derived from Oxs_Energy class.
 *
 * This interface is a modification of the interface
 * /oommf/app/oxs/ext/cubicanisotropy.h
 * It is designed for handling higher orders of the 
 * power series of the cubic anisotropy
 *
 * The required values are 
 * -scalar 'K1' (for fourth order power)
 * -scalar 'K2' (for sixth order power),
 * -scalar 'K3' (for eigth order power),
 * -vector 'axis1' indicating first cubic anisotropy direction
 * -vector 'axis2' indicating second cubic anisotropy direction
 * (the third axis is assumed to be perpendicular to axis1 and axis2)
 *
 * Juergen Zimmermann
 * Computational Engineering and Design Group
 * (c) 2005 University of Southampton
 * 
 * file created Wed Mai 11 2005
 *
 * file updated Thu April 19 2007: 
 * renaming issues  Ced_UniaxialAnisotropy to Oxs_UniaxialAnisotropy4
 */

#ifndef _OXS_CUBICANISOTROPY8
#define _OXS_CUBICANISOTROPY8

#include "nb.h"
#include "threevector.h"
#include "energy.h"
#include "key.h"
#include "simstate.h"
#include "mesh.h"
#include "meshvalue.h"
#include "scalarfield.h"
#include "vectorfield.h"

/* End includes */

class Southampton_CubicAnisotropy8:public Oxs_Energy {
private:
  Oxs_OwnedPointer<Oxs_ScalarField> K1_init;
  Oxs_OwnedPointer<Oxs_ScalarField> K2_init;
  Oxs_OwnedPointer<Oxs_ScalarField> K3_init;
  Oxs_OwnedPointer<Oxs_VectorField> axis1_init;
  Oxs_OwnedPointer<Oxs_VectorField> axis2_init;
  mutable UINT4m mesh_id;
  mutable Oxs_MeshValue<REAL8m> K1;
  mutable Oxs_MeshValue<REAL8m> K2;
  mutable Oxs_MeshValue<REAL8m> K3;
  mutable Oxs_MeshValue<ThreeVector> axis1;
  mutable Oxs_MeshValue<ThreeVector> axis2;
  /// K1, K2, K3, axis1 and axis2 are cached values filled by corresponding
  /// *_init members when a change in mesh is detected.

protected:
  virtual void GetEnergy(const Oxs_SimState& state,
			 Oxs_EnergyData& oed) const;

public:
  virtual const char* ClassName() const; // ClassName() is
  /// automatically generated by the OXS_EXT_REGISTER macro.
  Southampton_CubicAnisotropy8(const char* name,  // Child instance id
			       Oxs_Director* newdtr, // App director
			       const char* argstr);  // MIF input block parameters

  virtual ~Southampton_CubicAnisotropy8() {}
};


#endif // _OXS_CUBICANISOTROPY8
