set(OMNIORB_VERSION 4.2.4)


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was OmniORBConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################


include("${CMAKE_CURRENT_LIST_DIR}/OmniORBTargets.cmake")

set(_IMPORT_PREFIX ${PACKAGE_PREFIX_DIR})

find_package(Threads REQUIRED)

message(STATUS "Found OmniORB (found version \"4.2.4\")")
set(OMNIORB4_IDL_COMPILER ${CMAKE_COMMAND};-E;env;PATH=D:/bld/omniorb_1609955015638/_h_env$<SEMICOLON>;PYTHONHOME=D:/bld/omniorb_1609955015638/_h_env/Lib/..;PYTHONPATH="${PACKAGE_PREFIX_DIR}/D:/bld/omniorb_1609955015638/_h_env/Lib/site-packages";$<TARGET_FILE:OmniORB::omniidl>)
set(OMNIIDL_PLATFORM_FLAGS -T)
set_and_check(OMNI_PYTHON_RESOURCES D:/bld/omniorb_1609955015638/_h_env/Lib/site-packages)
set(RUN_OMNIIDL_DEPS OmniORB::omniidl OmniORB::omnicpp)
set(OMNIORB4_LIBRARIES OmniORB::omniORB4 OmniORB::omnithread OmniORB::omniDynamic4 OmniORB::COS4 OmniORB::COSDynamic4)
get_target_property(OMNIORB4_INCLUDE_DIR OmniORB::omniORB4 INTERFACE_INCLUDE_DIRECTORIES)
get_target_property(OMNIORB_INCLUDE_DIR OmniORB::omniORB4 INTERFACE_INCLUDE_DIRECTORIES)


include(${CMAKE_CURRENT_LIST_DIR}/run_omniidl.cmake)
