# Get current dir.
get_filename_component(_OBAKE_CONFIG_SELF_DIR "${CMAKE_CURRENT_LIST_FILE}" PATH)

# Find the deps. Alter the cmake module path.
set(_OBAKE_CONFIG_OLD_MODULE_PATH "${CMAKE_MODULE_PATH}")
list(APPEND CMAKE_MODULE_PATH "${_OBAKE_CONFIG_SELF_DIR}")
find_package(mp++ REQUIRED)
if(${mp++_VERSION} VERSION_LESS 0.17)
    message(FATAL_ERROR "The minimum mp++ version required by obake is 0.17, but version ${mp++_VERSION} was found instead.")
endif()
find_package(absl REQUIRED)
include(ObakeFindBoost)
find_package(TBB REQUIRED)
if(WIN32)
    find_package(DbgEng REQUIRED)
endif()
include(ObakeFindDl)
set(THREADS_PREFER_PTHREAD_FLAG YES)
find_package(Threads REQUIRED)
unset(THREADS_PREFER_PTHREAD_FLAG)

# Restore original module path.
set(CMAKE_MODULE_PATH "${_OBAKE_CONFIG_OLD_MODULE_PATH}")
unset(_OBAKE_CONFIG_OLD_MODULE_PATH)

include(${_OBAKE_CONFIG_SELF_DIR}/obake_export.cmake)

# Clean up.
unset(_OBAKE_CONFIG_SELF_DIR)
