// Copyright 2019-2020 Francesco Biscani (bluescarni@gmail.com)
//
// This file is part of the obake library.
//
// This Source Code Form is subject to the terms of the Mozilla
// Public License v. 2.0. If a copy of the MPL was not distributed
// with this file, You can obtain one at http://mozilla.org/MPL/2.0/.

#ifndef OBAKE_CONFIG_HPP
#define OBAKE_CONFIG_HPP

// Start of defines instantiated by CMake.
// clang-format off
#define OBAKE_VERSION_STRING "0.6.0"
#define OBAKE_VERSION_MAJOR 0
#define OBAKE_VERSION_MINOR 6
#define OBAKE_VERSION_PATCH 0

// clang-format on
// End of defines instantiated by CMake.

// Create a shortcut for detecting GCC.
// NOTE: clang defines __GNUC__ internally.
#if defined(__GNUC__) && !defined(__clang__)

#define OBAKE_COMPILER_IS_GCC

#endif

// Concepts setup.
#if defined(__cpp_concepts)

#define OBAKE_HAVE_CONCEPTS

// NOTE: GCC < 9 uses the syntax of the concept TS.
#if defined(OBAKE_COMPILER_IS_GCC) && __GNUC__ < 9

#define OBAKE_CONCEPT_DECL concept bool

#else

// Otherwise, just use the C++20 syntax.
#define OBAKE_CONCEPT_DECL concept

#endif

#endif

// C++ standard setup.
// NOTE: this is necessary because at this time MSVC does not set correctly the
// __cplusplus macro.
#if defined(_MSC_VER)

#define OBAKE_CPLUSPLUS _MSVC_LANG

#else

#define OBAKE_CPLUSPLUS __cplusplus

#endif

// Detect 128bit integers, lifted from mp++. This is part of the public API.
#include <mp++/config.hpp>

#if defined(MPPP_HAVE_GCC_INT128)

#define OBAKE_HAVE_GCC_INT128

#endif

// likely/unlikely macros, supported on GCC/clang.
#if defined(__GNUC__) || defined(__clang__)

#define obake_likely(x) __builtin_expect(static_cast<bool>(x), 1)
#define obake_unlikely(x) __builtin_expect(static_cast<bool>(x), 0)

#else

#define obake_likely(x) (x)
#define obake_unlikely(x) (x)

#endif

// Detect the availability of std::string_view.
// Use the definition from mp++.
#if defined(MPPP_HAVE_STRING_VIEW)

#define OBAKE_HAVE_STRING_VIEW

#endif

// Detect older versions of MSVC which do
// not like inline constexpr lambdas.
#if defined(_MSC_VER) && ((_MSVC_LANG <= 201703L) || (_MSC_FULL_VER <= 192428206))

#define OBAKE_MSVC_LAMBDA_WORKAROUND

#endif

#endif
