#
# Copyright The NOMAD Authors.
#
# This file is part of NOMAD.
# See https://nomad-lab.eu for further info.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
import numpy as np            # pylint: disable=unused-import
import typing                 # pylint: disable=unused-import
from nomad.metainfo import (  # pylint: disable=unused-import
    MSection, MCategory, Category, Package, Quantity, Section, SubSection, SectionProxy,
    Reference
)
from nomad.datamodel.metainfo import simulation


m_package = Package()


class x_fplo_in(MSection):
    '''
    FPLO input metainfo, autogenerated
    '''

    m_def = Section(validate=False)

    x_fplo_in_header = SubSection(
        sub_section=SectionProxy('x_fplo_in_header'),
        repeats=True)

    x_fplo_in_structure_information = SubSection(
        sub_section=SectionProxy('x_fplo_in_structure_information'),
        repeats=True)

    x_fplo_in_structure_dependend = SubSection(
        sub_section=SectionProxy('x_fplo_in_structure_dependend'),
        repeats=True)

    x_fplo_in_mesh = SubSection(
        sub_section=SectionProxy('x_fplo_in_mesh'),
        repeats=True)

    x_fplo_in_brillouin = SubSection(
        sub_section=SectionProxy('x_fplo_in_brillouin'),
        repeats=True)

    x_fplo_in_bandstructure_plot = SubSection(
        sub_section=SectionProxy('x_fplo_in_bandstructure_plot'),
        repeats=True)

    x_fplo_in_iteration_control = SubSection(
        sub_section=SectionProxy('x_fplo_in_iteration_control'),
        repeats=True)

    x_fplo_in_forces = SubSection(
        sub_section=SectionProxy('x_fplo_in_forces'),
        repeats=True)

    x_fplo_in_options = SubSection(
        sub_section=SectionProxy('x_fplo_in_options'),
        repeats=True)

    x_fplo_in_cpa = SubSection(
        sub_section=SectionProxy('x_fplo_in_cpa'),
        repeats=True)

    x_fplo_in_numerics = SubSection(
        sub_section=SectionProxy('x_fplo_in_numerics'),
        repeats=True)

    x_fplo_in_LSDA_U = SubSection(
        sub_section=SectionProxy('x_fplo_in_LSDA_U'),
        repeats=True)

    x_fplo_in_OPC = SubSection(
        sub_section=SectionProxy('x_fplo_in_OPC'),
        repeats=True)

    x_fplo_in_Advanced_output = SubSection(
        sub_section=SectionProxy('x_fplo_in_Advanced_output'),
        repeats=True)


class x_fplo_in_header(MSection):
    '''
    FPLO input section x_fplo_in.header
    '''

    m_def = Section(validate=False)

    x_fplo_in_header_compound = Quantity(
        type=str,
        shape=[],
        description='''
        FPLO input x_fplo_in.header.compound
        ''')

    x_fplo_in_header_version = SubSection(
        sub_section=SectionProxy('x_fplo_in_header_version'),
        repeats=True)

    x_fplo_in_header_last_changes = SubSection(
        sub_section=SectionProxy('x_fplo_in_header_last_changes'),
        repeats=True)


class x_fplo_in_header_version(MSection):
    '''
    FPLO input x_fplo_in.header.version
    '''

    m_def = Section(validate=False)

    x_fplo_in_header_version_mainversion = Quantity(
        type=str,
        shape=[],
        description='''
        FPLO input x_fplo_in.header.version.mainversion
        ''')

    x_fplo_in_header_version_subversion = Quantity(
        type=str,
        shape=[],
        description='''
        FPLO input x_fplo_in.header.version.subversion
        ''')


class x_fplo_in_header_last_changes(MSection):
    '''
    FPLO input x_fplo_in.header.last_changes
    '''

    m_def = Section(validate=False)

    x_fplo_in_header_last_changes_hostname = Quantity(
        type=str,
        shape=[],
        description='''
        FPLO input x_fplo_in.header.last_changes.hostname
        ''')

    x_fplo_in_header_last_changes_date = Quantity(
        type=str,
        shape=[],
        description='''
        FPLO input x_fplo_in.header.last_changes.date
        ''')

    x_fplo_in_header_last_changes_by = Quantity(
        type=str,
        shape=[],
        description='''
        FPLO input x_fplo_in.header.last_changes.by
        ''')


class x_fplo_in_structure_information(MSection):
    '''
    FPLO input section x_fplo_in.structure_information
    '''

    m_def = Section(validate=False)

    x_fplo_in_structure_information_subgroupgenerators = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.structure_information.subgroupgenerators
        ''')

    x_fplo_in_structure_information_lattice_constants = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.structure_information.lattice_constants
        ''')

    x_fplo_in_structure_information_axis_angles = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.structure_information.axis_angles
        ''')

    x_fplo_in_structure_information_max_L = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.structure_information.max_L
        ''')

    x_fplo_in_structure_information_nsort = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.structure_information.nsort
        ''')

    x_fplo_in_structure_information_structure_type = SubSection(
        sub_section=SectionProxy('x_fplo_in_structure_information_structure_type'),
        repeats=True)

    x_fplo_in_structure_information_spacegroup = SubSection(
        sub_section=SectionProxy('x_fplo_in_structure_information_spacegroup'),
        repeats=True)

    x_fplo_in_structure_information_lengthunit = SubSection(
        sub_section=SectionProxy('x_fplo_in_structure_information_lengthunit'),
        repeats=True)

    x_fplo_in_structure_information_wyckoff_positions = SubSection(
        sub_section=SectionProxy('x_fplo_in_structure_information_wyckoff_positions'),
        repeats=True)


class x_fplo_in_structure_information_structure_type(MSection):
    '''
    FPLO input x_fplo_in.structure_information.structure_type
    '''

    m_def = Section(validate=False)

    x_fplo_in_structure_information_structure_type_type = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.structure_information.structure_type.type
        ''')

    x_fplo_in_structure_information_structure_type_description = Quantity(
        type=str,
        shape=[],
        description='''
        FPLO input x_fplo_in.structure_information.structure_type.description
        ''')


class x_fplo_in_structure_information_spacegroup(MSection):
    '''
    FPLO input x_fplo_in.structure_information.spacegroup
    '''

    m_def = Section(validate=False)

    x_fplo_in_structure_information_spacegroup_number = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.structure_information.spacegroup.number
        ''')

    x_fplo_in_structure_information_spacegroup_symbol = Quantity(
        type=str,
        shape=[],
        description='''
        FPLO input x_fplo_in.structure_information.spacegroup.symbol
        ''')


class x_fplo_in_structure_information_lengthunit(MSection):
    '''
    FPLO input x_fplo_in.structure_information.lengthunit
    '''

    m_def = Section(validate=False)

    x_fplo_in_structure_information_lengthunit_type = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.structure_information.lengthunit.type
        ''')

    x_fplo_in_structure_information_lengthunit_description = Quantity(
        type=str,
        shape=[],
        description='''
        FPLO input x_fplo_in.structure_information.lengthunit.description
        ''')


class x_fplo_in_structure_information_wyckoff_positions(MSection):
    '''
    FPLO input x_fplo_in.structure_information.wyckoff_positions
    '''

    m_def = Section(validate=False)

    x_fplo_in_structure_information_wyckoff_positions_element = Quantity(
        type=str,
        shape=[],
        description='''
        FPLO input x_fplo_in.structure_information.wyckoff_positions.element
        ''')

    x_fplo_in_structure_information_wyckoff_positions_tau = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.structure_information.wyckoff_positions.tau
        ''')


class x_fplo_in_structure_dependend(MSection):
    '''
    FPLO input section x_fplo_in.structure_dependend
    '''

    m_def = Section(validate=False)

    x_fplo_in_structure_dependend_concentrations = SubSection(
        sub_section=SectionProxy('x_fplo_in_structure_dependend_concentrations'),
        repeats=True)

    x_fplo_in_structure_dependend_initial_spin_split = SubSection(
        sub_section=SectionProxy('x_fplo_in_structure_dependend_initial_spin_split'),
        repeats=True)

    x_fplo_in_structure_dependend_core_occupation = SubSection(
        sub_section=SectionProxy('x_fplo_in_structure_dependend_core_occupation'),
        repeats=True)

    x_fplo_in_structure_dependend_special_sympoints = SubSection(
        sub_section=SectionProxy('x_fplo_in_structure_dependend_special_sympoints'),
        repeats=True)


class x_fplo_in_structure_dependend_concentrations(MSection):
    '''
    FPLO input x_fplo_in.structure_dependend.concentrations
    '''

    m_def = Section(validate=False)

    x_fplo_in_structure_dependend_concentrations_atom = Quantity(
        type=str,
        shape=[],
        description='''
        FPLO input x_fplo_in.structure_dependend.concentrations.atom
        ''')

    x_fplo_in_structure_dependend_concentrations_concentration = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.structure_dependend.concentrations.concentration
        ''')


class x_fplo_in_structure_dependend_initial_spin_split(MSection):
    '''
    FPLO input x_fplo_in.structure_dependend.initial_spin_split
    '''

    m_def = Section(validate=False)

    x_fplo_in_structure_dependend_initial_spin_split_element = Quantity(
        type=str,
        shape=[],
        description='''
        FPLO input x_fplo_in.structure_dependend.initial_spin_split.element
        ''')

    x_fplo_in_structure_dependend_initial_spin_split_split = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.structure_dependend.initial_spin_split.split
        ''')


class x_fplo_in_structure_dependend_core_occupation(MSection):
    '''
    FPLO input x_fplo_in.structure_dependend.core_occupation
    '''

    m_def = Section(validate=False)

    x_fplo_in_structure_dependend_core_occupation_sort = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.structure_dependend.core_occupation.sort
        ''')

    x_fplo_in_structure_dependend_core_occupation_state = Quantity(
        type=str,
        shape=[],
        description='''
        FPLO input x_fplo_in.structure_dependend.core_occupation.state
        ''')

    x_fplo_in_structure_dependend_core_occupation_spinup = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.structure_dependend.core_occupation.spinup
        ''')

    x_fplo_in_structure_dependend_core_occupation_spindn = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.structure_dependend.core_occupation.spindn
        ''')


class x_fplo_in_structure_dependend_special_sympoints(MSection):
    '''
    FPLO input x_fplo_in.structure_dependend.special_sympoints
    '''

    m_def = Section(validate=False)

    x_fplo_in_structure_dependend_special_sympoints_label = Quantity(
        type=str,
        shape=[],
        description='''
        FPLO input x_fplo_in.structure_dependend.special_sympoints.label
        ''')

    x_fplo_in_structure_dependend_special_sympoints_kpoint = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.structure_dependend.special_sympoints.kpoint
        ''')


class x_fplo_in_mesh(MSection):
    '''
    FPLO input section x_fplo_in.mesh
    '''

    m_def = Section(validate=False)

    x_fplo_in_mesh_radial_mesh = SubSection(
        sub_section=SectionProxy('x_fplo_in_mesh_radial_mesh'),
        repeats=True)

    x_fplo_in_mesh_atom_radial_mesh = SubSection(
        sub_section=SectionProxy('x_fplo_in_mesh_atom_radial_mesh'),
        repeats=True)


class x_fplo_in_mesh_radial_mesh(MSection):
    '''
    FPLO input x_fplo_in.mesh.radial_mesh
    '''

    m_def = Section(validate=False)

    x_fplo_in_mesh_radial_mesh_nr = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.mesh.radial_mesh.nr
        ''')

    x_fplo_in_mesh_radial_mesh_rmin = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.mesh.radial_mesh.rmin
        ''')

    x_fplo_in_mesh_radial_mesh_rmax = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.mesh.radial_mesh.rmax
        ''')

    x_fplo_in_mesh_radial_mesh_rmax_factor = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.mesh.radial_mesh.rmax_factor
        ''')


class x_fplo_in_mesh_atom_radial_mesh(MSection):
    '''
    FPLO input x_fplo_in.mesh.atom_radial_mesh
    '''

    m_def = Section(validate=False)

    x_fplo_in_mesh_atom_radial_mesh_nr = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.mesh.atom_radial_mesh.nr
        ''')

    x_fplo_in_mesh_atom_radial_mesh_rmin = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.mesh.atom_radial_mesh.rmin
        ''')

    x_fplo_in_mesh_atom_radial_mesh_rmax = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.mesh.atom_radial_mesh.rmax
        ''')


class x_fplo_in_brillouin(MSection):
    '''
    FPLO input section x_fplo_in.brillouin
    '''

    m_def = Section(validate=False)

    x_fplo_in_brillouin_bzone_kT = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.brillouin.bzone_kT
        ''')

    x_fplo_in_brillouin_nband = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.brillouin.nband
        ''')

    x_fplo_in_brillouin_bzone_integration = SubSection(
        sub_section=SectionProxy('x_fplo_in_brillouin_bzone_integration'),
        repeats=True)

    x_fplo_in_brillouin_mp_bzone_integration = SubSection(
        sub_section=SectionProxy('x_fplo_in_brillouin_mp_bzone_integration'),
        repeats=True)

    x_fplo_in_brillouin_bzone_method = SubSection(
        sub_section=SectionProxy('x_fplo_in_brillouin_bzone_method'),
        repeats=True)


class x_fplo_in_brillouin_bzone_integration(MSection):
    '''
    FPLO input x_fplo_in.brillouin.bzone_integration
    '''

    m_def = Section(validate=False)

    x_fplo_in_brillouin_bzone_integration_metal = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.brillouin.bzone_integration.metal
        ''')

    x_fplo_in_brillouin_bzone_integration_nkxyz = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.brillouin.bzone_integration.nkxyz
        ''')


class x_fplo_in_brillouin_mp_bzone_integration(MSection):
    '''
    FPLO input x_fplo_in.brillouin.mp_bzone_integration
    '''

    m_def = Section(validate=False)

    x_fplo_in_brillouin_mp_bzone_integration_ne = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.brillouin.mp_bzone_integration.ne
        ''')

    x_fplo_in_brillouin_mp_bzone_integration_range = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.brillouin.mp_bzone_integration.range
        ''')

    x_fplo_in_brillouin_mp_bzone_integration_width = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.brillouin.mp_bzone_integration.width
        ''')

    x_fplo_in_brillouin_mp_bzone_integration_norder = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.brillouin.mp_bzone_integration.norder
        ''')


class x_fplo_in_brillouin_bzone_method(MSection):
    '''
    FPLO input x_fplo_in.brillouin.bzone_method
    '''

    m_def = Section(validate=False)

    x_fplo_in_brillouin_bzone_method_type = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.brillouin.bzone_method.type
        ''')

    x_fplo_in_brillouin_bzone_method_description = Quantity(
        type=str,
        shape=[],
        description='''
        FPLO input x_fplo_in.brillouin.bzone_method.description
        ''')


class x_fplo_in_bandstructure_plot(MSection):
    '''
    FPLO input section x_fplo_in.bandstructure_plot
    '''

    m_def = Section(validate=False)

    x_fplo_in_bandstructure_plot_bandplot_control = SubSection(
        sub_section=SectionProxy('x_fplo_in_bandstructure_plot_bandplot_control'),
        repeats=True)

    x_fplo_in_bandstructure_plot_bandweight_control = SubSection(
        sub_section=SectionProxy('x_fplo_in_bandstructure_plot_bandweight_control'),
        repeats=True)


class x_fplo_in_bandstructure_plot_bandplot_control(MSection):
    '''
    FPLO input x_fplo_in.bandstructure_plot.bandplot_control
    '''

    m_def = Section(validate=False)

    x_fplo_in_bandstructure_plot_bandplot_control_bandplot = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.bandstructure_plot.bandplot_control.bandplot
        ''')

    x_fplo_in_bandstructure_plot_bandplot_control_read_sympoints = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.bandstructure_plot.bandplot_control.read_sympoints
        ''')

    x_fplo_in_bandstructure_plot_bandplot_control_ndivisions = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.bandstructure_plot.bandplot_control.ndivisions
        ''')

    x_fplo_in_bandstructure_plot_bandplot_control_emin = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.bandstructure_plot.bandplot_control.emin
        ''')

    x_fplo_in_bandstructure_plot_bandplot_control_emax = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.bandstructure_plot.bandplot_control.emax
        ''')

    x_fplo_in_bandstructure_plot_bandplot_control_nptdos = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.bandstructure_plot.bandplot_control.nptdos
        ''')

    x_fplo_in_bandstructure_plot_bandplot_control_plot_idos = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.bandstructure_plot.bandplot_control.plot_idos
        ''')

    x_fplo_in_bandstructure_plot_bandplot_control_plot_ndos = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.bandstructure_plot.bandplot_control.plot_ndos
        ''')

    x_fplo_in_bandstructure_plot_bandplot_control_restrict_bands_to_window = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.bandstructure_plot.bandplot_control.restrict_bands_to_window
        ''')

    x_fplo_in_bandstructure_plot_bandplot_control_coeffout = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.bandstructure_plot.bandplot_control.coeffout
        ''')


class x_fplo_in_bandstructure_plot_bandweight_control(MSection):
    '''
    FPLO input x_fplo_in.bandstructure_plot.bandweight_control
    '''

    m_def = Section(validate=False)

    x_fplo_in_bandstructure_plot_bandweight_control_bandweights = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.bandstructure_plot.bandweight_control.bandweights
        ''')

    x_fplo_in_bandstructure_plot_bandweight_control_bweight_rot = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.bandstructure_plot.bandweight_control.bweight_rot
        ''')

    x_fplo_in_bandstructure_plot_bandweight_control_z_axis = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.bandstructure_plot.bandweight_control.z_axis
        ''')

    x_fplo_in_bandstructure_plot_bandweight_control_x_axis = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.bandstructure_plot.bandweight_control.x_axis
        ''')

    x_fplo_in_bandstructure_plot_bandweight_control_bwdfilename = Quantity(
        type=str,
        shape=[],
        description='''
        FPLO input x_fplo_in.bandstructure_plot.bandweight_control.bwdfilename
        ''')

    x_fplo_in_bandstructure_plot_bandweight_control_frelprojection = SubSection(
        sub_section=SectionProxy('x_fplo_in_bandstructure_plot_bandweight_control_frelprojection'),
        repeats=True)


class x_fplo_in_bandstructure_plot_bandweight_control_frelprojection(MSection):
    '''
    FPLO input x_fplo_in.bandstructure_plot.bandweight_control.frelprojection
    '''

    m_def = Section(validate=False)

    x_fplo_in_bandstructure_plot_bandweight_control_frelprojection_type = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.bandstructure_plot.bandweight_control.frelprojection.type
        ''')

    x_fplo_in_bandstructure_plot_bandweight_control_frelprojection_description = Quantity(
        type=str,
        shape=[],
        description='''
        FPLO input
        x_fplo_in.bandstructure_plot.bandweight_control.frelprojection.description
        ''')


class x_fplo_in_iteration_control(MSection):
    '''
    FPLO input section x_fplo_in.iteration_control
    '''

    m_def = Section(validate=False)

    x_fplo_in_iteration_control_etot_tolerance = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.iteration_control.etot_tolerance
        ''')

    x_fplo_in_iteration_control_iteration_control = SubSection(
        sub_section=SectionProxy('x_fplo_in_iteration_control_iteration_control'),
        repeats=True)

    x_fplo_in_iteration_control_iteration_version = SubSection(
        sub_section=SectionProxy('x_fplo_in_iteration_control_iteration_version'),
        repeats=True)

    x_fplo_in_iteration_control_iteration_convergence_condition = SubSection(
        sub_section=SectionProxy('x_fplo_in_iteration_control_iteration_convergence_condition'),
        repeats=True)

    x_fplo_in_iteration_control_iterationvector_ratio = SubSection(
        sub_section=SectionProxy('x_fplo_in_iteration_control_iterationvector_ratio'),
        repeats=True)


class x_fplo_in_iteration_control_iteration_control(MSection):
    '''
    FPLO input x_fplo_in.iteration_control.iteration_control
    '''

    m_def = Section(validate=False)

    x_fplo_in_iteration_control_iteration_control_steps = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.iteration_control.iteration_control.steps
        ''')

    x_fplo_in_iteration_control_iteration_control_tolerance = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.iteration_control.iteration_control.tolerance
        ''')

    x_fplo_in_iteration_control_iteration_control_mixing = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.iteration_control.iteration_control.mixing
        ''')

    x_fplo_in_iteration_control_iteration_control_maxdim = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.iteration_control.iteration_control.maxdim
        ''')

    x_fplo_in_iteration_control_iteration_control_progress = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.iteration_control.iteration_control.progress
        ''')


class x_fplo_in_iteration_control_iteration_version(MSection):
    '''
    FPLO input x_fplo_in.iteration_control.iteration_version
    '''

    m_def = Section(validate=False)

    x_fplo_in_iteration_control_iteration_version_scheme = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.iteration_control.iteration_version.scheme
        ''')

    x_fplo_in_iteration_control_iteration_version_description = Quantity(
        type=str,
        shape=[],
        description='''
        FPLO input x_fplo_in.iteration_control.iteration_version.description
        ''')


class x_fplo_in_iteration_control_iteration_convergence_condition(MSection):
    '''
    FPLO input x_fplo_in.iteration_control.iteration_convergence_condition
    '''

    m_def = Section(validate=False)

    x_fplo_in_iteration_control_iteration_convergence_condition_type = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.iteration_control.iteration_convergence_condition.type
        ''')

    x_fplo_in_iteration_control_iteration_convergence_condition_description = Quantity(
        type=str,
        shape=[],
        description='''
        FPLO input x_fplo_in.iteration_control.iteration_convergence_condition.description
        ''')


class x_fplo_in_iteration_control_iterationvector_ratio(MSection):
    '''
    FPLO input x_fplo_in.iteration_control.iterationvector_ratio
    '''

    m_def = Section(validate=False)

    x_fplo_in_iteration_control_iterationvector_ratio_U = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.iteration_control.iterationvector_ratio.U
        ''')


class x_fplo_in_forces(MSection):
    '''
    FPLO input section x_fplo_in.forces
    '''

    m_def = Section(validate=False)

    x_fplo_in_forces_force_in_each_step = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.forces.force_in_each_step
        ''')

    x_fplo_in_forces_approx_nodndL_ewald = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.forces.approx_nodndL_ewald
        ''')

    x_fplo_in_forces_geomopt_sites = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.forces.geomopt_sites
        ''')

    x_fplo_in_forces_force_iteration_control = SubSection(
        sub_section=SectionProxy('x_fplo_in_forces_force_iteration_control'),
        repeats=True)

    x_fplo_in_forces_force_iteration_version = SubSection(
        sub_section=SectionProxy('x_fplo_in_forces_force_iteration_version'),
        repeats=True)

    x_fplo_in_forces_force_mode = SubSection(
        sub_section=SectionProxy('x_fplo_in_forces_force_mode'),
        repeats=True)


class x_fplo_in_forces_force_iteration_control(MSection):
    '''
    FPLO input x_fplo_in.forces.force_iteration_control
    '''

    m_def = Section(validate=False)

    x_fplo_in_forces_force_iteration_control_steps = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.forces.force_iteration_control.steps
        ''')

    x_fplo_in_forces_force_iteration_control_tolerance = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.forces.force_iteration_control.tolerance
        ''')

    x_fplo_in_forces_force_iteration_control_maxdim = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.forces.force_iteration_control.maxdim
        ''')


class x_fplo_in_forces_force_iteration_version(MSection):
    '''
    FPLO input x_fplo_in.forces.force_iteration_version
    '''

    m_def = Section(validate=False)

    x_fplo_in_forces_force_iteration_version_scheme = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.forces.force_iteration_version.scheme
        ''')

    x_fplo_in_forces_force_iteration_version_description = Quantity(
        type=str,
        shape=[],
        description='''
        FPLO input x_fplo_in.forces.force_iteration_version.description
        ''')


class x_fplo_in_forces_force_mode(MSection):
    '''
    FPLO input x_fplo_in.forces.force_mode
    '''

    m_def = Section(validate=False)

    x_fplo_in_forces_force_mode_mode = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.forces.force_mode.mode
        ''')

    x_fplo_in_forces_force_mode_description = Quantity(
        type=str,
        shape=[],
        description='''
        FPLO input x_fplo_in.forces.force_mode.description
        ''')


class x_fplo_in_options(MSection):
    '''
    FPLO input section x_fplo_in.options
    '''

    m_def = Section(validate=False)

    x_fplo_in_options_ex_field_strength = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.options.ex_field_strength
        ''')

    x_fplo_in_options_quantization_axis = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.options.quantization_axis
        ''')

    x_fplo_in_options_calc_etot = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.options.calc_etot
        ''')

    x_fplo_in_options_spin = SubSection(
        sub_section=SectionProxy('x_fplo_in_options_spin'),
        repeats=True)

    x_fplo_in_options_xc_potential = SubSection(
        sub_section=SectionProxy('x_fplo_in_options_xc_potential'),
        repeats=True)

    x_fplo_in_options_relativistic = SubSection(
        sub_section=SectionProxy('x_fplo_in_options_relativistic'),
        repeats=True)

    x_fplo_in_options_nuclear_model = SubSection(
        sub_section=SectionProxy('x_fplo_in_options_nuclear_model'),
        repeats=True)

    x_fplo_in_options_charges = SubSection(
        sub_section=SectionProxy('x_fplo_in_options_charges'),
        repeats=True)

    x_fplo_in_options_spin_pop_type = SubSection(
        sub_section=SectionProxy('x_fplo_in_options_spin_pop_type'),
        repeats=True)

    x_fplo_in_options_options = SubSection(
        sub_section=SectionProxy('x_fplo_in_options_options'),
        repeats=True)

    x_fplo_in_options_verbosity_level = SubSection(
        sub_section=SectionProxy('x_fplo_in_options_verbosity_level'),
        repeats=True)

    x_fplo_in_options_fsmoment = SubSection(
        sub_section=SectionProxy('x_fplo_in_options_fsmoment'),
        repeats=True)


class x_fplo_in_options_spin(MSection):
    '''
    FPLO input x_fplo_in.options.spin
    '''

    m_def = Section(validate=False)

    x_fplo_in_options_spin_mspin = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.options.spin.mspin
        ''')

    x_fplo_in_options_spin_initial_spin_split = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.options.spin.initial_spin_split
        ''')


class x_fplo_in_options_xc_potential(MSection):
    '''
    FPLO input x_fplo_in.options.xc_potential
    '''

    m_def = Section(validate=False)

    x_fplo_in_options_xc_potential_type = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.options.xc_potential.type
        ''')

    x_fplo_in_options_xc_potential_description = Quantity(
        type=str,
        shape=[],
        description='''
        FPLO input x_fplo_in.options.xc_potential.description
        ''')


class x_fplo_in_options_relativistic(MSection):
    '''
    FPLO input x_fplo_in.options.relativistic
    '''

    m_def = Section(validate=False)

    x_fplo_in_options_relativistic_type = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.options.relativistic.type
        ''')

    x_fplo_in_options_relativistic_description = Quantity(
        type=str,
        shape=[],
        description='''
        FPLO input x_fplo_in.options.relativistic.description
        ''')


class x_fplo_in_options_nuclear_model(MSection):
    '''
    FPLO input x_fplo_in.options.nuclear_model
    '''

    m_def = Section(validate=False)

    x_fplo_in_options_nuclear_model_type = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.options.nuclear_model.type
        ''')

    x_fplo_in_options_nuclear_model_description = Quantity(
        type=str,
        shape=[],
        description='''
        FPLO input x_fplo_in.options.nuclear_model.description
        ''')


class x_fplo_in_options_charges(MSection):
    '''
    FPLO input x_fplo_in.options.charges
    '''

    m_def = Section(validate=False)

    x_fplo_in_options_charges_ionicity = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.options.charges.ionicity
        ''')

    x_fplo_in_options_charges_make_vca = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.options.charges.make_vca
        ''')

    x_fplo_in_options_charges_chargemode = SubSection(
        sub_section=SectionProxy('x_fplo_in_options_charges_chargemode'),
        repeats=True)

    x_fplo_in_options_charges_vca = SubSection(
        sub_section=SectionProxy('x_fplo_in_options_charges_vca'),
        repeats=True)


class x_fplo_in_options_charges_chargemode(MSection):
    '''
    FPLO input x_fplo_in.options.charges.chargemode
    '''

    m_def = Section(validate=False)

    x_fplo_in_options_charges_chargemode_type = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.options.charges.chargemode.type
        ''')

    x_fplo_in_options_charges_chargemode_description = Quantity(
        type=str,
        shape=[],
        description='''
        FPLO input x_fplo_in.options.charges.chargemode.description
        ''')


class x_fplo_in_options_charges_vca(MSection):
    '''
    FPLO input x_fplo_in.options.charges.vca
    '''

    m_def = Section(validate=False)

    x_fplo_in_options_charges_vca_sort = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.options.charges.vca.sort
        ''')

    x_fplo_in_options_charges_vca_Z = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.options.charges.vca.Z
        ''')


class x_fplo_in_options_spin_pop_type(MSection):
    '''
    FPLO input x_fplo_in.options.spin_pop_type
    '''

    m_def = Section(validate=False)

    x_fplo_in_options_spin_pop_type_type = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.options.spin_pop_type.type
        ''')

    x_fplo_in_options_spin_pop_type_description = Quantity(
        type=str,
        shape=[],
        description='''
        FPLO input x_fplo_in.options.spin_pop_type.description
        ''')


class x_fplo_in_options_options(MSection):
    '''
    FPLO input x_fplo_in.options.options
    '''

    m_def = Section(validate=False)

    x_fplo_in_options_options_CALC_DOS = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.options.options.CALC_DOS
        ''')

    x_fplo_in_options_options_FULLBZ = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.options.options.FULLBZ
        ''')

    x_fplo_in_options_options_CALC_PLASMON_FREQ = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.options.options.CALC_PLASMON_FREQ
        ''')

    x_fplo_in_options_options_EMPTY_LATTICE_TEST = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.options.options.EMPTY_LATTICE_TEST
        ''')

    x_fplo_in_options_options_NO_DOS = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.options.options.NO_DOS
        ''')

    x_fplo_in_options_options_PLOT_REALFUNC = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.options.options.PLOT_REALFUNC
        ''')

    x_fplo_in_options_options_PLOT_BASIS = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.options.options.PLOT_BASIS
        ''')

    x_fplo_in_options_options_TEST_LOI = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.options.options.TEST_LOI
        ''')

    x_fplo_in_options_options_TEST_DIAGNO = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.options.options.TEST_DIAGNO
        ''')

    x_fplo_in_options_options_TEST_SYMMETRIZATION = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.options.options.TEST_SYMMETRIZATION
        ''')

    x_fplo_in_options_options_TEST_HS_SYM = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.options.options.TEST_HS_SYM
        ''')

    x_fplo_in_options_options_PROT_PRINT_BASIS = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.options.options.PROT_PRINT_BASIS
        ''')

    x_fplo_in_options_options_PROT_MAKELATTICE = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.options.options.PROT_MAKELATTICE
        ''')

    x_fplo_in_options_options_PROT_STRUCTURE_PRNT = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.options.options.PROT_STRUCTURE_PRNT
        ''')

    x_fplo_in_options_options_PROT_TCI = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.options.options.PROT_TCI
        ''')

    x_fplo_in_options_options_NO_SYMMETRYTEST = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.options.options.NO_SYMMETRYTEST
        ''')

    x_fplo_in_options_options_NO_POTENTIAL = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.options.options.NO_POTENTIAL
        ''')

    x_fplo_in_options_options_NO_CORE = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.options.options.NO_CORE
        ''')

    x_fplo_in_options_options_NO_POPANALYSIS = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.options.options.NO_POPANALYSIS
        ''')

    x_fplo_in_options_options_NO_LOI = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.options.options.NO_LOI
        ''')

    x_fplo_in_options_options_NO_BASIS = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.options.options.NO_BASIS
        ''')

    x_fplo_in_options_options_NO_EFCH = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.options.options.NO_EFCH
        ''')


class x_fplo_in_options_verbosity_level(MSection):
    '''
    FPLO input x_fplo_in.options.verbosity_level
    '''

    m_def = Section(validate=False)

    x_fplo_in_options_verbosity_level_type = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.options.verbosity_level.type
        ''')

    x_fplo_in_options_verbosity_level_description = Quantity(
        type=str,
        shape=[],
        description='''
        FPLO input x_fplo_in.options.verbosity_level.description
        ''')


class x_fplo_in_options_fsmoment(MSection):
    '''
    FPLO input x_fplo_in.options.fsmoment
    '''

    m_def = Section(validate=False)

    x_fplo_in_options_fsmoment_moment = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.options.fsmoment.moment
        ''')

    x_fplo_in_options_fsmoment_fsm = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.options.fsmoment.fsm
        ''')


class x_fplo_in_cpa(MSection):
    '''
    FPLO input section x_fplo_in.cpa
    '''

    m_def = Section(validate=False)

    x_fplo_in_cpa_cpa_control = SubSection(
        sub_section=SectionProxy('x_fplo_in_cpa_cpa_control'),
        repeats=True)

    x_fplo_in_cpa_cpa_fermi_control = SubSection(
        sub_section=SectionProxy('x_fplo_in_cpa_cpa_fermi_control'),
        repeats=True)

    x_fplo_in_cpa_cpa_fermi_method = SubSection(
        sub_section=SectionProxy('x_fplo_in_cpa_cpa_fermi_method'),
        repeats=True)

    x_fplo_in_cpa_cpa_dos = SubSection(
        sub_section=SectionProxy('x_fplo_in_cpa_cpa_dos'),
        repeats=True)

    x_fplo_in_cpa_cpa_bloch_spectral_density = SubSection(
        sub_section=SectionProxy('x_fplo_in_cpa_cpa_bloch_spectral_density'),
        repeats=True)


class x_fplo_in_cpa_cpa_control(MSection):
    '''
    FPLO input x_fplo_in.cpa.cpa_control
    '''

    m_def = Section(validate=False)

    x_fplo_in_cpa_cpa_control_emin0 = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.cpa.cpa_control.emin0
        ''')

    x_fplo_in_cpa_cpa_control_emax0 = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.cpa.cpa_control.emax0
        ''')

    x_fplo_in_cpa_cpa_control_nec = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.cpa.cpa_control.nec
        ''')

    x_fplo_in_cpa_cpa_control_max_se_loops = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.cpa.cpa_control.max_se_loops
        ''')

    x_fplo_in_cpa_cpa_control_eimag = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.cpa.cpa_control.eimag
        ''')


class x_fplo_in_cpa_cpa_fermi_control(MSection):
    '''
    FPLO input x_fplo_in.cpa.cpa_fermi_control
    '''

    m_def = Section(validate=False)

    x_fplo_in_cpa_cpa_fermi_control_efermi0 = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.cpa.cpa_fermi_control.efermi0
        ''')

    x_fplo_in_cpa_cpa_fermi_control_slop_0 = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.cpa.cpa_fermi_control.slop_0
        ''')

    x_fplo_in_cpa_cpa_fermi_control_slop_min = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.cpa.cpa_fermi_control.slop_min
        ''')

    x_fplo_in_cpa_cpa_fermi_control_max_ef_loops = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.cpa.cpa_fermi_control.max_ef_loops
        ''')


class x_fplo_in_cpa_cpa_fermi_method(MSection):
    '''
    FPLO input x_fplo_in.cpa.cpa_fermi_method
    '''

    m_def = Section(validate=False)

    x_fplo_in_cpa_cpa_fermi_method_type = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.cpa.cpa_fermi_method.type
        ''')

    x_fplo_in_cpa_cpa_fermi_method_description = Quantity(
        type=str,
        shape=[],
        description='''
        FPLO input x_fplo_in.cpa.cpa_fermi_method.description
        ''')


class x_fplo_in_cpa_cpa_dos(MSection):
    '''
    FPLO input x_fplo_in.cpa.cpa_dos
    '''

    m_def = Section(validate=False)

    x_fplo_in_cpa_cpa_dos_ne = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.cpa.cpa_dos.ne
        ''')

    x_fplo_in_cpa_cpa_dos_eimag = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.cpa.cpa_dos.eimag
        ''')


class x_fplo_in_cpa_cpa_bloch_spectral_density(MSection):
    '''
    FPLO input x_fplo_in.cpa.cpa_bloch_spectral_density
    '''

    m_def = Section(validate=False)

    x_fplo_in_cpa_cpa_bloch_spectral_density_ne = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.cpa.cpa_bloch_spectral_density.ne
        ''')

    x_fplo_in_cpa_cpa_bloch_spectral_density_eimag = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.cpa.cpa_bloch_spectral_density.eimag
        ''')


class x_fplo_in_numerics(MSection):
    '''
    FPLO input section x_fplo_in.numerics
    '''

    m_def = Section(validate=False)

    x_fplo_in_numerics_nfft_ewp_per_site = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.numerics.nfft_ewp_per_site
        ''')

    x_fplo_in_numerics_interpolation = SubSection(
        sub_section=SectionProxy('x_fplo_in_numerics_interpolation'),
        repeats=True)

    x_fplo_in_numerics_one_center_integrals = SubSection(
        sub_section=SectionProxy('x_fplo_in_numerics_one_center_integrals'),
        repeats=True)

    x_fplo_in_numerics_coulomb_energy_calc = SubSection(
        sub_section=SectionProxy('x_fplo_in_numerics_coulomb_energy_calc'),
        repeats=True)

    x_fplo_in_numerics_overlap_density_calc = SubSection(
        sub_section=SectionProxy('x_fplo_in_numerics_overlap_density_calc'),
        repeats=True)

    x_fplo_in_numerics_cutoff_tolerances = SubSection(
        sub_section=SectionProxy('x_fplo_in_numerics_cutoff_tolerances'),
        repeats=True)

    x_fplo_in_numerics_ewald_parameter = SubSection(
        sub_section=SectionProxy('x_fplo_in_numerics_ewald_parameter'),
        repeats=True)

    x_fplo_in_numerics_symtest = SubSection(
        sub_section=SectionProxy('x_fplo_in_numerics_symtest'),
        repeats=True)


class x_fplo_in_numerics_interpolation(MSection):
    '''
    FPLO input x_fplo_in.numerics.interpolation
    '''

    m_def = Section(validate=False)

    x_fplo_in_numerics_interpolation_degree = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.numerics.interpolation.degree
        ''')


class x_fplo_in_numerics_one_center_integrals(MSection):
    '''
    FPLO input x_fplo_in.numerics.one_center_integrals
    '''

    m_def = Section(validate=False)

    x_fplo_in_numerics_one_center_integrals_nr = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.numerics.one_center_integrals.nr
        ''')


class x_fplo_in_numerics_coulomb_energy_calc(MSection):
    '''
    FPLO input x_fplo_in.numerics.coulomb_energy_calc
    '''

    m_def = Section(validate=False)

    x_fplo_in_numerics_coulomb_energy_calc_nxi = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.numerics.coulomb_energy_calc.nxi
        ''')

    x_fplo_in_numerics_coulomb_energy_calc_neta = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.numerics.coulomb_energy_calc.neta
        ''')


class x_fplo_in_numerics_overlap_density_calc(MSection):
    '''
    FPLO input x_fplo_in.numerics.overlap_density_calc
    '''

    m_def = Section(validate=False)

    x_fplo_in_numerics_overlap_density_calc_nr = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.numerics.overlap_density_calc.nr
        ''')

    x_fplo_in_numerics_overlap_density_calc_neta = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.numerics.overlap_density_calc.neta
        ''')


class x_fplo_in_numerics_cutoff_tolerances(MSection):
    '''
    FPLO input x_fplo_in.numerics.cutoff_tolerances
    '''

    m_def = Section(validate=False)

    x_fplo_in_numerics_cutoff_tolerances_dens = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.numerics.cutoff_tolerances.dens
        ''')

    x_fplo_in_numerics_cutoff_tolerances_pot = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.numerics.cutoff_tolerances.pot
        ''')

    x_fplo_in_numerics_cutoff_tolerances_orbital = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.numerics.cutoff_tolerances.orbital
        ''')


class x_fplo_in_numerics_ewald_parameter(MSection):
    '''
    FPLO input x_fplo_in.numerics.ewald_parameter
    '''

    m_def = Section(validate=False)

    x_fplo_in_numerics_ewald_parameter_cutoff = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.numerics.ewald_parameter.cutoff
        ''')

    x_fplo_in_numerics_ewald_parameter_eps_r = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.numerics.ewald_parameter.eps_r
        ''')

    x_fplo_in_numerics_ewald_parameter_eps_g = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.numerics.ewald_parameter.eps_g
        ''')


class x_fplo_in_numerics_symtest(MSection):
    '''
    FPLO input x_fplo_in.numerics.symtest
    '''

    m_def = Section(validate=False)

    x_fplo_in_numerics_symtest_tol = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.numerics.symtest.tol
        ''')


class x_fplo_in_LSDA_U(MSection):
    '''
    FPLO input section x_fplo_in.LSDA_U
    '''

    m_def = Section(validate=False)

    x_fplo_in_LSDA_U_make_lsdau = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.LSDA_U.make_lsdau
        ''')

    x_fplo_in_LSDA_U_lsdau_dmat_deviation = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.LSDA_U.lsdau_dmat_deviation
        ''')

    x_fplo_in_LSDA_U_lsdau_projection = SubSection(
        sub_section=SectionProxy('x_fplo_in_LSDA_U_lsdau_projection'),
        repeats=True)

    x_fplo_in_LSDA_U_lsdau_functional = SubSection(
        sub_section=SectionProxy('x_fplo_in_LSDA_U_lsdau_functional'),
        repeats=True)

    x_fplo_in_LSDA_U_lsdau_dmat_mode = SubSection(
        sub_section=SectionProxy('x_fplo_in_LSDA_U_lsdau_dmat_mode'),
        repeats=True)

    x_fplo_in_LSDA_U_lsdau_defs = SubSection(
        sub_section=SectionProxy('x_fplo_in_LSDA_U_lsdau_defs'),
        repeats=True)


class x_fplo_in_LSDA_U_lsdau_projection(MSection):
    '''
    FPLO input x_fplo_in.LSDA_U.lsdau_projection
    '''

    m_def = Section(validate=False)

    x_fplo_in_LSDA_U_lsdau_projection_type = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.LSDA_U.lsdau_projection.type
        ''')

    x_fplo_in_LSDA_U_lsdau_projection_description = Quantity(
        type=str,
        shape=[],
        description='''
        FPLO input x_fplo_in.LSDA_U.lsdau_projection.description
        ''')


class x_fplo_in_LSDA_U_lsdau_functional(MSection):
    '''
    FPLO input x_fplo_in.LSDA_U.lsdau_functional
    '''

    m_def = Section(validate=False)

    x_fplo_in_LSDA_U_lsdau_functional_type = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.LSDA_U.lsdau_functional.type
        ''')

    x_fplo_in_LSDA_U_lsdau_functional_description = Quantity(
        type=str,
        shape=[],
        description='''
        FPLO input x_fplo_in.LSDA_U.lsdau_functional.description
        ''')


class x_fplo_in_LSDA_U_lsdau_dmat_mode(MSection):
    '''
    FPLO input x_fplo_in.LSDA_U.lsdau_dmat_mode
    '''

    m_def = Section(validate=False)

    x_fplo_in_LSDA_U_lsdau_dmat_mode_type = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.LSDA_U.lsdau_dmat_mode.type
        ''')

    x_fplo_in_LSDA_U_lsdau_dmat_mode_description = Quantity(
        type=str,
        shape=[],
        description='''
        FPLO input x_fplo_in.LSDA_U.lsdau_dmat_mode.description
        ''')


class x_fplo_in_LSDA_U_lsdau_defs(MSection):
    '''
    FPLO input x_fplo_in.LSDA_U.lsdau_defs
    '''

    m_def = Section(validate=False)

    x_fplo_in_LSDA_U_lsdau_defs_sort = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.LSDA_U.lsdau_defs.sort
        ''')

    x_fplo_in_LSDA_U_lsdau_defs_state = Quantity(
        type=str,
        shape=[],
        description='''
        FPLO input x_fplo_in.LSDA_U.lsdau_defs.state
        ''')

    x_fplo_in_LSDA_U_lsdau_defs_f_slater = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.LSDA_U.lsdau_defs.f_slater
        ''')


class x_fplo_in_OPC(MSection):
    '''
    FPLO input section x_fplo_in.OPC
    '''

    m_def = Section(validate=False)

    x_fplo_in_OPC_make_opc = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.OPC.make_opc
        ''')

    x_fplo_in_OPC_opc_projection = SubSection(
        sub_section=SectionProxy('x_fplo_in_OPC_opc_projection'),
        repeats=True)

    x_fplo_in_OPC_opc_functional = SubSection(
        sub_section=SectionProxy('x_fplo_in_OPC_opc_functional'),
        repeats=True)

    x_fplo_in_OPC_opc_defs = SubSection(
        sub_section=SectionProxy('x_fplo_in_OPC_opc_defs'),
        repeats=True)


class x_fplo_in_OPC_opc_projection(MSection):
    '''
    FPLO input x_fplo_in.OPC.opc_projection
    '''

    m_def = Section(validate=False)

    x_fplo_in_OPC_opc_projection_type = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.OPC.opc_projection.type
        ''')

    x_fplo_in_OPC_opc_projection_description = Quantity(
        type=str,
        shape=[],
        description='''
        FPLO input x_fplo_in.OPC.opc_projection.description
        ''')


class x_fplo_in_OPC_opc_functional(MSection):
    '''
    FPLO input x_fplo_in.OPC.opc_functional
    '''

    m_def = Section(validate=False)

    x_fplo_in_OPC_opc_functional_type = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.OPC.opc_functional.type
        ''')

    x_fplo_in_OPC_opc_functional_description = Quantity(
        type=str,
        shape=[],
        description='''
        FPLO input x_fplo_in.OPC.opc_functional.description
        ''')


class x_fplo_in_OPC_opc_defs(MSection):
    '''
    FPLO input x_fplo_in.OPC.opc_defs
    '''

    m_def = Section(validate=False)

    x_fplo_in_OPC_opc_defs_sort = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.OPC.opc_defs.sort
        ''')

    x_fplo_in_OPC_opc_defs_state = Quantity(
        type=str,
        shape=[],
        description='''
        FPLO input x_fplo_in.OPC.opc_defs.state
        ''')


class x_fplo_in_Advanced_output(MSection):
    '''
    FPLO input section x_fplo_in.Advanced_output
    '''

    m_def = Section(validate=False)

    x_fplo_in_Advanced_output_ldossites = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.Advanced_output.ldossites
        ''')

    x_fplo_in_Advanced_output_grids_active = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.Advanced_output.grids_active
        ''')

    x_fplo_in_Advanced_output_grids_stop_after = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.Advanced_output.grids_stop_after
        ''')

    x_fplo_in_Advanced_output_grids = SubSection(
        sub_section=SectionProxy('x_fplo_in_Advanced_output_grids'),
        repeats=True)

    x_fplo_in_Advanced_output_topological_insulator = SubSection(
        sub_section=SectionProxy('x_fplo_in_Advanced_output_topological_insulator'),
        repeats=True)

    x_fplo_in_Advanced_output_optics = SubSection(
        sub_section=SectionProxy('x_fplo_in_Advanced_output_optics'),
        repeats=True)


class x_fplo_in_Advanced_output_grids(MSection):
    '''
    FPLO input x_fplo_in.Advanced_output.grids
    '''

    m_def = Section(validate=False)

    x_fplo_in_Advanced_output_grids_direction1 = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.Advanced_output.grids.direction1
        ''')

    x_fplo_in_Advanced_output_grids_direction2 = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.Advanced_output.grids.direction2
        ''')

    x_fplo_in_Advanced_output_grids_direction3 = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.Advanced_output.grids.direction3
        ''')

    x_fplo_in_Advanced_output_grids_origin = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.Advanced_output.grids.origin
        ''')

    x_fplo_in_Advanced_output_grids_subdivision = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.Advanced_output.grids.subdivision
        ''')

    x_fplo_in_Advanced_output_grids_file = Quantity(
        type=str,
        shape=[],
        description='''
        FPLO input x_fplo_in.Advanced_output.grids.file
        ''')

    x_fplo_in_Advanced_output_grids_InclPeriodicPoints = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.Advanced_output.grids.InclPeriodicPoints
        ''')

    x_fplo_in_Advanced_output_grids_createOpenDX = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.Advanced_output.grids.createOpenDX
        ''')

    x_fplo_in_Advanced_output_grids_scfwavefnctwindow = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.Advanced_output.grids.scfwavefnctwindow
        ''')

    x_fplo_in_Advanced_output_grids_basis = SubSection(
        sub_section=SectionProxy('x_fplo_in_Advanced_output_grids_basis'),
        repeats=True)

    x_fplo_in_Advanced_output_grids_quantities = SubSection(
        sub_section=SectionProxy('x_fplo_in_Advanced_output_grids_quantities'),
        repeats=True)

    x_fplo_in_Advanced_output_grids_outputdata = SubSection(
        sub_section=SectionProxy('x_fplo_in_Advanced_output_grids_outputdata'),
        repeats=True)

    x_fplo_in_Advanced_output_grids_energywindows = SubSection(
        sub_section=SectionProxy('x_fplo_in_Advanced_output_grids_energywindows'),
        repeats=True)

    x_fplo_in_Advanced_output_grids_kresolved = SubSection(
        sub_section=SectionProxy('x_fplo_in_Advanced_output_grids_kresolved'),
        repeats=True)


class x_fplo_in_Advanced_output_grids_basis(MSection):
    '''
    FPLO input x_fplo_in.Advanced_output.grids.basis
    '''

    m_def = Section(validate=False)

    x_fplo_in_Advanced_output_grids_basis_type = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.Advanced_output.grids.basis.type
        ''')

    x_fplo_in_Advanced_output_grids_basis_description = Quantity(
        type=str,
        shape=[],
        description='''
        FPLO input x_fplo_in.Advanced_output.grids.basis.description
        ''')


class x_fplo_in_Advanced_output_grids_quantities(MSection):
    '''
    FPLO input x_fplo_in.Advanced_output.grids.quantities
    '''

    m_def = Section(validate=False)

    x_fplo_in_Advanced_output_grids_quantities_type = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.Advanced_output.grids.quantities.type
        ''')

    x_fplo_in_Advanced_output_grids_quantities_description = Quantity(
        type=str,
        shape=[],
        description='''
        FPLO input x_fplo_in.Advanced_output.grids.quantities.description
        ''')


class x_fplo_in_Advanced_output_grids_outputdata(MSection):
    '''
    FPLO input x_fplo_in.Advanced_output.grids.outputdata
    '''

    m_def = Section(validate=False)

    x_fplo_in_Advanced_output_grids_outputdata_type = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.Advanced_output.grids.outputdata.type
        ''')

    x_fplo_in_Advanced_output_grids_outputdata_description = Quantity(
        type=str,
        shape=[],
        description='''
        FPLO input x_fplo_in.Advanced_output.grids.outputdata.description
        ''')


class x_fplo_in_Advanced_output_grids_energywindows(MSection):
    '''
    FPLO input x_fplo_in.Advanced_output.grids.energywindows
    '''

    m_def = Section(validate=False)

    x_fplo_in_Advanced_output_grids_energywindows_name = Quantity(
        type=str,
        shape=[],
        description='''
        FPLO input x_fplo_in.Advanced_output.grids.energywindows.name
        ''')

    x_fplo_in_Advanced_output_grids_energywindows_sections = SubSection(
        sub_section=SectionProxy('x_fplo_in_Advanced_output_grids_energywindows_sections'),
        repeats=True)


class x_fplo_in_Advanced_output_grids_energywindows_sections(MSection):
    '''
    FPLO input x_fplo_in.Advanced_output.grids.energywindows.sections
    '''

    m_def = Section(validate=False)

    x_fplo_in_Advanced_output_grids_energywindows_sections_emin = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.Advanced_output.grids.energywindows.sections.emin
        ''')

    x_fplo_in_Advanced_output_grids_energywindows_sections_emax = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.Advanced_output.grids.energywindows.sections.emax
        ''')

    x_fplo_in_Advanced_output_grids_energywindows_sections_de = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.Advanced_output.grids.energywindows.sections.de
        ''')

    x_fplo_in_Advanced_output_grids_energywindows_sections_spin = SubSection(
        sub_section=SectionProxy('x_fplo_in_Advanced_output_grids_energywindows_sections_spin'),
        repeats=True)


class x_fplo_in_Advanced_output_grids_energywindows_sections_spin(MSection):
    '''
    FPLO input x_fplo_in.Advanced_output.grids.energywindows.sections.spin
    '''

    m_def = Section(validate=False)

    x_fplo_in_Advanced_output_grids_energywindows_sections_spin_type = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.Advanced_output.grids.energywindows.sections.spin.type
        ''')

    x_fplo_in_Advanced_output_grids_energywindows_sections_spin_description = Quantity(
        type=str,
        shape=[],
        description='''
        FPLO input x_fplo_in.Advanced_output.grids.energywindows.sections.spin.description
        ''')


class x_fplo_in_Advanced_output_grids_kresolved(MSection):
    '''
    FPLO input x_fplo_in.Advanced_output.grids.kresolved
    '''

    m_def = Section(validate=False)

    x_fplo_in_Advanced_output_grids_kresolved_name = Quantity(
        type=str,
        shape=[],
        description='''
        FPLO input x_fplo_in.Advanced_output.grids.kresolved.name
        ''')

    x_fplo_in_Advanced_output_grids_kresolved_kpoint = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.Advanced_output.grids.kresolved.kpoint
        ''')

    x_fplo_in_Advanced_output_grids_kresolved_bandindices = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.Advanced_output.grids.kresolved.bandindices
        ''')

    x_fplo_in_Advanced_output_grids_kresolved_energywindow = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.Advanced_output.grids.kresolved.energywindow
        ''')


class x_fplo_in_Advanced_output_topological_insulator(MSection):
    '''
    FPLO input x_fplo_in.Advanced_output.topological_insulator
    '''

    m_def = Section(validate=False)

    x_fplo_in_Advanced_output_topological_insulator_active = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.Advanced_output.topological_insulator.active
        ''')


class x_fplo_in_Advanced_output_optics(MSection):
    '''
    FPLO input x_fplo_in.Advanced_output.optics
    '''

    m_def = Section(validate=False)

    x_fplo_in_Advanced_output_optics_active = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.Advanced_output.optics.active
        ''')

    x_fplo_in_Advanced_output_optics_jointdos = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.Advanced_output.optics.jointdos
        ''')

    x_fplo_in_Advanced_output_optics_bandoutput = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.Advanced_output.optics.bandoutput
        ''')

    x_fplo_in_Advanced_output_optics_stopafter = Quantity(
        type=bool,
        shape=[],
        description='''
        FPLO input x_fplo_in.Advanced_output.optics.stopafter
        ''')

    x_fplo_in_Advanced_output_optics_energy = SubSection(
        sub_section=SectionProxy('x_fplo_in_Advanced_output_optics_energy'),
        repeats=True)


class x_fplo_in_Advanced_output_optics_energy(MSection):
    '''
    FPLO input x_fplo_in.Advanced_output.optics.energy
    '''

    m_def = Section(validate=False)

    x_fplo_in_Advanced_output_optics_energy_ne = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        FPLO input x_fplo_in.Advanced_output.optics.energy.ne
        ''')

    x_fplo_in_Advanced_output_optics_energy_emin = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.Advanced_output.optics.energy.emin
        ''')

    x_fplo_in_Advanced_output_optics_energy_emax = Quantity(
        type=np.dtype(np.float64),
        shape=[],
        description='''
        FPLO input x_fplo_in.Advanced_output.optics.energy.emax
        ''')


class Method(simulation.method.Method):

    m_def = Section(validate=False, extends_base_section=True)

    x_fplo_in = SubSection(
        sub_section=SectionProxy('x_fplo_in'),
        repeats=True)
