# -*- coding: utf-8 -*-
structure_types_by_spacegroup = {1: [{'Notes': '-',
      'Pearsons Symbol': 'aP16',
      'Prototype': 'AsKSe2',
      'Space Group': 'P1',
      'Space Group Number': 1,
      'Strukturbericht Designation': '-',
      'Wyckoff Positions': 'a16',
      'aflow_prototype_id': 'ABC2_aP16_1_4a_4a_8a',
      'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/ABC2_aP16_1_4a_4a_8a.html',
      'atom_labels': ['As',
                      'As',
                      'As',
                      'As',
                      'K',
                      'K',
                      'K',
                      'K',
                      'Se',
                      'Se',
                      'Se',
                      'Se',
                      'Se',
                      'Se',
                      'Se',
                      'Se'],
      'atom_positions': [[1.8168765e-10,
                          8.613764600000001e-11,
                          5.143248530000001e-10],
                         [2.3958645e-11, 4.11434442e-10, 5.30716954e-10],
                         [3.100544e-12, 8.15919014e-10, 9.3755559e-11],
                         [-1.1845383e-11, 1.167786943e-09, 1.0282868e-11],
                         [3.4894612e-11, 2.8718862e-10, 1.36762142e-10],
                         [3.87756673e-10,
                          5.52519474e-10,
                          2.5059953700000003e-10],
                         [1.0859912300000001e-10,
                          8.20359369e-10,
                          4.666002490000001e-10],
                         [2.41130122e-10,
                          1.1678163310000001e-09,
                          2.7394769600000003e-10],
                         [3.57174912e-10,
                          2.2151187100000002e-10,
                          1.38153353e-10],
                         [-1.0860413600000001e-10,
                          1.109903372e-09,
                          4.17968333e-10],
                         [6.2662942e-11, 5.32378594e-10, 3.39576588e-10],
                         [-2.9901111e-11,
                          1.8797845900000003e-10,
                          4.46397438e-10],
                         [2.2661147599999998e-10,
                          8.40104779e-10,
                          1.5025084500000001e-10],
                         [-2.1292494899999998e-10,
                          4.49073326e-10,
                          5.74146948e-10],
                         [0.0, 0.0, 0.0],
                         [-2.18214959e-10, 7.95516948e-10, 4.97690802e-10]],
      'lattice_vectors': [[6.558e-10, 0.0, 0.0],
                          [-2.2969358800000001e-10,
                           1.2417345510000002e-09,
                           0.0],
                          [-1.9740983800000002e-10,
                           -1.57179078e-10,
                           6.04874577e-10]],
      'normalized_wyckoff': {'a': {'X_0': 7, 'X_1': 4, 'X_2': 4, 'X_3': 1}},
      'normalized_wysytax': {'a': {'X_0': 2, 'X_1': 1, 'X_2': 1}}},
     {'Notes': '-',
      'Pearsons Symbol': 'aP12',
      'Prototype': 'FeS2',
      'Space Group': 'P1',
      'Space Group Number': 1,
      'Strukturbericht Designation': '-',
      'Wyckoff Positions': 'a12',
      'aflow_prototype_id': 'AB2_aP12_1_4a_8a',
      'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB2_aP12_1_4a_8a.html',
      'atom_labels': ['Fe',
                      'Fe',
                      'Fe',
                      'Fe',
                      'S',
                      'S',
                      'S',
                      'S',
                      'S',
                      'S',
                      'S',
                      'S'],
      'atom_positions': [[-3.2501999999999996e-13,
                          2.7155421e-10,
                          2.7290845999999996e-10],
                         [5.417e-13, 1.0834e-12, 1.6250999999999998e-12],
                         [2.6900821999999996e-10, 5.417e-14, 2.7280012e-10],
                         [2.7090417e-10, 2.7193339999999996e-10, 5.9587e-13],
                         [6.213299e-11, 4.7972952e-10, 2.0806696999999998e-10],
                         [6.224133e-11, 3.3119537999999995e-10, 4.7918782e-10],
                         [2.0893369e-10, 6.289136999999999e-11, 4.7897114e-10],
                         [2.0893369e-10, 2.0757944e-10, 2.0801279999999998e-10],
                         [3.3319967000000003e-10, 3.3217044e-10, 3.3244129e-10],
                         [3.3330801000000004e-10, 4.8021705e-10, 6.180797e-11],
                         [4.796211799999999e-10, 6.267469e-11, 3.3276631e-10],
                         [4.796211799999999e-10,
                          2.0682105999999998e-10,
                          6.224133e-11]],
      'lattice_vectors': [[5.417e-10, 0.0, 0.0],
                          [0.0, 5.417e-10, 0.0],
                          [0.0, 0.0, 5.417e-10]],
      'normalized_wysytax': {'a': {'X_0': 2, 'X_1': 1}}}],
 2: [{'Notes': '-',
      'Pearsons Symbol': 'aP4',
      'Prototype': 'Cf',
      'Space Group': 'P1',
      'Space Group Number': 2,
      'Strukturbericht Designation': '-',
      'Wyckoff Positions': 'aci',
      'aflow_prototype_id': 'A_aP4_2_aci',
      'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_aP4_2_aci.html',
      'atom_labels': ['Cf', 'Cf', 'Cf', 'Cf'],
      'atom_positions': [[0.0, 0.0, 0.0],
                         [2.7787000000000002e-11, 3.6955700000000004e-10, 0.0],
                         [2.1377892799999999e-10,
                          1.9265115300000001e-10,
                          1.20497838e-10],
                         [-2.1377892799999999e-10,
                          -1.9265115300000001e-10,
                          -1.20497838e-10]],
      'lattice_vectors': [[3.307e-10, 0.0, 0.0],
                          [5.5574000000000004e-11, 7.391140000000001e-10, 0.0],
                          [2.3614e-11, 2.819e-12, 2.78286e-10]],
      'normalized_wysytax': {'a': {'X_0': 1},
                             'b': {'X_0': 1},
                             'i': {'X_0': 2}}},
     {'Notes': '-',
      'Pearsons Symbol': 'aP6',
      'Prototype': 'P2I4',
      'Space Group': 'P1',
      'Space Group Number': 2,
      'Strukturbericht Designation': '-',
      'Wyckoff Positions': 'i3',
      'aflow_prototype_id': 'A2B_aP6_2_2i_i',
      'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2B_aP6_2_2i_i.html',
      'atom_labels': ['P', 'P', 'I', 'I', 'I', 'I'],
      'atom_positions': [[1.6705481000000002e-11,
                          4.91033677e-10,
                          3.2467029e-10],
                         [-1.6705481000000002e-11,
                          -4.91033677e-10,
                          -3.2467029e-10],
                         [1.44853252e-10, 5.2597367e-10, 1.15703235e-10],
                         [-1.44853252e-10, -5.2597367e-10, -1.15703235e-10],
                         [1.4298048200000001e-10,
                          6.27937981e-10,
                          4.87356051e-10],
                         [-1.4298048200000001e-10,
                          -6.27937981e-10,
                          -4.87356051e-10]],
      'lattice_vectors': [[4.56e-10, 0.0, 0.0],
                          [-1.00696027e-10, 6.98782019e-10, 0.0],
                          [-2.15943322e-10, 9.6138158e-11, 7.01231728e-10]],
      'normalized_wyckoff': {'i': {'X_0': 2, 'X_1': 1}},
      'normalized_wysytax': {'i': {'X_0': 2, 'X_1': 1}}}],
 3: [{'Notes': 'found in atomistic simulations',
      'Pearsons Symbol': 'mP12',
      'Prototype': 'O2Si',
      'Space Group': 'P2',
      'Space Group Number': 3,
      'Strukturbericht Designation': '-',
      'Wyckoff Positions': 'bce5',
      'aflow_prototype_id': 'A2B_mP12_3_bc3e_2e',
      'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2B_mP12_3_bc3e_2e.html',
      'atom_labels': ['O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'Si',
                      'Si',
                      'Si',
                      'Si'],
      'atom_positions': [[-7.3184298e-11, 6.56863658e-11, 3.63766232e-10],
                         [2.08025e-10, 3.04993355e-10, 0.0],
                         [-1.77221447e-11, 3.1053088e-10, 1.37700069e-10],
                         [1.77221447e-11, 3.1053088e-10, -1.37700069e-10],
                         [6.66529868e-11, 2.95140606e-10, 4.66159151e-10],
                         [-6.66529868e-11, 2.95140606e-10, -4.66159151e-10],
                         [1.76190338e-10, 8.33973624e-11, 1.36790654e-10],
                         [-1.76190338e-10, 8.33973624e-11, -1.36790654e-10],
                         [-2.60430288e-11, 0.0, 5.06733637e-10],
                         [2.60430288e-11, 0.0, -5.06733637e-10],
                         [1.3245751e-10, 2.41834182e-10, 1.29478953e-10],
                         [-1.32472147e-10, 2.41834182e-10, -1.29406199e-10]],
      'lattice_vectors': [[4.1605e-10, 0.0, 0.0],
                          [0.0, 4.1294e-10, 0.0],
                          [-1.46368596e-10, 0.0, 7.27532464e-10]],
      'normalized_wyckoff': {'b': {'X_0': 1},
                             'c': {'X_0': 1},
                             'e': {'X_0': 6, 'X_1': 4}},
      'normalized_wysytax': {'b': {'X_0': 1},
                             'c': {'X_0': 1},
                             'e': {'X_0': 6, 'X_1': 4}}}],
 4: [{'Notes': 'high-pressure Te',
      'Pearsons Symbol': 'mP4',
      'Prototype': 'Te',
      'Space Group': 'P21',
      'Space Group Number': 4,
      'Strukturbericht Designation': '-',
      'Wyckoff Positions': 'a2',
      'aflow_prototype_id': 'A_mP4_4_2a',
      'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_mP4_4_2a.html',
      'atom_labels': ['Te', 'Te', 'Te', 'Te'],
      'atom_positions': [[6.6797285e-11, 1.72799e-10, 2.2822447700000003e-10],
                         [-6.6797285e-11, 5.48449e-10, -2.2822447700000003e-10],
                         [1.48541887e-10, 0.0, 9.509353e-12],
                         [-1.48541887e-10, 3.7565e-10, -9.509353e-12]],
      'lattice_vectors': [[3.1040000000000003e-10, 0.0, 0.0],
                          [0.0, 7.513e-10, 0.0],
                          [-2.2505655999999998e-11, 0.0, 4.7546766e-10]],
      'normalized_wyckoff': {'a': {'X_0': 1}},
      'normalized_wysytax': {'a': {'X_0': 1}}}],
 9: [{'Notes': 'monoclinic low tridymite',
      'Pearsons Symbol': 'mC144',
      'Prototype': 'O2Si',
      'Space Group': 'Cc',
      'Space Group Number': 9,
      'Strukturbericht Designation': '-',
      'Wyckoff Positions': 'a36',
      'aflow_prototype_id': 'A2B_mC144_9_24a_12a',
      'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2B_mC144_9_24a_12a.html',
      'atom_labels': ['O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'O',
                      'Si',
                      'Si',
                      'Si',
                      'Si',
                      'Si',
                      'Si',
                      'Si',
                      'Si',
                      'Si',
                      'Si',
                      'Si',
                      'Si',
                      'Si',
                      'Si',
                      'Si',
                      'Si',
                      'Si',
                      'Si',
                      'Si',
                      'Si',
                      'Si',
                      'Si',
                      'Si',
                      'Si'],
      'atom_positions': [[5.338519966554e-10,
                          1.7561231999999997e-10,
                          1.8743445089927996e-09],
                         [8.584014731554e-10,
                          -1.7561231999999997e-10,
                          7.289372069927999e-10],
                         [8.315378839372001e-10,
                          8.005119999999999e-11,
                          7.962871563503999e-10],
                         [5.069884074372002e-10,
                          -8.005119999999999e-11,
                          1.9416944583503998e-09],
                         [1.0401526978997e-09,
                          6.904416e-11,
                          1.1112741644004e-09],
                         [7.156032213997001e-10,
                          -6.904416e-11,
                          2.2566814664003997e-09],
                         [1.3035137941440003e-10,
                          7.204607999999999e-11,
                          1.1802276839807998e-09],
                         [4.549008559144e-10,
                          -7.204607999999999e-11,
                          3.48203819808e-11],
                         [3.321145957827001e-10,
                          1.7611264e-10,
                          1.5442381245564e-09],
                         [6.566640722827e-10,
                          -1.7611264e-10,
                          3.988308225564e-10],
                         [6.714046901398e-10, 7.404736e-11, 3.285028142136e-10],
                         [3.4685521363980014e-10,
                          -7.404736e-11,
                          1.4739101162135998e-09],
                         [4.2544513110110006e-10,
                          1.6810752e-10,
                          9.651201926652e-10],
                         [1.0089565460110013e-10,
                          -1.6810752e-10,
                          2.1105274946651997e-09],
                         [1.629768700967001e-10,
                          8.405375999999998e-11,
                          2.1444315508044e-09],
                         [4.875263465967e-10,
                          -8.405375999999998e-11,
                          9.990242488043998e-10],
                         [9.446520492286e-10,
                          7.254639999999996e-11,
                          1.7268160484951999e-09],
                         [1.2692015257286e-09,
                          -7.254639999999996e-11,
                          5.814087464951999e-10],
                         [-4.77424050105999e-11,
                          7.154576e-11,
                          1.6956609698807996e-09],
                         [2.7680707148940003e-10,
                          -7.154576e-11,
                          5.502536678808e-10],
                         [7.680336421808999e-10,
                          1.7060912e-10,
                          1.3394392989588001e-09],
                         [1.0925831186808998e-09,
                          -1.7060912e-10,
                          1.9403199695879998e-10],
                         [1.0335241992067e-09,
                          7.855024000000001e-11,
                          1.5142284532439998e-10],
                         [7.089747227067e-10,
                          -7.855024000000001e-11,
                          1.2968301473244e-09],
                         [-7.523246880859999e-11,
                          -5.50352e-12,
                          2.4328451094479995e-10],
                         [-3.997819453086e-10,
                          5.50352e-12,
                          1.3886918129448e-09],
                         [1.5374878396255001e-09,
                          5.5035200000000226e-12,
                          1.5233917116599998e-10],
                         [1.2129383631255002e-09,
                          -5.5035200000000226e-12,
                          1.2977464731659999e-09],
                         [7.680792126417002e-10,
                          2.5016000000000103e-12,
                          1.5373656807444e-09],
                         [1.0926286891417002e-09,
                          -2.5016000000000103e-12,
                          3.919583787444e-10],
                         [1.0264335036835002e-09,
                          2.0012799999999824e-12,
                          6.425734964219999e-10],
                         [7.018840271835002e-10,
                          -2.0012799999999824e-12,
                          1.787980798422e-09],
                         [5.224224037416e-10,
                          5.003200000000021e-13,
                          5.333016398111999e-10],
                         [1.9787292724160007e-10,
                          -5.003200000000021e-13,
                          1.6787089418112e-09],
                         [8.169748246510015e-11,
                          1.5009600000000062e-12,
                          1.9089358095131996e-09],
                         [4.062469589651001e-10,
                          -1.5009600000000062e-12,
                          7.635285075132e-10],
                         [7.801785510706e-10,
                          3.5022399999999885e-12,
                          5.493373420392e-10],
                         [4.556290745706e-10,
                          -3.5022399999999885e-12,
                          1.6947446440392e-09],
                         [-3.4799134964039995e-10,
                          5.503520000000003e-12,
                          2.1231269749872e-09],
                         [-2.3441873140400016e-11,
                          -5.503520000000003e-12,
                          9.777196729872e-10],
                         [3.370565284796001e-10,
                          2.4615744e-10,
                          2.0314943908272e-09],
                         [6.616060049796001e-10,
                          -2.4615744e-10,
                          8.860870888272e-10],
                         [6.016505235e-10,
                          2.3414976000000003e-10,
                          1.145407302e-09],
                         [9.262000000000001e-10, -2.3414976000000003e-10, 0.0],
                         [1.2850713940205999e-09,
                          4.5028800000000185e-12,
                          2.0571515143919996e-10],
                         [9.605219175206e-10,
                          -4.5028800000000185e-12,
                          1.3511224534391998e-09],
                         [-8.595153147149991e-11,
                          1.0506720000000004e-11,
                          2.0972407699619997e-09],
                         [2.385979450285e-10,
                          -1.0506720000000004e-11,
                          9.51833467962e-10],
                         [-2.723049492825999e-10,
                          2.0513120000000003e-11,
                          1.2924775995767998e-09],
                         [5.2244527217400023e-11,
                          -2.0513120000000003e-11,
                          1.470702975768e-10],
                         [2.2485651978260008e-10,
                          2.3314912e-10,
                          2.1437443064231997e-09],
                         [5.494059962826001e-10,
                          -2.3314912e-10,
                          9.983370044232e-10],
                         [-2.0778098435649993e-10,
                          2.9518880000000005e-11,
                          2.2003274271419995e-09],
                         [1.167684921435e-10,
                          -2.9518880000000005e-11,
                          1.054920125142e-09],
                         [-4.357336289006e-10,
                          2.451568e-11,
                          1.9934668684007998e-09],
                         [-1.1118415240059994e-10,
                          -2.451568e-11,
                          8.480595664007999e-10],
                         [1.1510051157309003e-09,
                          2.6516960000000005e-11,
                          5.376541875588e-10],
                         [8.264556392309003e-10,
                          -2.6516960000000005e-11,
                          1.6830614895588e-09],
                         [1.2997734217575002e-09,
                          2.4515680000000023e-11,
                          1.42603209099e-09],
                         [1.6243228982575001e-09,
                          -2.4515680000000023e-11,
                          2.8062478898999996e-10],
                         [5.489570228885001e-10,
                          2.151376000000001e-11,
                          1.822343017482e-09],
                         [8.735064993885002e-10,
                          -2.151376000000001e-11,
                          6.769357154819999e-10],
                         [3.3422739986370006e-10,
                          2.401536000000002e-11,
                          1.5969268604483998e-09],
                         [6.587768763637e-10,
                          -2.401536000000002e-11,
                          4.5151955844839995e-10],
                         [1.3907341004142e-09,
                          2.8017919999999986e-11,
                          8.84254437144e-11],
                         [1.0661846239142e-09,
                          -2.8017919999999986e-11,
                          1.2338327457144e-09],
                         [3.8725528860670005e-10,
                          2.551632e-11,
                          6.095857661244e-10],
                         [6.270581210670012e-11,
                          -2.551632e-11,
                          1.7549930681243998e-09],
                         [8.041417810269e-10,
                          2.051311999999998e-11,
                          1.3806739618307999e-09],
                         [1.1286912575269e-09,
                          -2.051311999999998e-11,
                          2.352666598308e-10],
                         [3.934043004752e-10,
                          1.851184000000001e-11,
                          9.199911449663999e-10],
                         [6.885482397520006e-11,
                          -1.851184000000001e-11,
                          2.0653984469663997e-09]],
      'lattice_vectors': [[9.262e-10, -2.5016e-10, 0.0],
                          [9.262e-10, 2.5016e-10, 0.0],
                          [-6.49098953e-10, 0.0, 2.290814604e-09]],
      'normalized_wyckoff': {'a': {'X_0': 2, 'X_1': 1}},
      'normalized_wysytax': {'a': {'X_0': 2, 'X_1': 1}}}],
 11: [{'Notes': '-',
       'Pearsons Symbol': 'mP10',
       'Prototype': 'KClO3',
       'Space Group': 'P21/m',
       'Space Group Number': 11,
       'Strukturbericht Designation': 'G06',
       'Wyckoff Positions': 'e3f',
       'aflow_prototype_id': 'ABC3_mP10_11_e_e_ef',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/ABC3_mP10_11_e_e_ef.html',
       'atom_labels': ['K', 'K', 'Cl', 'Cl', 'O', 'O', 'O', 'O', 'O', 'O'],
       'atom_positions': [[2.38687732e-10, 1.395e-10, -1.99429273e-10],
                          [-2.38687732e-10, -1.395e-10, 1.99429273e-10],
                          [8.743889000000001e-12, 1.395e-10, 1.17114506e-10],
                          [-8.743889000000001e-12, -1.395e-10, -1.17114506e-10],
                          [1.62269415e-10, 1.395e-10, 7.4284058e-11],
                          [-1.62269415e-10, -1.395e-10, -7.4284058e-11],
                          [2.53995e-13, 1.5624e-11, 1.86044759e-10],
                          [-2.53995e-13, -1.5624e-11, -1.86044759e-10],
                          [-2.53995e-13, 2.94624e-10, -1.86044759e-10],
                          [2.53995e-13, -2.94624e-10, 1.86044759e-10]],
       'lattice_vectors': [[4.64e-10, 0.0, 0.0],
                           [0.0, 5.58e-10, 0.0],
                           [-2.3108635e-10, 0.0, 6.692257500000001e-10]],
       'normalized_wyckoff': {'e': {'X_0': 1, 'X_1': 1, 'X_2': 1},
                              'f': {'X_0': 2}},
       'normalized_wysytax': {'e': {'X_0': 1, 'X_1': 1, 'X_2': 1},
                              'f': {'X_0': 2}}},
      {'Notes': '-',
       'Pearsons Symbol': 'mP4',
       'Prototype': 'NiTi',
       'Space Group': 'P21/m',
       'Space Group Number': 11,
       'Strukturbericht Designation': '-',
       'Wyckoff Positions': 'e2',
       'aflow_prototype_id': 'AB_mP4_11_e_e',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_mP4_11_e_e.html',
       'atom_labels': ['Ni', 'Ni', 'Ti', 'Ti'],
       'atom_positions': [[2.24038147e-10,
                           1.0275000000000001e-10,
                           3.8333221000000003e-10],
                          [-2.24038147e-10,
                           3.0825e-10,
                           -3.8333221000000003e-10],
                          [1.44242377e-10,
                           1.0275000000000001e-10,
                           1.23312892e-10],
                          [-1.44242377e-10, 3.0825e-10, -1.23312892e-10]],
       'lattice_vectors': [[2.884e-10, 0.0, 0.0],
                           [0.0, 4.1100000000000003e-10, 0.0],
                           [-6.573042500000001e-11, 0.0, 4.61846036e-10]],
       'normalized_wyckoff': {'e': {'X_0': 1, 'X_1': 1}},
       'normalized_wysytax': {'e': {'X_0': 1, 'X_1': 1}}},
      {'Notes': '-',
       'Pearsons Symbol': 'mP16',
       'Prototype': 'Pu (alpha)',
       'Space Group': 'P21/m',
       'Space Group Number': 11,
       'Strukturbericht Designation': '-',
       'Wyckoff Positions': 'e8',
       'aflow_prototype_id': 'A_mP16_11_8e',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_mP16_11_8e.html',
       'atom_labels': ['Pu',
                       'Pu',
                       'Pu',
                       'Pu',
                       'Pu',
                       'Pu',
                       'Pu',
                       'Pu',
                       'Pu',
                       'Pu',
                       'Pu',
                       'Pu',
                       'Pu',
                       'Pu',
                       'Pu',
                       'Pu'],
       'atom_positions': [[1.7705556558e-10,
                           1.2055000000000004e-10,
                           1.7386010262e-10],
                          [2.1743002442000003e-10,
                           3.616500000000001e-10,
                           8.9935040738e-10],
                          [-4.2149689119999996e-11,
                           3.616500000000001e-10,
                           8.929111443199999e-10],
                          [4.3663527912e-10,
                           1.2055000000000004e-10,
                           1.8029936568e-10],
                          [3.045500599999999e-12,
                           1.2055000000000004e-10,
                           3.648915734e-10],
                          [3.914400894e-10,
                           3.616500000000001e-10,
                           7.083189366000001e-10],
                          [9.054567536999999e-11,
                           3.616500000000001e-10,
                           5.827533069300001e-10],
                          [3.0393991463e-10,
                           1.2055000000000004e-10,
                           4.9045720307e-10],
                          [-1.2285980538e-10,
                           1.2055000000000004e-10,
                           6.6324409518e-10],
                          [-1.0095460462e-10,
                           3.616500000000001e-10,
                           4.0996641482e-10],
                          [1.4630509026999998e-10,
                           1.2055000000000004e-10,
                           7.008064630299999e-10],
                          [2.4818049973e-10,
                           3.616500000000001e-10,
                           3.7240404697e-10],
                          [2.1936466633999997e-10,
                           1.2055000000000004e-10,
                           -7.941757774e-11],
                          [3.9893533365999995e-10,
                           3.616500000000001e-10,
                           7.941757774e-11],
                          [5.727297254e-11,
                           3.616500000000001e-10,
                           1.1376031405999999e-10],
                          [3.3721261746000007e-10,
                           1.2055000000000004e-10,
                           9.5945019594e-10]],
       'lattice_vectors': [[6.183e-10, 0.0, 0.0],
                           [0.0, 4.822e-10, 0.0],
                           [-2.2381441e-10, 0.0, 1.07321051e-09]],
       'normalized_wyckoff': {'e': {'X_0': 1}},
       'normalized_wysytax': {'e': {'X_0': 1}}}],
 12: [{'Notes': '-',
       'Pearsons Symbol': 'mC16',
       'Prototype': 'AlCl3',
       'Space Group': 'C2/m',
       'Space Group Number': 12,
       'Strukturbericht Designation': 'D015',
       'Wyckoff Positions': 'gij',
       'aflow_prototype_id': 'AB3_mC16_12_g_ij',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB3_mC16_12_g_ij.html',
       'atom_labels': ['Al', 'Al', 'Cl', 'Cl', 'Cl', 'Cl', 'Cl', 'Cl'],
       'atom_positions': [[0.0, 1.70674e-10, 0.0],
                          [0.0, -1.70674e-10, 0.0],
                          [9.2104371e-11, 0.0, 1.28301328e-10],
                          [-9.2104371e-11, 0.0, -1.28301328e-10],
                          [1.8968762900000001e-10, 1.7885e-10, -1.28301328e-10],
                          [1.8968762900000001e-10,
                           -1.7885e-10,
                           -1.28301328e-10],
                          [-1.8968762900000001e-10,
                           -1.7885e-10,
                           1.28301328e-10],
                          [-1.8968762900000001e-10,
                           1.7885e-10,
                           1.28301328e-10]],
       'lattice_vectors': [[2.96e-10, -5.110000000000001e-10, 0.0],
                           [2.96e-10, 5.110000000000001e-10, 0.0],
                           [-1.9035446800000001e-10, 0.0, 5.85850814e-10]],
       'normalized_wyckoff': {'g': {'X_1': 1},
                              'i': {'X_0': 1},
                              'j': {'X_0': 2}},
       'normalized_wysytax': {'g': {'X_1': 1},
                              'i': {'X_0': 2},
                              'j': {'X_0': 2}}},
      {'Notes': '-',
       'Pearsons Symbol': 'mC14',
       'Prototype': 'Au5Mn2',
       'Space Group': 'C2/m',
       'Space Group Number': 12,
       'Strukturbericht Designation': '-',
       'Wyckoff Positions': 'ai2',
       'aflow_prototype_id': 'A5B2_mC14_12_a2i_i',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A5B2_mC14_12_a2i_i.html',
       'atom_labels': ['Au', 'Au', 'Au', 'Au', 'Au', 'Mn', 'Mn'],
       'atom_positions': [[0.0, 0.0, 0.0],
                          [9.4820204e-11, 0.0, 2.75533062e-10],
                          [-9.4820204e-11, 0.0, -2.75533062e-10],
                          [6.438338010000001e-10, 0.0, 9.1844354e-11],
                          [-6.438338010000001e-10, 0.0, -9.1844354e-11],
                          [3.69786403e-10, 0.0, 1.83688708e-10],
                          [-3.69786403e-10, 0.0, -1.83688708e-10]],
       'lattice_vectors': [[4.5940000000000004e-10,
                            -1.9770000000000003e-10,
                            0.0],
                           [4.5940000000000004e-10,
                            1.9770000000000003e-10,
                            0.0],
                           [-8.524055e-11, 0.0, 6.422682100000001e-10]],
       'normalized_wyckoff': {'a': {'X_0': 1}, 'i': {'X_0': 4, 'X_1': 2}},
       'normalized_wysytax': {'a': {'X_0': 1}, 'i': {'X_0': 4, 'X_1': 2}}},
      {'Notes': 'calaverite',
       'Pearsons Symbol': 'mC6',
       'Prototype': 'AuTe2',
       'Space Group': 'C2/m',
       'Space Group Number': 12,
       'Strukturbericht Designation': 'C34',
       'Wyckoff Positions': 'ai',
       'aflow_prototype_id': 'AB2_mC6_12_a_i',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB2_mC6_12_a_i.html',
       'atom_labels': ['Au', 'Te', 'Te'],
       'atom_positions': [[0.0, 0.0, 0.0],
                          [4.94633546778477e-10, 0.0, 1.46443374312183e-10],
                          [2.24620336151523e-10, 0.0, 3.60456502157817e-10]],
       'lattice_vectors': [[3.5945e-10, -2.2035e-10, 0.0],
                           [3.5945e-10, 2.2035e-10, 0.0],
                           [3.5388293e-13, 0.0, 5.0689987647e-10]],
       'normalized_wyckoff': {'a': {'X_1': 1}, 'i': {'X_0': 2}},
       'normalized_wysytax': {'a': {'X_1': 1}, 'i': {'X_0': 2}}},
      {'Notes': '-',
       'Pearsons Symbol': 'mC4',
       'Prototype': 'O2 (alpha)',
       'Space Group': 'C2/m',
       'Space Group Number': 12,
       'Strukturbericht Designation': '-',
       'Wyckoff Positions': 'i',
       'aflow_prototype_id': 'A_mC4_12_i',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_mC4_12_i.html',
       'atom_labels': ['O', 'O'],
       'atom_positions': [[-1.741585e-12, 0.0, 6.416699300000001e-11],
                          [1.741585e-12, 0.0, -6.416699300000001e-11]],
       'lattice_vectors': [[2.6945000000000004e-10, -1.7165e-10, 0.0],
                           [2.6945000000000004e-10, 1.7165e-10, 0.0],
                           [-3.41088214e-10, 0.0, 3.75245573e-10]],
       'normalized_wyckoff': {'i': {'X_0': 1}},
       'normalized_wysytax': {'i': {'X_0': 1}}},
      {'Notes': 'alternate orientation',
       'Pearsons Symbol': 'mC34',
       'Prototype': 'Pu (beta)',
       'Space Group': 'B2/m',
       'Space Group Number': 12,
       'Strukturbericht Designation': '-',
       'Wyckoff Positions': 'ahi3j2',
       'aflow_prototype_id': 'A_mC34_12_ah3i2j',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_mC34_12_ah3i2j.html',
       'atom_labels': ['Pu',
                       'Pu',
                       'Pu',
                       'Pu',
                       'Pu',
                       'Pu',
                       'Pu',
                       'Pu',
                       'Pu',
                       'Pu',
                       'Pu',
                       'Pu',
                       'Pu',
                       'Pu',
                       'Pu',
                       'Pu',
                       'Pu'],
       'atom_positions': [[0.0, 0.0, 0.0],
                          [-3.46329855e-10, 2.29878e-10, 3.04794115e-10],
                          [-3.46329855e-10, -2.29878e-10, 3.04794115e-10],
                          [2.9089001e-10, 0.0, 1.4691076300000002e-10],
                          [-2.9089001e-10, 0.0, -1.4691076300000002e-10],
                          [-2.73634226e-10, 0.0, 1.55444999e-10],
                          [2.73634226e-10, 0.0, -1.55444999e-10],
                          [5.52877011e-10, 0.0, -1.45081999e-10],
                          [-5.52877011e-10, 0.0, 1.45081999e-10],
                          [-1.5339240900000001e-10,
                           2.800332e-10,
                           2.2554765e-11],
                          [1.5339240900000001e-10,
                           -2.800332e-10,
                           -2.2554765e-11],
                          [-1.5339240900000001e-10,
                           -2.800332e-10,
                           2.2554765e-11],
                          [1.5339240900000001e-10,
                           2.800332e-10,
                           -2.2554765e-11],
                          [5.43988e-12, 1.56735e-10, 2.52369527e-10],
                          [-5.43988e-12, -1.56735e-10, -2.52369527e-10],
                          [5.43988e-12, -1.56735e-10, 2.52369527e-10],
                          [-5.43988e-12, 1.56735e-10, -2.52369527e-10]],
       'lattice_vectors': [[5.915e-10, -5.2245e-10, 0.0],
                           [5.915e-10, 5.2245e-10, 0.0],
                           [-6.9265971e-10, 0.0, 6.0958823e-10]],
       'normalized_wyckoff': {'a': {'X_0': 1},
                              'h': {'X_0': 2},
                              'i': {'X_0': 6},
                              'j': {'X_0': 8}},
       'normalized_wysytax': {'a': {'X_0': 1},
                              'h': {'X_0': 1},
                              'i': {'X_0': 6},
                              'j': {'X_0': 4}}}],
 13: [{'Notes': '-',
       'Pearsons Symbol': 'mP12',
       'Prototype': 'AgAuTe4',
       'Space Group': 'P2/c',
       'Space Group Number': 13,
       'Strukturbericht Designation': 'E1b',
       'Wyckoff Positions': 'aeg2',
       'aflow_prototype_id': 'ABC4_mP12_13_e_a_2g',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/ABC4_mP12_13_e_a_2g.html',
       'atom_labels': ['Ag',
                       'Ag',
                       'Au',
                       'Au',
                       'Te',
                       'Te',
                       'Te',
                       'Te',
                       'Te',
                       'Te',
                       'Te',
                       'Te'],
       'atom_positions': [[0.0, 0.0, 0.0],
                          [-6.019299450000001e-10, 0.0, 4.14778665e-10],
                          [-3.00964973e-10, 1.94417e-10, 2.07389332e-10],
                          [3.00964973e-10, -1.94417e-10, -2.07389332e-10],
                          [2.6821186e-10, 1.3919000000000002e-11, -8.29557e-13],
                          [-8.701418049999999e-10,
                           1.3919000000000002e-11,
                           4.15608222e-10],
                          [-2.6821186e-10,
                           -1.3919000000000002e-11,
                           8.29557e-13],
                          [-3.33718086e-10,
                           -1.3919000000000002e-11,
                           4.1394910700000004e-10],
                          [-3.4715074000000004e-11,
                           1.90825e-10,
                           1.9494597199999998e-10],
                          [-5.672148710000001e-10, 1.90825e-10, 2.19832692e-10],
                          [3.4715074000000004e-11,
                           -1.90825e-10,
                           -1.9494597199999998e-10],
                          [-6.3664502e-10, -1.90825e-10, 6.09724637e-10]],
       'lattice_vectors': [[8.960000000000001e-10, 0.0, 0.0],
                           [0.0, 4.4900000000000005e-10, 0.0],
                           [-1.2038598909999999e-09, 0.0, 8.29557329e-10]],
       'normalized_wyckoff': {'a': {'X_1': 1},
                              'f': {'X_2': 1},
                              'g': {'X_0': 4}},
       'normalized_wysytax': {'d': {'X_1': 1},
                              'e': {'X_2': 1},
                              'g': {'X_0': 4}}},
      {'Notes': 'monoclinic phosphorus',
       'Pearsons Symbol': 'mP84',
       'Prototype': 'P',
       'Space Group': 'P2/c',
       'Space Group Number': 13,
       'Strukturbericht Designation': '-',
       'Wyckoff Positions': 'g',
       'aflow_prototype_id': 'A_mP84_13_21g',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_mP84_13_21g.html',
       'atom_labels': ['P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P',
                       'P'],
       'atom_positions': [[1.6338679437948003e-10,
                           1.8416205e-10,
                           3.9403686034536e-10],
                          [-1.4997876362052e-10,
                           7.308379500000001e-10,
                           1.47971730434536e-09],
                          [4.442476476205201e-10,
                           1.8416205e-10,
                           6.916435836546399e-10],
                          [1.308820896205201e-10,
                           7.308379500000001e-10,
                           1.7773240276546398e-09],
                          [-2.903141828652e-11,
                           1.4531115e-10,
                           9.764609913336e-11],
                          [-3.4239697628652e-10,
                           7.6968885e-10,
                           1.18332654313336e-09],
                          [6.366658602865202e-10,
                           1.4531115e-10,
                           9.880343448666398e-10],
                          [3.2330030228652005e-10,
                           7.6968885e-10,
                           2.07371478886664e-09],
                          [-7.250676021864e-11,
                           1.269837e-10,
                           9.261722731675199e-10],
                          [-3.8587231821864e-10,
                           7.880163e-10,
                           2.0118527171675197e-09],
                          [6.801412022186401e-10,
                           1.269837e-10,
                           1.5950817083248001e-10],
                          [3.667756442186401e-10,
                           7.880163e-10,
                           1.2451886148324798e-09],
                          [-5.384888098175999e-11,
                           -8.309115e-11,
                           9.8875089395968e-10],
                          [-3.6721443898176005e-10,
                           9.9809115e-10,
                           2.07443133795968e-09],
                          [6.614833229817601e-10,
                           -8.309115e-11,
                           9.692955004032001e-11],
                          [3.481177649817601e-10,
                           9.9809115e-10,
                           1.18260999404032e-09],
                          [-1.5626671304327998e-10,
                           1.1653440000000002e-10,
                           2.0227963760430398e-09],
                          [1.5709884495672003e-10,
                           7.984656e-10,
                           9.3711593204304e-10],
                          [1.3717003904328003e-10,
                           1.1653440000000002e-10,
                           1.23424495595696e-09],
                          [4.5053559704328004e-10,
                           7.984656e-10,
                           1.4856451195696e-10],
                          [-1.5319584992736002e-10,
                           3.3200775000000003e-10,
                           2.09961912426048e-09],
                          [1.6016970807264e-10,
                           5.8299225e-10,
                           1.01393868026048e-09],
                          [1.3409917592736002e-10,
                           3.3200775000000003e-10,
                           1.15742220773952e-09],
                          [4.474647339273601e-10,
                           5.8299225e-10,
                           7.174176373952e-11],
                          [-7.379320594572001e-11,
                           3.3200775000000003e-10,
                           1.22935939395896e-09],
                          [2.3957235205428e-10,
                           5.8299225e-10,
                           1.4367894995896e-10],
                          [5.4696531945720166e-11,
                           3.3200775000000003e-10,
                           2.02768193804104e-09],
                          [3.680620899457201e-10,
                           5.8299225e-10,
                           9.4200149404104e-10],
                          [2.0292609467280004e-10,
                           3.7107825000000004e-10,
                           9.59741512496e-11],
                          [-1.1043946332719994e-10,
                           5.4392175e-10,
                           1.1816545952496e-09],
                          [4.047083473272001e-10,
                           3.7107825000000004e-10,
                           9.897062927503998e-10],
                          [9.134278932720007e-11,
                           5.4392175e-10,
                           2.0753867367503996e-09],
                          [2.6549169135960013e-11,
                           3.5598075000000003e-10,
                           3.7388663130472e-10],
                          [-2.8681638886404005e-10,
                           5.5901925e-10,
                           1.45956707530472e-09],
                          [5.8108527286404e-10,
                           3.5598075000000003e-10,
                           7.117938126952799e-10],
                          [2.6771971486404e-10,
                           5.5901925e-10,
                           1.79747425669528e-09],
                          [-7.599381819588002e-11,
                           9.200325e-11,
                           7.087973346698401e-10],
                          [-3.8935937619588e-10,
                           8.2299675e-10,
                           1.7944777786698398e-09],
                          [6.8362826019588e-10,
                           9.200325e-11,
                           3.7688310933015994e-10],
                          [3.7026270219588003e-10,
                           8.2299675e-10,
                           1.46256355333016e-09],
                          [-1.485341249495999e-10,
                           1.611864e-10,
                           1.8035323535727999e-09],
                          [1.6483143305040002e-10,
                           7.538136e-10,
                           7.178519095728e-10],
                          [1.2943745094960012e-10,
                           1.611864e-10,
                           1.4535089784272e-09],
                          [4.428030089496002e-10,
                           7.538136e-10,
                           3.6782853442719997e-10],
                          [8.683806598380002e-11,
                           2.9847300000000004e-11,
                           2.539406558516e-10],
                          [-2.2652749201620001e-10,
                           8.851527e-10,
                           1.3396210998516e-09],
                          [5.207963760162e-10,
                           2.9847300000000004e-11,
                           8.317397881483999e-10],
                          [2.0743081801620004e-10,
                           8.851527e-10,
                           1.9174202321484e-09],
                          [-3.2736448329119966e-11,
                           3.2408384999999997e-10,
                           1.44899254778016e-09],
                          [2.806291096708801e-10,
                           5.9091615e-10,
                           3.6331210378016e-10],
                          [1.3639774329120021e-11,
                           3.2408384999999997e-10,
                           1.8080487842198399e-09],
                          [3.2700533232912003e-10,
                           5.9091615e-10,
                           7.2236834021984e-10],
                          [-1.756220418696e-10,
                           2.955084e-10,
                           4.3557499413279997e-10],
                          [-4.889875998696e-10,
                           6.194916000000001e-10,
                           1.5212554381328e-09],
                          [7.832564838696001e-10,
                           2.955084e-10,
                           6.501054498672e-10],
                          [4.698909258696001e-10,
                           6.194916000000001e-10,
                           1.7357858938671998e-09],
                          [-6.685201677059999e-11,
                           -4.786365e-11,
                           3.9160493615079997e-10],
                          [-3.8021757477059997e-10,
                           9.6286365e-10,
                           1.4772853801507999e-09],
                          [6.744864587706001e-10,
                           -4.786365e-11,
                           6.940755078492e-10],
                          [3.611209007706002e-10,
                           9.6286365e-10,
                           1.7797559518492e-09],
                          [-4.5617414603543997e-10,
                           2.0039415e-10,
                           1.3382965697099198e-09],
                          [-1.4280858803544e-10,
                           7.1460585e-10,
                           2.5261612570991996e-10],
                          [4.3707747203544003e-10,
                           2.0039415e-10,
                           1.91874476229008e-09],
                          [7.504430300354401e-10,
                           7.1460585e-10,
                           8.330643182900799e-10],
                          [-3.2865947803920004e-10,
                           2.939712e-10,
                           1.7939783656655999e-09],
                          [-1.529392003919998e-11,
                           6.210288e-10,
                           7.082979216656e-10],
                          [3.095628040392001e-10,
                           2.939712e-10,
                           1.4630629663344e-09],
                          [6.229283620392002e-10,
                           6.210288e-10,
                           3.7738252233439995e-10],
                          [-2.7108277531368003e-10,
                           4.434822e-10,
                           1.94549592843024e-09],
                          [4.2282782686320024e-11,
                           4.715178000000001e-10,
                           8.598154844302399e-10],
                          [2.519861013136801e-10,
                           4.434822e-10,
                           1.3115454035697598e-09],
                          [5.6535165931368e-10,
                           4.715178000000001e-10,
                           2.2586495956976e-10],
                          [1.9428739941984e-10,
                           4.111278e-10,
                           7.1168524465088e-10],
                          [-1.1907815858016003e-10,
                           5.038722e-10,
                           1.79736568865088e-09],
                          [4.1334704258016004e-10,
                           4.111278e-10,
                           3.7399519934911993e-10],
                          [9.998148458016003e-11,
                           5.038722e-10,
                           1.4596756433491198e-09],
                          [3.1757298414048e-10,
                           2.5383015000000004e-10,
                           2.5344124284736e-10],
                          [4.207426140480062e-12,
                           6.6116985e-10,
                           1.3391216868473598e-09],
                          [2.9006145785952005e-10,
                           2.5383015000000004e-10,
                           8.3223920115264e-10],
                          [-2.3304100140479955e-11,
                           6.6116985e-10,
                           1.91791964515264e-09],
                          [-7.4614693542e-12,
                           3.5746305e-10,
                           1.573150963356e-10],
                          [-3.2082702735419997e-10,
                           5.575369500000001e-10,
                           1.2429955403356e-09],
                          [6.150959113542e-10,
                           3.5746305e-10,
                           9.283653476644e-10],
                          [3.017303533542001e-10,
                           5.575369500000001e-10,
                           2.0140457916643996e-09]],
       'lattice_vectors': [[9.21e-10, 0.0, 0.0],
                           [0.0, 9.15e-10, 0.0],
                           [-6.26731116e-10, 0.0, 2.171360888e-09]],
       'normalized_wyckoff': {'g': {'X_0': 1}},
       'normalized_wysytax': {'g': {'X_0': 1}}}],
 14: [{'Notes': 'baddeleyite',
       'Pearsons Symbol': 'mP12',
       'Prototype': 'O2Zr',
       'Space Group': 'P21/c',
       'Space Group Number': 14,
       'Strukturbericht Designation': 'C43',
       'Wyckoff Positions': 'e3',
       'aflow_prototype_id': 'A2B_mP12_14_2e_e',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2B_mP12_14_2e_e.html',
       'atom_labels': ['Zr',
                       'Zr',
                       'Zr',
                       'Zr',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O'],
       'atom_positions': [[1.2410912e-10, 2.10383e-11, 1.09503076e-10],
                          [-1.66715659e-10,
                           2.8141330000000003e-10,
                           1.52591409e-10],
                          [-1.2410912e-10, -2.10383e-11, -1.09503076e-10],
                          [8.1502581e-11, 2.393367e-10, 3.71597561e-10],
                          [6.104748e-12, 1.780965e-10, 1.80845195e-10],
                          [-4.8711287e-11, 4.384715e-10, 8.124929e-11],
                          [-6.104748e-12, -1.780965e-10, -1.80845195e-10],
                          [-3.6501791e-11, 8.22785e-11, 4.4293968000000005e-10],
                          [1.9124047600000002e-10,
                           3.9472850000000003e-10,
                           2.5108651700000003e-10],
                          [-2.33847015e-10,
                           1.3435349999999998e-10,
                           1.1007968000000001e-11],
                          [-1.9124047600000002e-10,
                           -3.9472850000000003e-10,
                           -2.5108651700000003e-10],
                          [1.48633937e-10,
                           -1.3435349999999998e-10,
                           5.13181002e-10]],
       'lattice_vectors': [[5.145400000000001e-10, 0.0, 0.0],
                           [0.0, 5.2075e-10, 0.0],
                           [-8.5213078e-11, 0.0, 5.2418897e-10]],
       'normalized_wyckoff': {'e': {'X_0': 2, 'X_1': 1}},
       'normalized_wysytax': {'e': {'X_0': 2, 'X_1': 1}}},
      {'Notes': '-',
       'Pearsons Symbol': 'mP64',
       'Prototype': 'Se (alpha)',
       'Space Group': 'P21/c',
       'Space Group Number': 14,
       'Strukturbericht Designation': 'Ak',
       'Wyckoff Positions': 'e16',
       'aflow_prototype_id': 'A_mP64_14_16e',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_mP64_14_16e.html',
       'atom_labels': ['Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se'],
       'atom_positions': [[2.7307035000000003e-10,
                           2.0686478e-10,
                           3.0261882e-11],
                          [-3.0074035000000005e-10,
                           9.4251478e-10,
                           4.0831611800000004e-10],
                          [-2.7307035000000003e-10,
                           -2.0686478e-10,
                           -3.0261882e-11],
                          [2.4540035e-10, 5.2878522e-10, 4.68839882e-10],
                          [3.36526796e-10,
                           4.1799633e-10,
                           1.0753932600000001e-10],
                          [-3.6419679600000003e-10,
                           1.15364633e-09,
                           3.31038674e-10],
                          [-3.36526796e-10,
                           -4.1799633e-10,
                           -1.0753932600000001e-10],
                          [3.08856796e-10,
                           3.1765367000000005e-10,
                           5.46117326e-10],
                          [4.7885427e-10,
                           4.694918300000001e-10,
                           8.72331642e-10],
                          [-5.0652427e-10,
                           1.2051418300000001e-09,
                           -4.3375364200000005e-10],
                          [-4.7885427e-10,
                           -4.694918300000001e-10,
                           -8.72331642e-10],
                          [5.0652427e-10,
                           2.6615817e-10,
                           4.3375364200000005e-10],
                          [7.09384598e-10,
                           4.2344014000000004e-10,
                           1.41485263e-10],
                          [-7.370545980000001e-10,
                           1.15909014e-09,
                           2.9709273700000003e-10],
                          [-7.09384598e-10,
                           -4.2344014000000004e-10,
                           -1.41485263e-10],
                          [6.81714598e-10,
                           3.1220986000000005e-10,
                           5.80063263e-10],
                          [7.8852701e-10, 2.1245572e-10, 8.2014086e-11],
                          [-8.1619701e-10,
                           9.481057200000001e-10,
                           3.5656391400000003e-10],
                          [-7.8852701e-10, -2.1245572e-10, -8.2014086e-11],
                          [7.6085701e-10, 5.2319428e-10, 5.20592086e-10],
                          [7.0541632e-10, 5.929339e-11, 2.37709276e-10],
                          [-7.330863199999999e-10,
                           7.949433900000001e-10,
                           2.0086872400000001e-10],
                          [-7.0541632e-10, -5.929339e-11, -2.37709276e-10],
                          [6.7774632e-10, 6.7635661e-10, 6.76287276e-10],
                          [5.217679920000001e-10,
                           -4.1490660000000003e-11,
                           1.32625987e-10],
                          [-5.49437992e-10,
                           6.941593400000001e-10,
                           3.05952013e-10],
                          [-5.217679920000001e-10,
                           4.1490660000000003e-11,
                           -1.32625987e-10],
                          [4.94097992e-10, 7.7714066e-10, 5.71203987e-10],
                          [3.25239198e-10,
                           6.267738000000001e-11,
                           2.05517651e-10],
                          [-3.52909198e-10,
                           7.983273800000001e-10,
                           2.3306034900000003e-10],
                          [-3.25239198e-10,
                           -6.267738000000001e-11,
                           -2.05517651e-10],
                          [2.97569198e-10,
                           6.7297262e-10,
                           6.440956510000001e-10],
                          [1.3555808600000001e-10,
                           7.150518e-10,
                           1.24643868e-10],
                          [-1.63228086e-10,
                           1.4507018000000001e-09,
                           3.1393413200000005e-10],
                          [-1.3555808600000001e-10,
                           -7.150518e-10,
                           -1.24643868e-10],
                          [1.07888086e-10, 2.05982e-11, 5.63221868e-10],
                          [4.127812e-12, 8.6630144e-10, 2.4402479900000004e-10],
                          [-3.1797812e-11,
                           1.3065144000000001e-10,
                           1.94553201e-10],
                          [-4.127812e-12,
                           -8.6630144e-10,
                           -2.4402479900000004e-10],
                          [-2.3542188e-11,
                           -1.3065144000000001e-10,
                           6.82602799e-10],
                          [-3.5703016e-11,
                           -4.1961475999999997e-10,
                           1.0648673799999999e-10],
                          [8.033016e-12, 3.1603524e-10, 3.32091262e-10],
                          [3.5703016e-11,
                           4.1961475999999997e-10,
                           -1.0648673799999999e-10],
                          [-6.3373016e-11,
                           1.1552647600000001e-09,
                           5.45064738e-10],
                          [1.1513473000000001e-10,
                           -2.5085665e-10,
                           1.62712438e-10],
                          [-1.4280473000000002e-10,
                           4.8479335e-10,
                           2.75865562e-10],
                          [-1.1513473000000001e-10,
                           2.5085665e-10,
                           -1.62712438e-10],
                          [8.746473e-11, 9.8650665e-10, 6.01290438e-10],
                          [2.8751397600000004e-10,
                           -2.7454458000000005e-10,
                           8.420698e-12],
                          [-3.15183976e-10,
                           4.6110542e-10,
                           4.3015730200000005e-10],
                          [-2.8751397600000004e-10,
                           2.7454458000000005e-10,
                           -8.420698e-12],
                          [2.59843976e-10, 1.01019458e-09, 4.46998698e-10],
                          [4.578894e-10,
                           1.08817348e-09,
                           1.2631046399999998e-10],
                          [-4.855594e-10, 3.5252348e-10, 3.12267536e-10],
                          [-4.578894e-10,
                           3.8312652e-10,
                           -1.2631046399999998e-10],
                          [4.302194e-10, -3.5252348e-10, 5.64888464e-10],
                          [4.60359688e-10, 8.7012682e-10, 4.1928057e-11],
                          [-4.880296880000001e-10,
                           1.3447682e-10,
                           3.96649943e-10],
                          [-4.60359688e-10, -8.7012682e-10, -4.1928057e-11],
                          [4.3268968799999996e-10,
                           -1.3447682e-10,
                           4.80506057e-10],
                          [3.5276641e-10,
                           7.4374215e-10,
                           2.0481592599999998e-10],
                          [-3.8043641e-10, 8.09215e-12, 2.33762074e-10],
                          [-3.5276641e-10,
                           -7.4374215e-10,
                           -2.0481592599999998e-10],
                          [3.2509641000000003e-10,
                           -8.09215e-12,
                           6.43393926e-10]],
       'lattice_vectors': [[1.5018000000000001e-09, 0.0, 0.0],
                           [0.0, 1.4712999999999999e-09, 0.0],
                           [-5.534e-11, 0.0, 8.77156e-10]],
       'normalized_wyckoff': {'e': {'X_0': 1}},
       'normalized_wysytax': {'e': {'X_0': 1}}},
      {'Notes': '-',
       'Pearsons Symbol': 'mP32',
       'Prototype': 'Se (beta)',
       'Space Group': 'P21/c',
       'Space Group Number': 14,
       'Strukturbericht Designation': 'Al',
       'Wyckoff Positions': 'e8',
       'aflow_prototype_id': 'A_mP32_14_8e',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_mP32_14_8e.html',
       'atom_labels': ['Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se',
                       'Se'],
       'atom_positions': [[3.65871808e-10, 2.54205e-10, 7.49320472e-10],
                          [-4.0095330799999997e-10,
                           6.577050000000001e-10,
                           -1.07778972e-10],
                          [-3.65871808e-10, -2.54205e-10, -7.49320472e-10],
                          [4.0095330799999997e-10, 1.49295e-10, 1.07778972e-10],
                          [1.95558249e-10, 1.83189e-10, 6.12030591e-10],
                          [-2.3063974900000002e-10,
                           5.86689e-10,
                           2.9510909000000005e-11],
                          [-1.95558249e-10, -1.83189e-10, -6.12030591e-10],
                          [1.60476749e-10,
                           2.2031100000000002e-10,
                           1.253572091e-09],
                          [2.0042653600000002e-10,
                           3.21186e-10,
                           4.2085122400000003e-10],
                          [-2.35508036e-10,
                           7.24686e-10,
                           2.2069027600000002e-10],
                          [-2.0042653600000002e-10,
                           -3.21186e-10,
                           -4.2085122400000003e-10],
                          [1.65345036e-10,
                           8.231400000000001e-11,
                           1.062392724e-09],
                          [2.1852624000000003e-11, 4.6806e-10, 4.51645216e-10],
                          [-5.6934124e-11, 6.456e-11, 1.89896284e-10],
                          [-2.1852624000000003e-11,
                           -4.6806e-10,
                           -4.51645216e-10],
                          [-1.3228876000000001e-11,
                           -6.456e-11,
                           1.093186716e-09],
                          [1.1740017e-10,
                           6.706170000000001e-10,
                           5.260640300000001e-10],
                          [-1.5248167e-10,
                           2.6711700000000003e-10,
                           1.1547747e-10],
                          [-1.1740017e-10,
                           -6.706170000000001e-10,
                           -5.260640300000001e-10],
                          [8.231867000000001e-11,
                           -2.6711700000000003e-10,
                           1.16760553e-09],
                          [9.080583e-11, 6.7788e-10, 7.570189700000001e-10],
                          [-1.2588733000000001e-10, 2.7438e-10, -1.1547747e-10],
                          [-9.080583e-11, -6.7788e-10, -7.570189700000001e-10],
                          [1.2588733000000001e-10, -2.7438e-10, 1.1547747e-10],
                          [2.9630042e-10, 6.08478e-10, 8.468347800000001e-10],
                          [-3.3138192e-10,
                           2.0497800000000003e-10,
                           -2.0529327999999998e-10],
                          [-2.9630042e-10,
                           -6.08478e-10,
                           -8.468347800000001e-10],
                          [3.3138192e-10,
                           -2.0497800000000003e-10,
                           2.0529327999999998e-10],
                          [2.6113827000000004e-10,
                           3.8655300000000005e-10,
                           9.109889300000001e-10],
                          [-2.9621977e-10, 7.90053e-10, -2.6944743e-10],
                          [-2.6113827000000004e-10,
                           -3.8655300000000005e-10,
                           -9.109889300000001e-10],
                          [2.9621977e-10, 1.6947e-11, 2.6944743e-10]],
       'lattice_vectors': [[9.310000000000001e-10, 0.0, 0.0],
                           [0.0, 8.070000000000001e-10, 0.0],
                           [-7.0163e-11, 0.0, 1.2830830000000002e-09]],
       'normalized_wyckoff': {'e': {'X_0': 1}},
       'normalized_wysytax': {'e': {'X_0': 1}}}],
 15: [{'Notes': '-',
       'Pearsons Symbol': 'mC28',
       'Prototype': 'B2Pd5',
       'Space Group': 'B2/b',
       'Space Group Number': 15,
       'Strukturbericht Designation': '-',
       'Wyckoff Positions': 'ef3',
       'aflow_prototype_id': 'A2B5_mC28_15_f_e2f',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2B5_mC28_15_f_e2f.html',
       'atom_labels': ['Pd',
                       'Pd',
                       'B',
                       'B',
                       'B',
                       'B',
                       'Pd',
                       'Pd',
                       'Pd',
                       'Pd',
                       'Pd',
                       'Pd',
                       'Pd',
                       'Pd'],
       'atom_positions': [[-1.6742818e-11, 2.8377285e-10, 1.35771565e-10],
                          [-5.0228452999999996e-11,
                           -2.8377285e-10,
                           4.07314695e-10],
                          [1.3031121200000001e-10, 1.541005e-10, 4.1817642e-11],
                          [-1.63796847e-10,
                           1.541005e-10,
                           2.2972548800000002e-10],
                          [-1.3031121200000001e-10,
                           -1.541005e-10,
                           -4.1817642e-11],
                          [1.63796847e-10,
                           -1.541005e-10,
                           -2.2972548800000002e-10],
                          [9.421740400000001e-11, 4.71716e-11, 2.28802241e-10],
                          [-1.27703039e-10, 4.71716e-11, 4.2740889e-11],
                          [-9.421740400000001e-11,
                           -4.71716e-11,
                           -2.28802241e-10],
                          [1.27703039e-10, -4.71716e-11, -4.2740889e-11],
                          [2.50815015e-10, 2.837233e-10, 1.70420468e-10],
                          [-2.8430065e-10, 2.837233e-10, 1.01122662e-10],
                          [-2.50815015e-10, -2.837233e-10, -1.70420468e-10],
                          [2.8430065e-10, -2.837233e-10, -1.01122662e-10]],
       'lattice_vectors': [[6.39e-10, -2.4775e-10, 0.0],
                           [6.39e-10, 2.4775e-10, 0.0],
                           [-6.697127000000001e-11, 0.0, 5.4308626e-10]],
       'normalized_wyckoff': {'e': {'X_0': 1}, 'f': {'X_0': 4, 'X_1': 2}},
       'normalized_wysytax': {'e': {'X_0': 1}, 'f': {'X_0': 4, 'X_1': 2}}},
      {'Notes': 'esseneite',
       'Pearsons Symbol': 'mC40',
       'Prototype': 'CaFeO6Si2',
       'Space Group': 'C2/c',
       'Space Group Number': 15,
       'Strukturbericht Designation': '-',
       'Wyckoff Positions': 'ef4',
       'aflow_prototype_id': 'ABC6D2_mC40_15_e_e_3f_f',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/ABC6D2_mC40_15_e_e_3f_f.html',
       'atom_labels': ['Fe',
                       'Fe',
                       'Ca',
                       'Ca',
                       'Si',
                       'Si',
                       'Si',
                       'Si',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O'],
       'atom_positions': [[-1.17012436e-10, 8.30844e-11, 4.13513183e-10],
                          [-3.9004145e-11,
                           -8.30844e-11,
                           1.3783772800000002e-10],
                          [-1.17012436e-10, 6.101676e-10, 4.13513183e-10],
                          [-3.9004145e-11,
                           -6.101676e-10,
                           1.3783772800000002e-10],
                          [8.612302600000001e-11,
                           3.578274e-10,
                           4.2806884700000007e-10],
                          [-1.64131317e-10, 3.578274e-10, -1.52393392e-10],
                          [-8.612302600000001e-11,
                           -3.578274e-10,
                           -4.2806884700000007e-10],
                          [1.64131317e-10, -3.578274e-10, 1.52393392e-10],
                          [2.45540442e-10, 3.636486e-10, 4.77414753e-10],
                          [-3.2354873300000005e-10,
                           3.636486e-10,
                           -2.01739298e-10],
                          [-2.45540442e-10, -3.636486e-10, -4.77414753e-10],
                          [3.2354873300000005e-10,
                           -3.636486e-10,
                           2.01739298e-10],
                          [2.7655726000000003e-11,
                           2.126502e-10,
                           3.74863484e-10],
                          [-1.0566401700000001e-10,
                           2.126502e-10,
                           -9.9188029e-11],
                          [-2.7655726000000003e-11,
                           -2.126502e-10,
                           -3.74863484e-10],
                          [1.0566401700000001e-10,
                           -2.126502e-10,
                           9.9188029e-11],
                          [1.41782594e-10, 4.235364e-10, 6.836751000000001e-12],
                          [-2.19790885e-10, 4.235364e-10, 2.68838704e-10],
                          [-1.41782594e-10,
                           -4.235364e-10,
                           -6.836751000000001e-12],
                          [2.19790885e-10, -4.235364e-10, -2.68838704e-10]],
       'lattice_vectors': [[4.895e-10, -4.4100000000000003e-10, 0.0],
                           [4.895e-10, 4.4100000000000003e-10, 0.0],
                           [-1.56016582e-10, 0.0, 5.513509100000001e-10]],
       'normalized_wyckoff': {'e': {'X_2': 1, 'X_3': 1},
                              'f': {'X_0': 6, 'X_1': 2}},
       'normalized_wysytax': {'e': {'X_2': 1, 'X_3': 1},
                              'f': {'X_0': 6, 'X_1': 2}}},
      {'Notes': 'tenorite',
       'Pearsons Symbol': 'mC8',
       'Prototype': 'CuO',
       'Space Group': 'C2/c',
       'Space Group Number': 15,
       'Strukturbericht Designation': 'B26',
       'Wyckoff Positions': 'ce',
       'aflow_prototype_id': 'AB_mC8_15_c_e',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_mC8_15_c_e.html',
       'atom_labels': ['Cr', 'Cr', 'O', 'O'],
       'atom_positions': [[1.16325e-10, 8.525e-11, 0.0],
                          [7.424500000000001e-11, -8.525e-11, 2.5191e-10],
                          [-2.1040000000000002e-11, 1.99144e-10, 1.25955e-10],
                          [2.1040000000000002e-11, -1.99144e-10, -1.25955e-10]],
       'lattice_vectors': [[2.3265e-10, -1.705e-10, 0.0],
                           [2.3265e-10, 1.705e-10, 0.0],
                           [-8.416000000000001e-11, 0.0, 5.03819e-10]],
       'normalized_wyckoff': {'c': {'X_0': 1}, 'e': {'X_1': 1}},
       'normalized_wysytax': {'c': {'X_0': 1}, 'e': {'X_1': 1}}},
      {'Notes': 'coesite',
       'Pearsons Symbol': 'mC48',
       'Prototype': 'O2Si',
       'Space Group': 'C2/c',
       'Space Group Number': 15,
       'Strukturbericht Designation': '-',
       'Wyckoff Positions': 'aef5',
       'aflow_prototype_id': 'A2B_mC48_15_ae3f_2f',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2B_mC48_15_ae3f_2f.html',
       'atom_labels': ['O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'Si',
                       'Si',
                       'Si',
                       'Si',
                       'Si',
                       'Si',
                       'Si',
                       'Si'],
       'atom_positions': [[0.0, 0.0, 0.0],
                          [-1.811801235e-10, 0.0, 3.09556304e-10],
                          [8.500981474999991e-11,
                           4.74606204e-10,
                           4.6433445600000003e-10],
                          [2.661899382499999e-10,
                           -4.74606204e-10,
                           1.54778152e-10],
                          [-1.5084790820470004e-10,
                           1.5263592799999998e-10,
                           5.820277627808e-10],
                          [3.033221529529997e-11,
                           -1.5263592799999998e-10,
                           2.724714587808e-10],
                          [3.208675377047e-10,
                           1.5263592800000008e-10,
                           3.466411492192e-10],
                          [5.020476612047e-10,
                           -1.5263592800000008e-10,
                           3.70848452192e-11],
                          [1.0327595093459995e-10,
                           1.28392296e-10,
                           2.0319275794560003e-10],
                          [-7.790417256540009e-11,
                           -1.28392296e-10,
                           5.127490619456e-10],
                          [4.291039255654e-10,
                           1.2839229600000004e-10,
                           1.063635460544e-10],
                          [2.4792380206539997e-10,
                           -1.2839229600000004e-10,
                           4.1591985005439995e-10],
                          [1.5542719111539995e-10,
                           3.56604036e-10,
                           3.230529588544e-10],
                          [1.459243838459987e-11,
                           3.566040359999999e-10,
                           6.056159531456e-10],
                          [3.3660731461539997e-10,
                           -3.56604036e-10,
                           1.34966548544e-11],
                          [1.957725618845999e-10,
                           -3.566040359999999e-10,
                           2.9605964914560003e-10],
                          [7.394609974930998e-11,
                           1.339955436e-10,
                           4.474326818016e-11],
                          [-7.952634674931007e-11,
                           4.844644564e-10,
                           5.743693398198401e-10],
                          [-1.0723402375069002e-10,
                           -1.339955436e-10,
                           3.5429957218016e-10],
                          [1.0165377675068997e-10,
                           -4.844644564e-10,
                           2.6481303581983997e-10],
                          [3.6668694807019e-10,
                           1.9542099080000002e-10,
                           -2.524122102816e-11],
                          [1.6569292842980993e-10,
                           1.9542099079999997e-10,
                           3.3479752502816003e-10],
                          [1.8550682457019e-10,
                           -1.9542099080000002e-10,
                           2.8431508297184e-10],
                          [3.4687305192980994e-10,
                           -1.9542099079999997e-10,
                           2.524122102816e-11]],
       'lattice_vectors': [[3.5678e-10, -6.1846e-10, 0.0],
                           [3.5678e-10, 6.1846e-10, 0.0],
                           [-3.62360247e-10, 0.0, 6.19112608e-10]],
       'normalized_wyckoff': {'d': {'X_0': 1},
                              'e': {'X_0': 1},
                              'f': {'X_0': 6, 'X_1': 4}},
       'normalized_wysytax': {'d': {'X_0': 1},
                              'e': {'X_0': 1},
                              'f': {'X_0': 6, 'X_1': 4}}}],
 16: [{'Notes': '-',
       'Pearsons Symbol': 'oP12',
       'Prototype': 'AlPS4',
       'Space Group': 'P222',
       'Space Group Number': 16,
       'Strukturbericht Designation': '-',
       'Wyckoff Positions': 'acdfu2',
       'aflow_prototype_id': 'ABC4_oP12_16_ag_cd_2u',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/ABC4_oP12_16_ag_cd_2u.html',
       'atom_labels': ['Al',
                       'P',
                       'P',
                       'Al',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S'],
       'atom_positions': [[0.0, 0.0, 0.0],
                          [0.0, 2.835e-10, 0.0],
                          [0.0, 0.0, 4.5250000000000004e-10],
                          [2.805e-10, 0.0, 4.5250000000000004e-10],
                          [1.1220000000000001e-10,
                           1.4742e-10,
                           1.1312500000000001e-10],
                          [-1.1220000000000001e-10,
                           -1.4742e-10,
                           1.1312500000000001e-10],
                          [-1.1220000000000001e-10,
                           1.4742e-10,
                           -1.1312500000000001e-10],
                          [1.1220000000000001e-10,
                           -1.4742e-10,
                           -1.1312500000000001e-10],
                          [4.1514e-10, 4.5359999999999996e-10, 5.7015e-10],
                          [-4.1514e-10, -4.5359999999999996e-10, 5.7015e-10],
                          [-4.1514e-10, 4.5359999999999996e-10, -5.7015e-10],
                          [4.1514e-10, -4.5359999999999996e-10, -5.7015e-10]],
       'lattice_vectors': [[5.61e-10, 0.0, 0.0],
                           [0.0, 5.67e-10, 0.0],
                           [0.0, 0.0, 9.050000000000001e-10]],
       'normalized_wyckoff': {'a': {'X_1': 1},
                              'c': {'X_2': 1},
                              'd': {'X_2': 1},
                              'f': {'X_1': 1},
                              'u': {'X_0': 8}},
       'normalized_wysytax': {'a': {'X_1': 1},
                              'c': {'X_2': 1},
                              'd': {'X_2': 1},
                              'f': {'X_1': 1},
                              'u': {'X_0': 8}}}],
 18: [{'Notes': '-',
       'Pearsons Symbol': 'oP16',
       'Prototype': 'BaS3',
       'Space Group': 'P21212',
       'Space Group Number': 18,
       'Strukturbericht Designation': '-',
       'Wyckoff Positions': 'abc3',
       'aflow_prototype_id': 'AB3_oP16_18_ab_3c',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB3_oP16_18_ab_3c.html',
       'atom_labels': ['Ba',
                       'Ba',
                       'Ba',
                       'Ba',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S'],
       'atom_positions': [[0.0, 0.0, 0.0],
                          [4.16e-10, 4.820000000000001e-10, 0.0],
                          [0.0, 4.820000000000001e-10, 0.0],
                          [4.16e-10, 0.0, 0.0],
                          [2.08e-10, 2.4100000000000005e-10, 0.0],
                          [2.08e-10, 7.230000000000001e-10, 0.0],
                          [6.24e-10, 2.4100000000000005e-10, 0.0],
                          [6.24e-10, 7.230000000000001e-10, 0.0],
                          [2.08e-10, 0.0, 2.4100000000000005e-10],
                          [2.08e-10,
                           4.820000000000001e-10,
                           2.4100000000000005e-10],
                          [6.24e-10, 0.0, 2.4100000000000005e-10],
                          [6.24e-10,
                           4.820000000000001e-10,
                           2.4100000000000005e-10],
                          [1.0316800000000001e-10,
                           2.97876e-10,
                           1.8412400000000001e-10],
                          [3.12832e-10, 7.798760000000001e-10, 2.97876e-10],
                          [5.19168e-10, 1.8412400000000001e-10, 2.97876e-10],
                          [7.288320000000001e-10,
                           6.66124e-10,
                           1.8412400000000001e-10]],
       'lattice_vectors': [[8.32e-10, 0.0, 0.0],
                           [0.0, 9.64e-10, 0.0],
                           [0.0, 0.0, 4.82e-10]],
       'normalized_wyckoff': {'a': {'X_1': 1},
                              'b': {'X_1': 1},
                              'c': {'X_0': 6}},
       'normalized_wysytax': {'a': {'X_1': 1},
                              'b': {'X_1': 1},
                              'c': {'X_0': 6}}}],
 19: [{'Notes': 'naumannite',
       'Pearsons Symbol': 'oP12',
       'Prototype': 'Ag2Se',
       'Space Group': 'P212121',
       'Space Group Number': 19,
       'Strukturbericht Designation': '-',
       'Wyckoff Positions': 'a3',
       'aflow_prototype_id': 'A2B_oP12_19_2a_a',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2B_oP12_19_2a_a.html',
       'atom_labels': ['Ag',
                       'Ag',
                       'Ag',
                       'Ag',
                       'Au',
                       'Au',
                       'Au',
                       'Au',
                       'Se',
                       'Se',
                       'Se',
                       'Se'],
       'atom_positions': [[-6.196190000000001e-11, 8.40378e-11, 3.540384e-10],
                          [2.7861189999999997e-10, -8.40378e-11, 7.422384e-10],
                          [6.196190000000001e-11, 4.371378e-10, 3.41616e-11],
                          [1.546881e-10, 2.690622e-10, -3.540384e-10],
                          [2.071174e-10, -1.560702e-10, 2.802804e-10],
                          [9.5326e-12, 1.560702e-10, 6.684804e-10],
                          [-2.071174e-10, 1.9702980000000003e-10, 1.079196e-10],
                          [4.237674e-10, 5.091702e-10, -2.802804e-10],
                          [4.67964e-11, -1.0593e-11, 1.156836e-10],
                          [1.6985360000000002e-10, 1.0593e-11, 5.038836e-10],
                          [-4.67964e-11, 3.42507e-10, 2.725164e-10],
                          [2.634464e-10,
                           3.6369300000000004e-10,
                           -1.156836e-10]],
       'lattice_vectors': [[4.3330000000000004e-10, 0.0, 0.0],
                           [0.0, 7.062000000000001e-10, 0.0],
                           [0.0, 0.0, 7.764e-10]],
       'normalized_wyckoff': {'a': {'X_0': 1, 'X_1': 1, 'X_2': 1}},
       'normalized_wysytax': {'a': {'X_0': 1, 'X_1': 1, 'X_2': 1}}}],
 20: [{'Notes': 'orthorhombic tridymite',
       'Pearsons Symbol': 'oC24',
       'Prototype': 'O2Si',
       'Space Group': 'C2221',
       'Space Group Number': 20,
       'Strukturbericht Designation': '-',
       'Wyckoff Positions': 'abc2',
       'aflow_prototype_id': 'A2B_oC24_20_abc_c',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2B_oC24_20_abc_c.html',
       'atom_labels': ['O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'Si',
                       'Si',
                       'Si',
                       'Si'],
       'atom_positions': [[2.915664e-10, 0.0, 0.0],
                          [5.824336e-10, 0.0, 4.12e-10],
                          [4.3700000000000004e-10,
                           3.008879999999999e-11,
                           6.18e-10],
                          [4.3700000000000004e-10,
                           -3.008879999999999e-11,
                           2.06e-10],
                          [2.143922e-10, 9.93384e-11, 2.2355120000000001e-10],
                          [2.2260780000000002e-10, 1.526616e-10, 6.355512e-10],
                          [2.143922e-10, -9.93384e-11, 6.004488000000001e-10],
                          [2.2260780000000002e-10, -1.526616e-10, 1.884488e-10],
                          [2.8976596e-10,
                           1.8088560000000008e-11,
                           6.686183200000001e-10],
                          [2.8976596e-10,
                           -1.8088560000000008e-11,
                           1.5538168e-10],
                          [5.8423404e-10,
                           1.8088560000000008e-11,
                           5.6738168e-10],
                          [5.8423404e-10,
                           -1.8088560000000008e-11,
                           2.5661832e-10]],
       'lattice_vectors': [[4.37e-10, -2.52e-10, 0.0],
                           [4.37e-10, 2.52e-10, 0.0],
                           [0.0, 0.0, 8.24e-10]],
       'normalized_wyckoff': {'a': {'X_0': 1},
                              'b': {'X_0': 1},
                              'c': {'X_0': 2, 'X_1': 2}},
       'normalized_wysytax': {'a': {'X_0': 2},
                              'b': {'X_0': 1},
                              'c': {'X_0': 2, 'X_1': 2}}}],
 25: [{'Notes': '-',
       'Pearsons Symbol': 'oP2',
       'Prototype': 'CdTe',
       'Space Group': 'Pmm2',
       'Space Group Number': 25,
       'Strukturbericht Designation': '-',
       'Wyckoff Positions': 'ab',
       'aflow_prototype_id': 'AB_oP2_25_b_a',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_oP2_25_b_a.html',
       'atom_labels': ['Te', 'Cd'],
       'atom_positions': [[0.0, 0.0, 0.0], [0.0, 2.629e-10, 7.56625e-11]],
       'lattice_vectors': [[2.8102000000000003e-10, 0.0, 0.0],
                           [0.0, 5.258e-10, 0.0],
                           [0.0, 0.0, 3.0265e-10]],
       'normalized_wyckoff': {'a': {'X_0': 1}, 'b': {'X_1': 1}},
       'normalized_wysytax': {'a': {'X_0': 1}, 'b': {'X_1': 1}}}],
 28: [{'Notes': 'krennerite',
       'Pearsons Symbol': 'oP24',
       'Prototype': 'AuTe2',
       'Space Group': 'Pma2',
       'Space Group Number': 28,
       'Strukturbericht Designation': 'C46',
       'Wyckoff Positions': 'ac3d4',
       'aflow_prototype_id': 'AB2_oP24_28_acd_2c3d',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB2_oP24_28_acd_2c3d.html',
       'atom_labels': ['Au',
                       'Au',
                       'Au',
                       'Au',
                       'Au',
                       'Au',
                       'Au',
                       'Au',
                       'Te',
                       'Te',
                       'Te',
                       'Te',
                       'Te',
                       'Te',
                       'Te',
                       'Te',
                       'Te',
                       'Te',
                       'Te',
                       'Te',
                       'Te',
                       'Te',
                       'Te',
                       'Te'],
       'atom_positions': [[0.0, 0.0, 0.0],
                          [8.269999999999999e-10, 0.0, 0.0],
                          [4.1349999999999997e-10,
                           2.8135800000000003e-10,
                           6.2440000000000005e-12],
                          [1.2405e-09, 6.00642e-10, 6.2440000000000005e-12],
                          [2.0509599999999999e-10, 5.87412e-10, 2.23e-10],
                          [6.219039999999999e-10, 5.87412e-10, 2.23e-10],
                          [1.032096e-09, 2.9458800000000005e-10, 2.23e-10],
                          [1.4489039999999999e-09,
                           2.9458800000000005e-10,
                           2.23e-10],
                          [4.1349999999999997e-10, 1.5876e-11, 1.8732e-11],
                          [1.2405e-09, 8.661239999999999e-10, 1.8732e-11],
                          [4.1349999999999997e-10,
                           5.441940000000001e-10,
                           1.8732e-11],
                          [1.2405e-09, 3.37806e-10, 1.8732e-11],
                          [4.961999999999999e-12, 6.16518e-10, 1.8732e-11],
                          [8.22038e-10, 6.16518e-10, 1.8732e-11],
                          [8.319619999999999e-10, 2.65482e-10, 1.8732e-11],
                          [1.649038e-09, 2.65482e-10, 1.8732e-11],
                          [2.18328e-10, 3.21048e-10, 2.23e-10],
                          [6.086719999999999e-10, 3.21048e-10, 2.23e-10],
                          [1.045328e-09, 5.60952e-10, 2.23e-10],
                          [1.4356719999999999e-09, 5.60952e-10, 2.23e-10],
                          [1.96826e-10, 8.50248e-10, 2.23e-10],
                          [6.30174e-10, 8.50248e-10, 2.23e-10],
                          [1.023826e-09, 3.1752e-11, 2.23e-10],
                          [1.4571739999999999e-09, 3.1752e-11, 2.23e-10]],
       'lattice_vectors': [[1.654e-09, 0.0, 0.0],
                           [0.0, 8.82e-10, 0.0],
                           [0.0, 0.0, 4.46e-10]],
       'normalized_wyckoff': {'a': {'X_1': 1},
                              'c': {'X_0': 2, 'X_1': 1},
                              'd': {'X_0': 6, 'X_1': 2}},
       'normalized_wysytax': {'a': {'X_1': 1},
                              'c': {'X_0': 2, 'X_1': 1},
                              'd': {'X_0': 6, 'X_1': 2}}}],
 31: [{'Notes': 'enargite',
       'Pearsons Symbol': 'oP16',
       'Prototype': 'AsCu3S4',
       'Space Group': 'P2m1',
       'Space Group Number': 31,
       'Strukturbericht Designation': 'H25',
       'Wyckoff Positions': 'a4b2',
       'aflow_prototype_id': 'AB3C4_oP16_31_a_ab_2ab',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB3C4_oP16_31_a_ab_2ab.html',
       'atom_labels': ['As',
                       'As',
                       'Cu',
                       'Cu',
                       'Cu',
                       'Cu',
                       'Cu',
                       'Cu',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S'],
       'atom_positions': [[0.0, 5.341128000000001e-10, 0.0],
                          [3.7150000000000006e-10,
                           1.1188720000000003e-10,
                           3.09e-10],
                          [0.0, 9.780440000000001e-11, 3.079494e-10],
                          [3.7150000000000006e-10,
                           5.481956000000001e-10,
                           6.169494000000001e-10],
                          [1.832238e-10,
                           2.1027300000000004e-10,
                           6.097188000000001e-10],
                          [1.8827620000000002e-10,
                           4.3572700000000003e-10,
                           3.0071880000000005e-10],
                          [5.547238000000001e-10,
                           4.3572700000000003e-10,
                           3.0071880000000005e-10],
                          [5.597762e-10,
                           2.1027300000000004e-10,
                           6.097188000000001e-10],
                          [0.0, 5.313996e-10, 3.9885720000000004e-10],
                          [3.7150000000000006e-10,
                           1.1460040000000002e-10,
                           8.985720000000001e-11],
                          [0.0, 9.276560000000001e-11, 7.205880000000001e-11],
                          [3.7150000000000006e-10,
                           5.532344000000001e-10,
                           3.810588e-10],
                          [1.7846860000000002e-10,
                           4.286856000000001e-10,
                           7.31712e-11],
                          [1.930314e-10,
                           2.1731440000000003e-10,
                           3.8217120000000006e-10],
                          [5.499686e-10,
                           2.1731440000000003e-10,
                           3.8217120000000006e-10],
                          [5.645314e-10, 4.286856000000001e-10, 7.31712e-11]],
       'lattice_vectors': [[7.43e-10, 0.0, 0.0],
                           [0.0, 6.46e-10, 0.0],
                           [0.0, 0.0, 6.18e-10]],
       'normalized_wyckoff': {'a': {'X_0': 2, 'X_1': 1, 'X_2': 1},
                              'b': {'X_0': 2, 'X_1': 2}},
       'normalized_wysytax': {'a': {'X_0': 2, 'X_1': 1, 'X_2': 1},
                              'b': {'X_0': 2, 'X_1': 2}}}],
 33: [{'Notes': 'modderite',
       'Pearsons Symbol': 'oP8',
       'Prototype': 'AsCo',
       'Space Group': 'Pna21',
       'Space Group Number': 33,
       'Strukturbericht Designation': '-',
       'Wyckoff Positions': 'a2',
       'aflow_prototype_id': 'AB_oP8_33_a_a',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_oP8_33_a_a.html',
       'atom_labels': ['As', 'As', 'As', 'As', 'Co', 'Co', 'Co', 'Co'],
       'atom_positions': [[1.05502572e-10,
                           3.4471562500000003e-10,
                           8.7416798e-11],
                          [1.5878242799999997e-10,
                           5.087122499999999e-11,
                           2.61831798e-10],
                          [3.6978757199999994e-10,
                           -5.087122499999999e-11,
                           8.7416798e-11],
                          [4.2306742799999996e-10,
                           2.42503775e-10,
                           2.61831798e-10],
                          [1.0571399999999999e-12, 1.17526025e-10, 8.72075e-11],
                          [-1.0571399999999999e-12,
                           4.69223975e-10,
                           2.616225e-10],
                          [2.6322785999999996e-10,
                           4.10901025e-10,
                           2.616225e-10],
                          [2.6534213999999995e-10,
                           1.75848975e-10,
                           8.72075e-11]],
       'lattice_vectors': [[5.2857e-10, 0.0, 0.0],
                           [0.0, 5.8675e-10, 0.0],
                           [0.0, 0.0, 3.4883e-10]]},
      {'Notes': '-',
       'Pearsons Symbol': 'oP32',
       'Prototype': 'AsK3S4',
       'Space Group': 'Pna21',
       'Space Group Number': 33,
       'Strukturbericht Designation': '-',
       'Wyckoff Positions': 'a8',
       'aflow_prototype_id': 'AB3C4_oP32_33_a_3a_4a',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB3C4_oP32_33_a_3a_4a.html',
       'atom_labels': ['As',
                       'As',
                       'As',
                       'As',
                       'K',
                       'K',
                       'K',
                       'K',
                       'K',
                       'K',
                       'K',
                       'K',
                       'K',
                       'K',
                       'K',
                       'K',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S'],
       'atom_positions': [[1.992357e-10,
                           4.819104000000001e-10,
                           2.1487980000000003e-10],
                          [-1.992357e-10,
                           -4.819104000000001e-10,
                           7.438798000000001e-10],
                          [6.547357e-10, -1.79104e-11, 2.1487980000000003e-10],
                          [2.5626430000000003e-10,
                           9.459104e-10,
                           7.438798000000001e-10],
                          [4.024798e-10, 7.375744e-10, 1.587e-12],
                          [-4.024798e-10, -7.375744e-10, 5.30587e-10],
                          [8.579798e-10, -2.735744e-10, 1.587e-12],
                          [5.3020199999999994e-11, 1.2015744e-09, 5.30587e-10],
                          [4.0885680000000004e-10, 7.454624e-10, 4.386468e-10],
                          [-4.0885680000000004e-10,
                           -7.454624e-10,
                           9.676468e-10],
                          [8.643568e-10, -2.8146239999999997e-10, 4.386468e-10],
                          [4.6643200000000005e-11, 1.2094624e-09, 9.676468e-10],
                          [1.295442e-10, 7.646720000000001e-11, 2.376268e-10],
                          [-1.295442e-10, -7.646720000000001e-11, 7.666268e-10],
                          [5.850442000000001e-10, 3.875328e-10, 2.376268e-10],
                          [3.2595580000000004e-10, 5.404672e-10, 7.666268e-10],
                          [1.74001e-10, 6.954432e-10, 2.3572240000000003e-10],
                          [-1.74001e-10, -6.954432e-10, 7.647224e-10],
                          [6.295010000000001e-10,
                           -2.3144320000000002e-10,
                           2.3572240000000003e-10],
                          [2.81499e-10, 1.1594432e-09, 7.647224e-10],
                          [3.119264e-10, 4.3049920000000007e-10, 4.3907e-11],
                          [-3.119264e-10, -4.3049920000000007e-10, 5.72907e-10],
                          [7.674264e-10, 3.35008e-11, 4.3907e-11],
                          [1.4357359999999999e-10,
                           8.944991999999999e-10,
                           5.72907e-10],
                          [6.2859e-12, 3.827072e-10, 2.340296e-10],
                          [-6.2859e-12, -3.827072e-10, 7.630296000000001e-10],
                          [4.6178590000000005e-10, 8.12928e-11, 2.340296e-10],
                          [4.492141e-10, 8.467072e-10, 7.630296000000001e-10],
                          [3.056405e-10, 4.2131200000000003e-10, 3.979138e-10],
                          [-3.056405e-10,
                           -4.2131200000000003e-10,
                           9.269138e-10],
                          [7.611405000000001e-10, 4.2688e-11, 3.979138e-10],
                          [1.4985949999999998e-10,
                           8.853120000000001e-10,
                           9.269138e-10]],
       'lattice_vectors': [[9.11e-10, 0.0, 0.0],
                           [0.0, 9.28e-10, 0.0],
                           [0.0, 0.0, 1.058e-09]],
       'normalized_wyckoff': {'a': {'X_0': 4, 'X_1': 3, 'X_2': 1}},
       'normalized_wysytax': {'a': {'X_0': 4, 'X_1': 3, 'X_2': 1}}}],
 36: [{'Notes': '-',
       'Pearsons Symbol': 'oC12',
       'Prototype': 'HgBr2',
       'Space Group': 'Cmc21',
       'Space Group Number': 36,
       'Strukturbericht Designation': 'C24',
       'Wyckoff Positions': 'b3',
       'aflow_prototype_id': 'A2B_oC12_36_2a_a',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2B_oC12_36_2a_a.html',
       'atom_labels': ['Hg', 'Hg', 'Br', 'Br', 'Br', 'Br'],
       'atom_positions': [[0.0, 2.2407e-10, 0.0],
                          [0.0, -2.2407e-10, 6.22e-10],
                          [0.0, 4.074e-11, 1.6172e-10],
                          [0.0, -4.074e-11, 7.837200000000001e-10],
                          [0.0, 2.6481e-10, 4.6028000000000004e-10],
                          [0.0, -2.6481e-10, 1.0822800000000001e-09]],
       'lattice_vectors': [[2.31e-10, -3.395e-10, 0.0],
                           [2.31e-10, 3.395e-10, 0.0],
                           [0.0, 0.0, 1.244e-09]],
       'normalized_wyckoff': {'a': {'X_0': 2, 'X_1': 1}},
       'normalized_wysytax': {'a': {'X_0': 2, 'X_1': 1}}}],
 38: [{'Notes': '-',
       'Pearsons Symbol': 'oC12',
       'Prototype': 'Au2V',
       'Space Group': 'Amm2',
       'Space Group Number': 38,
       'Strukturbericht Designation': '-',
       'Wyckoff Positions': 'abde',
       'aflow_prototype_id': 'A2B_oC12_38_de_ab',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2B_oC12_38_de_ab.html',
       'atom_labels': ['Au', 'Au', 'Au', 'Au', 'V', 'V'],
       'atom_positions': [[0.0, 1.4419400000000006e-10, 2.6936e-10],
                          [0.0, -1.4419400000000006e-10, 2.6936e-10],
                          [2.342e-10, 1.4843500000000002e-10, 0.0],
                          [2.342e-10, -1.4843500000000002e-10, 0.0],
                          [0.0, 0.0, 2.8859999999999998e-11],
                          [2.342e-10, 0.0, 2.405e-10]],
       'lattice_vectors': [[4.684e-10, 0.0, 0.0],
                           [0.0, 4.241e-10, -2.405e-10],
                           [0.0, 4.241e-10, 2.405e-10]],
       'normalized_wysytax': {'a': {'X_0': 1},
                              'b': {'X_0': 1},
                              'd': {'X_1': 1},
                              'e': {'X_1': 1}}},
      {'Notes': '-',
       'Pearsons Symbol': 'oC8',
       'Prototype': 'C2CeNi',
       'Space Group': 'Amm2',
       'Space Group Number': 38,
       'Strukturbericht Designation': '-',
       'Wyckoff Positions': 'abe',
       'aflow_prototype_id': 'A2BC_oC8_38_e_a_b',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2BC_oC8_38_e_a_b.html',
       'atom_labels': ['Ce', 'Ni', 'C', 'C'],
       'atom_positions': [[0.0, 0.0, 0.0],
                          [1.9375e-10, 0.0, -2.3760672e-10],
                          [1.9375e-10, 7.0556e-11, 1.7956068e-10],
                          [1.9375e-10, -7.0556e-11, 1.7956068e-10]],
       'lattice_vectors': [[3.875e-10, 0.0, 0.0],
                           [0.0, 2.276e-10, -3.081e-10],
                           [0.0, 2.276e-10, 3.081e-10]],
       'normalized_wyckoff': {'a': {'X_1': 1},
                              'b': {'X_2': 1},
                              'e': {'X_0': 2}},
       'normalized_wysytax': {'a': {'X_0': 1},
                              'b': {'X_1': 1},
                              'e': {'X_2': 1}}}],
 41: [{'Notes': '-',
       'Pearsons Symbol': 'oC24',
       'Prototype': 'PdSn2',
       'Space Group': 'Aba2',
       'Space Group Number': 41,
       'Strukturbericht Designation': 'Ce',
       'Wyckoff Positions': 'ab',
       'aflow_prototype_id': 'AB2_oC24_41_2a_2b',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB2_oC24_41_2a_2b.html',
       'atom_labels': ['Pd',
                       'Pd',
                       'Pd',
                       'Pd',
                       'Sn',
                       'Sn',
                       'Sn',
                       'Sn',
                       'Sn',
                       'Sn',
                       'Sn',
                       'Sn'],
       'atom_positions': [[0.0, 0.0, 1.2155e-11],
                          [3.239e-10, 3.239e-10, 1.2155e-11],
                          [0.0, 0.0, 2.89289e-10],
                          [3.239e-10, 3.239e-10, 2.89289e-10],
                          [2.2154759999999998e-10,
                           1.0235240000000002e-10,
                           1.519375e-10],
                          [-2.2154759999999998e-10,
                           -1.0235240000000002e-10,
                           1.519375e-10],
                          [-1.0235240000000002e-10,
                           2.2154759999999998e-10,
                           1.519375e-10],
                          [1.0235240000000002e-10,
                           -2.2154759999999998e-10,
                           1.519375e-10],
                          [1.6195e-10, 1.6195e-10, -1.519375e-10],
                          [-1.6195e-10, -1.6195e-10, -1.519375e-10],
                          [-1.6195e-10, 1.6195e-10, -1.519375e-10],
                          [1.6195e-10, -1.6195e-10, -1.519375e-10]],
       'lattice_vectors': [[6.478e-10, 0.0, 0.0],
                           [0.0, 3.239e-10, -6.0775e-10],
                           [0.0, 3.239e-10, 6.0775e-10]],
       'normalized_wysytax': {'a': {'X_0': 1}, 'b': {'X_1': 1}}},
      {'Notes': 'PdSn4',
       'Pearsons Symbol': 'oC20',
       'Prototype': 'PtSn4',
       'Space Group': 'Aba2',
       'Space Group Number': 41,
       'Strukturbericht Designation': 'D1c',
       'Wyckoff Positions': 'ab',
       'aflow_prototype_id': 'AB4_oC20_41_a_2b',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB4_oC20_41_a_2b.html',
       'atom_labels': ['Pt',
                       'Pt',
                       'Sn',
                       'Sn',
                       'Sn',
                       'Sn',
                       'Sn',
                       'Sn',
                       'Sn',
                       'Sn'],
       'atom_positions': [[0.0, 0.0, 0.0],
                          [3.19e-10, 3.2095e-10, 0.0],
                          [1.10374e-10, 2.099013e-10, 1.419625e-10],
                          [-1.10374e-10, -2.099013e-10, 1.419625e-10],
                          [-2.0862599999999997e-10, 1.110487e-10, 1.419625e-10],
                          [2.0862599999999997e-10, 2.099013e-10, 7.098125e-10],
                          [2.0862599999999997e-10, 1.110487e-10, -1.419625e-10],
                          [-2.0862599999999997e-10,
                           -1.110487e-10,
                           -1.419625e-10],
                          [-1.10374e-10, 2.099013e-10, -1.419625e-10],
                          [1.10374e-10, -2.099013e-10, -1.419625e-10]],
       'lattice_vectors': [[6.38e-10, 0.0, 0.0],
                           [0.0, 3.2095e-10, -5.6785e-10],
                           [0.0, 3.2095e-10, 5.6785e-10]]}],
 43: [{'Notes': '-',
       'Pearsons Symbol': 'oF72',
       'Prototype': 'GeS2',
       'Space Group': 'Fdd2',
       'Space Group Number': 43,
       'Strukturbericht Designation': 'C44',
       'Wyckoff Positions': 'ab4',
       'aflow_prototype_id': 'AB2_oF72_43_ab_3b',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB2_oF72_43_ab_3b.html',
       'atom_labels': ['Ge',
                       'Ge',
                       'Ge',
                       'Ge',
                       'Ge',
                       'Ge',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S'],
       'atom_positions': [[0.0, 0.0, 0.0],
                          [2.9150000000000003e-10, 5.585e-10, 1.715e-10],
                          [1.4575000000000001e-10, 3.0829200000000005e-10, 0.0],
                          [-1.4575000000000001e-10,
                           -3.0829200000000005e-10,
                           0.0],
                          [4.3724999999999996e-10, 2.50208e-10, 1.715e-10],
                          [1.4575000000000001e-10,
                           8.667920000000001e-10,
                           1.715e-10],
                          [2.5652000000000004e-11, 1.80954e-10, 1.25538e-10],
                          [-2.5652000000000004e-11, -1.80954e-10, 1.25538e-10],
                          [3.17152e-10, 3.7754599999999997e-10, 2.97038e-10],
                          [2.65848e-10, 7.39454e-10, 2.97038e-10],
                          [1.78398e-10, -3.1276e-11, -1.25538e-10],
                          [-1.78398e-10, 3.1276e-11, -1.25538e-10],
                          [4.69898e-10, 5.89776e-10, 4.5962e-11],
                          [1.13102e-10, 5.27224e-10, 4.5962e-11],
                          [7.229200000000001e-11,
                           2.7925e-10,
                           -1.9070800000000001e-10],
                          [-7.229200000000001e-11,
                           -2.7925e-10,
                           -1.9070800000000001e-10],
                          [3.63792e-10, 2.7925e-10, -1.9208e-11],
                          [2.19208e-10, 8.3775e-10, -1.9208e-11]],
       'lattice_vectors': [[0.0, 1.117e-09, 3.43e-10],
                           [5.830000000000001e-10, 0.0, 3.43e-10],
                           [5.830000000000001e-10, 1.117e-09, 0.0]],
       'normalized_wyckoff': {'a': {'X_1': 1}, 'b': {'X_0': 6, 'X_1': 2}},
       'normalized_wysytax': {'a': {'X_1': 1}, 'b': {'X_0': 6, 'X_1': 2}}}],
 44: [{'Notes': '> 24 GPa',
       'Pearsons Symbol': 'oI4',
       'Prototype': 'AsGa',
       'Space Group': 'Imm2',
       'Space Group Number': 44,
       'Strukturbericht Designation': '-',
       'Wyckoff Positions': 'ab',
       'aflow_prototype_id': 'AB_oI4_44_a_b',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_oI4_44_a_b.html',
       'atom_labels': ['As', 'Ga'],
       'atom_positions': [[0.0, 0.0, 0.0],
                          [-2.4600000000000003e-10, 0.0, -1.97625e-11]],
       'lattice_vectors': [[4.920000000000001e-10, 0.0, 0.0],
                           [0.0, 4.79e-10, 0.0],
                           [2.4600000000000003e-10,
                            2.395e-10,
                            1.3174999999999998e-10]],
       'normalized_wyckoff': {'a': {'X_0': 1}, 'b': {'X_1': 1}},
       'normalized_wysytax': {'a': {'X_0': 1}, 'b': {'X_1': 1}}}],
 47: [{'Notes': '-',
       'Pearsons Symbol': 'oP13',
       'Prototype': 'Ba2Cu3O7-xY',
       'Space Group': 'Pmmm',
       'Space Group Number': 47,
       'Strukturbericht Designation': '-',
       'Wyckoff Positions': 'abehq2rst',
       'aflow_prototype_id': 'A2B3C7D_oP13_47_t_aq_eqrs_h',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2B3C7D_oP13_47_t_aq_eqrs_h.html',
       'atom_labels': ['Ba',
                       'Ba',
                       'Cu',
                       'Cu',
                       'Cu',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'Y'],
       'atom_positions': [[1.90935e-10, 1.94165e-10, 2.152291715e-10],
                          [1.90935e-10, 1.94165e-10, 9.516408285e-10],
                          [0.0, 0.0, 0.0],
                          [0.0, 0.0, 4.14705598e-10],
                          [0.0, 0.0, 7.52164402e-10],
                          [0.0, 1.94165e-10, 0.0],
                          [0.0, 0.0, 1.84248773e-10],
                          [0.0, 0.0, 9.82621227e-10],
                          [0.0, 1.94165e-10, 4.4002667699999994e-10],
                          [0.0, 1.94165e-10, 7.26843323e-10],
                          [1.90935e-10, 0.0, 4.4201035600000003e-10],
                          [1.90935e-10, 0.0, 7.248596439999999e-10],
                          [1.90935e-10, 1.94165e-10, 5.83435e-10]],
       'lattice_vectors': [[3.8187e-10, 0.0, 0.0],
                           [0.0, 3.8833e-10, 0.0],
                           [0.0, 0.0, 1.16687e-09]],
       'normalized_wyckoff': {'a': {'X_3': 1},
                              'd': {'X_0': 1},
                              'h': {'X_1': 1},
                              'i': {'X_2': 2},
                              'j': {'X_0': 2},
                              'k': {'X_0': 2},
                              'l': {'X_0': 2, 'X_1': 2}},
       'normalized_wysytax': {'a': {'X_1': 1},
                              'e': {'X_0': 1},
                              'h': {'X_3': 1},
                              'q': {'X_0': 2, 'X_1': 2},
                              'r': {'X_0': 2},
                              's': {'X_0': 2},
                              't': {'X_2': 2}}}],
 51: [{'Notes': '-',
       'Pearsons Symbol': 'oP4',
       'Prototype': 'AuCd',
       'Space Group': 'Pmma',
       'Space Group Number': 51,
       'Strukturbericht Designation': 'B19',
       'Wyckoff Positions': 'ef',
       'aflow_prototype_id': 'AB_oP4_51_e_f',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_oP4_51_e_f.html',
       'atom_labels': ['Au', 'Au', 'Cd', 'Cd'],
       'atom_positions': [[1.1887250000000002e-10, 0.0, 3.9443625e-10],
                          [3.566175e-10, 0.0, 9.102374999999999e-11],
                          [1.1887250000000002e-10, 1.5738e-10, 1.5170625e-10],
                          [3.566175e-10, 1.5738e-10, 3.3375374999999997e-10]],
       'lattice_vectors': [[4.7549e-10, 0.0, 0.0],
                           [0.0, 3.1476e-10, 0.0],
                           [0.0, 0.0, 4.8546e-10]],
       'normalized_wyckoff': {'e': {'X_0': 1}, 'f': {'X_1': 1}},
       'normalized_wysytax': {'e': {'X_0': 1}, 'f': {'X_1': 1}}}],
 56: [{'Notes': '-',
       'Pearsons Symbol': 'oP20',
       'Prototype': 'O3Sb2',
       'Space Group': 'Pccn',
       'Space Group Number': 56,
       'Strukturbericht Designation': 'D511',
       'Wyckoff Positions': 'ce2',
       'aflow_prototype_id': 'A3B2_oP20_56_ce_e',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A3B2_oP20_56_ce_e.html',
       'atom_labels': ['O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'Sb',
                       'Sb',
                       'Sb',
                       'Sb',
                       'Sb',
                       'Sb',
                       'Sb',
                       'Sb'],
       'atom_positions': [[1.22775e-10,
                           3.1160000000000004e-10,
                           1.2393480000000001e-11],
                          [3.68325e-10,
                           9.348000000000001e-10,
                           2.5820652000000004e-10],
                          [3.68325e-10,
                           9.348000000000001e-10,
                           -1.2393480000000001e-11],
                          [1.22775e-10, 3.1160000000000004e-10, 2.8299348e-10],
                          [7.464720000000001e-11,
                           7.366224000000001e-11,
                           4.6294248e-10],
                          [1.709028e-10, 5.495377600000001e-10, 4.6294248e-10],
                          [-7.464720000000001e-11,
                           6.968622400000001e-10,
                           -1.9234248000000001e-10],
                          [3.2019720000000003e-10,
                           -7.366224000000001e-11,
                           -1.9234248000000001e-10],
                          [-7.464720000000001e-11,
                           -7.366224000000001e-11,
                           -4.6294248e-10],
                          [3.2019720000000003e-10,
                           6.968622400000001e-10,
                           -4.6294248e-10],
                          [7.464720000000001e-11,
                           5.495377600000001e-10,
                           1.9234248000000001e-10],
                          [1.709028e-10,
                           7.366224000000001e-11,
                           1.9234248000000001e-10],
                          [2.0375739e-11, 1.5885368e-10, 9.657714e-11],
                          [2.25174261e-10,
                           4.6434632000000005e-10,
                           9.657714e-11],
                          [-2.0375739e-11,
                           7.820536800000001e-10,
                           1.7402286e-10],
                          [2.6592573900000003e-10,
                           -1.5885368e-10,
                           1.7402286e-10],
                          [-2.0375739e-11, -1.5885368e-10, -9.657714e-11],
                          [2.6592573900000003e-10,
                           7.820536800000001e-10,
                           -9.657714e-11],
                          [2.0375739e-11,
                           4.6434632000000005e-10,
                           -1.7402286e-10],
                          [2.25174261e-10, 1.5885368e-10, -1.7402286e-10]],
       'lattice_vectors': [[4.911e-10, 0.0, 0.0],
                           [0.0, 1.2464000000000002e-09, 0.0],
                           [0.0, 0.0, 5.412000000000001e-10]],
       'normalized_wyckoff': {'c': {'X_0': 1}, 'e': {'X_0': 2, 'X_1': 2}},
       'normalized_wysytax': {'c': {'X_0': 1}, 'e': {'X_0': 2, 'X_1': 2}}}],
 57: [{'Notes': '-',
       'Pearsons Symbol': 'oP16',
       'Prototype': 'CKNS',
       'Space Group': 'Pbcm',
       'Space Group Number': 57,
       'Strukturbericht Designation': 'F59',
       'Wyckoff Positions': 'cd3',
       'aflow_prototype_id': 'ABCD_oP16_57_d_c_d_d',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/ABCD_oP16_57_d_c_d_d.html',
       'atom_labels': ['K',
                       'K',
                       'K',
                       'K',
                       'C',
                       'C',
                       'C',
                       'C',
                       'N',
                       'N',
                       'N',
                       'N',
                       'S',
                       'S',
                       'S',
                       'S'],
       'atom_positions': [[1.4119200000000002e-10, 1.65875e-10, 0.0],
                          [-1.4119200000000002e-10,
                           4.97625e-10,
                           3.7900000000000004e-10],
                          [-1.4119200000000002e-10, 4.97625e-10, 0.0],
                          [1.4119200000000002e-10,
                           1.65875e-10,
                           3.7900000000000004e-10],
                          [-5.328000000000001e-11,
                           2.654e-10,
                           1.8950000000000002e-10],
                          [5.328000000000001e-11, -2.654e-10, 5.685e-10],
                          [5.328000000000001e-11,
                           5.971500000000001e-10,
                           1.8950000000000002e-10],
                          [-5.328000000000001e-11, 6.635e-11, 5.685e-10],
                          [-1.3653e-10, 1.8578e-10, 1.8950000000000002e-10],
                          [1.3653e-10, -1.8578e-10, 5.685e-10],
                          [1.3653e-10, 5.1753e-10, 1.8950000000000002e-10],
                          [-1.3653e-10, 1.4597000000000001e-10, 5.685e-10],
                          [-2.6640000000000003e-10,
                           6.303250000000001e-11,
                           1.8950000000000002e-10],
                          [2.6640000000000003e-10,
                           -6.303250000000001e-11,
                           5.685e-10],
                          [2.6640000000000003e-10,
                           3.9478250000000003e-10,
                           1.8950000000000002e-10],
                          [-2.6640000000000003e-10, 2.687175e-10, 5.685e-10]],
       'lattice_vectors': [[6.660000000000001e-10, 0.0, 0.0],
                           [0.0, 6.635e-10, 0.0],
                           [0.0, 0.0, 7.580000000000001e-10]],
       'normalized_wyckoff': {'c': {'X_0': 1},
                              'd': {'X_1': 1, 'X_2': 1, 'X_3': 1}},
       'normalized_wysytax': {'c': {'X_0': 1},
                              'd': {'X_1': 1, 'X_2': 1, 'X_3': 1}}}],
 58: [{'Notes': '-',
       'Pearsons Symbol': 'oP6',
       'Prototype': 'CFe2',
       'Space Group': 'Pnnm',
       'Space Group Number': 58,
       'Strukturbericht Designation': '-',
       'Wyckoff Positions': 'ag',
       'aflow_prototype_id': 'AB2_oP6_58_a_g',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB2_oP6_58_a_g.eta-Fe2C.html',
       'atom_labels': ['C', 'C', 'Fe', 'Fe', 'Fe', 'Fe'],
       'atom_positions': [[0.0, 0.0, 0.0],
                          [2.3519999999999997e-10, 2.159e-10, 1.415e-10],
                          [3.1360000000000003e-10, 1.0795e-10, 0.0],
                          [1.5680000000000002e-10, 3.2385e-10, 0.0],
                          [7.840000000000001e-11, 1.0795e-10, 1.415e-10],
                          [3.92e-10, 3.2385e-10, 1.415e-10]],
       'lattice_vectors': [[4.703999999999999e-10, 0.0, 0.0],
                           [0.0, 4.318e-10, 0.0],
                           [0.0, 0.0, 2.83e-10]],
       'normalized_wyckoff': {'a': {'X_1': 1}, 'g': {'X_0': 2}},
       'normalized_wysytax': {'a': {'X_1': 1}, 'g': {'X_0': 2}}},
      {'Notes': '-',
       'Pearsons Symbol': 'oP6',
       'Prototype': 'CaCl2',
       'Space Group': 'Pnnm',
       'Space Group Number': 58,
       'Strukturbericht Designation': 'C35',
       'Wyckoff Positions': 'ag',
       'aflow_prototype_id': 'AB2_oP6_58_a_g',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB2_oP6_58_a_g.CaCl2.html',
       'atom_labels': ['Ca', 'Ca', 'Cl', 'Cl', 'Cl', 'Cl'],
       'atom_positions': [[0.0, 0.0, 0.0],
                          [3.12e-10, 3.215e-10, 2.1000000000000002e-10],
                          [1.716e-10, 2.08975e-10, 0.0],
                          [4.836000000000001e-10,
                           1.1252500000000001e-10,
                           2.1000000000000002e-10],
                          [-1.716e-10, -2.08975e-10, 0.0],
                          [-4.836000000000001e-10,
                           -1.1252500000000001e-10,
                           -2.1000000000000002e-10]],
       'lattice_vectors': [[6.24e-10, 0.0, 0.0],
                           [0.0, 6.43e-10, 0.0],
                           [0.0, 0.0, 4.2000000000000005e-10]],
       'normalized_wyckoff': {'a': {'X_1': 1}, 'g': {'X_0': 2}},
       'normalized_wysytax': {'a': {'X_1': 1}, 'g': {'X_0': 2}}},
      {'Notes': 'marcasite',
       'Pearsons Symbol': 'oP6',
       'Prototype': 'FeS2',
       'Space Group': 'Pnnm',
       'Space Group Number': 58,
       'Strukturbericht Designation': 'C18',
       'Wyckoff Positions': 'ag',
       'aflow_prototype_id': 'AB2_oP6_58_a_g',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB2_oP6_58_a_g.FeS2.html',
       'atom_labels': ['Fe', 'Fe', 'S', 'S', 'S', 'S'],
       'atom_positions': [[0.0, 0.0, 0.0],
                          [2.2223e-10, 2.7123e-10, 1.6932e-10],
                          [8.906978399999999e-11, 2.05429602e-10, 0.0],
                          [1.3316021599999998e-10,
                           4.766596020000001e-10,
                           1.6932e-10],
                          [3.1129978399999993e-10,
                           6.580039799999999e-11,
                           1.6932e-10],
                          [3.5539021599999997e-10,
                           3.3703039799999996e-10,
                           0.0]],
       'lattice_vectors': [[4.4446e-10, 0.0, 0.0],
                           [0.0, 5.4246e-10, 0.0],
                           [0.0, 0.0, 3.3864e-10]],
       'normalized_wyckoff': {'a': {'X_1': 1}, 'g': {'X_0': 2}},
       'normalized_wysytax': {'a': {'X_1': 1}, 'g': {'X_0': 2}}}],
 59: [{'Notes': 'cyanogen chloride',
       'Pearsons Symbol': 'oP6',
       'Prototype': 'CClN',
       'Space Group': 'Pmmn',
       'Space Group Number': 59,
       'Strukturbericht Designation': '-',
       'Wyckoff Positions': 'a3',
       'aflow_prototype_id': 'ABC_oP6_59_a_a_a',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/ABC_oP6_59_a_a_a.html',
       'atom_labels': ['C', 'C', 'N', 'N', 'Cl', 'Cl'],
       'atom_positions': [[1.421e-10, 9.9425e-11, 2.433186e-10],
                          [-1.421e-10, -9.9425e-11, -2.433186e-10],
                          [1.421e-10, 9.9425e-11, 3.592092e-10],
                          [-1.421e-10, -9.9425e-11, -3.592092e-10],
                          [1.421e-10, 9.9425e-11, 8.604260000000001e-11],
                          [-1.421e-10, -9.9425e-11, -8.604260000000001e-11]],
       'lattice_vectors': [[5.684e-10, 0.0, 0.0],
                           [0.0, 3.977e-10, 0.0],
                           [0.0, 0.0, 5.740000000000001e-10]],
       'normalized_wysytax': {'a': {'X_0': 1, 'X_1': 1, 'X_2': 1}}},
      {'Notes': '-',
       'Pearsons Symbol': 'oP4',
       'Prototype': 'CuTe',
       'Space Group': 'Pmmn',
       'Space Group Number': 59,
       'Strukturbericht Designation': '-',
       'Wyckoff Positions': 'ab',
       'aflow_prototype_id': 'AB_oP4_59_a_b',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_oP4_59_a_b.html',
       'atom_labels': ['Te', 'Te', 'Cu', 'Cu'],
       'atom_positions': [[0.0, 0.0, 1.52978e-10],
                          [1.55e-10, 2.0099999999999998e-10, -1.52978e-10],
                          [0.0, 2.0099999999999998e-10, 3.0801400000000004e-10],
                          [1.55e-10, 0.0, -3.0801400000000004e-10]],
       'lattice_vectors': [[3.1e-10, 0.0, 0.0],
                           [0.0, 4.0199999999999996e-10, 0.0],
                           [0.0, 0.0, 6.86e-10]],
       'normalized_wysytax': {'a': {'X_0': 1}, 'b': {'X_1': 1}}},
      {'Notes': '-',
       'Pearsons Symbol': 'oP8',
       'Prototype': 'Cu3Ti (beta)',
       'Space Group': 'Pmmn',
       'Space Group Number': 59,
       'Strukturbericht Designation': 'D0a',
       'Wyckoff Positions': 'abf',
       'aflow_prototype_id': 'A3B_oP8_59_bf_a',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A3B_oP8_59_bf_a.html',
       'atom_labels': ['Sb', 'Sb', 'Cu', 'Cu', 'Cu', 'Cu', 'Cu', 'Cu'],
       'atom_positions': [[0.0, 0.0, -1.57344e-10],
                          [2.752e-10, 2.1765e-10, 1.57344e-10],
                          [0.0, 2.1765e-10, 1.52576e-10],
                          [2.752e-10, 0.0, -1.52576e-10],
                          [1.376e-10, 0.0, 7.77184e-11],
                          [-1.376e-10, 0.0, 7.77184e-11],
                          [1.376e-10, 2.1765e-10, -7.77184e-11],
                          [4.128e-10, 2.1765e-10, -7.77184e-11]],
       'lattice_vectors': [[5.504e-10, 0.0, 0.0],
                           [0.0, 4.353e-10, 0.0],
                           [0.0, 0.0, 4.767999999999999e-10]],
       'normalized_wysytax': {'a': {'X_1': 1},
                              'b': {'X_0': 1},
                              'e': {'X_0': 2}}}],
 61: [{'Notes': '-',
       'Pearsons Symbol': 'oP16',
       'Prototype': 'CdSb',
       'Space Group': 'Pbca',
       'Space Group Number': 61,
       'Strukturbericht Designation': 'Be',
       'Wyckoff Positions': 'c2',
       'aflow_prototype_id': 'AB_oP16_61_c_c',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_oP16_61_c_c.html',
       'atom_labels': ['Cd',
                       'Cd',
                       'Cd',
                       'Cd',
                       'Cd',
                       'Cd',
                       'Cd',
                       'Cd',
                       'Sb',
                       'Sb',
                       'Sb',
                       'Sb',
                       'Sb',
                       'Sb',
                       'Sb',
                       'Sb'],
       'atom_positions': [[3.5598907e-10, 5.1469738e-10, 5.405163720000001e-10],
                          [3.253907e-11,
                           -1.0214738000000002e-10,
                           -5.405163720000001e-10],
                          [-3.5598907e-10,
                           1.0214738000000002e-10,
                           -1.1441637200000002e-10],
                          [-3.253907e-11,
                           -5.1469738e-10,
                           1.1441637200000002e-10],
                          [-3.5598907e-10,
                           -5.1469738e-10,
                           -5.405163720000001e-10],
                          [-3.253907e-11,
                           1.0214738000000002e-10,
                           5.405163720000001e-10],
                          [3.5598907e-10,
                           -1.0214738000000002e-10,
                           1.1441637200000002e-10],
                          [3.253907e-11,
                           5.1469738e-10,
                           -1.1441637200000002e-10],
                          [9.043662e-11, 6.097489e-11, 8.854358e-11],
                          [4.1388662e-10, 3.5157511e-10, -8.854358e-11],
                          [-9.043662e-11, 4.7352489e-10, 3.3755642e-10],
                          [2.3301338e-10, -6.097489e-11, 5.1464358e-10],
                          [-9.043662e-11, -6.097489e-11, -8.854358e-11],
                          [2.3301338e-10, 4.7352489e-10, 8.854358e-11],
                          [9.043662e-11, 3.5157511e-10, 5.1464358e-10],
                          [4.1388662e-10, 6.097489e-11, 3.3755642e-10]],
       'lattice_vectors': [[6.469e-10, 0.0, 0.0],
                           [0.0, 8.251e-10, 0.0],
                           [0.0, 0.0, 8.522e-10]],
       'normalized_wyckoff': {'c': {'X_0': 1, 'X_1': 1}},
       'normalized_wysytax': {'c': {'X_0': 1, 'X_1': 1}}},
      {'Notes': 'brookite',
       'Pearsons Symbol': 'oP24',
       'Prototype': 'O2Ti',
       'Space Group': 'Pbca',
       'Space Group Number': 61,
       'Strukturbericht Designation': 'C21',
       'Wyckoff Positions': 'c3',
       'aflow_prototype_id': 'A2B_oP24_61_2c_c',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2B_oP24_61_2c_c.html',
       'atom_labels': ['O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'Ti',
                       'Ti',
                       'Ti',
                       'Ti',
                       'Ti',
                       'Ti',
                       'Ti',
                       'Ti'],
       'atom_positions': [[8.7153e-12, 5.142459e-11, 9.428229999999999e-11],
                          [8.7153e-12, 1.2102541e-10, 3.511823e-10],
                          [4.499847e-10,
                           2.2387459000000002e-10,
                           9.428229999999999e-11],
                          [4.499847e-10, 2.9347541000000003e-10, 3.511823e-10],
                          [4.674153e-10, 5.142459e-11, 1.626177e-10],
                          [4.674153e-10, 1.2102541e-10, 4.1951769999999995e-10],
                          [9.086847e-10, 2.2387459000000002e-10, 1.626177e-10],
                          [9.086847e-10,
                           2.9347541000000003e-10,
                           4.1951769999999995e-10],
                          [2.1228636e-10,
                           3.8283900000000005e-11,
                           2.7570508e-10],
                          [2.1228636e-10, 1.341661e-10, 1.880508e-11],
                          [2.4641364e-10,
                           2.1073390000000003e-10,
                           2.7570508e-10],
                          [2.4641364e-10, 3.066161e-10, 1.880508e-11],
                          [6.7098636e-10,
                           3.8283900000000005e-11,
                           4.9499492e-10],
                          [6.7098636e-10, 1.341661e-10, 2.3809492e-10],
                          [7.051136399999999e-10,
                           2.1073390000000003e-10,
                           4.9499492e-10],
                          [7.051136399999999e-10, 3.066161e-10, 2.3809492e-10],
                          [1.1825286e-10, 3.352428e-11, 4.4330663999999997e-10],
                          [1.1825286e-10,
                           1.3892572000000002e-10,
                           1.8640664e-10],
                          [3.4044714e-10,
                           2.0597428000000003e-10,
                           4.4330663999999997e-10],
                          [3.4044714e-10, 3.1137572e-10, 1.8640664e-10],
                          [5.7695286e-10, 3.352428e-11, 3.2739336e-10],
                          [5.7695286e-10, 1.3892572000000002e-10, 7.049336e-11],
                          [7.9914714e-10,
                           2.0597428000000003e-10,
                           3.2739336e-10],
                          [7.9914714e-10, 3.1137572e-10, 7.049336e-11]],
       'lattice_vectors': [[9.174e-10, 0.0, 0.0],
                           [0.0, 3.449e-10, 0.0],
                           [0.0, 0.0, 5.138e-10]],
       'normalized_wyckoff': {'c': {'X_0': 2, 'X_1': 1}},
       'normalized_wysytax': {'c': {'X_0': 2, 'X_1': 1}}}],
 62: [{'Notes': '-',
       'Pearsons Symbol': 'oP8',
       'Prototype': 'BFe',
       'Space Group': 'Pnma',
       'Space Group Number': 62,
       'Strukturbericht Designation': 'B27',
       'Wyckoff Positions': 'c2',
       'aflow_prototype_id': 'AB_oP8_62_c_c',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_oP8_62_c_c.FeB.html',
       'atom_labels': ['B', 'B', 'B', 'B', 'Fe', 'Fe', 'Fe', 'Fe'],
       'atom_positions': [[1.9782e-11, 7.365000000000001e-11, 2.47233e-10],
                          [-1.9782e-11, 2.2095e-10, -2.47233e-10],
                          [2.54968e-10, 2.2095e-10, 4.4583e-11],
                          [2.9453200000000003e-10,
                           7.365000000000001e-11,
                           -4.4583e-11],
                          [9.891e-11, 7.365000000000001e-11, 5.06625e-11],
                          [-9.891e-11, 2.2095e-10, -5.06625e-11],
                          [1.7584e-10, 2.2095e-10, 2.533125e-10],
                          [3.7366000000000003e-10,
                           7.365000000000001e-11,
                           1.5198750000000001e-10]],
       'lattice_vectors': [[5.495e-10, 0.0, 0.0],
                           [0.0, 2.9460000000000005e-10, 0.0],
                           [0.0, 0.0, 4.053e-10]],
       'normalized_wyckoff': {'c': {'X_0': 1, 'X_1': 1}},
       'normalized_wysytax': {'c': {'X_0': 1, 'X_1': 1}}},
      {'Notes': '-',
       'Pearsons Symbol': 'oP20',
       'Prototype': 'B4Mg',
       'Space Group': 'Pnma',
       'Space Group Number': 62,
       'Strukturbericht Designation': '-',
       'Wyckoff Positions': 'c3d',
       'aflow_prototype_id': 'A4B_oP20_62_2cd_c',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A4B_oP20_62_2cd_c.html',
       'atom_labels': ['B',
                       'B',
                       'B',
                       'B',
                       'B',
                       'B',
                       'B',
                       'B',
                       'Mg',
                       'Mg',
                       'Mg',
                       'Mg',
                       'B',
                       'B',
                       'B',
                       'B',
                       'B',
                       'B',
                       'B',
                       'B'],
       'atom_positions': [[3.9614e-10, 1.107e-10, 2.562896e-10],
                          [-1.2294000000000002e-10,
                           3.321e-10,
                           6.298896000000001e-10],
                          [-3.9614e-10, 3.321e-10, -2.562896e-10],
                          [6.6934e-10, 1.107e-10, 1.173104e-10],
                          [3.054376e-10, 1.107e-10, 1.0909120000000002e-10],
                          [-3.22376e-11, 3.321e-10, 4.826912e-10],
                          [-3.054376e-10, 3.321e-10, -1.0909120000000002e-10],
                          [5.786376e-10, 1.107e-10, 2.645088e-10],
                          [2.7866400000000003e-11, 1.107e-10, 6.455808e-10],
                          [2.4533360000000003e-10, 3.321e-10, 1.0191808e-09],
                          [-2.7866400000000003e-11, 3.321e-10, -6.455808e-10],
                          [3.0106639999999996e-10, 1.107e-10, -2.719808e-10],
                          [7.1032e-11, 1.957176e-10, 4.229152e-10],
                          [2.02168e-10, -1.957176e-10, 7.965152e-10],
                          [-7.1032e-11, 4.171176e-10, -4.229152e-10],
                          [3.4423200000000003e-10, 2.56824e-11, -4.93152e-11],
                          [-7.1032e-11, -1.957176e-10, -4.229152e-10],
                          [3.4423200000000003e-10, 1.957176e-10, -4.93152e-11],
                          [7.1032e-11, 2.56824e-11, 4.229152e-10],
                          [2.02168e-10, 4.171176e-10, 7.965152e-10]],
       'lattice_vectors': [[5.464000000000001e-10, 0.0, 0.0],
                           [0.0, 4.428e-10, 0.0],
                           [0.0, 0.0, 7.472000000000001e-10]],
       'normalized_wyckoff': {'c': {'X_0': 2, 'X_1': 1}, 'd': {'X_0': 2}},
       'normalized_wysytax': {'c': {'X_0': 2, 'X_1': 1}, 'd': {'X_0': 2}}},
      {'Notes': '-',
       'Pearsons Symbol': 'oP40',
       'Prototype': 'C3Cr7',
       'Space Group': 'Pnma',
       'Space Group Number': 62,
       'Strukturbericht Designation': 'D101',
       'Wyckoff Positions': 'c4d3',
       'aflow_prototype_id': 'A3B7_oP40_62_cd_3c2d',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A3B7_oP40_62_cd_3c2d.html',
       'atom_labels': ['C',
                       'C',
                       'C',
                       'C',
                       'C',
                       'C',
                       'C',
                       'C',
                       'C',
                       'C',
                       'C',
                       'C',
                       'Cr',
                       'Cr',
                       'Cr',
                       'Cr',
                       'Cr',
                       'Cr',
                       'Cr',
                       'Cr',
                       'Cr',
                       'Cr',
                       'Cr',
                       'Cr',
                       'Cr',
                       'Cr',
                       'Cr',
                       'Cr',
                       'Cr',
                       'Cr',
                       'Cr',
                       'Cr',
                       'Cr',
                       'Cr',
                       'Cr',
                       'Cr',
                       'Cr',
                       'Cr',
                       'Cr',
                       'Cr'],
       'atom_positions': [[2.0792444e-10, 1.7525e-10, 6.8347318e-10],
                          [-2.0792444e-10,
                           5.257500000000001e-10,
                           -6.8347318e-10],
                          [1.837556e-11, 5.257500000000001e-10, 7.637318e-11],
                          [4.3422444000000006e-10, 1.7525e-10, -7.637318e-11],
                          [1.3034879999999999e-11,
                           2.0399100000000003e-11,
                           4.1622776000000007e-10],
                          [-1.3034879999999999e-11,
                           -2.0399100000000003e-11,
                           -4.1622776000000007e-10],
                          [2.3933488e-10, 3.301009e-10, 1.9087224e-10],
                          [2.1326512000000003e-10,
                           3.708991e-10,
                           1.02332776e-09],
                          [-1.3034879999999999e-11,
                           3.708991e-10,
                           -4.1622776000000007e-10],
                          [1.3034879999999999e-11,
                           3.301009e-10,
                           4.1622776000000007e-10],
                          [2.1326512000000003e-10,
                           -2.0399100000000003e-11,
                           1.02332776e-09],
                          [2.3933488e-10,
                           2.0399100000000003e-11,
                           1.9087224e-10],
                          [2.620554e-11, 1.7525e-10, 7.6021062e-10],
                          [-2.620554e-11,
                           5.257500000000001e-10,
                           -7.6021062e-10],
                          [2.0009446e-10, 5.257500000000001e-10, 1.5311062e-10],
                          [2.5250553999999997e-10, 1.7525e-10, -1.5311062e-10],
                          [1.1319526e-10, 1.7525e-10, 2.5048946e-10],
                          [-1.1319526e-10,
                           5.257500000000001e-10,
                           -2.5048946e-10],
                          [1.1310474e-10,
                           5.257500000000001e-10,
                           -3.5661054e-10],
                          [3.3949526e-10, 1.7525e-10, 3.5661054e-10],
                          [1.1853594000000002e-10, 1.7525e-10, 5.057143e-10],
                          [-1.1853594000000002e-10,
                           5.257500000000001e-10,
                           -5.057143e-10],
                          [1.0776406000000002e-10,
                           5.257500000000001e-10,
                           -1.0138570000000001e-10],
                          [3.4483594000000003e-10,
                           1.7525e-10,
                           1.0138570000000001e-10],
                          [2.5571899999999997e-11,
                           4.50042e-11,
                           9.858089800000001e-10],
                          [-2.5571899999999997e-11,
                           -4.50042e-11,
                           -9.858089800000001e-10],
                          [2.518719e-10,
                           3.0549580000000004e-10,
                           -3.7870898e-10],
                          [2.007281e-10, 3.955042e-10, 1.59290898e-09],
                          [-2.5571899999999997e-11,
                           3.955042e-10,
                           -9.858089800000001e-10],
                          [2.5571899999999997e-11,
                           3.0549580000000004e-10,
                           9.858089800000001e-10],
                          [2.007281e-10, -4.50042e-11, 1.59290898e-09],
                          [2.518719e-10, 4.50042e-11, -3.7870898e-10],
                          [1.1355734e-10, 4.60557e-11, 2.6469559999999998e-11],
                          [-1.1355734e-10,
                           -4.60557e-11,
                           -2.6469559999999998e-11],
                          [3.3985734000000004e-10, 3.044443e-10, 5.8063044e-10],
                          [1.1274266e-10, 3.965557e-10, 6.3356956e-10],
                          [-1.1355734e-10,
                           3.965557e-10,
                           -2.6469559999999998e-11],
                          [1.1355734e-10, 3.044443e-10, 2.6469559999999998e-11],
                          [1.1274266e-10, -4.60557e-11, 6.3356956e-10],
                          [3.3985734000000004e-10, 4.60557e-11, 5.8063044e-10]],
       'lattice_vectors': [[4.526e-10, 0.0, 0.0],
                           [0.0, 7.01e-10, 0.0],
                           [0.0, 0.0, 1.2142e-09]],
       'normalized_wyckoff': {'c': {'X_0': 3, 'X_1': 1},
                              'd': {'X_0': 4, 'X_1': 2}},
       'normalized_wysytax': {'c': {'X_0': 3, 'X_1': 1},
                              'd': {'X_0': 4, 'X_1': 2}}},
      {'Notes': 'cementite',
       'Pearsons Symbol': 'oP16',
       'Prototype': 'CFe3',
       'Space Group': 'Pnma',
       'Space Group Number': 62,
       'Strukturbericht Designation': 'D011',
       'Wyckoff Positions': 'c2d',
       'aflow_prototype_id': 'AB3_oP16_62_c_cd',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB3_oP16_62_c_cd.html',
       'atom_labels': ['C',
                       'C',
                       'C',
                       'C',
                       'Fe',
                       'Fe',
                       'Fe',
                       'Fe',
                       'Fe',
                       'Fe',
                       'Fe',
                       'Fe',
                       'Fe',
                       'Fe',
                       'Fe',
                       'Fe'],
       'atom_positions': [[5.5990000000000005e-11,
                           5.061e-10,
                           -2.0353499999999999e-10],
                          [1.9851e-10,
                           1.6870000000000002e-10,
                           2.2614999999999998e-11],
                          [3.1049e-10, 5.061e-10, 4.2968499999999995e-10],
                          [4.5301e-10,
                           1.6870000000000002e-10,
                           2.0353499999999999e-10],
                          [1.8324e-11, 1.6870000000000002e-10, 3.853596e-10],
                          [-1.8324e-11, 5.061e-10, 6.694039999999999e-11],
                          [2.36176e-10, 5.061e-10, 1.592096e-10],
                          [2.72824e-10, 1.6870000000000002e-10, 2.930904e-10],
                          [9.467399999999999e-11, 4.25124e-11, 1.483544e-10],
                          [9.467399999999999e-11, 2.948876e-10, 1.483544e-10],
                          [1.59826e-10, -4.25124e-11, 3.7450439999999995e-10],
                          [1.59826e-10, 3.799124e-10, 3.7450439999999995e-10],
                          [3.49174e-10, 4.25124e-11, 7.779559999999999e-11],
                          [3.49174e-10, 2.948876e-10, 7.779559999999999e-11],
                          [4.1432599999999997e-10,
                           3.799124e-10,
                           3.0394559999999996e-10],
                          [4.1432599999999997e-10,
                           6.322876e-10,
                           3.0394559999999996e-10]],
       'lattice_vectors': [[5.09e-10, 0.0, 0.0],
                           [0.0, 6.748e-10, 0.0],
                           [0.0, 0.0, 4.523e-10]],
       'normalized_wyckoff': {'c': {'X_0': 1, 'X_1': 1}, 'd': {'X_0': 2}},
       'normalized_wysytax': {'c': {'X_0': 1, 'X_1': 1}, 'd': {'X_0': 2}}},
      {'Notes': 'perovskite',
       'Pearsons Symbol': 'oP20',
       'Prototype': 'CaO3Ti',
       'Space Group': 'Pnma',
       'Space Group Number': 62,
       'Strukturbericht Designation': '-',
       'Wyckoff Positions': 'ac2d',
       'aflow_prototype_id': 'AB3C_oP20_62_c_cd_a',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB3C_oP20_62_c_cd_a.html',
       'atom_labels': ['Ca',
                       'Ca',
                       'Ca',
                       'Ca',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'Ti',
                       'Ti',
                       'Ti',
                       'Ti'],
       'atom_positions': [[-6.6695519999999995e-12,
                           1.91275e-10,
                           2.7475461199999996e-10],
                          [6.6695519999999995e-12,
                           5.73825e-10,
                           2.6567538799999996e-10],
                          [2.64450448e-10,
                           1.91275e-10,
                           -4.5396119999999994e-12],
                          [2.77789552e-10, 5.73825e-10, 4.5396119999999994e-12],
                          [1.6972112e-11, 1.91275e-10, 3.1669197999999995e-11],
                          [-1.6972112e-11,
                           5.73825e-10,
                           -3.1669197999999995e-11],
                          [2.54147888e-10, 5.73825e-10, 3.0188419799999995e-10],
                          [2.88092112e-10, 1.91275e-10, 2.3854580199999996e-10],
                          [1.1495487999999999e-10,
                           2.83087e-11,
                           3.8532658999999996e-10],
                          [1.1495487999999999e-10,
                           3.5424129999999996e-10,
                           3.8532658999999996e-10],
                          [1.5616512e-10,
                           4.1085869999999996e-10,
                           1.1511158999999998e-10],
                          [1.5616512e-10, 7.367913e-10, 1.1511158999999998e-10],
                          [3.8607487999999996e-10,
                           2.83087e-11,
                           4.2531840999999993e-10],
                          [3.8607487999999996e-10,
                           3.5424129999999996e-10,
                           4.2531840999999993e-10],
                          [4.2728512e-10, -2.83087e-11, 1.5510340999999998e-10],
                          [4.2728512e-10,
                           4.1085869999999996e-10,
                           1.5510340999999998e-10],
                          [0.0, 0.0, 0.0],
                          [0.0, 3.8255e-10, 0.0],
                          [2.7112e-10, 0.0, 2.70215e-10],
                          [2.7112e-10, 3.8255e-10, 2.70215e-10]],
       'lattice_vectors': [[5.4224e-10, 0.0, 0.0],
                           [0.0, 7.651e-10, 0.0],
                           [0.0, 0.0, 5.4043e-10]],
       'normalized_wyckoff': {'a': {'X_1': 1},
                              'c': {'X_0': 1, 'X_2': 1},
                              'd': {'X_0': 2}},
       'normalized_wysytax': {'a': {'X_1': 1},
                              'c': {'X_0': 1, 'X_2': 1},
                              'd': {'X_0': 2}}},
      {'Notes': '-',
       'Pearsons Symbol': 'oP12',
       'Prototype': 'Co2Si',
       'Space Group': 'Pnma',
       'Space Group Number': 62,
       'Strukturbericht Designation': 'C37',
       'Wyckoff Positions': 'c3',
       'aflow_prototype_id': 'A2B_oP12_62_2c_c',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2B_oP12_62_2c_c.Co2Si.html',
       'atom_labels': ['Co',
                       'Co',
                       'Co',
                       'Co',
                       'Co',
                       'Co',
                       'Co',
                       'Co',
                       'Si',
                       'Si',
                       'Si',
                       'Si'],
       'atom_positions': [[1.51696e-11, 9.125e-11, 4.763162000000001e-10],
                          [1.844304e-10, 2.7375e-10, 1.717662e-10],
                          [-1.51696e-11, 2.7375e-10, -4.763162000000001e-10],
                          [-1.844304e-10, 9.125e-11, -1.717662e-10],
                          [6.946080000000001e-11,
                           9.125e-11,
                           2.6678579999999997e-10],
                          [1.301392e-10, 2.7375e-10, -3.77642e-11],
                          [-6.946080000000001e-11,
                           2.7375e-10,
                           -2.6678579999999997e-10],
                          [-1.301392e-10, 9.125e-11, 3.77642e-11],
                          [2.802384e-10, 9.125e-11, 2.3693990000000003e-10],
                          [-8.06384e-11, 2.7375e-10, -6.761009999999999e-11],
                          [-2.802384e-10, 2.7375e-10, -2.3693990000000003e-10],
                          [8.06384e-11, 9.125e-11, 6.761009999999999e-11]],
       'lattice_vectors': [[3.9920000000000003e-10, 0.0, 0.0],
                           [0.0, 3.65e-10, 0.0],
                           [0.0, 0.0, 6.091e-10]],
       'normalized_wyckoff': {'c': {'X_0': 2, 'X_1': 1}},
       'normalized_wysytax': {'c': {'X_0': 2, 'X_1': 1}}},
      {'Notes': '-',
       'Pearsons Symbol': 'oP16',
       'Prototype': 'CuSbS2',
       'Space Group': 'Pnma',
       'Space Group Number': 62,
       'Strukturbericht Designation': 'F56',
       'Wyckoff Positions': 'c4',
       'aflow_prototype_id': 'AB2C_oP16_62_c_2c_c',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB2C_oP16_62_c_2c_c.html',
       'atom_labels': ['Cu',
                       'Cu',
                       'Cu',
                       'Cu',
                       'Sb',
                       'Sb',
                       'Sb',
                       'Sb',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S'],
       'atom_positions': [[1.2e-10, 9.45e-11, 1.1849000000000001e-09],
                          [4.2000000000000005e-10, 9.45e-11, -4.624e-10],
                          [-1.2e-10, -9.45e-11, -1.1849000000000001e-09],
                          [-4.2000000000000005e-10, -9.45e-11, 4.624e-10],
                          [1.32e-10, 9.45e-11, 8.670000000000001e-11],
                          [4.3200000000000006e-10, 9.45e-11, 6.358e-10],
                          [-1.32e-10, -9.45e-11, -8.670000000000001e-11],
                          [-4.3200000000000006e-10, -9.45e-11, -6.358e-10],
                          [3.6e-10, 9.45e-11, 1.3005e-10],
                          [6.6e-10, 9.45e-11, 5.924500000000001e-10],
                          [-3.6e-10, -9.45e-11, -1.3005e-10],
                          [-6.6e-10, -9.45e-11, -5.924500000000001e-10],
                          [4.8e-10, 9.45e-11, 1.1849000000000001e-09],
                          [7.8e-10, 9.45e-11, -4.624e-10],
                          [-4.8e-10, -9.45e-11, -1.1849000000000001e-09],
                          [-7.8e-10, -9.45e-11, 4.624e-10]],
       'lattice_vectors': [[6e-10, 0.0, 0.0],
                           [0.0, 3.78e-10, 0.0],
                           [0.0, 0.0, 1.445e-09]],
       'normalized_wyckoff': {'c': {'X_0': 2, 'X_1': 1, 'X_2': 1}},
       'normalized_wysytax': {'c': {'X_0': 2, 'X_1': 1, 'X_2': 1}}},
      {'Notes': '-',
       'Pearsons Symbol': 'oP8',
       'Prototype': 'GeS',
       'Space Group': 'Pnma',
       'Space Group Number': 62,
       'Strukturbericht Designation': 'B16',
       'Wyckoff Positions': 'c2',
       'aflow_prototype_id': 'AB_oP8_62_c_c',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_oP8_62_c_c.GeS.html',
       'atom_labels': ['Ge', 'Ge', 'Ge', 'Ge', 'S', 'S', 'S', 'S'],
       'atom_positions': [[1.2797301000000002e-10,
                           8.66e-11,
                           5.4898230000000005e-11],
                          [-1.2797301000000002e-10,
                           2.5979999999999997e-10,
                           -5.4898230000000005e-11],
                          [3.9607699e-10,
                           2.5979999999999997e-10,
                           2.6984823e-10],
                          [6.520230100000001e-10, 8.66e-11, 1.6005177e-10],
                          [8.9036095e-10, 8.66e-11, 2.1593877e-10],
                          [-8.9036095e-10,
                           2.5979999999999997e-10,
                           -2.1593877e-10],
                          [-3.6631095e-10, 2.5979999999999997e-10, 9.8877e-13],
                          [3.6631095e-10, 8.66e-11, -9.8877e-13]],
       'lattice_vectors': [[1.0481e-09, 0.0, 0.0],
                           [0.0, 3.464e-10, 0.0],
                           [0.0, 0.0, 4.2990000000000004e-10]],
       'normalized_wyckoff': {'c': {'X_0': 1, 'X_1': 1}},
       'normalized_wysytax': {'c': {'X_0': 1, 'X_1': 1}}},
      {'Notes': '-',
       'Pearsons Symbol': 'oP12',
       'Prototype': 'HgCl2',
       'Space Group': 'Pnma',
       'Space Group Number': 62,
       'Strukturbericht Designation': 'C25',
       'Wyckoff Positions': 'c3',
       'aflow_prototype_id': 'A2B_oP12_62_2c_c',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2B_oP12_62_2c_c.HgCl2.html',
       'atom_labels': ['Hg',
                       'Hg',
                       'Hg',
                       'Hg',
                       'Cl',
                       'Cl',
                       'Cl',
                       'Cl',
                       'Cl',
                       'Cl',
                       'Cl',
                       'Cl'],
       'atom_positions': [[1.583375e-10, 1.0767500000000002e-10, 3.73968e-11],
                          [7.916875e-10, 1.0767500000000002e-10, 2.594032e-10],
                          [-1.583375e-10,
                           -1.0767500000000002e-10,
                           -3.73968e-11],
                          [-7.916875e-10,
                           -1.0767500000000002e-10,
                           -2.594032e-10],
                          [3.16675e-10,
                           1.0767500000000002e-10,
                           2.5406080000000005e-10],
                          [9.50025e-10, 1.0767500000000002e-10, 4.27392e-11],
                          [-3.16675e-10,
                           -1.0767500000000002e-10,
                           -2.5406080000000005e-10],
                          [-9.50025e-10, -1.0767500000000002e-10, -4.27392e-11],
                          [0.0, 1.0767500000000002e-10, 4.452e-10],
                          [6.3335e-10, 1.0767500000000002e-10, -1.484e-10],
                          [0.0, -1.0767500000000002e-10, -4.452e-10],
                          [-6.3335e-10, -1.0767500000000002e-10, 1.484e-10]],
       'lattice_vectors': [[1.2667e-09, 0.0, 0.0],
                           [0.0, 4.3070000000000007e-10, 0.0],
                           [0.0, 0.0, 5.936e-10]],
       'normalized_wyckoff': {'c': {'X_0': 2, 'X_1': 1}},
       'normalized_wysytax': {'c': {'X_0': 2, 'X_1': 1}}},
      {'Notes': '-',
       'Pearsons Symbol': 'oP8',
       'Prototype': 'MnP',
       'Space Group': 'Pnma',
       'Space Group Number': 62,
       'Strukturbericht Designation': 'B31',
       'Wyckoff Positions': 'c2',
       'aflow_prototype_id': 'AB_oP8_62_c_c',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_oP8_62_c_c.MnP.html',
       'atom_labels': ['Mn', 'Mn', 'Mn', 'Mn', 'P', 'P', 'P', 'P'],
       'atom_positions': [[3.2086610000000004e-12,
                           7.935250000000001e-11,
                           1.1613666600000001e-10],
                          [2.59796339e-10,
                           2.380575e-10,
                           4.1210166600000007e-10],
                          [-3.2086610000000004e-12,
                           2.380575e-10,
                           -1.1613666600000001e-10],
                          [2.66213661e-10,
                           7.935250000000001e-11,
                           1.79828334e-10],
                          [9.910028400000001e-11,
                           7.935250000000001e-11,
                           3.3680817e-10],
                          [1.63904716e-10, 2.380575e-10, 4.084317e-11],
                          [-9.910028400000001e-11, 2.380575e-10, 2.5512183e-10],
                          [3.62105284e-10,
                           7.935250000000001e-11,
                           -4.084317e-11]],
       'lattice_vectors': [[5.2601e-10, 0.0, 0.0],
                           [0.0, 3.1741000000000004e-10, 0.0],
                           [0.0, 0.0, 5.9193e-10]],
       'normalized_wyckoff': {'c': {'X_0': 1, 'X_1': 1}},
       'normalized_wysytax': {'c': {'X_0': 1, 'X_1': 1}}},
      {'Notes': '-',
       'Pearsons Symbol': 'oP8',
       'Prototype': 'Np (alpha)',
       'Space Group': 'Pnma',
       'Space Group Number': 62,
       'Strukturbericht Designation': 'Ac',
       'Wyckoff Positions': 'c2',
       'aflow_prototype_id': 'A_oP8_62_2c',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_oP8_62_2c.html',
       'atom_labels': ['Np', 'Np', 'Np', 'Np', 'U', 'U', 'U', 'U'],
       'atom_positions': [[2.39868e-11, 1.18075e-10, 1.0164960000000001e-10],
                          [3.0916320000000003e-10,
                           3.5422500000000004e-10,
                           -1.427004e-10],
                          [-2.39868e-11,
                           3.5422500000000004e-10,
                           -1.0164960000000001e-10],
                          [3.5713680000000003e-10, 1.18075e-10, 1.427004e-10],
                          [2.1254970000000004e-10, 1.18075e-10, 4.114854e-10],
                          [1.206003e-10, 3.5422500000000004e-10, 1.671354e-10],
                          [-2.1254970000000004e-10,
                           3.5422500000000004e-10,
                           -4.114854e-10],
                          [5.456997000000001e-10, 1.18075e-10, -1.671354e-10]],
       'lattice_vectors': [[6.663000000000001e-10, 0.0, 0.0],
                           [0.0, 4.723e-10, 0.0],
                           [0.0, 0.0, 4.887e-10]],
       'normalized_wyckoff': {'c': {'X_0': 1, 'X_1': 1}},
       'normalized_wysytax': {'c': {'X_0': 1, 'X_1': 1}}},
      {'Notes': '-',
       'Pearsons Symbol': 'oP12',
       'Prototype': 'PbCl2',
       'Space Group': 'Pnma',
       'Space Group Number': 62,
       'Strukturbericht Designation': 'C23',
       'Wyckoff Positions': 'c3',
       'aflow_prototype_id': 'A2B_oP12_62_2c_c',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2B_oP12_62_2c_c.PbCl2.html',
       'atom_labels': ['Pb',
                       'Pb',
                       'Pb',
                       'Pb',
                       'Cl',
                       'Cl',
                       'Cl',
                       'Cl',
                       'Cl',
                       'Cl',
                       'Cl',
                       'Cl'],
       'atom_positions': [[-1.8696e-10, 1.13e-10, -8.5785e-11],
                          [5.6696e-10, 3.39e-10, -5.37285e-10],
                          [1.8696e-10, 3.39e-10, 8.5785e-11],
                          [-5.6696e-10, 1.13e-10, 5.37285e-10],
                          [1.14e-10, 1.13e-10, -6.321000000000001e-11],
                          [2.66e-10, 3.39e-10, -5.1471e-10],
                          [-1.14e-10, 3.39e-10, 6.321000000000001e-11],
                          [-2.66e-10, 1.13e-10, 5.1471e-10],
                          [3.8000000000000004e-11, 1.13e-10, 2.9799e-10],
                          [3.42e-10, 3.39e-10, -1.5351e-10],
                          [-3.8000000000000004e-11, 3.39e-10, -2.9799e-10],
                          [-3.42e-10, 1.13e-10, 1.5351e-10]],
       'lattice_vectors': [[7.6e-10, 0.0, 0.0],
                           [0.0, 4.52e-10, 0.0],
                           [0.0, 0.0, 9.03e-10]],
       'normalized_wyckoff': {'c': {'X_0': 2, 'X_1': 1}},
       'normalized_wysytax': {'c': {'X_0': 2, 'X_1': 1}}},
      {'Notes': '-',
       'Pearsons Symbol': 'oP20',
       'Prototype': 'S3Sb2',
       'Space Group': 'Pnma',
       'Space Group Number': 62,
       'Strukturbericht Designation': 'D58',
       'Wyckoff Positions': 'c5',
       'aflow_prototype_id': 'A3B2_oP20_62_3c_2c',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A3B2_oP20_62_3c_2c.html',
       'atom_labels': ['Sb',
                       'Sb',
                       'Sb',
                       'Sb',
                       'Sb',
                       'Sb',
                       'Sb',
                       'Sb',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S'],
       'atom_positions': [[3.4968e-11, 9.575e-11, 3.6736e-10],
                          [5.98968e-10, 9.575e-11, 1.9264e-10],
                          [-3.4968e-11, -9.575e-11, -3.6736e-10],
                          [-5.98968e-10, -9.575e-11, -1.9264e-10],
                          [3.9592800000000003e-10, 9.575e-11, 6.0368e-10],
                          [9.59928e-10, 9.575e-11, -4.3680000000000005e-11],
                          [-3.9592800000000003e-10, -9.575e-11, -6.0368e-10],
                          [-9.59928e-10, -9.575e-11, 4.3680000000000005e-11],
                          [5.3016e-11, 9.575e-11, 9.8896e-10],
                          [6.170160000000001e-10,
                           9.575e-11,
                           -4.2896000000000004e-10],
                          [-5.3016e-11, -9.575e-11, -9.8896e-10],
                          [-6.170160000000001e-10,
                           -9.575e-11,
                           4.2896000000000004e-10],
                          [1.01238e-09, 9.575e-11, 6.283200000000001e-10],
                          [1.57638e-09, 9.575e-11, -6.832e-11],
                          [-1.01238e-09, -9.575e-11, -6.283200000000001e-10],
                          [-1.57638e-09, -9.575e-11, 6.832e-11],
                          [2.34624e-10, 9.575e-11, 2.1728000000000002e-10],
                          [7.98624e-10, 9.575e-11, 3.4272000000000003e-10],
                          [-2.34624e-10, -9.575e-11, -2.1728000000000002e-10],
                          [-7.98624e-10, -9.575e-11, -3.4272000000000003e-10]],
       'lattice_vectors': [[1.128e-09, 0.0, 0.0],
                           [0.0, 3.83e-10, 0.0],
                           [0.0, 0.0, 1.12e-09]],
       'normalized_wyckoff': {'c': {'X_0': 3, 'X_1': 2}},
       'normalized_wysytax': {'c': {'X_0': 3, 'X_1': 2}}},
      {'Notes': '-',
       'Pearsons Symbol': 'oP8',
       'Prototype': 'SSn',
       'Space Group': 'Pnma',
       'Space Group Number': 62,
       'Strukturbericht Designation': 'B29',
       'Wyckoff Positions': 'c2',
       'aflow_prototype_id': 'AB_oP8_62_c_c',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_oP8_62_c_c.SnS.html',
       'atom_labels': ['Sn', 'Sn', 'Sn', 'Sn', 'S', 'S', 'S', 'S'],
       'atom_positions': [[1.31924e-10, 9.95e-11, 4.9795e-11],
                          [4.27076e-10, 2.985e-10, 2.66295e-10],
                          [-1.31924e-10, 2.985e-10, -4.9795e-11],
                          [6.90924e-10, 9.95e-11, 1.66705e-10],
                          [-1.677e-10, 9.95e-11, 2.06974e-10],
                          [7.267000000000001e-10, 2.985e-10, -9.526e-12],
                          [1.677e-10, 2.985e-10, 2.26026e-10],
                          [3.913e-10, 9.95e-11, 9.526e-12]],
       'lattice_vectors': [[1.118e-09, 0.0, 0.0],
                           [0.0, 3.98e-10, 0.0],
                           [0.0, 0.0, 4.33e-10]],
       'normalized_wyckoff': {'c': {'X_0': 1, 'X_1': 1}},
       'normalized_wysytax': {'c': {'X_0': 1, 'X_1': 1}}}],
 63: [{'Notes': '-',
       'Pearsons Symbol': 'oC8',
       'Prototype': 'BCr',
       'Space Group': 'Cmcm',
       'Space Group Number': 63,
       'Strukturbericht Designation': 'B33',
       'Wyckoff Positions': 'c2',
       'aflow_prototype_id': 'AB_oC8_63_c_c',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_oC8_63_c_c.html',
       'atom_labels': ['Cr', 'Cr', 'B', 'B'],
       'atom_positions': [[0.0, 1.147268e-10, 7.33e-11],
                          [0.0, -1.147268e-10, -7.33e-11],
                          [0.0, 3.4575200000000004e-10, 7.33e-11],
                          [0.0, -3.4575200000000004e-10, -7.33e-11]],
       'lattice_vectors': [[1.4845e-10, -3.929e-10, 0.0],
                           [1.4845e-10, 3.929e-10, 0.0],
                           [0.0, 0.0, 2.932e-10]],
       'normalized_wyckoff': {'c': {'X_0': 1, 'X_1': 1}},
       'normalized_wysytax': {'c': {'X_0': 1, 'X_1': 1}}},
      {'Notes': '-',
       'Pearsons Symbol': 'oC16',
       'Prototype': 'CuO2Sr',
       'Space Group': 'Cmcm',
       'Space Group Number': 63,
       'Strukturbericht Designation': '-',
       'Wyckoff Positions': 'c4',
       'aflow_prototype_id': 'AB2C_oC16_63_c_2c_c',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB2C_oC16_63_c_2c_c.html',
       'atom_labels': ['Cu', 'Cu', 'O', 'O', 'O', 'O', 'Sr', 'Sr'],
       'atom_positions': [[2.1851892999999998e-11, 0.0, 9.795500000000001e-11],
                          [0.0, -9.983327799999999e-11, 2.93865e-10],
                          [0.0, -9.118836e-11, 9.795500000000001e-11],
                          [0.0, 9.118836e-11, 2.93865e-10],
                          [1.7885e-10, 5.2425136e-10, 2.93865e-10],
                          [1.7885e-10, -5.2425136e-10, 9.795500000000001e-11],
                          [1.7885e-10, 2.7624516800000006e-10, 2.93865e-10],
                          [1.7885e-10,
                           -2.7624516800000006e-10,
                           9.795500000000001e-11]],
       'lattice_vectors': [[1.7885e-10, -8.171e-10, 0.0],
                           [1.7885e-10, 8.171e-10, 0.0],
                           [0.0, 0.0, 3.9182e-10]]},
      {'Notes': '-',
       'Pearsons Symbol': 'oC12',
       'Prototype': 'Si2Zr',
       'Space Group': 'Cmcm',
       'Space Group Number': 63,
       'Strukturbericht Designation': 'C49',
       'Wyckoff Positions': 'c3',
       'aflow_prototype_id': 'A2B_oC12_63_2c_c',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2B_oC12_63_2c_c.html',
       'atom_labels': ['Si', 'Si', 'Si', 'Si', 'Zr', 'Zr'],
       'atom_positions': [[0.0, 8.979200000000001e-11, 9.175e-11],
                          [0.0, -8.979200000000001e-11, 2.7525e-10],
                          [1.865e-10, 3.6800000000000007e-10, 9.175e-11],
                          [1.865e-10, -3.6800000000000007e-10, 2.7525e-10],
                          [1.865e-10, 1.5308800000000007e-10, 2.7525e-10],
                          [1.865e-10, -1.5308800000000007e-10, 9.175e-11]],
       'lattice_vectors': [[1.865e-10, -7.36e-10, 0.0],
                           [1.865e-10, 7.36e-10, 0.0],
                           [0.0, 0.0, 3.67e-10]],
       'normalized_wyckoff': {'c': {'X_0': 2, 'X_1': 1}},
       'normalized_wysytax': {'c': {'X_0': 2, 'X_1': 1}}},
      {'Notes': '-',
       'Pearsons Symbol': 'oC4',
       'Prototype': 'U (alpha)',
       'Space Group': 'Cmcm',
       'Space Group Number': 63,
       'Strukturbericht Designation': 'A20',
       'Wyckoff Positions': 'c',
       'aflow_prototype_id': 'A_oC4_63_c',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_oC4_63_c.html',
       'atom_labels': ['U', 'U'],
       'atom_positions': [[0.0, 5.9676081e-11, 1.23875e-10],
                          [0.0, -5.9676081e-11, -1.23875e-10]],
       'lattice_vectors': [[1.427e-10, -2.935e-10, 0.0],
                           [1.427e-10, 2.935e-10, 0.0],
                           [0.0, 0.0, 4.955e-10]],
       'normalized_wyckoff': {'c': {'X_0': 1}},
       'normalized_wysytax': {'c': {'X_0': 1}}}],
 64: [{'Notes': '-',
       'Pearsons Symbol': 'oC80',
       'Prototype': 'B2C2Mg',
       'Space Group': 'Cmca',
       'Space Group Number': 64,
       'Strukturbericht Designation': '-',
       'Wyckoff Positions': 'de2f3g2',
       'aflow_prototype_id': 'A2B2C_oC80_64_efg_efg_df',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2B2C_oC80_64_efg_efg_df.html',
       'atom_labels': ['Mg',
                       'Mg',
                       'Mg',
                       'Mg',
                       'Mg',
                       'Mg',
                       'Mg',
                       'Mg',
                       'B',
                       'B',
                       'B',
                       'B',
                       'B',
                       'B',
                       'B',
                       'B',
                       'B',
                       'B',
                       'B',
                       'B',
                       'B',
                       'B',
                       'B',
                       'B',
                       'C',
                       'C',
                       'C',
                       'C',
                       'C',
                       'C',
                       'C',
                       'C',
                       'C',
                       'C',
                       'C',
                       'C',
                       'C',
                       'C',
                       'C',
                       'C'],
       'atom_positions': [[1.6757625e-10, 0.0, 0.0],
                          [-1.6757625e-10, 0.0, 0.0],
                          [-1.6757625e-10, 4.7305e-10, 3.7295e-10],
                          [1.6757625e-10, 4.7305e-10, 3.7295e-10],
                          [0.0, 2.6472824e-10, -8.428670000000001e-12],
                          [0.0, 2.0832176e-10, 3.6452133000000003e-10],
                          [0.0, 7.3777824e-10, 3.8137867e-10],
                          [0.0, -2.6472824e-10, 8.428670000000001e-12],
                          [2.7305e-10, 8.950106e-11, 1.86475e-10],
                          [8.1915e-10, 3.8354894e-10, 5.59425e-10],
                          [8.1915e-10, -8.950106e-11, 5.59425e-10],
                          [2.7305e-10, 5.625510600000001e-10, 1.86475e-10],
                          [0.0, 5.5687446e-10, 2.0586840000000002e-10],
                          [0.0, -8.382446e-11, 5.788184000000001e-10],
                          [0.0, 1.0299244600000001e-09, 1.6708160000000003e-10],
                          [0.0, -5.5687446e-10, -2.0586840000000002e-10],
                          [1.3958316e-10,
                           3.2309315000000004e-10,
                           1.8185042e-10],
                          [-1.3958316e-10,
                           1.4995685000000002e-10,
                           5.5480042e-10],
                          [-1.3958316e-10, 7.9614315e-10, 1.9109958e-10],
                          [1.3958316e-10,
                           -3.2309315000000004e-10,
                           -1.8185042e-10],
                          [-1.3958316e-10,
                           -3.2309315000000004e-10,
                           -1.8185042e-10],
                          [1.3958316e-10,
                           -1.4995685000000002e-10,
                           -5.5480042e-10],
                          [1.3958316e-10, -7.9614315e-10, -1.9109958e-10],
                          [-1.3958316e-10,
                           3.2309315000000004e-10,
                           1.8185042e-10],
                          [2.7305e-10, 8.7712931e-10, 1.86475e-10],
                          [8.1915e-10, -4.0407931000000004e-10, 5.59425e-10],
                          [8.1915e-10, -8.7712931e-10, 5.59425e-10],
                          [2.7305e-10, 1.35017931e-09, 1.86475e-10],
                          [0.0, -7.493112e-11, 1.7260126e-10],
                          [0.0, 5.4798112e-10, 5.4555126e-10],
                          [0.0, 3.9811888e-10, 2.0034874e-10],
                          [0.0, 7.493112e-11, -1.7260126e-10],
                          [1.359789e-10, 1.655675e-10, 1.6641029000000002e-10],
                          [-1.359789e-10,
                           3.0748250000000003e-10,
                           5.3936029e-10],
                          [-1.359789e-10, 6.386175e-10, 2.0653971000000002e-10],
                          [1.359789e-10,
                           -1.655675e-10,
                           -1.6641029000000002e-10],
                          [-1.359789e-10,
                           -1.655675e-10,
                           -1.6641029000000002e-10],
                          [1.359789e-10,
                           -3.0748250000000003e-10,
                           -5.3936029e-10],
                          [1.359789e-10,
                           -6.386175e-10,
                           -2.0653971000000002e-10],
                          [-1.359789e-10,
                           1.655675e-10,
                           1.6641029000000002e-10]],
       'lattice_vectors': [[5.461e-10, -4.7305e-10, 0.0],
                           [5.461e-10, 4.7305e-10, 0.0],
                           [0.0, 0.0, 7.459e-10]],
       'normalized_wyckoff': {'d': {'X_2': 1},
                              'e': {'X_0': 1, 'X_1': 1},
                              'f': {'X_0': 1, 'X_1': 1, 'X_2': 1},
                              'g': {'X_0': 2, 'X_1': 2}},
       'normalized_wysytax': {'d': {'X_2': 2},
                              'e': {'X_0': 1, 'X_1': 1},
                              'f': {'X_0': 1, 'X_1': 1, 'X_2': 1},
                              'g': {'X_0': 2, 'X_1': 2}}},
      {'Notes': '-',
       'Pearsons Symbol': 'oC8',
       'Prototype': 'Ga (alpha)',
       'Space Group': 'Cmca',
       'Space Group Number': 64,
       'Strukturbericht Designation': 'A11',
       'Wyckoff Positions': 'f',
       'aflow_prototype_id': 'A_oC8_64_f',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_oC8_64_f.alpha-Ga.html',
       'atom_labels': ['Ga', 'Ga', 'Ga', 'Ga'],
       'atom_positions': [[0.0, 1.18658047e-10, 3.665979e-11],
                          [0.0, -1.18658047e-10, -3.665979e-11],
                          [0.0, 5.01673047e-10, 1.8963521000000002e-10],
                          [0.0, 2.6435695300000005e-10, 2.6295479e-10]],
       'lattice_vectors': [[2.25995e-10, -3.8301500000000005e-10, 0.0],
                           [2.25995e-10, 3.8301500000000005e-10, 0.0],
                           [0.0, 0.0, 4.5259000000000004e-10]],
       'normalized_wyckoff': {'f': {'X_0': 1}},
       'normalized_wysytax': {'f': {'X_0': 1}}},
      {'Notes': '-',
       'Pearsons Symbol': 'oC8',
       'Prototype': 'I2',
       'Space Group': 'Cmca',
       'Space Group Number': 64,
       'Strukturbericht Designation': 'A14',
       'Wyckoff Positions': 'f',
       'aflow_prototype_id': 'A_oC8_64_f',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_oC8_64_f.I.html',
       'atom_labels': ['I', 'I', 'I', 'I'],
       'atom_positions': [[0.0, 7.185e-11, 1.14426e-10],
                          [0.0, -7.185e-11, -1.14426e-10],
                          [3.625e-10, 7.185e-11, 3.74574e-10],
                          [3.625e-10, -7.185e-11, 6.03426e-10]],
       'lattice_vectors': [[3.625e-10, -2.395e-10, 0.0],
                           [3.625e-10, 2.395e-10, 0.0],
                           [0.0, 0.0, 9.78e-10]],
       'normalized_wyckoff': {'f': {'X_0': 1}},
       'normalized_wysytax': {'f': {'X_0': 1}}},
      {'Notes': 'black phosphorus',
       'Pearsons Symbol': 'oC8',
       'Prototype': 'P',
       'Space Group': 'Cmca',
       'Space Group Number': 64,
       'Strukturbericht Designation': 'A17',
       'Wyckoff Positions': 'f',
       'aflow_prototype_id': 'A_oC8_64_f',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_oC8_64_f.P.html',
       'atom_labels': ['P', 'P', 'P', 'P'],
       'atom_positions': [[1.6568e-10, 4.17359696e-10, 4.023745272000001e-10],
                          [1.6568e-10,
                           1.0654030400000002e-10,
                           1.8355952720000002e-10],
                          [1.6568e-10,
                           -1.0654030400000002e-10,
                           2.540704728e-10],
                          [1.6568e-10,
                           -4.17359696e-10,
                           3.5255472800000007e-11]],
       'lattice_vectors': [[1.6568e-10, -5.239e-10, 0.0],
                           [1.6568e-10, 5.239e-10, 0.0],
                           [0.0, 0.0, 4.3763e-10]],
       'normalized_wyckoff': {'f': {'X_0': 1}},
       'normalized_wysytax': {'f': {'X_0': 1}}}],
 65: [{'Notes': 'predicted structure',
       'Pearsons Symbol': 'oC8',
       'Prototype': 'CdPt3',
       'Space Group': 'Cmmm',
       'Space Group Number': 65,
       'Strukturbericht Designation': 'â\x80\x9cL13â\x80\x9d',
       'Wyckoff Positions': 'abf',
       'aflow_prototype_id': 'AB3_oC8_65_a_bf',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB3_oC8_65_a_bf.html',
       'atom_labels': ['Cd', 'Pt', 'Pt', 'Pt'],
       'atom_positions': [[0.0, 0.0, 0.0],
                          [3.7e-10, 0.0, 0.0],
                          [1.85e-10, 1.30814754e-10, 1.30814754e-10],
                          [1.85e-10, -1.30814754e-10, 1.30814754e-10]],
       'lattice_vectors': [[3.7e-10, -2.61629509e-10, 0.0],
                           [3.7e-10, 2.61629509e-10, 0.0],
                           [0.0, 0.0, 2.61629509e-10]],
       'normalized_wyckoff': {'a': {'X_1': 1},
                              'b': {'X_0': 1},
                              'f': {'X_0': 2}},
       'normalized_wysytax': {'a': {'X_1': 1},
                              'b': {'X_0': 1},
                              'f': {'X_0': 1}}},
      {'Notes': '-',
       'Pearsons Symbol': 'oC16',
       'Prototype': 'Ga3Pt5',
       'Space Group': 'Cmmm',
       'Space Group Number': 65,
       'Strukturbericht Designation': '-',
       'Wyckoff Positions': 'abehj',
       'aflow_prototype_id': 'A3B5_oC16_65_ah_bej',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A3B5_oC16_65_ah_bej.html',
       'atom_labels': ['Ni', 'Ni', 'Ni', 'Ni', 'Ni', 'Al', 'Al', 'Al'],
       'atom_positions': [[0.0, 0.0, 0.0],
                          [1.86e-10, 1.67e-10, 0.0],
                          [1.86e-10, -1.67e-10, 0.0],
                          [0.0, 1.67e-10, 1.86e-10],
                          [0.0, -1.67e-10, 1.86e-10],
                          [3.72e-10, 0.0, 0.0],
                          [1.86e-10, 0.0, 1.86e-10],
                          [-1.86e-10, 0.0, 1.86e-10]],
       'lattice_vectors': [[3.72e-10, -3.34e-10, 0.0],
                           [3.72e-10, 3.34e-10, 0.0],
                           [0.0, 0.0, 3.72e-10]],
       'normalized_wyckoff': {'a': {'X_1': 1},
                              'b': {'X_0': 1},
                              'e': {'X_0': 2},
                              'h': {'X_0': 2},
                              'j': {'X_1': 2}},
       'normalized_wysytax': {'a': {'X_0': 1},
                              'b': {'X_1': 1},
                              'e': {'X_0': 1},
                              'h': {'X_0': 2},
                              'j': {'X_1': 1}}},
      {'Notes': '-',
       'Pearsons Symbol': 'oC8',
       'Prototype': 'IrV (alpha)',
       'Space Group': 'Cmmm',
       'Space Group Number': 65,
       'Strukturbericht Designation': '-',
       'Wyckoff Positions': 'gj',
       'aflow_prototype_id': 'AB_oC8_65_j_g',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_oC8_65_j_g.html',
       'atom_labels': ['Ir', 'Ir', 'V', 'V'],
       'atom_positions': [[0.0, 1.4863200000000003e-10, 1.398e-10],
                          [0.0, -1.4863200000000003e-10, 1.398e-10],
                          [1.62148e-10, 0.0, 0.0],
                          [-1.62148e-10, 0.0, 0.0]],
       'lattice_vectors': [[2.8955000000000005e-10, -3.378e-10, 0.0],
                           [2.8955000000000005e-10, 3.378e-10, 0.0],
                           [0.0, 0.0, 2.796e-10]],
       'normalized_wyckoff': {'g': {'X_0': 1}, 'j': {'X_1': 1}},
       'normalized_wysytax': {'g': {'X_0': 2}, 'j': {'X_1': 1}}}],
 69: [{'Notes': '-',
       'Pearsons Symbol': 'oF8',
       'Prototype': 'FTl',
       'Space Group': 'Fmmm',
       'Space Group Number': 69,
       'Strukturbericht Designation': 'B24',
       'Wyckoff Positions': 'ab',
       'aflow_prototype_id': 'AB_oF8_69_a_b',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_oF8_69_a_b.html',
       'atom_labels': ['Tl', 'F'],
       'atom_positions': [[0.0, 0.0, 0.0], [0.0, 0.0, 3.0400000000000004e-10]],
       'lattice_vectors': [[0.0, 2.7475e-10, 3.0400000000000004e-10],
                           [2.59e-10, 0.0, 3.0400000000000004e-10],
                           [2.59e-10, 2.7475e-10, 0.0]],
       'normalized_wyckoff': {'a': {'X_0': 1}, 'b': {'X_1': 1}},
       'normalized_wysytax': {'a': {'X_0': 1}, 'b': {'X_1': 1}}}],
 70: [{'Notes': '-',
       'Pearsons Symbol': 'oF8',
       'Prototype': 'Pu (gamma)',
       'Space Group': 'Fddd',
       'Space Group Number': 70,
       'Strukturbericht Designation': '-',
       'Wyckoff Positions': 'a',
       'aflow_prototype_id': 'A_oF8_70_a',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_oF8_70_a.html',
       'atom_labels': ['Pu', 'Pu'],
       'atom_positions': [[3.948375e-11, 7.210250000000001e-11, 1.27025e-10],
                          [-3.948375e-11,
                           -7.210250000000001e-11,
                           -1.27025e-10]],
       'lattice_vectors': [[0.0, 2.8841000000000004e-10, 5.081e-10],
                           [1.57935e-10, 0.0, 5.081e-10],
                           [1.57935e-10, 2.8841000000000004e-10, 0.0]],
       'normalized_wyckoff': {'a': {'X_0': 1}},
       'normalized_wysytax': {'b': {'X_0': 1}}},
      {'Notes': '-',
       'Pearsons Symbol': 'oF128',
       'Prototype': 'S (alpha)',
       'Space Group': 'Fddd',
       'Space Group Number': 70,
       'Strukturbericht Designation': 'A16',
       'Wyckoff Positions': 'h4',
       'aflow_prototype_id': 'A_oF128_70_4h',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_oF128_70_4h.html',
       'atom_labels': ['S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S'],
       'atom_positions': [[8.927809800000001e-10,
                           1.2236147000000001e-09,
                           2.31895404e-09],
                          [-8.927809800000001e-10,
                           -1.2236147000000001e-09,
                           -2.31895404e-09],
                          [8.927809800000001e-10,
                           -9.024897e-10,
                           -1.70972904e-09],
                          [-8.927809800000001e-10,
                           1.5447397e-09,
                           2.92817904e-09],
                          [-6.3185598e-10,
                           1.2236147000000001e-09,
                           -1.70972904e-09],
                          [1.15370598e-09,
                           -1.2236147000000001e-09,
                           2.92817904e-09],
                          [-6.3185598e-10, -9.024897e-10, 2.31895404e-09],
                          [1.15370598e-09, 1.5447397e-09, -2.31895404e-09],
                          [8.1867828e-10, 3.866345e-11, 1.8593547e-10],
                          [-8.1867828e-10, -3.866345e-11, -1.8593547e-10],
                          [8.1867828e-10, 2.8246155e-10, 4.2328953e-10],
                          [-8.1867828e-10,
                           3.5978845000000003e-10,
                           7.9516047e-10],
                          [-5.5775328e-10, 3.866345e-11, 4.2328953e-10],
                          [1.0796032800000002e-09,
                           -3.866345e-11,
                           7.9516047e-10],
                          [-5.5775328e-10, 2.8246155e-10, 1.8593547e-10],
                          [1.0796032800000002e-09,
                           3.5978845000000003e-10,
                           -1.8593547e-10],
                          [7.3779153e-10, 1.25816775e-09, 9.7476e-12],
                          [-7.3779153e-10, -1.25816775e-09, -9.7476e-12],
                          [7.3779153e-10, -9.3704275e-10, 5.994774e-10],
                          [-7.3779153e-10,
                           1.57929275e-09,
                           6.189726000000001e-10],
                          [-4.768665300000001e-10,
                           1.25816775e-09,
                           5.994774e-10],
                          [9.987165299999999e-10,
                           -1.25816775e-09,
                           6.189726000000001e-10],
                          [-4.768665300000001e-10, -9.3704275e-10, 9.7476e-12],
                          [9.987165299999999e-10, 1.57929275e-09, -9.7476e-12],
                          [8.2055694e-10, 1.16542685e-09, 3.143601e-10],
                          [-8.2055694e-10, -1.16542685e-09, -3.143601e-10],
                          [8.2055694e-10, -8.443018500000001e-10, 2.948649e-10],
                          [-8.2055694e-10,
                           1.4865518500000002e-09,
                           9.235851000000001e-10],
                          [-5.5963194e-10, 1.16542685e-09, 2.948649e-10],
                          [1.08148194e-09,
                           -1.16542685e-09,
                           9.235851000000001e-10],
                          [-5.5963194e-10,
                           -8.443018500000001e-10,
                           3.143601e-10],
                          [1.08148194e-09,
                           1.4865518500000002e-09,
                           -3.143601e-10]],
       'lattice_vectors': [[0.0, 6.4225e-10, 1.21845e-09],
                           [5.2185e-10, 0.0, 1.21845e-09],
                           [5.2185e-10, 6.4225e-10, 0.0]],
       'normalized_wyckoff': {'h': {'X_0': 1}},
       'normalized_wysytax': {'h': {'X_0': 1}}},
      {'Notes': '-',
       'Pearsons Symbol': 'oF24',
       'Prototype': 'Si2Ti',
       'Space Group': 'Fddd',
       'Space Group Number': 70,
       'Strukturbericht Designation': 'C54',
       'Wyckoff Positions': 'ae',
       'aflow_prototype_id': 'A2B_oF24_70_e_a',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2B_oF24_70_e_a.html',
       'atom_labels': ['Ti', 'Ti', 'Si', 'Si', 'Si', 'Si'],
       'atom_positions': [[1.0333870000000001e-10,
                           6e-11,
                           1.0688120000000002e-10],
                          [-1.0333870000000001e-10,
                           -6e-11,
                           -1.0688120000000002e-10],
                          [3.815267e-10, 6e-11, 1.0688120000000002e-10],
                          [-3.815267e-10, -6e-11, -1.0688120000000002e-10],
                          [1.748492e-10, -6e-11, -1.0688120000000002e-10],
                          [-1.748492e-10, 6e-11, 1.0688120000000002e-10]],
       'lattice_vectors': [[0.0, 2.4e-10, 4.27525e-10],
                           [4.1335499999999996e-10, 0.0, 4.27525e-10],
                           [4.1335499999999996e-10, 2.4e-10, 0.0]],
       'normalized_wysytax': {'b': {'X_1': 1}, 'f': {'X_0': 2}}}],
 71: [{'Notes': '-',
       'Pearsons Symbol': 'oI6',
       'Prototype': 'MoPt2',
       'Space Group': 'Immm',
       'Space Group Number': 71,
       'Strukturbericht Designation': '-',
       'Wyckoff Positions': 'ag',
       'aflow_prototype_id': 'AB2_oI6_71_a_g',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB2_oI6_71_a_g.html',
       'atom_labels': ['Mo', 'Pt', 'Pt'],
       'atom_positions': [[0.0, 0.0, 0.0],
                          [0.0, 2.928488e-10, 0.0],
                          [0.0, -2.928488e-10, 0.0]],
       'lattice_vectors': [[2.7650000000000003e-10, 0.0, 0.0],
                           [0.0, 8.296e-10, 0.0],
                           [1.3825000000000001e-10, 4.148e-10, 1.969e-10]],
       'normalized_wysytax': {'a': {'X_1': 1}, 'i': {'X_0': 2}}},
      {'Notes': '-',
       'Pearsons Symbol': 'oI6',
       'Prototype': 'ReSi2',
       'Space Group': 'Immm',
       'Space Group Number': 71,
       'Strukturbericht Designation': '-',
       'Wyckoff Positions': 'ai',
       'aflow_prototype_id': 'AB2_oI6_71_a_i',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB2_oI6_71_a_i.html',
       'atom_labels': ['Re', 'Si', 'Si'],
       'atom_positions': [[0.0, 0.0, 0.0],
                          [0.0, 0.0, 2.602503e-10],
                          [0.0, 0.0, 5.074497e-10]],
       'lattice_vectors': [[-1.564e-10, 1.572e-10, 3.8385e-10],
                           [1.564e-10, -1.572e-10, 3.8385e-10],
                           [1.564e-10, 1.572e-10, -3.8385e-10]],
       'normalized_wysytax': {'a': {'X_1': 1}, 'i': {'X_0': 2}}}],
 72: [{'Notes': '-',
       'Pearsons Symbol': 'oI12',
       'Prototype': 'S2Si',
       'Space Group': 'Ibam',
       'Space Group Number': 72,
       'Strukturbericht Designation': 'C42',
       'Wyckoff Positions': 'aj',
       'aflow_prototype_id': 'A2B_oI12_72_j_a',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2B_oI12_72_j_a.html',
       'atom_labels': ['Si', 'Si', 'S', 'S', 'S', 'S'],
       'atom_positions': [[0.0, 0.0, 1.388e-10],
                          [0.0, 0.0, -1.388e-10],
                          [1.1282190000000002e-10, 1.1617630000000002e-10, 0.0],
                          [-1.1282190000000002e-10,
                           -1.1617630000000002e-10,
                           0.0],
                          [-1.1282190000000002e-10,
                           1.1617630000000002e-10,
                           2.776e-10],
                          [1.1282190000000002e-10,
                           -1.1617630000000002e-10,
                           2.776e-10]],
       'lattice_vectors': [[-4.7725e-10, 2.7820000000000003e-10, 2.776e-10],
                           [4.7725e-10, -2.7820000000000003e-10, 2.776e-10],
                           [4.7725e-10, 2.7820000000000003e-10, -2.776e-10]],
       'normalized_wyckoff': {'a': {'X_1': 1}, 'j': {'X_0': 2}},
       'normalized_wysytax': {'a': {'X_1': 2}, 'j': {'X_0': 3}}}],
 82: [{'Notes': '-',
       'Pearsons Symbol': 'tI14',
       'Prototype': 'Al2CdS4',
       'Space Group': 'I4',
       'Space Group Number': 82,
       'Strukturbericht Designation': 'E3',
       'Wyckoff Positions': 'abcg',
       'aflow_prototype_id': 'A2BC4_tI14_82_bc_a_g',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2BC4_tI14_82_bc_a_g.html',
       'atom_labels': ['Cd', 'Al', 'Al', 'S', 'S', 'S', 'S'],
       'atom_positions': [[0.0, 0.0, 0.0],
                          [2.7820000000000003e-10,
                           2.7820000000000003e-10,
                           -0.0],
                          [-0.0,
                           2.7820000000000003e-10,
                           2.5800000000000004e-10],
                          [1.44664e-10, 1.3910000000000002e-10, 1.3416e-10],
                          [-1.44664e-10, -1.3910000000000002e-10, 1.3416e-10],
                          [1.3910000000000002e-10, -1.44664e-10, -1.3416e-10],
                          [-1.3910000000000002e-10, 1.44664e-10, -1.3416e-10]],
       'lattice_vectors': [[5.564000000000001e-10, 0.0, 0.0],
                           [0.0, 5.564000000000001e-10, 0.0],
                           [2.7820000000000003e-10,
                            2.7820000000000003e-10,
                            5.160000000000001e-10]],
       'normalized_wyckoff': {'a': {'X_2': 1},
                              'b': {'X_1': 1},
                              'd': {'X_1': 1},
                              'g': {'X_0': 4}},
       'normalized_wysytax': {'a': {'X_2': 1},
                              'b': {'X_0': 1},
                              'd': {'X_0': 1},
                              'g': {'X_1': 2}}},
      {'Notes': '-',
       'Pearsons Symbol': 'tI12',
       'Prototype': 'BO4P',
       'Space Group': 'I4',
       'Space Group Number': 82,
       'Strukturbericht Designation': 'H07',
       'Wyckoff Positions': 'acg',
       'aflow_prototype_id': 'AB4C_tI12_82_c_g_a',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB4C_tI12_82_c_g_a.html',
       'atom_labels': ['P', 'B', 'O', 'O', 'O', 'O'],
       'atom_positions': [[0.0, 0.0, 0.0],
                          [0.0, 2.166e-10, 1.66e-10],
                          [5.97816e-11, 1.1263200000000001e-10, 8.6984e-11],
                          [-5.97816e-11, -1.1263200000000001e-10, 8.6984e-11],
                          [1.1263200000000001e-10, -5.97816e-11, -8.6984e-11],
                          [-1.1263200000000001e-10, 5.97816e-11, -8.6984e-11]],
       'lattice_vectors': [[4.332e-10, 0.0, 0.0],
                           [0.0, 4.332e-10, 0.0],
                           [2.166e-10, 2.166e-10, 3.32e-10]],
       'normalized_wyckoff': {'a': {'X_1': 1},
                              'd': {'X_2': 1},
                              'g': {'X_0': 4}},
       'normalized_wysytax': {'a': {'X_1': 1},
                              'd': {'X_2': 1},
                              'g': {'X_0': 2}}}],
 84: [{'Notes': '-',
       'Pearsons Symbol': 'tP16',
       'Prototype': 'PdS',
       'Space Group': 'P42/m',
       'Space Group Number': 84,
       'Strukturbericht Designation': 'B34',
       'Wyckoff Positions': 'cejk',
       'aflow_prototype_id': 'AB_tP16_84_cej_k',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_tP16_84_cej_k.html',
       'atom_labels': ['Pd',
                       'Pd',
                       'Pd',
                       'Pd',
                       'Pd',
                       'Pd',
                       'Pd',
                       'Pd',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S',
                       'S'],
       'atom_positions': [[0.0, 3.2145e-10, 0.0],
                          [3.2145e-10, 0.0, 3.3305e-10],
                          [0.0, 0.0, 1.66525e-10],
                          [0.0, 0.0, 4.99575e-10],
                          [3.0074347700000005e-10, 1.6531016300000002e-10, 0.0],
                          [-3.0074347700000005e-10,
                           -1.6531016300000002e-10,
                           0.0],
                          [-1.6531016300000002e-10,
                           3.0074347700000005e-10,
                           3.3305e-10],
                          [1.6531016300000002e-10,
                           -3.0074347700000005e-10,
                           3.3305e-10],
                          [1.24471869e-10,
                           1.9771746600000001e-10,
                           1.5256354400000002e-10],
                          [-1.24471869e-10,
                           -1.9771746600000001e-10,
                           1.5256354400000002e-10],
                          [-1.9771746600000001e-10,
                           1.24471869e-10,
                           4.856135440000001e-10],
                          [1.9771746600000001e-10,
                           -1.24471869e-10,
                           4.856135440000001e-10],
                          [-1.24471869e-10,
                           -1.9771746600000001e-10,
                           -1.5256354400000002e-10],
                          [1.24471869e-10,
                           1.9771746600000001e-10,
                           -1.5256354400000002e-10],
                          [1.9771746600000001e-10,
                           -1.24471869e-10,
                           1.80486456e-10],
                          [-1.9771746600000001e-10,
                           1.24471869e-10,
                           1.80486456e-10]],
       'lattice_vectors': [[6.429e-10, 0.0, 0.0],
                           [0.0, 6.429e-10, 0.0],
                           [0.0, 0.0, 6.661e-10]],
       'normalized_wyckoff': {'c': {'X_0': 1},
                              'e': {'X_0': 1},
                              'j': {'X_0': 2},
                              'k': {'X_1': 4}},
       'normalized_wysytax': {'c': {'X_0': 1},
                              'e': {'X_0': 1},
                              'j': {'X_0': 2},
                              'k': {'X_1': 4}}}],
 87: [{'Notes': '-',
       'Pearsons Symbol': 'tI10',
       'Prototype': 'MoNi4',
       'Space Group': 'I4/m',
       'Space Group Number': 87,
       'Strukturbericht Designation': 'D1a',
       'Wyckoff Positions': 'ah',
       'aflow_prototype_id': 'AB4_tI10_87_a_h',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB4_tI10_87_a_h.html',
       'atom_labels': ['Mo', 'Ni', 'Ni', 'Ni', 'Ni'],
       'atom_positions': [[0.0, 0.0, 0.0],
                          [1.144e-10, 2.288e-10, 0.0],
                          [-2.288e-10, 1.144e-10, 0.0],
                          [-1.144e-10, -2.288e-10, 0.0],
                          [2.288e-10, -1.144e-10, 0.0]],
       'lattice_vectors': [[5.72e-10, 0.0, 0.0],
                           [0.0, 5.72e-10, 0.0],
                           [2.86e-10, 2.86e-10, 1.7820000000000002e-10]],
       'normalized_wyckoff': {'a': {'X_1': 1}, 'h': {'X_0': 4}},
       'normalized_wysytax': {'a': {'X_1': 1}, 'h': {'X_0': 3}}},
      {'Notes': '-',
       'Pearsons Symbol': 'tI18',
       'Prototype': 'Te4Ti5',
       'Space Group': 'I4/m',
       'Space Group Number': 87,
       'Strukturbericht Designation': '-',
       'Wyckoff Positions': 'ah2',
       'aflow_prototype_id': 'A4B5_tI18_87_h_ah',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A4B5_tI18_87_h_ah.html',
       'atom_labels': ['Ti', 'Te', 'Te', 'Te', 'Te', 'Ti', 'Ti', 'Ti', 'Ti'],
       'atom_positions': [[0.0, 0.0, 0.0],
                          [5.986596e-11, 2.8428708000000003e-10, 0.0],
                          [-5.986596e-11, -2.8428708000000003e-10, 0.0],
                          [-2.8428708000000003e-10, 5.986596e-11, 0.0],
                          [2.8428708000000003e-10, -5.986596e-11, 0.0],
                          [3.1955616e-10, 3.8135328e-10, 0.0],
                          [-3.1955616e-10, -3.8135328e-10, 0.0],
                          [-3.8135328e-10, 3.1955616e-10, 0.0],
                          [3.8135328e-10, -3.1955616e-10, 0.0]],
       'lattice_vectors': [[-5.082e-10, 5.082e-10, 1.886e-10],
                           [5.082e-10, -5.082e-10, 1.886e-10],
                           [5.082e-10, 5.082e-10, -1.886e-10]],
       'normalized_wyckoff': {'a': {'X_0': 1}, 'h': {'X_0': 4, 'X_1': 4}},
       'normalized_wysytax': {'a': {'X_0': 1}, 'h': {'X_0': 3, 'X_1': 3}}}],
 92: [{'Notes': 'alpha cristobalite',
       'Pearsons Symbol': 'tP12',
       'Prototype': 'O2Si',
       'Space Group': 'P41212',
       'Space Group Number': 92,
       'Strukturbericht Designation': '-',
       'Wyckoff Positions': 'ab',
       'aflow_prototype_id': 'A2B_tP12_92_b_a',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2B_tP12_92_b_a.html',
       'atom_labels': ['O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'Si',
                       'Si',
                       'Si',
                       'Si'],
       'atom_positions': [[5.497313e-11, 1.1802617e-10, 5.63213122e-10],
                          [1.1802617e-10, 5.497313e-11, 1.25816878e-10],
                          [1.2982383e-10,
                           3.0282313000000003e-10,
                           4.644062200000001e-11],
                          [1.9287686999999997e-10,
                           3.6587617e-10,
                           2.98074378e-10],
                          [3.0282313000000003e-10,
                           1.2982383e-10,
                           6.425893780000001e-10],
                          [3.6587617e-10,
                           1.9287686999999997e-10,
                           3.909556220000001e-10],
                          [3.7767383e-10, 4.4072687e-10, 4.703318780000001e-10],
                          [4.4072687e-10,
                           3.7767383e-10,
                           2.1869812200000002e-10],
                          [9.681020999999999e-11,
                           3.9888978999999995e-10,
                           1.722575e-10],
                          [1.5103979e-10, 1.5103979e-10, 0.0],
                          [3.4466021000000003e-10,
                           3.4466021000000003e-10,
                           3.44515e-10],
                          [3.9888978999999995e-10,
                           9.681020999999999e-11,
                           5.167725e-10]],
       'lattice_vectors': [[4.957e-10, 0.0, 0.0],
                           [0.0, 4.957e-10, 0.0],
                           [0.0, 0.0, 6.8903e-10]],
       'normalized_wyckoff': {'a': {'X_1': 1}, 'b': {'X_0': 2}},
       'normalized_wysytax': {'a': {'X_1': 1}, 'b': {'X_0': 2}}}],
 96: [{'Notes': 'keatite',
       'Pearsons Symbol': 'tP36',
       'Prototype': 'O2Si',
       'Space Group': 'P43212',
       'Space Group Number': 96,
       'Strukturbericht Designation': '-',
       'Wyckoff Positions': 'ab4',
       'aflow_prototype_id': 'A2B_tP36_96_3b_ab',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2B_tP36_96_3b_ab.html',
       'atom_labels': ['O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'O',
                       'Si',
                       'Si',
                       'Si',
                       'Si',
                       'Si',
                       'Si',
                       'Si',
                       'Si',
                       'Si',
                       'Si',
                       'Si',
                       'Si'],
       'atom_positions': [[4.105200000000001e-11,
                           4.717248e-10,
                           3.0170000000000005e-10],
                          [9.85248e-11, 3.32148e-10, 5.172e-10],
                          [2.746752e-10, 7.05348e-10, 1.293e-10],
                          [3.32148e-10, 9.85248e-11, 3.4480000000000004e-10],
                          [4.1425200000000006e-10,
                           6.478752000000001e-10,
                           7.758e-10],
                          [4.717248e-10, 4.105200000000001e-11, 5.603e-10],
                          [6.478752000000001e-10,
                           4.1425200000000006e-10,
                           8.620000000000001e-11],
                          [7.05348e-10, 2.746752e-10, 7.327000000000002e-10],
                          [8.732880000000002e-11, 9.18072e-11, 2.55152e-10],
                          [9.18072e-11, 8.732880000000002e-11, 6.06848e-10],
                          [2.8139280000000006e-10,
                           4.6052880000000004e-10,
                           3.9652000000000004e-11],
                          [2.8587120000000004e-10,
                           4.6500719999999997e-10,
                           3.9134800000000003e-10],
                          [4.6052880000000004e-10,
                           2.8139280000000006e-10,
                           -3.9652000000000004e-11],
                          [4.6500719999999997e-10,
                           2.8587120000000004e-10,
                           4.70652e-10],
                          [6.545928000000001e-10,
                           6.590711999999999e-10,
                           1.75848e-10],
                          [6.590711999999999e-10,
                           6.545928000000001e-10,
                           6.861520000000001e-10],
                          [1.164384e-10, 5.948808e-10, 5.23234e-10],
                          [1.5151920000000001e-10,
                           6.299616000000001e-10,
                           7.697660000000001e-10],
                          [2.216808e-10, 2.567616e-10, 7.38734e-10],
                          [2.567616e-10, 2.216808e-10, 1.2326600000000002e-10],
                          [4.896384e-10,
                           5.247192000000001e-10,
                           5.542660000000001e-10],
                          [5.247192000000001e-10, 4.896384e-10, 3.07734e-10],
                          [5.948808e-10, 1.164384e-10, 3.387660000000001e-10],
                          [6.299616000000001e-10,
                           1.5151920000000001e-10,
                           9.223400000000001e-11],
                          [6.7176e-11, 6.79224e-10, 6.465000000000001e-10],
                          [3.0602400000000003e-10, 3.0602400000000003e-10, 0.0],
                          [4.4037600000000005e-10,
                           4.4037600000000005e-10,
                           4.3100000000000006e-10],
                          [6.79224e-10, 6.7176e-11, 2.1550000000000003e-10],
                          [8.9568e-11, 2.433264e-10, 6.48224e-10],
                          [1.298736e-10, 4.627680000000001e-10, 4.32724e-10],
                          [2.433264e-10, 8.9568e-11, 2.1377600000000003e-10],
                          [2.83632e-10, 6.165264e-10, 8.60276e-10],
                          [4.627680000000001e-10,
                           1.298736e-10,
                           4.2927600000000006e-10],
                          [5.030736e-10,
                           6.568320000000001e-10,
                           6.447760000000001e-10],
                          [6.165264e-10, 2.83632e-10, 1.7240000000000003e-12],
                          [6.568320000000001e-10,
                           5.030736e-10,
                           2.1722400000000003e-10]],
       'lattice_vectors': [[7.464e-10, 0.0, 0.0],
                           [0.0, 7.464e-10, 0.0],
                           [0.0, 0.0, 8.62e-10]],
       'normalized_wyckoff': {'a': {'X_1': 1}, 'b': {'X_0': 6, 'X_1': 2}},
       'normalized_wysytax': {'a': {'X_1': 1}, 'b': {'X_0': 6, 'X_1': 2}}},
      {'Notes': 'st12',
       'Pearsons Symbol': 'tP12',
       'Prototype': 'Si',
       'Space Group': 'P43212',
       'Space Group Number': 96,
       'Strukturbericht Designation': '-',
       'Wyckoff Positions': 'ab',
       'aflow_prototype_id': 'A_tP12_96_ab',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_tP12_96_ab.html',
       'atom_labels': ['Si',
                       'Si',
                       'Si',
                       'Si',
                       'Si',
                       'Si',
                       'Si',
                       'Si',
                       'Si',
                       'Si',
                       'Si',
                       'Si'],
       'atom_positions': [[4.68553831467e-11, 4.68553831467e-11, 0.0],
                          [-4.68553831467e-11,
                           -4.68553831467e-11,
                           3.476901225e-10],
                          [2.290891583533e-10,
                           3.227999246467e-10,
                           5.215351837499999e-10],
                          [3.227999246467e-10,
                           2.290891583533e-10,
                           1.7384506125e-10],
                          [6.666820122640001e-11,
                           3.726355088416e-10,
                           1.6828201929e-11],
                          [9.669096734160002e-11,
                           2.0927634027360002e-10,
                           1.90673263179e-10],
                          [1.792535741584e-10,
                           4.852208817736e-10,
                           3.30861920571e-10],
                          [2.0927634027360002e-10,
                           9.669096734160002e-11,
                           5.04706981821e-10],
                          [3.426127427264e-10,
                           4.551981156584e-10,
                           1.57016859321e-10],
                          [3.726355088416e-10,
                           6.666820122640001e-11,
                           -1.6828201929e-11],
                          [4.551981156584e-10,
                           3.426127427264e-10,
                           5.38363385679e-10],
                          [4.852208817736e-10,
                           1.792535741584e-10,
                           3.6451832442899994e-10]],
       'lattice_vectors': [[5.51889083e-10, 0.0, 0.0],
                           [0.0, 5.51889083e-10, 0.0],
                           [0.0, 0.0, 6.95380245e-10]],
       'normalized_wyckoff': {'a': {'X_0': 1}, 'b': {'X_0': 2}},
       'normalized_wysytax': {'a': {'X_0': 1}, 'b': {'X_0': 2}}}],
 99: [{'Notes': 'tetragonal PZT (x<0.52)',
       'Pearsons Symbol': 'tP5',
       'Prototype': 'O3PbTi1-xZrx',
       'Space Group': 'P4mm',
       'Space Group Number': 99,
       'Strukturbericht Designation': '-',
       'Wyckoff Positions': 'abc',
       'aflow_prototype_id': 'A3BC_tP5_99_bc_a_b',
       'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A3BC_tP5_99_bc_a_b.html',
       'atom_labels': ['O', 'O', 'O', 'Pb', 'Zr'],
       'atom_positions': [[2.023e-10, 2.023e-10, -4.2511638000000006e-11],
                          [0.0, 2.023e-10, 1.5667628999999999e-10],
                          [2.023e-10, 0.0, 1.5667628999999999e-10],
                          [0.0, 0.0, 0.0],
                          [2.023e-10, 2.023e-10, 1.86976698e-10]],
       'lattice_vectors': [[4.046e-10, 0.0, 0.0],
                           [0.0, 4.046e-10, 0.0],
                           [0.0, 0.0, 4.1394e-10]],
       'normalized_wyckoff': {'a': {'X_1': 1},
                              'b': {'X_0': 1, 'X_2': 1},
                              'c': {'X_0': 2}},
       'normalized_wysytax': {'a': {'X_1': 1},
                              'b': {'X_0': 1, 'X_2': 1},
                              'c': {'X_0': 2}}}],
 113: [{'Notes': '-',
        'Pearsons Symbol': 'tP8',
        'Prototype': 'BaS3',
        'Space Group': 'P421m',
        'Space Group Number': 113,
        'Strukturbericht Designation': 'D017',
        'Wyckoff Positions': 'ace',
        'aflow_prototype_id': 'AB3_tP8_113_a_ce',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB3_tP8_113_a_ce.html',
        'atom_labels': ['Ba', 'Ba', 'S', 'S', 'S', 'S', 'S', 'S'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [3.4355e-10, 3.4355e-10, 0.0],
                           [0.0, 3.4355e-10, 8.586286e-11],
                           [3.4355e-10, 0.0, 3.3094714e-10],
                           [1.2347187000000002e-10,
                            4.670218700000001e-10,
                            1.9840156e-10],
                           [2.2007813e-10,
                            1.2347187000000002e-10,
                            2.1840844e-10],
                           [4.670218700000001e-10,
                            5.6362813e-10,
                            2.1840844e-10],
                           [5.6362813e-10, 2.2007813e-10, 1.9840156e-10]],
        'lattice_vectors': [[6.871e-10, 0.0, 0.0],
                            [0.0, 6.871e-10, 0.0],
                            [0.0, 0.0, 4.1681e-10]],
        'normalized_wyckoff': {'a': {'X_1': 1},
                               'c': {'X_0': 1},
                               'e': {'X_0': 2}},
        'normalized_wysytax': {'a': {'X_1': 1},
                               'c': {'X_0': 1},
                               'e': {'X_0': 2}}}],
 121: [{'Notes': 'stannite',
        'Pearsons Symbol': 'tI16',
        'Prototype': 'Cu2FeS4Sn',
        'Space Group': 'I42m',
        'Space Group Number': 121,
        'Strukturbericht Designation': 'H26',
        'Wyckoff Positions': 'abdi',
        'aflow_prototype_id': 'A2BC4D_tI16_121_d_a_i_b',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2BC4D_tI16_121_d_a_i_b.html',
        'atom_labels': ['Fe', 'Sn', 'Cu', 'Cu', 'S', 'S', 'S', 'S'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [2.7245000000000003e-10,
                            2.7245000000000003e-10,
                            0.0],
                           [0.0, 2.7245000000000003e-10, 2.68925e-10],
                           [2.7245000000000003e-10, 0.0, 2.68925e-10],
                           [-1.3344601e-10, -1.3344601e-10, -1.3962586e-10],
                           [1.3344601e-10, 1.3344601e-10, -1.3962586e-10],
                           [-1.3344601e-10, 1.3344601e-10, 1.3962586e-10],
                           [1.3344601e-10, -1.3344601e-10, 1.3962586e-10]],
        'lattice_vectors': [[5.449000000000001e-10, 0.0, 0.0],
                            [0.0, 5.449000000000001e-10, 0.0],
                            [2.7245000000000003e-10,
                             2.7245000000000003e-10,
                             5.3785e-10]],
        'normalized_wyckoff': {'a': {'X_2': 1},
                               'b': {'X_3': 1},
                               'd': {'X_1': 2},
                               'i': {'X_0': 4}},
        'normalized_wysytax': {'a': {'X_2': 1},
                               'b': {'X_3': 1},
                               'd': {'X_0': 2},
                               'i': {'X_1': 2}}}],
 122: [{'Notes': 'chalcopyrite',
        'Pearsons Symbol': 'tI16',
        'Prototype': 'CuFeS2',
        'Space Group': 'I42d',
        'Space Group Number': 122,
        'Strukturbericht Designation': 'E11',
        'Wyckoff Positions': 'abd',
        'aflow_prototype_id': 'ABC2_tI16_122_a_b_d',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/ABC2_tI16_122_a_b_d.html',
        'atom_labels': ['Cu', 'Cu', 'Fe', 'Fe', 'S', 'S', 'S', 'S'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [0.0, 2.6432e-10, 2.60255e-10],
                           [2.6432e-10, 2.6432e-10, 0.0],
                           [2.6432e-10, 0.0, 2.60255e-10],
                           [1.3586050000000001e-10, 1.3216e-10, 1.301275e-10],
                           [-1.3586050000000001e-10, -1.3216e-10, 1.301275e-10],
                           [-1.3216e-10, 1.3586050000000001e-10, -1.301275e-10],
                           [1.3216e-10,
                            -1.3586050000000001e-10,
                            -1.301275e-10]],
        'lattice_vectors': [[5.2864e-10, 0.0, 0.0],
                            [0.0, 5.2864e-10, 0.0],
                            [2.6432e-10, 2.6432e-10, 5.2051e-10]],
        'normalized_wyckoff': {'a': {'X_1': 1},
                               'b': {'X_2': 1},
                               'd': {'X_0': 2}},
        'normalized_wysytax': {'a': {'X_0': 1},
                               'b': {'X_1': 1},
                               'd': {'X_2': 1}}}],
 123: [{'Notes': '-',
        'Pearsons Symbol': 'tP2',
        'Prototype': 'AuCu',
        'Space Group': 'P4/mmm',
        'Space Group Number': 123,
        'Strukturbericht Designation': 'L10',
        'Wyckoff Positions': 'ad',
        'aflow_prototype_id': 'AB_tP2_123_a_d',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_tP2_123_a_d.html',
        'atom_labels': ['Au', 'Cu'],
        'atom_positions': [[0.0, 0.0, 0.0], [1.9815e-10, 0.0, 1.8355e-10]],
        'lattice_vectors': [[1.9815e-10, -1.9815e-10, 0.0],
                            [1.9815e-10, 1.9815e-10, 0.0],
                            [0.0, 0.0, 3.671e-10]],
        'normalized_wyckoff': {'a': {'X_0': 1}, 'd': {'X_1': 1}},
        'normalized_wysytax': {'a': {'X_0': 1}, 'd': {'X_1': 1}}},
       {'Notes': 'prototype for high-Tc cuprates',
        'Pearsons Symbol': 'tP4',
        'Prototype': 'CaCuO2',
        'Space Group': 'P4/mmm',
        'Space Group Number': 123,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'adf',
        'aflow_prototype_id': 'ABC2_tP4_123_d_a_f',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/ABC2_tP4_123_d_a_f.html',
        'atom_labels': ['Ca', 'Cu', 'O', 'O'],
        'atom_positions': [[1.9305500000000004e-10,
                            1.9305500000000004e-10,
                            1.59975e-10],
                           [0.0, 0.0, 0.0],
                           [0.0, 1.9305500000000004e-10, 0.0],
                           [1.9305500000000004e-10, 0.0, 0.0]],
        'lattice_vectors': [[3.8611e-10, 0.0, 0.0],
                            [0.0, 3.8611e-10, 0.0],
                            [0.0, 0.0, 3.1995e-10]],
        'normalized_wyckoff': {'b': {'X_1': 1},
                               'c': {'X_2': 1},
                               'e': {'X_0': 2}},
        'normalized_wysytax': {'a': {'X_1': 1},
                               'd': {'X_2': 1},
                               'f': {'X_0': 2}}},
       {'Notes': '-',
        'Pearsons Symbol': 'tP7',
        'Prototype': 'CoGa5Ho',
        'Space Group': 'P4/mmm',
        'Space Group Number': 123,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'abci',
        'aflow_prototype_id': 'AB5C_tP7_123_b_ci_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB5C_tP7_123_b_ci_a.html',
        'atom_labels': ['Co', 'Ga', 'Ga', 'Ga', 'Ga', 'Ga', 'Ho'],
        'atom_positions': [[0.0, 0.0, 3.3975e-10],
                           [2.1035e-10, 2.1035e-10, 0.0],
                           [0.0, 2.1035e-10, 2.12004e-10],
                           [0.0, 2.1035e-10, 4.67496e-10],
                           [2.1035e-10, 0.0, 2.12004e-10],
                           [2.1035e-10, 0.0, 4.67496e-10],
                           [0.0, 0.0, 0.0]],
        'lattice_vectors': [[4.207e-10, 0.0, 0.0],
                            [0.0, 4.207e-10, 0.0],
                            [0.0, 0.0, 6.795e-10]],
        'normalized_wyckoff': {'a': {'X_1': 1},
                               'b': {'X_2': 1},
                               'c': {'X_0': 1},
                               'i': {'X_0': 4}},
        'normalized_wysytax': {'a': {'X_1': 1},
                               'b': {'X_2': 1},
                               'c': {'X_0': 1},
                               'i': {'X_0': 4}}},
       {'Notes': '-',
        'Pearsons Symbol': 'tP4',
        'Prototype': 'CuTi3',
        'Space Group': 'P4/mmm',
        'Space Group Number': 123,
        'Strukturbericht Designation': 'L60',
        'Wyckoff Positions': 'ace',
        'aflow_prototype_id': 'AB3_tP4_123_a_ce',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB3_tP4_123_a_ce.html',
        'atom_labels': ['Cu', 'Ti', 'Ti', 'Ti'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [2.0790000000000003e-10,
                            2.0790000000000003e-10,
                            0.0],
                           [0.0, 2.0790000000000003e-10, 1.797e-10],
                           [2.0790000000000003e-10, 0.0, 1.797e-10]],
        'lattice_vectors': [[4.1580000000000005e-10, 0.0, 0.0],
                            [0.0, 4.1580000000000005e-10, 0.0],
                            [0.0, 0.0, 3.594e-10]],
        'normalized_wyckoff': {'a': {'X_1': 1},
                               'c': {'X_0': 1},
                               'e': {'X_0': 2}},
        'normalized_wysytax': {'a': {'X_1': 1},
                               'c': {'X_0': 1},
                               'e': {'X_0': 2}}}],
 127: [{'Notes': '-',
        'Pearsons Symbol': 'tP10',
        'Prototype': 'Si2U3',
        'Space Group': 'P4/mbm',
        'Space Group Number': 127,
        'Strukturbericht Designation': 'D5a',
        'Wyckoff Positions': 'agh',
        'aflow_prototype_id': 'A2B3_tP10_127_g_ah',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2B3_tP10_127_g_ah.html',
        'atom_labels': ['U', 'U', 'U', 'U', 'U', 'U', 'Si', 'Si', 'Si', 'Si'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [3.6649500000000004e-10,
                            3.6649500000000004e-10,
                            0.0],
                           [1.3267119000000002e-10, 4.9916619e-10, 1.9502e-10],
                           [-1.3267119000000002e-10, 2.3382381e-10, 1.9502e-10],
                           [4.9916619e-10, -1.3267119000000002e-10, 1.9502e-10],
                           [2.3382381e-10, 1.3267119000000002e-10, 1.9502e-10],
                           [2.8513311e-10, 6.5162811e-10, 0.0],
                           [-2.8513311e-10, 8.136189000000001e-11, 0.0],
                           [6.5162811e-10, -2.8513311e-10, 0.0],
                           [8.136189000000001e-11, 2.8513311e-10, 0.0]],
        'lattice_vectors': [[7.329900000000001e-10, 0.0, 0.0],
                            [0.0, 7.329900000000001e-10, 0.0],
                            [0.0, 0.0, 3.9004e-10]],
        'normalized_wyckoff': {'b': {'X_0': 1},
                               'g': {'X_0': 2},
                               'h': {'X_1': 2}},
        'normalized_wysytax': {'a': {'X_0': 1},
                               'g': {'X_1': 2},
                               'h': {'X_0': 2}}}],
 129: [{'Notes': '-',
        'Pearsons Symbol': 'tP8',
        'Prototype': 'AsCuSiZr',
        'Space Group': 'P4/nmm',
        'Space Group Number': 129,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'abc2',
        'aflow_prototype_id': 'ABCD_tP8_129_c_b_a_c',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/ABCD_tP8_129_c_b_a_c.html',
        'atom_labels': ['As', 'As', 'Cu', 'Cu', 'Si', 'Si', 'Zr', 'Zr'],
        'atom_positions': [[9.184e-11, 9.184e-11, 6.501716160000001e-10],
                           [2.7552e-10, 2.7552e-10, 3.06948384e-10],
                           [9.184e-11, 2.7552e-10, 4.7856e-10],
                           [2.7552e-10, 9.184e-11, 4.7856e-10],
                           [9.184e-11, 2.7552e-10, 0.0],
                           [2.7552e-10, 9.184e-11, 0.0],
                           [9.184e-11, 9.184e-11, 2.14969152e-10],
                           [2.7552e-10, 2.7552e-10, 7.42150848e-10]],
        'lattice_vectors': [[3.6736e-10, 0.0, 0.0],
                            [0.0, 3.6736e-10, 0.0],
                            [0.0, 0.0, 9.5712e-10]],
        'normalized_wysytax': {'a': {'X_0': 1},
                               'b': {'X_1': 1},
                               'c': {'X_2': 1, 'X_3': 1}}},
       {'Notes': 'matlockite',
        'Pearsons Symbol': 'tP6',
        'Prototype': 'ClFPb',
        'Space Group': 'P4/nmm',
        'Space Group Number': 129,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'ac2',
        'aflow_prototype_id': 'ABC_tP6_129_c_a_c',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/ABC_tP6_129_c_a_c.html',
        'atom_labels': ['Cl', 'Cl', 'F', 'F', 'Pb', 'Pb'],
        'atom_positions': [[1.0275e-10, 1.0275e-10, 4.707726199999999e-10],
                           [3.0824999999999994e-10,
                            3.0824999999999994e-10,
                            2.5382738e-10],
                           [1.0275e-10, 3.0824999999999994e-10, 0.0],
                           [3.0824999999999994e-10, 1.0275e-10, 0.0],
                           [1.0275e-10, 1.0275e-10, 1.4912268e-10],
                           [3.0824999999999994e-10,
                            3.0824999999999994e-10,
                            5.754773199999999e-10]],
        'lattice_vectors': [[4.11e-10, 0.0, 0.0],
                            [0.0, 4.11e-10, 0.0],
                            [0.0, 0.0, 7.246e-10]],
        'normalized_wysytax': {'a': {'X_0': 1}, 'c': {'X_1': 1, 'X_2': 1}}},
       {'Notes': '-',
        'Pearsons Symbol': 'tP6',
        'Prototype': 'Cu2Sb',
        'Space Group': 'I4/nmm',
        'Space Group Number': 129,
        'Strukturbericht Designation': 'C38',
        'Wyckoff Positions': 'ac2',
        'aflow_prototype_id': 'A2B_tP6_129_ac_c',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2B_tP6_129_ac_c.html',
        'atom_labels': ['Cu', 'Cu', 'Cu', 'Cu', 'Sb', 'Sb'],
        'atom_positions': [[2.994e-10, 9.980000000000001e-11, 0.0],
                           [9.980000000000001e-11, 2.994e-10, 0.0],
                           [9.980000000000001e-11,
                            9.980000000000001e-11,
                            1.6445700000000002e-10],
                           [2.994e-10, 2.994e-10, -1.6445700000000002e-10],
                           [9.980000000000001e-11,
                            9.980000000000001e-11,
                            4.2637e-10],
                           [2.994e-10, 2.994e-10, 1.8273e-10]],
        'lattice_vectors': [[3.9920000000000003e-10, 0.0, 0.0],
                            [0.0, 3.9920000000000003e-10, 0.0],
                            [0.0, 0.0, 6.091e-10]],
        'normalized_wysytax': {'a': {'X_0': 1}, 'c': {'X_0': 1, 'X_1': 1}}},
       {'Notes': '-',
        'Pearsons Symbol': 'tP4',
        'Prototype': 'CuTi (gamma)',
        'Space Group': 'P4/nmm',
        'Space Group Number': 129,
        'Strukturbericht Designation': 'B11',
        'Wyckoff Positions': 'c2',
        'aflow_prototype_id': 'AB_tP4_129_a_c',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_tP4_129_a_c.html',
        'atom_labels': ['Cu', 'Cu', 'Ti', 'Ti'],
        'atom_positions': [[-7.77e-11, 7.77e-11, 5.887e-11],
                           [7.77e-11, -7.77e-11, -5.887e-11],
                           [-7.77e-11, 7.77e-11, 3.8265e-10],
                           [7.77e-11, -7.77e-11, -3.8265e-10]],
        'lattice_vectors': [[3.108e-10, 0.0, 0.0],
                            [0.0, 3.108e-10, 0.0],
                            [0.0, 0.0, 5.886999999999999e-10]],
        'normalized_wysytax': {'c': {'X_0': 1, 'X_1': 1}}},
       {'Notes': '-',
        'Pearsons Symbol': 'tP4',
        'Prototype': 'Np (beta)',
        'Space Group': 'P4/nmm',
        'Space Group Number': 129,
        'Strukturbericht Designation': 'Ad',
        'Wyckoff Positions': 'ac',
        'aflow_prototype_id': 'A_tP4_129_ac',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_tP4_129_ac.html',
        'atom_labels': ['Np', 'Np', 'Np', 'Np'],
        'atom_positions': [[1.2242500000000002e-10, 3.67275e-10, 0.0],
                           [3.67275e-10, 1.2242500000000002e-10, 0.0],
                           [1.2242500000000002e-10,
                            1.2242500000000002e-10,
                            1.2705e-10],
                           [3.67275e-10, 3.67275e-10, -1.2705e-10]],
        'lattice_vectors': [[4.897000000000001e-10, 0.0, 0.0],
                            [0.0, 4.897000000000001e-10, 0.0],
                            [0.0, 0.0, 3.388e-10]],
        'normalized_wysytax': {'a': {'X_0': 1}, 'c': {'X_0': 1}}},
       {'Notes': '-',
        'Pearsons Symbol': 'tP4',
        'Prototype': 'OPb',
        'Space Group': 'P4/nmm',
        'Space Group Number': 129,
        'Strukturbericht Designation': 'B10',
        'Wyckoff Positions': 'ac',
        'aflow_prototype_id': 'AB_tP4_129_a_c',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_tP4_129_a_c.html',
        'atom_labels': ['O', 'O', 'Pb', 'Pb'],
        'atom_positions': [[9.9995e-11, 2.99985e-10, 0.0],
                           [2.99985e-10, 9.9995e-11, 0.0],
                           [9.9995e-11, 9.9995e-11, 1.186317e-10],
                           [2.99985e-10, 2.99985e-10, -1.186317e-10]],
        'lattice_vectors': [[3.9998e-10, 0.0, 0.0],
                            [0.0, 3.9998e-10, 0.0],
                            [0.0, 0.0, 5.065400000000001e-10]],
        'normalized_wysytax': {'a': {'X_0': 1}, 'c': {'X_1': 1}}}],
 131: [{'Notes': '-',
        'Pearsons Symbol': 'tP4',
        'Prototype': 'PtS',
        'Space Group': 'P42/mmc',
        'Space Group Number': 131,
        'Strukturbericht Designation': 'B17',
        'Wyckoff Positions': 'ce',
        'aflow_prototype_id': 'AB_tP4_131_c_e',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_tP4_131_c_e.html',
        'atom_labels': ['Pt', 'Pt', 'S', 'S'],
        'atom_positions': [[0.0, 1.73505e-10, 0.0],
                           [1.73505e-10, 0.0, 3.0546000000000005e-10],
                           [0.0, 0.0, 1.5273000000000002e-10],
                           [0.0, 0.0, 4.5819000000000005e-10]],
        'lattice_vectors': [[3.4701e-10, 0.0, 0.0],
                            [0.0, 3.4701e-10, 0.0],
                            [0.0, 0.0, 6.109200000000001e-10]],
        'normalized_wyckoff': {'c': {'X_0': 1}, 'e': {'X_1': 1}},
        'normalized_wysytax': {'c': {'X_0': 1}, 'e': {'X_1': 1}}}],
 134: [{'Notes': '-',
        'Pearsons Symbol': 'tP50',
        'Prototype': 'B',
        'Space Group': 'P42/nnm',
        'Space Group Number': 134,
        'Strukturbericht Designation': 'Ag',
        'Wyckoff Positions': 'bm2n2',
        'aflow_prototype_id': 'A_tP50_134_b2m2n',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_tP50_134_b2m2n.html',
        'atom_labels': ['B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B'],
        'atom_positions': [[-2.1890000000000001e-10,
                            2.1890000000000001e-10,
                            1.2695e-10],
                           [2.1890000000000001e-10,
                            -2.1890000000000001e-10,
                            -1.2695e-10],
                           [4.20288e-12, -4.335971200000001e-10, 1.696052e-10],
                           [4.335971200000001e-10,
                            -4.335971200000001e-10,
                            8.42948e-11],
                           [4.335971200000001e-10, -4.20288e-12, 1.696052e-10],
                           [4.20288e-12, -4.20288e-12, 8.42948e-11],
                           [-4.335971200000001e-10, 4.20288e-12, -1.696052e-10],
                           [-4.20288e-12, 4.20288e-12, -8.42948e-11],
                           [-4.20288e-12, 4.335971200000001e-10, -1.696052e-10],
                           [-4.335971200000001e-10,
                            4.335971200000001e-10,
                            -8.42948e-11],
                           [-1.120768e-10, 3.257232e-10, 6.72835e-11],
                           [-3.257232e-10,
                            3.257232e-10,
                            -3.2118350000000005e-10],
                           [-3.257232e-10, 1.120768e-10, 6.72835e-11],
                           [-1.120768e-10,
                            1.120768e-10,
                            -3.2118350000000005e-10],
                           [3.257232e-10, 7.635232000000001e-10, -6.72835e-11],
                           [1.120768e-10,
                            7.635232000000001e-10,
                            -1.8661650000000002e-10],
                           [1.120768e-10, 5.498768e-10, -6.72835e-11],
                           [3.257232e-10,
                            5.498768e-10,
                            -1.8661650000000002e-10],
                           [-2.022636e-11,
                            2.9026139999999997e-10,
                            -8.22636e-11],
                           [-4.1757364e-10,
                            2.9026139999999997e-10,
                            -1.716364e-10],
                           [-2.9026139999999997e-10,
                            4.1757364e-10,
                            -1.716364e-10],
                           [-1.475386e-10, 4.1757364e-10, -8.22636e-11],
                           [-4.1757364e-10, 1.475386e-10, -8.22636e-11],
                           [-2.022636e-11, 1.475386e-10, -1.716364e-10],
                           [-1.475386e-10, 2.022636e-11, -1.716364e-10],
                           [-2.9026139999999997e-10,
                            2.022636e-11,
                            -8.22636e-11],
                           [4.1757364e-10, 7.280614e-10, 8.22636e-11],
                           [2.022636e-11, 7.280614e-10, 1.716364e-10],
                           [1.475386e-10, 8.5537364e-10, 1.716364e-10],
                           [2.9026139999999997e-10, 8.5537364e-10, 8.22636e-11],
                           [2.022636e-11, 5.853386e-10, 8.22636e-11],
                           [4.1757364e-10, 5.853386e-10, 1.716364e-10],
                           [2.9026139999999997e-10,
                            4.5802636000000004e-10,
                            1.716364e-10],
                           [1.475386e-10, 4.5802636000000004e-10, 8.22636e-11],
                           [6.602024e-11, 2.9586524000000003e-10, 7.59161e-11],
                           [-5.038202400000001e-10,
                            2.9586524000000003e-10,
                            -3.298161e-10],
                           [-2.9586524000000003e-10,
                            5.038202400000001e-10,
                            -3.298161e-10],
                           [-1.4193476e-10, 5.038202400000001e-10, 7.59161e-11],
                           [-5.038202400000001e-10, 1.4193476e-10, 7.59161e-11],
                           [6.602024e-11, 1.4193476e-10, -3.298161e-10],
                           [-1.4193476e-10, -6.602024e-11, -3.298161e-10],
                           [-2.9586524000000003e-10,
                            -6.602024e-11,
                            7.59161e-11],
                           [5.038202400000001e-10, 7.3366524e-10, -7.59161e-11],
                           [-6.602024e-11, 7.3366524e-10, 3.298161e-10],
                           [1.4193476e-10, 9.4162024e-10, 3.298161e-10],
                           [2.9586524000000003e-10,
                            9.4162024e-10,
                            -7.59161e-11],
                           [-6.602024e-11, 5.7973476e-10, -7.59161e-11],
                           [5.038202400000001e-10, 5.7973476e-10, 3.298161e-10],
                           [2.9586524000000003e-10,
                            3.7177976e-10,
                            3.298161e-10],
                           [1.4193476e-10, 3.7177976e-10, -7.59161e-11]],
        'lattice_vectors': [[8.756000000000001e-10, 0.0, 0.0],
                            [0.0, 8.756000000000001e-10, 0.0],
                            [0.0, 0.0, 5.078e-10]],
        'normalized_wysytax': {'a': {'X_0': 1},
                               'm': {'X_0': 8},
                               'n': {'X_0': 16}}}],
 136: [{'Notes': '-',
        'Pearsons Symbol': 'tP8',
        'Prototype': 'BeO (beta)',
        'Space Group': 'P42/mnm',
        'Space Group Number': 136,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'fg',
        'aflow_prototype_id': 'AB_tP8_136_g_f',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_tP8_136_g_f.html',
        'atom_labels': ['Be', 'Be', 'Be', 'Be', 'O', 'O', 'O', 'O'],
        'atom_positions': [[7.79e-11, 7.79e-11, 1.37e-10],
                           [1.596e-10, 3.1539999999999997e-10, 0.0],
                           [3.1539999999999997e-10, 1.596e-10, 0.0],
                           [3.971e-10, 3.971e-10, 1.37e-10],
                           [9.025e-11, 3.8475000000000004e-10, 1.37e-10],
                           [1.4725e-10, 1.4725e-10, 0.0],
                           [3.2775e-10, 3.2775e-10, 0.0],
                           [3.8475000000000004e-10, 9.025e-11, 1.37e-10]],
        'lattice_vectors': [[4.75e-10, 0.0, 0.0],
                            [0.0, 4.75e-10, 0.0],
                            [0.0, 0.0, 2.74e-10]],
        'normalized_wyckoff': {'f': {'X_0': 1}, 'g': {'X_1': 1}},
        'normalized_wysytax': {'f': {'X_0': 1}, 'g': {'X_1': 1}}},
       {'Notes': '-',
        'Pearsons Symbol': 'tP30',
        'Prototype': 'CrFe (sigma)',
        'Space Group': 'P42/mnm',
        'Space Group Number': 136,
        'Strukturbericht Designation': 'D8b',
        'Wyckoff Positions': 'afi3',
        'aflow_prototype_id': 'sigma_tP30_136_bf2ij',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/sigma_tP30_136_bf2ij.html',
        'atom_labels': ['Pd',
                        'Pd',
                        'Rh',
                        'Rh',
                        'Rh',
                        'Rh',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Cr',
                        'Cr',
                        'Cr',
                        'Cr',
                        'Cr',
                        'Cr',
                        'Cr',
                        'Cr',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [4.3983e-10, 4.3983e-10, 2.2791000000000002e-10],
                           [3.50667662e-10, 3.50667662e-10, 0.0],
                           [-3.50667662e-10, -3.50667662e-10, 0.0],
                           [-8.9162338e-11,
                            8.9162338e-11,
                            2.2791000000000002e-10],
                           [8.9162338e-11,
                            -8.9162338e-11,
                            2.2791000000000002e-10],
                           [4.0771361300000007e-10,
                            1.1542898500000001e-10,
                            0.0],
                           [-4.0771361300000007e-10,
                            -1.1542898500000001e-10,
                            0.0],
                           [-3.2116387e-11,
                            3.24401015e-10,
                            2.2791000000000002e-10],
                           [3.2116387e-11,
                            -3.24401015e-10,
                            2.2791000000000002e-10],
                           [1.1542898500000001e-10,
                            4.0771361300000007e-10,
                            0.0],
                           [-1.1542898500000001e-10,
                            -4.0771361300000007e-10,
                            0.0],
                           [-3.24401015e-10,
                            3.2116387e-11,
                            2.2791000000000002e-10],
                           [3.24401015e-10,
                            -3.2116387e-11,
                            2.2791000000000002e-10],
                           [6.50359028e-10, 5.8136729e-11, 0.0],
                           [-6.50359028e-10, -5.8136729e-11, 0.0],
                           [2.1052902800000003e-10,
                            3.8169327100000004e-10,
                            2.2791000000000002e-10],
                           [-2.1052902800000003e-10,
                            -3.8169327100000004e-10,
                            2.2791000000000002e-10],
                           [5.8136729e-11, 6.50359028e-10, 0.0],
                           [-5.8136729e-11, -6.50359028e-10, 0.0],
                           [-3.8169327100000004e-10,
                            -2.1052902800000003e-10,
                            2.2791000000000002e-10],
                           [3.8169327100000004e-10,
                            2.1052902800000003e-10,
                            2.2791000000000002e-10],
                           [1.6068749200000002e-10,
                            1.6068749200000002e-10,
                            1.14875756e-10],
                           [-1.6068749200000002e-10,
                            -1.6068749200000002e-10,
                            1.14875756e-10],
                           [-2.79142508e-10, 2.79142508e-10, -1.13034244e-10],
                           [2.79142508e-10, -2.79142508e-10, -1.13034244e-10],
                           [1.6068749200000002e-10,
                            1.6068749200000002e-10,
                            -1.14875756e-10],
                           [-1.6068749200000002e-10,
                            -1.6068749200000002e-10,
                            -1.14875756e-10],
                           [-2.79142508e-10, 2.79142508e-10, 1.13034244e-10],
                           [2.79142508e-10, -2.79142508e-10, 1.13034244e-10]],
        'lattice_vectors': [[8.7966e-10, 0.0, 0.0],
                            [0.0, 8.7966e-10, 0.0],
                            [0.0, 0.0, 4.5582000000000003e-10]],
        'normalized_wyckoff': {'a': {'X_4': 1},
                               'f': {'X_3': 2},
                               'i': {'X_0': 4, 'X_1': 4},
                               'j': {'X_2': 4}},
        'normalized_wysytax': {'a': {'X_4': 1},
                               'f': {'X_3': 2},
                               'i': {'X_0': 4, 'X_1': 4},
                               'j': {'X_2': 4}}},
       {'Notes': 'gamma N2',
        'Pearsons Symbol': 'tP4',
        'Prototype': 'N (gamma)',
        'Space Group': 'P42/mnm',
        'Space Group Number': 136,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'f',
        'aflow_prototype_id': 'A_tP4_136_f',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_tP4_136_f.html',
        'atom_labels': ['N', 'N', 'N', 'N'],
        'atom_positions': [[3.87786e-11, 3.87786e-11, 0.0],
                           [-3.87786e-11, -3.87786e-11, 0.0],
                           [1.590714e-10, 2.366286e-10, 2.5545000000000003e-10],
                           [2.366286e-10,
                            1.590714e-10,
                            2.5545000000000003e-10]],
        'lattice_vectors': [[3.957e-10, 0.0, 0.0],
                            [0.0, 3.957e-10, 0.0],
                            [0.0, 0.0, 5.109000000000001e-10]],
        'normalized_wyckoff': {'f': {'X_0': 1}},
        'normalized_wysytax': {'f': {'X_0': 1}}},
       {'Notes': 'rutile',
        'Pearsons Symbol': 'tP6',
        'Prototype': 'O2Ti',
        'Space Group': 'P42/mnm',
        'Space Group Number': 136,
        'Strukturbericht Designation': 'C4',
        'Wyckoff Positions': 'af',
        'aflow_prototype_id': 'A2B_tP6_136_f_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2B_tP6_136_f_a.html',
        'atom_labels': ['O', 'O', 'O', 'O', 'Ti', 'Ti'],
        'atom_positions': [[8.95662688e-11,
                            3.696537312e-10,
                            1.4787000000000003e-10],
                           [1.4004373120000002e-10,
                            1.4004373120000002e-10,
                            0.0],
                           [3.191762688e-10, 3.191762688e-10, 0.0],
                           [3.696537312e-10,
                            8.95662688e-11,
                            1.4787000000000003e-10],
                           [0.0, 0.0, 0.0],
                           [2.2961000000000002e-10,
                            2.2961000000000002e-10,
                            1.4787000000000003e-10]],
        'lattice_vectors': [[4.5922e-10, 0.0, 0.0],
                            [0.0, 4.5922e-10, 0.0],
                            [0.0, 0.0, 2.9574e-10]],
        'normalized_wyckoff': {'a': {'X_1': 1}, 'f': {'X_0': 2}},
        'normalized_wysytax': {'a': {'X_1': 1}, 'f': {'X_0': 2}}},
       {'Notes': '-',
        'Pearsons Symbol': 'tP30',
        'Prototype': 'U (beta)',
        'Space Group': 'P42/mnm',
        'Space Group Number': 136,
        'Strukturbericht Designation': 'Ab',
        'Wyckoff Positions': 'bfi2j',
        'aflow_prototype_id': 'A_tP30_136_bf2ij',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_tP30_136_bf2ij.html',
        'atom_labels': ['U',
                        'U',
                        'U',
                        'U',
                        'U',
                        'U',
                        'U',
                        'U',
                        'U',
                        'U',
                        'U',
                        'U',
                        'U',
                        'U',
                        'U',
                        'U',
                        'U',
                        'U',
                        'U',
                        'U',
                        'U',
                        'U',
                        'U',
                        'U',
                        'U',
                        'U',
                        'U',
                        'U',
                        'U',
                        'U'],
        'atom_positions': [[0.0, 0.0, 2.828e-10],
                           [5.3795e-10, 5.3795e-10, 0.0],
                           [1.108177e-10, 1.108177e-10, 0.0],
                           [-1.108177e-10, -1.108177e-10, 0.0],
                           [6.487677e-10, 4.271323e-10, 2.828e-10],
                           [4.271323e-10, 6.487677e-10, 2.828e-10],
                           [3.421362e-10, 3.421362e-10, 4.12888e-10],
                           [-3.421362e-10, -3.421362e-10, 4.12888e-10],
                           [-3.421362e-10, -3.421362e-10, -4.12888e-10],
                           [3.421362e-10, 3.421362e-10, -4.12888e-10],
                           [8.800862e-10, 1.958138e-10, 6.95688e-10],
                           [1.958138e-10, 8.800862e-10, 6.95688e-10],
                           [1.958138e-10, 8.800862e-10, -1.30088e-10],
                           [8.800862e-10, 1.958138e-10, -1.30088e-10],
                           [6.035799e-10, 2.528365e-10, 0.0],
                           [-6.035799e-10, -2.528365e-10, 0.0],
                           [2.528365e-10, 6.035799e-10, 0.0],
                           [-2.528365e-10, -6.035799e-10, 0.0],
                           [1.1415299e-09, 2.8511350000000004e-10, 2.828e-10],
                           [-6.56299e-11, 7.907865e-10, 2.828e-10],
                           [7.907865e-10, -6.56299e-11, 2.828e-10],
                           [2.8511350000000004e-10, 1.1415299e-09, 2.828e-10],
                           [3.948553e-10, 4.08842e-11, 0.0],
                           [-3.948553e-10, -4.08842e-11, 0.0],
                           [4.08842e-11, 3.948553e-10, 0.0],
                           [-4.08842e-11, -3.948553e-10, 0.0],
                           [9.328053000000002e-10, 4.970658e-10, 2.828e-10],
                           [1.430947e-10, 5.788342000000001e-10, 2.828e-10],
                           [5.788342000000001e-10, 1.430947e-10, 2.828e-10],
                           [4.970658e-10, 9.328053000000002e-10, 2.828e-10]],
        'lattice_vectors': [[1.0759e-09, 0.0, 0.0],
                            [0.0, 1.0759e-09, 0.0],
                            [0.0, 0.0, 5.656e-10]],
        'normalized_wyckoff': {'b': {'X_0': 1},
                               'f': {'X_0': 2},
                               'i': {'X_0': 8},
                               'j': {'X_0': 4}},
        'normalized_wysytax': {'b': {'X_0': 1},
                               'f': {'X_0': 2},
                               'i': {'X_0': 8},
                               'j': {'X_0': 4}}}],
 139: [{'Notes': '-',
        'Pearsons Symbol': 'tI10',
        'Prototype': 'Al4Ba',
        'Space Group': 'I4/mmm',
        'Space Group Number': 139,
        'Strukturbericht Designation': 'D13',
        'Wyckoff Positions': 'ade',
        'aflow_prototype_id': 'A4B_tI10_139_de_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A4B_tI10_139_de_a.html',
        'atom_labels': ['Ba', 'Al', 'Al', 'Al', 'Al'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [0.0, 2.270991e-10, 2.78177e-10],
                           [2.270991e-10, 0.0, 2.78177e-10],
                           [0.0, 0.0, 4.22354e-10],
                           [0.0, 0.0, -4.22354e-10]],
        'lattice_vectors': [[4.541982e-10, 0.0, 0.0],
                            [0.0, 4.541982e-10, 0.0],
                            [2.270991e-10, 2.270991e-10, 5.56354e-10]],
        'normalized_wyckoff': {'a': {'X_1': 1},
                               'd': {'X_0': 2},
                               'e': {'X_0': 2}},
        'normalized_wysytax': {'a': {'X_1': 1},
                               'd': {'X_0': 2},
                               'e': {'X_0': 2}}},
       {'Notes': '-',
        'Pearsons Symbol': 'tI8',
        'Prototype': 'Al3Ti',
        'Space Group': 'I4/mmm',
        'Space Group Number': 139,
        'Strukturbericht Designation': 'D022',
        'Wyckoff Positions': 'abd',
        'aflow_prototype_id': 'A3B_tI8_139_bd_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A3B_tI8_139_bd_a.html',
        'atom_labels': ['Ti', 'Al', 'Al', 'Al'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [1.924e-10, 1.924e-10, 0.0],
                           [0.0, 1.924e-10, 2.149e-10],
                           [1.924e-10, 0.0, 2.149e-10]],
        'lattice_vectors': [[3.848e-10, 0.0, 0.0],
                            [0.0, 3.848e-10, 0.0],
                            [1.924e-10, 1.924e-10, 4.298e-10]],
        'normalized_wyckoff': {'a': {'X_1': 1},
                               'b': {'X_0': 1},
                               'd': {'X_0': 2}},
        'normalized_wysytax': {'a': {'X_1': 1},
                               'b': {'X_0': 1},
                               'd': {'X_0': 2}}},
       {'Notes': '-',
        'Pearsons Symbol': 'tI16',
        'Prototype': 'Al3Zr',
        'Space Group': 'I4/mmm',
        'Space Group Number': 139,
        'Strukturbericht Designation': 'D023',
        'Wyckoff Positions': 'cde2',
        'aflow_prototype_id': 'A3B_tI16_139_cde_e',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A3B_tI16_139_cde_e.html',
        'atom_labels': ['Al', 'Al', 'Al', 'Al', 'Al', 'Al', 'Zr', 'Zr'],
        'atom_positions': [[1.99965e-10, 0.0, 0.0],
                           [0.0, 1.99965e-10, 0.0],
                           [1.99965e-10, -1.2924697071141057e-26, 4.32075e-10],
                           [-1.2924697071141057e-26, 1.99965e-10, 4.32075e-10],
                           [0.0, 0.0, 6.48077934e-10],
                           [0.0, 0.0, 1.0802220659999998e-09],
                           [0.0, 0.0, 2.0542573799999996e-10],
                           [0.0, 0.0, 1.5228742619999998e-09]],
        'lattice_vectors': [[-1.99965e-10, 1.99965e-10, 8.6415e-10],
                            [1.99965e-10, -1.99965e-10, 8.6415e-10],
                            [1.99965e-10, 1.99965e-10, -8.6415e-10]],
        'normalized_wyckoff': {'c': {'X_0': 1},
                               'd': {'X_0': 1},
                               'e': {'X_0': 1, 'X_1': 1}},
        'normalized_wysytax': {'c': {'X_0': 1},
                               'd': {'X_0': 1},
                               'e': {'X_0': 1, 'X_1': 1}}},
       {'Notes': '-',
        'Pearsons Symbol': 'tI14',
        'Prototype': '(Ba,La)2CuO4',
        'Space Group': 'I4/mmm',
        'Space Group Number': 139,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'ace2',
        'aflow_prototype_id': 'AB2C4_tI14_139_a_e_ce',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB2C4_tI14_139_a_e_ce.html',
        'atom_labels': ['Cu', 'La', 'La', 'O', 'O', 'O', 'O'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [1.89085e-10, 1.89085e-10, 1.844881475e-10],
                           [3.7817000000000005e-10,
                            3.7817000000000005e-10,
                            4.779468525e-10],
                           [0.0, 1.89085e-10, 0.0],
                           [1.89085e-10, 0.0, 0.0],
                           [1.8910390849999998e-10,
                            1.8910390849999998e-10,
                            4.208449555e-10],
                           [3.7817e-10, 3.7817e-10, 2.41656288e-10]],
        'lattice_vectors': [[3.7817e-10, 0.0, 0.0],
                            [0.0, 3.7817e-10, 0.0],
                            [1.89085e-10, 1.89085e-10, 6.62435e-10]],
        'normalized_wyckoff': {'a': {'X_2': 1},
                               'c': {'X_0': 2},
                               'e': {'X_0': 2, 'X_1': 2}},
        'normalized_wysytax': {'a': {'X_2': 1},
                               'c': {'X_0': 2},
                               'e': {'X_0': 2, 'X_1': 2}}},
       {'Notes': '4-member ring',
        'Pearsons Symbol': 'tI8',
        'Prototype': 'C (4-ring)',
        'Space Group': 'I4/mmm',
        'Space Group Number': 139,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'h',
        'aflow_prototype_id': 'A_tI8_139_h',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_tI8_139_h.html',
        'atom_labels': ['C', 'C', 'C', 'C'],
        'atom_positions': [[7.8116071e-11, 7.8116071e-11, 0.0],
                           [-7.8116071e-11, 7.8116071e-11, 0.0],
                           [-7.8116071e-11, -7.8116071e-11, 0.0],
                           [7.8116071e-11, -7.8116071e-11, 0.0]],
        'lattice_vectors': [[4.33184e-10, 0.0, 0.0],
                            [0.0, 4.33184e-10, 0.0],
                            [2.16592e-10, 2.16592e-10, 1.24346e-10]],
        'normalized_wyckoff': {'h': {'X_0': 1}},
        'normalized_wysytax': {'h': {'X_0': 1}}},
       {'Notes': '-',
        'Pearsons Symbol': 'tI6',
        'Prototype': 'H2Th',
        'Space Group': 'I4/mmm',
        'Space Group Number': 139,
        'Strukturbericht Designation': "L'2",
        'Wyckoff Positions': 'ad',
        'aflow_prototype_id': 'A2B_tI6_139_d_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2B_tI6_139_d_a.html',
        'atom_labels': ['Th', 'H', 'H'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [0.0, 2.05e-10, 1.2575e-10],
                           [2.05e-10, 0.0, 1.2575e-10]],
        'lattice_vectors': [[4.1e-10, 0.0, 0.0],
                            [0.0, 4.1e-10, 0.0],
                            [2.05e-10, 2.05e-10, 2.515e-10]],
        'normalized_wyckoff': {'a': {'X_1': 1}, 'd': {'X_0': 2}},
        'normalized_wysytax': {'a': {'X_1': 1}, 'd': {'X_0': 2}}},
       {'Notes': 'fct',
        'Pearsons Symbol': 'tI2',
        'Prototype': 'In',
        'Space Group': 'I4/mmm',
        'Space Group Number': 139,
        'Strukturbericht Designation': 'A6',
        'Wyckoff Positions': 'a',
        'aflow_prototype_id': 'A_tI2_139_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_tI2_139_a.In.html',
        'atom_labels': ['In'],
        'atom_positions': [[0.0, 0.0, 0.0]],
        'lattice_vectors': [[3.2512769800000005e-10, 0.0, 0.0],
                            [0.0, 3.2512769800000005e-10, 0.0],
                            [1.6256384900000002e-10,
                             1.6256384900000002e-10,
                             2.4735000000000003e-10]],
        'normalized_wyckoff': {'a': {'X_0': 1}},
        'normalized_wysytax': {'a': {'X_0': 1}}},
       {'Notes': '-',
        'Pearsons Symbol': 'tI26',
        'Prototype': 'Mn12Th',
        'Space Group': 'I4/mmm',
        'Space Group Number': 139,
        'Strukturbericht Designation': 'D2b',
        'Wyckoff Positions': 'afij',
        'aflow_prototype_id': 'A12B_tI26_139_fij_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A12B_tI26_139_fij_a.html',
        'atom_labels': ['Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Th'],
        'atom_positions': [[2.1174999999999997e-10,
                            2.1174999999999997e-10,
                            -1.2375e-10],
                           [2.1174999999999997e-10,
                            -2.1174999999999997e-10,
                            1.2375e-10],
                           [-2.1174999999999997e-10,
                            2.1174999999999997e-10,
                            1.2375e-10],
                           [2.1174999999999997e-10,
                            2.1174999999999997e-10,
                            1.2375e-10],
                           [3.0576699999999994e-10, 0.0, 0.0],
                           [5.412329999999999e-10, 0.0, 0.0],
                           [0.0, 3.0576699999999994e-10, 0.0],
                           [0.0, 5.412329999999999e-10, 0.0],
                           [4.2349999999999993e-10, 2.35466e-10, 0.0],
                           [2.35466e-10, 4.2349999999999993e-10, 0.0],
                           [1.8803399999999995e-10,
                            1.2924697071141057e-26,
                            2.4749999999999997e-10],
                           [1.2924697071141057e-26,
                            1.8803399999999995e-10,
                            2.4749999999999997e-10],
                           [0.0, 0.0, 0.0]],
        'lattice_vectors': [[-4.235e-10, 4.235e-10, 2.475e-10],
                            [4.235e-10, -4.235e-10, 2.475e-10],
                            [4.235e-10, 4.235e-10, -2.475e-10]],
        'normalized_wyckoff': {'a': {'X_1': 1},
                               'f': {'X_0': 4},
                               'i': {'X_0': 4},
                               'j': {'X_0': 4}},
        'normalized_wysytax': {'a': {'X_1': 1},
                               'f': {'X_0': 1},
                               'i': {'X_0': 4},
                               'j': {'X_0': 4}}},
       {'Notes': '-',
        'Pearsons Symbol': 'tI6',
        'Prototype': 'MoSi2',
        'Space Group': 'I4/mmm',
        'Space Group Number': 139,
        'Strukturbericht Designation': 'C11b',
        'Wyckoff Positions': 'ae',
        'aflow_prototype_id': 'AB2_tI6_139_a_e',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB2_tI6_139_a_e.html',
        'atom_labels': ['Mo', 'Si', 'Si'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [1.6014999800000002e-10,
                            1.6014999800000002e-10,
                            1.30916665e-10],
                           [-1.6014999800000002e-10,
                            -1.6014999800000002e-10,
                            -1.30916665e-10]],
        'lattice_vectors': [[3.203e-10, 0.0, 0.0],
                            [0.0, 3.203e-10, 0.0],
                            [1.6015e-10, 1.6015e-10, 3.9275e-10]],
        'normalized_wyckoff': {'a': {'X_1': 1}, 'e': {'X_0': 2}},
        'normalized_wysytax': {'a': {'X_1': 1}, 'e': {'X_0': 2}}},
       {'Notes': '-',
        'Pearsons Symbol': 'tI18',
        'Prototype': 'NbNi8',
        'Space Group': 'I4/mmm',
        'Space Group Number': 139,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'ahi',
        'aflow_prototype_id': 'A4B5_tI18_139_i_ah',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A4B5_tI18_139_i_ah.html',
        'atom_labels': ['Nb', 'Ni', 'Ni', 'Ni', 'Ni', 'Ni', 'Ni', 'Ni', 'Ni'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [2.48901587e-10, 2.48901587e-10, 0.0],
                           [-2.48901587e-10, -2.48901587e-10, 0.0],
                           [-2.48901587e-10, 2.48901587e-10, 0.0],
                           [2.48901587e-10, -2.48901587e-10, 0.0],
                           [2.48901587e-10, 0.0, 0.0],
                           [-2.48901587e-10, 0.0, 0.0],
                           [0.0, 2.48901587e-10, 0.0],
                           [0.0, -2.48901587e-10, 0.0]],
        'lattice_vectors': [[-3.7335238e-10, 3.7335238e-10, 1.76e-10],
                            [3.7335238e-10, -3.7335238e-10, 1.76e-10],
                            [3.7335238e-10, 3.7335238e-10, -1.76e-10]],
        'normalized_wyckoff': {'a': {'X_1': 1},
                               'h': {'X_0': 4},
                               'i': {'X_0': 4}},
        'normalized_wysytax': {'a': {'X_1': 1},
                               'h': {'X_0': 2},
                               'i': {'X_0': 4}}},
       {'Notes': 'bct',
        'Pearsons Symbol': 'tI2',
        'Prototype': 'Pa (alpha)',
        'Space Group': 'I4/mmm',
        'Space Group Number': 139,
        'Strukturbericht Designation': 'Aa',
        'Wyckoff Positions': 'a',
        'aflow_prototype_id': 'A_tI2_139_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_tI2_139_a.alpha-Pa.html',
        'atom_labels': ['Pa'],
        'atom_positions': [[0.0, 0.0, 0.0]],
        'lattice_vectors': [[3.925e-10, 0.0, 0.0],
                            [0.0, 3.925e-10, 0.0],
                            [1.9625e-10, 1.9625e-10, 1.619e-10]],
        'normalized_wyckoff': {'a': {'X_0': 1}},
        'normalized_wysytax': {'a': {'X_0': 1}}},
       {'Notes': 'bct5',
        'Pearsons Symbol': 'tI4',
        'Prototype': 'Si',
        'Space Group': 'I4/mmm',
        'Space Group Number': 139,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'e',
        'aflow_prototype_id': 'A_tI4_139_e',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_tI4_139_e.html',
        'atom_labels': ['Si', 'Si'],
        'atom_positions': [[0.0, 0.0, 1.1773409702407442e-10],
                           [0.0, 0.0, 5.327305274183256e-10]],
        'lattice_vectors': [[-1.674581275665e-10,
                             1.674581275665e-10,
                             3.252323122212e-10],
                            [1.674581275665e-10,
                             -1.674581275665e-10,
                             3.252323122212e-10],
                            [1.674581275665e-10,
                             1.674581275665e-10,
                             -3.252323122212e-10]],
        'normalized_wyckoff': {'e': {'X_0': 1}},
        'normalized_wysytax': {'e': {'X_0': 1}}},
       {'Notes': '-',
        'Pearsons Symbol': 'tI18',
        'Prototype': 'V4Zn5',
        'Space Group': 'I4/mmm',
        'Space Group Number': 139,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'ahi',
        'aflow_prototype_id': 'A4B5_tI18_139_i_ah',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A4B5_tI18_139_i_ah.html',
        'atom_labels': ['Zn', 'Zn', 'Zn', 'Zn', 'Zn', 'V', 'V', 'V', 'V'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [2.9224800000000003e-10,
                            2.9224800000000003e-10,
                            0.0],
                           [-2.9224800000000003e-10,
                            -2.9224800000000003e-10,
                            0.0],
                           [-2.9224800000000003e-10,
                            2.9224800000000003e-10,
                            0.0],
                           [2.9224800000000003e-10,
                            -2.9224800000000003e-10,
                            0.0],
                           [3.1006800000000003e-10, 0.0, 0.0],
                           [-3.1006800000000003e-10, 0.0, 0.0],
                           [0.0, 3.1006800000000003e-10, 0.0],
                           [0.0, -3.1006800000000003e-10, 0.0]],
        'lattice_vectors': [[8.91e-10, 0.0, 0.0],
                            [0.0, 8.91e-10, 0.0],
                            [4.455e-10, 4.455e-10, 1.6120000000000002e-10]],
        'normalized_wyckoff': {'a': {'X_0': 1},
                               'h': {'X_0': 4},
                               'i': {'X_1': 4}},
        'normalized_wysytax': {'a': {'X_1': 1},
                               'h': {'X_1': 2},
                               'i': {'X_0': 4}}}],
 140: [{'Notes': '-',
        'Pearsons Symbol': 'tI12',
        'Prototype': 'Al2Cu',
        'Space Group': 'I4/mcm',
        'Space Group Number': 140,
        'Strukturbericht Designation': 'C16',
        'Wyckoff Positions': 'ah',
        'aflow_prototype_id': 'A2B_tI12_140_h_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2B_tI12_140_h_a.html',
        'atom_labels': ['Al', 'Al', 'Al', 'Al', 'Cu', 'Cu'],
        'atom_positions': [[9.5432e-11, 3.9743199999999996e-10, 0.0],
                           [2.0656800000000003e-10, 9.5432e-11, 0.0],
                           [3.9743199999999996e-10, 5.08568e-10, 0.0],
                           [5.08568e-10, 2.0656800000000003e-10, 0.0],
                           [3.02e-10, 3.02e-10, 1.215e-10],
                           [6.04e-10, 6.04e-10, 1.215e-10]],
        'lattice_vectors': [[6.04e-10, 0.0, 0.0],
                            [0.0, 6.04e-10, 0.0],
                            [3.02e-10, 3.02e-10, 2.43e-10]],
        'normalized_wyckoff': {'a': {'X_1': 1}, 'h': {'X_0': 2}},
        'normalized_wysytax': {'a': {'X_1': 2}, 'h': {'X_0': 3}}},
       {'Notes': '-',
        'Pearsons Symbol': 'tI16',
        'Prototype': 'Ir3Si',
        'Space Group': 'I4/mcm',
        'Space Group Number': 140,
        'Strukturbericht Designation': "D0'c",
        'Wyckoff Positions': 'abh',
        'aflow_prototype_id': 'AB3_tI16_140_b_ah',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB3_tI16_140_b_ah.html',
        'atom_labels': ['Si', 'Si', 'Ir', 'Ir', 'Ir', 'Ir', 'Ir', 'Ir'],
        'atom_positions': [[0.0, 0.0, 1.9885e-10],
                           [0.0, 0.0, -1.9885e-10],
                           [0.0, 2.611e-10, 1.9885e-10],
                           [2.611e-10, 0.0, 1.9885e-10],
                           [9.6607e-11, 3.57707e-10, 0.0],
                           [-9.6607e-11, 1.6449300000000002e-10, 0.0],
                           [1.6449300000000002e-10, 9.6607e-11, 0.0],
                           [3.57707e-10, -9.6607e-11, 0.0]],
        'lattice_vectors': [[5.222e-10, 0.0, 0.0],
                            [0.0, 5.222e-10, 0.0],
                            [2.611e-10, 2.611e-10, 3.977e-10]],
        'normalized_wyckoff': {'a': {'X_1': 1},
                               'b': {'X_0': 1},
                               'h': {'X_0': 2}},
        'normalized_wysytax': {'a': {'X_1': 2},
                               'b': {'X_0': 2},
                               'h': {'X_0': 3}}},
       {'Notes': 'AlKTe2',
        'Pearsons Symbol': 'tI16',
        'Prototype': 'SeTl',
        'Space Group': 'I4/mcm',
        'Space Group Number': 140,
        'Strukturbericht Designation': 'B37',
        'Wyckoff Positions': 'abh',
        'aflow_prototype_id': 'AB_tI16_140_ab_h',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_tI16_140_ab_h.html',
        'atom_labels': ['K', 'K', 'Al', 'Al', 'Te', 'Te', 'Te', 'Te'],
        'atom_positions': [[0.0, 0.0, 1.6775000000000002e-10],
                           [4.385e-10, 4.385e-10, 1.6775000000000002e-10],
                           [0.0, 4.385e-10, 1.6775000000000002e-10],
                           [4.385e-10, 0.0, 1.6775000000000002e-10],
                           [1.4417880000000002e-10, 5.826788e-10, 0.0],
                           [-1.4417880000000002e-10, 2.943212e-10, 0.0],
                           [2.943212e-10, 1.4417880000000002e-10, 0.0],
                           [5.826788e-10, -1.4417880000000002e-10, 0.0]],
        'lattice_vectors': [[8.77e-10, 0.0, 0.0],
                            [0.0, 8.77e-10, 0.0],
                            [4.385e-10, 4.385e-10, 3.3550000000000003e-10]],
        'normalized_wyckoff': {'a': {'X_1': 1},
                               'b': {'X_2': 1},
                               'h': {'X_0': 2}},
        'normalized_wysytax': {'a': {'X_1': 2},
                               'b': {'X_2': 2},
                               'h': {'X_0': 3}}},
       {'Notes': '-',
        'Pearsons Symbol': 'tI16',
        'Prototype': 'SiU3',
        'Space Group': 'I4/mcm',
        'Space Group Number': 140,
        'Strukturbericht Designation': 'D0c',
        'Wyckoff Positions': 'abh',
        'aflow_prototype_id': 'AB3_tI16_140_b_ah',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB3_tI16_140_b_ah.html',
        'atom_labels': ['Si', 'Si', 'U', 'U', 'U', 'U', 'U', 'U'],
        'atom_positions': [[3.0085000000000005e-10,
                            2.5849394142282115e-26,
                            2.1697500000000002e-10],
                           [2.5849394142282115e-26,
                            3.0085000000000005e-10,
                            2.1697500000000002e-10],
                           [0.0, 0.0, 2.1697500000000002e-10],
                           [0.0, 0.0, 6.50925e-10],
                           [1.6185730000000002e-10,
                            1.3899270000000004e-10,
                            0.0],
                           [1.6185730000000002e-10,
                            -1.3899270000000004e-10,
                            4.3395000000000004e-10],
                           [-1.6185730000000002e-10,
                            1.3899270000000004e-10,
                            4.3395e-10],
                           [1.3899270000000004e-10,
                            1.6185730000000002e-10,
                            4.3395e-10]],
        'lattice_vectors': [[-3.0085e-10, 3.0085e-10, 4.3395e-10],
                            [3.0085e-10, -3.0085e-10, 4.3395e-10],
                            [3.0085e-10, 3.0085e-10, -4.3395e-10]],
        'normalized_wyckoff': {'a': {'X_0': 1},
                               'b': {'X_1': 1},
                               'h': {'X_0': 2}},
        'normalized_wysytax': {'a': {'X_0': 2},
                               'b': {'X_1': 2},
                               'h': {'X_0': 3}}}],
 141: [{'Notes': '-',
        'Pearsons Symbol': 'tI16',
        'Prototype': 'BMo',
        'Space Group': 'I41/amd',
        'Space Group Number': 141,
        'Strukturbericht Designation': 'Bg',
        'Wyckoff Positions': 'e2',
        'aflow_prototype_id': 'AB_tI16_141_e_e',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_tI16_141_e_e.html',
        'atom_labels': ['B', 'B', 'B', 'B', 'Mo', 'Mo', 'Mo', 'Mo'],
        'atom_positions': [[0.0, 0.0, 5.973440000000001e-10],
                           [-1.5525e-10, 0.0, 1.73094e-10],
                           [1.5525e-10, 0.0, 6.75406e-10],
                           [1.5525e-10, 1.5525e-10, 2.51156e-10],
                           [0.0, 0.0, 3.32612e-10],
                           [0.0, 1.5525e-10, 7.56862e-10],
                           [0.0, -1.5525e-10, 9.1638e-11],
                           [1.5525e-10, 1.5525e-10, 5.15888e-10]],
        'lattice_vectors': [[3.105e-10, 0.0, 0.0],
                            [0.0, 3.105e-10, 0.0],
                            [1.5525e-10, 1.5525e-10, 8.485e-10]],
        'normalized_wysytax': {'e': {'X_0': 1, 'X_1': 1}}},
       {'Notes': '-',
        'Pearsons Symbol': 'tI24',
        'Prototype': 'Ga2Hf',
        'Space Group': 'I41/amd',
        'Space Group Number': 141,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'e3',
        'aflow_prototype_id': 'A2B_tI24_141_2e_e',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2B_tI24_141_2e_e.html',
        'atom_labels': ['Ga',
                        'Ga',
                        'Ga',
                        'Ga',
                        'Ga',
                        'Ga',
                        'Ga',
                        'Ga',
                        'Hf',
                        'Hf',
                        'Hf',
                        'Hf'],
        'atom_positions': [[2.0229999999999996e-10,
                            -1.0114999999999996e-10,
                            9.542249999999998e-10],
                           [2.0229999999999996e-10,
                            1.0115e-10,
                            3.1807500000000006e-10],
                           [6.462348535570529e-27,
                            1.0114999999999998e-10,
                            9.54225e-10],
                           [2.5849394142282115e-26,
                            3.034499999999999e-10,
                            3.1807499999999986e-10],
                           [2.0229999999999996e-10,
                            1.0115000000000001e-10,
                            -5.369105999999999e-10],
                           [2.023e-10,
                            -1.0114999999999998e-10,
                            5.369106000000001e-10],
                           [2.023e-10,
                            1.0114999999999998e-10,
                            -9.923939999999997e-11],
                           [3.2311742677852644e-26,
                            1.0114999999999996e-10,
                            1.3715394e-09],
                           [6.462348535570529e-27,
                            1.0114999999999998e-10,
                            1.2977459999999997e-10],
                           [0.0, 1.0115e-10, 5.063754e-10],
                           [2.0229999999999996e-10,
                            1.0115e-10,
                            7.659246000000002e-10],
                           [2.5849394142282115e-26,
                            3.034499999999999e-10,
                            -1.2977459999999997e-10]],
        'lattice_vectors': [[-2.023e-10, 2.023e-10, 1.2723e-09],
                            [2.023e-10, -2.023e-10, 1.2723e-09],
                            [2.023e-10, 2.023e-10, -1.2723e-09]],
        'normalized_wysytax': {'e': {'X_0': 7, 'X_1': 4}}},
       {'Notes': 'ordered defect spinel',
        'Pearsons Symbol': 'tI80',
        'Prototype': 'In2S3 (beta)',
        'Space Group': 'I41/amd',
        'Space Group Number': 141,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'ceh4',
        'aflow_prototype_id': 'A2B3_tI80_141_ceh_3h',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2B3_tI80_141_ceh_3h.html',
        'atom_labels': ['In',
                        'In',
                        'In',
                        'In',
                        'In',
                        'In',
                        'In',
                        'In',
                        'In',
                        'In',
                        'In',
                        'In',
                        'In',
                        'In',
                        'In',
                        'In',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [3.8086e-10, 0.0, 1.6165350000000001e-09],
                           [1.9043e-10,
                            5.712900000000001e-10,
                            8.082675000000001e-10],
                           [1.9043e-10, 1.9043e-10, 2.4248025e-09],
                           [0.0, -1.5310572e-11, 1.074672468e-09],
                           [3.8086e-10, 1.5310572e-11, 2.691207468e-09],
                           [2.0574057200000003e-10,
                            5.712900000000001e-10,
                            1.8829399680000003e-09],
                           [1.7511942800000002e-10,
                            1.9043e-10,
                            3.499474968e-09],
                           [3.8086e-10, -1.5310572e-11, 5.41862532e-10],
                           [0.0, 1.5310572e-11, -1.074672468e-09],
                           [1.7511942800000002e-10,
                            5.712900000000001e-10,
                            -2.66404968e-10],
                           [2.0574057200000003e-10,
                            1.9043e-10,
                            1.350130032e-09],
                           [0.0, 1.9043e-10, 6.608395080000001e-10],
                           [0.0, 5.712900000000001e-10, 1.469107008e-09],
                           [3.8086e-10, 1.9043e-10, 9.556954920000002e-10],
                           [3.8086e-10, 5.712900000000001e-10, 1.47427992e-10],
                           [0.0, -1.218752e-11, 7.94365299e-10],
                           [3.8086e-10, 1.218752e-11, 2.410900299e-09],
                           [2.0261752e-10,
                            5.712900000000001e-10,
                            1.602632799e-09],
                           [1.7824248e-10, 1.9043e-10, 3.219167799e-09],
                           [3.8086e-10, -1.218752e-11, 8.22169701e-10],
                           [0.0, 1.218752e-11, -7.94365299e-10],
                           [1.7824248e-10,
                            5.712900000000001e-10,
                            1.3902201000000001e-11],
                           [2.0261752e-10, 1.9043e-10, 1.6304372010000003e-09],
                           [0.0, 4.57032e-12, 2.77720713e-10],
                           [3.8086e-10, -4.57032e-12, 1.894255713e-09],
                           [1.8585968e-10,
                            5.712900000000001e-10,
                            1.0859882130000002e-09],
                           [1.9500032e-10, 1.9043e-10, 2.702523213e-09],
                           [3.8086e-10, 4.57032e-12, 1.338814287e-09],
                           [0.0, -4.57032e-12, -2.77720713e-10],
                           [1.9500032e-10,
                            5.712900000000001e-10,
                            5.30546787e-10],
                           [1.8585968e-10, 1.9043e-10, 2.1470817870000003e-09],
                           [0.0, 2.5365276e-11, 1.346250348e-09],
                           [3.8086e-10, -2.5365276e-11, 2.962785348e-09],
                           [1.65064724e-10,
                            5.712900000000001e-10,
                            2.154517848e-09],
                           [2.1579527600000003e-10,
                            1.9043e-10,
                            3.771052848e-09],
                           [3.8086e-10, 2.5365276e-11, 2.70284652e-10],
                           [0.0, -2.5365276e-11, -1.346250348e-09],
                           [2.1579527600000003e-10,
                            5.712900000000001e-10,
                            -5.37982848e-10],
                           [1.65064724e-10, 1.9043e-10, 1.078552152e-09]],
        'lattice_vectors': [[7.6172e-10, 0.0, 0.0],
                            [0.0, 7.6172e-10, 0.0],
                            [3.8086e-10, 3.8086e-10, 1.6165350000000001e-09]],
        'normalized_wysytax': {'c': {'X_1': 3},
                               'e': {'X_1': 4},
                               'h': {'X_0': 18, 'X_1': 6}}},
       {'Notes': '-',
        'Pearsons Symbol': 'tI28',
        'Prototype': 'Mn3O4',
        'Space Group': 'I41/amd',
        'Space Group Number': 141,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'adh',
        'aflow_prototype_id': 'A3B4_tI28_141_ad_h',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A3B4_tI28_141_ad_h.html',
        'atom_labels': ['Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'O',
                        'O',
                        'O',
                        'O',
                        'O',
                        'O',
                        'O',
                        'O'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [0.0, 2.875e-10, 2.355e-10],
                           [2.875e-10, -1.4375e-10, 1.1775e-10],
                           [2.875e-10, 1.4375e-10, 1.1775e-10],
                           [-1.4375e-10, -2.875e-10, -1.1775e-10],
                           [1.4375e-10, -2.875e-10, -1.1775e-10],
                           [-2.875e-10, -1.44325e-10, -1.15866e-10],
                           [0.0, 4.31825e-10, 3.5513400000000003e-10],
                           [1.44325e-10, 0.0, 1.1963400000000001e-10],
                           [-1.44325e-10, 0.0, 1.1963400000000001e-10],
                           [0.0, -1.44325e-10, -1.1963400000000001e-10],
                           [0.0, 1.44325e-10, -1.1963400000000001e-10],
                           [-1.44325e-10, 2.875e-10, 1.15866e-10],
                           [1.44325e-10, 2.875e-10, 1.15866e-10]],
        'lattice_vectors': [[5.75e-10, 0.0, 0.0],
                            [0.0, 5.75e-10, 0.0],
                            [2.875e-10, 2.875e-10, 4.71e-10]],
        'normalized_wyckoff': {'a': {'X_1': 1},
                               'd': {'X_1': 2},
                               'h': {'X_0': 4}},
        'normalized_wysytax': {'a': {'X_1': 2},
                               'd': {'X_1': 3},
                               'h': {'X_0': 6}}},
       {'Notes': '40',
        'Pearsons Symbol': 'tI8',
        'Prototype': 'NbP',
        'Space Group': 'I41/amd',
        'Space Group Number': 141,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'ab',
        'aflow_prototype_id': 'AB_tI8_141_a_b',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_tI8_141_a_b.html',
        'atom_labels': ['Nb', 'Nb', 'P', 'P'],
        'atom_positions': [[1.6625e-10, 2.49375e-10, 4.2675000000000005e-10],
                           [3.3249999999999994e-10,
                            2.49375e-10,
                            1.4225000000000003e-10],
                           [1.6625e-10, 8.3125e-11, 1.4225000000000003e-10],
                           [3.325e-10,
                            4.1562499999999995e-10,
                            4.2675000000000005e-10]],
        'lattice_vectors': [[3.325e-10, 0.0, 0.0],
                            [0.0, 3.325e-10, 0.0],
                            [1.6625e-10, 1.6625e-10, 5.69e-10]],
        'normalized_wyckoff': {'a': {'X_0': 1}, 'b': {'X_1': 1}},
        'normalized_wysytax': {'a': {'X_0': 1}, 'b': {'X_1': 1}}},
       {'Notes': 'zircon',
        'Pearsons Symbol': 'tI24',
        'Prototype': 'O4SiZr',
        'Space Group': 'I41/amd',
        'Space Group Number': 141,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'abh',
        'aflow_prototype_id': 'A4BC_tI24_141_h_b_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A4BC_tI24_141_h_b_a.html',
        'atom_labels': ['Zr',
                        'Zr',
                        'Si',
                        'Si',
                        'O',
                        'O',
                        'O',
                        'O',
                        'O',
                        'O',
                        'O',
                        'O'],
        'atom_positions': [[0.0, -1.65175e-10, 7.477500000000001e-11],
                           [0.0, 1.65175e-10, -7.477500000000001e-11],
                           [-3.3035e-10, -1.65175e-10, -7.477500000000001e-11],
                           [3.3035e-10, 1.65175e-10, 7.477500000000001e-11],
                           [0.0, 4.367227e-11, 1.1682846000000001e-10],
                           [0.0, 2.8667773e-10, 1.1682846000000001e-10],
                           [-2.0884727000000002e-10,
                            1.65175e-10,
                            -3.272154e-11],
                           [2.0884727000000002e-10, 1.65175e-10, -3.272154e-11],
                           [0.0, -4.367227e-11, -1.1682846000000001e-10],
                           [0.0, -2.8667773e-10, -1.1682846000000001e-10],
                           [2.0884727000000002e-10, -1.65175e-10, 3.272154e-11],
                           [-2.0884727000000002e-10,
                            -1.65175e-10,
                            3.272154e-11]],
        'lattice_vectors': [[6.607e-10, 0.0, 0.0],
                            [0.0, 6.607e-10, 0.0],
                            [3.3035e-10, 3.3035e-10, 2.9910000000000003e-10]],
        'normalized_wyckoff': {'a': {'X_1': 1},
                               'b': {'X_2': 1},
                               'h': {'X_0': 4}},
        'normalized_wysytax': {'a': {'X_1': 1},
                               'b': {'X_2': 1},
                               'h': {'X_0': 3}}},
       {'Notes': 'anatase',
        'Pearsons Symbol': 'tI12',
        'Prototype': 'O2Ti',
        'Space Group': 'I41/amd',
        'Space Group Number': 141,
        'Strukturbericht Designation': 'C5',
        'Wyckoff Positions': 'ae',
        'aflow_prototype_id': 'A2B_tI12_141_e_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2B_tI12_141_e_a.html',
        'atom_labels': ['O', 'O', 'O', 'O', 'Ti', 'Ti'],
        'atom_positions': [[1.8925e-10,
                            9.462499999999997e-11,
                            -3.990171600000002e-11],
                           [-6.462348535570529e-27,
                            9.4625e-11,
                            1.9794828400000002e-10],
                           [1.8925e-10,
                            9.462499999999998e-11,
                            2.7775171599999993e-10],
                           [0.0, 9.4625e-11, 5.15601716e-10],
                           [1.8925e-10,
                            -9.462499999999998e-11,
                            3.5677500000000004e-10],
                           [0.0,
                            2.8387499999999996e-10,
                            1.1892499999999998e-10]],
        'lattice_vectors': [[-1.8925e-10, 1.8925e-10, 4.757e-10],
                            [1.8925e-10, -1.8925e-10, 4.757e-10],
                            [1.8925e-10, 1.8925e-10, -4.757e-10]],
        'normalized_wysytax': {'a': {'X_1': 1}, 'e': {'X_0': 2}}},
       {'Notes': 'white (beta) tin',
        'Pearsons Symbol': 'tI4',
        'Prototype': 'Sn',
        'Space Group': 'I41/amd',
        'Space Group Number': 141,
        'Strukturbericht Designation': 'A5',
        'Wyckoff Positions': 'a',
        'aflow_prototype_id': 'A_tI4_141_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_tI4_141_a.html',
        'atom_labels': ['Sn', 'Sn'],
        'atom_positions': [[0.0, -1.458e-10, 3.9765000000000004e-11],
                           [0.0, 1.458e-10, -3.9765000000000004e-11]],
        'lattice_vectors': [[5.832e-10, 0.0, 0.0],
                            [0.0, 5.832e-10, 0.0],
                            [2.916e-10, 2.916e-10, 1.5906000000000002e-10]],
        'normalized_wyckoff': {'a': {'X_0': 1}},
        'normalized_wysytax': {'a': {'X_0': 1}}}],
 142: [{'Notes': '-',
        'Pearsons Symbol': 'tI96',
        'Prototype': 'PPrS4',
        'Space Group': 'I41/acd',
        'Space Group Number': 142,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'abeg',
        'aflow_prototype_id': 'ABC4_tI96_142_e_ab_2g',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/ABC4_tI96_142_e_ab_2g.html',
        'atom_labels': ['Pr',
                        'Pr',
                        'Pr',
                        'Pr',
                        'Pr',
                        'Pr',
                        'Pr',
                        'Pr',
                        'P',
                        'P',
                        'P',
                        'P',
                        'P',
                        'P',
                        'P',
                        'P',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S'],
        'atom_positions': [[-5.457e-10, -2.7285e-10, -2.420125e-10],
                           [5.457e-10, 2.7285e-10, 2.420125e-10],
                           [0.0, -2.7285e-10, 2.420125e-10],
                           [0.0, 2.7285e-10, -2.420125e-10],
                           [5.457e-10, -2.7285e-10, 2.420125e-10],
                           [0.0, -2.7285e-10, -2.420125e-10],
                           [-5.457e-10, 2.7285e-10, -2.420125e-10],
                           [0.0, 2.7285e-10, 2.420125e-10],
                           [-2.7285e-10, -3.137775e-10, 0.0],
                           [2.7285e-10, -2.319225e-10, 0.0],
                           [5.866275e-10, 5.457e-10, 4.84025e-10],
                           [5.047725e-10, 0.0, 4.84025e-10],
                           [2.7285e-10, 3.137775e-10, 0.0],
                           [-2.7285e-10, 2.319225e-10, 0.0],
                           [-4.09275e-11, 0.0, 4.84025e-10],
                           [4.09275e-11, 5.457e-10, 4.84025e-10],
                           [-2.7481452000000003e-10,
                            -1.9677942e-10,
                            -1.6785987000000002e-10],
                           [2.7481452000000003e-10,
                            -3.4892058e-10,
                            -1.6785987000000002e-10],
                           [4.6962942e-10, 5.4373548e-10, 3.1616513e-10],
                           [6.2177058e-10, 1.96452e-12, 3.1616513e-10],
                           [-2.7088548e-10,
                            -1.9677942e-10,
                            1.6785987000000002e-10],
                           [2.7088548e-10,
                            -3.4892058e-10,
                            1.6785987000000002e-10],
                           [7.607058e-11, -5.4766452e-10, -3.1616513e-10],
                           [-7.607058e-11, 1.96452e-12, -3.1616513e-10],
                           [2.7481452000000003e-10,
                            1.9677942e-10,
                            1.6785987000000002e-10],
                           [-2.7481452000000003e-10,
                            3.4892058e-10,
                            1.6785987000000002e-10],
                           [-4.6962942e-10, -5.4373548e-10, -3.1616513e-10],
                           [-6.2177058e-10, -1.96452e-12, -3.1616513e-10],
                           [2.7088548e-10,
                            1.9677942e-10,
                            -1.6785987000000002e-10],
                           [-2.7088548e-10,
                            3.4892058e-10,
                            -1.6785987000000002e-10],
                           [-7.607058e-11, 5.4766452e-10, 3.1616513e-10],
                           [7.607058e-11, -1.96452e-12, 3.1616513e-10],
                           [-4.4496377999999997e-10,
                            -4.2379062000000006e-10,
                            4.84025e-12],
                           [4.4496377999999997e-10,
                            -1.2190938e-10,
                            4.84025e-12],
                           [1.5094062e-10,
                            -1.7211378e-10,
                            -4.791847500000001e-10],
                           [-1.5094062e-10,
                            -3.7358622e-10,
                            -4.791847500000001e-10],
                           [-1.0073622000000001e-10,
                            -4.2379062000000006e-10,
                            -4.84025e-12],
                           [1.0073622000000001e-10,
                            -1.2190938e-10,
                            -4.84025e-12],
                           [3.9475938e-10,
                            -1.7211378e-10,
                            4.791847500000001e-10],
                           [6.9664062e-10,
                            7.1781378e-10,
                            4.791847500000001e-10],
                           [4.4496377999999997e-10,
                            4.2379062000000006e-10,
                            -4.84025e-12],
                           [-4.4496377999999997e-10,
                            1.2190938e-10,
                            -4.84025e-12],
                           [-1.5094062e-10,
                            1.7211378e-10,
                            4.791847500000001e-10],
                           [1.5094062e-10,
                            3.7358622e-10,
                            4.791847500000001e-10],
                           [1.0073622000000001e-10,
                            4.2379062000000006e-10,
                            4.84025e-12],
                           [-1.0073622000000001e-10,
                            1.2190938e-10,
                            4.84025e-12],
                           [-3.9475938e-10,
                            1.7211378e-10,
                            -4.791847500000001e-10],
                           [-6.9664062e-10,
                            -7.1781378e-10,
                            -4.791847500000001e-10]],
        'lattice_vectors': [[1.0914e-09, 0.0, 0.0],
                            [0.0, 1.0914e-09, 0.0],
                            [5.457e-10, 5.457e-10, 9.6805e-10]],
        'normalized_wysytax': {'a': {'X_1': 1},
                               'b': {'X_1': 1},
                               'e': {'X_2': 1},
                               'g': {'X_0': 4}}}],
 147: [{'Notes': '-',
        'Pearsons Symbol': 'hP9',
        'Prototype': 'AgZn (eta)',
        'Space Group': 'P3',
        'Space Group Number': 147,
        'Strukturbericht Designation': 'Bb',
        'Wyckoff Positions': 'adg',
        'aflow_prototype_id': 'A2B_hP9_147_g_ad',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2B_hP9_147_g_ad.html',
        'atom_labels': ['Zn', 'Zn', 'Zn', 'Ag', 'Ag', 'Ag', 'Ag', 'Ag', 'Ag'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [3.818e-10,
                            2.2043237699999998e-10,
                            2.1147749999999998e-10],
                           [3.818e-10,
                            -2.2043237699999998e-10,
                            -2.1147749999999998e-10],
                           [1.458476e-10,
                            -2.10292446e-10,
                            2.1147749999999998e-10],
                           [1.0919479999999999e-10,
                            2.3145395e-10,
                            2.1147749999999998e-10],
                           [-2.550424e-10,
                            -2.1161504e-11,
                            2.1147749999999998e-10],
                           [-1.458476e-10,
                            2.10292446e-10,
                            -2.1147749999999998e-10],
                           [-1.0919479999999999e-10,
                            -2.3145395e-10,
                            -2.1147749999999998e-10],
                           [2.550424e-10,
                            2.1161504e-11,
                            -2.1147749999999998e-10]],
        'lattice_vectors': [[3.818e-10, -6.61297e-10, 0.0],
                            [3.818e-10, 6.61297e-10, 0.0],
                            [0.0, 0.0, 2.8197e-10]],
        'normalized_wyckoff': {'a': {'X_1': 1},
                               'd': {'X_1': 2},
                               'g': {'X_0': 6}},
        'normalized_wysytax': {'a': {'X_1': 1},
                               'd': {'X_1': 2},
                               'g': {'X_0': 6}}}],
 148: [{'Notes': '-',
        'Pearsons Symbol': 'hR26',
        'Prototype': 'AlPd',
        'Space Group': 'R3',
        'Space Group Number': 148,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'abf4',
        'aflow_prototype_id': 'AB_hR26_148_b2f_a2f',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_hR26_148_b2f_a2f.html',
        'atom_labels': ['Al',
                        'Pd',
                        'Al',
                        'Al',
                        'Al',
                        'Al',
                        'Al',
                        'Al',
                        'Pd',
                        'Pd',
                        'Pd',
                        'Pd',
                        'Pd',
                        'Pd',
                        'Al',
                        'Al',
                        'Al',
                        'Al',
                        'Al',
                        'Al',
                        'Pd',
                        'Pd',
                        'Pd',
                        'Pd',
                        'Pd',
                        'Pd'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [-0.0, -0.0, 2.6255000000000004e-10],
                           [2.2830822e-10, -9.2486646e-11, 8.700907e-11],
                           [-3.4058325e-11, 2.43964041e-10, 8.700907e-11],
                           [-1.9424989500000002e-10,
                            -1.51477395e-10,
                            8.700907e-11],
                           [-2.2830822e-10, 9.2486646e-11, -8.700907e-11],
                           [3.4058325e-11, -2.43964041e-10, -8.700907e-11],
                           [1.9424989500000002e-10,
                            1.51477395e-10,
                            -8.700907e-11],
                           [2.2658573e-10, -9.1401759e-11, -1.7564595e-10],
                           [-3.4136620000000005e-11,
                            2.41929878e-10,
                            -1.7564595e-10],
                           [-1.9244911e-10, -1.50528119e-10, -1.7564595e-10],
                           [-2.2658573e-10, 9.1401759e-11, 1.7564595e-10],
                           [3.4136620000000005e-11,
                            -2.41929878e-10,
                            1.7564595e-10],
                           [1.9244911e-10, 1.50528119e-10, 1.7564595e-10],
                           [3.15450555e-10,
                            -3.2153348600000004e-10,
                            -8.585385e-11],
                           [1.2073089e-10,
                            4.3395493700000004e-10,
                            -8.585385e-11],
                           [-4.36181445e-10,
                            -1.1242145100000001e-10,
                            -8.585385e-11],
                           [-3.15450555e-10,
                            3.2153348600000004e-10,
                            8.585385e-11],
                           [-1.2073089e-10,
                            -4.3395493700000004e-10,
                            8.585385e-11],
                           [4.36181445e-10,
                            1.1242145100000001e-10,
                            8.585385e-11],
                           [-4.67656035e-10, 1.31316572e-10, 9.27677e-13],
                           [1.2010453000000002e-10,
                            -4.70660293e-10,
                            9.27677e-13],
                           [3.47551505e-10, 3.3934372e-10, 9.27677e-13],
                           [4.67656035e-10, -1.31316572e-10, -9.27677e-13],
                           [-1.2010453000000002e-10,
                            4.70660293e-10,
                            -9.27677e-13],
                           [-3.47551505e-10, -3.3934372e-10, -9.27677e-13]],
        'lattice_vectors': [[0.0, 9.040727860000001e-10, 1.75033333e-10],
                            [-7.829500000000001e-10,
                             -4.5203639300000005e-10,
                             1.75033333e-10],
                            [7.829500000000001e-10,
                             -4.5203639300000005e-10,
                             1.75033333e-10]],
        'normalized_wyckoff': {'a': {'X_0': 1},
                               'b': {'X_1': 1},
                               'f': {'X_0': 12, 'X_1': 12}},
        'normalized_wysytax': {'a': {'X_0': 1}, 'f': {'X_0': 4, 'X_1': 4}}},
       {'Notes': '-',
        'Pearsons Symbol': 'hR8',
        'Prototype': 'BiI3',
        'Space Group': 'R3',
        'Space Group Number': 148,
        'Strukturbericht Designation': 'D05',
        'Wyckoff Positions': 'cf',
        'aflow_prototype_id': 'AB3_hR8_148_c_f',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB3_hR8_148_c_f.html',
        'atom_labels': ['Bi', 'Bi', 'I', 'I', 'I', 'I', 'I', 'I'],
        'atom_positions': [[0.0, 0.0, 6.894078e-10],
                           [0.0, 0.0, -6.894078e-10],
                           [-1.24812672e-10,
                            -2.1618188900000002e-10,
                            1.82003661e-10],
                           [2.49625344e-10, 0.0, 1.82003661e-10],
                           [-1.24812672e-10,
                            2.1618188900000002e-10,
                            1.82003661e-10],
                           [1.24812672e-10,
                            2.1618188900000002e-10,
                            -1.82003661e-10],
                           [-2.49625344e-10, 0.0, -1.82003661e-10],
                           [1.24812672e-10,
                            -2.1618188900000002e-10,
                            -1.82003661e-10]],
        'lattice_vectors': [[0.0, 4.32796575e-10, 6.89407807e-10],
                            [-3.74812829e-10, -2.16398287e-10, 6.89407807e-10],
                            [3.74812829e-10, -2.16398287e-10, 6.89407807e-10]],
        'normalized_wyckoff': {'c': {'X_1': 1}, 'f': {'X_0': 3}},
        'normalized_wysytax': {'c': {'X_0': 1}, 'f': {'X_1': 1}}},
       {'Notes': 'solid cubane',
        'Pearsons Symbol': 'hR16',
        'Prototype': 'C8H8',
        'Space Group': 'R3',
        'Space Group Number': 148,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'c2f2',
        'aflow_prototype_id': 'AB_hR16_148_cf_cf',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_hR16_148_cf_cf.html',
        'atom_labels': ['C',
                        'C',
                        'H',
                        'H',
                        'C',
                        'C',
                        'C',
                        'C',
                        'C',
                        'C',
                        'H',
                        'H',
                        'H',
                        'H',
                        'H',
                        'H'],
        'atom_positions': [[0.0, 0.0, 1.35476795e-10],
                           [0.0, 0.0, -1.35476795e-10],
                           [0.0, 0.0, 2.46406782e-10],
                           [0.0, 0.0, -2.46406782e-10],
                           [-2.7748323000000002e-11,
                            -1.22970486e-10,
                            4.5033773e-11],
                           [1.20369727e-10,
                            3.7454490000000004e-11,
                            4.5033773e-11],
                           [-9.2621403e-11,
                            8.551599600000001e-11,
                            4.5033773e-11],
                           [2.7748323000000002e-11,
                            1.22970486e-10,
                            -4.5033773e-11],
                           [-1.20369727e-10,
                            -3.7454490000000004e-11,
                            -4.5033773e-11],
                           [9.2621403e-11,
                            -8.551599600000001e-11,
                            -4.5033773e-11],
                           [-5.100679e-11,
                            -2.1464891300000002e-10,
                            8.0962228e-11],
                           [2.1139480700000002e-10,
                            6.3151281e-11,
                            8.0962228e-11],
                           [-1.6038801700000001e-10,
                            1.51497632e-10,
                            8.0962228e-11],
                           [5.100679e-11,
                            2.1464891300000002e-10,
                            -8.0962228e-11],
                           [-2.1139480700000002e-10,
                            -6.3151281e-11,
                            -8.0962228e-11],
                           [1.6038801700000001e-10,
                            -1.51497632e-10,
                            -8.0962228e-11]],
        'lattice_vectors': [[0.0, 3.63565232e-10, 3.91121876e-10],
                            [-3.14856727e-10, -1.81782616e-10, 3.91121876e-10],
                            [3.14856727e-10, -1.81782616e-10, 3.91121876e-10]],
        'normalized_wyckoff': {'c': {'X_0': 1, 'X_1': 1},
                               'f': {'X_0': 3, 'X_1': 3}},
        'normalized_wysytax': {'c': {'X_0': 1, 'X_1': 1},
                               'f': {'X_0': 1, 'X_1': 1}}},
       {'Notes': 'ilmenite',
        'Pearsons Symbol': 'hR10',
        'Prototype': 'FeO3Ti',
        'Space Group': 'R3',
        'Space Group Number': 148,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'c2f',
        'aflow_prototype_id': 'AB3C_hR10_148_c_f_c',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB3C_hR10_148_c_f_c.html',
        'atom_labels': ['Fe', 'Fe', 'Ti', 'Ti', 'O', 'O', 'O', 'O', 'O', 'O'],
        'atom_positions': [[0.0, 0.0, 5.042432790000001e-10],
                           [0.0, 0.0, -5.042432790000001e-10],
                           [0.0, 0.0, 2.00007111e-10],
                           [0.0, 0.0, -2.00007111e-10],
                           [6.994843100000001e-11,
                            1.34371062e-10,
                            3.52125195e-10],
                           [-1.51342968e-10,
                            -6.608413000000001e-12,
                            3.52125195e-10],
                           [8.139453800000001e-11,
                            -1.27762649e-10,
                            3.52125195e-10],
                           [-6.994843100000001e-11,
                            -1.34371062e-10,
                            -3.52125195e-10],
                           [1.51342968e-10,
                            6.608413000000001e-12,
                            -3.52125195e-10],
                           [-8.139453800000001e-11,
                            1.27762649e-10,
                            -3.52125195e-10]],
        'lattice_vectors': [[0.0, 2.9370724e-10, 4.6950026e-10],
                            [-2.5435793e-10, -1.4685362e-10, 4.6950026e-10],
                            [2.5435793e-10, -1.4685362e-10, 4.6950026e-10]],
        'normalized_wyckoff': {'c': {'X_1': 1, 'X_2': 1}, 'f': {'X_0': 3}},
        'normalized_wysytax': {'c': {'X_0': 1, 'X_1': 1}, 'f': {'X_2': 1}}}],
 150: [{'Notes': 'original structure',
        'Pearsons Symbol': 'hP9',
        'Prototype': 'Fe2P',
        'Space Group': 'P321',
        'Space Group Number': 150,
        'Strukturbericht Designation': 'C22',
        'Wyckoff Positions': 'bdef',
        'aflow_prototype_id': 'A2B_hP9_150_ef_bd',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2B_hP9_150_ef_bd.html',
        'atom_labels': ['Fe', 'Fe', 'Fe', 'Fe', 'Fe', 'Fe', 'P', 'P', 'P'],
        'atom_positions': [[7.522560000000001e-11, 1.3029456122985345e-10, 0.0],
                           [7.522560000000001e-11,
                            -1.3029456122985345e-10,
                            0.0],
                           [4.3724880000000005e-10, 0.0, 0.0],
                           [1.7307765e-10,
                            2.997792834546237e-10,
                            1.7185000000000003e-10],
                           [2.415447e-10, 0.0, 1.7185000000000003e-10],
                           [1.7307765e-10,
                            -2.997792834546237e-10,
                            1.7185000000000003e-10],
                           [0.0, 0.0, 1.7185000000000003e-10],
                           [2.938500000000001e-10, 1.6965437660137511e-10, 0.0],
                           [2.938500000000001e-10,
                            -1.6965437660137511e-10,
                            0.0]],
        'lattice_vectors': [[2.9385e-10, -5.08963129804115e-10, 0.0],
                            [2.9385e-10, 5.08963129804115e-10, 0.0],
                            [0.0, 0.0, 3.437e-10]]}],
 151: [{'Notes': '-',
        'Pearsons Symbol': 'hP24',
        'Prototype': 'CrCl3',
        'Space Group': 'P3112',
        'Space Group Number': 151,
        'Strukturbericht Designation': 'D04',
        'Wyckoff Positions': 'a2c3',
        'aflow_prototype_id': 'A3B_hP24_151_3c_2a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A3B_hP24_151_3c_2a.html',
        'atom_labels': ['Cr',
                        'Cr',
                        'Cr',
                        'Cr',
                        'Cr',
                        'Cr',
                        'Cl',
                        'Cl',
                        'Cl',
                        'Cl',
                        'Cl',
                        'Cl',
                        'Cl',
                        'Cl',
                        'Cl',
                        'Cl',
                        'Cl',
                        'Cl',
                        'Cl',
                        'Cl',
                        'Cl',
                        'Cl',
                        'Cl',
                        'Cl'],
        'atom_positions': [[0.0, 2.30940105e-10, 5.76666661e-10],
                           [-1.99999998e-10, -1.15470053e-10, 1.153333339e-09],
                           [1.99999998e-10, -1.15470053e-10, 0.0],
                           [0.0, -4.6188021e-10, 5.76666661e-10],
                           [3.99999999e-10,
                            2.3094011000000003e-10,
                            1.153333339e-09],
                           [-3.99999999e-10, 2.3094011000000003e-10, 0.0],
                           [1.99999998e-10,
                            -1.15470053e-10,
                            -4.4980000000000004e-10],
                           [0.0, 2.30940105e-10, 1.26866661e-10],
                           [-1.99999998e-10, -1.15470053e-10, 7.03533339e-10],
                           [-1.99999998e-10, -1.15470053e-10, 1.603133339e-09],
                           [0.0, 2.30940105e-10, 1.026466661e-09],
                           [1.99999998e-10,
                            -1.15470053e-10,
                            4.4980000000000004e-10],
                           [-9.9999999e-11,
                            -2.8867513200000004e-10,
                            -4.4980000000000004e-10],
                           [3e-10, 5.7735032e-11, 1.26866661e-10],
                           [-2.00000001e-10,
                            2.3094011000000003e-10,
                            7.03533339e-10],
                           [9.9999999e-11,
                            -2.8867513200000004e-10,
                            1.603133339e-09],
                           [-3e-10, 5.7735032e-11, 1.026466661e-09],
                           [2.00000001e-10,
                            2.3094011000000003e-10,
                            4.4980000000000004e-10],
                           [-9.9999999e-11,
                            5.7735026000000004e-11,
                            -4.4980000000000004e-10],
                           [0.0, -1.15470053e-10, 1.26866661e-10],
                           [9.9999999e-11,
                            5.7735026000000004e-11,
                            7.03533339e-10],
                           [9.9999999e-11,
                            5.7735026000000004e-11,
                            1.603133339e-09],
                           [0.0, -1.15470053e-10, 1.026466661e-09],
                           [-9.9999999e-11,
                            5.7735026000000004e-11,
                            4.4980000000000004e-10]],
        'lattice_vectors': [[3e-10, -5.19615242e-10, 0.0],
                            [3e-10, 5.19615242e-10, 0.0],
                            [0.0, 0.0, 1.7300000000000002e-09]],
        'normalized_wyckoff': {'a': {'X_1': 1}, 'c': {'X_0': 3}},
        'normalized_wysytax': {'a': {'X_1': 1}, 'c': {'X_0': 3}}}],
 152: [{'Notes': '-',
        'Pearsons Symbol': 'hP3',
        'Prototype': 'Se (gamma)',
        'Space Group': 'P3121',
        'Space Group Number': 152,
        'Strukturbericht Designation': 'A8',
        'Wyckoff Positions': 'a',
        'aflow_prototype_id': 'A_hP3_152_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_hP3_152_a.html',
        'atom_labels': ['Se', 'Se', 'Se'],
        'atom_positions': [[4.73583e-11, -8.2026982e-11, 1.70333333e-10],
                           [4.73583e-11, 8.2026982e-11, 3.40666667e-10],
                           [-9.47166e-11, 0.0, 0.0]],
        'lattice_vectors': [[1.9050000000000001e-10, -3.29955679e-10, 0.0],
                            [1.9050000000000001e-10, 3.29955679e-10, 0.0],
                            [0.0, 0.0, 5.110000000000001e-10]],
        'normalized_wyckoff': {'a': {'X_0': 1}},
        'normalized_wysytax': {'b': {'X_0': 1}}},
       {'Notes': 'low quartz',
        'Pearsons Symbol': 'hP9',
        'Prototype': 'O2Si (alpha)',
        'Space Group': 'P3121',
        'Space Group Number': 152,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'ac',
        'aflow_prototype_id': 'A2B_hP9_152_c_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2B_hP9_152_c_a.html',
        'atom_labels': ['O', 'O', 'O', 'O', 'O', 'O', 'Si', 'Si', 'Si'],
        'atom_positions': [[2.1606858e-10,
                            2.4980658656736393e-10,
                            2.447116000001802e-10],
                           [1.6702686e-10,
                            6.221758595596016e-11,
                            4.2491160000000003e-10],
                           [1.6702686e-10,
                            -6.221758595596016e-11,
                            1.1568839999999998e-10],
                           [3.5400455999999996e-10,
                            1.1354071089637594e-10,
                            6.45115999998198e-11],
                           [2.1606858e-10,
                            -2.4980658656736393e-10,
                            2.958883999998198e-10],
                           [3.5400455999999996e-10,
                            -1.1354071089637594e-10,
                            4.760884000001802e-10],
                           [1.1545442999999998e-10,
                            1.9997293871891703e-10,
                            3.604000000001802e-10],
                           [1.1545442999999998e-10,
                            -1.9997293871891703e-10,
                            1.8019999999981979e-10],
                           [2.6049113999999996e-10, 0.0, 0.0]],
        'lattice_vectors': [[2.457e-10, -4.255648834197e-10, 0.0],
                            [2.457e-10, 4.255648834197e-10, 0.0],
                            [0.0, 0.0, 5.406e-10]],
        'normalized_wyckoff': {'b': {'X_1': 1}, 'c': {'X_0': 2}},
        'normalized_wysytax': {'a': {'X_1': 1}, 'c': {'X_0': 2}}}],
 154: [{'Notes': 'cinnabar',
        'Pearsons Symbol': 'hP6',
        'Prototype': 'HgS',
        'Space Group': 'P3221',
        'Space Group Number': 154,
        'Strukturbericht Designation': 'B9',
        'Wyckoff Positions': 'ab',
        'aflow_prototype_id': 'AB_hP6_154_a_b',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_hP6_154_a_b.html',
        'atom_labels': ['Hg', 'Hg', 'Hg', 'S', 'S', 'S'],
        'atom_positions': [[1.4917855000000002e-10,
                            2.583848279994183e-10,
                            3.1653333333333013e-10],
                           [1.1614290000000002e-10, 0.0, 0.0],
                           [1.4917855000000002e-10,
                            -2.583848279994183e-10,
                            6.330666666666698e-10],
                           [1.0132452500000001e-10,
                            1.7549922535275854e-10,
                            7.9133333333333e-10],
                           [1.0132452500000001e-10,
                            -1.7549922535275854e-10,
                            1.5826666666666982e-10],
                           [2.1185095000000002e-10, 0.0, 4.748e-10]],
        'lattice_vectors': [[2.0725e-10, -3.589675298686e-10, 0.0],
                            [2.0725e-10, 3.589675298686e-10, 0.0],
                            [0.0, 0.0, 9.496e-10]],
        'normalized_wyckoff': {'a': {'X_0': 1}, 'b': {'X_1': 1}},
        'normalized_wysytax': {'a': {'X_0': 1}, 'b': {'X_1': 1}}}],
 155: [{'Notes': '-',
        'Pearsons Symbol': 'hR8',
        'Prototype': 'AlF3',
        'Space Group': 'R32',
        'Space Group Number': 155,
        'Strukturbericht Designation': 'D014',
        'Wyckoff Positions': 'cde',
        'aflow_prototype_id': 'AB3_hR8_155_c_de',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB3_hR8_155_c_de.html',
        'atom_labels': ['Al', 'Al', 'F', 'F', 'F', 'F', 'F', 'F'],
        'atom_positions': [[0.0, 0.0, 2.95178198e-10],
                           [0.0, 0.0, -2.95178198e-10],
                           [1.05690318e-10, 1.8306100100000001e-10, 0.0],
                           [-2.11380636e-10, 0.0, 0.0],
                           [1.05690318e-10, -1.8306100100000001e-10, 0.0],
                           [1.40101119e-10,
                            -4.1153248e-11,
                            2.0757960500000002e-10],
                           [-3.4410801000000004e-11,
                            1.4190775300000002e-10,
                            2.0757960500000002e-10],
                           [-1.05690318e-10,
                            -1.0075450399999999e-10,
                            2.0757960500000002e-10]],
        'lattice_vectors': [[2.45791437e-10,
                             -1.4190775300000002e-10,
                             4.1515920900000005e-10],
                            [0.0,
                             2.8381550500000004e-10,
                             4.1515920900000005e-10],
                            [-2.45791437e-10,
                             -1.4190775300000002e-10,
                             4.1515920900000005e-10]],
        'normalized_wyckoff': {'c': {'X_1': 2},
                               'd': {'X_0': 3},
                               'e': {'X_0': 3}},
        'normalized_wysytax': {'c': {'X_0': 2},
                               'd': {'X_1': 1},
                               'e': {'X_1': 1}}},
       {'Notes': '-',
        'Pearsons Symbol': 'hR5',
        'Prototype': 'Ni3S2',
        'Space Group': 'R32',
        'Space Group Number': 155,
        'Strukturbericht Designation': 'D5e',
        'Wyckoff Positions': 'ce',
        'aflow_prototype_id': 'A3B2_hR5_155_e_c',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A3B2_hR5_155_e_c.html',
        'atom_labels': ['S', 'S', 'Ni', 'Ni', 'Ni'],
        'atom_positions': [[0.0, 0.0, 1.7946999e-10],
                           [0.0, 0.0, -1.7946999e-10],
                           [-7.3098905e-11,
                            -2.04268422e-10,
                            1.1865000000000002e-10],
                           [2.1345109500000002e-10,
                            3.8828702e-11,
                            1.1865000000000002e-10],
                           [-1.4035219000000002e-10,
                            1.6543972000000002e-10,
                            1.1865000000000002e-10]],
        'lattice_vectors': [[2.8655e-10,
                             -1.6543972000000002e-10,
                             2.3730000000000005e-10],
                            [0.0,
                             3.3087943900000004e-10,
                             2.3730000000000005e-10],
                            [-2.8655e-10,
                             -1.6543972000000002e-10,
                             2.3730000000000005e-10]],
        'normalized_wyckoff': {'c': {'X_1': 2}, 'e': {'X_0': 3}},
        'normalized_wysytax': {'c': {'X_0': 1}, 'e': {'X_1': 1}}}],
 160: [{'Notes': 'moissanite-9R',
        'Pearsons Symbol': 'hR6',
        'Prototype': 'CSi',
        'Space Group': 'R3m',
        'Space Group Number': 160,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'a6',
        'aflow_prototype_id': 'AB_hR6_160_3a_3a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_hR6_160_3a_3a.html',
        'atom_labels': ['C', 'C', 'C', 'Si', 'Si', 'Si'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [6.706471535305932e-11, 0.0, 4.928229971143772e-10],
                           [2.3472650373571065e-10,
                            0.0,
                            1.7248804899003428e-09],
                           [2.514926825739649e-11, 0.0, 1.8480862391788592e-10],
                           [9.221398361045884e-11, 0.0, 6.776316210322855e-10],
                           [2.5987577199310716e-10,
                            0.0,
                            1.9096891138182287e-09]],
        'lattice_vectors': [[1.50895609544385e-10, -2.61358862369949e-10, 0.0],
                            [1.50895609544385e-10, 2.61358862369949e-10, 0.0],
                            [0.0, 0.0, 2.21770348701472e-09]]},
       {'Notes': '-',
        'Pearsons Symbol': 'hR6',
        'Prototype': 'NiS',
        'Space Group': 'R3m',
        'Space Group Number': 160,
        'Strukturbericht Designation': 'B13',
        'Wyckoff Positions': 'b2',
        'aflow_prototype_id': 'AB_hR6_160_b_b',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_hR6_160_b_b.html',
        'atom_labels': ['Ni', 'Ni', 'Ni', 'S', 'S', 'S'],
        'atom_positions': [[4.8035e-10, 4.23344553e-10, 4.4670411e-11],
                           [3.53897862e-10,
                            2.0432302600000003e-10,
                            4.4670411e-11],
                           [6.068021370000001e-10,
                            2.0432302600000003e-10,
                            4.4670411e-11],
                           [0.0, -1.8676525100000002e-10, 0.0],
                           [1.61743452e-10, 9.338262600000001e-11, 0.0],
                           [-1.61743452e-10, 9.338262600000001e-11, 0.0]],
        'lattice_vectors': [[4.8035e-10, -2.77330202e-10, 1.04766667e-10],
                            [0.0, 5.54660404e-10, 1.04766667e-10],
                            [-4.8035e-10, -2.77330202e-10, 1.04766667e-10]],
        'normalized_wyckoff': {'b': {'X_0': 1, 'X_1': 1}},
        'normalized_wysytax': {'b': {'X_0': 1, 'X_1': 1}}}],
 161: [{'Notes': 'ferroelectric phase',
        'Pearsons Symbol': 'hR10',
        'Prototype': 'LiNbO3',
        'Space Group': 'R3c',
        'Space Group Number': 161,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'a2b',
        'aflow_prototype_id': 'ABC3_hR10_161_a_a_b',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/ABC3_hR10_161_a_a_b.html',
        'atom_labels': ['Li', 'Li', 'Nb', 'Nb', 'O', 'O', 'O', 'O', 'O', 'O'],
        'atom_positions': [[0.0, 0.0, 3.9893212500000004e-10],
                           [0.0, 0.0, 1.0927271250000001e-09],
                           [0.0, 0.0, 1.7761152e-11],
                           [0.0, 0.0, 7.115561520000001e-10],
                           [-1.5907090499999997e-10,
                            -2.4586629222367476e-11,
                            5.781624999999954e-10],
                           [-1.0363909500000002e-10,
                            1.2708905999643255e-10,
                            8.094274999999954e-10],
                           [5.8242807e-11,
                            1.5005275934415884e-10,
                            5.781624999999954e-10],
                           [-5.8242807e-11,
                            -1.5329861909344118e-10,
                            8.094274999999954e-10],
                           [1.0082809799999998e-10,
                            -1.2546613012179134e-10,
                            5.781624999999954e-10],
                           [1.6188190200000001e-10,
                            2.6209559097008637e-11,
                            8.094274999999953e-10]],
        'lattice_vectors': [[2.6271e-10, -1.516756892188e-10, 4.6253e-10],
                            [0.0, 3.033513784376e-10, 4.6253e-10],
                            [-2.6271e-10, -1.516756892188e-10, 4.6253e-10]],
        'normalized_wyckoff': {'a': {'X_1': 1, 'X_2': 1}, 'b': {'X_0': 3}},
        'normalized_wysytax': {'a': {'X_0': 1, 'X_1': 1}, 'b': {'X_2': 1}}}],
 162: [{'Notes': '-',
        'Pearsons Symbol': 'hP9',
        'Prototype': 'NV2 (beta)',
        'Space Group': 'P31m',
        'Space Group Number': 162,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'adk',
        'aflow_prototype_id': 'AB2_hP9_162_ad_k',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB2_hP9_162_ad_k.html',
        'atom_labels': ['N', 'N', 'N', 'V', 'V', 'V', 'V', 'V', 'V'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [2.4585e-10,
                            1.4194156368027254e-10,
                            2.2840000000000003e-10],
                           [2.4585e-10,
                            -1.4194156368027254e-10,
                            2.2840000000000003e-10],
                           [7.990124999999999e-11,
                            1.3839302458826292e-10,
                            1.242496e-10],
                           [1.6594875e-10,
                            2.874316664525461e-10,
                            3.3255040000000003e-10],
                           [7.990124999999999e-11,
                            -1.3839302458826292e-10,
                            1.242496e-10],
                           [1.5980249999999998e-10,
                            0.0,
                            3.3255040000000003e-10],
                           [1.6594875e-10,
                            -2.874316664525461e-10,
                            3.3255040000000003e-10],
                           [3.318975e-10, 0.0, 1.242496e-10]],
        'lattice_vectors': [[2.4585e-10, -4.25824691040809e-10, 0.0],
                            [2.4585e-10, 4.25824691040809e-10, 0.0],
                            [0.0, 0.0, 4.568e-10]],
        'normalized_wyckoff': {'a': {'X_1': 1},
                               'd': {'X_1': 2},
                               'k': {'X_0': 6}},
        'normalized_wysytax': {'a': {'X_1': 1},
                               'd': {'X_1': 2},
                               'k': {'X_0': 6}}}],
 163: [{'Notes': 'usually written KAg(CN)2',
        'Pearsons Symbol': 'hP36',
        'Prototype': 'AgC2KN2',
        'Space Group': 'P31c',
        'Space Group Number': 163,
        'Strukturbericht Designation': 'F510',
        'Wyckoff Positions': 'bfhi2',
        'aflow_prototype_id': 'AB2CD2_hP36_163_h_i_bf_i',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB2CD2_hP36_163_h_i_bf_i.html',
        'atom_labels': ['K',
                        'K',
                        'K',
                        'K',
                        'K',
                        'K',
                        'Ag',
                        'Ag',
                        'Ag',
                        'Ag',
                        'Ag',
                        'Ag',
                        'C',
                        'C',
                        'C',
                        'C',
                        'C',
                        'C',
                        'C',
                        'C',
                        'C',
                        'C',
                        'C',
                        'C',
                        'N',
                        'N',
                        'N',
                        'N',
                        'N',
                        'N',
                        'N',
                        'N',
                        'N',
                        'N',
                        'N',
                        'N'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [0.0, 0.0, 8.775e-10],
                           [3.6920000000000003e-10, 2.13157719e-10, 1.755e-11],
                           [3.6920000000000003e-10,
                            2.13157719e-10,
                            8.599500000000001e-10],
                           [3.6920000000000003e-10,
                            -2.13157719e-10,
                            -1.755e-11],
                           [3.6920000000000003e-10,
                            -2.13157719e-10,
                            8.9505e-10],
                           [0.0, 2.13157719e-10, 4.3875e-10],
                           [-1.8460000000000001e-10,
                            -1.0657886000000001e-10,
                            4.3875e-10],
                           [1.8460000000000001e-10,
                            -1.0657886000000001e-10,
                            4.3875e-10],
                           [0.0, -2.13157719e-10, 1.31625e-09],
                           [1.8460000000000001e-10,
                            1.0657886000000001e-10,
                            1.31625e-09],
                           [-1.8460000000000001e-10,
                            1.0657886000000001e-10,
                            1.31625e-09],
                           [2.3198066700000004e-10,
                            2.4513138000000003e-11,
                            -2.47455e-10],
                           [-1.3721933300000001e-10,
                            1.88644582e-10,
                            -2.47455e-10],
                           [-9.4761333e-11, -2.13157719e-10, -2.47455e-10],
                           [-2.3198066700000004e-10,
                            2.4513138000000003e-11,
                            1.1249549999999999e-09],
                           [1.3721933300000001e-10,
                            1.88644582e-10,
                            1.1249549999999999e-09],
                           [9.4761333e-11,
                            -2.13157719e-10,
                            1.1249549999999999e-09],
                           [-2.3198066700000004e-10,
                            -2.4513138000000003e-11,
                            2.47455e-10],
                           [1.3721933300000001e-10,
                            -1.88644582e-10,
                            2.47455e-10],
                           [9.4761333e-11, 2.13157719e-10, 2.47455e-10],
                           [2.3198066700000004e-10,
                            -2.4513138000000003e-11,
                            6.30045e-10],
                           [-1.3721933300000001e-10,
                            -1.88644582e-10,
                            6.30045e-10],
                           [-9.4761333e-11, 2.13157719e-10, 6.30045e-10],
                           [2.57824667e-10, -2.0249983e-11, -1.45665e-10],
                           [-1.1137533300000001e-10,
                            2.33407703e-10,
                            -1.45665e-10],
                           [-1.4644933300000002e-10,
                            -2.13157719e-10,
                            -1.45665e-10],
                           [-2.57824667e-10, -2.0249983e-11, 1.023165e-09],
                           [1.1137533300000001e-10,
                            2.33407703e-10,
                            1.023165e-09],
                           [1.4644933300000002e-10,
                            -2.13157719e-10,
                            1.023165e-09],
                           [-2.57824667e-10, 2.0249983e-11, 1.45665e-10],
                           [1.1137533300000001e-10,
                            -2.33407703e-10,
                            1.45665e-10],
                           [1.4644933300000002e-10,
                            2.13157719e-10,
                            1.45665e-10],
                           [2.57824667e-10, 2.0249983e-11, 7.31835e-10],
                           [-1.1137533300000001e-10,
                            -2.33407703e-10,
                            7.31835e-10],
                           [-1.4644933300000002e-10,
                            2.13157719e-10,
                            7.31835e-10]],
        'lattice_vectors': [[3.6920000000000003e-10,
                             -6.394731580000001e-10,
                             0.0],
                            [3.6920000000000003e-10,
                             6.394731580000001e-10,
                             0.0],
                            [0.0, 0.0, 1.755e-09]],
        'normalized_wyckoff': {'b': {'X_2': 1},
                               'f': {'X_2': 2},
                               'h': {'X_3': 3},
                               'i': {'X_0': 6, 'X_1': 6}},
        'normalized_wysytax': {'b': {'X_2': 1},
                               'f': {'X_2': 2},
                               'h': {'X_3': 3},
                               'i': {'X_0': 6, 'X_1': 6}}}],
 164: [{'Notes': '-',
        'Pearsons Symbol': 'hP5',
        'Prototype': 'Al3Ni2',
        'Space Group': 'P3m1',
        'Space Group Number': 164,
        'Strukturbericht Designation': 'D519',
        'Wyckoff Positions': 'ad2',
        'aflow_prototype_id': 'A3B2_hP5_164_ad_d',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A3B2_hP5_164_ad_d.html',
        'atom_labels': ['Al', 'Al', 'Al', 'Pd', 'Pd'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [2.1095000000000003e-10,
                            1.21792039e-10,
                            3.344328e-10],
                           [2.1095000000000003e-10,
                            -1.21792039e-10,
                            1.8166720000000002e-10],
                           [2.1095000000000003e-10,
                            1.21792039e-10,
                            7.689890000000001e-11],
                           [2.1095000000000003e-10,
                            -1.21792039e-10,
                            4.3920110000000003e-10]],
        'lattice_vectors': [[2.1095000000000003e-10,
                             -3.6537611800000003e-10,
                             0.0],
                            [2.1095000000000003e-10,
                             3.6537611800000003e-10,
                             0.0],
                            [0.0, 0.0, 5.161e-10]],
        'normalized_wyckoff': {'b': {'X_0': 1}, 'd': {'X_0': 2, 'X_1': 2}},
        'normalized_wysytax': {'a': {'X_0': 1}, 'd': {'X_0': 2, 'X_1': 2}}},
       {'Notes': 'omega phase',
        'Pearsons Symbol': 'hP3',
        'Prototype': 'CrTi',
        'Space Group': 'P3m1',
        'Space Group Number': 164,
        'Strukturbericht Designation': 'C6',
        'Wyckoff Positions': 'ad',
        'aflow_prototype_id': 'AB2_hP3_164_a_d',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB2_hP3_164_a_d.html',
        'atom_labels': ['Nb', 'Zr', 'Zr'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [2.4e-10, 1.38564065e-10, 1.6104000000000002e-10],
                           [2.4e-10, -1.38564065e-10, 1.3176000000000002e-10]],
        'lattice_vectors': [[2.4e-10, -4.1569219400000005e-10, 0.0],
                            [2.4e-10, 4.1569219400000005e-10, 0.0],
                            [0.0, 0.0, 2.928e-10]],
        'normalized_wyckoff': {'a': {'X_1': 1}, 'd': {'X_0': 2}},
        'normalized_wysytax': {'a': {'X_1': 1}, 'd': {'X_0': 2}}}],
 165: [{'Notes': '-',
        'Pearsons Symbol': 'hP24',
        'Prototype': 'H3Ho',
        'Space Group': 'P3c1',
        'Space Group Number': 165,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'adfg',
        'aflow_prototype_id': 'A3B_hP24_165_adg_f',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A3B_hP24_165_adg_f.html',
        'atom_labels': ['H',
                        'H',
                        'H',
                        'H',
                        'H',
                        'H',
                        'Ho',
                        'Ho',
                        'Ho',
                        'Ho',
                        'Ho',
                        'Ho',
                        'H',
                        'H',
                        'H',
                        'H',
                        'H',
                        'H',
                        'H',
                        'H',
                        'H',
                        'H',
                        'H',
                        'H'],
        'atom_positions': [[0.0, 0.0, 1.64e-10],
                           [0.0, 0.0, 4.920000000000001e-10],
                           [3.154e-10, 1.8209627500000002e-10, 1.09552e-10],
                           [3.154e-10,
                            -1.8209627500000002e-10,
                            2.1844800000000004e-10],
                           [-3.154e-10, -1.8209627500000002e-10, -1.09552e-10],
                           [-3.154e-10,
                            1.8209627500000002e-10,
                            -2.1844800000000004e-10],
                           [2.1005639999999999e-10,
                            -3.6382835700000003e-10,
                            1.64e-10],
                           [2.1005639999999999e-10,
                            3.6382835700000003e-10,
                            1.64e-10],
                           [-4.2011279999999997e-10, 0.0, 1.64e-10],
                           [-2.1005639999999999e-10,
                            3.6382835700000003e-10,
                            4.920000000000001e-10],
                           [-2.1005639999999999e-10,
                            -3.6382835700000003e-10,
                            4.920000000000001e-10],
                           [4.2011279999999997e-10, 0.0, 4.920000000000001e-10],
                           [1.211136e-10, -1.79182735e-10, 6.2976e-11],
                           [9.462e-11, 1.9447882200000001e-10, 6.2976e-11],
                           [-2.157336e-10, -1.5296087e-11, 6.2976e-11],
                           [1.211136e-10, 1.79182735e-10, 2.65024e-10],
                           [9.462e-11, -1.9447882200000001e-10, 2.65024e-10],
                           [-2.157336e-10, 1.5296087e-11, 2.65024e-10],
                           [-1.211136e-10, 1.79182735e-10, -6.2976e-11],
                           [-9.462e-11, -1.9447882200000001e-10, -6.2976e-11],
                           [2.157336e-10, 1.5296087e-11, -6.2976e-11],
                           [-1.211136e-10, -1.79182735e-10, -2.65024e-10],
                           [-9.462e-11, 1.9447882200000001e-10, -2.65024e-10],
                           [2.157336e-10, -1.5296087e-11, -2.65024e-10]],
        'lattice_vectors': [[3.154e-10, -5.46288825e-10, 0.0],
                            [3.154e-10, 5.46288825e-10, 0.0],
                            [0.0, 0.0, 6.56e-10]],
        'normalized_wyckoff': {'a': {'X_0': 1},
                               'd': {'X_0': 2},
                               'f': {'X_1': 3},
                               'g': {'X_0': 6}},
        'normalized_wysytax': {'a': {'X_0': 1},
                               'd': {'X_0': 2},
                               'f': {'X_1': 3},
                               'g': {'X_0': 6}}}],
 166: [{'Notes': '-',
        'Pearsons Symbol': 'hR2',
        'Prototype': 'As (alpha)',
        'Space Group': 'R3m',
        'Space Group Number': 166,
        'Strukturbericht Designation': 'A7',
        'Wyckoff Positions': 'c',
        'aflow_prototype_id': 'A_hR2_166_c',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_hR2_166_c.alpha-As.html',
        'atom_labels': ['As', 'As'],
        'atom_positions': [[1.37328129e-10, 1.37328129e-10, 1.37328129e-10],
                           [-1.37328129e-10, -1.37328129e-10, -1.37328129e-10]],
        'lattice_vectors': [[2.5712604000000002e-11,
                             2.9159610300000004e-10,
                             2.9159610300000004e-10],
                            [2.9159610300000004e-10,
                             2.5712604000000002e-11,
                             2.9159610300000004e-10],
                            [2.9159610300000004e-10,
                             2.9159610300000004e-10,
                             2.5712604000000002e-11]],
        'normalized_wyckoff': {'c': {'X_0': 1}},
        'normalized_wysytax': {'c': {'X_0': 1}}},
       {'Notes': '-',
        'Pearsons Symbol': 'hR12',
        'Prototype': 'B (alpha)',
        'Space Group': 'R3m',
        'Space Group Number': 166,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'h2',
        'aflow_prototype_id': 'A_hR12_166_2h',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_hR12_166_2h.html',
        'atom_labels': ['B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B'],
        'atom_positions': [[0.0, -1.0233600000000001e-10, -1.38689e-10],
                           [8.862600000000001e-11,
                            5.1168000000000005e-11,
                            -1.38689e-10],
                           [-8.862600000000001e-11,
                            5.1168000000000005e-11,
                            -1.38689e-10],
                           [-0.0, 1.0233600000000001e-10, 1.38689e-10],
                           [-8.862600000000001e-11,
                            -5.1168000000000005e-11,
                            1.38689e-10],
                           [8.862600000000001e-11,
                            -5.1168000000000005e-11,
                            1.38689e-10],
                           [0.0, -1.70371e-10, 3.7291000000000003e-11],
                           [1.4754600000000001e-10,
                            8.5185e-11,
                            3.7291000000000003e-11],
                           [-1.4754600000000001e-10,
                            8.5185e-11,
                            3.7291000000000003e-11],
                           [-0.0, 1.70371e-10, -3.7291000000000003e-11],
                           [-1.4754600000000001e-10,
                            -8.5185e-11,
                            -3.7291000000000003e-11],
                           [1.4754600000000001e-10,
                            -8.5185e-11,
                            -3.7291000000000003e-11]],
        'lattice_vectors': [[2.4550000000000003e-10,
                             -1.41739e-10,
                             4.1900000000000005e-10],
                            [0.0, 2.83479e-10, 4.1900000000000005e-10],
                            [-2.4550000000000003e-10,
                             -1.41739e-10,
                             4.1900000000000005e-10]],
        'normalized_wyckoff': {'h': {'X_0': 1}},
        'normalized_wysytax': {'h': {'X_0': 1}}},
       {'Notes': '-',
        'Pearsons Symbol': 'hR105',
        'Prototype': 'B (beta)',
        'Space Group': 'R3m',
        'Space Group Number': 166,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'bch9i4',
        'aflow_prototype_id': 'A_hR105_166_bc9h4i',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_hR105_166_bc9h4i.html',
        'atom_labels': ['B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B'],
        'atom_positions': [[1.8878550000000001e-10,
                            -9.47786e-13,
                            4.2098085000000004e-10],
                           [-9.3571944e-11,
                            1.6396693200000002e-10,
                            4.2098085000000004e-10],
                           [-9.5213557e-11,
                            -1.63019146e-10,
                            4.2098085000000004e-10],
                           [9.3571944e-11,
                            1.6396693200000002e-10,
                            4.2098085000000004e-10],
                           [9.5213557e-11,
                            -1.63019146e-10,
                            4.2098085000000004e-10],
                           [-1.8878550000000001e-10,
                            -9.47786e-13,
                            4.2098085000000004e-10],
                           [-1.8878550000000001e-10,
                            9.47786e-13,
                            -4.2098085000000004e-10],
                           [9.3571944e-11,
                            -1.6396693200000002e-10,
                            -4.2098085000000004e-10],
                           [9.5213557e-11,
                            1.63019146e-10,
                            -4.2098085000000004e-10],
                           [-9.3571944e-11,
                            -1.6396693200000002e-10,
                            -4.2098085000000004e-10],
                           [-9.5213557e-11,
                            1.63019146e-10,
                            -4.2098085000000004e-10],
                           [1.8878550000000001e-10,
                            9.47786e-13,
                            -4.2098085000000004e-10],
                           [3.36804277e-10,
                            -2.1135622e-11,
                            3.0740174100000004e-10],
                           [-1.5009815300000002e-10,
                            3.0224887100000004e-10,
                            3.0740174100000004e-10],
                           [-1.86706124e-10,
                            -2.81113249e-10,
                            3.0740174100000004e-10],
                           [1.5009815300000002e-10,
                            3.0224887100000004e-10,
                            3.0740174100000004e-10],
                           [1.86706124e-10,
                            -2.81113249e-10,
                            3.0740174100000004e-10],
                           [-3.36804277e-10,
                            -2.1135622e-11,
                            3.0740174100000004e-10],
                           [-3.36804277e-10,
                            2.1135622e-11,
                            -3.0740174100000004e-10],
                           [1.5009815300000002e-10,
                            -3.0224887100000004e-10,
                            -3.0740174100000004e-10],
                           [1.86706124e-10,
                            2.81113249e-10,
                            -3.0740174100000004e-10],
                           [-1.5009815300000002e-10,
                            -3.0224887100000004e-10,
                            -3.0740174100000004e-10],
                           [-1.86706124e-10,
                            2.81113249e-10,
                            -3.0740174100000004e-10],
                           [3.36804277e-10,
                            2.1135622e-11,
                            -3.0740174100000004e-10],
                           [2.61508958e-10, -4.1228679e-11, 9.9982952e-10],
                           [-9.5049395e-11, 2.47087741e-10, 9.9982952e-10],
                           [-1.66459563e-10, -2.05859062e-10, 9.9982952e-10],
                           [9.5049395e-11, 2.47087741e-10, 9.9982952e-10],
                           [1.66459563e-10, -2.05859062e-10, 9.9982952e-10],
                           [-2.61508958e-10, -4.1228679e-11, 9.9982952e-10],
                           [-2.61508958e-10, 4.1228679e-11, -9.9982952e-10],
                           [9.5049395e-11, -2.47087741e-10, -9.9982952e-10],
                           [1.66459563e-10, 2.05859062e-10, -9.9982952e-10],
                           [-9.5049395e-11, -2.47087741e-10, -9.9982952e-10],
                           [-1.66459563e-10, 2.05859062e-10, -9.9982952e-10],
                           [2.61508958e-10, 4.1228679e-11, -9.9982952e-10],
                           [2.65777152e-10, 1.4690679e-11, 8.26960686e-10],
                           [-1.45611077e-10, 2.22824426e-10, 8.26960686e-10],
                           [-1.20166075e-10, -2.37515105e-10, 8.26960686e-10],
                           [1.45611077e-10, 2.22824426e-10, 8.26960686e-10],
                           [1.20166075e-10, -2.37515105e-10, 8.26960686e-10],
                           [-2.65777152e-10, 1.4690679e-11, 8.26960686e-10],
                           [-2.65777152e-10, -1.4690679e-11, -8.26960686e-10],
                           [1.45611077e-10, -2.22824426e-10, -8.26960686e-10],
                           [1.20166075e-10, 2.37515105e-10, -8.26960686e-10],
                           [-1.45611077e-10, -2.22824426e-10, -8.26960686e-10],
                           [-1.20166075e-10, 2.37515105e-10, -8.26960686e-10],
                           [2.65777152e-10, -1.4690679e-11, -8.26960686e-10],
                           [0.0,
                            -1.0406687400000001e-10,
                            -1.3334235100000002e-10],
                           [9.0124556e-11,
                            5.203343700000001e-11,
                            -1.3334235100000002e-10],
                           [-9.0124556e-11,
                            5.203343700000001e-11,
                            -1.3334235100000002e-10],
                           [0.0,
                            1.0406687400000001e-10,
                            1.3334235100000002e-10],
                           [-9.0124556e-11,
                            -5.203343700000001e-11,
                            1.3334235100000002e-10],
                           [9.0124556e-11,
                            -5.203343700000001e-11,
                            1.3334235100000002e-10],
                           [0.0, -1.64346046e-10, 3.0954474e-11],
                           [1.4232785100000002e-10,
                            8.2173023e-11,
                            3.0954474e-11],
                           [-1.4232785100000002e-10,
                            8.2173023e-11,
                            3.0954474e-11],
                           [0.0, 1.64346046e-10, -3.0954474e-11],
                           [-1.4232785100000002e-10,
                            -8.2173023e-11,
                            -3.0954474e-11],
                           [1.4232785100000002e-10,
                            -8.2173023e-11,
                            -3.0954474e-11],
                           [0.0, -2.06806847e-10, -2.71446928e-10],
                           [1.79099983e-10, 1.03403424e-10, -2.71446928e-10],
                           [-1.79099983e-10, 1.03403424e-10, -2.71446928e-10],
                           [0.0, 2.06806847e-10, 2.71446928e-10],
                           [-1.79099983e-10, -1.03403424e-10, 2.71446928e-10],
                           [1.79099983e-10, -1.03403424e-10, 2.71446928e-10],
                           [0.0, -3.22815821e-10, -5.56704315e-10],
                           [2.7956670199999997e-10,
                            1.61407911e-10,
                            -5.56704315e-10],
                           [-2.7956670199999997e-10,
                            1.61407911e-10,
                            -5.56704315e-10],
                           [0.0, 3.22815821e-10, 5.56704315e-10],
                           [-2.7956670199999997e-10,
                            -1.61407911e-10,
                            5.56704315e-10],
                           [2.7956670199999997e-10,
                            -1.61407911e-10,
                            5.56704315e-10],
                           [0.0, -2.4358093400000004e-10, -5.56704315e-10],
                           [2.10947276e-10,
                            1.2179046700000002e-10,
                            -5.56704315e-10],
                           [-2.10947276e-10,
                            1.2179046700000002e-10,
                            -5.56704315e-10],
                           [0.0, 2.4358093400000004e-10, 5.56704315e-10],
                           [-2.10947276e-10,
                            -1.2179046700000002e-10,
                            5.56704315e-10],
                           [2.10947276e-10,
                            -1.2179046700000002e-10,
                            5.56704315e-10],
                           [0.0, -1.93727404e-10, -7.19096249e-10],
                           [1.6777285300000002e-10,
                            9.6863702e-11,
                            -7.19096249e-10],
                           [-1.6777285300000002e-10,
                            9.6863702e-11,
                            -7.19096249e-10],
                           [0.0, 1.93727404e-10, 7.19096249e-10],
                           [-1.6777285300000002e-10,
                            -9.6863702e-11,
                            7.19096249e-10],
                           [1.6777285300000002e-10,
                            -9.6863702e-11,
                            7.19096249e-10],
                           [0.0, -1.06531117e-10, 7.7790975e-10],
                           [9.2258653e-11, 5.3265558e-11, 7.7790975e-10],
                           [-9.2258653e-11, 5.3265558e-11, 7.7790975e-10],
                           [0.0, 1.06531117e-10, -7.7790975e-10],
                           [-9.2258653e-11, -5.3265558e-11, -7.7790975e-10],
                           [9.2258653e-11, -5.3265558e-11, -7.7790975e-10],
                           [0.0, -1.69464089e-10, 9.50064249e-10],
                           [1.46760206e-10, 8.4732045e-11, 9.50064249e-10],
                           [-1.46760206e-10, 8.4732045e-11, 9.50064249e-10],
                           [0.0, 1.69464089e-10, -9.50064249e-10],
                           [-1.46760206e-10, -8.4732045e-11, -9.50064249e-10],
                           [1.46760206e-10, -8.4732045e-11, -9.50064249e-10],
                           [0.0, -1.0880580200000002e-10, -1.061976579e-09],
                           [9.4228589e-11,
                            5.440290100000001e-11,
                            -1.061976579e-09],
                           [-9.4228589e-11,
                            5.440290100000001e-11,
                            -1.061976579e-09],
                           [0.0, 1.0880580200000002e-10, 1.061976579e-09],
                           [-9.4228589e-11,
                            -5.440290100000001e-11,
                            1.061976579e-09],
                           [9.4228589e-11,
                            -5.440290100000001e-11,
                            1.061976579e-09],
                           [0.0, 0.0, 6.4290062e-10],
                           [0.0, 0.0, -6.4290062e-10],
                           [0.0, 0.0, 1.190556703e-09]],
        'lattice_vectors': [[5.47204349e-10, -3.15928578e-10, 7.93704469e-10],
                            [0.0, 6.31857156e-10, 7.93704469e-10],
                            [-5.47204349e-10, -3.15928578e-10, 7.93704469e-10]],
        'normalized_wysytax': {'b': {'X_0': 1},
                               'c': {'X_0': 2},
                               'h': {'X_0': 18},
                               'i': {'X_0': 16}}},
       {'Notes': '-',
        'Pearsons Symbol': 'hR7',
        'Prototype': 'B5Mo2',
        'Space Group': 'R3m',
        'Space Group Number': 166,
        'Strukturbericht Designation': 'D8i',
        'Wyckoff Positions': 'bc3',
        'aflow_prototype_id': 'A5B2_hR7_166_a2c_c',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A5B2_hR7_166_a2c_c.html',
        'atom_labels': ['B', 'B', 'B', 'B', 'B', 'Mo', 'Mo'],
        'atom_positions': [[0.0, 0.0, 1.0465e-09],
                           [0.0, 0.0, 6.96969e-10],
                           [0.0, 0.0, -6.96969e-10],
                           [0.0, 0.0, 3.89298e-10],
                           [0.0, 0.0, -3.89298e-10],
                           [0.0, 0.0, 1.56975e-10],
                           [0.0, 0.0, -1.56975e-10]],
        'lattice_vectors': [[1.5055e-10,
                             -8.692008300000001e-11,
                             6.976666670000001e-10],
                            [0.0,
                             1.7384016600000002e-10,
                             6.976666670000001e-10],
                            [-1.5055e-10,
                             -8.692008300000001e-11,
                             6.976666670000001e-10]],
        'normalized_wyckoff': {'b': {'X_0': 1}, 'c': {'X_0': 4, 'X_1': 2}},
        'normalized_wysytax': {'b': {'X_0': 1}, 'c': {'X_0': 4, 'X_1': 2}}},
       {'Notes': '-',
        'Pearsons Symbol': 'hR5',
        'Prototype': 'Bi2Te3',
        'Space Group': 'R3m',
        'Space Group Number': 166,
        'Strukturbericht Designation': 'C33',
        'Wyckoff Positions': 'ac2',
        'aflow_prototype_id': 'A2B3_hR5_166_c_ac',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2B3_hR5_166_c_ac.html',
        'atom_labels': ['Te', 'Te', 'Te', 'Bi', 'Bi'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [0.0, -2e-18, 6.46324398e-10],
                           [0.0, 2e-18, -6.46324398e-10],
                           [0.0, -4e-18, 1.219479996e-09],
                           [0.0, 4e-18, -1.219479996e-09]],
        'lattice_vectors': [[2.19175e-10,
                             -1.2654075000000002e-10,
                             1.01623333e-09],
                            [0.0, 2.5308149000000004e-10, 1.01623333e-09],
                            [-2.19175e-10,
                             -1.2654075000000002e-10,
                             1.01623333e-09]],
        'normalized_wyckoff': {'a': {'X_0': 1}, 'c': {'X_0': 2, 'X_1': 2}},
        'normalized_wysytax': {'a': {'X_0': 1}, 'c': {'X_0': 2, 'X_1': 2}}},
       {'Notes': 'rhombohedral graphite',
        'Pearsons Symbol': 'hR2',
        'Prototype': 'C',
        'Space Group': 'R3m',
        'Space Group Number': 166,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'c',
        'aflow_prototype_id': 'A_hR2_166_c',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_hR2_166_c.C.html',
        'atom_labels': ['C', 'C'],
        'atom_positions': [[0.0, 0.0, 1.6740000000000337e-10],
                           [0.0, 0.0, 8.369999999999966e-10]],
        'lattice_vectors': [[1.228e-10, -7.0898613056486e-11, 3.348e-10],
                            [0.0, 1.41797226112972e-10, 3.348e-10],
                            [-1.228e-10, -7.0898613056486e-11, 3.348e-10]],
        'normalized_wyckoff': {'c': {'X_0': 1}},
        'normalized_wysytax': {'c': {'X_0': 1}}},
       {'Notes': '-',
        'Pearsons Symbol': 'hR7',
        'Prototype': 'C6Ca',
        'Space Group': 'R3m',
        'Space Group Number': 166,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'ag',
        'aflow_prototype_id': 'A6B_hR7_166_g_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A6B_hR7_166_g_a.html',
        'atom_labels': ['Ca', 'C', 'C', 'C', 'C', 'C', 'C'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [1.44434618e-10, 1e-18, 2.2622164200000003e-10],
                           [-7.221731000000001e-11,
                            1.25084048e-10,
                            2.2622164200000003e-10],
                           [-7.221730800000001e-11,
                            -1.25084049e-10,
                            2.2622164200000003e-10],
                           [7.221730800000001e-11,
                            -1.25084049e-10,
                            2.2622164200000003e-10],
                           [7.221731000000001e-11,
                            1.25084048e-10,
                            2.2622164200000003e-10],
                           [-1.44434618e-10, 1e-18, 2.2622164200000003e-10]],
        'lattice_vectors': [[2.1665192599999998e-10,
                             -1.25084048e-10,
                             4.5244328300000006e-10],
                            [0.0, 2.50168096e-10, 4.5244328300000006e-10],
                            [-2.1665192599999998e-10,
                             -1.25084048e-10,
                             4.5244328300000006e-10]],
        'normalized_wyckoff': {'b': {'X_1': 1}, 'f': {'X_0': 6}},
        'normalized_wysytax': {'a': {'X_1': 1}, 'g': {'X_0': 3}}},
       {'Notes': 'caswellsilverite',
        'Pearsons Symbol': 'hR4',
        'Prototype': 'CrNaS2',
        'Space Group': 'R3m',
        'Space Group Number': 166,
        'Strukturbericht Designation': 'F51',
        'Wyckoff Positions': 'abc',
        'aflow_prototype_id': 'ABC2_hR4_166_a_b_c',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/ABC2_hR4_166_a_b_c.html',
        'atom_labels': ['Cr', 'Na', 'S', 'S'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [0.0, 0.0, 9.785e-10],
                           [0.0, 0.0, 5.166480000000001e-10],
                           [0.0, 0.0, -5.166480000000001e-10]],
        'lattice_vectors': [[1.755e-10,
                             -1.0132497199999999e-10,
                             6.52333333e-10],
                            [0.0, 2.0264994399999999e-10, 6.52333333e-10],
                            [-1.755e-10,
                             -1.0132497199999999e-10,
                             6.52333333e-10]],
        'normalized_wyckoff': {'a': {'X_1': 1},
                               'b': {'X_2': 1},
                               'c': {'X_0': 2}},
        'normalized_wysytax': {'a': {'X_1': 1}, 'c': {'X_0': 2}}},
       {'Notes': '-',
        'Pearsons Symbol': 'hR2',
        'Prototype': 'CuPt',
        'Space Group': 'R3m',
        'Space Group Number': 166,
        'Strukturbericht Designation': 'L11',
        'Wyckoff Positions': 'ab',
        'aflow_prototype_id': 'AB_hR2_166_a_b',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_hR2_166_a_b.html',
        'atom_labels': ['Cu', 'Pt'],
        'atom_positions': [[0.0, 0.0, 0.0], [3.65e-10, 3.65e-10, 3.65e-10]],
        'lattice_vectors': [[3.7e-10, 1.8e-10, 1.8e-10],
                            [1.8e-10, 3.7e-10, 1.8e-10],
                            [1.8e-10, 1.8e-10, 3.7e-10]],
        'normalized_wyckoff': {'a': {'X_0': 1}, 'b': {'X_1': 1}},
        'normalized_wysytax': {'a': {'X_0': 1}}},
       {'Notes': '-',
        'Pearsons Symbol': 'hR13',
        'Prototype': 'Fe7W6',
        'Space Group': 'R3m',
        'Space Group Number': 166,
        'Strukturbericht Designation': 'D85',
        'Wyckoff Positions': 'ac3h',
        'aflow_prototype_id': 'A7B6_hR13_166_ah_3c',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A7B6_hR13_166_ah_3c.html',
        'atom_labels': ['Fe',
                        'W',
                        'W',
                        'W',
                        'W',
                        'W',
                        'W',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [0.0, 0.0, 4.31528e-10],
                           [0.0, 0.0, -4.31528e-10],
                           [0.0, 0.0, 8.94064e-10],
                           [0.0, 0.0, -8.94064e-10],
                           [0.0, 0.0, 1.157632e-09],
                           [0.0, 0.0, -1.157632e-09],
                           [0.0, 1.37597407e-10, 6.64088e-10],
                           [-1.1916285e-10, -6.8798704e-11, 6.64088e-10],
                           [1.1916285e-10, -6.8798704e-11, 6.64088e-10],
                           [0.0, -1.37597407e-10, -6.64088e-10],
                           [-1.1916285e-10, 6.8798704e-11, -6.64088e-10],
                           [1.1916285e-10, 6.8798704e-11, -6.64088e-10]],
        'lattice_vectors': [[2.3785e-10, -1.37322762e-10, 8.61333333e-10],
                            [0.0, 2.74645523e-10, 8.61333333e-10],
                            [-2.3785e-10, -1.37322762e-10, 8.61333333e-10]],
        'normalized_wyckoff': {'a': {'X_0': 1},
                               'c': {'X_1': 6},
                               'h': {'X_0': 6}},
        'normalized_wysytax': {'a': {'X_1': 1},
                               'c': {'X_0': 6},
                               'h': {'X_1': 2}}},
       {'Notes': 'rhombohedral',
        'Pearsons Symbol': 'hR1',
        'Prototype': 'Hg (alpha)',
        'Space Group': 'R3m',
        'Space Group Number': 166,
        'Strukturbericht Designation': 'A10',
        'Wyckoff Positions': 'a',
        'aflow_prototype_id': 'A_hR1_166_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_hR1_166_a.alpha-Hg.html',
        'atom_labels': ['Hg'],
        'atom_positions': [[0.0, 0.0, 0.0]],
        'lattice_vectors': [[2.9288947099999997e-10,
                             4.7518459000000003e-11,
                             4.7518459000000003e-11],
                            [4.7518459000000003e-11,
                             2.9288947099999997e-10,
                             4.7518459000000003e-11],
                            [4.7518459000000003e-11,
                             4.7518459000000003e-11,
                             2.9288947099999997e-10]],
        'normalized_wyckoff': {'a': {'X_0': 1}},
        'normalized_wysytax': {'a': {'X_0': 1}}},
       {'Notes': '-',
        'Pearsons Symbol': 'hR2',
        'Prototype': 'O2 (beta)',
        'Space Group': 'R3m',
        'Space Group Number': 166,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'c',
        'aflow_prototype_id': 'A_hR2_166_c',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_hR2_166_c.beta-O.html',
        'atom_labels': ['O', 'O'],
        'atom_positions': [[0.0, 0.0, 6.125583e-11], [0.0, 0.0, -6.125583e-11]],
        'lattice_vectors': [[1.6445e-10, -9.4945252e-11, 3.76033333e-10],
                            [0.0, 1.89890504e-10, 3.76033333e-10],
                            [-1.6445e-10, -9.4945252e-11, 3.76033333e-10]],
        'normalized_wyckoff': {'c': {'X_0': 1}},
        'normalized_wysytax': {'c': {'X_0': 1}}},
       {'Notes': '-',
        'Pearsons Symbol': 'hR1',
        'Prototype': 'Po (beta)',
        'Space Group': 'R3m',
        'Space Group Number': 166,
        'Strukturbericht Designation': 'Ai',
        'Wyckoff Positions': 'a',
        'aflow_prototype_id': 'A_hR1_166_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_hR1_166_a.beta-Po.html',
        'atom_labels': ['Po'],
        'atom_positions': [[0.0, 0.0, 0.0]],
        'lattice_vectors': [[2.98911671e-10, -2.1818147e-11, -2.1818147e-11],
                            [-2.1818147e-11, 2.98911671e-10, -2.1818147e-11],
                            [-2.1818147e-11, -2.1818147e-11, 2.98911671e-10]],
        'normalized_wyckoff': {'a': {'X_0': 1}},
        'normalized_wysytax': {'a': {'X_0': 1}}},
       {'Notes': '-',
        'Pearsons Symbol': 'hR3',
        'Prototype': 'Sm (alpha)',
        'Space Group': 'R3m',
        'Space Group Number': 166,
        'Strukturbericht Designation': 'C19',
        'Wyckoff Positions': 'ac',
        'aflow_prototype_id': 'A_hR3_166_ac',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_hR3_166_ac.html',
        'atom_labels': ['Sm', 'Sm', 'Sm'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [0.0, 0.0, 5.82088889e-10],
                           [0.0, 0.0, -5.82088889e-10]],
        'lattice_vectors': [[0.0, 2.09462678e-10, 8.73133333e-10],
                            [-1.8140000000000001e-10,
                             -1.04731339e-10,
                             8.73133333e-10],
                            [1.8140000000000001e-10,
                             -1.04731339e-10,
                             8.73133333e-10]],
        'normalized_wyckoff': {'a': {'X_0': 1}, 'c': {'X_0': 2}},
        'normalized_wysytax': {'a': {'X_0': 1}, 'c': {'X_0': 2}}}],
 167: [{'Notes': 'corundum',
        'Pearsons Symbol': 'hR10',
        'Prototype': 'Al2O3 (alpha)',
        'Space Group': 'R3c',
        'Space Group Number': 167,
        'Strukturbericht Designation': 'D51',
        'Wyckoff Positions': 'ce',
        'aflow_prototype_id': 'A2B3_hR10_167_c_e',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2B3_hR10_167_c_e.html',
        'atom_labels': ['Al', 'Al', 'Al', 'Al', 'O', 'O', 'O', 'O', 'O', 'O'],
        'atom_positions': [[2.6420225e-10, 2.6420225e-10, 2.6420225e-10],
                           [-2.6420225e-10, -2.6420225e-10, -2.6420225e-10],
                           [1.1078675000000001e-10,
                            1.1078675000000001e-10,
                            1.1078675000000001e-10],
                           [-1.1078675000000001e-10,
                            -1.1078675000000001e-10,
                            -1.1078675000000001e-10],
                           [2.9058014499999997e-10,
                            8.440885500000001e-11,
                            1.874945e-10],
                           [-2.9058014499999997e-10,
                            -8.440885500000001e-11,
                            -1.874945e-10],
                           [8.440885500000001e-11,
                            1.874945e-10,
                            2.9058014499999997e-10],
                           [-8.440885500000001e-11,
                            -1.874945e-10,
                            -2.9058014499999997e-10],
                           [1.874945e-10,
                            2.9058014499999997e-10,
                            8.440885500000001e-11],
                           [-1.874945e-10,
                            -2.9058014499999997e-10,
                            -8.440885500000001e-11]],
        'lattice_vectors': [[2.56984e-11,
                             3.6213980000000004e-10,
                             3.6213980000000004e-10],
                            [3.6213980000000004e-10,
                             2.56984e-11,
                             3.6213980000000004e-10],
                            [3.6213980000000004e-10,
                             3.6213980000000004e-10,
                             2.56984e-11]],
        'normalized_wyckoff': {'c': {'X_1': 2}, 'e': {'X_0': 3}},
        'normalized_wysytax': {'c': {'X_0': 2}, 'e': {'X_1': 1}}},
       {'Notes': 'calcite',
        'Pearsons Symbol': 'hR10',
        'Prototype': 'CCaO3',
        'Space Group': 'R3c',
        'Space Group Number': 167,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'abe',
        'aflow_prototype_id': 'ABC3_hR10_167_a_b_e',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/ABC3_hR10_167_a_b_e.CaCO3.html',
        'atom_labels': ['Ca', 'Ca', 'C', 'C', 'O', 'O', 'O', 'O', 'O', 'O'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [0.0, 0.0, 8.50934427e-10],
                           [0.0, 0.0, 4.2546721300000004e-10],
                           [0.0, -0.0, 1.27640164e-09],
                           [-1.0480784700000002e-10,
                            6.0510839e-11,
                            4.2546721300000004e-10],
                           [1.0480784700000002e-10,
                            6.0510839e-11,
                            4.2546721300000004e-10],
                           [0.0, -1.21021677e-10, 4.2546721300000004e-10],
                           [-1.82730828e-10, -6.0510839e-11, 7.09112022e-10],
                           [3.896149e-11, 1.88504958e-10, 7.09112022e-10],
                           [1.43769337e-10, -1.27994119e-10, 7.09112022e-10]],
        'lattice_vectors': [[2.87538675e-10, 0.0, 5.672896180000001e-10],
                            [-1.43769337e-10,
                             2.49015797e-10,
                             5.672896180000001e-10],
                            [-1.43769337e-10,
                             -2.49015797e-10,
                             5.672896180000001e-10]],
        'normalized_wyckoff': {'a': {'X_1': 1},
                               'b': {'X_2': 1},
                               'e': {'X_0': 3}},
        'normalized_wysytax': {'a': {'X_1': 2},
                               'b': {'X_2': 2},
                               'e': {'X_0': 3}}},
       {'Notes': 'paraelectric phase',
        'Pearsons Symbol': 'hR10',
        'Prototype': 'LiNbO3',
        'Space Group': 'R3c',
        'Space Group Number': 167,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'abe',
        'aflow_prototype_id': 'ABC3_hR10_167_a_b_e',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/ABC3_hR10_167_a_b_e.LiNbO3.html',
        'atom_labels': ['Li', 'Li', 'Nb', 'Nb', 'O', 'O', 'O', 'O', 'O', 'O'],
        'atom_positions': [[1.32125e-10, 2.5000000000000004e-26, 9.622e-11],
                           [3.96375e-10, 7.500000000000001e-26, 2.8866e-10],
                           [0.0, 0.0, 0.0],
                           [2.6425e-10, 5.000000000000001e-26, 1.9244e-10],
                           [1.32125e-10, 9.846532749197281e-11, 2.8866e-10],
                           [2.9267449166666753e-10,
                            2.780798766960245e-10,
                            2.472597413333321e-10],
                           [2.9267449166666753e-10,
                            1.7961454920405168e-10,
                            5.481974133333205e-11],
                           [2.3582550833333245e-10,
                            -1.7961454920405157e-10,
                            3.3006025866666795e-10],
                           [2.3582550833333245e-10,
                            -2.7807987669602434e-10,
                            1.3762025866666797e-10],
                           [3.96375e-10, -9.846532749197275e-11, 9.622e-11]],
        'lattice_vectors': [[2.6425e-10, -4.57694425900076e-10, 0.0],
                            [2.6425e-10, 4.57694425900076e-10, 0.0],
                            [0.0, 1e-25, 3.8488e-10]]}],
 180: [{'Notes': '-',
        'Pearsons Symbol': 'hP9',
        'Prototype': 'CrSi2',
        'Space Group': 'P6222',
        'Space Group Number': 180,
        'Strukturbericht Designation': 'C40',
        'Wyckoff Positions': 'dj',
        'aflow_prototype_id': 'AB2_hP9_180_d_j',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB2_hP9_180_d_j.html',
        'atom_labels': ['Ta', 'Ta', 'Ta', 'Ge', 'Ge', 'Ge', 'Ge', 'Ge', 'Ge'],
        'atom_positions': [[1.2345e-10,
                            -2.13821672e-10,
                            3.3650000000000003e-10],
                           [1.2345e-10, 2.13821672e-10, 1.1216666900000001e-10],
                           [2.469e-10, 0.0, 5.60833331e-10],
                           [1.214748e-10,
                            7.0133508e-11,
                            3.3650000000000003e-10],
                           [-1.214748e-10,
                            7.0133508e-11,
                            1.1216666900000001e-10],
                           [0.0, -1.40267017e-10, 5.60833331e-10],
                           [-1.214748e-10,
                            -7.0133508e-11,
                            3.3650000000000003e-10],
                           [1.214748e-10,
                            -7.0133508e-11,
                            1.1216666900000001e-10],
                           [0.0, 1.40267017e-10, 5.60833331e-10]],
        'lattice_vectors': [[2.469e-10, -4.27643344e-10, 0.0],
                            [2.469e-10, 4.27643344e-10, 0.0],
                            [0.0, 0.0, 6.730000000000001e-10]],
        'normalized_wyckoff': {'c': {'X_1': 1}, 'i': {'X_0': 2}},
        'normalized_wysytax': {'d': {'X_1': 1}, 'j': {'X_0': 2}}},
       {'Notes': '-',
        'Pearsons Symbol': 'hP18',
        'Prototype': 'Mg2Ni',
        'Space Group': 'P6222',
        'Space Group Number': 180,
        'Strukturbericht Designation': 'Ca',
        'Wyckoff Positions': 'bcfi',
        'aflow_prototype_id': 'A2B_hP18_180_fi_bd',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2B_hP18_180_fi_bd.html',
        'atom_labels': ['Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Mg'],
        'atom_positions': [[0.0, 0.0, 6.62185e-10],
                           [0.0, 0.0, 2.20728334e-10],
                           [0.0, 0.0, -2.20728334e-10],
                           [1.302675e-10, -2.25629929e-10, 0.0],
                           [1.302675e-10, 2.25629929e-10, 8.82913334e-10],
                           [2.60535e-10, 0.0, 4.41456666e-10],
                           [1.302675e-10,
                            -2.25629929e-10,
                            2.1534256200000002e-10],
                           [1.302675e-10,
                            2.25629929e-10,
                            -2.2611410400000002e-10],
                           [2.60535e-10, 0.0, 6.56799228e-10],
                           [1.302675e-10,
                            -2.25629929e-10,
                            -2.1534256200000002e-10],
                           [1.302675e-10, 2.25629929e-10, 6.67570772e-10],
                           [2.60535e-10, 0.0, 2.2611410400000002e-10],
                           [1.27088973e-10, 7.3374853e-11, 0.0],
                           [-1.27088973e-10, 7.3374853e-11, 8.82913334e-10],
                           [0.0, -1.46749706e-10, 4.41456666e-10],
                           [-1.27088973e-10, -7.3374853e-11, 0.0],
                           [1.27088973e-10, -7.3374853e-11, 8.82913334e-10],
                           [0.0, 1.46749706e-10, 4.41456666e-10]],
        'lattice_vectors': [[2.60535e-10, -4.51259857e-10, 0.0],
                            [2.60535e-10, 4.51259857e-10, 0.0],
                            [0.0, 0.0, 1.32437e-09]],
        'normalized_wyckoff': {'b': {'X_1': 1},
                               'c': {'X_1': 1},
                               'f': {'X_0': 2},
                               'i': {'X_0': 2}},
        'normalized_wysytax': {'b': {'X_1': 1},
                               'c': {'X_1': 1},
                               'f': {'X_0': 2},
                               'i': {'X_0': 2}}},
       {'Notes': 'high quartz',
        'Pearsons Symbol': 'hP9',
        'Prototype': 'O2Si (beta)',
        'Space Group': 'P6222',
        'Space Group Number': 180,
        'Strukturbericht Designation': 'C8',
        'Wyckoff Positions': 'cj',
        'aflow_prototype_id': 'A2B_hP9_180_j_c',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2B_hP9_180_j_c.html',
        'atom_labels': ['O', 'O', 'O', 'O', 'O', 'O', 'Si', 'Si', 'Si'],
        'atom_positions': [[6.122369327155586e-10,
                            -2.841401493202755e-10,
                            1.4906346004999997e-09],
                           [1.2577726458119985e-09,
                            1.54540177568846e-11,
                            2.484391000833323e-09],
                           [1.6404839169764152e-10,
                            -1.0604254737334759e-09,
                            4.968782001666766e-10],
                           [1.0848018728023585e-09,
                            -1.1026466354263559e-09,
                            4.968782001666766e-10],
                           [-8.922381311998573e-12,
                            -2.1785261269167164e-09,
                            2.484391000833323e-09],
                           [6.366133317844415e-10,
                            -1.878931959839556e-09,
                            1.4906346004999997e-09],
                           [8.529805934149579e-10,
                            3.9586967108504256e-10,
                            1.9875128006666765e-09],
                           [-2.2855546116495788e-10,
                            -1.4774057256649583e-09,
                            0.0],
                           [6.2442513225e-10,
                            -1.0815360545799158e-09,
                            9.937564003333234e-10]],
        'lattice_vectors': [[2.49885e-10, -4.32813516049349e-10, 0.0],
                            [2.49885e-10, 4.32813516049349e-10, 0.0],
                            [0.0, 0.0, 5.4601e-10]],
        'normalized_wyckoff': {'c': {'X_1': 1}, 'j': {'X_0': 2}},
        'normalized_wysytax': {'c': {'X_1': 1}, 'j': {'X_0': 2}}}],
 182: [{'Notes': 'bainite',
        'Pearsons Symbol': 'hP8',
        'Prototype': 'CFe3',
        'Space Group': 'P6322',
        'Space Group Number': 182,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'dg',
        'aflow_prototype_id': 'AB3_hP8_182_c_g',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB3_hP8_182_c_g.html',
        'atom_labels': ['C', 'C', 'Fe', 'Fe', 'Fe', 'Fe', 'Fe', 'Fe'],
        'atom_positions': [[2.42535e-10,
                            1.4002764753790283e-10,
                            1.0513500000000001e-10],
                           [2.42535e-10, -1.4002764753790283e-10, 3.15405e-10],
                           [7.87996215e-11, 1.3648494805519114e-10, 0.0],
                           [1.6373537849999997e-10,
                            2.8359799455850883e-10,
                            2.1027000000000001e-10],
                           [7.87996215e-11, -1.3648494805519114e-10, 0.0],
                           [1.57599243e-10, 0.0, 2.1027000000000001e-10],
                           [1.6373537849999997e-10,
                            -2.8359799455850883e-10,
                            2.1027000000000001e-10],
                           [3.2747075699999995e-10, 0.0, 0.0]],
        'lattice_vectors': [[2.42535e-10, -4.200829426137e-10, 0.0],
                            [2.42535e-10, 4.200829426137e-10, 0.0],
                            [0.0, 0.0, 4.2054e-10]],
        'normalized_wyckoff': {'c': {'X_1': 1}, 'g': {'X_0': 3}},
        'normalized_wysytax': {'c': {'X_1': 1}, 'g': {'X_0': 3}}}],
 186: [{'Notes': '-',
        'Pearsons Symbol': 'hP18',
        'Prototype': 'Al5C3N',
        'Space Group': 'P63mc',
        'Space Group Number': 186,
        'Strukturbericht Designation': 'E94',
        'Wyckoff Positions': 'a4b5',
        'aflow_prototype_id': 'A5B3C_hP18_186_2a3b_2ab_b',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A5B3C_hP18_186_2a3b_2ab_b.html',
        'atom_labels': ['Al',
                        'Al',
                        'Al',
                        'Al',
                        'Al',
                        'Al',
                        'Al',
                        'Al',
                        'Al',
                        'Al',
                        'C',
                        'C',
                        'C',
                        'C',
                        'C',
                        'C',
                        'N',
                        'N'],
        'atom_positions': [[0.0, 0.0, 3.2325e-10],
                           [0.0, 0.0, 1.4007500000000002e-09],
                           [1.64e-10, 9.4685444e-11, 9.58975e-11],
                           [1.64e-10, -9.4685444e-11, 1.1733975e-09],
                           [1.64e-10, 9.4685444e-11, 9.826800000000002e-10],
                           [1.64e-10, -9.4685444e-11, 2.0601800000000002e-09],
                           [0.0, 0.0, 7.434750000000001e-10],
                           [0.0, 0.0, 1.8209750000000001e-09],
                           [1.64e-10, 9.4685444e-11, 5.172e-10],
                           [1.64e-10, -9.4685444e-11, 1.5946999999999999e-09],
                           [1.64e-10, 9.4685444e-11, 2.8661500000000005e-10],
                           [1.64e-10, -9.4685444e-11, 1.364115e-09],
                           [0.0, 0.0, 3.017e-12],
                           [0.0, 0.0, 1.080517e-09],
                           [1.64e-10, 9.4685444e-11, 7.951950000000001e-10],
                           [1.64e-10, -9.4685444e-11, 1.872695e-09],
                           [0.0, 0.0, 5.3875e-10],
                           [0.0, 0.0, 1.6162500000000003e-09]],
        'lattice_vectors': [[1.64e-10, -2.84056332e-10, 0.0],
                            [1.64e-10, 2.84056332e-10, 0.0],
                            [0.0, 0.0, 2.155e-09]],
        'normalized_wyckoff': {'a': {'X_0': 2, 'X_1': 1, 'X_2': 1},
                               'b': {'X_0': 3, 'X_1': 2}},
        'normalized_wysytax': {'a': {'X_0': 2, 'X_1': 1, 'X_2': 1},
                               'b': {'X_0': 3, 'X_1': 2}}},
       {'Notes': '-',
        'Pearsons Symbol': 'hP4',
        'Prototype': 'BN',
        'Space Group': 'P63mc',
        'Space Group Number': 186,
        'Strukturbericht Designation': 'B12',
        'Wyckoff Positions': 'ab',
        'aflow_prototype_id': 'AB_hP4_186_b_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_hP4_186_b_a.html',
        'atom_labels': ['B', 'B', 'N', 'N'],
        'atom_positions': [[1.2550000000000003e-10,
                            7.245745878329946e-11,
                            3.3499999999999994e-11],
                           [1.2550000000000003e-10,
                            -7.245745878329946e-11,
                            3.6849999999999997e-10],
                           [0.0, 0.0, 0.0],
                           [0.0, 0.0, 3.35e-10]],
        'lattice_vectors': [[1.255e-10, -2.17372376349894e-10, 0.0],
                            [1.255e-10, 2.17372376349894e-10, 0.0],
                            [0.0, 0.0, 6.7e-10]],
        'normalized_wyckoff': {'a': {'X_0': 1}, 'b': {'X_1': 1}},
        'normalized_wysytax': {'a': {'X_0': 1}, 'b': {'X_1': 1}}},
       {'Notes': 'buckled graphite',
        'Pearsons Symbol': 'hP4',
        'Prototype': 'C',
        'Space Group': 'P63mc',
        'Space Group Number': 186,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'ab',
        'aflow_prototype_id': 'A_hP4_186_ab',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_hP4_186_ab.html',
        'atom_labels': ['C', 'C', 'C', 'C'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [0.0, 0.0, 3.4000000000000007e-10],
                           [1.235e-10,
                            7.130275824493479e-11,
                            4.857142857142761e-11],
                           [1.235e-10,
                            -7.130275824493479e-11,
                            3.8857142857142764e-10]],
        'lattice_vectors': [[1.235e-10, -2.139082747348e-10, 0.0],
                            [1.235e-10, 2.139082747348e-10, 0.0],
                            [0.0, 0.0, 6.8e-10]],
        'normalized_wyckoff': {'a': {'X_0': 1}, 'b': {'X_0': 1}},
        'normalized_wysytax': {'a': {'X_0': 1}, 'b': {'X_0': 1}}},
       {'Notes': 'moissanite-6H',
        'Pearsons Symbol': 'hP12',
        'Prototype': 'CSi',
        'Space Group': 'P63mc',
        'Space Group Number': 186,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'a2b4',
        'aflow_prototype_id': 'AB_hP12_186_a2b_a2b',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_hP12_186_a2b_a2b.html',
        'atom_labels': ['C',
                        'C',
                        'C',
                        'C',
                        'C',
                        'C',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si'],
        'atom_positions': [[0.0, 0.0, 1.896017904e-10],
                           [0.0, 0.0, 9.455897903999999e-10],
                           [1.540645e-10,
                            8.894918054756679e-11,
                            4.41718748480005e-10],
                           [1.540645e-10,
                            -8.894918054756679e-11,
                            1.197706748480005e-09],
                           [1.540645e-10,
                            8.894918054756679e-11,
                            -6.274196408000504e-11],
                           [1.540645e-10,
                            -8.894918054756679e-11,
                            6.932460359199949e-10],
                           [0.0, 0.0, 0.0],
                           [0.0, 0.0, 7.55988e-10],
                           [1.540645e-10,
                            8.894918054756679e-11,
                            2.5211695808000503e-10],
                           [1.540645e-10,
                            -8.894918054756679e-11,
                            1.0081049580800049e-09],
                           [1.540645e-10,
                            8.894918054756679e-11,
                            1.260237035919995e-09],
                           [1.540645e-10,
                            -8.894918054756679e-11,
                            5.04249035919995e-10]],
        'lattice_vectors': [[1.540645e-10, -2.66847541642695e-10, 0.0],
                            [1.540645e-10, 2.66847541642695e-10, 0.0],
                            [0.0, 0.0, 1.511976e-09]],
        'normalized_wyckoff': {'a': {'X_0': 1, 'X_1': 1},
                               'b': {'X_0': 2, 'X_1': 2}},
        'normalized_wysytax': {'a': {'X_0': 1, 'X_1': 1},
                               'b': {'X_0': 2, 'X_1': 2}}},
       {'Notes': 'moissanite-4H',
        'Pearsons Symbol': 'hP8',
        'Prototype': 'CSi',
        'Space Group': 'P63mc',
        'Space Group Number': 186,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'a2b2',
        'aflow_prototype_id': 'AB_hP8_186_ab_ab',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_hP8_186_ab_ab.html',
        'atom_labels': ['C', 'C', 'C', 'C', 'Si', 'Si', 'Si', 'Si'],
        'atom_positions': [[0.0, 0.0, 1.8943036199999998e-10],
                           [0.0, 0.0, 6.93670362e-10],
                           [1.540255e-10,
                            8.892666388706845e-11,
                            4.40415822e-10],
                           [1.540255e-10,
                            -8.892666388706845e-11,
                            -6.382417799999999e-11],
                           [0.0, 0.0, 0.0],
                           [0.0, 0.0, 5.0424e-10],
                           [1.540255e-10,
                            8.892666388706845e-11,
                            2.51943516e-10],
                           [1.540255e-10,
                            -8.892666388706845e-11,
                            7.561835160000001e-10]],
        'lattice_vectors': [[1.540255e-10, -2.667799916612e-10, 0.0],
                            [1.540255e-10, 2.667799916612e-10, 0.0],
                            [0.0, 0.0, 1.00848e-09]],
        'normalized_wyckoff': {'a': {'X_0': 1, 'X_1': 1},
                               'b': {'X_0': 1, 'X_1': 1}},
        'normalized_wysytax': {'a': {'X_0': 1, 'X_1': 1},
                               'b': {'X_0': 1, 'X_1': 1}}},
       {'Notes': 'wurtzite',
        'Pearsons Symbol': 'hP4',
        'Prototype': 'SZn',
        'Space Group': 'P63mc',
        'Space Group Number': 186,
        'Strukturbericht Designation': 'B4',
        'Wyckoff Positions': 'b2',
        'aflow_prototype_id': 'AB_hP4_186_b_b',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_hP4_186_b_b.html',
        'atom_labels': ['Zn', 'Zn', 'S', 'S'],
        'atom_positions': [[1.91135e-10,
                            1.1035184370156889e-10,
                            2.34651036e-10],
                           [1.91135e-10,
                            -1.1035184370156889e-10,
                            5.476860360000001e-10],
                           [1.91135e-10, 1.1035184370156889e-10, 0.0],
                           [1.91135e-10, -1.1035184370156889e-10, 3.13035e-10]],
        'lattice_vectors': [[1.91135e-10, -3.310555311047e-10, 0.0],
                            [1.91135e-10, 3.310555311047e-10, 0.0],
                            [0.0, 0.0, 6.2607e-10]],
        'normalized_wyckoff': {'b': {'X_0': 1, 'X_1': 1}},
        'normalized_wysytax': {'b': {'X_0': 1, 'X_1': 1}}}],
 187: [{'Notes': '-',
        'Pearsons Symbol': 'hP3',
        'Prototype': 'BaPtSb',
        'Space Group': 'P6m2',
        'Space Group Number': 187,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'adf',
        'aflow_prototype_id': 'ABC_hP3_187_a_d_f',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/ABC_hP3_187_a_d_f.html',
        'atom_labels': ['Ba', 'Pt', 'Sb'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [2.2675000000000002e-10,
                            1.30914174e-10,
                            2.4420000000000005e-10],
                           [2.2675000000000002e-10,
                            -1.30914174e-10,
                            2.4420000000000005e-10]],
        'lattice_vectors': [[2.2675000000000002e-10,
                             -3.9274252100000003e-10,
                             0.0],
                            [2.2675000000000002e-10,
                             3.9274252100000003e-10,
                             0.0],
                            [0.0, 0.0, 4.884000000000001e-10]],
        'normalized_wyckoff': {'a': {'X_0': 1},
                               'd': {'X_1': 1},
                               'e': {'X_2': 1}},
        'normalized_wysytax': {'a': {'X_0': 1},
                               'd': {'X_1': 1},
                               'f': {'X_2': 1}}},
       {'Notes': '-',
        'Pearsons Symbol': 'hP2',
        'Prototype': 'CW',
        'Space Group': 'P6m2',
        'Space Group Number': 187,
        'Strukturbericht Designation': 'Bh',
        'Wyckoff Positions': 'af',
        'aflow_prototype_id': 'AB_hP2_187_d_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_hP2_187_d_a.html',
        'atom_labels': ['W', 'C'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [1.453e-10, -8.3888994e-11, 1.4185e-10]],
        'lattice_vectors': [[1.453e-10, -2.5166698200000005e-10, 0.0],
                            [1.453e-10, 2.5166698200000005e-10, 0.0],
                            [0.0, 0.0, 2.837e-10]],
        'normalized_wyckoff': {'a': {'X_0': 1}, 'f': {'X_1': 1}},
        'normalized_wysytax': {'a': {'X_0': 1}, 'f': {'X_1': 1}}}],
 189: [{'Notes': 'revised structure',
        'Pearsons Symbol': 'hP9',
        'Prototype': 'Fe2P',
        'Space Group': 'P62m',
        'Space Group Number': 189,
        'Strukturbericht Designation': 'C22',
        'Wyckoff Positions': 'bcfg',
        'aflow_prototype_id': 'A2B_hP9_189_fg_bc',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2B_hP9_189_fg_bc.html',
        'atom_labels': ['Fe', 'Fe', 'Fe', 'Fe', 'Fe', 'Fe', 'P', 'P', 'P'],
        'atom_positions': [[7.605000000000001e-11, 1.3172246391561322e-10, 0.0],
                           [7.605000000000001e-11,
                            -1.3172246391561322e-10,
                            0.0],
                           [4.329000000000001e-10, 0.0, 0.0],
                           [1.7550000000000001e-10,
                            3.0397491672833817e-10,
                            1.7250000000000002e-10],
                           [2.34e-10, 0.0, 1.7250000000000002e-10],
                           [1.7550000000000001e-10,
                            -3.0397491672833817e-10,
                            1.7250000000000002e-10],
                           [0.0, 0.0, 1.7250000000000002e-10],
                           [2.925e-10,
                            1.6887495373796907e-10,
                            -4.3125000000000006e-11],
                           [2.925e-10,
                            -1.6887495373796907e-10,
                            4.3125000000000006e-11]],
        'lattice_vectors': [[2.925e-10, -5.06624861213897e-10, 0.0],
                            [2.925e-10, 5.06624861213897e-10, 0.0],
                            [0.0, 0.0, 3.45e-10]]}],
 191: [{'Notes': 'hexagonal omega',
        'Pearsons Symbol': 'hP3',
        'Prototype': 'AlB2',
        'Space Group': 'P6/mmm',
        'Space Group Number': 191,
        'Strukturbericht Designation': 'C32',
        'Wyckoff Positions': 'ad',
        'aflow_prototype_id': 'AB2_hP3_191_a_d',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB2_hP3_191_a_d.html',
        'atom_labels': ['Al', 'B', 'B'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [1.5025e-10, 8.6746878e-11, 1.6285e-10],
                           [1.5025e-10, -8.6746878e-11, 1.6285e-10]],
        'lattice_vectors': [[1.5025e-10, -2.60240634e-10, 0.0],
                            [1.5025e-10, 2.60240634e-10, 0.0],
                            [0.0, 0.0, 3.257e-10]],
        'normalized_wyckoff': {'a': {'X_1': 1}, 'd': {'X_0': 2}},
        'normalized_wysytax': {'a': {'X_1': 1}, 'd': {'X_0': 2}}},
       {'Notes': 'doubled omega',
        'Pearsons Symbol': 'hP6',
        'Prototype': 'AlB4Mg',
        'Space Group': 'P6/mmm',
        'Space Group Number': 191,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'abh',
        'aflow_prototype_id': 'AB4C_hP6_191_a_h_b',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB4C_hP6_191_a_h_b.html',
        'atom_labels': ['Al', 'Mg', 'B', 'B', 'B', 'B'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [0.0, 0.0, 3.35624e-10],
                           [1.5221800000000003e-10,
                            8.7883103e-11,
                            1.6197214200000002e-10],
                           [1.5221800000000003e-10,
                            -8.7883103e-11,
                            1.6197214200000002e-10],
                           [1.5221800000000003e-10,
                            -8.7883103e-11,
                            -1.6197214200000002e-10],
                           [1.5221800000000003e-10,
                            8.7883103e-11,
                            -1.6197214200000002e-10]],
        'lattice_vectors': [[1.5221800000000003e-10, -2.6364931e-10, 0.0],
                            [1.5221800000000003e-10, 2.6364931e-10, 0.0],
                            [0.0, 0.0, 6.71248e-10]],
        'normalized_wyckoff': {'a': {'X_1': 1},
                               'b': {'X_2': 1},
                               'h': {'X_0': 4}},
        'normalized_wysytax': {'a': {'X_1': 1},
                               'b': {'X_2': 1},
                               'h': {'X_0': 4}}},
       {'Notes': '-',
        'Pearsons Symbol': 'hP6',
        'Prototype': 'CaCu5',
        'Space Group': 'P6/mmm',
        'Space Group Number': 191,
        'Strukturbericht Designation': 'D2d',
        'Wyckoff Positions': 'acg',
        'aflow_prototype_id': 'AB5_hP6_191_a_cg',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB5_hP6_191_a_cg.html',
        'atom_labels': ['Ca', 'Cu', 'Cu', 'Cu', 'Cu', 'Cu'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [2.541e-10, 1.46704703e-10, 0.0],
                           [2.541e-10, -1.46704703e-10, 0.0],
                           [1.2705e-10,
                            -2.2005705500000003e-10,
                            2.0390000000000001e-10],
                           [1.2705e-10,
                            2.2005705500000003e-10,
                            2.0390000000000001e-10],
                           [2.541e-10, 0.0, 2.0390000000000001e-10]],
        'lattice_vectors': [[2.541e-10, -4.4011411000000005e-10, 0.0],
                            [2.541e-10, 4.4011411000000005e-10, 0.0],
                            [0.0, 0.0, 4.0780000000000003e-10]],
        'normalized_wyckoff': {'b': {'X_1': 1},
                               'd': {'X_0': 2},
                               'f': {'X_0': 3}},
        'normalized_wysytax': {'a': {'X_1': 1},
                               'c': {'X_0': 2},
                               'g': {'X_0': 3}}},
       {'Notes': '-',
        'Pearsons Symbol': 'hP6',
        'Prototype': 'CoSn',
        'Space Group': 'P6/mmm',
        'Space Group Number': 191,
        'Strukturbericht Designation': 'B35',
        'Wyckoff Positions': 'adf',
        'aflow_prototype_id': 'AB_hP6_191_f_ad',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_hP6_191_f_ad.html',
        'atom_labels': ['Sn', 'Sn', 'Sn', 'Co', 'Co', 'Co'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [2.634e-10, 1.52074061e-10, 2.1245e-10],
                           [2.634e-10, -1.52074061e-10, 2.1245e-10],
                           [1.317e-10, -2.2811109100000002e-10, 0.0],
                           [1.317e-10, 2.2811109100000002e-10, 0.0],
                           [2.634e-10, 0.0, 0.0]],
        'lattice_vectors': [[2.634e-10, -4.5622218300000003e-10, 0.0],
                            [2.634e-10, 4.5622218300000003e-10, 0.0],
                            [0.0, 0.0, 4.249e-10]],
        'normalized_wyckoff': {'a': {'X_0': 1},
                               'd': {'X_0': 2},
                               'f': {'X_1': 3}},
        'normalized_wysytax': {'a': {'X_0': 1},
                               'd': {'X_0': 2},
                               'f': {'X_1': 3}}},
       {'Notes': '-',
        'Pearsons Symbol': 'hP6',
        'Prototype': 'Cu2Te',
        'Space Group': 'P6/mmm',
        'Space Group Number': 191,
        'Strukturbericht Designation': 'Ch',
        'Wyckoff Positions': 'ch',
        'aflow_prototype_id': 'A2B_hP6_191_h_e',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2B_hP6_191_h_e.html',
        'atom_labels': ['Te', 'Te', 'Cu', 'Cu', 'Cu', 'Cu'],
        'atom_positions': [[0.0, 0.0, 2.225844e-10],
                           [0.0, 0.0, -2.225844e-10],
                           [2.1185000000000002e-10,
                            1.2231165500000002e-10,
                            1.16384e-10],
                           [2.1185000000000002e-10,
                            -1.2231165500000002e-10,
                            1.16384e-10],
                           [2.1185000000000002e-10,
                            1.2231165500000002e-10,
                            -1.16384e-10],
                           [2.1185000000000002e-10,
                            -1.2231165500000002e-10,
                            -1.16384e-10]],
        'lattice_vectors': [[2.1185000000000002e-10,
                             -3.6693496400000004e-10,
                             0.0],
                            [2.1185000000000002e-10,
                             3.6693496400000004e-10,
                             0.0],
                            [0.0, 0.0, 7.274e-10]],
        'normalized_wyckoff': {'e': {'X_1': 1}, 'h': {'X_0': 2}},
        'normalized_wysytax': {'e': {'X_1': 1}, 'h': {'X_0': 2}}},
       {'Notes': 'simple hexagonal',
        'Pearsons Symbol': 'hP1',
        'Prototype': 'HgSn6-10 (gamma)',
        'Space Group': 'P6/mmm',
        'Space Group Number': 191,
        'Strukturbericht Designation': 'Af',
        'Wyckoff Positions': 'a',
        'aflow_prototype_id': 'A_hP1_191_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_hP1_191_a.html',
        'atom_labels': ['Au'],
        'atom_positions': [[0.0, 0.0, 0.0]],
        'lattice_vectors': [[1.6050000000000001e-10,
                             -2.7799415500000004e-10,
                             0.0],
                            [1.6050000000000001e-10,
                             2.7799415500000004e-10,
                             0.0],
                            [0.0, 0.0, 2.9900000000000005e-10]],
        'normalized_wyckoff': {'a': {'X_0': 1}},
        'normalized_wysytax': {'a': {'X_0': 1}}},
       {'Notes': '-',
        'Pearsons Symbol': 'hP4',
        'Prototype': 'Li3N',
        'Space Group': 'P6/mmm',
        'Space Group Number': 191,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'abc',
        'aflow_prototype_id': 'A3B_hP4_191_bc_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A3B_hP4_191_bc_a.html',
        'atom_labels': ['N', 'Li', 'Li', 'Li'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [0.0, 0.0, 1.945e-10],
                           [1.8325000000000001e-10, 1.05799439e-10, 0.0],
                           [1.8325000000000001e-10, -1.05799439e-10, 0.0]],
        'lattice_vectors': [[1.8325000000000001e-10,
                             -3.1739831000000003e-10,
                             0.0],
                            [1.8325000000000001e-10,
                             3.1739831000000003e-10,
                             0.0],
                            [0.0, 0.0, 3.89e-10]],
        'normalized_wyckoff': {'a': {'X_1': 1},
                               'b': {'X_0': 1},
                               'c': {'X_0': 2}},
        'normalized_wysytax': {'a': {'X_1': 1},
                               'b': {'X_0': 1},
                               'c': {'X_0': 2}}}],
 194: [{'Notes': 'some MAX phase',
        'Pearsons Symbol': 'hP8',
        'Prototype': 'AlCCr2',
        'Space Group': 'P63/mmc',
        'Space Group Number': 194,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'adf',
        'aflow_prototype_id': 'ABC2_hP8_194_d_a_f',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/ABC2_hP8_194_d_a_f.html',
        'atom_labels': ['C', 'C', 'Al', 'Al', 'Cr', 'Cr', 'Cr', 'Cr'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [0.0, 0.0, 6.410000000000001e-10],
                           [1.43e-10, -8.2561088e-11, 3.2050000000000003e-10],
                           [1.43e-10, 8.2561088e-11, 9.615e-10],
                           [1.43e-10, 8.2561088e-11, 1.10252e-10],
                           [1.43e-10, -8.2561088e-11, 7.512520000000001e-10],
                           [1.43e-10, -8.2561088e-11, -1.10252e-10],
                           [1.43e-10, 8.2561088e-11, 5.30748e-10]],
        'lattice_vectors': [[1.43e-10, -2.47683265e-10, 0.0],
                            [1.43e-10, 2.47683265e-10, 0.0],
                            [0.0, 0.0, 1.2820000000000001e-09]],
        'normalized_wyckoff': {'a': {'X_1': 1},
                               'd': {'X_2': 1},
                               'f': {'X_0': 2}},
        'normalized_wysytax': {'a': {'X_1': 1},
                               'd': {'X_2': 1},
                               'f': {'X_0': 2}}},
       {'Notes': 'MAX phase',
        'Pearsons Symbol': 'hP16',
        'Prototype': 'AlN3Ti4',
        'Space Group': 'P63/mmc',
        'Space Group Number': 194,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'acef2',
        'aflow_prototype_id': 'AB3C4_hP16_194_c_af_ef',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB3C4_hP16_194_c_af_ef.html',
        'atom_labels': ['N',
                        'N',
                        'Al',
                        'Al',
                        'Ti',
                        'Ti',
                        'Ti',
                        'Ti',
                        'Ti',
                        'Ti',
                        'Ti',
                        'Ti',
                        'N',
                        'N',
                        'N',
                        'N'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [0.0, 0.0, 1.1686e-09],
                           [1.494e-10, 8.625613e-11, 5.843e-10],
                           [1.494e-10, -8.625613e-11, 1.7529e-09],
                           [1.494e-10, 8.625613e-11, 1.2597508e-10],
                           [1.494e-10, -8.625613e-11, 1.29457508e-09],
                           [1.494e-10, -8.625613e-11, -1.2597508e-10],
                           [1.494e-10, 8.625613e-11, 1.04262492e-09],
                           [0.0, 0.0, 3.6062996e-10],
                           [0.0, 0.0, 1.5292299600000001e-09],
                           [0.0, 0.0, -3.6062996e-10],
                           [0.0, 0.0, 8.0797004e-10],
                           [1.494e-10, 8.625613e-11, 1.4140060000000001e-09],
                           [1.494e-10, -8.625613e-11, 2.45406e-10],
                           [1.494e-10, -8.625613e-11, 9.23194e-10],
                           [1.494e-10, 8.625613e-11, -2.45406e-10]],
        'lattice_vectors': [[1.494e-10, -2.58768391e-10, 0.0],
                            [1.494e-10, 2.58768391e-10, 0.0],
                            [0.0, 0.0, 2.3372e-09]],
        'normalized_wyckoff': {'a': {'X_1': 1},
                               'c': {'X_2': 1},
                               'e': {'X_0': 2},
                               'f': {'X_0': 2, 'X_1': 2}},
        'normalized_wysytax': {'a': {'X_1': 1},
                               'c': {'X_2': 1},
                               'e': {'X_0': 2},
                               'f': {'X_0': 2, 'X_1': 2}}},
       {'Notes': '-',
        'Pearsons Symbol': 'hP8',
        'Prototype': 'AsNa3',
        'Space Group': 'P63/mmc',
        'Space Group Number': 194,
        'Strukturbericht Designation': 'D018',
        'Wyckoff Positions': 'bcf',
        'aflow_prototype_id': 'AB3_hP8_194_c_bf',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB3_hP8_194_c_bf.html',
        'atom_labels': ['As', 'As', 'Na', 'Na', 'Na', 'Na', 'Na', 'Na'],
        'atom_positions': [[2.544e-10, 1.46877911e-10, 2.2455e-10],
                           [2.544e-10, -1.46877911e-10, 6.7365e-10],
                           [0.0, 0.0, 2.2455e-10],
                           [0.0, 0.0, 6.7365e-10],
                           [2.544e-10, 1.46877911e-10, 5.236506e-10],
                           [2.544e-10, -1.46877911e-10, 3.745494e-10],
                           [2.544e-10, -1.46877911e-10, 7.45506e-11],
                           [2.544e-10, 1.46877911e-10, -7.45506e-11]],
        'lattice_vectors': [[2.544e-10, -4.40633725e-10, 0.0],
                            [2.544e-10, 4.40633725e-10, 0.0],
                            [0.0, 0.0, 8.982e-10]],
        'normalized_wyckoff': {'b': {'X_0': 1},
                               'c': {'X_1': 1},
                               'f': {'X_0': 2}},
        'normalized_wysytax': {'b': {'X_0': 1},
                               'c': {'X_1': 1},
                               'f': {'X_0': 2}}},
       {'Notes': '-',
        'Pearsons Symbol': 'hP4',
        'Prototype': 'AsNi',
        'Space Group': 'P63/mmc',
        'Space Group Number': 194,
        'Strukturbericht Designation': 'B81',
        'Wyckoff Positions': 'ac',
        'aflow_prototype_id': 'AB_hP4_194_c_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_hP4_194_c_a.html',
        'atom_labels': ['Ni', 'Ni', 'As', 'As'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [0.0, 0.0, 2.517e-10],
                           [1.8095e-10, 1.0447153300000001e-10, 1.2585e-10],
                           [1.8095e-10, -1.0447153300000001e-10, 3.7755e-10]],
        'lattice_vectors': [[1.8095e-10, -3.13414594e-10, 0.0],
                            [1.8095e-10, 3.13414594e-10, 0.0],
                            [0.0, 0.0, 5.034e-10]],
        'normalized_wyckoff': {'a': {'X_0': 1}, 'c': {'X_1': 1}},
        'normalized_wysytax': {'a': {'X_0': 1}, 'c': {'X_1': 1}}},
       {'Notes': '-',
        'Pearsons Symbol': 'hP8',
        'Prototype': 'AsTi',
        'Space Group': 'P63/mmc',
        'Space Group Number': 194,
        'Strukturbericht Designation': 'Bi',
        'Wyckoff Positions': 'adf',
        'aflow_prototype_id': 'AB_hP8_194_ad_f',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_hP8_194_ad_f.html',
        'atom_labels': ['As', 'As', 'As', 'As', 'Ti', 'Ti', 'Ti', 'Ti'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [0.0, 0.0, 6.032e-10],
                           [1.821e-10, -1.0513548399999999e-10, 3.016e-10],
                           [1.821e-10, 1.0513548399999999e-10, 9.048e-10],
                           [1.821e-10, 1.0513548399999999e-10, 1.508e-10],
                           [1.821e-10, 1.0513548399999999e-10, 4.524e-10],
                           [1.821e-10, -1.0513548399999999e-10, -1.508e-10],
                           [1.821e-10, -1.0513548399999999e-10, 7.54e-10]],
        'lattice_vectors': [[1.821e-10, -3.15406452e-10, 0.0],
                            [1.821e-10, 3.15406452e-10, 0.0],
                            [0.0, 0.0, 1.2064e-09]],
        'normalized_wyckoff': {'a': {'X_0': 1},
                               'd': {'X_0': 1},
                               'f': {'X_1': 2}},
        'normalized_wysytax': {'a': {'X_0': 1},
                               'd': {'X_0': 1},
                               'f': {'X_1': 2}}},
       {'Notes': '-',
        'Pearsons Symbol': 'hP6',
        'Prototype': 'BCLi',
        'Space Group': 'P63/mmc',
        'Space Group Number': 194,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'ac2',
        'aflow_prototype_id': 'ABC_hP6_194_c_d_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/ABC_hP6_194_c_d_a.html',
        'atom_labels': ['Li', 'Li', 'B', 'B', 'C', 'C'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [0.0, 0.0, 3.529e-10],
                           [1.3750000000000002e-10, 7.9385662e-11, 1.7645e-10],
                           [1.3750000000000002e-10, -7.9385662e-11, 5.2935e-10],
                           [1.3750000000000002e-10, -7.9385662e-11, 1.7645e-10],
                           [1.3750000000000002e-10, 7.9385662e-11, 5.2935e-10]],
        'lattice_vectors': [[1.3750000000000002e-10, -2.38156986e-10, 0.0],
                            [1.3750000000000002e-10, 2.38156986e-10, 0.0],
                            [0.0, 0.0, 7.058e-10]],
        'normalized_wyckoff': {'a': {'X_0': 1},
                               'c': {'X_1': 1},
                               'd': {'X_2': 1}},
        'normalized_wysytax': {'a': {'X_0': 1},
                               'c': {'X_1': 1},
                               'd': {'X_2': 1}}},
       {'Notes': '-',
        'Pearsons Symbol': 'hP4',
        'Prototype': 'BN',
        'Space Group': 'P63/mmc',
        'Space Group Number': 194,
        'Strukturbericht Designation': 'Bk',
        'Wyckoff Positions': 'cd',
        'aflow_prototype_id': 'AB_hP4_194_c_d',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_hP4_194_c_d.html',
        'atom_labels': ['B', 'B', 'N', 'N'],
        'atom_positions': [[1.2519950000000001e-10,
                            7.228396502740813e-11,
                            1.6653000000000002e-10],
                           [1.2519950000000001e-10,
                            -7.228396502740813e-11,
                            4.9959e-10],
                           [1.2519950000000001e-10,
                            7.228396502740813e-11,
                            4.9959e-10],
                           [1.2519950000000001e-10,
                            -7.228396502740813e-11,
                            1.6653000000000002e-10]],
        'lattice_vectors': [[1.251995e-10, -2.1685189508222e-10, 0.0],
                            [1.251995e-10, 2.1685189508222e-10, 0.0],
                            [0.0, 0.0, 6.6612e-10]],
        'normalized_wyckoff': {'c': {'X_0': 1}, 'd': {'X_1': 1}},
        'normalized_wysytax': {'c': {'X_0': 1}, 'd': {'X_1': 1}}},
       {'Notes': '-',
        'Pearsons Symbol': 'hP14',
        'Prototype': 'B5W2',
        'Space Group': 'P63/mmc',
        'Space Group Number': 194,
        'Strukturbericht Designation': 'D8h',
        'Wyckoff Positions': 'abdf2',
        'aflow_prototype_id': 'A5B2_hP14_194_abdf_f',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A5B2_hP14_194_abdf_f.html',
        'atom_labels': ['B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'W',
                        'W',
                        'W',
                        'W'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [0.0, 0.0, 6.935e-10],
                           [0.0, 0.0, 3.4675e-10],
                           [0.0, 0.0, 1.04025e-09],
                           [1.491e-10, -8.6082925e-11, 3.4675e-10],
                           [1.491e-10, 8.6082925e-11, 1.04025e-09],
                           [1.491e-10, 8.6082925e-11, -3.8836e-11],
                           [1.491e-10, -8.6082925e-11, 3.8836e-11],
                           [1.491e-10, -8.6082925e-11, 6.54664e-10],
                           [1.491e-10, 8.6082925e-11, 7.32336e-10],
                           [1.491e-10, 8.6082925e-11, 1.92793e-10],
                           [1.491e-10, -8.6082925e-11, -1.92793e-10],
                           [1.491e-10, -8.6082925e-11, 8.862930000000001e-10],
                           [1.491e-10, 8.6082925e-11, 5.00707e-10]],
        'lattice_vectors': [[1.491e-10, -2.58248775e-10, 0.0],
                            [1.491e-10, 2.58248775e-10, 0.0],
                            [0.0, 0.0, 1.387e-09]],
        'normalized_wyckoff': {'a': {'X_0': 1},
                               'b': {'X_0': 1},
                               'd': {'X_0': 1},
                               'f': {'X_0': 2, 'X_1': 2}},
        'normalized_wysytax': {'a': {'X_0': 1},
                               'b': {'X_0': 1},
                               'd': {'X_0': 1},
                               'f': {'X_0': 2, 'X_1': 2}}},
       {'Notes': 'graphite',
        'Pearsons Symbol': 'hP4',
        'Prototype': 'C',
        'Space Group': 'P63/mmc',
        'Space Group Number': 194,
        'Strukturbericht Designation': 'A9',
        'Wyckoff Positions': 'bc',
        'aflow_prototype_id': 'A_hP4_194_bc',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_hP4_194_bc.html',
        'atom_labels': ['C', 'C', 'C', 'C'],
        'atom_positions': [[0.0, 0.0, 1.6777500000000002e-10],
                           [0.0, 0.0, 5.03325e-10],
                           [1.232e-10,
                            7.112955316416345e-11,
                            1.6777500000000002e-10],
                           [1.232e-10, -7.112955316416345e-11, 5.03325e-10]],
        'lattice_vectors': [[1.232e-10, -2.13388659492486e-10, 0.0],
                            [1.232e-10, 2.13388659492486e-10, 0.0],
                            [0.0, 0.0, 6.711e-10]],
        'normalized_wyckoff': {'b': {'X_0': 1}, 'c': {'X_0': 1}},
        'normalized_wysytax': {'b': {'X_0': 1}, 'c': {'X_0': 1}}},
       {'Notes': 'lonsdaleite',
        'Pearsons Symbol': 'hP4',
        'Prototype': 'C',
        'Space Group': 'P63/mmc',
        'Space Group Number': 194,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'f',
        'aflow_prototype_id': 'A_hP4_194_f',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_hP4_194_f.html',
        'atom_labels': ['C', 'C', 'C', 'C'],
        'atom_positions': [[1.254e-10,
                            7.239972375636814e-11,
                            2.50749999999637e-11],
                           [1.254e-10,
                            7.239972375636814e-11,
                            1.840750000000363e-10],
                           [1.254e-10,
                            -7.239972375636814e-11,
                            -2.50749999999637e-11],
                           [1.254e-10,
                            -7.239972375636814e-11,
                            2.342249999999637e-10]],
        'lattice_vectors': [[1.254e-10, -2.171991712691e-10, 0.0],
                            [1.254e-10, 2.171991712691e-10, 0.0],
                            [0.0, 0.0, 4.183e-10]],
        'normalized_wyckoff': {'f': {'X_0': 1}},
        'normalized_wysytax': {'f': {'X_0': 1}}},
       {'Notes': '3-member ring',
        'Pearsons Symbol': 'hP6',
        'Prototype': 'C (3-ring)',
        'Space Group': 'P63/mmc',
        'Space Group Number': 194,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'h',
        'aflow_prototype_id': 'A_hP6_194_h',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_hP6_194_h.html',
        'atom_labels': ['C', 'C', 'C', 'C', 'C', 'C'],
        'atom_positions': [[1.4447241861255155e-10,
                            1.7087975555866427e-10,
                            6.264156415682575e-11],
                           [2.20222418612552e-10,
                            3.967690688532104e-11,
                            6.264156415682575e-11],
                           [2.959724186125503e-10,
                            1.7087975555866047e-10,
                            6.264156415682575e-11],
                           [1.4447241861255155e-10,
                            -1.7087975555866427e-10,
                            1.8792469247047728e-10],
                           [2.20222418612552e-10,
                            -3.967690688532104e-11,
                            1.8792469247047728e-10],
                           [2.959724186125503e-10,
                            -1.7087975555866047e-10,
                            1.8792469247047728e-10]],
        'lattice_vectors': [[2.20222418612552e-10, -3.81436418002642e-10, 0.0],
                            [2.20222418612552e-10, 3.81436418002642e-10, 0.0],
                            [0.0, 0.0, 2.50566256627303e-10]],
        'normalized_wyckoff': {'h': {'X_0': 1}},
        'normalized_wysytax': {'h': {'X_0': 1}}},
       {'Notes': 'some MAX phase',
        'Pearsons Symbol': 'hP12',
        'Prototype': 'CMo',
        'Space Group': 'P63/mmc',
        'Space Group Number': 194,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'abf2',
        'aflow_prototype_id': 'AB_hP12_194_af_bf',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_hP12_194_af_bf.html',
        'atom_labels': ['C',
                        'C',
                        'Mo',
                        'Mo',
                        'C',
                        'C',
                        'C',
                        'C',
                        'Mo',
                        'Mo',
                        'Mo',
                        'Mo'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [0.0, 0.0, 7.305e-10],
                           [0.0, 0.0, 3.6525e-10],
                           [0.0, 0.0, 1.09575e-09],
                           [1.505e-10, 8.689121600000001e-11, 9.73026e-10],
                           [1.505e-10, -8.689121600000001e-11, 2.42526e-10],
                           [1.505e-10,
                            -8.689121600000001e-11,
                            4.879740000000001e-10],
                           [1.505e-10, 8.689121600000001e-11, -2.42526e-10],
                           [1.505e-10, 8.689121600000001e-11, 1.21263e-10],
                           [1.505e-10,
                            -8.689121600000001e-11,
                            8.517630000000001e-10],
                           [1.505e-10, -8.689121600000001e-11, -1.21263e-10],
                           [1.505e-10, 8.689121600000001e-11, 6.09237e-10]],
        'lattice_vectors': [[1.505e-10, -2.60673647e-10, 0.0],
                            [1.505e-10, 2.60673647e-10, 0.0],
                            [0.0, 0.0, 1.461e-09]],
        'normalized_wyckoff': {'a': {'X_0': 1},
                               'b': {'X_1': 1},
                               'f': {'X_0': 2, 'X_1': 2}},
        'normalized_wysytax': {'a': {'X_0': 1},
                               'b': {'X_1': 1},
                               'f': {'X_0': 2, 'X_1': 2}}},
       {'Notes': '-',
        'Pearsons Symbol': 'hP6',
        'Prototype': 'CaIn2',
        'Space Group': 'P63/mmc',
        'Space Group Number': 194,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'bf',
        'aflow_prototype_id': 'AB2_hP6_194_b_f',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB2_hP6_194_b_f.html',
        'atom_labels': ['Ca', 'Ca', 'In', 'In', 'In', 'In'],
        'atom_positions': [[0.0, 0.0, 1.9375e-10],
                           [0.0, 0.0, 5.8125e-10],
                           [2.4475e-10, 1.41306481e-10, 3.4875e-11],
                           [2.4475e-10, -1.41306481e-10, -3.4875e-11],
                           [2.4475e-10, 1.41306481e-10, 3.52625e-10],
                           [2.4475e-10, -1.41306481e-10, 4.22375e-10]],
        'lattice_vectors': [[2.4475e-10, -4.2391943500000004e-10, 0.0],
                            [2.4475e-10, 4.2391943500000004e-10, 0.0],
                            [0.0, 0.0, 7.75e-10]],
        'normalized_wyckoff': {'b': {'X_1': 1}, 'f': {'X_0': 2}},
        'normalized_wysytax': {'b': {'X_1': 1}, 'f': {'X_0': 2}}},
       {'Notes': '-',
        'Pearsons Symbol': 'hP12',
        'Prototype': 'CuS',
        'Space Group': 'P63/mmc',
        'Space Group Number': 194,
        'Strukturbericht Designation': 'B18',
        'Wyckoff Positions': 'c2d2e',
        'aflow_prototype_id': 'AB_hP12_194_df_ce',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_hP12_194_df_ce.html',
        'atom_labels': ['S',
                        'S',
                        'Cu',
                        'Cu',
                        'S',
                        'S',
                        'S',
                        'S',
                        'Cu',
                        'Cu',
                        'Cu',
                        'Cu'],
        'atom_positions': [[1.8785e-10, 1.08455248e-10, 4.04775e-10],
                           [1.8785e-10,
                            -1.08455248e-10,
                            1.2143250000000001e-09],
                           [1.8785e-10, 1.08455248e-10, 1.2143250000000001e-09],
                           [1.8785e-10, -1.08455248e-10, 4.04775e-10],
                           [0.0, 0.0, 1.1171789999999999e-10],
                           [0.0, 0.0, -1.1171789999999999e-10],
                           [0.0, 0.0, 9.212679e-10],
                           [0.0, 0.0, 6.978321e-10],
                           [1.8785e-10, 1.08455248e-10, 1.9380627e-10],
                           [1.8785e-10, -1.08455248e-10, -1.9380627e-10],
                           [1.8785e-10,
                            -1.08455248e-10,
                            1.0033562699999999e-09],
                           [1.8785e-10, 1.08455248e-10, 6.1574373e-10]],
        'lattice_vectors': [[1.8785e-10, -3.25365744e-10, 0.0],
                            [1.8785e-10, 3.25365744e-10, 0.0],
                            [0.0, 0.0, 1.6191e-09]],
        'normalized_wyckoff': {'c': {'X_0': 1},
                               'd': {'X_1': 1},
                               'e': {'X_0': 2},
                               'f': {'X_1': 2}},
        'normalized_wysytax': {'c': {'X_0': 1},
                               'd': {'X_1': 1},
                               'e': {'X_0': 2},
                               'f': {'X_1': 2}}},
       {'Notes': '-',
        'Pearsons Symbol': 'hP6',
        'Prototype': 'InNi2',
        'Space Group': 'P63/mmc',
        'Space Group Number': 194,
        'Strukturbericht Designation': 'B82',
        'Wyckoff Positions': 'acd',
        'aflow_prototype_id': 'AB2_hP6_194_c_ad',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB2_hP6_194_c_ad.html',
        'atom_labels': ['Ni', 'Ni', 'In', 'In', 'Ni', 'Ni'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [0.0, 0.0, 2.5655e-10],
                           [2.0895e-10, 1.2063734100000002e-10, 1.28275e-10],
                           [2.0895e-10, -1.2063734100000002e-10, 3.84825e-10],
                           [2.0895e-10, -1.2063734100000002e-10, 1.28275e-10],
                           [2.0895e-10, 1.2063734100000002e-10, 3.84825e-10]],
        'lattice_vectors': [[2.0895e-10, -3.61912016e-10, 0.0],
                            [2.0895e-10, 3.61912016e-10, 0.0],
                            [0.0, 0.0, 5.131e-10]],
        'normalized_wyckoff': {'a': {'X_0': 1},
                               'c': {'X_1': 1},
                               'd': {'X_0': 1}},
        'normalized_wysytax': {'a': {'X_0': 1},
                               'c': {'X_1': 1},
                               'd': {'X_0': 1}}},
       {'Notes': '-',
        'Pearsons Symbol': 'hP4',
        'Prototype': 'La (alpha)',
        'Space Group': 'P63/mmc',
        'Space Group Number': 194,
        'Strukturbericht Designation': "A3'",
        'Wyckoff Positions': 'ac',
        'aflow_prototype_id': 'A_hP4_194_ac',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_hP4_194_ac.html',
        'atom_labels': ['La', 'La', 'La', 'La'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [0.0, 0.0, 6.079500000000001e-10],
                           [1.885e-10,
                            1.0883052600000001e-10,
                            3.0397500000000003e-10],
                           [1.885e-10,
                            -1.0883052600000001e-10,
                            9.119249999999999e-10]],
        'lattice_vectors': [[1.885e-10, -3.26491577e-10, 0.0],
                            [1.885e-10, 3.26491577e-10, 0.0],
                            [0.0, 0.0, 1.2159000000000001e-09]],
        'normalized_wyckoff': {'a': {'X_0': 1}, 'c': {'X_0': 1}},
        'normalized_wysytax': {'a': {'X_0': 1}, 'c': {'X_0': 1}}},
       {'Notes': 'hcp',
        'Pearsons Symbol': 'hP2',
        'Prototype': 'Mg',
        'Space Group': 'P63/mmc',
        'Space Group Number': 194,
        'Strukturbericht Designation': 'A3',
        'Wyckoff Positions': 'c',
        'aflow_prototype_id': 'A_hP2_194_c',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_hP2_194_c.html',
        'atom_labels': ['Mg', 'Mg'],
        'atom_positions': [[1.6050000000000001e-10,
                            9.2664718e-11,
                            1.3025000000000002e-10],
                           [1.6050000000000001e-10,
                            -9.2664718e-11,
                            3.9075e-10]],
        'lattice_vectors': [[1.6050000000000001e-10,
                             -2.7799415500000004e-10,
                             0.0],
                            [1.6050000000000001e-10,
                             2.7799415500000004e-10,
                             0.0],
                            [0.0, 0.0, 5.210000000000001e-10]],
        'normalized_wyckoff': {'c': {'X_0': 1}},
        'normalized_wysytax': {'c': {'X_0': 1}}},
       {'Notes': 'hexagonal laves',
        'Pearsons Symbol': 'hP24',
        'Prototype': 'MgNi2',
        'Space Group': 'P63/mmc',
        'Space Group Number': 194,
        'Strukturbericht Designation': 'C36',
        'Wyckoff Positions': 'ef2gh',
        'aflow_prototype_id': 'AB2_hP24_194_ef_fgh',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB2_hP24_194_ef_fgh.html',
        'atom_labels': ['Mg',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni'],
        'atom_positions': [[0.0, 0.0, 1.47499999e-10],
                           [0.0, 0.0, -1.47499999e-10],
                           [0.0, 0.0, 9.37499999e-10],
                           [0.0, 0.0, 6.42500001e-10],
                           [2.4075e-10,
                            1.3899707800000002e-10,
                            -2.52038271e-10],
                           [2.4075e-10,
                            -1.3899707800000002e-10,
                            2.52038271e-10],
                           [2.4075e-10,
                            -1.3899707800000002e-10,
                            5.37961729e-10],
                           [2.4075e-10,
                            1.3899707800000002e-10,
                            1.0420382710000001e-09],
                           [2.4075e-10, 1.3899707800000002e-10, 1.94862961e-10],
                           [2.4075e-10,
                            -1.3899707800000002e-10,
                            -1.94862961e-10],
                           [2.4075e-10,
                            -1.3899707800000002e-10,
                            9.84862961e-10],
                           [2.4075e-10,
                            1.3899707800000002e-10,
                            5.951370410000001e-10],
                           [1.20375e-10, -2.08495616e-10, 0.0],
                           [1.20375e-10, 2.08495616e-10, 0.0],
                           [2.4075e-10, 0.0, 0.0],
                           [1.20375e-10,
                            -2.08495616e-10,
                            7.900000000000001e-10],
                           [1.20375e-10, 2.08495616e-10, 7.900000000000001e-10],
                           [2.4075e-10, 0.0, 7.900000000000001e-10],
                           [1.18846803e-10,
                            6.861623300000001e-11,
                            3.9500000000000003e-10],
                           [-1.18846803e-10,
                            6.861623300000001e-11,
                            3.9500000000000003e-10],
                           [0.0, -1.37232467e-10, 3.9500000000000003e-10],
                           [-1.18846803e-10, -6.861623300000001e-11, 1.185e-09],
                           [1.18846803e-10, -6.861623300000001e-11, 1.185e-09],
                           [0.0, 1.37232467e-10, 1.185e-09]],
        'lattice_vectors': [[2.4075e-10, -4.16991232e-10, 0.0],
                            [2.4075e-10, 4.16991232e-10, 0.0],
                            [0.0, 0.0, 1.5800000000000001e-09]],
        'normalized_wyckoff': {'e': {'X_1': 2},
                               'f': {'X_0': 2, 'X_1': 2},
                               'g': {'X_0': 3},
                               'h': {'X_0': 3}},
        'normalized_wysytax': {'e': {'X_1': 2},
                               'f': {'X_0': 2, 'X_1': 2},
                               'g': {'X_0': 3},
                               'h': {'X_0': 3}}},
       {'Notes': 'hexagonal laves',
        'Pearsons Symbol': 'hP12',
        'Prototype': 'MgZn2',
        'Space Group': 'P63/mmc',
        'Space Group Number': 194,
        'Strukturbericht Designation': 'C14',
        'Wyckoff Positions': 'afh',
        'aflow_prototype_id': 'AB2_hP12_194_f_ah',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB2_hP12_194_f_ah.html',
        'atom_labels': ['Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Mg'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [0.0, 0.0, 4.26e-10],
                           [-1.32e-10, -7.6210236e-11, 2.13e-10],
                           [1.32e-10, -7.6210236e-11, 2.13e-10],
                           [0.0, 1.52420471e-10, 2.13e-10],
                           [1.32e-10, 7.6210236e-11, 6.39e-10],
                           [-1.32e-10, 7.6210236e-11, 6.39e-10],
                           [0.0, -1.52420471e-10, 6.39e-10],
                           [2.59e-10, 1.4953372e-10, 5.691807e-11],
                           [2.59e-10, -1.4953372e-10, -5.691807e-11],
                           [2.59e-10, -1.4953372e-10, 4.8291807e-10],
                           [2.59e-10, 1.4953372e-10, 3.6908193e-10]],
        'lattice_vectors': [[2.59e-10, -4.4860115900000004e-10, 0.0],
                            [2.59e-10, 4.4860115900000004e-10, 0.0],
                            [0.0, 0.0, 8.52e-10]],
        'normalized_wyckoff': {'a': {'X_0': 1},
                               'f': {'X_1': 2},
                               'h': {'X_0': 3}},
        'normalized_wysytax': {'a': {'X_0': 1},
                               'f': {'X_1': 2},
                               'h': {'X_0': 3}}},
       {'Notes': '-',
        'Pearsons Symbol': 'hP6',
        'Prototype': 'MoS2',
        'Space Group': 'P63/mmc',
        'Space Group Number': 194,
        'Strukturbericht Designation': 'C7',
        'Wyckoff Positions': 'cf',
        'aflow_prototype_id': 'AB2_hP6_194_c_f',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB2_hP6_194_c_f.html',
        'atom_labels': ['Mo', 'Mo', 'S', 'S', 'S', 'S'],
        'atom_positions': [[1.5800000000000002e-10, 9.1221343e-11, 3.0725e-10],
                           [1.5800000000000002e-10,
                            -9.1221343e-11,
                            9.217499999999999e-10],
                           [1.5800000000000002e-10, 9.1221343e-11, 7.6198e-10],
                           [1.5800000000000002e-10,
                            -9.1221343e-11,
                            1.4748000000000002e-10],
                           [1.5800000000000002e-10,
                            -9.1221343e-11,
                            -7.6198e-10],
                           [1.5800000000000002e-10,
                            9.1221343e-11,
                            -1.4748000000000002e-10]],
        'lattice_vectors': [[1.5800000000000002e-10,
                             -2.7366402800000004e-10,
                             0.0],
                            [1.5800000000000002e-10,
                             2.7366402800000004e-10,
                             0.0],
                            [0.0, 0.0, 1.229e-09]],
        'normalized_wyckoff': {'c': {'X_1': 1}, 'f': {'X_0': 2}},
        'normalized_wysytax': {'c': {'X_1': 1}, 'f': {'X_0': 2}}},
       {'Notes': '-',
        'Pearsons Symbol': 'hP8',
        'Prototype': 'Ni3Sn',
        'Space Group': 'P63/mmc',
        'Space Group Number': 194,
        'Strukturbericht Designation': 'D019',
        'Wyckoff Positions': 'ch',
        'aflow_prototype_id': 'A3B_hP8_194_h_c',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A3B_hP8_194_h_c.html',
        'atom_labels': ['Ni', 'Ni', 'Ni', 'Ni', 'Ni', 'Ni', 'Sn', 'Sn'],
        'atom_positions': [[1.277154e-10, 7.373652056966712e-11, 3.18525e-10],
                           [2.6475000000000004e-10,
                            3.1108741016456577e-10,
                            3.18525e-10],
                           [1.277154e-10, -7.373652056966712e-11, 1.06175e-10],
                           [4.017846e-10, 7.373652056966714e-11, 3.18525e-10],
                           [2.6475000000000004e-10,
                            -3.1108741016456577e-10,
                            1.06175e-10],
                           [4.017846e-10, -7.373652056966714e-11, 1.06175e-10],
                           [2.6475e-10, 1.5285348376796973e-10, 1.06175e-10],
                           [2.6475e-10, -1.5285348376796973e-10, 3.18525e-10]],
        'lattice_vectors': [[2.6475e-10, -4.585604513039e-10, 0.0],
                            [2.6475e-10, 4.585604513039e-10, 0.0],
                            [0.0, 0.0, 4.247e-10]],
        'normalized_wyckoff': {'c': {'X_1': 1}, 'h': {'X_0': 3}},
        'normalized_wysytax': {'c': {'X_1': 1}, 'h': {'X_0': 3}}},
       {'Notes': 'beta tridymite',
        'Pearsons Symbol': 'hP12',
        'Prototype': 'O2Si',
        'Space Group': 'P63/mmc',
        'Space Group Number': 194,
        'Strukturbericht Designation': 'C10',
        'Wyckoff Positions': 'cfg',
        'aflow_prototype_id': 'A2B_hP12_194_cg_f',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2B_hP12_194_cg_f.html',
        'atom_labels': ['O',
                        'O',
                        'O',
                        'O',
                        'O',
                        'O',
                        'O',
                        'O',
                        'Si',
                        'Si',
                        'Si',
                        'Si'],
        'atom_positions': [[2.526e-10,
                            1.458386779973026e-10,
                            2.0674999999999998e-10],
                           [2.526e-10, -1.458386779973026e-10, 6.2025e-10],
                           [1.263e-10, 2.1875801699594952e-10, 0.0],
                           [1.263e-10,
                            2.1875801699594952e-10,
                            4.1349999999999997e-10],
                           [1.263e-10, -2.1875801699594952e-10, 0.0],
                           [1.263e-10,
                            -2.1875801699594952e-10,
                            4.1349999999999997e-10],
                           [2.526e-10, 0.0, 0.0],
                           [2.526e-10, 0.0, 4.1349999999999997e-10],
                           [2.526e-10,
                            1.458386779973026e-10,
                            5.1273999999999997e-11],
                           [2.526e-10,
                            1.458386779973026e-10,
                            3.6222599999999996e-10],
                           [2.526e-10,
                            -1.458386779973026e-10,
                            -5.1273999999999997e-11],
                           [2.526e-10,
                            -1.458386779973026e-10,
                            4.6477399999999997e-10]],
        'lattice_vectors': [[2.526e-10, -4.37516033991899e-10, 0.0],
                            [2.526e-10, 4.37516033991899e-10, 0.0],
                            [0.0, 0.0, 8.27e-10]],
        'normalized_wyckoff': {'c': {'X_0': 1},
                               'f': {'X_1': 2},
                               'g': {'X_0': 3}},
        'normalized_wysytax': {'c': {'X_0': 1},
                               'f': {'X_1': 2},
                               'g': {'X_0': 3}}}],
 197: [{'Notes': '-',
        'Pearsons Symbol': 'cI40',
        'Prototype': 'Ga4Ni',
        'Space Group': 'I23',
        'Space Group Number': 197,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'c2de',
        'aflow_prototype_id': 'A4B_cI40_197_cde_c',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A4B_cI40_197_cde_c.html',
        'atom_labels': ['Ga',
                        'Ga',
                        'Ga',
                        'Ga',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ga',
                        'Ga',
                        'Ga',
                        'Ga',
                        'Ga',
                        'Ga',
                        'Ga',
                        'Ga',
                        'Ga',
                        'Ga',
                        'Ga',
                        'Ga'],
        'atom_positions': [[1.4060406e-10, 1.4060406e-10, 1.4060406e-10],
                           [-1.4060406e-10, -1.4060406e-10, 1.4060406e-10],
                           [-1.4060406e-10, 1.4060406e-10, -1.4060406e-10],
                           [1.4060406e-10, -1.4060406e-10, -1.4060406e-10],
                           [2.81966775e-10, 2.81966775e-10, 2.81966775e-10],
                           [-2.81966775e-10, -2.81966775e-10, 2.81966775e-10],
                           [-2.81966775e-10, 2.81966775e-10, -2.81966775e-10],
                           [2.81966775e-10, -2.81966775e-10, -2.81966775e-10],
                           [2.9705558e-10, 0.0, 0.0],
                           [-2.9705558e-10, 0.0, 0.0],
                           [0.0, 2.9705558e-10, 0.0],
                           [0.0, -2.9705558e-10, 0.0],
                           [0.0, 0.0, 2.9705558e-10],
                           [0.0, 0.0, -2.9705558e-10],
                           [2.1225481e-10, 4.2147500000000004e-10, 0.0],
                           [-2.1225481e-10, 4.2147500000000004e-10, 0.0],
                           [0.0, 2.1225481e-10, 4.2147500000000004e-10],
                           [0.0, -2.1225481e-10, 4.2147500000000004e-10],
                           [4.2147500000000004e-10, 0.0, 2.1225481e-10],
                           [4.2147500000000004e-10, 0.0, -2.1225481e-10]],
        'lattice_vectors': [[-4.2147500000000004e-10,
                             4.2147500000000004e-10,
                             4.2147500000000004e-10],
                            [4.2147500000000004e-10,
                             -4.2147500000000004e-10,
                             4.2147500000000004e-10],
                            [4.2147500000000004e-10,
                             4.2147500000000004e-10,
                             -4.2147500000000004e-10]],
        'normalized_wysytax': {'c': {'X_0': 1, 'X_1': 1},
                               'd': {'X_0': 6},
                               'e': {'X_0': 6}}}],
 198: [{'Notes': '-',
        'Pearsons Symbol': 'cP8',
        'Prototype': 'CO',
        'Space Group': 'P213',
        'Space Group Number': 198,
        'Strukturbericht Designation': 'B21',
        'Wyckoff Positions': 'a2',
        'aflow_prototype_id': 'AB_cP8_198_a_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_cP8_198_a_a.alpha-CO.html',
        'atom_labels': ['C', 'C', 'C', 'C', 'O', 'O', 'O', 'O'],
        'atom_positions': [[3.378e-11, 3.378e-11, 3.378e-11],
                           [3.1528e-10, 2.4772e-10, -3.378e-11],
                           [-3.378e-11, 3.1528e-10, 2.4772e-10],
                           [2.4772e-10, -3.378e-11, 3.1528e-10],
                           [-2.2520000000000003e-11,
                            -2.2520000000000003e-11,
                            -2.2520000000000003e-11],
                           [2.5898e-10, 3.0402e-10, 2.2520000000000003e-11],
                           [2.2520000000000003e-11, 2.5898e-10, 3.0402e-10],
                           [3.0402e-10, 2.2520000000000003e-11, 2.5898e-10]],
        'lattice_vectors': [[5.63e-10, 0.0, 0.0],
                            [0.0, 5.63e-10, 0.0],
                            [0.0, 0.0, 5.63e-10]],
        'normalized_wyckoff': {'a': {'X_0': 1, 'X_1': 1}},
        'normalized_wysytax': {'a': {'X_0': 1, 'X_1': 1}}},
       {'Notes': '-',
        'Pearsons Symbol': 'cP8',
        'Prototype': 'FeSi',
        'Space Group': 'P213',
        'Space Group Number': 198,
        'Strukturbericht Designation': 'B20',
        'Wyckoff Positions': 'a2',
        'aflow_prototype_id': 'AB_cP8_198_a_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_cP8_198_a_a.FeSi.html',
        'atom_labels': ['Fe', 'Fe', 'Fe', 'Fe', 'Si', 'Si', 'Si', 'Si'],
        'atom_positions': [[6.125482211690161e-11,
                            6.125482211690161e-11,
                            6.125482211690161e-11],
                           [1.6308894479234836e-10,
                            3.8743271170159836e-10,
                            2.855985890261516e-10],
                           [2.855985890261516e-10,
                            1.6308894479234836e-10,
                            3.8743271170159836e-10],
                           [3.8743271170159836e-10,
                            2.855985890261516e-10,
                            1.6308894479234836e-10],
                           [7.071315532979559e-11,
                            1.536306115794544e-10,
                            2.9505692223904556e-10],
                           [1.536306115794544e-10,
                            2.9505692223904556e-10,
                            7.071315532979559e-11],
                           [2.9505692223904556e-10,
                            7.071315532979559e-11,
                            1.536306115794544e-10],
                           [3.779743784887043e-10,
                            3.779743784887043e-10,
                            3.779743784887043e-10]],
        'lattice_vectors': [[4.486875338185e-10, 0.0, 0.0],
                            [0.0, 4.486875338185e-10, 0.0],
                            [0.0, 0.0, 4.486875338185e-10]],
        'normalized_wyckoff': {'a': {'X_0': 1, 'X_1': 1}},
        'normalized_wysytax': {'a': {'X_0': 1, 'X_1': 1}}},
       {'Notes': 'ammonia',
        'Pearsons Symbol': 'cP16',
        'Prototype': 'H3N',
        'Space Group': 'P213',
        'Space Group Number': 198,
        'Strukturbericht Designation': 'D1',
        'Wyckoff Positions': 'ab',
        'aflow_prototype_id': 'A3B_cP16_198_b_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A3B_cP16_198_b_a.html',
        'atom_labels': ['N',
                        'N',
                        'N',
                        'N',
                        'H',
                        'H',
                        'H',
                        'H',
                        'H',
                        'H',
                        'H',
                        'H',
                        'H',
                        'H',
                        'H',
                        'H'],
        'atom_positions': [[1.1047469999999999e-10,
                            1.1047469999999999e-10,
                            1.1047469999999999e-10],
                           [3.650247e-10,
                            1.440753e-10,
                            -1.1047469999999999e-10],
                           [-1.1047469999999999e-10,
                            3.650247e-10,
                            1.440753e-10],
                           [1.440753e-10,
                            -1.1047469999999999e-10,
                            3.650247e-10],
                           [1.904034e-10, 1.3399512e-10, 5.569554e-11],
                           [4.449534e-10, 1.2055488e-10, -5.569554e-11],
                           [-1.904034e-10, 3.8854512e-10, 1.9885446e-10],
                           [6.41466e-11, -1.3399512e-10, 3.1024554e-10],
                           [5.569554e-11, 1.904034e-10, 1.3399512e-10],
                           [3.1024554e-10, 6.41466e-11, -1.3399512e-10],
                           [-5.569554e-11, 4.449534e-10, 1.2055488e-10],
                           [1.9885446e-10, -1.904034e-10, 3.8854512e-10],
                           [1.3399512e-10, 5.569554e-11, 1.904034e-10],
                           [3.8854512e-10, 1.9885446e-10, -1.904034e-10],
                           [-1.3399512e-10, 3.1024554e-10, 6.41466e-11],
                           [1.2055488e-10, -5.569554e-11, 4.449534e-10]],
        'lattice_vectors': [[5.091e-10, 0.0, 0.0],
                            [0.0, 5.091e-10, 0.0],
                            [0.0, 0.0, 5.091e-10]],
        'normalized_wyckoff': {'a': {'X_1': 1}, 'b': {'X_0': 3}},
        'normalized_wysytax': {'a': {'X_1': 1}, 'b': {'X_0': 3}}},
       {'Notes': 'ullmanite',
        'Pearsons Symbol': 'cP12',
        'Prototype': 'NiSSb',
        'Space Group': 'P213',
        'Space Group Number': 198,
        'Strukturbericht Designation': 'F01',
        'Wyckoff Positions': 'a3',
        'aflow_prototype_id': 'ABC_cP12_198_a_a_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/ABC_cP12_198_a_a_a.html',
        'atom_labels': ['Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'S',
                        'S',
                        'S',
                        'S',
                        'Sb',
                        'Sb',
                        'Sb',
                        'Sb'],
        'atom_positions': [[-1.4114399999999999e-11,
                            -1.4114399999999999e-11,
                            -1.4114399999999999e-11],
                           [-2.799356e-10,
                            1.4114399999999999e-11,
                            2.799356e-10],
                           [1.4114399999999999e-11,
                            2.799356e-10,
                            -2.799356e-10],
                           [2.799356e-10,
                            -2.799356e-10,
                            1.4114399999999999e-11],
                           [2.2935900000000001e-10,
                            2.2935900000000001e-10,
                            2.2935900000000001e-10],
                           [6.469100000000001e-11,
                            -2.2935900000000001e-10,
                            -6.469100000000001e-11],
                           [-2.2935900000000001e-10,
                            -6.469100000000001e-11,
                            6.469100000000001e-11],
                           [-6.469100000000001e-11,
                            6.469100000000001e-11,
                            -2.2935900000000001e-10],
                           [-2.2053750000000003e-10,
                            -2.2053750000000003e-10,
                            -2.2053750000000003e-10],
                           [-7.351250000000001e-11,
                            2.2053750000000003e-10,
                            7.351250000000001e-11],
                           [2.2053750000000003e-10,
                            7.351250000000001e-11,
                            -7.351250000000001e-11],
                           [7.351250000000001e-11,
                            -7.351250000000001e-11,
                            2.2053750000000003e-10]],
        'lattice_vectors': [[5.881000000000001e-10, 0.0, 0.0],
                            [0.0, 5.881000000000001e-10, 0.0],
                            [0.0, 0.0, 5.881000000000001e-10]],
        'normalized_wyckoff': {'a': {'X_0': 1, 'X_1': 1, 'X_2': 1}},
        'normalized_wysytax': {'a': {'X_0': 1, 'X_1': 1, 'X_2': 1}}}],
 199: [{'Notes': '-',
        'Pearsons Symbol': 'cI16',
        'Prototype': 'CoU',
        'Space Group': 'I213',
        'Space Group Number': 199,
        'Strukturbericht Designation': 'Ba',
        'Wyckoff Positions': 'a2',
        'aflow_prototype_id': 'AB_cI16_199_a_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_cI16_199_a_a.html',
        'atom_labels': ['Co', 'Co', 'Co', 'Co', 'U', 'U', 'U', 'U'],
        'atom_positions': [[1.8685758e-10, 1.8685758e-10, 1.8685758e-10],
                           [-1.8685758e-10, 1.3092742e-10, 1.8685758e-10],
                           [1.3092742e-10, 1.8685758e-10, -1.8685758e-10],
                           [1.8685758e-10, -1.8685758e-10, 1.3092742e-10],
                           [2.2054279e-11, 2.2054279e-11, 2.2054279e-11],
                           [-2.2054279e-11, 2.95730721e-10, 2.2054279e-11],
                           [2.95730721e-10, 2.2054279e-11, -2.2054279e-11],
                           [2.2054279e-11, -2.2054279e-11, 2.95730721e-10]],
        'lattice_vectors': [[-3.17785e-10, 3.17785e-10, 3.17785e-10],
                            [3.17785e-10, -3.17785e-10, 3.17785e-10],
                            [3.17785e-10, 3.17785e-10, -3.17785e-10]],
        'normalized_wyckoff': {'a': {'X_0': 1, 'X_1': 1}},
        'normalized_wysytax': {'a': {'X_0': 1, 'X_1': 1}}}],
 204: [{'Notes': 'Bergman',
        'Pearsons Symbol': 'cI162',
        'Prototype': '(Al,Zn)49Mg32',
        'Space Group': 'Im3',
        'Space Group Number': 204,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'ae2fg3h',
        'aflow_prototype_id': 'AB32C48_cI162_204_a_2efg_2gh',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB32C48_cI162_204_a_2efg_2gh.html',
        'atom_labels': ['Al',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Mg',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [7.08e-10,
                            2.5445519999999994e-10,
                            1.0339757656912846e-25],
                           [7.08e-10, 0.0, 4.5354479999999995e-10],
                           [4.5354479999999995e-10, 7.08e-10, 0.0],
                           [2.5445519999999994e-10,
                            5.169878828456423e-26,
                            7.08e-10],
                           [5.169878828456423e-26,
                            7.08e-10,
                            2.544551999999999e-10],
                           [2.5849394142282115e-26,
                            4.5354479999999995e-10,
                            7.08e-10],
                           [7.08e-10, 0.0, -1.413168e-10],
                           [7.08e-10, 5.169878828456423e-26, 1.413168e-10],
                           [-1.2924697071141057e-26,
                            -1.413168e-10,
                            7.080000000000001e-10],
                           [-1.413168e-10, 7.08e-10, 0.0],
                           [1.4131679999999995e-10,
                            7.08e-10,
                            5.169878828456423e-26],
                           [6.462348535570529e-26,
                            1.4131679999999995e-10,
                            7.079999999999999e-10],
                           [2.599776e-10, 2.599776e-10, -2.599776e-10],
                           [4.480224e-10, 4.480224e-10, -4.480224e-10],
                           [2.599776e-10, -2.599776e-10, 2.599776e-10],
                           [4.480224e-10, -4.480224e-10, 4.480224e-10],
                           [-2.599776e-10, 2.599776e-10, 2.599776e-10],
                           [2.599776e-10, 2.599776e-10, 2.599776e-10],
                           [-4.480224e-10, 4.480224e-10, 4.480224e-10],
                           [4.480224e-10, 4.480224e-10, 4.480224e-10],
                           [4.165872e-10, 1.690704e-10, 0.0],
                           [9.994128e-10, 1.6907040000000004e-10, 0.0],
                           [7.08e-10, -2.914128e-10, 5.389296e-10],
                           [5.389296e-10, 7.08e-10, -2.914128e-10],
                           [1.690704e-10, 0.0, 4.1658719999999994e-10],
                           [0.0, 4.165872e-10, 1.6907039999999996e-10],
                           [7.08e-10, 2.9141280000000004e-10, 5.389296e-10],
                           [5.389296e-10, 7.08e-10, 2.914128000000001e-10],
                           [1.6907040000000002e-10,
                            -2.5849394142282115e-26,
                            9.994128e-10],
                           [0.0, 9.994128e-10, 1.6907040000000004e-10],
                           [-2.914128e-10, 5.389296e-10, 7.08e-10],
                           [2.9141280000000004e-10,
                            5.389296e-10,
                            7.079999999999998e-10],
                           [0.0, -1.285728e-10, 2.1254159999999996e-10],
                           [7.079999999999999e-10,
                            -5.794272e-10,
                            4.954584000000001e-10],
                           [2.125416e-10, 0.0, -1.285728e-10],
                           [4.954584e-10, 7.08e-10, -5.794272e-10],
                           [2.1254160000000002e-10,
                            -2.5849394142282115e-26,
                            1.2857280000000002e-10],
                           [1.2034584e-09, 0.0, -1.2857279999999996e-10],
                           [-1.285728e-10, 2.125416e-10, 0.0],
                           [1.2857280000000002e-10,
                            2.1254160000000002e-10,
                            -2.5849394142282115e-26],
                           [-2.5849394142282115e-26,
                            1.2857280000000002e-10,
                            2.1254160000000002e-10],
                           [-1.2924697071141057e-26,
                            -1.2857279999999996e-10,
                            1.2034584000000002e-09],
                           [-5.794272000000001e-10, 4.954584e-10, 7.08e-10],
                           [-1.2857279999999996e-10, 1.2034584e-09, 0.0],
                           [7.08e-10,
                            4.6048320000000003e-10,
                            -2.8220880000000003e-10],
                           [4.257912e-10, 0.0, 2.475168e-10],
                           [9.902088e-10, 0.0, 2.475168e-10],
                           [2.475168e-10, 4.257912e-10, 0.0],
                           [4.6048320000000003e-10,
                            -2.8220880000000003e-10,
                            7.08e-10],
                           [0.0, 2.475168e-10, 4.257912e-10],
                           [7.08e-10, 4.604832e-10, 2.8220879999999993e-10],
                           [2.475168e-10, 9.902088e-10, 0.0],
                           [4.604832e-10, 2.822088e-10, 7.08e-10],
                           [-2.8220880000000003e-10,
                            7.08e-10,
                            4.6048320000000003e-10],
                           [2.822088e-10, 7.08e-10, 4.6048320000000003e-10],
                           [0.0, 2.475168e-10, 9.902088e-10],
                           [5.707896e-10, 2.37888e-10, -2.6337600000000004e-10],
                           [8.452103999999999e-10,
                            2.3788800000000003e-10,
                            -2.63376e-10],
                           [5.707896e-10, -2.37888e-10, 2.6337599999999994e-10],
                           [8.452103999999999e-10,
                            -2.378879999999999e-10,
                            2.63376e-10],
                           [4.701120000000001e-10, 4.44624e-10, -1.372104e-10],
                           [2.3788800000000003e-10, -2.63376e-10, 5.707896e-10],
                           [2.63376e-10, 5.707895999999999e-10, -2.37888e-10],
                           [4.44624e-10, -1.372104e-10, 4.701120000000001e-10],
                           [5.707895999999999e-10,
                            2.3788800000000003e-10,
                            2.6337600000000004e-10],
                           [8.452103999999999e-10,
                            2.378880000000001e-10,
                            2.6337599999999994e-10],
                           [4.70112e-10,
                            4.4462400000000005e-10,
                            1.372103999999999e-10],
                           [2.3788800000000003e-10, -2.63376e-10, 8.452104e-10],
                           [2.6337599999999994e-10,
                            8.452103999999999e-10,
                            -2.37888e-10],
                           [4.4462400000000005e-10,
                            1.3721039999999996e-10,
                            4.70112e-10],
                           [-2.63376e-10,
                            5.707895999999999e-10,
                            2.3788800000000003e-10],
                           [2.63376e-10,
                            5.707895999999999e-10,
                            2.3788800000000003e-10],
                           [-2.3788800000000003e-10,
                            2.63376e-10,
                            5.707895999999999e-10],
                           [2.3788800000000003e-10,
                            2.63376e-10,
                            5.707895999999999e-10],
                           [-1.3721040000000003e-10,
                            4.701120000000001e-10,
                            4.44624e-10],
                           [1.3721039999999996e-10,
                            4.70112e-10,
                            4.4462400000000005e-10],
                           [-2.6337600000000004e-10, 8.452104e-10, 2.37888e-10],
                           [2.6337599999999994e-10,
                            8.452103999999999e-10,
                            2.378880000000001e-10],
                           [-2.37888e-10,
                            2.6337599999999994e-10,
                            8.452103999999998e-10],
                           [2.378880000000001e-10,
                            2.6337599999999994e-10,
                            8.452103999999999e-10]],
        'lattice_vectors': [[-7.08e-10, 7.08e-10, 7.08e-10],
                            [7.08e-10, -7.08e-10, 7.08e-10],
                            [7.08e-10, 7.08e-10, -7.08e-10]],
        'normalized_wyckoff': {'a': {'X_2': 1},
                               'e': {'X_1': 12},
                               'f': {'X_1': 8},
                               'g': {'X_0': 24, 'X_1': 12},
                               'h': {'X_0': 24}},
        'normalized_wysytax': {'a': {'X_2': 1},
                               'e': {'X_1': 12},
                               'f': {'X_1': 2},
                               'g': {'X_0': 18, 'X_1': 9},
                               'h': {'X_0': 12}}},
       {'Notes': '-',
        'Pearsons Symbol': 'cI26',
        'Prototype': 'Al12W',
        'Space Group': 'Im3',
        'Space Group Number': 204,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'ag',
        'aflow_prototype_id': 'A12B_cI26_204_g_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A12B_cI26_204_g_a.html',
        'atom_labels': ['W',
                        'Al',
                        'Al',
                        'Al',
                        'Al',
                        'Al',
                        'Al',
                        'Al',
                        'Al',
                        'Al',
                        'Al',
                        'Al',
                        'Al'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [0.0, 1.3947752e-10, 2.3423127e-10],
                           [0.0, -1.3947752e-10, 2.3423127e-10],
                           [0.0, 1.3947752e-10, -2.3423127e-10],
                           [0.0, -1.3947752e-10, -2.3423127e-10],
                           [2.3423127e-10, 0.0, 1.3947752e-10],
                           [2.3423127e-10, 0.0, -1.3947752e-10],
                           [-2.3423127e-10, 0.0, 1.3947752e-10],
                           [-2.3423127e-10, 0.0, -1.3947752e-10],
                           [1.3947752e-10, 2.3423127e-10, 0.0],
                           [-1.3947752e-10, 2.3423127e-10, 0.0],
                           [1.3947752e-10, -2.3423127e-10, 0.0],
                           [-1.3947752e-10, -2.3423127e-10, 0.0]],
        'lattice_vectors': [[-3.79015e-10, 3.79015e-10, 3.79015e-10],
                            [3.79015e-10, -3.79015e-10, 3.79015e-10],
                            [3.79015e-10, 3.79015e-10, -3.79015e-10]],
        'normalized_wyckoff': {'a': {'X_1': 1}, 'g': {'X_0': 12}},
        'normalized_wysytax': {'a': {'X_1': 1}, 'g': {'X_0': 9}}},
       {'Notes': 'skutterudite',
        'Pearsons Symbol': 'cI32',
        'Prototype': 'As3Co',
        'Space Group': 'Im3',
        'Space Group Number': 204,
        'Strukturbericht Designation': 'D02',
        'Wyckoff Positions': 'cg',
        'aflow_prototype_id': 'A3B_cI32_204_g_c',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A3B_cI32_204_g_c.html',
        'atom_labels': ['Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'As',
                        'As',
                        'As',
                        'As',
                        'As',
                        'As',
                        'As',
                        'As',
                        'As',
                        'As',
                        'As',
                        'As'],
        'atom_positions': [[2.0513750000000003e-10,
                            2.0513750000000003e-10,
                            2.0513750000000003e-10],
                           [-2.0513750000000003e-10,
                            2.0513750000000003e-10,
                            2.0513750000000003e-10],
                           [2.0513750000000003e-10,
                            -2.0513750000000003e-10,
                            2.0513750000000003e-10],
                           [2.0513750000000003e-10,
                            2.0513750000000003e-10,
                            -2.0513750000000003e-10],
                           [0.0, 2.8243330000000004e-10, 1.242313e-10],
                           [-0.0, 2.8243330000000004e-10, -1.242313e-10],
                           [1.242313e-10, 0.0, 2.8243330000000004e-10],
                           [-1.242313e-10, 0.0, 2.8243330000000004e-10],
                           [2.8243330000000004e-10, 1.242313e-10, 0.0],
                           [2.8243330000000004e-10, -1.242313e-10, -0.0],
                           [-0.0, -2.8243330000000004e-10, -1.242313e-10],
                           [0.0, -2.8243330000000004e-10, 1.242313e-10],
                           [-1.242313e-10, -0.0, -2.8243330000000004e-10],
                           [1.242313e-10, -0.0, -2.8243330000000004e-10],
                           [-2.8243330000000004e-10, -1.242313e-10, -0.0],
                           [-2.8243330000000004e-10, 1.242313e-10, 0.0]],
        'lattice_vectors': [[-4.1027500000000006e-10,
                             4.1027500000000006e-10,
                             4.1027500000000006e-10],
                            [4.1027500000000006e-10,
                             -4.1027500000000006e-10,
                             4.1027500000000006e-10],
                            [4.1027500000000006e-10,
                             4.1027500000000006e-10,
                             -4.1027500000000006e-10]],
        'normalized_wyckoff': {'c': {'X_1': 1}, 'g': {'X_0': 3}},
        'normalized_wysytax': {'c': {'X_1': 1}, 'g': {'X_0': 9}}}],
 205: [{'Notes': 'sc16',
        'Pearsons Symbol': 'cP16',
        'Prototype': 'AlSb',
        'Space Group': 'Pa3',
        'Space Group Number': 205,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'c2',
        'aflow_prototype_id': 'AB_cP16_205_c_c',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_cP16_205_c_c.html',
        'atom_labels': ['Al',
                        'Al',
                        'Al',
                        'Al',
                        'Al',
                        'Al',
                        'Al',
                        'Al',
                        'Sb',
                        'Sb',
                        'Sb',
                        'Sb',
                        'Sb',
                        'Sb',
                        'Sb',
                        'Sb'],
        'atom_positions': [[1.1203700000000001e-10,
                            1.1203700000000001e-10,
                            1.1203700000000001e-10],
                           [4.86243e-10, 2.6216900000000003e-10, 6.36374e-10],
                           [6.36374e-10, 4.86243e-10, 2.6216900000000003e-10],
                           [2.6216900000000003e-10, 6.36374e-10, 4.86243e-10],
                           [6.36374e-10, 6.36374e-10, 6.36374e-10],
                           [2.6216900000000003e-10,
                            4.86243e-10,
                            1.1203700000000001e-10],
                           [1.1203700000000001e-10,
                            2.6216900000000003e-10,
                            4.86243e-10],
                           [4.86243e-10,
                            1.1203700000000001e-10,
                            2.6216900000000003e-10],
                           [2.6216900000000003e-10,
                            2.6216900000000003e-10,
                            2.6216900000000003e-10],
                           [6.36374e-10, 1.1203700000000001e-10, 4.86243e-10],
                           [4.86243e-10, 6.36374e-10, 1.1203700000000001e-10],
                           [1.1203700000000001e-10, 4.86243e-10, 6.36374e-10],
                           [4.86243e-10, 4.86243e-10, 4.86243e-10],
                           [1.1203700000000001e-10,
                            6.36374e-10,
                            2.6216900000000003e-10],
                           [2.6216900000000003e-10,
                            1.1203700000000001e-10,
                            6.36374e-10],
                           [6.36374e-10,
                            2.6216900000000003e-10,
                            1.1203700000000001e-10]],
        'lattice_vectors': [[7.48411e-10, 0.0, 0.0],
                            [0.0, 7.48411e-10, 0.0],
                            [0.0, 0.0, 7.48411e-10]],
        'normalized_wyckoff': {'c': {'X_0': 1, 'X_1': 1}},
        'normalized_wysytax': {'c': {'X_0': 1, 'X_1': 1}}},
       {'Notes': 'pyrite',
        'Pearsons Symbol': 'cP12',
        'Prototype': 'FeS2',
        'Space Group': 'Pa3',
        'Space Group Number': 205,
        'Strukturbericht Designation': 'C2',
        'Wyckoff Positions': 'ac',
        'aflow_prototype_id': 'AB2_cP12_205_a_c',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB2_cP12_205_a_c.html',
        'atom_labels': ['Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S',
                        'S'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [0.0, 2.7085e-10, 2.7085e-10],
                           [2.7085e-10, 0.0, 2.7085e-10],
                           [2.7085e-10, 2.7085e-10, 0.0],
                           [6.224133e-11,
                            3.3309132999999996e-10,
                            4.7945867e-10],
                           [6.224133e-11,
                            4.7945867e-10,
                            2.0860866999999999e-10],
                           [2.0860866999999999e-10,
                            6.224133e-11,
                            4.7945867e-10],
                           [2.0860866999999999e-10,
                            2.0860866999999999e-10,
                            2.0860866999999999e-10],
                           [3.3309132999999996e-10,
                            3.3309132999999996e-10,
                            3.3309132999999996e-10],
                           [3.3309132999999996e-10,
                            4.7945867e-10,
                            6.224133e-11],
                           [4.7945867e-10,
                            6.224133e-11,
                            3.3309132999999996e-10],
                           [4.7945867e-10,
                            2.0860866999999999e-10,
                            6.224133e-11]],
        'lattice_vectors': [[5.417e-10, 0.0, 0.0],
                            [0.0, 5.417e-10, 0.0],
                            [0.0, 0.0, 5.417e-10]],
        'normalized_wyckoff': {'a': {'X_1': 1}, 'c': {'X_0': 2}},
        'normalized_wysytax': {'a': {'X_1': 1}, 'c': {'X_0': 2}}},
       {'Notes': 'alpha N2',
        'Pearsons Symbol': 'cP8',
        'Prototype': 'N (alpha)',
        'Space Group': 'Pa3',
        'Space Group Number': 205,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'c',
        'aflow_prototype_id': 'A_cP8_205_c',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_cP8_205_c.html',
        'atom_labels': ['N', 'N', 'N', 'N', 'N', 'N', 'N', 'N'],
        'atom_positions': [[3.04776e-11, 3.04776e-11, 3.04776e-11],
                           [2.5172240000000003e-10, -3.04776e-11, 3.126776e-10],
                           [-3.04776e-11, 3.126776e-10, 2.5172240000000003e-10],
                           [3.126776e-10, 2.5172240000000003e-10, -3.04776e-11],
                           [-3.04776e-11, -3.04776e-11, -3.04776e-11],
                           [3.126776e-10, 3.04776e-11, 2.5172240000000003e-10],
                           [3.04776e-11, 2.5172240000000003e-10, 3.126776e-10],
                           [2.5172240000000003e-10, 3.126776e-10, 3.04776e-11]],
        'lattice_vectors': [[5.644e-10, 0.0, 0.0],
                            [0.0, 5.644e-10, 0.0],
                            [0.0, 0.0, 5.644e-10]],
        'normalized_wyckoff': {'c': {'X_0': 1}},
        'normalized_wysytax': {'c': {'X_0': 1}}}],
 206: [{'Notes': 'bixbyite',
        'Pearsons Symbol': 'cI80',
        'Prototype': 'Mn2O3',
        'Space Group': 'Ia3',
        'Space Group Number': 206,
        'Strukturbericht Designation': 'D53',
        'Wyckoff Positions': 'ade',
        'aflow_prototype_id': 'AB3C6_cI80_206_a_d_e',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB3C6_cI80_206_a_d_e.html',
        'atom_labels': ['Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'O',
                        'O',
                        'O',
                        'O',
                        'O',
                        'O',
                        'O',
                        'O',
                        'O',
                        'O',
                        'O',
                        'O',
                        'O',
                        'O',
                        'O',
                        'O',
                        'O',
                        'O',
                        'O',
                        'O',
                        'O',
                        'O',
                        'O',
                        'O'],
        'atom_positions': [[2.35e-10, 2.35e-10, 2.35e-10],
                           [-2.35e-10, 2.35e-10, 2.35e-10],
                           [2.35e-10, -2.35e-10, 2.35e-10],
                           [2.35e-10, 2.35e-10, -2.35e-10],
                           [-3.2336e-11, 0.0, 2.35e-10],
                           [3.2336e-11, -4.7e-10, 2.35e-10],
                           [2.35e-10, -3.2336e-11, 0.0],
                           [2.35e-10, 3.2336e-11, -4.7e-10],
                           [0.0, 2.35e-10, -3.2336e-11],
                           [-4.7e-10, 2.35e-10, 3.2336e-11],
                           [3.2336e-11, 0.0, -2.35e-10],
                           [-3.2336e-11, 4.7e-10, -2.35e-10],
                           [-2.35e-10, 3.2336e-11, 0.0],
                           [-2.35e-10, -3.2336e-11, 4.7e-10],
                           [0.0, -2.35e-10, 3.2336e-11],
                           [4.7e-10, -2.35e-10, -3.2336e-11],
                           [3.1772e-10, 9.4e-11, 1.175e-10],
                           [1.5228e-10, -9.4e-11, -3.525e-10],
                           [1.5228e-10, 9.4e-11, -1.175e-10],
                           [-1.5228e-10, 3.76e-10, -1.175e-10],
                           [1.175e-10, 3.1772e-10, 9.4e-11],
                           [-3.525e-10, 1.5228e-10, -9.4e-11],
                           [-1.175e-10, 1.5228e-10, 9.4e-11],
                           [-1.175e-10, -1.5228e-10, 3.76e-10],
                           [9.4e-11, 1.175e-10, 3.1772e-10],
                           [-9.4e-11, -3.525e-10, 1.5228e-10],
                           [9.4e-11, -1.175e-10, 1.5228e-10],
                           [3.76e-10, -1.175e-10, -1.5228e-10],
                           [-3.1772e-10, -9.4e-11, -1.175e-10],
                           [-1.5228e-10, 9.4e-11, 3.525e-10],
                           [-1.5228e-10, -9.4e-11, 1.175e-10],
                           [1.5228e-10, -3.76e-10, 1.175e-10],
                           [-1.175e-10, -3.1772e-10, -9.4e-11],
                           [3.525e-10, -1.5228e-10, 9.4e-11],
                           [1.175e-10, -1.5228e-10, -9.4e-11],
                           [1.175e-10, 1.5228e-10, -3.76e-10],
                           [-9.4e-11, -1.175e-10, -3.1772e-10],
                           [9.4e-11, 3.525e-10, -1.5228e-10],
                           [-9.4e-11, 1.175e-10, -1.5228e-10],
                           [-3.76e-10, 1.175e-10, 1.5228e-10]],
        'lattice_vectors': [[-4.7e-10, 4.7e-10, 4.7e-10],
                            [4.7e-10, -4.7e-10, 4.7e-10],
                            [4.7e-10, 4.7e-10, -4.7e-10]],
        'normalized_wyckoff': {'b': {'X_2': 1},
                               'd': {'X_1': 3},
                               'e': {'X_0': 6}},
        'normalized_wysytax': {'b': {'X_2': 1},
                               'd': {'X_0': 9},
                               'e': {'X_1': 9}}},
       {'Notes': 'bc8',
        'Pearsons Symbol': 'cI16',
        'Prototype': 'Si',
        'Space Group': 'Ia3',
        'Space Group Number': 206,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'c',
        'aflow_prototype_id': 'A_cI16_206_c',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_cI16_206_c.html',
        'atom_labels': ['Si', 'Si', 'Si', 'Si', 'Si', 'Si', 'Si', 'Si'],
        'atom_positions': [[1.6474739036832122e-10,
                            4.1238344025678806e-11,
                            -4.1238344025678806e-11],
                           [2.472240784196788e-10,
                            -4.123834402567878e-11,
                            4.123834402567878e-11],
                           [4.12383440256788e-11,
                            4.12383440256788e-11,
                            4.12383440256788e-11],
                           [4.1238344025678806e-11,
                            -4.1238344025678806e-11,
                            1.6474739036832122e-10],
                           [-4.1238344025678806e-11,
                            1.6474739036832122e-10,
                            4.1238344025678806e-11],
                           [4.123834402567878e-11,
                            2.472240784196788e-10,
                            -4.123834402567878e-11],
                           [-4.123834402567878e-11,
                            4.123834402567878e-11,
                            2.472240784196788e-10],
                           [1.6474739036832122e-10,
                            1.6474739036832122e-10,
                            1.6474739036832122e-10]],
        'lattice_vectors': [[-2.05985734394e-10,
                             2.05985734394e-10,
                             2.05985734394e-10],
                            [2.05985734394e-10,
                             -2.05985734394e-10,
                             2.05985734394e-10],
                            [2.05985734394e-10,
                             2.05985734394e-10,
                             -2.05985734394e-10]],
        'normalized_wyckoff': {'c': {'X_0': 1}},
        'normalized_wysytax': {'c': {'X_0': 1}}}],
 213: [{'Notes': '-',
        'Pearsons Symbol': 'cP20',
        'Prototype': 'Mn (beta)',
        'Space Group': 'P4132',
        'Space Group Number': 213,
        'Strukturbericht Designation': 'A13',
        'Wyckoff Positions': 'cd',
        'aflow_prototype_id': 'A_cP20_213_cd',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_cP20_213_cd.html',
        'atom_labels': ['Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn'],
        'atom_positions': [[-3.016044e-11, 2.368125e-10, 5.0378544e-10],
                           [3.016044e-11, 5.525625e-10, 4.4346456000000003e-10],
                           [7.89375e-11, 1.2771456e-10, 2.8558956000000005e-10],
                           [1.2771456e-10, 2.8558956000000005e-10, 7.89375e-11],
                           [1.8803544e-10,
                            3.4591044000000004e-10,
                            3.9468750000000004e-10],
                           [2.368125e-10, 5.0378544e-10, -3.016044e-11],
                           [2.8558956000000005e-10, 7.89375e-11, 1.2771456e-10],
                           [3.4591044000000004e-10,
                            3.9468750000000004e-10,
                            1.8803544e-10],
                           [3.9468750000000004e-10,
                            1.8803544e-10,
                            3.4591044000000004e-10],
                           [4.4346456000000003e-10, 3.016044e-11, 5.525625e-10],
                           [5.0378544e-10, -3.016044e-11, 2.368125e-10],
                           [5.525625e-10, 4.4346456000000003e-10, 3.016044e-11],
                           [4.0169715000000005e-11,
                            4.0169715000000005e-11,
                            4.0169715000000005e-11],
                           [-4.0169715000000005e-11,
                            3.55919715e-10,
                            2.75580285e-10],
                           [1.17705285e-10,
                            5.137947150000001e-10,
                            1.98044715e-10],
                           [1.98044715e-10,
                            1.17705285e-10,
                            5.137947150000001e-10],
                           [2.75580285e-10,
                            -4.0169715000000005e-11,
                            3.55919715e-10],
                           [3.55919715e-10,
                            2.75580285e-10,
                            -4.0169715000000005e-11],
                           [4.33455285e-10, 4.33455285e-10, 4.33455285e-10],
                           [5.137947150000001e-10,
                            1.98044715e-10,
                            1.17705285e-10]],
        'lattice_vectors': [[6.315e-10, 0.0, 0.0],
                            [0.0, 6.315e-10, 0.0],
                            [0.0, 0.0, 6.315e-10]],
        'normalized_wyckoff': {'c': {'X_0': 2}, 'd': {'X_0': 3}},
        'normalized_wysytax': {'c': {'X_0': 2}, 'd': {'X_0': 3}}}],
 215: [{'Notes': 'lazarevicite',
        'Pearsons Symbol': 'cP8',
        'Prototype': 'AsCu3S4',
        'Space Group': 'P43m',
        'Space Group Number': 215,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'ace',
        'aflow_prototype_id': 'AB3C4_cP8_215_a_c_e',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB3C4_cP8_215_a_c_e.html',
        'atom_labels': ['As', 'Cu', 'Cu', 'Cu', 'S', 'S', 'S', 'S'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [0.0, 2.64e-10, 2.64e-10],
                           [2.64e-10, 0.0, 2.64e-10],
                           [2.64e-10, 2.64e-10, 0.0],
                           [1.32e-10, 1.32e-10, 1.32e-10],
                           [1.32e-10,
                            3.9600000000000003e-10,
                            3.9600000000000003e-10],
                           [3.9600000000000003e-10,
                            1.32e-10,
                            3.9600000000000003e-10],
                           [3.9600000000000003e-10,
                            3.9600000000000003e-10,
                            1.32e-10]],
        'lattice_vectors': [[5.28e-10, 0.0, 0.0],
                            [0.0, 5.28e-10, 0.0],
                            [0.0, 0.0, 5.28e-10]],
        'normalized_wyckoff': {'a': {'X_2': 1},
                               'c': {'X_1': 3},
                               'e': {'X_0': 4}},
        'normalized_wysytax': {'a': {'X_2': 1},
                               'c': {'X_1': 3},
                               'e': {'X_0': 4}}},
       {'Notes': '-',
        'Pearsons Symbol': 'cP5',
        'Prototype': 'CFe4',
        'Space Group': 'P43m',
        'Space Group Number': 215,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'ae',
        'aflow_prototype_id': 'AB4_cP5_215_a_e',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB4_cP5_215_a_e.html',
        'atom_labels': ['C', 'Fe', 'Fe', 'Fe', 'Fe'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [1.0276700000000001e-10,
                            1.0276700000000001e-10,
                            1.0276700000000001e-10],
                           [1.0276700000000001e-10,
                            -1.0276700000000001e-10,
                            -1.0276700000000001e-10],
                           [-1.0276700000000001e-10,
                            1.0276700000000001e-10,
                            -1.0276700000000001e-10],
                           [-1.0276700000000001e-10,
                            -1.0276700000000001e-10,
                            1.0276700000000001e-10]],
        'lattice_vectors': [[3.8780000000000005e-10, 0.0, 0.0],
                            [0.0, 3.8780000000000005e-10, 0.0],
                            [0.0, 0.0, 3.8780000000000005e-10]],
        'normalized_wyckoff': {'a': {'X_1': 1}, 'e': {'X_0': 4}},
        'normalized_wysytax': {'a': {'X_1': 1}, 'e': {'X_0': 4}}},
       {'Notes': 'sulvanite',
        'Pearsons Symbol': 'cP8',
        'Prototype': 'Cu3S4V',
        'Space Group': 'P43m',
        'Space Group Number': 215,
        'Strukturbericht Designation': 'H24',
        'Wyckoff Positions': 'ade',
        'aflow_prototype_id': 'A3B4C_cP8_215_d_e_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A3B4C_cP8_215_d_e_a.html',
        'atom_labels': ['V', 'Cu', 'Cu', 'Cu', 'S', 'S', 'S', 'S'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [2.6956000000000005e-10, 0.0, 0.0],
                           [0.0, 2.6956000000000005e-10, 0.0],
                           [0.0, 0.0, 2.6956000000000005e-10],
                           [1.278793e-10, 1.278793e-10, 1.278793e-10],
                           [1.278793e-10, -1.278793e-10, -1.278793e-10],
                           [-1.278793e-10, 1.278793e-10, -1.278793e-10],
                           [-1.278793e-10, -1.278793e-10, 1.278793e-10]],
        'lattice_vectors': [[5.391200000000001e-10, 0.0, 0.0],
                            [0.0, 5.391200000000001e-10, 0.0],
                            [0.0, 0.0, 5.391200000000001e-10]],
        'normalized_wyckoff': {'a': {'X_2': 1},
                               'd': {'X_1': 3},
                               'e': {'X_0': 4}},
        'normalized_wysytax': {'a': {'X_2': 1},
                               'd': {'X_1': 3},
                               'e': {'X_0': 4}}}],
 216: [{'Notes': 'half-Heusler',
        'Pearsons Symbol': 'cF12',
        'Prototype': 'AgAsMg',
        'Space Group': 'F43m',
        'Space Group Number': 216,
        'Strukturbericht Designation': 'C1b',
        'Wyckoff Positions': 'abc',
        'aflow_prototype_id': 'ABC_cF12_216_b_c_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/ABC_cF12_216_b_c_a.html',
        'atom_labels': ['Mg', 'Ag', 'As'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [3.105e-10, 3.105e-10, 3.105e-10],
                           [1.5525e-10, 1.5525e-10, 1.5525e-10]],
        'lattice_vectors': [[0.0, 3.105e-10, 3.105e-10],
                            [3.105e-10, 0.0, 3.105e-10],
                            [3.105e-10, 3.105e-10, 0.0]],
        'normalized_wyckoff': {'a': {'X_0': 1},
                               'b': {'X_1': 1},
                               'c': {'X_2': 1}},
        'normalized_wysytax': {'a': {'X_0': 1},
                               'b': {'X_1': 1},
                               'd': {'X_2': 1}}},
       {'Notes': '-',
        'Pearsons Symbol': 'cF24',
        'Prototype': 'Cu4MgSn',
        'Space Group': 'F43m',
        'Space Group Number': 216,
        'Strukturbericht Designation': 'C15b',
        'Wyckoff Positions': 'ace',
        'aflow_prototype_id': 'AB5_cF24_216_a_ce',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB5_cF24_216_a_ce.html',
        'atom_labels': ['Mg', 'Sn', 'Cu', 'Cu', 'Cu', 'Cu'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [1.76091832e-10, 1.76091832e-10, 1.76091832e-10],
                           [-2.64137748e-10, -2.64137748e-10, -2.64137748e-10],
                           [-2.64137748e-10, 2.64137748e-10, 2.64137748e-10],
                           [2.64137748e-10, -2.64137748e-10, 2.64137748e-10],
                           [2.64137748e-10, 2.64137748e-10, -2.64137748e-10]],
        'lattice_vectors': [[0.0, 3.52183664e-10, 3.52183664e-10],
                            [3.52183664e-10, 0.0, 3.52183664e-10],
                            [3.52183664e-10, 3.52183664e-10, 0.0]],
        'normalized_wyckoff': {'a': {'X_1': 1},
                               'd': {'X_2': 1},
                               'e': {'X_0': 4}},
        'normalized_wysytax': {'a': {'X_1': 1},
                               'd': {'X_2': 1},
                               'e': {'X_0': 4}}},
       {'Notes': 'zincblende',
        'Pearsons Symbol': 'cF8',
        'Prototype': 'SZn',
        'Space Group': 'F43m',
        'Space Group Number': 216,
        'Strukturbericht Designation': 'B3',
        'Wyckoff Positions': 'ac',
        'aflow_prototype_id': 'AB_cF8_216_c_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_cF8_216_c_a.html',
        'atom_labels': ['S', 'Zn'],
        'atom_positions': [[1.352325e-10, 1.352325e-10, 1.352325e-10],
                           [0.0, 0.0, 0.0]],
        'lattice_vectors': [[0.0, 2.70465e-10, 2.70465e-10],
                            [2.70465e-10, 0.0, 2.70465e-10],
                            [2.70465e-10, 2.70465e-10, 0.0]],
        'normalized_wyckoff': {'a': {'X_0': 1}, 'd': {'X_1': 1}},
        'normalized_wysytax': {'a': {'X_0': 1}, 'd': {'X_1': 1}}}],
 217: [{'Notes': 'gamma brass',
        'Pearsons Symbol': 'cI52',
        'Prototype': 'Cu5Zn8',
        'Space Group': 'I43m',
        'Space Group Number': 217,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'ceg',
        'aflow_prototype_id': 'A5B8_cI52_217_ce_cg',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A5B8_cI52_217_ce_cg.html',
        'atom_labels': ['Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Cu',
                        'Cu',
                        'Cu',
                        'Cu',
                        'Cu',
                        'Cu',
                        'Cu',
                        'Cu',
                        'Cu',
                        'Cu',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn',
                        'Zn'],
        'atom_positions': [[9.658341000000001e-11,
                            9.658341000000001e-11,
                            9.658341000000001e-11],
                           [9.658341000000001e-11,
                            -9.658341000000001e-11,
                            -9.658341000000001e-11],
                           [-9.658341000000001e-11,
                            9.658341000000001e-11,
                            -9.658341000000001e-11],
                           [-9.658341000000001e-11,
                            -9.658341000000001e-11,
                            9.658341000000001e-11],
                           [-1.5254680000000002e-10,
                            -1.5254680000000002e-10,
                            -1.5254680000000002e-10],
                           [-1.5254680000000002e-10,
                            1.5254680000000002e-10,
                            1.5254680000000002e-10],
                           [1.5254680000000002e-10,
                            -1.5254680000000002e-10,
                            1.5254680000000002e-10],
                           [1.5254680000000002e-10,
                            1.5254680000000002e-10,
                            -1.5254680000000002e-10],
                           [3.1555901999999997e-10, 0.0, 0.0],
                           [-3.1555901999999997e-10, 0.0, 0.0],
                           [0.0, 3.1555901999999997e-10, 0.0],
                           [0.0, -3.1555901999999997e-10, 0.0],
                           [0.0, 0.0, 3.1555901999999997e-10],
                           [0.0, 0.0, -3.1555901999999997e-10],
                           [2.7742232e-10, 2.7742232e-10, 3.246054e-11],
                           [-2.7742232e-10, -2.7742232e-10, 3.246054e-11],
                           [-2.7742232e-10, 2.7742232e-10, -3.246054e-11],
                           [2.7742232e-10, -2.7742232e-10, -3.246054e-11],
                           [3.246054e-11, 2.7742232e-10, 2.7742232e-10],
                           [3.246054e-11, -2.7742232e-10, -2.7742232e-10],
                           [-3.246054e-11, -2.7742232e-10, 2.7742232e-10],
                           [-3.246054e-11, 2.7742232e-10, -2.7742232e-10],
                           [2.7742232e-10, 3.246054e-11, 2.7742232e-10],
                           [-2.7742232e-10, 3.246054e-11, -2.7742232e-10],
                           [2.7742232e-10, -3.246054e-11, -2.7742232e-10],
                           [-2.7742232e-10, -3.246054e-11, 2.7742232e-10]],
        'lattice_vectors': [[-4.4345e-10, 4.4345e-10, 4.4345e-10],
                            [4.4345e-10, -4.4345e-10, 4.4345e-10],
                            [4.4345e-10, 4.4345e-10, -4.4345e-10]],
        'normalized_wyckoff': {'c': {'X_0': 2, 'X_1': 2},
                               'e': {'X_1': 3},
                               'g': {'X_0': 6}},
        'normalized_wysytax': {'c': {'X_0': 1, 'X_1': 1},
                               'e': {'X_0': 6},
                               'g': {'X_1': 6}}},
       {'Notes': '-',
        'Pearsons Symbol': 'cI10',
        'Prototype': 'F4Si',
        'Space Group': 'I43m',
        'Space Group Number': 217,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'ac',
        'aflow_prototype_id': 'A4B_cI10_217_c_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A4B_cI10_217_c_a.html',
        'atom_labels': ['Si', 'F', 'F', 'F', 'F'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [8.926500000000001e-11,
                            8.926500000000001e-11,
                            8.926500000000001e-11],
                           [8.926500000000001e-11,
                            -8.926500000000001e-11,
                            -8.926500000000001e-11],
                           [-8.926500000000001e-11,
                            8.926500000000001e-11,
                            -8.926500000000001e-11],
                           [-8.926500000000001e-11,
                            -8.926500000000001e-11,
                            8.926500000000001e-11]],
        'lattice_vectors': [[-2.705e-10, 2.705e-10, 2.705e-10],
                            [2.705e-10, -2.705e-10, 2.705e-10],
                            [2.705e-10, 2.705e-10, -2.705e-10]],
        'normalized_wyckoff': {'a': {'X_1': 1}, 'c': {'X_0': 4}},
        'normalized_wysytax': {'a': {'X_0': 1}, 'c': {'X_1': 1}}},
       {'Notes': '-',
        'Pearsons Symbol': 'cI58',
        'Prototype': 'Mn (alpha)',
        'Space Group': 'I43m',
        'Space Group Number': 217,
        'Strukturbericht Designation': 'A12',
        'Wyckoff Positions': 'acg2',
        'aflow_prototype_id': 'A_cI58_217_ac2g',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_cI58_217_ac2g.html',
        'atom_labels': ['Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn',
                        'Mn'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [2.83311174e-10, 2.83311174e-10, 2.83311174e-10],
                           [2.83311174e-10, -2.83311174e-10, -2.83311174e-10],
                           [-2.83311174e-10, 2.83311174e-10, -2.83311174e-10],
                           [-2.83311174e-10, -2.83311174e-10, 2.83311174e-10],
                           [3.18240437e-10, 3.18240437e-10, 3.081155e-11],
                           [-3.18240437e-10, -3.18240437e-10, 3.081155e-11],
                           [-3.18240437e-10, 3.18240437e-10, -3.081155e-11],
                           [3.18240437e-10, -3.18240437e-10, -3.081155e-11],
                           [3.081155e-11, 3.18240437e-10, 3.18240437e-10],
                           [3.081155e-11, -3.18240437e-10, -3.18240437e-10],
                           [-3.081155e-11, -3.18240437e-10, 3.18240437e-10],
                           [-3.081155e-11, 3.18240437e-10, -3.18240437e-10],
                           [3.18240437e-10, 3.081155e-11, 3.18240437e-10],
                           [-3.18240437e-10, 3.081155e-11, -3.18240437e-10],
                           [3.18240437e-10, -3.081155e-11, -3.18240437e-10],
                           [-3.18240437e-10, -3.081155e-11, 3.18240437e-10],
                           [7.9840862e-11, 7.9840862e-11, 2.51287483e-10],
                           [-7.9840862e-11, -7.9840862e-11, 2.51287483e-10],
                           [-7.9840862e-11, 7.9840862e-11, -2.51287483e-10],
                           [7.9840862e-11, -7.9840862e-11, -2.51287483e-10],
                           [2.51287483e-10, 7.9840862e-11, 7.9840862e-11],
                           [2.51287483e-10, -7.9840862e-11, -7.9840862e-11],
                           [-2.51287483e-10, -7.9840862e-11, 7.9840862e-11],
                           [-2.51287483e-10, 7.9840862e-11, -7.9840862e-11],
                           [7.9840862e-11, 2.51287483e-10, 7.9840862e-11],
                           [-7.9840862e-11, 2.51287483e-10, -7.9840862e-11],
                           [7.9840862e-11, -2.51287483e-10, -7.9840862e-11],
                           [-7.9840862e-11, -2.51287483e-10, 7.9840862e-11]],
        'lattice_vectors': [[-4.456400000000001e-10,
                             4.456400000000001e-10,
                             4.456400000000001e-10],
                            [4.456400000000001e-10,
                             -4.456400000000001e-10,
                             4.456400000000001e-10],
                            [4.456400000000001e-10,
                             4.456400000000001e-10,
                             -4.456400000000001e-10]],
        'normalized_wyckoff': {'a': {'X_0': 1},
                               'c': {'X_0': 4},
                               'g': {'X_0': 24}},
        'normalized_wysytax': {'a': {'X_0': 1},
                               'c': {'X_0': 1},
                               'g': {'X_0': 9}}}],
 220: [{'Notes': '-',
        'Pearsons Symbol': 'cI40',
        'Prototype': 'C3Pu2',
        'Space Group': 'I43d',
        'Space Group Number': 220,
        'Strukturbericht Designation': 'D5c',
        'Wyckoff Positions': 'cd',
        'aflow_prototype_id': 'A3B2_cI40_220_d_c',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A3B2_cI40_220_d_c.html',
        'atom_labels': ['Pu',
                        'Pu',
                        'Pu',
                        'Pu',
                        'Pu',
                        'Pu',
                        'Pu',
                        'Pu',
                        'C',
                        'C',
                        'C',
                        'C',
                        'C',
                        'C',
                        'C',
                        'C',
                        'C',
                        'C',
                        'C',
                        'C'],
        'atom_positions': [[4.0660000000000005e-11,
                            4.0660000000000005e-11,
                            4.0660000000000005e-11],
                           [-4.0660000000000005e-11,
                            3.6594000000000003e-10,
                            4.0660000000000005e-11],
                           [3.6594000000000003e-10,
                            4.0660000000000005e-11,
                            -4.0660000000000005e-11],
                           [4.0660000000000005e-11,
                            -4.0660000000000005e-11,
                            3.6594000000000003e-10],
                           [-1.6264000000000002e-10,
                            -1.6264000000000002e-10,
                            -1.6264000000000002e-10],
                           [-2.4396e-10, 1.6264000000000002e-10, 2.4396e-10],
                           [2.4396e-10, -2.4396e-10, 1.6264000000000002e-10],
                           [1.6264000000000002e-10, 2.4396e-10, -2.4396e-10],
                           [-1.715852e-10, 4.066e-10, -2.033e-10],
                           [1.715852e-10, 0.0, -2.033e-10],
                           [-2.033e-10, -1.715852e-10, 4.066e-10],
                           [-2.033e-10, 1.715852e-10, 0.0],
                           [4.066e-10, -2.033e-10, -1.715852e-10],
                           [0.0, -2.033e-10, 1.715852e-10],
                           [-2.033e-10, 3.17148e-11, 0.0],
                           [-2.033e-10, -3.17148e-11, 4.066e-10],
                           [3.17148e-11, 0.0, -2.033e-10],
                           [-3.17148e-11, 4.066e-10, -2.033e-10],
                           [0.0, -2.033e-10, 3.17148e-11],
                           [4.066e-10, -2.033e-10, -3.17148e-11]],
        'lattice_vectors': [[-4.066e-10, 4.066e-10, 4.066e-10],
                            [4.066e-10, -4.066e-10, 4.066e-10],
                            [4.066e-10, 4.066e-10, -4.066e-10]],
        'normalized_wyckoff': {'c': {'X_1': 2}, 'd': {'X_0': 3}},
        'normalized_wysytax': {'c': {'X_1': 1}, 'd': {'X_0': 6}}},
       {'Notes': 'high-pressure cI16 phase',
        'Pearsons Symbol': 'cI16',
        'Prototype': 'Li',
        'Space Group': 'I43d',
        'Space Group Number': 220,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'c',
        'aflow_prototype_id': 'A_cI16_220_c',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_cI16_220_c.html',
        'atom_labels': ['Li', 'Li', 'Li', 'Li', 'Li', 'Li', 'Li', 'Li'],
        'atom_positions': [[2.583084e-11, 2.583084e-11, 2.583084e-11],
                           [-1.0595916000000001e-10,
                            -1.0595916000000001e-10,
                            -1.0595916000000001e-10],
                           [2.583084e-11, -2.583084e-11, 2.3774916e-10],
                           [1.5762084000000001e-10,
                            -1.5762084000000001e-10,
                            1.0595916000000001e-10],
                           [2.3774916e-10, 2.583084e-11, -2.583084e-11],
                           [1.0595916000000001e-10,
                            1.5762084000000001e-10,
                            -1.5762084000000001e-10],
                           [-2.583084e-11, 2.3774916e-10, 2.583084e-11],
                           [-1.5762084000000001e-10,
                            1.0595916000000001e-10,
                            1.5762084000000001e-10]],
        'lattice_vectors': [[-2.6358000000000003e-10,
                             2.6358000000000003e-10,
                             2.6358000000000003e-10],
                            [2.6358000000000003e-10,
                             -2.6358000000000003e-10,
                             2.6358000000000003e-10],
                            [2.6358000000000003e-10,
                             2.6358000000000003e-10,
                             -2.6358000000000003e-10]],
        'normalized_wyckoff': {'c': {'X_0': 1}},
        'normalized_wysytax': {'c': {'X_0': 1}}}],
 221: [{'Notes': '-',
        'Pearsons Symbol': 'cP4',
        'Prototype': 'AuCu3',
        'Space Group': 'Pm3m',
        'Space Group Number': 221,
        'Strukturbericht Designation': 'L12',
        'Wyckoff Positions': 'ac',
        'aflow_prototype_id': 'AB3_cP4_221_a_c',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB3_cP4_221_a_c.html',
        'atom_labels': ['Au', 'Cu', 'Cu', 'Cu'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [0.0, 1.875e-10, 1.875e-10],
                           [1.875e-10, 0.0, 1.875e-10],
                           [1.875e-10, 1.875e-10, 0.0]],
        'lattice_vectors': [[3.75e-10, 0.0, 0.0],
                            [0.0, 3.75e-10, 0.0],
                            [0.0, 0.0, 3.75e-10]],
        'normalized_wyckoff': {'a': {'X_1': 1}, 'c': {'X_0': 3}},
        'normalized_wysytax': {'a': {'X_1': 1}, 'c': {'X_0': 3}}},
       {'Notes': '-',
        'Pearsons Symbol': 'cP7',
        'Prototype': 'B6Ca',
        'Space Group': 'Pm3m',
        'Space Group Number': 221,
        'Strukturbericht Designation': 'D21',
        'Wyckoff Positions': 'af',
        'aflow_prototype_id': 'A6B_cP7_221_f_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A6B_cP7_221_f_a.html',
        'atom_labels': ['Ca', 'B', 'B', 'B', 'B', 'B', 'B'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [8.58015e-11,
                            2.0724999999999998e-10,
                            2.0724999999999998e-10],
                           [-8.58015e-11,
                            2.0724999999999998e-10,
                            2.0724999999999998e-10],
                           [2.0724999999999998e-10,
                            8.58015e-11,
                            2.0724999999999998e-10],
                           [2.0724999999999998e-10,
                            -8.58015e-11,
                            2.0724999999999998e-10],
                           [2.0724999999999998e-10,
                            2.0724999999999998e-10,
                            8.58015e-11],
                           [2.0724999999999998e-10,
                            2.0724999999999998e-10,
                            -8.58015e-11]],
        'lattice_vectors': [[4.1449999999999996e-10, 0.0, 0.0],
                            [0.0, 4.1449999999999996e-10, 0.0],
                            [0.0, 0.0, 4.1449999999999996e-10]],
        'normalized_wyckoff': {'b': {'X_1': 1}, 'e': {'X_0': 6}},
        'normalized_wysytax': {'a': {'X_1': 1}, 'f': {'X_0': 6}}},
       {'Notes': '-',
        'Pearsons Symbol': 'cP36',
        'Prototype': 'BaHg11',
        'Space Group': 'Pm3m',
        'Space Group Number': 221,
        'Strukturbericht Designation': 'D2e',
        'Wyckoff Positions': 'bdgij',
        'aflow_prototype_id': 'AB11_cP36_221_c_agij',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB11_cP36_221_c_agij.html',
        'atom_labels': ['Ba',
                        'Ba',
                        'Ba',
                        'Hg',
                        'Hg',
                        'Hg',
                        'Hg',
                        'Hg',
                        'Hg',
                        'Hg',
                        'Hg',
                        'Hg',
                        'Hg',
                        'Hg',
                        'Hg',
                        'Hg',
                        'Hg',
                        'Hg',
                        'Hg',
                        'Hg',
                        'Hg',
                        'Hg',
                        'Hg',
                        'Hg',
                        'Hg',
                        'Hg',
                        'Hg',
                        'Hg',
                        'Hg',
                        'Hg',
                        'Hg',
                        'Hg',
                        'Hg',
                        'Hg',
                        'Hg',
                        'Hg'],
        'atom_positions': [[4.8e-10, 0.0, 0.0],
                           [0.0, 4.8e-10, 0.0],
                           [0.0, 0.0, 4.8e-10],
                           [4.8e-10, 4.8e-10, 4.8e-10],
                           [1.488e-10, 1.488e-10, 1.488e-10],
                           [-1.488e-10, 1.488e-10, 1.488e-10],
                           [1.488e-10, -1.488e-10, 1.488e-10],
                           [1.488e-10, 1.488e-10, -1.488e-10],
                           [-1.488e-10, -1.488e-10, -1.488e-10],
                           [1.488e-10, -1.488e-10, -1.488e-10],
                           [-1.488e-10, 1.488e-10, -1.488e-10],
                           [-1.488e-10, -1.488e-10, 1.488e-10],
                           [0.0, 3.312e-10, 3.312e-10],
                           [3.312e-10, 0.0, 3.312e-10],
                           [3.312e-10, 3.312e-10, 0.0],
                           [0.0, 3.312e-10, -3.312e-10],
                           [3.312e-10, 0.0, -3.312e-10],
                           [3.312e-10, -3.312e-10, 0.0],
                           [0.0, -3.312e-10, -3.312e-10],
                           [-3.312e-10, 0.0, -3.312e-10],
                           [-3.312e-10, -3.312e-10, 0.0],
                           [0.0, -3.312e-10, 3.312e-10],
                           [-3.312e-10, 0.0, 3.312e-10],
                           [-3.312e-10, 3.312e-10, 0.0],
                           [4.8e-10, 2.64e-10, 2.64e-10],
                           [2.64e-10, 4.8e-10, 2.64e-10],
                           [2.64e-10, 2.64e-10, 4.8e-10],
                           [4.8e-10, 2.64e-10, -2.64e-10],
                           [2.64e-10, 4.8e-10, -2.64e-10],
                           [2.64e-10, -2.64e-10, 4.8e-10],
                           [4.8e-10, -2.64e-10, -2.64e-10],
                           [-2.64e-10, 4.8e-10, -2.64e-10],
                           [-2.64e-10, -2.64e-10, 4.8e-10],
                           [4.8e-10, -2.64e-10, 2.64e-10],
                           [-2.64e-10, 4.8e-10, 2.64e-10],
                           [-2.64e-10, 2.64e-10, 4.8e-10]],
        'lattice_vectors': [[9.6e-10, 0.0, 0.0],
                            [0.0, 9.6e-10, 0.0],
                            [0.0, 0.0, 9.6e-10]],
        'normalized_wyckoff': {'b': {'X_0': 1},
                               'd': {'X_1': 3},
                               'g': {'X_0': 8},
                               'i': {'X_0': 12},
                               'j': {'X_0': 12}},
        'normalized_wysytax': {'b': {'X_0': 1},
                               'd': {'X_1': 3},
                               'g': {'X_0': 8},
                               'i': {'X_0': 12},
                               'j': {'X_0': 12}}},
       {'Notes': 'cubic perovskite',
        'Pearsons Symbol': 'cP5',
        'Prototype': 'CaO3Ti',
        'Space Group': 'Pm3m',
        'Space Group Number': 221,
        'Strukturbericht Designation': 'E21',
        'Wyckoff Positions': 'abc',
        'aflow_prototype_id': 'AB3C_cP5_221_a_c_b',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB3C_cP5_221_a_c_b.html',
        'atom_labels': ['Ca', 'O', 'O', 'O', 'Ti'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [0.0, 1.8975e-10, 1.8975e-10],
                           [1.8975e-10, 0.0, 1.8975e-10],
                           [1.8975e-10, 1.8975e-10, 0.0],
                           [1.8975e-10, 1.8975e-10, 1.8975e-10]],
        'lattice_vectors': [[3.795e-10, 0.0, 0.0],
                            [0.0, 3.795e-10, 0.0],
                            [0.0, 0.0, 3.795e-10]],
        'normalized_wyckoff': {'a': {'X_1': 1},
                               'b': {'X_2': 1},
                               'c': {'X_0': 3}},
        'normalized_wysytax': {'a': {'X_1': 1},
                               'b': {'X_2': 1},
                               'c': {'X_0': 3}}},
       {'Notes': '-',
        'Pearsons Symbol': 'cP2',
        'Prototype': 'ClCs',
        'Space Group': 'Pm3m',
        'Space Group Number': 221,
        'Strukturbericht Designation': 'B2',
        'Wyckoff Positions': 'ab',
        'aflow_prototype_id': 'AB_cP2_221_b_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_cP2_221_b_a.html',
        'atom_labels': ['Cs', 'Cl'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [2.0550000000000001e-10,
                            2.0550000000000001e-10,
                            2.0550000000000001e-10]],
        'lattice_vectors': [[4.1100000000000003e-10, 0.0, 0.0],
                            [0.0, 4.1100000000000003e-10, 0.0],
                            [0.0, 0.0, 4.1100000000000003e-10]],
        'normalized_wyckoff': {'a': {'X_0': 1}, 'b': {'X_1': 1}},
        'normalized_wysytax': {'a': {'X_0': 1}, 'b': {'X_1': 1}}},
       {'Notes': 'hypothetical ferrite structure',
        'Pearsons Symbol': 'cP16',
        'Prototype': 'CrFe8MoNi6',
        'Space Group': 'Pm3m',
        'Space Group Number': 221,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'abcdg',
        'aflow_prototype_id': 'AB11CD3_cP16_221_a_dg_b_c',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB11CD3_cP16_221_a_dg_b_c.html',
        'atom_labels': ['Cr',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Mo'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [1.4063e-10, 1.4063e-10, 1.4063e-10],
                           [-1.4063e-10, 1.4063e-10, 1.4063e-10],
                           [1.4063e-10, -1.4063e-10, 1.4063e-10],
                           [1.4063e-10, 1.4063e-10, -1.4063e-10],
                           [-1.4063e-10, -1.4063e-10, -1.4063e-10],
                           [1.4063e-10, -1.4063e-10, -1.4063e-10],
                           [-1.4063e-10, 1.4063e-10, -1.4063e-10],
                           [-1.4063e-10, -1.4063e-10, 1.4063e-10],
                           [2.8700000000000004e-10, 0.0, 0.0],
                           [0.0, 2.8700000000000004e-10, 0.0],
                           [0.0, 0.0, 2.8700000000000004e-10],
                           [0.0,
                            2.8700000000000004e-10,
                            2.8700000000000004e-10],
                           [2.8700000000000004e-10,
                            0.0,
                            2.8700000000000004e-10],
                           [2.8700000000000004e-10,
                            2.8700000000000004e-10,
                            0.0],
                           [2.8700000000000004e-10,
                            2.8700000000000004e-10,
                            2.8700000000000004e-10]],
        'lattice_vectors': [[5.740000000000001e-10, 0.0, 0.0],
                            [0.0, 5.740000000000001e-10, 0.0],
                            [0.0, 0.0, 5.740000000000001e-10]],
        'normalized_wyckoff': {'a': {'X_2': 1},
                               'b': {'X_3': 1},
                               'c': {'X_1': 3},
                               'd': {'X_1': 3},
                               'g': {'X_0': 8}},
        'normalized_wysytax': {'a': {'X_2': 1},
                               'b': {'X_3': 1},
                               'c': {'X_1': 3},
                               'd': {'X_1': 3},
                               'g': {'X_0': 8}}},
       {'Notes': 'hypothetical austenite structure',
        'Pearsons Symbol': 'cP32',
        'Prototype': 'CrFe25Ni6',
        'Space Group': 'Pm3m',
        'Space Group Number': 221,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'abd2ij',
        'aflow_prototype_id': 'AB27CD3_cP32_221_a_dij_b_c',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB27CD3_cP32_221_a_dij_b_c.html',
        'atom_labels': ['Cr',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Fe'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [0.0, 1.7248e-10, 1.7248e-10],
                           [1.7248e-10, 0.0, 1.7248e-10],
                           [1.7248e-10, 1.7248e-10, 0.0],
                           [0.0, 1.7248e-10, -1.7248e-10],
                           [1.7248e-10, 0.0, -1.7248e-10],
                           [1.7248e-10, -1.7248e-10, 0.0],
                           [0.0, -1.7248e-10, 1.7248e-10],
                           [-1.7248e-10, 0.0, 1.7248e-10],
                           [-1.7248e-10, 1.7248e-10, 0.0],
                           [0.0, -1.7248e-10, -1.7248e-10],
                           [-1.7248e-10, 0.0, -1.7248e-10],
                           [-1.7248e-10, -1.7248e-10, 0.0],
                           [3.52e-10, 0.0, 0.0],
                           [0.0, 3.52e-10, 0.0],
                           [0.0, 0.0, 3.52e-10],
                           [3.52e-10,
                            1.8304000000000002e-10,
                            1.8304000000000002e-10],
                           [1.8304000000000002e-10,
                            3.52e-10,
                            1.8304000000000002e-10],
                           [1.8304000000000002e-10,
                            1.8304000000000002e-10,
                            3.52e-10],
                           [3.52e-10,
                            1.8304000000000002e-10,
                            -1.8304000000000002e-10],
                           [1.8304000000000002e-10,
                            3.52e-10,
                            -1.8304000000000002e-10],
                           [1.8304000000000002e-10,
                            -1.8304000000000002e-10,
                            3.52e-10],
                           [3.52e-10,
                            -1.8304000000000002e-10,
                            1.8304000000000002e-10],
                           [-1.8304000000000002e-10,
                            3.52e-10,
                            1.8304000000000002e-10],
                           [-1.8304000000000002e-10,
                            1.8304000000000002e-10,
                            3.52e-10],
                           [3.52e-10,
                            -1.8304000000000002e-10,
                            -1.8304000000000002e-10],
                           [-1.8304000000000002e-10,
                            3.52e-10,
                            -1.8304000000000002e-10],
                           [-1.8304000000000002e-10,
                            -1.8304000000000002e-10,
                            3.52e-10],
                           [0.0, 3.52e-10, 3.52e-10],
                           [3.52e-10, 0.0, 3.52e-10],
                           [3.52e-10, 3.52e-10, 0.0],
                           [3.52e-10, 3.52e-10, 3.52e-10]],
        'lattice_vectors': [[7.04e-10, 0.0, 0.0],
                            [0.0, 7.04e-10, 0.0],
                            [0.0, 0.0, 7.04e-10]],
        'normalized_wyckoff': {'a': {'X_0': 1},
                               'b': {'X_2': 1},
                               'c': {'X_1': 3},
                               'd': {'X_1': 3},
                               'i': {'X_0': 12},
                               'j': {'X_0': 12}},
        'normalized_wysytax': {'a': {'X_2': 1},
                               'b': {'X_0': 1},
                               'c': {'X_1': 3},
                               'd': {'X_1': 3},
                               'i': {'X_0': 12},
                               'j': {'X_0': 12}}},
       {'Notes': '-',
        'Pearsons Symbol': 'cP6',
        'Prototype': 'NbO',
        'Space Group': 'Pm3m',
        'Space Group Number': 221,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'cd',
        'aflow_prototype_id': 'AB_cP6_221_c_d',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_cP6_221_c_d.html',
        'atom_labels': ['Nb', 'Nb', 'Nb', 'O', 'O', 'O'],
        'atom_positions': [[0.0, 2.106e-10, 2.106e-10],
                           [2.106e-10, 0.0, 2.106e-10],
                           [2.106e-10, 2.106e-10, 0.0],
                           [2.106e-10, 0.0, 0.0],
                           [0.0, 2.106e-10, 0.0],
                           [0.0, 0.0, 2.106e-10]],
        'lattice_vectors': [[4.212e-10, 0.0, 0.0],
                            [0.0, 4.212e-10, 0.0],
                            [0.0, 0.0, 4.212e-10]],
        'normalized_wyckoff': {'c': {'X_0': 1}, 'd': {'X_1': 1}},
        'normalized_wysytax': {'c': {'X_0': 1}, 'd': {'X_1': 1}}},
       {'Notes': '-',
        'Pearsons Symbol': 'cP4',
        'Prototype': 'O3Re (alpha)',
        'Space Group': 'Pm3m',
        'Space Group Number': 221,
        'Strukturbericht Designation': 'D09',
        'Wyckoff Positions': 'ad',
        'aflow_prototype_id': 'A3B_cP4_221_d_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A3B_cP4_221_d_a.html',
        'atom_labels': ['Re', 'O', 'O', 'O'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [1.87387e-10, 0.0, 0.0],
                           [0.0, 1.87387e-10, 0.0],
                           [0.0, 0.0, 1.87387e-10]],
        'lattice_vectors': [[3.74774e-10, 0.0, 0.0],
                            [0.0, 3.74774e-10, 0.0],
                            [0.0, 0.0, 3.74774e-10]],
        'normalized_wyckoff': {'a': {'X_1': 1}, 'd': {'X_0': 3}},
        'normalized_wysytax': {'a': {'X_1': 1}, 'd': {'X_0': 3}}},
       {'Notes': 'simple cubic',
        'Pearsons Symbol': 'cP1',
        'Prototype': 'Po (alpha)',
        'Space Group': 'Pm3m',
        'Space Group Number': 221,
        'Strukturbericht Designation': 'Ah',
        'Wyckoff Positions': 'a',
        'aflow_prototype_id': 'A_cP1_221_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_cP1_221_a.html',
        'atom_labels': ['Po'],
        'atom_positions': [[0.0, 0.0, 0.0]],
        'lattice_vectors': [[3.34e-10, 0.0, 0.0],
                            [0.0, 3.34e-10, 0.0],
                            [0.0, 0.0, 3.34e-10]],
        'normalized_wyckoff': {'a': {'X_0': 1}},
        'normalized_wysytax': {'a': {'X_0': 1}}}],
 223: [{'Notes': '-',
        'Pearsons Symbol': 'cP8',
        'Prototype': 'Cr3Si',
        'Space Group': 'Pm3n',
        'Space Group Number': 223,
        'Strukturbericht Designation': 'A15',
        'Wyckoff Positions': 'ac',
        'aflow_prototype_id': 'A3B_cP8_223_c_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A3B_cP8_223_c_a.html',
        'atom_labels': ['Si', 'Si', 'Cr', 'Cr', 'Cr', 'Cr', 'Cr', 'Cr'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [2.275e-10, 2.275e-10, 2.275e-10],
                           [1.1375e-10, 2.275e-10, 0.0],
                           [3.4125000000000004e-10, 2.275e-10, 0.0],
                           [0.0, 1.1375e-10, 2.275e-10],
                           [0.0, 3.4125000000000004e-10, 2.275e-10],
                           [2.275e-10, 0.0, 1.1375e-10],
                           [2.275e-10, 0.0, 3.4125000000000004e-10]],
        'lattice_vectors': [[4.55e-10, 0.0, 0.0],
                            [0.0, 4.55e-10, 0.0],
                            [0.0, 0.0, 4.55e-10]],
        'normalized_wyckoff': {'a': {'X_1': 1}, 'd': {'X_0': 3}},
        'normalized_wysytax': {'a': {'X_1': 1}, 'd': {'X_0': 3}}},
       {'Notes': 'clathrate',
        'Pearsons Symbol': 'cP46',
        'Prototype': 'Si46',
        'Space Group': 'Pm3n',
        'Space Group Number': 223,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'dik',
        'aflow_prototype_id': 'A_cP46_223_dik',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_cP46_223_dik.html',
        'atom_labels': ['Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si'],
        'atom_positions': [[2.58875e-10, 5.1775e-10, 0.0],
                           [0.0, 2.58875e-10, 5.1775e-10],
                           [5.1775e-10, 0.0, 2.58875e-10],
                           [7.766250000000001e-10, 5.1775e-10, 0.0],
                           [0.0, 7.766250000000001e-10, 5.1775e-10],
                           [5.1775e-10, 0.0, 7.766250000000001e-10],
                           [1.9022135e-10, 1.9022135e-10, 1.9022135e-10],
                           [-1.9022135e-10, -1.9022135e-10, -1.9022135e-10],
                           [1.9022135e-10, -1.9022135e-10, -1.9022135e-10],
                           [-1.9022135e-10, 1.9022135e-10, -1.9022135e-10],
                           [-1.9022135e-10, -1.9022135e-10, 1.9022135e-10],
                           [-1.9022135e-10, 1.9022135e-10, 1.9022135e-10],
                           [1.9022135e-10, -1.9022135e-10, 1.9022135e-10],
                           [1.9022135e-10, 1.9022135e-10, -1.9022135e-10],
                           [7.079713500000001e-10,
                            7.079713500000001e-10,
                            7.079713500000001e-10],
                           [-7.079713500000001e-10,
                            -7.079713500000001e-10,
                            -7.079713500000001e-10],
                           [7.079713500000001e-10,
                            -7.079713500000001e-10,
                            -7.079713500000001e-10],
                           [-7.079713500000001e-10,
                            7.079713500000001e-10,
                            -7.079713500000001e-10],
                           [-7.079713500000001e-10,
                            -7.079713500000001e-10,
                            7.079713500000001e-10],
                           [-7.079713500000001e-10,
                            7.079713500000001e-10,
                            7.079713500000001e-10],
                           [7.079713500000001e-10,
                            -7.079713500000001e-10,
                            7.079713500000001e-10],
                           [7.079713500000001e-10,
                            7.079713500000001e-10,
                            -7.079713500000001e-10],
                           [0.0, 1.213606e-10, 3.1862335e-10],
                           [0.0, -1.213606e-10, -3.1862335e-10],
                           [3.1862335e-10, 0.0, 1.213606e-10],
                           [-3.1862335e-10, 0.0, -1.213606e-10],
                           [1.213606e-10, 3.1862335e-10, 0.0],
                           [-1.213606e-10, -3.1862335e-10, 0.0],
                           [0.0, 1.213606e-10, -3.1862335e-10],
                           [0.0, -1.213606e-10, 3.1862335e-10],
                           [-3.1862335e-10, 0.0, 1.213606e-10],
                           [3.1862335e-10, 0.0, -1.213606e-10],
                           [1.213606e-10, -3.1862335e-10, 0.0],
                           [-1.213606e-10, 3.1862335e-10, 0.0],
                           [5.1775e-10, 8.363733500000001e-10, 6.391106e-10],
                           [5.1775e-10, -8.363733500000001e-10, -6.391106e-10],
                           [5.1775e-10, -8.363733500000001e-10, 6.391106e-10],
                           [5.1775e-10, 8.363733500000001e-10, -6.391106e-10],
                           [6.391106e-10, 5.1775e-10, 8.363733500000001e-10],
                           [-6.391106e-10, 5.1775e-10, -8.363733500000001e-10],
                           [6.391106e-10, 5.1775e-10, -8.363733500000001e-10],
                           [-6.391106e-10, 5.1775e-10, 8.363733500000001e-10],
                           [8.363733500000001e-10, 6.391106e-10, 5.1775e-10],
                           [-8.363733500000001e-10, -6.391106e-10, 5.1775e-10],
                           [-8.363733500000001e-10, 6.391106e-10, 5.1775e-10],
                           [8.363733500000001e-10, -6.391106e-10, 5.1775e-10]],
        'lattice_vectors': [[1.0355e-09, 0.0, 0.0],
                            [0.0, 1.0355e-09, 0.0],
                            [0.0, 0.0, 1.0355e-09]],
        'normalized_wyckoff': {'d': {'X_0': 3},
                               'i': {'X_0': 8},
                               'k': {'X_0': 12}},
        'normalized_wysytax': {'d': {'X_0': 3},
                               'i': {'X_0': 8},
                               'k': {'X_0': 12}}}],
 224: [{'Notes': 'cuprite',
        'Pearsons Symbol': 'cP6',
        'Prototype': 'Ag2O',
        'Space Group': 'Pn3m',
        'Space Group Number': 224,
        'Strukturbericht Designation': 'C3',
        'Wyckoff Positions': 'ab',
        'aflow_prototype_id': 'A2B_cP6_224_b_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2B_cP6_224_b_a.html',
        'atom_labels': ['Ag', 'Ag', 'Ag', 'Ag', 'O', 'O'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [0.0, 2.3615e-10, 2.3615e-10],
                           [2.3615e-10, 0.0, 2.3615e-10],
                           [2.3615e-10, 2.3615e-10, 0.0],
                           [1.18075e-10, 1.18075e-10, 1.18075e-10],
                           [3.5422500000000004e-10,
                            3.5422500000000004e-10,
                            3.5422500000000004e-10]],
        'lattice_vectors': [[4.723e-10, 0.0, 0.0],
                            [0.0, 4.723e-10, 0.0],
                            [0.0, 0.0, 4.723e-10]],
        'normalized_wyckoff': {'a': {'X_1': 1}, 'c': {'X_0': 2}},
        'normalized_wysytax': {'a': {'X_1': 1}, 'c': {'X_0': 2}}}],
 225: [{'Notes': 'Heusler',
        'Pearsons Symbol': 'cF16',
        'Prototype': 'AlCu2Mn',
        'Space Group': 'Fm3m',
        'Space Group Number': 225,
        'Strukturbericht Designation': 'L21',
        'Wyckoff Positions': 'abc',
        'aflow_prototype_id': 'AB2C_cF16_225_a_c_b',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB2C_cF16_225_a_c_b.html',
        'atom_labels': ['Al', 'Mn', 'Cu', 'Cu'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [2.9785e-10, 2.9785e-10, 2.9785e-10],
                           [-1.48925e-10, -1.48925e-10, -1.48925e-10],
                           [1.48925e-10, 1.48925e-10, 1.48925e-10]],
        'lattice_vectors': [[0.0, 2.9785e-10, 2.9785e-10],
                            [2.9785e-10, 0.0, 2.9785e-10],
                            [2.9785e-10, 2.9785e-10, 0.0]],
        'normalized_wyckoff': {'a': {'X_1': 1},
                               'b': {'X_2': 1},
                               'c': {'X_0': 2}},
        'normalized_wysytax': {'a': {'X_1': 1},
                               'b': {'X_2': 1},
                               'c': {'X_0': 2}}},
       {'Notes': '-',
        'Pearsons Symbol': 'cF16',
        'Prototype': 'AlFe3',
        'Space Group': 'Fm3m',
        'Space Group Number': 225,
        'Strukturbericht Designation': 'D03',
        'Wyckoff Positions': 'abc',
        'aflow_prototype_id': 'AB3_cF16_225_a_bc',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB3_cF16_225_a_bc.html',
        'atom_labels': ['Al', 'Fe', 'Fe', 'Fe'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [3e-10, 0.0, 0.0],
                           [-1.5e-10, -1.5e-10, -1.5e-10],
                           [1.5e-10, 1.5e-10, 1.5e-10]],
        'lattice_vectors': [[0.0, 3e-10, 3e-10],
                            [3e-10, 0.0, 3e-10],
                            [3e-10, 3e-10, 0.0]],
        'normalized_wyckoff': {'a': {'X_1': 1},
                               'b': {'X_0': 1},
                               'c': {'X_0': 2}},
        'normalized_wysytax': {'a': {'X_1': 1},
                               'b': {'X_0': 1},
                               'c': {'X_0': 2}}},
       {'Notes': '-',
        'Pearsons Symbol': 'cF52',
        'Prototype': 'B12U',
        'Space Group': 'Fm3m',
        'Space Group Number': 225,
        'Strukturbericht Designation': 'D2f',
        'Wyckoff Positions': 'ai',
        'aflow_prototype_id': 'A12B_cF52_225_i_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A12B_cF52_225_i_a.html',
        'atom_labels': ['U',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B',
                        'B'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [3.7385e-10, 1.24616667e-10, 1.24616667e-10],
                           [1.24616667e-10, 3.7385e-10, 1.24616667e-10],
                           [1.24616667e-10, 1.24616667e-10, 3.7385e-10],
                           [0.0, 1.24616667e-10, 2.49233333e-10],
                           [1.24616667e-10, 0.0, 2.49233333e-10],
                           [1.24616667e-10, 2.49233333e-10, 0.0],
                           [3.7385e-10, 2.49233333e-10, 2.49233333e-10],
                           [2.49233333e-10, 3.7385e-10, 2.49233333e-10],
                           [2.49233333e-10, 2.49233333e-10, 3.7385e-10],
                           [0.0, 2.49233333e-10, 1.24616667e-10],
                           [2.49233333e-10, 0.0, 1.24616667e-10],
                           [2.49233333e-10, 1.24616667e-10, 0.0]],
        'lattice_vectors': [[0.0, 3.7385e-10, 3.7385e-10],
                            [3.7385e-10, 0.0, 3.7385e-10],
                            [3.7385e-10, 3.7385e-10, 0.0]],
        'normalized_wyckoff': {'a': {'X_1': 1}, 'i': {'X_0': 12}},
        'normalized_wysytax': {'a': {'X_1': 1}, 'i': {'X_0': 12}}},
       {'Notes': '-',
        'Pearsons Symbol': 'cF116',
        'Prototype': 'C6Cr23',
        'Space Group': 'Fm3m',
        'Space Group Number': 225,
        'Strukturbericht Designation': 'D84',
        'Wyckoff Positions': 'acefh',
        'aflow_prototype_id': 'A6B23_cF116_225_e_acfh',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A6B23_cF116_225_e_acfh.html',
        'atom_labels': ['Mn',
                        'Fe',
                        'Fe',
                        'C',
                        'C',
                        'C',
                        'C',
                        'C',
                        'C',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Cr',
                        'Cr',
                        'Cr',
                        'Cr',
                        'Cr',
                        'Cr',
                        'Cr',
                        'Cr',
                        'Cr',
                        'Cr',
                        'Cr',
                        'Cr'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [2.6625000000000004e-10,
                            2.6625000000000004e-10,
                            2.6625000000000004e-10],
                           [7.987500000000001e-10,
                            7.987500000000001e-10,
                            7.987500000000001e-10],
                           [2.9447250000000004e-10, 0.0, 0.0],
                           [-2.9447250000000004e-10, 0.0, 0.0],
                           [0.0, 2.9447250000000004e-10, 0.0],
                           [0.0, -2.9447250000000004e-10, 0.0],
                           [0.0, 0.0, 2.9447250000000004e-10],
                           [0.0, 0.0, -2.9447250000000004e-10],
                           [4.056585e-10, 4.056585e-10, 4.056585e-10],
                           [-4.056585e-10, -4.056585e-10, 4.056585e-10],
                           [-4.056585e-10, 4.056585e-10, -4.056585e-10],
                           [4.056585e-10, -4.056585e-10, -4.056585e-10],
                           [-4.056585e-10, -4.056585e-10, -4.056585e-10],
                           [4.056585e-10, 4.056585e-10, -4.056585e-10],
                           [4.056585e-10, -4.056585e-10, 4.056585e-10],
                           [-4.056585e-10, 4.056585e-10, 4.056585e-10],
                           [0.0, 1.809435e-10, 1.809435e-10],
                           [0.0, -1.809435e-10, 1.809435e-10],
                           [0.0, 1.809435e-10, -1.809435e-10],
                           [0.0, -1.809435e-10, -1.809435e-10],
                           [1.809435e-10, 1.809435e-10, 0.0],
                           [-1.809435e-10, 1.809435e-10, 0.0],
                           [1.809435e-10, -1.809435e-10, 0.0],
                           [-1.809435e-10, -1.809435e-10, 0.0],
                           [1.809435e-10, 0.0, 1.809435e-10],
                           [1.809435e-10, 0.0, -1.809435e-10],
                           [-1.809435e-10, 0.0, 1.809435e-10],
                           [-1.809435e-10, 0.0, -1.809435e-10]],
        'lattice_vectors': [[0.0, 5.325000000000001e-10, 5.325000000000001e-10],
                            [5.325000000000001e-10, 0.0, 5.325000000000001e-10],
                            [5.325000000000001e-10,
                             5.325000000000001e-10,
                             0.0]],
        'normalized_wyckoff': {'a': {'X_4': 1},
                               'c': {'X_3': 2},
                               'e': {'X_2': 6},
                               'f': {'X_1': 8},
                               'h': {'X_0': 12}},
        'normalized_wysytax': {'a': {'X_4': 1},
                               'c': {'X_2': 2},
                               'e': {'X_1': 6},
                               'f': {'X_0': 8},
                               'h': {'X_3': 2}}},
       {'Notes': 'fluorite',
        'Pearsons Symbol': 'cF12',
        'Prototype': 'CaF2',
        'Space Group': 'Fm3m',
        'Space Group Number': 225,
        'Strukturbericht Designation': 'C1',
        'Wyckoff Positions': 'ac',
        'aflow_prototype_id': 'AB2_cF12_225_a_c',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB2_cF12_225_a_c.html',
        'atom_labels': ['Ca', 'F', 'F'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [1.3657375e-10, 1.3657375e-10, 1.3657375e-10],
                           [4.0972125000000004e-10,
                            4.0972125000000004e-10,
                            4.0972125000000004e-10]],
        'lattice_vectors': [[0.0, 2.731475e-10, 2.731475e-10],
                            [2.731475e-10, 0.0, 2.731475e-10],
                            [2.731475e-10, 2.731475e-10, 0.0]],
        'normalized_wyckoff': {'a': {'X_1': 1}, 'c': {'X_0': 2}},
        'normalized_wysytax': {'a': {'X_1': 1}, 'c': {'X_0': 2}}},
       {'Notes': '-',
        'Pearsons Symbol': 'cF32',
        'Prototype': 'Ca7Ge',
        'Space Group': 'Fm3m',
        'Space Group Number': 225,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'abd',
        'aflow_prototype_id': 'A7B_cF32_225_bd_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A7B_cF32_225_bd_a.html',
        'atom_labels': ['Ge', 'Ca', 'Ca', 'Ca', 'Ca', 'Ca', 'Ca', 'Ca'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [0.0, 2.3625e-10, 2.3625e-10],
                           [2.3625e-10, 0.0, 2.3625e-10],
                           [2.3625e-10, 2.3625e-10, 0.0],
                           [0.0, -2.3625e-10, 2.3625e-10],
                           [-2.3625e-10, 0.0, 2.3625e-10],
                           [-2.3625e-10, 2.3625e-10, 0.0],
                           [4.725e-10, 4.725e-10, 4.725e-10]],
        'lattice_vectors': [[0.0, 4.725e-10, 4.725e-10],
                            [4.725e-10, 0.0, 4.725e-10],
                            [4.725e-10, 4.725e-10, 0.0]],
        'normalized_wyckoff': {'a': {'X_1': 1},
                               'b': {'X_0': 1},
                               'd': {'X_0': 6}},
        'normalized_wysytax': {'a': {'X_1': 1},
                               'b': {'X_0': 1},
                               'd': {'X_0': 2}}},
       {'Notes': 'rock salt',
        'Pearsons Symbol': 'cF8',
        'Prototype': 'ClNa',
        'Space Group': 'Fm3m',
        'Space Group Number': 225,
        'Strukturbericht Designation': 'B1',
        'Wyckoff Positions': 'ab',
        'aflow_prototype_id': 'AB_cF8_225_a_b',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_cF8_225_a_b.html',
        'atom_labels': ['Na', 'Cl'],
        'atom_positions': [[0.0, 0.0, 0.0], [2.815e-10, 2.815e-10, 2.815e-10]],
        'lattice_vectors': [[0.0, 2.815e-10, 2.815e-10],
                            [2.815e-10, 0.0, 2.815e-10],
                            [2.815e-10, 2.815e-10, 0.0]],
        'normalized_wyckoff': {'a': {'X_0': 1}, 'b': {'X_1': 1}},
        'normalized_wysytax': {'a': {'X_0': 1}, 'b': {'X_1': 1}}},
       {'Notes': 'hypothetical austenite structure',
        'Pearsons Symbol': 'cF108',
        'Prototype': 'CrFe18Ni8',
        'Space Group': 'Fm3m',
        'Space Group Number': 225,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'aefh',
        'aflow_prototype_id': 'AB18C8_cF108_225_a_eh_f',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB18C8_cF108_225_a_eh_f.html',
        'atom_labels': ['Cr',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [0.0, 1.6896e-10, 1.6896e-10],
                           [1.6896e-10, 0.0, 1.6896e-10],
                           [1.6896e-10, 1.6896e-10, 0.0],
                           [0.0, 1.6896e-10, -1.6896e-10],
                           [1.6896e-10, 0.0, -1.6896e-10],
                           [1.6896e-10, -1.6896e-10, 0.0],
                           [0.0, -1.6896e-10, 1.6896e-10],
                           [-1.6896e-10, 0.0, 1.6896e-10],
                           [-1.6896e-10, 1.6896e-10, 0.0],
                           [0.0, -1.6896e-10, -1.6896e-10],
                           [-1.6896e-10, 0.0, -1.6896e-10],
                           [-1.6896e-10, -1.6896e-10, 0.0],
                           [3.432e-10, 0.0, 0.0],
                           [0.0, 3.432e-10, 0.0],
                           [0.0, 0.0, 3.432e-10],
                           [-3.432e-10, 0.0, 0.0],
                           [0.0, -3.432e-10, 0.0],
                           [0.0, 0.0, -3.432e-10],
                           [3.6080352000000005e-10,
                            3.6080352000000005e-10,
                            3.6080352000000005e-10],
                           [-3.6080352000000005e-10,
                            3.6079824e-10,
                            3.6079824e-10],
                           [3.6079824e-10,
                            -3.6080352000000005e-10,
                            3.6079824e-10],
                           [3.6079824e-10,
                            3.6079824e-10,
                            -3.6080352000000005e-10],
                           [-3.6080352000000005e-10,
                            -3.6080352000000005e-10,
                            -3.6080352000000005e-10],
                           [3.6080352000000005e-10,
                            -3.6079824e-10,
                            -3.6079824e-10],
                           [-3.6079824e-10,
                            3.6080352000000005e-10,
                            -3.6079824e-10],
                           [-3.6079824e-10,
                            -3.6079824e-10,
                            3.6080352000000005e-10]],
        'lattice_vectors': [[0.0, 5.28e-10, 5.28e-10],
                            [5.28e-10, 0.0, 5.28e-10],
                            [5.28e-10, 5.28e-10, 0.0]],
        'normalized_wyckoff': {'a': {'X_2': 1},
                               'e': {'X_0': 6},
                               'f': {'X_1': 8},
                               'h': {'X_0': 12}},
        'normalized_wysytax': {'a': {'X_2': 1},
                               'e': {'X_0': 6},
                               'f': {'X_1': 8},
                               'h': {'X_0': 3}}},
       {'Notes': 'hypothetical ferrite structure',
        'Pearsons Symbol': 'cF128',
        'Prototype': 'Cr9Fe16Ni7',
        'Space Group': 'Fm3m',
        'Space Group Number': 225,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'abcdef2',
        'aflow_prototype_id': 'A9B16C7_cF128_225_acd_2f_be',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A9B16C7_cF128_225_acd_2f_be.html',
        'atom_labels': ['Cr',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Cr',
                        'Cr',
                        'Cr',
                        'Cr',
                        'Cr',
                        'Cr',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Cr',
                        'Cr',
                        'Ni'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [1.3776e-10, 1.3776e-10, 1.3776e-10],
                           [-1.3776e-10, 1.3776e-10, 1.3776e-10],
                           [1.3776e-10, -1.3776e-10, 1.3776e-10],
                           [1.3776e-10, 1.3776e-10, -1.3776e-10],
                           [-1.3776e-10, -1.3776e-10, -1.3776e-10],
                           [1.3776e-10, -1.3776e-10, -1.3776e-10],
                           [-1.3776e-10, 1.3776e-10, -1.3776e-10],
                           [-1.3776e-10, -1.3776e-10, 1.3776e-10],
                           [2.97332e-10, 0.0, 0.0],
                           [0.0, 2.97332e-10, 0.0],
                           [0.0, 0.0, 2.97332e-10],
                           [-2.97332e-10, 0.0, 0.0],
                           [0.0, -2.97332e-10, 0.0],
                           [0.0, 0.0, -2.97332e-10],
                           [0.0,
                            2.8700000000000004e-10,
                            2.8700000000000004e-10],
                           [2.8700000000000004e-10,
                            0.0,
                            2.8700000000000004e-10],
                           [2.8700000000000004e-10,
                            2.8700000000000004e-10,
                            0.0],
                           [0.0,
                            2.8700000000000004e-10,
                            -2.8700000000000004e-10],
                           [2.8700000000000004e-10,
                            0.0,
                            -2.8700000000000004e-10],
                           [2.8700000000000004e-10,
                            -2.8700000000000004e-10,
                            0.0],
                           [4.1902e-10,
                            -1.5498000000000002e-10,
                            -1.5498000000000002e-10],
                           [-4.1902e-10,
                            -1.5498000000000002e-10,
                            -1.5498000000000002e-10],
                           [-1.5498000000000002e-10,
                            -4.1902e-10,
                            -1.5498000000000002e-10],
                           [-1.5498000000000002e-10,
                            -1.5498000000000002e-10,
                            -4.1902e-10],
                           [-4.1902e-10,
                            1.5498000000000002e-10,
                            1.5498000000000002e-10],
                           [4.1902e-10,
                            1.5498000000000002e-10,
                            1.5498000000000002e-10],
                           [1.5498000000000002e-10,
                            4.1902e-10,
                            1.5498000000000002e-10],
                           [1.5498000000000002e-10,
                            1.5498000000000002e-10,
                            4.1902e-10],
                           [2.8700000000000004e-10,
                            2.8700000000000004e-10,
                            2.8700000000000004e-10],
                           [-2.8700000000000004e-10,
                            -2.8700000000000004e-10,
                            -2.8700000000000004e-10],
                           [5.740000000000001e-10, 0.0, 0.0]],
        'lattice_vectors': [[0.0, 5.740000000000001e-10, 5.740000000000001e-10],
                            [5.740000000000001e-10, 0.0, 5.740000000000001e-10],
                            [5.740000000000001e-10,
                             5.740000000000001e-10,
                             0.0]],
        'normalized_wyckoff': {'a': {'X_1': 1},
                               'b': {'X_2': 1},
                               'c': {'X_1': 2},
                               'd': {'X_1': 6},
                               'e': {'X_2': 6},
                               'f': {'X_0': 16}},
        'normalized_wysytax': {'a': {'X_2': 1},
                               'b': {'X_1': 1},
                               'c': {'X_2': 2},
                               'd': {'X_2': 3},
                               'e': {'X_1': 6},
                               'f': {'X_0': 16}}},
       {'Notes': 'fcc',
        'Pearsons Symbol': 'cF4',
        'Prototype': 'Cu',
        'Space Group': 'Fm3m',
        'Space Group Number': 225,
        'Strukturbericht Designation': 'A1',
        'Wyckoff Positions': 'a',
        'aflow_prototype_id': 'A_cF4_225_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_cF4_225_a.html',
        'atom_labels': ['Au'],
        'atom_positions': [[0.0, 0.0, 0.0]],
        'lattice_vectors': [[0.0,
                             2.0400000000000002e-10,
                             2.0400000000000002e-10],
                            [2.0400000000000002e-10,
                             0.0,
                             2.0400000000000002e-10],
                            [2.0400000000000002e-10,
                             2.0400000000000002e-10,
                             0.0]],
        'normalized_wyckoff': {'a': {'X_0': 1}},
        'normalized_wysytax': {'a': {'X_0': 1}}}],
 227: [{'Notes': 'spinel',
        'Pearsons Symbol': 'cF56',
        'Prototype': 'Al2MgO4',
        'Space Group': 'Fd3m',
        'Space Group Number': 227,
        'Strukturbericht Designation': 'H11',
        'Wyckoff Positions': 'ade',
        'aflow_prototype_id': 'A2BC4_cF56_227_d_a_e',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2BC4_cF56_227_d_a_e.html',
        'atom_labels': ['Mg',
                        'Mg',
                        'Al',
                        'Al',
                        'Al',
                        'Al',
                        'O',
                        'O',
                        'O',
                        'O',
                        'O',
                        'O',
                        'O',
                        'O'],
        'atom_positions': [[1.009375e-10, 1.009375e-10, 1.009375e-10],
                           [-1.009375e-10, -1.009375e-10, -1.009375e-10],
                           [4.0375e-10, 4.0375e-10, 4.0375e-10],
                           [4.0375e-10, 2.01875e-10, 2.01875e-10],
                           [2.01875e-10, 4.0375e-10, 2.01875e-10],
                           [2.01875e-10, 2.01875e-10, 4.0375e-10],
                           [1.9057e-10, 1.9057e-10, 1.9057e-10],
                           [1.9057e-10, 1.1305e-11, 1.1305e-11],
                           [1.1305e-11, 1.9057e-10, 1.1305e-11],
                           [1.1305e-11, 1.1305e-11, 1.9057e-10],
                           [-1.9057e-10, -1.9057e-10, -1.9057e-10],
                           [-1.9057e-10, -1.1305e-11, -1.1305e-11],
                           [-1.1305e-11, -1.9057e-10, -1.1305e-11],
                           [-1.1305e-11, -1.1305e-11, -1.9057e-10]],
        'lattice_vectors': [[0.0, 4.0375e-10, 4.0375e-10],
                            [4.0375e-10, 0.0, 4.0375e-10],
                            [4.0375e-10, 4.0375e-10, 0.0]],
        'normalized_wyckoff': {'b': {'X_2': 1},
                               'c': {'X_1': 2},
                               'e': {'X_0': 4}},
        'normalized_wysytax': {'b': {'X_2': 1},
                               'c': {'X_1': 2},
                               'e': {'X_0': 4}}},
       {'Notes': 'diamond',
        'Pearsons Symbol': 'cF8',
        'Prototype': 'C',
        'Space Group': 'Fd3m',
        'Space Group Number': 227,
        'Strukturbericht Designation': 'A4',
        'Wyckoff Positions': 'a',
        'aflow_prototype_id': 'A_cF8_227_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_cF8_227_a.html',
        'atom_labels': ['C', 'C'],
        'atom_positions': [[4.4375e-11, 4.4375e-11, 4.4375e-11],
                           [3.10625e-10, 3.10625e-10, 3.10625e-10]],
        'lattice_vectors': [[0.0, 1.775e-10, 1.775e-10],
                            [1.775e-10, 0.0, 1.775e-10],
                            [1.775e-10, 1.775e-10, 0.0]],
        'normalized_wyckoff': {'a': {'X_0': 1}},
        'normalized_wysytax': {'b': {'X_0': 1}}},
       {'Notes': '-',
        'Pearsons Symbol': 'cF112',
        'Prototype': 'CFe3W3',
        'Space Group': 'Fd3m',
        'Space Group Number': 227,
        'Strukturbericht Designation': 'E93',
        'Wyckoff Positions': 'cdef',
        'aflow_prototype_id': 'AB3C3_cF112_227_c_de_f',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB3C3_cF112_227_c_de_f.html',
        'atom_labels': ['C',
                        'C',
                        'C',
                        'C',
                        'Cr',
                        'Cr',
                        'Cr',
                        'Cr',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'W',
                        'W',
                        'W',
                        'W',
                        'W',
                        'W',
                        'W',
                        'W',
                        'W',
                        'W',
                        'W',
                        'W'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [0.0, 2.76e-10, 2.76e-10],
                           [2.76e-10, 0.0, 2.76e-10],
                           [2.76e-10, 2.76e-10, 0.0],
                           [0.0, -2.76e-10, 2.76e-10],
                           [-2.76e-10, 0.0, 2.76e-10],
                           [-2.76e-10, 2.76e-10, 0.0],
                           [5.52e-10, 0.0, 0.0],
                           [5.520000000000001e-11,
                            5.520000000000001e-11,
                            5.520000000000001e-11],
                           [2.2080000000000003e-10,
                            2.2080000000000003e-10,
                            5.520000000000001e-11],
                           [2.2080000000000003e-10,
                            5.520000000000001e-11,
                            2.2080000000000003e-10],
                           [5.520000000000001e-11,
                            2.2080000000000003e-10,
                            2.2080000000000003e-10],
                           [-5.520000000000001e-11,
                            -5.520000000000001e-11,
                            -5.520000000000001e-11],
                           [-2.2080000000000003e-10,
                            -2.2080000000000003e-10,
                            -5.520000000000001e-11],
                           [-2.2080000000000003e-10,
                            -5.520000000000001e-11,
                            -2.2080000000000003e-10],
                           [-5.520000000000001e-11,
                            -2.2080000000000003e-10,
                            -2.2080000000000003e-10],
                           [-7.728e-11, 1.38e-10, 1.38e-10],
                           [1.38e-10, -7.728e-11, 1.38e-10],
                           [1.38e-10, 1.38e-10, -7.728e-11],
                           [3.5328e-10, 1.38e-10, 1.38e-10],
                           [1.38e-10, 3.5328e-10, 1.38e-10],
                           [1.38e-10, 1.38e-10, 3.5328e-10],
                           [7.728e-11, -1.38e-10, -1.38e-10],
                           [-1.38e-10, 7.728e-11, -1.38e-10],
                           [-1.38e-10, -1.38e-10, 7.728e-11],
                           [-3.5328e-10, -1.38e-10, -1.38e-10],
                           [-1.38e-10, -3.5328e-10, -1.38e-10],
                           [-1.38e-10, -1.38e-10, -3.5328e-10]],
        'lattice_vectors': [[0.0, 5.52e-10, 5.52e-10],
                            [5.52e-10, 0.0, 5.52e-10],
                            [5.52e-10, 5.52e-10, 0.0]],
        'normalized_wysytax': {'c': {'X_2': 1},
                               'd': {'X_3': 1},
                               'e': {'X_1': 2},
                               'f': {'X_0': 3}}},
       {'Notes': 'also CTi2',
        'Pearsons Symbol': 'cF48',
        'Prototype': 'Ca33Ge',
        'Space Group': 'Fd3m',
        'Space Group Number': 227,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'ce',
        'aflow_prototype_id': 'AB2_cF48_227_c_e',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB2_cF48_227_c_e.html',
        'atom_labels': ['C',
                        'C',
                        'C',
                        'C',
                        'Ti',
                        'Ti',
                        'Ti',
                        'Ti',
                        'Ti',
                        'Ti',
                        'Ti',
                        'Ti'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [6.45e-10, 2.15e-10, 4.3e-10],
                           [2.15e-10, 4.3e-10, 6.45e-10],
                           [4.3e-10, 6.45e-10, 2.15e-10],
                           [2.1070000000000003e-10,
                            2.1070000000000003e-10,
                            2.1070000000000003e-10],
                           [4.343e-10, 4.3e-12, 6.407000000000001e-10],
                           [4.3e-12, 6.407000000000001e-10, 4.343e-10],
                           [6.407000000000001e-10, 4.343e-10, 4.3e-12],
                           [-2.1070000000000003e-10,
                            -2.1070000000000003e-10,
                            -2.1070000000000003e-10],
                           [8.557000000000001e-10, 4.257e-10, 2.193e-10],
                           [4.257e-10, 2.193e-10, 8.557000000000001e-10],
                           [2.193e-10, 8.557000000000001e-10, 4.257e-10]],
        'lattice_vectors': [[0.0, 4.3e-10, 4.3e-10],
                            [4.3e-10, 0.0, 4.3e-10],
                            [4.3e-10, 4.3e-10, 0.0]],
        'normalized_wyckoff': {'d': {'X_1': 1}, 'e': {'X_0': 2}},
        'normalized_wysytax': {'d': {'X_1': 1}, 'e': {'X_0': 2}}},
       {'Notes': 'cubic laves',
        'Pearsons Symbol': 'cF24',
        'Prototype': 'Cu2Mg',
        'Space Group': 'Fd3m',
        'Space Group Number': 227,
        'Strukturbericht Designation': 'C15',
        'Wyckoff Positions': 'ad',
        'aflow_prototype_id': 'A2B_cF24_227_d_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2B_cF24_227_d_a.html',
        'atom_labels': ['Mg', 'Mg', 'Cu', 'Cu', 'Cu', 'Cu'],
        'atom_positions': [[8.775e-11, 8.775e-11, 8.775e-11],
                           [-8.775e-11, -8.775e-11, -8.775e-11],
                           [3.51e-10, 3.51e-10, 3.51e-10],
                           [3.51e-10, 1.755e-10, 1.755e-10],
                           [1.755e-10, 3.51e-10, 1.755e-10],
                           [1.755e-10, 1.755e-10, 3.51e-10]],
        'lattice_vectors': [[0.0, 3.51e-10, 3.51e-10],
                            [3.51e-10, 0.0, 3.51e-10],
                            [3.51e-10, 3.51e-10, 0.0]],
        'normalized_wyckoff': {'b': {'X_1': 1}, 'c': {'X_0': 2}},
        'normalized_wysytax': {'b': {'X_1': 1}, 'c': {'X_0': 2}}},
       {'Notes': '-',
        'Pearsons Symbol': 'cF16',
        'Prototype': 'NaTl',
        'Space Group': 'Fd3m',
        'Space Group Number': 227,
        'Strukturbericht Designation': 'B32',
        'Wyckoff Positions': 'ab',
        'aflow_prototype_id': 'AB_cF16_227_a_b',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB_cF16_227_a_b.html',
        'atom_labels': ['Na', 'Na', 'Tl', 'Tl'],
        'atom_positions': [[9.35375e-11, 9.35375e-11, 9.35375e-11],
                           [6.547624999999999e-10,
                            6.547624999999999e-10,
                            6.547624999999999e-10],
                           [2.806125e-10, 2.806125e-10, 2.806125e-10],
                           [4.676875e-10, 4.676875e-10, 4.676875e-10]],
        'lattice_vectors': [[0.0, 3.7415e-10, 3.7415e-10],
                            [3.7415e-10, 0.0, 3.7415e-10],
                            [3.7415e-10, 3.7415e-10, 0.0]],
        'normalized_wyckoff': {'a': {'X_0': 1}, 'b': {'X_1': 1}},
        'normalized_wysytax': {'a': {'X_0': 1}, 'b': {'X_1': 1}}},
       {'Notes': '-',
        'Pearsons Symbol': 'cF96',
        'Prototype': 'NiTi2',
        'Space Group': 'Fd3m',
        'Space Group Number': 227,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'def',
        'aflow_prototype_id': 'AB2_cF96_227_e_cf',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB2_cF96_227_e_cf.html',
        'atom_labels': ['Ti',
                        'Ti',
                        'Ti',
                        'Ti',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ti',
                        'Ti',
                        'Ti',
                        'Ti',
                        'Ti',
                        'Ti',
                        'Ti',
                        'Ti',
                        'Ti',
                        'Ti',
                        'Ti',
                        'Ti'],
        'atom_positions': [[5.65965e-10, 2.829825e-10, 2.829825e-10],
                           [2.829825e-10, 5.65965e-10, 2.829825e-10],
                           [2.829825e-10, 2.829825e-10, 5.65965e-10],
                           [5.65965e-10, 5.65965e-10, 5.65965e-10],
                           [3.34824894e-10, 3.34824894e-10, 3.34824894e-10],
                           [5.14122606e-10, 5.14122606e-10, 3.34824894e-10],
                           [5.14122606e-10, 3.34824894e-10, 5.14122606e-10],
                           [3.34824894e-10, 5.14122606e-10, 5.14122606e-10],
                           [-3.34824894e-10, -3.34824894e-10, -3.34824894e-10],
                           [-5.14122606e-10, -5.14122606e-10, -3.34824894e-10],
                           [-5.14122606e-10, -3.34824894e-10, -5.14122606e-10],
                           [-3.34824894e-10, -5.14122606e-10, -5.14122606e-10],
                           [-1.4149125e-10, -1.4149125e-10, 8.1385767e-11],
                           [-1.4149125e-10, 8.1385767e-11, -1.4149125e-10],
                           [8.1385767e-11, -1.4149125e-10, -1.4149125e-10],
                           [-3.64368267e-10, -1.4149125e-10, -1.4149125e-10],
                           [-1.4149125e-10, -3.64368267e-10, -1.4149125e-10],
                           [-1.4149125e-10, -1.4149125e-10, -3.64368267e-10],
                           [1.4149125e-10, 1.4149125e-10, -8.1385767e-11],
                           [1.4149125e-10, -8.1385767e-11, 1.4149125e-10],
                           [-8.1385767e-11, 1.4149125e-10, 1.4149125e-10],
                           [3.64368267e-10, 1.4149125e-10, 1.4149125e-10],
                           [1.4149125e-10, 3.64368267e-10, 1.4149125e-10],
                           [1.4149125e-10, 1.4149125e-10, 3.64368267e-10]],
        'lattice_vectors': [[0.0, 5.65965e-10, 5.65965e-10],
                            [5.65965e-10, 0.0, 5.65965e-10],
                            [5.65965e-10, 5.65965e-10, 0.0]],
        'normalized_wysytax': {'c': {'X_0': 1},
                               'e': {'X_1': 2},
                               'f': {'X_0': 3}}},
       {'Notes': 'ideal beta cristobalite',
        'Pearsons Symbol': 'cF24',
        'Prototype': 'O2Si',
        'Space Group': 'Fd3m',
        'Space Group Number': 227,
        'Strukturbericht Designation': 'C9',
        'Wyckoff Positions': 'ac',
        'aflow_prototype_id': 'A2B_cF24_227_c_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2B_cF24_227_c_a.html',
        'atom_labels': ['O', 'O', 'O', 'O', 'Si', 'Si'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [1.7915e-10, 1.7915e-10, 0.0],
                           [1.7915e-10, 0.0, 1.7915e-10],
                           [0.0, 1.7915e-10, 1.7915e-10],
                           [8.9575e-11, 8.9575e-11, 8.9575e-11],
                           [6.270249999999999e-10,
                            6.270249999999999e-10,
                            6.270249999999999e-10]],
        'lattice_vectors': [[0.0, 3.583e-10, 3.583e-10],
                            [3.583e-10, 0.0, 3.583e-10],
                            [3.583e-10, 3.583e-10, 0.0]],
        'normalized_wyckoff': {'a': {'X_1': 1}, 'c': {'X_0': 2}},
        'normalized_wysytax': {'b': {'X_1': 1}, 'd': {'X_0': 2}}},
       {'Notes': 'clathrate',
        'Pearsons Symbol': 'cF136',
        'Prototype': 'Si34',
        'Space Group': 'Fd3m',
        'Space Group Number': 227,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'aeg',
        'aflow_prototype_id': 'A_cF136_227_aeg',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_cF136_227_aeg.html',
        'atom_labels': ['Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si',
                        'Si'],
        'atom_positions': [[1.8580000000000002e-10,
                            1.8580000000000002e-10,
                            1.8580000000000002e-10],
                           [-1.8580000000000002e-10,
                            -1.8580000000000002e-10,
                            -1.8580000000000002e-10],
                           [3.2314336e-10, 3.2314336e-10, 3.2314336e-10],
                           [3.2314336e-10,
                            4.8456640000000005e-11,
                            4.8456640000000005e-11],
                           [4.8456640000000005e-11,
                            3.2314336e-10,
                            4.8456640000000005e-11],
                           [4.8456640000000005e-11,
                            4.8456640000000005e-11,
                            3.2314336e-10],
                           [-3.2314336e-10, -3.2314336e-10, -3.2314336e-10],
                           [-3.2314336e-10,
                            -4.8456640000000005e-11,
                            -4.8456640000000005e-11],
                           [-4.8456640000000005e-11,
                            -3.2314336e-10,
                            -4.8456640000000005e-11],
                           [-4.8456640000000005e-11,
                            -4.8456640000000005e-11,
                            -3.2314336e-10],
                           [2.7111936000000003e-10,
                            2.7111936000000003e-10,
                            5.5011664e-10],
                           [2.7111936000000003e-10,
                            1.0048064000000002e-10,
                            -1.7851664000000002e-10],
                           [1.0048064000000002e-10,
                            2.7111936000000003e-10,
                            -1.7851664000000002e-10],
                           [1.0048064000000002e-10,
                            1.0048064000000002e-10,
                            5.5011664e-10],
                           [-2.7111936000000003e-10,
                            -2.7111936000000003e-10,
                            -5.5011664e-10],
                           [-2.7111936000000003e-10,
                            -1.0048064000000002e-10,
                            1.7851664000000002e-10],
                           [-1.0048064000000002e-10,
                            -2.7111936000000003e-10,
                            1.7851664000000002e-10],
                           [-1.0048064000000002e-10,
                            -1.0048064000000002e-10,
                            -5.5011664e-10],
                           [5.5011664e-10,
                            2.7111936000000003e-10,
                            2.7111936000000003e-10],
                           [5.5011664e-10,
                            1.0048064000000002e-10,
                            1.0048064000000002e-10],
                           [-1.7851664000000002e-10,
                            2.7111936000000003e-10,
                            1.0048064000000002e-10],
                           [-1.7851664000000002e-10,
                            1.0048064000000002e-10,
                            2.7111936000000003e-10],
                           [-5.5011664e-10,
                            -2.7111936000000003e-10,
                            -2.7111936000000003e-10],
                           [-5.5011664e-10,
                            -1.0048064000000002e-10,
                            -1.0048064000000002e-10],
                           [1.7851664000000002e-10,
                            -2.7111936000000003e-10,
                            -1.0048064000000002e-10],
                           [1.7851664000000002e-10,
                            -1.0048064000000002e-10,
                            -2.7111936000000003e-10],
                           [2.7111936000000003e-10,
                            5.5011664e-10,
                            2.7111936000000003e-10],
                           [2.7111936000000003e-10,
                            -1.7851664000000002e-10,
                            1.0048064000000002e-10],
                           [1.0048064000000002e-10,
                            5.5011664e-10,
                            1.0048064000000002e-10],
                           [1.0048064000000002e-10,
                            -1.7851664000000002e-10,
                            2.7111936000000003e-10],
                           [-2.7111936000000003e-10,
                            -5.5011664e-10,
                            -2.7111936000000003e-10],
                           [-2.7111936000000003e-10,
                            1.7851664000000002e-10,
                            -1.0048064000000002e-10],
                           [-1.0048064000000002e-10,
                            -5.5011664e-10,
                            -1.0048064000000002e-10],
                           [-1.0048064000000002e-10,
                            1.7851664000000002e-10,
                            -2.7111936000000003e-10]],
        'lattice_vectors': [[0.0, 7.432000000000001e-10, 7.432000000000001e-10],
                            [7.432000000000001e-10, 0.0, 7.432000000000001e-10],
                            [7.432000000000001e-10,
                             7.432000000000001e-10,
                             0.0]],
        'normalized_wyckoff': {'b': {'X_0': 1},
                               'e': {'X_0': 4},
                               'g': {'X_0': 12}},
        'normalized_wysytax': {'b': {'X_0': 1},
                               'e': {'X_0': 4},
                               'g': {'X_0': 12}}}],
 229: [{'Notes': 'hypothetical ferrite structure',
        'Pearsons Symbol': 'cI16',
        'Prototype': 'CrFe4Ni3',
        'Space Group': 'Im3m',
        'Space Group Number': 229,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'abc',
        'aflow_prototype_id': 'AB4C3_cI16_229_a_c_b',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB4C3_cI16_229_a_c_b.html',
        'atom_labels': ['Cr', 'Fe', 'Fe', 'Fe', 'Fe', 'Ni', 'Ni', 'Ni'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [1.4350000000000002e-10,
                            1.4350000000000002e-10,
                            1.4350000000000002e-10],
                           [-1.4350000000000002e-10,
                            1.4350000000000002e-10,
                            1.4350000000000002e-10],
                           [1.4350000000000002e-10,
                            -1.4350000000000002e-10,
                            1.4350000000000002e-10],
                           [1.4350000000000002e-10,
                            1.4350000000000002e-10,
                            -1.4350000000000002e-10],
                           [2.8700000000000004e-10, 0.0, 0.0],
                           [0.0, 2.8700000000000004e-10, 0.0],
                           [0.0, 0.0, 2.8700000000000004e-10]],
        'lattice_vectors': [[-2.8700000000000004e-10,
                             2.8700000000000004e-10,
                             2.8700000000000004e-10],
                            [2.8700000000000004e-10,
                             -2.8700000000000004e-10,
                             2.8700000000000004e-10],
                            [2.8700000000000004e-10,
                             2.8700000000000004e-10,
                             -2.8700000000000004e-10]],
        'normalized_wyckoff': {'a': {'X_2': 1},
                               'b': {'X_1': 3},
                               'c': {'X_0': 4}},
        'normalized_wysytax': {'a': {'X_1': 1},
                               'b': {'X_0': 3},
                               'c': {'X_2': 1}}},
       {'Notes': 'hypothetical austenite structure',
        'Pearsons Symbol': 'cI32',
        'Prototype': 'CrFe12Ni3',
        'Space Group': 'Im3m',
        'Space Group Number': 229,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'abh',
        'aflow_prototype_id': 'AB12C3_cI32_229_a_h_b',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/AB12C3_cI32_229_a_h_b.html',
        'atom_labels': ['Cr',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Ni',
                        'Ni',
                        'Ni'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [0.0, 1.672e-10, 1.672e-10],
                           [1.672e-10, 0.0, 1.672e-10],
                           [1.672e-10, 1.672e-10, 0.0],
                           [0.0, 1.672e-10, -1.672e-10],
                           [1.672e-10, 0.0, -1.672e-10],
                           [1.672e-10, -1.672e-10, 0.0],
                           [0.0, -1.672e-10, 1.672e-10],
                           [-1.672e-10, 0.0, 1.672e-10],
                           [-1.672e-10, 1.672e-10, 0.0],
                           [0.0, -1.672e-10, -1.672e-10],
                           [-1.672e-10, 0.0, -1.672e-10],
                           [-1.672e-10, -1.672e-10, 0.0],
                           [3.52e-10, 0.0, 0.0],
                           [0.0, 3.52e-10, 0.0],
                           [0.0, 0.0, 3.52e-10]],
        'lattice_vectors': [[-3.52e-10, 3.52e-10, 3.52e-10],
                            [3.52e-10, -3.52e-10, 3.52e-10],
                            [3.52e-10, 3.52e-10, -3.52e-10]],
        'normalized_wyckoff': {'a': {'X_2': 1},
                               'b': {'X_1': 3},
                               'h': {'X_0': 12}},
        'normalized_wysytax': {'a': {'X_2': 1},
                               'b': {'X_1': 3},
                               'h': {'X_0': 6}}},
       {'Notes': 'hypothetical ferrite structure',
        'Pearsons Symbol': 'cI54',
        'Prototype': 'CrFe20Ni6',
        'Space Group': 'Im3m',
        'Space Group Number': 229,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'aefh',
        'aflow_prototype_id': 'A2B7_cI54_229_e_afh',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2B7_cI54_229_e_afh.html',
        'atom_labels': ['Cr',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe',
                        'Fe'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [1.2915000000000001e-10,
                            1.2915000000000001e-10,
                            1.2915000000000001e-10],
                           [-1.2915000000000001e-10,
                            1.2915000000000001e-10,
                            1.2915000000000001e-10],
                           [1.2915000000000001e-10,
                            -1.2915000000000001e-10,
                            1.2915000000000001e-10],
                           [1.2915000000000001e-10,
                            1.2915000000000001e-10,
                            -1.2915000000000001e-10],
                           [-1.2915000000000001e-10,
                            -1.2915000000000001e-10,
                            -1.2915000000000001e-10],
                           [1.2915000000000001e-10,
                            -1.2915000000000001e-10,
                            -1.2915000000000001e-10],
                           [-1.2915000000000001e-10,
                            1.2915000000000001e-10,
                            -1.2915000000000001e-10],
                           [-1.2915000000000001e-10,
                            -1.2915000000000001e-10,
                            1.2915000000000001e-10],
                           [2.9274e-10, 0.0, 0.0],
                           [0.0, 2.9274e-10, 0.0],
                           [0.0, 0.0, 2.9274e-10],
                           [-2.9274e-10, 0.0, 0.0],
                           [0.0, -2.9274e-10, 0.0],
                           [0.0, 0.0, -2.9274e-10],
                           [0.0, 2.7552e-10, 2.7552e-10],
                           [2.7552e-10, 0.0, 2.7552e-10],
                           [2.7552e-10, 2.7552e-10, 0.0],
                           [0.0, 2.7552e-10, -2.7552e-10],
                           [2.7552e-10, 0.0, -2.7552e-10],
                           [2.7552e-10, -2.7552e-10, 0.0],
                           [0.0, -2.7552e-10, -2.7552e-10],
                           [-2.7552e-10, 0.0, -2.7552e-10],
                           [-2.7552e-10, -2.7552e-10, 0.0],
                           [0.0, -2.7552e-10, 2.7552e-10],
                           [-2.7552e-10, 0.0, 2.7552e-10],
                           [-2.7552e-10, 2.7552e-10, 0.0]],
        'lattice_vectors': [[-4.305e-10, 4.305e-10, 4.305e-10],
                            [4.305e-10, -4.305e-10, 4.305e-10],
                            [4.305e-10, 4.305e-10, -4.305e-10]],
        'normalized_wyckoff': {'a': {'X_2': 1},
                               'e': {'X_1': 6},
                               'f': {'X_0': 8},
                               'h': {'X_0': 12}},
        'normalized_wysytax': {'a': {'X_2': 1},
                               'e': {'X_1': 6},
                               'f': {'X_0': 2},
                               'h': {'X_0': 6}}},
       {'Notes': '-',
        'Pearsons Symbol': 'cI5',
        'Prototype': 'La2O3',
        'Space Group': 'Im3m',
        'Space Group Number': 229,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'ab',
        'aflow_prototype_id': 'A3B_cI8_229_b_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A3B_cI8_229_b_a.html',
        'atom_labels': ['La', 'O', 'O', 'O'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [2.255e-10, 0.0, 0.0],
                           [0.0, 2.255e-10, 0.0],
                           [0.0, 0.0, 2.255e-10]],
        'lattice_vectors': [[-2.255e-10, 2.255e-10, 2.255e-10],
                            [2.255e-10, -2.255e-10, 2.255e-10],
                            [2.255e-10, 2.255e-10, -2.255e-10]],
        'normalized_wyckoff': {'a': {'X_1': 1}, 'b': {'X_0': 3}},
        'normalized_wysytax': {'a': {'X_1': 1}, 'b': {'X_0': 3}}},
       {'Notes': '-',
        'Pearsons Symbol': 'cI14',
        'Prototype': 'O4Pt3',
        'Space Group': 'Im3m',
        'Space Group Number': 229,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'bc',
        'aflow_prototype_id': 'A4B3_cI14_229_c_b',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A4B3_cI14_229_c_b.html',
        'atom_labels': ['O', 'O', 'O', 'O', 'Pt', 'Pt', 'Pt'],
        'atom_positions': [[1.5565e-10, 1.5565e-10, -1.5565e-10],
                           [1.5565e-10, -1.5565e-10, 1.5565e-10],
                           [-1.5565e-10, 1.5565e-10, 1.5565e-10],
                           [1.5565e-10, 1.5565e-10, 1.5565e-10],
                           [3.113e-10, 0.0, 0.0],
                           [0.0, 3.113e-10, 0.0],
                           [0.0, 0.0, 3.113e-10]],
        'lattice_vectors': [[-3.113e-10, 3.113e-10, 3.113e-10],
                            [3.113e-10, -3.113e-10, 3.113e-10],
                            [3.113e-10, 3.113e-10, -3.113e-10]],
        'normalized_wyckoff': {'b': {'X_1': 3}, 'c': {'X_0': 4}},
        'normalized_wysytax': {'b': {'X_0': 3}, 'c': {'X_1': 1}}},
       {'Notes': 'see CrFe20Ni6',
        'Pearsons Symbol': 'cI54',
        'Prototype': 'Sb2Tl7',
        'Space Group': 'Im3m',
        'Space Group Number': 229,
        'Strukturbericht Designation': 'L22',
        'Wyckoff Positions': 'aefh',
        'aflow_prototype_id': 'A2B7_cI54_229_e_afh',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A2B7_cI54_229_e_afh.html',
        'atom_labels': ['Tl',
                        'Tl',
                        'Tl',
                        'Tl',
                        'Tl',
                        'Tl',
                        'Tl',
                        'Tl',
                        'Tl',
                        'Sb',
                        'Sb',
                        'Sb',
                        'Sb',
                        'Sb',
                        'Sb',
                        'Tl',
                        'Tl',
                        'Tl',
                        'Tl',
                        'Tl',
                        'Tl',
                        'Tl',
                        'Tl',
                        'Tl',
                        'Tl',
                        'Tl',
                        'Tl'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [1.9797072000000002e-10,
                            1.9797072000000002e-10,
                            1.9797072000000002e-10],
                           [-1.9797072000000002e-10,
                            1.9797072000000002e-10,
                            1.9797072000000002e-10],
                           [1.9797072000000002e-10,
                            -1.9797072000000002e-10,
                            1.9797072000000002e-10],
                           [1.9797072000000002e-10,
                            1.9797072000000002e-10,
                            -1.9797072000000002e-10],
                           [-1.9797072000000002e-10,
                            -1.9797072000000002e-10,
                            -1.9797072000000002e-10],
                           [1.9797072000000002e-10,
                            -1.9797072000000002e-10,
                            -1.9797072000000002e-10],
                           [-1.9797072000000002e-10,
                            1.9797072000000002e-10,
                            -1.9797072000000002e-10],
                           [-1.9797072000000002e-10,
                            -1.9797072000000002e-10,
                            1.9797072000000002e-10],
                           [3.6457284e-10, 0.0, 0.0],
                           [0.0, 3.6457284e-10, 0.0],
                           [0.0, 0.0, 3.6457284e-10],
                           [-3.6457284e-10, 0.0, 0.0],
                           [0.0, -3.6457284e-10, 0.0],
                           [0.0, 0.0, -3.6457284e-10],
                           [0.0,
                            4.0628146000000006e-10,
                            4.0628146000000006e-10],
                           [4.0628146000000006e-10,
                            0.0,
                            4.0628146000000006e-10],
                           [4.0628146000000006e-10,
                            4.0628146000000006e-10,
                            0.0],
                           [0.0,
                            4.0628146000000006e-10,
                            -4.0628146000000006e-10],
                           [4.0628146000000006e-10,
                            0.0,
                            -4.0628146000000006e-10],
                           [4.0628146000000006e-10,
                            -4.0628146000000006e-10,
                            0.0],
                           [0.0,
                            -4.0628146000000006e-10,
                            -4.0628146000000006e-10],
                           [-4.0628146000000006e-10,
                            0.0,
                            -4.0628146000000006e-10],
                           [-4.0628146000000006e-10,
                            -4.0628146000000006e-10,
                            0.0],
                           [0.0,
                            -4.0628146000000006e-10,
                            4.0628146000000006e-10],
                           [-4.0628146000000006e-10,
                            0.0,
                            4.0628146000000006e-10],
                           [-4.0628146000000006e-10,
                            4.0628146000000006e-10,
                            0.0]],
        'lattice_vectors': [[-5.809e-10, 5.809e-10, 5.809e-10],
                            [5.809e-10, -5.809e-10, 5.809e-10],
                            [5.809e-10, 5.809e-10, -5.809e-10]],
        'normalized_wyckoff': {'a': {'X_0': 1},
                               'e': {'X_1': 6},
                               'f': {'X_0': 8},
                               'h': {'X_0': 12}},
        'normalized_wysytax': {'a': {'X_0': 1},
                               'e': {'X_1': 6},
                               'f': {'X_0': 2},
                               'h': {'X_0': 6}}},
       {'Notes': 'bcc',
        'Pearsons Symbol': 'cI2',
        'Prototype': 'W',
        'Space Group': 'Im3m',
        'Space Group Number': 229,
        'Strukturbericht Designation': 'A2',
        'Wyckoff Positions': 'a',
        'aflow_prototype_id': 'A_cI2_229_a',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A_cI2_229_a.html',
        'atom_labels': ['Nb'],
        'atom_positions': [[0.0, 0.0, 0.0]],
        'lattice_vectors': [[-1.65e-10, 1.65e-10, 1.65e-10],
                            [1.65e-10, -1.65e-10, 1.65e-10],
                            [1.65e-10, 1.65e-10, -1.65e-10]],
        'normalized_wyckoff': {'a': {'X_0': 1}},
        'normalized_wysytax': {'a': {'X_0': 1}}}],
 230: [{'Notes': '-',
        'Pearsons Symbol': 'cI112',
        'Prototype': 'Ga4Ni3',
        'Space Group': 'Ia3d',
        'Space Group Number': 230,
        'Strukturbericht Designation': '-',
        'Wyckoff Positions': 'afg',
        'aflow_prototype_id': 'A4B3_cI112_230_af_g',
        'aflow_prototype_url': 'http://www.aflowlib.org/CrystalDatabase/A4B3_cI112_230_af_g.html',
        'atom_labels': ['Ga',
                        'Ga',
                        'Ga',
                        'Ga',
                        'Ga',
                        'Ga',
                        'Ga',
                        'Ga',
                        'Ga',
                        'Ga',
                        'Ga',
                        'Ga',
                        'Ga',
                        'Ga',
                        'Ga',
                        'Ga',
                        'Ga',
                        'Ga',
                        'Ga',
                        'Ga',
                        'Ga',
                        'Ga',
                        'Ga',
                        'Ga',
                        'Ga',
                        'Ga',
                        'Ga',
                        'Ga',
                        'Ga',
                        'Ga',
                        'Ga',
                        'Ga',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni',
                        'Ni'],
        'atom_positions': [[0.0, 0.0, 0.0],
                           [5.7055e-10, 0.0, 0.0],
                           [0.0, 5.7055e-10, 0.0],
                           [0.0, 0.0, 5.7055e-10],
                           [-2.85275e-10, 2.85275e-10, 2.85275e-10],
                           [2.85275e-10, -2.85275e-10, 2.85275e-10],
                           [2.85275e-10, 2.85275e-10, -2.85275e-10],
                           [2.85275e-10, 2.85275e-10, 2.85275e-10],
                           [1.1411e-13, 0.0, 2.85275e-10],
                           [5.7043589e-10, 0.0, -2.85275e-10],
                           [2.85275e-10, 1.1411e-13, 0.0],
                           [-2.85275e-10, 5.7043589e-10, 0.0],
                           [0.0, 2.85275e-10, 1.1411e-13],
                           [0.0, -2.85275e-10, 5.7043589e-10],
                           [-2.85275e-10, 2.8538911e-10, 0.0],
                           [2.85275e-10, 2.8516089e-10, 0.0],
                           [2.8538911e-10, 0.0, -2.85275e-10],
                           [2.8516089e-10, 0.0, 2.85275e-10],
                           [0.0, 2.85275e-10, 2.8516089e-10],
                           [0.0, -2.85275e-10, 2.8538911e-10],
                           [-1.1411e-13, 0.0, -2.85275e-10],
                           [-5.7043589e-10, 0.0, 2.85275e-10],
                           [-2.85275e-10, -1.1411e-13, 0.0],
                           [2.85275e-10, -5.7043589e-10, 0.0],
                           [0.0, -2.85275e-10, -1.1411e-13],
                           [0.0, 2.85275e-10, -5.7043589e-10],
                           [2.85275e-10, -2.8538911e-10, 0.0],
                           [-2.85275e-10, -2.8516089e-10, 0.0],
                           [-2.8538911e-10, 0.0, 2.85275e-10],
                           [-2.8516089e-10, 0.0, -2.85275e-10],
                           [0.0, -2.85275e-10, -2.8516089e-10],
                           [0.0, 2.85275e-10, -2.8538911e-10],
                           [-4.279125e-10,
                            -1.4252339000000002e-10,
                            4.2779838999999997e-10],
                           [-1.426375e-10,
                            1.4252339000000002e-10,
                            -1.4275161e-10],
                           [-1.426375e-10,
                            -1.4252339000000002e-10,
                            -4.2779838999999997e-10],
                           [-4.279125e-10,
                            1.4252339000000002e-10,
                            1.4275161e-10],
                           [4.2779838999999997e-10,
                            -4.279125e-10,
                            -1.4252339000000002e-10],
                           [-1.4275161e-10,
                            -1.426375e-10,
                            1.4252339000000002e-10],
                           [-4.2779838999999997e-10,
                            -1.426375e-10,
                            -1.4252339000000002e-10],
                           [1.4275161e-10,
                            -4.279125e-10,
                            1.4252339000000002e-10],
                           [-1.4252339000000002e-10,
                            4.2779838999999997e-10,
                            -4.279125e-10],
                           [1.4252339000000002e-10,
                            -1.4275161e-10,
                            -1.426375e-10],
                           [-1.4252339000000002e-10,
                            -4.2779838999999997e-10,
                            -1.426375e-10],
                           [1.4252339000000002e-10,
                            1.4275161e-10,
                            -4.279125e-10],
                           [4.279125e-10,
                            1.4252339000000002e-10,
                            -4.2779838999999997e-10],
                           [1.426375e-10,
                            -1.4252339000000002e-10,
                            1.4275161e-10],
                           [-4.279125e-10,
                            -4.2802661000000007e-10,
                            9.9834839e-10],
                           [4.279125e-10,
                            -1.4252339000000002e-10,
                            -1.4275161e-10],
                           [-4.2779838999999997e-10,
                            4.279125e-10,
                            1.4252339000000002e-10],
                           [1.4275161e-10,
                            1.426375e-10,
                            -1.4252339000000002e-10],
                           [4.2779838999999997e-10,
                            1.426375e-10,
                            1.4252339000000002e-10],
                           [-1.4275161e-10,
                            4.279125e-10,
                            -1.4252339000000002e-10],
                           [1.4252339000000002e-10,
                            -4.2779838999999997e-10,
                            4.279125e-10],
                           [-1.4252339000000002e-10,
                            1.4275161e-10,
                            1.426375e-10],
                           [1.4252339000000002e-10,
                            4.2779838999999997e-10,
                            1.426375e-10],
                           [-1.4252339000000002e-10,
                            -1.4275161e-10,
                            4.279125e-10]],
        'lattice_vectors': [[-5.7055e-10, 5.7055e-10, 5.7055e-10],
                            [5.7055e-10, -5.7055e-10, 5.7055e-10],
                            [5.7055e-10, 5.7055e-10, -5.7055e-10]],
        'normalized_wyckoff': {'a': {'X_0': 1},
                               'f': {'X_0': 3},
                               'g': {'X_1': 3}},
        'normalized_wysytax': {'a': {'X_0': 5},
                               'f': {'X_0': 18},
                               'g': {'X_1': 12}}}]}
