import logging
from argparse import ArgumentParser

from nlp.commands.convert import ConvertCommand
from nlp.commands.download import DownloadCommand
from nlp.commands.env import EnvironmentCommand
from nlp.commands.user import UserCommands
from nlp.commands.test import TestCommand
from nlp.commands.run_beam import RunBeamCommand
from nlp.commands.dummy_data import DummyDataCommand

logging.basicConfig(level=logging.INFO)

if __name__ == '__main__':
    parser = ArgumentParser('HuggingFace NLP CLI tool', usage='nlp-cli <command> [<args>]')
    commands_parser = parser.add_subparsers(help='nlp-cli command helpers')

    # Register commands
    ConvertCommand.register_subcommand(commands_parser)
    DownloadCommand.register_subcommand(commands_parser)
    EnvironmentCommand.register_subcommand(commands_parser)
    UserCommands.register_subcommand(commands_parser)
    TestCommand.register_subcommand(commands_parser)
    RunBeamCommand.register_subcommand(commands_parser)
    DummyDataCommand.register_subcommand(commands_parser)

    # Let's go
    args = parser.parse_args()

    if not hasattr(args, 'func'):
        parser.print_help()
        exit(1)

    # Run
    service = args.func(args)
    service.run()
