define(["@jupyter-widgets/base"], function(__WEBPACK_EXTERNAL_MODULE_2__) { return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;
/******/
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

	module.exports = {};
	
	var loadedModules = [
	    __webpack_require__(1),
	    //require("./ngl.js"),
	]
	
	for (var i in loadedModules) {
	    if (loadedModules.hasOwnProperty(i)) {
	        var loadedModule = loadedModules[i];
	        for (var target_name in loadedModule) {
	            if (loadedModule.hasOwnProperty(target_name)) {
	                module.exports[target_name] = loadedModule[target_name];
	            }
	        }
	    }
	}
	
	module.exports['version'] = __webpack_require__(66).version;


/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {

	var widgets = __webpack_require__(2);
	var NGL = __webpack_require__(3);
	var $ = __webpack_require__(7);
	var _ = __webpack_require__(8);
	__webpack_require__(9);
	__webpack_require__(19);
	__webpack_require__(21);
	__webpack_require__(35);
	
	var Jupyter;
	if (typeof window !== 'undefined') {
	  Jupyter = window['Jupyter'] = window['Jupyter'] || {};
	} else {
	  Jupyter = Jupyter || {};
	}
	
	var NGLModel = widgets.DOMWidgetModel.extend({
	    defaults: function(){
	        return _.extend(widgets.DOMWidgetModel.prototype.defaults(), {
	            _model_name: 'NGLModel',
	            _model_module: 'nglview-js-widgets',
	            _model_module_version: __webpack_require__(66).version,
	            _view_name: "NGLView",
	            _view_module: "nglview-js-widgets",
	            _view_module_version: __webpack_require__(66).version,
	        });
	    }
	})
	
	var NGLView = widgets.DOMWidgetView.extend({
	    render: function() {
	        // init setting of frame
	        this.model.on("change:frame", this.frameChanged, this);
	
	        // init setting of frame
	        this.model.on("change:count", this.countChanged, this);
	
	        // init _parameters handling
	        this.model.on("change:_parameters", this.parametersChanged, this);
	
	        this.model.set('_ngl_version', NGL.Version);
	
	        // for player
	        this.delay = 100;
	        this.sync_frame = false;
	        this.sync_camera = false;
	
	        // get message from Python
	        this.model.on("msg:custom", function(msg) {
	            this.on_msg(msg);
	        }, this);
	
	        if (this.model.comm) {
	            // for embeding in website
	            this.model.comm.on_msg(function(msg) {
	                var buffers = msg.buffers;
	                var content = msg.content.data.content;
	                if (buffers.length && content) {
	                    content.buffers = buffers;
	                }
	                this.model._handle_comm_msg.call(this.model, msg);
	            }.bind(this));
	        }
	
	        // init NGL stage
	        NGL.useWorker = false;
	        this.stage = new NGL.Stage(undefined, {
	            backgroundColor: "white"
	        });
	        this.structureComponent = undefined;
	        this.$container = $(this.stage.viewer.container);
	        this.$el.append(this.$container);
	        this.$container.resizable({
	            resize: function(event, ui) {
	                this.setSize(ui.size.width + "px", ui.size.height + "px");
	            }.bind(this)
	        });
	        this.displayed.then(function() {
	            this.ngl_view_id = this.get_last_child_id();
	            var that = this;
	            var width = this.$el.parent().width() + "px";
	            var height = "300px";
	
	            this.setSize(width, height);
	            this.$container.resizable(
	                "option", "maxWidth", this.$el.parent().width()
	            );
	            if (this.model.get("_ngl_serialize")){
	                that.handle_embed();
	            }else{
	                this.requestUpdateStageParameters();
	                if (this.model.views.length == 1){
	                    this.serialize_camera_orientation();
	                }else{
	                    this.set_camera_orientation(that.model.get("_camera_orientation"));
	                }
	            }
	        }.bind(this));
	
	        this.stage.viewerControls.signals.changed.add(function() {
	            this.serialize_camera_orientation();
	        }.bind(this));
	
	        // init toggle fullscreen
	        $(this.stage.viewer.container).dblclick(function(e) {
	            if (!e.altKey || !e.ctrlKey){
	                this.stage.toggleFullscreen();
	            }
	        }.bind(this));
	
	        // init picking handling
	        this.$pickingInfo = $("<div></div>")
	            .css("position", "absolute")
	            .css("top", "5%")
	            .css("left", "3%")
	            .css("background-color", "white")
	            .css("padding", "2px 5px 2px 5px")
	            .css("opacity", "0.7")
	            .appendTo(this.$container);
	
	        var $inputNotebookCommand = $('<input id="input_notebook_command" type="text" style="border:1px solid skyblue" size="50"></input>');
	        var that = this;
	
	        $inputNotebookCommand.keypress(function(e) {
	            var command = $("#input_notebook_command").val();
	            if (e.which == 13) {
	                $("#input_notebook_command").val("")
	                Jupyter.notebook.kernel.execute(command);
	            }
	        });
	
	        this.$notebook_text = $("<div></div>")
	            .css("position", "absolute")
	            .css("bottom", "5%")
	            .css("left", "3%")
	            .css("padding", "2px 5px 2px 5px")
	            .css("opacity", "0.7")
	            .append($inputNotebookCommand)
	            .appendTo(this.$container);
	        this.$notebook_text.hide();
	
	        this.stage.signals.clicked.add(function(pd) {
	            if (pd) {
	                var pd2 = {};
	                if (pd.atom) pd2.atom = pd.atom.toObject();
	                if (pd.bond) pd2.bond = pd.bond.toObject();
	                if (pd.instance) pd2.instance = pd.instance;
	                this.model.set("picked", pd2);
	                this.touch();
	                var pickingText = "";
	                if (pd.atom) {
	                    pickingText = "Atom: " + pd.atom.qualifiedName();
	                } else if (pd.bond) {
	                    pickingText = "Bond: " + pd.bond.atom1.qualifiedName() + " - " + pd.bond.atom2.qualifiedName();
	                }
	                this.$pickingInfo.text(pickingText);
	            }
	        }, this);
	
	        this.initPlayer();
	
	        var container = this.stage.viewer.container;
	        that = this;
	        container.addEventListener('dragover', function(e) {
	            e.stopPropagation();
	            e.preventDefault();
	            e.dataTransfer.dropEffect = 'copy';
	        }, false);
	
	        container.addEventListener('drop', function(e) {
	            e.stopPropagation();
	            e.preventDefault();
	            var file = e.dataTransfer.files[0];
	
	            that.stage.loadFile(file).then(function(o){
	                that._handle_loading_file_finished();
	                o;
	            });
	            var numDroppedFiles = that.model.get("_n_dragged_files");
	            that.model.set("_n_dragged_files", numDroppedFiles + 1);
	            that.touch();
	        }, false);
	
	        that = this;
	        this.stage.signals.componentAdded.add(function() {
	            var len = this.stage.compList.length;
	            this.model.set("n_components", len);
	            this.touch();
	            var comp = this.stage.compList[len - 1];
	            comp.signals.representationRemoved.add(function() {
	                that.request_repr_dict();
	            });
	            comp.signals.representationAdded.add(function() {
	                that.request_repr_dict();
	            });
	        }, this);
	
	        this.stage.signals.componentRemoved.add(function() {
	            this.model.set("n_components", this.stage.compList.length);
	            this.touch();
	        }, this);
	
	        // for callbacks from Python
	        // must be after initializing NGL.Stage
	        this.send({
	            'type': 'request_loaded',
	            'data': true
	        })
	        var state_params = this.stage.getParameters();
	        this.model.set('_ngl_original_stage_parameters', state_params);
	        this.touch();
	    },
	
	    serialize_camera_orientation: function(){
	         var m = this.stage.viewerControls.getOrientation();
	         this.model.set('_camera_orientation', m.elements);
	         this.touch();
	    },
	
	    set_camera_orientation: function(orientation){
	        if (orientation.length > 0){
	            this.stage.viewerControls.orient(orientation);
	            this.serialize_camera_orientation();
	        }
	    },
	
	    handle_embed: function(){
	        var that = this;
	        var ngl_coordinate_resource = that.model.get("_ngl_coordinate_resource");
	        var ngl_msg_archive = that.model.get("_ngl_msg_archive");
	        var ngl_stage_params = that.model.get('_ngl_full_stage_parameters_embed');
	        var loadfile_list = [];
	
	        _.each(ngl_msg_archive, function(msg){
	            if (msg.methodName == 'loadFile'){
	                if (msg.kwargs && msg.kwargs.defaultRepresentation) {
	                    // no need to add default representation as all representations
	                    // are serialized separately, also it unwantedly sets the orientation
	                    msg.kwargs.defaultRepresentation = false
	                 }
	                loadfile_list.push(that._get_loadFile_promise(msg));
	            }
	        });
	
	
	        Promise.all(loadfile_list).then(function(compList){
	            that._set_representation_from_backend(compList);
	            that.stage.setParameters(ngl_stage_params);
	            that.set_camera_orientation(that.model.get("_camera_orientation"));
	
	            var frame = 0;
	            var count = ngl_coordinate_resource['n_frames'];
	            delete ngl_coordinate_resource['n_frames'];
	
	            var play = function(){
	                that.$playerButton.text("pause");
	                that.playerInterval = setInterval(function(){
	                    frame = frame + 1;
	                    if (frame > count - 1){
	                        frame = 0;
	                    }
	                    that.$playerSlider.slider("option", "value", frame);
	                    that.updateCoordinatesFromDict(ngl_coordinate_resource, frame);
	                }, that.delay)
	            }
	
	            var pause = function() {
	                that.$playerButton.text("play");
	                if (that.playerInterval !== undefined) {
	                    clearInterval(that.playerInterval);
	                }
	            }.bind(that);
	
	            if (that.$playerButton){
	                that.$playerButton
	                    .off('click')
	                    .click(function(event) {
	                        if (that.$playerButton.text() === "play") {
	                            play();
	                        } else if (that.$playerButton.text() === "pause") {
	                            pause();
	                        }
	                        event; // to pass eslint
	                    }.bind(that));
	                that.$playerSlider.slider({
	                    max : count-1,
	                    slide: function(event, ui) {
	                        pause();
	                        that.updateCoordinatesFromDict(ngl_coordinate_resource, ui.value);
	                        frame = ui.value;
	                    }.bind(that)
	                })
	           }
	        });
	    },
	
	    updateCoordinatesFromDict: function(cdict, frame_index){
	        // update coordinates for given "index"
	        // cdict = Dict[int, List[base64]]
	        var keys = Object.keys(cdict);
	
	        for (var i = 0; i < keys.length; i++) {
	            var traj_index = keys[i];
	            var coordinates = this.decode_base64(cdict[traj_index][frame_index]);
	            if (coordinates && coordinates.byteLength > 0) {
	                this.updateCoordinates(coordinates, traj_index);
	            }
	        }
	    },
	
	    setSelector: function(selector_id) {
	        // id is uuid that will be set from Python
	        var selector = "<div class='" + selector_id + "'></div>";
	        this.$ngl_selector = $(selector)
	            .css("position", "absolute")
	            .css("bottom", "5%")
	            .css("left", "3%")
	            .css("padding", "2px 5px 2px 5px")
	            .css("opacity", "0.7")
	            .appendTo(this.$container);
	    },
	
	    setIPythonLikeCell: function() {
	        var cell = Jupyter.notebook.insert_cell_at_bottom();
	
	        var handler = function(event) {
	            var selected_cell = Jupyter.notebook.get_selected_cell();
	            if (selected_cell.cell_id === cell.cell_id) {
	                selected_cell.execute();
	                selected_cell.set_text('');
	            }
	            event; // to pass eslint
	            return false;
	        };
	
	        var action = {
	            help: 'run cell',
	            help_index: 'zz',
	            handler: handler
	        };
	
	        Jupyter.keyboard_manager.edit_shortcuts.add_shortcut('enter', action);
	    },
	
	    hideNotebookCommandBox: function() {
	        this.$notebook_text.hide();
	    },
	
	    showNotebookCommandBox: function() {
	        this.$notebook_text.show();
	    },
	
	    requestFrame: function() {
	        this.send({
	            'type': 'request_frame',
	            'data': 'frame'
	        });
	    },
	
	    requestUpdateStageParameters: function() {
	        var updated_params = this.stage.getParameters();
	        this.model.set('_ngl_full_stage_parameters', updated_params);
	        this.touch();
	    },
	
	    requestReprParameters: function(component_index, repr_index) {
	        var comp = this.stage.compList[component_index];
	        var repr = comp.reprList[repr_index];
	        var msg = repr.repr.getParameters();
	
	        if (msg) {
	            msg['name'] = repr.name;
	            this.send({
	                'type': 'repr_parameters',
	                'data': msg
	            });
	        }
	    },
	
	    request_repr_dict: function() {
	        var n_components = this.stage.compList.length;
	        var msg = {};
	
	        for (var i = 0; i < n_components; i++) {
	            var comp = this.stage.compList[i];
	            msg[i] = {};
	            var msgi = msg[i];
	            for (var j = 0; j < comp.reprList.length; j++) {
	                var repr = comp.reprList[j];
	                msgi[j] = {};
	                msgi[j]['type'] = repr.name;
	                msgi[j]['params'] = repr.repr.getParameters();
	            }
	        }
	        this.send({
	            // make sure we are using "request_repr_dict" name
	            // in backend too.
	            'type': 'request_repr_dict',
	            'data': msg
	        });
	    },
	
	    // setDraggable: function(params) {
	    //     if (params) {
	    //         this.$container.draggable(params);
	    //     } else {
	    //         this.$container.draggable();
	    //     }
	    // },
	    setDelay: function(delay) {
	        this.delay = delay;
	    },
	
	    setSyncFrame: function() {
	        this.sync_frame = true;
	    },
	
	    setUnSyncFrame: function() {
	        this.sync_frame = false;
	    },
	
	    setSyncCamera: function() {
	        this.sync_camera = true;
	        this.serialize_camera_orientation();
	    },
	
	    setUnSyncCamera: function() {
	        this.sync_camera = false;
	    },
	
	    viewXZPlane: function() {
	        var m = new NGL.Matrix4().makeRotationX( Math.PI / 2 );
	        var q = new NGL.Quaternion().setFromRotationMatrix( m );
	        this.stage.viewerControls.rotate( q );
	    },
	
	    set_representation_from_backend: function(){
	        this._set_representation_from_backend(this.stage.compList);
	    },
	
	    _set_representation_from_backend: function(compList){
	        if (compList.length > 0){
	            var ngl_repr_dict = this.model.get('_ngl_repr_dict');
	            for (var index in ngl_repr_dict){
	                var comp = compList[index];
	                comp.removeAllRepresentations();
	                var reprlist = ngl_repr_dict[index];
	                for (var j in reprlist){
	                    var repr = reprlist[j];
	                    if (repr){
	                        comp.addRepresentation(repr.type, repr.params);
	                    }
	                }
	            }
	        }
	    },
	
	    initPlayer: function() {
	        // init player
	        if (this.model.get("count")) {
	            var frame = this.model.get("frame");
	            var play = function() {
	                this.$playerButton.text("pause");
	                this.playerInterval = setInterval(function() {
	                    var frame = this.model.get("frame") + 1;
	                    var count = this.model.get("count");
	                    if (frame >= count) frame = 0;
	
	                    if (this.sync_frame) {
	                        this.model.set("frame", frame);
	                        this.touch();
	                    } else {
	                        this.requestFrame();
	                    }
	                }.bind(this), this.delay);
	            }.bind(this);
	            var pause = function() {
	                this.$playerButton.text("play");
	                if (this.playerInterval !== undefined) {
	                    clearInterval(this.playerInterval);
	                }
	            }.bind(this);
	            this.$playerButton = $("<button>play</button>")
	                .css("float", "left")
	                .css("width", "55px")
	                .css("opacity", "0.7")
	                .click(function(event) {
	                    if (this.$playerButton.text() === "play") {
	                        play();
	                    } else if (this.$playerButton.text() === "pause") {
	                        pause();
	                    }
	                    event; // to pass eslint
	                }.bind(this));
	            this.$playerSlider = $("<div></div>")
	                .css("margin-left", "70px")
	                .css("position", "relative")
	                .css("bottom", "-7px")
	                .slider({
	                    min: 0,
	                    max: this.model.get("count") - 1,
	                    value: frame,
	                    slide: function(event, ui) {
	                        pause();
	                        this.model.set("frame", ui.value);
	                        this.touch();
	                    }.bind(this)
	                });
	            this.$player = $("<div></div>")
	                .css("position", "absolute")
	                .css("bottom", "5%")
	                .css("width", "94%")
	                .css("margin-left", "3%")
	                .css("opacity", "0.7")
	                .append(this.$playerButton)
	                .append(this.$playerSlider)
	                .appendTo(this.$container);
	            this.model.on("change:frame", function() {
	                this.$playerSlider.slider("value", this.model.get("frame"));
	            }, this);
	
	            if (this.model.get("count") < 2) {
	                this.$player.hide()
	            }
	        }
	    },
	
	    countChanged: function() {
	        var count = this.model.get("count");
	        this.$playerSlider.slider({
	            max: count - 1
	        });
	        if (this.model.get("count") > 1) {
	            this.$player.show()
	        }
	    },
	
	    setVisibilityForRepr: function(component_index, repr_index, value) {
	        // value = True/False
	        var component = this.stage.compList[component_index];
	        var repr = component.reprList[repr_index];
	
	        if (repr) {
	            repr.setVisibility(value);
	        }
	    },
	
	    removeRepresentation: function(component_index, repr_index) {
	        var component = this.stage.compList[component_index];
	        var repr = component.reprList[repr_index]
	
	        if (repr) {
	            component.removeRepresentation(repr);
	        }
	    },
	
	    removeRepresentationsByName: function(repr_name, component_index) {
	        var component = this.stage.compList[component_index];
	
	        if (component) {
	            component.reprList.forEach(function(repr) {
	                if (repr.name == repr_name) {
	                    component.removeRepresentation(repr);
	                }
	            })
	        }
	    },
	
	    updateRepresentationForComponent: function(repr_index, component_index, params) {
	        var component = this.stage.compList[component_index];
	        var that = this;
	        var repr = component.reprList[repr_index];
	        if (repr) {
	            repr.setParameters(params);
	            that.request_repr_dict();
	        }
	    },
	
	    updateRepresentationsByName: function(repr_name, component_index, params) {
	        var component = this.stage.compList[component_index];
	        var that = this;
	
	        if (component) {
	            component.reprList.forEach(function(repr) {
	                if (repr.name == repr_name) {
	                    repr.setParameters(params);
	                    that.request_repr_dict();
	                }
	            })
	        }
	    },
	
	    setRepresentation: function(name, params, component_index, repr_index) {
	        var component = this.stage.compList[component_index];
	        var repr = component.reprList[repr_index];
	        var that = this;
	
	        if (repr) {
	            params['useWorker'] = false;
	            var new_repr = NGL.makeRepresentation(name, component.structure,
	                this.stage.viewer, params);
	            if (new_repr) {
	                repr.setRepresentation(new_repr);
	                repr.name = name;
	                component.reprList[repr_index] = repr;
	                that.request_repr_dict();
	            }
	        }
	    },
	
	    setColorByResidue: function(colors, component_index, repr_index){
	        console.log('NGL.ColormakerRegistry', NGL.ColormakerRegistry);
	        var repr = this.stage.compList[component_index].reprList[repr_index];
	        var schemeId = NGL.ColormakerRegistry.addScheme(function(params){
	            this.atomColor = function(atom){
	                 var color = colors[atom.residueIndex];
	                 return color
	            };
	            params; // to pass eslint; ack;
	        });
	        repr.setColor(schemeId);
	    },
	
	    addShape: function(name, shapes) {
	        // shapes: List[Tuple[str, ...]]
	        // e.g: [('sphere', ...), ('cone', ...)]
	        var shape = new NGL.Shape(name);
	        var shape_dict = {
	            'sphere': shape.addSphere,
	            'ellipsoid': shape.addEllipsoid,
	            'cylinder': shape.addCylinder,
	            'cone': shape.addCone,
	            'mesh': shape.addMesh,
	            'arrow': shape.addArrow,
	            'text': shape.addText,
	            'label': shape.addText,
	            'tetrahedron': shape.addTetrahedron,
	            'octahedron': shape.addOctahedron,
	            'torus': shape.addTorus
	        };
	        for (var i = 0; i < shapes.length; i++) {
	            var shapes_i = shapes[i]
	            var shape_type = shapes_i[0];
	            var params = shapes_i.slice(1, shapes_i.length);
	            // e.g params = ('sphere', [ 0, 0, 9 ], [ 1, 0, 0 ], 1.5)
	
	            var func = shape_dict[shape_type];
	            func.apply(shape, params);
	            // shape.func(params);
	        }
	        var shapeComp = this.stage.addComponentFromObject(shape);
	        shapeComp.addRepresentation("buffer");
	    },
	
	    addBuffer: function(name, kwargs){
	        var class_dict = {
	            "arrow": NGL.ArrowBuffer,
	            "box": NGL.BoXbuffer,
	            "cone": NGL.ConeBuffer,
	            "cylinder": NGL.CylinderBuffer,
	            "ellipsoid": NGL.EllipsoidBuffer,
	            "octahedron": NGL.OctahedronBuffer,
	            "sphere": NGL.SphereBuffer,
	            "text": NGL.TextBuffer,
	            "tetrahedron": NGL.TetrahedronBuffer,
	            "torus": NGL.TorusBuffer
	        };
	
	        var params = {};
	        for (var key in kwargs){
	            params[key] = new Float32Array(kwargs[key]);
	        }
	        var shape = new NGL.Shape("shape");
	        var buffer_class = class_dict[name];
	        var buffer = new buffer_class(params);
	        shape.addBuffer(buffer);
	        var shapeComp = this.stage.addComponentFromObject(shape);
	        shapeComp.addRepresentation("buffer");
	    },
	
	    replaceStructure: function(structure){
	         var blob = new Blob([structure.data], {type: "text/plain"});
	         var params = structure.params || {};
	         params.ext = structure.ext;
	         params.defaultRepresentation = false;
	         var comp = this.stage.compList[0];
	         var representations = comp.reprList.slice();
	         var old_orientation = this.stage.viewerControls.getOrientation();
	         var that = this;
	         this.stage.loadFile(blob, params).then(function(component) {
	             that.stage.viewerControls.orient(old_orientation);
	             representations.forEach(function(repr) {
	                 var repr_name = repr.name;
	                 var repr_params = repr.repr.getParameters();
	                 // Note: not using repr.repr.type, repr.repr.params
	                 // since seems to me that repr.repr.params won't return correct "sele"
	                 component.addRepresentation(repr_name, repr_params);
	             });
	             that.stage.removeComponent(comp);
	             that._handle_loading_file_finished();
	         });
	    },
	
	    superpose: function(cindex0, cindex1, align, sele0, sele1) {
	        // superpose two components with given params
	        var component0 = this.stage.compList[cindex0];
	        var component1 = this.stage.compList[cindex1];
	        component1.superpose(component0, align, sele0, sele1);
	    },
	
	    decode_base64: function(base64) {
	        // lightly adapted from Niklas
	
	        /*
	         * base64-arraybuffer
	         * https://github.com/niklasvh/base64-arraybuffer
	         *
	         * Copyright (c) 2012 Niklas von Hertzen
	         * Licensed under the MIT license.
	         */
	        var chars =
	            "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
	        var bufferLength = base64.length * 0.75,
	            len = base64.length,
	            i, p = 0,
	            encoded1, encoded2, encoded3, encoded4;
	
	        if (base64[base64.length - 1] === "=") {
	            bufferLength--;
	            if (base64[base64.length - 2] === "=") {
	                bufferLength--;
	            }
	        }
	
	        var arraybuffer = new ArrayBuffer(bufferLength),
	            bytes = new Uint8Array(arraybuffer);
	
	        for (i = 0; i < len; i += 4) {
	            encoded1 = chars.indexOf(base64[i]);
	            encoded2 = chars.indexOf(base64[i + 1]);
	            encoded3 = chars.indexOf(base64[i + 2]);
	            encoded4 = chars.indexOf(base64[i + 3]);
	
	            bytes[p++] = (encoded1 << 2) | (encoded2 >> 4);
	            bytes[p++] = ((encoded2 & 15) << 4) | (encoded3 >> 2);
	            bytes[p++] = ((encoded3 & 3) << 6) | (encoded4 & 63);
	        }
	
	        return arraybuffer;
	    },
	
	    updateCoordinates: function(coordinates, model) {
	        // coordinates must be ArrayBuffer (use this.decode_base64)
	        var component = this.stage.compList[model];
	        if (coordinates && component) {
	            var coords = new Float32Array(coordinates);
	            component.structure.updatePosition(coords);
	            component.updateRepresentations({
	                "position": true
	            });
	        }
	    },
	
	    handleResize: function() {
	        this.$container.resizable({
	            resize: function(event, ui) {
	                this.setSize(ui.size.width + "px", ui.size.height + "px");
	            }.bind(this)
	        })
	    },
	
	    setSize: function(width, height) {
	        this.stage.viewer.container.style.width = width;
	        this.stage.viewer.container.style.height = height;
	        this.stage.handleResize();
	    },
	
	    openNotebookCommandDialog: function() {
	        var that = this;
	        var dialog = this.$notebook_text.dialog({
	            draggable: true,
	            resizable: true,
	            modal: false,
	            show: {
	                effect: "blind",
	                duration: 150
	            },
	            close: function(event, ui) {
	                that.$container.append(that.$notebook_text);
	                that.$notebook_text.dialog('destroy');
	                event; ui; // to pass eslint; ack;
	            },
	        });
	        dialog.css({
	            overflow: 'hidden'
	        });
	        dialog.prev('.ui-dialog-titlebar')
	            .css({
	                'background': 'transparent',
	                'border': 'none'
	            });
	        Jupyter.keyboard_manager.register_events(dialog);
	    },
	
	    setDialog: function() {
	        var $nb_container = Jupyter.notebook.container;
	        var that = this;
	        var dialog = this.$container.dialog({
	            title: "NGLView",
	            draggable: true,
	            resizable: true,
	            modal: false,
	            width: window.innerWidth - $nb_container.width() - $nb_container.offset().left - 50,
	            height: 'auto',
	            position: {
	                my: 'right',
	                at: 'right',
	                of: window
	            },
	            show: {
	                effect: "blind",
	                duration: 150
	            },
	            close: function(event, ui) {
	                that.$el.append(that.$container);
	                that.$container.dialog('destroy');
	                that.handleResize();
	                event; ui; // to pass eslint; ack;
	            },
	            resize: function(event, ui) {
	                that.stage.handleResize();
	                that.setSize(ui.size.width + "px", ui.size.height + "px");
	            }.bind(that),
	        });
	        dialog.css({
	            overflow: 'hidden'
	        });
	        dialog.prev('.ui-dialog-titlebar')
	            .css({
	                'background': 'transparent',
	                'border': 'none'
	            });
	    },
	
	    resizeNotebook: function(width) {
	        var $nb_container = Jupyter.notebook.container;
	        $nb_container.width(width);
	
	        if (this.$container.dialog) {
	            this.$container.dialog({
	                width: $nb_container.offset().left
	            });
	        }
	    },
	
	    parametersChanged: function() {
	        var _parameters = this.model.get("_parameters");
	        this.setParameters(_parameters);
	    },
	
	    setParameters: function(parameters) {
	        this.stage.setParameters(parameters);
	
	        // do not set _ngl_full_stage_parameters here
	        // or parameters will be never updated (not sure why)
	        // use observe in python side
	        var updated_params = this.stage.getParameters();
	        this.send({
	            'type': 'stage_parameters',
	            'data': updated_params
	        })
	    },
	
	    _downloadImage: function(filename, params) {
	        if (this.ngl_view_id == this.get_last_child_id()){
	            this.stage.makeImage(params).then(function(blob) {
	                NGL.download(blob, filename);
	            })
	        }
	    },
	
	    _exportImage: function(params) {
	        if (this.ngl_view_id == this.get_last_child_id()){
	            this.stage.makeImage(params).then(function(blob) {
	                var reader = new FileReader();
	                var arr_str;
	                reader.onload = function() {
	                    arr_str = reader.result.replace("data:image/png;base64,", "");
	                    this.model.set("_image_data", arr_str);
	                    this.touch();
	                }.bind(this);
	                reader.readAsDataURL(blob);
	            }.bind(this));
	        }
	    },
	
	    cleanOutput: function() {
	
	        var cells = Jupyter.notebook.get_cells();
	
	        for (var i = 0; i < cells.length; i++) {
	            var cell = cells[i];
	            if (cell.output_area.outputs.length > 0) {
	                var out = cell.output_area.outputs[0];
	                if (out.output_type == 'display_data') {
	                    cell.clear_output();
	                }
	            }
	        }
	    },
	
	    _handle_loading_file_finished: function() {
	        this.send({'type': 'async_message', 'data': 'ok'});
	    },
	
	    _get_loadFile_promise: function(msg){
	         // args = [{'type': ..., 'data': ...}]
	         var args0 = msg.args[0];
	         if (args0.type == 'blob') {
	             var blob;
	             if (args0.binary) {
	                 var decoded_data = this.decode_base64(args0.data);
	                 blob = new Blob([decoded_data], {
	                     type: "application/octet-binary"
	                 });
	             } else {
	                 blob = new Blob([args0.data], {
	                     type: "text/plain"
	                 });
	             }
	             return this.stage.loadFile(blob, msg.kwargs)
	         } else {
	             return this.stage.loadFile(msg.args[0].data, msg.kwargs)
	         }
	    },
	
	    get_last_child_id: function(){
	        var keys = Object.keys(this.model.views);
	        return keys[keys.length-1]
	    },
	
	    _handle_stage_loadFile: function(msg){
	        // args = [{'type': ..., 'data': ...}]
	        if (this.ngl_view_id != this.get_last_child_id() && msg.last_child){
	            return
	        }
	        var that = this;
	        this._get_loadFile_promise(msg).then(function(o){
	            that._handle_loading_file_finished();
	            o;
	        });
	    },
	
	    on_msg: function(msg) {
	        // TODO: re-organize
	        if (msg.type == 'call_method') {
	            var index, component, func, stage;
	            var new_args = msg.args.slice();
	            new_args.push(msg.kwargs);
	
	            switch (msg.target) {
	                case 'Stage':
	                    var stage_func = this.stage[msg.methodName];
	                    stage = this.stage;
	                    if (msg.methodName == 'screenshot') {
	                        NGL.screenshot(this.stage.viewer, msg.kwargs);
	                    } else if (msg.methodName == 'removeComponent') {
	                        index = msg.args[0];
	                        component = this.stage.compList[index];
	                        this.stage.removeComponent(component);
	                    } else if (msg.methodName == 'loadFile') {
	                        if (this.model.views.length > 1 && msg.kwargs &&
	                            msg.kwargs.defaultRepresentation) {
	                            // no need to add default representation as all representations
	                            // are serialized separately, also it unwantedly sets the orientation
	                            msg.kwargs.defaultRepresentation = false
	                        }
	                        this._handle_stage_loadFile(msg);
	                    } else {
	                            stage_func.apply(stage, new_args);
	                    }
	                    break;
	                case 'Viewer':
	                    var viewer = this.stage.viewer;
	                    func = this.stage.viewer[msg.methodName];
	                    func.apply(viewer, new_args);
	                    break;
	                case 'viewerControls':
	                    var controls = this.stage.viewerControls;
	                    func = controls[msg.methodName];
	                    func.apply(controls, new_args);
	                    break;
	                case 'compList':
	                    index = msg['component_index'];
	                    component = this.stage.compList[index];
	                    func = component[msg.methodName];
	                    func.apply(component, new_args);
	                    break;
	                case 'StructureComponent':
	                    component = this.structureComponent;
	                    func = component[msg.methodName];
	                    func.apply(component, new_args);
	                    break;
	                case 'Widget':
	                    func = this[msg.methodName];
	                    if (func) {
	                        func.apply(this, new_args);
	                    } else {
	                        // send error message to Python?
	                        console.log('can not create func for ' + msg.methodName);
	                    }
	                    break;
	                case 'player':
	                    func = this.$player[msg.methodName];
	                    if (func) {
	                        func.apply(this.$player, new_args);
	                    } else {
	                        // send error message to Python?
	                        console.log('can not create func for ' + msg.methodName);
	                    }
	                    break;
	                case 'Representation':
	                    var component_index = msg['component_index'];
	                    var repr_index = msg['repr_index'];
	                    component = this.stage.compList[component_index];
	                    var repr = component.reprList[repr_index];
	                    func = repr[msg.methodName];
	                    if (repr && func) {
	                        func.apply(repr, new_args);
	                    }
	                    break;
	                default:
	                    console.log('there is no method for ' + msg.target);
	                    break;
	            }
	        } else if (msg.type == 'base64_single') {
	            var coordinatesDict = msg.data;
	            var keys = Object.keys(coordinatesDict);
	
	            for (var i = 0; i < keys.length; i++) {
	                var traj_index = keys[i];
	                var coordinates = this.decode_base64(coordinatesDict[traj_index]);
	                if (coordinates && coordinates.byteLength > 0) {
	                    this.updateCoordinates(coordinates, traj_index);
	                }
	            }
	        } else if (msg.type == 'binary_single') {
	            var coordinateMeta = msg.data;
	            keys = Object.keys(coordinateMeta);
	
	            for (i = 0; i < keys.length; i++) {
	                traj_index = keys[i];
	                coordinates = new Float32Array(msg.buffers[i].buffer);
	                if (coordinates.byteLength > 0) {
	                    this.updateCoordinates(coordinates, traj_index);
	                }
	            }
	        } else if (msg.type == 'get') {
	            if (msg.data == 'camera') {
	                this.send(JSON.stringify(this.stage.viewer.camera));
	            } else if (msg.data == 'parameters') {
	                this.send(JSON.stringify(this.stage.parameters));
	            } else {
	                console.log("Number of components", this.stage.compList.length);
	                console.log("ngl_view_id", this.ngl_view_id);
	            }
	        }
	    },
	});
	
	module.exports = {
	    'NGLView': NGLView,
	    'NGLModel': NGLModel,
	    'NGL': NGL,
	};


/***/ }),
/* 2 */
/***/ (function(module, exports) {

	module.exports = __WEBPACK_EXTERNAL_MODULE_2__;

/***/ }),
/* 3 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(setImmediate, global) {!function(t,e){ true?e(exports):"function"==typeof define&&define.amd?define(["exports"],e):e(t.NGL={})}(this,function(t){"use strict";var e,i,r,n,o,a,s,c;"undefined"!=typeof window&&function(){window.console=window.console||{};for(var t,e,i=window.console,r={},n=function(){},o="memory".split(","),a="assert,clear,count,debug,dir,dirxml,error,exception,group,groupCollapsed,groupEnd,info,log,markTimeline,profile,profiles,profileEnd,show,table,time,timeEnd,timeline,timelineEnd,timeStamp,trace,warn".split(",");t=o.pop();)i[t]||(i[t]=r);for(;e=a.pop();)i[e]||(i[e]=n)}(),void 0===window.HTMLCanvasElement||window.HTMLCanvasElement.prototype.toBlob||Object.defineProperty(window.HTMLCanvasElement.prototype,"toBlob",{value:function(t,e,i){for(var r=window.atob(this.toDataURL(e,i).split(",")[1]),n=r.length,o=n>>2,a=new Uint8Array(n),s=new Uint32Array(a.buffer,0,o),c=0,u=0;c<o;c++)s[c]=r.charCodeAt(u++)|r.charCodeAt(u++)<<8|r.charCodeAt(u++)<<16|r.charCodeAt(u++)<<24;for(var h=3&n;h--;)a[u]=r.charCodeAt(u++);t(new window.Blob([a],{type:e||"image/png"}))}}),Math.cbrt=Math.cbrt||function(t){var e=Math.pow(Math.abs(t),1/3);return t<0?-e:e},Math.sign||(Math.sign=function(t){return 0===(t=+t)||isNaN(t)?Number(t):t>0?1:-1}),Number.isInteger||(Number.isInteger=function(t){return"number"==typeof t&&isFinite(t)&&t>-9007199254740992&&t<9007199254740992&&Math.floor(t)===t}),Number.isNaN||(Number.isNaN=function(t){return t!=t}),Object.assign||Object.defineProperty(Object,"assign",{enumerable:!1,configurable:!0,writable:!0,value:function(t){var e=arguments;if(void 0===t||null===t)throw new TypeError("Cannot convert first argument to object");for(var i,r=Object(t),n=!1,o=1;o<arguments.length;o++){var a=e[o];if(void 0!==a&&null!==a){for(var s=Object.keys(Object(a)),c=0,u=s.length;c<u;c++){var h=s[c];try{var l=Object.getOwnPropertyDescriptor(a,h);void 0!==l&&l.enumerable&&(r[h]=a[h])}catch(t){n||(n=!0,i=t)}}if(n)throw i}}return r}}),String.prototype.startsWith||(e=function(){var t;try{var e={},i=Object.defineProperty;t=i(e,e,e)&&i}catch(t){}return t}(),i={}.toString,r=function(t){if(null===this)throw TypeError();var e=String(this);if(t&&"[object RegExp]"===i.call(t))throw TypeError();var r=e.length,n=String(t),o=n.length,a=arguments.length>1?arguments[1]:void 0,s=a?Number(a):0;Number.isNaN(s)&&(s=0);var c=Math.min(Math.max(s,0),r);if(o+c>r)return!1;for(var u=-1;++u<o;)if(e.charCodeAt(c+u)!==n.charCodeAt(u))return!1;return!0},e?e(String.prototype,"startsWith",{value:r,configurable:!0,writable:!0}):String.prototype.startsWith=r),String.prototype.endsWith||(String.prototype.endsWith=function(t,e){var i=this.toString();("number"!=typeof e||!isFinite(e)||Math.floor(e)!==e||e>i.length)&&(e=i.length),e-=t.length;var r=i.indexOf(t,e);return-1!==r&&r===e}),String.prototype.repeat||(String.prototype.repeat=function(t){if(null===this)throw new TypeError("can't convert "+this+" to object");var e=""+this;if(t=+t,Number.isNaN(t)&&(t=0),t<0)throw new RangeError("repeat count must be non-negative");if(t===1/0)throw new RangeError("repeat count must be less than infinity");if(t=Math.floor(t),0===e.length||0===t)return"";if(e.length*t>=1<<28)throw new RangeError("repeat count must not overflow maximum string size");for(var i="";1==(1&t)&&(i+=e),0!==(t>>>=1);)e+=e;return i}),String.prototype.includes||(String.prototype.includes=function(t,e){return"number"!=typeof e&&(e=0),!(e+t.length>this.length)&&-1!==this.indexOf(t,e)}),Array.prototype.includes||(Array.prototype.includes=function(t){if(null==this)throw new TypeError("Array.prototype.includes called on null or undefined");var e=Object(this),i=parseInt(e.length,10)||0;if(0===i)return!1;var r,n,o=parseInt(arguments[1],10)||0;for(o>=0?r=o:(r=i+o)<0&&(r=0);r<i;){if(t===(n=e[r])||Number.isNaN(t)&&Number.isNaN(n))return!0;r++}return!1}),Array.from||(Array.from=(n=Object.prototype.toString,o=function(t){return"function"==typeof t||"[object Function]"===n.call(t)},a=Math.pow(2,53)-1,s=function(t){var e,i=(e=Number(t),isNaN(e)?0:0!==e&&isFinite(e)?(e>0?1:-1)*Math.floor(Math.abs(e)):e);return Math.min(Math.max(i,0),a)},function(t){var e=Object(t);if(null==t)throw new TypeError("Array.from requires an array-like object - not null or undefined");var i,r=arguments.length>1?arguments[1]:void 0;if(void 0!==r){if(!o(r))throw new TypeError("Array.from: when provided, the second argument must be a function");arguments.length>2&&(i=arguments[2])}for(var n,a=s(e.length),c=o(this)?Object(new this(a)):new Array(a),u=0;u<a;)n=e[u],c[u]=r?void 0===i?r(n,u):r.call(i,n,u):n,u+=1;return c.length=a,c})),"undefined"!=typeof window&&function(){for(var t=0,e=["ms","moz","webkit","o"],i=0;i<e.length&&!window.requestAnimationFrame;++i)window.requestAnimationFrame=window[e[i]+"RequestAnimationFrame"],window.cancelAnimationFrame=window[e[i]+"CancelAnimationFrame"]||window[e[i]+"CancelRequestAnimationFrame"];window.requestAnimationFrame||(window.requestAnimationFrame=function(e){var i=(new Date).getTime(),r=Math.max(0,16-(i-t)),n=window.setTimeout(function(){e(i+r)},r);return t=i+r,n}),window.cancelAnimationFrame||(window.cancelAnimationFrame=function(t){clearTimeout(t)})}(),void 0===Function.prototype.name&&void 0!==Object.defineProperty&&Object.defineProperty(Function.prototype,"name",{get:function(){return this.toString().match(/^\s*function\s*(\S*)\s*\(/)[1]}}),"undefined"!=typeof window&&(void 0===window.performance&&(self.performance={}),void 0===window.performance.now&&(c=Date.now(),window.performance.now=function(){return Date.now()-c}));var u=setTimeout;function h(){}function l(t){if(!(this instanceof l))throw new TypeError("Promises must be constructed via new");if("function"!=typeof t)throw new TypeError("not a function");this._state=0,this._handled=!1,this._value=void 0,this._deferreds=[],g(t,this)}function p(t,e){for(;3===t._state;)t=t._value;0!==t._state?(t._handled=!0,l._immediateFn(function(){var i=1===t._state?e.onFulfilled:e.onRejected;if(null!==i){var r;try{r=i(t._value)}catch(t){return void f(e.promise,t)}d(e.promise,r)}else(1===t._state?d:f)(e.promise,t._value)})):t._deferreds.push(e)}function d(t,e){try{if(e===t)throw new TypeError("A promise cannot be resolved with itself.");if(e&&("object"==typeof e||"function"==typeof e)){var i=e.then;if(e instanceof l)return t._state=3,t._value=e,void m(t);if("function"==typeof i)return void g((r=i,n=e,function(){r.apply(n,arguments)}),t)}t._state=1,t._value=e,m(t)}catch(e){f(t,e)}var r,n}function f(t,e){t._state=2,t._value=e,m(t)}function m(t){2===t._state&&0===t._deferreds.length&&l._immediateFn(function(){t._handled||l._unhandledRejectionFn(t._value)});for(var e=0,i=t._deferreds.length;e<i;e++)p(t,t._deferreds[e]);t._deferreds=null}function g(t,e){var i=!1;try{t(function(t){i||(i=!0,d(e,t))},function(t){i||(i=!0,f(e,t))})}catch(t){if(i)return;i=!0,f(e,t)}}function v(){}l.prototype.catch=function(t){return this.then(null,t)},l.prototype.then=function(t,e){var i=new this.constructor(h);return p(this,new function(t,e,i){this.onFulfilled="function"==typeof t?t:null,this.onRejected="function"==typeof e?e:null,this.promise=i}(t,e,i)),i},l.all=function(t){return new l(function(e,i){if(!t||void 0===t.length)throw new TypeError("Promise.all accepts an array");var r=Array.prototype.slice.call(t);if(0===r.length)return e([]);var n=r.length;function o(t,a){try{if(a&&("object"==typeof a||"function"==typeof a)){var s=a.then;if("function"==typeof s)return void s.call(a,function(e){o(t,e)},i)}r[t]=a,0==--n&&e(r)}catch(t){i(t)}}for(var a=0;a<r.length;a++)o(a,r[a])})},l.resolve=function(t){return t&&"object"==typeof t&&t.constructor===l?t:new l(function(e){e(t)})},l.reject=function(t){return new l(function(e,i){i(t)})},l.race=function(t){return new l(function(e,i){for(var r=0,n=t.length;r<n;r++)t[r].then(e,i)})},l._immediateFn="function"==typeof setImmediate&&function(t){setImmediate(t)}||function(t){u(t,0)},l._unhandledRejectionFn=function(t){"undefined"!=typeof console&&console&&console.warn("Possible Unhandled Promise Rejection:",t)},void 0===Number.EPSILON&&(Number.EPSILON=Math.pow(2,-52)),void 0===Number.isInteger&&(Number.isInteger=function(t){return"number"==typeof t&&isFinite(t)&&Math.floor(t)===t}),void 0===Math.sign&&(Math.sign=function(t){return t<0?-1:t>0?1:+t}),"name"in Function.prototype==!1&&Object.defineProperty(Function.prototype,"name",{get:function(){return this.toString().match(/^\s*function\s*([^\(\s]*)/)[1]}}),void 0===Object.assign&&(Object.assign=function(t){var e=arguments;if(void 0===t||null===t)throw new TypeError("Cannot convert undefined or null to object");for(var i=Object(t),r=1;r<arguments.length;r++){var n=e[r];if(void 0!==n&&null!==n)for(var o in n)Object.prototype.hasOwnProperty.call(n,o)&&(i[o]=n[o])}return i}),Object.assign(v.prototype,{addEventListener:function(t,e){void 0===this._listeners&&(this._listeners={});var i=this._listeners;void 0===i[t]&&(i[t]=[]),-1===i[t].indexOf(e)&&i[t].push(e)},hasEventListener:function(t,e){if(void 0===this._listeners)return!1;var i=this._listeners;return void 0!==i[t]&&-1!==i[t].indexOf(e)},removeEventListener:function(t,e){if(void 0!==this._listeners){var i=this._listeners[t];if(void 0!==i){var r=i.indexOf(e);-1!==r&&i.splice(r,1)}}},dispatchEvent:function(t){if(void 0!==this._listeners){var e=this._listeners[t.type];if(void 0!==e){t.target=this;for(var i=e.slice(0),r=0,n=i.length;r<n;r++)i[r].call(this,t)}}}});var y,b,x,_,w,S,A,M,P,T,E,C,I,R,L,O,D,k,N,B,F="89",z=0,U=1,j=2,G=0,V=1,H=2,$=0,W=1,X=2,q=0,Y=1,Z=2,K=0,J=1,Q=2,tt=3,et=4,it=5,rt=100,nt=101,ot=102,at=103,st=104,ct=200,ut=201,ht=202,lt=203,pt=204,dt=205,ft=206,mt=207,gt=208,vt=209,yt=210,bt=0,xt=1,_t=2,wt=3,St=4,At=5,Mt=6,Pt=7,Tt=0,Et=1,Ct=2,It=0,Rt=1,Lt=2,Ot=3,Dt=4,kt=301,Nt=302,Bt=303,Ft=304,zt=305,Ut=306,jt=307,Gt=1e3,Vt=1001,Ht=1002,$t=1003,Wt=1004,Xt=1005,qt=1006,Yt=1007,Zt=1008,Kt=1009,Jt=1010,Qt=1011,te=1012,ee=1013,ie=1014,re=1015,ne=1016,oe=1017,ae=1018,se=1019,ce=1020,ue=1021,he=1022,le=1023,pe=1024,de=1025,fe=1026,ge=1027,ve=2001,ye=2002,be=2003,xe=2004,_e=2100,we=2101,Se=2102,Ae=2103,Me=2151,Pe=2201,Te=2400,Ee=2401,Ce=0,Ie=1,Re=2,Le=3e3,Oe=3001,De=3007,ke=3002,Ne=3004,Be=3005,Fe=3006,ze=3200,Ue=3201,je={DEG2RAD:Math.PI/180,RAD2DEG:180/Math.PI,generateUUID:function(){for(var t=[],e=0;e<256;e++)t[e]=(e<16?"0":"")+e.toString(16).toUpperCase();return function(){var e=4294967295*Math.random()|0,i=4294967295*Math.random()|0,r=4294967295*Math.random()|0,n=4294967295*Math.random()|0;return t[255&e]+t[e>>8&255]+t[e>>16&255]+t[e>>24&255]+"-"+t[255&i]+t[i>>8&255]+"-"+t[i>>16&15|64]+t[i>>24&255]+"-"+t[63&r|128]+t[r>>8&255]+"-"+t[r>>16&255]+t[r>>24&255]+t[255&n]+t[n>>8&255]+t[n>>16&255]+t[n>>24&255]}}(),clamp:function(t,e,i){return Math.max(e,Math.min(i,t))},euclideanModulo:function(t,e){return(t%e+e)%e},mapLinear:function(t,e,i,r,n){return r+(t-e)*(n-r)/(i-e)},lerp:function(t,e,i){return(1-i)*t+i*e},smoothstep:function(t,e,i){return t<=e?0:t>=i?1:(t=(t-e)/(i-e))*t*(3-2*t)},smootherstep:function(t,e,i){return t<=e?0:t>=i?1:(t=(t-e)/(i-e))*t*t*(t*(6*t-15)+10)},randInt:function(t,e){return t+Math.floor(Math.random()*(e-t+1))},randFloat:function(t,e){return t+Math.random()*(e-t)},randFloatSpread:function(t){return t*(.5-Math.random())},degToRad:function(t){return t*je.DEG2RAD},radToDeg:function(t){return t*je.RAD2DEG},isPowerOfTwo:function(t){return 0==(t&t-1)&&0!==t},ceilPowerOfTwo:function(t){return Math.pow(2,Math.ceil(Math.log(t)/Math.LN2))},floorPowerOfTwo:function(t){return Math.pow(2,Math.floor(Math.log(t)/Math.LN2))}};function Ge(t,e){this.x=t||0,this.y=e||0}function Ve(){this.elements=[1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1],arguments.length>0&&console.error("THREE.Matrix4: the constructor no longer reads arguments. use .set() instead.")}function He(t,e,i,r){this._x=t||0,this._y=e||0,this._z=i||0,this._w=void 0!==r?r:1}function $e(t,e,i){this.x=t||0,this.y=e||0,this.z=i||0}function We(){this.elements=[1,0,0,0,1,0,0,0,1],arguments.length>0&&console.error("THREE.Matrix3: the constructor no longer reads arguments. use .set() instead.")}Object.defineProperties(Ge.prototype,{width:{get:function(){return this.x},set:function(t){this.x=t}},height:{get:function(){return this.y},set:function(t){this.y=t}}}),Object.assign(Ge.prototype,{isVector2:!0,set:function(t,e){return this.x=t,this.y=e,this},setScalar:function(t){return this.x=t,this.y=t,this},setX:function(t){return this.x=t,this},setY:function(t){return this.y=t,this},setComponent:function(t,e){switch(t){case 0:this.x=e;break;case 1:this.y=e;break;default:throw new Error("index is out of range: "+t)}return this},getComponent:function(t){switch(t){case 0:return this.x;case 1:return this.y;default:throw new Error("index is out of range: "+t)}},clone:function(){return new this.constructor(this.x,this.y)},copy:function(t){return this.x=t.x,this.y=t.y,this},add:function(t,e){return void 0!==e?(console.warn("THREE.Vector2: .add() now only accepts one argument. Use .addVectors( a, b ) instead."),this.addVectors(t,e)):(this.x+=t.x,this.y+=t.y,this)},addScalar:function(t){return this.x+=t,this.y+=t,this},addVectors:function(t,e){return this.x=t.x+e.x,this.y=t.y+e.y,this},addScaledVector:function(t,e){return this.x+=t.x*e,this.y+=t.y*e,this},sub:function(t,e){return void 0!==e?(console.warn("THREE.Vector2: .sub() now only accepts one argument. Use .subVectors( a, b ) instead."),this.subVectors(t,e)):(this.x-=t.x,this.y-=t.y,this)},subScalar:function(t){return this.x-=t,this.y-=t,this},subVectors:function(t,e){return this.x=t.x-e.x,this.y=t.y-e.y,this},multiply:function(t){return this.x*=t.x,this.y*=t.y,this},multiplyScalar:function(t){return this.x*=t,this.y*=t,this},divide:function(t){return this.x/=t.x,this.y/=t.y,this},divideScalar:function(t){return this.multiplyScalar(1/t)},applyMatrix3:function(t){var e=this.x,i=this.y,r=t.elements;return this.x=r[0]*e+r[3]*i+r[6],this.y=r[1]*e+r[4]*i+r[7],this},min:function(t){return this.x=Math.min(this.x,t.x),this.y=Math.min(this.y,t.y),this},max:function(t){return this.x=Math.max(this.x,t.x),this.y=Math.max(this.y,t.y),this},clamp:function(t,e){return this.x=Math.max(t.x,Math.min(e.x,this.x)),this.y=Math.max(t.y,Math.min(e.y,this.y)),this},clampScalar:(y=new Ge,b=new Ge,function(t,e){return y.set(t,t),b.set(e,e),this.clamp(y,b)}),clampLength:function(t,e){var i=this.length();return this.divideScalar(i||1).multiplyScalar(Math.max(t,Math.min(e,i)))},floor:function(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this},ceil:function(){return this.x=Math.ceil(this.x),this.y=Math.ceil(this.y),this},round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this},roundToZero:function(){return this.x=this.x<0?Math.ceil(this.x):Math.floor(this.x),this.y=this.y<0?Math.ceil(this.y):Math.floor(this.y),this},negate:function(){return this.x=-this.x,this.y=-this.y,this},dot:function(t){return this.x*t.x+this.y*t.y},lengthSq:function(){return this.x*this.x+this.y*this.y},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},manhattanLength:function(){return Math.abs(this.x)+Math.abs(this.y)},normalize:function(){return this.divideScalar(this.length()||1)},angle:function(){var t=Math.atan2(this.y,this.x);return t<0&&(t+=2*Math.PI),t},distanceTo:function(t){return Math.sqrt(this.distanceToSquared(t))},distanceToSquared:function(t){var e=this.x-t.x,i=this.y-t.y;return e*e+i*i},manhattanDistanceTo:function(t){return Math.abs(this.x-t.x)+Math.abs(this.y-t.y)},setLength:function(t){return this.normalize().multiplyScalar(t)},lerp:function(t,e){return this.x+=(t.x-this.x)*e,this.y+=(t.y-this.y)*e,this},lerpVectors:function(t,e,i){return this.subVectors(e,t).multiplyScalar(i).add(t)},equals:function(t){return t.x===this.x&&t.y===this.y},fromArray:function(t,e){return void 0===e&&(e=0),this.x=t[e],this.y=t[e+1],this},toArray:function(t,e){return void 0===t&&(t=[]),void 0===e&&(e=0),t[e]=this.x,t[e+1]=this.y,t},fromBufferAttribute:function(t,e,i){return void 0!==i&&console.warn("THREE.Vector2: offset has been removed from .fromBufferAttribute()."),this.x=t.getX(e),this.y=t.getY(e),this},rotateAround:function(t,e){var i=Math.cos(e),r=Math.sin(e),n=this.x-t.x,o=this.y-t.y;return this.x=n*i-o*r+t.x,this.y=n*r+o*i+t.y,this}}),Object.assign(Ve.prototype,{isMatrix4:!0,set:function(t,e,i,r,n,o,a,s,c,u,h,l,p,d,f,m){var g=this.elements;return g[0]=t,g[4]=e,g[8]=i,g[12]=r,g[1]=n,g[5]=o,g[9]=a,g[13]=s,g[2]=c,g[6]=u,g[10]=h,g[14]=l,g[3]=p,g[7]=d,g[11]=f,g[15]=m,this},identity:function(){return this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1),this},clone:function(){return(new Ve).fromArray(this.elements)},copy:function(t){var e=this.elements,i=t.elements;return e[0]=i[0],e[1]=i[1],e[2]=i[2],e[3]=i[3],e[4]=i[4],e[5]=i[5],e[6]=i[6],e[7]=i[7],e[8]=i[8],e[9]=i[9],e[10]=i[10],e[11]=i[11],e[12]=i[12],e[13]=i[13],e[14]=i[14],e[15]=i[15],this},copyPosition:function(t){var e=this.elements,i=t.elements;return e[12]=i[12],e[13]=i[13],e[14]=i[14],this},extractBasis:function(t,e,i){return t.setFromMatrixColumn(this,0),e.setFromMatrixColumn(this,1),i.setFromMatrixColumn(this,2),this},makeBasis:function(t,e,i){return this.set(t.x,e.x,i.x,0,t.y,e.y,i.y,0,t.z,e.z,i.z,0,0,0,0,1),this},extractRotation:(P=new $e,function(t){var e=this.elements,i=t.elements,r=1/P.setFromMatrixColumn(t,0).length(),n=1/P.setFromMatrixColumn(t,1).length(),o=1/P.setFromMatrixColumn(t,2).length();return e[0]=i[0]*r,e[1]=i[1]*r,e[2]=i[2]*r,e[4]=i[4]*n,e[5]=i[5]*n,e[6]=i[6]*n,e[8]=i[8]*o,e[9]=i[9]*o,e[10]=i[10]*o,this}),makeRotationFromEuler:function(t){t&&t.isEuler||console.error("THREE.Matrix4: .makeRotationFromEuler() now expects a Euler rotation rather than a Vector3 and order.");var e=this.elements,i=t.x,r=t.y,n=t.z,o=Math.cos(i),a=Math.sin(i),s=Math.cos(r),c=Math.sin(r),u=Math.cos(n),h=Math.sin(n);if("XYZ"===t.order){var l=o*u,p=o*h,d=a*u,f=a*h;e[0]=s*u,e[4]=-s*h,e[8]=c,e[1]=p+d*c,e[5]=l-f*c,e[9]=-a*s,e[2]=f-l*c,e[6]=d+p*c,e[10]=o*s}else if("YXZ"===t.order){var m=s*u,g=s*h,v=c*u,y=c*h;e[0]=m+y*a,e[4]=v*a-g,e[8]=o*c,e[1]=o*h,e[5]=o*u,e[9]=-a,e[2]=g*a-v,e[6]=y+m*a,e[10]=o*s}else if("ZXY"===t.order){m=s*u,g=s*h,v=c*u,y=c*h;e[0]=m-y*a,e[4]=-o*h,e[8]=v+g*a,e[1]=g+v*a,e[5]=o*u,e[9]=y-m*a,e[2]=-o*c,e[6]=a,e[10]=o*s}else if("ZYX"===t.order){l=o*u,p=o*h,d=a*u,f=a*h;e[0]=s*u,e[4]=d*c-p,e[8]=l*c+f,e[1]=s*h,e[5]=f*c+l,e[9]=p*c-d,e[2]=-c,e[6]=a*s,e[10]=o*s}else if("YZX"===t.order){var b=o*s,x=o*c,_=a*s,w=a*c;e[0]=s*u,e[4]=w-b*h,e[8]=_*h+x,e[1]=h,e[5]=o*u,e[9]=-a*u,e[2]=-c*u,e[6]=x*h+_,e[10]=b-w*h}else if("XZY"===t.order){b=o*s,x=o*c,_=a*s,w=a*c;e[0]=s*u,e[4]=-h,e[8]=c*u,e[1]=b*h+w,e[5]=o*u,e[9]=x*h-_,e[2]=_*h-x,e[6]=a*u,e[10]=w*h+b}return e[3]=0,e[7]=0,e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,this},makeRotationFromQuaternion:function(t){var e=this.elements,i=t._x,r=t._y,n=t._z,o=t._w,a=i+i,s=r+r,c=n+n,u=i*a,h=i*s,l=i*c,p=r*s,d=r*c,f=n*c,m=o*a,g=o*s,v=o*c;return e[0]=1-(p+f),e[4]=h-v,e[8]=l+g,e[1]=h+v,e[5]=1-(u+f),e[9]=d-m,e[2]=l-g,e[6]=d+m,e[10]=1-(u+p),e[3]=0,e[7]=0,e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,this},lookAt:(S=new $e,A=new $e,M=new $e,function(t,e,i){var r=this.elements;return M.subVectors(t,e),0===M.lengthSq()&&(M.z=1),M.normalize(),S.crossVectors(i,M),0===S.lengthSq()&&(1===Math.abs(i.z)?M.x+=1e-4:M.z+=1e-4,M.normalize(),S.crossVectors(i,M)),S.normalize(),A.crossVectors(M,S),r[0]=S.x,r[4]=A.x,r[8]=M.x,r[1]=S.y,r[5]=A.y,r[9]=M.y,r[2]=S.z,r[6]=A.z,r[10]=M.z,this}),multiply:function(t,e){return void 0!==e?(console.warn("THREE.Matrix4: .multiply() now only accepts one argument. Use .multiplyMatrices( a, b ) instead."),this.multiplyMatrices(t,e)):this.multiplyMatrices(this,t)},premultiply:function(t){return this.multiplyMatrices(t,this)},multiplyMatrices:function(t,e){var i=t.elements,r=e.elements,n=this.elements,o=i[0],a=i[4],s=i[8],c=i[12],u=i[1],h=i[5],l=i[9],p=i[13],d=i[2],f=i[6],m=i[10],g=i[14],v=i[3],y=i[7],b=i[11],x=i[15],_=r[0],w=r[4],S=r[8],A=r[12],M=r[1],P=r[5],T=r[9],E=r[13],C=r[2],I=r[6],R=r[10],L=r[14],O=r[3],D=r[7],k=r[11],N=r[15];return n[0]=o*_+a*M+s*C+c*O,n[4]=o*w+a*P+s*I+c*D,n[8]=o*S+a*T+s*R+c*k,n[12]=o*A+a*E+s*L+c*N,n[1]=u*_+h*M+l*C+p*O,n[5]=u*w+h*P+l*I+p*D,n[9]=u*S+h*T+l*R+p*k,n[13]=u*A+h*E+l*L+p*N,n[2]=d*_+f*M+m*C+g*O,n[6]=d*w+f*P+m*I+g*D,n[10]=d*S+f*T+m*R+g*k,n[14]=d*A+f*E+m*L+g*N,n[3]=v*_+y*M+b*C+x*O,n[7]=v*w+y*P+b*I+x*D,n[11]=v*S+y*T+b*R+x*k,n[15]=v*A+y*E+b*L+x*N,this},multiplyScalar:function(t){var e=this.elements;return e[0]*=t,e[4]*=t,e[8]*=t,e[12]*=t,e[1]*=t,e[5]*=t,e[9]*=t,e[13]*=t,e[2]*=t,e[6]*=t,e[10]*=t,e[14]*=t,e[3]*=t,e[7]*=t,e[11]*=t,e[15]*=t,this},applyToBufferAttribute:(w=new $e,function(t){for(var e=0,i=t.count;e<i;e++)w.x=t.getX(e),w.y=t.getY(e),w.z=t.getZ(e),w.applyMatrix4(this),t.setXYZ(e,w.x,w.y,w.z);return t}),determinant:function(){var t=this.elements,e=t[0],i=t[4],r=t[8],n=t[12],o=t[1],a=t[5],s=t[9],c=t[13],u=t[2],h=t[6],l=t[10],p=t[14];return t[3]*(+n*s*h-r*c*h-n*a*l+i*c*l+r*a*p-i*s*p)+t[7]*(+e*s*p-e*c*l+n*o*l-r*o*p+r*c*u-n*s*u)+t[11]*(+e*c*h-e*a*p-n*o*h+i*o*p+n*a*u-i*c*u)+t[15]*(-r*a*u-e*s*h+e*a*l+r*o*h-i*o*l+i*s*u)},transpose:function(){var t,e=this.elements;return t=e[1],e[1]=e[4],e[4]=t,t=e[2],e[2]=e[8],e[8]=t,t=e[6],e[6]=e[9],e[9]=t,t=e[3],e[3]=e[12],e[12]=t,t=e[7],e[7]=e[13],e[13]=t,t=e[11],e[11]=e[14],e[14]=t,this},setPosition:function(t){var e=this.elements;return e[12]=t.x,e[13]=t.y,e[14]=t.z,this},getInverse:function(t,e){var i=this.elements,r=t.elements,n=r[0],o=r[1],a=r[2],s=r[3],c=r[4],u=r[5],h=r[6],l=r[7],p=r[8],d=r[9],f=r[10],m=r[11],g=r[12],v=r[13],y=r[14],b=r[15],x=d*y*l-v*f*l+v*h*m-u*y*m-d*h*b+u*f*b,_=g*f*l-p*y*l-g*h*m+c*y*m+p*h*b-c*f*b,w=p*v*l-g*d*l+g*u*m-c*v*m-p*u*b+c*d*b,S=g*d*h-p*v*h-g*u*f+c*v*f+p*u*y-c*d*y,A=n*x+o*_+a*w+s*S;if(0===A){var M="THREE.Matrix4: .getInverse() can't invert matrix, determinant is 0";if(!0===e)throw new Error(M);return console.warn(M),this.identity()}var P=1/A;return i[0]=x*P,i[1]=(v*f*s-d*y*s-v*a*m+o*y*m+d*a*b-o*f*b)*P,i[2]=(u*y*s-v*h*s+v*a*l-o*y*l-u*a*b+o*h*b)*P,i[3]=(d*h*s-u*f*s-d*a*l+o*f*l+u*a*m-o*h*m)*P,i[4]=_*P,i[5]=(p*y*s-g*f*s+g*a*m-n*y*m-p*a*b+n*f*b)*P,i[6]=(g*h*s-c*y*s-g*a*l+n*y*l+c*a*b-n*h*b)*P,i[7]=(c*f*s-p*h*s+p*a*l-n*f*l-c*a*m+n*h*m)*P,i[8]=w*P,i[9]=(g*d*s-p*v*s-g*o*m+n*v*m+p*o*b-n*d*b)*P,i[10]=(c*v*s-g*u*s+g*o*l-n*v*l-c*o*b+n*u*b)*P,i[11]=(p*u*s-c*d*s-p*o*l+n*d*l+c*o*m-n*u*m)*P,i[12]=S*P,i[13]=(p*v*a-g*d*a+g*o*f-n*v*f-p*o*y+n*d*y)*P,i[14]=(g*u*a-c*v*a-g*o*h+n*v*h+c*o*y-n*u*y)*P,i[15]=(c*d*a-p*u*a+p*o*h-n*d*h-c*o*f+n*u*f)*P,this},scale:function(t){var e=this.elements,i=t.x,r=t.y,n=t.z;return e[0]*=i,e[4]*=r,e[8]*=n,e[1]*=i,e[5]*=r,e[9]*=n,e[2]*=i,e[6]*=r,e[10]*=n,e[3]*=i,e[7]*=r,e[11]*=n,this},getMaxScaleOnAxis:function(){var t=this.elements,e=t[0]*t[0]+t[1]*t[1]+t[2]*t[2],i=t[4]*t[4]+t[5]*t[5]+t[6]*t[6],r=t[8]*t[8]+t[9]*t[9]+t[10]*t[10];return Math.sqrt(Math.max(e,i,r))},makeTranslation:function(t,e,i){return this.set(1,0,0,t,0,1,0,e,0,0,1,i,0,0,0,1),this},makeRotationX:function(t){var e=Math.cos(t),i=Math.sin(t);return this.set(1,0,0,0,0,e,-i,0,0,i,e,0,0,0,0,1),this},makeRotationY:function(t){var e=Math.cos(t),i=Math.sin(t);return this.set(e,0,i,0,0,1,0,0,-i,0,e,0,0,0,0,1),this},makeRotationZ:function(t){var e=Math.cos(t),i=Math.sin(t);return this.set(e,-i,0,0,i,e,0,0,0,0,1,0,0,0,0,1),this},makeRotationAxis:function(t,e){var i=Math.cos(e),r=Math.sin(e),n=1-i,o=t.x,a=t.y,s=t.z,c=n*o,u=n*a;return this.set(c*o+i,c*a-r*s,c*s+r*a,0,c*a+r*s,u*a+i,u*s-r*o,0,c*s-r*a,u*s+r*o,n*s*s+i,0,0,0,0,1),this},makeScale:function(t,e,i){return this.set(t,0,0,0,0,e,0,0,0,0,i,0,0,0,0,1),this},makeShear:function(t,e,i){return this.set(1,e,i,0,t,1,i,0,t,e,1,0,0,0,0,1),this},compose:function(t,e,i){return this.makeRotationFromQuaternion(e),this.scale(i),this.setPosition(t),this},decompose:(x=new $e,_=new Ve,function(t,e,i){var r=this.elements,n=x.set(r[0],r[1],r[2]).length(),o=x.set(r[4],r[5],r[6]).length(),a=x.set(r[8],r[9],r[10]).length();this.determinant()<0&&(n=-n),t.x=r[12],t.y=r[13],t.z=r[14],_.copy(this);var s=1/n,c=1/o,u=1/a;return _.elements[0]*=s,_.elements[1]*=s,_.elements[2]*=s,_.elements[4]*=c,_.elements[5]*=c,_.elements[6]*=c,_.elements[8]*=u,_.elements[9]*=u,_.elements[10]*=u,e.setFromRotationMatrix(_),i.x=n,i.y=o,i.z=a,this}),makePerspective:function(t,e,i,r,n,o){void 0===o&&console.warn("THREE.Matrix4: .makePerspective() has been redefined and has a new signature. Please check the docs.");var a=this.elements,s=2*n/(e-t),c=2*n/(i-r),u=(e+t)/(e-t),h=(i+r)/(i-r),l=-(o+n)/(o-n),p=-2*o*n/(o-n);return a[0]=s,a[4]=0,a[8]=u,a[12]=0,a[1]=0,a[5]=c,a[9]=h,a[13]=0,a[2]=0,a[6]=0,a[10]=l,a[14]=p,a[3]=0,a[7]=0,a[11]=-1,a[15]=0,this},makeOrthographic:function(t,e,i,r,n,o){var a=this.elements,s=1/(e-t),c=1/(i-r),u=1/(o-n),h=(e+t)*s,l=(i+r)*c,p=(o+n)*u;return a[0]=2*s,a[4]=0,a[8]=0,a[12]=-h,a[1]=0,a[5]=2*c,a[9]=0,a[13]=-l,a[2]=0,a[6]=0,a[10]=-2*u,a[14]=-p,a[3]=0,a[7]=0,a[11]=0,a[15]=1,this},equals:function(t){for(var e=this.elements,i=t.elements,r=0;r<16;r++)if(e[r]!==i[r])return!1;return!0},fromArray:function(t,e){void 0===e&&(e=0);for(var i=0;i<16;i++)this.elements[i]=t[i+e];return this},toArray:function(t,e){void 0===t&&(t=[]),void 0===e&&(e=0);var i=this.elements;return t[e]=i[0],t[e+1]=i[1],t[e+2]=i[2],t[e+3]=i[3],t[e+4]=i[4],t[e+5]=i[5],t[e+6]=i[6],t[e+7]=i[7],t[e+8]=i[8],t[e+9]=i[9],t[e+10]=i[10],t[e+11]=i[11],t[e+12]=i[12],t[e+13]=i[13],t[e+14]=i[14],t[e+15]=i[15],t}}),Object.assign(He,{slerp:function(t,e,i,r){return i.copy(t).slerp(e,r)},slerpFlat:function(t,e,i,r,n,o,a){var s=i[r+0],c=i[r+1],u=i[r+2],h=i[r+3],l=n[o+0],p=n[o+1],d=n[o+2],f=n[o+3];if(h!==f||s!==l||c!==p||u!==d){var m=1-a,g=s*l+c*p+u*d+h*f,v=g>=0?1:-1,y=1-g*g;if(y>Number.EPSILON){var b=Math.sqrt(y),x=Math.atan2(b,g*v);m=Math.sin(m*x)/b,a=Math.sin(a*x)/b}var _=a*v;if(s=s*m+l*_,c=c*m+p*_,u=u*m+d*_,h=h*m+f*_,m===1-a){var w=1/Math.sqrt(s*s+c*c+u*u+h*h);s*=w,c*=w,u*=w,h*=w}}t[e]=s,t[e+1]=c,t[e+2]=u,t[e+3]=h}}),Object.defineProperties(He.prototype,{x:{get:function(){return this._x},set:function(t){this._x=t,this.onChangeCallback()}},y:{get:function(){return this._y},set:function(t){this._y=t,this.onChangeCallback()}},z:{get:function(){return this._z},set:function(t){this._z=t,this.onChangeCallback()}},w:{get:function(){return this._w},set:function(t){this._w=t,this.onChangeCallback()}}}),Object.assign(He.prototype,{set:function(t,e,i,r){return this._x=t,this._y=e,this._z=i,this._w=r,this.onChangeCallback(),this},clone:function(){return new this.constructor(this._x,this._y,this._z,this._w)},copy:function(t){return this._x=t.x,this._y=t.y,this._z=t.z,this._w=t.w,this.onChangeCallback(),this},setFromEuler:function(t,e){if(!t||!t.isEuler)throw new Error("THREE.Quaternion: .setFromEuler() now expects an Euler rotation rather than a Vector3 and order.");var i=t._x,r=t._y,n=t._z,o=t.order,a=Math.cos,s=Math.sin,c=a(i/2),u=a(r/2),h=a(n/2),l=s(i/2),p=s(r/2),d=s(n/2);return"XYZ"===o?(this._x=l*u*h+c*p*d,this._y=c*p*h-l*u*d,this._z=c*u*d+l*p*h,this._w=c*u*h-l*p*d):"YXZ"===o?(this._x=l*u*h+c*p*d,this._y=c*p*h-l*u*d,this._z=c*u*d-l*p*h,this._w=c*u*h+l*p*d):"ZXY"===o?(this._x=l*u*h-c*p*d,this._y=c*p*h+l*u*d,this._z=c*u*d+l*p*h,this._w=c*u*h-l*p*d):"ZYX"===o?(this._x=l*u*h-c*p*d,this._y=c*p*h+l*u*d,this._z=c*u*d-l*p*h,this._w=c*u*h+l*p*d):"YZX"===o?(this._x=l*u*h+c*p*d,this._y=c*p*h+l*u*d,this._z=c*u*d-l*p*h,this._w=c*u*h-l*p*d):"XZY"===o&&(this._x=l*u*h-c*p*d,this._y=c*p*h-l*u*d,this._z=c*u*d+l*p*h,this._w=c*u*h+l*p*d),!1!==e&&this.onChangeCallback(),this},setFromAxisAngle:function(t,e){var i=e/2,r=Math.sin(i);return this._x=t.x*r,this._y=t.y*r,this._z=t.z*r,this._w=Math.cos(i),this.onChangeCallback(),this},setFromRotationMatrix:function(t){var e,i=t.elements,r=i[0],n=i[4],o=i[8],a=i[1],s=i[5],c=i[9],u=i[2],h=i[6],l=i[10],p=r+s+l;return p>0?(e=.5/Math.sqrt(p+1),this._w=.25/e,this._x=(h-c)*e,this._y=(o-u)*e,this._z=(a-n)*e):r>s&&r>l?(e=2*Math.sqrt(1+r-s-l),this._w=(h-c)/e,this._x=.25*e,this._y=(n+a)/e,this._z=(o+u)/e):s>l?(e=2*Math.sqrt(1+s-r-l),this._w=(o-u)/e,this._x=(n+a)/e,this._y=.25*e,this._z=(c+h)/e):(e=2*Math.sqrt(1+l-r-s),this._w=(a-n)/e,this._x=(o+u)/e,this._y=(c+h)/e,this._z=.25*e),this.onChangeCallback(),this},setFromUnitVectors:(E=new $e,function(t,e){return void 0===E&&(E=new $e),(T=t.dot(e)+1)<1e-6?(T=0,Math.abs(t.x)>Math.abs(t.z)?E.set(-t.y,t.x,0):E.set(0,-t.z,t.y)):E.crossVectors(t,e),this._x=E.x,this._y=E.y,this._z=E.z,this._w=T,this.normalize()}),inverse:function(){return this.conjugate().normalize()},conjugate:function(){return this._x*=-1,this._y*=-1,this._z*=-1,this.onChangeCallback(),this},dot:function(t){return this._x*t._x+this._y*t._y+this._z*t._z+this._w*t._w},lengthSq:function(){return this._x*this._x+this._y*this._y+this._z*this._z+this._w*this._w},length:function(){return Math.sqrt(this._x*this._x+this._y*this._y+this._z*this._z+this._w*this._w)},normalize:function(){var t=this.length();return 0===t?(this._x=0,this._y=0,this._z=0,this._w=1):(t=1/t,this._x=this._x*t,this._y=this._y*t,this._z=this._z*t,this._w=this._w*t),this.onChangeCallback(),this},multiply:function(t,e){return void 0!==e?(console.warn("THREE.Quaternion: .multiply() now only accepts one argument. Use .multiplyQuaternions( a, b ) instead."),this.multiplyQuaternions(t,e)):this.multiplyQuaternions(this,t)},premultiply:function(t){return this.multiplyQuaternions(t,this)},multiplyQuaternions:function(t,e){var i=t._x,r=t._y,n=t._z,o=t._w,a=e._x,s=e._y,c=e._z,u=e._w;return this._x=i*u+o*a+r*c-n*s,this._y=r*u+o*s+n*a-i*c,this._z=n*u+o*c+i*s-r*a,this._w=o*u-i*a-r*s-n*c,this.onChangeCallback(),this},slerp:function(t,e){if(0===e)return this;if(1===e)return this.copy(t);var i=this._x,r=this._y,n=this._z,o=this._w,a=o*t._w+i*t._x+r*t._y+n*t._z;if(a<0?(this._w=-t._w,this._x=-t._x,this._y=-t._y,this._z=-t._z,a=-a):this.copy(t),a>=1)return this._w=o,this._x=i,this._y=r,this._z=n,this;var s=Math.sqrt(1-a*a);if(Math.abs(s)<.001)return this._w=.5*(o+this._w),this._x=.5*(i+this._x),this._y=.5*(r+this._y),this._z=.5*(n+this._z),this;var c=Math.atan2(s,a),u=Math.sin((1-e)*c)/s,h=Math.sin(e*c)/s;return this._w=o*u+this._w*h,this._x=i*u+this._x*h,this._y=r*u+this._y*h,this._z=n*u+this._z*h,this.onChangeCallback(),this},equals:function(t){return t._x===this._x&&t._y===this._y&&t._z===this._z&&t._w===this._w},fromArray:function(t,e){return void 0===e&&(e=0),this._x=t[e],this._y=t[e+1],this._z=t[e+2],this._w=t[e+3],this.onChangeCallback(),this},toArray:function(t,e){return void 0===t&&(t=[]),void 0===e&&(e=0),t[e]=this._x,t[e+1]=this._y,t[e+2]=this._z,t[e+3]=this._w,t},onChange:function(t){return this.onChangeCallback=t,this},onChangeCallback:function(){}}),Object.assign($e.prototype,{isVector3:!0,set:function(t,e,i){return this.x=t,this.y=e,this.z=i,this},setScalar:function(t){return this.x=t,this.y=t,this.z=t,this},setX:function(t){return this.x=t,this},setY:function(t){return this.y=t,this},setZ:function(t){return this.z=t,this},setComponent:function(t,e){switch(t){case 0:this.x=e;break;case 1:this.y=e;break;case 2:this.z=e;break;default:throw new Error("index is out of range: "+t)}return this},getComponent:function(t){switch(t){case 0:return this.x;case 1:return this.y;case 2:return this.z;default:throw new Error("index is out of range: "+t)}},clone:function(){return new this.constructor(this.x,this.y,this.z)},copy:function(t){return this.x=t.x,this.y=t.y,this.z=t.z,this},add:function(t,e){return void 0!==e?(console.warn("THREE.Vector3: .add() now only accepts one argument. Use .addVectors( a, b ) instead."),this.addVectors(t,e)):(this.x+=t.x,this.y+=t.y,this.z+=t.z,this)},addScalar:function(t){return this.x+=t,this.y+=t,this.z+=t,this},addVectors:function(t,e){return this.x=t.x+e.x,this.y=t.y+e.y,this.z=t.z+e.z,this},addScaledVector:function(t,e){return this.x+=t.x*e,this.y+=t.y*e,this.z+=t.z*e,this},sub:function(t,e){return void 0!==e?(console.warn("THREE.Vector3: .sub() now only accepts one argument. Use .subVectors( a, b ) instead."),this.subVectors(t,e)):(this.x-=t.x,this.y-=t.y,this.z-=t.z,this)},subScalar:function(t){return this.x-=t,this.y-=t,this.z-=t,this},subVectors:function(t,e){return this.x=t.x-e.x,this.y=t.y-e.y,this.z=t.z-e.z,this},multiply:function(t,e){return void 0!==e?(console.warn("THREE.Vector3: .multiply() now only accepts one argument. Use .multiplyVectors( a, b ) instead."),this.multiplyVectors(t,e)):(this.x*=t.x,this.y*=t.y,this.z*=t.z,this)},multiplyScalar:function(t){return this.x*=t,this.y*=t,this.z*=t,this},multiplyVectors:function(t,e){return this.x=t.x*e.x,this.y=t.y*e.y,this.z=t.z*e.z,this},applyEuler:(N=new He,function(t){return t&&t.isEuler||console.error("THREE.Vector3: .applyEuler() now expects an Euler rotation rather than a Vector3 and order."),this.applyQuaternion(N.setFromEuler(t))}),applyAxisAngle:(k=new He,function(t,e){return this.applyQuaternion(k.setFromAxisAngle(t,e))}),applyMatrix3:function(t){var e=this.x,i=this.y,r=this.z,n=t.elements;return this.x=n[0]*e+n[3]*i+n[6]*r,this.y=n[1]*e+n[4]*i+n[7]*r,this.z=n[2]*e+n[5]*i+n[8]*r,this},applyMatrix4:function(t){var e=this.x,i=this.y,r=this.z,n=t.elements,o=1/(n[3]*e+n[7]*i+n[11]*r+n[15]);return this.x=(n[0]*e+n[4]*i+n[8]*r+n[12])*o,this.y=(n[1]*e+n[5]*i+n[9]*r+n[13])*o,this.z=(n[2]*e+n[6]*i+n[10]*r+n[14])*o,this},applyQuaternion:function(t){var e=this.x,i=this.y,r=this.z,n=t.x,o=t.y,a=t.z,s=t.w,c=s*e+o*r-a*i,u=s*i+a*e-n*r,h=s*r+n*i-o*e,l=-n*e-o*i-a*r;return this.x=c*s+l*-n+u*-a-h*-o,this.y=u*s+l*-o+h*-n-c*-a,this.z=h*s+l*-a+c*-o-u*-n,this},project:(D=new Ve,function(t){return D.multiplyMatrices(t.projectionMatrix,D.getInverse(t.matrixWorld)),this.applyMatrix4(D)}),unproject:(O=new Ve,function(t){return O.multiplyMatrices(t.matrixWorld,O.getInverse(t.projectionMatrix)),this.applyMatrix4(O)}),transformDirection:function(t){var e=this.x,i=this.y,r=this.z,n=t.elements;return this.x=n[0]*e+n[4]*i+n[8]*r,this.y=n[1]*e+n[5]*i+n[9]*r,this.z=n[2]*e+n[6]*i+n[10]*r,this.normalize()},divide:function(t){return this.x/=t.x,this.y/=t.y,this.z/=t.z,this},divideScalar:function(t){return this.multiplyScalar(1/t)},min:function(t){return this.x=Math.min(this.x,t.x),this.y=Math.min(this.y,t.y),this.z=Math.min(this.z,t.z),this},max:function(t){return this.x=Math.max(this.x,t.x),this.y=Math.max(this.y,t.y),this.z=Math.max(this.z,t.z),this},clamp:function(t,e){return this.x=Math.max(t.x,Math.min(e.x,this.x)),this.y=Math.max(t.y,Math.min(e.y,this.y)),this.z=Math.max(t.z,Math.min(e.z,this.z)),this},clampScalar:(R=new $e,L=new $e,function(t,e){return R.set(t,t,t),L.set(e,e,e),this.clamp(R,L)}),clampLength:function(t,e){var i=this.length();return this.divideScalar(i||1).multiplyScalar(Math.max(t,Math.min(e,i)))},floor:function(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this.z=Math.floor(this.z),this},ceil:function(){return this.x=Math.ceil(this.x),this.y=Math.ceil(this.y),this.z=Math.ceil(this.z),this},round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this.z=Math.round(this.z),this},roundToZero:function(){return this.x=this.x<0?Math.ceil(this.x):Math.floor(this.x),this.y=this.y<0?Math.ceil(this.y):Math.floor(this.y),this.z=this.z<0?Math.ceil(this.z):Math.floor(this.z),this},negate:function(){return this.x=-this.x,this.y=-this.y,this.z=-this.z,this},dot:function(t){return this.x*t.x+this.y*t.y+this.z*t.z},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z)},manhattanLength:function(){return Math.abs(this.x)+Math.abs(this.y)+Math.abs(this.z)},normalize:function(){return this.divideScalar(this.length()||1)},setLength:function(t){return this.normalize().multiplyScalar(t)},lerp:function(t,e){return this.x+=(t.x-this.x)*e,this.y+=(t.y-this.y)*e,this.z+=(t.z-this.z)*e,this},lerpVectors:function(t,e,i){return this.subVectors(e,t).multiplyScalar(i).add(t)},cross:function(t,e){return void 0!==e?(console.warn("THREE.Vector3: .cross() now only accepts one argument. Use .crossVectors( a, b ) instead."),this.crossVectors(t,e)):this.crossVectors(this,t)},crossVectors:function(t,e){var i=t.x,r=t.y,n=t.z,o=e.x,a=e.y,s=e.z;return this.x=r*s-n*a,this.y=n*o-i*s,this.z=i*a-r*o,this},projectOnVector:function(t){var e=t.dot(this)/t.lengthSq();return this.copy(t).multiplyScalar(e)},projectOnPlane:(I=new $e,function(t){return I.copy(this).projectOnVector(t),this.sub(I)}),reflect:(C=new $e,function(t){return this.sub(C.copy(t).multiplyScalar(2*this.dot(t)))}),angleTo:function(t){var e=this.dot(t)/Math.sqrt(this.lengthSq()*t.lengthSq());return Math.acos(je.clamp(e,-1,1))},distanceTo:function(t){return Math.sqrt(this.distanceToSquared(t))},distanceToSquared:function(t){var e=this.x-t.x,i=this.y-t.y,r=this.z-t.z;return e*e+i*i+r*r},manhattanDistanceTo:function(t){return Math.abs(this.x-t.x)+Math.abs(this.y-t.y)+Math.abs(this.z-t.z)},setFromSpherical:function(t){var e=Math.sin(t.phi)*t.radius;return this.x=e*Math.sin(t.theta),this.y=Math.cos(t.phi)*t.radius,this.z=e*Math.cos(t.theta),this},setFromCylindrical:function(t){return this.x=t.radius*Math.sin(t.theta),this.y=t.y,this.z=t.radius*Math.cos(t.theta),this},setFromMatrixPosition:function(t){var e=t.elements;return this.x=e[12],this.y=e[13],this.z=e[14],this},setFromMatrixScale:function(t){var e=this.setFromMatrixColumn(t,0).length(),i=this.setFromMatrixColumn(t,1).length(),r=this.setFromMatrixColumn(t,2).length();return this.x=e,this.y=i,this.z=r,this},setFromMatrixColumn:function(t,e){return this.fromArray(t.elements,4*e)},equals:function(t){return t.x===this.x&&t.y===this.y&&t.z===this.z},fromArray:function(t,e){return void 0===e&&(e=0),this.x=t[e],this.y=t[e+1],this.z=t[e+2],this},toArray:function(t,e){return void 0===t&&(t=[]),void 0===e&&(e=0),t[e]=this.x,t[e+1]=this.y,t[e+2]=this.z,t},fromBufferAttribute:function(t,e,i){return void 0!==i&&console.warn("THREE.Vector3: offset has been removed from .fromBufferAttribute()."),this.x=t.getX(e),this.y=t.getY(e),this.z=t.getZ(e),this}}),Object.assign(We.prototype,{isMatrix3:!0,set:function(t,e,i,r,n,o,a,s,c){var u=this.elements;return u[0]=t,u[1]=r,u[2]=a,u[3]=e,u[4]=n,u[5]=s,u[6]=i,u[7]=o,u[8]=c,this},identity:function(){return this.set(1,0,0,0,1,0,0,0,1),this},clone:function(){return(new this.constructor).fromArray(this.elements)},copy:function(t){var e=this.elements,i=t.elements;return e[0]=i[0],e[1]=i[1],e[2]=i[2],e[3]=i[3],e[4]=i[4],e[5]=i[5],e[6]=i[6],e[7]=i[7],e[8]=i[8],this},setFromMatrix4:function(t){var e=t.elements;return this.set(e[0],e[4],e[8],e[1],e[5],e[9],e[2],e[6],e[10]),this},applyToBufferAttribute:(B=new $e,function(t){for(var e=0,i=t.count;e<i;e++)B.x=t.getX(e),B.y=t.getY(e),B.z=t.getZ(e),B.applyMatrix3(this),t.setXYZ(e,B.x,B.y,B.z);return t}),multiply:function(t){return this.multiplyMatrices(this,t)},premultiply:function(t){return this.multiplyMatrices(t,this)},multiplyMatrices:function(t,e){var i=t.elements,r=e.elements,n=this.elements,o=i[0],a=i[3],s=i[6],c=i[1],u=i[4],h=i[7],l=i[2],p=i[5],d=i[8],f=r[0],m=r[3],g=r[6],v=r[1],y=r[4],b=r[7],x=r[2],_=r[5],w=r[8];return n[0]=o*f+a*v+s*x,n[3]=o*m+a*y+s*_,n[6]=o*g+a*b+s*w,n[1]=c*f+u*v+h*x,n[4]=c*m+u*y+h*_,n[7]=c*g+u*b+h*w,n[2]=l*f+p*v+d*x,n[5]=l*m+p*y+d*_,n[8]=l*g+p*b+d*w,this},multiplyScalar:function(t){var e=this.elements;return e[0]*=t,e[3]*=t,e[6]*=t,e[1]*=t,e[4]*=t,e[7]*=t,e[2]*=t,e[5]*=t,e[8]*=t,this},determinant:function(){var t=this.elements,e=t[0],i=t[1],r=t[2],n=t[3],o=t[4],a=t[5],s=t[6],c=t[7],u=t[8];return e*o*u-e*a*c-i*n*u+i*a*s+r*n*c-r*o*s},getInverse:function(t,e){t&&t.isMatrix4&&console.error("THREE.Matrix3: .getInverse() no longer takes a Matrix4 argument.");var i=t.elements,r=this.elements,n=i[0],o=i[1],a=i[2],s=i[3],c=i[4],u=i[5],h=i[6],l=i[7],p=i[8],d=p*c-u*l,f=u*h-p*s,m=l*s-c*h,g=n*d+o*f+a*m;if(0===g){var v="THREE.Matrix3: .getInverse() can't invert matrix, determinant is 0";if(!0===e)throw new Error(v);return console.warn(v),this.identity()}var y=1/g;return r[0]=d*y,r[1]=(a*l-p*o)*y,r[2]=(u*o-a*c)*y,r[3]=f*y,r[4]=(p*n-a*h)*y,r[5]=(a*s-u*n)*y,r[6]=m*y,r[7]=(o*h-l*n)*y,r[8]=(c*n-o*s)*y,this},transpose:function(){var t,e=this.elements;return t=e[1],e[1]=e[3],e[3]=t,t=e[2],e[2]=e[6],e[6]=t,t=e[5],e[5]=e[7],e[7]=t,this},getNormalMatrix:function(t){return this.setFromMatrix4(t).getInverse(this).transpose()},transposeIntoArray:function(t){var e=this.elements;return t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],this},setUvTransform:function(t,e,i,r,n,o,a){var s=Math.cos(n),c=Math.sin(n);this.set(i*s,i*c,-i*(s*o+c*a)+o+t,-r*c,r*s,-r*(-c*o+s*a)+a+e,0,0,1)},scale:function(t,e){var i=this.elements;return i[0]*=t,i[3]*=t,i[6]*=t,i[1]*=e,i[4]*=e,i[7]*=e,this},rotate:function(t){var e=Math.cos(t),i=Math.sin(t),r=this.elements,n=r[0],o=r[3],a=r[6],s=r[1],c=r[4],u=r[7];return r[0]=e*n+i*s,r[3]=e*o+i*c,r[6]=e*a+i*u,r[1]=-i*n+e*s,r[4]=-i*o+e*c,r[7]=-i*a+e*u,this},translate:function(t,e){var i=this.elements;return i[0]+=t*i[2],i[3]+=t*i[5],i[6]+=t*i[8],i[1]+=e*i[2],i[4]+=e*i[5],i[7]+=e*i[8],this},equals:function(t){for(var e=this.elements,i=t.elements,r=0;r<9;r++)if(e[r]!==i[r])return!1;return!0},fromArray:function(t,e){void 0===e&&(e=0);for(var i=0;i<9;i++)this.elements[i]=t[i+e];return this},toArray:function(t,e){void 0===t&&(t=[]),void 0===e&&(e=0);var i=this.elements;return t[e]=i[0],t[e+1]=i[1],t[e+2]=i[2],t[e+3]=i[3],t[e+4]=i[4],t[e+5]=i[5],t[e+6]=i[6],t[e+7]=i[7],t[e+8]=i[8],t}});var Xe,qe,Ye=0;function Ze(t,e,i,r,n,o,a,s,c,u){Object.defineProperty(this,"id",{value:Ye++}),this.uuid=je.generateUUID(),this.name="",this.image=void 0!==t?t:Ze.DEFAULT_IMAGE,this.mipmaps=[],this.mapping=void 0!==e?e:Ze.DEFAULT_MAPPING,this.wrapS=void 0!==i?i:Vt,this.wrapT=void 0!==r?r:Vt,this.magFilter=void 0!==n?n:qt,this.minFilter=void 0!==o?o:Zt,this.anisotropy=void 0!==c?c:1,this.format=void 0!==a?a:le,this.type=void 0!==s?s:Kt,this.offset=new Ge(0,0),this.repeat=new Ge(1,1),this.center=new Ge(0,0),this.rotation=0,this.matrixAutoUpdate=!0,this.matrix=new We,this.generateMipmaps=!0,this.premultiplyAlpha=!1,this.flipY=!0,this.unpackAlignment=4,this.encoding=void 0!==u?u:Le,this.version=0,this.onUpdate=null}function Ke(t,e,i,r){this.x=t||0,this.y=e||0,this.z=i||0,this.w=void 0!==r?r:1}function Je(t,e,i){this.uuid=je.generateUUID(),this.width=t,this.height=e,this.scissor=new Ke(0,0,t,e),this.scissorTest=!1,this.viewport=new Ke(0,0,t,e),void 0===(i=i||{}).minFilter&&(i.minFilter=qt),this.texture=new Ze(void 0,void 0,i.wrapS,i.wrapT,i.magFilter,i.minFilter,i.format,i.type,i.anisotropy,i.encoding),this.depthBuffer=void 0===i.depthBuffer||i.depthBuffer,this.stencilBuffer=void 0===i.stencilBuffer||i.stencilBuffer,this.depthTexture=void 0!==i.depthTexture?i.depthTexture:null}function Qe(t,e,i){Je.call(this,t,e,i),this.activeCubeFace=0,this.activeMipMapLevel=0}function ti(t,e,i,r,n,o,a,s,c,u,h,l){Ze.call(this,null,o,a,s,c,u,r,n,h,l),this.image={data:t,width:e,height:i},this.magFilter=void 0!==c?c:$t,this.minFilter=void 0!==u?u:$t,this.generateMipmaps=!1,this.flipY=!1,this.unpackAlignment=1}function ei(t,e,i,r,n,o,a,s,c,u){t=void 0!==t?t:[],e=void 0!==e?e:kt,Ze.call(this,t,e,i,r,n,o,a,s,c,u),this.flipY=!1}Ze.DEFAULT_IMAGE=void 0,Ze.DEFAULT_MAPPING=300,Ze.prototype=Object.assign(Object.create(v.prototype),{constructor:Ze,isTexture:!0,clone:function(){return(new this.constructor).copy(this)},copy:function(t){return this.name=t.name,this.image=t.image,this.mipmaps=t.mipmaps.slice(0),this.mapping=t.mapping,this.wrapS=t.wrapS,this.wrapT=t.wrapT,this.magFilter=t.magFilter,this.minFilter=t.minFilter,this.anisotropy=t.anisotropy,this.format=t.format,this.type=t.type,this.offset.copy(t.offset),this.repeat.copy(t.repeat),this.center.copy(t.center),this.rotation=t.rotation,this.matrixAutoUpdate=t.matrixAutoUpdate,this.matrix.copy(t.matrix),this.generateMipmaps=t.generateMipmaps,this.premultiplyAlpha=t.premultiplyAlpha,this.flipY=t.flipY,this.unpackAlignment=t.unpackAlignment,this.encoding=t.encoding,this},toJSON:function(t){var e=void 0===t||"string"==typeof t;if(!e&&void 0!==t.textures[this.uuid])return t.textures[this.uuid];var i={metadata:{version:4.5,type:"Texture",generator:"Texture.toJSON"},uuid:this.uuid,name:this.name,mapping:this.mapping,repeat:[this.repeat.x,this.repeat.y],offset:[this.offset.x,this.offset.y],center:[this.center.x,this.center.y],rotation:this.rotation,wrap:[this.wrapS,this.wrapT],minFilter:this.minFilter,magFilter:this.magFilter,anisotropy:this.anisotropy,flipY:this.flipY};if(void 0!==this.image){var r=this.image;void 0===r.uuid&&(r.uuid=je.generateUUID()),e||void 0!==t.images[r.uuid]||(t.images[r.uuid]={uuid:r.uuid,url:function(t){var e;if(t instanceof HTMLCanvasElement)e=t;else{(e=document.createElementNS("http://www.w3.org/1999/xhtml","canvas")).width=t.width,e.height=t.height;var i=e.getContext("2d");t instanceof ImageData?i.putImageData(t,0,0):i.drawImage(t,0,0,t.width,t.height)}return e.width>2048||e.height>2048?e.toDataURL("image/jpeg",.6):e.toDataURL("image/png")}(r)}),i.image=r.uuid}return e||(t.textures[this.uuid]=i),i},dispose:function(){this.dispatchEvent({type:"dispose"})},transformUv:function(t){if(300===this.mapping){if(t.applyMatrix3(this.matrix),t.x<0||t.x>1)switch(this.wrapS){case Gt:t.x=t.x-Math.floor(t.x);break;case Vt:t.x=t.x<0?0:1;break;case Ht:1===Math.abs(Math.floor(t.x)%2)?t.x=Math.ceil(t.x)-t.x:t.x=t.x-Math.floor(t.x)}if(t.y<0||t.y>1)switch(this.wrapT){case Gt:t.y=t.y-Math.floor(t.y);break;case Vt:t.y=t.y<0?0:1;break;case Ht:1===Math.abs(Math.floor(t.y)%2)?t.y=Math.ceil(t.y)-t.y:t.y=t.y-Math.floor(t.y)}this.flipY&&(t.y=1-t.y)}}}),Object.defineProperty(Ze.prototype,"needsUpdate",{set:function(t){!0===t&&this.version++}}),Object.assign(Ke.prototype,{isVector4:!0,set:function(t,e,i,r){return this.x=t,this.y=e,this.z=i,this.w=r,this},setScalar:function(t){return this.x=t,this.y=t,this.z=t,this.w=t,this},setX:function(t){return this.x=t,this},setY:function(t){return this.y=t,this},setZ:function(t){return this.z=t,this},setW:function(t){return this.w=t,this},setComponent:function(t,e){switch(t){case 0:this.x=e;break;case 1:this.y=e;break;case 2:this.z=e;break;case 3:this.w=e;break;default:throw new Error("index is out of range: "+t)}return this},getComponent:function(t){switch(t){case 0:return this.x;case 1:return this.y;case 2:return this.z;case 3:return this.w;default:throw new Error("index is out of range: "+t)}},clone:function(){return new this.constructor(this.x,this.y,this.z,this.w)},copy:function(t){return this.x=t.x,this.y=t.y,this.z=t.z,this.w=void 0!==t.w?t.w:1,this},add:function(t,e){return void 0!==e?(console.warn("THREE.Vector4: .add() now only accepts one argument. Use .addVectors( a, b ) instead."),this.addVectors(t,e)):(this.x+=t.x,this.y+=t.y,this.z+=t.z,this.w+=t.w,this)},addScalar:function(t){return this.x+=t,this.y+=t,this.z+=t,this.w+=t,this},addVectors:function(t,e){return this.x=t.x+e.x,this.y=t.y+e.y,this.z=t.z+e.z,this.w=t.w+e.w,this},addScaledVector:function(t,e){return this.x+=t.x*e,this.y+=t.y*e,this.z+=t.z*e,this.w+=t.w*e,this},sub:function(t,e){return void 0!==e?(console.warn("THREE.Vector4: .sub() now only accepts one argument. Use .subVectors( a, b ) instead."),this.subVectors(t,e)):(this.x-=t.x,this.y-=t.y,this.z-=t.z,this.w-=t.w,this)},subScalar:function(t){return this.x-=t,this.y-=t,this.z-=t,this.w-=t,this},subVectors:function(t,e){return this.x=t.x-e.x,this.y=t.y-e.y,this.z=t.z-e.z,this.w=t.w-e.w,this},multiplyScalar:function(t){return this.x*=t,this.y*=t,this.z*=t,this.w*=t,this},applyMatrix4:function(t){var e=this.x,i=this.y,r=this.z,n=this.w,o=t.elements;return this.x=o[0]*e+o[4]*i+o[8]*r+o[12]*n,this.y=o[1]*e+o[5]*i+o[9]*r+o[13]*n,this.z=o[2]*e+o[6]*i+o[10]*r+o[14]*n,this.w=o[3]*e+o[7]*i+o[11]*r+o[15]*n,this},divideScalar:function(t){return this.multiplyScalar(1/t)},setAxisAngleFromQuaternion:function(t){this.w=2*Math.acos(t.w);var e=Math.sqrt(1-t.w*t.w);return e<1e-4?(this.x=1,this.y=0,this.z=0):(this.x=t.x/e,this.y=t.y/e,this.z=t.z/e),this},setAxisAngleFromRotationMatrix:function(t){var e,i,r,n,o=t.elements,a=o[0],s=o[4],c=o[8],u=o[1],h=o[5],l=o[9],p=o[2],d=o[6],f=o[10];if(Math.abs(s-u)<.01&&Math.abs(c-p)<.01&&Math.abs(l-d)<.01){if(Math.abs(s+u)<.1&&Math.abs(c+p)<.1&&Math.abs(l+d)<.1&&Math.abs(a+h+f-3)<.1)return this.set(1,0,0,0),this;e=Math.PI;var m=(a+1)/2,g=(h+1)/2,v=(f+1)/2,y=(s+u)/4,b=(c+p)/4,x=(l+d)/4;return m>g&&m>v?m<.01?(i=0,r=.707106781,n=.707106781):(r=y/(i=Math.sqrt(m)),n=b/i):g>v?g<.01?(i=.707106781,r=0,n=.707106781):(i=y/(r=Math.sqrt(g)),n=x/r):v<.01?(i=.707106781,r=.707106781,n=0):(i=b/(n=Math.sqrt(v)),r=x/n),this.set(i,r,n,e),this}var _=Math.sqrt((d-l)*(d-l)+(c-p)*(c-p)+(u-s)*(u-s));return Math.abs(_)<.001&&(_=1),this.x=(d-l)/_,this.y=(c-p)/_,this.z=(u-s)/_,this.w=Math.acos((a+h+f-1)/2),this},min:function(t){return this.x=Math.min(this.x,t.x),this.y=Math.min(this.y,t.y),this.z=Math.min(this.z,t.z),this.w=Math.min(this.w,t.w),this},max:function(t){return this.x=Math.max(this.x,t.x),this.y=Math.max(this.y,t.y),this.z=Math.max(this.z,t.z),this.w=Math.max(this.w,t.w),this},clamp:function(t,e){return this.x=Math.max(t.x,Math.min(e.x,this.x)),this.y=Math.max(t.y,Math.min(e.y,this.y)),this.z=Math.max(t.z,Math.min(e.z,this.z)),this.w=Math.max(t.w,Math.min(e.w,this.w)),this},clampScalar:function(t,e){return void 0===Xe&&(Xe=new Ke,qe=new Ke),Xe.set(t,t,t,t),qe.set(e,e,e,e),this.clamp(Xe,qe)},clampLength:function(t,e){var i=this.length();return this.divideScalar(i||1).multiplyScalar(Math.max(t,Math.min(e,i)))},floor:function(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this.z=Math.floor(this.z),this.w=Math.floor(this.w),this},ceil:function(){return this.x=Math.ceil(this.x),this.y=Math.ceil(this.y),this.z=Math.ceil(this.z),this.w=Math.ceil(this.w),this},round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this.z=Math.round(this.z),this.w=Math.round(this.w),this},roundToZero:function(){return this.x=this.x<0?Math.ceil(this.x):Math.floor(this.x),this.y=this.y<0?Math.ceil(this.y):Math.floor(this.y),this.z=this.z<0?Math.ceil(this.z):Math.floor(this.z),this.w=this.w<0?Math.ceil(this.w):Math.floor(this.w),this},negate:function(){return this.x=-this.x,this.y=-this.y,this.z=-this.z,this.w=-this.w,this},dot:function(t){return this.x*t.x+this.y*t.y+this.z*t.z+this.w*t.w},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)},manhattanLength:function(){return Math.abs(this.x)+Math.abs(this.y)+Math.abs(this.z)+Math.abs(this.w)},normalize:function(){return this.divideScalar(this.length()||1)},setLength:function(t){return this.normalize().multiplyScalar(t)},lerp:function(t,e){return this.x+=(t.x-this.x)*e,this.y+=(t.y-this.y)*e,this.z+=(t.z-this.z)*e,this.w+=(t.w-this.w)*e,this},lerpVectors:function(t,e,i){return this.subVectors(e,t).multiplyScalar(i).add(t)},equals:function(t){return t.x===this.x&&t.y===this.y&&t.z===this.z&&t.w===this.w},fromArray:function(t,e){return void 0===e&&(e=0),this.x=t[e],this.y=t[e+1],this.z=t[e+2],this.w=t[e+3],this},toArray:function(t,e){return void 0===t&&(t=[]),void 0===e&&(e=0),t[e]=this.x,t[e+1]=this.y,t[e+2]=this.z,t[e+3]=this.w,t},fromBufferAttribute:function(t,e,i){return void 0!==i&&console.warn("THREE.Vector4: offset has been removed from .fromBufferAttribute()."),this.x=t.getX(e),this.y=t.getY(e),this.z=t.getZ(e),this.w=t.getW(e),this}}),Je.prototype=Object.assign(Object.create(v.prototype),{constructor:Je,isWebGLRenderTarget:!0,setSize:function(t,e){this.width===t&&this.height===e||(this.width=t,this.height=e,this.dispose()),this.viewport.set(0,0,t,e),this.scissor.set(0,0,t,e)},clone:function(){return(new this.constructor).copy(this)},copy:function(t){return this.width=t.width,this.height=t.height,this.viewport.copy(t.viewport),this.texture=t.texture.clone(),this.depthBuffer=t.depthBuffer,this.stencilBuffer=t.stencilBuffer,this.depthTexture=t.depthTexture,this},dispose:function(){this.dispatchEvent({type:"dispose"})}}),Qe.prototype=Object.create(Je.prototype),Qe.prototype.constructor=Qe,Qe.prototype.isWebGLRenderTargetCube=!0,ti.prototype=Object.create(Ze.prototype),ti.prototype.constructor=ti,ti.prototype.isDataTexture=!0,ei.prototype=Object.create(Ze.prototype),ei.prototype.constructor=ei,ei.prototype.isCubeTexture=!0,Object.defineProperty(ei.prototype,"images",{get:function(){return this.image},set:function(t){this.image=t}});var ii=new Ze,ri=new ei;function ni(){this.seq=[],this.map={}}var oi=[],ai=[],si=new Float32Array(16),ci=new Float32Array(9);function ui(t,e,i){var r=t[0];if(r<=0||r>0)return t;var n=e*i,o=oi[n];if(void 0===o&&(o=new Float32Array(n),oi[n]=o),0!==e){r.toArray(o,0);for(var a=1,s=0;a!==e;++a)s+=i,t[a].toArray(o,s)}return o}function hi(t,e){var i=ai[e];void 0===i&&(i=new Int32Array(e),ai[e]=i);for(var r=0;r!==e;++r)i[r]=t.allocTextureUnit();return i}function li(t,e){t.uniform1f(this.addr,e)}function pi(t,e){t.uniform1i(this.addr,e)}function di(t,e){void 0===e.x?t.uniform2fv(this.addr,e):t.uniform2f(this.addr,e.x,e.y)}function fi(t,e){void 0!==e.x?t.uniform3f(this.addr,e.x,e.y,e.z):void 0!==e.r?t.uniform3f(this.addr,e.r,e.g,e.b):t.uniform3fv(this.addr,e)}function mi(t,e){void 0===e.x?t.uniform4fv(this.addr,e):t.uniform4f(this.addr,e.x,e.y,e.z,e.w)}function gi(t,e){t.uniformMatrix2fv(this.addr,!1,e.elements||e)}function vi(t,e){void 0===e.elements?t.uniformMatrix3fv(this.addr,!1,e):(ci.set(e.elements),t.uniformMatrix3fv(this.addr,!1,ci))}function yi(t,e){void 0===e.elements?t.uniformMatrix4fv(this.addr,!1,e):(si.set(e.elements),t.uniformMatrix4fv(this.addr,!1,si))}function bi(t,e,i){var r=i.allocTextureUnit();t.uniform1i(this.addr,r),i.setTexture2D(e||ii,r)}function xi(t,e,i){var r=i.allocTextureUnit();t.uniform1i(this.addr,r),i.setTextureCube(e||ri,r)}function _i(t,e){t.uniform2iv(this.addr,e)}function wi(t,e){t.uniform3iv(this.addr,e)}function Si(t,e){t.uniform4iv(this.addr,e)}function Ai(t,e){t.uniform1fv(this.addr,e)}function Mi(t,e){t.uniform1iv(this.addr,e)}function Pi(t,e){t.uniform2fv(this.addr,ui(e,this.size,2))}function Ti(t,e){t.uniform3fv(this.addr,ui(e,this.size,3))}function Ei(t,e){t.uniform4fv(this.addr,ui(e,this.size,4))}function Ci(t,e){t.uniformMatrix2fv(this.addr,!1,ui(e,this.size,4))}function Ii(t,e){t.uniformMatrix3fv(this.addr,!1,ui(e,this.size,9))}function Ri(t,e){t.uniformMatrix4fv(this.addr,!1,ui(e,this.size,16))}function Li(t,e,i){var r=e.length,n=hi(i,r);t.uniform1iv(this.addr,n);for(var o=0;o!==r;++o)i.setTexture2D(e[o]||ii,n[o])}function Oi(t,e,i){var r=e.length,n=hi(i,r);t.uniform1iv(this.addr,n);for(var o=0;o!==r;++o)i.setTextureCube(e[o]||ri,n[o])}function Di(t,e,i){this.id=t,this.addr=i,this.setValue=function(t){switch(t){case 5126:return li;case 35664:return di;case 35665:return fi;case 35666:return mi;case 35674:return gi;case 35675:return vi;case 35676:return yi;case 35678:case 36198:return bi;case 35680:return xi;case 5124:case 35670:return pi;case 35667:case 35671:return _i;case 35668:case 35672:return wi;case 35669:case 35673:return Si}}(e.type)}function ki(t,e,i){this.id=t,this.addr=i,this.size=e.size,this.setValue=function(t){switch(t){case 5126:return Ai;case 35664:return Pi;case 35665:return Ti;case 35666:return Ei;case 35674:return Ci;case 35675:return Ii;case 35676:return Ri;case 35678:return Li;case 35680:return Oi;case 5124:case 35670:return Mi;case 35667:case 35671:return _i;case 35668:case 35672:return wi;case 35669:case 35673:return Si}}(e.type)}function Ni(t){this.id=t,ni.call(this)}Ni.prototype.setValue=function(t,e){for(var i=this.seq,r=0,n=i.length;r!==n;++r){var o=i[r];o.setValue(t,e[o.id])}};var Bi=/([\w\d_]+)(\])?(\[|\.)?/g;function Fi(t,e){t.seq.push(e),t.map[e.id]=e}function zi(t,e,i){var r=t.name,n=r.length;for(Bi.lastIndex=0;;){var o=Bi.exec(r),a=Bi.lastIndex,s=o[1],c="]"===o[2],u=o[3];if(c&&(s|=0),void 0===u||"["===u&&a+2===n){Fi(i,void 0===u?new Di(s,t,e):new ki(s,t,e));break}var h=i.map[s];void 0===h&&Fi(i,h=new Ni(s)),i=h}}function Ui(t,e,i){ni.call(this),this.renderer=i;for(var r=t.getProgramParameter(e,t.ACTIVE_UNIFORMS),n=0;n<r;++n){var o=t.getActiveUniform(e,n),a=o.name;zi(o,t.getUniformLocation(e,a),this)}}Ui.prototype.setValue=function(t,e,i){var r=this.map[e];void 0!==r&&r.setValue(t,i,this.renderer)},Ui.prototype.setOptional=function(t,e,i){var r=e[i];void 0!==r&&this.setValue(t,i,r)},Ui.upload=function(t,e,i,r){for(var n=0,o=e.length;n!==o;++n){var a=e[n],s=i[a.id];!1!==s.needsUpdate&&a.setValue(t,s.value,r)}},Ui.seqWithValue=function(t,e){for(var i=[],r=0,n=t.length;r!==n;++r){var o=t[r];o.id in e&&i.push(o)}return i};var ji={aliceblue:15792383,antiquewhite:16444375,aqua:65535,aquamarine:8388564,azure:15794175,beige:16119260,bisque:16770244,black:0,blanchedalmond:16772045,blue:255,blueviolet:9055202,brown:10824234,burlywood:14596231,cadetblue:6266528,chartreuse:8388352,chocolate:13789470,coral:16744272,cornflowerblue:6591981,cornsilk:16775388,crimson:14423100,cyan:65535,darkblue:139,darkcyan:35723,darkgoldenrod:12092939,darkgray:11119017,darkgreen:25600,darkgrey:11119017,darkkhaki:12433259,darkmagenta:9109643,darkolivegreen:5597999,darkorange:16747520,darkorchid:10040012,darkred:9109504,darksalmon:15308410,darkseagreen:9419919,darkslateblue:4734347,darkslategray:3100495,darkslategrey:3100495,darkturquoise:52945,darkviolet:9699539,deeppink:16716947,deepskyblue:49151,dimgray:6908265,dimgrey:6908265,dodgerblue:2003199,firebrick:11674146,floralwhite:16775920,forestgreen:2263842,fuchsia:16711935,gainsboro:14474460,ghostwhite:16316671,gold:16766720,goldenrod:14329120,gray:8421504,green:32768,greenyellow:11403055,grey:8421504,honeydew:15794160,hotpink:16738740,indianred:13458524,indigo:4915330,ivory:16777200,khaki:15787660,lavender:15132410,lavenderblush:16773365,lawngreen:8190976,lemonchiffon:16775885,lightblue:11393254,lightcoral:15761536,lightcyan:14745599,lightgoldenrodyellow:16448210,lightgray:13882323,lightgreen:9498256,lightgrey:13882323,lightpink:16758465,lightsalmon:16752762,lightseagreen:2142890,lightskyblue:8900346,lightslategray:7833753,lightslategrey:7833753,lightsteelblue:11584734,lightyellow:16777184,lime:65280,limegreen:3329330,linen:16445670,magenta:16711935,maroon:8388608,mediumaquamarine:6737322,mediumblue:205,mediumorchid:12211667,mediumpurple:9662683,mediumseagreen:3978097,mediumslateblue:8087790,mediumspringgreen:64154,mediumturquoise:4772300,mediumvioletred:13047173,midnightblue:1644912,mintcream:16121850,mistyrose:16770273,moccasin:16770229,navajowhite:16768685,navy:128,oldlace:16643558,olive:8421376,olivedrab:7048739,orange:16753920,orangered:16729344,orchid:14315734,palegoldenrod:15657130,palegreen:10025880,paleturquoise:11529966,palevioletred:14381203,papayawhip:16773077,peachpuff:16767673,peru:13468991,pink:16761035,plum:14524637,powderblue:11591910,purple:8388736,rebeccapurple:6697881,red:16711680,rosybrown:12357519,royalblue:4286945,saddlebrown:9127187,salmon:16416882,sandybrown:16032864,seagreen:3050327,seashell:16774638,sienna:10506797,silver:12632256,skyblue:8900331,slateblue:6970061,slategray:7372944,slategrey:7372944,snow:16775930,springgreen:65407,steelblue:4620980,tan:13808780,teal:32896,thistle:14204888,tomato:16737095,turquoise:4251856,violet:15631086,wheat:16113331,white:16777215,whitesmoke:16119285,yellow:16776960,yellowgreen:10145074};function Gi(t,e,i){return void 0===e&&void 0===i?this.set(t):this.setRGB(t,e,i)}Object.assign(Gi.prototype,{isColor:!0,r:1,g:1,b:1,set:function(t){return t&&t.isColor?this.copy(t):"number"==typeof t?this.setHex(t):"string"==typeof t&&this.setStyle(t),this},setScalar:function(t){return this.r=t,this.g=t,this.b=t,this},setHex:function(t){return t=Math.floor(t),this.r=(t>>16&255)/255,this.g=(t>>8&255)/255,this.b=(255&t)/255,this},setRGB:function(t,e,i){return this.r=t,this.g=e,this.b=i,this},setHSL:function(){function t(t,e,i){return i<0&&(i+=1),i>1&&(i-=1),i<1/6?t+6*(e-t)*i:i<.5?e:i<2/3?t+6*(e-t)*(2/3-i):t}return function(e,i,r){if(e=je.euclideanModulo(e,1),i=je.clamp(i,0,1),r=je.clamp(r,0,1),0===i)this.r=this.g=this.b=r;else{var n=r<=.5?r*(1+i):r+i-r*i,o=2*r-n;this.r=t(o,n,e+1/3),this.g=t(o,n,e),this.b=t(o,n,e-1/3)}return this}}(),setStyle:function(t){function e(e){void 0!==e&&parseFloat(e)<1&&console.warn("THREE.Color: Alpha component of "+t+" will be ignored.")}var i;if(i=/^((?:rgb|hsl)a?)\(\s*([^\)]*)\)/.exec(t)){var r,n=i[1],o=i[2];switch(n){case"rgb":case"rgba":if(r=/^(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*(,\s*([0-9]*\.?[0-9]+)\s*)?$/.exec(o))return this.r=Math.min(255,parseInt(r[1],10))/255,this.g=Math.min(255,parseInt(r[2],10))/255,this.b=Math.min(255,parseInt(r[3],10))/255,e(r[5]),this;if(r=/^(\d+)\%\s*,\s*(\d+)\%\s*,\s*(\d+)\%\s*(,\s*([0-9]*\.?[0-9]+)\s*)?$/.exec(o))return this.r=Math.min(100,parseInt(r[1],10))/100,this.g=Math.min(100,parseInt(r[2],10))/100,this.b=Math.min(100,parseInt(r[3],10))/100,e(r[5]),this;break;case"hsl":case"hsla":if(r=/^([0-9]*\.?[0-9]+)\s*,\s*(\d+)\%\s*,\s*(\d+)\%\s*(,\s*([0-9]*\.?[0-9]+)\s*)?$/.exec(o)){var a=parseFloat(r[1])/360,s=parseInt(r[2],10)/100,c=parseInt(r[3],10)/100;return e(r[5]),this.setHSL(a,s,c)}}}else if(i=/^\#([A-Fa-f0-9]+)$/.exec(t)){var u,h=(u=i[1]).length;if(3===h)return this.r=parseInt(u.charAt(0)+u.charAt(0),16)/255,this.g=parseInt(u.charAt(1)+u.charAt(1),16)/255,this.b=parseInt(u.charAt(2)+u.charAt(2),16)/255,this;if(6===h)return this.r=parseInt(u.charAt(0)+u.charAt(1),16)/255,this.g=parseInt(u.charAt(2)+u.charAt(3),16)/255,this.b=parseInt(u.charAt(4)+u.charAt(5),16)/255,this}t&&t.length>0&&(void 0!==(u=ji[t])?this.setHex(u):console.warn("THREE.Color: Unknown color "+t));return this},clone:function(){return new this.constructor(this.r,this.g,this.b)},copy:function(t){return this.r=t.r,this.g=t.g,this.b=t.b,this},copyGammaToLinear:function(t,e){return void 0===e&&(e=2),this.r=Math.pow(t.r,e),this.g=Math.pow(t.g,e),this.b=Math.pow(t.b,e),this},copyLinearToGamma:function(t,e){void 0===e&&(e=2);var i=e>0?1/e:1;return this.r=Math.pow(t.r,i),this.g=Math.pow(t.g,i),this.b=Math.pow(t.b,i),this},convertGammaToLinear:function(){var t=this.r,e=this.g,i=this.b;return this.r=t*t,this.g=e*e,this.b=i*i,this},convertLinearToGamma:function(){return this.r=Math.sqrt(this.r),this.g=Math.sqrt(this.g),this.b=Math.sqrt(this.b),this},getHex:function(){return 255*this.r<<16^255*this.g<<8^255*this.b<<0},getHexString:function(){return("000000"+this.getHex().toString(16)).slice(-6)},getHSL:function(t){var e,i,r=t||{h:0,s:0,l:0},n=this.r,o=this.g,a=this.b,s=Math.max(n,o,a),c=Math.min(n,o,a),u=(c+s)/2;if(c===s)e=0,i=0;else{var h=s-c;switch(i=u<=.5?h/(s+c):h/(2-s-c),s){case n:e=(o-a)/h+(o<a?6:0);break;case o:e=(a-n)/h+2;break;case a:e=(n-o)/h+4}e/=6}return r.h=e,r.s=i,r.l=u,r},getStyle:function(){return"rgb("+(255*this.r|0)+","+(255*this.g|0)+","+(255*this.b|0)+")"},offsetHSL:function(t,e,i){var r=this.getHSL();return r.h+=t,r.s+=e,r.l+=i,this.setHSL(r.h,r.s,r.l),this},add:function(t){return this.r+=t.r,this.g+=t.g,this.b+=t.b,this},addColors:function(t,e){return this.r=t.r+e.r,this.g=t.g+e.g,this.b=t.b+e.b,this},addScalar:function(t){return this.r+=t,this.g+=t,this.b+=t,this},sub:function(t){return this.r=Math.max(0,this.r-t.r),this.g=Math.max(0,this.g-t.g),this.b=Math.max(0,this.b-t.b),this},multiply:function(t){return this.r*=t.r,this.g*=t.g,this.b*=t.b,this},multiplyScalar:function(t){return this.r*=t,this.g*=t,this.b*=t,this},lerp:function(t,e){return this.r+=(t.r-this.r)*e,this.g+=(t.g-this.g)*e,this.b+=(t.b-this.b)*e,this},equals:function(t){return t.r===this.r&&t.g===this.g&&t.b===this.b},fromArray:function(t,e){return void 0===e&&(e=0),this.r=t[e],this.g=t[e+1],this.b=t[e+2],this},toArray:function(t,e){return void 0===t&&(t=[]),void 0===e&&(e=0),t[e]=this.r,t[e+1]=this.g,t[e+2]=this.b,t},toJSON:function(){return this.getHex()}});var Vi,Hi,$i={common:{diffuse:{value:new Gi(15658734)},opacity:{value:1},map:{value:null},uvTransform:{value:new We},alphaMap:{value:null}},specularmap:{specularMap:{value:null}},envmap:{envMap:{value:null},flipEnvMap:{value:-1},reflectivity:{value:1},refractionRatio:{value:.98}},aomap:{aoMap:{value:null},aoMapIntensity:{value:1}},lightmap:{lightMap:{value:null},lightMapIntensity:{value:1}},emissivemap:{emissiveMap:{value:null}},bumpmap:{bumpMap:{value:null},bumpScale:{value:1}},normalmap:{normalMap:{value:null},normalScale:{value:new Ge(1,1)}},displacementmap:{displacementMap:{value:null},displacementScale:{value:1},displacementBias:{value:0}},roughnessmap:{roughnessMap:{value:null}},metalnessmap:{metalnessMap:{value:null}},gradientmap:{gradientMap:{value:null}},fog:{fogDensity:{value:25e-5},fogNear:{value:1},fogFar:{value:2e3},fogColor:{value:new Gi(16777215)}},lights:{ambientLightColor:{value:[]},directionalLights:{value:[],properties:{direction:{},color:{},shadow:{},shadowBias:{},shadowRadius:{},shadowMapSize:{}}},directionalShadowMap:{value:[]},directionalShadowMatrix:{value:[]},spotLights:{value:[],properties:{color:{},position:{},direction:{},distance:{},coneCos:{},penumbraCos:{},decay:{},shadow:{},shadowBias:{},shadowRadius:{},shadowMapSize:{}}},spotShadowMap:{value:[]},spotShadowMatrix:{value:[]},pointLights:{value:[],properties:{color:{},position:{},decay:{},distance:{},shadow:{},shadowBias:{},shadowRadius:{},shadowMapSize:{},shadowCameraNear:{},shadowCameraFar:{}}},pointShadowMap:{value:[]},pointShadowMatrix:{value:[]},hemisphereLights:{value:[],properties:{direction:{},skyColor:{},groundColor:{}}},rectAreaLights:{value:[],properties:{color:{},position:{},width:{},height:{}}}},points:{diffuse:{value:new Gi(15658734)},opacity:{value:1},size:{value:1},scale:{value:1},map:{value:null},uvTransform:{value:new We}}},Wi={merge:function(t){for(var e={},i=0;i<t.length;i++){var r=this.clone(t[i]);for(var n in r)e[n]=r[n]}return e},clone:function(t){var e={};for(var i in t)for(var r in e[i]={},t[i]){var n=t[i][r];n&&(n.isColor||n.isMatrix3||n.isMatrix4||n.isVector2||n.isVector3||n.isVector4||n.isTexture)?e[i][r]=n.clone():Array.isArray(n)?e[i][r]=n.slice():e[i][r]=n}return e}},Xi={alphamap_fragment:"#ifdef USE_ALPHAMAP\n\tdiffuseColor.a *= texture2D( alphaMap, vUv ).g;\n#endif\n",alphamap_pars_fragment:"#ifdef USE_ALPHAMAP\n\tuniform sampler2D alphaMap;\n#endif\n",alphatest_fragment:"#ifdef ALPHATEST\n\tif ( diffuseColor.a < ALPHATEST ) discard;\n#endif\n",aomap_fragment:"#ifdef USE_AOMAP\n\tfloat ambientOcclusion = ( texture2D( aoMap, vUv2 ).r - 1.0 ) * aoMapIntensity + 1.0;\n\treflectedLight.indirectDiffuse *= ambientOcclusion;\n\t#if defined( USE_ENVMAP ) && defined( PHYSICAL )\n\t\tfloat dotNV = saturate( dot( geometry.normal, geometry.viewDir ) );\n\t\treflectedLight.indirectSpecular *= computeSpecularOcclusion( dotNV, ambientOcclusion, material.specularRoughness );\n\t#endif\n#endif\n",aomap_pars_fragment:"#ifdef USE_AOMAP\n\tuniform sampler2D aoMap;\n\tuniform float aoMapIntensity;\n#endif",begin_vertex:"\nvec3 transformed = vec3( position );\n",beginnormal_vertex:"\nvec3 objectNormal = vec3( normal );\n",bsdfs:"float punctualLightIntensityToIrradianceFactor( const in float lightDistance, const in float cutoffDistance, const in float decayExponent ) {\n\tif( decayExponent > 0.0 ) {\n#if defined ( PHYSICALLY_CORRECT_LIGHTS )\n\t\tfloat distanceFalloff = 1.0 / max( pow( lightDistance, decayExponent ), 0.01 );\n\t\tfloat maxDistanceCutoffFactor = pow2( saturate( 1.0 - pow4( lightDistance / cutoffDistance ) ) );\n\t\treturn distanceFalloff * maxDistanceCutoffFactor;\n#else\n\t\treturn pow( saturate( -lightDistance / cutoffDistance + 1.0 ), decayExponent );\n#endif\n\t}\n\treturn 1.0;\n}\nvec3 BRDF_Diffuse_Lambert( const in vec3 diffuseColor ) {\n\treturn RECIPROCAL_PI * diffuseColor;\n}\nvec3 F_Schlick( const in vec3 specularColor, const in float dotLH ) {\n\tfloat fresnel = exp2( ( -5.55473 * dotLH - 6.98316 ) * dotLH );\n\treturn ( 1.0 - specularColor ) * fresnel + specularColor;\n}\nfloat G_GGX_Smith( const in float alpha, const in float dotNL, const in float dotNV ) {\n\tfloat a2 = pow2( alpha );\n\tfloat gl = dotNL + sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNL ) );\n\tfloat gv = dotNV + sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNV ) );\n\treturn 1.0 / ( gl * gv );\n}\nfloat G_GGX_SmithCorrelated( const in float alpha, const in float dotNL, const in float dotNV ) {\n\tfloat a2 = pow2( alpha );\n\tfloat gv = dotNL * sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNV ) );\n\tfloat gl = dotNV * sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNL ) );\n\treturn 0.5 / max( gv + gl, EPSILON );\n}\nfloat D_GGX( const in float alpha, const in float dotNH ) {\n\tfloat a2 = pow2( alpha );\n\tfloat denom = pow2( dotNH ) * ( a2 - 1.0 ) + 1.0;\n\treturn RECIPROCAL_PI * a2 / pow2( denom );\n}\nvec3 BRDF_Specular_GGX( const in IncidentLight incidentLight, const in GeometricContext geometry, const in vec3 specularColor, const in float roughness ) {\n\tfloat alpha = pow2( roughness );\n\tvec3 halfDir = normalize( incidentLight.direction + geometry.viewDir );\n\tfloat dotNL = saturate( dot( geometry.normal, incidentLight.direction ) );\n\tfloat dotNV = saturate( dot( geometry.normal, geometry.viewDir ) );\n\tfloat dotNH = saturate( dot( geometry.normal, halfDir ) );\n\tfloat dotLH = saturate( dot( incidentLight.direction, halfDir ) );\n\tvec3 F = F_Schlick( specularColor, dotLH );\n\tfloat G = G_GGX_SmithCorrelated( alpha, dotNL, dotNV );\n\tfloat D = D_GGX( alpha, dotNH );\n\treturn F * ( G * D );\n}\nvec2 LTC_Uv( const in vec3 N, const in vec3 V, const in float roughness ) {\n\tconst float LUT_SIZE  = 64.0;\n\tconst float LUT_SCALE = ( LUT_SIZE - 1.0 ) / LUT_SIZE;\n\tconst float LUT_BIAS  = 0.5 / LUT_SIZE;\n\tfloat theta = acos( dot( N, V ) );\n\tvec2 uv = vec2(\n\t\tsqrt( saturate( roughness ) ),\n\t\tsaturate( theta / ( 0.5 * PI ) ) );\n\tuv = uv * LUT_SCALE + LUT_BIAS;\n\treturn uv;\n}\nfloat LTC_ClippedSphereFormFactor( const in vec3 f ) {\n\tfloat l = length( f );\n\treturn max( ( l * l + f.z ) / ( l + 1.0 ), 0.0 );\n}\nvec3 LTC_EdgeVectorFormFactor( const in vec3 v1, const in vec3 v2 ) {\n\tfloat x = dot( v1, v2 );\n\tfloat y = abs( x );\n\tfloat a = 0.86267 + (0.49788 + 0.01436 * y ) * y;\n\tfloat b = 3.45068 + (4.18814 + y) * y;\n\tfloat v = a / b;\n\tfloat theta_sintheta = (x > 0.0) ? v : 0.5 * inversesqrt( 1.0 - x * x ) - v;\n\treturn cross( v1, v2 ) * theta_sintheta;\n}\nvec3 LTC_Evaluate( const in vec3 N, const in vec3 V, const in vec3 P, const in mat3 mInv, const in vec3 rectCoords[ 4 ] ) {\n\tvec3 v1 = rectCoords[ 1 ] - rectCoords[ 0 ];\n\tvec3 v2 = rectCoords[ 3 ] - rectCoords[ 0 ];\n\tvec3 lightNormal = cross( v1, v2 );\n\tif( dot( lightNormal, P - rectCoords[ 0 ] ) < 0.0 ) return vec3( 0.0 );\n\tvec3 T1, T2;\n\tT1 = normalize( V - N * dot( V, N ) );\n\tT2 = - cross( N, T1 );\n\tmat3 mat = mInv * transposeMat3( mat3( T1, T2, N ) );\n\tvec3 coords[ 4 ];\n\tcoords[ 0 ] = mat * ( rectCoords[ 0 ] - P );\n\tcoords[ 1 ] = mat * ( rectCoords[ 1 ] - P );\n\tcoords[ 2 ] = mat * ( rectCoords[ 2 ] - P );\n\tcoords[ 3 ] = mat * ( rectCoords[ 3 ] - P );\n\tcoords[ 0 ] = normalize( coords[ 0 ] );\n\tcoords[ 1 ] = normalize( coords[ 1 ] );\n\tcoords[ 2 ] = normalize( coords[ 2 ] );\n\tcoords[ 3 ] = normalize( coords[ 3 ] );\n\tvec3 vectorFormFactor = vec3( 0.0 );\n\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 0 ], coords[ 1 ] );\n\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 1 ], coords[ 2 ] );\n\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 2 ], coords[ 3 ] );\n\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 3 ], coords[ 0 ] );\n\tvec3 result = vec3( LTC_ClippedSphereFormFactor( vectorFormFactor ) );\n\treturn result;\n}\nvec3 BRDF_Specular_GGX_Environment( const in GeometricContext geometry, const in vec3 specularColor, const in float roughness ) {\n\tfloat dotNV = saturate( dot( geometry.normal, geometry.viewDir ) );\n\tconst vec4 c0 = vec4( - 1, - 0.0275, - 0.572, 0.022 );\n\tconst vec4 c1 = vec4( 1, 0.0425, 1.04, - 0.04 );\n\tvec4 r = roughness * c0 + c1;\n\tfloat a004 = min( r.x * r.x, exp2( - 9.28 * dotNV ) ) * r.x + r.y;\n\tvec2 AB = vec2( -1.04, 1.04 ) * a004 + r.zw;\n\treturn specularColor * AB.x + AB.y;\n}\nfloat G_BlinnPhong_Implicit( ) {\n\treturn 0.25;\n}\nfloat D_BlinnPhong( const in float shininess, const in float dotNH ) {\n\treturn RECIPROCAL_PI * ( shininess * 0.5 + 1.0 ) * pow( dotNH, shininess );\n}\nvec3 BRDF_Specular_BlinnPhong( const in IncidentLight incidentLight, const in GeometricContext geometry, const in vec3 specularColor, const in float shininess ) {\n\tvec3 halfDir = normalize( incidentLight.direction + geometry.viewDir );\n\tfloat dotNH = saturate( dot( geometry.normal, halfDir ) );\n\tfloat dotLH = saturate( dot( incidentLight.direction, halfDir ) );\n\tvec3 F = F_Schlick( specularColor, dotLH );\n\tfloat G = G_BlinnPhong_Implicit( );\n\tfloat D = D_BlinnPhong( shininess, dotNH );\n\treturn F * ( G * D );\n}\nfloat GGXRoughnessToBlinnExponent( const in float ggxRoughness ) {\n\treturn ( 2.0 / pow2( ggxRoughness + 0.0001 ) - 2.0 );\n}\nfloat BlinnExponentToGGXRoughness( const in float blinnExponent ) {\n\treturn sqrt( 2.0 / ( blinnExponent + 2.0 ) );\n}\n",bumpmap_pars_fragment:"#ifdef USE_BUMPMAP\n\tuniform sampler2D bumpMap;\n\tuniform float bumpScale;\n\tvec2 dHdxy_fwd() {\n\t\tvec2 dSTdx = dFdx( vUv );\n\t\tvec2 dSTdy = dFdy( vUv );\n\t\tfloat Hll = bumpScale * texture2D( bumpMap, vUv ).x;\n\t\tfloat dBx = bumpScale * texture2D( bumpMap, vUv + dSTdx ).x - Hll;\n\t\tfloat dBy = bumpScale * texture2D( bumpMap, vUv + dSTdy ).x - Hll;\n\t\treturn vec2( dBx, dBy );\n\t}\n\tvec3 perturbNormalArb( vec3 surf_pos, vec3 surf_norm, vec2 dHdxy ) {\n\t\tvec3 vSigmaX = vec3( dFdx( surf_pos.x ), dFdx( surf_pos.y ), dFdx( surf_pos.z ) );\n\t\tvec3 vSigmaY = vec3( dFdy( surf_pos.x ), dFdy( surf_pos.y ), dFdy( surf_pos.z ) );\n\t\tvec3 vN = surf_norm;\n\t\tvec3 R1 = cross( vSigmaY, vN );\n\t\tvec3 R2 = cross( vN, vSigmaX );\n\t\tfloat fDet = dot( vSigmaX, R1 );\n\t\tvec3 vGrad = sign( fDet ) * ( dHdxy.x * R1 + dHdxy.y * R2 );\n\t\treturn normalize( abs( fDet ) * surf_norm - vGrad );\n\t}\n#endif\n",clipping_planes_fragment:"#if NUM_CLIPPING_PLANES > 0\n\tfor ( int i = 0; i < UNION_CLIPPING_PLANES; ++ i ) {\n\t\tvec4 plane = clippingPlanes[ i ];\n\t\tif ( dot( vViewPosition, plane.xyz ) > plane.w ) discard;\n\t}\n\t\t\n\t#if UNION_CLIPPING_PLANES < NUM_CLIPPING_PLANES\n\t\tbool clipped = true;\n\t\tfor ( int i = UNION_CLIPPING_PLANES; i < NUM_CLIPPING_PLANES; ++ i ) {\n\t\t\tvec4 plane = clippingPlanes[ i ];\n\t\t\tclipped = ( dot( vViewPosition, plane.xyz ) > plane.w ) && clipped;\n\t\t}\n\t\tif ( clipped ) discard;\n\t\n\t#endif\n#endif\n",clipping_planes_pars_fragment:"#if NUM_CLIPPING_PLANES > 0\n\t#if ! defined( PHYSICAL ) && ! defined( PHONG )\n\t\tvarying vec3 vViewPosition;\n\t#endif\n\tuniform vec4 clippingPlanes[ NUM_CLIPPING_PLANES ];\n#endif\n",clipping_planes_pars_vertex:"#if NUM_CLIPPING_PLANES > 0 && ! defined( PHYSICAL ) && ! defined( PHONG )\n\tvarying vec3 vViewPosition;\n#endif\n",clipping_planes_vertex:"#if NUM_CLIPPING_PLANES > 0 && ! defined( PHYSICAL ) && ! defined( PHONG )\n\tvViewPosition = - mvPosition.xyz;\n#endif\n",color_fragment:"#ifdef USE_COLOR\n\tdiffuseColor.rgb *= vColor;\n#endif",color_pars_fragment:"#ifdef USE_COLOR\n\tvarying vec3 vColor;\n#endif\n",color_pars_vertex:"#ifdef USE_COLOR\n\tvarying vec3 vColor;\n#endif",color_vertex:"#ifdef USE_COLOR\n\tvColor.xyz = color.xyz;\n#endif",common:"#define PI 3.14159265359\n#define PI2 6.28318530718\n#define PI_HALF 1.5707963267949\n#define RECIPROCAL_PI 0.31830988618\n#define RECIPROCAL_PI2 0.15915494\n#define LOG2 1.442695\n#define EPSILON 1e-6\n#define saturate(a) clamp( a, 0.0, 1.0 )\n#define whiteCompliment(a) ( 1.0 - saturate( a ) )\nfloat pow2( const in float x ) { return x*x; }\nfloat pow3( const in float x ) { return x*x*x; }\nfloat pow4( const in float x ) { float x2 = x*x; return x2*x2; }\nfloat average( const in vec3 color ) { return dot( color, vec3( 0.3333 ) ); }\nhighp float rand( const in vec2 uv ) {\n\tconst highp float a = 12.9898, b = 78.233, c = 43758.5453;\n\thighp float dt = dot( uv.xy, vec2( a,b ) ), sn = mod( dt, PI );\n\treturn fract(sin(sn) * c);\n}\nstruct IncidentLight {\n\tvec3 color;\n\tvec3 direction;\n\tbool visible;\n};\nstruct ReflectedLight {\n\tvec3 directDiffuse;\n\tvec3 directSpecular;\n\tvec3 indirectDiffuse;\n\tvec3 indirectSpecular;\n};\nstruct GeometricContext {\n\tvec3 position;\n\tvec3 normal;\n\tvec3 viewDir;\n};\nvec3 transformDirection( in vec3 dir, in mat4 matrix ) {\n\treturn normalize( ( matrix * vec4( dir, 0.0 ) ).xyz );\n}\nvec3 inverseTransformDirection( in vec3 dir, in mat4 matrix ) {\n\treturn normalize( ( vec4( dir, 0.0 ) * matrix ).xyz );\n}\nvec3 projectOnPlane(in vec3 point, in vec3 pointOnPlane, in vec3 planeNormal ) {\n\tfloat distance = dot( planeNormal, point - pointOnPlane );\n\treturn - distance * planeNormal + point;\n}\nfloat sideOfPlane( in vec3 point, in vec3 pointOnPlane, in vec3 planeNormal ) {\n\treturn sign( dot( point - pointOnPlane, planeNormal ) );\n}\nvec3 linePlaneIntersect( in vec3 pointOnLine, in vec3 lineDirection, in vec3 pointOnPlane, in vec3 planeNormal ) {\n\treturn lineDirection * ( dot( planeNormal, pointOnPlane - pointOnLine ) / dot( planeNormal, lineDirection ) ) + pointOnLine;\n}\nmat3 transposeMat3( const in mat3 m ) {\n\tmat3 tmp;\n\ttmp[ 0 ] = vec3( m[ 0 ].x, m[ 1 ].x, m[ 2 ].x );\n\ttmp[ 1 ] = vec3( m[ 0 ].y, m[ 1 ].y, m[ 2 ].y );\n\ttmp[ 2 ] = vec3( m[ 0 ].z, m[ 1 ].z, m[ 2 ].z );\n\treturn tmp;\n}\nfloat linearToRelativeLuminance( const in vec3 color ) {\n\tvec3 weights = vec3( 0.2126, 0.7152, 0.0722 );\n\treturn dot( weights, color.rgb );\n}\n",cube_uv_reflection_fragment:"#ifdef ENVMAP_TYPE_CUBE_UV\n#define cubeUV_textureSize (1024.0)\nint getFaceFromDirection(vec3 direction) {\n\tvec3 absDirection = abs(direction);\n\tint face = -1;\n\tif( absDirection.x > absDirection.z ) {\n\t\tif(absDirection.x > absDirection.y )\n\t\t\tface = direction.x > 0.0 ? 0 : 3;\n\t\telse\n\t\t\tface = direction.y > 0.0 ? 1 : 4;\n\t}\n\telse {\n\t\tif(absDirection.z > absDirection.y )\n\t\t\tface = direction.z > 0.0 ? 2 : 5;\n\t\telse\n\t\t\tface = direction.y > 0.0 ? 1 : 4;\n\t}\n\treturn face;\n}\n#define cubeUV_maxLods1  (log2(cubeUV_textureSize*0.25) - 1.0)\n#define cubeUV_rangeClamp (exp2((6.0 - 1.0) * 2.0))\nvec2 MipLevelInfo( vec3 vec, float roughnessLevel, float roughness ) {\n\tfloat scale = exp2(cubeUV_maxLods1 - roughnessLevel);\n\tfloat dxRoughness = dFdx(roughness);\n\tfloat dyRoughness = dFdy(roughness);\n\tvec3 dx = dFdx( vec * scale * dxRoughness );\n\tvec3 dy = dFdy( vec * scale * dyRoughness );\n\tfloat d = max( dot( dx, dx ), dot( dy, dy ) );\n\td = clamp(d, 1.0, cubeUV_rangeClamp);\n\tfloat mipLevel = 0.5 * log2(d);\n\treturn vec2(floor(mipLevel), fract(mipLevel));\n}\n#define cubeUV_maxLods2 (log2(cubeUV_textureSize*0.25) - 2.0)\n#define cubeUV_rcpTextureSize (1.0 / cubeUV_textureSize)\nvec2 getCubeUV(vec3 direction, float roughnessLevel, float mipLevel) {\n\tmipLevel = roughnessLevel > cubeUV_maxLods2 - 3.0 ? 0.0 : mipLevel;\n\tfloat a = 16.0 * cubeUV_rcpTextureSize;\n\tvec2 exp2_packed = exp2( vec2( roughnessLevel, mipLevel ) );\n\tvec2 rcp_exp2_packed = vec2( 1.0 ) / exp2_packed;\n\tfloat powScale = exp2_packed.x * exp2_packed.y;\n\tfloat scale = rcp_exp2_packed.x * rcp_exp2_packed.y * 0.25;\n\tfloat mipOffset = 0.75*(1.0 - rcp_exp2_packed.y) * rcp_exp2_packed.x;\n\tbool bRes = mipLevel == 0.0;\n\tscale =  bRes && (scale < a) ? a : scale;\n\tvec3 r;\n\tvec2 offset;\n\tint face = getFaceFromDirection(direction);\n\tfloat rcpPowScale = 1.0 / powScale;\n\tif( face == 0) {\n\t\tr = vec3(direction.x, -direction.z, direction.y);\n\t\toffset = vec2(0.0+mipOffset,0.75 * rcpPowScale);\n\t\toffset.y = bRes && (offset.y < 2.0*a) ? a : offset.y;\n\t}\n\telse if( face == 1) {\n\t\tr = vec3(direction.y, direction.x, direction.z);\n\t\toffset = vec2(scale+mipOffset, 0.75 * rcpPowScale);\n\t\toffset.y = bRes && (offset.y < 2.0*a) ? a : offset.y;\n\t}\n\telse if( face == 2) {\n\t\tr = vec3(direction.z, direction.x, direction.y);\n\t\toffset = vec2(2.0*scale+mipOffset, 0.75 * rcpPowScale);\n\t\toffset.y = bRes && (offset.y < 2.0*a) ? a : offset.y;\n\t}\n\telse if( face == 3) {\n\t\tr = vec3(direction.x, direction.z, direction.y);\n\t\toffset = vec2(0.0+mipOffset,0.5 * rcpPowScale);\n\t\toffset.y = bRes && (offset.y < 2.0*a) ? 0.0 : offset.y;\n\t}\n\telse if( face == 4) {\n\t\tr = vec3(direction.y, direction.x, -direction.z);\n\t\toffset = vec2(scale+mipOffset, 0.5 * rcpPowScale);\n\t\toffset.y = bRes && (offset.y < 2.0*a) ? 0.0 : offset.y;\n\t}\n\telse {\n\t\tr = vec3(direction.z, -direction.x, direction.y);\n\t\toffset = vec2(2.0*scale+mipOffset, 0.5 * rcpPowScale);\n\t\toffset.y = bRes && (offset.y < 2.0*a) ? 0.0 : offset.y;\n\t}\n\tr = normalize(r);\n\tfloat texelOffset = 0.5 * cubeUV_rcpTextureSize;\n\tvec2 s = ( r.yz / abs( r.x ) + vec2( 1.0 ) ) * 0.5;\n\tvec2 base = offset + vec2( texelOffset );\n\treturn base + s * ( scale - 2.0 * texelOffset );\n}\n#define cubeUV_maxLods3 (log2(cubeUV_textureSize*0.25) - 3.0)\nvec4 textureCubeUV(vec3 reflectedDirection, float roughness ) {\n\tfloat roughnessVal = roughness* cubeUV_maxLods3;\n\tfloat r1 = floor(roughnessVal);\n\tfloat r2 = r1 + 1.0;\n\tfloat t = fract(roughnessVal);\n\tvec2 mipInfo = MipLevelInfo(reflectedDirection, r1, roughness);\n\tfloat s = mipInfo.y;\n\tfloat level0 = mipInfo.x;\n\tfloat level1 = level0 + 1.0;\n\tlevel1 = level1 > 5.0 ? 5.0 : level1;\n\tlevel0 += min( floor( s + 0.5 ), 5.0 );\n\tvec2 uv_10 = getCubeUV(reflectedDirection, r1, level0);\n\tvec4 color10 = envMapTexelToLinear(texture2D(envMap, uv_10));\n\tvec2 uv_20 = getCubeUV(reflectedDirection, r2, level0);\n\tvec4 color20 = envMapTexelToLinear(texture2D(envMap, uv_20));\n\tvec4 result = mix(color10, color20, t);\n\treturn vec4(result.rgb, 1.0);\n}\n#endif\n",defaultnormal_vertex:"vec3 transformedNormal = normalMatrix * objectNormal;\n#ifdef FLIP_SIDED\n\ttransformedNormal = - transformedNormal;\n#endif\n",displacementmap_pars_vertex:"#ifdef USE_DISPLACEMENTMAP\n\tuniform sampler2D displacementMap;\n\tuniform float displacementScale;\n\tuniform float displacementBias;\n#endif\n",displacementmap_vertex:"#ifdef USE_DISPLACEMENTMAP\n\ttransformed += normalize( objectNormal ) * ( texture2D( displacementMap, uv ).x * displacementScale + displacementBias );\n#endif\n",emissivemap_fragment:"#ifdef USE_EMISSIVEMAP\n\tvec4 emissiveColor = texture2D( emissiveMap, vUv );\n\temissiveColor.rgb = emissiveMapTexelToLinear( emissiveColor ).rgb;\n\ttotalEmissiveRadiance *= emissiveColor.rgb;\n#endif\n",emissivemap_pars_fragment:"#ifdef USE_EMISSIVEMAP\n\tuniform sampler2D emissiveMap;\n#endif\n",encodings_fragment:"  gl_FragColor = linearToOutputTexel( gl_FragColor );\n",encodings_pars_fragment:"\nvec4 LinearToLinear( in vec4 value ) {\n\treturn value;\n}\nvec4 GammaToLinear( in vec4 value, in float gammaFactor ) {\n\treturn vec4( pow( value.xyz, vec3( gammaFactor ) ), value.w );\n}\nvec4 LinearToGamma( in vec4 value, in float gammaFactor ) {\n\treturn vec4( pow( value.xyz, vec3( 1.0 / gammaFactor ) ), value.w );\n}\nvec4 sRGBToLinear( in vec4 value ) {\n\treturn vec4( mix( pow( value.rgb * 0.9478672986 + vec3( 0.0521327014 ), vec3( 2.4 ) ), value.rgb * 0.0773993808, vec3( lessThanEqual( value.rgb, vec3( 0.04045 ) ) ) ), value.w );\n}\nvec4 LinearTosRGB( in vec4 value ) {\n\treturn vec4( mix( pow( value.rgb, vec3( 0.41666 ) ) * 1.055 - vec3( 0.055 ), value.rgb * 12.92, vec3( lessThanEqual( value.rgb, vec3( 0.0031308 ) ) ) ), value.w );\n}\nvec4 RGBEToLinear( in vec4 value ) {\n\treturn vec4( value.rgb * exp2( value.a * 255.0 - 128.0 ), 1.0 );\n}\nvec4 LinearToRGBE( in vec4 value ) {\n\tfloat maxComponent = max( max( value.r, value.g ), value.b );\n\tfloat fExp = clamp( ceil( log2( maxComponent ) ), -128.0, 127.0 );\n\treturn vec4( value.rgb / exp2( fExp ), ( fExp + 128.0 ) / 255.0 );\n}\nvec4 RGBMToLinear( in vec4 value, in float maxRange ) {\n\treturn vec4( value.xyz * value.w * maxRange, 1.0 );\n}\nvec4 LinearToRGBM( in vec4 value, in float maxRange ) {\n\tfloat maxRGB = max( value.x, max( value.g, value.b ) );\n\tfloat M      = clamp( maxRGB / maxRange, 0.0, 1.0 );\n\tM            = ceil( M * 255.0 ) / 255.0;\n\treturn vec4( value.rgb / ( M * maxRange ), M );\n}\nvec4 RGBDToLinear( in vec4 value, in float maxRange ) {\n\treturn vec4( value.rgb * ( ( maxRange / 255.0 ) / value.a ), 1.0 );\n}\nvec4 LinearToRGBD( in vec4 value, in float maxRange ) {\n\tfloat maxRGB = max( value.x, max( value.g, value.b ) );\n\tfloat D      = max( maxRange / maxRGB, 1.0 );\n\tD            = min( floor( D ) / 255.0, 1.0 );\n\treturn vec4( value.rgb * ( D * ( 255.0 / maxRange ) ), D );\n}\nconst mat3 cLogLuvM = mat3( 0.2209, 0.3390, 0.4184, 0.1138, 0.6780, 0.7319, 0.0102, 0.1130, 0.2969 );\nvec4 LinearToLogLuv( in vec4 value )  {\n\tvec3 Xp_Y_XYZp = value.rgb * cLogLuvM;\n\tXp_Y_XYZp = max(Xp_Y_XYZp, vec3(1e-6, 1e-6, 1e-6));\n\tvec4 vResult;\n\tvResult.xy = Xp_Y_XYZp.xy / Xp_Y_XYZp.z;\n\tfloat Le = 2.0 * log2(Xp_Y_XYZp.y) + 127.0;\n\tvResult.w = fract(Le);\n\tvResult.z = (Le - (floor(vResult.w*255.0))/255.0)/255.0;\n\treturn vResult;\n}\nconst mat3 cLogLuvInverseM = mat3( 6.0014, -2.7008, -1.7996, -1.3320, 3.1029, -5.7721, 0.3008, -1.0882, 5.6268 );\nvec4 LogLuvToLinear( in vec4 value ) {\n\tfloat Le = value.z * 255.0 + value.w;\n\tvec3 Xp_Y_XYZp;\n\tXp_Y_XYZp.y = exp2((Le - 127.0) / 2.0);\n\tXp_Y_XYZp.z = Xp_Y_XYZp.y / value.y;\n\tXp_Y_XYZp.x = value.x * Xp_Y_XYZp.z;\n\tvec3 vRGB = Xp_Y_XYZp.rgb * cLogLuvInverseM;\n\treturn vec4( max(vRGB, 0.0), 1.0 );\n}\n",envmap_fragment:"#ifdef USE_ENVMAP\n\t#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG )\n\t\tvec3 cameraToVertex = normalize( vWorldPosition - cameraPosition );\n\t\tvec3 worldNormal = inverseTransformDirection( normal, viewMatrix );\n\t\t#ifdef ENVMAP_MODE_REFLECTION\n\t\t\tvec3 reflectVec = reflect( cameraToVertex, worldNormal );\n\t\t#else\n\t\t\tvec3 reflectVec = refract( cameraToVertex, worldNormal, refractionRatio );\n\t\t#endif\n\t#else\n\t\tvec3 reflectVec = vReflect;\n\t#endif\n\t#ifdef ENVMAP_TYPE_CUBE\n\t\tvec4 envColor = textureCube( envMap, vec3( flipEnvMap * reflectVec.x, reflectVec.yz ) );\n\t#elif defined( ENVMAP_TYPE_EQUIREC )\n\t\tvec2 sampleUV;\n\t\treflectVec = normalize( reflectVec );\n\t\tsampleUV.y = asin( clamp( reflectVec.y, - 1.0, 1.0 ) ) * RECIPROCAL_PI + 0.5;\n\t\tsampleUV.x = atan( reflectVec.z, reflectVec.x ) * RECIPROCAL_PI2 + 0.5;\n\t\tvec4 envColor = texture2D( envMap, sampleUV );\n\t#elif defined( ENVMAP_TYPE_SPHERE )\n\t\treflectVec = normalize( reflectVec );\n\t\tvec3 reflectView = normalize( ( viewMatrix * vec4( reflectVec, 0.0 ) ).xyz + vec3( 0.0, 0.0, 1.0 ) );\n\t\tvec4 envColor = texture2D( envMap, reflectView.xy * 0.5 + 0.5 );\n\t#else\n\t\tvec4 envColor = vec4( 0.0 );\n\t#endif\n\tenvColor = envMapTexelToLinear( envColor );\n\t#ifdef ENVMAP_BLENDING_MULTIPLY\n\t\toutgoingLight = mix( outgoingLight, outgoingLight * envColor.xyz, specularStrength * reflectivity );\n\t#elif defined( ENVMAP_BLENDING_MIX )\n\t\toutgoingLight = mix( outgoingLight, envColor.xyz, specularStrength * reflectivity );\n\t#elif defined( ENVMAP_BLENDING_ADD )\n\t\toutgoingLight += envColor.xyz * specularStrength * reflectivity;\n\t#endif\n#endif\n",envmap_pars_fragment:"#if defined( USE_ENVMAP ) || defined( PHYSICAL )\n\tuniform float reflectivity;\n\tuniform float envMapIntensity;\n#endif\n#ifdef USE_ENVMAP\n\t#if ! defined( PHYSICAL ) && ( defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG ) )\n\t\tvarying vec3 vWorldPosition;\n\t#endif\n\t#ifdef ENVMAP_TYPE_CUBE\n\t\tuniform samplerCube envMap;\n\t#else\n\t\tuniform sampler2D envMap;\n\t#endif\n\tuniform float flipEnvMap;\n\t#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG ) || defined( PHYSICAL )\n\t\tuniform float refractionRatio;\n\t#else\n\t\tvarying vec3 vReflect;\n\t#endif\n#endif\n",envmap_pars_vertex:"#ifdef USE_ENVMAP\n\t#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG )\n\t\tvarying vec3 vWorldPosition;\n\t#else\n\t\tvarying vec3 vReflect;\n\t\tuniform float refractionRatio;\n\t#endif\n#endif\n",envmap_vertex:"#ifdef USE_ENVMAP\n\t#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG )\n\t\tvWorldPosition = worldPosition.xyz;\n\t#else\n\t\tvec3 cameraToVertex = normalize( worldPosition.xyz - cameraPosition );\n\t\tvec3 worldNormal = inverseTransformDirection( transformedNormal, viewMatrix );\n\t\t#ifdef ENVMAP_MODE_REFLECTION\n\t\t\tvReflect = reflect( cameraToVertex, worldNormal );\n\t\t#else\n\t\t\tvReflect = refract( cameraToVertex, worldNormal, refractionRatio );\n\t\t#endif\n\t#endif\n#endif\n",fog_vertex:"\n#ifdef USE_FOG\nfogDepth = -mvPosition.z;\n#endif",fog_pars_vertex:"#ifdef USE_FOG\n  varying float fogDepth;\n#endif\n",fog_fragment:"#ifdef USE_FOG\n\t#ifdef FOG_EXP2\n\t\tfloat fogFactor = whiteCompliment( exp2( - fogDensity * fogDensity * fogDepth * fogDepth * LOG2 ) );\n\t#else\n\t\tfloat fogFactor = smoothstep( fogNear, fogFar, fogDepth );\n\t#endif\n\tgl_FragColor.rgb = mix( gl_FragColor.rgb, fogColor, fogFactor );\n#endif\n",fog_pars_fragment:"#ifdef USE_FOG\n\tuniform vec3 fogColor;\n\tvarying float fogDepth;\n\t#ifdef FOG_EXP2\n\t\tuniform float fogDensity;\n\t#else\n\t\tuniform float fogNear;\n\t\tuniform float fogFar;\n\t#endif\n#endif\n",gradientmap_pars_fragment:"#ifdef TOON\n\tuniform sampler2D gradientMap;\n\tvec3 getGradientIrradiance( vec3 normal, vec3 lightDirection ) {\n\t\tfloat dotNL = dot( normal, lightDirection );\n\t\tvec2 coord = vec2( dotNL * 0.5 + 0.5, 0.0 );\n\t\t#ifdef USE_GRADIENTMAP\n\t\t\treturn texture2D( gradientMap, coord ).rgb;\n\t\t#else\n\t\t\treturn ( coord.x < 0.7 ) ? vec3( 0.7 ) : vec3( 1.0 );\n\t\t#endif\n\t}\n#endif\n",lightmap_fragment:"#ifdef USE_LIGHTMAP\n\treflectedLight.indirectDiffuse += PI * texture2D( lightMap, vUv2 ).xyz * lightMapIntensity;\n#endif\n",lightmap_pars_fragment:"#ifdef USE_LIGHTMAP\n\tuniform sampler2D lightMap;\n\tuniform float lightMapIntensity;\n#endif",lights_lambert_vertex:"vec3 diffuse = vec3( 1.0 );\nGeometricContext geometry;\ngeometry.position = mvPosition.xyz;\ngeometry.normal = normalize( transformedNormal );\ngeometry.viewDir = normalize( -mvPosition.xyz );\nGeometricContext backGeometry;\nbackGeometry.position = geometry.position;\nbackGeometry.normal = -geometry.normal;\nbackGeometry.viewDir = geometry.viewDir;\nvLightFront = vec3( 0.0 );\n#ifdef DOUBLE_SIDED\n\tvLightBack = vec3( 0.0 );\n#endif\nIncidentLight directLight;\nfloat dotNL;\nvec3 directLightColor_Diffuse;\n#if NUM_POINT_LIGHTS > 0\n\tfor ( int i = 0; i < NUM_POINT_LIGHTS; i ++ ) {\n\t\tgetPointDirectLightIrradiance( pointLights[ i ], geometry, directLight );\n\t\tdotNL = dot( geometry.normal, directLight.direction );\n\t\tdirectLightColor_Diffuse = PI * directLight.color;\n\t\tvLightFront += saturate( dotNL ) * directLightColor_Diffuse;\n\t\t#ifdef DOUBLE_SIDED\n\t\t\tvLightBack += saturate( -dotNL ) * directLightColor_Diffuse;\n\t\t#endif\n\t}\n#endif\n#if NUM_SPOT_LIGHTS > 0\n\tfor ( int i = 0; i < NUM_SPOT_LIGHTS; i ++ ) {\n\t\tgetSpotDirectLightIrradiance( spotLights[ i ], geometry, directLight );\n\t\tdotNL = dot( geometry.normal, directLight.direction );\n\t\tdirectLightColor_Diffuse = PI * directLight.color;\n\t\tvLightFront += saturate( dotNL ) * directLightColor_Diffuse;\n\t\t#ifdef DOUBLE_SIDED\n\t\t\tvLightBack += saturate( -dotNL ) * directLightColor_Diffuse;\n\t\t#endif\n\t}\n#endif\n#if NUM_DIR_LIGHTS > 0\n\tfor ( int i = 0; i < NUM_DIR_LIGHTS; i ++ ) {\n\t\tgetDirectionalDirectLightIrradiance( directionalLights[ i ], geometry, directLight );\n\t\tdotNL = dot( geometry.normal, directLight.direction );\n\t\tdirectLightColor_Diffuse = PI * directLight.color;\n\t\tvLightFront += saturate( dotNL ) * directLightColor_Diffuse;\n\t\t#ifdef DOUBLE_SIDED\n\t\t\tvLightBack += saturate( -dotNL ) * directLightColor_Diffuse;\n\t\t#endif\n\t}\n#endif\n#if NUM_HEMI_LIGHTS > 0\n\tfor ( int i = 0; i < NUM_HEMI_LIGHTS; i ++ ) {\n\t\tvLightFront += getHemisphereLightIrradiance( hemisphereLights[ i ], geometry );\n\t\t#ifdef DOUBLE_SIDED\n\t\t\tvLightBack += getHemisphereLightIrradiance( hemisphereLights[ i ], backGeometry );\n\t\t#endif\n\t}\n#endif\n",lights_pars:"uniform vec3 ambientLightColor;\nvec3 getAmbientLightIrradiance( const in vec3 ambientLightColor ) {\n\tvec3 irradiance = ambientLightColor;\n\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\tirradiance *= PI;\n\t#endif\n\treturn irradiance;\n}\n#if NUM_DIR_LIGHTS > 0\n\tstruct DirectionalLight {\n\t\tvec3 direction;\n\t\tvec3 color;\n\t\tint shadow;\n\t\tfloat shadowBias;\n\t\tfloat shadowRadius;\n\t\tvec2 shadowMapSize;\n\t};\n\tuniform DirectionalLight directionalLights[ NUM_DIR_LIGHTS ];\n\tvoid getDirectionalDirectLightIrradiance( const in DirectionalLight directionalLight, const in GeometricContext geometry, out IncidentLight directLight ) {\n\t\tdirectLight.color = directionalLight.color;\n\t\tdirectLight.direction = directionalLight.direction;\n\t\tdirectLight.visible = true;\n\t}\n#endif\n#if NUM_POINT_LIGHTS > 0\n\tstruct PointLight {\n\t\tvec3 position;\n\t\tvec3 color;\n\t\tfloat distance;\n\t\tfloat decay;\n\t\tint shadow;\n\t\tfloat shadowBias;\n\t\tfloat shadowRadius;\n\t\tvec2 shadowMapSize;\n\t\tfloat shadowCameraNear;\n\t\tfloat shadowCameraFar;\n\t};\n\tuniform PointLight pointLights[ NUM_POINT_LIGHTS ];\n\tvoid getPointDirectLightIrradiance( const in PointLight pointLight, const in GeometricContext geometry, out IncidentLight directLight ) {\n\t\tvec3 lVector = pointLight.position - geometry.position;\n\t\tdirectLight.direction = normalize( lVector );\n\t\tfloat lightDistance = length( lVector );\n\t\tdirectLight.color = pointLight.color;\n\t\tdirectLight.color *= punctualLightIntensityToIrradianceFactor( lightDistance, pointLight.distance, pointLight.decay );\n\t\tdirectLight.visible = ( directLight.color != vec3( 0.0 ) );\n\t}\n#endif\n#if NUM_SPOT_LIGHTS > 0\n\tstruct SpotLight {\n\t\tvec3 position;\n\t\tvec3 direction;\n\t\tvec3 color;\n\t\tfloat distance;\n\t\tfloat decay;\n\t\tfloat coneCos;\n\t\tfloat penumbraCos;\n\t\tint shadow;\n\t\tfloat shadowBias;\n\t\tfloat shadowRadius;\n\t\tvec2 shadowMapSize;\n\t};\n\tuniform SpotLight spotLights[ NUM_SPOT_LIGHTS ];\n\tvoid getSpotDirectLightIrradiance( const in SpotLight spotLight, const in GeometricContext geometry, out IncidentLight directLight  ) {\n\t\tvec3 lVector = spotLight.position - geometry.position;\n\t\tdirectLight.direction = normalize( lVector );\n\t\tfloat lightDistance = length( lVector );\n\t\tfloat angleCos = dot( directLight.direction, spotLight.direction );\n\t\tif ( angleCos > spotLight.coneCos ) {\n\t\t\tfloat spotEffect = smoothstep( spotLight.coneCos, spotLight.penumbraCos, angleCos );\n\t\t\tdirectLight.color = spotLight.color;\n\t\t\tdirectLight.color *= spotEffect * punctualLightIntensityToIrradianceFactor( lightDistance, spotLight.distance, spotLight.decay );\n\t\t\tdirectLight.visible = true;\n\t\t} else {\n\t\t\tdirectLight.color = vec3( 0.0 );\n\t\t\tdirectLight.visible = false;\n\t\t}\n\t}\n#endif\n#if NUM_RECT_AREA_LIGHTS > 0\n\tstruct RectAreaLight {\n\t\tvec3 color;\n\t\tvec3 position;\n\t\tvec3 halfWidth;\n\t\tvec3 halfHeight;\n\t};\n\tuniform sampler2D ltcMat;\tuniform sampler2D ltcMag;\n\tuniform RectAreaLight rectAreaLights[ NUM_RECT_AREA_LIGHTS ];\n#endif\n#if NUM_HEMI_LIGHTS > 0\n\tstruct HemisphereLight {\n\t\tvec3 direction;\n\t\tvec3 skyColor;\n\t\tvec3 groundColor;\n\t};\n\tuniform HemisphereLight hemisphereLights[ NUM_HEMI_LIGHTS ];\n\tvec3 getHemisphereLightIrradiance( const in HemisphereLight hemiLight, const in GeometricContext geometry ) {\n\t\tfloat dotNL = dot( geometry.normal, hemiLight.direction );\n\t\tfloat hemiDiffuseWeight = 0.5 * dotNL + 0.5;\n\t\tvec3 irradiance = mix( hemiLight.groundColor, hemiLight.skyColor, hemiDiffuseWeight );\n\t\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\t\tirradiance *= PI;\n\t\t#endif\n\t\treturn irradiance;\n\t}\n#endif\n#if defined( USE_ENVMAP ) && defined( PHYSICAL )\n\tvec3 getLightProbeIndirectIrradiance( const in GeometricContext geometry, const in int maxMIPLevel ) {\n\t\tvec3 worldNormal = inverseTransformDirection( geometry.normal, viewMatrix );\n\t\t#ifdef ENVMAP_TYPE_CUBE\n\t\t\tvec3 queryVec = vec3( flipEnvMap * worldNormal.x, worldNormal.yz );\n\t\t\t#ifdef TEXTURE_LOD_EXT\n\t\t\t\tvec4 envMapColor = textureCubeLodEXT( envMap, queryVec, float( maxMIPLevel ) );\n\t\t\t#else\n\t\t\t\tvec4 envMapColor = textureCube( envMap, queryVec, float( maxMIPLevel ) );\n\t\t\t#endif\n\t\t\tenvMapColor.rgb = envMapTexelToLinear( envMapColor ).rgb;\n\t\t#elif defined( ENVMAP_TYPE_CUBE_UV )\n\t\t\tvec3 queryVec = vec3( flipEnvMap * worldNormal.x, worldNormal.yz );\n\t\t\tvec4 envMapColor = textureCubeUV( queryVec, 1.0 );\n\t\t#else\n\t\t\tvec4 envMapColor = vec4( 0.0 );\n\t\t#endif\n\t\treturn PI * envMapColor.rgb * envMapIntensity;\n\t}\n\tfloat getSpecularMIPLevel( const in float blinnShininessExponent, const in int maxMIPLevel ) {\n\t\tfloat maxMIPLevelScalar = float( maxMIPLevel );\n\t\tfloat desiredMIPLevel = maxMIPLevelScalar + 0.79248 - 0.5 * log2( pow2( blinnShininessExponent ) + 1.0 );\n\t\treturn clamp( desiredMIPLevel, 0.0, maxMIPLevelScalar );\n\t}\n\tvec3 getLightProbeIndirectRadiance( const in GeometricContext geometry, const in float blinnShininessExponent, const in int maxMIPLevel ) {\n\t\t#ifdef ENVMAP_MODE_REFLECTION\n\t\t\tvec3 reflectVec = reflect( -geometry.viewDir, geometry.normal );\n\t\t#else\n\t\t\tvec3 reflectVec = refract( -geometry.viewDir, geometry.normal, refractionRatio );\n\t\t#endif\n\t\treflectVec = inverseTransformDirection( reflectVec, viewMatrix );\n\t\tfloat specularMIPLevel = getSpecularMIPLevel( blinnShininessExponent, maxMIPLevel );\n\t\t#ifdef ENVMAP_TYPE_CUBE\n\t\t\tvec3 queryReflectVec = vec3( flipEnvMap * reflectVec.x, reflectVec.yz );\n\t\t\t#ifdef TEXTURE_LOD_EXT\n\t\t\t\tvec4 envMapColor = textureCubeLodEXT( envMap, queryReflectVec, specularMIPLevel );\n\t\t\t#else\n\t\t\t\tvec4 envMapColor = textureCube( envMap, queryReflectVec, specularMIPLevel );\n\t\t\t#endif\n\t\t\tenvMapColor.rgb = envMapTexelToLinear( envMapColor ).rgb;\n\t\t#elif defined( ENVMAP_TYPE_CUBE_UV )\n\t\t\tvec3 queryReflectVec = vec3( flipEnvMap * reflectVec.x, reflectVec.yz );\n\t\t\tvec4 envMapColor = textureCubeUV(queryReflectVec, BlinnExponentToGGXRoughness(blinnShininessExponent));\n\t\t#elif defined( ENVMAP_TYPE_EQUIREC )\n\t\t\tvec2 sampleUV;\n\t\t\tsampleUV.y = asin( clamp( reflectVec.y, - 1.0, 1.0 ) ) * RECIPROCAL_PI + 0.5;\n\t\t\tsampleUV.x = atan( reflectVec.z, reflectVec.x ) * RECIPROCAL_PI2 + 0.5;\n\t\t\t#ifdef TEXTURE_LOD_EXT\n\t\t\t\tvec4 envMapColor = texture2DLodEXT( envMap, sampleUV, specularMIPLevel );\n\t\t\t#else\n\t\t\t\tvec4 envMapColor = texture2D( envMap, sampleUV, specularMIPLevel );\n\t\t\t#endif\n\t\t\tenvMapColor.rgb = envMapTexelToLinear( envMapColor ).rgb;\n\t\t#elif defined( ENVMAP_TYPE_SPHERE )\n\t\t\tvec3 reflectView = normalize( ( viewMatrix * vec4( reflectVec, 0.0 ) ).xyz + vec3( 0.0,0.0,1.0 ) );\n\t\t\t#ifdef TEXTURE_LOD_EXT\n\t\t\t\tvec4 envMapColor = texture2DLodEXT( envMap, reflectView.xy * 0.5 + 0.5, specularMIPLevel );\n\t\t\t#else\n\t\t\t\tvec4 envMapColor = texture2D( envMap, reflectView.xy * 0.5 + 0.5, specularMIPLevel );\n\t\t\t#endif\n\t\t\tenvMapColor.rgb = envMapTexelToLinear( envMapColor ).rgb;\n\t\t#endif\n\t\treturn envMapColor.rgb * envMapIntensity;\n\t}\n#endif\n",lights_phong_fragment:"BlinnPhongMaterial material;\nmaterial.diffuseColor = diffuseColor.rgb;\nmaterial.specularColor = specular;\nmaterial.specularShininess = shininess;\nmaterial.specularStrength = specularStrength;\n",lights_phong_pars_fragment:"varying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\nstruct BlinnPhongMaterial {\n\tvec3\tdiffuseColor;\n\tvec3\tspecularColor;\n\tfloat\tspecularShininess;\n\tfloat\tspecularStrength;\n};\nvoid RE_Direct_BlinnPhong( const in IncidentLight directLight, const in GeometricContext geometry, const in BlinnPhongMaterial material, inout ReflectedLight reflectedLight ) {\n\t#ifdef TOON\n\t\tvec3 irradiance = getGradientIrradiance( geometry.normal, directLight.direction ) * directLight.color;\n\t#else\n\t\tfloat dotNL = saturate( dot( geometry.normal, directLight.direction ) );\n\t\tvec3 irradiance = dotNL * directLight.color;\n\t#endif\n\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\tirradiance *= PI;\n\t#endif\n\treflectedLight.directDiffuse += irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\n\treflectedLight.directSpecular += irradiance * BRDF_Specular_BlinnPhong( directLight, geometry, material.specularColor, material.specularShininess ) * material.specularStrength;\n}\nvoid RE_IndirectDiffuse_BlinnPhong( const in vec3 irradiance, const in GeometricContext geometry, const in BlinnPhongMaterial material, inout ReflectedLight reflectedLight ) {\n\treflectedLight.indirectDiffuse += irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\n}\n#define RE_Direct\t\t\t\tRE_Direct_BlinnPhong\n#define RE_IndirectDiffuse\t\tRE_IndirectDiffuse_BlinnPhong\n#define Material_LightProbeLOD( material )\t(0)\n",lights_physical_fragment:"PhysicalMaterial material;\nmaterial.diffuseColor = diffuseColor.rgb * ( 1.0 - metalnessFactor );\nmaterial.specularRoughness = clamp( roughnessFactor, 0.04, 1.0 );\n#ifdef STANDARD\n\tmaterial.specularColor = mix( vec3( DEFAULT_SPECULAR_COEFFICIENT ), diffuseColor.rgb, metalnessFactor );\n#else\n\tmaterial.specularColor = mix( vec3( MAXIMUM_SPECULAR_COEFFICIENT * pow2( reflectivity ) ), diffuseColor.rgb, metalnessFactor );\n\tmaterial.clearCoat = saturate( clearCoat );\tmaterial.clearCoatRoughness = clamp( clearCoatRoughness, 0.04, 1.0 );\n#endif\n",lights_physical_pars_fragment:"struct PhysicalMaterial {\n\tvec3\tdiffuseColor;\n\tfloat\tspecularRoughness;\n\tvec3\tspecularColor;\n\t#ifndef STANDARD\n\t\tfloat clearCoat;\n\t\tfloat clearCoatRoughness;\n\t#endif\n};\n#define MAXIMUM_SPECULAR_COEFFICIENT 0.16\n#define DEFAULT_SPECULAR_COEFFICIENT 0.04\nfloat clearCoatDHRApprox( const in float roughness, const in float dotNL ) {\n\treturn DEFAULT_SPECULAR_COEFFICIENT + ( 1.0 - DEFAULT_SPECULAR_COEFFICIENT ) * ( pow( 1.0 - dotNL, 5.0 ) * pow( 1.0 - roughness, 2.0 ) );\n}\n#if NUM_RECT_AREA_LIGHTS > 0\n\tvoid RE_Direct_RectArea_Physical( const in RectAreaLight rectAreaLight, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n\t\tvec3 normal = geometry.normal;\n\t\tvec3 viewDir = geometry.viewDir;\n\t\tvec3 position = geometry.position;\n\t\tvec3 lightPos = rectAreaLight.position;\n\t\tvec3 halfWidth = rectAreaLight.halfWidth;\n\t\tvec3 halfHeight = rectAreaLight.halfHeight;\n\t\tvec3 lightColor = rectAreaLight.color;\n\t\tfloat roughness = material.specularRoughness;\n\t\tvec3 rectCoords[ 4 ];\n\t\trectCoords[ 0 ] = lightPos - halfWidth - halfHeight;\t\trectCoords[ 1 ] = lightPos + halfWidth - halfHeight;\n\t\trectCoords[ 2 ] = lightPos + halfWidth + halfHeight;\n\t\trectCoords[ 3 ] = lightPos - halfWidth + halfHeight;\n\t\tvec2 uv = LTC_Uv( normal, viewDir, roughness );\n\t\tfloat norm = texture2D( ltcMag, uv ).a;\n\t\tvec4 t = texture2D( ltcMat, uv );\n\t\tmat3 mInv = mat3(\n\t\t\tvec3(   1,   0, t.y ),\n\t\t\tvec3(   0, t.z,   0 ),\n\t\t\tvec3( t.w,   0, t.x )\n\t\t);\n\t\treflectedLight.directSpecular += lightColor * material.specularColor * norm * LTC_Evaluate( normal, viewDir, position, mInv, rectCoords );\n\t\treflectedLight.directDiffuse += lightColor * material.diffuseColor * LTC_Evaluate( normal, viewDir, position, mat3( 1 ), rectCoords );\n\t}\n#endif\nvoid RE_Direct_Physical( const in IncidentLight directLight, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n\tfloat dotNL = saturate( dot( geometry.normal, directLight.direction ) );\n\tvec3 irradiance = dotNL * directLight.color;\n\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\tirradiance *= PI;\n\t#endif\n\t#ifndef STANDARD\n\t\tfloat clearCoatDHR = material.clearCoat * clearCoatDHRApprox( material.clearCoatRoughness, dotNL );\n\t#else\n\t\tfloat clearCoatDHR = 0.0;\n\t#endif\n\treflectedLight.directSpecular += ( 1.0 - clearCoatDHR ) * irradiance * BRDF_Specular_GGX( directLight, geometry, material.specularColor, material.specularRoughness );\n\treflectedLight.directDiffuse += ( 1.0 - clearCoatDHR ) * irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\n\t#ifndef STANDARD\n\t\treflectedLight.directSpecular += irradiance * material.clearCoat * BRDF_Specular_GGX( directLight, geometry, vec3( DEFAULT_SPECULAR_COEFFICIENT ), material.clearCoatRoughness );\n\t#endif\n}\nvoid RE_IndirectDiffuse_Physical( const in vec3 irradiance, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n\treflectedLight.indirectDiffuse += irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\n}\nvoid RE_IndirectSpecular_Physical( const in vec3 radiance, const in vec3 clearCoatRadiance, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n\t#ifndef STANDARD\n\t\tfloat dotNV = saturate( dot( geometry.normal, geometry.viewDir ) );\n\t\tfloat dotNL = dotNV;\n\t\tfloat clearCoatDHR = material.clearCoat * clearCoatDHRApprox( material.clearCoatRoughness, dotNL );\n\t#else\n\t\tfloat clearCoatDHR = 0.0;\n\t#endif\n\treflectedLight.indirectSpecular += ( 1.0 - clearCoatDHR ) * radiance * BRDF_Specular_GGX_Environment( geometry, material.specularColor, material.specularRoughness );\n\t#ifndef STANDARD\n\t\treflectedLight.indirectSpecular += clearCoatRadiance * material.clearCoat * BRDF_Specular_GGX_Environment( geometry, vec3( DEFAULT_SPECULAR_COEFFICIENT ), material.clearCoatRoughness );\n\t#endif\n}\n#define RE_Direct\t\t\t\tRE_Direct_Physical\n#define RE_Direct_RectArea\t\tRE_Direct_RectArea_Physical\n#define RE_IndirectDiffuse\t\tRE_IndirectDiffuse_Physical\n#define RE_IndirectSpecular\t\tRE_IndirectSpecular_Physical\n#define Material_BlinnShininessExponent( material )   GGXRoughnessToBlinnExponent( material.specularRoughness )\n#define Material_ClearCoat_BlinnShininessExponent( material )   GGXRoughnessToBlinnExponent( material.clearCoatRoughness )\nfloat computeSpecularOcclusion( const in float dotNV, const in float ambientOcclusion, const in float roughness ) {\n\treturn saturate( pow( dotNV + ambientOcclusion, exp2( - 16.0 * roughness - 1.0 ) ) - 1.0 + ambientOcclusion );\n}\n",lights_template:"\nGeometricContext geometry;\ngeometry.position = - vViewPosition;\ngeometry.normal = normal;\ngeometry.viewDir = normalize( vViewPosition );\nIncidentLight directLight;\n#if ( NUM_POINT_LIGHTS > 0 ) && defined( RE_Direct )\n\tPointLight pointLight;\n\tfor ( int i = 0; i < NUM_POINT_LIGHTS; i ++ ) {\n\t\tpointLight = pointLights[ i ];\n\t\tgetPointDirectLightIrradiance( pointLight, geometry, directLight );\n\t\t#ifdef USE_SHADOWMAP\n\t\tdirectLight.color *= all( bvec2( pointLight.shadow, directLight.visible ) ) ? getPointShadow( pointShadowMap[ i ], pointLight.shadowMapSize, pointLight.shadowBias, pointLight.shadowRadius, vPointShadowCoord[ i ], pointLight.shadowCameraNear, pointLight.shadowCameraFar ) : 1.0;\n\t\t#endif\n\t\tRE_Direct( directLight, geometry, material, reflectedLight );\n\t}\n#endif\n#if ( NUM_SPOT_LIGHTS > 0 ) && defined( RE_Direct )\n\tSpotLight spotLight;\n\tfor ( int i = 0; i < NUM_SPOT_LIGHTS; i ++ ) {\n\t\tspotLight = spotLights[ i ];\n\t\tgetSpotDirectLightIrradiance( spotLight, geometry, directLight );\n\t\t#ifdef USE_SHADOWMAP\n\t\tdirectLight.color *= all( bvec2( spotLight.shadow, directLight.visible ) ) ? getShadow( spotShadowMap[ i ], spotLight.shadowMapSize, spotLight.shadowBias, spotLight.shadowRadius, vSpotShadowCoord[ i ] ) : 1.0;\n\t\t#endif\n\t\tRE_Direct( directLight, geometry, material, reflectedLight );\n\t}\n#endif\n#if ( NUM_DIR_LIGHTS > 0 ) && defined( RE_Direct )\n\tDirectionalLight directionalLight;\n\tfor ( int i = 0; i < NUM_DIR_LIGHTS; i ++ ) {\n\t\tdirectionalLight = directionalLights[ i ];\n\t\tgetDirectionalDirectLightIrradiance( directionalLight, geometry, directLight );\n\t\t#ifdef USE_SHADOWMAP\n\t\tdirectLight.color *= all( bvec2( directionalLight.shadow, directLight.visible ) ) ? getShadow( directionalShadowMap[ i ], directionalLight.shadowMapSize, directionalLight.shadowBias, directionalLight.shadowRadius, vDirectionalShadowCoord[ i ] ) : 1.0;\n\t\t#endif\n\t\tRE_Direct( directLight, geometry, material, reflectedLight );\n\t}\n#endif\n#if ( NUM_RECT_AREA_LIGHTS > 0 ) && defined( RE_Direct_RectArea )\n\tRectAreaLight rectAreaLight;\n\tfor ( int i = 0; i < NUM_RECT_AREA_LIGHTS; i ++ ) {\n\t\trectAreaLight = rectAreaLights[ i ];\n\t\tRE_Direct_RectArea( rectAreaLight, geometry, material, reflectedLight );\n\t}\n#endif\n#if defined( RE_IndirectDiffuse )\n\tvec3 irradiance = getAmbientLightIrradiance( ambientLightColor );\n\t#ifdef USE_LIGHTMAP\n\t\tvec3 lightMapIrradiance = texture2D( lightMap, vUv2 ).xyz * lightMapIntensity;\n\t\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\t\tlightMapIrradiance *= PI;\n\t\t#endif\n\t\tirradiance += lightMapIrradiance;\n\t#endif\n\t#if ( NUM_HEMI_LIGHTS > 0 )\n\t\tfor ( int i = 0; i < NUM_HEMI_LIGHTS; i ++ ) {\n\t\t\tirradiance += getHemisphereLightIrradiance( hemisphereLights[ i ], geometry );\n\t\t}\n\t#endif\n\t#if defined( USE_ENVMAP ) && defined( PHYSICAL ) && defined( ENVMAP_TYPE_CUBE_UV )\n\t\tirradiance += getLightProbeIndirectIrradiance( geometry, 8 );\n\t#endif\n\tRE_IndirectDiffuse( irradiance, geometry, material, reflectedLight );\n#endif\n#if defined( USE_ENVMAP ) && defined( RE_IndirectSpecular )\n\tvec3 radiance = getLightProbeIndirectRadiance( geometry, Material_BlinnShininessExponent( material ), 8 );\n\t#ifndef STANDARD\n\t\tvec3 clearCoatRadiance = getLightProbeIndirectRadiance( geometry, Material_ClearCoat_BlinnShininessExponent( material ), 8 );\n\t#else\n\t\tvec3 clearCoatRadiance = vec3( 0.0 );\n\t#endif\n\tRE_IndirectSpecular( radiance, clearCoatRadiance, geometry, material, reflectedLight );\n#endif\n",logdepthbuf_fragment:"#if defined( USE_LOGDEPTHBUF ) && defined( USE_LOGDEPTHBUF_EXT )\n\tgl_FragDepthEXT = log2( vFragDepth ) * logDepthBufFC * 0.5;\n#endif",logdepthbuf_pars_fragment:"#ifdef USE_LOGDEPTHBUF\n\tuniform float logDepthBufFC;\n\t#ifdef USE_LOGDEPTHBUF_EXT\n\t\tvarying float vFragDepth;\n\t#endif\n#endif\n",logdepthbuf_pars_vertex:"#ifdef USE_LOGDEPTHBUF\n\t#ifdef USE_LOGDEPTHBUF_EXT\n\t\tvarying float vFragDepth;\n\t#endif\n\tuniform float logDepthBufFC;\n#endif",logdepthbuf_vertex:"#ifdef USE_LOGDEPTHBUF\n\t#ifdef USE_LOGDEPTHBUF_EXT\n\t\tvFragDepth = 1.0 + gl_Position.w;\n\t#else\n\t\tgl_Position.z = log2( max( EPSILON, gl_Position.w + 1.0 ) ) * logDepthBufFC - 1.0;\n\t\tgl_Position.z *= gl_Position.w;\n\t#endif\n#endif\n",map_fragment:"#ifdef USE_MAP\n\tvec4 texelColor = texture2D( map, vUv );\n\ttexelColor = mapTexelToLinear( texelColor );\n\tdiffuseColor *= texelColor;\n#endif\n",map_pars_fragment:"#ifdef USE_MAP\n\tuniform sampler2D map;\n#endif\n",map_particle_fragment:"#ifdef USE_MAP\n\tvec2 uv = ( uvTransform * vec3( gl_PointCoord.x, 1.0 - gl_PointCoord.y, 1 ) ).xy;\n\tvec4 mapTexel = texture2D( map, uv );\n\tdiffuseColor *= mapTexelToLinear( mapTexel );\n#endif\n",map_particle_pars_fragment:"#ifdef USE_MAP\n\tuniform mat3 uvTransform;\n\tuniform sampler2D map;\n#endif\n",metalnessmap_fragment:"float metalnessFactor = metalness;\n#ifdef USE_METALNESSMAP\n\tvec4 texelMetalness = texture2D( metalnessMap, vUv );\n\tmetalnessFactor *= texelMetalness.b;\n#endif\n",metalnessmap_pars_fragment:"#ifdef USE_METALNESSMAP\n\tuniform sampler2D metalnessMap;\n#endif",morphnormal_vertex:"#ifdef USE_MORPHNORMALS\n\tobjectNormal += ( morphNormal0 - normal ) * morphTargetInfluences[ 0 ];\n\tobjectNormal += ( morphNormal1 - normal ) * morphTargetInfluences[ 1 ];\n\tobjectNormal += ( morphNormal2 - normal ) * morphTargetInfluences[ 2 ];\n\tobjectNormal += ( morphNormal3 - normal ) * morphTargetInfluences[ 3 ];\n#endif\n",morphtarget_pars_vertex:"#ifdef USE_MORPHTARGETS\n\t#ifndef USE_MORPHNORMALS\n\tuniform float morphTargetInfluences[ 8 ];\n\t#else\n\tuniform float morphTargetInfluences[ 4 ];\n\t#endif\n#endif",morphtarget_vertex:"#ifdef USE_MORPHTARGETS\n\ttransformed += ( morphTarget0 - position ) * morphTargetInfluences[ 0 ];\n\ttransformed += ( morphTarget1 - position ) * morphTargetInfluences[ 1 ];\n\ttransformed += ( morphTarget2 - position ) * morphTargetInfluences[ 2 ];\n\ttransformed += ( morphTarget3 - position ) * morphTargetInfluences[ 3 ];\n\t#ifndef USE_MORPHNORMALS\n\ttransformed += ( morphTarget4 - position ) * morphTargetInfluences[ 4 ];\n\ttransformed += ( morphTarget5 - position ) * morphTargetInfluences[ 5 ];\n\ttransformed += ( morphTarget6 - position ) * morphTargetInfluences[ 6 ];\n\ttransformed += ( morphTarget7 - position ) * morphTargetInfluences[ 7 ];\n\t#endif\n#endif\n",normal_fragment:"#ifdef FLAT_SHADED\n\tvec3 fdx = vec3( dFdx( vViewPosition.x ), dFdx( vViewPosition.y ), dFdx( vViewPosition.z ) );\n\tvec3 fdy = vec3( dFdy( vViewPosition.x ), dFdy( vViewPosition.y ), dFdy( vViewPosition.z ) );\n\tvec3 normal = normalize( cross( fdx, fdy ) );\n#else\n\tvec3 normal = normalize( vNormal );\n\t#ifdef DOUBLE_SIDED\n\t\tnormal = normal * ( float( gl_FrontFacing ) * 2.0 - 1.0 );\n\t#endif\n#endif\n#ifdef USE_NORMALMAP\n\tnormal = perturbNormal2Arb( -vViewPosition, normal );\n#elif defined( USE_BUMPMAP )\n\tnormal = perturbNormalArb( -vViewPosition, normal, dHdxy_fwd() );\n#endif\n",normalmap_pars_fragment:"#ifdef USE_NORMALMAP\n\tuniform sampler2D normalMap;\n\tuniform vec2 normalScale;\n\tvec3 perturbNormal2Arb( vec3 eye_pos, vec3 surf_norm ) {\n\t\tvec3 q0 = vec3( dFdx( eye_pos.x ), dFdx( eye_pos.y ), dFdx( eye_pos.z ) );\n\t\tvec3 q1 = vec3( dFdy( eye_pos.x ), dFdy( eye_pos.y ), dFdy( eye_pos.z ) );\n\t\tvec2 st0 = dFdx( vUv.st );\n\t\tvec2 st1 = dFdy( vUv.st );\n\t\tvec3 S = normalize( q0 * st1.t - q1 * st0.t );\n\t\tvec3 T = normalize( -q0 * st1.s + q1 * st0.s );\n\t\tvec3 N = normalize( surf_norm );\n\t\tvec3 mapN = texture2D( normalMap, vUv ).xyz * 2.0 - 1.0;\n\t\tmapN.xy = normalScale * mapN.xy;\n\t\tmat3 tsn = mat3( S, T, N );\n\t\treturn normalize( tsn * mapN );\n\t}\n#endif\n",packing:"vec3 packNormalToRGB( const in vec3 normal ) {\n\treturn normalize( normal ) * 0.5 + 0.5;\n}\nvec3 unpackRGBToNormal( const in vec3 rgb ) {\n\treturn 2.0 * rgb.xyz - 1.0;\n}\nconst float PackUpscale = 256. / 255.;const float UnpackDownscale = 255. / 256.;\nconst vec3 PackFactors = vec3( 256. * 256. * 256., 256. * 256.,  256. );\nconst vec4 UnpackFactors = UnpackDownscale / vec4( PackFactors, 1. );\nconst float ShiftRight8 = 1. / 256.;\nvec4 packDepthToRGBA( const in float v ) {\n\tvec4 r = vec4( fract( v * PackFactors ), v );\n\tr.yzw -= r.xyz * ShiftRight8;\treturn r * PackUpscale;\n}\nfloat unpackRGBAToDepth( const in vec4 v ) {\n\treturn dot( v, UnpackFactors );\n}\nfloat viewZToOrthographicDepth( const in float viewZ, const in float near, const in float far ) {\n\treturn ( viewZ + near ) / ( near - far );\n}\nfloat orthographicDepthToViewZ( const in float linearClipZ, const in float near, const in float far ) {\n\treturn linearClipZ * ( near - far ) - near;\n}\nfloat viewZToPerspectiveDepth( const in float viewZ, const in float near, const in float far ) {\n\treturn (( near + viewZ ) * far ) / (( far - near ) * viewZ );\n}\nfloat perspectiveDepthToViewZ( const in float invClipZ, const in float near, const in float far ) {\n\treturn ( near * far ) / ( ( far - near ) * invClipZ - far );\n}\n",premultiplied_alpha_fragment:"#ifdef PREMULTIPLIED_ALPHA\n\tgl_FragColor.rgb *= gl_FragColor.a;\n#endif\n",project_vertex:"vec4 mvPosition = modelViewMatrix * vec4( transformed, 1.0 );\ngl_Position = projectionMatrix * mvPosition;\n",dithering_fragment:"#if defined( DITHERING )\n  gl_FragColor.rgb = dithering( gl_FragColor.rgb );\n#endif\n",dithering_pars_fragment:"#if defined( DITHERING )\n\tvec3 dithering( vec3 color ) {\n\t\tfloat grid_position = rand( gl_FragCoord.xy );\n\t\tvec3 dither_shift_RGB = vec3( 0.25 / 255.0, -0.25 / 255.0, 0.25 / 255.0 );\n\t\tdither_shift_RGB = mix( 2.0 * dither_shift_RGB, -2.0 * dither_shift_RGB, grid_position );\n\t\treturn color + dither_shift_RGB;\n\t}\n#endif\n",roughnessmap_fragment:"float roughnessFactor = roughness;\n#ifdef USE_ROUGHNESSMAP\n\tvec4 texelRoughness = texture2D( roughnessMap, vUv );\n\troughnessFactor *= texelRoughness.g;\n#endif\n",roughnessmap_pars_fragment:"#ifdef USE_ROUGHNESSMAP\n\tuniform sampler2D roughnessMap;\n#endif",shadowmap_pars_fragment:"#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHTS > 0\n\t\tuniform sampler2D directionalShadowMap[ NUM_DIR_LIGHTS ];\n\t\tvarying vec4 vDirectionalShadowCoord[ NUM_DIR_LIGHTS ];\n\t#endif\n\t#if NUM_SPOT_LIGHTS > 0\n\t\tuniform sampler2D spotShadowMap[ NUM_SPOT_LIGHTS ];\n\t\tvarying vec4 vSpotShadowCoord[ NUM_SPOT_LIGHTS ];\n\t#endif\n\t#if NUM_POINT_LIGHTS > 0\n\t\tuniform sampler2D pointShadowMap[ NUM_POINT_LIGHTS ];\n\t\tvarying vec4 vPointShadowCoord[ NUM_POINT_LIGHTS ];\n\t#endif\n\tfloat texture2DCompare( sampler2D depths, vec2 uv, float compare ) {\n\t\treturn step( compare, unpackRGBAToDepth( texture2D( depths, uv ) ) );\n\t}\n\tfloat texture2DShadowLerp( sampler2D depths, vec2 size, vec2 uv, float compare ) {\n\t\tconst vec2 offset = vec2( 0.0, 1.0 );\n\t\tvec2 texelSize = vec2( 1.0 ) / size;\n\t\tvec2 centroidUV = floor( uv * size + 0.5 ) / size;\n\t\tfloat lb = texture2DCompare( depths, centroidUV + texelSize * offset.xx, compare );\n\t\tfloat lt = texture2DCompare( depths, centroidUV + texelSize * offset.xy, compare );\n\t\tfloat rb = texture2DCompare( depths, centroidUV + texelSize * offset.yx, compare );\n\t\tfloat rt = texture2DCompare( depths, centroidUV + texelSize * offset.yy, compare );\n\t\tvec2 f = fract( uv * size + 0.5 );\n\t\tfloat a = mix( lb, lt, f.y );\n\t\tfloat b = mix( rb, rt, f.y );\n\t\tfloat c = mix( a, b, f.x );\n\t\treturn c;\n\t}\n\tfloat getShadow( sampler2D shadowMap, vec2 shadowMapSize, float shadowBias, float shadowRadius, vec4 shadowCoord ) {\n\t\tfloat shadow = 1.0;\n\t\tshadowCoord.xyz /= shadowCoord.w;\n\t\tshadowCoord.z += shadowBias;\n\t\tbvec4 inFrustumVec = bvec4 ( shadowCoord.x >= 0.0, shadowCoord.x <= 1.0, shadowCoord.y >= 0.0, shadowCoord.y <= 1.0 );\n\t\tbool inFrustum = all( inFrustumVec );\n\t\tbvec2 frustumTestVec = bvec2( inFrustum, shadowCoord.z <= 1.0 );\n\t\tbool frustumTest = all( frustumTestVec );\n\t\tif ( frustumTest ) {\n\t\t#if defined( SHADOWMAP_TYPE_PCF )\n\t\t\tvec2 texelSize = vec2( 1.0 ) / shadowMapSize;\n\t\t\tfloat dx0 = - texelSize.x * shadowRadius;\n\t\t\tfloat dy0 = - texelSize.y * shadowRadius;\n\t\t\tfloat dx1 = + texelSize.x * shadowRadius;\n\t\t\tfloat dy1 = + texelSize.y * shadowRadius;\n\t\t\tshadow = (\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy, shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, dy1 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy1 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, dy1 ), shadowCoord.z )\n\t\t\t) * ( 1.0 / 9.0 );\n\t\t#elif defined( SHADOWMAP_TYPE_PCF_SOFT )\n\t\t\tvec2 texelSize = vec2( 1.0 ) / shadowMapSize;\n\t\t\tfloat dx0 = - texelSize.x * shadowRadius;\n\t\t\tfloat dy0 = - texelSize.y * shadowRadius;\n\t\t\tfloat dx1 = + texelSize.x * shadowRadius;\n\t\t\tfloat dy1 = + texelSize.y * shadowRadius;\n\t\t\tshadow = (\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx0, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( 0.0, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx1, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx0, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy, shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx1, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx0, dy1 ), shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( 0.0, dy1 ), shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx1, dy1 ), shadowCoord.z )\n\t\t\t) * ( 1.0 / 9.0 );\n\t\t#else\n\t\t\tshadow = texture2DCompare( shadowMap, shadowCoord.xy, shadowCoord.z );\n\t\t#endif\n\t\t}\n\t\treturn shadow;\n\t}\n\tvec2 cubeToUV( vec3 v, float texelSizeY ) {\n\t\tvec3 absV = abs( v );\n\t\tfloat scaleToCube = 1.0 / max( absV.x, max( absV.y, absV.z ) );\n\t\tabsV *= scaleToCube;\n\t\tv *= scaleToCube * ( 1.0 - 2.0 * texelSizeY );\n\t\tvec2 planar = v.xy;\n\t\tfloat almostATexel = 1.5 * texelSizeY;\n\t\tfloat almostOne = 1.0 - almostATexel;\n\t\tif ( absV.z >= almostOne ) {\n\t\t\tif ( v.z > 0.0 )\n\t\t\t\tplanar.x = 4.0 - v.x;\n\t\t} else if ( absV.x >= almostOne ) {\n\t\t\tfloat signX = sign( v.x );\n\t\t\tplanar.x = v.z * signX + 2.0 * signX;\n\t\t} else if ( absV.y >= almostOne ) {\n\t\t\tfloat signY = sign( v.y );\n\t\t\tplanar.x = v.x + 2.0 * signY + 2.0;\n\t\t\tplanar.y = v.z * signY - 2.0;\n\t\t}\n\t\treturn vec2( 0.125, 0.25 ) * planar + vec2( 0.375, 0.75 );\n\t}\n\tfloat getPointShadow( sampler2D shadowMap, vec2 shadowMapSize, float shadowBias, float shadowRadius, vec4 shadowCoord, float shadowCameraNear, float shadowCameraFar ) {\n\t\tvec2 texelSize = vec2( 1.0 ) / ( shadowMapSize * vec2( 4.0, 2.0 ) );\n\t\tvec3 lightToPosition = shadowCoord.xyz;\n\t\tfloat dp = ( length( lightToPosition ) - shadowCameraNear ) / ( shadowCameraFar - shadowCameraNear );\t\tdp += shadowBias;\n\t\tvec3 bd3D = normalize( lightToPosition );\n\t\t#if defined( SHADOWMAP_TYPE_PCF ) || defined( SHADOWMAP_TYPE_PCF_SOFT )\n\t\t\tvec2 offset = vec2( - 1, 1 ) * shadowRadius * texelSize.y;\n\t\t\treturn (\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xyy, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yyy, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xyx, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yyx, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xxy, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yxy, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xxx, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yxx, texelSize.y ), dp )\n\t\t\t) * ( 1.0 / 9.0 );\n\t\t#else\n\t\t\treturn texture2DCompare( shadowMap, cubeToUV( bd3D, texelSize.y ), dp );\n\t\t#endif\n\t}\n#endif\n",shadowmap_pars_vertex:"#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHTS > 0\n\t\tuniform mat4 directionalShadowMatrix[ NUM_DIR_LIGHTS ];\n\t\tvarying vec4 vDirectionalShadowCoord[ NUM_DIR_LIGHTS ];\n\t#endif\n\t#if NUM_SPOT_LIGHTS > 0\n\t\tuniform mat4 spotShadowMatrix[ NUM_SPOT_LIGHTS ];\n\t\tvarying vec4 vSpotShadowCoord[ NUM_SPOT_LIGHTS ];\n\t#endif\n\t#if NUM_POINT_LIGHTS > 0\n\t\tuniform mat4 pointShadowMatrix[ NUM_POINT_LIGHTS ];\n\t\tvarying vec4 vPointShadowCoord[ NUM_POINT_LIGHTS ];\n\t#endif\n#endif\n",shadowmap_vertex:"#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHTS > 0\n\tfor ( int i = 0; i < NUM_DIR_LIGHTS; i ++ ) {\n\t\tvDirectionalShadowCoord[ i ] = directionalShadowMatrix[ i ] * worldPosition;\n\t}\n\t#endif\n\t#if NUM_SPOT_LIGHTS > 0\n\tfor ( int i = 0; i < NUM_SPOT_LIGHTS; i ++ ) {\n\t\tvSpotShadowCoord[ i ] = spotShadowMatrix[ i ] * worldPosition;\n\t}\n\t#endif\n\t#if NUM_POINT_LIGHTS > 0\n\tfor ( int i = 0; i < NUM_POINT_LIGHTS; i ++ ) {\n\t\tvPointShadowCoord[ i ] = pointShadowMatrix[ i ] * worldPosition;\n\t}\n\t#endif\n#endif\n",shadowmask_pars_fragment:"float getShadowMask() {\n\tfloat shadow = 1.0;\n\t#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHTS > 0\n\tDirectionalLight directionalLight;\n\tfor ( int i = 0; i < NUM_DIR_LIGHTS; i ++ ) {\n\t\tdirectionalLight = directionalLights[ i ];\n\t\tshadow *= bool( directionalLight.shadow ) ? getShadow( directionalShadowMap[ i ], directionalLight.shadowMapSize, directionalLight.shadowBias, directionalLight.shadowRadius, vDirectionalShadowCoord[ i ] ) : 1.0;\n\t}\n\t#endif\n\t#if NUM_SPOT_LIGHTS > 0\n\tSpotLight spotLight;\n\tfor ( int i = 0; i < NUM_SPOT_LIGHTS; i ++ ) {\n\t\tspotLight = spotLights[ i ];\n\t\tshadow *= bool( spotLight.shadow ) ? getShadow( spotShadowMap[ i ], spotLight.shadowMapSize, spotLight.shadowBias, spotLight.shadowRadius, vSpotShadowCoord[ i ] ) : 1.0;\n\t}\n\t#endif\n\t#if NUM_POINT_LIGHTS > 0\n\tPointLight pointLight;\n\tfor ( int i = 0; i < NUM_POINT_LIGHTS; i ++ ) {\n\t\tpointLight = pointLights[ i ];\n\t\tshadow *= bool( pointLight.shadow ) ? getPointShadow( pointShadowMap[ i ], pointLight.shadowMapSize, pointLight.shadowBias, pointLight.shadowRadius, vPointShadowCoord[ i ], pointLight.shadowCameraNear, pointLight.shadowCameraFar ) : 1.0;\n\t}\n\t#endif\n\t#endif\n\treturn shadow;\n}\n",skinbase_vertex:"#ifdef USE_SKINNING\n\tmat4 boneMatX = getBoneMatrix( skinIndex.x );\n\tmat4 boneMatY = getBoneMatrix( skinIndex.y );\n\tmat4 boneMatZ = getBoneMatrix( skinIndex.z );\n\tmat4 boneMatW = getBoneMatrix( skinIndex.w );\n#endif",skinning_pars_vertex:"#ifdef USE_SKINNING\n\tuniform mat4 bindMatrix;\n\tuniform mat4 bindMatrixInverse;\n\t#ifdef BONE_TEXTURE\n\t\tuniform sampler2D boneTexture;\n\t\tuniform int boneTextureSize;\n\t\tmat4 getBoneMatrix( const in float i ) {\n\t\t\tfloat j = i * 4.0;\n\t\t\tfloat x = mod( j, float( boneTextureSize ) );\n\t\t\tfloat y = floor( j / float( boneTextureSize ) );\n\t\t\tfloat dx = 1.0 / float( boneTextureSize );\n\t\t\tfloat dy = 1.0 / float( boneTextureSize );\n\t\t\ty = dy * ( y + 0.5 );\n\t\t\tvec4 v1 = texture2D( boneTexture, vec2( dx * ( x + 0.5 ), y ) );\n\t\t\tvec4 v2 = texture2D( boneTexture, vec2( dx * ( x + 1.5 ), y ) );\n\t\t\tvec4 v3 = texture2D( boneTexture, vec2( dx * ( x + 2.5 ), y ) );\n\t\t\tvec4 v4 = texture2D( boneTexture, vec2( dx * ( x + 3.5 ), y ) );\n\t\t\tmat4 bone = mat4( v1, v2, v3, v4 );\n\t\t\treturn bone;\n\t\t}\n\t#else\n\t\tuniform mat4 boneMatrices[ MAX_BONES ];\n\t\tmat4 getBoneMatrix( const in float i ) {\n\t\t\tmat4 bone = boneMatrices[ int(i) ];\n\t\t\treturn bone;\n\t\t}\n\t#endif\n#endif\n",skinning_vertex:"#ifdef USE_SKINNING\n\tvec4 skinVertex = bindMatrix * vec4( transformed, 1.0 );\n\tvec4 skinned = vec4( 0.0 );\n\tskinned += boneMatX * skinVertex * skinWeight.x;\n\tskinned += boneMatY * skinVertex * skinWeight.y;\n\tskinned += boneMatZ * skinVertex * skinWeight.z;\n\tskinned += boneMatW * skinVertex * skinWeight.w;\n\ttransformed = ( bindMatrixInverse * skinned ).xyz;\n#endif\n",skinnormal_vertex:"#ifdef USE_SKINNING\n\tmat4 skinMatrix = mat4( 0.0 );\n\tskinMatrix += skinWeight.x * boneMatX;\n\tskinMatrix += skinWeight.y * boneMatY;\n\tskinMatrix += skinWeight.z * boneMatZ;\n\tskinMatrix += skinWeight.w * boneMatW;\n\tskinMatrix  = bindMatrixInverse * skinMatrix * bindMatrix;\n\tobjectNormal = vec4( skinMatrix * vec4( objectNormal, 0.0 ) ).xyz;\n#endif\n",specularmap_fragment:"float specularStrength;\n#ifdef USE_SPECULARMAP\n\tvec4 texelSpecular = texture2D( specularMap, vUv );\n\tspecularStrength = texelSpecular.r;\n#else\n\tspecularStrength = 1.0;\n#endif",specularmap_pars_fragment:"#ifdef USE_SPECULARMAP\n\tuniform sampler2D specularMap;\n#endif",tonemapping_fragment:"#if defined( TONE_MAPPING )\n  gl_FragColor.rgb = toneMapping( gl_FragColor.rgb );\n#endif\n",tonemapping_pars_fragment:"#ifndef saturate\n\t#define saturate(a) clamp( a, 0.0, 1.0 )\n#endif\nuniform float toneMappingExposure;\nuniform float toneMappingWhitePoint;\nvec3 LinearToneMapping( vec3 color ) {\n\treturn toneMappingExposure * color;\n}\nvec3 ReinhardToneMapping( vec3 color ) {\n\tcolor *= toneMappingExposure;\n\treturn saturate( color / ( vec3( 1.0 ) + color ) );\n}\n#define Uncharted2Helper( x ) max( ( ( x * ( 0.15 * x + 0.10 * 0.50 ) + 0.20 * 0.02 ) / ( x * ( 0.15 * x + 0.50 ) + 0.20 * 0.30 ) ) - 0.02 / 0.30, vec3( 0.0 ) )\nvec3 Uncharted2ToneMapping( vec3 color ) {\n\tcolor *= toneMappingExposure;\n\treturn saturate( Uncharted2Helper( color ) / Uncharted2Helper( vec3( toneMappingWhitePoint ) ) );\n}\nvec3 OptimizedCineonToneMapping( vec3 color ) {\n\tcolor *= toneMappingExposure;\n\tcolor = max( vec3( 0.0 ), color - 0.004 );\n\treturn pow( ( color * ( 6.2 * color + 0.5 ) ) / ( color * ( 6.2 * color + 1.7 ) + 0.06 ), vec3( 2.2 ) );\n}\n",uv_pars_fragment:"#if defined( USE_MAP ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( USE_SPECULARMAP ) || defined( USE_ALPHAMAP ) || defined( USE_EMISSIVEMAP ) || defined( USE_ROUGHNESSMAP ) || defined( USE_METALNESSMAP )\n\tvarying vec2 vUv;\n#endif",uv_pars_vertex:"#if defined( USE_MAP ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( USE_SPECULARMAP ) || defined( USE_ALPHAMAP ) || defined( USE_EMISSIVEMAP ) || defined( USE_ROUGHNESSMAP ) || defined( USE_METALNESSMAP )\n\tvarying vec2 vUv;\n\tuniform mat3 uvTransform;\n#endif\n",uv_vertex:"#if defined( USE_MAP ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( USE_SPECULARMAP ) || defined( USE_ALPHAMAP ) || defined( USE_EMISSIVEMAP ) || defined( USE_ROUGHNESSMAP ) || defined( USE_METALNESSMAP )\n\tvUv = ( uvTransform * vec3( uv, 1 ) ).xy;\n#endif",uv2_pars_fragment:"#if defined( USE_LIGHTMAP ) || defined( USE_AOMAP )\n\tvarying vec2 vUv2;\n#endif",uv2_pars_vertex:"#if defined( USE_LIGHTMAP ) || defined( USE_AOMAP )\n\tattribute vec2 uv2;\n\tvarying vec2 vUv2;\n#endif",uv2_vertex:"#if defined( USE_LIGHTMAP ) || defined( USE_AOMAP )\n\tvUv2 = uv2;\n#endif",worldpos_vertex:"#if defined( USE_ENVMAP ) || defined( DISTANCE ) || defined ( USE_SHADOWMAP )\n\tvec4 worldPosition = modelMatrix * vec4( transformed, 1.0 );\n#endif\n",cube_frag:"uniform samplerCube tCube;\nuniform float tFlip;\nuniform float opacity;\nvarying vec3 vWorldPosition;\nvoid main() {\n\tgl_FragColor = textureCube( tCube, vec3( tFlip * vWorldPosition.x, vWorldPosition.yz ) );\n\tgl_FragColor.a *= opacity;\n}\n",cube_vert:"varying vec3 vWorldPosition;\n#include <common>\nvoid main() {\n\tvWorldPosition = transformDirection( position, modelMatrix );\n\t#include <begin_vertex>\n\t#include <project_vertex>\n\tgl_Position.z = gl_Position.w;\n}\n",depth_frag:"#if DEPTH_PACKING == 3200\n\tuniform float opacity;\n#endif\n#include <common>\n#include <packing>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( 1.0 );\n\t#if DEPTH_PACKING == 3200\n\t\tdiffuseColor.a = opacity;\n\t#endif\n\t#include <map_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <logdepthbuf_fragment>\n\t#if DEPTH_PACKING == 3200\n\t\tgl_FragColor = vec4( vec3( gl_FragCoord.z ), opacity );\n\t#elif DEPTH_PACKING == 3201\n\t\tgl_FragColor = packDepthToRGBA( gl_FragCoord.z );\n\t#endif\n}\n",depth_vert:"#include <common>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <skinbase_vertex>\n\t#ifdef USE_DISPLACEMENTMAP\n\t\t#include <beginnormal_vertex>\n\t\t#include <morphnormal_vertex>\n\t\t#include <skinnormal_vertex>\n\t#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n}\n",distanceRGBA_frag:"#define DISTANCE\nuniform vec3 referencePosition;\nuniform float nearDistance;\nuniform float farDistance;\nvarying vec3 vWorldPosition;\n#include <common>\n#include <packing>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main () {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( 1.0 );\n\t#include <map_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\tfloat dist = length( vWorldPosition - referencePosition );\n\tdist = ( dist - nearDistance ) / ( farDistance - nearDistance );\n\tdist = saturate( dist );\n\tgl_FragColor = packDepthToRGBA( dist );\n}\n",distanceRGBA_vert:"#define DISTANCE\nvarying vec3 vWorldPosition;\n#include <common>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <skinbase_vertex>\n\t#ifdef USE_DISPLACEMENTMAP\n\t\t#include <beginnormal_vertex>\n\t\t#include <morphnormal_vertex>\n\t\t#include <skinnormal_vertex>\n\t#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <worldpos_vertex>\n\t#include <clipping_planes_vertex>\n\tvWorldPosition = worldPosition.xyz;\n}\n",equirect_frag:"uniform sampler2D tEquirect;\nvarying vec3 vWorldPosition;\n#include <common>\nvoid main() {\n\tvec3 direction = normalize( vWorldPosition );\n\tvec2 sampleUV;\n\tsampleUV.y = asin( clamp( direction.y, - 1.0, 1.0 ) ) * RECIPROCAL_PI + 0.5;\n\tsampleUV.x = atan( direction.z, direction.x ) * RECIPROCAL_PI2 + 0.5;\n\tgl_FragColor = texture2D( tEquirect, sampleUV );\n}\n",equirect_vert:"varying vec3 vWorldPosition;\n#include <common>\nvoid main() {\n\tvWorldPosition = transformDirection( position, modelMatrix );\n\t#include <begin_vertex>\n\t#include <project_vertex>\n}\n",linedashed_frag:"uniform vec3 diffuse;\nuniform float opacity;\nuniform float dashSize;\nuniform float totalSize;\nvarying float vLineDistance;\n#include <common>\n#include <color_pars_fragment>\n#include <fog_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tif ( mod( vLineDistance, totalSize ) > dashSize ) {\n\t\tdiscard;\n\t}\n\tvec3 outgoingLight = vec3( 0.0 );\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <logdepthbuf_fragment>\n\t#include <color_fragment>\n\toutgoingLight = diffuseColor.rgb;\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <premultiplied_alpha_fragment>\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n}\n",linedashed_vert:"uniform float scale;\nattribute float lineDistance;\nvarying float vLineDistance;\n#include <common>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <color_vertex>\n\tvLineDistance = scale * lineDistance;\n\tvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\n\tgl_Position = projectionMatrix * mvPosition;\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <fog_vertex>\n}\n",meshbasic_frag:"uniform vec3 diffuse;\nuniform float opacity;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <common>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <envmap_pars_fragment>\n#include <fog_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <specularmap_fragment>\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\t#ifdef USE_LIGHTMAP\n\t\treflectedLight.indirectDiffuse += texture2D( lightMap, vUv2 ).xyz * lightMapIntensity;\n\t#else\n\t\treflectedLight.indirectDiffuse += vec3( 1.0 );\n\t#endif\n\t#include <aomap_fragment>\n\treflectedLight.indirectDiffuse *= diffuseColor.rgb;\n\tvec3 outgoingLight = reflectedLight.indirectDiffuse;\n\t#include <envmap_fragment>\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <premultiplied_alpha_fragment>\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n}\n",meshbasic_vert:"#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <envmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <uv2_vertex>\n\t#include <color_vertex>\n\t#include <skinbase_vertex>\n\t#ifdef USE_ENVMAP\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <worldpos_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <envmap_vertex>\n\t#include <fog_vertex>\n}\n",meshlambert_frag:"uniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float opacity;\nvarying vec3 vLightFront;\n#ifdef DOUBLE_SIDED\n\tvarying vec3 vLightBack;\n#endif\n#include <common>\n#include <packing>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <envmap_pars_fragment>\n#include <bsdfs>\n#include <lights_pars>\n#include <fog_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <shadowmask_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <specularmap_fragment>\n\t#include <emissivemap_fragment>\n\treflectedLight.indirectDiffuse = getAmbientLightIrradiance( ambientLightColor );\n\t#include <lightmap_fragment>\n\treflectedLight.indirectDiffuse *= BRDF_Diffuse_Lambert( diffuseColor.rgb );\n\t#ifdef DOUBLE_SIDED\n\t\treflectedLight.directDiffuse = ( gl_FrontFacing ) ? vLightFront : vLightBack;\n\t#else\n\t\treflectedLight.directDiffuse = vLightFront;\n\t#endif\n\treflectedLight.directDiffuse *= BRDF_Diffuse_Lambert( diffuseColor.rgb ) * getShadowMask();\n\t#include <aomap_fragment>\n\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + totalEmissiveRadiance;\n\t#include <envmap_fragment>\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}\n",meshlambert_vert:"#define LAMBERT\nvarying vec3 vLightFront;\n#ifdef DOUBLE_SIDED\n\tvarying vec3 vLightBack;\n#endif\n#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <envmap_pars_vertex>\n#include <bsdfs>\n#include <lights_pars>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <uv2_vertex>\n\t#include <color_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <worldpos_vertex>\n\t#include <envmap_vertex>\n\t#include <lights_lambert_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}\n",meshphong_frag:"#define PHONG\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform vec3 specular;\nuniform float shininess;\nuniform float opacity;\n#include <common>\n#include <packing>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <envmap_pars_fragment>\n#include <gradientmap_pars_fragment>\n#include <fog_pars_fragment>\n#include <bsdfs>\n#include <lights_pars>\n#include <lights_phong_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <specularmap_fragment>\n\t#include <normal_fragment>\n\t#include <emissivemap_fragment>\n\t#include <lights_phong_fragment>\n\t#include <lights_template>\n\t#include <aomap_fragment>\n\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveRadiance;\n\t#include <envmap_fragment>\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}\n",meshphong_vert:"#define PHONG\nvarying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <envmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <uv2_vertex>\n\t#include <color_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n#ifndef FLAT_SHADED\n\tvNormal = normalize( transformedNormal );\n#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\tvViewPosition = - mvPosition.xyz;\n\t#include <worldpos_vertex>\n\t#include <envmap_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}\n",meshphysical_frag:"#define PHYSICAL\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float roughness;\nuniform float metalness;\nuniform float opacity;\n#ifndef STANDARD\n\tuniform float clearCoat;\n\tuniform float clearCoatRoughness;\n#endif\nvarying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <common>\n#include <packing>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <envmap_pars_fragment>\n#include <fog_pars_fragment>\n#include <bsdfs>\n#include <cube_uv_reflection_fragment>\n#include <lights_pars>\n#include <lights_physical_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <roughnessmap_pars_fragment>\n#include <metalnessmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <roughnessmap_fragment>\n\t#include <metalnessmap_fragment>\n\t#include <normal_fragment>\n\t#include <emissivemap_fragment>\n\t#include <lights_physical_fragment>\n\t#include <lights_template>\n\t#include <aomap_fragment>\n\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveRadiance;\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}\n",meshphysical_vert:"#define PHYSICAL\nvarying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <uv2_vertex>\n\t#include <color_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n#ifndef FLAT_SHADED\n\tvNormal = normalize( transformedNormal );\n#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\tvViewPosition = - mvPosition.xyz;\n\t#include <worldpos_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}\n",normal_frag:"#define NORMAL\nuniform float opacity;\n#if defined( FLAT_SHADED ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP )\n\tvarying vec3 vViewPosition;\n#endif\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <packing>\n#include <uv_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\nvoid main() {\n\t#include <logdepthbuf_fragment>\n\t#include <normal_fragment>\n\tgl_FragColor = vec4( packNormalToRGB( normal ), opacity );\n}\n",normal_vert:"#define NORMAL\n#if defined( FLAT_SHADED ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP )\n\tvarying vec3 vViewPosition;\n#endif\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n#ifndef FLAT_SHADED\n\tvNormal = normalize( transformedNormal );\n#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n#if defined( FLAT_SHADED ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP )\n\tvViewPosition = - mvPosition.xyz;\n#endif\n}\n",points_frag:"uniform vec3 diffuse;\nuniform float opacity;\n#include <common>\n#include <packing>\n#include <color_pars_fragment>\n#include <map_particle_pars_fragment>\n#include <fog_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec3 outgoingLight = vec3( 0.0 );\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <logdepthbuf_fragment>\n\t#include <map_particle_fragment>\n\t#include <color_fragment>\n\t#include <alphatest_fragment>\n\toutgoingLight = diffuseColor.rgb;\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <premultiplied_alpha_fragment>\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n}\n",points_vert:"uniform float size;\nuniform float scale;\n#include <common>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <color_vertex>\n\t#include <begin_vertex>\n\t#include <project_vertex>\n\t#ifdef USE_SIZEATTENUATION\n\t\tgl_PointSize = size * ( scale / - mvPosition.z );\n\t#else\n\t\tgl_PointSize = size;\n\t#endif\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <worldpos_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}\n",shadow_frag:"uniform vec3 color;\nuniform float opacity;\n#include <common>\n#include <packing>\n#include <fog_pars_fragment>\n#include <bsdfs>\n#include <lights_pars>\n#include <shadowmap_pars_fragment>\n#include <shadowmask_pars_fragment>\nvoid main() {\n\tgl_FragColor = vec4( color, opacity * ( 1.0 - getShadowMask() ) );\n\t#include <fog_fragment>\n}\n",shadow_vert:"#include <fog_pars_vertex>\n#include <shadowmap_pars_vertex>\nvoid main() {\n\t#include <begin_vertex>\n\t#include <project_vertex>\n\t#include <worldpos_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}\n"},qi={basic:{uniforms:Wi.merge([$i.common,$i.specularmap,$i.envmap,$i.aomap,$i.lightmap,$i.fog]),vertexShader:Xi.meshbasic_vert,fragmentShader:Xi.meshbasic_frag},lambert:{uniforms:Wi.merge([$i.common,$i.specularmap,$i.envmap,$i.aomap,$i.lightmap,$i.emissivemap,$i.fog,$i.lights,{emissive:{value:new Gi(0)}}]),vertexShader:Xi.meshlambert_vert,fragmentShader:Xi.meshlambert_frag},phong:{uniforms:Wi.merge([$i.common,$i.specularmap,$i.envmap,$i.aomap,$i.lightmap,$i.emissivemap,$i.bumpmap,$i.normalmap,$i.displacementmap,$i.gradientmap,$i.fog,$i.lights,{emissive:{value:new Gi(0)},specular:{value:new Gi(1118481)},shininess:{value:30}}]),vertexShader:Xi.meshphong_vert,fragmentShader:Xi.meshphong_frag},standard:{uniforms:Wi.merge([$i.common,$i.envmap,$i.aomap,$i.lightmap,$i.emissivemap,$i.bumpmap,$i.normalmap,$i.displacementmap,$i.roughnessmap,$i.metalnessmap,$i.fog,$i.lights,{emissive:{value:new Gi(0)},roughness:{value:.5},metalness:{value:.5},envMapIntensity:{value:1}}]),vertexShader:Xi.meshphysical_vert,fragmentShader:Xi.meshphysical_frag},points:{uniforms:Wi.merge([$i.points,$i.fog]),vertexShader:Xi.points_vert,fragmentShader:Xi.points_frag},dashed:{uniforms:Wi.merge([$i.common,$i.fog,{scale:{value:1},dashSize:{value:1},totalSize:{value:2}}]),vertexShader:Xi.linedashed_vert,fragmentShader:Xi.linedashed_frag},depth:{uniforms:Wi.merge([$i.common,$i.displacementmap]),vertexShader:Xi.depth_vert,fragmentShader:Xi.depth_frag},normal:{uniforms:Wi.merge([$i.common,$i.bumpmap,$i.normalmap,$i.displacementmap,{opacity:{value:1}}]),vertexShader:Xi.normal_vert,fragmentShader:Xi.normal_frag},cube:{uniforms:{tCube:{value:null},tFlip:{value:-1},opacity:{value:1}},vertexShader:Xi.cube_vert,fragmentShader:Xi.cube_frag},equirect:{uniforms:{tEquirect:{value:null}},vertexShader:Xi.equirect_vert,fragmentShader:Xi.equirect_frag},distanceRGBA:{uniforms:Wi.merge([$i.common,$i.displacementmap,{referencePosition:{value:new $e},nearDistance:{value:1},farDistance:{value:1e3}}]),vertexShader:Xi.distanceRGBA_vert,fragmentShader:Xi.distanceRGBA_frag},shadow:{uniforms:Wi.merge([$i.lights,$i.fog,{color:{value:new Gi(0)},opacity:{value:1}}]),vertexShader:Xi.shadow_vert,fragmentShader:Xi.shadow_frag}};function Yi(t,e){this.min=void 0!==t?t:new Ge(1/0,1/0),this.max=void 0!==e?e:new Ge(-1/0,-1/0)}function Zi(t,e,i,r,n){var o,a,s,c,u,h,l,p;function d(){var t,r,d,f,m,g=new Float32Array([-1,-1,0,0,1,-1,1,0,1,1,1,1,-1,1,0,1]),v=new Uint16Array([0,1,2,0,2,3]);o=e.createBuffer(),a=e.createBuffer(),e.bindBuffer(e.ARRAY_BUFFER,o),e.bufferData(e.ARRAY_BUFFER,g,e.STATIC_DRAW),e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,a),e.bufferData(e.ELEMENT_ARRAY_BUFFER,v,e.STATIC_DRAW),l=e.createTexture(),p=e.createTexture(),i.bindTexture(e.TEXTURE_2D,l),e.texImage2D(e.TEXTURE_2D,0,e.RGB,16,16,0,e.RGB,e.UNSIGNED_BYTE,null),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_S,e.CLAMP_TO_EDGE),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_T,e.CLAMP_TO_EDGE),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MAG_FILTER,e.NEAREST),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MIN_FILTER,e.NEAREST),i.bindTexture(e.TEXTURE_2D,p),e.texImage2D(e.TEXTURE_2D,0,e.RGBA,16,16,0,e.RGBA,e.UNSIGNED_BYTE,null),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_S,e.CLAMP_TO_EDGE),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_T,e.CLAMP_TO_EDGE),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MAG_FILTER,e.NEAREST),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MIN_FILTER,e.NEAREST),s={vertexShader:["uniform lowp int renderType;","uniform vec3 screenPosition;","uniform vec2 scale;","uniform float rotation;","uniform sampler2D occlusionMap;","attribute vec2 position;","attribute vec2 uv;","varying vec2 vUV;","varying float vVisibility;","void main() {","\tvUV = uv;","\tvec2 pos = position;","\tif ( renderType == 2 ) {","\t\tvec4 visibility = texture2D( occlusionMap, vec2( 0.1, 0.1 ) );","\t\tvisibility += texture2D( occlusionMap, vec2( 0.5, 0.1 ) );","\t\tvisibility += texture2D( occlusionMap, vec2( 0.9, 0.1 ) );","\t\tvisibility += texture2D( occlusionMap, vec2( 0.9, 0.5 ) );","\t\tvisibility += texture2D( occlusionMap, vec2( 0.9, 0.9 ) );","\t\tvisibility += texture2D( occlusionMap, vec2( 0.5, 0.9 ) );","\t\tvisibility += texture2D( occlusionMap, vec2( 0.1, 0.9 ) );","\t\tvisibility += texture2D( occlusionMap, vec2( 0.1, 0.5 ) );","\t\tvisibility += texture2D( occlusionMap, vec2( 0.5, 0.5 ) );","\t\tvVisibility =        visibility.r / 9.0;","\t\tvVisibility *= 1.0 - visibility.g / 9.0;","\t\tvVisibility *=       visibility.b / 9.0;","\t\tvVisibility *= 1.0 - visibility.a / 9.0;","\t\tpos.x = cos( rotation ) * position.x - sin( rotation ) * position.y;","\t\tpos.y = sin( rotation ) * position.x + cos( rotation ) * position.y;","\t}","\tgl_Position = vec4( ( pos * scale + screenPosition.xy ).xy, screenPosition.z, 1.0 );","}"].join("\n"),fragmentShader:["uniform lowp int renderType;","uniform sampler2D map;","uniform float opacity;","uniform vec3 color;","varying vec2 vUV;","varying float vVisibility;","void main() {","\tif ( renderType == 0 ) {","\t\tgl_FragColor = vec4( 1.0, 0.0, 1.0, 0.0 );","\t} else if ( renderType == 1 ) {","\t\tgl_FragColor = texture2D( map, vUV );","\t} else {","\t\tvec4 texture = texture2D( map, vUV );","\t\ttexture.a *= opacity * vVisibility;","\t\tgl_FragColor = texture;","\t\tgl_FragColor.rgb *= color;","\t}","}"].join("\n")},t=s,r=e.createProgram(),d=e.createShader(e.FRAGMENT_SHADER),f=e.createShader(e.VERTEX_SHADER),m="precision "+n.precision+" float;\n",e.shaderSource(d,m+t.fragmentShader),e.shaderSource(f,m+t.vertexShader),e.compileShader(d),e.compileShader(f),e.attachShader(r,d),e.attachShader(r,f),e.linkProgram(r),c=r,u={vertex:e.getAttribLocation(c,"position"),uv:e.getAttribLocation(c,"uv")},h={renderType:e.getUniformLocation(c,"renderType"),map:e.getUniformLocation(c,"map"),occlusionMap:e.getUniformLocation(c,"occlusionMap"),opacity:e.getUniformLocation(c,"opacity"),color:e.getUniformLocation(c,"color"),scale:e.getUniformLocation(c,"scale"),rotation:e.getUniformLocation(c,"rotation"),screenPosition:e.getUniformLocation(c,"screenPosition")}}this.render=function(t,n,s,f){if(0!==t.length){var m=new $e,g=f.w/f.z,v=.5*f.z,y=.5*f.w,b=16/f.w,x=new Ge(b*g,b),_=new $e(1,1,0),w=new Ge(1,1),S=new Yi;S.min.set(f.x,f.y),S.max.set(f.x+(f.z-16),f.y+(f.w-16)),void 0===c&&d(),i.useProgram(c),i.initAttributes(),i.enableAttribute(u.vertex),i.enableAttribute(u.uv),i.disableUnusedAttributes(),e.uniform1i(h.occlusionMap,0),e.uniform1i(h.map,1),e.bindBuffer(e.ARRAY_BUFFER,o),e.vertexAttribPointer(u.vertex,2,e.FLOAT,!1,16,0),e.vertexAttribPointer(u.uv,2,e.FLOAT,!1,16,8),e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,a),i.disable(e.CULL_FACE),i.buffers.depth.setMask(!1);for(var A=0,M=t.length;A<M;A++){b=16/f.w,x.set(b*g,b);var P=t[A];if(m.set(P.matrixWorld.elements[12],P.matrixWorld.elements[13],P.matrixWorld.elements[14]),m.applyMatrix4(s.matrixWorldInverse),m.applyMatrix4(s.projectionMatrix),_.copy(m),w.x=f.x+_.x*v+v-8,w.y=f.y+_.y*y+y-8,!0===S.containsPoint(w)){i.activeTexture(e.TEXTURE0),i.bindTexture(e.TEXTURE_2D,null),i.activeTexture(e.TEXTURE1),i.bindTexture(e.TEXTURE_2D,l),e.copyTexImage2D(e.TEXTURE_2D,0,e.RGB,w.x,w.y,16,16,0),e.uniform1i(h.renderType,0),e.uniform2f(h.scale,x.x,x.y),e.uniform3f(h.screenPosition,_.x,_.y,_.z),i.disable(e.BLEND),i.enable(e.DEPTH_TEST),e.drawElements(e.TRIANGLES,6,e.UNSIGNED_SHORT,0),i.activeTexture(e.TEXTURE0),i.bindTexture(e.TEXTURE_2D,p),e.copyTexImage2D(e.TEXTURE_2D,0,e.RGBA,w.x,w.y,16,16,0),e.uniform1i(h.renderType,1),i.disable(e.DEPTH_TEST),i.activeTexture(e.TEXTURE1),i.bindTexture(e.TEXTURE_2D,l),e.drawElements(e.TRIANGLES,6,e.UNSIGNED_SHORT,0),P.positionScreen.copy(_),P.customUpdateCallback?P.customUpdateCallback(P):P.updateLensFlares(),e.uniform1i(h.renderType,2),i.enable(e.BLEND);for(var T=0,E=P.lensFlares.length;T<E;T++){var C=P.lensFlares[T];C.opacity>.001&&C.scale>.001&&(_.x=C.x,_.y=C.y,_.z=C.z,b=C.size*C.scale/f.w,x.x=b*g,x.y=b,e.uniform3f(h.screenPosition,_.x,_.y,_.z),e.uniform2f(h.scale,x.x,x.y),e.uniform1f(h.rotation,C.rotation),e.uniform1f(h.opacity,C.opacity),e.uniform3f(h.color,C.color.r,C.color.g,C.color.b),i.setBlending(C.blending,C.blendEquation,C.blendSrc,C.blendDst),r.setTexture2D(C.texture,1),e.drawElements(e.TRIANGLES,6,e.UNSIGNED_SHORT,0))}}}i.enable(e.CULL_FACE),i.enable(e.DEPTH_TEST),i.buffers.depth.setMask(!0),i.reset()}}}function Ki(t,e,i,r,n,o,a,s,c){Ze.call(this,t,e,i,r,n,o,a,s,c),this.needsUpdate=!0}function Ji(t,e,i,r,n){var o,a,s,c,u,h,l=new $e,p=new He,d=new $e;function f(){var t,i,r,l=new Float32Array([-.5,-.5,0,0,.5,-.5,1,0,.5,.5,1,1,-.5,.5,0,1]),p=new Uint16Array([0,1,2,0,2,3]);o=e.createBuffer(),a=e.createBuffer(),e.bindBuffer(e.ARRAY_BUFFER,o),e.bufferData(e.ARRAY_BUFFER,l,e.STATIC_DRAW),e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,a),e.bufferData(e.ELEMENT_ARRAY_BUFFER,p,e.STATIC_DRAW),t=e.createProgram(),i=e.createShader(e.VERTEX_SHADER),r=e.createShader(e.FRAGMENT_SHADER),e.shaderSource(i,["precision "+n.precision+" float;","#define SHADER_NAME SpriteMaterial","uniform mat4 modelViewMatrix;","uniform mat4 projectionMatrix;","uniform float rotation;","uniform vec2 scale;","uniform vec2 uvOffset;","uniform vec2 uvScale;","attribute vec2 position;","attribute vec2 uv;","varying vec2 vUV;","varying float fogDepth;","void main() {","\tvUV = uvOffset + uv * uvScale;","\tvec2 alignedPosition = position * scale;","\tvec2 rotatedPosition;","\trotatedPosition.x = cos( rotation ) * alignedPosition.x - sin( rotation ) * alignedPosition.y;","\trotatedPosition.y = sin( rotation ) * alignedPosition.x + cos( rotation ) * alignedPosition.y;","\tvec4 mvPosition;","\tmvPosition = modelViewMatrix * vec4( 0.0, 0.0, 0.0, 1.0 );","\tmvPosition.xy += rotatedPosition;","\tgl_Position = projectionMatrix * mvPosition;","\tfogDepth = - mvPosition.z;","}"].join("\n")),e.shaderSource(r,["precision "+n.precision+" float;","#define SHADER_NAME SpriteMaterial","uniform vec3 color;","uniform sampler2D map;","uniform float opacity;","uniform int fogType;","uniform vec3 fogColor;","uniform float fogDensity;","uniform float fogNear;","uniform float fogFar;","uniform float alphaTest;","varying vec2 vUV;","varying float fogDepth;","void main() {","\tvec4 texture = texture2D( map, vUV );","\tgl_FragColor = vec4( color * texture.xyz, texture.a * opacity );","\tif ( gl_FragColor.a < alphaTest ) discard;","\tif ( fogType > 0 ) {","\t\tfloat fogFactor = 0.0;","\t\tif ( fogType == 1 ) {","\t\t\tfogFactor = smoothstep( fogNear, fogFar, fogDepth );","\t\t} else {","\t\t\tconst float LOG2 = 1.442695;","\t\t\tfogFactor = exp2( - fogDensity * fogDensity * fogDepth * fogDepth * LOG2 );","\t\t\tfogFactor = 1.0 - clamp( fogFactor, 0.0, 1.0 );","\t\t}","\t\tgl_FragColor.rgb = mix( gl_FragColor.rgb, fogColor, fogFactor );","\t}","}"].join("\n")),e.compileShader(i),e.compileShader(r),e.attachShader(t,i),e.attachShader(t,r),e.linkProgram(t),s=t,c={position:e.getAttribLocation(s,"position"),uv:e.getAttribLocation(s,"uv")},u={uvOffset:e.getUniformLocation(s,"uvOffset"),uvScale:e.getUniformLocation(s,"uvScale"),rotation:e.getUniformLocation(s,"rotation"),scale:e.getUniformLocation(s,"scale"),color:e.getUniformLocation(s,"color"),map:e.getUniformLocation(s,"map"),opacity:e.getUniformLocation(s,"opacity"),modelViewMatrix:e.getUniformLocation(s,"modelViewMatrix"),projectionMatrix:e.getUniformLocation(s,"projectionMatrix"),fogType:e.getUniformLocation(s,"fogType"),fogDensity:e.getUniformLocation(s,"fogDensity"),fogNear:e.getUniformLocation(s,"fogNear"),fogFar:e.getUniformLocation(s,"fogFar"),fogColor:e.getUniformLocation(s,"fogColor"),fogDepth:e.getUniformLocation(s,"fogDepth"),alphaTest:e.getUniformLocation(s,"alphaTest")};var d=document.createElementNS("http://www.w3.org/1999/xhtml","canvas");d.width=8,d.height=8;var f=d.getContext("2d");f.fillStyle="white",f.fillRect(0,0,8,8),h=new Ki(d)}function m(t,e){return t.renderOrder!==e.renderOrder?t.renderOrder-e.renderOrder:t.z!==e.z?e.z-t.z:e.id-t.id}this.render=function(n,g,v){if(0!==n.length){void 0===s&&f(),i.useProgram(s),i.initAttributes(),i.enableAttribute(c.position),i.enableAttribute(c.uv),i.disableUnusedAttributes(),i.disable(e.CULL_FACE),i.enable(e.BLEND),e.bindBuffer(e.ARRAY_BUFFER,o),e.vertexAttribPointer(c.position,2,e.FLOAT,!1,16,0),e.vertexAttribPointer(c.uv,2,e.FLOAT,!1,16,8),e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,a),e.uniformMatrix4fv(u.projectionMatrix,!1,v.projectionMatrix.elements),i.activeTexture(e.TEXTURE0),e.uniform1i(u.map,0);var y=0,b=0,x=g.fog;x?(e.uniform3f(u.fogColor,x.color.r,x.color.g,x.color.b),x.isFog?(e.uniform1f(u.fogNear,x.near),e.uniform1f(u.fogFar,x.far),e.uniform1i(u.fogType,1),y=1,b=1):x.isFogExp2&&(e.uniform1f(u.fogDensity,x.density),e.uniform1i(u.fogType,2),y=2,b=2)):(e.uniform1i(u.fogType,0),y=0,b=0);for(var _=0,w=n.length;_<w;_++){(A=n[_]).modelViewMatrix.multiplyMatrices(v.matrixWorldInverse,A.matrixWorld),A.z=-A.modelViewMatrix.elements[14]}n.sort(m);var S=[];for(_=0,w=n.length;_<w;_++){var A,M=(A=n[_]).material;if(!1!==M.visible){A.onBeforeRender(t,g,v,void 0,M,void 0),e.uniform1f(u.alphaTest,M.alphaTest),e.uniformMatrix4fv(u.modelViewMatrix,!1,A.modelViewMatrix.elements),A.matrixWorld.decompose(l,p,d),S[0]=d.x,S[1]=d.y;var P=0;g.fog&&M.fog&&(P=b),y!==P&&(e.uniform1i(u.fogType,P),y=P),null!==M.map?(e.uniform2f(u.uvOffset,M.map.offset.x,M.map.offset.y),e.uniform2f(u.uvScale,M.map.repeat.x,M.map.repeat.y)):(e.uniform2f(u.uvOffset,0,0),e.uniform2f(u.uvScale,1,1)),e.uniform1f(u.opacity,M.opacity),e.uniform3f(u.color,M.color.r,M.color.g,M.color.b),e.uniform1f(u.rotation,M.rotation),e.uniform2fv(u.scale,S),i.setBlending(M.blending,M.blendEquation,M.blendSrc,M.blendDst,M.blendEquationAlpha,M.blendSrcAlpha,M.blendDstAlpha,M.premultipliedAlpha),i.buffers.depth.setTest(M.depthTest),i.buffers.depth.setMask(M.depthWrite),i.buffers.color.setMask(M.colorWrite),r.setTexture2D(M.map||h,0),e.drawElements(e.TRIANGLES,6,e.UNSIGNED_SHORT,0),A.onAfterRender(t,g,v,void 0,M,void 0)}}i.enable(e.CULL_FACE),i.reset()}}}qi.physical={uniforms:Wi.merge([qi.standard.uniforms,{clearCoat:{value:0},clearCoatRoughness:{value:0}}]),vertexShader:Xi.meshphysical_vert,fragmentShader:Xi.meshphysical_frag},Object.assign(Yi.prototype,{set:function(t,e){return this.min.copy(t),this.max.copy(e),this},setFromPoints:function(t){this.makeEmpty();for(var e=0,i=t.length;e<i;e++)this.expandByPoint(t[e]);return this},setFromCenterAndSize:(Hi=new Ge,function(t,e){var i=Hi.copy(e).multiplyScalar(.5);return this.min.copy(t).sub(i),this.max.copy(t).add(i),this}),clone:function(){return(new this.constructor).copy(this)},copy:function(t){return this.min.copy(t.min),this.max.copy(t.max),this},makeEmpty:function(){return this.min.x=this.min.y=1/0,this.max.x=this.max.y=-1/0,this},isEmpty:function(){return this.max.x<this.min.x||this.max.y<this.min.y},getCenter:function(t){var e=t||new Ge;return this.isEmpty()?e.set(0,0):e.addVectors(this.min,this.max).multiplyScalar(.5)},getSize:function(t){var e=t||new Ge;return this.isEmpty()?e.set(0,0):e.subVectors(this.max,this.min)},expandByPoint:function(t){return this.min.min(t),this.max.max(t),this},expandByVector:function(t){return this.min.sub(t),this.max.add(t),this},expandByScalar:function(t){return this.min.addScalar(-t),this.max.addScalar(t),this},containsPoint:function(t){return!(t.x<this.min.x||t.x>this.max.x||t.y<this.min.y||t.y>this.max.y)},containsBox:function(t){return this.min.x<=t.min.x&&t.max.x<=this.max.x&&this.min.y<=t.min.y&&t.max.y<=this.max.y},getParameter:function(t,e){return(e||new Ge).set((t.x-this.min.x)/(this.max.x-this.min.x),(t.y-this.min.y)/(this.max.y-this.min.y))},intersectsBox:function(t){return!(t.max.x<this.min.x||t.min.x>this.max.x||t.max.y<this.min.y||t.min.y>this.max.y)},clampPoint:function(t,e){return(e||new Ge).copy(t).clamp(this.min,this.max)},distanceToPoint:(Vi=new Ge,function(t){return Vi.copy(t).clamp(this.min,this.max).sub(t).length()}),intersect:function(t){return this.min.max(t.min),this.max.min(t.max),this},union:function(t){return this.min.min(t.min),this.max.max(t.max),this},translate:function(t){return this.min.add(t),this.max.add(t),this},equals:function(t){return t.min.equals(this.min)&&t.max.equals(this.max)}}),Ki.prototype=Object.create(Ze.prototype),Ki.prototype.constructor=Ki;var Qi,tr,er,ir,rr,nr,or,ar,sr,cr,ur,hr,lr,pr,dr,fr,mr,gr=0;function vr(){Object.defineProperty(this,"id",{value:gr++}),this.uuid=je.generateUUID(),this.name="",this.type="Material",this.fog=!0,this.lights=!0,this.blending=J,this.side=$,this.flatShading=!1,this.vertexColors=q,this.opacity=1,this.transparent=!1,this.blendSrc=pt,this.blendDst=dt,this.blendEquation=rt,this.blendSrcAlpha=null,this.blendDstAlpha=null,this.blendEquationAlpha=null,this.depthFunc=wt,this.depthTest=!0,this.depthWrite=!0,this.clippingPlanes=null,this.clipIntersection=!1,this.clipShadows=!1,this.colorWrite=!0,this.precision=null,this.polygonOffset=!1,this.polygonOffsetFactor=0,this.polygonOffsetUnits=0,this.dithering=!1,this.alphaTest=0,this.premultipliedAlpha=!1,this.overdraw=0,this.visible=!0,this.userData={},this.needsUpdate=!0}function yr(t){vr.call(this),this.type="MeshDepthMaterial",this.depthPacking=ze,this.skinning=!1,this.morphTargets=!1,this.map=null,this.alphaMap=null,this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.wireframe=!1,this.wireframeLinewidth=1,this.fog=!1,this.lights=!1,this.setValues(t)}function br(t){vr.call(this),this.type="MeshDistanceMaterial",this.referencePosition=new $e,this.nearDistance=1,this.farDistance=1e3,this.skinning=!1,this.morphTargets=!1,this.map=null,this.alphaMap=null,this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.fog=!1,this.lights=!1,this.setValues(t)}function xr(t,e){this.min=void 0!==t?t:new $e(1/0,1/0,1/0),this.max=void 0!==e?e:new $e(-1/0,-1/0,-1/0)}function _r(t,e){this.center=void 0!==t?t:new $e,this.radius=void 0!==e?e:0}function wr(t,e){this.normal=void 0!==t?t:new $e(1,0,0),this.constant=void 0!==e?e:0}function Sr(t,e,i,r,n,o){this.planes=[void 0!==t?t:new wr,void 0!==e?e:new wr,void 0!==i?i:new wr,void 0!==r?r:new wr,void 0!==n?n:new wr,void 0!==o?o:new wr]}function Ar(t,e,i){for(var r=new Sr,n=new Ve,o=new Ge,a=new Ge(i,i),s=new $e,c=new $e,u=1,h=2,l=1+(u|h),p=new Array(l),d=new Array(l),f={},m=[new $e(1,0,0),new $e(-1,0,0),new $e(0,0,1),new $e(0,0,-1),new $e(0,1,0),new $e(0,-1,0)],g=[new $e(0,1,0),new $e(0,1,0),new $e(0,1,0),new $e(0,1,0),new $e(0,0,1),new $e(0,0,-1)],v=[new Ke,new Ke,new Ke,new Ke,new Ke,new Ke],y=0;y!==l;++y){var b=0!=(y&u),x=0!=(y&h),_=new yr({depthPacking:Ue,morphTargets:b,skinning:x});p[y]=_;var w=new br({morphTargets:b,skinning:x});d[y]=w}var S=this;function A(e,i,r,n,o,a){var s=e.geometry,c=null,l=p,m=e.customDepthMaterial;if(r&&(l=d,m=e.customDistanceMaterial),m)c=m;else{var g=!1;i.morphTargets&&(s&&s.isBufferGeometry?g=s.morphAttributes&&s.morphAttributes.position&&s.morphAttributes.position.length>0:s&&s.isGeometry&&(g=s.morphTargets&&s.morphTargets.length>0)),e.isSkinnedMesh&&!1===i.skinning&&console.warn("THREE.WebGLShadowMap: THREE.SkinnedMesh with material.skinning set to false:",e);var v=e.isSkinnedMesh&&i.skinning,y=0;g&&(y|=u),v&&(y|=h),c=l[y]}if(t.localClippingEnabled&&!0===i.clipShadows&&0!==i.clippingPlanes.length){var b=c.uuid,x=i.uuid,_=f[b];void 0===_&&(_={},f[b]=_);var w=_[x];void 0===w&&(w=c.clone(),_[x]=w),c=w}c.visible=i.visible,c.wireframe=i.wireframe;var A=i.side;return S.renderSingleSided&&A==X&&(A=$),S.renderReverseSided&&(A===$?A=W:A===W&&(A=$)),c.side=A,c.clipShadows=i.clipShadows,c.clippingPlanes=i.clippingPlanes,c.clipIntersection=i.clipIntersection,c.wireframeLinewidth=i.wireframeLinewidth,c.linewidth=i.linewidth,r&&c.isMeshDistanceMaterial&&(c.referencePosition.copy(n),c.nearDistance=o,c.farDistance=a),c}function M(i,n,o,a){if(!1!==i.visible){if(i.layers.test(n.layers)&&(i.isMesh||i.isLine||i.isPoints)&&i.castShadow&&(!i.frustumCulled||r.intersectsObject(i))){i.modelViewMatrix.multiplyMatrices(o.matrixWorldInverse,i.matrixWorld);var s=e.update(i),u=i.material;if(Array.isArray(u))for(var h=s.groups,l=0,p=h.length;l<p;l++){var d=h[l],f=u[d.materialIndex];if(f&&f.visible){var m=A(i,f,a,c,o.near,o.far);t.renderBufferDirect(o,null,s,m,i,d)}}else if(u.visible){m=A(i,u,a,c,o.near,o.far);t.renderBufferDirect(o,null,s,m,i,null)}}for(var g=i.children,v=0,y=g.length;v<y;v++)M(g[v],n,o,a)}}this.enabled=!1,this.autoUpdate=!0,this.needsUpdate=!1,this.type=V,this.renderReverseSided=!0,this.renderSingleSided=!0,this.render=function(e,i,u){if(!1!==S.enabled&&(!1!==S.autoUpdate||!1!==S.needsUpdate)&&0!==e.length){var h,l=t.context,p=t.state;p.disable(l.BLEND),p.buffers.color.setClear(1,1,1,1),p.buffers.depth.setTest(!0),p.setScissorTest(!1);for(var d=0,f=e.length;d<f;d++){var y=e[d],b=y.shadow,x=y&&y.isPointLight;if(void 0!==b){var _=b.camera;if(o.copy(b.mapSize),o.min(a),x){var w=o.x,A=o.y;v[0].set(2*w,A,w,A),v[1].set(0,A,w,A),v[2].set(3*w,A,w,A),v[3].set(w,A,w,A),v[4].set(3*w,0,w,A),v[5].set(w,0,w,A),o.x*=4,o.y*=2}if(null===b.map){var P={minFilter:$t,magFilter:$t,format:le};b.map=new Je(o.x,o.y,P),b.map.texture.name=y.name+".shadowMap",_.updateProjectionMatrix()}b.isSpotLightShadow&&b.update(y);var T=b.map,E=b.matrix;c.setFromMatrixPosition(y.matrixWorld),_.position.copy(c),x?(h=6,E.makeTranslation(-c.x,-c.y,-c.z)):(h=1,s.setFromMatrixPosition(y.target.matrixWorld),_.lookAt(s),_.updateMatrixWorld(),E.set(.5,0,0,.5,0,.5,0,.5,0,0,.5,.5,0,0,0,1),E.multiply(_.projectionMatrix),E.multiply(_.matrixWorldInverse)),t.setRenderTarget(T),t.clear();for(var C=0;C<h;C++){if(x){s.copy(_.position),s.add(m[C]),_.up.copy(g[C]),_.lookAt(s),_.updateMatrixWorld();var I=v[C];p.viewport(I)}n.multiplyMatrices(_.projectionMatrix,_.matrixWorldInverse),r.setFromMatrix(n),M(i,u,_,x)}}else console.warn("THREE.WebGLShadowMap:",y,"has no shadow.")}S.needsUpdate=!1}}}function Mr(t){var e={};return{get:function(t){return t.isInterleavedBufferAttribute&&(t=t.data),e[t.uuid]},remove:function(i){i.isInterleavedBufferAttribute&&(i=i.data);var r=e[i.uuid];r&&(t.deleteBuffer(r.buffer),delete e[i.uuid])},update:function(i,r){i.isInterleavedBufferAttribute&&(i=i.data);var n,o,a,s,c,u=e[i.uuid];void 0===u?e[i.uuid]=function(e,i){var r=e.array,n=e.dynamic?t.DYNAMIC_DRAW:t.STATIC_DRAW,o=t.createBuffer();t.bindBuffer(i,o),t.bufferData(i,r,n),e.onUploadCallback();var a=t.FLOAT;return r instanceof Float32Array?a=t.FLOAT:r instanceof Float64Array?console.warn("THREE.WebGLAttributes: Unsupported data buffer format: Float64Array."):r instanceof Uint16Array?a=t.UNSIGNED_SHORT:r instanceof Int16Array?a=t.SHORT:r instanceof Uint32Array?a=t.UNSIGNED_INT:r instanceof Int32Array?a=t.INT:r instanceof Int8Array?a=t.BYTE:r instanceof Uint8Array&&(a=t.UNSIGNED_BYTE),{buffer:o,type:a,bytesPerElement:r.BYTES_PER_ELEMENT,version:e.version}}(i,r):u.version<i.version&&(n=u.buffer,a=r,s=(o=i).array,c=o.updateRange,t.bindBuffer(a,n),!1===o.dynamic?t.bufferData(a,s,t.STATIC_DRAW):-1===c.count?t.bufferSubData(a,0,s):0===c.count?console.error("THREE.WebGLObjects.updateBuffer: dynamic THREE.BufferAttribute marked as needsUpdate but updateRange.count is 0, ensure you are using set methods or updating manually."):(t.bufferSubData(a,c.offset*s.BYTES_PER_ELEMENT,s.subarray(c.offset,c.offset+c.count)),c.count=-1),u.version=i.version)}}}function Pr(t,e,i,r){this._x=t||0,this._y=e||0,this._z=i||0,this._order=r||Pr.DefaultOrder}function Tr(){this.mask=1}vr.prototype=Object.assign(Object.create(v.prototype),{constructor:vr,isMaterial:!0,onBeforeCompile:function(){},setValues:function(t){var e=this;if(void 0!==t)for(var i in t){var r=t[i];if(void 0!==r)if("shading"!==i){var n=e[i];void 0!==n?n&&n.isColor?n.set(r):n&&n.isVector3&&r&&r.isVector3?n.copy(r):e[i]="overdraw"===i?Number(r):r:console.warn("THREE."+e.type+": '"+i+"' is not a property of this material.")}else console.warn("THREE."+e.type+": .shading has been removed. Use the boolean .flatShading instead."),e.flatShading=1===r;else console.warn("THREE.Material: '"+i+"' parameter is undefined.")}},toJSON:function(t){var e=void 0===t||"string"==typeof t;e&&(t={textures:{},images:{}});var i={metadata:{version:4.5,type:"Material",generator:"Material.toJSON"}};function r(t){var e=[];for(var i in t){var r=t[i];delete r.metadata,e.push(r)}return e}if(i.uuid=this.uuid,i.type=this.type,""!==this.name&&(i.name=this.name),this.color&&this.color.isColor&&(i.color=this.color.getHex()),void 0!==this.roughness&&(i.roughness=this.roughness),void 0!==this.metalness&&(i.metalness=this.metalness),this.emissive&&this.emissive.isColor&&(i.emissive=this.emissive.getHex()),1!==this.emissiveIntensity&&(i.emissiveIntensity=this.emissiveIntensity),this.specular&&this.specular.isColor&&(i.specular=this.specular.getHex()),void 0!==this.shininess&&(i.shininess=this.shininess),void 0!==this.clearCoat&&(i.clearCoat=this.clearCoat),void 0!==this.clearCoatRoughness&&(i.clearCoatRoughness=this.clearCoatRoughness),this.map&&this.map.isTexture&&(i.map=this.map.toJSON(t).uuid),this.alphaMap&&this.alphaMap.isTexture&&(i.alphaMap=this.alphaMap.toJSON(t).uuid),this.lightMap&&this.lightMap.isTexture&&(i.lightMap=this.lightMap.toJSON(t).uuid),this.bumpMap&&this.bumpMap.isTexture&&(i.bumpMap=this.bumpMap.toJSON(t).uuid,i.bumpScale=this.bumpScale),this.normalMap&&this.normalMap.isTexture&&(i.normalMap=this.normalMap.toJSON(t).uuid,i.normalScale=this.normalScale.toArray()),this.displacementMap&&this.displacementMap.isTexture&&(i.displacementMap=this.displacementMap.toJSON(t).uuid,i.displacementScale=this.displacementScale,i.displacementBias=this.displacementBias),this.roughnessMap&&this.roughnessMap.isTexture&&(i.roughnessMap=this.roughnessMap.toJSON(t).uuid),this.metalnessMap&&this.metalnessMap.isTexture&&(i.metalnessMap=this.metalnessMap.toJSON(t).uuid),this.emissiveMap&&this.emissiveMap.isTexture&&(i.emissiveMap=this.emissiveMap.toJSON(t).uuid),this.specularMap&&this.specularMap.isTexture&&(i.specularMap=this.specularMap.toJSON(t).uuid),this.envMap&&this.envMap.isTexture&&(i.envMap=this.envMap.toJSON(t).uuid,i.reflectivity=this.reflectivity),this.gradientMap&&this.gradientMap.isTexture&&(i.gradientMap=this.gradientMap.toJSON(t).uuid),void 0!==this.size&&(i.size=this.size),void 0!==this.sizeAttenuation&&(i.sizeAttenuation=this.sizeAttenuation),this.blending!==J&&(i.blending=this.blending),!0===this.flatShading&&(i.flatShading=this.flatShading),this.side!==$&&(i.side=this.side),this.vertexColors!==q&&(i.vertexColors=this.vertexColors),this.opacity<1&&(i.opacity=this.opacity),!0===this.transparent&&(i.transparent=this.transparent),i.depthFunc=this.depthFunc,i.depthTest=this.depthTest,i.depthWrite=this.depthWrite,0!==this.rotation&&(i.rotation=this.rotation),1!==this.linewidth&&(i.linewidth=this.linewidth),void 0!==this.dashSize&&(i.dashSize=this.dashSize),void 0!==this.gapSize&&(i.gapSize=this.gapSize),void 0!==this.scale&&(i.scale=this.scale),!0===this.dithering&&(i.dithering=!0),this.alphaTest>0&&(i.alphaTest=this.alphaTest),!0===this.premultipliedAlpha&&(i.premultipliedAlpha=this.premultipliedAlpha),!0===this.wireframe&&(i.wireframe=this.wireframe),this.wireframeLinewidth>1&&(i.wireframeLinewidth=this.wireframeLinewidth),"round"!==this.wireframeLinecap&&(i.wireframeLinecap=this.wireframeLinecap),"round"!==this.wireframeLinejoin&&(i.wireframeLinejoin=this.wireframeLinejoin),!0===this.morphTargets&&(i.morphTargets=!0),!0===this.skinning&&(i.skinning=!0),!1===this.visible&&(i.visible=!1),"{}"!==JSON.stringify(this.userData)&&(i.userData=this.userData),e){var n=r(t.textures),o=r(t.images);n.length>0&&(i.textures=n),o.length>0&&(i.images=o)}return i},clone:function(){return(new this.constructor).copy(this)},copy:function(t){this.name=t.name,this.fog=t.fog,this.lights=t.lights,this.blending=t.blending,this.side=t.side,this.flatShading=t.flatShading,this.vertexColors=t.vertexColors,this.opacity=t.opacity,this.transparent=t.transparent,this.blendSrc=t.blendSrc,this.blendDst=t.blendDst,this.blendEquation=t.blendEquation,this.blendSrcAlpha=t.blendSrcAlpha,this.blendDstAlpha=t.blendDstAlpha,this.blendEquationAlpha=t.blendEquationAlpha,this.depthFunc=t.depthFunc,this.depthTest=t.depthTest,this.depthWrite=t.depthWrite,this.colorWrite=t.colorWrite,this.precision=t.precision,this.polygonOffset=t.polygonOffset,this.polygonOffsetFactor=t.polygonOffsetFactor,this.polygonOffsetUnits=t.polygonOffsetUnits,this.dithering=t.dithering,this.alphaTest=t.alphaTest,this.premultipliedAlpha=t.premultipliedAlpha,this.overdraw=t.overdraw,this.visible=t.visible,this.userData=JSON.parse(JSON.stringify(t.userData)),this.clipShadows=t.clipShadows,this.clipIntersection=t.clipIntersection;var e=t.clippingPlanes,i=null;if(null!==e){var r=e.length;i=new Array(r);for(var n=0;n!==r;++n)i[n]=e[n].clone()}return this.clippingPlanes=i,this},dispose:function(){this.dispatchEvent({type:"dispose"})}}),yr.prototype=Object.create(vr.prototype),yr.prototype.constructor=yr,yr.prototype.isMeshDepthMaterial=!0,yr.prototype.copy=function(t){return vr.prototype.copy.call(this,t),this.depthPacking=t.depthPacking,this.skinning=t.skinning,this.morphTargets=t.morphTargets,this.map=t.map,this.alphaMap=t.alphaMap,this.displacementMap=t.displacementMap,this.displacementScale=t.displacementScale,this.displacementBias=t.displacementBias,this.wireframe=t.wireframe,this.wireframeLinewidth=t.wireframeLinewidth,this},br.prototype=Object.create(vr.prototype),br.prototype.constructor=br,br.prototype.isMeshDistanceMaterial=!0,br.prototype.copy=function(t){return vr.prototype.copy.call(this,t),this.referencePosition.copy(t.referencePosition),this.nearDistance=t.nearDistance,this.farDistance=t.farDistance,this.skinning=t.skinning,this.morphTargets=t.morphTargets,this.map=t.map,this.alphaMap=t.alphaMap,this.displacementMap=t.displacementMap,this.displacementScale=t.displacementScale,this.displacementBias=t.displacementBias,this},Object.assign(xr.prototype,{isBox3:!0,set:function(t,e){return this.min.copy(t),this.max.copy(e),this},setFromArray:function(t){for(var e=1/0,i=1/0,r=1/0,n=-1/0,o=-1/0,a=-1/0,s=0,c=t.length;s<c;s+=3){var u=t[s],h=t[s+1],l=t[s+2];u<e&&(e=u),h<i&&(i=h),l<r&&(r=l),u>n&&(n=u),h>o&&(o=h),l>a&&(a=l)}return this.min.set(e,i,r),this.max.set(n,o,a),this},setFromBufferAttribute:function(t){for(var e=1/0,i=1/0,r=1/0,n=-1/0,o=-1/0,a=-1/0,s=0,c=t.count;s<c;s++){var u=t.getX(s),h=t.getY(s),l=t.getZ(s);u<e&&(e=u),h<i&&(i=h),l<r&&(r=l),u>n&&(n=u),h>o&&(o=h),l>a&&(a=l)}return this.min.set(e,i,r),this.max.set(n,o,a),this},setFromPoints:function(t){this.makeEmpty();for(var e=0,i=t.length;e<i;e++)this.expandByPoint(t[e]);return this},setFromCenterAndSize:(rr=new $e,function(t,e){var i=rr.copy(e).multiplyScalar(.5);return this.min.copy(t).sub(i),this.max.copy(t).add(i),this}),setFromObject:function(t){return this.makeEmpty(),this.expandByObject(t)},clone:function(){return(new this.constructor).copy(this)},copy:function(t){return this.min.copy(t.min),this.max.copy(t.max),this},makeEmpty:function(){return this.min.x=this.min.y=this.min.z=1/0,this.max.x=this.max.y=this.max.z=-1/0,this},isEmpty:function(){return this.max.x<this.min.x||this.max.y<this.min.y||this.max.z<this.min.z},getCenter:function(t){var e=t||new $e;return this.isEmpty()?e.set(0,0,0):e.addVectors(this.min,this.max).multiplyScalar(.5)},getSize:function(t){var e=t||new $e;return this.isEmpty()?e.set(0,0,0):e.subVectors(this.max,this.min)},expandByPoint:function(t){return this.min.min(t),this.max.max(t),this},expandByVector:function(t){return this.min.sub(t),this.max.add(t),this},expandByScalar:function(t){return this.min.addScalar(-t),this.max.addScalar(t),this},expandByObject:function(){var t,e,i,r=new $e;function n(n){var o=n.geometry;if(void 0!==o)if(o.isGeometry){var a=o.vertices;for(e=0,i=a.length;e<i;e++)r.copy(a[e]),r.applyMatrix4(n.matrixWorld),t.expandByPoint(r)}else if(o.isBufferGeometry){var s=o.attributes.position;if(void 0!==s)for(e=0,i=s.count;e<i;e++)r.fromBufferAttribute(s,e).applyMatrix4(n.matrixWorld),t.expandByPoint(r)}}return function(e){return t=this,e.updateMatrixWorld(!0),e.traverse(n),this}}(),containsPoint:function(t){return!(t.x<this.min.x||t.x>this.max.x||t.y<this.min.y||t.y>this.max.y||t.z<this.min.z||t.z>this.max.z)},containsBox:function(t){return this.min.x<=t.min.x&&t.max.x<=this.max.x&&this.min.y<=t.min.y&&t.max.y<=this.max.y&&this.min.z<=t.min.z&&t.max.z<=this.max.z},getParameter:function(t,e){return(e||new $e).set((t.x-this.min.x)/(this.max.x-this.min.x),(t.y-this.min.y)/(this.max.y-this.min.y),(t.z-this.min.z)/(this.max.z-this.min.z))},intersectsBox:function(t){return!(t.max.x<this.min.x||t.min.x>this.max.x||t.max.y<this.min.y||t.min.y>this.max.y||t.max.z<this.min.z||t.min.z>this.max.z)},intersectsSphere:(ir=new $e,function(t){return this.clampPoint(t.center,ir),ir.distanceToSquared(t.center)<=t.radius*t.radius}),intersectsPlane:function(t){var e,i;return t.normal.x>0?(e=t.normal.x*this.min.x,i=t.normal.x*this.max.x):(e=t.normal.x*this.max.x,i=t.normal.x*this.min.x),t.normal.y>0?(e+=t.normal.y*this.min.y,i+=t.normal.y*this.max.y):(e+=t.normal.y*this.max.y,i+=t.normal.y*this.min.y),t.normal.z>0?(e+=t.normal.z*this.min.z,i+=t.normal.z*this.max.z):(e+=t.normal.z*this.max.z,i+=t.normal.z*this.min.z),e<=t.constant&&i>=t.constant},clampPoint:function(t,e){return(e||new $e).copy(t).clamp(this.min,this.max)},distanceToPoint:(er=new $e,function(t){return er.copy(t).clamp(this.min,this.max).sub(t).length()}),getBoundingSphere:(tr=new $e,function(t){var e=t||new _r;return this.getCenter(e.center),e.radius=.5*this.getSize(tr).length(),e}),intersect:function(t){return this.min.max(t.min),this.max.min(t.max),this.isEmpty()&&this.makeEmpty(),this},union:function(t){return this.min.min(t.min),this.max.max(t.max),this},applyMatrix4:(Qi=[new $e,new $e,new $e,new $e,new $e,new $e,new $e,new $e],function(t){return this.isEmpty()?this:(Qi[0].set(this.min.x,this.min.y,this.min.z).applyMatrix4(t),Qi[1].set(this.min.x,this.min.y,this.max.z).applyMatrix4(t),Qi[2].set(this.min.x,this.max.y,this.min.z).applyMatrix4(t),Qi[3].set(this.min.x,this.max.y,this.max.z).applyMatrix4(t),Qi[4].set(this.max.x,this.min.y,this.min.z).applyMatrix4(t),Qi[5].set(this.max.x,this.min.y,this.max.z).applyMatrix4(t),Qi[6].set(this.max.x,this.max.y,this.min.z).applyMatrix4(t),Qi[7].set(this.max.x,this.max.y,this.max.z).applyMatrix4(t),this.setFromPoints(Qi),this)}),translate:function(t){return this.min.add(t),this.max.add(t),this},equals:function(t){return t.min.equals(this.min)&&t.max.equals(this.max)}}),Object.assign(_r.prototype,{set:function(t,e){return this.center.copy(t),this.radius=e,this},setFromPoints:(nr=new xr,function(t,e){var i=this.center;void 0!==e?i.copy(e):nr.setFromPoints(t).getCenter(i);for(var r=0,n=0,o=t.length;n<o;n++)r=Math.max(r,i.distanceToSquared(t[n]));return this.radius=Math.sqrt(r),this}),clone:function(){return(new this.constructor).copy(this)},copy:function(t){return this.center.copy(t.center),this.radius=t.radius,this},empty:function(){return this.radius<=0},containsPoint:function(t){return t.distanceToSquared(this.center)<=this.radius*this.radius},distanceToPoint:function(t){return t.distanceTo(this.center)-this.radius},intersectsSphere:function(t){var e=this.radius+t.radius;return t.center.distanceToSquared(this.center)<=e*e},intersectsBox:function(t){return t.intersectsSphere(this)},intersectsPlane:function(t){return Math.abs(t.distanceToPoint(this.center))<=this.radius},clampPoint:function(t,e){var i=this.center.distanceToSquared(t),r=e||new $e;return r.copy(t),i>this.radius*this.radius&&(r.sub(this.center).normalize(),r.multiplyScalar(this.radius).add(this.center)),r},getBoundingBox:function(t){var e=t||new xr;return e.set(this.center,this.center),e.expandByScalar(this.radius),e},applyMatrix4:function(t){return this.center.applyMatrix4(t),this.radius=this.radius*t.getMaxScaleOnAxis(),this},translate:function(t){return this.center.add(t),this},equals:function(t){return t.center.equals(this.center)&&t.radius===this.radius}}),Object.assign(wr.prototype,{set:function(t,e){return this.normal.copy(t),this.constant=e,this},setComponents:function(t,e,i,r){return this.normal.set(t,e,i),this.constant=r,this},setFromNormalAndCoplanarPoint:function(t,e){return this.normal.copy(t),this.constant=-e.dot(this.normal),this},setFromCoplanarPoints:(cr=new $e,ur=new $e,function(t,e,i){var r=cr.subVectors(i,e).cross(ur.subVectors(t,e)).normalize();return this.setFromNormalAndCoplanarPoint(r,t),this}),clone:function(){return(new this.constructor).copy(this)},copy:function(t){return this.normal.copy(t.normal),this.constant=t.constant,this},normalize:function(){var t=1/this.normal.length();return this.normal.multiplyScalar(t),this.constant*=t,this},negate:function(){return this.constant*=-1,this.normal.negate(),this},distanceToPoint:function(t){return this.normal.dot(t)+this.constant},distanceToSphere:function(t){return this.distanceToPoint(t.center)-t.radius},projectPoint:function(t,e){return(e||new $e).copy(this.normal).multiplyScalar(-this.distanceToPoint(t)).add(t)},intersectLine:(sr=new $e,function(t,e){var i=e||new $e,r=t.delta(sr),n=this.normal.dot(r);if(0===n)return 0===this.distanceToPoint(t.start)?i.copy(t.start):void 0;var o=-(t.start.dot(this.normal)+this.constant)/n;return o<0||o>1?void 0:i.copy(r).multiplyScalar(o).add(t.start)}),intersectsLine:function(t){var e=this.distanceToPoint(t.start),i=this.distanceToPoint(t.end);return e<0&&i>0||i<0&&e>0},intersectsBox:function(t){return t.intersectsPlane(this)},intersectsSphere:function(t){return t.intersectsPlane(this)},coplanarPoint:function(t){return(t||new $e).copy(this.normal).multiplyScalar(-this.constant)},applyMatrix4:(or=new $e,ar=new We,function(t,e){var i=e||ar.getNormalMatrix(t),r=this.coplanarPoint(or).applyMatrix4(t),n=this.normal.applyMatrix3(i).normalize();return this.constant=-r.dot(n),this}),translate:function(t){return this.constant-=t.dot(this.normal),this},equals:function(t){return t.normal.equals(this.normal)&&t.constant===this.constant}}),Object.assign(Sr.prototype,{set:function(t,e,i,r,n,o){var a=this.planes;return a[0].copy(t),a[1].copy(e),a[2].copy(i),a[3].copy(r),a[4].copy(n),a[5].copy(o),this},clone:function(){return(new this.constructor).copy(this)},copy:function(t){for(var e=this.planes,i=0;i<6;i++)e[i].copy(t.planes[i]);return this},setFromMatrix:function(t){var e=this.planes,i=t.elements,r=i[0],n=i[1],o=i[2],a=i[3],s=i[4],c=i[5],u=i[6],h=i[7],l=i[8],p=i[9],d=i[10],f=i[11],m=i[12],g=i[13],v=i[14],y=i[15];return e[0].setComponents(a-r,h-s,f-l,y-m).normalize(),e[1].setComponents(a+r,h+s,f+l,y+m).normalize(),e[2].setComponents(a+n,h+c,f+p,y+g).normalize(),e[3].setComponents(a-n,h-c,f-p,y-g).normalize(),e[4].setComponents(a-o,h-u,f-d,y-v).normalize(),e[5].setComponents(a+o,h+u,f+d,y+v).normalize(),this},intersectsObject:(dr=new _r,function(t){var e=t.geometry;return null===e.boundingSphere&&e.computeBoundingSphere(),dr.copy(e.boundingSphere).applyMatrix4(t.matrixWorld),this.intersectsSphere(dr)}),intersectsSprite:(pr=new _r,function(t){return pr.center.set(0,0,0),pr.radius=.7071067811865476,pr.applyMatrix4(t.matrixWorld),this.intersectsSphere(pr)}),intersectsSphere:function(t){for(var e=this.planes,i=t.center,r=-t.radius,n=0;n<6;n++){if(e[n].distanceToPoint(i)<r)return!1}return!0},intersectsBox:(hr=new $e,lr=new $e,function(t){for(var e=this.planes,i=0;i<6;i++){var r=e[i];hr.x=r.normal.x>0?t.min.x:t.max.x,lr.x=r.normal.x>0?t.max.x:t.min.x,hr.y=r.normal.y>0?t.min.y:t.max.y,lr.y=r.normal.y>0?t.max.y:t.min.y,hr.z=r.normal.z>0?t.min.z:t.max.z,lr.z=r.normal.z>0?t.max.z:t.min.z;var n=r.distanceToPoint(hr),o=r.distanceToPoint(lr);if(n<0&&o<0)return!1}return!0}),containsPoint:function(t){for(var e=this.planes,i=0;i<6;i++)if(e[i].distanceToPoint(t)<0)return!1;return!0}}),Pr.RotationOrders=["XYZ","YZX","ZXY","XZY","YXZ","ZYX"],Pr.DefaultOrder="XYZ",Object.defineProperties(Pr.prototype,{x:{get:function(){return this._x},set:function(t){this._x=t,this.onChangeCallback()}},y:{get:function(){return this._y},set:function(t){this._y=t,this.onChangeCallback()}},z:{get:function(){return this._z},set:function(t){this._z=t,this.onChangeCallback()}},order:{get:function(){return this._order},set:function(t){this._order=t,this.onChangeCallback()}}}),Object.assign(Pr.prototype,{isEuler:!0,set:function(t,e,i,r){return this._x=t,this._y=e,this._z=i,this._order=r||this._order,this.onChangeCallback(),this},clone:function(){return new this.constructor(this._x,this._y,this._z,this._order)},copy:function(t){return this._x=t._x,this._y=t._y,this._z=t._z,this._order=t._order,this.onChangeCallback(),this},setFromRotationMatrix:function(t,e,i){var r=je.clamp,n=t.elements,o=n[0],a=n[4],s=n[8],c=n[1],u=n[5],h=n[9],l=n[2],p=n[6],d=n[10];return"XYZ"===(e=e||this._order)?(this._y=Math.asin(r(s,-1,1)),Math.abs(s)<.99999?(this._x=Math.atan2(-h,d),this._z=Math.atan2(-a,o)):(this._x=Math.atan2(p,u),this._z=0)):"YXZ"===e?(this._x=Math.asin(-r(h,-1,1)),Math.abs(h)<.99999?(this._y=Math.atan2(s,d),this._z=Math.atan2(c,u)):(this._y=Math.atan2(-l,o),this._z=0)):"ZXY"===e?(this._x=Math.asin(r(p,-1,1)),Math.abs(p)<.99999?(this._y=Math.atan2(-l,d),this._z=Math.atan2(-a,u)):(this._y=0,this._z=Math.atan2(c,o))):"ZYX"===e?(this._y=Math.asin(-r(l,-1,1)),Math.abs(l)<.99999?(this._x=Math.atan2(p,d),this._z=Math.atan2(c,o)):(this._x=0,this._z=Math.atan2(-a,u))):"YZX"===e?(this._z=Math.asin(r(c,-1,1)),Math.abs(c)<.99999?(this._x=Math.atan2(-h,u),this._y=Math.atan2(-l,o)):(this._x=0,this._y=Math.atan2(s,d))):"XZY"===e?(this._z=Math.asin(-r(a,-1,1)),Math.abs(a)<.99999?(this._x=Math.atan2(p,u),this._y=Math.atan2(s,o)):(this._x=Math.atan2(-h,d),this._y=0)):console.warn("THREE.Euler: .setFromRotationMatrix() given unsupported order: "+e),this._order=e,!1!==i&&this.onChangeCallback(),this},setFromQuaternion:(mr=new Ve,function(t,e,i){return mr.makeRotationFromQuaternion(t),this.setFromRotationMatrix(mr,e,i)}),setFromVector3:function(t,e){return this.set(t.x,t.y,t.z,e||this._order)},reorder:(fr=new He,function(t){return fr.setFromEuler(this),this.setFromQuaternion(fr,t)}),equals:function(t){return t._x===this._x&&t._y===this._y&&t._z===this._z&&t._order===this._order},fromArray:function(t){return this._x=t[0],this._y=t[1],this._z=t[2],void 0!==t[3]&&(this._order=t[3]),this.onChangeCallback(),this},toArray:function(t,e){return void 0===t&&(t=[]),void 0===e&&(e=0),t[e]=this._x,t[e+1]=this._y,t[e+2]=this._z,t[e+3]=this._order,t},toVector3:function(t){return t?t.set(this._x,this._y,this._z):new $e(this._x,this._y,this._z)},onChange:function(t){return this.onChangeCallback=t,this},onChangeCallback:function(){}}),Object.assign(Tr.prototype,{set:function(t){this.mask=1<<t|0},enable:function(t){this.mask|=1<<t|0},toggle:function(t){this.mask^=1<<t|0},disable:function(t){this.mask&=~(1<<t|0)},test:function(t){return 0!=(this.mask&t.mask)}});var Er,Cr,Ir,Rr,Lr,Or,Dr,kr,Nr,Br,Fr,zr,Ur,jr,Gr,Vr,Hr,$r,Wr,Xr=0;function qr(){Object.defineProperty(this,"id",{value:Xr++}),this.uuid=je.generateUUID(),this.name="",this.type="Object3D",this.parent=null,this.children=[],this.up=qr.DefaultUp.clone();var t=new $e,e=new Pr,i=new He,r=new $e(1,1,1);e.onChange(function(){i.setFromEuler(e,!1)}),i.onChange(function(){e.setFromQuaternion(i,void 0,!1)}),Object.defineProperties(this,{position:{enumerable:!0,value:t},rotation:{enumerable:!0,value:e},quaternion:{enumerable:!0,value:i},scale:{enumerable:!0,value:r},modelViewMatrix:{value:new Ve},normalMatrix:{value:new We}}),this.matrix=new Ve,this.matrixWorld=new Ve,this.matrixAutoUpdate=qr.DefaultMatrixAutoUpdate,this.matrixWorldNeedsUpdate=!1,this.layers=new Tr,this.visible=!0,this.castShadow=!1,this.receiveShadow=!1,this.frustumCulled=!0,this.renderOrder=0,this.userData={}}function Yr(){qr.call(this),this.type="Camera",this.matrixWorldInverse=new Ve,this.projectionMatrix=new Ve}function Zr(t,e,i,r,n,o){Yr.call(this),this.type="OrthographicCamera",this.zoom=1,this.view=null,this.left=t,this.right=e,this.top=i,this.bottom=r,this.near=void 0!==n?n:.1,this.far=void 0!==o?o:2e3,this.updateProjectionMatrix()}function Kr(t,e,i,r,n,o){this.a=t,this.b=e,this.c=i,this.normal=r&&r.isVector3?r:new $e,this.vertexNormals=Array.isArray(r)?r:[],this.color=n&&n.isColor?n:new Gi,this.vertexColors=Array.isArray(n)?n:[],this.materialIndex=void 0!==o?o:0}qr.DefaultUp=new $e(0,1,0),qr.DefaultMatrixAutoUpdate=!0,qr.prototype=Object.assign(Object.create(v.prototype),{constructor:qr,isObject3D:!0,onBeforeRender:function(){},onAfterRender:function(){},applyMatrix:function(t){this.matrix.multiplyMatrices(t,this.matrix),this.matrix.decompose(this.position,this.quaternion,this.scale)},applyQuaternion:function(t){return this.quaternion.premultiply(t),this},setRotationFromAxisAngle:function(t,e){this.quaternion.setFromAxisAngle(t,e)},setRotationFromEuler:function(t){this.quaternion.setFromEuler(t,!0)},setRotationFromMatrix:function(t){this.quaternion.setFromRotationMatrix(t)},setRotationFromQuaternion:function(t){this.quaternion.copy(t)},rotateOnAxis:($r=new He,function(t,e){return $r.setFromAxisAngle(t,e),this.quaternion.multiply($r),this}),rotateOnWorldAxis:(Hr=new He,function(t,e){return Hr.setFromAxisAngle(t,e),this.quaternion.premultiply(Hr),this}),rotateX:(Vr=new $e(1,0,0),function(t){return this.rotateOnAxis(Vr,t)}),rotateY:(Gr=new $e(0,1,0),function(t){return this.rotateOnAxis(Gr,t)}),rotateZ:(jr=new $e(0,0,1),function(t){return this.rotateOnAxis(jr,t)}),translateOnAxis:(Ur=new $e,function(t,e){return Ur.copy(t).applyQuaternion(this.quaternion),this.position.add(Ur.multiplyScalar(e)),this}),translateX:(zr=new $e(1,0,0),function(t){return this.translateOnAxis(zr,t)}),translateY:(Fr=new $e(0,1,0),function(t){return this.translateOnAxis(Fr,t)}),translateZ:(Br=new $e(0,0,1),function(t){return this.translateOnAxis(Br,t)}),localToWorld:function(t){return t.applyMatrix4(this.matrixWorld)},worldToLocal:(Nr=new Ve,function(t){return t.applyMatrix4(Nr.getInverse(this.matrixWorld))}),lookAt:(Dr=new Ve,kr=new $e,function(t,e,i){t.isVector3?kr.copy(t):kr.set(t,e,i),this.isCamera?Dr.lookAt(this.position,kr,this.up):Dr.lookAt(kr,this.position,this.up),this.quaternion.setFromRotationMatrix(Dr)}),add:function(t){var e=arguments;if(arguments.length>1){for(var i=0;i<arguments.length;i++)this.add(e[i]);return this}return t===this?(console.error("THREE.Object3D.add: object can't be added as a child of itself.",t),this):(t&&t.isObject3D?(null!==t.parent&&t.parent.remove(t),t.parent=this,t.dispatchEvent({type:"added"}),this.children.push(t)):console.error("THREE.Object3D.add: object not an instance of THREE.Object3D.",t),this)},remove:function(t){var e=arguments;if(arguments.length>1){for(var i=0;i<arguments.length;i++)this.remove(e[i]);return this}var r=this.children.indexOf(t);return-1!==r&&(t.parent=null,t.dispatchEvent({type:"removed"}),this.children.splice(r,1)),this},getObjectById:function(t){return this.getObjectByProperty("id",t)},getObjectByName:function(t){return this.getObjectByProperty("name",t)},getObjectByProperty:function(t,e){if(this[t]===e)return this;for(var i=0,r=this.children.length;i<r;i++){var n=this.children[i].getObjectByProperty(t,e);if(void 0!==n)return n}},getWorldPosition:function(t){var e=t||new $e;return this.updateMatrixWorld(!0),e.setFromMatrixPosition(this.matrixWorld)},getWorldQuaternion:(Lr=new $e,Or=new $e,function(t){var e=t||new He;return this.updateMatrixWorld(!0),this.matrixWorld.decompose(Lr,e,Or),e}),getWorldRotation:(Rr=new He,function(t){var e=t||new Pr;return this.getWorldQuaternion(Rr),e.setFromQuaternion(Rr,this.rotation.order,!1)}),getWorldScale:(Cr=new $e,Ir=new He,function(t){var e=t||new $e;return this.updateMatrixWorld(!0),this.matrixWorld.decompose(Cr,Ir,e),e}),getWorldDirection:(Er=new He,function(t){var e=t||new $e;return this.getWorldQuaternion(Er),e.set(0,0,1).applyQuaternion(Er)}),raycast:function(){},traverse:function(t){t(this);for(var e=this.children,i=0,r=e.length;i<r;i++)e[i].traverse(t)},traverseVisible:function(t){if(!1!==this.visible){t(this);for(var e=this.children,i=0,r=e.length;i<r;i++)e[i].traverseVisible(t)}},traverseAncestors:function(t){var e=this.parent;null!==e&&(t(e),e.traverseAncestors(t))},updateMatrix:function(){this.matrix.compose(this.position,this.quaternion,this.scale),this.matrixWorldNeedsUpdate=!0},updateMatrixWorld:function(t){this.matrixAutoUpdate&&this.updateMatrix(),(this.matrixWorldNeedsUpdate||t)&&(null===this.parent?this.matrixWorld.copy(this.matrix):this.matrixWorld.multiplyMatrices(this.parent.matrixWorld,this.matrix),this.matrixWorldNeedsUpdate=!1,t=!0);for(var e=this.children,i=0,r=e.length;i<r;i++)e[i].updateMatrixWorld(t)},toJSON:function(t){var e=void 0===t||"string"==typeof t,i={};e&&(t={geometries:{},materials:{},textures:{},images:{},shapes:{}},i.metadata={version:4.5,type:"Object",generator:"Object3D.toJSON"});var r={};function n(e,i){return void 0===e[i.uuid]&&(e[i.uuid]=i.toJSON(t)),i.uuid}if(r.uuid=this.uuid,r.type=this.type,""!==this.name&&(r.name=this.name),!0===this.castShadow&&(r.castShadow=!0),!0===this.receiveShadow&&(r.receiveShadow=!0),!1===this.visible&&(r.visible=!1),"{}"!==JSON.stringify(this.userData)&&(r.userData=this.userData),r.matrix=this.matrix.toArray(),void 0!==this.geometry){r.geometry=n(t.geometries,this.geometry);var o=this.geometry.parameters;if(void 0!==o&&void 0!==o.shapes){var a=o.shapes;if(Array.isArray(a))for(var s=0,c=a.length;s<c;s++){var u=a[s];n(t.shapes,u)}else n(t.shapes,a)}}if(void 0!==this.material)if(Array.isArray(this.material)){var h=[];for(s=0,c=this.material.length;s<c;s++)h.push(n(t.materials,this.material[s]));r.material=h}else r.material=n(t.materials,this.material);if(this.children.length>0){r.children=[];for(s=0;s<this.children.length;s++)r.children.push(this.children[s].toJSON(t).object)}if(e){var l=m(t.geometries),p=m(t.materials),d=m(t.textures),f=m(t.images);a=m(t.shapes);l.length>0&&(i.geometries=l),p.length>0&&(i.materials=p),d.length>0&&(i.textures=d),f.length>0&&(i.images=f),a.length>0&&(i.shapes=a)}return i.object=r,i;function m(t){var e=[];for(var i in t){var r=t[i];delete r.metadata,e.push(r)}return e}},clone:function(t){return(new this.constructor).copy(this,t)},copy:function(t,e){if(void 0===e&&(e=!0),this.name=t.name,this.up.copy(t.up),this.position.copy(t.position),this.quaternion.copy(t.quaternion),this.scale.copy(t.scale),this.matrix.copy(t.matrix),this.matrixWorld.copy(t.matrixWorld),this.matrixAutoUpdate=t.matrixAutoUpdate,this.matrixWorldNeedsUpdate=t.matrixWorldNeedsUpdate,this.layers.mask=t.layers.mask,this.visible=t.visible,this.castShadow=t.castShadow,this.receiveShadow=t.receiveShadow,this.frustumCulled=t.frustumCulled,this.renderOrder=t.renderOrder,this.userData=JSON.parse(JSON.stringify(t.userData)),!0===e)for(var i=0;i<t.children.length;i++){var r=t.children[i];this.add(r.clone())}return this}}),Yr.prototype=Object.assign(Object.create(qr.prototype),{constructor:Yr,isCamera:!0,copy:function(t,e){return qr.prototype.copy.call(this,t,e),this.matrixWorldInverse.copy(t.matrixWorldInverse),this.projectionMatrix.copy(t.projectionMatrix),this},getWorldDirection:(Wr=new He,function(t){var e=t||new $e;return this.getWorldQuaternion(Wr),e.set(0,0,-1).applyQuaternion(Wr)}),updateMatrixWorld:function(t){qr.prototype.updateMatrixWorld.call(this,t),this.matrixWorldInverse.getInverse(this.matrixWorld)},clone:function(){return(new this.constructor).copy(this)}}),Zr.prototype=Object.assign(Object.create(Yr.prototype),{constructor:Zr,isOrthographicCamera:!0,copy:function(t,e){return Yr.prototype.copy.call(this,t,e),this.left=t.left,this.right=t.right,this.top=t.top,this.bottom=t.bottom,this.near=t.near,this.far=t.far,this.zoom=t.zoom,this.view=null===t.view?null:Object.assign({},t.view),this},setViewOffset:function(t,e,i,r,n,o){null===this.view&&(this.view={enabled:!0,fullWidth:1,fullHeight:1,offsetX:0,offsetY:0,width:1,height:1}),this.view.enabled=!0,this.view.fullWidth=t,this.view.fullHeight=e,this.view.offsetX=i,this.view.offsetY=r,this.view.width=n,this.view.height=o,this.updateProjectionMatrix()},clearViewOffset:function(){null!==this.view&&(this.view.enabled=!1),this.updateProjectionMatrix()},updateProjectionMatrix:function(){var t=(this.right-this.left)/(2*this.zoom),e=(this.top-this.bottom)/(2*this.zoom),i=(this.right+this.left)/2,r=(this.top+this.bottom)/2,n=i-t,o=i+t,a=r+e,s=r-e;if(null!==this.view&&this.view.enabled){var c=this.zoom/(this.view.width/this.view.fullWidth),u=this.zoom/(this.view.height/this.view.fullHeight),h=(this.right-this.left)/this.view.width,l=(this.top-this.bottom)/this.view.height;o=(n+=h*(this.view.offsetX/c))+h*(this.view.width/c),s=(a-=l*(this.view.offsetY/u))-l*(this.view.height/u)}this.projectionMatrix.makeOrthographic(n,o,a,s,this.near,this.far)},toJSON:function(t){var e=qr.prototype.toJSON.call(this,t);return e.object.zoom=this.zoom,e.object.left=this.left,e.object.right=this.right,e.object.top=this.top,e.object.bottom=this.bottom,e.object.near=this.near,e.object.far=this.far,null!==this.view&&(e.object.view=Object.assign({},this.view)),e}}),Object.assign(Kr.prototype,{clone:function(){return(new this.constructor).copy(this)},copy:function(t){this.a=t.a,this.b=t.b,this.c=t.c,this.normal.copy(t.normal),this.color.copy(t.color),this.materialIndex=t.materialIndex;for(var e=0,i=t.vertexNormals.length;e<i;e++)this.vertexNormals[e]=t.vertexNormals[e].clone();for(e=0,i=t.vertexColors.length;e<i;e++)this.vertexColors[e]=t.vertexColors[e].clone();return this}});var Jr,Qr,tn,en,rn,nn,on=0;function an(){Object.defineProperty(this,"id",{value:on+=2}),this.uuid=je.generateUUID(),this.name="",this.type="Geometry",this.vertices=[],this.colors=[],this.faces=[],this.faceVertexUvs=[[]],this.morphTargets=[],this.morphNormals=[],this.skinWeights=[],this.skinIndices=[],this.lineDistances=[],this.boundingBox=null,this.boundingSphere=null,this.elementsNeedUpdate=!1,this.verticesNeedUpdate=!1,this.uvsNeedUpdate=!1,this.normalsNeedUpdate=!1,this.colorsNeedUpdate=!1,this.lineDistancesNeedUpdate=!1,this.groupsNeedUpdate=!1}function sn(t,e,i){if(Array.isArray(t))throw new TypeError("THREE.BufferAttribute: array should be a Typed Array.");this.uuid=je.generateUUID(),this.name="",this.array=t,this.itemSize=e,this.count=void 0!==t?t.length/e:0,this.normalized=!0===i,this.dynamic=!1,this.updateRange={offset:0,count:-1},this.onUploadCallback=function(){},this.version=0}function cn(t,e,i){sn.call(this,new Int8Array(t),e,i)}function un(t,e,i){sn.call(this,new Uint8Array(t),e,i)}function hn(t,e,i){sn.call(this,new Uint8ClampedArray(t),e,i)}function ln(t,e,i){sn.call(this,new Int16Array(t),e,i)}function pn(t,e,i){sn.call(this,new Uint16Array(t),e,i)}function dn(t,e,i){sn.call(this,new Int32Array(t),e,i)}function fn(t,e,i){sn.call(this,new Uint32Array(t),e,i)}function mn(t,e,i){sn.call(this,new Float32Array(t),e,i)}function gn(t,e,i){sn.call(this,new Float64Array(t),e,i)}function vn(){this.indices=[],this.vertices=[],this.normals=[],this.colors=[],this.uvs=[],this.uvs2=[],this.groups=[],this.morphTargets={},this.skinWeights=[],this.skinIndices=[],this.boundingBox=null,this.boundingSphere=null,this.verticesNeedUpdate=!1,this.normalsNeedUpdate=!1,this.colorsNeedUpdate=!1,this.uvsNeedUpdate=!1,this.groupsNeedUpdate=!1}function yn(t){if(0===t.length)return-1/0;for(var e=t[0],i=1,r=t.length;i<r;++i)t[i]>e&&(e=t[i]);return e}an.prototype=Object.assign(Object.create(v.prototype),{constructor:an,isGeometry:!0,applyMatrix:function(t){for(var e=(new We).getNormalMatrix(t),i=0,r=this.vertices.length;i<r;i++){this.vertices[i].applyMatrix4(t)}for(i=0,r=this.faces.length;i<r;i++){var n=this.faces[i];n.normal.applyMatrix3(e).normalize();for(var o=0,a=n.vertexNormals.length;o<a;o++)n.vertexNormals[o].applyMatrix3(e).normalize()}return null!==this.boundingBox&&this.computeBoundingBox(),null!==this.boundingSphere&&this.computeBoundingSphere(),this.verticesNeedUpdate=!0,this.normalsNeedUpdate=!0,this},rotateX:(nn=new Ve,function(t){return nn.makeRotationX(t),this.applyMatrix(nn),this}),rotateY:(rn=new Ve,function(t){return rn.makeRotationY(t),this.applyMatrix(rn),this}),rotateZ:(en=new Ve,function(t){return en.makeRotationZ(t),this.applyMatrix(en),this}),translate:(tn=new Ve,function(t,e,i){return tn.makeTranslation(t,e,i),this.applyMatrix(tn),this}),scale:(Qr=new Ve,function(t,e,i){return Qr.makeScale(t,e,i),this.applyMatrix(Qr),this}),lookAt:(Jr=new qr,function(t){Jr.lookAt(t),Jr.updateMatrix(),this.applyMatrix(Jr.matrix)}),fromBufferGeometry:function(t){var e=this,i=null!==t.index?t.index.array:void 0,r=t.attributes,n=r.position.array,o=void 0!==r.normal?r.normal.array:void 0,a=void 0!==r.color?r.color.array:void 0,s=void 0!==r.uv?r.uv.array:void 0,c=void 0!==r.uv2?r.uv2.array:void 0;void 0!==c&&(this.faceVertexUvs[1]=[]);for(var u=[],h=[],l=[],p=0,d=0;p<n.length;p+=3,d+=2)e.vertices.push(new $e(n[p],n[p+1],n[p+2])),void 0!==o&&u.push(new $e(o[p],o[p+1],o[p+2])),void 0!==a&&e.colors.push(new Gi(a[p],a[p+1],a[p+2])),void 0!==s&&h.push(new Ge(s[d],s[d+1])),void 0!==c&&l.push(new Ge(c[d],c[d+1]));function f(t,i,r,n){var p=new Kr(t,i,r,void 0!==o?[u[t].clone(),u[i].clone(),u[r].clone()]:[],void 0!==a?[e.colors[t].clone(),e.colors[i].clone(),e.colors[r].clone()]:[],n);e.faces.push(p),void 0!==s&&e.faceVertexUvs[0].push([h[t].clone(),h[i].clone(),h[r].clone()]),void 0!==c&&e.faceVertexUvs[1].push([l[t].clone(),l[i].clone(),l[r].clone()])}var m=t.groups;if(m.length>0)for(p=0;p<m.length;p++)for(var g=m[p],v=g.start,y=(d=v,v+g.count);d<y;d+=3)void 0!==i?f(i[d],i[d+1],i[d+2],g.materialIndex):f(d,d+1,d+2,g.materialIndex);else if(void 0!==i)for(p=0;p<i.length;p+=3)f(i[p],i[p+1],i[p+2]);else for(p=0;p<n.length/3;p+=3)f(p,p+1,p+2);return this.computeFaceNormals(),null!==t.boundingBox&&(this.boundingBox=t.boundingBox.clone()),null!==t.boundingSphere&&(this.boundingSphere=t.boundingSphere.clone()),this},center:function(){this.computeBoundingBox();var t=this.boundingBox.getCenter().negate();return this.translate(t.x,t.y,t.z),t},normalize:function(){this.computeBoundingSphere();var t=this.boundingSphere.center,e=this.boundingSphere.radius,i=0===e?1:1/e,r=new Ve;return r.set(i,0,0,-i*t.x,0,i,0,-i*t.y,0,0,i,-i*t.z,0,0,0,1),this.applyMatrix(r),this},computeFaceNormals:function(){for(var t=new $e,e=new $e,i=0,r=this.faces.length;i<r;i++){var n=this.faces[i],o=this.vertices[n.a],a=this.vertices[n.b],s=this.vertices[n.c];t.subVectors(s,a),e.subVectors(o,a),t.cross(e),t.normalize(),n.normal.copy(t)}},computeVertexNormals:function(t){var e,i,r,n,o,a;for(void 0===t&&(t=!0),a=new Array(this.vertices.length),e=0,i=this.vertices.length;e<i;e++)a[e]=new $e;if(t){var s,c,u,h=new $e,l=new $e;for(r=0,n=this.faces.length;r<n;r++)o=this.faces[r],s=this.vertices[o.a],c=this.vertices[o.b],u=this.vertices[o.c],h.subVectors(u,c),l.subVectors(s,c),h.cross(l),a[o.a].add(h),a[o.b].add(h),a[o.c].add(h)}else for(this.computeFaceNormals(),r=0,n=this.faces.length;r<n;r++)a[(o=this.faces[r]).a].add(o.normal),a[o.b].add(o.normal),a[o.c].add(o.normal);for(e=0,i=this.vertices.length;e<i;e++)a[e].normalize();for(r=0,n=this.faces.length;r<n;r++){var p=(o=this.faces[r]).vertexNormals;3===p.length?(p[0].copy(a[o.a]),p[1].copy(a[o.b]),p[2].copy(a[o.c])):(p[0]=a[o.a].clone(),p[1]=a[o.b].clone(),p[2]=a[o.c].clone())}this.faces.length>0&&(this.normalsNeedUpdate=!0)},computeFlatVertexNormals:function(){var t,e,i;for(this.computeFaceNormals(),t=0,e=this.faces.length;t<e;t++){var r=(i=this.faces[t]).vertexNormals;3===r.length?(r[0].copy(i.normal),r[1].copy(i.normal),r[2].copy(i.normal)):(r[0]=i.normal.clone(),r[1]=i.normal.clone(),r[2]=i.normal.clone())}this.faces.length>0&&(this.normalsNeedUpdate=!0)},computeMorphNormals:function(){var t,e,i,r,n,o=this;for(i=0,r=this.faces.length;i<r;i++)for((n=o.faces[i]).__originalFaceNormal?n.__originalFaceNormal.copy(n.normal):n.__originalFaceNormal=n.normal.clone(),n.__originalVertexNormals||(n.__originalVertexNormals=[]),t=0,e=n.vertexNormals.length;t<e;t++)n.__originalVertexNormals[t]?n.__originalVertexNormals[t].copy(n.vertexNormals[t]):n.__originalVertexNormals[t]=n.vertexNormals[t].clone();var a=new an;for(a.faces=this.faces,t=0,e=this.morphTargets.length;t<e;t++){if(!o.morphNormals[t]){o.morphNormals[t]={},o.morphNormals[t].faceNormals=[],o.morphNormals[t].vertexNormals=[];var s=o.morphNormals[t].faceNormals,c=o.morphNormals[t].vertexNormals;for(i=0,r=this.faces.length;i<r;i++)u=new $e,h={a:new $e,b:new $e,c:new $e},s.push(u),c.push(h)}var u,h,l=o.morphNormals[t];for(a.vertices=o.morphTargets[t].vertices,a.computeFaceNormals(),a.computeVertexNormals(),i=0,r=this.faces.length;i<r;i++)n=o.faces[i],u=l.faceNormals[i],h=l.vertexNormals[i],u.copy(n.normal),h.a.copy(n.vertexNormals[0]),h.b.copy(n.vertexNormals[1]),h.c.copy(n.vertexNormals[2])}for(i=0,r=this.faces.length;i<r;i++)(n=o.faces[i]).normal=n.__originalFaceNormal,n.vertexNormals=n.__originalVertexNormals},computeLineDistances:function(){for(var t=0,e=this.vertices,i=0,r=e.length;i<r;i++)i>0&&(t+=e[i].distanceTo(e[i-1])),this.lineDistances[i]=t},computeBoundingBox:function(){null===this.boundingBox&&(this.boundingBox=new xr),this.boundingBox.setFromPoints(this.vertices)},computeBoundingSphere:function(){null===this.boundingSphere&&(this.boundingSphere=new _r),this.boundingSphere.setFromPoints(this.vertices)},merge:function(t,e,i){if(t&&t.isGeometry){var r,n=this.vertices.length,o=this.vertices,a=t.vertices,s=this.faces,c=t.faces,u=this.faceVertexUvs[0],h=t.faceVertexUvs[0],l=this.colors,p=t.colors;void 0===i&&(i=0),void 0!==e&&(r=(new We).getNormalMatrix(e));for(var d=0,f=a.length;d<f;d++){var m=a[d].clone();void 0!==e&&m.applyMatrix4(e),o.push(m)}for(d=0,f=p.length;d<f;d++)l.push(p[d].clone());for(d=0,f=c.length;d<f;d++){var g,v,y,b=c[d],x=b.vertexNormals,_=b.vertexColors;(g=new Kr(b.a+n,b.b+n,b.c+n)).normal.copy(b.normal),void 0!==r&&g.normal.applyMatrix3(r).normalize();for(var w=0,S=x.length;w<S;w++)v=x[w].clone(),void 0!==r&&v.applyMatrix3(r).normalize(),g.vertexNormals.push(v);g.color.copy(b.color);for(w=0,S=_.length;w<S;w++)y=_[w],g.vertexColors.push(y.clone());g.materialIndex=b.materialIndex+i,s.push(g)}for(d=0,f=h.length;d<f;d++){var A=h[d],M=[];if(void 0!==A){for(w=0,S=A.length;w<S;w++)M.push(A[w].clone());u.push(M)}}}else console.error("THREE.Geometry.merge(): geometry not an instance of THREE.Geometry.",t)},mergeMesh:function(t){t&&t.isMesh?(t.matrixAutoUpdate&&t.updateMatrix(),this.merge(t.geometry,t.matrix)):console.error("THREE.Geometry.mergeMesh(): mesh not an instance of THREE.Mesh.",t)},mergeVertices:function(){var t,e,i,r,n,o,a,s,c={},u=[],h=[],l=Math.pow(10,4);for(i=0,r=this.vertices.length;i<r;i++)t=this.vertices[i],void 0===c[e=Math.round(t.x*l)+"_"+Math.round(t.y*l)+"_"+Math.round(t.z*l)]?(c[e]=i,u.push(this.vertices[i]),h[i]=u.length-1):h[i]=h[c[e]];var p=[];for(i=0,r=this.faces.length;i<r;i++){(n=this.faces[i]).a=h[n.a],n.b=h[n.b],n.c=h[n.c],o=[n.a,n.b,n.c];for(var d=0;d<3;d++)if(o[d]===o[(d+1)%3]){p.push(i);break}}for(i=p.length-1;i>=0;i--){var f=p[i];for(this.faces.splice(f,1),a=0,s=this.faceVertexUvs.length;a<s;a++)this.faceVertexUvs[a].splice(f,1)}var m=this.vertices.length-u.length;return this.vertices=u,m},setFromPoints:function(t){this.vertices=[];for(var e=0,i=t.length;e<i;e++){var r=t[e];this.vertices.push(new $e(r.x,r.y,r.z||0))}return this},sortFacesByMaterialIndex:function(){for(var t=this.faces,e=t.length,i=0;i<e;i++)t[i]._id=i;t.sort(function(t,e){return t.materialIndex-e.materialIndex});var r,n,o=this.faceVertexUvs[0],a=this.faceVertexUvs[1];o&&o.length===e&&(r=[]),a&&a.length===e&&(n=[]);for(i=0;i<e;i++){var s=t[i]._id;r&&r.push(o[s]),n&&n.push(a[s])}r&&(this.faceVertexUvs[0]=r),n&&(this.faceVertexUvs[1]=n)},toJSON:function(){var t={metadata:{version:4.5,type:"Geometry",generator:"Geometry.toJSON"}};if(t.uuid=this.uuid,t.type=this.type,""!==this.name&&(t.name=this.name),void 0!==this.parameters){var e=this.parameters;for(var i in e)void 0!==e[i]&&(t[i]=e[i]);return t}for(var r=[],n=0;n<this.vertices.length;n++){var o=this.vertices[n];r.push(o.x,o.y,o.z)}var a=[],s=[],c={},u=[],h={},l=[],p={};for(n=0;n<this.faces.length;n++){var d=this.faces[n],f=void 0!==this.faceVertexUvs[0][n],m=d.normal.length()>0,g=d.vertexNormals.length>0,v=1!==d.color.r||1!==d.color.g||1!==d.color.b,y=d.vertexColors.length>0,b=0;if(b=S(b=S(b=S(b=S(b=S(b=S(b=S(b=S(b,0,0),1,!0),2,!1),3,f),4,m),5,g),6,v),7,y),a.push(b),a.push(d.a,d.b,d.c),a.push(d.materialIndex),f){var x=this.faceVertexUvs[0][n];a.push(P(x[0]),P(x[1]),P(x[2]))}if(m&&a.push(A(d.normal)),g){var _=d.vertexNormals;a.push(A(_[0]),A(_[1]),A(_[2]))}if(v&&a.push(M(d.color)),y){var w=d.vertexColors;a.push(M(w[0]),M(w[1]),M(w[2]))}}function S(t,e,i){return i?t|1<<e:t&~(1<<e)}function A(t){var e=t.x.toString()+t.y.toString()+t.z.toString();return void 0!==c[e]?c[e]:(c[e]=s.length/3,s.push(t.x,t.y,t.z),c[e])}function M(t){var e=t.r.toString()+t.g.toString()+t.b.toString();return void 0!==h[e]?h[e]:(h[e]=u.length,u.push(t.getHex()),h[e])}function P(t){var e=t.x.toString()+t.y.toString();return void 0!==p[e]?p[e]:(p[e]=l.length/2,l.push(t.x,t.y),p[e])}return t.data={},t.data.vertices=r,t.data.normals=s,u.length>0&&(t.data.colors=u),l.length>0&&(t.data.uvs=[l]),t.data.faces=a,t},clone:function(){return(new an).copy(this)},copy:function(t){var e,i,r,n,o,a,s=this;this.vertices=[],this.colors=[],this.faces=[],this.faceVertexUvs=[[]],this.morphTargets=[],this.morphNormals=[],this.skinWeights=[],this.skinIndices=[],this.lineDistances=[],this.boundingBox=null,this.boundingSphere=null,this.name=t.name;var c=t.vertices;for(e=0,i=c.length;e<i;e++)s.vertices.push(c[e].clone());var u=t.colors;for(e=0,i=u.length;e<i;e++)s.colors.push(u[e].clone());var h=t.faces;for(e=0,i=h.length;e<i;e++)s.faces.push(h[e].clone());for(e=0,i=t.faceVertexUvs.length;e<i;e++){var l=t.faceVertexUvs[e];for(void 0===s.faceVertexUvs[e]&&(s.faceVertexUvs[e]=[]),r=0,n=l.length;r<n;r++){var p=l[r],d=[];for(o=0,a=p.length;o<a;o++){var f=p[o];d.push(f.clone())}s.faceVertexUvs[e].push(d)}}var m=t.morphTargets;for(e=0,i=m.length;e<i;e++){var g={};if(g.name=m[e].name,void 0!==m[e].vertices)for(g.vertices=[],r=0,n=m[e].vertices.length;r<n;r++)g.vertices.push(m[e].vertices[r].clone());if(void 0!==m[e].normals)for(g.normals=[],r=0,n=m[e].normals.length;r<n;r++)g.normals.push(m[e].normals[r].clone());s.morphTargets.push(g)}var v=t.morphNormals;for(e=0,i=v.length;e<i;e++){var y={};if(void 0!==v[e].vertexNormals)for(y.vertexNormals=[],r=0,n=v[e].vertexNormals.length;r<n;r++){var b=v[e].vertexNormals[r],x={};x.a=b.a.clone(),x.b=b.b.clone(),x.c=b.c.clone(),y.vertexNormals.push(x)}if(void 0!==v[e].faceNormals)for(y.faceNormals=[],r=0,n=v[e].faceNormals.length;r<n;r++)y.faceNormals.push(v[e].faceNormals[r].clone());s.morphNormals.push(y)}var _=t.skinWeights;for(e=0,i=_.length;e<i;e++)s.skinWeights.push(_[e].clone());var w=t.skinIndices;for(e=0,i=w.length;e<i;e++)s.skinIndices.push(w[e].clone());var S=t.lineDistances;for(e=0,i=S.length;e<i;e++)s.lineDistances.push(S[e]);var A=t.boundingBox;null!==A&&(this.boundingBox=A.clone());var M=t.boundingSphere;return null!==M&&(this.boundingSphere=M.clone()),this.elementsNeedUpdate=t.elementsNeedUpdate,this.verticesNeedUpdate=t.verticesNeedUpdate,this.uvsNeedUpdate=t.uvsNeedUpdate,this.normalsNeedUpdate=t.normalsNeedUpdate,this.colorsNeedUpdate=t.colorsNeedUpdate,this.lineDistancesNeedUpdate=t.lineDistancesNeedUpdate,this.groupsNeedUpdate=t.groupsNeedUpdate,this},dispose:function(){this.dispatchEvent({type:"dispose"})}}),Object.defineProperty(sn.prototype,"needsUpdate",{set:function(t){!0===t&&this.version++}}),Object.assign(sn.prototype,{isBufferAttribute:!0,setArray:function(t){if(Array.isArray(t))throw new TypeError("THREE.BufferAttribute: array should be a Typed Array.");this.count=void 0!==t?t.length/this.itemSize:0,this.array=t},setDynamic:function(t){return this.dynamic=t,this},copy:function(t){return this.array=new t.array.constructor(t.array),this.itemSize=t.itemSize,this.count=t.count,this.normalized=t.normalized,this.dynamic=t.dynamic,this},copyAt:function(t,e,i){t*=this.itemSize,i*=e.itemSize;for(var r=0,n=this.itemSize;r<n;r++)this.array[t+r]=e.array[i+r];return this},copyArray:function(t){return this.array.set(t),this},copyColorsArray:function(t){for(var e=this.array,i=0,r=0,n=t.length;r<n;r++){var o=t[r];void 0===o&&(console.warn("THREE.BufferAttribute.copyColorsArray(): color is undefined",r),o=new Gi),e[i++]=o.r,e[i++]=o.g,e[i++]=o.b}return this},copyIndicesArray:function(t){for(var e=this.array,i=0,r=0,n=t.length;r<n;r++){var o=t[r];e[i++]=o.a,e[i++]=o.b,e[i++]=o.c}return this},copyVector2sArray:function(t){for(var e=this.array,i=0,r=0,n=t.length;r<n;r++){var o=t[r];void 0===o&&(console.warn("THREE.BufferAttribute.copyVector2sArray(): vector is undefined",r),o=new Ge),e[i++]=o.x,e[i++]=o.y}return this},copyVector3sArray:function(t){for(var e=this.array,i=0,r=0,n=t.length;r<n;r++){var o=t[r];void 0===o&&(console.warn("THREE.BufferAttribute.copyVector3sArray(): vector is undefined",r),o=new $e),e[i++]=o.x,e[i++]=o.y,e[i++]=o.z}return this},copyVector4sArray:function(t){for(var e=this.array,i=0,r=0,n=t.length;r<n;r++){var o=t[r];void 0===o&&(console.warn("THREE.BufferAttribute.copyVector4sArray(): vector is undefined",r),o=new Ke),e[i++]=o.x,e[i++]=o.y,e[i++]=o.z,e[i++]=o.w}return this},set:function(t,e){return void 0===e&&(e=0),this.array.set(t,e),this},getX:function(t){return this.array[t*this.itemSize]},setX:function(t,e){return this.array[t*this.itemSize]=e,this},getY:function(t){return this.array[t*this.itemSize+1]},setY:function(t,e){return this.array[t*this.itemSize+1]=e,this},getZ:function(t){return this.array[t*this.itemSize+2]},setZ:function(t,e){return this.array[t*this.itemSize+2]=e,this},getW:function(t){return this.array[t*this.itemSize+3]},setW:function(t,e){return this.array[t*this.itemSize+3]=e,this},setXY:function(t,e,i){return t*=this.itemSize,this.array[t+0]=e,this.array[t+1]=i,this},setXYZ:function(t,e,i,r){return t*=this.itemSize,this.array[t+0]=e,this.array[t+1]=i,this.array[t+2]=r,this},setXYZW:function(t,e,i,r,n){return t*=this.itemSize,this.array[t+0]=e,this.array[t+1]=i,this.array[t+2]=r,this.array[t+3]=n,this},onUpload:function(t){return this.onUploadCallback=t,this},clone:function(){return new this.constructor(this.array,this.itemSize).copy(this)}}),cn.prototype=Object.create(sn.prototype),cn.prototype.constructor=cn,un.prototype=Object.create(sn.prototype),un.prototype.constructor=un,hn.prototype=Object.create(sn.prototype),hn.prototype.constructor=hn,ln.prototype=Object.create(sn.prototype),ln.prototype.constructor=ln,pn.prototype=Object.create(sn.prototype),pn.prototype.constructor=pn,dn.prototype=Object.create(sn.prototype),dn.prototype.constructor=dn,fn.prototype=Object.create(sn.prototype),fn.prototype.constructor=fn,mn.prototype=Object.create(sn.prototype),mn.prototype.constructor=mn,gn.prototype=Object.create(sn.prototype),gn.prototype.constructor=gn,Object.assign(vn.prototype,{computeGroups:function(t){for(var e,i=[],r=void 0,n=t.faces,o=0;o<n.length;o++){var a=n[o];a.materialIndex!==r&&(r=a.materialIndex,void 0!==e&&(e.count=3*o-e.start,i.push(e)),e={start:3*o,materialIndex:r})}void 0!==e&&(e.count=3*o-e.start,i.push(e)),this.groups=i},fromGeometry:function(t){var e,i=this,r=t.faces,n=t.vertices,o=t.faceVertexUvs,a=o[0]&&o[0].length>0,s=o[1]&&o[1].length>0,c=t.morphTargets,u=c.length;if(u>0){e=[];for(var h=0;h<u;h++)e[h]=[];this.morphTargets.position=e}var l,p=t.morphNormals,d=p.length;if(d>0){l=[];for(h=0;h<d;h++)l[h]=[];this.morphTargets.normal=l}var f=t.skinIndices,m=t.skinWeights,g=f.length===n.length,v=m.length===n.length;for(h=0;h<r.length;h++){var y=r[h];i.vertices.push(n[y.a],n[y.b],n[y.c]);var b=y.vertexNormals;if(3===b.length)i.normals.push(b[0],b[1],b[2]);else{var x=y.normal;i.normals.push(x,x,x)}var _,w=y.vertexColors;if(3===w.length)i.colors.push(w[0],w[1],w[2]);else{var S=y.color;i.colors.push(S,S,S)}if(!0===a)void 0!==(_=o[0][h])?i.uvs.push(_[0],_[1],_[2]):(console.warn("THREE.DirectGeometry.fromGeometry(): Undefined vertexUv ",h),i.uvs.push(new Ge,new Ge,new Ge));if(!0===s)void 0!==(_=o[1][h])?i.uvs2.push(_[0],_[1],_[2]):(console.warn("THREE.DirectGeometry.fromGeometry(): Undefined vertexUv2 ",h),i.uvs2.push(new Ge,new Ge,new Ge));for(var A=0;A<u;A++){var M=c[A].vertices;e[A].push(M[y.a],M[y.b],M[y.c])}for(A=0;A<d;A++){var P=p[A].vertexNormals[h];l[A].push(P.a,P.b,P.c)}g&&i.skinIndices.push(f[y.a],f[y.b],f[y.c]),v&&i.skinWeights.push(m[y.a],m[y.b],m[y.c])}return this.computeGroups(t),this.verticesNeedUpdate=t.verticesNeedUpdate,this.normalsNeedUpdate=t.normalsNeedUpdate,this.colorsNeedUpdate=t.colorsNeedUpdate,this.uvsNeedUpdate=t.uvsNeedUpdate,this.groupsNeedUpdate=t.groupsNeedUpdate,this}});var bn,xn,_n,wn,Sn,An,Mn,Pn,Tn,En,Cn,In,Rn,Ln,On,Dn,kn,Nn,Bn,Fn,zn,Un,jn,Gn,Vn,Hn,$n,Wn,Xn,qn,Yn,Zn,Kn,Jn=1;function Qn(){Object.defineProperty(this,"id",{value:Jn+=2}),this.uuid=je.generateUUID(),this.name="",this.type="BufferGeometry",this.index=null,this.attributes={},this.morphAttributes={},this.groups=[],this.boundingBox=null,this.boundingSphere=null,this.drawRange={start:0,count:1/0}}function to(t,e,i,r,n,o){an.call(this),this.type="BoxGeometry",this.parameters={width:t,height:e,depth:i,widthSegments:r,heightSegments:n,depthSegments:o},this.fromBufferGeometry(new eo(t,e,i,r,n,o)),this.mergeVertices()}function eo(t,e,i,r,n,o){Qn.call(this),this.type="BoxBufferGeometry",this.parameters={width:t,height:e,depth:i,widthSegments:r,heightSegments:n,depthSegments:o};var a=this;t=t||1,e=e||1,i=i||1,r=Math.floor(r)||1,n=Math.floor(n)||1;var s=[],c=[],u=[],h=[],l=0,p=0;function d(t,e,i,r,n,o,d,f,m,g,v){var y,b,x=o/m,_=d/g,w=o/2,S=d/2,A=f/2,M=m+1,P=g+1,T=0,E=0,C=new $e;for(b=0;b<P;b++){var I=b*_-S;for(y=0;y<M;y++){var R=y*x-w;C[t]=R*r,C[e]=I*n,C[i]=A,c.push(C.x,C.y,C.z),C[t]=0,C[e]=0,C[i]=f>0?1:-1,u.push(C.x,C.y,C.z),h.push(y/m),h.push(1-b/g),T+=1}}for(b=0;b<g;b++)for(y=0;y<m;y++){var L=l+y+M*b,O=l+y+M*(b+1),D=l+(y+1)+M*(b+1),k=l+(y+1)+M*b;s.push(L,O,k),s.push(O,D,k),E+=6}a.addGroup(p,E,v),p+=E,l+=T}d("z","y","x",-1,-1,i,e,t,o=Math.floor(o)||1,n,0),d("z","y","x",1,-1,i,e,-t,o,n,1),d("x","z","y",1,1,t,i,e,r,o,2),d("x","z","y",1,-1,t,i,-e,r,o,3),d("x","y","z",1,-1,t,e,i,r,n,4),d("x","y","z",-1,-1,t,e,-i,r,n,5),this.setIndex(s),this.addAttribute("position",new mn(c,3)),this.addAttribute("normal",new mn(u,3)),this.addAttribute("uv",new mn(h,2))}function io(t,e,i,r){an.call(this),this.type="PlaneGeometry",this.parameters={width:t,height:e,widthSegments:i,heightSegments:r},this.fromBufferGeometry(new ro(t,e,i,r)),this.mergeVertices()}function ro(t,e,i,r){Qn.call(this),this.type="PlaneBufferGeometry",this.parameters={width:t,height:e,widthSegments:i,heightSegments:r};var n,o,a=(t=t||1)/2,s=(e=e||1)/2,c=Math.floor(i)||1,u=Math.floor(r)||1,h=c+1,l=u+1,p=t/c,d=e/u,f=[],m=[],g=[],v=[];for(o=0;o<l;o++){var y=o*d-s;for(n=0;n<h;n++){var b=n*p-a;m.push(b,-y,0),g.push(0,0,1),v.push(n/c),v.push(1-o/u)}}for(o=0;o<u;o++)for(n=0;n<c;n++){var x=n+h*o,_=n+h*(o+1),w=n+1+h*(o+1),S=n+1+h*o;f.push(x,_,S),f.push(_,w,S)}this.setIndex(f),this.addAttribute("position",new mn(m,3)),this.addAttribute("normal",new mn(g,3)),this.addAttribute("uv",new mn(v,2))}function no(t){vr.call(this),this.type="MeshBasicMaterial",this.color=new Gi(16777215),this.map=null,this.lightMap=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.specularMap=null,this.alphaMap=null,this.envMap=null,this.combine=Tt,this.reflectivity=1,this.refractionRatio=.98,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinecap="round",this.wireframeLinejoin="round",this.skinning=!1,this.morphTargets=!1,this.lights=!1,this.setValues(t)}function oo(t){vr.call(this),this.type="ShaderMaterial",this.defines={},this.uniforms={},this.vertexShader="void main() {\n\tgl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",this.fragmentShader="void main() {\n\tgl_FragColor = vec4( 1.0, 0.0, 0.0, 1.0 );\n}",this.linewidth=1,this.wireframe=!1,this.wireframeLinewidth=1,this.fog=!1,this.lights=!1,this.clipping=!1,this.skinning=!1,this.morphTargets=!1,this.morphNormals=!1,this.extensions={derivatives:!1,fragDepth:!1,drawBuffers:!1,shaderTextureLOD:!1},this.defaultAttributeValues={color:[1,1,1],uv:[0,0],uv2:[0,0]},this.index0AttributeName=void 0,void 0!==t&&(void 0!==t.attributes&&console.error("THREE.ShaderMaterial: attributes should now be defined in THREE.BufferGeometry instead."),this.setValues(t))}function ao(t,e){this.origin=void 0!==t?t:new $e,this.direction=void 0!==e?e:new $e}function so(t,e){this.start=void 0!==t?t:new $e,this.end=void 0!==e?e:new $e}function co(t,e,i){this.a=void 0!==t?t:new $e,this.b=void 0!==e?e:new $e,this.c=void 0!==i?i:new $e}function uo(t,e){qr.call(this),this.type="Mesh",this.geometry=void 0!==t?t:new Qn,this.material=void 0!==e?e:new no({color:16777215*Math.random()}),this.drawMode=Ce,this.updateMorphTargets()}function ho(t,e){return t.renderOrder!==e.renderOrder?t.renderOrder-e.renderOrder:t.program&&e.program&&t.program!==e.program?t.program.id-e.program.id:t.material.id!==e.material.id?t.material.id-e.material.id:t.z!==e.z?t.z-e.z:t.id-e.id}function lo(t,e){return t.renderOrder!==e.renderOrder?t.renderOrder-e.renderOrder:t.z!==e.z?e.z-t.z:t.id-e.id}function po(){var t={};return{get:function(e,i){var r=e.id+","+i.id,n=t[r];return void 0===n&&(n=new function(){var t=[],e=0,i=[],r=[];return{opaque:i,transparent:r,init:function(){e=0,i.length=0,r.length=0},push:function(n,o,a,s,c){var u=t[e];void 0===u?(u={id:n.id,object:n,geometry:o,material:a,program:a.program,renderOrder:n.renderOrder,z:s,group:c},t[e]=u):(u.id=n.id,u.object=n,u.geometry=o,u.material=a,u.program=a.program,u.renderOrder=n.renderOrder,u.z=s,u.group=c),(!0===a.transparent?r:i).push(u),e++},sort:function(){i.length>1&&i.sort(ho),r.length>1&&r.sort(lo)}}},t[r]=n),n},dispose:function(){t={}}}}function fo(t,e){return Math.abs(e[1])-Math.abs(t[1])}function mo(){var t=new function(){var t={};return{get:function(e){if(void 0!==t[e.id])return t[e.id];var i;switch(e.type){case"DirectionalLight":i={direction:new $e,color:new Gi,shadow:!1,shadowBias:0,shadowRadius:1,shadowMapSize:new Ge};break;case"SpotLight":i={position:new $e,direction:new $e,color:new Gi,distance:0,coneCos:0,penumbraCos:0,decay:0,shadow:!1,shadowBias:0,shadowRadius:1,shadowMapSize:new Ge};break;case"PointLight":i={position:new $e,color:new Gi,distance:0,decay:0,shadow:!1,shadowBias:0,shadowRadius:1,shadowMapSize:new Ge,shadowCameraNear:1,shadowCameraFar:1e3};break;case"HemisphereLight":i={direction:new $e,skyColor:new Gi,groundColor:new Gi};break;case"RectAreaLight":i={color:new Gi,position:new $e,halfWidth:new $e,halfHeight:new $e}}return t[e.id]=i,i}}},e={hash:"",ambient:[0,0,0],directional:[],directionalShadowMap:[],directionalShadowMatrix:[],spot:[],spotShadowMap:[],spotShadowMatrix:[],rectArea:[],point:[],pointShadowMap:[],pointShadowMatrix:[],hemi:[]},i=new $e,r=new Ve,n=new Ve;return{setup:function(o,a,s){for(var c=0,u=0,h=0,l=0,p=0,d=0,f=0,m=0,g=s.matrixWorldInverse,v=0,y=o.length;v<y;v++){var b=o[v],x=b.color,_=b.intensity,w=b.distance,S=b.shadow&&b.shadow.map?b.shadow.map.texture:null;if(b.isAmbientLight)c+=x.r*_,u+=x.g*_,h+=x.b*_;else if(b.isDirectionalLight){if((M=t.get(b)).color.copy(b.color).multiplyScalar(b.intensity),M.direction.setFromMatrixPosition(b.matrixWorld),i.setFromMatrixPosition(b.target.matrixWorld),M.direction.sub(i),M.direction.transformDirection(g),M.shadow=b.castShadow,b.castShadow){var A=b.shadow;M.shadowBias=A.bias,M.shadowRadius=A.radius,M.shadowMapSize=A.mapSize}e.directionalShadowMap[l]=S,e.directionalShadowMatrix[l]=b.shadow.matrix,e.directional[l]=M,l++}else if(b.isSpotLight)(M=t.get(b)).position.setFromMatrixPosition(b.matrixWorld),M.position.applyMatrix4(g),M.color.copy(x).multiplyScalar(_),M.distance=w,M.direction.setFromMatrixPosition(b.matrixWorld),i.setFromMatrixPosition(b.target.matrixWorld),M.direction.sub(i),M.direction.transformDirection(g),M.coneCos=Math.cos(b.angle),M.penumbraCos=Math.cos(b.angle*(1-b.penumbra)),M.decay=0===b.distance?0:b.decay,M.shadow=b.castShadow,b.castShadow&&(A=b.shadow,M.shadowBias=A.bias,M.shadowRadius=A.radius,M.shadowMapSize=A.mapSize),e.spotShadowMap[d]=S,e.spotShadowMatrix[d]=b.shadow.matrix,e.spot[d]=M,d++;else if(b.isRectAreaLight)(M=t.get(b)).color.copy(x).multiplyScalar(_/(b.width*b.height)),M.position.setFromMatrixPosition(b.matrixWorld),M.position.applyMatrix4(g),n.identity(),r.copy(b.matrixWorld),r.premultiply(g),n.extractRotation(r),M.halfWidth.set(.5*b.width,0,0),M.halfHeight.set(0,.5*b.height,0),M.halfWidth.applyMatrix4(n),M.halfHeight.applyMatrix4(n),e.rectArea[f]=M,f++;else if(b.isPointLight)(M=t.get(b)).position.setFromMatrixPosition(b.matrixWorld),M.position.applyMatrix4(g),M.color.copy(b.color).multiplyScalar(b.intensity),M.distance=b.distance,M.decay=0===b.distance?0:b.decay,M.shadow=b.castShadow,b.castShadow&&(A=b.shadow,M.shadowBias=A.bias,M.shadowRadius=A.radius,M.shadowMapSize=A.mapSize,M.shadowCameraNear=A.camera.near,M.shadowCameraFar=A.camera.far),e.pointShadowMap[p]=S,e.pointShadowMatrix[p]=b.shadow.matrix,e.point[p]=M,p++;else if(b.isHemisphereLight){var M;(M=t.get(b)).direction.setFromMatrixPosition(b.matrixWorld),M.direction.transformDirection(g),M.direction.normalize(),M.skyColor.copy(b.color).multiplyScalar(_),M.groundColor.copy(b.groundColor).multiplyScalar(_),e.hemi[m]=M,m++}}e.ambient[0]=c,e.ambient[1]=u,e.ambient[2]=h,e.directional.length=l,e.spot.length=d,e.rectArea.length=f,e.point.length=p,e.hemi.length=m,e.hash=l+","+p+","+d+","+f+","+m+","+a.length},state:e}}function go(t,e,i){var r=t.createShader(e);return t.shaderSource(r,i),t.compileShader(r),!1===t.getShaderParameter(r,t.COMPILE_STATUS)&&console.error("THREE.WebGLShader: Shader couldn't compile."),""!==t.getShaderInfoLog(r)&&console.warn("THREE.WebGLShader: gl.getShaderInfoLog()",e===t.VERTEX_SHADER?"vertex":"fragment",t.getShaderInfoLog(r),function(t){for(var e=t.split("\n"),i=0;i<e.length;i++)e[i]=i+1+": "+e[i];return e.join("\n")}(i)),r}Qn.prototype=Object.assign(Object.create(v.prototype),{constructor:Qn,isBufferGeometry:!0,getIndex:function(){return this.index},setIndex:function(t){Array.isArray(t)?this.index=new(yn(t)>65535?fn:pn)(t,1):this.index=t},addAttribute:function(t,e){return e&&e.isBufferAttribute||e&&e.isInterleavedBufferAttribute?"index"===t?(console.warn("THREE.BufferGeometry.addAttribute: Use .setIndex() for index attribute."),void this.setIndex(e)):(this.attributes[t]=e,this):(console.warn("THREE.BufferGeometry: .addAttribute() now expects ( name, attribute )."),void this.addAttribute(t,new sn(arguments[1],arguments[2])))},getAttribute:function(t){return this.attributes[t]},removeAttribute:function(t){return delete this.attributes[t],this},addGroup:function(t,e,i){this.groups.push({start:t,count:e,materialIndex:void 0!==i?i:0})},clearGroups:function(){this.groups=[]},setDrawRange:function(t,e){this.drawRange.start=t,this.drawRange.count=e},applyMatrix:function(t){var e=this.attributes.position;void 0!==e&&(t.applyToBufferAttribute(e),e.needsUpdate=!0);var i=this.attributes.normal;void 0!==i&&((new We).getNormalMatrix(t).applyToBufferAttribute(i),i.needsUpdate=!0);return null!==this.boundingBox&&this.computeBoundingBox(),null!==this.boundingSphere&&this.computeBoundingSphere(),this},rotateX:(Tn=new Ve,function(t){return Tn.makeRotationX(t),this.applyMatrix(Tn),this}),rotateY:(Pn=new Ve,function(t){return Pn.makeRotationY(t),this.applyMatrix(Pn),this}),rotateZ:(Mn=new Ve,function(t){return Mn.makeRotationZ(t),this.applyMatrix(Mn),this}),translate:(An=new Ve,function(t,e,i){return An.makeTranslation(t,e,i),this.applyMatrix(An),this}),scale:(Sn=new Ve,function(t,e,i){return Sn.makeScale(t,e,i),this.applyMatrix(Sn),this}),lookAt:(wn=new qr,function(t){wn.lookAt(t),wn.updateMatrix(),this.applyMatrix(wn.matrix)}),center:function(){this.computeBoundingBox();var t=this.boundingBox.getCenter().negate();return this.translate(t.x,t.y,t.z),t},setFromObject:function(t){var e=t.geometry;if(t.isPoints||t.isLine){var i=new mn(3*e.vertices.length,3),r=new mn(3*e.colors.length,3);if(this.addAttribute("position",i.copyVector3sArray(e.vertices)),this.addAttribute("color",r.copyColorsArray(e.colors)),e.lineDistances&&e.lineDistances.length===e.vertices.length){var n=new mn(e.lineDistances.length,1);this.addAttribute("lineDistance",n.copyArray(e.lineDistances))}null!==e.boundingSphere&&(this.boundingSphere=e.boundingSphere.clone()),null!==e.boundingBox&&(this.boundingBox=e.boundingBox.clone())}else t.isMesh&&e&&e.isGeometry&&this.fromGeometry(e);return this},setFromPoints:function(t){for(var e=[],i=0,r=t.length;i<r;i++){var n=t[i];e.push(n.x,n.y,n.z||0)}return this.addAttribute("position",new mn(e,3)),this},updateFromObject:function(t){var e,i=t.geometry;if(t.isMesh){var r=i.__directGeometry;if(!0===i.elementsNeedUpdate&&(r=void 0,i.elementsNeedUpdate=!1),void 0===r)return this.fromGeometry(i);r.verticesNeedUpdate=i.verticesNeedUpdate,r.normalsNeedUpdate=i.normalsNeedUpdate,r.colorsNeedUpdate=i.colorsNeedUpdate,r.uvsNeedUpdate=i.uvsNeedUpdate,r.groupsNeedUpdate=i.groupsNeedUpdate,i.verticesNeedUpdate=!1,i.normalsNeedUpdate=!1,i.colorsNeedUpdate=!1,i.uvsNeedUpdate=!1,i.groupsNeedUpdate=!1,i=r}return!0===i.verticesNeedUpdate&&(void 0!==(e=this.attributes.position)&&(e.copyVector3sArray(i.vertices),e.needsUpdate=!0),i.verticesNeedUpdate=!1),!0===i.normalsNeedUpdate&&(void 0!==(e=this.attributes.normal)&&(e.copyVector3sArray(i.normals),e.needsUpdate=!0),i.normalsNeedUpdate=!1),!0===i.colorsNeedUpdate&&(void 0!==(e=this.attributes.color)&&(e.copyColorsArray(i.colors),e.needsUpdate=!0),i.colorsNeedUpdate=!1),i.uvsNeedUpdate&&(void 0!==(e=this.attributes.uv)&&(e.copyVector2sArray(i.uvs),e.needsUpdate=!0),i.uvsNeedUpdate=!1),i.lineDistancesNeedUpdate&&(void 0!==(e=this.attributes.lineDistance)&&(e.copyArray(i.lineDistances),e.needsUpdate=!0),i.lineDistancesNeedUpdate=!1),i.groupsNeedUpdate&&(i.computeGroups(t.geometry),this.groups=i.groups,i.groupsNeedUpdate=!1),this},fromGeometry:function(t){return t.__directGeometry=(new vn).fromGeometry(t),this.fromDirectGeometry(t.__directGeometry)},fromDirectGeometry:function(t){var e=new Float32Array(3*t.vertices.length);if(this.addAttribute("position",new sn(e,3).copyVector3sArray(t.vertices)),t.normals.length>0){var i=new Float32Array(3*t.normals.length);this.addAttribute("normal",new sn(i,3).copyVector3sArray(t.normals))}if(t.colors.length>0){var r=new Float32Array(3*t.colors.length);this.addAttribute("color",new sn(r,3).copyColorsArray(t.colors))}if(t.uvs.length>0){var n=new Float32Array(2*t.uvs.length);this.addAttribute("uv",new sn(n,2).copyVector2sArray(t.uvs))}if(t.uvs2.length>0){var o=new Float32Array(2*t.uvs2.length);this.addAttribute("uv2",new sn(o,2).copyVector2sArray(t.uvs2))}if(t.indices.length>0){var a=new(yn(t.indices)>65535?Uint32Array:Uint16Array)(3*t.indices.length);this.setIndex(new sn(a,1).copyIndicesArray(t.indices))}for(var s in this.groups=t.groups,t.morphTargets){for(var c=[],u=t.morphTargets[s],h=0,l=u.length;h<l;h++){var p=u[h],d=new mn(3*p.length,3);c.push(d.copyVector3sArray(p))}this.morphAttributes[s]=c}if(t.skinIndices.length>0){var f=new mn(4*t.skinIndices.length,4);this.addAttribute("skinIndex",f.copyVector4sArray(t.skinIndices))}if(t.skinWeights.length>0){var m=new mn(4*t.skinWeights.length,4);this.addAttribute("skinWeight",m.copyVector4sArray(t.skinWeights))}return null!==t.boundingSphere&&(this.boundingSphere=t.boundingSphere.clone()),null!==t.boundingBox&&(this.boundingBox=t.boundingBox.clone()),this},computeBoundingBox:function(){null===this.boundingBox&&(this.boundingBox=new xr);var t=this.attributes.position;void 0!==t?this.boundingBox.setFromBufferAttribute(t):this.boundingBox.makeEmpty(),(isNaN(this.boundingBox.min.x)||isNaN(this.boundingBox.min.y)||isNaN(this.boundingBox.min.z))&&console.error('THREE.BufferGeometry.computeBoundingBox: Computed min/max have NaN values. The "position" attribute is likely to have NaN values.',this)},computeBoundingSphere:(xn=new xr,_n=new $e,function(){null===this.boundingSphere&&(this.boundingSphere=new _r);var t=this.attributes.position;if(t){var e=this.boundingSphere.center;xn.setFromBufferAttribute(t),xn.getCenter(e);for(var i=0,r=0,n=t.count;r<n;r++)_n.x=t.getX(r),_n.y=t.getY(r),_n.z=t.getZ(r),i=Math.max(i,e.distanceToSquared(_n));this.boundingSphere.radius=Math.sqrt(i),isNaN(this.boundingSphere.radius)&&console.error('THREE.BufferGeometry.computeBoundingSphere(): Computed radius is NaN. The "position" attribute is likely to have NaN values.',this)}}),computeFaceNormals:function(){},computeVertexNormals:function(){var t=this.index,e=this.attributes,i=this.groups;if(e.position){var r=e.position.array;if(void 0===e.normal)this.addAttribute("normal",new sn(new Float32Array(r.length),3));else for(var n=e.normal.array,o=0,a=n.length;o<a;o++)n[o]=0;var s,c,u,h=e.normal.array,l=new $e,p=new $e,d=new $e,f=new $e,m=new $e;if(t){var g=t.array;0===i.length&&this.addGroup(0,g.length);for(var v=0,y=i.length;v<y;++v){var b=i[v],x=b.start;for(o=x,a=x+b.count;o<a;o+=3)s=3*g[o+0],c=3*g[o+1],u=3*g[o+2],l.fromArray(r,s),p.fromArray(r,c),d.fromArray(r,u),f.subVectors(d,p),m.subVectors(l,p),f.cross(m),h[s]+=f.x,h[s+1]+=f.y,h[s+2]+=f.z,h[c]+=f.x,h[c+1]+=f.y,h[c+2]+=f.z,h[u]+=f.x,h[u+1]+=f.y,h[u+2]+=f.z}}else for(o=0,a=r.length;o<a;o+=9)l.fromArray(r,o),p.fromArray(r,o+3),d.fromArray(r,o+6),f.subVectors(d,p),m.subVectors(l,p),f.cross(m),h[o]=f.x,h[o+1]=f.y,h[o+2]=f.z,h[o+3]=f.x,h[o+4]=f.y,h[o+5]=f.z,h[o+6]=f.x,h[o+7]=f.y,h[o+8]=f.z;this.normalizeNormals(),e.normal.needsUpdate=!0}},merge:function(t,e){if(t&&t.isBufferGeometry){void 0===e&&(e=0);var i=this.attributes;for(var r in i)if(void 0!==t.attributes[r])for(var n=i[r].array,o=t.attributes[r],a=o.array,s=0,c=o.itemSize*e;s<a.length;s++,c++)n[c]=a[s];return this}console.error("THREE.BufferGeometry.merge(): geometry not an instance of THREE.BufferGeometry.",t)},normalizeNormals:(bn=new $e,function(){for(var t=this.attributes.normal,e=0,i=t.count;e<i;e++)bn.x=t.getX(e),bn.y=t.getY(e),bn.z=t.getZ(e),bn.normalize(),t.setXYZ(e,bn.x,bn.y,bn.z)}),toNonIndexed:function(){if(null===this.index)return console.warn("THREE.BufferGeometry.toNonIndexed(): Geometry is already non-indexed."),this;var t=new Qn,e=this.index.array,i=this.attributes;for(var r in i){for(var n=i[r],o=n.array,a=n.itemSize,s=new o.constructor(e.length*a),c=0,u=0,h=0,l=e.length;h<l;h++){c=e[h]*a;for(var p=0;p<a;p++)s[u++]=o[c++]}t.addAttribute(r,new sn(s,a))}return t},toJSON:function(){var t={metadata:{version:4.5,type:"BufferGeometry",generator:"BufferGeometry.toJSON"}};if(t.uuid=this.uuid,t.type=this.type,""!==this.name&&(t.name=this.name),void 0!==this.parameters){var e=this.parameters;for(var i in e)void 0!==e[i]&&(t[i]=e[i]);return t}t.data={attributes:{}};var r=this.index;if(null!==r){var n=Array.prototype.slice.call(r.array);t.data.index={type:r.array.constructor.name,array:n}}var o=this.attributes;for(var i in o){var a=o[i];n=Array.prototype.slice.call(a.array);t.data.attributes[i]={itemSize:a.itemSize,type:a.array.constructor.name,array:n,normalized:a.normalized}}var s=this.groups;s.length>0&&(t.data.groups=JSON.parse(JSON.stringify(s)));var c=this.boundingSphere;return null!==c&&(t.data.boundingSphere={center:c.center.toArray(),radius:c.radius}),t},clone:function(){return(new Qn).copy(this)},copy:function(t){var e,i,r;this.index=null,this.attributes={},this.morphAttributes={},this.groups=[],this.boundingBox=null,this.boundingSphere=null,this.name=t.name;var n=t.index;null!==n&&this.setIndex(n.clone());var o=t.attributes;for(e in o){var a=o[e];this.addAttribute(e,a.clone())}var s=t.morphAttributes;for(e in s){var c=[],u=s[e];for(i=0,r=u.length;i<r;i++)c.push(u[i].clone());this.morphAttributes[e]=c}var h=t.groups;for(i=0,r=h.length;i<r;i++){var l=h[i];this.addGroup(l.start,l.count,l.materialIndex)}var p=t.boundingBox;null!==p&&(this.boundingBox=p.clone());var d=t.boundingSphere;return null!==d&&(this.boundingSphere=d.clone()),this.drawRange.start=t.drawRange.start,this.drawRange.count=t.drawRange.count,this},dispose:function(){this.dispatchEvent({type:"dispose"})}}),to.prototype=Object.create(an.prototype),to.prototype.constructor=to,eo.prototype=Object.create(Qn.prototype),eo.prototype.constructor=eo,io.prototype=Object.create(an.prototype),io.prototype.constructor=io,ro.prototype=Object.create(Qn.prototype),ro.prototype.constructor=ro,no.prototype=Object.create(vr.prototype),no.prototype.constructor=no,no.prototype.isMeshBasicMaterial=!0,no.prototype.copy=function(t){return vr.prototype.copy.call(this,t),this.color.copy(t.color),this.map=t.map,this.lightMap=t.lightMap,this.lightMapIntensity=t.lightMapIntensity,this.aoMap=t.aoMap,this.aoMapIntensity=t.aoMapIntensity,this.specularMap=t.specularMap,this.alphaMap=t.alphaMap,this.envMap=t.envMap,this.combine=t.combine,this.reflectivity=t.reflectivity,this.refractionRatio=t.refractionRatio,this.wireframe=t.wireframe,this.wireframeLinewidth=t.wireframeLinewidth,this.wireframeLinecap=t.wireframeLinecap,this.wireframeLinejoin=t.wireframeLinejoin,this.skinning=t.skinning,this.morphTargets=t.morphTargets,this},oo.prototype=Object.create(vr.prototype),oo.prototype.constructor=oo,oo.prototype.isShaderMaterial=!0,oo.prototype.copy=function(t){return vr.prototype.copy.call(this,t),this.fragmentShader=t.fragmentShader,this.vertexShader=t.vertexShader,this.uniforms=Wi.clone(t.uniforms),this.defines=t.defines,this.wireframe=t.wireframe,this.wireframeLinewidth=t.wireframeLinewidth,this.lights=t.lights,this.clipping=t.clipping,this.skinning=t.skinning,this.morphTargets=t.morphTargets,this.morphNormals=t.morphNormals,this.extensions=t.extensions,this},oo.prototype.toJSON=function(t){var e=vr.prototype.toJSON.call(this,t);return e.uniforms=this.uniforms,e.vertexShader=this.vertexShader,e.fragmentShader=this.fragmentShader,e},Object.assign(ao.prototype,{set:function(t,e){return this.origin.copy(t),this.direction.copy(e),this},clone:function(){return(new this.constructor).copy(this)},copy:function(t){return this.origin.copy(t.origin),this.direction.copy(t.direction),this},at:function(t,e){return(e||new $e).copy(this.direction).multiplyScalar(t).add(this.origin)},lookAt:function(t){return this.direction.copy(t).sub(this.origin).normalize(),this},recast:(Fn=new $e,function(t){return this.origin.copy(this.at(t,Fn)),this}),closestPointToPoint:function(t,e){var i=e||new $e;i.subVectors(t,this.origin);var r=i.dot(this.direction);return r<0?i.copy(this.origin):i.copy(this.direction).multiplyScalar(r).add(this.origin)},distanceToPoint:function(t){return Math.sqrt(this.distanceSqToPoint(t))},distanceSqToPoint:(Bn=new $e,function(t){var e=Bn.subVectors(t,this.origin).dot(this.direction);return e<0?this.origin.distanceToSquared(t):(Bn.copy(this.direction).multiplyScalar(e).add(this.origin),Bn.distanceToSquared(t))}),distanceSqToSegment:(Dn=new $e,kn=new $e,Nn=new $e,function(t,e,i,r){Dn.copy(t).add(e).multiplyScalar(.5),kn.copy(e).sub(t).normalize(),Nn.copy(this.origin).sub(Dn);var n,o,a,s,c=.5*t.distanceTo(e),u=-this.direction.dot(kn),h=Nn.dot(this.direction),l=-Nn.dot(kn),p=Nn.lengthSq(),d=Math.abs(1-u*u);if(d>0)if(o=u*h-l,s=c*d,(n=u*l-h)>=0)if(o>=-s)if(o<=s){var f=1/d;a=(n*=f)*(n+u*(o*=f)+2*h)+o*(u*n+o+2*l)+p}else o=c,a=-(n=Math.max(0,-(u*o+h)))*n+o*(o+2*l)+p;else o=-c,a=-(n=Math.max(0,-(u*o+h)))*n+o*(o+2*l)+p;else o<=-s?a=-(n=Math.max(0,-(-u*c+h)))*n+(o=n>0?-c:Math.min(Math.max(-c,-l),c))*(o+2*l)+p:o<=s?(n=0,a=(o=Math.min(Math.max(-c,-l),c))*(o+2*l)+p):a=-(n=Math.max(0,-(u*c+h)))*n+(o=n>0?c:Math.min(Math.max(-c,-l),c))*(o+2*l)+p;else o=u>0?-c:c,a=-(n=Math.max(0,-(u*o+h)))*n+o*(o+2*l)+p;return i&&i.copy(this.direction).multiplyScalar(n).add(this.origin),r&&r.copy(kn).multiplyScalar(o).add(Dn),a}),intersectSphere:(On=new $e,function(t,e){On.subVectors(t.center,this.origin);var i=On.dot(this.direction),r=On.dot(On)-i*i,n=t.radius*t.radius;if(r>n)return null;var o=Math.sqrt(n-r),a=i-o,s=i+o;return a<0&&s<0?null:a<0?this.at(s,e):this.at(a,e)}),intersectsSphere:function(t){return this.distanceToPoint(t.center)<=t.radius},distanceToPlane:function(t){var e=t.normal.dot(this.direction);if(0===e)return 0===t.distanceToPoint(this.origin)?0:null;var i=-(this.origin.dot(t.normal)+t.constant)/e;return i>=0?i:null},intersectPlane:function(t,e){var i=this.distanceToPlane(t);return null===i?null:this.at(i,e)},intersectsPlane:function(t){var e=t.distanceToPoint(this.origin);return 0===e||t.normal.dot(this.direction)*e<0},intersectBox:function(t,e){var i,r,n,o,a,s,c=1/this.direction.x,u=1/this.direction.y,h=1/this.direction.z,l=this.origin;return c>=0?(i=(t.min.x-l.x)*c,r=(t.max.x-l.x)*c):(i=(t.max.x-l.x)*c,r=(t.min.x-l.x)*c),u>=0?(n=(t.min.y-l.y)*u,o=(t.max.y-l.y)*u):(n=(t.max.y-l.y)*u,o=(t.min.y-l.y)*u),i>o||n>r?null:((n>i||i!=i)&&(i=n),(o<r||r!=r)&&(r=o),h>=0?(a=(t.min.z-l.z)*h,s=(t.max.z-l.z)*h):(a=(t.max.z-l.z)*h,s=(t.min.z-l.z)*h),i>s||a>r?null:((a>i||i!=i)&&(i=a),(s<r||r!=r)&&(r=s),r<0?null:this.at(i>=0?i:r,e)))},intersectsBox:(Ln=new $e,function(t){return null!==this.intersectBox(t,Ln)}),intersectTriangle:(En=new $e,Cn=new $e,In=new $e,Rn=new $e,function(t,e,i,r,n){Cn.subVectors(e,t),In.subVectors(i,t),Rn.crossVectors(Cn,In);var o,a=this.direction.dot(Rn);if(a>0){if(r)return null;o=1}else{if(!(a<0))return null;o=-1,a=-a}En.subVectors(this.origin,t);var s=o*this.direction.dot(In.crossVectors(En,In));if(s<0)return null;var c=o*this.direction.dot(Cn.cross(En));if(c<0)return null;if(s+c>a)return null;var u=-o*En.dot(Rn);return u<0?null:this.at(u/a,n)}),applyMatrix4:function(t){return this.origin.applyMatrix4(t),this.direction.transformDirection(t),this},equals:function(t){return t.origin.equals(this.origin)&&t.direction.equals(this.direction)}}),Object.assign(so.prototype,{set:function(t,e){return this.start.copy(t),this.end.copy(e),this},clone:function(){return(new this.constructor).copy(this)},copy:function(t){return this.start.copy(t.start),this.end.copy(t.end),this},getCenter:function(t){return(t||new $e).addVectors(this.start,this.end).multiplyScalar(.5)},delta:function(t){return(t||new $e).subVectors(this.end,this.start)},distanceSq:function(){return this.start.distanceToSquared(this.end)},distance:function(){return this.start.distanceTo(this.end)},at:function(t,e){var i=e||new $e;return this.delta(i).multiplyScalar(t).add(this.start)},closestPointToPointParameter:(zn=new $e,Un=new $e,function(t,e){zn.subVectors(t,this.start),Un.subVectors(this.end,this.start);var i=Un.dot(Un),r=Un.dot(zn)/i;return e&&(r=je.clamp(r,0,1)),r}),closestPointToPoint:function(t,e,i){var r=this.closestPointToPointParameter(t,e),n=i||new $e;return this.delta(n).multiplyScalar(r).add(this.start)},applyMatrix4:function(t){return this.start.applyMatrix4(t),this.end.applyMatrix4(t),this},equals:function(t){return t.start.equals(this.start)&&t.end.equals(this.end)}}),Object.assign(co,{normal:($n=new $e,function(t,e,i,r){var n=r||new $e;n.subVectors(i,e),$n.subVectors(t,e),n.cross($n);var o=n.lengthSq();return o>0?n.multiplyScalar(1/Math.sqrt(o)):n.set(0,0,0)}),barycoordFromPoint:(Gn=new $e,Vn=new $e,Hn=new $e,function(t,e,i,r,n){Gn.subVectors(r,e),Vn.subVectors(i,e),Hn.subVectors(t,e);var o=Gn.dot(Gn),a=Gn.dot(Vn),s=Gn.dot(Hn),c=Vn.dot(Vn),u=Vn.dot(Hn),h=o*c-a*a,l=n||new $e;if(0===h)return l.set(-2,-1,-1);var p=1/h,d=(c*s-a*u)*p,f=(o*u-a*s)*p;return l.set(1-d-f,f,d)}),containsPoint:(jn=new $e,function(t,e,i,r){var n=co.barycoordFromPoint(t,e,i,r,jn);return n.x>=0&&n.y>=0&&n.x+n.y<=1})}),Object.assign(co.prototype,{set:function(t,e,i){return this.a.copy(t),this.b.copy(e),this.c.copy(i),this},setFromPointsAndIndices:function(t,e,i,r){return this.a.copy(t[e]),this.b.copy(t[i]),this.c.copy(t[r]),this},clone:function(){return(new this.constructor).copy(this)},copy:function(t){return this.a.copy(t.a),this.b.copy(t.b),this.c.copy(t.c),this},area:(Zn=new $e,Kn=new $e,function(){return Zn.subVectors(this.c,this.b),Kn.subVectors(this.a,this.b),.5*Zn.cross(Kn).length()}),midpoint:function(t){return(t||new $e).addVectors(this.a,this.b).add(this.c).multiplyScalar(1/3)},normal:function(t){return co.normal(this.a,this.b,this.c,t)},plane:function(t){return(t||new wr).setFromCoplanarPoints(this.a,this.b,this.c)},barycoordFromPoint:function(t,e){return co.barycoordFromPoint(t,this.a,this.b,this.c,e)},containsPoint:function(t){return co.containsPoint(t,this.a,this.b,this.c)},closestPointToPoint:(Wn=new wr,Xn=[new so,new so,new so],qn=new $e,Yn=new $e,function(t,e){var i=e||new $e,r=1/0;if(Wn.setFromCoplanarPoints(this.a,this.b,this.c),Wn.projectPoint(t,qn),!0===this.containsPoint(qn))i.copy(qn);else{Xn[0].set(this.a,this.b),Xn[1].set(this.b,this.c),Xn[2].set(this.c,this.a);for(var n=0;n<Xn.length;n++){Xn[n].closestPointToPoint(qn,!0,Yn);var o=qn.distanceToSquared(Yn);o<r&&(r=o,i.copy(Yn))}}return i}),equals:function(t){return t.a.equals(this.a)&&t.b.equals(this.b)&&t.c.equals(this.c)}}),uo.prototype=Object.assign(Object.create(qr.prototype),{constructor:uo,isMesh:!0,setDrawMode:function(t){this.drawMode=t},copy:function(t){return qr.prototype.copy.call(this,t),this.drawMode=t.drawMode,void 0!==t.morphTargetInfluences&&(this.morphTargetInfluences=t.morphTargetInfluences.slice()),void 0!==t.morphTargetDictionary&&(this.morphTargetDictionary=Object.assign({},t.morphTargetDictionary)),this},updateMorphTargets:function(){var t,e,i,r=this.geometry;if(r.isBufferGeometry){var n=r.morphAttributes,o=Object.keys(n);if(o.length>0){var a=n[o[0]];if(void 0!==a)for(this.morphTargetInfluences=[],this.morphTargetDictionary={},t=0,e=a.length;t<e;t++)i=a[t].name||String(t),this.morphTargetInfluences.push(0),this.morphTargetDictionary[i]=t}}else{var s=r.morphTargets;if(void 0!==s&&s.length>0)for(this.morphTargetInfluences=[],this.morphTargetDictionary={},t=0,e=s.length;t<e;t++)i=s[t].name||String(t),this.morphTargetInfluences.push(0),this.morphTargetDictionary[i]=t}},raycast:function(){var t=new Ve,e=new ao,i=new _r,r=new $e,n=new $e,o=new $e,a=new $e,s=new $e,c=new $e,u=new Ge,h=new Ge,l=new Ge,p=new $e,d=new $e,f=new $e;function m(t,e,i,r,n,o,a){return co.barycoordFromPoint(t,e,i,r,p),n.multiplyScalar(p.x),o.multiplyScalar(p.y),a.multiplyScalar(p.z),n.add(o).add(a),n.clone()}function g(t,e,i,r,n,o,a,s){if(null===(e.side===W?r.intersectTriangle(a,o,n,!0,s):r.intersectTriangle(n,o,a,e.side!==X,s)))return null;f.copy(s),f.applyMatrix4(t.matrixWorld);var c=i.ray.origin.distanceTo(f);return c<i.near||c>i.far?null:{distance:c,point:f.clone(),object:t}}function v(t,e,i,a,s,c,p,f){r.fromBufferAttribute(a,c),n.fromBufferAttribute(a,p),o.fromBufferAttribute(a,f);var v=g(t,t.material,e,i,r,n,o,d);return v&&(s&&(u.fromBufferAttribute(s,c),h.fromBufferAttribute(s,p),l.fromBufferAttribute(s,f),v.uv=m(d,r,n,o,u,h,l)),v.face=new Kr(c,p,f,co.normal(r,n,o)),v.faceIndex=c),v}return function(p,f){var y,b=this.geometry,x=this.material,_=this.matrixWorld;if(void 0!==x&&(null===b.boundingSphere&&b.computeBoundingSphere(),i.copy(b.boundingSphere),i.applyMatrix4(_),!1!==p.ray.intersectsSphere(i)&&(t.getInverse(_),e.copy(p.ray).applyMatrix4(t),null===b.boundingBox||!1!==e.intersectsBox(b.boundingBox))))if(b.isBufferGeometry){var w,S,A,M,P,T=b.index,E=b.attributes.position,C=b.attributes.uv;if(null!==T)for(M=0,P=T.count;M<P;M+=3)w=T.getX(M),S=T.getX(M+1),A=T.getX(M+2),(y=v(this,p,e,E,C,w,S,A))&&(y.faceIndex=Math.floor(M/3),f.push(y));else if(void 0!==E)for(M=0,P=E.count;M<P;M+=3)(y=v(this,p,e,E,C,w=M,S=M+1,A=M+2))&&(y.index=w,f.push(y))}else if(b.isGeometry){var I,R,L,O,D=Array.isArray(x),k=b.vertices,N=b.faces,B=b.faceVertexUvs[0];B.length>0&&(O=B);for(var F=0,z=N.length;F<z;F++){var U=N[F],j=D?x[U.materialIndex]:x;if(void 0!==j){if(I=k[U.a],R=k[U.b],L=k[U.c],!0===j.morphTargets){var G=b.morphTargets,V=this.morphTargetInfluences;r.set(0,0,0),n.set(0,0,0),o.set(0,0,0);for(var H=0,$=G.length;H<$;H++){var W=V[H];if(0!==W){var X=G[H].vertices;r.addScaledVector(a.subVectors(X[U.a],I),W),n.addScaledVector(s.subVectors(X[U.b],R),W),o.addScaledVector(c.subVectors(X[U.c],L),W)}}r.add(I),n.add(R),o.add(L),I=r,R=n,L=o}if(y=g(this,j,p,e,I,R,L,d)){if(O&&O[F]){var q=O[F];u.copy(q[0]),h.copy(q[1]),l.copy(q[2]),y.uv=m(d,I,R,L,u,h,l)}y.face=U,y.faceIndex=F,f.push(y)}}}}}}(),clone:function(){return new this.constructor(this.geometry,this.material).copy(this)}});var vo,yo,bo,xo,_o,wo,So,Ao,Mo,Po,To,Eo,Co,Io,Ro=0;function Lo(t){switch(t){case Le:return["Linear","( value )"];case Oe:return["sRGB","( value )"];case ke:return["RGBE","( value )"];case Ne:return["RGBM","( value, 7.0 )"];case Be:return["RGBM","( value, 16.0 )"];case Fe:return["RGBD","( value, 256.0 )"];case De:return["Gamma","( value, float( GAMMA_FACTOR ) )"];default:throw new Error("unsupported encoding: "+t)}}function Oo(t,e){var i=Lo(e);return"vec4 "+t+"( vec4 value ) { return "+i[0]+"ToLinear"+i[1]+"; }"}function Do(t){return""!==t}function ko(t,e){return t.replace(/NUM_DIR_LIGHTS/g,e.numDirLights).replace(/NUM_SPOT_LIGHTS/g,e.numSpotLights).replace(/NUM_RECT_AREA_LIGHTS/g,e.numRectAreaLights).replace(/NUM_POINT_LIGHTS/g,e.numPointLights).replace(/NUM_HEMI_LIGHTS/g,e.numHemiLights)}function No(t){return t.replace(/^[ \t]*#include +<([\w\d.]+)>/gm,function(t,e){var i=Xi[e];if(void 0===i)throw new Error("Can not resolve #include <"+e+">");return No(i)})}function Bo(t){return t.replace(/for \( int i \= (\d+)\; i < (\d+)\; i \+\+ \) \{([\s\S]+?)(?=\})\}/g,function(t,e,i,r){for(var n="",o=parseInt(e);o<parseInt(i);o++)n+=r.replace(/\[ i \]/g,"[ "+o+" ]");return n})}function Fo(t,e,i,r,n,o){var a=t.context,s=r.defines,c=n.vertexShader,u=n.fragmentShader,h="SHADOWMAP_TYPE_BASIC";o.shadowMapType===V?h="SHADOWMAP_TYPE_PCF":o.shadowMapType===H&&(h="SHADOWMAP_TYPE_PCF_SOFT");var l="ENVMAP_TYPE_CUBE",p="ENVMAP_MODE_REFLECTION",d="ENVMAP_BLENDING_MULTIPLY";if(o.envMap){switch(r.envMap.mapping){case kt:case Nt:l="ENVMAP_TYPE_CUBE";break;case Ut:case jt:l="ENVMAP_TYPE_CUBE_UV";break;case Bt:case Ft:l="ENVMAP_TYPE_EQUIREC";break;case zt:l="ENVMAP_TYPE_SPHERE"}switch(r.envMap.mapping){case Nt:case Ft:p="ENVMAP_MODE_REFRACTION"}switch(r.combine){case Tt:d="ENVMAP_BLENDING_MULTIPLY";break;case Et:d="ENVMAP_BLENDING_MIX";break;case Ct:d="ENVMAP_BLENDING_ADD"}}var f,m,g,v,y,b,x,_,w=t.gammaFactor>0?t.gammaFactor:1,S=(f=r.extensions,m=o,g=e,[(f=f||{}).derivatives||m.envMapCubeUV||m.bumpMap||m.normalMap||m.flatShading?"#extension GL_OES_standard_derivatives : enable":"",(f.fragDepth||m.logarithmicDepthBuffer)&&g.get("EXT_frag_depth")?"#extension GL_EXT_frag_depth : enable":"",f.drawBuffers&&g.get("WEBGL_draw_buffers")?"#extension GL_EXT_draw_buffers : require":"",(f.shaderTextureLOD||m.envMap)&&g.get("EXT_shader_texture_lod")?"#extension GL_EXT_shader_texture_lod : enable":""].filter(Do).join("\n")),A=function(t){var e=[];for(var i in t){var r=t[i];!1!==r&&e.push("#define "+i+" "+r)}return e.join("\n")}(s),M=a.createProgram();r.isRawShaderMaterial?((v=[A].filter(Do).join("\n")).length>0&&(v+="\n"),(y=[S,A].filter(Do).join("\n")).length>0&&(y+="\n")):(v=["precision "+o.precision+" float;","precision "+o.precision+" int;","#define SHADER_NAME "+n.name,A,o.supportsVertexTextures?"#define VERTEX_TEXTURES":"","#define GAMMA_FACTOR "+w,"#define MAX_BONES "+o.maxBones,o.useFog&&o.fog?"#define USE_FOG":"",o.useFog&&o.fogExp?"#define FOG_EXP2":"",o.map?"#define USE_MAP":"",o.envMap?"#define USE_ENVMAP":"",o.envMap?"#define "+p:"",o.lightMap?"#define USE_LIGHTMAP":"",o.aoMap?"#define USE_AOMAP":"",o.emissiveMap?"#define USE_EMISSIVEMAP":"",o.bumpMap?"#define USE_BUMPMAP":"",o.normalMap?"#define USE_NORMALMAP":"",o.displacementMap&&o.supportsVertexTextures?"#define USE_DISPLACEMENTMAP":"",o.specularMap?"#define USE_SPECULARMAP":"",o.roughnessMap?"#define USE_ROUGHNESSMAP":"",o.metalnessMap?"#define USE_METALNESSMAP":"",o.alphaMap?"#define USE_ALPHAMAP":"",o.vertexColors?"#define USE_COLOR":"",o.flatShading?"#define FLAT_SHADED":"",o.skinning?"#define USE_SKINNING":"",o.useVertexTexture?"#define BONE_TEXTURE":"",o.morphTargets?"#define USE_MORPHTARGETS":"",o.morphNormals&&!1===o.flatShading?"#define USE_MORPHNORMALS":"",o.doubleSided?"#define DOUBLE_SIDED":"",o.flipSided?"#define FLIP_SIDED":"","#define NUM_CLIPPING_PLANES "+o.numClippingPlanes,o.shadowMapEnabled?"#define USE_SHADOWMAP":"",o.shadowMapEnabled?"#define "+h:"",o.sizeAttenuation?"#define USE_SIZEATTENUATION":"",o.logarithmicDepthBuffer?"#define USE_LOGDEPTHBUF":"",o.logarithmicDepthBuffer&&e.get("EXT_frag_depth")?"#define USE_LOGDEPTHBUF_EXT":"","uniform mat4 modelMatrix;","uniform mat4 modelViewMatrix;","uniform mat4 projectionMatrix;","uniform mat4 viewMatrix;","uniform mat3 normalMatrix;","uniform vec3 cameraPosition;","attribute vec3 position;","attribute vec3 normal;","attribute vec2 uv;","#ifdef USE_COLOR","\tattribute vec3 color;","#endif","#ifdef USE_MORPHTARGETS","\tattribute vec3 morphTarget0;","\tattribute vec3 morphTarget1;","\tattribute vec3 morphTarget2;","\tattribute vec3 morphTarget3;","\t#ifdef USE_MORPHNORMALS","\t\tattribute vec3 morphNormal0;","\t\tattribute vec3 morphNormal1;","\t\tattribute vec3 morphNormal2;","\t\tattribute vec3 morphNormal3;","\t#else","\t\tattribute vec3 morphTarget4;","\t\tattribute vec3 morphTarget5;","\t\tattribute vec3 morphTarget6;","\t\tattribute vec3 morphTarget7;","\t#endif","#endif","#ifdef USE_SKINNING","\tattribute vec4 skinIndex;","\tattribute vec4 skinWeight;","#endif","\n"].filter(Do).join("\n"),y=[S,"precision "+o.precision+" float;","precision "+o.precision+" int;","#define SHADER_NAME "+n.name,A,o.alphaTest?"#define ALPHATEST "+o.alphaTest:"","#define GAMMA_FACTOR "+w,o.useFog&&o.fog?"#define USE_FOG":"",o.useFog&&o.fogExp?"#define FOG_EXP2":"",o.map?"#define USE_MAP":"",o.envMap?"#define USE_ENVMAP":"",o.envMap?"#define "+l:"",o.envMap?"#define "+p:"",o.envMap?"#define "+d:"",o.lightMap?"#define USE_LIGHTMAP":"",o.aoMap?"#define USE_AOMAP":"",o.emissiveMap?"#define USE_EMISSIVEMAP":"",o.bumpMap?"#define USE_BUMPMAP":"",o.normalMap?"#define USE_NORMALMAP":"",o.specularMap?"#define USE_SPECULARMAP":"",o.roughnessMap?"#define USE_ROUGHNESSMAP":"",o.metalnessMap?"#define USE_METALNESSMAP":"",o.alphaMap?"#define USE_ALPHAMAP":"",o.vertexColors?"#define USE_COLOR":"",o.gradientMap?"#define USE_GRADIENTMAP":"",o.flatShading?"#define FLAT_SHADED":"",o.doubleSided?"#define DOUBLE_SIDED":"",o.flipSided?"#define FLIP_SIDED":"","#define NUM_CLIPPING_PLANES "+o.numClippingPlanes,"#define UNION_CLIPPING_PLANES "+(o.numClippingPlanes-o.numClipIntersection),o.shadowMapEnabled?"#define USE_SHADOWMAP":"",o.shadowMapEnabled?"#define "+h:"",o.premultipliedAlpha?"#define PREMULTIPLIED_ALPHA":"",o.physicallyCorrectLights?"#define PHYSICALLY_CORRECT_LIGHTS":"",o.logarithmicDepthBuffer?"#define USE_LOGDEPTHBUF":"",o.logarithmicDepthBuffer&&e.get("EXT_frag_depth")?"#define USE_LOGDEPTHBUF_EXT":"",o.envMap&&e.get("EXT_shader_texture_lod")?"#define TEXTURE_LOD_EXT":"","uniform mat4 viewMatrix;","uniform vec3 cameraPosition;",o.toneMapping!==It?"#define TONE_MAPPING":"",o.toneMapping!==It?Xi.tonemapping_pars_fragment:"",o.toneMapping!==It?function(t,e){var i;switch(e){case Rt:i="Linear";break;case Lt:i="Reinhard";break;case Ot:i="Uncharted2";break;case Dt:i="OptimizedCineon";break;default:throw new Error("unsupported toneMapping: "+e)}return"vec3 "+t+"( vec3 color ) { return "+i+"ToneMapping( color ); }"}("toneMapping",o.toneMapping):"",o.dithering?"#define DITHERING":"",o.outputEncoding||o.mapEncoding||o.envMapEncoding||o.emissiveMapEncoding?Xi.encodings_pars_fragment:"",o.mapEncoding?Oo("mapTexelToLinear",o.mapEncoding):"",o.envMapEncoding?Oo("envMapTexelToLinear",o.envMapEncoding):"",o.emissiveMapEncoding?Oo("emissiveMapTexelToLinear",o.emissiveMapEncoding):"",o.outputEncoding?(b="linearToOutputTexel",x=o.outputEncoding,_=Lo(x),"vec4 "+b+"( vec4 value ) { return LinearTo"+_[0]+_[1]+"; }"):"",o.depthPacking?"#define DEPTH_PACKING "+r.depthPacking:"","\n"].filter(Do).join("\n")),c=ko(c=No(c),o),u=ko(u=No(u),o),r.isShaderMaterial||(c=Bo(c),u=Bo(u));var P=v+c,T=y+u,E=go(a,a.VERTEX_SHADER,P),C=go(a,a.FRAGMENT_SHADER,T);a.attachShader(M,E),a.attachShader(M,C),void 0!==r.index0AttributeName?a.bindAttribLocation(M,0,r.index0AttributeName):!0===o.morphTargets&&a.bindAttribLocation(M,0,"position"),a.linkProgram(M);var I,R,L=a.getProgramInfoLog(M),O=a.getShaderInfoLog(E),D=a.getShaderInfoLog(C),k=!0,N=!0;return!1===a.getProgramParameter(M,a.LINK_STATUS)?(k=!1,console.error("THREE.WebGLProgram: shader error: ",a.getError(),"gl.VALIDATE_STATUS",a.getProgramParameter(M,a.VALIDATE_STATUS),"gl.getProgramInfoLog",L,O,D)):""!==L?console.warn("THREE.WebGLProgram: gl.getProgramInfoLog()",L):""!==O&&""!==D||(N=!1),N&&(this.diagnostics={runnable:k,material:r,programLog:L,vertexShader:{log:O,prefix:v},fragmentShader:{log:D,prefix:y}}),a.deleteShader(E),a.deleteShader(C),this.getUniforms=function(){return void 0===I&&(I=new Ui(a,M,t)),I},this.getAttributes=function(){return void 0===R&&(R=function(t,e){for(var i={},r=t.getProgramParameter(e,t.ACTIVE_ATTRIBUTES),n=0;n<r;n++){var o=t.getActiveAttrib(e,n).name;i[o]=t.getAttribLocation(e,o)}return i}(a,M)),R},this.destroy=function(){a.deleteProgram(M),this.program=void 0},Object.defineProperties(this,{uniforms:{get:function(){return console.warn("THREE.WebGLProgram: .uniforms is now .getUniforms()."),this.getUniforms()}},attributes:{get:function(){return console.warn("THREE.WebGLProgram: .attributes is now .getAttributes()."),this.getAttributes()}}}),this.id=Ro++,this.code=i,this.usedTimes=1,this.program=M,this.vertexShader=E,this.fragmentShader=C,this}function zo(t,e,i){var r=[],n={MeshDepthMaterial:"depth",MeshDistanceMaterial:"distanceRGBA",MeshNormalMaterial:"normal",MeshBasicMaterial:"basic",MeshLambertMaterial:"lambert",MeshPhongMaterial:"phong",MeshToonMaterial:"phong",MeshStandardMaterial:"physical",MeshPhysicalMaterial:"physical",LineBasicMaterial:"basic",LineDashedMaterial:"dashed",PointsMaterial:"points",ShadowMaterial:"shadow"},o=["precision","supportsVertexTextures","map","mapEncoding","envMap","envMapMode","envMapEncoding","lightMap","aoMap","emissiveMap","emissiveMapEncoding","bumpMap","normalMap","displacementMap","specularMap","roughnessMap","metalnessMap","gradientMap","alphaMap","combine","vertexColors","fog","useFog","fogExp","flatShading","sizeAttenuation","logarithmicDepthBuffer","skinning","maxBones","useVertexTexture","morphTargets","morphNormals","maxMorphTargets","maxMorphNormals","premultipliedAlpha","numDirLights","numPointLights","numSpotLights","numHemiLights","numRectAreaLights","shadowMapEnabled","shadowMapType","toneMapping","physicallyCorrectLights","alphaTest","doubleSided","flipSided","numClippingPlanes","numClipIntersection","depthPacking","dithering"];function a(t,e){var i;return t?t.isTexture?i=t.encoding:t.isWebGLRenderTarget&&(console.warn("THREE.WebGLPrograms.getTextureEncodingFromMap: don't use render targets as textures. Use their .texture property instead."),i=t.texture.encoding):i=Le,i===Le&&e&&(i=De),i}this.getParameters=function(e,r,o,s,c,u,h){var l=n[e.type],p=h.isSkinnedMesh?function(t){var e=t.skeleton.bones;if(i.floatVertexTextures)return 1024;var r=i.maxVertexUniforms,n=Math.floor((r-20)/4),o=Math.min(n,e.length);return o<e.length?(console.warn("THREE.WebGLRenderer: Skeleton has "+e.length+" bones. This GPU supports "+o+"."),0):o}(h):0,d=i.precision;null!==e.precision&&(d=i.getMaxPrecision(e.precision))!==e.precision&&console.warn("THREE.WebGLProgram.getParameters:",e.precision,"not supported, using",d,"instead.");var f=t.getRenderTarget();return{shaderID:l,precision:d,supportsVertexTextures:i.vertexTextures,outputEncoding:a(f?f.texture:null,t.gammaOutput),map:!!e.map,mapEncoding:a(e.map,t.gammaInput),envMap:!!e.envMap,envMapMode:e.envMap&&e.envMap.mapping,envMapEncoding:a(e.envMap,t.gammaInput),envMapCubeUV:!!e.envMap&&(e.envMap.mapping===Ut||e.envMap.mapping===jt),lightMap:!!e.lightMap,aoMap:!!e.aoMap,emissiveMap:!!e.emissiveMap,emissiveMapEncoding:a(e.emissiveMap,t.gammaInput),bumpMap:!!e.bumpMap,normalMap:!!e.normalMap,displacementMap:!!e.displacementMap,roughnessMap:!!e.roughnessMap,metalnessMap:!!e.metalnessMap,specularMap:!!e.specularMap,alphaMap:!!e.alphaMap,gradientMap:!!e.gradientMap,combine:e.combine,vertexColors:e.vertexColors,fog:!!s,useFog:e.fog,fogExp:s&&s.isFogExp2,flatShading:e.flatShading,sizeAttenuation:e.sizeAttenuation,logarithmicDepthBuffer:i.logarithmicDepthBuffer,skinning:e.skinning&&p>0,maxBones:p,useVertexTexture:i.floatVertexTextures,morphTargets:e.morphTargets,morphNormals:e.morphNormals,maxMorphTargets:t.maxMorphTargets,maxMorphNormals:t.maxMorphNormals,numDirLights:r.directional.length,numPointLights:r.point.length,numSpotLights:r.spot.length,numRectAreaLights:r.rectArea.length,numHemiLights:r.hemi.length,numClippingPlanes:c,numClipIntersection:u,dithering:e.dithering,shadowMapEnabled:t.shadowMap.enabled&&h.receiveShadow&&o.length>0,shadowMapType:t.shadowMap.type,toneMapping:t.toneMapping,physicallyCorrectLights:t.physicallyCorrectLights,premultipliedAlpha:e.premultipliedAlpha,alphaTest:e.alphaTest,doubleSided:e.side===X,flipSided:e.side===W,depthPacking:void 0!==e.depthPacking&&e.depthPacking}},this.getProgramCode=function(e,i){var r=[];if(i.shaderID?r.push(i.shaderID):(r.push(e.fragmentShader),r.push(e.vertexShader)),void 0!==e.defines)for(var n in e.defines)r.push(n),r.push(e.defines[n]);for(var a=0;a<o.length;a++)r.push(i[o[a]]);return r.push(e.onBeforeCompile.toString()),r.push(t.gammaOutput),r.join()},this.acquireProgram=function(i,n,o,a){for(var s,c=0,u=r.length;c<u;c++){var h=r[c];if(h.code===a){++(s=h).usedTimes;break}}return void 0===s&&(s=new Fo(t,e,a,i,n,o),r.push(s)),s},this.releaseProgram=function(t){if(0==--t.usedTimes){var e=r.indexOf(t);r[e]=r[r.length-1],r.pop(),t.destroy()}},this.programs=r}function Uo(t,e,i,r,n,o,a){var s="undefined"!=typeof WebGL2RenderingContext&&t instanceof window.WebGL2RenderingContext,c={};function u(t,e){if(t.width>e||t.height>e){var i=e/Math.max(t.width,t.height),r=document.createElementNS("http://www.w3.org/1999/xhtml","canvas");return r.width=Math.floor(t.width*i),r.height=Math.floor(t.height*i),r.getContext("2d").drawImage(t,0,0,t.width,t.height,0,0,r.width,r.height),console.warn("THREE.WebGLRenderer: image is too big ("+t.width+"x"+t.height+"). Resized to "+r.width+"x"+r.height,t),r}return t}function h(t){return je.isPowerOfTwo(t.width)&&je.isPowerOfTwo(t.height)}function l(t,e){return t.generateMipmaps&&e&&t.minFilter!==$t&&t.minFilter!==qt}function p(e){return e===$t||e===Wt||e===Xt?t.NEAREST:t.LINEAR}function d(e){var i=e.target;i.removeEventListener("dispose",d),function(e){var i=r.get(e);if(e.image&&i.__image__webglTextureCube)t.deleteTexture(i.__image__webglTextureCube);else{if(void 0===i.__webglInit)return;t.deleteTexture(i.__webglTexture)}r.remove(e)}(i),i.isVideoTexture&&delete c[i.id],a.textures--}function f(e){var i=e.target;i.removeEventListener("dispose",f),function(e){var i=r.get(e),n=r.get(e.texture);if(!e)return;void 0!==n.__webglTexture&&t.deleteTexture(n.__webglTexture);e.depthTexture&&e.depthTexture.dispose();if(e.isWebGLRenderTargetCube)for(var o=0;o<6;o++)t.deleteFramebuffer(i.__webglFramebuffer[o]),i.__webglDepthbuffer&&t.deleteRenderbuffer(i.__webglDepthbuffer[o]);else t.deleteFramebuffer(i.__webglFramebuffer),i.__webglDepthbuffer&&t.deleteRenderbuffer(i.__webglDepthbuffer);r.remove(e.texture),r.remove(e)}(i),a.textures--}function m(e,p){var f=r.get(e);if(e.version>0&&f.__version!==e.version){var m=e.image;if(void 0===m)console.warn("THREE.WebGLRenderer: Texture marked for update but image is undefined",e);else{if(!1!==m.complete)return void function(e,r,p){void 0===e.__webglInit&&(e.__webglInit=!0,r.addEventListener("dispose",d),e.__webglTexture=t.createTexture(),r.isVideoTexture&&(c[r.id]=r),a.textures++);i.activeTexture(t.TEXTURE0+p),i.bindTexture(t.TEXTURE_2D,e.__webglTexture),t.pixelStorei(t.UNPACK_FLIP_Y_WEBGL,r.flipY),t.pixelStorei(t.UNPACK_PREMULTIPLY_ALPHA_WEBGL,r.premultiplyAlpha),t.pixelStorei(t.UNPACK_ALIGNMENT,r.unpackAlignment);var f=u(r.image,n.maxTextureSize);m=r,(m.wrapS!==Vt||m.wrapT!==Vt||m.minFilter!==$t&&m.minFilter!==qt)&&!1===h(f)&&(f=function(t){if(t instanceof HTMLImageElement||t instanceof HTMLCanvasElement||t instanceof ImageBitmap){var e=document.createElementNS("http://www.w3.org/1999/xhtml","canvas");return e.width=je.floorPowerOfTwo(t.width),e.height=je.floorPowerOfTwo(t.height),e.getContext("2d").drawImage(t,0,0,e.width,e.height),console.warn("THREE.WebGLRenderer: image is not power of two ("+t.width+"x"+t.height+"). Resized to "+e.width+"x"+e.height,t),e}return t}(f));var m;var v=h(f),y=o.convert(r.format),b=o.convert(r.type);g(t.TEXTURE_2D,r,v);var x,_=r.mipmaps;if(r.isDepthTexture){var w=t.DEPTH_COMPONENT;if(r.type===re){if(!s)throw new Error("Float Depth Texture only supported in WebGL2.0");w=t.DEPTH_COMPONENT32F}else s&&(w=t.DEPTH_COMPONENT16);r.format===fe&&w===t.DEPTH_COMPONENT&&r.type!==te&&r.type!==ie&&(console.warn("THREE.WebGLRenderer: Use UnsignedShortType or UnsignedIntType for DepthFormat DepthTexture."),r.type=te,b=o.convert(r.type)),r.format===ge&&(w=t.DEPTH_STENCIL,r.type!==ce&&(console.warn("THREE.WebGLRenderer: Use UnsignedInt248Type for DepthStencilFormat DepthTexture."),r.type=ce,b=o.convert(r.type))),i.texImage2D(t.TEXTURE_2D,0,w,f.width,f.height,0,y,b,null)}else if(r.isDataTexture)if(_.length>0&&v){for(var S=0,A=_.length;S<A;S++)x=_[S],i.texImage2D(t.TEXTURE_2D,S,y,x.width,x.height,0,y,b,x.data);r.generateMipmaps=!1}else i.texImage2D(t.TEXTURE_2D,0,y,f.width,f.height,0,y,b,f.data);else if(r.isCompressedTexture)for(var S=0,A=_.length;S<A;S++)x=_[S],r.format!==le&&r.format!==he?i.getCompressedTextureFormats().indexOf(y)>-1?i.compressedTexImage2D(t.TEXTURE_2D,S,y,x.width,x.height,0,x.data):console.warn("THREE.WebGLRenderer: Attempt to load unsupported compressed texture format in .uploadTexture()"):i.texImage2D(t.TEXTURE_2D,S,y,x.width,x.height,0,y,b,x.data);else if(_.length>0&&v){for(var S=0,A=_.length;S<A;S++)x=_[S],i.texImage2D(t.TEXTURE_2D,S,y,y,b,x);r.generateMipmaps=!1}else i.texImage2D(t.TEXTURE_2D,0,y,y,b,f);l(r,v)&&t.generateMipmap(t.TEXTURE_2D);e.__version=r.version,r.onUpdate&&r.onUpdate(r)}(f,e,p);console.warn("THREE.WebGLRenderer: Texture marked for update but image is incomplete",e)}}i.activeTexture(t.TEXTURE0+p),i.bindTexture(t.TEXTURE_2D,f.__webglTexture)}function g(i,a,s){var c;if(s?(t.texParameteri(i,t.TEXTURE_WRAP_S,o.convert(a.wrapS)),t.texParameteri(i,t.TEXTURE_WRAP_T,o.convert(a.wrapT)),t.texParameteri(i,t.TEXTURE_MAG_FILTER,o.convert(a.magFilter)),t.texParameteri(i,t.TEXTURE_MIN_FILTER,o.convert(a.minFilter))):(t.texParameteri(i,t.TEXTURE_WRAP_S,t.CLAMP_TO_EDGE),t.texParameteri(i,t.TEXTURE_WRAP_T,t.CLAMP_TO_EDGE),a.wrapS===Vt&&a.wrapT===Vt||console.warn("THREE.WebGLRenderer: Texture is not power of two. Texture.wrapS and Texture.wrapT should be set to THREE.ClampToEdgeWrapping.",a),t.texParameteri(i,t.TEXTURE_MAG_FILTER,p(a.magFilter)),t.texParameteri(i,t.TEXTURE_MIN_FILTER,p(a.minFilter)),a.minFilter!==$t&&a.minFilter!==qt&&console.warn("THREE.WebGLRenderer: Texture is not power of two. Texture.minFilter should be set to THREE.NearestFilter or THREE.LinearFilter.",a)),c=e.get("EXT_texture_filter_anisotropic")){if(a.type===re&&null===e.get("OES_texture_float_linear"))return;if(a.type===ne&&null===e.get("OES_texture_half_float_linear"))return;(a.anisotropy>1||r.get(a).__currentAnisotropy)&&(t.texParameterf(i,c.TEXTURE_MAX_ANISOTROPY_EXT,Math.min(a.anisotropy,n.getMaxAnisotropy())),r.get(a).__currentAnisotropy=a.anisotropy)}}function v(e,n,a,s){var c=o.convert(n.texture.format),u=o.convert(n.texture.type);i.texImage2D(s,0,c,n.width,n.height,0,c,u,null),t.bindFramebuffer(t.FRAMEBUFFER,e),t.framebufferTexture2D(t.FRAMEBUFFER,a,s,r.get(n.texture).__webglTexture,0),t.bindFramebuffer(t.FRAMEBUFFER,null)}function y(e,i){t.bindRenderbuffer(t.RENDERBUFFER,e),i.depthBuffer&&!i.stencilBuffer?(t.renderbufferStorage(t.RENDERBUFFER,t.DEPTH_COMPONENT16,i.width,i.height),t.framebufferRenderbuffer(t.FRAMEBUFFER,t.DEPTH_ATTACHMENT,t.RENDERBUFFER,e)):i.depthBuffer&&i.stencilBuffer?(t.renderbufferStorage(t.RENDERBUFFER,t.DEPTH_STENCIL,i.width,i.height),t.framebufferRenderbuffer(t.FRAMEBUFFER,t.DEPTH_STENCIL_ATTACHMENT,t.RENDERBUFFER,e)):t.renderbufferStorage(t.RENDERBUFFER,t.RGBA4,i.width,i.height),t.bindRenderbuffer(t.RENDERBUFFER,null)}function b(e){var i=r.get(e),n=!0===e.isWebGLRenderTargetCube;if(e.depthTexture){if(n)throw new Error("target.depthTexture not supported in Cube render targets");!function(e,i){if(i&&i.isWebGLRenderTargetCube)throw new Error("Depth Texture with cube render targets is not supported");if(t.bindFramebuffer(t.FRAMEBUFFER,e),!i.depthTexture||!i.depthTexture.isDepthTexture)throw new Error("renderTarget.depthTexture must be an instance of THREE.DepthTexture");r.get(i.depthTexture).__webglTexture&&i.depthTexture.image.width===i.width&&i.depthTexture.image.height===i.height||(i.depthTexture.image.width=i.width,i.depthTexture.image.height=i.height,i.depthTexture.needsUpdate=!0),m(i.depthTexture,0);var n=r.get(i.depthTexture).__webglTexture;if(i.depthTexture.format===fe)t.framebufferTexture2D(t.FRAMEBUFFER,t.DEPTH_ATTACHMENT,t.TEXTURE_2D,n,0);else{if(i.depthTexture.format!==ge)throw new Error("Unknown depthTexture format");t.framebufferTexture2D(t.FRAMEBUFFER,t.DEPTH_STENCIL_ATTACHMENT,t.TEXTURE_2D,n,0)}}(i.__webglFramebuffer,e)}else if(n){i.__webglDepthbuffer=[];for(var o=0;o<6;o++)t.bindFramebuffer(t.FRAMEBUFFER,i.__webglFramebuffer[o]),i.__webglDepthbuffer[o]=t.createRenderbuffer(),y(i.__webglDepthbuffer[o],e)}else t.bindFramebuffer(t.FRAMEBUFFER,i.__webglFramebuffer),i.__webglDepthbuffer=t.createRenderbuffer(),y(i.__webglDepthbuffer,e);t.bindFramebuffer(t.FRAMEBUFFER,null)}this.setTexture2D=m,this.setTextureCube=function(e,s){var c=r.get(e);if(6===e.image.length)if(e.version>0&&c.__version!==e.version){c.__image__webglTextureCube||(e.addEventListener("dispose",d),c.__image__webglTextureCube=t.createTexture(),a.textures++),i.activeTexture(t.TEXTURE0+s),i.bindTexture(t.TEXTURE_CUBE_MAP,c.__image__webglTextureCube),t.pixelStorei(t.UNPACK_FLIP_Y_WEBGL,e.flipY);for(var p=e&&e.isCompressedTexture,f=e.image[0]&&e.image[0].isDataTexture,m=[],v=0;v<6;v++)m[v]=p||f?f?e.image[v].image:e.image[v]:u(e.image[v],n.maxCubemapSize);var y=h(m[0]),b=o.convert(e.format),x=o.convert(e.type);for(g(t.TEXTURE_CUBE_MAP,e,y),v=0;v<6;v++)if(p)for(var _,w=m[v].mipmaps,S=0,A=w.length;S<A;S++)_=w[S],e.format!==le&&e.format!==he?i.getCompressedTextureFormats().indexOf(b)>-1?i.compressedTexImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+v,S,b,_.width,_.height,0,_.data):console.warn("THREE.WebGLRenderer: Attempt to load unsupported compressed texture format in .setTextureCube()"):i.texImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+v,S,b,_.width,_.height,0,b,x,_.data);else f?i.texImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+v,0,b,m[v].width,m[v].height,0,b,x,m[v].data):i.texImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+v,0,b,b,x,m[v]);l(e,y)&&t.generateMipmap(t.TEXTURE_CUBE_MAP),c.__version=e.version,e.onUpdate&&e.onUpdate(e)}else i.activeTexture(t.TEXTURE0+s),i.bindTexture(t.TEXTURE_CUBE_MAP,c.__image__webglTextureCube)},this.setTextureCubeDynamic=function(e,n){i.activeTexture(t.TEXTURE0+n),i.bindTexture(t.TEXTURE_CUBE_MAP,r.get(e).__webglTexture)},this.setupRenderTarget=function(e){var n=r.get(e),o=r.get(e.texture);e.addEventListener("dispose",f),o.__webglTexture=t.createTexture(),a.textures++;var s=!0===e.isWebGLRenderTargetCube,c=h(e);if(s){n.__webglFramebuffer=[];for(var u=0;u<6;u++)n.__webglFramebuffer[u]=t.createFramebuffer()}else n.__webglFramebuffer=t.createFramebuffer();if(s){for(i.bindTexture(t.TEXTURE_CUBE_MAP,o.__webglTexture),g(t.TEXTURE_CUBE_MAP,e.texture,c),u=0;u<6;u++)v(n.__webglFramebuffer[u],e,t.COLOR_ATTACHMENT0,t.TEXTURE_CUBE_MAP_POSITIVE_X+u);l(e.texture,c)&&t.generateMipmap(t.TEXTURE_CUBE_MAP),i.bindTexture(t.TEXTURE_CUBE_MAP,null)}else i.bindTexture(t.TEXTURE_2D,o.__webglTexture),g(t.TEXTURE_2D,e.texture,c),v(n.__webglFramebuffer,e,t.COLOR_ATTACHMENT0,t.TEXTURE_2D),l(e.texture,c)&&t.generateMipmap(t.TEXTURE_2D),i.bindTexture(t.TEXTURE_2D,null);e.depthBuffer&&b(e)},this.updateRenderTargetMipmap=function(e){var n=e.texture;if(l(n,h(e))){var o=e.isWebGLRenderTargetCube?t.TEXTURE_CUBE_MAP:t.TEXTURE_2D,a=r.get(n).__webglTexture;i.bindTexture(o,a),t.generateMipmap(o),i.bindTexture(o,null)}},this.updateVideoTextures=function(){for(var t in c)c[t].update()}}function jo(t,e,i,r){Yr.call(this),this.type="PerspectiveCamera",this.fov=void 0!==t?t:50,this.zoom=1,this.near=void 0!==i?i:.1,this.far=void 0!==r?r:2e3,this.focus=10,this.aspect=void 0!==e?e:1,this.view=null,this.filmGauge=35,this.filmOffset=0,this.updateProjectionMatrix()}function Go(t){jo.call(this),this.cameras=t||[]}function Vo(t){var e=this,i=null,r=null,n=null;"undefined"!=typeof window&&"VRFrameData"in window&&(r=new window.VRFrameData);var o=new Ve,a=new jo;a.bounds=new Ke(0,0,.5,1),a.layers.enable(1);var s=new jo;s.bounds=new Ke(.5,0,.5,1),s.layers.enable(2);var c,u,h=new Go([a,s]);function l(){if(null!==i&&i.isPresenting){var r=i.getEyeParameters("left"),n=r.renderWidth,o=r.renderHeight;u=t.getPixelRatio(),c=t.getSize(),t.setDrawingBufferSize(2*n,o,1)}else e.enabled&&t.setDrawingBufferSize(c.width,c.height,u)}h.layers.enable(1),h.layers.enable(2),"undefined"!=typeof window&&window.addEventListener("vrdisplaypresentchange",l,!1),this.enabled=!1,this.getDevice=function(){return i},this.setDevice=function(t){void 0!==t&&(i=t)},this.setPoseTarget=function(t){void 0!==t&&(n=t)},this.getCamera=function(t){if(null===i)return t;i.depthNear=t.near,i.depthFar=t.far,i.getFrameData(r);var e=r.pose,c=null!==n?n:t;if(null!==e.position?c.position.fromArray(e.position):c.position.set(0,0,0),null!==e.orientation&&c.quaternion.fromArray(e.orientation),c.updateMatrixWorld(),!1===i.isPresenting)return t;a.near=t.near,s.near=t.near,a.far=t.far,s.far=t.far,h.matrixWorld.copy(t.matrixWorld),h.matrixWorldInverse.copy(t.matrixWorldInverse),a.matrixWorldInverse.fromArray(r.leftViewMatrix),s.matrixWorldInverse.fromArray(r.rightViewMatrix);var u=c.parent;null!==u&&(o.getInverse(u.matrixWorld),a.matrixWorldInverse.multiply(o),s.matrixWorldInverse.multiply(o)),a.matrixWorld.getInverse(a.matrixWorldInverse),s.matrixWorld.getInverse(s.matrixWorldInverse),a.projectionMatrix.fromArray(r.leftProjectionMatrix),s.projectionMatrix.fromArray(r.rightProjectionMatrix),h.projectionMatrix.copy(a.projectionMatrix);var l=i.getLayers();if(l.length){var p=l[0];null!==p.leftBounds&&4===p.leftBounds.length&&a.bounds.fromArray(p.leftBounds),null!==p.rightBounds&&4===p.rightBounds.length&&s.bounds.fromArray(p.rightBounds)}return h},this.submitFrame=function(){i&&i.isPresenting&&i.submitFrame()},this.dispose=function(){"undefined"!=typeof window&&window.removeEventListener("vrdisplaypresentchange",l)}}function Ho(t){console.log("THREE.WebGLRenderer",F);var e=void 0!==(t=t||{}).canvas?t.canvas:document.createElementNS("http://www.w3.org/1999/xhtml","canvas"),i=void 0!==t.context?t.context:null,r=void 0!==t.alpha&&t.alpha,n=void 0===t.depth||t.depth,o=void 0===t.stencil||t.stencil,a=void 0!==t.antialias&&t.antialias,s=void 0===t.premultipliedAlpha||t.premultipliedAlpha,c=void 0!==t.preserveDrawingBuffer&&t.preserveDrawingBuffer,u=void 0!==t.powerPreference?t.powerPreference:"default",h=[],l=[],p=null,d=[],f=[];this.domElement=e,this.context=null,this.autoClear=!0,this.autoClearColor=!0,this.autoClearDepth=!0,this.autoClearStencil=!0,this.sortObjects=!0,this.clippingPlanes=[],this.localClippingEnabled=!1,this.gammaFactor=2,this.gammaInput=!1,this.gammaOutput=!1,this.physicallyCorrectLights=!1,this.toneMapping=Rt,this.toneMappingExposure=1,this.toneMappingWhitePoint=1,this.maxMorphTargets=8,this.maxMorphNormals=4;var m,g,v,y,b,x,_,w,S,A,M,P,T,E,C,I,R,L,O,D=this,k=!1,N=null,B=null,V=-1,H="",$=null,Y=null,Z=new Ke,Tt=new Ke,Et=null,Ct=0,It=e.width,Lt=e.height,Ot=1,Dt=new Ke(0,0,It,Lt),kt=new Ke(0,0,It,Lt),Nt=!1,Bt=new Sr,Ft=new function(){var t=this,e=null,i=0,r=!1,n=!1,o=new wr,a=new We,s={value:null,needsUpdate:!1};function c(){s.value!==e&&(s.value=e,s.needsUpdate=i>0),t.numPlanes=i,t.numIntersection=0}function u(e,i,r,n){var c=null!==e?e.length:0,u=null;if(0!==c){if(u=s.value,!0!==n||null===u){var h=r+4*c,l=i.matrixWorldInverse;a.getNormalMatrix(l),(null===u||u.length<h)&&(u=new Float32Array(h));for(var p=0,d=r;p!==c;++p,d+=4)o.copy(e[p]).applyMatrix4(l,a),o.normal.toArray(u,d),u[d+3]=o.constant}s.value=u,s.needsUpdate=!0}return t.numPlanes=c,u}this.uniform=s,this.numPlanes=0,this.numIntersection=0,this.init=function(t,n,o){var a=0!==t.length||n||0!==i||r;return r=n,e=u(t,o,0),i=t.length,a},this.beginShadows=function(){n=!0,u(null)},this.endShadows=function(){n=!1,c()},this.setState=function(t,o,a,h,l,p){if(!r||null===t||0===t.length||n&&!a)n?u(null):c();else{var d=n?0:i,f=4*d,m=l.clippingState||null;s.value=m,m=u(t,h,f,p);for(var g=0;g!==f;++g)m[g]=e[g];l.clippingState=m,this.numIntersection=o?this.numPlanes:0,this.numPlanes+=d}}},zt=!1,Ut=!1,jt=new Ve,me=new $e,Pe={geometries:0,textures:0},Te={frame:0,calls:0,vertices:0,faces:0,points:0};function Ee(){return null===N?Ot:1}this.info={render:Te,memory:Pe,programs:null};try{var Le={alpha:r,depth:n,stencil:o,antialias:a,premultipliedAlpha:s,preserveDrawingBuffer:c,powerPreference:u};if(e.addEventListener("webglcontextlost",Ne,!1),e.addEventListener("webglcontextrestored",Be,!1),null===(m=i||e.getContext("webgl",Le)||e.getContext("experimental-webgl",Le)))throw null!==e.getContext("webgl")?new Error("Error creating WebGL context with your selected attributes."):new Error("Error creating WebGL context.");void 0===m.getShaderPrecisionFormat&&(m.getShaderPrecisionFormat=function(){return{rangeMin:1,rangeMax:1,precision:1}})}catch(t){console.error("THREE.WebGLRenderer: "+t.message)}function Oe(){(g=new function(t){var e={};return{get:function(i){if(void 0!==e[i])return e[i];var r;switch(i){case"WEBGL_depth_texture":r=t.getExtension("WEBGL_depth_texture")||t.getExtension("MOZ_WEBGL_depth_texture")||t.getExtension("WEBKIT_WEBGL_depth_texture");break;case"EXT_texture_filter_anisotropic":r=t.getExtension("EXT_texture_filter_anisotropic")||t.getExtension("MOZ_EXT_texture_filter_anisotropic")||t.getExtension("WEBKIT_EXT_texture_filter_anisotropic");break;case"WEBGL_compressed_texture_s3tc":r=t.getExtension("WEBGL_compressed_texture_s3tc")||t.getExtension("MOZ_WEBGL_compressed_texture_s3tc")||t.getExtension("WEBKIT_WEBGL_compressed_texture_s3tc");break;case"WEBGL_compressed_texture_pvrtc":r=t.getExtension("WEBGL_compressed_texture_pvrtc")||t.getExtension("WEBKIT_WEBGL_compressed_texture_pvrtc");break;case"WEBGL_compressed_texture_etc1":r=t.getExtension("WEBGL_compressed_texture_etc1");break;default:r=t.getExtension(i)}return null===r&&console.warn("THREE.WebGLRenderer: "+i+" extension not supported."),e[i]=r,r}}}(m)).get("WEBGL_depth_texture"),g.get("OES_texture_float"),g.get("OES_texture_float_linear"),g.get("OES_texture_half_float"),g.get("OES_texture_half_float_linear"),g.get("OES_standard_derivatives"),g.get("OES_element_index_uint"),g.get("ANGLE_instanced_arrays"),O=new function(t,e){return{convert:function(i){var r;if(i===Gt)return t.REPEAT;if(i===Vt)return t.CLAMP_TO_EDGE;if(i===Ht)return t.MIRRORED_REPEAT;if(i===$t)return t.NEAREST;if(i===Wt)return t.NEAREST_MIPMAP_NEAREST;if(i===Xt)return t.NEAREST_MIPMAP_LINEAR;if(i===qt)return t.LINEAR;if(i===Yt)return t.LINEAR_MIPMAP_NEAREST;if(i===Zt)return t.LINEAR_MIPMAP_LINEAR;if(i===Kt)return t.UNSIGNED_BYTE;if(i===oe)return t.UNSIGNED_SHORT_4_4_4_4;if(i===ae)return t.UNSIGNED_SHORT_5_5_5_1;if(i===se)return t.UNSIGNED_SHORT_5_6_5;if(i===Jt)return t.BYTE;if(i===Qt)return t.SHORT;if(i===te)return t.UNSIGNED_SHORT;if(i===ee)return t.INT;if(i===ie)return t.UNSIGNED_INT;if(i===re)return t.FLOAT;if(i===ne&&null!==(r=e.get("OES_texture_half_float")))return r.HALF_FLOAT_OES;if(i===ue)return t.ALPHA;if(i===he)return t.RGB;if(i===le)return t.RGBA;if(i===pe)return t.LUMINANCE;if(i===de)return t.LUMINANCE_ALPHA;if(i===fe)return t.DEPTH_COMPONENT;if(i===ge)return t.DEPTH_STENCIL;if(i===rt)return t.FUNC_ADD;if(i===nt)return t.FUNC_SUBTRACT;if(i===ot)return t.FUNC_REVERSE_SUBTRACT;if(i===ct)return t.ZERO;if(i===ut)return t.ONE;if(i===ht)return t.SRC_COLOR;if(i===lt)return t.ONE_MINUS_SRC_COLOR;if(i===pt)return t.SRC_ALPHA;if(i===dt)return t.ONE_MINUS_SRC_ALPHA;if(i===ft)return t.DST_ALPHA;if(i===mt)return t.ONE_MINUS_DST_ALPHA;if(i===gt)return t.DST_COLOR;if(i===vt)return t.ONE_MINUS_DST_COLOR;if(i===yt)return t.SRC_ALPHA_SATURATE;if((i===ve||i===ye||i===be||i===xe)&&null!==(r=e.get("WEBGL_compressed_texture_s3tc"))){if(i===ve)return r.COMPRESSED_RGB_S3TC_DXT1_EXT;if(i===ye)return r.COMPRESSED_RGBA_S3TC_DXT1_EXT;if(i===be)return r.COMPRESSED_RGBA_S3TC_DXT3_EXT;if(i===xe)return r.COMPRESSED_RGBA_S3TC_DXT5_EXT}if((i===_e||i===we||i===Se||i===Ae)&&null!==(r=e.get("WEBGL_compressed_texture_pvrtc"))){if(i===_e)return r.COMPRESSED_RGB_PVRTC_4BPPV1_IMG;if(i===we)return r.COMPRESSED_RGB_PVRTC_2BPPV1_IMG;if(i===Se)return r.COMPRESSED_RGBA_PVRTC_4BPPV1_IMG;if(i===Ae)return r.COMPRESSED_RGBA_PVRTC_2BPPV1_IMG}if(i===Me&&null!==(r=e.get("WEBGL_compressed_texture_etc1")))return r.COMPRESSED_RGB_ETC1_WEBGL;if((i===at||i===st)&&null!==(r=e.get("EXT_blend_minmax"))){if(i===at)return r.MIN_EXT;if(i===st)return r.MAX_EXT}return i===ce&&null!==(r=e.get("WEBGL_depth_texture"))?r.UNSIGNED_INT_24_8_WEBGL:0}}}(m,g),v=new function(t,e,i){var r;function n(e){if("highp"===e){if(t.getShaderPrecisionFormat(t.VERTEX_SHADER,t.HIGH_FLOAT).precision>0&&t.getShaderPrecisionFormat(t.FRAGMENT_SHADER,t.HIGH_FLOAT).precision>0)return"highp";e="mediump"}return"mediump"===e&&t.getShaderPrecisionFormat(t.VERTEX_SHADER,t.MEDIUM_FLOAT).precision>0&&t.getShaderPrecisionFormat(t.FRAGMENT_SHADER,t.MEDIUM_FLOAT).precision>0?"mediump":"lowp"}var o=void 0!==i.precision?i.precision:"highp",a=n(o);a!==o&&(console.warn("THREE.WebGLRenderer:",o,"not supported, using",a,"instead."),o=a);var s=!0===i.logarithmicDepthBuffer,c=t.getParameter(t.MAX_TEXTURE_IMAGE_UNITS),u=t.getParameter(t.MAX_VERTEX_TEXTURE_IMAGE_UNITS),h=t.getParameter(t.MAX_TEXTURE_SIZE),l=t.getParameter(t.MAX_CUBE_MAP_TEXTURE_SIZE),p=t.getParameter(t.MAX_VERTEX_ATTRIBS),d=t.getParameter(t.MAX_VERTEX_UNIFORM_VECTORS),f=t.getParameter(t.MAX_VARYING_VECTORS),m=t.getParameter(t.MAX_FRAGMENT_UNIFORM_VECTORS),g=u>0,v=!!e.get("OES_texture_float");return{getMaxAnisotropy:function(){if(void 0!==r)return r;var i=e.get("EXT_texture_filter_anisotropic");return r=null!==i?t.getParameter(i.MAX_TEXTURE_MAX_ANISOTROPY_EXT):0},getMaxPrecision:n,precision:o,logarithmicDepthBuffer:s,maxTextures:c,maxVertexTextures:u,maxTextureSize:h,maxCubemapSize:l,maxAttributes:p,maxVertexUniforms:d,maxVaryings:f,maxFragmentUniforms:m,vertexTextures:g,floatFragmentTextures:v,floatVertexTextures:g&&v}}(m,g,t),(y=new function(t,e,i){var r=new function(){var e=!1,i=new Ke,r=null,n=new Ke(0,0,0,0);return{setMask:function(i){r===i||e||(t.colorMask(i,i,i,i),r=i)},setLocked:function(t){e=t},setClear:function(e,r,o,a,s){!0===s&&(e*=a,r*=a,o*=a),i.set(e,r,o,a),!1===n.equals(i)&&(t.clearColor(e,r,o,a),n.copy(i))},reset:function(){e=!1,r=null,n.set(-1,0,0,0)}}},n=new function(){var e=!1,i=null,r=null,n=null;return{setTest:function(e){e?k(t.DEPTH_TEST):N(t.DEPTH_TEST)},setMask:function(r){i===r||e||(t.depthMask(r),i=r)},setFunc:function(e){if(r!==e){if(e)switch(e){case bt:t.depthFunc(t.NEVER);break;case xt:t.depthFunc(t.ALWAYS);break;case _t:t.depthFunc(t.LESS);break;case wt:t.depthFunc(t.LEQUAL);break;case St:t.depthFunc(t.EQUAL);break;case At:t.depthFunc(t.GEQUAL);break;case Mt:t.depthFunc(t.GREATER);break;case Pt:t.depthFunc(t.NOTEQUAL);break;default:t.depthFunc(t.LEQUAL)}else t.depthFunc(t.LEQUAL);r=e}},setLocked:function(t){e=t},setClear:function(e){n!==e&&(t.clearDepth(e),n=e)},reset:function(){e=!1,i=null,r=null,n=null}}},o=new function(){var e=!1,i=null,r=null,n=null,o=null,a=null,s=null,c=null,u=null;return{setTest:function(e){e?k(t.STENCIL_TEST):N(t.STENCIL_TEST)},setMask:function(r){i===r||e||(t.stencilMask(r),i=r)},setFunc:function(e,i,a){r===e&&n===i&&o===a||(t.stencilFunc(e,i,a),r=e,n=i,o=a)},setOp:function(e,i,r){a===e&&s===i&&c===r||(t.stencilOp(e,i,r),a=e,s=i,c=r)},setLocked:function(t){e=t},setClear:function(e){u!==e&&(t.clearStencil(e),u=e)},reset:function(){e=!1,i=null,r=null,n=null,o=null,a=null,s=null,c=null,u=null}}},a=t.getParameter(t.MAX_VERTEX_ATTRIBS),s=new Uint8Array(a),c=new Uint8Array(a),u=new Uint8Array(a),h={},l=null,p=null,d=null,f=null,m=null,g=null,v=null,y=null,b=null,x=!1,_=null,w=null,S=null,A=null,M=null,P=t.getParameter(t.MAX_COMBINED_TEXTURE_IMAGE_UNITS),T=parseFloat(/^WebGL\ ([0-9])/.exec(t.getParameter(t.VERSION))[1]),E=parseFloat(T)>=1,C=null,I={},R=new Ke,L=new Ke;function O(e,i,r){var n=new Uint8Array(4),o=t.createTexture();t.bindTexture(e,o),t.texParameteri(e,t.TEXTURE_MIN_FILTER,t.NEAREST),t.texParameteri(e,t.TEXTURE_MAG_FILTER,t.NEAREST);for(var a=0;a<r;a++)t.texImage2D(i+a,0,t.RGBA,1,1,0,t.RGBA,t.UNSIGNED_BYTE,n);return o}var D={};function k(e){!0!==h[e]&&(t.enable(e),h[e]=!0)}function N(e){!1!==h[e]&&(t.disable(e),h[e]=!1)}function B(e,r,n,o,a,s,c,u){if(e!==K?k(t.BLEND):N(t.BLEND),e!==it){if(e!==d||u!==x)switch(e){case Q:u?(t.blendEquationSeparate(t.FUNC_ADD,t.FUNC_ADD),t.blendFuncSeparate(t.ONE,t.ONE,t.ONE,t.ONE)):(t.blendEquation(t.FUNC_ADD),t.blendFunc(t.SRC_ALPHA,t.ONE));break;case tt:u?(t.blendEquationSeparate(t.FUNC_ADD,t.FUNC_ADD),t.blendFuncSeparate(t.ZERO,t.ZERO,t.ONE_MINUS_SRC_COLOR,t.ONE_MINUS_SRC_ALPHA)):(t.blendEquation(t.FUNC_ADD),t.blendFunc(t.ZERO,t.ONE_MINUS_SRC_COLOR));break;case et:u?(t.blendEquationSeparate(t.FUNC_ADD,t.FUNC_ADD),t.blendFuncSeparate(t.ZERO,t.SRC_COLOR,t.ZERO,t.SRC_ALPHA)):(t.blendEquation(t.FUNC_ADD),t.blendFunc(t.ZERO,t.SRC_COLOR));break;default:u?(t.blendEquationSeparate(t.FUNC_ADD,t.FUNC_ADD),t.blendFuncSeparate(t.ONE,t.ONE_MINUS_SRC_ALPHA,t.ONE,t.ONE_MINUS_SRC_ALPHA)):(t.blendEquationSeparate(t.FUNC_ADD,t.FUNC_ADD),t.blendFuncSeparate(t.SRC_ALPHA,t.ONE_MINUS_SRC_ALPHA,t.ONE,t.ONE_MINUS_SRC_ALPHA))}f=null,m=null,g=null,v=null,y=null,b=null}else a=a||r,s=s||n,c=c||o,r===f&&a===v||(t.blendEquationSeparate(i.convert(r),i.convert(a)),f=r,v=a),n===m&&o===g&&s===y&&c===b||(t.blendFuncSeparate(i.convert(n),i.convert(o),i.convert(s),i.convert(c)),m=n,g=o,y=s,b=c);d=e,x=u}function F(e){_!==e&&(e?t.frontFace(t.CW):t.frontFace(t.CCW),_=e)}function G(e){e!==z?(k(t.CULL_FACE),e!==w&&(e===U?t.cullFace(t.BACK):e===j?t.cullFace(t.FRONT):t.cullFace(t.FRONT_AND_BACK))):N(t.CULL_FACE),w=e}function V(e,i,r){e?(k(t.POLYGON_OFFSET_FILL),A===i&&M===r||(t.polygonOffset(i,r),A=i,M=r)):N(t.POLYGON_OFFSET_FILL)}function H(e){void 0===e&&(e=t.TEXTURE0+P-1),C!==e&&(t.activeTexture(e),C=e)}return D[t.TEXTURE_2D]=O(t.TEXTURE_2D,t.TEXTURE_2D,1),D[t.TEXTURE_CUBE_MAP]=O(t.TEXTURE_CUBE_MAP,t.TEXTURE_CUBE_MAP_POSITIVE_X,6),r.setClear(0,0,0,1),n.setClear(1),o.setClear(0),k(t.DEPTH_TEST),n.setFunc(wt),F(!1),G(U),k(t.CULL_FACE),k(t.BLEND),B(J),{buffers:{color:r,depth:n,stencil:o},initAttributes:function(){for(var t=0,e=s.length;t<e;t++)s[t]=0},enableAttribute:function(i){s[i]=1,0===c[i]&&(t.enableVertexAttribArray(i),c[i]=1),0!==u[i]&&(e.get("ANGLE_instanced_arrays").vertexAttribDivisorANGLE(i,0),u[i]=0)},enableAttributeAndDivisor:function(i,r){s[i]=1,0===c[i]&&(t.enableVertexAttribArray(i),c[i]=1),u[i]!==r&&(e.get("ANGLE_instanced_arrays").vertexAttribDivisorANGLE(i,r),u[i]=r)},disableUnusedAttributes:function(){for(var e=0,i=c.length;e!==i;++e)c[e]!==s[e]&&(t.disableVertexAttribArray(e),c[e]=0)},enable:k,disable:N,getCompressedTextureFormats:function(){if(null===l&&(l=[],e.get("WEBGL_compressed_texture_pvrtc")||e.get("WEBGL_compressed_texture_s3tc")||e.get("WEBGL_compressed_texture_etc1")))for(var i=t.getParameter(t.COMPRESSED_TEXTURE_FORMATS),r=0;r<i.length;r++)l.push(i[r]);return l},useProgram:function(e){return p!==e&&(t.useProgram(e),p=e,!0)},setBlending:B,setMaterial:function(e,i){e.side===X?N(t.CULL_FACE):k(t.CULL_FACE);var o=e.side===W;i&&(o=!o),F(o),!0===e.transparent?B(e.blending,e.blendEquation,e.blendSrc,e.blendDst,e.blendEquationAlpha,e.blendSrcAlpha,e.blendDstAlpha,e.premultipliedAlpha):B(K),n.setFunc(e.depthFunc),n.setTest(e.depthTest),n.setMask(e.depthWrite),r.setMask(e.colorWrite),V(e.polygonOffset,e.polygonOffsetFactor,e.polygonOffsetUnits)},setFlipSided:F,setCullFace:G,setLineWidth:function(e){e!==S&&(E&&t.lineWidth(e),S=e)},setPolygonOffset:V,setScissorTest:function(e){e?k(t.SCISSOR_TEST):N(t.SCISSOR_TEST)},activeTexture:H,bindTexture:function(e,i){null===C&&H();var r=I[C];void 0===r&&(r={type:void 0,texture:void 0},I[C]=r),r.type===e&&r.texture===i||(t.bindTexture(e,i||D[e]),r.type=e,r.texture=i)},compressedTexImage2D:function(){try{t.compressedTexImage2D.apply(t,arguments)}catch(t){console.error("THREE.WebGLState:",t)}},texImage2D:function(){try{t.texImage2D.apply(t,arguments)}catch(t){console.error("THREE.WebGLState:",t)}},scissor:function(e){!1===R.equals(e)&&(t.scissor(e.x,e.y,e.z,e.w),R.copy(e))},viewport:function(e){!1===L.equals(e)&&(t.viewport(e.x,e.y,e.z,e.w),L.copy(e))},reset:function(){for(var e=0;e<c.length;e++)1===c[e]&&(t.disableVertexAttribArray(e),c[e]=0);h={},l=null,C=null,I={},p=null,d=null,_=null,w=null,r.reset(),n.reset(),o.reset()}}}(m,g,O)).scissor(Tt.copy(kt).multiplyScalar(Ot)),y.viewport(Z.copy(Dt).multiplyScalar(Ot)),b=new function(){var t={};return{get:function(e){var i=e.uuid,r=t[i];return void 0===r&&(r={},t[i]=r),r},remove:function(e){delete t[e.uuid]},clear:function(){t={}}}},x=new Uo(m,g,y,b,v,O,Pe),_=new Mr(m),w=new function(t,e,i){var r={},n={};function o(t){var a=t.target,s=r[a.id];for(var c in null!==s.index&&e.remove(s.index),s.attributes)e.remove(s.attributes[c]);a.removeEventListener("dispose",o),delete r[a.id];var u=n[a.id];u&&(e.remove(u),delete n[a.id]),(u=n[s.id])&&(e.remove(u),delete n[s.id]),i.geometries--}return{get:function(t,e){var n=r[e.id];return n||(e.addEventListener("dispose",o),e.isBufferGeometry?n=e:e.isGeometry&&(void 0===e._bufferGeometry&&(e._bufferGeometry=(new Qn).setFromObject(t)),n=e._bufferGeometry),r[e.id]=n,i.geometries++,n)},update:function(i){var r=i.index,n=i.attributes;for(var o in null!==r&&e.update(r,t.ELEMENT_ARRAY_BUFFER),n)e.update(n[o],t.ARRAY_BUFFER);var a=i.morphAttributes;for(var o in a)for(var s=a[o],c=0,u=s.length;c<u;c++)e.update(s[c],t.ARRAY_BUFFER)},getWireframeAttribute:function(i){var r=n[i.id];if(r)return r;var o,a=[],s=i.index,c=i.attributes;if(null!==s)for(var u=0,h=(o=s.array).length;u<h;u+=3){var l=o[u+0],p=o[u+1],d=o[u+2];a.push(l,p,p,d,d,l)}else for(u=0,h=(o=c.position.array).length/3-1;u<h;u+=3)l=u+0,p=u+1,d=u+2,a.push(l,p,p,d,d,l);return r=new(yn(a)>65535?fn:pn)(a,1),e.update(r,t.ELEMENT_ARRAY_BUFFER),n[i.id]=r,r}}}(m,_,Pe),S=new function(t,e){var i={};return{update:function(r){var n=e.frame,o=r.geometry,a=t.get(r,o);return i[a.id]!==n&&(o.isGeometry&&a.updateFromObject(r),t.update(a),i[a.id]=n),a},clear:function(){i={}}}}(w,Te),E=new function(t){var e={},i=new Float32Array(8);return{update:function(r,n,o,a){var s=r.morphTargetInfluences,c=s.length,u=e[n.id];if(void 0===u){u=[];for(var h=0;h<c;h++)u[h]=[h,0];e[n.id]=u}var l=o.morphTargets&&n.morphAttributes.position,p=o.morphNormals&&n.morphAttributes.normal;for(h=0;h<c;h++)0!==(d=u[h])[1]&&(l&&n.removeAttribute("morphTarget"+h),p&&n.removeAttribute("morphNormal"+h));for(h=0;h<c;h++)(d=u[h])[0]=h,d[1]=s[h];for(u.sort(fo),h=0;h<8;h++){var d;if(d=u[h]){var f=d[0],m=d[1];if(m){l&&n.addAttribute("morphTarget"+h,l[f]),p&&n.addAttribute("morphNormal"+h,p[f]),i[h]=m;continue}}i[h]=0}a.getUniforms().setValue(t,"morphTargetInfluences",i)}}}(m),M=new zo(D,g,v),A=new mo,P=new po,T=new function(t,e,i,r){var n,o,a,s=new Gi(0),c=0;function u(t,i){e.buffers.color.setClear(t.r,t.g,t.b,i,r)}return{getClearColor:function(){return s},setClearColor:function(t,e){s.set(t),u(s,c=void 0!==e?e:1)},getClearAlpha:function(){return c},setClearAlpha:function(t){u(s,c=t)},render:function(e,r,h,l){var p=r.background;null===p?u(s,c):p&&p.isColor&&(u(p,1),l=!0),(t.autoClear||l)&&t.clear(t.autoClearColor,t.autoClearDepth,t.autoClearStencil),p&&p.isCubeTexture?(void 0===a&&((a=new uo(new eo(1,1,1),new oo({uniforms:qi.cube.uniforms,vertexShader:qi.cube.vertexShader,fragmentShader:qi.cube.fragmentShader,side:W,depthTest:!0,depthWrite:!1,fog:!1}))).geometry.removeAttribute("normal"),a.geometry.removeAttribute("uv"),a.onBeforeRender=function(t,e,i){this.matrixWorld.copyPosition(i.matrixWorld)},i.update(a.geometry)),a.material.uniforms.tCube.value=p,e.push(a,a.geometry,a.material,0,null)):p&&p.isTexture&&(void 0===n&&(n=new Zr(-1,1,1,-1,0,1),o=new uo(new ro(2,2),new no({depthTest:!1,depthWrite:!1,fog:!1})),i.update(o.geometry)),o.material.map=p,t.renderBufferDirect(n,null,o.geometry,o.material,o,null))}}}(D,y,w,s),C=new function(t,e,i){var r;this.setMode=function(t){r=t},this.render=function(e,n){t.drawArrays(r,e,n),i.calls++,i.vertices+=n,r===t.TRIANGLES?i.faces+=n/3:r===t.POINTS&&(i.points+=n)},this.renderInstances=function(n,o,a){var s=e.get("ANGLE_instanced_arrays");if(null!==s){var c=n.attributes.position;c.isInterleavedBufferAttribute?(a=c.data.count,s.drawArraysInstancedANGLE(r,0,a,n.maxInstancedCount)):s.drawArraysInstancedANGLE(r,o,a,n.maxInstancedCount),i.calls++,i.vertices+=a*n.maxInstancedCount,r===t.TRIANGLES?i.faces+=n.maxInstancedCount*a/3:r===t.POINTS&&(i.points+=n.maxInstancedCount*a)}else console.error("THREE.WebGLBufferRenderer: using THREE.InstancedBufferGeometry but hardware does not support extension ANGLE_instanced_arrays.")}}(m,g,Te),I=new function(t,e,i){var r,n,o;this.setMode=function(t){r=t},this.setIndex=function(t){n=t.type,o=t.bytesPerElement},this.render=function(e,a){t.drawElements(r,a,n,e*o),i.calls++,i.vertices+=a,r===t.TRIANGLES?i.faces+=a/3:r===t.POINTS&&(i.points+=a)},this.renderInstances=function(a,s,c){var u=e.get("ANGLE_instanced_arrays");null!==u?(u.drawElementsInstancedANGLE(r,c,n,s*o,a.maxInstancedCount),i.calls++,i.vertices+=c*a.maxInstancedCount,r===t.TRIANGLES?i.faces+=a.maxInstancedCount*c/3:r===t.POINTS&&(i.points+=a.maxInstancedCount*c)):console.error("THREE.WebGLIndexedBufferRenderer: using THREE.InstancedBufferGeometry but hardware does not support extension ANGLE_instanced_arrays.")}}(m,g,Te),R=new Zi(D,m,y,x,v),L=new Ji(D,m,y,x,v),D.info.programs=M.programs,D.context=m,D.capabilities=v,D.extensions=g,D.properties=b,D.renderLists=P,D.state=y}Oe();var De=new Vo(D);this.vr=De;var ke=new Ar(D,S,v.maxTextureSize);function Ne(t){t.preventDefault(),console.log("THREE.WebGLRenderer: Context Lost."),k=!0}function Be(){console.log("THREE.WebGLRenderer: Context Restored."),k=!1,Oe()}function Fe(t){var e,i=t.target;i.removeEventListener("dispose",Fe),ze(e=i),b.remove(e)}function ze(t){var e=b.get(t).program;t.program=void 0,void 0!==e&&M.releaseProgram(e)}this.shadowMap=ke,this.getContext=function(){return m},this.getContextAttributes=function(){return m.getContextAttributes()},this.forceContextLoss=function(){var t=g.get("WEBGL_lose_context");t&&t.loseContext()},this.forceContextRestore=function(){var t=g.get("WEBGL_lose_context");t&&t.restoreContext()},this.getPixelRatio=function(){return Ot},this.setPixelRatio=function(t){void 0!==t&&(Ot=t,this.setSize(It,Lt,!1))},this.getSize=function(){return{width:It,height:Lt}},this.setSize=function(t,i,r){var n=De.getDevice();n&&n.isPresenting?console.warn("THREE.WebGLRenderer: Can't change size while VR device is presenting."):(It=t,Lt=i,e.width=t*Ot,e.height=i*Ot,!1!==r&&(e.style.width=t+"px",e.style.height=i+"px"),this.setViewport(0,0,t,i))},this.getDrawingBufferSize=function(){return{width:It*Ot,height:Lt*Ot}},this.setDrawingBufferSize=function(t,i,r){It=t,Lt=i,Ot=r,e.width=t*r,e.height=i*r,this.setViewport(0,0,t,i)},this.setViewport=function(t,e,i,r){Dt.set(t,Lt-e-r,i,r),y.viewport(Z.copy(Dt).multiplyScalar(Ot))},this.setScissor=function(t,e,i,r){kt.set(t,Lt-e-r,i,r),y.scissor(Tt.copy(kt).multiplyScalar(Ot))},this.setScissorTest=function(t){y.setScissorTest(Nt=t)},this.getClearColor=function(){return T.getClearColor()},this.setClearColor=function(){T.setClearColor.apply(T,arguments)},this.getClearAlpha=function(){return T.getClearAlpha()},this.setClearAlpha=function(){T.setClearAlpha.apply(T,arguments)},this.clear=function(t,e,i){var r=0;(void 0===t||t)&&(r|=m.COLOR_BUFFER_BIT),(void 0===e||e)&&(r|=m.DEPTH_BUFFER_BIT),(void 0===i||i)&&(r|=m.STENCIL_BUFFER_BIT),m.clear(r)},this.clearColor=function(){this.clear(!0,!1,!1)},this.clearDepth=function(){this.clear(!1,!0,!1)},this.clearStencil=function(){this.clear(!1,!1,!0)},this.clearTarget=function(t,e,i,r){this.setRenderTarget(t),this.clear(e,i,r)},this.dispose=function(){e.removeEventListener("webglcontextlost",Ne,!1),e.removeEventListener("webglcontextrestored",Be,!1),P.dispose(),De.dispose()},this.renderBufferImmediate=function(t,e,i){y.initAttributes();var r=b.get(t);t.hasPositions&&!r.position&&(r.position=m.createBuffer()),t.hasNormals&&!r.normal&&(r.normal=m.createBuffer()),t.hasUvs&&!r.uv&&(r.uv=m.createBuffer()),t.hasColors&&!r.color&&(r.color=m.createBuffer());var n=e.getAttributes();if(t.hasPositions&&(m.bindBuffer(m.ARRAY_BUFFER,r.position),m.bufferData(m.ARRAY_BUFFER,t.positionArray,m.DYNAMIC_DRAW),y.enableAttribute(n.position),m.vertexAttribPointer(n.position,3,m.FLOAT,!1,0,0)),t.hasNormals){if(m.bindBuffer(m.ARRAY_BUFFER,r.normal),!i.isMeshPhongMaterial&&!i.isMeshStandardMaterial&&!i.isMeshNormalMaterial&&!0===i.flatShading)for(var o=0,a=3*t.count;o<a;o+=9){var s=t.normalArray,c=(s[o+0]+s[o+3]+s[o+6])/3,u=(s[o+1]+s[o+4]+s[o+7])/3,h=(s[o+2]+s[o+5]+s[o+8])/3;s[o+0]=c,s[o+1]=u,s[o+2]=h,s[o+3]=c,s[o+4]=u,s[o+5]=h,s[o+6]=c,s[o+7]=u,s[o+8]=h}m.bufferData(m.ARRAY_BUFFER,t.normalArray,m.DYNAMIC_DRAW),y.enableAttribute(n.normal),m.vertexAttribPointer(n.normal,3,m.FLOAT,!1,0,0)}t.hasUvs&&i.map&&(m.bindBuffer(m.ARRAY_BUFFER,r.uv),m.bufferData(m.ARRAY_BUFFER,t.uvArray,m.DYNAMIC_DRAW),y.enableAttribute(n.uv),m.vertexAttribPointer(n.uv,2,m.FLOAT,!1,0,0)),t.hasColors&&i.vertexColors!==q&&(m.bindBuffer(m.ARRAY_BUFFER,r.color),m.bufferData(m.ARRAY_BUFFER,t.colorArray,m.DYNAMIC_DRAW),y.enableAttribute(n.color),m.vertexAttribPointer(n.color,3,m.FLOAT,!1,0,0)),y.disableUnusedAttributes(),m.drawArrays(m.TRIANGLES,0,t.count),t.count=0},this.renderBufferDirect=function(t,e,i,r,n,o){var a=n.isMesh&&n.matrixWorld.determinant()<0;y.setMaterial(r,a);var s=ei(t,e,r,n),c=i.id+"_"+s.id+"_"+(!0===r.wireframe),u=!1;c!==H&&(H=c,u=!0),n.morphTargetInfluences&&(E.update(n,i,r,s),u=!0);var h,l=i.index,p=i.attributes.position,d=1;!0===r.wireframe&&(l=w.getWireframeAttribute(i),d=2);var f=C;null!==l&&(h=_.get(l),(f=I).setIndex(h)),u&&(!function(t,e,i,r){if(i&&i.isInstancedBufferGeometry&&null===g.get("ANGLE_instanced_arrays"))return void console.error("THREE.WebGLRenderer.setupVertexAttributes: using THREE.InstancedBufferGeometry but hardware does not support extension ANGLE_instanced_arrays.");void 0===r&&(r=0);y.initAttributes();var n=i.attributes,o=e.getAttributes(),a=t.defaultAttributeValues;for(var s in o){var c=o[s];if(c>=0){var u=n[s];if(void 0!==u){var h=u.normalized,l=u.itemSize,p=_.get(u);if(void 0===p)continue;var d=p.buffer,f=p.type,v=p.bytesPerElement;if(u.isInterleavedBufferAttribute){var b=u.data,x=b.stride,w=u.offset;b&&b.isInstancedInterleavedBuffer?(y.enableAttributeAndDivisor(c,b.meshPerAttribute),void 0===i.maxInstancedCount&&(i.maxInstancedCount=b.meshPerAttribute*b.count)):y.enableAttribute(c),m.bindBuffer(m.ARRAY_BUFFER,d),m.vertexAttribPointer(c,l,f,h,x*v,(r*x+w)*v)}else u.isInstancedBufferAttribute?(y.enableAttributeAndDivisor(c,u.meshPerAttribute),void 0===i.maxInstancedCount&&(i.maxInstancedCount=u.meshPerAttribute*u.count)):y.enableAttribute(c),m.bindBuffer(m.ARRAY_BUFFER,d),m.vertexAttribPointer(c,l,f,h,0,r*l*v)}else if(void 0!==a){var S=a[s];if(void 0!==S)switch(S.length){case 2:m.vertexAttrib2fv(c,S);break;case 3:m.vertexAttrib3fv(c,S);break;case 4:m.vertexAttrib4fv(c,S);break;default:m.vertexAttrib1fv(c,S)}}}}y.disableUnusedAttributes()}(r,s,i),null!==l&&m.bindBuffer(m.ELEMENT_ARRAY_BUFFER,h.buffer));var v=0;null!==l?v=l.count:void 0!==p&&(v=p.count);var b=i.drawRange.start*d,x=i.drawRange.count*d,S=null!==o?o.start*d:0,A=null!==o?o.count*d:1/0,M=Math.max(b,S),P=Math.min(v,b+x,S+A)-1,T=Math.max(0,P-M+1);if(0!==T){if(n.isMesh)if(!0===r.wireframe)y.setLineWidth(r.wireframeLinewidth*Ee()),f.setMode(m.LINES);else switch(n.drawMode){case Ce:f.setMode(m.TRIANGLES);break;case Ie:f.setMode(m.TRIANGLE_STRIP);break;case Re:f.setMode(m.TRIANGLE_FAN)}else if(n.isLine){var R=r.linewidth;void 0===R&&(R=1),y.setLineWidth(R*Ee()),n.isLineSegments?f.setMode(m.LINES):n.isLineLoop?f.setMode(m.LINE_LOOP):f.setMode(m.LINE_STRIP)}else n.isPoints&&f.setMode(m.POINTS);i&&i.isInstancedBufferGeometry?i.maxInstancedCount>0&&f.renderInstances(i,M,T):f.render(M,T)}},this.compile=function(t,e){h.length=0,l.length=0,t.traverse(function(t){t.isLight&&(h.push(t),t.castShadow&&l.push(t))}),A.setup(h,l,e),t.traverse(function(e){if(e.material)if(Array.isArray(e.material))for(var i=0;i<e.material.length;i++)Qe(e.material[i],t.fog,e);else Qe(e.material,t.fog,e)})};var Ue,Ge,He,Xe=!1,qe=null;function Ye(t){null!==qe&&qe(t);var e=De.getDevice();e&&e.isPresenting?e.requestAnimationFrame(Ye):window.requestAnimationFrame(Ye)}function Ze(t,e,i,r){for(var n=0,o=t.length;n<o;n++){var a=t[n],s=a.object,c=a.geometry,u=void 0===r?a.material:r,h=a.group;if(i.isArrayCamera){Y=i;for(var l=i.cameras,p=0,d=l.length;p<d;p++){var f=l[p];if(s.layers.test(f.layers)){var m=f.bounds,g=m.x*It,v=m.y*Lt,b=m.z*It,x=m.w*Lt;y.viewport(Z.set(g,v,b,x).multiplyScalar(Ot)),Je(s,e,f,c,u,h)}}}else Y=null,Je(s,e,i,c,u,h)}}function Je(t,e,i,r,n,o){if(t.onBeforeRender(D,e,i,r,n,o),t.modelViewMatrix.multiplyMatrices(i.matrixWorldInverse,t.matrixWorld),t.normalMatrix.getNormalMatrix(t.modelViewMatrix),t.isImmediateRenderObject){var a=t.isMesh&&t.matrixWorld.determinant()<0;y.setMaterial(n,a);var s=ei(i,e.fog,n,t);H="",c=s,u=n,t.render(function(t){D.renderBufferImmediate(t,c,u)})}else D.renderBufferDirect(i,e.fog,r,n,t,o);var c,u;t.onAfterRender(D,e,i,r,n,o)}function Qe(t,e,i){var r=b.get(t),n=M.getParameters(t,A.state,l,e,Ft.numPlanes,Ft.numIntersection,i),o=M.getProgramCode(t,n),a=r.program,s=!0;if(void 0===a)t.addEventListener("dispose",Fe);else if(a.code!==o)ze(t);else{if(void 0!==n.shaderID)return;s=!1}if(s){if(n.shaderID){var c=qi[n.shaderID];r.shader={name:t.type,uniforms:Wi.clone(c.uniforms),vertexShader:c.vertexShader,fragmentShader:c.fragmentShader}}else r.shader={name:t.type,uniforms:t.uniforms,vertexShader:t.vertexShader,fragmentShader:t.fragmentShader};t.onBeforeCompile(r.shader),a=M.acquireProgram(t,r.shader,n,o),r.program=a,t.program=a}var u=a.getAttributes();if(t.morphTargets){t.numSupportedMorphTargets=0;for(var h=0;h<D.maxMorphTargets;h++)u["morphTarget"+h]>=0&&t.numSupportedMorphTargets++}if(t.morphNormals){t.numSupportedMorphNormals=0;for(h=0;h<D.maxMorphNormals;h++)u["morphNormal"+h]>=0&&t.numSupportedMorphNormals++}var p=r.shader.uniforms;(t.isShaderMaterial||t.isRawShaderMaterial)&&!0!==t.clipping||(r.numClippingPlanes=Ft.numPlanes,r.numIntersection=Ft.numIntersection,p.clippingPlanes=Ft.uniform),r.fog=e,r.lightsHash=A.state.hash,t.lights&&(p.ambientLightColor.value=A.state.ambient,p.directionalLights.value=A.state.directional,p.spotLights.value=A.state.spot,p.rectAreaLights.value=A.state.rectArea,p.pointLights.value=A.state.point,p.hemisphereLights.value=A.state.hemi,p.directionalShadowMap.value=A.state.directionalShadowMap,p.directionalShadowMatrix.value=A.state.directionalShadowMatrix,p.spotShadowMap.value=A.state.spotShadowMap,p.spotShadowMatrix.value=A.state.spotShadowMatrix,p.pointShadowMap.value=A.state.pointShadowMap,p.pointShadowMatrix.value=A.state.pointShadowMatrix);var d=r.program.getUniforms(),f=Ui.seqWithValue(d.seq,p);r.uniformsList=f}function ei(t,e,i,r){Ct=0;var n=b.get(i);if(zt&&(Ut||t!==$)){var o=t===$&&i.id===V;Ft.setState(i.clippingPlanes,i.clipIntersection,i.clipShadows,t,n,o)}!1===i.needsUpdate&&(void 0===n.program?i.needsUpdate=!0:i.fog&&n.fog!==e?i.needsUpdate=!0:i.lights&&n.lightsHash!==A.state.hash?i.needsUpdate=!0:void 0===n.numClippingPlanes||n.numClippingPlanes===Ft.numPlanes&&n.numIntersection===Ft.numIntersection||(i.needsUpdate=!0)),i.needsUpdate&&(Qe(i,e,r),i.needsUpdate=!1);var a,s,c,u,h,l,p,d,f,g,x,_,w,S,M,P,T=!1,E=!1,C=!1,I=n.program,R=I.getUniforms(),L=n.shader.uniforms;if(y.useProgram(I.program)&&(T=!0,E=!0,C=!0),i.id!==V&&(V=i.id,E=!0),T||t!==$){if(R.setValue(m,"projectionMatrix",t.projectionMatrix),v.logarithmicDepthBuffer&&R.setValue(m,"logDepthBufFC",2/(Math.log(t.far+1)/Math.LN2)),$!==(Y||t)&&($=Y||t,E=!0,C=!0),i.isShaderMaterial||i.isMeshPhongMaterial||i.isMeshStandardMaterial||i.envMap){var O=R.map.cameraPosition;void 0!==O&&O.setValue(m,me.setFromMatrixPosition(t.matrixWorld))}(i.isMeshPhongMaterial||i.isMeshLambertMaterial||i.isMeshBasicMaterial||i.isMeshStandardMaterial||i.isShaderMaterial||i.skinning)&&R.setValue(m,"viewMatrix",t.matrixWorldInverse)}if(i.skinning){R.setOptional(m,r,"bindMatrix"),R.setOptional(m,r,"bindMatrixInverse");var k=r.skeleton;if(k){var N=k.bones;if(v.floatVertexTextures){if(void 0===k.boneTexture){var B=Math.sqrt(4*N.length);B=je.ceilPowerOfTwo(B),B=Math.max(B,4);var F=new Float32Array(B*B*4);F.set(k.boneMatrices);var z=new ti(F,B,B,le,re);k.boneMatrices=F,k.boneTexture=z,k.boneTextureSize=B}R.setValue(m,"boneTexture",k.boneTexture),R.setValue(m,"boneTextureSize",k.boneTextureSize)}else R.setOptional(m,k,"boneMatrices")}}return E&&(R.setValue(m,"toneMappingExposure",D.toneMappingExposure),R.setValue(m,"toneMappingWhitePoint",D.toneMappingWhitePoint),i.lights&&(P=C,(M=L).ambientLightColor.needsUpdate=P,M.directionalLights.needsUpdate=P,M.pointLights.needsUpdate=P,M.spotLights.needsUpdate=P,M.rectAreaLights.needsUpdate=P,M.hemisphereLights.needsUpdate=P),e&&i.fog&&(S=e,(w=L).fogColor.value=S.color,S.isFog?(w.fogNear.value=S.near,w.fogFar.value=S.far):S.isFogExp2&&(w.fogDensity.value=S.density)),i.isMeshBasicMaterial?ii(L,i):i.isMeshLambertMaterial?(ii(L,i),x=L,(_=i).emissiveMap&&(x.emissiveMap.value=_.emissiveMap)):i.isMeshPhongMaterial?(ii(L,i),i.isMeshToonMaterial?(ri(f=L,g=i),g.gradientMap&&(f.gradientMap.value=g.gradientMap)):ri(L,i)):i.isMeshStandardMaterial?(ii(L,i),i.isMeshPhysicalMaterial?(d=i,(p=L).clearCoat.value=d.clearCoat,p.clearCoatRoughness.value=d.clearCoatRoughness,ni(p,d)):ni(L,i)):i.isMeshDepthMaterial?(ii(L,i),h=L,(l=i).displacementMap&&(h.displacementMap.value=l.displacementMap,h.displacementScale.value=l.displacementScale,h.displacementBias.value=l.displacementBias)):i.isMeshDistanceMaterial?(ii(L,i),function(t,e){e.displacementMap&&(t.displacementMap.value=e.displacementMap,t.displacementScale.value=e.displacementScale,t.displacementBias.value=e.displacementBias);t.referencePosition.value.copy(e.referencePosition),t.nearDistance.value=e.nearDistance,t.farDistance.value=e.farDistance}(L,i)):i.isMeshNormalMaterial?(ii(L,i),function(t,e){e.bumpMap&&(t.bumpMap.value=e.bumpMap,t.bumpScale.value=e.bumpScale);e.normalMap&&(t.normalMap.value=e.normalMap,t.normalScale.value.copy(e.normalScale));e.displacementMap&&(t.displacementMap.value=e.displacementMap,t.displacementScale.value=e.displacementScale,t.displacementBias.value=e.displacementBias)}(L,i)):i.isLineBasicMaterial?(u=i,(c=L).diffuse.value=u.color,c.opacity.value=u.opacity,i.isLineDashedMaterial&&(s=i,(a=L).dashSize.value=s.dashSize,a.totalSize.value=s.dashSize+s.gapSize,a.scale.value=s.scale)):i.isPointsMaterial?function(t,e){if(t.diffuse.value=e.color,t.opacity.value=e.opacity,t.size.value=e.size*Ot,t.scale.value=.5*Lt,t.map.value=e.map,null!==e.map){if(!0===e.map.matrixAutoUpdate){var i=e.map.offset,r=e.map.repeat,n=e.map.rotation,o=e.map.center;e.map.matrix.setUvTransform(i.x,i.y,r.x,r.y,n,o.x,o.y)}t.uvTransform.value.copy(e.map.matrix)}}(L,i):i.isShadowMaterial&&(L.color.value=i.color,L.opacity.value=i.opacity),void 0!==L.ltcMat&&(L.ltcMat.value=$i.LTC_MAT_TEXTURE),void 0!==L.ltcMag&&(L.ltcMag.value=$i.LTC_MAG_TEXTURE),Ui.upload(m,n.uniformsList,L,D)),R.setValue(m,"modelViewMatrix",r.modelViewMatrix),R.setValue(m,"normalMatrix",r.normalMatrix),R.setValue(m,"modelMatrix",r.matrixWorld),I}function ii(t,e){var i;if(t.opacity.value=e.opacity,e.color&&(t.diffuse.value=e.color),e.emissive&&t.emissive.value.copy(e.emissive).multiplyScalar(e.emissiveIntensity),e.map&&(t.map.value=e.map),e.alphaMap&&(t.alphaMap.value=e.alphaMap),e.specularMap&&(t.specularMap.value=e.specularMap),e.envMap&&(t.envMap.value=e.envMap,t.flipEnvMap.value=e.envMap&&e.envMap.isCubeTexture?-1:1,t.reflectivity.value=e.reflectivity,t.refractionRatio.value=e.refractionRatio),e.lightMap&&(t.lightMap.value=e.lightMap,t.lightMapIntensity.value=e.lightMapIntensity),e.aoMap&&(t.aoMap.value=e.aoMap,t.aoMapIntensity.value=e.aoMapIntensity),e.map?i=e.map:e.specularMap?i=e.specularMap:e.displacementMap?i=e.displacementMap:e.normalMap?i=e.normalMap:e.bumpMap?i=e.bumpMap:e.roughnessMap?i=e.roughnessMap:e.metalnessMap?i=e.metalnessMap:e.alphaMap?i=e.alphaMap:e.emissiveMap&&(i=e.emissiveMap),void 0!==i){if(i.isWebGLRenderTarget&&(i=i.texture),!0===i.matrixAutoUpdate){var r=i.offset,n=i.repeat,o=i.rotation,a=i.center;i.matrix.setUvTransform(r.x,r.y,n.x,n.y,o,a.x,a.y)}t.uvTransform.value.copy(i.matrix)}}function ri(t,e){t.specular.value=e.specular,t.shininess.value=Math.max(e.shininess,1e-4),e.emissiveMap&&(t.emissiveMap.value=e.emissiveMap),e.bumpMap&&(t.bumpMap.value=e.bumpMap,t.bumpScale.value=e.bumpScale),e.normalMap&&(t.normalMap.value=e.normalMap,t.normalScale.value.copy(e.normalScale)),e.displacementMap&&(t.displacementMap.value=e.displacementMap,t.displacementScale.value=e.displacementScale,t.displacementBias.value=e.displacementBias)}function ni(t,e){t.roughness.value=e.roughness,t.metalness.value=e.metalness,e.roughnessMap&&(t.roughnessMap.value=e.roughnessMap),e.metalnessMap&&(t.metalnessMap.value=e.metalnessMap),e.emissiveMap&&(t.emissiveMap.value=e.emissiveMap),e.bumpMap&&(t.bumpMap.value=e.bumpMap,t.bumpScale.value=e.bumpScale),e.normalMap&&(t.normalMap.value=e.normalMap,t.normalScale.value.copy(e.normalScale)),e.displacementMap&&(t.displacementMap.value=e.displacementMap,t.displacementScale.value=e.displacementScale,t.displacementBias.value=e.displacementBias),e.envMap&&(t.envMapIntensity.value=e.envMapIntensity)}this.animate=function(t){qe=t,function(){if(!Xe){var t=De.getDevice();t&&t.isPresenting?t.requestAnimationFrame(Ye):window.requestAnimationFrame(Ye),Xe=!0}}()},this.render=function(t,e,i,r){if(e&&e.isCamera){if(!k){H="",V=-1,$=null,!0===t.autoUpdate&&t.updateMatrixWorld(),null===e.parent&&e.updateMatrixWorld(),De.enabled&&(e=De.getCamera(e)),jt.multiplyMatrices(e.projectionMatrix,e.matrixWorldInverse),Bt.setFromMatrix(jt),h.length=0,l.length=0,d.length=0,f.length=0,Ut=this.localClippingEnabled,zt=Ft.init(this.clippingPlanes,Ut,e),(p=P.get(t,e)).init(),function t(e,i,r){if(!1===e.visible)return;var n=e.layers.test(i.layers);if(n)if(e.isLight)h.push(e),e.castShadow&&l.push(e);else if(e.isSprite)e.frustumCulled&&!Bt.intersectsSprite(e)||d.push(e);else if(e.isLensFlare)f.push(e);else if(e.isImmediateRenderObject)r&&me.setFromMatrixPosition(e.matrixWorld).applyMatrix4(jt),p.push(e,null,e.material,me.z,null);else if((e.isMesh||e.isLine||e.isPoints)&&(e.isSkinnedMesh&&e.skeleton.update(),!e.frustumCulled||Bt.intersectsObject(e))){r&&me.setFromMatrixPosition(e.matrixWorld).applyMatrix4(jt);var o=S.update(e),a=e.material;if(Array.isArray(a))for(var s=o.groups,c=0,u=s.length;c<u;c++){var m=s[c],g=a[m.materialIndex];g&&g.visible&&p.push(e,o,g,me.z,m)}else a.visible&&p.push(e,o,a,me.z,null)}var v=e.children;for(var c=0,u=v.length;c<u;c++)t(v[c],i,r)}(t,e,D.sortObjects),!0===D.sortObjects&&p.sort(),x.updateVideoTextures(),zt&&Ft.beginShadows(),ke.render(l,t,e),A.setup(h,l,e),zt&&Ft.endShadows(),Te.frame++,Te.calls=0,Te.vertices=0,Te.faces=0,Te.points=0,void 0===i&&(i=null),this.setRenderTarget(i),T.render(p,t,e,r);var n=p.opaque,o=p.transparent;if(t.overrideMaterial){var a=t.overrideMaterial;n.length&&Ze(n,t,e,a),o.length&&Ze(o,t,e,a)}else n.length&&Ze(n,t,e),o.length&&Ze(o,t,e);L.render(d,t,e),R.render(f,t,e,Z),i&&x.updateRenderTargetMipmap(i),y.buffers.depth.setTest(!0),y.buffers.depth.setMask(!0),y.buffers.color.setMask(!0),y.setPolygonOffset(!1),De.enabled&&De.submitFrame()}}else console.error("THREE.WebGLRenderer.render: camera is not an instance of THREE.Camera.")},this.setFaceCulling=function(t,e){y.setCullFace(t),y.setFlipSided(e===G)},this.allocTextureUnit=function(){var t=Ct;return t>=v.maxTextures&&console.warn("THREE.WebGLRenderer: Trying to use "+t+" texture units while this GPU supports only "+v.maxTextures),Ct+=1,t},this.setTexture2D=(Ue=!1,function(t,e){t&&t.isWebGLRenderTarget&&(Ue||(console.warn("THREE.WebGLRenderer.setTexture2D: don't use render targets as textures. Use their .texture property instead."),Ue=!0),t=t.texture),x.setTexture2D(t,e)}),this.setTexture=(Ge=!1,function(t,e){Ge||(console.warn("THREE.WebGLRenderer: .setTexture is deprecated, use setTexture2D instead."),Ge=!0),x.setTexture2D(t,e)}),this.setTextureCube=(He=!1,function(t,e){t&&t.isWebGLRenderTargetCube&&(He||(console.warn("THREE.WebGLRenderer.setTextureCube: don't use cube render targets as textures. Use their .texture property instead."),He=!0),t=t.texture),t&&t.isCubeTexture||Array.isArray(t.image)&&6===t.image.length?x.setTextureCube(t,e):x.setTextureCubeDynamic(t,e)}),this.getRenderTarget=function(){return N},this.setRenderTarget=function(t){N=t,t&&void 0===b.get(t).__webglFramebuffer&&x.setupRenderTarget(t);var e=null,i=!1;if(t){var r=b.get(t).__webglFramebuffer;t.isWebGLRenderTargetCube?(e=r[t.activeCubeFace],i=!0):e=r,Z.copy(t.viewport),Tt.copy(t.scissor),Et=t.scissorTest}else Z.copy(Dt).multiplyScalar(Ot),Tt.copy(kt).multiplyScalar(Ot),Et=Nt;if(B!==e&&(m.bindFramebuffer(m.FRAMEBUFFER,e),B=e),y.viewport(Z),y.scissor(Tt),y.setScissorTest(Et),i){var n=b.get(t.texture);m.framebufferTexture2D(m.FRAMEBUFFER,m.COLOR_ATTACHMENT0,m.TEXTURE_CUBE_MAP_POSITIVE_X+t.activeCubeFace,n.__webglTexture,t.activeMipMapLevel)}},this.readRenderTargetPixels=function(t,e,i,r,n,o){if(t&&t.isWebGLRenderTarget){var a=b.get(t).__webglFramebuffer;if(a){var s=!1;a!==B&&(m.bindFramebuffer(m.FRAMEBUFFER,a),s=!0);try{var c=t.texture,u=c.format,h=c.type;if(u!==le&&O.convert(u)!==m.getParameter(m.IMPLEMENTATION_COLOR_READ_FORMAT))return void console.error("THREE.WebGLRenderer.readRenderTargetPixels: renderTarget is not in RGBA or implementation defined format.");if(!(h===Kt||O.convert(h)===m.getParameter(m.IMPLEMENTATION_COLOR_READ_TYPE)||h===re&&(g.get("OES_texture_float")||g.get("WEBGL_color_buffer_float"))||h===ne&&g.get("EXT_color_buffer_half_float")))return void console.error("THREE.WebGLRenderer.readRenderTargetPixels: renderTarget is not in UnsignedByteType or implementation defined type.");m.checkFramebufferStatus(m.FRAMEBUFFER)===m.FRAMEBUFFER_COMPLETE?e>=0&&e<=t.width-r&&i>=0&&i<=t.height-n&&m.readPixels(e,i,r,n,O.convert(u),O.convert(h),o):console.error("THREE.WebGLRenderer.readRenderTargetPixels: readPixels from renderTarget failed. Framebuffer not complete.")}finally{s&&m.bindFramebuffer(m.FRAMEBUFFER,B)}}}else console.error("THREE.WebGLRenderer.readRenderTargetPixels: renderTarget is not THREE.WebGLRenderTarget.")}}function $o(t,e){this.name="",this.color=new Gi(t),this.density=void 0!==e?e:25e-5}function Wo(t,e,i){this.name="",this.color=new Gi(t),this.near=void 0!==e?e:1,this.far=void 0!==i?i:1e3}function Xo(){qr.call(this),this.type="Scene",this.background=null,this.fog=null,this.overrideMaterial=null,this.autoUpdate=!0}function qo(t,e,i,r,n){qr.call(this),this.lensFlares=[],this.positionScreen=new $e,this.customUpdateCallback=void 0,void 0!==t&&this.add(t,e,i,r,n)}function Yo(t){vr.call(this),this.type="SpriteMaterial",this.color=new Gi(16777215),this.map=null,this.rotation=0,this.fog=!1,this.lights=!1,this.setValues(t)}function Zo(t){qr.call(this),this.type="Sprite",this.material=void 0!==t?t:new Yo}function Ko(){qr.call(this),this.type="LOD",Object.defineProperties(this,{levels:{enumerable:!0,value:[]}})}function Jo(t,e){if(t=t||[],this.bones=t.slice(0),this.boneMatrices=new Float32Array(16*this.bones.length),void 0===e)this.calculateInverses();else if(this.bones.length===e.length)this.boneInverses=e.slice(0);else{console.warn("THREE.Skeleton boneInverses is the wrong length."),this.boneInverses=[];for(var i=0,r=this.bones.length;i<r;i++)this.boneInverses.push(new Ve)}}function Qo(){qr.call(this),this.type="Bone"}function ta(t,e){uo.call(this,t,e),this.type="SkinnedMesh",this.bindMode="attached",this.bindMatrix=new Ve,this.bindMatrixInverse=new Ve;var i=new Jo(this.initBones());this.bind(i,this.matrixWorld),this.normalizeSkinWeights()}function ea(t){vr.call(this),this.type="LineBasicMaterial",this.color=new Gi(16777215),this.linewidth=1,this.linecap="round",this.linejoin="round",this.lights=!1,this.setValues(t)}function ia(t,e,i){if(1===i)return console.warn("THREE.Line: parameter THREE.LinePieces no longer supported. Created THREE.LineSegments instead."),new ra(t,e);qr.call(this),this.type="Line",this.geometry=void 0!==t?t:new Qn,this.material=void 0!==e?e:new ea({color:16777215*Math.random()})}function ra(t,e){ia.call(this,t,e),this.type="LineSegments"}function na(t,e){ia.call(this,t,e),this.type="LineLoop"}function oa(t){vr.call(this),this.type="PointsMaterial",this.color=new Gi(16777215),this.map=null,this.size=1,this.sizeAttenuation=!0,this.lights=!1,this.setValues(t)}function aa(t,e){qr.call(this),this.type="Points",this.geometry=void 0!==t?t:new Qn,this.material=void 0!==e?e:new oa({color:16777215*Math.random()})}function sa(){qr.call(this),this.type="Group"}function ca(t,e,i,r,n,o,a,s,c){Ze.call(this,t,e,i,r,n,o,a,s,c),this.generateMipmaps=!1;var u=this;t.addEventListener("loadeddata",function e(){t.removeEventListener("loadeddata",e,!1),u.needsUpdate=!0},!1)}function ua(t,e,i,r,n,o,a,s,c,u,h,l){Ze.call(this,null,o,a,s,c,u,r,n,h,l),this.image={width:e,height:i},this.mipmaps=t,this.flipY=!1,this.generateMipmaps=!1}function ha(t,e,i,r,n,o,a,s,c,u){if((u=void 0!==u?u:fe)!==fe&&u!==ge)throw new Error("DepthTexture format must be either THREE.DepthFormat or THREE.DepthStencilFormat");void 0===i&&u===fe&&(i=te),void 0===i&&u===ge&&(i=ce),Ze.call(this,null,r,n,o,a,s,u,i,c),this.image={width:t,height:e},this.magFilter=void 0!==a?a:$t,this.minFilter=void 0!==s?s:$t,this.flipY=!1,this.generateMipmaps=!1}function la(t){Qn.call(this),this.type="WireframeGeometry";var e,i,r,n,o,a,s,c,u,h,l=[],p=[0,0],d={},f=["a","b","c"];if(t&&t.isGeometry){var m=t.faces;for(e=0,r=m.length;e<r;e++){var g=m[e];for(i=0;i<3;i++)s=g[f[i]],c=g[f[(i+1)%3]],p[0]=Math.min(s,c),p[1]=Math.max(s,c),void 0===d[u=p[0]+","+p[1]]&&(d[u]={index1:p[0],index2:p[1]})}for(u in d)a=d[u],h=t.vertices[a.index1],l.push(h.x,h.y,h.z),h=t.vertices[a.index2],l.push(h.x,h.y,h.z)}else if(t&&t.isBufferGeometry){var v,y,b,x,_,w,S;if(h=new $e,null!==t.index){for(v=t.attributes.position,y=t.index,0===(b=t.groups).length&&(b=[{start:0,count:y.count,materialIndex:0}]),n=0,o=b.length;n<o;++n)for(e=_=(x=b[n]).start,r=_+x.count;e<r;e+=3)for(i=0;i<3;i++)s=y.getX(e+i),c=y.getX(e+(i+1)%3),p[0]=Math.min(s,c),p[1]=Math.max(s,c),void 0===d[u=p[0]+","+p[1]]&&(d[u]={index1:p[0],index2:p[1]});for(u in d)a=d[u],h.fromBufferAttribute(v,a.index1),l.push(h.x,h.y,h.z),h.fromBufferAttribute(v,a.index2),l.push(h.x,h.y,h.z)}else for(e=0,r=(v=t.attributes.position).count/3;e<r;e++)for(i=0;i<3;i++)w=3*e+i,h.fromBufferAttribute(v,w),l.push(h.x,h.y,h.z),S=3*e+(i+1)%3,h.fromBufferAttribute(v,S),l.push(h.x,h.y,h.z)}this.addAttribute("position",new mn(l,3))}function pa(t,e,i){an.call(this),this.type="ParametricGeometry",this.parameters={func:t,slices:e,stacks:i},this.fromBufferGeometry(new da(t,e,i)),this.mergeVertices()}function da(t,e,i){Qn.call(this),this.type="ParametricBufferGeometry",this.parameters={func:t,slices:e,stacks:i};var r,n,o=[],a=[],s=[],c=[],u=new $e,h=new $e,l=new $e,p=new $e,d=new $e,f=e+1;for(r=0;r<=i;r++){var m=r/i;for(n=0;n<=e;n++){var g=n/e;h=t(g,m,h),a.push(h.x,h.y,h.z),g-1e-5>=0?(l=t(g-1e-5,m,l),p.subVectors(h,l)):(l=t(g+1e-5,m,l),p.subVectors(l,h)),m-1e-5>=0?(l=t(g,m-1e-5,l),d.subVectors(h,l)):(l=t(g,m+1e-5,l),d.subVectors(l,h)),u.crossVectors(p,d).normalize(),s.push(u.x,u.y,u.z),c.push(g,m)}}for(r=0;r<i;r++)for(n=0;n<e;n++){var v=r*f+n,y=r*f+n+1,b=(r+1)*f+n+1,x=(r+1)*f+n;o.push(v,y,x),o.push(y,b,x)}this.setIndex(o),this.addAttribute("position",new mn(a,3)),this.addAttribute("normal",new mn(s,3)),this.addAttribute("uv",new mn(c,2))}function fa(t,e,i,r){an.call(this),this.type="PolyhedronGeometry",this.parameters={vertices:t,indices:e,radius:i,detail:r},this.fromBufferGeometry(new ma(t,e,i,r)),this.mergeVertices()}function ma(t,e,i,r){Qn.call(this),this.type="PolyhedronBufferGeometry",this.parameters={vertices:t,indices:e,radius:i,detail:r},i=i||1;var n=[],o=[];function a(t,e,i,r){var n,o,a=Math.pow(2,r),c=[];for(n=0;n<=a;n++){c[n]=[];var u=t.clone().lerp(i,n/a),h=e.clone().lerp(i,n/a),l=a-n;for(o=0;o<=l;o++)c[n][o]=0===o&&n===a?u:u.clone().lerp(h,o/l)}for(n=0;n<a;n++)for(o=0;o<2*(a-n)-1;o++){var p=Math.floor(o/2);o%2==0?(s(c[n][p+1]),s(c[n+1][p]),s(c[n][p])):(s(c[n][p+1]),s(c[n+1][p+1]),s(c[n+1][p]))}}function s(t){n.push(t.x,t.y,t.z)}function c(e,i){var r=3*e;i.x=t[r+0],i.y=t[r+1],i.z=t[r+2]}function u(t,e,i,r){r<0&&1===t.x&&(o[e]=t.x-1),0===i.x&&0===i.z&&(o[e]=r/2/Math.PI+.5)}function h(t){return Math.atan2(t.z,-t.x)}!function(t){for(var i=new $e,r=new $e,n=new $e,o=0;o<e.length;o+=3)c(e[o+0],i),c(e[o+1],r),c(e[o+2],n),a(i,r,n,t)}(r=r||0),function(t){for(var e=new $e,i=0;i<n.length;i+=3)e.x=n[i+0],e.y=n[i+1],e.z=n[i+2],e.normalize().multiplyScalar(t),n[i+0]=e.x,n[i+1]=e.y,n[i+2]=e.z}(i),function(){for(var t=new $e,e=0;e<n.length;e+=3){t.x=n[e+0],t.y=n[e+1],t.z=n[e+2];var i=h(t)/2/Math.PI+.5,r=(a=t,Math.atan2(-a.y,Math.sqrt(a.x*a.x+a.z*a.z))/Math.PI+.5);o.push(i,1-r)}var a;(function(){for(var t=new $e,e=new $e,i=new $e,r=new $e,a=new Ge,s=new Ge,c=new Ge,l=0,p=0;l<n.length;l+=9,p+=6){t.set(n[l+0],n[l+1],n[l+2]),e.set(n[l+3],n[l+4],n[l+5]),i.set(n[l+6],n[l+7],n[l+8]),a.set(o[p+0],o[p+1]),s.set(o[p+2],o[p+3]),c.set(o[p+4],o[p+5]),r.copy(t).add(e).add(i).divideScalar(3);var d=h(r);u(a,p+0,t,d),u(s,p+2,e,d),u(c,p+4,i,d)}})(),function(){for(var t=0;t<o.length;t+=6){var e=o[t+0],i=o[t+2],r=o[t+4],n=Math.max(e,i,r),a=Math.min(e,i,r);n>.9&&a<.1&&(e<.2&&(o[t+0]+=1),i<.2&&(o[t+2]+=1),r<.2&&(o[t+4]+=1))}}()}(),this.addAttribute("position",new mn(n,3)),this.addAttribute("normal",new mn(n.slice(),3)),this.addAttribute("uv",new mn(o,2)),0===r?this.computeVertexNormals():this.normalizeNormals()}function ga(t,e){an.call(this),this.type="TetrahedronGeometry",this.parameters={radius:t,detail:e},this.fromBufferGeometry(new va(t,e)),this.mergeVertices()}function va(t,e){ma.call(this,[1,1,1,-1,-1,1,-1,1,-1,1,-1,-1],[2,1,0,0,3,2,1,3,0,2,3,1],t,e),this.type="TetrahedronBufferGeometry",this.parameters={radius:t,detail:e}}function ya(t,e){an.call(this),this.type="OctahedronGeometry",this.parameters={radius:t,detail:e},this.fromBufferGeometry(new ba(t,e)),this.mergeVertices()}function ba(t,e){ma.call(this,[1,0,0,-1,0,0,0,1,0,0,-1,0,0,0,1,0,0,-1],[0,2,4,0,4,3,0,3,5,0,5,2,1,2,5,1,5,3,1,3,4,1,4,2],t,e),this.type="OctahedronBufferGeometry",this.parameters={radius:t,detail:e}}function xa(t,e){an.call(this),this.type="IcosahedronGeometry",this.parameters={radius:t,detail:e},this.fromBufferGeometry(new _a(t,e)),this.mergeVertices()}function _a(t,e){var i=(1+Math.sqrt(5))/2,r=[-1,i,0,1,i,0,-1,-i,0,1,-i,0,0,-1,i,0,1,i,0,-1,-i,0,1,-i,i,0,-1,i,0,1,-i,0,-1,-i,0,1];ma.call(this,r,[0,11,5,0,5,1,0,1,7,0,7,10,0,10,11,1,5,9,5,11,4,11,10,2,10,7,6,7,1,8,3,9,4,3,4,2,3,2,6,3,6,8,3,8,9,4,9,5,2,4,11,6,2,10,8,6,7,9,8,1],t,e),this.type="IcosahedronBufferGeometry",this.parameters={radius:t,detail:e}}function wa(t,e){an.call(this),this.type="DodecahedronGeometry",this.parameters={radius:t,detail:e},this.fromBufferGeometry(new Sa(t,e)),this.mergeVertices()}function Sa(t,e){var i=(1+Math.sqrt(5))/2,r=1/i,n=[-1,-1,-1,-1,-1,1,-1,1,-1,-1,1,1,1,-1,-1,1,-1,1,1,1,-1,1,1,1,0,-r,-i,0,-r,i,0,r,-i,0,r,i,-r,-i,0,-r,i,0,r,-i,0,r,i,0,-i,0,-r,i,0,-r,-i,0,r,i,0,r];ma.call(this,n,[3,11,7,3,7,15,3,15,13,7,19,17,7,17,6,7,6,15,17,4,8,17,8,10,17,10,6,8,0,16,8,16,2,8,2,10,0,12,1,0,1,18,0,18,16,6,10,2,6,2,13,6,13,15,2,16,18,2,18,3,2,3,13,18,1,9,18,9,11,18,11,3,4,14,12,4,12,0,4,0,8,11,9,5,11,5,19,11,19,7,19,5,14,19,14,4,19,4,17,1,12,14,1,14,5,1,5,9],t,e),this.type="DodecahedronBufferGeometry",this.parameters={radius:t,detail:e}}function Aa(t,e,i,r,n,o){an.call(this),this.type="TubeGeometry",this.parameters={path:t,tubularSegments:e,radius:i,radialSegments:r,closed:n},void 0!==o&&console.warn("THREE.TubeGeometry: taper has been removed.");var a=new Ma(t,e,i,r,n);this.tangents=a.tangents,this.normals=a.normals,this.binormals=a.binormals,this.fromBufferGeometry(a),this.mergeVertices()}function Ma(t,e,i,r,n){Qn.call(this),this.type="TubeBufferGeometry",this.parameters={path:t,tubularSegments:e,radius:i,radialSegments:r,closed:n},e=e||64,i=i||1,r=r||8,n=n||!1;var o=t.computeFrenetFrames(e,n);this.tangents=o.tangents,this.normals=o.normals,this.binormals=o.binormals;var a,s,c=new $e,u=new $e,h=new Ge,l=new $e,p=[],d=[],f=[],m=[];function g(n){l=t.getPointAt(n/e,l);var a=o.normals[n],h=o.binormals[n];for(s=0;s<=r;s++){var f=s/r*Math.PI*2,m=Math.sin(f),g=-Math.cos(f);u.x=g*a.x+m*h.x,u.y=g*a.y+m*h.y,u.z=g*a.z+m*h.z,u.normalize(),d.push(u.x,u.y,u.z),c.x=l.x+i*u.x,c.y=l.y+i*u.y,c.z=l.z+i*u.z,p.push(c.x,c.y,c.z)}}!function(){for(a=0;a<e;a++)g(a);g(!1===n?e:0),function(){for(a=0;a<=e;a++)for(s=0;s<=r;s++)h.x=a/e,h.y=s/r,f.push(h.x,h.y)}(),function(){for(s=1;s<=e;s++)for(a=1;a<=r;a++){var t=(r+1)*(s-1)+(a-1),i=(r+1)*s+(a-1),n=(r+1)*s+a,o=(r+1)*(s-1)+a;m.push(t,i,o),m.push(i,n,o)}}()}(),this.setIndex(m),this.addAttribute("position",new mn(p,3)),this.addAttribute("normal",new mn(d,3)),this.addAttribute("uv",new mn(f,2))}function Pa(t,e,i,r,n,o,a){an.call(this),this.type="TorusKnotGeometry",this.parameters={radius:t,tube:e,tubularSegments:i,radialSegments:r,p:n,q:o},void 0!==a&&console.warn("THREE.TorusKnotGeometry: heightScale has been deprecated. Use .scale( x, y, z ) instead."),this.fromBufferGeometry(new Ta(t,e,i,r,n,o)),this.mergeVertices()}function Ta(t,e,i,r,n,o){Qn.call(this),this.type="TorusKnotBufferGeometry",this.parameters={radius:t,tube:e,tubularSegments:i,radialSegments:r,p:n,q:o},t=t||1,e=e||.4,i=Math.floor(i)||64,r=Math.floor(r)||8,n=n||2,o=o||3;var a,s,c=[],u=[],h=[],l=[],p=new $e,d=new $e,f=new $e,m=new $e,g=new $e,v=new $e,y=new $e;for(a=0;a<=i;++a){var b=a/i*n*Math.PI*2;for(T(b,n,o,t,f),T(b+.01,n,o,t,m),v.subVectors(m,f),y.addVectors(m,f),g.crossVectors(v,y),y.crossVectors(g,v),g.normalize(),y.normalize(),s=0;s<=r;++s){var x=s/r*Math.PI*2,_=-e*Math.cos(x),w=e*Math.sin(x);p.x=f.x+(_*y.x+w*g.x),p.y=f.y+(_*y.y+w*g.y),p.z=f.z+(_*y.z+w*g.z),u.push(p.x,p.y,p.z),d.subVectors(p,f).normalize(),h.push(d.x,d.y,d.z),l.push(a/i),l.push(s/r)}}for(s=1;s<=i;s++)for(a=1;a<=r;a++){var S=(r+1)*(s-1)+(a-1),A=(r+1)*s+(a-1),M=(r+1)*s+a,P=(r+1)*(s-1)+a;c.push(S,A,P),c.push(A,M,P)}function T(t,e,i,r,n){var o=Math.cos(t),a=Math.sin(t),s=i/e*t,c=Math.cos(s);n.x=r*(2+c)*.5*o,n.y=r*(2+c)*a*.5,n.z=r*Math.sin(s)*.5}this.setIndex(c),this.addAttribute("position",new mn(u,3)),this.addAttribute("normal",new mn(h,3)),this.addAttribute("uv",new mn(l,2))}function Ea(t,e,i,r,n){an.call(this),this.type="TorusGeometry",this.parameters={radius:t,tube:e,radialSegments:i,tubularSegments:r,arc:n},this.fromBufferGeometry(new Ca(t,e,i,r,n)),this.mergeVertices()}function Ca(t,e,i,r,n){Qn.call(this),this.type="TorusBufferGeometry",this.parameters={radius:t,tube:e,radialSegments:i,tubularSegments:r,arc:n},t=t||1,e=e||.4,i=Math.floor(i)||8,r=Math.floor(r)||6,n=n||2*Math.PI;var o,a,s=[],c=[],u=[],h=[],l=new $e,p=new $e,d=new $e;for(o=0;o<=i;o++)for(a=0;a<=r;a++){var f=a/r*n,m=o/i*Math.PI*2;p.x=(t+e*Math.cos(m))*Math.cos(f),p.y=(t+e*Math.cos(m))*Math.sin(f),p.z=e*Math.sin(m),c.push(p.x,p.y,p.z),l.x=t*Math.cos(f),l.y=t*Math.sin(f),d.subVectors(p,l).normalize(),u.push(d.x,d.y,d.z),h.push(a/r),h.push(o/i)}for(o=1;o<=i;o++)for(a=1;a<=r;a++){var g=(r+1)*o+a-1,v=(r+1)*(o-1)+a-1,y=(r+1)*(o-1)+a,b=(r+1)*o+a;s.push(g,v,b),s.push(v,y,b)}this.setIndex(s),this.addAttribute("position",new mn(c,3)),this.addAttribute("normal",new mn(u,3)),this.addAttribute("uv",new mn(h,2))}jo.prototype=Object.assign(Object.create(Yr.prototype),{constructor:jo,isPerspectiveCamera:!0,copy:function(t,e){return Yr.prototype.copy.call(this,t,e),this.fov=t.fov,this.zoom=t.zoom,this.near=t.near,this.far=t.far,this.focus=t.focus,this.aspect=t.aspect,this.view=null===t.view?null:Object.assign({},t.view),this.filmGauge=t.filmGauge,this.filmOffset=t.filmOffset,this},setFocalLength:function(t){var e=.5*this.getFilmHeight()/t;this.fov=2*je.RAD2DEG*Math.atan(e),this.updateProjectionMatrix()},getFocalLength:function(){var t=Math.tan(.5*je.DEG2RAD*this.fov);return.5*this.getFilmHeight()/t},getEffectiveFOV:function(){return 2*je.RAD2DEG*Math.atan(Math.tan(.5*je.DEG2RAD*this.fov)/this.zoom)},getFilmWidth:function(){return this.filmGauge*Math.min(this.aspect,1)},getFilmHeight:function(){return this.filmGauge/Math.max(this.aspect,1)},setViewOffset:function(t,e,i,r,n,o){this.aspect=t/e,null===this.view&&(this.view={enabled:!0,fullWidth:1,fullHeight:1,offsetX:0,offsetY:0,width:1,height:1}),this.view.enabled=!0,this.view.fullWidth=t,this.view.fullHeight=e,this.view.offsetX=i,this.view.offsetY=r,this.view.width=n,this.view.height=o,this.updateProjectionMatrix()},clearViewOffset:function(){null!==this.view&&(this.view.enabled=!1),this.updateProjectionMatrix()},updateProjectionMatrix:function(){var t=this.near,e=t*Math.tan(.5*je.DEG2RAD*this.fov)/this.zoom,i=2*e,r=this.aspect*i,n=-.5*r,o=this.view;if(null!==this.view&&this.view.enabled){var a=o.fullWidth,s=o.fullHeight;n+=o.offsetX*r/a,e-=o.offsetY*i/s,r*=o.width/a,i*=o.height/s}var c=this.filmOffset;0!==c&&(n+=t*c/this.getFilmWidth()),this.projectionMatrix.makePerspective(n,n+r,e,e-i,t,this.far)},toJSON:function(t){var e=qr.prototype.toJSON.call(this,t);return e.object.fov=this.fov,e.object.zoom=this.zoom,e.object.near=this.near,e.object.far=this.far,e.object.focus=this.focus,e.object.aspect=this.aspect,null!==this.view&&(e.object.view=Object.assign({},this.view)),e.object.filmGauge=this.filmGauge,e.object.filmOffset=this.filmOffset,e}}),Go.prototype=Object.assign(Object.create(jo.prototype),{constructor:Go,isArrayCamera:!0}),$o.prototype.isFogExp2=!0,$o.prototype.clone=function(){return new $o(this.color.getHex(),this.density)},$o.prototype.toJSON=function(){return{type:"FogExp2",color:this.color.getHex(),density:this.density}},Wo.prototype.isFog=!0,Wo.prototype.clone=function(){return new Wo(this.color.getHex(),this.near,this.far)},Wo.prototype.toJSON=function(){return{type:"Fog",color:this.color.getHex(),near:this.near,far:this.far}},Xo.prototype=Object.assign(Object.create(qr.prototype),{constructor:Xo,copy:function(t,e){return qr.prototype.copy.call(this,t,e),null!==t.background&&(this.background=t.background.clone()),null!==t.fog&&(this.fog=t.fog.clone()),null!==t.overrideMaterial&&(this.overrideMaterial=t.overrideMaterial.clone()),this.autoUpdate=t.autoUpdate,this.matrixAutoUpdate=t.matrixAutoUpdate,this},toJSON:function(t){var e=qr.prototype.toJSON.call(this,t);return null!==this.background&&(e.object.background=this.background.toJSON(t)),null!==this.fog&&(e.object.fog=this.fog.toJSON()),e}}),qo.prototype=Object.assign(Object.create(qr.prototype),{constructor:qo,isLensFlare:!0,copy:function(t){qr.prototype.copy.call(this,t),this.positionScreen.copy(t.positionScreen),this.customUpdateCallback=t.customUpdateCallback;for(var e=0,i=t.lensFlares.length;e<i;e++)this.lensFlares.push(t.lensFlares[e]);return this},add:function(t,e,i,r,n,o){void 0===e&&(e=-1),void 0===i&&(i=0),void 0===o&&(o=1),void 0===n&&(n=new Gi(16777215)),void 0===r&&(r=J),i=Math.min(i,Math.max(0,i)),this.lensFlares.push({texture:t,size:e,distance:i,x:0,y:0,z:0,scale:1,rotation:0,opacity:o,color:n,blending:r})},updateLensFlares:function(){var t,e,i=this.lensFlares.length,r=2*-this.positionScreen.x,n=2*-this.positionScreen.y;for(t=0;t<i;t++)(e=this.lensFlares[t]).x=this.positionScreen.x+r*e.distance,e.y=this.positionScreen.y+n*e.distance,e.wantedRotation=e.x*Math.PI*.25,e.rotation+=.25*(e.wantedRotation-e.rotation)}}),Yo.prototype=Object.create(vr.prototype),Yo.prototype.constructor=Yo,Yo.prototype.isSpriteMaterial=!0,Yo.prototype.copy=function(t){return vr.prototype.copy.call(this,t),this.color.copy(t.color),this.map=t.map,this.rotation=t.rotation,this},Zo.prototype=Object.assign(Object.create(qr.prototype),{constructor:Zo,isSprite:!0,raycast:(vo=new $e,yo=new $e,bo=new $e,function(t,e){yo.setFromMatrixPosition(this.matrixWorld),t.ray.closestPointToPoint(yo,vo),bo.setFromMatrixScale(this.matrixWorld);var i=bo.x*bo.y/4;if(!(yo.distanceToSquared(vo)>i)){var r=t.ray.origin.distanceTo(vo);r<t.near||r>t.far||e.push({distance:r,point:vo.clone(),face:null,object:this})}}),clone:function(){return new this.constructor(this.material).copy(this)}}),Ko.prototype=Object.assign(Object.create(qr.prototype),{constructor:Ko,copy:function(t){qr.prototype.copy.call(this,t,!1);for(var e=t.levels,i=0,r=e.length;i<r;i++){var n=e[i];this.addLevel(n.object.clone(),n.distance)}return this},addLevel:function(t,e){void 0===e&&(e=0),e=Math.abs(e);for(var i=this.levels,r=0;r<i.length&&!(e<i[r].distance);r++);i.splice(r,0,{distance:e,object:t}),this.add(t)},getObjectForDistance:function(t){for(var e=this.levels,i=1,r=e.length;i<r&&!(t<e[i].distance);i++);return e[i-1].object},raycast:(wo=new $e,function(t,e){wo.setFromMatrixPosition(this.matrixWorld);var i=t.ray.origin.distanceTo(wo);this.getObjectForDistance(i).raycast(t,e)}),update:(xo=new $e,_o=new $e,function(t){var e=this.levels;if(e.length>1){xo.setFromMatrixPosition(t.matrixWorld),_o.setFromMatrixPosition(this.matrixWorld);var i=xo.distanceTo(_o);e[0].object.visible=!0;for(var r=1,n=e.length;r<n&&i>=e[r].distance;r++)e[r-1].object.visible=!1,e[r].object.visible=!0;for(;r<n;r++)e[r].object.visible=!1}}),toJSON:function(t){var e=qr.prototype.toJSON.call(this,t);e.object.levels=[];for(var i=this.levels,r=0,n=i.length;r<n;r++){var o=i[r];e.object.levels.push({object:o.object.uuid,distance:o.distance})}return e}}),Object.assign(Jo.prototype,{calculateInverses:function(){this.boneInverses=[];for(var t=0,e=this.bones.length;t<e;t++){var i=new Ve;this.bones[t]&&i.getInverse(this.bones[t].matrixWorld),this.boneInverses.push(i)}},pose:function(){var t,e,i;for(e=0,i=this.bones.length;e<i;e++)(t=this.bones[e])&&t.matrixWorld.getInverse(this.boneInverses[e]);for(e=0,i=this.bones.length;e<i;e++)(t=this.bones[e])&&(t.parent&&t.parent.isBone?(t.matrix.getInverse(t.parent.matrixWorld),t.matrix.multiply(t.matrixWorld)):t.matrix.copy(t.matrixWorld),t.matrix.decompose(t.position,t.quaternion,t.scale))},update:(So=new Ve,Ao=new Ve,function(){for(var t=this.bones,e=this.boneInverses,i=this.boneMatrices,r=this.boneTexture,n=0,o=t.length;n<o;n++){var a=t[n]?t[n].matrixWorld:Ao;So.multiplyMatrices(a,e[n]),So.toArray(i,16*n)}void 0!==r&&(r.needsUpdate=!0)}),clone:function(){return new Jo(this.bones,this.boneInverses)}}),Qo.prototype=Object.assign(Object.create(qr.prototype),{constructor:Qo,isBone:!0}),ta.prototype=Object.assign(Object.create(uo.prototype),{constructor:ta,isSkinnedMesh:!0,initBones:function(){var t,e,i,r,n=[];if(this.geometry&&void 0!==this.geometry.bones){for(i=0,r=this.geometry.bones.length;i<r;i++)e=this.geometry.bones[i],t=new Qo,n.push(t),t.name=e.name,t.position.fromArray(e.pos),t.quaternion.fromArray(e.rotq),void 0!==e.scl&&t.scale.fromArray(e.scl);for(i=0,r=this.geometry.bones.length;i<r;i++)-1!==(e=this.geometry.bones[i]).parent&&null!==e.parent&&void 0!==n[e.parent]?n[e.parent].add(n[i]):this.add(n[i])}return this.updateMatrixWorld(!0),n},bind:function(t,e){this.skeleton=t,void 0===e&&(this.updateMatrixWorld(!0),this.skeleton.calculateInverses(),e=this.matrixWorld),this.bindMatrix.copy(e),this.bindMatrixInverse.getInverse(e)},pose:function(){this.skeleton.pose()},normalizeSkinWeights:function(){var t,e;if(this.geometry&&this.geometry.isGeometry)for(e=0;e<this.geometry.skinWeights.length;e++){var i=this.geometry.skinWeights[e];(t=1/i.manhattanLength())!==1/0?i.multiplyScalar(t):i.set(1,0,0,0)}else if(this.geometry&&this.geometry.isBufferGeometry){var r=new Ke,n=this.geometry.attributes.skinWeight;for(e=0;e<n.count;e++)r.x=n.getX(e),r.y=n.getY(e),r.z=n.getZ(e),r.w=n.getW(e),(t=1/r.manhattanLength())!==1/0?r.multiplyScalar(t):r.set(1,0,0,0),n.setXYZW(e,r.x,r.y,r.z,r.w)}},updateMatrixWorld:function(t){uo.prototype.updateMatrixWorld.call(this,t),"attached"===this.bindMode?this.bindMatrixInverse.getInverse(this.matrixWorld):"detached"===this.bindMode?this.bindMatrixInverse.getInverse(this.bindMatrix):console.warn("THREE.SkinnedMesh: Unrecognized bindMode: "+this.bindMode)},clone:function(){return new this.constructor(this.geometry,this.material).copy(this)}}),ea.prototype=Object.create(vr.prototype),ea.prototype.constructor=ea,ea.prototype.isLineBasicMaterial=!0,ea.prototype.copy=function(t){return vr.prototype.copy.call(this,t),this.color.copy(t.color),this.linewidth=t.linewidth,this.linecap=t.linecap,this.linejoin=t.linejoin,this},ia.prototype=Object.assign(Object.create(qr.prototype),{constructor:ia,isLine:!0,raycast:(Mo=new Ve,Po=new ao,To=new _r,function(t,e){var i=t.linePrecision,r=i*i,n=this.geometry,o=this.matrixWorld;if(null===n.boundingSphere&&n.computeBoundingSphere(),To.copy(n.boundingSphere),To.applyMatrix4(o),!1!==t.ray.intersectsSphere(To)){Mo.getInverse(o),Po.copy(t.ray).applyMatrix4(Mo);var a=new $e,s=new $e,c=new $e,u=new $e,h=this&&this.isLineSegments?2:1;if(n.isBufferGeometry){var l=n.index,p=n.attributes.position.array;if(null!==l)for(var d=l.array,f=0,m=d.length-1;f<m;f+=h){var g=d[f],v=d[f+1];a.fromArray(p,3*g),s.fromArray(p,3*v),Po.distanceSqToSegment(a,s,u,c)>r||(u.applyMatrix4(this.matrixWorld),(x=t.ray.origin.distanceTo(u))<t.near||x>t.far||e.push({distance:x,point:c.clone().applyMatrix4(this.matrixWorld),index:f,face:null,faceIndex:null,object:this}))}else for(f=0,m=p.length/3-1;f<m;f+=h)a.fromArray(p,3*f),s.fromArray(p,3*f+3),Po.distanceSqToSegment(a,s,u,c)>r||(u.applyMatrix4(this.matrixWorld),(x=t.ray.origin.distanceTo(u))<t.near||x>t.far||e.push({distance:x,point:c.clone().applyMatrix4(this.matrixWorld),index:f,face:null,faceIndex:null,object:this}))}else if(n.isGeometry){var y=n.vertices,b=y.length;for(f=0;f<b-1;f+=h){var x;Po.distanceSqToSegment(y[f],y[f+1],u,c)>r||(u.applyMatrix4(this.matrixWorld),(x=t.ray.origin.distanceTo(u))<t.near||x>t.far||e.push({distance:x,point:c.clone().applyMatrix4(this.matrixWorld),index:f,face:null,faceIndex:null,object:this}))}}}}),clone:function(){return new this.constructor(this.geometry,this.material).copy(this)}}),ra.prototype=Object.assign(Object.create(ia.prototype),{constructor:ra,isLineSegments:!0}),na.prototype=Object.assign(Object.create(ia.prototype),{constructor:na,isLineLoop:!0}),oa.prototype=Object.create(vr.prototype),oa.prototype.constructor=oa,oa.prototype.isPointsMaterial=!0,oa.prototype.copy=function(t){return vr.prototype.copy.call(this,t),this.color.copy(t.color),this.map=t.map,this.size=t.size,this.sizeAttenuation=t.sizeAttenuation,this},aa.prototype=Object.assign(Object.create(qr.prototype),{constructor:aa,isPoints:!0,raycast:(Eo=new Ve,Co=new ao,Io=new _r,function(t,e){var i=this,r=this.geometry,n=this.matrixWorld,o=t.params.Points.threshold;if(null===r.boundingSphere&&r.computeBoundingSphere(),Io.copy(r.boundingSphere),Io.applyMatrix4(n),Io.radius+=o,!1!==t.ray.intersectsSphere(Io)){Eo.getInverse(n),Co.copy(t.ray).applyMatrix4(Eo);var a=o/((this.scale.x+this.scale.y+this.scale.z)/3),s=a*a,c=new $e;if(r.isBufferGeometry){var u=r.index,h=r.attributes.position.array;if(null!==u)for(var l=u.array,p=0,d=l.length;p<d;p++){var f=l[p];c.fromArray(h,3*f),v(c,f)}else{p=0;for(var m=h.length/3;p<m;p++)c.fromArray(h,3*p),v(c,p)}}else{var g=r.vertices;for(p=0,m=g.length;p<m;p++)v(g[p],p)}}function v(r,o){var a=Co.distanceSqToPoint(r);if(a<s){var c=Co.closestPointToPoint(r);c.applyMatrix4(n);var u=t.ray.origin.distanceTo(c);if(u<t.near||u>t.far)return;e.push({distance:u,distanceToRay:Math.sqrt(a),point:c.clone(),index:o,face:null,object:i})}}}),clone:function(){return new this.constructor(this.geometry,this.material).copy(this)}}),sa.prototype=Object.assign(Object.create(qr.prototype),{constructor:sa,isGroup:!0}),ca.prototype=Object.assign(Object.create(Ze.prototype),{constructor:ca,isVideoTexture:!0,update:function(){var t=this.image;t.readyState>=t.HAVE_CURRENT_DATA&&(this.needsUpdate=!0)}}),ua.prototype=Object.create(Ze.prototype),ua.prototype.constructor=ua,ua.prototype.isCompressedTexture=!0,ha.prototype=Object.create(Ze.prototype),ha.prototype.constructor=ha,ha.prototype.isDepthTexture=!0,la.prototype=Object.create(Qn.prototype),la.prototype.constructor=la,pa.prototype=Object.create(an.prototype),pa.prototype.constructor=pa,da.prototype=Object.create(Qn.prototype),da.prototype.constructor=da,fa.prototype=Object.create(an.prototype),fa.prototype.constructor=fa,ma.prototype=Object.create(Qn.prototype),ma.prototype.constructor=ma,ga.prototype=Object.create(an.prototype),ga.prototype.constructor=ga,va.prototype=Object.create(ma.prototype),va.prototype.constructor=va,ya.prototype=Object.create(an.prototype),ya.prototype.constructor=ya,ba.prototype=Object.create(ma.prototype),ba.prototype.constructor=ba,xa.prototype=Object.create(an.prototype),xa.prototype.constructor=xa,_a.prototype=Object.create(ma.prototype),_a.prototype.constructor=_a,wa.prototype=Object.create(an.prototype),wa.prototype.constructor=wa,Sa.prototype=Object.create(ma.prototype),Sa.prototype.constructor=Sa,Aa.prototype=Object.create(an.prototype),Aa.prototype.constructor=Aa,Ma.prototype=Object.create(Qn.prototype),Ma.prototype.constructor=Ma,Pa.prototype=Object.create(an.prototype),Pa.prototype.constructor=Pa,Ta.prototype=Object.create(Qn.prototype),Ta.prototype.constructor=Ta,Ea.prototype=Object.create(an.prototype),Ea.prototype.constructor=Ea,Ca.prototype=Object.create(Qn.prototype),Ca.prototype.constructor=Ca;var Ia=function(t,e,i){i=i||2;var r,n,o,a,s,c,u,h=e&&e.length,l=h?e[0]*i:t.length,p=Ra(t,0,l,i,!0),d=[];if(!p)return d;if(h&&(p=function(t,e,i,r){var n,o,a,s,c,u=[];for(n=0,o=e.length;n<o;n++)a=e[n]*r,s=n<o-1?e[n+1]*r:t.length,(c=Ra(t,a,s,r,!1))===c.next&&(c.steiner=!0),u.push(ja(c));for(u.sort(Fa),n=0;n<u.length;n++)za(u[n],i),i=La(i,i.next);return i}(t,e,p,i)),t.length>80*i){r=o=t[0],n=a=t[1];for(var f=i;f<l;f+=i)s=t[f],c=t[f+1],s<r&&(r=s),c<n&&(n=c),s>o&&(o=s),c>a&&(a=c);u=0!==(u=Math.max(o-r,a-n))?1/u:0}return Oa(p,d,i,r,n,u),d};function Ra(t,e,i,r,n){var o,a;if(n===function(t,e,i,r){for(var n=0,o=e,a=i-r;o<i;o+=r)n+=(t[a]-t[o])*(t[o+1]+t[a+1]),a=o;return n}(t,e,i,r)>0)for(o=e;o<i;o+=r)a=qa(o,t[o],t[o+1],a);else for(o=i-r;o>=e;o-=r)a=qa(o,t[o],t[o+1],a);return a&&Ha(a,a.next)&&(Ya(a),a=a.next),a}function La(t,e){if(!t)return t;e||(e=t);var i,r=t;do{if(i=!1,r.steiner||!Ha(r,r.next)&&0!==Va(r.prev,r,r.next))r=r.next;else{if(Ya(r),(r=e=r.prev)===r.next)break;i=!0}}while(i||r!==e);return e}function Oa(t,e,i,r,n,o,a){if(t){!a&&o&&function(t,e,i,r){var n=t;do{null===n.z&&(n.z=Ua(n.x,n.y,e,i,r)),n.prevZ=n.prev,n.nextZ=n.next,n=n.next}while(n!==t);n.prevZ.nextZ=null,n.prevZ=null,function(t){var e,i,r,n,o,a,s,c,u=1;do{for(i=t,t=null,o=null,a=0;i;){for(a++,r=i,s=0,e=0;e<u&&(s++,r=r.nextZ);e++);for(c=u;s>0||c>0&&r;)0!==s&&(0===c||!r||i.z<=r.z)?(n=i,i=i.nextZ,s--):(n=r,r=r.nextZ,c--),o?o.nextZ=n:t=n,n.prevZ=o,o=n;i=r}o.nextZ=null,u*=2}while(a>1)}(n)}(t,r,n,o);for(var s,c,u=t;t.prev!==t.next;)if(s=t.prev,c=t.next,o?ka(t,r,n,o):Da(t))e.push(s.i/i),e.push(t.i/i),e.push(c.i/i),Ya(t),t=c.next,u=c.next;else if((t=c)===u){a?1===a?Oa(t=Na(t,e,i),e,i,r,n,o,2):2===a&&Ba(t,e,i,r,n,o):Oa(La(t),e,i,r,n,o,1);break}}}function Da(t){var e=t.prev,i=t,r=t.next;if(Va(e,i,r)>=0)return!1;for(var n=t.next.next;n!==t.prev;){if(Ga(e.x,e.y,i.x,i.y,r.x,r.y,n.x,n.y)&&Va(n.prev,n,n.next)>=0)return!1;n=n.next}return!0}function ka(t,e,i,r){var n=t.prev,o=t,a=t.next;if(Va(n,o,a)>=0)return!1;for(var s=n.x<o.x?n.x<a.x?n.x:a.x:o.x<a.x?o.x:a.x,c=n.y<o.y?n.y<a.y?n.y:a.y:o.y<a.y?o.y:a.y,u=n.x>o.x?n.x>a.x?n.x:a.x:o.x>a.x?o.x:a.x,h=n.y>o.y?n.y>a.y?n.y:a.y:o.y>a.y?o.y:a.y,l=Ua(s,c,e,i,r),p=Ua(u,h,e,i,r),d=t.nextZ;d&&d.z<=p;){if(d!==t.prev&&d!==t.next&&Ga(n.x,n.y,o.x,o.y,a.x,a.y,d.x,d.y)&&Va(d.prev,d,d.next)>=0)return!1;d=d.nextZ}for(d=t.prevZ;d&&d.z>=l;){if(d!==t.prev&&d!==t.next&&Ga(n.x,n.y,o.x,o.y,a.x,a.y,d.x,d.y)&&Va(d.prev,d,d.next)>=0)return!1;d=d.prevZ}return!0}function Na(t,e,i){var r=t;do{var n=r.prev,o=r.next.next;!Ha(n,o)&&$a(n,r,r.next,o)&&Wa(n,o)&&Wa(o,n)&&(e.push(n.i/i),e.push(r.i/i),e.push(o.i/i),Ya(r),Ya(r.next),r=t=o),r=r.next}while(r!==t);return r}function Ba(t,e,i,r,n,o){var a,s,c=t;do{for(var u=c.next.next;u!==c.prev;){if(c.i!==u.i&&(s=u,(a=c).next.i!==s.i&&a.prev.i!==s.i&&!function(t,e){var i=t;do{if(i.i!==t.i&&i.next.i!==t.i&&i.i!==e.i&&i.next.i!==e.i&&$a(i,i.next,t,e))return!0;i=i.next}while(i!==t);return!1}(a,s)&&Wa(a,s)&&Wa(s,a)&&function(t,e){var i=t,r=!1,n=(t.x+e.x)/2,o=(t.y+e.y)/2;do{i.y>o!=i.next.y>o&&i.next.y!==i.y&&n<(i.next.x-i.x)*(o-i.y)/(i.next.y-i.y)+i.x&&(r=!r),i=i.next}while(i!==t);return r}(a,s))){var h=Xa(c,u);return c=La(c,c.next),h=La(h,h.next),Oa(c,e,i,r,n,o),void Oa(h,e,i,r,n,o)}u=u.next}c=c.next}while(c!==t)}function Fa(t,e){return t.x-e.x}function za(t,e){if(e=function(t,e){var i,r=e,n=t.x,o=t.y,a=-1/0;do{if(o<=r.y&&o>=r.next.y&&r.next.y!==r.y){var s=r.x+(o-r.y)*(r.next.x-r.x)/(r.next.y-r.y);if(s<=n&&s>a){if(a=s,s===n){if(o===r.y)return r;if(o===r.next.y)return r.next}i=r.x<r.next.x?r:r.next}}r=r.next}while(r!==e);if(!i)return null;if(n===a)return i.prev;var c,u=i,h=i.x,l=i.y,p=1/0;r=i.next;for(;r!==u;)n>=r.x&&r.x>=h&&n!==r.x&&Ga(o<l?n:a,o,h,l,o<l?a:n,o,r.x,r.y)&&((c=Math.abs(o-r.y)/(n-r.x))<p||c===p&&r.x>i.x)&&Wa(r,t)&&(i=r,p=c),r=r.next;return i}(t,e)){var i=Xa(e,t);La(i,i.next)}}function Ua(t,e,i,r,n){return(t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=32767*(t-i)*n)|t<<8))|t<<4))|t<<2))|t<<1))|(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=32767*(e-r)*n)|e<<8))|e<<4))|e<<2))|e<<1))<<1}function ja(t){var e=t,i=t;do{e.x<i.x&&(i=e),e=e.next}while(e!==t);return i}function Ga(t,e,i,r,n,o,a,s){return(n-a)*(e-s)-(t-a)*(o-s)>=0&&(t-a)*(r-s)-(i-a)*(e-s)>=0&&(i-a)*(o-s)-(n-a)*(r-s)>=0}function Va(t,e,i){return(e.y-t.y)*(i.x-e.x)-(e.x-t.x)*(i.y-e.y)}function Ha(t,e){return t.x===e.x&&t.y===e.y}function $a(t,e,i,r){return!!(Ha(t,e)&&Ha(i,r)||Ha(t,r)&&Ha(i,e))||Va(t,e,i)>0!=Va(t,e,r)>0&&Va(i,r,t)>0!=Va(i,r,e)>0}function Wa(t,e){return Va(t.prev,t,t.next)<0?Va(t,e,t.next)>=0&&Va(t,t.prev,e)>=0:Va(t,e,t.prev)<0||Va(t,t.next,e)<0}function Xa(t,e){var i=new Za(t.i,t.x,t.y),r=new Za(e.i,e.x,e.y),n=t.next,o=e.prev;return t.next=e,e.prev=t,i.next=n,n.prev=i,r.next=i,i.prev=r,o.next=r,r.prev=o,r}function qa(t,e,i,r){var n=new Za(t,e,i);return r?(n.next=r.next,n.prev=r,r.next.prev=n,r.next=n):(n.prev=n,n.next=n),n}function Ya(t){t.next.prev=t.prev,t.prev.next=t.next,t.prevZ&&(t.prevZ.nextZ=t.nextZ),t.nextZ&&(t.nextZ.prevZ=t.prevZ)}function Za(t,e,i){this.i=t,this.x=e,this.y=i,this.prev=null,this.next=null,this.z=null,this.prevZ=null,this.nextZ=null,this.steiner=!1}var Ka={area:function(t){for(var e=t.length,i=0,r=e-1,n=0;n<e;r=n++)i+=t[r].x*t[n].y-t[n].x*t[r].y;return.5*i},isClockWise:function(t){return Ka.area(t)<0},triangulateShape:function(t,e){function i(t){var e=t.length;e>2&&t[e-1].equals(t[0])&&t.pop()}function r(t,e){for(var i=0;i<e.length;i++)t.push(e[i].x),t.push(e[i].y)}var n=[],o=[],a=[];i(t),r(n,t);var s=t.length;for(e.forEach(i),u=0;u<e.length;u++)o.push(s),s+=e[u].length,r(n,e[u]);for(var c=Ia(n,o),u=0;u<c.length;u+=3)a.push(c.slice(u,u+3));return a}};function Ja(t,e){an.call(this),this.type="ExtrudeGeometry",this.parameters={shapes:t,options:e},this.fromBufferGeometry(new Qa(t,e)),this.mergeVertices()}function Qa(t,e){void 0!==t&&(Qn.call(this),this.type="ExtrudeBufferGeometry",t=Array.isArray(t)?t:[t],this.addShapeList(t,e),this.computeVertexNormals())}function ts(t,e){an.call(this),this.type="TextGeometry",this.parameters={text:t,parameters:e},this.fromBufferGeometry(new es(t,e)),this.mergeVertices()}function es(t,e){var i=(e=e||{}).font;if(!i||!i.isFont)return console.error("THREE.TextGeometry: font parameter is not an instance of THREE.Font."),new an;var r=i.generateShapes(t,e.size,e.curveSegments);e.amount=void 0!==e.height?e.height:50,void 0===e.bevelThickness&&(e.bevelThickness=10),void 0===e.bevelSize&&(e.bevelSize=8),void 0===e.bevelEnabled&&(e.bevelEnabled=!1),Qa.call(this,r,e),this.type="TextBufferGeometry"}function is(t,e,i,r,n,o,a){an.call(this),this.type="SphereGeometry",this.parameters={radius:t,widthSegments:e,heightSegments:i,phiStart:r,phiLength:n,thetaStart:o,thetaLength:a},this.fromBufferGeometry(new rs(t,e,i,r,n,o,a)),this.mergeVertices()}function rs(t,e,i,r,n,o,a){Qn.call(this),this.type="SphereBufferGeometry",this.parameters={radius:t,widthSegments:e,heightSegments:i,phiStart:r,phiLength:n,thetaStart:o,thetaLength:a},t=t||1,e=Math.max(3,Math.floor(e)||8),i=Math.max(2,Math.floor(i)||6),r=void 0!==r?r:0,n=void 0!==n?n:2*Math.PI;var s,c,u=(o=void 0!==o?o:0)+(a=void 0!==a?a:Math.PI),h=0,l=[],p=new $e,d=new $e,f=[],m=[],g=[],v=[];for(c=0;c<=i;c++){var y=[],b=c/i;for(s=0;s<=e;s++){var x=s/e;p.x=-t*Math.cos(r+x*n)*Math.sin(o+b*a),p.y=t*Math.cos(o+b*a),p.z=t*Math.sin(r+x*n)*Math.sin(o+b*a),m.push(p.x,p.y,p.z),d.set(p.x,p.y,p.z).normalize(),g.push(d.x,d.y,d.z),v.push(x,1-b),y.push(h++)}l.push(y)}for(c=0;c<i;c++)for(s=0;s<e;s++){var _=l[c][s+1],w=l[c][s],S=l[c+1][s],A=l[c+1][s+1];(0!==c||o>0)&&f.push(_,w,A),(c!==i-1||u<Math.PI)&&f.push(w,S,A)}this.setIndex(f),this.addAttribute("position",new mn(m,3)),this.addAttribute("normal",new mn(g,3)),this.addAttribute("uv",new mn(v,2))}function ns(t,e,i,r,n,o){an.call(this),this.type="RingGeometry",this.parameters={innerRadius:t,outerRadius:e,thetaSegments:i,phiSegments:r,thetaStart:n,thetaLength:o},this.fromBufferGeometry(new os(t,e,i,r,n,o)),this.mergeVertices()}function os(t,e,i,r,n,o){Qn.call(this),this.type="RingBufferGeometry",this.parameters={innerRadius:t,outerRadius:e,thetaSegments:i,phiSegments:r,thetaStart:n,thetaLength:o},t=t||.5,e=e||1,n=void 0!==n?n:0,o=void 0!==o?o:2*Math.PI,i=void 0!==i?Math.max(3,i):8;var a,s,c,u=[],h=[],l=[],p=[],d=t,f=(e-t)/(r=void 0!==r?Math.max(1,r):1),m=new $e,g=new Ge;for(s=0;s<=r;s++){for(c=0;c<=i;c++)a=n+c/i*o,m.x=d*Math.cos(a),m.y=d*Math.sin(a),h.push(m.x,m.y,m.z),l.push(0,0,1),g.x=(m.x/e+1)/2,g.y=(m.y/e+1)/2,p.push(g.x,g.y);d+=f}for(s=0;s<r;s++){var v=s*(i+1);for(c=0;c<i;c++){var y=a=c+v,b=a+i+1,x=a+i+2,_=a+1;u.push(y,b,_),u.push(b,x,_)}}this.setIndex(u),this.addAttribute("position",new mn(h,3)),this.addAttribute("normal",new mn(l,3)),this.addAttribute("uv",new mn(p,2))}function as(t,e,i,r){an.call(this),this.type="LatheGeometry",this.parameters={points:t,segments:e,phiStart:i,phiLength:r},this.fromBufferGeometry(new ss(t,e,i,r)),this.mergeVertices()}function ss(t,e,i,r){Qn.call(this),this.type="LatheBufferGeometry",this.parameters={points:t,segments:e,phiStart:i,phiLength:r},e=Math.floor(e)||12,i=i||0,r=r||2*Math.PI,r=je.clamp(r,0,2*Math.PI);var n,o,a,s=[],c=[],u=[],h=1/e,l=new $e,p=new Ge;for(o=0;o<=e;o++){var d=i+o*h*r,f=Math.sin(d),m=Math.cos(d);for(a=0;a<=t.length-1;a++)l.x=t[a].x*f,l.y=t[a].y,l.z=t[a].x*m,c.push(l.x,l.y,l.z),p.x=o/e,p.y=a/(t.length-1),u.push(p.x,p.y)}for(o=0;o<e;o++)for(a=0;a<t.length-1;a++){var g=n=a+o*t.length,v=n+t.length,y=n+t.length+1,b=n+1;s.push(g,v,b),s.push(v,y,b)}if(this.setIndex(s),this.addAttribute("position",new mn(c,3)),this.addAttribute("uv",new mn(u,2)),this.computeVertexNormals(),r===2*Math.PI){var x=this.attributes.normal.array,_=new $e,w=new $e,S=new $e;for(n=e*t.length*3,o=0,a=0;o<t.length;o++,a+=3)_.x=x[a+0],_.y=x[a+1],_.z=x[a+2],w.x=x[n+a+0],w.y=x[n+a+1],w.z=x[n+a+2],S.addVectors(_,w).normalize(),x[a+0]=x[n+a+0]=S.x,x[a+1]=x[n+a+1]=S.y,x[a+2]=x[n+a+2]=S.z}}function cs(t,e){an.call(this),this.type="ShapeGeometry","object"==typeof e&&(console.warn("THREE.ShapeGeometry: Options parameter has been removed."),e=e.curveSegments),this.parameters={shapes:t,curveSegments:e},this.fromBufferGeometry(new us(t,e)),this.mergeVertices()}function us(t,e){Qn.call(this),this.type="ShapeBufferGeometry",this.parameters={shapes:t,curveSegments:e},e=e||12;var i=[],r=[],n=[],o=[],a=0,s=0;if(!1===Array.isArray(t))u(t);else for(var c=0;c<t.length;c++)u(t[c]),this.addGroup(a,s,c),a+=s,s=0;function u(t){var a,c,u,h=r.length/3,l=t.extractPoints(e),p=l.shape,d=l.holes;if(!1===Ka.isClockWise(p))for(p=p.reverse(),a=0,c=d.length;a<c;a++)u=d[a],!0===Ka.isClockWise(u)&&(d[a]=u.reverse());var f=Ka.triangulateShape(p,d);for(a=0,c=d.length;a<c;a++)u=d[a],p=p.concat(u);for(a=0,c=p.length;a<c;a++){var m=p[a];r.push(m.x,m.y,0),n.push(0,0,1),o.push(m.x,m.y)}for(a=0,c=f.length;a<c;a++){var g=f[a],v=g[0]+h,y=g[1]+h,b=g[2]+h;i.push(v,y,b),s+=3}}this.setIndex(i),this.addAttribute("position",new mn(r,3)),this.addAttribute("normal",new mn(n,3)),this.addAttribute("uv",new mn(o,2))}function hs(t,e){if(e.shapes=[],Array.isArray(t))for(var i=0,r=t.length;i<r;i++){var n=t[i];e.shapes.push(n.uuid)}else e.shapes.push(t.uuid);return e}function ls(t,e){Qn.call(this),this.type="EdgesGeometry",this.parameters={thresholdAngle:e},e=void 0!==e?e:1;var i,r,n,o,a=[],s=Math.cos(je.DEG2RAD*e),c=[0,0],u={},h=["a","b","c"];t.isBufferGeometry?(o=new an).fromBufferGeometry(t):o=t.clone(),o.mergeVertices(),o.computeFaceNormals();for(var l=o.vertices,p=o.faces,d=0,f=p.length;d<f;d++)for(var m=p[d],g=0;g<3;g++)i=m[h[g]],r=m[h[(g+1)%3]],c[0]=Math.min(i,r),c[1]=Math.max(i,r),void 0===u[n=c[0]+","+c[1]]?u[n]={index1:c[0],index2:c[1],face1:d,face2:void 0}:u[n].face2=d;for(n in u){var v=u[n];if(void 0===v.face2||p[v.face1].normal.dot(p[v.face2].normal)<=s){var y=l[v.index1];a.push(y.x,y.y,y.z),y=l[v.index2],a.push(y.x,y.y,y.z)}}this.addAttribute("position",new mn(a,3))}function ps(t,e,i,r,n,o,a,s){an.call(this),this.type="CylinderGeometry",this.parameters={radiusTop:t,radiusBottom:e,height:i,radialSegments:r,heightSegments:n,openEnded:o,thetaStart:a,thetaLength:s},this.fromBufferGeometry(new ds(t,e,i,r,n,o,a,s)),this.mergeVertices()}function ds(t,e,i,r,n,o,a,s){Qn.call(this),this.type="CylinderBufferGeometry",this.parameters={radiusTop:t,radiusBottom:e,height:i,radialSegments:r,heightSegments:n,openEnded:o,thetaStart:a,thetaLength:s};var c=this;t=void 0!==t?t:1,e=void 0!==e?e:1,i=i||1,r=Math.floor(r)||8,n=Math.floor(n)||1,o=void 0!==o&&o,a=void 0!==a?a:0,s=void 0!==s?s:2*Math.PI;var u=[],h=[],l=[],p=[],d=0,f=[],m=i/2,g=0;function v(i){var n,o,f,v=new Ge,y=new $e,b=0,x=!0===i?t:e,_=!0===i?1:-1;for(o=d,n=1;n<=r;n++)h.push(0,m*_,0),l.push(0,_,0),p.push(.5,.5),d++;for(f=d,n=0;n<=r;n++){var w=n/r*s+a,S=Math.cos(w),A=Math.sin(w);y.x=x*A,y.y=m*_,y.z=x*S,h.push(y.x,y.y,y.z),l.push(0,_,0),v.x=.5*S+.5,v.y=.5*A*_+.5,p.push(v.x,v.y),d++}for(n=0;n<r;n++){var M=o+n,P=f+n;!0===i?u.push(P,P+1,M):u.push(P+1,P,M),b+=3}c.addGroup(g,b,!0===i?1:2),g+=b}!function(){var o,v,y=new $e,b=new $e,x=0,_=(e-t)/i;for(v=0;v<=n;v++){var w=[],S=v/n,A=S*(e-t)+t;for(o=0;o<=r;o++){var M=o/r,P=M*s+a,T=Math.sin(P),E=Math.cos(P);b.x=A*T,b.y=-S*i+m,b.z=A*E,h.push(b.x,b.y,b.z),y.set(T,_,E).normalize(),l.push(y.x,y.y,y.z),p.push(M,1-S),w.push(d++)}f.push(w)}for(o=0;o<r;o++)for(v=0;v<n;v++){var C=f[v][o],I=f[v+1][o],R=f[v+1][o+1],L=f[v][o+1];u.push(C,I,L),u.push(I,R,L),x+=6}c.addGroup(g,x,0),g+=x}(),!1===o&&(t>0&&v(!0),e>0&&v(!1)),this.setIndex(u),this.addAttribute("position",new mn(h,3)),this.addAttribute("normal",new mn(l,3)),this.addAttribute("uv",new mn(p,2))}function fs(t,e,i,r,n,o,a){ps.call(this,0,t,e,i,r,n,o,a),this.type="ConeGeometry",this.parameters={radius:t,height:e,radialSegments:i,heightSegments:r,openEnded:n,thetaStart:o,thetaLength:a}}function ms(t,e,i,r,n,o,a){ds.call(this,0,t,e,i,r,n,o,a),this.type="ConeBufferGeometry",this.parameters={radius:t,height:e,radialSegments:i,heightSegments:r,openEnded:n,thetaStart:o,thetaLength:a}}function gs(t,e,i,r){an.call(this),this.type="CircleGeometry",this.parameters={radius:t,segments:e,thetaStart:i,thetaLength:r},this.fromBufferGeometry(new vs(t,e,i,r)),this.mergeVertices()}function vs(t,e,i,r){Qn.call(this),this.type="CircleBufferGeometry",this.parameters={radius:t,segments:e,thetaStart:i,thetaLength:r},t=t||1,e=void 0!==e?Math.max(3,e):8,i=void 0!==i?i:0,r=void 0!==r?r:2*Math.PI;var n,o,a=[],s=[],c=[],u=[],h=new $e,l=new Ge;for(s.push(0,0,0),c.push(0,0,1),u.push(.5,.5),o=0,n=3;o<=e;o++,n+=3){var p=i+o/e*r;h.x=t*Math.cos(p),h.y=t*Math.sin(p),s.push(h.x,h.y,h.z),c.push(0,0,1),l.x=(s[n]/t+1)/2,l.y=(s[n+1]/t+1)/2,u.push(l.x,l.y)}for(n=1;n<=e;n++)a.push(n,n+1,0);this.setIndex(a),this.addAttribute("position",new mn(s,3)),this.addAttribute("normal",new mn(c,3)),this.addAttribute("uv",new mn(u,2))}Ja.prototype=Object.create(an.prototype),Ja.prototype.constructor=Ja,Qa.prototype=Object.create(Qn.prototype),Qa.prototype.constructor=Qa,Qa.prototype.getArrays=function(){var t=this.getAttribute("position"),e=t?Array.prototype.slice.call(t.array):[],i=this.getAttribute("uv"),r=i?Array.prototype.slice.call(i.array):[],n=this.index;return{position:e,uv:r,index:n?Array.prototype.slice.call(n.array):[]}},Qa.prototype.addShapeList=function(t,e){var i=t.length;e.arrays=this.getArrays();for(var r=0;r<i;r++){var n=t[r];this.addShape(n,e)}this.setIndex(e.arrays.index),this.addAttribute("position",new mn(e.arrays.position,3)),this.addAttribute("uv",new mn(e.arrays.uv,2))},Qa.prototype.addShape=function(t,e){var i,r,n,o,a,s,c,u,h=e.arrays?e.arrays:this.getArrays(),l=h.position,p=h.index,d=h.uv,f=[],m=void 0!==e.amount?e.amount:100,g=void 0!==e.bevelThickness?e.bevelThickness:6,v=void 0!==e.bevelSize?e.bevelSize:g-2,y=void 0!==e.bevelSegments?e.bevelSegments:3,b=void 0===e.bevelEnabled||e.bevelEnabled,x=void 0!==e.curveSegments?e.curveSegments:12,_=void 0!==e.steps?e.steps:1,w=e.extrudePath,S=!1,A=void 0!==e.UVGenerator?e.UVGenerator:Ja.WorldUVGenerator;w&&(i=w.getSpacedPoints(_),S=!0,b=!1,r=void 0!==e.frames?e.frames:w.computeFrenetFrames(_,!1),n=new $e,o=new $e,a=new $e),b||(y=0,g=0,v=0);var M=this,P=t.extractPoints(x),T=P.shape,E=P.holes;if(!Ka.isClockWise(T))for(T=T.reverse(),c=0,u=E.length;c<u;c++)s=E[c],Ka.isClockWise(s)&&(E[c]=s.reverse());var C=Ka.triangulateShape(T,E),I=T;for(c=0,u=E.length;c<u;c++)s=E[c],T=T.concat(s);function R(t,e,i){return e||console.error("THREE.ExtrudeGeometry: vec does not exist"),e.clone().multiplyScalar(i).add(t)}var L,O,D,k,N,B,F=T.length,z=C.length;function U(t,e,i){var r,n,o,a=t.x-e.x,s=t.y-e.y,c=i.x-t.x,u=i.y-t.y,h=a*a+s*s,l=a*u-s*c;if(Math.abs(l)>Number.EPSILON){var p=Math.sqrt(h),d=Math.sqrt(c*c+u*u),f=e.x-s/p,m=e.y+a/p,g=((i.x-u/d-f)*u-(i.y+c/d-m)*c)/(a*u-s*c),v=(r=f+a*g-t.x)*r+(n=m+s*g-t.y)*n;if(v<=2)return new Ge(r,n);o=Math.sqrt(v/2)}else{var y=!1;a>Number.EPSILON?c>Number.EPSILON&&(y=!0):a<-Number.EPSILON?c<-Number.EPSILON&&(y=!0):Math.sign(s)===Math.sign(u)&&(y=!0),y?(r=-s,n=a,o=Math.sqrt(h)):(r=a,n=s,o=Math.sqrt(h/2))}return new Ge(r/o,n/o)}for(var j=[],G=0,V=I.length,H=V-1,$=G+1;G<V;G++,H++,$++)H===V&&(H=0),$===V&&($=0),j[G]=U(I[G],I[H],I[$]);var W,X,q=[],Y=j.concat();for(c=0,u=E.length;c<u;c++){for(s=E[c],W=[],G=0,H=(V=s.length)-1,$=G+1;G<V;G++,H++,$++)H===V&&(H=0),$===V&&($=0),W[G]=U(s[G],s[H],s[$]);q.push(W),Y=Y.concat(W)}for(L=0;L<y;L++){for(D=L/y,k=g*Math.cos(D*Math.PI/2),O=v*Math.sin(D*Math.PI/2),G=0,V=I.length;G<V;G++)K((N=R(I[G],j[G],O)).x,N.y,-k);for(c=0,u=E.length;c<u;c++)for(s=E[c],W=q[c],G=0,V=s.length;G<V;G++)K((N=R(s[G],W[G],O)).x,N.y,-k)}for(O=v,G=0;G<F;G++)N=b?R(T[G],Y[G],O):T[G],S?(o.copy(r.normals[0]).multiplyScalar(N.x),n.copy(r.binormals[0]).multiplyScalar(N.y),a.copy(i[0]).add(o).add(n),K(a.x,a.y,a.z)):K(N.x,N.y,0);for(X=1;X<=_;X++)for(G=0;G<F;G++)N=b?R(T[G],Y[G],O):T[G],S?(o.copy(r.normals[X]).multiplyScalar(N.x),n.copy(r.binormals[X]).multiplyScalar(N.y),a.copy(i[X]).add(o).add(n),K(a.x,a.y,a.z)):K(N.x,N.y,m/_*X);for(L=y-1;L>=0;L--){for(D=L/y,k=g*Math.cos(D*Math.PI/2),O=v*Math.sin(D*Math.PI/2),G=0,V=I.length;G<V;G++)K((N=R(I[G],j[G],O)).x,N.y,m+k);for(c=0,u=E.length;c<u;c++)for(s=E[c],W=q[c],G=0,V=s.length;G<V;G++)N=R(s[G],W[G],O),S?K(N.x,N.y+i[_-1].y,i[_-1].x+k):K(N.x,N.y,m+k)}function Z(t,e){var i,r;for(G=t.length;--G>=0;){i=G,(r=G-1)<0&&(r=t.length-1);var n=0,o=_+2*y;for(n=0;n<o;n++){var a=F*n,s=F*(n+1);Q(e+i+a,e+r+a,e+r+s,e+i+s)}}}function K(t,e,i){f.push(t),f.push(e),f.push(i)}function J(t,e,i){tt(t),tt(e),tt(i);var r=l.length/3,n=A.generateTopUV(M,l,r-3,r-2,r-1);et(n[0]),et(n[1]),et(n[2])}function Q(t,e,i,r){tt(t),tt(e),tt(r),tt(e),tt(i),tt(r);var n=l.length/3,o=A.generateSideWallUV(M,l,n-6,n-3,n-2,n-1);et(o[0]),et(o[1]),et(o[3]),et(o[1]),et(o[2]),et(o[3])}function tt(t){p.push(l.length/3),l.push(f[3*t+0]),l.push(f[3*t+1]),l.push(f[3*t+2])}function et(t){d.push(t.x),d.push(t.y)}!function(){var t=l.length/3;if(b){var i=0,r=F*i;for(G=0;G<z;G++)J((B=C[G])[2]+r,B[1]+r,B[0]+r);for(r=F*(i=_+2*y),G=0;G<z;G++)J((B=C[G])[0]+r,B[1]+r,B[2]+r)}else{for(G=0;G<z;G++)J((B=C[G])[2],B[1],B[0]);for(G=0;G<z;G++)J((B=C[G])[0]+F*_,B[1]+F*_,B[2]+F*_)}M.addGroup(t,l.length/3-t,void 0!==e.material?e.material:0)}(),function(){var t=l.length/3,i=0;for(Z(I,i),i+=I.length,c=0,u=E.length;c<u;c++)Z(s=E[c],i),i+=s.length;M.addGroup(t,l.length/3-t,void 0!==e.extrudeMaterial?e.extrudeMaterial:1)}(),e.arrays||(this.setIndex(p),this.addAttribute("position",new mn(l,3)),this.addAttribute("uv",new mn(d,2)))},Ja.WorldUVGenerator={generateTopUV:function(t,e,i,r,n){var o=e[3*i],a=e[3*i+1],s=e[3*r],c=e[3*r+1],u=e[3*n],h=e[3*n+1];return[new Ge(o,a),new Ge(s,c),new Ge(u,h)]},generateSideWallUV:function(t,e,i,r,n,o){var a=e[3*i],s=e[3*i+1],c=e[3*i+2],u=e[3*r],h=e[3*r+1],l=e[3*r+2],p=e[3*n],d=e[3*n+1],f=e[3*n+2],m=e[3*o],g=e[3*o+1],v=e[3*o+2];return Math.abs(s-h)<.01?[new Ge(a,1-c),new Ge(u,1-l),new Ge(p,1-f),new Ge(m,1-v)]:[new Ge(s,1-c),new Ge(h,1-l),new Ge(d,1-f),new Ge(g,1-v)]}},ts.prototype=Object.create(an.prototype),ts.prototype.constructor=ts,es.prototype=Object.create(Qa.prototype),es.prototype.constructor=es,is.prototype=Object.create(an.prototype),is.prototype.constructor=is,rs.prototype=Object.create(Qn.prototype),rs.prototype.constructor=rs,ns.prototype=Object.create(an.prototype),ns.prototype.constructor=ns,os.prototype=Object.create(Qn.prototype),os.prototype.constructor=os,as.prototype=Object.create(an.prototype),as.prototype.constructor=as,ss.prototype=Object.create(Qn.prototype),ss.prototype.constructor=ss,cs.prototype=Object.create(an.prototype),cs.prototype.constructor=cs,cs.prototype.toJSON=function(){var t=an.prototype.toJSON.call(this);return hs(this.parameters.shapes,t)},us.prototype=Object.create(Qn.prototype),us.prototype.constructor=us,us.prototype.toJSON=function(){var t=Qn.prototype.toJSON.call(this);return hs(this.parameters.shapes,t)},ls.prototype=Object.create(Qn.prototype),ls.prototype.constructor=ls,ps.prototype=Object.create(an.prototype),ps.prototype.constructor=ps,ds.prototype=Object.create(Qn.prototype),ds.prototype.constructor=ds,fs.prototype=Object.create(ps.prototype),fs.prototype.constructor=fs,ms.prototype=Object.create(ds.prototype),ms.prototype.constructor=ms,gs.prototype=Object.create(an.prototype),gs.prototype.constructor=gs,vs.prototype=Object.create(Qn.prototype),vs.prototype.constructor=vs;var ys=Object.freeze({WireframeGeometry:la,ParametricGeometry:pa,ParametricBufferGeometry:da,TetrahedronGeometry:ga,TetrahedronBufferGeometry:va,OctahedronGeometry:ya,OctahedronBufferGeometry:ba,IcosahedronGeometry:xa,IcosahedronBufferGeometry:_a,DodecahedronGeometry:wa,DodecahedronBufferGeometry:Sa,PolyhedronGeometry:fa,PolyhedronBufferGeometry:ma,TubeGeometry:Aa,TubeBufferGeometry:Ma,TorusKnotGeometry:Pa,TorusKnotBufferGeometry:Ta,TorusGeometry:Ea,TorusBufferGeometry:Ca,TextGeometry:ts,TextBufferGeometry:es,SphereGeometry:is,SphereBufferGeometry:rs,RingGeometry:ns,RingBufferGeometry:os,PlaneGeometry:io,PlaneBufferGeometry:ro,LatheGeometry:as,LatheBufferGeometry:ss,ShapeGeometry:cs,ShapeBufferGeometry:us,ExtrudeGeometry:Ja,ExtrudeBufferGeometry:Qa,EdgesGeometry:ls,ConeGeometry:fs,ConeBufferGeometry:ms,CylinderGeometry:ps,CylinderBufferGeometry:ds,CircleGeometry:gs,CircleBufferGeometry:vs,BoxGeometry:to,BoxBufferGeometry:eo});function bs(t){vr.call(this),this.type="ShadowMaterial",this.color=new Gi(0),this.opacity=1,this.lights=!0,this.transparent=!0,this.setValues(t)}function xs(t){oo.call(this,t),this.type="RawShaderMaterial"}function _s(t){vr.call(this),this.defines={STANDARD:""},this.type="MeshStandardMaterial",this.color=new Gi(16777215),this.roughness=.5,this.metalness=.5,this.map=null,this.lightMap=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.emissive=new Gi(0),this.emissiveIntensity=1,this.emissiveMap=null,this.bumpMap=null,this.bumpScale=1,this.normalMap=null,this.normalScale=new Ge(1,1),this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.roughnessMap=null,this.metalnessMap=null,this.alphaMap=null,this.envMap=null,this.envMapIntensity=1,this.refractionRatio=.98,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinecap="round",this.wireframeLinejoin="round",this.skinning=!1,this.morphTargets=!1,this.morphNormals=!1,this.setValues(t)}function ws(t){_s.call(this),this.defines={PHYSICAL:""},this.type="MeshPhysicalMaterial",this.reflectivity=.5,this.clearCoat=0,this.clearCoatRoughness=0,this.setValues(t)}function Ss(t){vr.call(this),this.type="MeshPhongMaterial",this.color=new Gi(16777215),this.specular=new Gi(1118481),this.shininess=30,this.map=null,this.lightMap=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.emissive=new Gi(0),this.emissiveIntensity=1,this.emissiveMap=null,this.bumpMap=null,this.bumpScale=1,this.normalMap=null,this.normalScale=new Ge(1,1),this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.specularMap=null,this.alphaMap=null,this.envMap=null,this.combine=Tt,this.reflectivity=1,this.refractionRatio=.98,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinecap="round",this.wireframeLinejoin="round",this.skinning=!1,this.morphTargets=!1,this.morphNormals=!1,this.setValues(t)}function As(t){Ss.call(this),this.defines={TOON:""},this.type="MeshToonMaterial",this.gradientMap=null,this.setValues(t)}function Ms(t){vr.call(this),this.type="MeshNormalMaterial",this.bumpMap=null,this.bumpScale=1,this.normalMap=null,this.normalScale=new Ge(1,1),this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.wireframe=!1,this.wireframeLinewidth=1,this.fog=!1,this.lights=!1,this.skinning=!1,this.morphTargets=!1,this.morphNormals=!1,this.setValues(t)}function Ps(t){vr.call(this),this.type="MeshLambertMaterial",this.color=new Gi(16777215),this.map=null,this.lightMap=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.emissive=new Gi(0),this.emissiveIntensity=1,this.emissiveMap=null,this.specularMap=null,this.alphaMap=null,this.envMap=null,this.combine=Tt,this.reflectivity=1,this.refractionRatio=.98,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinecap="round",this.wireframeLinejoin="round",this.skinning=!1,this.morphTargets=!1,this.morphNormals=!1,this.setValues(t)}function Ts(t){ea.call(this),this.type="LineDashedMaterial",this.scale=1,this.dashSize=3,this.gapSize=1,this.setValues(t)}bs.prototype=Object.create(vr.prototype),bs.prototype.constructor=bs,bs.prototype.isShadowMaterial=!0,xs.prototype=Object.create(oo.prototype),xs.prototype.constructor=xs,xs.prototype.isRawShaderMaterial=!0,_s.prototype=Object.create(vr.prototype),_s.prototype.constructor=_s,_s.prototype.isMeshStandardMaterial=!0,_s.prototype.copy=function(t){return vr.prototype.copy.call(this,t),this.defines={STANDARD:""},this.color.copy(t.color),this.roughness=t.roughness,this.metalness=t.metalness,this.map=t.map,this.lightMap=t.lightMap,this.lightMapIntensity=t.lightMapIntensity,this.aoMap=t.aoMap,this.aoMapIntensity=t.aoMapIntensity,this.emissive.copy(t.emissive),this.emissiveMap=t.emissiveMap,this.emissiveIntensity=t.emissiveIntensity,this.bumpMap=t.bumpMap,this.bumpScale=t.bumpScale,this.normalMap=t.normalMap,this.normalScale.copy(t.normalScale),this.displacementMap=t.displacementMap,this.displacementScale=t.displacementScale,this.displacementBias=t.displacementBias,this.roughnessMap=t.roughnessMap,this.metalnessMap=t.metalnessMap,this.alphaMap=t.alphaMap,this.envMap=t.envMap,this.envMapIntensity=t.envMapIntensity,this.refractionRatio=t.refractionRatio,this.wireframe=t.wireframe,this.wireframeLinewidth=t.wireframeLinewidth,this.wireframeLinecap=t.wireframeLinecap,this.wireframeLinejoin=t.wireframeLinejoin,this.skinning=t.skinning,this.morphTargets=t.morphTargets,this.morphNormals=t.morphNormals,this},ws.prototype=Object.create(_s.prototype),ws.prototype.constructor=ws,ws.prototype.isMeshPhysicalMaterial=!0,ws.prototype.copy=function(t){return _s.prototype.copy.call(this,t),this.defines={PHYSICAL:""},this.reflectivity=t.reflectivity,this.clearCoat=t.clearCoat,this.clearCoatRoughness=t.clearCoatRoughness,this},Ss.prototype=Object.create(vr.prototype),Ss.prototype.constructor=Ss,Ss.prototype.isMeshPhongMaterial=!0,Ss.prototype.copy=function(t){return vr.prototype.copy.call(this,t),this.color.copy(t.color),this.specular.copy(t.specular),this.shininess=t.shininess,this.map=t.map,this.lightMap=t.lightMap,this.lightMapIntensity=t.lightMapIntensity,this.aoMap=t.aoMap,this.aoMapIntensity=t.aoMapIntensity,this.emissive.copy(t.emissive),this.emissiveMap=t.emissiveMap,this.emissiveIntensity=t.emissiveIntensity,this.bumpMap=t.bumpMap,this.bumpScale=t.bumpScale,this.normalMap=t.normalMap,this.normalScale.copy(t.normalScale),this.displacementMap=t.displacementMap,this.displacementScale=t.displacementScale,this.displacementBias=t.displacementBias,this.specularMap=t.specularMap,this.alphaMap=t.alphaMap,this.envMap=t.envMap,this.combine=t.combine,this.reflectivity=t.reflectivity,this.refractionRatio=t.refractionRatio,this.wireframe=t.wireframe,this.wireframeLinewidth=t.wireframeLinewidth,this.wireframeLinecap=t.wireframeLinecap,this.wireframeLinejoin=t.wireframeLinejoin,this.skinning=t.skinning,this.morphTargets=t.morphTargets,this.morphNormals=t.morphNormals,this},As.prototype=Object.create(Ss.prototype),As.prototype.constructor=As,As.prototype.isMeshToonMaterial=!0,As.prototype.copy=function(t){return Ss.prototype.copy.call(this,t),this.gradientMap=t.gradientMap,this},Ms.prototype=Object.create(vr.prototype),Ms.prototype.constructor=Ms,Ms.prototype.isMeshNormalMaterial=!0,Ms.prototype.copy=function(t){return vr.prototype.copy.call(this,t),this.bumpMap=t.bumpMap,this.bumpScale=t.bumpScale,this.normalMap=t.normalMap,this.normalScale.copy(t.normalScale),this.displacementMap=t.displacementMap,this.displacementScale=t.displacementScale,this.displacementBias=t.displacementBias,this.wireframe=t.wireframe,this.wireframeLinewidth=t.wireframeLinewidth,this.skinning=t.skinning,this.morphTargets=t.morphTargets,this.morphNormals=t.morphNormals,this},Ps.prototype=Object.create(vr.prototype),Ps.prototype.constructor=Ps,Ps.prototype.isMeshLambertMaterial=!0,Ps.prototype.copy=function(t){return vr.prototype.copy.call(this,t),this.color.copy(t.color),this.map=t.map,this.lightMap=t.lightMap,this.lightMapIntensity=t.lightMapIntensity,this.aoMap=t.aoMap,this.aoMapIntensity=t.aoMapIntensity,this.emissive.copy(t.emissive),this.emissiveMap=t.emissiveMap,this.emissiveIntensity=t.emissiveIntensity,this.specularMap=t.specularMap,this.alphaMap=t.alphaMap,this.envMap=t.envMap,this.combine=t.combine,this.reflectivity=t.reflectivity,this.refractionRatio=t.refractionRatio,this.wireframe=t.wireframe,this.wireframeLinewidth=t.wireframeLinewidth,this.wireframeLinecap=t.wireframeLinecap,this.wireframeLinejoin=t.wireframeLinejoin,this.skinning=t.skinning,this.morphTargets=t.morphTargets,this.morphNormals=t.morphNormals,this},Ts.prototype=Object.create(ea.prototype),Ts.prototype.constructor=Ts,Ts.prototype.isLineDashedMaterial=!0,Ts.prototype.copy=function(t){return ea.prototype.copy.call(this,t),this.scale=t.scale,this.dashSize=t.dashSize,this.gapSize=t.gapSize,this};var Es=Object.freeze({ShadowMaterial:bs,SpriteMaterial:Yo,RawShaderMaterial:xs,ShaderMaterial:oo,PointsMaterial:oa,MeshPhysicalMaterial:ws,MeshStandardMaterial:_s,MeshPhongMaterial:Ss,MeshToonMaterial:As,MeshNormalMaterial:Ms,MeshLambertMaterial:Ps,MeshDepthMaterial:yr,MeshDistanceMaterial:br,MeshBasicMaterial:no,LineDashedMaterial:Ts,LineBasicMaterial:ea,Material:vr}),Cs={enabled:!1,files:{},add:function(t,e){!1!==this.enabled&&(this.files[t]=e)},get:function(t){if(!1!==this.enabled)return this.files[t]},remove:function(t){delete this.files[t]},clear:function(){this.files={}}};function Is(t,e,i){var r=this,n=!1,o=0,a=0,s=void 0;this.onStart=void 0,this.onLoad=t,this.onProgress=e,this.onError=i,this.itemStart=function(t){a++,!1===n&&void 0!==r.onStart&&r.onStart(t,o,a),n=!0},this.itemEnd=function(t){o++,void 0!==r.onProgress&&r.onProgress(t,o,a),o===a&&(n=!1,void 0!==r.onLoad&&r.onLoad())},this.itemError=function(t){void 0!==r.onError&&r.onError(t)},this.resolveURL=function(t){return s?s(t):t},this.setURLModifier=function(t){return s=t,this}}var Rs=new Is,Ls={};function Os(t){this.manager=void 0!==t?t:Rs}function Ds(t){this.manager=void 0!==t?t:Rs}function ks(t){this.manager=void 0!==t?t:Rs}function Ns(){this.type="Curve",this.arcLengthDivisions=200}function Bs(t,e,i,r,n,o,a,s){Ns.call(this),this.type="EllipseCurve",this.aX=t||0,this.aY=e||0,this.xRadius=i||1,this.yRadius=r||1,this.aStartAngle=n||0,this.aEndAngle=o||2*Math.PI,this.aClockwise=a||!1,this.aRotation=s||0}function Fs(t,e,i,r,n,o){Bs.call(this,t,e,i,i,r,n,o),this.type="ArcCurve"}function zs(){var t=0,e=0,i=0,r=0;function n(n,o,a,s){t=n,e=a,i=-3*n+3*o-2*a-s,r=2*n-2*o+a+s}return{initCatmullRom:function(t,e,i,r,o){n(e,i,o*(i-t),o*(r-e))},initNonuniformCatmullRom:function(t,e,i,r,o,a,s){var c=(e-t)/o-(i-t)/(o+a)+(i-e)/a,u=(i-e)/a-(r-e)/(a+s)+(r-i)/s;n(e,i,c*=a,u*=a)},calc:function(n){var o=n*n;return t+e*n+i*o+r*(o*n)}}}Object.assign(Os.prototype,{load:function(t,e,i,r){void 0===t&&(t=""),void 0!==this.path&&(t=this.path+t),t=this.manager.resolveURL(t);var n=this,o=Cs.get(t);if(void 0!==o)return n.manager.itemStart(t),setTimeout(function(){e&&e(o),n.manager.itemEnd(t)},0),o;if(void 0===Ls[t]){var a=t.match(/^data:(.*?)(;base64)?,(.*)$/);if(a){var s=a[1],c=!!a[2],u=a[3];u=window.decodeURIComponent(u),c&&(u=window.atob(u));try{var h,l=(this.responseType||"").toLowerCase();switch(l){case"arraybuffer":case"blob":for(var p=new Uint8Array(u.length),d=0;d<u.length;d++)p[d]=u.charCodeAt(d);h="blob"===l?new Blob([p.buffer],{type:s}):p.buffer;break;case"document":var f=new DOMParser;h=f.parseFromString(u,s);break;case"json":h=JSON.parse(u);break;default:h=u}window.setTimeout(function(){e&&e(h),n.manager.itemEnd(t)},0)}catch(e){window.setTimeout(function(){r&&r(e),n.manager.itemEnd(t),n.manager.itemError(t)},0)}}else{Ls[t]=[],Ls[t].push({onLoad:e,onProgress:i,onError:r});var m=new XMLHttpRequest;for(var g in m.open("GET",t,!0),m.addEventListener("load",function(e){var i=this.response;Cs.add(t,i);var r=Ls[t];if(delete Ls[t],200===this.status){for(var o=0,a=r.length;o<a;o++){(s=r[o]).onLoad&&s.onLoad(i)}n.manager.itemEnd(t)}else if(0===this.status){console.warn("THREE.FileLoader: HTTP Status 0 received.");for(o=0,a=r.length;o<a;o++){(s=r[o]).onLoad&&s.onLoad(i)}n.manager.itemEnd(t)}else{for(o=0,a=r.length;o<a;o++){var s;(s=r[o]).onError&&s.onError(e)}n.manager.itemEnd(t),n.manager.itemError(t)}},!1),m.addEventListener("progress",function(e){for(var i=Ls[t],r=0,n=i.length;r<n;r++){var o=i[r];o.onProgress&&o.onProgress(e)}},!1),m.addEventListener("error",function(e){var i=Ls[t];delete Ls[t];for(var r=0,o=i.length;r<o;r++){var a=i[r];a.onError&&a.onError(e)}n.manager.itemEnd(t),n.manager.itemError(t)},!1),void 0!==this.responseType&&(m.responseType=this.responseType),void 0!==this.withCredentials&&(m.withCredentials=this.withCredentials),m.overrideMimeType&&m.overrideMimeType(void 0!==this.mimeType?this.mimeType:"text/plain"),this.requestHeader)m.setRequestHeader(g,this.requestHeader[g]);m.send(null)}return n.manager.itemStart(t),m}Ls[t].push({onLoad:e,onProgress:i,onError:r})},setPath:function(t){return this.path=t,this},setResponseType:function(t){return this.responseType=t,this},setWithCredentials:function(t){return this.withCredentials=t,this},setMimeType:function(t){return this.mimeType=t,this},setRequestHeader:function(t){return this.requestHeader=t,this}}),Object.assign(function(t){this.manager=void 0!==t?t:Rs,this._parser=null}.prototype,{load:function(t,e,i,r){var n=this,o=[],a=new ua;a.image=o;var s=new Os(this.manager);function c(c){s.load(t[c],function(t){var i=n._parser(t,!0);o[c]={width:i.width,height:i.height,format:i.format,mipmaps:i.mipmaps},6===(u+=1)&&(1===i.mipmapCount&&(a.minFilter=qt),a.format=i.format,a.needsUpdate=!0,e&&e(a))},i,r)}if(s.setPath(this.path),s.setResponseType("arraybuffer"),Array.isArray(t))for(var u=0,h=0,l=t.length;h<l;++h)c(h);else s.load(t,function(t){var i=n._parser(t,!0);if(i.isCubemap)for(var r=i.mipmaps.length/i.mipmapCount,s=0;s<r;s++){o[s]={mipmaps:[]};for(var c=0;c<i.mipmapCount;c++)o[s].mipmaps.push(i.mipmaps[s*i.mipmapCount+c]),o[s].format=i.format,o[s].width=i.width,o[s].height=i.height}else a.image.width=i.width,a.image.height=i.height,a.mipmaps=i.mipmaps;1===i.mipmapCount&&(a.minFilter=qt),a.format=i.format,a.needsUpdate=!0,e&&e(a)},i,r);return a},setPath:function(t){return this.path=t,this}}),Object.assign(function(t){this.manager=void 0!==t?t:Rs,this._parser=null}.prototype,{load:function(t,e,i,r){var n=this,o=new ti,a=new Os(this.manager);return a.setResponseType("arraybuffer"),a.load(t,function(t){var i=n._parser(t);i&&(void 0!==i.image?o.image=i.image:void 0!==i.data&&(o.image.width=i.width,o.image.height=i.height,o.image.data=i.data),o.wrapS=void 0!==i.wrapS?i.wrapS:Vt,o.wrapT=void 0!==i.wrapT?i.wrapT:Vt,o.magFilter=void 0!==i.magFilter?i.magFilter:qt,o.minFilter=void 0!==i.minFilter?i.minFilter:Zt,o.anisotropy=void 0!==i.anisotropy?i.anisotropy:1,void 0!==i.format&&(o.format=i.format),void 0!==i.type&&(o.type=i.type),void 0!==i.mipmaps&&(o.mipmaps=i.mipmaps),1===i.mipmapCount&&(o.minFilter=qt),o.needsUpdate=!0,e&&e(o,i))},i,r),o}}),Object.assign(Ds.prototype,{crossOrigin:"Anonymous",load:function(t,e,i,r){void 0===t&&(t=""),void 0!==this.path&&(t=this.path+t),t=this.manager.resolveURL(t);var n=this,o=Cs.get(t);if(void 0!==o)return n.manager.itemStart(t),setTimeout(function(){e&&e(o),n.manager.itemEnd(t)},0),o;var a=document.createElementNS("http://www.w3.org/1999/xhtml","img");return a.addEventListener("load",function(){Cs.add(t,this),e&&e(this),n.manager.itemEnd(t)},!1),a.addEventListener("error",function(e){r&&r(e),n.manager.itemEnd(t),n.manager.itemError(t)},!1),"data:"!==t.substr(0,5)&&void 0!==this.crossOrigin&&(a.crossOrigin=this.crossOrigin),n.manager.itemStart(t),a.src=t,a},setCrossOrigin:function(t){return this.crossOrigin=t,this},setPath:function(t){return this.path=t,this}}),Object.assign(function(t){this.manager=void 0!==t?t:Rs}.prototype,{crossOrigin:"Anonymous",load:function(t,e,i,r){var n=new ei,o=new Ds(this.manager);o.setCrossOrigin(this.crossOrigin),o.setPath(this.path);var a=0;function s(i){o.load(t[i],function(t){n.images[i]=t,6===++a&&(n.needsUpdate=!0,e&&e(n))},void 0,r)}for(var c=0;c<t.length;++c)s(c);return n},setCrossOrigin:function(t){return this.crossOrigin=t,this},setPath:function(t){return this.path=t,this}}),Object.assign(ks.prototype,{crossOrigin:"Anonymous",load:function(t,e,i,r){var n=new Ze,o=new Ds(this.manager);return o.setCrossOrigin(this.crossOrigin),o.setPath(this.path),o.load(t,function(i){n.image=i;var r=t.search(/\.(jpg|jpeg)$/)>0||0===t.search(/^data\:image\/jpeg/);n.format=r?he:le,n.needsUpdate=!0,void 0!==e&&e(n)},i,r),n},setCrossOrigin:function(t){return this.crossOrigin=t,this},setPath:function(t){return this.path=t,this}}),Object.assign(Ns.prototype,{getPoint:function(){return console.warn("THREE.Curve: .getPoint() not implemented."),null},getPointAt:function(t,e){var i=this.getUtoTmapping(t);return this.getPoint(i,e)},getPoints:function(t){void 0===t&&(t=5);for(var e=[],i=0;i<=t;i++)e.push(this.getPoint(i/t));return e},getSpacedPoints:function(t){void 0===t&&(t=5);for(var e=[],i=0;i<=t;i++)e.push(this.getPointAt(i/t));return e},getLength:function(){var t=this.getLengths();return t[t.length-1]},getLengths:function(t){if(void 0===t&&(t=this.arcLengthDivisions),this.cacheArcLengths&&this.cacheArcLengths.length===t+1&&!this.needsUpdate)return this.cacheArcLengths;this.needsUpdate=!1;var e,i,r=[],n=this.getPoint(0),o=0;for(r.push(0),i=1;i<=t;i++)o+=(e=this.getPoint(i/t)).distanceTo(n),r.push(o),n=e;return this.cacheArcLengths=r,r},updateArcLengths:function(){this.needsUpdate=!0,this.getLengths()},getUtoTmapping:function(t,e){var i,r=this.getLengths(),n=0,o=r.length;i=e||t*r[o-1];for(var a,s=0,c=o-1;s<=c;)if((a=r[n=Math.floor(s+(c-s)/2)]-i)<0)s=n+1;else{if(!(a>0)){c=n;break}c=n-1}if(r[n=c]===i)return n/(o-1);var u=r[n];return(n+(i-u)/(r[n+1]-u))/(o-1)},getTangent:function(t){var e=t-1e-4,i=t+1e-4;e<0&&(e=0),i>1&&(i=1);var r=this.getPoint(e);return this.getPoint(i).clone().sub(r).normalize()},getTangentAt:function(t){var e=this.getUtoTmapping(t);return this.getTangent(e)},computeFrenetFrames:function(t,e){var i,r,n,o=new $e,a=[],s=[],c=[],u=new $e,h=new Ve;for(i=0;i<=t;i++)r=i/t,a[i]=this.getTangentAt(r),a[i].normalize();s[0]=new $e,c[0]=new $e;var l=Number.MAX_VALUE,p=Math.abs(a[0].x),d=Math.abs(a[0].y),f=Math.abs(a[0].z);for(p<=l&&(l=p,o.set(1,0,0)),d<=l&&(l=d,o.set(0,1,0)),f<=l&&o.set(0,0,1),u.crossVectors(a[0],o).normalize(),s[0].crossVectors(a[0],u),c[0].crossVectors(a[0],s[0]),i=1;i<=t;i++)s[i]=s[i-1].clone(),c[i]=c[i-1].clone(),u.crossVectors(a[i-1],a[i]),u.length()>Number.EPSILON&&(u.normalize(),n=Math.acos(je.clamp(a[i-1].dot(a[i]),-1,1)),s[i].applyMatrix4(h.makeRotationAxis(u,n))),c[i].crossVectors(a[i],s[i]);if(!0===e)for(n=Math.acos(je.clamp(s[0].dot(s[t]),-1,1)),n/=t,a[0].dot(u.crossVectors(s[0],s[t]))>0&&(n=-n),i=1;i<=t;i++)s[i].applyMatrix4(h.makeRotationAxis(a[i],n*i)),c[i].crossVectors(a[i],s[i]);return{tangents:a,normals:s,binormals:c}},clone:function(){return(new this.constructor).copy(this)},copy:function(t){return this.arcLengthDivisions=t.arcLengthDivisions,this},toJSON:function(){var t={metadata:{version:4.5,type:"Curve",generator:"Curve.toJSON"}};return t.arcLengthDivisions=this.arcLengthDivisions,t.type=this.type,t},fromJSON:function(t){return this.arcLengthDivisions=t.arcLengthDivisions,this}}),Bs.prototype=Object.create(Ns.prototype),Bs.prototype.constructor=Bs,Bs.prototype.isEllipseCurve=!0,Bs.prototype.getPoint=function(t,e){for(var i=e||new Ge,r=2*Math.PI,n=this.aEndAngle-this.aStartAngle,o=Math.abs(n)<Number.EPSILON;n<0;)n+=r;for(;n>r;)n-=r;n<Number.EPSILON&&(n=o?0:r),!0!==this.aClockwise||o||(n===r?n=-r:n-=r);var a=this.aStartAngle+t*n,s=this.aX+this.xRadius*Math.cos(a),c=this.aY+this.yRadius*Math.sin(a);if(0!==this.aRotation){var u=Math.cos(this.aRotation),h=Math.sin(this.aRotation),l=s-this.aX,p=c-this.aY;s=l*u-p*h+this.aX,c=l*h+p*u+this.aY}return i.set(s,c)},Bs.prototype.copy=function(t){return Ns.prototype.copy.call(this,t),this.aX=t.aX,this.aY=t.aY,this.xRadius=t.xRadius,this.yRadius=t.yRadius,this.aStartAngle=t.aStartAngle,this.aEndAngle=t.aEndAngle,this.aClockwise=t.aClockwise,this.aRotation=t.aRotation,this},Bs.prototype.toJSON=function(){var t=Ns.prototype.toJSON.call(this);return t.aX=this.aX,t.aY=this.aY,t.xRadius=this.xRadius,t.yRadius=this.yRadius,t.aStartAngle=this.aStartAngle,t.aEndAngle=this.aEndAngle,t.aClockwise=this.aClockwise,t.aRotation=this.aRotation,t},Bs.prototype.fromJSON=function(t){return Ns.prototype.fromJSON.call(this,t),this.aX=t.aX,this.aY=t.aY,this.xRadius=t.xRadius,this.yRadius=t.yRadius,this.aStartAngle=t.aStartAngle,this.aEndAngle=t.aEndAngle,this.aClockwise=t.aClockwise,this.aRotation=t.aRotation,this},Fs.prototype=Object.create(Bs.prototype),Fs.prototype.constructor=Fs,Fs.prototype.isArcCurve=!0;var Us=new $e,js=new zs,Gs=new zs,Vs=new zs;function Hs(t,e,i,r){Ns.call(this),this.type="CatmullRomCurve3",this.points=t||[],this.closed=e||!1,this.curveType=i||"centripetal",this.tension=r||.5}function $s(t,e,i,r,n){var o=.5*(r-e),a=.5*(n-i),s=t*t;return(2*i-2*r+o+a)*(t*s)+(-3*i+3*r-2*o-a)*s+o*t+i}function Ws(t,e,i,r){return(a=1-t)*a*e+2*(1-(o=t))*o*i+(n=t)*n*r;var n,o,a}function Xs(t,e,i,r,n){return(u=1-t)*u*u*e+3*(c=1-(s=t))*c*s*i+3*(1-(a=t))*a*a*r+(o=t)*o*o*n;var o,a,s,c,u}function qs(t,e,i,r){Ns.call(this),this.type="CubicBezierCurve",this.v0=t||new Ge,this.v1=e||new Ge,this.v2=i||new Ge,this.v3=r||new Ge}function Ys(t,e,i,r){Ns.call(this),this.type="CubicBezierCurve3",this.v0=t||new $e,this.v1=e||new $e,this.v2=i||new $e,this.v3=r||new $e}function Zs(t,e){Ns.call(this),this.type="LineCurve",this.v1=t||new Ge,this.v2=e||new Ge}function Ks(t,e){Ns.call(this),this.type="LineCurve3",this.v1=t||new $e,this.v2=e||new $e}function Js(t,e,i){Ns.call(this),this.type="QuadraticBezierCurve",this.v0=t||new Ge,this.v1=e||new Ge,this.v2=i||new Ge}function Qs(t,e,i){Ns.call(this),this.type="QuadraticBezierCurve3",this.v0=t||new $e,this.v1=e||new $e,this.v2=i||new $e}function tc(t){Ns.call(this),this.type="SplineCurve",this.points=t||[]}Hs.prototype=Object.create(Ns.prototype),Hs.prototype.constructor=Hs,Hs.prototype.isCatmullRomCurve3=!0,Hs.prototype.getPoint=function(t,e){var i,r,n,o,a=e||new $e,s=this.points,c=s.length,u=(c-(this.closed?0:1))*t,h=Math.floor(u),l=u-h;if(this.closed?h+=h>0?0:(Math.floor(Math.abs(h)/s.length)+1)*s.length:0===l&&h===c-1&&(h=c-2,l=1),this.closed||h>0?i=s[(h-1)%c]:(Us.subVectors(s[0],s[1]).add(s[0]),i=Us),r=s[h%c],n=s[(h+1)%c],this.closed||h+2<c?o=s[(h+2)%c]:(Us.subVectors(s[c-1],s[c-2]).add(s[c-1]),o=Us),"centripetal"===this.curveType||"chordal"===this.curveType){var p="chordal"===this.curveType?.5:.25,d=Math.pow(i.distanceToSquared(r),p),f=Math.pow(r.distanceToSquared(n),p),m=Math.pow(n.distanceToSquared(o),p);f<1e-4&&(f=1),d<1e-4&&(d=f),m<1e-4&&(m=f),js.initNonuniformCatmullRom(i.x,r.x,n.x,o.x,d,f,m),Gs.initNonuniformCatmullRom(i.y,r.y,n.y,o.y,d,f,m),Vs.initNonuniformCatmullRom(i.z,r.z,n.z,o.z,d,f,m)}else"catmullrom"===this.curveType&&(js.initCatmullRom(i.x,r.x,n.x,o.x,this.tension),Gs.initCatmullRom(i.y,r.y,n.y,o.y,this.tension),Vs.initCatmullRom(i.z,r.z,n.z,o.z,this.tension));return a.set(js.calc(l),Gs.calc(l),Vs.calc(l)),a},Hs.prototype.copy=function(t){Ns.prototype.copy.call(this,t),this.points=[];for(var e=0,i=t.points.length;e<i;e++){var r=t.points[e];this.points.push(r.clone())}return this.closed=t.closed,this.curveType=t.curveType,this.tension=t.tension,this},Hs.prototype.toJSON=function(){var t=Ns.prototype.toJSON.call(this);t.points=[];for(var e=0,i=this.points.length;e<i;e++){var r=this.points[e];t.points.push(r.toArray())}return t.closed=this.closed,t.curveType=this.curveType,t.tension=this.tension,t},Hs.prototype.fromJSON=function(t){Ns.prototype.fromJSON.call(this,t),this.points=[];for(var e=0,i=t.points.length;e<i;e++){var r=t.points[e];this.points.push((new $e).fromArray(r))}return this.closed=t.closed,this.curveType=t.curveType,this.tension=t.tension,this},qs.prototype=Object.create(Ns.prototype),qs.prototype.constructor=qs,qs.prototype.isCubicBezierCurve=!0,qs.prototype.getPoint=function(t,e){var i=e||new Ge,r=this.v0,n=this.v1,o=this.v2,a=this.v3;return i.set(Xs(t,r.x,n.x,o.x,a.x),Xs(t,r.y,n.y,o.y,a.y)),i},qs.prototype.copy=function(t){return Ns.prototype.copy.call(this,t),this.v0.copy(t.v0),this.v1.copy(t.v1),this.v2.copy(t.v2),this.v3.copy(t.v3),this},qs.prototype.toJSON=function(){var t=Ns.prototype.toJSON.call(this);return t.v0=this.v0.toArray(),t.v1=this.v1.toArray(),t.v2=this.v2.toArray(),t.v3=this.v3.toArray(),t},qs.prototype.fromJSON=function(t){return Ns.prototype.fromJSON.call(this,t),this.v0.fromArray(t.v0),this.v1.fromArray(t.v1),this.v2.fromArray(t.v2),this.v3.fromArray(t.v3),this},Ys.prototype=Object.create(Ns.prototype),Ys.prototype.constructor=Ys,Ys.prototype.isCubicBezierCurve3=!0,Ys.prototype.getPoint=function(t,e){var i=e||new $e,r=this.v0,n=this.v1,o=this.v2,a=this.v3;return i.set(Xs(t,r.x,n.x,o.x,a.x),Xs(t,r.y,n.y,o.y,a.y),Xs(t,r.z,n.z,o.z,a.z)),i},Ys.prototype.copy=function(t){return Ns.prototype.copy.call(this,t),this.v0.copy(t.v0),this.v1.copy(t.v1),this.v2.copy(t.v2),this.v3.copy(t.v3),this},Ys.prototype.toJSON=function(){var t=Ns.prototype.toJSON.call(this);return t.v0=this.v0.toArray(),t.v1=this.v1.toArray(),t.v2=this.v2.toArray(),t.v3=this.v3.toArray(),t},Ys.prototype.fromJSON=function(t){return Ns.prototype.fromJSON.call(this,t),this.v0.fromArray(t.v0),this.v1.fromArray(t.v1),this.v2.fromArray(t.v2),this.v3.fromArray(t.v3),this},Zs.prototype=Object.create(Ns.prototype),Zs.prototype.constructor=Zs,Zs.prototype.isLineCurve=!0,Zs.prototype.getPoint=function(t,e){var i=e||new Ge;return 1===t?i.copy(this.v2):(i.copy(this.v2).sub(this.v1),i.multiplyScalar(t).add(this.v1)),i},Zs.prototype.getPointAt=function(t,e){return this.getPoint(t,e)},Zs.prototype.getTangent=function(){return this.v2.clone().sub(this.v1).normalize()},Zs.prototype.copy=function(t){return Ns.prototype.copy.call(this,t),this.v1.copy(t.v1),this.v2.copy(t.v2),this},Zs.prototype.toJSON=function(){var t=Ns.prototype.toJSON.call(this);return t.v1=this.v1.toArray(),t.v2=this.v2.toArray(),t},Zs.prototype.fromJSON=function(t){return Ns.prototype.fromJSON.call(this,t),this.v1.fromArray(t.v1),this.v2.fromArray(t.v2),this},Ks.prototype=Object.create(Ns.prototype),Ks.prototype.constructor=Ks,Ks.prototype.isLineCurve3=!0,Ks.prototype.getPoint=function(t,e){var i=e||new $e;return 1===t?i.copy(this.v2):(i.copy(this.v2).sub(this.v1),i.multiplyScalar(t).add(this.v1)),i},Ks.prototype.getPointAt=function(t,e){return this.getPoint(t,e)},Ks.prototype.copy=function(t){return Ns.prototype.copy.call(this,t),this.v1.copy(t.v1),this.v2.copy(t.v2),this},Ks.prototype.toJSON=function(){var t=Ns.prototype.toJSON.call(this);return t.v1=this.v1.toArray(),t.v2=this.v2.toArray(),t},Ks.prototype.fromJSON=function(t){return Ns.prototype.fromJSON.call(this,t),this.v1.fromArray(t.v1),this.v2.fromArray(t.v2),this},Js.prototype=Object.create(Ns.prototype),Js.prototype.constructor=Js,Js.prototype.isQuadraticBezierCurve=!0,Js.prototype.getPoint=function(t,e){var i=e||new Ge,r=this.v0,n=this.v1,o=this.v2;return i.set(Ws(t,r.x,n.x,o.x),Ws(t,r.y,n.y,o.y)),i},Js.prototype.copy=function(t){return Ns.prototype.copy.call(this,t),this.v0.copy(t.v0),this.v1.copy(t.v1),this.v2.copy(t.v2),this},Js.prototype.toJSON=function(){var t=Ns.prototype.toJSON.call(this);return t.v0=this.v0.toArray(),t.v1=this.v1.toArray(),t.v2=this.v2.toArray(),t},Js.prototype.fromJSON=function(t){return Ns.prototype.fromJSON.call(this,t),this.v0.fromArray(t.v0),this.v1.fromArray(t.v1),this.v2.fromArray(t.v2),this},Qs.prototype=Object.create(Ns.prototype),Qs.prototype.constructor=Qs,Qs.prototype.isQuadraticBezierCurve3=!0,Qs.prototype.getPoint=function(t,e){var i=e||new $e,r=this.v0,n=this.v1,o=this.v2;return i.set(Ws(t,r.x,n.x,o.x),Ws(t,r.y,n.y,o.y),Ws(t,r.z,n.z,o.z)),i},Qs.prototype.copy=function(t){return Ns.prototype.copy.call(this,t),this.v0.copy(t.v0),this.v1.copy(t.v1),this.v2.copy(t.v2),this},Qs.prototype.toJSON=function(){var t=Ns.prototype.toJSON.call(this);return t.v0=this.v0.toArray(),t.v1=this.v1.toArray(),t.v2=this.v2.toArray(),t},Qs.prototype.fromJSON=function(t){return Ns.prototype.fromJSON.call(this,t),this.v0.fromArray(t.v0),this.v1.fromArray(t.v1),this.v2.fromArray(t.v2),this},tc.prototype=Object.create(Ns.prototype),tc.prototype.constructor=tc,tc.prototype.isSplineCurve=!0,tc.prototype.getPoint=function(t,e){var i=e||new Ge,r=this.points,n=(r.length-1)*t,o=Math.floor(n),a=n-o,s=r[0===o?o:o-1],c=r[o],u=r[o>r.length-2?r.length-1:o+1],h=r[o>r.length-3?r.length-1:o+2];return i.set($s(a,s.x,c.x,u.x,h.x),$s(a,s.y,c.y,u.y,h.y)),i},tc.prototype.copy=function(t){Ns.prototype.copy.call(this,t),this.points=[];for(var e=0,i=t.points.length;e<i;e++){var r=t.points[e];this.points.push(r.clone())}return this},tc.prototype.toJSON=function(){var t=Ns.prototype.toJSON.call(this);t.points=[];for(var e=0,i=this.points.length;e<i;e++){var r=this.points[e];t.points.push(r.toArray())}return t},tc.prototype.fromJSON=function(t){Ns.prototype.fromJSON.call(this,t),this.points=[];for(var e=0,i=t.points.length;e<i;e++){var r=t.points[e];this.points.push((new Ge).fromArray(r))}return this};var ec=Object.freeze({ArcCurve:Fs,CatmullRomCurve3:Hs,CubicBezierCurve:qs,CubicBezierCurve3:Ys,EllipseCurve:Bs,LineCurve:Zs,LineCurve3:Ks,QuadraticBezierCurve:Js,QuadraticBezierCurve3:Qs,SplineCurve:tc});function ic(){Ns.call(this),this.type="CurvePath",this.curves=[],this.autoClose=!1}function rc(t){ic.call(this),this.type="Path",this.currentPoint=new Ge,t&&this.setFromPoints(t)}function nc(t){rc.call(this,t),this.uuid=je.generateUUID(),this.type="Shape",this.holes=[]}function oc(t,e){qr.call(this),this.type="Light",this.color=new Gi(t),this.intensity=void 0!==e?e:1,this.receiveShadow=void 0}function ac(t,e,i){oc.call(this,t,i),this.type="HemisphereLight",this.castShadow=void 0,this.position.copy(qr.DefaultUp),this.updateMatrix(),this.groundColor=new Gi(e)}function sc(t){this.camera=t,this.bias=0,this.radius=1,this.mapSize=new Ge(512,512),this.map=null,this.matrix=new Ve}function cc(){sc.call(this,new jo(50,1,.5,500))}function uc(t,e,i,r,n,o){oc.call(this,t,e),this.type="SpotLight",this.position.copy(qr.DefaultUp),this.updateMatrix(),this.target=new qr,Object.defineProperty(this,"power",{get:function(){return this.intensity*Math.PI},set:function(t){this.intensity=t/Math.PI}}),this.distance=void 0!==i?i:0,this.angle=void 0!==r?r:Math.PI/3,this.penumbra=void 0!==n?n:0,this.decay=void 0!==o?o:1,this.shadow=new cc}function hc(t,e,i,r){oc.call(this,t,e),this.type="PointLight",Object.defineProperty(this,"power",{get:function(){return 4*this.intensity*Math.PI},set:function(t){this.intensity=t/(4*Math.PI)}}),this.distance=void 0!==i?i:0,this.decay=void 0!==r?r:1,this.shadow=new sc(new jo(90,1,.5,500))}function lc(){sc.call(this,new Zr(-5,5,5,-5,.5,500))}function pc(t,e){oc.call(this,t,e),this.type="DirectionalLight",this.position.copy(qr.DefaultUp),this.updateMatrix(),this.target=new qr,this.shadow=new lc}function dc(t,e){oc.call(this,t,e),this.type="AmbientLight",this.castShadow=void 0}function fc(t,e,i,r){oc.call(this,t,e),this.type="RectAreaLight",this.position.set(0,1,0),this.updateMatrix(),this.width=void 0!==i?i:10,this.height=void 0!==r?r:10}function mc(t,e,i,r){Pc.call(this,t,e,i,r)}function gc(t,e,i){Pc.call(this,t,e,i)}function vc(t,e,i,r){this.parameterPositions=t,this._cachedIndex=0,this.resultBuffer=void 0!==r?r:new e.constructor(i),this.sampleValues=e,this.valueSize=i}function yc(t,e,i,r){vc.call(this,t,e,i,r)}function bc(t,e,i,r){Pc.call(this,t,e,i,r)}function xc(t,e,i,r){Pc.call(this,t,e,i,r)}function _c(t,e,i,r){Pc.call(this,t,e,i,r)}function wc(t,e,i,r){vc.call(this,t,e,i,r),this._weightPrev=-0,this._offsetPrev=-0,this._weightNext=-0,this._offsetNext=-0}function Sc(t,e,i,r){vc.call(this,t,e,i,r)}function Ac(t,e,i,r){vc.call(this,t,e,i,r)}ic.prototype=Object.assign(Object.create(Ns.prototype),{constructor:ic,add:function(t){this.curves.push(t)},closePath:function(){var t=this.curves[0].getPoint(0),e=this.curves[this.curves.length-1].getPoint(1);t.equals(e)||this.curves.push(new Zs(e,t))},getPoint:function(t){for(var e=t*this.getLength(),i=this.getCurveLengths(),r=0;r<i.length;){if(i[r]>=e){var n=i[r]-e,o=this.curves[r],a=o.getLength(),s=0===a?0:1-n/a;return o.getPointAt(s)}r++}return null},getLength:function(){var t=this.getCurveLengths();return t[t.length-1]},updateArcLengths:function(){this.needsUpdate=!0,this.cacheLengths=null,this.getCurveLengths()},getCurveLengths:function(){if(this.cacheLengths&&this.cacheLengths.length===this.curves.length)return this.cacheLengths;for(var t=[],e=0,i=0,r=this.curves.length;i<r;i++)e+=this.curves[i].getLength(),t.push(e);return this.cacheLengths=t,t},getSpacedPoints:function(t){void 0===t&&(t=40);for(var e=[],i=0;i<=t;i++)e.push(this.getPoint(i/t));return this.autoClose&&e.push(e[0]),e},getPoints:function(t){t=t||12;for(var e,i=[],r=0,n=this.curves;r<n.length;r++)for(var o=n[r],a=o&&o.isEllipseCurve?2*t:o&&o.isLineCurve?1:o&&o.isSplineCurve?t*o.points.length:t,s=o.getPoints(a),c=0;c<s.length;c++){var u=s[c];e&&e.equals(u)||(i.push(u),e=u)}return this.autoClose&&i.length>1&&!i[i.length-1].equals(i[0])&&i.push(i[0]),i},copy:function(t){Ns.prototype.copy.call(this,t),this.curves=[];for(var e=0,i=t.curves.length;e<i;e++){var r=t.curves[e];this.curves.push(r.clone())}return this.autoClose=t.autoClose,this},toJSON:function(){var t=Ns.prototype.toJSON.call(this);t.autoClose=this.autoClose,t.curves=[];for(var e=0,i=this.curves.length;e<i;e++){var r=this.curves[e];t.curves.push(r.toJSON())}return t},fromJSON:function(t){Ns.prototype.fromJSON.call(this,t),this.autoClose=t.autoClose,this.curves=[];for(var e=0,i=t.curves.length;e<i;e++){var r=t.curves[e];this.curves.push((new ec[r.type]).fromJSON(r))}return this}}),rc.prototype=Object.assign(Object.create(ic.prototype),{constructor:rc,setFromPoints:function(t){this.moveTo(t[0].x,t[0].y);for(var e=1,i=t.length;e<i;e++)this.lineTo(t[e].x,t[e].y)},moveTo:function(t,e){this.currentPoint.set(t,e)},lineTo:function(t,e){var i=new Zs(this.currentPoint.clone(),new Ge(t,e));this.curves.push(i),this.currentPoint.set(t,e)},quadraticCurveTo:function(t,e,i,r){var n=new Js(this.currentPoint.clone(),new Ge(t,e),new Ge(i,r));this.curves.push(n),this.currentPoint.set(i,r)},bezierCurveTo:function(t,e,i,r,n,o){var a=new qs(this.currentPoint.clone(),new Ge(t,e),new Ge(i,r),new Ge(n,o));this.curves.push(a),this.currentPoint.set(n,o)},splineThru:function(t){var e=new tc([this.currentPoint.clone()].concat(t));this.curves.push(e),this.currentPoint.copy(t[t.length-1])},arc:function(t,e,i,r,n,o){var a=this.currentPoint.x,s=this.currentPoint.y;this.absarc(t+a,e+s,i,r,n,o)},absarc:function(t,e,i,r,n,o){this.absellipse(t,e,i,i,r,n,o)},ellipse:function(t,e,i,r,n,o,a,s){var c=this.currentPoint.x,u=this.currentPoint.y;this.absellipse(t+c,e+u,i,r,n,o,a,s)},absellipse:function(t,e,i,r,n,o,a,s){var c=new Bs(t,e,i,r,n,o,a,s);if(this.curves.length>0){var u=c.getPoint(0);u.equals(this.currentPoint)||this.lineTo(u.x,u.y)}this.curves.push(c);var h=c.getPoint(1);this.currentPoint.copy(h)},copy:function(t){return ic.prototype.copy.call(this,t),this.currentPoint.copy(t.currentPoint),this},toJSON:function(){var t=ic.prototype.toJSON.call(this);return t.currentPoint=this.currentPoint.toArray(),t},fromJSON:function(t){return ic.prototype.fromJSON.call(this,t),this.currentPoint.fromArray(t.currentPoint),this}}),nc.prototype=Object.assign(Object.create(rc.prototype),{constructor:nc,getPointsHoles:function(t){for(var e=[],i=0,r=this.holes.length;i<r;i++)e[i]=this.holes[i].getPoints(t);return e},extractPoints:function(t){return{shape:this.getPoints(t),holes:this.getPointsHoles(t)}},copy:function(t){rc.prototype.copy.call(this,t),this.holes=[];for(var e=0,i=t.holes.length;e<i;e++){var r=t.holes[e];this.holes.push(r.clone())}return this},toJSON:function(){var t=rc.prototype.toJSON.call(this);t.uuid=this.uuid,t.holes=[];for(var e=0,i=this.holes.length;e<i;e++){var r=this.holes[e];t.holes.push(r.toJSON())}return t},fromJSON:function(t){rc.prototype.fromJSON.call(this,t),this.uuid=t.uuid,this.holes=[];for(var e=0,i=t.holes.length;e<i;e++){var r=t.holes[e];this.holes.push((new rc).fromJSON(r))}return this}}),oc.prototype=Object.assign(Object.create(qr.prototype),{constructor:oc,isLight:!0,copy:function(t){return qr.prototype.copy.call(this,t),this.color.copy(t.color),this.intensity=t.intensity,this},toJSON:function(t){var e=qr.prototype.toJSON.call(this,t);return e.object.color=this.color.getHex(),e.object.intensity=this.intensity,void 0!==this.groundColor&&(e.object.groundColor=this.groundColor.getHex()),void 0!==this.distance&&(e.object.distance=this.distance),void 0!==this.angle&&(e.object.angle=this.angle),void 0!==this.decay&&(e.object.decay=this.decay),void 0!==this.penumbra&&(e.object.penumbra=this.penumbra),void 0!==this.shadow&&(e.object.shadow=this.shadow.toJSON()),e}}),ac.prototype=Object.assign(Object.create(oc.prototype),{constructor:ac,isHemisphereLight:!0,copy:function(t){return oc.prototype.copy.call(this,t),this.groundColor.copy(t.groundColor),this}}),Object.assign(sc.prototype,{copy:function(t){return this.camera=t.camera.clone(),this.bias=t.bias,this.radius=t.radius,this.mapSize.copy(t.mapSize),this},clone:function(){return(new this.constructor).copy(this)},toJSON:function(){var t={};return 0!==this.bias&&(t.bias=this.bias),1!==this.radius&&(t.radius=this.radius),512===this.mapSize.x&&512===this.mapSize.y||(t.mapSize=this.mapSize.toArray()),t.camera=this.camera.toJSON(!1).object,delete t.camera.matrix,t}}),cc.prototype=Object.assign(Object.create(sc.prototype),{constructor:cc,isSpotLightShadow:!0,update:function(t){var e=this.camera,i=2*je.RAD2DEG*t.angle,r=this.mapSize.width/this.mapSize.height,n=t.distance||e.far;i===e.fov&&r===e.aspect&&n===e.far||(e.fov=i,e.aspect=r,e.far=n,e.updateProjectionMatrix())}}),uc.prototype=Object.assign(Object.create(oc.prototype),{constructor:uc,isSpotLight:!0,copy:function(t){return oc.prototype.copy.call(this,t),this.distance=t.distance,this.angle=t.angle,this.penumbra=t.penumbra,this.decay=t.decay,this.target=t.target.clone(),this.shadow=t.shadow.clone(),this}}),hc.prototype=Object.assign(Object.create(oc.prototype),{constructor:hc,isPointLight:!0,copy:function(t){return oc.prototype.copy.call(this,t),this.distance=t.distance,this.decay=t.decay,this.shadow=t.shadow.clone(),this}}),lc.prototype=Object.assign(Object.create(sc.prototype),{constructor:lc}),pc.prototype=Object.assign(Object.create(oc.prototype),{constructor:pc,isDirectionalLight:!0,copy:function(t){return oc.prototype.copy.call(this,t),this.target=t.target.clone(),this.shadow=t.shadow.clone(),this}}),dc.prototype=Object.assign(Object.create(oc.prototype),{constructor:dc,isAmbientLight:!0}),fc.prototype=Object.assign(Object.create(oc.prototype),{constructor:fc,isRectAreaLight:!0,copy:function(t){return oc.prototype.copy.call(this,t),this.width=t.width,this.height=t.height,this},toJSON:function(t){var e=oc.prototype.toJSON.call(this,t);return e.object.width=this.width,e.object.height=this.height,e}}),mc.prototype=Object.assign(Object.create(Pc.prototype),{constructor:mc,ValueTypeName:"string",ValueBufferType:Array,DefaultInterpolation:2300,InterpolantFactoryMethodLinear:void 0,InterpolantFactoryMethodSmooth:void 0}),gc.prototype=Object.assign(Object.create(Pc.prototype),{constructor:gc,ValueTypeName:"bool",ValueBufferType:Array,DefaultInterpolation:2300,InterpolantFactoryMethodLinear:void 0,InterpolantFactoryMethodSmooth:void 0}),Object.assign(vc.prototype,{evaluate:function(t){var e=this.parameterPositions,i=this._cachedIndex,r=e[i],n=e[i-1];t:{e:{var o;i:{r:if(!(t<r)){for(var a=i+2;;){if(void 0===r){if(t<n)break r;return i=e.length,this._cachedIndex=i,this.afterEnd_(i-1,t,n)}if(i===a)break;if(n=r,t<(r=e[++i]))break e}o=e.length;break i}if(t>=n)break t;var s=e[1];t<s&&(i=2,n=s);for(a=i-2;;){if(void 0===n)return this._cachedIndex=0,this.beforeStart_(0,t,r);if(i===a)break;if(r=n,t>=(n=e[--i-1]))break e}o=i,i=0}for(;i<o;){var c=i+o>>>1;t<e[c]?o=c:i=c+1}if(r=e[i],void 0===(n=e[i-1]))return this._cachedIndex=0,this.beforeStart_(0,t,r);if(void 0===r)return i=e.length,this._cachedIndex=i,this.afterEnd_(i-1,n,t)}this._cachedIndex=i,this.intervalChanged_(i,n,r)}return this.interpolate_(i,n,t,r)},settings:null,DefaultSettings_:{},getSettings_:function(){return this.settings||this.DefaultSettings_},copySampleValue_:function(t){for(var e=this.resultBuffer,i=this.sampleValues,r=this.valueSize,n=t*r,o=0;o!==r;++o)e[o]=i[n+o];return e},interpolate_:function(){throw new Error("call to abstract method")},intervalChanged_:function(){}}),Object.assign(vc.prototype,{beforeStart_:vc.prototype.copySampleValue_,afterEnd_:vc.prototype.copySampleValue_}),yc.prototype=Object.assign(Object.create(vc.prototype),{constructor:yc,interpolate_:function(t,e,i,r){for(var n=this.resultBuffer,o=this.sampleValues,a=this.valueSize,s=t*a,c=(i-e)/(r-e),u=s+a;s!==u;s+=4)He.slerpFlat(n,0,o,s-a,o,s,c);return n}}),bc.prototype=Object.assign(Object.create(Pc.prototype),{constructor:bc,ValueTypeName:"quaternion",DefaultInterpolation:2301,InterpolantFactoryMethodLinear:function(t){return new yc(this.times,this.values,this.getValueSize(),t)},InterpolantFactoryMethodSmooth:void 0}),xc.prototype=Object.assign(Object.create(Pc.prototype),{constructor:xc,ValueTypeName:"color"}),_c.prototype=Object.assign(Object.create(Pc.prototype),{constructor:_c,ValueTypeName:"number"}),wc.prototype=Object.assign(Object.create(vc.prototype),{constructor:wc,DefaultSettings_:{endingStart:Te,endingEnd:Te},intervalChanged_:function(t,e,i){var r=this.parameterPositions,n=t-2,o=t+1,a=r[n],s=r[o];if(void 0===a)switch(this.getSettings_().endingStart){case Ee:n=t,a=2*e-i;break;case 2402:a=e+r[n=r.length-2]-r[n+1];break;default:n=t,a=i}if(void 0===s)switch(this.getSettings_().endingEnd){case Ee:o=t,s=2*i-e;break;case 2402:o=1,s=i+r[1]-r[0];break;default:o=t-1,s=e}var c=.5*(i-e),u=this.valueSize;this._weightPrev=c/(e-a),this._weightNext=c/(s-i),this._offsetPrev=n*u,this._offsetNext=o*u},interpolate_:function(t,e,i,r){for(var n=this.resultBuffer,o=this.sampleValues,a=this.valueSize,s=t*a,c=s-a,u=this._offsetPrev,h=this._offsetNext,l=this._weightPrev,p=this._weightNext,d=(i-e)/(r-e),f=d*d,m=f*d,g=-l*m+2*l*f-l*d,v=(1+l)*m+(-1.5-2*l)*f+(-.5+l)*d+1,y=(-1-p)*m+(1.5+p)*f+.5*d,b=p*m-p*f,x=0;x!==a;++x)n[x]=g*o[u+x]+v*o[c+x]+y*o[s+x]+b*o[h+x];return n}}),Sc.prototype=Object.assign(Object.create(vc.prototype),{constructor:Sc,interpolate_:function(t,e,i,r){for(var n=this.resultBuffer,o=this.sampleValues,a=this.valueSize,s=t*a,c=s-a,u=(i-e)/(r-e),h=1-u,l=0;l!==a;++l)n[l]=o[c+l]*h+o[s+l]*u;return n}}),Ac.prototype=Object.assign(Object.create(vc.prototype),{constructor:Ac,interpolate_:function(t){return this.copySampleValue_(t-1)}});var Mc={arraySlice:function(t,e,i){return Mc.isTypedArray(t)?new t.constructor(t.subarray(e,void 0!==i?i:t.length)):t.slice(e,i)},convertArray:function(t,e,i){return!t||!i&&t.constructor===e?t:"number"==typeof e.BYTES_PER_ELEMENT?new e(t):Array.prototype.slice.call(t)},isTypedArray:function(t){return ArrayBuffer.isView(t)&&!(t instanceof DataView)},getKeyframeOrder:function(t){for(var e=t.length,i=new Array(e),r=0;r!==e;++r)i[r]=r;return i.sort(function(e,i){return t[e]-t[i]}),i},sortedArray:function(t,e,i){for(var r=t.length,n=new t.constructor(r),o=0,a=0;a!==r;++o)for(var s=i[o]*e,c=0;c!==e;++c)n[a++]=t[s+c];return n},flattenJSON:function(t,e,i,r){for(var n=1,o=t[0];void 0!==o&&void 0===o[r];)o=t[n++];if(void 0!==o){var a=o[r];if(void 0!==a)if(Array.isArray(a))do{void 0!==(a=o[r])&&(e.push(o.time),i.push.apply(i,a)),o=t[n++]}while(void 0!==o);else if(void 0!==a.toArray)do{void 0!==(a=o[r])&&(e.push(o.time),a.toArray(i,i.length)),o=t[n++]}while(void 0!==o);else do{void 0!==(a=o[r])&&(e.push(o.time),i.push(a)),o=t[n++]}while(void 0!==o)}}};function Pc(t,e,i,r){if(void 0===t)throw new Error("THREE.KeyframeTrack: track name is undefined");if(void 0===e||0===e.length)throw new Error("THREE.KeyframeTrack: no keyframes in track named "+t);this.name=t,this.times=Mc.convertArray(e,this.TimeBufferType),this.values=Mc.convertArray(i,this.ValueBufferType),this.setInterpolation(r||this.DefaultInterpolation),this.validate(),this.optimize()}function Tc(t,e,i,r){Pc.call(this,t,e,i,r)}function Ec(t,e,i){this.name=t,this.tracks=i,this.duration=void 0!==e?e:-1,this.uuid=je.generateUUID(),this.duration<0&&this.resetDuration(),this.optimize()}function Cc(t){this.manager=void 0!==t?t:Rs,this.textures={}}function Ic(t){this.manager=void 0!==t?t:Rs}Object.assign(Pc,{parse:function(t){if(void 0===t.type)throw new Error("THREE.KeyframeTrack: track type undefined, can not parse");var e=Pc._getTrackTypeForValueTypeName(t.type);if(void 0===t.times){var i=[],r=[];Mc.flattenJSON(t.keys,i,r,"value"),t.times=i,t.values=r}return void 0!==e.parse?e.parse(t):new e(t.name,t.times,t.values,t.interpolation)},toJSON:function(t){var e,i=t.constructor;if(void 0!==i.toJSON)e=i.toJSON(t);else{e={name:t.name,times:Mc.convertArray(t.times,Array),values:Mc.convertArray(t.values,Array)};var r=t.getInterpolation();r!==t.DefaultInterpolation&&(e.interpolation=r)}return e.type=t.ValueTypeName,e},_getTrackTypeForValueTypeName:function(t){switch(t.toLowerCase()){case"scalar":case"double":case"float":case"number":case"integer":return _c;case"vector":case"vector2":case"vector3":case"vector4":return Tc;case"color":return xc;case"quaternion":return bc;case"bool":case"boolean":return gc;case"string":return mc}throw new Error("THREE.KeyframeTrack: Unsupported typeName: "+t)}}),Object.assign(Pc.prototype,{constructor:Pc,TimeBufferType:Float32Array,ValueBufferType:Float32Array,DefaultInterpolation:2301,InterpolantFactoryMethodDiscrete:function(t){return new Ac(this.times,this.values,this.getValueSize(),t)},InterpolantFactoryMethodLinear:function(t){return new Sc(this.times,this.values,this.getValueSize(),t)},InterpolantFactoryMethodSmooth:function(t){return new wc(this.times,this.values,this.getValueSize(),t)},setInterpolation:function(t){var e;switch(t){case 2300:e=this.InterpolantFactoryMethodDiscrete;break;case 2301:e=this.InterpolantFactoryMethodLinear;break;case 2302:e=this.InterpolantFactoryMethodSmooth}if(void 0!==e)this.createInterpolant=e;else{var i="unsupported interpolation for "+this.ValueTypeName+" keyframe track named "+this.name;if(void 0===this.createInterpolant){if(t===this.DefaultInterpolation)throw new Error(i);this.setInterpolation(this.DefaultInterpolation)}console.warn("THREE.KeyframeTrack:",i)}},getInterpolation:function(){switch(this.createInterpolant){case this.InterpolantFactoryMethodDiscrete:return 2300;case this.InterpolantFactoryMethodLinear:return 2301;case this.InterpolantFactoryMethodSmooth:return 2302}},getValueSize:function(){return this.values.length/this.times.length},shift:function(t){if(0!==t)for(var e=this.times,i=0,r=e.length;i!==r;++i)e[i]+=t;return this},scale:function(t){if(1!==t)for(var e=this.times,i=0,r=e.length;i!==r;++i)e[i]*=t;return this},trim:function(t,e){for(var i=this.times,r=i.length,n=0,o=r-1;n!==r&&i[n]<t;)++n;for(;-1!==o&&i[o]>e;)--o;if(++o,0!==n||o!==r){n>=o&&(n=(o=Math.max(o,1))-1);var a=this.getValueSize();this.times=Mc.arraySlice(i,n,o),this.values=Mc.arraySlice(this.values,n*a,o*a)}return this},validate:function(){var t=!0,e=this.getValueSize();e-Math.floor(e)!=0&&(console.error("THREE.KeyframeTrack: Invalid value size in track.",this),t=!1);var i=this.times,r=this.values,n=i.length;0===n&&(console.error("THREE.KeyframeTrack: Track is empty.",this),t=!1);for(var o=null,a=0;a!==n;a++){var s=i[a];if("number"==typeof s&&isNaN(s)){console.error("THREE.KeyframeTrack: Time is not a valid number.",this,a,s),t=!1;break}if(null!==o&&o>s){console.error("THREE.KeyframeTrack: Out of order keys.",this,a,s,o),t=!1;break}o=s}if(void 0!==r&&Mc.isTypedArray(r)){a=0;for(var c=r.length;a!==c;++a){var u=r[a];if(isNaN(u)){console.error("THREE.KeyframeTrack: Value is not a valid number.",this,a,u),t=!1;break}}}return t},optimize:function(){for(var t=this.times,e=this.values,i=this.getValueSize(),r=2302===this.getInterpolation(),n=1,o=t.length-1,a=1;a<o;++a){var s=!1,c=t[a];if(c!==t[a+1]&&(1!==a||c!==c[0]))if(r)s=!0;else for(var u=a*i,h=u-i,l=u+i,p=0;p!==i;++p){var d=e[u+p];if(d!==e[h+p]||d!==e[l+p]){s=!0;break}}if(s){if(a!==n){t[n]=t[a];var f=a*i,m=n*i;for(p=0;p!==i;++p)e[m+p]=e[f+p]}++n}}if(o>0){t[n]=t[o];for(f=o*i,m=n*i,p=0;p!==i;++p)e[m+p]=e[f+p];++n}return n!==t.length&&(this.times=Mc.arraySlice(t,0,n),this.values=Mc.arraySlice(e,0,n*i)),this}}),Tc.prototype=Object.assign(Object.create(Pc.prototype),{constructor:Tc,ValueTypeName:"vector"}),Object.assign(Ec,{parse:function(t){for(var e=[],i=t.tracks,r=1/(t.fps||1),n=0,o=i.length;n!==o;++n)e.push(Pc.parse(i[n]).scale(r));return new Ec(t.name,t.duration,e)},toJSON:function(t){for(var e=[],i=t.tracks,r={name:t.name,duration:t.duration,tracks:e},n=0,o=i.length;n!==o;++n)e.push(Pc.toJSON(i[n]));return r},CreateFromMorphTargetSequence:function(t,e,i,r){for(var n=e.length,o=[],a=0;a<n;a++){var s=[],c=[];s.push((a+n-1)%n,a,(a+1)%n),c.push(0,1,0);var u=Mc.getKeyframeOrder(s);s=Mc.sortedArray(s,1,u),c=Mc.sortedArray(c,1,u),r||0!==s[0]||(s.push(n),c.push(c[0])),o.push(new _c(".morphTargetInfluences["+e[a].name+"]",s,c).scale(1/i))}return new Ec(t,-1,o)},findByName:function(t,e){var i=t;if(!Array.isArray(t)){var r=t;i=r.geometry&&r.geometry.animations||r.animations}for(var n=0;n<i.length;n++)if(i[n].name===e)return i[n];return null},CreateClipsFromMorphTargetSequences:function(t,e,i){for(var r={},n=/^([\w-]*?)([\d]+)$/,o=0,a=t.length;o<a;o++){var s=t[o],c=s.name.match(n);if(c&&c.length>1){var u=r[l=c[1]];u||(r[l]=u=[]),u.push(s)}}var h=[];for(var l in r)h.push(Ec.CreateFromMorphTargetSequence(l,r[l],e,i));return h},parseAnimation:function(t,e){if(!t)return console.error("THREE.AnimationClip: No animation in JSONLoader data."),null;for(var i=function(t,e,i,r,n){if(0!==i.length){var o=[],a=[];Mc.flattenJSON(i,o,a,r),0!==o.length&&n.push(new t(e,o,a))}},r=[],n=t.name||"default",o=t.length||-1,a=t.fps||30,s=t.hierarchy||[],c=0;c<s.length;c++){var u=s[c].keys;if(u&&0!==u.length)if(u[0].morphTargets){for(var h={},l=0;l<u.length;l++)if(u[l].morphTargets)for(var p=0;p<u[l].morphTargets.length;p++)h[u[l].morphTargets[p]]=-1;for(var d in h){var f=[],m=[];for(p=0;p!==u[l].morphTargets.length;++p){var g=u[l];f.push(g.time),m.push(g.morphTarget===d?1:0)}r.push(new _c(".morphTargetInfluence["+d+"]",f,m))}o=h.length*(a||1)}else{var v=".bones["+e[c].name+"]";i(Tc,v+".position",u,"pos",r),i(bc,v+".quaternion",u,"rot",r),i(Tc,v+".scale",u,"scl",r)}}return 0===r.length?null:new Ec(n,o,r)}}),Object.assign(Ec.prototype,{resetDuration:function(){for(var t=0,e=0,i=this.tracks.length;e!==i;++e){var r=this.tracks[e];t=Math.max(t,r.times[r.times.length-1])}this.duration=t},trim:function(){for(var t=0;t<this.tracks.length;t++)this.tracks[t].trim(0,this.duration);return this},optimize:function(){for(var t=0;t<this.tracks.length;t++)this.tracks[t].optimize();return this}}),Object.assign(Cc.prototype,{load:function(t,e,i,r){var n=this;new Os(n.manager).load(t,function(t){e(n.parse(JSON.parse(t)))},i,r)},setTextures:function(t){this.textures=t},parse:function(t){var e=this.textures;function i(t){return void 0===e[t]&&console.warn("THREE.MaterialLoader: Undefined texture",t),e[t]}var r=new Es[t.type];if(void 0!==t.uuid&&(r.uuid=t.uuid),void 0!==t.name&&(r.name=t.name),void 0!==t.color&&r.color.setHex(t.color),void 0!==t.roughness&&(r.roughness=t.roughness),void 0!==t.metalness&&(r.metalness=t.metalness),void 0!==t.emissive&&r.emissive.setHex(t.emissive),void 0!==t.specular&&r.specular.setHex(t.specular),void 0!==t.shininess&&(r.shininess=t.shininess),void 0!==t.clearCoat&&(r.clearCoat=t.clearCoat),void 0!==t.clearCoatRoughness&&(r.clearCoatRoughness=t.clearCoatRoughness),void 0!==t.uniforms&&(r.uniforms=t.uniforms),void 0!==t.vertexShader&&(r.vertexShader=t.vertexShader),void 0!==t.fragmentShader&&(r.fragmentShader=t.fragmentShader),void 0!==t.vertexColors&&(r.vertexColors=t.vertexColors),void 0!==t.fog&&(r.fog=t.fog),void 0!==t.flatShading&&(r.flatShading=t.flatShading),void 0!==t.blending&&(r.blending=t.blending),void 0!==t.side&&(r.side=t.side),void 0!==t.opacity&&(r.opacity=t.opacity),void 0!==t.transparent&&(r.transparent=t.transparent),void 0!==t.alphaTest&&(r.alphaTest=t.alphaTest),void 0!==t.depthTest&&(r.depthTest=t.depthTest),void 0!==t.depthWrite&&(r.depthWrite=t.depthWrite),void 0!==t.colorWrite&&(r.colorWrite=t.colorWrite),void 0!==t.wireframe&&(r.wireframe=t.wireframe),void 0!==t.wireframeLinewidth&&(r.wireframeLinewidth=t.wireframeLinewidth),void 0!==t.wireframeLinecap&&(r.wireframeLinecap=t.wireframeLinecap),void 0!==t.wireframeLinejoin&&(r.wireframeLinejoin=t.wireframeLinejoin),void 0!==t.rotation&&(r.rotation=t.rotation),1!==t.linewidth&&(r.linewidth=t.linewidth),void 0!==t.dashSize&&(r.dashSize=t.dashSize),void 0!==t.gapSize&&(r.gapSize=t.gapSize),void 0!==t.scale&&(r.scale=t.scale),void 0!==t.skinning&&(r.skinning=t.skinning),void 0!==t.morphTargets&&(r.morphTargets=t.morphTargets),void 0!==t.dithering&&(r.dithering=t.dithering),void 0!==t.visible&&(r.visible=t.visible),void 0!==t.userData&&(r.userData=t.userData),void 0!==t.shading&&(r.flatShading=1===t.shading),void 0!==t.size&&(r.size=t.size),void 0!==t.sizeAttenuation&&(r.sizeAttenuation=t.sizeAttenuation),void 0!==t.map&&(r.map=i(t.map)),void 0!==t.alphaMap&&(r.alphaMap=i(t.alphaMap),r.transparent=!0),void 0!==t.bumpMap&&(r.bumpMap=i(t.bumpMap)),void 0!==t.bumpScale&&(r.bumpScale=t.bumpScale),void 0!==t.normalMap&&(r.normalMap=i(t.normalMap)),void 0!==t.normalScale){var n=t.normalScale;!1===Array.isArray(n)&&(n=[n,n]),r.normalScale=(new Ge).fromArray(n)}return void 0!==t.displacementMap&&(r.displacementMap=i(t.displacementMap)),void 0!==t.displacementScale&&(r.displacementScale=t.displacementScale),void 0!==t.displacementBias&&(r.displacementBias=t.displacementBias),void 0!==t.roughnessMap&&(r.roughnessMap=i(t.roughnessMap)),void 0!==t.metalnessMap&&(r.metalnessMap=i(t.metalnessMap)),void 0!==t.emissiveMap&&(r.emissiveMap=i(t.emissiveMap)),void 0!==t.emissiveIntensity&&(r.emissiveIntensity=t.emissiveIntensity),void 0!==t.specularMap&&(r.specularMap=i(t.specularMap)),void 0!==t.envMap&&(r.envMap=i(t.envMap)),void 0!==t.reflectivity&&(r.reflectivity=t.reflectivity),void 0!==t.lightMap&&(r.lightMap=i(t.lightMap)),void 0!==t.lightMapIntensity&&(r.lightMapIntensity=t.lightMapIntensity),void 0!==t.aoMap&&(r.aoMap=i(t.aoMap)),void 0!==t.aoMapIntensity&&(r.aoMapIntensity=t.aoMapIntensity),void 0!==t.gradientMap&&(r.gradientMap=i(t.gradientMap)),r}}),Object.assign(Ic.prototype,{load:function(t,e,i,r){var n=this;new Os(n.manager).load(t,function(t){e(n.parse(JSON.parse(t)))},i,r)},parse:function(t){var e=new Qn,i=t.data.index;if(void 0!==i){var r=new kc[i.type](i.array);e.setIndex(new sn(r,1))}var n=t.data.attributes;for(var o in n){var a=n[o];r=new kc[a.type](a.array);e.addAttribute(o,new sn(r,a.itemSize,a.normalized))}var s=t.data.groups||t.data.drawcalls||t.data.offsets;if(void 0!==s)for(var c=0,u=s.length;c!==u;++c){var h=s[c];e.addGroup(h.start,h.count,h.materialIndex)}var l=t.data.boundingSphere;if(void 0!==l){var p=new $e;void 0!==l.center&&p.fromArray(l.center),e.boundingSphere=new _r(p,l.radius)}return e}});var Rc,Lc,Oc,Dc,kc={Int8Array:Int8Array,Uint8Array:Uint8Array,Uint8ClampedArray:"undefined"!=typeof Uint8ClampedArray?Uint8ClampedArray:Uint8Array,Int16Array:Int16Array,Uint16Array:Uint16Array,Int32Array:Int32Array,Uint32Array:Uint32Array,Float32Array:Float32Array,Float64Array:Float64Array};function Nc(){this.onLoadStart=function(){},this.onLoadProgress=function(){},this.onLoadComplete=function(){}}Nc.Handlers={handlers:[],add:function(t,e){this.handlers.push(t,e)},get:function(t){for(var e=this.handlers,i=0,r=e.length;i<r;i+=2){var n=e[i],o=e[i+1];if(n.test(t))return o}return null}},Object.assign(Nc.prototype,{crossOrigin:void 0,initMaterials:function(t,e,i){for(var r=[],n=0;n<t.length;++n)r[n]=this.createMaterial(t[n],e,i);return r},createMaterial:(Rc={NoBlending:K,NormalBlending:J,AdditiveBlending:Q,SubtractiveBlending:tt,MultiplyBlending:et,CustomBlending:it},Lc=new Gi,Oc=new ks,Dc=new Cc,function(t,e,i){var r={};function n(t,n,o,a,s){var c,u=e+t,h=Nc.Handlers.get(u);null!==h?c=h.load(u):(Oc.setCrossOrigin(i),c=Oc.load(u)),void 0!==n&&(c.repeat.fromArray(n),1!==n[0]&&(c.wrapS=Gt),1!==n[1]&&(c.wrapT=Gt)),void 0!==o&&c.offset.fromArray(o),void 0!==a&&("repeat"===a[0]&&(c.wrapS=Gt),"mirror"===a[0]&&(c.wrapS=Ht),"repeat"===a[1]&&(c.wrapT=Gt),"mirror"===a[1]&&(c.wrapT=Ht)),void 0!==s&&(c.anisotropy=s);var l=je.generateUUID();return r[l]=c,l}var o={uuid:je.generateUUID(),type:"MeshLambertMaterial"};for(var a in t){var s=t[a];switch(a){case"DbgColor":case"DbgIndex":case"opticalDensity":case"illumination":break;case"DbgName":o.name=s;break;case"blending":o.blending=Rc[s];break;case"colorAmbient":case"mapAmbient":console.warn("THREE.Loader.createMaterial:",a,"is no longer supported.");break;case"colorDiffuse":o.color=Lc.fromArray(s).getHex();break;case"colorSpecular":o.specular=Lc.fromArray(s).getHex();break;case"colorEmissive":o.emissive=Lc.fromArray(s).getHex();break;case"specularCoef":o.shininess=s;break;case"shading":"basic"===s.toLowerCase()&&(o.type="MeshBasicMaterial"),"phong"===s.toLowerCase()&&(o.type="MeshPhongMaterial"),"standard"===s.toLowerCase()&&(o.type="MeshStandardMaterial");break;case"mapDiffuse":o.map=n(s,t.mapDiffuseRepeat,t.mapDiffuseOffset,t.mapDiffuseWrap,t.mapDiffuseAnisotropy);break;case"mapDiffuseRepeat":case"mapDiffuseOffset":case"mapDiffuseWrap":case"mapDiffuseAnisotropy":break;case"mapEmissive":o.emissiveMap=n(s,t.mapEmissiveRepeat,t.mapEmissiveOffset,t.mapEmissiveWrap,t.mapEmissiveAnisotropy);break;case"mapEmissiveRepeat":case"mapEmissiveOffset":case"mapEmissiveWrap":case"mapEmissiveAnisotropy":break;case"mapLight":o.lightMap=n(s,t.mapLightRepeat,t.mapLightOffset,t.mapLightWrap,t.mapLightAnisotropy);break;case"mapLightRepeat":case"mapLightOffset":case"mapLightWrap":case"mapLightAnisotropy":break;case"mapAO":o.aoMap=n(s,t.mapAORepeat,t.mapAOOffset,t.mapAOWrap,t.mapAOAnisotropy);break;case"mapAORepeat":case"mapAOOffset":case"mapAOWrap":case"mapAOAnisotropy":break;case"mapBump":o.bumpMap=n(s,t.mapBumpRepeat,t.mapBumpOffset,t.mapBumpWrap,t.mapBumpAnisotropy);break;case"mapBumpScale":o.bumpScale=s;break;case"mapBumpRepeat":case"mapBumpOffset":case"mapBumpWrap":case"mapBumpAnisotropy":break;case"mapNormal":o.normalMap=n(s,t.mapNormalRepeat,t.mapNormalOffset,t.mapNormalWrap,t.mapNormalAnisotropy);break;case"mapNormalFactor":o.normalScale=[s,s];break;case"mapNormalRepeat":case"mapNormalOffset":case"mapNormalWrap":case"mapNormalAnisotropy":break;case"mapSpecular":o.specularMap=n(s,t.mapSpecularRepeat,t.mapSpecularOffset,t.mapSpecularWrap,t.mapSpecularAnisotropy);break;case"mapSpecularRepeat":case"mapSpecularOffset":case"mapSpecularWrap":case"mapSpecularAnisotropy":break;case"mapMetalness":o.metalnessMap=n(s,t.mapMetalnessRepeat,t.mapMetalnessOffset,t.mapMetalnessWrap,t.mapMetalnessAnisotropy);break;case"mapMetalnessRepeat":case"mapMetalnessOffset":case"mapMetalnessWrap":case"mapMetalnessAnisotropy":break;case"mapRoughness":o.roughnessMap=n(s,t.mapRoughnessRepeat,t.mapRoughnessOffset,t.mapRoughnessWrap,t.mapRoughnessAnisotropy);break;case"mapRoughnessRepeat":case"mapRoughnessOffset":case"mapRoughnessWrap":case"mapRoughnessAnisotropy":break;case"mapAlpha":o.alphaMap=n(s,t.mapAlphaRepeat,t.mapAlphaOffset,t.mapAlphaWrap,t.mapAlphaAnisotropy);break;case"mapAlphaRepeat":case"mapAlphaOffset":case"mapAlphaWrap":case"mapAlphaAnisotropy":break;case"flipSided":o.side=W;break;case"doubleSided":o.side=X;break;case"transparency":console.warn("THREE.Loader.createMaterial: transparency has been renamed to opacity"),o.opacity=s;break;case"depthTest":case"depthWrite":case"colorWrite":case"opacity":case"reflectivity":case"transparent":case"visible":case"wireframe":o[a]=s;break;case"vertexColors":!0===s&&(o.vertexColors=Z),"face"===s&&(o.vertexColors=Y);break;default:console.error("THREE.Loader.createMaterial: Unsupported",a,s)}}return"MeshBasicMaterial"===o.type&&delete o.emissive,"MeshPhongMaterial"!==o.type&&delete o.specular,o.opacity<1&&(o.transparent=!0),Dc.setTextures(r),Dc.parse(o)})});var Bc,Fc=function(t){var e=t.split("/");return 1===e.length?"./":(e.pop(),e.join("/")+"/")};function zc(t){"boolean"==typeof t&&(console.warn("THREE.JSONLoader: showStatus parameter has been removed from constructor."),t=void 0),this.manager=void 0!==t?t:Rs,this.withCredentials=!1}Object.assign(zc.prototype,{load:function(t,e,i,r){var n=this,o=this.texturePath&&"string"==typeof this.texturePath?this.texturePath:Fc(t),a=new Os(this.manager);a.setWithCredentials(this.withCredentials),a.load(t,function(i){var r=JSON.parse(i),a=r.metadata;if(void 0!==a){var s=a.type;if(void 0!==s){if("object"===s.toLowerCase())return void console.error("THREE.JSONLoader: "+t+" should be loaded with THREE.ObjectLoader instead.");if("scene"===s.toLowerCase())return void console.error("THREE.JSONLoader: "+t+" should be loaded with THREE.SceneLoader instead.")}}var c=n.parse(r,o);e(c.geometry,c.materials)},i,r)},setTexturePath:function(t){this.texturePath=t},parse:function(){return function(t,e){void 0!==t.data&&(t=t.data),void 0!==t.scale?t.scale=1/t.scale:t.scale=1;var i=new an;return function(t,e){function i(t,e){return t&1<<e}var r,n,o,a,s,c,u,h,l,p,d,f,m,g,v,y,b,x,_,w,S,A,M,P,T,E=t.faces,C=t.vertices,I=t.normals,R=t.colors,L=t.scale,O=0;if(void 0!==t.uvs){for(r=0;r<t.uvs.length;r++)t.uvs[r].length&&O++;for(r=0;r<O;r++)e.faceVertexUvs[r]=[]}for(a=0,s=C.length;a<s;)(x=new $e).x=C[a++]*L,x.y=C[a++]*L,x.z=C[a++]*L,e.vertices.push(x);for(a=0,s=E.length;a<s;)if(d=i(p=E[a++],0),f=i(p,1),m=i(p,3),g=i(p,4),v=i(p,5),y=i(p,6),b=i(p,7),d){if((w=new Kr).a=E[a],w.b=E[a+1],w.c=E[a+3],(S=new Kr).a=E[a+1],S.b=E[a+2],S.c=E[a+3],a+=4,f&&(l=E[a++],w.materialIndex=l,S.materialIndex=l),o=e.faces.length,m)for(r=0;r<O;r++)for(P=t.uvs[r],e.faceVertexUvs[r][o]=[],e.faceVertexUvs[r][o+1]=[],n=0;n<4;n++)T=new Ge(P[2*(h=E[a++])],P[2*h+1]),2!==n&&e.faceVertexUvs[r][o].push(T),0!==n&&e.faceVertexUvs[r][o+1].push(T);if(g&&(u=3*E[a++],w.normal.set(I[u++],I[u++],I[u]),S.normal.copy(w.normal)),v)for(r=0;r<4;r++)u=3*E[a++],M=new $e(I[u++],I[u++],I[u]),2!==r&&w.vertexNormals.push(M),0!==r&&S.vertexNormals.push(M);if(y&&(A=R[c=E[a++]],w.color.setHex(A),S.color.setHex(A)),b)for(r=0;r<4;r++)A=R[c=E[a++]],2!==r&&w.vertexColors.push(new Gi(A)),0!==r&&S.vertexColors.push(new Gi(A));e.faces.push(w),e.faces.push(S)}else{if((_=new Kr).a=E[a++],_.b=E[a++],_.c=E[a++],f&&(l=E[a++],_.materialIndex=l),o=e.faces.length,m)for(r=0;r<O;r++)for(P=t.uvs[r],e.faceVertexUvs[r][o]=[],n=0;n<3;n++)T=new Ge(P[2*(h=E[a++])],P[2*h+1]),e.faceVertexUvs[r][o].push(T);if(g&&(u=3*E[a++],_.normal.set(I[u++],I[u++],I[u])),v)for(r=0;r<3;r++)u=3*E[a++],M=new $e(I[u++],I[u++],I[u]),_.vertexNormals.push(M);if(y&&(c=E[a++],_.color.setHex(R[c])),b)for(r=0;r<3;r++)c=E[a++],_.vertexColors.push(new Gi(R[c]));e.faces.push(_)}}(t,i),function(t,e){var i=void 0!==t.influencesPerVertex?t.influencesPerVertex:2;if(t.skinWeights)for(var r=0,n=t.skinWeights.length;r<n;r+=i){var o=t.skinWeights[r],a=i>1?t.skinWeights[r+1]:0,s=i>2?t.skinWeights[r+2]:0,c=i>3?t.skinWeights[r+3]:0;e.skinWeights.push(new Ke(o,a,s,c))}if(t.skinIndices)for(r=0,n=t.skinIndices.length;r<n;r+=i){var u=t.skinIndices[r],h=i>1?t.skinIndices[r+1]:0,l=i>2?t.skinIndices[r+2]:0,p=i>3?t.skinIndices[r+3]:0;e.skinIndices.push(new Ke(u,h,l,p))}e.bones=t.bones,e.bones&&e.bones.length>0&&(e.skinWeights.length!==e.skinIndices.length||e.skinIndices.length!==e.vertices.length)&&console.warn("When skinning, number of vertices ("+e.vertices.length+"), skinIndices ("+e.skinIndices.length+"), and skinWeights ("+e.skinWeights.length+") should match.")}(t,i),function(t,e){var i=t.scale;if(void 0!==t.morphTargets)for(var r=0,n=t.morphTargets.length;r<n;r++){e.morphTargets[r]={},e.morphTargets[r].name=t.morphTargets[r].name,e.morphTargets[r].vertices=[];for(var o=e.morphTargets[r].vertices,a=t.morphTargets[r].vertices,s=0,c=a.length;s<c;s+=3){var u=new $e;u.x=a[s]*i,u.y=a[s+1]*i,u.z=a[s+2]*i,o.push(u)}}if(void 0!==t.morphColors&&t.morphColors.length>0){console.warn('THREE.JSONLoader: "morphColors" no longer supported. Using them as face colors.');var h=e.faces,l=t.morphColors[0].colors;for(r=0,n=h.length;r<n;r++)h[r].color.fromArray(l,3*r)}}(t,i),function(t,e){var i=[],r=[];void 0!==t.animation&&r.push(t.animation),void 0!==t.animations&&(t.animations.length?r=r.concat(t.animations):r.push(t.animations));for(var n=0;n<r.length;n++){var o=Ec.parseAnimation(r[n],e.bones);o&&i.push(o)}if(e.morphTargets){var a=Ec.CreateClipsFromMorphTargetSequences(e.morphTargets,10);i=i.concat(a)}i.length>0&&(e.animations=i)}(t,i),i.computeFaceNormals(),i.computeBoundingSphere(),void 0===t.materials||0===t.materials.length?{geometry:i}:{geometry:i,materials:Nc.prototype.initMaterials(t.materials,e,this.crossOrigin)}}}()}),Object.assign(function(t){this.manager=void 0!==t?t:Rs,this.texturePath=""}.prototype,{load:function(t,e,i,r){""===this.texturePath&&(this.texturePath=t.substring(0,t.lastIndexOf("/")+1));var n=this;new Os(n.manager).load(t,function(i){var o=null;try{o=JSON.parse(i)}catch(e){return void 0!==r&&r(e),void console.error("THREE:ObjectLoader: Can't parse "+t+".",e.message)}var a=o.metadata;void 0!==a&&void 0!==a.type&&"geometry"!==a.type.toLowerCase()?n.parse(o,e):console.error("THREE.ObjectLoader: Can't load "+t+". Use THREE.JSONLoader instead.")},i,r)},setTexturePath:function(t){this.texturePath=t},setCrossOrigin:function(t){this.crossOrigin=t},parse:function(t,e){var i=this.parseShape(t.shapes),r=this.parseGeometries(t.geometries,i),n=this.parseImages(t.images,function(){void 0!==e&&e(s)}),o=this.parseTextures(t.textures,n),a=this.parseMaterials(t.materials,o),s=this.parseObject(t.object,r,a);return t.animations&&(s.animations=this.parseAnimations(t.animations)),void 0!==t.images&&0!==t.images.length||void 0!==e&&e(s),s},parseShape:function(t){var e={};if(void 0!==t)for(var i=0,r=t.length;i<r;i++){var n=(new nc).fromJSON(t[i]);e[n.uuid]=n}return e},parseGeometries:function(t,e){var i={};if(void 0!==t)for(var r=new zc,n=new Ic,o=0,a=t.length;o<a;o++){var s,c=t[o];switch(c.type){case"PlaneGeometry":case"PlaneBufferGeometry":s=new ys[c.type](c.width,c.height,c.widthSegments,c.heightSegments);break;case"BoxGeometry":case"BoxBufferGeometry":case"CubeGeometry":s=new ys[c.type](c.width,c.height,c.depth,c.widthSegments,c.heightSegments,c.depthSegments);break;case"CircleGeometry":case"CircleBufferGeometry":s=new ys[c.type](c.radius,c.segments,c.thetaStart,c.thetaLength);break;case"CylinderGeometry":case"CylinderBufferGeometry":s=new ys[c.type](c.radiusTop,c.radiusBottom,c.height,c.radialSegments,c.heightSegments,c.openEnded,c.thetaStart,c.thetaLength);break;case"ConeGeometry":case"ConeBufferGeometry":s=new ys[c.type](c.radius,c.height,c.radialSegments,c.heightSegments,c.openEnded,c.thetaStart,c.thetaLength);break;case"SphereGeometry":case"SphereBufferGeometry":s=new ys[c.type](c.radius,c.widthSegments,c.heightSegments,c.phiStart,c.phiLength,c.thetaStart,c.thetaLength);break;case"DodecahedronGeometry":case"DodecahedronBufferGeometry":case"IcosahedronGeometry":case"IcosahedronBufferGeometry":case"OctahedronGeometry":case"OctahedronBufferGeometry":case"TetrahedronGeometry":case"TetrahedronBufferGeometry":s=new ys[c.type](c.radius,c.detail);break;case"RingGeometry":case"RingBufferGeometry":s=new ys[c.type](c.innerRadius,c.outerRadius,c.thetaSegments,c.phiSegments,c.thetaStart,c.thetaLength);break;case"TorusGeometry":case"TorusBufferGeometry":s=new ys[c.type](c.radius,c.tube,c.radialSegments,c.tubularSegments,c.arc);break;case"TorusKnotGeometry":case"TorusKnotBufferGeometry":s=new ys[c.type](c.radius,c.tube,c.tubularSegments,c.radialSegments,c.p,c.q);break;case"LatheGeometry":case"LatheBufferGeometry":s=new ys[c.type](c.points,c.segments,c.phiStart,c.phiLength);break;case"PolyhedronGeometry":case"PolyhedronBufferGeometry":s=new ys[c.type](c.vertices,c.indices,c.radius,c.details);break;case"ShapeGeometry":case"ShapeBufferGeometry":var u=[];for(o=0,a=c.shapes.length;o<a;o++){var h=e[c.shapes[o]];u.push(h)}s=new ys[c.type](u,c.curveSegments);break;case"BufferGeometry":s=n.parse(c);break;case"Geometry":s=r.parse(c,this.texturePath).geometry;break;default:console.warn('THREE.ObjectLoader: Unsupported geometry type "'+c.type+'"');continue}s.uuid=c.uuid,void 0!==c.name&&(s.name=c.name),i[c.uuid]=s}return i},parseMaterials:function(t,e){var i={};if(void 0!==t){var r=new Cc;r.setTextures(e);for(var n=0,o=t.length;n<o;n++){var a=t[n];if("MultiMaterial"===a.type){for(var s=[],c=0;c<a.materials.length;c++)s.push(r.parse(a.materials[c]));i[a.uuid]=s}else i[a.uuid]=r.parse(a)}}return i},parseAnimations:function(t){for(var e=[],i=0;i<t.length;i++){var r=Ec.parse(t[i]);e.push(r)}return e},parseImages:function(t,e){var i=this,r={};function n(t){return i.manager.itemStart(t),o.load(t,function(){i.manager.itemEnd(t)},void 0,function(){i.manager.itemEnd(t),i.manager.itemError(t)})}if(void 0!==t&&t.length>0){var o=new Ds(new Is(e));o.setCrossOrigin(this.crossOrigin);for(var a=0,s=t.length;a<s;a++){var c=t[a],u=/^(\/\/)|([a-z]+:(\/\/)?)/i.test(c.url)?c.url:i.texturePath+c.url;r[c.uuid]=n(u)}}return r},parseTextures:function(t,e){function i(t,e){return"number"==typeof t?t:(console.warn("THREE.ObjectLoader.parseTexture: Constant should be in numeric form.",t),e[t])}var r={};if(void 0!==t)for(var n=0,o=t.length;n<o;n++){var a=t[n];void 0===a.image&&console.warn('THREE.ObjectLoader: No "image" specified for',a.uuid),void 0===e[a.image]&&console.warn("THREE.ObjectLoader: Undefined image",a.image);var s=new Ze(e[a.image]);s.needsUpdate=!0,s.uuid=a.uuid,void 0!==a.name&&(s.name=a.name),void 0!==a.mapping&&(s.mapping=i(a.mapping,jc)),void 0!==a.offset&&s.offset.fromArray(a.offset),void 0!==a.repeat&&s.repeat.fromArray(a.repeat),void 0!==a.center&&s.center.fromArray(a.center),void 0!==a.rotation&&(s.rotation=a.rotation),void 0!==a.wrap&&(s.wrapS=i(a.wrap[0],Gc),s.wrapT=i(a.wrap[1],Gc)),void 0!==a.minFilter&&(s.minFilter=i(a.minFilter,Vc)),void 0!==a.magFilter&&(s.magFilter=i(a.magFilter,Vc)),void 0!==a.anisotropy&&(s.anisotropy=a.anisotropy),void 0!==a.flipY&&(s.flipY=a.flipY),r[a.uuid]=s}return r},parseObject:(Bc=new Ve,function(t,e,i){var r;function n(t){return void 0===e[t]&&console.warn("THREE.ObjectLoader: Undefined geometry",t),e[t]}function o(t){if(void 0!==t){if(Array.isArray(t)){for(var e=[],r=0,n=t.length;r<n;r++){var o=t[r];void 0===i[o]&&console.warn("THREE.ObjectLoader: Undefined material",o),e.push(i[o])}return e}return void 0===i[t]&&console.warn("THREE.ObjectLoader: Undefined material",t),i[t]}}switch(t.type){case"Scene":r=new Xo,void 0!==t.background&&Number.isInteger(t.background)&&(r.background=new Gi(t.background)),void 0!==t.fog&&("Fog"===t.fog.type?r.fog=new Wo(t.fog.color,t.fog.near,t.fog.far):"FogExp2"===t.fog.type&&(r.fog=new $o(t.fog.color,t.fog.density)));break;case"PerspectiveCamera":r=new jo(t.fov,t.aspect,t.near,t.far),void 0!==t.focus&&(r.focus=t.focus),void 0!==t.zoom&&(r.zoom=t.zoom),void 0!==t.filmGauge&&(r.filmGauge=t.filmGauge),void 0!==t.filmOffset&&(r.filmOffset=t.filmOffset),void 0!==t.view&&(r.view=Object.assign({},t.view));break;case"OrthographicCamera":r=new Zr(t.left,t.right,t.top,t.bottom,t.near,t.far);break;case"AmbientLight":r=new dc(t.color,t.intensity);break;case"DirectionalLight":r=new pc(t.color,t.intensity);break;case"PointLight":r=new hc(t.color,t.intensity,t.distance,t.decay);break;case"RectAreaLight":r=new fc(t.color,t.intensity,t.width,t.height);break;case"SpotLight":r=new uc(t.color,t.intensity,t.distance,t.angle,t.penumbra,t.decay);break;case"HemisphereLight":r=new ac(t.color,t.groundColor,t.intensity);break;case"SkinnedMesh":console.warn("THREE.ObjectLoader.parseObject() does not support SkinnedMesh yet.");case"Mesh":var a=n(t.geometry),s=o(t.material);r=a.bones&&a.bones.length>0?new ta(a,s):new uo(a,s);break;case"LOD":r=new Ko;break;case"Line":r=new ia(n(t.geometry),o(t.material),t.mode);break;case"LineLoop":r=new na(n(t.geometry),o(t.material));break;case"LineSegments":r=new ra(n(t.geometry),o(t.material));break;case"PointCloud":case"Points":r=new aa(n(t.geometry),o(t.material));break;case"Sprite":r=new Zo(o(t.material));break;case"Group":r=new sa;break;default:r=new qr}if(r.uuid=t.uuid,void 0!==t.name&&(r.name=t.name),void 0!==t.matrix?(Bc.fromArray(t.matrix),Bc.decompose(r.position,r.quaternion,r.scale)):(void 0!==t.position&&r.position.fromArray(t.position),void 0!==t.rotation&&r.rotation.fromArray(t.rotation),void 0!==t.quaternion&&r.quaternion.fromArray(t.quaternion),void 0!==t.scale&&r.scale.fromArray(t.scale)),void 0!==t.castShadow&&(r.castShadow=t.castShadow),void 0!==t.receiveShadow&&(r.receiveShadow=t.receiveShadow),t.shadow&&(void 0!==t.shadow.bias&&(r.shadow.bias=t.shadow.bias),void 0!==t.shadow.radius&&(r.shadow.radius=t.shadow.radius),void 0!==t.shadow.mapSize&&r.shadow.mapSize.fromArray(t.shadow.mapSize),void 0!==t.shadow.camera&&(r.shadow.camera=this.parseObject(t.shadow.camera))),void 0!==t.visible&&(r.visible=t.visible),void 0!==t.userData&&(r.userData=t.userData),void 0!==t.children)for(var c=t.children,u=0;u<c.length;u++)r.add(this.parseObject(c[u],e,i));if("LOD"===t.type)for(var h=t.levels,l=0;l<h.length;l++){var p=h[l],d=r.getObjectByProperty("uuid",p.object);void 0!==d&&r.addLevel(d,p.distance)}return r})});var Uc,jc={UVMapping:300,CubeReflectionMapping:kt,CubeRefractionMapping:Nt,EquirectangularReflectionMapping:Bt,EquirectangularRefractionMapping:Ft,SphericalReflectionMapping:zt,CubeUVReflectionMapping:Ut,CubeUVRefractionMapping:jt},Gc={RepeatWrapping:Gt,ClampToEdgeWrapping:Vt,MirroredRepeatWrapping:Ht},Vc={NearestFilter:$t,NearestMipMapNearestFilter:Wt,NearestMipMapLinearFilter:Xt,LinearFilter:qt,LinearMipMapNearestFilter:Yt,LinearMipMapLinearFilter:Zt};function Hc(){this.type="ShapePath",this.subPaths=[],this.currentPath=null}function $c(t){this.type="Font",this.data=t}Object.assign(Hc.prototype,{moveTo:function(t,e){this.currentPath=new rc,this.subPaths.push(this.currentPath),this.currentPath.moveTo(t,e)},lineTo:function(t,e){this.currentPath.lineTo(t,e)},quadraticCurveTo:function(t,e,i,r){this.currentPath.quadraticCurveTo(t,e,i,r)},bezierCurveTo:function(t,e,i,r,n,o){this.currentPath.bezierCurveTo(t,e,i,r,n,o)},splineThru:function(t){this.currentPath.splineThru(t)},toShapes:function(t,e){function i(t){for(var e=[],i=0,r=t.length;i<r;i++){var n=t[i],o=new nc;o.curves=n.curves,e.push(o)}return e}function r(t,e){for(var i=e.length,r=!1,n=i-1,o=0;o<i;n=o++){var a=e[n],s=e[o],c=s.x-a.x,u=s.y-a.y;if(Math.abs(u)>Number.EPSILON){if(u<0&&(a=e[o],c=-c,s=e[n],u=-u),t.y<a.y||t.y>s.y)continue;if(t.y===a.y){if(t.x===a.x)return!0}else{var h=u*(t.x-a.x)-c*(t.y-a.y);if(0===h)return!0;if(h<0)continue;r=!r}}else{if(t.y!==a.y)continue;if(s.x<=t.x&&t.x<=a.x||a.x<=t.x&&t.x<=s.x)return!0}}return r}var n=Ka.isClockWise,o=this.subPaths;if(0===o.length)return[];if(!0===e)return i(o);var a,s,c,u=[];if(1===o.length)return s=o[0],(c=new nc).curves=s.curves,u.push(c),u;var h=!n(o[0].getPoints());h=t?!h:h;var l,p,d=[],f=[],m=[],g=0;f[g]=void 0,m[g]=[];for(var v=0,y=o.length;v<y;v++)a=n(l=(s=o[v]).getPoints()),(a=t?!a:a)?(!h&&f[g]&&g++,f[g]={s:new nc,p:l},f[g].s.curves=s.curves,h&&g++,m[g]=[]):m[g].push({h:s,p:l[0]});if(!f[0])return i(o);if(f.length>1){for(var b=!1,x=[],_=0,w=f.length;_<w;_++)d[_]=[];for(_=0,w=f.length;_<w;_++)for(var S=m[_],A=0;A<S.length;A++){for(var M=S[A],P=!0,T=0;T<f.length;T++)r(M.p,f[T].p)&&(_!==T&&x.push({froms:_,tos:T,hole:A}),P?(P=!1,d[T].push(M)):b=!0);P&&d[_].push(M)}x.length>0&&(b||(m=d))}v=0;for(var E=f.length;v<E;v++){c=f[v].s,u.push(c);for(var C=0,I=(p=m[v]).length;C<I;C++)c.holes.push(p[C].h)}return u}}),Object.assign($c.prototype,{isFont:!0,generateShapes:function(t,e,i){function r(t,e,i,r){var o=n.glyphs[t]||n.glyphs["?"];if(o){var a,s,c,u,h,l,p,d,f,m=new Hc,g=[];if(o.o)for(var v=o._cachedOutline||(o._cachedOutline=o.o.split(" ")),y=0,b=v.length;y<b;){switch(v[y++]){case"m":a=v[y++]*e+i,s=v[y++]*e+r,m.moveTo(a,s);break;case"l":a=v[y++]*e+i,s=v[y++]*e+r,m.lineTo(a,s);break;case"q":c=v[y++]*e+i,u=v[y++]*e+r,h=v[y++]*e+i,l=v[y++]*e+r,m.quadraticCurveTo(h,l,c,u),(f=g[g.length-1])&&(f.x,f.y);break;case"b":c=v[y++]*e+i,u=v[y++]*e+r,h=v[y++]*e+i,l=v[y++]*e+r,p=v[y++]*e+i,d=v[y++]*e+r,m.bezierCurveTo(h,l,p,d,c,u),(f=g[g.length-1])&&(f.x,f.y)}}return{offsetX:o.ha*e,path:m}}}void 0===e&&(e=100),void 0===i&&(i=4);for(var n=this.data,o=function(t){for(var i=String(t).split(""),o=e/n.resolution,a=(n.boundingBox.yMax-n.boundingBox.yMin+n.underlineThickness)*o,s=0,c=0,u=[],h=0;h<i.length;h++){var l=i[h];if("\n"===l)s=0,c-=a;else{var p=r(l,o,s,c);s+=p.offsetX,u.push(p.path)}}return u}(t),a=[],s=0,c=o.length;s<c;s++)Array.prototype.push.apply(a,o[s].toShapes());return a}}),Object.assign(function(t){this.manager=void 0!==t?t:Rs}.prototype,{load:function(t,e,i,r){var n=this,o=new Os(this.manager);o.setPath(this.path),o.load(t,function(t){var i;try{i=JSON.parse(t)}catch(e){console.warn("THREE.FontLoader: typeface.js support is being deprecated. Use typeface.json instead."),i=JSON.parse(t.substring(65,t.length-2))}var r=n.parse(i);e&&e(r)},i,r)},parse:function(t){return new $c(t)},setPath:function(t){return this.path=t,this}});var Wc,Xc,qc,Yc,Zc,Kc,Jc,Qc,tu,eu,iu,ru,nu,ou,au,su,cu,uu,hu,lu,pu,du,fu,mu,gu,vu,yu,bu,xu,_u,wu,Su,Au,Mu,Pu,Tu,Eu,Cu,Iu,Ru,Lu={getContext:function(){return void 0===Uc&&(Uc=new(window.AudioContext||window.webkitAudioContext)),Uc},setContext:function(t){Uc=t}};function Ou(t){this.manager=void 0!==t?t:Rs}function Du(){this.type="StereoCamera",this.aspect=1,this.eyeSep=.064,this.cameraL=new jo,this.cameraL.layers.enable(1),this.cameraL.matrixAutoUpdate=!1,this.cameraR=new jo,this.cameraR.layers.enable(2),this.cameraR.matrixAutoUpdate=!1}function ku(t,e,i){qr.call(this),this.type="CubeCamera";var r=new jo(90,1,t,e);r.up.set(0,-1,0),r.lookAt(new $e(1,0,0)),this.add(r);var n=new jo(90,1,t,e);n.up.set(0,-1,0),n.lookAt(new $e(-1,0,0)),this.add(n);var o=new jo(90,1,t,e);o.up.set(0,0,1),o.lookAt(new $e(0,1,0)),this.add(o);var a=new jo(90,1,t,e);a.up.set(0,0,-1),a.lookAt(new $e(0,-1,0)),this.add(a);var s=new jo(90,1,t,e);s.up.set(0,-1,0),s.lookAt(new $e(0,0,1)),this.add(s);var c=new jo(90,1,t,e);c.up.set(0,-1,0),c.lookAt(new $e(0,0,-1)),this.add(c);var u={format:he,magFilter:qt,minFilter:qt};this.renderTarget=new Qe(i,i,u),this.renderTarget.texture.name="CubeCamera",this.update=function(t,e){null===this.parent&&this.updateMatrixWorld();var i=this.renderTarget,u=i.texture.generateMipmaps;i.texture.generateMipmaps=!1,i.activeCubeFace=0,t.render(e,r,i),i.activeCubeFace=1,t.render(e,n,i),i.activeCubeFace=2,t.render(e,o,i),i.activeCubeFace=3,t.render(e,a,i),i.activeCubeFace=4,t.render(e,s,i),i.texture.generateMipmaps=u,i.activeCubeFace=5,t.render(e,c,i),t.setRenderTarget(null)},this.clear=function(t,e,i,r){for(var n=this.renderTarget,o=0;o<6;o++)n.activeCubeFace=o,t.setRenderTarget(n),t.clear(e,i,r);t.setRenderTarget(null)}}function Nu(){qr.call(this),this.type="AudioListener",this.context=Lu.getContext(),this.gain=this.context.createGain(),this.gain.connect(this.context.destination),this.filter=null}function Bu(t){qr.call(this),this.type="Audio",this.context=t.context,this.gain=this.context.createGain(),this.gain.connect(t.getInput()),this.autoplay=!1,this.buffer=null,this.loop=!1,this.startTime=0,this.offset=0,this.playbackRate=1,this.isPlaying=!1,this.hasPlaybackControl=!0,this.sourceType="empty",this.filters=[]}function Fu(t){Bu.call(this,t),this.panner=this.context.createPanner(),this.panner.connect(this.gain)}function zu(t,e){this.analyser=t.context.createAnalyser(),this.analyser.fftSize=void 0!==e?e:2048,this.data=new Uint8Array(this.analyser.frequencyBinCount),t.getOutput().connect(this.analyser)}function Uu(t,e,i){this.binding=t,this.valueSize=i;var r,n=Float64Array;switch(e){case"quaternion":r=this._slerp;break;case"string":case"bool":n=Array,r=this._select;break;default:r=this._lerp}this.buffer=new n(4*i),this._mixBufferRegion=r,this.cumulativeWeight=0,this.useCount=0,this.referenceCount=0}function ju(t,e,i){var r=i||Gu.parseTrackName(e);this._targetGroup=t,this._bindings=t.subscribe_(e,r)}function Gu(t,e,i){this.path=e,this.parsedPath=i||Gu.parseTrackName(e),this.node=Gu.findNode(t,this.parsedPath.nodeName)||t,this.rootNode=t}function Vu(t,e,i){this._mixer=t,this._clip=e,this._localRoot=i||null;for(var r=e.tracks,n=r.length,o=new Array(n),a={endingStart:Te,endingEnd:Te},s=0;s!==n;++s){var c=r[s].createInterpolant(null);o[s]=c,c.settings=a}this._interpolantSettings=a,this._interpolants=o,this._propertyBindings=new Array(n),this._cacheIndex=null,this._byClipCacheIndex=null,this._timeScaleInterpolant=null,this._weightInterpolant=null,this.loop=Pe,this._loopCount=-1,this._startTime=null,this.time=0,this.timeScale=1,this._effectiveTimeScale=1,this.weight=1,this._effectiveWeight=1,this.repetitions=1/0,this.paused=!1,this.enabled=!0,this.clampWhenFinished=!1,this.zeroSlopeAtStart=!0,this.zeroSlopeAtEnd=!0}function Hu(t){this._root=t,this._initMemoryManager(),this._accuIndex=0,this.time=0,this.timeScale=1}function $u(t){"string"==typeof t&&(console.warn("THREE.Uniform: Type parameter is no longer needed."),t=arguments[1]),this.value=t}function Wu(){Qn.call(this),this.type="InstancedBufferGeometry",this.maxInstancedCount=void 0}function Xu(t,e,i,r){this.uuid=je.generateUUID(),this.data=t,this.itemSize=e,this.offset=i,this.normalized=!0===r}function qu(t,e){this.uuid=je.generateUUID(),this.array=t,this.stride=e,this.count=void 0!==t?t.length/e:0,this.dynamic=!1,this.updateRange={offset:0,count:-1},this.onUploadCallback=function(){},this.version=0}function Yu(t,e,i){qu.call(this,t,e),this.meshPerAttribute=i||1}function Zu(t,e,i){sn.call(this,t,e),this.meshPerAttribute=i||1}function Ku(t,e){return t.distance-e.distance}function Ju(t,e,i,r){if(!1!==t.visible&&(t.raycast(e,i),!0===r))for(var n=t.children,o=0,a=n.length;o<a;o++)Ju(n[o],e,i,!0)}function Qu(t){qr.call(this),this.material=t,this.render=function(){}}function th(t,e,i,r){this.object=t,this.size=void 0!==e?e:1;var n=void 0!==i?i:16711680,o=void 0!==r?r:1,a=0,s=this.object.geometry;s&&s.isGeometry?a=3*s.faces.length:s&&s.isBufferGeometry&&(a=s.attributes.normal.count);var c=new Qn,u=new mn(2*a*3,3);c.addAttribute("position",u),ra.call(this,c,new ea({color:n,linewidth:o})),this.matrixAutoUpdate=!1,this.update()}function eh(t,e){qr.call(this),this.light=t,this.light.updateMatrixWorld(),this.matrix=t.matrixWorld,this.matrixAutoUpdate=!1,this.color=e;for(var i=new Qn,r=[0,0,0,0,0,1,0,0,0,1,0,1,0,0,0,-1,0,1,0,0,0,0,1,1,0,0,0,0,-1,1],n=0,o=1;n<32;n++,o++){var a=n/32*Math.PI*2,s=o/32*Math.PI*2;r.push(Math.cos(a),Math.sin(a),1,Math.cos(s),Math.sin(s),1)}i.addAttribute("position",new mn(r,3));var c=new ea({fog:!1});this.cone=new ra(i,c),this.add(this.cone),this.update()}function ih(t){for(var e=function t(e){var i=[];e&&e.isBone&&i.push(e);for(var r=0;r<e.children.length;r++)i.push.apply(i,t(e.children[r]));return i}(t),i=new Qn,r=[],n=[],o=new Gi(0,0,1),a=new Gi(0,1,0),s=0;s<e.length;s++){var c=e[s];c.parent&&c.parent.isBone&&(r.push(0,0,0),r.push(0,0,0),n.push(o.r,o.g,o.b),n.push(a.r,a.g,a.b))}i.addAttribute("position",new mn(r,3)),i.addAttribute("color",new mn(n,3));var u=new ea({vertexColors:Z,depthTest:!1,depthWrite:!1,transparent:!0});ra.call(this,i,u),this.root=t,this.bones=e,this.matrix=t.matrixWorld,this.matrixAutoUpdate=!1}function rh(t,e,i){this.light=t,this.light.updateMatrixWorld(),this.color=i;var r=new rs(e,4,2),n=new no({wireframe:!0,fog:!1});uo.call(this,r,n),this.matrix=this.light.matrixWorld,this.matrixAutoUpdate=!1,this.update()}function nh(t,e){qr.call(this),this.light=t,this.light.updateMatrixWorld(),this.matrix=t.matrixWorld,this.matrixAutoUpdate=!1,this.color=e;var i=new ea({fog:!1}),r=new Qn;r.addAttribute("position",new sn(new Float32Array(15),3)),this.line=new ia(r,i),this.add(this.line),this.update()}function oh(t,e,i){qr.call(this),this.light=t,this.light.updateMatrixWorld(),this.matrix=t.matrixWorld,this.matrixAutoUpdate=!1,this.color=i;var r=new ba(e);r.rotateY(.5*Math.PI),this.material=new no({wireframe:!0,fog:!1}),void 0===this.color&&(this.material.vertexColors=Z);var n=r.getAttribute("position"),o=new Float32Array(3*n.count);r.addAttribute("color",new sn(o,3)),this.add(new uo(r,this.material)),this.update()}function ah(t,e,i,r){t=t||10,e=e||10,i=new Gi(void 0!==i?i:4473924),r=new Gi(void 0!==r?r:8947848);for(var n=e/2,o=t/e,a=t/2,s=[],c=[],u=0,h=0,l=-a;u<=e;u++,l+=o){s.push(-a,0,l,a,0,l),s.push(l,0,-a,l,0,a);var p=u===n?i:r;p.toArray(c,h),h+=3,p.toArray(c,h),h+=3,p.toArray(c,h),h+=3,p.toArray(c,h),h+=3}var d=new Qn;d.addAttribute("position",new mn(s,3)),d.addAttribute("color",new mn(c,3));var f=new ea({vertexColors:Z});ra.call(this,d,f)}function sh(t,e,i,r,n,o){t=t||10,e=e||16,i=i||8,r=r||64,n=new Gi(void 0!==n?n:4473924),o=new Gi(void 0!==o?o:8947848);var a,s,c,u,h,l,p,d=[],f=[];for(u=0;u<=e;u++)c=u/e*(2*Math.PI),a=Math.sin(c)*t,s=Math.cos(c)*t,d.push(0,0,0),d.push(a,0,s),p=1&u?n:o,f.push(p.r,p.g,p.b),f.push(p.r,p.g,p.b);for(u=0;u<=i;u++)for(p=1&u?n:o,l=t-t/i*u,h=0;h<r;h++)c=h/r*(2*Math.PI),a=Math.sin(c)*l,s=Math.cos(c)*l,d.push(a,0,s),f.push(p.r,p.g,p.b),c=(h+1)/r*(2*Math.PI),a=Math.sin(c)*l,s=Math.cos(c)*l,d.push(a,0,s),f.push(p.r,p.g,p.b);var m=new Qn;m.addAttribute("position",new mn(d,3)),m.addAttribute("color",new mn(f,3));var g=new ea({vertexColors:Z});ra.call(this,m,g)}function ch(t,e,i,r){this.object=t,this.size=void 0!==e?e:1;var n=void 0!==i?i:16776960,o=void 0!==r?r:1,a=0,s=this.object.geometry;s&&s.isGeometry?a=s.faces.length:console.warn("THREE.FaceNormalsHelper: only THREE.Geometry is supported. Use THREE.VertexNormalsHelper, instead.");var c=new Qn,u=new mn(2*a*3,3);c.addAttribute("position",u),ra.call(this,c,new ea({color:n,linewidth:o})),this.matrixAutoUpdate=!1,this.update()}function uh(t,e,i){qr.call(this),this.light=t,this.light.updateMatrixWorld(),this.matrix=t.matrixWorld,this.matrixAutoUpdate=!1,this.color=i,void 0===e&&(e=1);var r=new Qn;r.addAttribute("position",new mn([-e,e,0,e,e,0,e,-e,0,-e,-e,0,-e,e,0],3));var n=new ea({fog:!1});this.lightPlane=new ia(r,n),this.add(this.lightPlane),(r=new Qn).addAttribute("position",new mn([0,0,0,0,0,1],3)),this.targetLine=new ia(r,n),this.add(this.targetLine),this.update()}function hh(t){var e=new Qn,i=new ea({color:16777215,vertexColors:Y}),r=[],n=[],o={},a=new Gi(16755200),s=new Gi(16711680),c=new Gi(43775),u=new Gi(16777215),h=new Gi(3355443);function l(t,e,i){p(t,i),p(e,i)}function p(t,e){r.push(0,0,0),n.push(e.r,e.g,e.b),void 0===o[t]&&(o[t]=[]),o[t].push(r.length/3-1)}l("n1","n2",a),l("n2","n4",a),l("n4","n3",a),l("n3","n1",a),l("f1","f2",a),l("f2","f4",a),l("f4","f3",a),l("f3","f1",a),l("n1","f1",a),l("n2","f2",a),l("n3","f3",a),l("n4","f4",a),l("p","n1",s),l("p","n2",s),l("p","n3",s),l("p","n4",s),l("u1","u2",c),l("u2","u3",c),l("u3","u1",c),l("c","t",u),l("p","c",h),l("cn1","cn2",h),l("cn3","cn4",h),l("cf1","cf2",h),l("cf3","cf4",h),e.addAttribute("position",new mn(r,3)),e.addAttribute("color",new mn(n,3)),ra.call(this,e,i),this.camera=t,this.camera.updateProjectionMatrix&&this.camera.updateProjectionMatrix(),this.matrix=t.matrixWorld,this.matrixAutoUpdate=!1,this.pointMap=o,this.update()}function lh(t,e){this.object=t,void 0===e&&(e=16776960);var i=new Uint16Array([0,1,1,2,2,3,3,0,4,5,5,6,6,7,7,4,0,4,1,5,2,6,3,7]),r=new Float32Array(24),n=new Qn;n.setIndex(new sn(i,1)),n.addAttribute("position",new sn(r,3)),ra.call(this,n,new ea({color:e})),this.matrixAutoUpdate=!1,this.update()}function ph(t,e){this.type="Box3Helper",this.box=t;var i=void 0!==e?e:16776960,r=new Uint16Array([0,1,1,2,2,3,3,0,4,5,5,6,6,7,7,4,0,4,1,5,2,6,3,7]),n=new Qn;n.setIndex(new sn(r,1)),n.addAttribute("position",new mn([1,1,1,-1,1,1,-1,-1,1,1,-1,1,1,1,-1,-1,1,-1,-1,-1,-1,1,-1,-1],3)),ra.call(this,n,new ea({color:i})),this.geometry.computeBoundingSphere()}function dh(t,e,i){this.type="PlaneHelper",this.plane=t,this.size=void 0===e?1:e;var r=void 0!==i?i:16776960,n=new Qn;n.addAttribute("position",new mn([1,-1,1,-1,1,1,-1,-1,1,1,1,1,-1,1,1,-1,-1,1,1,-1,1,1,1,1,0,0,1,0,0,0],3)),n.computeBoundingSphere(),ia.call(this,n,new ea({color:r}));var o=new Qn;o.addAttribute("position",new mn([1,1,1,-1,1,1,-1,-1,1,1,1,1,-1,-1,1,1,-1,1],3)),o.computeBoundingSphere(),this.add(new uo(o,new no({color:r,opacity:.2,transparent:!0,depthWrite:!1})))}function fh(t,e,i,r,n,o){qr.call(this),void 0===r&&(r=16776960),void 0===i&&(i=1),void 0===n&&(n=.2*i),void 0===o&&(o=.2*n),void 0===Tu&&((Tu=new Qn).addAttribute("position",new mn([0,0,0,0,1,0],3)),(Eu=new ds(0,.5,1,5,1)).translate(0,-.5,0)),this.position.copy(e),this.line=new ia(Tu,new ea({color:r})),this.line.matrixAutoUpdate=!1,this.add(this.line),this.cone=new uo(Eu,new no({color:r})),this.cone.matrixAutoUpdate=!1,this.add(this.cone),this.setDirection(t),this.setLength(i,n,o)}function mh(t){var e=[0,0,0,t=t||1,0,0,0,0,0,0,t,0,0,0,0,0,0,t],i=new Qn;i.addAttribute("position",new mn(e,3)),i.addAttribute("color",new mn([1,0,0,1,.6,0,0,1,0,.6,1,0,0,0,1,0,.6,1],3));var r=new ea({vertexColors:Z});ra.call(this,i,r)}function gh(t){console.warn("THREE.Spline has been removed. Use THREE.CatmullRomCurve3 instead."),Hs.call(this,t),this.type="catmullrom"}function vh(t){if("undefined"!=typeof window){var e=new RegExp(t+"=([^&#=]*)").exec(window.location.search);return e?decodeURIComponent(e[1]):void 0}}function yh(t,e){return void 0!==t?t:e}function bh(t,e){var i=Object.assign({},t);for(var r in e){void 0===t[r]&&(i[r]=e[r])}return i}function xh(t,e){for(var i in e){var r=e[i];void 0!==r&&(t[i]=r)}return t}function _h(){var t=window.location.protocol;return null===t.match(/http(s)?:/gi)?"http:":t}function wh(){if("undefined"==typeof window)return!1;var t=window.navigator.userAgent;return/Opera|OPR/.test(t)?"Opera":/Chrome/i.test(t)?"Chrome":/Firefox/i.test(t)?"Firefox":/Mobile(\/.*)? Safari/i.test(t)?"Mobile Safari":/MSIE/i.test(t)?"Internet Explorer":!!/Safari/i.test(t)&&"Safari"}function Sh(t){window.open(t,"_blank")||(window.location.href=t)}function Ah(t,e){if(void 0===e&&(e="download"),t){var i="Safari"===wh(),r=/CriOS\/[\d]+/.test(window.navigator.userAgent),n=document.createElement("a");if("undefined"!=typeof navigator&&navigator.msSaveOrOpenBlob)navigator.msSaveOrOpenBlob(t,e);else if((i||r)&&FileReader)if(t instanceof Blob){var o=new FileReader;o.onloadend=function(){s(o.result)},o.readAsDataURL(t)}else s(t);else{var a=!1;t instanceof Blob&&(t=URL.createObjectURL(t),a=!0),"download"in n?(n.style.display="hidden",document.body.appendChild(n),n.href=t,n.download=e,n.target="_blank",n.click(),document.body.removeChild(n)):Sh(t),a&&window.URL.revokeObjectURL(t)}}function s(t){Sh(r?t:t.replace(/^data:[^;]*;/,"data:attachment/file;"))}}function Mh(t,e){return t<e?-1:t>e?1:0}function Ph(t,e,i){void 0===i&&(i=Mh);for(var r=0,n=t.length-1;r<=n;){var o=r+n>>1,a=i(e,t[o]);if(a>0)r=o+1;else{if(!(a<0))return o;n=o-1}}return-r-1}function Th(t,e,i){var r=function(t,e){var i=t.length-1;if(t[i]<e)return-1;for(var r=0;r<=i;){var n=r+i>>1;t[n]>=e?i=n-1:r=n+1}return i+1}(t,e),n=function(t,e){if(t[0]>e)return-1;for(var i=0,r=t.length-1;i<=r;){var n=i+r>>1;t[n]>e?r=n-1:i=n+1}return i-1}(t,i);return-1===r||-1===n||r>n?0:n-r+1}function Eh(t){return t.sort().filter(function(t,e,i){return 0===e||t!==i[e-1]})}function Ch(t){if(t.length>28672){for(var e=[],i=0;i<t.length;i+=28672)e.push(String.fromCharCode.apply(null,t.subarray(i,i+28672)));return e.join("")}return String.fromCharCode.apply(null,t)}function Ih(t,e){switch(t){case"int8":return new Int8Array(e);case"int16":return new Int16Array(e);case"int32":return new Int32Array(e);case"uint8":return new Uint8Array(e);case"uint16":return new Uint16Array(e);case"uint32":return new Uint32Array(e);case"float32":return new Float32Array(e);default:throw new Error("arrayType unknown: "+t)}}function Rh(t,e){return new(e>65535?Uint32Array:Uint16Array)(t)}function Lh(t){return t.buffer&&t.buffer instanceof ArrayBuffer?t.buffer:t}function Oh(t,e){return void 0===t?t=new e:Array.isArray(t)&&(t=(new e).fromArray(t)),t}function Dh(t){return Oh(t,$e)}function kh(t){return Oh(t,Ve)}function Nh(t){return Oh(t,He)}function Bh(t){return e=t,i=Float32Array,e instanceof i?e:new i(e);var e,i}function Fh(t){return yh(t,"").toString().toLowerCase()}Object.assign(Ou.prototype,{load:function(t,e,i,r){var n=new Os(this.manager);n.setResponseType("arraybuffer"),n.load(t,function(t){Lu.getContext().decodeAudioData(t,function(t){e(t)})},i,r)}}),Object.assign(Du.prototype,{update:(tu=new Ve,eu=new Ve,function(t){if(Wc!==this||Xc!==t.focus||qc!==t.fov||Yc!==t.aspect*this.aspect||Zc!==t.near||Kc!==t.far||Jc!==t.zoom||Qc!==this.eyeSep){Wc=this,Xc=t.focus,qc=t.fov,Yc=t.aspect*this.aspect,Zc=t.near,Kc=t.far,Jc=t.zoom;var e,i,r=t.projectionMatrix.clone(),n=(Qc=this.eyeSep/2)*Zc/Xc,o=Zc*Math.tan(je.DEG2RAD*qc*.5)/Jc;eu.elements[12]=-Qc,tu.elements[12]=Qc,e=-o*Yc+n,i=o*Yc+n,r.elements[0]=2*Zc/(i-e),r.elements[8]=(i+e)/(i-e),this.cameraL.projectionMatrix.copy(r),e=-o*Yc-n,i=o*Yc-n,r.elements[0]=2*Zc/(i-e),r.elements[8]=(i+e)/(i-e),this.cameraR.projectionMatrix.copy(r)}this.cameraL.matrixWorld.copy(t.matrixWorld).multiply(eu),this.cameraR.matrixWorld.copy(t.matrixWorld).multiply(tu)})}),ku.prototype=Object.create(qr.prototype),ku.prototype.constructor=ku,Nu.prototype=Object.assign(Object.create(qr.prototype),{constructor:Nu,getInput:function(){return this.gain},removeFilter:function(){null!==this.filter&&(this.gain.disconnect(this.filter),this.filter.disconnect(this.context.destination),this.gain.connect(this.context.destination),this.filter=null)},getFilter:function(){return this.filter},setFilter:function(t){null!==this.filter?(this.gain.disconnect(this.filter),this.filter.disconnect(this.context.destination)):this.gain.disconnect(this.context.destination),this.filter=t,this.gain.connect(this.filter),this.filter.connect(this.context.destination)},getMasterVolume:function(){return this.gain.gain.value},setMasterVolume:function(t){this.gain.gain.value=t},updateMatrixWorld:(iu=new $e,ru=new He,nu=new $e,ou=new $e,function(t){qr.prototype.updateMatrixWorld.call(this,t);var e=this.context.listener,i=this.up;this.matrixWorld.decompose(iu,ru,nu),ou.set(0,0,-1).applyQuaternion(ru),e.positionX?(e.positionX.setValueAtTime(iu.x,this.context.currentTime),e.positionY.setValueAtTime(iu.y,this.context.currentTime),e.positionZ.setValueAtTime(iu.z,this.context.currentTime),e.forwardX.setValueAtTime(ou.x,this.context.currentTime),e.forwardY.setValueAtTime(ou.y,this.context.currentTime),e.forwardZ.setValueAtTime(ou.z,this.context.currentTime),e.upX.setValueAtTime(i.x,this.context.currentTime),e.upY.setValueAtTime(i.y,this.context.currentTime),e.upZ.setValueAtTime(i.z,this.context.currentTime)):(e.setPosition(iu.x,iu.y,iu.z),e.setOrientation(ou.x,ou.y,ou.z,i.x,i.y,i.z))})}),Bu.prototype=Object.assign(Object.create(qr.prototype),{constructor:Bu,getOutput:function(){return this.gain},setNodeSource:function(t){return this.hasPlaybackControl=!1,this.sourceType="audioNode",this.source=t,this.connect(),this},setBuffer:function(t){return this.buffer=t,this.sourceType="buffer",this.autoplay&&this.play(),this},play:function(){if(!0!==this.isPlaying){if(!1!==this.hasPlaybackControl){var t=this.context.createBufferSource();return t.buffer=this.buffer,t.loop=this.loop,t.onended=this.onEnded.bind(this),t.playbackRate.setValueAtTime(this.playbackRate,this.startTime),this.startTime=this.context.currentTime,t.start(this.startTime,this.offset),this.isPlaying=!0,this.source=t,this.connect()}console.warn("THREE.Audio: this Audio has no playback control.")}else console.warn("THREE.Audio: Audio is already playing.")},pause:function(){if(!1!==this.hasPlaybackControl)return!0===this.isPlaying&&(this.source.stop(),this.offset+=(this.context.currentTime-this.startTime)*this.playbackRate,this.isPlaying=!1),this;console.warn("THREE.Audio: this Audio has no playback control.")},stop:function(){if(!1!==this.hasPlaybackControl)return this.source.stop(),this.offset=0,this.isPlaying=!1,this;console.warn("THREE.Audio: this Audio has no playback control.")},connect:function(){if(this.filters.length>0){this.source.connect(this.filters[0]);for(var t=1,e=this.filters.length;t<e;t++)this.filters[t-1].connect(this.filters[t]);this.filters[this.filters.length-1].connect(this.getOutput())}else this.source.connect(this.getOutput());return this},disconnect:function(){if(this.filters.length>0){this.source.disconnect(this.filters[0]);for(var t=1,e=this.filters.length;t<e;t++)this.filters[t-1].disconnect(this.filters[t]);this.filters[this.filters.length-1].disconnect(this.getOutput())}else this.source.disconnect(this.getOutput());return this},getFilters:function(){return this.filters},setFilters:function(t){return t||(t=[]),!0===this.isPlaying?(this.disconnect(),this.filters=t,this.connect()):this.filters=t,this},getFilter:function(){return this.getFilters()[0]},setFilter:function(t){return this.setFilters(t?[t]:[])},setPlaybackRate:function(t){if(!1!==this.hasPlaybackControl)return this.playbackRate=t,!0===this.isPlaying&&this.source.playbackRate.setValueAtTime(this.playbackRate,this.context.currentTime),this;console.warn("THREE.Audio: this Audio has no playback control.")},getPlaybackRate:function(){return this.playbackRate},onEnded:function(){this.isPlaying=!1},getLoop:function(){return!1===this.hasPlaybackControl?(console.warn("THREE.Audio: this Audio has no playback control."),!1):this.loop},setLoop:function(t){if(!1!==this.hasPlaybackControl)return this.loop=t,!0===this.isPlaying&&(this.source.loop=this.loop),this;console.warn("THREE.Audio: this Audio has no playback control.")},getVolume:function(){return this.gain.gain.value},setVolume:function(t){return this.gain.gain.value=t,this}}),Fu.prototype=Object.assign(Object.create(Bu.prototype),{constructor:Fu,getOutput:function(){return this.panner},getRefDistance:function(){return this.panner.refDistance},setRefDistance:function(t){this.panner.refDistance=t},getRolloffFactor:function(){return this.panner.rolloffFactor},setRolloffFactor:function(t){this.panner.rolloffFactor=t},getDistanceModel:function(){return this.panner.distanceModel},setDistanceModel:function(t){this.panner.distanceModel=t},getMaxDistance:function(){return this.panner.maxDistance},setMaxDistance:function(t){this.panner.maxDistance=t},updateMatrixWorld:(au=new $e,function(t){qr.prototype.updateMatrixWorld.call(this,t),au.setFromMatrixPosition(this.matrixWorld),this.panner.setPosition(au.x,au.y,au.z)})}),Object.assign(zu.prototype,{getFrequencyData:function(){return this.analyser.getByteFrequencyData(this.data),this.data},getAverageFrequency:function(){for(var t=0,e=this.getFrequencyData(),i=0;i<e.length;i++)t+=e[i];return t/e.length}}),Object.assign(Uu.prototype,{accumulate:function(t,e){var i=this.buffer,r=this.valueSize,n=t*r+r,o=this.cumulativeWeight;if(0===o){for(var a=0;a!==r;++a)i[n+a]=i[a];o=e}else{var s=e/(o+=e);this._mixBufferRegion(i,n,0,s,r)}this.cumulativeWeight=o},apply:function(t){var e=this.valueSize,i=this.buffer,r=t*e+e,n=this.cumulativeWeight,o=this.binding;if(this.cumulativeWeight=0,n<1){var a=3*e;this._mixBufferRegion(i,r,a,1-n,e)}for(var s=e,c=e+e;s!==c;++s)if(i[s]!==i[s+e]){o.setValue(i,r);break}},saveOriginalState:function(){var t=this.binding,e=this.buffer,i=this.valueSize,r=3*i;t.getValue(e,r);for(var n=i,o=r;n!==o;++n)e[n]=e[r+n%i];this.cumulativeWeight=0},restoreOriginalState:function(){var t=3*this.valueSize;this.binding.setValue(this.buffer,t)},_select:function(t,e,i,r,n){if(r>=.5)for(var o=0;o!==n;++o)t[e+o]=t[i+o]},_slerp:function(t,e,i,r){He.slerpFlat(t,e,t,e,t,i,r)},_lerp:function(t,e,i,r,n){for(var o=1-r,a=0;a!==n;++a){var s=e+a;t[s]=t[s]*o+t[i+a]*r}}}),Object.assign(ju.prototype,{getValue:function(t,e){this.bind();var i=this._targetGroup.nCachedObjects_,r=this._bindings[i];void 0!==r&&r.getValue(t,e)},setValue:function(t,e){for(var i=this._bindings,r=this._targetGroup.nCachedObjects_,n=i.length;r!==n;++r)i[r].setValue(t,e)},bind:function(){for(var t=this._bindings,e=this._targetGroup.nCachedObjects_,i=t.length;e!==i;++e)t[e].bind()},unbind:function(){for(var t=this._bindings,e=this._targetGroup.nCachedObjects_,i=t.length;e!==i;++e)t[e].unbind()}}),Object.assign(Gu,{Composite:ju,create:function(t,e,i){return t&&t.isAnimationObjectGroup?new Gu.Composite(t,e,i):new Gu(t,e,i)},sanitizeNodeName:function(t){return t.replace(/\s/g,"_").replace(/[^\w-]/g,"")},parseTrackName:(su=new RegExp("^"+/((?:[\w-]+[\/:])*)/.source+/([\w-\.]+)?/.source+/(?:\.([\w-]+)(?:\[(.+)\])?)?/.source+/\.([\w-]+)(?:\[(.+)\])?/.source+"$"),cu=["material","materials","bones"],function(t){var e=su.exec(t);if(!e)throw new Error("PropertyBinding: Cannot parse trackName: "+t);var i={nodeName:e[2],objectName:e[3],objectIndex:e[4],propertyName:e[5],propertyIndex:e[6]},r=i.nodeName&&i.nodeName.lastIndexOf(".");if(void 0!==r&&-1!==r){var n=i.nodeName.substring(r+1);-1!==cu.indexOf(n)&&(i.nodeName=i.nodeName.substring(0,r),i.objectName=n)}if(null===i.propertyName||0===i.propertyName.length)throw new Error("PropertyBinding: can not parse propertyName from trackName: "+t);return i}),findNode:function(t,e){if(!e||""===e||"root"===e||"."===e||-1===e||e===t.name||e===t.uuid)return t;if(t.skeleton){var i=function(t){for(var i=0;i<t.bones.length;i++){var r=t.bones[i];if(r.name===e)return r}return null}(t.skeleton);if(i)return i}if(t.children){var r=function(t){for(var i=0;i<t.length;i++){var n=t[i];if(n.name===e||n.uuid===e)return n;var o=r(n.children);if(o)return o}return null},n=r(t.children);if(n)return n}return null}}),Object.assign(Gu.prototype,{_getValue_unavailable:function(){},_setValue_unavailable:function(){},BindingType:{Direct:0,EntireArray:1,ArrayElement:2,HasFromToArray:3},Versioning:{None:0,NeedsUpdate:1,MatrixWorldNeedsUpdate:2},GetterByBindingType:[function(t,e){t[e]=this.node[this.propertyName]},function(t,e){for(var i=this.resolvedProperty,r=0,n=i.length;r!==n;++r)t[e++]=i[r]},function(t,e){t[e]=this.resolvedProperty[this.propertyIndex]},function(t,e){this.resolvedProperty.toArray(t,e)}],SetterByBindingTypeAndVersioning:[[function(t,e){this.targetObject[this.propertyName]=t[e]},function(t,e){this.targetObject[this.propertyName]=t[e],this.targetObject.needsUpdate=!0},function(t,e){this.targetObject[this.propertyName]=t[e],this.targetObject.matrixWorldNeedsUpdate=!0}],[function(t,e){for(var i=this.resolvedProperty,r=0,n=i.length;r!==n;++r)i[r]=t[e++]},function(t,e){for(var i=this.resolvedProperty,r=0,n=i.length;r!==n;++r)i[r]=t[e++];this.targetObject.needsUpdate=!0},function(t,e){for(var i=this.resolvedProperty,r=0,n=i.length;r!==n;++r)i[r]=t[e++];this.targetObject.matrixWorldNeedsUpdate=!0}],[function(t,e){this.resolvedProperty[this.propertyIndex]=t[e]},function(t,e){this.resolvedProperty[this.propertyIndex]=t[e],this.targetObject.needsUpdate=!0},function(t,e){this.resolvedProperty[this.propertyIndex]=t[e],this.targetObject.matrixWorldNeedsUpdate=!0}],[function(t,e){this.resolvedProperty.fromArray(t,e)},function(t,e){this.resolvedProperty.fromArray(t,e),this.targetObject.needsUpdate=!0},function(t,e){this.resolvedProperty.fromArray(t,e),this.targetObject.matrixWorldNeedsUpdate=!0}]],getValue:function(t,e){this.bind(),this.getValue(t,e)},setValue:function(t,e){this.bind(),this.setValue(t,e)},bind:function(){var t=this.node,e=this.parsedPath,i=e.objectName,r=e.propertyName,n=e.propertyIndex;if(t||(t=Gu.findNode(this.rootNode,e.nodeName)||this.rootNode,this.node=t),this.getValue=this._getValue_unavailable,this.setValue=this._setValue_unavailable,t){if(i){var o=e.objectIndex;switch(i){case"materials":if(!t.material)return void console.error("THREE.PropertyBinding: Can not bind to material as node does not have a material.",this);if(!t.material.materials)return void console.error("THREE.PropertyBinding: Can not bind to material.materials as node.material does not have a materials array.",this);t=t.material.materials;break;case"bones":if(!t.skeleton)return void console.error("THREE.PropertyBinding: Can not bind to bones as node does not have a skeleton.",this);t=t.skeleton.bones;for(var a=0;a<t.length;a++)if(t[a].name===o){o=a;break}break;default:if(void 0===t[i])return void console.error("THREE.PropertyBinding: Can not bind to objectName of node undefined.",this);t=t[i]}if(void 0!==o){if(void 0===t[o])return void console.error("THREE.PropertyBinding: Trying to bind to objectIndex of objectName, but is undefined.",this,t);t=t[o]}}var s=t[r];if(void 0!==s){var c=this.Versioning.None;void 0!==t.needsUpdate?(c=this.Versioning.NeedsUpdate,this.targetObject=t):void 0!==t.matrixWorldNeedsUpdate&&(c=this.Versioning.MatrixWorldNeedsUpdate,this.targetObject=t);var u=this.BindingType.Direct;if(void 0!==n){if("morphTargetInfluences"===r){if(!t.geometry)return void console.error("THREE.PropertyBinding: Can not bind to morphTargetInfluences because node does not have a geometry.",this);if(t.geometry.isBufferGeometry){if(!t.geometry.morphAttributes)return void console.error("THREE.PropertyBinding: Can not bind to morphTargetInfluences because node does not have a geometry.morphAttributes.",this);for(a=0;a<this.node.geometry.morphAttributes.position.length;a++)if(t.geometry.morphAttributes.position[a].name===n){n=a;break}}else{if(!t.geometry.morphTargets)return void console.error("THREE.PropertyBinding: Can not bind to morphTargetInfluences because node does not have a geometry.morphTargets.",this);for(a=0;a<this.node.geometry.morphTargets.length;a++)if(t.geometry.morphTargets[a].name===n){n=a;break}}}u=this.BindingType.ArrayElement,this.resolvedProperty=s,this.propertyIndex=n}else void 0!==s.fromArray&&void 0!==s.toArray?(u=this.BindingType.HasFromToArray,this.resolvedProperty=s):Array.isArray(s)?(u=this.BindingType.EntireArray,this.resolvedProperty=s):this.propertyName=r;this.getValue=this.GetterByBindingType[u],this.setValue=this.SetterByBindingTypeAndVersioning[u][c]}else{var h=e.nodeName;console.error("THREE.PropertyBinding: Trying to update property for track: "+h+"."+r+" but it wasn't found.",t)}}else console.error("THREE.PropertyBinding: Trying to update node for track: "+this.path+" but it wasn't found.")},unbind:function(){this.node=null,this.getValue=this._getValue_unbound,this.setValue=this._setValue_unbound}}),Object.assign(Gu.prototype,{_getValue_unbound:Gu.prototype.getValue,_setValue_unbound:Gu.prototype.setValue}),Object.assign(function(){var t=arguments;this.uuid=je.generateUUID(),this._objects=Array.prototype.slice.call(arguments),this.nCachedObjects_=0;var e={};this._indicesByUUID=e;for(var i=0,r=arguments.length;i!==r;++i)e[t[i].uuid]=i;this._paths=[],this._parsedPaths=[],this._bindings=[],this._bindingsIndicesByPath={};var n=this;this.stats={objects:{get total(){return n._objects.length},get inUse(){return this.total-n.nCachedObjects_}},get bindingsPerObject(){return n._bindings.length}}}.prototype,{isAnimationObjectGroup:!0,add:function(){for(var t=arguments,e=this._objects,i=e.length,r=this.nCachedObjects_,n=this._indicesByUUID,o=this._paths,a=this._parsedPaths,s=this._bindings,c=s.length,u=0,h=arguments.length;u!==h;++u){var l=t[u],p=l.uuid,d=n[p],f=void 0;if(void 0===d){d=i++,n[p]=d,e.push(l);for(var m=0,g=c;m!==g;++m)s[m].push(new Gu(l,o[m],a[m]))}else if(d<r){f=e[d];var v=--r,y=e[v];n[y.uuid]=d,e[d]=y,n[p]=v,e[v]=l;for(m=0,g=c;m!==g;++m){var b=s[m],x=b[v],_=b[d];b[d]=x,void 0===_&&(_=new Gu(l,o[m],a[m])),b[v]=_}}else e[d]!==f&&console.error("THREE.AnimationObjectGroup: Different objects with the same UUID detected. Clean the caches or recreate your infrastructure when reloading scenes.")}this.nCachedObjects_=r},remove:function(){for(var t=arguments,e=this._objects,i=this.nCachedObjects_,r=this._indicesByUUID,n=this._bindings,o=n.length,a=0,s=arguments.length;a!==s;++a){var c=t[a],u=c.uuid,h=r[u];if(void 0!==h&&h>=i){var l=i++,p=e[l];r[p.uuid]=h,e[h]=p,r[u]=l,e[l]=c;for(var d=0,f=o;d!==f;++d){var m=n[d],g=m[l],v=m[h];m[h]=g,m[l]=v}}}this.nCachedObjects_=i},uncache:function(){for(var t=arguments,e=this._objects,i=e.length,r=this.nCachedObjects_,n=this._indicesByUUID,o=this._bindings,a=o.length,s=0,c=arguments.length;s!==c;++s){var u=t[s].uuid,h=n[u];if(void 0!==h)if(delete n[u],h<r){var l=--r,p=e[l],d=e[y=--i];n[p.uuid]=h,e[h]=p,n[d.uuid]=l,e[l]=d,e.pop();for(var f=0,m=a;f!==m;++f){var g=(b=o[f])[l],v=b[y];b[h]=g,b[l]=v,b.pop()}}else{var y;n[(d=e[y=--i]).uuid]=h,e[h]=d,e.pop();for(f=0,m=a;f!==m;++f){var b;(b=o[f])[h]=b[y],b.pop()}}}this.nCachedObjects_=r},subscribe_:function(t,e){var i=this._bindingsIndicesByPath,r=i[t],n=this._bindings;if(void 0!==r)return n[r];var o=this._paths,a=this._parsedPaths,s=this._objects,c=s.length,u=this.nCachedObjects_,h=new Array(c);r=n.length,i[t]=r,o.push(t),a.push(e),n.push(h);for(var l=u,p=s.length;l!==p;++l){var d=s[l];h[l]=new Gu(d,t,e)}return h},unsubscribe_:function(t){var e=this._bindingsIndicesByPath,i=e[t];if(void 0!==i){var r=this._paths,n=this._parsedPaths,o=this._bindings,a=o.length-1,s=o[a];e[t[a]]=i,o[i]=s,o.pop(),n[i]=n[a],n.pop(),r[i]=r[a],r.pop()}}}),Object.assign(Vu.prototype,{play:function(){return this._mixer._activateAction(this),this},stop:function(){return this._mixer._deactivateAction(this),this.reset()},reset:function(){return this.paused=!1,this.enabled=!0,this.time=0,this._loopCount=-1,this._startTime=null,this.stopFading().stopWarping()},isRunning:function(){return this.enabled&&!this.paused&&0!==this.timeScale&&null===this._startTime&&this._mixer._isActiveAction(this)},isScheduled:function(){return this._mixer._isActiveAction(this)},startAt:function(t){return this._startTime=t,this},setLoop:function(t,e){return this.loop=t,this.repetitions=e,this},setEffectiveWeight:function(t){return this.weight=t,this._effectiveWeight=this.enabled?t:0,this.stopFading()},getEffectiveWeight:function(){return this._effectiveWeight},fadeIn:function(t){return this._scheduleFading(t,0,1)},fadeOut:function(t){return this._scheduleFading(t,1,0)},crossFadeFrom:function(t,e,i){if(t.fadeOut(e),this.fadeIn(e),i){var r=this._clip.duration,n=t._clip.duration,o=n/r,a=r/n;t.warp(1,o,e),this.warp(a,1,e)}return this},crossFadeTo:function(t,e,i){return t.crossFadeFrom(this,e,i)},stopFading:function(){var t=this._weightInterpolant;return null!==t&&(this._weightInterpolant=null,this._mixer._takeBackControlInterpolant(t)),this},setEffectiveTimeScale:function(t){return this.timeScale=t,this._effectiveTimeScale=this.paused?0:t,this.stopWarping()},getEffectiveTimeScale:function(){return this._effectiveTimeScale},setDuration:function(t){return this.timeScale=this._clip.duration/t,this.stopWarping()},syncWith:function(t){return this.time=t.time,this.timeScale=t.timeScale,this.stopWarping()},halt:function(t){return this.warp(this._effectiveTimeScale,0,t)},warp:function(t,e,i){var r=this._mixer,n=r.time,o=this._timeScaleInterpolant,a=this.timeScale;null===o&&(o=r._lendControlInterpolant(),this._timeScaleInterpolant=o);var s=o.parameterPositions,c=o.sampleValues;return s[0]=n,s[1]=n+i,c[0]=t/a,c[1]=e/a,this},stopWarping:function(){var t=this._timeScaleInterpolant;return null!==t&&(this._timeScaleInterpolant=null,this._mixer._takeBackControlInterpolant(t)),this},getMixer:function(){return this._mixer},getClip:function(){return this._clip},getRoot:function(){return this._localRoot||this._mixer._root},_update:function(t,e,i,r){if(this.enabled){var n=this._startTime;if(null!==n){var o=(t-n)*i;if(o<0||0===i)return;this._startTime=null,e=i*o}e*=this._updateTimeScale(t);var a=this._updateTime(e),s=this._updateWeight(t);if(s>0)for(var c=this._interpolants,u=this._propertyBindings,h=0,l=c.length;h!==l;++h)c[h].evaluate(a),u[h].accumulate(r,s)}else this._updateWeight(t)},_updateWeight:function(t){var e=0;if(this.enabled){e=this.weight;var i=this._weightInterpolant;if(null!==i){var r=i.evaluate(t)[0];e*=r,t>i.parameterPositions[1]&&(this.stopFading(),0===r&&(this.enabled=!1))}}return this._effectiveWeight=e,e},_updateTimeScale:function(t){var e=0;if(!this.paused){e=this.timeScale;var i=this._timeScaleInterpolant;if(null!==i)e*=i.evaluate(t)[0],t>i.parameterPositions[1]&&(this.stopWarping(),0===e?this.paused=!0:this.timeScale=e)}return this._effectiveTimeScale=e,e},_updateTime:function(t){var e=this.time+t;if(0===t)return e;var i=this._clip.duration,r=this.loop,n=this._loopCount;if(2200===r){-1===n&&(this._loopCount=0,this._setEndings(!0,!0,!1));t:{if(e>=i)e=i;else{if(!(e<0))break t;e=0}this.clampWhenFinished?this.paused=!0:this.enabled=!1,this._mixer.dispatchEvent({type:"finished",action:this,direction:t<0?-1:1})}}else{var o=2202===r;if(-1===n&&(t>=0?(n=0,this._setEndings(!0,0===this.repetitions,o)):this._setEndings(0===this.repetitions,!0,o)),e>=i||e<0){var a=Math.floor(e/i);e-=i*a,n+=Math.abs(a);var s=this.repetitions-n;if(s<0)this.clampWhenFinished?this.paused=!0:this.enabled=!1,e=t>0?i:0,this._mixer.dispatchEvent({type:"finished",action:this,direction:t>0?1:-1});else{if(0===s){var c=t<0;this._setEndings(c,!c,o)}else this._setEndings(!1,!1,o);this._loopCount=n,this._mixer.dispatchEvent({type:"loop",action:this,loopDelta:a})}}if(o&&1==(1&n))return this.time=e,i-e}return this.time=e,e},_setEndings:function(t,e,i){var r=this._interpolantSettings;i?(r.endingStart=Ee,r.endingEnd=Ee):(r.endingStart=t?this.zeroSlopeAtStart?Ee:Te:2402,r.endingEnd=e?this.zeroSlopeAtEnd?Ee:Te:2402)},_scheduleFading:function(t,e,i){var r=this._mixer,n=r.time,o=this._weightInterpolant;null===o&&(o=r._lendControlInterpolant(),this._weightInterpolant=o);var a=o.parameterPositions,s=o.sampleValues;return a[0]=n,s[0]=e,a[1]=n+t,s[1]=i,this}}),Hu.prototype=Object.assign(Object.create(v.prototype),{constructor:Hu,_bindAction:function(t,e){var i=t._localRoot||this._root,r=t._clip.tracks,n=r.length,o=t._propertyBindings,a=t._interpolants,s=i.uuid,c=this._bindingsByRootAndName,u=c[s];void 0===u&&(u={},c[s]=u);for(var h=0;h!==n;++h){var l=r[h],p=l.name,d=u[p];if(void 0!==d)o[h]=d;else{if(void 0!==(d=o[h])){null===d._cacheIndex&&(++d.referenceCount,this._addInactiveBinding(d,s,p));continue}var f=e&&e._propertyBindings[h].binding.parsedPath;++(d=new Uu(Gu.create(i,p,f),l.ValueTypeName,l.getValueSize())).referenceCount,this._addInactiveBinding(d,s,p),o[h]=d}a[h].resultBuffer=d.buffer}},_activateAction:function(t){if(!this._isActiveAction(t)){if(null===t._cacheIndex){var e=(t._localRoot||this._root).uuid,i=t._clip.uuid,r=this._actionsByClip[i];this._bindAction(t,r&&r.knownActions[0]),this._addInactiveAction(t,i,e)}for(var n=t._propertyBindings,o=0,a=n.length;o!==a;++o){var s=n[o];0==s.useCount++&&(this._lendBinding(s),s.saveOriginalState())}this._lendAction(t)}},_deactivateAction:function(t){if(this._isActiveAction(t)){for(var e=t._propertyBindings,i=0,r=e.length;i!==r;++i){var n=e[i];0==--n.useCount&&(n.restoreOriginalState(),this._takeBackBinding(n))}this._takeBackAction(t)}},_initMemoryManager:function(){this._actions=[],this._nActiveActions=0,this._actionsByClip={},this._bindings=[],this._nActiveBindings=0,this._bindingsByRootAndName={},this._controlInterpolants=[],this._nActiveControlInterpolants=0;var t=this;this.stats={actions:{get total(){return t._actions.length},get inUse(){return t._nActiveActions}},bindings:{get total(){return t._bindings.length},get inUse(){return t._nActiveBindings}},controlInterpolants:{get total(){return t._controlInterpolants.length},get inUse(){return t._nActiveControlInterpolants}}}},_isActiveAction:function(t){var e=t._cacheIndex;return null!==e&&e<this._nActiveActions},_addInactiveAction:function(t,e,i){var r=this._actions,n=this._actionsByClip,o=n[e];if(void 0===o)o={knownActions:[t],actionByRoot:{}},t._byClipCacheIndex=0,n[e]=o;else{var a=o.knownActions;t._byClipCacheIndex=a.length,a.push(t)}t._cacheIndex=r.length,r.push(t),o.actionByRoot[i]=t},_removeInactiveAction:function(t){var e=this._actions,i=e[e.length-1],r=t._cacheIndex;i._cacheIndex=r,e[r]=i,e.pop(),t._cacheIndex=null;var n=t._clip.uuid,o=this._actionsByClip,a=o[n],s=a.knownActions,c=s[s.length-1],u=t._byClipCacheIndex;c._byClipCacheIndex=u,s[u]=c,s.pop(),t._byClipCacheIndex=null,delete a.actionByRoot[(t._localRoot||this._root).uuid],0===s.length&&delete o[n],this._removeInactiveBindingsForAction(t)},_removeInactiveBindingsForAction:function(t){for(var e=t._propertyBindings,i=0,r=e.length;i!==r;++i){var n=e[i];0==--n.referenceCount&&this._removeInactiveBinding(n)}},_lendAction:function(t){var e=this._actions,i=t._cacheIndex,r=this._nActiveActions++,n=e[r];t._cacheIndex=r,e[r]=t,n._cacheIndex=i,e[i]=n},_takeBackAction:function(t){var e=this._actions,i=t._cacheIndex,r=--this._nActiveActions,n=e[r];t._cacheIndex=r,e[r]=t,n._cacheIndex=i,e[i]=n},_addInactiveBinding:function(t,e,i){var r=this._bindingsByRootAndName,n=r[e],o=this._bindings;void 0===n&&(n={},r[e]=n),n[i]=t,t._cacheIndex=o.length,o.push(t)},_removeInactiveBinding:function(t){var e=this._bindings,i=t.binding,r=i.rootNode.uuid,n=i.path,o=this._bindingsByRootAndName,a=o[r],s=e[e.length-1],c=t._cacheIndex;s._cacheIndex=c,e[c]=s,e.pop(),delete a[n];t:{for(var u in a)break t;delete o[r]}},_lendBinding:function(t){var e=this._bindings,i=t._cacheIndex,r=this._nActiveBindings++,n=e[r];t._cacheIndex=r,e[r]=t,n._cacheIndex=i,e[i]=n},_takeBackBinding:function(t){var e=this._bindings,i=t._cacheIndex,r=--this._nActiveBindings,n=e[r];t._cacheIndex=r,e[r]=t,n._cacheIndex=i,e[i]=n},_lendControlInterpolant:function(){var t=this._controlInterpolants,e=this._nActiveControlInterpolants++,i=t[e];return void 0===i&&((i=new Sc(new Float32Array(2),new Float32Array(2),1,this._controlInterpolantsResultBuffer)).__cacheIndex=e,t[e]=i),i},_takeBackControlInterpolant:function(t){var e=this._controlInterpolants,i=t.__cacheIndex,r=--this._nActiveControlInterpolants,n=e[r];t.__cacheIndex=r,e[r]=t,n.__cacheIndex=i,e[i]=n},_controlInterpolantsResultBuffer:new Float32Array(1),clipAction:function(t,e){var i=e||this._root,r=i.uuid,n="string"==typeof t?Ec.findByName(i,t):t,o=null!==n?n.uuid:t,a=this._actionsByClip[o],s=null;if(void 0!==a){var c=a.actionByRoot[r];if(void 0!==c)return c;s=a.knownActions[0],null===n&&(n=s._clip)}if(null===n)return null;var u=new Vu(this,n,e);return this._bindAction(u,s),this._addInactiveAction(u,o,r),u},existingAction:function(t,e){var i=e||this._root,r=i.uuid,n="string"==typeof t?Ec.findByName(i,t):t,o=n?n.uuid:t,a=this._actionsByClip[o];return void 0!==a&&a.actionByRoot[r]||null},stopAllAction:function(){var t=this._actions,e=this._nActiveActions,i=this._bindings,r=this._nActiveBindings;this._nActiveActions=0,this._nActiveBindings=0;for(var n=0;n!==e;++n)t[n].reset();for(n=0;n!==r;++n)i[n].useCount=0;return this},update:function(t){t*=this.timeScale;for(var e=this._actions,i=this._nActiveActions,r=this.time+=t,n=Math.sign(t),o=this._accuIndex^=1,a=0;a!==i;++a){e[a]._update(r,t,n,o)}var s=this._bindings,c=this._nActiveBindings;for(a=0;a!==c;++a)s[a].apply(o);return this},getRoot:function(){return this._root},uncacheClip:function(t){var e=this._actions,i=t.uuid,r=this._actionsByClip,n=r[i];if(void 0!==n){for(var o=n.knownActions,a=0,s=o.length;a!==s;++a){var c=o[a];this._deactivateAction(c);var u=c._cacheIndex,h=e[e.length-1];c._cacheIndex=null,c._byClipCacheIndex=null,h._cacheIndex=u,e[u]=h,e.pop(),this._removeInactiveBindingsForAction(c)}delete r[i]}},uncacheRoot:function(t){var e=t.uuid,i=this._actionsByClip;for(var r in i){var n=i[r].actionByRoot[e];void 0!==n&&(this._deactivateAction(n),this._removeInactiveAction(n))}var o=this._bindingsByRootAndName[e];if(void 0!==o)for(var a in o){var s=o[a];s.restoreOriginalState(),this._removeInactiveBinding(s)}},uncacheAction:function(t,e){var i=this.existingAction(t,e);null!==i&&(this._deactivateAction(i),this._removeInactiveAction(i))}}),$u.prototype.clone=function(){return new $u(void 0===this.value.clone?this.value:this.value.clone())},Wu.prototype=Object.assign(Object.create(Qn.prototype),{constructor:Wu,isInstancedBufferGeometry:!0,copy:function(t){return Qn.prototype.copy.call(this,t),this.maxInstancedCount=t.maxInstancedCount,this},clone:function(){return(new this.constructor).copy(this)}}),Object.defineProperties(Xu.prototype,{count:{get:function(){return this.data.count}},array:{get:function(){return this.data.array}}}),Object.assign(Xu.prototype,{isInterleavedBufferAttribute:!0,setX:function(t,e){return this.data.array[t*this.data.stride+this.offset]=e,this},setY:function(t,e){return this.data.array[t*this.data.stride+this.offset+1]=e,this},setZ:function(t,e){return this.data.array[t*this.data.stride+this.offset+2]=e,this},setW:function(t,e){return this.data.array[t*this.data.stride+this.offset+3]=e,this},getX:function(t){return this.data.array[t*this.data.stride+this.offset]},getY:function(t){return this.data.array[t*this.data.stride+this.offset+1]},getZ:function(t){return this.data.array[t*this.data.stride+this.offset+2]},getW:function(t){return this.data.array[t*this.data.stride+this.offset+3]},setXY:function(t,e,i){return t=t*this.data.stride+this.offset,this.data.array[t+0]=e,this.data.array[t+1]=i,this},setXYZ:function(t,e,i,r){return t=t*this.data.stride+this.offset,this.data.array[t+0]=e,this.data.array[t+1]=i,this.data.array[t+2]=r,this},setXYZW:function(t,e,i,r,n){return t=t*this.data.stride+this.offset,this.data.array[t+0]=e,this.data.array[t+1]=i,this.data.array[t+2]=r,this.data.array[t+3]=n,this}}),Object.defineProperty(qu.prototype,"needsUpdate",{set:function(t){!0===t&&this.version++}}),Object.assign(qu.prototype,{isInterleavedBuffer:!0,setArray:function(t){if(Array.isArray(t))throw new TypeError("THREE.BufferAttribute: array should be a Typed Array.");this.count=void 0!==t?t.length/this.stride:0,this.array=t},setDynamic:function(t){return this.dynamic=t,this},copy:function(t){return this.array=new t.array.constructor(t.array),this.count=t.count,this.stride=t.stride,this.dynamic=t.dynamic,this},copyAt:function(t,e,i){t*=this.stride,i*=e.stride;for(var r=0,n=this.stride;r<n;r++)this.array[t+r]=e.array[i+r];return this},set:function(t,e){return void 0===e&&(e=0),this.array.set(t,e),this},clone:function(){return(new this.constructor).copy(this)},onUpload:function(t){return this.onUploadCallback=t,this}}),Yu.prototype=Object.assign(Object.create(qu.prototype),{constructor:Yu,isInstancedInterleavedBuffer:!0,copy:function(t){return qu.prototype.copy.call(this,t),this.meshPerAttribute=t.meshPerAttribute,this}}),Zu.prototype=Object.assign(Object.create(sn.prototype),{constructor:Zu,isInstancedBufferAttribute:!0,copy:function(t){return sn.prototype.copy.call(this,t),this.meshPerAttribute=t.meshPerAttribute,this}}),Object.assign(function(t,e,i,r){this.ray=new ao(t,e),this.near=i||0,this.far=r||1/0,this.params={Mesh:{},Line:{},LOD:{},Points:{threshold:1},Sprite:{}},Object.defineProperties(this.params,{PointCloud:{get:function(){return console.warn("THREE.Raycaster: params.PointCloud has been renamed to params.Points."),this.Points}}})}.prototype,{linePrecision:1,set:function(t,e){this.ray.set(t,e)},setFromCamera:function(t,e){e&&e.isPerspectiveCamera?(this.ray.origin.setFromMatrixPosition(e.matrixWorld),this.ray.direction.set(t.x,t.y,.5).unproject(e).sub(this.ray.origin).normalize()):e&&e.isOrthographicCamera?(this.ray.origin.set(t.x,t.y,(e.near+e.far)/(e.near-e.far)).unproject(e),this.ray.direction.set(0,0,-1).transformDirection(e.matrixWorld)):console.error("THREE.Raycaster: Unsupported camera type.")},intersectObject:function(t,e){var i=[];return Ju(t,this,i,e),i.sort(Ku),i},intersectObjects:function(t,e){var i=[];if(!1===Array.isArray(t))return console.warn("THREE.Raycaster.intersectObjects: objects is not an Array."),i;for(var r=0,n=t.length;r<n;r++)Ju(t[r],this,i,e);return i.sort(Ku),i}}),Object.assign(function(t){this.autoStart=void 0===t||t,this.startTime=0,this.oldTime=0,this.elapsedTime=0,this.running=!1}.prototype,{start:function(){this.startTime=("undefined"==typeof performance?Date:performance).now(),this.oldTime=this.startTime,this.elapsedTime=0,this.running=!0},stop:function(){this.getElapsedTime(),this.running=!1,this.autoStart=!1},getElapsedTime:function(){return this.getDelta(),this.elapsedTime},getDelta:function(){var t=0;if(this.autoStart&&!this.running)return this.start(),0;if(this.running){var e=("undefined"==typeof performance?Date:performance).now();t=(e-this.oldTime)/1e3,this.oldTime=e,this.elapsedTime+=t}return t}}),Object.assign(function(t,e,i){return this.radius=void 0!==t?t:1,this.phi=void 0!==e?e:0,this.theta=void 0!==i?i:0,this}.prototype,{set:function(t,e,i){return this.radius=t,this.phi=e,this.theta=i,this},clone:function(){return(new this.constructor).copy(this)},copy:function(t){return this.radius=t.radius,this.phi=t.phi,this.theta=t.theta,this},makeSafe:function(){return this.phi=Math.max(1e-6,Math.min(Math.PI-1e-6,this.phi)),this},setFromVector3:function(t){return this.radius=t.length(),0===this.radius?(this.theta=0,this.phi=0):(this.theta=Math.atan2(t.x,t.z),this.phi=Math.acos(je.clamp(t.y/this.radius,-1,1))),this}}),Object.assign(function(t,e,i){return this.radius=void 0!==t?t:1,this.theta=void 0!==e?e:0,this.y=void 0!==i?i:0,this}.prototype,{set:function(t,e,i){return this.radius=t,this.theta=e,this.y=i,this},clone:function(){return(new this.constructor).copy(this)},copy:function(t){return this.radius=t.radius,this.theta=t.theta,this.y=t.y,this},setFromVector3:function(t){return this.radius=Math.sqrt(t.x*t.x+t.z*t.z),this.theta=Math.atan2(t.x,t.z),this.y=t.y,this}}),Qu.prototype=Object.create(qr.prototype),Qu.prototype.constructor=Qu,Qu.prototype.isImmediateRenderObject=!0,th.prototype=Object.create(ra.prototype),th.prototype.constructor=th,th.prototype.update=(uu=new $e,hu=new $e,lu=new We,function(){var t=["a","b","c"];this.object.updateMatrixWorld(!0),lu.getNormalMatrix(this.object.matrixWorld);var e=this.object.matrixWorld,i=this.geometry.attributes.position,r=this.object.geometry;if(r&&r.isGeometry)for(var n=r.vertices,o=r.faces,a=0,s=0,c=o.length;s<c;s++)for(var u=o[s],h=0,l=u.vertexNormals.length;h<l;h++){var p=n[u[t[h]]],d=u.vertexNormals[h];uu.copy(p).applyMatrix4(e),hu.copy(d).applyMatrix3(lu).normalize().multiplyScalar(this.size).add(uu),i.setXYZ(a,uu.x,uu.y,uu.z),a+=1,i.setXYZ(a,hu.x,hu.y,hu.z),a+=1}else if(r&&r.isBufferGeometry){var f=r.attributes.position,m=r.attributes.normal;for(a=0,h=0,l=f.count;h<l;h++)uu.set(f.getX(h),f.getY(h),f.getZ(h)).applyMatrix4(e),hu.set(m.getX(h),m.getY(h),m.getZ(h)),hu.applyMatrix3(lu).normalize().multiplyScalar(this.size).add(uu),i.setXYZ(a,uu.x,uu.y,uu.z),a+=1,i.setXYZ(a,hu.x,hu.y,hu.z),a+=1}i.needsUpdate=!0}),eh.prototype=Object.create(qr.prototype),eh.prototype.constructor=eh,eh.prototype.dispose=function(){this.cone.geometry.dispose(),this.cone.material.dispose()},eh.prototype.update=(pu=new $e,du=new $e,function(){this.light.updateMatrixWorld();var t=this.light.distance?this.light.distance:1e3,e=t*Math.tan(this.light.angle);this.cone.scale.set(e,e,t),pu.setFromMatrixPosition(this.light.matrixWorld),du.setFromMatrixPosition(this.light.target.matrixWorld),this.cone.lookAt(du.sub(pu)),void 0!==this.color?this.cone.material.color.set(this.color):this.cone.material.color.copy(this.light.color)}),ih.prototype=Object.create(ra.prototype),ih.prototype.constructor=ih,ih.prototype.updateMatrixWorld=(fu=new $e,mu=new Ve,gu=new Ve,function(t){var e=this.bones,i=this.geometry,r=i.getAttribute("position");gu.getInverse(this.root.matrixWorld);for(var n=0,o=0;n<e.length;n++){var a=e[n];a.parent&&a.parent.isBone&&(mu.multiplyMatrices(gu,a.matrixWorld),fu.setFromMatrixPosition(mu),r.setXYZ(o,fu.x,fu.y,fu.z),mu.multiplyMatrices(gu,a.parent.matrixWorld),fu.setFromMatrixPosition(mu),r.setXYZ(o+1,fu.x,fu.y,fu.z),o+=2)}i.getAttribute("position").needsUpdate=!0,qr.prototype.updateMatrixWorld.call(this,t)}),rh.prototype=Object.create(uo.prototype),rh.prototype.constructor=rh,rh.prototype.dispose=function(){this.geometry.dispose(),this.material.dispose()},rh.prototype.update=function(){void 0!==this.color?this.material.color.set(this.color):this.material.color.copy(this.light.color)},nh.prototype=Object.create(qr.prototype),nh.prototype.constructor=nh,nh.prototype.dispose=function(){this.children[0].geometry.dispose(),this.children[0].material.dispose()},nh.prototype.update=function(){var t=.5*this.light.width,e=.5*this.light.height,i=this.line.geometry.attributes.position,r=i.array;r[0]=t,r[1]=-e,r[2]=0,r[3]=t,r[4]=e,r[5]=0,r[6]=-t,r[7]=e,r[8]=0,r[9]=-t,r[10]=-e,r[11]=0,r[12]=t,r[13]=-e,r[14]=0,i.needsUpdate=!0,void 0!==this.color?this.line.material.color.set(this.color):this.line.material.color.copy(this.light.color)},oh.prototype=Object.create(qr.prototype),oh.prototype.constructor=oh,oh.prototype.dispose=function(){this.children[0].geometry.dispose(),this.children[0].material.dispose()},oh.prototype.update=(vu=new $e,yu=new Gi,bu=new Gi,function(){var t=this.children[0];if(void 0!==this.color)this.material.color.set(this.color);else{var e=t.geometry.getAttribute("color");yu.copy(this.light.color),bu.copy(this.light.groundColor);for(var i=0,r=e.count;i<r;i++){var n=i<r/2?yu:bu;e.setXYZ(i,n.r,n.g,n.b)}e.needsUpdate=!0}t.lookAt(vu.setFromMatrixPosition(this.light.matrixWorld).negate())}),ah.prototype=Object.create(ra.prototype),ah.prototype.constructor=ah,sh.prototype=Object.create(ra.prototype),sh.prototype.constructor=sh,ch.prototype=Object.create(ra.prototype),ch.prototype.constructor=ch,ch.prototype.update=(xu=new $e,_u=new $e,wu=new We,function(){this.object.updateMatrixWorld(!0),wu.getNormalMatrix(this.object.matrixWorld);for(var t=this.object.matrixWorld,e=this.geometry.attributes.position,i=this.object.geometry,r=i.vertices,n=i.faces,o=0,a=0,s=n.length;a<s;a++){var c=n[a],u=c.normal;xu.copy(r[c.a]).add(r[c.b]).add(r[c.c]).divideScalar(3).applyMatrix4(t),_u.copy(u).applyMatrix3(wu).normalize().multiplyScalar(this.size).add(xu),e.setXYZ(o,xu.x,xu.y,xu.z),o+=1,e.setXYZ(o,_u.x,_u.y,_u.z),o+=1}e.needsUpdate=!0}),uh.prototype=Object.create(qr.prototype),uh.prototype.constructor=uh,uh.prototype.dispose=function(){this.lightPlane.geometry.dispose(),this.lightPlane.material.dispose(),this.targetLine.geometry.dispose(),this.targetLine.material.dispose()},uh.prototype.update=(Su=new $e,Au=new $e,Mu=new $e,function(){Su.setFromMatrixPosition(this.light.matrixWorld),Au.setFromMatrixPosition(this.light.target.matrixWorld),Mu.subVectors(Au,Su),this.lightPlane.lookAt(Mu),void 0!==this.color?(this.lightPlane.material.color.set(this.color),this.targetLine.material.color.set(this.color)):(this.lightPlane.material.color.copy(this.light.color),this.targetLine.material.color.copy(this.light.color)),this.targetLine.lookAt(Mu),this.targetLine.scale.z=Mu.length()}),hh.prototype=Object.create(ra.prototype),hh.prototype.constructor=hh,hh.prototype.update=function(){var t,e,i=new $e,r=new Yr;function n(n,o,a,s){i.set(o,a,s).unproject(r);var c=e[n];if(void 0!==c)for(var u=t.getAttribute("position"),h=0,l=c.length;h<l;h++)u.setXYZ(c[h],i.x,i.y,i.z)}return function(){t=this.geometry,e=this.pointMap;r.projectionMatrix.copy(this.camera.projectionMatrix),n("c",0,0,-1),n("t",0,0,1),n("n1",-1,-1,-1),n("n2",1,-1,-1),n("n3",-1,1,-1),n("n4",1,1,-1),n("f1",-1,-1,1),n("f2",1,-1,1),n("f3",-1,1,1),n("f4",1,1,1),n("u1",.7,1.1,-1),n("u2",-.7,1.1,-1),n("u3",0,2,-1),n("cf1",-1,0,1),n("cf2",1,0,1),n("cf3",0,-1,1),n("cf4",0,1,1),n("cn1",-1,0,-1),n("cn2",1,0,-1),n("cn3",0,-1,-1),n("cn4",0,1,-1),t.getAttribute("position").needsUpdate=!0}}(),lh.prototype=Object.create(ra.prototype),lh.prototype.constructor=lh,lh.prototype.update=(Pu=new xr,function(t){if(void 0!==t&&console.warn("THREE.BoxHelper: .update() has no longer arguments."),void 0!==this.object&&Pu.setFromObject(this.object),!Pu.isEmpty()){var e=Pu.min,i=Pu.max,r=this.geometry.attributes.position,n=r.array;n[0]=i.x,n[1]=i.y,n[2]=i.z,n[3]=e.x,n[4]=i.y,n[5]=i.z,n[6]=e.x,n[7]=e.y,n[8]=i.z,n[9]=i.x,n[10]=e.y,n[11]=i.z,n[12]=i.x,n[13]=i.y,n[14]=e.z,n[15]=e.x,n[16]=i.y,n[17]=e.z,n[18]=e.x,n[19]=e.y,n[20]=e.z,n[21]=i.x,n[22]=e.y,n[23]=e.z,r.needsUpdate=!0,this.geometry.computeBoundingSphere()}}),lh.prototype.setFromObject=function(t){return this.object=t,this.update(),this},ph.prototype=Object.create(ra.prototype),ph.prototype.constructor=ph,ph.prototype.updateMatrixWorld=function(t){var e=this.box;e.isEmpty()||(e.getCenter(this.position),e.getSize(this.scale),this.scale.multiplyScalar(.5),qr.prototype.updateMatrixWorld.call(this,t))},dh.prototype=Object.create(ia.prototype),dh.prototype.constructor=dh,dh.prototype.updateMatrixWorld=function(t){var e=-this.plane.constant;Math.abs(e)<1e-8&&(e=1e-8),this.scale.set(.5*this.size,.5*this.size,e),this.lookAt(this.plane.normal),qr.prototype.updateMatrixWorld.call(this,t)},fh.prototype=Object.create(qr.prototype),fh.prototype.constructor=fh,fh.prototype.setDirection=(Iu=new $e,function(t){t.y>.99999?this.quaternion.set(0,0,0,1):t.y<-.99999?this.quaternion.set(1,0,0,0):(Iu.set(t.z,0,-t.x).normalize(),Cu=Math.acos(t.y),this.quaternion.setFromAxisAngle(Iu,Cu))}),fh.prototype.setLength=function(t,e,i){void 0===e&&(e=.2*t),void 0===i&&(i=.2*e),this.line.scale.set(1,Math.max(0,t-e),1),this.line.updateMatrix(),this.cone.scale.set(i,e,i),this.cone.position.y=t,this.cone.updateMatrix()},fh.prototype.setColor=function(t){this.line.material.color.copy(t),this.cone.material.color.copy(t)},mh.prototype=Object.create(ra.prototype),mh.prototype.constructor=mh,Ns.create=function(t,e){return console.log("THREE.Curve.create() has been deprecated"),t.prototype=Object.create(Ns.prototype),t.prototype.constructor=t,t.prototype.getPoint=e,t},Object.assign(ic.prototype,{createPointsGeometry:function(t){console.warn("THREE.CurvePath: .createPointsGeometry() has been removed. Use new THREE.Geometry().setFromPoints( points ) instead.");var e=this.getPoints(t);return this.createGeometry(e)},createSpacedPointsGeometry:function(t){console.warn("THREE.CurvePath: .createSpacedPointsGeometry() has been removed. Use new THREE.Geometry().setFromPoints( points ) instead.");var e=this.getSpacedPoints(t);return this.createGeometry(e)},createGeometry:function(t){console.warn("THREE.CurvePath: .createGeometry() has been removed. Use new THREE.Geometry().setFromPoints( points ) instead.");for(var e=new an,i=0,r=t.length;i<r;i++){var n=t[i];e.vertices.push(new $e(n.x,n.y,n.z||0))}return e}}),Object.assign(rc.prototype,{fromPoints:function(t){console.warn("THREE.Path: .fromPoints() has been renamed to .setFromPoints()."),this.setFromPoints(t)}}),gh.prototype=Object.create(Hs.prototype),Object.assign(gh.prototype,{initFromArray:function(){console.error("THREE.Spline: .initFromArray() has been removed.")},getControlPointsArray:function(){console.error("THREE.Spline: .getControlPointsArray() has been removed.")},reparametrizeByArcLength:function(){console.error("THREE.Spline: .reparametrizeByArcLength() has been removed.")}}),ah.prototype.setColors=function(){console.error("THREE.GridHelper: setColors() has been deprecated, pass them in the constructor instead.")},ih.prototype.update=function(){console.error("THREE.SkeletonHelper: update() no longer needs to be called.")},Object.assign(Nc.prototype,{extractUrlBase:function(t){return console.warn("THREE.Loader: .extractUrlBase() has been deprecated. Use THREE.LoaderUtils.extractUrlBase() instead."),Fc(t)}}),Object.assign(Yi.prototype,{center:function(t){return console.warn("THREE.Box2: .center() has been renamed to .getCenter()."),this.getCenter(t)},empty:function(){return console.warn("THREE.Box2: .empty() has been renamed to .isEmpty()."),this.isEmpty()},isIntersectionBox:function(t){return console.warn("THREE.Box2: .isIntersectionBox() has been renamed to .intersectsBox()."),this.intersectsBox(t)},size:function(t){return console.warn("THREE.Box2: .size() has been renamed to .getSize()."),this.getSize(t)}}),Object.assign(xr.prototype,{center:function(t){return console.warn("THREE.Box3: .center() has been renamed to .getCenter()."),this.getCenter(t)},empty:function(){return console.warn("THREE.Box3: .empty() has been renamed to .isEmpty()."),this.isEmpty()},isIntersectionBox:function(t){return console.warn("THREE.Box3: .isIntersectionBox() has been renamed to .intersectsBox()."),this.intersectsBox(t)},isIntersectionSphere:function(t){return console.warn("THREE.Box3: .isIntersectionSphere() has been renamed to .intersectsSphere()."),this.intersectsSphere(t)},size:function(t){return console.warn("THREE.Box3: .size() has been renamed to .getSize()."),this.getSize(t)}}),so.prototype.center=function(t){return console.warn("THREE.Line3: .center() has been renamed to .getCenter()."),this.getCenter(t)},Object.assign(je,{random16:function(){return console.warn("THREE.Math: .random16() has been deprecated. Use Math.random() instead."),Math.random()},nearestPowerOfTwo:function(t){return console.warn("THREE.Math: .nearestPowerOfTwo() has been renamed to .floorPowerOfTwo()."),je.floorPowerOfTwo(t)},nextPowerOfTwo:function(t){return console.warn("THREE.Math: .nextPowerOfTwo() has been renamed to .ceilPowerOfTwo()."),je.ceilPowerOfTwo(t)}}),Object.assign(We.prototype,{flattenToArrayOffset:function(t,e){return console.warn("THREE.Matrix3: .flattenToArrayOffset() has been deprecated. Use .toArray() instead."),this.toArray(t,e)},multiplyVector3:function(t){return console.warn("THREE.Matrix3: .multiplyVector3() has been removed. Use vector.applyMatrix3( matrix ) instead."),t.applyMatrix3(this)},multiplyVector3Array:function(){console.error("THREE.Matrix3: .multiplyVector3Array() has been removed.")},applyToBuffer:function(t){return console.warn("THREE.Matrix3: .applyToBuffer() has been removed. Use matrix.applyToBufferAttribute( attribute ) instead."),this.applyToBufferAttribute(t)},applyToVector3Array:function(){console.error("THREE.Matrix3: .applyToVector3Array() has been removed.")}}),Object.assign(Ve.prototype,{extractPosition:function(t){return console.warn("THREE.Matrix4: .extractPosition() has been renamed to .copyPosition()."),this.copyPosition(t)},flattenToArrayOffset:function(t,e){return console.warn("THREE.Matrix4: .flattenToArrayOffset() has been deprecated. Use .toArray() instead."),this.toArray(t,e)},getPosition:function(){return void 0===Ru&&(Ru=new $e),console.warn("THREE.Matrix4: .getPosition() has been removed. Use Vector3.setFromMatrixPosition( matrix ) instead."),Ru.setFromMatrixColumn(this,3)},setRotationFromQuaternion:function(t){return console.warn("THREE.Matrix4: .setRotationFromQuaternion() has been renamed to .makeRotationFromQuaternion()."),this.makeRotationFromQuaternion(t)},multiplyToArray:function(){console.warn("THREE.Matrix4: .multiplyToArray() has been removed.")},multiplyVector3:function(t){return console.warn("THREE.Matrix4: .multiplyVector3() has been removed. Use vector.applyMatrix4( matrix ) instead."),t.applyMatrix4(this)},multiplyVector4:function(t){return console.warn("THREE.Matrix4: .multiplyVector4() has been removed. Use vector.applyMatrix4( matrix ) instead."),t.applyMatrix4(this)},multiplyVector3Array:function(){console.error("THREE.Matrix4: .multiplyVector3Array() has been removed.")},rotateAxis:function(t){console.warn("THREE.Matrix4: .rotateAxis() has been removed. Use Vector3.transformDirection( matrix ) instead."),t.transformDirection(this)},crossVector:function(t){return console.warn("THREE.Matrix4: .crossVector() has been removed. Use vector.applyMatrix4( matrix ) instead."),t.applyMatrix4(this)},translate:function(){console.error("THREE.Matrix4: .translate() has been removed.")},rotateX:function(){console.error("THREE.Matrix4: .rotateX() has been removed.")},rotateY:function(){console.error("THREE.Matrix4: .rotateY() has been removed.")},rotateZ:function(){console.error("THREE.Matrix4: .rotateZ() has been removed.")},rotateByAxis:function(){console.error("THREE.Matrix4: .rotateByAxis() has been removed.")},applyToBuffer:function(t){return console.warn("THREE.Matrix4: .applyToBuffer() has been removed. Use matrix.applyToBufferAttribute( attribute ) instead."),this.applyToBufferAttribute(t)},applyToVector3Array:function(){console.error("THREE.Matrix4: .applyToVector3Array() has been removed.")},makeFrustum:function(t,e,i,r,n,o){return console.warn("THREE.Matrix4: .makeFrustum() has been removed. Use .makePerspective( left, right, top, bottom, near, far ) instead."),this.makePerspective(t,e,r,i,n,o)}}),wr.prototype.isIntersectionLine=function(t){return console.warn("THREE.Plane: .isIntersectionLine() has been renamed to .intersectsLine()."),this.intersectsLine(t)},He.prototype.multiplyVector3=function(t){return console.warn("THREE.Quaternion: .multiplyVector3() has been removed. Use is now vector.applyQuaternion( quaternion ) instead."),t.applyQuaternion(this)},Object.assign(ao.prototype,{isIntersectionBox:function(t){return console.warn("THREE.Ray: .isIntersectionBox() has been renamed to .intersectsBox()."),this.intersectsBox(t)},isIntersectionPlane:function(t){return console.warn("THREE.Ray: .isIntersectionPlane() has been renamed to .intersectsPlane()."),this.intersectsPlane(t)},isIntersectionSphere:function(t){return console.warn("THREE.Ray: .isIntersectionSphere() has been renamed to .intersectsSphere()."),this.intersectsSphere(t)}}),Object.assign(nc.prototype,{extractAllPoints:function(t){return console.warn("THREE.Shape: .extractAllPoints() has been removed. Use .extractPoints() instead."),this.extractPoints(t)},extrude:function(t){return console.warn("THREE.Shape: .extrude() has been removed. Use ExtrudeGeometry() instead."),new Ja(this,t)},makeGeometry:function(t){return console.warn("THREE.Shape: .makeGeometry() has been removed. Use ShapeGeometry() instead."),new cs(this,t)}}),Object.assign(Ge.prototype,{fromAttribute:function(t,e,i){return console.warn("THREE.Vector2: .fromAttribute() has been renamed to .fromBufferAttribute()."),this.fromBufferAttribute(t,e,i)},distanceToManhattan:function(t){return console.warn("THREE.Vector2: .distanceToManhattan() has been renamed to .manhattanDistanceTo()."),this.manhattanDistanceTo(t)},lengthManhattan:function(){return console.warn("THREE.Vector2: .lengthManhattan() has been renamed to .manhattanLength()."),this.manhattanLength()}}),Object.assign($e.prototype,{setEulerFromRotationMatrix:function(){console.error("THREE.Vector3: .setEulerFromRotationMatrix() has been removed. Use Euler.setFromRotationMatrix() instead.")},setEulerFromQuaternion:function(){console.error("THREE.Vector3: .setEulerFromQuaternion() has been removed. Use Euler.setFromQuaternion() instead.")},getPositionFromMatrix:function(t){return console.warn("THREE.Vector3: .getPositionFromMatrix() has been renamed to .setFromMatrixPosition()."),this.setFromMatrixPosition(t)},getScaleFromMatrix:function(t){return console.warn("THREE.Vector3: .getScaleFromMatrix() has been renamed to .setFromMatrixScale()."),this.setFromMatrixScale(t)},getColumnFromMatrix:function(t,e){return console.warn("THREE.Vector3: .getColumnFromMatrix() has been renamed to .setFromMatrixColumn()."),this.setFromMatrixColumn(e,t)},applyProjection:function(t){return console.warn("THREE.Vector3: .applyProjection() has been removed. Use .applyMatrix4( m ) instead."),this.applyMatrix4(t)},fromAttribute:function(t,e,i){return console.warn("THREE.Vector3: .fromAttribute() has been renamed to .fromBufferAttribute()."),this.fromBufferAttribute(t,e,i)},distanceToManhattan:function(t){return console.warn("THREE.Vector3: .distanceToManhattan() has been renamed to .manhattanDistanceTo()."),this.manhattanDistanceTo(t)},lengthManhattan:function(){return console.warn("THREE.Vector3: .lengthManhattan() has been renamed to .manhattanLength()."),this.manhattanLength()}}),Object.assign(Ke.prototype,{fromAttribute:function(t,e,i){return console.warn("THREE.Vector4: .fromAttribute() has been renamed to .fromBufferAttribute()."),this.fromBufferAttribute(t,e,i)},lengthManhattan:function(){return console.warn("THREE.Vector4: .lengthManhattan() has been renamed to .manhattanLength()."),this.manhattanLength()}}),an.prototype.computeTangents=function(){console.warn("THREE.Geometry: .computeTangents() has been removed.")},Object.assign(qr.prototype,{getChildByName:function(t){return console.warn("THREE.Object3D: .getChildByName() has been renamed to .getObjectByName()."),this.getObjectByName(t)},renderDepth:function(){console.warn("THREE.Object3D: .renderDepth has been removed. Use .renderOrder, instead.")},translate:function(t,e){return console.warn("THREE.Object3D: .translate() has been removed. Use .translateOnAxis( axis, distance ) instead."),this.translateOnAxis(e,t)}}),Object.defineProperties(qr.prototype,{eulerOrder:{get:function(){return console.warn("THREE.Object3D: .eulerOrder is now .rotation.order."),this.rotation.order},set:function(t){console.warn("THREE.Object3D: .eulerOrder is now .rotation.order."),this.rotation.order=t}},useQuaternion:{get:function(){console.warn("THREE.Object3D: .useQuaternion has been removed. The library now uses quaternions by default.")},set:function(){console.warn("THREE.Object3D: .useQuaternion has been removed. The library now uses quaternions by default.")}}}),Object.defineProperties(Ko.prototype,{objects:{get:function(){return console.warn("THREE.LOD: .objects has been renamed to .levels."),this.levels}}}),Object.defineProperty(Jo.prototype,"useVertexTexture",{get:function(){console.warn("THREE.Skeleton: useVertexTexture has been removed.")},set:function(){console.warn("THREE.Skeleton: useVertexTexture has been removed.")}}),Object.defineProperty(Ns.prototype,"__arcLengthDivisions",{get:function(){return console.warn("THREE.Curve: .__arcLengthDivisions is now .arcLengthDivisions."),this.arcLengthDivisions},set:function(t){console.warn("THREE.Curve: .__arcLengthDivisions is now .arcLengthDivisions."),this.arcLengthDivisions=t}}),jo.prototype.setLens=function(t,e){console.warn("THREE.PerspectiveCamera.setLens is deprecated. Use .setFocalLength and .filmGauge for a photographic setup."),void 0!==e&&(this.filmGauge=e),this.setFocalLength(t)},Object.defineProperties(oc.prototype,{onlyShadow:{set:function(){console.warn("THREE.Light: .onlyShadow has been removed.")}},shadowCameraFov:{set:function(t){console.warn("THREE.Light: .shadowCameraFov is now .shadow.camera.fov."),this.shadow.camera.fov=t}},shadowCameraLeft:{set:function(t){console.warn("THREE.Light: .shadowCameraLeft is now .shadow.camera.left."),this.shadow.camera.left=t}},shadowCameraRight:{set:function(t){console.warn("THREE.Light: .shadowCameraRight is now .shadow.camera.right."),this.shadow.camera.right=t}},shadowCameraTop:{set:function(t){console.warn("THREE.Light: .shadowCameraTop is now .shadow.camera.top."),this.shadow.camera.top=t}},shadowCameraBottom:{set:function(t){console.warn("THREE.Light: .shadowCameraBottom is now .shadow.camera.bottom."),this.shadow.camera.bottom=t}},shadowCameraNear:{set:function(t){console.warn("THREE.Light: .shadowCameraNear is now .shadow.camera.near."),this.shadow.camera.near=t}},shadowCameraFar:{set:function(t){console.warn("THREE.Light: .shadowCameraFar is now .shadow.camera.far."),this.shadow.camera.far=t}},shadowCameraVisible:{set:function(){console.warn("THREE.Light: .shadowCameraVisible has been removed. Use new THREE.CameraHelper( light.shadow.camera ) instead.")}},shadowBias:{set:function(t){console.warn("THREE.Light: .shadowBias is now .shadow.bias."),this.shadow.bias=t}},shadowDarkness:{set:function(){console.warn("THREE.Light: .shadowDarkness has been removed.")}},shadowMapWidth:{set:function(t){console.warn("THREE.Light: .shadowMapWidth is now .shadow.mapSize.width."),this.shadow.mapSize.width=t}},shadowMapHeight:{set:function(t){console.warn("THREE.Light: .shadowMapHeight is now .shadow.mapSize.height."),this.shadow.mapSize.height=t}}}),Object.defineProperties(sn.prototype,{length:{get:function(){return console.warn("THREE.BufferAttribute: .length has been deprecated. Use .count instead."),this.array.length}}}),Object.assign(Qn.prototype,{addIndex:function(t){console.warn("THREE.BufferGeometry: .addIndex() has been renamed to .setIndex()."),this.setIndex(t)},addDrawCall:function(t,e,i){void 0!==i&&console.warn("THREE.BufferGeometry: .addDrawCall() no longer supports indexOffset."),console.warn("THREE.BufferGeometry: .addDrawCall() is now .addGroup()."),this.addGroup(t,e)},clearDrawCalls:function(){console.warn("THREE.BufferGeometry: .clearDrawCalls() is now .clearGroups()."),this.clearGroups()},computeTangents:function(){console.warn("THREE.BufferGeometry: .computeTangents() has been removed.")},computeOffsets:function(){console.warn("THREE.BufferGeometry: .computeOffsets() has been removed.")}}),Object.defineProperties(Qn.prototype,{drawcalls:{get:function(){return console.error("THREE.BufferGeometry: .drawcalls has been renamed to .groups."),this.groups}},offsets:{get:function(){return console.warn("THREE.BufferGeometry: .offsets has been renamed to .groups."),this.groups}}}),Object.defineProperties($u.prototype,{dynamic:{set:function(){console.warn("THREE.Uniform: .dynamic has been removed. Use object.onBeforeRender() instead.")}},onUpdate:{value:function(){return console.warn("THREE.Uniform: .onUpdate() has been removed. Use object.onBeforeRender() instead."),this}}}),Object.defineProperties(vr.prototype,{wrapAround:{get:function(){console.warn("THREE.Material: .wrapAround has been removed.")},set:function(){console.warn("THREE.Material: .wrapAround has been removed.")}},wrapRGB:{get:function(){return console.warn("THREE.Material: .wrapRGB has been removed."),new Gi}},shading:{get:function(){console.error("THREE."+this.type+": .shading has been removed. Use the boolean .flatShading instead.")},set:function(t){console.warn("THREE."+this.type+": .shading has been removed. Use the boolean .flatShading instead."),this.flatShading=1===t}}}),Object.defineProperties(Ss.prototype,{metal:{get:function(){return console.warn("THREE.MeshPhongMaterial: .metal has been removed. Use THREE.MeshStandardMaterial instead."),!1},set:function(){console.warn("THREE.MeshPhongMaterial: .metal has been removed. Use THREE.MeshStandardMaterial instead")}}}),Object.defineProperties(oo.prototype,{derivatives:{get:function(){return console.warn("THREE.ShaderMaterial: .derivatives has been moved to .extensions.derivatives."),this.extensions.derivatives},set:function(t){console.warn("THREE. ShaderMaterial: .derivatives has been moved to .extensions.derivatives."),this.extensions.derivatives=t}}}),Object.assign(Ho.prototype,{getCurrentRenderTarget:function(){return console.warn("THREE.WebGLRenderer: .getCurrentRenderTarget() is now .getRenderTarget()."),this.getRenderTarget()},getMaxAnisotropy:function(){return console.warn("THREE.WebGLRenderer: .getMaxAnisotropy() is now .capabilities.getMaxAnisotropy()."),this.capabilities.getMaxAnisotropy()},getPrecision:function(){return console.warn("THREE.WebGLRenderer: .getPrecision() is now .capabilities.precision."),this.capabilities.precision},resetGLState:function(){return console.warn("THREE.WebGLRenderer: .resetGLState() is now .state.reset()."),this.state.reset()},supportsFloatTextures:function(){return console.warn("THREE.WebGLRenderer: .supportsFloatTextures() is now .extensions.get( 'OES_texture_float' )."),this.extensions.get("OES_texture_float")},supportsHalfFloatTextures:function(){return console.warn("THREE.WebGLRenderer: .supportsHalfFloatTextures() is now .extensions.get( 'OES_texture_half_float' )."),this.extensions.get("OES_texture_half_float")},supportsStandardDerivatives:function(){return console.warn("THREE.WebGLRenderer: .supportsStandardDerivatives() is now .extensions.get( 'OES_standard_derivatives' )."),this.extensions.get("OES_standard_derivatives")},supportsCompressedTextureS3TC:function(){return console.warn("THREE.WebGLRenderer: .supportsCompressedTextureS3TC() is now .extensions.get( 'WEBGL_compressed_texture_s3tc' )."),this.extensions.get("WEBGL_compressed_texture_s3tc")},supportsCompressedTexturePVRTC:function(){return console.warn("THREE.WebGLRenderer: .supportsCompressedTexturePVRTC() is now .extensions.get( 'WEBGL_compressed_texture_pvrtc' )."),this.extensions.get("WEBGL_compressed_texture_pvrtc")},supportsBlendMinMax:function(){return console.warn("THREE.WebGLRenderer: .supportsBlendMinMax() is now .extensions.get( 'EXT_blend_minmax' )."),this.extensions.get("EXT_blend_minmax")},supportsVertexTextures:function(){return console.warn("THREE.WebGLRenderer: .supportsVertexTextures() is now .capabilities.vertexTextures."),this.capabilities.vertexTextures},supportsInstancedArrays:function(){return console.warn("THREE.WebGLRenderer: .supportsInstancedArrays() is now .extensions.get( 'ANGLE_instanced_arrays' )."),this.extensions.get("ANGLE_instanced_arrays")},enableScissorTest:function(t){console.warn("THREE.WebGLRenderer: .enableScissorTest() is now .setScissorTest()."),this.setScissorTest(t)},initMaterial:function(){console.warn("THREE.WebGLRenderer: .initMaterial() has been removed.")},addPrePlugin:function(){console.warn("THREE.WebGLRenderer: .addPrePlugin() has been removed.")},addPostPlugin:function(){console.warn("THREE.WebGLRenderer: .addPostPlugin() has been removed.")},updateShadowMap:function(){console.warn("THREE.WebGLRenderer: .updateShadowMap() has been removed.")}}),Object.defineProperties(Ho.prototype,{shadowMapEnabled:{get:function(){return this.shadowMap.enabled},set:function(t){console.warn("THREE.WebGLRenderer: .shadowMapEnabled is now .shadowMap.enabled."),this.shadowMap.enabled=t}},shadowMapType:{get:function(){return this.shadowMap.type},set:function(t){console.warn("THREE.WebGLRenderer: .shadowMapType is now .shadowMap.type."),this.shadowMap.type=t}},shadowMapCullFace:{get:function(){return this.shadowMap.cullFace},set:function(t){console.warn("THREE.WebGLRenderer: .shadowMapCullFace is now .shadowMap.cullFace."),this.shadowMap.cullFace=t}}}),Object.defineProperties(Ar.prototype,{cullFace:{get:function(){return this.renderReverseSided?j:U},set:function(t){var e=t!==U;console.warn("WebGLRenderer: .shadowMap.cullFace is deprecated. Set .shadowMap.renderReverseSided to "+e+"."),this.renderReverseSided=e}}}),Object.defineProperties(Je.prototype,{wrapS:{get:function(){return console.warn("THREE.WebGLRenderTarget: .wrapS is now .texture.wrapS."),this.texture.wrapS},set:function(t){console.warn("THREE.WebGLRenderTarget: .wrapS is now .texture.wrapS."),this.texture.wrapS=t}},wrapT:{get:function(){return console.warn("THREE.WebGLRenderTarget: .wrapT is now .texture.wrapT."),this.texture.wrapT},set:function(t){console.warn("THREE.WebGLRenderTarget: .wrapT is now .texture.wrapT."),this.texture.wrapT=t}},magFilter:{get:function(){return console.warn("THREE.WebGLRenderTarget: .magFilter is now .texture.magFilter."),this.texture.magFilter},set:function(t){console.warn("THREE.WebGLRenderTarget: .magFilter is now .texture.magFilter."),this.texture.magFilter=t}},minFilter:{get:function(){return console.warn("THREE.WebGLRenderTarget: .minFilter is now .texture.minFilter."),this.texture.minFilter},set:function(t){console.warn("THREE.WebGLRenderTarget: .minFilter is now .texture.minFilter."),this.texture.minFilter=t}},anisotropy:{get:function(){return console.warn("THREE.WebGLRenderTarget: .anisotropy is now .texture.anisotropy."),this.texture.anisotropy},set:function(t){console.warn("THREE.WebGLRenderTarget: .anisotropy is now .texture.anisotropy."),this.texture.anisotropy=t}},offset:{get:function(){return console.warn("THREE.WebGLRenderTarget: .offset is now .texture.offset."),this.texture.offset},set:function(t){console.warn("THREE.WebGLRenderTarget: .offset is now .texture.offset."),this.texture.offset=t}},repeat:{get:function(){return console.warn("THREE.WebGLRenderTarget: .repeat is now .texture.repeat."),this.texture.repeat},set:function(t){console.warn("THREE.WebGLRenderTarget: .repeat is now .texture.repeat."),this.texture.repeat=t}},format:{get:function(){return console.warn("THREE.WebGLRenderTarget: .format is now .texture.format."),this.texture.format},set:function(t){console.warn("THREE.WebGLRenderTarget: .format is now .texture.format."),this.texture.format=t}},type:{get:function(){return console.warn("THREE.WebGLRenderTarget: .type is now .texture.type."),this.texture.type},set:function(t){console.warn("THREE.WebGLRenderTarget: .type is now .texture.type."),this.texture.type=t}},generateMipmaps:{get:function(){return console.warn("THREE.WebGLRenderTarget: .generateMipmaps is now .texture.generateMipmaps."),this.texture.generateMipmaps},set:function(t){console.warn("THREE.WebGLRenderTarget: .generateMipmaps is now .texture.generateMipmaps."),this.texture.generateMipmaps=t}}}),Object.assign(Vo.prototype,{getStandingMatrix:function(){console.warn("THREE.WebVRManager: .getStandingMatrix() has been removed.")}}),Object.defineProperties(Vo.prototype,{standing:{set:function(){console.warn("THREE.WebVRManager: .standing has been removed.")}}}),Bu.prototype.load=function(t){console.warn("THREE.Audio: .load has been deprecated. Use THREE.AudioLoader instead.");var e=this;return(new Ou).load(t,function(t){e.setBuffer(t)}),this},zu.prototype.getData=function(){return console.warn("THREE.AudioAnalyser: .getData() is now .getFrequencyData()."),this.getFrequencyData()},ku.prototype.updateCubeMap=function(t,e){return console.warn("THREE.CubeCamera: .updateCubeMap() is now .update()."),this.update(t,e)};var zh=function(t){this.name=t,this._dict={}},Uh={names:{configurable:!0}};function jh(t){return.01745*t}zh.prototype.add=function(t,e){this._dict[Fh(t)]=e},zh.prototype.get=function(t){return this._dict[Fh(t)]},Uh.names.get=function(){return Object.keys(this._dict)},Object.defineProperties(zh.prototype,Uh);var Gh="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".split(""),Vh=new Array(36);function Hh(){for(var t,e=0,i=0;i<36;i++)8===i||13===i||18===i||23===i?Vh[i]="-":14===i?Vh[i]="4":(e<=2&&(e=33554432+16777216*Math.random()|0),t=15&e,e>>=4,Vh[i]=Gh[19===i?3&t|8:t]);return Vh.join("")}function $h(t,e,i){return Math.max(e,Math.min(i,t))}function Wh(t){return $h(t,0,100)}function Xh(t,e,i){return t+(e-t)*i}function qh(t,e,i,r,n,o){var a=(i-t)*o,s=(r-e)*o,c=n*n;return(2*e-2*i+a+s)*(n*c)+(-3*e+3*i-2*a-s)*c+a*n+e}function Yh(t,e,i){var r;return(i=$h((i-(r=t))/(e-r),0,1))*i*(3-2*i)}var Zh="undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{};function Kh(t,e){return t(e={exports:{}},e.exports),e.exports}var Jh=Kh(function(t,e){(function(){var i,r,n,o,a,s,c,u,h,l,p,d,f,m,g,v,y,b,x,_,w,S,A,M,P,T,E,C,I,R,L,O,D,k,N,B,F,z,U,j,G,V,H,$,W,X,q,Y,Z,K,J,Q,tt,et,it,rt,nt,ot,at,st,ct,ut,ht,lt,pt,dt,ft,mt,gt,vt,yt,bt,xt,_t,wt,St,At,Mt,Pt,Tt,Et=[].slice;St=function(){var t,e,i,r,n;for(t={},r=0,e=(n="Boolean Number String Function Array Date RegExp Undefined Null".split(" ")).length;r<e;r++)i=n[r],t["[object "+i+"]"]=i.toLowerCase();return function(e){var i;return i=Object.prototype.toString.call(e),t[i]||"object"}}(),q=function(t,e,i){return null==e&&(e=0),null==i&&(i=1),t<e&&(t=e),t>i&&(t=i),t},At=function(t){return t.length>=3?[].slice.call(t):t[0]},w=function(t){var e,i;for(t._clipped=!1,t._unclipped=t.slice(0),e=i=0;i<3;e=++i)e<3?((t[e]<0||t[e]>255)&&(t._clipped=!0),t[e]<0&&(t[e]=0),t[e]>255&&(t[e]=255)):3===e&&(t[e]<0&&(t[e]=0),t[e]>1&&(t[e]=1));return t._clipped||delete t._unclipped,t},o=Math.PI,yt=Math.round,A=Math.cos,C=Math.floor,it=Math.pow,Y=Math.log,xt=Math.sin,_t=Math.sqrt,m=Math.atan2,J=Math.max,f=Math.abs,c=2*o,a=o/3,r=o/180,s=180/o,(_=function(){return arguments[0]instanceof i?arguments[0]:function(t,e,i){i.prototype=t.prototype;var r=new i,n=t.apply(r,e);return Object(n)===n?n:r}(i,arguments,function(){})}).default=_,d=[],null!==t&&null!=t.exports&&(t.exports=_),(null!==e?e:this).chroma=_,_.version="1.3.5",p={},h=[],l=!1,i=function(){function t(){var t,e,i,r,n,o,a,s,c=arguments;for(this,e=[],a=0,r=arguments.length;a<r;a++)null!=(t=c[a])&&e.push(t);if(e.length>1&&(o=e[e.length-1]),null!=p[o])this._rgb=w(p[o](At(e.slice(0,-1))));else{for(l||(h=h.sort(function(t,e){return e.p-t.p}),l=!0),s=0,n=h.length;s<n&&!(o=(i=h[s]).test.apply(i,e));s++);o&&(this._rgb=w(p[o].apply(p,e)))}null==this._rgb&&console.warn("unknown format: "+e),null==this._rgb&&(this._rgb=[0,0,0]),3===this._rgb.length&&this._rgb.push(1)}return t.prototype.toString=function(){return this.hex()},t.prototype.clone=function(){return _(me._rgb)},t}(),_._input=p,_.brewer=b={OrRd:["#fff7ec","#fee8c8","#fdd49e","#fdbb84","#fc8d59","#ef6548","#d7301f","#b30000","#7f0000"],PuBu:["#fff7fb","#ece7f2","#d0d1e6","#a6bddb","#74a9cf","#3690c0","#0570b0","#045a8d","#023858"],BuPu:["#f7fcfd","#e0ecf4","#bfd3e6","#9ebcda","#8c96c6","#8c6bb1","#88419d","#810f7c","#4d004b"],Oranges:["#fff5eb","#fee6ce","#fdd0a2","#fdae6b","#fd8d3c","#f16913","#d94801","#a63603","#7f2704"],BuGn:["#f7fcfd","#e5f5f9","#ccece6","#99d8c9","#66c2a4","#41ae76","#238b45","#006d2c","#00441b"],YlOrBr:["#ffffe5","#fff7bc","#fee391","#fec44f","#fe9929","#ec7014","#cc4c02","#993404","#662506"],YlGn:["#ffffe5","#f7fcb9","#d9f0a3","#addd8e","#78c679","#41ab5d","#238443","#006837","#004529"],Reds:["#fff5f0","#fee0d2","#fcbba1","#fc9272","#fb6a4a","#ef3b2c","#cb181d","#a50f15","#67000d"],RdPu:["#fff7f3","#fde0dd","#fcc5c0","#fa9fb5","#f768a1","#dd3497","#ae017e","#7a0177","#49006a"],Greens:["#f7fcf5","#e5f5e0","#c7e9c0","#a1d99b","#74c476","#41ab5d","#238b45","#006d2c","#00441b"],YlGnBu:["#ffffd9","#edf8b1","#c7e9b4","#7fcdbb","#41b6c4","#1d91c0","#225ea8","#253494","#081d58"],Purples:["#fcfbfd","#efedf5","#dadaeb","#bcbddc","#9e9ac8","#807dba","#6a51a3","#54278f","#3f007d"],GnBu:["#f7fcf0","#e0f3db","#ccebc5","#a8ddb5","#7bccc4","#4eb3d3","#2b8cbe","#0868ac","#084081"],Greys:["#ffffff","#f0f0f0","#d9d9d9","#bdbdbd","#969696","#737373","#525252","#252525","#000000"],YlOrRd:["#ffffcc","#ffeda0","#fed976","#feb24c","#fd8d3c","#fc4e2a","#e31a1c","#bd0026","#800026"],PuRd:["#f7f4f9","#e7e1ef","#d4b9da","#c994c7","#df65b0","#e7298a","#ce1256","#980043","#67001f"],Blues:["#f7fbff","#deebf7","#c6dbef","#9ecae1","#6baed6","#4292c6","#2171b5","#08519c","#08306b"],PuBuGn:["#fff7fb","#ece2f0","#d0d1e6","#a6bddb","#67a9cf","#3690c0","#02818a","#016c59","#014636"],Viridis:["#440154","#482777","#3f4a8a","#31678e","#26838f","#1f9d8a","#6cce5a","#b6de2b","#fee825"],Spectral:["#9e0142","#d53e4f","#f46d43","#fdae61","#fee08b","#ffffbf","#e6f598","#abdda4","#66c2a5","#3288bd","#5e4fa2"],RdYlGn:["#a50026","#d73027","#f46d43","#fdae61","#fee08b","#ffffbf","#d9ef8b","#a6d96a","#66bd63","#1a9850","#006837"],RdBu:["#67001f","#b2182b","#d6604d","#f4a582","#fddbc7","#f7f7f7","#d1e5f0","#92c5de","#4393c3","#2166ac","#053061"],PiYG:["#8e0152","#c51b7d","#de77ae","#f1b6da","#fde0ef","#f7f7f7","#e6f5d0","#b8e186","#7fbc41","#4d9221","#276419"],PRGn:["#40004b","#762a83","#9970ab","#c2a5cf","#e7d4e8","#f7f7f7","#d9f0d3","#a6dba0","#5aae61","#1b7837","#00441b"],RdYlBu:["#a50026","#d73027","#f46d43","#fdae61","#fee090","#ffffbf","#e0f3f8","#abd9e9","#74add1","#4575b4","#313695"],BrBG:["#543005","#8c510a","#bf812d","#dfc27d","#f6e8c3","#f5f5f5","#c7eae5","#80cdc1","#35978f","#01665e","#003c30"],RdGy:["#67001f","#b2182b","#d6604d","#f4a582","#fddbc7","#ffffff","#e0e0e0","#bababa","#878787","#4d4d4d","#1a1a1a"],PuOr:["#7f3b08","#b35806","#e08214","#fdb863","#fee0b6","#f7f7f7","#d8daeb","#b2abd2","#8073ac","#542788","#2d004b"],Set2:["#66c2a5","#fc8d62","#8da0cb","#e78ac3","#a6d854","#ffd92f","#e5c494","#b3b3b3"],Accent:["#7fc97f","#beaed4","#fdc086","#ffff99","#386cb0","#f0027f","#bf5b17","#666666"],Set1:["#e41a1c","#377eb8","#4daf4a","#984ea3","#ff7f00","#ffff33","#a65628","#f781bf","#999999"],Set3:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3","#fdb462","#b3de69","#fccde5","#d9d9d9","#bc80bd","#ccebc5","#ffed6f"],Dark2:["#1b9e77","#d95f02","#7570b3","#e7298a","#66a61e","#e6ab02","#a6761d","#666666"],Paired:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99","#e31a1c","#fdbf6f","#ff7f00","#cab2d6","#6a3d9a","#ffff99","#b15928"],Pastel2:["#b3e2cd","#fdcdac","#cbd5e8","#f4cae4","#e6f5c9","#fff2ae","#f1e2cc","#cccccc"],Pastel1:["#fbb4ae","#b3cde3","#ccebc5","#decbe4","#fed9a6","#ffffcc","#e5d8bd","#fddaec","#f2f2f2"]},function(){var t,e;for(t in e=[],b)e.push(b[t.toLowerCase()]=b[t])}(),_.colors=Mt={aliceblue:"#f0f8ff",antiquewhite:"#faebd7",aqua:"#00ffff",aquamarine:"#7fffd4",azure:"#f0ffff",beige:"#f5f5dc",bisque:"#ffe4c4",black:"#000000",blanchedalmond:"#ffebcd",blue:"#0000ff",blueviolet:"#8a2be2",brown:"#a52a2a",burlywood:"#deb887",cadetblue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",coral:"#ff7f50",cornflower:"#6495ed",cornflowerblue:"#6495ed",cornsilk:"#fff8dc",crimson:"#dc143c",cyan:"#00ffff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",darkgray:"#a9a9a9",darkgreen:"#006400",darkgrey:"#a9a9a9",darkkhaki:"#bdb76b",darkmagenta:"#8b008b",darkolivegreen:"#556b2f",darkorange:"#ff8c00",darkorchid:"#9932cc",darkred:"#8b0000",darksalmon:"#e9967a",darkseagreen:"#8fbc8f",darkslateblue:"#483d8b",darkslategray:"#2f4f4f",darkslategrey:"#2f4f4f",darkturquoise:"#00ced1",darkviolet:"#9400d3",deeppink:"#ff1493",deepskyblue:"#00bfff",dimgray:"#696969",dimgrey:"#696969",dodgerblue:"#1e90ff",firebrick:"#b22222",floralwhite:"#fffaf0",forestgreen:"#228b22",fuchsia:"#ff00ff",gainsboro:"#dcdcdc",ghostwhite:"#f8f8ff",gold:"#ffd700",goldenrod:"#daa520",gray:"#808080",green:"#008000",greenyellow:"#adff2f",grey:"#808080",honeydew:"#f0fff0",hotpink:"#ff69b4",indianred:"#cd5c5c",indigo:"#4b0082",ivory:"#fffff0",khaki:"#f0e68c",laserlemon:"#ffff54",lavender:"#e6e6fa",lavenderblush:"#fff0f5",lawngreen:"#7cfc00",lemonchiffon:"#fffacd",lightblue:"#add8e6",lightcoral:"#f08080",lightcyan:"#e0ffff",lightgoldenrod:"#fafad2",lightgoldenrodyellow:"#fafad2",lightgray:"#d3d3d3",lightgreen:"#90ee90",lightgrey:"#d3d3d3",lightpink:"#ffb6c1",lightsalmon:"#ffa07a",lightseagreen:"#20b2aa",lightskyblue:"#87cefa",lightslategray:"#778899",lightslategrey:"#778899",lightsteelblue:"#b0c4de",lightyellow:"#ffffe0",lime:"#00ff00",limegreen:"#32cd32",linen:"#faf0e6",magenta:"#ff00ff",maroon:"#800000",maroon2:"#7f0000",maroon3:"#b03060",mediumaquamarine:"#66cdaa",mediumblue:"#0000cd",mediumorchid:"#ba55d3",mediumpurple:"#9370db",mediumseagreen:"#3cb371",mediumslateblue:"#7b68ee",mediumspringgreen:"#00fa9a",mediumturquoise:"#48d1cc",mediumvioletred:"#c71585",midnightblue:"#191970",mintcream:"#f5fffa",mistyrose:"#ffe4e1",moccasin:"#ffe4b5",navajowhite:"#ffdead",navy:"#000080",oldlace:"#fdf5e6",olive:"#808000",olivedrab:"#6b8e23",orange:"#ffa500",orangered:"#ff4500",orchid:"#da70d6",palegoldenrod:"#eee8aa",palegreen:"#98fb98",paleturquoise:"#afeeee",palevioletred:"#db7093",papayawhip:"#ffefd5",peachpuff:"#ffdab9",peru:"#cd853f",pink:"#ffc0cb",plum:"#dda0dd",powderblue:"#b0e0e6",purple:"#800080",purple2:"#7f007f",purple3:"#a020f0",rebeccapurple:"#663399",red:"#ff0000",rosybrown:"#bc8f8f",royalblue:"#4169e1",saddlebrown:"#8b4513",salmon:"#fa8072",sandybrown:"#f4a460",seagreen:"#2e8b57",seashell:"#fff5ee",sienna:"#a0522d",silver:"#c0c0c0",skyblue:"#87ceeb",slateblue:"#6a5acd",slategray:"#708090",slategrey:"#708090",snow:"#fffafa",springgreen:"#00ff7f",steelblue:"#4682b4",tan:"#d2b48c",teal:"#008080",thistle:"#d8bfd8",tomato:"#ff6347",turquoise:"#40e0d0",violet:"#ee82ee",wheat:"#f5deb3",white:"#ffffff",whitesmoke:"#f5f5f5",yellow:"#ffff00",yellowgreen:"#9acd32"},V=function(){var t,e,i,r,o,a,s;return r=(e=At(arguments))[0],t=e[1],i=e[2],a=(r+16)/116,o=isNaN(t)?a:a+t/500,s=isNaN(i)?a:a-i/200,a=n.Yn*H(a),o=n.Xn*H(o),s=n.Zn*H(s),[Tt(3.2404542*o-1.5371385*a-.4985314*s),Tt(-.969266*o+1.8760108*a+.041556*s),i=Tt(.0556434*o-.2040259*a+1.0572252*s),e.length>3?e[3]:1]},Tt=function(t){return 255*(t<=.00304?12.92*t:1.055*it(t,1/2.4)-.055)},H=function(t){return t>n.t1?t*t*t:n.t2*(t-n.t0)},n={Kn:18,Xn:.95047,Yn:1,Zn:1.08883,t0:.137931034,t1:.206896552,t2:.12841855,t3:.008856452},ht=function(){var t,e,i,r,n,o,a;return i=(r=At(arguments))[0],e=r[1],t=r[2],o=(n=mt(i,e,t))[0],[116*(a=n[1])-16,500*(o-a),200*(a-n[2])]},gt=function(t){return(t/=255)<=.04045?t/12.92:it((t+.055)/1.055,2.4)},Pt=function(t){return t>n.t3?it(t,1/3):t/n.t2+n.t0},mt=function(){var t,e,i,r;return i=(r=At(arguments))[0],e=r[1],t=r[2],i=gt(i),e=gt(e),t=gt(t),[Pt((.4124564*i+.3575761*e+.1804375*t)/n.Xn),Pt((.2126729*i+.7151522*e+.072175*t)/n.Yn),Pt((.0193339*i+.119192*e+.9503041*t)/n.Zn)]},_.lab=function(){return function(t,e,i){i.prototype=t.prototype;var r=new i,n=t.apply(r,e);return Object(n)===n?n:r}(i,Et.call(arguments).concat(["lab"]),function(){})},p.lab=V,i.prototype.lab=function(){return ht(this._rgb)},g=function(t){var e,i,r,n,o,a,s,c,u,h,l;return 2===(t=function(){var e,i,r;for(r=[],i=0,e=t.length;i<e;i++)n=t[i],r.push(_(n));return r}()).length?(u=function(){var e,i,r;for(r=[],i=0,e=t.length;i<e;i++)n=t[i],r.push(n.lab());return r}(),o=u[0],a=u[1],e=function(t){var e,i;return i=function(){var i,r;for(r=[],e=i=0;i<=2;e=++i)r.push(o[e]+t*(a[e]-o[e]));return r}(),_.lab.apply(_,i)}):3===t.length?(h=function(){var e,i,r;for(r=[],i=0,e=t.length;i<e;i++)n=t[i],r.push(n.lab());return r}(),o=h[0],a=h[1],s=h[2],e=function(t){var e,i;return i=function(){var i,r;for(r=[],e=i=0;i<=2;e=++i)r.push((1-t)*(1-t)*o[e]+2*(1-t)*t*a[e]+t*t*s[e]);return r}(),_.lab.apply(_,i)}):4===t.length?(l=function(){var e,i,r;for(r=[],i=0,e=t.length;i<e;i++)n=t[i],r.push(n.lab());return r}(),o=l[0],a=l[1],s=l[2],c=l[3],e=function(t){var e,i;return i=function(){var i,r;for(r=[],e=i=0;i<=2;e=++i)r.push((1-t)*(1-t)*(1-t)*o[e]+3*(1-t)*(1-t)*t*a[e]+3*(1-t)*t*t*s[e]+t*t*t*c[e]);return r}(),_.lab.apply(_,i)}):5===t.length&&(i=g(t.slice(0,3)),r=g(t.slice(2,5)),e=function(t){return t<.5?i(2*t):r(2*(t-.5))}),e},_.bezier=function(t){var e;return(e=g(t)).scale=function(){return _.scale(e)},e},_.cubehelix=function(t,e,i,r,n){var o,a,s;return null==t&&(t=300),null==e&&(e=-1.5),null==i&&(i=1),null==r&&(r=1),null==n&&(n=[0,1]),o=0,"array"===St(n)?a=n[1]-n[0]:(a=0,n=[n,n]),(s=function(s){var u,h,l,p,d;return u=c*((t+120)/360+e*s),p=it(n[0]+a*s,r),h=(0!==o?i[0]+s*o:i)*p*(1-p)/2,l=A(u),d=xt(u),_(w([255*(p+h*(-.14861*l+1.78277*d)),255*(p+h*(-.29227*l-.90649*d)),255*(p+h*(1.97294*l))]))}).start=function(e){return null==e?t:(t=e,s)},s.rotations=function(t){return null==t?e:(e=t,s)},s.gamma=function(t){return null==t?r:(r=t,s)},s.hue=function(t){return null==t?i:("array"===St(i=t)?0===(o=i[1]-i[0])&&(i=i[1]):o=0,s)},s.lightness=function(t){return null==t?n:("array"===St(t)?(n=t,a=t[1]-t[0]):(n=[t,t],a=0),s)},s.scale=function(){return _.scale(s)},s.hue(i),s},_.random=function(){var t,e,r;for(e="0123456789abcdef",t="#",r=0;r<6;++r)t+=e.charAt(C(16*Math.random()));return new i(t)},d=[],_.interpolate=N=function(t,e,i,r){var n,o,a,s;for(null==i&&(i=.5),null==r&&(r="rgb"),"object"!==St(t)&&(t=_(t)),"object"!==St(e)&&(e=_(e)),a=0,o=d.length;a<o;a++)if(r===(n=d[a])[0]){s=n[1](t,e,i,r);break}if(null==s)throw"color mode "+r+" is not supported";return s.alpha(t.alpha()+i*(e.alpha()-t.alpha()))},i.prototype.interpolate=function(t,e,i){return N(this,t,e,i)},_.mix=N,i.prototype.mix=i.prototype.interpolate,p.rgb=function(){var t,e,i,r;for(t in i=[],e=At(arguments))r=e[t],i.push(r);return i},_.rgb=function(){return function(t,e,i){i.prototype=t.prototype;var r=new i,n=t.apply(r,e);return Object(n)===n?n:r}(i,Et.call(arguments).concat(["rgb"]),function(){})},i.prototype.rgb=function(t){return null==t&&(t=!0),t?this._rgb.map(Math.round).slice(0,3):this._rgb.slice(0,3)},i.prototype.rgba=function(t){return null==t&&(t=!0),t?[Math.round(this._rgb[0]),Math.round(this._rgb[1]),Math.round(this._rgb[2]),this._rgb[3]]:this._rgb.slice(0)},h.push({p:3,test:function(t){var e;return e=At(arguments),"array"===St(e)&&3===e.length?"rgb":4===e.length&&"number"===St(e[3])&&e[3]>=0&&e[3]<=1?"rgb":void 0}}),p.lrgb=p.rgb,z=function(t,e,r,n){var o,a;return o=t._rgb,a=e._rgb,new i(_t(it(o[0],2)*(1-r)+it(a[0],2)*r),_t(it(o[1],2)*(1-r)+it(a[1],2)*r),_t(it(o[2],2)*(1-r)+it(a[2],2)*r),n)},u=function(t){var e,r,n,o,a;for(e=1/t.length,a=[0,0,0,0],n=0,r=t.length;n<r;n++)o=t[n]._rgb,a[0]+=it(o[0],2)*e,a[1]+=it(o[1],2)*e,a[2]+=it(o[2],2)*e,a[3]+=o[3]*e;return a[0]=_t(a[0]),a[1]=_t(a[1]),a[2]=_t(a[2]),new i(a)},d.push(["lrgb",z]),_.average=function(t,e){var i,r,n,a,s,c,h,l,p,d,f,g,v;if(null==e&&(e="rgb"),p=t.length,h=(t=t.map(function(t){return _(t)})).splice(0,1)[0],"lrgb"===e)return u(t);for(l in a=[],s=0,c=0,g=h.get(e))g[l]=g[l]||0,a.push(isNaN(g[l])?0:1),"h"!==e.charAt(l)||isNaN(g[l])||(i=g[l]/180*o,s+=A(i),c+=xt(i));for(r=h.alpha(),f=0,d=t.length;f<d;f++)for(l in v=(n=t[f]).get(e),r+=n.alpha(),g)isNaN(v[l])||(g[l]+=v[l],a[l]+=1,"h"===e.charAt(l)&&(i=g[l]/180*o,s+=A(i),c+=xt(i)));for(l in g)if(g[l]=g[l]/a[l],"h"===e.charAt(l)){for(i=m(c/a[l],s/a[l])/o*180;i<0;)i+=360;for(;i>=360;)i-=360;g[l]=i}return _(g,e).alpha(r/p)},R=function(t){var e,i;if(t.match(/^#?([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/))return 4!==t.length&&7!==t.length||(t=t.substr(1)),3===t.length&&(t=(t=t.split(""))[0]+t[0]+t[1]+t[1]+t[2]+t[2]),[(i=parseInt(t,16))>>16,i>>8&255,255&i,1];if(t.match(/^#?([A-Fa-f0-9]{8})$/))return 9===t.length&&(t=t.substr(1)),[(i=parseInt(t,16))>>24&255,i>>16&255,i>>8&255,yt((255&i)/255*100)/100];if(null!=p.css&&(e=p.css(t)))return e;throw"unknown color: "+t},at=function(t,e){var i,r,n,o,a,s;return null==e&&(e="rgb"),a=t[0],n=t[1],r=t[2],i=t[3],a=Math.round(a),n=Math.round(n),r=Math.round(r),s=(s="000000"+(a<<16|n<<8|r).toString(16)).substr(s.length-6),o=(o="0"+yt(255*i).toString(16)).substr(o.length-2),"#"+function(){switch(e.toLowerCase()){case"rgba":return s+o;case"argb":return o+s;default:return s}}()},p.hex=function(t){return R(t)},_.hex=function(){return function(t,e,i){i.prototype=t.prototype;var r=new i,n=t.apply(r,e);return Object(n)===n?n:r}(i,Et.call(arguments).concat(["hex"]),function(){})},i.prototype.hex=function(t){return null==t&&(t="rgb"),at(this._rgb,t)},h.push({p:4,test:function(t){if(1===arguments.length&&"string"===St(t))return"hex"}}),D=function(){var t,e,i,r,n,o,a,s,c,u,h,l,p,d;if(n=(t=At(arguments))[0],h=t[1],a=t[2],0===h)c=r=e=255*a;else{for(d=[0,0,0],i=[0,0,0],l=2*a-(p=a<.5?a*(1+h):a+h-a*h),n/=360,d[0]=n+1/3,d[1]=n,d[2]=n-1/3,o=s=0;s<=2;o=++s)d[o]<0&&(d[o]+=1),d[o]>1&&(d[o]-=1),6*d[o]<1?i[o]=l+6*(p-l)*d[o]:2*d[o]<1?i[o]=p:3*d[o]<2?i[o]=l+(p-l)*(2/3-d[o])*6:i[o]=l;c=(u=[yt(255*i[0]),yt(255*i[1]),yt(255*i[2])])[0],r=u[1],e=u[2]}return t.length>3?[c,r,e,t[3]]:[c,r,e]},ct=function(t,e,i){var r,n,o,a,s;return void 0!==t&&t.length>=3&&(t=(a=t)[0],e=a[1],i=a[2]),t/=255,e/=255,i/=255,o=Math.min(t,e,i),n=((J=Math.max(t,e,i))+o)/2,J===o?(s=0,r=Number.NaN):s=n<.5?(J-o)/(J+o):(J-o)/(2-J-o),t===J?r=(e-i)/(J-o):e===J?r=2+(i-t)/(J-o):i===J&&(r=4+(t-e)/(J-o)),(r*=60)<0&&(r+=360),[r,s,n]},_.hsl=function(){return function(t,e,i){i.prototype=t.prototype;var r=new i,n=t.apply(r,e);return Object(n)===n?n:r}(i,Et.call(arguments).concat(["hsl"]),function(){})},p.hsl=D,i.prototype.hsl=function(){return ct(this._rgb)},k=function(){var t,e,i,r,n,o,a,s,c,u,h,l,p,d,f,m,g,v;if(n=(t=At(arguments))[0],m=t[1],v=t[2],v*=255,0===m)c=r=e=v;else switch(360===n&&(n=0),n>360&&(n-=360),n<0&&(n+=360),a=v*(1-m),s=v*(1-m*(i=(n/=60)-(o=C(n)))),g=v*(1-m*(1-i)),o){case 0:c=(u=[v,g,a])[0],r=u[1],e=u[2];break;case 1:c=(h=[s,v,a])[0],r=h[1],e=h[2];break;case 2:c=(l=[a,v,g])[0],r=l[1],e=l[2];break;case 3:c=(p=[a,s,v])[0],r=p[1],e=p[2];break;case 4:c=(d=[g,a,v])[0],r=d[1],e=d[2];break;case 5:c=(f=[v,a,s])[0],r=f[1],e=f[2]}return[c,r,e,t.length>3?t[3]:1]},ut=function(){var t,e,i,r,n,o,a,s,c;return o=(a=At(arguments))[0],i=a[1],t=a[2],n=Math.min(o,i,t),e=(J=Math.max(o,i,t))-n,c=J/255,0===J?(r=Number.NaN,s=0):(s=e/J,o===J&&(r=(i-t)/e),i===J&&(r=2+(t-o)/e),t===J&&(r=4+(o-i)/e),(r*=60)<0&&(r+=360)),[r,s,c]},_.hsv=function(){return function(t,e,i){i.prototype=t.prototype;var r=new i,n=t.apply(r,e);return Object(n)===n?n:r}(i,Et.call(arguments).concat(["hsv"]),function(){})},p.hsv=k,i.prototype.hsv=function(){return ut(this._rgb)},tt=function(t){return"number"===St(t)&&t>=0&&t<=16777215?[t>>16,t>>8&255,255&t,1]:(console.warn("unknown num color: "+t),[0,0,0,1])},dt=function(){var t;return((t=At(arguments))[0]<<16)+(t[1]<<8)+t[2]},_.num=function(t){return new i(t,"num")},i.prototype.num=function(t){return null==t&&(t="rgb"),dt(this._rgb,t)},p.num=tt,h.push({p:1,test:function(t){if(1===arguments.length&&"number"===St(t)&&t>=0&&t<=16777215)return"num"}}),I=function(){var t,e,i,r,n,o,a,s,c,u,h,l,p,d,f,m,g,v,y,b;if(s=(i=At(arguments))[0],n=i[1],e=i[2],a=a/100*255,t=255*(n/=100),0===n)l=a=r=e;else switch(360===s&&(s=0),s>360&&(s-=360),s<0&&(s+=360),h=(u=e*(1-n))+t*(1-(o=(s/=60)-(c=C(s)))),y=u+t*o,b=u+t,c){case 0:l=(p=[b,y,u])[0],a=p[1],r=p[2];break;case 1:l=(d=[h,b,u])[0],a=d[1],r=d[2];break;case 2:l=(f=[u,b,y])[0],a=f[1],r=f[2];break;case 3:l=(m=[u,h,b])[0],a=m[1],r=m[2];break;case 4:l=(g=[y,u,b])[0],a=g[1],r=g[2];break;case 5:l=(v=[b,u,h])[0],a=v[1],r=v[2]}return[l,a,r,i.length>3?i[3]:1]},ot=function(){var t,e,i,r,n,o,a,s,c;return s=(c=At(arguments))[0],n=c[1],e=c[2],a=Math.min(s,n,e),i=100*(r=(J=Math.max(s,n,e))-a)/255,t=a/(255-r)*100,0===r?o=Number.NaN:(s===J&&(o=(n-e)/r),n===J&&(o=2+(e-s)/r),e===J&&(o=4+(s-n)/r),(o*=60)<0&&(o+=360)),[o,i,t]},_.hcg=function(){return function(t,e,i){i.prototype=t.prototype;var r=new i,n=t.apply(r,e);return Object(n)===n?n:r}(i,Et.call(arguments).concat(["hcg"]),function(){})},p.hcg=I,i.prototype.hcg=function(){return ot(this._rgb)},M=function(t){var e,i,r,n,o,a,s,c;if(t=t.toLowerCase(),null!=_.colors&&_.colors[t])return R(_.colors[t]);if(o=t.match(/rgb\(\s*(\-?\d+),\s*(\-?\d+)\s*,\s*(\-?\d+)\s*\)/)){for(s=o.slice(1,4),n=a=0;a<=2;n=++a)s[n]=+s[n];s[3]=1}else if(o=t.match(/rgba\(\s*(\-?\d+),\s*(\-?\d+)\s*,\s*(\-?\d+)\s*,\s*([01]|[01]?\.\d+)\)/))for(s=o.slice(1,5),n=c=0;c<=3;n=++c)s[n]=+s[n];else if(o=t.match(/rgb\(\s*(\-?\d+(?:\.\d+)?)%,\s*(\-?\d+(?:\.\d+)?)%\s*,\s*(\-?\d+(?:\.\d+)?)%\s*\)/)){for(s=o.slice(1,4),n=e=0;e<=2;n=++e)s[n]=yt(2.55*s[n]);s[3]=1}else if(o=t.match(/rgba\(\s*(\-?\d+(?:\.\d+)?)%,\s*(\-?\d+(?:\.\d+)?)%\s*,\s*(\-?\d+(?:\.\d+)?)%\s*,\s*([01]|[01]?\.\d+)\)/)){for(s=o.slice(1,5),n=i=0;i<=2;n=++i)s[n]=yt(2.55*s[n]);s[3]=+s[3]}else(o=t.match(/hsl\(\s*(\-?\d+(?:\.\d+)?),\s*(\-?\d+(?:\.\d+)?)%\s*,\s*(\-?\d+(?:\.\d+)?)%\s*\)/))?((r=o.slice(1,4))[1]*=.01,r[2]*=.01,(s=D(r))[3]=1):(o=t.match(/hsla\(\s*(\-?\d+(?:\.\d+)?),\s*(\-?\d+(?:\.\d+)?)%\s*,\s*(\-?\d+(?:\.\d+)?)%\s*,\s*([01]|[01]?\.\d+)\)/))&&((r=o.slice(1,4))[1]*=.01,r[2]*=.01,(s=D(r))[3]=+o[4]);return s},nt=function(t){var e;return"rgb"===(e=t[3]<1?"rgba":"rgb")?e+"("+t.slice(0,3).map(yt).join(",")+")":"rgba"===e?e+"("+t.slice(0,3).map(yt).join(",")+","+t[3]+")":void 0},vt=function(t){return yt(100*t)/100},O=function(t,e){var i;return i=e<1?"hsla":"hsl",t[0]=vt(t[0]||0),t[1]=vt(100*t[1])+"%",t[2]=vt(100*t[2])+"%","hsla"===i&&(t[3]=e),i+"("+t.join(",")+")"},p.css=function(t){return M(t)},_.css=function(){return function(t,e,i){i.prototype=t.prototype;var r=new i,n=t.apply(r,e);return Object(n)===n?n:r}(i,Et.call(arguments).concat(["css"]),function(){})},i.prototype.css=function(t){return null==t&&(t="rgb"),"rgb"===t.slice(0,3)?nt(this._rgb):"hsl"===t.slice(0,3)?O(this.hsl(),this.alpha()):void 0},p.named=function(t){return R(Mt[t])},h.push({p:5,test:function(t){if(1===arguments.length&&null!=Mt[t])return"named"}}),i.prototype.name=function(t){var e,i;for(i in arguments.length&&(Mt[t]&&(this._rgb=R(Mt[t])),this._rgb[3]=1),e=this.hex(),Mt)if(e===Mt[i])return i;return e},$=function(){var t,e,i,n;return i=(n=At(arguments))[0],t=n[1],e=n[2],[i,A(e*=r)*t,xt(e)*t]},W=function(){var t,e,i,r,n,o,a,s,c;return a=(i=At(arguments))[0],n=i[1],o=i[2],t=(s=$(a,n,o))[0],e=s[1],r=s[2],[(c=V(t,e,r))[0],c[1],r=c[2],i.length>3?i[3]:1]},G=function(){var t,e,i,r,n,o;return n=(o=At(arguments))[0],t=o[1],e=o[2],i=_t(t*t+e*e),r=(m(e,t)*s+360)%360,0===yt(1e4*i)&&(r=Number.NaN),[n,i,r]},lt=function(){var t,e,i,r,n,o,a;return n=(o=At(arguments))[0],i=o[1],e=o[2],r=(a=ht(n,i,e))[0],t=a[1],e=a[2],G(r,t,e)},_.lch=function(){var t;return t=At(arguments),new i(t,"lch")},_.hcl=function(){var t;return t=At(arguments),new i(t,"hcl")},p.lch=W,p.hcl=function(){var t,e,i,r;return e=(r=At(arguments))[0],t=r[1],i=r[2],W([i,t,e])},i.prototype.lch=function(){return lt(this._rgb)},i.prototype.hcl=function(){return lt(this._rgb).reverse()},rt=function(t){var e,i,r,n,o,a;return null==t&&(t="rgb"),o=(a=At(arguments))[0],r=a[1],e=a[2],r/=255,e/=255,[(1-(o/=255)-(n=1-Math.max(o,Math.max(r,e))))*(i=n<1?1/(1-n):0),(1-r-n)*i,(1-e-n)*i,n]},S=function(){var t,e,i,r,n,o;return i=(e=At(arguments))[0],n=e[1],o=e[2],r=e[3],t=e.length>4?e[4]:1,1===r?[0,0,0,t]:[i>=1?0:255*(1-i)*(1-r),n>=1?0:255*(1-n)*(1-r),o>=1?0:255*(1-o)*(1-r),t]},p.cmyk=function(){return S(At(arguments))},_.cmyk=function(){return function(t,e,i){i.prototype=t.prototype;var r=new i,n=t.apply(r,e);return Object(n)===n?n:r}(i,Et.call(arguments).concat(["cmyk"]),function(){})},i.prototype.cmyk=function(){return rt(this._rgb)},p.gl=function(){var t,e,i,r,n;for(r=function(){var t,i;for(e in i=[],t=At(arguments))n=t[e],i.push(n);return i}.apply(this,arguments),t=i=0;i<=2;t=++i)r[t]*=255;return r},_.gl=function(){return function(t,e,i){i.prototype=t.prototype;var r=new i,n=t.apply(r,e);return Object(n)===n?n:r}(i,Et.call(arguments).concat(["gl"]),function(){})},i.prototype.gl=function(){var t;return[(t=this._rgb)[0]/255,t[1]/255,t[2]/255,t[3]]},pt=function(t,e,i){var r;return t=(r=At(arguments))[0],e=r[1],i=r[2],.2126*(t=Z(t))+.7152*(e=Z(e))+.0722*(i=Z(i))},Z=function(t){return(t/=255)<=.03928?t/12.92:it((t+.055)/1.055,2.4)},j=function(t,e,r,n){var o,a;return o=t._rgb,a=e._rgb,new i(o[0]+r*(a[0]-o[0]),o[1]+r*(a[1]-o[1]),o[2]+r*(a[2]-o[2]),n)},d.push(["rgb",j]),i.prototype.luminance=function(t,e){var i,r,n,o;return null==e&&(e="rgb"),arguments.length?(0===t?this._rgb=[0,0,0,this._rgb[3]]:1===t?this._rgb=[255,255,255,this._rgb[3]]:(r=1e-7,n=20,o=function(i,a){var s,c;return s=(c=i.interpolate(a,.5,e)).luminance(),Math.abs(t-s)<r||!n--?c:s>t?o(i,c):o(c,a)},i=pt(this._rgb),this._rgb=(i>t?o(_("black"),this):o(this,_("white"))).rgba()),this):pt(this._rgb)},wt=function(t){var e,i,r,n;return(n=t/100)<66?(r=255,i=-155.25485562709179-.44596950469579133*(i=n-2)+104.49216199393888*Y(i),e=n<20?0:.8274096064007395*(e=n-10)-254.76935184120902+115.67994401066147*Y(e)):(r=351.97690566805693+.114206453784165*(r=n-55)-40.25366309332127*Y(r),i=325.4494125711974+.07943456536662342*(i=n-50)-28.0852963507957*Y(i),e=255),[r,i,e]},ft=function(){var t,e,i,r,n,o,a;for(r=(n=At(arguments))[0],n[1],t=n[2],i=1e3,e=4e4,.4;e-i>.4;)(o=wt(a=.5*(e+i)))[2]/o[0]>=t/r?e=a:i=a;return yt(a)},_.temperature=_.kelvin=function(){return function(t,e,i){i.prototype=t.prototype;var r=new i,n=t.apply(r,e);return Object(n)===n?n:r}(i,Et.call(arguments).concat(["temperature"]),function(){})},p.temperature=p.kelvin=p.K=wt,i.prototype.temperature=function(){return ft(this._rgb)},i.prototype.kelvin=i.prototype.temperature,_.contrast=function(t,e){var r,n,o,a;return"string"!==(o=St(t))&&"number"!==o||(t=new i(t)),"string"!==(a=St(e))&&"number"!==a||(e=new i(e)),(r=t.luminance())>(n=e.luminance())?(r+.05)/(n+.05):(n+.05)/(r+.05)},_.distance=function(t,e,r){var n,o,a,s,c,u,h;for(o in null==r&&(r="lab"),"string"!==(c=St(t))&&"number"!==c||(t=new i(t)),"string"!==(u=St(e))&&"number"!==u||(e=new i(e)),a=t.get(r),s=e.get(r),h=0,a)h+=(n=(a[o]||0)-(s[o]||0))*n;return Math.sqrt(h)},_.deltaE=function(t,e,r,n){var a,s,c,u,h,l,p,d,g,v,y,b,x,_,w,S,M,P,T,E,C,I,R,L;for(null==r&&(r=1),null==n&&(n=1),"string"!==(w=St(t))&&"number"!==w||(t=new i(t)),"string"!==(S=St(e))&&"number"!==S||(e=new i(e)),a=(M=t.lab())[0],c=M[1],h=M[2],s=(P=e.lab())[0],u=P[1],l=P[2],p=_t(c*c+h*h),d=_t(u*u+l*l),E=a<16?.511:.040975*a/(1+.01765*a),T=.0638*p/(1+.0131*p)+.638,_=p<1e-6?0:180*m(h,c)/o;_<0;)_+=360;for(;_>=360;)_-=360;return C=_>=164&&_<=345?.56+f(.2*A(o*(_+168)/180)):.36+f(.4*A(o*(_+35)/180)),x=_t((g=p*p*p*p)/(g+1900)),_t((I=(a-s)/(r*E))*I+(R=(b=p-d)/(n*T))*R+((v=c-u)*v+(y=h-l)*y-b*b)/((L=T*(x*C+1-x))*L))},i.prototype.get=function(t){var e,i,r,n,o;return this,r=(n=t.split("."))[0],e=n[1],o=this[r](),e?(i=r.indexOf(e))>-1?o[i]:console.warn("unknown channel "+e+" in mode "+r):o},i.prototype.set=function(t,e){var i,r,n,o,a;if(this,n=(o=t.split("."))[0],i=o[1])if(a=this[n](),(r=n.indexOf(i))>-1)if("string"===St(e))switch(e.charAt(0)){case"+":case"-":a[r]+=+e;break;case"*":a[r]*=+e.substr(1);break;case"/":a[r]/=+e.substr(1);break;default:a[r]=+e}else a[r]=e;else console.warn("unknown channel "+i+" in mode "+n);else a=e;return _(a,n).alpha(this.alpha())},i.prototype.clipped=function(){return this._rgb._clipped||!1},i.prototype.alpha=function(t){return arguments.length?_.rgb([this._rgb[0],this._rgb[1],this._rgb[2],t]):this._rgb[3]},i.prototype.darken=function(t){var e;return null==t&&(t=1),this,(e=this.lab())[0]-=n.Kn*t,_.lab(e).alpha(this.alpha())},i.prototype.brighten=function(t){return null==t&&(t=1),this.darken(-t)},i.prototype.darker=i.prototype.darken,i.prototype.brighter=i.prototype.brighten,i.prototype.saturate=function(t){var e;return null==t&&(t=1),this,(e=this.lch())[1]+=t*n.Kn,e[1]<0&&(e[1]=0),_.lch(e).alpha(this.alpha())},i.prototype.desaturate=function(t){return null==t&&(t=1),this.saturate(-t)},i.prototype.premultiply=function(){var t,e;return e=this.rgb(),t=this.alpha(),_(e[0]*t,e[1]*t,e[2]*t,t)},Q=function(t,e){return t*e/255},P=function(t,e){return t>e?e:t},X=function(t,e){return t>e?t:e},bt=function(t,e){return 255*(1-(1-t/255)*(1-e/255))},et=function(t,e){return e<128?2*t*e/255:255*(1-2*(1-t/255)*(1-e/255))},x=function(t,e){return 255*(1-(1-e/255)/(t/255))},T=function(t,e){return 255===t?255:(t=e/255*255/(1-t/255))>255?255:t},(v=function(t,e,i){if(!v[i])throw"unknown blend mode "+i;return v[i](t,e)}).normal=(y=function(t){return function(e,i){var r,n;return r=_(i).rgb(),n=_(e).rgb(),_(t(r,n),"rgb")}})((E=function(t){return function(e,i){var r,n,o;for(o=[],r=n=0;n<=3;r=++n)o[r]=t(e[r],i[r]);return o}})(function(t,e){return t})),v.multiply=y(E(Q)),v.screen=y(E(bt)),v.overlay=y(E(et)),v.darken=y(E(P)),v.lighten=y(E(X)),v.dodge=y(E(T)),v.burn=y(E(x)),_.blend=v,_.analyze=function(t){var e,i,r,n;for(r={min:Number.MAX_VALUE,max:-1*Number.MAX_VALUE,sum:0,values:[],count:0},i=0,e=t.length;i<e;i++)null==(n=t[i])||isNaN(n)||(r.values.push(n),r.sum+=n,n<r.min&&(r.min=n),n>r.max&&(r.max=n),r.count+=1);return r.domain=[r.min,r.max],r.limits=function(t,e){return _.limits(r,t,e)},r},_.scale=function(t,e){var i,r,n,o,a,s,c,u,h,l,p,d,f,m,g,v,y,b,x,w,S;return h="rgb",l=_("#ccc"),m=0,a=[0,1],f=[],d=[0,0],i=!1,n=[],p=!1,u=0,c=1,o=!1,r={},g=!0,s=1,w=function(t){var e,i,r,o,a,s;if(null==t&&(t=["#fff","#000"]),null!=t&&"string"===St(t)&&null!=_.brewer&&(t=_.brewer[t]||_.brewer[t.toLowerCase()]||t),"array"===St(t)){for(e=r=0,o=(t=t.slice(0)).length-1;0<=o?r<=o:r>=o;e=0<=o?++r:--r)i=t[e],"string"===St(i)&&(t[e]=_(i));for(f.length=0,e=s=0,a=t.length-1;0<=a?s<=a:s>=a;e=0<=a?++s:--s)f.push(e/(t.length-1))}return x(),n=t},y=function(t){var e,r;if(null!=i){for(r=i.length-1,e=0;e<r&&t>=i[e];)e++;return e-1}return 0},S=function(t){return t},b=function(t,e){var o,a,p,m,v,b,x;if(null==e&&(e=!1),isNaN(t))return l;if(x=e?t:i&&i.length>2?y(t)/(i.length-2):c!==u?(t-u)/(c-u):1,e||(x=S(x)),1!==s&&(x=it(x,s)),x=d[0]+x*(1-d[0]-d[1]),x=Math.min(1,Math.max(0,x)),p=Math.floor(1e4*x),g&&r[p])o=r[p];else{if("array"===St(n))for(a=m=0,b=f.length-1;0<=b?m<=b:m>=b;a=0<=b?++m:--m){if(x<=(v=f[a])){o=n[a];break}if(x>=v&&a===f.length-1){o=n[a];break}if(x>v&&x<f[a+1]){x=(x-v)/(f[a+1]-v),o=_.interpolate(n[a],n[a+1],x,h);break}}else"function"===St(n)&&(o=n(x));g&&(r[p]=o)}return o},x=function(){return r={}},w(t),(v=function(t){var e;return e=_(b(t)),p&&e[p]?e[p]():e}).classes=function(t){var e;return null!=t?("array"===St(t)?(i=t,a=[t[0],t[t.length-1]]):(e=_.analyze(a),i=0===t?[e.min,e.max]:_.limits(e,"e",t)),v):i},v.domain=function(t){var e,i,r,o,s,h,l;if(!arguments.length)return a;if(u=t[0],c=t[t.length-1],f=[],r=n.length,t.length===r&&u!==c)for(s=0,o=t.length;s<o;s++)i=t[s],f.push((i-u)/(c-u));else for(e=l=0,h=r-1;0<=h?l<=h:l>=h;e=0<=h?++l:--l)f.push(e/(r-1));return a=[u,c],v},v.mode=function(t){return arguments.length?(h=t,x(),v):h},v.range=function(t,e){return w(t),v},v.out=function(t){return p=t,v},v.spread=function(t){return arguments.length?(m=t,v):m},v.correctLightness=function(t){return null==t&&(t=!0),o=t,x(),S=o?function(t){var e,i,r,n,o,a,s,c,u;for(e=b(0,!0).lab()[0],i=b(1,!0).lab()[0],s=e>i,r=b(t,!0).lab()[0],n=r-(o=e+(i-e)*t),c=0,u=1,a=20;Math.abs(n)>.01&&a-- >0;)s&&(n*=-1),n<0?(c=t,t+=.5*(u-t)):(u=t,t+=.5*(c-t)),r=b(t,!0).lab()[0],n=r-o;return t}:function(t){return t},v},v.padding=function(t){return null!=t?("number"===St(t)&&(t=[t,t]),d=t,v):d},v.colors=function(e,r){var o,s,c,u,h,l,p,d;if(arguments.length<2&&(r="hex"),h=[],0===arguments.length)h=n.slice(0);else if(1===e)h=[v(.5)];else if(e>1)s=a[0],o=a[1]-s,h=function(){l=[];for(var t=0;0<=e?t<e:t>e;0<=e?t++:t--)l.push(t);return l}.apply(this).map(function(t){return v(s+t/(e-1)*o)});else{if(t=[],p=[],i&&i.length>2)for(c=d=1,u=i.length;1<=u?d<u:d>u;c=1<=u?++d:--d)p.push(.5*(i[c-1]+i[c]));else p=a;h=p.map(function(t){return v(t)})}return _[r]&&(h=h.map(function(t){return t[r]()})),h},v.cache=function(t){return null!=t?(g=t,v):g},v.gamma=function(t){return null!=t?(s=t,v):s},v},null==_.scales&&(_.scales={}),_.scales.cool=function(){return _.scale([_.hsl(180,1,.9),_.hsl(250,.7,.4)])},_.scales.hot=function(){return _.scale(["#000","#f00","#ff0","#fff"],[0,.25,.75,1]).mode("rgb")},_.analyze=function(t,e,i){var r,n,o,a,s,c;if(s={min:Number.MAX_VALUE,max:-1*Number.MAX_VALUE,sum:0,values:[],count:0},null==i&&(i=function(){return!0}),r=function(t){null==t||isNaN(t)||(s.values.push(t),s.sum+=t,t<s.min&&(s.min=t),t>s.max&&(s.max=t),s.count+=1)},c=function(t,n){if(i(t,n))return null!=e&&"function"===St(e)?r(e(t)):null!=e&&"string"===St(e)||"number"===St(e)?r(t[e]):r(t)},"array"===St(t))for(a=0,o=t.length;a<o;a++)c(t[a]);else for(n in t)c(t[n],n);return s.domain=[s.min,s.max],s.limits=function(t,e){return _.limits(s,t,e)},s},_.limits=function(t,e,i){var r,n,o,a,s,c,u,h,l,p,d,m,g,v,y,b,x,w,S,A,M,P,T,E,I,R,L,O,D,k,N,B,F,z,U,j,G,V,H,$,W,X,q,Z,K,Q,tt,et,rt,nt,ot,at,st,ct,ut;if(null==e&&(e="equal"),null==i&&(i=7),"array"===St(t)&&(t=_.analyze(t)),I=t.min,J=t.max,t.sum,ct=t.values.sort(function(t,e){return t-e}),1===i)return[I,J];if(T=[],"c"===e.substr(0,1)&&(T.push(I),T.push(J)),"e"===e.substr(0,1)){for(T.push(I),A=N=1,U=i-1;1<=U?N<=U:N>=U;A=1<=U?++N:--N)T.push(I+A/i*(J-I));T.push(J)}else if("l"===e.substr(0,1)){if(I<=0)throw"Logarithmic scales are only possible for values > 0";for(R=Math.LOG10E*Y(I),E=Math.LOG10E*Y(J),T.push(I),A=ut=1,j=i-1;1<=j?ut<=j:ut>=j;A=1<=j?++ut:--ut)T.push(it(10,R+A/i*(E-R)));T.push(J)}else if("q"===e.substr(0,1)){for(T.push(I),A=r=1,X=i-1;1<=X?r<=X:r>=X;A=1<=X?++r:--r)B=(ct.length-1)*A/i,(F=C(B))===B?T.push(ct[F]):(z=B-F,T.push(ct[F]*(1-z)+ct[F+1]*z));T.push(J)}else if("k"===e.substr(0,1)){for(O=ct.length,v=new Array(O),w=new Array(i),nt=!0,D=0,b=null,(b=[]).push(I),A=n=1,q=i-1;1<=q?n<=q:n>=q;A=1<=q?++n:--n)b.push(I+A/i*(J-I));for(b.push(J);nt;){for(M=o=0,Z=i-1;0<=Z?o<=Z:o>=Z;M=0<=Z?++o:--o)w[M]=0;for(A=a=0,K=O-1;0<=K?a<=K:a>=K;A=0<=K?++a:--a){for(st=ct[A],L=Number.MAX_VALUE,M=s=0,Q=i-1;0<=Q?s<=Q:s>=Q;M=0<=Q?++s:--s)(S=f(b[M]-st))<L&&(L=S,y=M);w[y]++,v[A]=y}for(k=new Array(i),M=c=0,tt=i-1;0<=tt?c<=tt:c>=tt;M=0<=tt?++c:--c)k[M]=null;for(A=u=0,et=O-1;0<=et?u<=et:u>=et;A=0<=et?++u:--u)null===k[x=v[A]]?k[x]=ct[A]:k[x]+=ct[A];for(M=h=0,rt=i-1;0<=rt?h<=rt:h>=rt;M=0<=rt?++h:--h)k[M]*=1/w[M];for(nt=!1,M=l=0,G=i-1;0<=G?l<=G:l>=G;M=0<=G?++l:--l)if(k[M]!==b[A]){nt=!0;break}b=k,++D>200&&(nt=!1)}for(P={},M=p=0,V=i-1;0<=V?p<=V:p>=V;M=0<=V?++p:--p)P[M]=[];for(A=d=0,H=O-1;0<=H?d<=H:d>=H;A=0<=H?++d:--d)P[x=v[A]].push(ct[A]);for(ot=[],M=m=0,$=i-1;0<=$?m<=$:m>=$;M=0<=$?++m:--m)ot.push(P[M][0]),ot.push(P[M][P[M].length-1]);for(ot=ot.sort(function(t,e){return t-e}),T.push(ot[0]),A=g=1,W=ot.length-1;g<=W;A=g+=2)at=ot[A],isNaN(at)||-1!==T.indexOf(at)||T.push(at)}return T},L=function(t,e,i){var r,n,o,s;return t=(r=At(arguments))[0],e=r[1],i=r[2],isNaN(t)&&(t=0),(t/=360)<1/3?o=1-((n=(1-e)/3)+(s=(1+e*A(c*t)/A(a-c*t))/3)):t<2/3?n=1-((s=(1-e)/3)+(o=(1+e*A(c*(t-=1/3))/A(a-c*t))/3)):s=1-((o=(1-e)/3)+(n=(1+e*A(c*(t-=2/3))/A(a-c*t))/3)),[255*(s=q(i*s*3)),255*(o=q(i*o*3)),255*(n=q(i*n*3)),r.length>3?r[3]:1]},st=function(){var t,e,i,r,n,o,a;return n=(o=At(arguments))[0],e=o[1],t=o[2],c=2*Math.PI,n/=255,e/=255,t/=255,0===(a=1-Math.min(n,e,t)/(r=(n+e+t)/3))?i=0:(i=(n-e+(n-t))/2,i/=Math.sqrt((n-e)*(n-e)+(n-t)*(e-t)),i=Math.acos(i),t>e&&(i=c-i),i/=c),[360*i,a,r]},_.hsi=function(){return function(t,e,i){i.prototype=t.prototype;var r=new i,n=t.apply(r,e);return Object(n)===n?n:r}(i,Et.call(arguments).concat(["hsi"]),function(){})},p.hsi=L,i.prototype.hsi=function(){return st(this._rgb)},B=function(t,e,i,r){var n,o,a,s,c,u,h,l,p,d;return"hsl"===r?(p=t.hsl(),d=e.hsl()):"hsv"===r?(p=t.hsv(),d=e.hsv()):"hcg"===r?(p=t.hcg(),d=e.hcg()):"hsi"===r?(p=t.hsi(),d=e.hsi()):"lch"!==r&&"hcl"!==r||(r="hcl",p=t.hcl(),d=e.hcl()),"h"===r.substr(0,1)&&(o=p[0],h=p[1],s=p[2],a=d[0],l=d[1],c=d[2]),isNaN(o)||isNaN(a)?isNaN(o)?isNaN(a)?n=Number.NaN:(n=a,1!==s&&0!==s||"hsv"===r||(u=l)):(n=o,1!==c&&0!==c||"hsv"===r||(u=h)):n=o+i*(a>o&&a-o>180?a-(o+360):a<o&&o-a>180?a+360-o:a-o),null==u&&(u=h+i*(l-h)),_[r](n,u,s+i*(c-s))},U=function(t,e,i,r){var n,o;return n=t.num(),o=e.num(),_.num(n+(o-n)*i,"num")},(d=d.concat(function(){var t,e,i,r;for(r=[],e=0,t=(i=["hsv","hsl","hsi","hcl","lch","hcg"]).length;e<t;e++)K=i[e],r.push([K,B]);return r}())).push(["num",U]),F=function(t,e,r,n){var o,a;return o=t.lab(),a=e.lab(),new i(o[0]+r*(a[0]-o[0]),o[1]+r*(a[1]-o[1]),o[2]+r*(a[2]-o[2]),n)},d.push(["lab",F])}).call(Zh)}).scale,Qh={scale:"uniform",mode:"hcl",domain:[0,1],value:16777215,reverse:!1},tl=new Gi,el=function(t){void 0===t&&(t={}),this.parameters=bh(t,Qh),"string"==typeof this.parameters.value&&(this.parameters.value=tl.set(this.parameters.value).getHex()),this.parameters.structure&&(this.atomProxy=this.parameters.structure.getAtomProxy())};el.prototype.getScale=function(t){void 0===t&&(t={});var e=bh(t,this.parameters);return"rainbow"===e.scale?e.scale=["red","orange","yellow","green","blue"]:"rwb"===e.scale&&(e.scale=["red","white","blue"]),e.reverse&&e.domain.reverse(),Jh(e.scale).mode(e.mode).domain(e.domain).out("num")},el.prototype.colorToArray=function(t,e,i){return void 0===e&&(e=[]),void 0===i&&(i=0),e[i]=(t>>16&255)/255,e[i+1]=(t>>8&255)/255,e[i+2]=(255&t)/255,e},el.prototype.atomColorToArray=function(t,e,i){return this.colorToArray(this.atomColor?this.atomColor(t):0,e,i)},el.prototype.bondColor=function(t,e){return this.atomProxy&&this.atomColor?(this.atomProxy.index=e?t.atomIndex1:t.atomIndex2,this.atomColor(this.atomProxy)):0},el.prototype.bondColorToArray=function(t,e,i,r){return this.colorToArray(this.bondColor(t,e),i,r)},el.prototype.volumeColorToArray=function(t,e,i){return this.colorToArray(this.volumeColor?this.volumeColor(t):0,e,i)},el.prototype.positionColorToArray=function(t,e,i){return this.colorToArray(this.positionColor?this.positionColor(t):0,e,i)};var il,rl,nl=Kh(function(t){!function(e){function i(t,e,i,r,n){this._listener=e,this._isOnce=i,this.context=r,this._signal=t,this._priority=n||0}function r(t,e){if("function"!=typeof t)throw new Error("listener is a required param of {fn}() and should be a Function.".replace("{fn}",e))}function n(){this._bindings=[],this._prevParams=null;var t=this;this.dispatch=function(){n.prototype.dispatch.apply(t,arguments)}}i.prototype={active:!0,params:null,execute:function(t){var e,i;return this.active&&this._listener&&(i=this.params?this.params.concat(t):t,e=this._listener.apply(this.context,i),this._isOnce&&this.detach()),e},detach:function(){return this.isBound()?this._signal.remove(this._listener,this.context):null},isBound:function(){return!!this._signal&&!!this._listener},isOnce:function(){return this._isOnce},getListener:function(){return this._listener},getSignal:function(){return this._signal},_destroy:function(){delete this._signal,delete this._listener,delete this.context},toString:function(){return"[SignalBinding isOnce:"+this._isOnce+", isBound:"+this.isBound()+", active:"+this.active+"]"}},n.prototype={VERSION:"1.0.0",memorize:!1,_shouldPropagate:!0,active:!0,_registerListener:function(t,e,r,n){var o,a=this._indexOfListener(t,r);if(-1!==a){if((o=this._bindings[a]).isOnce()!==e)throw new Error("You cannot add"+(e?"":"Once")+"() then add"+(e?"Once":"")+"() the same listener without removing the relationship first.")}else o=new i(this,t,e,r,n),this._addBinding(o);return this.memorize&&this._prevParams&&o.execute(this._prevParams),o},_addBinding:function(t){var e=this._bindings.length;do{--e}while(this._bindings[e]&&t._priority<=this._bindings[e]._priority);this._bindings.splice(e+1,0,t)},_indexOfListener:function(t,e){for(var i,r=this._bindings.length;r--;)if((i=this._bindings[r])._listener===t&&i.context===e)return r;return-1},has:function(t,e){return-1!==this._indexOfListener(t,e)},add:function(t,e,i){return r(t,"add"),this._registerListener(t,!1,e,i)},addOnce:function(t,e,i){return r(t,"addOnce"),this._registerListener(t,!0,e,i)},remove:function(t,e){r(t,"remove");var i=this._indexOfListener(t,e);return-1!==i&&(this._bindings[i]._destroy(),this._bindings.splice(i,1)),t},removeAll:function(){for(var t=this._bindings.length;t--;)this._bindings[t]._destroy();this._bindings.length=0},getNumListeners:function(){return this._bindings.length},halt:function(){this._shouldPropagate=!1},dispatch:function(t){if(this.active){var e,i=Array.prototype.slice.call(arguments),r=this._bindings.length;if(this.memorize&&(this._prevParams=i),r){e=this._bindings.slice(),this._shouldPropagate=!0;do{r--}while(e[r]&&this._shouldPropagate&&!1!==e[r].execute(i))}}},forget:function(){this._prevParams=null},dispose:function(){this.removeAll(),delete this._bindings,delete this._prevParams},toString:function(){return"[Signal active:"+this.active+" numListeners:"+this.getNumListeners()+"]"}};var o=n;o.Signal=n,t.exports?t.exports=o:e.signals=o}(Zh)}).Signal;(rl=il||(il={}))[rl.PROTEIN=1]="PROTEIN",rl[rl.NUCLEIC=2]="NUCLEIC",rl[rl.RNA=3]="RNA",rl[rl.DNA=4]="DNA",rl[rl.POLYMER=5]="POLYMER",rl[rl.WATER=6]="WATER",rl[rl.HELIX=7]="HELIX",rl[rl.SHEET=8]="SHEET",rl[rl.TURN=9]="TURN",rl[rl.BACKBONE=10]="BACKBONE",rl[rl.SIDECHAIN=11]="SIDECHAIN",rl[rl.ALL=12]="ALL",rl[rl.HETERO=13]="HETERO",rl[rl.ION=14]="ION",rl[rl.SACCHARIDE=15]="SACCHARIDE",rl[rl.SUGAR=15]="SUGAR",rl[rl.BONDED=16]="BONDED",rl[rl.RING=17]="RING",rl[rl.AROMATICRING=18]="AROMATICRING",rl[rl.METAL=19]="METAL",rl[rl.NONE=20]="NONE";var ol=["*","","ALL"],al=["NONE"],sl=[il.BACKBONE,il.SIDECHAIN,il.BONDED,il.RING,il.AROMATICRING,il.METAL],cl=[il.POLYMER,il.WATER],ul=["ALA","GLY","SER"],hl=["CYS","SER","THR"],ll=["ALA","ILE","LEU","MET","PHE","PRO","TRP","VAL"],pl=["PHE","TRP","TYR","HIS"],dl=["ASN","GLN"],fl=["ASP","GLU"],ml=["ARG","HIS","LYS"],gl=["ARG","ASP","GLU","HIS","LYS"],vl=["ASN","ARG","ASP","CYS","GLY","GLN","GLU","HIS","LYS","SER","THR","TYR"],yl=["ALA","ILE","LEU","MET","PHE","PRO","TRP","VAL"],bl=["HIS","PHE","PRO","TRP","TYR"],xl=["ALA","GLY","ILE","LEU","VAL"];function _l(t,e){if(void 0===e.atomname&&void 0===e.element&&void 0===e.altloc&&void 0===e.atomindex&&void 0===e.keyword&&void 0===e.inscode&&void 0===e.resname&&void 0===e.sstruc&&void 0===e.resno&&void 0===e.chainname&&void 0===e.model)return-1;if(void 0!==e.keyword){if(e.keyword===il.BACKBONE&&!t.isBackbone())return!1;if(e.keyword===il.SIDECHAIN&&!t.isSidechain())return!1;if(e.keyword===il.BONDED&&!t.isBonded())return!1;if(e.keyword===il.RING&&!t.isRing())return!1;if(e.keyword===il.AROMATICRING&&!t.isAromatic())return!1;if(e.keyword===il.HETERO&&!t.isHetero())return!1;if(e.keyword===il.PROTEIN&&!t.isProtein())return!1;if(e.keyword===il.NUCLEIC&&!t.isNucleic())return!1;if(e.keyword===il.RNA&&!t.isRna())return!1;if(e.keyword===il.DNA&&!t.isDna())return!1;if(e.keyword===il.POLYMER&&!t.isPolymer())return!1;if(e.keyword===il.WATER&&!t.isWater())return!1;if(e.keyword===il.HELIX&&!t.isHelix())return!1;if(e.keyword===il.SHEET&&!t.isSheet())return!1;if(e.keyword===il.TURN&&!t.isTurn())return!1;if(e.keyword===il.ION&&!t.isIon())return!1;if(e.keyword===il.SACCHARIDE&&!t.isSaccharide())return!1;if(e.keyword===il.METAL&&!t.isMetal())return!1}if(void 0!==e.atomname&&e.atomname!==t.atomname)return!1;if(void 0!==e.element&&e.element!==t.element)return!1;if(void 0!==e.altloc&&e.altloc!==t.altloc)return!1;if(void 0!==e.atomindex&&Ph(e.atomindex,t.index)<0)return!1;if(void 0!==e.resname)if(Array.isArray(e.resname)){if(!e.resname.includes(t.resname))return!1}else if(e.resname!==t.resname)return!1;if(void 0!==e.sstruc&&e.sstruc!==t.sstruc)return!1;if(void 0!==e.resno)if(Array.isArray(e.resno)&&2===e.resno.length){if(e.resno[0]>t.resno||e.resno[1]<t.resno)return!1}else if(e.resno!==t.resno)return!1;return(void 0===e.inscode||e.inscode===t.inscode)&&((void 0===e.chainname||e.chainname===t.chainname)&&(void 0===e.model||e.model===t.modelIndex))}function wl(t,e){if(void 0===e.resname&&void 0===e.resno&&void 0===e.inscode&&void 0===e.sstruc&&void 0===e.model&&void 0===e.chainname&&void 0===e.atomindex&&(void 0===e.keyword||sl.includes(e.keyword)))return-1;if(void 0!==e.keyword){if(e.keyword===il.HETERO&&!t.isHetero())return!1;if(e.keyword===il.PROTEIN&&!t.isProtein())return!1;if(e.keyword===il.NUCLEIC&&!t.isNucleic())return!1;if(e.keyword===il.RNA&&!t.isRna())return!1;if(e.keyword===il.DNA&&!t.isDna())return!1;if(e.keyword===il.POLYMER&&!t.isPolymer())return!1;if(e.keyword===il.WATER&&!t.isWater())return!1;if(e.keyword===il.HELIX&&!t.isHelix())return!1;if(e.keyword===il.SHEET&&!t.isSheet())return!1;if(e.keyword===il.TURN&&!t.isTurn())return!1;if(e.keyword===il.ION&&!t.isIon())return!1;if(e.keyword===il.SACCHARIDE&&!t.isSaccharide())return!1}if(void 0!==e.atomindex&&0===Th(e.atomindex,t.atomOffset,t.atomEnd))return!1;if(void 0!==e.resname)if(Array.isArray(e.resname)){if(!e.resname.includes(t.resname))return!1}else if(e.resname!==t.resname)return!1;if(void 0!==e.sstruc&&e.sstruc!==t.sstruc)return!1;if(void 0!==e.resno)if(Array.isArray(e.resno)&&2===e.resno.length){if(e.resno[0]>t.resno||e.resno[1]<t.resno)return!1}else if(e.resno!==t.resno)return!1;return(void 0===e.inscode||e.inscode===t.inscode)&&((void 0===e.chainname||e.chainname===t.chainname)&&(void 0===e.model||e.model===t.modelIndex))}function Sl(t,e){if(!(void 0!==e.chainname||void 0!==e.model||void 0!==e.atomindex||void 0!==e.keyword&&cl.includes(e.keyword)&&t.entity))return-1;if(void 0!==e.keyword){if(e.keyword===il.POLYMER&&!t.entity.isPolymer())return!1;if(e.keyword===il.WATER&&!t.entity.isWater())return!1}return(void 0===e.atomindex||0!==Th(e.atomindex,t.atomOffset,t.atomEnd))&&((void 0===e.chainname||e.chainname===t.chainname)&&(void 0===e.model||e.model===t.modelIndex))}function Al(t,e){return void 0===e.model&&void 0===e.atomindex?-1:(void 0===e.atomindex||0!==Th(e.atomindex,t.atomOffset,t.atomEnd))&&(void 0===e.model||e.model===t.index)}function Ml(t,e){if(null===t)return!1;if(t.error)return!1;if(!t.rules||0===t.rules.length)return!1;for(var i=t.rules.length,r=!t.negate,n=!!t.negate,o=[],a=0;a<i;++a){var s=t.rules[a];s.hasOwnProperty("operator")&&(o[a]=Ml(s,e))}return function(a){for(var s="AND"===t.operator,c=!1,u=0;u<i;++u){var h=t.rules[u],l=void 0;if(h.hasOwnProperty("operator")){var p=o[u];if(-1===(l=!1!==p?p(a):-1)){c=!0;continue}if(!0===l){if(s)continue;return r}if(s)return n}else{if(h.keyword===il.ALL){if(s)continue;return r}if(h.keyword===il.NONE){if(s)continue;return n}if(-1!==(l=e(a,h))){if(!0===l){if(s)continue;return r}if(s)return n}else c=!0}}return c?-1:s?r:n}}function Pl(t,e){if(t.error)return t;if(!t.rules||0===t.rules.length)return t;var i=t.rules.length,r={operator:t.operator,rules:[]};t.hasOwnProperty("negate")&&(r.negate=t.negate);for(var n=0;n<i;++n){var o=t.rules[n];if(o.hasOwnProperty("operator")){var a=Pl(o,e);null!==a&&r.rules.push(a)}else e(o)||r.rules.push(o)}return r.rules.length>0?t:null}function Tl(t,e){void 0===e&&(e=!1);var i=t;return e&&(i=Pl(t,function(t){return void 0!==t.keyword&&!sl.includes(t.keyword)||(void 0!==t.model||(void 0!==t.chainname||(void 0!==t.resname||(void 0!==t.resno||void 0!==t.sstruc))))})),Ml(i,_l)}function El(t,e){void 0===e&&(e=!1);var i=t;return e&&(i=Pl(t,function(t){return!(void 0===t.keyword||!sl.includes(t.keyword))||(void 0!==t.model||(void 0!==t.chainname||(void 0!==t.atomname||(void 0!==t.element||void 0!==t.altloc))))})),Ml(i,wl)}function Cl(t,e){void 0===e&&(e=!1);var i=t;return e&&(i=Pl(t,function(t){return void 0!==t.keyword&&!cl.includes(t.keyword)||(void 0!==t.resname||(void 0!==t.resno||(void 0!==t.atomname||(void 0!==t.element||(void 0!==t.altloc||(void 0!==t.sstruc||void 0!==t.inscode))))))})),Ml(i,Sl)}function Il(t,e){void 0===e&&(e=!1);var i=t;return e&&(i=Pl(t,function(t){return void 0!==t.keyword||(void 0!==t.chainname||(void 0!==t.resname||(void 0!==t.resno||(void 0!==t.atomname||(void 0!==t.element||(void 0!==t.altloc||(void 0!==t.sstruc||void 0!==t.inscode)))))))})),Ml(i,Al)}var Rl=function(t){this.signals={stringChanged:new nl},this.setString(t)},Ll={type:{configurable:!0}};Ll.type.get=function(){return"selection"},Rl.prototype.setString=function(t,e){if(void 0===t&&(t=this.string||""),t!==this.string){try{this.selection=function(t){var e={operator:void 0,rules:[]};if(!t)return e;var i,r,n=e,o=[];"("===(t=t.replace(/\(/g," ( ").replace(/\)/g," ) ").trim()).charAt(0)&&")"===t.substr(-1)&&(t=t.slice(1,-1).trim());for(var a=t.split(/\s+/),s=function(t){i={operator:t,rules:[]},void 0===n?(n=i,e=i):(n.rules.push(i),o.push(n),n=i)},c=function(t){r=n,void 0===(n=o.pop())&&(s(t),u(r))},u=function(t){n.rules.push(t)},h=!1,l=0;l<a.length;++l){var p=a[l],d=p.toUpperCase();if("("!==p)if(")"!==p){if(h>0)if("NOT"===d)h=1;else if(1===h)h=2;else{if(2!==h)throw new Error("something went wrong with 'not'");h=!1,c()}if("AND"!==d)if("OR"!==d)if("NOT"!==p.toUpperCase()){if(+d!=+d){var f=il[d];if(void 0!==f){u({keyword:f});continue}}if("HYDROGEN"!==d)if("SMALL"!==d)if("NUCLEOPHILIC"!==d)if("HYDROPHOBIC"!==d)if("AROMATIC"!==d)if("AMIDE"!==d)if("ACIDIC"!==d)if("BASIC"!==d)if("CHARGED"!==d)if("POLAR"!==d)if("NONPOLAR"!==d)if("CYCLIC"!==d)if("ALIPHATIC"!==d)if("SIDECHAINATTACHED"!==d)if("LIGAND"!==d)if(-1===ol.indexOf(d))if("@"!==p.charAt(0))if("#"!==p.charAt(0))if("_"!==p.charAt(0))if("["!==p[0]||"]"!==p[p.length-1])if(p.length>=1&&p.length<=4&&"^"!==p[0]&&":"!==p[0]&&"."!==p[0]&&"%"!==p[0]&&"/"!==p[0]&&isNaN(parseInt(p)))u({resname:d});else{var m={operator:"AND",rules:[]},g=p.split("/");if(g.length>1&&g[1]){if(isNaN(parseInt(g[1])))throw new Error("model must be an integer");m.rules.push({model:parseInt(g[1])})}var v=g[0].split("%");v.length>1&&m.rules.push({altloc:v[1]});var y=v[0].split(".");if(y.length>1&&y[1]){if(y[1].length>4)throw new Error("atomname must be one to four characters");m.rules.push({atomname:y[1].substring(0,4).toUpperCase()})}var b=y[0].split(":");b.length>1&&b[1]&&m.rules.push({chainname:b[1]});var x=b[0].split("^");if(x.length>1&&m.rules.push({inscode:x[1]}),x[0]){var _=void 0,w=void 0;"-"===x[0][0]&&(x[0]=x[0].substr(1),_=!0),x[0].includes("--")&&(x[0]=x[0].replace("--","-"),w=!0);var S=x[0].split("-");if(1===S.length){var A=parseInt(S[0]);if(isNaN(A))throw new Error("resi must be an integer");_&&(A*=-1),m.rules.push({resno:A})}else{if(2!==S.length)throw new Error("resi range must contain one '-'");var M=S.map(function(t){return parseInt(t)});_&&(M[0]*=-1),w&&(M[1]*=-1),m.rules.push({resno:[M[0],M[1]]})}}if(1===m.rules.length)u(m.rules[0]);else{if(!(m.rules.length>1))throw new Error("empty selection chunk");u(m)}}else{var P=d.substr(1,p.length-2).split(","),T=P.length>1?P:P[0];u({resname:T})}else u({element:d.substr(1)});else console.error("# for element selection deprecated, use _"),u({element:d.substr(1)});else{var E=p.substr(1).split(",").map(function(t){return parseInt(t)});E.sort(function(t,e){return t-e}),u({atomindex:E})}else u({keyword:il.ALL});else u({operator:"AND",rules:[{operator:"OR",rules:[{operator:"AND",rules:[{keyword:il.HETERO},{negate:!0,operator:void 0,rules:[{keyword:il.POLYMER}]}]},{negate:!0,operator:void 0,rules:[{keyword:il.POLYMER}]}]},{negate:!0,operator:void 0,rules:[{operator:"OR",rules:[{keyword:il.WATER},{keyword:il.ION}]}]}]});else u({operator:"OR",rules:[{keyword:il.SIDECHAIN},{operator:"AND",negate:!1,rules:[{keyword:il.PROTEIN},{operator:"OR",negate:!1,rules:[{atomname:"CA"},{atomname:"BB"}]}]},{operator:"AND",negate:!1,rules:[{resname:"PRO"},{atomname:"N"}]},{operator:"AND",negate:!1,rules:[{keyword:il.NUCLEIC},{operator:"OR",negate:!0,rules:[{atomname:"P"},{atomname:"OP1"},{atomname:"OP2"},{atomname:"O3'"},{atomname:"O3*"},{atomname:"O5'"},{atomname:"O5*"},{atomname:"C5'"},{atomname:"C5*"}]}]}]});else u({resname:xl});else u({resname:bl});else u({resname:yl});else u({resname:vl});else u({resname:gl});else u({resname:ml});else u({resname:fl});else u({resname:dl});else u({resname:pl});else u({resname:ll});else u({resname:hl});else u({resname:ul});else u({operator:"OR",rules:[{element:"H"},{element:"D"}]})}else h=1,s(),n.negate=!0;else"AND"===n.operator?c("OR"):n.operator="OR";else if("OR"===n.operator){var C=n.rules.pop();s("AND"),u(C)}else n.operator="AND"}else c(),n.negate&&c();else h=!1,s()}return void 0===e.operator&&1===e.rules.length&&e.rules[0].hasOwnProperty("operator")&&(e=e.rules[0]),e}(t)}catch(t){this.selection={error:t.message}}var i=this.selection;this.string=t,this.test=Tl(i),this.residueTest=El(i),this.chainTest=Cl(i),this.modelTest=Il(i),this.atomOnlyTest=Tl(i,!0),this.residueOnlyTest=El(i,!0),this.chainOnlyTest=Cl(i,!0),this.modelOnlyTest=Il(i,!0),e||this.signals.stringChanged.dispatch(this.string)}},Rl.prototype.isAllSelection=function(){return ol.includes(this.string.toUpperCase())},Rl.prototype.isNoneSelection=function(){return al.includes(this.string.toUpperCase())},Object.defineProperties(Rl.prototype,Ll);var Ol=function(t){function e(e){var i=this;t.call(this,e),this.colormakerList=[],this.selectionList=[],(e.dataList||[]).forEach(function(t){var e=t[0],r=t[1],n=t[2];void 0===n&&(n={}),Jl.hasScheme(e)?Object.assign(n,{scheme:e,structure:i.parameters.structure}):Object.assign(n,{scheme:"uniform",value:new Gi(e).getHex()}),i.colormakerList.push(Jl.getScheme(n)),i.selectionList.push(new Rl(r))})}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.atomColor=function(t){for(var e=0,i=this.selectionList.length;e<i;++e){var r=this.selectionList[e].test;if(r&&r(t))return this.colormakerList[e].atomColor(t)}return 16777215},e}(el),Dl={"":"",OrRd:"[S] Orange-Red",PuBu:"[S] Purple-Blue",BuPu:"[S] Blue-Purple",Oranges:"[S] Oranges",BuGn:"[S] Blue-Green",YlOrBr:"[S] Yellow-Orange-Brown",YlGn:"[S] Yellow-Green",Reds:"[S] Reds",RdPu:"[S] Red-Purple",Greens:"[S] Greens",YlGnBu:"[S] Yellow-Green-Blue",Purples:"[S] Purples",GnBu:"[S] Green-Blue",Greys:"[S] Greys",YlOrRd:"[S] Yellow-Orange-Red",PuRd:"[S] Purple-Red",Blues:"[S] Blues",PuBuGn:"[S] Purple-Blue-Green",Viridis:"[D] Viridis",Spectral:"[D] Spectral",RdYlGn:"[D] Red-Yellow-Green",RdBu:"[D] Red-Blue",PiYG:"[D] Pink-Yellowgreen",PRGn:"[D] Purplered-Green",RdYlBu:"[D] Red-Yellow-Blue",BrBG:"[D] Brown-Bluegreen",RdGy:"[D] Red-Grey",PuOr:"[D] Purple-Orange",Set1:"[Q] Set1",Set2:"[Q] Set2",Set3:"[Q] Set3",Dark2:"[Q] Dark2",Paired:"[Q] Paired",Pastel1:"[Q] Pastel1",Pastel2:"[Q] Pastel2",Accent:"[Q] Accent",rainbow:"[?] Rainbow",rwb:"[?] Red-White-Blue"},kl={"":"",rgb:"Red Green Blue",hsv:"Hue Saturation Value",hsl:"Hue Saturation Lightness",hsi:"Hue Saturation Intensity",lab:"CIE L*a*b*",hcl:"Hue Chroma Lightness"},Nl=function(){this.schemes={},this.userSchemes={}};Nl.prototype.getScheme=function(t){var e=((t||{}).scheme||"").toLowerCase();return new(e in this.schemes?this.schemes[e]:e in this.userSchemes?this.userSchemes[e]:el)(t)},Nl.prototype.getSchemes=function(){var t={};return Object.keys(this.schemes).forEach(function(e){t[e]=e}),Object.keys(this.userSchemes).forEach(function(e){t[e]=e.split("|")[1]}),t},Nl.prototype.getScales=function(){return Dl},Nl.prototype.getModes=function(){return kl},Nl.prototype.add=function(t,e){t=t.toLowerCase(),this.schemes[t]=e},Nl.prototype.addScheme=function(t,e){return t instanceof el||(t=this._createScheme(t)),this._addUserScheme(t,e)},Nl.prototype._addUserScheme=function(t,e){e=e||"";var i=(Hh()+"|"+e).toLowerCase();return this.userSchemes[i]=t,i},Nl.prototype.removeScheme=function(t){t=t.toLowerCase(),delete this.userSchemes[t]},Nl.prototype._createScheme=function(t){var e=function(e){el.call(this,e),t.call(this,e)};return(e.prototype=el.prototype).constructor=el,e},Nl.prototype.addSelectionScheme=function(t,e){var i=function(e){function i(i){e.call(this,Object.assign({dataList:t},i))}return e&&(i.__proto__=e),i.prototype=Object.create(e&&e.prototype),i.prototype.constructor=i,i}(Ol);return this._addUserScheme(i,e)},Nl.prototype.hasScheme=function(t){return(t=t.toLowerCase())in this.schemes||t in this.userSchemes};var Bl=function(t){function e(){t.call(this,"parser")}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.__hasObjName=function(t,e){var i=this.get(t);return i&&i.prototype.__objName===e},e.prototype.isTrajectory=function(t){return this.__hasObjName(t,"frames")},e.prototype.isStructure=function(t){return this.__hasObjName(t,"structure")},e.prototype.isVolume=function(t){return this.__hasObjName(t,"volume")},e.prototype.isSurface=function(t){return this.__hasObjName(t,"surface")},e.prototype.isBinary=function(t){var e=this.get(t);return e&&e.prototype.isBinary},e.prototype.isXml=function(t){var e=this.get(t);return e&&e.prototype.isXml},e.prototype.isJson=function(t){var e=this.get(t);return e&&e.prototype.isJson},e.prototype.getTrajectoryExtensions=function(){var t=this;return this.names.filter(function(e){return t.isTrajectory(e)})},e.prototype.getStructureExtensions=function(){var t=this;return this.names.filter(function(e){return t.isStructure(e)})},e.prototype.getVolumeExtensions=function(){var t=this;return this.names.filter(function(e){return t.isVolume(e)})},e.prototype.getSurfaceExtensions=function(){var t=this;return this.names.filter(function(e){return t.isSurface(e)})},e}(zh);function Fl(t){return Eh(function t(e){var i=e;return e.forEach(function(e){e.__deps&&Array.prototype.push.apply(i,t(e.__deps))}),i}(t)).map(function(t){return t.toString()}).join("\n\n\n")}function zl(t,e){var i="'use strict';\n\n"+Fl(e);return i+="\n\n\nself.func = "+t.toString()+";",i+="\n\n\nself.onmessage = "+function(t){var e=t.data.__name,i=t.data.__postId;void 0===e?console.error("message __name undefined"):void 0===self.func?console.error("worker func undefined",e):self.func(t,function(t,e){t=t||{},void 0!==i&&(t.__postId=i);try{self.postMessage(t,e)}catch(e){console.error("self.postMessage:",e),self.postMessage(t)}})}.toString()+";",new Blob([i],{type:"application/javascript"})}var Ul=function(){this.activeWorkerCount=0,this._funcDict={},this._depsDict={},this._blobDict={}};Ul.prototype.add=function(t,e,i){this._funcDict[t]=e,this._depsDict[t]=i},Ul.prototype.get=function(t){return this._blobDict[t]||(this._blobDict[t]=zl(this._funcDict[t],this._depsDict[t])),this._blobDict[t]};var jl=wh(),Gl=!1;try{var Vl=Object.defineProperty({},"passive",{get:function(){Gl=!0}});window.addEventListener("test",function(t){},Vl)}catch(t){}var Hl="undefined"!=typeof window&&void 0!==window.orientation,$l=!1;var Wl=!1;var Xl,ql={log:Function.prototype.bind.call(console.log,console),info:Function.prototype.bind.call(console.info,console),warn:Function.prototype.bind.call(console.warn,console),error:Function.prototype.bind.call(console.error,console),time:Function.prototype.bind.call(console.time,console),timeEnd:Function.prototype.bind.call(console.timeEnd,console)},Yl={color:"green",labelColor:"grey",labelAttachment:"bottom-center",labelSize:.7,labelZOffset:.5,labelYOffset:.1,labelBorder:!0,labelBorderColor:"lightgrey",labelBorderWidth:.25,lineOpacity:.8,linewidth:5,opacity:.6,labelUnit:"angstrom",arcVisible:!0,planeVisible:!1};t.Debug=!!(Xl=vh("debug"))&&("string"!=typeof Xl||/^1|true|t|yes|y$/i.test(Xl));var Zl=["ngl","js"],Kl=new Ul,Jl=new Nl,Ql=new zh("datasource"),tp=new zh("representatation"),ep=new Bl,ip=new zh("shader"),rp=new zh("decompressor"),np=new zh("component"),op=new zh("buffer"),ap=new zh("picker");var sp=function(t,e){void 0===e&&(e={}),this.chunkSize=10485760,this.newline="\n",this.__pointer=0,this.__partialLine="",this.compressed=yh(e.compressed,!1),this.binary=yh(e.binary,!1),this.json=yh(e.json,!1),this.xml=yh(e.xml,!1),this.src=t};sp.prototype.isBinary=function(){return this.binary||this.compressed},sp.prototype.read=function(){var t=this;return this._read().then(function(e){var i=t.compressed?rp.get(t.compressed):void 0;return t.compressed&&i?t.data=i(e):((t.binary||t.compressed)&&e instanceof ArrayBuffer&&(e=new Uint8Array(e)),t.data=e),t.data})},sp.prototype._chunk=function(t,e){return e=Math.min(this.data.length,e),0===t&&this.data.length===e?this.data:this.isBinary()?this.data.subarray(t,e):this.data.substring(t,e)},sp.prototype.chunk=function(t){var e=t+this.chunkSize;return this._chunk(t,e)},sp.prototype.peekLines=function(t){var e,i=this.data,r=i.length,n=this.isBinary()?this.newline.charCodeAt(0):this.newline,o=0;for(e=0;e<r&&(i[e]===n&&++o,o!==t);++e);var a=this._chunk(0,e+1);return this.chunkToLines(a,"",e>r).lines},sp.prototype.chunkCount=function(){return Math.floor(this.data.length/this.chunkSize)+1},sp.prototype.asText=function(){return this.isBinary()?Ch(this.data):this.data},sp.prototype.chunkToLines=function(t,e,i){var r=this.newline;if(!this.isBinary()&&t.length===this.data.length)return{lines:t.split(r),partialLine:""};var n=[],o=this.isBinary()?Ch(t):t,a=o.lastIndexOf(r);if(-1===a)e+=o;else{var s=e+o.substr(0,a);n=n.concat(s.split(r)),e=a===o.length-r.length?"":o.substr(a+r.length)}return i&&""!==e&&n.push(e),{lines:n,partialLine:e}},sp.prototype.nextChunk=function(){var t=this.__pointer;if(!(t>this.data.length))return this.__pointer+=this.chunkSize,this.chunk(t)},sp.prototype.nextChunkOfLines=function(){var t=this.nextChunk();if(void 0!==t){var e=this.__pointer>this.data.length,i=this.chunkToLines(t,this.__partialLine,e);return this.__partialLine=i.partialLine,i.lines}},sp.prototype.eachChunk=function(t){for(var e=this.chunkSize,i=this.data.length,r=this.chunkCount(),n=0;n<i;n+=e){t(this.chunk(n),Math.round(n/e),r)}},sp.prototype.eachChunkOfLines=function(t){var e=this;this.eachChunk(function(i,r,n){var o=r===n+1,a=e.chunkToLines(i,e.__partialLine,o);e.__partialLine=a.partialLine,t(a.lines,r,n)})},sp.prototype.dispose=function(){delete this.src};var cp=function(t){function e(){t.apply(this,arguments)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype._read=function(){var t=this;return new Promise(function(e,i){var r=t.src,n=new FileReader;n.onload=function(t){return e(t.target.result)},n.onerror=function(t){return i(t)},t.binary||t.compressed?n.readAsArrayBuffer(r):n.readAsText(r)})},e}(sp),up=function(t){function e(){t.apply(this,arguments)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype._read=function(){var t=this;return new Promise(function(e,i){var r=t.src,n=new XMLHttpRequest;n.open("GET",r,!0),n.addEventListener("load",function(){if(200===n.status||304===n.status||0===n.status)try{e(n.response)}catch(t){i(t)}else i(n.statusText)},!1),n.addEventListener("error",function(t){return i("network error")},!1),t.isBinary()?n.responseType="arraybuffer":t.json?n.responseType="json":t.xml?n.responseType="document":n.responseType="text",n.send(null)})},e}(sp),hp=function(t,e){void 0===e&&(e={}),this.parameters=bh(e,{ext:"",compressed:!1,binary:ep.isBinary(e.ext||""),name:"",dir:"",path:"",protocol:""});var i={compressed:this.parameters.compressed,binary:this.parameters.binary,json:ep.isJson(this.parameters.ext),xml:ep.isXml(this.parameters.ext)};"undefined"!=typeof File&&t instanceof File||"undefined"!=typeof Blob&&t instanceof Blob?this.streamer=new cp(t,i):this.streamer=new up(t,i)},lp=function(t){function e(e,i){void 0===i&&(i={}),t.call(this,e,i),this.parserParams={voxelSize:i.voxelSize,firstModelOnly:i.firstModelOnly,asTrajectory:i.asTrajectory,cAlphaOnly:i.cAlphaOnly,name:this.parameters.name,path:this.parameters.path}}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.load=function(){return new(ep.get(this.parameters.ext))(this.streamer,this.parserParams).parse()},e}(hp),pp=function(t,e,i){this.name=e,this.path=i,this.signals={elementAdded:new nl,elementRemoved:new nl,nameChanged:new nl},this.type="Script",this.dir=i.substring(0,i.lastIndexOf("/")+1);try{this.fn=new Function("stage","__name","__path","__dir",t)}catch(t){ql.error("Script compilation failed",t),this.fn=function(){}}};pp.prototype.run=function(t){var e=this;return new Promise(function(i,r){try{e.fn.apply(null,[t,e.name,e.path,e.dir]),i()}catch(t){ql.error("Script.fn",t),r(t)}})};var dp=function(t){function e(){t.apply(this,arguments)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.load=function(){var t=this;return this.streamer.read().then(function(){return new pp(t.streamer.asText(),t.parameters.name,t.parameters.path)})},e}(hp);function fp(t){var e,i,r=rp.names,n="",o=(e=t instanceof File?t.name:t instanceof Blob?"":t).lastIndexOf("?"),a=-1!==o?e.substring(o):"",s=(e=e.substring(0,-1===o?e.length:o)).replace(/^.*[\\/]/,""),c=s.substring(0,s.lastIndexOf(".")),u=s.split("."),h=u.length>1?(u.pop()||"").toLowerCase():"",l=e.match(/^(.+):\/\/(.+)$/);l&&(n=l[1].toLowerCase(),e=l[2]||"");var p=e.substring(0,e.lastIndexOf("/")+1);if(r.includes(h)){i=h;var d=e.length-h.length-1;h=(e.substr(0,d).split(".").pop()||"").toLowerCase();var f=c.length-h.length-1;c=c.substr(0,f)}else i=!1;return{path:e,name:s,ext:h,base:c,dir:p,compressed:i,protocol:n,query:a,src:t}}function mp(t){var e=fp(t),i=Ql.get(e.protocol);return i&&!(e=fp(i.getUrl(e.src))).ext&&i.getExt&&(e.ext=i.getExt(t)),e}function gp(t,e){void 0===e&&(e={});var i,r=Object.assign(mp(t),e);return ep.names.includes(r.ext)?i=new lp(r.src,r):Zl.includes(r.ext)&&(i=new dp(r.src,r)),i?i.load():Promise.reject(new Error("autoLoad: ext '"+r.ext+"' unknown"))}var vp=Kh(function(t,e){!function(){var t={not_string:/[^s]/,not_bool:/[^t]/,not_type:/[^T]/,not_primitive:/[^v]/,number:/[diefg]/,numeric_arg:/[bcdiefguxX]/,json:/[j]/,not_json:/[^j]/,text:/^[^\x25]+/,modulo:/^\x25{2}/,placeholder:/^\x25(?:([1-9]\d*)\$|\(([^\)]+)\))?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-gijostTuvxX])/,key:/^([a-z_][a-z_\d]*)/i,key_access:/^\.([a-z_][a-z_\d]*)/i,index_access:/^\[(\d+)\]/,sign:/^[\+\-]/};function i(e){return function(e,r){var n,o,a,s,c,u,h,l,p,d=1,f=e.length,m="";for(o=0;o<f;o++)if("string"==typeof e[o])m+=e[o];else if("object"==typeof e[o]){if((s=e[o]).keys)for(n=r[d],a=0;a<s.keys.length;a++){if(void 0==n)throw new Error(i('[sprintf] Cannot access property "%s" of undefined value "%s"',s.keys[a],s.keys[a-1]));n=n[s.keys[a]]}else n=s.param_no?r[s.param_no]:r[d++];if(t.not_type.test(s.type)&&t.not_primitive.test(s.type)&&n instanceof Function&&(n=n()),t.numeric_arg.test(s.type)&&"number"!=typeof n&&isNaN(n))throw new TypeError(i("[sprintf] expecting number but found %T",n));switch(t.number.test(s.type)&&(l=n>=0),s.type){case"b":n=parseInt(n,10).toString(2);break;case"c":n=String.fromCharCode(parseInt(n,10));break;case"d":case"i":n=parseInt(n,10);break;case"j":n=JSON.stringify(n,null,s.width?parseInt(s.width):0);break;case"e":n=s.precision?parseFloat(n).toExponential(s.precision):parseFloat(n).toExponential();break;case"f":n=s.precision?parseFloat(n).toFixed(s.precision):parseFloat(n);break;case"g":n=s.precision?String(Number(n.toPrecision(s.precision))):parseFloat(n);break;case"o":n=(parseInt(n,10)>>>0).toString(8);break;case"s":n=String(n),n=s.precision?n.substring(0,s.precision):n;break;case"t":n=String(!!n),n=s.precision?n.substring(0,s.precision):n;break;case"T":n=Object.prototype.toString.call(n).slice(8,-1).toLowerCase(),n=s.precision?n.substring(0,s.precision):n;break;case"u":n=parseInt(n,10)>>>0;break;case"v":n=n.valueOf(),n=s.precision?n.substring(0,s.precision):n;break;case"x":n=(parseInt(n,10)>>>0).toString(16);break;case"X":n=(parseInt(n,10)>>>0).toString(16).toUpperCase()}t.json.test(s.type)?m+=n:(!t.number.test(s.type)||l&&!s.sign?p="":(p=l?"+":"-",n=n.toString().replace(t.sign,"")),u=s.pad_char?"0"===s.pad_char?"0":s.pad_char.charAt(1):" ",h=s.width-(p+n).length,c=s.width&&h>0?u.repeat(h):"",m+=s.align?p+n+c:"0"===u?p+c+n:c+p+n)}return m}(function(e){if(n[e])return n[e];var i,r=e,o=[],a=0;for(;r;){if(null!==(i=t.text.exec(r)))o.push(i[0]);else if(null!==(i=t.modulo.exec(r)))o.push("%");else{if(null===(i=t.placeholder.exec(r)))throw new SyntaxError("[sprintf] unexpected placeholder");if(i[2]){a|=1;var s=[],c=i[2],u=[];if(null===(u=t.key.exec(c)))throw new SyntaxError("[sprintf] failed to parse named argument key");for(s.push(u[1]);""!==(c=c.substring(u[0].length));)if(null!==(u=t.key_access.exec(c)))s.push(u[1]);else{if(null===(u=t.index_access.exec(c)))throw new SyntaxError("[sprintf] failed to parse named argument key");s.push(u[1])}i[2]=s}else a|=2;if(3===a)throw new Error("[sprintf] mixing positional and named placeholders is not (yet) supported");o.push({placeholder:i[0],param_no:i[1],keys:i[2],sign:i[3],pad_char:i[4],align:i[5],width:i[6],precision:i[7],type:i[8]})}r=r.substring(i[0].length)}return n[e]=o}(e),arguments)}function r(t,e){return i.apply(null,[t].concat(e||[]))}var n=Object.create(null);e.sprintf=i,e.vsprintf=r,"undefined"!=typeof window&&(window.sprintf=i,window.vsprintf=r)}()}).sprintf,yp=function(){};yp.prototype.getBlob=function(){return new Blob([this.getData()],{type:this.mimeType})},yp.prototype.download=function(t,e){t=yh(t,this.defaultName),e=yh(e,this.defaultExt),Ah(this.getBlob(),t+"."+e)};var bp=function(t){function e(e,i){t.call(this),this.mimeType="text/plain",this.defaultName="structure",this.defaultExt="pdb";var r,n=Object.assign({},i);this.renumberSerial=yh(n.renumberSerial,!0),this.remarks=(r=yh(n.remarks,[]),Array.isArray(r)?r:[r]),this.structure=e,this._records=[]}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype._writeRecords=function(){this._records.length=0,this._writeTitle(),this._writeRemarks(),this._writeAtoms()},e.prototype._writeTitle=function(){this._records.push(vp("TITLE %-74s",this.structure.name))},e.prototype._writeRemarks=function(){var t=this;this.remarks.forEach(function(e){t._records.push(vp("REMARK %-73s",e))}),this.structure.trajectory&&(this._records.push(vp("REMARK %-73s","Trajectory '"+this.structure.trajectory.name+"'")),this._records.push(vp("REMARK %-73s","Frame "+this.structure.trajectory.frame)))},e.prototype._writeAtoms=function(){var t=this,e=1,i=1;this.structure.eachModel(function(r){t._records.push(vp("MODEL %-74d",i++)),r.eachAtom(function(i){var r=i.hetero?"HETATM%5d %-4s %3s %1s%4d    %8.3f%8.3f%8.3f%6.2f%6.2f      %4s%2s":"ATOM  %5d %-4s %3s %1s%4d    %8.3f%8.3f%8.3f%6.2f%6.2f      %4s%2s",n=t.renumberSerial?e:i.serial,o=i.atomname;1===o.length&&(o=" "+o),t._records.push(vp(r,n,o,i.resname,yh(i.chainname," "),i.resno,i.x,i.y,i.z,yh(i.occupancy,1),yh(i.bfactor,0),"",yh(i.element,""))),e+=1}),t._records.push(vp("%-80s","ENDMDL")),i+=1}),this._records.push(vp("%-80s","END"))},e.prototype.getString=function(){return console.warn("PdbWriter.getString() is deprecated, use .getData instead"),this.getData()},e.prototype.getData=function(){return this._writeRecords(),this._records.join("\n")},e}(yp),xp=function(t){function e(e){t.call(this),this.mimeType="text/plain",this.defaultName="structure",this.defaultExt="sdf",this.structure=e,this._records=[]}t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e;var i={idString:{configurable:!0},titleString:{configurable:!0},countsString:{configurable:!0},chargeLines:{configurable:!0}};return i.idString.get=function(){return this.structure.id},i.titleString.get=function(){return"  "+this.structure.title},i.countsString.get=function(){return vp("%3i%3i  0  0  0  0  0  0  0  0999 V2000",this.structure.atomCount,this.structure.bondCount)},i.chargeLines.get=function(){var t=[];this.structure.eachAtom(function(e){null!=e.formalCharge&&0!==e.formalCharge&&t.push([e.index,e.formalCharge])});for(var e=[],i=0;i<t.length;i+=8){for(var r=Math.min(8,t.length-i),n=vp("M  CHG%3i",r),o=i;o<i+r;o++)n+=vp(" %3i %3i",t[o][0]+1,t[o][1]);e.push(n)}return e},e.prototype.formatAtom=function(t){var e=0;null!=t.formalCharge&&0!==t.formalCharge&&(e=4-t.formalCharge);var i=vp("%10.4f%10.4f%10.4f %-3s 0%3i  0  0  0",t.x,t.y,t.z,t.element,e);if(48!==i.length)throw new Error("Incompatible atom for sdf format");return i},e.prototype.formatBond=function(t){return vp("%3i%3i%3i  0  0  0",t.atomIndex1+1,t.atomIndex2+1,t.bondOrder)},e.prototype._writeRecords=function(){this._records.length=0,this._writeHeader(),this._writeCTab(),this._writeFooter()},e.prototype._writeHeader=function(){this._records.push(this.idString,this.titleString,"")},e.prototype._writeCTab=function(){var t=this;this._records.push(this.countsString),this.structure.eachAtom(function(e){t._records.push(t.formatAtom(e))}),this.structure.eachBond(function(e){t._records.push(t.formatBond(e))}),this.chargeLines.forEach(function(e){t._records.push(e)}),this._records.push("M  END")},e.prototype._writeFooter=function(){this._records.push("$$$$")},e.prototype.getData=function(){return this._writeRecords(),this._records.join("\n")},Object.defineProperties(e.prototype,i),e}(yp),_p=[],wp=function(t,e){void 0===e&&(e={}),this._mark=0,this._marks=[],this.offset=0,this.littleEndian=!0;var i=!1;void 0===t&&(t=8192),"number"==typeof t?t=new ArrayBuffer(t):i=!0;var r=e.offset?e.offset>>>0:0,n=t.byteLength-r,o=r;t instanceof ArrayBuffer||(t.byteLength!==t.buffer.byteLength&&(o=t.byteOffset+r),t=t.buffer),this._lastWrittenByte=i?n:0,this.buffer=t,this.length=n,this.byteLength=n,this.byteOffset=o,this._data=new DataView(this.buffer,o,n)};wp.prototype.available=function(t){return void 0===t&&(t=1),this.offset+t<=this.length},wp.prototype.isLittleEndian=function(){return this.littleEndian},wp.prototype.setLittleEndian=function(){return this.littleEndian=!0,this},wp.prototype.isBigEndian=function(){return!this.littleEndian},wp.prototype.setBigEndian=function(){return this.littleEndian=!1,this},wp.prototype.skip=function(t){return void 0===t&&(t=1),this.offset+=t,this},wp.prototype.seek=function(t){return this.offset=t,this},wp.prototype.mark=function(){return this._mark=this.offset,this},wp.prototype.reset=function(){return this.offset=this._mark,this},wp.prototype.pushMark=function(){return this._marks.push(this.offset),this},wp.prototype.popMark=function(){var t=this._marks.pop();if(void 0===t)throw new Error("Mark stack empty");return this.seek(t),this},wp.prototype.rewind=function(){return this.offset=0,this},wp.prototype.ensureAvailable=function(t){if(void 0===t&&(t=1),!this.available(t)){var e=2*(this.offset+t),i=new Uint8Array(e);i.set(new Uint8Array(this.buffer)),this.buffer=i.buffer,this.length=this.byteLength=e,this._data=new DataView(this.buffer)}return this},wp.prototype.readBoolean=function(){return 0!==this.readUint8()},wp.prototype.readInt8=function(){return this._data.getInt8(this.offset++)},wp.prototype.readUint8=function(){return this._data.getUint8(this.offset++)},wp.prototype.readByte=function(){return this.readUint8()},wp.prototype.readBytes=function(t){void 0===t&&(t=1);for(var e=new Uint8Array(t),i=0;i<t;i++)e[i]=this.readByte();return e},wp.prototype.readInt16=function(){var t=this._data.getInt16(this.offset,this.littleEndian);return this.offset+=2,t},wp.prototype.readUint16=function(){var t=this._data.getUint16(this.offset,this.littleEndian);return this.offset+=2,t},wp.prototype.readInt32=function(){var t=this._data.getInt32(this.offset,this.littleEndian);return this.offset+=4,t},wp.prototype.readUint32=function(){var t=this._data.getUint32(this.offset,this.littleEndian);return this.offset+=4,t},wp.prototype.readFloat32=function(){var t=this._data.getFloat32(this.offset,this.littleEndian);return this.offset+=4,t},wp.prototype.readFloat64=function(){var t=this._data.getFloat64(this.offset,this.littleEndian);return this.offset+=8,t},wp.prototype.readChar=function(){return String.fromCharCode(this.readInt8())},wp.prototype.readChars=function(t){void 0===t&&(t=1),_p.length=t;for(var e=0;e<t;e++)_p[e]=this.readChar();return _p.join("")},wp.prototype.writeBoolean=function(t){return void 0===t&&(t=!1),this.writeUint8(t?255:0),this},wp.prototype.writeInt8=function(t){return this.ensureAvailable(1),this._data.setInt8(this.offset++,t),this._updateLastWrittenByte(),this},wp.prototype.writeUint8=function(t){return this.ensureAvailable(1),this._data.setUint8(this.offset++,t),this._updateLastWrittenByte(),this},wp.prototype.writeByte=function(t){return this.writeUint8(t)},wp.prototype.writeBytes=function(t){this.ensureAvailable(t.length);for(var e=0;e<t.length;e++)this._data.setUint8(this.offset++,t[e]);return this._updateLastWrittenByte(),this},wp.prototype.writeInt16=function(t){return this.ensureAvailable(2),this._data.setInt16(this.offset,t,this.littleEndian),this.offset+=2,this._updateLastWrittenByte(),this},wp.prototype.writeUint16=function(t){return this.ensureAvailable(2),this._data.setUint16(this.offset,t,this.littleEndian),this.offset+=2,this._updateLastWrittenByte(),this},wp.prototype.writeInt32=function(t){return this.ensureAvailable(4),this._data.setInt32(this.offset,t,this.littleEndian),this.offset+=4,this._updateLastWrittenByte(),this},wp.prototype.writeUint32=function(t){return this.ensureAvailable(4),this._data.setUint32(this.offset,t,this.littleEndian),this.offset+=4,this._updateLastWrittenByte(),this},wp.prototype.writeFloat32=function(t){return this.ensureAvailable(4),this._data.setFloat32(this.offset,t,this.littleEndian),this.offset+=4,this._updateLastWrittenByte(),this},wp.prototype.writeFloat64=function(t){return this.ensureAvailable(8),this._data.setFloat64(this.offset,t,this.littleEndian),this.offset+=8,this._updateLastWrittenByte(),this},wp.prototype.writeChar=function(t){return this.writeUint8(t.charCodeAt(0))},wp.prototype.writeChars=function(t){for(var e=0;e<t.length;e++)this.writeUint8(t.charCodeAt(e));return this},wp.prototype.toArray=function(){return new Uint8Array(this.buffer,this.byteOffset,this._lastWrittenByte)},wp.prototype._updateLastWrittenByte=function(){this.offset>this._lastWrittenByte&&(this._lastWrittenByte=this.offset)};var Sp=function(t){function e(e){t.call(this),this.mimeType="application/vnd.ms-pki.stl",this.defaultName="surface",this.defaultExt="stl",this.surface=e}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.getData=function(){var t=this.surface.index.length/3,e=new wp(2*t+3*t*4*4+80+4);e.skip(80),e.writeUint32(t);for(var i=new $e,r=new $e,n=new $e,o=new $e,a=0;a<t;a++){var s=[this.surface.index[3*a],this.surface.index[3*a+1],this.surface.index[3*a+2]];r.fromArray(this.surface.normal,3*s[0]),n.fromArray(this.surface.normal,3*s[1]),o.fromArray(this.surface.normal,3*s[2]),i.addVectors(r,n).add(o).normalize(),e.writeFloat32(i.x),e.writeFloat32(i.y),e.writeFloat32(i.z);for(var c=0;c<3;c++)i.fromArray(this.surface.position,3*s[c]),e.writeFloat32(i.x),e.writeFloat32(i.y),e.writeFloat32(i.z);e.writeUint16(0)}return new DataView(e.buffer)},e}(yp),Ap=function(){this.count=0,this.signals={countChanged:new nl}};Ap.prototype.clear=function(){this.change(-this.count)},Ap.prototype.change=function(t){this.count+=t,this.signals.countChanged.dispatch(t,this.count),this.count<0&&ql.warn("Counter.count below zero",this.count)},Ap.prototype.increment=function(){this.change(1)},Ap.prototype.decrement=function(){this.change(-1)},Ap.prototype.listen=function(t){this.change(t.count),t.signals.countChanged.add(this.change,this)},Ap.prototype.unlisten=function(t){var e=t.signals.countChanged;e.has(this.change,this)&&e.remove(this.change,this)},Ap.prototype.onZeroOnce=function(t,e){var i=this;if(0===this.count)t.call(e);else{var r=function(){0===i.count&&(i.signals.countChanged.remove(r,i),t.call(e))};this.signals.countChanged.add(r,this)}},Ap.prototype.dispose=function(){this.clear(),this.signals.countChanged.dispose()},ip.add("shader/BasicLine.vert","void main(){\n#include begin_vertex\n#include project_vertex\n}"),ip.add("shader/BasicLine.frag","uniform vec3 uColor;\n#include common\n#include fog_pars_fragment\nvoid main(){\ngl_FragColor = vec4( uColor, 1.0 );\n#include premultiplied_alpha_fragment\n#include tonemapping_fragment\n#include encodings_fragment\n#include fog_fragment\n}"),ip.add("shader/Quad.vert","varying vec2 vUv;\nvoid main() {\nvUv = uv;\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}"),ip.add("shader/Quad.frag","varying vec2 vUv;\nuniform sampler2D tForeground;\nuniform float scale;\nvoid main() {\nvec4 foreground = texture2D( tForeground, vUv );\ngl_FragColor = foreground * scale;\n}");var Mp=function(){this.signals={updated:new nl},this.maxDuration=-1/0,this.minDuration=1/0,this.avgDuration=14,this.lastDuration=1/0,this.prevFpsTime=0,this.lastFps=1/0,this.lastFrames=1,this.frames=0,this.count=0,this.begin()};Mp.prototype.update=function(){this.startTime=this.end(),this.currentTime=this.startTime,this.signals.updated.dispatch()},Mp.prototype.begin=function(){this.startTime=window.performance.now(),this.lastFrames=this.frames},Mp.prototype.end=function(){var t=window.performance.now();return this.count+=1,this.frames+=1,this.lastDuration=t-this.startTime,this.minDuration=Math.min(this.minDuration,this.lastDuration),this.maxDuration=Math.max(this.maxDuration,this.lastDuration),this.avgDuration-=this.avgDuration/30,this.avgDuration+=this.lastDuration/30,t>this.prevFpsTime+1e3&&(this.lastFps=this.frames,this.prevFpsTime=t,this.frames=0),t},ip.add("shader/chunk/fog_fragment.glsl","#ifdef USE_FOG\nfloat depth = length( vViewPosition );\n#ifdef FOG_EXP2\nfloat fogFactor = whiteCompliment( exp2( - fogDensity * fogDensity * depth * depth * LOG2 ) );\n#else\nfloat fogFactor = smoothstep( fogNear, fogFar, depth );\n#endif\ngl_FragColor.rgb = mix( gl_FragColor.rgb, fogColor, fogFactor );\n#endif"),ip.add("shader/chunk/interior_fragment.glsl","if( gl_FrontFacing == false ){\n#ifdef USE_INTERIOR_COLOR\noutgoingLight.xyz = interiorColor;\n#else\n#ifdef DIFFUSE_INTERIOR\noutgoingLight.xyz = vColor;\n#endif\n#endif\noutgoingLight.xyz *= 1.0 - interiorDarkening;\n}"),ip.add("shader/chunk/matrix_scale.glsl","float matrixScale( in mat4 m ){\nvec4 r = m[ 0 ];\nreturn sqrt( r[ 0 ] * r[ 0 ] + r[ 1 ] * r[ 1 ] + r[ 2 ] * r[ 2 ] );\n}"),ip.add("shader/chunk/nearclip_vertex.glsl","#ifdef NEAR_CLIP\nif( vViewPosition.z < clipNear - 5.0 )\ngl_Position.z = 2.0 * gl_Position.w;\n#endif"),ip.add("shader/chunk/nearclip_fragment.glsl","#ifdef NEAR_CLIP\nif( vViewPosition.z < clipNear )\ndiscard;\n#endif"),ip.add("shader/chunk/opaque_back_fragment.glsl","#ifdef OPAQUE_BACK\n#ifdef FLIP_SIDED\nif( gl_FrontFacing == true ){\ngl_FragColor.a = 1.0;\n}\n#else\nif( gl_FrontFacing == false ){\ngl_FragColor.a = 1.0;\n}\n#endif\n#endif"),ip.add("shader/chunk/radiusclip_vertex.glsl","#ifdef RADIUS_CLIP\nif( distance( vViewPosition, vClipCenter ) > clipRadius + 5.0 )\ngl_Position.z = 2.0 * gl_Position.w;\n#endif"),ip.add("shader/chunk/radiusclip_fragment.glsl","#ifdef RADIUS_CLIP\nif( distance( vViewPosition, vClipCenter ) > clipRadius )\ndiscard;\n#endif"),ip.add("shader/chunk/unpack_color.glsl","vec3 unpackColor(float f) {\nvec3 color;\ncolor.r = floor(f / 256.0 / 256.0);\ncolor.g = floor((f - color.r * 256.0 * 256.0) / 256.0);\ncolor.b = floor(f - color.r * 256.0 * 256.0 - color.g * 256.0);\nreturn color / 255.0;\n}");var Pp=/^(?!\/\/)\s*#include\s+(\S+)/gim,Tp={};function Ep(t,e){void 0===e&&(e={});var i=t+"|";for(var r in e)i+=r+":"+e[r];if(!Tp[i]){var n=function(t){if(void 0===t)return"";var e=[];for(var i in t){var r=t[i];r&&e.push("#define "+i+" "+r)}return e.join("\n")+"\n"}(e),o=ip.get("shader/"+t);if(!o)throw new Error("empty shader, '"+t+"'");o=o.replace(Pp,function(t,e){var i="shader/chunk/"+e+".glsl",r=ip.get(i)||Xi[e];if(!r)throw new Error("empty chunk, '"+e+"'");return r}),Tp[i]=n+o}return Tp[i]}if("undefined"!=typeof WebGLRenderingContext){var Cp=WebGLRenderingContext.prototype,Ip=Cp.getShaderParameter;Cp.getShaderParameter=function(){return!t.Debug||Ip.apply(this,arguments)};var Rp=Cp.getShaderInfoLog;Cp.getShaderInfoLog=function(){return t.Debug?Rp.apply(this,arguments):""};var Lp=Cp.getProgramParameter;Cp.getProgramParameter=function(e,i){return!t.Debug&&i===Cp.LINK_STATUS||Lp.apply(this,arguments)};var Op=Cp.getProgramInfoLog;Cp.getProgramInfoLog=function(){return t.Debug?Op.apply(this,arguments):""}}var Dp=[[[0,0]],[[4,4],[-4,-4]],[[-2,-6],[6,-2],[-6,2],[2,6]],[[1,-3],[-1,3],[5,1],[-3,-5],[-5,5],[-7,-1],[3,7],[7,-7]],[[1,1],[-1,-3],[-3,2],[4,-1],[-5,-2],[2,5],[5,3],[3,-5],[-2,6],[0,-7],[-4,-6],[-6,4],[-8,0],[7,-4],[6,7],[-7,-8]],[[-4,-7],[-7,-5],[-3,-5],[-5,-4],[-1,-4],[-2,-2],[-6,-1],[-4,0],[-7,1],[-1,2],[-6,3],[-3,3],[-7,6],[-3,6],[-5,7],[-1,7],[5,-7],[1,-6],[6,-5],[4,-4],[2,-3],[7,-2],[1,-1],[4,-1],[2,1],[6,2],[0,4],[4,4],[2,5],[7,5],[5,6],[3,7]]];Dp.forEach(function(t){t.forEach(function(t){t[0]*=.0625,t[1]*=.0625})});var kp=function(t,e,i,r){this.canvas=document.createElement("canvas"),this._viewer=i,this._factor=yh(r.factor,2),this._antialias=yh(r.antialias,!1),this._onProgress=r.onProgress,this._onFinish=r.onFinish,this._antialias&&(this._factor*=2),this._n=this._factor*this._factor,this._width=this._viewer.width,this._height=this._viewer.height,this._antialias?(this.canvas.width=this._width*this._factor/2,this.canvas.height=this._height*this._factor/2):(this.canvas.width=this._width*this._factor,this.canvas.height=this._height*this._factor),this._ctx=this.canvas.getContext("2d"),this._viewerSampleLevel=i.sampleLevel,this._viewer.setSampling(-1)};kp.prototype._renderTile=function(t){var e=this._viewer,i=this._width,r=this._height,n=this._factor,o=t%n*i,a=Math.floor(t/n)*r;e.camera.setViewOffset(i*n,r*n,o,a,i,r),e.render(),this._antialias?this._ctx.drawImage(e.renderer.domElement,Math.floor(o/2),Math.floor(a/2),Math.ceil(i/2),Math.ceil(r/2)):this._ctx.drawImage(e.renderer.domElement,Math.floor(o),Math.floor(a),Math.ceil(i),Math.ceil(r)),"function"==typeof this._onProgress&&this._onProgress(t+1,this._n,!1)},kp.prototype._finalize=function(){this._viewer.setSampling(this._viewerSampleLevel),this._viewer.camera.view=null,"function"==typeof this._onFinish&&this._onFinish(this._n+1,this._n,!1)},kp.prototype.render=function(){for(var t=0;t<=this._n;++t)t===this._n?this._finalize():this._renderTile(t)},kp.prototype.renderAsync=function(){for(var t=this,e=0,i=this._n,r=function(){e===i?t._finalize():t._renderTile(e),e+=1},n=0;n<=i;++n)setTimeout(r,0)};var Np=2*Math.PI,Bp=(Math.PI,180/Math.PI);function Fp(t,e,i,r,n){void 0===i&&(i=1),void 0===r&&(r=0);var o=n?n.length:t.length/i,a=0,s=0;if(n)for(var c=0;c<o;++c){var u=(t[n[c]*i+r]+e)%e/e*Np-Math.PI;a+=Math.cos(u),s+=Math.sin(u)}else for(var h=r;h<o;h+=i){var l=(t[h]+e)%e/e*Np-Math.PI;a+=Math.cos(l),s+=Math.sin(l)}return a/=o,s/=o,(Math.atan2(s,a)+Math.PI)/Np*e}function zp(t,e,i,r){void 0===r&&(r=0);var n=t.length;i=i||new Float32Array(n);for(var o=0;o<n;o+=3)i[r+o+0]=(t[o+0]+e[o+0])/2,i[r+o+1]=(t[o+1]+e[o+1])/2,i[r+o+2]=(t[o+2]+e[o+2])/2;return i}function Up(t,e){for(var i=t.length,r=new Float32Array(i),n=0;n<i;n+=3)r[n+0]=e[n+0]-t[n+0],r[n+1]=e[n+1]-t[n+1],r[n+2]=e[n+2]-t[n+2];return r}function jp(t,e,i){for(var r=i||new Float32Array(t),n=0;n<t;++n)r[n]=e;return r}function Gp(t,e,i,r,n){for(var o=n||new Float32Array(3*t),a=0;a<t;++a){var s=3*a;o[s+0]=e,o[s+1]=i,o[s+2]=r}return o}function Vp(t){for(var e=new Float32Array(t),i=0;i<t;++i)e[i]=i;return e}function Hp(t,e,i,r){void 0===i&&(i=0);for(var n=r||new Float32Array(t*e),o=0;o<t;++o)for(var a=i+o*e,s=0;s<e;++s)n[a+s]=o;return n}function $p(t,e){for(var i=t.length,r=new Float32Array(i*e),n=0;n<i;++n)for(var o=n*e,a=t[n],s=0;s<e;++s)r[o+s]=a;return r}function Wp(t,e,i,r,n){for(var o=0;o<n;++o)e[r+o]=t[i+o]}function Xp(t,e,i,r){Wp(t,t,e,i,r)}function qp(t){for(var e=-1/0,i=0,r=t.length;i<r;++i)t[i]>e&&(e=t[i]);return e}function Yp(t){for(var e=1/0,i=0,r=t.length;i<r;++i)t[i]<e&&(e=t[i]);return e}function Zp(t,e,i){void 0===e&&(e=1),void 0===i&&(i=0);for(var r=t.length,n=0,o=i;o<r;o+=e)n+=t[o];return n}function Kp(t,e,i){return void 0===e&&(e=1),void 0===i&&(i=0),Zp(t,e,i)/(t.length/e)}var Jp={trim:!1,factor:1,antialias:!1,transparent:!1,onProgress:void 0};function Qp(t,e){void 0===e&&(e={});var i=bh(e,Jp),r=i.trim,n=i.factor,o=i.antialias,a=i.transparent,s=t.renderer,c=t.camera,u=s.getClearAlpha(),h=s.getClearColor();function l(e){void 0===e&&(e=!1);var i=n;o&&(i*=2),e&&(i=1/i),t.scene.traverse(function(t){var e=t.material;e&&e.linewidth&&(e.linewidth*=i),e&&e.uniforms&&e.uniforms.size&&void 0===e.uniforms.size.__seen&&(e.uniforms.size.value*=i,e.uniforms.size.__seen=!0),e&&e.uniforms&&e.uniforms.linewidth&&void 0===e.uniforms.linewidth.__seen&&(e.uniforms.linewidth.value*=i,e.uniforms.linewidth.__seen=!0)}),t.scene.traverse(function(t){var e=t.material;e&&e.uniforms&&e.uniforms.size&&delete e.uniforms.size.__seen,e&&e.uniforms&&e.uniforms.linewidth&&delete e.uniforms.linewidth.__seen})}function p(t){if(r){var e=h;return function(t,e,i,r,n){var o,a,s,c,u=t.height,h=t.width,l=t.getContext("2d").getImageData(0,0,h,u).data;for(s=!1,a=0;a<u;a++){for(o=0;o<h;o++)if(l[c=4*(a*h+o)]!==e||l[c+1]!==i||l[c+2]!==r||l[c+3]!==n){s=!0;break}if(s)break}var p=a;for(s=!1,o=0;o<h;o++){for(a=0;a<u;a++)if(l[c=4*(a*h+o)]!==e||l[c+1]!==i||l[c+2]!==r||l[c+3]!==n){s=!0;break}if(s)break}var d=o;for(s=!1,a=u-1;a>=0;a--){for(o=h-1;o>=0;o--)if(l[c=4*(a*h+o)]!==e||l[c+1]!==i||l[c+2]!==r||l[c+3]!==n){s=!0;break}if(s)break}var f=a;for(s=!1,o=h-1;o>=0;o--){for(a=u-1;a>=0;a--)if(l[c=4*(a*h+o)]!==e||l[c+1]!==i||l[c+2]!==r||l[c+3]!==n){s=!0;break}if(s)break}var m=o,g=document.createElement("canvas");return g.width=m-d,g.height=f-p,g.getContext("2d").drawImage(t,d,p,g.width,g.height,0,0,g.width,g.height),g}(t,a?0:255*e.r,a?0:255*e.g,a?0:255*e.b,a?0:255)}return t}function d(t,i,r){"function"==typeof e.onProgress&&e.onProgress(t,i,r)}return new Promise(function(e,i){var r=new kp(s,c,t,{factor:n,antialias:o,onProgress:d,onFinish:function(n,o){p(r.canvas).toBlob(function(r){s.setClearAlpha(u),l(!0),t.requestRender(),d(o,o,!0),r?e(r):i("error creating image")},"image/png")}});s.setClearAlpha(a?0:1),l(),r.renderAsync()})}var td=new $e,ed=new Ve,id=new Ve;var rd=new Ge,nd=new Ve,od=new Ve;function ad(t,e){nd.getInverse(e.projectionMatrix),od.copy(e.projectionMatrix).transpose(),t.traverse(function(t){var e=t.material;if(e){var i=e.uniforms;i&&(i.projectionMatrixInverse&&i.projectionMatrixInverse.value.copy(nd),i.projectionMatrixTranspose&&i.projectionMatrixTranspose.value.copy(od))}})}function sd(t,e,i){var r=t.createShader(i);return t.shaderSource(r,e),t.compileShader(r),t.getShaderParameter(r,t.COMPILE_STATUS)?r:(console.log("error compiling shader "+r+": "+t.getShaderInfoLog(r)),t.deleteShader(r),null)}function cd(t,e){var i=t.getExtension(e);return i||console.log("extension '"+e+"' not available"),i}var ud="\nattribute vec4 a_position;\n\nvoid main() {\n  gl_Position = a_position;\n}",hd="\nprecision mediump float;\nuniform vec4 u_color;\nuniform sampler2D u_texture;\n\nvoid main() {\n  gl_FragColor = texture2D(u_texture, vec2(0.5, 0.5)) * u_color;\n}",ld=new Float32Array([-1,-1,1,-1,-1,1,-1,1,1,-1,1,1]);function pd(t){var e=document.createElement("canvas");e.width=16,e.height=16,e.style.width="16px",e.style.height="16px";var i=e.getContext("webgl")||e.getContext("experimental-webgl");if(!i)return console.log("error creating webgl context for "+t),!1;cd(i,"OES_texture_float"),cd(i,"OES_texture_half_float"),cd(i,"WEBGL_color_buffer_float");var r=sd(i,ud,i.VERTEX_SHADER),n=sd(i,hd,i.FRAGMENT_SHADER);if(!r||!n)return!1;var o,a,s,c,u,h=(a=[r,n],u=(o=i).createProgram(),a.forEach(function(t){return o.attachShader(u,t)}),s&&s.forEach(function(t,e){o.bindAttribLocation(u,c?c[e]:e,t)}),o.linkProgram(u),o.getProgramParameter(u,o.LINK_STATUS)?u:(console.log("error linking program: "+o.getProgramInfoLog(u)),o.deleteProgram(u),null));i.useProgram(h);var l=i.getAttribLocation(h,"a_position"),p=i.getUniformLocation(h,"u_color");if(!p)return console.log("error getting 'u_color' uniform location"),!1;var d=i.createBuffer();i.bindBuffer(i.ARRAY_BUFFER,d),i.bufferData(i.ARRAY_BUFFER,ld,i.STATIC_DRAW),i.enableVertexAttribArray(l),i.vertexAttribPointer(l,2,i.FLOAT,!1,0,0);var f=i.createTexture(),m=new Uint8Array([255,255,255,255]);i.bindTexture(i.TEXTURE_2D,f),i.texImage2D(i.TEXTURE_2D,0,i.RGBA,1,1,0,i.RGBA,i.UNSIGNED_BYTE,m);var g=i.createTexture();i.bindTexture(i.TEXTURE_2D,g),i.texImage2D(i.TEXTURE_2D,0,i.RGBA,1,1,0,i.RGBA,t,null),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_MIN_FILTER,i.NEAREST),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_MAG_FILTER,i.NEAREST);var v=i.createFramebuffer();if(i.bindFramebuffer(i.FRAMEBUFFER,v),i.framebufferTexture2D(i.FRAMEBUFFER,i.COLOR_ATTACHMENT0,i.TEXTURE_2D,g,0),i.checkFramebufferStatus(i.FRAMEBUFFER)!==i.FRAMEBUFFER_COMPLETE)return console.log("error creating framebuffer for "+t),!1;i.bindTexture(i.TEXTURE_2D,f),i.uniform4fv(p,[0,10,20,1]),i.drawArrays(i.TRIANGLES,0,6),i.bindTexture(i.TEXTURE_2D,g),i.bindFramebuffer(i.FRAMEBUFFER,null),i.clearColor(1,0,0,1),i.clear(i.COLOR_BUFFER_BIT),i.uniform4fv(p,[0,.1,.05,1]),i.drawArrays(i.TRIANGLES,0,6);var y=new Uint8Array(4);if(i.readPixels(0,0,1,1,i.RGBA,i.UNSIGNED_BYTE,y),0!==y[0]||y[1]<248||y[2]<248||y[3]<254)return console.log("not able to actually render to "+t+" texture"),!1;if(t===i.FLOAT){i.bindFramebuffer(i.FRAMEBUFFER,v);var b=new Float32Array(4);i.readPixels(0,0,1,1,i.RGBA,i.FLOAT,b);var x=i.getError();if(x)return console.log("error reading pixels as float: '"+function(t,e){switch(e){case t.NO_ERROR:return"no error";case t.INVALID_ENUM:return"invalid enum";case t.INVALID_VALUE:return"invalid value";case t.INVALID_OPERATION:return"invalid operation";case t.INVALID_FRAMEBUFFER_OPERATION:return"invalid framebuffer operation";case t.OUT_OF_MEMORY:return"out of memory";case t.CONTEXT_LOST_WEBGL:return"context lost"}return"unknown error"}(i,x)+"'"),!1}return!0}var dd=new Float32Array(4),fd=new Uint8Array(4),md=new Ve;function gd(t,e,i,r,n){var o=n.uniforms,a=[];if(o.objectId&&(o.objectId.value=$l?this.id:this.id/255,a.push("objectId")),(o.modelViewMatrixInverse||o.modelViewMatrixInverseTranspose||o.modelViewProjectionMatrix||o.modelViewProjectionMatrixInverse)&&this.modelViewMatrix.multiplyMatrices(i.matrixWorldInverse,this.matrixWorld),o.modelViewMatrixInverse&&(o.modelViewMatrixInverse.value.getInverse(this.modelViewMatrix),a.push("modelViewMatrixInverse")),o.modelViewMatrixInverseTranspose&&(o.modelViewMatrixInverse?o.modelViewMatrixInverseTranspose.value.copy(o.modelViewMatrixInverse.value).transpose():o.modelViewMatrixInverseTranspose.value.getInverse(this.modelViewMatrix).transpose(),a.push("modelViewMatrixInverseTranspose")),o.modelViewProjectionMatrix&&(o.modelViewProjectionMatrix.value.multiplyMatrices(i.projectionMatrix,this.modelViewMatrix),a.push("modelViewProjectionMatrix")),o.modelViewProjectionMatrixInverse&&(o.modelViewProjectionMatrix?(md.copy(o.modelViewProjectionMatrix.value),o.modelViewProjectionMatrixInverse.value.getInverse(md)):(md.multiplyMatrices(i.projectionMatrix,this.modelViewMatrix),o.modelViewProjectionMatrixInverse.value.getInverse(md)),a.push("modelViewProjectionMatrixInverse")),a.length){var s=t.properties.get(n);if(s.program){var c=t.getContext(),u=s.program;c.useProgram(u.program);var h=u.getUniforms();a.forEach(function(t){h.setValue(c,t,o[t].value)})}}}var vd=function(t){if(this.boundingBox=new xr,this.boundingBoxSize=new $e,this.boundingBoxLength=0,this.info={memory:{programs:0,geometries:0,textures:0},render:{calls:0,vertices:0,faces:0,points:0}},this.distVector=new $e,this.signals={ticked:new nl,rendered:new nl},"string"==typeof t){var e=document.getElementById(t);this.container=null===e?document.createElement("div"):e}else t instanceof HTMLElement?this.container=t:this.container=document.createElement("div");if(this.container===document.body)this.width=window.innerWidth||1,this.height=window.innerHeight||1;else{var i=this.container.getBoundingClientRect();this.width=i.width||1,this.height=i.height||1,this.container.style.overflow="hidden"}this.wrapper=document.createElement("div"),this.wrapper.style.position="relative",this.container.appendChild(this.wrapper),this._initParams(),this._initStats(),this._initCamera(),this._initScene(),!1!==this._initRenderer()?(this._initHelper(),this.setBackground(),this.setFog(),this.animate=this.animate.bind(this)):ql.error("Viewer: could not initialize renderer")};vd.prototype._initParams=function(){this.parameters={fogColor:new Gi(0),fogNear:50,fogFar:100,backgroundColor:new Gi(0),cameraType:"perspective",cameraFov:40,cameraZ:-80,clipNear:0,clipFar:100,clipDist:10,lightColor:new Gi(14540253),lightIntensity:1,ambientColor:new Gi(14540253),ambientIntensity:.2,sampleLevel:0}},vd.prototype._initCamera=function(){var t=new $e(0,0,0),e=this.width,i=this.height;this.perspectiveCamera=new jo(this.parameters.cameraFov,e/i),this.perspectiveCamera.position.z=this.parameters.cameraZ,this.perspectiveCamera.lookAt(t),this.orthographicCamera=new Zr(e/-2,e/2,i/2,i/-2),this.orthographicCamera.position.z=this.parameters.cameraZ,this.orthographicCamera.lookAt(t),this.stereoCamera=new Du,this.stereoCamera.aspect=.5;var r=this.parameters.cameraType;if("orthographic"===r)this.camera=this.orthographicCamera;else{if("perspective"!==r&&"stereo"!==r)throw new Error("Unknown cameraType '"+r+"'");this.camera=this.perspectiveCamera}this.camera.updateProjectionMatrix()},vd.prototype._initStats=function(){this.stats=new Mp},vd.prototype._initScene=function(){this.scene||(this.scene=new Xo,this.scene.name="scene"),this.rotationGroup=new sa,this.rotationGroup.name="rotationGroup",this.scene.add(this.rotationGroup),this.translationGroup=new sa,this.translationGroup.name="translationGroup",this.rotationGroup.add(this.translationGroup),this.modelGroup=new sa,this.modelGroup.name="modelGroup",this.translationGroup.add(this.modelGroup),this.pickingGroup=new sa,this.pickingGroup.name="pickingGroup",this.translationGroup.add(this.pickingGroup),this.backgroundGroup=new sa,this.backgroundGroup.name="backgroundGroup",this.translationGroup.add(this.backgroundGroup),this.helperGroup=new sa,this.helperGroup.name="helperGroup",this.translationGroup.add(this.helperGroup),this.scene.fog=new Wo(this.parameters.fogColor.getHex()),this.spotLight=new uc(this.parameters.lightColor.getHex(),this.parameters.lightIntensity),this.scene.add(this.spotLight),this.ambientLight=new dc(this.parameters.ambientColor.getHex(),this.parameters.ambientIntensity),this.scene.add(this.ambientLight)},vd.prototype._initRenderer=function(){var e=window.devicePixelRatio,i=this.width,r=this.height;try{this.renderer=new Ho({preserveDrawingBuffer:!0,alpha:!0,antialias:!0})}catch(t){return this.wrapper.innerHTML='<div style="display:flex;align-items:center;justify-content:center;height:100%;"><p style="padding:15px;text-align:center;">Your browser/graphics card does not seem to support <a target="_blank" href="https://en.wikipedia.org/wiki/WebGL">WebGL</a>.<br/><br/>Find out how to get it <a target="_blank" href="http://get.webgl.org/">here</a>.</p></div>',!1}this.renderer.setPixelRatio(e),this.renderer.setSize(i,r),this.renderer.autoClear=!1,this.renderer.sortObjects=!0;var n,o,a=this.renderer.getContext();n=this.renderer.extensions.get("EXT_frag_depth"),Wl=n,this.renderer.extensions.get("OES_element_index_uint"),o=this.renderer.extensions.get("OES_texture_float")&&this.renderer.extensions.get("WEBGL_color_buffer_float")||this.renderer.extensions.get("OES_texture_float")&&pd(a.FLOAT),$l=o,this.wrapper.appendChild(this.renderer.domElement);var s=i*e,c=r*e;this.renderer.extensions.get("OES_texture_float"),this.supportsHalfFloat=this.renderer.extensions.get("OES_texture_half_float")&&pd(36193),this.renderer.extensions.get("WEBGL_color_buffer_float"),t.Debug&&console.log(JSON.stringify({Browser:jl,OES_texture_float:!!this.renderer.extensions.get("OES_texture_float"),OES_texture_half_float:!!this.renderer.extensions.get("OES_texture_half_float"),WEBGL_color_buffer_float:!!this.renderer.extensions.get("WEBGL_color_buffer_float"),"testTextureSupport Float":pd(a.FLOAT),"testTextureSupport HalfFloat":pd(36193),"this.supportsHalfFloat":this.supportsHalfFloat,SupportsReadPixelsFloat:$l},null,2)),this.pickingTarget=new Je(s,c,{minFilter:$t,magFilter:$t,stencilBuffer:!1,format:le,type:$l?re:Kt}),this.pickingTarget.texture.generateMipmaps=!1,this.renderer.clearTarget(this.pickingTarget,!0,!0,!0),this.renderer.setRenderTarget(null),this.sampleTarget=new Je(s,c,{minFilter:qt,magFilter:qt,format:le}),this.holdTarget=new Je(s,c,{minFilter:$t,magFilter:$t,format:le,type:Kt}),this.compositeUniforms={tForeground:new $u(this.sampleTarget.texture),scale:new $u(1)},this.compositeMaterial=new oo({uniforms:this.compositeUniforms,vertexShader:Ep("Quad.vert"),fragmentShader:Ep("Quad.frag"),premultipliedAlpha:!0,transparent:!0,blending:Q,depthTest:!1,depthWrite:!1}),this.compositeCamera=new Zr(-1,1,1,-1,0,1),this.compositeScene=new Xo,this.compositeScene.name="compositeScene",this.compositeScene.add(new uo(new io(2,2),this.compositeMaterial))},vd.prototype._initHelper=function(){var t=new Uint16Array([0,1,1,2,2,3,3,0,4,5,5,6,6,7,7,4,0,4,1,5,2,6,3,7]),e=new Float32Array(24),i=new Qn;i.setIndex(new sn(t,1)),i.addAttribute("position",new sn(e,3));var r=new oo({uniforms:{uColor:{value:new Gi("skyblue")}},vertexShader:Ep("BasicLine.vert"),fragmentShader:Ep("BasicLine.frag")});this.boundingBoxMesh=new ra(i,r),this.helperGroup.add(this.boundingBoxMesh)},vd.prototype.updateHelper=function(){var t=this.boundingBoxMesh.geometry.attributes.position,e=t.array,i=this.boundingBox,r=i.min,n=i.max;e[0]=n.x,e[1]=n.y,e[2]=n.z,e[3]=r.x,e[4]=n.y,e[5]=n.z,e[6]=r.x,e[7]=r.y,e[8]=n.z,e[9]=n.x,e[10]=r.y,e[11]=n.z,e[12]=n.x,e[13]=n.y,e[14]=r.z,e[15]=r.x,e[16]=n.y,e[17]=r.z,e[18]=r.x,e[19]=r.y,e[20]=r.z,e[21]=n.x,e[22]=r.y,e[23]=r.z,t.needsUpdate=!0,this.boundingBox.isEmpty()||this.boundingBoxMesh.geometry.computeBoundingSphere()},vd.prototype.add=function(e,i){var r=this;i?i.forEach(function(t){return r.addBuffer(e,t)}):this.addBuffer(e),e.parameters.background?(this.backgroundGroup.add(e.group),this.backgroundGroup.add(e.wireframeGroup)):(this.modelGroup.add(e.group),this.modelGroup.add(e.wireframeGroup)),e.pickable&&this.pickingGroup.add(e.pickingGroup),t.Debug&&this.updateHelper()},vd.prototype.addBuffer=function(t,e){function i(r){r instanceof sa?r.children.forEach(i):(r.userData.buffer=t,r.userData.instance=e,r.onBeforeRender=gd)}var r=t.getMesh();e&&r.applyMatrix(e.matrix),i(r),t.group.add(r);var n=t.getWireframeMesh();if(e&&(n.matrix.copy(r.matrix),n.position.copy(r.position),n.quaternion.copy(r.quaternion),n.scale.copy(r.scale)),i(n),t.wireframeGroup.add(n),t.pickable){var o=t.getPickingMesh();e&&(o.matrix.copy(r.matrix),o.position.copy(r.position),o.quaternion.copy(r.quaternion),o.scale.copy(r.scale)),i(o),t.pickingGroup.add(o)}e?this._updateBoundingBox(t.geometry,t.matrix,e.matrix):this._updateBoundingBox(t.geometry,t.matrix)},vd.prototype.remove=function(e){this.translationGroup.children.forEach(function(t){t.remove(e.group),t.remove(e.wireframeGroup)}),e.pickable&&this.pickingGroup.remove(e.pickingGroup),this.updateBoundingBox(),t.Debug&&this.updateHelper()},vd.prototype._updateBoundingBox=function(t,e,i){var r=this.boundingBox;function n(t,e,i){t.boundingBox||t.computeBoundingBox();var n=t.boundingBox.clone();e&&n.applyMatrix4(e),i&&n.applyMatrix4(i),n.min.equals(n.max)&&n.expandByScalar(5),r.union(n)}function o(t){var e,i;void 0!==t.geometry&&(t.userData.buffer&&(e=t.userData.buffer.matrix),t.userData.instance&&(i=t.userData.instance.matrix),n(t.geometry,e,i))}t?n(t,e,i):(r.makeEmpty(),this.modelGroup.traverse(o),this.backgroundGroup.traverse(o)),r.getSize(this.boundingBoxSize),this.boundingBoxLength=this.boundingBoxSize.length()},vd.prototype.updateBoundingBox=function(){this._updateBoundingBox(),t.Debug&&this.updateHelper()},vd.prototype.getPickingPixels=function(){var t=this.width,e=this.height,i=t*e*4,r=$l?new Float32Array(i):new Uint8Array(i);return this.render(!0),this.renderer.readRenderTargetPixels(this.pickingTarget,0,0,t,e,r),r},vd.prototype.getImage=function(t){var e=this;return new Promise(function(i){if(t){var r=e,n=r.width,o=r.height,a=n*o*4,s=e.getPickingPixels();if($l){for(var c=new Uint8Array(a),u=0;u<a;++u)c[u]=Math.round(255*s[u]);s=c}var h=document.createElement("canvas");h.width=n,h.height=o;var l=h.getContext("2d"),p=l.getImageData(0,0,n,o);p.data.set(s),l.putImageData(p,0,0),h.toBlob(i,"image/png")}else e.renderer.domElement.toBlob(i,"image/png")})},vd.prototype.makeImage=function(t){return void 0===t&&(t={}),Qp(this,t)},vd.prototype.setLight=function(t,e,i,r){var n=this.parameters;void 0!==t&&n.lightColor.set(t),void 0!==e&&(n.lightIntensity=e),void 0!==i&&n.ambientColor.set(i),void 0!==r&&(n.ambientIntensity=r),this.requestRender()},vd.prototype.setFog=function(t,e,i){var r=this.parameters;void 0!==t&&r.fogColor.set(t),void 0!==e&&(r.fogNear=e),void 0!==i&&(r.fogFar=i),this.requestRender()},vd.prototype.setBackground=function(t){var e=this.parameters;t&&e.backgroundColor.set(t),this.setFog(e.backgroundColor),this.renderer.setClearColor(e.backgroundColor,0),this.renderer.domElement.style.backgroundColor=e.backgroundColor.getStyle(),this.requestRender()},vd.prototype.setSampling=function(t){void 0!==t&&(this.parameters.sampleLevel=t,this.sampleLevel=t),this.requestRender()},vd.prototype.setCamera=function(t,e){var i=this.parameters;if(t&&(i.cameraType=t),e&&(i.cameraFov=e),"orthographic"===i.cameraType)this.camera!==this.orthographicCamera&&(this.camera=this.orthographicCamera,this.camera.position.copy(this.perspectiveCamera.position),this.camera.up.copy(this.perspectiveCamera.up),this.updateZoom());else{if("perspective"!==i.cameraType&&"stereo"!==i.cameraType)throw new Error("Unknown cameraType '"+i.cameraType+"'");this.camera!==this.perspectiveCamera&&(this.camera=this.perspectiveCamera,this.camera.position.copy(this.orthographicCamera.position),this.camera.up.copy(this.orthographicCamera.up))}this.perspectiveCamera.fov=i.cameraFov,this.camera.updateProjectionMatrix(),this.requestRender()},vd.prototype.setClip=function(t,e,i){var r=this.parameters;void 0!==t&&(r.clipNear=t),void 0!==e&&(r.clipFar=e),void 0!==i&&(r.clipDist=i),this.requestRender()},vd.prototype.setSize=function(t,e){this.width=t||1,this.height=e||1,this.perspectiveCamera.aspect=this.width/this.height,this.orthographicCamera.left=-this.width/2,this.orthographicCamera.right=this.width/2,this.orthographicCamera.top=this.height/2,this.orthographicCamera.bottom=-this.height/2,this.camera.updateProjectionMatrix();var i=window.devicePixelRatio;this.renderer.setPixelRatio(i),this.renderer.setSize(t,e);var r=this.width*i,n=this.height*i;this.pickingTarget.setSize(r,n),this.sampleTarget.setSize(r,n),this.holdTarget.setSize(r,n),this.requestRender()},vd.prototype.handleResize=function(){if(this.container===document.body)this.setSize(window.innerWidth,window.innerHeight);else{var t=this.container.getBoundingClientRect();this.setSize(t.width,t.height)}},vd.prototype.updateInfo=function(t){var e=this.info,i=e.memory,r=e.render;if(t)i.programs=0,i.geometries=0,i.textures=0,r.calls=0,r.vertices=0,r.faces=0,r.points=0;else{var n=this.renderer.info,o=n.memory,a=n.render;i.geometries=o.geometries,i.textures=o.textures,r.calls+=a.calls,r.vertices+=a.vertices,r.faces+=a.faces,r.points+=a.points}},vd.prototype.animate=function(){if(this.signals.ticked.dispatch(this.stats),window.performance.now()-this.stats.startTime>500&&!this.isStill&&this.sampleLevel<3&&-1!==this.sampleLevel){var e=this.sampleLevel;this.sampleLevel=3,this.renderPending=!0,this.render(),this.isStill=!0,this.sampleLevel=e,t.Debug&&ql.log("rendered still frame")}window.requestAnimationFrame(this.animate)},vd.prototype.pick=function(t,e){if("stereo"===this.parameters.cameraType)return{pid:0,instance:void 0,picker:void 0};var i,r,n;t*=window.devicePixelRatio,e*=window.devicePixelRatio;var o=$l?dd:fd;this.render(!0),this.renderer.readRenderTargetPixels(this.pickingTarget,t,e,1,1,o),i=$l?Math.round(255*o[0])<<16&16711680|Math.round(255*o[1])<<8&65280|255&Math.round(255*o[2]):o[0]<<16|o[1]<<8|o[2];var a=Math.round(o[3]),s=this.pickingGroup.getObjectById(a);return s&&(r=s.userData.instance,n=s.userData.buffer.picking),{pid:i,instance:r,picker:n}},vd.prototype.requestRender=function(){var t=this;this.renderPending||(window.performance.now()-this.stats.startTime>22&&(this.stats.begin(),this.isStill=!1),this.renderPending=!0,window.requestAnimationFrame(function(){t.render(),t.stats.update()}))},vd.prototype.updateZoom=function(){var t=jh(this.perspectiveCamera.fov),e=2*Math.tan(t/2)*-this.camera.position.z;this.orthographicCamera.zoom=this.height/e},vd.prototype.__updateClipping=function(){var t=this.parameters;this.cDist=this.distVector.copy(this.camera.position).length(),this.cDist||(this.camera.position.set(0,0,t.cameraZ),this.cDist=Math.abs(t.cameraZ)),this.bRadius=Math.max(10,.5*this.boundingBoxLength),this.bRadius+=this.boundingBox.getCenter(this.distVector).length(),(this.bRadius===1/0||this.bRadius===-1/0||isNaN(this.bRadius))&&(this.bRadius=50);var e=(50-t.clipNear)/50,i=-(50-t.clipFar)/50;this.camera.near=this.cDist-this.bRadius*e,this.camera.far=this.cDist+this.bRadius*i;var r=(50-t.fogNear)/50,n=-(50-t.fogFar)/50,o=this.scene.fog;o.color.set(t.fogColor),o.near=this.cDist-this.bRadius*r,o.far=this.cDist+this.bRadius*n,"PerspectiveCamera"===this.camera.type?(this.camera.near=Math.max(.1,t.clipDist,this.camera.near),this.camera.far=Math.max(1,this.camera.far),o.near=Math.max(.1,o.near),o.far=Math.max(1,o.far)):"OrthographicCamera"===this.camera.type&&t.clipDist>0&&(this.camera.near=Math.max(t.clipDist,this.camera.near))},vd.prototype.__updateCamera=function(){var t,e,i,r,n,o,a,s,c,u,h,l,p,d=this.camera;d.updateMatrix(),d.updateMatrixWorld(!0),d.updateProjectionMatrix(),t=this.scene,e=d,i=this.renderer,r=this.cDist,n=this.bRadius,o=i.getSize(),a=o.width,s=o.height,c=s,u=i.getPixelRatio(),h="OrthographicCamera"===e.type,rd.set(a,s),nd.getInverse(e.projectionMatrix),od.copy(e.projectionMatrix).transpose(),t.traverse(function(t){var e=t.material;if(e){var i=e.uniforms;if(i){if(e.clipNear){var o=(50-e.clipNear)/50,a=r-n*o;i.clipNear.value=a}i.canvasHeight&&(i.canvasHeight.value=c),i.resolution&&i.resolution.value.copy(rd),i.pixelRatio&&(i.pixelRatio.value=u),i.projectionMatrixInverse&&i.projectionMatrixInverse.value.copy(nd),i.projectionMatrixTranspose&&i.projectionMatrixTranspose.value.copy(od),i.ortho&&(i.ortho.value=h)}}}),l=this.scene,p=d,l.traverseVisible(function(t){if(t instanceof aa&&t.userData.buffer.parameters.sortParticles){var e=t.geometry.attributes,i=e.position.count;if(0!==i){var r,n,o,a,s,c,u;ed.multiplyMatrices(p.matrixWorldInverse,t.matrixWorld),id.multiplyMatrices(p.projectionMatrix,ed),t.userData.sortData?(r=t.userData.sortData,o=r.__zArray,n=r.__sortArray,a=r.__cmpFn):(o=new Float32Array(i),n=new Uint32Array(i),r={__zArray:o,__sortArray:n,__cmpFn:a=function(t,e){var i=o[t],r=o[e];return i>r?1:i<r?-1:0}},t.userData.sortData=r);for(var h=0;h<i;++h)td.fromArray(e.position.array,3*h),td.applyMatrix4(id),o[h]=-td.z,n[h]=h;for(var l in function(t,e,i,r){void 0===i&&(i=0),e=e||function(t,e){return t>e?1:t<e?-1:0};var n,o,a,s=[],c=-1,u=i,h=r=(r||t.length)-1;function l(e,i){var r=t[e];t[e]=t[i],t[i]=r}for(;;)if(h-u<=25){for(var p=u+1;p<=h;++p){for(n=t[p],o=p-1;o>=u&&e(t[o],n)>0;)t[o+1]=t[o],--o;t[o+1]=n}if(-1===c)break;h=s[c--],u=s[c--]}else{for(a=h,l(u+h>>1,o=u+1),e(t[u],t[h])>0&&l(u,h),e(t[o],t[h])>0&&l(o,h),e(t[u],t[o])>0&&l(u,o),n=t[o];;){do{o++}while(e(t[o],n)<0);do{a--}while(e(t[a],n)>0);if(a<o)break;l(o,a)}t[u+1]=t[a],t[a]=n,h-o+1>=a-u?(s[++c]=o,s[++c]=h,h=a-1):(s[++c]=u,s[++c]=a-1,u=o)}}(n,a),e){var d=e[l],f=d.array,m=d.itemSize;r[l]||(r[l]=new Float32Array(m*i)),u=r[l],r[l]=f;for(var g=0;g<i;++g){s=n[g];for(var v=0;v<m;++v)c=s*m+v,u[g*m+v]=f[c]}e[l].array=u,e[l].needsUpdate=!0}}}})},vd.prototype.__setVisibility=function(t,e,i,r){this.modelGroup.visible=t,this.pickingGroup.visible=e,this.backgroundGroup.visible=i,this.helperGroup.visible=r},vd.prototype.__updateLights=function(){this.spotLight.color.set(this.parameters.lightColor),this.spotLight.intensity=this.parameters.lightIntensity,this.distVector.copy(this.camera.position).setLength(100*this.boundingBoxLength),this.spotLight.position.copy(this.camera.position).add(this.distVector),this.ambientLight.color.set(this.parameters.ambientColor),this.ambientLight.intensity=this.parameters.ambientIntensity},vd.prototype.__renderPickingGroup=function(t){this.renderer.clearTarget(this.pickingTarget,!0,!0,!0),this.__setVisibility(!1,!0,!1,!1),this.renderer.render(this.scene,t,this.pickingTarget),this.updateInfo(),this.renderer.setRenderTarget(null)},vd.prototype.__renderModelGroup=function(e,i){i?this.renderer.clearTarget(i,!0,!0,!0):this.renderer.clear(),this.__setVisibility(!1,!1,!0,!1),this.renderer.render(this.scene,e,i),i?this.renderer.clearTarget(i,!1,!0,!1):this.renderer.clearDepth(),this.updateInfo(),this.__setVisibility(!0,!1,!1,t.Debug),this.renderer.render(this.scene,e,i),this.updateInfo()},vd.prototype.__renderSuperSample=function(t){var e=Dp[Math.max(0,Math.min(this.sampleLevel,5))],i=1/e.length;this.compositeUniforms.tForeground.value=this.sampleTarget.texture;var r=this.sampleTarget.width,n=this.sampleTarget.height;"stereo"===this.parameters.cameraType&&(r/=2);for(var o=0;o<e.length;++o){var a=e[o];t.setViewOffset(r,n,a[0],a[1],r,n),t.updateProjectionMatrix(),ad(this.scene,t);var s=i;s+=1/32*((o+.5)/e.length-.5),this.compositeUniforms.scale.value=s,this.__renderModelGroup(t,this.sampleTarget),this.renderer.render(this.compositeScene,this.compositeCamera,this.holdTarget,0===o)}this.compositeUniforms.scale.value=1,this.compositeUniforms.tForeground.value=this.holdTarget.texture,t.clearViewOffset(),this.renderer.render(this.compositeScene,this.compositeCamera,null,!0)},vd.prototype.__renderStereo=function(t){void 0===t&&(t=!1);var e=this.stereoCamera;e.update(this.perspectiveCamera);var i=this.renderer,r=i.getSize();i.setScissorTest(!0),i.setScissor(0,0,r.width/2,r.height),i.setViewport(0,0,r.width/2,r.height),ad(this.scene,e.cameraL),this.__render(t,e.cameraL),i.setScissor(r.width/2,0,r.width/2,r.height),i.setViewport(r.width/2,0,r.width/2,r.height),ad(this.scene,e.cameraR),this.__render(t,e.cameraR),i.setScissorTest(!1),i.setViewport(0,0,r.width,r.height)},vd.prototype.__render=function(t,e){void 0===t&&(t=!1),t?this.lastRenderedPicking||this.__renderPickingGroup(e):this.sampleLevel>0&&"stereo"!==this.parameters.cameraType?this.__renderSuperSample(e):this.__renderModelGroup(e)},vd.prototype.render=function(t){void 0===t&&(t=!1),this.rendering?ql.warn("'tried to call 'render' from within 'render'"):(this.rendering=!0,this.__updateClipping(),this.__updateCamera(),this.__updateLights(),this.updateInfo(!0),"stereo"===this.parameters.cameraType?this.__renderStereo(t):this.__render(t,this.camera),this.lastRenderedPicking=t,this.rendering=!1,this.renderPending=!1,this.signals.rendered.dispatch())},vd.prototype.clear=function(){ql.log("scene cleared"),this.scene.remove(this.rotationGroup),this._initScene(),this.renderer.clear()};function yd(t){var e=t.touches[0].pageX-t.touches[1].pageX,i=t.touches[0].pageY-t.touches[1].pageY;return Math.sqrt(e*e+i*i)}var bd=function(t,e){void 0===e&&(e={}),this.domElement=t,this.signals={moved:new nl,scrolled:new nl,dragged:new nl,dropped:new nl,clicked:new nl,hovered:new nl,doubleClicked:new nl},this.position=new Ge,this.prevPosition=new Ge,this.down=new Ge,this.canvasPosition=new Ge,this.prevClickCP=new Ge,this.moving=!1,this.hovering=!0,this.scrolled=!1,this.lastMoved=1/0,this.which=0,this.buttons=0,this.pressed=!1,this.altKey=!1,this.ctrlKey=!1,this.metaKey=!1,this.shiftKey=!1,this.domElement.style.touchAction="none",this.hoverTimeout=yh(e.hoverTimeout,50),this.handleScroll=yh(e.handleScroll,!0),this.doubleClickSpeed=yh(e.doubleClickSpeed,500),this._listen=this._listen.bind(this),this._onMousewheel=this._onMousewheel.bind(this),this._onMousemove=this._onMousemove.bind(this),this._onMousedown=this._onMousedown.bind(this),this._onMouseup=this._onMouseup.bind(this),this._onContextmenu=this._onContextmenu.bind(this),this._onTouchstart=this._onTouchstart.bind(this),this._onTouchend=this._onTouchend.bind(this),this._onTouchmove=this._onTouchmove.bind(this),this._listen(),document.addEventListener("mousewheel",this._onMousewheel),document.addEventListener("wheel",this._onMousewheel),document.addEventListener("MozMousePixelScroll",this._onMousewheel),document.addEventListener("mousemove",this._onMousemove),document.addEventListener("mousedown",this._onMousedown),document.addEventListener("mouseup",this._onMouseup),document.addEventListener("contextmenu",this._onContextmenu),document.addEventListener("touchstart",this._onTouchstart),document.addEventListener("touchend",this._onTouchend),document.addEventListener("touchmove",this._onTouchmove)},xd={key:{configurable:!0}};xd.key.get=function(){var t=0;return this.altKey&&(t+=1),this.ctrlKey&&(t+=2),this.metaKey&&(t+=4),this.shiftKey&&(t+=8),t},bd.prototype.setParameters=function(t){void 0===t&&(t={}),this.hoverTimeout=yh(t.hoverTimeout,this.hoverTimeout)},bd.prototype._listen=function(){var t=window.performance.now(),e=this.canvasPosition;this.doubleClickPending&&t-this.lastClicked>this.doubleClickSpeed&&(this.doubleClickPending=!1),t-this.lastMoved>this.hoverTimeout&&(this.moving=!1),(this.scrolled||!this.moving&&!this.hovering)&&(this.scrolled=!1,-1!==this.hoverTimeout&&this.overElement&&(this.hovering=!0,this.signals.hovered.dispatch(e.x,e.y))),window.requestAnimationFrame(this._listen)},bd.prototype._onMousewheel=function(t){var e=this;if(t.target===this.domElement&&this.handleScroll){t.preventDefault(),this._setKeys(t);var i=0;i=t.wheelDelta?t.wheelDelta/40:t.detail?-t.detail/3:-t.deltaY/(t.deltaMode?.33:30),this.signals.scrolled.dispatch(i),setTimeout(function(){e.scrolled=!0},this.hoverTimeout)}},bd.prototype._onMousemove=function(t){t.target===this.domElement?(t.preventDefault(),this.overElement=!0):this.overElement=!1,this._setKeys(t),this.moving=!0,this.hovering=!1,this.lastMoved=window.performance.now(),this.prevPosition.copy(this.position),this.position.set(t.clientX,t.clientY),this._setCanvasPosition(t);var e=this.prevPosition.x-this.position.x,i=this.prevPosition.y-this.position.y;this.signals.moved.dispatch(e,i),this.pressed&&this.signals.dragged.dispatch(e,i)},bd.prototype._onMousedown=function(t){t.target===this.domElement&&(t.preventDefault(),this._setKeys(t),this.moving=!1,this.hovering=!1,this.down.set(t.clientX,t.clientY),this.position.set(t.clientX,t.clientY),this.which=t.which,this.buttons=function(t){if("object"==typeof t){if("buttons"in t)return t.buttons;if("which"in t){var e=t.which;if(2===e)return 4;if(3===e)return 2;if(e>0)return 1<<e-1}else if("button"in t){var i=t.button;if(1===i)return 4;if(2===i)return 2;if(i>=0)return 1<<i}}return 0}(t),this.pressed=!0,this._setCanvasPosition(t))},bd.prototype._onMouseup=function(t){t.target===this.domElement&&t.preventDefault(),this._setKeys(t);var e=this.canvasPosition;this._distance()<4&&(this.lastClicked=window.performance.now(),this.doubleClickPending&&this.prevClickCP.distanceTo(e)<4&&(this.signals.doubleClicked.dispatch(e.x,e.y),this.doubleClickPending=!1),this.signals.clicked.dispatch(e.x,e.y),this.doubleClickPending=!0,this.prevClickCP.copy(e)),this.which=void 0,this.buttons=void 0,this.pressed=void 0},bd.prototype._onContextmenu=function(t){t.target===this.domElement&&t.preventDefault()},bd.prototype._onTouchstart=function(t){if(t.target===this.domElement)switch(t.preventDefault(),this.pressed=!0,t.touches.length){case 1:this.moving=!1,this.hovering=!1,this.down.set(t.touches[0].pageX,t.touches[0].pageY),this.position.set(t.touches[0].pageX,t.touches[0].pageY),this._setCanvasPosition(t.touches[0]);break;case 2:this.down.set((t.touches[0].pageX+t.touches[1].pageX)/2,(t.touches[0].pageY+t.touches[1].pageY)/2),this.position.set((t.touches[0].pageX+t.touches[1].pageX)/2,(t.touches[0].pageY+t.touches[1].pageY)/2),this.lastTouchDistance=yd(t)}},bd.prototype._onTouchend=function(t){t.target===this.domElement&&t.preventDefault(),this.which=void 0,this.buttons=void 0,this.pressed=void 0},bd.prototype._onTouchmove=function(t){switch(t.target===this.domElement?(t.preventDefault(),this.overElement=!0):this.overElement=!1,t.touches.length){case 1:this._setKeys(t),this.which=1,this.buttons=1,this.moving=!0,this.hovering=!1,this.lastMoved=window.performance.now(),this.prevPosition.copy(this.position),this.position.set(t.touches[0].pageX,t.touches[0].pageY),this._setCanvasPosition(t.touches[0]);var e=this.prevPosition.x-this.position.x,i=this.prevPosition.y-this.position.y;this.signals.moved.dispatch(e,i),this.pressed&&this.signals.dragged.dispatch(e,i);break;case 2:var r=yd(t),n=r-this.lastTouchDistance;if(this.lastTouchDistance=r,this.prevPosition.copy(this.position),this.position.set((t.touches[0].pageX+t.touches[1].pageX)/2,(t.touches[0].pageY+t.touches[1].pageY)/2),Math.abs(n)>2&&this.handleScroll&&this.position.distanceTo(this.prevPosition)<2)this.which=0,this.buttons=0,this.signals.scrolled.dispatch(n/2);else{this.which=3,this.buttons=2;var o=this.prevPosition.x-this.position.x,a=this.prevPosition.y-this.position.y;this.signals.moved.dispatch(o,a),this.pressed&&this.signals.dragged.dispatch(o,a)}}},bd.prototype._distance=function(){return this.position.distanceTo(this.down)},bd.prototype._setCanvasPosition=function(t){var e,i,r=this.domElement.getBoundingClientRect();"offsetX"in t&&"offsetY"in t?(e=t.offsetX,i=t.offsetY):(e=t.clientX-r.left,i=t.clientY-r.top),this.canvasPosition.set(e,r.height-i)},bd.prototype._setKeys=function(t){this.altKey=t.altKey,this.ctrlKey=t.ctrlKey,this.metaKey=t.metaKey,this.shiftKey=t.shiftKey},bd.prototype.dispose=function(){document.removeEventListener("mousewheel",this._onMousewheel),document.removeEventListener("wheel",this._onMousewheel),document.removeEventListener("MozMousePixelScroll",this._onMousewheel),document.removeEventListener("mousemove",this._onMousemove),document.removeEventListener("mousedown",this._onMousedown),document.removeEventListener("mouseup",this._onMouseup),document.removeEventListener("contextmenu",this._onContextmenu),document.removeEventListener("touchstart",this._onTouchstart),document.removeEventListener("touchend",this._onTouchend),document.removeEventListener("touchmove",this._onTouchmove)},Object.defineProperties(bd.prototype,xd);var _d=new Ve,wd=new Ve,Sd=new Ve,Ad=new $e,Md=new He,Pd=new Ve,Td=new $e,Ed=new $e,Cd=function(t,e){void 0===e&&(e={}),this.stage=t,this.rotateSpeed=yh(e.rotateSpeed,2),this.zoomSpeed=yh(e.zoomSpeed,1.2),this.panSpeed=yh(e.panSpeed,1),this.viewer=t.viewer,this.mouse=t.mouseObserver,this.controls=t.viewerControls},Id={component:{configurable:!0},atom:{configurable:!0}};Id.component.get=function(){return this.stage.transformComponent},Id.atom.get=function(){return this.stage.transformAtom},Cd.prototype._setPanVector=function(t,e,i){void 0===i&&(i=0);var r=this.controls.getCanvasScaleFactor(i);Td.set(t,e,0),Td.multiplyScalar(this.panSpeed*r)},Cd.prototype._getRotateXY=function(t,e){return[this.rotateSpeed*-t*.01,this.rotateSpeed*e*.01]},Cd.prototype._transformPanVector=function(){this.component&&(Pd.extractRotation(this.component.transform),Pd.premultiply(this.viewer.rotationGroup.matrix),Pd.getInverse(Pd),Td.applyMatrix4(Pd))},Cd.prototype.zoom=function(t){this.controls.zoom(this.zoomSpeed*t*.02)},Cd.prototype.pan=function(t,e){this._setPanVector(t,e),Pd.getInverse(this.viewer.rotationGroup.matrix),Td.applyMatrix4(Pd),this.controls.translate(Td)},Cd.prototype.panComponent=function(t,e){this.component&&(this._setPanVector(t,e),this._transformPanVector(),this.component.position.add(Td),this.component.updateMatrix())},Cd.prototype.panAtom=function(t,e){this.atom&&this.component&&(this.atom.positionToVector3(Ed),Ed.add(this.viewer.translationGroup.position),Ed.applyMatrix4(this.viewer.rotationGroup.matrix),this._setPanVector(t,e,Ed.z),this._transformPanVector(),this.atom.positionAdd(Td),this.component.updateRepresentations({position:!0}))},Cd.prototype.rotate=function(t,e){var i=this._getRotateXY(t,e),r=i[0],n=i[1];_d.makeRotationX(n),wd.makeRotationY(r),_d.multiply(wd),this.controls.applyMatrix(_d)},Cd.prototype.rotateComponent=function(t,e){if(this.component){var i=this._getRotateXY(t,e),r=i[0],n=i[1];Sd.extractRotation(this.component.transform),Sd.premultiply(this.viewer.rotationGroup.matrix),Sd.getInverse(Sd),Ad.set(1,0,0),Ad.applyMatrix4(Sd),_d.makeRotationAxis(Ad,n),Ad.set(0,1,0),Ad.applyMatrix4(Sd),wd.makeRotationAxis(Ad,r),_d.multiply(wd),Md.setFromRotationMatrix(_d),this.component.quaternion.premultiply(Md),this.component.updateMatrix()}},Object.defineProperties(Cd.prototype,Id);var Rd=new $e;var Ld=function(t,e){this.stage=e,this.pid=t.pid,this.picker=t.picker,this.instance=t.instance,this.stage=e,this.controls=e.viewerControls,this.mouse=e.mouseObserver},Od={type:{configurable:!0},altKey:{configurable:!0},ctrlKey:{configurable:!0},metaKey:{configurable:!0},shiftKey:{configurable:!0},canvasPosition:{configurable:!0},component:{configurable:!0},object:{configurable:!0},position:{configurable:!0},closestBondAtom:{configurable:!0},closeAtom:{configurable:!0},arrow:{configurable:!0},atom:{configurable:!0},axes:{configurable:!0},bond:{configurable:!0},box:{configurable:!0},cone:{configurable:!0},clash:{configurable:!0},contact:{configurable:!0},cylinder:{configurable:!0},distance:{configurable:!0},ellipsoid:{configurable:!0},octahedron:{configurable:!0},point:{configurable:!0},mesh:{configurable:!0},slice:{configurable:!0},sphere:{configurable:!0},tetrahedron:{configurable:!0},torus:{configurable:!0},surface:{configurable:!0},unitcell:{configurable:!0},unknown:{configurable:!0},volume:{configurable:!0},wideline:{configurable:!0}};Od.type.get=function(){return this.picker.type},Od.altKey.get=function(){return this.mouse.altKey},Od.ctrlKey.get=function(){return this.mouse.ctrlKey},Od.metaKey.get=function(){return this.mouse.metaKey},Od.shiftKey.get=function(){return this.mouse.shiftKey},Od.canvasPosition.get=function(){return this.mouse.canvasPosition},Od.component.get=function(){return this.stage.getComponentsByObject(this.picker.data).list[0]},Od.object.get=function(){return this.picker.getObject(this.pid)},Od.position.get=function(){return this.picker.getPosition(this.pid,this.instance,this.component)},Od.closestBondAtom.get=function(){if("bond"===this.type&&this.bond){var t,e,i,r=this.bond,n=this.controls,o=this.canvasPosition,a=n.getPositionOnCanvas(r.atom1),s=n.getPositionOnCanvas(r.atom2);return e=a,i=s,(t=o).distanceTo(e)<t.distanceTo(i)?r.atom1:r.atom2}},Od.closeAtom.get=function(){var t=this.canvasPosition,e=this.closestBondAtom;if(e){var i=this.controls.getPositionOnCanvas(e);e.positionToVector3(Rd),this.instance&&Rd.applyMatrix4(this.instance.matrix),Rd.applyMatrix4(this.component.matrix);var r=this.controls.viewer;Rd.add(r.translationGroup.position),Rd.applyMatrix4(r.rotationGroup.matrix);var n=this.controls.getCanvasScaleFactor(Rd.z),o=this.component.getMaxRepresentationRadius(e.index);return t.distanceTo(i)<=o/n?e:void 0}},Od.arrow.get=function(){return this._objectIfType("arrow")},Od.atom.get=function(){return this._objectIfType("atom")},Od.axes.get=function(){return this._objectIfType("axes")},Od.bond.get=function(){return this._objectIfType("bond")},Od.box.get=function(){return this._objectIfType("box")},Od.cone.get=function(){return this._objectIfType("cone")},Od.clash.get=function(){return this._objectIfType("clash")},Od.contact.get=function(){return this._objectIfType("contact")},Od.cylinder.get=function(){return this._objectIfType("cylinder")},Od.distance.get=function(){return this._objectIfType("distance")},Od.ellipsoid.get=function(){return this._objectIfType("ellipsoid")},Od.octahedron.get=function(){return this._objectIfType("octahedron")},Od.point.get=function(){return this._objectIfType("point")},Od.mesh.get=function(){return this._objectIfType("mesh")},Od.slice.get=function(){return this._objectIfType("slice")},Od.sphere.get=function(){return this._objectIfType("sphere")},Od.tetrahedron.get=function(){return this._objectIfType("tetrahedron")},Od.torus.get=function(){return this._objectIfType("torus")},Od.surface.get=function(){return this._objectIfType("surface")},Od.unitcell.get=function(){return this._objectIfType("unitcell")},Od.unknown.get=function(){return this._objectIfType("unknown")},Od.volume.get=function(){return this._objectIfType("volume")},Od.wideline.get=function(){return this._objectIfType("wideline")},Ld.prototype._objectIfType=function(t){return this.type===t?this.object:void 0},Ld.prototype.getLabel=function(){var t=this.atom||this.closeAtom,e="nothing";return this.arrow?e=this.arrow.name:t?e="atom: "+t.qualifiedName()+" ("+t.structure.name+")":this.axes?e="axes":this.bond?e="bond: "+this.bond.atom1.qualifiedName()+" - "+this.bond.atom2.qualifiedName()+" ("+this.bond.structure.name+")":this.box?e=this.box.name:this.cone?e=this.cone.name:this.clash?e="clash: "+this.clash.clash.sele1+" - "+this.clash.clash.sele2:this.contact?e=this.contact.type+": "+this.contact.atom1.qualifiedName()+" - "+this.contact.atom2.qualifiedName()+" ("+this.contact.atom1.structure.name+")":this.cylinder?e=this.cylinder.name:this.distance?e="distance: "+this.distance.atom1.qualifiedName()+" - "+this.distance.atom2.qualifiedName()+" ("+this.distance.structure.name+")":this.ellipsoid?e=this.ellipsoid.name:this.octahedron?e=this.octahedron.name:this.point?e=this.point.name:this.mesh?e="mesh: "+(this.mesh.name||this.mesh.serial)+" ("+this.mesh.shape.name+")":this.slice?e="slice: "+this.slice.value.toPrecision(3)+" ("+this.slice.volume.name+")":this.sphere?e=this.sphere.name:this.surface?e="surface: "+this.surface.surface.name:this.tetrahedron?e=this.tetrahedron.name:this.torus?e=this.torus.name:this.unitcell?e="unitcell: "+this.unitcell.unitcell.spacegroup+" ("+this.unitcell.structure.name+")":this.unknown?e="unknown":this.volume?e="volume: "+this.volume.value.toPrecision(3)+" ("+this.volume.volume.name+")":this.wideline&&(e=this.wideline.name),e},Object.defineProperties(Ld.prototype,Od);var Dd=function(t){this.stage=t,this.viewer=t.viewer};Dd.prototype.pick=function(t,e){var i=this.viewer.pick(t,e);if(i.picker&&"ignore"!==i.picker.type&&void 0!==i.pid){var r=i.picker.array;if(!(r&&i.pid>=r.length))return new Ld(i,this.stage);console.error("pid >= picker.array.length")}};var kd=new He,Nd=new $e,Bd=new $e,Fd=new $e,zd=new $e,Ud=new Ve,jd=new $e,Gd=new Ve,Vd=function(t){this.stage=t,this.signals={changed:new nl},this.viewer=t.viewer},Hd={position:{configurable:!0},rotation:{configurable:!0}};Hd.position.get=function(){return this.viewer.translationGroup.position},Hd.rotation.get=function(){return this.viewer.rotationGroup.quaternion},Vd.prototype.changed=function(){this.viewer.requestRender(),this.signals.changed.dispatch()},Vd.prototype.getPositionOnCanvas=function(t,e){var i=Oh(e,Ge),r=this.viewer;return Fd.copy(t).add(r.translationGroup.position).applyMatrix4(r.rotationGroup.matrix).project(r.camera),i.set((Fd.x+1)*r.width/2,(Fd.y+1)*r.height/2)},Vd.prototype.getCanvasScaleFactor=function(t){void 0===t&&(t=0);var e=this.viewer.camera;if(e instanceof Zr)return 1/e.zoom;t=-t,t+=e.position.z;var i=jh(e.fov);return-2*t*Math.tan(i/2)/this.viewer.height},Vd.prototype.getOrientation=function(t){var e=kh(t);e.copy(this.viewer.rotationGroup.matrix);var i=-this.viewer.camera.position.z;return e.scale(zd.set(i,i,i)),e.setPosition(this.viewer.translationGroup.position),e},Vd.prototype.orient=function(t){kh(t).decompose(Nd,kd,Bd);var e=this.viewer;e.rotationGroup.setRotationFromQuaternion(kd),e.translationGroup.position.copy(Nd),e.camera.position.z=-Bd.z,e.updateZoom(),this.changed()},Vd.prototype.translate=function(t){this.viewer.translationGroup.position.add(Dh(t)),this.changed()},Vd.prototype.center=function(t){this.viewer.translationGroup.position.copy(Dh(t)).negate(),this.changed()},Vd.prototype.zoom=function(t){this.distance(this.viewer.camera.position.z*(1-t))},Vd.prototype.distance=function(t){this.viewer.camera.position.z=Math.min(-1,t),this.viewer.updateZoom(),this.changed()},Vd.prototype.spin=function(t,e){Ud.getInverse(this.viewer.rotationGroup.matrix),jd.copy(Dh(t)).applyMatrix4(Ud),this.viewer.rotationGroup.rotateOnAxis(jd,e),this.changed()},Vd.prototype.rotate=function(t){this.viewer.rotationGroup.setRotationFromQuaternion(Nh(t)),this.changed()},Vd.prototype.align=function(t){Gd.getInverse(kh(t)),this.viewer.rotationGroup.setRotationFromMatrix(Gd),this.changed()},Vd.prototype.applyMatrix=function(t){this.viewer.rotationGroup.applyMatrix(kh(t)),this.changed()},Object.defineProperties(Vd.prototype,Hd);var $d=function(t,e){for(var i,r=[],n=arguments.length-2;n-- >0;)r[n]=arguments[n+2];this.pausedTime=-1,this.elapsedDuration=0,this.pausedDuration=0,this.ignoreGlobalToggle=!1,this._paused=!1,this._resolveList=[],this.duration=yh(t,1e3),this.controls=e,this.startTime=window.performance.now(),(i=this)._init.apply(i,r)},Wd={done:{configurable:!0},paused:{configurable:!0}};Wd.done.get=function(){return 1===this.alpha},Wd.paused.get=function(){return this._paused},$d.prototype.tick=function(t){if(!this._paused)return this.elapsedDuration=t.currentTime-this.startTime-this.pausedDuration,0===this.duration?this.alpha=1:this.alpha=Yh(0,1,this.elapsedDuration/this.duration),this._tick(t),this.done&&this._resolveList.forEach(function(t){return t()}),this.done},$d.prototype.pause=function(t){t&&(this._hold=!0),-1===this.pausedTime&&(this.pausedTime=window.performance.now()),this._paused=!0},$d.prototype.resume=function(t){!t&&this._hold||(this.pausedDuration+=window.performance.now()-this.pausedTime,this._paused=!1,this._hold=!1,this.pausedTime=-1)},$d.prototype.toggle=function(){this._paused?this.resume():this.pause()},$d.prototype.then=function(t){var e=this;return(this.done?Promise.resolve():new Promise(function(t){return e._resolveList.push(t)})).then(t)},Object.defineProperties($d.prototype,Wd);var Xd=function(t){function e(e,i){for(var r=[],n=arguments.length-2;n-- >0;)r[n]=arguments[n+2];t.apply(this,[yh(e,1/0),i].concat(r))}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype._init=function(t,e){Array.isArray(t)?this.axis=(new $e).fromArray(t):this.axis=yh(t,new $e(0,1,0)),this.angle=yh(e,.01)},e.prototype._tick=function(t){this.axis&&this.angle&&this.controls.spin(this.axis,this.angle*t.lastDuration/16)},e}($d),qd=function(t){function e(e,i){for(var r=[],n=arguments.length-2;n-- >0;)r[n]=arguments[n+2];t.apply(this,[yh(e,1/0),i].concat(r)),this.angleSum=0,this.direction=1}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype._init=function(t,e,i){Array.isArray(t)?this.axis=(new $e).fromArray(t):this.axis=yh(t,new $e(0,1,0)),this.angleStep=yh(e,.01),this.angleEnd=yh(i,.2)},e.prototype._tick=function(t){if(this.axis&&this.angleStep&&this.angleEnd){var e=Yh(0,1,Math.abs(this.angleSum)/this.angleEnd),i=this.angleStep*this.direction*(1.1-e);this.controls.spin(this.axis,i*t.lastDuration/16),this.angleSum+=this.angleStep,this.angleSum>=this.angleEnd&&(this.direction*=-1,this.angleSum=-this.angleEnd)}},e}($d),Yd=function(t){function e(){t.apply(this,arguments)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype._init=function(t,e){this.moveFrom=Dh(yh(t,new $e)),this.moveTo=Dh(yh(e,new $e))},e.prototype._tick=function(){this.controls.position.lerpVectors(this.moveFrom,this.moveTo,this.alpha).negate(),this.controls.changed()},e}($d),Zd=function(t){function e(){t.apply(this,arguments)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype._init=function(t,e){this.zoomFrom=t,this.zoomTo=e},e.prototype._tick=function(){this.controls.distance(Xh(this.zoomFrom,this.zoomTo,this.alpha))},e}($d),Kd=function(t){function e(){t.apply(this,arguments),this._currentRotation=new He}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype._init=function(t,e){this.rotateFrom=Nh(t),this.rotateTo=Nh(e),this._currentRotation=new He},e.prototype._tick=function(){this._currentRotation.copy(this.rotateFrom).slerp(this.rotateTo,this.alpha),this.controls.rotate(this._currentRotation)},e}($d),Jd=function(t){function e(){t.apply(this,arguments)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype._init=function(t,e,i){this.valueFrom=t,this.valueTo=e,this.callback=i},e.prototype._tick=function(){this.callback(Xh(this.valueFrom,this.valueTo,this.alpha))},e}($d),Qd=function(t){function e(){t.apply(this,arguments)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype._init=function(t){this.callback=t},e.prototype._tick=function(){1===this.alpha&&this.callback()},e}($d),tf=function(t){void 0===t&&(t=[]),this._resolveList=[],this._list=t},ef={done:{configurable:!0}};ef.done.get=function(){return this._list.every(function(t){return t.done})},tf.prototype.then=function(t){var e=this;return(this.done?Promise.resolve():new Promise(function(t){e._resolveList.push(t),e._list.forEach(function(t){t.then(function(){e._resolveList.forEach(function(t){t()}),e._resolveList.length=0})})})).then(t)},Object.defineProperties(tf.prototype,ef);var rf=function(t){this.stage=t,this.animationList=[],this.finishedList=[],this.viewer=t.viewer,this.controls=t.viewerControls},nf={paused:{configurable:!0}};nf.paused.get=function(){return this.animationList.every(function(t){return t.paused})},rf.prototype.add=function(t){return 0===t.duration?t.tick(this.viewer.stats):this.animationList.push(t),t},rf.prototype.remove=function(t){var e=this.animationList,i=e.indexOf(t);i>-1&&e.splice(i,1)},rf.prototype.run=function(t){for(var e=this.finishedList,i=this.animationList,r=i.length,n=0;n<r;++n){var o=i[n];o.tick(t)&&e.push(o)}var a=e.length;if(a){for(var s=0;s<a;++s)this.remove(e[s]);e.length=0}},rf.prototype.spin=function(t,e,i){return this.add(new Xd(i,this.controls,t,e))},rf.prototype.rock=function(t,e,i,r){return this.add(new qd(r,this.controls,t,e,i))},rf.prototype.rotate=function(t,e){var i=this.viewer.rotationGroup.quaternion.clone();return this.add(new Kd(e,this.controls,i,t))},rf.prototype.move=function(t,e){var i=this.controls.position.clone().negate();return this.add(new Yd(e,this.controls,i,t))},rf.prototype.zoom=function(t,e){var i=this.viewer.camera.position.z;return this.add(new Zd(e,this.controls,i,t))},rf.prototype.zoomMove=function(t,e,i){return new tf([this.move(t,i),this.zoom(e,i)])},rf.prototype.orient=function(t,e){var i=new $e,r=new He,n=new $e;return kh(t).decompose(i,r,n),new tf([this.move(i.negate(),e),this.rotate(r,e),this.zoom(-n.x,e)])},rf.prototype.value=function(t,e,i,r){return this.add(new Jd(r,this.controls,t,e,i))},rf.prototype.timeout=function(t,e){return this.add(new Qd(e,this.controls,t))},rf.prototype.spinComponent=function(t,e,i,r){return this.add(new Xd(r,t.controls,e,i))},rf.prototype.rockComponent=function(t,e,i,r,n){return this.add(new qd(n,t.controls,e,i,r))},rf.prototype.moveComponent=function(t,e,i){var r=t.controls.position.clone().negate();return this.add(new Yd(i,t.controls,r,e))},rf.prototype.pause=function(){this.animationList.forEach(function(t){return t.pause()})},rf.prototype.resume=function(){this.animationList.forEach(function(t){return t.resume()})},rf.prototype.toggle=function(){this.paused?this.resume():this.pause()},rf.prototype.clear=function(){this.animationList.length=0},rf.prototype.dispose=function(){this.clear()},Object.defineProperties(rf.prototype,nf);var of=function(t,e){if(this.fn=t,this.queue=[],this.pending=!1,this.next=this.next.bind(this),e){for(var i=0,r=e.length;i<r;++i)this.queue.push(e[i]);this.next()}};of.prototype.run=function(t){this.fn(t,this.next)},of.prototype.next=function(){var t=this,e=this.queue.shift();void 0!==e?(this.pending=!0,setTimeout(function(){return t.run(e)})):this.pending=!1},of.prototype.push=function(t){this.queue.push(t),this.pending||this.next()},of.prototype.kill=function(){this.queue.length=0},of.prototype.length=function(){return this.queue.length};var af=function(t,e,i){this.type="",this.parameters={lazy:{type:"boolean"},clipNear:{type:"range",step:1,max:100,min:0,buffer:!0},clipRadius:{type:"number",precision:1,max:1e3,min:0,buffer:!0},clipCenter:{type:"vector3",precision:1,buffer:!0},flatShaded:{type:"boolean",buffer:!0},opacity:{type:"range",step:.01,max:1,min:0,buffer:!0},depthWrite:{type:"boolean",buffer:!0},side:{type:"select",buffer:!0,options:{front:"front",back:"back",double:"double"}},wireframe:{type:"boolean",buffer:!0},colorScheme:{type:"select",update:"color",options:{}},colorScale:{type:"select",update:"color",options:Jl.getScales()},colorReverse:{type:"boolean",update:"color"},colorValue:{type:"color",update:"color"},colorDomain:{type:"hidden",update:"color"},colorMode:{type:"select",update:"color",options:Jl.getModes()},roughness:{type:"range",step:.01,max:1,min:0,buffer:!0},metalness:{type:"range",step:.01,max:1,min:0,buffer:!0},diffuse:{type:"color",buffer:!0},diffuseInterior:{type:"boolean",buffer:!0},useInteriorColor:{type:"boolean",buffer:!0},interiorColor:{type:"color",buffer:!0},interiorDarkening:{type:"range",step:.01,max:1,min:0,buffer:!0},matrix:{type:"hidden",buffer:!0},disablePicking:{type:"boolean",rebuild:!0}},this.viewer=e,this.tasks=new Ap,this.queue=new of(this.make.bind(this)),this.bufferList=[],this.parameters.colorScheme&&(this.parameters.colorScheme.options=Jl.getSchemes())};af.prototype.init=function(t){var e=t||{};this.clipNear=yh(e.clipNear,0),this.clipRadius=yh(e.clipRadius,0),this.clipCenter=yh(e.clipCenter,new $e),this.flatShaded=yh(e.flatShaded,!1),this.side=yh(e.side,"double"),this.opacity=yh(e.opacity,1),this.depthWrite=yh(e.depthWrite,!0),this.wireframe=yh(e.wireframe,!1),this.setColor(e.color,e),this.colorScheme=yh(e.colorScheme,"uniform"),this.colorScale=yh(e.colorScale,""),this.colorReverse=yh(e.colorReverse,!1),this.colorValue=yh(e.colorValue,9474192),this.colorDomain=yh(e.colorDomain,void 0),this.colorMode=yh(e.colorMode,"hcl"),this.visible=yh(e.visible,!0),this.quality=yh(e.quality,void 0),this.roughness=yh(e.roughness,.4),this.metalness=yh(e.metalness,0),this.diffuse=yh(e.diffuse,16777215),this.diffuseInterior=yh(e.diffuseInterior,!1),this.useInteriorColor=yh(e.useInteriorColor,!1),this.interiorColor=yh(e.interiorColor,2236962),this.interiorDarkening=yh(e.interiorDarkening,0),this.lazy=yh(e.lazy,!1),this.lazyProps={build:!1,bufferParams:{},what:{}},this.matrix=yh(e.matrix,new Ve),this.disablePicking=yh(e.disablePicking,!1);var i=this.parameters;!0===i.sphereDetail&&(i.sphereDetail={type:"integer",max:3,min:0,rebuild:"impostor"}),!0===i.radialSegments&&(i.radialSegments={type:"integer",max:25,min:5,rebuild:"impostor"}),!0===i.openEnded&&(i.openEnded={type:"boolean",rebuild:"impostor",buffer:!0}),!0===i.disableImpostor&&(i.disableImpostor={type:"boolean",rebuild:!0}),"low"===e.quality?(i.sphereDetail&&(this.sphereDetail=0),i.radialSegments&&(this.radialSegments=5)):"medium"===e.quality?(i.sphereDetail&&(this.sphereDetail=1),i.radialSegments&&(this.radialSegments=10)):"high"===e.quality?(i.sphereDetail&&(this.sphereDetail=2),i.radialSegments&&(this.radialSegments=20)):(i.sphereDetail&&(this.sphereDetail=yh(e.sphereDetail,1)),i.radialSegments&&(this.radialSegments=yh(e.radialSegments,10))),i.openEnded&&(this.openEnded=yh(e.openEnded,!0)),i.disableImpostor&&(this.disableImpostor=yh(e.disableImpostor,!1))},af.prototype.getColorParams=function(t){return Object.assign({scheme:this.colorScheme,scale:this.colorScale,reverse:this.colorReverse,value:this.colorValue,domain:this.colorDomain,mode:this.colorMode},t)},af.prototype.getBufferParams=function(t){return Object.assign({clipNear:this.clipNear,clipRadius:this.clipRadius,clipCenter:this.clipCenter,flatShaded:this.flatShaded,opacity:this.opacity,depthWrite:this.depthWrite,side:this.side,wireframe:this.wireframe,roughness:this.roughness,metalness:this.metalness,diffuse:this.diffuse,diffuseInterior:this.diffuseInterior,useInteriorColor:this.useInteriorColor,interiorColor:this.interiorColor,interiorDarkening:this.interiorDarkening,matrix:this.matrix,disablePicking:this.disablePicking},t)},af.prototype.setColor=function(t,e){var i=Object.keys(Jl.getSchemes());return"string"==typeof t&&i.includes(t.toLowerCase())?e?e.colorScheme=t:this.setParameters({colorScheme:t}):void 0!==t&&(t=new Gi(t).getHex(),e?(e.colorScheme="uniform",e.colorValue=t):this.setParameters({colorScheme:"uniform",colorValue:t})),this},af.prototype.create=function(){},af.prototype.update=function(){this.build()},af.prototype.build=function(t){if(!this.lazy||this.visible&&this.opacity){if(!this.prepare)return this.tasks.increment(),void this.make();this.queue.length()>0?(this.tasks.change(1-this.queue.length()),this.queue.kill()):this.tasks.increment(),this.queue.push(t||!1)}else this.lazyProps.build=!0},af.prototype.make=function(e,i){var r=this;t.Debug&&ql.time("Representation.make "+this.type);var n=function(){e?(r.update(e),r.viewer.requestRender(),r.tasks.decrement(),i&&i()):(r.clear(),r.create(),r.manualAttach||r.disposed||(t.Debug&&ql.time("Representation.attach "+r.type),r.attach(function(){t.Debug&&ql.timeEnd("Representation.attach "+r.type),r.tasks.decrement(),i&&i()}))),t.Debug&&ql.timeEnd("Representation.make "+r.type)};this.prepare?this.prepare(n):n()},af.prototype.attach=function(t){this.setVisibility(this.visible),t()},af.prototype.setVisibility=function(t,e){if(this.visible=t,this.visible&&this.opacity){var i=this.lazyProps,r=i.bufferParams,n=i.what;if(i.build)return i.build=!1,void this.build();(Object.keys(r).length||Object.keys(n).length)&&(i.bufferParams={},i.what={},this.updateParameters(r,n))}return this.bufferList.forEach(function(e){e.setVisibility(t)}),e||this.viewer.requestRender(),this},af.prototype.setParameters=function(t,e,i){var r=this;void 0===e&&(e={}),void 0===i&&(i=!1);var n=t||{},o=this.parameters,a={};for(var s in this.opacity||void 0===n.opacity||(this.lazyProps.build?(this.lazyProps.build=!1,i=!0):(Object.assign(a,this.lazyProps.bufferParams),Object.assign(e,this.lazyProps.what),this.lazyProps.bufferParams={},this.lazyProps.what={})),this.setColor(n.color,n),n)void 0!==n[s]&&void 0!==o[s]&&(o[s].int&&(n[s]=parseInt(n[s])),o[s].float&&(n[s]=parseFloat(n[s])),(n[s]!==r[s]||n[s].equals&&!n[s].equals(r[s]))&&(r[s]&&r[s].copy&&n[s].copy?r[s].copy(n[s]):r[s]&&r[s].set?r[s].set(n[s]):r[s]=n[s],o[s].buffer&&(!0===o[s].buffer?a[s]=n[s]:a[o[s].buffer]=n[s]),o[s].update&&(e[o[s].update]=!0),!o[s].rebuild||"impostor"===o[s].rebuild&&Wl&&!r.disableImpostor||(i=!0)));return i?this.build():this.updateParameters(a,e),this},af.prototype.updateParameters=function(t,e){if(void 0===t&&(t={}),this.lazy&&(!this.visible||!this.opacity)&&void 0===t.opacity)return Object.assign(this.lazyProps.bufferParams,t),void Object.assign(this.lazyProps.what,e);this.bufferList.forEach(function(e){e.setParameters(t)}),Object.keys(e).length&&this.update(e),this.viewer.requestRender()},af.prototype.getParameters=function(){var t=this,e={lazy:this.lazy,visible:this.visible,quality:this.quality};return Object.keys(this.parameters).forEach(function(i){null!==t.parameters[i]&&(e[i]=t[i])}),e},af.prototype.clear=function(){var t=this;this.bufferList.forEach(function(e){t.viewer.remove(e),e.dispose()}),this.bufferList.length=0,this.viewer.requestRender()},af.prototype.dispose=function(){this.disposed=!0,this.queue.kill(),this.tasks.dispose(),this.clear()};var sf=function(e){var i=this;this.pending=0,this.postCount=0,this.onmessageDict={},this.onerrorDict={},this.name=e,this.blobUrl=window.URL.createObjectURL(Kl.get(e)),this.worker=new Worker(this.blobUrl),Kl.activeWorkerCount+=1,this.worker.onmessage=function(r){i.pending-=1;var n=r.data.__postId;t.Debug&&ql.timeEnd("Worker.postMessage "+e+" #"+n);var o=i.onmessageDict[n];o&&o.call(i.worker,r),delete i.onmessageDict[n],delete i.onerrorDict[n]},this.worker.onerror=function(t){if(i.pending-=1,t.data){var r=t.data.__postId,n=i.onerrorDict[r];n?n.call(i.worker,t):ql.error("Worker.onerror",r,e,t),delete i.onmessageDict[r],delete i.onerrorDict[r]}else ql.error("Worker.onerror",e,t)}};sf.prototype.post=function(e,i,r,n){void 0===e&&(e={}),this.onmessageDict[this.postCount]=r,this.onerrorDict[this.postCount]=n,e.__name=this.name,e.__postId=this.postCount,e.__debug=t.Debug,t.Debug&&ql.time("Worker.postMessage "+this.name+" #"+this.postCount);try{this.worker.postMessage(e,i)}catch(t){ql.error("worker.post:",t),this.worker.postMessage(e)}return this.pending+=1,this.postCount+=1,this},sf.prototype.terminate=function(){this.worker?(this.worker.terminate(),window.URL.revokeObjectURL(this.blobUrl),Kl.activeWorkerCount-=1):ql.log("no worker to terminate")};var cf=function(t,e){void 0===e&&(e=2),this.pool=[],this.count=0,this.maxCount=Math.min(8,e),this.name=t};function uf(t){for(var e=t.length,i=e/3,r=0,n=0,o=0,a=0;a<e;a+=3)r+=t[a+0],n+=t[a+1],o+=t[a+2];return new $e(r/i,n/i,o/i)}function hf(t,e,i){return i?t.sub(i).projectOnVector(e).add(i):t.projectOnVector(e),t}function lf(t){for(var e=1/0,i=1/0,r=1/0,n=-1/0,o=-1/0,a=-1/0,s=0,c=t.length;s<c;s+=3){var u=t[s],h=t[s+1],l=t[s+2];u<e&&(e=u),h<i&&(i=h),l<r&&(r=l),u>n&&(n=u),h>o&&(o=h),l>a&&(a=l)}return[mf([e,i,r]),mf([n,o,a])]}function pf(t,e){for(var i=0,r=e.length;i<r;i+=3){var n=e[i],o=e[i+1],a=e[i+2];e[i]=t[0]*n+t[4]*o+t[8]*a+t[12],e[i+1]=t[1]*n+t[5]*o+t[9]*a+t[13],e[i+2]=t[2]*n+t[6]*o+t[10]*a+t[14]}}function df(t,e){for(var i=0,r=e.length;i<r;i+=3){var n=e[i],o=e[i+1],a=e[i+2];e[i]=t[0]*n+t[3]*o+t[6]*a,e[i+1]=t[1]*n+t[4]*o+t[7]*a,e[i+2]=t[2]*n+t[5]*o+t[8]*a}}function ff(t){for(var e=0,i=t.length;e<i;e+=3){var r=t[e],n=t[e+1],o=t[e+2],a=1/Math.sqrt(r*r+n*n+o*o);t[e]=r*a,t[e+1]=n*a,t[e+2]=o*a}}function mf(t){return new Float32Array(t||3)}function gf(t,e,i){var r=e[0],n=e[1],o=e[2],a=i[0],s=i[1],c=i[2];t[0]=n*c-o*s,t[1]=o*a-r*c,t[2]=r*s-n*a}function vf(t,e){return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]}function yf(t,e,i){t[0]=e[0]-i[0],t[1]=e[1]-i[1],t[2]=e[2]-i[2]}function bf(t,e,i){t[0]=e[0]+i[0],t[1]=e[1]+i[1],t[2]=e[2]+i[2]}function xf(t,e,i){void 0===i&&(i=0),t[0]=e[i],t[1]=e[i+1],t[2]=e[i+2]}function _f(t,e,i){void 0===i&&(i=0),e[i]=t[0],e[i+1]=t[1],e[i+2]=t[2]}function wf(t){return Math.sqrt(t[0]*t[0]+t[1]*t[1]+t[2]*t[2])}function Sf(t,e,i){Af(t,e,1/i)}function Af(t,e,i){t[0]=e[0]*i,t[1]=e[1]*i,t[2]=e[2]*i}function Mf(t,e){Af(t,e,1/wf(e))}function Pf(t,e,i){t[0]=e[0]-i,t[1]=e[1]-i,t[2]=e[2]-i}function Tf(t,e,i){t[0]=e[0]+i,t[1]=e[1]+i,t[2]=e[2]+i}function Ef(t,e){t[0]=Math.floor(e[0]),t[1]=Math.floor(e[1]),t[2]=Math.floor(e[2])}function Cf(t,e){t[0]=Math.ceil(e[0]),t[1]=Math.ceil(e[1]),t[2]=Math.ceil(e[2])}function If(t,e){t[0]=-e[0],t[1]=-e[1],t[2]=-e[2]}function Rf(t,e){void 0===e&&(e=9);for(var i=Math.floor(e/2),r=t.position1.length/3,n=3*(i*r),o=1/e,a=Up(t.position1,t.position2),s=new Float32Array(n),c=new Float32Array(n),u=new $e,h=0;h<r;++h){var l=3*h;u.set(a[l],a[l+1],a[l+2]);for(var p=t.position1[l],d=t.position1[l+1],f=t.position1[l+2],m=0;m<i;++m){var g=i*l+3*m,v=o*(2*m+1),y=o*(2*m+2);s[g]=p+u.x*v,s[g+1]=d+u.y*v,s[g+2]=f+u.z*v,c[g]=p+u.x*y,c[g+1]=d+u.y*y,c[g+2]=f+u.z*y}}var b=zp(s,c),x=function(t,e){for(var i=t.length/3,r=new Float32Array(i*e*3),n=0;n<i;++n)for(var o=3*n,a=n*e*3,s=t[o+0],c=t[o+1],u=t[o+2],h=0;h<e;++h){var l=a+3*h;r[l+0]=s,r[l+1]=c,r[l+2]=u}return r}(t.color,i),_={position:b,position1:s,position2:c,color:x,color2:x};return t.radius&&(_.radius=$p(t.radius,i)),t.picking&&t.picking.array&&(t.picking.array=$p(t.picking.array,i),_.picking=t.picking),t.primitiveId&&(_.primitiveId=$p(t.primitiveId,i)),_}function Lf(t,e){void 0===e&&(e=.1);for(var i=Up(t.position1,t.position2),r=[],n=[],o=[],a=t.radius?[]:void 0,s=t.picking?[]:void 0,c=t.primitiveId?[]:void 0,u=new $e,h=t.position1.length/3,l=0,p=0;p<h;++p){var d=3*p;u.set(i[d],i[d+1],i[d+2]);for(var f=u.length()/e,m=Math.floor(f/2),g=1/f,v=t.position1[d],y=t.position1[d+1],b=t.position1[d+2],x=0;x<m;++x){var _=3*l+3*x,w=g*(2*x+1),S=g*(2*x+2);r[_]=v+u.x*w,r[_+1]=y+u.y*w,r[_+2]=b+u.z*w,n[_]=v+u.x*S,n[_+1]=y+u.y*S,n[_+2]=b+u.z*S,t.color&&(o[_]=t.color[d],o[_+1]=t.color[d+1],o[_+2]=t.color[d+2]),a&&(a[l+x]=t.radius[p]),s&&(t.picking.array?s[l+x]=t.picking.array[p]:s[l+x]=p),c&&(c[l+x]=t.primitiveId[p])}l+=m}var A=new Float32Array(r),M=new Float32Array(n),P=zp(A,M),T=new Float32Array(o),E={position:P,position1:A,position2:M,color:T,color2:T};return a&&(E.radius=new Float32Array(a)),s&&t.picking&&(t.picking.array=new Float32Array(s),E.picking=t.picking),c&&(E.primitiveId=new Float32Array(c)),E}function Of(t,e){void 0===e&&(e=.1);for(var i=Up(t.position1,t.position2),r=[],n=[],o=[],a=t.radius?[]:void 0,s=t.picking?[]:void 0,c=t.primitiveId?[]:void 0,u=new $e,h=t.position1.length/3,l=e,p=!0,d=0,f=0,m=0,g=0;g<h;++g){var v=3*g,y=t.position1[v],b=t.position1[v+1],x=t.position1[v+2];u.set(i[v],i[v+1],i[v+2]);var _=u.length();p&&(r[f]=y,r[f+1]=b,r[f+2]=x);for(var w=l,S=1/_;w<_;){var A=p?n:r;A[f]=y+u.x*w*S,A[f+1]=b+u.y*w*S,A[f+2]=x+u.z*w*S,p&&(f=3*++d),p=!p,l=e,w+=e}p&&(n[f]=t.position2[v],n[f+1]=t.position2[v+1],n[f+2]=t.position2[v+2],f=3*++d),l=w-_;for(var M=m;M<d;M++){if(t.color){var P=3*M;o[P]=t.color[v],o[P+1]=t.color[v+1],o[P+2]=t.color[v+2]}a&&(a[M]=t.radius[g]),s&&(t.picking.array?s[M]=t.picking.array[g]:s[M]=g),c&&(c[M]=t.primitiveId[g])}m=d}if(!p&&h>0){var T=3*d;n[T]=t.position2[3*h-3],n[T+1]=t.position2[3*h-2],n[T+1]=t.position2[3*h-1]}var E=new Float32Array(r),C=new Float32Array(n),I=zp(E,C),R=new Float32Array(o),L={position:I,position1:E,position2:C,color:R,color2:R};return a&&(L.radius=new Float32Array(a)),s&&t.picking&&(t.picking.array=new Float32Array(s),L.picking=t.picking),c&&(L.primitiveId=new Float32Array(c)),L}cf.prototype.post=function(t,e,i,r){void 0===t&&(t={});var n=this.getNextWorker();return n?n.post(t,e,i,r):console.error("unable to get worker from pool"),this},cf.prototype.terminate=function(){this.pool.forEach(function(t){t.terminate()})},cf.prototype.getNextWorker=function(){for(var t,e=1/0,i=0;i<this.maxCount;++i){if(i>=this.count){t=new sf(this.name),this.pool.push(t),this.count+=1;break}var r=this.pool[i];if(0===r.pending){t=r;break}r.pending<e&&(e=r.pending,t=r)}return t},cf.prototype.constructor=cf,lf.__deps=[mf],Sf.__deps=[Af],Mf.__deps=[Af,wf];var Df=new $e,kf=function(){},Nf={Picker:{configurable:!0},Buffer:{configurable:!0}};Nf.Picker.get=function(){return ap.get(this.type)},Nf.Buffer.get=function(){return op.get(this.type)},kf.getShapeKey=function(t){return this.type+t[0].toUpperCase()+t.substr(1)},kf.expandBoundingBox=function(t,e){},kf.valueToShape=function(t,e,i){var r,n,o=t._primitiveData[this.getShapeKey(e)];switch(this.fields[e]){case"v3":case"c":n=o,void 0!==(r=i).toArray?r=r.toArray():void 0!==r.x?r=[r.x,r.y,r.z]:void 0!==r.r&&(r=[r.r,r.g,r.b]),n.push.apply(n,r);break;default:o.push(i)}},kf.objectToShape=function(t,e){var i=this;Object.keys(this.fields).forEach(function(r){i.valueToShape(t,r,e[r])}),this.valueToShape(t,"name",e.name),this.expandBoundingBox(t.boundingBox,e)},kf.valueFromShape=function(t,e,i){var r=t._primitiveData[this.getShapeKey(i)];switch(this.fields[i]){case"v3":return(new $e).fromArray(r,3*e);case"c":return(new Gi).fromArray(r,3*e);default:return r[e]}},kf.objectFromShape=function(t,e){var i=this,r=this.valueFromShape(t,e,"name");void 0===r&&(r=this.type+": "+e+" ("+t.name+")");var n={shape:t,name:r};return Object.keys(this.fields).forEach(function(r){n[r]=i.valueFromShape(t,e,r)}),n},kf.arrayFromShape=function(t,e){var i=t._primitiveData[this.getShapeKey(e)];switch(this.fields[e]){case"s":return i;default:return new Float32Array(i)}},kf.dataFromShape=function(t){var e=this,i={};return this.Picker&&(i.picking=new this.Picker(t)),Object.keys(this.fields).forEach(function(r){i[r]=e.arrayFromShape(t,r)}),i},kf.bufferFromShape=function(t,e){return new this.Buffer(this.dataFromShape(t),e)},Object.defineProperties(kf,Nf),kf.type="",kf.fields={};var Bf=function(t){function e(){t.apply(this,arguments)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.positionFromShape=function(t,e){return this.valueFromShape(t,e,"position")},e.expandBoundingBox=function(t,e){t.expandByPoint(Df.fromArray(e.position))},e}(kf);Bf.type="sphere",Bf.fields={position:"v3",color:"c",radius:"f"};var Ff=function(t){function e(){t.apply(this,arguments)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.positionFromShape=function(t,e){return this.valueFromShape(t,e,"position")},e.expandBoundingBox=function(t,e){t.expandByPoint(Df.fromArray(e.position))},e}(kf);Ff.type="box",Ff.fields={position:"v3",color:"c",size:"f",heightAxis:"v3",depthAxis:"v3"};var zf=function(t){function e(){t.apply(this,arguments)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e}(Ff);zf.type="octahedron";var Uf=function(t){function e(){t.apply(this,arguments)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e}(Ff);Uf.type="tetrahedron";var jf=function(t){function e(){t.apply(this,arguments)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.positionFromShape=function(t,e){var i=this.valueFromShape(t,e,"position1"),r=this.valueFromShape(t,e,"position2");return i.add(r).multiplyScalar(.5)},e.expandBoundingBox=function(t,e){t.expandByPoint(Df.fromArray(e.position1)),t.expandByPoint(Df.fromArray(e.position2))},e.bufferFromShape=function(t,e){void 0===e&&(e={});var i=this.dataFromShape(t);return"cylinder"===this.type&&e.dashedCylinder&&(i=Lf(i)),new this.Buffer(i,e)},e}(kf);jf.type="cylinder",jf.fields={position1:"v3",position2:"v3",color:"c",radius:"f"};var Gf=function(t){function e(){t.apply(this,arguments)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e}(jf);Gf.type="arrow";var Vf=function(t){function e(){t.apply(this,arguments)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e}(jf);Vf.type="cone";var Hf=function(t){function e(){t.apply(this,arguments)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e}(Bf);Hf.type="ellipsoid",Hf.fields={position:"v3",color:"c",radius:"f",majorAxis:"v3",minorAxis:"v3"};var $f=function(t){function e(){t.apply(this,arguments)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e}(Hf);$f.type="torus";var Wf=function(t){function e(){t.apply(this,arguments)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.positionFromShape=function(t,e){return this.valueFromShape(t,e,"position")},e.expandBoundingBox=function(t,e){t.expandByPoint(Df.fromArray(e.position))},e}(kf);Wf.type="text",Wf.fields={position:"v3",color:"c",size:"f",text:"s"};var Xf=function(t){function e(){t.apply(this,arguments)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.positionFromShape=function(t,e){return this.valueFromShape(t,e,"position")},e.expandBoundingBox=function(t,e){t.expandByPoint(Df.fromArray(e.position))},e}(kf);Xf.type="point",Xf.fields={position:"v3",color:"c"};var qf=function(t){function e(){t.apply(this,arguments)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.positionFromShape=function(t,e){var i=this.valueFromShape(t,e,"position1"),r=this.valueFromShape(t,e,"position2");return i.add(r).multiplyScalar(.5)},e.expandBoundingBox=function(t,e){t.expandByPoint(Df.fromArray(e.position1)),t.expandByPoint(Df.fromArray(e.position2))},e}(kf);qf.type="wideline",qf.fields={position1:"v3",position2:"v3",color:"c"};var Yf=function(t,e){this.exp=3;var i=e||function(t){for(var e=t.x,i=t.y,r=t.z,n=new xr,o=e.length,a=n.min,s=n.max,c=0;c<o;c++)a.x=Math.min(e[c],a.x),a.y=Math.min(i[c],a.y),a.z=Math.min(r[c],a.z),s.x=Math.max(e[c],s.x),s.y=Math.max(i[c],s.y),s.z=Math.max(r[c],s.z);return n}(t);this.minX=i.min.x,this.minY=i.min.y,this.minZ=i.min.z,this.boundX=1+(i.max.x-this.minX>>this.exp),this.boundY=1+(i.max.y-this.minY>>this.exp),this.boundZ=1+(i.max.z-this.minZ>>this.exp);for(var r=this.boundX*this.boundY*this.boundZ,n=t.x.length,o=t.x,a=t.y,s=t.z,c=0,u=new Uint32Array(r),h=new Int32Array(n),l=0;l<n;++l){var p=o[l]-this.minX>>this.exp,d=a[l]-this.minY>>this.exp,f=s[l]-this.minZ>>this.exp,m=(p*this.boundY+d)*this.boundZ+f;1===(u[m]+=1)&&(c+=1),h[l]=m}for(var g=new Uint16Array(c),v=0,y=0;v<r;++v){var b=u[v];b>0&&(u[v]=y+1,g[y]=b,y+=1)}for(var x=new Uint32Array(c),_=1;_<c;++_)x[_]+=x[_-1]+g[_-1];for(var w=new Uint16Array(c),S=new Int32Array(n),A=0;A<n;++A){var M=u[h[A]];if(M>0){var P=M-1;S[x[P]+w[P]]=A,w[P]+=1}}this.grid=u,this.bucketCount=g,this.bucketOffset=x,this.bucketArray=S,this.xArray=o,this.yArray=a,this.zArray=s};Yf.prototype.within=function(t,e,i,r){var n=[];return this.eachWithin(t,e,i,r,function(t){return n.push(t)}),n},Yf.prototype.eachWithin=function(t,e,i,r,n){for(var o=r*r,a=Math.max(0,t-r-this.minX>>this.exp),s=Math.max(0,e-r-this.minY>>this.exp),c=Math.max(0,i-r-this.minZ>>this.exp),u=Math.min(this.boundX,t+r-this.minX>>this.exp),h=Math.min(this.boundY,e+r-this.minY>>this.exp),l=Math.min(this.boundZ,i+r-this.minZ>>this.exp),p=a;p<=u;++p)for(var d=s;d<=h;++d)for(var f=c;f<=l;++f){var m=(p*this.boundY+d)*this.boundZ+f,g=this.grid[m];if(g>0)for(var v=g-1,y=this.bucketOffset[v],b=y+this.bucketCount[v],x=y;x<b;++x){var _=this.bucketArray[x],w=this.xArray[_]-t,S=this.yArray[_]-e,A=this.zArray[_]-i,M=w*w+S*S+A*A;M<=o&&n(_,M)}}};var Zf=function(t){void 0===t&&(t=0),this._fields=this._defaultFields,this._init(0)};Zf.prototype._init=function(t){this.length=t,this.count=0;for(var e=0,i=this._fields.length;e<i;++e){var r=this._fields[e],n=r[0],o=r[1],a=r[2];this._initField(n,o,a)}},Zf.prototype._initField=function(t,e,i){this[t]=Ih(i,this.length*e)},Zf.prototype.addField=function(t,e,i){this._fields.push([t,e,i]),this._initField(t,e,i)},Zf.prototype.resize=function(t){this.length=Math.round(t||0),this.count=Math.min(this.count,this.length);for(var e=0,i=this._fields.length;e<i;++e){var r=this._fields[e][0],n=this._fields[e][1],o=this.length*n,a=new this[r].constructor(o);this[r].length>o?a.set(this[r].subarray(0,o)):a.set(this[r]),this[r]=a}},Zf.prototype.growIfFull=function(){if(this.count>=this.length){var t=Math.round(1.5*this.length);this.resize(Math.max(256,t))}},Zf.prototype.copyFrom=function(t,e,i,r){for(var n=0,o=this._fields.length;n<o;++n)for(var a=this._fields[n][0],s=this._fields[n][1],c=this[a],u=t[a],h=0;h<r;++h)for(var l=s*(e+h),p=s*(i+h),d=0;d<s;++d)c[l+d]=u[p+d]},Zf.prototype.copyWithin=function(t,e,i){for(var r=0,n=this._fields.length;r<n;++r)for(var o=this._fields[r][0],a=this._fields[r][1],s=this[o],c=0;c<i;++c)for(var u=a*(t+c),h=a*(e+c),l=0;l<a;++l)s[u+l]=s[h+l]},Zf.prototype.sort=function(t){ql.time("Store.sort");var e=this,i=new this.constructor(1);!function r(n,o){if(n<o){var a=Math.floor((n+o)/2),s=n,c=o;do{for(;t(s,a)<0;)s+=1;for(;t(c,a)>0;)c-=1;s<=c&&(s===a?a=c:c===a&&(a=s),(u=s)!==(h=c)&&(i.copyFrom(e,0,u,1),e.copyWithin(u,h,1),e.copyFrom(i,h,0,1)),s+=1,c-=1)}while(s<=c);r(n,c),r(s,o)}var u,h}(0,this.count-1),ql.timeEnd("Store.sort")},Zf.prototype.clear=function(){this.count=0},Zf.prototype.dispose=function(){delete this.length,delete this.count;for(var t=0,e=this._fields.length;t<e;++t){delete this[this._fields[t][0]]}};var Kf=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e;var i={_defaultFields:{configurable:!0}};return i._defaultFields.get=function(){return[["index1",1,"int32"],["index2",1,"int32"],["type",1,"int8"]]},e.prototype.addContact=function(t,e,i){this.growIfFull();var r=this.count;t<e?(this.index1[r]=t,this.index2[r]=e):(this.index2[r]=t,this.index1[r]=e),i&&(this.type[r]=i),this.count+=1},Object.defineProperties(e.prototype,i),e}(Zf);function Jf(t){return 16843009*((t=(858993459&(t-=t>>>1&1431655765))+(t>>>2&858993459))+(t>>>4)&252645135)>>>24}var Qf=function(t,e){this.length=t,this._words=new Uint32Array(t+32>>>5),!0===e&&this.setAll()};function tm(t){for(var e=t.edgeCount,i=t.nodeCount,r=t.nodeArray1,n=t.nodeArray2,o=new Uint8Array(i),a=new Int32Array(i),s=0;s<e;++s)o[r[s]]+=1,o[n[s]]+=1;for(var c=1;c<i;++c)a[c]+=a[c-1]+o[c-1];for(var u=2*e,h=new Int32Array(u),l=0;l<u;++l)h[l]=-1;for(var p=0;p<e;++p){for(var d=r[p],f=n[p],m=a[d];-1!==h[m]&&m<u;)m+=1;h[m]=p;for(var g=a[f];-1!==h[g]&&g<u;)g+=1;h[g]=p}return{countArray:o,offsetArray:a,indexArray:h}}function em(t,e){return void 0===t&&(t=0),void 0===e&&(e=0),{type:t,group:e,x:0,y:0,z:0,atomSet:[]}}function im(t,e){t.x+=e.x,t.y+=e.y,t.z+=e.z,t.atomSet.push(e.index)}function rm(t,e){var i=e.atomSet.length;if(i>0){var r=t.types,n=t.groups,o=t.centers,a=t.atomSets;r.push(e.type),n.push(e.group),o.x.push(e.x/i),o.y.push(e.y/i),o.z.push(e.z/i),a.push(e.atomSet)}}Qf.prototype.get=function(t){return 0!=(this._words[t>>>5]&1<<t)},Qf.prototype.set=function(t){this._words[t>>>5]|=1<<t},Qf.prototype.clear=function(t){this._words[t>>>5]&=~(1<<t)},Qf.prototype.flip=function(t){this._words[t>>>5]^=1<<t},Qf.prototype._assignRange=function(t,e,i){if(!(e<t)){for(var r=this._words,n=!0===i?4294967295:0,o=t>>>5,a=e>>>5,s=o;s<a;++s)r[s]=n;var c=o<<5,u=a<<5;if(!0===i)if(e-t<32)for(var h=t,l=e+1;h<l;++h)r[h>>>5]|=1<<h;else{for(var p=t,d=c;p<d;++p)r[p>>>5]|=1<<p;for(var f=u,m=e+1;f<m;++f)r[f>>>5]|=1<<f}else if(e-t<32)for(var g=t,v=e+1;g<v;++g)r[g>>>5]&=~(1<<g);else{for(var y=t,b=c;y<b;++y)r[y>>>5]&=~(1<<y);for(var x=u,_=e+1;x<_;++x)r[x>>>5]&=~(1<<x)}return this}},Qf.prototype.setRange=function(t,e){return this._assignRange(t,e,!0)},Qf.prototype.clearRange=function(t,e){return this._assignRange(t,e,!1)},Qf.prototype.setBits=function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];for(var i=this._words,r=t.length,n=0;n<r;++n){var o=t[n];i[o>>>5]|=1<<o}return this},Qf.prototype.clearBits=function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];for(var i=this._words,r=t.length,n=0;n<r;++n){var o=t[n];i[o>>>5]&=~(1<<o)}return this},Qf.prototype.setAll=function(){return this._assignRange(0,this.length-1,!0)},Qf.prototype.clearAll=function(){return this._assignRange(0,this.length-1,!1)},Qf.prototype.flipAll=function(){for(var t=this._words.length,e=this._words,i=32-this.length%32,r=0;r<t-1;++r)e[r]=~e[r];return e[t-1]=~(e[t-1]<<i)>>>i,this},Qf.prototype._isRangeValue=function(t,e,i){if(!(e<t)){for(var r=this._words,n=!0===i?4294967295:0,o=t>>>5,a=e>>>5,s=o;s<a;++s)if(r[s]!==n)return!1;if(e-t<32){for(var c=t,u=e+1;c<u;++c)if(!!(r[c>>>5]&1<<c)!==i)return!1}else{for(var h=a<<5,l=t,p=o<<5<<5;l<p;++l)if(!!(r[l>>>5]&1<<l)!==i)return!1;for(var d=h,f=e+1;d<f;++d)if(!!(r[d>>>5]&1<<d)!==i)return!1}return!0}},Qf.prototype.isRangeSet=function(t,e){return this._isRangeValue(t,e,!0)},Qf.prototype.isRangeClear=function(t,e){return this._isRangeValue(t,e,!1)},Qf.prototype.isAllSet=function(){return this._isRangeValue(0,this.length-1,!0)},Qf.prototype.isAllClear=function(){return this._isRangeValue(0,this.length-1,!1)},Qf.prototype.isSet=function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];for(var i=this._words,r=t.length,n=0;n<r;++n){var o=t[n];if(0==(i[o>>>5]&1<<o))return!1}return!0},Qf.prototype.isClear=function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];for(var i=this._words,r=t.length,n=0;n<r;++n){var o=t[n];if(0!=(i[o>>>5]&1<<o))return!1}return!0},Qf.prototype.isEqualTo=function(t){for(var e=this._words,i=t._words,r=Math.min(e.length,i.length),n=0;n<r;++n)if(e[n]!==i[n])return!1;return!0},Qf.prototype.getSize=function(){for(var t=this._words.length,e=this._words,i=0,r=0;r<t;++r)i+=Jf(e[r]);return i},Qf.prototype.difference=function(t){for(var e=this._words,i=t._words,r=Math.min(e.length,i.length),n=0;n<r;++n)e[n]=e[n]&~i[n];for(var o=e.length;o<r;++o)e[o]=0;return this},Qf.prototype.union=function(t){for(var e=this._words,i=t._words,r=Math.min(e.length,i.length),n=0;n<r;++n)e[n]|=i[n];for(var o=e.length;o<r;++o)e[o]=0;return this},Qf.prototype.intersection=function(t){for(var e=this._words,i=t._words,r=Math.min(e.length,i.length),n=0;n<r;++n)e[n]&=i[n];for(var o=e.length;o<r;++o)e[o]=0;return this},Qf.prototype.intersects=function(t){for(var e=this._words,i=t._words,r=Math.min(e.length,i.length),n=0;n<r;++n)if(0!=(e[n]&i[n]))return!0;return!1},Qf.prototype.getIntersectionSize=function(t){for(var e=this._words,i=t._words,r=Math.min(e.length,i.length),n=0,o=0;o<r;++o)n+=Jf(e[o]&i[o]);return n},Qf.prototype.makeIntersection=function(t){var e=this._words,i=t._words,r=Math.min(e.length,i.length),n=new Uint32Array(r),o=Object.create(Qf.prototype);o._words=n,o.length=Math.min(this.length,t.length);for(var a=0;a<r;++a)n[a]=e[a]&i[a];return o},Qf.prototype.forEach=function(t){for(var e=this._words.length,i=this._words,r=0,n=0;n<e;++n)for(var o=i[n];0!==o;){var a=o&-o;t((n<<5)+Jf(a-1),r),o^=a,++r}},Qf.prototype.toArray=function(){for(var t=this._words,e=new Array(this.getSize()),i=this._words.length,r=0,n=0;n<i;++n)for(var o=t[n];0!==o;){var a=o&-o;e[r++]=(n<<5)+Jf(a-1),o^=a}return e},Qf.prototype.toString=function(){return"{"+this.toArray().join(",")+"}"},Qf.prototype.toSeleString=function(){var t=this.toArray().join(",");return t?"@"+t:"NONE"},Qf.prototype.clone=function(){var t=Object.create(Qf.prototype);return t.length=this.length,t._words=new Uint32Array(this._words),t};var nm=0,om=1,am=2,sm=3,cm=4,um=0,hm=["D-BETA-PEPTIDE, C-GAMMA LINKING","D-GAMMA-PEPTIDE, C-DELTA LINKING","D-PEPTIDE COOH CARBOXY TERMINUS","D-PEPTIDE NH3 AMINO TERMINUS","D-PEPTIDE LINKING","L-BETA-PEPTIDE, C-GAMMA LINKING","L-GAMMA-PEPTIDE, C-DELTA LINKING","L-PEPTIDE COOH CARBOXY TERMINUS","L-PEPTIDE NH3 AMINO TERMINUS","L-PEPTIDE LINKING","PEPTIDE LINKING","PEPTIDE-LIKE"],lm=["RNA OH 3 PRIME TERMINUS","RNA OH 5 PRIME TERMINUS","RNA LINKING"],pm=["DNA OH 3 PRIME TERMINUS","DNA OH 5 PRIME TERMINUS","DNA LINKING","L-DNA LINKING","L-RNA LINKING"],dm=["D-SACCHARIDE","D-SACCHARIDE 1,4 AND 1,4 LINKING","D-SACCHARIDE 1,4 AND 1,6 LINKING","L-SACCHARIDE","L-SACCHARIDE 1,4 AND 1,4 LINKING","L-SACCHARIDE 1,4 AND 1,6 LINKING","SACCHARIDE"],fm=["NON-POLYMER"].concat(["OTHER"],dm),mm=["h","g","i"],gm=["e","b"],vm=["s","t","l",""],ym={H:1,D:1,T:1,HE:2,LI:3,BE:4,B:5,C:6,N:7,O:8,F:9,NE:10,NA:11,MG:12,AL:13,SI:14,P:15,S:16,CL:17,AR:18,K:19,CA:20,SC:21,TI:22,V:23,CR:24,MN:25,FE:26,CO:27,NI:28,CU:29,ZN:30,GA:31,GE:32,AS:33,SE:34,BR:35,KR:36,RB:37,SR:38,Y:39,ZR:40,NB:41,MO:42,TC:43,RU:44,RH:45,PD:46,AG:47,CD:48,IN:49,SN:50,SB:51,TE:52,I:53,XE:54,CS:55,BA:56,LA:57,CE:58,PR:59,ND:60,PM:61,SM:62,EU:63,GD:64,TB:65,DY:66,HO:67,ER:68,TM:69,YB:70,LU:71,HF:72,TA:73,W:74,RE:75,OS:76,IR:77,PT:78,AU:79,HG:80,TL:81,PB:82,BI:83,PO:84,AT:85,RN:86,FR:87,RA:88,AC:89,TH:90,PA:91,U:92,NP:93,PU:94,AM:95,CM:96,BK:97,CF:98,ES:99,FM:100,MD:101,NO:102,LR:103,RF:104,DB:105,SG:106,BH:107,HS:108,MT:109,DS:110,RG:111,CN:112,NH:113,FL:114,MC:115,LV:116,TS:117,OG:118},bm={1:1.1,2:1.4,3:1.81,4:1.53,5:1.92,6:1.7,7:1.55,8:1.52,9:1.47,10:1.54,11:2.27,12:1.73,13:1.84,14:2.1,15:1.8,16:1.8,17:1.75,18:1.88,19:2.75,20:2.31,21:2.3,22:2.15,23:2.05,24:2.05,25:2.05,26:2.05,27:2,28:2,29:2,30:2.1,31:1.87,32:2.11,33:1.85,34:1.9,35:1.83,36:2.02,37:3.03,38:2.49,39:2.4,40:2.3,41:2.15,42:2.1,43:2.05,44:2.05,45:2,46:2.05,47:2.1,48:2.2,49:2.2,50:1.93,51:2.17,52:2.06,53:1.98,54:2.16,55:3.43,56:2.68,57:2.5,58:2.48,59:2.47,60:2.45,61:2.43,62:2.42,63:2.4,64:2.38,65:2.37,66:2.35,67:2.33,68:2.32,69:2.3,70:2.28,71:2.27,72:2.25,73:2.2,74:2.1,75:2.05,76:2,77:2,78:2.05,79:2.1,80:2.05,81:1.96,82:2.02,83:2.07,84:1.97,85:2.02,86:2.2,87:3.48,88:2.83,89:2,90:2.4,91:2,92:2.3,93:2,94:2,95:2,96:2,97:2,98:2,99:2,100:2,101:2,102:2,103:2,104:2,105:2,106:2,107:2,108:2,109:2,110:2,111:2,112:2,113:2,114:2,115:2,116:2,117:2,118:2},xm={1:.31,2:.28,3:1.28,4:.96,5:.84,6:.76,7:.71,8:.66,9:.57,10:.58,11:1.66,12:1.41,13:1.21,14:1.11,15:1.07,16:1.05,17:1.02,18:1.06,19:2.03,20:1.76,21:1.7,22:1.6,23:1.53,24:1.39,25:1.39,26:1.32,27:1.26,28:1.24,29:1.32,30:1.22,31:1.22,32:1.2,33:1.19,34:1.2,35:1.2,36:1.16,37:2.2,38:1.95,39:1.9,40:1.75,41:1.64,42:1.54,43:1.47,44:1.46,45:1.42,46:1.39,47:1.45,48:1.44,49:1.42,50:1.39,51:1.39,52:1.38,53:1.39,54:1.4,55:2.44,56:2.15,57:2.07,58:2.04,59:2.03,60:2.01,61:1.99,62:1.98,63:1.98,64:1.96,65:1.94,66:1.92,67:1.92,68:1.89,69:1.9,70:1.87,71:1.87,72:1.75,73:1.7,74:1.62,75:1.51,76:1.44,77:1.41,78:1.36,79:1.36,80:1.32,81:1.45,82:1.46,83:1.48,84:1.4,85:1.5,86:1.5,87:2.6,88:2.21,89:2.15,90:2.06,91:2,92:1.96,93:1.9,94:1.87,95:1.8,96:1.69,97:1.6,98:1.6,99:1.6,100:1.6,101:1.6,102:1.6,103:1.6,104:1.6,105:1.6,106:1.6,107:1.6,108:1.6,109:1.6,110:1.6,111:1.6,112:1.6,113:1.6,114:1.6,115:1.6,116:1.6,117:1.6,118:1.6},_m={1:[1],2:[0],3:[1],4:[2],5:[3],6:[4],7:[3],8:[2],9:[1],10:[0],11:[1],12:[2],13:[6],14:[6],15:[3,5,7],16:[2,4,6],17:[1],18:[0],19:[1],20:[2],31:[3],32:[4],33:[3,5],34:[2,4,6],35:[1],36:[0],37:[1],38:[2],49:[3],50:[4],51:[3,5],52:[2],53:[1,2,5],54:[0,2],55:[1],56:[2],81:[3],82:[4],83:[3],84:[2],85:[1],86:[0],87:[1],88:[2]},wm={1:1,2:2,3:1,4:2,5:3,6:4,7:5,8:6,9:7,10:8,11:1,12:2,13:3,14:4,15:5,16:6,17:7,18:8,19:1,20:2,21:3,22:4,23:5,24:6,25:7,26:8,27:9,28:10,29:11,30:2,31:3,32:4,33:5,34:6,35:7,36:8,37:1,38:2,39:3,40:4,41:5,42:6,43:7,44:8,45:9,46:10,47:11,48:2,49:3,50:4,51:5,52:6,53:7,54:8,55:1,56:2,57:3,58:4,59:3,60:4,61:5,62:6,63:7,64:8,65:9,66:10,67:11,68:12,69:13,70:14,71:15,72:4,73:5,74:6,75:7,76:8,77:9,78:10,79:11,80:2,81:3,82:4,83:5,84:6,85:7,86:8,87:1,88:2,89:3,90:4,91:3,92:4,93:5,94:6,95:7,96:8,97:9,98:10,99:11,100:12,101:13,102:14,103:15,104:2,105:2,106:2,107:2,108:2,109:2,110:2,111:2,112:2,113:3,114:4,115:5,116:6,117:7,118:8},Sm={ALA:[.17,.5,.33],ARG:[.81,1.81,1],ASN:[.42,.85,.43],ASP:[1.23,3.64,2.41],ASH:[-.07,.43,.5],CYS:[-.24,-.02,.22],GLN:[.58,.77,.19],GLU:[2.02,3.63,1.61],GLH:[-.01,.11,.12],GLY:[.01,1.15,1.14],HIS:[.17,.11,-.06],ILE:[-.31,-1.12,-.81],LEU:[-.56,-1.25,-.69],LYS:[.99,2.8,1.81],MET:[-.23,-.67,-.44],PHE:[-1.13,-1.71,-.58],PRO:[.45,.14,-.31],SER:[.13,.46,.33],THR:[.14,.25,.11],TRP:[-1.85,-2.09,-.24],TYR:[-.94,-.71,.23],VAL:[.07,-.46,-.53]},Am=[0,0,0],Mm={HIS:"H",ARG:"R",LYS:"K",ILE:"I",PHE:"F",LEU:"L",TRP:"W",ALA:"A",MET:"M",PRO:"P",CYS:"C",ASN:"N",VAL:"V",GLY:"G",SER:"S",GLN:"Q",TYR:"Y",ASP:"D",GLU:"E",THR:"T",ASH:"D",GLH:"E"},Pm=Object.keys(Mm),Tm=["A","C","T","G","U"],Em=["DA","DC","DT","DG","DU","TCY","MCY","5CM"],Cm=["A","G","DA","DG"],Im=Tm.concat(Em),Rm=["SOL","WAT","HOH","H2O","W","DOD","D3O","TIP3","TIP4","SPC"],Lm=["118","119","1AL","1CU","2FK","2HP","2OF","3CO","3MT","3NI","3OF","3P8","4MO","4PU","543","6MO","ACT","AG","AL","ALF","AM","ATH","AU","AU3","AUC","AZI","BA","BCT","BEF","BF4","BO4","BR","BS3","BSY","CA","CAC","CD","CD1","CD3","CD5","CE","CHT","CL","CO","CO3","CO5","CON","CR","CS","CSB","CU","CU1","CU3","CUA","CUZ","CYN","DME","DMI","DSC","DTI","DY","E4N","EDR","EMC","ER3","EU","EU3","F","FE","FE2","FPO","GA","GD3","GEP","HAI","HG","HGC","IN","IOD","IR","IR3","IRI","IUM","K","KO4","LA","LCO","LCP","LI","LU","MAC","MG","MH2","MH3","MLI","MLT","MMC","MN","MN3","MN5","MN6","MO1","MO2","MO3","MO4","MO5","MO6","MOO","MOS","MOW","MW1","MW2","MW3","NA","NA2","NA5","NA6","NAO","NAW","NCO","NET","NH4","NI","NI1","NI2","NI3","NO2","NO3","NRU","O4M","OAA","OC1","OC2","OC3","OC4","OC5","OC6","OC7","OC8","OCL","OCM","OCN","OCO","OF1","OF2","OF3","OH","OS","OS4","OXL","PB","PBM","PD","PDV","PER","PI","PO3","PO4","PR","PT","PT4","PTN","RB","RH3","RHD","RU","SB","SCN","SE4","SEK","SM","SMO","SO3","SO4","SR","T1A","TB","TBA","TCN","TEA","TH","THE","TL","TMA","TRA","UNX","V","VN3","VO4","W","WO5","Y1","YB","YB2","YH","YT3","ZCM","ZN","ZN2","ZN3","ZNO","ZO3","OHX"],Om=["045","0AT","0BD","0MK","0NZ","0TS","0V4","0XY","0YT","10M","147","149","14T","15L","16G","18T","18Y","1AR","1BW","1GL","1GN","1JB","1LL","1NA","1S3","26M","26Q","26R","26V","26W","26Y","27C","289","291","293","2DG","2F8","2FG","2FL","2FP","2GL","2M4","2M5","32O","34V","3CM","3DO","3DY","3FM","3LR","3MF","3MG","3SA","3ZW","46D","46M","46Z","48Z","4CQ","4GC","4NN","50A","5DI","5GF","5MM","5RP","5SA","5SP","64K","6PG","6SA","7JZ","7SA","A1Q","A2G","AAB","AAL","AAO","ABC","ABD","ABE","ABF","ABL","ACG","ACI","ACR","ACX","ADA","ADG","ADR","AF1","AFD","AFL","AFO","AFP","AFR","AGC","AGH","AGL","AHR","AIG","ALL","ALX","AMU","AOG","AOS","ARA","ARB","ARE","ARI","ASG","ASO","AXP","AXR","B0D","B16","B2G","B4G","B6D","B8D","B9D","BBK","BCD","BDG","BDP","BDR","BEM","BFP","BGC","BGL","BGP","BGS","BHG","BMA","BMX","BNG","BNX","BOG","BRI","BXF","BXP","BXX","BXY","C3X","C4X","C5X","CAP","CBI","CBK","CBS","CDR","CEG","CGF","CHO","CR1","CR6","CRA","CT3","CTO","CTR","CTT","D6G","DAF","DAG","DDA","DDB","DDL","DEL","DFR","DFX","DG0","DGC","DGD","DGM","DGS","DIG","DLF","DLG","DMU","DNO","DOM","DP5","DQQ","DQR","DR2","DR3","DR4","DRI","DSR","DT6","DVC","E4P","E5G","EAG","EBG","EBQ","EGA","EJT","EPG","ERE","ERI","F1P","F1X","F6P","FBP","FCA","FCB","FCT","FDP","FDQ","FFC","FIX","FMO","FRU","FSI","FU4","FUB","FUC","FUD","FUL","FXP","G16","G1P","G2F","G3I","G4D","G4S","G6D","G6P","G6S","GAC","GAD","GAL","GC1","GC4","GCD","GCN","GCO","GCS","GCT","GCU","GCV","GCW","GCX","GE1","GFG","GFP","GIV","GL0","GL2","GL5","GL6","GL7","GL9","GLA","GLB","GLC","GLD","GLF","GLG","GLO","GLP","GLS","GLT","GLW","GMH","GN1","GNX","GP1","GP4","GPH","GPM","GQ1","GQ2","GQ4","GS1","GS4","GSA","GSD","GTE","GTH","GTK","GTR","GTZ","GU0","GU1","GU2","GU3","GU4","GU5","GU6","GU8","GU9","GUF","GUP","GUZ","GYP","GYV","H2P","HDL","HMS","HS2","HSD","HSG","HSH","HSJ","HSQ","HSR","HSU","HSX","HSY","HSZ","IAB","IDG","IDR","IDS","IDT","IDU","IDX","IDY","IMK","IN1","IPT","ISL","KBG","KD2","KDA","KDM","KDO","KFN","KO1","KO2","KTU","L6S","LAG","LAI","LAK","LAO","LAT","LB2","LBT","LCN","LDY","LGC","LGU","LM2","LMT","LMU","LOG","LOX","LPK","LSM","LTM","LVZ","LXB","LXZ","M1F","M3M","M6P","M8C","MA1","MA2","MA3","MAB","MAG","MAL","MAN","MAT","MAV","MAW","MBG","MCU","MDA","MDM","MDP","MFA","MFB","MFU","MG5","MGA","MGL","MLB","MMA","MMN","MN0","MRP","MTT","MUG","MVP","MXY","N1L","N9S","NAA","NAG","NBG","NDG","NED","NG1","NG6","NGA","NGB","NGC","NGE","NGF","NGL","NGS","NGY","NHF","NM6","NM9","NTF","NTO","NTP","NXD","NYT","OPG","OPM","ORP","OX2","P3M","P53","P6P","PA5","PNA","PNG","PNW","PRP","PSJ","PSV","PTQ","QDK","QPS","QV4","R1P","R1X","R2B","R5P","RAA","RAE","RAF","RAM","RAO","RAT","RB5","RBL","RCD","RDP","REL","RER","RF5","RG1","RGG","RHA","RIB","RIP","RNS","RNT","ROB","ROR","RPA","RST","RUB","RUU","RZM","S6P","S7P","SA0","SCR","SDD","SF6","SF9","SG4","SG5","SG6","SG7","SGA","SGC","SGD","SGN","SGS","SHB","SHG","SI3","SIO","SOE","SOL","SSG","SUC","SUP","SUS","T6P","T6T","TAG","TCB","TDG","TGK","TGY","TH1","TIA","TM5","TM6","TM9","TMR","TMX","TOA","TOC","TRE","TYV","UCD","UDC","VG1","X0X","X1X","X2F","X4S","X5S","X6X","XBP","XDN","XDP","XIF","XIM","XLF","XLS","XMM","XUL","XXR","XYP","XYS","YO5","Z3Q","Z6J","Z9M","ZDC","ZDM"],Dm=["CA","C","N","O","O1","O2","OC1","OC2","OX1","OXT","H","H1","H2","H3","HA","HN","BB"],km=["P","OP1","OP2","O2'","O3'","O4'","O5'","C1'","C2'","C3'","C4'","C5'","O2*","O3*","O4*","O5*","C1*","C2*","C3*","C4*","C5*"],Nm={};function Bm(t){switch(t){case 0:return 0;case 1:return 1;case 2:return 2;case 3:return 3;case 4:return 4;default:return 8}}Nm[1]={trace:"CA",direction1:"C",direction2:["O","OC1","O1","OX1","OXT"],backboneStart:"N",backboneEnd:"C"},Nm[2]={trace:["C4'","C4*"],direction1:["C1'","C1*"],direction2:["C3'","C3*"],backboneStart:"P",backboneEnd:["O3'","O3*"]},Nm[3]={trace:["C3'","C3*"],direction1:["C2'","C2*"],direction2:["O4'","O4*"],backboneStart:"P",backboneEnd:["O3'","O3*"]},Nm[4]={trace:["CA","BB"],backboneStart:["CA","BB"],backboneEnd:["CA","BB"]},Nm[5]={trace:["C4'","C4*","P"],backboneStart:["C4'","C4*","P"],backboneEnd:["C4'","C4*","P"]},Nm[6]={trace:["C3'","C3*","C2'","P"],backboneStart:["C3'","C3*","C2'","P"],backboneEnd:["C3'","C3*","C2'","P"]},Nm[um]={};var Fm=new Map([[2,jh(180)],[3,jh(120)],[4,jh(109.4721)],[6,jh(90)]]);function zm(t,e){var i=[],r=new $e,n=new $e;return r.subVectors(e,t),t.eachBondedAtom(function(e){1!==e.number&&(n.subVectors(e,t),i.push(r.angleTo(n)))}),i}function Um(t,e){var i=t.clone(),r=new $e;r.subVectors(e,t);var n=[new $e,new $e],o=0;if(t.eachBondedAtom(function(e){o>1||1!==e.number&&(i.index=e.index,n[o++].subVectors(e,t))}),1===o&&i.eachBondedAtom(function(e){o>1||1!==e.number&&e.index!==t.index&&n[o++].subVectors(e,t)}),2===o){var a=n[0].cross(n[1]);return Math.abs(Math.PI/2-a.angleTo(r))}}function jm(t,e){var i=t.structure,r=i.atomCount,n=new Int8Array(r),o=new Int8Array(r),a=new Int8Array(r),s=new Int8Array(r);return i.eachAtom(function(t){var i=t.index,r=function(t,e){var i,r=t.bondToElementCount(1),n=t.formalCharge||0,o="always"===e.assignCharge||"auto"===e.assignCharge&&0===n,a="always"===e.assignH||"auto"===e.assignH&&0===r,s=t.bondCount,c=(i=0,t.eachBond(function(t){return i+=t.bondOrder}),i),u=function(t){var e=t.structure.getBondProxy(),i=t.number,r=8===i||7===i;if(r&&4===t.bondCount)return!1;var n=!1;return t.eachBond(function(i){if(i.bondOrder>1)n=!0;else if(r){var o=i.getOtherAtom(t);o.eachBond(function(t){if(t.bondOrder>1){var e=o.number;if((15===e||16===e)&&8===t.getOtherAtom(o).number)return;n=!0}},e)}}),n}(t),h=c-s>0,l=0,p=8;switch(t.number){case 1:o&&(0===s?(n=1,p=0):1===s&&(n=0,p=1));break;case 6:o&&(n=0),a&&(l=Math.max(0,4-c-Math.abs(n))),p=Bm(s+l+Math.max(0,-n));break;case 7:if(o)if(a)if(u&&c<4)n=s-r==1&&c-r==2?1:0;else{var d=!1;t.eachBondedAtom(function(t){(16===t.number||t.isMetal())&&(d=!0)}),n=d?0:1}else n=c-3;a&&(l=Math.max(0,3-c+n)),p=Bm(u&&!h?s+l-n:s+l+1-n);break;case 8:o&&(a||(n=c-2),1===c&&t.eachBondedAtom(function(e){e.eachBond(function(i){var r=i.getOtherAtom(e);r.index!==t.index&&8===r.number&&2===i.bondOrder&&(n=-1)})})),a&&(l=Math.max(0,2-c+n)),p=Bm(u&&!h?s+l-n+1:s+l-n+2);break;case 16:o&&(a||(n=c<=3&&!t.bondToElementCount(8)?c-2:0)),a&&c<2&&(l=Math.max(0,2-c+n)),c<=3&&(p=Bm(s+l-n+2));break;case 9:case 17:case 35:case 53:case 85:o&&(n=c-1);break;case 3:case 11:case 19:case 37:case 55:case 87:o&&(n=1-c);break;case 4:case 12:case 20:case 38:case 56:case 88:o&&(n=2-c);break;default:console.warn("Requested charge, protonation for an unhandled element",t.element)}return[n,l,l+r,p]}(t,e),c=r[0],u=r[1],h=r[2],l=r[3];n[i]=c,o[i]=u,a[i]=h,s[i]=l}),{charge:n,implicitH:o,totalH:a,idealGeometry:s}}function Gm(t){if(t["@valenceModel"])return t["@valenceModel"];var e=jm(t,{assignCharge:"auto",assignH:"auto"});return t["@valenceModel"]=e,e}function Vm(t){return 15===t.number&&t.bondToElementCount(8)===t.bondCount}var Hm=["ARG","HIS","LYS"],$m=["GLU","ASP"];function Wm(t,e,i){void 0===i&&(i={});for(var r=yh(i.maxIonicDist,eg.maxIonicDist),n=yh(i.maxPiStackingDist,eg.maxPiStackingDist),o=yh(i.maxPiStackingOffset,eg.maxPiStackingOffset),a=yh(i.maxPiStackingAngle,eg.maxPiStackingAngle),s=yh(i.maxCationPiDist,eg.maxCationPiDist),c=yh(i.maxCationPiOffset,eg.maxCationPiOffset),u=yh(i.masterModelIndex,eg.masterModelIndex),h=Math.max(r+2,n,s),l=n*n,p=s*s,d=e.features,f=e.spatialHash,m=e.contactStore,g=e.featureSet,v=d.types,y=d.centers,b=d.atomSets,x=y.x,_=y.y,w=y.z,S=v.length,A=t.atomStore.x,M=t.atomStore.y,P=t.atomStore.z,T=t.getAtomProxy(),E=t.getAtomProxy(),C=new $e,I=new $e,R=new $e,L=new $e,O=new $e,D=new $e,k=new $e,N=function(t,e){C.set(A[t[0]],M[t[0]],P[t[0]]),I.set(A[t[1]],M[t[1]],P[t[1]]),R.set(A[t[2]],M[t[2]],P[t[2]]),L.subVectors(C,I),O.subVectors(C,R),e.crossVectors(L,O)},B=function(t,e,i){return C.set(x[t],_[t],w[t]),I.set(x[e],_[e],w[e]),C.sub(I).projectOnPlane(i).add(I).distanceTo(I)},F=function(t,e,i){g.setBits(t,e),m.addContact(t,e,i)},z=function(t){f.eachWithin(x[t],_[t],w[t],h,function(e,i){if(!(e<=t||(T.index=b[t][0],E.index=b[e][0],rg(T,E,u)))){var n,s,h,d,f=v[t],m=v[e];if(d=m,2===(h=f)&&1===d||1===h&&2===d)(function(t,e,i){for(var r=t.length,n=e.length,o=0;o<r;++o){T.index=t[o];for(var a=0;a<n;++a)if(E.index=e[a],T.distanceTo(E)<=i)return!0}return!1})(b[t],b[e],r)&&F(t,e,1);else if(3===f&&3===m){if(i<=l){N(b[t],D),N(b[e],k);var g=57.29578*D.angleTo(k);Math.min(B(t,e,k),B(e,t,D))<=o&&(g<=a||g>=180-a?F(t,e,3):g<=a+90&&g>=90-a&&F(t,e,3))}}else if(s=m,(3===(n=f)&&1===s||1===n&&3===s)&&i<=p){var y=3===f?[t,e]:[e,t],x=y[0],_=y[1];N(b[x],D),B(_,x,D)<=c&&F(x,_,2)}}})},U=0;U<S;++U)z(U)}function Xm(t){return"HIS"===t.resname&&7==t.number&&t.isRing()}var qm=[3,11,19,37,55,12,20,38,56,13,31,49,81,21,50,82,83,51,80];var Ym=[17,35,53,85];var Zm=[7,8,16],Km=[6,7,15,16];var Jm=jh(180),Qm=jh(120);function tg(t,e,i){return!ig(t,e,i)&&(t.modelIndex!==e.modelIndex||t.altloc&&e.altloc&&t.altloc!==e.altloc)}var eg={maxHydrophobicDist:4,maxHbondDist:3.5,maxHbondSulfurDist:4.1,maxHbondAccAngle:45,maxHbondDonAngle:45,maxHbondAccPlaneAngle:90,maxHbondDonPlaneAngle:30,maxPiStackingDist:5.5,maxPiStackingOffset:2,maxPiStackingAngle:30,maxCationPiDist:6,maxCationPiOffset:2,maxIonicDist:5,maxHalogenBondDist:4,maxHalogenBondAngle:30,maxMetalDist:3,refineSaltBridges:!0,masterModelIndex:-1,lineOfSightDistFactor:1};function ig(t,e,i){return t.modelIndex===i&&e.modelIndex!==i||e.modelIndex===i&&t.modelIndex!==i}function rg(t,e,i){return!ig(t,e,i)&&(t.modelIndex!==e.modelIndex||t.residueIndex===e.residueIndex||t.altloc&&e.altloc&&t.altloc!==e.altloc)}function ng(e){var i,r,n,o,a,s,c,u,h,l,p,d,f,m,g,v,y,b,x,_,w,S,A,M,P,T,E,C,I={types:[],groups:[],centers:{x:[],y:[],z:[]},atomSets:[]};return t.Debug&&ql.time("calculateFeatures"),r=I,n=Gm((i=e).data).charge,o={},i.eachResidue(function(t){if(Hm.includes(t.resname)){var e=em(1);t.eachAtom(function(t){7===t.number&&t.isSidechain()&&im(e,t)}),rm(r,e)}else Pm.includes(t.resname)||t.isNucleic()||(t.eachAtom(function(t){var e,i,n,a,s=!1,c=em(1);a=0,6===(n=t).number&&3===n.bondCount&&3===n.bondToElementCount(7)&&n.eachBondedAtom(function(t){t.bondCount-t.bondToElementCount(1)==1&&++a}),2===a?(c.group=8,s=!0):(i=0,6===(e=t).number&&3===e.bondCount&&2===e.bondToElementCount(7)&&1===e.bondToElementCount(6)&&e.eachBondedAtom(function(t){t.bondCount-t.bondToElementCount(1)==1&&++i}),2===i&&(c.group=9,s=!0)),s&&(t.eachBondedAtom(function(t){7===t.number&&(o[t.index]=!0,im(c,t))}),rm(r,c))}),t.eachAtom(function(t){var e=em(1);n[t.index]>0&&(o[t.index]||(im(e,t),rm(r,e)))}))}),s=I,c=Gm((a=e).data).charge,u={},a.eachResidue(function(t){if($m.includes(t.resname)){var e=em(2);t.eachAtom(function(t){8===t.number&&t.isSidechain()&&im(e,t)}),rm(s,e)}else if(Im.includes(t.resname)){var i=em(2);t.eachAtom(function(t){Vm(t)&&(i.group=6,t.eachBondedAtom(function(t){8===t.number&&im(i,t)}),rm(s,i))})}else Pm.includes(t.resname)||Im.includes(t.resname)||(t.eachAtom(function(t){var e,i,r,n,o=!1,a=em(2);16===(n=t).number&&3===n.bondToElementCount(8)?(a.group=4,o=!0):Vm(t)?(a.group=6,o=!0):16===(r=t).number&&4===r.bondToElementCount(8)?(a.group=5,o=!0):(i=0,6===(e=t).number&&2===e.bondToElementCount(8)&&1===e.bondToElementCount(6)&&e.eachBondedAtom(function(t){8===t.number&&t.bondCount-t.bondToElementCount(1)==1&&++i}),2===i&&(a.group=10,o=!0)),o&&(t.eachBondedAtom(function(t){8===t.number&&(u[t.index]=!0,im(a,t))}),rm(s,a))}),t.eachAtom(function(t){var e=em(2);c[t.index]<0&&(u[t.index]||(im(e,t),rm(s,e)))}))}),l=I,p=(h=e).getAtomProxy(),h.eachResidue(function(t){var e=t.getAromaticRings();if(e){var i=t.atomOffset;e.forEach(function(t){var e=em(3);t.forEach(function(t){p.index=t+i,im(e,p)}),rm(l,e)})}}),f=I,m=Gm((d=e).data),g=m.charge,v=m.implicitH,y=m.idealGeometry,d.eachAtom(function(t){var e=em(5),i=t.number;if(8===i)im(e,t),rm(f,e);else if(7===i){if(Xm(t))im(e,t),rm(f,e);else if(g[t.index]<1){var r=t.bondCount+v[t.index],n=y[t.index];(4===n&&r<4||3===n&&r<3||2===n&&r<2)&&(im(e,t),rm(f,e))}}else 16===i&&("CYS"!==t.resname&&"MET"!==t.resname&&-1!==t.formalCharge||(im(e,t),rm(f,e)))}),x=I,_=Gm((b=e).data).totalH,b.eachAtom(function(t){var e=em(4),i=t.number;Xm(t)?(im(e,t),rm(x,e)):_[t.index]>0&&(7===i||8===i||16===i)&&(im(e,t),rm(x,e))}),S=I,A=Gm((w=e).data).totalH,w.eachAtom(function(t){if(6===t.number&&A[t.index]>0&&(t.bondToElementCount(7)>0||t.bondToElementCount(8)>0||function(t){if(!t.isAromatic())return!1;var e=t.residueType.getRings();if(!e)return!1;var i=!1;return e.rings.forEach(function(e){i||e.some(function(e){return t.index-t.residueAtomOffset===e})&&(i=e.some(function(e){var i=t.residueType.atomTypeIdList[e],r=t.atomMap.get(i).number;return 7===r||8===r}))}),i}(t))){var e=em(9);im(e,t),rm(S,e)}}),M=I,e.eachAtom(function(t){var e=!1,i=!1;if(t.isProtein()?8===t.number?["ASP","GLU","SER","THR","TYR","ASN","GLN","CSO"].includes(t.resname)&&t.isSidechain()?(e=!0,i=!0):t.isBackbone()&&(e=!0,i=!0):16===t.number&&["CYS","CSO"].includes(t.resname)?(e=!0,i=!0):7===t.number&&"HIS"===t.resname&&t.isSidechain()&&(e=!0):t.isPolymer()?t.isNucleic()&&(8===t.number&&t.isBackbone()?(e=!0,i=!0):["N3","N4","N7"].includes(t.atomname)?e=!0:["O2","O4","O6"].includes(t.atomname)&&(e=!0,i=!0)):t.isHalogen()||8===t.number||16===t.number?(e=!0,i=!0):7===t.number&&(e=!0),e){var r=em(11);im(r,t),rm(M,r)}if(i){var n=em(10);im(n,t),rm(M,n)}}),P=I,e.eachAtom(function(t){if(t.isTransitionMetal()||30===t.number||48===t.number){var e=em(12);im(e,t),rm(P,e)}else if(qm.includes(t.number)){var i=em(13);im(i,t),rm(P,i)}}),T=I,e.eachAtom(function(t){var e=em(8),i=!1;6===t.number?(i=!0,t.eachBondedAtom(function(t){var e=t.number;6!==e&&1!==e&&(i=!1)})):9===t.number&&(i=!0),i&&(im(e,t),rm(T,e))}),E=I,e.eachAtom(function(t){if(Zm.includes(t.number)){var e=!1;if(t.eachBondedAtom(function(t){Km.includes(t.number)&&(e=!0)}),e){var i=em(7);im(i,t),rm(E,i)}}}),C=I,e.eachAtom(function(t){if(Ym.includes(t.number)&&1===t.bondToElementCount(6)){var e=em(6);im(e,t),rm(C,e)}}),t.Debug&&ql.timeEnd("calculateFeatures"),I}function og(e,i){void 0===i&&(i=eg);var r,n,o,a=ng(e),s=(n=(r=a).types,o=r.centers,{features:r,spatialHash:new Yf(o),contactStore:new Kf,featureSet:new Qf(n.length,!1)});t.Debug&&ql.time("calculateContacts"),Wm(e,s,i),function(t,e,i){void 0===i&&(i={});for(var r=yh(i.maxHbondDist,eg.maxHbondDist),n=yh(i.maxHbondSulfurDist,eg.maxHbondSulfurDist),o=jh(yh(i.maxHbondAccAngle,eg.maxHbondAccAngle)),a=jh(yh(i.maxHbondDonAngle,eg.maxHbondDonAngle)),s=jh(yh(i.maxHbondAccPlaneAngle,eg.maxHbondAccPlaneAngle)),c=jh(yh(i.maxHbondDonPlaneAngle,eg.maxHbondDonPlaneAngle)),u=yh(i.masterModelIndex,eg.masterModelIndex),h=Math.max(r,n),l=r*r,p=e.features,d=e.spatialHash,f=e.contactStore,m=e.featureSet,g=p.types,v=p.centers,y=p.atomSets,b=v.x,x=v.y,_=v.z,w=g.length,S=Gm(t.data).idealGeometry,A=t.getAtomProxy(),M=t.getAtomProxy(),P=function(t){d.eachWithin(b[t],x[t],_[t],h,function(e,i){if(!(e<=t)){var r,n,h=g[t],p=g[e],d=(n=p,9===(r=h)&&5===n||5===r&&9===n);if(d||(b=p,5===(v=h)&&4===b||4===v&&5===b)){var v,b,x=5===p?[t,e]:[e,t],_=x[0],w=x[1];if(A.index=y[_][0],M.index=y[w][0],!rg(A,M,u)&&!(16!==A.number&&16!==M.number&&i>l||A.connectedTo(M))){var P=zm(A,M),T=Fm.get(S[A.index])||jh(120);if(!P.some(function(t){return Math.abs(T-t)>a})){if(3===S[A.index]){var E=Um(A,M);if(void 0!==E&&E>c)return}var C=zm(M,A),I=Fm.get(S[M.index])||jh(120);if(!C.some(function(t){return I-t>o})){if(3===S[M.index]){var R=Um(M,A);if(void 0!==R&&R>s)return}m.setBits(_,w);var L,O,D,k,N=d?8:(k=O=M,(L=A).isWater()&&k.isWater()?9:(D=O,L.isBackbone()&&D.isBackbone()?10:4));f.addContact(_,w,N)}}}}}})},T=0;T<w;++T)P(T)}(e,s,i),function(t,e,i){void 0===i&&(i={});for(var r=yh(i.maxMetalDist,eg.maxMetalDist),n=yh(i.masterModelIndex,eg.masterModelIndex),o=e.features,a=e.spatialHash,s=e.contactStore,c=e.featureSet,u=o.types,h=o.centers,l=o.atomSets,p=h.x,d=h.y,f=h.z,m=u.length,g=t.getAtomProxy(),v=t.getAtomProxy(),y=function(t){a.eachWithin(p[t],d[t],f[t],r,function(e,i){if(!(e<=t||(g.index=l[t][0],v.index=l[e][0],rg(g,v,n)))){var r=g.isMetal(),o=v.isMetal();if(r||o){var a,h,p=r?[u[t],u[e]]:[u[e],u[t]];h=p[1],(12===(a=p[0])?11===h||12===h:13===a?10===h:void 0)&&(c.setBits(t,e),s.addContact(t,e,7))}}})},b=0;b<m;++b)y(b)}(e,s,i),function(t,e,i){void 0===i&&(i={});for(var r=yh(i.maxHydrophobicDist,eg.maxHydrophobicDist),n=yh(i.masterModelIndex,eg.masterModelIndex),o=e.features,a=e.spatialHash,s=e.contactStore,c=e.featureSet,u=o.types,h=o.centers,l=o.atomSets,p=h.x,d=h.y,f=h.z,m=u.length,g=t.getAtomProxy(),v=t.getAtomProxy(),y=function(t){a.eachWithin(p[t],d[t],f[t],r,function(e,i){var r,o;e<=t||(g.index=l[t][0],v.index=l[e][0],rg(g,v,n)||9===g.number&&9===v.number||g.connectedTo(v)||(r=u[t],o=u[e],8===r&&8===o&&(c.setBits(t,e),s.addContact(t,e,6))))})},b=0;b<m;++b)y(b)}(e,s,i),function(t,e,i){void 0===i&&(i={});for(var r=yh(i.maxHalogenBondDist,eg.maxHalogenBondDist),n=jh(yh(i.maxHalogenBondAngle,eg.maxHalogenBondAngle)),o=yh(i.masterModelIndex,eg.masterModelIndex),a=e.features,s=e.spatialHash,c=e.contactStore,u=e.featureSet,h=a.types,l=a.centers,p=a.atomSets,d=l.x,f=l.y,m=l.z,g=h.length,v=t.getAtomProxy(),y=t.getAtomProxy(),b=function(t){s.eachWithin(d[t],f[t],m[t],r,function(e,i){if(!(e<=t)&&(v.index=p[t][0],y.index=p[e][0],!rg(v,y,o)&&(r=h[t],a=h[e],7===r&&6===a||6===r&&7===a))){var r,a,s=6===h[t]?[v,y]:[y,v],l=s[0],d=s[1],f=zm(l,d);if(1===f.length&&!(Jm-f[0]>n)){var m=zm(d,l);0!==m.length&&(m.some(function(t){return Qm-t>n})||(u.setBits(t,e),c.addContact(t,e,5)))}}})},x=0;x<g;++x)b(x)}(e,s,i);var c,u,h,l,p,d,f,m,g,v,y,b,x,_,w,S,A,M,P,T,E,C,I,R,L,O,D,k,N,B,F,z,U,j,G,V,H,$,W,X,q,Y,Z,K,J,Q,tt,et=(u=(c=s).contactStore,h=tm({nodeArray1:u.index1,nodeArray2:u.index2,edgeCount:u.count,nodeCount:c.featureSet.length}),l=new Qf(c.contactStore.count,!0),Object.assign({adjacencyList:h,contactSet:l},c));return function(e,i,r){void 0===r&&(r={}),t.Debug&&ql.time("refineLineOfSight");var n=yh(r.lineOfSightDistFactor,eg.lineOfSightDistFactor),o=yh(r.masterModelIndex,eg.masterModelIndex),a=e.spatialHash,s=i.contactSet,c=i.contactStore,u=i.features,h=c.index1,l=c.index2,p=u.centers,d=u.atomSets,f=p.x,m=p.y,g=p.z,v=e.getAtomProxy(),y=e.getAtomProxy(),b=e.getAtomProxy(),x=new $e,_=new $e,w=3*n,S=n*n;s.forEach(function(e){x.set(f[h[e]],m[h[e]],g[h[e]]),_.set(f[l[e]],m[l[e]],g[l[e]]);var i=(x.x+_.x)/2,r=(x.y+_.y)/2,n=(x.z+_.z)/2,c=d[h[e]],u=d[l[e]];v.index=c[0],y.index=u[0],a.eachWithin(i,r,n,w,function(i,r){b.index=i,1!==b.number&&b.vdw*b.vdw*S>r&&!tg(v,b,o)&&!tg(y,b,o)&&!c.includes(i)&&!u.includes(i)&&x.distanceToSquared(b)>1&&_.distanceToSquared(b)>1&&(s.clear(e),t.Debug&&ql.log("removing",v.qualifiedName(),y.qualifiedName(),"because",b.qualifiedName()))})}),t.Debug&&ql.timeEnd("refineLineOfSight")}(e,et,i),p=e,f=(d=et).contactSet,m=d.contactStore,g=d.features,v=m.type,y=m.index1,b=m.index2,x=g.atomSets,_=p.getAtomProxy(),w=p.getAtomProxy(),S={},A=function(t,e,i){var r=S[i]||[1/0,-1],n=r[0],o=r[1];t<n?(-1!==o&&f.clear(o),S[i]=[t,e]):f.clear(e)},f.forEach(function(t){if(6===v[t]){_.index=x[y[t]][0],w.index=x[b[t]][0];var e=_.distanceTo(w);A(e,t,_.index+"|"+w.residueIndex),A(e,t,w.index+"|"+_.residueIndex)}}),i.refineSaltBridges&&(P=(M=et).contactSet,T=M.contactStore,E=M.features,C=T.type,I=T.index1,R=T.index2,L=E.atomSets,O={},D=function(t,e){O[t]||(O[t]=[]),O[t].push(e)},P.forEach(function(t){1===C[t]&&(L[I[t]].forEach(function(e){return D(e,t)}),L[R[t]].forEach(function(e){return D(e,t)}))}),P.forEach(function(t){if(4===(e=C[t])||9===e||10===e){var e,i=O[L[I[t]][0]],r=O[L[R[t]][0]];if(i&&r)for(var n=i.length,o=0;o<n;++o)if(r.includes(i[o]))return void P.clear(t)}})),N=(k=et).contactSet,B=k.contactStore,F=k.features,z=B.type,U=B.index1,j=B.index2,G=F.atomSets,V={},H=function(t,e){V[t]||(V[t]=[]),V[t].push(e)},N.forEach(function(t){3===z[t]&&(G[U[t]].forEach(function(e){return H(e,t)}),G[j[t]].forEach(function(e){return H(e,t)}))}),N.forEach(function(t){if(6===z[t]||2===z[t]){var e=V[G[U[t]][0]],i=V[G[j[t]][0]];if(e&&i)for(var r=e.length,n=0;n<r;++n)if(i.includes(e[n]))return void N.clear(t)}}),W=($=et).contactSet,X=$.contactStore,q=$.features,Y=X.type,Z=X.index1,K=X.index2,J=q.atomSets,Q={},tt=function(t,e){Q[t]||(Q[t]=[]),Q[t].push(e)},W.forEach(function(t){1===Y[t]&&(J[Z[t]].forEach(function(e){return tt(e,t)}),J[K[t]].forEach(function(e){return tt(e,t)}))}),W.forEach(function(t){if(7===Y[t]){var e=Q[J[Z[t]][0]],i=Q[J[K[t]][0]];if(e&&i)for(var r=e.length,n=0;n<r;++n)if(i.includes(e[n]))return void W.clear(e[n])}}),t.Debug&&ql.timeEnd("calculateContacts"),et}var ag={hydrogenBond:!0,hydrophobic:!0,halogenBond:!0,ionicInteraction:!0,metalCoordination:!0,cationPi:!0,piStacking:!0,weakHydrogenBond:!0,waterHydrogenBond:!0,backboneHydrogenBond:!0,radius:1,filterSele:""},sg=new Gi;function cg(t,e,i){var r=bh(i,ag),n=[];r.hydrogenBond&&n.push(4),r.hydrophobic&&n.push(6),r.halogenBond&&n.push(5),r.ionicInteraction&&n.push(1),r.metalCoordination&&n.push(7),r.cationPi&&n.push(2),r.piStacking&&n.push(3),r.weakHydrogenBond&&n.push(8),r.waterHydrogenBond&&n.push(9),r.backboneHydrogenBond&&n.push(10);var o,a=t.features,s=t.contactSet,c=t.contactStore,u=a.centers,h=a.atomSets,l=u.x,p=u.y,d=u.z,f=c.index1,m=c.index2,g=c.type,v=[],y=[],b=[],x=[],_=[];return r.filterSele&&(o=e.getAtomSet(new Rl(r.filterSele))),s.forEach(function(t){var e=g[t];if(n.includes(e)){if(o){var i=h[f[t]][0],a=h[m[t]][0];if(!o.isSet(i)&&!o.isSet(a))return}var s=f[t],c=m[t];v.push(l[s],p[s],d[s]),y.push(l[c],p[c],d[c]),b.push.apply(b,function(t){switch(t){case 4:case 9:case 10:return sg.setHex(2851770).toArray();case 6:return sg.setHex(8421504).toArray();case 5:return sg.setHex(4259775).toArray();case 1:return sg.setHex(15779860).toArray();case 7:return sg.setHex(9191577).toArray();case 2:return sg.setHex(16744448).toArray();case 3:return sg.setHex(9220966).toArray();case 8:return sg.setHex(12967404).toArray();default:return sg.setHex(13421772).toArray()}}(e)),x.push(r.radius),_.push(t)}}),{position1:new Float32Array(v),position2:new Float32Array(y),color:new Float32Array(b),radius:new Float32Array(x),picking:new vg(_,t,e)}}var ug=function(t){this.array=t},hg={type:{configurable:!0},data:{configurable:!0}};hg.type.get=function(){return""},hg.data.get=function(){return{}},ug.prototype.getIndex=function(t){return this.array?this.array[t]:t},ug.prototype.getObject=function(t){return{}},ug.prototype._applyTransformations=function(t,e,i){return e&&t.applyMatrix4(e.matrix),i&&t.applyMatrix4(i.matrix),t},ug.prototype._getPosition=function(){return new $e},ug.prototype.getPosition=function(t,e,i){return this._applyTransformations(this._getPosition(t),e,i)},Object.defineProperties(ug.prototype,hg);var lg=function(t){function e(e){t.call(this),this.shape=e}t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e;var i={primitive:{configurable:!0},data:{configurable:!0},type:{configurable:!0}};return i.primitive.get=function(){},i.data.get=function(){return this.shape},i.type.get=function(){return this.primitive.type},e.prototype.getObject=function(t){return this.primitive.objectFromShape(this.shape,this.getIndex(t))},e.prototype._getPosition=function(t){return this.primitive.positionFromShape(this.shape,this.getIndex(t))},Object.defineProperties(e.prototype,i),e}(ug),pg=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e;var i={primitive:{configurable:!0}};return i.primitive.get=function(){return jf},Object.defineProperties(e.prototype,i),e}(lg),dg=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e;var i={primitive:{configurable:!0}};return i.primitive.get=function(){return Gf},Object.defineProperties(e.prototype,i),e}(lg),fg=function(t){function e(e,i){t.call(this,e),this.structure=i}t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e;var i={type:{configurable:!0},data:{configurable:!0}};return i.type.get=function(){return"atom"},i.data.get=function(){return this.structure},e.prototype.getObject=function(t){return this.structure.getAtomProxy(this.getIndex(t))},e.prototype._getPosition=function(t){return(new $e).copy(this.getObject(t))},Object.defineProperties(e.prototype,i),e}(ug),mg=function(t){function e(e){t.call(this),this.axes=e}t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e;var i={type:{configurable:!0},data:{configurable:!0}};return i.type.get=function(){return"axes"},i.data.get=function(){return this.axes},e.prototype.getObject=function(){return{axes:this.axes}},e.prototype._getPosition=function(){return this.axes.center.clone()},Object.defineProperties(e.prototype,i),e}(ug),gg=function(t){function e(e,i,r){t.call(this,e),this.structure=i,this.bondStore=r||i.bondStore}t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e;var i={type:{configurable:!0},data:{configurable:!0}};return i.type.get=function(){return"bond"},i.data.get=function(){return this.structure},e.prototype.getObject=function(t){var e=this.structure.getBondProxy(this.getIndex(t));return e.bondStore=this.bondStore,e},e.prototype._getPosition=function(t){var e=this.getObject(t);return(new $e).copy(e.atom1).add(e.atom2).multiplyScalar(.5)},Object.defineProperties(e.prototype,i),e}(ug),vg=function(t){function e(e,i,r){t.call(this,e),this.contacts=i,this.structure=r}t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e;var i={type:{configurable:!0},data:{configurable:!0}};return i.type.get=function(){return"contact"},i.data.get=function(){return this.contacts},e.prototype.getObject=function(t){var e=this.getIndex(t),i=this.contacts,r=i.features,n=i.contactStore,o=r.centers,a=r.atomSets,s=o.x,c=o.y,u=o.z,h=n.index1,l=n.index2,p=n.type,d=h[e],f=l[e];return{center1:new $e(s[d],c[d],u[d]),center2:new $e(s[f],c[f],u[f]),atom1:this.structure.getAtomProxy(a[d][0]),atom2:this.structure.getAtomProxy(a[f][0]),type:function(t){switch(t){case 4:case 9:case 10:return"hydrogen bond";case 6:return"hydrophobic contact";case 5:return"halogen bond";case 1:return"ionic interaction";case 7:return"metal coordination";case 2:return"cation-pi interaction";case 3:return"pi-pi stacking";case 8:return"weak hydrogen bond";default:return"unknown contact"}}(p[e])}},e.prototype._getPosition=function(t){var e=this.getObject(t),i=e.center1,r=e.center2;return(new $e).addVectors(i,r).multiplyScalar(.5)},Object.defineProperties(e.prototype,i),e}(ug),yg=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e;var i={primitive:{configurable:!0}};return i.primitive.get=function(){return Vf},Object.defineProperties(e.prototype,i),e}(lg),bg=function(t){function e(e,i,r){t.call(this,e),this.validation=i,this.structure=r}t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e;var i={type:{configurable:!0},data:{configurable:!0}};return i.type.get=function(){return"clash"},i.data.get=function(){return this.validation},e.prototype.getObject=function(t){var e=this.validation,i=this.getIndex(t);return{validation:e,index:i,clash:e.clashArray[i]}},e.prototype._getAtomProxyFromSele=function(t){var e=new Rl(t),i=this.structure.getAtomIndices(e)[0];return this.structure.getAtomProxy(i)},e.prototype._getPosition=function(t){var e=this.getObject(t).clash,i=this._getAtomProxyFromSele(e.sele1),r=this._getAtomProxyFromSele(e.sele2);return(new $e).copy(i).add(r).multiplyScalar(.5)},Object.defineProperties(e.prototype,i),e}(ug),xg=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e;var i={type:{configurable:!0}};return i.type.get=function(){return"distance"},Object.defineProperties(e.prototype,i),e}(gg),_g=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e;var i={primitive:{configurable:!0}};return i.primitive.get=function(){return Hf},Object.defineProperties(e.prototype,i),e}(lg),wg=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e;var i={primitive:{configurable:!0}};return i.primitive.get=function(){return zf},Object.defineProperties(e.prototype,i),e}(lg),Sg=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e;var i={primitive:{configurable:!0}};return i.primitive.get=function(){return Ff},Object.defineProperties(e.prototype,i),e}(lg),Ag=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e;var i={type:{configurable:!0}};return i.type.get=function(){return"ignore"},Object.defineProperties(e.prototype,i),e}(ug),Mg=function(t){function e(e,i){t.call(this,e),this.mesh=i}t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e;var i={type:{configurable:!0}};return i.type.get=function(){return"mesh"},e.prototype.getObject=function(){var t=this.mesh;return{shape:this.shape,name:t.name,serial:t.serial}},e.prototype._getPosition=function(){return this.__position||(this.__position=uf(this.mesh.position)),this.__position},Object.defineProperties(e.prototype,i),e}(lg),Pg=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e;var i={primitive:{configurable:!0}};return i.primitive.get=function(){return Bf},Object.defineProperties(e.prototype,i),e}(lg),Tg=function(t){function e(e,i){t.call(this,e),this.surface=i}t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e;var i={type:{configurable:!0},data:{configurable:!0}};return i.type.get=function(){return"surface"},i.data.get=function(){return this.surface},e.prototype.getObject=function(t){return{surface:this.surface,index:this.getIndex(t)}},e.prototype._getPosition=function(){return this.surface.center.clone()},Object.defineProperties(e.prototype,i),e}(ug),Eg=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e;var i={primitive:{configurable:!0}};return i.primitive.get=function(){return Uf},Object.defineProperties(e.prototype,i),e}(lg),Cg=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e;var i={primitive:{configurable:!0}};return i.primitive.get=function(){return $f},Object.defineProperties(e.prototype,i),e}(lg),Ig=function(t){function e(e,i){t.call(this),this.unitcell=e,this.structure=i}t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e;var i={type:{configurable:!0},data:{configurable:!0}};return i.type.get=function(){return"unitcell"},i.data.get=function(){return this.unitcell},e.prototype.getObject=function(){return{unitcell:this.unitcell,structure:this.structure}},e.prototype._getPosition=function(){return this.unitcell.getCenter(this.structure)},Object.defineProperties(e.prototype,i),e}(ug),Rg=(function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e;var i={type:{configurable:!0}};i.type.get=function(){return"unknown"},Object.defineProperties(e.prototype,i)}(ug),function(t){function e(e,i){t.call(this,e),this.volume=i}t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e;var i={type:{configurable:!0},data:{configurable:!0}};return i.type.get=function(){return"volume"},i.data.get=function(){return this.volume},e.prototype.getObject=function(t){var e=this.volume,i=this.getIndex(t);return{volume:e,index:i,value:e.data[i]}},e.prototype._getPosition=function(t){var e=this.volume.position,i=this.getIndex(t);return new $e(e[3*i],e[3*i+1],e[3*i+2])},Object.defineProperties(e.prototype,i),e}(ug)),Lg=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e;var i={type:{configurable:!0}};return i.type.get=function(){return"slice"},Object.defineProperties(e.prototype,i),e}(Rg),Og=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e;var i={primitive:{configurable:!0}};return i.primitive.get=function(){return Xf},Object.defineProperties(e.prototype,i),e}(lg),Dg=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e;var i={primitive:{configurable:!0}};return i.primitive.get=function(){return qf},Object.defineProperties(e.prototype,i),e}(lg);function kg(){return new Uint32Array([0,265,515,778,1030,1295,1541,1804,2060,2309,2575,2822,3082,3331,3593,3840,400,153,915,666,1430,1183,1941,1692,2460,2197,2975,2710,3482,3219,3993,3728,560,825,51,314,1590,1855,1077,1340,2620,2869,2111,2358,3642,3891,3129,3376,928,681,419,170,1958,1711,1445,1196,2988,2725,2479,2214,4010,3747,3497,3232,1120,1385,1635,1898,102,367,613,876,3180,3429,3695,3942,2154,2403,2665,2912,1520,1273,2035,1786,502,255,1013,764,3580,3317,4095,3830,2554,2291,3065,2800,1616,1881,1107,1370,598,863,85,348,3676,3925,3167,3414,2650,2899,2137,2384,1984,1737,1475,1226,966,719,453,204,4044,3781,3535,3270,3018,2755,2505,2240,2240,2505,2755,3018,3270,3535,3781,4044,204,453,719,966,1226,1475,1737,1984,2384,2137,2899,2650,3414,3167,3925,3676,348,85,863,598,1370,1107,1881,1616,2800,3065,2291,2554,3830,4095,3317,3580,764,1013,255,502,1786,2035,1273,1520,2912,2665,2403,2154,3942,3695,3429,3180,876,613,367,102,1898,1635,1385,1120,3232,3497,3747,4010,2214,2479,2725,2988,1196,1445,1711,1958,170,419,681,928,3376,3129,3891,3642,2358,2111,2869,2620,1340,1077,1855,1590,314,51,825,560,3728,3993,3219,3482,2710,2975,2197,2460,1692,1941,1183,1430,666,915,153,400,3840,3593,3331,3082,2822,2575,2309,2060,1804,1541,1295,1030,778,515,265,0])}function Ng(){return new Int32Array([-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,8,3,9,8,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,1,2,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,2,10,0,2,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,8,3,2,10,8,10,9,8,-1,-1,-1,-1,-1,-1,-1,3,11,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,11,2,8,11,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,9,0,2,3,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,11,2,1,9,11,9,8,11,-1,-1,-1,-1,-1,-1,-1,3,10,1,11,10,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,10,1,0,8,10,8,11,10,-1,-1,-1,-1,-1,-1,-1,3,9,0,3,11,9,11,10,9,-1,-1,-1,-1,-1,-1,-1,9,8,10,10,8,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,7,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,3,0,7,3,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,8,4,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,1,9,4,7,1,7,3,1,-1,-1,-1,-1,-1,-1,-1,1,2,10,8,4,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,4,7,3,0,4,1,2,10,-1,-1,-1,-1,-1,-1,-1,9,2,10,9,0,2,8,4,7,-1,-1,-1,-1,-1,-1,-1,2,10,9,2,9,7,2,7,3,7,9,4,-1,-1,-1,-1,8,4,7,3,11,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,4,7,11,2,4,2,0,4,-1,-1,-1,-1,-1,-1,-1,9,0,1,8,4,7,2,3,11,-1,-1,-1,-1,-1,-1,-1,4,7,11,9,4,11,9,11,2,9,2,1,-1,-1,-1,-1,3,10,1,3,11,10,7,8,4,-1,-1,-1,-1,-1,-1,-1,1,11,10,1,4,11,1,0,4,7,11,4,-1,-1,-1,-1,4,7,8,9,0,11,9,11,10,11,0,3,-1,-1,-1,-1,4,7,11,4,11,9,9,11,10,-1,-1,-1,-1,-1,-1,-1,9,5,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,5,4,0,8,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,5,4,1,5,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,5,4,8,3,5,3,1,5,-1,-1,-1,-1,-1,-1,-1,1,2,10,9,5,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,8,1,2,10,4,9,5,-1,-1,-1,-1,-1,-1,-1,5,2,10,5,4,2,4,0,2,-1,-1,-1,-1,-1,-1,-1,2,10,5,3,2,5,3,5,4,3,4,8,-1,-1,-1,-1,9,5,4,2,3,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,11,2,0,8,11,4,9,5,-1,-1,-1,-1,-1,-1,-1,0,5,4,0,1,5,2,3,11,-1,-1,-1,-1,-1,-1,-1,2,1,5,2,5,8,2,8,11,4,8,5,-1,-1,-1,-1,10,3,11,10,1,3,9,5,4,-1,-1,-1,-1,-1,-1,-1,4,9,5,0,8,1,8,10,1,8,11,10,-1,-1,-1,-1,5,4,0,5,0,11,5,11,10,11,0,3,-1,-1,-1,-1,5,4,8,5,8,10,10,8,11,-1,-1,-1,-1,-1,-1,-1,9,7,8,5,7,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,3,0,9,5,3,5,7,3,-1,-1,-1,-1,-1,-1,-1,0,7,8,0,1,7,1,5,7,-1,-1,-1,-1,-1,-1,-1,1,5,3,3,5,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,7,8,9,5,7,10,1,2,-1,-1,-1,-1,-1,-1,-1,10,1,2,9,5,0,5,3,0,5,7,3,-1,-1,-1,-1,8,0,2,8,2,5,8,5,7,10,5,2,-1,-1,-1,-1,2,10,5,2,5,3,3,5,7,-1,-1,-1,-1,-1,-1,-1,7,9,5,7,8,9,3,11,2,-1,-1,-1,-1,-1,-1,-1,9,5,7,9,7,2,9,2,0,2,7,11,-1,-1,-1,-1,2,3,11,0,1,8,1,7,8,1,5,7,-1,-1,-1,-1,11,2,1,11,1,7,7,1,5,-1,-1,-1,-1,-1,-1,-1,9,5,8,8,5,7,10,1,3,10,3,11,-1,-1,-1,-1,5,7,0,5,0,9,7,11,0,1,0,10,11,10,0,-1,11,10,0,11,0,3,10,5,0,8,0,7,5,7,0,-1,11,10,5,7,11,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,10,6,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,5,10,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,0,1,5,10,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,8,3,1,9,8,5,10,6,-1,-1,-1,-1,-1,-1,-1,1,6,5,2,6,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,6,5,1,2,6,3,0,8,-1,-1,-1,-1,-1,-1,-1,9,6,5,9,0,6,0,2,6,-1,-1,-1,-1,-1,-1,-1,5,9,8,5,8,2,5,2,6,3,2,8,-1,-1,-1,-1,2,3,11,10,6,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,0,8,11,2,0,10,6,5,-1,-1,-1,-1,-1,-1,-1,0,1,9,2,3,11,5,10,6,-1,-1,-1,-1,-1,-1,-1,5,10,6,1,9,2,9,11,2,9,8,11,-1,-1,-1,-1,6,3,11,6,5,3,5,1,3,-1,-1,-1,-1,-1,-1,-1,0,8,11,0,11,5,0,5,1,5,11,6,-1,-1,-1,-1,3,11,6,0,3,6,0,6,5,0,5,9,-1,-1,-1,-1,6,5,9,6,9,11,11,9,8,-1,-1,-1,-1,-1,-1,-1,5,10,6,4,7,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,3,0,4,7,3,6,5,10,-1,-1,-1,-1,-1,-1,-1,1,9,0,5,10,6,8,4,7,-1,-1,-1,-1,-1,-1,-1,10,6,5,1,9,7,1,7,3,7,9,4,-1,-1,-1,-1,6,1,2,6,5,1,4,7,8,-1,-1,-1,-1,-1,-1,-1,1,2,5,5,2,6,3,0,4,3,4,7,-1,-1,-1,-1,8,4,7,9,0,5,0,6,5,0,2,6,-1,-1,-1,-1,7,3,9,7,9,4,3,2,9,5,9,6,2,6,9,-1,3,11,2,7,8,4,10,6,5,-1,-1,-1,-1,-1,-1,-1,5,10,6,4,7,2,4,2,0,2,7,11,-1,-1,-1,-1,0,1,9,4,7,8,2,3,11,5,10,6,-1,-1,-1,-1,9,2,1,9,11,2,9,4,11,7,11,4,5,10,6,-1,8,4,7,3,11,5,3,5,1,5,11,6,-1,-1,-1,-1,5,1,11,5,11,6,1,0,11,7,11,4,0,4,11,-1,0,5,9,0,6,5,0,3,6,11,6,3,8,4,7,-1,6,5,9,6,9,11,4,7,9,7,11,9,-1,-1,-1,-1,10,4,9,6,4,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,10,6,4,9,10,0,8,3,-1,-1,-1,-1,-1,-1,-1,10,0,1,10,6,0,6,4,0,-1,-1,-1,-1,-1,-1,-1,8,3,1,8,1,6,8,6,4,6,1,10,-1,-1,-1,-1,1,4,9,1,2,4,2,6,4,-1,-1,-1,-1,-1,-1,-1,3,0,8,1,2,9,2,4,9,2,6,4,-1,-1,-1,-1,0,2,4,4,2,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,3,2,8,2,4,4,2,6,-1,-1,-1,-1,-1,-1,-1,10,4,9,10,6,4,11,2,3,-1,-1,-1,-1,-1,-1,-1,0,8,2,2,8,11,4,9,10,4,10,6,-1,-1,-1,-1,3,11,2,0,1,6,0,6,4,6,1,10,-1,-1,-1,-1,6,4,1,6,1,10,4,8,1,2,1,11,8,11,1,-1,9,6,4,9,3,6,9,1,3,11,6,3,-1,-1,-1,-1,8,11,1,8,1,0,11,6,1,9,1,4,6,4,1,-1,3,11,6,3,6,0,0,6,4,-1,-1,-1,-1,-1,-1,-1,6,4,8,11,6,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,10,6,7,8,10,8,9,10,-1,-1,-1,-1,-1,-1,-1,0,7,3,0,10,7,0,9,10,6,7,10,-1,-1,-1,-1,10,6,7,1,10,7,1,7,8,1,8,0,-1,-1,-1,-1,10,6,7,10,7,1,1,7,3,-1,-1,-1,-1,-1,-1,-1,1,2,6,1,6,8,1,8,9,8,6,7,-1,-1,-1,-1,2,6,9,2,9,1,6,7,9,0,9,3,7,3,9,-1,7,8,0,7,0,6,6,0,2,-1,-1,-1,-1,-1,-1,-1,7,3,2,6,7,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,11,10,6,8,10,8,9,8,6,7,-1,-1,-1,-1,2,0,7,2,7,11,0,9,7,6,7,10,9,10,7,-1,1,8,0,1,7,8,1,10,7,6,7,10,2,3,11,-1,11,2,1,11,1,7,10,6,1,6,7,1,-1,-1,-1,-1,8,9,6,8,6,7,9,1,6,11,6,3,1,3,6,-1,0,9,1,11,6,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,8,0,7,0,6,3,11,0,11,6,0,-1,-1,-1,-1,7,11,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,6,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,8,11,7,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,11,7,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,1,9,8,3,1,11,7,6,-1,-1,-1,-1,-1,-1,-1,10,1,2,6,11,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,10,3,0,8,6,11,7,-1,-1,-1,-1,-1,-1,-1,2,9,0,2,10,9,6,11,7,-1,-1,-1,-1,-1,-1,-1,6,11,7,2,10,3,10,8,3,10,9,8,-1,-1,-1,-1,7,2,3,6,2,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,0,8,7,6,0,6,2,0,-1,-1,-1,-1,-1,-1,-1,2,7,6,2,3,7,0,1,9,-1,-1,-1,-1,-1,-1,-1,1,6,2,1,8,6,1,9,8,8,7,6,-1,-1,-1,-1,10,7,6,10,1,7,1,3,7,-1,-1,-1,-1,-1,-1,-1,10,7,6,1,7,10,1,8,7,1,0,8,-1,-1,-1,-1,0,3,7,0,7,10,0,10,9,6,10,7,-1,-1,-1,-1,7,6,10,7,10,8,8,10,9,-1,-1,-1,-1,-1,-1,-1,6,8,4,11,8,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,6,11,3,0,6,0,4,6,-1,-1,-1,-1,-1,-1,-1,8,6,11,8,4,6,9,0,1,-1,-1,-1,-1,-1,-1,-1,9,4,6,9,6,3,9,3,1,11,3,6,-1,-1,-1,-1,6,8,4,6,11,8,2,10,1,-1,-1,-1,-1,-1,-1,-1,1,2,10,3,0,11,0,6,11,0,4,6,-1,-1,-1,-1,4,11,8,4,6,11,0,2,9,2,10,9,-1,-1,-1,-1,10,9,3,10,3,2,9,4,3,11,3,6,4,6,3,-1,8,2,3,8,4,2,4,6,2,-1,-1,-1,-1,-1,-1,-1,0,4,2,4,6,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,9,0,2,3,4,2,4,6,4,3,8,-1,-1,-1,-1,1,9,4,1,4,2,2,4,6,-1,-1,-1,-1,-1,-1,-1,8,1,3,8,6,1,8,4,6,6,10,1,-1,-1,-1,-1,10,1,0,10,0,6,6,0,4,-1,-1,-1,-1,-1,-1,-1,4,6,3,4,3,8,6,10,3,0,3,9,10,9,3,-1,10,9,4,6,10,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,9,5,7,6,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,4,9,5,11,7,6,-1,-1,-1,-1,-1,-1,-1,5,0,1,5,4,0,7,6,11,-1,-1,-1,-1,-1,-1,-1,11,7,6,8,3,4,3,5,4,3,1,5,-1,-1,-1,-1,9,5,4,10,1,2,7,6,11,-1,-1,-1,-1,-1,-1,-1,6,11,7,1,2,10,0,8,3,4,9,5,-1,-1,-1,-1,7,6,11,5,4,10,4,2,10,4,0,2,-1,-1,-1,-1,3,4,8,3,5,4,3,2,5,10,5,2,11,7,6,-1,7,2,3,7,6,2,5,4,9,-1,-1,-1,-1,-1,-1,-1,9,5,4,0,8,6,0,6,2,6,8,7,-1,-1,-1,-1,3,6,2,3,7,6,1,5,0,5,4,0,-1,-1,-1,-1,6,2,8,6,8,7,2,1,8,4,8,5,1,5,8,-1,9,5,4,10,1,6,1,7,6,1,3,7,-1,-1,-1,-1,1,6,10,1,7,6,1,0,7,8,7,0,9,5,4,-1,4,0,10,4,10,5,0,3,10,6,10,7,3,7,10,-1,7,6,10,7,10,8,5,4,10,4,8,10,-1,-1,-1,-1,6,9,5,6,11,9,11,8,9,-1,-1,-1,-1,-1,-1,-1,3,6,11,0,6,3,0,5,6,0,9,5,-1,-1,-1,-1,0,11,8,0,5,11,0,1,5,5,6,11,-1,-1,-1,-1,6,11,3,6,3,5,5,3,1,-1,-1,-1,-1,-1,-1,-1,1,2,10,9,5,11,9,11,8,11,5,6,-1,-1,-1,-1,0,11,3,0,6,11,0,9,6,5,6,9,1,2,10,-1,11,8,5,11,5,6,8,0,5,10,5,2,0,2,5,-1,6,11,3,6,3,5,2,10,3,10,5,3,-1,-1,-1,-1,5,8,9,5,2,8,5,6,2,3,8,2,-1,-1,-1,-1,9,5,6,9,6,0,0,6,2,-1,-1,-1,-1,-1,-1,-1,1,5,8,1,8,0,5,6,8,3,8,2,6,2,8,-1,1,5,6,2,1,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,3,6,1,6,10,3,8,6,5,6,9,8,9,6,-1,10,1,0,10,0,6,9,5,0,5,6,0,-1,-1,-1,-1,0,3,8,5,6,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,10,5,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,5,10,7,5,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,5,10,11,7,5,8,3,0,-1,-1,-1,-1,-1,-1,-1,5,11,7,5,10,11,1,9,0,-1,-1,-1,-1,-1,-1,-1,10,7,5,10,11,7,9,8,1,8,3,1,-1,-1,-1,-1,11,1,2,11,7,1,7,5,1,-1,-1,-1,-1,-1,-1,-1,0,8,3,1,2,7,1,7,5,7,2,11,-1,-1,-1,-1,9,7,5,9,2,7,9,0,2,2,11,7,-1,-1,-1,-1,7,5,2,7,2,11,5,9,2,3,2,8,9,8,2,-1,2,5,10,2,3,5,3,7,5,-1,-1,-1,-1,-1,-1,-1,8,2,0,8,5,2,8,7,5,10,2,5,-1,-1,-1,-1,9,0,1,5,10,3,5,3,7,3,10,2,-1,-1,-1,-1,9,8,2,9,2,1,8,7,2,10,2,5,7,5,2,-1,1,3,5,3,7,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,7,0,7,1,1,7,5,-1,-1,-1,-1,-1,-1,-1,9,0,3,9,3,5,5,3,7,-1,-1,-1,-1,-1,-1,-1,9,8,7,5,9,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5,8,4,5,10,8,10,11,8,-1,-1,-1,-1,-1,-1,-1,5,0,4,5,11,0,5,10,11,11,3,0,-1,-1,-1,-1,0,1,9,8,4,10,8,10,11,10,4,5,-1,-1,-1,-1,10,11,4,10,4,5,11,3,4,9,4,1,3,1,4,-1,2,5,1,2,8,5,2,11,8,4,5,8,-1,-1,-1,-1,0,4,11,0,11,3,4,5,11,2,11,1,5,1,11,-1,0,2,5,0,5,9,2,11,5,4,5,8,11,8,5,-1,9,4,5,2,11,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,5,10,3,5,2,3,4,5,3,8,4,-1,-1,-1,-1,5,10,2,5,2,4,4,2,0,-1,-1,-1,-1,-1,-1,-1,3,10,2,3,5,10,3,8,5,4,5,8,0,1,9,-1,5,10,2,5,2,4,1,9,2,9,4,2,-1,-1,-1,-1,8,4,5,8,5,3,3,5,1,-1,-1,-1,-1,-1,-1,-1,0,4,5,1,0,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,4,5,8,5,3,9,0,5,0,3,5,-1,-1,-1,-1,9,4,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,11,7,4,9,11,9,10,11,-1,-1,-1,-1,-1,-1,-1,0,8,3,4,9,7,9,11,7,9,10,11,-1,-1,-1,-1,1,10,11,1,11,4,1,4,0,7,4,11,-1,-1,-1,-1,3,1,4,3,4,8,1,10,4,7,4,11,10,11,4,-1,4,11,7,9,11,4,9,2,11,9,1,2,-1,-1,-1,-1,9,7,4,9,11,7,9,1,11,2,11,1,0,8,3,-1,11,7,4,11,4,2,2,4,0,-1,-1,-1,-1,-1,-1,-1,11,7,4,11,4,2,8,3,4,3,2,4,-1,-1,-1,-1,2,9,10,2,7,9,2,3,7,7,4,9,-1,-1,-1,-1,9,10,7,9,7,4,10,2,7,8,7,0,2,0,7,-1,3,7,10,3,10,2,7,4,10,1,10,0,4,0,10,-1,1,10,2,8,7,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,9,1,4,1,7,7,1,3,-1,-1,-1,-1,-1,-1,-1,4,9,1,4,1,7,0,8,1,8,7,1,-1,-1,-1,-1,4,0,3,7,4,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,8,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,10,8,10,11,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,9,3,9,11,11,9,10,-1,-1,-1,-1,-1,-1,-1,0,1,10,0,10,8,8,10,11,-1,-1,-1,-1,-1,-1,-1,3,1,10,11,3,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,11,1,11,9,9,11,8,-1,-1,-1,-1,-1,-1,-1,3,0,9,3,9,11,1,2,9,2,11,9,-1,-1,-1,-1,0,2,11,8,0,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,2,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,8,2,8,10,10,8,9,-1,-1,-1,-1,-1,-1,-1,9,10,2,0,9,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,8,2,8,10,0,1,8,1,10,8,-1,-1,-1,-1,1,10,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,3,8,9,1,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,9,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,3,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1])}function Bg(){return[[0,4,4,4,2,0,0,0,2,2,0,0],[4,0,4,4,0,8,0,0,0,8,8,0],[4,4,0,4,0,0,8,0,0,0,8,8],[4,4,4,0,0,0,0,1,1,0,0,1],[2,0,0,0,0,8,8,8,2,2,0,0],[0,8,0,0,8,0,8,8,0,8,8,0],[0,0,8,0,8,8,0,8,0,0,8,8],[0,0,0,1,8,8,8,0,1,0,0,1],[2,0,0,1,2,0,0,1,0,2,0,1],[2,8,0,0,2,8,0,0,2,0,8,0],[0,8,8,0,0,8,8,0,0,8,0,8],[0,0,8,1,0,0,8,1,1,0,8,0]]}function Fg(t,e,i,r,n){var o,a,s,c,u,h,l,p=0,d=!1,f=!1,m=!1,g=e*i*r,v=e,y=e*i,b=new Int32Array(12),x=[],_=[],w=[],S=[],A=kg(),M=Ng(),P=[[0,4,4,4,2,0,0,0,2,2,0,0],[4,0,4,4,0,8,0,0,0,8,8,0],[4,4,0,4,0,0,8,0,0,0,8,8],[4,4,4,0,0,0,0,1,1,0,0,1],[2,0,0,0,0,8,8,8,2,2,0,0],[0,8,0,0,8,0,8,8,0,8,8,0],[0,0,8,0,8,8,0,8,0,0,8,8],[0,0,0,1,8,8,8,0,1,0,0,1],[2,0,0,1,2,0,0,1,0,2,0,1],[2,8,0,0,2,8,0,0,2,0,8,0],[0,8,8,0,0,8,8,0,0,8,0,8],[0,0,8,1,0,0,8,1,1,0,8,0]];function T(t,e,i){return t+(e-t)*i}function E(t,n,o){return y*(o=(o+l)%r)+v*(n=(n+h)%i)+(t=(t+u)%e)}function C(t,e,i,r,c,u,h){var l=f?3*t:t;if(a[l]<0){var m=(p-u)/(h-u),g=o,v=3*s;if(x[v+0]=i+m,x[v+1]=r,x[v+2]=c,!d){var y=3*t;_[v]=-T(g[y],g[y+3],m),_[v+1]=-T(g[y+1],g[y+4],m),_[v+2]=-T(g[y+2],g[y+5],m)}n&&(S[s]=n[t+Math.round(m)]),a[l]=s,b[e]=s,s+=1}else b[e]=a[l]}function I(t,e,i,r,c,u,h){var l=f?3*t+1:t;if(a[l]<0){var m=(p-u)/(h-u),g=o,y=3*s;if(x[y]=i,x[y+1]=r+m,x[y+2]=c,!d){var w=3*t,A=w+3*v;_[y]=-T(g[w],g[A],m),_[y+1]=-T(g[w+1],g[A+1],m),_[y+2]=-T(g[w+2],g[A+2],m)}n&&(S[s]=n[t+Math.round(m)*v]),a[l]=s,b[e]=s,s+=1}else b[e]=a[l]}function R(t,e,i,r,c,u,h){var l=f?3*t+2:t;if(a[l]<0){var m=(p-u)/(h-u),g=o,v=3*s;if(x[v]=i,x[v+1]=r,x[v+2]=c+m,!d){var w=3*t,A=w+3*y;_[v]=-T(g[w],g[A],m),_[v+1]=-T(g[w+1],g[A+1],m),_[v+2]=-T(g[w+2],g[A+2],m)}n&&(S[s]=n[t+Math.round(m)*y]),a[l]=s,b[e]=s,s+=1}else b[e]=a[l]}function L(e){var i=3*e;0===o[i]&&(o[i]=t[(e-1+g)%g]-t[(e+1)%g],o[i+1]=t[(e-v+g)%g]-t[(e+v)%g],o[i+2]=t[(e-y+g)%g]-t[(e+y)%g])}function O(e,i,r,n,o){var a,s,u,h,l,g,x;m?(n=E(e,i,r),a=E(e+1,i,r),s=E(e,i+1,r),u=E(e,i,r+1),h=E(e+1,i+1,r),l=E(e+1,i,r+1),g=E(e,i+1,r+1),x=E(e+1,i+1,r+1)):(a=n+1,h=(s=n+v)+1,l=(u=n+y)+1,x=(g=s+y)+1);var _=0,S=t[n],T=t[a],O=t[s],D=t[h],k=t[u],N=t[l],B=t[g],F=t[x];S<p&&(_|=1),T<p&&(_|=2),O<p&&(_|=8),D<p&&(_|=4),k<p&&(_|=16),N<p&&(_|=32),B<p&&(_|=128),F<p&&(_|=64);var z=A[_];if(0===z)return 0;var U=e+1,j=i+1,G=r+1;1&z&&(d||(L(n),L(a)),C(n,0,e,i,r,S,T)),2&z&&(d||(L(a),L(h)),I(a,1,U,i,r,T,D)),4&z&&(d||(L(s),L(h)),C(s,2,e,j,r,O,D)),8&z&&(d||(L(n),L(s)),I(n,3,e,i,r,S,O)),16&z&&(d||(L(u),L(l)),C(u,4,e,i,G,k,N)),32&z&&(d||(L(l),L(x)),I(l,5,U,i,G,N,F)),64&z&&(d||(L(g),L(x)),C(g,6,e,j,G,B,F)),128&z&&(d||(L(u),L(g)),I(u,7,e,i,G,k,B)),256&z&&(d||(L(n),L(u)),R(n,8,e,i,r,S,k)),512&z&&(d||(L(a),L(l)),R(a,9,U,i,r,T,N)),1024&z&&(d||(L(h),L(x)),R(h,10,U,j,r,D,F)),2048&z&&(d||(L(s),L(g)),R(s,11,e,j,r,O,B));for(var V,H,$,W=_<<4,X=0;-1!==M[W+X];)V=M[W+X],H=M[W+X+1],$=M[W+X+2],f?(P[V][H]&o&&(w[c++]=b[V],w[c++]=b[H]),P[H][$]&o&&(w[c++]=b[H],w[c++]=b[$]),P[V][$]&o&&(w[c++]=b[V],w[c++]=b[$])):(w[c++]=b[H],w[c++]=b[V],w[c++]=b[$]),X+=3}function D(n,o,s,c,u,h){var l,g,b,x,_,w,S,A,M,P,T,C,I;if(n=void 0!==n?n:0,o=void 0!==o?o:0,s=void 0!==s?s:0,c=void 0!==c?c:e-1,u=void 0!==u?u:i-1,h=void 0!==h?h:r-1,m||(d?(n=Math.max(0,n),o=Math.max(0,o),s=Math.max(0,s),c=Math.min(e-1,c),u=Math.min(i-1,u),h=Math.min(r-1,h)):(n=Math.max(1,n),o=Math.max(1,o),s=Math.max(1,s),c=Math.min(e-2,c),u=Math.min(i-2,u),h=Math.min(r-2,h))),m)for(A=n-2,M=o-2,T=c+2,C=u+2,I=h+2,_=P=s-2;_<I;++_)for(x=M;x<C;++x)for(b=A;b<T;++b)f?(g=3*E(b,x,_),a[g]=-1,a[g+1]=-1,a[g+2]=-1):(l=E(b,x,_),a[l]=-1);else for(A=Math.max(0,n-2),M=Math.max(0,o-2),P=Math.max(0,s-2),T=Math.min(e,c+2),C=Math.min(i,u+2),I=Math.min(r,h+2),_=P;_<I;++_)for(S=y*_,x=M;x<C;++x)for(w=S+v*x,b=A;b<T;++b)f?(a[l=3*(w+b)]=-1,a[l+1]=-1,a[l+2]=-1):a[l=w+b]=-1;if(!m){var R,L=n,D=o,k=s,N=c,B=u,F=h;for(R=!1,_=s;_<h;++_){for(x=o;x<u;++x){for(b=n;b<c;++b)if(t[l=e*i*_+e*x+b]>=p){k=_,R=!0;break}if(R)break}if(R)break}for(R=!1,x=o;x<u;++x){for(_=k;_<h;++_){for(b=n;b<c;++b)if(t[l=e*i*_+e*x+b]>=p){D=x,R=!0;break}if(R)break}if(R)break}for(R=!1,b=n;b<c;++b){for(x=D;x<u;++x){for(_=k;_<h;++_)if(t[l=e*i*_+e*x+b]>=p){L=b,R=!0;break}if(R)break}if(R)break}for(R=!1,_=h;_>=s;--_){for(x=u;x>=o;--x){for(b=c;b>=n;--b)if(t[l=e*i*_+e*x+b]>=p){F=_,R=!0;break}if(R)break}if(R)break}for(R=!1,x=u;x>=o;--x){for(_=F;_>=s;--_){for(b=c;b>=n;--b)if(t[l=e*i*_+e*x+b]>=p){B=x,R=!0;break}if(R)break}if(R)break}for(R=!1,b=c;b>=n;--b){for(x=B;x>=o;--x){for(_=F;_>=s;--_)if(t[l=e*i*_+e*x+b]>=p){N=b,R=!0;break}if(R)break}if(R)break}d?(n=Math.max(0,L-1),o=Math.max(0,D-1),s=Math.max(0,k-1),c=Math.min(e-1,N+1),u=Math.min(i-1,B+1),h=Math.min(r-1,F+1)):(n=Math.max(1,L-1),o=Math.max(1,D-1),s=Math.max(1,k-1),c=Math.min(e-2,N+1),u=Math.min(i-2,B+1),h=Math.min(r-2,F+1))}var z=15;for(_=s;_<h;++_,z&=-5)for(S=y*_,z|=2,x=o;x<u;++x,z&=-3)for(w=S+v*x,z|=1,b=n;b<c;++b,z&=-2)O(b,x,_,l=w+b,z)}this.triangulate=function(t,v,y,b,A){p=t,f=b,m=A,(d=v||f)||o||(o=new Float32Array(3*g));var M=f?3*g:g;if(a&&a.length===M||(a=new Int32Array(M)),s=0,c=0,void 0!==y){var P=y[0].map(Math.round),T=y[1].map(Math.round);u=e*Math.ceil(Math.abs(P[0])/e),h=i*Math.ceil(Math.abs(P[1])/i),l=r*Math.ceil(Math.abs(P[2])/r),D(P[0],P[1],P[2],T[0],T[1],T[2])}else u=h=l=0,D();return x.length=3*s,d||(_.length=3*s),w.length=c,n&&(S.length=s),{position:new Float32Array(x),normal:d?void 0:new Float32Array(_),index:Rh(w,x.length/3),atomindex:n?new Int32Array(S):void 0,contour:f}}}ap.add("arrow",dg),ap.add("box",Sg),ap.add("cone",yg),ap.add("cylinder",pg),ap.add("ellipsoid",_g),ap.add("octahedron",wg),ap.add("sphere",Pg),ap.add("tetrahedron",Eg),ap.add("torus",Cg),ap.add("point",Og),ap.add("wideline",Dg),Fg.__deps=[kg,Ng,Bg,Rh];var zg=function(t,e){this.cols=t,this.rows=e,this.size=this.cols*this.rows,this.data=new Float32Array(this.size)};function Ug(t,e){for(var i=0,r=0,n=e.rows,o=e.cols,a=0,s=0,c=0,u=e.data,h=t.data;i<n;s+=1,a+=o,i++)for(c=s,r=0;r<o;c+=n,r++)h[c]=u[a+r]}function jg(t,e,i){for(var r=0,n=0,o=0,a=0,s=0,c=0,u=0,h=e.cols,l=e.rows,p=i.rows,d=e.data,f=i.data,m=t.data,g=0;r<l;a+=h,r++)for(c=0,n=0;n<p;u++,n++){for(s=a,g=0,o=0;o<h;s++,c++,o++)g+=d[s]*f[c];m[u]=g}}function Gg(t,e,i){var r=t.data,n=e.data,o=i.data,a=n[0],s=n[1],c=n[2],u=n[3],h=n[4],l=n[5],p=n[6],d=n[7],f=n[8],m=o[0],g=o[1],v=o[2],y=o[3],b=o[4],x=o[5],_=o[6],w=o[7],S=o[8];r[0]=a*m+s*y+c*_,r[1]=a*g+s*b+c*w,r[2]=a*v+s*x+c*S,r[3]=u*m+h*y+l*_,r[4]=u*g+h*b+l*w,r[5]=u*v+h*x+l*S,r[6]=p*m+d*y+f*_,r[7]=p*g+d*b+f*w,r[8]=p*v+d*x+f*S}function Vg(t){for(var e=t.rows,i=t.cols,r=t.data,n=new Array(i),o=0;o<i;++o)n[o]=0;for(var a=0,s=0;a<e;++a)for(var c=0;c<i;++c,++s)n[c]+=r[s];for(var u=0;u<i;++u)n[u]/=e;return n}function Hg(t,e){for(var i=t.rows,r=t.cols,n=t.data,o=0,a=0;o<i;++o)for(var s=0;s<r;++s,++a)n[a]-=e[s]}function $g(t,e,i,r){r=t[e],t[e]=t[i],t[i]=r}zg.prototype.copyTo=function(t){t.data.set(this.data)};var Wg=1.192092896e-7,Xg=1e-37;function qg(t,e,i,r){var n=0,o=0,a=t.rows,s=t.cols,c=a,u=s;c<u&&(n=1,o=c,c=u,u=o);var h=new zg(c,c),l=new zg(1,u),p=new zg(u,u);if(0===n)Ug(h,t);else{for(o=0;o<s*a;o++)h.data[o]=t.data[o];for(;o<u*c;o++)h.data[o]=0}if(function(t,e,i,r,n,o,a,s){for(var c,u,h=2*Wg,l=Xg,p=0,d=0,f=0,m=0,g=Math.max(o,30),v=0,y=0,b=0,x=0,_=0,w=0,S=0,A=0,M=0,P=0,T=0,E=0,C=0,I=0,R=0,L=0,O=0,D=4660,k=0,N=0,B=0,F=new Float64Array(a<<3);p<a;p++){for(f=0,T=0;f<o;f++)T+=(A=t[p*e+f])*A;if(F[p]=T,r){for(f=0;f<a;f++)r[p*n+f]=0;r[p*n+p]=1}}for(;m<g;m++){for(_=0,p=0;p<a-1;p++)for(d=p+1;d<a;d++){for(v=p*e|0,y=d*e|0,R=F[p],L=0,O=F[d],f=2,L+=t[v]*t[y],L+=t[v+1]*t[y+1];f<o;f++)L+=t[v+f]*t[y+f];if(!(Math.abs(L)<=h*Math.sqrt(R*O))){for(c=L*=2,u=E=R-O,C=(c=Math.abs(c))>(u=Math.abs(u))?(u/=c,c*Math.sqrt(1+u*u)):u>0?(c/=u,u*Math.sqrt(1+c*c)):0,E<0?(I=.5*(C-E),w=L/(C*(S=Math.sqrt(I/C))*2)):S=L/(C*(w=Math.sqrt((C+E)/(2*C)))*2),R=0,O=0,f=2,M=w*t[v]+S*t[y],P=-S*t[v]+w*t[y],t[v]=M,t[y]=P,R+=M*M,O+=P*P,M=w*t[v+1]+S*t[y+1],P=-S*t[v+1]+w*t[y+1],t[v+1]=M,t[y+1]=P,R+=M*M,O+=P*P;f<o;f++)M=w*t[v+f]+S*t[y+f],P=-S*t[v+f]+w*t[y+f],t[v+f]=M,t[y+f]=P,R+=M*M,O+=P*P;if(F[p]=R,F[d]=O,_=1,r)for(x=d*n|0,f=2,M=w*r[b=p*n|0]+S*r[x],P=-S*r[b]+w*r[x],r[b]=M,r[x]=P,M=w*r[b+1]+S*r[x+1],P=-S*r[b+1]+w*r[x+1],r[b+1]=M,r[x+1]=P;f<a;f++)M=w*r[b+f]+S*r[x+f],P=-S*r[b+f]+w*r[x+f],r[b+f]=M,r[x+f]=P}}if(0===_)break}for(p=0;p<a;p++){for(f=0,T=0;f<o;f++)T+=(A=t[p*e+f])*A;F[p]=Math.sqrt(T)}for(p=0;p<a-1;p++){for(d=p,f=p+1;f<a;f++)F[d]<F[f]&&(d=f);if(p!==d&&($g(F,p,d,T),r)){for(f=0;f<o;f++)$g(t,p*e+f,d*e+f,A);for(f=0;f<a;f++)$g(r,p*n+f,d*n+f,A)}}for(p=0;p<a;p++)i[p]=F[p];if(r)for(p=0;p<s;p++){for(T=p<a?F[p]:0;T<=l;){for(N=1/o,f=0;f<o;f++)k=0!=(256&(D=214013*D+2531011)>>16)?N:-N,t[p*e+f]=k;for(m=0;m<2;m++)for(d=0;d<p;d++){for(T=0,f=0;f<o;f++)T+=t[p*e+f]*t[d*e+f];for(B=0,f=0;f<o;f++)A=t[p*e+f]-T*t[d*e+f],t[p*e+f]=A,B+=Math.abs(A);for(B=B?1/B:0,f=0;f<o;f++)t[p*e+f]*=B}for(T=0,f=0;f<o;f++)T+=(A=t[p*e+f])*A;T=Math.sqrt(T)}for(S=1/T,f=0;f<o;f++)t[p*e+f]*=S}}(h.data,c,l.data,p.data,u,c,u,c),e){for(o=0;o<u;o++)e.data[o]=l.data[o];for(;o<s;o++)e.data[o]=0}0===n?(i&&Ug(i,h),r&&Ug(r,p)):(i&&Ug(i,p),r&&Ug(r,h))}function Yg(){return new Float32Array([1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1])}function Zg(t,e,i,r,n,o,a,s,c,u,h,l,p,d,f,m,g){t[0]=e,t[4]=i,t[8]=r,t[12]=n,t[1]=o,t[5]=a,t[9]=s,t[13]=c,t[2]=u,t[6]=h,t[10]=l,t[14]=p,t[3]=d,t[7]=f,t[11]=m,t[15]=g}function Kg(t,e,i){var r=e[0],n=e[4],o=e[8],a=e[12],s=e[1],c=e[5],u=e[9],h=e[13],l=e[2],p=e[6],d=e[10],f=e[14],m=e[3],g=e[7],v=e[11],y=e[15],b=i[0],x=i[4],_=i[8],w=i[12],S=i[1],A=i[5],M=i[9],P=i[13],T=i[2],E=i[6],C=i[10],I=i[14],R=i[3],L=i[7],O=i[11],D=i[15];t[0]=r*b+n*S+o*T+a*R,t[4]=r*x+n*A+o*E+a*L,t[8]=r*_+n*M+o*C+a*O,t[12]=r*w+n*P+o*I+a*D,t[1]=s*b+c*S+u*T+h*R,t[5]=s*x+c*A+u*E+h*L,t[9]=s*_+c*M+u*C+h*O,t[13]=s*w+c*P+u*I+h*D,t[2]=l*b+p*S+d*T+f*R,t[6]=l*x+p*A+d*E+f*L,t[10]=l*_+p*M+d*C+f*O,t[14]=l*w+p*P+d*I+f*D,t[3]=m*b+g*S+v*T+y*R,t[7]=m*x+g*A+v*E+y*L,t[11]=m*_+g*M+v*C+y*O,t[15]=m*w+g*P+v*I+y*D}function Jg(t,e,i,r){Zg(t,e,0,0,0,0,i,0,0,0,0,r,0,0,0,0,1)}function Qg(t,e,i,r){Zg(t,1,0,0,e,0,1,0,i,0,0,1,r,0,0,0,1)}function tv(t,e){var i=Math.cos(e),r=Math.sin(e);Zg(t,i,0,r,0,0,1,0,0,-r,0,i,0,0,0,0,1)}function ev(){return new Float32Array([1,0,0,0,1,0,0,0,1])}function iv(t,e){var i=mf([e[0],e[1],e[2]]),r=mf([e[4],e[5],e[6]]),n=mf([e[8],e[9],e[10]]),o=mf();gf(o,r,n),t[0]=o[0],t[1]=o[1],t[2]=o[2],gf(o,n,i),t[3]=o[0],t[4]=o[1],t[5]=o[2],gf(o,i,r),t[6]=o[0],t[7]=o[1],t[8]=o[2]}function rv(t,e,i,r){i=i||1,r=r||!0;var n,o=t.length/3,a=e.length/3;r&&(n=new Float32Array(3*o));var s,c,u,h,l=new Float32Array(3*o),p=new Array(20);for(s=0;s<20;++s)p[s]=new Uint32Array(o);for(s=0;s<o;++s)p[0][s]=0;for(s=0;s<a;++s){var d=3*s,f=3*s+1,m=3*s+2;for(h=!0,c=0,u=p[0][e[d]];c<u;++c)if(e[f]===p[c+1][e[d]]){h=!1;break}for(h&&(p[0][e[d]]++,p[p[0][e[d]]][e[d]]=e[f]),h=!0,c=0,u=p[0][e[d]];c<u;++c)if(e[m]===p[c+1][e[d]]){h=!1;break}for(h&&(p[0][e[d]]++,p[p[0][e[d]]][e[d]]=e[m]),h=!0,c=0,u=p[0][e[f]];c<u;++c)if(e[d]===p[c+1][e[f]]){h=!1;break}for(h&&(p[0][e[f]]++,p[p[0][e[f]]][e[f]]=e[d]),h=!0,c=0,u=p[0][e[f]];c<u;++c)if(e[m]===p[c+1][e[f]]){h=!1;break}for(h&&(p[0][e[f]]++,p[p[0][e[f]]][e[f]]=e[m]),h=!0,c=0;c<p[0][e[m]];++c)if(e[d]===p[c+1][e[m]]){h=!1;break}for(h&&(p[0][e[m]]++,p[p[0][e[m]]][e[m]]=e[d]),h=!0,c=0,u=p[0][e[m]];c<u;++c)if(e[f]===p[c+1][e[m]]){h=!1;break}h&&(p[0][e[m]]++,p[p[0][e[m]]][e[m]]=e[f])}for(var g,v,y,b,x,_=0;_<i;++_){for(s=0;s<o;++s)if(g=3*s,(y=p[0][s])<3)l[g]=t[g],l[g+1]=t[g+1],l[g+2]=t[g+2];else if(3===y||4===y){for(l[g]=0,l[g+1]=0,l[g+2]=0,c=0;c<y;++c)v=3*p[c+1][s],l[g]+=t[v],l[g+1]+=t[v+1],l[g+2]+=t[v+2];l[g]+=.5*t[g],l[g+1]+=.5*t[g+1],l[g+2]+=.5*t[g+2],x=.5+y,l[g]/=x,l[g+1]/=x,l[g+2]/=x}else{for(l[g]=0,l[g+1]=0,l[g+2]=0,c=0;c<y;++c)v=3*p[c+1][s],l[g]+=t[v],l[g+1]+=t[v+1],l[g+2]+=t[v+2];l[g]+=1*t[g],l[g+1]+=1*t[g+1],l[g+2]+=1*t[g+2],b=1+y,l[g]/=b,l[g+1]/=b,l[g+2]/=b}if(t.set(l),r){nv(t,e,n);var w=3*o;for(g=0;g<w;g+=3)t[g]+=.75/4.5*-1*n[g],t[g+1]+=.75/4.5*-1*n[g+1],t[g+2]+=.75/4.5*-1*n[g+2]}}}function nv(t,e,i){var r,n;if(void 0===i)i=new Float32Array(t.length);else for(r=0,n=i.length;r<n;r++)i[r]=0;var o=new Float32Array(3),a=new Float32Array(3),s=new Float32Array(3),c=new Float32Array(3),u=new Float32Array(3);if(e)for(r=0,n=e.length;r<n;r+=3){var h=3*e[r],l=3*e[r+1],p=3*e[r+2];xf(o,t,h),xf(a,t,l),xf(s,t,p),yf(c,s,a),yf(u,o,a),gf(c,c,u),i[h]+=c[0],i[h+1]+=c[1],i[h+2]+=c[2],i[l]+=c[0],i[l+1]+=c[1],i[l+2]+=c[2],i[p]+=c[0],i[p+1]+=c[1],i[p+2]+=c[2]}else for(r=0,n=t.length;r<n;r+=9)xf(o,t,r),xf(a,t,r+3),xf(s,t,r+6),yf(c,s,a),yf(u,o,a),gf(c,c,u),i[r]=c[0],i[r+1]=c[1],i[r+2]=c[2],i[r+3]=c[0],i[r+4]=c[1],i[r+5]=c[2],i[r+6]=c[0],i[r+7]=c[1],i[r+8]=c[2];return ff(i),i}function ov(t){for(var e={},i=0,r=t.length;i<r;++i)e[t[i]]=!0;return e}function av(t,e,i,r,n){var o=1/r*3;Pf(t,t,n+(o+=i)),Tf(e,e,n+o),Af(t,t,r),Ef(t,t),Sf(t,t,r),Af(e,e,r),Cf(e,e),Sf(e,e,r);var a=new Float32Array(3);yf(a,e,t),Af(a,a,r),Cf(a,a),Tf(a,a,1);var s=256*Math.pow(10,6),c=a[0]*a[1]*a[2]*3;s<=c&&(Af(t,t,r*=Math.pow(s/c,1/3)),Ef(t,t),Sf(t,t,r),Af(e,e,r),Cf(e,e),Sf(e,e,r),yf(a,e,t),Af(a,a,r),Cf(a,a),Tf(a,a,1));var u=new Float32Array(t);If(u,u);var h=Yg(),l=Yg();tv(l,jh(90)),Kg(h,h,l);var p=Yg();Jg(p,-1/r,1/r,1/r),Kg(h,h,p);var d=Yg();return Qg(d,-r*u[2],-r*u[1],-r*u[0]),Kg(h,h,d),{dim:a,tran:u,matrix:h,scaleFactor:r}}Jg.__deps=[Zg],Qg.__deps=[Zg],tv.__deps=[Zg],iv.__deps=[mf,gf],rv.__deps=[nv],nv.__deps=[yf,gf,xf,ff],av.__deps=[jh,Pf,Tf,Sf,Af,Ef,Cf,yf,If,Yg,Kg,Qg,Jg,tv];var sv=function(t,e,i){this.name=t||"",this.path=e||"",this.info={},this.center=new $e,this.boundingBox=new xr,i instanceof an||i instanceof Qn||i instanceof sa?this.fromGeometry(i):i&&(this.set(i.position,i.index,i.normal,i.color,i.atomindex,i.contour),this.boundingBox.setFromArray(i.position),this.boundingBox.getCenter(this.center))},cv={type:{configurable:!0}};function uv(t,e,i,r,n){var o=new Fg(t,e,i,r,n);this.getSurface=function(t,e,i,r,n,a){var s=o.triangulate(t,e,i,n,a);if(e&&!n&&(rv(s.position,s.index,e,!0),s.normal=nv(s.position,s.index)),r&&(pf(r,s.position),s.normal)){var c=ev();iv(c,r),df(c,s.normal)}return s}}cv.type.get=function(){return"Surface"},sv.prototype.set=function(t,e,i,r,n,o){this.position=t,this.index=e,this.normal=i,this.color=r,this.atomindex=n,this.size=t.length/3,this.contour=o},sv.prototype.fromGeometry=function(e){var i,r,n,o;if(t.Debug&&ql.time("GeometrySurface.fromGeometry"),e instanceof an?(e.computeVertexNormals(!0),i=(new Qn).fromGeometry(e)):i=e instanceof Qn?e:e[0],i.boundingBox||i.computeBoundingBox(),this.boundingBox.copy(i.boundingBox),this.boundingBox.getCenter(this.center),i instanceof Qn){var a=i.attributes,s=!!a.normal&&a.normal.array;(!s||0===s[0]&&0===s[1]&&0===s[2])&&i.computeVertexNormals(),r=a.position.array,n=a.index?a.index.array:null,o=a.normal.array}this.set(r,n,o,void 0,void 0),t.Debug&&ql.timeEnd("GeometrySurface.setGeometry")},sv.prototype.getPosition=function(){return this.position},sv.prototype.getColor=function(t){var e=t||{};e.surface=this;var i=this.size,r=new Float32Array(3*i),n=Jl.getScheme(e);if(n.volumeColor||"random"===e.scheme)for(var o=0;o<i;++o)n.volumeColorToArray(o,r,3*o);else if(n.positionColor)for(var a=new $e,s=this.position,c=0;c<i;++c){var u=3*c;a.set(s[u],s[u+1],s[u+2]),n.positionColorToArray(a,r,u)}else if(n.atomColor&&this.atomindex)for(var h=e.structure.getAtomProxy(),l=this.atomindex,p=0;p<i;++p)h.index=l[p],n.atomColorToArray(h,r,3*p);else{var d=new Gi(e.value);Gp(i,d.r,d.g,d.b,r)}return r},sv.prototype.getPicking=function(t){return this.atomindex&&t?new fg(this.atomindex,t):new Tg(Vp(this.size),this)},sv.prototype.getNormal=function(){return this.normal},sv.prototype.getSize=function(t,e){return jp(this.size,t*e)},sv.prototype.getIndex=function(){return this.index},sv.prototype.getFilteredIndex=function(t,e){if(t&&this.atomindex){for(var i=new Rl(t),r=e.getAtomSet(i),n=[],o=this.atomindex,a=this.index,s=a.length,c=this.contour?2:3,u=0,h=0;h<s;h+=c){for(var l=!0,p=0;p<c;p++){var d=o[a[h+p]];if(!r.get(d)){l=!1;break}}if(l)for(var f=0;f<c;f++,u++)n[u]=a[h+f]}return Rh(n,this.position.length/3)}return this.index},sv.prototype.getAtomindex=function(){return this.atomindex},sv.prototype.dispose=function(){},Object.defineProperties(sv.prototype,cv),uv.__deps=[rv,nv,Fg,pf,df,ev,iv],Kl.add("surf",function(t,e){var i=t.data.args,r=t.data.params;if(i&&(self.volsurf=new uv(i[0],i[1],i[2],i[3],i[4])),r){var n=self.volsurf.getSurface(r.isolevel,r.smooth,r.box,r.matrix,r.contour,r.wrap),o=[n.position.buffer,n.index.buffer];n.normal&&o.push(n.normal.buffer),n.atomindex&&o.push(n.atomindex.buffer),e({sd:n,p:r},o)}},[uv]);var hv=function(t,e,i,r,n,o,a){this.name=t,this.path=e,this.matrix=new Ve,this.normalMatrix=new We,this.inverseMatrix=new Ve,this.center=new $e,this.boundingBox=new xr,this.setData(i,r,n,o,a)},lv={type:{configurable:!0},position:{configurable:!0},min:{configurable:!0},max:{configurable:!0},sum:{configurable:!0},mean:{configurable:!0},rms:{configurable:!0}};function pv(t){return"front"===t?$:"back"===t?W:X}lv.type.get=function(){return"Volume"},hv.prototype.setData=function(t,e,i,r,n){this.nx=e||1,this.ny=i||1,this.nz=r||1,this.data=t||new Float32Array(1),this.setAtomindex(n),delete this._position,delete this._min,delete this._max,delete this._mean,delete this._rms,this.worker&&this.worker.terminate()},hv.prototype.setStats=function(t,e,i,r){this._min=t,this._max=e,this._mean=i,this._rms=r},hv.prototype.setMatrix=function(t){this.matrix.copy(t);var e=this.boundingBox,i=this.center,r=this.nx-1,n=this.ny-1,o=this.nz-1;e.makeEmpty(),e.expandByPoint(i.set(r,n,o)),e.expandByPoint(i.set(r,n,0)),e.expandByPoint(i.set(r,0,o)),e.expandByPoint(i.set(r,0,0)),e.expandByPoint(i.set(0,n,o)),e.expandByPoint(i.set(0,0,o)),e.expandByPoint(i.set(0,n,0)),e.expandByPoint(i.set(0,0,0)),e.applyMatrix4(this.matrix),e.getCenter(this.center);var a=this.matrix.elements,s=new $e(a[0],a[1],a[2]),c=new $e(a[4],a[5],a[6]),u=new $e(a[8],a[9],a[10]),h=new $e,l=this.normalMatrix.elements;h.crossVectors(c,u),l[0]=h.x,l[1]=h.y,l[2]=h.z,h.crossVectors(u,s),l[3]=h.x,l[4]=h.y,l[5]=h.z,h.crossVectors(s,c),l[6]=h.x,l[7]=h.y,l[8]=h.z,this.inverseMatrix.getInverse(this.matrix)},hv.prototype.setAtomindex=function(t){this.atomindex=t},hv.prototype.getBox=function(t,e,i){return i||(i=new xr),i.set(t,t),i.expandByScalar(e),i.applyMatrix4(this.inverseMatrix),i.min.round(),i.max.round(),i},hv.prototype._getBox=function(t,e){if(t&&e){this.__box||(this.__box=new xr);var i=this.getBox(t,e,this.__box);return[i.min.toArray(),i.max.toArray()]}},hv.prototype._makeSurface=function(t,e,i){var r=this.name+"@"+e.toPrecision(2),n=new sv(r,"",t);return n.info.isolevel=e,n.info.smooth=i,n.info.volume=this,n},hv.prototype.getSurface=function(t,e,i,r,n,o){t=isNaN(t)?this.getValueForSigma(2):t,e=yh(e,0),void 0===this.volsurf&&(this.volsurf=new uv(this.data,this.nx,this.ny,this.nz,this.atomindex));var a=this._getBox(i,r),s=this.volsurf.getSurface(t,e,a,this.matrix.elements,n,o);return this._makeSurface(s,t,e)},hv.prototype.getSurfaceWorker=function(t,e,i,r,n,o,a){var s=this;if(t=isNaN(t)?this.getValueForSigma(2):t,e=e||0,window.Worker){void 0===this.workerPool&&(this.workerPool=new cf("surf",2));var c={},u=this.workerPool.getNextWorker();0===u.postCount&&(c.args=[this.data,this.nx,this.ny,this.nz,this.atomindex]),c.params={isolevel:t,smooth:e,box:this._getBox(i,r),matrix:this.matrix.elements,contour:n,wrap:o},u.post(c,void 0,function(t){var e=t.data.sd,i=t.data.p;a(s._makeSurface(e,i.isolevel,i.smooth))},function(c){console.warn("Volume.getSurfaceWorker error - trying without worker",c);var u=s.getSurface(t,e,i,r,n,o);a(u)})}else{var h=this.getSurface(t,e,i,r,n,o);a(h)}},hv.prototype.getValueForSigma=function(t){return this.mean+yh(t,2)*this.rms},hv.prototype.getSigmaForValue=function(t){return(yh(t,0)-this.mean)/this.rms},lv.position.get=function(){if(!this._position){for(var t=this.nz,e=this.ny,i=this.nx,r=new Float32Array(i*e*t*3),n=0,o=0;o<t;++o)for(var a=0;a<e;++a)for(var s=0;s<i;++s)r[n+0]=s,r[n+1]=a,r[n+2]=o,n+=3;pf(this.matrix.elements,r),this._position=r}return this._position},hv.prototype.getDataAtomindex=function(){return this.atomindex},hv.prototype.getDataPosition=function(){return this.position},hv.prototype.getDataColor=function(t){var e=t||{};e.volume=this,e.scale=e.scale||"Spectral",e.domain=e.domain||[this.min,this.max];for(var i=Jl.getScheme(e),r=this.position.length/3,n=new Float32Array(3*r),o=0;o<r;++o)i.volumeColorToArray(o,n,3*o);return n},hv.prototype.getDataPicking=function(){var t=Vp(this.position.length/3);return new Rg(t,this)},hv.prototype.getDataSize=function(t,e){var i,r=this.data,n=this.position.length/3;switch(t){case"value":i=new Float32Array(r);break;case"abs-value":i=new Float32Array(r);for(var o=0;o<n;++o)i[o]=Math.abs(i[o]);break;case"value-min":i=new Float32Array(r);for(var a=this.min,s=0;s<n;++s)i[s]-=a;break;case"deviation":i=new Float32Array(r);break;default:i=jp(n,t)}if(1!==e)for(var c=0;c<n;++c)i[c]*=e;return i},lv.min.get=function(){return void 0===this._min&&(this._min=Yp(this.data)),this._min},lv.max.get=function(){return void 0===this._max&&(this._max=qp(this.data)),this._max},lv.sum.get=function(){return void 0===this._sum&&(this._sum=Zp(this.data)),this._sum},lv.mean.get=function(){return void 0===this._mean&&(this._mean=Kp(this.data)),this._mean},lv.rms.get=function(){return void 0===this._rms&&(this._rms=function(t){for(var e=t.length,i=0,r=0;r<e;++r){var n=t[r];i+=n*n}return Math.sqrt(i/e)}(this.data)),this._rms},hv.prototype.clone=function(){var t=new hv(this.name,this.path,this.data,this.nx,this.ny,this.nz,this.atomindex);return t.matrix.copy(this.matrix),t.header=Object.assign({},this.header),t},hv.prototype.dispose=function(){this.workerPool&&this.workerPool.terminate()},Object.defineProperties(hv.prototype,lv),ip.add("shader/Mesh.vert","#define STANDARD\nuniform float clipNear;\nuniform vec3 clipCenter;\n#if defined( NEAR_CLIP ) || defined( RADIUS_CLIP ) || ( !defined( PICKING ) && !defined( NOLIGHT ) )\nvarying vec3 vViewPosition;\n#endif\n#if defined( RADIUS_CLIP )\nvarying vec3 vClipCenter;\n#endif\n#if defined( PICKING )\n#include unpack_color\nattribute float primitiveId;\nvarying vec3 vPickingColor;\n#elif defined( NOLIGHT )\nvarying vec3 vColor;\n#else\n#include color_pars_vertex\n#ifndef FLAT_SHADED\nvarying vec3 vNormal;\n#endif\n#endif\n#include common\nvoid main(){\n#if defined( PICKING )\nvPickingColor = unpackColor( primitiveId );\n#elif defined( NOLIGHT )\nvColor = color;\n#else\n#include color_vertex\n#include beginnormal_vertex\n#include defaultnormal_vertex\n#ifndef FLAT_SHADED\nvNormal = normalize( transformedNormal );\n#endif\n#endif\n#include begin_vertex\n#include project_vertex\n#if defined( NEAR_CLIP ) || defined( RADIUS_CLIP ) || ( !defined( PICKING ) && !defined( NOLIGHT ) )\nvViewPosition = -mvPosition.xyz;\n#endif\n#if defined( RADIUS_CLIP )\nvClipCenter = -( modelViewMatrix * vec4( clipCenter, 1.0 ) ).xyz;\n#endif\n#include nearclip_vertex\n}"),ip.add("shader/Mesh.frag","#define STANDARD\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform vec3 interiorColor;\nuniform float interiorDarkening;\nuniform float roughness;\nuniform float metalness;\nuniform float opacity;\nuniform float clipNear;\nuniform float clipRadius;\n#if defined( NEAR_CLIP ) || defined( RADIUS_CLIP ) || ( !defined( PICKING ) && !defined( NOLIGHT ) )\nvarying vec3 vViewPosition;\n#endif\n#if defined( RADIUS_CLIP )\nvarying vec3 vClipCenter;\n#endif\n#if defined( PICKING )\nuniform float objectId;\nvarying vec3 vPickingColor;\n#elif defined( NOLIGHT )\nvarying vec3 vColor;\n#else\n#ifndef FLAT_SHADED\nvarying vec3 vNormal;\n#endif\n#include common\n#include color_pars_fragment\n#include fog_pars_fragment\n#include bsdfs\n#include lights_pars\n#include lights_physical_pars_fragment\n#endif\nvoid main(){\n#include nearclip_fragment\n#include radiusclip_fragment\n#if defined( PICKING )\nif( opacity < 0.7 )\ndiscard;\ngl_FragColor = vec4( vPickingColor, objectId );\n#elif defined( NOLIGHT )\ngl_FragColor = vec4( vColor, opacity );\n#else\nvec4 diffuseColor = vec4( diffuse, opacity );\nReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\nvec3 totalEmissiveLight = emissive;\n#include color_fragment\n#include roughnessmap_fragment\n#include metalnessmap_fragment\n#include normal_fragment\n#include lights_physical_fragment\n#include lights_template\nvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveLight;\n#include interior_fragment\ngl_FragColor = vec4( outgoingLight, diffuseColor.a );\n#include premultiplied_alpha_fragment\n#include tonemapping_fragment\n#include encodings_fragment\n#include fog_fragment\n#include opaque_back_fragment\n#endif\n}");var dv={f:1,v2:2,v3:3,c:3};function fv(t,e){t.matrix.copy(e),t.matrix.decompose(t.position,t.quaternion,t.scale),t.matrixWorldNeedsUpdate=!0}var mv={opaqueBack:!1,side:"double",opacity:1,depthWrite:!0,clipNear:0,clipRadius:0,clipCenter:new $e,flatShaded:!1,wireframe:!1,roughness:.4,metalness:0,diffuse:16777215,diffuseInterior:!1,useInteriorColor:!1,interiorColor:14540253,interiorDarkening:0,forceTransparent:!1,matrix:new Ve,disablePicking:!1,sortParticles:!1,background:!1},gv={opaqueBack:{updateShader:!0},side:{updateShader:!0,property:!0},opacity:{uniform:!0},depthWrite:{property:!0},clipNear:{updateShader:!0,property:!0},clipRadius:{updateShader:!0,uniform:!0},clipCenter:{uniform:!0},flatShaded:{updateShader:!0},background:{updateShader:!0},wireframe:{updateVisibility:!0},roughness:{uniform:!0},metalness:{uniform:!0},diffuse:{uniform:!0},diffuseInterior:{updateShader:!0},useInteriorColor:{updateShader:!0},interiorColor:{uniform:!0},interiorDarkening:{uniform:!0},matrix:{}},vv=function(t,e){void 0===e&&(e={}),this.parameterTypes=gv,this.geometry=new Qn,this.indexVersion=0,this.wireframeIndexVersion=-1,this.group=new sa,this.wireframeGroup=new sa,this.pickingGroup=new sa,this.vertexShader="",this.fragmentShader="",this.isImpostor=!1,this.isText=!1,this.isSurface=!1,this.isPoint=!1,this.isLine=!1,this.dynamic=!0,this.visible=!0,this.wireframeIndexCount=0,this.parameters=bh(e,this.defaultParameters),this.uniforms=Wi.merge([$i.common,{fogColor:{value:null},fogNear:{value:0},fogFar:{value:0},opacity:{value:this.parameters.opacity},clipNear:{value:0},clipRadius:{value:this.parameters.clipRadius},clipCenter:{value:this.parameters.clipCenter}},{emissive:{value:new Gi(0)},roughness:{value:this.parameters.roughness},metalness:{value:this.parameters.metalness},interiorColor:{value:new Gi(this.parameters.interiorColor)},interiorDarkening:{value:this.parameters.interiorDarkening}},$i.lights]),this.uniforms.diffuse.value.set(this.parameters.diffuse),this.pickingUniforms={clipNear:{value:0},objectId:{value:0},opacity:{value:this.parameters.opacity}};var i=t.position||t.position1;this._positionDataSize=i?i.length/3:0,t.primitiveId||(t.primitiveId=Vp(this._positionDataSize)),this.addAttributes({position:{type:"v3",value:t.position},color:{type:"c",value:t.color},primitiveId:{type:"f",value:t.primitiveId}}),e.matrix&&(this.matrix=e.matrix),t.index&&this.initIndex(t.index),this.picking=t.picking,this.makeWireframeGeometry()},yv={defaultParameters:{configurable:!0},matrix:{configurable:!0},transparent:{configurable:!0},size:{configurable:!0},attributeSize:{configurable:!0},pickable:{configurable:!0}};yv.defaultParameters.get=function(){return mv},yv.matrix.set=function(t){this.setMatrix(t)},yv.matrix.get=function(){return this.group.matrix.clone()},yv.transparent.get=function(){return this.parameters.opacity<1||this.parameters.forceTransparent},yv.size.get=function(){return this._positionDataSize},yv.attributeSize.get=function(){return this.size},yv.pickable.get=function(){return!!this.picking&&!this.parameters.disablePicking},vv.prototype.setMatrix=function(t){fv(this.group,t),fv(this.wireframeGroup,t),fv(this.pickingGroup,t)},vv.prototype.initIndex=function(t){this.geometry.setIndex(new sn(t,1)),this.geometry.getIndex().setDynamic(this.dynamic)},vv.prototype.makeMaterial=function(){var t=pv(this.parameters.side),e=new oo({uniforms:this.uniforms,vertexShader:"",fragmentShader:"",depthTest:!0,transparent:this.transparent,depthWrite:this.parameters.depthWrite,lights:!0,fog:!0,side:t});e.vertexColors=Z,e.extensions.derivatives=this.parameters.flatShaded,e.extensions.fragDepth=this.isImpostor;var i=new oo({uniforms:this.uniforms,vertexShader:"",fragmentShader:"",depthTest:!0,transparent:this.transparent,depthWrite:this.parameters.depthWrite,lights:!1,fog:!0,side:t});i.vertexColors=Z;var r=new oo({uniforms:this.pickingUniforms,vertexShader:"",fragmentShader:"",depthTest:!0,transparent:!1,depthWrite:this.parameters.depthWrite,lights:!1,fog:!1,side:t,blending:K});r.vertexColors=Z,r.extensions.fragDepth=this.isImpostor,e.clipNear=this.parameters.clipNear,i.clipNear=this.parameters.clipNear,r.clipNear=this.parameters.clipNear,this.material=e,this.wireframeMaterial=i,this.pickingMaterial=r,this.updateShader()},vv.prototype.makeWireframeGeometry=function(){this.makeWireframeIndex();var t=this.geometry,e=this.wireframeIndex,i=new Qn;i.attributes=t.attributes,e&&(i.setIndex(new sn(e,1).setDynamic(this.dynamic)),i.setDrawRange(0,this.wireframeIndexCount)),this.wireframeGeometry=i},vv.prototype.makeWireframeIndex=function(){var t=[];function e(e,i){if(e>i){var r=e;e=i,i=r}var n=t[e];return void 0===n?(t[e]=[i],!0):!n.includes(i)&&(n.push(i),!0)}var i=this.geometry,r=i.index;if(this.parameters.wireframe)if(r){var n,o=r.array,a=o.length;if(i.drawRange.count!==1/0&&(a=i.drawRange.count),this.wireframeIndex&&this.wireframeIndex.length>2*a)n=this.wireframeIndex;else n=Rh(2*a,i.attributes.position.count);var s=0;t.length=0;for(var c=0;c<a;c+=3){var u=o[c+0],h=o[c+1],l=o[c+2];e(u,h)&&(n[s+0]=u,n[s+1]=h,s+=2),e(h,l)&&(n[s+0]=h,n[s+1]=l,s+=2),e(l,u)&&(n[s+0]=l,n[s+1]=u,s+=2)}this.wireframeIndex=n,this.wireframeIndexCount=s,this.wireframeIndexVersion=this.indexVersion}else{var p,d=i.attributes.position.count;p=this.wireframeIndex&&this.wireframeIndex.length>2*d?this.wireframeIndex:Rh(2*d,d);for(var f=0,m=0;f<d;f+=3)p[m+0]=f,p[m+1]=f+1,p[m+2]=f+1,p[m+3]=f+2,p[m+4]=f+2,p[m+5]=f,m+=6;this.wireframeIndex=p,this.wireframeIndexCount=2*d,this.wireframeIndexVersion=this.indexVersion}else this.wireframeIndex=new Uint16Array(0),this.wireframeIndexCount=0},vv.prototype.updateWireframeIndex=function(){if(this.wireframeGeometry&&this.wireframeIndex){if(this.wireframeGeometry.setDrawRange(0,1/0),this.wireframeIndexVersion<this.indexVersion&&this.makeWireframeIndex(),this.wireframeIndex.length>this.wireframeGeometry.index.array.length)this.wireframeGeometry.setIndex(new sn(this.wireframeIndex,1).setDynamic(this.dynamic));else{var t=this.wireframeGeometry.getIndex();t.set(this.wireframeIndex),t.needsUpdate=this.wireframeIndexCount>0,t.updateRange.count=this.wireframeIndexCount}this.wireframeGeometry.setDrawRange(0,this.wireframeIndexCount)}},vv.prototype.getRenderOrder=function(){var t=0;return this.isText?t=1:this.transparent&&(t=this.isSurface?3:2),t},vv.prototype._getMesh=function(t){this.material||this.makeMaterial();var e,i=this.geometry,r=this[t];return(e=this.isLine?new ra(i,r):this.isPoint?new aa(i,r):new uo(i,r)).frustumCulled=!1,e.renderOrder=this.getRenderOrder(),e},vv.prototype.getMesh=function(){return this._getMesh("material")},vv.prototype.getWireframeMesh=function(){var t;return this.material||this.makeMaterial(),this.wireframeGeometry||this.makeWireframeGeometry(),(t=new ra(this.wireframeGeometry,this.wireframeMaterial)).frustumCulled=!1,t.renderOrder=this.getRenderOrder(),t},vv.prototype.getPickingMesh=function(){return this._getMesh("pickingMaterial")},vv.prototype.getShader=function(t,e){return Ep(t,this.getDefines(e))},vv.prototype.getVertexShader=function(t){return this.getShader(this.vertexShader,t)},vv.prototype.getFragmentShader=function(t){return this.getShader(this.fragmentShader,t)},vv.prototype.getDefines=function(t){var e={};return this.parameters.clipNear&&(e.NEAR_CLIP=1),this.parameters.clipRadius&&(e.RADIUS_CLIP=1),"picking"===t?e.PICKING=1:(("background"===t||this.parameters.background)&&(e.NOLIGHT=1),this.parameters.flatShaded&&(e.FLAT_SHADED=1),this.parameters.opaqueBack&&(e.OPAQUE_BACK=1),this.parameters.diffuseInterior&&(e.DIFFUSE_INTERIOR=1),this.parameters.useInteriorColor&&(e.USE_INTERIOR_COLOR=1)),e},vv.prototype.getParameters=function(){return this.parameters},vv.prototype.addUniforms=function(t){this.uniforms=Wi.merge([this.uniforms,t]),this.pickingUniforms=Wi.merge([this.pickingUniforms,t])},vv.prototype.addAttributes=function(t){for(var e in t){var i=void 0,r=t[e],n=this.attributeSize*dv[r.type];r.value?(n!==r.value.length&&ql.error("attribute value has wrong length",e),i=r.value):i=Ih("float32",n),this.geometry.addAttribute(e,new sn(i,dv[r.type]).setDynamic(this.dynamic))}},vv.prototype.updateRenderOrder=function(){var t=this.getRenderOrder();function e(e){e.renderOrder=t}this.group.children.forEach(e),this.pickingGroup&&this.pickingGroup.children.forEach(e)},vv.prototype.updateShader=function(){var t=this.material,e=this.wireframeMaterial,i=this.pickingMaterial;t.vertexShader=this.getVertexShader(),t.fragmentShader=this.getFragmentShader(),t.needsUpdate=!0,e.vertexShader=this.getShader("Line.vert"),e.fragmentShader=this.getShader("Line.frag"),e.needsUpdate=!0,i.vertexShader=this.getVertexShader("picking"),i.fragmentShader=this.getFragmentShader("picking"),i.needsUpdate=!0},vv.prototype.setParameters=function(t){var e=t,i=this.parameterTypes,r=this.parameters,n={},o={},a=!1,s=!1;for(var c in e){var u=e[c];void 0!==u&&(r[c]=u,void 0!==i[c]&&(i[c].property&&(!0!==i[c].property?n[i[c].property]=u:n[c]=u),i[c].uniform&&(!0!==i[c].uniform?o[i[c].uniform]=u:o[c]=u),i[c].updateShader&&(a=!0),i[c].updateVisibility&&(s=!0),this.dynamic&&"wireframe"===c&&!0===u&&this.updateWireframeIndex(),"flatShaded"===c&&(this.material.extensions.derivatives=this.parameters.flatShaded||this.isText),"forceTransparent"===c&&(n.transparent=this.transparent),"matrix"===c&&(this.matrix=u)))}this.setProperties(n),this.setUniforms(o),a&&this.updateShader(),s&&this.setVisibility(this.visible)},vv.prototype.setAttributes=function(t){var e=this.geometry,i=e.attributes;for(var r in t)if("picking"!==r){var n=t[r],o=n.length;if("index"===r){var a=e.getIndex();e.setDrawRange(0,1/0),o>a.array.length?e.setIndex(new sn(n,1).setDynamic(this.dynamic)):(a.set(n),a.needsUpdate=o>0,a.updateRange.count=o,e.setDrawRange(0,o)),this.indexVersion++,this.parameters.wireframe&&this.updateWireframeIndex()}else{var s=i[r];o>s.array.length?e.addAttribute(r,new sn(n,s.itemSize).setDynamic(this.dynamic)):(i[r].set(n),i[r].needsUpdate=o>0,i[r].updateRange.count=o)}}},vv.prototype.setUniforms=function(t){if(t){var e=this.material.uniforms,i=this.wireframeMaterial.uniforms,r=this.pickingMaterial.uniforms;for(var n in t)"opacity"===n&&this.setProperties({transparent:this.transparent}),void 0!==e[n]&&(e[n].value.isVector3?e[n].value.copy(t[n]):e[n].value.set?e[n].value.set(t[n]):e[n].value=t[n]),void 0!==i[n]&&(i[n].value.isVector3?i[n].value.copy(t[n]):i[n].value.set?i[n].value.set(t[n]):i[n].value=t[n]),void 0!==r[n]&&(r[n].value.isVector3?r[n].value.copy(t[n]):r[n].value.set?r[n].value.set(t[n]):r[n].value=t[n])}},vv.prototype.setProperties=function(t){if(t){var e=this.material,i=this.wireframeMaterial,r=this.pickingMaterial;for(var n in t){var o=n,a=t[o];"transparent"===o?this.updateRenderOrder():"side"===o&&(a=pv(a)),e[o]=a,i[o]=a,r[o]=a}e.needsUpdate=!0,i.needsUpdate=!0,r.needsUpdate=!0}},vv.prototype.setVisibility=function(t){this.visible=t,this.parameters.wireframe?(this.group.visible=!1,this.wireframeGroup.visible=t,this.pickable&&(this.pickingGroup.visible=!1)):(this.group.visible=t,this.wireframeGroup.visible=!1,this.pickable&&(this.pickingGroup.visible=t))},vv.prototype.dispose=function(){this.material&&this.material.dispose(),this.wireframeMaterial&&this.wireframeMaterial.dispose(),this.pickingMaterial&&this.pickingMaterial.dispose(),this.geometry.dispose(),this.wireframeGeometry&&this.wireframeGeometry.dispose()},Object.defineProperties(vv.prototype,yv);var bv=function(t){function e(e,i){void 0===i&&(i={}),t.call(this,e,i),this.vertexShader="Mesh.vert",this.fragmentShader="Mesh.frag",this.addAttributes({normal:{type:"v3",value:e.normal}}),void 0===e.normal&&this.geometry.computeVertexNormals()}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e}(vv),xv=function(t){function e(){t.apply(this,arguments),this.isSurface=!0}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e}(bv);function _v(t){t.visible=!0}function wv(t){t.visible=!1}var Sv=function(t){this.group=new sa,this.wireframeGroup=new sa,this.pickingGroup=new sa,this.frontMeshes=[],this.backMeshes=[],this.size=t.size,this.side=t.parameters.side,this.visible=t.visible,this.geometry=t.geometry,this.picking=t.picking,this.group=new sa,this.wireframeGroup=new sa,this.pickingGroup=new sa,this.matrix=t.matrix;var e=t,i=new t.constructor({position:new Float32Array(0)});e.makeMaterial(),i.makeMaterial(),i.picking=t.picking,i.geometry=t.geometry,i.wireframeGeometry=t.wireframeGeometry,i.setParameters(t.getParameters()),i.updateShader(),e.setParameters({side:"front"}),i.setParameters({side:"back",opacity:i.parameters.opacity}),this.buffer=t,this.frontBuffer=e,this.backBuffer=i},Av={matrix:{configurable:!0},pickable:{configurable:!0},parameters:{configurable:!0}};Av.matrix.set=function(t){vv.prototype.setMatrix.call(this,t)},Av.matrix.get=function(){return this.group.matrix.clone()},Av.pickable.get=function(){return!!this.picking&&!this.parameters.disablePicking},Av.parameters.get=function(){return this.buffer.parameters},Sv.prototype.getParameters=function(){var t=Object.assign({},this.buffer.parameters);return t.side=this.side,t},Sv.prototype.getMesh=function(t){var e,i;return t?(i=this.backBuffer.getPickingMesh(),e=this.frontBuffer.getPickingMesh()):(i=this.backBuffer.getMesh(),e=this.frontBuffer.getMesh()),this.frontMeshes.push(e),this.backMeshes.push(i),this.setParameters({side:this.side}),(new sa).add(i,e)},Sv.prototype.getWireframeMesh=function(){return this.buffer.getWireframeMesh()},Sv.prototype.getPickingMesh=function(){return this.getMesh(!0)},Sv.prototype.setAttributes=function(t){this.buffer.setAttributes(t)},Sv.prototype.setParameters=function(t){"front"===(t=Object.assign({},t)).side?(this.frontMeshes.forEach(_v),this.backMeshes.forEach(wv)):"back"===t.side?(this.frontMeshes.forEach(wv),this.backMeshes.forEach(_v)):"double"===t.side&&(this.frontMeshes.forEach(_v),this.backMeshes.forEach(_v)),void 0!==t.side&&(this.side=t.side),delete t.side,void 0!==t.matrix&&(this.matrix=t.matrix),delete t.matrix,this.frontBuffer.setParameters(t),void 0!==t.wireframe&&(this.wireframe=t.wireframe,this.setVisibility(this.visible)),delete t.wireframe,this.backBuffer.setParameters(t)},Sv.prototype.setVisibility=function(t){this.visible=t,this.parameters.wireframe?(this.group.visible=!1,this.wireframeGroup.visible=t,this.pickable&&(this.pickingGroup.visible=!1)):(this.group.visible=t,this.wireframeGroup.visible=!1,this.pickable&&(this.pickingGroup.visible=t))},Sv.prototype.dispose=function(){this.frontBuffer.dispose(),this.backBuffer.dispose()},Object.defineProperties(Sv.prototype,Av),ip.add("shader/Line.vert","uniform float clipNear;\nuniform vec3 clipCenter;\nvarying vec3 vViewPosition;\n#if defined( RADIUS_CLIP )\nvarying vec3 vClipCenter;\n#endif\n#include color_pars_vertex\nvoid main(){\n#include color_vertex\n#include begin_vertex\n#include project_vertex\nvViewPosition = -mvPosition.xyz;\n#if defined( RADIUS_CLIP )\nvClipCenter = -( modelViewMatrix * vec4( clipCenter, 1.0 ) ).xyz;\n#endif\n#include nearclip_vertex\n}"),ip.add("shader/Line.frag","uniform float opacity;\nuniform float clipNear;\nuniform float clipRadius;\nvarying vec3 vViewPosition;\n#if defined( RADIUS_CLIP )\nvarying vec3 vClipCenter;\n#endif\n#include common\n#include color_pars_fragment\n#include fog_pars_fragment\nvoid main(){\n#include nearclip_fragment\n#include radiusclip_fragment\ngl_FragColor = vec4( vColor, opacity );\n#include premultiplied_alpha_fragment\n#include tonemapping_fragment\n#include encodings_fragment\n#include fog_fragment\n}");var Mv=function(t){function e(){t.apply(this,arguments),this.isLine=!0,this.vertexShader="Line.vert",this.fragmentShader="Line.frag"}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e}(vv),Pv=function(t){function e(e,i,r){t.call(this,e,i,r),this.type="surface",this.parameters=Object.assign({isolevelType:{type:"select",options:{value:"value",sigma:"sigma"}},isolevel:{type:"number",precision:2,max:1e3,min:-1e3},negateIsolevel:{type:"boolean"},isolevelScroll:{type:"boolean"},smooth:{type:"integer",precision:1,max:10,min:0},background:{type:"boolean",rebuild:!0},opaqueBack:{type:"boolean",buffer:!0},boxSize:{type:"integer",precision:1,max:100,min:0},colorVolume:{type:"hidden"},contour:{type:"boolean",rebuild:!0},useWorker:{type:"boolean",rebuild:!0},wrap:{type:"boolean",rebuild:!0}},this.parameters),e instanceof hv?(this.surface=void 0,this.volume=e):(this.surface=e,this.volume=void 0),this.boxCenter=new $e,this.__boxCenter=new $e,this.box=new xr,this.__box=new xr,this._position=new $e,this.setBox=function(){this._position.copy(i.translationGroup.position).negate(),this._position.equals(this.boxCenter)||this.setParameters({boxCenter:this._position})},this.viewer.signals.ticked.add(this.setBox,this),this.init(r)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.init=function(e){var i=e||{};i.colorScheme=yh(i.colorScheme,"uniform"),i.colorValue=yh(i.colorValue,14540253),this.isolevelType=yh(i.isolevelType,"sigma"),this.isolevel=yh(i.isolevel,2),this.negateIsolevel=yh(i.negateIsolevel,!1),this.isolevelScroll=yh(i.isolevelScroll,!1),this.smooth=yh(i.smooth,0),this.background=yh(i.background,!1),this.opaqueBack=yh(i.opaqueBack,!0),this.boxSize=yh(i.boxSize,0),this.colorVolume=yh(i.colorVolume,void 0),this.contour=yh(i.contour,!1),this.useWorker=yh(i.useWorker,!0),this.wrap=yh(i.wrap,!1),t.prototype.init.call(this,i),this.build()},e.prototype.attach=function(t){var e=this;this.bufferList.forEach(function(t){e.viewer.add(t)}),this.setVisibility(this.visible),t()},e.prototype.prepare=function(t){var e,i=this;if(this.volume)if(e="sigma"===this.isolevelType?this.volume.getValueForSigma(this.isolevel):this.isolevel,this.negateIsolevel&&(e*=-1),!this.surface||this.__isolevel!==e||this.__smooth!==this.smooth||this.__contour!==this.contour||this.__wrap!==this.wrap||this.__boxSize!==this.boxSize||this.boxSize>0&&!this.__boxCenter.equals(this.boxCenter)){this.__isolevel=e,this.__smooth=this.smooth,this.__contour=this.contour,this.__wrap=this.wrap,this.__boxSize=this.boxSize,this.__boxCenter.copy(this.boxCenter),this.__box.copy(this.box);var r=function(e){i.surface=e,t()};this.useWorker?this.volume.getSurfaceWorker(e,this.smooth,this.boxCenter,this.boxSize,this.contour,this.wrap,r):r(this.volume.getSurface(e,this.smooth,this.boxCenter,this.boxSize,this.contour,this.wrap))}else t();else t()},e.prototype.create=function(){var t,e={position:this.surface.getPosition(),color:this.surface.getColor(this.getColorParams()),index:this.surface.getIndex()};if(this.contour)t=new Mv(e,this.getBufferParams({wireframe:!1}));else{e.normal=this.surface.getNormal(),e.picking=this.surface.getPicking();var i=new xv(e,this.getBufferParams({background:this.background,opaqueBack:this.opaqueBack,dullInterior:!1}));t=new Sv(i)}this.bufferList.push(t)},e.prototype.update=function(t){if(0!==this.bufferList.length){var e={};(t=t||{}).position&&(e.position=this.surface.getPosition()),t.color&&(e.color=this.surface.getColor(this.getColorParams())),t.index&&(e.index=this.surface.getIndex()),t.normal&&(e.normal=this.surface.getNormal()),this.bufferList.forEach(function(t){t.setAttributes(e)})}},e.prototype.setParameters=function(e,i,r){return e&&void 0!==e.isolevelType&&this.volume&&("value"===this.isolevelType&&"sigma"===e.isolevelType?this.isolevel=this.volume.getSigmaForValue(this.isolevel):"sigma"===this.isolevelType&&"value"===e.isolevelType&&(this.isolevel=this.volume.getValueForSigma(this.isolevel)),this.isolevelType=e.isolevelType),e&&e.boxCenter&&(this.boxCenter.copy(e.boxCenter),delete e.boxCenter),e&&e.wireframe&&(e.contour||void 0===e.contour&&this.contour)&&(e.wireframe=!1),t.prototype.setParameters.call(this,e,i,r),this.volume&&this.volume.getBox(this.boxCenter,this.boxSize,this.box),e&&void 0!==e.colorVolume&&(i.color=!0),this.surface&&(void 0!==e.isolevel||void 0!==e.negateIsolevel||void 0!==e.smooth||void 0!==e.wrap||void 0!==e.boxSize||this.boxSize>0&&!this.__box.equals(this.box))&&this.build({position:!0,color:!0,index:!0,normal:!this.contour}),this},e.prototype.getColorParams=function(){var e=t.prototype.getColorParams.call(this);return e.volume=this.colorVolume,e},e.prototype.dispose=function(){this.viewer.signals.ticked.remove(this.setBox,this),t.prototype.dispose.call(this)},e}(af),Tv=function(){};Tv.zoomScroll=function(t,e){t.trackballControls.zoom(e)},Tv.clipNearScroll=function(t,e){var i=t.getParameters();t.setParameters({clipNear:i.clipNear+e/10})},Tv.focusScroll=function(t,e){var i=2*t.getParameters().clipNear,r=Math.sign(e)*function(t,e,i){if(t>e)return t;var r=t/e;return((2*i-e)*r+(2*e-3*i))*r*r+i}((100-i)/10,5,.2);t.setFocus(i+r)},Tv.zoomFocusScroll=function(t,e){t.trackballControls.zoom(e);var i=t.viewer.camera.position.z;t.setFocus(100-Math.abs(i/8))},Tv.isolevelScroll=function(t,e){var i=Math.sign(e)/10;t.eachRepresentation(function(t,e){if(t.repr instanceof Pv){var r=t.getParameters();r.isolevelScroll&&t.setParameters({isolevel:r.isolevel+i})}})},Tv.panDrag=function(t,e,i){t.trackballControls.pan(e,i)},Tv.rotateDrag=function(t,e,i){t.trackballControls.rotate(e,i)},Tv.zoomDrag=function(t,e,i){t.trackballControls.zoom((e+i)/-2)},Tv.zoomFocusDrag=function(t,e,i){t.trackballControls.zoom((e+i)/-2);var r=t.viewer.camera.position.z;t.setFocus(100-Math.abs(r/8))},Tv.panComponentDrag=function(t,e,i){t.trackballControls.panComponent(e,i)},Tv.panAtomDrag=function(t,e,i){t.trackballControls.panAtom(e,i)},Tv.rotateComponentDrag=function(t,e,i){t.trackballControls.rotateComponent(e,i)},Tv.movePick=function(t,e){e&&t.animationControls.move(e.position.clone())},Tv.tooltipPick=function(t,e){var i=t.tooltip;if(t.getParameters().tooltip&&e){var r=e.mouse.position;i.innerText=e.getLabel(),i.style.bottom=window.innerHeight-r.y+3+"px",i.style.left=r.x+3+"px",i.style.display="block"}else i.style.display="none"};var Ev={default:[["scroll",Tv.zoomScroll],["scroll-shift",Tv.focusScroll],["scroll-ctrl",Tv.isolevelScroll],["scroll-shift-ctrl",Tv.zoomFocusScroll],["drag-left",Tv.rotateDrag],["drag-right",Tv.panDrag],["drag-ctrl-left",Tv.panDrag],["drag-shift-left",Tv.zoomDrag],["drag-middle",Tv.zoomFocusDrag],["drag-ctrl-shift-right",Tv.panComponentDrag],["drag-ctrl-shift-left",Tv.rotateComponentDrag],["clickPick-right",Tv.measurePick=function(t,e){if(e&&(e.atom||e.bond)){var i=e.atom||e.closestBondAtom;e.component.measurePick(i)}else t.measureClear()}],["clickPick-ctrl-left",Tv.measurePick],["clickPick-middle",Tv.movePick],["clickPick-left",Tv.movePick],["hoverPick",Tv.tooltipPick]],pymol:[["drag-left",Tv.rotateDrag],["drag-middle",Tv.panDrag],["drag-right",Tv.zoomDrag],["drag-shift-right",Tv.focusScroll],["clickPick-ctrl+shift-middle",Tv.movePick],["hoverPick",Tv.tooltipPick]],coot:[["scroll",Tv.isolevelScroll],["drag-left",Tv.rotateDrag],["drag-middle",Tv.panDrag],["drag-ctrl-left",Tv.panDrag],["drag-right",Tv.zoomFocusDrag],["drag-ctrl-right",Tv.focusScroll],["clickPick-middle",Tv.movePick],["hoverPick",Tv.tooltipPick]],astexviewer:[["drag-left",Tv.rotateDrag],["drag-ctrl-left",Tv.panDrag],["drag-shift-left",Tv.zoomDrag],["scroll",Tv.focusScroll],["clickPick-middle",Tv.movePick],["hoverPick",Tv.tooltipPick]]};function Cv(t){var e=t.split(/[-+]/),i="";e.includes("scroll")&&(i="scroll"),e.includes("drag")&&(i="drag"),e.includes("click")&&(i="click"),e.includes("doubleClick")&&(i="doubleClick"),e.includes("hover")&&(i="hover"),e.includes("clickPick")&&(i="clickPick"),e.includes("hoverPick")&&(i="hoverPick");var r=0;e.includes("alt")&&(r+=1),e.includes("ctrl")&&(r+=2),e.includes("meta")&&(r+=4),e.includes("shift")&&(r+=8);var n=0;return e.includes("left")&&(n+=1),e.includes("right")&&(n+=2),e.includes("middle")&&(n+=4),[i,r,n]}var Iv=function(t,e){void 0===e&&(e={}),this.stage=t,this.actionList=[],this.mouse=t.mouseObserver,this.disabled=e.disabled||!1,this.preset(e.preset||"default")};Iv.prototype.run=function(t){for(var e=this,i=[],r=arguments.length-1;r-- >0;)i[r]=arguments[r+1];if(!this.disabled){var n=this.mouse.key||0,o=this.mouse.buttons||0;this.actionList.forEach(function(r){r.type===t&&r.key===n&&r.button===o&&r.callback.apply(r,[e.stage].concat(i))})}},Iv.prototype.add=function(t,e){var i=Cv(t),r=i[0],n=i[1],o=i[2];this.actionList.push({type:r,key:n,button:o,callback:e})},Iv.prototype.remove=function(t,e){var i=t.includes("*"),r=Cv(t),n=r[0],o=r[1],a=r[2],s=this.actionList.filter(function(t){return!((t.type===n||i&&""===n)&&(t.key===o||i&&0===o)&&(t.button===a||i&&0===a)&&(t.callback===e||void 0===e))});this.actionList=s},Iv.prototype.preset=function(t){var e=this;this.clear(),(Ev[t]||[]).forEach(function(t){return e.add(t[0],t[1])})},Iv.prototype.clear=function(){this.actionList.length=0};var Rv=function(){};Rv.autoView=function(t){t.autoView(1e3)},Rv.toggleAnimations=function(t){t.animationControls.toggle()},Rv.toggleRock=function(t){t.toggleRock()};var Lv={default:[["i",Rv.toggleSpin=function(t){t.toggleSpin()}],["k",Rv.toggleRock],["p",Rv.toggleAnimations],["a",Rv.toggleAntialiasing=function(t){var e=t.getParameters();t.setParameters({sampleLevel:-1===e.sampleLevel?0:-1})}],["r",Rv.autoView]]},Ov=function(t,e){void 0===e&&(e={}),this.stage=t,this.actionList=[],this.disabled=e.disabled||!1,this.preset(e.preset||"default")};Ov.prototype.run=function(t){var e=this;this.disabled||this.actionList.forEach(function(i){i.keyCode===t&&i.callback(e.stage)})},Ov.prototype.add=function(t,e){var i=t.charCodeAt(0);this.actionList.push({keyCode:i,callback:e})},Ov.prototype.remove=function(t,e){var i=t.charCodeAt(0),r=this.actionList.filter(function(t){return!(t.keyCode===i&&(t.callback===e||void 0===e))});this.actionList=r},Ov.prototype.preset=function(t){var e=this;this.clear(),(Lv[t]||[]).forEach(function(t){return e.add(t[0],t[1])})},Ov.prototype.clear=function(){this.actionList.length=0};var Dv=function(t){this.stage=t,this.stage=t,this.mouse=t.mouseObserver,this.controls=t.mouseControls,this.mouse.signals.clicked.add(this._onClick,this),this.mouse.signals.hovered.add(this._onHover,this)};Dv.prototype._onClick=function(t,e){var i=this.stage.pickingControls.pick(t,e);this.stage.signals.clicked.dispatch(i),this.controls.run("clickPick",i)},Dv.prototype._onHover=function(t,e){var i=this.stage.pickingControls.pick(t,e);i&&this.mouse.down.equals(this.mouse.position)&&(this.stage.transformComponent=i.component,this.stage.transformAtom=i.atom),this.stage.signals.hovered.dispatch(i),this.controls.run("hoverPick",i)},Dv.prototype.dispose=function(){this.mouse.signals.clicked.remove(this._onClick,this),this.mouse.signals.hovered.remove(this._onHover,this)};var kv=function(t){this.stage=t,this.stage=t,this.mouse=t.mouseObserver,this.controls=t.mouseControls,this.mouse.signals.moved.add(this._onMove,this),this.mouse.signals.scrolled.add(this._onScroll,this),this.mouse.signals.dragged.add(this._onDrag,this),this.mouse.signals.clicked.add(this._onClick,this),this.mouse.signals.hovered.add(this._onHover,this),this.mouse.signals.doubleClicked.add(this._onDblclick,this)};kv.prototype._onMove=function(){this.stage.tooltip.style.display="none"},kv.prototype._onScroll=function(t){this.controls.run("scroll",t)},kv.prototype._onDrag=function(t,e){this.controls.run("drag",t,e)},kv.prototype._onClick=function(t,e){this.controls.run("click",t,e)},kv.prototype._onDblclick=function(t,e){this.controls.run("doubleClick",t,e)},kv.prototype._onHover=function(t,e){this.controls.run("hover",t,e)},kv.prototype.dispose=function(){this.mouse.signals.moved.remove(this._onMove,this),this.mouse.signals.scrolled.remove(this._onScroll,this),this.mouse.signals.dragged.remove(this._onDrag,this),this.mouse.signals.clicked.remove(this._onClick,this),this.mouse.signals.hovered.remove(this._onHover,this)};var Nv=function(t){this.stage=t,this.viewer=t.viewer,this.animationControls=t.animationControls,this.viewer.signals.ticked.add(this._onTick,this)};Nv.prototype._onTick=function(t){this.animationControls.run(t)},Nv.prototype.dispose=function(){this.viewer.signals.ticked.remove(this._onTick,this)};var Bv=!!Gl&&{passive:!0},Fv=function(t){this.stage=t,this.stage=t,this.controls=t.keyControls,this.domElement=t.viewer.renderer.domElement,this.domElement.setAttribute("tabIndex","-1"),this.domElement.style.outline="none",this._focusDomElement=this._focusDomElement.bind(this),this._onKeydown=this._onKeydown.bind(this),this._onKeyup=this._onKeyup.bind(this),this._onKeypress=this._onKeypress.bind(this),this.domElement.addEventListener("mousedown",this._focusDomElement),this.domElement.addEventListener("touchstart",this._focusDomElement,Bv),this.domElement.addEventListener("keydown",this._onKeydown),this.domElement.addEventListener("keyup",this._onKeyup),this.domElement.addEventListener("keypress",this._onKeypress)};Fv.prototype._onKeydown=function(){},Fv.prototype._onKeyup=function(){},Fv.prototype._onKeypress=function(t){this.controls.run(t.keyCode)},Fv.prototype._focusDomElement=function(){this.domElement.focus()},Fv.prototype.dispose=function(){this.domElement.removeEventListener("mousedown",this._focusDomElement),this.domElement.removeEventListener("touchstart",this._focusDomElement,Bv),this.domElement.removeEventListener("keydown",this._onKeypress),this.domElement.removeEventListener("keyup",this._onKeypress),this.domElement.removeEventListener("keypress",this._onKeypress)};var zv=function(t,e,i,r){void 0===r&&(r={}),this.component=t,this.position=e,this.offsetX=yh(r.offsetX,0),this.offsetY=yh(r.offsetY,0),this.visible=yh(r.visible,!0),this.stage=t.stage,this.viewer=t.stage.viewer,this._viewerPosition=new $e,this._updateViewerPosition(),this._canvasPosition=new Ge,this._cameraPosition=new $e,this.element=document.createElement("div"),Object.assign(this.element.style,{display:"block",position:"absolute",pointerEvents:"none",whiteSpace:"nowrap",left:"-10000px"}),this.viewer.wrapper.appendChild(this.element),this.setContent(i),this.updateVisibility(),this.viewer.signals.rendered.add(this._update,this),this.component.signals.matrixChanged.add(this._updateViewerPosition,this)};zv.prototype.setContent=function(t){var e=this.element.style.display;if("none"===e&&(this.element.style.left="-10000px",this.element.style.display="block"),t instanceof HTMLElement)this.element.appendChild(t);else{var i=document.createElement("div");i.innerText=t,Object.assign(i.style,{backgroundColor:"rgba( 0, 0, 0, 0.6 )",color:"lightgrey",padding:"8px",fontFamily:"sans-serif"}),this.element.appendChild(i)}this._clientRect=this.element.getBoundingClientRect(),"none"===e&&(this.element.style.display=e)},zv.prototype.setVisibility=function(t){this.visible=t,this.updateVisibility()},zv.prototype.getVisibility=function(){return this.visible&&this.component.parameters.visible},zv.prototype.updateVisibility=function(){this.element.style.display=this.getVisibility()?"block":"none"},zv.prototype._updateViewerPosition=function(){this._viewerPosition.copy(this.position).applyMatrix4(this.component.matrix)},zv.prototype._update=function(){if(this.getVisibility()){var t=this.element.style,e=this._canvasPosition,i=this._viewerPosition,r=this._clientRect;if(this._cameraPosition.copy(i).add(this.viewer.translationGroup.position).applyMatrix4(this.viewer.rotationGroup.matrix).sub(this.viewer.camera.position),this._cameraPosition.z<0)t.display="none";else{t.display="block";var n=this._cameraPosition.length(),o=this.viewer.scene.fog;t.opacity=(1-Yh(o.near,o.far,n)).toString(),t.zIndex=Math.round(100*(o.far-n)).toString(),this.stage.viewerControls.getPositionOnCanvas(i,e),t.bottom=this.offsetX+e.y+r.height/2+"px",t.left=this.offsetY+e.x-r.width/2+"px"}}},zv.prototype.dispose=function(){this.viewer.wrapper.removeChild(this.element),this.viewer.signals.ticked.remove(this._update,this),this.component.signals.matrixChanged.remove(this._updateViewerPosition,this)};var Uv=new Ve,jv=new $e,Gv=new He,Vv=function(t){this.component=t,this.signals={changed:new nl},this.stage=t.stage,this.viewer=t.stage.viewer},Hv={position:{configurable:!0},rotation:{configurable:!0}};Hv.position.get=function(){return this.component.position},Hv.rotation.get=function(){return this.component.quaternion},Vv.prototype.changed=function(){this.component.updateMatrix(),this.viewer.requestRender(),this.signals.changed.dispatch()},Vv.prototype.spin=function(t,e){Uv.getInverse(this.viewer.rotationGroup.matrix),jv.copy(Dh(t)).applyMatrix4(Uv),Uv.extractRotation(this.component.transform),Uv.premultiply(this.viewer.rotationGroup.matrix),Uv.getInverse(Uv),jv.copy(Dh(t)),jv.applyMatrix4(Uv),Uv.makeRotationAxis(jv,e),Gv.setFromRotationMatrix(Uv),this.component.quaternion.premultiply(Gv),this.changed()},Object.defineProperties(Vv.prototype,Hv);var $v={"":"",vdw:"by vdW radius",covalent:"by covalent radius",sstruc:"by secondary structure",bfactor:"by bfactor",size:"size",data:"data"},Wv=function(t){void 0===t&&(t={}),this.max=10,this.type=yh(t.type,"size"),this.scale=yh(t.scale,1),this.size=yh(t.size,1),this.data=yh(t.data,{})};Wv.prototype.atomRadius=function(t){var e;switch(this.type){case"vdw":e=t.vdw;break;case"covalent":e=t.covalent;break;case"bfactor":e=t.bfactor||1;break;case"sstruc":var i=t.sstruc;e="h"===i?.25:"g"===i?.25:"i"===i?.25:"e"===i?.25:"b"===i?.25:km.includes(t.atomname)?.4:.1;break;case"data":e=yh(this.data[t.index],1);break;default:e=this.size}return Math.min(e*this.scale,this.max)},Wv.types=$v;var Xv=new $e(-1,-1,-1),qv=new Ve,Yv=function(t){var e=t.rows,i=e/3,r=new zg(e,3),n=new zg(3,3),o=new zg(1,3),a=new zg(3,3),s=new zg(3,3),c=Vg(t);Hg(t,c),Ug(r,t),jg(n,r,r),qg(n,o,a,s);var u=new $e(c[0],c[1],c[2]),h=new $e(a.data[0],a.data[3],a.data[6]),l=new $e(a.data[1],a.data[4],a.data[7]),p=new $e(a.data[2],a.data[5],a.data[8]),d=h.clone().multiplyScalar(Math.sqrt(o.data[0]/i)),f=l.clone().multiplyScalar(Math.sqrt(o.data[1]/i)),m=p.clone().multiplyScalar(Math.sqrt(o.data[2]/i));this.begA=u.clone().sub(d),this.endA=u.clone().add(d),this.begB=u.clone().sub(f),this.endB=u.clone().add(f),this.begC=u.clone().sub(m),this.endC=u.clone().add(m),this.center=u,this.vecA=d,this.vecB=f,this.vecC=m,this.normVecA=h,this.normVecB=l,this.normVecC=p};Yv.prototype.getBasisMatrix=function(t){void 0===t&&(t=new Ve);var e=t;return e.makeBasis(this.normVecB,this.normVecA,this.normVecC),e.determinant()<0&&e.scale(Xv),e},Yv.prototype.getRotationQuaternion=function(t){void 0===t&&(t=new He);var e=t;return e.setFromRotationMatrix(this.getBasisMatrix(qv)),e.inverse()},Yv.prototype.getProjectedScaleForAtoms=function(t){var e=-1/0,i=-1/0,r=-1/0,n=-1/0,o=-1/0,a=-1/0,s=new $e,c=new $e,u=this.center,h=this.normVecA,l=this.normVecB,p=this.normVecC;return t.eachAtom(function(t){hf(s.copy(t),h,u);var d=c.subVectors(s,u).normalize().dot(h),f=s.distanceTo(u);d>0?f>e&&(e=f):f>i&&(i=f),hf(s.copy(t),l,u);var m=c.subVectors(s,u).normalize().dot(l),g=s.distanceTo(u);m>0?g>r&&(r=g):g>n&&(n=g),hf(s.copy(t),p,u);var v=c.subVectors(s,u).normalize().dot(p),y=s.distanceTo(u);v>0?y>o&&(o=y):y>a&&(a=y)}),{d1a:e,d2a:r,d3a:o,d1b:-i,d2b:-n,d3b:-a}};var Zv=function(t,e,i,r){this.volume=t,this.setFilter(e,i,r)},Kv={header:{configurable:!0},matrix:{configurable:!0},normalMatrix:{configurable:!0},inverseMatrix:{configurable:!0},center:{configurable:!0},boundingBox:{configurable:!0},min:{configurable:!0},max:{configurable:!0},mean:{configurable:!0},rms:{configurable:!0}};Kv.header.get=function(){return this.volume.header},Kv.matrix.get=function(){return this.volume.matrix},Kv.normalMatrix.get=function(){return this.volume.normalMatrix},Kv.inverseMatrix.get=function(){return this.volume.inverseMatrix},Kv.center.get=function(){return this.volume.center},Kv.boundingBox.get=function(){return this.volume.boundingBox},Kv.min.get=function(){return this.volume.min},Kv.max.get=function(){return this.volume.max},Kv.mean.get=function(){return this.volume.mean},Kv.rms.get=function(){return this.volume.rms},Zv.prototype._getFilterHash=function(t,e,i){return JSON.stringify([t,e,i])},Zv.prototype.setFilter=function(t,e,i){isNaN(t)&&this.header&&(t=this.header.DMEAN+2*this.header.ARMS),t=void 0===t||isNaN(t)?-1/0:t,e=yh(e,1/0),i=yh(i,!1);var r=this.volume.data,n=this.volume.position,o=this.volume.atomindex,a=this._getFilterHash(t,e,i);if(a!==this._filterHash){if(t===-1/0&&e===1/0)this.data=r,this.position=n,this.atomindex=o;else{var s=r.length;this._dataBuffer||(this._dataBuffer=new ArrayBuffer(4*s),this._positionBuffer=new ArrayBuffer(3*s*4),o&&(this._atomindexBuffer=new ArrayBuffer(4*s)));var c,u=new Float32Array(this._dataBuffer),h=new Float32Array(this._positionBuffer);o&&(c=new Uint32Array(this._atomindexBuffer));for(var l=0,p=0;p<s;++p){var d=3*p,f=r[p];if(!i&&f>=t&&f<=e||i&&(f<t||f>e)){var m=3*l;u[l]=f,h[m+0]=n[d+0],h[m+1]=n[d+1],h[m+2]=n[d+2],o&&(c[l]=o[p]),l+=1}}this.data=new Float32Array(this._dataBuffer,0,l),this.position=new Float32Array(this._positionBuffer,0,3*l),o&&(this.atomindex=new Float32Array(this._atomindexBuffer,0,l))}this._filterHash=a}},Object.defineProperties(Zv.prototype,Kv),Zv.prototype.getValueForSigma=hv.prototype.getValueForSigma,Zv.prototype.getSigmaForValue=hv.prototype.getSigmaForValue,Zv.prototype.getDataAtomindex=hv.prototype.getDataAtomindex,Zv.prototype.getDataPosition=hv.prototype.getDataPosition,Zv.prototype.getDataColor=hv.prototype.getDataColor,Zv.prototype.getDataPicking=hv.prototype.getDataPicking,Zv.prototype.getDataSize=hv.prototype.getDataSize;var Jv=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e;var i={_defaultFields:{configurable:!0}};return i._defaultFields.get=function(){return[["atomIndex1",1,"int32"],["atomIndex2",1,"int32"],["bondOrder",1,"int8"]]},e.prototype.addBond=function(t,e,i){this.growIfFull();var r=this.count,n=t.index,o=e.index;n<o?(this.atomIndex1[r]=n,this.atomIndex2[r]=o):(this.atomIndex2[r]=n,this.atomIndex1[r]=o),i&&(this.bondOrder[r]=i),this.count+=1},e.prototype.addBondIfConnected=function(t,e,i){return!!t.connectedTo(e)&&(this.addBond(t,e,i),!0)},Object.defineProperties(e.prototype,i),e}(Zf),Qv=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e;var i={_defaultFields:{configurable:!0}};return i._defaultFields.get=function(){return[["residueIndex",1,"uint32"],["atomTypeId",1,"uint16"],["x",1,"float32"],["y",1,"float32"],["z",1,"float32"],["serial",1,"int32"],["bfactor",1,"float32"],["altloc",1,"uint8"],["occupancy",1,"float32"]]},e.prototype.setAltloc=function(t,e){this.altloc[t]=e.charCodeAt(0)},e.prototype.getAltloc=function(t){var e=this.altloc[t];return e?String.fromCharCode(e):""},Object.defineProperties(e.prototype,i),e}(Zf),ty=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e;var i={_defaultFields:{configurable:!0}};return i._defaultFields.get=function(){return[["chainIndex",1,"uint32"],["atomOffset",1,"uint32"],["atomCount",1,"uint16"],["residueTypeId",1,"uint16"],["resno",1,"int32"],["sstruc",1,"uint8"],["inscode",1,"uint8"]]},e.prototype.setSstruc=function(t,e){this.sstruc[t]=e.charCodeAt(0)},e.prototype.getSstruc=function(t){var e=this.sstruc[t];return e?String.fromCharCode(e):""},e.prototype.setInscode=function(t,e){this.inscode[t]=e.charCodeAt(0)},e.prototype.getInscode=function(t){var e=this.inscode[t];return e?String.fromCharCode(e):""},Object.defineProperties(e.prototype,i),e}(Zf),ey=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e;var i={_defaultFields:{configurable:!0}};return i._defaultFields.get=function(){return[["entityIndex",1,"uint16"],["modelIndex",1,"uint16"],["residueOffset",1,"uint32"],["residueCount",1,"uint32"],["chainname",4,"uint8"],["chainid",4,"uint8"]]},e.prototype.setChainname=function(t,e){var i=4*t;this.chainname[i]=e.charCodeAt(0),this.chainname[i+1]=e.charCodeAt(1),this.chainname[i+2]=e.charCodeAt(2),this.chainname[i+3]=e.charCodeAt(3)},e.prototype.getChainname=function(t){for(var e="",i=0;i<4;++i){var r=this.chainname[4*t+i];if(!r)break;e+=String.fromCharCode(r)}return e},e.prototype.setChainid=function(t,e){var i=4*t;this.chainid[i]=e.charCodeAt(0),this.chainid[i+1]=e.charCodeAt(1),this.chainid[i+2]=e.charCodeAt(2),this.chainid[i+3]=e.charCodeAt(3)},e.prototype.getChainid=function(t){for(var e="",i=0;i<4;++i){var r=this.chainid[4*t+i];if(!r)break;e+=String.fromCharCode(r)}return e},Object.defineProperties(e.prototype,i),e}(Zf),iy=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e;var i={_defaultFields:{configurable:!0}};return i._defaultFields.get=function(){return[["chainOffset",1,"uint32"],["chainCount",1,"uint32"]]},Object.defineProperties(e.prototype,i),e}(Zf),ry=function(t){this.polymer=t,this.size=t.residueCount};ry.prototype.getCenterIterator=function(t){void 0===t&&(t=0);var e=this.getPosition().center,i=e.length/3,r=0,n=-1,o=[new $e,new $e,new $e,new $e];return{size:i,next:function(){var t=this.get(n);return n+=1,t},get:function(n){n=Math.min(i-1,Math.max(0,n));var a=o[r%4],s=3*n;if(a.fromArray(e,s),t){for(var c=Math.min(t,n,i-n-1),u=1;u<=c;++u){var h=3*u,l=(c+1-u)/(c+1);a.x+=l*e[s-h+0]+l*e[s+h+0],a.y+=l*e[s-h+1]+l*e[s+h+1],a.z+=l*e[s-h+2]+l*e[s+h+2]}a.x/=c+1,a.y/=c+1,a.z/=c+1}return r+=1,a},reset:function(){r=0,n=-1}}},ry.prototype.getColor=function(t){var e=this.polymer,i=e.structure,r=e.residueCount,n=e.residueIndexStart,o=new Float32Array(3*r),a=t||{};a.structure=i;for(var s=Jl.getScheme(a),c=i.getResidueProxy(),u=i.getAtomProxy(),h=0;h<r;++h)c.index=n+h,u.index=c.traceAtomIndex,s.atomColorToArray(u,o,3*h);return{color:o}},ry.prototype.getPicking=function(){for(var t=this.polymer,e=t.structure,i=t.residueCount,r=t.residueIndexStart,n=new Float32Array(i),o=e.getResidueProxy(),a=0;a<i;++a)o.index=r+a,n[a]=o.traceAtomIndex;return{picking:new fg(n,e)}},ry.prototype.getSize=function(t){for(var e=this.polymer,i=e.structure,r=e.residueCount,n=e.residueIndexStart,o=new Float32Array(r),a=new Wv(t),s=i.getResidueProxy(),c=i.getAtomProxy(),u=0;u<r;++u)s.index=n+u,c.index=s.traceAtomIndex,o[u]=a.atomRadius(c);return{size:o}},ry.prototype.getPosition=function(){for(var t=this.polymer,e=t.structure,i=t.residueCount,r=i-3,n=new Float32Array(3*i),o=new Float32Array(3*i),a=new Float32Array(i),s=new Float32Array(i),c=new Float32Array(i),u=new Float32Array(i),h=new Float32Array(3*i),l=new $e,p=new $e,d=new $e,f=new $e,m=new $e,g=new $e,v=new $e,y=new $e,b=new $e,x=new $e,_=new $e,w=new $e(0,0,0),S="trace",A=e.getAtomProxy(),M=e.getAtomProxy(t.getAtomIndexByType(0,S)),P=e.getAtomProxy(t.getAtomIndexByType(1,S)),T=e.getAtomProxy(t.getAtomIndexByType(2,S)),E=0;E<r;++E){A.index=M.index,M.index=P.index,P.index=T.index,T.index=t.getAtomIndexByType(E+3,S);var C=3*E;l.subVectors(M,A),p.subVectors(P,M),d.subVectors(T,P),f.subVectors(l,p),m.subVectors(p,d),b.crossVectors(f,m).normalize(),b.toArray(o,C),E>0&&(a[E]=b.angleTo(x));var I=Math.cos(f.angleTo(m));u[E]=180/Math.PI*Math.acos(I);var R=f.length(),L=m.length();s[E]=Math.sqrt(L*R)/Math.max(2,2*(1-I)),c[E]=Math.abs(p.dot(b)),g.copy(f).multiplyScalar(s[E]/R),v.copy(m).multiplyScalar(s[E]/L),g.subVectors(M,g),v.subVectors(P,v),g.toArray(n,C+3),v.toArray(n,C+6),_.subVectors(A,w),_.toArray(h,C),x.copy(b),w.copy(g)}g.fromArray(n,3),v.fromArray(n,6),b.subVectors(g,v).normalize(),A.index=t.getAtomIndexByType(0,S),w.copy(A),y.copy(A),hf(y,b,g),y.toArray(n,0),_.subVectors(w,g),_.toArray(h,0),g.fromArray(n,3*i-6),v.fromArray(n,3*i-9),b.subVectors(g,v).normalize(),A.index=t.getAtomIndexByType(i-1,S),w.copy(A),y.copy(A),hf(y,b,g),y.toArray(n,3*i-3);for(var O=i-3;O<i;++O)g.fromArray(n,3*O),A.index=t.getAtomIndexByType(O,S),w.copy(A),_.subVectors(w,g),_.toArray(h,3*O);var D=new Float32Array(i),k=new Float32Array(i),N=new Float32Array(i),B=new Float32Array(i);D[1]=s[0],k[1]=u[0],N[1]=s[0];for(var F=2;F<i-2;++F)D[F]=.5*(s[F-2]+s[F-1]),k[F]=.5*(u[F-2]+u[F-1]),N[F]=.5*(c[F-2]+c[F-1]),g.fromArray(o,3*(F-2)),v.fromArray(o,3*(F-1)),B[F]=180/Math.PI*Math.acos(Math.cos(g.angleTo(v)));D[i-2]=s[i-4],k[i-2]=u[i-4],N[i-2]=c[i-4];var z=new Float32Array(3*i);Wp(o,z,0,0,3),Wp(o,z,0,3,3);for(var U=2;U<i-2;++U)g.fromArray(o,3*(U-2)),v.fromArray(o,3*(U-1)),b.addVectors(v,g).multiplyScalar(.5).normalize(),b.toArray(z,3*U);return Wp(o,z,3*i-12,3*i-6,3),Wp(o,z,3*i-12,3*i-3,3),{center:n,axis:z,bending:B,radius:D,rise:N,twist:k,resdir:h}};var ny=function(t){this.polymer=t,this.helixorient=new ry(t),this.position=this.helixorient.getPosition()};ny.prototype.getAxis=function(t,e,i,r,n){t=t||30,e=e||2.5,i=void 0!==i&&i;var o=this.polymer,a=o.structure,s=o.residueCount,c=o.residueIndexStart,u=this.position,h=r||{};h.structure=a;for(var l,p,d=Jl.getScheme(h),f=new Wv(n),m=0,g=0,v=[],y=[],b=[],x=[],_=[],w=[],S=[],A=[],M=[],P=[],T=[],E=new $e,C=new $e,I=a.getResidueProxy(),R=a.getResidueProxy(),L=a.getAtomProxy(),O=new $e,D=new $e,k=!1,N=0;N<s;++N)if(I.index=c+N,O.fromArray(u.center,3*N),N===s-1?k=!0:(R.index=c+N+1,D.fromArray(u.center,3*N+3),i&&I.sstruc!==R.sstruc?k=!0:O.distanceTo(D)>e?k=!0:u.bending[N]>t&&(k=!0)),k){if(N-m<4){m=N,k=!1;continue}L.index=I.traceAtomIndex,P=u.axis.subarray(3*m+3,3*N),T=u.center.subarray(3*m,3*N+3),l=uf(P).normalize(),p=uf(T),E.fromArray(T),hf(E,l,p),C.fromArray(T,T.length-3),hf(C,l,p),l.subVectors(C,E),l.toArray(v,g),p.toArray(y,g),E.toArray(b,g),C.toArray(x,g),d.atomColorToArray(L,_,g),w.push(L.index),S.push(f.atomRadius(L)),A.push(c+m),M.push(c+N+1-m),g+=3,m=N,k=!1}var B=new Float32Array(w);return{axis:new Float32Array(v),center:new Float32Array(y),begin:new Float32Array(b),end:new Float32Array(x),color:new Float32Array(_),picking:new fg(B,a),size:new Float32Array(S),residueOffset:A,residueCount:M}};var oy=function(t){this.scoreFunction=t,this.content=[],this.scoreFunction=t};oy.prototype.push=function(t){this.content.push(t),this.bubbleUp(this.content.length-1)},oy.prototype.pop=function(){var t=this.content[0],e=this.content.pop();return e&&this.content.length>0&&(this.content[0]=e,this.sinkDown(0)),t},oy.prototype.peek=function(){return this.content[0]},oy.prototype.remove=function(t){for(var e=this.content.length,i=0;i<e;i++)if(this.content[i]===t){var r=this.content.pop();return void(r&&i!==e-1&&(this.content[i]=r,this.scoreFunction(r)<this.scoreFunction(t)?this.bubbleUp(i):this.sinkDown(i)))}throw new Error("Node not found.")},oy.prototype.size=function(){return this.content.length},oy.prototype.bubbleUp=function(t){for(var e=this.content[t];t>0;){var i=Math.floor((t+1)/2)-1,r=this.content[i];if(!(this.scoreFunction(e)<this.scoreFunction(r)))break;this.content[i]=e,this.content[t]=r,t=i}},oy.prototype.sinkDown=function(t){for(var e=this.content.length,i=this.content[t],r=this.scoreFunction(i),n=0;;){var o=2*(t+1),a=o-1,s=null;if(a<e){var c=this.content[a];(n=this.scoreFunction(c))<r&&(s=a)}if(o<e){var u=this.content[o];this.scoreFunction(u)<(null===s?r:n)&&(s=o)}if(null===s)break;this.content[t]=this.content[s],this.content[s]=i,t=s}};var ay=function(t,e){this.points=t,this.metric=e,this.maxDepth=0,this.currentNode=0;for(var i=t.length/3,r=new Uint32Array(i),n=0;n<i;++n)r[n]=n;this.indices=r,this.nodes=new Int32Array(4*i),this.rootIndex=this.buildTree(0,-1,0,i)};ay.prototype.buildTree=function(t,e,i,r){t>this.maxDepth&&(this.maxDepth=t);var n=r-i;if(0===n)return-1;var o=4*this.currentNode,a=this.nodes;if(this.currentNode+=1,1===n)return a[o]=i,a[o+1]=-1,a[o+2]=-1,a[o+3]=e,o;for(var s,c,u,h,l,p=this.indices,d=this.points,f=i+Math.floor(n/2),m=t%3,g=i,v=r-1;v>g;){for(h=d[3*p[u=g+v>>1]+m],c=p[u],p[u]=p[v],p[v]=c,l=g,s=g;s<v;++s)d[3*p[s]+m]<h&&(c=p[l],p[l]=p[s],p[s]=c,++l);if(c=p[v],p[v]=p[l],p[l]=c,f===(u=l))break;f<u?v=u-1:g=u+1}return a[o]=f,a[o+1]=this.buildTree(t+1,o,i,f),a[o+2]=this.buildTree(t+1,o,f+1,r),a[o+3]=e,o},ay.prototype.getNodeDepth=function(t){var e=this.nodes[t+3];return-1===e?0:this.getNodeDepth(e)+1},ay.prototype.nearest=function(t,e,i){var r=this,n=new oy(function(t){return-t[1]}),o=this.nodes,a=this.points,s=this.indices,c=function(u){var h,l,p=r.getNodeDepth(u)%3,d=3*s[o[u]],f=[a[d+0],a[d+1],a[d+2]],m=r.metric(t,f);function g(t,i){n.push([t,i]),n.size()>e&&n.pop()}var v=o[u+1],y=o[u+2];if(-1!==y||-1!==v){h=-1===y?v:-1===v?y:t[p]<=a[d+p]?v:y,c(h),(n.size()<e||m<n.peek()[1])&&m<=i&&g(u,m);for(var b=[],x=0;x<3;x+=1)b[x]=x===p?t[x]:a[d+x];var _=r.metric(b,f);(n.size()<e||Math.abs(_)<n.peek()[1])&&Math.abs(_)<=i&&-1!==(l=h===v?y:v)&&c(l)}else(n.size()<e||m<n.peek()[1])&&m<=i&&g(u,m)};c(this.rootIndex);for(var u=[],h=0,l=Math.min(n.size(),e);h<l;h+=1)u.push(n.content[h]);return u},ay.prototype.verify=function(t,e){void 0===e&&(e=0);var i=1;if(void 0===t&&(t=this.rootIndex),-1===t)throw new Error("node is null");var r=e%3,n=this.nodes,o=this.points,a=this.indices,s=n[t+1],c=n[t+2];if(-1!==s){if(o[3*a[n[s]]+r]>o[3*a[n[t]]+r])throw new Error("left child is > parent!");i+=this.verify(s,e+1)}if(-1!==c){if(o[3*a[n[c]]+r]<o[3*a[n[t]]+r])throw new Error("right child is < parent!");i+=this.verify(c,e+1)}return i};var sy=function(t,e){void 0===e&&(e=0),this.structure=t,this.index=e,this.chainStore=t.chainStore,this.residueStore=t.residueStore,this.atomStore=t.atomStore,this.residueMap=t.residueMap,this.atomMap=t.atomMap},cy={bondHash:{configurable:!0},entity:{configurable:!0},entityIndex:{configurable:!0},modelIndex:{configurable:!0},chainIndex:{configurable:!0},residue:{configurable:!0},residueIndex:{configurable:!0},sstruc:{configurable:!0},inscode:{configurable:!0},resno:{configurable:!0},chainname:{configurable:!0},chainid:{configurable:!0},residueType:{configurable:!0},atomType:{configurable:!0},residueAtomOffset:{configurable:!0},resname:{configurable:!0},hetero:{configurable:!0},atomname:{configurable:!0},number:{configurable:!0},element:{configurable:!0},vdw:{configurable:!0},covalent:{configurable:!0},x:{configurable:!0},y:{configurable:!0},z:{configurable:!0},serial:{configurable:!0},bfactor:{configurable:!0},occupancy:{configurable:!0},altloc:{configurable:!0},partialCharge:{configurable:!0},formalCharge:{configurable:!0},aromatic:{configurable:!0},bondCount:{configurable:!0}};function uy(t,e){var i=t[0]-e[0],r=t[1]-e[1],n=t[2]-e[2];return i*i+r*r+n*n}function hy(t,e){return Math.sqrt(uy(t,e))}cy.bondHash.get=function(){return this.structure.bondHash},cy.entity.get=function(){return this.structure.entityList[this.entityIndex]},cy.entityIndex.get=function(){return this.chainStore.entityIndex[this.chainIndex]},cy.modelIndex.get=function(){return this.chainStore.modelIndex[this.chainIndex]},cy.chainIndex.get=function(){return this.residueStore.chainIndex[this.residueIndex]},cy.residue.get=function(){return console.warn("residue - might be expensive"),this.structure.getResidueProxy(this.residueIndex)},cy.residueIndex.get=function(){return this.atomStore.residueIndex[this.index]},cy.residueIndex.set=function(t){this.atomStore.residueIndex[this.index]=t},cy.sstruc.get=function(){return this.residueStore.getSstruc(this.residueIndex)},cy.inscode.get=function(){return this.residueStore.getInscode(this.residueIndex)},cy.resno.get=function(){return this.residueStore.resno[this.residueIndex]},cy.chainname.get=function(){return this.chainStore.getChainname(this.chainIndex)},cy.chainid.get=function(){return this.chainStore.getChainid(this.chainIndex)},cy.residueType.get=function(){return this.residueMap.get(this.residueStore.residueTypeId[this.residueIndex])},cy.atomType.get=function(){return this.atomMap.get(this.atomStore.atomTypeId[this.index])},cy.residueAtomOffset.get=function(){return this.residueStore.atomOffset[this.residueIndex]},cy.resname.get=function(){return this.residueType.resname},cy.hetero.get=function(){return this.residueType.hetero},cy.atomname.get=function(){return this.atomType.atomname},cy.number.get=function(){return this.atomType.number},cy.element.get=function(){return this.atomType.element},cy.vdw.get=function(){return this.atomType.vdw},cy.covalent.get=function(){return this.atomType.covalent},cy.x.get=function(){return this.atomStore.x[this.index]},cy.x.set=function(t){this.atomStore.x[this.index]=t},cy.y.get=function(){return this.atomStore.y[this.index]},cy.y.set=function(t){this.atomStore.y[this.index]=t},cy.z.get=function(){return this.atomStore.z[this.index]},cy.z.set=function(t){this.atomStore.z[this.index]=t},cy.serial.get=function(){return this.atomStore.serial[this.index]},cy.serial.set=function(t){this.atomStore.serial[this.index]=t},cy.bfactor.get=function(){return this.atomStore.bfactor[this.index]},cy.bfactor.set=function(t){this.atomStore.bfactor[this.index]=t},cy.occupancy.get=function(){return this.atomStore.occupancy[this.index]},cy.occupancy.set=function(t){this.atomStore.occupancy[this.index]=t},cy.altloc.get=function(){return this.atomStore.getAltloc(this.index)},cy.altloc.set=function(t){this.atomStore.setAltloc(this.index,t)},cy.partialCharge.get=function(){return this.atomStore.partialCharge?this.atomStore.partialCharge[this.index]:null},cy.partialCharge.set=function(t){this.atomStore.partialCharge&&(this.atomStore.partialCharge[this.index]=t)},cy.formalCharge.get=function(){return this.atomStore.formalCharge?this.atomStore.formalCharge[this.index]:null},cy.formalCharge.set=function(t){this.atomStore.formalCharge&&(this.atomStore.formalCharge[this.index]=t)},cy.aromatic.get=function(){return this.atomStore.aromatic?this.atomStore.aromatic[this.index]:this.residueType.isAromatic(this)?1:0},cy.aromatic.set=function(t){this.atomStore.aromatic&&(this.atomStore.aromatic[this.index]=t)},cy.bondCount.get=function(){return this.bondHash.countArray[this.index]},sy.prototype.eachBond=function(t,e){e=e||this.structure._bp;for(var i=this.index,r=this.bondHash,n=r.indexArray,o=r.countArray[i],a=r.offsetArray[i],s=0;s<o;++s)e.index=n[a+s],t(e)},sy.prototype.eachBondedAtom=function(t,e){var i=e||this.structure._ap,r=this.index;this.eachBond(function(e){i.index=r!==e.atomIndex1?e.atomIndex1:e.atomIndex2,t(i)}),this.index=r},sy.prototype.hasBondTo=function(t){var e=!1;return this.eachBondedAtom(function(i){t.index===i.index&&(e=!0)}),e},sy.prototype.bondToElementCount=function(t){var e=0,i=this.index;return this.eachBondedAtom(function(i){i.number===t&&(e+=1)}),this.index=i,e},sy.prototype.hasBondToElement=function(t){return this.bondToElementCount(t)>0},sy.prototype.isBackbone=function(){var t=this.residueType.backboneIndexList;return t.length>0&&t.includes(this.index-this.residueAtomOffset)},sy.prototype.isPolymer=function(){if(this.structure.entityList.length>0)return this.entity.isPolymer();var t=this.residueType.moleculeType;return 3===t||4===t||5===t},sy.prototype.isSidechain=function(){return this.isPolymer()&&!this.isBackbone()},sy.prototype.isCg=function(){var t=this.residueType.backboneType;return 4===t||5===t||6===t},sy.prototype.isTrace=function(){return this.index===this.residueType.traceAtomIndex+this.residueAtomOffset},sy.prototype.isHetero=function(){return 1===this.residueType.hetero},sy.prototype.isProtein=function(){return 3===this.residueType.moleculeType},sy.prototype.isNucleic=function(){var t=this.residueType.moleculeType;return 4===t||5===t},sy.prototype.isRna=function(){return 4===this.residueType.moleculeType},sy.prototype.isDna=function(){return 5===this.residueType.moleculeType},sy.prototype.isWater=function(){return 1===this.residueType.moleculeType},sy.prototype.isIon=function(){return 2===this.residueType.moleculeType},sy.prototype.isSaccharide=function(){return 6===this.residueType.moleculeType},sy.prototype.isHelix=function(){return mm.includes(this.sstruc)},sy.prototype.isSheet=function(){return gm.includes(this.sstruc)},sy.prototype.isTurn=function(){return vm.includes(this.sstruc)&&this.isProtein()},sy.prototype.isBonded=function(){return 0!==this.bondHash.countArray[this.index]},sy.prototype.isRing=function(){return 1===this.residueType.getRings().flags[this.index-this.residueAtomOffset]},sy.prototype.isAromatic=function(){return 1===this.aromatic},sy.prototype.isMetal=function(){return this.atomType.isMetal()},sy.prototype.isNonmetal=function(){return this.atomType.isNonmetal()},sy.prototype.isMetalloid=function(){return this.atomType.isMetalloid()},sy.prototype.isHalogen=function(){return this.atomType.isHalogen()},sy.prototype.isDiatomicNonmetal=function(){return this.atomType.isDiatomicNonmetal()},sy.prototype.isPolyatomicNonmetal=function(){return this.atomType.isPolyatomicNonmetal()},sy.prototype.isAlkaliMetal=function(){return this.atomType.isAlkaliMetal()},sy.prototype.isAlkalineEarthMetal=function(){return this.atomType.isAlkalineEarthMetal()},sy.prototype.isNobleGas=function(){return this.atomType.isNobleGas()},sy.prototype.isTransitionMetal=function(){return this.atomType.isTransitionMetal()},sy.prototype.isPostTransitionMetal=function(){return this.atomType.isPostTransitionMetal()},sy.prototype.isLanthanide=function(){return this.atomType.isLanthanide()},sy.prototype.isActinide=function(){return this.atomType.isActinide()},sy.prototype.getDefaultValence=function(){return this.atomType.getDefaultValence()},sy.prototype.getValenceList=function(){return this.atomType.getValenceList()},sy.prototype.getOuterShellElectronCount=function(){return this.atomType.getOuterShellElectronCount()},sy.prototype.distanceTo=function(t){var e=this.atomStore,i=t.atomStore,r=this.index,n=t.index,o=e.x[r]-i.x[n],a=e.y[r]-i.y[n],s=e.z[r]-i.z[n],c=o*o+a*a+s*s;return Math.sqrt(c)},sy.prototype.connectedTo=function(t){var e=this.atomStore,i=t.atomStore,r=this.index,n=t.index;if(e.altloc&&i.altloc){var o=e.altloc[r],a=i.altloc[n];if(0!==o&&0!==a&&32!==o&&32!==a&&o!==a)return!1}var s=e.x[r]-i.x[n],c=e.y[r]-i.y[n],u=e.z[r]-i.z[n],h=s*s+c*c+u*u;if(h<64&&this.isCg())return!0;if(isNaN(h))return!1;var l=this.covalent+t.covalent,p=l+.3,d=l-.5;return h<p*p&&h>d*d},sy.prototype.positionFromArray=function(t,e){return void 0===e&&(e=0),this.x=t[e+0],this.y=t[e+1],this.z=t[e+2],this},sy.prototype.positionToArray=function(t,e){void 0===t&&(t=[]),void 0===e&&(e=0);var i=this.index,r=this.atomStore;return t[e+0]=r.x[i],t[e+1]=r.y[i],t[e+2]=r.z[i],t},sy.prototype.positionToVector3=function(t){return void 0===t&&(t=new $e),t.x=this.x,t.y=this.y,t.z=this.z,t},sy.prototype.positionFromVector3=function(t){return this.x=t.x,this.y=t.y,this.z=t.z,this},sy.prototype.positionAdd=function(t){return this.x+=t.x,this.y+=t.y,this.z+=t.z,this},sy.prototype.positionSub=function(t){return this.x-=t.x,this.y-=t.y,this.z-=t.z,this},sy.prototype.getResidueBonds=function(t){void 0===t&&(t=!1);var e,i,r,n,o=this.residueAtomOffset,a=this.index-this.residueAtomOffset,s=this.residueType.getBonds(),c=s.atomIndices1,u=s.atomIndices2;for(t||(n=[]),e=c.indexOf(a);-1!==e;){if(r=u[e]+o,!n)return r;n.push(r),e=c.indexOf(a,e+1)}for(i=u.indexOf(a);-1!==i;){if(r=c[i]+o,!n)return r;n.push(r),i=u.indexOf(a,i+1)}return n},sy.prototype.qualifiedName=function(t){void 0===t&&(t=!1);var e="";return this.resname&&!t&&(e+="["+this.resname+"]"),void 0!==this.resno&&(e+=this.resno),this.inscode&&(e+="^"+this.inscode),this.chainname&&(e+=":"+this.chainname),this.atomname&&(e+="."+this.atomname),this.altloc&&(e+="%"+this.altloc),this.structure.modelStore.count>1&&(e+="/"+this.modelIndex),e},sy.prototype.clone=function(){return new sy(this.structure,this.index)},sy.prototype.toObject=function(){return{index:this.index,residueIndex:this.residueIndex,resname:this.resname,x:this.x,y:this.y,z:this.z,element:this.element,chainname:this.chainname,resno:this.resno,serial:this.serial,vdw:this.vdw,covalent:this.covalent,hetero:this.hetero,bfactor:this.bfactor,altloc:this.altloc,atomname:this.atomname,modelIndex:this.modelIndex}},Object.defineProperties(sy.prototype,cy);var ly=new Float32Array(3),py=function(e,i){void 0===i&&(i=!1),t.Debug&&ql.time("Kdtree build");var r=i?uy:hy,n=new Float32Array(3*e.atomCount),o=new Uint32Array(e.atomCount),a=0;e.eachAtom(function(t){n[a+0]=t.x,n[a+1]=t.y,n[a+2]=t.z,o[a/3]=t.index,a+=3}),this.atomIndices=o,this.points=n,this.kdtree=new ay(n,r),t.Debug&&ql.timeEnd("Kdtree build")};py.prototype.nearest=function(t,e,i){t instanceof $e?t.toArray(ly):t instanceof sy&&t.positionToArray(ly);for(var r=this.kdtree.nearest(ly,e,i),n=this.kdtree.indices,o=this.kdtree.nodes,a=this.atomIndices,s=[],c=0,u=r.length;c<u;++c){var h=r[c],l=h[0],p=h[1];s.push({index:a[n[o[l]]],distance:p})}return s};var dy={" ":"X","!":"Y","#":"Z",$:"-X","%":"-Y","&":"-Z","'":"Y+1/2","(":"1/2+X",")":"1/2+Y","*":"1/2-X","+":"1/2+Z",",":"1/2-Y","-":"1/2-Z",".":"X+1/2","/":"Z+1/2",0:"-X+1/2",1:"-Y+1/2",2:"-Z+1/2",3:"1/4+X",4:"1/4-Y",5:"1/4+Z",6:"1/4-X",7:"1/4+Y",8:"3/4-Y",9:"3/4+Z",":":"3/4+Y",";":"3/4+X","<":"3/4-X","=":"1/4-Z",">":"3/4-Z","?":"X-Y","@":"Y-X",A:"Z+1/3",B:"Z+2/3",C:"X+2/3",D:"Y+1/3",E:"-Y+2/3",F:"X-Y+1/3",G:"Y-X+2/3",H:"-X+1/3",I:"X+1/3",J:"Y+2/3",K:"-Y+1/3",L:"X-Y+2/3",M:"Y-X+1/3",N:"-X+2/3",O:"2/3+X",P:"1/3+Y",Q:"1/3+Z",R:"2/3-Y",S:"1/3+X-Y",T:"2/3+Y-X",U:"1/3-X",V:"2/3-X",W:"1/3-Y",X:"1/3-Z",Y:"2/3+Y",Z:"1/3+Y-X","[":"2/3+X-Y","]":"1/3+X","^":"2/3+Z",_:"2/3-Z","`":"5/6+Z",a:"1/6+Z",b:"5/6-Z",c:"1/6-Z",d:"Z+5/6",e:"Z+1/6",f:"Z+1/4",g:"+Y"},fy={"P 1":" !#","P -1":" !#$%&","P 1 2 1":" !#$!&","P 1 21 1":" !#$'&","C 1 2 1":" !#$!&()#*)&","P 1 m 1":" !# %#","P 1 c 1":" !# %+","C 1 m 1":" !# %#()#(,#","C 1 c 1":" !# %+()#(,+","P 1 2/m 1":" !# %#$!&$%&","P 1 21/m 1":" !#$)&$%& ,#","C 1 2/m 1":" !# %#$!&$%&()#(,#*)&*,&","P 1 2/c 1":" !#$!-$%& %+","P 1 21/c 1":" !#$%&$)- ,+","C 1 2/c 1":" !#$!-$%& %+()#*)-*,&(,+","P 2 2 2":" !#$%#$!& %&","P 2 2 21":" !#$%+$!- %&","P 21 21 2":" !#$%#*)&(,&","P 21 21 21":" !#*%+$)-(,&","C 2 2 21":" !#$%+$!- %&()#*,+*)-(,&","C 2 2 2":" !#$%#$!& %&()#*,#*)&(,&","F 2 2 2":" !#$%#$!& %& )+$,+$)- ,-(!+*%+*!-(%-()#*,#*)&(,&","I 2 2 2":" !#$%# %&$!&.'/01/.120'2","I 21 21 21":" !#*%+$)-(,&()+$,#*!& %-","P m m 2":" !#$%# %#$!#","P m c 21":" !#$%+ %+$!#","P c c 2":" !#$%# %+$!+","P m a 2":" !#$%#(%#*!#","P c a 21":" !#$%+(%#*!+","P n c 2":" !#$%# ,+$)+","P m n 21":" !#*%+(%+$!#","P b a 2":" !#$%#(,#*)#","P n a 21":" !#$%+(,#*)+","P n n 2":" !#$%#(,+*)+","C m m 2":" !#$%# %#$!#()#*,#(,#*)#","C m c 21":" !#$%+ %+$!#()#*,+(,+*)#","C c c 2":" !#$%# %+$!+()#*,#(,+*)+","A m m 2":" !#$%# %#$!# )+$,+ ,+$)+","A b m 2":" !#$%# ,#$)# )+$,+ %+$!+","A m a 2":" !#$%#(%#*!# )+$,+(,+*)+","A b a 2":" !#$%#(,#*)# )+$,+(%+*!+","F m m 2":" !#$%# %#$!# )+$,+ ,+$)+(!+*%+(%+*!+()#*,#(,#*)#","F d d 2":" !#$%#345675 )+$,+3896:9(!+*%+;49<79()#*,#;85<:5","I m m 2":" !#$%# %#$!#()+*,+(,+*)+","I b a 2":" !#$%#(,#*)#()+*,+ %+$!+","I m a 2":" !#$%#(%#*!#()+*,+ ,+$)+","P 2/m 2/m 2/m":" !#$%#$!& %&$%& !& %#$!#","P 2/n 2/n 2/n":" !#$%#$!& %&*,-()-(,+*)+","P 2/c 2/c 2/m":" !#$%#$!- %-$%& !& %+$!+","P 2/b 2/a 2/n":" !#$%#$!& %&*,&()&(,#*)#","P 21/m 2/m 2/a":" !#*%#$!&(%&$%&(!& %#*!#","P 2/n 21/n 2/a":" !#*%#*)- ,-$%&(!&(,+$)+","P 2/m 2/n 21/a":" !#*%+*!- %&$%&(!-(%+$!#","P 21/c 2/c 2/a":" !#*%#$!-(%-$%&(!& %+*!+","P 21/b 21/a 2/m":" !#$%#*)&(,&$%& !&(,#*)#","P 21/c 21/c 2/n":" !#*,#$)-(%-$%&()& ,+*!+","P 2/b 21/c 21/m":" !#$%+$)- ,&$%& !- ,+$)#","P 21/n 21/n 2/m":" !#$%#*)-(,-$%& !&(,+*)+","P 21/m 21/m 2/n":" !#$%#*'&.,&*,&.'& %#$!#","P 21/b 2/c 21/n":" !#*,+$!-(,&$%&()- %+*)#","P 21/b 21/c 21/a":" !#*%+$)-(,&$%&(!- ,+*)#","P 21/n 21/m 21/a":" !#0%/$'&.12$%&.!2 1#0'/","C 2/m 2/c 21/m":" !#$%+$!- %&$%& !- %+$!#()#*,+*)-(,&*,&()-(,+*)#","C 2/m 2/c 21/a":" !#$,+$)- %&$%& )- ,+$!#()#*%+*!-(,&*,&(!-(%+*)#","C 2/m 2/m 2/m":" !#$%#$!& %&$%& !& %#$!#()#*,#*)&(,&*,&()&(,#*)#","C 2/c 2/c 2/m":" !#$%#$!- %-$%& !& %+$!+()#*,#*)-(,-*,&()&(,+*)+","C 2/m 2/m 2/a":" !#$,#$)& %&$%& )& ,#$!#()#*%#*!&(,&*,&(!&(%#*)#","C 2/c 2/c 2/a":" !#*,#$!&(,&$,-(!- ,+*!+()#$%#*)& %&*%- )-(%+$)+","F 2/m 2/m 2/m":" !#$%#$!& %&$%& !& %#$!# )+$,+$)- ,-$,- )- ,+$)+(!+*%+*!-(%-*%-(!-(%+*!+()#*,#*)&(,&*,&()&(,#*)#","F 2/d 2/d 2/d":" !#$%#$!& %&64=37=345675 )+$,+$)- ,-68>3:>3896:9(!+*%+*!-(%-<4>;7>;49<79()#*,#*)&(,&<8=;:=;85<:5","I 2/m 2/m 2/m":" !#$%#$!& %&$%& !& %#$!#()+*,+*)-(,-*,-()-(,+*)+","I 2/b 2/a 2/m":" !#$%#*)&(,&$%& !&(,#*)#()+*,+$!- %-*,-()- %+$!+","I 21/b 21/c 21/a":" !#*%+$)-(,&$%&(!- ,+*)#()+$,#*!& %-*,- )&(%#$!+","I 21/m 21/m 21/a":" !#$,#$)& %&$%& )& ,#$!#()+*%+*!-(,-*,-(!-(%+*)+","P 4":" !#$%#% #!$#","P 41":" !#$%+% 5!$9","P 42":" !#$%#% +!$+","P 43":" !#$%+% 9!$5","I 4":" !#$%#% #!$#()+*,+,(+)*+","I 41":" !#*,+%(5)$9()+$%#, 9!*5","P -4":" !#$%#!$&% &","I -4":" !#$%#!$&% &()+*,+)*-,(-","P 4/m":" !#$%#% #!$#$%& !&!$&% &","P 42/m":" !#$%#% +!$+$%& !&!$-% -","P 4/n":" !#$%#,(#)*#*,&()&!$&% &","P 42/n":" !#$%#,(+)*+*,-()-!$&% &","I 4/m":" !#$%#% #!$#$%& !&!$&% &()+*,+,(+)*+*,-()-)*-,(-","I 41/a":" !#*,+%(5)$9$,=(!>!$&,(-()+$%#, 9!*5*%> )=)*-% &","P 4 2 2":" !#$%#% #!$#$!& %&! &%$&","P 4 21 2":" !#$%#,(#)*#*)&(,&! &%$&","P 41 2 2":" !#$%+% 5!$9$!& %-! >%$=","P 41 21 2":" !#$%+,(5)*9*)=(,>! &%$-","P 42 2 2":" !#$%#% +!$+$!& %&! -%$-","P 42 21 2":" !#$%#,(+)*+*)-(,-! &%$&","P 43 2 2":" !#$%+% 9!$5$!& %-! =%$>","P 43 21 2":" !#$%+,(9)*5*)>(,=! &%$-","I 4 2 2":" !#$%#% #!$#$!& %&! &%$&()+*,+,(+)*+*)-(,-)(-,*-","I 41 2 2":" !#*,+%(5)$9*!> ,=)(-%$&()+$%#, 9!*5$)=(%>! &,*-","P 4 m m":" !#$%#% #!$# %#$!#%$#! #","P 4 b m":" !#$%#% #!$#(,#*)#,*#)(#","P 42 c m":" !#$%#% +!$+ %+$!+%$#! #","P 42 n m":" !#$%#,(+)*+(,+*)+%$#! #","P 4 c c":" !#$%#% #!$# %+$!+%$+! +","P 4 n c":" !#$%#% #!$#(,+*)+,*+)(+","P 42 m c":" !#$%#% +!$+ %#$!#%$+! +","P 42 b c":" !#$%#% +!$+(,#*)#,*+)(+","I 4 m m":" !#$%#% #!$# %#$!#%$#! #()+*,+,(+)*+(,+*)+,*+)(+","I 4 c m":" !#$%#% #!$# %+$!+%$+! +()+*,+,(+)*+(,#*)#,*#)(#","I 41 m d":" !#*,+%(5)$9 %#*)+%*5) 9()+$%#, 9!*5(,+$!#,$9!(5","I 41 c d":" !#*,+%(5)$9 %+*)#%*9) 5()+$%#, 9!*5(,#$!+,$5!(9","P -4 2 m":" !#$%#% &!$&$!& %&%$#! #","P -4 2 c":" !#$%#% &!$&$!- %-%$+! +","P -4 21 m":" !#$%#% &!$&*)&(,&,*#)(#","P -4 21 c":" !#$%#% &!$&*)-(,-,*+)(+","P -4 m 2":" !#$%#!$&% & %#$!#! &%$&","P -4 c 2":" !#$%#% &!$& %+$!+! -%$-","P -4 b 2":" !#$%#% &!$&(,#*)#)(&,*&","P -4 n 2":" !#$%#% &!$&(,+*)+)(-,*-","I -4 m 2":" !#$%#% &!$& %#$!#! &%$&()+*,+,(-)*-(,+*)+)(-,*-","I -4 c 2":" !#$%#% &!$& %+$!+! -%$-()+*,+,(-)*-(,#*)#)(&,*&","I -4 2 m":" !#$%#% &!$&$!& %&%$#! #()+*,+,(-)*-*)-(,-,*+)(+","I -4 2 d":" !#$%#% &!$&*!>(%>,$9) 9()+*,+,(-)*-$)= ,=%*5!(5","P 4/m 2/m 2/m":" !#$%#% #!$#$!& %&! &%$&$%& !&!$&% & %#$!#%$#! #","P 4/m 2/c 2/c":" !#$%#% #!$#$!- %-! -%$-$%& !&!$&% & %+$!+%$+! +","P 4/n 2/b 2/m":" !#$%#% #!$#$!& %&! &%$&*,&()&)*&,(&(,#*)#,*#)(#","P 4/n 2/n 2/c":" !#$%#% #!$#$!& %&! &%$&*,-()-)*-,(-(,+*)+,*+)(+","P 4/m 21/b 2/m":" !#$%#% #!$#*)&(,&)(&,*&$%& !&!$&% &(,#*)#,*#)(#","P 4/m 21/n 2/c":" !#$%#% #!$#*)-(,-)(-,*-$%& !&!$&% &(,+*)+,*+)(+","P 4/n 21/m 2/m":" !#$%#,(#)*#*)&(,&! &%$&*,&()&!$&% & %#$!#,*#)(#","P 4/n 2/c 2/c":" !#$%#,(#)*#*)-(,-! -%$-*,&()&!$&% & %+$!+,*+)(+","P 42/m 2/m 2/c":" !#$%#% +!$+$!& %&! -%$-$%& !&!$-% - %#$!#%$+! +","P 42/m 2/c 2/m":" !#$%#% +!$+$!- %-! &%$&$%& !&!$-% - %+$!+%$#! #","P 42/n 2/b 2/c":" !#$%#,(+)*+$!- %-)(&,*&*,-()-!$&% &(,#*)#%$+! +","P 42/n 2/n 2/m":" !#$%#,(+)*+$!& %&)(-,*-*,-()-!$&% &(,+*)+%$#! #","P 42/m 21/b 2/c":" !#$%#% +!$+*)&(,&)(-,*-$%& !&!$-% -(,#*)#,*+)(+","P 42/m 21/n 2/m":" !#$%#,./'*/*'-.,-! &%$&$%& !&'*-,.-.,/*'/%$#! #","P 42/n 21/m 2/c":" !#$%#,(+)*+*)-(,-! &%$&*,-()-!$&% & %#$!#,*+)(+","P 42/n 21/c 2/m":" !#$%#,(+)*+*)&(,&! -%$-*,-()-!$&% & %+$!+,*#)(#","I 4/m 2/m 2/m":" !#$%#% #!$#$!& %&! &%$&$%& !&!$&% & %#$!#%$#! #()+*,+,(+)*+*)-(,-)(-,*-*,-()-)*-,(-(,+*)+,*+)(+","I 4/m 2/c 2/m":" !#$%#% #!$#$!- %-! -%$-$%& !&!$&% & %+$!+%$+! +()+*,+,(+)*+*)&(,&)(&,*&*,-()-)*-,(-(,#*)#,*#)(#","I 41/a 2/m 2/d":" !#*,+%(5)$9*!> ,=)(-%$&$,=(!>!$&,(-(,+$!#,$9!(5()+$%#, 9!*5$)=(%>! &,*-*%> )=)*-% & %#*)+%*5) 9","I 41/a 2/c 2/d":" !#*,+%(5)$9*!= ,>)(&%$-$,=(!>!$&,(-(,#$!+,$5!(9()+$%#, 9!*5$)>(%=! -,*&*%> )=)*-% & %+*)#%*9) 5","P 3":" !#%?#@$#","P 31":" !#%?A@$B","P 32":" !#%?B@$A","H 3":" !#%?#@$#CDAEFAGHAIJBKLBMNB","R 3":" !## !!# ","P -3":" !#%?#@$#$%&!@&? &","H -3":" !#%?#@$#$%&!@&? &OPQRSQTUQVWXYZX[]X]Y^W[^ZV^UR_PT_SO_","R -3":" !## !!# $%&&$%%&$","P 3 1 2":" !#%?#@$#%$&@!& ?&","P 3 2 1":" !#%?#@$#! &?%&$@&","P 31 1 2":" !#%?Q@$^%$_@!X ?&","P 31 2 1":" !#%?A@$B! &?%_$@X","P 32 1 2":" !#%?^@$Q%$X@!_ ?&","P 32 2 1":" !#%?B@$A! &?%X$@_","H 3 2":" !#%?#@$#! &?%&$@&OPQRSQTUQY]X[WXVZX]Y^W[^ZV^PO_SR_UT_","R 3 2":" !## !!# %$&$&%&%$","P 3 m 1":" !#%?#@$#%$#@!# ?#","P 3 1 m":" !#%?#@$#! #?%#$@#","P 3 c 1":" !#%?#@$#%$+@!+ ?+","P 3 1 c":" !#%?#@$#! +?%+$@+","H 3 m":" !#%?#@$#%$#@!# ?#OPQRSQTUQRUQTPQOSQ]Y^W[^ZV^WV^ZY^][^","R 3 m":" !## !!# ! # #!#! ","H 3 c":" !#%?#@$#%$+@!+ ?+OPQRSQTUQRU`TP`OS`]Y^W[^ZV^WVaZYa][a","R 3 c":" !## !!# '././'/'.","P -3 1 2/m":" !#%?#@$#%$&@!& ?&$%&!@&? &! #?%#$@#","P -3 1 2/c":" !#%?#@$#%$-@!- ?-$%&!@&? &! +?%+$@+","P -3 2/m 1":" !#%?#@$#! &?%&$@&$%&!@&? &%$#@!# ?#","P -3 2/c 1":" !#%?#@$#! -?%-$@-$%&!@&? &%$+@!+ ?+","H -3 2/m":" !#%?#@$#! &?%&$@&$%&!@&? &%$#@!# ?#OPQRSQTUQY]X[WXVZXVWXYZX[]XRUQTPQOSQ]Y^W[^ZV^PO_SR_UT_UR_PT_SO_WV^ZY^][^","R -3 2/m":" !## !!# %$&$&%&%$$%&&$%%&$! # #!#! ","H -3 2/c":" !#%?#@$#! -?%-$@-$%&!@&? &%$+@!+ ?+OPQRSQTUQY]b[WbVZbVWXYZX[]XRU`TP`OS`]Y^W[^ZV^POcSRcUTcUR_PT_SO_WVaZYa][a","R -3 2/c":" !## !!# 102021210$%&&$%%&$'././'/'.","P 6":" !#%?#@$#$%#!@#? #","P 61":" !#%?A@$B$%/!@d? e","P 65":" !#%?B@$A$%/!@e? d","P 62":" !#%?^@$Q$%#!@^? Q","P 64":" !#%?Q@$^$%#!@Q? ^","P 63":" !#%?#@$#$%+!@+? +","P -6":" !#%?#@$# !&%?&@$&","P 6/m":" !#%?#@$#$%#!@#? #$%&!@&? & !&%?&@$&","P 63/m":" !#%?#@$#$%+!@+? +$%&!@&? & !-%?-@$-","P 6 2 2":" !#%?#@$#$%#!@#? #! &?%&$@&%$&@!& ?&","P 61 2 2":" !#%?Q@$^$%+!@`? a! X?%&$@_%$b@!- ?c","P 65 2 2":" !#%?^@$Q$%+!@a? `! _?%&$@X%$c@!- ?b","P 62 2 2":" !#%?^@$Q$%#!@^? Q! _?%&$@X%$_@!& ?X","P 64 2 2":" !#%?Q@$^$%#!@Q? ^! X?%&$@_%$X@!& ?_","P 63 2 2":" !#%?#@$#$%+!@+? +! &?%&$@&%$-@!- ?-","P 6 m m":" !#%?#@$#$%#!@#? #%$#@!# ?#! #?%#$@#","P 6 c c":" !#%?#@$#$%#!@#? #%$+@!+ ?+! +?%+$@+","P 63 c m":" !#%?#@$#$%+!@+? +%$+@!+ ?+! #?%#$@#","P 63 m c":" !#%?#@$#$%+!@+? +%$#@!# ?#! +?%+$@+","P -6 m 2":" !#%?#@$# !&%?&@$&%$#@!# ?#%$&@!& ?&","P -6 c 2":" !#%?#@$# !-%?-@$-%$+@!+ ?+%$&@!& ?&","P -6 2 m":" !#%?#@$# !&%?&@$&! &?%&$@&! #?%#$@#","P -6 2 c":" !#%?#@$# !-%?-@$-! &?%&$@&! +?%+$@+","P 6/m 2/m 2/m":" !#%?#@$#$%#!@#? #! &?%&$@&%$&@!& ?&$%&!@&? & !&@$&%?&%$#@!# ?#! #?%#$@#","P 6/m 2/c 2/c":" !#%?#@$#$%#!@#? #! -?%-$@-%$-@!- ?-$%&!@&? & !&@$&%?&%$+@!+ ?+! +?%+$@+","P 63/m 2/c 2/m":" !#%?#@$#$%+!@+? +! -?%-$@-%$&@!& ?&$%&!@&? & !-@$-%?-%$+@!+ ?+! #?%#$@#","P 63/m 2/m 2/c":" !#%?#@$#$%+!@+? +! &?%&$@&%$-@!- ?-$%&!@&? & !-@$-%?-%$#@!# ?#! +?%+$@+","P 2 3":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& ","F 2 3":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%&  )+$,+$)- ,-#()#*,&*)&(,!+(%+*!-*%-((!+*%+*!-(%-+ )+$,-$)- ,)#(,#*)&*,&(()#*,#*)&(,&+(!+*%-*!-(%)+ ,+$)-$,- ","I 2 3":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& ()+*,+*)-(,-+()+*,-*)-(,)+(,+*)-*,-(","P 21 3":" !#*%+$)-(,&# !+*%-$)&(,!# %+*)-$,&(","I 21 3":" !#*%+$)-(,&# !+*%-$)&(,!# %+*)-$,&(()+$,#*!& %-+()#$,&*!- %)+(,#$!&*%- ","P 2/m -3":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& $%& !& %#$!#&$%& !# %#$!%&$!& %# !#$","P 2/n -3":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& *,-()-(,+*)+-*,-()+(,+*),-*)-(,+()+*","F 2/m -3":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& $%& !& %#$!#&$%& !# %#$!%&$!& %# !#$ )+$,+$)- ,-#()#*,&*)&(,!+(%+*!-*%-($,- )- ,+$)+&*,&()#(,#*)%-*!-(%+(!+*(!+*%+*!-(%-+ )+$,-$)- ,)#(,#*)&*,&(*%-(!-(%+*!+-$,- )+ ,+$),&*)&(,#()#*()#*,#*)&(,&+(!+*%-*!-(%)+ ,+$)-$,- *,&()&(,#*)#-*%-(!+(%+*!,-$)- ,+ )+$","F 2/d -3":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& 64=37=345675=64=375345674=67=3453756 )+$,+$)- ,-#()#*,&*)&(,!+(%+*!-*%-(68>3:>3896:9=<8=;:5;85<:4><7>;49;79<(!+*%+*!-(%-+ )+$,-$)- ,)#(,#*)&*,&(<4>;7>;49<79>68>3:93896:8=<:=;85;:5<()#*,#*)&(,&+(!+*%-*!-(%)+ ,+$)-$,- <8=;:=;8f<:f><4>;79;49<78>6:>3893:96","I 2/m -3":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& $%& !& %#$!#&$%& !# %#$!%&$!& %# !#$()+*,+*)-(,-+()+*,-*)-(,)+(,+*)-*,-(*,-()-(,+*)+-*,-()+(,+*),-*)-(,+()+*","P 21/a -3":" !#*%+$)-(,&# !+*%-$)&(,!# %+*)-$,&($%&(!- ,+*)#&$%-(!+ ,#*)%&$!-(,+ )#*","I 21/a -3":" !#*%+$)-(,&# !+*%-$)&(,!# %+*)-$,&($%&(!- ,+*)#&$%-(!+ ,#*)%&$!-(,+ )#*()+$,#*g& %-+()#$,&*!- %)+(,#$!&*%- *,- )&(%#$!+-*,& )#(%+$!,-*)& %#(!+$","P 4 3 2":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& ! &%$&!$#% # #%$#!$&% &!#!$#% &! &%$","P 42 3 2":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& )(-,*-)*+,(+(+,*+)*-,(-)+)*+,(-)(-,*","F 4 3 2":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& ! &%$&!$#% # #%$#!$&% &!#!$#% &! &%$ )+$,+$)- ,-#()#*,&*)&(,!+(%+*!-*%-(!(-%*-!*+%(+ +,$+)$-, -)#)*#,(&)(&,*(!+*%+*!-(%-+ )+$,-$)- ,)#(,#*)&*,&() -,$-)$+, +(#,*#)*&,(&)+!*+%(-!(-%*()#*,#*)&(,&+(!+*%-*!-(%)+ ,+$)-$,- )(&,*&)*#,(#(+%*+!*-%(-!+)$+, -) -,$","F 41 3 2":" !#$,+*)&(%-# !+$,&*)-(%!# ,+$)&*%-(:3>46=7<98;5;58<976=43>:97<58;>:3=46 )+$%#*!-(,&#()+*%&$!- ,!+(,#*)-$%& :;=4<>765839;94<5:6>83=79:6543>7;=8<(!+*,#$)- %&+ )#$%-*!&(,)#(%+*!&$,- 73=86>:<54;935469:<=8;>7576983=:;>4<()#*%+$!& ,-+(!#*,-$)& %)+ %#$!-*,&(7;>8<=:69435398657<>4;=:5:<94;=73>86","I 4 3 2":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& ! &%$&!$#% # #%$#!$&% &!#!$#% &! &%$()+*,+*)-(,-+()+*,-*)-(,)+(,+*)-*,-()(-,*-)*+,(+(+,*+)*-,(-)+)*+,(-)(-,*","P 43 3 2":" !#*%+$)-(,&# !+*%-$)&(,!# %+*)-$,&(7;>46=:<5839398<5:6=4;>75:<983>7;=46","P 41 3 2":" !#*%+$)-(,&# !+*%-$)&(,!# %+*)-$,&(:3=8<>7694;5;54697<>83=:97654;=:3>8<","I 41 3 2":" !#*%+$)-(,&# !+*%-$)&(,!# %+*)-$,&(:3=8<>7694;5;54697<>83=:97654;=:3>8<()+$,#*!& %-+()#$,&*!- %)+(,#$!&*%- 7;>46=:<5839398<5:6=4;>75:<983>7;=46","P -4 3 m":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& ! #%$#!$&% & #!$#%$&! &%#! #%$&!$&% ","F -4 3 m":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& ! #%$#!$&% & #!$#%$&! &%#! #%$&!$&%  )+$,+$)- ,-#()#*,&*)&(,!+(%+*!-*%-(!(+%*+!*-%(- +)$+,$-) -,#)(#,*&)*&,((!+*%+*!-(%-+ )+$,-$)- ,)#(,#*)&*,&() +,$+)$-, -(#)*#,*&)(&,+!(+%*-!*-%(()#*,#*)&(,&+(!+*%-*!-(%)+ ,+$)-$,- )(#,*#)*&,(&(+!*+%*-!(-%+) +,$-)$-, ","I -4 3 m":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& ! #%$#!$&% & #!$#%$&! &%#! #%$&!$&% ()+*,+*)-(,-+()+*,-*)-(,)+(,+*)-*,-()(+,*+)*-,(-(+)*+,*-)(-,+)(+,*-)*-,(","P -4 3 n":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& )(+,*+)*-,(-(+)*+,*-)(-,+)(+,*-)*-,(","F -4 3 c":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& )(+,*+)*-,(-(+)*+,*-)(-,+)(+,*-)*-,( )+$,+$)- ,-#()#*,&*)&(,!+(%+*!-*%-() #,$#)$&, &(#!*#%*&!(&%+! +%$-!$-% (!+*%+*!-(%-+ )+$,-$)- ,)#(,#*)&*,&(!(#%*#!*&%(& +!$+%$-! -%#) #,$&)$&, ()#*,#*)&(,&+(!+*%-*!-(%)+ ,+$)-$,- ! +%$+!$-% - #)$#,$&) &,#!(#%*&!*&%(","I -4 3 d":" !#*%+$)-(,&# !+*%-$)&(,!# %+*)-$,&(7354<9:6>8;=357<946>:;=857394<>:6=8;()+$,#*!& %-+()#$,&*!- %)+(,#$!&*%- :;98657<=43>;9:658<=73>49:;586=7<>43","P 4/m -3 2/m":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& ! &%$&!$#% # #%$#!$&% &!#!$#% &! &%$$%& !& %#$!#&$%& !# %#$!%&$!& %# !#$%$#! #% &!$&$&! &% #!$#%&% &!$#%$#! ","P 4/n -3 2/n":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& ! &%$&!$#% # #%$#!$&% &!#!$#% &! &%$*,-()-(,+*)+-*,-()+(,+*),-*)-(,+()+*,*+)(+,(-)*-*-)(-,(+)*+,-,(-)*+,*+)(","P 42/m -3 2/n":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& )(-,*-)*+,(+(+,*+)*-,(-)+)*+,(-)(-,*$%& !& %#$!#&$%& !# %#$!%&$!& %# !#$,*+)(+,(-)*-*-)(-,(+)*+,-,(-)*+,*+)(","P 42/n -3 2/m":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& )(-,*-)*+,(+(+,*+)*-,(-)+)*+,(-)(-,**,-()-(,+*)+-*,-()+(,+*),-*)-(,+()+*%$#! #% &!$&$&! &% #!$#%&% &!$#%$#! ","F 4/m -3 2/m":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& ! &%$&!$#% # #%$#!$&% &!#!$#% &! &%$$%& !& %#$!#&$%& !# %#$!%&$!& %# !#$%$#! #% &!$&$&! &% #!$#%&% &!$#%$#!  )+$,+$)- ,-#()#*,&*)&(,!+(%+*!-*%-(!(-%*-!*+%(+ +,$+)$-, -)#)*#,(&)(&,*$,- )- ,+$)+&*,&()#(,#*)%-*!-(%+(!+*%*+!(+%(-!*-$-) -, +)$+,&,(&)*#,*#)((!+*%+*!-(%-+ )+$,-$)- ,)#(,#*)&*,&() -,$-)$+, +(#,*#)*&,(&)+!*+%(-!(-%**%-(!-(%+*!+-$,- )+ ,+$),&*)&(,#()#*,$+) +, -)$-*&)(&,(#)*#,-%(-!*+%*+!(()#*,#*)&(,&+(!+*%-*!-(%)+ ,+$)-$,- )(&,*&)*#,(#(+%*+!*-%(-!+)$+, -) -,$*,&()&(,#*)#-*%-(!+(%+*!,-$)- ,+ )+$,*#)(#,(&)*&*-!(-%(+!*+%-, -)$+,$+) ","F 4/m -3 2/c":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& )(-,*-)*+,(+(+,*+)*-,(-)+)*+,(-)(-,*$%& !& %#$!#&$%& !# %#$!%&$!& %# !#$,*+)(+,(-)*-*-)(-,(+)*+,-,(-)*+,*+)( )+$,+$)- ,-#()#*,&*)&(,!+(%+*!-*%-() &,$&)$#, #(#%*#!*&%(&!+!$+% -! -%$$,- )- ,+$)+&*,&()#(,#*)%-*!-(%+(!+*,$#) #, &)$&*&!(&%(#!*#%-% -!$+%$+! (!+*%+*!-(%-+ )+$,-$)- ,)#(,#*)&*,&(!(&%*&!*#%(# +%$+!$-% -!#)$#, &) &,$*%-(!-(%+*!+-$,- )+ ,+$),&*)&(,#()#*%*#!(#%(&!*&$-! -% +!$+%&, &)$#,$#) ()#*,#*)&(,&+(!+*%-*!-(%)+ ,+$)-$,- ! -%$-!$+% + #,$#)$&, &)#!*#%(&!(&%**,&()&(,#*)#-*%-(!+(%+*!,-$)- ,+ )+$%$+! +% -!$-$&) &, #)$#,&%(&!*#%*#!(","F 41/d -3 2/m":" !#$,+*)&(%-# !+$,&*)-(%!# ,+$)&*%-(:3>46=7<98;5;58<976=43>:97<58;>:3=4664=3:>;85<79=64>3:5;89<74=6:>385;79<,$+! #%(-)*&*&)(-% #!$+,-%(&)*+,$#!  )+$%#*!-(,&#()+*%&$!- ,!+(,#*)-$%& :;=4<>765839;94<5:6>83=79:6543>7;=8<68>37=;49<:5=<8>;753496:4><:=;893756,*#!(+% &)$-*-!(&, +)$#%-, &!$+%*#)((!+*,#$)- %&+ )#$%-*!&(,)#(%+*!&$,- 73=86>:<54;935469:<=8;>7576983=:;>4<<4>;:=389675>68=379;45<:8=<7>;453:96%$#) +,(&!*-$&! -,(#)*+%&% -)$#,*+!(()#*%+$!& ,-+(!#*,-$)& %)+ %#$!-*,&(7;>8<=:69435398657<>4;=:5:<94;=73>86<8=;7>3456:9><4=;:9385678>67=349;:5<%*+)(#, -!$&$-) &%(+!*#,&,(-!*#%$+) ","F 41/d -3 2/c":" !#$,+*)&(%-# !+$,&*)-(%!# ,+$)&*%-(:3>46=7<98;5;58<976=43>:97<58;>:3=46<8>;7=3496:5><8=;793456:8><7=;493:56%*#)(+, &!$-$-! &,(+)*#%&, -!$#%*+)( )+$%#*!-(,&#()+*%&$!- ,!+(,#*)-$%& :;=4<>765839;94<5:6>83=79:6543>7;=8<<4=;:>385679>64=3:9;85<78=67>345;:9<%$+) #,(-!*&$&) -%(#!*+,&%(-)*#,$+! (!+*,#$)- %&+ )#$%-*!&(,)#(%+*!&$,- 73=86>:<54;935469:<=8;>7576983=:;>4<68=37>;45<:9=<4>;:5389674>6:=389;75<,*+!(#% -)$&*-)(&% +!$#,-,(&!*+%$#) ()#*%+$!& ,-+(!#*,-$)& %)+ %#$!-*,&(7;>8<=:69435398657<>4;=:5:<94;=73>8664>3:=;89<75=68>375;49<:4=<:>;853796,$#! +%(&)*-*&!(-, #)$+%-% &)$+,*#!(","I 4/m -3 2/m":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& ! &%$&!$#% # #%$#!$&% &!#!$#% &! &%$$%& !& %#$!#&$%& !# %#$!%&$!& %# !#$%$#! #% &!$&$&! &% #!$#%&% &!$#%$#! ()+*,+*)-(,-+()+*,-*)-(,)+(,+*)-*,-()(-,*-)*+,(+(+,*+)*-,(-)+)*+,(-)(-,**,-()-(,+*)+-*,-()+(,+*),-*)-(,+()+*,*+)(+,(-)*-*-)(-,(+)*+,-,(-)*+,*+)(","I 41/a -3 2/d":" !#*%+$)-(,&# !+*%-$)&(,!# %+*)-$,&(:3=8<>7694;5;54697<>83=:97654;=:3>8<$%&(!- ,+*)#&$%-(!+ ,#*)%&$!-(,+ )#*4<97358;=:6>6>:;=8357<94=8;>:694<573()+$,#*!& %-+()#$,&*!- %)+(,#$!&*%- 7;>46=:<5839398<5:6=4;>75:<983>7;=46*,- )&(%#$!+-*,& )#(%+$!,-*)& %#(!+$865:;943>7<=<=73>4;9:658>43=7<5869:;","P 1 1 2":" !#$%#","P 1 1 21":" !#$%+","B 1 1 2":" !#$%#(g+*%+","A 1 2 1":" !#$!& )+$)-","C 1 21 1":" !#$)&()#*!&","I 1 2 1":" !#$!&.'/0'2","I 1 21 1":" !#$)&.'/0!-","P 1 1 m":" !# !&","P 1 1 b":" !# )&","B 1 1 m":" !# !&(!+(!-","B 1 1 b":" !# )&(!+()-","P 1 1 2/m":" !# !&$%#$%&","P 1 1 21/m":" !#$%+$%& !-","B 1 1 2/m":" !# !&$%#$%&(!+(!-*%+*%-","P 1 1 2/b":" !#$,#$%& )&","P 1 1 21/b":" !#$%&$,+ )-","B 1 1 2/b":" !#$,#$%& )&(!+*,+*%-()-","P 21 2 2":" !#$!&(%&*%#","P 2 21 2":" !# ,&$)&$%#","P 21 21 2 (a)":" !#*,#.%&$'&","P 21 2 21":" !#$!&(%-*%+","P 2 21 21":" !# %&$)-$,+","C 2 2 21a)":" !#*%+(,&$)-()#$,+ %&*!-","C 2 2 2a":" !#*,#.%&$'&()#$%# ,&*!&","F 2 2 2a":" !#*,#.%&$'& '/*%/.12$!2.!/$,/ %20'2.'#$%# 1&0!&","I 2 2 2a":" !#*,#.%&$'&()+$%+*!- ,-","P 21/m 21/m 2/n a":" !#*,#$)&(%&$%&.'& ,#*!#","P 42 21 2a":" !#*,#%.+'$+$'&.%&! -,*-","I 2 3a":" !#*,#.%&$'&!# ,- '&$%/$# !-*!/$%&.%()+$%+ ,-*!-)+(%&(!-*,#*+()&$)#*,- ,"},my=/^[1-9]$/;function gy(t){var e="";return t.length>0&&(e=":"+Eh(t).join(" OR :")),new Rl(e)}var vy=function(t){void 0===t&&(t=""),this.name=t,this.partList=[]},yy={type:{configurable:!0}};yy.type.get=function(){return"Assembly"},vy.prototype.addPart=function(t,e){var i=new by(t,e);return this.partList.push(i),i},vy.prototype.getAtomCount=function(t){return this.partList.reduce(function(e,i){return e+i.getAtomCount(t)},0)},vy.prototype.getResidueCount=function(t){return this.partList.reduce(function(e,i){return e+i.getResidueCount(t)},0)},vy.prototype.getInstanceCount=function(){var t=0;return this.partList.forEach(function(e){t+=e.matrixList.length}),t},vy.prototype.isIdentity=function(t){if(1!==this.partList.length)return!1;var e=this.partList[0];if(1!==e.matrixList.length)return!1;if(!(new Ve).equals(e.matrixList[0]))return!1;var i=[];return t.eachChain(function(t){i.push(t.chainname)}),i=Eh(i),e.chainList.length===i.length},vy.prototype.getBoundingBox=function(t){var e=new xr;return this.partList.forEach(function(i){var r=i.getBoundingBox(t);e.expandByPoint(r.min),e.expandByPoint(r.max)}),e},vy.prototype.getCenter=function(t){return this.getBoundingBox(t).getCenter()},vy.prototype.getSelection=function(){var t=[];return this.partList.forEach(function(e){t=t.concat(e.chainList)}),gy(t)},Object.defineProperties(vy.prototype,yy);var by=function(t,e){void 0===t&&(t=[]),void 0===e&&(e=[]),this.matrixList=t,this.chainList=e},xy={type:{configurable:!0}};xy.type.get=function(){return"AssemblyPart"},by.prototype._getCount=function(t,e){var i=this,r=0;return t.eachChain(function(t){(0===i.chainList.length||i.chainList.includes(t.chainname))&&(r+=t[e])}),this.matrixList.length*r},by.prototype.getAtomCount=function(t){return this._getCount(t,"atomCount")},by.prototype.getResidueCount=function(t){return this._getCount(t,"residueCount")},by.prototype.getBoundingBox=function(t){var e=new xr,i=new xr,r=this.getSelection(),n=t.getBoundingBox(r);return this.matrixList.forEach(function(t){i.copy(n).applyMatrix4(t),e.expandByPoint(i.min),e.expandByPoint(i.max)}),e},by.prototype.getSelection=function(){return gy(this.chainList)},by.prototype.getView=function(t){var e=this.getSelection();return e?t.getView(e):t},by.prototype.getInstanceList=function(){for(var t=[],e=0,i=this.matrixList.length;e<i;++e)t.push({id:e+1,name:e,matrix:this.matrixList[e]});return t},Object.defineProperties(by.prototype,xy);var _y=function(t){this.structure=t,this.currentModelindex=null,this.currentChainid=null,this.currentResname=null,this.currentResno=null,this.currentInscode=null,this.currentHetero=null,this.previousResname="",this.previousHetero=null,this.ai=-1,this.ri=-1,this.ci=-1,this.mi=-1};function wy(e,i){if(i){t.Debug&&ql.time("assignSecondaryStructure");var r=[];e.eachModel(function(t){t.eachChain(function(t){r.push(t.chainname)})});var n=r.slice().sort(),o=[];n.forEach(function(t){o.push(r.indexOf(t))});var a=i.helices.filter(function(t){return Ph(n,t[0])>=0});a.sort(function(t,e){var i=t[0],r=e[0],a=t[1],s=e[1];if(i===r)return a===s?0:a<s?-1:1;var c=Ph(n,i),u=Ph(n,r);return o[c]<o[u]?-1:1});var s=e.residueStore;e.eachModel(function(t){var e=0,i=a.length;if(0!==i){var r=a[e],n=!1,o=!1;t.eachChain(function(t){var c=!1;if(t.chainname===r[0])for(var u=t.residueCount,h=t.residueOffset,l=h+u,p=h;p<l;++p)if(s.resno[p]===r[1]&&s.getInscode(p)===r[2]&&(n=!0),n&&(s.sstruc[p]=r[6],s.resno[p]===r[4]&&s.getInscode(p)===r[5]&&(n=!1,(e+=1)<i?(p=h-1,r=a[e],c=t.chainname!==r[0]):o=!0)),c||o)return})}});var c=i.sheets.filter(function(t){return Ph(n,t[0])>=0});c.sort(function(t,e){var i=t[0],r=e[0];if(i===r)return 0;var a=Ph(n,i),s=Ph(n,r);return o[a]<o[s]?-1:1});var u="e".charCodeAt(0);e.eachModel(function(t){var e=0,i=c.length;if(0!==i){var r=c[e],n=!1,o=!1;t.eachChain(function(t){var a=!1;if(t.chainname===r[0])for(var h=t.residueCount,l=t.residueOffset,p=l+h,d=l;d<p;++d)if(s.resno[d]===r[1]&&s.getInscode(d)===r[2]&&(n=!0),n&&(s.sstruc[d]=u,s.resno[d]===r[4]&&s.getInscode(d)===r[5]&&(n=!1,(e+=1)<i?(d=l-1,r=c[e],a=t.chainname!==r[0]):o=!0)),a||o)return})}}),t.Debug&&ql.timeEnd("assignSecondaryStructure")}}_y.prototype.addResidueType=function(t){for(var e=this.structure.atomStore,i=this.structure.residueStore,r=this.structure.residueMap,n=i.atomCount[t],o=i.atomOffset[t],a=new Array(n),s=0;s<n;++s)a[s]=e.atomTypeId[o+s];i.residueTypeId[t]=r.add(this.previousResname,a,this.previousHetero)},_y.prototype.addAtom=function(t,e,i,r,n,o,a,s){var c=this.structure.atomStore,u=this.structure.residueStore,h=this.structure.chainStore,l=this.structure.modelStore,p=!1,d=!1,f=!1;this.currentModelindex!==t?(p=!0,d=!0,f=!0,this.mi+=1,this.ci+=1,this.ri+=1):this.currentChainid!==i?(d=!0,f=!0,this.ci+=1,this.ri+=1):this.currentResno===n&&this.currentResname===r&&this.currentInscode===s||(f=!0,this.ri+=1),this.ai+=1,p&&(l.growIfFull(),l.chainOffset[this.mi]=this.ci,l.chainCount[this.mi]=0,l.count+=1,h.modelIndex[this.ci]=this.mi),d&&(h.growIfFull(),h.setChainname(this.ci,e),h.setChainid(this.ci,i),h.residueOffset[this.ci]=this.ri,h.residueCount[this.ci]=0,h.count+=1,h.modelIndex[this.ci]=this.mi,l.chainCount[this.mi]+=1,u.chainIndex[this.ri]=this.ci),f&&(this.previousResname=this.currentResname,this.previousHetero=this.currentHetero,this.ri>0&&this.addResidueType(this.ri-1),u.growIfFull(),u.resno[this.ri]=n,void 0!==a&&(u.sstruc[this.ri]=a.charCodeAt(0)),void 0!==s&&(u.inscode[this.ri]=s.charCodeAt(0)),u.atomOffset[this.ri]=this.ai,u.atomCount[this.ri]=0,u.count+=1,u.chainIndex[this.ri]=this.ci,h.residueCount[this.ci]+=1),c.count+=1,c.residueIndex[this.ai]=this.ri,u.atomCount[this.ri]+=1,this.currentModelindex=t,this.currentChainid=i,this.currentResname=r,this.currentResno=n,this.currentInscode=s,this.currentHetero=o},_y.prototype.finalize=function(){this.previousResname=this.currentResname,this.previousHetero=this.currentHetero,this.ri>-1&&this.addResidueType(this.ri)};var Sy,Ay=(Sy=function(t,e,i,r){for(var n=t.structure,o=t.residueIndexStart,a=n.getResidueProxy(),s=n.getResidueProxy(),c=n.getAtomProxy(),u=n.getAtomProxy(),h=Math.max(0,e-2);h<=e;++h)for(var l=2;l<5;++l)if(!(h+l>=t.residueCount)){a.index=o+h,s.index=o+h+l,c.index=a.traceAtomIndex,u.index=s.traceAtomIndex;var p=c.distanceTo(u);if(Math.abs(p-i[l-2])>r)return!1}return!0},function(e){t.Debug&&ql.time("calculateSecondaryStructure"),e.eachPolymer(function(t){if(!(t.residueCount<4)){if(t.isCg())!function(t){for(var e=t.residueStore,i=t.residueIndexStart,r=new ny(t).position,n=new $e,o=new $e,a=0,s=t.residueCount;a<s;++a){n.fromArray(r.center,3*a),o.fromArray(r.center,3*a+3);var c=n.distanceTo(o);c<2&&c>1&&r.bending[a]<20&&(e.sstruc[i+a]="h".charCodeAt(0),e.sstruc[i+a+1]="h".charCodeAt(0))}}(t);else{if(!t.isProtein())return;!function(t){for(var e=t.residueStore,i=t.residueIndexStart,r=0,n=t.residueCount;r<n;++r){var o="c";Sy(t,r,[5.45,5.18,6.37],2.1)?o="h":Sy(t,r,[6.1,10.4,13],1.42)&&(o="s"),e.sstruc[i+r]=o.charCodeAt(0)}}(t)}var e,i=0;t.eachResidue(function(t){t.sstruc===e?i+=1:(1===i&&(t.index-=1,t.sstruc="c"),i=1,e=t.sstruc)})}}),t.Debug&&ql.timeEnd("calculateSecondaryStructure")}),My="ABCDEFGHIJKLMNOPQRSTUVWXYZ";function Py(t){for(var e=My.length,i=t,r=0,n=My[i%e];i>=e;)i=Math.floor(i/e),n+=My[i%e],r+=1;return r>=5&&ql.warn("chainname overflow"),n}function Ty(e,i){void 0===i&&(i=!1),t.Debug&&ql.time("calculateChainnames");var r=!0;if(e.eachChain(function(t){t.chainname&&(r=!1)}),r){var n=e.modelStore,o=e.chainStore,a=e.residueStore,s=e.getAtomProxy(),c=e.getAtomProxy(),u=0,h=0,l=0,p=0,d=[];1===a.count?d.push({mIndex:0,chainname:"A",rStart:0,rCount:1}):e.eachResidueN(2,function(t,e){var r=!1,n=t.backboneType,o=e.backboneType,f=um;p=t.index,t.modelIndex!==e.modelIndex?r=!0:t.moleculeType!==e.moleculeType?r=!0:n!==f&&n===o&&(s.index=t.backboneEndAtomIndex,c.index=e.backboneStartAtomIndex,r=i?!s.hasBondTo(c):!s.connectedTo(c)),r||e.index!==a.count-1||(r=!0,p=e.index),r&&(d.push({mIndex:h,chainname:Py(u),rStart:l,rCount:p-l+1}),u+=1,t.modelIndex!==e.modelIndex&&(u=0,h+=1),e.index===a.count-1&&p!==e.index&&d.push({mIndex:h,chainname:Py(u),rStart:a.count-1,rCount:1}),l=e.index,p=e.index)}),o.count=0,d.forEach(function(t){!function(t,e,i,r){for(var s=o.count,c=0;c<r;++c)a.chainIndex[i+c]=s;o.growIfFull(),o.modelIndex[s]=t,o.setChainname(s,e),o.setChainid(s,e),o.residueOffset[s]=i,o.residueCount[s]=r,o.count+=1,n.chainCount[t]+=1}(t.mIndex,t.chainname,t.rStart,t.rCount)});var f=0;e.eachModel(function(t){n.chainOffset[t.index]=f,n.chainCount[t.index]-=1,f+=n.chainCount[t.index]})}t.Debug&&ql.timeEnd("calculateChainnames")}function Ey(e){t.Debug&&ql.time("calculateBonds"),Ry(e),Ly(e),t.Debug&&ql.timeEnd("calculateBonds")}var Cy={"HIS|CD2|CG":2,"HIS|CE1|ND1":2,"ARG|CZ|NH2":2,"PHE|CE1|CZ":2,"PHE|CD2|CE2":2,"PHE|CD1|CG":2,"TRP|CD1|CG":2,"TRP|CD2|CE2":2,"TRP|CE3|CZ3":2,"TRP|CH2|CZ2":2,"ASN|CG|OD1":2,"GLN|CD|OE1":2,"TYR|CD1|CG":2,"TYR|CD2|CE2":2,"TYR|CE1|CZ":2,"ASP|CG|OD1":2,"GLU|CD|OE1":2,"G|C8|N7":2,"G|C4|C5":2,"G|C2|N3":2,"G|C6|O6":2,"C|C4|N3":2,"C|C5|C6":2,"C|C2|O2":2,"A|C2|N3":2,"A|C6|N1":2,"A|C4|C5":2,"A|C8|N7":2,"U|C5|C6":2,"U|C2|O2":2,"U|C4|O4":2,"DG|C8|N7":2,"DG|C4|C5":2,"DG|C2|N3":2,"DG|C6|O6":2,"DC|C4|N3":2,"DC|C5|C6":2,"DC|C2|O2":2,"DA|C2|N3":2,"DA|C6|N1":2,"DA|C4|C5":2,"DA|C8|N7":2,"DT|C5|C6":2,"DT|C2|O2":2,"DT|C4|O4":2};function Iy(t,e,i){var r;return e=(r=e<i?[e,i]:[i,e])[0],i=r[1],Pm.includes(t)&&"C"===e&&"O"===i?2:Im.includes(t)&&"OP1"===e&&"P"===i?2:Cy[t+"|"+e+"|"+i]||1}function Ry(e,i){void 0===i&&(i=!1),t.Debug&&ql.time("calculateBondsWithin");var r=e.bondStore,n=e.rungBondStore,o=e.getAtomSet(!1),a=e.getAtomProxy(),s=e.getAtomProxy(),c=e.getBondProxy(),u=i?null:function(e){t.Debug&&ql.time("calculateAtomBondMap");var i=[];return e.eachBond(function(t){var e=t.atomIndex1,r=t.atomIndex2;void 0===i[e]&&(i[e]=[]),i[e][r]=t.index}),t.Debug&&ql.timeEnd("calculateAtomBondMap"),i}(e);e.eachResidue(function(t){if(!i&&u){var e=t.atomCount,h=t.atomOffset;if(e>500)return void ql.warn("more than 500 atoms, skip residue for auto-bonding",t.qualifiedName());for(var l=t.getBonds(),p=l.atomIndices1,d=l.atomIndices2,f=l.bondOrders,m=p.length,g=0;g<m;++g){var v=p[g]+h,y=d[g]+h,b=u[v];if(void 0!==b&&void 0!==b[y])c.index=b[y],f[t.residueType.getBondIndex(v,y)]=c.bondOrder;else a.index=v,s.index=y,r.addBond(a,s,f[g])}}var x=t.residueType.traceAtomIndex,_=t.residueType.rungEndAtomIndex;-1!==x&&-1!==_&&(a.index=t.traceAtomIndex,s.index=t.rungEndAtomIndex,n.addBond(a,s),o.set(a.index),o.set(s.index))}),e.atomSetDict.rung=o,t.Debug&&ql.timeEnd("calculateBondsWithin")}function Ly(e,i,r){void 0===i&&(i=!1),void 0===r&&(r=!1),t.Debug&&ql.time("calculateBondsBetween");var n=e.bondStore,o=e.backboneBondStore,a=e.getAtomSet(!1),s=e.getAtomProxy(),c=e.getAtomProxy();function u(t,e){var u=t.backboneType,h=e.backboneType;u!==um&&u===h&&(s.index=t.backboneEndAtomIndex,c.index=e.backboneStartAtomIndex,(r&&s.hasBondTo(c)||s.connectedTo(c))&&(i||n.addBond(s,c,1),s.index=t.traceAtomIndex,c.index=e.traceAtomIndex,o.addBond(s,c),a.set(s.index),a.set(c.index)))}0===o.count&&o.resize(e.residueStore.count),e.eachResidueN(2,u);var h=e.getResidueProxy(),l=e.getResidueProxy();if(e.eachChain(function(t){0!==t.residueCount&&(h.index=t.residueOffset,l.index=t.residueOffset+t.residueCount-1,u(l,h))}),e.atomSetDict.backbone=a,!i){t.Debug&&ql.time("calculateBondsBetween inter");var p=e.spatialHash;e.eachResidue(function(t){t.backboneType!==um||t.isWater()||t.eachAtom(function(t){t.isMetal()||p.eachWithin(t.x,t.y,t.z,4,function(e){c.index=e,t.modelIndex!==c.modelIndex||t.residueIndex===c.residueIndex||c.isMetal()||n.addBondIfConnected(t,c,1)})})}),t.Debug&&ql.timeEnd("calculateBondsBetween inter")}t.Debug&&ql.timeEnd("calculateBondsBetween")}function Oy(e){if(e.unitcell){t.Debug&&ql.time("buildUnitcellAssembly");var i=e.unitcell,r=e.center.clone().applyMatrix4(i.cartToFrac),n=r.clone().floor(),o=function(t){var e=fy[t],i={};if(void 0===e)return console.warn("spacegroup '"+t+"' not found in symop library"),i;for(var r=[],n=0,o=e.length;n<o;n+=3){for(var a=[],s=0;s<3;++s)a.push(dy[e[n+s]]);r.push(a)}return r.forEach(function(t){var e=0,r=(new Ve).set(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1),n=r.elements;i[t.toString()]=r,t.forEach(function(t){for(var i=!1,r=!1,o=0,a=t.length;o<a;++o){var s=t[o];if("-"===s)i=!0;else if("+"===s)i=!1;else if("/"===s)r=!0;else if("X"===s)n[0+e]=i?-1:1;else if("Y"===s)n[4+e]=i?-1:1;else if("Z"===s)n[8+e]=i?-1:1;else if(my.test(s)){var c=parseInt(s);r?n[12+e]/=c:n[12+e]=c}else ql.warn("getSymmetryOperations: unknown token '"+s+"'")}e+=1})}),i}(i.spacegroup),a=new $e,s=new $e,c=new vy("UNITCELL"),u=g(),h=[];if(e.biomolDict.NCS){h.push.apply(h,[new Ve].concat(e.biomolDict.NCS.partList[0].matrixList));var l=[];u.forEach(function(t){h.forEach(function(e){l.push(t.clone().multiply(e))})}),c.addPart(l)}else c.addPart(u);var p=new $e,d=new vy("SUPERCELL"),f=Array.prototype.concat.call(g(p.set(1,0,0)),g(p.set(0,1,0)),g(p.set(0,0,1)),g(p.set(-1,0,0)),g(p.set(0,-1,0)),g(p.set(0,0,-1)),g(p.set(1,1,0)),g(p.set(1,0,1)),g(p.set(0,1,1)),g(p.set(-1,-1,0)),g(p.set(-1,0,-1)),g(p.set(0,-1,-1)),g(p.set(1,-1,-1)),g(p.set(1,1,-1)),g(p.set(1,-1,1)),g(p.set(-1,1,1)),g(p.set(-1,-1,1)),g(p.set(-1,1,-1)),g(p.set(0,1,-1)),g(p.set(0,-1,1)),g(p.set(1,0,-1)),g(p.set(-1,0,1)),g(p.set(1,-1,0)),g(p.set(-1,1,0)),g(),g(p.set(1,1,1)),g(p.set(-1,-1,-1)));if(e.biomolDict.NCS){var m=[];f.forEach(function(t){h.forEach(function(e){m.push(t.clone().multiply(e))})}),d.addPart(m)}else d.addPart(f);e.biomolDict.UNITCELL=c,e.biomolDict.SUPERCELL=d,t.Debug&&ql.timeEnd("buildUnitcellAssembly")}function g(t){var e=[];return Object.keys(o).forEach(function(c){var u=o[c].clone();a.copy(r).applyMatrix4(u).floor(),s.setFromMatrixPosition(u),s.sub(a),s.add(n),t&&s.add(t),u.setPosition(s),u.multiplyMatrices(i.fracToCart,u),u.multiply(i.cartToFrac),e.push(u)}),e}}var Dy=["H","C","O","N","S","P"],ky=["NA","CL","FE"];function Ny(t){var e=t.trim().toUpperCase();parseInt(e.charAt(0))&&(e=e.substr(1)),parseInt(e.charAt(0))&&(e=e.substr(1));var i=e.length;if(0===i)return"";if(1===i)return e;if(2===i){if(-1!==ky.indexOf(e))return e;if(-1!==Dy.indexOf(e[0]))return e[0]}return i>=3&&-1!==Dy.indexOf(e[0])?e[0]:""}function By(t){var e=t.bondHash,i=e.countArray,r=e.offsetArray,n=e.indexArray,o=t.getBondProxy();t.eachResidue(function(t){var e=t.residueType;if(void 0===e.bonds){var a=t.atomOffset,s=[],c=[],u=[],h={};t.eachAtom(function(t){for(var e=t.index,l=r[e],p=0,d=i[e];p<d;++p){o.index=n[l+p];var f=o.atomIndex1,m=o.atomIndex2;if(f>m){var g=m;m=f,f=g}var v=f+"|"+m;void 0===h[v]&&(h[v]=!0,s.push(f-a),c.push(m-a),u.push(o.bondOrder))}}),e.bonds={atomIndices1:s,atomIndices2:c,bondOrders:u}}})}var Fy=[3,11,19,37,55,87],zy=[4,12,20,38,56,88],Uy=[6,15,16,34],jy=[1,7,8,9,17,35,53],Gy=[2,10,18,36,54,86],Vy=[13,30,31,48,49,50,80,81,82,83,84,85,112],Hy=[5,14,32,33,51,52,85],$y=[9,17,35,53,85],Wy=function(t,e,i){this.structure=t,this.atomname=e,i=i||Ny(e),this.element=i,this.number=ym[i]||0,this.vdw=bm[this.number]||2,this.covalent=xm[this.number]||1.6};Wy.prototype.getDefaultValence=function(){var t=_m[this.number];return t?t[0]:-1},Wy.prototype.getValenceList=function(){return _m[this.number]||[]},Wy.prototype.getOuterShellElectronCount=function(){return wm[this.number]||2},Wy.prototype.isMetal=function(){return this.isAlkaliMetal()||this.isAlkalineEarthMetal()||this.isLanthanide()||this.isActinide()||this.isTransitionMetal()||this.isPostTransitionMetal()},Wy.prototype.isNonmetal=function(){return this.isDiatomicNonmetal()||this.isPolyatomicNonmetal()||this.isNobleGas()},Wy.prototype.isMetalloid=function(){return Hy.includes(this.number)},Wy.prototype.isHalogen=function(){return $y.includes(this.number)},Wy.prototype.isDiatomicNonmetal=function(){return jy.includes(this.number)},Wy.prototype.isPolyatomicNonmetal=function(){return Uy.includes(this.number)},Wy.prototype.isAlkaliMetal=function(){return Fy.includes(this.number)},Wy.prototype.isAlkalineEarthMetal=function(){return zy.includes(this.number)},Wy.prototype.isNobleGas=function(){return Gy.includes(this.number)},Wy.prototype.isTransitionMetal=function(){var t=this.number;return t>=21&&t<=29||t>=39&&t<=47||t>=72&&t<=79||t>=104&&t<=108},Wy.prototype.isPostTransitionMetal=function(){return Vy.includes(this.number)},Wy.prototype.isLanthanide=function(){return this.number>=57&&this.number<=71},Wy.prototype.isActinide=function(){return this.number>=89&&this.number<=103};var Xy=function(t){this.structure=t,this.dict={},this.list=[],this.structure=t};Xy.prototype.add=function(t,e){t=t.toUpperCase(),e=e?e.toUpperCase():Ny(t);var i=t+"|"+e,r=this.dict[i];if(void 0===r){var n=new Wy(this.structure,t,e);r=this.list.length,this.dict[i]=r,this.list.push(n)}return r},Xy.prototype.get=function(t){return this.list[t]};var qy=function(t,e,i,r,n,o){this.structure=t,this.bondReferenceAtomIndices=[],this.resname=e,this.atomTypeIdList=i,this.hetero=r?1:0,this.chemCompType=n,this.bonds=o,this.atomCount=i.length,this.moleculeType=this.getMoleculeType(),this.backboneType=this.getBackboneType(0),this.backboneEndType=this.getBackboneType(-1),this.backboneStartType=this.getBackboneType(1),this.backboneIndexList=this.getBackboneIndexList();var a=Nm[this.backboneType],s=Nm[this.backboneStartType],c=Nm[this.backboneEndType],u=this.getAtomIndexByName(a.trace);this.traceAtomIndex=yh(u,-1);var h=this.getAtomIndexByName(a.direction1);this.direction1AtomIndex=yh(h,-1);var l=this.getAtomIndexByName(a.direction2);this.direction2AtomIndex=yh(l,-1);var p=this.getAtomIndexByName(s.backboneStart);this.backboneStartAtomIndex=yh(p,-1);var d,f=this.getAtomIndexByName(c.backboneEnd);this.backboneEndAtomIndex=yh(f,-1),d=Cm.includes(e)?this.getAtomIndexByName("N1"):this.getAtomIndexByName("N3"),this.rungEndAtomIndex=yh(d,-1)};qy.prototype.getBackboneIndexList=function(){var t,e=[];switch(this.moleculeType){case 3:t=Dm;break;case 4:case 5:t=km;break;default:return e}for(var i=this.structure.atomMap,r=this.atomTypeIdList,n=0,o=this.atomCount;n<o;++n){var a=i.get(r[n]);t.includes(a.atomname)&&e.push(n)}return e},qy.prototype.getMoleculeType=function(){return this.isProtein()?3:this.isRna()?4:this.isDna()?5:this.isWater()?1:this.isIon()?2:this.isSaccharide()?6:0},qy.prototype.getBackboneType=function(t){return this.hasProteinBackbone(t)?1:this.hasRnaBackbone(t)?2:this.hasDnaBackbone(t)?3:this.hasCgProteinBackbone(t)?4:this.hasCgRnaBackbone(t)?5:this.hasCgDnaBackbone(t)?6:um},qy.prototype.isProtein=function(){return this.chemCompType?hm.includes(this.chemCompType):this.hasAtomWithName("CA","C","N")||Pm.includes(this.resname)},qy.prototype.isCg=function(){var t=this.backboneType;return 4===t||5===t||6===t},qy.prototype.isNucleic=function(){return this.isRna()||this.isDna()},qy.prototype.isRna=function(){return this.chemCompType?lm.includes(this.chemCompType):this.hasAtomWithName(["P","O3'","O3*"],["C4'","C4*"],["O2'","O2*","F2'","F2*"])||Tm.includes(this.resname)&&this.hasAtomWithName(["O2'","O2*","F2'","F2*"])},qy.prototype.isDna=function(){return this.chemCompType?pm.includes(this.chemCompType):this.hasAtomWithName(["P","O3'","O3*"],["C3'","C3*"])&&!this.hasAtomWithName(["O2'","O2*","F2'","F2*"])||Em.includes(this.resname)},qy.prototype.isHetero=function(){return 1===this.hetero},qy.prototype.isIon=function(){return Lm.includes(this.resname)},qy.prototype.isWater=function(){return Rm.includes(this.resname)},qy.prototype.isSaccharide=function(){return this.chemCompType?dm.includes(this.chemCompType):Om.includes(this.resname)},qy.prototype.hasBackboneAtoms=function(t,e){var i=Nm[e];return-1===t?this.hasAtomWithName(i.trace,i.backboneEnd,i.direction1,i.direction2):0===t?this.hasAtomWithName(i.trace,i.direction1,i.direction2):1===t?this.hasAtomWithName(i.trace,i.backboneStart,i.direction1,i.direction2):this.hasAtomWithName(i.trace,i.backboneStart,i.backboneEnd,i.direction1,i.direction2)},qy.prototype.hasProteinBackbone=function(t){return this.isProtein()&&this.hasBackboneAtoms(t,1)},qy.prototype.hasRnaBackbone=function(t){return this.isRna()&&this.hasBackboneAtoms(t,2)},qy.prototype.hasDnaBackbone=function(t){return this.isDna()&&this.hasBackboneAtoms(t,3)},qy.prototype.hasCgProteinBackbone=function(t){return this.atomCount<7&&this.isProtein()&&this.hasBackboneAtoms(t,4)},qy.prototype.hasCgRnaBackbone=function(t){return this.atomCount<11&&this.isRna()&&this.hasBackboneAtoms(t,5)},qy.prototype.hasCgDnaBackbone=function(t){return this.atomCount<11&&this.isDna()&&this.hasBackboneAtoms(t,6)},qy.prototype.hasBackbone=function(t){return this.hasProteinBackbone(t)||this.hasRnaBackbone(t)||this.hasDnaBackbone(t)||this.hasCgProteinBackbone(t)||this.hasCgRnaBackbone(t)||this.hasCgDnaBackbone(t)},qy.prototype.getAtomIndexByName=function(t){var e=this.atomCount,i=this.structure.atomMap,r=this.atomTypeIdList;if(Array.isArray(t))for(var n=0;n<e;++n){var o=r[n];if(t.includes(i.get(o).atomname))return n}else for(var a=0;a<e;++a){var s=r[a];if(t===i.get(s).atomname)return a}},qy.prototype.hasAtomWithName=function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];for(var i=t.length,r=0;r<i;++r)if(void 0!==t[r]&&void 0===this.getAtomIndexByName(t[r]))return!1;return!0},qy.prototype.getBonds=function(e){return void 0===this.bonds&&(this.bonds=function(e){var i=e.structure,r=i.getAtomProxy(),n=i.getAtomProxy(),o=e.atomCount,a=e.atomOffset,s=a+o-1,c=[],u=[],h=[];if(o>500)t.Debug&&ql.warn("more than 500 atoms, skip residue for auto-bonding",e.qualifiedName());else if(o>50)for(var l=new py(e,!0),p=e.isCg()?1.2:2.3,d=a;d<s;++d){r.index=d;for(var f=r.covalent+p+.3,m=l.nearest(r,1/0,f*f),g=m.length,v=0;v<g;++v)n.index=m[v].index,r.index<n.index&&r.connectedTo(n)&&(c.push(r.index-a),u.push(n.index-a),h.push(Iy(r.resname,r.atomname,n.atomname)))}else for(var y=a;y<s;++y){r.index=y;for(var b=y+1;b<=s;++b)n.index=b,r.connectedTo(n)&&(c.push(y-a),u.push(b-a),h.push(Iy(r.resname,r.atomname,n.atomname)))}return{atomIndices1:c,atomIndices2:u,bondOrders:h}}(e)),this.bonds},qy.prototype.getRings=function(){return void 0===this.rings&&this.calculateRings(),this.rings},qy.prototype.getBondGraph=function(){return void 0===this.bondGraph&&this.calculateBondGraph(),this.bondGraph},qy.prototype.getAromatic=function(t){return void 0===this.aromaticAtoms&&this.calculateAromatic(this.structure.getResidueProxy(t.residueIndex)),this.aromaticAtoms},qy.prototype.getAromaticRings=function(t){return void 0===this.aromaticRings&&this.calculateAromatic(t),this.aromaticRings},qy.prototype.calculateBondGraph=function(){for(var t=this.bondGraph={},e=this.getBonds(),i=e.atomIndices1.length,r=e.atomIndices1,n=e.atomIndices2,o=0;o<i;++o){var a=r[o],s=n[o];(t[a]=t[a]||[]).push(s),(t[s]=t[s]||[]).push(a)}},qy.prototype.calculateRings=function(){for(var t=function(t,e){for(var i={count:e,visited:new Int32Array(e),queue:new Int32Array(e),pred:new Int32Array(e),left:new Int32Array(Qy),right:new Int32Array(Qy),color:new Int32Array(e),currentColor:0,rings:[],flags:new Int8Array(e),bonds:t},r=0;r<e;r++)i.visited[r]=-1,i.pred[r]=-1;return i}(this.getBondGraph(),this.atomCount),e=0;e<t.count;e++)t.visited[e]>=0||Jy(t,e);this.rings={flags:t.flags,rings:t.rings}},qy.prototype.isAromatic=function(t){return this.aromaticAtoms=this.getAromatic(t),1===this.aromaticAtoms[t.index-t.residueAtomOffset]},qy.prototype.calculateAromatic=function(t){var e=this,i=this.aromaticAtoms=new Uint8Array(this.atomCount),r=this.getRings().rings,n=r.map(function(i){return function(t){if(t.some(function(t){return!Yy.includes(t.number)}))return!1;var e=0,i=new zg(3,t.length),r=i.data;return t.forEach(function(t){r[e+0]=t.x,r[e+1]=t.y,r[e+2]=t.z,e+=3}),new Yv(i).vecC.length()<Zy}(i.map(function(i){return e.structure.getAtomProxy(i+t.atomOffset)}))}),o=this.aromaticRings=[];r.forEach(function(t,e){n[e]&&(o.push(t),t.forEach(function(t){return i[t]=1}))})},qy.prototype.assignBondReferenceAtomIndices=function(){var t=this.getBondGraph(),e=this.getRings(),i=e.flags,r=e.rings,n=this.bonds,o=n.atomIndices1,a=n.atomIndices2,s=n.bondOrders,c=this.bondReferenceAtomIndices,u=n.atomIndices1.length;c.length=0;for(var h=0;h<u;++h)if(!(s[h]<=1)){var l=o[h],p=a[h];if(i[l]&&i[p]){for(var d=0;d<r.length&&void 0===c[h];++d)for(var f=r[d],m=null,g=!1,v=0;v<f.length;++v){var y=f[v];if(y===l||y===p?g=!0:m=y,g&&null!==m){c[h]=m;break}}if(void 0!==c[h])continue}if(t[l].length>1)for(var b=0;b<t[l].length;++b){var x=t[l][b];if(x!==p){c[h]=x;break}}else if(t[p].length>1)for(var _=0;_<t[p].length;++_){var w=t[p][_];if(w!==l){c[h]=w;break}}else;}},qy.prototype.getBondIndex=function(t,e){for(var i=this.bonds,r=i.atomIndices1,n=i.atomIndices2,o=r.indexOf(t),a=n.indexOf(e),s=a;-1!==o;){for(;-1!==a;){if(o===a)return o;a=n.indexOf(e,a+1)}o=r.indexOf(t,o+1),a=s}},qy.prototype.getBondReferenceAtomIndex=function(t,e){var i=this.getBondIndex(t,e);if(void 0!==i)return 0===this.bondReferenceAtomIndices.length&&this.assignBondReferenceAtomIndices(),this.bondReferenceAtomIndices[i]};var Yy=[5,6,7,8,14,15,16,32,33,50,51,83],Zy=.05;function Ky(t,e,i){if(!(i<e)){for(var r=t.pred,n=t.color,o=t.left,a=t.right,s=++t.currentColor,c=e,u=0;u<Qy&&(n[c]=s,!((c=r[c])<0));u++);var h=0,l=0,p=!1,d=0;c=i;for(var f=0;f<Qy;f++){if(n[c]===s){d=c,p=!0;break}if(a[l++]=c,(c=r[c])<0)break}if(p){c=e;for(var m=0;m<Qy&&(o[h++]=c,d!==c)&&!((c=r[c])<0);m++);for(var g=h+l,v=new Array(g),y=0,b=0;b<h;b++)v[y++]=o[b];for(var x=l-1;x>=0;x--)v[y++]=a[x];for(var _=0;_<g;++_)t.flags[v[_]]=1;t.rings.push(v)}}}function Jy(t,e){var i=t.bonds,r=t.visited,n=t.queue,o=t.pred;r[e]=1,n[0]=e;for(var a=0,s=1;a<s;){var c=n[a++];if(void 0!==i[c])for(var u=i[c].length,h=0;h<u;h++){var l=i[c][h];r[l]>0?o[l]!==c&&o[c]!==l&&Ky(t,c,l):(r[l]=1,n[s++]=l,o[l]=c)}}}var Qy=4;var tb=function(t){this.structure=t,this.dict={},this.list=[]};tb.prototype.add=function(t,e,i,r,n){void 0===r&&(r=""),t=t.toUpperCase();var o,a,s=(o=i,void 0===(a=r)&&(a=""),t+"|"+e.join(",")+"|"+(o?1:0)+"|"+a),c=this.dict[s];if(void 0===c){var u=new qy(this.structure,t,e,i,r,n);c=this.list.length,this.dict[s]=c,this.list.push(u)}return c},tb.prototype.get=function(t){return this.list[t]};var eb=function(t,e){void 0===e&&(e=0),this.structure=t,this.index=e,this.bondStore=t.bondStore,this._v12=new $e,this._v13=new $e,this._ap1=this.structure.getAtomProxy(),this._ap2=this.structure.getAtomProxy(),this._ap3=this.structure.getAtomProxy()},ib={atom1:{configurable:!0},atom2:{configurable:!0},atomIndex1:{configurable:!0},atomIndex2:{configurable:!0},bondOrder:{configurable:!0}};ib.atom1.get=function(){return this.structure.getAtomProxy(this.atomIndex1)},ib.atom2.get=function(){return this.structure.getAtomProxy(this.atomIndex2)},ib.atomIndex1.get=function(){return this.bondStore.atomIndex1[this.index]},ib.atomIndex1.set=function(t){this.bondStore.atomIndex1[this.index]=t},ib.atomIndex2.get=function(){return this.bondStore.atomIndex2[this.index]},ib.atomIndex2.set=function(t){this.bondStore.atomIndex2[this.index]=t},ib.bondOrder.get=function(){return this.bondStore.bondOrder[this.index]},ib.bondOrder.set=function(t){this.bondStore.bondOrder[this.index]=t},eb.prototype.getOtherAtomIndex=function(t){return t===this.atomIndex1?this.atomIndex2:this.atomIndex1},eb.prototype.getOtherAtom=function(t){return this.structure.getAtomProxy(this.getOtherAtomIndex(t.index))},eb.prototype.getReferenceAtomIndex=function(){var t=this._ap1,e=this._ap2;if(t.index=this.atomIndex1,e.index=this.atomIndex2,t.residueIndex===e.residueIndex){var i=t.index-t.residueAtomOffset,r=e.index-e.residueAtomOffset,n=t.residueType.getBondReferenceAtomIndex(i,r);if(void 0!==n)return n+t.residueAtomOffset;console.warn("No reference atom found",t.index,e.index)}},eb.prototype.calculateShiftDir=function(t){void 0===t&&(t=new $e);var e=this._ap1,i=this._ap2,r=this._ap3,n=this._v12,o=this._v13;e.index=this.atomIndex1,i.index=this.atomIndex2;var a=this.getReferenceAtomIndex();n.subVectors(e,i).normalize(),void 0!==a?(r.index=a,o.subVectors(e,r)):o.copy(e),o.normalize();var s=n.dot(o);return 1-Math.abs(s)<1e-5&&(o.set(1,0,0),s=n.dot(o),1-Math.abs(s)<1e-5&&(o.set(0,1,0),s=n.dot(o))),t.copy(o.sub(n.multiplyScalar(s))).normalize()},eb.prototype.qualifiedName=function(){return this.atomIndex1+"="+this.atomIndex2},eb.prototype.clone=function(){return new eb(this.structure,this.index)},eb.prototype.toObject=function(){return{atomIndex1:this.atomIndex1,atomIndex2:this.atomIndex2,bondOrder:this.bondOrder}},Object.defineProperties(eb.prototype,ib);var rb=function(t,e){void 0===e&&(e=0),this.structure=t,this.index=e,this.chainStore=t.chainStore,this.residueStore=t.residueStore,this.atomStore=t.atomStore,this.residueMap=t.residueMap,this.atomMap=t.atomMap},nb={entity:{configurable:!0},entityIndex:{configurable:!0},chain:{configurable:!0},chainIndex:{configurable:!0},atomOffset:{configurable:!0},atomCount:{configurable:!0},atomEnd:{configurable:!0},modelIndex:{configurable:!0},chainname:{configurable:!0},chainid:{configurable:!0},resno:{configurable:!0},sstruc:{configurable:!0},inscode:{configurable:!0},residueType:{configurable:!0},resname:{configurable:!0},hetero:{configurable:!0},moleculeType:{configurable:!0},backboneType:{configurable:!0},backboneStartType:{configurable:!0},backboneEndType:{configurable:!0},traceAtomIndex:{configurable:!0},direction1AtomIndex:{configurable:!0},direction2AtomIndex:{configurable:!0},backboneStartAtomIndex:{configurable:!0},backboneEndAtomIndex:{configurable:!0},rungEndAtomIndex:{configurable:!0},x:{configurable:!0},y:{configurable:!0},z:{configurable:!0}};nb.entity.get=function(){return this.structure.entityList[this.entityIndex]},nb.entityIndex.get=function(){return this.chainStore.entityIndex[this.chainIndex]},nb.chain.get=function(){return this.structure.getChainProxy(this.chainIndex)},nb.chainIndex.get=function(){return this.residueStore.chainIndex[this.index]},nb.chainIndex.set=function(t){this.residueStore.chainIndex[this.index]=t},nb.atomOffset.get=function(){return this.residueStore.atomOffset[this.index]},nb.atomOffset.set=function(t){this.residueStore.atomOffset[this.index]=t},nb.atomCount.get=function(){return this.residueStore.atomCount[this.index]},nb.atomCount.set=function(t){this.residueStore.atomCount[this.index]=t},nb.atomEnd.get=function(){return this.atomOffset+this.atomCount-1},nb.modelIndex.get=function(){return this.chainStore.modelIndex[this.chainIndex]},nb.chainname.get=function(){return this.chainStore.getChainname(this.chainIndex)},nb.chainid.get=function(){return this.chainStore.getChainid(this.chainIndex)},nb.resno.get=function(){return this.residueStore.resno[this.index]},nb.resno.set=function(t){this.residueStore.resno[this.index]=t},nb.sstruc.get=function(){return this.residueStore.getSstruc(this.index)},nb.sstruc.set=function(t){this.residueStore.setSstruc(this.index,t)},nb.inscode.get=function(){return this.residueStore.getInscode(this.index)},nb.inscode.set=function(t){this.residueStore.setInscode(this.index,t)},nb.residueType.get=function(){return this.residueMap.get(this.residueStore.residueTypeId[this.index])},nb.resname.get=function(){return this.residueType.resname},nb.hetero.get=function(){return this.residueType.hetero},nb.moleculeType.get=function(){return this.residueType.moleculeType},nb.backboneType.get=function(){return this.residueType.backboneType},nb.backboneStartType.get=function(){return this.residueType.backboneStartType},nb.backboneEndType.get=function(){return this.residueType.backboneEndType},nb.traceAtomIndex.get=function(){return this.residueType.traceAtomIndex+this.atomOffset},nb.direction1AtomIndex.get=function(){return this.residueType.direction1AtomIndex+this.atomOffset},nb.direction2AtomIndex.get=function(){return this.residueType.direction2AtomIndex+this.atomOffset},nb.backboneStartAtomIndex.get=function(){return this.residueType.backboneStartAtomIndex+this.atomOffset},nb.backboneEndAtomIndex.get=function(){return this.residueType.backboneEndAtomIndex+this.atomOffset},nb.rungEndAtomIndex.get=function(){return this.residueType.rungEndAtomIndex+this.atomOffset},nb.x.get=function(){for(var t=0,e=this.atomOffset;e<=this.atomEnd;++e)t+=this.atomStore.x[e];return t/this.atomCount},nb.y.get=function(){for(var t=0,e=this.atomOffset;e<=this.atomEnd;++e)t+=this.atomStore.y[e];return t/this.atomCount},nb.z.get=function(){for(var t=0,e=this.atomOffset;e<=this.atomEnd;++e)t+=this.atomStore.z[e];return t/this.atomCount},rb.prototype.eachAtom=function(t,e){var i=this.atomCount,r=this.atomOffset,n=this.structure._ap,o=r+i;if(e&&e.atomOnlyTest)for(var a=e.atomOnlyTest,s=r;s<o;++s)n.index=s,a(n)&&t(n);else for(var c=r;c<o;++c)n.index=c,t(n)},rb.prototype.positionToArray=function(t,e){return void 0===t&&(t=[]),void 0===e&&(e=0),t[e+0]=this.x,t[e+1]=this.y,t[e+2]=this.z,t},rb.prototype.isProtein=function(){return 3===this.residueType.moleculeType},rb.prototype.isNucleic=function(){var t=this.residueType.moleculeType;return 4===t||5===t},rb.prototype.isRna=function(){return 4===this.residueType.moleculeType},rb.prototype.isDna=function(){return 5===this.residueType.moleculeType},rb.prototype.isCg=function(){var t=this.residueType.backboneType;return 4===t||5===t||6===t},rb.prototype.isPolymer=function(){if(this.structure.entityList.length>0)return this.entity.isPolymer();var t=this.residueType.moleculeType;return 3===t||4===t||5===t},rb.prototype.isHetero=function(){return 1===this.residueType.hetero},rb.prototype.isWater=function(){return 1===this.residueType.moleculeType},rb.prototype.isIon=function(){return 2===this.residueType.moleculeType},rb.prototype.isSaccharide=function(){return 6===this.residueType.moleculeType},rb.prototype.isHelix=function(){return mm.includes(this.sstruc)},rb.prototype.isSheet=function(){return gm.includes(this.sstruc)},rb.prototype.isTurn=function(){return vm.includes(this.sstruc)&&this.isProtein()},rb.prototype.getAtomType=function(t){return this.atomMap.get(this.atomStore.atomTypeId[t])},rb.prototype.getResname1=function(){return Mm[this.resname.toUpperCase()]||"X"},rb.prototype.getBackboneType=function(t){switch(t){case-1:return this.residueType.backboneStartType;case 1:return this.residueType.backboneEndType;default:return this.residueType.backboneType}},rb.prototype.getAtomIndexByName=function(t){var e=this.residueType.getAtomIndexByName(t);return void 0!==e&&(e+=this.atomOffset),e},rb.prototype.hasAtomWithName=function(t){return this.residueType.hasAtomWithName(t)},rb.prototype.getAtomnameList=function(){console.warn("getAtomnameList - might be expensive");for(var t=this.atomCount,e=this.atomOffset,i=new Array(t),r=0;r<t;++r)i[r]=this.getAtomType(e+r).atomname;return i},rb.prototype.connectedTo=function(t){var e=this.structure.getAtomProxy(this.backboneEndAtomIndex),i=this.structure.getAtomProxy(t.backboneStartAtomIndex);return!(!e||!i)&&e.connectedTo(i)},rb.prototype.getNextConnectedResidue=function(){var t=this.chainStore.residueOffset[this.chainIndex],e=this.chainStore.residueCount[this.chainIndex],i=this.index+1;if(i<t+e){var r=this.structure.getResidueProxy(i);if(this.connectedTo(r))return r}else if(i===t+e){var n=this.structure.getResidueProxy(t);if(this.connectedTo(n))return n}},rb.prototype.getPreviousConnectedResidue=function(t){var e=this.chainStore.residueOffset[this.chainIndex],i=this.index-1;if(i>=e){var r=yh(t,this.structure.getResidueProxy());if(r.index=i,r.connectedTo(this))return r}else if(i===e-1){var n=this.chainStore.residueCount[this.chainIndex],o=yh(t,this.structure.getResidueProxy());if(o.index=e+n-1,o.connectedTo(this))return o}},rb.prototype.getBonds=function(){return this.residueType.getBonds(this)},rb.prototype.getRings=function(){return this.residueType.getRings()},rb.prototype.getAromaticRings=function(){return this.residueType.getAromaticRings(this)},rb.prototype.qualifiedName=function(t){void 0===t&&(t=!1);var e="";return this.resname&&!t&&(e+="["+this.resname+"]"),void 0!==this.resno&&(e+=this.resno),this.inscode&&(e+="^"+this.inscode),this.chain&&(e+=":"+this.chainname),e+="/"+this.modelIndex},rb.prototype.clone=function(){return new rb(this.structure,this.index)},rb.prototype.toObject=function(){return{index:this.index,chainIndex:this.chainIndex,atomOffset:this.atomOffset,atomCount:this.atomCount,resno:this.resno,resname:this.resname,sstruc:this.sstruc}},Object.defineProperties(rb.prototype,nb);var ob=function(t,e,i){this.structure=t,this.residueIndexStart=e,this.residueIndexEnd=i,this.chainStore=t.chainStore,this.residueStore=t.residueStore,this.atomStore=t.atomStore,this.residueCount=i-e+1;var r=this.structure.getResidueProxy(this.residueIndexStart),n=this.structure.getResidueProxy(this.residueIndexEnd);this.isPrevConnected=void 0!==r.getPreviousConnectedResidue();var o=n.getNextConnectedResidue();this.isNextConnected=void 0!==o,this.isNextNextConnected=void 0!==o&&void 0!==o.getNextConnectedResidue(),this.isCyclic=n.connectedTo(r),this.__residueProxy=this.structure.getResidueProxy()},ab={chainIndex:{configurable:!0},modelIndex:{configurable:!0},chainname:{configurable:!0}};ab.chainIndex.get=function(){return this.residueStore.chainIndex[this.residueIndexStart]},ab.modelIndex.get=function(){return this.chainStore.modelIndex[this.chainIndex]},ab.chainname.get=function(){return this.chainStore.getChainname(this.chainIndex)},ob.prototype.isProtein=function(){return this.__residueProxy.index=this.residueIndexStart,this.__residueProxy.isProtein()},ob.prototype.isCg=function(){return this.__residueProxy.index=this.residueIndexStart,this.__residueProxy.isCg()},ob.prototype.isNucleic=function(){return this.__residueProxy.index=this.residueIndexStart,this.__residueProxy.isNucleic()},ob.prototype.getMoleculeType=function(){return this.__residueProxy.index=this.residueIndexStart,this.__residueProxy.moleculeType},ob.prototype.getBackboneType=function(t){return this.__residueProxy.index=this.residueIndexStart,this.__residueProxy.getBackboneType(t)},ob.prototype.getAtomIndexByType=function(t,e){this.isCyclic?-1===t?t=this.residueCount-1:t===this.residueCount&&(t=0):(-1!==t||this.isPrevConnected||(t+=1),t!==this.residueCount||this.isNextNextConnected||(t-=1));var i,r=this.__residueProxy;switch(r.index=this.residueIndexStart+t,e){case"trace":i=r.traceAtomIndex;break;case"direction1":i=r.direction1AtomIndex;break;case"direction2":i=r.direction2AtomIndex;break;default:i=r.getAtomIndexByName(e)}return i},ob.prototype.eachAtom=function(t,e){this.eachResidue(function(i){i.eachAtom(t,e)})},ob.prototype.eachAtomN=function(t,e,i){for(var r=this.residueCount,n=new Array(t),o=0;o<t;++o)n[o]=this.structure.getAtomProxy(this.getAtomIndexByType(o,i));e.apply(this,n);for(var a=t;a<r;++a){for(var s=1;s<t;++s)n[s-1].index=n[s].index;n[t-1].index=this.getAtomIndexByType(a,i),e.apply(this,n)}},ob.prototype.eachResidue=function(t){for(var e=this.structure.getResidueProxy(),i=this.residueCount,r=this.residueIndexStart,n=0;n<i;++n)e.index=r+n,t(e)},ob.prototype.qualifiedName=function(){var t=this.structure.getResidueProxy(this.residueIndexStart),e=this.structure.getResidueProxy(this.residueIndexEnd);return t.qualifiedName()+" - "+e.qualifiedName()},Object.defineProperties(ob.prototype,ab);var sb=function(t,e){void 0===e&&(e=0),this.structure=t,this.index=e,this.chainStore=t.chainStore,this.residueStore=t.residueStore},cb={entity:{configurable:!0},model:{configurable:!0},entityIndex:{configurable:!0},modelIndex:{configurable:!0},residueOffset:{configurable:!0},residueCount:{configurable:!0},residueEnd:{configurable:!0},atomOffset:{configurable:!0},atomEnd:{configurable:!0},atomCount:{configurable:!0},chainname:{configurable:!0},chainid:{configurable:!0}};cb.entity.get=function(){return this.structure.entityList[this.entityIndex]},cb.model.get=function(){return this.structure.getModelProxy(this.modelIndex)},cb.entityIndex.get=function(){return this.chainStore.entityIndex[this.index]},cb.entityIndex.set=function(t){this.chainStore.entityIndex[this.index]=t},cb.modelIndex.get=function(){return this.chainStore.modelIndex[this.index]},cb.modelIndex.set=function(t){this.chainStore.modelIndex[this.index]=t},cb.residueOffset.get=function(){return this.chainStore.residueOffset[this.index]},cb.residueOffset.set=function(t){this.chainStore.residueOffset[this.index]=t},cb.residueCount.get=function(){return this.chainStore.residueCount[this.index]},cb.residueCount.set=function(t){this.chainStore.residueCount[this.index]=t},cb.residueEnd.get=function(){return this.residueOffset+this.residueCount-1},cb.atomOffset.get=function(){return this.residueStore.atomOffset[this.residueOffset]},cb.atomEnd.get=function(){return this.residueStore.atomOffset[this.residueEnd]+this.residueStore.atomCount[this.residueEnd]-1},cb.atomCount.get=function(){return 0===this.residueCount?0:this.atomEnd-this.atomOffset+1},cb.chainname.get=function(){return this.chainStore.getChainname(this.index)},cb.chainname.set=function(t){this.chainStore.setChainname(this.index,t)},cb.chainid.get=function(){return this.chainStore.getChainid(this.index)},cb.chainid.set=function(t){this.chainStore.setChainid(this.index,t)},sb.prototype.eachAtom=function(t,e){this.eachResidue(function(i){i.eachAtom(t,e)},e)},sb.prototype.eachResidue=function(t,e){var i=this.residueCount,r=this.residueOffset,n=this.structure._rp,o=r+i;if(e&&e.test){var a=e.residueOnlyTest;if(a)for(var s=r;s<o;++s)n.index=s,a(n)&&t(n);else for(var c=r;c<o;++c)n.index=c,t(n)}else for(var u=r;u<o;++u)n.index=u,t(n)},sb.prototype.eachResidueN=function(t,e){var i=this.residueCount,r=this.residueOffset,n=r+i;if(!(i<t)){for(var o=new Array(t),a=0;a<t;++a)o[a]=this.structure.getResidueProxy(r+a);e.apply(this,o);for(var s=r+t;s<n;++s){for(var c=0;c<t;++c)o[c].index+=1;e.apply(this,o)}}},sb.prototype.eachPolymer=function(t,e){for(var i=0,r=0,n=e?e.residueOnlyTest:void 0,o=this.model.structure,a=this.residueCount,s=this.residueOffset,c=s+a,u=this.structure.getResidueProxy(),h=this.structure.getResidueProxy(s),l=this.structure.getAtomProxy(),p=this.structure.getAtomProxy(),d=!0,f=s+1;f<c;++f){u.index=h.index,h.index=f;var m=d?u.backboneEndType:u.backboneType,g=h.backboneType;d&&(i=u.index,d=!1),r=h.index,m!==um&&m===g?(l.index=u.backboneEndAtomIndex,p.index=h.backboneStartAtomIndex,l&&p&&l.connectedTo(p)&&(!n||n(u)&&n(h))||(u.index-i>1&&t(new ob(o,i,u.index)),i=r)):(m!==um&&u.index-i>1&&t(new ob(o,i,u.index)),i=r)}r-i>1&&this.structure.getResidueProxy(i).backboneEndType&&t(new ob(o,i,r))},sb.prototype.qualifiedName=function(){return":"+this.chainname+"/"+this.modelIndex},sb.prototype.clone=function(){return new sb(this.structure,this.index)},sb.prototype.toObject=function(){return{index:this.index,residueOffset:this.residueOffset,residueCount:this.residueCount,chainname:this.chainname}},Object.defineProperties(sb.prototype,cb);var ub=function(t,e){void 0===e&&(e=0),this.structure=t,this.index=e,this.modelStore=t.modelStore,this.chainStore=t.chainStore,this.residueStore=t.residueStore},hb={chainOffset:{configurable:!0},chainCount:{configurable:!0},residueOffset:{configurable:!0},atomOffset:{configurable:!0},chainEnd:{configurable:!0},residueEnd:{configurable:!0},atomEnd:{configurable:!0},residueCount:{configurable:!0},atomCount:{configurable:!0}};hb.chainOffset.get=function(){return this.modelStore.chainOffset[this.index]},hb.chainOffset.set=function(t){this.modelStore.chainOffset[this.index]=t},hb.chainCount.get=function(){return this.modelStore.chainCount[this.index]},hb.chainCount.set=function(t){this.modelStore.chainCount[this.index]=t},hb.residueOffset.get=function(){return this.chainStore.residueOffset[this.chainOffset]},hb.atomOffset.get=function(){return this.residueStore.atomOffset[this.residueOffset]},hb.chainEnd.get=function(){return this.chainOffset+this.chainCount-1},hb.residueEnd.get=function(){return this.chainStore.residueOffset[this.chainEnd]+this.chainStore.residueCount[this.chainEnd]-1},hb.atomEnd.get=function(){return this.residueStore.atomOffset[this.residueEnd]+this.residueStore.atomCount[this.residueEnd]-1},hb.residueCount.get=function(){return 0===this.chainCount?0:this.residueEnd-this.residueOffset+1},hb.atomCount.get=function(){return 0===this.residueCount?0:this.atomEnd-this.atomOffset+1},ub.prototype.eachAtom=function(t,e){this.eachChain(function(i){i.eachAtom(t,e)},e)},ub.prototype.eachResidue=function(t,e){this.eachChain(function(i){i.eachResidue(t,e)},e)},ub.prototype.eachPolymer=function(t,e){if(e&&e.chainOnlyTest){var i=e.chainOnlyTest;this.eachChain(function(r){i(r)&&r.eachPolymer(t,e)})}else this.eachChain(function(i){i.eachPolymer(t,e)})},ub.prototype.eachChain=function(t,e){var i=this.chainCount,r=this.chainOffset,n=this.structure._cp,o=r+i;if(e&&e.test){var a=e.chainOnlyTest;if(a)for(var s=r;s<o;++s)n.index=s,a(n)&&t(n);else for(var c=r;c<o;++c)n.index=c,t(n)}else for(var u=r;u<o;++u)n.index=u,t(n)},ub.prototype.qualifiedName=function(){return"/"+this.index},ub.prototype.clone=function(){return new ub(this.structure,this.index)},ub.prototype.toObject=function(){return{index:this.index,chainOffset:this.chainOffset,chainCount:this.chainCount}},Object.defineProperties(ub.prototype,hb);var lb=function(t,e){void 0===t&&(t=""),void 0===e&&(e=""),this.signals={refreshed:new nl},this.init(t,e)},pb={type:{configurable:!0}};lb.prototype.init=function(t,e){this.name=t,this.path=e,this.title="",this.id="",this.data={structure:this,"@spatialLookup":void 0,"@valenceModel":void 0},this.header={},this.extraData={},this.atomSetCache={},this.atomSetDict={},this.biomolDict={},this.entityList=[],this.unitcell=void 0,this.frames=[],this.boxes=[],this.validation=void 0,this.bondStore=new Jv(0),this.backboneBondStore=new Jv(0),this.rungBondStore=new Jv(0),this.atomStore=new Qv(0),this.residueStore=new ty(0),this.chainStore=new ey(0),this.modelStore=new iy(0),this.atomMap=new Xy(this),this.residueMap=new tb(this),this.bondHash=void 0,this.spatialHash=void 0,this.atomSet=void 0,this.bondSet=void 0,this.center=new $e,this.boundingBox=new xr,this._bp=this.getBondProxy(),this._ap=this.getAtomProxy(),this._rp=this.getResidueProxy(),this._cp=this.getChainProxy()},pb.type.get=function(){return"Structure"},lb.prototype.finalizeAtoms=function(){this.atomSet=this.getAtomSet(),this.atomCount=this.atomStore.count,this.boundingBox=this.getBoundingBox(void 0,this.boundingBox),this.center=this.boundingBox.getCenter(),this.spatialHash=new Yf(this.atomStore,this.boundingBox)},lb.prototype.finalizeBonds=function(){for(var t in this.bondSet=this.getBondSet(),this.bondCount=this.bondStore.count,this.bondHash=new function(t,e){var i=tm({nodeArray1:t.atomIndex1,nodeArray2:t.atomIndex2,edgeCount:t.count,nodeCount:e});this.countArray=i.countArray,this.offsetArray=i.offsetArray,this.indexArray=i.indexArray}(this.bondStore,this.atomStore.count),this.atomSetCache={},this.atomSetDict.rung||(this.atomSetDict.rung=this.getAtomSet(!1)),this.atomSetDict)this.atomSetCache["__"+t]=this.atomSetDict[t].clone()},lb.prototype.getBondProxy=function(t){return new eb(this,t)},lb.prototype.getAtomProxy=function(t){return new sy(this,t)},lb.prototype.getResidueProxy=function(t){return new rb(this,t)},lb.prototype.getChainProxy=function(t){return new sb(this,t)},lb.prototype.getModelProxy=function(t){return new ub(this,t)},lb.prototype.getBondSet=function(){var t=this.bondStore.count,e=new Qf(t),i=this.atomSet;if(i)if(i.isAllSet())e.setAll();else if(i.isAllClear())e.clearAll();else for(var r=this.getBondProxy(),n=0;n<t;++n)r.index=n,i.isSet(r.atomIndex1,r.atomIndex2)&&e.set(r.index);else e.setAll();return e},lb.prototype.getBackboneBondSet=function(){var t=this.backboneBondStore.count,e=new Qf(t),i=this.atomSetCache.__backbone;if(i){var r=this.getBondProxy();r.bondStore=this.backboneBondStore;for(var n=0;n<t;++n)r.index=n,i.isSet(r.atomIndex1,r.atomIndex2)&&e.set(r.index)}else e.setAll();return e},lb.prototype.getRungBondSet=function(){var t=this.rungBondStore.count,e=new Qf(t),i=this.atomSetCache.__rung;if(i){var r=this.getBondProxy();r.bondStore=this.rungBondStore;for(var n=0;n<t;++n)r.index=n,i.isSet(r.atomIndex1,r.atomIndex2)&&e.set(r.index)}else e.setAll();return e},lb.prototype.getAtomSet=function(t){var e=this.atomStore.count;if(void 0===t)return new Qf(e,!0);if(t instanceof Qf)return t;if(!0===t)return new Qf(e,!0);if(t&&t.test){var i=t.string;if(i in this.atomSetCache)return this.atomSetCache[i];if(""===i)return new Qf(e,!0);var r=new Qf(e);return this.eachAtom(function(t){r.set(t.index)},t),this.atomSetCache[i]=r,r}return!1===t?new Qf(e):new Qf(e,!0)},lb.prototype.getAtomSetWithinSelection=function(t,e){var i=this.spatialHash,r=this.getAtomSet(!1),n=this.getAtomProxy();return i?(this.getAtomSet(t).forEach(function(t){n.index=t,i.within(n.x,n.y,n.z,e).forEach(function(t){r.set(t)})}),r):r},lb.prototype.getAtomSetWithinPoint=function(t,e){var i=t,r=this.getAtomSet(!1);return this.spatialHash?(this.spatialHash.within(i.x,i.y,i.z,e).forEach(function(t){r.set(t)}),r):r},lb.prototype.getAtomSetWithinVolume=function(t,e,i,r,n){var o=new Zv(t,i,r,n),a=o.getDataPosition(),s=a.length,c=o.matrix.getMaxScaleOnAxis(),u=this.getAtomSet(!1);if(!this.spatialHash)return u;for(var h=0;h<s;h+=3)this.spatialHash.within(a[h],a[h+1],a[h+2],c).forEach(function(t){u.set(t)});return u},lb.prototype.getAtomSetWithinGroup=function(t){var e=this.atomStore.residueIndex,i=this.getAtomSet(!1),r=this.getResidueProxy();return this.getAtomSet(t).forEach(function(t){r.index=e[t];for(var n=r.atomOffset;n<=r.atomEnd;++n)i.set(n)}),i},lb.prototype.getSelection=function(){return!1},lb.prototype.getStructure=function(){return this},lb.prototype.eachEntity=function(t,e){this.entityList.forEach(function(i){void 0!==e&&i.getEntityType()!==e||t(i)})},lb.prototype.eachBond=function(t,e){var i,r=this.getBondProxy();if(e&&e.test&&(i=this.getBondSet(),this.bondSet&&i.intersection(this.bondSet)),i)i.forEach(function(e){r.index=e,t(r)});else for(var n=this.bondStore.count,o=0;o<n;++o)r.index=o,t(r)},lb.prototype.eachAtom=function(t,e){if(e&&e.test)this.eachModel(function(i){i.eachAtom(t,e)},e);else for(var i=this.atomStore.count,r=this.getAtomProxy(),n=0;n<i;++n)r.index=n,t(r)},lb.prototype.eachResidue=function(t,e){if(e&&e.test){var i=this.modelStore.count,r=this.getModelProxy(),n=e.modelOnlyTest;if(n)for(var o=0;o<i;++o)r.index=o,n(r)&&r.eachResidue(t,e);else for(var a=0;a<i;++a)r.index=a,r.eachResidue(t,e)}else for(var s=this.residueStore.count,c=this.getResidueProxy(),u=0;u<s;++u)c.index=u,t(c)},lb.prototype.eachResidueN=function(t,e){var i=this.residueStore.count;if(!(i<t)){for(var r=new Array(t),n=0;n<t;++n)r[n]=this.getResidueProxy(n);e.apply(this,r);for(var o=t;o<i;++o){for(var a=0;a<t;++a)r[a].index+=1;e.apply(this,r)}}},lb.prototype.eachPolymer=function(t,e){if(e&&e.modelOnlyTest){var i=e.modelOnlyTest;this.eachModel(function(r){i(r)&&r.eachPolymer(t,e)})}else this.eachModel(function(i){i.eachPolymer(t,e)})},lb.prototype.eachChain=function(t,e){if(e&&e.test)this.eachModel(function(i){i.eachChain(t,e)});else for(var i=this.chainStore.count,r=this.getChainProxy(),n=0;n<i;++n)r.index=n,t(r)},lb.prototype.eachModel=function(t,e){var i=this.modelStore.count,r=this.getModelProxy();if(e&&e.test){var n=e.modelOnlyTest;if(n)for(var o=0;o<i;++o)r.index=o,n(r)&&t(r);else for(var a=0;a<i;++a)r.index=a,t(r)}else for(var s=0;s<i;++s)r.index=s,t(r)},lb.prototype.getAtomData=function(t){var e=Object.assign({},t);e.colorParams&&(e.colorParams.structure=this.getStructure());var i,r,n=e.what,o=yh(e.atomSet,this.atomSet),a={},s=this.getAtomProxy(),c=o.getSize();n&&!n.position||(a.position=new Float32Array(3*c)),n&&!n.color||!e.colorParams||(a.color=new Float32Array(3*c),r=Jl.getScheme(e.colorParams)),n&&!n.picking||(a.picking=new fg(new Float32Array(c),this.getStructure())),n&&!n.radius||(a.radius=new Float32Array(c),i=new Wv(e.radiusParams)),n&&!n.index||(a.index=new Uint32Array(c));var u=a.position,h=a.color,l=a.picking,p=a.radius,d=a.index;return o.forEach(function(t,e){var n=3*e;s.index=t,u&&s.positionToArray(u,n),h&&r.atomColorToArray(s,h,n),l&&(l.array[e]=t),p&&(p[e]=i.atomRadius(s)),d&&(d[e]=t)}),a},lb.prototype.getBondData=function(t){var e=Object.assign({},t);e.colorParams&&(e.colorParams.structure=this.getStructure());var i,r,n=e.what,o=yh(e.bondSet,this.bondSet),a=yh(e.multipleBond,"off"),s="off"!==a,c="offset"===a,u=yh(e.bondScale,.4),h=yh(e.bondSpacing,1),l={},p=this.getBondProxy();e.bondStore&&(p.bondStore=e.bondStore);var d,f=this.getAtomProxy(),m=this.getAtomProxy();if(s){var g=p.bondStore.bondOrder;d=0,o.forEach(function(t){d+=g[t]})}else d=o.getSize();n&&!n.position||(l.position1=new Float32Array(3*d),l.position2=new Float32Array(3*d)),n&&!n.color||!e.colorParams||(l.color=new Float32Array(3*d),l.color2=new Float32Array(3*d),r=Jl.getScheme(e.colorParams)),n&&!n.picking||(l.picking=new gg(new Float32Array(d),this.getStructure(),e.bondStore)),(!n||n.radius||s&&n.position)&&(i=new Wv(e.radiusParams)),n&&!n.radius||(l.radius=new Float32Array(d),e.radius2&&(l.radius2=new Float32Array(d)));var v,y,b,x,_,w,S=l.position1,A=l.position2,M=l.color,P=l.color2,T=l.picking,E=l.radius,C=l.radius2,I=0,R=new $e,L=new $e,O=new $e;return o.forEach(function(t){if(y=3*I,p.index=t,f.index=p.atomIndex1,m.index=p.atomIndex2,x=p.bondOrder,S)if(s&&x>1){var e=i.atomRadius(f);w=e*u/(.5*x),p.calculateShiftDir(O),c?(_=2*h*e,O.multiplyScalar(_),O.negate(),L.subVectors(m,f).multiplyScalar(Math.max(.1,_/1.88)),f.positionToArray(S,y),m.positionToArray(A,y),x>=2&&(R.addVectors(f,O).add(L).toArray(S,y+3),R.addVectors(m,O).sub(L).toArray(A,y+3),x>=3&&(R.subVectors(f,O).add(L).toArray(S,y+6),R.subVectors(m,O).sub(L).toArray(A,y+6)))):(_=(h-u)*e,O.multiplyScalar(_),2===x?(R.addVectors(f,O).toArray(S,y),R.subVectors(f,O).toArray(S,y+3),R.addVectors(m,O).toArray(A,y),R.subVectors(m,O).toArray(A,y+3)):3===x?(f.positionToArray(S,y),R.addVectors(f,O).toArray(S,y+3),R.subVectors(f,O).toArray(S,y+6),m.positionToArray(A,y),R.addVectors(m,O).toArray(A,y+3),R.subVectors(m,O).toArray(A,y+6)):(f.positionToArray(S,y),m.positionToArray(A,y)))}else f.positionToArray(S,y),m.positionToArray(A,y);if(M&&P&&(r.bondColorToArray(p,1,M,y),r.bondColorToArray(p,0,P,y),s&&x>1))for(v=1;v<x;++v)Xp(M,y,b=3*v+y,3),Xp(P,y,b,3);if(T&&(T.array[I]=t,s&&x>1))for(v=1;v<x;++v)T.array[I+v]=t;if(E&&(E[I]=i.atomRadius(f),s&&x>1))for(w=E[I]*u/(c?1:.5*x),v=c?1:0;v<x;++v)E[I+v]=w;if(C&&(C[I]=i.atomRadius(m),s&&x>1))for(w=C[I]*u/(c?1:.5*x),v=c?1:0;v<x;++v)C[I+v]=w;I+=s?x:1}),l},lb.prototype.getBackboneAtomData=function(t){return t=Object.assign({atomSet:this.atomSetCache.__backbone},t),this.getAtomData(t)},lb.prototype.getBackboneBondData=function(t){return t=Object.assign({bondSet:this.getBackboneBondSet(),bondStore:this.backboneBondStore},t),this.getBondData(t)},lb.prototype.getRungAtomData=function(t){return t=Object.assign({atomSet:this.atomSetCache.__rung},t),this.getAtomData(t)},lb.prototype.getRungBondData=function(t){return t=Object.assign({bondSet:this.getRungBondSet(),bondStore:this.rungBondStore},t),this.getBondData(t)},lb.prototype.getBoundingBox=function(e,i){t.Debug&&ql.time("getBoundingBox"),i=i||new xr;var r=1/0,n=1/0,o=1/0,a=-1/0,s=-1/0,c=-1/0;return this.eachAtom(function(t){var e=t.x,i=t.y,u=t.z;e<r&&(r=e),i<n&&(n=i),u<o&&(o=u),e>a&&(a=e),i>s&&(s=i),u>c&&(c=u)},e),i.min.set(r,n,o),i.max.set(a,s,c),t.Debug&&ql.timeEnd("getBoundingBox"),i},lb.prototype.getPrincipalAxes=function(e){t.Debug&&ql.time("getPrincipalAxes");var i=0,r=new zg(3,this.atomCount),n=r.data;return this.eachAtom(function(t){n[i+0]=t.x,n[i+1]=t.y,n[i+2]=t.z,i+=3},e),t.Debug&&ql.timeEnd("getPrincipalAxes"),new Yv(r)},lb.prototype.atomCenter=function(t){return t?this.getBoundingBox(t).getCenter():this.center.clone()},lb.prototype.hasCoords=function(){if(void 0===this._hasCoords){var t=this.atomStore;this._hasCoords=0!==Yp(t.x)||0!==qp(t.x)||0!==Yp(t.y)||0!==qp(t.y)||0!==Yp(t.z)||0!==qp(t.z)}return this._hasCoords},lb.prototype.getSequence=function(t){var e=[],i=this.getResidueProxy();return this.eachAtom(function(t){i.index=t.residueIndex,t.index===i.traceAtomIndex&&e.push(i.getResname1())},t),e},lb.prototype.getAtomIndices=function(t){if(t&&t.string){var e=[];return this.eachAtom(function(t){e.push(t.index)},t),new Uint32Array(e)}return this.getAtomData({what:{index:!0}}).index},lb.prototype.getChainnameCount=function(t){var e=new Set;return this.eachChain(function(t){t.residueCount&&e.add(t.chainname)},t),e.size},lb.prototype.updatePosition=function(t){var e=0;this.eachAtom(function(i){i.positionFromArray(t,e),e+=3},void 0),this._hasCoords=void 0},lb.prototype.refreshPosition=function(){this.getBoundingBox(void 0,this.boundingBox),this.boundingBox.getCenter(this.center),this.spatialHash=new Yf(this.atomStore,this.boundingBox)},lb.prototype.dispose=function(){this.frames&&(this.frames.length=0),this.boxes&&(this.boxes.length=0),this.bondStore.dispose(),this.backboneBondStore.dispose(),this.rungBondStore.dispose(),this.atomStore.dispose(),this.residueStore.dispose(),this.chainStore.dispose(),this.modelStore.dispose(),delete this.bondStore,delete this.atomStore,delete this.residueStore,delete this.chainStore,delete this.modelStore,delete this.frames,delete this.boxes,delete this.bondSet,delete this.atomSet},Object.defineProperties(lb.prototype,pb);var db=new xr,fb=[Gf,Ff,Vf,jf,Hf,zf,Bf,Uf,Wf,$f,Xf,qf],mb={aspectRatio:1.5,sphereDetail:2,radialSegments:50,disableImpostor:!1,openEnded:!1,dashedCylinder:!1,labelParams:{},pointSize:2,sizeAttenuation:!1,useTexture:!0,lineWidth:2},gb=function(t,e){var i=this;void 0===t&&(t="shape"),void 0===e&&(e={}),this.boundingBox=new xr,this.bufferList=[],this.meshCount=0,this._primitiveData={},this.name=t,this.parameters=bh(e,mb),fb.forEach(function(t){Object.keys(t.fields).forEach(function(e){i._primitiveData[t.getShapeKey(e)]=[]}),i._primitiveData[t.getShapeKey("name")]=[]})},vb={center:{configurable:!0},type:{configurable:!0}};gb.prototype.addBuffer=function(t){this.bufferList.push(t);var e=t.geometry;return e.boundingBox||e.computeBoundingBox(),this.boundingBox.union(e.boundingBox),this},gb.prototype.addMesh=function(t,e,i,r,n){t=Bh(t),e=Bh(e),Array.isArray(i)&&(i=Rh(i,t.length)),r&&(r=Bh(r));var o={position:t,color:e,index:i,normal:r},a=new Mg(this,Object.assign({serial:this.meshCount,name:n},o)),s=new bv(Object.assign({picking:a},o));return this.bufferList.push(s),db.setFromArray(t),this.boundingBox.union(db),this.meshCount+=1,this},gb.prototype.addSphere=function(t,e,i,r){return Bf.objectToShape(this,{position:t,color:e,radius:i,name:r}),this},gb.prototype.addEllipsoid=function(t,e,i,r,n,o){return Hf.objectToShape(this,{position:t,color:e,radius:i,majorAxis:r,minorAxis:n,name:o}),this},gb.prototype.addTorus=function(t,e,i,r,n,o){return $f.objectToShape(this,{position:t,color:e,radius:i,majorAxis:r,minorAxis:n,name:o}),this},gb.prototype.addCylinder=function(t,e,i,r,n){return jf.objectToShape(this,{position1:t,position2:e,color:i,radius:r,name:n}),this},gb.prototype.addCone=function(t,e,i,r,n){return Vf.objectToShape(this,{position1:t,position2:e,color:i,radius:r,name:n}),this},gb.prototype.addArrow=function(t,e,i,r,n){return Gf.objectToShape(this,{position1:t,position2:e,color:i,radius:r,name:n}),this},gb.prototype.addBox=function(t,e,i,r,n,o){return Ff.objectToShape(this,{position:t,color:e,size:i,heightAxis:r,depthAxis:n,name:o}),this},gb.prototype.addOctahedron=function(t,e,i,r,n,o){return zf.objectToShape(this,{position:t,color:e,size:i,heightAxis:r,depthAxis:n,name:o}),this},gb.prototype.addTetrahedron=function(t,e,i,r,n,o){return Uf.objectToShape(this,{position:t,color:e,size:i,heightAxis:r,depthAxis:n,name:o}),this},gb.prototype.addText=function(t,e,i,r){return Wf.objectToShape(this,{position:t,color:e,size:i,text:r}),this},gb.prototype.addPoint=function(t,e,i){return Xf.objectToShape(this,{position:t,color:e,name:i}),this},gb.prototype.addWideline=function(t,e,i,r){return qf.objectToShape(this,{position1:t,position2:e,color:i,name:r}),this},gb.prototype.addLabel=function(t,e,i,r){return console.warn("Shape.addLabel is deprecated, use .addText instead"),this.addText(t,e,i,r)},gb.prototype.getBufferList=function(){var t=this,e=[];return fb.forEach(function(i){t._primitiveData[i.getShapeKey("color")].length&&e.push(i.bufferFromShape(t,t.parameters))}),this.bufferList.concat(e)},gb.prototype.dispose=function(){var t=this;this.bufferList.forEach(function(t){t.dispose()}),this.bufferList.length=0,fb.forEach(function(e){Object.keys(e.fields).forEach(function(i){t._primitiveData[e.getShapeKey(i)].length=0}),t._primitiveData[e.getShapeKey("name")].length=0})},vb.center.get=function(){return this._center||(this._center=this.boundingBox.getCenter()),this._center},vb.type.get=function(){return"Shape"},Object.defineProperties(gb.prototype,vb);var yb=function(t){function e(e,i,r){Array.isArray(e)||(e=[e]),t.call(this,e,i,r),this.type="buffer",this.parameters=Object.assign({},this.parameters,{colorScheme:null,colorScale:null,colorValue:null,colorDomain:null,colorMode:null}),this.buffer=e,this.init(r)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.init=function(e){t.prototype.init.call(this,e),this.build()},e.prototype.create=function(){this.bufferList.push.apply(this.bufferList,this.buffer)},e.prototype.attach=function(t){var e=this;this.bufferList.forEach(function(t){e.viewer.add(t),t.setParameters(e.getBufferParams())}),this.setVisibility(this.visible),t()},e}(af),bb=new Ve,xb=new We;var _b=function(t){function e(e,i,r){var n,o,a,s,c,u,h,l,p,d,f;void 0===i&&(i={}),t.call(this,(n=e,s=(o=r).attributes.position.array,c=o.index?o.index.array:void 0,u=n.position.length/3,h=s.length/3,l=u*h,p=new Float32Array(3*l),d=new Float32Array(3*l),f=new Float32Array(3*l),c&&(a=Rh(u*c.length,l)),{position:p,color:f,index:a,normal:d,primitiveId:n.primitiveId||Hp(u,h),picking:n.picking}),i),this.updateNormals=!1;var m=r.attributes.position.array,g=r.attributes.normal.array,v=r.index?r.index.array:void 0;this.geoPosition=m,this.geoNormal=g,this.geoIndex=v,this.positionCount=e.position.length/3,this.geoPositionCount=m.length/3,this.transformedGeoPosition=new Float32Array(3*this.geoPositionCount),this.transformedGeoNormal=new Float32Array(3*this.geoPositionCount);var y=this.geometry.attributes;this.meshPosition=y.position.array,this.meshColor=y.color.array,this.meshNormal=y.normal.array,this.setAttributes(e),v&&(this.meshIndex=this.geometry.getIndex().array,this.makeIndex())}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.setAttributes=function(t,e){void 0===t&&(t={}),void 0===e&&(e=!1);var i,r,n,o,a,s,c,u,h,l=this.geometry.attributes,p=this.updateNormals;t.position&&(i=t.position,n=this.geoPosition,c=this.meshPosition,a=this.transformedGeoPosition,l.position.needsUpdate=!0,(p||e)&&(o=this.geoNormal,h=this.meshNormal,s=this.transformedGeoNormal,l.normal.needsUpdate=!0)),t.color&&(r=t.color,u=this.meshColor,l.color.needsUpdate=!0);for(var d=this.positionCount,f=this.geoPositionCount,m=0;m<d;++m){var g=void 0,v=void 0,y=m*f*3,b=3*m;if(i&&a&&c&&h&&n&&o&&(a.set(n),bb.makeTranslation(i[b],i[b+1],i[b+2]),this.applyPositionTransform(bb,m,b),pf(bb.elements,a),c.set(a,y),p&&s?(s.set(o),xb.getNormalMatrix(bb),df(xb.elements,s),h.set(s,y)):e&&h.set(o,y)),r&&u)for(g=0;g<f;++g)u[v=y+3*g]=r[b],u[v+1]=r[b+1],u[v+2]=r[b+2]}},e.prototype.makeIndex=function(){var t=this.geoIndex,e=this.meshIndex;if(t)for(var i=this.positionCount,r=this.geoPositionCount,n=3*(t.length/3),o=0;o<i;++o){var a=o*n,s=a+n;e.set(t,a);for(var c=a;c<s;++c)e[c]+=o*r}},e}(bv),wb=new $e,Sb=Object.assign({sphereDetail:1},mv),Ab=function(t){function e(e,i){void 0===i&&(i={}),t.call(this,e,i,new _a(1,yh(i.sphereDetail,1))),this.setAttributes(e,!0)}t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e;var i={defaultParameters:{configurable:!0}};return i.defaultParameters.get=function(){return Sb},e.prototype.applyPositionTransform=function(t,e){var i=this._radius[e];wb.set(i,i,i),t.scale(wb)},e.prototype.setAttributes=function(e,i){void 0===e&&(e={}),e.radius&&(this._radius=e.radius),t.prototype.setAttributes.call(this,e,i)},Object.defineProperties(e.prototype,i),e}(_b);ip.add("shader/SphereImpostor.vert","uniform mat4 projectionMatrixInverse;\nuniform float clipNear;\nvarying float vRadius;\nvarying float vRadiusSq;\nvarying vec3 vPoint;\nvarying vec3 vPointViewPosition;\nattribute vec2 mapping;\nattribute float radius;\n#ifdef PICKING\n#include unpack_color\nattribute float primitiveId;\nvarying vec3 vPickingColor;\n#else\n#include color_pars_vertex\n#endif\n#include matrix_scale\nconst mat4 D = mat4(\n1.0, 0.0, 0.0, 0.0,\n0.0, 1.0, 0.0, 0.0,\n0.0, 0.0, 1.0, 0.0,\n0.0, 0.0, 0.0, -1.0\n);\nmat4 transpose( in mat4 inMatrix ) {\nvec4 i0 = inMatrix[0];\nvec4 i1 = inMatrix[1];\nvec4 i2 = inMatrix[2];\nvec4 i3 = inMatrix[3];\nmat4 outMatrix = mat4(\nvec4(i0.x, i1.x, i2.x, i3.x),\nvec4(i0.y, i1.y, i2.y, i3.y),\nvec4(i0.z, i1.z, i2.z, i3.z),\nvec4(i0.w, i1.w, i2.w, i3.w)\n);\nreturn outMatrix;\n}\nvoid ComputePointSizeAndPositionInClipCoordSphere(){\nvec2 xbc;\nvec2 ybc;\nmat4 T = mat4(\nradius, 0.0, 0.0, 0.0,\n0.0, radius, 0.0, 0.0,\n0.0, 0.0, radius, 0.0,\nposition.x, position.y, position.z, 1.0\n);\nmat4 R = transpose( projectionMatrix * modelViewMatrix * T );\nfloat A = dot( R[ 3 ], D * R[ 3 ] );\nfloat B = -2.0 * dot( R[ 0 ], D * R[ 3 ] );\nfloat C = dot( R[ 0 ], D * R[ 0 ] );\nxbc[ 0 ] = ( -B - sqrt( B * B - 4.0 * A * C ) ) / ( 2.0 * A );\nxbc[ 1 ] = ( -B + sqrt( B * B - 4.0 * A * C ) ) / ( 2.0 * A );\nfloat sx = abs( xbc[ 0 ] - xbc[ 1 ] ) * 0.5;\nA = dot( R[ 3 ], D * R[ 3 ] );\nB = -2.0 * dot( R[ 1 ], D * R[ 3 ] );\nC = dot( R[ 1 ], D * R[ 1 ] );\nybc[ 0 ] = ( -B - sqrt( B * B - 4.0 * A * C ) ) / ( 2.0 * A );\nybc[ 1 ] = ( -B + sqrt( B * B - 4.0 * A * C ) ) / ( 2.0 * A );\nfloat sy = abs( ybc[ 0 ] - ybc[ 1 ] ) * 0.5;\ngl_Position.xy = vec2( 0.5 * ( xbc.x + xbc.y ), 0.5 * ( ybc.x + ybc.y ) );\ngl_Position.xy -= mapping * vec2( sx, sy );\ngl_Position.xy *= gl_Position.w;\n}\nvoid main(void){\n#ifdef PICKING\nvPickingColor = unpackColor( primitiveId );\n#else\n#include color_vertex\n#endif\nvRadius = radius * matrixScale( modelViewMatrix );\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nmvPosition.z -= vRadius;\ngl_Position = projectionMatrix * vec4( mvPosition.xyz, 1.0 );\nComputePointSizeAndPositionInClipCoordSphere();\nvRadiusSq = vRadius * vRadius;\nvec4 vPoint4 = projectionMatrixInverse * gl_Position;\nvPoint = vPoint4.xyz / vPoint4.w;\nvPointViewPosition = -mvPosition.xyz / mvPosition.w;\n}"),ip.add("shader/SphereImpostor.frag","#define STANDARD\n#define IMPOSTOR\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform vec3 interiorColor;\nuniform float interiorDarkening;\nuniform float roughness;\nuniform float metalness;\nuniform float opacity;\nuniform float clipNear;\nuniform mat4 projectionMatrix;\nuniform float ortho;\nvarying float vRadius;\nvarying float vRadiusSq;\nvarying vec3 vPoint;\nvarying vec3 vPointViewPosition;\n#ifdef PICKING\nuniform float objectId;\nvarying vec3 vPickingColor;\n#else\n#include common\n#include color_pars_fragment\n#include fog_pars_fragment\n#include bsdfs\n#include lights_pars\n#include lights_physical_pars_fragment\n#endif\nbool flag2 = false;\nbool interior = false;\nvec3 cameraPos;\nvec3 cameraNormal;\nfloat calcDepth( in vec3 cameraPos ){\nvec2 clipZW = cameraPos.z * projectionMatrix[2].zw + projectionMatrix[3].zw;\nreturn 0.5 + 0.5 * clipZW.x / clipZW.y;\n}\nfloat calcClip( vec3 cameraPos ){\nreturn dot( vec4( cameraPos, 1.0 ), vec4( 0.0, 0.0, 1.0, clipNear - 0.5 ) );\n}\nbool Impostor( out vec3 cameraPos, out vec3 cameraNormal ){\nvec3 cameraSpherePos = -vPointViewPosition;\ncameraSpherePos.z += vRadius;\nvec3 rayOrigin = mix( vec3( 0.0, 0.0, 0.0 ), vPoint, ortho );\nvec3 rayDirection = mix( normalize( vPoint ), vec3( 0.0, 0.0, 1.0 ), ortho );\nvec3 cameraSphereDir = mix( cameraSpherePos, rayOrigin - cameraSpherePos, ortho );\nfloat B = dot( rayDirection, cameraSphereDir );\nfloat det = B * B + vRadiusSq - dot( cameraSphereDir, cameraSphereDir );\nif( det < 0.0 ){\ndiscard;\nreturn false;\n}\nfloat sqrtDet = sqrt( det );\nfloat posT = mix( B + sqrtDet, B + sqrtDet, ortho );\nfloat negT = mix( B - sqrtDet, sqrtDet - B, ortho );\ncameraPos = rayDirection * negT + rayOrigin;\n#ifdef NEAR_CLIP\nif( calcDepth( cameraPos ) <= 0.0 ){\ncameraPos = rayDirection * posT + rayOrigin;\ninterior = true;\n}else if( calcClip( cameraPos ) > 0.0 ){\ncameraPos = rayDirection * posT + rayOrigin;\ninterior = true;\nflag2 = true;\n}\n#else\nif( calcDepth( cameraPos ) <= 0.0 ){\ncameraPos = rayDirection * posT + rayOrigin;\ninterior = true;\n}\n#endif\ncameraNormal = normalize( cameraPos - cameraSpherePos );\ncameraNormal *= float(!interior) * 2.0 - 1.0;\nreturn !interior;\n}\nvoid main(void){\nbool flag = Impostor( cameraPos, cameraNormal );\n#ifdef NEAR_CLIP\nif( calcClip( cameraPos ) > 0.0 )\ndiscard;\n#endif\ngl_FragDepthEXT = calcDepth( cameraPos );\nif( !flag ){\n#ifdef NEAR_CLIP\nif( flag2 ){\ngl_FragDepthEXT = max( 0.0, calcDepth( vec3( - ( clipNear - 0.5 ) ) ) + ( 0.0000001 / vRadius ) );\n}else if( gl_FragDepthEXT >= 0.0 ){\ngl_FragDepthEXT = 0.0 + ( 0.0000001 / vRadius );\n}\n#else\nif( gl_FragDepthEXT >= 0.0 ){\ngl_FragDepthEXT = 0.0 + ( 0.0000001 / vRadius );\n}\n#endif\n}\nif (gl_FragDepthEXT < 0.0)\ndiscard;\nif (gl_FragDepthEXT > 1.0)\ndiscard;\n#ifdef PICKING\ngl_FragColor = vec4( vPickingColor, objectId );\n#else\nvec3 vNormal = cameraNormal;\nvec3 vViewPosition = -cameraPos;\nvec4 diffuseColor = vec4( diffuse, opacity );\nReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\nvec3 totalEmissiveLight = emissive;\n#include color_fragment\n#include roughnessmap_fragment\n#include metalnessmap_fragment\n#include normal_fragment\n#include lights_physical_fragment\n#include lights_template\nvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveLight;\nif( interior ){\n#ifdef USE_INTERIOR_COLOR\noutgoingLight.xyz = interiorColor;\n#else\n#ifdef DIFFUSE_INTERIOR\noutgoingLight.xyz = vColor;\n#endif\n#endif\noutgoingLight.xyz *= 1.0 - interiorDarkening;\n}\ngl_FragColor = vec4( outgoingLight, diffuseColor.a );\n#include premultiplied_alpha_fragment\n#include tonemapping_fragment\n#include encodings_fragment\n#include fog_fragment\n#endif\n}");var Mb=function(t){function e(e,i,r){void 0===r&&(r={}),t.call(this,i,r),this.index=Rh(this.indexSize,this.attributeSize),this.makeIndex(),this.initIndex(this.index),this.addAttributes({mapping:{type:e,value:null}}),this.setAttributes({primitiveId:Vp(this.size)})}t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e;var i={attributeSize:{configurable:!0},indexSize:{configurable:!0}};return i.attributeSize.get=function(){return this.size*this.mappingSize},i.indexSize.get=function(){return this.size*this.mappingIndicesSize},e.prototype.addAttributes=function(e){var i={};for(var r in e){var n=e[r];i[r]={type:n.type,value:null}}t.prototype.addAttributes.call(this,i)},e.prototype.getAttributeIndex=function(t){return 3*t*this.mappingSize},e.prototype.setAttributes=function(t){t&&!t.position&&t.position1&&t.position2&&(t.position=zp(t.position1,t.position2));var e,i,r,n,o,a,s,c=this.size,u=this.mappingSize,h=this.geometry.attributes;for(var l in t)if("index"!==l&&"picking"!==l){i=t[l],r=(e=h[l]).itemSize,n=e.array;for(var p=0;p<c;++p){a=(o=p*r)*u;for(var d=0;d<u;++d){s=a+r*d;for(var f=0;f<r;++f)n[s+f]=i[o+f]}}e.needsUpdate=!0}},e.prototype.makeMapping=function(){for(var t=this.size,e=this.mapping,i=this.mappingSize,r=this.mappingItemSize,n=this.geometry.attributes.mapping.array,o=0;o<t;o++)n.set(e,o*r*i)},e.prototype.makeIndex=function(){for(var t=this.size,e=this.mappingSize,i=this.mappingIndices,r=this.mappingIndicesSize,n=this.index,o=0;o<t;o++){var a=o*r,s=o*e;n.set(i,a);for(var c=0;c<r;++c)n[a+c]+=s}},Object.defineProperties(e.prototype,i),e}(vv),Pb=new Float32Array([-1,1,-1,-1,1,1,1,-1]),Tb=new Uint16Array([0,1,2,1,3,2]),Eb=function(t){function e(e,i){void 0===i&&(i={}),t.call(this,"v2",e,i)}t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e;var i={mapping:{configurable:!0},mappingIndices:{configurable:!0},mappingIndicesSize:{configurable:!0},mappingSize:{configurable:!0},mappingItemSize:{configurable:!0}};return i.mapping.get=function(){return Pb},i.mappingIndices.get=function(){return Tb},i.mappingIndicesSize.get=function(){return 6},i.mappingSize.get=function(){return 4},i.mappingItemSize.get=function(){return 2},Object.defineProperties(e.prototype,i),e}(Mb),Cb=function(t){function e(e,i){void 0===i&&(i={}),t.call(this,e,i),this.isImpostor=!0,this.vertexShader="SphereImpostor.vert",this.fragmentShader="SphereImpostor.frag",this.addUniforms({projectionMatrixInverse:{value:new Ve},ortho:{value:0}}),this.addAttributes({radius:{type:"f",value:null}}),this.setAttributes(e),this.makeMapping()}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e}(Eb),Ib=(Object.assign({disableImpostor:!1},Sb),function(t,e){return!Wl||e&&e.disableImpostor?new Ab(t,e):new Cb(t,e)});op.add("sphere",Ib),ip.add("shader/Point.vert","uniform float clipNear;\nuniform float clipRadius;\nuniform vec3 clipCenter;\nuniform float size;\nuniform float canvasHeight;\nuniform float pixelRatio;\n#if defined( RADIUS_CLIP )\nvarying vec3 vClipCenter;\n#endif\n#if defined( PICKING )\n#include unpack_color\nattribute float primitiveId;\nvarying vec3 vPickingColor;\n#else\n#include color_pars_vertex\nvarying vec3 vViewPosition;\n#endif\n#include common\nvoid main(){\n#if defined( PICKING )\nvPickingColor = unpackColor( primitiveId );\n#else\n#include color_vertex\n#endif\n#include begin_vertex\n#include project_vertex\n#ifdef USE_SIZEATTENUATION\ngl_PointSize = size * pixelRatio * ( ( canvasHeight / 2.0 ) / -mvPosition.z );\n#else\ngl_PointSize = size * pixelRatio;\n#endif\n#ifndef PICKING\nvViewPosition = -mvPosition.xyz;\n#endif\n#if defined( RADIUS_CLIP )\nvClipCenter = -( modelViewMatrix * vec4( clipCenter, 1.0 ) ).xyz;\n#endif\n#include nearclip_vertex\n#include radiusclip_vertex\n}"),ip.add("shader/Point.frag","uniform vec3 diffuse;\nuniform float opacity;\nuniform float clipNear;\nuniform float clipRadius;\n#if defined( RADIUS_CLIP )\nvarying vec3 vClipCenter;\n#endif\n#ifdef USE_MAP\nuniform sampler2D map;\n#endif\n#if defined( PICKING )\nuniform float objectId;\nvarying vec3 vPickingColor;\n#else\n#include common\n#include color_pars_fragment\n#include fog_pars_fragment\nvarying vec3 vViewPosition;\n#endif\nvoid main(){\n#include nearclip_fragment\n#include radiusclip_fragment\n#if defined( PICKING )\n#ifdef USE_MAP\nif( texture2D( map, vec2( gl_PointCoord.x, 1.0 - gl_PointCoord.y ) ).a < 0.5 )\ndiscard;\n#endif\ngl_FragColor = vec4( vPickingColor, objectId );\n#else\nvec3 outgoingLight = vec3( 0.0 );\nvec4 diffuseColor = vec4( diffuse, 1.0 );\n#ifdef USE_MAP\ndiffuseColor *= texture2D( map, vec2( gl_PointCoord.x, 1.0 - gl_PointCoord.y ) );\n#endif\n#include color_fragment\n#include alphatest_fragment\noutgoingLight = diffuseColor.rgb;\ngl_FragColor = vec4( outgoingLight, diffuseColor.a * opacity );\n#include premultiplied_alpha_fragment\n#include tonemapping_fragment\n#include encodings_fragment\n#include fog_fragment\n#endif\n}");var Rb=Object.assign({pointSize:1,sizeAttenuation:!0,sortParticles:!1,alphaTest:.5,useTexture:!1,forceTransparent:!1,edgeBleach:0},mv),Lb=Object.assign({pointSize:{uniform:"size"},sizeAttenuation:{updateShader:!0},sortParticles:{},alphaTest:{updateShader:!0},useTexture:{updateShader:!0},forceTransparent:{},edgeBleach:{uniform:!0}},gv),Ob=function(t){function e(e,i){void 0===i&&(i={}),t.call(this,e,i),this.parameterTypes=Lb,this.vertexShader="Point.vert",this.fragmentShader="Point.frag",this.isPoint=!0,this.addUniforms({size:{value:this.parameters.pointSize},canvasHeight:{value:1},pixelRatio:{value:1},map:{value:null}})}t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e;var i={defaultParameters:{configurable:!0}};return i.defaultParameters.get=function(){return Rb},e.prototype.makeMaterial=function(){t.prototype.makeMaterial.call(this),this.makeTexture();var e=this.material,i=this.wireframeMaterial,r=this.pickingMaterial;e.uniforms.map.value=this.tex,e.needsUpdate=!0,i.uniforms.map.value=this.tex,i.needsUpdate=!0,r.uniforms.map.value=this.tex,r.needsUpdate=!0},e.prototype.makeTexture=function(){this.tex&&this.tex.dispose(),this.tex=function(t){for(var e,i,r=t||{},n=yh(r.width,256),o=yh(r.height,256),a=[n/2,o/2],s=Math.min(n/2,o/2),c=yh(r.delta,1/(s+1))*s,u=0,h=0,l=new Uint8Array(n*o*4),p=0,d=l.length;p<d;p+=4){var f=1-Yh(s-c,s,(e=a[0]-u,i=a[1]-h,Math.sqrt(e*e+i*i)));l[p]=255*f,l[p+1]=255*f,l[p+2]=255*f,l[p+3]=255*f,++u===n&&(u=0,h++)}var m=new ti(l,n,o);return m.needsUpdate=!0,m}({delta:this.parameters.edgeBleach})},e.prototype.getDefines=function(e){var i=t.prototype.getDefines.call(this,e);return this.parameters.sizeAttenuation&&(i.USE_SIZEATTENUATION=1),this.parameters.useTexture&&(i.USE_MAP=1),this.parameters.alphaTest>0&&this.parameters.alphaTest<=1&&(i.ALPHATEST=this.parameters.alphaTest.toPrecision(2)),i},e.prototype.setUniforms=function(e){e&&void 0!==e.edgeBleach&&(this.makeTexture(),e.map=this.tex),t.prototype.setUniforms.call(this,e)},e.prototype.dispose=function(){t.prototype.dispose.call(this),this.tex&&this.tex.dispose()},Object.defineProperties(e.prototype,i),e}(vv);op.add("point",Ob);var Db=function(t){function e(e,i,r){t.call(this,e,i,r),this.type="dot",this.parameters=Object.assign({thresholdType:{type:"select",rebuild:!0,options:{value:"value",sigma:"sigma"}},thresholdMin:{type:"number",precision:3,max:1/0,min:-1/0,rebuild:!0},thresholdMax:{type:"number",precision:3,max:1/0,min:-1/0,rebuild:!0},thresholdOut:{type:"boolean",rebuild:!0},dotType:{type:"select",rebuild:!0,options:{"":"",sphere:"sphere",point:"point"}},radiusType:{type:"select",options:{"":"",value:"value","abs-value":"abs-value","value-min":"value-min",deviation:"deviation",size:"size"}},radius:{type:"number",precision:3,max:10,min:.001,property:"size"},scale:{type:"number",precision:3,max:10,min:.001},sphereDetail:!0,disableImpostor:!0,pointSize:{type:"number",precision:1,max:100,min:0,buffer:!0},sizeAttenuation:{type:"boolean",buffer:!0},sortParticles:{type:"boolean",rebuild:!0},useTexture:{type:"boolean",buffer:!0},alphaTest:{type:"range",step:.001,max:1,min:0,buffer:!0},forceTransparent:{type:"boolean",buffer:!0},edgeBleach:{type:"range",step:.001,max:1,min:0,buffer:!0}},this.parameters,{colorScheme:{type:"select",update:"color",options:{"":"",value:"value",uniform:"uniform",random:"random"}}}),e instanceof hv?(this.surface=void 0,this.volume=new Zv(e)):(this.surface=e,this.volume=void 0),this.init(r)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.init=function(e){var i=e||{};i.colorScheme=yh(i.colorScheme,"uniform"),i.colorValue=yh(i.colorValue,14540253),this.thresholdType=yh(i.thresholdType,"sigma"),this.thresholdMin=yh(i.thresholdMin,2),this.thresholdMax=yh(i.thresholdMax,1/0),this.thresholdOut=yh(i.thresholdOut,!1),this.dotType=yh(i.dotType,"point"),this.radius=yh(i.radius,.1),this.scale=yh(i.scale,1),this.pointSize=yh(i.pointSize,1),this.sizeAttenuation=yh(i.sizeAttenuation,!0),this.sortParticles=yh(i.sortParticles,!1),this.useTexture=yh(i.useTexture,!1),this.alphaTest=yh(i.alphaTest,.5),this.forceTransparent=yh(i.forceTransparent,!1),this.edgeBleach=yh(i.edgeBleach,0),t.prototype.init.call(this,i),this.build()},e.prototype.attach=function(t){var e=this;this.bufferList.forEach(function(t){e.viewer.add(t)}),this.setVisibility(this.visible),t()},e.prototype.create=function(){var t={};if(this.volume){var e,i,r=this.volume;"sigma"===this.thresholdType?(e=r.getValueForSigma(this.thresholdMin),i=r.getValueForSigma(this.thresholdMax)):(e=this.thresholdMin,i=this.thresholdMax),r.setFilter(e,i,this.thresholdOut),t.position=r.getDataPosition(),t.color=r.getDataColor(this.getColorParams()),"sphere"===this.dotType&&(t.radius=r.getDataSize(this.radius,this.scale),t.picking=r.getDataPicking())}else{var n=this.surface;t.position=n.getPosition(),t.color=n.getColor(this.getColorParams()),"sphere"===this.dotType&&(t.radius=n.getSize(this.radius,this.scale),t.picking=n.getPicking())}"sphere"===this.dotType?this.dotBuffer=new Ib(t,this.getBufferParams({sphereDetail:this.sphereDetail,disableImpostor:this.disableImpostor,dullInterior:!1})):this.dotBuffer=new Ob(t,this.getBufferParams({pointSize:this.pointSize,sizeAttenuation:this.sizeAttenuation,sortParticles:this.sortParticles,useTexture:this.useTexture,alphaTest:this.alphaTest,forceTransparent:this.forceTransparent,edgeBleach:this.edgeBleach})),this.bufferList.push(this.dotBuffer)},e.prototype.update=function(t){if(0!==this.bufferList.length){var e={};(t=t||{}).color&&(this.volume?e.color=this.volume.getDataColor(this.getColorParams()):e.color=this.surface.getColor(this.getColorParams())),"sphere"===this.dotType&&(t.radius||t.scale)&&(this.volume?e.radius=this.volume.getDataSize(this.radius,this.scale):e.radius=this.surface.getSize(this.radius,this.scale)),this.dotBuffer.setAttributes(e)}},e.prototype.setParameters=function(e,i,r){return i=i||{},e&&void 0!==e.thresholdType&&this.volume instanceof hv&&("value"===this.thresholdType&&"sigma"===e.thresholdType?(this.thresholdMin=this.volume.getSigmaForValue(this.thresholdMin),this.thresholdMax=this.volume.getSigmaForValue(this.thresholdMax)):"sigma"===this.thresholdType&&"value"===e.thresholdType&&(this.thresholdMin=this.volume.getValueForSigma(this.thresholdMin),this.thresholdMax=this.volume.getValueForSigma(this.thresholdMax)),this.thresholdType=e.thresholdType),e&&void 0!==e.radiusType&&("radius"===e.radiusType?this.radius=.1:this.radius=e.radiusType,i.radius=!0,"sphere"!==this.dotType||Wl&&!this.disableImpostor||(r=!0)),e&&void 0!==e.radius&&(i.radius=!0,"sphere"!==this.dotType||Wl&&!this.disableImpostor||(r=!0)),e&&void 0!==e.scale&&(i.scale=!0,"sphere"!==this.dotType||Wl&&!this.disableImpostor||(r=!0)),t.prototype.setParameters.call(this,e,i,r),this},e}(af);ip.add("shader/Image.vert","uniform float clipRadius;\nuniform vec3 clipCenter;\nvarying vec2 vUv;\n#if defined( NEAR_CLIP ) || defined( RADIUS_CLIP ) || !defined( PICKING )\nvarying vec3 vViewPosition;\n#endif\n#if defined( RADIUS_CLIP )\nvarying vec3 vClipCenter;\n#endif\nvoid main() {\n#include begin_vertex\n#include project_vertex\nvUv = uv;\n#if defined( NEAR_CLIP ) || defined( RADIUS_CLIP ) || !defined( PICKING )\nvViewPosition = -mvPosition.xyz;\n#endif\n#if defined( RADIUS_CLIP )\nvClipCenter = -( modelViewMatrix * vec4( clipCenter, 1.0 ) ).xyz;\n#endif\n}"),ip.add("shader/Image.frag","uniform sampler2D map;\nuniform float opacity;\nuniform vec2 mapSize;\nuniform float clipNear;\nuniform float clipRadius;\nvarying vec2 vUv;\n#if defined( NEAR_CLIP ) || defined( RADIUS_CLIP ) || !defined( PICKING )\nvarying vec3 vViewPosition;\n#endif\n#if defined( RADIUS_CLIP )\nvarying vec3 vClipCenter;\n#endif\n#if defined( PICKING )\nuniform sampler2D pickingMap;\nuniform float objectId;\n#else\n#include fog_pars_fragment\n#endif\n#if defined( CUBIC_INTERPOLATION )\n#if defined( CATMULROM_FILTER ) || defined( MITCHELL_FILTER )\n#if defined( CATMULROM_FILTER )\nconst float B = 0.0;\nconst float C = 0.5;\n#elif defined( MITCHELL_FILTER )\nconst float B = 0.333;\nconst float C = 0.333;\n#endif\nfloat filter( float x ){\nfloat f = x;\nif( f < 0.0 ){\nf = -f;\n}\nif( f < 1.0 ){\nreturn ( ( 12.0 - 9.0 * B - 6.0 * C ) * ( f * f * f ) +\n( -18.0 + 12.0 * B + 6.0 *C ) * ( f * f ) +\n( 6.0 - 2.0 * B ) ) / 6.0;\n}else if( f >= 1.0 && f < 2.0 ){\nreturn ( ( -B - 6.0 * C ) * ( f * f * f )\n+ ( 6.0 * B + 30.0 * C ) * ( f *f ) +\n( - ( 12.0 * B ) - 48.0 * C ) * f +\n8.0 * B + 24.0 * C ) / 6.0;\n}else{\nreturn 0.0;\n}\n}\n#elif defined( BSPLINE_FILTER )\nfloat filter( float x ){\nfloat f = x;\nif( f < 0.0 ){\nf = -f;\n}\nif( f >= 0.0 && f <= 1.0 ){\nreturn ( 2.0 / 3.0 ) + ( 0.5 ) * ( f * f * f ) - ( f * f );\n}else if( f > 1.0 && f <= 2.0 ){\nreturn 1.0 / 6.0 * pow( ( 2.0 - f ), 3.0 );\n}\nreturn 1.0;\n}\n#else\nfloat filter( float x ){\nreturn 1.0;\n}\n#endif\nvec4 biCubic( sampler2D tex, vec2 texCoord ){\nvec2 texelSize = 1.0 / mapSize;\ntexCoord -= texelSize / 2.0;\nvec4 nSum = vec4( 0.0 );\nfloat nDenom = 0.0;\nvec2 cell = fract( texCoord * mapSize );\nfor( float m = -1.0; m <= 2.0; ++m ){\nfor( float n = -1.0; n <= 2.0; ++n ){\nvec4 vecData = texture2D(\ntex, texCoord + texelSize * vec2( m, n )\n);\nfloat c = filter( m - cell.x ) * filter( -n + cell.y );\nnSum += vecData * c;\nnDenom += c;\n}\n}\nreturn nSum / nDenom;\n}\n#endif\nvoid main(){\n#include nearclip_fragment\n#include radiusclip_fragment\n#if defined( CUBIC_INTERPOLATION )\ngl_FragColor = biCubic( map, vUv );\n#else\ngl_FragColor = texture2D( map, vUv );\n#endif\n#if defined( PICKING )\nif( gl_FragColor.a < 0.7 )\ndiscard;\ngl_FragColor = vec4( texture2D( pickingMap, vUv ).xyz, objectId );\n#else\nif( gl_FragColor.a < 0.01 )\ndiscard;\ngl_FragColor.a *= opacity;\n#include fog_fragment\n#endif\n}");var kb=new Uint16Array([0,1,2,1,3,2]),Nb=new Float32Array([0,1,0,0,1,1,1,0]),Bb=Object.assign({filter:"nearest",forceTransparent:!0},mv),Fb=Object.assign({filter:{updateShader:!0,uniform:!0}},gv),zb=function(t){function e(e,i){t.call(this,{position:e.position,index:kb,picking:e.picking},i),this.parameterTypes=Fb,this.alwaysTransparent=!0,this.hasWireframe=!1,this.vertexShader="Image.vert",this.fragmentShader="Image.frag";var r=e.imageData,n=e.width,o=e.height,a=new ti(r,n,o);a.flipY=!0,this.tex=a;for(var s=r.length,c=new Uint8Array(s),u=0;u<s;u+=4){var h=u/4;c[u]=h>>16&255,c[u+1]=h>>8&255,c[u+2]=255&h}var l=new ti(c,n,o);l.flipY=!0,l.minFilter=$t,l.magFilter=$t,this.pickingTex=l,this.addUniforms({map:{value:a},pickingMap:{value:l},mapSize:{value:new Ge(n,o)}}),this.geometry.addAttribute("uv",new sn(Nb,2))}t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e;var i={defaultParameters:{configurable:!0}};return i.defaultParameters.get=function(){return Bb},e.prototype.getDefines=function(e){var i=t.prototype.getDefines.call(this,e),r=this.parameters.filter;return r.startsWith("cubic")&&(i.CUBIC_INTERPOLATION=1,r.endsWith("bspline")?i.BSPLINE_FILTER=1:r.endsWith("catmulrom")?i.CATMULROM_FILTER=1:r.endsWith("mitchell")&&(i.MITCHELL_FILTER=1)),i},e.prototype.updateTexture=function(){var t=this.tex,e=this.parameters.filter;e.startsWith("cubic")?(t.minFilter=$t,t.magFilter=$t):"linear"===e?(t.minFilter=qt,t.magFilter=qt):(t.minFilter=$t,t.magFilter=$t),t.needsUpdate=!0,this.pickingTex.needsUpdate=!0},e.prototype.makeMaterial=function(){t.prototype.makeMaterial.call(this),this.updateTexture();var e=this.material;e.uniforms.map.value=this.tex,e.blending=J,e.needsUpdate=!0;var i=this.wireframeMaterial;i.uniforms.map.value=this.tex,i.blending=J,i.needsUpdate=!0;var r=this.pickingMaterial;r.uniforms.map.value=this.tex,r.uniforms.pickingMap.value=this.pickingTex,r.blending=J,r.needsUpdate=!0},e.prototype.setUniforms=function(e){e&&void 0!==e.filter&&(this.updateTexture(),e.map=this.tex),t.prototype.setUniforms.call(this,e)},Object.defineProperties(e.prototype,i),e}(vv),Ub=function(t,e){var i=e||{};this.dimension=yh(i.dimension,"x"),this.positionType=yh(i.positionType,"percent"),this.position=yh(i.position,30),this.thresholdType=yh(i.thresholdType,"sigma"),this.thresholdMin=yh(i.thresholdMin,-1/0),this.thresholdMax=yh(i.thresholdMax,1/0),this.normalize=yh(i.normalize,!1),this.volume=t};Ub.prototype.getPositionFromCoordinate=function(t){var e,i=this.dimension,r=this.volume,n=r.matrix,o=(new $e).setFromMatrixPosition(n)[i],a=(new $e).setFromMatrixScale(n)[i];return e="x"===i?r.nx:"y"===i?r.ny:r.nz,Math.round(((t-o)/(e/100)+1)/a)},Ub.prototype.getData=function(t){t=t||{};var e,i=this.volume,r=i.data,n=i.matrix;function o(t){return Math.round(t/100*(e-1))}function a(t,e,r,n){return 3*(r*i.ny*i.nx+e*i.nx+t)+n}e="coordinate"===this.positionType?this.getPositionFromCoordinate(this.position):this.position;var s,c,u,h,l,p=new Float32Array(12),d=new $e,f=0,m=0,g=0,v=i.nx,y=i.ny,b=i.nz;function x(t,e,i,r){d.set(t,e,i).applyMatrix4(n).toArray(p,r)}"x"===this.dimension?(u=o(i.nx),h=i.ny-1,l=i.nz-1,s=i.nz,c=i.ny,v=(f=u)+1,x(u,0,0,0),x(u,h,0,3),x(u,0,l,6),x(u,h,l,9)):"y"===this.dimension?(u=i.nx-1,h=o(i.ny),l=i.nz-1,s=i.nz,c=i.nx,y=(m=h)+1,x(0,h,0,0),x(u,h,0,3),x(0,h,l,6),x(u,h,l,9)):"z"===this.dimension&&(u=i.nx-1,h=i.ny-1,l=o(i.nz),s=i.nx,c=i.ny,b=(g=l)+1,x(0,0,l,0),x(0,h,l,3),x(u,0,l,6),x(u,h,l,9));var _,w,S=0,A=0,M=new Uint8Array(s*c*4),P=new Float32Array(s*c);"sigma"===this.thresholdType?(_=i.getValueForSigma(this.thresholdMin),w=i.getValueForSigma(this.thresholdMax)):(_=this.thresholdMin,w=this.thresholdMax);var T=Object.assign({},t.colorParams,{volume:i});this.normalize&&(T.domain=[0,1]);var E,C,I,R=Jl.getScheme(T),L=new Float32Array(3),O=R.getScale();if(this.normalize){E=1/0,C=-1/0;for(var D=m;D<y;++D)for(var k=f;k<v;++k)for(var N=g;N<b;++N){var B=r[a(k,D,N,0)/3];B<E&&(E=B),B>C&&(C=B)}I=C-E}for(var F=m;F<y;++F)for(var z=f;z<v;++z)for(var U=g;U<b;++U){var j=a(z,F,U,0)/3,G=r[j];this.normalize&&(G=(G-E)/I),R.colorToArray(O(G),L),M[S]=Math.round(255*L[0]),M[S+1]=Math.round(255*L[1]),M[S+2]=Math.round(255*L[2]),M[S+3]=G>_&&G<w?255:0,P[A]=j,++A,S+=4}var V=new Lg(P,i);return{position:p,imageData:M,width:s,height:c,picking:V}};var jb=function(t){function e(e,i,r){t.call(this,e,i,r),this.type="slice",this.parameters=Object.assign({filter:{type:"select",buffer:!0,options:{nearest:"nearest",linear:"linear","cubic-bspline":"cubic-bspline","cubic-catmulrom":"cubic-catmulrom","cubic-mitchell":"cubic-mitchell"}},positionType:{type:"select",rebuild:!0,options:{percent:"percent",coordinate:"coordinate"}},position:{type:"range",step:.1,max:100,min:1,rebuild:!0},dimension:{type:"select",rebuild:!0,options:{x:"x",y:"y",z:"z"}},thresholdType:{type:"select",rebuild:!0,options:{value:"value",sigma:"sigma"}},thresholdMin:{type:"number",precision:3,max:1/0,min:-1/0,rebuild:!0},thresholdMax:{type:"number",precision:3,max:1/0,min:-1/0,rebuild:!0},normalize:{type:"boolean",rebuild:!0}},this.parameters,{flatShaded:null,side:null,wireframe:null,linewidth:null,colorScheme:null,roughness:null,metalness:null,diffuse:null}),this.volume=e,this.init(r)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.init=function(e){var i=this.volume,r=e||{};r.colorDomain=yh(r.colorDomain,[i.min,i.max]),r.colorScheme=yh(r.colorScheme,"value"),r.colorScale=yh(r.colorScale,"Spectral"),this.colorScheme="value",this.dimension=yh(r.dimension,"x"),this.filter=yh(r.filter,"cubic-bspline"),this.positionType=yh(r.positionType,"percent"),this.position=yh(r.position,30),this.thresholdType=yh(r.thresholdType,"sigma"),this.thresholdMin=yh(r.thresholdMin,-1/0),this.thresholdMax=yh(r.thresholdMax,1/0),this.normalize=yh(r.normalize,!1),t.prototype.init.call(this,r),this.build()},e.prototype.attach=function(t){var e=this;this.bufferList.forEach(function(t){e.viewer.add(t)}),this.setVisibility(this.visible),t()},e.prototype.create=function(){var t=new Ub(this.volume,{positionType:this.positionType,position:this.position,dimension:this.dimension,thresholdType:this.thresholdType,thresholdMin:this.thresholdMin,thresholdMax:this.thresholdMax,normalize:this.normalize}),e=new zb(t.getData({colorParams:this.getColorParams()}),this.getBufferParams({filter:this.filter}));this.bufferList.push(e)},e}(af);function Gb(t){ql.error("makeRepresentation: representation type "+t+" unknown")}var Vb={name:"some element",status:""},Hb=function(t,e){void 0===e&&(e={}),this.stage=t,this.signals={statusChanged:new nl,nameChanged:new nl,disposed:new nl},this.parameters=bh(e,this.defaultParameters),this.uuid=Hh()},$b={defaultParameters:{configurable:!0},name:{configurable:!0}};$b.defaultParameters.get=function(){return Vb},$b.name.get=function(){return this.parameters.name},Hb.prototype.setStatus=function(t){return this.parameters.status=t,this.signals.statusChanged.dispatch(t),this},Hb.prototype.setName=function(t){return this.parameters.name=t,this.signals.nameChanged.dispatch(t),this},Hb.prototype.dispose=function(){this.signals.disposed.dispatch()},Object.defineProperties(Hb.prototype,$b);var Wb=Object.assign({visible:!0},Vb),Xb=function(t){function e(e,i,r,n){void 0===r&&(r={}),t.call(this,e,Object.assign({name:i.type},r)),this.parent=n,this.signals=Object.assign({visibilityChanged:new nl,parametersChanged:new nl},this.signals),this.setRepresentation(i)}t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e;var i={defaultParameters:{configurable:!0},visible:{configurable:!0},type:{configurable:!0}};return i.defaultParameters.get=function(){return Wb},i.visible.get=function(){return this.parameters.visible},i.type.get=function(){return"representation"},e.prototype.getType=function(){return this.repr.type},e.prototype.setRepresentation=function(t){this._disposeRepresentation(),this.repr=t,this.stage.tasks.listen(this.repr.tasks),this.updateVisibility()},e.prototype._disposeRepresentation=function(){this.repr&&(this.stage.tasks.unlisten(this.repr.tasks),this.repr.dispose())},e.prototype.dispose=function(){this.parent&&this.parent.hasRepresentation(this)?this.parent.removeRepresentation(this):(this._disposeRepresentation(),this.signals.disposed.dispatch())},e.prototype.setVisibility=function(t){return this.parameters.visible=t,this.updateVisibility(),this.signals.visibilityChanged.dispatch(this.parameters.visible),this},e.prototype.getVisibility=function(){return this.parent?this.parent.parameters.visible&&this.parameters.visible:this.parameters.visible},e.prototype.toggleVisibility=function(){return this.setVisibility(!this.parameters.visible)},e.prototype.updateVisibility=function(){this.repr.setVisibility(this.getVisibility())},e.prototype.update=function(t){return this.repr.update(t),this},e.prototype.build=function(t){return this.repr.build(t),this},e.prototype.setSelection=function(t){var e=this.repr;return e.setSelection&&e.setSelection(t),this},e.prototype.setParameters=function(t){return this.repr.setParameters(t),this.signals.parametersChanged.dispatch(this.repr.getParameters()),this},e.prototype.getParameters=function(){return this.repr.getParameters()},e.prototype.setColor=function(t){return this.repr.setColor(t),this},Object.defineProperties(e.prototype,i),e}(Hb),qb=new Ve,Yb=new $e,Zb={name:"",status:"",visible:!0},Kb=function(t,e,i){void 0===i&&(i={}),this.stage=t,this.object=e,this.signals={representationAdded:new nl,representationRemoved:new nl,visibilityChanged:new nl,matrixChanged:new nl,statusChanged:new nl,nameChanged:new nl,disposed:new nl},this.reprList=[],this.annotationList=[],this.matrix=new Ve,this.position=new $e,this.quaternion=new He,this.scale=new $e(1,1,1),this.transform=new Ve,this.parameters=bh(i,this.defaultParameters),this.uuid=Hh(),this.viewer=t.viewer,this.controls=new Vv(this)},Jb={defaultParameters:{configurable:!0},name:{configurable:!0},status:{configurable:!0},visible:{configurable:!0}};Jb.defaultParameters.get=function(){return Zb},Jb.name.get=function(){return this.parameters.name},Jb.status.get=function(){return this.parameters.status},Jb.visible.get=function(){return this.parameters.visible},Kb.prototype.setPosition=function(t){return Array.isArray(t)?this.position.fromArray(t):this.position.copy(t),this.updateMatrix(),this},Kb.prototype.setRotation=function(t){if(Array.isArray(t))if(3===t.length){var e=(new Pr).fromArray(t);this.quaternion.setFromEuler(e)}else this.quaternion.fromArray(t);else t instanceof Pr?this.quaternion.setFromEuler(t):this.quaternion.copy(t);return this.updateMatrix(),this},Kb.prototype.setScale=function(t){return this.scale.set(t,t,t),this.updateMatrix(),this},Kb.prototype.setTransform=function(t){return this.transform.copy(t),this.updateMatrix(),this},Kb.prototype.updateMatrix=function(){var t=this,e=this.getCenterUntransformed(Yb);this.matrix.makeTranslation(-e.x,-e.y,-e.z),qb.makeRotationFromQuaternion(this.quaternion),this.matrix.premultiply(qb),qb.makeScale(this.scale.x,this.scale.y,this.scale.z),this.matrix.premultiply(qb);var i=this.position;qb.makeTranslation(i.x+e.x,i.y+e.y,i.z+e.z),this.matrix.premultiply(qb),this.matrix.premultiply(this.transform),this.reprList.forEach(function(e){e.setParameters({matrix:t.matrix})}),this.stage.viewer.updateBoundingBox(),this.signals.matrixChanged.dispatch(this.matrix)},Kb.prototype.addAnnotation=function(t,e,i){var r=new zv(this,t,e,i);return this.annotationList.push(r),r},Kb.prototype.eachAnnotation=function(t){this.annotationList.slice().forEach(t)},Kb.prototype.removeAnnotation=function(t){var e=this.annotationList.indexOf(t);-1!==e&&(this.annotationList.splice(e,1),t.dispose())},Kb.prototype.removeAllAnnotations=function(){this.eachAnnotation(function(t){return t.dispose()}),this.annotationList.length=0},Kb.prototype._addRepresentation=function(e,i,r,n){void 0===n&&(n=!1);var o=r||{},a=this.stage.getParameters();o.matrix=this.matrix.clone(),o.quality=o.quality||a.quality,o.disableImpostor=yh(o.disableImpostor,!a.impostor),o.useWorker=yh(o.useWorker,a.workerDefault),o.visible=yh(o.visible,!0);var s=Object.assign({},o,{visible:this.parameters.visible&&o.visible}),c=function(e,i,r,n){var o;if(t.Debug&&ql.time("makeRepresentation "+e),i instanceof lb){if(!(o=tp.get(e)))return void Gb(e)}else if(i instanceof sv)if("surface"===e)o=Pv;else{if("dot"!==e)return void Gb(e);o=Db}else if(i instanceof hv)if("surface"===e)o=Pv;else if("dot"===e)o=Db;else{if("slice"!==e)return void Gb(e);o=jb}else if(i instanceof gb)o=yb,i=i.getBufferList();else{if("buffer"!==e)return void ql.error("makeRepresentation: object "+i+" unknown");o=yb}var a=new o(i,r,n);return t.Debug&&ql.timeEnd("makeRepresentation "+e),a}(e,i,this.viewer,s),u=new Xb(this.stage,c,o,this);return n||(this.reprList.push(u),this.signals.representationAdded.dispatch(u)),u},Kb.prototype.addBufferRepresentation=function(t,e){return this._addRepresentation.call(this,"buffer",t,e)},Kb.prototype.hasRepresentation=function(t){return-1!==this.reprList.indexOf(t)},Kb.prototype.eachRepresentation=function(t){this.reprList.slice().forEach(t)},Kb.prototype.removeRepresentation=function(t){var e=this.reprList.indexOf(t);-1!==e&&(this.reprList.splice(e,1),t.dispose(),this.signals.representationRemoved.dispatch(t))},Kb.prototype.updateRepresentations=function(t){this.reprList.forEach(function(e){return e.update(t)}),this.stage.viewer.requestRender()},Kb.prototype.removeAllRepresentations=function(){this.eachRepresentation(function(t){return t.dispose()})},Kb.prototype.dispose=function(){this.removeAllAnnotations(),this.removeAllRepresentations(),delete this.annotationList,delete this.reprList,this.signals.disposed.dispatch()},Kb.prototype.setVisibility=function(t){return this.parameters.visible=t,this.eachRepresentation(function(t){return t.updateVisibility()}),this.eachAnnotation(function(t){return t.updateVisibility()}),this.signals.visibilityChanged.dispatch(t),this},Kb.prototype.setStatus=function(t){return this.parameters.status=t,this.signals.statusChanged.dispatch(t),this},Kb.prototype.setName=function(t){return this.parameters.name=t,this.signals.nameChanged.dispatch(t),this},Kb.prototype.getBox=function(){for(var t,e=[],i=arguments.length;i--;)e[i]=arguments[i];return(t=this).getBoxUntransformed.apply(t,e).clone().applyMatrix4(this.matrix)},Kb.prototype.getCenter=function(){for(var t,e=[],i=arguments.length;i--;)e[i]=arguments[i];return(t=this).getCenterUntransformed.apply(t,e).clone().applyMatrix4(this.matrix)},Kb.prototype.getZoom=function(){for(var t,e=[],i=arguments.length;i--;)e[i]=arguments[i];return this.stage.getZoomForBox((t=this).getBox.apply(t,e))},Kb.prototype.getBoxUntransformed=function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return new xr},Kb.prototype.getCenterUntransformed=function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return this.getBoxUntransformed().getCenter()},Kb.prototype.autoView=function(t){this.stage.animationControls.zoomMove(this.getCenter(),this.getZoom(),yh(t,0))},Object.defineProperties(Kb.prototype,Jb);var Qb=function(t){void 0===t&&(t=[]),this.list=t;for(var e=t.length,i=0;i<e;++i){t[i].signals.disposed.add(this._remove,this)}},tx={first:{configurable:!0}};Qb.prototype._remove=function(t){var e=this.list.indexOf(t);-1!==e&&this.list.splice(e,1)},tx.first.get=function(){return this.list.length>0?this.list[0]:void 0},Qb.prototype.forEach=function(t){return this.list.forEach(t),this},Qb.prototype.dispose=function(){return this.forEach(function(t){return t.dispose()})},Object.defineProperties(Qb.prototype,tx);var ex=function(t){function e(){t.apply(this,arguments)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.setParameters=function(t){return this.forEach(function(e){return e.setParameters(t)})},e.prototype.setVisibility=function(t){return this.forEach(function(e){return e.setVisibility(t)})},e.prototype.setSelection=function(t){return this.forEach(function(e){return e.setSelection(t)})},e.prototype.setColor=function(t){return this.forEach(function(e){return e.setColor(t)})},e.prototype.update=function(t){return this.forEach(function(e){return e.update(t)})},e.prototype.build=function(t){return this.forEach(function(e){return e.build(t)})},e.prototype.dispose=function(t){return this.forEach(function(t){return t.dispose()})},e}(Qb),ix=Object.assign({defaultStep:1,defaultTimeout:50,defaultInterpolateType:"",defaultInterpolateStep:5,defaultMode:"loop",defaultDirection:"forward",initialFrame:0},Vb),rx=function(t){function e(e,i,r){var n=this;void 0===r&&(r={}),t.call(this,e,Object.assign({name:i.name},r)),this.trajectory=i,this.signals=Object.assign(this.signals,{frameChanged:new nl,playerChanged:new nl,countChanged:new nl,parametersChanged:new nl}),i.signals.frameChanged.add(function(t){n.signals.frameChanged.dispatch(t)}),i.signals.playerChanged.add(function(t){n.signals.playerChanged.dispatch(t)}),i.signals.countChanged.add(function(t){n.signals.countChanged.dispatch(t)}),void 0!==r.initialFrame&&this.setFrame(r.initialFrame)}t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e;var i={defaultParameters:{configurable:!0},type:{configurable:!0}};return i.defaultParameters.get=function(){return ix},i.type.get=function(){return"trajectory"},e.prototype.setFrame=function(t){this.trajectory.setFrame(t)},e.prototype.setParameters=function(t){void 0===t&&(t={}),this.trajectory.setParameters(t),this.signals.parametersChanged.dispatch(t)},e.prototype.dispose=function(){this.trajectory.dispose(),t.prototype.dispose.call(this)},Object.defineProperties(e.prototype,i),e}(Hb),nx=function(t,e){this.name=t,this.path=e,this.coordinates=[],this.boxes=[],this.times=[],this.timeOffset=0,this.deltaTime=1},ox={type:{configurable:!0}};ox.type.get=function(){return"Frames"},Object.defineProperties(nx.prototype,ox);var ax=function(t,e){var i,r;if(this.A=new zg(3,3),this.W=new zg(1,3),this.U=new zg(3,3),this.V=new zg(3,3),this.VH=new zg(3,3),this.R=new zg(3,3),this.tmp=new zg(3,3),this.c=new zg(3,3),t instanceof lb)i=t.atomCount;else{if(!(t instanceof Float32Array))return;i=t.length/3}if(e instanceof lb)r=e.atomCount;else{if(!(e instanceof Float32Array))return;r=e.length/3}var n=Math.min(i,r),o=new zg(3,n),a=new zg(3,n);this.coords1t=new zg(n,3),this.coords2t=new zg(n,3),this.c.data.set([1,0,0,0,1,0,0,0,-1]),this.prepCoords(t,o,n),this.prepCoords(e,a,n),this._superpose(o,a)};ax.prototype._superpose=function(e,i){var r,n,o,a,s,c,u,h,l,p,d,f,m,g,v,y,b,x,_,w,S,A;this.mean1=Vg(e),this.mean2=Vg(i),Hg(e,this.mean1),Hg(i,this.mean2),Ug(this.coords1t,e),Ug(this.coords2t,i),jg(this.A,this.coords2t,this.coords1t),qg(this.A,this.W,this.U,this.V),r=this.V,n=this.VH,o=r.data,a=n.data,s=o[4],c=o[8],u=o[5],h=o[7],l=o[0],p=l*s,d=l*u,f=o[3],m=o[1],g=f*m,v=o[2],y=f*v,b=o[6],w=1/(p*c-d*h-g*c+y*h+(x=b*m)*u-(_=b*v)*s),a[0]=(s*c-u*h)*w,a[1]=-(m*c-v*h)*w,a[2]=-(-m*u+v*s)*w,a[3]=-(f*c-u*b)*w,a[4]=(l*c-_)*w,a[5]=-(d-y)*w,a[6]=-(-f*h+s*b)*w,a[7]=-(l*h-x)*w,a[8]=(p-g)*w,Gg(this.R,this.U,this.VH),S=this.R,(A=S.data)[0]*A[4]*A[8]-A[0]*A[5]*A[7]-A[3]*A[1]*A[8]+A[3]*A[2]*A[7]+A[6]*A[1]*A[5]-A[6]*A[2]*A[4]<0&&(t.Debug&&ql.log("R not a right handed system"),Gg(this.tmp,this.c,this.VH),Gg(this.R,this.U,this.tmp))},ax.prototype.prepCoords=function(t,e,i){var r=0,n=3*i,o=e.data;t instanceof lb?t.eachAtom(function(t){r<n&&(o[r+0]=t.x,o[r+1]=t.y,o[r+2]=t.z,r+=3)}):t instanceof Float32Array?o.set(t.subarray(0,n)):ql.warn("prepCoords: input type unknown")},ax.prototype.transform=function(t){var e;if(t instanceof lb)e=t.atomCount;else{if(!(t instanceof Float32Array))return;e=t.length/3}var i=new zg(3,e),r=new zg(e,3);this.prepCoords(t,i,e),Hg(i,this.mean1),jg(r,this.R,i),Ug(i,r),function(t,e){for(var i=t.rows,r=t.cols,n=t.data,o=0,a=0;o<i;++o)for(var s=0;s<r;++s,++a)n[a]+=e[s]}(i,this.mean2);var n=0,o=i.data;t instanceof lb?t.eachAtom(function(t){t.x=o[n+0],t.y=o[n+1],t.z=o[n+2],n+=3}):t instanceof Float32Array?t.set(o.subarray(0,3*e)):ql.warn("transform: input type unknown")};var sx={step:1,timeout:50,start:0,end:0,interpolateType:"",interpolateStep:5,mode:"loop",direction:"forward"},cx=function(t,e){var i=this;void 0===e&&(e={}),this.signals={startedRunning:new nl,haltedRunning:new nl},this._run=!1,this._previousTime=0,this._currentTime=0,this._currentStep=1,t.signals.playerChanged.add(function(t){t!==i&&i.pause()},this);var r=yh(t.frameCount,1);this.traj=t,this.parameters=bh(e,sx),this.parameters.end=Math.min(yh(e.end,r-1),r-1),this.parameters.step=yh(e.step,Math.ceil((r+1)/100)),this._currentFrame=this.parameters.start,this._direction="bounce"===this.parameters.direction?"forward":this.parameters.direction,t.signals.countChanged.add(function(t){i.parameters.end=Math.min(yh(i.parameters.end,t-1),t-1)},this),this._animate=this._animate.bind(this)},ux={isRunning:{configurable:!0}};ux.isRunning.get=function(){return this._run},cx.prototype.setParameters=function(t){void 0===t&&(t={}),xh(this.parameters,t),void 0!==t.direction&&"bounce"!==this.parameters.direction&&(this._direction=this.parameters.direction)},cx.prototype._animate=function(){if(this._run){this._currentTime=window.performance.now();var t=this._currentTime-this._previousTime,e=this.parameters.interpolateType?this.parameters.interpolateStep:1,i=this.parameters.timeout/e,r=this.traj;if(r&&r.frameCount&&!r.inProgress&&t>=i)if(this.parameters.interpolateType)if(this._currentStep>this.parameters.interpolateStep&&(this._currentStep=1),1===this._currentStep&&(this._currentFrame=this._nextInterpolated()),r.hasFrame(this._currentFrame)){this._currentStep+=1;var n=this._currentStep/(this.parameters.interpolateStep+1),o=this._currentFrame,a=o[0],s=o[1],c=o[2],u=o[3];r.setFrameInterpolated(a,s,c,u,n,this.parameters.interpolateType),this._previousTime=this._currentTime}else r.loadFrame(this._c