define(["@jupyter-widgets/base"], function(__WEBPACK_EXTERNAL_MODULE_2__) { return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;
/******/
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

	module.exports = {};
	
	var loadedModules = [
	    __webpack_require__(1),
	    //require("./ngl.js"),
	]
	
	for (var i in loadedModules) {
	    if (loadedModules.hasOwnProperty(i)) {
	        var loadedModule = loadedModules[i];
	        for (var target_name in loadedModule) {
	            if (loadedModule.hasOwnProperty(target_name)) {
	                module.exports[target_name] = loadedModule[target_name];
	            }
	        }
	    }
	}
	
	module.exports['version'] = __webpack_require__(70).version;


/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {

	var widgets = __webpack_require__(2);
	var NGL = __webpack_require__(3);
	var $ = __webpack_require__(11);
	var _ = __webpack_require__(12);
	__webpack_require__(13);
	__webpack_require__(23);
	__webpack_require__(25);
	__webpack_require__(39);
	
	var Jupyter;
	if (typeof window !== 'undefined') {
	  Jupyter = window['Jupyter'] = window['Jupyter'] || {};
	} else {
	  Jupyter = Jupyter || {};
	}
	
	var NGLModel = widgets.DOMWidgetModel.extend({
	    defaults: function(){
	        return _.extend(widgets.DOMWidgetModel.prototype.defaults(), {
	            _model_name: 'NGLModel',
	            _model_module: 'nglview-js-widgets',
	            _model_module_version: __webpack_require__(70).version,
	            _view_name: "NGLView",
	            _view_module: "nglview-js-widgets",
	            _view_module_version: __webpack_require__(70).version,
	        });
	    }
	})
	
	var NGLView = widgets.DOMWidgetView.extend({
	    render: function() {
	        // init setting of frame
	        this.model.on("change:frame", this.frameChanged, this);
	
	        // init setting of frame
	        this.model.on("change:count", this.countChanged, this);
	
	        // init _parameters handling
	        this.model.on("change:_parameters", this.parametersChanged, this);
	
	        this.model.set('_ngl_version', NGL.Version);
	
	        // for player
	        this.delay = 100;
	        this.sync_frame = false;
	        this.sync_camera = false;
	
	        // get message from Python
	        this.model.on("msg:custom", function(msg) {
	            this.on_msg(msg);
	        }, this);
	
	        if (this.model.comm) {
	            // for embeding in website
	            this.model.comm.on_msg(function(msg) {
	                var buffers = msg.buffers;
	                var content = msg.content.data.content;
	                if (buffers.length && content) {
	                    content.buffers = buffers;
	                }
	                this.model._handle_comm_msg.call(this.model, msg);
	            }.bind(this));
	        }
	
	        // init NGL stage
	        NGL.useWorker = false;
	        this.stage = new NGL.Stage(undefined, {
	            backgroundColor: "white"
	        });
	        this.structureComponent = undefined;
	        this.$container = $(this.stage.viewer.container);
	        this.$el.append(this.$container);
	        this.$container.resizable({
	            resize: function(event, ui) {
	                this.setSize(ui.size.width + "px", ui.size.height + "px");
	            }.bind(this)
	        });
	        this.displayed.then(function() {
	            this.ngl_view_id = this.get_last_child_id();
	            var that = this;
	            var width = this.$el.parent().width() + "px";
	            var height = "300px";
	
	            this.setSize(width, height);
	            this.$container.resizable(
	                "option", "maxWidth", this.$el.parent().width()
	            );
	            if (this.model.get("_ngl_serialize")){
	                that.handle_embed();
	            }else{
	                this.requestUpdateStageParameters();
	                if (this.model.views.length == 1){
	                    this.serialize_camera_orientation();
	                }else{
	                    this.set_camera_orientation(that.model.get("_camera_orientation"));
	                }
	            }
	        }.bind(this));
	
	        this.stage.viewerControls.signals.changed.add(function() {
	            this.serialize_camera_orientation();
	        }.bind(this));
	
	        // init toggle fullscreen
	        $(this.stage.viewer.container).dblclick(function() {
	            this.stage.toggleFullscreen();
	        }.bind(this));
	
	        // init picking handling
	        this.$pickingInfo = $("<div></div>")
	            .css("position", "absolute")
	            .css("top", "5%")
	            .css("left", "3%")
	            .css("background-color", "white")
	            .css("padding", "2px 5px 2px 5px")
	            .css("opacity", "0.7")
	            .appendTo(this.$container);
	
	        var $inputNotebookCommand = $('<input id="input_notebook_command" type="text" style="border:1px solid skyblue" size="50"></input>');
	        var that = this;
	
	        $inputNotebookCommand.keypress(function(e) {
	            var command = $("#input_notebook_command").val();
	            if (e.which == 13) {
	                $("#input_notebook_command").val("")
	                Jupyter.notebook.kernel.execute(command);
	            }
	        });
	
	        this.$notebook_text = $("<div></div>")
	            .css("position", "absolute")
	            .css("bottom", "5%")
	            .css("left", "3%")
	            .css("padding", "2px 5px 2px 5px")
	            .css("opacity", "0.7")
	            .append($inputNotebookCommand)
	            .appendTo(this.$container);
	        this.$notebook_text.hide();
	
	        this.stage.signals.clicked.add(function(pd) {
	            if (pd) {
	                var pd2 = {};
	                if (pd.atom) pd2.atom = pd.atom.toObject();
	                if (pd.bond) pd2.bond = pd.bond.toObject();
	                if (pd.instance) pd2.instance = pd.instance;
	                this.model.set("picked", pd2);
	                this.touch();
	                var pickingText = "";
	                if (pd.atom) {
	                    pickingText = "Atom: " + pd.atom.qualifiedName();
	                } else if (pd.bond) {
	                    pickingText = "Bond: " + pd.bond.atom1.qualifiedName() + " - " + pd.bond.atom2.qualifiedName();
	                }
	                this.$pickingInfo.text(pickingText);
	            }
	        }, this);
	
	        this.initPlayer();
	
	        var container = this.stage.viewer.container;
	        that = this;
	        container.addEventListener('dragover', function(e) {
	            e.stopPropagation();
	            e.preventDefault();
	            e.dataTransfer.dropEffect = 'copy';
	        }, false);
	
	        container.addEventListener('drop', function(e) {
	            e.stopPropagation();
	            e.preventDefault();
	            var file = e.dataTransfer.files[0];
	
	            that.stage.loadFile(file).then(function(o){
	                that._handle_loading_file_finished();
	                o;
	            });
	            var numDroppedFiles = that.model.get("_n_dragged_files");
	            that.model.set("_n_dragged_files", numDroppedFiles + 1);
	            that.touch();
	        }, false);
	
	        that = this;
	        this.stage.signals.componentAdded.add(function() {
	            var len = this.stage.compList.length;
	            this.model.set("n_components", len);
	            this.touch();
	            var comp = this.stage.compList[len - 1];
	            comp.signals.representationRemoved.add(function() {
	                that.request_repr_dict();
	            });
	            comp.signals.representationAdded.add(function() {
	                that.request_repr_dict();
	            });
	        }, this);
	
	        this.stage.signals.componentRemoved.add(function() {
	            this.model.set("n_components", this.stage.compList.length);
	            this.touch();
	        }, this);
	
	        // for callbacks from Python
	        // must be after initializing NGL.Stage
	        this.send({
	            'type': 'request_loaded',
	            'data': true
	        })
	        var state_params = this.stage.getParameters();
	        this.model.set('_ngl_original_stage_parameters', state_params);
	        this.touch();
	    },
	
	    serialize_camera_orientation: function(){
	         var m = this.stage.viewerControls.getOrientation();
	         this.model.set('_camera_orientation', m.elements);
	         this.touch();
	    },
	
	    set_camera_orientation: function(orientation){
	        if (orientation.length > 0){
	            this.stage.viewerControls.orient(orientation);
	            this.serialize_camera_orientation();
	        }
	    },
	
	    handle_embed: function(){
	        var that = this;
	        var ngl_coordinate_resource = that.model.get("_ngl_coordinate_resource");
	        var ngl_msg_archive = that.model.get("_ngl_msg_archive");
	        var ngl_stage_params = that.model.get('_ngl_full_stage_parameters_embed');
	        var loadfile_list = [];
	
	        _.each(ngl_msg_archive, function(msg){
	            if (msg.methodName == 'loadFile'){
	                if (msg.kwargs && msg.kwargs.defaultRepresentation) {
	                    // no need to add default representation as all representations
	                    // are serialized separately, also it unwantedly sets the orientation
	                    msg.kwargs.defaultRepresentation = false
	                 }
	                loadfile_list.push(that._get_loadFile_promise(msg));
	            }
	        });
	
	
	        Promise.all(loadfile_list).then(function(compList){
	            that._set_representation_from_backend(compList);
	            that.stage.setParameters(ngl_stage_params);
	            that.set_camera_orientation(that.model.get("_camera_orientation"));
	
	            var frame = 0;
	            var count = ngl_coordinate_resource['n_frames'];
	            delete ngl_coordinate_resource['n_frames'];
	
	            var play = function(){
	                that.$playerButton.text("pause");
	                that.playerInterval = setInterval(function(){
	                    frame = frame + 1;
	                    if (frame > count - 1){
	                        frame = 0;
	                    }
	                    that.$playerSlider.slider("option", "value", frame);
	                    that.updateCoordinatesFromDict(ngl_coordinate_resource, frame);
	                }, that.delay)
	            }
	
	            var pause = function() {
	                that.$playerButton.text("play");
	                if (that.playerInterval !== undefined) {
	                    clearInterval(that.playerInterval);
	                }
	            }.bind(that);
	
	            if (that.$playerButton){
	                that.$playerButton
	                    .off('click')
	                    .click(function(event) {
	                        if (that.$playerButton.text() === "play") {
	                            play();
	                        } else if (that.$playerButton.text() === "pause") {
	                            pause();
	                        }
	                        event; // to pass eslint
	                    }.bind(that));
	                that.$playerSlider.slider({
	                    max : count-1,
	                    slide: function(event, ui) {
	                        pause();
	                        that.updateCoordinatesFromDict(ngl_coordinate_resource, ui.value);
	                        frame = ui.value;
	                    }.bind(that)
	                })
	           }
	        });
	    },
	
	    updateCoordinatesFromDict: function(cdict, frame_index){
	        // update coordinates for given "index"
	        // cdict = Dict[int, List[base64]]
	        var keys = Object.keys(cdict);
	
	        for (var i = 0; i < keys.length; i++) {
	            var traj_index = keys[i];
	            var coordinates = this.decode_base64(cdict[traj_index][frame_index]);
	            if (coordinates && coordinates.byteLength > 0) {
	                this.updateCoordinates(coordinates, traj_index);
	            }
	        }
	    },
	
	    setSelector: function(selector_id) {
	        // id is uuid that will be set from Python
	        var selector = "<div class='" + selector_id + "'></div>";
	        this.$ngl_selector = $(selector)
	            .css("position", "absolute")
	            .css("bottom", "5%")
	            .css("left", "3%")
	            .css("padding", "2px 5px 2px 5px")
	            .css("opacity", "0.7")
	            .appendTo(this.$container);
	    },
	
	    setIPythonLikeCell: function() {
	        var cell = Jupyter.notebook.insert_cell_at_bottom();
	
	        var handler = function(event) {
	            var selected_cell = Jupyter.notebook.get_selected_cell();
	            if (selected_cell.cell_id === cell.cell_id) {
	                selected_cell.execute();
	                selected_cell.set_text('');
	            }
	            event; // to pass eslint
	            return false;
	        };
	
	        var action = {
	            help: 'run cell',
	            help_index: 'zz',
	            handler: handler
	        };
	
	        Jupyter.keyboard_manager.edit_shortcuts.add_shortcut('enter', action);
	    },
	
	    hideNotebookCommandBox: function() {
	        this.$notebook_text.hide();
	    },
	
	    showNotebookCommandBox: function() {
	        this.$notebook_text.show();
	    },
	
	    requestFrame: function() {
	        this.send({
	            'type': 'request_frame',
	            'data': 'frame'
	        });
	    },
	
	    requestUpdateStageParameters: function() {
	        var updated_params = this.stage.getParameters();
	        this.model.set('_ngl_full_stage_parameters', updated_params);
	        this.touch();
	    },
	
	    requestReprParameters: function(component_index, repr_index) {
	        var comp = this.stage.compList[component_index];
	        var repr = comp.reprList[repr_index];
	        var msg = repr.repr.getParameters();
	
	        if (msg) {
	            msg['name'] = repr.name;
	            this.send({
	                'type': 'repr_parameters',
	                'data': msg
	            });
	        }
	    },
	
	    request_repr_dict: function() {
	        var n_components = this.stage.compList.length;
	        var msg = {};
	
	        for (var i = 0; i < n_components; i++) {
	            var comp = this.stage.compList[i];
	            msg[i] = {};
	            var msgi = msg[i];
	            for (var j = 0; j < comp.reprList.length; j++) {
	                var repr = comp.reprList[j];
	                msgi[j] = {};
	                msgi[j]['type'] = repr.name;
	                msgi[j]['params'] = repr.repr.getParameters();
	            }
	        }
	        this.send({
	            // make sure we are using "request_repr_dict" name
	            // in backend too.
	            'type': 'request_repr_dict',
	            'data': msg
	        });
	    },
	
	    // setDraggable: function(params) {
	    //     if (params) {
	    //         this.$container.draggable(params);
	    //     } else {
	    //         this.$container.draggable();
	    //     }
	    // },
	    setDelay: function(delay) {
	        this.delay = delay;
	    },
	
	    setSyncFrame: function() {
	        this.sync_frame = true;
	    },
	
	    setUnSyncFrame: function() {
	        this.sync_frame = false;
	    },
	
	    setSyncCamera: function() {
	        this.sync_camera = true;
	        this.serialize_camera_orientation();
	    },
	
	    setUnSyncCamera: function() {
	        this.sync_camera = false;
	    },
	
	    viewXZPlane: function() {
	        var m = new NGL.Matrix4().makeRotationX( Math.PI / 2 );
	        var q = new NGL.Quaternion().setFromRotationMatrix( m );
	        this.stage.viewerControls.rotate( q );
	    },
	
	    set_representation_from_backend: function(){
	        this._set_representation_from_backend(this.stage.compList);
	    },
	
	    _set_representation_from_backend: function(compList){
	        if (compList.length > 0){
	            var ngl_repr_dict = this.model.get('_ngl_repr_dict');
	            for (var index in ngl_repr_dict){
	                var comp = compList[index];
	                comp.removeAllRepresentations();
	                var reprlist = ngl_repr_dict[index];
	                for (var j in reprlist){
	                    var repr = reprlist[j];
	                    if (repr){
	                        comp.addRepresentation(repr.type, repr.params);
	                    }
	                }
	            }
	        }
	    },
	
	    initPlayer: function() {
	        // init player
	        if (this.model.get("count")) {
	            var frame = this.model.get("frame");
	            var play = function() {
	                this.$playerButton.text("pause");
	                this.playerInterval = setInterval(function() {
	                    var frame = this.model.get("frame") + 1;
	                    var count = this.model.get("count");
	                    if (frame >= count) frame = 0;
	
	                    if (this.sync_frame) {
	                        this.model.set("frame", frame);
	                        this.touch();
	                    } else {
	                        this.requestFrame();
	                    }
	                }.bind(this), this.delay);
	            }.bind(this);
	            var pause = function() {
	                this.$playerButton.text("play");
	                if (this.playerInterval !== undefined) {
	                    clearInterval(this.playerInterval);
	                }
	            }.bind(this);
	            this.$playerButton = $("<button>play</button>")
	                .css("float", "left")
	                .css("width", "55px")
	                .css("opacity", "0.7")
	                .click(function(event) {
	                    if (this.$playerButton.text() === "play") {
	                        play();
	                    } else if (this.$playerButton.text() === "pause") {
	                        pause();
	                    }
	                    event; // to pass eslint
	                }.bind(this));
	            this.$playerSlider = $("<div></div>")
	                .css("margin-left", "70px")
	                .css("position", "relative")
	                .css("bottom", "-7px")
	                .slider({
	                    min: 0,
	                    max: this.model.get("count") - 1,
	                    value: frame,
	                    slide: function(event, ui) {
	                        pause();
	                        this.model.set("frame", ui.value);
	                        this.touch();
	                    }.bind(this)
	                });
	            this.$player = $("<div></div>")
	                .css("position", "absolute")
	                .css("bottom", "5%")
	                .css("width", "94%")
	                .css("margin-left", "3%")
	                .css("opacity", "0.7")
	                .append(this.$playerButton)
	                .append(this.$playerSlider)
	                .appendTo(this.$container);
	            this.model.on("change:frame", function() {
	                this.$playerSlider.slider("value", this.model.get("frame"));
	            }, this);
	
	            if (this.model.get("count") < 2) {
	                this.$player.hide()
	            }
	        }
	    },
	
	    countChanged: function() {
	        var count = this.model.get("count");
	        this.$playerSlider.slider({
	            max: count - 1
	        });
	        if (this.model.get("count") > 1) {
	            this.$player.show()
	        }
	    },
	
	    setVisibilityForRepr: function(component_index, repr_index, value) {
	        // value = True/False
	        var component = this.stage.compList[component_index];
	        var repr = component.reprList[repr_index];
	
	        if (repr) {
	            repr.setVisibility(value);
	        }
	    },
	
	    removeRepresentation: function(component_index, repr_index) {
	        var component = this.stage.compList[component_index];
	        var repr = component.reprList[repr_index]
	
	        if (repr) {
	            component.removeRepresentation(repr);
	        }
	    },
	
	    removeRepresentationsByName: function(repr_name, component_index) {
	        var component = this.stage.compList[component_index];
	
	        if (component) {
	            component.reprList.forEach(function(repr) {
	                if (repr.name == repr_name) {
	                    component.removeRepresentation(repr);
	                }
	            })
	        }
	    },
	
	    updateRepresentationForComponent: function(repr_index, component_index, params) {
	        var component = this.stage.compList[component_index];
	        var that = this;
	        var repr = component.reprList[repr_index];
	        if (repr) {
	            repr.setParameters(params);
	            that.request_repr_dict();
	        }
	    },
	
	    updateRepresentationsByName: function(repr_name, component_index, params) {
	        var component = this.stage.compList[component_index];
	        var that = this;
	
	        if (component) {
	            component.reprList.forEach(function(repr) {
	                if (repr.name == repr_name) {
	                    repr.setParameters(params);
	                    that.request_repr_dict();
	                }
	            })
	        }
	    },
	
	    setRepresentation: function(name, params, component_index, repr_index) {
	        var component = this.stage.compList[component_index];
	        var repr = component.reprList[repr_index];
	        var that = this;
	
	        if (repr) {
	            params['useWorker'] = false;
	            var new_repr = NGL.makeRepresentation(name, component.structure,
	                this.stage.viewer, params);
	            if (new_repr) {
	                repr.setRepresentation(new_repr);
	                repr.name = name;
	                component.reprList[repr_index] = repr;
	                that.request_repr_dict();
	            }
	        }
	    },
	
	    setColorByResidue: function(colors, component_index, repr_index){
	        console.log('NGL.ColormakerRegistry', NGL.ColormakerRegistry);
	        var repr = this.stage.compList[component_index].reprList[repr_index];
	        var schemeId = NGL.ColormakerRegistry.addScheme(function(params){
	            this.atomColor = function(atom){
	                 var color = colors[atom.residueIndex];
	                 return color
	            };
	            params; // to pass eslint; ack;
	        });
	        repr.setColor(schemeId);
	    },
	
	    addShape: function(name, shapes) {
	        // shapes: List[Tuple[str, ...]]
	        // e.g: [('sphere', ...), ('cone', ...)]
	        var shape = new NGL.Shape(name);
	        var shape_dict = {
	            'sphere': shape.addSphere,
	            'ellipsoid': shape.addEllipsoid,
	            'cylinder': shape.addCylinder,
	            'cone': shape.addCone,
	            'mesh': shape.addMesh,
	            'arrow': shape.addArrow,
	            'text': shape.addText,
	            'label': shape.addText,
	            'tetrahedron': shape.addTetrahedron,
	            'octahedron': shape.addOctahedron,
	            'torus': shape.addTorus
	        };
	        for (var i = 0; i < shapes.length; i++) {
	            var shapes_i = shapes[i]
	            var shape_type = shapes_i[0];
	            var params = shapes_i.slice(1, shapes_i.length);
	            // e.g params = ('sphere', [ 0, 0, 9 ], [ 1, 0, 0 ], 1.5)
	
	            var func = shape_dict[shape_type];
	            func.apply(shape, params);
	            // shape.func(params);
	        }
	        var shapeComp = this.stage.addComponentFromObject(shape);
	        shapeComp.addRepresentation("buffer");
	    },
	
	    addBuffer: function(name, kwargs){
	        var class_dict = {
	            "arrow": NGL.ArrowBuffer,
	            "box": NGL.BoXbuffer,
	            "cone": NGL.ConeBuffer,
	            "cylinder": NGL.CylinderBuffer,
	            "ellipsoid": NGL.EllipsoidBuffer,
	            "octahedron": NGL.OctahedronBuffer,
	            "sphere": NGL.SphereBuffer,
	            "text": NGL.TextBuffer,
	            "tetrahedron": NGL.TetrahedronBuffer,
	            "torus": NGL.TorusBuffer
	        };
	
	        var params = {};
	        for (var key in kwargs){
	            params[key] = new Float32Array(kwargs[key]);
	        }
	        var shape = new NGL.Shape("shape");
	        var buffer_class = class_dict[name];
	        var buffer = new buffer_class(params);
	        shape.addBuffer(buffer);
	        var shapeComp = this.stage.addComponentFromObject(shape);
	        shapeComp.addRepresentation("buffer");
	    },
	
	    replaceStructure: function(structure){
	         var blob = new Blob([structure.data], {type: "text/plain"});
	         var params = structure.params || {};
	         params.ext = structure.ext;
	         params.defaultRepresentation = false;
	         var comp = this.stage.compList[0];
	         var representations = comp.reprList.slice();
	         var old_orientation = this.stage.viewerControls.getOrientation();
	         var that = this;
	         this.stage.loadFile(blob, params).then(function(component) {
	             that.stage.viewerControls.orient(old_orientation);
	             representations.forEach(function(repr) {
	                 var repr_name = repr.name;
	                 var repr_params = repr.repr.getParameters();
	                 // Note: not using repr.repr.type, repr.repr.params
	                 // since seems to me that repr.repr.params won't return correct "sele"
	                 component.addRepresentation(repr_name, repr_params);
	             });
	             that.stage.removeComponent(comp);
	             that._handle_loading_file_finished();
	         });
	    },
	
	    superpose: function(cindex0, cindex1, align, sele0, sele1) {
	        // superpose two components with given params
	        var component0 = this.stage.compList[cindex0];
	        var component1 = this.stage.compList[cindex1];
	        component1.superpose(component0, align, sele0, sele1);
	    },
	
	    decode_base64: function(base64) {
	        // lightly adapted from Niklas
	
	        /*
	         * base64-arraybuffer
	         * https://github.com/niklasvh/base64-arraybuffer
	         *
	         * Copyright (c) 2012 Niklas von Hertzen
	         * Licensed under the MIT license.
	         */
	        var chars =
	            "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
	        var bufferLength = base64.length * 0.75,
	            len = base64.length,
	            i, p = 0,
	            encoded1, encoded2, encoded3, encoded4;
	
	        if (base64[base64.length - 1] === "=") {
	            bufferLength--;
	            if (base64[base64.length - 2] === "=") {
	                bufferLength--;
	            }
	        }
	
	        var arraybuffer = new ArrayBuffer(bufferLength),
	            bytes = new Uint8Array(arraybuffer);
	
	        for (i = 0; i < len; i += 4) {
	            encoded1 = chars.indexOf(base64[i]);
	            encoded2 = chars.indexOf(base64[i + 1]);
	            encoded3 = chars.indexOf(base64[i + 2]);
	            encoded4 = chars.indexOf(base64[i + 3]);
	
	            bytes[p++] = (encoded1 << 2) | (encoded2 >> 4);
	            bytes[p++] = ((encoded2 & 15) << 4) | (encoded3 >> 2);
	            bytes[p++] = ((encoded3 & 3) << 6) | (encoded4 & 63);
	        }
	
	        return arraybuffer;
	    },
	
	    updateCoordinates: function(coordinates, model) {
	        // coordinates must be ArrayBuffer (use this.decode_base64)
	        var component = this.stage.compList[model];
	        if (coordinates && component) {
	            var coords = new Float32Array(coordinates);
	            component.structure.updatePosition(coords);
	            component.updateRepresentations({
	                "position": true
	            });
	        }
	    },
	
	    handleResize: function() {
	        this.$container.resizable({
	            resize: function(event, ui) {
	                this.setSize(ui.size.width + "px", ui.size.height + "px");
	            }.bind(this)
	        })
	    },
	
	    setSize: function(width, height) {
	        this.stage.viewer.container.style.width = width;
	        this.stage.viewer.container.style.height = height;
	        this.stage.handleResize();
	    },
	
	    openNotebookCommandDialog: function() {
	        var that = this;
	        var dialog = this.$notebook_text.dialog({
	            draggable: true,
	            resizable: true,
	            modal: false,
	            show: {
	                effect: "blind",
	                duration: 150
	            },
	            close: function(event, ui) {
	                that.$container.append(that.$notebook_text);
	                that.$notebook_text.dialog('destroy');
	                event; ui; // to pass eslint; ack;
	            },
	        });
	        dialog.css({
	            overflow: 'hidden'
	        });
	        dialog.prev('.ui-dialog-titlebar')
	            .css({
	                'background': 'transparent',
	                'border': 'none'
	            });
	        Jupyter.keyboard_manager.register_events(dialog);
	    },
	
	    setDialog: function() {
	        var $nb_container = Jupyter.notebook.container;
	        var that = this;
	        var dialog = this.$container.dialog({
	            title: "NGLView",
	            draggable: true,
	            resizable: true,
	            modal: false,
	            width: window.innerWidth - $nb_container.width() - $nb_container.offset().left - 50,
	            height: 'auto',
	            position: {
	                my: 'right',
	                at: 'right',
	                of: window
	            },
	            show: {
	                effect: "blind",
	                duration: 150
	            },
	            close: function(event, ui) {
	                that.$el.append(that.$container);
	                that.$container.dialog('destroy');
	                that.handleResize();
	                event; ui; // to pass eslint; ack;
	            },
	            resize: function(event, ui) {
	                that.stage.handleResize();
	                that.setSize(ui.size.width + "px", ui.size.height + "px");
	            }.bind(that),
	        });
	        dialog.css({
	            overflow: 'hidden'
	        });
	        dialog.prev('.ui-dialog-titlebar')
	            .css({
	                'background': 'transparent',
	                'border': 'none'
	            });
	    },
	
	    resizeNotebook: function(width) {
	        var $nb_container = Jupyter.notebook.container;
	        $nb_container.width(width);
	
	        if (this.$container.dialog) {
	            this.$container.dialog({
	                width: $nb_container.offset().left
	            });
	        }
	    },
	
	    parametersChanged: function() {
	        var _parameters = this.model.get("_parameters");
	        this.setParameters(_parameters);
	    },
	
	    setParameters: function(parameters) {
	        this.stage.setParameters(parameters);
	
	        // do not set _ngl_full_stage_parameters here
	        // or parameters will be never updated (not sure why)
	        // use observe in python side
	        var updated_params = this.stage.getParameters();
	        this.send({
	            'type': 'stage_parameters',
	            'data': updated_params
	        })
	    },
	
	    _downloadImage: function(filename, params) {
	        if (this.ngl_view_id == this.get_last_child_id()){
	            this.stage.makeImage(params).then(function(blob) {
	                NGL.download(blob, filename);
	            })
	        }
	    },
	
	    _exportImage: function(params) {
	        if (this.ngl_view_id == this.get_last_child_id()){
	            this.stage.makeImage(params).then(function(blob) {
	                var reader = new FileReader();
	                var arr_str;
	                reader.onload = function() {
	                    arr_str = reader.result.replace("data:image/png;base64,", "");
	                    this.model.set("_image_data", arr_str);
	                    this.touch();
	                }.bind(this);
	                reader.readAsDataURL(blob);
	            }.bind(this));
	        }
	    },
	
	    cleanOutput: function() {
	
	        var cells = Jupyter.notebook.get_cells();
	
	        for (var i = 0; i < cells.length; i++) {
	            var cell = cells[i];
	            if (cell.output_area.outputs.length > 0) {
	                var out = cell.output_area.outputs[0];
	                if (out.output_type == 'display_data') {
	                    cell.clear_output();
	                }
	            }
	        }
	    },
	
	    _handle_loading_file_finished: function() {
	        this.send({'type': 'async_message', 'data': 'ok'});
	    },
	
	    _get_loadFile_promise: function(msg){
	         // args = [{'type': ..., 'data': ...}]
	         var args0 = msg.args[0];
	         if (args0.type == 'blob') {
	             var blob;
	             if (args0.binary) {
	                 var decoded_data = this.decode_base64(args0.data);
	                 blob = new Blob([decoded_data], {
	                     type: "application/octet-binary"
	                 });
	             } else {
	                 blob = new Blob([args0.data], {
	                     type: "text/plain"
	                 });
	             }
	             return this.stage.loadFile(blob, msg.kwargs)
	         } else {
	             return this.stage.loadFile(msg.args[0].data, msg.kwargs)
	         }
	    },
	
	    get_last_child_id: function(){
	        var keys = Object.keys(this.model.views);
	        return keys[keys.length-1]
	    },
	
	    _handle_stage_loadFile: function(msg){
	        // args = [{'type': ..., 'data': ...}]
	        if (this.ngl_view_id != this.get_last_child_id() && msg.last_child){
	            return
	        }
	        var that = this;
	        this._get_loadFile_promise(msg).then(function(o){
	            that._handle_loading_file_finished();
	            o;
	        });
	    },
	
	    on_msg: function(msg) {
	        // TODO: re-organize
	        if (msg.type == 'call_method') {
	            var index, component, func, stage;
	            var new_args = msg.args.slice();
	            new_args.push(msg.kwargs);
	
	            switch (msg.target) {
	                case 'Stage':
	                    var stage_func = this.stage[msg.methodName];
	                    stage = this.stage;
	                    if (msg.methodName == 'screenshot') {
	                        NGL.screenshot(this.stage.viewer, msg.kwargs);
	                    } else if (msg.methodName == 'removeComponent') {
	                        index = msg.args[0];
	                        component = this.stage.compList[index];
	                        this.stage.removeComponent(component);
	                    } else if (msg.methodName == 'loadFile') {
	                        if (this.model.views.length > 1 && msg.kwargs &&
	                            msg.kwargs.defaultRepresentation) {
	                            // no need to add default representation as all representations
	                            // are serialized separately, also it unwantedly sets the orientation
	                            msg.kwargs.defaultRepresentation = false
	                        }
	                        this._handle_stage_loadFile(msg);
	                    } else {
	                            stage_func.apply(stage, new_args);
	                    }
	                    break;
	                case 'Viewer':
	                    var viewer = this.stage.viewer;
	                    func = this.stage.viewer[msg.methodName];
	                    func.apply(viewer, new_args);
	                    break;
	                case 'viewerControls':
	                    var controls = this.stage.viewerControls;
	                    func = controls[msg.methodName];
	                    func.apply(controls, new_args);
	                    break;
	                case 'compList':
	                    index = msg['component_index'];
	                    component = this.stage.compList[index];
	                    func = component[msg.methodName];
	                    func.apply(component, new_args);
	                    break;
	                case 'StructureComponent':
	                    component = this.structureComponent;
	                    func = component[msg.methodName];
	                    func.apply(component, new_args);
	                    break;
	                case 'Widget':
	                    func = this[msg.methodName];
	                    if (func) {
	                        func.apply(this, new_args);
	                    } else {
	                        // send error message to Python?
	                        console.log('can not create func for ' + msg.methodName);
	                    }
	                    break;
	                case 'player':
	                    func = this.$player[msg.methodName];
	                    if (func) {
	                        func.apply(this.$player, new_args);
	                    } else {
	                        // send error message to Python?
	                        console.log('can not create func for ' + msg.methodName);
	                    }
	                    break;
	                case 'Representation':
	                    var component_index = msg['component_index'];
	                    var repr_index = msg['repr_index'];
	                    component = this.stage.compList[component_index];
	                    var repr = component.reprList[repr_index];
	                    func = repr[msg.methodName];
	                    if (repr && func) {
	                        func.apply(repr, new_args);
	                    }
	                    break;
	                default:
	                    console.log('there is no method for ' + msg.target);
	                    break;
	            }
	        } else if (msg.type == 'base64_single') {
	            var coordinatesDict = msg.data;
	            var keys = Object.keys(coordinatesDict);
	
	            for (var i = 0; i < keys.length; i++) {
	                var traj_index = keys[i];
	                var coordinates = this.decode_base64(coordinatesDict[traj_index]);
	                if (coordinates && coordinates.byteLength > 0) {
	                    this.updateCoordinates(coordinates, traj_index);
	                }
	            }
	        } else if (msg.type == 'binary_single') {
	            var coordinateMeta = msg.data;
	            keys = Object.keys(coordinateMeta);
	
	            for (i = 0; i < keys.length; i++) {
	                traj_index = keys[i];
	                coordinates = new Float32Array(msg.buffers[i].buffer);
	                if (coordinates.byteLength > 0) {
	                    this.updateCoordinates(coordinates, traj_index);
	                }
	            }
	        } else if (msg.type == 'get') {
	            if (msg.data == 'camera') {
	                this.send(JSON.stringify(this.stage.viewer.camera));
	            } else if (msg.data == 'parameters') {
	                this.send(JSON.stringify(this.stage.parameters));
	            } else {
	                console.log("Number of components", this.stage.compList.length);
	                console.log("ngl_view_id", this.ngl_view_id);
	            }
	        }
	    },
	});
	
	module.exports = {
	    'NGLView': NGLView,
	    'NGLModel': NGLModel,
	    'NGL': NGL,
	};


/***/ }),
/* 2 */
/***/ (function(module, exports) {

	module.exports = __WEBPACK_EXTERNAL_MODULE_2__;

/***/ }),
/* 3 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(setImmediate, Buffer) {!function(t,e){ true?e(exports):"function"==typeof define&&define.amd?define(["exports"],e):e(t.NGL={})}(this,function(t){"use strict";function e(){}function i(t,e){return function(){t.apply(e,arguments)}}function r(t){if("object"!=typeof this)throw new TypeError("Promises must be constructed via new");if("function"!=typeof t)throw new TypeError("not a function");this._state=0,this._handled=!1,this._value=void 0,this._deferreds=[],u(t,this)}function n(t,e){for(;3===t._state;)t=t._value;0!==t._state?(t._handled=!0,_l(function(){var i=1===t._state?e.onFulfilled:e.onRejected;if(null!==i){var r;try{r=i(t._value)}catch(t){return void a(e.promise,t)}o(e.promise,r)}else(1===t._state?o:a)(e.promise,t._value)})):t._deferreds.push(e)}function o(t,e){try{if(e===t)throw new TypeError("A promise cannot be resolved with itself.");if(e&&("object"==typeof e||"function"==typeof e)){var n=e.then;if(e instanceof r)return t._state=3,t._value=e,void s(t);if("function"==typeof n)return void u(i(n,e),t)}t._state=1,t._value=e,s(t)}catch(e){a(t,e)}}function a(t,e){t._state=2,t._value=e,s(t)}function s(t){2===t._state&&0===t._deferreds.length&&_l(function(){t._handled||wl(t._value)});for(var e=0,i=t._deferreds.length;e<i;e++)n(t,t._deferreds[e]);t._deferreds=null}function c(t,e,i){this.onFulfilled="function"==typeof t?t:null,this.onRejected="function"==typeof e?e:null,this.promise=i}function u(t,e){var i=!1;try{t(function(t){i||(i=!0,o(e,t))},function(t){i||(i=!0,a(e,t))})}catch(t){if(i)return;i=!0,a(e,t)}}function l(){}function h(t,e){this.x=t||0,this.y=e||0}function p(t,e,i,r,n,o,a,s,c,u){Object.defineProperty(this,"id",{value:Mp++}),this.uuid=Ap.generateUUID(),this.name="",this.image=void 0!==t?t:p.DEFAULT_IMAGE,this.mipmaps=[],this.mapping=void 0!==e?e:p.DEFAULT_MAPPING,this.wrapS=void 0!==i?i:Th,this.wrapT=void 0!==r?r:Th,this.magFilter=void 0!==n?n:Oh,this.minFilter=void 0!==o?o:Nh,this.anisotropy=void 0!==c?c:1,this.format=void 0!==a?a:Zh,this.type=void 0!==s?s:kh,this.offset=new h(0,0),this.repeat=new h(1,1),this.generateMipmaps=!0,this.premultiplyAlpha=!1,this.flipY=!0,this.unpackAlignment=4,this.encoding=void 0!==u?u:mp,this.version=0,this.onUpdate=null}function d(t,e,i,r){this.x=t||0,this.y=e||0,this.z=i||0,this.w=void 0!==r?r:1}function f(t,e,i){this.uuid=Ap.generateUUID(),this.width=t,this.height=e,this.scissor=new d(0,0,t,e),this.scissorTest=!1,this.viewport=new d(0,0,t,e),void 0===(i=i||{}).minFilter&&(i.minFilter=Oh),this.texture=new p(void 0,void 0,i.wrapS,i.wrapT,i.magFilter,i.minFilter,i.format,i.type,i.anisotropy,i.encoding),this.depthBuffer=void 0===i.depthBuffer||i.depthBuffer,this.stencilBuffer=void 0===i.stencilBuffer||i.stencilBuffer,this.depthTexture=void 0!==i.depthTexture?i.depthTexture:null}function m(t,e,i){f.call(this,t,e,i),this.activeCubeFace=0,this.activeMipMapLevel=0}function g(t,e,i,r){this._x=t||0,this._y=e||0,this._z=i||0,this._w=void 0!==r?r:1}function v(t,e,i){this.x=t||0,this.y=e||0,this.z=i||0}function y(){this.elements=[1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1],arguments.length>0&&console.error("THREE.Matrix4: the constructor no longer reads arguments. use .set() instead.")}function b(t,e,i,r,n,o,a,s,c,u,l,h){p.call(this,null,o,a,s,c,u,r,n,l,h),this.image={data:t,width:e,height:i},this.magFilter=void 0!==c?c:Ih,this.minFilter=void 0!==u?u:Ih,this.generateMipmaps=!1,this.flipY=!1,this.unpackAlignment=1}function x(t,e,i,r,n,o,a,s,c,u){t=void 0!==t?t:[],e=void 0!==e?e:xh,p.call(this,t,e,i,r,n,o,a,s,c,u),this.flipY=!1}function _(){this.seq=[],this.map={}}function w(t,e,i){var r=t[0];if(r<=0||r>0)return t;var n=e*i,o=Tp[n];if(void 0===o&&(o=new Float32Array(n),Tp[n]=o),0!==e){r.toArray(o,0);for(var a=1,s=0;a!==e;++a)s+=i,t[a].toArray(o,s)}return o}function S(t,e){var i=Cp[e];void 0===i&&(i=new Int32Array(e),Cp[e]=i);for(var r=0;r!==e;++r)i[r]=t.allocTextureUnit();return i}function A(t,e){t.uniform1f(this.addr,e)}function M(t,e){t.uniform1i(this.addr,e)}function P(t,e){void 0===e.x?t.uniform2fv(this.addr,e):t.uniform2f(this.addr,e.x,e.y)}function E(t,e){void 0!==e.x?t.uniform3f(this.addr,e.x,e.y,e.z):void 0!==e.r?t.uniform3f(this.addr,e.r,e.g,e.b):t.uniform3fv(this.addr,e)}function T(t,e){void 0===e.x?t.uniform4fv(this.addr,e):t.uniform4f(this.addr,e.x,e.y,e.z,e.w)}function C(t,e){t.uniformMatrix2fv(this.addr,!1,e.elements||e)}function I(t,e){void 0===e.elements?t.uniformMatrix3fv(this.addr,!1,e):(Rp.set(e.elements),t.uniformMatrix3fv(this.addr,!1,Rp))}function R(t,e){void 0===e.elements?t.uniformMatrix4fv(this.addr,!1,e):(Ip.set(e.elements),t.uniformMatrix4fv(this.addr,!1,Ip))}function L(t,e,i){var r=i.allocTextureUnit();t.uniform1i(this.addr,r),i.setTexture2D(e||Pp,r)}function O(t,e,i){var r=i.allocTextureUnit();t.uniform1i(this.addr,r),i.setTextureCube(e||Ep,r)}function D(t,e){t.uniform2iv(this.addr,e)}function N(t,e){t.uniform3iv(this.addr,e)}function k(t,e){t.uniform4iv(this.addr,e)}function B(t){switch(t){case 5126:return A;case 35664:return P;case 35665:return E;case 35666:return T;case 35674:return C;case 35675:return I;case 35676:return R;case 35678:case 36198:return L;case 35680:return O;case 5124:case 35670:return M;case 35667:case 35671:return D;case 35668:case 35672:return N;case 35669:case 35673:return k}}function F(t,e){t.uniform1fv(this.addr,e)}function z(t,e){t.uniform1iv(this.addr,e)}function U(t,e){t.uniform2fv(this.addr,w(e,this.size,2))}function j(t,e){t.uniform3fv(this.addr,w(e,this.size,3))}function V(t,e){t.uniform4fv(this.addr,w(e,this.size,4))}function G(t,e){t.uniformMatrix2fv(this.addr,!1,w(e,this.size,4))}function $(t,e){t.uniformMatrix3fv(this.addr,!1,w(e,this.size,9))}function H(t,e){t.uniformMatrix4fv(this.addr,!1,w(e,this.size,16))}function W(t,e,i){var r=e.length,n=S(i,r);t.uniform1iv(this.addr,n);for(var o=0;o!==r;++o)i.setTexture2D(e[o]||Pp,n[o])}function X(t,e,i){var r=e.length,n=S(i,r);t.uniform1iv(this.addr,n);for(var o=0;o!==r;++o)i.setTextureCube(e[o]||Ep,n[o])}function q(t){switch(t){case 5126:return F;case 35664:return U;case 35665:return j;case 35666:return V;case 35674:return G;case 35675:return $;case 35676:return H;case 35678:return W;case 35680:return X;case 5124:case 35670:return z;case 35667:case 35671:return D;case 35668:case 35672:return N;case 35669:case 35673:return k}}function Y(t,e,i){this.id=t,this.addr=i,this.setValue=B(e.type)}function Z(t,e,i){this.id=t,this.addr=i,this.size=e.size,this.setValue=q(e.type)}function K(t){this.id=t,_.call(this)}function Q(t,e){t.seq.push(e),t.map[e.id]=e}function J(t,e,i){var r=t.name,n=r.length;for(Lp.lastIndex=0;;){var o=Lp.exec(r),a=Lp.lastIndex,s=o[1],c="]"===o[2],u=o[3];if(c&&(s|=0),void 0===u||"["===u&&a+2===n){Q(i,void 0===u?new Y(s,t,e):new Z(s,t,e));break}var l=i.map[s];void 0===l&&Q(i,l=new K(s)),i=l}}function tt(t,e,i){var r=this;_.call(this),this.renderer=i;for(var n=t.getProgramParameter(e,t.ACTIVE_UNIFORMS),o=0;o<n;++o){var a=t.getActiveUniform(e,o),s=a.name;J(a,t.getUniformLocation(e,s),r)}}function et(t,e,i){return void 0===e&&void 0===i?this.set(t):this.setRGB(t,e,i)}function it(t,e){this.min=void 0!==t?t:new h(1/0,1/0),this.max=void 0!==e?e:new h(-1/0,-1/0)}function rt(t,e,i,r,n){function o(){var t=new Float32Array([-1,-1,0,0,1,-1,1,0,1,1,1,1,-1,1,0,1]),r=new Uint16Array([0,1,2,0,2,3]);s=e.createBuffer(),c=e.createBuffer(),e.bindBuffer(e.ARRAY_BUFFER,s),e.bufferData(e.ARRAY_BUFFER,t,e.STATIC_DRAW),e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,c),e.bufferData(e.ELEMENT_ARRAY_BUFFER,r,e.STATIC_DRAW),f=e.createTexture(),m=e.createTexture(),i.bindTexture(e.TEXTURE_2D,f),e.texImage2D(e.TEXTURE_2D,0,e.RGB,16,16,0,e.RGB,e.UNSIGNED_BYTE,null),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_S,e.CLAMP_TO_EDGE),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_T,e.CLAMP_TO_EDGE),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MAG_FILTER,e.NEAREST),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MIN_FILTER,e.NEAREST),i.bindTexture(e.TEXTURE_2D,m),e.texImage2D(e.TEXTURE_2D,0,e.RGBA,16,16,0,e.RGBA,e.UNSIGNED_BYTE,null),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_S,e.CLAMP_TO_EDGE),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_T,e.CLAMP_TO_EDGE),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MAG_FILTER,e.NEAREST),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MIN_FILTER,e.NEAREST),u={vertexShader:["uniform lowp int renderType;","uniform vec3 screenPosition;","uniform vec2 scale;","uniform float rotation;","uniform sampler2D occlusionMap;","attribute vec2 position;","attribute vec2 uv;","varying vec2 vUV;","varying float vVisibility;","void main() {","vUV = uv;","vec2 pos = position;","if ( renderType == 2 ) {","vec4 visibility = texture2D( occlusionMap, vec2( 0.1, 0.1 ) );","visibility += texture2D( occlusionMap, vec2( 0.5, 0.1 ) );","visibility += texture2D( occlusionMap, vec2( 0.9, 0.1 ) );","visibility += texture2D( occlusionMap, vec2( 0.9, 0.5 ) );","visibility += texture2D( occlusionMap, vec2( 0.9, 0.9 ) );","visibility += texture2D( occlusionMap, vec2( 0.5, 0.9 ) );","visibility += texture2D( occlusionMap, vec2( 0.1, 0.9 ) );","visibility += texture2D( occlusionMap, vec2( 0.1, 0.5 ) );","visibility += texture2D( occlusionMap, vec2( 0.5, 0.5 ) );","vVisibility =        visibility.r / 9.0;","vVisibility *= 1.0 - visibility.g / 9.0;","vVisibility *=       visibility.b / 9.0;","vVisibility *= 1.0 - visibility.a / 9.0;","pos.x = cos( rotation ) * position.x - sin( rotation ) * position.y;","pos.y = sin( rotation ) * position.x + cos( rotation ) * position.y;","}","gl_Position = vec4( ( pos * scale + screenPosition.xy ).xy, screenPosition.z, 1.0 );","}"].join("\n"),fragmentShader:["uniform lowp int renderType;","uniform sampler2D map;","uniform float opacity;","uniform vec3 color;","varying vec2 vUV;","varying float vVisibility;","void main() {","if ( renderType == 0 ) {","gl_FragColor = vec4( 1.0, 0.0, 1.0, 0.0 );","} else if ( renderType == 1 ) {","gl_FragColor = texture2D( map, vUV );","} else {","vec4 texture = texture2D( map, vUV );","texture.a *= opacity * vVisibility;","gl_FragColor = texture;","gl_FragColor.rgb *= color;","}","}"].join("\n")},l=a(u),p={vertex:e.getAttribLocation(l,"position"),uv:e.getAttribLocation(l,"uv")},d={renderType:e.getUniformLocation(l,"renderType"),map:e.getUniformLocation(l,"map"),occlusionMap:e.getUniformLocation(l,"occlusionMap"),opacity:e.getUniformLocation(l,"opacity"),color:e.getUniformLocation(l,"color"),scale:e.getUniformLocation(l,"scale"),rotation:e.getUniformLocation(l,"rotation"),screenPosition:e.getUniformLocation(l,"screenPosition")}}function a(t){var i=e.createProgram(),r=e.createShader(e.FRAGMENT_SHADER),o=e.createShader(e.VERTEX_SHADER),a="precision "+n.precision+" float;\n";return e.shaderSource(r,a+t.fragmentShader),e.shaderSource(o,a+t.vertexShader),e.compileShader(r),e.compileShader(o),e.attachShader(i,r),e.attachShader(i,o),e.linkProgram(i),i}var s,c,u,l,p,d,f,m;this.render=function(t,n,a,u){if(0!==t.length){var g=new v,y=u.w/u.z,b=.5*u.z,x=.5*u.w,_=16/u.w,w=new h(_*y,_),S=new v(1,1,0),A=new h(1,1),M=new it;M.min.set(u.x,u.y),M.max.set(u.x+(u.z-16),u.y+(u.w-16)),void 0===l&&o(),i.useProgram(l),i.initAttributes(),i.enableAttribute(p.vertex),i.enableAttribute(p.uv),i.disableUnusedAttributes(),e.uniform1i(d.occlusionMap,0),e.uniform1i(d.map,1),e.bindBuffer(e.ARRAY_BUFFER,s),e.vertexAttribPointer(p.vertex,2,e.FLOAT,!1,16,0),e.vertexAttribPointer(p.uv,2,e.FLOAT,!1,16,8),e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,c),i.disable(e.CULL_FACE),i.buffers.depth.setMask(!1);for(var P=0,E=t.length;P<E;P++){_=16/u.w,w.set(_*y,_);var T=t[P];if(g.set(T.matrixWorld.elements[12],T.matrixWorld.elements[13],T.matrixWorld.elements[14]),g.applyMatrix4(a.matrixWorldInverse),g.applyMatrix4(a.projectionMatrix),S.copy(g),A.x=u.x+S.x*b+b-8,A.y=u.y+S.y*x+x-8,!0===M.containsPoint(A)){i.activeTexture(e.TEXTURE0),i.bindTexture(e.TEXTURE_2D,null),i.activeTexture(e.TEXTURE1),i.bindTexture(e.TEXTURE_2D,f),e.copyTexImage2D(e.TEXTURE_2D,0,e.RGB,A.x,A.y,16,16,0),e.uniform1i(d.renderType,0),e.uniform2f(d.scale,w.x,w.y),e.uniform3f(d.screenPosition,S.x,S.y,S.z),i.disable(e.BLEND),i.enable(e.DEPTH_TEST),e.drawElements(e.TRIANGLES,6,e.UNSIGNED_SHORT,0),i.activeTexture(e.TEXTURE0),i.bindTexture(e.TEXTURE_2D,m),e.copyTexImage2D(e.TEXTURE_2D,0,e.RGBA,A.x,A.y,16,16,0),e.uniform1i(d.renderType,1),i.disable(e.DEPTH_TEST),i.activeTexture(e.TEXTURE1),i.bindTexture(e.TEXTURE_2D,f),e.drawElements(e.TRIANGLES,6,e.UNSIGNED_SHORT,0),T.positionScreen.copy(S),T.customUpdateCallback?T.customUpdateCallback(T):T.updateLensFlares(),e.uniform1i(d.renderType,2),i.enable(e.BLEND);for(var C=0,I=T.lensFlares.length;C<I;C++){var R=T.lensFlares[C];R.opacity>.001&&R.scale>.001&&(S.x=R.x,S.y=R.y,S.z=R.z,_=R.size*R.scale/u.w,w.x=_*y,w.y=_,e.uniform3f(d.screenPosition,S.x,S.y,S.z),e.uniform2f(d.scale,w.x,w.y),e.uniform1f(d.rotation,R.rotation),e.uniform1f(d.opacity,R.opacity),e.uniform3f(d.color,R.color.r,R.color.g,R.color.b),i.setBlending(R.blending,R.blendEquation,R.blendSrc,R.blendDst),r.setTexture2D(R.texture,1),e.drawElements(e.TRIANGLES,6,e.UNSIGNED_SHORT,0))}}}i.enable(e.CULL_FACE),i.enable(e.DEPTH_TEST),i.buffers.depth.setMask(!0),i.reset()}}}function nt(t,e,i,r,n,o,a,s,c){p.call(this,t,e,i,r,n,o,a,s,c),this.needsUpdate=!0}function ot(t,e,i,r,n){function o(){var t=new Float32Array([-.5,-.5,0,0,.5,-.5,1,0,.5,.5,1,1,-.5,.5,0,1]),i=new Uint16Array([0,1,2,0,2,3]);c=e.createBuffer(),u=e.createBuffer(),e.bindBuffer(e.ARRAY_BUFFER,c),e.bufferData(e.ARRAY_BUFFER,t,e.STATIC_DRAW),e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,u),e.bufferData(e.ELEMENT_ARRAY_BUFFER,i,e.STATIC_DRAW),l=a(),h={position:e.getAttribLocation(l,"position"),uv:e.getAttribLocation(l,"uv")},p={uvOffset:e.getUniformLocation(l,"uvOffset"),uvScale:e.getUniformLocation(l,"uvScale"),rotation:e.getUniformLocation(l,"rotation"),scale:e.getUniformLocation(l,"scale"),color:e.getUniformLocation(l,"color"),map:e.getUniformLocation(l,"map"),opacity:e.getUniformLocation(l,"opacity"),modelViewMatrix:e.getUniformLocation(l,"modelViewMatrix"),projectionMatrix:e.getUniformLocation(l,"projectionMatrix"),fogType:e.getUniformLocation(l,"fogType"),fogDensity:e.getUniformLocation(l,"fogDensity"),fogNear:e.getUniformLocation(l,"fogNear"),fogFar:e.getUniformLocation(l,"fogFar"),fogColor:e.getUniformLocation(l,"fogColor"),alphaTest:e.getUniformLocation(l,"alphaTest")};var r=document.createElementNS("http://www.w3.org/1999/xhtml","canvas");r.width=8,r.height=8;var n=r.getContext("2d");n.fillStyle="white",n.fillRect(0,0,8,8),d=new nt(r)}function a(){var t=e.createProgram(),i=e.createShader(e.VERTEX_SHADER),r=e.createShader(e.FRAGMENT_SHADER);return e.shaderSource(i,["precision "+n.precision+" float;","#define SHADER_NAME SpriteMaterial","uniform mat4 modelViewMatrix;","uniform mat4 projectionMatrix;","uniform float rotation;","uniform vec2 scale;","uniform vec2 uvOffset;","uniform vec2 uvScale;","attribute vec2 position;","attribute vec2 uv;","varying vec2 vUV;","void main() {","vUV = uvOffset + uv * uvScale;","vec2 alignedPosition = position * scale;","vec2 rotatedPosition;","rotatedPosition.x = cos( rotation ) * alignedPosition.x - sin( rotation ) * alignedPosition.y;","rotatedPosition.y = sin( rotation ) * alignedPosition.x + cos( rotation ) * alignedPosition.y;","vec4 finalPosition;","finalPosition = modelViewMatrix * vec4( 0.0, 0.0, 0.0, 1.0 );","finalPosition.xy += rotatedPosition;","finalPosition = projectionMatrix * finalPosition;","gl_Position = finalPosition;","}"].join("\n")),e.shaderSource(r,["precision "+n.precision+" float;","#define SHADER_NAME SpriteMaterial","uniform vec3 color;","uniform sampler2D map;","uniform float opacity;","uniform int fogType;","uniform vec3 fogColor;","uniform float fogDensity;","uniform float fogNear;","uniform float fogFar;","uniform float alphaTest;","varying vec2 vUV;","void main() {","vec4 texture = texture2D( map, vUV );","if ( texture.a < alphaTest ) discard;","gl_FragColor = vec4( color * texture.xyz, texture.a * opacity );","if ( fogType > 0 ) {","float depth = gl_FragCoord.z / gl_FragCoord.w;","float fogFactor = 0.0;","if ( fogType == 1 ) {","fogFactor = smoothstep( fogNear, fogFar, depth );","} else {","const float LOG2 = 1.442695;","fogFactor = exp2( - fogDensity * fogDensity * depth * depth * LOG2 );","fogFactor = 1.0 - clamp( fogFactor, 0.0, 1.0 );","}","gl_FragColor = mix( gl_FragColor, vec4( fogColor, gl_FragColor.w ), fogFactor );","}","}"].join("\n")),e.compileShader(i),e.compileShader(r),e.attachShader(t,i),e.attachShader(t,r),e.linkProgram(t),t}function s(t,e){return t.renderOrder!==e.renderOrder?t.renderOrder-e.renderOrder:t.z!==e.z?e.z-t.z:e.id-t.id}var c,u,l,h,p,d,f=new v,m=new g,y=new v;this.render=function(n,a,g){if(0!==n.length){void 0===l&&o(),i.useProgram(l),i.initAttributes(),i.enableAttribute(h.position),i.enableAttribute(h.uv),i.disableUnusedAttributes(),i.disable(e.CULL_FACE),i.enable(e.BLEND),e.bindBuffer(e.ARRAY_BUFFER,c),e.vertexAttribPointer(h.position,2,e.FLOAT,!1,16,0),e.vertexAttribPointer(h.uv,2,e.FLOAT,!1,16,8),e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,u),e.uniformMatrix4fv(p.projectionMatrix,!1,g.projectionMatrix.elements),i.activeTexture(e.TEXTURE0),e.uniform1i(p.map,0);var v=0,b=0,x=a.fog;x?(e.uniform3f(p.fogColor,x.color.r,x.color.g,x.color.b),x.isFog?(e.uniform1f(p.fogNear,x.near),e.uniform1f(p.fogFar,x.far),e.uniform1i(p.fogType,1),v=1,b=1):x.isFogExp2&&(e.uniform1f(p.fogDensity,x.density),e.uniform1i(p.fogType,2),v=2,b=2)):(e.uniform1i(p.fogType,0),v=0,b=0);for(var _=0,w=n.length;_<w;_++)(A=n[_]).modelViewMatrix.multiplyMatrices(g.matrixWorldInverse,A.matrixWorld),A.z=-A.modelViewMatrix.elements[14];n.sort(s);for(var S=[],_=0,w=n.length;_<w;_++){var A=n[_],M=A.material;if(!1!==M.visible){A.onBeforeRender(t,a,g,void 0,M,void 0),e.uniform1f(p.alphaTest,M.alphaTest),e.uniformMatrix4fv(p.modelViewMatrix,!1,A.modelViewMatrix.elements),A.matrixWorld.decompose(f,m,y),S[0]=y.x,S[1]=y.y;var P=0;a.fog&&M.fog&&(P=b),v!==P&&(e.uniform1i(p.fogType,P),v=P),null!==M.map?(e.uniform2f(p.uvOffset,M.map.offset.x,M.map.offset.y),e.uniform2f(p.uvScale,M.map.repeat.x,M.map.repeat.y)):(e.uniform2f(p.uvOffset,0,0),e.uniform2f(p.uvScale,1,1)),e.uniform1f(p.opacity,M.opacity),e.uniform3f(p.color,M.color.r,M.color.g,M.color.b),e.uniform1f(p.rotation,M.rotation),e.uniform2fv(p.scale,S),i.setBlending(M.blending,M.blendEquation,M.blendSrc,M.blendDst,M.blendEquationAlpha,M.blendSrcAlpha,M.blendDstAlpha,M.premultipliedAlpha),i.buffers.depth.setTest(M.depthTest),i.buffers.depth.setMask(M.depthWrite),r.setTexture2D(M.map||d,0),e.drawElements(e.TRIANGLES,6,e.UNSIGNED_SHORT,0),A.onAfterRender(t,a,g,void 0,M,void 0)}}i.enable(e.CULL_FACE),i.reset()}}}function at(){Object.defineProperty(this,"id",{value:Fp++}),this.uuid=Ap.generateUUID(),this.name="",this.type="Material",this.fog=!0,this.lights=!0,this.blending=Bl,this.side=Il,this.flatShading=!1,this.vertexColors=Ol,this.opacity=1,this.transparent=!1,this.blendSrc=Kl,this.blendDst=Ql,this.blendEquation=Vl,this.blendSrcAlpha=null,this.blendDstAlpha=null,this.blendEquationAlpha=null,this.depthFunc=sh,this.depthTest=!0,this.depthWrite=!0,this.clippingPlanes=null,this.clipIntersection=!1,this.clipShadows=!1,this.colorWrite=!0,this.precision=null,this.polygonOffset=!1,this.polygonOffsetFactor=0,this.polygonOffsetUnits=0,this.dithering=!1,this.alphaTest=0,this.premultipliedAlpha=!1,this.overdraw=0,this.visible=!0,this.userData={},this.needsUpdate=!0}function st(t){at.call(this),this.type="ShaderMaterial",this.defines={},this.uniforms={},this.vertexShader="void main() {\n\tgl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",this.fragmentShader="void main() {\n\tgl_FragColor = vec4( 1.0, 0.0, 0.0, 1.0 );\n}",this.linewidth=1,this.wireframe=!1,this.wireframeLinewidth=1,this.fog=!1,this.lights=!1,this.clipping=!1,this.skinning=!1,this.morphTargets=!1,this.morphNormals=!1,this.extensions={derivatives:!1,fragDepth:!1,drawBuffers:!1,shaderTextureLOD:!1},this.defaultAttributeValues={color:[1,1,1],uv:[0,0],uv2:[0,0]},this.index0AttributeName=void 0,void 0!==t&&(void 0!==t.attributes&&console.error("THREE.ShaderMaterial: attributes should now be defined in THREE.BufferGeometry instead."),this.setValues(t))}function ct(t){at.call(this),this.type="MeshDepthMaterial",this.depthPacking=wp,this.skinning=!1,this.morphTargets=!1,this.map=null,this.alphaMap=null,this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.wireframe=!1,this.wireframeLinewidth=1,this.fog=!1,this.lights=!1,this.setValues(t)}function ut(t){at.call(this),this.type="MeshDistanceMaterial",this.referencePosition=new v,this.nearDistance=1,this.farDistance=1e3,this.skinning=!1,this.morphTargets=!1,this.map=null,this.alphaMap=null,this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.fog=!1,this.lights=!1,this.setValues(t)}function lt(t,e){this.min=void 0!==t?t:new v(1/0,1/0,1/0),this.max=void 0!==e?e:new v(-1/0,-1/0,-1/0)}function ht(t,e){this.center=void 0!==t?t:new v,this.radius=void 0!==e?e:0}function pt(){this.elements=[1,0,0,0,1,0,0,0,1],arguments.length>0&&console.error("THREE.Matrix3: the constructor no longer reads arguments. use .set() instead.")}function dt(t,e){this.normal=void 0!==t?t:new v(1,0,0),this.constant=void 0!==e?e:0}function ft(t,e,i,r,n,o){this.planes=[void 0!==t?t:new dt,void 0!==e?e:new dt,void 0!==i?i:new dt,void 0!==r?r:new dt,void 0!==n?n:new dt,void 0!==o?o:new dt]}function mt(t,e,i){function r(e,i,r,n,o,a){var s=e.geometry,c=null,u=b,l=e.customDepthMaterial;if(r&&(u=x,l=e.customDistanceMaterial),l)c=l;else{var h=!1;i.morphTargets&&(s&&s.isBufferGeometry?h=s.morphAttributes&&s.morphAttributes.position&&s.morphAttributes.position.length>0:s&&s.isGeometry&&(h=s.morphTargets&&s.morphTargets.length>0)),e.isSkinnedMesh&&!1===i.skinning&&console.warn("THREE.WebGLShadowMap: THREE.SkinnedMesh with material.skinning set to false:",e);var d=e.isSkinnedMesh&&i.skinning,f=0;h&&(f|=p),d&&(f|=m),c=u[f]}if(t.localClippingEnabled&&!0===i.clipShadows&&0!==i.clippingPlanes.length){var g=c.uuid,v=i.uuid,y=_[g];void 0===y&&(y={},_[g]=y);var w=y[v];void 0===w&&(w=c.clone(),y[v]=w),c=w}c.visible=i.visible,c.wireframe=i.wireframe;var S=i.side;return I.renderSingleSided&&S==Ll&&(S=Il),I.renderReverseSided&&(S===Il?S=Rl:S===Rl&&(S=Il)),c.side=S,c.clipShadows=i.clipShadows,c.clippingPlanes=i.clippingPlanes,c.clipIntersection=i.clipIntersection,c.wireframeLinewidth=i.wireframeLinewidth,c.linewidth=i.linewidth,r&&c.isMeshDistanceMaterial&&(c.referencePosition.copy(n),c.nearDistance=o,c.farDistance=a),c}function n(i,a,s,c){if(!1!==i.visible){if(i.layers.test(a.layers)&&(i.isMesh||i.isLine||i.isPoints)&&i.castShadow&&(!i.frustumCulled||o.intersectsObject(i))){i.modelViewMatrix.multiplyMatrices(s.matrixWorldInverse,i.matrixWorld);var u=e.update(i),h=i.material;if(Array.isArray(h))for(var p=u.groups,d=0,f=p.length;d<f;d++){var m=p[d],g=h[m.materialIndex];if(g&&g.visible){v=r(i,g,c,l,s.near,s.far);t.renderBufferDirect(s,null,u,v,i,m)}}else if(h.visible){var v=r(i,h,c,l,s.near,s.far);t.renderBufferDirect(s,null,u,v,i,null)}}for(var y=i.children,b=0,x=y.length;b<x;b++)n(y[b],a,s,c)}}for(var o=new ft,a=new y,s=new h,c=new h(i,i),u=new v,l=new v,p=1,m=2,g=1+(p|m),b=new Array(g),x=new Array(g),_={},w=[new v(1,0,0),new v(-1,0,0),new v(0,0,1),new v(0,0,-1),new v(0,1,0),new v(0,-1,0)],S=[new v(0,1,0),new v(0,1,0),new v(0,1,0),new v(0,1,0),new v(0,0,1),new v(0,0,-1)],A=[new d,new d,new d,new d,new d,new d],M=0;M!==g;++M){var P=0!=(M&p),E=0!=(M&m),T=new ct({depthPacking:Sp,morphTargets:P,skinning:E});b[M]=T;var C=new ut({morphTargets:P,skinning:E});x[M]=C}var I=this;this.enabled=!1,this.autoUpdate=!0,this.needsUpdate=!1,this.type=Tl,this.renderReverseSided=!0,this.renderSingleSided=!0,this.render=function(e,i,r){if(!1!==I.enabled&&(!1!==I.autoUpdate||!1!==I.needsUpdate)&&0!==e.length){var h=t.context,p=t.state;p.disable(h.BLEND),p.buffers.color.setClear(1,1,1,1),p.buffers.depth.setTest(!0),p.setScissorTest(!1);for(var d,m=0,g=e.length;m<g;m++){var v=e[m],y=v.shadow,b=v&&v.isPointLight;if(void 0!==y){var x=y.camera;if(s.copy(y.mapSize),s.min(c),b){var _=s.x,M=s.y;A[0].set(2*_,M,_,M),A[1].set(0,M,_,M),A[2].set(3*_,M,_,M),A[3].set(_,M,_,M),A[4].set(3*_,0,_,M),A[5].set(_,0,_,M),s.x*=4,s.y*=2}if(null===y.map){var P={minFilter:Ih,magFilter:Ih,format:Zh};y.map=new f(s.x,s.y,P),y.map.texture.name=v.name+".shadowMap",x.updateProjectionMatrix()}y.isSpotLightShadow&&y.update(v);var E=y.map,T=y.matrix;l.setFromMatrixPosition(v.matrixWorld),x.position.copy(l),b?(d=6,T.makeTranslation(-l.x,-l.y,-l.z)):(d=1,u.setFromMatrixPosition(v.target.matrixWorld),x.lookAt(u),x.updateMatrixWorld(),T.set(.5,0,0,.5,0,.5,0,.5,0,0,.5,.5,0,0,0,1),T.multiply(x.projectionMatrix),T.multiply(x.matrixWorldInverse)),t.setRenderTarget(E),t.clear();for(var C=0;C<d;C++){if(b){u.copy(x.position),u.add(w[C]),x.up.copy(S[C]),x.lookAt(u),x.updateMatrixWorld();var R=A[C];p.viewport(R)}a.multiplyMatrices(x.projectionMatrix,x.matrixWorldInverse),o.setFromMatrix(a),n(i,r,x,b)}}else console.warn("THREE.WebGLShadowMap:",v,"has no shadow.")}I.needsUpdate=!1}}}function gt(t){function e(e,i){var r=e.array,n=e.dynamic?t.DYNAMIC_DRAW:t.STATIC_DRAW,o=t.createBuffer();t.bindBuffer(i,o),t.bufferData(i,r,n),e.onUploadCallback();var a=t.FLOAT;return r instanceof Float32Array?a=t.FLOAT:r instanceof Float64Array?console.warn("THREE.WebGLAttributes: Unsupported data buffer format: Float64Array."):r instanceof Uint16Array?a=t.UNSIGNED_SHORT:r instanceof Int16Array?a=t.SHORT:r instanceof Uint32Array?a=t.UNSIGNED_INT:r instanceof Int32Array?a=t.INT:r instanceof Int8Array?a=t.BYTE:r instanceof Uint8Array&&(a=t.UNSIGNED_BYTE),{buffer:o,type:a,bytesPerElement:r.BYTES_PER_ELEMENT,version:e.version}}function i(e,i,r){var n=i.array,o=i.updateRange;t.bindBuffer(r,e),!1===i.dynamic?t.bufferData(r,n,t.STATIC_DRAW):-1===o.count?t.bufferSubData(r,0,n):0===o.count?console.error("THREE.WebGLObjects.updateBuffer: dynamic THREE.BufferAttribute marked as needsUpdate but updateRange.count is 0, ensure you are using set methods or updating manually."):(t.bufferSubData(r,o.offset*n.BYTES_PER_ELEMENT,n.subarray(o.offset,o.offset+o.count)),o.count=-1)}var r={};return{get:function(t){return t.isInterleavedBufferAttribute&&(t=t.data),r[t.uuid]},remove:function(e){e.isInterleavedBufferAttribute&&(e=e.data);var i=r[e.uuid];i&&(t.deleteBuffer(i.buffer),delete r[e.uuid])},update:function(t,n){t.isInterleavedBufferAttribute&&(t=t.data);var o=r[t.uuid];void 0===o?r[t.uuid]=e(t,n):o.version<t.version&&(i(o.buffer,t,n),o.version=t.version)}}}function vt(t,e,i,r){this._x=t||0,this._y=e||0,this._z=i||0,this._order=r||vt.DefaultOrder}function yt(){this.mask=1}function bt(){Object.defineProperty(this,"id",{value:zp++}),this.uuid=Ap.generateUUID(),this.name="",this.type="Object3D",this.parent=null,this.children=[],this.up=bt.DefaultUp.clone();var t=new v,e=new vt,i=new g,r=new v(1,1,1);e.onChange(function(){i.setFromEuler(e,!1)}),i.onChange(function(){e.setFromQuaternion(i,void 0,!1)}),Object.defineProperties(this,{position:{enumerable:!0,value:t},rotation:{enumerable:!0,value:e},quaternion:{enumerable:!0,value:i},scale:{enumerable:!0,value:r},modelViewMatrix:{value:new y},normalMatrix:{value:new pt}}),this.matrix=new y,this.matrixWorld=new y,this.matrixAutoUpdate=bt.DefaultMatrixAutoUpdate,this.matrixWorldNeedsUpdate=!1,this.layers=new yt,this.visible=!0,this.castShadow=!1,this.receiveShadow=!1,this.frustumCulled=!0,this.renderOrder=0,this.userData={}}function xt(){bt.call(this),this.type="Camera",this.matrixWorldInverse=new y,this.projectionMatrix=new y}function _t(t,e,i,r,n,o){xt.call(this),this.type="OrthographicCamera",this.zoom=1,this.view=null,this.left=t,this.right=e,this.top=i,this.bottom=r,this.near=void 0!==n?n:.1,this.far=void 0!==o?o:2e3,this.updateProjectionMatrix()}function wt(t,e,i,r){xt.call(this),this.type="PerspectiveCamera",this.fov=void 0!==t?t:50,this.zoom=1,this.near=void 0!==i?i:.1,this.far=void 0!==r?r:2e3,this.focus=10,this.aspect=void 0!==e?e:1,this.view=null,this.filmGauge=35,this.filmOffset=0,this.updateProjectionMatrix()}function St(t,e,i,r,n,o){this.a=t,this.b=e,this.c=i,this.normal=r&&r.isVector3?r:new v,this.vertexNormals=Array.isArray(r)?r:[],this.color=n&&n.isColor?n:new et,this.vertexColors=Array.isArray(n)?n:[],this.materialIndex=void 0!==o?o:0}function At(){return Up++}function Mt(){Object.defineProperty(this,"id",{value:At()}),this.uuid=Ap.generateUUID(),this.name="",this.type="Geometry",this.vertices=[],this.colors=[],this.faces=[],this.faceVertexUvs=[[]],this.morphTargets=[],this.morphNormals=[],this.skinWeights=[],this.skinIndices=[],this.lineDistances=[],this.boundingBox=null,this.boundingSphere=null,this.elementsNeedUpdate=!1,this.verticesNeedUpdate=!1,this.uvsNeedUpdate=!1,this.normalsNeedUpdate=!1,this.colorsNeedUpdate=!1,this.lineDistancesNeedUpdate=!1,this.groupsNeedUpdate=!1}function Pt(t,e,i){if(Array.isArray(t))throw new TypeError("THREE.BufferAttribute: array should be a Typed Array.");this.uuid=Ap.generateUUID(),this.name="",this.array=t,this.itemSize=e,this.count=void 0!==t?t.length/e:0,this.normalized=!0===i,this.dynamic=!1,this.updateRange={offset:0,count:-1},this.onUploadCallback=function(){},this.version=0}function Et(t,e){Pt.call(this,new Int8Array(t),e)}function Tt(t,e){Pt.call(this,new Uint8Array(t),e)}function Ct(t,e){Pt.call(this,new Uint8ClampedArray(t),e)}function It(t,e){Pt.call(this,new Int16Array(t),e)}function Rt(t,e){Pt.call(this,new Uint16Array(t),e)}function Lt(t,e){Pt.call(this,new Int32Array(t),e)}function Ot(t,e){Pt.call(this,new Uint32Array(t),e)}function Dt(t,e){Pt.call(this,new Float32Array(t),e)}function Nt(t,e){Pt.call(this,new Float64Array(t),e)}function kt(){this.indices=[],this.vertices=[],this.normals=[],this.colors=[],this.uvs=[],this.uvs2=[],this.groups=[],this.morphTargets={},this.skinWeights=[],this.skinIndices=[],this.boundingBox=null,this.boundingSphere=null,this.verticesNeedUpdate=!1,this.normalsNeedUpdate=!1,this.colorsNeedUpdate=!1,this.uvsNeedUpdate=!1,this.groupsNeedUpdate=!1}function Bt(t){if(0===t.length)return-1/0;for(var e=t[0],i=1,r=t.length;i<r;++i)t[i]>e&&(e=t[i]);return e}function Ft(){Object.defineProperty(this,"id",{value:At()}),this.uuid=Ap.generateUUID(),this.name="",this.type="BufferGeometry",this.index=null,this.attributes={},this.morphAttributes={},this.groups=[],this.boundingBox=null,this.boundingSphere=null,this.drawRange={start:0,count:1/0}}function zt(t,e,i,r,n,o){Mt.call(this),this.type="BoxGeometry",this.parameters={width:t,height:e,depth:i,widthSegments:r,heightSegments:n,depthSegments:o},this.fromBufferGeometry(new Ut(t,e,i,r,n,o)),this.mergeVertices()}function Ut(t,e,i,r,n,o){function a(t,e,i,r,n,o,a,f,m,g,y){var b,x,_=o/m,w=a/g,S=o/2,A=a/2,M=f/2,P=m+1,E=g+1,T=0,C=0,I=new v;for(x=0;x<E;x++){var R=x*w-A;for(b=0;b<P;b++){var L=b*_-S;I[t]=L*r,I[e]=R*n,I[i]=M,u.push(I.x,I.y,I.z),I[t]=0,I[e]=0,I[i]=f>0?1:-1,l.push(I.x,I.y,I.z),h.push(b/m),h.push(1-x/g),T+=1}}for(x=0;x<g;x++)for(b=0;b<m;b++){var O=p+b+P*x,D=p+b+P*(x+1),N=p+(b+1)+P*(x+1),k=p+(b+1)+P*x;c.push(O,D,k),c.push(D,N,k),C+=6}s.addGroup(d,C,y),d+=C,p+=T}Ft.call(this),this.type="BoxBufferGeometry",this.parameters={width:t,height:e,depth:i,widthSegments:r,heightSegments:n,depthSegments:o};var s=this;r=Math.floor(r)||1,n=Math.floor(n)||1;var c=[],u=[],l=[],h=[],p=0,d=0;a("z","y","x",-1,-1,i,e,t,o=Math.floor(o)||1,n,0),a("z","y","x",1,-1,i,e,-t,o,n,1),a("x","z","y",1,1,t,i,e,r,o,2),a("x","z","y",1,-1,t,i,-e,r,o,3),a("x","y","z",1,-1,t,e,i,r,n,4),a("x","y","z",-1,-1,t,e,-i,r,n,5),this.setIndex(c),this.addAttribute("position",new Dt(u,3)),this.addAttribute("normal",new Dt(l,3)),this.addAttribute("uv",new Dt(h,2))}function jt(t,e,i,r){Mt.call(this),this.type="PlaneGeometry",this.parameters={width:t,height:e,widthSegments:i,heightSegments:r},this.fromBufferGeometry(new Vt(t,e,i,r)),this.mergeVertices()}function Vt(t,e,i,r){Ft.call(this),this.type="PlaneBufferGeometry",this.parameters={width:t,height:e,widthSegments:i,heightSegments:r};var n,o,a=t/2,s=e/2,c=Math.floor(i)||1,u=Math.floor(r)||1,l=c+1,h=u+1,p=t/c,d=e/u,f=[],m=[],g=[],v=[];for(o=0;o<h;o++){var y=o*d-s;for(n=0;n<l;n++){var b=n*p-a;m.push(b,-y,0),g.push(0,0,1),v.push(n/c),v.push(1-o/u)}}for(o=0;o<u;o++)for(n=0;n<c;n++){var x=n+l*o,_=n+l*(o+1),w=n+1+l*(o+1),S=n+1+l*o;f.push(x,_,S),f.push(_,w,S)}this.setIndex(f),this.addAttribute("position",new Dt(m,3)),this.addAttribute("normal",new Dt(g,3)),this.addAttribute("uv",new Dt(v,2))}function Gt(t){at.call(this),this.type="MeshBasicMaterial",this.color=new et(16777215),this.map=null,this.lightMap=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.specularMap=null,this.alphaMap=null,this.envMap=null,this.combine=ph,this.reflectivity=1,this.refractionRatio=.98,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinecap="round",this.wireframeLinejoin="round",this.skinning=!1,this.morphTargets=!1,this.lights=!1,this.setValues(t)}function $t(t,e){this.origin=void 0!==t?t:new v,this.direction=void 0!==e?e:new v}function Ht(t,e){this.start=void 0!==t?t:new v,this.end=void 0!==e?e:new v}function Wt(t,e,i){this.a=void 0!==t?t:new v,this.b=void 0!==e?e:new v,this.c=void 0!==i?i:new v}function Xt(t,e){bt.call(this),this.type="Mesh",this.geometry=void 0!==t?t:new Ft,this.material=void 0!==e?e:new Gt({color:16777215*Math.random()}),this.drawMode=pp,this.updateMorphTargets()}function qt(t,e,i,r){function n(t,i){e.buffers.color.setClear(t.r,t.g,t.b,i,r)}var o,a,s,c=new et(0),u=0;return{getClearColor:function(){return c},setClearColor:function(t,e){c.set(t),n(c,u=void 0!==e?e:1)},getClearAlpha:function(){return u},setClearAlpha:function(t){n(c,u=t)},render:function(e,r,l,h){var p=r.background;null===p?n(c,u):p&&p.isColor&&(n(p,1),h=!0),(t.autoClear||h)&&t.clear(t.autoClearColor,t.autoClearDepth,t.autoClearStencil),p&&p.isCubeTexture?(void 0===s&&((s=new Xt(new Ut(1,1,1),new st({uniforms:Bp.cube.uniforms,vertexShader:Bp.cube.vertexShader,fragmentShader:Bp.cube.fragmentShader,side:Rl,depthTest:!0,depthWrite:!1,polygonOffset:!0,fog:!1}))).geometry.removeAttribute("normal"),s.geometry.removeAttribute("uv"),s.onBeforeRender=function(t,e,i){var r=i.far;this.matrixWorld.makeScale(r,r,r),this.matrixWorld.copyPosition(i.matrixWorld),this.material.polygonOffsetUnits=10*r},i.update(s.geometry)),s.material.uniforms.tCube.value=p,e.push(s,s.geometry,s.material,0,null)):p&&p.isTexture&&(void 0===o&&(o=new _t(-1,1,1,-1,0,1),a=new Xt(new Vt(2,2),new Gt({depthTest:!1,depthWrite:!1,fog:!1})),i.update(a.geometry)),a.material.map=p,t.renderBufferDirect(o,null,a.geometry,a.material,a,null))}}}function Yt(t,e){return t.renderOrder!==e.renderOrder?t.renderOrder-e.renderOrder:t.program&&e.program&&t.program!==e.program?t.program.id-e.program.id:t.material.id!==e.material.id?t.material.id-e.material.id:t.z!==e.z?t.z-e.z:t.id-e.id}function Zt(t,e){return t.renderOrder!==e.renderOrder?t.renderOrder-e.renderOrder:t.z!==e.z?e.z-t.z:t.id-e.id}function Kt(){var t=[],e=0,i=[],r=[];return{opaque:i,transparent:r,init:function(){e=0,i.length=0,r.length=0},push:function(n,o,a,s,c){var u=t[e];void 0===u?(u={id:n.id,object:n,geometry:o,material:a,program:a.program,renderOrder:n.renderOrder,z:s,group:c},t[e]=u):(u.id=n.id,u.object=n,u.geometry=o,u.material=a,u.program=a.program,u.renderOrder=n.renderOrder,u.z=s,u.group=c),(!0===a.transparent?r:i).push(u),e++},sort:function(){i.length>1&&i.sort(Yt),r.length>1&&r.sort(Zt)}}}function Qt(){var t={};return{get:function(e,i){var r=e.id+","+i.id,n=t[r];return void 0===n&&(n=new Kt,t[r]=n),n},dispose:function(){t={}}}}function Jt(t,e){return Math.abs(e[1])-Math.abs(t[1])}function te(t){var e={},i=new Float32Array(8);return{update:function(r,n,o,a){var s=r.morphTargetInfluences,c=s.length,u=e[n.id];if(void 0===u){for(u=[],p=0;p<c;p++)u[p]=[p,0];e[n.id]=u}for(var l=o.morphTargets&&n.morphAttributes.position,h=o.morphNormals&&n.morphAttributes.normal,p=0;p<c;p++)0!==(d=u[p])[1]&&(l&&n.removeAttribute("morphTarget"+p),h&&n.removeAttribute("morphNormal"+p));for(p=0;p<c;p++)(d=u[p])[0]=p,d[1]=s[p];u.sort(Jt);for(p=0;p<8;p++){var d=u[p];if(d){var f=d[0],m=d[1];if(m){l&&n.addAttribute("morphTarget"+p,l[f]),h&&n.addAttribute("morphNormal"+p,h[f]),i[p]=m;continue}}i[p]=0}a.getUniforms().setValue(t,"morphTargetInfluences",i)}}}function ee(t,e,i){var r,n,o;this.setMode=function(t){r=t},this.setIndex=function(t){n=t.type,o=t.bytesPerElement},this.render=function(e,a){t.drawElements(r,a,n,e*o),i.calls++,i.vertices+=a,r===t.TRIANGLES?i.faces+=a/3:r===t.POINTS&&(i.points+=a)},this.renderInstances=function(a,s,c){var u=e.get("ANGLE_instanced_arrays");null!==u?(u.drawElementsInstancedANGLE(r,c,n,s*o,a.maxInstancedCount),i.calls++,i.vertices+=c*a.maxInstancedCount,r===t.TRIANGLES?i.faces+=a.maxInstancedCount*c/3:r===t.POINTS&&(i.points+=a.maxInstancedCount*c)):console.error("THREE.WebGLIndexedBufferRenderer: using THREE.InstancedBufferGeometry but hardware does not support extension ANGLE_instanced_arrays.")}}function ie(t,e,i){var r;this.setMode=function(t){r=t},this.render=function(e,n){t.drawArrays(r,e,n),i.calls++,i.vertices+=n,r===t.TRIANGLES?i.faces+=n/3:r===t.POINTS&&(i.points+=n)},this.renderInstances=function(n,o,a){var s=e.get("ANGLE_instanced_arrays");if(null!==s){var c=n.attributes.position;c.isInterleavedBufferAttribute?(a=c.data.count,s.drawArraysInstancedANGLE(r,0,a,n.maxInstancedCount)):s.drawArraysInstancedANGLE(r,o,a,n.maxInstancedCount),i.calls++,i.vertices+=a*n.maxInstancedCount,r===t.TRIANGLES?i.faces+=n.maxInstancedCount*a/3:r===t.POINTS&&(i.points+=n.maxInstancedCount*a)}else console.error("THREE.WebGLBufferRenderer: using THREE.InstancedBufferGeometry but hardware does not support extension ANGLE_instanced_arrays.")}}function re(t,e,i){function r(t){var a=t.target,s=n[a.id];null!==s.index&&e.remove(s.index);for(var c in s.attributes)e.remove(s.attributes[c]);a.removeEventListener("dispose",r),delete n[a.id];var u=o[a.id];u&&(e.remove(u),delete o[a.id]),(u=o[s.id])&&(e.remove(u),delete o[s.id]),i.geometries--}var n={},o={};return{get:function(t,e){var o=n[e.id];return o||(e.addEventListener("dispose",r),e.isBufferGeometry?o=e:e.isGeometry&&(void 0===e._bufferGeometry&&(e._bufferGeometry=(new Ft).setFromObject(t)),o=e._bufferGeometry),n[e.id]=o,i.geometries++,o)},update:function(i){var r=i.index,n=i.attributes;null!==r&&e.update(r,t.ELEMENT_ARRAY_BUFFER);for(var o in n)e.update(n[o],t.ARRAY_BUFFER);var a=i.morphAttributes;for(var o in a)for(var s=a[o],c=0,u=s.length;c<u;c++)e.update(s[c],t.ARRAY_BUFFER)},getWireframeAttribute:function(i){var r=o[i.id];if(r)return r;var n=[],a=i.index,s=i.attributes;if(null!==a)for(var c=0,u=(d=a.array).length;c<u;c+=3){var l=d[c+0],h=d[c+1],p=d[c+2];n.push(l,h,h,p,p,l)}else for(var d=s.position.array,c=0,u=d.length/3-1;c<u;c+=3){var l=c+0,h=c+1,p=c+2;n.push(l,h,h,p,p,l)}return r=new(Bt(n)>65535?Ot:Rt)(n,1),e.update(r,t.ELEMENT_ARRAY_BUFFER),o[i.id]=r,r}}}function ne(){var t={};return{get:function(e){if(void 0!==t[e.id])return t[e.id];var i;switch(e.type){case"DirectionalLight":i={direction:new v,color:new et,shadow:!1,shadowBias:0,shadowRadius:1,shadowMapSize:new h};break;case"SpotLight":i={position:new v,direction:new v,color:new et,distance:0,coneCos:0,penumbraCos:0,decay:0,shadow:!1,shadowBias:0,shadowRadius:1,shadowMapSize:new h};break;case"PointLight":i={position:new v,color:new et,distance:0,decay:0,shadow:!1,shadowBias:0,shadowRadius:1,shadowMapSize:new h,shadowCameraNear:1,shadowCameraFar:1e3};break;case"HemisphereLight":i={direction:new v,skyColor:new et,groundColor:new et};break;case"RectAreaLight":i={color:new et,position:new v,halfWidth:new v,halfHeight:new v}}return t[e.id]=i,i}}}function oe(){var t=new ne,e={hash:"",ambient:[0,0,0],directional:[],directionalShadowMap:[],directionalShadowMatrix:[],spot:[],spotShadowMap:[],spotShadowMatrix:[],rectArea:[],point:[],pointShadowMap:[],pointShadowMatrix:[],hemi:[]},i=new v,r=new y,n=new y;return{setup:function(o,a,s){for(var c=0,u=0,l=0,h=0,p=0,d=0,f=0,m=0,g=s.matrixWorldInverse,v=0,y=o.length;v<y;v++){var b=o[v],x=b.color,_=b.intensity,w=b.distance,S=b.shadow&&b.shadow.map?b.shadow.map.texture:null;if(b.isAmbientLight)c+=x.r*_,u+=x.g*_,l+=x.b*_;else if(b.isDirectionalLight)(M=t.get(b)).color.copy(b.color).multiplyScalar(b.intensity),M.direction.setFromMatrixPosition(b.matrixWorld),i.setFromMatrixPosition(b.target.matrixWorld),M.direction.sub(i),M.direction.transformDirection(g),M.shadow=b.castShadow,b.castShadow&&(A=b.shadow,M.shadowBias=A.bias,M.shadowRadius=A.radius,M.shadowMapSize=A.mapSize),e.directionalShadowMap[h]=S,e.directionalShadowMatrix[h]=b.shadow.matrix,e.directional[h]=M,h++;else if(b.isSpotLight)(M=t.get(b)).position.setFromMatrixPosition(b.matrixWorld),M.position.applyMatrix4(g),M.color.copy(x).multiplyScalar(_),M.distance=w,M.direction.setFromMatrixPosition(b.matrixWorld),i.setFromMatrixPosition(b.target.matrixWorld),M.direction.sub(i),M.direction.transformDirection(g),M.coneCos=Math.cos(b.angle),M.penumbraCos=Math.cos(b.angle*(1-b.penumbra)),M.decay=0===b.distance?0:b.decay,M.shadow=b.castShadow,b.castShadow&&(A=b.shadow,M.shadowBias=A.bias,M.shadowRadius=A.radius,M.shadowMapSize=A.mapSize),e.spotShadowMap[d]=S,e.spotShadowMatrix[d]=b.shadow.matrix,e.spot[d]=M,d++;else if(b.isRectAreaLight)(M=t.get(b)).color.copy(x).multiplyScalar(_/(b.width*b.height)),M.position.setFromMatrixPosition(b.matrixWorld),M.position.applyMatrix4(g),n.identity(),r.copy(b.matrixWorld),r.premultiply(g),n.extractRotation(r),M.halfWidth.set(.5*b.width,0,0),M.halfHeight.set(0,.5*b.height,0),M.halfWidth.applyMatrix4(n),M.halfHeight.applyMatrix4(n),e.rectArea[f]=M,f++;else if(b.isPointLight){if((M=t.get(b)).position.setFromMatrixPosition(b.matrixWorld),M.position.applyMatrix4(g),M.color.copy(b.color).multiplyScalar(b.intensity),M.distance=b.distance,M.decay=0===b.distance?0:b.decay,M.shadow=b.castShadow,b.castShadow){var A=b.shadow;M.shadowBias=A.bias,M.shadowRadius=A.radius,M.shadowMapSize=A.mapSize,M.shadowCameraNear=A.camera.near,M.shadowCameraFar=A.camera.far}e.pointShadowMap[p]=S,e.pointShadowMatrix[p]=b.shadow.matrix,e.point[p]=M,p++}else if(b.isHemisphereLight){var M=t.get(b);M.direction.setFromMatrixPosition(b.matrixWorld),M.direction.transformDirection(g),M.direction.normalize(),M.skyColor.copy(b.color).multiplyScalar(_),M.groundColor.copy(b.groundColor).multiplyScalar(_),e.hemi[m]=M,m++}}e.ambient[0]=c,e.ambient[1]=u,e.ambient[2]=l,e.directional.length=h,e.spot.length=d,e.rectArea.length=f,e.point.length=p,e.hemi.length=m,e.hash=h+","+p+","+d+","+f+","+m+","+a.length},state:e}}function ae(t,e){var i={};return{update:function(r){var n=e.frame,o=r.geometry,a=t.get(r,o);return i[a.id]!==n&&(o.isGeometry&&a.updateFromObject(r),t.update(a),i[a.id]=n),a},clear:function(){i={}}}}function se(t){for(var e=t.split("\n"),i=0;i<e.length;i++)e[i]=i+1+": "+e[i];return e.join("\n")}function ce(t,e,i){var r=t.createShader(e);return t.shaderSource(r,i),t.compileShader(r),!1===t.getShaderParameter(r,t.COMPILE_STATUS)&&console.error("THREE.WebGLShader: Shader couldn't compile."),""!==t.getShaderInfoLog(r)&&console.warn("THREE.WebGLShader: gl.getShaderInfoLog()",e===t.VERTEX_SHADER?"vertex":"fragment",t.getShaderInfoLog(r),se(i)),r}function ue(t){switch(t){case mp:return["Linear","( value )"];case gp:return["sRGB","( value )"];case yp:return["RGBE","( value )"];case bp:return["RGBM","( value, 7.0 )"];case xp:return["RGBM","( value, 16.0 )"];case _p:return["RGBD","( value, 256.0 )"];case vp:return["Gamma","( value, float( GAMMA_FACTOR ) )"];default:throw new Error("unsupported encoding: "+t)}}function le(t,e){var i=ue(e);return"vec4 "+t+"( vec4 value ) { return "+i[0]+"ToLinear"+i[1]+"; }"}function he(t,e){var i=ue(e);return"vec4 "+t+"( vec4 value ) { return LinearTo"+i[0]+i[1]+"; }"}function pe(t,e){var i;switch(e){case gh:i="Linear";break;case vh:i="Reinhard";break;case yh:i="Uncharted2";break;case bh:i="OptimizedCineon";break;default:throw new Error("unsupported toneMapping: "+e)}return"vec3 "+t+"( vec3 color ) { return "+i+"ToneMapping( color ); }"}function de(t,e,i){return[(t=t||{}).derivatives||e.envMapCubeUV||e.bumpMap||e.normalMap||e.flatShading?"#extension GL_OES_standard_derivatives : enable":"",(t.fragDepth||e.logarithmicDepthBuffer)&&i.get("EXT_frag_depth")?"#extension GL_EXT_frag_depth : enable":"",t.drawBuffers&&i.get("WEBGL_draw_buffers")?"#extension GL_EXT_draw_buffers : require":"",(t.shaderTextureLOD||e.envMap)&&i.get("EXT_shader_texture_lod")?"#extension GL_EXT_shader_texture_lod : enable":""].filter(ge).join("\n")}function fe(t){var e=[];for(var i in t){var r=t[i];!1!==r&&e.push("#define "+i+" "+r)}return e.join("\n")}function me(t,e,i){for(var r={},n=t.getProgramParameter(e,t.ACTIVE_ATTRIBUTES),o=0;o<n;o++){var a=t.getActiveAttrib(e,o).name;r[a]=t.getAttribLocation(e,a)}return r}function ge(t){return""!==t}function ve(t,e){return t.replace(/NUM_DIR_LIGHTS/g,e.numDirLights).replace(/NUM_SPOT_LIGHTS/g,e.numSpotLights).replace(/NUM_RECT_AREA_LIGHTS/g,e.numRectAreaLights).replace(/NUM_POINT_LIGHTS/g,e.numPointLights).replace(/NUM_HEMI_LIGHTS/g,e.numHemiLights)}function ye(t){var e=/^[ \t]*#include +<([\w\d.]+)>/gm;return t.replace(e,function(t,e){var i=kp[e];if(void 0===i)throw new Error("Can not resolve #include <"+e+">");return ye(i)})}function be(t){var e=/for \( int i \= (\d+)\; i < (\d+)\; i \+\+ \) \{([\s\S]+?)(?=\})\}/g;return t.replace(e,function(t,e,i,r){for(var n="",o=parseInt(e);o<parseInt(i);o++)n+=r.replace(/\[ i \]/g,"[ "+o+" ]");return n})}function xe(t,e,i,r,n,o){var a=t.context,s=r.defines,c=n.vertexShader,u=n.fragmentShader,l="SHADOWMAP_TYPE_BASIC";o.shadowMapType===Tl?l="SHADOWMAP_TYPE_PCF":o.shadowMapType===Cl&&(l="SHADOWMAP_TYPE_PCF_SOFT");var h="ENVMAP_TYPE_CUBE",p="ENVMAP_MODE_REFLECTION",d="ENVMAP_BLENDING_MULTIPLY";if(o.envMap){switch(r.envMap.mapping){case xh:case _h:h="ENVMAP_TYPE_CUBE";break;case Mh:case Ph:h="ENVMAP_TYPE_CUBE_UV";break;case wh:case Sh:h="ENVMAP_TYPE_EQUIREC";break;case Ah:h="ENVMAP_TYPE_SPHERE"}switch(r.envMap.mapping){case _h:case Sh:p="ENVMAP_MODE_REFRACTION"}switch(r.combine){case ph:d="ENVMAP_BLENDING_MULTIPLY";break;case dh:d="ENVMAP_BLENDING_MIX";break;case fh:d="ENVMAP_BLENDING_ADD"}}var f,m,g=t.gammaFactor>0?t.gammaFactor:1,v=de(r.extensions,o,e),y=fe(s),b=a.createProgram();r.isRawShaderMaterial?(f=[y,"\n"].filter(ge).join("\n"),m=[v,y,"\n"].filter(ge).join("\n")):(f=["precision "+o.precision+" float;","precision "+o.precision+" int;","#define SHADER_NAME "+n.name,y,o.supportsVertexTextures?"#define VERTEX_TEXTURES":"","#define GAMMA_FACTOR "+g,"#define MAX_BONES "+o.maxBones,o.useFog&&o.fog?"#define USE_FOG":"",o.useFog&&o.fogExp?"#define FOG_EXP2":"",o.map?"#define USE_MAP":"",o.envMap?"#define USE_ENVMAP":"",o.envMap?"#define "+p:"",o.lightMap?"#define USE_LIGHTMAP":"",o.aoMap?"#define USE_AOMAP":"",o.emissiveMap?"#define USE_EMISSIVEMAP":"",o.bumpMap?"#define USE_BUMPMAP":"",o.normalMap?"#define USE_NORMALMAP":"",o.displacementMap&&o.supportsVertexTextures?"#define USE_DISPLACEMENTMAP":"",o.specularMap?"#define USE_SPECULARMAP":"",o.roughnessMap?"#define USE_ROUGHNESSMAP":"",o.metalnessMap?"#define USE_METALNESSMAP":"",o.alphaMap?"#define USE_ALPHAMAP":"",o.vertexColors?"#define USE_COLOR":"",o.flatShading?"#define FLAT_SHADED":"",o.skinning?"#define USE_SKINNING":"",o.useVertexTexture?"#define BONE_TEXTURE":"",o.morphTargets?"#define USE_MORPHTARGETS":"",o.morphNormals&&!1===o.flatShading?"#define USE_MORPHNORMALS":"",o.doubleSided?"#define DOUBLE_SIDED":"",o.flipSided?"#define FLIP_SIDED":"","#define NUM_CLIPPING_PLANES "+o.numClippingPlanes,o.shadowMapEnabled?"#define USE_SHADOWMAP":"",o.shadowMapEnabled?"#define "+l:"",o.sizeAttenuation?"#define USE_SIZEATTENUATION":"",o.logarithmicDepthBuffer?"#define USE_LOGDEPTHBUF":"",o.logarithmicDepthBuffer&&e.get("EXT_frag_depth")?"#define USE_LOGDEPTHBUF_EXT":"","uniform mat4 modelMatrix;","uniform mat4 modelViewMatrix;","uniform mat4 projectionMatrix;","uniform mat4 viewMatrix;","uniform mat3 normalMatrix;","uniform vec3 cameraPosition;","attribute vec3 position;","attribute vec3 normal;","attribute vec2 uv;","#ifdef USE_COLOR","\tattribute vec3 color;","#endif","#ifdef USE_MORPHTARGETS","\tattribute vec3 morphTarget0;","\tattribute vec3 morphTarget1;","\tattribute vec3 morphTarget2;","\tattribute vec3 morphTarget3;","\t#ifdef USE_MORPHNORMALS","\t\tattribute vec3 morphNormal0;","\t\tattribute vec3 morphNormal1;","\t\tattribute vec3 morphNormal2;","\t\tattribute vec3 morphNormal3;","\t#else","\t\tattribute vec3 morphTarget4;","\t\tattribute vec3 morphTarget5;","\t\tattribute vec3 morphTarget6;","\t\tattribute vec3 morphTarget7;","\t#endif","#endif","#ifdef USE_SKINNING","\tattribute vec4 skinIndex;","\tattribute vec4 skinWeight;","#endif","\n"].filter(ge).join("\n"),m=[v,"precision "+o.precision+" float;","precision "+o.precision+" int;","#define SHADER_NAME "+n.name,y,o.alphaTest?"#define ALPHATEST "+o.alphaTest:"","#define GAMMA_FACTOR "+g,o.useFog&&o.fog?"#define USE_FOG":"",o.useFog&&o.fogExp?"#define FOG_EXP2":"",o.map?"#define USE_MAP":"",o.envMap?"#define USE_ENVMAP":"",o.envMap?"#define "+h:"",o.envMap?"#define "+p:"",o.envMap?"#define "+d:"",o.lightMap?"#define USE_LIGHTMAP":"",o.aoMap?"#define USE_AOMAP":"",o.emissiveMap?"#define USE_EMISSIVEMAP":"",o.bumpMap?"#define USE_BUMPMAP":"",o.normalMap?"#define USE_NORMALMAP":"",o.specularMap?"#define USE_SPECULARMAP":"",o.roughnessMap?"#define USE_ROUGHNESSMAP":"",o.metalnessMap?"#define USE_METALNESSMAP":"",o.alphaMap?"#define USE_ALPHAMAP":"",o.vertexColors?"#define USE_COLOR":"",o.gradientMap?"#define USE_GRADIENTMAP":"",o.flatShading?"#define FLAT_SHADED":"",o.doubleSided?"#define DOUBLE_SIDED":"",o.flipSided?"#define FLIP_SIDED":"","#define NUM_CLIPPING_PLANES "+o.numClippingPlanes,"#define UNION_CLIPPING_PLANES "+(o.numClippingPlanes-o.numClipIntersection),o.shadowMapEnabled?"#define USE_SHADOWMAP":"",o.shadowMapEnabled?"#define "+l:"",o.premultipliedAlpha?"#define PREMULTIPLIED_ALPHA":"",o.physicallyCorrectLights?"#define PHYSICALLY_CORRECT_LIGHTS":"",o.logarithmicDepthBuffer?"#define USE_LOGDEPTHBUF":"",o.logarithmicDepthBuffer&&e.get("EXT_frag_depth")?"#define USE_LOGDEPTHBUF_EXT":"",o.envMap&&e.get("EXT_shader_texture_lod")?"#define TEXTURE_LOD_EXT":"","uniform mat4 viewMatrix;","uniform vec3 cameraPosition;",o.toneMapping!==mh?"#define TONE_MAPPING":"",o.toneMapping!==mh?kp.tonemapping_pars_fragment:"",o.toneMapping!==mh?pe("toneMapping",o.toneMapping):"",o.dithering?"#define DITHERING":"",o.outputEncoding||o.mapEncoding||o.envMapEncoding||o.emissiveMapEncoding?kp.encodings_pars_fragment:"",o.mapEncoding?le("mapTexelToLinear",o.mapEncoding):"",o.envMapEncoding?le("envMapTexelToLinear",o.envMapEncoding):"",o.emissiveMapEncoding?le("emissiveMapTexelToLinear",o.emissiveMapEncoding):"",o.outputEncoding?he("linearToOutputTexel",o.outputEncoding):"",o.depthPacking?"#define DEPTH_PACKING "+r.depthPacking:"","\n"].filter(ge).join("\n")),c=ve(c=ye(c),o),u=ve(u=ye(u),o),r.isShaderMaterial||(c=be(c),u=be(u));var x=f+c,_=m+u,w=ce(a,a.VERTEX_SHADER,x),S=ce(a,a.FRAGMENT_SHADER,_);a.attachShader(b,w),a.attachShader(b,S),void 0!==r.index0AttributeName?a.bindAttribLocation(b,0,r.index0AttributeName):!0===o.morphTargets&&a.bindAttribLocation(b,0,"position"),a.linkProgram(b);var A=a.getProgramInfoLog(b),M=a.getShaderInfoLog(w),P=a.getShaderInfoLog(S),E=!0,T=!0;!1===a.getProgramParameter(b,a.LINK_STATUS)?(E=!1,console.error("THREE.WebGLProgram: shader error: ",a.getError(),"gl.VALIDATE_STATUS",a.getProgramParameter(b,a.VALIDATE_STATUS),"gl.getProgramInfoLog",A,M,P)):""!==A?console.warn("THREE.WebGLProgram: gl.getProgramInfoLog()",A):""!==M&&""!==P||(T=!1),T&&(this.diagnostics={runnable:E,material:r,programLog:A,vertexShader:{log:M,prefix:f},fragmentShader:{log:P,prefix:m}}),a.deleteShader(w),a.deleteShader(S);var C;this.getUniforms=function(){return void 0===C&&(C=new tt(a,b,t)),C};var I;return this.getAttributes=function(){return void 0===I&&(I=me(a,b)),I},this.destroy=function(){a.deleteProgram(b),this.program=void 0},Object.defineProperties(this,{uniforms:{get:function(){return console.warn("THREE.WebGLProgram: .uniforms is now .getUniforms()."),this.getUniforms()}},attributes:{get:function(){return console.warn("THREE.WebGLProgram: .attributes is now .getAttributes()."),this.getAttributes()}}}),this.id=jp++,this.code=i,this.usedTimes=1,this.program=b,this.vertexShader=w,this.fragmentShader=S,this}function _e(t,e,i){function r(t){var e=t.skeleton.bones;if(i.floatVertexTextures)return 1024;var r=i.maxVertexUniforms,n=Math.floor((r-20)/4),o=Math.min(n,e.length);return o<e.length?(console.warn("THREE.WebGLRenderer: Skeleton has "+e.length+" bones. This GPU supports "+o+"."),0):o}function n(t,e){var i;return t?t.isTexture?i=t.encoding:t.isWebGLRenderTarget&&(console.warn("THREE.WebGLPrograms.getTextureEncodingFromMap: don't use render targets as textures. Use their .texture property instead."),i=t.texture.encoding):i=mp,i===mp&&e&&(i=vp),i}var o=[],a={MeshDepthMaterial:"depth",MeshDistanceMaterial:"distanceRGBA",MeshNormalMaterial:"normal",MeshBasicMaterial:"basic",MeshLambertMaterial:"lambert",MeshPhongMaterial:"phong",MeshToonMaterial:"phong",MeshStandardMaterial:"physical",MeshPhysicalMaterial:"physical",LineBasicMaterial:"basic",LineDashedMaterial:"dashed",PointsMaterial:"points",ShadowMaterial:"shadow"},s=["precision","supportsVertexTextures","map","mapEncoding","envMap","envMapMode","envMapEncoding","lightMap","aoMap","emissiveMap","emissiveMapEncoding","bumpMap","normalMap","displacementMap","specularMap","roughnessMap","metalnessMap","gradientMap","alphaMap","combine","vertexColors","fog","useFog","fogExp","flatShading","sizeAttenuation","logarithmicDepthBuffer","skinning","maxBones","useVertexTexture","morphTargets","morphNormals","maxMorphTargets","maxMorphNormals","premultipliedAlpha","numDirLights","numPointLights","numSpotLights","numHemiLights","numRectAreaLights","shadowMapEnabled","shadowMapType","toneMapping","physicallyCorrectLights","alphaTest","doubleSided","flipSided","numClippingPlanes","numClipIntersection","depthPacking","dithering"];this.getParameters=function(e,o,s,c,u,l,h){var p=a[e.type],d=h.isSkinnedMesh?r(h):0,f=i.precision;null!==e.precision&&(f=i.getMaxPrecision(e.precision))!==e.precision&&console.warn("THREE.WebGLProgram.getParameters:",e.precision,"not supported, using",f,"instead.");var m=t.getRenderTarget();return{shaderID:p,precision:f,supportsVertexTextures:i.vertexTextures,outputEncoding:n(m?m.texture:null,t.gammaOutput),map:!!e.map,mapEncoding:n(e.map,t.gammaInput),envMap:!!e.envMap,envMapMode:e.envMap&&e.envMap.mapping,envMapEncoding:n(e.envMap,t.gammaInput),envMapCubeUV:!!e.envMap&&(e.envMap.mapping===Mh||e.envMap.mapping===Ph),lightMap:!!e.lightMap,aoMap:!!e.aoMap,emissiveMap:!!e.emissiveMap,emissiveMapEncoding:n(e.emissiveMap,t.gammaInput),bumpMap:!!e.bumpMap,normalMap:!!e.normalMap,displacementMap:!!e.displacementMap,roughnessMap:!!e.roughnessMap,metalnessMap:!!e.metalnessMap,specularMap:!!e.specularMap,alphaMap:!!e.alphaMap,gradientMap:!!e.gradientMap,combine:e.combine,vertexColors:e.vertexColors,fog:!!c,useFog:e.fog,fogExp:c&&c.isFogExp2,flatShading:e.flatShading,sizeAttenuation:e.sizeAttenuation,logarithmicDepthBuffer:i.logarithmicDepthBuffer,skinning:e.skinning&&d>0,maxBones:d,useVertexTexture:i.floatVertexTextures,morphTargets:e.morphTargets,morphNormals:e.morphNormals,maxMorphTargets:t.maxMorphTargets,maxMorphNormals:t.maxMorphNormals,numDirLights:o.directional.length,numPointLights:o.point.length,numSpotLights:o.spot.length,numRectAreaLights:o.rectArea.length,numHemiLights:o.hemi.length,numClippingPlanes:u,numClipIntersection:l,dithering:e.dithering,shadowMapEnabled:t.shadowMap.enabled&&h.receiveShadow&&s.length>0,shadowMapType:t.shadowMap.type,toneMapping:t.toneMapping,physicallyCorrectLights:t.physicallyCorrectLights,premultipliedAlpha:e.premultipliedAlpha,alphaTest:e.alphaTest,doubleSided:e.side===Ll,flipSided:e.side===Rl,depthPacking:void 0!==e.depthPacking&&e.depthPacking}},this.getProgramCode=function(e,i){var r=[];if(i.shaderID?r.push(i.shaderID):(r.push(e.fragmentShader),r.push(e.vertexShader)),void 0!==e.defines)for(var n in e.defines)r.push(n),r.push(e.defines[n]);for(var o=0;o<s.length;o++)r.push(i[s[o]]);return r.push(e.onBeforeCompile.toString()),r.push(t.gammaOutput),r.join()},this.acquireProgram=function(i,r,n,a){for(var s,c=0,u=o.length;c<u;c++){var l=o[c];if(l.code===a){++(s=l).usedTimes;break}}return void 0===s&&(s=new xe(t,e,a,i,r,n),o.push(s)),s},this.releaseProgram=function(t){if(0==--t.usedTimes){var e=o.indexOf(t);o[e]=o[o.length-1],o.pop(),t.destroy()}},this.programs=o}function we(t,e,i,r,n,o,a){function s(t,e){if(t.width>e||t.height>e){var i=e/Math.max(t.width,t.height),r=document.createElementNS("http://www.w3.org/1999/xhtml","canvas");return r.width=Math.floor(t.width*i),r.height=Math.floor(t.height*i),r.getContext("2d").drawImage(t,0,0,t.width,t.height,0,0,r.width,r.height),console.warn("THREE.WebGLRenderer: image is too big ("+t.width+"x"+t.height+"). Resized to "+r.width+"x"+r.height,t),r}return t}function c(t){return Ap.isPowerOfTwo(t.width)&&Ap.isPowerOfTwo(t.height)}function u(t){if(t instanceof HTMLImageElement||t instanceof HTMLCanvasElement){var e=document.createElementNS("http://www.w3.org/1999/xhtml","canvas");return e.width=Ap.nearestPowerOfTwo(t.width),e.height=Ap.nearestPowerOfTwo(t.height),e.getContext("2d").drawImage(t,0,0,e.width,e.height),console.warn("THREE.WebGLRenderer: image is not power of two ("+t.width+"x"+t.height+"). Resized to "+e.width+"x"+e.height,t),e}return t}function l(t){return t.wrapS!==Th||t.wrapT!==Th||t.minFilter!==Ih&&t.minFilter!==Oh}function h(t,e){return t.generateMipmaps&&e&&t.minFilter!==Ih&&t.minFilter!==Oh}function p(e){return e===Ih||e===Rh||e===Lh?t.NEAREST:t.LINEAR}function d(t){var e=t.target;e.removeEventListener("dispose",d),m(e),a.textures--}function f(t){var e=t.target;e.removeEventListener("dispose",f),g(e),a.textures--}function m(e){var i=r.get(e);if(e.image&&i.__image__webglTextureCube)t.deleteTexture(i.__image__webglTextureCube);else{if(void 0===i.__webglInit)return;t.deleteTexture(i.__webglTexture)}r.remove(e)}function g(e){var i=r.get(e),n=r.get(e.texture);if(e){if(void 0!==n.__webglTexture&&t.deleteTexture(n.__webglTexture),e.depthTexture&&e.depthTexture.dispose(),e.isWebGLRenderTargetCube)for(var o=0;o<6;o++)t.deleteFramebuffer(i.__webglFramebuffer[o]),i.__webglDepthbuffer&&t.deleteRenderbuffer(i.__webglDepthbuffer[o]);else t.deleteFramebuffer(i.__webglFramebuffer),i.__webglDepthbuffer&&t.deleteRenderbuffer(i.__webglDepthbuffer);r.remove(e.texture),r.remove(e)}}function v(e,n){var o=r.get(e);if(e.version>0&&o.__version!==e.version){var a=e.image;if(void 0===a)console.warn("THREE.WebGLRenderer: Texture marked for update but image is undefined",e);else{if(!1!==a.complete)return void b(o,e,n);console.warn("THREE.WebGLRenderer: Texture marked for update but image is incomplete",e)}}i.activeTexture(t.TEXTURE0+n),i.bindTexture(t.TEXTURE_2D,o.__webglTexture)}function y(i,a,s){var c;if(s?(t.texParameteri(i,t.TEXTURE_WRAP_S,o.convert(a.wrapS)),t.texParameteri(i,t.TEXTURE_WRAP_T,o.convert(a.wrapT)),t.texParameteri(i,t.TEXTURE_MAG_FILTER,o.convert(a.magFilter)),t.texParameteri(i,t.TEXTURE_MIN_FILTER,o.convert(a.minFilter))):(t.texParameteri(i,t.TEXTURE_WRAP_S,t.CLAMP_TO_EDGE),t.texParameteri(i,t.TEXTURE_WRAP_T,t.CLAMP_TO_EDGE),a.wrapS===Th&&a.wrapT===Th||console.warn("THREE.WebGLRenderer: Texture is not power of two. Texture.wrapS and Texture.wrapT should be set to THREE.ClampToEdgeWrapping.",a),t.texParameteri(i,t.TEXTURE_MAG_FILTER,p(a.magFilter)),t.texParameteri(i,t.TEXTURE_MIN_FILTER,p(a.minFilter)),a.minFilter!==Ih&&a.minFilter!==Oh&&console.warn("THREE.WebGLRenderer: Texture is not power of two. Texture.minFilter should be set to THREE.NearestFilter or THREE.LinearFilter.",a)),c=e.get("EXT_texture_filter_anisotropic")){if(a.type===Vh&&null===e.get("OES_texture_float_linear"))return;if(a.type===Gh&&null===e.get("OES_texture_half_float_linear"))return;(a.anisotropy>1||r.get(a).__currentAnisotropy)&&(t.texParameterf(i,c.TEXTURE_MAX_ANISOTROPY_EXT,Math.min(a.anisotropy,n.getMaxAnisotropy())),r.get(a).__currentAnisotropy=a.anisotropy)}}function b(e,r,p){void 0===e.__webglInit&&(e.__webglInit=!0,r.addEventListener("dispose",d),e.__webglTexture=t.createTexture(),a.textures++),i.activeTexture(t.TEXTURE0+p),i.bindTexture(t.TEXTURE_2D,e.__webglTexture),t.pixelStorei(t.UNPACK_FLIP_Y_WEBGL,r.flipY),t.pixelStorei(t.UNPACK_PREMULTIPLY_ALPHA_WEBGL,r.premultiplyAlpha),t.pixelStorei(t.UNPACK_ALIGNMENT,r.unpackAlignment);var f=s(r.image,n.maxTextureSize);l(r)&&!1===c(f)&&(f=u(f));var m=c(f),g=o.convert(r.format),v=o.convert(r.type);y(t.TEXTURE_2D,r,m);var b,x=r.mipmaps;if(r.isDepthTexture){var _=t.DEPTH_COMPONENT;if(r.type===Vh){if(!A)throw new Error("Float Depth Texture only supported in WebGL2.0");_=t.DEPTH_COMPONENT32F}else A&&(_=t.DEPTH_COMPONENT16);r.format===Jh&&_===t.DEPTH_COMPONENT&&r.type!==zh&&r.type!==jh&&(console.warn("THREE.WebGLRenderer: Use UnsignedShortType or UnsignedIntType for DepthFormat DepthTexture."),r.type=zh,v=o.convert(r.type)),r.format===tp&&(_=t.DEPTH_STENCIL,r.type!==Xh&&(console.warn("THREE.WebGLRenderer: Use UnsignedInt248Type for DepthStencilFormat DepthTexture."),r.type=Xh,v=o.convert(r.type))),i.texImage2D(t.TEXTURE_2D,0,_,f.width,f.height,0,g,v,null)}else if(r.isDataTexture)if(x.length>0&&m){for(var w=0,S=x.length;w<S;w++)b=x[w],i.texImage2D(t.TEXTURE_2D,w,g,b.width,b.height,0,g,v,b.data);r.generateMipmaps=!1}else i.texImage2D(t.TEXTURE_2D,0,g,f.width,f.height,0,g,v,f.data);else if(r.isCompressedTexture)for(var w=0,S=x.length;w<S;w++)b=x[w],r.format!==Zh&&r.format!==Yh?i.getCompressedTextureFormats().indexOf(g)>-1?i.compressedTexImage2D(t.TEXTURE_2D,w,g,b.width,b.height,0,b.data):console.warn("THREE.WebGLRenderer: Attempt to load unsupported compressed texture format in .uploadTexture()"):i.texImage2D(t.TEXTURE_2D,w,g,b.width,b.height,0,g,v,b.data);else if(x.length>0&&m){for(var w=0,S=x.length;w<S;w++)b=x[w],i.texImage2D(t.TEXTURE_2D,w,g,g,v,b);r.generateMipmaps=!1}else i.texImage2D(t.TEXTURE_2D,0,g,g,v,f);h(r,m)&&t.generateMipmap(t.TEXTURE_2D),e.__version=r.version,r.onUpdate&&r.onUpdate(r)}function x(e,n,a,s){var c=o.convert(n.texture.format),u=o.convert(n.texture.type);i.texImage2D(s,0,c,n.width,n.height,0,c,u,null),t.bindFramebuffer(t.FRAMEBUFFER,e),t.framebufferTexture2D(t.FRAMEBUFFER,a,s,r.get(n.texture).__webglTexture,0),t.bindFramebuffer(t.FRAMEBUFFER,null)}function _(e,i){t.bindRenderbuffer(t.RENDERBUFFER,e),i.depthBuffer&&!i.stencilBuffer?(t.renderbufferStorage(t.RENDERBUFFER,t.DEPTH_COMPONENT16,i.width,i.height),t.framebufferRenderbuffer(t.FRAMEBUFFER,t.DEPTH_ATTACHMENT,t.RENDERBUFFER,e)):i.depthBuffer&&i.stencilBuffer?(t.renderbufferStorage(t.RENDERBUFFER,t.DEPTH_STENCIL,i.width,i.height),t.framebufferRenderbuffer(t.FRAMEBUFFER,t.DEPTH_STENCIL_ATTACHMENT,t.RENDERBUFFER,e)):t.renderbufferStorage(t.RENDERBUFFER,t.RGBA4,i.width,i.height),t.bindRenderbuffer(t.RENDERBUFFER,null)}function w(e,i){if(i&&i.isWebGLRenderTargetCube)throw new Error("Depth Texture with cube render targets is not supported");if(t.bindFramebuffer(t.FRAMEBUFFER,e),!i.depthTexture||!i.depthTexture.isDepthTexture)throw new Error("renderTarget.depthTexture must be an instance of THREE.DepthTexture");r.get(i.depthTexture).__webglTexture&&i.depthTexture.image.width===i.width&&i.depthTexture.image.height===i.height||(i.depthTexture.image.width=i.width,i.depthTexture.image.height=i.height,i.depthTexture.needsUpdate=!0),v(i.depthTexture,0);var n=r.get(i.depthTexture).__webglTexture;if(i.depthTexture.format===Jh)t.framebufferTexture2D(t.FRAMEBUFFER,t.DEPTH_ATTACHMENT,t.TEXTURE_2D,n,0);else{if(i.depthTexture.format!==tp)throw new Error("Unknown depthTexture format");t.framebufferTexture2D(t.FRAMEBUFFER,t.DEPTH_STENCIL_ATTACHMENT,t.TEXTURE_2D,n,0)}}function S(e){var i=r.get(e),n=!0===e.isWebGLRenderTargetCube;if(e.depthTexture){if(n)throw new Error("target.depthTexture not supported in Cube render targets");w(i.__webglFramebuffer,e)}else if(n){i.__webglDepthbuffer=[];for(var o=0;o<6;o++)t.bindFramebuffer(t.FRAMEBUFFER,i.__webglFramebuffer[o]),i.__webglDepthbuffer[o]=t.createRenderbuffer(),_(i.__webglDepthbuffer[o],e)}else t.bindFramebuffer(t.FRAMEBUFFER,i.__webglFramebuffer),i.__webglDepthbuffer=t.createRenderbuffer(),_(i.__webglDepthbuffer,e);t.bindFramebuffer(t.FRAMEBUFFER,null)}var A="undefined"!=typeof WebGL2RenderingContext&&t instanceof WebGL2RenderingContext;this.setTexture2D=v,this.setTextureCube=function(e,u){var l=r.get(e);if(6===e.image.length)if(e.version>0&&l.__version!==e.version){l.__image__webglTextureCube||(e.addEventListener("dispose",d),l.__image__webglTextureCube=t.createTexture(),a.textures++),i.activeTexture(t.TEXTURE0+u),i.bindTexture(t.TEXTURE_CUBE_MAP,l.__image__webglTextureCube),t.pixelStorei(t.UNPACK_FLIP_Y_WEBGL,e.flipY);for(var p=e&&e.isCompressedTexture,f=e.image[0]&&e.image[0].isDataTexture,m=[],g=0;g<6;g++)m[g]=p||f?f?e.image[g].image:e.image[g]:s(e.image[g],n.maxCubemapSize);var v=c(m[0]),b=o.convert(e.format),x=o.convert(e.type);for(y(t.TEXTURE_CUBE_MAP,e,v),g=0;g<6;g++)if(p)for(var _,w=m[g].mipmaps,S=0,A=w.length;S<A;S++)_=w[S],e.format!==Zh&&e.format!==Yh?i.getCompressedTextureFormats().indexOf(b)>-1?i.compressedTexImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+g,S,b,_.width,_.height,0,_.data):console.warn("THREE.WebGLRenderer: Attempt to load unsupported compressed texture format in .setTextureCube()"):i.texImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+g,S,b,_.width,_.height,0,b,x,_.data);else f?i.texImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+g,0,b,m[g].width,m[g].height,0,b,x,m[g].data):i.texImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+g,0,b,b,x,m[g]);h(e,v)&&t.generateMipmap(t.TEXTURE_CUBE_MAP),l.__version=e.version,e.onUpdate&&e.onUpdate(e)}else i.activeTexture(t.TEXTURE0+u),i.bindTexture(t.TEXTURE_CUBE_MAP,l.__image__webglTextureCube)},this.setTextureCubeDynamic=function(e,n){i.activeTexture(t.TEXTURE0+n),i.bindTexture(t.TEXTURE_CUBE_MAP,r.get(e).__webglTexture)},this.setupRenderTarget=function(e){var n=r.get(e),o=r.get(e.texture);e.addEventListener("dispose",f),o.__webglTexture=t.createTexture(),a.textures++;var s=!0===e.isWebGLRenderTargetCube,u=c(e);if(s)for(n.__webglFramebuffer=[],l=0;l<6;l++)n.__webglFramebuffer[l]=t.createFramebuffer();else n.__webglFramebuffer=t.createFramebuffer();if(s){i.bindTexture(t.TEXTURE_CUBE_MAP,o.__webglTexture),y(t.TEXTURE_CUBE_MAP,e.texture,u);for(var l=0;l<6;l++)x(n.__webglFramebuffer[l],e,t.COLOR_ATTACHMENT0,t.TEXTURE_CUBE_MAP_POSITIVE_X+l);h(e.texture,u)&&t.generateMipmap(t.TEXTURE_CUBE_MAP),i.bindTexture(t.TEXTURE_CUBE_MAP,null)}else i.bindTexture(t.TEXTURE_2D,o.__webglTexture),y(t.TEXTURE_2D,e.texture,u),x(n.__webglFramebuffer,e,t.COLOR_ATTACHMENT0,t.TEXTURE_2D),h(e.texture,u)&&t.generateMipmap(t.TEXTURE_2D),i.bindTexture(t.TEXTURE_2D,null);e.depthBuffer&&S(e)},this.updateRenderTargetMipmap=function(e){var n=e.texture;if(h(n,c(e))){var o=e.isWebGLRenderTargetCube?t.TEXTURE_CUBE_MAP:t.TEXTURE_2D,a=r.get(n).__webglTexture;i.bindTexture(o,a),t.generateMipmap(o),i.bindTexture(o,null)}}}function Se(){var t={};return{get:function(e){var i=e.uuid,r=t[i];return void 0===r&&(r={},t[i]=r),r},remove:function(e){delete t[e.uuid]},clear:function(){t={}}}}function Ae(t,e,i){function r(e,i,r){var n=new Uint8Array(4),o=t.createTexture();t.bindTexture(e,o),t.texParameteri(e,t.TEXTURE_MIN_FILTER,t.NEAREST),t.texParameteri(e,t.TEXTURE_MAG_FILTER,t.NEAREST);for(var a=0;a<r;a++)t.texImage2D(i+a,0,t.RGBA,1,1,0,t.RGBA,t.UNSIGNED_BYTE,n);return o}function n(e){!0!==b[e]&&(t.enable(e),b[e]=!0)}function o(e){!1!==b[e]&&(t.disable(e),b[e]=!1)}function a(e,r,a,s,c,u,l,h){if(e!==kl?n(t.BLEND):o(t.BLEND),e!==jl){if(e!==w||h!==C)switch(e){case Fl:h?(t.blendEquationSeparate(t.FUNC_ADD,t.FUNC_ADD),t.blendFuncSeparate(t.ONE,t.ONE,t.ONE,t.ONE)):(t.blendEquation(t.FUNC_ADD),t.blendFunc(t.SRC_ALPHA,t.ONE));break;case zl:h?(t.blendEquationSeparate(t.FUNC_ADD,t.FUNC_ADD),t.blendFuncSeparate(t.ZERO,t.ZERO,t.ONE_MINUS_SRC_COLOR,t.ONE_MINUS_SRC_ALPHA)):(t.blendEquation(t.FUNC_ADD),t.blendFunc(t.ZERO,t.ONE_MINUS_SRC_COLOR));break;case Ul:h?(t.blendEquationSeparate(t.FUNC_ADD,t.FUNC_ADD),t.blendFuncSeparate(t.ZERO,t.SRC_COLOR,t.ZERO,t.SRC_ALPHA)):(t.blendEquation(t.FUNC_ADD),t.blendFunc(t.ZERO,t.SRC_COLOR));break;default:h?(t.blendEquationSeparate(t.FUNC_ADD,t.FUNC_ADD),t.blendFuncSeparate(t.ONE,t.ONE_MINUS_SRC_ALPHA,t.ONE,t.ONE_MINUS_SRC_ALPHA)):(t.blendEquationSeparate(t.FUNC_ADD,t.FUNC_ADD),t.blendFuncSeparate(t.SRC_ALPHA,t.ONE_MINUS_SRC_ALPHA,t.ONE,t.ONE_MINUS_SRC_ALPHA))}S=null,A=null,M=null,P=null,E=null,T=null}else c=c||r,u=u||a,l=l||s,r===S&&c===P||(t.blendEquationSeparate(i.convert(r),i.convert(c)),S=r,P=c),a===A&&s===M&&u===E&&l===T||(t.blendFuncSeparate(i.convert(a),i.convert(s),i.convert(u),i.convert(l)),A=a,M=s,E=u,T=l);w=e,C=h}function s(e){I!==e&&(e?t.frontFace(t.CW):t.frontFace(t.CCW),I=e)}function c(e){e!==Al?(n(t.CULL_FACE),e!==R&&(e===Ml?t.cullFace(t.BACK):e===Pl?t.cullFace(t.FRONT):t.cullFace(t.FRONT_AND_BACK))):o(t.CULL_FACE),R=e}function u(e,i,r){e?(n(t.POLYGON_OFFSET_FILL),O===i&&D===r||(t.polygonOffset(i,r),O=i,D=r)):o(t.POLYGON_OFFSET_FILL)}function l(e){void 0===e&&(e=t.TEXTURE0+N-1),F!==e&&(t.activeTexture(e),F=e)}var h=new function(){var e=!1,i=new d,r=null,n=new d(0,0,0,0);return{setMask:function(i){r===i||e||(t.colorMask(i,i,i,i),r=i)},setLocked:function(t){e=t},setClear:function(e,r,o,a,s){!0===s&&(e*=a,r*=a,o*=a),i.set(e,r,o,a),!1===n.equals(i)&&(t.clearColor(e,r,o,a),n.copy(i))},reset:function(){e=!1,r=null,n.set(-1,0,0,0)}}},p=new function(){var e=!1,i=null,r=null,a=null;return{setTest:function(e){e?n(t.DEPTH_TEST):o(t.DEPTH_TEST)},setMask:function(r){i===r||e||(t.depthMask(r),i=r)},setFunc:function(e){if(r!==e){if(e)switch(e){case nh:t.depthFunc(t.NEVER);break;case oh:t.depthFunc(t.ALWAYS);break;case ah:t.depthFunc(t.LESS);break;case sh:t.depthFunc(t.LEQUAL);break;case ch:t.depthFunc(t.EQUAL);break;case uh:t.depthFunc(t.GEQUAL);break;case lh:t.depthFunc(t.GREATER);break;case hh:t.depthFunc(t.NOTEQUAL);break;default:t.depthFunc(t.LEQUAL)}else t.depthFunc(t.LEQUAL);r=e}},setLocked:function(t){e=t},setClear:function(e){a!==e&&(t.clearDepth(e),a=e)},reset:function(){e=!1,i=null,r=null,a=null}}},f=new function(){var e=!1,i=null,r=null,a=null,s=null,c=null,u=null,l=null,h=null;return{setTest:function(e){e?n(t.STENCIL_TEST):o(t.STENCIL_TEST)},setMask:function(r){i===r||e||(t.stencilMask(r),i=r)},setFunc:function(e,i,n){r===e&&a===i&&s===n||(t.stencilFunc(e,i,n),r=e,a=i,s=n)},setOp:function(e,i,r){c===e&&u===i&&l===r||(t.stencilOp(e,i,r),c=e,u=i,l=r)},setLocked:function(t){e=t},setClear:function(e){h!==e&&(t.clearStencil(e),h=e)},reset:function(){e=!1,i=null,r=null,a=null,s=null,c=null,u=null,l=null,h=null}}},m=t.getParameter(t.MAX_VERTEX_ATTRIBS),g=new Uint8Array(m),v=new Uint8Array(m),y=new Uint8Array(m),b={},x=null,_=null,w=null,S=null,A=null,M=null,P=null,E=null,T=null,C=!1,I=null,R=null,L=null,O=null,D=null,N=t.getParameter(t.MAX_COMBINED_TEXTURE_IMAGE_UNITS),k=parseFloat(/^WebGL\ ([0-9])/.exec(t.getParameter(t.VERSION))[1]),B=parseFloat(k)>=1,F=null,z={},U=new d,j=new d,V={};return V[t.TEXTURE_2D]=r(t.TEXTURE_2D,t.TEXTURE_2D,1),V[t.TEXTURE_CUBE_MAP]=r(t.TEXTURE_CUBE_MAP,t.TEXTURE_CUBE_MAP_POSITIVE_X,6),h.setClear(0,0,0,1),p.setClear(1),f.setClear(0),n(t.DEPTH_TEST),p.setFunc(sh),s(!1),c(Ml),n(t.CULL_FACE),n(t.BLEND),a(Bl),{buffers:{color:h,depth:p,stencil:f},initAttributes:function(){for(var t=0,e=g.length;t<e;t++)g[t]=0},enableAttribute:function(i){g[i]=1,0===v[i]&&(t.enableVertexAttribArray(i),v[i]=1),0!==y[i]&&(e.get("ANGLE_instanced_arrays").vertexAttribDivisorANGLE(i,0),y[i]=0)},enableAttributeAndDivisor:function(i,r){g[i]=1,0===v[i]&&(t.enableVertexAttribArray(i),v[i]=1),y[i]!==r&&(e.get("ANGLE_instanced_arrays").vertexAttribDivisorANGLE(i,r),y[i]=r)},disableUnusedAttributes:function(){for(var e=0,i=v.length;e!==i;++e)v[e]!==g[e]&&(t.disableVertexAttribArray(e),v[e]=0)},enable:n,disable:o,getCompressedTextureFormats:function(){if(null===x&&(x=[],e.get("WEBGL_compressed_texture_pvrtc")||e.get("WEBGL_compressed_texture_s3tc")||e.get("WEBGL_compressed_texture_etc1")))for(var i=t.getParameter(t.COMPRESSED_TEXTURE_FORMATS),r=0;r<i.length;r++)x.push(i[r]);return x},useProgram:function(e){return _!==e&&(t.useProgram(e),_=e,!0)},setBlending:a,setMaterial:function(e){e.side===Ll?o(t.CULL_FACE):n(t.CULL_FACE),s(e.side===Rl),!0===e.transparent?a(e.blending,e.blendEquation,e.blendSrc,e.blendDst,e.blendEquationAlpha,e.blendSrcAlpha,e.blendDstAlpha,e.premultipliedAlpha):a(kl),p.setFunc(e.depthFunc),p.setTest(e.depthTest),p.setMask(e.depthWrite),h.setMask(e.colorWrite),u(e.polygonOffset,e.polygonOffsetFactor,e.polygonOffsetUnits)},setFlipSided:s,setCullFace:c,setLineWidth:function(e){e!==L&&(B&&t.lineWidth(e),L=e)},setPolygonOffset:u,setScissorTest:function(e){e?n(t.SCISSOR_TEST):o(t.SCISSOR_TEST)},activeTexture:l,bindTexture:function(e,i){null===F&&l();var r=z[F];void 0===r&&(r={type:void 0,texture:void 0},z[F]=r),r.type===e&&r.texture===i||(t.bindTexture(e,i||V[e]),r.type=e,r.texture=i)},compressedTexImage2D:function(){try{t.compressedTexImage2D.apply(t,arguments)}catch(t){console.error("THREE.WebGLState:",t)}},texImage2D:function(){try{t.texImage2D.apply(t,arguments)}catch(t){console.error("THREE.WebGLState:",t)}},scissor:function(e){!1===U.equals(e)&&(t.scissor(e.x,e.y,e.z,e.w),U.copy(e))},viewport:function(e){!1===j.equals(e)&&(t.viewport(e.x,e.y,e.z,e.w),j.copy(e))},reset:function(){for(var e=0;e<v.length;e++)1===v[e]&&(t.disableVertexAttribArray(e),v[e]=0);b={},x=null,F=null,z={},_=null,w=null,I=null,R=null,h.reset(),p.reset(),f.reset()}}}function Me(t,e,i){function r(e){if("highp"===e){if(t.getShaderPrecisionFormat(t.VERTEX_SHADER,t.HIGH_FLOAT).precision>0&&t.getShaderPrecisionFormat(t.FRAGMENT_SHADER,t.HIGH_FLOAT).precision>0)return"highp";e="mediump"}return"mediump"===e&&t.getShaderPrecisionFormat(t.VERTEX_SHADER,t.MEDIUM_FLOAT).precision>0&&t.getShaderPrecisionFormat(t.FRAGMENT_SHADER,t.MEDIUM_FLOAT).precision>0?"mediump":"lowp"}var n,o=void 0!==i.precision?i.precision:"highp",a=r(o);a!==o&&(console.warn("THREE.WebGLRenderer:",o,"not supported, using",a,"instead."),o=a);var s=!0===i.logarithmicDepthBuffer&&!!e.get("EXT_frag_depth"),c=t.getParameter(t.MAX_TEXTURE_IMAGE_UNITS),u=t.getParameter(t.MAX_VERTEX_TEXTURE_IMAGE_UNITS),l=t.getParameter(t.MAX_TEXTURE_SIZE),h=t.getParameter(t.MAX_CUBE_MAP_TEXTURE_SIZE),p=t.getParameter(t.MAX_VERTEX_ATTRIBS),d=t.getParameter(t.MAX_VERTEX_UNIFORM_VECTORS),f=t.getParameter(t.MAX_VARYING_VECTORS),m=t.getParameter(t.MAX_FRAGMENT_UNIFORM_VECTORS),g=u>0,v=!!e.get("OES_texture_float");return{getMaxAnisotropy:function(){if(void 0!==n)return n;var i=e.get("EXT_texture_filter_anisotropic");return n=null!==i?t.getParameter(i.MAX_TEXTURE_MAX_ANISOTROPY_EXT):0},getMaxPrecision:r,precision:o,logarithmicDepthBuffer:s,maxTextures:c,maxVertexTextures:u,maxTextureSize:l,maxCubemapSize:h,maxAttributes:p,maxVertexUniforms:d,maxVaryings:f,maxFragmentUniforms:m,vertexTextures:g,floatFragmentTextures:v,floatVertexTextures:g&&v}}function Pe(t){wt.call(this),this.cameras=t||[]}function Ee(t){function e(){if(null!==r&&r.isPresenting){var e=r.getEyeParameters("left"),n=e.renderWidth,o=e.renderHeight;p=t.getPixelRatio(),h=t.getSize(),t.setDrawingBufferSize(2*n,o,1)}else i.enabled&&t.setDrawingBufferSize(h.width,h.height,p)}var i=this,r=null,n=null;"VRFrameData"in window&&(n=new window.VRFrameData);var o=new y,a=new y,s=new y,c=new wt;c.bounds=new d(0,0,.5,1),c.layers.enable(1);var u=new wt;u.bounds=new d(.5,0,.5,1),u.layers.enable(2);var l=new Pe([c,u]);l.layers.enable(1),l.layers.enable(2);var h,p;window.addEventListener("vrdisplaypresentchange",e,!1),this.enabled=!1,this.standing=!1,this.getDevice=function(){return r},this.setDevice=function(t){void 0!==t&&(r=t)},this.getCamera=function(t){if(null===r)return t;r.depthNear=t.near,r.depthFar=t.far,r.getFrameData(n);var e=n.pose;null!==e.position?t.position.fromArray(e.position):t.position.set(0,0,0),null!==e.orientation&&t.quaternion.fromArray(e.orientation),t.updateMatrixWorld();var i=r.stageParameters;if(this.standing&&i&&(a.fromArray(i.sittingToStandingTransform),s.getInverse(a),t.matrixWorld.multiply(a),t.matrixWorldInverse.multiply(s)),!1===r.isPresenting)return t;c.near=t.near,u.near=t.near,c.far=t.far,u.far=t.far,l.matrixWorld.copy(t.matrixWorld),l.matrixWorldInverse.copy(t.matrixWorldInverse),c.matrixWorldInverse.fromArray(n.leftViewMatrix),u.matrixWorldInverse.fromArray(n.rightViewMatrix),this.standing&&i&&(c.matrixWorldInverse.multiply(s),u.matrixWorldInverse.multiply(s));var h=t.parent;null!==h&&(o.getInverse(h.matrixWorld),c.matrixWorldInverse.multiply(o),u.matrixWorldInverse.multiply(o)),c.matrixWorld.getInverse(c.matrixWorldInverse),u.matrixWorld.getInverse(u.matrixWorldInverse),c.projectionMatrix.fromArray(n.leftProjectionMatrix),u.projectionMatrix.fromArray(n.rightProjectionMatrix),l.projectionMatrix.copy(c.projectionMatrix);var p=r.getLayers();if(p.length){var d=p[0];null!==d.leftBounds&&4===d.leftBounds.length&&c.bounds.fromArray(d.leftBounds),null!==d.rightBounds&&4===d.rightBounds.length&&u.bounds.fromArray(d.rightBounds)}return l},this.getStandingMatrix=function(){return a},this.submitFrame=function(){r&&r.isPresenting&&r.submitFrame()},this.dispose=function(){window.removeEventListener("vrdisplaypresentchange",e)}}function Te(t){var e={};return{get:function(i){if(void 0!==e[i])return e[i];var r;switch(i){case"WEBGL_depth_texture":r=t.getExtension("WEBGL_depth_texture")||t.getExtension("MOZ_WEBGL_depth_texture")||t.getExtension("WEBKIT_WEBGL_depth_texture");break;case"EXT_texture_filter_anisotropic":r=t.getExtension("EXT_texture_filter_anisotropic")||t.getExtension("MOZ_EXT_texture_filter_anisotropic")||t.getExtension("WEBKIT_EXT_texture_filter_anisotropic");break;case"WEBGL_compressed_texture_s3tc":r=t.getExtension("WEBGL_compressed_texture_s3tc")||t.getExtension("MOZ_WEBGL_compressed_texture_s3tc")||t.getExtension("WEBKIT_WEBGL_compressed_texture_s3tc");break;case"WEBGL_compressed_texture_pvrtc":r=t.getExtension("WEBGL_compressed_texture_pvrtc")||t.getExtension("WEBKIT_WEBGL_compressed_texture_pvrtc");break;case"WEBGL_compressed_texture_etc1":r=t.getExtension("WEBGL_compressed_texture_etc1");break;default:r=t.getExtension(i)}return null===r&&console.warn("THREE.WebGLRenderer: "+i+" extension not supported."),e[i]=r,r}}}function Ce(){function t(){u.value!==r&&(u.value=r,u.needsUpdate=n>0),i.numPlanes=n,i.numIntersection=0}function e(t,e,r,n){var o=null!==t?t.length:0,a=null;if(0!==o){if(a=u.value,!0!==n||null===a){var l=r+4*o,h=e.matrixWorldInverse;c.getNormalMatrix(h),(null===a||a.length<l)&&(a=new Float32Array(l));for(var p=0,d=r;p!==o;++p,d+=4)s.copy(t[p]).applyMatrix4(h,c),s.normal.toArray(a,d),a[d+3]=s.constant}u.value=a,u.needsUpdate=!0}return i.numPlanes=o,a}var i=this,r=null,n=0,o=!1,a=!1,s=new dt,c=new pt,u={value:null,needsUpdate:!1};this.uniform=u,this.numPlanes=0,this.numIntersection=0,this.init=function(t,i,a){var s=0!==t.length||i||0!==n||o;return o=i,r=e(t,a,0),n=t.length,s},this.beginShadows=function(){a=!0,e(null)},this.endShadows=function(){a=!1,t()},this.setState=function(i,s,c,l,h,p){if(!o||null===i||0===i.length||a&&!c)a?e(null):t();else{var d=a?0:n,f=4*d,m=h.clippingState||null;u.value=m,m=e(i,l,f,p);for(var g=0;g!==f;++g)m[g]=r[g];h.clippingState=m,this.numIntersection=s?this.numPlanes:0,this.numPlanes+=d}}}function Ie(t,e){return{convert:function(i){var r;if(i===Eh)return t.REPEAT;if(i===Th)return t.CLAMP_TO_EDGE;if(i===Ch)return t.MIRRORED_REPEAT;if(i===Ih)return t.NEAREST;if(i===Rh)return t.NEAREST_MIPMAP_NEAREST;if(i===Lh)return t.NEAREST_MIPMAP_LINEAR;if(i===Oh)return t.LINEAR;if(i===Dh)return t.LINEAR_MIPMAP_NEAREST;if(i===Nh)return t.LINEAR_MIPMAP_LINEAR;if(i===kh)return t.UNSIGNED_BYTE;if(i===$h)return t.UNSIGNED_SHORT_4_4_4_4;if(i===Hh)return t.UNSIGNED_SHORT_5_5_5_1;if(i===Wh)return t.UNSIGNED_SHORT_5_6_5;if(i===Bh)return t.BYTE;if(i===Fh)return t.SHORT;if(i===zh)return t.UNSIGNED_SHORT;if(i===Uh)return t.INT;if(i===jh)return t.UNSIGNED_INT;if(i===Vh)return t.FLOAT;if(i===Gh&&null!==(r=e.get("OES_texture_half_float")))return r.HALF_FLOAT_OES;if(i===qh)return t.ALPHA;if(i===Yh)return t.RGB;if(i===Zh)return t.RGBA;if(i===Kh)return t.LUMINANCE;if(i===Qh)return t.LUMINANCE_ALPHA;if(i===Jh)return t.DEPTH_COMPONENT;if(i===tp)return t.DEPTH_STENCIL;if(i===Vl)return t.FUNC_ADD;if(i===Gl)return t.FUNC_SUBTRACT;if(i===$l)return t.FUNC_REVERSE_SUBTRACT;if(i===Xl)return t.ZERO;if(i===ql)return t.ONE;if(i===Yl)return t.SRC_COLOR;if(i===Zl)return t.ONE_MINUS_SRC_COLOR;if(i===Kl)return t.SRC_ALPHA;if(i===Ql)return t.ONE_MINUS_SRC_ALPHA;if(i===Jl)return t.DST_ALPHA;if(i===th)return t.ONE_MINUS_DST_ALPHA;if(i===eh)return t.DST_COLOR;if(i===ih)return t.ONE_MINUS_DST_COLOR;if(i===rh)return t.SRC_ALPHA_SATURATE;if((i===ep||i===ip||i===rp||i===np)&&null!==(r=e.get("WEBGL_compressed_texture_s3tc"))){if(i===ep)return r.COMPRESSED_RGB_S3TC_DXT1_EXT;if(i===ip)return r.COMPRESSED_RGBA_S3TC_DXT1_EXT;if(i===rp)return r.COMPRESSED_RGBA_S3TC_DXT3_EXT;if(i===np)return r.COMPRESSED_RGBA_S3TC_DXT5_EXT}if((i===op||i===ap||i===sp||i===cp)&&null!==(r=e.get("WEBGL_compressed_texture_pvrtc"))){if(i===op)return r.COMPRESSED_RGB_PVRTC_4BPPV1_IMG;if(i===ap)return r.COMPRESSED_RGB_PVRTC_2BPPV1_IMG;if(i===sp)return r.COMPRESSED_RGBA_PVRTC_4BPPV1_IMG;if(i===cp)return r.COMPRESSED_RGBA_PVRTC_2BPPV1_IMG}if(i===up&&null!==(r=e.get("WEBGL_compressed_texture_etc1")))return r.COMPRESSED_RGB_ETC1_WEBGL;if((i===Hl||i===Wl)&&null!==(r=e.get("EXT_blend_minmax"))){if(i===Hl)return r.MIN_EXT;if(i===Wl)return r.MAX_EXT}return i===Xh&&null!==(r=e.get("WEBGL_depth_texture"))?r.UNSIGNED_INT_24_8_WEBGL:0}}}function Re(t){function e(){return null===Z?ht:1}function i(){(Tt=new Te(Pt)).get("WEBGL_depth_texture"),Tt.get("OES_texture_float"),Tt.get("OES_texture_float_linear"),Tt.get("OES_texture_half_float"),Tt.get("OES_texture_half_float_linear"),Tt.get("OES_standard_derivatives"),Tt.get("ANGLE_instanced_arrays"),Tt.get("OES_element_index_uint")&&(Ft.MaxIndex=4294967296),Wt=new Ie(Pt,Tt),Ct=new Me(Pt,Tt,t),(It=new Ae(Pt,Tt,Wt)).scissor(at.copy(dt).multiplyScalar(ht)),It.viewport(nt.copy(pt).multiplyScalar(ht)),Rt=new Se,Lt=new we(Pt,Tt,It,Rt,Ct,Wt,At),Ot=new gt(Pt),Dt=new re(Pt,Ot,At),Nt=new ae(Dt,Mt),jt=new te(Pt),Bt=new _e(q,Tt,Ct),kt=new oe,zt=new Qt,Ut=new qt(q,It,Dt,j),Vt=new ie(Pt,Tt,Mt),Gt=new ee(Pt,Tt,Mt),$t=new rt(q,Pt,It,Lt,Ct),Ht=new ot(q,Pt,It,Lt,Ct),q.info.programs=Bt.programs,q.context=Pt,q.capabilities=Ct,q.extensions=Tt,q.properties=Rt,q.renderLists=zt,q.state=It}function r(t){t.preventDefault(),console.log("THREE.WebGLRenderer: Context Lost."),Y=!0}function n(t){console.log("THREE.WebGLRenderer: Context Restored."),Y=!1,i()}function o(t){var e=t.target;e.removeEventListener("dispose",o),a(e)}function a(t){s(t),Rt.remove(t)}function s(t){var e=Rt.get(t).program;t.program=void 0,void 0!==e&&Bt.releaseProgram(e)}function c(t,e,i){t.render(function(t){q.renderBufferImmediate(t,e,i)})}function u(t,e,i,r){if(i&&i.isInstancedBufferGeometry&&null===Tt.get("ANGLE_instanced_arrays"))console.error("THREE.WebGLRenderer.setupVertexAttributes: using THREE.InstancedBufferGeometry but hardware does not support extension ANGLE_instanced_arrays.");else{void 0===r&&(r=0),It.initAttributes();var n=i.attributes,o=e.getAttributes(),a=t.defaultAttributeValues;for(var s in o){var c=o[s];if(c>=0){var u=n[s];if(void 0!==u){var l=u.normalized,h=u.itemSize,p=Ot.get(u);if(void 0===p)continue;var d=p.buffer,f=p.type,m=p.bytesPerElement;if(u.isInterleavedBufferAttribute){var g=u.data,v=g.stride,y=u.offset;g&&g.isInstancedInterleavedBuffer?(It.enableAttributeAndDivisor(c,g.meshPerAttribute),void 0===i.maxInstancedCount&&(i.maxInstancedCount=g.meshPerAttribute*g.count)):It.enableAttribute(c),Pt.bindBuffer(Pt.ARRAY_BUFFER,d),Pt.vertexAttribPointer(c,h,f,l,v*m,(r*v+y)*m)}else u.isInstancedBufferAttribute?(It.enableAttributeAndDivisor(c,u.meshPerAttribute),void 0===i.maxInstancedCount&&(i.maxInstancedCount=u.meshPerAttribute*u.count)):It.enableAttribute(c),Pt.bindBuffer(Pt.ARRAY_BUFFER,d),Pt.vertexAttribPointer(c,h,f,l,0,r*h*m)}else if(void 0!==a){var b=a[s];if(void 0!==b)switch(b.length){case 2:Pt.vertexAttrib2fv(c,b);break;case 3:Pt.vertexAttrib3fv(c,b);break;case 4:Pt.vertexAttrib4fv(c,b);break;default:Pt.vertexAttrib1fv(c,b)}}}}It.disableUnusedAttributes()}}function l(){Zt||((Xt.getDevice()||window).requestAnimationFrame(h),Zt=!0)}function h(t){null!==Kt&&Kt(t),(Xt.getDevice()||window).requestAnimationFrame(h)}function p(t,e,i){if(t.visible){if(t.layers.test(e.layers))if(t.isLight)G.push(t),t.castShadow&&$.push(t);else if(t.isSprite)t.frustumCulled&&!yt.intersectsSprite(t)||W.push(t);else if(t.isLensFlare)X.push(t);else if(t.isImmediateRenderObject)i&&St.setFromMatrixPosition(t.matrixWorld).applyMatrix4(wt),H.push(t,null,t.material,St.z,null);else if((t.isMesh||t.isLine||t.isPoints)&&(t.isSkinnedMesh&&t.skeleton.update(),!t.frustumCulled||yt.intersectsObject(t))){i&&St.setFromMatrixPosition(t.matrixWorld).applyMatrix4(wt);var r=Nt.update(t),n=t.material;if(Array.isArray(n))for(var o=r.groups,a=0,s=o.length;a<s;a++){var c=o[a],u=n[c.materialIndex];u&&u.visible&&H.push(t,r,u,St.z,c)}else n.visible&&H.push(t,r,n,St.z,null)}for(var l=t.children,a=0,s=l.length;a<s;a++)p(l[a],e,i)}}function f(t,e,i,r){for(var n=0,o=t.length;n<o;n++){var a=t[n],s=a.object,c=a.geometry,u=void 0===r?a.material:r,l=a.group;if(i.isArrayCamera){it=i;for(var h=i.cameras,p=0,d=h.length;p<d;p++){var f=h[p];if(s.layers.test(f.layers)){var g=f.bounds,v=g.x*ut,y=g.y*lt,b=g.z*ut,x=g.w*lt;It.viewport(nt.set(v,y,b,x).multiplyScalar(ht)),m(s,e,f,c,u,l)}}}else it=null,m(s,e,i,c,u,l)}}function m(t,e,i,r,n,o){if(t.onBeforeRender(q,e,i,r,n,o),t.modelViewMatrix.multiplyMatrices(i.matrixWorldInverse,t.matrixWorld),t.normalMatrix.getNormalMatrix(t.modelViewMatrix),t.isImmediateRenderObject){It.setMaterial(n);var a=x(i,e.fog,n,t);J="",c(t,a,n)}else q.renderBufferDirect(i,e.fog,r,n,t,o);t.onAfterRender(q,e,i,r,n,o)}function g(t,e,i){var r=Rt.get(t),n=Bt.getParameters(t,kt.state,$,e,bt.numPlanes,bt.numIntersection,i),a=Bt.getProgramCode(t,n),c=r.program,u=!0;if(void 0===c)t.addEventListener("dispose",o);else if(c.code!==a)s(t);else{if(void 0!==n.shaderID)return;u=!1}if(u){if(n.shaderID){var l=Bp[n.shaderID];r.shader={name:t.type,uniforms:Np.clone(l.uniforms),vertexShader:l.vertexShader,fragmentShader:l.fragmentShader}}else r.shader={name:t.type,uniforms:t.uniforms,vertexShader:t.vertexShader,fragmentShader:t.fragmentShader};t.onBeforeCompile(r.shader),c=Bt.acquireProgram(t,r.shader,n,a),r.program=c,t.program=c}var h=c.getAttributes();if(t.morphTargets){t.numSupportedMorphTargets=0;for(p=0;p<q.maxMorphTargets;p++)h["morphTarget"+p]>=0&&t.numSupportedMorphTargets++}if(t.morphNormals){t.numSupportedMorphNormals=0;for(var p=0;p<q.maxMorphNormals;p++)h["morphNormal"+p]>=0&&t.numSupportedMorphNormals++}var d=r.shader.uniforms;(t.isShaderMaterial||t.isRawShaderMaterial)&&!0!==t.clipping||(r.numClippingPlanes=bt.numPlanes,r.numIntersection=bt.numIntersection,d.clippingPlanes=bt.uniform),r.fog=e,r.lightsHash=kt.state.hash,t.lights&&(d.ambientLightColor.value=kt.state.ambient,d.directionalLights.value=kt.state.directional,d.spotLights.value=kt.state.spot,d.rectAreaLights.value=kt.state.rectArea,d.pointLights.value=kt.state.point,d.hemisphereLights.value=kt.state.hemi,d.directionalShadowMap.value=kt.state.directionalShadowMap,d.directionalShadowMatrix.value=kt.state.directionalShadowMatrix,d.spotShadowMap.value=kt.state.spotShadowMap,d.spotShadowMatrix.value=kt.state.spotShadowMatrix,d.pointShadowMap.value=kt.state.pointShadowMap,d.pointShadowMatrix.value=kt.state.pointShadowMatrix);var f=r.program.getUniforms(),m=tt.seqWithValue(f.seq,d);r.uniformsList=m}function x(t,e,i,r){ct=0;var n=Rt.get(i);if(xt&&(_t||t!==et)){var o=t===et&&i.id===Q;bt.setState(i.clippingPlanes,i.clipIntersection,i.clipShadows,t,n,o)}!1===i.needsUpdate&&(void 0===n.program?i.needsUpdate=!0:i.fog&&n.fog!==e?i.needsUpdate=!0:i.lights&&n.lightsHash!==kt.state.hash?i.needsUpdate=!0:void 0===n.numClippingPlanes||n.numClippingPlanes===bt.numPlanes&&n.numIntersection===bt.numIntersection||(i.needsUpdate=!0)),i.needsUpdate&&(g(i,e,r),i.needsUpdate=!1);var a=!1,s=!1,c=!1,u=n.program,l=u.getUniforms(),h=n.shader.uniforms;if(It.useProgram(u.program)&&(a=!0,s=!0,c=!0),i.id!==Q&&(Q=i.id,s=!0),a||t!==et){if(l.setValue(Pt,"projectionMatrix",t.projectionMatrix),Ct.logarithmicDepthBuffer&&l.setValue(Pt,"logDepthBufFC",2/(Math.log(t.far+1)/Math.LN2)),et!==(it||t)&&(et=it||t,s=!0,c=!0),i.isShaderMaterial||i.isMeshPhongMaterial||i.isMeshStandardMaterial||i.envMap){var p=l.map.cameraPosition;void 0!==p&&p.setValue(Pt,St.setFromMatrixPosition(t.matrixWorld))}(i.isMeshPhongMaterial||i.isMeshLambertMaterial||i.isMeshBasicMaterial||i.isMeshStandardMaterial||i.isShaderMaterial||i.skinning)&&l.setValue(Pt,"viewMatrix",t.matrixWorldInverse)}if(i.skinning){l.setOptional(Pt,r,"bindMatrix"),l.setOptional(Pt,r,"bindMatrixInverse");var d=r.skeleton;if(d){var f=d.bones;if(Ct.floatVertexTextures){if(void 0===d.boneTexture){var m=Math.sqrt(4*f.length);m=Ap.nextPowerOfTwo(Math.ceil(m)),m=Math.max(m,4);var v=new Float32Array(m*m*4);v.set(d.boneMatrices);var y=new b(v,m,m,Zh,Vh);d.boneMatrices=v,d.boneTexture=y,d.boneTextureSize=m}l.setValue(Pt,"boneTexture",d.boneTexture),l.setValue(Pt,"boneTextureSize",d.boneTextureSize)}else l.setOptional(Pt,d,"boneMatrices")}}return s&&(l.setValue(Pt,"toneMappingExposure",q.toneMappingExposure),l.setValue(Pt,"toneMappingWhitePoint",q.toneMappingWhitePoint),i.lights&&D(h,c),e&&i.fog&&M(h,e),i.isMeshBasicMaterial?_(h,i):i.isMeshLambertMaterial?(_(h,i),P(h,i)):i.isMeshPhongMaterial?(_(h,i),i.isMeshToonMaterial?T(h,i):E(h,i)):i.isMeshStandardMaterial?(_(h,i),i.isMeshPhysicalMaterial?I(h,i):C(h,i)):i.isMeshDepthMaterial?(_(h,i),R(h,i)):i.isMeshDistanceMaterial?(_(h,i),L(h,i)):i.isMeshNormalMaterial?(_(h,i),O(h,i)):i.isLineBasicMaterial?(w(h,i),i.isLineDashedMaterial&&S(h,i)):i.isPointsMaterial?A(h,i):i.isShadowMaterial&&(h.color.value=i.color,h.opacity.value=i.opacity),void 0!==h.ltcMat&&(h.ltcMat.value=Dp.LTC_MAT_TEXTURE),void 0!==h.ltcMag&&(h.ltcMag.value=Dp.LTC_MAG_TEXTURE),tt.upload(Pt,n.uniformsList,h,q)),l.setValue(Pt,"modelViewMatrix",r.modelViewMatrix),l.setValue(Pt,"normalMatrix",r.normalMatrix),l.setValue(Pt,"modelMatrix",r.matrixWorld),u}function _(t,e){t.opacity.value=e.opacity,e.color&&(t.diffuse.value=e.color),e.emissive&&t.emissive.value.copy(e.emissive).multiplyScalar(e.emissiveIntensity),e.map&&(t.map.value=e.map),e.alphaMap&&(t.alphaMap.value=e.alphaMap),e.specularMap&&(t.specularMap.value=e.specularMap),e.envMap&&(t.envMap.value=e.envMap,t.flipEnvMap.value=e.envMap&&e.envMap.isCubeTexture?-1:1,t.reflectivity.value=e.reflectivity,t.refractionRatio.value=e.refractionRatio),e.lightMap&&(t.lightMap.value=e.lightMap,t.lightMapIntensity.value=e.lightMapIntensity),e.aoMap&&(t.aoMap.value=e.aoMap,t.aoMapIntensity.value=e.aoMapIntensity);var i;if(e.map?i=e.map:e.specularMap?i=e.specularMap:e.displacementMap?i=e.displacementMap:e.normalMap?i=e.normalMap:e.bumpMap?i=e.bumpMap:e.roughnessMap?i=e.roughnessMap:e.metalnessMap?i=e.metalnessMap:e.alphaMap?i=e.alphaMap:e.emissiveMap&&(i=e.emissiveMap),void 0!==i){i.isWebGLRenderTarget&&(i=i.texture);var r=i.offset,n=i.repeat;t.offsetRepeat.value.set(r.x,r.y,n.x,n.y)}}function w(t,e){t.diffuse.value=e.color,t.opacity.value=e.opacity}function S(t,e){t.dashSize.value=e.dashSize,t.totalSize.value=e.dashSize+e.gapSize,t.scale.value=e.scale}function A(t,e){if(t.diffuse.value=e.color,t.opacity.value=e.opacity,t.size.value=e.size*ht,t.scale.value=.5*lt,t.map.value=e.map,null!==e.map){var i=e.map.offset,r=e.map.repeat;t.offsetRepeat.value.set(i.x,i.y,r.x,r.y)}}function M(t,e){t.fogColor.value=e.color,e.isFog?(t.fogNear.value=e.near,t.fogFar.value=e.far):e.isFogExp2&&(t.fogDensity.value=e.density)}function P(t,e){e.emissiveMap&&(t.emissiveMap.value=e.emissiveMap)}function E(t,e){t.specular.value=e.specular,t.shininess.value=Math.max(e.shininess,1e-4),e.emissiveMap&&(t.emissiveMap.value=e.emissiveMap),e.bumpMap&&(t.bumpMap.value=e.bumpMap,t.bumpScale.value=e.bumpScale),e.normalMap&&(t.normalMap.value=e.normalMap,t.normalScale.value.copy(e.normalScale)),e.displacementMap&&(t.displacementMap.value=e.displacementMap,t.displacementScale.value=e.displacementScale,t.displacementBias.value=e.displacementBias)}function T(t,e){E(t,e),e.gradientMap&&(t.gradientMap.value=e.gradientMap)}function C(t,e){t.roughness.value=e.roughness,t.metalness.value=e.metalness,e.roughnessMap&&(t.roughnessMap.value=e.roughnessMap),e.metalnessMap&&(t.metalnessMap.value=e.metalnessMap),e.emissiveMap&&(t.emissiveMap.value=e.emissiveMap),e.bumpMap&&(t.bumpMap.value=e.bumpMap,t.bumpScale.value=e.bumpScale),e.normalMap&&(t.normalMap.value=e.normalMap,t.normalScale.value.copy(e.normalScale)),e.displacementMap&&(t.displacementMap.value=e.displacementMap,t.displacementScale.value=e.displacementScale,t.displacementBias.value=e.displacementBias),e.envMap&&(t.envMapIntensity.value=e.envMapIntensity)}function I(t,e){t.clearCoat.value=e.clearCoat,t.clearCoatRoughness.value=e.clearCoatRoughness,C(t,e)}function R(t,e){e.displacementMap&&(t.displacementMap.value=e.displacementMap,t.displacementScale.value=e.displacementScale,t.displacementBias.value=e.displacementBias)}function L(t,e){e.displacementMap&&(t.displacementMap.value=e.displacementMap,t.displacementScale.value=e.displacementScale,t.displacementBias.value=e.displacementBias),t.referencePosition.value.copy(e.referencePosition),t.nearDistance.value=e.nearDistance,t.farDistance.value=e.farDistance}function O(t,e){e.bumpMap&&(t.bumpMap.value=e.bumpMap,t.bumpScale.value=e.bumpScale),e.normalMap&&(t.normalMap.value=e.normalMap,t.normalScale.value.copy(e.normalScale)),e.displacementMap&&(t.displacementMap.value=e.displacementMap,t.displacementScale.value=e.displacementScale,t.displacementBias.value=e.displacementBias)}function D(t,e){t.ambientLightColor.needsUpdate=e,t.directionalLights.needsUpdate=e,t.pointLights.needsUpdate=e,t.spotLights.needsUpdate=e,t.rectAreaLights.needsUpdate=e,t.hemisphereLights.needsUpdate=e}console.log("THREE.WebGLRenderer",Sl);var N=void 0!==(t=t||{}).canvas?t.canvas:document.createElementNS("http://www.w3.org/1999/xhtml","canvas"),k=void 0!==t.context?t.context:null,B=void 0!==t.alpha&&t.alpha,F=void 0===t.depth||t.depth,z=void 0===t.stencil||t.stencil,U=void 0!==t.antialias&&t.antialias,j=void 0===t.premultipliedAlpha||t.premultipliedAlpha,V=void 0!==t.preserveDrawingBuffer&&t.preserveDrawingBuffer,G=[],$=[],H=null,W=[],X=[];this.domElement=N,this.context=null,this.autoClear=!0,this.autoClearColor=!0,this.autoClearDepth=!0,this.autoClearStencil=!0,this.sortObjects=!0,this.clippingPlanes=[],this.localClippingEnabled=!1,this.gammaFactor=2,this.gammaInput=!1,this.gammaOutput=!1,this.physicallyCorrectLights=!1,this.toneMapping=gh,this.toneMappingExposure=1,this.toneMappingWhitePoint=1,this.maxMorphTargets=8,this.maxMorphNormals=4;var q=this,Y=!1,Z=null,K=null,Q=-1,J="",et=null,it=null,nt=new d,at=new d,st=null,ct=0,ut=N.width,lt=N.height,ht=1,pt=new d(0,0,ut,lt),dt=new d(0,0,ut,lt),vt=!1,yt=new ft,bt=new Ce,xt=!1,_t=!1,wt=new y,St=new v,At={geometries:0,textures:0},Mt={frame:0,calls:0,vertices:0,faces:0,points:0};this.info={render:Mt,memory:At,programs:null};var Pt;try{var Et={alpha:B,depth:F,stencil:z,antialias:U,premultipliedAlpha:j,preserveDrawingBuffer:V};if(null===(Pt=k||N.getContext("webgl",Et)||N.getContext("experimental-webgl",Et)))throw null!==N.getContext("webgl")?"Error creating WebGL context with your selected attributes.":"Error creating WebGL context.";void 0===Pt.getShaderPrecisionFormat&&(Pt.getShaderPrecisionFormat=function(){return{rangeMin:1,rangeMax:1,precision:1}}),N.addEventListener("webglcontextlost",r,!1),N.addEventListener("webglcontextrestored",n,!1)}catch(t){console.error("THREE.WebGLRenderer: "+t)}var Tt,Ct,It,Rt,Lt,Ot,Dt,Nt,kt,Bt,zt,Ut,jt,Vt,Gt,$t,Ht,Wt;i();var Xt=new Ee(q);this.vr=Xt;var Yt=new mt(q,Nt,Ct.maxTextureSize);this.shadowMap=Yt,this.getContext=function(){return Pt},this.getContextAttributes=function(){return Pt.getContextAttributes()},this.forceContextLoss=function(){var t=Tt.get("WEBGL_lose_context");t&&t.loseContext()},this.forceContextRestore=function(){var t=Tt.get("WEBGL_lose_context");t&&t.restoreContext()},this.getPixelRatio=function(){return ht},this.setPixelRatio=function(t){void 0!==t&&(ht=t,this.setSize(ut,lt,!1))},this.getSize=function(){return{width:ut,height:lt}},this.setSize=function(t,e,i){var r=Xt.getDevice();r&&r.isPresenting?console.warn("THREE.WebGLRenderer: Can't change size while VR device is presenting."):(ut=t,lt=e,N.width=t*ht,N.height=e*ht,!1!==i&&(N.style.width=t+"px",N.style.height=e+"px"),this.setViewport(0,0,t,e))},this.getDrawingBufferSize=function(){return{width:ut*ht,height:lt*ht}},this.setDrawingBufferSize=function(t,e,i){ut=t,lt=e,ht=i,N.width=t*i,N.height=e*i,this.setViewport(0,0,t,e)},this.setViewport=function(t,e,i,r){pt.set(t,lt-e-r,i,r),It.viewport(nt.copy(pt).multiplyScalar(ht))},this.setScissor=function(t,e,i,r){dt.set(t,lt-e-r,i,r),It.scissor(at.copy(dt).multiplyScalar(ht))},this.setScissorTest=function(t){It.setScissorTest(vt=t)},this.getClearColor=Ut.getClearColor,this.setClearColor=Ut.setClearColor,this.getClearAlpha=Ut.getClearAlpha,this.setClearAlpha=Ut.setClearAlpha,this.clear=function(t,e,i){var r=0;(void 0===t||t)&&(r|=Pt.COLOR_BUFFER_BIT),(void 0===e||e)&&(r|=Pt.DEPTH_BUFFER_BIT),(void 0===i||i)&&(r|=Pt.STENCIL_BUFFER_BIT),Pt.clear(r)},this.clearColor=function(){this.clear(!0,!1,!1)},this.clearDepth=function(){this.clear(!1,!0,!1)},this.clearStencil=function(){this.clear(!1,!1,!0)},this.clearTarget=function(t,e,i,r){this.setRenderTarget(t),this.clear(e,i,r)},this.dispose=function(){N.removeEventListener("webglcontextlost",r,!1),N.removeEventListener("webglcontextrestored",n,!1),zt.dispose(),Xt.dispose()},this.renderBufferImmediate=function(t,e,i){It.initAttributes();var r=Rt.get(t);t.hasPositions&&!r.position&&(r.position=Pt.createBuffer()),t.hasNormals&&!r.normal&&(r.normal=Pt.createBuffer()),t.hasUvs&&!r.uv&&(r.uv=Pt.createBuffer()),t.hasColors&&!r.color&&(r.color=Pt.createBuffer());var n=e.getAttributes();if(t.hasPositions&&(Pt.bindBuffer(Pt.ARRAY_BUFFER,r.position),Pt.bufferData(Pt.ARRAY_BUFFER,t.positionArray,Pt.DYNAMIC_DRAW),It.enableAttribute(n.position),Pt.vertexAttribPointer(n.position,3,Pt.FLOAT,!1,0,0)),t.hasNormals){if(Pt.bindBuffer(Pt.ARRAY_BUFFER,r.normal),!i.isMeshPhongMaterial&&!i.isMeshStandardMaterial&&!i.isMeshNormalMaterial&&!0===i.flatShading)for(var o=0,a=3*t.count;o<a;o+=9){var s=t.normalArray,c=(s[o+0]+s[o+3]+s[o+6])/3,u=(s[o+1]+s[o+4]+s[o+7])/3,l=(s[o+2]+s[o+5]+s[o+8])/3;s[o+0]=c,s[o+1]=u,s[o+2]=l,s[o+3]=c,s[o+4]=u,s[o+5]=l,s[o+6]=c,s[o+7]=u,s[o+8]=l}Pt.bufferData(Pt.ARRAY_BUFFER,t.normalArray,Pt.DYNAMIC_DRAW),It.enableAttribute(n.normal),Pt.vertexAttribPointer(n.normal,3,Pt.FLOAT,!1,0,0)}t.hasUvs&&i.map&&(Pt.bindBuffer(Pt.ARRAY_BUFFER,r.uv),Pt.bufferData(Pt.ARRAY_BUFFER,t.uvArray,Pt.DYNAMIC_DRAW),It.enableAttribute(n.uv),Pt.vertexAttribPointer(n.uv,2,Pt.FLOAT,!1,0,0)),t.hasColors&&i.vertexColors!==Ol&&(Pt.bindBuffer(Pt.ARRAY_BUFFER,r.color),Pt.bufferData(Pt.ARRAY_BUFFER,t.colorArray,Pt.DYNAMIC_DRAW),It.enableAttribute(n.color),Pt.vertexAttribPointer(n.color,3,Pt.FLOAT,!1,0,0)),It.disableUnusedAttributes(),Pt.drawArrays(Pt.TRIANGLES,0,t.count),t.count=0},this.renderBufferDirect=function(t,i,r,n,o,a){It.setMaterial(n);var s=x(t,i,n,o),c=r.id+"_"+s.id+"_"+(!0===n.wireframe),l=!1;c!==J&&(J=c,l=!0),o.morphTargetInfluences&&(jt.update(o,r,n,s),l=!0);var h=r.index,p=r.attributes.position,d=1;!0===n.wireframe&&(h=Dt.getWireframeAttribute(r),d=2);var f,m=Vt;null!==h&&(f=Ot.get(h),(m=Gt).setIndex(f)),l&&(u(n,s,r),null!==h&&Pt.bindBuffer(Pt.ELEMENT_ARRAY_BUFFER,f.buffer));var g=0;null!==h?g=h.count:void 0!==p&&(g=p.count);var v=r.drawRange.start*d,y=r.drawRange.count*d,b=null!==a?a.start*d:0,_=null!==a?a.count*d:1/0,w=Math.max(v,b),S=Math.min(g,v+y,b+_)-1,A=Math.max(0,S-w+1);if(0!==A){if(o.isMesh)if(!0===n.wireframe)It.setLineWidth(n.wireframeLinewidth*e()),m.setMode(Pt.LINES);else switch(o.drawMode){case pp:m.setMode(Pt.TRIANGLES);break;case dp:m.setMode(Pt.TRIANGLE_STRIP);break;case fp:m.setMode(Pt.TRIANGLE_FAN)}else if(o.isLine){var M=n.linewidth;void 0===M&&(M=1),It.setLineWidth(M*e()),o.isLineSegments?m.setMode(Pt.LINES):o.isLineLoop?m.setMode(Pt.LINE_LOOP):m.setMode(Pt.LINE_STRIP)}else o.isPoints&&m.setMode(Pt.POINTS);r&&r.isInstancedBufferGeometry?r.maxInstancedCount>0&&m.renderInstances(r,w,A):m.render(w,A)}},this.compile=function(t,e){G.length=0,$.length=0,t.traverse(function(t){t.isLight&&(G.push(t),t.castShadow&&$.push(t))}),kt.setup(G,$,e),t.traverse(function(e){if(e.material)if(Array.isArray(e.material))for(var i=0;i<e.material.length;i++)g(e.material[i],t.fog,e);else g(e.material,t.fog,e)})};var Zt=!1,Kt=null;this.animate=function(t){Kt=t,l()},this.render=function(t,e,i,r){if(e&&e.isCamera){if(!Y){J="",Q=-1,et=null,!0===t.autoUpdate&&t.updateMatrixWorld(),null===e.parent&&e.updateMatrixWorld(),Xt.enabled&&(e=Xt.getCamera(e)),wt.multiplyMatrices(e.projectionMatrix,e.matrixWorldInverse),yt.setFromMatrix(wt),G.length=0,$.length=0,W.length=0,X.length=0,_t=this.localClippingEnabled,xt=bt.init(this.clippingPlanes,_t,e),(H=zt.get(t,e)).init(),p(t,e,q.sortObjects),!0===q.sortObjects&&H.sort(),xt&&bt.beginShadows(),Yt.render($,t,e),kt.setup(G,$,e),xt&&bt.endShadows(),Mt.frame++,Mt.calls=0,Mt.vertices=0,Mt.faces=0,Mt.points=0,void 0===i&&(i=null),this.setRenderTarget(i),Ut.render(H,t,e,r);var n=H.opaque,o=H.transparent;if(t.overrideMaterial){var a=t.overrideMaterial;n.length&&f(n,t,e,a),o.length&&f(o,t,e,a)}else n.length&&f(n,t,e),o.length&&f(o,t,e);Ht.render(W,t,e),$t.render(X,t,e,nt),i&&Lt.updateRenderTargetMipmap(i),It.buffers.depth.setTest(!0),It.buffers.depth.setMask(!0),It.buffers.color.setMask(!0),It.setPolygonOffset(!1),Xt.enabled&&Xt.submitFrame()}}else console.error("THREE.WebGLRenderer.render: camera is not an instance of THREE.Camera.")},this.setFaceCulling=function(t,e){It.setCullFace(t),It.setFlipSided(e===El)},this.allocTextureUnit=function(){var t=ct;return t>=Ct.maxTextures&&console.warn("THREE.WebGLRenderer: Trying to use "+t+" texture units while this GPU supports only "+Ct.maxTextures),ct+=1,t},this.setTexture2D=function(){var t=!1;return function(e,i){e&&e.isWebGLRenderTarget&&(t||(console.warn("THREE.WebGLRenderer.setTexture2D: don't use render targets as textures. Use their .texture property instead."),t=!0),e=e.texture),Lt.setTexture2D(e,i)}}(),this.setTexture=function(){var t=!1;return function(e,i){t||(console.warn("THREE.WebGLRenderer: .setTexture is deprecated, use setTexture2D instead."),t=!0),Lt.setTexture2D(e,i)}}(),this.setTextureCube=function(){var t=!1;return function(e,i){e&&e.isWebGLRenderTargetCube&&(t||(console.warn("THREE.WebGLRenderer.setTextureCube: don't use cube render targets as textures. Use their .texture property instead."),t=!0),e=e.texture),e&&e.isCubeTexture||Array.isArray(e.image)&&6===e.image.length?Lt.setTextureCube(e,i):Lt.setTextureCubeDynamic(e,i)}}(),this.getRenderTarget=function(){return Z},this.setRenderTarget=function(t){Z=t,t&&void 0===Rt.get(t).__webglFramebuffer&&Lt.setupRenderTarget(t);var e=null,i=!1;if(t){var r=Rt.get(t).__webglFramebuffer;t.isWebGLRenderTargetCube?(e=r[t.activeCubeFace],i=!0):e=r,nt.copy(t.viewport),at.copy(t.scissor),st=t.scissorTest}else nt.copy(pt).multiplyScalar(ht),at.copy(dt).multiplyScalar(ht),st=vt;if(K!==e&&(Pt.bindFramebuffer(Pt.FRAMEBUFFER,e),K=e),It.viewport(nt),It.scissor(at),It.setScissorTest(st),i){var n=Rt.get(t.texture);Pt.framebufferTexture2D(Pt.FRAMEBUFFER,Pt.COLOR_ATTACHMENT0,Pt.TEXTURE_CUBE_MAP_POSITIVE_X+t.activeCubeFace,n.__webglTexture,t.activeMipMapLevel)}},this.readRenderTargetPixels=function(t,e,i,r,n,o){if(t&&t.isWebGLRenderTarget){var a=Rt.get(t).__webglFramebuffer;if(a){var s=!1;a!==K&&(Pt.bindFramebuffer(Pt.FRAMEBUFFER,a),s=!0);try{var c=t.texture,u=c.format,l=c.type;if(u!==Zh&&Wt.convert(u)!==Pt.getParameter(Pt.IMPLEMENTATION_COLOR_READ_FORMAT))return void console.error("THREE.WebGLRenderer.readRenderTargetPixels: renderTarget is not in RGBA or implementation defined format.");if(!(l===kh||Wt.convert(l)===Pt.getParameter(Pt.IMPLEMENTATION_COLOR_READ_TYPE)||l===Vh&&(Tt.get("OES_texture_float")||Tt.get("WEBGL_color_buffer_float"))||l===Gh&&Tt.get("EXT_color_buffer_half_float")))return void console.error("THREE.WebGLRenderer.readRenderTargetPixels: renderTarget is not in UnsignedByteType or implementation defined type.");Pt.checkFramebufferStatus(Pt.FRAMEBUFFER)===Pt.FRAMEBUFFER_COMPLETE?e>=0&&e<=t.width-r&&i>=0&&i<=t.height-n&&Pt.readPixels(e,i,r,n,Wt.convert(u),Wt.convert(l),o):console.error("THREE.WebGLRenderer.readRenderTargetPixels: readPixels from renderTarget failed. Framebuffer not complete.")}finally{s&&Pt.bindFramebuffer(Pt.FRAMEBUFFER,K)}}}else console.error("THREE.WebGLRenderer.readRenderTargetPixels: renderTarget is not THREE.WebGLRenderTarget.")}}function Le(t,e){this.name="",this.color=new et(t),this.density=void 0!==e?e:25e-5}function Oe(t,e,i){this.name="",this.color=new et(t),this.near=void 0!==e?e:1,this.far=void 0!==i?i:1e3}function De(){bt.call(this),this.type="Scene",this.background=null,this.fog=null,this.overrideMaterial=null,this.autoUpdate=!0}function Ne(t,e,i,r,n){bt.call(this),this.lensFlares=[],this.positionScreen=new v,this.customUpdateCallback=void 0,void 0!==t&&this.add(t,e,i,r,n)}function ke(t){at.call(this),this.type="SpriteMaterial",this.color=new et(16777215),this.map=null,this.rotation=0,this.fog=!1,this.lights=!1,this.setValues(t)}function Be(t){bt.call(this),this.type="Sprite",this.material=void 0!==t?t:new ke}function Fe(){bt.call(this),this.type="LOD",Object.defineProperties(this,{levels:{enumerable:!0,value:[]}})}function ze(t,e){var i=this;if(t=t||[],this.bones=t.slice(0),this.boneMatrices=new Float32Array(16*this.bones.length),void 0===e)this.calculateInverses();else if(this.bones.length===e.length)this.boneInverses=e.slice(0);else{console.warn("THREE.Skeleton boneInverses is the wrong length."),this.boneInverses=[];for(var r=0,n=this.bones.length;r<n;r++)i.boneInverses.push(new y)}}function Ue(){bt.call(this),this.type="Bone"}function je(t,e){Xt.call(this,t,e),this.type="SkinnedMesh",this.bindMode="attached",this.bindMatrix=new y,this.bindMatrixInverse=new y;var i=new ze(this.initBones());this.bind(i,this.matrixWorld),this.normalizeSkinWeights()}function Ve(t){at.call(this),this.type="LineBasicMaterial",this.color=new et(16777215),this.linewidth=1,this.linecap="round",this.linejoin="round",this.lights=!1,this.setValues(t)}function Ge(t,e,i){if(1===i)return console.warn("THREE.Line: parameter THREE.LinePieces no longer supported. Created THREE.LineSegments instead."),new $e(t,e);bt.call(this),this.type="Line",this.geometry=void 0!==t?t:new Ft,this.material=void 0!==e?e:new Ve({color:16777215*Math.random()})}function $e(t,e){Ge.call(this,t,e),this.type="LineSegments"}function He(t,e){Ge.call(this,t,e),this.type="LineLoop"}function We(t){at.call(this),this.type="PointsMaterial",this.color=new et(16777215),this.map=null,this.size=1,this.sizeAttenuation=!0,this.lights=!1,this.setValues(t)}function Xe(t,e){bt.call(this),this.type="Points",this.geometry=void 0!==t?t:new Ft,this.material=void 0!==e?e:new We({color:16777215*Math.random()})}function qe(){bt.call(this),this.type="Group"}function Ye(t,e,i,r,n,o,a,s,c){function u(){requestAnimationFrame(u),t.readyState>=t.HAVE_CURRENT_DATA&&(l.needsUpdate=!0)}p.call(this,t,e,i,r,n,o,a,s,c),this.generateMipmaps=!1;var l=this;u()}function Ze(t,e,i,r,n,o,a,s,c,u,l,h){p.call(this,null,o,a,s,c,u,r,n,l,h),this.image={width:e,height:i},this.mipmaps=t,this.flipY=!1,this.generateMipmaps=!1}function Ke(t,e,i,r,n,o,a,s,c,u){if((u=void 0!==u?u:Jh)!==Jh&&u!==tp)throw new Error("DepthTexture format must be either THREE.DepthFormat or THREE.DepthStencilFormat");void 0===i&&u===Jh&&(i=zh),void 0===i&&u===tp&&(i=Xh),p.call(this,null,r,n,o,a,s,u,i,c),this.image={width:t,height:e},this.magFilter=void 0!==a?a:Ih,this.minFilter=void 0!==s?s:Ih,this.flipY=!1,this.generateMipmaps=!1}function Qe(t){Ft.call(this),this.type="WireframeGeometry";var e,i,r,n,o,a,s,c,u,l,h=[],p=[0,0],d={},f=["a","b","c"];if(t&&t.isGeometry){var m=t.faces;for(e=0,r=m.length;e<r;e++){var g=m[e];for(i=0;i<3;i++)s=g[f[i]],c=g[f[(i+1)%3]],p[0]=Math.min(s,c),p[1]=Math.max(s,c),void 0===d[u=p[0]+","+p[1]]&&(d[u]={index1:p[0],index2:p[1]})}for(u in d)a=d[u],l=t.vertices[a.index1],h.push(l.x,l.y,l.z),l=t.vertices[a.index2],h.push(l.x,l.y,l.z)}else if(t&&t.isBufferGeometry){var y,b,x,_,w,S,A;if(l=new v,null!==t.index){for(y=t.attributes.position,b=t.index,0===(x=t.groups).length&&(x=[{start:0,count:b.count,materialIndex:0}]),n=0,o=x.length;n<o;++n)for(e=w=(_=x[n]).start,r=w+_.count;e<r;e+=3)for(i=0;i<3;i++)s=b.getX(e+i),c=b.getX(e+(i+1)%3),p[0]=Math.min(s,c),p[1]=Math.max(s,c),void 0===d[u=p[0]+","+p[1]]&&(d[u]={index1:p[0],index2:p[1]});for(u in d)a=d[u],l.fromBufferAttribute(y,a.index1),h.push(l.x,l.y,l.z),l.fromBufferAttribute(y,a.index2),h.push(l.x,l.y,l.z)}else for(e=0,r=(y=t.attributes.position).count/3;e<r;e++)for(i=0;i<3;i++)S=3*e+i,l.fromBufferAttribute(y,S),h.push(l.x,l.y,l.z),A=3*e+(i+1)%3,l.fromBufferAttribute(y,A),h.push(l.x,l.y,l.z)}this.addAttribute("position",new Dt(h,3))}function Je(t,e,i){Mt.call(this),this.type="ParametricGeometry",this.parameters={func:t,slices:e,stacks:i},this.fromBufferGeometry(new ti(t,e,i)),this.mergeVertices()}function ti(t,e,i){Ft.call(this),this.type="ParametricBufferGeometry",this.parameters={func:t,slices:e,stacks:i};var r,n,o=[],a=[],s=[],c=[],u=new v,l=new v,h=new v,p=new v,d=new v,f=e+1;for(r=0;r<=i;r++){var m=r/i;for(n=0;n<=e;n++){var g=n/e;l=t(g,m,l),a.push(l.x,l.y,l.z),g-1e-5>=0?(h=t(g-1e-5,m,h),p.subVectors(l,h)):(h=t(g+1e-5,m,h),p.subVectors(h,l)),m-1e-5>=0?(h=t(g,m-1e-5,h),d.subVectors(l,h)):(h=t(g,m+1e-5,h),d.subVectors(h,l)),u.crossVectors(p,d).normalize(),s.push(u.x,u.y,u.z),c.push(g,m)}}for(r=0;r<i;r++)for(n=0;n<e;n++){var y=r*f+n,b=r*f+n+1,x=(r+1)*f+n+1,_=(r+1)*f+n;o.push(y,b,_),o.push(b,x,_)}this.setIndex(o),this.addAttribute("position",new Dt(a,3)),this.addAttribute("normal",new Dt(s,3)),this.addAttribute("uv",new Dt(c,2))}function ei(t,e,i,r){Mt.call(this),this.type="PolyhedronGeometry",this.parameters={vertices:t,indices:e,radius:i,detail:r},this.fromBufferGeometry(new ii(t,e,i,r)),this.mergeVertices()}function ii(t,e,i,r){function n(t,e,i,r){var n,o,s=Math.pow(2,r),c=[];for(n=0;n<=s;n++){c[n]=[];var u=t.clone().lerp(i,n/s),l=e.clone().lerp(i,n/s),h=s-n;for(o=0;o<=h;o++)c[n][o]=0===o&&n===s?u:u.clone().lerp(l,o/h)}for(n=0;n<s;n++)for(o=0;o<2*(s-n)-1;o++){var p=Math.floor(o/2);o%2==0?(a(c[n][p+1]),a(c[n+1][p]),a(c[n][p])):(a(c[n][p+1]),a(c[n+1][p+1]),a(c[n+1][p]))}}function o(){for(var t=0;t<f.length;t+=6){var e=f[t+0],i=f[t+2],r=f[t+4],n=Math.max(e,i,r),o=Math.min(e,i,r);n>.9&&o<.1&&(e<.2&&(f[t+0]+=1),i<.2&&(f[t+2]+=1),r<.2&&(f[t+4]+=1))}}function a(t){d.push(t.x,t.y,t.z)}function s(e,i){var r=3*e;i.x=t[r+0],i.y=t[r+1],i.z=t[r+2]}function c(){for(var t=new v,e=new v,i=new v,r=new v,n=new h,o=new h,a=new h,s=0,c=0;s<d.length;s+=9,c+=6){t.set(d[s+0],d[s+1],d[s+2]),e.set(d[s+3],d[s+4],d[s+5]),i.set(d[s+6],d[s+7],d[s+8]),n.set(f[c+0],f[c+1]),o.set(f[c+2],f[c+3]),a.set(f[c+4],f[c+5]),r.copy(t).add(e).add(i).divideScalar(3);var p=l(r);u(n,c+0,t,p),u(o,c+2,e,p),u(a,c+4,i,p)}}function u(t,e,i,r){r<0&&1===t.x&&(f[e]=t.x-1),0===i.x&&0===i.z&&(f[e]=r/2/Math.PI+.5)}function l(t){return Math.atan2(t.z,-t.x)}function p(t){return Math.atan2(-t.y,Math.sqrt(t.x*t.x+t.z*t.z))}Ft.call(this),this.type="PolyhedronBufferGeometry",this.parameters={vertices:t,indices:e,radius:i,detail:r},i=i||1;var d=[],f=[];!function(t){for(var i=new v,r=new v,o=new v,a=0;a<e.length;a+=3)s(e[a+0],i),s(e[a+1],r),s(e[a+2],o),n(i,r,o,t)}(r=r||0),function(t){for(var e=new v,i=0;i<d.length;i+=3)e.x=d[i+0],e.y=d[i+1],e.z=d[i+2],e.normalize().multiplyScalar(t),d[i+0]=e.x,d[i+1]=e.y,d[i+2]=e.z}(i),function(){for(var t=new v,e=0;e<d.length;e+=3){t.x=d[e+0],t.y=d[e+1],t.z=d[e+2];var i=l(t)/2/Math.PI+.5,r=p(t)/Math.PI+.5;f.push(i,1-r)}c(),o()}(),this.addAttribute("position",new Dt(d,3)),this.addAttribute("normal",new Dt(d.slice(),3)),this.addAttribute("uv",new Dt(f,2)),0===r?this.computeVertexNormals():this.normalizeNormals()}function ri(t,e){Mt.call(this),this.type="TetrahedronGeometry",this.parameters={radius:t,detail:e},this.fromBufferGeometry(new ni(t,e)),this.mergeVertices()}function ni(t,e){var i=[1,1,1,-1,-1,1,-1,1,-1,1,-1,-1],r=[2,1,0,0,3,2,1,3,0,2,3,1];ii.call(this,i,r,t,e),this.type="TetrahedronBufferGeometry",this.parameters={radius:t,detail:e}}function oi(t,e){Mt.call(this),this.type="OctahedronGeometry",this.parameters={radius:t,detail:e},this.fromBufferGeometry(new ai(t,e)),this.mergeVertices()}function ai(t,e){var i=[1,0,0,-1,0,0,0,1,0,0,-1,0,0,0,1,0,0,-1],r=[0,2,4,0,4,3,0,3,5,0,5,2,1,2,5,1,5,3,1,3,4,1,4,2];ii.call(this,i,r,t,e),this.type="OctahedronBufferGeometry",this.parameters={radius:t,detail:e}}function si(t,e){Mt.call(this),this.type="IcosahedronGeometry",this.parameters={radius:t,detail:e},this.fromBufferGeometry(new ci(t,e)),this.mergeVertices()}function ci(t,e){var i=(1+Math.sqrt(5))/2,r=[-1,i,0,1,i,0,-1,-i,0,1,-i,0,0,-1,i,0,1,i,0,-1,-i,0,1,-i,i,0,-1,i,0,1,-i,0,-1,-i,0,1],n=[0,11,5,0,5,1,0,1,7,0,7,10,0,10,11,1,5,9,5,11,4,11,10,2,10,7,6,7,1,8,3,9,4,3,4,2,3,2,6,3,6,8,3,8,9,4,9,5,2,4,11,6,2,10,8,6,7,9,8,1];ii.call(this,r,n,t,e),this.type="IcosahedronBufferGeometry",this.parameters={radius:t,detail:e}}function ui(t,e){Mt.call(this),this.type="DodecahedronGeometry",this.parameters={radius:t,detail:e},this.fromBufferGeometry(new li(t,e)),this.mergeVertices()}function li(t,e){var i=(1+Math.sqrt(5))/2,r=1/i,n=[-1,-1,-1,-1,-1,1,-1,1,-1,-1,1,1,1,-1,-1,1,-1,1,1,1,-1,1,1,1,0,-r,-i,0,-r,i,0,r,-i,0,r,i,-r,-i,0,-r,i,0,r,-i,0,r,i,0,-i,0,-r,i,0,-r,-i,0,r,i,0,r],o=[3,11,7,3,7,15,3,15,13,7,19,17,7,17,6,7,6,15,17,4,8,17,8,10,17,10,6,8,0,16,8,16,2,8,2,10,0,12,1,0,1,18,0,18,16,6,10,2,6,2,13,6,13,15,2,16,18,2,18,3,2,3,13,18,1,9,18,9,11,18,11,3,4,14,12,4,12,0,4,0,8,11,9,5,11,5,19,11,19,7,19,5,14,19,14,4,19,4,17,1,12,14,1,14,5,1,5,9];ii.call(this,n,o,t,e),this.type="DodecahedronBufferGeometry",this.parameters={radius:t,detail:e}}function hi(t,e,i,r,n,o){Mt.call(this),this.type="TubeGeometry",this.parameters={path:t,tubularSegments:e,radius:i,radialSegments:r,closed:n},void 0!==o&&console.warn("THREE.TubeGeometry: taper has been removed.");var a=new pi(t,e,i,r,n);this.tangents=a.tangents,this.normals=a.normals,this.binormals=a.binormals,this.fromBufferGeometry(a),this.mergeVertices()}function pi(t,e,i,r,n){function o(n){var o=t.getPointAt(n/e),a=c.normals[n],s=c.binormals[n];for(l=0;l<=r;l++){var u=l/r*Math.PI*2,h=Math.sin(u),f=-Math.cos(u);d.x=f*a.x+h*s.x,d.y=f*a.y+h*s.y,d.z=f*a.z+h*s.z,d.normalize(),g.push(d.x,d.y,d.z),p.x=o.x+i*d.x,p.y=o.y+i*d.y,p.z=o.z+i*d.z,m.push(p.x,p.y,p.z)}}function a(){for(l=1;l<=e;l++)for(u=1;u<=r;u++){var t=(r+1)*(l-1)+(u-1),i=(r+1)*l+(u-1),n=(r+1)*l+u,o=(r+1)*(l-1)+u;b.push(t,i,o),b.push(i,n,o)}}function s(){for(u=0;u<=e;u++)for(l=0;l<=r;l++)f.x=u/e,f.y=l/r,y.push(f.x,f.y)}Ft.call(this),this.type="TubeBufferGeometry",this.parameters={path:t,tubularSegments:e,radius:i,radialSegments:r,closed:n},e=e||64,i=i||1,r=r||8,n=n||!1;var c=t.computeFrenetFrames(e,n);this.tangents=c.tangents,this.normals=c.normals,this.binormals=c.binormals;var u,l,p=new v,d=new v,f=new h,m=[],g=[],y=[],b=[];!function(){for(u=0;u<e;u++)o(u);o(!1===n?e:0),s(),a()}(),this.setIndex(b),this.addAttribute("position",new Dt(m,3)),this.addAttribute("normal",new Dt(g,3)),this.addAttribute("uv",new Dt(y,2))}function di(t,e,i,r,n,o,a){Mt.call(this),this.type="TorusKnotGeometry",this.parameters={radius:t,tube:e,tubularSegments:i,radialSegments:r,p:n,q:o},void 0!==a&&console.warn("THREE.TorusKnotGeometry: heightScale has been deprecated. Use .scale( x, y, z ) instead."),this.fromBufferGeometry(new fi(t,e,i,r,n,o)),this.mergeVertices()}function fi(t,e,i,r,n,o){function a(t,e,i,r,n){var o=Math.cos(t),a=Math.sin(t),s=i/e*t,c=Math.cos(s);n.x=r*(2+c)*.5*o,n.y=r*(2+c)*a*.5,n.z=r*Math.sin(s)*.5}Ft.call(this),this.type="TorusKnotBufferGeometry",this.parameters={radius:t,tube:e,tubularSegments:i,radialSegments:r,p:n,q:o},t=t||100,e=e||40,i=Math.floor(i)||64,r=Math.floor(r)||8,n=n||2,o=o||3;var s,c,u=[],l=[],h=[],p=[],d=new v,f=new v,m=new v,g=new v,y=new v,b=new v,x=new v;for(s=0;s<=i;++s){var _=s/i*n*Math.PI*2;for(a(_,n,o,t,m),a(_+.01,n,o,t,g),b.subVectors(g,m),x.addVectors(g,m),y.crossVectors(b,x),x.crossVectors(y,b),y.normalize(),x.normalize(),c=0;c<=r;++c){var w=c/r*Math.PI*2,S=-e*Math.cos(w),A=e*Math.sin(w);d.x=m.x+(S*x.x+A*y.x),d.y=m.y+(S*x.y+A*y.y),d.z=m.z+(S*x.z+A*y.z),l.push(d.x,d.y,d.z),f.subVectors(d,m).normalize(),h.push(f.x,f.y,f.z),p.push(s/i),p.push(c/r)}}for(c=1;c<=i;c++)for(s=1;s<=r;s++){var M=(r+1)*(c-1)+(s-1),P=(r+1)*c+(s-1),E=(r+1)*c+s,T=(r+1)*(c-1)+s;u.push(M,P,T),u.push(P,E,T)}this.setIndex(u),this.addAttribute("position",new Dt(l,3)),this.addAttribute("normal",new Dt(h,3)),this.addAttribute("uv",new Dt(p,2))}function mi(t,e,i,r,n){Mt.call(this),this.type="TorusGeometry",this.parameters={radius:t,tube:e,radialSegments:i,tubularSegments:r,arc:n},this.fromBufferGeometry(new gi(t,e,i,r,n)),this.mergeVertices()}function gi(t,e,i,r,n){Ft.call(this),this.type="TorusBufferGeometry",this.parameters={radius:t,tube:e,radialSegments:i,tubularSegments:r,arc:n},t=t||100,e=e||40,i=Math.floor(i)||8,r=Math.floor(r)||6,n=n||2*Math.PI;var o,a,s=[],c=[],u=[],l=[],h=new v,p=new v,d=new v;for(o=0;o<=i;o++)for(a=0;a<=r;a++){var f=a/r*n,m=o/i*Math.PI*2;p.x=(t+e*Math.cos(m))*Math.cos(f),p.y=(t+e*Math.cos(m))*Math.sin(f),p.z=e*Math.sin(m),c.push(p.x,p.y,p.z),h.x=t*Math.cos(f),h.y=t*Math.sin(f),d.subVectors(p,h).normalize(),u.push(d.x,d.y,d.z),l.push(a/r),l.push(o/i)}for(o=1;o<=i;o++)for(a=1;a<=r;a++){var g=(r+1)*o+a-1,y=(r+1)*(o-1)+a-1,b=(r+1)*(o-1)+a,x=(r+1)*o+a;s.push(g,y,x),s.push(y,b,x)}this.setIndex(s),this.addAttribute("position",new Dt(c,3)),this.addAttribute("normal",new Dt(u,3)),this.addAttribute("uv",new Dt(l,2))}function vi(t,e){Mt.call(this),this.type="ExtrudeGeometry",this.parameters={shapes:t,options:e},this.fromBufferGeometry(new yi(t,e)),this.mergeVertices()}function yi(t,e){void 0!==t&&(Ft.call(this),this.type="ExtrudeBufferGeometry",t=Array.isArray(t)?t:[t],this.addShapeList(t,e),this.computeVertexNormals())}function bi(t,e){Mt.call(this),this.type="TextGeometry",this.parameters={text:t,parameters:e},this.fromBufferGeometry(new xi(t,e)),this.mergeVertices()}function xi(t,e){var i=(e=e||{}).font;if(!i||!i.isFont)return console.error("THREE.TextGeometry: font parameter is not an instance of THREE.Font."),new Mt;var r=i.generateShapes(t,e.size,e.curveSegments);e.amount=void 0!==e.height?e.height:50,void 0===e.bevelThickness&&(e.bevelThickness=10),void 0===e.bevelSize&&(e.bevelSize=8),void 0===e.bevelEnabled&&(e.bevelEnabled=!1),yi.call(this,r,e),this.type="TextBufferGeometry"}function _i(t,e,i,r,n,o,a){Mt.call(this),this.type="SphereGeometry",this.parameters={radius:t,widthSegments:e,heightSegments:i,phiStart:r,phiLength:n,thetaStart:o,thetaLength:a},this.fromBufferGeometry(new wi(t,e,i,r,n,o,a)),this.mergeVertices()}function wi(t,e,i,r,n,o,a){Ft.call(this),this.type="SphereBufferGeometry",this.parameters={radius:t,widthSegments:e,heightSegments:i,phiStart:r,phiLength:n,thetaStart:o,thetaLength:a},t=t||50,e=Math.max(3,Math.floor(e)||8),i=Math.max(2,Math.floor(i)||6),r=void 0!==r?r:0,n=void 0!==n?n:2*Math.PI;var s,c,u=(o=void 0!==o?o:0)+(a=void 0!==a?a:Math.PI),l=0,h=[],p=new v,d=new v,f=[],m=[],g=[],y=[];for(c=0;c<=i;c++){var b=[],x=c/i;for(s=0;s<=e;s++){var _=s/e;p.x=-t*Math.cos(r+_*n)*Math.sin(o+x*a),p.y=t*Math.cos(o+x*a),p.z=t*Math.sin(r+_*n)*Math.sin(o+x*a),m.push(p.x,p.y,p.z),d.set(p.x,p.y,p.z).normalize(),g.push(d.x,d.y,d.z),y.push(_,1-x),b.push(l++)}h.push(b)}for(c=0;c<i;c++)for(s=0;s<e;s++){var w=h[c][s+1],S=h[c][s],A=h[c+1][s],M=h[c+1][s+1];(0!==c||o>0)&&f.push(w,S,M),(c!==i-1||u<Math.PI)&&f.push(S,A,M)}this.setIndex(f),this.addAttribute("position",new Dt(m,3)),this.addAttribute("normal",new Dt(g,3)),this.addAttribute("uv",new Dt(y,2))}function Si(t,e,i,r,n,o){Mt.call(this),this.type="RingGeometry",this.parameters={innerRadius:t,outerRadius:e,thetaSegments:i,phiSegments:r,thetaStart:n,thetaLength:o},this.fromBufferGeometry(new Ai(t,e,i,r,n,o)),this.mergeVertices()}function Ai(t,e,i,r,n,o){Ft.call(this),this.type="RingBufferGeometry",this.parameters={innerRadius:t,outerRadius:e,thetaSegments:i,phiSegments:r,thetaStart:n,thetaLength:o},t=t||20,e=e||50,n=void 0!==n?n:0,o=void 0!==o?o:2*Math.PI,i=void 0!==i?Math.max(3,i):8;var a,s,c,u=[],l=[],p=[],d=[],f=t,m=(e-t)/(r=void 0!==r?Math.max(1,r):1),g=new v,y=new h;for(s=0;s<=r;s++){for(c=0;c<=i;c++)a=n+c/i*o,g.x=f*Math.cos(a),g.y=f*Math.sin(a),l.push(g.x,g.y,g.z),p.push(0,0,1),y.x=(g.x/e+1)/2,y.y=(g.y/e+1)/2,d.push(y.x,y.y);f+=m}for(s=0;s<r;s++){var b=s*(i+1);for(c=0;c<i;c++){var x=a=c+b,_=a+i+1,w=a+i+2,S=a+1;u.push(x,_,S),u.push(_,w,S)}}this.setIndex(u),this.addAttribute("position",new Dt(l,3)),this.addAttribute("normal",new Dt(p,3)),this.addAttribute("uv",new Dt(d,2))}function Mi(t,e,i,r){Mt.call(this),this.type="LatheGeometry",this.parameters={points:t,segments:e,phiStart:i,phiLength:r},this.fromBufferGeometry(new Pi(t,e,i,r)),this.mergeVertices()}function Pi(t,e,i,r){Ft.call(this),this.type="LatheBufferGeometry",this.parameters={points:t,segments:e,phiStart:i,phiLength:r},e=Math.floor(e)||12,i=i||0,r=r||2*Math.PI,r=Ap.clamp(r,0,2*Math.PI);var n,o,a,s=[],c=[],u=[],l=1/e,p=new v,d=new h;for(o=0;o<=e;o++){var f=i+o*l*r,m=Math.sin(f),g=Math.cos(f);for(a=0;a<=t.length-1;a++)p.x=t[a].x*m,p.y=t[a].y,p.z=t[a].x*g,c.push(p.x,p.y,p.z),d.x=o/e,d.y=a/(t.length-1),u.push(d.x,d.y)}for(o=0;o<e;o++)for(a=0;a<t.length-1;a++){var y=n=a+o*t.length,b=n+t.length,x=n+t.length+1,_=n+1;s.push(y,b,_),s.push(b,x,_)}if(this.setIndex(s),this.addAttribute("position",new Dt(c,3)),this.addAttribute("uv",new Dt(u,2)),this.computeVertexNormals(),r===2*Math.PI){var w=this.attributes.normal.array,S=new v,A=new v,M=new v;for(n=e*t.length*3,o=0,a=0;o<t.length;o++,a+=3)S.x=w[a+0],S.y=w[a+1],S.z=w[a+2],A.x=w[n+a+0],A.y=w[n+a+1],A.z=w[n+a+2],M.addVectors(S,A).normalize(),w[a+0]=w[n+a+0]=M.x,w[a+1]=w[n+a+1]=M.y,w[a+2]=w[n+a+2]=M.z}}function Ei(t,e){Mt.call(this),this.type="ShapeGeometry","object"==typeof e&&(console.warn("THREE.ShapeGeometry: Options parameter has been removed."),e=e.curveSegments),this.parameters={shapes:t,curveSegments:e},this.fromBufferGeometry(new Ti(t,e)),this.mergeVertices()}function Ti(t,e){function i(t){var i,r,c,l=o.length/3,h=t.extractPoints(e),p=h.shape,d=h.holes;if(!1===Vp.isClockWise(p))for(p=p.reverse(),i=0,r=d.length;i<r;i++)c=d[i],!0===Vp.isClockWise(c)&&(d[i]=c.reverse());var f=Vp.triangulateShape(p,d);for(i=0,r=d.length;i<r;i++)c=d[i],p=p.concat(c);for(i=0,r=p.length;i<r;i++){var m=p[i];o.push(m.x,m.y,0),a.push(0,0,1),s.push(m.x,m.y)}for(i=0,r=f.length;i<r;i++){var g=f[i],v=g[0]+l,y=g[1]+l,b=g[2]+l;n.push(v,y,b),u+=3}}var r=this;Ft.call(this),this.type="ShapeBufferGeometry",this.parameters={shapes:t,curveSegments:e},e=e||12;var n=[],o=[],a=[],s=[],c=0,u=0;if(!1===Array.isArray(t))i(t);else for(var l=0;l<t.length;l++)i(t[l]),r.addGroup(c,u,l),c+=u,u=0;this.setIndex(n),this.addAttribute("position",new Dt(o,3)),this.addAttribute("normal",new Dt(a,3)),this.addAttribute("uv",new Dt(s,2))}function Ci(t,e){Ft.call(this),this.type="EdgesGeometry",this.parameters={thresholdAngle:e},e=void 0!==e?e:1;var i,r,n,o,a=[],s=Math.cos(Ap.DEG2RAD*e),c=[0,0],u={},l=["a","b","c"];t.isBufferGeometry?(o=new Mt).fromBufferGeometry(t):o=t.clone(),o.mergeVertices(),o.computeFaceNormals();for(var h=o.vertices,p=o.faces,d=0,f=p.length;d<f;d++)for(var m=p[d],g=0;g<3;g++)i=m[l[g]],r=m[l[(g+1)%3]],c[0]=Math.min(i,r),c[1]=Math.max(i,r),void 0===u[n=c[0]+","+c[1]]?u[n]={index1:c[0],index2:c[1],face1:d,face2:void 0}:u[n].face2=d;for(n in u){var v=u[n];if(void 0===v.face2||p[v.face1].normal.dot(p[v.face2].normal)<=s){var y=h[v.index1];a.push(y.x,y.y,y.z),y=h[v.index2],a.push(y.x,y.y,y.z)}}this.addAttribute("position",new Dt(a,3))}function Ii(t,e,i,r,n,o,a,s){Mt.call(this),this.type="CylinderGeometry",this.parameters={radiusTop:t,radiusBottom:e,height:i,radialSegments:r,heightSegments:n,openEnded:o,thetaStart:a,thetaLength:s},this.fromBufferGeometry(new Ri(t,e,i,r,n,o,a,s)),this.mergeVertices()}function Ri(t,e,i,r,n,o,a,s){function c(i){var n,o,c,g=new h,x=new v,_=0,w=!0===i?t:e,S=!0===i?1:-1;for(o=m,n=1;n<=r;n++)p.push(0,y*S,0),d.push(0,S,0),f.push(.5,.5),m++;for(c=m,n=0;n<=r;n++){var A=n/r*s+a,M=Math.cos(A),P=Math.sin(A);x.x=w*P,x.y=y*S,x.z=w*M,p.push(x.x,x.y,x.z),d.push(0,S,0),g.x=.5*M+.5,g.y=.5*P*S+.5,f.push(g.x,g.y),m++}for(n=0;n<r;n++){var E=o+n,T=c+n;!0===i?l.push(T,T+1,E):l.push(T+1,T,E),_+=3}u.addGroup(b,_,!0===i?1:2),b+=_}Ft.call(this),this.type="CylinderBufferGeometry",this.parameters={radiusTop:t,radiusBottom:e,height:i,radialSegments:r,heightSegments:n,openEnded:o,thetaStart:a,thetaLength:s};var u=this;t=void 0!==t?t:20,e=void 0!==e?e:20,i=void 0!==i?i:100,r=Math.floor(r)||8,n=Math.floor(n)||1,o=void 0!==o&&o,a=void 0!==a?a:0,s=void 0!==s?s:2*Math.PI;var l=[],p=[],d=[],f=[],m=0,g=[],y=i/2,b=0;!function(){var o,c,h=new v,x=new v,_=0,w=(e-t)/i;for(c=0;c<=n;c++){var S=[],A=c/n,M=A*(e-t)+t;for(o=0;o<=r;o++){var P=o/r,E=P*s+a,T=Math.sin(E),C=Math.cos(E);x.x=M*T,x.y=-A*i+y,x.z=M*C,p.push(x.x,x.y,x.z),h.set(T,w,C).normalize(),d.push(h.x,h.y,h.z),f.push(P,1-A),S.push(m++)}g.push(S)}for(o=0;o<r;o++)for(c=0;c<n;c++){var I=g[c][o],R=g[c+1][o],L=g[c+1][o+1],O=g[c][o+1];l.push(I,R,O),l.push(R,L,O),_+=6}u.addGroup(b,_,0),b+=_}(),!1===o&&(t>0&&c(!0),e>0&&c(!1)),this.setIndex(l),this.addAttribute("position",new Dt(p,3)),this.addAttribute("normal",new Dt(d,3)),this.addAttribute("uv",new Dt(f,2))}function Li(t,e,i,r,n,o,a){Ii.call(this,0,t,e,i,r,n,o,a),this.type="ConeGeometry",this.parameters={radius:t,height:e,radialSegments:i,heightSegments:r,openEnded:n,thetaStart:o,thetaLength:a}}function Oi(t,e,i,r,n,o,a){Ri.call(this,0,t,e,i,r,n,o,a),this.type="ConeBufferGeometry",this.parameters={radius:t,height:e,radialSegments:i,heightSegments:r,openEnded:n,thetaStart:o,thetaLength:a}}function Di(t,e,i,r){Mt.call(this),this.type="CircleGeometry",this.parameters={radius:t,segments:e,thetaStart:i,thetaLength:r},this.fromBufferGeometry(new Ni(t,e,i,r)),this.mergeVertices()}function Ni(t,e,i,r){Ft.call(this),this.type="CircleBufferGeometry",this.parameters={radius:t,segments:e,thetaStart:i,thetaLength:r},t=t||50,e=void 0!==e?Math.max(3,e):8,i=void 0!==i?i:0,r=void 0!==r?r:2*Math.PI;var n,o,a=[],s=[],c=[],u=[],l=new v,p=new h;for(s.push(0,0,0),c.push(0,0,1),u.push(.5,.5),o=0,n=3;o<=e;o++,n+=3){var d=i+o/e*r;l.x=t*Math.cos(d),l.y=t*Math.sin(d),s.push(l.x,l.y,l.z),c.push(0,0,1),p.x=(s[n]/t+1)/2,p.y=(s[n+1]/t+1)/2,u.push(p.x,p.y)}for(n=1;n<=e;n++)a.push(n,n+1,0);this.setIndex(a),this.addAttribute("position",new Dt(s,3)),this.addAttribute("normal",new Dt(c,3)),this.addAttribute("uv",new Dt(u,2))}function ki(t){at.call(this),this.type="ShadowMaterial",this.color=new et(0),this.opacity=1,this.lights=!0,this.transparent=!0,this.setValues(t)}function Bi(t){st.call(this,t),this.type="RawShaderMaterial"}function Fi(t){at.call(this),this.defines={STANDARD:""},this.type="MeshStandardMaterial",this.color=new et(16777215),this.roughness=.5,this.metalness=.5,this.map=null,this.lightMap=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.emissive=new et(0),this.emissiveIntensity=1,this.emissiveMap=null,this.bumpMap=null,this.bumpScale=1,this.normalMap=null,this.normalScale=new h(1,1),this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.roughnessMap=null,this.metalnessMap=null,this.alphaMap=null,this.envMap=null,this.envMapIntensity=1,this.refractionRatio=.98,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinecap="round",this.wireframeLinejoin="round",this.skinning=!1,this.morphTargets=!1,this.morphNormals=!1,this.setValues(t)}function zi(t){Fi.call(this),this.defines={PHYSICAL:""},this.type="MeshPhysicalMaterial",this.reflectivity=.5,this.clearCoat=0,this.clearCoatRoughness=0,this.setValues(t)}function Ui(t){at.call(this),this.type="MeshPhongMaterial",this.color=new et(16777215),this.specular=new et(1118481),this.shininess=30,this.map=null,this.lightMap=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.emissive=new et(0),this.emissiveIntensity=1,this.emissiveMap=null,this.bumpMap=null,this.bumpScale=1,this.normalMap=null,this.normalScale=new h(1,1),this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.specularMap=null,this.alphaMap=null,this.envMap=null,this.combine=ph,this.reflectivity=1,this.refractionRatio=.98,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinecap="round",this.wireframeLinejoin="round",this.skinning=!1,this.morphTargets=!1,this.morphNormals=!1,this.setValues(t)}function ji(t){Ui.call(this),this.defines={TOON:""},this.type="MeshToonMaterial",this.gradientMap=null,this.setValues(t)}function Vi(t){at.call(this),this.type="MeshNormalMaterial",this.bumpMap=null,this.bumpScale=1,this.normalMap=null,this.normalScale=new h(1,1),this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.wireframe=!1,this.wireframeLinewidth=1,this.fog=!1,this.lights=!1,this.skinning=!1,this.morphTargets=!1,this.morphNormals=!1,this.setValues(t)}function Gi(t){at.call(this),this.type="MeshLambertMaterial",this.color=new et(16777215),this.map=null,this.lightMap=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.emissive=new et(0),this.emissiveIntensity=1,this.emissiveMap=null,this.specularMap=null,this.alphaMap=null,this.envMap=null,this.combine=ph,this.reflectivity=1,this.refractionRatio=.98,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinecap="round",this.wireframeLinejoin="round",this.skinning=!1,this.morphTargets=!1,this.morphNormals=!1,this.setValues(t)}function $i(t){Ve.call(this),this.type="LineDashedMaterial",this.scale=1,this.dashSize=3,this.gapSize=1,this.setValues(t)}function Hi(t,e,i){var r=this,n=!1,o=0,a=0;this.onStart=void 0,this.onLoad=t,this.onProgress=e,this.onError=i,this.itemStart=function(t){a++,!1===n&&void 0!==r.onStart&&r.onStart(t,o,a),n=!0},this.itemEnd=function(t){o++,void 0!==r.onProgress&&r.onProgress(t,o,a),o===a&&(n=!1,void 0!==r.onLoad&&r.onLoad())},this.itemError=function(t){void 0!==r.onError&&r.onError(t)}}function Wi(t){this.manager=void 0!==t?t:Wp}function Xi(t){this.manager=void 0!==t?t:Wp}function qi(t){this.manager=void 0!==t?t:Wp}function Yi(t,e){bt.call(this),this.type="Light",this.color=new et(t),this.intensity=void 0!==e?e:1,this.receiveShadow=void 0}function Zi(t,e,i){Yi.call(this,t,i),this.type="HemisphereLight",this.castShadow=void 0,this.position.copy(bt.DefaultUp),this.updateMatrix(),this.groundColor=new et(e)}function Ki(t){this.camera=t,this.bias=0,this.radius=1,this.mapSize=new h(512,512),this.map=null,this.matrix=new y}function Qi(){Ki.call(this,new wt(50,1,.5,500))}function Ji(t,e,i,r,n,o){Yi.call(this,t,e),this.type="SpotLight",this.position.copy(bt.DefaultUp),this.updateMatrix(),this.target=new bt,Object.defineProperty(this,"power",{get:function(){return this.intensity*Math.PI},set:function(t){this.intensity=t/Math.PI}}),this.distance=void 0!==i?i:0,this.angle=void 0!==r?r:Math.PI/3,this.penumbra=void 0!==n?n:0,this.decay=void 0!==o?o:1,this.shadow=new Qi}function tr(t,e,i,r){Yi.call(this,t,e),this.type="PointLight",Object.defineProperty(this,"power",{get:function(){return 4*this.intensity*Math.PI},set:function(t){this.intensity=t/(4*Math.PI)}}),this.distance=void 0!==i?i:0,this.decay=void 0!==r?r:1,this.shadow=new Ki(new wt(90,1,.5,500))}function er(){Ki.call(this,new _t(-5,5,5,-5,.5,500))}function ir(t,e){Yi.call(this,t,e),this.type="DirectionalLight",this.position.copy(bt.DefaultUp),this.updateMatrix(),this.target=new bt,this.shadow=new er}function rr(t,e){Yi.call(this,t,e),this.type="AmbientLight",this.castShadow=void 0}function nr(t,e,i,r){Yi.call(this,t,e),this.type="RectAreaLight",this.position.set(0,1,0),this.updateMatrix(),this.width=void 0!==i?i:10,this.height=void 0!==r?r:10}function or(t,e,i,r){this.parameterPositions=t,this._cachedIndex=0,this.resultBuffer=void 0!==r?r:new e.constructor(i),this.sampleValues=e,this.valueSize=i}function ar(t,e,i,r){or.call(this,t,e,i,r),this._weightPrev=-0,this._offsetPrev=-0,this._weightNext=-0,this._offsetNext=-0}function sr(t,e,i,r){or.call(this,t,e,i,r)}function cr(t,e,i,r){or.call(this,t,e,i,r)}function ur(t,e,i,r){if(void 0===t)throw new Error("track name is undefined");if(void 0===e||0===e.length)throw new Error("no keyframes in track named "+t);this.name=t,this.times=Xp.convertArray(e,this.TimeBufferType),this.values=Xp.convertArray(i,this.ValueBufferType),this.setInterpolation(r||this.DefaultInterpolation),this.validate(),this.optimize()}function lr(t,e,i,r){ur.call(this,t,e,i,r)}function hr(t,e,i,r){or.call(this,t,e,i,r)}function pr(t,e,i,r){ur.call(this,t,e,i,r)}function dr(t,e,i,r){ur.call(this,t,e,i,r)}function fr(t,e,i,r){ur.call(this,t,e,i,r)}function mr(t,e,i){ur.call(this,t,e,i)}function gr(t,e,i,r){ur.call(this,t,e,i,r)}function vr(t,e,i,r){ur.apply(this,arguments)}function yr(t,e,i){this.name=t,this.tracks=i,this.duration=void 0!==e?e:-1,this.uuid=Ap.generateUUID(),this.duration<0&&this.resetDuration(),this.optimize()}function br(t){this.manager=void 0!==t?t:Wp,this.textures={}}function xr(t){this.manager=void 0!==t?t:Wp}function _r(){this.onLoadStart=function(){},this.onLoadProgress=function(){},this.onLoadComplete=function(){}}function wr(t){"boolean"==typeof t&&(console.warn("THREE.JSONLoader: showStatus parameter has been removed from constructor."),t=void 0),this.manager=void 0!==t?t:Wp,this.withCredentials=!1}function Sr(t,e,i,r,n){var o=.5*(r-e),a=.5*(n-i),s=t*t;return(2*i-2*r+o+a)*(t*s)+(-3*i+3*r-2*o-a)*s+o*t+i}function Ar(t,e){var i=1-t;return i*i*e}function Mr(t,e){return 2*(1-t)*t*e}function Pr(t,e){return t*t*e}function Er(t,e,i,r){return Ar(t,e)+Mr(t,i)+Pr(t,r)}function Tr(t,e){var i=1-t;return i*i*i*e}function Cr(t,e){var i=1-t;return 3*i*i*t*e}function Ir(t,e){return 3*(1-t)*t*t*e}function Rr(t,e){return t*t*t*e}function Lr(t,e,i,r,n){return Tr(t,e)+Cr(t,i)+Ir(t,r)+Rr(t,n)}function Or(){this.arcLengthDivisions=200}function Dr(t,e){Or.call(this),this.v1=t,this.v2=e}function Nr(){Or.call(this),this.curves=[],this.autoClose=!1}function kr(t,e,i,r,n,o,a,s){Or.call(this),this.aX=t,this.aY=e,this.xRadius=i,this.yRadius=r,this.aStartAngle=n,this.aEndAngle=o,this.aClockwise=a,this.aRotation=s||0}function Br(t){Or.call(this),this.points=void 0===t?[]:t}function Fr(t,e,i,r){Or.call(this),this.v0=t,this.v1=e,this.v2=i,this.v3=r}function zr(t,e,i){Or.call(this),this.v0=t,this.v1=e,this.v2=i}function Ur(t){Nr.call(this),this.currentPoint=new h,t&&this.fromPoints(t)}function jr(){Ur.apply(this,arguments),this.holes=[]}function Vr(){this.subPaths=[],this.currentPath=null}function Gr(t){this.data=t}function $r(t){this.manager=void 0!==t?t:Wp}function Hr(t,e,i){bt.call(this),this.type="CubeCamera";var r=new wt(90,1,t,e);r.up.set(0,-1,0),r.lookAt(new v(1,0,0)),this.add(r);var n=new wt(90,1,t,e);n.up.set(0,-1,0),n.lookAt(new v(-1,0,0)),this.add(n);var o=new wt(90,1,t,e);o.up.set(0,0,1),o.lookAt(new v(0,1,0)),this.add(o);var a=new wt(90,1,t,e);a.up.set(0,0,-1),a.lookAt(new v(0,-1,0)),this.add(a);var s=new wt(90,1,t,e);s.up.set(0,-1,0),s.lookAt(new v(0,0,1)),this.add(s);var c=new wt(90,1,t,e);c.up.set(0,-1,0),c.lookAt(new v(0,0,-1)),this.add(c);var u={format:Yh,magFilter:Oh,minFilter:Oh};this.renderTarget=new m(i,i,u),this.renderTarget.texture.name="CubeCamera",this.update=function(t,e){null===this.parent&&this.updateMatrixWorld();var i=this.renderTarget,u=i.texture.generateMipmaps;i.texture.generateMipmaps=!1,i.activeCubeFace=0,t.render(e,r,i),i.activeCubeFace=1,t.render(e,n,i),i.activeCubeFace=2,t.render(e,o,i),i.activeCubeFace=3,t.render(e,a,i),i.activeCubeFace=4,t.render(e,s,i),i.texture.generateMipmaps=u,i.activeCubeFace=5,t.render(e,c,i),t.setRenderTarget(null)},this.clear=function(t,e,i,r){for(var n=this.renderTarget,o=0;o<6;o++)n.activeCubeFace=o,t.setRenderTarget(n),t.clear(e,i,r);t.setRenderTarget(null)}}function Wr(){bt.call(this),this.type="AudioListener",this.context=ed.getContext(),this.gain=this.context.createGain(),this.gain.connect(this.context.destination),this.filter=null}function Xr(t){bt.call(this),this.type="Audio",this.context=t.context,this.gain=this.context.createGain(),this.gain.connect(t.getInput()),this.autoplay=!1,this.buffer=null,this.loop=!1,this.startTime=0,this.playbackRate=1,this.isPlaying=!1,this.hasPlaybackControl=!0,this.sourceType="empty",this.filters=[]}function qr(t){Xr.call(this,t),this.panner=this.context.createPanner(),this.panner.connect(this.gain)}function Yr(t,e){this.analyser=t.context.createAnalyser(),this.analyser.fftSize=void 0!==e?e:2048,this.data=new Uint8Array(this.analyser.frequencyBinCount),t.getOutput().connect(this.analyser)}function Zr(t,e,i){this.binding=t,this.valueSize=i;var r,n=Float64Array;switch(e){case"quaternion":r=this._slerp;break;case"string":case"bool":n=Array,r=this._select;break;default:r=this._lerp}this.buffer=new n(4*i),this._mixBufferRegion=r,this.cumulativeWeight=0,this.useCount=0,this.referenceCount=0}function Kr(t,e,i){var r=i||Qr.parseTrackName(e);this._targetGroup=t,this._bindings=t.subscribe_(e,r)}function Qr(t,e,i){this.path=e,this.parsedPath=i||Qr.parseTrackName(e),this.node=Qr.findNode(t,this.parsedPath.nodeName)||t,this.rootNode=t}function Jr(t,e,i){this._mixer=t,this._clip=e,this._localRoot=i||null;for(var r=e.tracks,n=r.length,o=new Array(n),a={endingStart:hp,endingEnd:hp},s=0;s!==n;++s){var c=r[s].createInterpolant(null);o[s]=c,c.settings=a}this._interpolantSettings=a,this._interpolants=o,this._propertyBindings=new Array(n),this._cacheIndex=null,this._byClipCacheIndex=null,this._timeScaleInterpolant=null,this._weightInterpolant=null,this.loop=lp,this._loopCount=-1,this._startTime=null,this.time=0,this.timeScale=1,this._effectiveTimeScale=1,this.weight=1,this._effectiveWeight=1,this.repetitions=1/0,this.paused=!1,this.enabled=!0,this.clampWhenFinished=!1,this.zeroSlopeAtStart=!0,this.zeroSlopeAtEnd=!0}function tn(t){"string"==typeof t&&(console.warn("THREE.Uniform: Type parameter is no longer needed."),t=arguments[1]),this.value=t}function en(){Ft.call(this),this.type="InstancedBufferGeometry",this.maxInstancedCount=void 0}function rn(t,e,i,r){this.uuid=Ap.generateUUID(),this.data=t,this.itemSize=e,this.offset=i,this.normalized=!0===r}function nn(t,e){this.uuid=Ap.generateUUID(),this.array=t,this.stride=e,this.count=void 0!==t?t.length/e:0,this.dynamic=!1,this.updateRange={offset:0,count:-1},this.onUploadCallback=function(){},this.version=0}function on(t,e,i){nn.call(this,t,e),this.meshPerAttribute=i||1}function an(t,e,i){Pt.call(this,t,e),this.meshPerAttribute=i||1}function sn(t,e){return t.distance-e.distance}function cn(t,e,i,r){if(!1!==t.visible&&(t.raycast(e,i),!0===r))for(var n=t.children,o=0,a=n.length;o<a;o++)cn(n[o],e,i,!0)}function un(t){bt.call(this),this.material=t,this.render=function(t){}}function ln(t,e,i,r){this.object=t,this.size=void 0!==e?e:1;var n=void 0!==i?i:16711680,o=void 0!==r?r:1,a=0,s=this.object.geometry;s&&s.isGeometry?a=3*s.faces.length:s&&s.isBufferGeometry&&(a=s.attributes.normal.count);var c=new Ft,u=new Dt(2*a*3,3);c.addAttribute("position",u),$e.call(this,c,new Ve({color:n,linewidth:o})),this.matrixAutoUpdate=!1,this.update()}function hn(t,e){bt.call(this),this.light=t,this.light.updateMatrixWorld(),this.matrix=t.matrixWorld,this.matrixAutoUpdate=!1,this.color=e;for(var i=new Ft,r=[0,0,0,0,0,1,0,0,0,1,0,1,0,0,0,-1,0,1,0,0,0,0,1,1,0,0,0,0,-1,1],n=0,o=1;n<32;n++,o++){var a=n/32*Math.PI*2,s=o/32*Math.PI*2;r.push(Math.cos(a),Math.sin(a),1,Math.cos(s),Math.sin(s),1)}i.addAttribute("position",new Dt(r,3));var c=new Ve({fog:!1});this.cone=new $e(i,c),this.add(this.cone),this.update()}function pn(t){var e=[];t&&t.isBone&&e.push(t);for(var i=0;i<t.children.length;i++)e.push.apply(e,pn(t.children[i]));return e}function dn(t){for(var e=pn(t),i=new Ft,r=[],n=[],o=new et(0,0,1),a=new et(0,1,0),s=0;s<e.length;s++){var c=e[s];c.parent&&c.parent.isBone&&(r.push(0,0,0),r.push(0,0,0),n.push(o.r,o.g,o.b),n.push(a.r,a.g,a.b))}i.addAttribute("position",new Dt(r,3)),i.addAttribute("color",new Dt(n,3));var u=new Ve({vertexColors:Nl,depthTest:!1,depthWrite:!1,transparent:!0});$e.call(this,i,u),this.root=t,this.bones=e,this.matrix=t.matrixWorld,this.matrixAutoUpdate=!1,this.onBeforeRender()}function fn(t,e,i){this.light=t,this.light.updateMatrixWorld(),this.color=i;var r=new wi(e,4,2),n=new Gt({wireframe:!0,fog:!1});Xt.call(this,r,n),this.matrix=this.light.matrixWorld,this.matrixAutoUpdate=!1,this.update()}function mn(t,e){bt.call(this),this.light=t,this.light.updateMatrixWorld(),this.matrix=t.matrixWorld,this.matrixAutoUpdate=!1,this.color=e;var i=new Ve({fog:!1}),r=new Ft;r.addAttribute("position",new Pt(new Float32Array(15),3)),this.line=new Ge(r,i),this.add(this.line),this.update()}function gn(t,e,i){bt.call(this),this.light=t,this.light.updateMatrixWorld(),this.matrix=t.matrixWorld,this.matrixAutoUpdate=!1,this.color=i;var r=new ai(e);r.rotateY(.5*Math.PI),this.material=new Gt({wireframe:!0,fog:!1}),void 0===this.color&&(this.material.vertexColors=Nl);var n=r.getAttribute("position"),o=new Float32Array(3*n.count);r.addAttribute("color",new Pt(o,3)),this.add(new Xt(r,this.material)),this.update()}function vn(t,e,i,r){t=t||10,e=e||10,i=new et(void 0!==i?i:4473924),r=new et(void 0!==r?r:8947848);for(var n=e/2,o=t/e,a=t/2,s=[],c=[],u=0,l=0,h=-a;u<=e;u++,h+=o){s.push(-a,0,h,a,0,h),s.push(h,0,-a,h,0,a);var p=u===n?i:r;p.toArray(c,l),l+=3,p.toArray(c,l),l+=3,p.toArray(c,l),l+=3,p.toArray(c,l),l+=3}var d=new Ft;d.addAttribute("position",new Dt(s,3)),d.addAttribute("color",new Dt(c,3));var f=new Ve({vertexColors:Nl});$e.call(this,d,f)}function yn(t,e,i,r,n,o){t=t||10,e=e||16,i=i||8,r=r||64,n=new et(void 0!==n?n:4473924),o=new et(void 0!==o?o:8947848);var a,s,c,u,l,h,p,d=[],f=[];for(u=0;u<=e;u++)c=u/e*(2*Math.PI),a=Math.sin(c)*t,s=Math.cos(c)*t,d.push(0,0,0),d.push(a,0,s),p=1&u?n:o,f.push(p.r,p.g,p.b),f.push(p.r,p.g,p.b);for(u=0;u<=i;u++)for(p=1&u?n:o,h=t-t/i*u,l=0;l<r;l++)c=l/r*(2*Math.PI),a=Math.sin(c)*h,s=Math.cos(c)*h,d.push(a,0,s),f.push(p.r,p.g,p.b),c=(l+1)/r*(2*Math.PI),a=Math.sin(c)*h,s=Math.cos(c)*h,d.push(a,0,s),f.push(p.r,p.g,p.b);var m=new Ft;m.addAttribute("position",new Dt(d,3)),m.addAttribute("color",new Dt(f,3));var g=new Ve({vertexColors:Nl});$e.call(this,m,g)}function bn(t,e,i,r){this.object=t,this.size=void 0!==e?e:1;var n=void 0!==i?i:16776960,o=void 0!==r?r:1,a=0,s=this.object.geometry;s&&s.isGeometry?a=s.faces.length:console.warn("THREE.FaceNormalsHelper: only THREE.Geometry is supported. Use THREE.VertexNormalsHelper, instead.");var c=new Ft,u=new Dt(2*a*3,3);c.addAttribute("position",u),$e.call(this,c,new Ve({color:n,linewidth:o})),this.matrixAutoUpdate=!1,this.update()}function xn(t,e,i){bt.call(this),this.light=t,this.light.updateMatrixWorld(),this.matrix=t.matrixWorld,this.matrixAutoUpdate=!1,this.color=i,void 0===e&&(e=1);var r=new Ft;r.addAttribute("position",new Dt([-e,e,0,e,e,0,e,-e,0,-e,-e,0,-e,e,0],3));var n=new Ve({fog:!1});this.lightPlane=new Ge(r,n),this.add(this.lightPlane),(r=new Ft).addAttribute("position",new Dt([0,0,0,0,0,1],3)),this.targetLine=new Ge(r,n),this.add(this.targetLine),this.update()}function _n(t){function e(t,e,r){i(t,r),i(e,r)}function i(t,e){o.push(0,0,0),a.push(e.r,e.g,e.b),void 0===s[t]&&(s[t]=[]),s[t].push(o.length/3-1)}var r=new Ft,n=new Ve({color:16777215,vertexColors:Dl}),o=[],a=[],s={},c=new et(16755200),u=new et(16711680),l=new et(43775),h=new et(16777215),p=new et(3355443);e("n1","n2",c),e("n2","n4",c),e("n4","n3",c),e("n3","n1",c),e("f1","f2",c),e("f2","f4",c),e("f4","f3",c),e("f3","f1",c),e("n1","f1",c),e("n2","f2",c),e("n3","f3",c),e("n4","f4",c),e("p","n1",u),e("p","n2",u),e("p","n3",u),e("p","n4",u),e("u1","u2",l),e("u2","u3",l),e("u3","u1",l),e("c","t",h),e("p","c",p),e("cn1","cn2",p),e("cn3","cn4",p),e("cf1","cf2",p),e("cf3","cf4",p),r.addAttribute("position",new Dt(o,3)),r.addAttribute("color",new Dt(a,3)),$e.call(this,r,n),this.camera=t,this.camera.updateProjectionMatrix&&this.camera.updateProjectionMatrix(),this.matrix=t.matrixWorld,this.matrixAutoUpdate=!1,this.pointMap=s,this.update()}function wn(t,e){this.object=t,void 0===e&&(e=16776960);var i=new Uint16Array([0,1,1,2,2,3,3,0,4,5,5,6,6,7,7,4,0,4,1,5,2,6,3,7]),r=new Float32Array(24),n=new Ft;n.setIndex(new Pt(i,1)),n.addAttribute("position",new Pt(r,3)),$e.call(this,n,new Ve({color:e})),this.matrixAutoUpdate=!1,this.update()}function Sn(t,e){this.type="Box3Helper",this.box=t;var i=void 0!==e?e:16776960,r=new Uint16Array([0,1,1,2,2,3,3,0,4,5,5,6,6,7,7,4,0,4,1,5,2,6,3,7]),n=[1,1,1,-1,1,1,-1,-1,1,1,-1,1,1,1,-1,-1,1,-1,-1,-1,-1,1,-1,-1],o=new Ft;o.setIndex(new Pt(r,1)),o.addAttribute("position",new Dt(n,3)),$e.call(this,o,new Ve({color:i})),this.geometry.computeBoundingSphere(),this.onBeforeRender()}function An(t,e,i){this.type="PlaneHelper",this.plane=t,this.size=void 0===e?1:e;var r=void 0!==i?i:16776960,n=[1,-1,1,-1,1,1,-1,-1,1,1,1,1,-1,1,1,-1,-1,1,1,-1,1,1,1,1,0,0,1,0,0,0],o=new Ft;o.addAttribute("position",new Dt(n,3)),o.computeBoundingSphere(),Ge.call(this,o,new Ve({color:r}));var a=[1,1,1,-1,1,1,-1,-1,1,1,1,1,-1,-1,1,1,-1,1],s=new Ft;s.addAttribute("position",new Dt(a,3)),s.computeBoundingSphere(),this.add(new Xt(s,new Gt({color:r,opacity:.2,transparent:!0,depthWrite:!1}))),this.onBeforeRender()}function Mn(t,e,i,r,n,o){bt.call(this),void 0===r&&(r=16776960),void 0===i&&(i=1),void 0===n&&(n=.2*i),void 0===o&&(o=.2*n),void 0===id&&((id=new Ft).addAttribute("position",new Dt([0,0,0,0,1,0],3)),(rd=new Ri(0,.5,1,5,1)).translate(0,-.5,0)),this.position.copy(e),this.line=new Ge(id,new Ve({color:r})),this.line.matrixAutoUpdate=!1,this.add(this.line),this.cone=new Xt(rd,new Gt({color:r})),this.cone.matrixAutoUpdate=!1,this.add(this.cone),this.setDirection(t),this.setLength(i,n,o)}function Pn(t){var e=[0,0,0,t=t||1,0,0,0,0,0,0,t,0,0,0,0,0,0,t],i=[1,0,0,1,.6,0,0,1,0,.6,1,0,0,0,1,0,.6,1],r=new Ft;r.addAttribute("position",new Dt(e,3)),r.addAttribute("color",new Dt(i,3));var n=new Ve({vertexColors:Nl});$e.call(this,r,n)}function En(){function t(t,o,a,s){e=t,i=a,r=-3*t+3*o-2*a-s,n=2*t-2*o+a+s}var e=0,i=0,r=0,n=0;return{initCatmullRom:function(e,i,r,n,o){t(i,r,o*(r-e),o*(n-i))},initNonuniformCatmullRom:function(e,i,r,n,o,a,s){var c=(i-e)/o-(r-e)/(o+a)+(r-i)/a,u=(r-i)/a-(n-i)/(a+s)+(n-r)/s;t(i,r,c*=a,u*=a)},calc:function(t){var o=t*t;return e+i*t+r*o+n*(o*t)}}}function Tn(t){Or.call(this),t.length<2&&console.warn("THREE.CatmullRomCurve3: Points array needs at least two entries."),this.points=t||[],this.closed=!1}function Cn(t,e,i,r){Or.call(this),this.v0=t,this.v1=e,this.v2=i,this.v3=r}function In(t,e,i){Or.call(this),this.v0=t,this.v1=e,this.v2=i}function Rn(t,e){Or.call(this),this.v1=t,this.v2=e}function Ln(t,e,i,r,n,o){kr.call(this,t,e,i,i,r,n,o)}function On(t){console.warn("THREE.Spline has been removed. Use THREE.CatmullRomCurve3 instead."),Tn.call(this,t),this.type="catmullrom"}function Dn(t){if("undefined"!=typeof window){var e=new RegExp(t+"=([^&#=]*)").exec(window.location.search);return e?decodeURIComponent(e[1]):void 0}}function Nn(t,e){return void 0!==t?t:e}function kn(t,e){e=Nn(e,[]);for(var i=0;i<t.length;i++)Array.isArray(t[i])?kn(t[i],e):e.push(t[i]);return e}function Bn(){var t=window.location.protocol;return null===t.match(/http(s)?:/gi)?"http:":t}function Fn(){if("undefined"==typeof window)return!1;var t=window.navigator.userAgent;return/Opera|OPR/.test(t)?"Opera":/Chrome/i.test(t)?"Chrome":/Firefox/i.test(t)?"Firefox":/Mobile(\/.*)? Safari/i.test(t)?"Mobile Safari":/MSIE/i.test(t)?"Internet Explorer":!!/Safari/i.test(t)&&"Safari"}function zn(t){var e=window.location,i=e.pathname,r=i.substring(0,i.lastIndexOf("/")+1);return e.origin+r+t}function Un(t,e){function i(t){window.open(t,"_blank")||(window.location.href=t)}function r(t){i(o?t:t.replace(/^data:[^;]*;/,"data:attachment/file;"))}if(t){e=e||"download";var n="Safari"===Fn(),o=/CriOS\/[\d]+/.test(window.navigator.userAgent),a=document.createElement("a");if("undefined"!=typeof navigator&&navigator.msSaveOrOpenBlob)navigator.msSaveOrOpenBlob(t,e);else if((n||o)&&window.FileReader)if(t instanceof window.Blob){var s=new window.FileReader;s.onloadend=function(){r(s.result)},s.readAsDataURL(t)}else r(t);else t instanceof window.Blob&&(t=window.URL.createObjectURL(t)),"download"in a?(a.style.display="hidden",document.body.appendChild(a),a.href=t,a.download=e,a.target="_blank",a.click(),document.body.removeChild(a)):i(t),t instanceof window.Blob&&window.URL.revokeObjectURL(t)}}function jn(t){var e,i,r,n=Pm.names,o=(e="undefined"!=typeof window&&t instanceof window.File||"undefined"!=typeof window&&t instanceof window.Blob?t.name||"":t).lastIndexOf("?"),a=-1!==o?e.substring(o):"",s=(e=e.substring(0,-1===o?e.length:o)).replace(/^.*[\\/]/,""),c=s.substring(0,s.lastIndexOf(".")),u=s.split("."),l=u.length>1?u.pop().toLowerCase():"",h=e.match(/^(.+):\/\/(.+)$/);h&&(r=h[1].toLowerCase(),e=h[2]);var p=e.substring(0,e.lastIndexOf("/")+1);if(n.includes(l)){i=l;var d=e.length-l.length-1;l=e.substr(0,d).split(".").pop().toLowerCase();var f=c.length-l.length-1;c=c.substr(0,f)}else i=!1;return{path:e,name:s,ext:l,base:c,dir:p,compressed:i,protocol:r,src:t,query:a}}function Vn(t,e){return t<e?-1:t>e?1:0}function Gn(t,e,i){void 0===i&&(i=Vn);for(var r=0,n=t.length-1;r<=n;){var o=r+n>>1,a=i(e,t[o]);if(a>0)r=o+1;else{if(!(a<0))return o;n=o-1}}return-r-1}function $n(t,e){var i=t.length-1;if(t[i]<e)return-1;for(var r=0;r<=i;){var n=r+i>>1;t[n]>=e?i=n-1:r=n+1}return i+1}function Hn(t,e){if(t[0]>e)return-1;for(var i=0,r=t.length-1;i<=r;){var n=i+r>>1;t[n]>e?r=n-1:i=n+1}return i-1}function Wn(t,e,i){var r=$n(t,e),n=Hn(t,i);return-1===r||-1===n||r>n?0:n-r+1}function Xn(t){return t.sort().filter(function(t,e,i){return 0===e||t!==i[e-1]})}function qn(t){if(t.length>28672){for(var e=[],i=0;i<t.length;i+=28672)e.push(String.fromCharCode.apply(null,t.subarray(i,i+28672)));return e.join("")}return String.fromCharCode.apply(null,t)}function Yn(t,e,i){e=void 0!==e?e:10485760,i=void 0!==i?i:"\n";for(var r="",n=[],o=0;o<t.length;o+=e){var a=qn(t.subarray(o,o+e)),s=a.lastIndexOf(i);if(-1===s)r+=a;else{var c=r+a.substr(0,s);n=n.concat(c.split(i)),r=s===a.length-i.length?"":a.substr(s+i.length)}}return""!==r&&n.push(r),n}function Zn(t,e){switch(t){case"int8":return new Int8Array(e);case"int16":return new Int16Array(e);case"int32":return new Int32Array(e);case"uint8":return new Uint8Array(e);case"uint16":return new Uint16Array(e);case"uint32":return new Uint32Array(e);case"float32":return new Float32Array(e);default:throw new Error("arrayType unknown: "+t)}}function Kn(t,e){return new(e>65535?Uint32Array:Uint16Array)(t)}function Qn(t){return Array.isArray(t)?t:[t]}function Jn(t){return t.buffer&&t.buffer instanceof ArrayBuffer?t.buffer:t}function to(t,e){return t instanceof e?t:new e(t)}function eo(t,e){return void 0===t?t=new e:Array.isArray(t)&&(t=(new e).fromArray(t)),t}function io(t){return eo(t,h)}function ro(t){return eo(t,v)}function no(t){return eo(t,y)}function oo(t){return eo(t,g)}function ao(t){return to(t,Float32Array)}function so(t){return Nn(t,"").toString().toLowerCase()}function co(t){return.01745*t}function uo(t){return 57.29578*t}function lo(){for(var t,e=0,i=0;i<36;i++)8===i||13===i||18===i||23===i?Bf[i]="-":14===i?Bf[i]="4":(e<=2&&(e=33554432+16777216*Math.random()|0),t=15&e,e>>=4,Bf[i]=kf[19===i?3&t|8:t]);return Bf.join("")}function ho(t){return t-=t>>1&1431655765,16843009*((t=(858993459&t)+(t>>2&858993459))+(t>>4)&252645135)>>24}function po(t,e,i){return(t-e)/(i-e)}function fo(t,e,i){return Math.max(e,Math.min(i,t))}function mo(t){return fo(t,0,100)}function go(t){return fo(t,0,1)}function vo(t,e,i){return t+(e-t)*i}function yo(t,e,i,r,n,o){var a=(i-t)*o,s=(r-e)*o,c=n*n;return(2*e-2*i+a+s)*(n*c)+(-3*e+3*i-2*a-s)*c+a*n+e}function bo(t,e,i){return(i=go(po(i,t,e)))*i*(3-2*i)}function xo(t,e,i){if(t>e)return t;var r=t/e;return((2*i-e)*r+(2*e-3*i))*r*r+i}function _o(t,e,i,r,n){this._listener=e,this._isOnce=i,this.context=r,this._signal=t,this._priority=n||0}function wo(t,e){if("function"!=typeof t)throw new Error("listener is a required param of {fn}() and should be a Function.".replace("{fn}",e))}function So(){this._bindings=[],this._prevParams=null;var t=this;this.dispatch=function(){So.prototype.dispatch.apply(t,arguments)}}function Ao(t){var e={operator:void 0,rules:[]};if(!t)return e;var i,r,n=e,o=[];"("===(t=t.replace(/\(/g," ( ").replace(/\)/g," ) ").trim()).charAt(0)&&")"===t.substr(-1)&&(t=t.slice(1,-1).trim());for(var a,s=t.split(/\s+/),c=function(t){i={operator:t,rules:[]},void 0===n?(n=i,e=i):(n.rules.push(i),o.push(n),n=i)},u=function(t){r=n,void 0===(n=o.pop())&&(c(t),l(r))},l=function(t){n.rules.push(t)},h=0;h<s.length;++h){var p=s[h],d=p.toUpperCase();if("("!==p)if(")"!==p){if(a>0)if("NOT"===d)a=1;else if(1===a)a=2;else{if(2!==a)throw new Error("something went wrong with 'not'");a=!1,u()}if("AND"!==d)if("OR"!==d)if("NOT"!==p.toUpperCase()){var f=jf[d];if(void 0===f)if("HYDROGEN"!==d)if("SMALL"!==d)if("NUCLEOPHILIC"!==d)if("HYDROPHOBIC"!==d)if("AROMATIC"!==d)if("AMIDE"!==d)if("ACIDIC"!==d)if("BASIC"!==d)if("CHARGED"!==d)if("POLAR"!==d)if("NONPOLAR"!==d)if("CYCLIC"!==d)if("ALIPHATIC"!==d)if("SIDECHAINATTACHED"!==d)if("LIGAND"!==d)if(-1===Vf.indexOf(d))if("@"!==p.charAt(0))if("#"!==p.charAt(0))if("_"!==p.charAt(0))if("["!==p[0]||"]"!==p[p.length-1])if(p.length>=1&&p.length<=4&&"^"!==p[0]&&":"!==p[0]&&"."!==p[0]&&"%"!==p[0]&&"/"!==p[0]&&isNaN(parseInt(p)))l({resname:d});else{var m={operator:"AND",rules:[]},g=p.split("/");if(g.length>1&&g[1]){if(isNaN(parseInt(g[1])))throw new Error("model must be an integer");m.rules.push({model:parseInt(g[1])})}var v=g[0].split("%");v.length>1&&m.rules.push({altloc:v[1]});var y=v[0].split(".");if(y.length>1&&y[1]){if(y[1].length>4)throw new Error("atomname must be one to four characters");m.rules.push({atomname:y[1].substring(0,4).toUpperCase()})}var b=y[0].split(":");b.length>1&&b[1]&&m.rules.push({chainname:b[1]});var x=b[0].split("^");if(x.length>1&&m.rules.push({inscode:x[1]}),x[0]){var _=void 0,w=void 0;"-"===x[0][0]&&(x[0]=x[0].substr(1),_=!0),x[0].includes("--")&&(x[0]=x[0].replace("--","-"),w=!0);var S=x[0].split("-");if(1===S.length){if(S=parseInt(S[0]),isNaN(S))throw new Error("resi must be an integer");_&&(S*=-1),m.rules.push({resno:S})}else{if(2!==S.length)throw new Error("resi range must contain one '-'");_&&(S[0]*=-1),w&&(S[1]*=-1),m.rules.push({resno:[parseInt(S[0]),parseInt(S[1])]})}}if(1===m.rules.length)l(m.rules[0]);else{if(!(m.rules.length>1))throw new Error("empty selection chunk");l(m)}}else{var A=d.substr(1,p.length-2).split(","),M=A.length>1?A:A[0];l({resname:M})}else l({element:d.substr(1)});else console.error("# for element selection deprecated, use _"),l({element:d.substr(1)});else{for(var P=p.substr(1).split(","),E=0,T=P.length;E<T;++E)P[E]=parseInt(P[E]);P.sort(function(t,e){return t-e}),l({atomindex:P})}else l({keyword:jf.ALL});else l({operator:"AND",rules:[{operator:"OR",rules:[{operator:"AND",rules:[{keyword:jf.HETERO},{negate:!0,operator:void 0,rules:[{keyword:jf.POLYMER}]}]},{negate:!0,operator:void 0,rules:[{keyword:jf.POLYMER}]}]},{negate:!0,operator:void 0,rules:[{operator:"OR",rules:[{keyword:jf.WATER},{keyword:jf.ION}]}]}]});else l({operator:"OR",rules:[{keyword:jf.SIDECHAIN},{operator:"AND",negate:!1,rules:[{keyword:jf.PROTEIN},{operator:"OR",negate:!1,rules:[{atomname:"CA"},{atomname:"BB"}]}]},{operator:"AND",negate:!1,rules:[{resname:"PRO"},{atomname:"N"}]},{operator:"AND",negate:!1,rules:[{keyword:jf.NUCLEIC},{operator:"OR",negate:!0,rules:[{atomname:"P"},{atomname:"OP1"},{atomname:"OP2"},{atomname:"O3'"},{atomname:"O3*"},{atomname:"O5'"},{atomname:"O5*"},{atomname:"C5'"},{atomname:"C5*"}]}]}]});else l({resname:im});else l({resname:em});else l({resname:tm});else l({resname:Jf});else l({resname:Qf});else l({resname:Kf});else l({resname:Zf});else l({resname:Yf});else l({resname:qf});else l({resname:Xf});else l({resname:Wf});else l({resname:Hf});else l({element:"H"});else l({keyword:f})}else a=1,c(),n.negate=!0;else"AND"===n.operator?u("OR"):n.operator="OR";else if("OR"===n.operator){var C=n.rules.pop();c("AND"),l(C)}else n.operator="AND"}else u(),n.negate&&u();else a=!1,c()}return void 0===e.operator&&1===e.rules.length&&e.rules[0].hasOwnProperty("operator")&&(e=e.rules[0]),e}function Mo(t,e){if(void 0===e.atomname&&void 0===e.element&&void 0===e.altloc&&void 0===e.atomindex&&void 0===e.keyword&&void 0===e.inscode&&void 0===e.resname&&void 0===e.sstruc&&void 0===e.resno&&void 0===e.chainname&&void 0===e.model)return-1;if(void 0!==e.keyword){if(e.keyword===jf.BACKBONE&&!t.isBackbone())return!1;if(e.keyword===jf.SIDECHAIN&&!t.isSidechain())return!1;if(e.keyword===jf.BONDED&&!t.isBonded())return!1;if(e.keyword===jf.RING&&!t.isRing())return!1;if(e.keyword===jf.HETERO&&!t.isHetero())return!1;if(e.keyword===jf.PROTEIN&&!t.isProtein())return!1;if(e.keyword===jf.NUCLEIC&&!t.isNucleic())return!1;if(e.keyword===jf.RNA&&!t.isRna())return!1;if(e.keyword===jf.DNA&&!t.isDna())return!1;if(e.keyword===jf.POLYMER&&!t.isPolymer())return!1;if(e.keyword===jf.WATER&&!t.isWater())return!1;if(e.keyword===jf.HELIX&&!t.isHelix())return!1;if(e.keyword===jf.SHEET&&!t.isSheet())return!1;if(e.keyword===jf.TURN&&!t.isTurn())return!1;if(e.keyword===jf.ION&&!t.isIon())return!1;if(e.keyword===jf.SACCHARIDE&&!t.isSaccharide())return!1}if(void 0!==e.atomname&&e.atomname!==t.atomname)return!1;if(void 0!==e.element&&e.element!==t.element)return!1;if(void 0!==e.altloc&&e.altloc!==t.altloc)return!1;if(void 0!==e.atomindex&&Gn(e.atomindex,t.index)<0)return!1;if(void 0!==e.resname)if(Array.isArray(e.resname)){if(!e.resname.includes(t.resname))return!1}else if(e.resname!==t.resname)return!1;if(void 0!==e.sstruc&&e.sstruc!==t.sstruc)return!1;if(void 0!==e.resno)if(Array.isArray(e.resno)&&2===e.resno.length){if(e.resno[0]>t.resno||e.resno[1]<t.resno)return!1}else if(e.resno!==t.resno)return!1;return(void 0===e.inscode||e.inscode===t.inscode)&&((void 0===e.chainname||e.chainname===t.chainname)&&(void 0===e.model||e.model===t.modelIndex))}function Po(t,e){if(void 0===e.resname&&void 0===e.resno&&void 0===e.inscode&&void 0===e.sstruc&&void 0===e.model&&void 0===e.chainname&&void 0===e.atomindex&&(void 0===e.keyword||Gf.includes(e.keyword)))return-1;if(void 0!==e.keyword){if(e.keyword===jf.HETERO&&!t.isHetero())return!1;if(e.keyword===jf.PROTEIN&&!t.isProtein())return!1;if(e.keyword===jf.NUCLEIC&&!t.isNucleic())return!1;if(e.keyword===jf.RNA&&!t.isRna())return!1;if(e.keyword===jf.DNA&&!t.isDna())return!1;if(e.keyword===jf.POLYMER&&!t.isPolymer())return!1;if(e.keyword===jf.WATER&&!t.isWater())return!1;if(e.keyword===jf.HELIX&&!t.isHelix())return!1;if(e.keyword===jf.SHEET&&!t.isSheet())return!1;if(e.keyword===jf.TURN&&!t.isTurn())return!1;if(e.keyword===jf.ION&&!t.isIon())return!1;if(e.keyword===jf.SACCHARIDE&&!t.isSaccharide())return!1}if(void 0!==e.atomindex&&0===Wn(e.atomindex,t.atomOffset,t.atomEnd))return!1;if(void 0!==e.resname)if(Array.isArray(e.resname)){if(!e.resname.includes(t.resname))return!1}else if(e.resname!==t.resname)return!1;if(void 0!==e.sstruc&&e.sstruc!==t.sstruc)return!1;if(void 0!==e.resno)if(Array.isArray(e.resno)&&2===e.resno.length){if(e.resno[0]>t.resno||e.resno[1]<t.resno)return!1}else if(e.resno!==t.resno)return!1;return(void 0===e.inscode||e.inscode===t.inscode)&&((void 0===e.chainname||e.chainname===t.chainname)&&(void 0===e.model||e.model===t.modelIndex))}function Eo(t,e){if(!(void 0!==e.chainname||void 0!==e.model||void 0!==e.atomindex||void 0!==e.keyword&&$f.includes(e.keyword)&&t.entity))return-1;if(void 0!==e.keyword){if(e.keyword===jf.POLYMER&&!t.entity.isPolymer())return!1;if(e.keyword===jf.WATER&&!t.entity.isWater())return!1}return(void 0===e.atomindex||0!==Wn(e.atomindex,t.atomOffset,t.atomEnd))&&((void 0===e.chainname||e.chainname===t.chainname)&&(void 0===e.model||e.model===t.modelIndex))}function To(t,e){return void 0===e.model&&void 0===e.atomindex?-1:(void 0===e.atomindex||0!==Wn(e.atomindex,t.atomOffset,t.atomEnd))&&(void 0===e.model||e.model===t.index)}function Co(t,e){if(null===t)return!1;if(t.error)return!1;var i=t.rules.length;if(0===i)return!1;for(var r=!t.negate,n=!!t.negate,o=[],a=0;a<i;++a){var s=t.rules[a];s.hasOwnProperty("operator")&&(o[a]=Co(s,e))}return function(a){for(var s="AND"===t.operator,c=!1,u=0;u<i;++u){var l=t.rules[u],h=void 0;if(l.hasOwnProperty("operator")){if(-1===(h=o[u]?o[u](a):-1)){c=!0;continue}if(!0===h){if(s)continue;return r}if(s)return n}else{if(l.keyword===jf.ALL){if(s)continue;return r}if(-1!==(h=e(a,l))){if(!0===h){if(s)continue;return r}if(s)return n}else c=!0}}return c?-1:s?r:n}}function Io(t,e){if(t.error)return t;var i=t.rules.length;if(0===i)return t;var r={operator:t.operator,rules:[]};t.hasOwnProperty("negate")&&(r.negate=t.negate);for(var n=0;n<i;++n){var o=t.rules[n];if(o.hasOwnProperty("operator")){var a=Io(o,e);null!==a&&r.rules.push(a)}else e(o)||r.rules.push(o)}return r.rules.length>0?t:null}function Ro(t,e){return e&&(t=Io(t,function(t){return void 0!==t.keyword&&!Gf.includes(t.keyword)||(void 0!==t.model||(void 0!==t.chainname||(void 0!==t.resname||(void 0!==t.resno||void 0!==t.sstruc))))})),Co(t,Mo)}function Lo(t,e){return e&&(t=Io(t,function(t){return!(void 0===t.keyword||!Gf.includes(t.keyword))||(void 0!==t.model||(void 0!==t.chainname||(void 0!==t.atomname||(void 0!==t.element||void 0!==t.altloc))))})),Co(t,Po)}function Oo(t,e){return e&&(t=Io(t,function(t){return void 0!==t.keyword&&!$f.includes(t.keyword)||(void 0!==t.resname||(void 0!==t.resno||(void 0!==t.atomname||(void 0!==t.element||(void 0!==t.altloc||(void 0!==t.sstruc||void 0!==t.inscode))))))})),Co(t,Eo)}function Do(t,e){return e&&(t=Io(t,function(t){return void 0!==t.keyword||(void 0!==t.chainname||(void 0!==t.resname||(void 0!==t.resno||(void 0!==t.atomname||(void 0!==t.element||(void 0!==t.altloc||(void 0!==t.sstruc||void 0!==t.inscode)))))))})),Co(t,To)}function No(t){var e=t;return t.forEach(function(t){t.__deps&&Array.prototype.push.apply(e,No(t.__deps))}),e}function ko(t){return Xn(No(t)).map(function(t){return t.toString()}).join("\n\n\n")}function Bo(t){var e=t.data.__name,i=t.data.__postId;if(void 0===e)console.error("message __name undefined");else if(void 0===self.func)console.error("worker func undefined",e);else{self.func(t,function(t,e){t=t||{},void 0!==i&&(t.__postId=i);try{self.postMessage(t,e)}catch(e){console.error("self.postMessage:",e),self.postMessage(t)}})}}function Fo(t,e){var i="'use strict';\n\n"+ko(e);return i+="\n\n\nself.func = "+t.toString()+";",i+="\n\n\nself.onmessage = "+Bo.toString()+";",new window.Blob([i],{type:"application/javascript"})}function zo(t){mm=t}function Uo(t){gm=t}function jo(t){var e=jn(t),i=wm.get(e.protocol);return i&&!(e=jn(i.getUrl(e.src))).ext&&i.getExt&&(e.ext=i.getExt(t)),e}function Vo(t,e){var i,r=Object.assign(jo(t),e);return Am.names.includes(r.ext)?i=Nm:bm.includes(r.ext)?i=Fm:"plugin"===r.ext&&(i=zm),i?new i(r.src,r).load():Promise.reject(new Error("autoLoad: ext '"+r.ext+"' unknown"))}function Go(t){return $o(Ho(t),arguments)}function $o(t,e){var i,r,n,o,a,s,c,u,l,h=1,p=t.length,d="";for(r=0;r<p;r++)if("string"==typeof t[r])d+=t[r];else if("object"==typeof t[r]){if((o=t[r]).keys)for(i=e[h],n=0;n<o.keys.length;n++){if(!i.hasOwnProperty(o.keys[n]))throw new Error(Go('[sprintf] property "%s" does not exist',o.keys[n]));i=i[o.keys[n]]}else i=o.param_no?e[o.param_no]:e[h++];if(Vm.not_type.test(o.type)&&Vm.not_primitive.test(o.type)&&i instanceof Function&&(i=i()),Vm.numeric_arg.test(o.type)&&"number"!=typeof i&&isNaN(i))throw new TypeError(Go("[sprintf] expecting number but found %T",i));switch(Vm.number.test(o.type)&&(u=i>=0),o.type){case"b":i=parseInt(i,10).toString(2);break;case"c":i=String.fromCharCode(parseInt(i,10));break;case"d":case"i":i=parseInt(i,10);break;case"j":i=JSON.stringify(i,null,o.width?parseInt(o.width):0);break;case"e":i=o.precision?parseFloat(i).toExponential(o.precision):parseFloat(i).toExponential();break;case"f":i=o.precision?parseFloat(i).toFixed(o.precision):parseFloat(i);break;case"g":i=o.precision?String(Number(i.toPrecision(o.precision))):parseFloat(i);break;case"o":i=(parseInt(i,10)>>>0).toString(8);break;case"s":i=String(i),i=o.precision?i.substring(0,o.precision):i;break;case"t":i=String(!!i),i=o.precision?i.substring(0,o.precision):i;break;case"T":i=Object.prototype.toString.call(i).slice(8,-1).toLowerCase(),i=o.precision?i.substring(0,o.precision):i;break;case"u":i=parseInt(i,10)>>>0;break;case"v":i=i.valueOf(),i=o.precision?i.substring(0,o.precision):i;break;case"x":i=(parseInt(i,10)>>>0).toString(16);break;case"X":i=(parseInt(i,10)>>>0).toString(16).toUpperCase()}Vm.json.test(o.type)?d+=i:(!Vm.number.test(o.type)||u&&!o.sign?l="":(l=u?"+":"-",i=i.toString().replace(Vm.sign,"")),s=o.pad_char?"0"===o.pad_char?"0":o.pad_char.charAt(1):" ",c=o.width-(l+i).length,a=o.width&&c>0?s.repeat(c):"",d+=o.align?l+i+a:"0"===s?l+a+i:a+l+i)}return d}function Ho(t){if(Gm[t])return Gm[t];for(var e,i=t,r=[],n=0;i;){if(null!==(e=Vm.text.exec(i)))r.push(e[0]);else if(null!==(e=Vm.modulo.exec(i)))r.push("%");else{if(null===(e=Vm.placeholder.exec(i)))throw new SyntaxError("[sprintf] unexpected placeholder");if(e[2]){n|=1;var o=[],a=e[2],s=[];if(null===(s=Vm.key.exec(a)))throw new SyntaxError("[sprintf] failed to parse named argument key");for(o.push(s[1]);""!==(a=a.substring(s[0].length));)if(null!==(s=Vm.key_access.exec(a)))o.push(s[1]);else{if(null===(s=Vm.index_access.exec(a)))throw new SyntaxError("[sprintf] failed to parse named argument key");o.push(s[1])}e[2]=o}else n|=2;if(3===n)throw new Error("[sprintf] mixing positional and named placeholders is not (yet) supported");r.push({placeholder:e[0],param_no:e[1],keys:e[2],sign:e[3],pad_char:e[4],align:e[5],width:e[6],precision:e[7],type:e[8]})}i=i.substring(e[0].length)}return Gm[t]=r}function Wo(){this.signals={updated:new So},this.begin(),this.maxDuration=-1/0,this.minDuration=1/0,this.avgDuration=14,this.lastDuration=1/0,this.prevFpsTime=0,this.lastFps=1/0,this.lastFrames=1,this.frames=0,this.count=0}function Xo(t){if(void 0===t)return"";var e=[];for(var i in t){var r=t[i];!1!==r&&e.push("#define "+i+" "+r)}return e.join("\n")+"\n"}function qo(t,e){e=e||{};var i=t+"|";for(var r in e)i+=r+":"+e[r];if(!Km[i]){var n=Xo(e),o=Mm.get("shader/"+t);if(!o)throw new Error("empty shader, '"+t+"'");o=o.replace(Zm,function(t,e){var i="shader/chunk/"+e+".glsl";return Mm.get(i)||kp[e]||""}),Km[i]=n+o}return Km[i]}function Yo(t,e,i,r){function n(e){var r=e%s,n=Math.floor(e/s),o=r*d,a=n*f;i.camera.setViewOffset(d*s,f*s,o,a,d,f),i.render(),c?m.drawImage(t.domElement,Math.floor(o/2),Math.floor(a/2),Math.ceil(d/2),Math.ceil(f/2)):m.drawImage(t.domElement,Math.floor(o),Math.floor(a),Math.ceil(d),Math.ceil(f)),"function"==typeof u&&u(e+1,h,!1)}function o(){i.setSampling(g),i.camera.view=null,"function"==typeof l&&l(h+1,h,!1)}var a=r||{},s=void 0!==a.factor?a.factor:2,c=void 0!==a.antialias&&a.antialias,u=a.onProgress,l=a.onFinish;c&&(s*=2);var h=s*s,p=document.createElement("canvas"),d=i.width,f=i.height;c?(p.width=d*s/2,p.height=f*s/2):(p.width=d*s,p.height=f*s);var m=p.getContext("2d"),g=i.sampleLevel;i.setSampling(-1),this.render=function(){for(var t=0;t<=h;++t)t===h?o():n(t)},this.renderAsync=function(){for(var t=0,e=0;e<=h;++e)setTimeout(function(){t===h?o():n(t),t+=1},0)},this.canvas=p}function Zo(t,e,i,r,n){i=i||1,r=r||0;var o,a,s=n?n.length:t.length/i,c=0,u=0;if(n)for(a=0;a<s;++a)o=(t[n[a]*i+r]+e)%e/e*ng-Math.PI,c+=Math.cos(o),u+=Math.sin(o);else for(a=r;a<s;a+=i)o=(t[a]+e)%e/e*ng-Math.PI,c+=Math.cos(o),u+=Math.sin(o);return c/=s,u/=s,(Math.atan2(u,c)+Math.PI)/ng*e}function Ko(t,e,i,r){var n=t.length;i=i||new Float32Array(n),r=r||0;for(var o=0;o<n;o+=3)i[r+o+0]=(t[o+0]+e[o+0])/2,i[r+o+1]=(t[o+1]+e[o+1])/2,i[r+o+2]=(t[o+2]+e[o+2])/2;return i}function Qo(t,e,i){for(var r=i||new Float32Array(t),n=0;n<t;++n)r[n]=e;return r}function Jo(t,e,i,r,n){for(var o,a=n||new Float32Array(3*t),s=0;s<t;++s)a[(o=3*s)+0]=e,a[o+1]=i,a[o+2]=r;return a}function ta(t,e){var i=t.length;e=e||new v;for(var r=0;r<i;r+=3)e.x+=t[r],e.y+=t[r+1],e.z+=t[r+2];return e.divideScalar(i/3),e}function ea(t){for(var e=new Float32Array(t),i=0;i<t;++i)e[i]=i;return e}function ia(t,e,i,r){void 0===i&&(i=0);for(var n=r||new Float32Array(t*e),o=0;o<t;++o)for(var a=i+o*e,s=0;s<e;++s)n[a+s]=o;return n}function ra(t,e){for(var i=t.length,r=new Float32Array(i),n=0;n<i;n++)r[n]=Math.min(t[n],e[n]);return r}function na(t,e,i,r,n){for(var o=0;o<n;++o)e[r+o]=t[i+o]}function oa(t,e,i,r){na(t,t,e,i,r)}function aa(t,e,i,r){function n(e,i){p=t[e],t[e]=t[i],t[i]=p}e=e||function(t,e){return t>e?1:t<e?-1:0};for(var o,a,s=[],c=-1,u=i=i||0,l=r=(r||t.length)-1,h=0,p=0;;)if(l-u<=25){for(a=u+1;a<=l;++a){for(h=t[a],o=a-1;o>=u&&e(t[o],h)>0;)t[o+1]=t[o],--o;t[o+1]=h}if(-1===c)break;l=s[c--],u=s[c--]}else{for(a=l,n(u+l>>1,o=u+1),e(t[u],t[l])>0&&n(u,l),e(t[o],t[l])>0&&n(o,l),e(t[u],t[o])>0&&n(u,o),h=t[o];;){do{o++}while(e(t[o],h)<0);do{a--}while(e(t[a],h)>0);if(a<o)break;n(o,a)}t[u+1]=t[a],t[a]=h,l-o+1>=a-u?(s[++c]=o,s[++c]=l,l=a-1):(s[++c]=u,s[++c]=a-1,u=o)}return t}function sa(t){for(var e=-1/0,i=0,r=t.length;i<r;++i)t[i]>e&&(e=t[i]);return e}function ca(t){for(var e=1/0,i=0,r=t.length;i<r;++i)t[i]<e&&(e=t[i]);return e}function ua(t,e,i){e=e||1,i=i||0;for(var r=t.length,n=0,o=i;o<r;o+=e)n+=t[o];return n}function la(t,e,i){return ua(t,e,i)/(t.length/(e||1))}function ha(t){for(var e=t.length,i=0,r=0;r<e;++r){var n=t[r];i+=n*n}return Math.sqrt(i/e)}function pa(t,e,i,r,n){var o,a,s,c,u=t.height,l=t.width,h=t.getContext("2d").getImageData(0,0,l,u).data;for(s=!1,a=0;a<u;a++){for(o=0;o<l;o++)if(c=4*(a*l+o),h[c]!==e||h[c+1]!==i||h[c+2]!==r||h[c+3]!==n){s=!0;break}if(s)break}var p=a;for(s=!1,o=0;o<l;o++){for(a=0;a<u;a++)if(c=4*(a*l+o),h[c]!==e||h[c+1]!==i||h[c+2]!==r||h[c+3]!==n){s=!0;break}if(s)break}var d=o;for(s=!1,a=u-1;a>=0;a--){for(o=l-1;o>=0;o--)if(c=4*(a*l+o),h[c]!==e||h[c+1]!==i||h[c+2]!==r||h[c+3]!==n){s=!0;break}if(s)break}var f=a;for(s=!1,o=l-1;o>=0;o--){for(a=u-1;a>=0;a--)if(c=4*(a*l+o),h[c]!==e||h[c+1]!==i||h[c+2]!==r||h[c+3]!==n){s=!0;break}if(s)break}var m=o,g=document.createElement("canvas");return g.width=m-d,g.height=f-p,g.getContext("2d").drawImage(t,d,p,g.width,g.height,0,0,g.width,g.height),g}function da(t,e){function i(e){var i=s;c&&(i*=2),e&&(i=1/i),t.scene.traverse(function(t){var e=t.material;e&&e.linewidth&&(e.linewidth*=i),e&&e.uniforms&&e.uniforms.size&&void 0===e.uniforms.size.__seen&&(e.uniforms.size.value*=i,e.uniforms.size.__seen=!0),e&&e.uniforms&&e.uniforms.linewidth&&void 0===e.uniforms.linewidth.__seen&&(e.uniforms.linewidth.value*=i,e.uniforms.linewidth.__seen=!0)}),t.scene.traverse(function(t){var e=t.material;e&&e.uniforms&&e.uniforms.size&&delete e.uniforms.size.__seen,e&&e.uniforms&&e.uniforms.linewidth&&delete e.uniforms.linewidth.__seen})}function r(t){if(a){var e=d;return pa(t,u?0:255*e.r,u?0:255*e.g,u?0:255*e.b,u?0:255)}return t}function n(t,e,i){"function"==typeof o.onProgress&&o.onProgress(t,e,i)}var o=e||{},a=Nn(o.trim,!1),s=Nn(o.factor,1),c=Nn(o.antialias,!1),u=Nn(o.transparent,!1),l=t.renderer,h=t.camera,p=l.getClearAlpha(),d=l.getClearColor();return new Promise(function(e){var o=new Yo(l,h,t,{factor:s,antialias:c,onProgress:n,onFinish:function(a,s){r(o.canvas).toBlob(function(r){l.setClearAlpha(p),i(!0),t.requestRender(),n(s,s,!0),e(r)},"image/png")}});l.setClearAlpha(u?0:1),i(),o.renderAsync()})}function fa(t,e){t.traverseVisible(function(t){if(t instanceof Xe&&t.sortParticles){var i=t.geometry.attributes,r=i.position.count;if(0!==r){sg.multiplyMatrices(e.matrixWorldInverse,t.matrixWorld),cg.multiplyMatrices(e.projectionMatrix,sg);var n,o,a,s;t.userData.sortData?(n=t.userData.sortData,a=n.__zArray,o=n.__sortArray,s=n.__cmpFn):(a=new Float32Array(r),o=new Uint32Array(r),n={__zArray:a,__sortArray:o,__cmpFn:s=function(t,e){var i=a[t],r=a[e];return i>r?1:i<r?-1:0}},t.userData.sortData=n);for(var c=0;c<r;++c)ag.fromArray(i.position.array,3*c),ag.applyMatrix4(cg),a[c]=-ag.z,o[c]=c;aa(o,s);var u,l,h;for(var p in i){var d=i[p],f=d.array,m=d.itemSize;n[p]||(n[p]=new Float32Array(m*r)),h=n[p],n[p]=f;for(var g=0;g<r;++g){u=o[g];for(var v=0;v<m;++v)l=u*m+v,h[g*m+v]=f[l]}i[p].array=h,i[p].needsUpdate=!0}}}})}function ma(t,e,i,r,n){var o=i.getSize(),a=o.width,s=o.height,c=s,u=i.getPixelRatio(),l="OrthographicCamera"===e.type;ug.set(a,s),lg.getInverse(e.projectionMatrix),hg.copy(e.projectionMatrix).transpose(),t.traverse(function(t){var e=t.material;if(e){var i=t.material.uniforms;if(i){if(e.clipNear){var o=(50-e.clipNear)/50,a=r-n*o;i.nearClip.value=a}i.canvasHeight&&(i.canvasHeight.value=c),i.resolution&&i.resolution.value.copy(ug),i.pixelRatio&&(i.pixelRatio.value=u),i.projectionMatrixInverse&&i.projectionMatrixInverse.value.copy(lg),i.projectionMatrixTranspose&&i.projectionMatrixTranspose.value.copy(hg),i.ortho&&(i.ortho.value=l)}}})}function ga(t,e){var i=t.createTexture();t.bindTexture(t.TEXTURE_2D,i),t.texImage2D(t.TEXTURE_2D,0,t.RGBA,1,1,0,t.RGBA,e,null),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_MIN_FILTER,t.NEAREST),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_MAG_FILTER,t.NEAREST);var r=t.createFramebuffer();return t.bindFramebuffer(t.FRAMEBUFFER,r),t.framebufferTexture2D(t.FRAMEBUFFER,t.COLOR_ATTACHMENT0,t.TEXTURE_2D,i,0),t.checkFramebufferStatus(t.FRAMEBUFFER)===t.FRAMEBUFFER_COMPLETE}function va(t,e,i,r,n){var o=n.uniforms,a=[];if(o.objectId&&(o.objectId.value=mm?this.id:this.id/255,a.push("objectId")),(o.modelViewMatrixInverse||o.modelViewMatrixInverseTranspose||o.modelViewProjectionMatrix||o.modelViewProjectionMatrixInverse)&&this.modelViewMatrix.multiplyMatrices(i.matrixWorldInverse,this.matrixWorld),o.modelViewMatrixInverse&&(o.modelViewMatrixInverse.value.getInverse(this.modelViewMatrix),a.push("modelViewMatrixInverse")),o.modelViewMatrixInverseTranspose&&(o.modelViewMatrixInverse?o.modelViewMatrixInverseTranspose.value.copy(o.modelViewMatrixInverse.value).transpose():o.modelViewMatrixInverseTranspose.value.getInverse(this.modelViewMatrix).transpose(),a.push("modelViewMatrixInverseTranspose")),o.modelViewProjectionMatrix&&(i.updateProjectionMatrix(),o.modelViewProjectionMatrix.value.multiplyMatrices(i.projectionMatrix,this.modelViewMatrix),a.push("modelViewProjectionMatrix")),o.modelViewProjectionMatrixInverse&&(o.modelViewProjectionMatrix?(fg.copy(o.modelViewProjectionMatrix.value),o.modelViewProjectionMatrixInverse.value.getInverse(fg)):(i.updateProjectionMatrix(),fg.multiplyMatrices(i.projectionMatrix,this.modelViewMatrix),o.modelViewProjectionMatrixInverse.value.getInverse(fg)),a.push("modelViewProjectionMatrixInverse")),a.length){var s=t.properties.get(n);if(s.program){var c=t.getContext(),u=s.program;c.useProgram(u.program);var l=u.getUniforms();a.forEach(function(t){l.setValue(c,t,o[t].value)})}}}function ya(e){function i(){j||(j=new De),($=new qe).name="rotationGroup",j.add($),(H=new qe).name="translationGroup",$.add(H),(W=new qe).name="modelGroup",H.add(W),(X=new qe).name="pickingGroup",H.add(X),(q=new qe).name="backgroundGroup",H.add(q),(Y=new qe).name="helperGroup",H.add(Y),j.fog=new Oe,V=new Ji(k.lightColor,k.lightIntensity),j.add(V),G=new rr(k.ambientLight,k.ambientIntensity),j.add(G)}function r(){var t=at.geometry.attributes.position,e=t.array,i=ct.min,r=ct.max;e[0]=r.x,e[1]=r.y,e[2]=r.z,e[3]=i.x,e[4]=r.y,e[5]=r.z,e[6]=i.x,e[7]=i.y,e[8]=r.z,e[9]=r.x,e[10]=i.y,e[11]=r.z,e[12]=r.x,e[13]=r.y,e[14]=i.z,e[15]=i.x,e[16]=r.y,e[17]=i.z,e[18]=i.x,e[19]=i.y,e[20]=i.z,e[21]=r.x,e[22]=i.y,e[23]=i.z,t.needsUpdate=!0,ct.isEmpty()||at.geometry.computeBoundingSphere()}function n(t,e){function i(r){r instanceof qe?r.children.forEach(i):(r.userData.buffer=t,r.userData.instance=e,r.onBeforeRender=va)}var r=t.getMesh();e&&r.applyMatrix(e.matrix),i(r),t.group.add(r);var n=t.getWireframeMesh();if(e&&(n.matrix.copy(r.matrix),n.position.copy(r.position),n.quaternion.copy(r.quaternion),n.scale.copy(r.scale)),i(n),t.wireframeGroup.add(n),t.pickable){var a=t.getPickingMesh();e&&(a.matrix.copy(r.matrix),a.position.copy(r.position),a.quaternion.copy(r.quaternion),a.scale.copy(r.scale)),i(a),t.pickingGroup.add(a)}e?o(t.geometry,t.matrix,e.matrix):o(t.geometry,t.matrix)}function o(t,e,i){function r(t,e,i){t.boundingBox||t.computeBoundingBox();var r=t.boundingBox.clone();e&&r.applyMatrix4(e),i&&r.applyMatrix4(i),r.min.equals(r.max)&&r.expandByScalar(5),ct.union(r)}function n(t){if(void 0!==t.geometry){var e,i;t.userData.buffer&&(e=t.userData.buffer.matrix),t.userData.instance&&(i=t.userData.instance.matrix),r(t.geometry,e,i)}}t?r(t,e,i):(ct.makeEmpty(),W.traverse(n),q.traverse(n)),ct.getSize(ut),ht=ut.length()}function a(){var t=M*P*4,e=mm?new Float32Array(t):new Uint8Array(t);return S(!0),Z.readRenderTargetPixels(Q,0,0,M,P,e),e}function s(t,e,i){var r=k;void 0!==t&&r.fogColor.set(t),void 0!==e&&(r.fogNear=e),void 0!==i&&(r.fogFar=i),p()}function c(t){var e=k;t&&e.backgroundColor.set(t),s(e.backgroundColor),Z.setClearColor(e.backgroundColor,0),Z.domElement.style.backgroundColor=e.backgroundColor.getStyle(),p()}function u(t,e){M=t||1,P=e||1,F.aspect=M/P,z.left=-M/2,z.right=M/2,z.top=P/2,z.bottom=-P/2,U.updateProjectionMatrix();var i=window.devicePixelRatio;Z.setPixelRatio(i),Z.setSize(M,P);var r=M*i,n=P*i;Q.setSize(r,n),J.setSize(r,n),tt.setSize(r,n),p()}function l(t){var e=dt.memory,i=dt.render;if(t)e.programs=0,e.geometries=0,e.textures=0,i.calls=0,i.vertices=0,i.faces=0,i.points=0;else{var r=Z.info,n=r.memory,o=r.render;e.programs=n.programs,e.geometries=n.geometries,e.textures=n.textures,i.calls+=o.calls,i.vertices+=o.vertices,i.faces+=o.faces,i.points+=o.points}}function h(){if(E.ticked.dispatch(B),window.performance.now()-B.startTime>500&&!L&&O<3&&-1!==O){var e=O;O=3,I=!0,S(),L=!0,O=e,t.Debug&&vm.log("rendered still frame")}window.requestAnimationFrame(h)}function p(){I||(window.performance.now()-B.startTime>22&&(B.begin(),L=!1),I=!0,window.requestAnimationFrame(function(){S(),B.update()}))}function d(){var t=co(F.fov),e=2*Math.tan(t/2)*-U.position.z;z.zoom=P/e}function m(){var t=k;(D=pt.copy(U.position).length())||(U.position.set(0,0,t.cameraZ),D=Math.abs(t.cameraZ)),N=Math.max(10,.5*ht),((N+=ct.getCenter(pt).length())===1/0||N===-1/0||isNaN(N))&&(N=50);var e=(50-t.clipNear)/50,i=-(50-t.clipFar)/50;U.near=D-N*e,U.far=D+N*i;var r=(50-t.fogNear)/50,n=-(50-t.fogFar)/50,o=j.fog;o.color.set(t.fogColor),o.near=D-N*r,o.far=D+N*n,"PerspectiveCamera"===U.type?(U.near=Math.max(.1,t.clipDist,U.near),U.far=Math.max(1,U.far),o.near=Math.max(.1,o.near),o.far=Math.max(1,o.far)):"OrthographicCamera"===U.type&&0===t.clipNear&&t.clipDist>0&&D+U.zoom>2*-t.clipDist&&(U.near+=U.zoom+t.clipDist)}function g(){U.updateMatrix(),U.updateMatrixWorld(!0),U.matrixWorldInverse.getInverse(U.matrixWorld),U.updateProjectionMatrix(),ma(j,U,Z,D,N),fa(j,U)}function y(t,e,i,r){W.visible=t,X.visible=e,q.visible=i,Y.visible=r}function b(){pt.copy(U.position).setLength(100*ht),V.position.copy(U.position).add(pt),V.color.set(k.lightColor),V.intensity=k.lightIntensity,G.color.set(k.ambientColor),G.intensity=k.ambientIntensity}function x(){Z.clearTarget(Q),y(!1,!0,!1,!1),Z.render(j,U,Q),l(),Z.setRenderTarget(null)}function _(e){e?Z.clearTarget(e):Z.clear(),y(!1,!1,!0,!1),Z.render(j,U,e),e?Z.clearTarget(e,!1,!0,!1):Z.clearDepth(),l(),y(!0,!1,!1,t.Debug),Z.render(j,U,e),l()}function w(){var t=rg[Math.max(0,Math.min(O,5))],e=1/t.length;it.tForeground.value=J.texture;for(var i=J.width,r=J.height,n=0;n<t.length;++n){var o=t[n];U.setViewOffset(i,r,o[0],o[1],i,r),g();var a=e;a+=1/32*((n+.5)/t.length-.5),it.scale.value=a,_(J),Z.render(ot,nt,tt,0===n)}it.scale.value=1,it.tForeground.value=tt.texture,Z.render(ot,nt,null,!0),U.view=null}function S(t){C?vm.warn("'tried to call 'render' from within 'render'"):(C=!0,m(),g(),b(),l(!0),t?R||x():O>0?w():_(),R=t,C=!1,I=!1)}var A,M,P,E={ticked:new So};if((A="string"==typeof e?document.getElementById(e):e instanceof window.Element?e:document.createElement("div"))===document.body)M=window.innerWidth||1,P=window.innerHeight||1;else{var T=A.getBoundingClientRect();M=T.width||1,P=T.height||1}var C,I,R,L,O,D,N,k;k={fogColor:new et(0),fogNear:50,fogFar:100,backgroundColor:new et(0),cameraType:"perspective",cameraFov:40,cameraZ:-80,clipNear:0,clipFar:100,clipDist:10,lightColor:new et(14540253),lightIntensity:1,ambientColor:new et(14540253),ambientIntensity:.2,sampleLevel:0};var B;B=new Wo;var F,z,U;!function(){var t=new v(0,0,0);(F=new wt(k.cameraFov,M/P)).position.z=k.cameraZ,F.lookAt(t),(z=new _t(M/-2,M/2,P/2,P/-2)).position.z=k.cameraZ,z.lookAt(t),(U="orthographic"===k.cameraType?z:F).updateProjectionMatrix()}();var j,V,G,$,H,W,X,q,Y;i();var Z,K,Q,J,tt,it,rt,nt,ot;if(!1===function(){var t=window.devicePixelRatio;try{Z=new Re({preserveDrawingBuffer:!0,alpha:!0,antialias:!0})}catch(t){return A.innerHTML=ym,!1}Z.setPixelRatio(t),Z.setSize(M,P),Z.autoClear=!1,Z.sortObjects=!0;var e=Z.getContext();Uo(Z.extensions.get("EXT_frag_depth")),Z.extensions.get("OES_element_index_uint"),zo("Safari"!==hm&&(Z.extensions.get("OES_texture_float")&&Z.extensions.get("WEBGL_color_buffer_float")||Z.extensions.get("OES_texture_float")&&ga(e,e.FLOAT))),A.appendChild(Z.domElement);var i=M*t,r=P*t;Z.extensions.get("OES_texture_float"),K=Z.extensions.get("OES_texture_half_float")&&ga(e,36193),Z.extensions.get("WEBGL_color_buffer_float"),(Q=new f(i,r,{minFilter:Ih,magFilter:Ih,stencilBuffer:!1,format:Zh,type:mm?Vh:kh})).texture.generateMipmaps=!1,Z.clearTarget(Q),Z.setRenderTarget(null),J=new f(i,r,{minFilter:Oh,magFilter:Oh,format:Zh}),tt=new f(i,r,{minFilter:Ih,magFilter:Ih,format:Zh,type:K?Gh:mm?Vh:kh}),rt=new st({uniforms:it={tForeground:{type:"t",value:null},scale:{type:"f",value:1}},vertexShader:qo("Quad.vert"),fragmentShader:qo("Quad.frag"),premultipliedAlpha:!0,transparent:!0,blending:Fl,depthTest:!1,depthWrite:!1}),nt=new _t(-1,1,1,-1,0,1),ot=(new De).add(new Xt(new jt(2,2),rt))}())return this.container=A,void vm.error("Viewer: could not initialize renderer");var at,ct=new lt,ut=new v,ht=0;!function(){var t=new Uint16Array([0,1,1,2,2,3,3,0,4,5,5,6,6,7,7,4,0,4,1,5,2,6,3,7]),e=new Float32Array(24),i=new Ft;i.setIndex(new Pt(t,1)),i.addAttribute("position",new Pt(e,3));var r=new st({uniforms:{uColor:{value:new et("skyblue")}},vertexShader:qo("BasicLine.vert"),fragmentShader:qo("BasicLine.frag"),linewidth:2});at=new $e(i,r),Y.add(at)}(),c(),s();var pt=new v,dt={memory:{programs:0,geometries:0,textures:0},render:{calls:0,vertices:0,faces:0,points:0}};this.container=A,this.stats=B,this.signals=E,this.rotationGroup=$,this.translationGroup=H,this.add=function(e,i){i?i.forEach(function(t){n(e,t)}):n(e),e.background?(q.add(e.group),q.add(e.wireframeGroup)):(W.add(e.group),W.add(e.wireframeGroup)),e.pickable&&X.add(e.pickingGroup),t.Debug&&r()},this.remove=function(e){H.children.forEach(function(t){t.remove(e.group),t.remove(e.wireframeGroup)}),e.pickable&&X.remove(e.pickingGroup),o(),t.Debug&&r()},this.clear=function(){vm.log("scene cleared"),j.remove($),i(),Z.clear()},this.getPickingPixels=a,this.getImage=function(t){return new Promise(function(e){if(t){var i=M*P*4,r=a();if(mm){for(var n=new Uint8Array(i),o=0;o<i;++o)n[o]=Math.round(255*r[o]);r=n}var s=document.createElement("canvas");s.width=M,s.height=P;var c=s.getContext("2d"),u=c.getImageData(0,0,M,P);u.data.set(r),c.putImageData(u,0,0),s.toBlob(e,"image/png")}else Z.domElement.toBlob(e,"image/png")})},this.makeImage=function(t){return da(this,t)},this.setLight=function(t,e,i,r){var n=k;void 0!==t&&n.lightColor.set(t),void 0!==e&&(n.lightIntensity=e),void 0!==i&&n.ambientColor.set(i),void 0!==r&&(n.ambientIntensity=r),p()},this.setFog=s,this.setBackground=c,this.setSampling=function(t){void 0!==t&&(k.sampleLevel=t,O=t),p()},this.setCamera=function(t,e){var i=k;t&&(i.cameraType=t),e&&(i.cameraFov=e),"orthographic"===i.cameraType?U!==z&&((U=z).position.copy(F.position),U.up.copy(F.up),d()):U!==F&&((U=F).position.copy(z.position),U.up.copy(z.up)),F.fov=i.cameraFov,U.updateProjectionMatrix(),p()},this.setClip=function(t,e,i){var r=k;void 0!==t&&(r.clipNear=t),void 0!==e&&(r.clipFar=e),void 0!==i&&(r.clipDist=i),p()},this.setSize=u,this.handleResize=function(){if(A===document.body)u(window.innerWidth,window.innerHeight);else{var t=A.getBoundingClientRect();u(t.width,t.height)}},this.pick=function(t,e){t*=window.devicePixelRatio,e*=window.devicePixelRatio;var i,r,n,o=mm?pg:dg;S(!0),Z.readRenderTargetPixels(Q,t,e,1,1,o),i=mm?Math.round(255*o[0])<<16&16711680|Math.round(255*o[1])<<8&65280|255&Math.round(255*o[2]):o[0]<<16|o[1]<<8|o[2];var a=Math.round(o[3]),s=X.getObjectById(a);return s&&(r=s.userData.instance,n=s.userData.buffer.picking),{pid:i,instance:r,picker:n}},this.requestRender=p,this.render=S,this.animate=h,this.updateZoom=d,this.updateHelper=r,this.renderer=Z,this.scene=j,this.perspectiveCamera=F,this.boundingBox=ct,this.updateBoundingBox=function(){o(),t.Debug&&r()},Object.defineProperties(this,{camera:{get:function(){return U}},width:{get:function(){return M}},height:{get:function(){return P}},sampleLevel:{get:function(){return O}}})}function ba(t){var e=t.touches[0].pageX-t.touches[1].pageX,i=t.touches[0].pageY-t.touches[1].pageY;return Math.sqrt(e*e+i*i)}function xa(t){if("object"==typeof t){if("buttons"in t)return t.buttons;if("which"in t){var e=t.which;if(2===e)return 4;if(3===e)return 2;if(e>0)return 1<<e-1}else if("button"in t){var i=t.button;if(1===i)return 4;if(2===i)return 2;if(i>=0)return 1<<i}}return 0}function _a(t,e,i){return t.distanceTo(e)<t.distanceTo(i)}function wa(t){var e=t.split(/[-+]/),i="";e.includes("scroll")&&(i="scroll"),e.includes("drag")&&(i="drag"),e.includes("click")&&(i="click"),e.includes("doubleClick")&&(i="doubleClick"),e.includes("hover")&&(i="hover"),e.includes("clickPick")&&(i="clickPick"),e.includes("hoverPick")&&(i="hoverPick");var r=0;e.includes("alt")&&(r+=1),e.includes("ctrl")&&(r+=2),e.includes("meta")&&(r+=4),e.includes("shift")&&(r+=8);var n=0;return e.includes("left")&&(n+=1),e.includes("right")&&(n+=2),e.includes("middle")&&(n+=4),[i,r,n]}function Sa(t){var e,i=t.length,r=t.length/3,n=0,o=0,a=0;for(e=0;e<i;e+=3)n+=t[e+0],o+=t[e+1],a+=t[e+2];return new v(n/r,o/r,a/r)}function Aa(t,e,i){return i?t.sub(i).projectOnVector(e).add(i):t.projectOnVector(e),t}function Ma(t){for(var e=1/0,i=1/0,r=1/0,n=-1/0,o=-1/0,a=-1/0,s=0,c=t.length;s<c;s+=3){var u=t[s],l=t[s+1],h=t[s+2];u<e&&(e=u),l<i&&(i=l),h<r&&(r=h),u>n&&(n=u),l>o&&(o=l),h>a&&(a=h)}return[Ca([e,i,r]),Ca([n,o,a])]}function Pa(t,e){for(var i=0,r=e.length;i<r;i+=3){var n=e[i],o=e[i+1],a=e[i+2];e[i]=t[0]*n+t[4]*o+t[8]*a+t[12],e[i+1]=t[1]*n+t[5]*o+t[9]*a+t[13],e[i+2]=t[2]*n+t[6]*o+t[10]*a+t[14]}}function Ea(t,e){for(var i=0,r=e.length;i<r;i+=3){var n=e[i],o=e[i+1],a=e[i+2];e[i]=t[0]*n+t[3]*o+t[6]*a,e[i+1]=t[1]*n+t[4]*o+t[7]*a,e[i+2]=t[2]*n+t[5]*o+t[8]*a}}function Ta(t){for(var e=0,i=t.length;e<i;e+=3){var r=t[e],n=t[e+1],o=t[e+2],a=1/Math.sqrt(r*r+n*n+o*o);t[e]=r*a,t[e+1]=n*a,t[e+2]=o*a}}function Ca(t){return new Float32Array(t||3)}function Ia(t,e,i){var r=e[0],n=e[1],o=e[2],a=i[0],s=i[1],c=i[2];t[0]=n*c-o*s,t[1]=o*a-r*c,t[2]=r*s-n*a}function Ra(t,e){return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]}function La(t,e,i){t[0]=e[0]-i[0],t[1]=e[1]-i[1],t[2]=e[2]-i[2]}function Oa(t,e,i){t[0]=e[0]+i[0],t[1]=e[1]+i[1],t[2]=e[2]+i[2]}function Da(t,e,i){t[0]=e[i],t[1]=e[i+1],t[2]=e[i+2]}function Na(t,e,i){e[i]=t[0],e[i+1]=t[1],e[i+2]=t[2]}function ka(t){return Math.sqrt(t[0]*t[0]+t[1]*t[1]+t[2]*t[2])}function Ba(t,e,i){Fa(t,e,1/i)}function Fa(t,e,i){t[0]=e[0]*i,t[1]=e[1]*i,t[2]=e[2]*i}function za(t,e){Fa(t,e,1/ka(e))}function Ua(t,e,i){t[0]=e[0]-i,t[1]=e[1]-i,t[2]=e[2]-i}function ja(t,e,i){t[0]=e[0]+i,t[1]=e[1]+i,t[2]=e[2]+i}function Va(t,e){t[0]=Math.floor(e[0]),t[1]=Math.floor(e[1]),t[2]=Math.floor(e[2])}function Ga(t,e){t[0]=Math.ceil(e[0]),t[1]=Math.ceil(e[1]),t[2]=Math.ceil(e[2])}function $a(t,e){t[0]=-e[0],t[1]=-e[1],t[2]=-e[2]}function Ha(t,e){void 0!==t.toArray?t=t.toArray():void 0!==t.x?t=[t.x,t.y,t.z]:void 0!==t.r&&(t=[t.r,t.g,t.b]),e.push.apply(e,t)}function Wa(t){return t-=t>>>1&1431655765,16843009*((t=(858993459&t)+(t>>>2&858993459))+(t>>>4)&252645135)>>>24}function Xa(t,e){this.type=t,this.scale=e||1,this.max=10}function qa(t,e){this.cols=t,this.rows=e,this.size=this.cols*this.rows,this.data=new Float32Array(this.size)}function Ya(t,e){for(var i=0,r=0,n=e.rows,o=e.cols,a=0,s=0,c=0,u=e.data,l=t.data;i<n;s+=1,a+=o,i++)for(c=s,r=0;r<o;c+=n,r++)l[c]=u[a+r]}function Za(t,e,i){for(var r=0,n=0,o=0,a=0,s=0,c=0,u=0,l=e.cols,h=e.rows,p=i.rows,d=e.data,f=i.data,m=t.data,g=0;r<h;a+=l,r++)for(c=0,n=0;n<p;u++,n++){for(s=a,g=0,o=0;o<l;s++,c++,o++)g+=d[s]*f[c];m[u]=g}}function Ka(t,e){var i=t.data,r=e.data,n=i[4],o=i[8],a=i[5],s=i[7],c=i[0],u=c*n,l=c*a,h=i[3],p=i[1],d=h*p,f=i[2],m=h*f,g=i[6],v=g*p,y=g*f,b=1/(u*o-l*s-d*o+m*s+v*a-y*n);r[0]=(n*o-a*s)*b,r[1]=-(p*o-f*s)*b,r[2]=-(-p*a+f*n)*b,r[3]=-(h*o-a*g)*b,r[4]=(c*o-y)*b,r[5]=-(l-m)*b,r[6]=-(-h*s+n*g)*b,r[7]=-(c*s-v)*b,r[8]=(u-d)*b}function Qa(t){var e=t.data;return e[0]*e[4]*e[8]-e[0]*e[5]*e[7]-e[3]*e[1]*e[8]+e[3]*e[2]*e[7]+e[6]*e[1]*e[5]-e[6]*e[2]*e[4]}function Ja(t,e,i){var r=t.data,n=e.data,o=i.data,a=n[0],s=n[1],c=n[2],u=n[3],l=n[4],h=n[5],p=n[6],d=n[7],f=n[8],m=o[0],g=o[1],v=o[2],y=o[3],b=o[4],x=o[5],_=o[6],w=o[7],S=o[8];r[0]=a*m+s*y+c*_,r[1]=a*g+s*b+c*w,r[2]=a*v+s*x+c*S,r[3]=u*m+l*y+h*_,r[4]=u*g+l*b+h*w,r[5]=u*v+l*x+h*S,r[6]=p*m+d*y+f*_,r[7]=p*g+d*b+f*w,r[8]=p*v+d*x+f*S}function ts(t){var e,i,r=0,n=t.rows,o=t.cols,a=t.data,s=new Array(o);for(i=0;i<o;++i)s[i]=0;for(e=0;e<n;++e)for(i=0;i<o;++i,++r)s[i]+=a[r];for(i=0;i<o;++i)s[i]/=n;return s}function es(t,e){var i,r,n=0,o=t.rows,a=t.cols,s=t.data;for(i=0;i<o;++i)for(r=0;r<a;++r,++n)s[n]-=e[r]}function is(t,e){var i,r,n=0,o=t.rows,a=t.cols,s=t.data;for(i=0;i<o;++i)for(r=0;r<a;++r,++n)s[n]+=e[r]}function rs(t,e,i,r){r=t[e],t[e]=t[i],t[i]=r}function ns(t,e){return t=Math.abs(t),e=Math.abs(e),t>e?(e/=t,t*Math.sqrt(1+e*e)):e>0?(t/=e,e*Math.sqrt(1+t*t)):0}function os(t,e,i,r,n,o,a,s){for(var c=2*Cy,u=Iy,l=0,h=0,p=0,d=0,f=Math.max(o,30),m=0,g=0,v=0,y=0,b=0,x=0,_=0,w=0,S=0,A=0,M=0,P=0,E=0,T=0,C=0,I=0,R=0,L=4660,O=0,D=0,N=0,k=new Float64Array(a<<3);l<a;l++){for(p=0,M=0;p<o;p++)M+=(w=t[l*e+p])*w;if(k[l]=M,r){for(p=0;p<a;p++)r[l*n+p]=0;r[l*n+l]=1}}for(;d<f;d++){for(b=0,l=0;l<a-1;l++)for(h=l+1;h<a;h++){for(m=l*e|0,g=h*e|0,C=k[l],I=0,R=k[h],p=2,I+=t[m]*t[g],I+=t[m+1]*t[g+1];p<o;p++)I+=t[m+p]*t[g+p];if(!(Math.abs(I)<=c*Math.sqrt(C*R))){for(E=ns(I*=2,P=C-R),P<0?(T=.5*(E-P),x=I/(E*(_=Math.sqrt(T/E))*2)):_=I/(E*(x=Math.sqrt((E+P)/(2*E)))*2),C=0,R=0,p=2,S=x*t[m]+_*t[g],A=-_*t[m]+x*t[g],t[m]=S,t[g]=A,C+=S*S,R+=A*A,S=x*t[m+1]+_*t[g+1],A=-_*t[m+1]+x*t[g+1],t[m+1]=S,t[g+1]=A,C+=S*S,R+=A*A;p<o;p++)S=x*t[m+p]+_*t[g+p],A=-_*t[m+p]+x*t[g+p],t[m+p]=S,t[g+p]=A,C+=S*S,R+=A*A;if(k[l]=C,k[h]=R,b=1,r)for(y=h*n|0,p=2,S=x*r[v=l*n|0]+_*r[y],A=-_*r[v]+x*r[y],r[v]=S,r[y]=A,S=x*r[v+1]+_*r[y+1],A=-_*r[v+1]+x*r[y+1],r[v+1]=S,r[y+1]=A;p<a;p++)S=x*r[v+p]+_*r[y+p],A=-_*r[v+p]+x*r[y+p],r[v+p]=S,r[y+p]=A}}if(0===b)break}for(l=0;l<a;l++){for(p=0,M=0;p<o;p++)M+=(w=t[l*e+p])*w;k[l]=Math.sqrt(M)}for(l=0;l<a-1;l++){for(h=l,p=l+1;p<a;p++)k[h]<k[p]&&(h=p);if(l!==h&&(rs(k,l,h,M),r)){for(p=0;p<o;p++)rs(t,l*e+p,h*e+p,w);for(p=0;p<a;p++)rs(r,l*n+p,h*n+p,w)}}for(l=0;l<a;l++)i[l]=k[l];if(r)for(l=0;l<s;l++){for(M=l<a?k[l]:0;M<=u;){for(D=1/o,p=0;p<o;p++)O=0!=(256&(L=214013*L+2531011)>>16)?D:-D,t[l*e+p]=O;for(d=0;d<2;d++)for(h=0;h<l;h++){for(M=0,p=0;p<o;p++)M+=t[l*e+p]*t[h*e+p];for(N=0,p=0;p<o;p++)w=t[l*e+p]-M*t[h*e+p],t[l*e+p]=w,N+=Math.abs(w);for(N=N?1/N:0,p=0;p<o;p++)t[l*e+p]*=N}for(M=0,p=0;p<o;p++)M+=(w=t[l*e+p])*w;M=Math.sqrt(M)}for(_=1/M,p=0;p<o;p++)t[l*e+p]*=_}}function as(t,e,i,r){var n=0,o=0,a=t.rows,s=t.cols,c=a,u=s;c<u&&(n=1,o=c,c=u,u=o);var l=new qa(c,c),h=new qa(1,u),p=new qa(u,u);if(0===n)Ya(l,t);else{for(o=0;o<s*a;o++)l.data[o]=t.data[o];for(;o<u*c;o++)l.data[o]=0}if(os(l.data,c,h.data,p.data,u,c,u,c),e){for(o=0;o<u;o++)e.data[o]=h.data[o];for(;o<s;o++)e.data[o]=0}0===n?(i&&Ya(i,l),r&&Ya(r,p)):(i&&Ya(i,p),r&&Ya(r,l))}function ss(){return new Float32Array([1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1])}function cs(t,e,i,r,n,o,a,s,c,u,l,h,p,d,f,m,g){t[0]=e,t[4]=i,t[8]=r,t[12]=n,t[1]=o,t[5]=a,t[9]=s,t[13]=c,t[2]=u,t[6]=l,t[10]=h,t[14]=p,t[3]=d,t[7]=f,t[11]=m,t[15]=g}function us(t,e,i){var r=e[0],n=e[4],o=e[8],a=e[12],s=e[1],c=e[5],u=e[9],l=e[13],h=e[2],p=e[6],d=e[10],f=e[14],m=e[3],g=e[7],v=e[11],y=e[15],b=i[0],x=i[4],_=i[8],w=i[12],S=i[1],A=i[5],M=i[9],P=i[13],E=i[2],T=i[6],C=i[10],I=i[14],R=i[3],L=i[7],O=i[11],D=i[15];t[0]=r*b+n*S+o*E+a*R,t[4]=r*x+n*A+o*T+a*L,t[8]=r*_+n*M+o*C+a*O,t[12]=r*w+n*P+o*I+a*D,t[1]=s*b+c*S+u*E+l*R,t[5]=s*x+c*A+u*T+l*L,t[9]=s*_+c*M+u*C+l*O,t[13]=s*w+c*P+u*I+l*D,t[2]=h*b+p*S+d*E+f*R,t[6]=h*x+p*A+d*T+f*L,t[10]=h*_+p*M+d*C+f*O,t[14]=h*w+p*P+d*I+f*D,t[3]=m*b+g*S+v*E+y*R,t[7]=m*x+g*A+v*T+y*L,t[11]=m*_+g*M+v*C+y*O,t[15]=m*w+g*P+v*I+y*D}function ls(t,e,i,r){cs(t,e,0,0,0,0,i,0,0,0,0,r,0,0,0,0,1)}function hs(t,e,i,r){cs(t,1,0,0,e,0,1,0,i,0,0,1,r,0,0,0,1)}function ps(t,e){var i=Math.cos(e),r=Math.sin(e);cs(t,i,0,r,0,0,1,0,0,-r,0,i,0,0,0,0,1)}function ds(){return new Float32Array([1,0,0,0,1,0,0,0,1])}function fs(t,e){var i=Ca([e[0],e[1],e[2]]),r=Ca([e[4],e[5],e[6]]),n=Ca([e[8],e[9],e[10]]),o=Ca();Ia(o,r,n),t[0]=o[0],t[1]=o[1],t[2]=o[2],Ia(o,n,i),t[3]=o[0],t[4]=o[1],t[5]=o[2],Ia(o,i,r),t[6]=o[0],t[7]=o[1],t[8]=o[2]}function ms(t,e){function i(t,e,i,r,n){for(var a=r*r,d=Math.max(0,t-r-s>>o),f=Math.max(0,e-r-c>>o),y=Math.max(0,i-r-u>>o),x=Math.min(l,t+r-s>>o),_=Math.min(h,e+r-c>>o),w=Math.min(p,i+r-u>>o),S=[],A=d;A<=x;++A)for(var P=f;P<=_;++P)for(var T=y;T<=w;++T){var I=b[(A*h+P)*p+T];if(I>0)for(var R=I-1,L=E[R],O=L+M[R],D=L;D<O;++D){var N=C[D],k=m[N]-t,B=g[N]-e,F=v[N]-i,z=k*k+B*B+F*F;z<=a&&n(N,z)}}return S}var r,n,o=3,a=e,s=a.min.x,c=a.min.y,u=a.min.z,l=1+(a.max.x-s>>o),h=1+(a.max.y-c>>o),p=1+(a.max.z-u>>o),d=l*h*p,f=t.count,m=t.x,g=t.y,v=t.z,y=0,b=new Uint32Array(d),x=new Int32Array(f);for(r=0;r<f;++r){var _=m[r]-s>>o,w=g[r]-c>>o,S=v[r]-u>>o,A=(_*h+w)*p+S;1===(b[A]+=1)&&(y+=1),x[r]=A}var M=new Uint16Array(y);for(r=0,n=0;r<d;++r){var P=b[r];P>0&&(b[r]=n+1,M[n]=P,n+=1)}var E=new Uint32Array(y);for(r=1;r<y;++r)E[r]+=E[r-1]+M[r-1];var T=new Uint16Array(y),C=new Int32Array(f);for(r=0;r<f;++r){var I=b[x[r]];if(I>0){var R=I-1;C[E[R]+T[R]]=r,T[R]+=1}}this.within=function(t,e,r,n){var o=[];return i(t,e,r,n,function(t){return o.push(t)}),o},this.eachWithin=i}function gs(e){var i=0,r=0,n={},o={},a=window.URL.createObjectURL(xm.get(e)),s=new window.Worker(a);xm.activeWorkerCount+=1,s.onmessage=function(r){i-=1;var a=r.data.__postId;t.Debug&&vm.timeEnd("Worker.postMessage "+e+" #"+a),n[a]&&n[a].call(s,r),delete n[a],delete o[a]},s.onerror=function(t){if(i-=1,t.data){var r=t.data.__postId;o[r]?o[r].call(s,t):vm.error("Worker.onerror",r,e,t),delete n[r],delete o[r]}else vm.error("Worker.onerror",e,t)},this.name=e,this.post=function(a,c,u,l){n[r]=u,o[r]=l,(a=a||{}).__name=e,a.__postId=r,a.__debug=t.Debug,t.Debug&&vm.time("Worker.postMessage "+e+" #"+r);try{s.postMessage(a,c)}catch(t){vm.error("worker.post:",t),s.postMessage(a)}return i+=1,r+=1,this},this.terminate=function(){s?(s.terminate(),window.URL.revokeObjectURL(a),xm.activeWorkerCount-=1):vm.log("no worker to terminate")},Object.defineProperties(this,{postCount:{get:function(){return r}},pending:{get:function(){return i}}})}function vs(t,e){e=Math.min(8,e||2);var i=[],r=0;this.name=t,this.maxCount=e,this.post=function(t,e,i,r){return this.getNextWorker().post(t,e,i,r),this},this.terminate=function(){i.forEach(function(t){t.terminate()})},this.getNextWorker=function(){for(var n,o=1/0,a=0;a<e;++a){if(a>=r){n=new gs(t),i.push(n),r+=1;break}var s=i[a];if(0===s.pending){n=s;break}s.pending<o&&(o=s.pending,n=s)}return n},Object.defineProperties(this,{count:{get:function(){return r}}})}function ys(){return new Uint32Array([0,265,515,778,1030,1295,1541,1804,2060,2309,2575,2822,3082,3331,3593,3840,400,153,915,666,1430,1183,1941,1692,2460,2197,2975,2710,3482,3219,3993,3728,560,825,51,314,1590,1855,1077,1340,2620,2869,2111,2358,3642,3891,3129,3376,928,681,419,170,1958,1711,1445,1196,2988,2725,2479,2214,4010,3747,3497,3232,1120,1385,1635,1898,102,367,613,876,3180,3429,3695,3942,2154,2403,2665,2912,1520,1273,2035,1786,502,255,1013,764,3580,3317,4095,3830,2554,2291,3065,2800,1616,1881,1107,1370,598,863,85,348,3676,3925,3167,3414,2650,2899,2137,2384,1984,1737,1475,1226,966,719,453,204,4044,3781,3535,3270,3018,2755,2505,2240,2240,2505,2755,3018,3270,3535,3781,4044,204,453,719,966,1226,1475,1737,1984,2384,2137,2899,2650,3414,3167,3925,3676,348,85,863,598,1370,1107,1881,1616,2800,3065,2291,2554,3830,4095,3317,3580,764,1013,255,502,1786,2035,1273,1520,2912,2665,2403,2154,3942,3695,3429,3180,876,613,367,102,1898,1635,1385,1120,3232,3497,3747,4010,2214,2479,2725,2988,1196,1445,1711,1958,170,419,681,928,3376,3129,3891,3642,2358,2111,2869,2620,1340,1077,1855,1590,314,51,825,560,3728,3993,3219,3482,2710,2975,2197,2460,1692,1941,1183,1430,666,915,153,400,3840,3593,3331,3082,2822,2575,2309,2060,1804,1541,1295,1030,778,515,265,0])}function bs(){return new Int32Array([-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,8,3,9,8,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,1,2,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,2,10,0,2,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,8,3,2,10,8,10,9,8,-1,-1,-1,-1,-1,-1,-1,3,11,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,11,2,8,11,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,9,0,2,3,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,11,2,1,9,11,9,8,11,-1,-1,-1,-1,-1,-1,-1,3,10,1,11,10,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,10,1,0,8,10,8,11,10,-1,-1,-1,-1,-1,-1,-1,3,9,0,3,11,9,11,10,9,-1,-1,-1,-1,-1,-1,-1,9,8,10,10,8,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,7,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,3,0,7,3,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,8,4,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,1,9,4,7,1,7,3,1,-1,-1,-1,-1,-1,-1,-1,1,2,10,8,4,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,4,7,3,0,4,1,2,10,-1,-1,-1,-1,-1,-1,-1,9,2,10,9,0,2,8,4,7,-1,-1,-1,-1,-1,-1,-1,2,10,9,2,9,7,2,7,3,7,9,4,-1,-1,-1,-1,8,4,7,3,11,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,4,7,11,2,4,2,0,4,-1,-1,-1,-1,-1,-1,-1,9,0,1,8,4,7,2,3,11,-1,-1,-1,-1,-1,-1,-1,4,7,11,9,4,11,9,11,2,9,2,1,-1,-1,-1,-1,3,10,1,3,11,10,7,8,4,-1,-1,-1,-1,-1,-1,-1,1,11,10,1,4,11,1,0,4,7,11,4,-1,-1,-1,-1,4,7,8,9,0,11,9,11,10,11,0,3,-1,-1,-1,-1,4,7,11,4,11,9,9,11,10,-1,-1,-1,-1,-1,-1,-1,9,5,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,5,4,0,8,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,5,4,1,5,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,5,4,8,3,5,3,1,5,-1,-1,-1,-1,-1,-1,-1,1,2,10,9,5,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,8,1,2,10,4,9,5,-1,-1,-1,-1,-1,-1,-1,5,2,10,5,4,2,4,0,2,-1,-1,-1,-1,-1,-1,-1,2,10,5,3,2,5,3,5,4,3,4,8,-1,-1,-1,-1,9,5,4,2,3,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,11,2,0,8,11,4,9,5,-1,-1,-1,-1,-1,-1,-1,0,5,4,0,1,5,2,3,11,-1,-1,-1,-1,-1,-1,-1,2,1,5,2,5,8,2,8,11,4,8,5,-1,-1,-1,-1,10,3,11,10,1,3,9,5,4,-1,-1,-1,-1,-1,-1,-1,4,9,5,0,8,1,8,10,1,8,11,10,-1,-1,-1,-1,5,4,0,5,0,11,5,11,10,11,0,3,-1,-1,-1,-1,5,4,8,5,8,10,10,8,11,-1,-1,-1,-1,-1,-1,-1,9,7,8,5,7,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,3,0,9,5,3,5,7,3,-1,-1,-1,-1,-1,-1,-1,0,7,8,0,1,7,1,5,7,-1,-1,-1,-1,-1,-1,-1,1,5,3,3,5,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,7,8,9,5,7,10,1,2,-1,-1,-1,-1,-1,-1,-1,10,1,2,9,5,0,5,3,0,5,7,3,-1,-1,-1,-1,8,0,2,8,2,5,8,5,7,10,5,2,-1,-1,-1,-1,2,10,5,2,5,3,3,5,7,-1,-1,-1,-1,-1,-1,-1,7,9,5,7,8,9,3,11,2,-1,-1,-1,-1,-1,-1,-1,9,5,7,9,7,2,9,2,0,2,7,11,-1,-1,-1,-1,2,3,11,0,1,8,1,7,8,1,5,7,-1,-1,-1,-1,11,2,1,11,1,7,7,1,5,-1,-1,-1,-1,-1,-1,-1,9,5,8,8,5,7,10,1,3,10,3,11,-1,-1,-1,-1,5,7,0,5,0,9,7,11,0,1,0,10,11,10,0,-1,11,10,0,11,0,3,10,5,0,8,0,7,5,7,0,-1,11,10,5,7,11,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,10,6,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,5,10,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,0,1,5,10,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,8,3,1,9,8,5,10,6,-1,-1,-1,-1,-1,-1,-1,1,6,5,2,6,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,6,5,1,2,6,3,0,8,-1,-1,-1,-1,-1,-1,-1,9,6,5,9,0,6,0,2,6,-1,-1,-1,-1,-1,-1,-1,5,9,8,5,8,2,5,2,6,3,2,8,-1,-1,-1,-1,2,3,11,10,6,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,0,8,11,2,0,10,6,5,-1,-1,-1,-1,-1,-1,-1,0,1,9,2,3,11,5,10,6,-1,-1,-1,-1,-1,-1,-1,5,10,6,1,9,2,9,11,2,9,8,11,-1,-1,-1,-1,6,3,11,6,5,3,5,1,3,-1,-1,-1,-1,-1,-1,-1,0,8,11,0,11,5,0,5,1,5,11,6,-1,-1,-1,-1,3,11,6,0,3,6,0,6,5,0,5,9,-1,-1,-1,-1,6,5,9,6,9,11,11,9,8,-1,-1,-1,-1,-1,-1,-1,5,10,6,4,7,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,3,0,4,7,3,6,5,10,-1,-1,-1,-1,-1,-1,-1,1,9,0,5,10,6,8,4,7,-1,-1,-1,-1,-1,-1,-1,10,6,5,1,9,7,1,7,3,7,9,4,-1,-1,-1,-1,6,1,2,6,5,1,4,7,8,-1,-1,-1,-1,-1,-1,-1,1,2,5,5,2,6,3,0,4,3,4,7,-1,-1,-1,-1,8,4,7,9,0,5,0,6,5,0,2,6,-1,-1,-1,-1,7,3,9,7,9,4,3,2,9,5,9,6,2,6,9,-1,3,11,2,7,8,4,10,6,5,-1,-1,-1,-1,-1,-1,-1,5,10,6,4,7,2,4,2,0,2,7,11,-1,-1,-1,-1,0,1,9,4,7,8,2,3,11,5,10,6,-1,-1,-1,-1,9,2,1,9,11,2,9,4,11,7,11,4,5,10,6,-1,8,4,7,3,11,5,3,5,1,5,11,6,-1,-1,-1,-1,5,1,11,5,11,6,1,0,11,7,11,4,0,4,11,-1,0,5,9,0,6,5,0,3,6,11,6,3,8,4,7,-1,6,5,9,6,9,11,4,7,9,7,11,9,-1,-1,-1,-1,10,4,9,6,4,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,10,6,4,9,10,0,8,3,-1,-1,-1,-1,-1,-1,-1,10,0,1,10,6,0,6,4,0,-1,-1,-1,-1,-1,-1,-1,8,3,1,8,1,6,8,6,4,6,1,10,-1,-1,-1,-1,1,4,9,1,2,4,2,6,4,-1,-1,-1,-1,-1,-1,-1,3,0,8,1,2,9,2,4,9,2,6,4,-1,-1,-1,-1,0,2,4,4,2,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,3,2,8,2,4,4,2,6,-1,-1,-1,-1,-1,-1,-1,10,4,9,10,6,4,11,2,3,-1,-1,-1,-1,-1,-1,-1,0,8,2,2,8,11,4,9,10,4,10,6,-1,-1,-1,-1,3,11,2,0,1,6,0,6,4,6,1,10,-1,-1,-1,-1,6,4,1,6,1,10,4,8,1,2,1,11,8,11,1,-1,9,6,4,9,3,6,9,1,3,11,6,3,-1,-1,-1,-1,8,11,1,8,1,0,11,6,1,9,1,4,6,4,1,-1,3,11,6,3,6,0,0,6,4,-1,-1,-1,-1,-1,-1,-1,6,4,8,11,6,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,10,6,7,8,10,8,9,10,-1,-1,-1,-1,-1,-1,-1,0,7,3,0,10,7,0,9,10,6,7,10,-1,-1,-1,-1,10,6,7,1,10,7,1,7,8,1,8,0,-1,-1,-1,-1,10,6,7,10,7,1,1,7,3,-1,-1,-1,-1,-1,-1,-1,1,2,6,1,6,8,1,8,9,8,6,7,-1,-1,-1,-1,2,6,9,2,9,1,6,7,9,0,9,3,7,3,9,-1,7,8,0,7,0,6,6,0,2,-1,-1,-1,-1,-1,-1,-1,7,3,2,6,7,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,11,10,6,8,10,8,9,8,6,7,-1,-1,-1,-1,2,0,7,2,7,11,0,9,7,6,7,10,9,10,7,-1,1,8,0,1,7,8,1,10,7,6,7,10,2,3,11,-1,11,2,1,11,1,7,10,6,1,6,7,1,-1,-1,-1,-1,8,9,6,8,6,7,9,1,6,11,6,3,1,3,6,-1,0,9,1,11,6,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,8,0,7,0,6,3,11,0,11,6,0,-1,-1,-1,-1,7,11,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,6,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,8,11,7,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,11,7,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,1,9,8,3,1,11,7,6,-1,-1,-1,-1,-1,-1,-1,10,1,2,6,11,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,10,3,0,8,6,11,7,-1,-1,-1,-1,-1,-1,-1,2,9,0,2,10,9,6,11,7,-1,-1,-1,-1,-1,-1,-1,6,11,7,2,10,3,10,8,3,10,9,8,-1,-1,-1,-1,7,2,3,6,2,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,0,8,7,6,0,6,2,0,-1,-1,-1,-1,-1,-1,-1,2,7,6,2,3,7,0,1,9,-1,-1,-1,-1,-1,-1,-1,1,6,2,1,8,6,1,9,8,8,7,6,-1,-1,-1,-1,10,7,6,10,1,7,1,3,7,-1,-1,-1,-1,-1,-1,-1,10,7,6,1,7,10,1,8,7,1,0,8,-1,-1,-1,-1,0,3,7,0,7,10,0,10,9,6,10,7,-1,-1,-1,-1,7,6,10,7,10,8,8,10,9,-1,-1,-1,-1,-1,-1,-1,6,8,4,11,8,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,6,11,3,0,6,0,4,6,-1,-1,-1,-1,-1,-1,-1,8,6,11,8,4,6,9,0,1,-1,-1,-1,-1,-1,-1,-1,9,4,6,9,6,3,9,3,1,11,3,6,-1,-1,-1,-1,6,8,4,6,11,8,2,10,1,-1,-1,-1,-1,-1,-1,-1,1,2,10,3,0,11,0,6,11,0,4,6,-1,-1,-1,-1,4,11,8,4,6,11,0,2,9,2,10,9,-1,-1,-1,-1,10,9,3,10,3,2,9,4,3,11,3,6,4,6,3,-1,8,2,3,8,4,2,4,6,2,-1,-1,-1,-1,-1,-1,-1,0,4,2,4,6,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,9,0,2,3,4,2,4,6,4,3,8,-1,-1,-1,-1,1,9,4,1,4,2,2,4,6,-1,-1,-1,-1,-1,-1,-1,8,1,3,8,6,1,8,4,6,6,10,1,-1,-1,-1,-1,10,1,0,10,0,6,6,0,4,-1,-1,-1,-1,-1,-1,-1,4,6,3,4,3,8,6,10,3,0,3,9,10,9,3,-1,10,9,4,6,10,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,9,5,7,6,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,4,9,5,11,7,6,-1,-1,-1,-1,-1,-1,-1,5,0,1,5,4,0,7,6,11,-1,-1,-1,-1,-1,-1,-1,11,7,6,8,3,4,3,5,4,3,1,5,-1,-1,-1,-1,9,5,4,10,1,2,7,6,11,-1,-1,-1,-1,-1,-1,-1,6,11,7,1,2,10,0,8,3,4,9,5,-1,-1,-1,-1,7,6,11,5,4,10,4,2,10,4,0,2,-1,-1,-1,-1,3,4,8,3,5,4,3,2,5,10,5,2,11,7,6,-1,7,2,3,7,6,2,5,4,9,-1,-1,-1,-1,-1,-1,-1,9,5,4,0,8,6,0,6,2,6,8,7,-1,-1,-1,-1,3,6,2,3,7,6,1,5,0,5,4,0,-1,-1,-1,-1,6,2,8,6,8,7,2,1,8,4,8,5,1,5,8,-1,9,5,4,10,1,6,1,7,6,1,3,7,-1,-1,-1,-1,1,6,10,1,7,6,1,0,7,8,7,0,9,5,4,-1,4,0,10,4,10,5,0,3,10,6,10,7,3,7,10,-1,7,6,10,7,10,8,5,4,10,4,8,10,-1,-1,-1,-1,6,9,5,6,11,9,11,8,9,-1,-1,-1,-1,-1,-1,-1,3,6,11,0,6,3,0,5,6,0,9,5,-1,-1,-1,-1,0,11,8,0,5,11,0,1,5,5,6,11,-1,-1,-1,-1,6,11,3,6,3,5,5,3,1,-1,-1,-1,-1,-1,-1,-1,1,2,10,9,5,11,9,11,8,11,5,6,-1,-1,-1,-1,0,11,3,0,6,11,0,9,6,5,6,9,1,2,10,-1,11,8,5,11,5,6,8,0,5,10,5,2,0,2,5,-1,6,11,3,6,3,5,2,10,3,10,5,3,-1,-1,-1,-1,5,8,9,5,2,8,5,6,2,3,8,2,-1,-1,-1,-1,9,5,6,9,6,0,0,6,2,-1,-1,-1,-1,-1,-1,-1,1,5,8,1,8,0,5,6,8,3,8,2,6,2,8,-1,1,5,6,2,1,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,3,6,1,6,10,3,8,6,5,6,9,8,9,6,-1,10,1,0,10,0,6,9,5,0,5,6,0,-1,-1,-1,-1,0,3,8,5,6,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,10,5,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,5,10,7,5,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,5,10,11,7,5,8,3,0,-1,-1,-1,-1,-1,-1,-1,5,11,7,5,10,11,1,9,0,-1,-1,-1,-1,-1,-1,-1,10,7,5,10,11,7,9,8,1,8,3,1,-1,-1,-1,-1,11,1,2,11,7,1,7,5,1,-1,-1,-1,-1,-1,-1,-1,0,8,3,1,2,7,1,7,5,7,2,11,-1,-1,-1,-1,9,7,5,9,2,7,9,0,2,2,11,7,-1,-1,-1,-1,7,5,2,7,2,11,5,9,2,3,2,8,9,8,2,-1,2,5,10,2,3,5,3,7,5,-1,-1,-1,-1,-1,-1,-1,8,2,0,8,5,2,8,7,5,10,2,5,-1,-1,-1,-1,9,0,1,5,10,3,5,3,7,3,10,2,-1,-1,-1,-1,9,8,2,9,2,1,8,7,2,10,2,5,7,5,2,-1,1,3,5,3,7,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,7,0,7,1,1,7,5,-1,-1,-1,-1,-1,-1,-1,9,0,3,9,3,5,5,3,7,-1,-1,-1,-1,-1,-1,-1,9,8,7,5,9,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5,8,4,5,10,8,10,11,8,-1,-1,-1,-1,-1,-1,-1,5,0,4,5,11,0,5,10,11,11,3,0,-1,-1,-1,-1,0,1,9,8,4,10,8,10,11,10,4,5,-1,-1,-1,-1,10,11,4,10,4,5,11,3,4,9,4,1,3,1,4,-1,2,5,1,2,8,5,2,11,8,4,5,8,-1,-1,-1,-1,0,4,11,0,11,3,4,5,11,2,11,1,5,1,11,-1,0,2,5,0,5,9,2,11,5,4,5,8,11,8,5,-1,9,4,5,2,11,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,5,10,3,5,2,3,4,5,3,8,4,-1,-1,-1,-1,5,10,2,5,2,4,4,2,0,-1,-1,-1,-1,-1,-1,-1,3,10,2,3,5,10,3,8,5,4,5,8,0,1,9,-1,5,10,2,5,2,4,1,9,2,9,4,2,-1,-1,-1,-1,8,4,5,8,5,3,3,5,1,-1,-1,-1,-1,-1,-1,-1,0,4,5,1,0,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,4,5,8,5,3,9,0,5,0,3,5,-1,-1,-1,-1,9,4,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,11,7,4,9,11,9,10,11,-1,-1,-1,-1,-1,-1,-1,0,8,3,4,9,7,9,11,7,9,10,11,-1,-1,-1,-1,1,10,11,1,11,4,1,4,0,7,4,11,-1,-1,-1,-1,3,1,4,3,4,8,1,10,4,7,4,11,10,11,4,-1,4,11,7,9,11,4,9,2,11,9,1,2,-1,-1,-1,-1,9,7,4,9,11,7,9,1,11,2,11,1,0,8,3,-1,11,7,4,11,4,2,2,4,0,-1,-1,-1,-1,-1,-1,-1,11,7,4,11,4,2,8,3,4,3,2,4,-1,-1,-1,-1,2,9,10,2,7,9,2,3,7,7,4,9,-1,-1,-1,-1,9,10,7,9,7,4,10,2,7,8,7,0,2,0,7,-1,3,7,10,3,10,2,7,4,10,1,10,0,4,0,10,-1,1,10,2,8,7,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,9,1,4,1,7,7,1,3,-1,-1,-1,-1,-1,-1,-1,4,9,1,4,1,7,0,8,1,8,7,1,-1,-1,-1,-1,4,0,3,7,4,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,8,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,10,8,10,11,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,9,3,9,11,11,9,10,-1,-1,-1,-1,-1,-1,-1,0,1,10,0,10,8,8,10,11,-1,-1,-1,-1,-1,-1,-1,3,1,10,11,3,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,11,1,11,9,9,11,8,-1,-1,-1,-1,-1,-1,-1,3,0,9,3,9,11,1,2,9,2,11,9,-1,-1,-1,-1,0,2,11,8,0,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,2,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,8,2,8,10,10,8,9,-1,-1,-1,-1,-1,-1,-1,9,10,2,0,9,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,8,2,8,10,0,1,8,1,10,8,-1,-1,-1,-1,1,10,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,3,8,9,1,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,9,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,3,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1])}function xs(){return[[0,4,4,4,2,0,0,0,2,2,0,0],[4,0,4,4,0,8,0,0,0,8,8,0],[4,4,0,4,0,0,8,0,0,0,8,8],[4,4,4,0,0,0,0,1,1,0,0,1],[2,0,0,0,0,8,8,8,2,2,0,0],[0,8,0,0,8,0,8,8,0,8,8,0],[0,0,8,0,8,8,0,8,0,0,8,8],[0,0,0,1,8,8,8,0,1,0,0,1],[2,0,0,1,2,0,0,1,0,2,0,1],[2,8,0,0,2,8,0,0,2,0,8,0],[0,8,8,0,0,8,8,0,0,8,0,8],[0,0,8,1,0,0,8,1,1,0,8,0]]}function _s(t,e,i,r,n){function o(t,e,i){return t+(e-t)*i}function a(t,n,o){return t=(t+v)%e,n=(n+y)%i,o=(o+b)%r,P*o+M*n+t}function s(t,e,i,r,a,s,c){var u=w?3*t:t;if(f[u]<0){var l=(x-s)/(c-s),h=d,p=3*m;if(T[p+0]=i+l,T[p+1]=r,T[p+2]=a,!_){var g=3*t;C[p]=-o(h[g],h[g+3],l),C[p+1]=-o(h[g+1],h[g+4],l),C[p+2]=-o(h[g+2],h[g+5],l)}n&&(R[m]=n[t+Math.round(l)]),f[u]=m,E[e]=m,m+=1}else E[e]=f[u]}function c(t,e,i,r,a,s,c){var u=w?3*t+1:t;if(f[u]<0){var l=(x-s)/(c-s),h=d,p=3*m;if(T[p]=i,T[p+1]=r+l,T[p+2]=a,!_){var g=3*t,v=g+3*M;C[p]=-o(h[g],h[v],l),C[p+1]=-o(h[g+1],h[v+1],l),C[p+2]=-o(h[g+2],h[v+2],l)}n&&(R[m]=n[t+Math.round(l)*M]),f[u]=m,E[e]=m,m+=1}else E[e]=f[u]}function u(t,e,i,r,a,s,c){var u=w?3*t+2:t;if(f[u]<0){var l=(x-s)/(c-s),h=d,p=3*m;if(T[p]=i,T[p+1]=r,T[p+2]=a+l,!_){var g=3*t,v=g+3*P;C[p]=-o(h[g],h[v],l),C[p+1]=-o(h[g+1],h[v+1],l),C[p+2]=-o(h[g+2],h[v+2],l)}n&&(R[m]=n[t+Math.round(l)*P]),f[u]=m,E[e]=m,m+=1}else E[e]=f[u]}function l(e){var i=3*e;0===d[i]&&(d[i]=t[(e-1+A)%A]-t[(e+1)%A],d[i+1]=t[(e-M+A)%A]-t[(e+M)%A],d[i+2]=t[(e-P+A)%A]-t[(e+P)%A])}function h(e,i,r,n,o){var h,p,d,f,m,v,y;S?(n=a(e,i,r),h=a(e+1,i,r),p=a(e,i+1,r),d=a(e,i,r+1),f=a(e+1,i+1,r),m=a(e+1,i,r+1),v=a(e,i+1,r+1),y=a(e+1,i+1,r+1)):(h=n+1,f=(p=n+M)+1,m=(d=n+P)+1,y=(v=p+P)+1);var b=0,A=t[n],T=t[h],C=t[p],R=t[f],N=t[d],k=t[m],B=t[v],F=t[y];A<x&&(b|=1),T<x&&(b|=2),C<x&&(b|=8),R<x&&(b|=4),N<x&&(b|=16),k<x&&(b|=32),B<x&&(b|=128),F<x&&(b|=64);var z=L[b];if(0===z)return 0;var U=e+1,j=i+1,V=r+1;1&z&&(_||(l(n),l(h)),s(n,0,e,i,r,A,T)),2&z&&(_||(l(h),l(f)),c(h,1,U,i,r,T,R)),4&z&&(_||(l(p),l(f)),s(p,2,e,j,r,C,R)),8&z&&(_||(l(n),l(p)),c(n,3,e,i,r,A,C)),16&z&&(_||(l(d),l(m)),s(d,4,e,i,V,N,k)),32&z&&(_||(l(m),l(y)),c(m,5,U,i,V,k,F)),64&z&&(_||(l(v),l(y)),s(v,6,e,j,V,B,F)),128&z&&(_||(l(d),l(v)),c(d,7,e,i,V,N,B)),256&z&&(_||(l(n),l(d)),u(n,8,e,i,r,A,N)),512&z&&(_||(l(h),l(m)),u(h,9,U,i,r,T,k)),1024&z&&(_||(l(f),l(y)),u(f,10,U,j,r,R,F)),2048&z&&(_||(l(p),l(v)),u(p,11,e,j,r,C,B));for(var G,$,H,W=b<<4,X=0;-1!==O[W+X];)G=O[W+X],$=O[W+X+1],H=O[W+X+2],w?(D[G][$]&o&&(I[g++]=E[G],I[g++]=E[$]),D[$][H]&o&&(I[g++]=E[$],I[g++]=E[H]),D[G][H]&o&&(I[g++]=E[G],I[g++]=E[H])):(I[g++]=E[$],I[g++]=E[G],I[g++]=E[H]),X+=3}function p(n,o,s,c,u,l){var p,d,m,g,v,y,b;n=void 0!==n?n:0,o=void 0!==o?o:0,s=void 0!==s?s:0,c=void 0!==c?c:e-1,u=void 0!==u?u:i-1,l=void 0!==l?l:r-1,S||(_?(n=Math.max(0,n),o=Math.max(0,o),s=Math.max(0,s),c=Math.min(e-1,c),u=Math.min(i-1,u),l=Math.min(r-1,l)):(n=Math.max(1,n),o=Math.max(1,o),s=Math.max(1,s),c=Math.min(e-2,c),u=Math.min(i-2,u),l=Math.min(r-2,l)));var A,E,T,C,I,R;if(S)for(A=n-2,E=o-2,C=c+2,I=u+2,R=l+2,v=T=s-2;v<R;++v)for(g=E;g<I;++g)for(m=A;m<C;++m)w?(d=3*a(m,g,v),f[d]=-1,f[d+1]=-1,f[d+2]=-1):(p=a(m,g,v),f[p]=-1);else for(A=Math.max(0,n-2),E=Math.max(0,o-2),T=Math.max(0,s-2),C=Math.min(e,c+2),I=Math.min(i,u+2),R=Math.min(r,l+2),v=T;v<R;++v)for(b=P*v,g=E;g<I;++g)for(y=b+M*g,m=A;m<C;++m)w?(f[p=3*(y+m)]=-1,f[p+1]=-1,f[p+2]=-1):f[p=y+m]=-1;if(!S){var L,O=n,D=o,N=s,k=c,B=u,F=l;for(L=!1,v=s;v<l;++v){for(g=o;g<u;++g){for(m=n;m<c;++m)if(p=e*i*v+e*g+m,t[p]>=x){N=v,L=!0;break}if(L)break}if(L)break}for(L=!1,g=o;g<u;++g){for(v=N;v<l;++v){for(m=n;m<c;++m)if(p=e*i*v+e*g+m,t[p]>=x){D=g,L=!0;break}if(L)break}if(L)break}for(L=!1,m=n;m<c;++m){for(g=D;g<u;++g){for(v=N;v<l;++v)if(p=e*i*v+e*g+m,t[p]>=x){O=m,L=!0;break}if(L)break}if(L)break}for(L=!1,v=l;v>=s;--v){for(g=u;g>=o;--g){for(m=c;m>=n;--m)if(p=e*i*v+e*g+m,t[p]>=x){F=v,L=!0;break}if(L)break}if(L)break}for(L=!1,g=u;g>=o;--g){for(v=F;v>=s;--v){for(m=c;m>=n;--m)if(p=e*i*v+e*g+m,t[p]>=x){B=g,L=!0;break}if(L)break}if(L)break}for(L=!1,m=c;m>=n;--m){for(g=B;g>=o;--g){for(v=F;v>=s;--v)if(p=e*i*v+e*g+m,t[p]>=x){k=m,L=!0;break}if(L)break}if(L)break}_?(n=Math.max(0,O-1),o=Math.max(0,D-1),s=Math.max(0,N-1),c=Math.min(e-1,k+1),u=Math.min(i-1,B+1),l=Math.min(r-1,F+1)):(n=Math.max(1,O-1),o=Math.max(1,D-1),s=Math.max(1,N-1),c=Math.min(e-2,k+1),u=Math.min(i-2,B+1),l=Math.min(r-2,F+1))}var z=15;for(v=s;v<l;++v,z&=-5)for(b=P*v,z|=2,g=o;g<u;++g,z&=-3)for(y=b+M*g,z|=1,m=n;m<c;++m,z&=-2)h(m,g,v,p=y+m,z)}var d,f,m,g,v,y,b,x=0,_=!1,w=!1,S=!1,A=e*i*r,M=e,P=e*i,E=new Int32Array(12),T=[],C=[],I=[],R=[],L=ys(),O=bs(),D=xs();this.triangulate=function(t,o,a,s,c){x=t,w=s,S=c,(_=o||w)||d||(d=new Float32Array(3*A));var u=w?3*A:A;if(f&&f.length===u||(f=new Int32Array(u)),m=0,g=0,void 0!==a){var l=a[0].map(Math.round),h=a[1].map(Math.round);v=e*Math.ceil(Math.abs(l[0])/e),y=i*Math.ceil(Math.abs(l[1])/i),b=r*Math.ceil(Math.abs(l[2])/r),p(l[0],l[1],l[2],h[0],h[1],h[2])}else v=y=b=0,p();return T.length=3*m,_||(C.length=3*m),I.length=g,n&&(R.length=m),{position:new Float32Array(T),normal:_?void 0:new Float32Array(C),index:Kn(I,T.length/3),atomindex:n?new Int32Array(R):void 0,contour:w}}}function ws(t,e,i,r){i=i||1,r=r||!0;var n,o=t.length/3,a=e.length/3;r&&(n=new Float32Array(3*o));var s,c=new Float32Array(3*o),u=new Array(20);for(s=0;s<20;++s)u[s]=new Uint32Array(o);for(s=0;s<o;++s)u[0][s]=0;var l,h,p;for(s=0;s<a;++s){var d=3*s,f=3*s+1,m=3*s+2;for(p=!0,l=0,h=u[0][e[d]];l<h;++l)if(e[f]===u[l+1][e[d]]){p=!1;break}for(p&&(u[0][e[d]]++,u[u[0][e[d]]][e[d]]=e[f]),p=!0,l=0,h=u[0][e[d]];l<h;++l)if(e[m]===u[l+1][e[d]]){p=!1;break}for(p&&(u[0][e[d]]++,u[u[0][e[d]]][e[d]]=e[m]),p=!0,l=0,h=u[0][e[f]];l<h;++l)if(e[d]===u[l+1][e[f]]){p=!1;break}for(p&&(u[0][e[f]]++,u[u[0][e[f]]][e[f]]=e[d]),p=!0,l=0,h=u[0][e[f]];l<h;++l)if(e[m]===u[l+1][e[f]]){p=!1;break}for(p&&(u[0][e[f]]++,u[u[0][e[f]]][e[f]]=e[m]),p=!0,l=0;l<u[0][e[m]];++l)if(e[d]===u[l+1][e[m]]){p=!1;break}for(p&&(u[0][e[m]]++,u[u[0][e[m]]][e[m]]=e[d]),p=!0,l=0,h=u[0][e[m]];l<h;++l)if(e[f]===u[l+1][e[m]]){p=!1;break}p&&(u[0][e[m]]++,u[u[0][e[m]]][e[m]]=e[f])}for(var g,v,y,b,x,_=0;_<i;++_){for(s=0;s<o;++s)if(g=3*s,(y=u[0][s])<3)c[g]=t[g],c[g+1]=t[g+1],c[g+2]=t[g+2];else if(3===y||4===y){for(c[g]=0,c[g+1]=0,c[g+2]=0,l=0;l<y;++l)v=3*u[l+1][s],c[g]+=t[v],c[g+1]+=t[v+1],c[g+2]+=t[v+2];c[g]+=.5*t[g],c[g+1]+=.5*t[g+1],c[g+2]+=.5*t[g+2],x=.5+y,c[g]/=x,c[g+1]/=x,c[g+2]/=x}else{for(c[g]=0,c[g+1]=0,c[g+2]=0,l=0;l<y;++l)v=3*u[l+1][s],c[g]+=t[v],c[g+1]+=t[v+1],c[g+2]+=t[v+2];c[g]+=1*t[g],c[g+1]+=1*t[g+1],c[g+2]+=1*t[g+2],b=1+y,c[g]/=b,c[g+1]/=b,c[g+2]/=b}if(t.set(c),r){Ss(t,e,n);var w=3*o;for(g=0;g<w;g+=3)t[g]+=.75/4.5*-1*n[g],t[g+1]+=.75/4.5*-1*n[g+1],t[g+2]+=.75/4.5*-1*n[g+2]}}}function Ss(t,e,i){var r,n;if(void 0===i)i=new Float32Array(t.length);else for(r=0,n=i.length;r<n;r++)i[r]=0;var o=new Float32Array(3),a=new Float32Array(3),s=new Float32Array(3),c=new Float32Array(3),u=new Float32Array(3);if(e)for(r=0,n=e.length;r<n;r+=3){var l=3*e[r],h=3*e[r+1],p=3*e[r+2];Da(o,t,l),Da(a,t,h),Da(s,t,p),La(c,s,a),La(u,o,a),Ia(c,c,u),i[l]+=c[0],i[l+1]+=c[1],i[l+2]+=c[2],i[h]+=c[0],i[h+1]+=c[1],i[h+2]+=c[2],i[p]+=c[0],i[p+1]+=c[1],i[p+2]+=c[2]}else for(r=0,n=t.length;r<n;r+=9)Da(o,t,r),Da(a,t,r+3),Da(s,t,r+6),La(c,s,a),La(u,o,a),Ia(c,c,u),i[r]=c[0],i[r+1]=c[1],i[r+2]=c[2],i[r+3]=c[0],i[r+4]=c[1],i[r+5]=c[2],i[r+6]=c[0],i[r+7]=c[1],i[r+8]=c[2];return Ta(i),i}function As(t){for(var e={},i=0,r=t.length;i<r;++i)e[t[i]]=!0;return e}function Ms(t,e,i,r,n){var o=1/r*3;Ua(t,t,n+(o+=i)),ja(e,e,n+o),Fa(t,t,r),Va(t,t),Ba(t,t,r),Fa(e,e,r),Ga(e,e),Ba(e,e,r);var a=new Float32Array(3);La(a,e,t),Fa(a,a,r),Ga(a,a),ja(a,a,1);var s=256*Math.pow(10,6),c=a[0]*a[1]*a[2]*3;s<=c&&(Fa(t,t,r*=Math.pow(s/c,1/3)),Va(t,t),Ba(t,t,r),Fa(e,e,r),Ga(e,e),Ba(e,e,r),La(a,e,t),Fa(a,a,r),Ga(a,a),ja(a,a,1));var u=new Float32Array(t);$a(u,u);var l=ss(),h=ss();ps(h,co(90)),us(l,l,h);var p=ss();ls(p,-1/r,1/r,1/r),us(l,l,p);var d=ss();return hs(d,-r*u[2],-r*u[1],-r*u[0]),us(l,l,d),{dim:a,tran:u,matrix:l,scaleFactor:r}}function Ps(t,e,i,r,n){var o=new _s(t,e,i,r,n);this.getSurface=function(t,e,i,r,n,a){var s=o.triangulate(t,e,i,n,a);if(e&&!n&&(ws(s.position,s.index,e,!0),s.normal=Ss(s.position,s.index)),r&&(Pa(r,s.position),s.normal)){var c=ds();fs(c,r),Ea(c,s.normal)}return s}}function Es(t){this.polymer=t,this.size=t.residueCount}function Ts(t){this.polymer=t,this.helixorient=new Es(t),this.position=this.helixorient.getPosition()}function Cs(t){this.content=[],this.scoreFunction=t}function Is(t,e){function i(e,r,n,o){e>a&&(a=e);var c=o-n;if(0===c)return-1;var p=4*l;if(l+=1,1===c)return u[p]=n,u[p+1]=-1,u[p+2]=-1,u[p+3]=r,p;var d=n+Math.floor(c/2);h=e%3;for(var f,m,g,v,y,b=n,x=o-1;x>b;){for(v=t[3*s[g=b+x>>1]+h],m=s[g],s[g]=s[x],s[x]=m,y=b,f=b;f<x;++f)t[3*s[f]+h]<v&&(m=s[y],s[y]=s[f],s[f]=m,++y);if(m=s[x],s[x]=s[y],s[y]=m,g=y,d===g)break;d<g?x=g-1:b=g+1}return u[p]=d,u[p+1]=i(e+1,p,n,d),u[p+2]=i(e+1,p,d+1,o),u[p+3]=r,p}function r(t){var e=u[t+3];return-1===e?0:r(e)+1}function n(e,i){var r=1;if(void 0===e&&(e=p,i=0),-1===e)throw new Error("node is null");var o=i%3,a=u[e+1],c=u[e+2];if(-1!==a){if(t[3*s[u[a]]+o]>t[3*s[u[e]]+o])throw new Error("left child is > parent!");r+=n(a,i+1)}if(-1!==c){if(t[3*s[u[c]]+o]<t[3*s[u[e]]+o])throw new Error("right child is < parent!");r+=n(c,i+1)}return r}for(var o=t.length/3,a=0,s=new Uint32Array(o),c=0;c<o;++c)s[c]=c;var u=new Int32Array(4*o),l=0,h=0,p=i(0,-1,0,o);this.rootIndex=p,this.maxDepth=a,this.nearest=function(i,n,o){function a(l){function h(t,e){c.push([t,e]),c.size()>n&&c.pop()}var p,d,f=r(l)%3,m=3*s[u[l]],g=[t[m+0],t[m+1],t[m+2]],v=e(i,g),y=u[l+1],b=u[l+2];if(-1!==b||-1!==y){a(p=-1===b?y:-1===y?b:i[f]<=t[m+f]?y:b),(c.size()<n||v<c.peek()[1])&&v<=o&&h(l,v);for(var x=[],_=0;_<3;_+=1)x[_]=_===f?i[_]:t[m+_];var w=e(x,g);(c.size()<n||Math.abs(w)<c.peek()[1])&&Math.abs(w)<=o&&-1!==(d=p===y?b:y)&&a(d)}else(c.size()<n||v<c.peek()[1])&&v<=o&&h(l,v)}var c=new Cs(function(t){return-t[1]});a(p);for(var l=[],h=0,d=Math.min(c.size(),n);h<d;h+=1)l.push(c.content[h]);return l},this.indices=s,this.nodes=u,this.verify=n}function Rs(e,i){t.Debug&&vm.time("Kdtree build");var r;r=i?function(t,e){var i=t[0]-e[0],r=t[1]-e[1],n=t[2]-e[2];return i*i+r*r+n*n}:function(t,e){var i=t[0]-e[0],r=t[1]-e[1],n=t[2]-e[2];return Math.sqrt(i*i+r*r+n*n)};var n=new Float32Array(3*e.atomCount),o=new Uint32Array(e.atomCount),a=0;e.eachAtom(function(t){n[a+0]=t.x,n[a+1]=t.y,n[a+2]=t.z,o[a/3]=t.index,a+=3}),this.atomIndices=o,this.points=n,this.kdtree=new Is(n,r),t.Debug&&vm.timeEnd("Kdtree build")}function Ls(t){var e=qy[t],i={};if(void 0===e)return console.warn("getSymmetryOperations: spacegroup '"+t+"' not found in symop library"),i;for(var r=[],n=0,o=e.length;n<o;n+=3){for(var a=[],s=0;s<3;++s)a.push(Xy[e[n+s]]);r.push(a)}var c=/^[1-9]$/;return r.forEach(function(t){var e=0,r=(new y).set(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1),n=r.elements;i[t]=r,t.forEach(function(t){for(var i=!1,r=!1,o=0,a=t.length;o<a;++o){var s=t[o];if("-"===s)i=!0;else if("+"===s)i=!1;else if("/"===s)r=!0;else if("X"===s)n[0+e]=i?-1:1;else if("Y"===s)n[4+e]=i?-1:1;else if("Z"===s)n[8+e]=i?-1:1;else if(c.test(s)){var u=parseInt(s);r?n[12+e]/=u:n[12+e]=u}else vm.warn('getSymmetryOperations: unknown token "'+s+'"')}e+=1})}),i}function Os(t){var e="";return t.length>0&&(e=":"+Xn(t).join(" OR :")),new rm(e)}function Ds(e,i){if(i){t.Debug&&vm.time("assignSecondaryStructure");var r=[];e.eachModel(function(t){t.eachChain(function(t){r.push(t.chainname)})});var n=r.slice().sort(),o=[];n.forEach(function(t){o.push(r.indexOf(t))});var a=i.helices;(a=a.filter(function(t){return Gn(n,t[0])>=0})).sort(function(t,e){var i=t[0],r=e[0],a=t[1],s=e[1];if(i===r)return a===s?0:a<s?-1:1;var c=Gn(n,i),u=Gn(n,r);return o[c]<o[u]?-1:1});var s=e.residueStore;e.eachModel(function(t){var e=0,i=a.length;if(0!==i){var r=a[e],n=!1,o=!1;t.eachChain(function(t){var c=!1;if(t.chainname===r[0])for(var u=t.residueCount,l=t.residueOffset,h=l+u,p=l;p<h;++p)if(s.resno[p]===r[1]&&s.getInscode(p)===r[2]&&(n=!0),n&&(s.sstruc[p]=r[6],s.resno[p]===r[4]&&s.getInscode(p)===r[5]&&(n=!1,(e+=1)<i?(p=l-1,r=a[e],c=t.chainname!==r[0]):o=!0)),c||o)return})}});var c=i.sheets;(c=c.filter(function(t){return Gn(n,t[0])>=0})).sort(function(t,e){var i=t[0],r=e[0];if(i===r)return 0;var a=Gn(n,i),s=Gn(n,r);return o[a]<o[s]?-1:1});var u="e".charCodeAt(0);e.eachModel(function(t){var e=0,i=c.length;if(0!==i){var r=c[e],n=!1,o=!1;t.eachChain(function(t){var a=!1;if(t.chainname===r[0])for(var l=t.residueCount,h=t.residueOffset,p=h+l,d=h;d<p;++d)if(s.resno[d]===r[1]&&s.getInscode(d)===r[2]&&(n=!0),n&&(s.sstruc[d]=u,s.resno[d]===r[4]&&s.getInscode(d)===r[5]&&(n=!1,(e+=1)<i?(d=h-1,r=c[e],a=t.chainname!==r[0]):o=!0)),a||o)return})}}),t.Debug&&vm.timeEnd("assignSecondaryStructure")}}function Ns(t){for(var e=tb.length,i=t,r=0,n=tb[i%e];i>=e;)i=Math.floor(i/e),n+=tb[i%e],r+=1;return r>=5&&vm.warn("chainname overflow"),n}function ks(e,i){t.Debug&&vm.time("calculateChainnames");var r=!0;if(e.eachChain(function(t){t.chainname&&(r=!1)}),r){var n=e.modelStore,o=e.chainStore,a=e.residueStore,s=function(t,e,i,r){for(var s=o.count,c=0;c<r;++c)a.chainIndex[i+c]=s;o.growIfFull(),o.modelIndex[s]=t,o.setChainname(s,e),o.setChainid(s,e),o.residueOffset[s]=i,o.residueCount[s]=r,o.count+=1,n.chainCount[t]+=1},c=e.getAtomProxy(),u=e.getAtomProxy(),l=0,h=0,p=0,d=0,f=[];1===a.count?f.push({mIndex:0,chainname:"A",rStart:0,rCount:1}):e.eachResidueN(2,function(t,e){var r=!1,n=t.backboneType,o=e.backboneType,s=ny;d=t.index,t.modelIndex!==e.modelIndex?r=!0:t.moleculeType!==e.moleculeType?r=!0:n!==s&&n===o&&(c.index=t.backboneEndAtomIndex,u.index=e.backboneStartAtomIndex,r=i?!c.hasBondTo(u):!c.connectedTo(u)),r||e.index!==a.count-1||(r=!0,d=e.index),r&&(f.push({mIndex:h,chainname:Ns(l),rStart:p,rCount:d-p+1}),l+=1,t.modelIndex!==e.modelIndex&&(l=0,h+=1),e.index===a.count-1&&d!==e.index&&f.push({mIndex:h,chainname:Ns(l),rStart:a.count-1,rCount:1}),p=e.index,d=e.index)}),o.count=0,f.forEach(function(t){s(t.mIndex,t.chainname,t.rStart,t.rCount)});var m=0;e.eachModel(function(t){n.chainOffset[t.index]=m,n.chainCount[t.index]-=1,m+=n.chainCount[t.index]})}t.Debug&&vm.timeEnd("calculateChainnames")}function Bs(e){t.Debug&&vm.time("calculateBonds"),Us(e),js(e),t.Debug&&vm.timeEnd("calculateBonds")}function Fs(e){var i=e.structure,r=i.getAtomProxy(),n=i.getAtomProxy(),o=e.atomCount,a=e.atomOffset,s=a+o-1;if(!(o>500)){var c,u,l=[],h=[],p=[];if(o>50){var d=new Rs(e,!0),f=e.isCg()?1.2:2.3;for(c=a;c<s;++c){r.index=c;var m=r.covalent+f+.3,g=d.nearest(r,1/0,m*m),v=g.length;for(u=0;u<v;++u)n.index=g[u].index,r.index<n.index&&r.connectedTo(n)&&(l.push(r.index-a),h.push(n.index-a),p.push(1))}}else for(c=a;c<s;++c)for(r.index=c,u=c+1;u<=s;++u)n.index=u,r.connectedTo(n)&&(l.push(c-a),h.push(u-a),p.push(1));return{atomIndices1:l,atomIndices2:h,bondOrders:p}}t.Debug&&vm.warn("more than 500 atoms, skip residue for auto-bonding",e.qualifiedName())}function zs(e){t.Debug&&vm.time("calculateAtomBondMap");var i=[];return e.eachBond(function(t){var e=t.atomIndex1,r=t.atomIndex2;void 0===i[e]&&(i[e]=[]),i[e][r]=t.index}),t.Debug&&vm.timeEnd("calculateAtomBondMap"),i}function Us(e,i){t.Debug&&vm.time("calculateBondsWithin");var r=e.bondStore,n=e.rungBondStore,o=e.getAtomSet(!1),a=e.getAtomProxy(),s=e.getAtomProxy(),c=e.getBondProxy(),u=i?null:zs(e);e.eachResidue(function(t){if(!i){var e=t.atomCount,l=t.atomOffset;if(e>500)return void vm.warn("more than 500 atoms, skip residue for auto-bonding",t.qualifiedName());for(var h=t.getBonds(),p=h.atomIndices1,d=h.atomIndices2,f=h.bondOrders,m=p.length,g=0;g<m;++g){var v=p[g]+l,y=d[g]+l,b=u[v];void 0!==b&&void 0!==(b=b[y])?(c.index=b,f[t.residueType.getBondIndex(v,y)]=c.bondOrder):(a.index=v,s.index=y,r.addBond(a,s,f[g]))}}var x=t.residueType.traceAtomIndex,_=t.residueType.rungEndAtomIndex;-1!==x&&-1!==_&&(a.index=t.traceAtomIndex,s.index=t.rungEndAtomIndex,n.addBond(a,s),o.set(a.index),o.set(s.index))}),e.atomSetDict.rung=o,t.Debug&&vm.timeEnd("calculateBondsWithin")}function js(e,i,r){function n(t,e){var n=t.backboneType,l=e.backboneType;n!==ny&&n===l&&(c.index=t.backboneEndAtomIndex,u.index=e.backboneStartAtomIndex,(r&&c.hasBondTo(u)||c.connectedTo(u))&&(i||o.addBond(c,u,1),c.index=t.traceAtomIndex,u.index=e.traceAtomIndex,a.addBond(c,u),s.set(c.index),s.set(u.index)))}t.Debug&&vm.time("calculateBondsBetween");var o=e.bondStore,a=e.backboneBondStore,s=e.getAtomSet(!1),c=e.getAtomProxy(),u=e.getAtomProxy();0===a.count&&a.resize(e.residueStore.count),e.eachResidueN(2,n);var l=e.getResidueProxy(),h=e.getResidueProxy();if(e.eachChain(function(t){0!==t.residueCount&&(l.index=t.residueOffset,h.index=t.residueOffset+t.residueCount-1,n(h,l))}),e.atomSetDict.backbone=s,!i){t.Debug&&vm.time("calculateBondsBetween inter");var p=e.spatialHash;e.eachResidue(function(t){t.backboneType!==ny||t.isWater()||t.eachAtom(function(t){p.eachWithin(t.x,t.y,t.z,4,function(e){u.index=e,t.residueIndex!==u.residueIndex&&o.addBondIfConnected(t,u,1)})})}),t.Debug&&vm.timeEnd("calculateBondsBetween inter")}t.Debug&&vm.timeEnd("calculateBondsBetween")}function Vs(e){function i(t){var e=[];return Object.keys(o).forEach(function(i){var u=o[i].clone();s.copy(n).applyMatrix4(u),c.setFromMatrixPosition(u),c.sub(a),s.x>1&&(c.x-=1),s.x<0&&(c.x+=1),s.y>1&&(c.y-=1),s.y<0&&(c.y+=1),s.z>1&&(c.z-=1),s.z<0&&(c.z+=1),t&&c.add(t),u.setPosition(c),u.multiplyMatrices(r.fracToCart,u),u.multiply(r.cartToFrac),e.push(u)}),e}if(e.unitcell){t.Debug&&vm.time("buildUnitcellAssembly");var r=e.unitcell,n=e.center.clone().applyMatrix4(r.cartToFrac),o=Ls(r.spacegroup),a=new v,s=new v,c=new v;n.x>1&&(a.x-=1),n.x<0&&(a.x+=1),n.y>1&&(a.y-=1),n.y<0&&(a.y+=1),n.z>1&&(a.z-=1),n.z<0&&(a.z+=1);var u,l=new Yy("UNITCELL"),h=i();if(e.biomolDict.NCS){u=[new y].concat(e.biomolDict.NCS.partList[0].matrixList);var p=[];h.forEach(function(t){u.forEach(function(e){p.push(t.clone().multiply(e))})}),l.addPart(p)}else l.addPart(h);var d=new v,f=new Yy("SUPERCELL"),m=Array.prototype.concat.call(i(d.set(1,0,0)),i(d.set(0,1,0)),i(d.set(0,0,1)),i(d.set(-1,0,0)),i(d.set(0,-1,0)),i(d.set(0,0,-1)),i(d.set(1,1,0)),i(d.set(1,0,1)),i(d.set(0,1,1)),i(d.set(-1,-1,0)),i(d.set(-1,0,-1)),i(d.set(0,-1,-1)),i(d.set(1,-1,-1)),i(d.set(1,1,-1)),i(d.set(1,-1,1)),i(d.set(-1,1,1)),i(d.set(-1,-1,1)),i(d.set(-1,1,-1)),i(d.set(0,1,-1)),i(d.set(0,-1,1)),i(d.set(1,0,-1)),i(d.set(-1,0,1)),i(d.set(1,-1,0)),i(d.set(-1,1,0)),i(),i(d.set(1,1,1)),i(d.set(-1,-1,-1)));if(e.biomolDict.NCS){var g=[];m.forEach(function(t){u.forEach(function(e){g.push(t.clone().multiply(e))})}),f.addPart(g)}else f.addPart(m);e.biomolDict.UNITCELL=l,e.biomolDict.SUPERCELL=f,t.Debug&&vm.timeEnd("buildUnitcellAssembly")}}function Gs(t){var e=t.trim().toUpperCase();parseInt(e.charAt(0))&&(e=e.substr(1)),parseInt(e.charAt(0))&&(e=e.substr(1));var i=e.length;if(0===i)return"";if(1===i)return e;if(2===i){if(-1!==ib.indexOf(e))return e;if(-1!==eb.indexOf(e[0]))return e[0]}return i>=3&&-1!==eb.indexOf(e[0])?e[0]:""}function $s(t){var e=t.bondHash,i=e.countArray,r=e.offsetArray,n=e.indexArray,o=t.getBondProxy();t.eachResidue(function(t){var e=t.residueType;if(void 0===e.bonds){var a=t.atomOffset,s=[],c=[],u=[],l={};t.eachAtom(function(t){for(var e=t.index,h=r[e],p=0,d=i[e];p<d;++p){o.index=n[h+p];var f=o.atomIndex1,m=o.atomIndex2;if(f>m){var g=m;m=f,f=g}var v=f+"|"+m;void 0===l[v]&&(l[v]=!0,s.push(f-a),c.push(m-a),u.push(o.bondOrder))}}),e.bonds={atomIndices1:s,atomIndices2:c,bondOrders:u}}})}function Hs(t,e){return t+"|"+e}function Ws(t,e,i,r){return t+"|"+e.join(",")+"|"+(i?1:0)+"|"+(r||"")}function Xs(t,e,i){if(0!==i[0]&&0!==i[8]&&0!==i[4])for(var r=t.length,n=i[0],o=i[1],a=i[2],s=-e[0]+n+n/2,c=-e[1]+o+o/2,u=-e[2]+a+a/2,l=0;l<r;l+=3)t[l+0]=(t[l+0]+s)%n,t[l+1]=(t[l+1]+c)%o,t[l+2]=(t[l+2]+u)%a}function qs(t,e){if(0!==e[0]&&0!==e[8]&&0!==e[4]){for(var i=t.length,r=3;r<i;r+=3)for(var n=0;n<3;++n){var o=t[r+n]-t[r-3+n];if(Math.abs(o)>.9*e[3*n+n])if(o>0)for(var a=0;a<3;++a)t[r+a]-=e[3*n+a];else for(var s=0;s<3;++s)t[r+s]+=e[3*n+s]}return t}}function Ys(t,e,i){if(0!==e[0]&&0!==e[8]&&0!==e[4]){for(var r=t.length,n=3;n<r;n+=3)for(var o=0;o<3;++o){var a=(t[n+o]-i[o])/e[3*o+o];Math.abs(a)>.5&&(t[n+o]-=e[3*o+o]*Math.round(a))}return t}}function Zs(t,e,i){return[Zo(e,i[0],3,0,t),Zo(e,i[1],3,1,t),Zo(e,i[2],3,2,t)]}function Ks(t){return[la(t,3,0),la(t,3,1),la(t,3,2)]}function Qs(t,e,i,r,n){for(var o=t.length,a=new Float32Array(o),s=0;s<o;s+=3){var c=s+1,u=s+2;a[s]=yo(r[s],i[s],e[s],t[s],n,1),a[c]=yo(r[c],i[c],e[c],t[c],n,1),a[u]=yo(r[u],i[u],e[u],t[u],n,1)}return a}function Js(t,e,i){for(var r=t.length,n=new Float32Array(r),o=0;o<r;o+=3){var a=o+1,s=o+2;n[o]=vo(e[o],t[o],i),n[a]=vo(e[a],t[a],i),n[s]=vo(e[s],t[s],i)}return n}function tc(t){return"front"===t?Il:"back"===t?Rl:Ll}function ec(t,e){t.matrix.copy(e),t.matrix.decompose(t.position,t.quaternion,t.scale),t.matrixWorldNeedsUpdate=!0}function ic(t,e){function i(e){t(e,r)}function r(){var t=n.shift();void 0!==t?(o=!0,setTimeout(function(){i(t)})):o=!1}var n=[],o=!1;if(e){for(var a=0,s=e.length;a<s;++a)n.push(e[a]);r()}this.push=function(t){n.push(t),o||r()},this.kill=function(){n.length=0},this.length=function(){return n.length}}function rc(t){t.visible=!0}function nc(t){t.visible=!1}function oc(t,e,i,r){var n=i-t,o=r-e;return Math.sqrt(n*n+o*o)}function ac(t){for(var e=t||{},i=Nn(e.width,256),r=Nn(e.height,256),n=[i/2,r/2],o=Math.min(i/2,r/2),a=Nn(e.delta,1/(o+1))*o,s=0,c=0,u=new Uint8Array(i*r*4),l=0,h=u.length;l<h;l+=4){var p=1-bo(o-a,o,oc(s,c,n[0],n[1]));u[l]=255*p,u[l+1]=255*p,u[l+2]=255*p,u[l+3]=255*p,++s===i&&(s=0,c++)}var d=new b(u,i,r);return d.needsUpdate=!0,d}function sc(t){vm.error("makeRepresentation: representation type "+t+" unknown")}function cc(e,i,r,n){t.Debug&&vm.time("makeRepresentation "+e);var o;if(i instanceof bb){if(!(o=Sm.get(e)))return void sc(e)}else if(i instanceof Dy)if("surface"===e)o=Ub;else{if("dot"!==e)return void sc(e);o=Jb}else if(i instanceof ky)if("surface"===e)o=Ub;else if("dot"===e)o=Jb;else{if("slice"!==e)return void sc(e);o=nx}else if(i instanceof Ab)o=gx;else if(i instanceof Lb)o=Nb,i=i.getBufferList();else{if("buffer"!==e)return void vm.error("makeRepresentation: object "+i+" unknown");o=Nb}var a=new o(i,r,n);return t.Debug&&vm.timeEnd("makeRepresentation "+e),a}function uc(t,e){return t instanceof RegExp?null!==e.name.match(t):e.name===t}function lc(t,e){var i,r=0,n={};return e.forEach(function(e){i=0;var o={};e.forEach(function(e){o[t[i++]]=e}),n[t[r++]]=o}),n}function hc(t,e,i,r,n){i=Nn(i,!1),r=Nn(r,""),n=Nn(n,"");var o,a,s,c,u;if(i){var l=t,h=e;r&&n&&(l=t.getView(new rm(r)),h=e.getView(new rm(n)));var p=l.getSequence(),d=h.getSequence(),f=new Ix(p.join(""),d.join(""));f.calc(),f.trace();var m,g,v,y,b;o=0,a=0,s=f.ali1.length;var x=[],_=[];for(m=0;m<s;++m)y=f.ali1[m],b=f.ali2[m],g=0,v=0,"-"===y?_[a]=!1:(_[a]=!0,g=1),"-"===b?x[o]=!1:(x[o]=!0,v=1),o+=g,a+=v;var w=[],S=[],A=l.getAtomProxy(),M=h.getAtomProxy();o=0,l.eachResidue(function(t){void 0!==t.traceAtomIndex&&t.traceAtomIndex===t.getAtomIndexByName("CA")&&(x[o]&&(A.index=t.getAtomIndexByName("CA"),w.push(A.x,A.y,A.z)),o+=1)}),o=0,h.eachResidue(function(t){void 0!==t.traceAtomIndex&&t.traceAtomIndex===t.getAtomIndexByName("CA")&&(_[o]&&(M.index=t.getAtomIndexByName("CA"),S.push(M.x,M.y,M.z)),o+=1)}),c=new Float32Array(w),u=new Float32Array(S)}else c=t.getView(new rm(r+" and .CA")),u=e.getView(new rm(n+" and .CA"));new _b(c,u).transform(t),t.refreshPosition()}function pc(t,e){var i=!1,r=!1,n=!1;return(e=e||new v).set(2*t.x,2*t.y,2*t.z),t.eachBondedAtom(function(t){if(!i)return"H"===t.atomname?(e.set(t),void(i=!0)):void(r||"CA"!==t.atomname?n||"C"!==t.atomname||(n=!0,e.sub(t)):(e.sub(t),r=!0))}),i?e:r&&n?(e.normalize(),e.multiplyScalar(zx),e.add(t),e):void 0}function dc(t){for(var e=t.length,i=new Float32Array(e),r=new Float32Array(e),n=new Float32Array(e),o=0;o<t.length;o++){var a=t[o];i[o]=a.x,r[o]=a.y,n[o]=a.z}return{x:i,y:r,z:n,count:e}}function fc(){return 16777215*Math.random()}function mc(t,e,i){return t&&"Frames"===t.type?new l_(t,e,i):!t&&e.frames?new h_(t,e,i):new p_(t,e,i)}function gc(t,e){var i=t.getAtomProxy(),r=new rm,n=e.length;if(0===n)return new Float32Array(0);var o=e[0].length,a=!Number.isInteger(e[0][0]),s=new Float32Array(n*o*3),c=0;return e.forEach(function(e){for(var n=!1,u=0;u<o;u++){if(a){r.setString(e[u]);var l=t.getAtomIndices(r);if(!l.length){n=!0;break}i.index=l[0]}else i.index=e[u];var h=c+3*u;s[h++]=i.x,s[h++]=i.y,s[h++]=i.z}n||(c+=3*o)}),s.subarray(0,c)}function vc(t,e,i,r,n){var o=Math.cos(n),a=Math.sin(n);t[0]=e[0]+i[0]*o+r[0]*a,t[1]=e[1]+i[1]*o+r[1]*a,t[2]=e[2]+i[2]*o+r[2]*a}function yc(t){var e=JSON.stringify(t);return void 0===y_[e]&&(y_[e]=new b_(t)),y_[e]}function bc(t){for(var e=[],i=t.length/9,r=0;r<i;r++){for(var n=!0,o=r;o<r+3;o+=3)t[o]===t[o+3]&&t[o+1]===t[o+4]&&t[o+2]===t[o+5]&&(n=!1);n&&e.push(r)}var a=new Float32Array(9*e.length),s=0;return e.forEach(function(e){na(t,a,9*e,9*s,9),s++}),a}function xc(t,e){return bc(gc(t,e))}function _c(t,e){for(var i=Nn((e=e||{}).angleStep,Math.PI/90),r=t.length/9,n=new Float32Array(r),o=new Float32Array(3*r),a=new Array(r),s=new Float32Array(6*r),c=new Float32Array(6*r),u=new Array(r),l=new Array(r),h=new Array(r),p=0,d=Ca(),f=Ca(),m=Ca(),g=Ca(),v=Ca(),y=Ca(),b=Ca(),x=Ca(),_=Ca(),w=0;w<r;w++)!function(e){var r=9*e;Da(d,t,r),Da(f,t,r+3),Da(m,t,r+6);var w=6*e;Na(d,s,w),Na(f,c,w),Na(f,s,w+3),Na(m,c,w+3),La(g,d,f),La(v,m,f),za(g,g),za(v,v),Ia(y,g,v);var S=ka(y),A=Ra(g,v),M=n[e]=Math.atan2(S,A);a[e]=(og*M).toFixed(1)+String.fromCharCode(176),0===ka(y)&&(y[0]=1,y[1]=0,y[2]=0),Ia(b,y,g),za(b,b),vc(x,f,g,b,M/2),Na(x,o,3*e);var P=Math.ceil(M/i),E=new Float32Array(9*P);h[e]=E;var T=new Float32Array(3*P),C=new Float32Array(3*P);u[e]=T,l[e]=C,Oa(_,f,g);for(var I=function(t,e){var i=9*e,r=3*e;Na(f,E,i),Na(_,E,i+3),Na(_,T,r),vc(_,f,g,b,t),Na(_,E,i+6),Na(_,C,r)},R=0,L=i;L<M;L+=i)I(L,R),R++;I(M,R),p+=P}(w);for(var S=3*p,A=9*p,M=new Float32Array(S),P=new Float32Array(S),E=new Float32Array(A),T=0,C=0,I=0;I<r;I++){var R=u[I],L=l[I];na(R,M,0,C,R.length),na(L,P,0,C,L.length),C+=R.length;var O=h[I];na(O,E,0,T,O.length),T+=O.length}return{labelPosition:o,labelText:a,vectorPosition1:s,vectorPosition2:c,arcPosition1:M,arcPosition2:P,sectorPosition:E}}function wc(t,e){function i(t,i,r,n,o,a,s){a[s+0]=yo(t.x,i.x,r.x,n.x,o,e),a[s+1]=yo(t.y,i.y,r.y,n.y,o,e),a[s+2]=yo(t.z,i.z,r.z,n.z,o,e)}function r(t,i,r,n,o,a){a.x=yo(t.x,i.x,r.x,n.x,o,e),a.y=yo(t.y,i.y,r.y,n.y,o,e),a.z=yo(t.z,i.z,r.z,n.z,o,e)}function n(e,r,n,o,a,s){for(var c=0;c<t;++c)i(e,r,n,o,p*c,a,s+3*c)}function o(e,i,n,o,a,s){for(var c=0;c<t;++c){var u=p*c,l=u-d,h=u+d,g=s+3*c;l<0&&(l=0),h>1&&(h=1),r(e,i,n,o,l,f),r(e,i,n,o,h,m),m.sub(f).normalize(),m.toArray(a,g)}}function a(e,i,r,n,o){for(var a=i.next(),s=i.next(),c=i.next(),u=i.size,l=u-1,h=n||0,p=0;p<l;++p)e(a,a=s,s=c,c=i.next(),r,h),h+=3*t;o&&(e(i.get(u-2),a=i.get(u-1),s=i.get(0),c=i.get(1),r,h),h+=3*t)}function s(e,i,n,o,a,s,c,u,l,h,d,v,w){for(var S=0;S<t;++S){var A=v+3*S;w&&(A+=3*_);var M=p*S;r(e,i,n,o,M,f),r(a,s,c,u,M,m),g.subVectors(m,f).normalize(),y.fromArray(l,A),x.crossVectors(g,y).normalize(),x.toArray(d,A),b.crossVectors(y,x).normalize(),b.toArray(h,A)}}function c(e,i,r,n,o){for(var a=0;a<t;++a){var s=o+3*a;e.copy(b),y.fromArray(i,s),x.crossVectors(e,y).normalize(),x.toArray(n,s),b.crossVectors(y,x).normalize(),b.toArray(r,s)}}function u(e,i,r,n,o){var a;for(a=0;a<_;++a)r(e,n,o+3*a);for(a=_;a<t;++a)r(i,n,o+3*a)}function l(e,i,r,n,o){var a;for(a=0;a<_;++a)n[o+a]=r(e);for(a=_;a<t;++a)n[o+a]=r(i)}function h(e,i,r,n,o){for(var a=r(e),s=r(i),c=0;c<t;++c){var u=c/t;n[o+c]=(1-u)*a+u*s}}var p=1/t,d=1e-4,f=new v,m=new v;this.getPosition=function(e,i,r,o){e.reset(),a(n,e,i,r,o);var s=e.size-1,c=s*t*3;o&&(c+=3*t);var u=e.get(o?0:s);i[c]=u.x,i[c+1]=u.y,i[c+2]=u.z},this.getTangent=function(e,i,r,n){e.reset(),a(o,e,i,r,n);var s=(e.size-1)*t*3;n&&(s+=3*t),na(i,i,s-3,s,3)};var g=new v,y=new v,b=new v,x=new v,_=Math.ceil(t/2);this.getNormal=function(e,i,r,n,o,a){b.set(0,0,1);for(var s=e-1,u=o||0,l=0;l<s;++l)c(g,i,r,n,u),u+=3*t;a&&(c(g,i,r,n,u),u+=3*t),x.toArray(n,u),b.toArray(r,u)},this.getNormalDir=function(e,i,r,n,o,a,c,u){e.reset(),i.reset();var l=new v,h=new v,p=new v,d=new v,f=new v,m=(new v).copy(e.next()),g=(new v).copy(e.next()),y=(new v).copy(e.next()),w=new v,S=(new v).copy(i.next()),A=(new v).copy(i.next()),M=(new v).copy(i.next());b.set(0,0,1);for(var P=e.size,E=P-1,T=a||0,C=0;C<E;++C)f.copy(m),m.copy(g),g.copy(y),y.copy(e.next()),w.copy(S),S.copy(A),A.copy(M),M.copy(i.next()),0===C?(l.subVectors(w,f),h.subVectors(S,m),l.dot(h)<0&&(h.multiplyScalar(-1),S.addVectors(m,h)),p.subVectors(A,g),h.dot(p)<0&&(p.multiplyScalar(-1),A.addVectors(g,p))):p.copy(d),d.subVectors(M,y),p.dot(d)<0&&(d.multiplyScalar(-1),M.addVectors(y,d)),s(f,m,g,y,w,S,A,M,r,n,o,T,u),T+=3*t;if(c&&(f.copy(e.get(P-2)),m.copy(e.get(P-1)),g.copy(e.get(0)),y.copy(e.get(1)),w.copy(i.get(P-2)),S.copy(i.get(P-1)),A.copy(i.get(0)),M.copy(i.get(1)),p.copy(d),d.subVectors(M,y),p.dot(d)<0&&(d.multiplyScalar(-1),M.addVectors(y,d)),s(f,m,g,y,w,S,A,M,r,n,o,T,u),T+=3*t),u){x.fromArray(o,3*_),b.fromArray(n,3*_);for(var I=0;I<_;++I)x.toArray(o,3*I),b.toArray(n,3*I)}else x.toArray(o,T),b.toArray(n,T)},this.getColor=function(e,i,r,n,o){e.reset(),e.next();for(var a=e.next(),s=e.size,c=s-1,l=n||0,h=0;h<c;++h)u(a,a=e.next(),i,r,l),l+=3*t;o&&(u(e.get(s-1),a=e.get(0),i,r,l),l+=3*t),r[l]=r[l-3],r[l+1]=r[l-2],r[l+2]=r[l-1]},this.getPicking=function(e,i,r,n,o){e.reset(),e.next();for(var a=e.next(),s=e.size,c=s-1,u=n||0,h=0;h<c;++h)l(a,a=e.next(),i,r,u),u+=t;o&&(l(e.get(s-1),a=e.get(0),i,r,u),u+=t),r[u]=r[u-1]},this.getSize=function(e,i,r,n,o){e.reset(),e.next();for(var a=e.next(),s=e.size,c=s-1,u=n||0,l=0;l<c;++l)h(a,a=e.next(),i,r,u),u+=t;o&&(h(e.get(s-1),a=e.get(0),i,r,u),u+=t),r[u]=r[u-1]}}function Sc(t,e){this.polymer=t,this.size=t.residueCount;var i=e||{};this.directional=i.directional||!1,this.positionIterator=i.positionIterator||!1,this.subdiv=i.subdiv||1,this.smoothSheet=i.smoothSheet||!1,this.tension=i.tension?i.tension:this.polymer.isNucleic()?.5:.9,this.interpolator=new wc(this.subdiv,this.tension)}function Ac(t,e,i){e=e||3.5,i=i||40;for(var r=new rm("( ARG and ( .NE or .NH1 or .NH2 ) ) or ( ASP and .ND2 ) or ( GLN and .NE2 ) or ( HIS and ( .ND1 or .NE2 ) ) or ( LYS and .NZ ) or ( SER and .OG ) or ( THR and .OG1 ) or ( TRP and .NE1 ) or ( TYR and .OH ) or ( PROTEIN and .N )"),n=new rm("( ASN and .OD1 ) or ( ASP and ( OD1 or .OD2 ) ) or ( GLN and .OE1 ) or ( GLU and ( .OE1 or .OE2 ) ) or ( HIS and ( .ND1 or .NE2 ) ) or ( SER and .OG ) or ( THR and .OG1 ) or ( TYR and .OH ) or ( PROTEIN and .O )"),o=t.getView(r),a=t.getView(n),s=new R_(o,a).within(e),c=s.bondStore,u=t.getAtomProxy(),l=t.getAtomProxy(),h=t.getAtomProxy(),p=t.getAtomProxy(),d=t.getResidueProxy(),f=t.getResidueProxy(),m=new v,g=new v,y=0,b=c.count;y<b;++y)if(u.index=c.atomIndex1[y],l.index=c.atomIndex2[y],"O"===u.atomname&&"N"===l.atomname||"N"===u.atomname&&"O"===l.atomname)s.bondSet.clear(y);else if("N"===u.atomname||"N"===l.atomname){var x,_;if("N"===u.atomname?(x=u,_=l):(x=l,_=u),d.index=x.residueIndex,h.index=d.getAtomIndexByName("CA"),void 0===h.index)continue;var w=d.getPreviousConnectedResidue(f);if(void 0===w)continue;if(p.index=w.getAtomIndexByName("C"),void 0===p.index)continue;m.subVectors(x,p),g.subVectors(x,h),m.add(g).multiplyScalar(.5),g.subVectors(_,x),uo(m.angleTo(g))>i&&s.bondSet.clear(y)}else("OH"===u.atomname&&"TYR"===u.resname||"OH"===l.atomname&&"TYR"===l.resname)&&(function(t,e,r,n){var o,a;t.atomname===r?(o=t,a=e):(o=e,a=t),d.index=o.residueIndex;var s=d.getAtomIndexByName(n);return m.subVectors(s,o),g.subVectors(s,a),uo(m.angleTo(g))<i}(u,l,"OH","CZ")||s.bondSet.clear(y));return{atomSet:s.atomSet,bondSet:s.bondSet,bondStore:s.bondStore}}function Mc(t,e,i){e=e||3.5,i=i||40;for(var r=new rm("( PROTEIN and .N )"),n=new rm("( PROTEIN and .O )"),o=t.getView(r),a=t.getView(n),s=new R_(o,a).within(e),c=s.bondStore,u=t.getAtomProxy(),l=t.getAtomProxy(),h=t.getAtomProxy(),p=t.getAtomProxy(),d=t.getResidueProxy(),f=t.getResidueProxy(),m=new v,g=new v,y=0,b=c.count;y<b;++y){u.index=c.atomIndex1[y],l.index=c.atomIndex2[y];var x,_;if("N"===u.atomname?(x=u,_=l):(x=l,_=u),d.index=x.residueIndex,h.index=d.getAtomIndexByName("CA"),void 0!==h.index){var w=d.getPreviousConnectedResidue(f);void 0!==w&&(p.index=w.getAtomIndexByName("C"),void 0!==p.index&&(m.subVectors(x,p),g.subVectors(x,h),m.add(g).multiplyScalar(.5),g.subVectors(_,x),uo(m.angleTo(g))>i&&s.bondSet.clear(y)))}}return{atomSet:s.atomSet,bondSet:s.bondSet,bondStore:s.bondStore}}function Pc(t,e){for(var i=Nn((e=e||{}).angleStep,Math.PI/90),r=t.length,n=t.length/12,o=new Float32Array(n),a=new Float32Array(3*n),s=new Array(n),c=new Array(n),u=new Array(n),l=new Array(n),h=new Array(n),p=0,d=0,f=0,m=Ca(),g=Ca(),v=Ca(),y=Ca(),b=Ca(),x=Ca(),_=Ca(),w=Ca(),S=Ca(),A=Ca(),M=Ca(),P=Ca(),E=Ca(),T=Ca(),C=Ca(),I=0,R=0;R<r;R+=12)!function(e){if(Da(m,t,e),Da(g,t,e+3),Da(v,t,e+6),Da(y,t,e+9),La(b,m,g),La(x,v,g),0!==ka(x)){La(_,y,v),Fa(w,x,.5),Oa(S,g,w),za(b,b),za(x,x),za(_,_),La(w,m,S);var r=Ra(w,x)>0;La(w,y,S);var n=Ra(w,x)<0;if(Fa(w,x,Ra(x,b)),La(A,b,w),Fa(w,x,Ra(x,_)),La(M,_,w),0!==ka(A)&&0!==ka(M)){za(A,A),za(M,M);var R=o[I]=Math.acos(Ra(A,M));s[I]=(og*R).toFixed(1)+String.fromCharCode(176),Ia(T,A,x),za(T,T),Ra(T,M)<0&&$a(T,T),vc(w,S,A,T,R/2),Na(w,a,3*I);var L=Math.ceil(R/i),O=L+2,D=new Float32Array(3*O),N=new Float32Array(3*O),k=new Float32Array(9*L),B=new Float32Array(36);c[I]=D,u[I]=N,l[I]=k,h[I]=B,r?(La(w,m,v),za(w,w),Fa(P,w,1/Ra(A,w)),Oa(P,P,v)):(Fa(P,b,1/Ra(A,b)),Oa(P,P,g)),n?(La(w,y,g),za(w,w),Fa(E,w,1/Ra(M,w)),Oa(E,E,g)):(Fa(E,_,1/Ra(M,_)),Oa(E,E,v)),Oa(C,S,A),Na(P,D,0),Na(C,N,0),Na(P,B,0),Na(C,B,3),Na(r?v:g,B,6),Na(r?v:g,B,9),Na(C,B,12),Na(S,B,15);for(var F=function(t,e){var i=9*e,r=3*e;Na(S,k,i),Na(C,k,i+3),Na(C,D,r),vc(C,S,A,T,t),Na(C,k,i+6),Na(C,N,r)},z=0,U=i;U<R;U+=i)F(U,z++);F(R,z++),n?(La(w,y,g),za(w,w),Oa(w,w,g)):Oa(w,v,_),Na(C,D,3*z),Na(w,N,3*z),Na(E,B,18),Na(C,B,21),Na(n?g:v,B,24),Na(n?g:v,B,27),Na(C,B,30),Na(S,B,33),p+=3*O,d+=9*L,f+=36,I+=1}}}(R);for(var L=I,O=new Float32Array(p),D=new Float32Array(p),N=new Float32Array(d),k=new Float32Array(f),B=0,F=0,z=0,U=0;U<L;U++){var j=c[U],V=u[U],G=l[U],$=h[U];na(j,O,0,B,j.length),na(V,D,0,B,V.length),na(G,N,0,F,G.length),na($,k,0,z,$.length),B+=j.length,F+=G.length,z+=$.length}return{labelPosition:a.subarray(0,3*L),labelText:s.slice(0,L),linePosition1:O,linePosition2:D,planePosition:k,sectorPosition:N}}function Ec(t,e){this.type=t,this.text=e||{}}function Tc(t){var e=t.getAtomSet(),i=t.getBondSet(),r=t.getBondProxy();return i.forEach(function(t){r.index=t,e.clear(r.atomIndex1),e.clear(r.atomIndex2)}),e}function Cc(t,e,i,r,n){function o(t,r,o){return((t*e+r)*i+o)*n}var a,s=new(r=r||Int32Array)(t*e*i*(n=n||1));this.data=s,this.index=o,this.set=function(t,e,i){var r=arguments,c=o(t,e,i);for(a=0;a<n;++a)s[c+a]=r[3+a]},this.toArray=function(t,e,i,r,c){var u=o(t,e,i);for(void 0===r&&(r=[]),void 0===c&&(c=0),a=0;a<n;++a)r[c+a]=s[u+a]},this.fromArray=function(t,e,i,r,c){var u=o(t,e,i);for(void 0===c&&(c=0),a=0;a<n;++a)s[u+a]=r[c+a]},this.copy=function(t){this.data.set(t.data)},this.clone=function(){return new Cc(t,e,i,r,n).copy(this)}}function Ic(t,e,i){function r(t,e,i,r,o){m=e||1.4,g=i||2,P=o||!0;var a=0;for(var s in d)a=Math.max(a,s);var c=Ms(I,R,a,g,t?m:0);y=c.dim[0],b=c.dim[1],x=c.dim[2],_=c.matrix,w=c.tran,g=c.scaleFactor,S={},A={},n(t),M=m*g,v=r||m/g,E=new Uint8Array(y*b*x),t&&(T=new Float64Array(y*b*x)),P&&(C=new Int32Array(y*b*x))}function n(t){var e,i,r,n,o,a,s,c,u,l;for(var h in d)if(e=d[h],!S[h]){for(a=(s=t?(e+m)*g+.5:e*g+.5)*s,c=Math.floor(s)+1,u=new Int32Array(c*c),l=0,i=0;i<c;++i)for(r=0;r<c;++r)(n=i*i+r*r)>a?u[l]=-1:(o=Math.sqrt(a-n),u[l]=Math.floor(o)),++l;A[h]=c,S[h]=u}}function o(i){var r,n,o,a,s,c,u,l,h,p,d,f,m,v,_,M,T,I,R=3*i,O=i;r=Math.floor(.5+g*(t[R]+w[0])),n=Math.floor(.5+g*(t[R+1]+w[1])),o=Math.floor(.5+g*(t[R+2]+w[2]));var D,N=e[O],k=S[N],B=0,F=b*x,z=A[N];for(p=0;p<z;++p)for(d=0;d<z;++d){if(-1!==(D=k[B]))for(M=-1;M<2;++M)for(T=-1;T<2;++T)for(I=-1;I<2;++I)if(0!==M&&0!==T&&0!==I)for(u=M*p,h=I*d,f=0;f<=D;++f)if(l=f*T,m=r+u,v=n+l,_=o+h,!(m<0||v<0||_<0||m>=y||v>=b||_>=x)){var U=m*F+v*x+_;if(P)if(E[U]&L){if(E[U]&L){var j=C[U];j!==R&&u*u+l*l+h*h<(a=r+u-Math.floor(.5+g*(t[j]+w[0])))*a+(s=n+l-Math.floor(.5+g*(t[j+1]+w[1])))*s+(c=o+h-Math.floor(.5+g*(t[j+2]+w[2])))*c&&(C[U]=i)}}else E[U]|=L,C[U]=i;else E[U]|=L}B++}}function a(e){console.time("EDTSurface fillvoxels");var i,r;for(i=0,r=E.length;i<r;++i)E[i]=0,e&&(T[i]=-1),P&&(C[i]=-1);for(i=0,r=t.length/3;i<r;++i)o(i);for(i=0,r=E.length;i<r;++i)E[i]&L&&(E[i]|=O);console.timeEnd("EDTSurface fillvoxels")}function s(i){var r,n,o,a,s,c,u,l,h,p,d,f,m,v,_,M,T,I,R,L=3*i,D=i,N=0;r=Math.floor(.5+g*(t[L]+w[0])),n=Math.floor(.5+g*(t[L+1]+w[1])),o=Math.floor(.5+g*(t[L+2]+w[2]));var k=e[D],B=b*x;for(m=0,R=A[k];m<R;++m)for(v=0;v<R;++v){if(-1!==S[k][N])for(M=-1;M<2;++M)for(T=-1;T<2;++T)for(I=-1;I<2;++I)if(0!==M&&0!==T&&0!==I)for(u=M*m,h=I*v,_=0;_<=S[k][N];++_)if(l=_*T,p=r+u,d=n+l,f=o+h,!(p<0||d<0||f<0||p>=y||d>=b||f>=x)){var F=p*B+d*x+f;if(E[F]&O){if(P){var z=C[F];u*u+l*l+h*h<(a=Math.floor(.5+g*(t[z]+w[0])))*a+(s=Math.floor(.5+g*(t[z+1]+w[1])))*s+(c=Math.floor(.5+g*(t[z+2]+w[2])))*c&&(C[F]=i)}}else E[F]|=O,P&&(C[F]=i)}N++}}function c(){var e,i;for(e=0,i=E.length;e<i;++e)E[e]&=~O;for(e=0,i=t.length/3;e<i;++e)s(e)}function u(){var t,e,i,r=b*x;for(t=0;t<y;++t)for(e=0;e<x;++e)for(i=0;i<b;++i){var n=t*r+i*x+e;if(E[n]&L)for(var o=0;o<26;){var a=t+N[o][0],s=e+N[o][2],c=i+N[o][1];if(a>-1&&a<y&&c>-1&&c<b&&s>-1&&s<x&&!(E[a*r+c*x+s]&L)){E[n]|=D;break}o++}}}function l(){console.time("EDTSurface fastdistancemap");var t,e,i,r,n,o=new Cc(y,b,x,Uint16Array,3),a=b*x,s=M*M,c=0;for(t=0;t<y;++t)for(e=0;e<b;++e)for(i=0;i<x;++i)E[n=t*a+e*x+i]&=~O,E[n]&L&&E[n]&D&&(o.set(t,e,i,t,e,i),T[n]=0,E[n]|=O,c+=1);var u=new Int32Array(3*c),l=0,p=new Int32Array(3*c),d=0;for(t=0;t<y;++t)for(e=0;e<b;++e)for(i=0;i<x;++i)E[n=t*a+e*x+i]&D&&(u[l]=t,u[l+1]=e,u[l+2]=i,l+=3,E[n]&=~D);do{for(d=h(u,o,l,p),l=0,t=0,r=d;t<r;t+=3)n=a*p[t]+x*p[t+1]+p[t+2],E[n]&=~D,T[n]<=1.0404*s&&(u[l]=p[t],u[l+1]=p[t+1],u[l+2]=p[t+2],l+=3)}while(l>0);var f,m=v*v,g=new Uint16Array(3);for(t=0;t<y;++t)for(e=0;e<b;++e)for(i=0;i<x;++i)E[n=t*a+e*x+i]&=~D,E[n]&L&&(E[n]&O&&!(E[n]&O&&T[n]>=m)||(E[n]|=D,P&&E[n]&O&&(o.toArray(t,e,i,g),f=g[0]*a+g[1]*x+g[2],C[n]=C[f])));console.timeEnd("EDTSurface fastdistancemap")}function h(t,e,i,r){var n,o,a,s,c,u,l,h,p,d,f,m,g=new Uint16Array(3),v=0;if(0===i)return v;var _=-1,w=-1,S=-1,A=b*x;for(l=0,p=i;l<p;l+=3)for(n=t[l],o=t[l+1],a=t[l+2],e.toArray(n,o,a,g),h=0;h<6;++h)_=n+(m=N[h])[0],w=o+m[1],S=a+m[2],_<y&&_>-1&&w<b&&w>-1&&S<x&&S>-1&&(E[f=_*A+x*w+S]&L&&!(E[f]&O)?(e.fromArray(_,w,S,g),d=(s=_-g[0])*s+(c=w-g[1])*c+(u=S-g[2])*u,T[f]=d,E[f]|=O,E[f]|=D,r[v]=_,r[v+1]=w,r[v+2]=S,v+=3):E[f]&L&&E[f]&O&&(d=(s=_-g[0])*s+(c=w-g[1])*c+(u=S-g[2])*u)<T[f]&&(e.fromArray(_,w,S,g),T[f]=d,E[f]&D||(E[f]|=D,r[v]=_,r[v+1]=w,r[v+2]=S,v+=3)));for(l=0,p=i;l<p;l+=3)for(n=t[l],o=t[l+1],a=t[l+2],e.toArray(n,o,a,g),h=6;h<18;h++)_=n+(m=N[h])[0],w=o+m[1],S=a+m[2],_<y&&_>-1&&w<b&&w>-1&&S<x&&S>-1&&(E[f=_*A+x*w+S]&L&&!(E[f]&O)?(e.fromArray(_,w,S,g),d=(s=_-g[0])*s+(c=w-g[1])*c+(u=S-g[2])*u,T[f]=d,E[f]|=O,E[f]|=D,r[v]=_,r[v+1]=w,r[v+2]=S,v+=3):E[f]&L&&E[f]&O&&(d=(s=_-g[0])*s+(c=w-g[1])*c+(u=S-g[2])*u)<T[f]&&(e.fromArray(_,w,S,g),T[f]=d,E[f]&D||(E[f]|=D,r[v]=_,r[v+1]=w,r[v+2]=S,v+=3)));for(l=0,p=i;l<p;l+=3)for(n=t[l],o=t[l+1],a=t[l+2],e.toArray(n,o,a,g),h=18;h<26;h++)_=n+(m=N[h])[0],w=o+m[1],S=a+m[2],_<y&&_>-1&&w<b&&w>-1&&S<x&&S>-1&&(E[f=_*A+x*w+S]&L&&!(E[f]&O)?(e.fromArray(_,w,S,g),d=(s=_-g[0])*s+(c=w-g[1])*c+(u=S-g[2])*u,T[f]=d,E[f]|=O,E[f]|=D,r[v]=_,r[v+1]=w,r[v+2]=S,v+=3):E[f]&L&&E[f]&O&&(d=(s=_-g[0])*s+(c=w-g[1])*c+(u=S-g[2])*u)<T[f]&&(e.fromArray(_,w,S,g),T[f]=d,E[f]&D||(E[f]|=D,r[v]=_,r[v+1]=w,r[v+2]=S,v+=3)));return v}function p(t){var e,i=E.length;if("vws"===t)for(e=0;e<i;++e)E[e]&=~D,E[e]=E[e]&O?1:0;else if("ms"===t)for(e=0;e<i;++e)E[e]&=~O,E[e]&D&&(E[e]|=O),E[e]&=~D,E[e]=E[e]&O?1:0;else if("ses"===t)for(e=0;e<i;++e)E[e]&D&&E[e]&O?E[e]&=~D:E[e]&D&&!(E[e]&O)&&(E[e]|=O),E[e]=E[e]&O?1:0;else if("sas"===t)for(e=0;e<i;++e)E[e]&=~D,E[e]=E[e]&O?1:0}var d=As(e),f=Ma(t);0===t.length&&(f[0].set([0,0,0]),f[1].set([0,0,0]));var m,g,v,y,b,x,_,w,S,A,M,P,E,T,C,I=f[0],R=f[1],L=1,O=2,D=4,N=[new Int32Array([1,0,0]),new Int32Array([-1,0,0]),new Int32Array([0,1,0]),new Int32Array([0,-1,0]),new Int32Array([0,0,1]),new Int32Array([0,0,-1]),new Int32Array([1,1,0]),new Int32Array([1,-1,0]),new Int32Array([-1,1,0]),new Int32Array([-1,-1,0]),new Int32Array([1,0,1]),new Int32Array([1,0,-1]),new Int32Array([-1,0,1]),new Int32Array([-1,0,-1]),new Int32Array([0,1,1]),new Int32Array([0,1,-1]),new Int32Array([0,-1,1]),new Int32Array([0,-1,-1]),new Int32Array([1,1,1]),new Int32Array([1,1,-1]),new Int32Array([1,-1,1]),new Int32Array([-1,1,1]),new Int32Array([1,-1,-1]),new Int32Array([-1,-1,1]),new Int32Array([-1,1,-1]),new Int32Array([-1,-1,-1])];this.getVolume=function(t,e,o,s,h){console.time("EDTSurface.getVolume");var d="vws"!==t;r(d,e,o,s,h),a(d),u(),"ms"!==t&&"ses"!==t||l(),"ses"===t&&(n(!1),c()),p(t);for(var f=0,m=C.length;f<m;++f)C[f]=i[C[f]];return console.timeEnd("EDTSurface.getVolume"),{data:E,nx:x,ny:b,nz:y,atomindex:C}},this.getSurface=function(t,e,i,r,n,o,a){var s=this.getVolume(t,e,i,r,n);return new Ps(s.data,s.nx,s.ny,s.nz,s.atomindex).getSurface(1,o,void 0,_,a)}}function Rc(t,e,i,r,n,o,a){function s(t,e){return Math.floor((t-e)/a)}for(var c=t.length,u=n[0],l=n[1],h=n[2],p=o[0],d=o[1],f=o[2],m=s(p,u)+1,g=s(d,l)+1,v=s(f,h)+1,y=m*g*v,b=g*v,x=[],_=0;_<c;_++){var w=function(t,e,i){return(s(t,u)*g+s(e,l))*v+s(i,h)}(t[_],e[_],i[_]);void 0===x[w]?x[w]=[_]:x[w].push(_)}var S=new Uint32Array(y),A=new Uint16Array(y),M=new Uint32Array(c),P=0,E=0;for(_=0;_<y;_++){var T=S[_]=P,C=x[_];if(void 0!==C)for(var I=0;I<C.length;I++)M[P]=C[I],P++;var R=P-T;A[_]=R,R>E&&(E=R)}this.neighbourListLength=27*E+1,this.withinRadii=function(n,o,a,c,p){for(var d=0,f=s(n,u),y=s(o,l),x=s(a,h),_=Math.max(0,f-1),w=Math.max(0,y-1),P=Math.max(0,x-1),E=Math.min(m,f+1),T=Math.min(g,y+1),C=Math.min(v,x+1),I=_;I<=E;++I)for(var R=I*b,L=w;L<=T;++L)for(var O=L*v,D=P;D<=C;++D)for(var N=R+O+D,k=S[N],B=k+A[N],F=k;F<B;F++){var z=M[F],U=t[z]-n,j=e[z]-o,V=i[z]-a,G=r[z]+c;U*U+j*j+V*V<=G*G&&(p[d++]=M[F])}p[d]=-1}}function Lc(t,e,i){function r(t,i,r,n){E=Nn(t,1.4),T=Nn(i,2),C=Nn(r,!0),I=Nn(n,30),A=new Float32Array(v),M=new Float32Array(v);for(var c=0;c<A.length;++c){var u=e[c]+E;A[c]=u,M[c]=u*u}P=0;for(var l=0;l<A.length;++l)A[l]>P&&(P=A[l]);o(),a(),s(),H=-1}function n(t,e,i){for(var r=0;r<t.length;r++)t[r]=e+i*r}function o(){var t=Ms(G,$,P,T,0);T=t.scaleFactor,R=t.dim,L=t.matrix,V=Math.min(5,2+Math.floor(E*T)),O=Qo(R[0]*R[1]*R[2],-1001),D=new Int32Array(O.length),N=new Float32Array(R[0]),k=new Float32Array(R[1]),B=new Float32Array(R[2]),n(N,G[0],1/T),n(k,G[1],1/T),n(B,G[2],1/T)}function a(){var t=0,e=2*Math.PI/I;z=new Float32Array(I),F=new Float32Array(I);for(var i=0;i<I;i++)z[i]=Math.cos(t),F[i]=Math.sin(t),t+=e}function s(){U=new Rc(y,b,x,A,G,$,2.01*P),j=new Int32Array(U.neighbourListLength)}function c(t,e,i,r,n){var o;if(-1!==H){if((o=H)!==r&&o!==n&&u(o,t,e,i))return o;H=-1}var a=0;for(o=j[a];o>=0;){if(o!==r&&o!==n&&u(o,t,e,i))return H=o,o;o=j[++a]}return H=-1,-1}function u(e,i,r,n){var o=3*e,a=M[e],s=t[o]-i,c=t[o+1]-r,u=t[o+2]-n;return s*s+c*c+u*u<a}function l(){for(var t=0;t<v;t++){var e=y[t],i=b[t],r=x[t],n=A[t],o=M[t];U.withinRadii(e,i,r,n,j);for(var a=Math.ceil(n*T),s=Math.floor(T*(e-G[0])),u=Math.floor(T*(i-G[1])),l=Math.floor(T*(r-G[2])),h=Math.max(0,s-a),p=Math.max(0,u-a),d=Math.max(0,l-a),f=Math.min(R[0],s+a+2),m=Math.min(R[1],u+a+2),g=Math.min(R[2],l+a+2),_=h;_<f;_++)for(var w=N[_]-e,S=R[1]*R[2]*_,P=p;P<m;P++)for(var E=k[P]-i,I=w*w+E*E,L=S+R[2]*P,F=d;F<g;F++){var z=B[F]-r,V=I+z*z;if(V<o){var $=F+L;O[$]<0&&(O[$]=-O[$]);var H=Math.sqrt(V),W=n/H,X=w*W,q=E*W,Y=z*W;if(X+=e,q+=i,Y+=r,-1===c(X,q,Y,t,-1)){var Z=n-H;Z<O[$]&&(O[$]=Z,C&&(D[$]=t))}}}}}function h(){for(var t=0;t<v;t++){U.withinRadii(y[t],b[t],x[t],A[t],j);for(var e=0,i=j[e];i>=0;)t<i&&p(t,i),i=j[++e]}}function p(t,e){var i=A[t],r=A[e],n=W[0]=y[e]-y[t],o=W[1]=b[e]-b[t],a=W[2]=x[e]-x[t],s=n*n+o*o+a*a,u=Math.sqrt(s),l=i*((i*i+u*u-r*r)/(2*i*u));za(W,W),d(X,W),za(X,X),Ia(q,W,X),za(q,q);var h=Math.sqrt(i*i-l*l);Fa(X,X,h),Fa(q,q,h),Fa(W,W,l),W[0]+=y[t],W[1]+=b[t],W[2]+=x[t],H=-1;for(var p=V,f=0;f<I;f++){var m=z[f],g=F[f],v=W[0]+m*X[0]+g*q[0],_=W[1]+m*X[1]+g*q[1],w=W[2]+m*X[2]+g*q[2];if(-1===c(v,_,w,t,e))for(var S=Math.floor(T*(v-G[0])),M=Math.floor(T*(_-G[1])),P=Math.floor(T*(w-G[2])),E=Math.max(0,S-p),L=Math.max(0,M-p),U=Math.max(0,P-p),j=Math.min(R[0],S+p+2),$=Math.min(R[1],M+p+2),Y=Math.min(R[2],P+p+2),Z=E;Z<j;Z++){n=v-N[Z];for(var K=R[1]*R[2]*Z,Q=L;Q<$;Q++)for(var J=n*n+(o=_-k[Q])*o,tt=K+R[2]*Q,et=U;et<Y;et++){s=J+(a=w-B[et])*a;var it=et+tt,rt=O[it];rt>0&&s<rt*rt&&(O[it]=Math.sqrt(s),C&&(D[it]=t))}}}}function d(t,e){return t[0]=t[1]=t[2]=1,0!==e[0]?t[0]=(e[1]+e[2])/-e[0]:0!==e[1]?t[1]=(e[0]+e[2])/-e[1]:0!==e[2]&&(t[2]=(e[0]+e[1])/-e[2]),t}function f(){for(var t=0;t<O.length;t++)O[t]<0&&(O[t]=0)}function m(){for(var t=0;t<D.length;t++)D[t]=i[D[t]]}function g(t,e,i){console.time("AVSurface.getVolume"),console.time("AVSurface.init"),r(t,e,i),console.timeEnd("AVSurface.init"),console.time("AVSurface.projectPoints"),l(),console.timeEnd("AVSurface.projectPoints"),console.time("AVSurface.projectTorii"),h(),console.timeEnd("AVSurface.projectTorii"),f(),m(),console.timeEnd("AVSurface.getVolume")}for(var v=e.length,y=new Float32Array(v),b=new Float32Array(v),x=new Float32Array(v),_=0;_<v;_++){var w=3*_;y[_]=t[w],b[_]=t[w+1],x[_]=t[w+2]}var S=Ma(t);0===t.length&&(S[0].set([0,0,0]),S[1].set([0,0,0]));var A,M,P,E,T,C,I,R,L,O,D,N,k,B,F,z,U,j,V,G=S[0],$=S[1],H=-1,W=new Float32Array([0,0,0]),X=new Float32Array([0,0,0]),q=new Float32Array([0,0,0]);this.getSurface=function(t,e,i,r,n,o,a){return g(e,i,n),new Ps(O,R[2],R[1],R[0],D).getSurface(e,!1,void 0,L,a)}}function Oc(t){function e(t){for(var e=h.atomCount[t],n=h.atomOffset[t],o=new Array(e),a=0;a<e;++a)o[a]=l.atomTypeId[n+a];h.residueTypeId[t]=f.add(i,o,r)}var i,r,n=null,o=null,a=null,s=null,c=null,u=null,l=t.atomStore,h=t.residueStore,p=t.chainStore,d=t.modelStore,f=t.residueMap,m=-1,g=-1,v=-1,y=-1;this.addAtom=function(t,f,b,x,_,w,S,A){var M=!1,P=!1,E=!1;n!==t?(M=!0,P=!0,E=!0,y+=1,v+=1,g+=1):o!==b?(P=!0,E=!0,v+=1,g+=1):s===_&&a===x&&c===A||(E=!0,g+=1),m+=1,M&&(d.growIfFull(),d.chainOffset[y]=v,d.chainCount[y]=0,d.count+=1,p.modelIndex[v]=y),P&&(p.growIfFull(),p.setChainname(v,f),p.setChainid(v,b),p.residueOffset[v]=g,p.residueCount[v]=0,p.count+=1,p.modelIndex[v]=y,d.chainCount[y]+=1,h.chainIndex[g]=v),E&&(i=a,r=u,g>0&&e(g-1),h.growIfFull(),h.resno[g]=_,void 0!==S&&(h.sstruc[g]=S.charCodeAt(0)),void 0!==A&&(h.inscode[g]=A.charCodeAt(0)),h.atomOffset[g]=m,h.atomCount[g]=0,h.count+=1,h.chainIndex[g]=v,p.residueCount[v]+=1),l.count+=1,l.residueIndex[m]=g,h.atomCount[g]+=1,n=t,o=b,a=x,s=_,c=A,u=w},this.finalize=function(){i=a,r=u,g>-1&&e(g)}}function Dc(t){switch(t=t.toLowerCase()){case"polymer":return ty;case"non-polymer":return ey;case"macrolide":return iy;case"water":return ry;default:return Jv}}function Nc(t,e,i){var r=""+t;return e&&(r+=":"+e),i&&(r+="^"+i),r}function kc(t){return!t||t[0]!==t[t.length-1]||"'"!==t[0]&&'"'!==t[0]?t:t.substring(1,t.length-1)}function Bc(t,e){Array.isArray(t[e])||Object.keys(t).forEach(function(e){t[e]=[t[e]]})}function Fc(t){return"?"!==t}function zc(t,e){return Fc(t)?t:e}function Uc(t){switch(t.toLowerCase()){case"?":case"sing":return 1;case"doub":return 2;case"trip":return 3;case"quad":return 4}return 0}function jc(t,e,i){var r,n,o=e.atomStore,a=e.atomMap,s=t.chem_comp,c=t.chem_comp_atom,u=t.chem_comp_bond;s&&(s.name&&(e.title=s.name.trim().replace(tS,"")),s.id&&(e.id=s.id.trim().replace(tS,"")));var l={};if(c){var h,p,d,f;for(n=c.comp_id.length,r=0;r<n;++r)o.growIfFull(),h=c.atom_id[r].replace(Jw,""),p=c.type_symbol[r],l[h]=r,o.atomTypeId[r]=a.add(h,p),o.x[r]=c.model_Cartn_x[r],o.y[r]=c.model_Cartn_y[r],o.z[r]=c.model_Cartn_z[r],o.serial[r]=r,d=c.pdbx_component_comp_id[r],f=c.pdbx_residue_numbering?c.pdbx_residue_numbering[r]:1,i.addAtom(0,"","",d,f,1);for(r=0;r<n;++r){var m=r+n;o.growIfFull(),h=c.atom_id[r].replace(Jw,""),p=c.type_symbol[r],o.atomTypeId[m]=a.add(h,p),o.x[m]=c.pdbx_model_Cartn_x_ideal[r],o.y[m]=c.pdbx_model_Cartn_y_ideal[r],o.z[m]=c.pdbx_model_Cartn_z_ideal[r],o.serial[m]=m,d=c.pdbx_component_comp_id[r],f=c.pdbx_residue_numbering?c.pdbx_residue_numbering[r]:1,i.addAtom(1,"","",d,f,1)}}if(c&&u){var g,v,y;n=u.comp_id.length;var b=c.comp_id.length,x=e.getAtomProxy(),_=e.getAtomProxy();for(r=0;r<n;++r)g=u.atom_id_1[r].replace(Jw,""),v=u.atom_id_2[r].replace(Jw,""),y=Uc(u.value_order[r]),x.index=l[g],_.index=l[v],e.bondStore.growIfFull(),e.bondStore.addBond(x,_,y),x.index+=b,_.index+=b,e.bondStore.growIfFull(),e.bondStore.addBond(x,_,y)}}function Vc(t,e,i){function r(t){return o.get(n.atomTypeId[t]).covalent}var n=e.atomStore,o=e.atomMap;t.data&&(e.id=t.data,e.name=t.data),e.unitcell=new Hw({a:parseFloat(t.cell_length_a),b:parseFloat(t.cell_length_b),c:parseFloat(t.cell_length_c),alpha:parseFloat(t.cell_angle_alpha),beta:parseFloat(t.cell_angle_beta),gamma:parseFloat(t.cell_angle_gamma),spacegroup:kc(t.symmetry_space_group_name_H)});for(var a=new v,s=new v,c=t.atom_site_type_symbol.length,u=0;u<c;++u){n.growIfFull();var l=t.atom_site_label[u],h=t.atom_site_type_symbol[u];n.atomTypeId[u]=o.add(l,h),a.set(t.atom_site_fract_x[u],t.atom_site_fract_y[u],t.atom_site_fract_z[u]),a.applyMatrix4(e.unitcell.fracToCart),s.add(a),n.x[u]=a.x,n.y[u]=a.y,n.z[u]=a.z,t.atom_site_occupancy&&(n.occupancy[u]=parseFloat(t.atom_site_occupancy[u])),n.serial[u]=u,i.addAtom(0,"","","HET",1,1)}s.divideScalar(c),e.center=s,Vs(e);for(var p=new v,d=new v,f=e.biomolDict.SUPERCELL.partList[0].matrixList,m=c,g=new y,b=0;b<c;++b)!function(t){var e=r(t);a.set(n.x[t],n.y[t],n.z[t]),f.forEach(function(o){if(!g.equals(o)){p.copy(a),p.applyMatrix4(o);for(var s=0;s<c;++s){d.set(n.x[s],n.y[s],n.z[s]);var u=p.distanceToSquared(d),l=r(s)+e,h=l+.3,f=l-.5;if(u<h*h&&u>f*f)return n.growIfFull(),n.atomTypeId[m]=n.atomTypeId[t],n.x[m]=p.x,n.y[m]=p.y,n.z[m]=p.z,n.occupancy[m]=n.occupancy[t],n.serial[m]=m,n.altloc[m]="A".charCodeAt(0),i.addAtom(0,"","","HET",1,1),void(m+=1)}}})}(b)}function Gc(t,e,i){var r,n,o,a,s=[],c=[],u=t.struct_conf;if(u)for(Bc(u,"id"),r=0,n=u.beg_auth_seq_id.length;r<n;++r){var l=parseInt(u.pdbx_PDB_helix_class[r]);Number.isNaN(l)||(o=u.pdbx_beg_PDB_ins_code[r],a=u.pdbx_end_PDB_ins_code[r],s.push([i[u.beg_label_asym_id[r]],parseInt(u.beg_auth_seq_id[r]),zc(o,""),i[u.end_label_asym_id[r]],parseInt(u.end_auth_seq_id[r]),zc(a,""),(Ww[l]||Ww[""]).charCodeAt(0)]))}var h=t.struct_sheet_range;if(h)for(Bc(h,"id"),r=0,n=h.beg_auth_seq_id.length;r<n;++r)o=h.pdbx_beg_PDB_ins_code[r],a=h.pdbx_end_PDB_ins_code[r],c.push([i[h.beg_label_asym_id[r]],parseInt(h.beg_auth_seq_id[r]),zc(o,""),i[h.end_label_asym_id[r]],parseInt(h.end_auth_seq_id[r]),zc(a,"")]);return!(!u&&!h)&&{helices:s,sheets:c}}function $c(t,e,i){var r={},n=e.biomolDict;if(t.pdbx_struct_oper_list){var o=t.pdbx_struct_oper_list;Bc(o,"id"),o.id.forEach(function(t,e){var i=new y,n=i.elements;n[0]=parseFloat(o["matrix[1][1]"][e]),n[1]=parseFloat(o["matrix[1][2]"][e]),n[2]=parseFloat(o["matrix[1][3]"][e]),n[4]=parseFloat(o["matrix[2][1]"][e]),n[5]=parseFloat(o["matrix[2][2]"][e]),n[6]=parseFloat(o["matrix[2][3]"][e]),n[8]=parseFloat(o["matrix[3][1]"][e]),n[9]=parseFloat(o["matrix[3][2]"][e]),n[10]=parseFloat(o["matrix[3][3]"][e]),n[3]=parseFloat(o["vector[1]"][e]),n[7]=parseFloat(o["vector[2]"][e]),n[11]=parseFloat(o["vector[3]"][e]),i.transpose(),r[t]=i})}if(t.pdbx_struct_assembly_gen){var a=t.pdbx_struct_assembly_gen;Bc(a,"assembly_id");var s=function(t){var e={};return t.replace(/[()']/g,"").split(",").forEach(function(t){if(t.includes("-"))for(var i=t.split("-"),n=parseInt(i[0]),o=parseInt(i[1]);n<=o;++n)e[n]=r[n];else e[t]=r[t]}),e};a.assembly_id.forEach(function(t,e){var r={},o=a.oper_expression[e].replace(/['"]\(|['"]/g,"");if(o.includes(")(")||o.indexOf("(")>0){o=o.split("(");var c=s(o[0]),u=s(o[1]);Object.keys(c).forEach(function(t){Object.keys(u).forEach(function(e){var i=new y;i.multiplyMatrices(c[t],u[e]),r[t+"x"+e]=i})})}else r=s(o);var l=[];for(var h in r)l.push(r[h]);var p=t;/^(0|[1-9][0-9]*)$/.test(p)&&(p="BU"+p);for(var d=a.asym_id_list[e].split(","),f=0,m=d.length;f<m;++f)d[f]=i[d[f]];void 0===n[p]&&(n[p]=new Yy(p)),n[p].addPart(l,d)})}if(t.struct_ncs_oper){var c=t.struct_ncs_oper;Bc(c,"id");n.NCS=new Yy("NCS");var u=n.NCS.addPart();c.id.forEach(function(t,e){if("given"!==c.code[e]){var i=new y,r=i.elements;r[0]=parseFloat(c["matrix[1][1]"][e]),r[1]=parseFloat(c["matrix[1][2]"][e]),r[2]=parseFloat(c["matrix[1][3]"][e]),r[4]=parseFloat(c["matrix[2][1]"][e]),r[5]=parseFloat(c["matrix[2][2]"][e]),r[6]=parseFloat(c["matrix[2][3]"][e]),r[8]=parseFloat(c["matrix[3][1]"][e]),r[9]=parseFloat(c["matrix[3][2]"][e]),r[10]=parseFloat(c["matrix[3][3]"][e]),r[3]=parseFloat(c["vector[1]"][e]),r[7]=parseFloat(c["vector[2]"][e]),r[11]=parseFloat(c["vector[3]"][e]),i.transpose(),u.matrixList.push(i)}}),0===u.matrixList.length&&delete n.NCS}var l={};if(t.cell){var h=t.cell,p=parseFloat(h.length_a),d=parseFloat(h.length_b),f=parseFloat(h.length_c),m=new Float32Array(9);m[0]=p,m[4]=d,m[8]=f,e.boxes.push(m),l.a=p,l.b=d,l.c=f,l.alpha=parseFloat(h.angle_alpha),l.beta=parseFloat(h.angle_beta),l.gamma=parseFloat(h.angle_gamma)}t.symmetry&&(l.spacegroup=kc(t.symmetry["space_group_name_H-M"]));var g=new y;if(t.database_PDB_matrix){var v=t.database_PDB_matrix,b=g.elements;b[0]=parseFloat(v["origx[1][1]"]),b[1]=parseFloat(v["origx[1][2]"]),b[2]=parseFloat(v["origx[1][3]"]),b[4]=parseFloat(v["origx[2][1]"]),b[5]=parseFloat(v["origx[2][2]"]),b[6]=parseFloat(v["origx[2][3]"]),b[8]=parseFloat(v["origx[3][1]"]),b[9]=parseFloat(v["origx[3][2]"]),b[10]=parseFloat(v["origx[3][3]"]),b[3]=parseFloat(v["origx_vector[1]"]),b[7]=parseFloat(v["origx_vector[2]"]),b[11]=parseFloat(v["origx_vector[3]"]),g.transpose(),l.origx=g}var x=new y;if(t.atom_sites){var _=t.atom_sites,w=x.elements;w[0]=parseFloat(_["fract_transf_matrix[1][1]"]),w[1]=parseFloat(_["fract_transf_matrix[1][2]"]),w[2]=parseFloat(_["fract_transf_matrix[1][3]"]),w[4]=parseFloat(_["fract_transf_matrix[2][1]"]),w[5]=parseFloat(_["fract_transf_matrix[2][2]"]),w[6]=parseFloat(_["fract_transf_matrix[2][3]"]),w[8]=parseFloat(_["fract_transf_matrix[3][1]"]),w[9]=parseFloat(_["fract_transf_matrix[3][2]"]),w[10]=parseFloat(_["fract_transf_matrix[3][3]"]),w[3]=parseFloat(_["fract_transf_vector[1]"]),w[7]=parseFloat(_["fract_transf_vector[2]"]),w[11]=parseFloat(_["fract_transf_vector[3]"]),x.transpose(),l.scale=x}void 0!==l.a?e.unitcell=new Hw(l):e.unitcell=void 0}function Hc(e,i,r){var n=e.struct_conn;if(n){Bc(n,"id");for(var o=/"/g,a=i.getAtomProxy(),s=i.getAtomProxy(),c={},u=0,l=n.id.length;u<l;++u){var h=n.conn_type_id[u];if("hydrog"!==h&&"mismat"!==h&&"saltbr"!==h&&("1_555"===n.ptnr1_symmetry[u]&&"1_555"===n.ptnr2_symmetry[u])){var p=n.pdbx_ptnr1_PDB_ins_code[u],d=n.pdbx_ptnr1_label_alt_id[u],f=n.ptnr1_auth_seq_id[u]+(Fc(p)?"^"+p:"")+":"+r[n.ptnr1_label_asym_id[u]]+"."+n.ptnr1_label_atom_id[u].replace(o,"")+(Fc(d)?"%"+d:""),m=c[f];if(!m){var g=new rm(f);if(g.selection.error){t.Debug&&vm.warn("invalid selection for connection",f);continue}m=i.getAtomIndices(g),c[f]=m}var v=n.pdbx_ptnr2_PDB_ins_code[u],y=n.pdbx_ptnr2_label_alt_id[u],b=n.ptnr2_auth_seq_id[u]+(Fc(v)?"^"+v:"")+":"+r[n.ptnr2_label_asym_id[u]]+"."+n.ptnr2_label_atom_id[u].replace(o,"")+(Fc(y)?"%"+y:""),x=c[b];if(!x){var _=new rm(b);if(_.selection.error){t.Debug&&vm.warn("invalid selection for connection",b);continue}x=i.getAtomIndices(_),c[b]=x}var w=m.length,S=x.length;if(w>S){var A=w;w=S,S=A;var M=m;m=x,x=M}if(0!==w&&0!==S)for(var P=0;P<S;++P)a.index=m[P%w],s.index=x[P],a&&s?i.bondStore.addBond(a,s,Uc(n.pdbx_value_order[u])):vm.log("atoms for connection not found");else t.Debug&&vm.warn("no atoms found for",f,b)}}}}function Wc(t,e,i){if(t.entity){Bc(t.entity,"id");for(var r=t.entity,n=r.id.length,o=0;o<n;++o){var a=r.pdbx_description[o],s=r.type[o],c=Array.from(i[r.id[o]]);e.entityList[o]=new Gw(e,o,a,s,c)}}}function Xc(t,e,i){return e?new t(e.buffer,e.byteOffset,e.byteLength/(i||1)):void 0}function qc(t){return Xc(DataView,t)}function Yc(t){return Xc(Uint8Array,t)}function Zc(t){return Xc(Int8Array,t)}function Kc(t){return Xc(Int32Array,t,4)}function Qc(t){return Xc(Float32Array,t,4)}function Jc(t,e){var i=t.length/2;e||(e=new Int16Array(i));for(var r=0,n=0;r<i;++r,n+=2)e[r]=t[n]<<8^t[n+1]<<0;return e}function tu(t,e){var i=t.length/4;e||(e=new Int32Array(i));for(var r=0,n=0;r<i;++r,n+=4)e[r]=t[n]<<24^t[n+1]<<16^t[n+2]<<8^t[n+3]<<0;return e}function eu(t,e){var i=t.length;e||(e=new Float32Array(i/4));for(var r=qc(e),n=qc(t),o=0,a=0,s=i/4;o<s;++o,a+=4)r.setFloat32(a,n.getFloat32(a),!0);return e}function iu(t,e,i){var r=t.length,n=1/e;i||(i=new Float32Array(r));for(var o=0;o<r;++o)i[o]=t[o]*n;return i}function ru(t,e){var i,r;if(!e){var n=0;for(i=0,r=t.length;i<r;i+=2)n+=t[i+1];e=new t.constructor(n)}var o=0;for(i=0,r=t.length;i<r;i+=2)for(var a=t[i],s=t[i+1],c=0;c<s;++c)e[o]=a,++o;return e}function nu(t,e){var i=t.length;e||(e=new t.constructor(i)),i&&(e[0]=t[0]);for(var r=1;r<i;++r)e[r]=t[r]+e[r-1];return e}function ou(t,e){var i,r,n=t instanceof Int8Array?127:32767,o=-n-1,a=t.length;if(!e){var s=0;for(i=0;i<a;++i)t[i]<n&&t[i]>o&&++s;e=new Int32Array(s)}for(i=0,r=0;i<a;){for(var c=0;t[i]===n||t[i]===o;)c+=t[i],++i;c+=t[i],++i,e[r]=c,++r}return e}function au(t,e){return nu(ru(t),e)}function su(t,e,i){return iu(ru(t,Kc(i)),e,i)}function cu(t,e,i){return iu(nu(t,Kc(i)),e,i)}function uu(t,e,i){return iu(ou(t,Kc(i)),e,i)}function lu(t,e,i){var r=ou(t,Kc(i));return cu(r,e,Qc(r))}function hu(t){var e=qc(t),i=e.getInt32(0),r=e.getInt32(4),n=t.subarray(8,12);return[i,t=t.subarray(12),r,n]}function pu(t){function e(t){for(var e={},i=0;i<t;i++)e[o()]=o();return e}function i(e){var i=t.subarray(a,a+e);return a+=e,i}function r(e){var i=t.subarray(a,a+e);a+=e;if(e>65535){for(var r=[],n=0;n<i.length;n+=65535)r.push(String.fromCharCode.apply(null,i.subarray(n,n+65535)));return r.join("")}return String.fromCharCode.apply(null,i)}function n(t){for(var e=new Array(t),i=0;i<t;i++)e[i]=o();return e}function o(){var o,c,u=t[a];if(0==(128&u))return a++,u;if(128==(240&u))return c=15&u,a++,e(c);if(144==(240&u))return c=15&u,a++,n(c);if(160==(224&u))return c=31&u,a++,r(c);if(224==(224&u))return o=s.getInt8(a),a++,o;switch(u){case 192:return a++,null;case 194:return a++,!1;case 195:return a++,!0;case 196:return c=s.getUint8(a+1),a+=2,i(c);case 197:return c=s.getUint16(a+1),a+=3,i(c);case 198:return c=s.getUint32(a+1),a+=5,i(c);case 202:return o=s.getFloat32(a+1),a+=5,o;case 203:return o=s.getFloat64(a+1),a+=9,o;case 204:return o=t[a+1],a+=2,o;case 205:return o=s.getUint16(a+1),a+=3,o;case 206:return o=s.getUint32(a+1),a+=5,o;case 208:return o=s.getInt8(a+1),a+=2,o;case 209:return o=s.getInt16(a+1),a+=3,o;case 210:return o=s.getInt32(a+1),a+=5,o;case 217:return c=s.getUint8(a+1),a+=2,r(c);case 218:return c=s.getUint16(a+1),a+=3,r(c);case 219:return c=s.getUint32(a+1),a+=5,r(c);case 220:return c=s.getUint16(a+1),a+=3,n(c);case 221:return c=s.getUint32(a+1),a+=5,n(c);case 222:return c=s.getUint16(a+1),a+=3,e(c);case 223:return c=s.getUint32(a+1),a+=5,e(c)}throw new Error("Unknown type 0x"+u.toString(16))}var a=0,s=new DataView(t.buffer);return o()}function du(t,e,i,r){switch(t){case 1:return eu(e);case 2:return Zc(e);case 3:return Jc(e);case 4:return tu(e);case 5:return Yc(e);case 6:return ru(tu(e),new Uint8Array(i));case 7:return ru(tu(e));case 8:return au(tu(e));case 9:return su(tu(e),tu(r)[0]);case 10:return lu(Jc(e),tu(r)[0]);case 11:return iu(Jc(e),tu(r)[0]);case 12:return uu(Jc(e),tu(r)[0]);case 13:return uu(Zc(e),tu(r)[0]);case 14:return ou(Jc(e));case 15:return ou(Zc(e))}}function fu(t,e){var i=(e=e||{}).ignoreFields,r={};return nS.forEach(function(e){var n=!!i&&-1!==i.indexOf(e),o=t[e];n||void 0===o||(o instanceof Uint8Array?r[e]=du.apply(null,hu(o)):r[e]=o)}),r}function mu(t,e,i){return parseInt(t.substr(e,i).trim())}function gu(t,e){if(t)throw new TypeError("Not a valid NetCDF v3.x file: "+e)}function vu(t){t.offset%4!=0&&t.skip(4-t.offset%4)}function yu(t){var e=t.readUint32(),i=t.readChars(e);return vu(t),i}function bu(t){switch(Number(t)){case WS.BYTE:return"byte";case WS.CHAR:return"char";case WS.SHORT:return"short";case WS.INT:return"int";case WS.FLOAT:return"float";case WS.DOUBLE:return"double";default:return"undefined"}}function xu(t){switch(Number(t)){case WS.BYTE:case WS.CHAR:return 1;case WS.SHORT:return 2;case WS.INT:case WS.FLOAT:return 4;case WS.DOUBLE:return 8;default:return-1}}function _u(t){switch(String(t)){case"byte":return WS.BYTE;case"char":return WS.CHAR;case"short":return WS.SHORT;case"int":return WS.INT;case"float":return WS.FLOAT;case"double":return WS.DOUBLE;default:return-1}}function wu(t,e){if(1!==t){for(var i=new Array(t),r=0;r<t;r++)i[r]=e();return i}return e()}function Su(t,e,i){switch(e){case WS.BYTE:return t.readBytes(i);case WS.CHAR:return Au(t.readChars(i));case WS.SHORT:return wu(i,t.readInt16.bind(t));case WS.INT:return wu(i,t.readInt32.bind(t));case WS.FLOAT:return wu(i,t.readFloat32.bind(t));case WS.DOUBLE:return wu(i,t.readFloat64.bind(t));default:return void gu(!0,"non valid type "+e)}}function Au(t){return 0===t.charCodeAt(t.length-1)?t.substring(0,t.length-1):t}function Mu(t,e){for(var i=_u(e.type),r=e.size/xu(i),n=new Array(r),o=0;o<r;o++)n[o]=Su(t,i,1);return n}function Pu(t,e,i){for(var r=_u(e.type),n=e.size?e.size/xu(r):1,o=i.length,a=new Array(o),s=i.recordStep,c=0;c<o;c++){var u=t.offset;a[c]=Su(t,r,n),t.seek(u+s)}return a}function Eu(t,e){var i={recordDimension:{length:t.readUint32()}};i.version=e;var r=Tu(t);i.recordDimension.id=r.recordId,i.recordDimension.name=r.recordName,i.dimensions=r.dimensions,i.globalAttributes=Cu(t);var n=Iu(t,r.recordId,e);return i.variables=n.variables,i.recordDimension.recordStep=n.recordStep,i}function Tu(t){var e,i,r,n=t.readUint32();if(n===XS)return gu(t.readUint32()!==XS,"wrong empty tag for list of dimensions"),[];gu(n!==qS,"wrong tag for list of dimensions");var o=t.readUint32();e=new Array(o);for(var a=0;a<o;a++){var s=yu(t),c=t.readUint32();0===c&&(i=a,r=s),e[a]={name:s,size:c}}return{dimensions:e,recordId:i,recordName:r}}function Cu(t){var e,i=t.readUint32();if(i===XS)return gu(t.readUint32()!==XS,"wrong empty tag for list of attributes"),[];gu(i!==ZS,"wrong tag for list of attributes");var r=t.readUint32();e=new Array(r);for(var n=0;n<r;n++){var o=yu(t),a=t.readUint32();gu(a<1||a>6,"non valid type "+a);var s=Su(t,a,t.readUint32());vu(t),e[n]={name:o,type:bu(a),value:s}}return e}function Iu(t,e,i){var r,n=t.readUint32(),o=0;if(n===XS)return gu(t.readUint32()!==XS,"wrong empty tag for list of variables"),[];gu(n!==YS,"wrong tag for list of variables");var a=t.readUint32();r=new Array(a);for(var s=0;s<a;s++){for(var c=yu(t),u=t.readUint32(),l=new Array(u),h=0;h<u;h++)l[h]=t.readUint32();var p=Cu(t),d=t.readUint32();gu(d<1&&d>6,"non valid type "+d);var f=t.readUint32(),m=t.readUint32();2===i&&(gu(m>0,"offsets larger than 4GB not supported"),m=t.readUint32()),l[0]===e&&(o+=f),r[s]={name:c,dimensions:l,attributes:p,type:bu(d),size:f,offset:m,record:l[0]===e}}return{variables:r,recordStep:o}}function Ru(t){for(var e=1,i=0;t>=e&&i<32;)i++,e<<=1;return i}function Lu(t,e){var i=1,r=0;iA[0]=1;for(var n=0;n<t;n++){var o=void 0,a=0;for(o=0;o<i;o++)a+=iA[o]*e[n],iA[o]=255&a,a>>=8;for(;0!==a;)iA[o++]=255&a,a>>=8;i=o}var s=1;for(i--;iA[i]>=s;)r++,s*=2;return r+8*i}function Ou(t,e,i,r){for(var n=(1<<i)-1,o=r[1],a=r[2],s=t[0],c=0;i>=8;)c|=(a=a<<8|e[s++])>>o<<i-8,i-=8;return i>0&&(o<i&&(o+=8,a=a<<8|e[s++]),c|=a>>(o-=i)&(1<<i)-1),c&=n,t[0]=s,t[1]=o,t[2]=a,c}function Du(t,e,i,r,n,o,a){var s=0;for(rA[1]=0,rA[2]=0,rA[3]=0;r>8;)rA[s++]=Ou(t,e,8,a),r-=8;r>0&&(rA[s++]=Ou(t,e,r,a));for(var c=i-1;c>0;c--){for(var u=0,l=s-1;l>=0;l--){var h=(u=u<<8|rA[l])/n[c]|0;rA[l]=h,u-=h*n[c]}o[c]=u}o[0]=rA[0]|rA[1]<<8|rA[2]<<16|rA[3]<<24}function Nu(t){return t.trim().split(fA).map(parseFloat)}function ku(){this.regexp={vertex_pattern:/^v\s+([\d.+\-eE]+)\s+([\d.+\-eE]+)\s+([\d.+\-eE]+)/,normal_pattern:/^vn\s+([\d.+\-eE]+)\s+([\d.+\-eE]+)\s+([\d.+\-eE]+)/,uv_pattern:/^vt\s+([\d.+\-eE]+)\s+([\d.+\-eE]+)/,face_vertex:/^f\s+(-?\d+)\s+(-?\d+)\s+(-?\d+)(?:\s+(-?\d+))?/,face_vertex_uv:/^f\s+(-?\d+)\/(-?\d+)\s+(-?\d+)\/(-?\d+)\s+(-?\d+)\/(-?\d+)(?:\s+(-?\d+)\/(-?\d+))?/,face_vertex_uv_normal:/^f\s+(-?\d+)\/(-?\d+)\/(-?\d+)\s+(-?\d+)\/(-?\d+)\/(-?\d+)\s+(-?\d+)\/(-?\d+)\/(-?\d+)(?:\s+(-?\d+)\/(-?\d+)\/(-?\d+))?/,face_vertex_normal:/^f\s+(-?\d+)\/\/(-?\d+)\s+(-?\d+)\/\/(-?\d+)\s+(-?\d+)\/\/(-?\d+)(?:\s+(-?\d+)\/\/(-?\d+))?/,object_pattern:/^[og]\s*(.+)?/,smoothing_pattern:/^s\s+(\d+|on|off)/,material_library_pattern:/^mtllib /,material_use_pattern:/^usemtl /}}function Bu(){this.propertyNameMapping={}}function Fu(t){return t.replace(AA,"")}function zu(t){function e(){if(o(/^<\?xml\s*/)){for(var t={attributes:{}};!a()&&!s("?>");){var e=n();if(!e)return t;t.attributes[e.name]=e.value}return o(/\?>\s*/),t}}function i(){var t=o(MA);if(t){for(var e={name:t[1],attributes:{},children:[]};!(a()||s(">")||s("?>")||s("/>"));){var c=n();if(!c)return e;e.attributes[c.name]=c.value}if(o(/^\s*\/>\s*/))return e;o(/\??>\s*/),e.content=r();for(var u;u=i();)e.children.push(u);return o(/^<\/[\w-:.]+>\s*/),e}}function r(){var t=o(PA);return t?t[1]:""}function n(){var t=o(EA);if(t)return{name:t[1],value:Fu(t[2])}}function o(e){var i=t.match(e);if(i)return t=t.slice(i[0].length),i}function a(){return 0===t.length}function s(e){return 0===t.indexOf(e)}return t=t.trim().replace(/<!--[\s\S]*?-->/g,""),{declaration:e(),root:i()}}function Uu(t,e,i){var r=t.icode.value,n=t.chain.value,o=t.altcode.value,a=t.resnum.value;return r.trim()&&(a+="^"+r),n.trim()&&(a+=":"+n),e&&(a+="."+e),i&&o.trim()&&(a+="%"+o),a+="/"+(parseInt(t.model.value)-1)}function ju(t,e,i){void 0===t[e]?t[e]=i:t[e]|=i}function Vu(t,e){return void 0!==t&&t.value===e}function Gu(t){var e=t.inscode,i=t.chainname,r=t.atomname,n=t.altloc,o=t.resno;return e&&(o+="^"+e),i&&(o+=":"+i),r&&(o+="."+r),n&&(o+="%"+n),o+="/"+t.modelIndex}function $u(t,e,i){for(var r=0,n=e.getElementsByTagName("clash"),o=0,a=n.length;o<a;++o)if(t[n[o].attributes.cid.value]){r+=1;break}return e.getElementsByTagName("angle-outlier").length>0&&(r+=1),e.getElementsByTagName("bond-outlier").length>0&&(r+=1),e.getElementsByTagName("plane-outlier").length>0&&(r+=1),Vu(i.rota,"OUTLIER")&&(r+=1),Vu(i.rama,"OUTLIER")&&(r+=1),Vu(i.RNApucker,"outlier")&&(r+=1),r}function Hu(t){for(var e=Array.prototype.slice.call(arguments,1);e.length;){var i=e.shift();if(i){if("object"!=typeof i)throw new TypeError(i+"must be non-object");for(var r in i)i.hasOwnProperty(r)&&(t[r]=i[r])}}return t}function Wu(t,e){return t.length===e?t:t.subarray?t.subarray(0,e):(t.length=e,t)}function Xu(t,e,i,r,n){if(e.subarray&&t.subarray)t.set(e.subarray(i,i+r),n);else for(var o=0;o<r;o++)t[n+o]=e[i+o]}function qu(t){var e,i,r,n,o,a;for(r=0,e=0,i=t.length;e<i;e++)r+=t[e].length;for(a=new Uint8Array(r),n=0,e=0,i=t.length;e<i;e++)o=t[e],a.set(o,n),n+=o.length;return a}function Yu(t,e,i,r){for(var n=65535&t|0,o=t>>>16&65535|0,a=0;0!==i;){i-=a=i>2e3?2e3:i;do{o=o+(n=n+e[r++]|0)|0}while(--a);n%=65521,o%=65521}return n|o<<16|0}function Zu(t,e,i,r){var n=DA,o=r+i;t^=-1;for(var a=r;a<o;a++)t=t>>>8^n[255&(t^e[a])];return-1^t}function Ku(t,e){var i,r,n,o,a,s,c,u,l,h,p,d,f,m,g,v,y,b,x,_,w,S,A,M,P;i=t.state,r=t.next_in,M=t.input,n=r+(t.avail_in-5),o=t.next_out,P=t.output,a=o-(e-t.avail_out),s=o+(t.avail_out-257),c=i.dmax,u=i.wsize,l=i.whave,h=i.wnext,p=i.window,d=i.hold,f=i.bits,m=i.lencode,g=i.distcode,v=(1<<i.lenbits)-1,y=(1<<i.distbits)-1;t:do{f<15&&(d+=M[r++]<<f,f+=8,d+=M[r++]<<f,f+=8),b=m[d&v];e:for(;;){if(x=b>>>24,d>>>=x,f-=x,0===(x=b>>>16&255))P[o++]=65535&b;else{if(!(16&x)){if(0==(64&x)){b=m[(65535&b)+(d&(1<<x)-1)];continue e}if(32&x){i.mode=kA;break t}t.msg="invalid literal/length code",i.mode=NA;break t}_=65535&b,(x&=15)&&(f<x&&(d+=M[r++]<<f,f+=8),_+=d&(1<<x)-1,d>>>=x,f-=x),f<15&&(d+=M[r++]<<f,f+=8,d+=M[r++]<<f,f+=8),b=g[d&y];i:for(;;){if(x=b>>>24,d>>>=x,f-=x,!(16&(x=b>>>16&255))){if(0==(64&x)){b=g[(65535&b)+(d&(1<<x)-1)];continue i}t.msg="invalid distance code",i.mode=NA;break t}if(w=65535&b,x&=15,f<x&&(d+=M[r++]<<f,(f+=8)<x&&(d+=M[r++]<<f,f+=8)),(w+=d&(1<<x)-1)>c){t.msg="invalid distance too far back",i.mode=NA;break t}if(d>>>=x,f-=x,x=o-a,w>x){if((x=w-x)>l&&i.sane){t.msg="invalid distance too far back",i.mode=NA;break t}if(S=0,A=p,0===h){if(S+=u-x,x<_){_-=x;do{P[o++]=p[S++]}while(--x);S=o-w,A=P}}else if(h<x){if(S+=u+h-x,(x-=h)<_){_-=x;do{P[o++]=p[S++]}while(--x);if(S=0,h<_){_-=x=h;do{P[o++]=p[S++]}while(--x);S=o-w,A=P}}}else if(S+=h-x,x<_){_-=x;do{P[o++]=p[S++]}while(--x);S=o-w,A=P}for(;_>2;)P[o++]=A[S++],P[o++]=A[S++],P[o++]=A[S++],_-=3;_&&(P[o++]=A[S++],_>1&&(P[o++]=A[S++]))}else{S=o-w;do{P[o++]=P[S++],P[o++]=P[S++],P[o++]=P[S++],_-=3}while(_>2);_&&(P[o++]=P[S++],_>1&&(P[o++]=P[S++]))}break}}break}}while(r<n&&o<s);r-=_=f>>3,d&=(1<<(f-=_<<3))-1,t.next_in=r,t.next_out=o,t.avail_in=r<n?n-r+5:5-(r-n),t.avail_out=o<s?s-o+257:257-(o-s),i.hold=d,i.bits=f}function Qu(t,e,i,r,n,o,a,s){var c,u,l,h,p,d,f,m,g,v=s.bits,y=0,b=0,x=0,_=0,w=0,S=0,A=0,M=0,P=0,E=0,T=null,C=0,I=new Uint16Array(BA+1),R=new Uint16Array(BA+1),L=null,O=0;for(y=0;y<=BA;y++)I[y]=0;for(b=0;b<r;b++)I[e[i+b]]++;for(w=v,_=BA;_>=1&&0===I[_];_--);if(w>_&&(w=_),0===_)return n[o++]=20971520,n[o++]=20971520,s.bits=1,0;for(x=1;x<_&&0===I[x];x++);for(w<x&&(w=x),M=1,y=1;y<=BA;y++)if(M<<=1,(M-=I[y])<0)return-1;if(M>0&&(t===UA||1!==_))return-1;for(R[1]=0,y=1;y<BA;y++)R[y+1]=R[y]+I[y];for(b=0;b<r;b++)0!==e[i+b]&&(a[R[e[i+b]]++]=b);if(t===UA?(T=L=a,d=19):t===jA?(T=GA,C-=257,L=$A,O-=257,d=256):(T=HA,L=WA,d=-1),E=0,b=0,y=x,p=o,S=w,A=0,l=-1,P=1<<w,h=P-1,t===jA&&P>FA||t===VA&&P>zA)return 1;for(;;){f=y-A,a[b]<d?(m=0,g=a[b]):a[b]>d?(m=L[O+a[b]],g=T[C+a[b]]):(m=96,g=0),c=1<<y-A,x=u=1<<S;do{n[p+(E>>A)+(u-=c)]=f<<24|m<<16|g|0}while(0!==u);for(c=1<<y-1;E&c;)c>>=1;if(0!==c?(E&=c-1,E+=c):E=0,b++,0==--I[y]){if(y===_)break;y=e[i+a[b]]}if(y>w&&(E&h)!==l){for(0===A&&(A=w),p+=x,M=1<<(S=y-A);S+A<_&&!((M-=I[S+A])<=0);)S++,M<<=1;if(P+=1<<S,t===jA&&P>FA||t===VA&&P>zA)return 1;n[l=E&h]=w<<24|S<<16|p-o|0}}return 0!==E&&(n[p+E]=y-A<<24|64<<16|0),s.bits=w,0}function Ju(t){return(t>>>24&255)+(t>>>8&65280)+((65280&t)<<8)+((255&t)<<24)}function tl(){this.mode=0,this.last=!1,this.wrap=0,this.havedict=!1,this.flags=0,this.dmax=0,this.check=0,this.total=0,this.head=null,this.wbits=0,this.wsize=0,this.whave=0,this.wnext=0,this.window=null,this.hold=0,this.bits=0,this.length=0,this.offset=0,this.extra=0,this.lencode=null,this.distcode=null,this.lenbits=0,this.distbits=0,this.ncode=0,this.nlen=0,this.ndist=0,this.have=0,this.next=null,this.lens=new Uint16Array(320),this.work=new Uint16Array(288),this.lendyn=null,this.distdyn=null,this.sane=0,this.back=0,this.was=0}function el(t){var e;return t&&t.state?(e=t.state,t.total_in=t.total_out=e.total=0,t.msg="",e.wrap&&(t.adler=1&e.wrap),e.mode=sM,e.last=0,e.havedict=0,e.dmax=32768,e.head=null,e.hold=0,e.bits=0,e.lencode=e.lendyn=new Int32Array(zM),e.distcode=e.distdyn=new Int32Array(UM),e.sane=1,e.back=-1,JA):iM}function il(t){var e;return t&&t.state?(e=t.state,e.wsize=0,e.whave=0,e.wnext=0,el(t)):iM}function rl(t,e){var i,r;return t&&t.state?(r=t.state,e<0?(i=0,e=-e):(i=1+(e>>4),e<48&&(e&=15)),e&&(e<8||e>15)?iM:(null!==r.window&&r.wbits!==e&&(r.window=null),r.wrap=i,r.wbits=e,il(t))):iM}function nl(t,e){var i,r;return t?(r=new tl,t.state=r,r.window=null,(i=rl(t,e))!==JA&&(t.state=null),i):iM}function ol(t){if(jM){var e;for(LA=new Int32Array(512),OA=new Int32Array(32),e=0;e<144;)t.lens[e++]=8;for(;e<256;)t.lens[e++]=9;for(;e<280;)t.lens[e++]=7;for(;e<288;)t.lens[e++]=8;for(Qu(qA,t.lens,0,288,LA,0,t.work,{bits:9}),e=0;e<32;)t.lens[e++]=5;Qu(YA,t.lens,0,32,OA,0,t.work,{bits:5}),jM=!1}t.lencode=LA,t.lenbits=9,t.distcode=OA,t.distbits=5}function al(t,e,i,r){var n,o=t.state;return null===o.window&&(o.wsize=1<<o.wbits,o.wnext=0,o.whave=0,o.window=new Uint8Array(o.wsize)),r>=o.wsize?(Xu(o.window,e,i-o.wsize,o.wsize,0),o.wnext=0,o.whave=o.wsize):((n=o.wsize-o.wnext)>r&&(n=r),Xu(o.window,e,i-r,n,o.wnext),(r-=n)?(Xu(o.window,e,i-r,r,0),o.wnext=r,o.whave=o.wsize):(o.wnext+=n,o.wnext===o.wsize&&(o.wnext=0),o.whave<o.wsize&&(o.whave+=n))),0}function sl(t,e){var i,r,n,o,a,s,c,u,l,h,p,d,f,m,g,v,y,b,x,_,w,S,A,M,P=0,E=new Uint8Array(4),T=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15];if(!t||!t.state||!t.output||!t.input&&0!==t.avail_in)return iM;(i=t.state).mode===yM&&(i.mode=bM),a=t.next_out,n=t.output,c=t.avail_out,o=t.next_in,r=t.input,s=t.avail_in,u=i.hold,l=i.bits,h=s,p=c,S=JA;t:for(;;)switch(i.mode){case sM:if(0===i.wrap){i.mode=bM;break}for(;l<16;){if(0===s)break t;s--,u+=r[o++]<<l,l+=8}if(2&i.wrap&&35615===u){i.check=0,E[0]=255&u,E[1]=u>>>8&255,i.check=Zu(i.check,E,2,0),u=0,l=0,i.mode=cM;break}if(i.flags=0,i.head&&(i.head.done=!1),!(1&i.wrap)||(((255&u)<<8)+(u>>8))%31){t.msg="incorrect header check",i.mode=kM;break}if((15&u)!==aM){t.msg="unknown compression method",i.mode=kM;break}if(u>>>=4,l-=4,w=8+(15&u),0===i.wbits)i.wbits=w;else if(w>i.wbits){t.msg="invalid window size",i.mode=kM;break}i.dmax=1<<w,t.adler=i.check=1,i.mode=512&u?gM:yM,u=0,l=0;break;case cM:for(;l<16;){if(0===s)break t;s--,u+=r[o++]<<l,l+=8}if(i.flags=u,(255&i.flags)!==aM){t.msg="unknown compression method",i.mode=kM;break}if(57344&i.flags){t.msg="unknown header flags set",i.mode=kM;break}i.head&&(i.head.text=u>>8&1),512&i.flags&&(E[0]=255&u,E[1]=u>>>8&255,i.check=Zu(i.check,E,2,0)),u=0,l=0,i.mode=uM;case uM:for(;l<32;){if(0===s)break t;s--,u+=r[o++]<<l,l+=8}i.head&&(i.head.time=u),512&i.flags&&(E[0]=255&u,E[1]=u>>>8&255,E[2]=u>>>16&255,E[3]=u>>>24&255,i.check=Zu(i.check,E,4,0)),u=0,l=0,i.mode=lM;case lM:for(;l<16;){if(0===s)break t;s--,u+=r[o++]<<l,l+=8}i.head&&(i.head.xflags=255&u,i.head.os=u>>8),512&i.flags&&(E[0]=255&u,E[1]=u>>>8&255,i.check=Zu(i.check,E,2,0)),u=0,l=0,i.mode=hM;case hM:if(1024&i.flags){for(;l<16;){if(0===s)break t;s--,u+=r[o++]<<l,l+=8}i.length=u,i.head&&(i.head.extra_len=u),512&i.flags&&(E[0]=255&u,E[1]=u>>>8&255,i.check=Zu(i.check,E,2,0)),u=0,l=0}else i.head&&(i.head.extra=null);i.mode=pM;case pM:if(1024&i.flags&&((d=i.length)>s&&(d=s),d&&(i.head&&(w=i.head.extra_len-i.length,i.head.extra||(i.head.extra=new Array(i.head.extra_len)),Xu(i.head.extra,r,o,d,w)),512&i.flags&&(i.check=Zu(i.check,r,d,o)),s-=d,o+=d,i.length-=d),i.length))break t;i.length=0,i.mode=dM;case dM:if(2048&i.flags){if(0===s)break t;d=0;do{w=r[o+d++],i.head&&w&&i.length<65536&&(i.head.name+=String.fromCharCode(w))}while(w&&d<s);if(512&i.flags&&(i.check=Zu(i.check,r,d,o)),s-=d,o+=d,w)break t}else i.head&&(i.head.name=null);i.length=0,i.mode=fM;case fM:if(4096&i.flags){if(0===s)break t;d=0;do{w=r[o+d++],i.head&&w&&i.length<65536&&(i.head.comment+=String.fromCharCode(w))}while(w&&d<s);if(512&i.flags&&(i.check=Zu(i.check,r,d,o)),s-=d,o+=d,w)break t}else i.head&&(i.head.comment=null);i.mode=mM;case mM:if(512&i.flags){for(;l<16;){if(0===s)break t;s--,u+=r[o++]<<l,l+=8}if(u!==(65535&i.check)){t.msg="header crc mismatch",i.mode=kM;break}u=0,l=0}i.head&&(i.head.hcrc=i.flags>>9&1,i.head.done=!0),t.adler=i.check=0,i.mode=yM;break;case gM:for(;l<32;){if(0===s)break t;s--,u+=r[o++]<<l,l+=8}t.adler=i.check=Ju(u),u=0,l=0,i.mode=vM;case vM:if(0===i.havedict)return t.next_out=a,t.avail_out=c,t.next_in=o,t.avail_in=s,i.hold=u,i.bits=l,eM;t.adler=i.check=1,i.mode=yM;case yM:if(e===KA||e===QA)break t;case bM:if(i.last){u>>>=7&l,l-=7&l,i.mode=OM;break}for(;l<3;){if(0===s)break t;s--,u+=r[o++]<<l,l+=8}switch(i.last=1&u,u>>>=1,l-=1,3&u){case 0:i.mode=xM;break;case 1:if(ol(i),i.mode=PM,e===QA){u>>>=2,l-=2;break t}break;case 2:i.mode=SM;break;case 3:t.msg="invalid block type",i.mode=kM}u>>>=2,l-=2;break;case xM:for(u>>>=7&l,l-=7&l;l<32;){if(0===s)break t;s--,u+=r[o++]<<l,l+=8}if((65535&u)!=(u>>>16^65535)){t.msg="invalid stored block lengths",i.mode=kM;break}if(i.length=65535&u,u=0,l=0,i.mode=_M,e===QA)break t;case _M:i.mode=wM;case wM:if(d=i.length){if(d>s&&(d=s),d>c&&(d=c),0===d)break t;Xu(n,r,o,d,a),s-=d,o+=d,c-=d,a+=d,i.length-=d;break}i.mode=yM;break;case SM:for(;l<14;){if(0===s)break t;s--,u+=r[o++]<<l,l+=8}if(i.nlen=257+(31&u),u>>>=5,l-=5,i.ndist=1+(31&u),u>>>=5,l-=5,i.ncode=4+(15&u),u>>>=4,l-=4,i.nlen>286||i.ndist>30){t.msg="too many length or distance symbols",i.mode=kM;break}i.have=0,i.mode=AM;case AM:for(;i.have<i.ncode;){for(;l<3;){if(0===s)break t;s--,u+=r[o++]<<l,l+=8}i.lens[T[i.have++]]=7&u,u>>>=3,l-=3}for(;i.have<19;)i.lens[T[i.have++]]=0;if(i.lencode=i.lendyn,i.lenbits=7,A={bits:i.lenbits},S=Qu(XA,i.lens,0,19,i.lencode,0,i.work,A),i.lenbits=A.bits,S){t.msg="invalid code lengths set",i.mode=kM;break}i.have=0,i.mode=MM;case MM:for(;i.have<i.nlen+i.ndist;){for(;P=i.lencode[u&(1<<i.lenbits)-1],g=P>>>24,v=P>>>16&255,y=65535&P,!(g<=l);){if(0===s)break t;s--,u+=r[o++]<<l,l+=8}if(y<16)u>>>=g,l-=g,i.lens[i.have++]=y;else{if(16===y){for(M=g+2;l<M;){if(0===s)break t;s--,u+=r[o++]<<l,l+=8}if(u>>>=g,l-=g,0===i.have){t.msg="invalid bit length repeat",i.mode=kM;break}w=i.lens[i.have-1],d=3+(3&u),u>>>=2,l-=2}else if(17===y){for(M=g+3;l<M;){if(0===s)break t;s--,u+=r[o++]<<l,l+=8}l-=g,w=0,d=3+(7&(u>>>=g)),u>>>=3,l-=3}else{for(M=g+7;l<M;){if(0===s)break t;s--,u+=r[o++]<<l,l+=8}l-=g,w=0,d=11+(127&(u>>>=g)),u>>>=7,l-=7}if(i.have+d>i.nlen+i.ndist){t.msg="invalid bit length repeat",i.mode=kM;break}for(;d--;)i.lens[i.have++]=w}}if(i.mode===kM)break;if(0===i.lens[256]){t.msg="invalid code -- missing end-of-block",i.mode=kM;break}if(i.lenbits=9,A={bits:i.lenbits},S=Qu(qA,i.lens,0,i.nlen,i.lencode,0,i.work,A),i.lenbits=A.bits,S){t.msg="invalid literal/lengths set",i.mode=kM;break}if(i.distbits=6,i.distcode=i.distdyn,A={bits:i.distbits},S=Qu(YA,i.lens,i.nlen,i.ndist,i.distcode,0,i.work,A),i.distbits=A.bits,S){t.msg="invalid distances set",i.mode=kM;break}if(i.mode=PM,e===QA)break t;case PM:i.mode=EM;case EM:if(s>=6&&c>=258){t.next_out=a,t.avail_out=c,t.next_in=o,t.avail_in=s,i.hold=u,i.bits=l,Ku(t,p),a=t.next_out,n=t.output,c=t.avail_out,o=t.next_in,r=t.input,s=t.avail_in,u=i.hold,l=i.bits,i.mode===yM&&(i.back=-1);break}for(i.back=0;P=i.lencode[u&(1<<i.lenbits)-1],g=P>>>24,v=P>>>16&255,y=65535&P,!(g<=l);){if(0===s)break t;s--,u+=r[o++]<<l,l+=8}if(v&&0==(240&v)){for(b=g,x=v,_=y;P=i.lencode[_+((u&(1<<b+x)-1)>>b)],g=P>>>24,v=P>>>16&255,y=65535&P,!(b+g<=l);){if(0===s)break t;s--,u+=r[o++]<<l,l+=8}u>>>=b,l-=b,i.back+=b}if(u>>>=g,l-=g,i.back+=g,i.length=y,0===v){i.mode=LM;break}if(32&v){i.back=-1,i.mode=yM;break}if(64&v){t.msg="invalid literal/length code",i.mode=kM;break}i.extra=15&v,i.mode=TM;case TM:if(i.extra){for(M=i.extra;l<M;){if(0===s)break t;s--,u+=r[o++]<<l,l+=8}i.length+=u&(1<<i.extra)-1,u>>>=i.extra,l-=i.extra,i.back+=i.extra}i.was=i.length,i.mode=CM;case CM:for(;P=i.distcode[u&(1<<i.distbits)-1],g=P>>>24,v=P>>>16&255,y=65535&P,!(g<=l);){if(0===s)break t;s--,u+=r[o++]<<l,l+=8}if(0==(240&v)){for(b=g,x=v,_=y;P=i.distcode[_+((u&(1<<b+x)-1)>>b)],g=P>>>24,v=P>>>16&255,y=65535&P,!(b+g<=l);){if(0===s)break t;s--,u+=r[o++]<<l,l+=8}u>>>=b,l-=b,i.back+=b}if(u>>>=g,l-=g,i.back+=g,64&v){t.msg="invalid distance code",i.mode=kM;break}i.offset=y,i.extra=15&v,i.mode=IM;case IM:if(i.extra){for(M=i.extra;l<M;){if(0===s)break t;s--,u+=r[o++]<<l,l+=8}i.offset+=u&(1<<i.extra)-1,u>>>=i.extra,l-=i.extra,i.back+=i.extra}if(i.offset>i.dmax){t.msg="invalid distance too far back",i.mode=kM;break}i.mode=RM;case RM:if(0===c)break t;if(d=p-c,i.offset>d){if((d=i.offset-d)>i.whave&&i.sane){t.msg="invalid distance too far back",i.mode=kM;break}d>i.wnext?(d-=i.wnext,f=i.wsize-d):f=i.wnext-d,d>i.length&&(d=i.length),m=i.window}else m=n,f=a-i.offset,d=i.length;d>c&&(d=c),c-=d,i.length-=d;do{n[a++]=m[f++]}while(--d);0===i.length&&(i.mode=EM);break;case LM:if(0===c)break t;n[a++]=i.length,c--,i.mode=EM;break;case OM:if(i.wrap){for(;l<32;){if(0===s)break t;s--,u|=r[o++]<<l,l+=8}if(p-=c,t.total_out+=p,i.total+=p,p&&(t.adler=i.check=i.flags?Zu(i.check,n,p,a-p):Yu(i.check,n,p,a-p)),p=c,(i.flags?u:Ju(u))!==i.check){t.msg="incorrect data check",i.mode=kM;break}u=0,l=0}i.mode=DM;case DM:if(i.wrap&&i.flags){for(;l<32;){if(0===s)break t;s--,u+=r[o++]<<l,l+=8}if(u!==(4294967295&i.total)){t.msg="incorrect length check",i.mode=kM;break}u=0,l=0}i.mode=NM;case NM:S=tM;break t;case kM:S=rM;break t;case BM:return nM;case FM:default:return iM}return t.next_out=a,t.avail_out=c,t.next_in=o,t.avail_in=s,i.hold=u,i.bits=l,(i.wsize||p!==t.avail_out&&i.mode<kM&&(i.mode<OM||e!==ZA))&&al(t,t.output,t.next_out,p-t.avail_out)?(i.mode=BM,nM):(h-=t.avail_in,p-=t.avail_out,t.total_in+=h,t.total_out+=p,i.total+=p,i.wrap&&p&&(t.adler=i.check=i.flags?Zu(i.check,n,p,t.next_out-p):Yu(i.check,n,p,t.next_out-p)),t.data_type=i.bits+(i.last?64:0)+(i.mode===yM?128:0)+(i.mode===PM||i.mode===_M?256:0),(0===h&&0===p||e===ZA)&&S===JA&&(S=oM),S)}function cl(t){if(!t||!t.state)return iM;var e=t.state;return e.window&&(e.window=null),t.state=null,JA}function ul(t,e){var i;return t&&t.state?0==(2&(i=t.state).wrap)?iM:(i.head=e,e.done=!1,JA):iM}function ll(t,e){var i,r,n=e.length;return t&&t.state?0!==(i=t.state).wrap&&i.mode!==vM?iM:i.mode===vM&&(r=1,(r=Yu(r,e,n,0))!==i.check)?rM:al(t,e,n,n)?(i.mode=BM,nM):(i.havedict=1,JA):iM}function hl(t){var e,i,r,n,o,a=t.length,s=0;for(n=0;n<a;n++)55296==(64512&(i=t.charCodeAt(n)))&&n+1<a&&56320==(64512&(r=t.charCodeAt(n+1)))&&(i=65536+(i-55296<<10)+(r-56320),n++),s+=i<128?1:i<2048?2:i<65536?3:4;for(e=new Uint8Array(s),o=0,n=0;o<s;n++)55296==(64512&(i=t.charCodeAt(n)))&&n+1<a&&56320==(64512&(r=t.charCodeAt(n+1)))&&(i=65536+(i-55296<<10)+(r-56320),n++),i<128?e[o++]=i:i<2048?(e[o++]=192|i>>>6,e[o++]=128|63&i):i<65536?(e[o++]=224|i>>>12,e[o++]=128|i>>>6&63,e[o++]=128|63&i):(e[o++]=240|i>>>18,e[o++]=128|i>>>12&63,e[o++]=128|i>>>6&63,e[o++]=128|63&i);return e}function pl(t,e){if(e<65537&&(t.subarray&&GM||!t.subarray&&VM))return String.fromCharCode.apply(null,Wu(t,e));for(var i="",r=0;r<e;r++)i+=String.fromCharCode(t[r]);return i}function dl(t){for(var e=new Uint8Array(t.length),i=0,r=e.length;i<r;i++)e[i]=t.charCodeAt(i);return e}function fl(t,e){var i,r,n,o,a=e||t.length,s=new Array(2*a);for(r=0,i=0;i<a;)if((n=t[i++])<128)s[r++]=n;else if((o=$M[n])>4)s[r++]=65533,i+=o-1;else{for(n&=2===o?31:3===o?15:7;o>1&&i<a;)n=n<<6|63&t[i++],o--;o>1?s[r++]=65533:n<65536?s[r++]=n:(n-=65536,s[r++]=55296|n>>10&1023,s[r++]=56320|1023&n)}return pl(s,r)}function ml(t,e){var i;for((e=e||t.length)>t.length&&(e=t.length),i=e-1;i>=0&&128==(192&t[i]);)i--;return i<0?e:0===i?e:i+$M[t[i]]>e?i:e}function gl(){this.input=null,this.next_in=0,this.avail_in=0,this.total_in=0,this.output=null,this.next_out=0,this.avail_out=0,this.total_out=0,this.msg="",this.state=null,this.data_type=2,this.adler=0}function vl(){this.text=0,this.time=0,this.xflags=0,this.os=0,this.extra=null,this.extra_len=0,this.name="",this.comment="",this.hcrc=0,this.done=!1}function yl(t){if(!(this instanceof yl))return new yl(t);this.options=Hu({chunkSize:16384,windowBits:0,to:""},t||{});var e=this.options;e.raw&&e.windowBits>=0&&e.windowBits<16&&(e.windowBits=-e.windowBits,0===e.windowBits&&(e.windowBits=-15)),!(e.windowBits>=0&&e.windowBits<16)||t&&t.windowBits||(e.windowBits+=32),e.windowBits>15&&e.windowBits<48&&0==(15&e.windowBits)&&(e.windowBits|=15),this.err=0,this.msg="",this.ended=!1,this.chunks=[],this.strm=new gl,this.strm.avail_out=0;var i=nl(this.strm,e.windowBits);if(i!==WM)throw new Error(XM[i]);this.header=new vl,ul(this.strm,this.header)}function bl(t,e){var i=new yl(e);if(i.push(t,!0),i.err)throw i.msg;return i.result}"undefined"!=typeof window&&function(){window.console=window.console||{};for(var t,e,i=window.console,r={},n="memory".split(","),o="assert,clear,count,debug,dir,dirxml,error,exception,group,groupCollapsed,groupEnd,info,log,markTimeline,profile,profiles,profileEnd,show,table,time,timeEnd,timeline,timelineEnd,timeStamp,trace,warn".split(",");t=n.pop();)i[t]||(i[t]=r);for(;e=o.pop();)i[e]||(i[e]=function(){})}(),void 0===window.HTMLCanvasElement||window.HTMLCanvasElement.prototype.toBlob||Object.defineProperty(window.HTMLCanvasElement.prototype,"toBlob",{value:function(t,e,i){for(var r=window.atob(this.toDataURL(e,i).split(",")[1]),n=r.length,o=n>>2,a=new Uint8Array(n),s=new Uint32Array(a.buffer,0,o),c=0,u=0;c<o;c++)s[c]=r.charCodeAt(u++)|r.charCodeAt(u++)<<8|r.charCodeAt(u++)<<16|r.charCodeAt(u++)<<24;for(var l=3&n;l--;)a[u]=r.charCodeAt(u++);t(new window.Blob([a],{type:e||"image/png"}))}}),Math.cbrt=Math.cbrt||function(t){var e=Math.pow(Math.abs(t),1/3);return t<0?-e:e},Math.sign||(Math.sign=function(t){return 0==(t=+t)||isNaN(t)?Number(t):t>0?1:-1}),Number.isInteger||(Number.isInteger=function(t){return"number"==typeof t&&isFinite(t)&&t>-9007199254740992&&t<9007199254740992&&Math.floor(t)===t}),Number.isNaN||(Number.isNaN=function(t){return t!==t}),Object.assign||Object.defineProperty(Object,"assign",{enumerable:!1,configurable:!0,writable:!0,value:function(t){var e=arguments;if(void 0===t||null===t)throw new TypeError("Cannot convert first argument to object");for(var i,r=Object(t),n=!1,o=1;o<arguments.length;o++){var a=e[o];if(void 0!==a&&null!==a){for(var s=Object.keys(Object(a)),c=0,u=s.length;c<u;c++){var l=s[c];try{var h=Object.getOwnPropertyDescriptor(a,l);void 0!==h&&h.enumerable&&(r[l]=a[l])}catch(t){n||(n=!0,i=t)}}if(n)throw i}}return r}}),String.prototype.startsWith||function(){var t=function(){var t;try{var e={},i=Object.defineProperty;t=i(e,e,e)&&i}catch(t){}return t}(),e={}.toString,i=function(t){if(null===this)throw TypeError();var i=String(this);if(t&&"[object RegExp]"===e.call(t))throw TypeError();var r=i.length,n=String(t),o=n.length,a=arguments.length>1?arguments[1]:void 0,s=a?Number(a):0;Number.isNaN(s)&&(s=0);var c=Math.min(Math.max(s,0),r);if(o+c>r)return!1;for(var u=-1;++u<o;)if(i.charCodeAt(c+u)!==n.charCodeAt(u))return!1;return!0};t?t(String.prototype,"startsWith",{value:i,configurable:!0,writable:!0}):String.prototype.startsWith=i}(),String.prototype.endsWith||(String.prototype.endsWith=function(t,e){var i=this.toString();("number"!=typeof e||!isFinite(e)||Math.floor(e)!==e||e>i.length)&&(e=i.length),e-=t.length;var r=i.indexOf(t,e);return-1!==r&&r===e}),String.prototype.repeat||(String.prototype.repeat=function(t){if(null===this)throw new TypeError("can't convert "+this+" to object");var e=""+this;if(t=+t,Number.isNaN(t)&&(t=0),t<0)throw new RangeError("repeat count must be non-negative");if(t===1/0)throw new RangeError("repeat count must be less than infinity");if(t=Math.floor(t),0===e.length||0===t)return"";if(e.length*t>=1<<28)throw new RangeError("repeat count must not overflow maximum string size");for(var i="";1==(1&t)&&(i+=e),0!==(t>>>=1);)e+=e;return i}),String.prototype.includes||(String.prototype.includes=function(t,e){return"number"!=typeof e&&(e=0),!(e+t.length>this.length)&&-1!==this.indexOf(t,e)}),Array.prototype.includes||(Array.prototype.includes=function(t){if(null==this)throw new TypeError("Array.prototype.includes called on null or undefined");var e=Object(this),i=parseInt(e.length,10)||0;if(0===i)return!1;var r,n=parseInt(arguments[1],10)||0;n>=0?r=n:(r=i+n)<0&&(r=0);for(var o;r<i;){if(o=e[r],t===o||Number.isNaN(t)&&Number.isNaN(o))return!0;r++}return!1}),Array.from||(Array.from=function(){var t=Object.prototype.toString,e=function(e){return"function"==typeof e||"[object Function]"===t.call(e)},i=function(t){var e=Number(t);return isNaN(e)?0:0!==e&&isFinite(e)?(e>0?1:-1)*Math.floor(Math.abs(e)):e},r=Math.pow(2,53)-1,n=function(t){var e=i(t);return Math.min(Math.max(e,0),r)};return function(t){var i=this,r=Object(t);if(null==t)throw new TypeError("Array.from requires an array-like object - not null or undefined");var o,a=arguments.length>1?arguments[1]:void 0;if(void 0!==a){if(!e(a))throw new TypeError("Array.from: when provided, the second argument must be a function");arguments.length>2&&(o=arguments[2])}for(var s,c=n(r.length),u=e(i)?Object(new i(c)):new Array(c),l=0;l<c;)s=r[l],u[l]=a?void 0===o?a(s,l):a.call(o,s,l):s,l+=1;return u.length=c,u}}()),"undefined"!=typeof window&&function(){for(var t=0,e=["ms","moz","webkit","o"],i=0;i<e.length&&!window.requestAnimationFrame;++i)window.requestAnimationFrame=window[e[i]+"RequestAnimationFrame"],window.cancelAnimationFrame=window[e[i]+"CancelAnimationFrame"]||window[e[i]+"CancelRequestAnimationFrame"];window.requestAnimationFrame||(window.requestAnimationFrame=function(e){var i=(new Date).getTime(),r=Math.max(0,16-(i-t)),n=window.setTimeout(function(){e(i+r)},r);return t=i+r,n}),window.cancelAnimationFrame||(window.cancelAnimationFrame=function(t){clearTimeout(t)})}(),void 0===Function.prototype.name&&void 0!==Object.defineProperty&&Object.defineProperty(Function.prototype,"name",{get:function(){return this.toString().match(/^\s*function\s*(\S*)\s*\(/)[1]}}),"undefined"!=typeof window&&(void 0===window.performance&&(self.performance={}),void 0===window.performance.now&&function(){var t=Date.now();window.performance.now=function(){return Date.now()-t}}());var xl=setTimeout,_l="function"==typeof setImmediate&&setImmediate||function(t){xl(t,0)},wl=function(t){"undefined"!=typeof console&&console&&console.warn("Possible Unhandled Promise Rejection:",t)};r.prototype.catch=function(t){return this.then(null,t)},r.prototype.then=function(t,i){var r=new this.constructor(e);return n(this,new c(t,i,r)),r},r.all=function(t){var e=Array.prototype.slice.call(t);return new r(function(t,i){function r(o,a){try{if(a&&("object"==typeof a||"function"==typeof a)){var s=a.then;if("function"==typeof s)return void s.call(a,function(t){r(o,t)},i)}e[o]=a,0==--n&&t(e)}catch(t){i(t)}}if(0===e.length)return t([]);for(var n=e.length,o=0;o<e.length;o++)r(o,e[o])})},r.resolve=function(t){return t&&"object"==typeof t&&t.constructor===r?t:new r(function(e){e(t)})},r.reject=function(t){return new r(function(e,i){i(t)})},r.race=function(t){return new r(function(e,i){for(var r=0,n=t.length;r<n;r++)t[r].then(e,i)})},r._setImmediateFn=function(t){_l=t},r._setUnhandledRejectionFn=function(t){wl=t},void 0===Number.EPSILON&&(Number.EPSILON=Math.pow(2,-52)),void 0===Number.isInteger&&(Number.isInteger=function(t){return"number"==typeof t&&isFinite(t)&&Math.floor(t)===t}),void 0===Math.sign&&(Math.sign=function(t){return t<0?-1:t>0?1:+t}),void 0===Function.prototype.name&&Object.defineProperty(Function.prototype,"name",{get:function(){return this.toString().match(/^\s*function\s*([^\(\s]*)/)[1]}}),void 0===Object.assign&&(Object.assign=function(t){var e=arguments;if(void 0===t||null===t)throw new TypeError("Cannot convert undefined or null to object");for(var i=Object(t),r=1;r<arguments.length;r++){var n=e[r];if(void 0!==n&&null!==n)for(var o in n)Object.prototype.hasOwnProperty.call(n,o)&&(i[o]=n[o])}return i}),Object.assign(l.prototype,{addEventListener:function(t,e){void 0===this._listeners&&(this._listeners={});var i=this._listeners;void 0===i[t]&&(i[t]=[]),-1===i[t].indexOf(e)&&i[t].push(e)},hasEventListener:function(t,e){if(void 0===this._listeners)return!1;var i=this._listeners;return void 0!==i[t]&&-1!==i[t].indexOf(e)},removeEventListener:function(t,e){if(void 0!==this._listeners){var i=this._listeners[t];if(void 0!==i){var r=i.indexOf(e);-1!==r&&i.splice(r,1)}}},dispatchEvent:function(t){var e=this;if(void 0!==this._listeners){var i=this._listeners[t.type];if(void 0!==i){t.target=this;for(var r=i.slice(0),n=0,o=r.length;n<o;n++)r[n].call(e,t)}}}});var Sl="87",Al=0,Ml=1,Pl=2,El=0,Tl=1,Cl=2,Il=0,Rl=1,Ll=2,Ol=0,Dl=1,Nl=2,kl=0,Bl=1,Fl=2,zl=3,Ul=4,jl=5,Vl=100,Gl=101,$l=102,Hl=103,Wl=104,Xl=200,ql=201,Yl=202,Zl=203,Kl=204,Ql=205,Jl=206,th=207,eh=208,ih=209,rh=210,nh=0,oh=1,ah=2,sh=3,ch=4,uh=5,lh=6,hh=7,ph=0,dh=1,fh=2,mh=0,gh=1,vh=2,yh=3,bh=4,xh=301,_h=302,wh=303,Sh=304,Ah=305,Mh=306,Ph=307,Eh=1e3,Th=1001,Ch=1002,Ih=1003,Rh=1004,Lh=1005,Oh=1006,Dh=1007,Nh=1008,kh=1009,Bh=1010,Fh=1011,zh=1012,Uh=1013,jh=1014,Vh=1015,Gh=1016,$h=1017,Hh=1018,Wh=1019,Xh=1020,qh=1021,Yh=1022,Zh=1023,Kh=1024,Qh=1025,Jh=1026,tp=1027,ep=2001,ip=2002,rp=2003,np=2004,op=2100,ap=2101,sp=2102,cp=2103,up=2151,lp=2201,hp=2400,pp=0,dp=1,fp=2,mp=3e3,gp=3001,vp=3007,yp=3002,bp=3004,xp=3005,_p=3006,wp=3200,Sp=3201,Ap={DEG2RAD:Math.PI/180,RAD2DEG:180/Math.PI,generateUUID:function(){var t,e="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".split(""),i=new Array(36),r=0;return function(){for(var n=0;n<36;n++)8===n||13===n||18===n||23===n?i[n]="-":14===n?i[n]="4":(r<=2&&(r=33554432+16777216*Math.random()|0),t=15&r,r>>=4,i[n]=e[19===n?3&t|8:t]);return i.join("")}}(),clamp:function(t,e,i){return Math.max(e,Math.min(i,t))},euclideanModulo:function(t,e){return(t%e+e)%e},mapLinear:function(t,e,i,r,n){return r+(t-e)*(n-r)/(i-e)},lerp:function(t,e,i){return(1-i)*t+i*e},smoothstep:function(t,e,i){return t<=e?0:t>=i?1:(t=(t-e)/(i-e))*t*(3-2*t)},smootherstep:function(t,e,i){return t<=e?0:t>=i?1:(t=(t-e)/(i-e))*t*t*(t*(6*t-15)+10)},randInt:function(t,e){return t+Math.floor(Math.random()*(e-t+1))},randFloat:function(t,e){return t+Math.random()*(e-t)},randFloatSpread:function(t){return t*(.5-Math.random())},degToRad:function(t){return t*Ap.DEG2RAD},radToDeg:function(t){return t*Ap.RAD2DEG},isPowerOfTwo:function(t){return 0==(t&t-1)&&0!==t},nearestPowerOfTwo:function(t){return Math.pow(2,Math.round(Math.log(t)/Math.LN2))},nextPowerOfTwo:function(t){return t--,t|=t>>1,t|=t>>2,t|=t>>4,t|=t>>8,t|=t>>16,++t}};Object.defineProperties(h.prototype,{width:{get:function(){return this.x},set:function(t){this.x=t}},height:{get:function(){return this.y},set:function(t){this.y=t}}}),Object.assign(h.prototype,{isVector2:!0,set:function(t,e){return this.x=t,this.y=e,this},setScalar:function(t){return this.x=t,this.y=t,this},setX:function(t){return this.x=t,this},setY:function(t){return this.y=t,this},setComponent:function(t,e){switch(t){case 0:this.x=e;break;case 1:this.y=e;break;default:throw new Error("index is out of range: "+t)}return this},getComponent:function(t){switch(t){case 0:return this.x;case 1:return this.y;default:throw new Error("index is out of range: "+t)}},clone:function(){return new this.constructor(this.x,this.y)},copy:function(t){return this.x=t.x,this.y=t.y,this},add:function(t,e){return void 0!==e?(console.warn("THREE.Vector2: .add() now only accepts one argument. Use .addVectors( a, b ) instead."),this.addVectors(t,e)):(this.x+=t.x,this.y+=t.y,this)},addScalar:function(t){return this.x+=t,this.y+=t,this},addVectors:function(t,e){return this.x=t.x+e.x,this.y=t.y+e.y,this},addScaledVector:function(t,e){return this.x+=t.x*e,this.y+=t.y*e,this},sub:function(t,e){return void 0!==e?(console.warn("THREE.Vector2: .sub() now only accepts one argument. Use .subVectors( a, b ) instead."),this.subVectors(t,e)):(this.x-=t.x,this.y-=t.y,this)},subScalar:function(t){return this.x-=t,this.y-=t,this},subVectors:function(t,e){return this.x=t.x-e.x,this.y=t.y-e.y,this},multiply:function(t){return this.x*=t.x,this.y*=t.y,this},multiplyScalar:function(t){return this.x*=t,this.y*=t,this},divide:function(t){return this.x/=t.x,this.y/=t.y,this},divideScalar:function(t){return this.multiplyScalar(1/t)},min:function(t){return this.x=Math.min(this.x,t.x),this.y=Math.min(this.y,t.y),this},max:function(t){return this.x=Math.max(this.x,t.x),this.y=Math.max(this.y,t.y),this},clamp:function(t,e){return this.x=Math.max(t.x,Math.min(e.x,this.x)),this.y=Math.max(t.y,Math.min(e.y,this.y)),this},clampScalar:function(){var t=new h,e=new h;return function(i,r){return t.set(i,i),e.set(r,r),this.clamp(t,e)}}(),clampLength:function(t,e){var i=this.length();return this.divideScalar(i||1).multiplyScalar(Math.max(t,Math.min(e,i)))},floor:function(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this},ceil:function(){return this.x=Math.ceil(this.x),this.y=Math.ceil(this.y),this},round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this},roundToZero:function(){return this.x=this.x<0?Math.ceil(this.x):Math.floor(this.x),this.y=this.y<0?Math.ceil(this.y):Math.floor(this.y),this},negate:function(){return this.x=-this.x,this.y=-this.y,this},dot:function(t){return this.x*t.x+this.y*t.y},lengthSq:function(){return this.x*this.x+this.y*this.y},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},lengthManhattan:function(){return Math.abs(this.x)+Math.abs(this.y)},normalize:function(){return this.divideScalar(this.length()||1)},angle:function(){var t=Math.atan2(this.y,this.x);return t<0&&(t+=2*Math.PI),t},distanceTo:function(t){return Math.sqrt(this.distanceToSquared(t))},distanceToSquared:function(t){var e=this.x-t.x,i=this.y-t.y;return e*e+i*i},distanceToManhattan:function(t){return Math.abs(this.x-t.x)+Math.abs(this.y-t.y)},setLength:function(t){return this.normalize().multiplyScalar(t)},lerp:function(t,e){return this.x+=(t.x-this.x)*e,this.y+=(t.y-this.y)*e,this},lerpVectors:function(t,e,i){return this.subVectors(e,t).multiplyScalar(i).add(t)},equals:function(t){return t.x===this.x&&t.y===this.y},fromArray:function(t,e){return void 0===e&&(e=0),this.x=t[e],this.y=t[e+1],this},toArray:function(t,e){return void 0===t&&(t=[]),void 0===e&&(e=0),t[e]=this.x,t[e+1]=this.y,t},fromBufferAttribute:function(t,e,i){return void 0!==i&&console.warn("THREE.Vector2: offset has been removed from .fromBufferAttribute()."),this.x=t.getX(e),this.y=t.getY(e),this},rotateAround:function(t,e){var i=Math.cos(e),r=Math.sin(e),n=this.x-t.x,o=this.y-t.y;return this.x=n*i-o*r+t.x,this.y=n*r+o*i+t.y,this}});var Mp=0;p.DEFAULT_IMAGE=void 0,p.DEFAULT_MAPPING=300,Object.defineProperty(p.prototype,"needsUpdate",{set:function(t){!0===t&&this.version++}}),Object.assign(p.prototype,l.prototype,{constructor:p,isTexture:!0,clone:function(){return(new this.constructor).copy(this)},copy:function(t){return this.name=t.name,this.image=t.image,this.mipmaps=t.mipmaps.slice(0),this.mapping=t.mapping,this.wrapS=t.wrapS,this.wrapT=t.wrapT,this.magFilter=t.magFilter,this.minFilter=t.minFilter,this.anisotropy=t.anisotropy,this.format=t.format,this.type=t.type,this.offset.copy(t.offset),this.repeat.copy(t.repeat),this.generateMipmaps=t.generateMipmaps,this.premultiplyAlpha=t.premultiplyAlpha,this.flipY=t.flipY,this.unpackAlignment=t.unpackAlignment,this.encoding=t.encoding,this},toJSON:function(t){if(void 0!==t.textures[this.uuid])return t.textures[this.uuid];var e={metadata:{version:4.5,type:"Texture",generator:"Texture.toJSON"},uuid:this.uuid,name:this.name,mapping:this.mapping,repeat:[this.repeat.x,this.repeat.y],offset:[this.offset.x,this.offset.y],wrap:[this.wrapS,this.wrapT],minFilter:this.minFilter,magFilter:this.magFilter,anisotropy:this.anisotropy,flipY:this.flipY};if(void 0!==this.image){var i=this.image;void 0===i.uuid&&(i.uuid=Ap.generateUUID()),void 0===t.images[i.uuid]&&(t.images[i.uuid]={uuid:i.uuid,url:function(t){var e;if(t instanceof HTMLCanvasElement)e=t;else{(e=document.createElementNS("http://www.w3.org/1999/xhtml","canvas")).width=t.width,e.height=t.height;var i=e.getContext("2d");t instanceof ImageData?i.putImageData(t,0,0):i.drawImage(t,0,0,t.width,t.height)}return e.width>2048||e.height>2048?e.toDataURL("image/jpeg",.6):e.toDataURL("image/png")}(i)}),e.image=i.uuid}return t.textures[this.uuid]=e,e},dispose:function(){this.dispatchEvent({type:"dispose"})},transformUv:function(t){if(300===this.mapping){if(t.multiply(this.repeat),t.add(this.offset),t.x<0||t.x>1)switch(this.wrapS){case Eh:t.x=t.x-Math.floor(t.x);break;case Th:t.x=t.x<0?0:1;break;case Ch:1===Math.abs(Math.floor(t.x)%2)?t.x=Math.ceil(t.x)-t.x:t.x=t.x-Math.floor(t.x)}if(t.y<0||t.y>1)switch(this.wrapT){case Eh:t.y=t.y-Math.floor(t.y);break;case Th:t.y=t.y<0?0:1;break;case Ch:1===Math.abs(Math.floor(t.y)%2)?t.y=Math.ceil(t.y)-t.y:t.y=t.y-Math.floor(t.y)}this.flipY&&(t.y=1-t.y)}}}),Object.assign(d.prototype,{isVector4:!0,set:function(t,e,i,r){return this.x=t,this.y=e,this.z=i,this.w=r,this},setScalar:function(t){return this.x=t,this.y=t,this.z=t,this.w=t,this},setX:function(t){return this.x=t,this},setY:function(t){return this.y=t,this},setZ:function(t){return this.z=t,this},setW:function(t){return this.w=t,this},setComponent:function(t,e){switch(t){case 0:this.x=e;break;case 1:this.y=e;break;case 2:this.z=e;break;case 3:this.w=e;break;default:throw new Error("index is out of range: "+t)}return this},getComponent:function(t){switch(t){case 0:return this.x;case 1:return this.y;case 2:return this.z;case 3:return this.w;default:throw new Error("index is out of range: "+t)}},clone:function(){return new this.constructor(this.x,this.y,this.z,this.w)},copy:function(t){return this.x=t.x,this.y=t.y,this.z=t.z,this.w=void 0!==t.w?t.w:1,this},add:function(t,e){return void 0!==e?(console.warn("THREE.Vector4: .add() now only accepts one argument. Use .addVectors( a, b ) instead."),this.addVectors(t,e)):(this.x+=t.x,this.y+=t.y,this.z+=t.z,this.w+=t.w,this)},addScalar:function(t){return this.x+=t,this.y+=t,this.z+=t,this.w+=t,this},addVectors:function(t,e){return this.x=t.x+e.x,this.y=t.y+e.y,this.z=t.z+e.z,this.w=t.w+e.w,this},addScaledVector:function(t,e){return this.x+=t.x*e,this.y+=t.y*e,this.z+=t.z*e,this.w+=t.w*e,this},sub:function(t,e){return void 0!==e?(console.warn("THREE.Vector4: .sub() now only accepts one argument. Use .subVectors( a, b ) instead."),this.subVectors(t,e)):(this.x-=t.x,this.y-=t.y,this.z-=t.z,this.w-=t.w,this)},subScalar:function(t){return this.x-=t,this.y-=t,this.z-=t,this.w-=t,this},subVectors:function(t,e){return this.x=t.x-e.x,this.y=t.y-e.y,this.z=t.z-e.z,this.w=t.w-e.w,this},multiplyScalar:function(t){return this.x*=t,this.y*=t,this.z*=t,this.w*=t,this},applyMatrix4:function(t){var e=this.x,i=this.y,r=this.z,n=this.w,o=t.elements;return this.x=o[0]*e+o[4]*i+o[8]*r+o[12]*n,this.y=o[1]*e+o[5]*i+o[9]*r+o[13]*n,this.z=o[2]*e+o[6]*i+o[10]*r+o[14]*n,this.w=o[3]*e+o[7]*i+o[11]*r+o[15]*n,this},divideScalar:function(t){return this.multiplyScalar(1/t)},setAxisAngleFromQuaternion:function(t){this.w=2*Math.acos(t.w);var e=Math.sqrt(1-t.w*t.w);return e<1e-4?(this.x=1,this.y=0,this.z=0):(this.x=t.x/e,this.y=t.y/e,this.z=t.z/e),this},setAxisAngleFromRotationMatrix:function(t){var e,i,r,n,o=t.elements,a=o[0],s=o[4],c=o[8],u=o[1],l=o[5],h=o[9],p=o[2],d=o[6],f=o[10];if(Math.abs(s-u)<.01&&Math.abs(c-p)<.01&&Math.abs(h-d)<.01){if(Math.abs(s+u)<.1&&Math.abs(c+p)<.1&&Math.abs(h+d)<.1&&Math.abs(a+l+f-3)<.1)return this.set(1,0,0,0),this;e=Math.PI;var m=(a+1)/2,g=(l+1)/2,v=(f+1)/2,y=(s+u)/4,b=(c+p)/4,x=(h+d)/4;return m>g&&m>v?m<.01?(i=0,r=.707106781,n=.707106781):(r=y/(i=Math.sqrt(m)),n=b/i):g>v?g<.01?(i=.707106781,r=0,n=.707106781):(i=y/(r=Math.sqrt(g)),n=x/r):v<.01?(i=.707106781,r=.707106781,n=0):(i=b/(n=Math.sqrt(v)),r=x/n),this.set(i,r,n,e),this}var _=Math.sqrt((d-h)*(d-h)+(c-p)*(c-p)+(u-s)*(u-s));return Math.abs(_)<.001&&(_=1),this.x=(d-h)/_,this.y=(c-p)/_,this.z=(u-s)/_,this.w=Math.acos((a+l+f-1)/2),this},min:function(t){return this.x=Math.min(this.x,t.x),this.y=Math.min(this.y,t.y),this.z=Math.min(this.z,t.z),this.w=Math.min(this.w,t.w),this},max:function(t){return this.x=Math.max(this.x,t.x),this.y=Math.max(this.y,t.y),this.z=Math.max(this.z,t.z),this.w=Math.max(this.w,t.w),this},clamp:function(t,e){return this.x=Math.max(t.x,Math.min(e.x,this.x)),this.y=Math.max(t.y,Math.min(e.y,this.y)),this.z=Math.max(t.z,Math.min(e.z,this.z)),this.w=Math.max(t.w,Math.min(e.w,this.w)),this},clampScalar:function(){var t,e;return function(i,r){return void 0===t&&(t=new d,e=new d),t.set(i,i,i,i),e.set(r,r,r,r),this.clamp(t,e)}}(),clampLength:function(t,e){var i=this.length();return this.divideScalar(i||1).multiplyScalar(Math.max(t,Math.min(e,i)))},floor:function(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this.z=Math.floor(this.z),this.w=Math.floor(this.w),this},ceil:function(){return this.x=Math.ceil(this.x),this.y=Math.ceil(this.y),this.z=Math.ceil(this.z),this.w=Math.ceil(this.w),this},round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this.z=Math.round(this.z),this.w=Math.round(this.w),this},roundToZero:function(){return this.x=this.x<0?Math.ceil(this.x):Math.floor(this.x),this.y=this.y<0?Math.ceil(this.y):Math.floor(this.y),this.z=this.z<0?Math.ceil(this.z):Math.floor(this.z),this.w=this.w<0?Math.ceil(this.w):Math.floor(this.w),this},negate:function(){return this.x=-this.x,this.y=-this.y,this.z=-this.z,this.w=-this.w,this},dot:function(t){return this.x*t.x+this.y*t.y+this.z*t.z+this.w*t.w},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)},lengthManhattan:function(){return Math.abs(this.x)+Math.abs(this.y)+Math.abs(this.z)+Math.abs(this.w)},normalize:function(){return this.divideScalar(this.length()||1)},setLength:function(t){return this.normalize().multiplyScalar(t)},lerp:function(t,e){return this.x+=(t.x-this.x)*e,this.y+=(t.y-this.y)*e,this.z+=(t.z-this.z)*e,this.w+=(t.w-this.w)*e,this},lerpVectors:function(t,e,i){return this.subVectors(e,t).multiplyScalar(i).add(t)},equals:function(t){return t.x===this.x&&t.y===this.y&&t.z===this.z&&t.w===this.w},fromArray:function(t,e){return void 0===e&&(e=0),this.x=t[e],this.y=t[e+1],this.z=t[e+2],this.w=t[e+3],this},toArray:function(t,e){return void 0===t&&(t=[]),void 0===e&&(e=0),t[e]=this.x,t[e+1]=this.y,t[e+2]=this.z,t[e+3]=this.w,t},fromBufferAttribute:function(t,e,i){return void 0!==i&&console.warn("THREE.Vector4: offset has been removed from .fromBufferAttribute()."),this.x=t.getX(e),this.y=t.getY(e),this.z=t.getZ(e),this.w=t.getW(e),this}}),Object.assign(f.prototype,l.prototype,{isWebGLRenderTarget:!0,setSize:function(t,e){this.width===t&&this.height===e||(this.width=t,this.height=e,this.dispose()),this.viewport.set(0,0,t,e),this.scissor.set(0,0,t,e)},clone:function(){return(new this.constructor).copy(this)},copy:function(t){return this.width=t.width,this.height=t.height,this.viewport.copy(t.viewport),this.texture=t.texture.clone(),this.depthBuffer=t.depthBuffer,this.stencilBuffer=t.stencilBuffer,this.depthTexture=t.depthTexture,this},dispose:function(){this.dispatchEvent({type:"dispose"})}}),m.prototype=Object.create(f.prototype),m.prototype.constructor=m,m.prototype.isWebGLRenderTargetCube=!0,Object.assign(g,{slerp:function(t,e,i,r){return i.copy(t).slerp(e,r)},slerpFlat:function(t,e,i,r,n,o,a){var s=i[r+0],c=i[r+1],u=i[r+2],l=i[r+3],h=n[o+0],p=n[o+1],d=n[o+2],f=n[o+3];if(l!==f||s!==h||c!==p||u!==d){var m=1-a,g=s*h+c*p+u*d+l*f,v=g>=0?1:-1,y=1-g*g;if(y>Number.EPSILON){var b=Math.sqrt(y),x=Math.atan2(b,g*v);m=Math.sin(m*x)/b,a=Math.sin(a*x)/b}var _=a*v;if(s=s*m+h*_,c=c*m+p*_,u=u*m+d*_,l=l*m+f*_,m===1-a){var w=1/Math.sqrt(s*s+c*c+u*u+l*l);s*=w,c*=w,u*=w,l*=w}}t[e]=s,t[e+1]=c,t[e+2]=u,t[e+3]=l}}),Object.defineProperties(g.prototype,{x:{get:function(){return this._x},set:function(t){this._x=t,this.onChangeCallback()}},y:{get:function(){return this._y},set:function(t){this._y=t,this.onChangeCallback()}},z:{get:function(){return this._z},set:function(t){this._z=t,this.onChangeCallback()}},w:{get:function(){return this._w},set:function(t){this._w=t,this.onChangeCallback()}}}),Object.assign(g.prototype,{set:function(t,e,i,r){return this._x=t,this._y=e,this._z=i,this._w=r,this.onChangeCallback(),this},clone:function(){return new this.constructor(this._x,this._y,this._z,this._w)},copy:function(t){return this._x=t.x,this._y=t.y,this._z=t.z,this._w=t.w,this.onChangeCallback(),this},setFromEuler:function(t,e){if(!t||!t.isEuler)throw new Error("THREE.Quaternion: .setFromEuler() now expects an Euler rotation rather than a Vector3 and order.");var i=t._x,r=t._y,n=t._z,o=t.order,a=Math.cos,s=Math.sin,c=a(i/2),u=a(r/2),l=a(n/2),h=s(i/2),p=s(r/2),d=s(n/2);return"XYZ"===o?(this._x=h*u*l+c*p*d,this._y=c*p*l-h*u*d,this._z=c*u*d+h*p*l,this._w=c*u*l-h*p*d):"YXZ"===o?(this._x=h*u*l+c*p*d,this._y=c*p*l-h*u*d,this._z=c*u*d-h*p*l,this._w=c*u*l+h*p*d):"ZXY"===o?(this._x=h*u*l-c*p*d,this._y=c*p*l+h*u*d,this._z=c*u*d+h*p*l,this._w=c*u*l-h*p*d):"ZYX"===o?(this._x=h*u*l-c*p*d,this._y=c*p*l+h*u*d,this._z=c*u*d-h*p*l,this._w=c*u*l+h*p*d):"YZX"===o?(this._x=h*u*l+c*p*d,this._y=c*p*l+h*u*d,this._z=c*u*d-h*p*l,this._w=c*u*l-h*p*d):"XZY"===o&&(this._x=h*u*l-c*p*d,this._y=c*p*l-h*u*d,this._z=c*u*d+h*p*l,this._w=c*u*l+h*p*d),!1!==e&&this.onChangeCallback(),this},setFromAxisAngle:function(t,e){var i=e/2,r=Math.sin(i);return this._x=t.x*r,this._y=t.y*r,this._z=t.z*r,this._w=Math.cos(i),this.onChangeCallback(),this},setFromRotationMatrix:function(t){var e,i=t.elements,r=i[0],n=i[4],o=i[8],a=i[1],s=i[5],c=i[9],u=i[2],l=i[6],h=i[10],p=r+s+h;return p>0?(e=.5/Math.sqrt(p+1),this._w=.25/e,this._x=(l-c)*e,this._y=(o-u)*e,this._z=(a-n)*e):r>s&&r>h?(e=2*Math.sqrt(1+r-s-h),this._w=(l-c)/e,this._x=.25*e,this._y=(n+a)/e,this._z=(o+u)/e):s>h?(e=2*Math.sqrt(1+s-r-h),this._w=(o-u)/e,this._x=(n+a)/e,this._y=.25*e,this._z=(c+l)/e):(e=2*Math.sqrt(1+h-r-s),this._w=(a-n)/e,this._x=(o+u)/e,this._y=(c+l)/e,this._z=.25*e),this.onChangeCallback(),this},setFromUnitVectors:function(){var t,e=new v;return function(i,r){return void 0===e&&(e=new v),(t=i.dot(r)+1)<1e-6?(t=0,Math.abs(i.x)>Math.abs(i.z)?e.set(-i.y,i.x,0):e.set(0,-i.z,i.y)):e.crossVectors(i,r),this._x=e.x,this._y=e.y,this._z=e.z,this._w=t,this.normalize()}}(),inverse:function(){return this.conjugate().normalize()},conjugate:function(){return this._x*=-1,this._y*=-1,this._z*=-1,this.onChangeCallback(),this},dot:function(t){return this._x*t._x+this._y*t._y+this._z*t._z+this._w*t._w},lengthSq:function(){return this._x*this._x+this._y*this._y+this._z*this._z+this._w*this._w},length:function(){return Math.sqrt(this._x*this._x+this._y*this._y+this._z*this._z+this._w*this._w)},normalize:function(){var t=this.length();return 0===t?(this._x=0,this._y=0,this._z=0,this._w=1):(t=1/t,this._x=this._x*t,this._y=this._y*t,this._z=this._z*t,this._w=this._w*t),this.onChangeCallback(),this},multiply:function(t,e){return void 0!==e?(console.warn("THREE.Quaternion: .multiply() now only accepts one argument. Use .multiplyQuaternions( a, b ) instead."),this.multiplyQuaternions(t,e)):this.multiplyQuaternions(this,t)},premultiply:function(t){return this.multiplyQuaternions(t,this)},multiplyQuaternions:function(t,e){var i=t._x,r=t._y,n=t._z,o=t._w,a=e._x,s=e._y,c=e._z,u=e._w;return this._x=i*u+o*a+r*c-n*s,this._y=r*u+o*s+n*a-i*c,this._z=n*u+o*c+i*s-r*a,this._w=o*u-i*a-r*s-n*c,this.onChangeCallback(),this},slerp:function(t,e){if(0===e)return this;if(1===e)return this.copy(t);var i=this._x,r=this._y,n=this._z,o=this._w,a=o*t._w+i*t._x+r*t._y+n*t._z;if(a<0?(this._w=-t._w,this._x=-t._x,this._y=-t._y,this._z=-t._z,a=-a):this.copy(t),a>=1)return this._w=o,this._x=i,this._y=r,this._z=n,this;var s=Math.sqrt(1-a*a);if(Math.abs(s)<.001)return this._w=.5*(o+this._w),this._x=.5*(i+this._x),this._y=.5*(r+this._y),this._z=.5*(n+this._z),this;var c=Math.atan2(s,a),u=Math.sin((1-e)*c)/s,l=Math.sin(e*c)/s;return this._w=o*u+this._w*l,this._x=i*u+this._x*l,this._y=r*u+this._y*l,this._z=n*u+this._z*l,this.onChangeCallback(),this},equals:function(t){return t._x===this._x&&t._y===this._y&&t._z===this._z&&t._w===this._w},fromArray:function(t,e){return void 0===e&&(e=0),this._x=t[e],this._y=t[e+1],this._z=t[e+2],this._w=t[e+3],this.onChangeCallback(),this},toArray:function(t,e){return void 0===t&&(t=[]),void 0===e&&(e=0),t[e]=this._x,t[e+1]=this._y,t[e+2]=this._z,t[e+3]=this._w,t},onChange:function(t){return this.onChangeCallback=t,this},onChangeCallback:function(){}}),Object.assign(v.prototype,{isVector3:!0,set:function(t,e,i){return this.x=t,this.y=e,this.z=i,this},setScalar:function(t){return this.x=t,this.y=t,this.z=t,this},setX:function(t){return this.x=t,this},setY:function(t){return this.y=t,this},setZ:function(t){return this.z=t,this},setComponent:function(t,e){switch(t){case 0:this.x=e;break;case 1:this.y=e;break;case 2:this.z=e;break;default:throw new Error("index is out of range: "+t)}return this},getComponent:function(t){switch(t){case 0:return this.x;case 1:return this.y;case 2:return this.z;default:throw new Error("index is out of range: "+t)}},clone:function(){return new this.constructor(this.x,this.y,this.z)},copy:function(t){return this.x=t.x,this.y=t.y,this.z=t.z,this},add:function(t,e){return void 0!==e?(console.warn("THREE.Vector3: .add() now only accepts one argument. Use .addVectors( a, b ) instead."),this.addVectors(t,e)):(this.x+=t.x,this.y+=t.y,this.z+=t.z,this)},addScalar:function(t){return this.x+=t,this.y+=t,this.z+=t,this},addVectors:function(t,e){return this.x=t.x+e.x,this.y=t.y+e.y,this.z=t.z+e.z,this},addScaledVector:function(t,e){return this.x+=t.x*e,this.y+=t.y*e,this.z+=t.z*e,this},sub:function(t,e){return void 0!==e?(console.warn("THREE.Vector3: .sub() now only accepts one argument. Use .subVectors( a, b ) instead."),this.subVectors(t,e)):(this.x-=t.x,this.y-=t.y,this.z-=t.z,this)},subScalar:function(t){return this.x-=t,this.y-=t,this.z-=t,this},subVectors:function(t,e){return this.x=t.x-e.x,this.y=t.y-e.y,this.z=t.z-e.z,this},multiply:function(t,e){return void 0!==e?(console.warn("THREE.Vector3: .multiply() now only accepts one argument. Use .multiplyVectors( a, b ) instead."),this.multiplyVectors(t,e)):(this.x*=t.x,this.y*=t.y,this.z*=t.z,this)},multiplyScalar:function(t){return this.x*=t,this.y*=t,this.z*=t,this},multiplyVectors:function(t,e){return this.x=t.x*e.x,this.y=t.y*e.y,this.z=t.z*e.z,this},applyEuler:function(){var t=new g;return function(e){return e&&e.isEuler||console.error("THREE.Vector3: .applyEuler() now expects an Euler rotation rather than a Vector3 and order."),this.applyQuaternion(t.setFromEuler(e))}}(),applyAxisAngle:function(){var t=new g;return function(e,i){return this.applyQuaternion(t.setFromAxisAngle(e,i))}}(),applyMatrix3:function(t){var e=this.x,i=this.y,r=this.z,n=t.elements;return this.x=n[0]*e+n[3]*i+n[6]*r,this.y=n[1]*e+n[4]*i+n[7]*r,this.z=n[2]*e+n[5]*i+n[8]*r,this},applyMatrix4:function(t){var e=this.x,i=this.y,r=this.z,n=t.elements,o=1/(n[3]*e+n[7]*i+n[11]*r+n[15]);return this.x=(n[0]*e+n[4]*i+n[8]*r+n[12])*o,this.y=(n[1]*e+n[5]*i+n[9]*r+n[13])*o,this.z=(n[2]*e+n[6]*i+n[10]*r+n[14])*o,this},applyQuaternion:function(t){var e=this.x,i=this.y,r=this.z,n=t.x,o=t.y,a=t.z,s=t.w,c=s*e+o*r-a*i,u=s*i+a*e-n*r,l=s*r+n*i-o*e,h=-n*e-o*i-a*r;return this.x=c*s+h*-n+u*-a-l*-o,this.y=u*s+h*-o+l*-n-c*-a,this.z=l*s+h*-a+c*-o-u*-n,this},project:function(){var t=new y;return function(e){return t.multiplyMatrices(e.projectionMatrix,t.getInverse(e.matrixWorld)),this.applyMatrix4(t)}}(),unproject:function(){var t=new y;return function(e){return t.multiplyMatrices(e.matrixWorld,t.getInverse(e.projectionMatrix)),this.applyMatrix4(t)}}(),transformDirection:function(t){var e=this.x,i=this.y,r=this.z,n=t.elements;return this.x=n[0]*e+n[4]*i+n[8]*r,this.y=n[1]*e+n[5]*i+n[9]*r,this.z=n[2]*e+n[6]*i+n[10]*r,this.normalize()},divide:function(t){return this.x/=t.x,this.y/=t.y,this.z/=t.z,this},divideScalar:function(t){return this.multiplyScalar(1/t)},min:function(t){return this.x=Math.min(this.x,t.x),this.y=Math.min(this.y,t.y),this.z=Math.min(this.z,t.z),this},max:function(t){return this.x=Math.max(this.x,t.x),this.y=Math.max(this.y,t.y),this.z=Math.max(this.z,t.z),this},clamp:function(t,e){return this.x=Math.max(t.x,Math.min(e.x,this.x)),this.y=Math.max(t.y,Math.min(e.y,this.y)),this.z=Math.max(t.z,Math.min(e.z,this.z)),this},clampScalar:function(){var t=new v,e=new v;return function(i,r){return t.set(i,i,i),e.set(r,r,r),this.clamp(t,e)}}(),clampLength:function(t,e){var i=this.length();return this.divideScalar(i||1).multiplyScalar(Math.max(t,Math.min(e,i)))},floor:function(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this.z=Math.floor(this.z),this},ceil:function(){return this.x=Math.ceil(this.x),this.y=Math.ceil(this.y),this.z=Math.ceil(this.z),this},round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this.z=Math.round(this.z),this},roundToZero:function(){return this.x=this.x<0?Math.ceil(this.x):Math.floor(this.x),this.y=this.y<0?Math.ceil(this.y):Math.floor(this.y),this.z=this.z<0?Math.ceil(this.z):Math.floor(this.z),this},negate:function(){return this.x=-this.x,this.y=-this.y,this.z=-this.z,this},dot:function(t){return this.x*t.x+this.y*t.y+this.z*t.z},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z)},lengthManhattan:function(){return Math.abs(this.x)+Math.abs(this.y)+Math.abs(this.z)},normalize:function(){return this.divideScalar(this.length()||1)},setLength:function(t){return this.normalize().multiplyScalar(t)},lerp:function(t,e){return this.x+=(t.x-this.x)*e,this.y+=(t.y-this.y)*e,this.z+=(t.z-this.z)*e,this},lerpVectors:function(t,e,i){return this.subVectors(e,t).multiplyScalar(i).add(t)},cross:function(t,e){if(void 0!==e)return console.warn("THREE.Vector3: .cross() now only accepts one argument. Use .crossVectors( a, b ) instead."),this.crossVectors(t,e);var i=this.x,r=this.y,n=this.z;return this.x=r*t.z-n*t.y,this.y=n*t.x-i*t.z,this.z=i*t.y-r*t.x,this},crossVectors:function(t,e){var i=t.x,r=t.y,n=t.z,o=e.x,a=e.y,s=e.z;return this.x=r*s-n*a,this.y=n*o-i*s,this.z=i*a-r*o,this},projectOnVector:function(t){var e=t.dot(this)/t.lengthSq();return this.copy(t).multiplyScalar(e)},projectOnPlane:function(){var t=new v;return function(e){return t.copy(this).projectOnVector(e),this.sub(t)}}(),reflect:function(){var t=new v;return function(e){return this.sub(t.copy(e).multiplyScalar(2*this.dot(e)))}}(),angleTo:function(t){var e=this.dot(t)/Math.sqrt(this.lengthSq()*t.lengthSq());return Math.acos(Ap.clamp(e,-1,1))},distanceTo:function(t){return Math.sqrt(this.distanceToSquared(t))},distanceToSquared:function(t){var e=this.x-t.x,i=this.y-t.y,r=this.z-t.z;return e*e+i*i+r*r},distanceToManhattan:function(t){return Math.abs(this.x-t.x)+Math.abs(this.y-t.y)+Math.abs(this.z-t.z)},setFromSpherical:function(t){var e=Math.sin(t.phi)*t.radius;return this.x=e*Math.sin(t.theta),this.y=Math.cos(t.phi)*t.radius,this.z=e*Math.cos(t.theta),this},setFromCylindrical:function(t){return this.x=t.radius*Math.sin(t.theta),this.y=t.y,this.z=t.radius*Math.cos(t.theta),this},setFromMatrixPosition:function(t){var e=t.elements;return this.x=e[12],this.y=e[13],this.z=e[14],this},setFromMatrixScale:function(t){var e=this.setFromMatrixColumn(t,0).length(),i=this.setFromMatrixColumn(t,1).length(),r=this.setFromMatrixColumn(t,2).length();return this.x=e,this.y=i,this.z=r,this},setFromMatrixColumn:function(t,e){return this.fromArray(t.elements,4*e)},equals:function(t){return t.x===this.x&&t.y===this.y&&t.z===this.z},fromArray:function(t,e){return void 0===e&&(e=0),this.x=t[e],this.y=t[e+1],this.z=t[e+2],this},toArray:function(t,e){return void 0===t&&(t=[]),void 0===e&&(e=0),t[e]=this.x,t[e+1]=this.y,t[e+2]=this.z,t},fromBufferAttribute:function(t,e,i){return void 0!==i&&console.warn("THREE.Vector3: offset has been removed from .fromBufferAttribute()."),this.x=t.getX(e),this.y=t.getY(e),this.z=t.getZ(e),this}}),Object.assign(y.prototype,{isMatrix4:!0,set:function(t,e,i,r,n,o,a,s,c,u,l,h,p,d,f,m){var g=this.elements;return g[0]=t,g[4]=e,g[8]=i,g[12]=r,g[1]=n,g[5]=o,g[9]=a,g[13]=s,g[2]=c,g[6]=u,g[10]=l,g[14]=h,g[3]=p,g[7]=d,g[11]=f,g[15]=m,this},identity:function(){return this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1),this},clone:function(){return(new y).fromArray(this.elements)},copy:function(t){var e=this.elements,i=t.elements;return e[0]=i[0],e[1]=i[1],e[2]=i[2],e[3]=i[3],e[4]=i[4],e[5]=i[5],e[6]=i[6],e[7]=i[7],e[8]=i[8],e[9]=i[9],e[10]=i[10],e[11]=i[11],e[12]=i[12],e[13]=i[13],e[14]=i[14],e[15]=i[15],this},copyPosition:function(t){var e=this.elements,i=t.elements;return e[12]=i[12],e[13]=i[13],e[14]=i[14],this},extractBasis:function(t,e,i){return t.setFromMatrixColumn(this,0),e.setFromMatrixColumn(this,1),i.setFromMatrixColumn(this,2),this},makeBasis:function(t,e,i){return this.set(t.x,e.x,i.x,0,t.y,e.y,i.y,0,t.z,e.z,i.z,0,0,0,0,1),this},extractRotation:function(){var t=new v;return function(e){var i=this.elements,r=e.elements,n=1/t.setFromMatrixColumn(e,0).length(),o=1/t.setFromMatrixColumn(e,1).length(),a=1/t.setFromMatrixColumn(e,2).length();return i[0]=r[0]*n,i[1]=r[1]*n,i[2]=r[2]*n,i[4]=r[4]*o,i[5]=r[5]*o,i[6]=r[6]*o,i[8]=r[8]*a,i[9]=r[9]*a,i[10]=r[10]*a,this}}(),makeRotationFromEuler:function(t){t&&t.isEuler||console.error("THREE.Matrix4: .makeRotationFromEuler() now expects a Euler rotation rather than a Vector3 and order.");var e=this.elements,i=t.x,r=t.y,n=t.z,o=Math.cos(i),a=Math.sin(i),s=Math.cos(r),c=Math.sin(r),u=Math.cos(n),l=Math.sin(n);if("XYZ"===t.order){var h=o*u,p=o*l,d=a*u,f=a*l;e[0]=s*u,e[4]=-s*l,e[8]=c,e[1]=p+d*c,e[5]=h-f*c,e[9]=-a*s,e[2]=f-h*c,e[6]=d+p*c,e[10]=o*s}else if("YXZ"===t.order){var m=s*u,g=s*l,v=c*u,y=c*l;e[0]=m+y*a,e[4]=v*a-g,e[8]=o*c,e[1]=o*l,e[5]=o*u,e[9]=-a,e[2]=g*a-v,e[6]=y+m*a,e[10]=o*s}else if("ZXY"===t.order){var m=s*u,g=s*l,v=c*u,y=c*l;e[0]=m-y*a,e[4]=-o*l,e[8]=v+g*a,e[1]=g+v*a,e[5]=o*u,e[9]=y-m*a,e[2]=-o*c,e[6]=a,e[10]=o*s}else if("ZYX"===t.order){var h=o*u,p=o*l,d=a*u,f=a*l;e[0]=s*u,e[4]=d*c-p,e[8]=h*c+f,e[1]=s*l,e[5]=f*c+h,e[9]=p*c-d,e[2]=-c,e[6]=a*s,e[10]=o*s}else if("YZX"===t.order){var b=o*s,x=o*c,_=a*s,w=a*c;e[0]=s*u,e[4]=w-b*l,e[8]=_*l+x,e[1]=l,e[5]=o*u,e[9]=-a*u,e[2]=-c*u,e[6]=x*l+_,e[10]=b-w*l}else if("XZY"===t.order){var b=o*s,x=o*c,_=a*s,w=a*c;e[0]=s*u,e[4]=-l,e[8]=c*u,e[1]=b*l+w,e[5]=o*u,e[9]=x*l-_,e[2]=_*l-x,e[6]=a*u,e[10]=w*l+b}return e[3]=0,e[7]=0,e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,this},makeRotationFromQuaternion:function(t){var e=this.elements,i=t._x,r=t._y,n=t._z,o=t._w,a=i+i,s=r+r,c=n+n,u=i*a,l=i*s,h=i*c,p=r*s,d=r*c,f=n*c,m=o*a,g=o*s,v=o*c;return e[0]=1-(p+f),e[4]=l-v,e[8]=h+g,e[1]=l+v,e[5]=1-(u+f),e[9]=d-m,e[2]=h-g,e[6]=d+m,e[10]=1-(u+p),e[3]=0,e[7]=0,e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,this},lookAt:function(){var t=new v,e=new v,i=new v;return function(r,n,o){var a=this.elements;return i.subVectors(r,n),0===i.lengthSq()&&(i.z=1),i.normalize(),t.crossVectors(o,i),0===t.lengthSq()&&(1===Math.abs(o.z)?i.x+=1e-4:i.z+=1e-4,i.normalize(),t.crossVectors(o,i)),t.normalize(),e.crossVectors(i,t),a[0]=t.x,a[4]=e.x,a[8]=i.x,a[1]=t.y,a[5]=e.y,a[9]=i.y,a[2]=t.z,a[6]=e.z,a[10]=i.z,this}}(),multiply:function(t,e){return void 0!==e?(console.warn("THREE.Matrix4: .multiply() now only accepts one argument. Use .multiplyMatrices( a, b ) instead."),this.multiplyMatrices(t,e)):this.multiplyMatrices(this,t)},premultiply:function(t){return this.multiplyMatrices(t,this)},multiplyMatrices:function(t,e){var i=t.elements,r=e.elements,n=this.elements,o=i[0],a=i[4],s=i[8],c=i[12],u=i[1],l=i[5],h=i[9],p=i[13],d=i[2],f=i[6],m=i[10],g=i[14],v=i[3],y=i[7],b=i[11],x=i[15],_=r[0],w=r[4],S=r[8],A=r[12],M=r[1],P=r[5],E=r[9],T=r[13],C=r[2],I=r[6],R=r[10],L=r[14],O=r[3],D=r[7],N=r[11],k=r[15];return n[0]=o*_+a*M+s*C+c*O,n[4]=o*w+a*P+s*I+c*D,n[8]=o*S+a*E+s*R+c*N,n[12]=o*A+a*T+s*L+c*k,n[1]=u*_+l*M+h*C+p*O,n[5]=u*w+l*P+h*I+p*D,n[9]=u*S+l*E+h*R+p*N,n[13]=u*A+l*T+h*L+p*k,n[2]=d*_+f*M+m*C+g*O,n[6]=d*w+f*P+m*I+g*D,n[10]=d*S+f*E+m*R+g*N,n[14]=d*A+f*T+m*L+g*k,n[3]=v*_+y*M+b*C+x*O,n[7]=v*w+y*P+b*I+x*D,n[11]=v*S+y*E+b*R+x*N,n[15]=v*A+y*T+b*L+x*k,this},multiplyScalar:function(t){var e=this.elements;return e[0]*=t,e[4]*=t,e[8]*=t,e[12]*=t,e[1]*=t,e[5]*=t,e[9]*=t,e[13]*=t,e[2]*=t,e[6]*=t,e[10]*=t,e[14]*=t,e[3]*=t,e[7]*=t,e[11]*=t,e[15]*=t,this},applyToBufferAttribute:function(){var t=new v;return function(e){for(var i=this,r=0,n=e.count;r<n;r++)t.x=e.getX(r),t.y=e.getY(r),t.z=e.getZ(r),t.applyMatrix4(i),e.setXYZ(r,t.x,t.y,t.z);return e}}(),determinant:function(){var t=this.elements,e=t[0],i=t[4],r=t[8],n=t[12],o=t[1],a=t[5],s=t[9],c=t[13],u=t[2],l=t[6],h=t[10],p=t[14];return t[3]*(+n*s*l-r*c*l-n*a*h+i*c*h+r*a*p-i*s*p)+t[7]*(+e*s*p-e*c*h+n*o*h-r*o*p+r*c*u-n*s*u)+t[11]*(+e*c*l-e*a*p-n*o*l+i*o*p+n*a*u-i*c*u)+t[15]*(-r*a*u-e*s*l+e*a*h+r*o*l-i*o*h+i*s*u)},transpose:function(){var t,e=this.elements;return t=e[1],e[1]=e[4],e[4]=t,t=e[2],e[2]=e[8],e[8]=t,t=e[6],e[6]=e[9],e[9]=t,t=e[3],e[3]=e[12],e[12]=t,t=e[7],e[7]=e[13],e[13]=t,t=e[11],e[11]=e[14],e[14]=t,this},setPosition:function(t){var e=this.elements;return e[12]=t.x,e[13]=t.y,e[14]=t.z,this},getInverse:function(t,e){var i=this.elements,r=t.elements,n=r[0],o=r[1],a=r[2],s=r[3],c=r[4],u=r[5],l=r[6],h=r[7],p=r[8],d=r[9],f=r[10],m=r[11],g=r[12],v=r[13],y=r[14],b=r[15],x=d*y*h-v*f*h+v*l*m-u*y*m-d*l*b+u*f*b,_=g*f*h-p*y*h-g*l*m+c*y*m+p*l*b-c*f*b,w=p*v*h-g*d*h+g*u*m-c*v*m-p*u*b+c*d*b,S=g*d*l-p*v*l-g*u*f+c*v*f+p*u*y-c*d*y,A=n*x+o*_+a*w+s*S;if(0===A){var M="THREE.Matrix4: .getInverse() can't invert matrix, determinant is 0";if(!0===e)throw new Error(M);return console.warn(M),this.identity()}var P=1/A;return i[0]=x*P,i[1]=(v*f*s-d*y*s-v*a*m+o*y*m+d*a*b-o*f*b)*P,i[2]=(u*y*s-v*l*s+v*a*h-o*y*h-u*a*b+o*l*b)*P,i[3]=(d*l*s-u*f*s-d*a*h+o*f*h+u*a*m-o*l*m)*P,i[4]=_*P,i[5]=(p*y*s-g*f*s+g*a*m-n*y*m-p*a*b+n*f*b)*P,i[6]=(g*l*s-c*y*s-g*a*h+n*y*h+c*a*b-n*l*b)*P,i[7]=(c*f*s-p*l*s+p*a*h-n*f*h-c*a*m+n*l*m)*P,i[8]=w*P,i[9]=(g*d*s-p*v*s-g*o*m+n*v*m+p*o*b-n*d*b)*P,i[10]=(c*v*s-g*u*s+g*o*h-n*v*h-c*o*b+n*u*b)*P,i[11]=(p*u*s-c*d*s-p*o*h+n*d*h+c*o*m-n*u*m)*P,i[12]=S*P,i[13]=(p*v*a-g*d*a+g*o*f-n*v*f-p*o*y+n*d*y)*P,i[14]=(g*u*a-c*v*a-g*o*l+n*v*l+c*o*y-n*u*y)*P,i[15]=(c*d*a-p*u*a+p*o*l-n*d*l-c*o*f+n*u*f)*P,this},scale:function(t){var e=this.elements,i=t.x,r=t.y,n=t.z;return e[0]*=i,e[4]*=r,e[8]*=n,e[1]*=i,e[5]*=r,e[9]*=n,e[2]*=i,e[6]*=r,e[10]*=n,e[3]*=i,e[7]*=r,e[11]*=n,this},getMaxScaleOnAxis:function(){var t=this.elements,e=t[0]*t[0]+t[1]*t[1]+t[2]*t[2],i=t[4]*t[4]+t[5]*t[5]+t[6]*t[6],r=t[8]*t[8]+t[9]*t[9]+t[10]*t[10];return Math.sqrt(Math.max(e,i,r))},makeTranslation:function(t,e,i){return this.set(1,0,0,t,0,1,0,e,0,0,1,i,0,0,0,1),this},makeRotationX:function(t){var e=Math.cos(t),i=Math.sin(t);return this.set(1,0,0,0,0,e,-i,0,0,i,e,0,0,0,0,1),this},makeRotationY:function(t){var e=Math.cos(t),i=Math.sin(t);return this.set(e,0,i,0,0,1,0,0,-i,0,e,0,0,0,0,1),this},makeRotationZ:function(t){var e=Math.cos(t),i=Math.sin(t);return this.set(e,-i,0,0,i,e,0,0,0,0,1,0,0,0,0,1),this},makeRotationAxis:function(t,e){var i=Math.cos(e),r=Math.sin(e),n=1-i,o=t.x,a=t.y,s=t.z,c=n*o,u=n*a;return this.set(c*o+i,c*a-r*s,c*s+r*a,0,c*a+r*s,u*a+i,u*s-r*o,0,c*s-r*a,u*s+r*o,n*s*s+i,0,0,0,0,1),this},makeScale:function(t,e,i){return this.set(t,0,0,0,0,e,0,0,0,0,i,0,0,0,0,1),this},makeShear:function(t,e,i){return this.set(1,e,i,0,t,1,i,0,t,e,1,0,0,0,0,1),this},compose:function(t,e,i){return this.makeRotationFromQuaternion(e),this.scale(i),this.setPosition(t),this},decompose:function(){var t=new v,e=new y;return function(i,r,n){var o=this.elements,a=t.set(o[0],o[1],o[2]).length(),s=t.set(o[4],o[5],o[6]).length(),c=t.set(o[8],o[9],o[10]).length();this.determinant()<0&&(a=-a),i.x=o[12],i.y=o[13],i.z=o[14],e.copy(this);var u=1/a,l=1/s,h=1/c;return e.elements[0]*=u,e.elements[1]*=u,e.elements[2]*=u,e.elements[4]*=l,e.elements[5]*=l,e.elements[6]*=l,e.elements[8]*=h,e.elements[9]*=h,e.elements[10]*=h,r.setFromRotationMatrix(e),n.x=a,n.y=s,n.z=c,this}}(),makePerspective:function(t,e,i,r,n,o){void 0===o&&console.warn("THREE.Matrix4: .makePerspective() has been redefined and has a new signature. Please check the docs.");var a=this.elements,s=2*n/(e-t),c=2*n/(i-r),u=(e+t)/(e-t),l=(i+r)/(i-r),h=-(o+n)/(o-n),p=-2*o*n/(o-n);return a[0]=s,a[4]=0,a[8]=u,a[12]=0,a[1]=0,a[5]=c,a[9]=l,a[13]=0,a[2]=0,a[6]=0,a[10]=h,a[14]=p,a[3]=0,a[7]=0,a[11]=-1,a[15]=0,this},makeOrthographic:function(t,e,i,r,n,o){var a=this.elements,s=1/(e-t),c=1/(i-r),u=1/(o-n),l=(e+t)*s,h=(i+r)*c,p=(o+n)*u;return a[0]=2*s,a[4]=0,a[8]=0,a[12]=-l,a[1]=0,a[5]=2*c,a[9]=0,a[13]=-h,a[2]=0,a[6]=0,a[10]=-2*u,a[14]=-p,a[3]=0,a[7]=0,a[11]=0,a[15]=1,this},equals:function(t){for(var e=this.elements,i=t.elements,r=0;r<16;r++)if(e[r]!==i[r])return!1;return!0},fromArray:function(t,e){var i=this;void 0===e&&(e=0);for(var r=0;r<16;r++)i.elements[r]=t[r+e];return this},toArray:function(t,e){void 0===t&&(t=[]),void 0===e&&(e=0);var i=this.elements;return t[e]=i[0],t[e+1]=i[1],t[e+2]=i[2],t[e+3]=i[3],t[e+4]=i[4],t[e+5]=i[5],t[e+6]=i[6],t[e+7]=i[7],t[e+8]=i[8],t[e+9]=i[9],t[e+10]=i[10],t[e+11]=i[11],t[e+12]=i[12],t[e+13]=i[13],t[e+14]=i[14],t[e+15]=i[15],t}}),b.prototype=Object.create(p.prototype),b.prototype.constructor=b,b.prototype.isDataTexture=!0,(x.prototype=Object.create(p.prototype)).constructor=x,x.prototype.isCubeTexture=!0,Object.defineProperty(x.prototype,"images",{get:function(){return this.image},set:function(t){this.image=t}});var Pp=new p,Ep=new x,Tp=[],Cp=[],Ip=new Float32Array(16),Rp=new Float32Array(9);K.prototype.setValue=function(t,e){for(var i=this.seq,r=0,n=i.length;r!==n;++r){var o=i[r];o.setValue(t,e[o.id])}};var Lp=/([\w\d_]+)(\])?(\[|\.)?/g;tt.prototype.setValue=function(t,e,i){var r=this.map[e];void 0!==r&&r.setValue(t,i,this.renderer)},tt.prototype.setOptional=function(t,e,i){var r=e[i];void 0!==r&&this.setValue(t,i,r)},tt.upload=function(t,e,i,r){for(var n=0,o=e.length;n!==o;++n){var a=e[n],s=i[a.id];!1!==s.needsUpdate&&a.setValue(t,s.value,r)}},tt.seqWithValue=function(t,e){for(var i=[],r=0,n=t.length;r!==n;++r){var o=t[r];o.id in e&&i.push(o)}return i};var Op={aliceblue:15792383,antiquewhite:16444375,aqua:65535,aquamarine:8388564,azure:15794175,beige:16119260,bisque:16770244,black:0,blanchedalmond:16772045,blue:255,blueviolet:9055202,brown:10824234,burlywood:14596231,cadetblue:6266528,chartreuse:8388352,chocolate:13789470,coral:16744272,cornflowerblue:6591981,cornsilk:16775388,crimson:14423100,cyan:65535,darkblue:139,darkcyan:35723,darkgoldenrod:12092939,darkgray:11119017,darkgreen:25600,darkgrey:11119017,darkkhaki:12433259,darkmagenta:9109643,darkolivegreen:5597999,darkorange:16747520,darkorchid:10040012,darkred:9109504,darksalmon:15308410,darkseagreen:9419919,darkslateblue:4734347,darkslategray:3100495,darkslategrey:3100495,darkturquoise:52945,darkviolet:9699539,deeppink:16716947,deepskyblue:49151,dimgray:6908265,dimgrey:6908265,dodgerblue:2003199,firebrick:11674146,floralwhite:16775920,forestgreen:2263842,fuchsia:16711935,gainsboro:14474460,ghostwhite:16316671,gold:16766720,goldenrod:14329120,gray:8421504,green:32768,greenyellow:11403055,grey:8421504,honeydew:15794160,hotpink:16738740,indianred:13458524,indigo:4915330,ivory:16777200,khaki:15787660,lavender:15132410,lavenderblush:16773365,lawngreen:8190976,lemonchiffon:16775885,lightblue:11393254,lightcoral:15761536,lightcyan:14745599,lightgoldenrodyellow:16448210,lightgray:13882323,lightgreen:9498256,lightgrey:13882323,lightpink:16758465,lightsalmon:16752762,lightseagreen:2142890,lightskyblue:8900346,lightslategray:7833753,lightslategrey:7833753,lightsteelblue:11584734,lightyellow:16777184,lime:65280,limegreen:3329330,linen:16445670,magenta:16711935,maroon:8388608,mediumaquamarine:6737322,mediumblue:205,mediumorchid:12211667,mediumpurple:9662683,mediumseagreen:3978097,mediumslateblue:8087790,mediumspringgreen:64154,mediumturquoise:4772300,mediumvioletred:13047173,midnightblue:1644912,mintcream:16121850,mistyrose:16770273,moccasin:16770229,navajowhite:16768685,navy:128,oldlace:16643558,olive:8421376,olivedrab:7048739,orange:16753920,orangered:16729344,orchid:14315734,palegoldenrod:15657130,palegreen:10025880,paleturquoise:11529966,palevioletred:14381203,papayawhip:16773077,peachpuff:16767673,peru:13468991,pink:16761035,plum:14524637,powderblue:11591910,purple:8388736,rebeccapurple:6697881,red:16711680,rosybrown:12357519,royalblue:4286945,saddlebrown:9127187,salmon:16416882,sandybrown:16032864,seagreen:3050327,seashell:16774638,sienna:10506797,silver:12632256,skyblue:8900331,slateblue:6970061,slategray:7372944,slategrey:7372944,snow:16775930,springgreen:65407,steelblue:4620980,tan:13808780,teal:32896,thistle:14204888,tomato:16737095,turquoise:4251856,violet:15631086,wheat:16113331,white:16777215,whitesmoke:16119285,yellow:16776960,yellowgreen:10145074};Object.assign(et.prototype,{isColor:!0,r:1,g:1,b:1,set:function(t){return t&&t.isColor?this.copy(t):"number"==typeof t?this.setHex(t):"string"==typeof t&&this.setStyle(t),this},setScalar:function(t){return this.r=t,this.g=t,this.b=t,this},setHex:function(t){return t=Math.floor(t),this.r=(t>>16&255)/255,this.g=(t>>8&255)/255,this.b=(255&t)/255,this},setRGB:function(t,e,i){return this.r=t,this.g=e,this.b=i,this},setHSL:function(){function t(t,e,i){return i<0&&(i+=1),i>1&&(i-=1),i<1/6?t+6*(e-t)*i:i<.5?e:i<2/3?t+6*(e-t)*(2/3-i):t}return function(e,i,r){if(e=Ap.euclideanModulo(e,1),i=Ap.clamp(i,0,1),r=Ap.clamp(r,0,1),0===i)this.r=this.g=this.b=r;else{var n=r<=.5?r*(1+i):r+i-r*i,o=2*r-n;this.r=t(o,n,e+1/3),this.g=t(o,n,e),this.b=t(o,n,e-1/3)}return this}}(),setStyle:function(t){function e(e){void 0!==e&&parseFloat(e)<1&&console.warn("THREE.Color: Alpha component of "+t+" will be ignored.")}var i;if(i=/^((?:rgb|hsl)a?)\(\s*([^\)]*)\)/.exec(t)){var r,n=i[1],o=i[2];switch(n){case"rgb":case"rgba":if(r=/^(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*(,\s*([0-9]*\.?[0-9]+)\s*)?$/.exec(o))return this.r=Math.min(255,parseInt(r[1],10))/255,this.g=Math.min(255,parseInt(r[2],10))/255,this.b=Math.min(255,parseInt(r[3],10))/255,e(r[5]),this;if(r=/^(\d+)\%\s*,\s*(\d+)\%\s*,\s*(\d+)\%\s*(,\s*([0-9]*\.?[0-9]+)\s*)?$/.exec(o))return this.r=Math.min(100,parseInt(r[1],10))/100,this.g=Math.min(100,parseInt(r[2],10))/100,this.b=Math.min(100,parseInt(r[3],10))/100,e(r[5]),this;break;case"hsl":case"hsla":if(r=/^([0-9]*\.?[0-9]+)\s*,\s*(\d+)\%\s*,\s*(\d+)\%\s*(,\s*([0-9]*\.?[0-9]+)\s*)?$/.exec(o)){var a=parseFloat(r[1])/360,s=parseInt(r[2],10)/100,c=parseInt(r[3],10)/100;return e(r[5]),this.setHSL(a,s,c)}}}else if(i=/^\#([A-Fa-f0-9]+)$/.exec(t)){var u=(l=i[1]).length;if(3===u)return this.r=parseInt(l.charAt(0)+l.charAt(0),16)/255,this.g=parseInt(l.charAt(1)+l.charAt(1),16)/255,this.b=parseInt(l.charAt(2)+l.charAt(2),16)/255,this;if(6===u)return this.r=parseInt(l.charAt(0)+l.charAt(1),16)/255,this.g=parseInt(l.charAt(2)+l.charAt(3),16)/255,this.b=parseInt(l.charAt(4)+l.charAt(5),16)/255,this}if(t&&t.length>0){var l=Op[t];void 0!==l?this.setHex(l):console.warn("THREE.Color: Unknown color "+t)}return this},clone:function(){return new this.constructor(this.r,this.g,this.b)},copy:function(t){return this.r=t.r,this.g=t.g,this.b=t.b,this},copyGammaToLinear:function(t,e){return void 0===e&&(e=2),this.r=Math.pow(t.r,e),this.g=Math.pow(t.g,e),this.b=Math.pow(t.b,e),this},copyLinearToGamma:function(t,e){void 0===e&&(e=2);var i=e>0?1/e:1;return this.r=Math.pow(t.r,i),this.g=Math.pow(t.g,i),this.b=Math.pow(t.b,i),this},convertGammaToLinear:function(){var t=this.r,e=this.g,i=this.b;return this.r=t*t,this.g=e*e,this.b=i*i,this},convertLinearToGamma:function(){return this.r=Math.sqrt(this.r),this.g=Math.sqrt(this.g),this.b=Math.sqrt(this.b),this},getHex:function(){return 255*this.r<<16^255*this.g<<8^255*this.b<<0},getHexString:function(){return("000000"+this.getHex().toString(16)).slice(-6)},getHSL:function(t){var e,i,r=t||{h:0,s:0,l:0},n=this.r,o=this.g,a=this.b,s=Math.max(n,o,a),c=Math.min(n,o,a),u=(c+s)/2;if(c===s)e=0,i=0;else{var l=s-c;switch(i=u<=.5?l/(s+c):l/(2-s-c),s){case n:e=(o-a)/l+(o<a?6:0);break;case o:e=(a-n)/l+2;break;case a:e=(n-o)/l+4}e/=6}return r.h=e,r.s=i,r.l=u,r},getStyle:function(){return"rgb("+(255*this.r|0)+","+(255*this.g|0)+","+(255*this.b|0)+")"},offsetHSL:function(t,e,i){var r=this.getHSL();return r.h+=t,r.s+=e,r.l+=i,this.setHSL(r.h,r.s,r.l),this},add:function(t){return this.r+=t.r,this.g+=t.g,this.b+=t.b,this},addColors:function(t,e){return this.r=t.r+e.r,this.g=t.g+e.g,this.b=t.b+e.b,this},addScalar:function(t){return this.r+=t,this.g+=t,this.b+=t,this},sub:function(t){return this.r=Math.max(0,this.r-t.r),this.g=Math.max(0,this.g-t.g),this.b=Math.max(0,this.b-t.b),this},multiply:function(t){return this.r*=t.r,this.g*=t.g,this.b*=t.b,this},multiplyScalar:function(t){return this.r*=t,this.g*=t,this.b*=t,this},lerp:function(t,e){return this.r+=(t.r-this.r)*e,this.g+=(t.g-this.g)*e,this.b+=(t.b-this.b)*e,this},equals:function(t){return t.r===this.r&&t.g===this.g&&t.b===this.b},fromArray:function(t,e){return void 0===e&&(e=0),this.r=t[e],this.g=t[e+1],this.b=t[e+2],this},toArray:function(t,e){return void 0===t&&(t=[]),void 0===e&&(e=0),t[e]=this.r,t[e+1]=this.g,t[e+2]=this.b,t},toJSON:function(){return this.getHex()}});var Dp={common:{diffuse:{value:new et(15658734)},opacity:{value:1},map:{value:null},offsetRepeat:{value:new d(0,0,1,1)},alphaMap:{value:null}},specularmap:{specularMap:{value:null}},envmap:{envMap:{value:null},flipEnvMap:{value:-1},reflectivity:{value:1},refractionRatio:{value:.98}},aomap:{aoMap:{value:null},aoMapIntensity:{value:1}},lightmap:{lightMap:{value:null},lightMapIntensity:{value:1}},emissivemap:{emissiveMap:{value:null}},bumpmap:{bumpMap:{value:null},bumpScale:{value:1}},normalmap:{normalMap:{value:null},normalScale:{value:new h(1,1)}},displacementmap:{displacementMap:{value:null},displacementScale:{value:1},displacementBias:{value:0}},roughnessmap:{roughnessMap:{value:null}},metalnessmap:{metalnessMap:{value:null}},gradientmap:{gradientMap:{value:null}},fog:{fogDensity:{value:25e-5},fogNear:{value:1},fogFar:{value:2e3},fogColor:{value:new et(16777215)}},lights:{ambientLightColor:{value:[]},directionalLights:{value:[],properties:{direction:{},color:{},shadow:{},shadowBias:{},shadowRadius:{},shadowMapSize:{}}},directionalShadowMap:{value:[]},directionalShadowMatrix:{value:[]},spotLights:{value:[],properties:{color:{},position:{},direction:{},distance:{},coneCos:{},penumbraCos:{},decay:{},shadow:{},shadowBias:{},shadowRadius:{},shadowMapSize:{}}},spotShadowMap:{value:[]},spotShadowMatrix:{value:[]},pointLights:{value:[],properties:{color:{},position:{},decay:{},distance:{},shadow:{},shadowBias:{},shadowRadius:{},shadowMapSize:{},shadowCameraNear:{},shadowCameraFar:{}}},pointShadowMap:{value:[]},pointShadowMatrix:{value:[]},hemisphereLights:{value:[],properties:{direction:{},skyColor:{},groundColor:{}}},rectAreaLights:{value:[],properties:{color:{},position:{},width:{},height:{}}}},points:{diffuse:{value:new et(15658734)},opacity:{value:1},size:{value:1},scale:{value:1},map:{value:null},offsetRepeat:{value:new d(0,0,1,1)}}},Np={merge:function(t){for(var e=this,i={},r=0;r<t.length;r++){var n=e.clone(t[r]);for(var o in n)i[o]=n[o]}return i},clone:function(t){var e={};for(var i in t){e[i]={};for(var r in t[i]){var n=t[i][r];n&&(n.isColor||n.isMatrix3||n.isMatrix4||n.isVector2||n.isVector3||n.isVector4||n.isTexture)?e[i][r]=n.clone():Array.isArray(n)?e[i][r]=n.slice():e[i][r]=n}}return e}},kp={alphamap_fragment:"#ifdef USE_ALPHAMAP\n\tdiffuseColor.a *= texture2D( alphaMap, vUv ).g;\n#endif\n",alphamap_pars_fragment:"#ifdef USE_ALPHAMAP\n\tuniform sampler2D alphaMap;\n#endif\n",alphatest_fragment:"#ifdef ALPHATEST\n\tif ( diffuseColor.a < ALPHATEST ) discard;\n#endif\n",aomap_fragment:"#ifdef USE_AOMAP\n\tfloat ambientOcclusion = ( texture2D( aoMap, vUv2 ).r - 1.0 ) * aoMapIntensity + 1.0;\n\treflectedLight.indirectDiffuse *= ambientOcclusion;\n\t#if defined( USE_ENVMAP ) && defined( PHYSICAL )\n\t\tfloat dotNV = saturate( dot( geometry.normal, geometry.viewDir ) );\n\t\treflectedLight.indirectSpecular *= computeSpecularOcclusion( dotNV, ambientOcclusion, material.specularRoughness );\n\t#endif\n#endif\n",aomap_pars_fragment:"#ifdef USE_AOMAP\n\tuniform sampler2D aoMap;\n\tuniform float aoMapIntensity;\n#endif",begin_vertex:"\nvec3 transformed = vec3( position );\n",beginnormal_vertex:"\nvec3 objectNormal = vec3( normal );\n",bsdfs:"float punctualLightIntensityToIrradianceFactor( const in float lightDistance, const in float cutoffDistance, const in float decayExponent ) {\n\tif( decayExponent > 0.0 ) {\n#if defined ( PHYSICALLY_CORRECT_LIGHTS )\n\t\tfloat distanceFalloff = 1.0 / max( pow( lightDistance, decayExponent ), 0.01 );\n\t\tfloat maxDistanceCutoffFactor = pow2( saturate( 1.0 - pow4( lightDistance / cutoffDistance ) ) );\n\t\treturn distanceFalloff * maxDistanceCutoffFactor;\n#else\n\t\treturn pow( saturate( -lightDistance / cutoffDistance + 1.0 ), decayExponent );\n#endif\n\t}\n\treturn 1.0;\n}\nvec3 BRDF_Diffuse_Lambert( const in vec3 diffuseColor ) {\n\treturn RECIPROCAL_PI * diffuseColor;\n}\nvec3 F_Schlick( const in vec3 specularColor, const in float dotLH ) {\n\tfloat fresnel = exp2( ( -5.55473 * dotLH - 6.98316 ) * dotLH );\n\treturn ( 1.0 - specularColor ) * fresnel + specularColor;\n}\nfloat G_GGX_Smith( const in float alpha, const in float dotNL, const in float dotNV ) {\n\tfloat a2 = pow2( alpha );\n\tfloat gl = dotNL + sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNL ) );\n\tfloat gv = dotNV + sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNV ) );\n\treturn 1.0 / ( gl * gv );\n}\nfloat G_GGX_SmithCorrelated( const in float alpha, const in float dotNL, const in float dotNV ) {\n\tfloat a2 = pow2( alpha );\n\tfloat gv = dotNL * sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNV ) );\n\tfloat gl = dotNV * sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNL ) );\n\treturn 0.5 / max( gv + gl, EPSILON );\n}\nfloat D_GGX( const in float alpha, const in float dotNH ) {\n\tfloat a2 = pow2( alpha );\n\tfloat denom = pow2( dotNH ) * ( a2 - 1.0 ) + 1.0;\n\treturn RECIPROCAL_PI * a2 / pow2( denom );\n}\nvec3 BRDF_Specular_GGX( const in IncidentLight incidentLight, const in GeometricContext geometry, const in vec3 specularColor, const in float roughness ) {\n\tfloat alpha = pow2( roughness );\n\tvec3 halfDir = normalize( incidentLight.direction + geometry.viewDir );\n\tfloat dotNL = saturate( dot( geometry.normal, incidentLight.direction ) );\n\tfloat dotNV = saturate( dot( geometry.normal, geometry.viewDir ) );\n\tfloat dotNH = saturate( dot( geometry.normal, halfDir ) );\n\tfloat dotLH = saturate( dot( incidentLight.direction, halfDir ) );\n\tvec3 F = F_Schlick( specularColor, dotLH );\n\tfloat G = G_GGX_SmithCorrelated( alpha, dotNL, dotNV );\n\tfloat D = D_GGX( alpha, dotNH );\n\treturn F * ( G * D );\n}\nvec2 LTC_Uv( const in vec3 N, const in vec3 V, const in float roughness ) {\n\tconst float LUT_SIZE  = 64.0;\n\tconst float LUT_SCALE = ( LUT_SIZE - 1.0 ) / LUT_SIZE;\n\tconst float LUT_BIAS  = 0.5 / LUT_SIZE;\n\tfloat theta = acos( dot( N, V ) );\n\tvec2 uv = vec2(\n\t\tsqrt( saturate( roughness ) ),\n\t\tsaturate( theta / ( 0.5 * PI ) ) );\n\tuv = uv * LUT_SCALE + LUT_BIAS;\n\treturn uv;\n}\nfloat LTC_ClippedSphereFormFactor( const in vec3 f ) {\n\tfloat l = length( f );\n\treturn max( ( l * l + f.z ) / ( l + 1.0 ), 0.0 );\n}\nvec3 LTC_EdgeVectorFormFactor( const in vec3 v1, const in vec3 v2 ) {\n\tfloat x = dot( v1, v2 );\n\tfloat y = abs( x );\n\tfloat a = 0.86267 + (0.49788 + 0.01436 * y ) * y;\n\tfloat b = 3.45068 + (4.18814 + y) * y;\n\tfloat v = a / b;\n\tfloat theta_sintheta = (x > 0.0) ? v : 0.5 * inversesqrt( 1.0 - x * x ) - v;\n\treturn cross( v1, v2 ) * theta_sintheta;\n}\nvec3 LTC_Evaluate( const in vec3 N, const in vec3 V, const in vec3 P, const in mat3 mInv, const in vec3 rectCoords[ 4 ] ) {\n\tvec3 v1 = rectCoords[ 1 ] - rectCoords[ 0 ];\n\tvec3 v2 = rectCoords[ 3 ] - rectCoords[ 0 ];\n\tvec3 lightNormal = cross( v1, v2 );\n\tif( dot( lightNormal, P - rectCoords[ 0 ] ) < 0.0 ) return vec3( 0.0 );\n\tvec3 T1, T2;\n\tT1 = normalize( V - N * dot( V, N ) );\n\tT2 = - cross( N, T1 );\n\tmat3 mat = mInv * transpose( mat3( T1, T2, N ) );\n\tvec3 coords[ 4 ];\n\tcoords[ 0 ] = mat * ( rectCoords[ 0 ] - P );\n\tcoords[ 1 ] = mat * ( rectCoords[ 1 ] - P );\n\tcoords[ 2 ] = mat * ( rectCoords[ 2 ] - P );\n\tcoords[ 3 ] = mat * ( rectCoords[ 3 ] - P );\n\tcoords[ 0 ] = normalize( coords[ 0 ] );\n\tcoords[ 1 ] = normalize( coords[ 1 ] );\n\tcoords[ 2 ] = normalize( coords[ 2 ] );\n\tcoords[ 3 ] = normalize( coords[ 3 ] );\n\tvec3 vectorFormFactor = vec3( 0.0 );\n\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 0 ], coords[ 1 ] );\n\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 1 ], coords[ 2 ] );\n\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 2 ], coords[ 3 ] );\n\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 3 ], coords[ 0 ] );\n\tvec3 result = vec3( LTC_ClippedSphereFormFactor( vectorFormFactor ) );\n\treturn result;\n}\nvec3 BRDF_Specular_GGX_Environment( const in GeometricContext geometry, const in vec3 specularColor, const in float roughness ) {\n\tfloat dotNV = saturate( dot( geometry.normal, geometry.viewDir ) );\n\tconst vec4 c0 = vec4( - 1, - 0.0275, - 0.572, 0.022 );\n\tconst vec4 c1 = vec4( 1, 0.0425, 1.04, - 0.04 );\n\tvec4 r = roughness * c0 + c1;\n\tfloat a004 = min( r.x * r.x, exp2( - 9.28 * dotNV ) ) * r.x + r.y;\n\tvec2 AB = vec2( -1.04, 1.04 ) * a004 + r.zw;\n\treturn specularColor * AB.x + AB.y;\n}\nfloat G_BlinnPhong_Implicit( ) {\n\treturn 0.25;\n}\nfloat D_BlinnPhong( const in float shininess, const in float dotNH ) {\n\treturn RECIPROCAL_PI * ( shininess * 0.5 + 1.0 ) * pow( dotNH, shininess );\n}\nvec3 BRDF_Specular_BlinnPhong( const in IncidentLight incidentLight, const in GeometricContext geometry, const in vec3 specularColor, const in float shininess ) {\n\tvec3 halfDir = normalize( incidentLight.direction + geometry.viewDir );\n\tfloat dotNH = saturate( dot( geometry.normal, halfDir ) );\n\tfloat dotLH = saturate( dot( incidentLight.direction, halfDir ) );\n\tvec3 F = F_Schlick( specularColor, dotLH );\n\tfloat G = G_BlinnPhong_Implicit( );\n\tfloat D = D_BlinnPhong( shininess, dotNH );\n\treturn F * ( G * D );\n}\nfloat GGXRoughnessToBlinnExponent( const in float ggxRoughness ) {\n\treturn ( 2.0 / pow2( ggxRoughness + 0.0001 ) - 2.0 );\n}\nfloat BlinnExponentToGGXRoughness( const in float blinnExponent ) {\n\treturn sqrt( 2.0 / ( blinnExponent + 2.0 ) );\n}\n",bumpmap_pars_fragment:"#ifdef USE_BUMPMAP\n\tuniform sampler2D bumpMap;\n\tuniform float bumpScale;\n\tvec2 dHdxy_fwd() {\n\t\tvec2 dSTdx = dFdx( vUv );\n\t\tvec2 dSTdy = dFdy( vUv );\n\t\tfloat Hll = bumpScale * texture2D( bumpMap, vUv ).x;\n\t\tfloat dBx = bumpScale * texture2D( bumpMap, vUv + dSTdx ).x - Hll;\n\t\tfloat dBy = bumpScale * texture2D( bumpMap, vUv + dSTdy ).x - Hll;\n\t\treturn vec2( dBx, dBy );\n\t}\n\tvec3 perturbNormalArb( vec3 surf_pos, vec3 surf_norm, vec2 dHdxy ) {\n\t\tvec3 vSigmaX = vec3( dFdx( surf_pos.x ), dFdx( surf_pos.y ), dFdx( surf_pos.z ) );\n\t\tvec3 vSigmaY = vec3( dFdy( surf_pos.x ), dFdy( surf_pos.y ), dFdy( surf_pos.z ) );\n\t\tvec3 vN = surf_norm;\n\t\tvec3 R1 = cross( vSigmaY, vN );\n\t\tvec3 R2 = cross( vN, vSigmaX );\n\t\tfloat fDet = dot( vSigmaX, R1 );\n\t\tvec3 vGrad = sign( fDet ) * ( dHdxy.x * R1 + dHdxy.y * R2 );\n\t\treturn normalize( abs( fDet ) * surf_norm - vGrad );\n\t}\n#endif\n",clipping_planes_fragment:"#if NUM_CLIPPING_PLANES > 0\n\tfor ( int i = 0; i < UNION_CLIPPING_PLANES; ++ i ) {\n\t\tvec4 plane = clippingPlanes[ i ];\n\t\tif ( dot( vViewPosition, plane.xyz ) > plane.w ) discard;\n\t}\n\t\t\n\t#if UNION_CLIPPING_PLANES < NUM_CLIPPING_PLANES\n\t\tbool clipped = true;\n\t\tfor ( int i = UNION_CLIPPING_PLANES; i < NUM_CLIPPING_PLANES; ++ i ) {\n\t\t\tvec4 plane = clippingPlanes[ i ];\n\t\t\tclipped = ( dot( vViewPosition, plane.xyz ) > plane.w ) && clipped;\n\t\t}\n\t\tif ( clipped ) discard;\n\t\n\t#endif\n#endif\n",clipping_planes_pars_fragment:"#if NUM_CLIPPING_PLANES > 0\n\t#if ! defined( PHYSICAL ) && ! defined( PHONG )\n\t\tvarying vec3 vViewPosition;\n\t#endif\n\tuniform vec4 clippingPlanes[ NUM_CLIPPING_PLANES ];\n#endif\n",clipping_planes_pars_vertex:"#if NUM_CLIPPING_PLANES > 0 && ! defined( PHYSICAL ) && ! defined( PHONG )\n\tvarying vec3 vViewPosition;\n#endif\n",clipping_planes_vertex:"#if NUM_CLIPPING_PLANES > 0 && ! defined( PHYSICAL ) && ! defined( PHONG )\n\tvViewPosition = - mvPosition.xyz;\n#endif\n",color_fragment:"#ifdef USE_COLOR\n\tdiffuseColor.rgb *= vColor;\n#endif",color_pars_fragment:"#ifdef USE_COLOR\n\tvarying vec3 vColor;\n#endif\n",color_pars_vertex:"#ifdef USE_COLOR\n\tvarying vec3 vColor;\n#endif",color_vertex:"#ifdef USE_COLOR\n\tvColor.xyz = color.xyz;\n#endif",common:"#define PI 3.14159265359\n#define PI2 6.28318530718\n#define PI_HALF 1.5707963267949\n#define RECIPROCAL_PI 0.31830988618\n#define RECIPROCAL_PI2 0.15915494\n#define LOG2 1.442695\n#define EPSILON 1e-6\n#define saturate(a) clamp( a, 0.0, 1.0 )\n#define whiteCompliment(a) ( 1.0 - saturate( a ) )\nfloat pow2( const in float x ) { return x*x; }\nfloat pow3( const in float x ) { return x*x*x; }\nfloat pow4( const in float x ) { float x2 = x*x; return x2*x2; }\nfloat average( const in vec3 color ) { return dot( color, vec3( 0.3333 ) ); }\nhighp float rand( const in vec2 uv ) {\n\tconst highp float a = 12.9898, b = 78.233, c = 43758.5453;\n\thighp float dt = dot( uv.xy, vec2( a,b ) ), sn = mod( dt, PI );\n\treturn fract(sin(sn) * c);\n}\nstruct IncidentLight {\n\tvec3 color;\n\tvec3 direction;\n\tbool visible;\n};\nstruct ReflectedLight {\n\tvec3 directDiffuse;\n\tvec3 directSpecular;\n\tvec3 indirectDiffuse;\n\tvec3 indirectSpecular;\n};\nstruct GeometricContext {\n\tvec3 position;\n\tvec3 normal;\n\tvec3 viewDir;\n};\nvec3 transformDirection( in vec3 dir, in mat4 matrix ) {\n\treturn normalize( ( matrix * vec4( dir, 0.0 ) ).xyz );\n}\nvec3 inverseTransformDirection( in vec3 dir, in mat4 matrix ) {\n\treturn normalize( ( vec4( dir, 0.0 ) * matrix ).xyz );\n}\nvec3 projectOnPlane(in vec3 point, in vec3 pointOnPlane, in vec3 planeNormal ) {\n\tfloat distance = dot( planeNormal, point - pointOnPlane );\n\treturn - distance * planeNormal + point;\n}\nfloat sideOfPlane( in vec3 point, in vec3 pointOnPlane, in vec3 planeNormal ) {\n\treturn sign( dot( point - pointOnPlane, planeNormal ) );\n}\nvec3 linePlaneIntersect( in vec3 pointOnLine, in vec3 lineDirection, in vec3 pointOnPlane, in vec3 planeNormal ) {\n\treturn lineDirection * ( dot( planeNormal, pointOnPlane - pointOnLine ) / dot( planeNormal, lineDirection ) ) + pointOnLine;\n}\nmat3 transpose( const in mat3 v ) {\n\tmat3 tmp;\n\ttmp[0] = vec3(v[0].x, v[1].x, v[2].x);\n\ttmp[1] = vec3(v[0].y, v[1].y, v[2].y);\n\ttmp[2] = vec3(v[0].z, v[1].z, v[2].z);\n\treturn tmp;\n}\n",cube_uv_reflection_fragment:"#ifdef ENVMAP_TYPE_CUBE_UV\n#define cubeUV_textureSize (1024.0)\nint getFaceFromDirection(vec3 direction) {\n\tvec3 absDirection = abs(direction);\n\tint face = -1;\n\tif( absDirection.x > absDirection.z ) {\n\t\tif(absDirection.x > absDirection.y )\n\t\t\tface = direction.x > 0.0 ? 0 : 3;\n\t\telse\n\t\t\tface = direction.y > 0.0 ? 1 : 4;\n\t}\n\telse {\n\t\tif(absDirection.z > absDirection.y )\n\t\t\tface = direction.z > 0.0 ? 2 : 5;\n\t\telse\n\t\t\tface = direction.y > 0.0 ? 1 : 4;\n\t}\n\treturn face;\n}\n#define cubeUV_maxLods1  (log2(cubeUV_textureSize*0.25) - 1.0)\n#define cubeUV_rangeClamp (exp2((6.0 - 1.0) * 2.0))\nvec2 MipLevelInfo( vec3 vec, float roughnessLevel, float roughness ) {\n\tfloat scale = exp2(cubeUV_maxLods1 - roughnessLevel);\n\tfloat dxRoughness = dFdx(roughness);\n\tfloat dyRoughness = dFdy(roughness);\n\tvec3 dx = dFdx( vec * scale * dxRoughness );\n\tvec3 dy = dFdy( vec * scale * dyRoughness );\n\tfloat d = max( dot( dx, dx ), dot( dy, dy ) );\n\td = clamp(d, 1.0, cubeUV_rangeClamp);\n\tfloat mipLevel = 0.5 * log2(d);\n\treturn vec2(floor(mipLevel), fract(mipLevel));\n}\n#define cubeUV_maxLods2 (log2(cubeUV_textureSize*0.25) - 2.0)\n#define cubeUV_rcpTextureSize (1.0 / cubeUV_textureSize)\nvec2 getCubeUV(vec3 direction, float roughnessLevel, float mipLevel) {\n\tmipLevel = roughnessLevel > cubeUV_maxLods2 - 3.0 ? 0.0 : mipLevel;\n\tfloat a = 16.0 * cubeUV_rcpTextureSize;\n\tvec2 exp2_packed = exp2( vec2( roughnessLevel, mipLevel ) );\n\tvec2 rcp_exp2_packed = vec2( 1.0 ) / exp2_packed;\n\tfloat powScale = exp2_packed.x * exp2_packed.y;\n\tfloat scale = rcp_exp2_packed.x * rcp_exp2_packed.y * 0.25;\n\tfloat mipOffset = 0.75*(1.0 - rcp_exp2_packed.y) * rcp_exp2_packed.x;\n\tbool bRes = mipLevel == 0.0;\n\tscale =  bRes && (scale < a) ? a : scale;\n\tvec3 r;\n\tvec2 offset;\n\tint face = getFaceFromDirection(direction);\n\tfloat rcpPowScale = 1.0 / powScale;\n\tif( face == 0) {\n\t\tr = vec3(direction.x, -direction.z, direction.y);\n\t\toffset = vec2(0.0+mipOffset,0.75 * rcpPowScale);\n\t\toffset.y = bRes && (offset.y < 2.0*a) ? a : offset.y;\n\t}\n\telse if( face == 1) {\n\t\tr = vec3(direction.y, direction.x, direction.z);\n\t\toffset = vec2(scale+mipOffset, 0.75 * rcpPowScale);\n\t\toffset.y = bRes && (offset.y < 2.0*a) ? a : offset.y;\n\t}\n\telse if( face == 2) {\n\t\tr = vec3(direction.z, direction.x, direction.y);\n\t\toffset = vec2(2.0*scale+mipOffset, 0.75 * rcpPowScale);\n\t\toffset.y = bRes && (offset.y < 2.0*a) ? a : offset.y;\n\t}\n\telse if( face == 3) {\n\t\tr = vec3(direction.x, direction.z, direction.y);\n\t\toffset = vec2(0.0+mipOffset,0.5 * rcpPowScale);\n\t\toffset.y = bRes && (offset.y < 2.0*a) ? 0.0 : offset.y;\n\t}\n\telse if( face == 4) {\n\t\tr = vec3(direction.y, direction.x, -direction.z);\n\t\toffset = vec2(scale+mipOffset, 0.5 * rcpPowScale);\n\t\toffset.y = bRes && (offset.y < 2.0*a) ? 0.0 : offset.y;\n\t}\n\telse {\n\t\tr = vec3(direction.z, -direction.x, direction.y);\n\t\toffset = vec2(2.0*scale+mipOffset, 0.5 * rcpPowScale);\n\t\toffset.y = bRes && (offset.y < 2.0*a) ? 0.0 : offset.y;\n\t}\n\tr = normalize(r);\n\tfloat texelOffset = 0.5 * cubeUV_rcpTextureSize;\n\tvec2 s = ( r.yz / abs( r.x ) + vec2( 1.0 ) ) * 0.5;\n\tvec2 base = offset + vec2( texelOffset );\n\treturn base + s * ( scale - 2.0 * texelOffset );\n}\n#define cubeUV_maxLods3 (log2(cubeUV_textureSize*0.25) - 3.0)\nvec4 textureCubeUV(vec3 reflectedDirection, float roughness ) {\n\tfloat roughnessVal = roughness* cubeUV_maxLods3;\n\tfloat r1 = floor(roughnessVal);\n\tfloat r2 = r1 + 1.0;\n\tfloat t = fract(roughnessVal);\n\tvec2 mipInfo = MipLevelInfo(reflectedDirection, r1, roughness);\n\tfloat s = mipInfo.y;\n\tfloat level0 = mipInfo.x;\n\tfloat level1 = level0 + 1.0;\n\tlevel1 = level1 > 5.0 ? 5.0 : level1;\n\tlevel0 += min( floor( s + 0.5 ), 5.0 );\n\tvec2 uv_10 = getCubeUV(reflectedDirection, r1, level0);\n\tvec4 color10 = envMapTexelToLinear(texture2D(envMap, uv_10));\n\tvec2 uv_20 = getCubeUV(reflectedDirection, r2, level0);\n\tvec4 color20 = envMapTexelToLinear(texture2D(envMap, uv_20));\n\tvec4 result = mix(color10, color20, t);\n\treturn vec4(result.rgb, 1.0);\n}\n#endif\n",defaultnormal_vertex:"vec3 transformedNormal = normalMatrix * objectNormal;\n#ifdef FLIP_SIDED\n\ttransformedNormal = - transformedNormal;\n#endif\n",displacementmap_pars_vertex:"#ifdef USE_DISPLACEMENTMAP\n\tuniform sampler2D displacementMap;\n\tuniform float displacementScale;\n\tuniform float displacementBias;\n#endif\n",displacementmap_vertex:"#ifdef USE_DISPLACEMENTMAP\n\ttransformed += normalize( objectNormal ) * ( texture2D( displacementMap, uv ).x * displacementScale + displacementBias );\n#endif\n",emissivemap_fragment:"#ifdef USE_EMISSIVEMAP\n\tvec4 emissiveColor = texture2D( emissiveMap, vUv );\n\temissiveColor.rgb = emissiveMapTexelToLinear( emissiveColor ).rgb;\n\ttotalEmissiveRadiance *= emissiveColor.rgb;\n#endif\n",emissivemap_pars_fragment:"#ifdef USE_EMISSIVEMAP\n\tuniform sampler2D emissiveMap;\n#endif\n",encodings_fragment:"  gl_FragColor = linearToOutputTexel( gl_FragColor );\n",encodings_pars_fragment:"\nvec4 LinearToLinear( in vec4 value ) {\n\treturn value;\n}\nvec4 GammaToLinear( in vec4 value, in float gammaFactor ) {\n\treturn vec4( pow( value.xyz, vec3( gammaFactor ) ), value.w );\n}\nvec4 LinearToGamma( in vec4 value, in float gammaFactor ) {\n\treturn vec4( pow( value.xyz, vec3( 1.0 / gammaFactor ) ), value.w );\n}\nvec4 sRGBToLinear( in vec4 value ) {\n\treturn vec4( mix( pow( value.rgb * 0.9478672986 + vec3( 0.0521327014 ), vec3( 2.4 ) ), value.rgb * 0.0773993808, vec3( lessThanEqual( value.rgb, vec3( 0.04045 ) ) ) ), value.w );\n}\nvec4 LinearTosRGB( in vec4 value ) {\n\treturn vec4( mix( pow( value.rgb, vec3( 0.41666 ) ) * 1.055 - vec3( 0.055 ), value.rgb * 12.92, vec3( lessThanEqual( value.rgb, vec3( 0.0031308 ) ) ) ), value.w );\n}\nvec4 RGBEToLinear( in vec4 value ) {\n\treturn vec4( value.rgb * exp2( value.a * 255.0 - 128.0 ), 1.0 );\n}\nvec4 LinearToRGBE( in vec4 value ) {\n\tfloat maxComponent = max( max( value.r, value.g ), value.b );\n\tfloat fExp = clamp( ceil( log2( maxComponent ) ), -128.0, 127.0 );\n\treturn vec4( value.rgb / exp2( fExp ), ( fExp + 128.0 ) / 255.0 );\n}\nvec4 RGBMToLinear( in vec4 value, in float maxRange ) {\n\treturn vec4( value.xyz * value.w * maxRange, 1.0 );\n}\nvec4 LinearToRGBM( in vec4 value, in float maxRange ) {\n\tfloat maxRGB = max( value.x, max( value.g, value.b ) );\n\tfloat M      = clamp( maxRGB / maxRange, 0.0, 1.0 );\n\tM            = ceil( M * 255.0 ) / 255.0;\n\treturn vec4( value.rgb / ( M * maxRange ), M );\n}\nvec4 RGBDToLinear( in vec4 value, in float maxRange ) {\n\treturn vec4( value.rgb * ( ( maxRange / 255.0 ) / value.a ), 1.0 );\n}\nvec4 LinearToRGBD( in vec4 value, in float maxRange ) {\n\tfloat maxRGB = max( value.x, max( value.g, value.b ) );\n\tfloat D      = max( maxRange / maxRGB, 1.0 );\n\tD            = min( floor( D ) / 255.0, 1.0 );\n\treturn vec4( value.rgb * ( D * ( 255.0 / maxRange ) ), D );\n}\nconst mat3 cLogLuvM = mat3( 0.2209, 0.3390, 0.4184, 0.1138, 0.6780, 0.7319, 0.0102, 0.1130, 0.2969 );\nvec4 LinearToLogLuv( in vec4 value )  {\n\tvec3 Xp_Y_XYZp = value.rgb * cLogLuvM;\n\tXp_Y_XYZp = max(Xp_Y_XYZp, vec3(1e-6, 1e-6, 1e-6));\n\tvec4 vResult;\n\tvResult.xy = Xp_Y_XYZp.xy / Xp_Y_XYZp.z;\n\tfloat Le = 2.0 * log2(Xp_Y_XYZp.y) + 127.0;\n\tvResult.w = fract(Le);\n\tvResult.z = (Le - (floor(vResult.w*255.0))/255.0)/255.0;\n\treturn vResult;\n}\nconst mat3 cLogLuvInverseM = mat3( 6.0014, -2.7008, -1.7996, -1.3320, 3.1029, -5.7721, 0.3008, -1.0882, 5.6268 );\nvec4 LogLuvToLinear( in vec4 value ) {\n\tfloat Le = value.z * 255.0 + value.w;\n\tvec3 Xp_Y_XYZp;\n\tXp_Y_XYZp.y = exp2((Le - 127.0) / 2.0);\n\tXp_Y_XYZp.z = Xp_Y_XYZp.y / value.y;\n\tXp_Y_XYZp.x = value.x * Xp_Y_XYZp.z;\n\tvec3 vRGB = Xp_Y_XYZp.rgb * cLogLuvInverseM;\n\treturn vec4( max(vRGB, 0.0), 1.0 );\n}\n",envmap_fragment:"#ifdef USE_ENVMAP\n\t#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG )\n\t\tvec3 cameraToVertex = normalize( vWorldPosition - cameraPosition );\n\t\tvec3 worldNormal = inverseTransformDirection( normal, viewMatrix );\n\t\t#ifdef ENVMAP_MODE_REFLECTION\n\t\t\tvec3 reflectVec = reflect( cameraToVertex, worldNormal );\n\t\t#else\n\t\t\tvec3 reflectVec = refract( cameraToVertex, worldNormal, refractionRatio );\n\t\t#endif\n\t#else\n\t\tvec3 reflectVec = vReflect;\n\t#endif\n\t#ifdef ENVMAP_TYPE_CUBE\n\t\tvec4 envColor = textureCube( envMap, vec3( flipEnvMap * reflectVec.x, reflectVec.yz ) );\n\t#elif defined( ENVMAP_TYPE_EQUIREC )\n\t\tvec2 sampleUV;\n\t\treflectVec = normalize( reflectVec );\n\t\tsampleUV.y = asin( clamp( reflectVec.y, - 1.0, 1.0 ) ) * RECIPROCAL_PI + 0.5;\n\t\tsampleUV.x = atan( reflectVec.z, reflectVec.x ) * RECIPROCAL_PI2 + 0.5;\n\t\tvec4 envColor = texture2D( envMap, sampleUV );\n\t#elif defined( ENVMAP_TYPE_SPHERE )\n\t\treflectVec = normalize( reflectVec );\n\t\tvec3 reflectView = normalize( ( viewMatrix * vec4( reflectVec, 0.0 ) ).xyz + vec3( 0.0, 0.0, 1.0 ) );\n\t\tvec4 envColor = texture2D( envMap, reflectView.xy * 0.5 + 0.5 );\n\t#else\n\t\tvec4 envColor = vec4( 0.0 );\n\t#endif\n\tenvColor = envMapTexelToLinear( envColor );\n\t#ifdef ENVMAP_BLENDING_MULTIPLY\n\t\toutgoingLight = mix( outgoingLight, outgoingLight * envColor.xyz, specularStrength * reflectivity );\n\t#elif defined( ENVMAP_BLENDING_MIX )\n\t\toutgoingLight = mix( outgoingLight, envColor.xyz, specularStrength * reflectivity );\n\t#elif defined( ENVMAP_BLENDING_ADD )\n\t\toutgoingLight += envColor.xyz * specularStrength * reflectivity;\n\t#endif\n#endif\n",envmap_pars_fragment:"#if defined( USE_ENVMAP ) || defined( PHYSICAL )\n\tuniform float reflectivity;\n\tuniform float envMapIntensity;\n#endif\n#ifdef USE_ENVMAP\n\t#if ! defined( PHYSICAL ) && ( defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG ) )\n\t\tvarying vec3 vWorldPosition;\n\t#endif\n\t#ifdef ENVMAP_TYPE_CUBE\n\t\tuniform samplerCube envMap;\n\t#else\n\t\tuniform sampler2D envMap;\n\t#endif\n\tuniform float flipEnvMap;\n\t#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG ) || defined( PHYSICAL )\n\t\tuniform float refractionRatio;\n\t#else\n\t\tvarying vec3 vReflect;\n\t#endif\n#endif\n",envmap_pars_vertex:"#ifdef USE_ENVMAP\n\t#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG )\n\t\tvarying vec3 vWorldPosition;\n\t#else\n\t\tvarying vec3 vReflect;\n\t\tuniform float refractionRatio;\n\t#endif\n#endif\n",envmap_vertex:"#ifdef USE_ENVMAP\n\t#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG )\n\t\tvWorldPosition = worldPosition.xyz;\n\t#else\n\t\tvec3 cameraToVertex = normalize( worldPosition.xyz - cameraPosition );\n\t\tvec3 worldNormal = inverseTransformDirection( transformedNormal, viewMatrix );\n\t\t#ifdef ENVMAP_MODE_REFLECTION\n\t\t\tvReflect = reflect( cameraToVertex, worldNormal );\n\t\t#else\n\t\t\tvReflect = refract( cameraToVertex, worldNormal, refractionRatio );\n\t\t#endif\n\t#endif\n#endif\n",fog_vertex:"\n#ifdef USE_FOG\nfogDepth = -mvPosition.z;\n#endif",fog_pars_vertex:"#ifdef USE_FOG\n  varying float fogDepth;\n#endif\n",fog_fragment:"#ifdef USE_FOG\n\t#ifdef FOG_EXP2\n\t\tfloat fogFactor = whiteCompliment( exp2( - fogDensity * fogDensity * fogDepth * fogDepth * LOG2 ) );\n\t#else\n\t\tfloat fogFactor = smoothstep( fogNear, fogFar, fogDepth );\n\t#endif\n\tgl_FragColor.rgb = mix( gl_FragColor.rgb, fogColor, fogFactor );\n#endif\n",fog_pars_fragment:"#ifdef USE_FOG\n\tuniform vec3 fogColor;\n\tvarying float fogDepth;\n\t#ifdef FOG_EXP2\n\t\tuniform float fogDensity;\n\t#else\n\t\tuniform float fogNear;\n\t\tuniform float fogFar;\n\t#endif\n#endif\n",gradientmap_pars_fragment:"#ifdef TOON\n\tuniform sampler2D gradientMap;\n\tvec3 getGradientIrradiance( vec3 normal, vec3 lightDirection ) {\n\t\tfloat dotNL = dot( normal, lightDirection );\n\t\tvec2 coord = vec2( dotNL * 0.5 + 0.5, 0.0 );\n\t\t#ifdef USE_GRADIENTMAP\n\t\t\treturn texture2D( gradientMap, coord ).rgb;\n\t\t#else\n\t\t\treturn ( coord.x < 0.7 ) ? vec3( 0.7 ) : vec3( 1.0 );\n\t\t#endif\n\t}\n#endif\n",lightmap_fragment:"#ifdef USE_LIGHTMAP\n\treflectedLight.indirectDiffuse += PI * texture2D( lightMap, vUv2 ).xyz * lightMapIntensity;\n#endif\n",lightmap_pars_fragment:"#ifdef USE_LIGHTMAP\n\tuniform sampler2D lightMap;\n\tuniform float lightMapIntensity;\n#endif",lights_lambert_vertex:"vec3 diffuse = vec3( 1.0 );\nGeometricContext geometry;\ngeometry.position = mvPosition.xyz;\ngeometry.normal = normalize( transformedNormal );\ngeometry.viewDir = normalize( -mvPosition.xyz );\nGeometricContext backGeometry;\nbackGeometry.position = geometry.position;\nbackGeometry.normal = -geometry.normal;\nbackGeometry.viewDir = geometry.viewDir;\nvLightFront = vec3( 0.0 );\n#ifdef DOUBLE_SIDED\n\tvLightBack = vec3( 0.0 );\n#endif\nIncidentLight directLight;\nfloat dotNL;\nvec3 directLightColor_Diffuse;\n#if NUM_POINT_LIGHTS > 0\n\tfor ( int i = 0; i < NUM_POINT_LIGHTS; i ++ ) {\n\t\tgetPointDirectLightIrradiance( pointLights[ i ], geometry, directLight );\n\t\tdotNL = dot( geometry.normal, directLight.direction );\n\t\tdirectLightColor_Diffuse = PI * directLight.color;\n\t\tvLightFront += saturate( dotNL ) * directLightColor_Diffuse;\n\t\t#ifdef DOUBLE_SIDED\n\t\t\tvLightBack += saturate( -dotNL ) * directLightColor_Diffuse;\n\t\t#endif\n\t}\n#endif\n#if NUM_SPOT_LIGHTS > 0\n\tfor ( int i = 0; i < NUM_SPOT_LIGHTS; i ++ ) {\n\t\tgetSpotDirectLightIrradiance( spotLights[ i ], geometry, directLight );\n\t\tdotNL = dot( geometry.normal, directLight.direction );\n\t\tdirectLightColor_Diffuse = PI * directLight.color;\n\t\tvLightFront += saturate( dotNL ) * directLightColor_Diffuse;\n\t\t#ifdef DOUBLE_SIDED\n\t\t\tvLightBack += saturate( -dotNL ) * directLightColor_Diffuse;\n\t\t#endif\n\t}\n#endif\n#if NUM_DIR_LIGHTS > 0\n\tfor ( int i = 0; i < NUM_DIR_LIGHTS; i ++ ) {\n\t\tgetDirectionalDirectLightIrradiance( directionalLights[ i ], geometry, directLight );\n\t\tdotNL = dot( geometry.normal, directLight.direction );\n\t\tdirectLightColor_Diffuse = PI * directLight.color;\n\t\tvLightFront += saturate( dotNL ) * directLightColor_Diffuse;\n\t\t#ifdef DOUBLE_SIDED\n\t\t\tvLightBack += saturate( -dotNL ) * directLightColor_Diffuse;\n\t\t#endif\n\t}\n#endif\n#if NUM_HEMI_LIGHTS > 0\n\tfor ( int i = 0; i < NUM_HEMI_LIGHTS; i ++ ) {\n\t\tvLightFront += getHemisphereLightIrradiance( hemisphereLights[ i ], geometry );\n\t\t#ifdef DOUBLE_SIDED\n\t\t\tvLightBack += getHemisphereLightIrradiance( hemisphereLights[ i ], backGeometry );\n\t\t#endif\n\t}\n#endif\n",lights_pars:"uniform vec3 ambientLightColor;\nvec3 getAmbientLightIrradiance( const in vec3 ambientLightColor ) {\n\tvec3 irradiance = ambientLightColor;\n\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\tirradiance *= PI;\n\t#endif\n\treturn irradiance;\n}\n#if NUM_DIR_LIGHTS > 0\n\tstruct DirectionalLight {\n\t\tvec3 direction;\n\t\tvec3 color;\n\t\tint shadow;\n\t\tfloat shadowBias;\n\t\tfloat shadowRadius;\n\t\tvec2 shadowMapSize;\n\t};\n\tuniform DirectionalLight directionalLights[ NUM_DIR_LIGHTS ];\n\tvoid getDirectionalDirectLightIrradiance( const in DirectionalLight directionalLight, const in GeometricContext geometry, out IncidentLight directLight ) {\n\t\tdirectLight.color = directionalLight.color;\n\t\tdirectLight.direction = directionalLight.direction;\n\t\tdirectLight.visible = true;\n\t}\n#endif\n#if NUM_POINT_LIGHTS > 0\n\tstruct PointLight {\n\t\tvec3 position;\n\t\tvec3 color;\n\t\tfloat distance;\n\t\tfloat decay;\n\t\tint shadow;\n\t\tfloat shadowBias;\n\t\tfloat shadowRadius;\n\t\tvec2 shadowMapSize;\n\t\tfloat shadowCameraNear;\n\t\tfloat shadowCameraFar;\n\t};\n\tuniform PointLight pointLights[ NUM_POINT_LIGHTS ];\n\tvoid getPointDirectLightIrradiance( const in PointLight pointLight, const in GeometricContext geometry, out IncidentLight directLight ) {\n\t\tvec3 lVector = pointLight.position - geometry.position;\n\t\tdirectLight.direction = normalize( lVector );\n\t\tfloat lightDistance = length( lVector );\n\t\tdirectLight.color = pointLight.color;\n\t\tdirectLight.color *= punctualLightIntensityToIrradianceFactor( lightDistance, pointLight.distance, pointLight.decay );\n\t\tdirectLight.visible = ( directLight.color != vec3( 0.0 ) );\n\t}\n#endif\n#if NUM_SPOT_LIGHTS > 0\n\tstruct SpotLight {\n\t\tvec3 position;\n\t\tvec3 direction;\n\t\tvec3 color;\n\t\tfloat distance;\n\t\tfloat decay;\n\t\tfloat coneCos;\n\t\tfloat penumbraCos;\n\t\tint shadow;\n\t\tfloat shadowBias;\n\t\tfloat shadowRadius;\n\t\tvec2 shadowMapSize;\n\t};\n\tuniform SpotLight spotLights[ NUM_SPOT_LIGHTS ];\n\tvoid getSpotDirectLightIrradiance( const in SpotLight spotLight, const in GeometricContext geometry, out IncidentLight directLight  ) {\n\t\tvec3 lVector = spotLight.position - geometry.position;\n\t\tdirectLight.direction = normalize( lVector );\n\t\tfloat lightDistance = length( lVector );\n\t\tfloat angleCos = dot( directLight.direction, spotLight.direction );\n\t\tif ( angleCos > spotLight.coneCos ) {\n\t\t\tfloat spotEffect = smoothstep( spotLight.coneCos, spotLight.penumbraCos, angleCos );\n\t\t\tdirectLight.color = spotLight.color;\n\t\t\tdirectLight.color *= spotEffect * punctualLightIntensityToIrradianceFactor( lightDistance, spotLight.distance, spotLight.decay );\n\t\t\tdirectLight.visible = true;\n\t\t} else {\n\t\t\tdirectLight.color = vec3( 0.0 );\n\t\t\tdirectLight.visible = false;\n\t\t}\n\t}\n#endif\n#if NUM_RECT_AREA_LIGHTS > 0\n\tstruct RectAreaLight {\n\t\tvec3 color;\n\t\tvec3 position;\n\t\tvec3 halfWidth;\n\t\tvec3 halfHeight;\n\t};\n\tuniform sampler2D ltcMat;\tuniform sampler2D ltcMag;\n\tuniform RectAreaLight rectAreaLights[ NUM_RECT_AREA_LIGHTS ];\n#endif\n#if NUM_HEMI_LIGHTS > 0\n\tstruct HemisphereLight {\n\t\tvec3 direction;\n\t\tvec3 skyColor;\n\t\tvec3 groundColor;\n\t};\n\tuniform HemisphereLight hemisphereLights[ NUM_HEMI_LIGHTS ];\n\tvec3 getHemisphereLightIrradiance( const in HemisphereLight hemiLight, const in GeometricContext geometry ) {\n\t\tfloat dotNL = dot( geometry.normal, hemiLight.direction );\n\t\tfloat hemiDiffuseWeight = 0.5 * dotNL + 0.5;\n\t\tvec3 irradiance = mix( hemiLight.groundColor, hemiLight.skyColor, hemiDiffuseWeight );\n\t\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\t\tirradiance *= PI;\n\t\t#endif\n\t\treturn irradiance;\n\t}\n#endif\n#if defined( USE_ENVMAP ) && defined( PHYSICAL )\n\tvec3 getLightProbeIndirectIrradiance( const in GeometricContext geometry, const in int maxMIPLevel ) {\n\t\tvec3 worldNormal = inverseTransformDirection( geometry.normal, viewMatrix );\n\t\t#ifdef ENVMAP_TYPE_CUBE\n\t\t\tvec3 queryVec = vec3( flipEnvMap * worldNormal.x, worldNormal.yz );\n\t\t\t#ifdef TEXTURE_LOD_EXT\n\t\t\t\tvec4 envMapColor = textureCubeLodEXT( envMap, queryVec, float( maxMIPLevel ) );\n\t\t\t#else\n\t\t\t\tvec4 envMapColor = textureCube( envMap, queryVec, float( maxMIPLevel ) );\n\t\t\t#endif\n\t\t\tenvMapColor.rgb = envMapTexelToLinear( envMapColor ).rgb;\n\t\t#elif defined( ENVMAP_TYPE_CUBE_UV )\n\t\t\tvec3 queryVec = vec3( flipEnvMap * worldNormal.x, worldNormal.yz );\n\t\t\tvec4 envMapColor = textureCubeUV( queryVec, 1.0 );\n\t\t#else\n\t\t\tvec4 envMapColor = vec4( 0.0 );\n\t\t#endif\n\t\treturn PI * envMapColor.rgb * envMapIntensity;\n\t}\n\tfloat getSpecularMIPLevel( const in float blinnShininessExponent, const in int maxMIPLevel ) {\n\t\tfloat maxMIPLevelScalar = float( maxMIPLevel );\n\t\tfloat desiredMIPLevel = maxMIPLevelScalar - 0.79248 - 0.5 * log2( pow2( blinnShininessExponent ) + 1.0 );\n\t\treturn clamp( desiredMIPLevel, 0.0, maxMIPLevelScalar );\n\t}\n\tvec3 getLightProbeIndirectRadiance( const in GeometricContext geometry, const in float blinnShininessExponent, const in int maxMIPLevel ) {\n\t\t#ifdef ENVMAP_MODE_REFLECTION\n\t\t\tvec3 reflectVec = reflect( -geometry.viewDir, geometry.normal );\n\t\t#else\n\t\t\tvec3 reflectVec = refract( -geometry.viewDir, geometry.normal, refractionRatio );\n\t\t#endif\n\t\treflectVec = inverseTransformDirection( reflectVec, viewMatrix );\n\t\tfloat specularMIPLevel = getSpecularMIPLevel( blinnShininessExponent, maxMIPLevel );\n\t\t#ifdef ENVMAP_TYPE_CUBE\n\t\t\tvec3 queryReflectVec = vec3( flipEnvMap * reflectVec.x, reflectVec.yz );\n\t\t\t#ifdef TEXTURE_LOD_EXT\n\t\t\t\tvec4 envMapColor = textureCubeLodEXT( envMap, queryReflectVec, specularMIPLevel );\n\t\t\t#else\n\t\t\t\tvec4 envMapColor = textureCube( envMap, queryReflectVec, specularMIPLevel );\n\t\t\t#endif\n\t\t\tenvMapColor.rgb = envMapTexelToLinear( envMapColor ).rgb;\n\t\t#elif defined( ENVMAP_TYPE_CUBE_UV )\n\t\t\tvec3 queryReflectVec = vec3( flipEnvMap * reflectVec.x, reflectVec.yz );\n\t\t\tvec4 envMapColor = textureCubeUV(queryReflectVec, BlinnExponentToGGXRoughness(blinnShininessExponent));\n\t\t#elif defined( ENVMAP_TYPE_EQUIREC )\n\t\t\tvec2 sampleUV;\n\t\t\tsampleUV.y = asin( clamp( reflectVec.y, - 1.0, 1.0 ) ) * RECIPROCAL_PI + 0.5;\n\t\t\tsampleUV.x = atan( reflectVec.z, reflectVec.x ) * RECIPROCAL_PI2 + 0.5;\n\t\t\t#ifdef TEXTURE_LOD_EXT\n\t\t\t\tvec4 envMapColor = texture2DLodEXT( envMap, sampleUV, specularMIPLevel );\n\t\t\t#else\n\t\t\t\tvec4 envMapColor = texture2D( envMap, sampleUV, specularMIPLevel );\n\t\t\t#endif\n\t\t\tenvMapColor.rgb = envMapTexelToLinear( envMapColor ).rgb;\n\t\t#elif defined( ENVMAP_TYPE_SPHERE )\n\t\t\tvec3 reflectView = normalize( ( viewMatrix * vec4( reflectVec, 0.0 ) ).xyz + vec3( 0.0,0.0,1.0 ) );\n\t\t\t#ifdef TEXTURE_LOD_EXT\n\t\t\t\tvec4 envMapColor = texture2DLodEXT( envMap, reflectView.xy * 0.5 + 0.5, specularMIPLevel );\n\t\t\t#else\n\t\t\t\tvec4 envMapColor = texture2D( envMap, reflectView.xy * 0.5 + 0.5, specularMIPLevel );\n\t\t\t#endif\n\t\t\tenvMapColor.rgb = envMapTexelToLinear( envMapColor ).rgb;\n\t\t#endif\n\t\treturn envMapColor.rgb * envMapIntensity;\n\t}\n#endif\n",lights_phong_fragment:"BlinnPhongMaterial material;\nmaterial.diffuseColor = diffuseColor.rgb;\nmaterial.specularColor = specular;\nmaterial.specularShininess = shininess;\nmaterial.specularStrength = specularStrength;\n",lights_phong_pars_fragment:"varying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\nstruct BlinnPhongMaterial {\n\tvec3\tdiffuseColor;\n\tvec3\tspecularColor;\n\tfloat\tspecularShininess;\n\tfloat\tspecularStrength;\n};\nvoid RE_Direct_BlinnPhong( const in IncidentLight directLight, const in GeometricContext geometry, const in BlinnPhongMaterial material, inout ReflectedLight reflectedLight ) {\n\t#ifdef TOON\n\t\tvec3 irradiance = getGradientIrradiance( geometry.normal, directLight.direction ) * directLight.color;\n\t#else\n\t\tfloat dotNL = saturate( dot( geometry.normal, directLight.direction ) );\n\t\tvec3 irradiance = dotNL * directLight.color;\n\t#endif\n\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\tirradiance *= PI;\n\t#endif\n\treflectedLight.directDiffuse += irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\n\treflectedLight.directSpecular += irradiance * BRDF_Specular_BlinnPhong( directLight, geometry, material.specularColor, material.specularShininess ) * material.specularStrength;\n}\nvoid RE_IndirectDiffuse_BlinnPhong( const in vec3 irradiance, const in GeometricContext geometry, const in BlinnPhongMaterial material, inout ReflectedLight reflectedLight ) {\n\treflectedLight.indirectDiffuse += irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\n}\n#define RE_Direct\t\t\t\tRE_Direct_BlinnPhong\n#define RE_IndirectDiffuse\t\tRE_IndirectDiffuse_BlinnPhong\n#define Material_LightProbeLOD( material )\t(0)\n",lights_physical_fragment:"PhysicalMaterial material;\nmaterial.diffuseColor = diffuseColor.rgb * ( 1.0 - metalnessFactor );\nmaterial.specularRoughness = clamp( roughnessFactor, 0.04, 1.0 );\n#ifdef STANDARD\n\tmaterial.specularColor = mix( vec3( DEFAULT_SPECULAR_COEFFICIENT ), diffuseColor.rgb, metalnessFactor );\n#else\n\tmaterial.specularColor = mix( vec3( MAXIMUM_SPECULAR_COEFFICIENT * pow2( reflectivity ) ), diffuseColor.rgb, metalnessFactor );\n\tmaterial.clearCoat = saturate( clearCoat );\tmaterial.clearCoatRoughness = clamp( clearCoatRoughness, 0.04, 1.0 );\n#endif\n",lights_physical_pars_fragment:"struct PhysicalMaterial {\n\tvec3\tdiffuseColor;\n\tfloat\tspecularRoughness;\n\tvec3\tspecularColor;\n\t#ifndef STANDARD\n\t\tfloat clearCoat;\n\t\tfloat clearCoatRoughness;\n\t#endif\n};\n#define MAXIMUM_SPECULAR_COEFFICIENT 0.16\n#define DEFAULT_SPECULAR_COEFFICIENT 0.04\nfloat clearCoatDHRApprox( const in float roughness, const in float dotNL ) {\n\treturn DEFAULT_SPECULAR_COEFFICIENT + ( 1.0 - DEFAULT_SPECULAR_COEFFICIENT ) * ( pow( 1.0 - dotNL, 5.0 ) * pow( 1.0 - roughness, 2.0 ) );\n}\n#if NUM_RECT_AREA_LIGHTS > 0\n\tvoid RE_Direct_RectArea_Physical( const in RectAreaLight rectAreaLight, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n\t\tvec3 normal = geometry.normal;\n\t\tvec3 viewDir = geometry.viewDir;\n\t\tvec3 position = geometry.position;\n\t\tvec3 lightPos = rectAreaLight.position;\n\t\tvec3 halfWidth = rectAreaLight.halfWidth;\n\t\tvec3 halfHeight = rectAreaLight.halfHeight;\n\t\tvec3 lightColor = rectAreaLight.color;\n\t\tfloat roughness = material.specularRoughness;\n\t\tvec3 rectCoords[ 4 ];\n\t\trectCoords[ 0 ] = lightPos - halfWidth - halfHeight;\t\trectCoords[ 1 ] = lightPos + halfWidth - halfHeight;\n\t\trectCoords[ 2 ] = lightPos + halfWidth + halfHeight;\n\t\trectCoords[ 3 ] = lightPos - halfWidth + halfHeight;\n\t\tvec2 uv = LTC_Uv( normal, viewDir, roughness );\n\t\tfloat norm = texture2D( ltcMag, uv ).a;\n\t\tvec4 t = texture2D( ltcMat, uv );\n\t\tmat3 mInv = mat3(\n\t\t\tvec3(   1,   0, t.y ),\n\t\t\tvec3(   0, t.z,   0 ),\n\t\t\tvec3( t.w,   0, t.x )\n\t\t);\n\t\treflectedLight.directSpecular += lightColor * material.specularColor * norm * LTC_Evaluate( normal, viewDir, position, mInv, rectCoords );\n\t\treflectedLight.directDiffuse += lightColor * material.diffuseColor * LTC_Evaluate( normal, viewDir, position, mat3( 1 ), rectCoords );\n\t}\n#endif\nvoid RE_Direct_Physical( const in IncidentLight directLight, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n\tfloat dotNL = saturate( dot( geometry.normal, directLight.direction ) );\n\tvec3 irradiance = dotNL * directLight.color;\n\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\tirradiance *= PI;\n\t#endif\n\t#ifndef STANDARD\n\t\tfloat clearCoatDHR = material.clearCoat * clearCoatDHRApprox( material.clearCoatRoughness, dotNL );\n\t#else\n\t\tfloat clearCoatDHR = 0.0;\n\t#endif\n\treflectedLight.directSpecular += ( 1.0 - clearCoatDHR ) * irradiance * BRDF_Specular_GGX( directLight, geometry, material.specularColor, material.specularRoughness );\n\treflectedLight.directDiffuse += ( 1.0 - clearCoatDHR ) * irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\n\t#ifndef STANDARD\n\t\treflectedLight.directSpecular += irradiance * material.clearCoat * BRDF_Specular_GGX( directLight, geometry, vec3( DEFAULT_SPECULAR_COEFFICIENT ), material.clearCoatRoughness );\n\t#endif\n}\nvoid RE_IndirectDiffuse_Physical( const in vec3 irradiance, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n\treflectedLight.indirectDiffuse += irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\n}\nvoid RE_IndirectSpecular_Physical( const in vec3 radiance, const in vec3 clearCoatRadiance, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n\t#ifndef STANDARD\n\t\tfloat dotNV = saturate( dot( geometry.normal, geometry.viewDir ) );\n\t\tfloat dotNL = dotNV;\n\t\tfloat clearCoatDHR = material.clearCoat * clearCoatDHRApprox( material.clearCoatRoughness, dotNL );\n\t#else\n\t\tfloat clearCoatDHR = 0.0;\n\t#endif\n\treflectedLight.indirectSpecular += ( 1.0 - clearCoatDHR ) * radiance * BRDF_Specular_GGX_Environment( geometry, material.specularColor, material.specularRoughness );\n\t#ifndef STANDARD\n\t\treflectedLight.indirectSpecular += clearCoatRadiance * material.clearCoat * BRDF_Specular_GGX_Environment( geometry, vec3( DEFAULT_SPECULAR_COEFFICIENT ), material.clearCoatRoughness );\n\t#endif\n}\n#define RE_Direct\t\t\t\tRE_Direct_Physical\n#define RE_Direct_RectArea\t\tRE_Direct_RectArea_Physical\n#define RE_IndirectDiffuse\t\tRE_IndirectDiffuse_Physical\n#define RE_IndirectSpecular\t\tRE_IndirectSpecular_Physical\n#define Material_BlinnShininessExponent( material )   GGXRoughnessToBlinnExponent( material.specularRoughness )\n#define Material_ClearCoat_BlinnShininessExponent( material )   GGXRoughnessToBlinnExponent( material.clearCoatRoughness )\nfloat computeSpecularOcclusion( const in float dotNV, const in float ambientOcclusion, const in float roughness ) {\n\treturn saturate( pow( dotNV + ambientOcclusion, exp2( - 16.0 * roughness - 1.0 ) ) - 1.0 + ambientOcclusion );\n}\n",lights_template:"\nGeometricContext geometry;\ngeometry.position = - vViewPosition;\ngeometry.normal = normal;\ngeometry.viewDir = normalize( vViewPosition );\nIncidentLight directLight;\n#if ( NUM_POINT_LIGHTS > 0 ) && defined( RE_Direct )\n\tPointLight pointLight;\n\tfor ( int i = 0; i < NUM_POINT_LIGHTS; i ++ ) {\n\t\tpointLight = pointLights[ i ];\n\t\tgetPointDirectLightIrradiance( pointLight, geometry, directLight );\n\t\t#ifdef USE_SHADOWMAP\n\t\tdirectLight.color *= all( bvec2( pointLight.shadow, directLight.visible ) ) ? getPointShadow( pointShadowMap[ i ], pointLight.shadowMapSize, pointLight.shadowBias, pointLight.shadowRadius, vPointShadowCoord[ i ], pointLight.shadowCameraNear, pointLight.shadowCameraFar ) : 1.0;\n\t\t#endif\n\t\tRE_Direct( directLight, geometry, material, reflectedLight );\n\t}\n#endif\n#if ( NUM_SPOT_LIGHTS > 0 ) && defined( RE_Direct )\n\tSpotLight spotLight;\n\tfor ( int i = 0; i < NUM_SPOT_LIGHTS; i ++ ) {\n\t\tspotLight = spotLights[ i ];\n\t\tgetSpotDirectLightIrradiance( spotLight, geometry, directLight );\n\t\t#ifdef USE_SHADOWMAP\n\t\tdirectLight.color *= all( bvec2( spotLight.shadow, directLight.visible ) ) ? getShadow( spotShadowMap[ i ], spotLight.shadowMapSize, spotLight.shadowBias, spotLight.shadowRadius, vSpotShadowCoord[ i ] ) : 1.0;\n\t\t#endif\n\t\tRE_Direct( directLight, geometry, material, reflectedLight );\n\t}\n#endif\n#if ( NUM_DIR_LIGHTS > 0 ) && defined( RE_Direct )\n\tDirectionalLight directionalLight;\n\tfor ( int i = 0; i < NUM_DIR_LIGHTS; i ++ ) {\n\t\tdirectionalLight = directionalLights[ i ];\n\t\tgetDirectionalDirectLightIrradiance( directionalLight, geometry, directLight );\n\t\t#ifdef USE_SHADOWMAP\n\t\tdirectLight.color *= all( bvec2( directionalLight.shadow, directLight.visible ) ) ? getShadow( directionalShadowMap[ i ], directionalLight.shadowMapSize, directionalLight.shadowBias, directionalLight.shadowRadius, vDirectionalShadowCoord[ i ] ) : 1.0;\n\t\t#endif\n\t\tRE_Direct( directLight, geometry, material, reflectedLight );\n\t}\n#endif\n#if ( NUM_RECT_AREA_LIGHTS > 0 ) && defined( RE_Direct_RectArea )\n\tRectAreaLight rectAreaLight;\n\tfor ( int i = 0; i < NUM_RECT_AREA_LIGHTS; i ++ ) {\n\t\trectAreaLight = rectAreaLights[ i ];\n\t\tRE_Direct_RectArea( rectAreaLight, geometry, material, reflectedLight );\n\t}\n#endif\n#if defined( RE_IndirectDiffuse )\n\tvec3 irradiance = getAmbientLightIrradiance( ambientLightColor );\n\t#ifdef USE_LIGHTMAP\n\t\tvec3 lightMapIrradiance = texture2D( lightMap, vUv2 ).xyz * lightMapIntensity;\n\t\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\t\tlightMapIrradiance *= PI;\n\t\t#endif\n\t\tirradiance += lightMapIrradiance;\n\t#endif\n\t#if ( NUM_HEMI_LIGHTS > 0 )\n\t\tfor ( int i = 0; i < NUM_HEMI_LIGHTS; i ++ ) {\n\t\t\tirradiance += getHemisphereLightIrradiance( hemisphereLights[ i ], geometry );\n\t\t}\n\t#endif\n\t#if defined( USE_ENVMAP ) && defined( PHYSICAL ) && defined( ENVMAP_TYPE_CUBE_UV )\n\t\tirradiance += getLightProbeIndirectIrradiance( geometry, 8 );\n\t#endif\n\tRE_IndirectDiffuse( irradiance, geometry, material, reflectedLight );\n#endif\n#if defined( USE_ENVMAP ) && defined( RE_IndirectSpecular )\n\tvec3 radiance = getLightProbeIndirectRadiance( geometry, Material_BlinnShininessExponent( material ), 8 );\n\t#ifndef STANDARD\n\t\tvec3 clearCoatRadiance = getLightProbeIndirectRadiance( geometry, Material_ClearCoat_BlinnShininessExponent( material ), 8 );\n\t#else\n\t\tvec3 clearCoatRadiance = vec3( 0.0 );\n\t#endif\n\tRE_IndirectSpecular( radiance, clearCoatRadiance, geometry, material, reflectedLight );\n#endif\n",logdepthbuf_fragment:"#if defined(USE_LOGDEPTHBUF) && defined(USE_LOGDEPTHBUF_EXT)\n\tgl_FragDepthEXT = log2(vFragDepth) * logDepthBufFC * 0.5;\n#endif",logdepthbuf_pars_fragment:"#ifdef USE_LOGDEPTHBUF\n\tuniform float logDepthBufFC;\n\t#ifdef USE_LOGDEPTHBUF_EXT\n\t\tvarying float vFragDepth;\n\t#endif\n#endif\n",logdepthbuf_pars_vertex:"#ifdef USE_LOGDEPTHBUF\n\t#ifdef USE_LOGDEPTHBUF_EXT\n\t\tvarying float vFragDepth;\n\t#endif\n\tuniform float logDepthBufFC;\n#endif",logdepthbuf_vertex:"#ifdef USE_LOGDEPTHBUF\n\tgl_Position.z = log2(max( EPSILON, gl_Position.w + 1.0 )) * logDepthBufFC;\n\t#ifdef USE_LOGDEPTHBUF_EXT\n\t\tvFragDepth = 1.0 + gl_Position.w;\n\t#else\n\t\tgl_Position.z = (gl_Position.z - 1.0) * gl_Position.w;\n\t#endif\n#endif\n",map_fragment:"#ifdef USE_MAP\n\tvec4 texelColor = texture2D( map, vUv );\n\ttexelColor = mapTexelToLinear( texelColor );\n\tdiffuseColor *= texelColor;\n#endif\n",map_pars_fragment:"#ifdef USE_MAP\n\tuniform sampler2D map;\n#endif\n",map_particle_fragment:"#ifdef USE_MAP\n\tvec4 mapTexel = texture2D( map, vec2( gl_PointCoord.x, 1.0 - gl_PointCoord.y ) * offsetRepeat.zw + offsetRepeat.xy );\n\tdiffuseColor *= mapTexelToLinear( mapTexel );\n#endif\n",map_particle_pars_fragment:"#ifdef USE_MAP\n\tuniform vec4 offsetRepeat;\n\tuniform sampler2D map;\n#endif\n",metalnessmap_fragment:"float metalnessFactor = metalness;\n#ifdef USE_METALNESSMAP\n\tvec4 texelMetalness = texture2D( metalnessMap, vUv );\n\tmetalnessFactor *= texelMetalness.b;\n#endif\n",metalnessmap_pars_fragment:"#ifdef USE_METALNESSMAP\n\tuniform sampler2D metalnessMap;\n#endif",morphnormal_vertex:"#ifdef USE_MORPHNORMALS\n\tobjectNormal += ( morphNormal0 - normal ) * morphTargetInfluences[ 0 ];\n\tobjectNormal += ( morphNormal1 - normal ) * morphTargetInfluences[ 1 ];\n\tobjectNormal += ( morphNormal2 - normal ) * morphTargetInfluences[ 2 ];\n\tobjectNormal += ( morphNormal3 - normal ) * morphTargetInfluences[ 3 ];\n#endif\n",morphtarget_pars_vertex:"#ifdef USE_MORPHTARGETS\n\t#ifndef USE_MORPHNORMALS\n\tuniform float morphTargetInfluences[ 8 ];\n\t#else\n\tuniform float morphTargetInfluences[ 4 ];\n\t#endif\n#endif",morphtarget_vertex:"#ifdef USE_MORPHTARGETS\n\ttransformed += ( morphTarget0 - position ) * morphTargetInfluences[ 0 ];\n\ttransformed += ( morphTarget1 - position ) * morphTargetInfluences[ 1 ];\n\ttransformed += ( morphTarget2 - position ) * morphTargetInfluences[ 2 ];\n\ttransformed += ( morphTarget3 - position ) * morphTargetInfluences[ 3 ];\n\t#ifndef USE_MORPHNORMALS\n\ttransformed += ( morphTarget4 - position ) * morphTargetInfluences[ 4 ];\n\ttransformed += ( morphTarget5 - position ) * morphTargetInfluences[ 5 ];\n\ttransformed += ( morphTarget6 - position ) * morphTargetInfluences[ 6 ];\n\ttransformed += ( morphTarget7 - position ) * morphTargetInfluences[ 7 ];\n\t#endif\n#endif\n",normal_fragment:"#ifdef FLAT_SHADED\n\tvec3 fdx = vec3( dFdx( vViewPosition.x ), dFdx( vViewPosition.y ), dFdx( vViewPosition.z ) );\n\tvec3 fdy = vec3( dFdy( vViewPosition.x ), dFdy( vViewPosition.y ), dFdy( vViewPosition.z ) );\n\tvec3 normal = normalize( cross( fdx, fdy ) );\n#else\n\tvec3 normal = normalize( vNormal );\n\t#ifdef DOUBLE_SIDED\n\t\tnormal = normal * ( float( gl_FrontFacing ) * 2.0 - 1.0 );\n\t#endif\n#endif\n#ifdef USE_NORMALMAP\n\tnormal = perturbNormal2Arb( -vViewPosition, normal );\n#elif defined( USE_BUMPMAP )\n\tnormal = perturbNormalArb( -vViewPosition, normal, dHdxy_fwd() );\n#endif\n",normalmap_pars_fragment:"#ifdef USE_NORMALMAP\n\tuniform sampler2D normalMap;\n\tuniform vec2 normalScale;\n\tvec3 perturbNormal2Arb( vec3 eye_pos, vec3 surf_norm ) {\n\t\tvec3 q0 = vec3( dFdx( eye_pos.x ), dFdx( eye_pos.y ), dFdx( eye_pos.z ) );\n\t\tvec3 q1 = vec3( dFdy( eye_pos.x ), dFdy( eye_pos.y ), dFdy( eye_pos.z ) );\n\t\tvec2 st0 = dFdx( vUv.st );\n\t\tvec2 st1 = dFdy( vUv.st );\n\t\tvec3 S = normalize( q0 * st1.t - q1 * st0.t );\n\t\tvec3 T = normalize( -q0 * st1.s + q1 * st0.s );\n\t\tvec3 N = normalize( surf_norm );\n\t\tvec3 mapN = texture2D( normalMap, vUv ).xyz * 2.0 - 1.0;\n\t\tmapN.xy = normalScale * mapN.xy;\n\t\tmat3 tsn = mat3( S, T, N );\n\t\treturn normalize( tsn * mapN );\n\t}\n#endif\n",packing:"vec3 packNormalToRGB( const in vec3 normal ) {\n\treturn normalize( normal ) * 0.5 + 0.5;\n}\nvec3 unpackRGBToNormal( const in vec3 rgb ) {\n\treturn 1.0 - 2.0 * rgb.xyz;\n}\nconst float PackUpscale = 256. / 255.;const float UnpackDownscale = 255. / 256.;\nconst vec3 PackFactors = vec3( 256. * 256. * 256., 256. * 256.,  256. );\nconst vec4 UnpackFactors = UnpackDownscale / vec4( PackFactors, 1. );\nconst float ShiftRight8 = 1. / 256.;\nvec4 packDepthToRGBA( const in float v ) {\n\tvec4 r = vec4( fract( v * PackFactors ), v );\n\tr.yzw -= r.xyz * ShiftRight8;\treturn r * PackUpscale;\n}\nfloat unpackRGBAToDepth( const in vec4 v ) {\n\treturn dot( v, UnpackFactors );\n}\nfloat viewZToOrthographicDepth( const in float viewZ, const in float near, const in float far ) {\n\treturn ( viewZ + near ) / ( near - far );\n}\nfloat orthographicDepthToViewZ( const in float linearClipZ, const in float near, const in float far ) {\n\treturn linearClipZ * ( near - far ) - near;\n}\nfloat viewZToPerspectiveDepth( const in float viewZ, const in float near, const in float far ) {\n\treturn (( near + viewZ ) * far ) / (( far - near ) * viewZ );\n}\nfloat perspectiveDepthToViewZ( const in float invClipZ, const in float near, const in float far ) {\n\treturn ( near * far ) / ( ( far - near ) * invClipZ - far );\n}\n",premultiplied_alpha_fragment:"#ifdef PREMULTIPLIED_ALPHA\n\tgl_FragColor.rgb *= gl_FragColor.a;\n#endif\n",project_vertex:"vec4 mvPosition = modelViewMatrix * vec4( transformed, 1.0 );\ngl_Position = projectionMatrix * mvPosition;\n",dithering_fragment:"#if defined( DITHERING )\n  gl_FragColor.rgb = dithering( gl_FragColor.rgb );\n#endif\n",dithering_pars_fragment:"#if defined( DITHERING )\n\tvec3 dithering( vec3 color ) {\n\t\tfloat grid_position = rand( gl_FragCoord.xy );\n\t\tvec3 dither_shift_RGB = vec3( 0.25 / 255.0, -0.25 / 255.0, 0.25 / 255.0 );\n\t\tdither_shift_RGB = mix( 2.0 * dither_shift_RGB, -2.0 * dither_shift_RGB, grid_position );\n\t\treturn color + dither_shift_RGB;\n\t}\n#endif\n",roughnessmap_fragment:"float roughnessFactor = roughness;\n#ifdef USE_ROUGHNESSMAP\n\tvec4 texelRoughness = texture2D( roughnessMap, vUv );\n\troughnessFactor *= texelRoughness.g;\n#endif\n",roughnessmap_pars_fragment:"#ifdef USE_ROUGHNESSMAP\n\tuniform sampler2D roughnessMap;\n#endif",shadowmap_pars_fragment:"#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHTS > 0\n\t\tuniform sampler2D directionalShadowMap[ NUM_DIR_LIGHTS ];\n\t\tvarying vec4 vDirectionalShadowCoord[ NUM_DIR_LIGHTS ];\n\t#endif\n\t#if NUM_SPOT_LIGHTS > 0\n\t\tuniform sampler2D spotShadowMap[ NUM_SPOT_LIGHTS ];\n\t\tvarying vec4 vSpotShadowCoord[ NUM_SPOT_LIGHTS ];\n\t#endif\n\t#if NUM_POINT_LIGHTS > 0\n\t\tuniform sampler2D pointShadowMap[ NUM_POINT_LIGHTS ];\n\t\tvarying vec4 vPointShadowCoord[ NUM_POINT_LIGHTS ];\n\t#endif\n\tfloat texture2DCompare( sampler2D depths, vec2 uv, float compare ) {\n\t\treturn step( compare, unpackRGBAToDepth( texture2D( depths, uv ) ) );\n\t}\n\tfloat texture2DShadowLerp( sampler2D depths, vec2 size, vec2 uv, float compare ) {\n\t\tconst vec2 offset = vec2( 0.0, 1.0 );\n\t\tvec2 texelSize = vec2( 1.0 ) / size;\n\t\tvec2 centroidUV = floor( uv * size + 0.5 ) / size;\n\t\tfloat lb = texture2DCompare( depths, centroidUV + texelSize * offset.xx, compare );\n\t\tfloat lt = texture2DCompare( depths, centroidUV + texelSize * offset.xy, compare );\n\t\tfloat rb = texture2DCompare( depths, centroidUV + texelSize * offset.yx, compare );\n\t\tfloat rt = texture2DCompare( depths, centroidUV + texelSize * offset.yy, compare );\n\t\tvec2 f = fract( uv * size + 0.5 );\n\t\tfloat a = mix( lb, lt, f.y );\n\t\tfloat b = mix( rb, rt, f.y );\n\t\tfloat c = mix( a, b, f.x );\n\t\treturn c;\n\t}\n\tfloat getShadow( sampler2D shadowMap, vec2 shadowMapSize, float shadowBias, float shadowRadius, vec4 shadowCoord ) {\n\t\tfloat shadow = 1.0;\n\t\tshadowCoord.xyz /= shadowCoord.w;\n\t\tshadowCoord.z += shadowBias;\n\t\tbvec4 inFrustumVec = bvec4 ( shadowCoord.x >= 0.0, shadowCoord.x <= 1.0, shadowCoord.y >= 0.0, shadowCoord.y <= 1.0 );\n\t\tbool inFrustum = all( inFrustumVec );\n\t\tbvec2 frustumTestVec = bvec2( inFrustum, shadowCoord.z <= 1.0 );\n\t\tbool frustumTest = all( frustumTestVec );\n\t\tif ( frustumTest ) {\n\t\t#if defined( SHADOWMAP_TYPE_PCF )\n\t\t\tvec2 texelSize = vec2( 1.0 ) / shadowMapSize;\n\t\t\tfloat dx0 = - texelSize.x * shadowRadius;\n\t\t\tfloat dy0 = - texelSize.y * shadowRadius;\n\t\t\tfloat dx1 = + texelSize.x * shadowRadius;\n\t\t\tfloat dy1 = + texelSize.y * shadowRadius;\n\t\t\tshadow = (\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy, shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, dy1 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy1 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, dy1 ), shadowCoord.z )\n\t\t\t) * ( 1.0 / 9.0 );\n\t\t#elif defined( SHADOWMAP_TYPE_PCF_SOFT )\n\t\t\tvec2 texelSize = vec2( 1.0 ) / shadowMapSize;\n\t\t\tfloat dx0 = - texelSize.x * shadowRadius;\n\t\t\tfloat dy0 = - texelSize.y * shadowRadius;\n\t\t\tfloat dx1 = + texelSize.x * shadowRadius;\n\t\t\tfloat dy1 = + texelSize.y * shadowRadius;\n\t\t\tshadow = (\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx0, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( 0.0, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx1, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx0, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy, shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx1, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx0, dy1 ), shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( 0.0, dy1 ), shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx1, dy1 ), shadowCoord.z )\n\t\t\t) * ( 1.0 / 9.0 );\n\t\t#else\n\t\t\tshadow = texture2DCompare( shadowMap, shadowCoord.xy, shadowCoord.z );\n\t\t#endif\n\t\t}\n\t\treturn shadow;\n\t}\n\tvec2 cubeToUV( vec3 v, float texelSizeY ) {\n\t\tvec3 absV = abs( v );\n\t\tfloat scaleToCube = 1.0 / max( absV.x, max( absV.y, absV.z ) );\n\t\tabsV *= scaleToCube;\n\t\tv *= scaleToCube * ( 1.0 - 2.0 * texelSizeY );\n\t\tvec2 planar = v.xy;\n\t\tfloat almostATexel = 1.5 * texelSizeY;\n\t\tfloat almostOne = 1.0 - almostATexel;\n\t\tif ( absV.z >= almostOne ) {\n\t\t\tif ( v.z > 0.0 )\n\t\t\t\tplanar.x = 4.0 - v.x;\n\t\t} else if ( absV.x >= almostOne ) {\n\t\t\tfloat signX = sign( v.x );\n\t\t\tplanar.x = v.z * signX + 2.0 * signX;\n\t\t} else if ( absV.y >= almostOne ) {\n\t\t\tfloat signY = sign( v.y );\n\t\t\tplanar.x = v.x + 2.0 * signY + 2.0;\n\t\t\tplanar.y = v.z * signY - 2.0;\n\t\t}\n\t\treturn vec2( 0.125, 0.25 ) * planar + vec2( 0.375, 0.75 );\n\t}\n\tfloat getPointShadow( sampler2D shadowMap, vec2 shadowMapSize, float shadowBias, float shadowRadius, vec4 shadowCoord, float shadowCameraNear, float shadowCameraFar ) {\n\t\tvec2 texelSize = vec2( 1.0 ) / ( shadowMapSize * vec2( 4.0, 2.0 ) );\n\t\tvec3 lightToPosition = shadowCoord.xyz;\n\t\tfloat dp = ( length( lightToPosition ) - shadowCameraNear ) / ( shadowCameraFar - shadowCameraNear );\t\tdp += shadowBias;\n\t\tvec3 bd3D = normalize( lightToPosition );\n\t\t#if defined( SHADOWMAP_TYPE_PCF ) || defined( SHADOWMAP_TYPE_PCF_SOFT )\n\t\t\tvec2 offset = vec2( - 1, 1 ) * shadowRadius * texelSize.y;\n\t\t\treturn (\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xyy, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yyy, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xyx, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yyx, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xxy, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yxy, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xxx, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yxx, texelSize.y ), dp )\n\t\t\t) * ( 1.0 / 9.0 );\n\t\t#else\n\t\t\treturn texture2DCompare( shadowMap, cubeToUV( bd3D, texelSize.y ), dp );\n\t\t#endif\n\t}\n#endif\n",shadowmap_pars_vertex:"#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHTS > 0\n\t\tuniform mat4 directionalShadowMatrix[ NUM_DIR_LIGHTS ];\n\t\tvarying vec4 vDirectionalShadowCoord[ NUM_DIR_LIGHTS ];\n\t#endif\n\t#if NUM_SPOT_LIGHTS > 0\n\t\tuniform mat4 spotShadowMatrix[ NUM_SPOT_LIGHTS ];\n\t\tvarying vec4 vSpotShadowCoord[ NUM_SPOT_LIGHTS ];\n\t#endif\n\t#if NUM_POINT_LIGHTS > 0\n\t\tuniform mat4 pointShadowMatrix[ NUM_POINT_LIGHTS ];\n\t\tvarying vec4 vPointShadowCoord[ NUM_POINT_LIGHTS ];\n\t#endif\n#endif\n",shadowmap_vertex:"#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHTS > 0\n\tfor ( int i = 0; i < NUM_DIR_LIGHTS; i ++ ) {\n\t\tvDirectionalShadowCoord[ i ] = directionalShadowMatrix[ i ] * worldPosition;\n\t}\n\t#endif\n\t#if NUM_SPOT_LIGHTS > 0\n\tfor ( int i = 0; i < NUM_SPOT_LIGHTS; i ++ ) {\n\t\tvSpotShadowCoord[ i ] = spotShadowMatrix[ i ] * worldPosition;\n\t}\n\t#endif\n\t#if NUM_POINT_LIGHTS > 0\n\tfor ( int i = 0; i < NUM_POINT_LIGHTS; i ++ ) {\n\t\tvPointShadowCoord[ i ] = pointShadowMatrix[ i ] * worldPosition;\n\t}\n\t#endif\n#endif\n",shadowmask_pars_fragment:"float getShadowMask() {\n\tfloat shadow = 1.0;\n\t#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHTS > 0\n\tDirectionalLight directionalLight;\n\tfor ( int i = 0; i < NUM_DIR_LIGHTS; i ++ ) {\n\t\tdirectionalLight = directionalLights[ i ];\n\t\tshadow *= bool( directionalLight.shadow ) ? getShadow( directionalShadowMap[ i ], directionalLight.shadowMapSize, directionalLight.shadowBias, directionalLight.shadowRadius, vDirectionalShadowCoord[ i ] ) : 1.0;\n\t}\n\t#endif\n\t#if NUM_SPOT_LIGHTS > 0\n\tSpotLight spotLight;\n\tfor ( int i = 0; i < NUM_SPOT_LIGHTS; i ++ ) {\n\t\tspotLight = spotLights[ i ];\n\t\tshadow *= bool( spotLight.shadow ) ? getShadow( spotShadowMap[ i ], spotLight.shadowMapSize, spotLight.shadowBias, spotLight.shadowRadius, vSpotShadowCoord[ i ] ) : 1.0;\n\t}\n\t#endif\n\t#if NUM_POINT_LIGHTS > 0\n\tPointLight pointLight;\n\tfor ( int i = 0; i < NUM_POINT_LIGHTS; i ++ ) {\n\t\tpointLight = pointLights[ i ];\n\t\tshadow *= bool( pointLight.shadow ) ? getPointShadow( pointShadowMap[ i ], pointLight.shadowMapSize, pointLight.shadowBias, pointLight.shadowRadius, vPointShadowCoord[ i ], pointLight.shadowCameraNear, pointLight.shadowCameraFar ) : 1.0;\n\t}\n\t#endif\n\t#endif\n\treturn shadow;\n}\n",skinbase_vertex:"#ifdef USE_SKINNING\n\tmat4 boneMatX = getBoneMatrix( skinIndex.x );\n\tmat4 boneMatY = getBoneMatrix( skinIndex.y );\n\tmat4 boneMatZ = getBoneMatrix( skinIndex.z );\n\tmat4 boneMatW = getBoneMatrix( skinIndex.w );\n#endif",skinning_pars_vertex:"#ifdef USE_SKINNING\n\tuniform mat4 bindMatrix;\n\tuniform mat4 bindMatrixInverse;\n\t#ifdef BONE_TEXTURE\n\t\tuniform sampler2D boneTexture;\n\t\tuniform int boneTextureSize;\n\t\tmat4 getBoneMatrix( const in float i ) {\n\t\t\tfloat j = i * 4.0;\n\t\t\tfloat x = mod( j, float( boneTextureSize ) );\n\t\t\tfloat y = floor( j / float( boneTextureSize ) );\n\t\t\tfloat dx = 1.0 / float( boneTextureSize );\n\t\t\tfloat dy = 1.0 / float( boneTextureSize );\n\t\t\ty = dy * ( y + 0.5 );\n\t\t\tvec4 v1 = texture2D( boneTexture, vec2( dx * ( x + 0.5 ), y ) );\n\t\t\tvec4 v2 = texture2D( boneTexture, vec2( dx * ( x + 1.5 ), y ) );\n\t\t\tvec4 v3 = texture2D( boneTexture, vec2( dx * ( x + 2.5 ), y ) );\n\t\t\tvec4 v4 = texture2D( boneTexture, vec2( dx * ( x + 3.5 ), y ) );\n\t\t\tmat4 bone = mat4( v1, v2, v3, v4 );\n\t\t\treturn bone;\n\t\t}\n\t#else\n\t\tuniform mat4 boneMatrices[ MAX_BONES ];\n\t\tmat4 getBoneMatrix( const in float i ) {\n\t\t\tmat4 bone = boneMatrices[ int(i) ];\n\t\t\treturn bone;\n\t\t}\n\t#endif\n#endif\n",skinning_vertex:"#ifdef USE_SKINNING\n\tvec4 skinVertex = bindMatrix * vec4( transformed, 1.0 );\n\tvec4 skinned = vec4( 0.0 );\n\tskinned += boneMatX * skinVertex * skinWeight.x;\n\tskinned += boneMatY * skinVertex * skinWeight.y;\n\tskinned += boneMatZ * skinVertex * skinWeight.z;\n\tskinned += boneMatW * skinVertex * skinWeight.w;\n\ttransformed = ( bindMatrixInverse * skinned ).xyz;\n#endif\n",skinnormal_vertex:"#ifdef USE_SKINNING\n\tmat4 skinMatrix = mat4( 0.0 );\n\tskinMatrix += skinWeight.x * boneMatX;\n\tskinMatrix += skinWeight.y * boneMatY;\n\tskinMatrix += skinWeight.z * boneMatZ;\n\tskinMatrix += skinWeight.w * boneMatW;\n\tskinMatrix  = bindMatrixInverse * skinMatrix * bindMatrix;\n\tobjectNormal = vec4( skinMatrix * vec4( objectNormal, 0.0 ) ).xyz;\n#endif\n",specularmap_fragment:"float specularStrength;\n#ifdef USE_SPECULARMAP\n\tvec4 texelSpecular = texture2D( specularMap, vUv );\n\tspecularStrength = texelSpecular.r;\n#else\n\tspecularStrength = 1.0;\n#endif",specularmap_pars_fragment:"#ifdef USE_SPECULARMAP\n\tuniform sampler2D specularMap;\n#endif",tonemapping_fragment:"#if defined( TONE_MAPPING )\n  gl_FragColor.rgb = toneMapping( gl_FragColor.rgb );\n#endif\n",tonemapping_pars_fragment:"#define saturate(a) clamp( a, 0.0, 1.0 )\nuniform float toneMappingExposure;\nuniform float toneMappingWhitePoint;\nvec3 LinearToneMapping( vec3 color ) {\n\treturn toneMappingExposure * color;\n}\nvec3 ReinhardToneMapping( vec3 color ) {\n\tcolor *= toneMappingExposure;\n\treturn saturate( color / ( vec3( 1.0 ) + color ) );\n}\n#define Uncharted2Helper( x ) max( ( ( x * ( 0.15 * x + 0.10 * 0.50 ) + 0.20 * 0.02 ) / ( x * ( 0.15 * x + 0.50 ) + 0.20 * 0.30 ) ) - 0.02 / 0.30, vec3( 0.0 ) )\nvec3 Uncharted2ToneMapping( vec3 color ) {\n\tcolor *= toneMappingExposure;\n\treturn saturate( Uncharted2Helper( color ) / Uncharted2Helper( vec3( toneMappingWhitePoint ) ) );\n}\nvec3 OptimizedCineonToneMapping( vec3 color ) {\n\tcolor *= toneMappingExposure;\n\tcolor = max( vec3( 0.0 ), color - 0.004 );\n\treturn pow( ( color * ( 6.2 * color + 0.5 ) ) / ( color * ( 6.2 * color + 1.7 ) + 0.06 ), vec3( 2.2 ) );\n}\n",uv_pars_fragment:"#if defined( USE_MAP ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( USE_SPECULARMAP ) || defined( USE_ALPHAMAP ) || defined( USE_EMISSIVEMAP ) || defined( USE_ROUGHNESSMAP ) || defined( USE_METALNESSMAP )\n\tvarying vec2 vUv;\n#endif",uv_pars_vertex:"#if defined( USE_MAP ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( USE_SPECULARMAP ) || defined( USE_ALPHAMAP ) || defined( USE_EMISSIVEMAP ) || defined( USE_ROUGHNESSMAP ) || defined( USE_METALNESSMAP )\n\tvarying vec2 vUv;\n\tuniform vec4 offsetRepeat;\n#endif\n",uv_vertex:"#if defined( USE_MAP ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( USE_SPECULARMAP ) || defined( USE_ALPHAMAP ) || defined( USE_EMISSIVEMAP ) || defined( USE_ROUGHNESSMAP ) || defined( USE_METALNESSMAP )\n\tvUv = uv * offsetRepeat.zw + offsetRepeat.xy;\n#endif",uv2_pars_fragment:"#if defined( USE_LIGHTMAP ) || defined( USE_AOMAP )\n\tvarying vec2 vUv2;\n#endif",uv2_pars_vertex:"#if defined( USE_LIGHTMAP ) || defined( USE_AOMAP )\n\tattribute vec2 uv2;\n\tvarying vec2 vUv2;\n#endif",uv2_vertex:"#if defined( USE_LIGHTMAP ) || defined( USE_AOMAP )\n\tvUv2 = uv2;\n#endif",worldpos_vertex:"#if defined( USE_ENVMAP ) || defined( PHONG ) || defined( PHYSICAL ) || defined( LAMBERT ) || defined( DISTANCE ) || defined ( USE_SHADOWMAP )\n\tvec4 worldPosition = modelMatrix * vec4( transformed, 1.0 );\n#endif\n",cube_frag:"uniform samplerCube tCube;\nuniform float tFlip;\nuniform float opacity;\nvarying vec3 vWorldPosition;\nvoid main() {\n\tgl_FragColor = textureCube( tCube, vec3( tFlip * vWorldPosition.x, vWorldPosition.yz ) );\n\tgl_FragColor.a *= opacity;\n}\n",cube_vert:"varying vec3 vWorldPosition;\n#include <common>\nvoid main() {\n\tvWorldPosition = transformDirection( position, modelMatrix );\n\t#include <begin_vertex>\n\t#include <project_vertex>\n}\n",depth_frag:"#if DEPTH_PACKING == 3200\n\tuniform float opacity;\n#endif\n#include <common>\n#include <packing>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( 1.0 );\n\t#if DEPTH_PACKING == 3200\n\t\tdiffuseColor.a = opacity;\n\t#endif\n\t#include <map_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <logdepthbuf_fragment>\n\t#if DEPTH_PACKING == 3200\n\t\tgl_FragColor = vec4( vec3( gl_FragCoord.z ), opacity );\n\t#elif DEPTH_PACKING == 3201\n\t\tgl_FragColor = packDepthToRGBA( gl_FragCoord.z );\n\t#endif\n}\n",depth_vert:"#include <common>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <skinbase_vertex>\n\t#ifdef USE_DISPLACEMENTMAP\n\t\t#include <beginnormal_vertex>\n\t\t#include <morphnormal_vertex>\n\t\t#include <skinnormal_vertex>\n\t#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n}\n",distanceRGBA_frag:"#define DISTANCE\nuniform vec3 referencePosition;\nuniform float nearDistance;\nuniform float farDistance;\nvarying vec3 vWorldPosition;\n#include <common>\n#include <packing>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main () {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( 1.0 );\n\t#include <map_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\tfloat dist = length( vWorldPosition - referencePosition );\n\tdist = ( dist - nearDistance ) / ( farDistance - nearDistance );\n\tdist = saturate( dist );\n\tgl_FragColor = packDepthToRGBA( dist );\n}\n",distanceRGBA_vert:"#define DISTANCE\nvarying vec3 vWorldPosition;\n#include <common>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <skinbase_vertex>\n\t#ifdef USE_DISPLACEMENTMAP\n\t\t#include <beginnormal_vertex>\n\t\t#include <morphnormal_vertex>\n\t\t#include <skinnormal_vertex>\n\t#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <worldpos_vertex>\n\t#include <clipping_planes_vertex>\n\tvWorldPosition = worldPosition.xyz;\n}\n",equirect_frag:"uniform sampler2D tEquirect;\nvarying vec3 vWorldPosition;\n#include <common>\nvoid main() {\n\tvec3 direction = normalize( vWorldPosition );\n\tvec2 sampleUV;\n\tsampleUV.y = asin( clamp( direction.y, - 1.0, 1.0 ) ) * RECIPROCAL_PI + 0.5;\n\tsampleUV.x = atan( direction.z, direction.x ) * RECIPROCAL_PI2 + 0.5;\n\tgl_FragColor = texture2D( tEquirect, sampleUV );\n}\n",equirect_vert:"varying vec3 vWorldPosition;\n#include <common>\nvoid main() {\n\tvWorldPosition = transformDirection( position, modelMatrix );\n\t#include <begin_vertex>\n\t#include <project_vertex>\n}\n",linedashed_frag:"uniform vec3 diffuse;\nuniform float opacity;\nuniform float dashSize;\nuniform float totalSize;\nvarying float vLineDistance;\n#include <common>\n#include <color_pars_fragment>\n#include <fog_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tif ( mod( vLineDistance, totalSize ) > dashSize ) {\n\t\tdiscard;\n\t}\n\tvec3 outgoingLight = vec3( 0.0 );\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <logdepthbuf_fragment>\n\t#include <color_fragment>\n\toutgoingLight = diffuseColor.rgb;\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <premultiplied_alpha_fragment>\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n}\n",linedashed_vert:"uniform float scale;\nattribute float lineDistance;\nvarying float vLineDistance;\n#include <common>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <color_vertex>\n\tvLineDistance = scale * lineDistance;\n\tvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\n\tgl_Position = projectionMatrix * mvPosition;\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <fog_vertex>\n}\n",meshbasic_frag:"uniform vec3 diffuse;\nuniform float opacity;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <common>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <envmap_pars_fragment>\n#include <fog_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <specularmap_fragment>\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\t#ifdef USE_LIGHTMAP\n\t\treflectedLight.indirectDiffuse += texture2D( lightMap, vUv2 ).xyz * lightMapIntensity;\n\t#else\n\t\treflectedLight.indirectDiffuse += vec3( 1.0 );\n\t#endif\n\t#include <aomap_fragment>\n\treflectedLight.indirectDiffuse *= diffuseColor.rgb;\n\tvec3 outgoingLight = reflectedLight.indirectDiffuse;\n\t#include <envmap_fragment>\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <premultiplied_alpha_fragment>\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n}\n",meshbasic_vert:"#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <envmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <uv2_vertex>\n\t#include <color_vertex>\n\t#include <skinbase_vertex>\n\t#ifdef USE_ENVMAP\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <worldpos_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <envmap_vertex>\n\t#include <fog_vertex>\n}\n",meshlambert_frag:"uniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float opacity;\nvarying vec3 vLightFront;\n#ifdef DOUBLE_SIDED\n\tvarying vec3 vLightBack;\n#endif\n#include <common>\n#include <packing>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <envmap_pars_fragment>\n#include <bsdfs>\n#include <lights_pars>\n#include <fog_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <shadowmask_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <specularmap_fragment>\n\t#include <emissivemap_fragment>\n\treflectedLight.indirectDiffuse = getAmbientLightIrradiance( ambientLightColor );\n\t#include <lightmap_fragment>\n\treflectedLight.indirectDiffuse *= BRDF_Diffuse_Lambert( diffuseColor.rgb );\n\t#ifdef DOUBLE_SIDED\n\t\treflectedLight.directDiffuse = ( gl_FrontFacing ) ? vLightFront : vLightBack;\n\t#else\n\t\treflectedLight.directDiffuse = vLightFront;\n\t#endif\n\treflectedLight.directDiffuse *= BRDF_Diffuse_Lambert( diffuseColor.rgb ) * getShadowMask();\n\t#include <aomap_fragment>\n\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + totalEmissiveRadiance;\n\t#include <envmap_fragment>\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}\n",meshlambert_vert:"#define LAMBERT\nvarying vec3 vLightFront;\n#ifdef DOUBLE_SIDED\n\tvarying vec3 vLightBack;\n#endif\n#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <envmap_pars_vertex>\n#include <bsdfs>\n#include <lights_pars>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <uv2_vertex>\n\t#include <color_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <worldpos_vertex>\n\t#include <envmap_vertex>\n\t#include <lights_lambert_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}\n",meshphong_frag:"#define PHONG\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform vec3 specular;\nuniform float shininess;\nuniform float opacity;\n#include <common>\n#include <packing>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <envmap_pars_fragment>\n#include <gradientmap_pars_fragment>\n#include <fog_pars_fragment>\n#include <bsdfs>\n#include <lights_pars>\n#include <lights_phong_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <specularmap_fragment>\n\t#include <normal_fragment>\n\t#include <emissivemap_fragment>\n\t#include <lights_phong_fragment>\n\t#include <lights_template>\n\t#include <aomap_fragment>\n\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveRadiance;\n\t#include <envmap_fragment>\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}\n",meshphong_vert:"#define PHONG\nvarying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <envmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <uv2_vertex>\n\t#include <color_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n#ifndef FLAT_SHADED\n\tvNormal = normalize( transformedNormal );\n#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\tvViewPosition = - mvPosition.xyz;\n\t#include <worldpos_vertex>\n\t#include <envmap_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}\n",meshphysical_frag:"#define PHYSICAL\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float roughness;\nuniform float metalness;\nuniform float opacity;\n#ifndef STANDARD\n\tuniform float clearCoat;\n\tuniform float clearCoatRoughness;\n#endif\nvarying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <common>\n#include <packing>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <envmap_pars_fragment>\n#include <fog_pars_fragment>\n#include <bsdfs>\n#include <cube_uv_reflection_fragment>\n#include <lights_pars>\n#include <lights_physical_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <roughnessmap_pars_fragment>\n#include <metalnessmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <roughnessmap_fragment>\n\t#include <metalnessmap_fragment>\n\t#include <normal_fragment>\n\t#include <emissivemap_fragment>\n\t#include <lights_physical_fragment>\n\t#include <lights_template>\n\t#include <aomap_fragment>\n\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveRadiance;\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}\n",meshphysical_vert:"#define PHYSICAL\nvarying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <uv2_vertex>\n\t#include <color_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n#ifndef FLAT_SHADED\n\tvNormal = normalize( transformedNormal );\n#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\tvViewPosition = - mvPosition.xyz;\n\t#include <worldpos_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}\n",normal_frag:"#define NORMAL\nuniform float opacity;\n#if defined( FLAT_SHADED ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP )\n\tvarying vec3 vViewPosition;\n#endif\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <packing>\n#include <uv_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\nvoid main() {\n\t#include <logdepthbuf_fragment>\n\t#include <normal_fragment>\n\tgl_FragColor = vec4( packNormalToRGB( normal ), opacity );\n}\n",normal_vert:"#define NORMAL\n#if defined( FLAT_SHADED ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP )\n\tvarying vec3 vViewPosition;\n#endif\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n#ifndef FLAT_SHADED\n\tvNormal = normalize( transformedNormal );\n#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n#if defined( FLAT_SHADED ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP )\n\tvViewPosition = - mvPosition.xyz;\n#endif\n}\n",points_frag:"uniform vec3 diffuse;\nuniform float opacity;\n#include <common>\n#include <packing>\n#include <color_pars_fragment>\n#include <map_particle_pars_fragment>\n#include <fog_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec3 outgoingLight = vec3( 0.0 );\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <logdepthbuf_fragment>\n\t#include <map_particle_fragment>\n\t#include <color_fragment>\n\t#include <alphatest_fragment>\n\toutgoingLight = diffuseColor.rgb;\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <premultiplied_alpha_fragment>\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n}\n",points_vert:"uniform float size;\nuniform float scale;\n#include <common>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <color_vertex>\n\t#include <begin_vertex>\n\t#include <project_vertex>\n\t#ifdef USE_SIZEATTENUATION\n\t\tgl_PointSize = size * ( scale / - mvPosition.z );\n\t#else\n\t\tgl_PointSize = size;\n\t#endif\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <worldpos_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}\n",shadow_frag:"uniform vec3 color;\nuniform float opacity;\n#include <common>\n#include <packing>\n#include <bsdfs>\n#include <lights_pars>\n#include <shadowmap_pars_fragment>\n#include <shadowmask_pars_fragment>\nvoid main() {\n\tgl_FragColor = vec4( color, opacity * ( 1.0 - getShadowMask() ) );\n}\n",shadow_vert:"#include <shadowmap_pars_vertex>\nvoid main() {\n\t#include <begin_vertex>\n\t#include <project_vertex>\n\t#include <worldpos_vertex>\n\t#include <shadowmap_vertex>\n}\n"},Bp={basic:{uniforms:Np.merge([Dp.common,Dp.specularmap,Dp.envmap,Dp.aomap,Dp.lightmap,Dp.fog]),vertexShader:kp.meshbasic_vert,fragmentShader:kp.meshbasic_frag},lambert:{uniforms:Np.merge([Dp.common,Dp.specularmap,Dp.envmap,Dp.aomap,Dp.lightmap,Dp.emissivemap,Dp.fog,Dp.lights,{emissive:{value:new et(0)}}]),vertexShader:kp.meshlambert_vert,fragmentShader:kp.meshlambert_frag},phong:{uniforms:Np.merge([Dp.common,Dp.specularmap,Dp.envmap,Dp.aomap,Dp.lightmap,Dp.emissivemap,Dp.bumpmap,Dp.normalmap,Dp.displacementmap,Dp.gradientmap,Dp.fog,Dp.lights,{emissive:{value:new et(0)},specular:{value:new et(1118481)},shininess:{value:30}}]),vertexShader:kp.meshphong_vert,fragmentShader:kp.meshphong_frag},standard:{uniforms:Np.merge([Dp.common,Dp.envmap,Dp.aomap,Dp.lightmap,Dp.emissivemap,Dp.bumpmap,Dp.normalmap,Dp.displacementmap,Dp.roughnessmap,Dp.metalnessmap,Dp.fog,Dp.lights,{emissive:{value:new et(0)},roughness:{value:.5},metalness:{value:.5},envMapIntensity:{value:1}}]),vertexShader:kp.meshphysical_vert,fragmentShader:kp.meshphysical_frag},points:{uniforms:Np.merge([Dp.points,Dp.fog]),vertexShader:kp.points_vert,fragmentShader:kp.points_frag},dashed:{uniforms:Np.merge([Dp.common,Dp.fog,{scale:{value:1},dashSize:{value:1},totalSize:{value:2}}]),vertexShader:kp.linedashed_vert,fragmentShader:kp.linedashed_frag},depth:{uniforms:Np.merge([Dp.common,Dp.displacementmap]),vertexShader:kp.depth_vert,fragmentShader:kp.depth_frag},normal:{uniforms:Np.merge([Dp.common,Dp.bumpmap,Dp.normalmap,Dp.displacementmap,{opacity:{value:1}}]),vertexShader:kp.normal_vert,fragmentShader:kp.normal_frag},cube:{uniforms:{tCube:{value:null},tFlip:{value:-1},opacity:{value:1}},vertexShader:kp.cube_vert,fragmentShader:kp.cube_frag},equirect:{uniforms:{tEquirect:{value:null}},vertexShader:kp.equirect_vert,fragmentShader:kp.equirect_frag},distanceRGBA:{uniforms:Np.merge([Dp.common,Dp.displacementmap,{referencePosition:{value:new v},nearDistance:{value:1},farDistance:{value:1e3}}]),vertexShader:kp.distanceRGBA_vert,fragmentShader:kp.distanceRGBA_frag},shadow:{uniforms:Np.merge([Dp.lights,{color:{value:new et(0)},opacity:{value:1}}]),vertexShader:kp.shadow_vert,fragmentShader:kp.shadow_frag}};Bp.physical={uniforms:Np.merge([Bp.standard.uniforms,{clearCoat:{value:0},clearCoatRoughness:{value:0}}]),vertexShader:kp.meshphysical_vert,fragmentShader:kp.meshphysical_frag},Object.assign(it.prototype,{set:function(t,e){return this.min.copy(t),this.max.copy(e),this},setFromPoints:function(t){var e=this;this.makeEmpty();for(var i=0,r=t.length;i<r;i++)e.expandByPoint(t[i]);return this},setFromCenterAndSize:function(){var t=new h;return function(e,i){var r=t.copy(i).multiplyScalar(.5);return this.min.copy(e).sub(r),this.max.copy(e).add(r),this}}(),clone:function(){return(new this.constructor).copy(this)},copy:function(t){return this.min.copy(t.min),this.max.copy(t.max),this},makeEmpty:function(){return this.min.x=this.min.y=1/0,this.max.x=this.max.y=-1/0,this},isEmpty:function(){return this.max.x<this.min.x||this.max.y<this.min.y},getCenter:function(t){var e=t||new h;return this.isEmpty()?e.set(0,0):e.addVectors(this.min,this.max).multiplyScalar(.5)},getSize:function(t){var e=t||new h;return this.isEmpty()?e.set(0,0):e.subVectors(this.max,this.min)},expandByPoint:function(t){return this.min.min(t),this.max.max(t),this},expandByVector:function(t){return this.min.sub(t),this.max.add(t),this},expandByScalar:function(t){return this.min.addScalar(-t),this.max.addScalar(t),this},containsPoint:function(t){return!(t.x<this.min.x||t.x>this.max.x||t.y<this.min.y||t.y>this.max.y)},containsBox:function(t){return this.min.x<=t.min.x&&t.max.x<=this.max.x&&this.min.y<=t.min.y&&t.max.y<=this.max.y},getParameter:function(t,e){return(e||new h).set((t.x-this.min.x)/(this.max.x-this.min.x),(t.y-this.min.y)/(this.max.y-this.min.y))},intersectsBox:function(t){return!(t.max.x<this.min.x||t.min.x>this.max.x||t.max.y<this.min.y||t.min.y>this.max.y)},clampPoint:function(t,e){return(e||new h).copy(t).clamp(this.min,this.max)},distanceToPoint:function(){var t=new h;return function(e){return t.copy(e).clamp(this.min,this.max).sub(e).length()}}(),intersect:function(t){return this.min.max(t.min),this.max.min(t.max),this},union:function(t){return this.min.min(t.min),this.max.max(t.max),this},translate:function(t){return this.min.add(t),this.max.add(t),this},equals:function(t){return t.min.equals(this.min)&&t.max.equals(this.max)}}),nt.prototype=Object.create(p.prototype),nt.prototype.constructor=nt;var Fp=0;Object.assign(at.prototype,l.prototype,{isMaterial:!0,onBeforeCompile:function(){},setValues:function(t){var e=this;if(void 0!==t)for(var i in t){var r=t[i];if(void 0!==r)if("shading"!==i){var n=e[i];void 0!==n?n&&n.isColor?n.set(r):n&&n.isVector3&&r&&r.isVector3?n.copy(r):e[i]="overdraw"===i?Number(r):r:console.warn("THREE."+e.type+": '"+i+"' is not a property of this material.")}else console.warn("THREE."+e.type+": .shading has been removed. Use the boolean .flatShading instead."),e.flatShading=1===r;else console.warn("THREE.Material: '"+i+"' parameter is undefined.")}},toJSON:function(t){function e(t){var e=[];for(var i in t){var r=t[i];delete r.metadata,e.push(r)}return e}var i=void 0===t;i&&(t={textures:{},images:{}});var r={metadata:{version:4.5,type:"Material",generator:"Material.toJSON"}};if(r.uuid=this.uuid,r.type=this.type,""!==this.name&&(r.name=this.name),this.color&&this.color.isColor&&(r.color=this.color.getHex()),void 0!==this.roughness&&(r.roughness=this.roughness),void 0!==this.metalness&&(r.metalness=this.metalness),this.emissive&&this.emissive.isColor&&(r.emissive=this.emissive.getHex()),this.specular&&this.specular.isColor&&(r.specular=this.specular.getHex()),void 0!==this.shininess&&(r.shininess=this.shininess),void 0!==this.clearCoat&&(r.clearCoat=this.clearCoat),void 0!==this.clearCoatRoughness&&(r.clearCoatRoughness=this.clearCoatRoughness),this.map&&this.map.isTexture&&(r.map=this.map.toJSON(t).uuid),this.alphaMap&&this.alphaMap.isTexture&&(r.alphaMap=this.alphaMap.toJSON(t).uuid),this.lightMap&&this.lightMap.isTexture&&(r.lightMap=this.lightMap.toJSON(t).uuid),this.bumpMap&&this.bumpMap.isTexture&&(r.bumpMap=this.bumpMap.toJSON(t).uuid,r.bumpScale=this.bumpScale),this.normalMap&&this.normalMap.isTexture&&(r.normalMap=this.normalMap.toJSON(t).uuid,r.normalScale=this.normalScale.toArray()),this.displacementMap&&this.displacementMap.isTexture&&(r.displacementMap=this.displacementMap.toJSON(t).uuid,r.displacementScale=this.displacementScale,r.displacementBias=this.displacementBias),this.roughnessMap&&this.roughnessMap.isTexture&&(r.roughnessMap=this.roughnessMap.toJSON(t).uuid),this.metalnessMap&&this.metalnessMap.isTexture&&(r.metalnessMap=this.metalnessMap.toJSON(t).uuid),this.emissiveMap&&this.emissiveMap.isTexture&&(r.emissiveMap=this.emissiveMap.toJSON(t).uuid),this.specularMap&&this.specularMap.isTexture&&(r.specularMap=this.specularMap.toJSON(t).uuid),this.envMap&&this.envMap.isTexture&&(r.envMap=this.envMap.toJSON(t).uuid,r.reflectivity=this.reflectivity),this.gradientMap&&this.gradientMap.isTexture&&(r.gradientMap=this.gradientMap.toJSON(t).uuid),void 0!==this.size&&(r.size=this.size),void 0!==this.sizeAttenuation&&(r.sizeAttenuation=this.sizeAttenuation),this.blending!==Bl&&(r.blending=this.blending),!0===this.flatShading&&(r.flatShading=this.flatShading),this.side!==Il&&(r.side=this.side),this.vertexColors!==Ol&&(r.vertexColors=this.vertexColors),this.opacity<1&&(r.opacity=this.opacity),!0===this.transparent&&(r.transparent=this.transparent),r.depthFunc=this.depthFunc,r.depthTest=this.depthTest,r.depthWrite=this.depthWrite,!0===this.dithering&&(r.dithering=!0),this.alphaTest>0&&(r.alphaTest=this.alphaTest),!0===this.premultipliedAlpha&&(r.premultipliedAlpha=this.premultipliedAlpha),!0===this.wireframe&&(r.wireframe=this.wireframe),this.wireframeLinewidth>1&&(r.wireframeLinewidth=this.wireframeLinewidth),"round"!==this.wireframeLinecap&&(r.wireframeLinecap=this.wireframeLinecap),"round"!==this.wireframeLinejoin&&(r.wireframeLinejoin=this.wireframeLinejoin),!0===this.morphTargets&&(r.morphTargets=!0),!0===this.skinning&&(r.skinning=!0),!1===this.visible&&(r.visible=!1),"{}"!==JSON.stringify(this.userData)&&(r.userData=this.userData),i){var n=e(t.textures),o=e(t.images);n.length>0&&(r.textures=n),o.length>0&&(r.images=o)}return r},clone:function(){return(new this.constructor).copy(this)},copy:function(t){this.name=t.name,this.fog=t.fog,this.lights=t.lights,this.blending=t.blending,this.side=t.side,this.flatShading=t.flatShading,this.vertexColors=t.vertexColors,this.opacity=t.opacity,this.transparent=t.transparent,this.blendSrc=t.blendSrc,this.blendDst=t.blendDst,this.blendEquation=t.blendEquation,this.blendSrcAlpha=t.blendSrcAlpha,this.blendDstAlpha=t.blendDstAlpha,this.blendEquationAlpha=t.blendEquationAlpha,this.depthFunc=t.depthFunc,this.depthTest=t.depthTest,this.depthWrite=t.depthWrite,this.colorWrite=t.colorWrite,this.precision=t.precision,this.polygonOffset=t.polygonOffset,this.polygonOffsetFactor=t.polygonOffsetFactor,this.polygonOffsetUnits=t.polygonOffsetUnits,this.dithering=t.dithering,this.alphaTest=t.alphaTest,this.premultipliedAlpha=t.premultipliedAlpha,this.overdraw=t.overdraw,this.visible=t.visible,this.userData=JSON.parse(JSON.stringify(t.userData)),this.clipShadows=t.clipShadows,this.clipIntersection=t.clipIntersection;var e=t.clippingPlanes,i=null;if(null!==e){var r=e.length;i=new Array(r);for(var n=0;n!==r;++n)i[n]=e[n].clone()}return this.clippingPlanes=i,this},dispose:function(){this.dispatchEvent({type:"dispose"})}}),st.prototype=Object.create(at.prototype),st.prototype.constructor=st,st.prototype.isShaderMaterial=!0,st.prototype.copy=function(t){return at.prototype.copy.call(this,t),this.fragmentShader=t.fragmentShader,this.vertexShader=t.vertexShader,this.uniforms=Np.clone(t.uniforms),this.defines=t.defines,this.wireframe=t.wireframe,this.wireframeLinewidth=t.wireframeLinewidth,this.lights=t.lights,this.clipping=t.clipping,this.skinning=t.skinning,this.morphTargets=t.morphTargets,this.morphNormals=t.morphNormals,this.extensions=t.extensions,this},st.prototype.toJSON=function(t){var e=at.prototype.toJSON.call(this,t);return e.uniforms=this.uniforms,e.vertexShader=this.vertexShader,e.fragmentShader=this.fragmentShader,e},ct.prototype=Object.create(at.prototype),ct.prototype.constructor=ct,ct.prototype.isMeshDepthMaterial=!0,ct.prototype.copy=function(t){return at.prototype.copy.call(this,t),this.depthPacking=t.depthPacking,this.skinning=t.skinning,this.morphTargets=t.morphTargets,this.map=t.map,this.alphaMap=t.alphaMap,this.displacementMap=t.displacementMap,this.displacementScale=t.displacementScale,this.displacementBias=t.displacementBias,this.wireframe=t.wireframe,this.wireframeLinewidth=t.wireframeLinewidth,this},ut.prototype=Object.create(at.prototype),ut.prototype.constructor=ut,ut.prototype.isMeshDistanceMaterial=!0,ut.prototype.copy=function(t){return at.prototype.copy.call(this,t),this.referencePosition.copy(t.referencePosition),this.nearDistance=t.nearDistance,this.farDistance=t.farDistance,this.skinning=t.skinning,this.morphTargets=t.morphTargets,this.map=t.map,this.alphaMap=t.alphaMap,this.displacementMap=t.displacementMap,this.displacementScale=t.displacementScale,this.displacementBias=t.displacementBias,this},Object.assign(lt.prototype,{isBox3:!0,set:function(t,e){return this.min.copy(t),this.max.copy(e),this},setFromArray:function(t){for(var e=1/0,i=1/0,r=1/0,n=-1/0,o=-1/0,a=-1/0,s=0,c=t.length;s<c;s+=3){var u=t[s],l=t[s+1],h=t[s+2];u<e&&(e=u),l<i&&(i=l),h<r&&(r=h),u>n&&(n=u),l>o&&(o=l),h>a&&(a=h)}return this.min.set(e,i,r),this.max.set(n,o,a),this},setFromBufferAttribute:function(t){for(var e=1/0,i=1/0,r=1/0,n=-1/0,o=-1/0,a=-1/0,s=0,c=t.count;s<c;s++){var u=t.getX(s),l=t.getY(s),h=t.getZ(s);u<e&&(e=u),l<i&&(i=l),h<r&&(r=h),u>n&&(n=u),l>o&&(o=l),h>a&&(a=h)}return this.min.set(e,i,r),this.max.set(n,o,a),this},setFromPoints:function(t){var e=this;this.makeEmpty();for(var i=0,r=t.length;i<r;i++)e.expandByPoint(t[i]);return this},setFromCenterAndSize:function(){var t=new v;return function(e,i){var r=t.copy(i).multiplyScalar(.5);return this.min.copy(e).sub(r),this.max.copy(e).add(r),this}}(),setFromObject:function(t){return this.makeEmpty(),this.expandByObject(t)},clone:function(){return(new this.constructor).copy(this)},copy:function(t){return this.min.copy(t.min),this.max.copy(t.max),this},makeEmpty:function(){return this.min.x=this.min.y=this.min.z=1/0,this.max.x=this.max.y=this.max.z=-1/0,this},isEmpty:function(){return this.max.x<this.min.x||this.max.y<this.min.y||this.max.z<this.min.z},getCenter:function(t){var e=t||new v;return this.isEmpty()?e.set(0,0,0):e.addVectors(this.min,this.max).multiplyScalar(.5)},getSize:function(t){var e=t||new v;return this.isEmpty()?e.set(0,0,0):e.subVectors(this.max,this.min)},expandByPoint:function(t){return this.min.min(t),this.max.max(t),this},expandByVector:function(t){return this.min.sub(t),this.max.add(t),this},expandByScalar:function(t){return this.min.addScalar(-t),this.max.addScalar(t),this},expandByObject:function(){var t=new v;return function(e){var i=this;return e.updateMatrixWorld(!0),e.traverse(function(e){var r,n,o=e.geometry;if(void 0!==o)if(o.isGeometry){var a=o.vertices;for(r=0,n=a.length;r<n;r++)t.copy(a[r]),t.applyMatrix4(e.matrixWorld),i.expandByPoint(t)}else if(o.isBufferGeometry){var s=o.attributes.position;if(void 0!==s)for(r=0,n=s.count;r<n;r++)t.fromBufferAttribute(s,r).applyMatrix4(e.matrixWorld),i.expandByPoint(t)}}),this}}(),containsPoint:function(t){return!(t.x<this.min.x||t.x>this.max.x||t.y<this.min.y||t.y>this.max.y||t.z<this.min.z||t.z>this.max.z)},containsBox:function(t){return this.min.x<=t.min.x&&t.max.x<=this.max.x&&this.min.y<=t.min.y&&t.max.y<=this.max.y&&this.min.z<=t.min.z&&t.max.z<=this.max.z},getParameter:function(t,e){return(e||new v).set((t.x-this.min.x)/(this.max.x-this.min.x),(t.y-this.min.y)/(this.max.y-this.min.y),(t.z-this.min.z)/(this.max.z-this.min.z))},intersectsBox:function(t){return!(t.max.x<this.min.x||t.min.x>this.max.x||t.max.y<this.min.y||t.min.y>this.max.y||t.max.z<this.min.z||t.min.z>this.max.z)},intersectsSphere:function(){var t=new v;return function(e){return this.clampPoint(e.center,t),t.distanceToSquared(e.center)<=e.radius*e.radius}}(),intersectsPlane:function(t){var e,i;return t.normal.x>0?(e=t.normal.x*this.min.x,i=t.normal.x*this.max.x):(e=t.normal.x*this.max.x,i=t.normal.x*this.min.x),t.normal.y>0?(e+=t.normal.y*this.min.y,i+=t.normal.y*this.max.y):(e+=t.normal.y*this.max.y,i+=t.normal.y*this.min.y),t.normal.z>0?(e+=t.normal.z*this.min.z,i+=t.normal.z*this.max.z):(e+=t.normal.z*this.max.z,i+=t.normal.z*this.min.z),e<=t.constant&&i>=t.constant},clampPoint:function(t,e){return(e||new v).copy(t).clamp(this.min,this.max)},distanceToPoint:function(){var t=new v;return function(e){return t.copy(e).clamp(this.min,this.max).sub(e).length()}}(),getBoundingSphere:function(){var t=new v;return function(e){var i=e||new ht;return this.getCenter(i.center),i.radius=.5*this.getSize(t).length(),i}}(),intersect:function(t){return this.min.max(t.min),this.max.min(t.max),this.isEmpty()&&this.makeEmpty(),this},union:function(t){return this.min.min(t.min),this.max.max(t.max),this},applyMatrix4:function(){var t=[new v,new v,new v,new v,new v,new v,new v,new v];return function(e){return this.isEmpty()?this:(t[0].set(this.min.x,this.min.y,this.min.z).applyMatrix4(e),t[1].set(this.min.x,this.min.y,this.max.z).applyMatrix4(e),t[2].set(this.min.x,this.max.y,this.min.z).applyMatrix4(e),t[3].set(this.min.x,this.max.y,this.max.z).applyMatrix4(e),t[4].set(this.max.x,this.min.y,this.min.z).applyMatrix4(e),t[5].set(this.max.x,this.min.y,this.max.z).applyMatrix4(e),t[6].set(this.max.x,this.max.y,this.min.z).applyMatrix4(e),t[7].set(this.max.x,this.max.y,this.max.z).applyMatrix4(e),this.setFromPoints(t),this)}}(),translate:function(t){return this.min.add(t),this.max.add(t),this},equals:function(t){return t.min.equals(this.min)&&t.max.equals(this.max)}}),Object.assign(ht.prototype,{set:function(t,e){return this.center.copy(t),this.radius=e,this},setFromPoints:function(){var t=new lt;return function(e,i){var r=this.center;void 0!==i?r.copy(i):t.setFromPoints(e).getCenter(r);for(var n=0,o=0,a=e.length;o<a;o++)n=Math.max(n,r.distanceToSquared(e[o]));return this.radius=Math.sqrt(n),this}}(),clone:function(){return(new this.constructor).copy(this)},copy:function(t){return this.center.copy(t.center),this.radius=t.radius,this},empty:function(){return this.radius<=0},containsPoint:function(t){return t.distanceToSquared(this.center)<=this.radius*this.radius},distanceToPoint:function(t){return t.distanceTo(this.center)-this.radius},intersectsSphere:function(t){var e=this.radius+t.radius;return t.center.distanceToSquared(this.center)<=e*e},intersectsBox:function(t){return t.intersectsSphere(this)},intersectsPlane:function(t){return Math.abs(t.distanceToPoint(this.center))<=this.radius},clampPoint:function(t,e){var i=this.center.distanceToSquared(t),r=e||new v;return r.copy(t),i>this.radius*this.radius&&(r.sub(this.center).normalize(),r.multiplyScalar(this.radius).add(this.center)),r},getBoundingBox:function(t){var e=t||new lt;return e.set(this.center,this.center),e.expandByScalar(this.radius),e},applyMatrix4:function(t){return this.center.applyMatrix4(t),this.radius=this.radius*t.getMaxScaleOnAxis(),this},translate:function(t){return this.center.add(t),this},equals:function(t){return t.center.equals(this.center)&&t.radius===this.radius}}),Object.assign(pt.prototype,{isMatrix3:!0,set:function(t,e,i,r,n,o,a,s,c){var u=this.elements;return u[0]=t,u[1]=r,u[2]=a,u[3]=e,u[4]=n,u[5]=s,u[6]=i,u[7]=o,u[8]=c,this},identity:function(){return this.set(1,0,0,0,1,0,0,0,1),this},clone:function(){return(new this.constructor).fromArray(this.elements)},copy:function(t){var e=this.elements,i=t.elements;return e[0]=i[0],e[1]=i[1],e[2]=i[2],e[3]=i[3],e[4]=i[4],e[5]=i[5],e[6]=i[6],e[7]=i[7],e[8]=i[8],this},setFromMatrix4:function(t){var e=t.elements;return this.set(e[0],e[4],e[8],e[1],e[5],e[9],e[2],e[6],e[10]),this},applyToBufferAttribute:function(){var t=new v;return function(e){for(var i=this,r=0,n=e.count;r<n;r++)t.x=e.getX(r),t.y=e.getY(r),t.z=e.getZ(r),t.applyMatrix3(i),e.setXYZ(r,t.x,t.y,t.z);return e}}(),multiply:function(t){return this.multiplyMatrices(this,t)},premultiply:function(t){return this.multiplyMatrices(t,this)},multiplyMatrices:function(t,e){var i=t.elements,r=e.elements,n=this.elements,o=i[0],a=i[3],s=i[6],c=i[1],u=i[4],l=i[7],h=i[2],p=i[5],d=i[8],f=r[0],m=r[3],g=r[6],v=r[1],y=r[4],b=r[7],x=r[2],_=r[5],w=r[8];return n[0]=o*f+a*v+s*x,n[3]=o*m+a*y+s*_,n[6]=o*g+a*b+s*w,n[1]=c*f+u*v+l*x,n[4]=c*m+u*y+l*_,n[7]=c*g+u*b+l*w,n[2]=h*f+p*v+d*x,n[5]=h*m+p*y+d*_,n[8]=h*g+p*b+d*w,this},multiplyScalar:function(t){var e=this.elements;return e[0]*=t,e[3]*=t,e[6]*=t,e[1]*=t,e[4]*=t,e[7]*=t,e[2]*=t,e[5]*=t,e[8]*=t,this},determinant:function(){var t=this.elements,e=t[0],i=t[1],r=t[2],n=t[3],o=t[4],a=t[5],s=t[6],c=t[7],u=t[8];return e*o*u-e*a*c-i*n*u+i*a*s+r*n*c-r*o*s},getInverse:function(t,e){t&&t.isMatrix4&&console.error("THREE.Matrix3: .getInverse() no longer takes a Matrix4 argument.");var i=t.elements,r=this.elements,n=i[0],o=i[1],a=i[2],s=i[3],c=i[4],u=i[5],l=i[6],h=i[7],p=i[8],d=p*c-u*h,f=u*l-p*s,m=h*s-c*l,g=n*d+o*f+a*m;if(0===g){var v="THREE.Matrix3: .getInverse() can't invert matrix, determinant is 0";if(!0===e)throw new Error(v);return console.warn(v),this.identity()}var y=1/g;return r[0]=d*y,r[1]=(a*h-p*o)*y,r[2]=(u*o-a*c)*y,r[3]=f*y,r[4]=(p*n-a*l)*y,r[5]=(a*s-u*n)*y,r[6]=m*y,r[7]=(o*l-h*n)*y,r[8]=(c*n-o*s)*y,this},transpose:function(){var t,e=this.elements;return t=e[1],e[1]=e[3],e[3]=t,t=e[2],e[2]=e[6],e[6]=t,t=e[5],e[5]=e[7],e[7]=t,this},getNormalMatrix:function(t){return this.setFromMatrix4(t).getInverse(this).transpose()},transposeIntoArray:function(t){var e=this.elements;return t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],this},equals:function(t){for(var e=this.elements,i=t.elements,r=0;r<9;r++)if(e[r]!==i[r])return!1;return!0},fromArray:function(t,e){var i=this;void 0===e&&(e=0);for(var r=0;r<9;r++)i.elements[r]=t[r+e];return this},toArray:function(t,e){void 0===t&&(t=[]),void 0===e&&(e=0);var i=this.elements;return t[e]=i[0],t[e+1]=i[1],t[e+2]=i[2],t[e+3]=i[3],t[e+4]=i[4],t[e+5]=i[5],t[e+6]=i[6],t[e+7]=i[7],t[e+8]=i[8],t}}),Object.assign(dt.prototype,{set:function(t,e){return this.normal.copy(t),this.constant=e,this},setComponents:function(t,e,i,r){return this.normal.set(t,e,i),this.constant=r,this},setFromNormalAndCoplanarPoint:function(t,e){return this.normal.copy(t),this.constant=-e.dot(this.normal),this},setFromCoplanarPoints:function(){var t=new v,e=new v;return function(i,r,n){var o=t.subVectors(n,r).cross(e.subVectors(i,r)).normalize();return this.setFromNormalAndCoplanarPoint(o,i),this}}(),clone:function(){return(new this.constructor).copy(this)},copy:function(t){return this.normal.copy(t.normal),this.constant=t.constant,this},normalize:function(){var t=1/this.normal.length();return this.normal.multiplyScalar(t),this.constant*=t,this},negate:function(){return this.constant*=-1,this.normal.negate(),this},distanceToPoint:function(t){return this.normal.dot(t)+this.constant},distanceToSphere:function(t){return this.distanceToPoint(t.center)-t.radius},projectPoint:function(t,e){return(e||new v).copy(this.normal).multiplyScalar(-this.distanceToPoint(t)).add(t)},intersectLine:function(){var t=new v;return function(e,i){var r=i||new v,n=e.delta(t),o=this.normal.dot(n);if(0!==o){var a=-(e.start.dot(this.normal)+this.constant)/o;if(!(a<0||a>1))return r.copy(n).multiplyScalar(a).add(e.start)}else if(0===this.distanceToPoint(e.start))return r.copy(e.start)}}(),intersectsLine:function(t){var e=this.distanceToPoint(t.start),i=this.distanceToPoint(t.end);return e<0&&i>0||i<0&&e>0},intersectsBox:function(t){return t.intersectsPlane(this)},intersectsSphere:function(t){return t.intersectsPlane(this)},coplanarPoint:function(t){return(t||new v).copy(this.normal).multiplyScalar(-this.constant)},applyMatrix4:function(){var t=new v,e=new pt;return function(i,r){var n=r||e.getNormalMatrix(i),o=this.coplanarPoint(t).applyMatrix4(i),a=this.normal.applyMatrix3(n).normalize();return this.constant=-o.dot(a),this}}(),translate:function(t){return this.constant-=t.dot(this.normal),this},equals:function(t){return t.normal.equals(this.normal)&&t.constant===this.constant}}),Object.assign(ft.prototype,{set:function(t,e,i,r,n,o){var a=this.planes;return a[0].copy(t),a[1].copy(e),a[2].copy(i),a[3].copy(r),a[4].copy(n),a[5].copy(o),this},clone:function(){return(new this.constructor).copy(this)},copy:function(t){for(var e=this.planes,i=0;i<6;i++)e[i].copy(t.planes[i]);return this},setFromMatrix:function(t){var e=this.planes,i=t.elements,r=i[0],n=i[1],o=i[2],a=i[3],s=i[4],c=i[5],u=i[6],l=i[7],h=i[8],p=i[9],d=i[10],f=i[11],m=i[12],g=i[13],v=i[14],y=i[15];return e[0].setComponents(a-r,l-s,f-h,y-m).normalize(),e[1].setComponents(a+r,l+s,f+h,y+m).normalize(),e[2].setComponents(a+n,l+c,f+p,y+g).normalize(),e[3].setComponents(a-n,l-c,f-p,y-g).normalize(),e[4].setComponents(a-o,l-u,f-d,y-v).normalize(),e[5].setComponents(a+o,l+u,f+d,y+v).normalize(),this},intersectsObject:function(){var t=new ht;return function(e){var i=e.geometry;return null===i.boundingSphere&&i.computeBoundingSphere(),t.copy(i.boundingSphere).applyMatrix4(e.matrixWorld),this.intersectsSphere(t)}}(),intersectsSprite:function(){var t=new ht;return function(e){return t.center.set(0,0,0),t.radius=.7071067811865476,t.applyMatrix4(e.matrixWorld),this.intersectsSphere(t)}}(),intersectsSphere:function(t){for(var e=this.planes,i=t.center,r=-t.radius,n=0;n<6;n++)if(e[n].distanceToPoint(i)<r)return!1;return!0},intersectsBox:function(){var t=new v,e=new v;return function(i){for(var r=this.planes,n=0;n<6;n++){var o=r[n];t.x=o.normal.x>0?i.min.x:i.max.x,e.x=o.normal.x>0?i.max.x:i.min.x,t.y=o.normal.y>0?i.min.y:i.max.y,e.y=o.normal.y>0?i.max.y:i.min.y,t.z=o.normal.z>0?i.min.z:i.max.z,e.z=o.normal.z>0?i.max.z:i.min.z;var a=o.distanceToPoint(t),s=o.distanceToPoint(e);if(a<0&&s<0)return!1}return!0}}(),containsPoint:function(t){for(var e=this.planes,i=0;i<6;i++)if(e[i].distanceToPoint(t)<0)return!1;return!0}}),vt.RotationOrders=["XYZ","YZX","ZXY","XZY","YXZ","ZYX"],vt.DefaultOrder="XYZ",Object.defineProperties(vt.prototype,{x:{get:function(){return this._x},set:function(t){this._x=t,this.onChangeCallback()}},y:{get:function(){return this._y},set:function(t){this._y=t,this.onChangeCallback()}},z:{get:function(){return this._z},set:function(t){this._z=t,this.onChangeCallback()}},order:{get:function(){return this._order},set:function(t){this._order=t,this.onChangeCallback()}}}),Object.assign(vt.prototype,{isEuler:!0,set:function(t,e,i,r){return this._x=t,this._y=e,this._z=i,this._order=r||this._order,this.onChangeCallback(),this},clone:function(){return new this.constructor(this._x,this._y,this._z,this._order)},copy:function(t){return this._x=t._x,this._y=t._y,this._z=t._z,this._order=t._order,this.onChangeCallback(),this},setFromRotationMatrix:function(t,e,i){var r=Ap.clamp,n=t.elements,o=n[0],a=n[4],s=n[8],c=n[1],u=n[5],l=n[9],h=n[2],p=n[6],d=n[10];return"XYZ"===(e=e||this._order)?(this._y=Math.asin(r(s,-1,1)),Math.abs(s)<.99999?(this._x=Math.atan2(-l,d),this._z=Math.atan2(-a,o)):(this._x=Math.atan2(p,u),this._z=0)):"YXZ"===e?(this._x=Math.asin(-r(l,-1,1)),Math.abs(l)<.99999?(this._y=Math.atan2(s,d),this._z=Math.atan2(c,u)):(this._y=Math.atan2(-h,o),this._z=0)):"ZXY"===e?(this._x=Math.asin(r(p,-1,1)),Math.abs(p)<.99999?(this._y=Math.atan2(-h,d),this._z=Math.atan2(-a,u)):(this._y=0,this._z=Math.atan2(c,o))):"ZYX"===e?(this._y=Math.asin(-r(h,-1,1)),Math.abs(h)<.99999?(this._x=Math.atan2(p,d),this._z=Math.atan2(c,o)):(this._x=0,this._z=Math.atan2(-a,u))):"YZX"===e?(this._z=Math.asin(r(c,-1,1)),Math.abs(c)<.99999?(this._x=Math.atan2(-l,u),this._y=Math.atan2(-h,o)):(this._x=0,this._y=Math.atan2(s,d))):"XZY"===e?(this._z=Math.asin(-r(a,-1,1)),Math.abs(a)<.99999?(this._x=Math.atan2(p,u),this._y=Math.atan2(s,o)):(this._x=Math.atan2(-l,d),this._y=0)):console.warn("THREE.Euler: .setFromRotationMatrix() given unsupported order: "+e),this._order=e,!1!==i&&this.onChangeCallback(),this},setFromQuaternion:function(){var t=new y;return function(e,i,r){return t.makeRotationFromQuaternion(e),this.setFromRotationMatrix(t,i,r)}}(),setFromVector3:function(t,e){return this.set(t.x,t.y,t.z,e||this._order)},reorder:function(){var t=new g;return function(e){return t.setFromEuler(this),this.setFromQuaternion(t,e)}}(),equals:function(t){return t._x===this._x&&t._y===this._y&&t._z===this._z&&t._order===this._order},fromArray:function(t){return this._x=t[0],this._y=t[1],this._z=t[2],void 0!==t[3]&&(this._order=t[3]),this.onChangeCallback(),this},toArray:function(t,e){return void 0===t&&(t=[]),void 0===e&&(e=0),t[e]=this._x,t[e+1]=this._y,t[e+2]=this._z,t[e+3]=this._order,t},toVector3:function(t){return t?t.set(this._x,this._y,this._z):new v(this._x,this._y,this._z)},onChange:function(t){return this.onChangeCallback=t,this},onChangeCallback:function(){}}),Object.assign(yt.prototype,{set:function(t){this.mask=1<<t|0},enable:function(t){this.mask|=1<<t|0},toggle:function(t){this.mask^=1<<t|0},disable:function(t){this.mask&=~(1<<t|0)},test:function(t){return 0!=(this.mask&t.mask)}});var zp=0;bt.DefaultUp=new v(0,1,0),bt.DefaultMatrixAutoUpdate=!0,Object.assign(bt.prototype,l.prototype,{isObject3D:!0,onBeforeRender:function(){},onAfterRender:function(){},applyMatrix:function(t){this.matrix.multiplyMatrices(t,this.matrix),this.matrix.decompose(this.position,this.quaternion,this.scale)},applyQuaternion:function(t){return this.quaternion.premultiply(t),this},setRotationFromAxisAngle:function(t,e){this.quaternion.setFromAxisAngle(t,e)},setRotationFromEuler:function(t){this.quaternion.setFromEuler(t,!0)},setRotationFromMatrix:function(t){this.quaternion.setFromRotationMatrix(t)},setRotationFromQuaternion:function(t){this.quaternion.copy(t)},rotateOnAxis:function(){var t=new g;return function(e,i){return t.setFromAxisAngle(e,i),this.quaternion.multiply(t),this}}(),rotateX:function(){var t=new v(1,0,0);return function(e){return this.rotateOnAxis(t,e)}}(),rotateY:function(){var t=new v(0,1,0);return function(e){return this.rotateOnAxis(t,e)}}(),rotateZ:function(){var t=new v(0,0,1);return function(e){return this.rotateOnAxis(t,e)}}(),translateOnAxis:function(){var t=new v;return function(e,i){return t.copy(e).applyQuaternion(this.quaternion),this.position.add(t.multiplyScalar(i)),this}}(),translateX:function(){var t=new v(1,0,0);return function(e){return this.translateOnAxis(t,e)}}(),translateY:function(){var t=new v(0,1,0);return function(e){return this.translateOnAxis(t,e)}}(),translateZ:function(){var t=new v(0,0,1);return function(e){return this.translateOnAxis(t,e)}}(),localToWorld:function(t){return t.applyMatrix4(this.matrixWorld)},worldToLocal:function(){var t=new y;return function(e){return e.applyMatrix4(t.getInverse(this.matrixWorld))}}(),lookAt:function(){var t=new y;return function(e){this.isCamera?t.lookAt(this.position,e,this.up):t.lookAt(e,this.position,this.up),this.quaternion.setFromRotationMatrix(t)}}(),add:function(t){var e=arguments,i=this;if(arguments.length>1){for(var r=0;r<arguments.length;r++)i.add(e[r]);return this}return t===this?(console.error("THREE.Object3D.add: object can't be added as a child of itself.",t),this):(t&&t.isObject3D?(null!==t.parent&&t.parent.remove(t),t.parent=this,t.dispatchEvent({type:"added"}),this.children.push(t)):console.error("THREE.Object3D.add: object not an instance of THREE.Object3D.",t),this)},remove:function(t){var e=arguments,i=this;if(arguments.length>1){for(var r=0;r<arguments.length;r++)i.remove(e[r]);return this}var n=this.children.indexOf(t);return-1!==n&&(t.parent=null,t.dispatchEvent({type:"removed"}),this.children.splice(n,1)),this},getObjectById:function(t){return this.getObjectByProperty("id",t)},getObjectByName:function(t){return this.getObjectByProperty("name",t)},getObjectByProperty:function(t,e){var i=this;if(this[t]===e)return this;for(var r=0,n=this.children.length;r<n;r++){var o=i.children[r].getObjectByProperty(t,e);if(void 0!==o)return o}},getWorldPosition:function(t){var e=t||new v;return this.updateMatrixWorld(!0),e.setFromMatrixPosition(this.matrixWorld)},getWorldQuaternion:function(){var t=new v,e=new v;return function(i){var r=i||new g;return this.updateMatrixWorld(!0),this.matrixWorld.decompose(t,r,e),r}}(),getWorldRotation:function(){var t=new g;return function(e){var i=e||new vt;return this.getWorldQuaternion(t),i.setFromQuaternion(t,this.rotation.order,!1)}}(),getWorldScale:function(){var t=new v,e=new g;return function(i){var r=i||new v;return this.updateMatrixWorld(!0),this.matrixWorld.decompose(t,e,r),r}}(),getWorldDirection:function(){var t=new g;return function(e){var i=e||new v;return this.getWorldQuaternion(t),i.set(0,0,1).applyQuaternion(t)}}(),raycast:function(){},traverse:function(t){t(this);for(var e=this.children,i=0,r=e.length;i<r;i++)e[i].traverse(t)},traverseVisible:function(t){if(!1!==this.visible){t(this);for(var e=this.children,i=0,r=e.length;i<r;i++)e[i].traverseVisible(t)}},traverseAncestors:function(t){var e=this.parent;null!==e&&(t(e),e.traverseAncestors(t))},updateMatrix:function(){this.matrix.compose(this.position,this.quaternion,this.scale),this.matrixWorldNeedsUpdate=!0},updateMatrixWorld:function(t){this.matrixAutoUpdate&&this.updateMatrix(),(this.matrixWorldNeedsUpdate||t)&&(null===this.parent?this.matrixWorld.copy(this.matrix):this.matrixWorld.multiplyMatrices(this.parent.matrixWorld,this.matrix),this.matrixWorldNeedsUpdate=!1,t=!0);for(var e=this.children,i=0,r=e.length;i<r;i++)e[i].updateMatrixWorld(t)},toJSON:function(t){function e(e,i){return void 0===e[i.uuid]&&(e[i.uuid]=i.toJSON(t)),i.uuid}function i(t){var e=[];for(var i in t){var r=t[i];delete r.metadata,e.push(r)}return e}var r=this,n=void 0===t||""===t,o={};n&&(t={geometries:{},materials:{},textures:{},images:{}},o.metadata={version:4.5,type:"Object",generator:"Object3D.toJSON"});var a={};if(a.uuid=this.uuid,a.type=this.type,""!==this.name&&(a.name=this.name),!0===this.castShadow&&(a.castShadow=!0),!0===this.receiveShadow&&(a.receiveShadow=!0),!1===this.visible&&(a.visible=!1),"{}"!==JSON.stringify(this.userData)&&(a.userData=this.userData),a.matrix=this.matrix.toArray(),void 0!==this.geometry&&(a.geometry=e(t.geometries,this.geometry)),void 0!==this.material)if(Array.isArray(this.material)){for(var s=[],c=0,u=this.material.length;c<u;c++)s.push(e(t.materials,r.material[c]));a.material=s}else a.material=e(t.materials,this.material);if(this.children.length>0){a.children=[];for(c=0;c<this.children.length;c++)a.children.push(r.children[c].toJSON(t).object)}if(n){var l=i(t.geometries),h=i(t.materials),p=i(t.textures),d=i(t.images);l.length>0&&(o.geometries=l),h.length>0&&(o.materials=h),p.length>0&&(o.textures=p),d.length>0&&(o.images=d)}return o.object=a,o},clone:function(t){return(new this.constructor).copy(this,t)},copy:function(t,e){var i=this;if(void 0===e&&(e=!0),this.name=t.name,this.up.copy(t.up),this.position.copy(t.position),this.quaternion.copy(t.quaternion),this.scale.copy(t.scale),this.matrix.copy(t.matrix),this.matrixWorld.copy(t.matrixWorld),this.matrixAutoUpdate=t.matrixAutoUpdate,this.matrixWorldNeedsUpdate=t.matrixWorldNeedsUpdate,this.layers.mask=t.layers.mask,this.visible=t.visible,this.castShadow=t.castShadow,this.receiveShadow=t.receiveShadow,this.frustumCulled=t.frustumCulled,this.renderOrder=t.renderOrder,this.userData=JSON.parse(JSON.stringify(t.userData)),!0===e)for(var r=0;r<t.children.length;r++){var n=t.children[r];i.add(n.clone())}return this}}),xt.prototype=Object.assign(Object.create(bt.prototype),{constructor:xt,isCamera:!0,copy:function(t,e){return bt.prototype.copy.call(this,t,e),this.matrixWorldInverse.copy(t.matrixWorldInverse),this.projectionMatrix.copy(t.projectionMatrix),this},getWorldDirection:function(){var t=new g;return function(e){var i=e||new v;return this.getWorldQuaternion(t),i.set(0,0,-1).applyQuaternion(t)}}(),updateMatrixWorld:function(t){bt.prototype.updateMatrixWorld.call(this,t),this.matrixWorldInverse.getInverse(this.matrixWorld)},clone:function(){return(new this.constructor).copy(this)}}),_t.prototype=Object.assign(Object.create(xt.prototype),{constructor:_t,isOrthographicCamera:!0,copy:function(t,e){return xt.prototype.copy.call(this,t,e),this.left=t.left,this.right=t.right,this.top=t.top,this.bottom=t.bottom,this.near=t.near,this.far=t.far,this.zoom=t.zoom,this.view=null===t.view?null:Object.assign({},t.view),this},setViewOffset:function(t,e,i,r,n,o){this.view={fullWidth:t,fullHeight:e,offsetX:i,offsetY:r,width:n,height:o},this.updateProjectionMatrix()},clearViewOffset:function(){this.view=null,this.updateProjectionMatrix()},updateProjectionMatrix:function(){var t=(this.right-this.left)/(2*this.zoom),e=(this.top-this.bottom)/(2*this.zoom),i=(this.right+this.left)/2,r=(this.top+this.bottom)/2,n=i-t,o=i+t,a=r+e,s=r-e;if(null!==this.view){var c=this.zoom/(this.view.width/this.view.fullWidth),u=this.zoom/(this.view.height/this.view.fullHeight),l=(this.right-this.left)/this.view.width,h=(this.top-this.bottom)/this.view.height;o=(n+=l*(this.view.offsetX/c))+l*(this.view.width/c),s=(a-=h*(this.view.offsetY/u))-h*(this.view.height/u)}this.projectionMatrix.makeOrthographic(n,o,a,s,this.near,this.far)},toJSON:function(t){var e=bt.prototype.toJSON.call(this,t);return e.object.zoom=this.zoom,e.object.left=this.left,e.object.right=this.right,e.object.top=this.top,e.object.bottom=this.bottom,e.object.near=this.near,e.object.far=this.far,null!==this.view&&(e.object.view=Object.assign({},this.view)),e}}),wt.prototype=Object.assign(Object.create(xt.prototype),{constructor:wt,isPerspectiveCamera:!0,copy:function(t,e){return xt.prototype.copy.call(this,t,e),this.fov=t.fov,this.zoom=t.zoom,this.near=t.near,this.far=t.far,this.focus=t.focus,this.aspect=t.aspect,this.view=null===t.view?null:Object.assign({},t.view),this.filmGauge=t.filmGauge,this.filmOffset=t.filmOffset,this},setFocalLength:function(t){var e=.5*this.getFilmHeight()/t;this.fov=2*Ap.RAD2DEG*Math.atan(e),this.updateProjectionMatrix()},getFocalLength:function(){var t=Math.tan(.5*Ap.DEG2RAD*this.fov);return.5*this.getFilmHeight()/t},getEffectiveFOV:function(){return 2*Ap.RAD2DEG*Math.atan(Math.tan(.5*Ap.DEG2RAD*this.fov)/this.zoom)},getFilmWidth:function(){return this.filmGauge*Math.min(this.aspect,1)},getFilmHeight:function(){return this.filmGauge/Math.max(this.aspect,1)},setViewOffset:function(t,e,i,r,n,o){this.aspect=t/e,this.view={fullWidth:t,fullHeight:e,offsetX:i,offsetY:r,width:n,height:o},this.updateProjectionMatrix()},clearViewOffset:function(){this.view=null,this.updateProjectionMatrix()},updateProjectionMatrix:function(){var t=this.near,e=t*Math.tan(.5*Ap.DEG2RAD*this.fov)/this.zoom,i=2*e,r=this.aspect*i,n=-.5*r,o=this.view;if(null!==o){var a=o.fullWidth,s=o.fullHeight;n+=o.offsetX*r/a,e-=o.offsetY*i/s,r*=o.width/a,i*=o.height/s}var c=this.filmOffset;0!==c&&(n+=t*c/this.getFilmWidth()),this.projectionMatrix.makePerspective(n,n+r,e,e-i,t,this.far)},toJSON:function(t){var e=bt.prototype.toJSON.call(this,t);return e.object.fov=this.fov,e.object.zoom=this.zoom,e.object.near=this.near,e.object.far=this.far,e.object.focus=this.focus,e.object.aspect=this.aspect,null!==this.view&&(e.object.view=Object.assign({},this.view)),e.object.filmGauge=this.filmGauge,e.object.filmOffset=this.filmOffset,e}}),Object.assign(St.prototype,{clone:function(){return(new this.constructor).copy(this)},copy:function(t){var e=this;this.a=t.a,this.b=t.b,this.c=t.c,this.normal.copy(t.normal),this.color.copy(t.color),this.materialIndex=t.materialIndex;for(var i=0,r=t.vertexNormals.length;i<r;i++)e.vertexNormals[i]=t.vertexNormals[i].clone();for(var i=0,r=t.vertexColors.length;i<r;i++)e.vertexColors[i]=t.vertexColors[i].clone();return this}});var Up=0;Object.assign(Mt.prototype,l.prototype,{isGeometry:!0,applyMatrix:function(t){for(var e=this,i=(new pt).getNormalMatrix(t),r=0,n=this.vertices.length;r<n;r++)e.vertices[r].applyMatrix4(t);for(var r=0,n=this.faces.length;r<n;r++){var o=e.faces[r];o.normal.applyMatrix3(i).normalize();for(var a=0,s=o.vertexNormals.length;a<s;a++)o.vertexNormals[a].applyMatrix3(i).normalize()}return null!==this.boundingBox&&this.computeBoundingBox(),null!==this.boundingSphere&&this.computeBoundingSphere(),this.verticesNeedUpdate=!0,this.normalsNeedUpdate=!0,this},rotateX:function(){var t=new y;return function(e){return t.makeRotationX(e),this.applyMatrix(t),this}}(),rotateY:function(){var t=new y;return function(e){return t.makeRotationY(e),this.applyMatrix(t),this}}(),rotateZ:function(){var t=new y;return function(e){return t.makeRotationZ(e),this.applyMatrix(t),this}}(),translate:function(){var t=new y;return function(e,i,r){return t.makeTranslation(e,i,r),this.applyMatrix(t),this}}(),scale:function(){var t=new y;return function(e,i,r){return t.makeScale(e,i,r),this.applyMatrix(t),this}}(),lookAt:function(){var t=new bt;return function(e){t.lookAt(e),t.updateMatrix(),this.applyMatrix(t.matrix)}}(),fromBufferGeometry:function(t){function e(t,e,r,n){var o=new St(t,e,r,void 0!==a?[l[t].clone(),l[e].clone(),l[r].clone()]:[],void 0!==s?[i.colors[t].clone(),i.colors[e].clone(),i.colors[r].clone()]:[],n);i.faces.push(o),void 0!==c&&i.faceVertexUvs[0].push([p[t].clone(),p[e].clone(),p[r].clone()]),void 0!==u&&i.faceVertexUvs[1].push([d[t].clone(),d[e].clone(),d[r].clone()])}var i=this,r=null!==t.index?t.index.array:void 0,n=t.attributes,o=n.position.array,a=void 0!==n.normal?n.normal.array:void 0,s=void 0!==n.color?n.color.array:void 0,c=void 0!==n.uv?n.uv.array:void 0,u=void 0!==n.uv2?n.uv2.array:void 0;void 0!==u&&(this.faceVertexUvs[1]=[]);for(var l=[],p=[],d=[],f=0,m=0;f<o.length;f+=3,m+=2)i.vertices.push(new v(o[f],o[f+1],o[f+2])),void 0!==a&&l.push(new v(a[f],a[f+1],a[f+2])),void 0!==s&&i.colors.push(new et(s[f],s[f+1],s[f+2])),void 0!==c&&p.push(new h(c[m],c[m+1])),void 0!==u&&d.push(new h(u[m],u[m+1]));var g=t.groups;if(g.length>0)for(f=0;f<g.length;f++)for(var y=g[f],b=y.start,m=b,x=b+y.count;m<x;m+=3)void 0!==r?e(r[m],r[m+1],r[m+2],y.materialIndex):e(m,m+1,m+2,y.materialIndex);else if(void 0!==r)for(f=0;f<r.length;f+=3)e(r[f],r[f+1],r[f+2]);else for(f=0;f<o.length/3;f+=3)e(f,f+1,f+2);return this.computeFaceNormals(),null!==t.boundingBox&&(this.boundingBox=t.boundingBox.clone()),null!==t.boundingSphere&&(this.boundingSphere=t.boundingSphere.clone()),this},center:function(){this.computeBoundingBox();var t=this.boundingBox.getCenter().negate();return this.translate(t.x,t.y,t.z),t},normalize:function(){this.computeBoundingSphere();var t=this.boundingSphere.center,e=this.boundingSphere.radius,i=0===e?1:1/e,r=new y;return r.set(i,0,0,-i*t.x,0,i,0,-i*t.y,0,0,i,-i*t.z,0,0,0,1),this.applyMatrix(r),this},computeFaceNormals:function(){for(var t=this,e=new v,i=new v,r=0,n=this.faces.length;r<n;r++){var o=t.faces[r],a=t.vertices[o.a],s=t.vertices[o.b],c=t.vertices[o.c];e.subVectors(c,s),i.subVectors(a,s),e.cross(i),e.normalize(),o.normal.copy(e)}},computeVertexNormals:function(t){var e=this;void 0===t&&(t=!0);var i,r,n,o,a,s;for(s=new Array(this.vertices.length),i=0,r=this.vertices.length;i<r;i++)s[i]=new v;if(t){var c,u,l,h=new v,p=new v;for(n=0,o=this.faces.length;n<o;n++)a=e.faces[n],c=e.vertices[a.a],u=e.vertices[a.b],l=e.vertices[a.c],h.subVectors(l,u),p.subVectors(c,u),h.cross(p),s[a.a].add(h),s[a.b].add(h),s[a.c].add(h)}else for(this.computeFaceNormals(),n=0,o=this.faces.length;n<o;n++)s[(a=e.faces[n]).a].add(a.normal),s[a.b].add(a.normal),s[a.c].add(a.normal);for(i=0,r=this.vertices.length;i<r;i++)s[i].normalize();for(n=0,o=this.faces.length;n<o;n++){var d=(a=e.faces[n]).vertexNormals;3===d.length?(d[0].copy(s[a.a]),d[1].copy(s[a.b]),d[2].copy(s[a.c])):(d[0]=s[a.a].clone(),d[1]=s[a.b].clone(),d[2]=s[a.c].clone())}this.faces.length>0&&(this.normalsNeedUpdate=!0)},computeFlatVertexNormals:function(){var t,e,i,r=this;for(this.computeFaceNormals(),t=0,e=this.faces.length;t<e;t++){var n=(i=r.faces[t]).vertexNormals;3===n.length?(n[0].copy(i.normal),n[1].copy(i.normal),n[2].copy(i.normal)):(n[0]=i.normal.clone(),n[1]=i.normal.clone(),n[2]=i.normal.clone())}this.faces.length>0&&(this.normalsNeedUpdate=!0)},computeMorphNormals:function(){var t,e,i,r,n,o=this;for(i=0,r=this.faces.length;i<r;i++)for((n=o.faces[i]).__originalFaceNormal?n.__originalFaceNormal.copy(n.normal):n.__originalFaceNormal=n.normal.clone(),n.__originalVertexNormals||(n.__originalVertexNormals=[]),t=0,e=n.vertexNormals.length;t<e;t++)n.__originalVertexNormals[t]?n.__originalVertexNormals[t].copy(n.vertexNormals[t]):n.__originalVertexNormals[t]=n.vertexNormals[t].clone();var a=new Mt;for(a.faces=this.faces,t=0,e=this.morphTargets.length;t<e;t++){if(!o.morphNormals[t]){o.morphNormals[t]={},o.morphNormals[t].faceNormals=[],o.morphNormals[t].vertexNormals=[];var s=o.morphNormals[t].faceNormals,c=o.morphNormals[t].vertexNormals;for(i=0,r=this.faces.length;i<r;i++)l=new v,h={a:new v,b:new v,c:new v},s.push(l),c.push(h)}var u=o.morphNormals[t];a.vertices=o.morphTargets[t].vertices,a.computeFaceNormals(),a.computeVertexNormals();var l,h;for(i=0,r=this.faces.length;i<r;i++)n=o.faces[i],l=u.faceNormals[i],h=u.vertexNormals[i],l.copy(n.normal),h.a.copy(n.vertexNormals[0]),h.b.copy(n.vertexNormals[1]),h.c.copy(n.vertexNormals[2])}for(i=0,r=this.faces.length;i<r;i++)(n=o.faces[i]).normal=n.__originalFaceNormal,n.vertexNormals=n.__originalVertexNormals},computeLineDistances:function(){for(var t=this,e=0,i=this.vertices,r=0,n=i.length;r<n;r++)r>0&&(e+=i[r].distanceTo(i[r-1])),t.lineDistances[r]=e},computeBoundingBox:function(){null===this.boundingBox&&(this.boundingBox=new lt),this.boundingBox.setFromPoints(this.vertices)},computeBoundingSphere:function(){null===this.boundingSphere&&(this.boundingSphere=new ht),this.boundingSphere.setFromPoints(this.vertices)},merge:function(t,e,i){if(t&&t.isGeometry){var r,n=this.vertices.length,o=this.vertices,a=t.vertices,s=this.faces,c=t.faces,u=this.faceVertexUvs[0],l=t.faceVertexUvs[0],h=this.colors,p=t.colors;void 0===i&&(i=0),void 0!==e&&(r=(new pt).getNormalMatrix(e));for(var d=0,f=a.length;d<f;d++){var m=a[d].clone();void 0!==e&&m.applyMatrix4(e),o.push(m)}for(var d=0,f=p.length;d<f;d++)h.push(p[d].clone());for(d=0,f=c.length;d<f;d++){var g,v,y,b=c[d],x=b.vertexNormals,_=b.vertexColors;(g=new St(b.a+n,b.b+n,b.c+n)).normal.copy(b.normal),void 0!==r&&g.normal.applyMatrix3(r).normalize();for(var w=0,S=x.length;w<S;w++)v=x[w].clone(),void 0!==r&&v.applyMatrix3(r).normalize(),g.vertexNormals.push(v);g.color.copy(b.color);for(var w=0,S=_.length;w<S;w++)y=_[w],g.vertexColors.push(y.clone());g.materialIndex=b.materialIndex+i,s.push(g)}for(d=0,f=l.length;d<f;d++){var A=l[d],M=[];if(void 0!==A){for(var w=0,S=A.length;w<S;w++)M.push(A[w].clone());u.push(M)}}}else console.error("THREE.Geometry.merge(): geometry not an instance of THREE.Geometry.",t)},mergeMesh:function(t){t&&t.isMesh?(t.matrixAutoUpdate&&t.updateMatrix(),this.merge(t.geometry,t.matrix)):console.error("THREE.Geometry.mergeMesh(): mesh not an instance of THREE.Mesh.",t)},mergeVertices:function(){var t,e,i,r,n,o,a,s,c=this,u={},l=[],h=[],p=Math.pow(10,4);for(i=0,r=this.vertices.length;i<r;i++)t=c.vertices[i],void 0===u[e=Math.round(t.x*p)+"_"+Math.round(t.y*p)+"_"+Math.round(t.z*p)]?(u[e]=i,l.push(c.vertices[i]),h[i]=l.length-1):h[i]=h[u[e]];var d=[];for(i=0,r=this.faces.length;i<r;i++){(n=c.faces[i]).a=h[n.a],n.b=h[n.b],n.c=h[n.c],o=[n.a,n.b,n.c];for(var f=0;f<3;f++)if(o[f]===o[(f+1)%3]){d.push(i);break}}for(i=d.length-1;i>=0;i--){var m=d[i];for(c.faces.splice(m,1),a=0,s=this.faceVertexUvs.length;a<s;a++)c.faceVertexUvs[a].splice(m,1)}var g=this.vertices.length-l.length;return this.vertices=l,g},sortFacesByMaterialIndex:function(){for(var t=this.faces,e=t.length,i=0;i<e;i++)t[i]._id=i;t.sort(function(t,e){return t.materialIndex-e.materialIndex});var r,n,o=this.faceVertexUvs[0],a=this.faceVertexUvs[1];o&&o.length===e&&(r=[]),a&&a.length===e&&(n=[]);for(i=0;i<e;i++){var s=t[i]._id;r&&r.push(o[s]),n&&n.push(a[s])}r&&(this.faceVertexUvs[0]=r),n&&(this.faceVertexUvs[1]=n)},toJSON:function(){function t(t,e,i){return i?t|1<<e:t&~(1<<e)}function e(t){var e=t.x.toString()+t.y.toString()+t.z.toString();return void 0!==d[e]?d[e]:(d[e]=p.length/3,p.push(t.x,t.y,t.z),d[e])}function i(t){var e=t.r.toString()+t.g.toString()+t.b.toString();return void 0!==m[e]?m[e]:(m[e]=f.length,f.push(t.getHex()),m[e])}function r(t){var e=t.x.toString()+t.y.toString();return void 0!==v[e]?v[e]:(v[e]=g.length/2,g.push(t.x,t.y),v[e])}var n=this,o={metadata:{version:4.5,type:"Geometry",generator:"Geometry.toJSON"}};if(o.uuid=this.uuid,o.type=this.type,""!==this.name&&(o.name=this.name),void 0!==this.parameters){var a=this.parameters;for(var s in a)void 0!==a[s]&&(o[s]=a[s]);return o}for(var c=[],u=0;u<this.vertices.length;u++){var l=n.vertices[u];c.push(l.x,l.y,l.z)}for(var h=[],p=[],d={},f=[],m={},g=[],v={},u=0;u<this.faces.length;u++){var y=n.faces[u],b=void 0!==n.faceVertexUvs[0][u],x=y.normal.length()>0,_=y.vertexNormals.length>0,w=1!==y.color.r||1!==y.color.g||1!==y.color.b,S=y.vertexColors.length>0,A=0;if(A=t(A,0,0),A=t(A,1,!0),A=t(A,2,!1),A=t(A,3,b),A=t(A,4,x),A=t(A,5,_),A=t(A,6,w),A=t(A,7,S),h.push(A),h.push(y.a,y.b,y.c),h.push(y.materialIndex),b){var M=n.faceVertexUvs[0][u];h.push(r(M[0]),r(M[1]),r(M[2]))}if(x&&h.push(e(y.normal)),_){var P=y.vertexNormals;h.push(e(P[0]),e(P[1]),e(P[2]))}if(w&&h.push(i(y.color)),S){var E=y.vertexColors;h.push(i(E[0]),i(E[1]),i(E[2]))}}return o.data={},o.data.vertices=c,o.data.normals=p,f.length>0&&(o.data.colors=f),g.length>0&&(o.data.uvs=[g]),o.data.faces=h,o},clone:function(){return(new Mt).copy(this)},copy:function(t){var e,i,r,n,o,a,s=this;this.vertices=[],this.colors=[],this.faces=[],this.faceVertexUvs=[[]],this.morphTargets=[],this.morphNormals=[],this.skinWeights=[],this.skinIndices=[],this.lineDistances=[],this.boundingBox=null,this.boundingSphere=null,this.name=t.name;var c=t.vertices;for(e=0,i=c.length;e<i;e++)s.vertices.push(c[e].clone());var u=t.colors;for(e=0,i=u.length;e<i;e++)s.colors.push(u[e].clone());var l=t.faces;for(e=0,i=l.length;e<i;e++)s.faces.push(l[e].clone());for(e=0,i=t.faceVertexUvs.length;e<i;e++){var h=t.faceVertexUvs[e];for(void 0===s.faceVertexUvs[e]&&(s.faceVertexUvs[e]=[]),r=0,n=h.length;r<n;r++){var p=h[r],d=[];for(o=0,a=p.length;o<a;o++){var f=p[o];d.push(f.clone())}s.faceVertexUvs[e].push(d)}}var m=t.morphTargets;for(e=0,i=m.length;e<i;e++){var g={};if(g.name=m[e].name,void 0!==m[e].vertices)for(g.vertices=[],r=0,n=m[e].vertices.length;r<n;r++)g.vertices.push(m[e].vertices[r].clone());if(void 0!==m[e].normals)for(g.normals=[],r=0,n=m[e].normals.length;r<n;r++)g.normals.push(m[e].normals[r].clone());s.morphTargets.push(g)}var v=t.morphNormals;for(e=0,i=v.length;e<i;e++){var y={};if(void 0!==v[e].vertexNormals)for(y.vertexNormals=[],r=0,n=v[e].vertexNormals.length;r<n;r++){var b=v[e].vertexNormals[r],x={};x.a=b.a.clone(),x.b=b.b.clone(),x.c=b.c.clone(),y.vertexNormals.push(x)}if(void 0!==v[e].faceNormals)for(y.faceNormals=[],r=0,n=v[e].faceNormals.length;r<n;r++)y.faceNormals.push(v[e].faceNormals[r].clone());s.morphNormals.push(y)}var _=t.skinWeights;for(e=0,i=_.length;e<i;e++)s.skinWeights.push(_[e].clone());var w=t.skinIndices;for(e=0,i=w.length;e<i;e++)s.skinIndices.push(w[e].clone());var S=t.lineDistances;for(e=0,i=S.length;e<i;e++)s.lineDistances.push(S[e]);var A=t.boundingBox;null!==A&&(this.boundingBox=A.clone());var M=t.boundingSphere;return null!==M&&(this.boundingSphere=M.clone()),this.elementsNeedUpdate=t.elementsNeedUpdate,this.verticesNeedUpdate=t.verticesNeedUpdate,this.uvsNeedUpdate=t.uvsNeedUpdate,this.normalsNeedUpdate=t.normalsNeedUpdate,this.colorsNeedUpdate=t.colorsNeedUpdate,this.lineDistancesNeedUpdate=t.lineDistancesNeedUpdate,this.groupsNeedUpdate=t.groupsNeedUpdate,this},dispose:function(){this.dispatchEvent({type:"dispose"})}}),Object.defineProperty(Pt.prototype,"needsUpdate",{set:function(t){!0===t&&this.version++}}),Object.assign(Pt.prototype,{isBufferAttribute:!0,setArray:function(t){if(Array.isArray(t))throw new TypeError("THREE.BufferAttribute: array should be a Typed Array.");this.count=void 0!==t?t.length/this.itemSize:0,this.array=t},setDynamic:function(t){return this.dynamic=t,this},copy:function(t){return this.array=new t.array.constructor(t.array),this.itemSize=t.itemSize,this.count=t.count,this.normalized=t.normalized,this.dynamic=t.dynamic,this},copyAt:function(t,e,i){var r=this;t*=this.itemSize,i*=e.itemSize;for(var n=0,o=this.itemSize;n<o;n++)r.array[t+n]=e.array[i+n];return this},copyArray:function(t){return this.array.set(t),this},copyColorsArray:function(t){for(var e=this.array,i=0,r=0,n=t.length;r<n;r++){var o=t[r];void 0===o&&(console.warn("THREE.BufferAttribute.copyColorsArray(): color is undefined",r),o=new et),e[i++]=o.r,e[i++]=o.g,e[i++]=o.b}return this},copyIndicesArray:function(t){for(var e=this.array,i=0,r=0,n=t.length;r<n;r++){var o=t[r];e[i++]=o.a,e[i++]=o.b,e[i++]=o.c}return this},copyVector2sArray:function(t){for(var e=this.array,i=0,r=0,n=t.length;r<n;r++){var o=t[r];void 0===o&&(console.warn("THREE.BufferAttribute.copyVector2sArray(): vector is undefined",r),o=new h),e[i++]=o.x,e[i++]=o.y}return this},copyVector3sArray:function(t){for(var e=this.array,i=0,r=0,n=t.length;r<n;r++){var o=t[r];void 0===o&&(console.warn("THREE.BufferAttribute.copyVector3sArray(): vector is undefined",r),o=new v),e[i++]=o.x,e[i++]=o.y,e[i++]=o.z}return this},copyVector4sArray:function(t){for(var e=this.array,i=0,r=0,n=t.length;r<n;r++){var o=t[r];void 0===o&&(console.warn("THREE.BufferAttribute.copyVector4sArray(): vector is undefined",r),o=new d),e[i++]=o.x,e[i++]=o.y,e[i++]=o.z,e[i++]=o.w}return this},set:function(t,e){return void 0===e&&(e=0),this.array.set(t,e),this},getX:function(t){return this.array[t*this.itemSize]},setX:function(t,e){return this.array[t*this.itemSize]=e,this},getY:function(t){return this.array[t*this.itemSize+1]},setY:function(t,e){return this.array[t*this.itemSize+1]=e,this},getZ:function(t){return this.array[t*this.itemSize+2]},setZ:function(t,e){return this.array[t*this.itemSize+2]=e,this},getW:function(t){return this.array[t*this.itemSize+3]},setW:function(t,e){return this.array[t*this.itemSize+3]=e,this},setXY:function(t,e,i){return t*=this.itemSize,this.array[t+0]=e,this.array[t+1]=i,this},setXYZ:function(t,e,i,r){return t*=this.itemSize,this.array[t+0]=e,this.array[t+1]=i,this.array[t+2]=r,this},setXYZW:function(t,e,i,r,n){return t*=this.itemSize,this.array[t+0]=e,this.array[t+1]=i,this.array[t+2]=r,this.array[t+3]=n,this},onUpload:function(t){return this.onUploadCallback=t,this},clone:function(){return new this.constructor(this.array,this.itemSize).copy(this)}}),(Et.prototype=Object.create(Pt.prototype)).constructor=Et,(Tt.prototype=Object.create(Pt.prototype)).constructor=Tt,(Ct.prototype=Object.create(Pt.prototype)).constructor=Ct,(It.prototype=Object.create(Pt.prototype)).constructor=It,Rt.prototype=Object.create(Pt.prototype),Rt.prototype.constructor=Rt,(Lt.prototype=Object.create(Pt.prototype)).constructor=Lt,Ot.prototype=Object.create(Pt.prototype),Ot.prototype.constructor=Ot,Dt.prototype=Object.create(Pt.prototype),Dt.prototype.constructor=Dt,(Nt.prototype=Object.create(Pt.prototype)).constructor=Nt,Object.assign(kt.prototype,{computeGroups:function(t){for(var e,i=[],r=void 0,n=t.faces,o=0;o<n.length;o++){var a=n[o];a.materialIndex!==r&&(r=a.materialIndex,void 0!==e&&(e.count=3*o-e.start,i.push(e)),e={start:3*o,materialIndex:r})}void 0!==e&&(e.count=3*o-e.start,i.push(e)),this.groups=i},fromGeometry:function(t){var e,i=this,r=t.faces,n=t.vertices,o=t.faceVertexUvs,a=o[0]&&o[0].length>0,s=o[1]&&o[1].length>0,c=t.morphTargets,u=c.length;if(u>0){e=[];for(y=0;y<u;y++)e[y]=[];this.morphTargets.position=e}var l,p=t.morphNormals,d=p.length;if(d>0){l=[];for(y=0;y<d;y++)l[y]=[];this.morphTargets.normal=l}for(var f=t.skinIndices,m=t.skinWeights,g=f.length===n.length,v=m.length===n.length,y=0;y<r.length;y++){var b=r[y];i.vertices.push(n[b.a],n[b.b],n[b.c]);var x=b.vertexNormals;if(3===x.length)i.normals.push(x[0],x[1],x[2]);else{var _=b.normal;i.normals.push(_,_,_)}var w=b.vertexColors;if(3===w.length)i.colors.push(w[0],w[1],w[2]);else{var S=b.color;i.colors.push(S,S,S)}if(!0===a&&(void 0!==(A=o[0][y])?i.uvs.push(A[0],A[1],A[2]):(console.warn("THREE.DirectGeometry.fromGeometry(): Undefined vertexUv ",y),i.uvs.push(new h,new h,new h))),!0===s){var A=o[1][y];void 0!==A?i.uvs2.push(A[0],A[1],A[2]):(console.warn("THREE.DirectGeometry.fromGeometry(): Undefined vertexUv2 ",y),i.uvs2.push(new h,new h,new h))}for(P=0;P<u;P++){var M=c[P].vertices;e[P].push(M[b.a],M[b.b],M[b.c])}for(var P=0;P<d;P++){var E=p[P].vertexNormals[y];l[P].push(E.a,E.b,E.c)}g&&i.skinIndices.push(f[b.a],f[b.b],f[b.c]),v&&i.skinWeights.push(m[b.a],m[b.b],m[b.c])}return this.computeGroups(t),this.verticesNeedUpdate=t.verticesNeedUpdate,this.normalsNeedUpdate=t.normalsNeedUpdate,this.colorsNeedUpdate=t.colorsNeedUpdate,this.uvsNeedUpdate=t.uvsNeedUpdate,this.groupsNeedUpdate=t.groupsNeedUpdate,this}}),Ft.MaxIndex=65535,Object.assign(Ft.prototype,l.prototype,{isBufferGeometry:!0,getIndex:function(){return this.index},setIndex:function(t){Array.isArray(t)?this.index=new(Bt(t)>65535?Ot:Rt)(t,1):this.index=t},addAttribute:function(t,e){return e&&e.isBufferAttribute||e&&e.isInterleavedBufferAttribute?"index"===t?(console.warn("THREE.BufferGeometry.addAttribute: Use .setIndex() for index attribute."),void this.setIndex(e)):(this.attributes[t]=e,this):(console.warn("THREE.BufferGeometry: .addAttribute() now expects ( name, attribute )."),void this.addAttribute(t,new Pt(arguments[1],arguments[2])))},getAttribute:function(t){return this.attributes[t]},removeAttribute:function(t){return delete this.attributes[t],this},addGroup:function(t,e,i){this.groups.push({start:t,count:e,materialIndex:void 0!==i?i:0})},clearGroups:function(){this.groups=[]},setDrawRange:function(t,e){this.drawRange.start=t,this.drawRange.count=e},applyMatrix:function(t){var e=this.attributes.position;void 0!==e&&(t.applyToBufferAttribute(e),e.needsUpdate=!0);var i=this.attributes.normal;return void 0!==i&&((new pt).getNormalMatrix(t).applyToBufferAttribute(i),i.needsUpdate=!0),null!==this.boundingBox&&this.computeBoundingBox(),null!==this.boundingSphere&&this.computeBoundingSphere(),this},rotateX:function(){var t=new y;return function(e){return t.makeRotationX(e),this.applyMatrix(t),this}}(),rotateY:function(){var t=new y;return function(e){return t.makeRotationY(e),this.applyMatrix(t),this}}(),rotateZ:function(){var t=new y;return function(e){return t.makeRotationZ(e),this.applyMatrix(t),this}}(),translate:function(){var t=new y;return function(e,i,r){return t.makeTranslation(e,i,r),this.applyMatrix(t),this}}(),scale:function(){var t=new y;return function(e,i,r){return t.makeScale(e,i,r),this.applyMatrix(t),this}}(),lookAt:function(){var t=new bt;return function(e){t.lookAt(e),t.updateMatrix(),this.applyMatrix(t.matrix)}}(),center:function(){this.computeBoundingBox();var t=this.boundingBox.getCenter().negate();return this.translate(t.x,t.y,t.z),t},setFromObject:function(t){var e=t.geometry;if(t.isPoints||t.isLine){var i=new Dt(3*e.vertices.length,3),r=new Dt(3*e.colors.length,3);if(this.addAttribute("position",i.copyVector3sArray(e.vertices)),this.addAttribute("color",r.copyColorsArray(e.colors)),e.lineDistances&&e.lineDistances.length===e.vertices.length){var n=new Dt(e.lineDistances.length,1);this.addAttribute("lineDistance",n.copyArray(e.lineDistances))}null!==e.boundingSphere&&(this.boundingSphere=e.boundingSphere.clone()),null!==e.boundingBox&&(this.boundingBox=e.boundingBox.clone())}else t.isMesh&&e&&e.isGeometry&&this.fromGeometry(e);return this},updateFromObject:function(t){var e=t.geometry;if(t.isMesh){var i=e.__directGeometry;if(!0===e.elementsNeedUpdate&&(i=void 0,e.elementsNeedUpdate=!1),void 0===i)return this.fromGeometry(e);i.verticesNeedUpdate=e.verticesNeedUpdate,i.normalsNeedUpdate=e.normalsNeedUpdate,i.colorsNeedUpdate=e.colorsNeedUpdate,i.uvsNeedUpdate=e.uvsNeedUpdate,i.groupsNeedUpdate=e.groupsNeedUpdate,e.verticesNeedUpdate=!1,e.normalsNeedUpdate=!1,e.colorsNeedUpdate=!1,e.uvsNeedUpdate=!1,e.groupsNeedUpdate=!1,e=i}var r;return!0===e.verticesNeedUpdate&&(void 0!==(r=this.attributes.position)&&(r.copyVector3sArray(e.vertices),r.needsUpdate=!0),e.verticesNeedUpdate=!1),!0===e.normalsNeedUpdate&&(void 0!==(r=this.attributes.normal)&&(r.copyVector3sArray(e.normals),r.needsUpdate=!0),e.normalsNeedUpdate=!1),!0===e.colorsNeedUpdate&&(void 0!==(r=this.attributes.color)&&(r.copyColorsArray(e.colors),r.needsUpdate=!0),e.colorsNeedUpdate=!1),e.uvsNeedUpdate&&(void 0!==(r=this.attributes.uv)&&(r.copyVector2sArray(e.uvs),r.needsUpdate=!0),e.uvsNeedUpdate=!1),e.lineDistancesNeedUpdate&&(void 0!==(r=this.attributes.lineDistance)&&(r.copyArray(e.lineDistances),r.needsUpdate=!0),e.lineDistancesNeedUpdate=!1),e.groupsNeedUpdate&&(e.computeGroups(t.geometry),this.groups=e.groups,e.groupsNeedUpdate=!1),this},fromGeometry:function(t){return t.__directGeometry=(new kt).fromGeometry(t),this.fromDirectGeometry(t.__directGeometry)},fromDirectGeometry:function(t){var e=this,i=new Float32Array(3*t.vertices.length);if(this.addAttribute("position",new Pt(i,3).copyVector3sArray(t.vertices)),t.normals.length>0){var r=new Float32Array(3*t.normals.length);this.addAttribute("normal",new Pt(r,3).copyVector3sArray(t.normals))}if(t.colors.length>0){var n=new Float32Array(3*t.colors.length);this.addAttribute("color",new Pt(n,3).copyColorsArray(t.colors))}if(t.uvs.length>0){var o=new Float32Array(2*t.uvs.length);this.addAttribute("uv",new Pt(o,2).copyVector2sArray(t.uvs))}if(t.uvs2.length>0){var a=new Float32Array(2*t.uvs2.length);this.addAttribute("uv2",new Pt(a,2).copyVector2sArray(t.uvs2))}if(t.indices.length>0){var s=new(Bt(t.indices)>65535?Uint32Array:Uint16Array)(3*t.indices.length);this.setIndex(new Pt(s,1).copyIndicesArray(t.indices))}this.groups=t.groups;for(var c in t.morphTargets){for(var u=[],l=t.morphTargets[c],h=0,p=l.length;h<p;h++){var d=l[h],f=new Dt(3*d.length,3);u.push(f.copyVector3sArray(d))}e.morphAttributes[c]=u}if(t.skinIndices.length>0){var m=new Dt(4*t.skinIndices.length,4);this.addAttribute("skinIndex",m.copyVector4sArray(t.skinIndices))}if(t.skinWeights.length>0){var g=new Dt(4*t.skinWeights.length,4);this.addAttribute("skinWeight",g.copyVector4sArray(t.skinWeights))}return null!==t.boundingSphere&&(this.boundingSphere=t.boundingSphere.clone()),null!==t.boundingBox&&(this.boundingBox=t.boundingBox.clone()),this},computeBoundingBox:function(){null===this.boundingBox&&(this.boundingBox=new lt);var t=this.attributes.position;void 0!==t?this.boundingBox.setFromBufferAttribute(t):this.boundingBox.makeEmpty(),(isNaN(this.boundingBox.min.x)||isNaN(this.boundingBox.min.y)||isNaN(this.boundingBox.min.z))&&console.error('THREE.BufferGeometry.computeBoundingBox: Computed min/max have NaN values. The "position" attribute is likely to have NaN values.',this)},computeBoundingSphere:function(){var t=new lt,e=new v;return function(){null===this.boundingSphere&&(this.boundingSphere=new ht);var i=this.attributes.position;if(i){var r=this.boundingSphere.center;t.setFromBufferAttribute(i),t.getCenter(r);for(var n=0,o=0,a=i.count;o<a;o++)e.x=i.getX(o),e.y=i.getY(o),e.z=i.getZ(o),n=Math.max(n,r.distanceToSquared(e));this.boundingSphere.radius=Math.sqrt(n),isNaN(this.boundingSphere.radius)&&console.error('THREE.BufferGeometry.computeBoundingSphere(): Computed radius is NaN. The "position" attribute is likely to have NaN values.',this)}}}(),computeFaceNormals:function(){},computeVertexNormals:function(){var t=this.index,e=this.attributes,i=this.groups;if(e.position){var r=e.position.array;if(void 0===e.normal)this.addAttribute("normal",new Pt(new Float32Array(r.length),3));else for(var n=e.normal.array,o=0,a=n.length;o<a;o++)n[o]=0;var s,c,u,l=e.normal.array,h=new v,p=new v,d=new v,f=new v,m=new v;if(t){var g=t.array;0===i.length&&this.addGroup(0,g.length);for(var y=0,b=i.length;y<b;++y)for(var x=i[y],_=x.start,o=_,a=_+x.count;o<a;o+=3)s=3*g[o+0],c=3*g[o+1],u=3*g[o+2],h.fromArray(r,s),p.fromArray(r,c),d.fromArray(r,u),f.subVectors(d,p),m.subVectors(h,p),f.cross(m),l[s]+=f.x,l[s+1]+=f.y,l[s+2]+=f.z,l[c]+=f.x,l[c+1]+=f.y,l[c+2]+=f.z,l[u]+=f.x,l[u+1]+=f.y,l[u+2]+=f.z}else for(var o=0,a=r.length;o<a;o+=9)h.fromArray(r,o),p.fromArray(r,o+3),d.fromArray(r,o+6),f.subVectors(d,p),m.subVectors(h,p),f.cross(m),l[o]=f.x,l[o+1]=f.y,l[o+2]=f.z,l[o+3]=f.x,l[o+4]=f.y,l[o+5]=f.z,l[o+6]=f.x,l[o+7]=f.y,l[o+8]=f.z;this.normalizeNormals(),e.normal.needsUpdate=!0}},merge:function(t,e){if(t&&t.isBufferGeometry){void 0===e&&(e=0);var i=this.attributes;for(var r in i)if(void 0!==t.attributes[r])for(var n=i[r].array,o=t.attributes[r],a=o.array,s=0,c=o.itemSize*e;s<a.length;s++,c++)n[c]=a[s];return this}console.error("THREE.BufferGeometry.merge(): geometry not an instance of THREE.BufferGeometry.",t)},normalizeNormals:function(){var t=new v;return function(){for(var e=this.attributes.normal,i=0,r=e.count;i<r;i++)t.x=e.getX(i),t.y=e.getY(i),t.z=e.getZ(i),t.normalize(),e.setXYZ(i,t.x,t.y,t.z)}}(),toNonIndexed:function(){if(null===this.index)return console.warn("THREE.BufferGeometry.toNonIndexed(): Geometry is already non-indexed."),this;var t=new Ft,e=this.index.array,i=this.attributes;for(var r in i){for(var n=i[r],o=n.array,a=n.itemSize,s=new o.constructor(e.length*a),c=0,u=0,l=0,h=e.length;l<h;l++){c=e[l]*a;for(var p=0;p<a;p++)s[u++]=o[c++]}t.addAttribute(r,new Pt(s,a))}return t},toJSON:function(){var t={metadata:{version:4.5,type:"BufferGeometry",generator:"BufferGeometry.toJSON"}};if(t.uuid=this.uuid,t.type=this.type,""!==this.name&&(t.name=this.name),void 0!==this.parameters){var e=this.parameters;for(var i in e)void 0!==e[i]&&(t[i]=e[i]);return t}t.data={attributes:{}};var r=this.index;if(null!==r){a=Array.prototype.slice.call(r.array);t.data.index={type:r.array.constructor.name,array:a}}var n=this.attributes;for(var i in n){var o=n[i],a=Array.prototype.slice.call(o.array);t.data.attributes[i]={itemSize:o.itemSize,type:o.array.constructor.name,array:a,normalized:o.normalized}}var s=this.groups;s.length>0&&(t.data.groups=JSON.parse(JSON.stringify(s)));var c=this.boundingSphere;return null!==c&&(t.data.boundingSphere={center:c.center.toArray(),radius:c.radius}),t},clone:function(){return(new Ft).copy(this)},copy:function(t){var e,i,r,n=this;this.index=null,this.attributes={},this.morphAttributes={},this.groups=[],this.boundingBox=null,this.boundingSphere=null,this.name=t.name;var o=t.index;null!==o&&this.setIndex(o.clone());var a=t.attributes;for(e in a){var s=a[e];n.addAttribute(e,s.clone())}var c=t.morphAttributes;for(e in c){var u=[],l=c[e];for(i=0,r=l.length;i<r;i++)u.push(l[i].clone());n.morphAttributes[e]=u}var h=t.groups;for(i=0,r=h.length;i<r;i++){var p=h[i];n.addGroup(p.start,p.count,p.materialIndex)}var d=t.boundingBox;null!==d&&(this.boundingBox=d.clone());var f=t.boundingSphere;return null!==f&&(this.boundingSphere=f.clone()),this.drawRange.start=t.drawRange.start,this.drawRange.count=t.drawRange.count,this},dispose:function(){this.dispatchEvent({type:"dispose"})}}),(zt.prototype=Object.create(Mt.prototype)).constructor=zt,Ut.prototype=Object.create(Ft.prototype),Ut.prototype.constructor=Ut,jt.prototype=Object.create(Mt.prototype),jt.prototype.constructor=jt,Vt.prototype=Object.create(Ft.prototype),Vt.prototype.constructor=Vt,Gt.prototype=Object.create(at.prototype),Gt.prototype.constructor=Gt,Gt.prototype.isMeshBasicMaterial=!0,Gt.prototype.copy=function(t){return at.prototype.copy.call(this,t),this.color.copy(t.color),this.map=t.map,this.lightMap=t.lightMap,this.lightMapIntensity=t.lightMapIntensity,this.aoMap=t.aoMap,this.aoMapIntensity=t.aoMapIntensity,this.specularMap=t.specularMap,this.alphaMap=t.alphaMap,this.envMap=t.envMap,this.combine=t.combine,this.reflectivity=t.reflectivity,this.refractionRatio=t.refractionRatio,this.wireframe=t.wireframe,this.wireframeLinewidth=t.wireframeLinewidth,this.wireframeLinecap=t.wireframeLinecap,this.wireframeLinejoin=t.wireframeLinejoin,this.skinning=t.skinning,this.morphTargets=t.morphTargets,this},Object.assign($t.prototype,{set:function(t,e){return this.origin.copy(t),this.direction.copy(e),this},clone:function(){return(new this.constructor).copy(this)},copy:function(t){return this.origin.copy(t.origin),this.direction.copy(t.direction),this},at:function(t,e){return(e||new v).copy(this.direction).multiplyScalar(t).add(this.origin)},lookAt:function(t){return this.direction.copy(t).sub(this.origin).normalize(),this},recast:function(){var t=new v;return function(e){return this.origin.copy(this.at(e,t)),this}}(),closestPointToPoint:function(t,e){var i=e||new v;i.subVectors(t,this.origin);var r=i.dot(this.direction);return r<0?i.copy(this.origin):i.copy(this.direction).multiplyScalar(r).add(this.origin)},distanceToPoint:function(t){return Math.sqrt(this.distanceSqToPoint(t))},distanceSqToPoint:function(){var t=new v;return function(e){var i=t.subVectors(e,this.origin).dot(this.direction);return i<0?this.origin.distanceToSquared(e):(t.copy(this.direction).multiplyScalar(i).add(this.origin),t.distanceToSquared(e))}}(),distanceSqToSegment:function(){var t=new v,e=new v,i=new v;return function(r,n,o,a){t.copy(r).add(n).multiplyScalar(.5),e.copy(n).sub(r).normalize(),i.copy(this.origin).sub(t);var s,c,u,l,h=.5*r.distanceTo(n),p=-this.direction.dot(e),d=i.dot(this.direction),f=-i.dot(e),m=i.lengthSq(),g=Math.abs(1-p*p);if(g>0)if(s=p*f-d,c=p*d-f,l=h*g,s>=0)if(c>=-l)if(c<=l){var v=1/g;u=(s*=v)*(s+p*(c*=v)+2*d)+c*(p*s+c+2*f)+m}else c=h,u=-(s=Math.max(0,-(p*c+d)))*s+c*(c+2*f)+m;else c=-h,u=-(s=Math.max(0,-(p*c+d)))*s+c*(c+2*f)+m;else c<=-l?u=-(s=Math.max(0,-(-p*h+d)))*s+(c=s>0?-h:Math.min(Math.max(-h,-f),h))*(c+2*f)+m:c<=l?(s=0,u=(c=Math.min(Math.max(-h,-f),h))*(c+2*f)+m):u=-(s=Math.max(0,-(p*h+d)))*s+(c=s>0?h:Math.min(Math.max(-h,-f),h))*(c+2*f)+m;else c=p>0?-h:h,u=-(s=Math.max(0,-(p*c+d)))*s+c*(c+2*f)+m;return o&&o.copy(this.direction).multiplyScalar(s).add(this.origin),a&&a.copy(e).multiplyScalar(c).add(t),u}}(),intersectSphere:function(){var t=new v;return function(e,i){t.subVectors(e.center,this.origin);var r=t.dot(this.direction),n=t.dot(t)-r*r,o=e.radius*e.radius;if(n>o)return null;var a=Math.sqrt(o-n),s=r-a,c=r+a;return s<0&&c<0?null:s<0?this.at(c,i):this.at(s,i)}}(),intersectsSphere:function(t){return this.distanceToPoint(t.center)<=t.radius},distanceToPlane:function(t){var e=t.normal.dot(this.direction);if(0===e)return 0===t.distanceToPoint(this.origin)?0:null;var i=-(this.origin.dot(t.normal)+t.constant)/e;return i>=0?i:null},intersectPlane:function(t,e){var i=this.distanceToPlane(t);return null===i?null:this.at(i,e)},intersectsPlane:function(t){var e=t.distanceToPoint(this.origin);return 0===e||t.normal.dot(this.direction)*e<0},intersectBox:function(t,e){var i,r,n,o,a,s,c=1/this.direction.x,u=1/this.direction.y,l=1/this.direction.z,h=this.origin;return c>=0?(i=(t.min.x-h.x)*c,r=(t.max.x-h.x)*c):(i=(t.max.x-h.x)*c,r=(t.min.x-h.x)*c),u>=0?(n=(t.min.y-h.y)*u,o=(t.max.y-h.y)*u):(n=(t.max.y-h.y)*u,o=(t.min.y-h.y)*u),i>o||n>r?null:((n>i||i!==i)&&(i=n),(o<r||r!==r)&&(r=o),l>=0?(a=(t.min.z-h.z)*l,s=(t.max.z-h.z)*l):(a=(t.max.z-h.z)*l,s=(t.min.z-h.z)*l),i>s||a>r?null:((a>i||i!==i)&&(i=a),(s<r||r!==r)&&(r=s),r<0?null:this.at(i>=0?i:r,e)))},intersectsBox:function(){var t=new v;return function(e){return null!==this.intersectBox(e,t)}}(),intersectTriangle:function(){var t=new v,e=new v,i=new v,r=new v;return function(n,o,a,s,c){e.subVectors(o,n),i.subVectors(a,n),r.crossVectors(e,i);var u,l=this.direction.dot(r);if(l>0){if(s)return null;u=1}else{if(!(l<0))return null;u=-1,l=-l}t.subVectors(this.origin,n);var h=u*this.direction.dot(i.crossVectors(t,i));if(h<0)return null;var p=u*this.direction.dot(e.cross(t));if(p<0)return null;if(h+p>l)return null;var d=-u*t.dot(r);return d<0?null:this.at(d/l,c)}}(),applyMatrix4:function(t){return this.origin.applyMatrix4(t),this.direction.transformDirection(t),this},equals:function(t){return t.origin.equals(this.origin)&&t.direction.equals(this.direction)}}),Object.assign(Ht.prototype,{set:function(t,e){return this.start.copy(t),this.end.copy(e),this},clone:function(){return(new this.constructor).copy(this)},copy:function(t){return this.start.copy(t.start),this.end.copy(t.end),this},getCenter:function(t){return(t||new v).addVectors(this.start,this.end).multiplyScalar(.5)},delta:function(t){return(t||new v).subVectors(this.end,this.start)},distanceSq:function(){return this.start.distanceToSquared(this.end)},distance:function(){return this.start.distanceTo(this.end)},at:function(t,e){var i=e||new v;return this.delta(i).multiplyScalar(t).add(this.start)},closestPointToPointParameter:function(){var t=new v,e=new v;return function(i,r){t.subVectors(i,this.start),e.subVectors(this.end,this.start);var n=e.dot(e),o=e.dot(t)/n;return r&&(o=Ap.clamp(o,0,1)),o}}(),closestPointToPoint:function(t,e,i){var r=this.closestPointToPointParameter(t,e),n=i||new v;return this.delta(n).multiplyScalar(r).add(this.start)},applyMatrix4:function(t){return this.start.applyMatrix4(t),this.end.applyMatrix4(t),this},equals:function(t){return t.start.equals(this.start)&&t.end.equals(this.end)}}),Object.assign(Wt,{normal:function(){var t=new v;return function(e,i,r,n){var o=n||new v;o.subVectors(r,i),t.subVectors(e,i),o.cross(t);var a=o.lengthSq();return a>0?o.multiplyScalar(1/Math.sqrt(a)):o.set(0,0,0)}}(),barycoordFromPoint:function(){var t=new v,e=new v,i=new v;return function(r,n,o,a,s){t.subVectors(a,n),e.subVectors(o,n),i.subVectors(r,n);var c=t.dot(t),u=t.dot(e),l=t.dot(i),h=e.dot(e),p=e.dot(i),d=c*h-u*u,f=s||new v;if(0===d)return f.set(-2,-1,-1);var m=1/d,g=(h*l-u*p)*m,y=(c*p-u*l)*m;return f.set(1-g-y,y,g)}}(),containsPoint:function(){var t=new v;return function(e,i,r,n){var o=Wt.barycoordFromPoint(e,i,r,n,t);return o.x>=0&&o.y>=0&&o.x+o.y<=1}}()}),Object.assign(Wt.prototype,{set:function(t,e,i){return this.a.copy(t),this.b.copy(e),this.c.copy(i),this},setFromPointsAndIndices:function(t,e,i,r){return this.a.copy(t[e]),this.b.copy(t[i]),this.c.copy(t[r]),this},clone:function(){return(new this.constructor).copy(this)},copy:function(t){return this.a.copy(t.a),this.b.copy(t.b),this.c.copy(t.c),this},area:function(){var t=new v,e=new v;return function(){return t.subVectors(this.c,this.b),e.subVectors(this.a,this.b),.5*t.cross(e).length()}}(),midpoint:function(t){return(t||new v).addVectors(this.a,this.b).add(this.c).multiplyScalar(1/3)},normal:function(t){return Wt.normal(this.a,this.b,this.c,t)},plane:function(t){return(t||new dt).setFromCoplanarPoints(this.a,this.b,this.c)},barycoordFromPoint:function(t,e){return Wt.barycoordFromPoint(t,this.a,this.b,this.c,e)},containsPoint:function(t){return Wt.containsPoint(t,this.a,this.b,this.c)},closestPointToPoint:function(){var t=new dt,e=[new Ht,new Ht,new Ht],i=new v,r=new v;return function(n,o){var a=o||new v,s=1/0;if(t.setFromCoplanarPoints(this.a,this.b,this.c),t.projectPoint(n,i),!0===this.containsPoint(i))a.copy(i);else{e[0].set(this.a,this.b),e[1].set(this.b,this.c),e[2].set(this.c,this.a);for(var c=0;c<e.length;c++){e[c].closestPointToPoint(i,!0,r);var u=i.distanceToSquared(r);u<s&&(s=u,a.copy(r))}}return a}}(),equals:function(t){return t.a.equals(this.a)&&t.b.equals(this.b)&&t.c.equals(this.c)}}),Xt.prototype=Object.assign(Object.create(bt.prototype),{constructor:Xt,isMesh:!0,setDrawMode:function(t){this.drawMode=t},copy:function(t){return bt.prototype.copy.call(this,t),this.drawMode=t.drawMode,this},updateMorphTargets:function(){var t,e,i,r=this,n=this.geometry;if(n.isBufferGeometry){var o=n.morphAttributes,a=Object.keys(o);if(a.length>0){var s=o[a[0]];if(void 0!==s)for(this.morphTargetInfluences=[],this.morphTargetDictionary={},t=0,e=s.length;t<e;t++)i=s[t].name||String(t),r.morphTargetInfluences.push(0),r.morphTargetDictionary[i]=t}}else{var c=n.morphTargets;if(void 0!==c&&c.length>0)for(this.morphTargetInfluences=[],this.morphTargetDictionary={},t=0,e=c.length;t<e;t++)i=c[t].name||String(t),r.morphTargetInfluences.push(0),r.morphTargetDictionary[i]=t}},raycast:function(){function t(t,e,i,r,n,o,a){return Wt.barycoordFromPoint(t,e,i,r,g),n.multiplyScalar(g.x),o.multiplyScalar(g.y),a.multiplyScalar(g.z),n.add(o).add(a),n.clone()}function e(t,e,i,r,n,o,a,s){if(null===(e.side===Rl?r.intersectTriangle(a,o,n,!0,s):r.intersectTriangle(n,o,a,e.side!==Ll,s)))return null;x.copy(s),x.applyMatrix4(t.matrixWorld);var c=i.ray.origin.distanceTo(x);return c<i.near||c>i.far?null:{distance:c,point:x.clone(),object:t}}function i(i,r,n,o,u,l,h,p){a.fromBufferAttribute(o,l),s.fromBufferAttribute(o,h),c.fromBufferAttribute(o,p);var g=e(i,i.material,r,n,a,s,c,b);return g&&(u&&(d.fromBufferAttribute(u,l),f.fromBufferAttribute(u,h),m.fromBufferAttribute(u,p),g.uv=t(b,a,s,c,d,f,m)),g.face=new St(l,h,p,Wt.normal(a,s,c)),g.faceIndex=l),g}var r=new y,n=new $t,o=new ht,a=new v,s=new v,c=new v,u=new v,l=new v,p=new v,d=new h,f=new h,m=new h,g=new v,b=new v,x=new v;return function(h,g){var v=this,y=this.geometry,x=this.material,_=this.matrixWorld;if(void 0!==x&&(null===y.boundingSphere&&y.computeBoundingSphere(),o.copy(y.boundingSphere),o.applyMatrix4(_),!1!==h.ray.intersectsSphere(o)&&(r.getInverse(_),n.copy(h.ray).applyMatrix4(r),null===y.boundingBox||!1!==n.intersectsBox(y.boundingBox)))){var w;if(y.isBufferGeometry){var S,A,M,P,E,T=y.index,C=y.attributes.position,I=y.attributes.uv;if(null!==T)for(P=0,E=T.count;P<E;P+=3)S=T.getX(P),A=T.getX(P+1),M=T.getX(P+2),(w=i(v,h,n,C,I,S,A,M))&&(w.faceIndex=Math.floor(P/3),g.push(w));else for(P=0,E=C.count;P<E;P+=3)(w=i(v,h,n,C,I,S=P,A=P+1,M=P+2))&&(w.index=S,g.push(w))}else if(y.isGeometry){var R,L,O,D,N=Array.isArray(x),k=y.vertices,B=y.faces,F=y.faceVertexUvs[0];F.length>0&&(D=F);for(var z=0,U=B.length;z<U;z++){var j=B[z],V=N?x[j.materialIndex]:x;if(void 0!==V){if(R=k[j.a],L=k[j.b],O=k[j.c],!0===V.morphTargets){var G=y.morphTargets,$=v.morphTargetInfluences;a.set(0,0,0),s.set(0,0,0),c.set(0,0,0);for(var H=0,W=G.length;H<W;H++){var X=$[H];if(0!==X){var q=G[H].vertices;a.addScaledVector(u.subVectors(q[j.a],R),X),s.addScaledVector(l.subVectors(q[j.b],L),X),c.addScaledVector(p.subVectors(q[j.c],O),X)}}a.add(R),s.add(L),c.add(O),R=a,L=s,O=c}if(w=e(v,V,h,n,R,L,O,b)){if(D&&D[z]){var Y=D[z];d.copy(Y[0]),f.copy(Y[1]),m.copy(Y[2]),w.uv=t(b,R,L,O,d,f,m)}w.face=j,w.faceIndex=z,g.push(w)}}}}}}}(),clone:function(){return new this.constructor(this.geometry,this.material).copy(this)}});var jp=0;Pe.prototype=Object.assign(Object.create(wt.prototype),{constructor:Pe,isArrayCamera:!0}),Le.prototype.isFogExp2=!0,Le.prototype.clone=function(){return new Le(this.color.getHex(),this.density)},Le.prototype.toJSON=function(t){return{type:"FogExp2",color:this.color.getHex(),density:this.density}},Oe.prototype.isFog=!0,Oe.prototype.clone=function(){return new Oe(this.color.getHex(),this.near,this.far)},Oe.prototype.toJSON=function(t){return{type:"Fog",color:this.color.getHex(),near:this.near,far:this.far}},De.prototype=Object.assign(Object.create(bt.prototype),{constructor:De,copy:function(t,e){return bt.prototype.copy.call(this,t,e),null!==t.background&&(this.background=t.background.clone()),null!==t.fog&&(this.fog=t.fog.clone()),null!==t.overrideMaterial&&(this.overrideMaterial=t.overrideMaterial.clone()),this.autoUpdate=t.autoUpdate,this.matrixAutoUpdate=t.matrixAutoUpdate,this},toJSON:function(t){var e=bt.prototype.toJSON.call(this,t);return null!==this.background&&(e.object.background=this.background.toJSON(t)),null!==this.fog&&(e.object.fog=this.fog.toJSON()),e}}),Ne.prototype=Object.assign(Object.create(bt.prototype),{constructor:Ne,isLensFlare:!0,copy:function(t){var e=this;bt.prototype.copy.call(this,t),this.positionScreen.copy(t.positionScreen),this.customUpdateCallback=t.customUpdateCallback;for(var i=0,r=t.lensFlares.length;i<r;i++)e.lensFlares.push(t.lensFlares[i]);return this},add:function(t,e,i,r,n,o){void 0===e&&(e=-1),void 0===i&&(i=0),void 0===o&&(o=1),void 0===n&&(n=new et(16777215)),void 0===r&&(r=Bl),i=Math.min(i,Math.max(0,i)),this.lensFlares.push({texture:t,size:e,distance:i,x:0,y:0,z:0,scale:1,rotation:0,opacity:o,color:n,blending:r})},updateLensFlares:function(){var t,e,i=this,r=this.lensFlares.length,n=2*-this.positionScreen.x,o=2*-this.positionScreen.y;for(t=0;t<r;t++)(e=i.lensFlares[t]).x=i.positionScreen.x+n*e.distance,e.y=i.positionScreen.y+o*e.distance,e.wantedRotation=e.x*Math.PI*.25,e.rotation+=.25*(e.wantedRotation-e.rotation)}}),ke.prototype=Object.create(at.prototype),ke.prototype.constructor=ke,ke.prototype.isSpriteMaterial=!0,ke.prototype.copy=function(t){return at.prototype.copy.call(this,t),this.color.copy(t.color),this.map=t.map,this.rotation=t.rotation,this},Be.prototype=Object.assign(Object.create(bt.prototype),{constructor:Be,isSprite:!0,raycast:function(){var t=new v,e=new v,i=new v;return function(r,n){e.setFromMatrixPosition(this.matrixWorld),r.ray.closestPointToPoint(e,t),i.setFromMatrixScale(this.matrixWorld);var o=i.x*i.y/4;if(!(e.distanceToSquared(t)>o)){var a=r.ray.origin.distanceTo(t);a<r.near||a>r.far||n.push({distance:a,point:t.clone(),face:null,object:this})}}}(),clone:function(){return new this.constructor(this.material).copy(this)}}),Fe.prototype=Object.assign(Object.create(bt.prototype),{constructor:Fe,copy:function(t){var e=this;bt.prototype.copy.call(this,t,!1);for(var i=t.levels,r=0,n=i.length;r<n;r++){var o=i[r];e.addLevel(o.object.clone(),o.distance)}return this},addLevel:function(t,e){void 0===e&&(e=0),e=Math.abs(e);for(var i=this.levels,r=0;r<i.length&&!(e<i[r].distance);r++);i.splice(r,0,{distance:e,object:t}),this.add(t)},getObjectForDistance:function(t){for(var e=this.levels,i=1,r=e.length;i<r&&!(t<e[i].distance);i++);return e[i-1].object},raycast:function(){var t=new v;return function(e,i){t.setFromMatrixPosition(this.matrixWorld);var r=e.ray.origin.distanceTo(t);this.getObjectForDistance(r).raycast(e,i)}}(),update:function(){var t=new v,e=new v;return function(i){var r=this.levels;if(r.length>1){t.setFromMatrixPosition(i.matrixWorld),e.setFromMatrixPosition(this.matrixWorld);var n=t.distanceTo(e);r[0].object.visible=!0;for(var o=1,a=r.length;o<a&&n>=r[o].distance;o++)r[o-1].object.visible=!1,r[o].object.visible=!0;for(;o<a;o++)r[o].object.visible=!1}}}(),toJSON:function(t){var e=bt.prototype.toJSON.call(this,t);e.object.levels=[];for(var i=this.levels,r=0,n=i.length;r<n;r++){var o=i[r];e.object.levels.push({object:o.object.uuid,distance:o.distance})}return e}}),Object.assign(ze.prototype,{calculateInverses:function(){var t=this;this.boneInverses=[];for(var e=0,i=this.bones.length;e<i;e++){var r=new y;t.bones[e]&&r.getInverse(t.bones[e].matrixWorld),t.boneInverses.push(r)}},pose:function(){var t,e,i,r=this;for(e=0,i=this.bones.length;e<i;e++)(t=r.bones[e])&&t.matrixWorld.getInverse(r.boneInverses[e]);for(e=0,i=this.bones.length;e<i;e++)(t=r.bones[e])&&(t.parent&&t.parent.isBone?(t.matrix.getInverse(t.parent.matrixWorld),t.matrix.multiply(t.matrixWorld)):t.matrix.copy(t.matrixWorld),t.matrix.decompose(t.position,t.quaternion,t.scale))},update:function(){var t=new y,e=new y;return function(){for(var i=this.bones,r=this.boneInverses,n=this.boneMatrices,o=this.boneTexture,a=0,s=i.length;a<s;a++){var c=i[a]?i[a].matrixWorld:e;t.multiplyMatrices(c,r[a]),t.toArray(n,16*a)}void 0!==o&&(o.needsUpdate=!0)}}(),clone:function(){return new ze(this.bones,this.boneInverses)}}),Ue.prototype=Object.assign(Object.create(bt.prototype),{constructor:Ue,isBone:!0}),je.prototype=Object.assign(Object.create(Xt.prototype),{constructor:je,isSkinnedMesh:!0,initBones:function(){var t,e,i,r,n=this,o=[];if(this.geometry&&void 0!==this.geometry.bones){for(i=0,r=this.geometry.bones.length;i<r;i++)e=n.geometry.bones[i],t=new Ue,o.push(t),t.name=e.name,t.position.fromArray(e.pos),t.quaternion.fromArray(e.rotq),void 0!==e.scl&&t.scale.fromArray(e.scl);for(i=0,r=this.geometry.bones.length;i<r;i++)-1!==(e=n.geometry.bones[i]).parent&&null!==e.parent&&void 0!==o[e.parent]?o[e.parent].add(o[i]):n.add(o[i])}return this.updateMatrixWorld(!0),o},bind:function(t,e){this.skeleton=t,void 0===e&&(this.updateMatrixWorld(!0),this.skeleton.calculateInverses(),e=this.matrixWorld),this.bindMatrix.copy(e),this.bindMatrixInverse.getInverse(e)},pose:function(){this.skeleton.pose()},normalizeSkinWeights:function(){var t,e,i=this;if(this.geometry&&this.geometry.isGeometry)for(e=0;e<this.geometry.skinWeights.length;e++){var r=i.geometry.skinWeights[e];(t=1/r.lengthManhattan())!==1/0?r.multiplyScalar(t):r.set(1,0,0,0)}else if(this.geometry&&this.geometry.isBufferGeometry){var n=new d,o=this.geometry.attributes.skinWeight;for(e=0;e<o.count;e++)n.x=o.getX(e),n.y=o.getY(e),n.z=o.getZ(e),n.w=o.getW(e),(t=1/n.lengthManhattan())!==1/0?n.multiplyScalar(t):n.set(1,0,0,0),o.setXYZW(e,n.x,n.y,n.z,n.w)}},updateMatrixWorld:function(t){Xt.prototype.updateMatrixWorld.call(this,t),"attached"===this.bindMode?this.bindMatrixInverse.getInverse(this.matrixWorld):"detached"===this.bindMode?this.bindMatrixInverse.getInverse(this.bindMatrix):console.warn("THREE.SkinnedMesh: Unrecognized bindMode: "+this.bindMode)},clone:function(){return new this.constructor(this.geometry,this.material).copy(this)}}),Ve.prototype=Object.create(at.prototype),Ve.prototype.constructor=Ve,Ve.prototype.isLineBasicMaterial=!0,Ve.prototype.copy=function(t){return at.prototype.copy.call(this,t),this.color.copy(t.color),this.linewidth=t.linewidth,this.linecap=t.linecap,this.linejoin=t.linejoin,this},Ge.prototype=Object.assign(Object.create(bt.prototype),{constructor:Ge,isLine:!0,raycast:function(){var t=new y,e=new $t,i=new ht;return function(r,n){var o=this,a=r.linePrecision,s=a*a,c=this.geometry,u=this.matrixWorld;if(null===c.boundingSphere&&c.computeBoundingSphere(),i.copy(c.boundingSphere),i.applyMatrix4(u),!1!==r.ray.intersectsSphere(i)){t.getInverse(u),e.copy(r.ray).applyMatrix4(t);var l=new v,h=new v,p=new v,d=new v,f=this&&this.isLineSegments?2:1;if(c.isBufferGeometry){var m=c.index,g=c.attributes.position.array;if(null!==m)for(var y=m.array,b=0,x=y.length-1;b<x;b+=f){var _=y[b],w=y[b+1];l.fromArray(g,3*_),h.fromArray(g,3*w),(M=e.distanceSqToSegment(l,h,d,p))>s||(d.applyMatrix4(o.matrixWorld),(P=r.ray.origin.distanceTo(d))<r.near||P>r.far||n.push({distance:P,point:p.clone().applyMatrix4(o.matrixWorld),index:b,face:null,faceIndex:null,object:o}))}else for(var b=0,x=g.length/3-1;b<x;b+=f)l.fromArray(g,3*b),h.fromArray(g,3*b+3),(M=e.distanceSqToSegment(l,h,d,p))>s||(d.applyMatrix4(o.matrixWorld),(P=r.ray.origin.distanceTo(d))<r.near||P>r.far||n.push({distance:P,point:p.clone().applyMatrix4(o.matrixWorld),index:b,face:null,faceIndex:null,object:o}))}else if(c.isGeometry)for(var S=c.vertices,A=S.length,b=0;b<A-1;b+=f){var M=e.distanceSqToSegment(S[b],S[b+1],d,p);if(!(M>s)){d.applyMatrix4(o.matrixWorld);var P=r.ray.origin.distanceTo(d);P<r.near||P>r.far||n.push({distance:P,point:p.clone().applyMatrix4(o.matrixWorld),index:b,face:null,faceIndex:null,object:o})}}}}}(),clone:function(){return new this.constructor(this.geometry,this.material).copy(this)}}),$e.prototype=Object.assign(Object.create(Ge.prototype),{constructor:$e,isLineSegments:!0}),He.prototype=Object.assign(Object.create(Ge.prototype),{constructor:He,isLineLoop:!0}),We.prototype=Object.create(at.prototype),We.prototype.constructor=We,We.prototype.isPointsMaterial=!0,We.prototype.copy=function(t){return at.prototype.copy.call(this,t),this.color.copy(t.color),this.map=t.map,this.size=t.size,this.sizeAttenuation=t.sizeAttenuation,this},Xe.prototype=Object.assign(Object.create(bt.prototype),{constructor:Xe,isPoints:!0,raycast:function(){var t=new y,e=new $t,i=new ht;return function(r,n){function o(t,i){var o=e.distanceSqToPoint(t);if(o<h){var s=e.closestPointToPoint(t);s.applyMatrix4(c);var u=r.ray.origin.distanceTo(s);if(u<r.near||u>r.far)return;n.push({distance:u,distanceToRay:Math.sqrt(o),point:s.clone(),index:i,face:null,object:a})}}var a=this,s=this.geometry,c=this.matrixWorld,u=r.params.Points.threshold;if(null===s.boundingSphere&&s.computeBoundingSphere(),i.copy(s.boundingSphere),i.applyMatrix4(c),i.radius+=u,!1!==r.ray.intersectsSphere(i)){t.getInverse(c),e.copy(r.ray).applyMatrix4(t);var l=u/((this.scale.x+this.scale.y+this.scale.z)/3),h=l*l,p=new v;if(s.isBufferGeometry){var d=s.index,f=s.attributes.position.array;if(null!==d)for(var m=d.array,g=0,y=m.length;g<y;g++){var b=m[g];p.fromArray(f,3*b),o(p,b)}else for(var g=0,x=f.length/3;g<x;g++)p.fromArray(f,3*g),o(p,g)}else for(var _=s.vertices,g=0,x=_.length;g<x;g++)o(_[g],g)}}}(),clone:function(){return new this.constructor(this.geometry,this.material).copy(this)}}),qe.prototype=Object.assign(Object.create(bt.prototype),{constructor:qe}),(Ye.prototype=Object.create(p.prototype)).constructor=Ye,(Ze.prototype=Object.create(p.prototype)).constructor=Ze,Ze.prototype.isCompressedTexture=!0,(Ke.prototype=Object.create(p.prototype)).constructor=Ke,Ke.prototype.isDepthTexture=!0,(Qe.prototype=Object.create(Ft.prototype)).constructor=Qe,(Je.prototype=Object.create(Mt.prototype)).constructor=Je,(ti.prototype=Object.create(Ft.prototype)).constructor=ti,(ei.prototype=Object.create(Mt.prototype)).constructor=ei,ii.prototype=Object.create(Ft.prototype),ii.prototype.constructor=ii,(ri.prototype=Object.create(Mt.prototype)).constructor=ri,ni.prototype=Object.create(ii.prototype),ni.prototype.constructor=ni,(oi.prototype=Object.create(Mt.prototype)).constructor=oi,ai.prototype=Object.create(ii.prototype),ai.prototype.constructor=ai,(si.prototype=Object.create(Mt.prototype)).constructor=si,ci.prototype=Object.create(ii.prototype),ci.prototype.constructor=ci,(ui.prototype=Object.create(Mt.prototype)).constructor=ui,(li.prototype=Object.create(ii.prototype)).constructor=li,(hi.prototype=Object.create(Mt.prototype)).constructor=hi,(pi.prototype=Object.create(Ft.prototype)).constructor=pi,(di.prototype=Object.create(Mt.prototype)).constructor=di,(fi.prototype=Object.create(Ft.prototype)).constructor=fi,(mi.prototype=Object.create(Mt.prototype)).constructor=mi,gi.prototype=Object.create(Ft.prototype),gi.prototype.constructor=gi;var Vp={area:function(t){for(var e=t.length,i=0,r=e-1,n=0;n<e;r=n++)i+=t[r].x*t[n].y-t[n].x*t[r].y;return.5*i},triangulate:function(){function t(t,e,i,r,n,o){var a,s,c,u,l,h,p,d,f;if(s=t[o[e]].x,c=t[o[e]].y,u=t[o[i]].x,l=t[o[i]].y,h=t[o[r]].x,p=t[o[r]].y,(u-s)*(p-c)-(l-c)*(h-s)<=0)return!1;var m,g,v,y,b,x,_,w,S,A,M,P,E,T,C;for(m=h-u,g=p-l,v=s-h,y=c-p,b=u-s,x=l-c,a=0;a<n;a++)if(d=t[o[a]].x,f=t[o[a]].y,!(d===s&&f===c||d===u&&f===l||d===h&&f===p)&&(_=d-s,w=f-c,S=d-u,A=f-l,M=d-h,P=f-p,C=m*A-g*S,E=b*w-x*_,T=v*P-y*M,C>=-Number.EPSILON&&T>=-Number.EPSILON&&E>=-Number.EPSILON))return!1;return!0}return function(e,i){var r=e.length;if(r<3)return null;var n,o,a,s=[],c=[],u=[];if(Vp.area(e)>0)for(o=0;o<r;o++)c[o]=o;else for(o=0;o<r;o++)c[o]=r-1-o;var l=r,h=2*l;for(o=l-1;l>2;){if(h--<=0)return console.warn("THREE.ShapeUtils: Unable to triangulate polygon! in triangulate()"),i?u:s;if(n=o,l<=n&&(n=0),o=n+1,l<=o&&(o=0),a=o+1,l<=a&&(a=0),t(e,n,o,a,l,c)){var p,d,f,m,g;for(p=c[n],d=c[o],f=c[a],s.push([e[p],e[d],e[f]]),u.push([c[n],c[o],c[a]]),m=o,g=o+1;g<l;m++,g++)c[m]=c[g];h=2*--l}}return i?u:s}}(),triangulateShape:function(t,e){function i(t){var e=t.length;e>2&&t[e-1].equals(t[0])&&t.pop()}function r(t,e,i){return t.x!==e.x?t.x<e.x?t.x<=i.x&&i.x<=e.x:e.x<=i.x&&i.x<=t.x:t.y<e.y?t.y<=i.y&&i.y<=e.y:e.y<=i.y&&i.y<=t.y}function n(t,e,i,n,o){var a=e.x-t.x,s=e.y-t.y,c=n.x-i.x,u=n.y-i.y,l=t.x-i.x,h=t.y-i.y,p=s*c-a*u,d=s*l-a*h;if(Math.abs(p)>Number.EPSILON){var f;if(p>0){if(d<0||d>p)return[];if((f=u*l-c*h)<0||f>p)return[]}else{if(d>0||d<p)return[];if((f=u*l-c*h)>0||f<p)return[]}if(0===f)return!o||0!==d&&d!==p?[t]:[];if(f===p)return!o||0!==d&&d!==p?[e]:[];if(0===d)return[i];if(d===p)return[n];var m=f/p;return[{x:t.x+m*a,y:t.y+m*s}]}if(0!==d||u*l!=c*h)return[];var g=0===a&&0===s,v=0===c&&0===u;if(g&&v)return t.x!==i.x||t.y!==i.y?[]:[t];if(g)return r(i,n,t)?[t]:[];if(v)return r(t,e,i)?[i]:[];var y,b,x,_,w,S,A,M;return 0!==a?(t.x<e.x?(y=t,x=t.x,b=e,_=e.x):(y=e,x=e.x,b=t,_=t.x),i.x<n.x?(w=i,A=i.x,S=n,M=n.x):(w=n,A=n.x,S=i,M=i.x)):(t.y<e.y?(y=t,x=t.y,b=e,_=e.y):(y=e,x=e.y,b=t,_=t.y),i.y<n.y?(w=i,A=i.y,S=n,M=n.y):(w=n,A=n.y,S=i,M=i.y)),x<=A?_<A?[]:_===A?o?[]:[w]:_<=M?[w,b]:[w,S]:x>M?[]:x===M?o?[]:[y]:_<=M?[y,b]:[y,S]}function o(t,e,i,r){var n=e.x-t.x,o=e.y-t.y,a=i.x-t.x,s=i.y-t.y,c=r.x-t.x,u=r.y-t.y,l=n*s-o*a,h=n*u-o*c;if(Math.abs(l)>Number.EPSILON){var p=c*s-u*a;return l>0?h>=0&&p>=0:h>=0||p>=0}return h>0}i(t),e.forEach(i);for(var a,s,c,u,l,h,p={},d=t.concat(),f=0,m=e.length;f<m;f++)Array.prototype.push.apply(d,e[f]);for(a=0,s=d.length;a<s;a++)void 0!==p[l=d[a].x+":"+d[a].y]&&console.warn("THREE.ShapeUtils: Duplicate point",l,a),p[l]=a;var g=function(t,e){for(var i,r,a,s,c,u,l,h,p,d,f,m=t.concat(),g=[],v=[],y=0,b=e.length;y<b;y++)g.push(y);for(var x=0,_=2*g.length;g.length>0;){if(--_<0){console.log('THREE.ShapeUtils: Infinite Loop! Holes left:" + indepHoles.length + ", Probably Hole outside Shape!');break}for(a=x;a<m.length;a++){for(s=m[a],r=-1,y=0;y<g.length;y++)if(u=g[y],l=s.x+":"+s.y+":"+u,void 0===v[l]){i=e[u];for(var w=0;w<i.length;w++)if(c=i[w],function(t,e){var r=m.length-1,n=t-1;n<0&&(n=r);var a=t+1;a>r&&(a=0);var s=o(m[t],m[n],m[a],i[e]);if(!s)return!1;var c=i.length-1,u=e-1;u<0&&(u=c);var l=e+1;return l>c&&(l=0),!!(s=o(i[e],i[u],i[l],m[t]))}(a,w)&&!function(t,e){var i,r;for(i=0;i<m.length;i++)if(r=i+1,r%=m.length,n(t,e,m[i],m[r],!0).length>0)return!0;return!1}(s,c)&&!function(t,i){var r,o,a,s;for(r=0;r<g.length;r++)for(o=e[g[r]],a=0;a<o.length;a++)if(s=a+1,s%=o.length,n(t,i,o[a],o[s],!0).length>0)return!0;return!1}(s,c)){r=w,g.splice(y,1),h=m.slice(0,a+1),p=m.slice(a),d=i.slice(r),f=i.slice(0,r+1),m=h.concat(d).concat(f).concat(p),x=a;break}if(r>=0)break;v[l]=!0}if(r>=0)break}}return m}(t,e),v=Vp.triangulate(g,!1);for(a=0,s=v.length;a<s;a++)for(u=v[a],c=0;c<3;c++)void 0!==(h=p[l=u[c].x+":"+u[c].y])&&(u[c]=h);return v.concat()},isClockWise:function(t){return Vp.area(t)<0}};(vi.prototype=Object.create(Mt.prototype)).constructor=vi,yi.prototype=Object.create(Ft.prototype),yi.prototype.constructor=yi,yi.prototype.getArrays=function(){var t=this.getAttribute("position"),e=t?Array.prototype.slice.call(t.array):[],i=this.getAttribute("uv"),r=i?Array.prototype.slice.call(i.array):[],n=this.index;return{position:e,uv:r,index:n?Array.prototype.slice.call(n.array):[]}},yi.prototype.addShapeList=function(t,e){var i=this,r=t.length;e.arrays=this.getArrays();for(var n=0;n<r;n++){var o=t[n];i.addShape(o,e)}this.setIndex(e.arrays.index),this.addAttribute("position",new Dt(e.arrays.position,3)),this.addAttribute("uv",new Dt(e.arrays.uv,2))},yi.prototype.addShape=function(t,e){function i(t,e,i){return e||console.error("THREE.ExtrudeGeometry: vec does not exist"),e.clone().multiplyScalar(i).add(t)}function r(t,e,i){var r,n,o,a=t.x-e.x,s=t.y-e.y,c=i.x-t.x,u=i.y-t.y,l=a*a+s*s,p=a*u-s*c;if(Math.abs(p)>Number.EPSILON){var d=Math.sqrt(l),f=Math.sqrt(c*c+u*u),m=e.x-s/d,g=e.y+a/d,v=((i.x-u/f-m)*u-(i.y+c/f-g)*c)/(a*u-s*c),y=(r=m+a*v-t.x)*r+(n=g+s*v-t.y)*n;if(y<=2)return new h(r,n);o=Math.sqrt(y/2)}else{var b=!1;a>Number.EPSILON?c>Number.EPSILON&&(b=!0):a<-Number.EPSILON?c<-Number.EPSILON&&(b=!0):Math.sign(s)===Math.sign(u)&&(b=!0),b?(r=-s,n=a,o=Math.sqrt(l)):(r=a,n=s,o=Math.sqrt(l/2))}return new h(r/o,n/o)}function n(t,e){var i,r;for(Z=t.length;--Z>=0;){i=Z,(r=Z-1)<0&&(r=t.length-1);var n=0,o=T+2*M;for(n=0;n<o;n++){var a=X*n,c=X*(n+1);s(e+i+a,e+r+a,e+r+c,e+i+c,t,n,o,i,r)}}}function o(t,e,i){_.push(t),_.push(e),_.push(i)}function a(t,e,i){c(t),c(e),c(i);var r=y.length/3,n=R.generateTopUV(N,y,r-3,r-2,r-1);u(n[0]),u(n[1]),u(n[2])}function s(t,e,i,r,n,o,a,s,l){c(t),c(e),c(r),c(e),c(i),c(r);var h=y.length/3,p=R.generateSideWallUV(N,y,h-6,h-3,h-2,h-1);u(p[0]),u(p[1]),u(p[3]),u(p[1]),u(p[2]),u(p[3])}function c(t){b.push(y.length/3),y.push(_[3*t+0]),y.push(_[3*t+1]),y.push(_[3*t+2])}function u(t){x.push(t.x),x.push(t.y)}var l,p,d,f,m,g=e.arrays?e.arrays:this.getArrays(),y=g.position,b=g.index,x=g.uv,_=[],w=void 0!==e.amount?e.amount:100,S=void 0!==e.bevelThickness?e.bevelThickness:6,A=void 0!==e.bevelSize?e.bevelSize:S-2,M=void 0!==e.bevelSegments?e.bevelSegments:3,P=void 0===e.bevelEnabled||e.bevelEnabled,E=void 0!==e.curveSegments?e.curveSegments:12,T=void 0!==e.steps?e.steps:1,C=e.extrudePath,I=!1,R=void 0!==e.UVGenerator?e.UVGenerator:vi.WorldUVGenerator;C&&(l=C.getSpacedPoints(T),I=!0,P=!1,p=void 0!==e.frames?e.frames:C.computeFrenetFrames(T,!1),d=new v,f=new v,m=new v),P||(M=0,S=0,A=0);var L,O,D,N=this,k=t.extractPoints(E),B=k.shape,F=k.holes;if(!Vp.isClockWise(B))for(B=B.reverse(),O=0,D=F.length;O<D;O++)L=F[O],Vp.isClockWise(L)&&(F[O]=L.reverse());var z=Vp.triangulateShape(B,F),U=B;for(O=0,D=F.length;O<D;O++)L=F[O],B=B.concat(L);for(var j,V,G,$,H,W,X=B.length,q=z.length,Y=[],Z=0,K=U.length,Q=K-1,J=Z+1;Z<K;Z++,Q++,J++)Q===K&&(Q=0),J===K&&(J=0),Y[Z]=r(U[Z],U[Q],U[J]);var tt,et=[],it=Y.concat();for(O=0,D=F.length;O<D;O++){for(L=F[O],tt=[],Z=0,Q=(K=L.length)-1,J=Z+1;Z<K;Z++,Q++,J++)Q===K&&(Q=0),J===K&&(J=0),tt[Z]=r(L[Z],L[Q],L[J]);et.push(tt),it=it.concat(tt)}for(j=0;j<M;j++){for(G=j/M,$=S*Math.cos(G*Math.PI/2),V=A*Math.sin(G*Math.PI/2),Z=0,K=U.length;Z<K;Z++)o((H=i(U[Z],Y[Z],V)).x,H.y,-$);for(O=0,D=F.length;O<D;O++)for(L=F[O],tt=et[O],Z=0,K=L.length;Z<K;Z++)o((H=i(L[Z],tt[Z],V)).x,H.y,-$)}for(V=A,Z=0;Z<X;Z++)H=P?i(B[Z],it[Z],V):B[Z],I?(f.copy(p.normals[0]).multiplyScalar(H.x),d.copy(p.binormals[0]).multiplyScalar(H.y),m.copy(l[0]).add(f).add(d),o(m.x,m.y,m.z)):o(H.x,H.y,0);var rt;for(rt=1;rt<=T;rt++)for(Z=0;Z<X;Z++)H=P?i(B[Z],it[Z],V):B[Z],I?(f.copy(p.normals[rt]).multiplyScalar(H.x),d.copy(p.binormals[rt]).multiplyScalar(H.y),m.copy(l[rt]).add(f).add(d),o(m.x,m.y,m.z)):o(H.x,H.y,w/T*rt);for(j=M-1;j>=0;j--){for(G=j/M,$=S*Math.cos(G*Math.PI/2),V=A*Math.sin(G*Math.PI/2),Z=0,K=U.length;Z<K;Z++)o((H=i(U[Z],Y[Z],V)).x,H.y,w+$);for(O=0,D=F.length;O<D;O++)for(L=F[O],tt=et[O],Z=0,K=L.length;Z<K;Z++)H=i(L[Z],tt[Z],V),I?o(H.x,H.y+l[T-1].y,l[T-1].x+$):o(H.x,H.y,w+$)}!function(){var t=y.length/3;if(P){var i=0,r=X*i;for(Z=0;Z<q;Z++)a((W=z[Z])[2]+r,W[1]+r,W[0]+r);for(r=X*(i=T+2*M),Z=0;Z<q;Z++)a((W=z[Z])[0]+r,W[1]+r,W[2]+r)}else{for(Z=0;Z<q;Z++)a((W=z[Z])[2],W[1],W[0]);for(Z=0;Z<q;Z++)a((W=z[Z])[0]+X*T,W[1]+X*T,W[2]+X*T)}N.addGroup(t,y.length/3-t,void 0!==e.material?e.material:0)}(),function(){var t=y.length/3,i=0;for(n(U,i),i+=U.length,O=0,D=F.length;O<D;O++)n(L=F[O],i),i+=L.length;N.addGroup(t,y.length/3-t,void 0!==e.extrudeMaterial?e.extrudeMaterial:1)}(),e.arrays||(this.setIndex(b),this.addAttribute("position",new Dt(y,3)),this.addAttribute("uv",new Dt(e.arrays.uv,2)))},vi.WorldUVGenerator={generateTopUV:function(t,e,i,r,n){var o=e[3*i],a=e[3*i+1],s=e[3*r],c=e[3*r+1],u=e[3*n],l=e[3*n+1];return[new h(o,a),new h(s,c),new h(u,l)]},generateSideWallUV:function(t,e,i,r,n,o){var a=e[3*i],s=e[3*i+1],c=e[3*i+2],u=e[3*r],l=e[3*r+1],p=e[3*r+2],d=e[3*n],f=e[3*n+1],m=e[3*n+2],g=e[3*o],v=e[3*o+1],y=e[3*o+2];return Math.abs(s-l)<.01?[new h(a,1-c),new h(u,1-p),new h(d,1-m),new h(g,1-y)]:[new h(s,1-c),new h(l,1-p),new h(f,1-m),new h(v,1-y)]}},(bi.prototype=Object.create(Mt.prototype)).constructor=bi,(xi.prototype=Object.create(yi.prototype)).constructor=xi,(_i.prototype=Object.create(Mt.prototype)).constructor=_i,wi.prototype=Object.create(Ft.prototype),wi.prototype.constructor=wi,(Si.prototype=Object.create(Mt.prototype)).constructor=Si,(Ai.prototype=Object.create(Ft.prototype)).constructor=Ai,(Mi.prototype=Object.create(Mt.prototype)).constructor=Mi,(Pi.prototype=Object.create(Ft.prototype)).constructor=Pi,(Ei.prototype=Object.create(Mt.prototype)).constructor=Ei,(Ti.prototype=Object.create(Ft.prototype)).constructor=Ti,(Ci.prototype=Object.create(Ft.prototype)).constructor=Ci,Ii.prototype=Object.create(Mt.prototype),Ii.prototype.constructor=Ii,Ri.prototype=Object.create(Ft.prototype),Ri.prototype.constructor=Ri,(Li.prototype=Object.create(Ii.prototype)).constructor=Li,Oi.prototype=Object.create(Ri.prototype),Oi.prototype.constructor=Oi,(Di.prototype=Object.create(Mt.prototype)).constructor=Di,(Ni.prototype=Object.create(Ft.prototype)).constructor=Ni;var Gp=Object.freeze({WireframeGeometry:Qe,ParametricGeometry:Je,ParametricBufferGeometry:ti,TetrahedronGeometry:ri,TetrahedronBufferGeometry:ni,OctahedronGeometry:oi,OctahedronBufferGeometry:ai,IcosahedronGeometry:si,IcosahedronBufferGeometry:ci,DodecahedronGeometry:ui,DodecahedronBufferGeometry:li,PolyhedronGeometry:ei,PolyhedronBufferGeometry:ii,TubeGeometry:hi,TubeBufferGeometry:pi,TorusKnotGeometry:di,TorusKnotBufferGeometry:fi,TorusGeometry:mi,TorusBufferGeometry:gi,TextGeometry:bi,TextBufferGeometry:xi,SphereGeometry:_i,SphereBufferGeometry:wi,RingGeometry:Si,RingBufferGeometry:Ai,PlaneGeometry:jt,PlaneBufferGeometry:Vt,LatheGeometry:Mi,LatheBufferGeometry:Pi,ShapeGeometry:Ei,ShapeBufferGeometry:Ti,ExtrudeGeometry:vi,ExtrudeBufferGeometry:yi,EdgesGeometry:Ci,ConeGeometry:Li,ConeBufferGeometry:Oi,CylinderGeometry:Ii,CylinderBufferGeometry:Ri,CircleGeometry:Di,CircleBufferGeometry:Ni,BoxGeometry:zt,BoxBufferGeometry:Ut});(ki.prototype=Object.create(at.prototype)).constructor=ki,ki.prototype.isShadowMaterial=!0,(Bi.prototype=Object.create(st.prototype)).constructor=Bi,Bi.prototype.isRawShaderMaterial=!0,Fi.prototype=Object.create(at.prototype),Fi.prototype.constructor=Fi,Fi.prototype.isMeshStandardMaterial=!0,Fi.prototype.copy=function(t){return at.prototype.copy.call(this,t),this.defines={STANDARD:""},this.color.copy(t.color),this.roughness=t.roughness,this.metalness=t.metalness,this.map=t.map,this.lightMap=t.lightMap,this.lightMapIntensity=t.lightMapIntensity,this.aoMap=t.aoMap,this.aoMapIntensity=t.aoMapIntensity,this.emissive.copy(t.emissive),this.emissiveMap=t.emissiveMap,this.emissiveIntensity=t.emissiveIntensity,this.bumpMap=t.bumpMap,this.bumpScale=t.bumpScale,this.normalMap=t.normalMap,this.normalScale.copy(t.normalScale),this.displacementMap=t.displacementMap,this.displacementScale=t.displacementScale,this.displacementBias=t.displacementBias,this.roughnessMap=t.roughnessMap,this.metalnessMap=t.metalnessMap,this.alphaMap=t.alphaMap,this.envMap=t.envMap,this.envMapIntensity=t.envMapIntensity,this.refractionRatio=t.refractionRatio,this.wireframe=t.wireframe,this.wireframeLinewidth=t.wireframeLinewidth,this.wireframeLinecap=t.wireframeLinecap,this.wireframeLinejoin=t.wireframeLinejoin,this.skinning=t.skinning,this.morphTargets=t.morphTargets,this.morphNormals=t.morphNormals,this},(zi.prototype=Object.create(Fi.prototype)).constructor=zi,zi.prototype.isMeshPhysicalMaterial=!0,zi.prototype.copy=function(t){return Fi.prototype.copy.call(this,t),this.defines={PHYSICAL:""},this.reflectivity=t.reflectivity,this.clearCoat=t.clearCoat,this.clearCoatRoughness=t.clearCoatRoughness,this},Ui.prototype=Object.create(at.prototype),Ui.prototype.constructor=Ui,Ui.prototype.isMeshPhongMaterial=!0,Ui.prototype.copy=function(t){return at.prototype.copy.call(this,t),this.color.copy(t.color),this.specular.copy(t.specular),this.shininess=t.shininess,this.map=t.map,this.lightMap=t.lightMap,this.lightMapIntensity=t.lightMapIntensity,this.aoMap=t.aoMap,this.aoMapIntensity=t.aoMapIntensity,this.emissive.copy(t.emissive),this.emissiveMap=t.emissiveMap,this.emissiveIntensity=t.emissiveIntensity,this.bumpMap=t.bumpMap,this.bumpScale=t.bumpScale,this.normalMap=t.normalMap,this.normalScale.copy(t.normalScale),this.displacementMap=t.displacementMap,this.displacementScale=t.displacementScale,this.displacementBias=t.displacementBias,this.specularMap=t.specularMap,this.alphaMap=t.alphaMap,this.envMap=t.envMap,this.combine=t.combine,this.reflectivity=t.reflectivity,this.refractionRatio=t.refractionRatio,this.wireframe=t.wireframe,this.wireframeLinewidth=t.wireframeLinewidth,this.wireframeLinecap=t.wireframeLinecap,this.wireframeLinejoin=t.wireframeLinejoin,this.skinning=t.skinning,this.morphTargets=t.morphTargets,this.morphNormals=t.morphNormals,this},(ji.prototype=Object.create(Ui.prototype)).constructor=ji,ji.prototype.isMeshToonMaterial=!0,ji.prototype.copy=function(t){return Ui.prototype.copy.call(this,t),this.gradientMap=t.gradientMap,this},(Vi.prototype=Object.create(at.prototype)).constructor=Vi,Vi.prototype.isMeshNormalMaterial=!0,Vi.prototype.copy=function(t){return at.prototype.copy.call(this,t),this.bumpMap=t.bumpMap,this.bumpScale=t.bumpScale,this.normalMap=t.normalMap,this.normalScale.copy(t.normalScale),this.displacementMap=t.displacementMap,this.displacementScale=t.displacementScale,this.displacementBias=t.displacementBias,this.wireframe=t.wireframe,this.wireframeLinewidth=t.wireframeLinewidth,this.skinning=t.skinning,this.morphTargets=t.morphTargets,this.morphNormals=t.morphNormals,this},(Gi.prototype=Object.create(at.prototype)).constructor=Gi,Gi.prototype.isMeshLambertMaterial=!0,Gi.prototype.copy=function(t){return at.prototype.copy.call(this,t),this.color.copy(t.color),this.map=t.map,this.lightMap=t.lightMap,this.lightMapIntensity=t.lightMapIntensity,this.aoMap=t.aoMap,this.aoMapIntensity=t.aoMapIntensity,this.emissive.copy(t.emissive),this.emissiveMap=t.emissiveMap,this.emissiveIntensity=t.emissiveIntensity,this.specularMap=t.specularMap,this.alphaMap=t.alphaMap,this.envMap=t.envMap,this.combine=t.combine,this.reflectivity=t.reflectivity,this.refractionRatio=t.refractionRatio,this.wireframe=t.wireframe,this.wireframeLinewidth=t.wireframeLinewidth,this.wireframeLinecap=t.wireframeLinecap,this.wireframeLinejoin=t.wireframeLinejoin,this.skinning=t.skinning,this.morphTargets=t.morphTargets,this.morphNormals=t.morphNormals,this},($i.prototype=Object.create(Ve.prototype)).constructor=$i,$i.prototype.isLineDashedMaterial=!0,$i.prototype.copy=function(t){return Ve.prototype.copy.call(this,t),this.scale=t.scale,this.dashSize=t.dashSize,this.gapSize=t.gapSize,this};var $p=Object.freeze({ShadowMaterial:ki,SpriteMaterial:ke,RawShaderMaterial:Bi,ShaderMaterial:st,PointsMaterial:We,MeshPhysicalMaterial:zi,MeshStandardMaterial:Fi,MeshPhongMaterial:Ui,MeshToonMaterial:ji,MeshNormalMaterial:Vi,MeshLambertMaterial:Gi,MeshDepthMaterial:ct,MeshDistanceMaterial:ut,MeshBasicMaterial:Gt,LineDashedMaterial:$i,LineBasicMaterial:Ve,Material:at}),Hp={enabled:!1,files:{},add:function(t,e){!1!==this.enabled&&(this.files[t]=e)},get:function(t){if(!1!==this.enabled)return this.files[t]},remove:function(t){delete this.files[t]},clear:function(){this.files={}}},Wp=new Hi;Object.assign(Wi.prototype,{load:function(t,e,i,r){var n=this;void 0===t&&(t=""),void 0!==this.path&&(t=this.path+t);var o=this,a=Hp.get(t);if(void 0!==a)return o.manager.itemStart(t),setTimeout(function(){e&&e(a),o.manager.itemEnd(t)},0),a;var s=/^data:(.*?)(;base64)?,(.*)$/,c=t.match(s);if(c){var u=c[1],l=!!c[2],h=c[3];h=window.decodeURIComponent(h),l&&(h=window.atob(h));try{var p,d=(this.responseType||"").toLowerCase();switch(d){case"arraybuffer":case"blob":p=new ArrayBuffer(h.length);for(var f=new Uint8Array(p),m=0;m<h.length;m++)f[m]=h.charCodeAt(m);"blob"===d&&(p=new Blob([p],{type:u}));break;case"document":var g=new DOMParser;p=g.parseFromString(h,u);break;case"json":p=JSON.parse(h);break;default:p=h}window.setTimeout(function(){e&&e(p),o.manager.itemEnd(t)},0)}catch(e){window.setTimeout(function(){r&&r(e),o.manager.itemEnd(t),o.manager.itemError(t)},0)}}else{var v=new XMLHttpRequest;v.open("GET",t,!0),v.addEventListener("load",function(i){var n=i.target.response;Hp.add(t,n),200===this.status?(e&&e(n),o.manager.itemEnd(t)):0===this.status?(console.warn("THREE.FileLoader: HTTP Status 0 received."),e&&e(n),o.manager.itemEnd(t)):(r&&r(i),o.manager.itemEnd(t),o.manager.itemError(t))},!1),void 0!==i&&v.addEventListener("progress",function(t){i(t)},!1),v.addEventListener("error",function(e){r&&r(e),o.manager.itemEnd(t),o.manager.itemError(t)},!1),void 0!==this.responseType&&(v.responseType=this.responseType),void 0!==this.withCredentials&&(v.withCredentials=this.withCredentials),v.overrideMimeType&&v.overrideMimeType(void 0!==this.mimeType?this.mimeType:"text/plain");for(var y in n.requestHeader)v.setRequestHeader(y,n.requestHeader[y]);v.send(null)}return o.manager.itemStart(t),v},setPath:function(t){return this.path=t,this},setResponseType:function(t){return this.responseType=t,this},setWithCredentials:function(t){return this.withCredentials=t,this},setMimeType:function(t){return this.mimeType=t,this},setRequestHeader:function(t){return this.requestHeader=t,this}}),Object.assign(function(t){this.manager=void 0!==t?t:Wp,this._parser=null}.prototype,{load:function(t,e,i,r){var n=this,o=[],a=new Ze;a.image=o;var s=new Wi(this.manager);if(s.setPath(this.path),s.setResponseType("arraybuffer"),Array.isArray(t))for(var c=0,u=0,l=t.length;u<l;++u)!function(u){s.load(t[u],function(t){var i=n._parser(t,!0);o[u]={width:i.width,height:i.height,format:i.format,mipmaps:i.mipmaps},6===(c+=1)&&(1===i.mipmapCount&&(a.minFilter=Oh),a.format=i.format,a.needsUpdate=!0,e&&e(a))},i,r)}(u);else s.load(t,function(t){var i=n._parser(t,!0);if(i.isCubemap)for(var r=i.mipmaps.length/i.mipmapCount,s=0;s<r;s++){o[s]={mipmaps:[]};for(var c=0;c<i.mipmapCount;c++)o[s].mipmaps.push(i.mipmaps[s*i.mipmapCount+c]),o[s].format=i.format,o[s].width=i.width,o[s].height=i.height}else a.image.width=i.width,a.image.height=i.height,a.mipmaps=i.mipmaps;1===i.mipmapCount&&(a.minFilter=Oh),a.format=i.format,a.needsUpdate=!0,e&&e(a)},i,r);return a},setPath:function(t){return this.path=t,this}}),Object.assign(function(t){this.manager=void 0!==t?t:Wp,this._parser=null}.prototype,{load:function(t,e,i,r){var n=this,o=new b,a=new Wi(this.manager);return a.setResponseType("arraybuffer"),a.load(t,function(t){var i=n._parser(t);i&&(void 0!==i.image?o.image=i.image:void 0!==i.data&&(o.image.width=i.width,o.image.height=i.height,o.image.data=i.data),o.wrapS=void 0!==i.wrapS?i.wrapS:Th,o.wrapT=void 0!==i.wrapT?i.wrapT:Th,o.magFilter=void 0!==i.magFilter?i.magFilter:Oh,o.minFilter=void 0!==i.minFilter?i.minFilter:Nh,o.anisotropy=void 0!==i.anisotropy?i.anisotropy:1,void 0!==i.format&&(o.format=i.format),void 0!==i.type&&(o.type=i.type),void 0!==i.mipmaps&&(o.mipmaps=i.mipmaps),1===i.mipmapCount&&(o.minFilter=Oh),o.needsUpdate=!0,e&&e(o,i))},i,r),o}}),Object.assign(Xi.prototype,{crossOrigin:"Anonymous",load:function(t,e,i,r){void 0===t&&(t=""),void 0!==this.path&&(t=this.path+t);var n=this,o=Hp.get(t);if(void 0!==o)return n.manager.itemStart(t),setTimeout(function(){e&&e(o),n.manager.itemEnd(t)},0),o;var a=document.createElementNS("http://www.w3.org/1999/xhtml","img");return a.addEventListener("load",function(){Hp.add(t,this),e&&e(this),n.manager.itemEnd(t)},!1),a.addEventListener("error",function(e){r&&r(e),n.manager.itemEnd(t),n.manager.itemError(t)},!1),"data:"!==t.substr(0,5)&&void 0!==this.crossOrigin&&(a.crossOrigin=this.crossOrigin),n.manager.itemStart(t),a.src=t,a},setCrossOrigin:function(t){return this.crossOrigin=t,this},setPath:function(t){return this.path=t,this}}),Object.assign(function(t){this.manager=void 0!==t?t:Wp}.prototype,{crossOrigin:"Anonymous",load:function(t,e,i,r){var n=new x,o=new Xi(this.manager);o.setCrossOrigin(this.crossOrigin),o.setPath(this.path);for(var a=0,s=0;s<t.length;++s)!function(i){o.load(t[i],function(t){n.images[i]=t,6==++a&&(n.needsUpdate=!0,e&&e(n))},void 0,r)}(s);return n},setCrossOrigin:function(t){return this.crossOrigin=t,this},setPath:function(t){return this.path=t,this}}),Object.assign(qi.prototype,{crossOrigin:"Anonymous",load:function(t,e,i,r){var n=new Xi(this.manager);n.setCrossOrigin(this.crossOrigin),n.setPath(this.path);var o=new p;return o.image=n.load(t,function(){var i=t.search(/\.(jpg|jpeg)$/)>0||0===t.search(/^data\:image\/jpeg/);o.format=i?Yh:Zh,o.needsUpdate=!0,void 0!==e&&e(o)},i,r),o},setCrossOrigin:function(t){return this.crossOrigin=t,this},setPath:function(t){return this.path=t,this}}),Yi.prototype=Object.assign(Object.create(bt.prototype),{constructor:Yi,isLight:!0,copy:function(t){return bt.prototype.copy.call(this,t),this.color.copy(t.color),this.intensity=t.intensity,this},toJSON:function(t){var e=bt.prototype.toJSON.call(this,t);return e.object.color=this.color.getHex(),e.object.intensity=this.intensity,void 0!==this.groundColor&&(e.object.groundColor=this.groundColor.getHex()),void 0!==this.distance&&(e.object.distance=this.distance),void 0!==this.angle&&(e.object.angle=this.angle),void 0!==this.decay&&(e.object.decay=this.decay),void 0!==this.penumbra&&(e.object.penumbra=this.penumbra),void 0!==this.shadow&&(e.object.shadow=this.shadow.toJSON()),e}}),Zi.prototype=Object.assign(Object.create(Yi.prototype),{constructor:Zi,isHemisphereLight:!0,copy:function(t){return Yi.prototype.copy.call(this,t),this.groundColor.copy(t.groundColor),this}}),Object.assign(Ki.prototype,{copy:function(t){return this.camera=t.camera.clone(),this.bias=t.bias,this.radius=t.radius,this.mapSize.copy(t.mapSize),this},clone:function(){return(new this.constructor).copy(this)},toJSON:function(){var t={};return 0!==this.bias&&(t.bias=this.bias),1!==this.radius&&(t.radius=this.radius),512===this.mapSize.x&&512===this.mapSize.y||(t.mapSize=this.mapSize.toArray()),t.camera=this.camera.toJSON(!1).object,delete t.camera.matrix,t}}),Qi.prototype=Object.assign(Object.create(Ki.prototype),{constructor:Qi,isSpotLightShadow:!0,update:function(t){var e=this.camera,i=2*Ap.RAD2DEG*t.angle,r=this.mapSize.width/this.mapSize.height,n=t.distance||e.far;i===e.fov&&r===e.aspect&&n===e.far||(e.fov=i,e.aspect=r,e.far=n,e.updateProjectionMatrix())}}),Ji.prototype=Object.assign(Object.create(Yi.prototype),{constructor:Ji,isSpotLight:!0,copy:function(t){return Yi.prototype.copy.call(this,t),this.distance=t.distance,this.angle=t.angle,this.penumbra=t.penumbra,this.decay=t.decay,this.target=t.target.clone(),this.shadow=t.shadow.clone(),this}}),tr.prototype=Object.assign(Object.create(Yi.prototype),{constructor:tr,isPointLight:!0,copy:function(t){return Yi.prototype.copy.call(this,t),this.distance=t.distance,this.decay=t.decay,this.shadow=t.shadow.clone(),this}}),er.prototype=Object.assign(Object.create(Ki.prototype),{constructor:er}),ir.prototype=Object.assign(Object.create(Yi.prototype),{constructor:ir,isDirectionalLight:!0,copy:function(t){return Yi.prototype.copy.call(this,t),this.target=t.target.clone(),this.shadow=t.shadow.clone(),this}}),rr.prototype=Object.assign(Object.create(Yi.prototype),{constructor:rr,isAmbientLight:!0}),nr.prototype=Object.assign(Object.create(Yi.prototype),{constructor:nr,isRectAreaLight:!0,copy:function(t){return Yi.prototype.copy.call(this,t),this.width=t.width,this.height=t.height,this},toJSON:function(t){var e=Yi.prototype.toJSON.call(this,t);return e.object.width=this.width,e.object.height=this.height,e}});var Xp={arraySlice:function(t,e,i){return Xp.isTypedArray(t)?new t.constructor(t.subarray(e,void 0!==i?i:t.length)):t.slice(e,i)},convertArray:function(t,e,i){return!t||!i&&t.constructor===e?t:"number"==typeof e.BYTES_PER_ELEMENT?new e(t):Array.prototype.slice.call(t)},isTypedArray:function(t){return ArrayBuffer.isView(t)&&!(t instanceof DataView)},getKeyframeOrder:function(t){for(var e=t.length,i=new Array(e),r=0;r!==e;++r)i[r]=r;return i.sort(function(e,i){return t[e]-t[i]}),i},sortedArray:function(t,e,i){for(var r=t.length,n=new t.constructor(r),o=0,a=0;a!==r;++o)for(var s=i[o]*e,c=0;c!==e;++c)n[a++]=t[s+c];return n},flattenJSON:function(t,e,i,r){for(var n=1,o=t[0];void 0!==o&&void 0===o[r];)o=t[n++];if(void 0!==o){var a=o[r];if(void 0!==a)if(Array.isArray(a))do{void 0!==(a=o[r])&&(e.push(o.time),i.push.apply(i,a)),o=t[n++]}while(void 0!==o);else if(void 0!==a.toArray)do{void 0!==(a=o[r])&&(e.push(o.time),a.toArray(i,i.length)),o=t[n++]}while(void 0!==o);else do{void 0!==(a=o[r])&&(e.push(o.time),i.push(a)),o=t[n++]}while(void 0!==o)}}};Object.assign(or.prototype,{evaluate:function(t){var e=this,i=this.parameterPositions,r=this._cachedIndex,n=i[r],o=i[r-1];t:{e:{var a;i:{r:if(!(t<n)){for(c=r+2;;){if(void 0===n){if(t<o)break r;return r=i.length,e._cachedIndex=r,e.afterEnd_(r-1,t,o)}if(r===c)break;if(o=n,n=i[++r],t<n)break e}a=i.length;break i}{if(t>=o)break t;var s=i[1];t<s&&(r=2,o=s);for(var c=r-2;;){if(void 0===o)return e._cachedIndex=0,e.beforeStart_(0,t,n);if(r===c)break;if(n=o,o=i[--r-1],t>=o)break e}a=r,r=0}}for(;r<a;){var u=r+a>>>1;t<i[u]?a=u:r=u+1}if(n=i[r],void 0===(o=i[r-1]))return this._cachedIndex=0,this.beforeStart_(0,t,n);if(void 0===n)return r=i.length,this._cachedIndex=r,this.afterEnd_(r-1,o,t)}this._cachedIndex=r,this.intervalChanged_(r,o,n)}return this.interpolate_(r,o,t,n)},settings:null,DefaultSettings_:{},getSettings_:function(){return this.settings||this.DefaultSettings_},copySampleValue_:function(t){for(var e=this.resultBuffer,i=this.sampleValues,r=this.valueSize,n=t*r,o=0;o!==r;++o)e[o]=i[n+o];return e},interpolate_:function(t,e,i,r){throw new Error("call to abstract method")},intervalChanged_:function(t,e,i){}}),Object.assign(or.prototype,{beforeStart_:or.prototype.copySampleValue_,afterEnd_:or.prototype.copySampleValue_}),ar.prototype=Object.assign(Object.create(or.prototype),{constructor:ar,DefaultSettings_:{endingStart:hp,endingEnd:hp},intervalChanged_:function(t,e,i){var r=this.parameterPositions,n=t-2,o=t+1,a=r[n],s=r[o];if(void 0===a)switch(this.getSettings_().endingStart){case 2401:n=t,a=2*e-i;break;case 2402:a=e+r[n=r.length-2]-r[n+1];break;default:n=t,a=i}if(void 0===s)switch(this.getSettings_().endingEnd){case 2401:o=t,s=2*i-e;break;case 2402:o=1,s=i+r[1]-r[0];break;default:o=t-1,s=e}var c=.5*(i-e),u=this.valueSize;this._weightPrev=c/(e-a),this._weightNext=c/(s-i),this._offsetPrev=n*u,this._offsetNext=o*u},interpolate_:function(t,e,i,r){for(var n=this.resultBuffer,o=this.sampleValues,a=this.valueSize,s=t*a,c=s-a,u=this._offsetPrev,l=this._offsetNext,h=this._weightPrev,p=this._weightNext,d=(i-e)/(r-e),f=d*d,m=f*d,g=-h*m+2*h*f-h*d,v=(1+h)*m+(-1.5-2*h)*f+(-.5+h)*d+1,y=(-1-p)*m+(1.5+p)*f+.5*d,b=p*m-p*f,x=0;x!==a;++x)n[x]=g*o[u+x]+v*o[c+x]+y*o[s+x]+b*o[l+x];return n}}),sr.prototype=Object.assign(Object.create(or.prototype),{constructor:sr,interpolate_:function(t,e,i,r){for(var n=this.resultBuffer,o=this.sampleValues,a=this.valueSize,s=t*a,c=s-a,u=(i-e)/(r-e),l=1-u,h=0;h!==a;++h)n[h]=o[c+h]*l+o[s+h]*u;return n}}),cr.prototype=Object.assign(Object.create(or.prototype),{constructor:cr,interpolate_:function(t,e,i,r){return this.copySampleValue_(t-1)}});var qp;qp={TimeBufferType:Float32Array,ValueBufferType:Float32Array,DefaultInterpolation:2301,InterpolantFactoryMethodDiscrete:function(t){return new cr(this.times,this.values,this.getValueSize(),t)},InterpolantFactoryMethodLinear:function(t){return new sr(this.times,this.values,this.getValueSize(),t)},InterpolantFactoryMethodSmooth:function(t){return new ar(this.times,this.values,this.getValueSize(),t)},setInterpolation:function(t){var e;switch(t){case 2300:e=this.InterpolantFactoryMethodDiscrete;break;case 2301:e=this.InterpolantFactoryMethodLinear;break;case 2302:e=this.InterpolantFactoryMethodSmooth}if(void 0!==e)this.createInterpolant=e;else{var i="unsupported interpolation for "+this.ValueTypeName+" keyframe track named "+this.name;if(void 0===this.createInterpolant){if(t===this.DefaultInterpolation)throw new Error(i);this.setInterpolation(this.DefaultInterpolation)}console.warn("THREE.KeyframeTrackPrototype:",i)}},getInterpolation:function(){switch(this.createInterpolant){case this.InterpolantFactoryMethodDiscrete:return 2300;case this.InterpolantFactoryMethodLinear:return 2301;case this.InterpolantFactoryMethodSmooth:return 2302}},getValueSize:function(){return this.values.length/this.times.length},shift:function(t){if(0!==t)for(var e=this.times,i=0,r=e.length;i!==r;++i)e[i]+=t;return this},scale:function(t){if(1!==t)for(var e=this.times,i=0,r=e.length;i!==r;++i)e[i]*=t;return this},trim:function(t,e){for(var i=this.times,r=i.length,n=0,o=r-1;n!==r&&i[n]<t;)++n;for(;-1!==o&&i[o]>e;)--o;if(++o,0!==n||o!==r){n>=o&&(n=(o=Math.max(o,1))-1);var a=this.getValueSize();this.times=Xp.arraySlice(i,n,o),this.values=Xp.arraySlice(this.values,n*a,o*a)}return this},validate:function(){var t=this,e=!0,i=this.getValueSize();i-Math.floor(i)!=0&&(console.error("THREE.KeyframeTrackPrototype: Invalid value size in track.",this),e=!1);var r=this.times,n=this.values,o=r.length;0===o&&(console.error("THREE.KeyframeTrackPrototype: Track is empty.",this),e=!1);for(var a=null,s=0;s!==o;s++){var c=r[s];if("number"==typeof c&&isNaN(c)){console.error("THREE.KeyframeTrackPrototype: Time is not a valid number.",t,s,c),e=!1;break}if(null!==a&&a>c){console.error("THREE.KeyframeTrackPrototype: Out of order keys.",t,s,c,a),e=!1;break}a=c}if(void 0!==n&&Xp.isTypedArray(n))for(var s=0,u=n.length;s!==u;++s){var l=n[s];if(isNaN(l)){console.error("THREE.KeyframeTrackPrototype: Value is not a valid number.",t,s,l),e=!1;break}}return e},optimize:function(){for(var t=this.times,e=this.values,i=this.getValueSize(),r=2302===this.getInterpolation(),n=1,o=t.length-1,a=1;a<o;++a){var s=!1,c=t[a];if(c!==t[a+1]&&(1!==a||c!==c[0]))if(r)s=!0;else for(var u=a*i,l=u-i,h=u+i,p=0;p!==i;++p){var d=e[u+p];if(d!==e[l+p]||d!==e[h+p]){s=!0;break}}if(s){if(a!==n){t[n]=t[a];for(var f=a*i,m=n*i,p=0;p!==i;++p)e[m+p]=e[f+p]}++n}}if(o>0){t[n]=t[o];for(var f=o*i,m=n*i,p=0;p!==i;++p)e[m+p]=e[f+p];++n}return n!==t.length&&(this.times=Xp.arraySlice(t,0,n),this.values=Xp.arraySlice(e,0,n*i)),this}},lr.prototype=Object.assign(Object.create(qp),{constructor:lr,ValueTypeName:"vector"}),hr.prototype=Object.assign(Object.create(or.prototype),{constructor:hr,interpolate_:function(t,e,i,r){for(var n=this.resultBuffer,o=this.sampleValues,a=this.valueSize,s=t*a,c=(i-e)/(r-e),u=s+a;s!==u;s+=4)g.slerpFlat(n,0,o,s-a,o,s,c);return n}}),pr.prototype=Object.assign(Object.create(qp),{constructor:pr,ValueTypeName:"quaternion",DefaultInterpolation:2301,InterpolantFactoryMethodLinear:function(t){return new hr(this.times,this.values,this.getValueSize(),t)},InterpolantFactoryMethodSmooth:void 0}),dr.prototype=Object.assign(Object.create(qp),{constructor:dr,ValueTypeName:"number"}),fr.prototype=Object.assign(Object.create(qp),{constructor:fr,ValueTypeName:"string",ValueBufferType:Array,DefaultInterpolation:2300,InterpolantFactoryMethodLinear:void 0,InterpolantFactoryMethodSmooth:void 0}),mr.prototype=Object.assign(Object.create(qp),{constructor:mr,ValueTypeName:"bool",ValueBufferType:Array,DefaultInterpolation:2300,InterpolantFactoryMethodLinear:void 0,InterpolantFactoryMethodSmooth:void 0}),gr.prototype=Object.assign(Object.create(qp),{constructor:gr,ValueTypeName:"color"}),vr.prototype=qp,qp.constructor=vr,Object.assign(vr,{parse:function(t){if(void 0===t.type)throw new Error("track type undefined, can not parse");var e=vr._getTrackTypeForValueTypeName(t.type);if(void 0===t.times){var i=[],r=[];Xp.flattenJSON(t.keys,i,r,"value"),t.times=i,t.values=r}return void 0!==e.parse?e.parse(t):new e(t.name,t.times,t.values,t.interpolation)},toJSON:function(t){var e,i=t.constructor;if(void 0!==i.toJSON)e=i.toJSON(t);else{e={name:t.name,times:Xp.convertArray(t.times,Array),values:Xp.convertArray(t.values,Array)};var r=t.getInterpolation();r!==t.DefaultInterpolation&&(e.interpolation=r)}return e.type=t.ValueTypeName,e},_getTrackTypeForValueTypeName:function(t){switch(t.toLowerCase()){case"scalar":case"double":case"float":case"number":case"integer":return dr;case"vector":case"vector2":case"vector3":case"vector4":return lr;case"color":return gr;case"quaternion":return pr;case"bool":case"boolean":return mr;case"string":return fr}throw new Error("Unsupported typeName: "+t)}}),Object.assign(yr,{parse:function(t){for(var e=[],i=t.tracks,r=1/(t.fps||1),n=0,o=i.length;n!==o;++n)e.push(vr.parse(i[n]).scale(r));return new yr(t.name,t.duration,e)},toJSON:function(t){for(var e=[],i=t.tracks,r={name:t.name,duration:t.duration,tracks:e},n=0,o=i.length;n!==o;++n)e.push(vr.toJSON(i[n]));return r},CreateFromMorphTargetSequence:function(t,e,i,r){for(var n=e.length,o=[],a=0;a<n;a++){var s=[],c=[];s.push((a+n-1)%n,a,(a+1)%n),c.push(0,1,0);var u=Xp.getKeyframeOrder(s);s=Xp.sortedArray(s,1,u),c=Xp.sortedArray(c,1,u),r||0!==s[0]||(s.push(n),c.push(c[0])),o.push(new dr(".morphTargetInfluences["+e[a].name+"]",s,c).scale(1/i))}return new yr(t,-1,o)},findByName:function(t,e){var i=t;if(!Array.isArray(t)){var r=t;i=r.geometry&&r.geometry.animations||r.animations}for(var n=0;n<i.length;n++)if(i[n].name===e)return i[n];return null},CreateClipsFromMorphTargetSequences:function(t,e,i){for(var r={},n=/^([\w-]*?)([\d]+)$/,o=0,a=t.length;o<a;o++){var s=t[o],c=s.name.match(n);if(c&&c.length>1){var u=r[h=c[1]];u||(r[h]=u=[]),u.push(s)}}var l=[];for(var h in r)l.push(yr.CreateFromMorphTargetSequence(h,r[h],e,i));return l},parseAnimation:function(t,e){if(!t)return console.error("THREE.AnimationClip: No animation in JSONLoader data."),null;for(var i=function(t,e,i,r,n){if(0!==i.length){var o=[],a=[];Xp.flattenJSON(i,o,a,r),0!==o.length&&n.push(new t(e,o,a))}},r=[],n=t.name||"default",o=t.length||-1,a=t.fps||30,s=t.hierarchy||[],c=0;c<s.length;c++){var u=s[c].keys;if(u&&0!==u.length)if(u[0].morphTargets){for(var l={},h=0;h<u.length;h++)if(u[h].morphTargets)for(m=0;m<u[h].morphTargets.length;m++)l[u[h].morphTargets[m]]=-1;for(var p in l){for(var d=[],f=[],m=0;m!==u[h].morphTargets.length;++m){var g=u[h];d.push(g.time),f.push(g.morphTarget===p?1:0)}r.push(new dr(".morphTargetInfluence["+p+"]",d,f))}o=l.length*(a||1)}else{var v=".bones["+e[c].name+"]";i(lr,v+".position",u,"pos",r),i(pr,v+".quaternion",u,"rot",r),i(lr,v+".scale",u,"scl",r)}}return 0===r.length?null:new yr(n,o,r)}}),Object.assign(yr.prototype,{resetDuration:function(){for(var t=this,e=0,i=0,r=this.tracks.length;i!==r;++i){var n=t.tracks[i];e=Math.max(e,n.times[n.times.length-1])}this.duration=e},trim:function(){for(var t=this,e=0;e<this.tracks.length;e++)t.tracks[e].trim(0,t.duration);return this},optimize:function(){for(var t=this,e=0;e<this.tracks.length;e++)t.tracks[e].optimize();return this}}),Object.assign(br.prototype,{load:function(t,e,i,r){var n=this;new Wi(n.manager).load(t,function(t){e(n.parse(JSON.parse(t)))},i,r)},setTextures:function(t){this.textures=t},parse:function(t){function e(t){return void 0===i[t]&&console.warn("THREE.MaterialLoader: Undefined texture",t),i[t]}var i=this.textures,r=new $p[t.type];if(void 0!==t.uuid&&(r.uuid=t.uuid),void 0!==t.name&&(r.name=t.name),void 0!==t.color&&r.color.setHex(t.color),void 0!==t.roughness&&(r.roughness=t.roughness),void 0!==t.metalness&&(r.metalness=t.metalness),void 0!==t.emissive&&r.emissive.setHex(t.emissive),void 0!==t.specular&&r.specular.setHex(t.specular),void 0!==t.shininess&&(r.shininess=t.shininess),void 0!==t.clearCoat&&(r.clearCoat=t.clearCoat),void 0!==t.clearCoatRoughness&&(r.clearCoatRoughness=t.clearCoatRoughness),void 0!==t.uniforms&&(r.uniforms=t.uniforms),void 0!==t.vertexShader&&(r.vertexShader=t.vertexShader),void 0!==t.fragmentShader&&(r.fragmentShader=t.fragmentShader),void 0!==t.vertexColors&&(r.vertexColors=t.vertexColors),void 0!==t.fog&&(r.fog=t.fog),void 0!==t.flatShading&&(r.flatShading=t.flatShading),void 0!==t.blending&&(r.blending=t.blending),void 0!==t.side&&(r.side=t.side),void 0!==t.opacity&&(r.opacity=t.opacity),void 0!==t.transparent&&(r.transparent=t.transparent),void 0!==t.alphaTest&&(r.alphaTest=t.alphaTest),void 0!==t.depthTest&&(r.depthTest=t.depthTest),void 0!==t.depthWrite&&(r.depthWrite=t.depthWrite),void 0!==t.colorWrite&&(r.colorWrite=t.colorWrite),void 0!==t.wireframe&&(r.wireframe=t.wireframe),void 0!==t.wireframeLinewidth&&(r.wireframeLinewidth=t.wireframeLinewidth),void 0!==t.wireframeLinecap&&(r.wireframeLinecap=t.wireframeLinecap),void 0!==t.wireframeLinejoin&&(r.wireframeLinejoin=t.wireframeLinejoin),void 0!==t.skinning&&(r.skinning=t.skinning),void 0!==t.morphTargets&&(r.morphTargets=t.morphTargets),void 0!==t.dithering&&(r.dithering=t.dithering),void 0!==t.visible&&(r.visible=t.visible),void 0!==t.userData&&(r.userData=t.userData),void 0!==t.shading&&(r.flatShading=1===t.shading),void 0!==t.size&&(r.size=t.size),void 0!==t.sizeAttenuation&&(r.sizeAttenuation=t.sizeAttenuation),void 0!==t.map&&(r.map=e(t.map)),void 0!==t.alphaMap&&(r.alphaMap=e(t.alphaMap),r.transparent=!0),void 0!==t.bumpMap&&(r.bumpMap=e(t.bumpMap)),void 0!==t.bumpScale&&(r.bumpScale=t.bumpScale),void 0!==t.normalMap&&(r.normalMap=e(t.normalMap)),void 0!==t.normalScale){var n=t.normalScale;!1===Array.isArray(n)&&(n=[n,n]),r.normalScale=(new h).fromArray(n)}return void 0!==t.displacementMap&&(r.displacementMap=e(t.displacementMap)),void 0!==t.displacementScale&&(r.displacementScale=t.displacementScale),void 0!==t.displacementBias&&(r.displacementBias=t.displacementBias),void 0!==t.roughnessMap&&(r.roughnessMap=e(t.roughnessMap)),void 0!==t.metalnessMap&&(r.metalnessMap=e(t.metalnessMap)),void 0!==t.emissiveMap&&(r.emissiveMap=e(t.emissiveMap)),void 0!==t.emissiveIntensity&&(r.emissiveIntensity=t.emissiveIntensity),void 0!==t.specularMap&&(r.specularMap=e(t.specularMap)),void 0!==t.envMap&&(r.envMap=e(t.envMap)),void 0!==t.reflectivity&&(r.reflectivity=t.reflectivity),void 0!==t.lightMap&&(r.lightMap=e(t.lightMap)),void 0!==t.lightMapIntensity&&(r.lightMapIntensity=t.lightMapIntensity),void 0!==t.aoMap&&(r.aoMap=e(t.aoMap)),void 0!==t.aoMapIntensity&&(r.aoMapIntensity=t.aoMapIntensity),void 0!==t.gradientMap&&(r.gradientMap=e(t.gradientMap)),r}}),Object.assign(xr.prototype,{load:function(t,e,i,r){var n=this;new Wi(n.manager).load(t,function(t){e(n.parse(JSON.parse(t)))},i,r)},parse:function(t){var e=new Ft,i=t.data.index;if(void 0!==i){a=new Yp[i.type](i.array);e.setIndex(new Pt(a,1))}var r=t.data.attributes;for(var n in r){var o=r[n],a=new Yp[o.type](o.array);e.addAttribute(n,new Pt(a,o.itemSize,o.normalized))}var s=t.data.groups||t.data.drawcalls||t.data.offsets;if(void 0!==s)for(var c=0,u=s.length;c!==u;++c){var l=s[c];e.addGroup(l.start,l.count,l.materialIndex)}var h=t.data.boundingSphere;if(void 0!==h){var p=new v;void 0!==h.center&&p.fromArray(h.center),e.boundingSphere=new ht(p,h.radius)}return e}});var Yp={Int8Array:Int8Array,Uint8Array:Uint8Array,Uint8ClampedArray:"undefined"!=typeof Uint8ClampedArray?Uint8ClampedArray:Uint8Array,Int16Array:Int16Array,Uint16Array:Uint16Array,Int32Array:Int32Array,Uint32Array:Uint32Array,Float32Array:Float32Array,Float64Array:Float64Array};_r.Handlers={handlers:[],add:function(t,e){this.handlers.push(t,e)},get:function(t){for(var e=this.handlers,i=0,r=e.length;i<r;i+=2){var n=e[i],o=e[i+1];if(n.test(t))return o}return null}},Object.assign(_r.prototype,{crossOrigin:void 0,extractUrlBase:function(t){var e=t.split("/");return 1===e.length?"./":(e.pop(),e.join("/")+"/")},initMaterials:function(t,e,i){for(var r=this,n=[],o=0;o<t.length;++o)n[o]=r.createMaterial(t[o],e,i);return n},createMaterial:function(){var t={NoBlending:kl,NormalBlending:Bl,AdditiveBlending:Fl,SubtractiveBlending:zl,MultiplyBlending:Ul,CustomBlending:jl},e=new et,i=new qi,r=new br;return function(n,o,a){function s(t,e,r,n,s){var u,l=o+t,h=_r.Handlers.get(l);null!==h?u=h.load(l):(i.setCrossOrigin(a),u=i.load(l)),void 0!==e&&(u.repeat.fromArray(e),1!==e[0]&&(u.wrapS=Eh),1!==e[1]&&(u.wrapT=Eh)),void 0!==r&&u.offset.fromArray(r),void 0!==n&&("repeat"===n[0]&&(u.wrapS=Eh),"mirror"===n[0]&&(u.wrapS=Ch),"repeat"===n[1]&&(u.wrapT=Eh),"mirror"===n[1]&&(u.wrapT=Ch)),void 0!==s&&(u.anisotropy=s);var p=Ap.generateUUID();return c[p]=u,p}var c={},u={uuid:Ap.generateUUID(),type:"MeshLambertMaterial"};for(var l in n){var h=n[l];switch(l){case"DbgColor":case"DbgIndex":case"opticalDensity":case"illumination":break;case"DbgName":u.name=h;break;case"blending":u.blending=t[h];break;case"colorAmbient":case"mapAmbient":console.warn("THREE.Loader.createMaterial:",l,"is no longer supported.");break;case"colorDiffuse":u.color=e.fromArray(h).getHex();break;case"colorSpecular":u.specular=e.fromArray(h).getHex();break;case"colorEmissive":u.emissive=e.fromArray(h).getHex();break;case"specularCoef":u.shininess=h;break;case"shading":"basic"===h.toLowerCase()&&(u.type="MeshBasicMaterial"),"phong"===h.toLowerCase()&&(u.type="MeshPhongMaterial"),"standard"===h.toLowerCase()&&(u.type="MeshStandardMaterial");break;case"mapDiffuse":u.map=s(h,n.mapDiffuseRepeat,n.mapDiffuseOffset,n.mapDiffuseWrap,n.mapDiffuseAnisotropy);break;case"mapDiffuseRepeat":case"mapDiffuseOffset":case"mapDiffuseWrap":case"mapDiffuseAnisotropy":break;case"mapEmissive":u.emissiveMap=s(h,n.mapEmissiveRepeat,n.mapEmissiveOffset,n.mapEmissiveWrap,n.mapEmissiveAnisotropy);break;case"mapEmissiveRepeat":case"mapEmissiveOffset":case"mapEmissiveWrap":case"mapEmissiveAnisotropy":break;case"mapLight":u.lightMap=s(h,n.mapLightRepeat,n.mapLightOffset,n.mapLightWrap,n.mapLightAnisotropy);break;case"mapLightRepeat":case"mapLightOffset":case"mapLightWrap":case"mapLightAnisotropy":break;case"mapAO":u.aoMap=s(h,n.mapAORepeat,n.mapAOOffset,n.mapAOWrap,n.mapAOAnisotropy);break;case"mapAORepeat":case"mapAOOffset":case"mapAOWrap":case"mapAOAnisotropy":break;case"mapBump":u.bumpMap=s(h,n.mapBumpRepeat,n.mapBumpOffset,n.mapBumpWrap,n.mapBumpAnisotropy);break;case"mapBumpScale":u.bumpScale=h;break;case"mapBumpRepeat":case"mapBumpOffset":case"mapBumpWrap":case"mapBumpAnisotropy":break;case"mapNormal":u.normalMap=s(h,n.mapNormalRepeat,n.mapNormalOffset,n.mapNormalWrap,n.mapNormalAnisotropy);break;case"mapNormalFactor":u.normalScale=[h,h];break;case"mapNormalRepeat":case"mapNormalOffset":case"mapNormalWrap":case"mapNormalAnisotropy":break;case"mapSpecular":u.specularMap=s(h,n.mapSpecularRepeat,n.mapSpecularOffset,n.mapSpecularWrap,n.mapSpecularAnisotropy);break;case"mapSpecularRepeat":case"mapSpecularOffset":case"mapSpecularWrap":case"mapSpecularAnisotropy":break;case"mapMetalness":u.metalnessMap=s(h,n.mapMetalnessRepeat,n.mapMetalnessOffset,n.mapMetalnessWrap,n.mapMetalnessAnisotropy);break;case"mapMetalnessRepeat":case"mapMetalnessOffset":case"mapMetalnessWrap":case"mapMetalnessAnisotropy":break;case"mapRoughness":u.roughnessMap=s(h,n.mapRoughnessRepeat,n.mapRoughnessOffset,n.mapRoughnessWrap,n.mapRoughnessAnisotropy);break;case"mapRoughnessRepeat":case"mapRoughnessOffset":case"mapRoughnessWrap":case"mapRoughnessAnisotropy":break;case"mapAlpha":u.alphaMap=s(h,n.mapAlphaRepeat,n.mapAlphaOffset,n.mapAlphaWrap,n.mapAlphaAnisotropy);break;case"mapAlphaRepeat":case"mapAlphaOffset":case"mapAlphaWrap":case"mapAlphaAnisotropy":break;case"flipSided":u.side=Rl;break;case"doubleSided":u.side=Ll;break;case"transparency":console.warn("THREE.Loader.createMaterial: transparency has been renamed to opacity"),u.opacity=h;break;case"depthTest":case"depthWrite":case"colorWrite":case"opacity":case"reflectivity":case"transparent":case"visible":case"wireframe":u[l]=h;break;case"vertexColors":!0===h&&(u.vertexColors=Nl),"face"===h&&(u.vertexColors=Dl);break;default:console.error("THREE.Loader.createMaterial: Unsupported",l,h)}}return"MeshBasicMaterial"===u.type&&delete u.emissive,"MeshPhongMaterial"!==u.type&&delete u.specular,u.opacity<1&&(u.transparent=!0),r.setTextures(c),r.parse(u)}}()}),Object.assign(wr.prototype,{load:function(t,e,i,r){var n=this,o=this.texturePath&&"string"==typeof this.texturePath?this.texturePath:_r.prototype.extractUrlBase(t),a=new Wi(this.manager);a.setWithCredentials(this.withCredentials),a.load(t,function(i){var r=JSON.parse(i),a=r.metadata;if(void 0!==a){var s=a.type;if(void 0!==s){if("object"===s.toLowerCase())return void console.error("THREE.JSONLoader: "+t+" should be loaded with THREE.ObjectLoader instead.");if("scene"===s.toLowerCase())return void console.error("THREE.JSONLoader: "+t+" should be loaded with THREE.SceneLoader instead.")}}var c=n.parse(r,o);e(c.geometry,c.materials)},i,r)},setTexturePath:function(t){this.texturePath=t},parse:function(){function t(t,e){function i(t,e){return t&1<<e}var r,n,o,a,s,c,u,l,p,d,f,m,g,y,b,x,_,w,S,A,M,P,E,T,C,I=t.faces,R=t.vertices,L=t.normals,O=t.colors,D=t.scale,N=0;if(void 0!==t.uvs){for(r=0;r<t.uvs.length;r++)t.uvs[r].length&&N++;for(r=0;r<N;r++)e.faceVertexUvs[r]=[]}for(a=0,s=R.length;a<s;)(w=new v).x=R[a++]*D,w.y=R[a++]*D,w.z=R[a++]*D,e.vertices.push(w);for(a=0,s=I.length;a<s;)if(d=I[a++],f=i(d,0),m=i(d,1),g=i(d,3),y=i(d,4),b=i(d,5),x=i(d,6),_=i(d,7),f){if(A=new St,A.a=I[a],A.b=I[a+1],A.c=I[a+3],M=new St,M.a=I[a+1],M.b=I[a+2],M.c=I[a+3],a+=4,m&&(p=I[a++],A.materialIndex=p,M.materialIndex=p),o=e.faces.length,g)for(r=0;r<N;r++)for(T=t.uvs[r],e.faceVertexUvs[r][o]=[],e.faceVertexUvs[r][o+1]=[],n=0;n<4;n++)C=new h(T[2*(l=I[a++])],T[2*l+1]),2!==n&&e.faceVertexUvs[r][o].push(C),0!==n&&e.faceVertexUvs[r][o+1].push(C);if(y&&(u=3*I[a++],A.normal.set(L[u++],L[u++],L[u]),M.normal.copy(A.normal)),b)for(r=0;r<4;r++)u=3*I[a++],E=new v(L[u++],L[u++],L[u]),2!==r&&A.vertexNormals.push(E),0!==r&&M.vertexNormals.push(E);if(x&&(P=O[c=I[a++]],A.color.setHex(P),M.color.setHex(P)),_)for(r=0;r<4;r++)P=O[c=I[a++]],2!==r&&A.vertexColors.push(new et(P)),0!==r&&M.vertexColors.push(new et(P));e.faces.push(A),e.faces.push(M)}else{if(S=new St,S.a=I[a++],S.b=I[a++],S.c=I[a++],m&&(p=I[a++],S.materialIndex=p),o=e.faces.length,g)for(r=0;r<N;r++)for(T=t.uvs[r],e.faceVertexUvs[r][o]=[],n=0;n<3;n++)C=new h(T[2*(l=I[a++])],T[2*l+1]),e.faceVertexUvs[r][o].push(C);if(y&&(u=3*I[a++],S.normal.set(L[u++],L[u++],L[u])),b)for(r=0;r<3;r++)u=3*I[a++],E=new v(L[u++],L[u++],L[u]),S.vertexNormals.push(E);if(x&&(c=I[a++],S.color.setHex(O[c])),_)for(r=0;r<3;r++)c=I[a++],S.vertexColors.push(new et(O[c]));e.faces.push(S)}}function e(t,e){var i=void 0!==t.influencesPerVertex?t.influencesPerVertex:2;if(t.skinWeights)for(var r=0,n=t.skinWeights.length;r<n;r+=i){var o=t.skinWeights[r],a=i>1?t.skinWeights[r+1]:0,s=i>2?t.skinWeights[r+2]:0,c=i>3?t.skinWeights[r+3]:0;e.skinWeights.push(new d(o,a,s,c))}if(t.skinIndices)for(var r=0,n=t.skinIndices.length;r<n;r+=i){var u=t.skinIndices[r],l=i>1?t.skinIndices[r+1]:0,h=i>2?t.skinIndices[r+2]:0,p=i>3?t.skinIndices[r+3]:0;e.skinIndices.push(new d(u,l,h,p))}e.bones=t.bones,e.bones&&e.bones.length>0&&(e.skinWeights.length!==e.skinIndices.length||e.skinIndices.length!==e.vertices.length)&&console.warn("When skinning, number of vertices ("+e.vertices.length+"), skinIndices ("+e.skinIndices.length+"), and skinWeights ("+e.skinWeights.length+") should match.")}function i(t,e){var i=t.scale;if(void 0!==t.morphTargets)for(var r=0,n=t.morphTargets.length;r<n;r++){e.morphTargets[r]={},e.morphTargets[r].name=t.morphTargets[r].name,e.morphTargets[r].vertices=[];for(var o=e.morphTargets[r].vertices,a=t.morphTargets[r].vertices,s=0,c=a.length;s<c;s+=3){var u=new v;u.x=a[s]*i,u.y=a[s+1]*i,u.z=a[s+2]*i,o.push(u)}}if(void 0!==t.morphColors&&t.morphColors.length>0){console.warn('THREE.JSONLoader: "morphColors" no longer supported. Using them as face colors.');for(var l=e.faces,h=t.morphColors[0].colors,r=0,n=l.length;r<n;r++)l[r].color.fromArray(h,3*r)}}function r(t,e){var i=[],r=[];void 0!==t.animation&&r.push(t.animation),void 0!==t.animations&&(t.animations.length?r=r.concat(t.animations):r.push(t.animations));for(var n=0;n<r.length;n++){var o=yr.parseAnimation(r[n],e.bones);o&&i.push(o)}if(e.morphTargets){var a=yr.CreateClipsFromMorphTargetSequences(e.morphTargets,10);i=i.concat(a)}i.length>0&&(e.animations=i)}return function(n,o){void 0!==n.data&&(n=n.data),void 0!==n.scale?n.scale=1/n.scale:n.scale=1;var a=new Mt;return t(n,a),e(n,a),i(n,a),r(n,a),a.computeFaceNormals(),a.computeBoundingSphere(),void 0===n.materials||0===n.materials.length?{geometry:a}:{geometry:a,materials:_r.prototype.initMaterials(n.materials,o,this.crossOrigin)}}}()}),Object.assign(function(t){this.manager=void 0!==t?t:Wp,this.texturePath=""}.prototype,{load:function(t,e,i,r){""===this.texturePath&&(this.texturePath=t.substring(0,t.lastIndexOf("/")+1));var n=this;new Wi(n.manager).load(t,function(i){var o=null;try{o=JSON.parse(i)}catch(e){return void 0!==r&&r(e),void console.error("THREE:ObjectLoader: Can't parse "+t+".",e.message)}var a=o.metadata;void 0!==a&&void 0!==a.type&&"geometry"!==a.type.toLowerCase()?n.parse(o,e):console.error("THREE.ObjectLoader: Can't load "+t+". Use THREE.JSONLoader instead.")},i,r)},setTexturePath:function(t){this.texturePath=t},setCrossOrigin:function(t){this.crossOrigin=t},parse:function(t,e){var i=this.parseGeometries(t.geometries),r=this.parseImages(t.images,function(){void 0!==e&&e(a)}),n=this.parseTextures(t.textures,r),o=this.parseMaterials(t.materials,n),a=this.parseObject(t.object,i,o);return t.animations&&(a.animations=this.parseAnimations(t.animations)),void 0!==t.images&&0!==t.images.length||void 0!==e&&e(a),a},parseGeometries:function(t){var e=this,i={};if(void 0!==t)for(var r=new wr,n=new xr,o=0,a=t.length;o<a;o++){var s,c=t[o];switch(c.type){case"PlaneGeometry":case"PlaneBufferGeometry":s=new Gp[c.type](c.width,c.height,c.widthSegments,c.heightSegments);break;case"BoxGeometry":case"BoxBufferGeometry":case"CubeGeometry":s=new Gp[c.type](c.width,c.height,c.depth,c.widthSegments,c.heightSegments,c.depthSegments);break;case"CircleGeometry":case"CircleBufferGeometry":s=new Gp[c.type](c.radius,c.segments,c.thetaStart,c.thetaLength);break;case"CylinderGeometry":case"CylinderBufferGeometry":s=new Gp[c.type](c.radiusTop,c.radiusBottom,c.height,c.radialSegments,c.heightSegments,c.openEnded,c.thetaStart,c.thetaLength);break;case"ConeGeometry":case"ConeBufferGeometry":s=new Gp[c.type](c.radius,c.height,c.radialSegments,c.heightSegments,c.openEnded,c.thetaStart,c.thetaLength);break;case"SphereGeometry":case"SphereBufferGeometry":s=new Gp[c.type](c.radius,c.widthSegments,c.heightSegments,c.phiStart,c.phiLength,c.thetaStart,c.thetaLength);break;case"DodecahedronGeometry":case"IcosahedronGeometry":case"OctahedronGeometry":case"TetrahedronGeometry":s=new Gp[c.type](c.radius,c.detail);break;case"RingGeometry":case"RingBufferGeometry":s=new Gp[c.type](c.innerRadius,c.outerRadius,c.thetaSegments,c.phiSegments,c.thetaStart,c.thetaLength);break;case"TorusGeometry":case"TorusBufferGeometry":s=new Gp[c.type](c.radius,c.tube,c.radialSegments,c.tubularSegments,c.arc);break;case"TorusKnotGeometry":case"TorusKnotBufferGeometry":s=new Gp[c.type](c.radius,c.tube,c.tubularSegments,c.radialSegments,c.p,c.q);break;case"LatheGeometry":case"LatheBufferGeometry":s=new Gp[c.type](c.points,c.segments,c.phiStart,c.phiLength);break;case"BufferGeometry":s=n.parse(c);break;case"Geometry":s=r.parse(c,e.texturePath).geometry;break;default:console.warn('THREE.ObjectLoader: Unsupported geometry type "'+c.type+'"');continue}s.uuid=c.uuid,void 0!==c.name&&(s.name=c.name),i[c.uuid]=s}return i},parseMaterials:function(t,e){var i={};if(void 0!==t){var r=new br;r.setTextures(e);for(var n=0,o=t.length;n<o;n++){var a=t[n];if("MultiMaterial"===a.type){for(var s=[],c=0;c<a.materials.length;c++)s.push(r.parse(a.materials[c]));i[a.uuid]=s}else i[a.uuid]=r.parse(a)}}return i},parseAnimations:function(t){for(var e=[],i=0;i<t.length;i++){var r=yr.parse(t[i]);e.push(r)}return e},parseImages:function(t,e){var i=this,r={};if(void 0!==t&&t.length>0){var n=new Xi(new Hi(e));n.setCrossOrigin(this.crossOrigin);for(var o=0,a=t.length;o<a;o++){var s=t[o],c=/^(\/\/)|([a-z]+:(\/\/)?)/i.test(s.url)?s.url:i.texturePath+s.url;r[s.uuid]=function(t){return i.manager.itemStart(t),n.load(t,function(){i.manager.itemEnd(t)},void 0,function(){i.manager.itemEnd(t),i.manager.itemError(t)})}(c)}}return r},parseTextures:function(t,e){function i(t,e){return"number"==typeof t?t:(console.warn("THREE.ObjectLoader.parseTexture: Constant should be in numeric form.",t),e[t])}var r={};if(void 0!==t)for(var n=0,o=t.length;n<o;n++){var a=t[n];void 0===a.image&&console.warn('THREE.ObjectLoader: No "image" specified for',a.uuid),void 0===e[a.image]&&console.warn("THREE.ObjectLoader: Undefined image",a.image);var s=new p(e[a.image]);s.needsUpdate=!0,s.uuid=a.uuid,void 0!==a.name&&(s.name=a.name),void 0!==a.mapping&&(s.mapping=i(a.mapping,Zp)),void 0!==a.offset&&s.offset.fromArray(a.offset),void 0!==a.repeat&&s.repeat.fromArray(a.repeat),void 0!==a.wrap&&(s.wrapS=i(a.wrap[0],Kp),s.wrapT=i(a.wrap[1],Kp)),void 0!==a.minFilter&&(s.minFilter=i(a.minFilter,Qp)),void 0!==a.magFilter&&(s.magFilter=i(a.magFilter,Qp)),void 0!==a.anisotropy&&(s.anisotropy=a.anisotropy),void 0!==a.flipY&&(s.flipY=a.flipY),r[a.uuid]=s}return r},parseObject:function(){var t=new y;return function(e,i,r){function n(t){return void 0===i[t]&&console.warn("THREE.ObjectLoader: Undefined geometry",t),i[t]}function o(t){if(void 0!==t){if(Array.isArray(t)){for(var e=[],i=0,n=t.length;i<n;i++){var o=t[i];void 0===r[o]&&console.warn("THREE.ObjectLoader: Undefined material",o),e.push(r[o])}return e}return void 0===r[t]&&console.warn("THREE.ObjectLoader: Undefined material",t),r[t]}}var a,s=this;switch(e.type){case"Scene":a=new De,void 0!==e.background&&Number.isInteger(e.background)&&(a.background=new et(e.background)),void 0!==e.fog&&("Fog"===e.fog.type?a.fog=new Oe(e.fog.color,e.fog.near,e.fog.far):"FogExp2"===e.fog.type&&(a.fog=new Le(e.fog.color,e.fog.density)));break;case"PerspectiveCamera":a=new wt(e.fov,e.aspect,e.near,e.far),void 0!==e.focus&&(a.focus=e.focus),void 0!==e.zoom&&(a.zoom=e.zoom),void 0!==e.filmGauge&&(a.filmGauge=e.filmGauge),void 0!==e.filmOffset&&(a.filmOffset=e.filmOffset),void 0!==e.view&&(a.view=Object.assign({},e.view));break;case"OrthographicCamera":a=new _t(e.left,e.right,e.top,e.bottom,e.near,e.far);break;case"AmbientLight":a=new rr(e.color,e.intensity);break;case"DirectionalLight":a=new ir(e.color,e.intensity);break;case"PointLight":a=new tr(e.color,e.intensity,e.distance,e.decay);break;case"RectAreaLight":a=new nr(e.color,e.intensity,e.width,e.height);break;case"SpotLight":a=new Ji(e.color,e.intensity,e.distance,e.angle,e.penumbra,e.decay);break;case"HemisphereLight":a=new Zi(e.color,e.groundColor,e.intensity);break;case"SkinnedMesh":console.warn("THREE.ObjectLoader.parseObject() does not support SkinnedMesh yet.");case"Mesh":var c=n(e.geometry),u=o(e.material);a=c.bones&&c.bones.length>0?new je(c,u):new Xt(c,u);break;case"LOD":a=new Fe;break;case"Line":a=new Ge(n(e.geometry),o(e.material),e.mode);break;case"LineLoop":a=new He(n(e.geometry),o(e.material));break;case"LineSegments":a=new $e(n(e.geometry),o(e.material));break;case"PointCloud":case"Points":a=new Xe(n(e.geometry),o(e.material));break;case"Sprite":a=new Be(o(e.material));break;case"Group":a=new qe;break;default:a=new bt}if(a.uuid=e.uuid,void 0!==e.name&&(a.name=e.name),void 0!==e.matrix?(t.fromArray(e.matrix),t.decompose(a.position,a.quaternion,a.scale)):(void 0!==e.position&&a.position.fromArray(e.position),void 0!==e.rotation&&a.rotation.fromArray(e.rotation),void 0!==e.quaternion&&a.quaternion.fromArray(e.quaternion),void 0!==e.scale&&a.scale.fromArray(e.scale)),void 0!==e.castShadow&&(a.castShadow=e.castShadow),void 0!==e.receiveShadow&&(a.receiveShadow=e.receiveShadow),e.shadow&&(void 0!==e.shadow.bias&&(a.shadow.bias=e.shadow.bias),void 0!==e.shadow.radius&&(a.shadow.radius=e.shadow.radius),void 0!==e.shadow.mapSize&&a.shadow.mapSize.fromArray(e.shadow.mapSize),void 0!==e.shadow.camera&&(a.shadow.camera=this.parseObject(e.shadow.camera))),void 0!==e.visible&&(a.visible=e.visible),void 0!==e.userData&&(a.userData=e.userData),void 0!==e.children)for(var l=e.children,h=0;h<l.length;h++)a.add(s.parseObject(l[h],i,r));if("LOD"===e.type)for(var p=e.levels,d=0;d<p.length;d++){var f=p[d],m=a.getObjectByProperty("uuid",f.object);void 0!==m&&a.addLevel(m,f.distance)}return a}}()});var Zp={UVMapping:300,CubeReflectionMapping:xh,CubeRefractionMapping:_h,EquirectangularReflectionMapping:wh,EquirectangularRefractionMapping:Sh,SphericalReflectionMapping:Ah,CubeUVReflectionMapping:Mh,CubeUVRefractionMapping:Ph},Kp={RepeatWrapping:Eh,ClampToEdgeWrapping:Th,MirroredRepeatWrapping:Ch},Qp={NearestFilter:Ih,NearestMipMapNearestFilter:Rh,NearestMipMapLinearFilter:Lh,LinearFilter:Oh,LinearMipMapNearestFilter:Dh,LinearMipMapLinearFilter:Nh};Object.assign(Or.prototype,{getPoint:function(){return console.warn("THREE.Curve: .getPoint() not implemented."),null},getPointAt:function(t){var e=this.getUtoTmapping(t);return this.getPoint(e)},getPoints:function(t){var e=this;void 0===t&&(t=5);for(var i=[],r=0;r<=t;r++)i.push(e.getPoint(r/t));return i},getSpacedPoints:function(t){var e=this;void 0===t&&(t=5);for(var i=[],r=0;r<=t;r++)i.push(e.getPointAt(r/t));return i},getLength:function(){var t=this.getLengths();return t[t.length-1]},getLengths:function(t){var e=this;if(void 0===t&&(t=this.arcLengthDivisions),this.cacheArcLengths&&this.cacheArcLengths.length===t+1&&!this.needsUpdate)return this.cacheArcLengths;this.needsUpdate=!1;var i,r,n=[],o=this.getPoint(0),a=0;for(n.push(0),r=1;r<=t;r++)a+=(i=e.getPoint(r/t)).distanceTo(o),n.push(a),o=i;return this.cacheArcLengths=n,n},updateArcLengths:function(){this.needsUpdate=!0,this.getLengths()},getUtoTmapping:function(t,e){var i,r=this.getLengths(),n=0,o=r.length;i=e||t*r[o-1];for(var a,s=0,c=o-1;s<=c;)if(n=Math.floor(s+(c-s)/2),(a=r[n]-i)<0)s=n+1;else{if(!(a>0)){c=n;break}c=n-1}if(n=c,r[n]===i)return n/(o-1);var u=r[n];return(n+(i-u)/(r[n+1]-u))/(o-1)},getTangent:function(t){var e=t-1e-4,i=t+1e-4;e<0&&(e=0),i>1&&(i=1);var r=this.getPoint(e);return this.getPoint(i).clone().sub(r).normalize()},getTangentAt:function(t){var e=this.getUtoTmapping(t);return this.getTangent(e)},computeFrenetFrames:function(t,e){var i,r,n,o=this,a=new v,s=[],c=[],u=[],l=new v,h=new y;for(i=0;i<=t;i++)r=i/t,s[i]=o.getTangentAt(r),s[i].normalize();c[0]=new v,u[0]=new v;var p=Number.MAX_VALUE,d=Math.abs(s[0].x),f=Math.abs(s[0].y),m=Math.abs(s[0].z);for(d<=p&&(p=d,a.set(1,0,0)),f<=p&&(p=f,a.set(0,1,0)),m<=p&&a.set(0,0,1),l.crossVectors(s[0],a).normalize(),c[0].crossVectors(s[0],l),u[0].crossVectors(s[0],c[0]),i=1;i<=t;i++)c[i]=c[i-1].clone(),u[i]=u[i-1].clone(),l.crossVectors(s[i-1],s[i]),l.length()>Number.EPSILON&&(l.normalize(),n=Math.acos(Ap.clamp(s[i-1].dot(s[i]),-1,1)),c[i].applyMatrix4(h.makeRotationAxis(l,n))),u[i].crossVectors(s[i],c[i]);if(!0===e)for(n=Math.acos(Ap.clamp(c[0].dot(c[t]),-1,1)),n/=t,s[0].dot(l.crossVectors(c[0],c[t]))>0&&(n=-n),i=1;i<=t;i++)c[i].applyMatrix4(h.makeRotationAxis(s[i],n*i)),u[i].crossVectors(s[i],c[i]);return{tangents:s,normals:c,binormals:u}}}),(Dr.prototype=Object.create(Or.prototype)).constructor=Dr,Dr.prototype.isLineCurve=!0,Dr.prototype.getPoint=function(t){if(1===t)return this.v2.clone();var e=this.v2.clone().sub(this.v1);return e.multiplyScalar(t).add(this.v1),e},Dr.prototype.getPointAt=function(t){return this.getPoint(t)},Dr.prototype.getTangent=function(t){return this.v2.clone().sub(this.v1).normalize()},Nr.prototype=Object.assign(Object.create(Or.prototype),{constructor:Nr,add:function(t){this.curves.push(t)},closePath:function(){var t=this.curves[0].getPoint(0),e=this.curves[this.curves.length-1].getPoint(1);t.equals(e)||this.curves.push(new Dr(e,t))},getPoint:function(t){for(var e=this,i=t*this.getLength(),r=this.getCurveLengths(),n=0;n<r.length;){if(r[n]>=i){var o=r[n]-i,a=e.curves[n],s=a.getLength(),c=0===s?0:1-o/s;return a.getPointAt(c)}n++}return null},getLength:function(){var t=this.getCurveLengths();return t[t.length-1]},updateArcLengths:function(){this.needsUpdate=!0,this.cacheLengths=null,this.getCurveLengths()},getCurveLengths:function(){var t=this;if(this.cacheLengths&&this.cacheLengths.length===this.curves.length)return this.cacheLengths;for(var e=[],i=0,r=0,n=this.curves.length;r<n;r++)i+=t.curves[r].getLength(),e.push(i);return this.cacheLengths=e,e},getSpacedPoints:function(t){var e=this;void 0===t&&(t=40);for(var i=[],r=0;r<=t;r++)i.push(e.getPoint(r/t));return this.autoClose&&i.push(i[0]),i},getPoints:function(t){t=t||12;for(var e,i=[],r=0,n=this.curves;r<n.length;r++)for(var o=n[r],a=o&&o.isEllipseCurve?2*t:o&&o.isLineCurve?1:o&&o.isSplineCurve?t*o.points.length:t,s=o.getPoints(a),c=0;c<s.length;c++){var u=s[c];e&&e.equals(u)||(i.push(u),e=u)}return this.autoClose&&i.length>1&&!i[i.length-1].equals(i[0])&&i.push(i[0]),i},createPointsGeometry:function(t){var e=this.getPoints(t);return this.createGeometry(e)},createSpacedPointsGeometry:function(t){var e=this.getSpacedPoints(t);return this.createGeometry(e)},createGeometry:function(t){for(var e=new Mt,i=0,r=t.length;i<r;i++){var n=t[i];e.vertices.push(new v(n.x,n.y,n.z||0))}return e}}),kr.prototype=Object.create(Or.prototype),kr.prototype.constructor=kr,kr.prototype.isEllipseCurve=!0,kr.prototype.getPoint=function(t){for(var e=2*Math.PI,i=this.aEndAngle-this.aStartAngle,r=Math.abs(i)<Number.EPSILON;i<0;)i+=e;for(;i>e;)i-=e;i<Number.EPSILON&&(i=r?0:e),!0!==this.aClockwise||r||(i===e?i=-e:i-=e);var n=this.aStartAngle+t*i,o=this.aX+this.xRadius*Math.cos(n),a=this.aY+this.yRadius*Math.sin(n);if(0!==this.aRotation){var s=Math.cos(this.aRotation),c=Math.sin(this.aRotation),u=o-this.aX,l=a-this.aY;o=u*s-l*c+this.aX,a=u*c+l*s+this.aY}return new h(o,a)},(Br.prototype=Object.create(Or.prototype)).constructor=Br,Br.prototype.isSplineCurve=!0,Br.prototype.getPoint=function(t){var e=this.points,i=(e.length-1)*t,r=Math.floor(i),n=i-r,o=e[0===r?r:r-1],a=e[r],s=e[r>e.length-2?e.length-1:r+1],c=e[r>e.length-3?e.length-1:r+2];return new h(Sr(n,o.x,a.x,s.x,c.x),Sr(n,o.y,a.y,s.y,c.y))},(Fr.prototype=Object.create(Or.prototype)).constructor=Fr,Fr.prototype.getPoint=function(t){var e=this.v0,i=this.v1,r=this.v2,n=this.v3;return new h(Lr(t,e.x,i.x,r.x,n.x),Lr(t,e.y,i.y,r.y,n.y))},(zr.prototype=Object.create(Or.prototype)).constructor=zr,zr.prototype.getPoint=function(t){var e=this.v0,i=this.v1,r=this.v2;return new h(Er(t,e.x,i.x,r.x),Er(t,e.y,i.y,r.y))};var Jp=Object.assign(Object.create(Nr.prototype),{fromPoints:function(t){var e=this;this.moveTo(t[0].x,t[0].y);for(var i=1,r=t.length;i<r;i++)e.lineTo(t[i].x,t[i].y)},moveTo:function(t,e){this.currentPoint.set(t,e)},lineTo:function(t,e){var i=new Dr(this.currentPoint.clone(),new h(t,e));this.curves.push(i),this.currentPoint.set(t,e)},quadraticCurveTo:function(t,e,i,r){var n=new zr(this.currentPoint.clone(),new h(t,e),new h(i,r));this.curves.push(n),this.currentPoint.set(i,r)},bezierCurveTo:function(t,e,i,r,n,o){var a=new Fr(this.currentPoint.clone(),new h(t,e),new h(i,r),new h(n,o));this.curves.push(a),this.currentPoint.set(n,o)},splineThru:function(t){var e=new Br([this.currentPoint.clone()].concat(t));this.curves.push(e),this.currentPoint.copy(t[t.length-1])},arc:function(t,e,i,r,n,o){var a=this.currentPoint.x,s=this.currentPoint.y;this.absarc(t+a,e+s,i,r,n,o)},absarc:function(t,e,i,r,n,o){this.absellipse(t,e,i,i,r,n,o)},ellipse:function(t,e,i,r,n,o,a,s){var c=this.currentPoint.x,u=this.currentPoint.y;this.absellipse(t+c,e+u,i,r,n,o,a,s)},absellipse:function(t,e,i,r,n,o,a,s){var c=new kr(t,e,i,r,n,o,a,s);if(this.curves.length>0){var u=c.getPoint(0);u.equals(this.currentPoint)||this.lineTo(u.x,u.y)}this.curves.push(c);var l=c.getPoint(1);this.currentPoint.copy(l)}});Ur.prototype=Jp,Jp.constructor=Ur,jr.prototype=Object.assign(Object.create(Jp),{constructor:jr,getPointsHoles:function(t){for(var e=this,i=[],r=0,n=this.holes.length;r<n;r++)i[r]=e.holes[r].getPoints(t);return i},extractAllPoints:function(t){return{shape:this.getPoints(t),holes:this.getPointsHoles(t)}},extractPoints:function(t){return this.extractAllPoints(t)}}),Object.assign(Vr.prototype,{moveTo:function(t,e){this.currentPath=new Ur,this.subPaths.push(this.currentPath),this.currentPath.moveTo(t,e)},lineTo:function(t,e){this.currentPath.lineTo(t,e)},quadraticCurveTo:function(t,e,i,r){this.currentPath.quadraticCurveTo(t,e,i,r)},bezierCurveTo:function(t,e,i,r,n,o){this.currentPath.bezierCurveTo(t,e,i,r,n,o)},splineThru:function(t){this.currentPath.splineThru(t)},toShapes:function(t,e){function i(t){for(var e=[],i=0,r=t.length;i<r;i++){var n=t[i],o=new jr;o.curves=n.curves,e.push(o)}return e}var r=Vp.isClockWise,n=this.subPaths;if(0===n.length)return[];if(!0===e)return i(n);var o,a,s,c=[];if(1===n.length)return a=n[0],s=new jr,s.curves=a.curves,c.push(s),c;var u=!r(n[0].getPoints());u=t?!u:u;var l,h=[],p=[],d=[],f=0;p[f]=void 0,d[f]=[];for(var m=0,g=n.length;m<g;m++)o=r(l=(a=n[m]).getPoints()),(o=t?!o:o)?(!u&&p[f]&&f++,p[f]={s:new jr,p:l},p[f].s.curves=a.curves,u&&f++,d[f]=[]):d[f].push({h:a,p:l[0]});if(!p[0])return i(n);if(p.length>1){for(var v=!1,y=[],b=0,x=p.length;b<x;b++)h[b]=[];for(var b=0,x=p.length;b<x;b++)for(var _=d[b],w=0;w<_.length;w++){for(var S=_[w],A=!0,M=0;M<p.length;M++)(function(t,e){for(var i=e.length,r=!1,n=i-1,o=0;o<i;n=o++){var a=e[n],s=e[o],c=s.x-a.x,u=s.y-a.y;if(Math.abs(u)>Number.EPSILON){if(u<0&&(a=e[o],c=-c,s=e[n],u=-u),t.y<a.y||t.y>s.y)continue;if(t.y===a.y){if(t.x===a.x)return!0}else{var l=u*(t.x-a.x)-c*(t.y-a.y);if(0===l)return!0;if(l<0)continue;r=!r}}else{if(t.y!==a.y)continue;if(s.x<=t.x&&t.x<=a.x||a.x<=t.x&&t.x<=s.x)return!0}}return r})(S.p,p[M].p)&&(b!==M&&y.push({froms:b,tos:M,hole:w}),A?(A=!1,h[M].push(S)):v=!0);A&&h[b].push(S)}y.length>0&&(v||(d=h))}for(var P,m=0,E=p.length;m<E;m++){s=p[m].s,c.push(s);for(var T=0,C=(P=d[m]).length;T<C;T++)s.holes.push(P[T].h)}return c}}),Object.assign(Gr.prototype,{isFont:!0,generateShapes:function(t,e,i){function r(t,e,r,o){var a=n.glyphs[t]||n.glyphs["?"];if(a){var s,c,u,l,h,p,d,f,m,g,v,y=new Vr,b=[];if(a.o)for(var x=a._cachedOutline||(a._cachedOutline=a.o.split(" ")),_=0,w=x.length;_<w;)switch(x[_++]){case"m":s=x[_++]*e+r,c=x[_++]*e+o,y.moveTo(s,c);break;case"l":s=x[_++]*e+r,c=x[_++]*e+o,y.lineTo(s,c);break;case"q":if(u=x[_++]*e+r,l=x[_++]*e+o,d=x[_++]*e+r,f=x[_++]*e+o,y.quadraticCurveTo(d,f,u,l),v=b[b.length-1]){h=v.x,p=v.y;for(S=1;S<=i;S++)Er(A=S/i,h,d,u),Er(A,p,f,l)}break;case"b":if(u=x[_++]*e+r,l=x[_++]*e+o,d=x[_++]*e+r,f=x[_++]*e+o,m=x[_++]*e+r,g=x[_++]*e+o,y.bezierCurveTo(d,f,m,g,u,l),v=b[b.length-1]){h=v.x,p=v.y;for(var S=1;S<=i;S++){var A=S/i;Lr(A,h,d,m,u),Lr(A,p,f,g,l)}}}return{offsetX:a.ha*e,path:y}}}void 0===e&&(e=100),void 0===i&&(i=4);for(var n=this.data,o=function(t){for(var i=String(t).split(""),o=e/n.resolution,a=(n.boundingBox.yMax-n.boundingBox.yMin+n.underlineThickness)*o,s=0,c=0,u=[],l=0;l<i.length;l++){var h=i[l];if("\n"===h)s=0,c-=a;else{var p=r(h,o,s,c);s+=p.offsetX,u.push(p.path)}}return u}(t),a=[],s=0,c=o.length;s<c;s++)Array.prototype.push.apply(a,o[s].toShapes());return a}}),Object.assign(function(t){this.manager=void 0!==t?t:Wp}.prototype,{load:function(t,e,i,r){var n=this;new Wi(this.manager).load(t,function(t){var i;try{i=JSON.parse(t)}catch(e){console.warn("THREE.FontLoader: typeface.js support is being deprecated. Use typeface.json instead."),i=JSON.parse(t.substring(65,t.length-2))}var r=n.parse(i);e&&e(r)},i,r)},parse:function(t){return new Gr(t)}});var td,ed={getContext:function(){return void 0===td&&(td=new(window.AudioContext||window.webkitAudioContext)),td},setContext:function(t){td=t}};Object.assign($r.prototype,{load:function(t,e,i,r){var n=new Wi(this.manager);n.setResponseType("arraybuffer"),n.load(t,function(t){ed.getContext().decodeAudioData(t,function(t){e(t)})},i,r)}}),Object.assign(function(){this.type="StereoCamera",this.aspect=1,this.eyeSep=.064,this.cameraL=new wt,this.cameraL.layers.enable(1),this.cameraL.matrixAutoUpdate=!1,this.cameraR=new wt,this.cameraR.layers.enable(2),this.cameraR.matrixAutoUpdate=!1}.prototype,{update:function(){var t,e,i,r,n,o,a,s,c=new y,u=new y;return function(l){if(t!==this||e!==l.focus||i!==l.fov||r!==l.aspect*this.aspect||n!==l.near||o!==l.far||a!==l.zoom||s!==this.eyeSep){t=this,e=l.focus,i=l.fov,r=l.aspect*this.aspect,n=l.near,o=l.far,a=l.zoom;var h,p,d=l.projectionMatrix.clone(),f=(s=this.eyeSep/2)*n/e,m=n*Math.tan(Ap.DEG2RAD*i*.5)/a;u.elements[12]=-s,c.elements[12]=s,h=-m*r+f,p=m*r+f,d.elements[0]=2*n/(p-h),d.elements[8]=(p+h)/(p-h),this.cameraL.projectionMatrix.copy(d),h=-m*r-f,p=m*r-f,d.elements[0]=2*n/(p-h),d.elements[8]=(p+h)/(p-h),this.cameraR.projectionMatrix.copy(d)}this.cameraL.matrixWorld.copy(l.matrixWorld).multiply(u),this.cameraR.matrixWorld.copy(l.matrixWorld).multiply(c)}}()}),(Hr.prototype=Object.create(bt.prototype)).constructor=Hr,Wr.prototype=Object.assign(Object.create(bt.prototype),{constructor:Wr,getInput:function(){return this.gain},removeFilter:function(){null!==this.filter&&(this.gain.disconnect(this.filter),this.filter.disconnect(this.context.destination),this.gain.connect(this.context.destination),this.filter=null)},getFilter:function(){return this.filter},setFilter:function(t){null!==this.filter?(this.gain.disconnect(this.filter),this.filter.disconnect(this.context.destination)):this.gain.disconnect(this.context.destination),this.filter=t,this.gain.connect(this.filter),this.filter.connect(this.context.destination)},getMasterVolume:function(){return this.gain.gain.value},setMasterVolume:function(t){this.gain.gain.value=t},updateMatrixWorld:function(){var t=new v,e=new g,i=new v,r=new v;return function(n){bt.prototype.updateMatrixWorld.call(this,n);var o=this.context.listener,a=this.up;this.matrixWorld.decompose(t,e,i),r.set(0,0,-1).applyQuaternion(e),o.positionX?(o.positionX.setValueAtTime(t.x,this.context.currentTime),o.positionY.setValueAtTime(t.y,this.context.currentTime),o.positionZ.setValueAtTime(t.z,this.context.currentTime),o.forwardX.setValueAtTime(r.x,this.context.currentTime),o.forwardY.setValueAtTime(r.y,this.context.currentTime),o.forwardZ.setValueAtTime(r.z,this.context.currentTime),o.upX.setValueAtTime(a.x,this.context.currentTime),o.upY.setValueAtTime(a.y,this.context.currentTime),o.upZ.setValueAtTime(a.z,this.context.currentTime)):(o.setPosition(t.x,t.y,t.z),o.setOrientation(r.x,r.y,r.z,a.x,a.y,a.z))}}()}),Xr.prototype=Object.assign(Object.create(bt.prototype),{constructor:Xr,getOutput:function(){return this.gain},setNodeSource:function(t){return this.hasPlaybackControl=!1,this.sourceType="audioNode",this.source=t,this.connect(),this},setBuffer:function(t){return this.buffer=t,this.sourceType="buffer",this.autoplay&&this.play(),this},play:function(){if(!0!==this.isPlaying){if(!1!==this.hasPlaybackControl){var t=this.context.createBufferSource();return t.buffer=this.buffer,t.loop=this.loop,t.onended=this.onEnded.bind(this),t.playbackRate.setValueAtTime(this.playbackRate,this.startTime),t.start(0,this.startTime),this.isPlaying=!0,this.source=t,this.connect()}console.warn("THREE.Audio: this Audio has no playback control.")}else console.warn("THREE.Audio: Audio is already playing.")},pause:function(){if(!1!==this.hasPlaybackControl)return this.source.stop(),this.startTime=this.context.currentTime,this.isPlaying=!1,this;console.warn("THREE.Audio: this Audio has no playback control.")},stop:function(){if(!1!==this.hasPlaybackControl)return this.source.stop(),this.startTime=0,this.isPlaying=!1,this;console.warn("THREE.Audio: this Audio has no playback control.")},connect:function(){var t=this;if(this.filters.length>0){this.source.connect(this.filters[0]);for(var e=1,i=this.filters.length;e<i;e++)t.filters[e-1].connect(t.filters[e]);this.filters[this.filters.length-1].connect(this.getOutput())}else this.source.connect(this.getOutput());return this},disconnect:function(){var t=this;if(this.filters.length>0){this.source.disconnect(this.filters[0]);for(var e=1,i=this.filters.length;e<i;e++)t.filters[e-1].disconnect(t.filters[e]);this.filters[this.filters.length-1].disconnect(this.getOutput())}else this.source.disconnect(this.getOutput());return this},getFilters:function(){return this.filters},setFilters:function(t){return t||(t=[]),!0===this.isPlaying?(this.disconnect(),this.filters=t,this.connect()):this.filters=t,this},getFilter:function(){return this.getFilters()[0]},setFilter:function(t){return this.setFilters(t?[t]:[])},setPlaybackRate:function(t){if(!1!==this.hasPlaybackControl)return this.playbackRate=t,!0===this.isPlaying&&this.source.playbackRate.setValueAtTime(this.playbackRate,this.context.currentTime),this;console.warn("THREE.Audio: this Audio has no playback control.")},getPlaybackRate:function(){return this.playbackRate},onEnded:function(){this.isPlaying=!1},getLoop:function(){return!1===this.hasPlaybackControl?(console.warn("THREE.Audio: this Audio has no playback control."),!1):this.loop},setLoop:function(t){if(!1!==this.hasPlaybackControl)return this.loop=t,!0===this.isPlaying&&(this.source.loop=this.loop),this;console.warn("THREE.Audio: this Audio has no playback control.")},getVolume:function(){return this.gain.gain.value},setVolume:function(t){return this.gain.gain.value=t,this}}),qr.prototype=Object.assign(Object.create(Xr.prototype),{constructor:qr,getOutput:function(){return this.panner},getRefDistance:function(){return this.panner.refDistance},setRefDistance:function(t){this.panner.refDistance=t},getRolloffFactor:function(){return this.panner.rolloffFactor},setRolloffFactor:function(t){this.panner.rolloffFactor=t},getDistanceModel:function(){return this.panner.distanceModel},setDistanceModel:function(t){this.panner.distanceModel=t},getMaxDistance:function(){return this.panner.maxDistance},setMaxDistance:function(t){this.panner.maxDistance=t},updateMatrixWorld:function(){var t=new v;return function(e){bt.prototype.updateMatrixWorld.call(this,e),t.setFromMatrixPosition(this.matrixWorld),this.panner.setPosition(t.x,t.y,t.z)}}()}),Object.assign(Yr.prototype,{getFrequencyData:function(){return this.analyser.getByteFrequencyData(this.data),this.data},getAverageFrequency:function(){for(var t=0,e=this.getFrequencyData(),i=0;i<e.length;i++)t+=e[i];return t/e.length}}),Object.assign(Zr.prototype,{accumulate:function(t,e){var i=this.buffer,r=this.valueSize,n=t*r+r,o=this.cumulativeWeight;if(0===o){for(var a=0;a!==r;++a)i[n+a]=i[a];o=e}else{var s=e/(o+=e);this._mixBufferRegion(i,n,0,s,r)}this.cumulativeWeight=o},apply:function(t){var e=this.valueSize,i=this.buffer,r=t*e+e,n=this.cumulativeWeight,o=this.binding;if(this.cumulativeWeight=0,n<1){var a=3*e;this._mixBufferRegion(i,r,a,1-n,e)}for(var s=e,c=e+e;s!==c;++s)if(i[s]!==i[s+e]){o.setValue(i,r);break}},saveOriginalState:function(){var t=this.binding,e=this.buffer,i=this.valueSize,r=3*i;t.getValue(e,r);for(var n=i,o=r;n!==o;++n)e[n]=e[r+n%i];this.cumulativeWeight=0},restoreOriginalState:function(){var t=3*this.valueSize;this.binding.setValue(this.buffer,t)},_select:function(t,e,i,r,n){if(r>=.5)for(var o=0;o!==n;++o)t[e+o]=t[i+o]},_slerp:function(t,e,i,r){g.slerpFlat(t,e,t,e,t,i,r)},_lerp:function(t,e,i,r,n){for(var o=1-r,a=0;a!==n;++a){var s=e+a;t[s]=t[s]*o+t[i+a]*r}}}),Object.assign(Kr.prototype,{getValue:function(t,e){this.bind();var i=this._targetGroup.nCachedObjects_,r=this._bindings[i];void 0!==r&&r.getValue(t,e)},setValue:function(t,e){for(var i=this._bindings,r=this._targetGroup.nCachedObjects_,n=i.length;r!==n;++r)i[r].setValue(t,e)},bind:function(){for(var t=this._bindings,e=this._targetGroup.nCachedObjects_,i=t.length;e!==i;++e)t[e].bind()},unbind:function(){for(var t=this._bindings,e=this._targetGroup.nCachedObjects_,i=t.length;e!==i;++e)t[e].unbind()}}),Object.assign(Qr,{Composite:Kr,create:function(t,e,i){return t&&t.isAnimationObjectGroup?new Qr.Composite(t,e,i):new Qr(t,e,i)},sanitizeNodeName:function(t){return t.replace(/\s/g,"_").replace(/[^\w-]/g,"")},parseTrackName:function(){var t=/((?:[\w-]+[\/:])*)/,e=/([\w-\.]+)?/,i=/(?:\.([\w-]+)(?:\[(.+)\])?)?/,r=/\.([\w-]+)(?:\[(.+)\])?/,n=new RegExp("^"+t.source+e.source+i.source+r.source+"$"),o=["material","materials","bones"];return function(t){var e=n.exec(t);if(!e)throw new Error("PropertyBinding: Cannot parse trackName: "+t);var i={nodeName:e[2],objectName:e[3],objectIndex:e[4],propertyName:e[5],propertyIndex:e[6]},r=i.nodeName&&i.nodeName.lastIndexOf(".");if(void 0!==r&&-1!==r){var a=i.nodeName.substring(r+1);-1!==o.indexOf(a)&&(i.nodeName=i.nodeName.substring(0,r),i.objectName=a)}if(null===i.propertyName||0===i.propertyName.length)throw new Error("PropertyBinding: can not parse propertyName from trackName: "+t);return i}}(),findNode:function(t,e){if(!e||""===e||"root"===e||"."===e||-1===e||e===t.name||e===t.uuid)return t;if(t.skeleton){var i=function(t){for(var i=0;i<t.bones.length;i++){var r=t.bones[i];if(r.name===e)return r}return null}(t.skeleton);if(i)return i}if(t.children){var r=function(t){for(var i=0;i<t.length;i++){var n=t[i];if(n.name===e||n.uuid===e)return n;var o=r(n.children);if(o)return o}return null},n=r(t.children);if(n)return n}return null}}),Object.assign(Qr.prototype,{_getValue_unavailable:function(){},_setValue_unavailable:function(){},BindingType:{Direct:0,EntireArray:1,ArrayElement:2,HasFromToArray:3},Versioning:{None:0,NeedsUpdate:1,MatrixWorldNeedsUpdate:2},GetterByBindingType:[function(t,e){t[e]=this.node[this.propertyName]},function(t,e){for(var i=this.resolvedProperty,r=0,n=i.length;r!==n;++r)t[e++]=i[r]},function(t,e){t[e]=this.resolvedProperty[this.propertyIndex]},function(t,e){this.resolvedProperty.toArray(t,e)}],SetterByBindingTypeAndVersioning:[[function(t,e){this.node[this.propertyName]=t[e]},function(t,e){this.node[this.propertyName]=t[e],this.targetObject.needsUpdate=!0},function(t,e){this.node[this.propertyName]=t[e],this.targetObject.matrixWorldNeedsUpdate=!0}],[function(t,e){for(var i=this.resolvedProperty,r=0,n=i.length;r!==n;++r)i[r]=t[e++]},function(t,e){for(var i=this.resolvedProperty,r=0,n=i.length;r!==n;++r)i[r]=t[e++];this.targetObject.needsUpdate=!0},function(t,e){for(var i=this.resolvedProperty,r=0,n=i.length;r!==n;++r)i[r]=t[e++];this.targetObject.matrixWorldNeedsUpdate=!0}],[function(t,e){this.resolvedProperty[this.propertyIndex]=t[e]},function(t,e){this.resolvedProperty[this.propertyIndex]=t[e],this.targetObject.needsUpdate=!0},function(t,e){this.resolvedProperty[this.propertyIndex]=t[e],this.targetObject.matrixWorldNeedsUpdate=!0}],[function(t,e){this.resolvedProperty.fromArray(t,e)},function(t,e){this.resolvedProperty.fromArray(t,e),this.targetObject.needsUpdate=!0},function(t,e){this.resolvedProperty.fromArray(t,e),this.targetObject.matrixWorldNeedsUpdate=!0}]],getValue:function(t,e){this.bind(),this.getValue(t,e)},setValue:function(t,e){this.bind(),this.setValue(t,e)},bind:function(){var t=this.node,e=this.parsedPath,i=e.objectName,r=e.propertyName,n=e.propertyIndex;if(t||(t=Qr.findNode(this.rootNode,e.nodeName)||this.rootNode,this.node=t),this.getValue=this._getValue_unavailable,this.setValue=this._setValue_unavailable,t){if(i){var o=e.objectIndex;switch(i){case"materials":if(!t.material)return void console.error("THREE.PropertyBinding: Can not bind to material as node does not have a material.",this);if(!t.material.materials)return void console.error("THREE.PropertyBinding: Can not bind to material.materials as node.material does not have a materials array.",this);t=t.material.materials;break;case"bones":if(!t.skeleton)return void console.error("THREE.PropertyBinding: Can not bind to bones as node does not have a skeleton.",this);t=t.skeleton.bones;for(u=0;u<t.length;u++)if(t[u].name===o){o=u;break}break;default:if(void 0===t[i])return void console.error("THREE.PropertyBinding: Can not bind to objectName of node undefined.",this);t=t[i]}if(void 0!==o){if(void 0===t[o])return void console.error("THREE.PropertyBinding: Trying to bind to objectIndex of objectName, but is undefined.",this,t);t=t[o]}}var a=t[r];if(void 0!==a){var s=this.Versioning.None;void 0!==t.needsUpdate?(s=this.Versioning.NeedsUpdate,this.targetObject=t):void 0!==t.matrixWorldNeedsUpdate&&(s=this.Versioning.MatrixWorldNeedsUpdate,this.targetObject=t);var c=this.BindingType.Direct;if(void 0!==n){if("morphTargetInfluences"===r){if(!t.geometry)return void console.error("THREE.PropertyBinding: Can not bind to morphTargetInfluences because node does not have a geometry.",this);if(t.geometry.isBufferGeometry){if(!t.geometry.morphAttributes)return void console.error("THREE.PropertyBinding: Can not bind to morphTargetInfluences because node does not have a geometry.morphAttributes.",this);for(u=0;u<this.node.geometry.morphAttributes.position.length;u++)if(t.geometry.morphAttributes.position[u].name===n){n=u;break}}else{if(!t.geometry.morphTargets)return void console.error("THREE.PropertyBinding: Can not bind to morphTargetInfluences because node does not have a geometry.morphTargets.",this);for(var u=0;u<this.node.geometry.morphTargets.length;u++)if(t.geometry.morphTargets[u].name===n){n=u;break}}}c=this.BindingType.ArrayElement,this.resolvedProperty=a,this.propertyIndex=n}else void 0!==a.fromArray&&void 0!==a.toArray?(c=this.BindingType.HasFromToArray,this.resolvedProperty=a):Array.isArray(a)?(c=this.BindingType.EntireArray,this.resolvedProperty=a):this.propertyName=r;this.getValue=this.GetterByBindingType[c],this.setValue=this.SetterByBindingTypeAndVersioning[c][s]}else{var l=e.nodeName;console.error("THREE.PropertyBinding: Trying to update property for track: "+l+"."+r+" but it wasn't found.",t)}}else console.error("THREE.PropertyBinding: Trying to update node for track: "+this.path+" but it wasn't found.")},unbind:function(){this.node=null,this.getValue=this._getValue_unbound,this.setValue=this._setValue_unbound}}),Object.assign(Qr.prototype,{_getValue_unbound:Qr.prototype.getValue,_setValue_unbound:Qr.prototype.setValue}),Object.assign(function(t){var e=arguments;this.uuid=Ap.generateUUID(),this._objects=Array.prototype.slice.call(arguments),this.nCachedObjects_=0;var i={};this._indicesByUUID=i;for(var r=0,n=arguments.length;r!==n;++r)i[e[r].uuid]=r;this._paths=[],this._parsedPaths=[],this._bindings=[],this._bindingsIndicesByPath={};var o=this;this.stats={objects:{get total(){return o._objects.length},get inUse(){return this.total-o.nCachedObjects_}},get bindingsPerObject(){return o._bindings.length}}}.prototype,{isAnimationObjectGroup:!0,add:function(t){for(var e=arguments,i=this._objects,r=i.length,n=this.nCachedObjects_,o=this._indicesByUUID,a=this._paths,s=this._parsedPaths,c=this._bindings,u=c.length,l=0,h=arguments.length;l!==h;++l){var p=e[l],d=p.uuid,f=o[d],m=void 0;if(void 0===f){f=r++,o[d]=f,i.push(p);for(var g=0,v=u;g!==v;++g)c[g].push(new Qr(p,a[g],s[g]))}else if(f<n){m=i[f];var y=--n,b=i[y];o[b.uuid]=f,i[f]=b,o[d]=y,i[y]=p;for(var g=0,v=u;g!==v;++g){var x=c[g],_=x[y],w=x[f];x[f]=_,void 0===w&&(w=new Qr(p,a[g],s[g])),x[y]=w}}else i[f]!==m&&console.error("THREE.AnimationObjectGroup: Different objects with the same UUID detected. Clean the caches or recreate your infrastructure when reloading scenes.")}this.nCachedObjects_=n},remove:function(t){for(var e=arguments,i=this._objects,r=this.nCachedObjects_,n=this._indicesByUUID,o=this._bindings,a=o.length,s=0,c=arguments.length;s!==c;++s){var u=e[s],l=u.uuid,h=n[l];if(void 0!==h&&h>=r){var p=r++,d=i[p];n[d.uuid]=h,i[h]=d,n[l]=p,i[p]=u;for(var f=0,m=a;f!==m;++f){var g=o[f],v=g[p],y=g[h];g[h]=v,g[p]=y}}}this.nCachedObjects_=r},uncache:function(t){for(var e=arguments,i=this._objects,r=i.length,n=this.nCachedObjects_,o=this._indicesByUUID,a=this._bindings,s=a.length,c=0,u=arguments.length;c!==u;++c){var l=e[c].uuid,h=o[l];if(void 0!==h)if(delete o[l],h<n){var p=--n,d=i[p],f=i[b=--r];o[d.uuid]=h,i[h]=d,o[f.uuid]=p,i[p]=f,i.pop();for(var m=0,g=s;m!==g;++m){var v=(x=a[m])[p],y=x[b];x[h]=v,x[p]=y,x.pop()}}else{var b=--r;o[(f=i[b]).uuid]=h,i[h]=f,i.pop();for(var m=0,g=s;m!==g;++m){var x=a[m];x[h]=x[b],x.pop()}}}this.nCachedObjects_=n},subscribe_:function(t,e){var i=this._bindingsIndicesByPath,r=i[t],n=this._bindings;if(void 0!==r)return n[r];var o=this._paths,a=this._parsedPaths,s=this._objects,c=s.length,u=this.nCachedObjects_,l=new Array(c);r=n.length,i[t]=r,o.push(t),a.push(e),n.push(l);for(var h=u,p=s.length;h!==p;++h){var d=s[h];l[h]=new Qr(d,t,e)}return l},unsubscribe_:function(t){var e=this._bindingsIndicesByPath,i=e[t];if(void 0!==i){var r=this._paths,n=this._parsedPaths,o=this._bindings,a=o.length-1,s=o[a];e[t[a]]=i,o[i]=s,o.pop(),n[i]=n[a],n.pop(),r[i]=r[a],r.pop()}}}),Object.assign(Jr.prototype,{play:function(){return this._mixer._activateAction(this),this},stop:function(){return this._mixer._deactivateAction(this),this.reset()},reset:function(){return this.paused=!1,this.enabled=!0,this.time=0,this._loopCount=-1,this._startTime=null,this.stopFading().stopWarping()},isRunning:function(){return this.enabled&&!this.paused&&0!==this.timeScale&&null===this._startTime&&this._mixer._isActiveAction(this)},isScheduled:function(){return this._mixer._isActiveAction(this)},startAt:function(t){return this._startTime=t,this},setLoop:function(t,e){return this.loop=t,this.repetitions=e,this},setEffectiveWeight:function(t){return this.weight=t,this._effectiveWeight=this.enabled?t:0,this.stopFading()},getEffectiveWeight:function(){return this._effectiveWeight},fadeIn:function(t){return this._scheduleFading(t,0,1)},fadeOut:function(t){return this._scheduleFading(t,1,0)},crossFadeFrom:function(t,e,i){if(t.fadeOut(e),this.fadeIn(e),i){var r=this._clip.duration,n=t._clip.duration,o=n/r,a=r/n;t.warp(1,o,e),this.warp(a,1,e)}return this},crossFadeTo:function(t,e,i){return t.crossFadeFrom(this,e,i)},stopFading:function(){var t=this._weightInterpolant;return null!==t&&(this._weightInterpolant=null,this._mixer._takeBackControlInterpolant(t)),this},setEffectiveTimeScale:function(t){return this.timeScale=t,this._effectiveTimeScale=this.paused?0:t,this.stopWarping()},getEffectiveTimeScale:function(){return this._effectiveTimeScale},setDuration:function(t){return this.timeScale=this._clip.duration/t,this.stopWarping()},syncWith:function(t){return this.time=t.time,this.timeScale=t.timeScale,this.stopWarping()},halt:function(t){return this.warp(this._effectiveTimeScale,0,t)},warp:function(t,e,i){var r=this._mixer,n=r.time,o=this._timeScaleInterpolant,a=this.timeScale;null===o&&(o=r._lendControlInterpolant(),this._timeScaleInterpolant=o);var s=o.parameterPositions,c=o.sampleValues;return s[0]=n,s[1]=n+i,c[0]=t/a,c[1]=e/a,this},stopWarping:function(){var t=this._timeScaleInterpolant;return null!==t&&(this._timeScaleInterpolant=null,this._mixer._takeBackControlInterpolant(t)),this},getMixer:function(){return this._mixer},getClip:function(){return this._clip},getRoot:function(){return this._localRoot||this._mixer._root},_update:function(t,e,i,r){if(this.enabled){var n=this._startTime;if(null!==n){var o=(t-n)*i;if(o<0||0===i)return;this._startTime=null,e=i*o}e*=this._updateTimeScale(t);var a=this._updateTime(e),s=this._updateWeight(t);if(s>0)for(var c=this._interpolants,u=this._propertyBindings,l=0,h=c.length;l!==h;++l)c[l].evaluate(a),u[l].accumulate(r,s)}else this._updateWeight(t)},_updateWeight:function(t){var e=0;if(this.enabled){e=this.weight;var i=this._weightInterpolant;if(null!==i){var r=i.evaluate(t)[0];e*=r,t>i.parameterPositions[1]&&(this.stopFading(),0===r&&(this.enabled=!1))}}return this._effectiveWeight=e,e},_updateTimeScale:function(t){var e=0;if(!this.paused){e=this.timeScale;var i=this._timeScaleInterpolant;null!==i&&(e*=i.evaluate(t)[0],t>i.parameterPositions[1]&&(this.stopWarping(),0===e?this.paused=!0:this.timeScale=e))}return this._effectiveTimeScale=e,e},_updateTime:function(t){var e=this.time+t;if(0===t)return e;var i=this._clip.duration,r=this.loop,n=this._loopCount;if(2200===r){-1===n&&(this._loopCount=0,this._setEndings(!0,!0,!1));t:{if(e>=i)e=i;else{if(!(e<0))break t;e=0}this.clampWhenFinished?this.paused=!0:this.enabled=!1,this._mixer.dispatchEvent({type:"finished",action:this,direction:t<0?-1:1})}}else{var o=2202===r;if(-1===n&&(t>=0?(n=0,this._setEndings(!0,0===this.repetitions,o)):this._setEndings(0===this.repetitions,!0,o)),e>=i||e<0){var a=Math.floor(e/i);e-=i*a,n+=Math.abs(a);var s=this.repetitions-n;if(s<0)this.clampWhenFinished?this.paused=!0:this.enabled=!1,e=t>0?i:0,this._mixer.dispatchEvent({type:"finished",action:this,direction:t>0?1:-1});else{if(0===s){var c=t<0;this._setEndings(c,!c,o)}else this._setEndings(!1,!1,o);this._loopCount=n,this._mixer.dispatchEvent({type:"loop",action:this,loopDelta:a})}}if(o&&1==(1&n))return this.time=e,i-e}return this.time=e,e},_setEndings:function(t,e,i){var r=this._interpolantSettings;i?(r.endingStart=2401,r.endingEnd=2401):(r.endingStart=t?this.zeroSlopeAtStart?2401:hp:2402,r.endingEnd=e?this.zeroSlopeAtEnd?2401:hp:2402)},_scheduleFading:function(t,e,i){var r=this._mixer,n=r.time,o=this._weightInterpolant;null===o&&(o=r._lendControlInterpolant(),this._weightInterpolant=o);var a=o.parameterPositions,s=o.sampleValues;return a[0]=n,s[0]=e,a[1]=n+t,s[1]=i,this}}),Object.assign(function(t){this._root=t,this._initMemoryManager(),this._accuIndex=0,this.time=0,this.timeScale=1}.prototype,l.prototype,{_bindAction:function(t,e){var i=this,r=t._localRoot||this._root,n=t._clip.tracks,o=n.length,a=t._propertyBindings,s=t._interpolants,c=r.uuid,u=this._bindingsByRootAndName,l=u[c];void 0===l&&(l={},u[c]=l);for(var h=0;h!==o;++h){var p=n[h],d=p.name,f=l[d];if(void 0!==f)a[h]=f;else{if(void 0!==(f=a[h])){null===f._cacheIndex&&(++f.referenceCount,i._addInactiveBinding(f,c,d));continue}var m=e&&e._propertyBindings[h].binding.parsedPath;++(f=new Zr(Qr.create(r,d,m),p.ValueTypeName,p.getValueSize())).referenceCount,i._addInactiveBinding(f,c,d),a[h]=f}s[h].resultBuffer=f.buffer}},_activateAction:function(t){var e=this;if(!this._isActiveAction(t)){if(null===t._cacheIndex){var i=(t._localRoot||this._root).uuid,r=t._clip.uuid,n=this._actionsByClip[r];this._bindAction(t,n&&n.knownActions[0]),this._addInactiveAction(t,r,i)}for(var o=t._propertyBindings,a=0,s=o.length;a!==s;++a){var c=o[a];0==c.useCount++&&(e._lendBinding(c),c.saveOriginalState())}this._lendAction(t)}},_deactivateAction:function(t){var e=this;if(this._isActiveAction(t)){for(var i=t._propertyBindings,r=0,n=i.length;r!==n;++r){var o=i[r];0==--o.useCount&&(o.restoreOriginalState(),e._takeBackBinding(o))}this._takeBackAction(t)}},_initMemoryManager:function(){this._actions=[],this._nActiveActions=0,this._actionsByClip={},this._bindings=[],this._nActiveBindings=0,this._bindingsByRootAndName={},this._controlInterpolants=[],this._nActiveControlInterpolants=0;var t=this;this.stats={actions:{get total(){return t._actions.length},get inUse(){return t._nActiveActions}},bindings:{get total(){return t._bindings.length},get inUse(){return t._nActiveBindings}},controlInterpolants:{get total(){return t._controlInterpolants.length},get inUse(){return t._nActiveControlInterpolants}}}},_isActiveAction:function(t){var e=t._cacheIndex;return null!==e&&e<this._nActiveActions},_addInactiveAction:function(t,e,i){var r=this._actions,n=this._actionsByClip,o=n[e];if(void 0===o)o={knownActions:[t],actionByRoot:{}},t._byClipCacheIndex=0,n[e]=o;else{var a=o.knownActions;t._byClipCacheIndex=a.length,a.push(t)}t._cacheIndex=r.length,r.push(t),o.actionByRoot[i]=t},_removeInactiveAction:function(t){var e=this._actions,i=e[e.length-1],r=t._cacheIndex;i._cacheIndex=r,e[r]=i,e.pop(),t._cacheIndex=null;var n=t._clip.uuid,o=this._actionsByClip,a=o[n],s=a.knownActions,c=s[s.length-1],u=t._byClipCacheIndex;c._byClipCacheIndex=u,s[u]=c,s.pop(),t._byClipCacheIndex=null,delete a.actionByRoot[(t._localRoot||this._root).uuid],0===s.length&&delete o[n],this._removeInactiveBindingsForAction(t)},_removeInactiveBindingsForAction:function(t){for(var e=this,i=t._propertyBindings,r=0,n=i.length;r!==n;++r){var o=i[r];0==--o.referenceCount&&e._removeInactiveBinding(o)}},_lendAction:function(t){var e=this._actions,i=t._cacheIndex,r=this._nActiveActions++,n=e[r];t._cacheIndex=r,e[r]=t,n._cacheIndex=i,e[i]=n},_takeBackAction:function(t){var e=this._actions,i=t._cacheIndex,r=--this._nActiveActions,n=e[r];t._cacheIndex=r,e[r]=t,n._cacheIndex=i,e[i]=n},_addInactiveBinding:function(t,e,i){var r=this._bindingsByRootAndName,n=r[e],o=this._bindings;void 0===n&&(n={},r[e]=n),n[i]=t,t._cacheIndex=o.length,o.push(t)},_removeInactiveBinding:function(t){var e=this._bindings,i=t.binding,r=i.rootNode.uuid,n=i.path,o=this._bindingsByRootAndName,a=o[r],s=e[e.length-1],c=t._cacheIndex;s._cacheIndex=c,e[c]=s,e.pop(),delete a[n];t:{for(var u in a)break t;delete o[r]}},_lendBinding:function(t){var e=this._bindings,i=t._cacheIndex,r=this._nActiveBindings++,n=e[r];t._cacheIndex=r,e[r]=t,n._cacheIndex=i,e[i]=n},_takeBackBinding:function(t){var e=this._bindings,i=t._cacheIndex,r=--this._nActiveBindings,n=e[r];t._cacheIndex=r,e[r]=t,n._cacheIndex=i,e[i]=n},_lendControlInterpolant:function(){var t=this._controlInterpolants,e=this._nActiveControlInterpolants++,i=t[e];return void 0===i&&((i=new sr(new Float32Array(2),new Float32Array(2),1,this._controlInterpolantsResultBuffer)).__cacheIndex=e,t[e]=i),i},_takeBackControlInterpolant:function(t){var e=this._controlInterpolants,i=t.__cacheIndex,r=--this._nActiveControlInterpolants,n=e[r];t.__cacheIndex=r,e[r]=t,n.__cacheIndex=i,e[i]=n},_controlInterpolantsResultBuffer:new Float32Array(1),clipAction:function(t,e){var i=e||this._root,r=i.uuid,n="string"==typeof t?yr.findByName(i,t):t,o=null!==n?n.uuid:t,a=this._actionsByClip[o],s=null;if(void 0!==a){var c=a.actionByRoot[r];if(void 0!==c)return c;s=a.knownActions[0],null===n&&(n=s._clip)}if(null===n)return null;var u=new Jr(this,n,e);return this._bindAction(u,s),this._addInactiveAction(u,o,r),u},existingAction:function(t,e){var i=e||this._root,r=i.uuid,n="string"==typeof t?yr.findByName(i,t):t,o=n?n.uuid:t,a=this._actionsByClip[o];return void 0!==a?a.actionByRoot[r]||null:null},stopAllAction:function(){var t=this._actions,e=this._nActiveActions,i=this._bindings,r=this._nActiveBindings;this._nActiveActions=0,this._nActiveBindings=0;for(n=0;n!==e;++n)t[n].reset();for(var n=0;n!==r;++n)i[n].useCount=0;return this},update:function(t){t*=this.timeScale;for(var e=this._actions,i=this._nActiveActions,r=this.time+=t,n=Math.sign(t),o=this._accuIndex^=1,a=0;a!==i;++a)e[a]._update(r,t,n,o);for(var s=this._bindings,c=this._nActiveBindings,a=0;a!==c;++a)s[a].apply(o);return this},getRoot:function(){return this._root},uncacheClip:function(t){var e=this,i=this._actions,r=t.uuid,n=this._actionsByClip,o=n[r];if(void 0!==o){for(var a=o.knownActions,s=0,c=a.length;s!==c;++s){var u=a[s];e._deactivateAction(u);var l=u._cacheIndex,h=i[i.length-1];u._cacheIndex=null,u._byClipCacheIndex=null,h._cacheIndex=l,i[l]=h,i.pop(),e._removeInactiveBindingsForAction(u)}delete n[r]}},uncacheRoot:function(t){var e=this,i=t.uuid,r=this._actionsByClip;for(var n in r){var o=r[n].actionByRoot[i];void 0!==o&&(e._deactivateAction(o),e._removeInactiveAction(o))}var a=this._bindingsByRootAndName[i];if(void 0!==a)for(var s in a){var c=a[s];c.restoreOriginalState(),e._removeInactiveBinding(c)}},uncacheAction:function(t,e){var i=this.existingAction(t,e);null!==i&&(this._deactivateAction(i),this._removeInactiveAction(i))}}),tn.prototype.clone=function(){return new tn(void 0===this.value.clone?this.value:this.value.clone())},en.prototype=Object.assign(Object.create(Ft.prototype),{constructor:en,isInstancedBufferGeometry:!0,addGroup:function(t,e,i){this.groups.push({start:t,count:e,materialIndex:i})},copy:function(t){var e=this,i=t.index;null!==i&&this.setIndex(i.clone());var r=t.attributes;for(var n in r){var o=r[n];e.addAttribute(n,o.clone())}for(var a=t.groups,s=0,c=a.length;s<c;s++){var u=a[s];e.addGroup(u.start,u.count,u.materialIndex)}return this}}),Object.defineProperties(rn.prototype,{count:{get:function(){return this.data.count}},array:{get:function(){return this.data.array}}}),Object.assign(rn.prototype,{isInterleavedBufferAttribute:!0,setX:function(t,e){return this.data.array[t*this.data.stride+this.offset]=e,this},setY:function(t,e){return this.data.array[t*this.data.stride+this.offset+1]=e,this},setZ:function(t,e){return this.data.array[t*this.data.stride+this.offset+2]=e,this},setW:function(t,e){return this.data.array[t*this.data.stride+this.offset+3]=e,this},getX:function(t){return this.data.array[t*this.data.stride+this.offset]},getY:function(t){return this.data.array[t*this.data.stride+this.offset+1]},getZ:function(t){return this.data.array[t*this.data.stride+this.offset+2]},getW:function(t){return this.data.array[t*this.data.stride+this.offset+3]},setXY:function(t,e,i){return t=t*this.data.stride+this.offset,this.data.array[t+0]=e,this.data.array[t+1]=i,this},setXYZ:function(t,e,i,r){return t=t*this.data.stride+this.offset,this.data.array[t+0]=e,this.data.array[t+1]=i,this.data.array[t+2]=r,this},setXYZW:function(t,e,i,r,n){return t=t*this.data.stride+this.offset,this.data.array[t+0]=e,this.data.array[t+1]=i,this.data.array[t+2]=r,this.data.array[t+3]=n,this}}),Object.defineProperty(nn.prototype,"needsUpdate",{set:function(t){!0===t&&this.version++}}),Object.assign(nn.prototype,{isInterleavedBuffer:!0,setArray:function(t){if(Array.isArray(t))throw new TypeError("THREE.BufferAttribute: array should be a Typed Array.");this.count=void 0!==t?t.length/this.stride:0,this.array=t},setDynamic:function(t){return this.dynamic=t,this},copy:function(t){return this.array=new t.array.constructor(t.array),this.count=t.count,this.stride=t.stride,this.dynamic=t.dynamic,this},copyAt:function(t,e,i){var r=this;t*=this.stride,i*=e.stride;for(var n=0,o=this.stride;n<o;n++)r.array[t+n]=e.array[i+n];return this},set:function(t,e){return void 0===e&&(e=0),this.array.set(t,e),this},clone:function(){return(new this.constructor).copy(this)},onUpload:function(t){return this.onUploadCallback=t,this}}),on.prototype=Object.assign(Object.create(nn.prototype),{constructor:on,isInstancedInterleavedBuffer:!0,copy:function(t){return nn.prototype.copy.call(this,t),this.meshPerAttribute=t.meshPerAttribute,this}}),an.prototype=Object.assign(Object.create(Pt.prototype),{constructor:an,isInstancedBufferAttribute:!0,copy:function(t){return Pt.prototype.copy.call(this,t),this.meshPerAttribute=t.meshPerAttribute,this}}),Object.assign(function(t,e,i,r){this.ray=new $t(t,e),this.near=i||0,this.far=r||1/0,this.params={Mesh:{},Line:{},LOD:{},Points:{threshold:1},Sprite:{}},Object.defineProperties(this.params,{PointCloud:{get:function(){return console.warn("THREE.Raycaster: params.PointCloud has been renamed to params.Points."),this.Points}}})}.prototype,{linePrecision:1,set:function(t,e){this.ray.set(t,e)},setFromCamera:function(t,e){e&&e.isPerspectiveCamera?(this.ray.origin.setFromMatrixPosition(e.matrixWorld),this.ray.direction.set(t.x,t.y,.5).unproject(e).sub(this.ray.origin).normalize()):e&&e.isOrthographicCamera?(this.ray.origin.set(t.x,t.y,(e.near+e.far)/(e.near-e.far)).unproject(e),this.ray.direction.set(0,0,-1).transformDirection(e.matrixWorld)):console.error("THREE.Raycaster: Unsupported camera type.")},intersectObject:function(t,e){var i=[];return cn(t,this,i,e),i.sort(sn),i},intersectObjects:function(t,e){var i=this,r=[];if(!1===Array.isArray(t))return console.warn("THREE.Raycaster.intersectObjects: objects is not an Array."),r;for(var n=0,o=t.length;n<o;n++)cn(t[n],i,r,e);return r.sort(sn),r}}),Object.assign(function(t){this.autoStart=void 0===t||t,this.startTime=0,this.oldTime=0,this.elapsedTime=0,this.running=!1}.prototype,{start:function(){this.startTime=("undefined"==typeof performance?Date:performance).now(),this.oldTime=this.startTime,this.elapsedTime=0,this.running=!0},stop:function(){this.getElapsedTime(),this.running=!1,this.autoStart=!1},getElapsedTime:function(){return this.getDelta(),this.elapsedTime},getDelta:function(){var t=0;if(this.autoStart&&!this.running)return this.start(),0;if(this.running){var e=("undefined"==typeof performance?Date:performance).now();t=(e-this.oldTime)/1e3,this.oldTime=e,this.elapsedTime+=t}return t}}),Object.assign(function(t,e,i){return this.radius=void 0!==t?t:1,this.phi=void 0!==e?e:0,this.theta=void 0!==i?i:0,this}.prototype,{set:function(t,e,i){return this.radius=t,this.phi=e,this.theta=i,this},clone:function(){return(new this.constructor).copy(this)},copy:function(t){return this.radius=t.radius,this.phi=t.phi,this.theta=t.theta,this},makeSafe:function(){return this.phi=Math.max(1e-6,Math.min(Math.PI-1e-6,this.phi)),this},setFromVector3:function(t){return this.radius=t.length(),0===this.radius?(this.theta=0,this.phi=0):(this.theta=Math.atan2(t.x,t.z),this.phi=Math.acos(Ap.clamp(t.y/this.radius,-1,1))),this}}),Object.assign(function(t,e,i){return this.radius=void 0!==t?t:1,this.theta=void 0!==e?e:0,this.y=void 0!==i?i:0,this}.prototype,{set:function(t,e,i){return this.radius=t,this.theta=e,this.y=i,this},clone:function(){return(new this.constructor).copy(this)},copy:function(t){return this.radius=t.radius,this.theta=t.theta,this.y=t.y,this},setFromVector3:function(t){return this.radius=Math.sqrt(t.x*t.x+t.z*t.z),this.theta=Math.atan2(t.x,t.z),this.y=t.y,this}}),(un.prototype=Object.create(bt.prototype)).constructor=un,un.prototype.isImmediateRenderObject=!0,(ln.prototype=Object.create($e.prototype)).constructor=ln,ln.prototype.update=function(){var t=new v,e=new v,i=new pt;return function(){var r=this,n=["a","b","c"];this.object.updateMatrixWorld(!0),i.getNormalMatrix(this.object.matrixWorld);var o=this.object.matrixWorld,a=this.geometry.attributes.position,s=this.object.geometry;if(s&&s.isGeometry)for(var c=s.vertices,u=s.faces,l=0,h=0,p=u.length;h<p;h++)for(var d=u[h],f=0,m=d.vertexNormals.length;f<m;f++){var g=c[d[n[f]]],v=d.vertexNormals[f];t.copy(g).applyMatrix4(o),e.copy(v).applyMatrix3(i).normalize().multiplyScalar(r.size).add(t),a.setXYZ(l,t.x,t.y,t.z),l+=1,a.setXYZ(l,e.x,e.y,e.z),l+=1}else if(s&&s.isBufferGeometry)for(var y=s.attributes.position,b=s.attributes.normal,l=0,f=0,m=y.count;f<m;f++)t.set(y.getX(f),y.getY(f),y.getZ(f)).applyMatrix4(o),e.set(b.getX(f),b.getY(f),b.getZ(f)),e.applyMatrix3(i).normalize().multiplyScalar(r.size).add(t),a.setXYZ(l,t.x,t.y,t.z),l+=1,a.setXYZ(l,e.x,e.y,e.z),l+=1;a.needsUpdate=!0}}(),(hn.prototype=Object.create(bt.prototype)).constructor=hn,hn.prototype.dispose=function(){this.cone.geometry.dispose(),this.cone.material.dispose()},hn.prototype.update=function(){var t=new v,e=new v;return function(){this.light.updateMatrixWorld();var i=this.light.distance?this.light.distance:1e3,r=i*Math.tan(this.light.angle);this.cone.scale.set(r,r,i),t.setFromMatrixPosition(this.light.matrixWorld),e.setFromMatrixPosition(this.light.target.matrixWorld),this.cone.lookAt(e.sub(t)),void 0!==this.color?this.cone.material.color.set(this.color):this.cone.material.color.copy(this.light.color)}}(),(dn.prototype=Object.create($e.prototype)).constructor=dn,dn.prototype.onBeforeRender=function(){var t=new v,e=new y,i=new y;return function(){var r=this.bones,n=this.geometry,o=n.getAttribute("position");i.getInverse(this.root.matrixWorld);for(var a=0,s=0;a<r.length;a++){var c=r[a];c.parent&&c.parent.isBone&&(e.multiplyMatrices(i,c.matrixWorld),t.setFromMatrixPosition(e),o.setXYZ(s,t.x,t.y,t.z),e.multiplyMatrices(i,c.parent.matrixWorld),t.setFromMatrixPosition(e),o.setXYZ(s+1,t.x,t.y,t.z),s+=2)}n.getAttribute("position").needsUpdate=!0}}(),(fn.prototype=Object.create(Xt.prototype)).constructor=fn,fn.prototype.dispose=function(){this.geometry.dispose(),this.material.dispose()},fn.prototype.update=function(){void 0!==this.color?this.material.color.set(this.color):this.material.color.copy(this.light.color)},(mn.prototype=Object.create(bt.prototype)).constructor=mn,mn.prototype.dispose=function(){this.children[0].geometry.dispose(),this.children[0].material.dispose()},mn.prototype.update=function(){var t=.5*this.light.width,e=.5*this.light.height,i=this.line.geometry.attributes.position,r=i.array;r[0]=t,r[1]=-e,r[2]=0,r[3]=t,r[4]=e,r[5]=0,r[6]=-t,r[7]=e,r[8]=0,r[9]=-t,r[10]=-e,r[11]=0,r[12]=t,r[13]=-e,r[14]=0,i.needsUpdate=!0,void 0!==this.color?this.line.material.color.set(this.color):this.line.material.color.copy(this.light.color)},(gn.prototype=Object.create(bt.prototype)).constructor=gn,gn.prototype.dispose=function(){this.children[0].geometry.dispose(),this.children[0].material.dispose()},gn.prototype.update=function(){var t=new v,e=new et,i=new et;return function(){var r=this.children[0];if(void 0!==this.color)this.material.color.set(this.color);else{var n=r.geometry.getAttribute("color");e.copy(this.light.color),i.copy(this.light.groundColor);for(var o=0,a=n.count;o<a;o++){var s=o<a/2?e:i;n.setXYZ(o,s.r,s.g,s.b)}n.needsUpdate=!0}r.lookAt(t.setFromMatrixPosition(this.light.matrixWorld).negate())}}(),(vn.prototype=Object.create($e.prototype)).constructor=vn,(yn.prototype=Object.create($e.prototype)).constructor=yn,(bn.prototype=Object.create($e.prototype)).constructor=bn,bn.prototype.update=function(){var t=new v,e=new v,i=new pt;return function(){var r=this;this.object.updateMatrixWorld(!0),i.getNormalMatrix(this.object.matrixWorld);for(var n=this.object.matrixWorld,o=this.geometry.attributes.position,a=this.object.geometry,s=a.vertices,c=a.faces,u=0,l=0,h=c.length;l<h;l++){var p=c[l],d=p.normal;t.copy(s[p.a]).add(s[p.b]).add(s[p.c]).divideScalar(3).applyMatrix4(n),e.copy(d).applyMatrix3(i).normalize().multiplyScalar(r.size).add(t),o.setXYZ(u,t.x,t.y,t.z),u+=1,o.setXYZ(u,e.x,e.y,e.z),u+=1}o.needsUpdate=!0}}(),(xn.prototype=Object.create(bt.prototype)).constructor=xn,xn.prototype.dispose=function(){this.lightPlane.geometry.dispose(),this.lightPlane.material.dispose(),this.targetLine.geometry.dispose(),this.targetLine.material.dispose()},xn.prototype.update=function(){var t=new v,e=new v,i=new v;return function(){t.setFromMatrixPosition(this.light.matrixWorld),e.setFromMatrixPosition(this.light.target.matrixWorld),i.subVectors(e,t),this.lightPlane.lookAt(i),void 0!==this.color?(this.lightPlane.material.color.set(this.color),this.targetLine.material.color.set(this.color)):(this.lightPlane.material.color.copy(this.light.color),this.targetLine.material.color.copy(this.light.color)),this.targetLine.lookAt(i),this.targetLine.scale.z=i.length()}}(),(_n.prototype=Object.create($e.prototype)).constructor=_n,_n.prototype.update=function(){function t(t,o,a,s){r.set(o,a,s).unproject(n);var c=i[t];if(void 0!==c)for(var u=e.getAttribute("position"),l=0,h=c.length;l<h;l++)u.setXYZ(c[l],r.x,r.y,r.z)}var e,i,r=new v,n=new xt;return function(){e=this.geometry,i=this.pointMap;n.projectionMatrix.copy(this.camera.projectionMatrix),t("c",0,0,-1),t("t",0,0,1),t("n1",-1,-1,-1),t("n2",1,-1,-1),t("n3",-1,1,-1),t("n4",1,1,-1),t("f1",-1,-1,1),t("f2",1,-1,1),t("f3",-1,1,1),t("f4",1,1,1),t("u1",.7,1.1,-1),t("u2",-.7,1.1,-1),t("u3",0,2,-1),t("cf1",-1,0,1),t("cf2",1,0,1),t("cf3",0,-1,1),t("cf4",0,1,1),t("cn1",-1,0,-1),t("cn2",1,0,-1),t("cn3",0,-1,-1),t("cn4",0,1,-1),e.getAttribute("position").needsUpdate=!0}}(),(wn.prototype=Object.create($e.prototype)).constructor=wn,wn.prototype.update=function(){var t=new lt;return function(e){if(void 0!==e&&console.warn("THREE.BoxHelper: .update() has no longer arguments."),void 0!==this.object&&t.setFromObject(this.object),!t.isEmpty()){var i=t.min,r=t.max,n=this.geometry.attributes.position,o=n.array;o[0]=r.x,o[1]=r.y,o[2]=r.z,o[3]=i.x,o[4]=r.y,o[5]=r.z,o[6]=i.x,o[7]=i.y,o[8]=r.z,o[9]=r.x,o[10]=i.y,o[11]=r.z,o[12]=r.x,o[13]=r.y,o[14]=i.z,o[15]=i.x,o[16]=r.y,o[17]=i.z,o[18]=i.x,o[19]=i.y,o[20]=i.z,o[21]=r.x,o[22]=i.y,o[23]=i.z,n.needsUpdate=!0,this.geometry.computeBoundingSphere()}}}(),wn.prototype.setFromObject=function(t){return this.object=t,this.update(),this},(Sn.prototype=Object.create($e.prototype)).constructor=Sn,Sn.prototype.onBeforeRender=function(){var t=this.box;t.isEmpty()||(t.getCenter(this.position),t.getSize(this.scale),this.scale.multiplyScalar(.5))},(An.prototype=Object.create(Ge.prototype)).constructor=An,An.prototype.onBeforeRender=function(){var t=-this.plane.constant;Math.abs(t)<1e-8&&(t=1e-8),this.scale.set(.5*this.size,.5*this.size,t),this.lookAt(this.plane.normal),this.updateMatrixWorld()};var id,rd;(Mn.prototype=Object.create(bt.prototype)).constructor=Mn,Mn.prototype.setDirection=function(){var t,e=new v;return function(i){i.y>.99999?this.quaternion.set(0,0,0,1):i.y<-.99999?this.quaternion.set(1,0,0,0):(e.set(i.z,0,-i.x).normalize(),t=Math.acos(i.y),this.quaternion.setFromAxisAngle(e,t))}}(),Mn.prototype.setLength=function(t,e,i){void 0===e&&(e=.2*t),void 0===i&&(i=.2*e),this.line.scale.set(1,Math.max(0,t-e),1),this.line.updateMatrix(),this.cone.scale.set(i,e,i),this.cone.position.y=t,this.cone.updateMatrix()},Mn.prototype.setColor=function(t){this.line.material.color.copy(t),this.cone.material.color.copy(t)},(Pn.prototype=Object.create($e.prototype)).constructor=Pn;var nd=new v,od=new En,ad=new En,sd=new En;Tn.prototype=Object.create(Or.prototype),Tn.prototype.constructor=Tn,Tn.prototype.getPoint=function(t){var e=this.points,i=e.length,r=(i-(this.closed?0:1))*t,n=Math.floor(r),o=r-n;this.closed?n+=n>0?0:(Math.floor(Math.abs(n)/e.length)+1)*e.length:0===o&&n===i-1&&(n=i-2,o=1);var a,s,c,u;if(this.closed||n>0?a=e[(n-1)%i]:(nd.subVectors(e[0],e[1]).add(e[0]),a=nd),s=e[n%i],c=e[(n+1)%i],this.closed||n+2<i?u=e[(n+2)%i]:(nd.subVectors(e[i-1],e[i-2]).add(e[i-1]),u=nd),void 0===this.type||"centripetal"===this.type||"chordal"===this.type){var l="chordal"===this.type?.5:.25,h=Math.pow(a.distanceToSquared(s),l),p=Math.pow(s.distanceToSquared(c),l),d=Math.pow(c.distanceToSquared(u),l);p<1e-4&&(p=1),h<1e-4&&(h=p),d<1e-4&&(d=p),od.initNonuniformCatmullRom(a.x,s.x,c.x,u.x,h,p,d),ad.initNonuniformCatmullRom(a.y,s.y,c.y,u.y,h,p,d),sd.initNonuniformCatmullRom(a.z,s.z,c.z,u.z,h,p,d)}else if("catmullrom"===this.type){var f=void 0!==this.tension?this.tension:.5;od.initCatmullRom(a.x,s.x,c.x,u.x,f),ad.initCatmullRom(a.y,s.y,c.y,u.y,f),sd.initCatmullRom(a.z,s.z,c.z,u.z,f)}return new v(od.calc(o),ad.calc(o),sd.calc(o))},(Cn.prototype=Object.create(Or.prototype)).constructor=Cn,Cn.prototype.getPoint=function(t){var e=this.v0,i=this.v1,r=this.v2,n=this.v3;return new v(Lr(t,e.x,i.x,r.x,n.x),Lr(t,e.y,i.y,r.y,n.y),Lr(t,e.z,i.z,r.z,n.z))},(In.prototype=Object.create(Or.prototype)).constructor=In,In.prototype.getPoint=function(t){var e=this.v0,i=this.v1,r=this.v2;return new v(Er(t,e.x,i.x,r.x),Er(t,e.y,i.y,r.y),Er(t,e.z,i.z,r.z))},(Rn.prototype=Object.create(Or.prototype)).constructor=Rn,Rn.prototype.getPoint=function(t){if(1===t)return this.v2.clone();var e=new v;return e.subVectors(this.v2,this.v1),e.multiplyScalar(t),e.add(this.v1),e},(Ln.prototype=Object.create(kr.prototype)).constructor=Ln,Or.create=function(t,e){return console.log("THREE.Curve.create() has been deprecated"),t.prototype=Object.create(Or.prototype),t.prototype.constructor=t,t.prototype.getPoint=e,t},On.prototype=Object.create(Tn.prototype),Object.assign(On.prototype,{initFromArray:function(t){console.error("THREE.Spline: .initFromArray() has been removed.")},getControlPointsArray:function(t){console.error("THREE.Spline: .getControlPointsArray() has been removed.")},reparametrizeByArcLength:function(t){console.error("THREE.Spline: .reparametrizeByArcLength() has been removed.")}}),vn.prototype.setColors=function(){console.error("THREE.GridHelper: setColors() has been deprecated, pass them in the constructor instead.")},dn.prototype.update=function(){console.error("THREE.SkeletonHelper: update() no longer needs to be called.")},Object.assign(it.prototype,{center:function(t){return console.warn("THREE.Box2: .center() has been renamed to .getCenter()."),this.getCenter(t)},empty:function(){return console.warn("THREE.Box2: .empty() has been renamed to .isEmpty()."),this.isEmpty()},isIntersectionBox:function(t){return console.warn("THREE.Box2: .isIntersectionBox() has been renamed to .intersectsBox()."),this.intersectsBox(t)},size:function(t){return console.warn("THREE.Box2: .size() has been renamed to .getSize()."),this.getSize(t)}}),Object.assign(lt.prototype,{center:function(t){return console.warn("THREE.Box3: .center() has been renamed to .getCenter()."),this.getCenter(t)},empty:function(){return console.warn("THREE.Box3: .empty() has been renamed to .isEmpty()."),this.isEmpty()},isIntersectionBox:function(t){return console.warn("THREE.Box3: .isIntersectionBox() has been renamed to .intersectsBox()."),this.intersectsBox(t)},isIntersectionSphere:function(t){return console.warn("THREE.Box3: .isIntersectionSphere() has been renamed to .intersectsSphere()."),this.intersectsSphere(t)},size:function(t){return console.warn("THREE.Box3: .size() has been renamed to .getSize()."),this.getSize(t)}}),Ht.prototype.center=function(t){return console.warn("THREE.Line3: .center() has been renamed to .getCenter()."),this.getCenter(t)},Ap.random16=function(){return console.warn("THREE.Math.random16() has been deprecated. Use Math.random() instead."),Math.random()},Object.assign(pt.prototype,{flattenToArrayOffset:function(t,e){return console.warn("THREE.Matrix3: .flattenToArrayOffset() has been deprecated. Use .toArray() instead."),this.toArray(t,e)},multiplyVector3:function(t){return console.warn("THREE.Matrix3: .multiplyVector3() has been removed. Use vector.applyMatrix3( matrix ) instead."),t.applyMatrix3(this)},multiplyVector3Array:function(t){console.error("THREE.Matrix3: .multiplyVector3Array() has been removed.")},applyToBuffer:function(t,e,i){return console.warn("THREE.Matrix3: .applyToBuffer() has been removed. Use matrix.applyToBufferAttribute( attribute ) instead."),this.applyToBufferAttribute(t)},applyToVector3Array:function(t,e,i){console.error("THREE.Matrix3: .applyToVector3Array() has been removed.")}}),Object.assign(y.prototype,{extractPosition:function(t){return console.warn("THREE.Matrix4: .extractPosition() has been renamed to .copyPosition()."),this.copyPosition(t)},flattenToArrayOffset:function(t,e){return console.warn("THREE.Matrix4: .flattenToArrayOffset() has been deprecated. Use .toArray() instead."),this.toArray(t,e)},getPosition:function(){var t;return function(){return void 0===t&&(t=new v),console.warn("THREE.Matrix4: .getPosition() has been removed. Use Vector3.setFromMatrixPosition( matrix ) instead."),t.setFromMatrixColumn(this,3)}}(),setRotationFromQuaternion:function(t){return console.warn("THREE.Matrix4: .setRotationFromQuaternion() has been renamed to .makeRotationFromQuaternion()."),this.makeRotationFromQuaternion(t)},multiplyToArray:function(){console.warn("THREE.Matrix4: .multiplyToArray() has been removed.")},multiplyVector3:function(t){return console.warn("THREE.Matrix4: .multiplyVector3() has been removed. Use vector.applyMatrix4( matrix ) instead."),t.applyMatrix4(this)},multiplyVector4:function(t){return console.warn("THREE.Matrix4: .multiplyVector4() has been removed. Use vector.applyMatrix4( matrix ) instead."),t.applyMatrix4(this)},multiplyVector3Array:function(t){console.error("THREE.Matrix4: .multiplyVector3Array() has been removed.")},rotateAxis:function(t){console.warn("THREE.Matrix4: .rotateAxis() has been removed. Use Vector3.transformDirection( matrix ) instead."),t.transformDirection(this)},crossVector:function(t){return console.warn("THREE.Matrix4: .crossVector() has been removed. Use vector.applyMatrix4( matrix ) instead."),t.applyMatrix4(this)},translate:function(){console.error("THREE.Matrix4: .translate() has been removed.")},rotateX:function(){console.error("THREE.Matrix4: .rotateX() has been removed.")},rotateY:function(){console.error("THREE.Matrix4: .rotateY() has been removed.")},rotateZ:function(){console.error("THREE.Matrix4: .rotateZ() has been removed.")},rotateByAxis:function(){console.error("THREE.Matrix4: .rotateByAxis() has been removed.")},applyToBuffer:function(t,e,i){return console.warn("THREE.Matrix4: .applyToBuffer() has been removed. Use matrix.applyToBufferAttribute( attribute ) instead."),this.applyToBufferAttribute(t)},applyToVector3Array:function(t,e,i){console.error("THREE.Matrix4: .applyToVector3Array() has been removed.")},makeFrustum:function(t,e,i,r,n,o){return console.warn("THREE.Matrix4: .makeFrustum() has been removed. Use .makePerspective( left, right, top, bottom, near, far ) instead."),this.makePerspective(t,e,r,i,n,o)}}),dt.prototype.isIntersectionLine=function(t){return console.warn("THREE.Plane: .isIntersectionLine() has been renamed to .intersectsLine()."),this.intersectsLine(t)},g.prototype.multiplyVector3=function(t){return console.warn("THREE.Quaternion: .multiplyVector3() has been removed. Use is now vector.applyQuaternion( quaternion ) instead."),t.applyQuaternion(this)},Object.assign($t.prototype,{isIntersectionBox:function(t){return console.warn("THREE.Ray: .isIntersectionBox() has been renamed to .intersectsBox()."),this.intersectsBox(t)},isIntersectionPlane:function(t){return console.warn("THREE.Ray: .isIntersectionPlane() has been renamed to .intersectsPlane()."),this.intersectsPlane(t)},isIntersectionSphere:function(t){return console.warn("THREE.Ray: .isIntersectionSphere() has been renamed to .intersectsSphere()."),this.intersectsSphere(t)}}),Object.assign(jr.prototype,{extrude:function(t){return console.warn("THREE.Shape: .extrude() has been removed. Use ExtrudeGeometry() instead."),new vi(this,t)},makeGeometry:function(t){return console.warn("THREE.Shape: .makeGeometry() has been removed. Use ShapeGeometry() instead."),new Ei(this,t)}}),Object.assign(h.prototype,{fromAttribute:function(t,e,i){return console.error("THREE.Vector2: .fromAttribute() has been renamed to .fromBufferAttribute()."),this.fromBufferAttribute(t,e,i)}}),Object.assign(v.prototype,{setEulerFromRotationMatrix:function(){console.error("THREE.Vector3: .setEulerFromRotationMatrix() has been removed. Use Euler.setFromRotationMatrix() instead.")},setEulerFromQuaternion:function(){console.error("THREE.Vector3: .setEulerFromQuaternion() has been removed. Use Euler.setFromQuaternion() instead.")},getPositionFromMatrix:function(t){return console.warn("THREE.Vector3: .getPositionFromMatrix() has been renamed to .setFromMatrixPosition()."),this.setFromMatrixPosition(t)},getScaleFromMatrix:function(t){return console.warn("THREE.Vector3: .getScaleFromMatrix() has been renamed to .setFromMatrixScale()."),this.setFromMatrixScale(t)},getColumnFromMatrix:function(t,e){return console.warn("THREE.Vector3: .getColumnFromMatrix() has been renamed to .setFromMatrixColumn()."),this.setFromMatrixColumn(e,t)},applyProjection:function(t){return console.warn("THREE.Vector3: .applyProjection() has been removed. Use .applyMatrix4( m ) instead."),this.applyMatrix4(t)},fromAttribute:function(t,e,i){return console.error("THREE.Vector3: .fromAttribute() has been renamed to .fromBufferAttribute()."),this.fromBufferAttribute(t,e,i)}}),Object.assign(d.prototype,{fromAttribute:function(t,e,i){return console.error("THREE.Vector4: .fromAttribute() has been renamed to .fromBufferAttribute()."),this.fromBufferAttribute(t,e,i)}}),Mt.prototype.computeTangents=function(){console.warn("THREE.Geometry: .computeTangents() has been removed.")},Object.assign(bt.prototype,{getChildByName:function(t){return console.warn("THREE.Object3D: .getChildByName() has been renamed to .getObjectByName()."),this.getObjectByName(t)},renderDepth:function(){console.warn("THREE.Object3D: .renderDepth has been removed. Use .renderOrder, instead.")},translate:function(t,e){return console.warn("THREE.Object3D: .translate() has been removed. Use .translateOnAxis( axis, distance ) instead."),this.translateOnAxis(e,t)}}),Object.defineProperties(bt.prototype,{eulerOrder:{get:function(){return console.warn("THREE.Object3D: .eulerOrder is now .rotation.order."),this.rotation.order},set:function(t){console.warn("THREE.Object3D: .eulerOrder is now .rotation.order."),this.rotation.order=t}},useQuaternion:{get:function(){console.warn("THREE.Object3D: .useQuaternion has been removed. The library now uses quaternions by default.")},set:function(){console.warn("THREE.Object3D: .useQuaternion has been removed. The library now uses quaternions by default.")}}}),Object.defineProperties(Fe.prototype,{objects:{get:function(){return console.warn("THREE.LOD: .objects has been renamed to .levels."),this.levels}}}),Object.defineProperty(ze.prototype,"useVertexTexture",{get:function(){console.warn("THREE.Skeleton: useVertexTexture has been removed.")},set:function(){console.warn("THREE.Skeleton: useVertexTexture has been removed.")}}),Object.defineProperty(Or.prototype,"__arcLengthDivisions",{get:function(){return console.warn("THREE.Curve: .__arcLengthDivisions is now .arcLengthDivisions."),this.arcLengthDivisions},set:function(t){console.warn("THREE.Curve: .__arcLengthDivisions is now .arcLengthDivisions."),this.arcLengthDivisions=t}}),wt.prototype.setLens=function(t,e){console.warn("THREE.PerspectiveCamera.setLens is deprecated. Use .setFocalLength and .filmGauge for a photographic setup."),void 0!==e&&(this.filmGauge=e),this.setFocalLength(t)},Object.defineProperties(Yi.prototype,{onlyShadow:{set:function(){console.warn("THREE.Light: .onlyShadow has been removed.")}},shadowCameraFov:{set:function(t){console.warn("THREE.Light: .shadowCameraFov is now .shadow.camera.fov."),this.shadow.camera.fov=t}},shadowCameraLeft:{set:function(t){console.warn("THREE.Light: .shadowCameraLeft is now .shadow.camera.left."),this.shadow.camera.left=t}},shadowCameraRight:{set:function(t){console.warn("THREE.Light: .shadowCameraRight is now .shadow.camera.right."),this.shadow.camera.right=t}},shadowCameraTop:{set:function(t){console.warn("THREE.Light: .shadowCameraTop is now .shadow.camera.top."),this.shadow.camera.top=t}},shadowCameraBottom:{set:function(t){console.warn("THREE.Light: .shadowCameraBottom is now .shadow.camera.bottom."),this.shadow.camera.bottom=t}},shadowCameraNear:{set:function(t){console.warn("THREE.Light: .shadowCameraNear is now .shadow.camera.near."),this.shadow.camera.near=t}},shadowCameraFar:{set:function(t){console.warn("THREE.Light: .shadowCameraFar is now .shadow.camera.far."),this.shadow.camera.far=t}},shadowCameraVisible:{set:function(){console.warn("THREE.Light: .shadowCameraVisible has been removed. Use new THREE.CameraHelper( light.shadow.camera ) instead.")}},shadowBias:{set:function(t){console.warn("THREE.Light: .shadowBias is now .shadow.bias."),this.shadow.bias=t}},shadowDarkness:{set:function(){console.warn("THREE.Light: .shadowDarkness has been removed.")}},shadowMapWidth:{set:function(t){console.warn("THREE.Light: .shadowMapWidth is now .shadow.mapSize.width."),this.shadow.mapSize.width=t}},shadowMapHeight:{set:function(t){console.warn("THREE.Light: .shadowMapHeight is now .shadow.mapSize.height."),this.shadow.mapSize.height=t}}}),Object.defineProperties(Pt.prototype,{length:{get:function(){return console.warn("THREE.BufferAttribute: .length has been deprecated. Use .count instead."),this.array.length}}}),Object.assign(Ft.prototype,{addIndex:function(t){console.warn("THREE.BufferGeometry: .addIndex() has been renamed to .setIndex()."),this.setIndex(t)},addDrawCall:function(t,e,i){void 0!==i&&console.warn("THREE.BufferGeometry: .addDrawCall() no longer supports indexOffset."),console.warn("THREE.BufferGeometry: .addDrawCall() is now .addGroup()."),this.addGroup(t,e)},clearDrawCalls:function(){console.warn("THREE.BufferGeometry: .clearDrawCalls() is now .clearGroups()."),this.clearGroups()},computeTangents:function(){console.warn("THREE.BufferGeometry: .computeTangents() has been removed.")},computeOffsets:function(){console.warn("THREE.BufferGeometry: .computeOffsets() has been removed.")}}),Object.defineProperties(Ft.prototype,{drawcalls:{get:function(){return console.error("THREE.BufferGeometry: .drawcalls has been renamed to .groups."),this.groups}},offsets:{get:function(){return console.warn("THREE.BufferGeometry: .offsets has been renamed to .groups."),this.groups}}}),Object.defineProperties(tn.prototype,{dynamic:{set:function(){console.warn("THREE.Uniform: .dynamic has been removed. Use object.onBeforeRender() instead.")}},onUpdate:{value:function(){return console.warn("THREE.Uniform: .onUpdate() has been removed. Use object.onBeforeRender() instead."),this}}}),Object.defineProperties(at.prototype,{wrapAround:{get:function(){console.warn("THREE.Material: .wrapAround has been removed.")},set:function(){console.warn("THREE.Material: .wrapAround has been removed.")}},wrapRGB:{get:function(){return console.warn("THREE.Material: .wrapRGB has been removed."),new et}},shading:{get:function(){console.error("THREE."+this.type+": .shading has been removed. Use the boolean .flatShading instead.")},set:function(t){console.warn("THREE."+this.type+": .shading has been removed. Use the boolean .flatShading instead."),this.flatShading=1===t}}}),Object.defineProperties(Ui.prototype,{metal:{get:function(){return console.warn("THREE.MeshPhongMaterial: .metal has been removed. Use THREE.MeshStandardMaterial instead."),!1},set:function(){console.warn("THREE.MeshPhongMaterial: .metal has been removed. Use THREE.MeshStandardMaterial instead")}}}),Object.defineProperties(st.prototype,{derivatives:{get:function(){return console.warn("THREE.ShaderMaterial: .derivatives has been moved to .extensions.derivatives."),this.extensions.derivatives},set:function(t){console.warn("THREE. ShaderMaterial: .derivatives has been moved to .extensions.derivatives."),this.extensions.derivatives=t}}}),Object.assign(Re.prototype,{getCurrentRenderTarget:function(){return console.warn("THREE.WebGLRenderer: .getCurrentRenderTarget() is now .getRenderTarget()."),this.getRenderTarget()},getMaxAnisotropy:function(){return console.warn("THREE.WebGLRenderer: .getMaxAnisotropy() is now .capabilities.getMaxAnisotropy()."),this.capabilities.getMaxAnisotropy()},getPrecision:function(){return console.warn("THREE.WebGLRenderer: .getPrecision() is now .capabilities.precision."),this.capabilities.precision},supportsFloatTextures:function(){return console.warn("THREE.WebGLRenderer: .supportsFloatTextures() is now .extensions.get( 'OES_texture_float' )."),this.extensions.get("OES_texture_float")},supportsHalfFloatTextures:function(){return console.warn("THREE.WebGLRenderer: .supportsHalfFloatTextures() is now .extensions.get( 'OES_texture_half_float' )."),this.extensions.get("OES_texture_half_float")},supportsStandardDerivatives:function(){return console.warn("THREE.WebGLRenderer: .supportsStandardDerivatives() is now .extensions.get( 'OES_standard_derivatives' )."),this.extensions.get("OES_standard_derivatives")},supportsCompressedTextureS3TC:function(){return console.warn("THREE.WebGLRenderer: .supportsCompressedTextureS3TC() is now .extensions.get( 'WEBGL_compressed_texture_s3tc' )."),this.extensions.get("WEBGL_compressed_texture_s3tc")},supportsCompressedTexturePVRTC:function(){return console.warn("THREE.WebGLRenderer: .supportsCompressedTexturePVRTC() is now .extensions.get( 'WEBGL_compressed_texture_pvrtc' )."),this.extensions.get("WEBGL_compressed_texture_pvrtc")},supportsBlendMinMax:function(){return console.warn("THREE.WebGLRenderer: .supportsBlendMinMax() is now .extensions.get( 'EXT_blend_minmax' )."),this.extensions.get("EXT_blend_minmax")},supportsVertexTextures:function(){return console.warn("THREE.WebGLRenderer: .supportsVertexTextures() is now .capabilities.vertexTextures."),this.capabilities.vertexTextures},supportsInstancedArrays:function(){return console.warn("THREE.WebGLRenderer: .supportsInstancedArrays() is now .extensions.get( 'ANGLE_instanced_arrays' )."),this.extensions.get("ANGLE_instanced_arrays")},enableScissorTest:function(t){console.warn("THREE.WebGLRenderer: .enableScissorTest() is now .setScissorTest()."),this.setScissorTest(t)},initMaterial:function(){console.warn("THREE.WebGLRenderer: .initMaterial() has been removed.")},addPrePlugin:function(){console.warn("THREE.WebGLRenderer: .addPrePlugin() has been removed.")},addPostPlugin:function(){console.warn("THREE.WebGLRenderer: .addPostPlugin() has been removed.")},updateShadowMap:function(){console.warn("THREE.WebGLRenderer: .updateShadowMap() has been removed.")}}),Object.defineProperties(Re.prototype,{shadowMapEnabled:{get:function(){return this.shadowMap.enabled},set:function(t){console.warn("THREE.WebGLRenderer: .shadowMapEnabled is now .shadowMap.enabled."),this.shadowMap.enabled=t}},shadowMapType:{get:function(){return this.shadowMap.type},set:function(t){console.warn("THREE.WebGLRenderer: .shadowMapType is now .shadowMap.type."),this.shadowMap.type=t}},shadowMapCullFace:{get:function(){return this.shadowMap.cullFace},set:function(t){console.warn("THREE.WebGLRenderer: .shadowMapCullFace is now .shadowMap.cullFace."),this.shadowMap.cullFace=t}}}),Object.defineProperties(mt.prototype,{cullFace:{get:function(){return this.renderReverseSided?Pl:Ml},set:function(t){var e=t!==Ml;console.warn("WebGLRenderer: .shadowMap.cullFace is deprecated. Set .shadowMap.renderReverseSided to "+e+"."),this.renderReverseSided=e}}}),Object.defineProperties(f.prototype,{wrapS:{get:function(){return console.warn("THREE.WebGLRenderTarget: .wrapS is now .texture.wrapS."),this.texture.wrapS},set:function(t){console.warn("THREE.WebGLRenderTarget: .wrapS is now .texture.wrapS."),this.texture.wrapS=t}},wrapT:{get:function(){return console.warn("THREE.WebGLRenderTarget: .wrapT is now .texture.wrapT."),this.texture.wrapT},set:function(t){console.warn("THREE.WebGLRenderTarget: .wrapT is now .texture.wrapT."),this.texture.wrapT=t}},magFilter:{get:function(){return console.warn("THREE.WebGLRenderTarget: .magFilter is now .texture.magFilter."),this.texture.magFilter},set:function(t){console.warn("THREE.WebGLRenderTarget: .magFilter is now .texture.magFilter."),this.texture.magFilter=t}},minFilter:{get:function(){return console.warn("THREE.WebGLRenderTarget: .minFilter is now .texture.minFilter."),this.texture.minFilter},set:function(t){console.warn("THREE.WebGLRenderTarget: .minFilter is now .texture.minFilter."),this.texture.minFilter=t}},anisotropy:{get:function(){return console.warn("THREE.WebGLRenderTarget: .anisotropy is now .texture.anisotropy."),this.texture.anisotropy},set:function(t){console.warn("THREE.WebGLRenderTarget: .anisotropy is now .texture.anisotropy."),this.texture.anisotropy=t}},offset:{get:function(){return console.warn("THREE.WebGLRenderTarget: .offset is now .texture.offset."),this.texture.offset},set:function(t){console.warn("THREE.WebGLRenderTarget: .offset is now .texture.offset."),this.texture.offset=t}},repeat:{get:function(){return console.warn("THREE.WebGLRenderTarget: .repeat is now .texture.repeat."),this.texture.repeat},set:function(t){console.warn("THREE.WebGLRenderTarget: .repeat is now .texture.repeat."),this.texture.repeat=t}},format:{get:function(){return console.warn("THREE.WebGLRenderTarget: .format is now .texture.format."),this.texture.format},set:function(t){console.warn("THREE.WebGLRenderTarget: .format is now .texture.format."),this.texture.format=t}},type:{get:function(){return console.warn("THREE.WebGLRenderTarget: .type is now .texture.type."),this.texture.type},set:function(t){console.warn("THREE.WebGLRenderTarget: .type is now .texture.type."),this.texture.type=t}},generateMipmaps:{get:function(){return console.warn("THREE.WebGLRenderTarget: .generateMipmaps is now .texture.generateMipmaps."),this.texture.generateMipmaps},set:function(t){console.warn("THREE.WebGLRenderTarget: .generateMipmaps is now .texture.generateMipmaps."),this.texture.generateMipmaps=t}}}),Xr.prototype.load=function(t){console.warn("THREE.Audio: .load has been deprecated. Use THREE.AudioLoader instead.");var e=this;return(new $r).load(t,function(t){e.setBuffer(t)}),this},Yr.prototype.getData=function(){return console.warn("THREE.AudioAnalyser: .getData() is now .getFrequencyData()."),this.getFrequencyData()},Hr.prototype.updateCubeMap=function(t,e){return console.warn("THREE.CubeCamera: .updateCubeMap() is now .update()."),this.update(t,e)};var cd=function(t){this.name=t,this._dict={}},ud={names:{configurable:!0}};cd.prototype.add=function(t,e){this._dict[so(t)]=e},cd.prototype.get=function(t){return this._dict[so(t)]},ud.names.get=function(){return Object.keys(this._dict)},Object.defineProperties(cd.prototype,ud);var ld,hd,pd,dd,fd,md,gd,vd,yd,bd,xd,_d,wd,Sd,Ad,Md,Pd,Ed,Td,Cd,Id,Rd,Ld,Od,Dd,Nd,kd,Bd,Fd,zd,Ud,jd,Vd,Gd,$d,Hd,Wd,Xd,qd,Yd,Zd,Kd,Qd,Jd,tf,ef,rf,nf,of,af,sf,cf,uf,lf,hf,pf,df,ff,mf,gf,vf,yf,bf,xf,_f,wf,Sf,Af,Mf,Pf,Ef,Tf,Cf,If,Rf,Lf,Of,Df,Nf,kf="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".split(""),Bf=new Array(36),Ff=[].slice;Rf=function(){var t,e,i,r,n;for(t={},r=0,e=(n="Boolean Number String Function Array Date RegExp Undefined Null".split(" ")).length;r<e;r++)i=n[r],t["[object "+i+"]"]=i.toLowerCase();return function(e){var i;return i=Object.prototype.toString.call(e),t[i]||"object"}}(),tf=function(t,e,i){return null==e&&(e=0),null==i&&(i=1),t<e&&(t=e),t>i&&(t=i),t},Lf=function(t){return t.length>=3?[].slice.call(t):t[0]},Cd=function(t){var e,i;for(t._clipped=!1,t._unclipped=t.slice(0),e=i=0;i<3;e=++i)e<3?((t[e]<0||t[e]>255)&&(t._clipped=!0),t[e]<0&&(t[e]=0),t[e]>255&&(t[e]=255)):3===e&&(t[e]<0&&(t[e]=0),t[e]>1&&(t[e]=1));return t._clipped||delete t._unclipped,t},dd=Math.PI,Pf=Math.round,Rd=Math.cos,kd=Math.floor,lf=Math.pow,ef=Math.log,Tf=Math.sin,Cf=Math.sqrt,wd=Math.atan2,of=Math.max,_d=Math.abs,gd=2*dd,fd=dd/3,hd=dd/180,md=180/dd,xd=[],(Td=function(){return arguments[0]instanceof ld?arguments[0]:function(t,e,i){i.prototype=t.prototype;var r=new i,n=t.apply(r,e);return Object(n)===n?n:r}(ld,arguments,function(){})}).version="1.3.3",bd={},vd=[],yd=!1,ld=function(){function t(){var t,e,i,r,n,o,a,s,c,u=arguments;for(o=this,e=[],s=0,r=arguments.length;s<r;s++)null!=(t=u[s])&&e.push(t);if(a=e[e.length-1],null!=bd[a])o._rgb=Cd(bd[a](Lf(e.slice(0,-1))));else{for(yd||(vd=vd.sort(function(t,e){return e.p-t.p}),yd=!0),c=0,n=vd.length;c<n&&(i=vd[c],!(a=i.test.apply(i,e)));c++);a&&(o._rgb=Cd(bd[a].apply(bd,e)))}null==o._rgb&&console.warn("unknown format: "+e),null==o._rgb&&(o._rgb=[0,0,0]),3===o._rgb.length&&o._rgb.push(1)}return t.prototype.toString=function(){return this.hex()},t}(),Td._input=bd,Td.brewer=Pd={OrRd:["#fff7ec","#fee8c8","#fdd49e","#fdbb84","#fc8d59","#ef6548","#d7301f","#b30000","#7f0000"],PuBu:["#fff7fb","#ece7f2","#d0d1e6","#a6bddb","#74a9cf","#3690c0","#0570b0","#045a8d","#023858"],BuPu:["#f7fcfd","#e0ecf4","#bfd3e6","#9ebcda","#8c96c6","#8c6bb1","#88419d","#810f7c","#4d004b"],Oranges:["#fff5eb","#fee6ce","#fdd0a2","#fdae6b","#fd8d3c","#f16913","#d94801","#a63603","#7f2704"],BuGn:["#f7fcfd","#e5f5f9","#ccece6","#99d8c9","#66c2a4","#41ae76","#238b45","#006d2c","#00441b"],YlOrBr:["#ffffe5","#fff7bc","#fee391","#fec44f","#fe9929","#ec7014","#cc4c02","#993404","#662506"],YlGn:["#ffffe5","#f7fcb9","#d9f0a3","#addd8e","#78c679","#41ab5d","#238443","#006837","#004529"],Reds:["#fff5f0","#fee0d2","#fcbba1","#fc9272","#fb6a4a","#ef3b2c","#cb181d","#a50f15","#67000d"],RdPu:["#fff7f3","#fde0dd","#fcc5c0","#fa9fb5","#f768a1","#dd3497","#ae017e","#7a0177","#49006a"],Greens:["#f7fcf5","#e5f5e0","#c7e9c0","#a1d99b","#74c476","#41ab5d","#238b45","#006d2c","#00441b"],YlGnBu:["#ffffd9","#edf8b1","#c7e9b4","#7fcdbb","#41b6c4","#1d91c0","#225ea8","#253494","#081d58"],Purples:["#fcfbfd","#efedf5","#dadaeb","#bcbddc","#9e9ac8","#807dba","#6a51a3","#54278f","#3f007d"],GnBu:["#f7fcf0","#e0f3db","#ccebc5","#a8ddb5","#7bccc4","#4eb3d3","#2b8cbe","#0868ac","#084081"],Greys:["#ffffff","#f0f0f0","#d9d9d9","#bdbdbd","#969696","#737373","#525252","#252525","#000000"],YlOrRd:["#ffffcc","#ffeda0","#fed976","#feb24c","#fd8d3c","#fc4e2a","#e31a1c","#bd0026","#800026"],PuRd:["#f7f4f9","#e7e1ef","#d4b9da","#c994c7","#df65b0","#e7298a","#ce1256","#980043","#67001f"],Blues:["#f7fbff","#deebf7","#c6dbef","#9ecae1","#6baed6","#4292c6","#2171b5","#08519c","#08306b"],PuBuGn:["#fff7fb","#ece2f0","#d0d1e6","#a6bddb","#67a9cf","#3690c0","#02818a","#016c59","#014636"],Viridis:["#440154","#482777","#3f4a8a","#31678e","#26838f","#1f9d8a","#6cce5a","#b6de2b","#fee825"],Spectral:["#9e0142","#d53e4f","#f46d43","#fdae61","#fee08b","#ffffbf","#e6f598","#abdda4","#66c2a5","#3288bd","#5e4fa2"],RdYlGn:["#a50026","#d73027","#f46d43","#fdae61","#fee08b","#ffffbf","#d9ef8b","#a6d96a","#66bd63","#1a9850","#006837"],RdBu:["#67001f","#b2182b","#d6604d","#f4a582","#fddbc7","#f7f7f7","#d1e5f0","#92c5de","#4393c3","#2166ac","#053061"],PiYG:["#8e0152","#c51b7d","#de77ae","#f1b6da","#fde0ef","#f7f7f7","#e6f5d0","#b8e186","#7fbc41","#4d9221","#276419"],PRGn:["#40004b","#762a83","#9970ab","#c2a5cf","#e7d4e8","#f7f7f7","#d9f0d3","#a6dba0","#5aae61","#1b7837","#00441b"],RdYlBu:["#a50026","#d73027","#f46d43","#fdae61","#fee090","#ffffbf","#e0f3f8","#abd9e9","#74add1","#4575b4","#313695"],BrBG:["#543005","#8c510a","#bf812d","#dfc27d","#f6e8c3","#f5f5f5","#c7eae5","#80cdc1","#35978f","#01665e","#003c30"],RdGy:["#67001f","#b2182b","#d6604d","#f4a582","#fddbc7","#ffffff","#e0e0e0","#bababa","#878787","#4d4d4d","#1a1a1a"],PuOr:["#7f3b08","#b35806","#e08214","#fdb863","#fee0b6","#f7f7f7","#d8daeb","#b2abd2","#8073ac","#542788","#2d004b"],Set2:["#66c2a5","#fc8d62","#8da0cb","#e78ac3","#a6d854","#ffd92f","#e5c494","#b3b3b3"],Accent:["#7fc97f","#beaed4","#fdc086","#ffff99","#386cb0","#f0027f","#bf5b17","#666666"],Set1:["#e41a1c","#377eb8","#4daf4a","#984ea3","#ff7f00","#ffff33","#a65628","#f781bf","#999999"],Set3:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3","#fdb462","#b3de69","#fccde5","#d9d9d9","#bc80bd","#ccebc5","#ffed6f"],Dark2:["#1b9e77","#d95f02","#7570b3","#e7298a","#66a61e","#e6ab02","#a6761d","#666666"],Paired:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99","#e31a1c","#fdbf6f","#ff7f00","#cab2d6","#6a3d9a","#ffff99","#b15928"],Pastel2:["#b3e2cd","#fdcdac","#cbd5e8","#f4cae4","#e6f5c9","#fff2ae","#f1e2cc","#cccccc"],Pastel1:["#fbb4ae","#b3cde3","#ccebc5","#decbe4","#fed9a6","#ffffcc","#e5d8bd","#fddaec","#f2f2f2"]},function(){var t,e;e=[];for(t in Pd)e.push(Pd[t.toLowerCase()]=Pd[t])}(),Of={aliceblue:"#f0f8ff",antiquewhite:"#faebd7",aqua:"#00ffff",aquamarine:"#7fffd4",azure:"#f0ffff",beige:"#f5f5dc",bisque:"#ffe4c4",black:"#000000",blanchedalmond:"#ffebcd",blue:"#0000ff",blueviolet:"#8a2be2",brown:"#a52a2a",burlywood:"#deb887",cadetblue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",coral:"#ff7f50",cornflower:"#6495ed",cornflowerblue:"#6495ed",cornsilk:"#fff8dc",crimson:"#dc143c",cyan:"#00ffff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",darkgray:"#a9a9a9",darkgreen:"#006400",darkgrey:"#a9a9a9",darkkhaki:"#bdb76b",darkmagenta:"#8b008b",darkolivegreen:"#556b2f",darkorange:"#ff8c00",darkorchid:"#9932cc",darkred:"#8b0000",darksalmon:"#e9967a",darkseagreen:"#8fbc8f",darkslateblue:"#483d8b",darkslategray:"#2f4f4f",darkslategrey:"#2f4f4f",darkturquoise:"#00ced1",darkviolet:"#9400d3",deeppink:"#ff1493",deepskyblue:"#00bfff",dimgray:"#696969",dimgrey:"#696969",dodgerblue:"#1e90ff",firebrick:"#b22222",floralwhite:"#fffaf0",forestgreen:"#228b22",fuchsia:"#ff00ff",gainsboro:"#dcdcdc",ghostwhite:"#f8f8ff",gold:"#ffd700",goldenrod:"#daa520",gray:"#808080",green:"#008000",greenyellow:"#adff2f",grey:"#808080",honeydew:"#f0fff0",hotpink:"#ff69b4",indianred:"#cd5c5c",indigo:"#4b0082",ivory:"#fffff0",khaki:"#f0e68c",laserlemon:"#ffff54",lavender:"#e6e6fa",lavenderblush:"#fff0f5",lawngreen:"#7cfc00",lemonchiffon:"#fffacd",lightblue:"#add8e6",lightcoral:"#f08080",lightcyan:"#e0ffff",lightgoldenrod:"#fafad2",lightgoldenrodyellow:"#fafad2",lightgray:"#d3d3d3",lightgreen:"#90ee90",lightgrey:"#d3d3d3",lightpink:"#ffb6c1",lightsalmon:"#ffa07a",lightseagreen:"#20b2aa",lightskyblue:"#87cefa",lightslategray:"#778899",lightslategrey:"#778899",lightsteelblue:"#b0c4de",lightyellow:"#ffffe0",lime:"#00ff00",limegreen:"#32cd32",linen:"#faf0e6",magenta:"#ff00ff",maroon:"#800000",maroon2:"#7f0000",maroon3:"#b03060",mediumaquamarine:"#66cdaa",mediumblue:"#0000cd",mediumorchid:"#ba55d3",mediumpurple:"#9370db",mediumseagreen:"#3cb371",mediumslateblue:"#7b68ee",mediumspringgreen:"#00fa9a",mediumturquoise:"#48d1cc",mediumvioletred:"#c71585",midnightblue:"#191970",mintcream:"#f5fffa",mistyrose:"#ffe4e1",moccasin:"#ffe4b5",navajowhite:"#ffdead",navy:"#000080",oldlace:"#fdf5e6",olive:"#808000",olivedrab:"#6b8e23",orange:"#ffa500",orangered:"#ff4500",orchid:"#da70d6",palegoldenrod:"#eee8aa",palegreen:"#98fb98",paleturquoise:"#afeeee",palevioletred:"#db7093",papayawhip:"#ffefd5",peachpuff:"#ffdab9",peru:"#cd853f",pink:"#ffc0cb",plum:"#dda0dd",powderblue:"#b0e0e6",purple:"#800080",purple2:"#7f007f",purple3:"#a020f0",rebeccapurple:"#663399",red:"#ff0000",rosybrown:"#bc8f8f",royalblue:"#4169e1",saddlebrown:"#8b4513",salmon:"#fa8072",sandybrown:"#f4a460",seagreen:"#2e8b57",seashell:"#fff5ee",sienna:"#a0522d",silver:"#c0c0c0",skyblue:"#87ceeb",slateblue:"#6a5acd",slategray:"#708090",slategrey:"#708090",snow:"#fffafa",springgreen:"#00ff7f",steelblue:"#4682b4",tan:"#d2b48c",teal:"#008080",thistle:"#d8bfd8",tomato:"#ff6347",turquoise:"#40e0d0",violet:"#ee82ee",wheat:"#f5deb3",white:"#ffffff",whitesmoke:"#f5f5f5",yellow:"#ffff00",yellowgreen:"#9acd32"},Td.colors=Of,Yd=function(){var t,e,i,r,n,o,a,s,c;return e=Lf(arguments),n=e[0],t=e[1],i=e[2],s=(n+16)/116,a=isNaN(t)?s:s+t/500,c=isNaN(i)?s:s-i/200,s=pd.Yn*Zd(s),a=pd.Xn*Zd(a),c=pd.Zn*Zd(c),o=Nf(3.2404542*a-1.5371385*s-.4985314*c),r=Nf(-.969266*a+1.8760108*s+.041556*c),i=Nf(.0556434*a-.2040259*s+1.0572252*c),[o,r,i,e.length>3?e[3]:1]},Nf=function(t){return 255*(t<=.00304?12.92*t:1.055*lf(t,1/2.4)-.055)},Zd=function(t){return t>pd.t1?t*t*t:pd.t2*(t-pd.t0)},pd={Kn:18,Xn:.95047,Yn:1,Zn:1.08883,t0:.137931034,t1:.206896552,t2:.12841855,t3:.008856452},yf=function(){var t,e,i,r,n,o,a,s;return r=Lf(arguments),i=r[0],e=r[1],t=r[2],n=Sf(i,e,t),o=n[0],a=n[1],s=n[2],[116*a-16,500*(o-a),200*(a-s)]},Af=function(t){return(t/=255)<=.04045?t/12.92:lf((t+.055)/1.055,2.4)},Df=function(t){return t>pd.t3?lf(t,1/3):t/pd.t2+pd.t0},Sf=function(){var t,e,i,r,n,o,a;return r=Lf(arguments),i=r[0],e=r[1],t=r[2],i=Af(i),e=Af(e),t=Af(t),n=Df((.4124564*i+.3575761*e+.1804375*t)/pd.Xn),o=Df((.2126729*i+.7151522*e+.072175*t)/pd.Yn),a=Df((.0193339*i+.119192*e+.9503041*t)/pd.Zn),[n,o,a]},Td.lab=function(){return function(t,e,i){i.prototype=t.prototype;var r=new i,n=t.apply(r,e);return Object(n)===n?n:r}(ld,Ff.call(arguments).concat(["lab"]),function(){})},bd.lab=Yd,ld.prototype.lab=function(){return yf(this._rgb)},Sd=function(t){var e,i,r,n,o,a,s,c,u,l,h;return 2===(t=function(){var e,i,r;for(r=[],i=0,e=t.length;i<e;i++)n=t[i],r.push(Td(n));return r}()).length?(u=function(){var e,i,r;for(r=[],i=0,e=t.length;i<e;i++)n=t[i],r.push(n.lab());return r}(),o=u[0],a=u[1],e=function(t){var e,i;return i=function(){var i,r;for(r=[],e=i=0;i<=2;e=++i)r.push(o[e]+t*(a[e]-o[e]));return r}(),Td.lab.apply(Td,i)}):3===t.length?(l=function(){var e,i,r;for(r=[],i=0,e=t.length;i<e;i++)n=t[i],r.push(n.lab());return r}(),o=l[0],a=l[1],s=l[2],e=function(t){var e,i;return i=function(){var i,r;for(r=[],e=i=0;i<=2;e=++i)r.push((1-t)*(1-t)*o[e]+2*(1-t)*t*a[e]+t*t*s[e]);return r}(),Td.lab.apply(Td,i)}):4===t.length?(h=function(){var e,i,r;for(r=[],i=0,e=t.length;i<e;i++)n=t[i],r.push(n.lab());return r}(),o=h[0],a=h[1],s=h[2],c=h[3],e=function(t){var e,i;return i=function(){var i,r;for(r=[],e=i=0;i<=2;e=++i)r.push((1-t)*(1-t)*(1-t)*o[e]+3*(1-t)*(1-t)*t*a[e]+3*(1-t)*t*t*s[e]+t*t*t*c[e]);return r}(),Td.lab.apply(Td,i)}):5===t.length&&(i=Sd(t.slice(0,3)),r=Sd(t.slice(2,5)),e=function(t){return t<.5?i(2*t):r(2*(t-.5))}),e},Td.bezier=function(t){var e;return e=Sd(t),e.scale=function(){return Td.scale(e)},e},Td.cubehelix=function(t,e,i,r,n){var o,a,s;return null==t&&(t=300),null==e&&(e=-1.5),null==i&&(i=1),null==r&&(r=1),null==n&&(n=[0,1]),o=0,"array"===Rf(n)?a=n[1]-n[0]:(a=0,n=[n,n]),s=function(s){var c,u,l,h,p,d,f,m,g;return c=gd*((t+120)/360+e*s),f=lf(n[0]+a*s,r),d=0!==o?i[0]+s*o:i,u=d*f*(1-f)/2,h=Rd(c),g=Tf(c),m=f+u*(-.14861*h+1.78277*g),p=f+u*(-.29227*h-.90649*g),l=f+u*(1.97294*h),Td(Cd([255*m,255*p,255*l]))},s.start=function(e){return null==e?t:(t=e,s)},s.rotations=function(t){return null==t?e:(e=t,s)},s.gamma=function(t){return null==t?r:(r=t,s)},s.hue=function(t){return null==t?i:(i=t,"array"===Rf(i)?0===(o=i[1]-i[0])&&(i=i[1]):o=0,s)},s.lightness=function(t){return null==t?n:("array"===Rf(t)?(n=t,a=t[1]-t[0]):(n=[t,t],a=0),s)},s.scale=function(){return Td.scale(s)},s.hue(i),s},Td.random=function(){var t,e;for("0123456789abcdef",t="#",e=0;e<6;++e)t+="0123456789abcdef".charAt(kd(16*Math.random()));return new ld(t)},Td.average=function(t,e){var i,r,n,o,a,s,c,u,l,h,p,d,f;null==e&&(e="rgb"),l=t.length,d=(c=(t=t.map(function(t){return Td(t)})).splice(0,1)[0]).get(e),o=[],a=0,s=0;for(u in d)d[u]=d[u]||0,o.push(isNaN(d[u])?0:1),"h"!==e.charAt(u)||isNaN(d[u])||(i=d[u]/180*dd,a+=Rd(i),s+=Tf(i));for(r=c.alpha(),p=0,h=t.length;p<h;p++){f=(n=t[p]).get(e),r+=n.alpha();for(u in d)isNaN(f[u])||(d[u]+=f[u],o[u]+=1,"h"===e.charAt(u)&&(i=d[u]/180*dd,a+=Rd(i),s+=Tf(i)))}for(u in d)if(d[u]=d[u]/o[u],"h"===e.charAt(u)){for(i=wd(s/o[u],a/o[u])/dd*180;i<0;)i+=360;for(;i>=360;)i-=360;d[u]=i}return Td(d,e).alpha(r/l)},bd.rgb=function(){var t,e,i,r;e=Lf(arguments),i=[];for(t in e)r=e[t],i.push(r);return i},Td.rgb=function(){return function(t,e,i){i.prototype=t.prototype;var r=new i,n=t.apply(r,e);return Object(n)===n?n:r}(ld,Ff.call(arguments).concat(["rgb"]),function(){})},ld.prototype.rgb=function(t){return null==t&&(t=!0),t?this._rgb.map(Math.round).slice(0,3):this._rgb.slice(0,3)},ld.prototype.rgba=function(t){return null==t&&(t=!0),t?[Math.round(this._rgb[0]),Math.round(this._rgb[1]),Math.round(this._rgb[2]),this._rgb[3]]:this._rgb.slice(0)},vd.push({p:3,test:function(t){var e;return e=Lf(arguments),"array"===Rf(e)&&3===e.length?"rgb":4===e.length&&"number"===Rf(e[3])&&e[3]>=0&&e[3]<=1?"rgb":void 0}}),Fd=function(t){var e,i,r,n,o,a;if(t.match(/^#?([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/))return 4!==t.length&&7!==t.length||(t=t.substr(1)),3===t.length&&(t=(t=t.split(""))[0]+t[0]+t[1]+t[1]+t[2]+t[2]),a=parseInt(t,16),n=a>>16,r=a>>8&255,i=255&a,[n,r,i,1];if(t.match(/^#?([A-Fa-f0-9]{8})$/))return 9===t.length&&(t=t.substr(1)),a=parseInt(t,16),n=a>>24&255,r=a>>16&255,i=a>>8&255,e=Pf((255&a)/255*100)/100,[n,r,i,e];if(null!=bd.css&&(o=bd.css(t)))return o;throw"unknown color: "+t},ff=function(t,e){var i,r,n,o,a,s,c;return null==e&&(e="rgb"),a=t[0],n=t[1],r=t[2],i=t[3],a=Math.round(a),n=Math.round(n),r=Math.round(r),c=a<<16|n<<8|r,s="000000"+c.toString(16),s=s.substr(s.length-6),o="0"+Pf(255*i).toString(16),o=o.substr(o.length-2),"#"+function(){switch(e.toLowerCase()){case"rgba":return s+o;case"argb":return o+s;default:return s}}()},bd.hex=function(t){return Fd(t)},Td.hex=function(){return function(t,e,i){i.prototype=t.prototype;var r=new i,n=t.apply(r,e);return Object(n)===n?n:r}(ld,Ff.call(arguments).concat(["hex"]),function(){})},ld.prototype.hex=function(t){return null==t&&(t="rgb"),ff(this._rgb,t)},vd.push({p:4,test:function(t){if(1===arguments.length&&"string"===Rf(t))return"hex"}}),jd=function(){var t,e,i,r,n,o,a,s,c,u,l,h,p,d;if(t=Lf(arguments),n=t[0],l=t[1],a=t[2],0===l)c=r=e=255*a;else{for(d=[0,0,0],i=[0,0,0],h=2*a-(p=a<.5?a*(1+l):a+l-a*l),n/=360,d[0]=n+1/3,d[1]=n,d[2]=n-1/3,o=s=0;s<=2;o=++s)d[o]<0&&(d[o]+=1),d[o]>1&&(d[o]-=1),6*d[o]<1?i[o]=h+6*(p-h)*d[o]:2*d[o]<1?i[o]=p:3*d[o]<2?i[o]=h+(p-h)*(2/3-d[o])*6:i[o]=h;c=(u=[Pf(255*i[0]),Pf(255*i[1]),Pf(255*i[2])])[0],r=u[1],e=u[2]}return t.length>3?[c,r,e,t[3]]:[c,r,e]},gf=function(t,e,i){var r,n,o,a,s;return void 0!==t&&t.length>=3&&(t=(a=t)[0],e=a[1],i=a[2]),t/=255,e/=255,i/=255,o=Math.min(t,e,i),of=Math.max(t,e,i),n=(of+o)/2,of===o?(s=0,r=Number.NaN):s=n<.5?(of-o)/(of+o):(of-o)/(2-of-o),t===of?r=(e-i)/(of-o):e===of?r=2+(i-t)/(of-o):i===of&&(r=4+(t-e)/(of-o)),(r*=60)<0&&(r+=360),[r,s,n]},Td.hsl=function(){return function(t,e,i){i.prototype=t.prototype;var r=new i,n=t.apply(r,e);return Object(n)===n?n:r}(ld,Ff.call(arguments).concat(["hsl"]),function(){})},bd.hsl=jd,ld.prototype.hsl=function(){return gf(this._rgb)},Vd=function(){var t,e,i,r,n,o,a,s,c,u,l,h,p,d,f,m,g,v;if(t=Lf(arguments),n=t[0],m=t[1],v=t[2],v*=255,0===m)c=r=e=v;else switch(360===n&&(n=0),n>360&&(n-=360),n<0&&(n+=360),n/=60,o=kd(n),i=n-o,a=v*(1-m),s=v*(1-m*i),g=v*(1-m*(1-i)),o){case 0:c=(u=[v,g,a])[0],r=u[1],e=u[2];break;case 1:c=(l=[s,v,a])[0],r=l[1],e=l[2];break;case 2:c=(h=[a,v,g])[0],r=h[1],e=h[2];break;case 3:c=(p=[a,s,v])[0],r=p[1],e=p[2];break;case 4:c=(d=[g,a,v])[0],r=d[1],e=d[2];break;case 5:c=(f=[v,a,s])[0],r=f[1],e=f[2]}return[c,r,e,t.length>3?t[3]:1]},vf=function(){var t,e,i,r,n,o,a,s,c;return a=Lf(arguments),o=a[0],i=a[1],t=a[2],n=Math.min(o,i,t),of=Math.max(o,i,t),e=of-n,c=of/255,0===of?(r=Number.NaN,s=0):(s=e/of,o===of&&(r=(i-t)/e),i===of&&(r=2+(t-o)/e),t===of&&(r=4+(o-i)/e),(r*=60)<0&&(r+=360)),[r,s,c]},Td.hsv=function(){return function(t,e,i){i.prototype=t.prototype;var r=new i,n=t.apply(r,e);return Object(n)===n?n:r}(ld,Ff.call(arguments).concat(["hsv"]),function(){})},bd.hsv=Vd,ld.prototype.hsv=function(){return vf(this._rgb)},cf=function(t){var e,i,r;return"number"===Rf(t)&&t>=0&&t<=16777215?(r=t>>16,i=t>>8&255,e=255&t,[r,i,e,1]):(console.warn("unknown num color: "+t),[0,0,0,1])},_f=function(){var t,e,i,r;return r=Lf(arguments),i=r[0],e=r[1],t=r[2],(i<<16)+(e<<8)+t},Td.num=function(t){return new ld(t,"num")},ld.prototype.num=function(t){return null==t&&(t="rgb"),_f(this._rgb,t)},bd.num=cf,vd.push({p:1,test:function(t){if(1===arguments.length&&"number"===Rf(t)&&t>=0&&t<=16777215)return"num"}}),Bd=function(){var t,e,i,r,n,o,a,s,c,u,l,h,p,d,f,m,g,v,y,b;if(i=Lf(arguments),s=i[0],n=i[1],e=i[2],n/=100,a=a/100*255,t=255*n,0===n)h=a=r=e;else switch(360===s&&(s=0),s>360&&(s-=360),s<0&&(s+=360),s/=60,c=kd(s),o=s-c,u=e*(1-n),l=u+t*(1-o),y=u+t*o,b=u+t,c){case 0:h=(p=[b,y,u])[0],a=p[1],r=p[2];break;case 1:h=(d=[l,b,u])[0],a=d[1],r=d[2];break;case 2:h=(f=[u,b,y])[0],a=f[1],r=f[2];break;case 3:h=(m=[u,l,b])[0],a=m[1],r=m[2];break;case 4:h=(g=[y,u,b])[0],a=g[1],r=g[2];break;case 5:h=(v=[b,u,l])[0],a=v[1],r=v[2]}return[h,a,r,i.length>3?i[3]:1]},df=function(){var t,e,i,r,n,o,a,s,c;return c=Lf(arguments),s=c[0],n=c[1],e=c[2],a=Math.min(s,n,e),of=Math.max(s,n,e),r=of-a,i=100*r/255,t=a/(255-r)*100,0===r?o=Number.NaN:(s===of&&(o=(n-e)/r),n===of&&(o=2+(e-s)/r),e===of&&(o=4+(s-n)/r),(o*=60)<0&&(o+=360)),[o,i,t]},Td.hcg=function(){return function(t,e,i){i.prototype=t.prototype;var r=new i,n=t.apply(r,e);return Object(n)===n?n:r}(ld,Ff.call(arguments).concat(["hcg"]),function(){})},bd.hcg=Bd,ld.prototype.hcg=function(){return df(this._rgb)},Ld=function(t){var e,i,r,n,o,a,s,c;if(t=t.toLowerCase(),null!=Td.colors&&Td.colors[t])return Fd(Td.colors[t]);if(o=t.match(/rgb\(\s*(\-?\d+),\s*(\-?\d+)\s*,\s*(\-?\d+)\s*\)/)){for(s=o.slice(1,4),n=a=0;a<=2;n=++a)s[n]=+s[n];s[3]=1}else if(o=t.match(/rgba\(\s*(\-?\d+),\s*(\-?\d+)\s*,\s*(\-?\d+)\s*,\s*([01]|[01]?\.\d+)\)/))for(s=o.slice(1,5),n=c=0;c<=3;n=++c)s[n]=+s[n];else if(o=t.match(/rgb\(\s*(\-?\d+(?:\.\d+)?)%,\s*(\-?\d+(?:\.\d+)?)%\s*,\s*(\-?\d+(?:\.\d+)?)%\s*\)/)){for(s=o.slice(1,4),n=e=0;e<=2;n=++e)s[n]=Pf(2.55*s[n]);s[3]=1}else if(o=t.match(/rgba\(\s*(\-?\d+(?:\.\d+)?)%,\s*(\-?\d+(?:\.\d+)?)%\s*,\s*(\-?\d+(?:\.\d+)?)%\s*,\s*([01]|[01]?\.\d+)\)/)){for(s=o.slice(1,5),n=i=0;i<=2;n=++i)s[n]=Pf(2.55*s[n]);s[3]=+s[3]}else(o=t.match(/hsl\(\s*(\-?\d+(?:\.\d+)?),\s*(\-?\d+(?:\.\d+)?)%\s*,\s*(\-?\d+(?:\.\d+)?)%\s*\)/))?((r=o.slice(1,4))[1]*=.01,r[2]*=.01,(s=jd(r))[3]=1):(o=t.match(/hsla\(\s*(\-?\d+(?:\.\d+)?),\s*(\-?\d+(?:\.\d+)?)%\s*,\s*(\-?\d+(?:\.\d+)?)%\s*,\s*([01]|[01]?\.\d+)\)/))&&((r=o.slice(1,4))[1]*=.01,r[2]*=.01,(s=jd(r))[3]=+o[4]);return s},pf=function(t){var e;return"rgb"==(e=t[3]<1?"rgba":"rgb")?e+"("+t.slice(0,3).map(Pf).join(",")+")":"rgba"===e?e+"("+t.slice(0,3).map(Pf).join(",")+","+t[3]+")":void 0},Mf=function(t){return Pf(100*t)/100},Ud=function(t,e){var i;return i=e<1?"hsla":"hsl",t[0]=Mf(t[0]||0),t[1]=Mf(100*t[1])+"%",t[2]=Mf(100*t[2])+"%","hsla"===i&&(t[3]=e),i+"("+t.join(",")+")"},bd.css=function(t){return Ld(t)},Td.css=function(){return function(t,e,i){i.prototype=t.prototype;var r=new i,n=t.apply(r,e);return Object(n)===n?n:r}(ld,Ff.call(arguments).concat(["css"]),function(){})},ld.prototype.css=function(t){return null==t&&(t="rgb"),"rgb"===t.slice(0,3)?pf(this._rgb):"hsl"===t.slice(0,3)?Ud(this.hsl(),this.alpha()):void 0},bd.named=function(t){return Fd(Of[t])},vd.push({p:5,test:function(t){if(1===arguments.length&&null!=Of[t])return"named"}}),ld.prototype.name=function(t){var e,i;arguments.length&&(Of[t]&&(this._rgb=Fd(Of[t])),this._rgb[3]=1),e=this.hex();for(i in Of)if(e===Of[i])return i;return e},Kd=function(){var t,e,i,r;return r=Lf(arguments),i=r[0],t=r[1],e=r[2],e*=hd,[i,Rd(e)*t,Tf(e)*t]},Qd=function(){var t,e,i,r,n,o,a,s,c,u,l;return i=Lf(arguments),s=i[0],n=i[1],a=i[2],u=Kd(s,n,a),t=u[0],e=u[1],r=u[2],l=Yd(t,e,r),c=l[0],o=l[1],r=l[2],[c,o,r,i.length>3?i[3]:1]},qd=function(){var t,e,i,r,n,o;return o=Lf(arguments),n=o[0],t=o[1],e=o[2],i=Cf(t*t+e*e),r=(wd(e,t)*md+360)%360,0===Pf(1e4*i)&&(r=Number.NaN),[n,i,r]},bf=function(){var t,e,i,r,n,o,a;return o=Lf(arguments),n=o[0],i=o[1],e=o[2],a=yf(n,i,e),r=a[0],t=a[1],e=a[2],qd(r,t,e)},Td.lch=function(){var t;return t=Lf(arguments),new ld(t,"lch")},Td.hcl=function(){var t;return t=Lf(arguments),new ld(t,"hcl")},bd.lch=Qd,bd.hcl=function(){var t,e,i,r;return r=Lf(arguments),e=r[0],t=r[1],i=r[2],Qd([i,t,e])},ld.prototype.lch=function(){return bf(this._rgb)},ld.prototype.hcl=function(){return bf(this._rgb).reverse()},hf=function(t){var e,i,r,n,o,a,s,c,u;return null==t&&(t="rgb"),c=Lf(arguments),s=c[0],n=c[1],e=c[2],s/=255,n/=255,e/=255,o=1-Math.max(s,Math.max(n,e)),r=o<1?1/(1-o):0,i=(1-s-o)*r,a=(1-n-o)*r,u=(1-e-o)*r,[i,a,u,o]},Id=function(){var t,e,i,r,n,o,a,s,c;return e=Lf(arguments),r=e[0],a=e[1],c=e[2],o=e[3],t=e.length>4?e[4]:1,1===o?[0,0,0,t]:(s=r>=1?0:255*(1-r)*(1-o),n=a>=1?0:255*(1-a)*(1-o),i=c>=1?0:255*(1-c)*(1-o),[s,n,i,t])},bd.cmyk=function(){return Id(Lf(arguments))},Td.cmyk=function(){return function(t,e,i){i.prototype=t.prototype;var r=new i,n=t.apply(r,e);return Object(n)===n?n:r}(ld,Ff.call(arguments).concat(["cmyk"]),function(){})},ld.prototype.cmyk=function(){return hf(this._rgb)},bd.gl=function(){var t,e,i,r,n;for(r=function(){var t,i;t=Lf(arguments),i=[];for(e in t)n=t[e],i.push(n);return i}.apply(this,arguments),t=i=0;i<=2;t=++i)r[t]*=255;return r},Td.gl=function(){return function(t,e,i){i.prototype=t.prototype;var r=new i,n=t.apply(r,e);return Object(n)===n?n:r}(ld,Ff.call(arguments).concat(["gl"]),function(){})},ld.prototype.gl=function(){var t;return t=this._rgb,[t[0]/255,t[1]/255,t[2]/255,t[3]]},xf=function(t,e,i){var r;return r=Lf(arguments),t=r[0],e=r[1],i=r[2],t=rf(t),e=rf(e),i=rf(i),.2126*t+.7152*e+.0722*i},rf=function(t){return(t/=255)<=.03928?t/12.92:lf((t+.055)/1.055,2.4)},xd=[],Gd=function(t,e,i,r){var n,o,a,s;for(null==i&&(i=.5),null==r&&(r="rgb"),"object"!==Rf(t)&&(t=Td(t)),"object"!==Rf(e)&&(e=Td(e)),a=0,o=xd.length;a<o;a++)if(n=xd[a],r===n[0]){s=n[1](t,e,i,r);break}if(null==s)throw"color mode "+r+" is not supported";return s.alpha(t.alpha()+i*(e.alpha()-t.alpha()))},Td.interpolate=Gd,ld.prototype.interpolate=function(t,e,i){return Gd(this,t,e,i)},Td.mix=Gd,ld.prototype.mix=ld.prototype.interpolate,Xd=function(t,e,i,r){var n,o;return n=t._rgb,o=e._rgb,new ld(n[0]+i*(o[0]-n[0]),n[1]+i*(o[1]-n[1]),n[2]+i*(o[2]-n[2]),r)},xd.push(["rgb",Xd]),ld.prototype.luminance=function(t,e){var i,r,n,o;return null==e&&(e="rgb"),arguments.length?(0===t?this._rgb=[0,0,0,this._rgb[3]]:1===t?this._rgb=[255,255,255,this._rgb[3]]:(r=1e-7,n=20,o=function(i,a){var s,c;return c=i.interpolate(a,.5,e),s=c.luminance(),Math.abs(t-s)<r||!n--?c:s>t?o(i,c):o(c,a)},i=xf(this._rgb),this._rgb=(i>t?o(Td("black"),this):o(this,Td("white"))).rgba()),this):xf(this._rgb)},If=function(t){var e,i,r,n;return(n=t/100)<66?(r=255,i=-155.25485562709179-.44596950469579133*(i=n-2)+104.49216199393888*ef(i),e=n<20?0:.8274096064007395*(e=n-10)-254.76935184120902+115.67994401066147*ef(e)):(r=351.97690566805693+.114206453784165*(r=n-55)-40.25366309332127*ef(r),i=325.4494125711974+.07943456536662342*(i=n-50)-28.0852963507957*ef(i),e=255),[r,i,e]},wf=function(){var t,e,i,r,n,o,a;for(r=(n=Lf(arguments))[0],n[1],t=n[2],i=1e3,e=4e4,.4;e-i>.4;)(o=If(a=.5*(e+i)))[2]/o[0]>=t/r?e=a:i=a;return Pf(a)},Td.temperature=Td.kelvin=function(){return function(t,e,i){i.prototype=t.prototype;var r=new i,n=t.apply(r,e);return Object(n)===n?n:r}(ld,Ff.call(arguments).concat(["temperature"]),function(){})},bd.temperature=bd.kelvin=bd.K=If,ld.prototype.temperature=function(){return wf(this._rgb)},ld.prototype.kelvin=ld.prototype.temperature,Td.contrast=function(t,e){var i,r,n,o;return"string"!==(n=Rf(t))&&"number"!==n||(t=new ld(t)),"string"!==(o=Rf(e))&&"number"!==o||(e=new ld(e)),i=t.luminance(),r=e.luminance(),i>r?(i+.05)/(r+.05):(r+.05)/(i+.05)},Td.distance=function(t,e,i){var r,n,o,a,s,c,u;null==i&&(i="lab"),"string"!==(s=Rf(t))&&"number"!==s||(t=new ld(t)),"string"!==(c=Rf(e))&&"number"!==c||(e=new ld(e)),o=t.get(i),a=e.get(i),u=0;for(n in o)u+=(r=(o[n]||0)-(a[n]||0))*r;return Math.sqrt(u)},Td.deltaE=function(t,e,i,r){var n,o,a,s,c,u,l,h,p,d,f,m,g,v,y,b,x,_,w,S,A,M,P,E,T,C,I;for(null==i&&(i=1),null==r&&(r=1),"string"!==(x=Rf(t))&&"number"!==x||(t=new ld(t)),"string"!==(_=Rf(e))&&"number"!==_||(e=new ld(e)),n=(w=t.lab())[0],a=w[1],c=w[2],o=(S=e.lab())[0],s=S[1],u=S[2],l=Cf(a*a+c*c),h=Cf(s*s+u*u),P=n<16?.511:.040975*n/(1+.01765*n),A=.0638*l/(1+.0131*l)+.638,b=l<1e-6?0:180*wd(c,a)/dd;b<0;)b+=360;for(;b>=360;)b-=360;return E=b>=164&&b<=345?.56+_d(.2*Rd(dd*(b+168)/180)):.36+_d(.4*Rd(dd*(b+35)/180)),p=l*l*l*l,y=Cf(p/(p+1900)),M=A*(y*E+1-y),v=n-o,g=l-h,f=a-s,m=c-u,d=f*f+m*m-g*g,T=v/(i*P),C=g/(r*A),I=M,Cf(T*T+C*C+d/(I*I))},ld.prototype.get=function(t){var e,i,r,n,o,a;return r=this,o=t.split("."),n=o[0],e=o[1],a=r[n](),e?(i=n.indexOf(e))>-1?a[i]:console.warn("unknown channel "+e+" in mode "+n):a},ld.prototype.set=function(t,e){var i,r,n,o,a,s;if(n=this,a=t.split("."),o=a[0],i=a[1])if(s=n[o](),(r=o.indexOf(i))>-1)if("string"===Rf(e))switch(e.charAt(0)){case"+":case"-":s[r]+=+e;break;case"*":s[r]*=+e.substr(1);break;case"/":s[r]/=+e.substr(1);break;default:s[r]=+e}else s[r]=e;else console.warn("unknown channel "+i+" in mode "+o);else s=e;return Td(s,o).alpha(n.alpha())},ld.prototype.clipped=function(){return this._rgb._clipped||!1},ld.prototype.alpha=function(t){return arguments.length?Td.rgb([this._rgb[0],this._rgb[1],this._rgb[2],t]):this._rgb[3]},ld.prototype.darken=function(t){var e,i;return null==t&&(t=1),i=this,e=i.lab(),e[0]-=pd.Kn*t,Td.lab(e).alpha(i.alpha())},ld.prototype.brighten=function(t){return null==t&&(t=1),this.darken(-t)},ld.prototype.darker=ld.prototype.darken,ld.prototype.brighter=ld.prototype.brighten,ld.prototype.saturate=function(t){var e,i;return null==t&&(t=1),i=this,e=i.lch(),e[1]+=t*pd.Kn,e[1]<0&&(e[1]=0),Td.lch(e).alpha(i.alpha())},ld.prototype.desaturate=function(t){return null==t&&(t=1),this.saturate(-t)},ld.prototype.premultiply=function(){var t,e;return e=this.rgb(),t=this.alpha(),Td(e[0]*t,e[1]*t,e[2]*t,t)},Md=function(t){return function(e,i){var r,n;return r=Td(i).rgb(),n=Td(e).rgb(),Td(t(r,n),"rgb")}},Nd=function(t){return function(e,i){var r,n,o;for(o=[],r=n=0;n<=3;r=++n)o[r]=t(e[r],i[r]);return o}},sf=function(t,e){return t},af=function(t,e){return t*e/255},Od=function(t,e){return t>e?e:t},Jd=function(t,e){return t>e?t:e},Ef=function(t,e){return 255*(1-(1-t/255)*(1-e/255))},uf=function(t,e){return e<128?2*t*e/255:255*(1-2*(1-t/255)*(1-e/255))},Ed=function(t,e){return 255*(1-(1-e/255)/(t/255))},Dd=function(t,e){return 255===t?255:(t=e/255*255/(1-t/255))>255?255:t},(Ad=function(t,e,i){if(!Ad[i])throw"unknown blend mode "+i;return Ad[i](t,e)}).normal=Md(Nd(sf)),Ad.multiply=Md(Nd(af)),Ad.screen=Md(Nd(Ef)),Ad.overlay=Md(Nd(uf)),Ad.darken=Md(Nd(Od)),Ad.lighten=Md(Nd(Jd)),Ad.dodge=Md(Nd(Dd)),Ad.burn=Md(Nd(Ed)),Td.blend=Ad,Td.analyze=function(t){var e,i,r,n;for(r={min:Number.MAX_VALUE,max:-1*Number.MAX_VALUE,sum:0,values:[],count:0},i=0,e=t.length;i<e;i++)null==(n=t[i])||isNaN(n)||(r.values.push(n),r.sum+=n,n<r.min&&(r.min=n),n>r.max&&(r.max=n),r.count+=1);return r.domain=[r.min,r.max],r.limits=function(t,e){return Td.limits(r,t,e)},r},Td.scale=function(t,e){var i,r,n,o,a,s,c,u,l,h,p,d,f,m,g,v,y,b,x,_;return u="rgb",l=Td("#ccc"),f=0,a=[0,1],d=[],p=[0,0],i=!1,n=[],h=!1,c=0,s=1,o=!1,r={},m=!0,x=function(t){var e,i,r,o,a,s;if(null==t&&(t=["#fff","#000"]),null!=t&&"string"===Rf(t)&&null!=Td.brewer&&(t=Td.brewer[t]||Td.brewer[t.toLowerCase()]||t),"array"===Rf(t)){for(e=r=0,o=(t=t.slice(0)).length-1;0<=o?r<=o:r>=o;e=0<=o?++r:--r)i=t[e],"string"===Rf(i)&&(t[e]=Td(i));for(d.length=0,e=s=0,a=t.length-1;0<=a?s<=a:s>=a;e=0<=a?++s:--s)d.push(e/(t.length-1))}return b(),n=t},v=function(t){var e,r;if(null!=i){for(r=i.length-1,e=0;e<r&&t>=i[e];)e++;return e-1}return 0},_=function(t){return t},y=function(t,e){var o,a,h,f,g,y,b;if(null==e&&(e=!1),isNaN(t))return l;if(e?b=t:i&&i.length>2?(b=v(t)/(i.length-2),b=p[0]+b*(1-p[0]-p[1])):s!==c?(b=(t-c)/(s-c),b=p[0]+b*(1-p[0]-p[1]),b=Math.min(1,Math.max(0,b))):b=1,e||(b=_(b)),h=Math.floor(1e4*b),m&&r[h])o=r[h];else{if("array"===Rf(n))for(a=f=0,y=d.length-1;0<=y?f<=y:f>=y;a=0<=y?++f:--f){if(g=d[a],b<=g){o=n[a];break}if(b>=g&&a===d.length-1){o=n[a];break}if(b>g&&b<d[a+1]){b=(b-g)/(d[a+1]-g),o=Td.interpolate(n[a],n[a+1],b,u);break}}else"function"===Rf(n)&&(o=n(b));m&&(r[h]=o)}return o},b=function(){return r={}},x(t),g=function(t){var e;return e=Td(y(t)),h&&e[h]?e[h]():e},g.classes=function(t){var e;return null!=t?("array"===Rf(t)?(i=t,a=[t[0],t[t.length-1]]):(e=Td.analyze(a),i=0===t?[e.min,e.max]:Td.limits(e,"e",t)),g):i},g.domain=function(t){var e,i,r,o,u,l,h;if(!arguments.length)return a;if(c=t[0],s=t[t.length-1],d=[],r=n.length,t.length===r&&c!==s)for(u=0,o=t.length;u<o;u++)i=t[u],d.push((i-c)/(s-c));else for(e=h=0,l=r-1;0<=l?h<=l:h>=l;e=0<=l?++h:--h)d.push(e/(r-1));return a=[c,s],g},g.mode=function(t){return arguments.length?(u=t,b(),g):u},g.range=function(t,e){return x(t),g},g.out=function(t){return h=t,g},g.spread=function(t){return arguments.length?(f=t,g):f},g.correctLightness=function(t){return null==t&&(t=!0),o=t,b(),_=o?function(t){var e,i,r,n,o,a,s,c,u;for(e=y(0,!0).lab()[0],i=y(1,!0).lab()[0],s=e>i,r=y(t,!0).lab()[0],n=r-(o=e+(i-e)*t),c=0,u=1,a=20;Math.abs(n)>.01&&a-- >0;)s&&(n*=-1),n<0?(c=t,t+=.5*(u-t)):(u=t,t+=.5*(c-t)),r=y(t,!0).lab()[0],n=r-o;return t}:function(t){return t},g},g.padding=function(t){return null!=t?("number"===Rf(t)&&(t=[t,t]),p=t,g):p},g.colors=function(e,r){var o,s,c,u,l,h,p;if(null==r&&(r="hex"),0===arguments.length)return n.map(function(t){return t[r]()});if(e)return 1===e?g(.5)[r]():(s=a[0],o=a[1]-s,function(){l=[];for(var t=0;0<=e?t<e:t>e;0<=e?t++:t--)l.push(t);return l}.apply(this).map(function(t){return g(s+t/(e-1)*o)[r]()}));if(t=[],h=[],i&&i.length>2)for(c=p=1,u=i.length;1<=u?p<u:p>u;c=1<=u?++p:--p)h.push(.5*(i[c-1]+i[c]));else h=a;return h.map(function(t){return g(t)[r]()})},g.cache=function(t){return null!=t?m=t:m},g},null==Td.scales&&(Td.scales={}),Td.scales.cool=function(){return Td.scale([Td.hsl(180,1,.9),Td.hsl(250,.7,.4)])},Td.scales.hot=function(){return Td.scale(["#000","#f00","#ff0","#fff"],[0,.25,.75,1]).mode("rgb")},Td.analyze=function(t,e,i){var r,n,o,a,s,c;if(s={min:Number.MAX_VALUE,max:-1*Number.MAX_VALUE,sum:0,values:[],count:0},null==i&&(i=function(){return!0}),r=function(t){null==t||isNaN(t)||(s.values.push(t),s.sum+=t,t<s.min&&(s.min=t),t>s.max&&(s.max=t),s.count+=1)},c=function(t,n){if(i(t,n))return r(null!=e&&"function"===Rf(e)?e(t):null!=e&&"string"===Rf(e)||"number"===Rf(e)?t[e]:t)},"array"===Rf(t))for(a=0,o=t.length;a<o;a++)c(t[a]);else for(n in t)c(t[n],n);return s.domain=[s.min,s.max],s.limits=function(t,e){return Td.limits(s,t,e)},s},Td.limits=function(t,e,i){var r,n,o,a,s,c,u,l,h,p,d,f,m,g,v,y,b,x,_,w,S,A,M,P,E,T,C,I,R,L,O,D,N,k,B,F,z,U,j,V,G,$,H,W,X,q,Y,Z,K,Q,J,tt,et,it,rt;if(null==e&&(e="equal"),null==i&&(i=7),"array"===Rf(t)&&(t=Td.analyze(t)),E=t.min,of=t.max,it=t.values.sort(function(t,e){return t-e}),1===i)return[E,of];if(M=[],"c"===e.substr(0,1)&&(M.push(E),M.push(of)),"e"===e.substr(0,1)){for(M.push(E),w=O=1,B=i-1;1<=B?O<=B:O>=B;w=1<=B?++O:--O)M.push(E+w/i*(of-E));M.push(of)}else if("l"===e.substr(0,1)){if(E<=0)throw"Logarithmic scales are only possible for values > 0";for(T=Math.LOG10E*ef(E),P=Math.LOG10E*ef(of),M.push(E),w=rt=1,F=i-1;1<=F?rt<=F:rt>=F;w=1<=F?++rt:--rt)M.push(lf(10,T+w/i*(P-T)));M.push(of)}else if("q"===e.substr(0,1)){for(M.push(E),w=r=1,$=i-1;1<=$?r<=$:r>=$;w=1<=$?++r:--r)D=(it.length-1)*w/i,(N=kd(D))===D?M.push(it[N]):(k=D-N,M.push(it[N]*(1-k)+it[N+1]*k));M.push(of)}else if("k"===e.substr(0,1)){for(I=it.length,g=new Array(I),x=new Array(i),Q=!0,R=0,y=null,(y=[]).push(E),w=n=1,H=i-1;1<=H?n<=H:n>=H;w=1<=H?++n:--n)y.push(E+w/i*(of-E));for(y.push(of);Q;){for(S=o=0,W=i-1;0<=W?o<=W:o>=W;S=0<=W?++o:--o)x[S]=0;for(w=a=0,X=I-1;0<=X?a<=X:a>=X;w=0<=X?++a:--a){for(et=it[w],C=Number.MAX_VALUE,S=s=0,q=i-1;0<=q?s<=q:s>=q;S=0<=q?++s:--s)(_=_d(y[S]-et))<C&&(C=_,v=S);x[v]++,g[w]=v}for(L=new Array(i),S=c=0,Y=i-1;0<=Y?c<=Y:c>=Y;S=0<=Y?++c:--c)L[S]=null;for(w=u=0,Z=I-1;0<=Z?u<=Z:u>=Z;w=0<=Z?++u:--u)null===L[b=g[w]]?L[b]=it[w]:L[b]+=it[w];for(S=l=0,K=i-1;0<=K?l<=K:l>=K;S=0<=K?++l:--l)L[S]*=1/x[S];for(Q=!1,S=h=0,z=i-1;0<=z?h<=z:h>=z;S=0<=z?++h:--h)if(L[S]!==y[w]){Q=!0;break}y=L,++R>200&&(Q=!1)}for(A={},S=p=0,U=i-1;0<=U?p<=U:p>=U;S=0<=U?++p:--p)A[S]=[];for(w=d=0,j=I-1;0<=j?d<=j:d>=j;w=0<=j?++d:--d)A[b=g[w]].push(it[w]);for(J=[],S=f=0,V=i-1;0<=V?f<=V:f>=V;S=0<=V?++f:--f)J.push(A[S][0]),J.push(A[S][A[S].length-1]);for(J=J.sort(function(t,e){return t-e}),M.push(J[0]),w=m=1,G=J.length-1;m<=G;w=m+=2)tt=J[w],isNaN(tt)||-1!==M.indexOf(tt)||M.push(tt)}return M},zd=function(t,e,i){var r,n,o,a;return r=Lf(arguments),t=r[0],e=r[1],i=r[2],isNaN(t)&&(t=0),(t/=360)<1/3?o=1-((n=(1-e)/3)+(a=(1+e*Rd(gd*t)/Rd(fd-gd*t))/3)):t<2/3?n=1-((a=(1-e)/3)+(o=(1+e*Rd(gd*(t-=1/3))/Rd(fd-gd*t))/3)):a=1-((o=(1-e)/3)+(n=(1+e*Rd(gd*(t-=2/3))/Rd(fd-gd*t))/3)),a=tf(i*a*3),o=tf(i*o*3),n=tf(i*n*3),[255*a,255*o,255*n,r.length>3?r[3]:1]},mf=function(){var t,e,i,r,n,o,a,s;return a=Lf(arguments),o=a[0],e=a[1],t=a[2],gd=2*Math.PI,o/=255,e/=255,t/=255,n=Math.min(o,e,t),r=(o+e+t)/3,0===(s=1-n/r)?i=0:(i=(o-e+(o-t))/2,i/=Math.sqrt((o-e)*(o-e)+(o-t)*(e-t)),i=Math.acos(i),t>e&&(i=gd-i),i/=gd),[360*i,s,r]},Td.hsi=function(){return function(t,e,i){i.prototype=t.prototype;var r=new i,n=t.apply(r,e);return Object(n)===n?n:r}(ld,Ff.call(arguments).concat(["hsi"]),function(){})},bd.hsi=zd,ld.prototype.hsi=function(){return mf(this._rgb)},$d=function(t,e,i,r){var n,o,a,s,c,u,l,h,p,d,f;return"hsl"===r?(d=t.hsl(),f=e.hsl()):"hsv"===r?(d=t.hsv(),f=e.hsv()):"hcg"===r?(d=t.hcg(),f=e.hcg()):"hsi"===r?(d=t.hsi(),f=e.hsi()):"lch"!==r&&"hcl"!==r||(r="hcl",d=t.hcl(),f=e.hcl()),"h"===r.substr(0,1)&&(o=d[0],h=d[1],c=d[2],a=f[0],p=f[1],u=f[2]),isNaN(o)||isNaN(a)?isNaN(o)?isNaN(a)?n=Number.NaN:(n=a,1!==c&&0!==c||"hsv"===r||(l=p)):(n=o,1!==u&&0!==u||"hsv"===r||(l=h)):n=o+i*(a>o&&a-o>180?a-(o+360):a<o&&o-a>180?a+360-o:a-o),null==l&&(l=h+i*(p-h)),s=c+i*(u-c),Td[r](n,l,s)},Wd=function(t,e,i,r){var n,o;return n=t.num(),o=e.num(),Td.num(n+(o-n)*i,"num")},(xd=xd.concat(function(){var t,e,i,r;for(r=[],e=0,t=(i=["hsv","hsl","hsi","hcl","lch","hcg"]).length;e<t;e++)nf=i[e],r.push([nf,$d]);return r}())).push(["num",Wd]),Hd=function(t,e,i,r){var n,o;return n=t.lab(),o=e.lab(),new ld(n[0]+i*(o[0]-n[0]),n[1]+i*(o[1]-n[1]),n[2]+i*(o[2]-n[2]),r)},xd.push(["lab",Hd]);var zf=Td,Uf=function(t){var e=t||{};this.scale=Nn(e.scale,"uniform"),this.mode=Nn(e.mode,"hcl"),this.domain=Nn(e.domain,[0,1]),this.value=new et(Nn(e.value,16777215)).getHex(),this.reverse=Nn(e.reverse,!1),this.structure=e.structure,this.volume=e.volume,this.surface=e.surface,this.structure&&(this.atomProxy=this.structure.getAtomProxy())};Uf.prototype.getScale=function(t){var e=t||{},i=Nn(e.scale,this.scale);"rainbow"===i?i=["red","orange","yellow","green","blue"]:"rwb"===i&&(i=["red","white","blue"]);var r=Nn(e.domain,this.domain);return this.reverse&&(r=r.slice().reverse()),zf.scale(i).mode(Nn(e.mode,this.mode)).domain(r).out("num")},Uf.prototype.colorToArray=function(t,e,i){return void 0===e&&(e=[]),void 0===i&&(i=0),e[i+0]=(t>>16&255)/255,e[i+1]=(t>>8&255)/255,e[i+2]=(255&t)/255,e},Uf.prototype.atomColorToArray=function(t,e,i){return this.colorToArray(this.atomColor(t),e,i)},Uf.prototype.bondColor=function(t,e){return this.atomProxy.index=e?t.atomIndex1:t.atomIndex2,this.atomColor(this.atomProxy)},Uf.prototype.bondColorToArray=function(t,e,i,r){return this.colorToArray(this.bondColor(t,e),i,r)},Uf.prototype.volumeColorToArray=function(t,e,i){return this.colorToArray(this.volumeColor(t),e,i)},Uf.prototype.positionColorToArray=function(t,e,i){return this.colorToArray(this.positionColor(t),e,i)},_o.prototype={active:!0,params:null,execute:function(t){var e,i;return this.active&&this._listener&&(i=this.params?this.params.concat(t):t,e=this._listener.apply(this.context,i),this._isOnce&&this.detach()),e},detach:function(){return this.isBound()?this._signal.remove(this._listener,this.context):null},isBound:function(){return!!this._signal&&!!this._listener},isOnce:function(){return this._isOnce},getListener:function(){return this._listener},getSignal:function(){return this._signal},_destroy:function(){delete this._signal,delete this._listener,delete this.context},toString:function(){return"[SignalBinding isOnce:"+this._isOnce+", isBound:"+this.isBound()+", active:"+this.active+"]"}},So.prototype={VERSION:"1.0.0",memorize:!1,_shouldPropagate:!0,active:!0,_registerListener:function(t,e,i,r){var n,o=this._indexOfListener(t,i);if(-1!==o){if((n=this._bindings[o]).isOnce()!==e)throw new Error("You cannot add"+(e?"":"Once")+"() then add"+(e?"Once":"")+"() the same listener without removing the relationship first.")}else n=new _o(this,t,e,i,r),this._addBinding(n);return this.memorize&&this._prevParams&&n.execute(this._prevParams),n},_addBinding:function(t){var e=this._bindings.length;do{--e}while(this._bindings[e]&&t._priority<=this._bindings[e]._priority);this._bindings.splice(e+1,0,t)},_indexOfListener:function(t,e){for(var i,r=this,n=this._bindings.length;n--;)if((i=r._bindings[n])._listener===t&&i.context===e)return n;return-1},has:function(t,e){return-1!==this._indexOfListener(t,e)},add:function(t,e,i){return wo(t,"add"),this._registerListener(t,!1,e,i)},addOnce:function(t,e,i){return wo(t,"addOnce"),this._registerListener(t,!0,e,i)},remove:function(t,e){wo(t,"remove");var i=this._indexOfListener(t,e);return-1!==i&&(this._bindings[i]._destroy(),this._bindings.splice(i,1)),t},removeAll:function(){for(var t=this,e=this._bindings.length;e--;)t._bindings[e]._destroy();this._bindings.length=0},getNumListeners:function(){return this._bindings.length},halt:function(){this._shouldPropagate=!1},dispatch:function(t){if(this.active){var e,i=Array.prototype.slice.call(arguments),r=this._bindings.length;if(this.memorize&&(this._prevParams=i),r){e=this._bindings.slice(),this._shouldPropagate=!0;do{r--}while(e[r]&&this._shouldPropagate&&!1!==e[r].execute(i))}}},forget:function(){this._prevParams=null},dispose:function(){this.removeAll(),delete this._bindings,delete this._prevParams},toString:function(){return"[Signal active:"+this.active+" numListeners:"+this.getNumListeners()+"]"}};var jf={PROTEIN:1,NUCLEIC:2,RNA:3,DNA:4,POLYMER:5,WATER:6,HELIX:7,SHEET:8,TURN:9,BACKBONE:10,SIDECHAIN:11,ALL:12,HETERO:13,ION:14,SACCHARIDE:15,SUGAR:15,BONDED:16,RING:17},Vf=["*","","ALL"],Gf=[jf.BACKBONE,jf.SIDECHAIN,jf.BONDED,jf.RING],$f=[jf.POLYMER,jf.WATER],Hf=["ALA","GLY","SER"],Wf=["CYS","SER","THR"],Xf=["ALA","ILE","LEU","MET","PHE","PRO","TRP","VAL"],qf=["PHE","TRP","TYR","HIS"],Yf=["ASN","GLN"],Zf=["ASP","GLU"],Kf=["ARG","HIS","LYS"],Qf=["ARG","ASP","GLU","HIS","LYS"],Jf=["ASN","ARG","ASP","CYS","GLY","GLN","GLU","HIS","LYS","SER","THR","TYR"],tm=["ALA","ILE","LEU","MET","PHE","PRO","TRP","VAL"],em=["HIS","PHE","PRO","TRP","TYR"],im=["ALA","GLY","ILE","LEU","VAL"],rm=function(t){this.signals={stringChanged:new So},this.setString(t)},nm={type:{configurable:!0}};nm.type.get=function(){return"selection"},rm.prototype.setString=function(t,e){if(void 0===t&&(t=this.string||""),t!==this.string){try{this.selection=Ao(t)}catch(t){this.selection={error:t.message}}var i=this.selection;this.string=t,this.test=Ro(i),this.residueTest=Lo(i),this.chainTest=Oo(i),this.modelTest=Do(i),this.atomOnlyTest=Ro(i,!0),this.residueOnlyTest=Lo(i,!0),this.chainOnlyTest=Oo(i,!0),this.modelOnlyTest=Do(i,!0),e||this.signals.stringChanged.dispatch(this.string)}},Object.defineProperties(rm.prototype,nm);var om=function(t){function e(e){var i=this;t.call(this,e);var r=e.dataList||[];this.colormakerList=[],this.selectionList=[],r.forEach(function(t){var e=t[0],r=t[1],n=t[2];void 0===n&&(n={}),_m.hasScheme(e)?Object.assign(n,{scheme:e,structure:i.structure}):Object.assign(n,{scheme:"uniform",value:new et(e).getHex()}),i.colormakerList.push(_m.getScheme(n)),i.selectionList.push(new rm(r))})}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.atomColor=function(t){for(var e=this,i=0,r=this.selectionList.length;i<r;++i)if(e.selectionList[i].test(t))return e.colormakerList[i].atomColor(t);return 16777215},e}(Uf),am={"":"",OrRd:"[S] Orange-Red",PuBu:"[S] Purple-Blue",BuPu:"[S] Blue-Purple",Oranges:"[S] Oranges",BuGn:"[S] Blue-Green",YlOrBr:"[S] Yellow-Orange-Brown",YlGn:"[S] Yellow-Green",Reds:"[S] Reds",RdPu:"[S] Red-Purple",Greens:"[S] Greens",YlGnBu:"[S] Yellow-Green-Blue",Purples:"[S] Purples",GnBu:"[S] Green-Blue",Greys:"[S] Greys",YlOrRd:"[S] Yellow-Orange-Red",PuRd:"[S] Purple-Red",Blues:"[S] Blues",PuBuGn:"[S] Purple-Blue-Green",Viridis:"[D] Viridis",Spectral:"[D] Spectral",RdYlGn:"[D] Red-Yellow-Green",RdBu:"[D] Red-Blue",PiYG:"[D] Pink-Yellowgreen",PRGn:"[D] Purplered-Green",RdYlBu:"[D] Red-Yellow-Blue",BrBG:"[D] Brown-Bluegreen",RdGy:"[D] Red-Grey",PuOr:"[D] Purple-Orange",Set1:"[Q] Set1",Set2:"[Q] Set2",Set3:"[Q] Set3",Dark2:"[Q] Dark2",Paired:"[Q] Paired",Pastel1:"[Q] Pastel1",Pastel2:"[Q] Pastel2",Accent:"[Q] Accent",rainbow:"[?] Rainbow",rwb:"[?] Red-White-Blue"},sm={"":"",rgb:"Red Green Blue",hsv:"Hue Saturation Value",hsl:"Hue Saturation Lightness",hsi:"Hue Saturation Intensity",lab:"CIE L*a*b*",hcl:"Hue Chroma Lightness"},cm=function(){this.schemes={},this.userSchemes={}};cm.prototype.getScheme=function(t){var e=((t||{}).scheme||"").toLowerCase();return new(e in this.schemes?this.schemes[e]:e in this.userSchemes?this.userSchemes[e]:Uf)(t)},cm.prototype.getSchemes=function(){var t={};return Object.keys(this.schemes).forEach(function(e){t[e]=e}),Object.keys(this.userSchemes).forEach(function(e){t[e]=e.split("|")[1]}),t},cm.prototype.getScales=function(){return am},cm.prototype.getModes=function(){return sm},cm.prototype.add=function(t,e){t=t.toLowerCase(),this.schemes[t]=e},cm.prototype.addScheme=function(t,e){return t instanceof Uf||(t=this._createScheme(t)),this._addUserScheme(t,e)},cm.prototype._addUserScheme=function(t,e){e=e||"";var i=(lo()+"|"+e).toLowerCase();return this.userSchemes[i]=t,i},cm.prototype.removeScheme=function(t){t=t.toLowerCase(),delete this.userSchemes[t]},cm.prototype._createScheme=function(t){var e=function(e){Uf.call(this,e),t.call(this,e)};return e.prototype=Uf.prototype,e.prototype.constructor=Uf,e},cm.prototype.addSelectionScheme=function(t,e){var i=function(e){function i(i){e.call(this,Object.assign({dataList:t},i))}return e&&(i.__proto__=e),i.prototype=Object.create(e&&e.prototype),i.prototype.constructor=i,i}(om);return this._addUserScheme(i,e)},cm.prototype.hasScheme=function(t){return(t=t.toLowerCase())in this.schemes||t in this.userSchemes};var um=function(t){function e(){t.call(this,"parser")}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.__hasObjName=function(t,e){var i=this.get(t);return i&&i.prototype.__objName===e},e.prototype.isTrajectory=function(t){return this.__hasObjName(t,"frames")},e.prototype.isStructure=function(t){return this.__hasObjName(t,"structure")},e.prototype.isVolume=function(t){return this.__hasObjName(t,"volume")},e.prototype.isSurface=function(t){return this.__hasObjName(t,"surface")},e.prototype.isBinary=function(t){var e=this.get(t);return e&&e.prototype.isBinary},e.prototype.isXml=function(t){var e=this.get(t);return e&&e.prototype.isXml},e.prototype.isJson=function(t){var e=this.get(t);return e&&e.prototype.isJson},e.prototype.getTrajectoryExtensions=function(){var t=this;return this.names.filter(function(e){return t.isTrajectory(e)})},e.prototype.getStructureExtensions=function(){var t=this;return this.names.filter(function(e){return t.isStructure(e)})},e.prototype.getVolumeExtensions=function(){var t=this;return this.names.filter(function(e){return t.isVolume(e)})},e.prototype.getSurfaceExtensions=function(){var t=this;return this.names.filter(function(e){return t.isSurface(e)})},e}(cd),lm=function(){this.activeWorkerCount=0,this._funcDict={},this._depsDict={},this._blobDict={}};lm.prototype.add=function(t,e,i){this._funcDict[t]=e,this._depsDict[t]=i},lm.prototype.get=function(t){return this._blobDict[t]||(this._blobDict[t]=Fo(this._funcDict[t],this._depsDict[t])),this._blobDict[t]};var hm=Fn(),pm=!1;try{var dm=Object.defineProperty({},"passive",{get:function(){pm=!0}});window.addEventListener("test",null,dm)}catch(t){}var fm="undefined"!=typeof window&&void 0!==window.orientation,mm=!1,gm=!1,vm={log:Function.prototype.bind.call(console.log,console),info:Function.prototype.bind.call(console.info,console),warn:Function.prototype.bind.call(console.warn,console),error:Function.prototype.bind.call(console.error,console),time:Function.prototype.bind.call(console.time,console),timeEnd:Function.prototype.bind.call(console.timeEnd,console)};t.Debug=function(t){return!!t&&("string"!=typeof t||/^1|true|t|yes|y$/i.test(t))}(Dn("debug"));var ym='<div style="display:flex;align-items:center;justify-content:center;height:100%;"><p style="padding:15px;text-align:center;">Your browser/graphics card does not seem to support <a target="_blank" href="https://en.wikipedia.org/wiki/WebGL">WebGL</a>.<br/><br/>Find out how to get it <a target="_blank" href="http://get.webgl.org/">here</a>.</p></div>',bm=["ngl","js"],xm=new lm,_m=new cm,wm=new cd("datasource"),Sm=new cd("representatation"),Am=new um,Mm=new cd("shader"),Pm=new cd("decompressor"),Em=new cd("component"),Tm=new cd("buffer"),Cm=new cd("picker"),Im=function(t,e){var i=e||{};this.compressed=Nn(i.compressed,!1),this.binary=Nn(i.binary,!1),this.json=Nn(i.json,!1),this.xml=Nn(i.xml,!1),this.src=t,this.chunkSize=10485760,this.newline="\n",this.__pointer=0,this.__partialLine="",this.__srcName&&(this[this.__srcName]=t)},Rm={type:{configurable:!0},__srcName:{configurable:!0}};Rm.type.get=function(){return""},Rm.__srcName.get=function(){},Im.prototype.isBinary=function(){return this.binary||this.compressed},Im.prototype.onload=function(){},Im.prototype.onprogress=function(){},Im.prototype.onerror=function(){},Im.prototype.read=function(){var t=this;return new Promise(function(e,i){try{t._read(function(i){var r=Pm.get(t.compressed);t.compressed&&r?t.data=r(i):((t.binary||t.compressed)&&i instanceof ArrayBuffer&&(i=new Uint8Array(i)),t.data=i),e(t.data)})}catch(t){i(t)}})},Im.prototype._read=function(t){t(this.src)},Im.prototype._chunk=function(t,e){return e=Math.min(this.data.length,e),0===t&&this.data.length===e?this.data:this.isBinary()?this.data.subarray(t,e):this.data.substring(t,e)},Im.prototype.chunk=function(t){var e=t+this.chunkSize;return this._chunk(t,e)},Im.prototype.peekLines=function(t){var e,i=this.data,r=i.length,n=this.isBinary()?this.newline.charCodeAt(0):this.newline,o=0;for(e=0;e<r&&(i[e]===n&&++o,o!==t);++e);var a=this._chunk(0,e+1);return this.chunkToLines(a,"",e>r).lines},Im.prototype.chunkCount=function(){return Math.floor(this.data.length/this.chunkSize)+1},Im.prototype.asText=function(){return this.isBinary()?qn(this.data):this.data},Im.prototype.chunkToLines=function(t,e,i){var r=this.newline;if(!this.isBinary()&&t.length===this.data.length)return{lines:t.split(r),partialLine:""};var n=[],o=this.isBinary()?qn(t):t,a=o.lastIndexOf(r);if(-1===a)e+=o;else{var s=e+o.substr(0,a);n=n.concat(s.split(r)),e=a===o.length-r.length?"":o.substr(a+r.length)}return i&&""!==e&&n.push(e),{lines:n,partialLine:e}},Im.prototype.nextChunk=function(){var t=this.__pointer;if(!(t>this.data.length))return this.__pointer+=this.chunkSize,this.chunk(t)},Im.prototype.nextChunkOfLines=function(){var t=this.nextChunk();if(void 0!==t){var e=this.__pointer>this.data.length,i=this.chunkToLines(t,this.__partialLine,e);return this.__partialLine=i.partialLine,i.lines}},Im.prototype.eachChunk=function(t){for(var e=this,i=this.chunkSize,r=this.data.length,n=this.chunkCount(),o=0;o<r;o+=i)t(e.chunk(o),Math.round(o/i),n)},Im.prototype.eachChunkOfLines=function(t){var e=this;this.eachChunk(function(i,r,n){var o=r===n+1,a=e.chunkToLines(i,e.__partialLine,o);e.__partialLine=a.partialLine,t(a.lines,r,n)})},Im.prototype.dispose=function(){delete this.src,this.__srcName&&delete this[this.__srcName]},Object.defineProperties(Im.prototype,Rm);var Lm=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={type:{configurable:!0},__srcName:{configurable:!0}};return i.type.get=function(){return"file"},i.__srcName.get=function(){return"file"},e.prototype._read=function(t){var e,i=this;if("function"==typeof importScripts){e=new window.FileReaderSync;var r;r=this.binary||this.compressed?e.readAsArrayBuffer(this.file):e.readAsText(this.file),t(r)}else(e=new window.FileReader).onload=function(e){t(e.target.result)},"function"==typeof this.onprogress&&(e.onprogress=function(t){i.onprogress(t)}),"function"==typeof this.onerror&&(e.onerror=function(t){i.onerror(t)}),this.binary||this.compressed?e.readAsArrayBuffer(this.file):e.readAsText(this.file)},Object.defineProperties(e.prototype,i),e}(Im),Om=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={type:{configurable:!0},__srcName:{configurable:!0}};return i.type.get=function(){return"network"},i.__srcName.get=function(){return"url"},e.prototype._read=function(t){var e=this.src;"function"==typeof importScripts&&"../"===e.substr(0,3)&&(e="../"+e);var i=new window.XMLHttpRequest;i.open("GET",e,!0),i.addEventListener("load",function(){if(200!==i.status&&304!==i.status&&0!==i.status)throw"function"==typeof this.onerror&&this.onerror(i.status),new Error("NetworkStreamer._read: status code "+i.status);try{t(i.response)}catch(t){this.onerror(t)}}.bind(this),!1),"function"==typeof this.onerror&&i.addEventListener("error",function(t){this.onerror(t)}.bind(this),!1),this.isBinary()?i.responseType="arraybuffer":this.json?i.responseType="json":this.xml?i.responseType="document":i.responseType="text",i.send(null)},Object.defineProperties(e.prototype,i),e}(Im),Dm=function(t,e){var i=Object.assign({},e);this.compressed=Nn(i.compressed,!1),this.binary=Nn(i.binary,Am.isBinary(i.ext)),this.name=Nn(i.name,""),this.ext=Nn(i.ext,""),this.dir=Nn(i.dir,""),this.path=Nn(i.path,""),this.protocol=Nn(i.protocol,""),this.params=e;var r={compressed:this.compressed,binary:this.binary,json:Am.isJson(this.ext),xml:Am.isXml(this.ext)};"undefined"!=typeof File&&t instanceof window.File||"undefined"!=typeof Blob&&t instanceof window.Blob?this.streamer=new Lm(t,r):this.streamer=new Om(t,r),"function"==typeof i.onProgress&&(this.streamer.onprogress=i.onprogress)};Dm.prototype.load=function(){return Promise.reject(new Error("not implemented"))};var Nm=function(t){function e(){t.apply(this,arguments)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.load=function(){return new(Am.get(this.ext))(this.streamer,this.params).parse()},e}(Dm),km=function(t,e,i){this.signals={elementAdded:new So,elementRemoved:new So,nameChanged:new So},this.name=e,this.path=i,this.dir=i.substring(0,i.lastIndexOf("/")+1);try{this.fn=new Function("stage","panel","__name__","__path__","__dir__",t)}catch(t){vm.error("Script compilation failed",t),this.fn=function(){}}},Bm={type:{configurable:!0}};Bm.type.get=function(){return"Script"},km.prototype.call=function(t){var e=this,i={add:function(){this.signals.elementAdded.dispatch(arguments)}.bind(this),remove:function(){this.signals.elementRemoved.dispatch(arguments)}.bind(this),setName:function(t){this.signals.nameChanged.dispatch(t)}.bind(this)};return new Promise(function(r,n){var o=[t,i,e.name,e.path,e.dir];try{e.fn.apply(null,o),r()}catch(t){vm.error("Script.fn",t),n(t)}})},Object.defineProperties(km.prototype,Bm);var Fm=function(t){function e(){t.apply(this,arguments)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.load=function(){var t=this;return this.streamer.read().then(function(){return new km(t.streamer.asText(),t.name,t.path)})},e}(Dm),zm=function(t){function e(){t.apply(this,arguments)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.load=function(){var t,e=this;return t=this.protocol?this.protocol+"://"+this.dir:this.dir,this.streamer.read().then(function(){var i=JSON.parse(e.streamer.asText()),r=[];return i.files.map(function(e){r.push(Vo(t+e,{ext:"text",useWorker:!1}))}),Promise.all(r).then(function(t){var r=t.reduce(function(t,e){return t+"\n\n"+e.data},"");return r+=i.source||"",new km(r,e.name,e.path)})})},e}(Dm),Um=function(){},jm={mimeType:{configurable:!0},defaultName:{configurable:!0},defaultExt:{configurable:!0}};jm.mimeType.get=function(){},jm.defaultName.get=function(){},jm.defaultExt.get=function(){},Um.prototype.getData=function(){},Um.prototype.getBlob=function(){return new window.Blob([this.getData()],{type:this.mimeType})},Um.prototype.download=function(t,e){t=Nn(t,this.defaultName),e=Nn(e,this.defaultExt),Un(this.getBlob(),t+"."+e)},Object.defineProperties(Um.prototype,jm);var Vm={not_string:/[^s]/,not_bool:/[^t]/,not_type:/[^T]/,not_primitive:/[^v]/,number:/[diefg]/,numeric_arg:/[bcdiefguxX]/,json:/[j]/,not_json:/[^j]/,text:/^[^\x25]+/,modulo:/^\x25{2}/,placeholder:/^\x25(?:([1-9]\d*)\$|\(([^\)]+)\))?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-gijostTuvxX])/,key:/^([a-z_][a-z_\d]*)/i,key_access:/^\.([a-z_][a-z_\d]*)/i,index_access:/^\[(\d+)\]/,sign:/^[\+\-]/},Gm=Object.create(null),$m=function(t){function e(e,i){var r=Object.assign({},i);t.call(this),this.renumberSerial=Nn(r.renumberSerial,!0),this.remarks=Qn(Nn(r.remarks,[])),this.structure=e,this._records=[]}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={mimeType:{configurable:!0},defaultName:{configurable:!0},defaultExt:{configurable:!0}};return i.mimeType.get=function(){return"text/plain"},i.defaultName.get=function(){return"structure"},i.defaultExt.get=function(){return"pdb"},e.prototype._writeRecords=function(){this._records.length=0,this._writeTitle(),this._writeRemarks(),this._writeAtoms()},e.prototype._writeTitle=function(){this._records.push(Go("TITLE %-74s",this.structure.name))},e.prototype._writeRemarks=function(){var t=this;this.remarks.forEach(function(e){t._records.push(Go("REMARK %-73s",e))}),this.structure.trajectory&&(this._records.push(Go("REMARK %-73s","Trajectory '"+this.structure.trajectory.name+"'")),this._records.push(Go("REMARK %-73s","Frame "+this.structure.trajectory.frame)))},e.prototype._writeAtoms=function(){var t=this,e=1,i=1;this.structure.eachModel(function(r){t._records.push(Go("MODEL %-74d",i++)),r.eachAtom(function(i){var r=i.hetero?"HETATM%5d %-4s %3s %1s%4d    %8.3f%8.3f%8.3f%6.2f%6.2f      %4s%2s":"ATOM  %5d %-4s %3s %1s%4d    %8.3f%8.3f%8.3f%6.2f%6.2f      %4s%2s",n=t.renumberSerial?e:i.serial,o=i.atomname;1===o.length&&(o=" "+o),t._records.push(Go(r,n,o,i.resname,Nn(i.chainname," "),i.resno,i.x,i.y,i.z,Nn(i.occurence,1),Nn(i.bfactor,0),Nn(i.segid,""),Nn(i.element,""))),e+=1}),t._records.push(Go("%-80s","ENDMDL")),i+=1}),this._records.push(Go("%-80s","END"))},e.prototype.getString=function(){return console.warn("PdbWriter.getString() is deprecated, use .getData instead"),this.getData()},e.prototype.getData=function(){return this._writeRecords(),this._records.join("\n")},Object.defineProperties(e.prototype,i),e}(Um),Hm=function(t){function e(e){t.call(this),this.structure=e,this._records=[]}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={idString:{configurable:!0},titleString:{configurable:!0},countsString:{configurable:!0},chargeLines:{configurable:!0}};return i.idString.get=function(){return this.structure.id},i.titleString.get=function(){return"  "+this.structure.title},i.countsString.get=function(){return Go("%3i%3i  0  0  0  0  0  0  0  0999 V2000",this.structure.atomCount,this.structure.bondCount)},i.chargeLines.get=function(){var t=[];this.structure.eachAtom(function(e){null!=e.formalCharge&&0!==e.formalCharge&&t.push([e.index,e.formalCharge])});for(var e=[],i=0;i<t.length;i+=8){for(var r=Math.min(8,t.length-i),n=Go("M  CHG%3i",r),o=i;o<i+r;o++)n+=Go(" %3i %3i",t[o][0]+1,t[o][1]);e.push(n)}return e},e.prototype.formatAtom=function(t){var e=0;null!=t.formalCharge&&0!==t.formalCharge&&(e=4-t.formalCharge);var i=Go("%10.4f%10.4f%10.4f %-3s 0%3i  0  0  0",t.x,t.y,t.z,t.element,e);if(48!==i.length)throw new Error("Incompatible atom for sdf format");return i},e.prototype.formatBond=function(t){return Go("%3i%3i%3i  0  0  0",t.atomIndex1+1,t.atomIndex2+1,t.bondOrder)},e.prototype._writeRecords=function(){this._records.length=0,this._writeHeader(),this._writeCTab(),this._writeFooter()},e.prototype._writeHeader=function(){this._records.push(this.idString,this.titleString,"")},e.prototype._writeCTab=function(){var t=this;this._records.push(this.countsString),this.structure.eachAtom(function(e){t._records.push(t.formatAtom(e))}),this.structure.eachBond(function(e){t._records.push(t.formatBond(e))}),this.chargeLines.forEach(function(e){t._records.push(e)}),this._records.push("M  END")},e.prototype._writeFooter=function(){this._records.push("$$$$")},e.prototype.getData=function(){return this._writeRecords(),this._records.join("\n")},Object.defineProperties(e.prototype,i),e}(Um),Wm=[],Xm=function(t,e){var i=e||{},r=!1;void 0===t&&(t=8192),"number"==typeof t?t=new ArrayBuffer(t):(r=!0,this._lastWrittenByte=t.byteLength);var n=i.offset?i.offset>>>0:0,o=t.byteLength-n,a=n;t.buffer&&(t.byteLength!==t.buffer.byteLength&&(a=t.byteOffset+n),t=t.buffer),this._lastWrittenByte=r?o:0,this.buffer=t,this.length=o,this.byteLength=o,this.byteOffset=a,this.offset=0,this.littleEndian=!0,this._data=new DataView(this.buffer,a,o),this._mark=0,this._marks=[]};Xm.prototype.available=function(t){return void 0===t&&(t=1),this.offset+t<=this.length},Xm.prototype.isLittleEndian=function(){return this.littleEndian},Xm.prototype.setLittleEndian=function(){return this.littleEndian=!0,this},Xm.prototype.isBigEndian=function(){return!this.littleEndian},Xm.prototype.setBigEndian=function(){return this.littleEndian=!1,this},Xm.prototype.skip=function(t){return void 0===t&&(t=1),this.offset+=t,this},Xm.prototype.seek=function(t){return this.offset=t,this},Xm.prototype.mark=function(){return this._mark=this.offset,this},Xm.prototype.reset=function(){return this.offset=this._mark,this},Xm.prototype.pushMark=function(){return this._marks.push(this.offset),this},Xm.prototype.popMark=function(){var t=this._marks.pop();if(void 0===t)throw new Error("Mark stack empty");return this.seek(t),this},Xm.prototype.rewind=function(){return this.offset=0,this},Xm.prototype.ensureAvailable=function(t){if(void 0===t&&(t=1),!this.available(t)){var e=2*(this.offset+t),i=new Uint8Array(e);i.set(new Uint8Array(this.buffer)),this.buffer=i.buffer,this.length=this.byteLength=e,this._data=new DataView(this.buffer)}return this},Xm.prototype.readBoolean=function(){return 0!==this.readUint8()},Xm.prototype.readInt8=function(){return this._data.getInt8(this.offset++)},Xm.prototype.readUint8=function(){return this._data.getUint8(this.offset++)},Xm.prototype.readByte=function(){return this.readUint8()},Xm.prototype.readBytes=function(t){var e=this;void 0===t&&(t=1);for(var i=new Uint8Array(t),r=0;r<t;r++)i[r]=e.readByte();return i},Xm.prototype.readInt16=function(){var t=this._data.getInt16(this.offset,this.littleEndian);return this.offset+=2,t},Xm.prototype.readUint16=function(){var t=this._data.getUint16(this.offset,this.littleEndian);return this.offset+=2,t},Xm.prototype.readInt32=function(){var t=this._data.getInt32(this.offset,this.littleEndian);return this.offset+=4,t},Xm.prototype.readUint32=function(){var t=this._data.getUint32(this.offset,this.littleEndian);return this.offset+=4,t},Xm.prototype.readFloat32=function(){var t=this._data.getFloat32(this.offset,this.littleEndian);return this.offset+=4,t},Xm.prototype.readFloat64=function(){var t=this._data.getFloat64(this.offset,this.littleEndian);return this.offset+=8,t},Xm.prototype.readChar=function(){return String.fromCharCode(this.readInt8())},Xm.prototype.readChars=function(t){var e=this;void 0===t&&(t=1),Wm.length=t;for(var i=0;i<t;i++)Wm[i]=e.readChar();return Wm.join("")},Xm.prototype.writeBoolean=function(t){return this.writeUint8(t?255:0),this},Xm.prototype.writeInt8=function(t){return this.ensureAvailable(1),this._data.setInt8(this.offset++,t),this._updateLastWrittenByte(),this},Xm.prototype.writeUint8=function(t){return this.ensureAvailable(1),this._data.setUint8(this.offset++,t),this._updateLastWrittenByte(),this},Xm.prototype.writeByte=function(t){return this.writeUint8(t)},Xm.prototype.writeBytes=function(t){var e=this;this.ensureAvailable(t.length);for(var i=0;i<t.length;i++)e._data.setUint8(e.offset++,t[i]);return this._updateLastWrittenByte(),this},Xm.prototype.writeInt16=function(t){return this.ensureAvailable(2),this._data.setInt16(this.offset,t,this.littleEndian),this.offset+=2,this._updateLastWrittenByte(),this},Xm.prototype.writeUint16=function(t){return this.ensureAvailable(2),this._data.setUint16(this.offset,t,this.littleEndian),this.offset+=2,this._updateLastWrittenByte(),this},Xm.prototype.writeInt32=function(t){return this.ensureAvailable(4),this._data.setInt32(this.offset,t,this.littleEndian),this.offset+=4,this._updateLastWrittenByte(),this},Xm.prototype.writeUint32=function(t){return this.ensureAvailable(4),this._data.setUint32(this.offset,t,this.littleEndian),this.offset+=4,this._updateLastWrittenByte(),this},Xm.prototype.writeFloat32=function(t){return this.ensureAvailable(4),this._data.setFloat32(this.offset,t,this.littleEndian),this.offset+=4,this._updateLastWrittenByte(),this},Xm.prototype.writeFloat64=function(t){return this.ensureAvailable(8),this._data.setFloat64(this.offset,t,this.littleEndian),this.offset+=8,this._updateLastWrittenByte(),this},Xm.prototype.writeChar=function(t){return this.writeUint8(t.charCodeAt(0))},Xm.prototype.writeChars=function(t){for(var e=this,i=0;i<t.length;i++)e.writeUint8(t.charCodeAt(i));return this},Xm.prototype.toArray=function(){return new Uint8Array(this.buffer,this.byteOffset,this._lastWrittenByte)},Xm.prototype.getBuffer=function(){return"undefined"!=typeof Buffer?Buffer.from(this.toArray()):this.toArray()},Xm.prototype._updateLastWrittenByte=function(){this.offset>this._lastWrittenByte&&(this._lastWrittenByte=this.offset)};var qm=function(t){function e(e){t.call(this),this.surface=e,this._records=[]}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={mimeType:{configurable:!0},defaultName:{configurable:!0},defaultExt:{configurable:!0}};return i.mimeType.get=function(){return"application/vnd.ms-pki.stl"},i.defaultName.get=function(){return"surface"},i.defaultExt.get=function(){return"stl"},e.prototype.getData=function(){var t=this,e=this.surface.index.length/3,i=new Xm(2*e+3*e*4*4+80+4);i.skip(80),i.writeUint32(e);for(var r=new v,n=new v,o=new v,a=new v,s=0;s<e;s++){var c=[t.surface.index[3*s],t.surface.index[3*s+1],t.surface.index[3*s+2]];n.fromArray(t.surface.normal,3*c[0]),o.fromArray(t.surface.normal,3*c[1]),a.fromArray(t.surface.normal,3*c[2]),r.addVectors(n,o).add(a).normalize(),i.writeFloat32(r.x),i.writeFloat32(r.y),i.writeFloat32(r.z);for(var u=0;u<3;u++)r.fromArray(t.surface.position,3*c[u]),i.writeFloat32(r.x),i.writeFloat32(r.y),i.writeFloat32(r.z);i.writeUint16(0)}return new DataView(i.buffer)},Object.defineProperties(e.prototype,i),e}(Um),Ym=function(){this.count=0,this.signals={countChanged:new So}};Ym.prototype.clear=function(){this.change(-this.count)},Ym.prototype.change=function(t){this.count+=t,this.signals.countChanged.dispatch(t,this.count),this.count<0&&vm.warn("Counter.count below zero",this.count)},Ym.prototype.increment=function(){this.change(1)},Ym.prototype.decrement=function(){this.change(-1)},Ym.prototype.listen=function(t){this.change(t.count),t.signals.countChanged.add(this.change,this)},Ym.prototype.unlisten=function(t){var e=t.signals.countChanged;e.has(this.change,this)&&e.remove(this.change,this)},Ym.prototype.onZeroOnce=function(t,e){if(0===this.count)t.call(e,0,0);else{var i=function(){0===this.count&&(this.signals.countChanged.remove(i,this),t.apply(e,arguments))};this.signals.countChanged.add(i,this)}},Ym.prototype.dispose=function(){this.clear(),this.signals.countChanged.dispose()},Mm.add("shader/BasicLine.vert","void main(){\n#include begin_vertex\n#include project_vertex\n}"),Mm.add("shader/BasicLine.frag","uniform vec3 uColor;\n#include common\n#include fog_pars_fragment\nvoid main(){\ngl_FragColor = vec4( uColor, 1.0 );\n#include premultiplied_alpha_fragment\n#include tonemapping_fragment\n#include encodings_fragment\n#include fog_fragment\n}"),Mm.add("shader/Quad.vert","varying vec2 vUv;\nvoid main() {\nvUv = uv;\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}"),Mm.add("shader/Quad.frag","varying vec2 vUv;\nuniform sampler2D tForeground;\nuniform float scale;\nvoid main() {\nvec4 foreground = texture2D( tForeground, vUv );\ngl_FragColor = foreground * scale;\n}"),Wo.prototype={update:function(){this.startTime=this.end(),this.currentTime=this.startTime,this.signals.updated.dispatch()},begin:function(){this.startTime=window.performance.now(),this.lastFrames=this.frames},end:function(){var t=window.performance.now();return this.count+=1,this.frames+=1,this.lastDuration=t-this.startTime,this.minDuration=Math.min(this.minDuration,this.lastDuration),this.maxDuration=Math.max(this.maxDuration,this.lastDuration),this.avgDuration-=this.avgDuration/30,this.avgDuration+=this.lastDuration/30,t>this.prevFpsTime+1e3&&(this.lastFps=this.frames,this.prevFpsTime=t,this.frames=0),t}},Mm.add("shader/chunk/dull_interior_fragment.glsl","#ifdef DULL_INTERIOR\nif( gl_FrontFacing == false ){\nnormal = vec3( 0.0, 0.0, 0.4 );\n}\n#endif"),Mm.add("shader/chunk/fog_fragment.glsl","#ifdef USE_FOG\nfloat depth = length( vViewPosition );\n#ifdef FOG_EXP2\nfloat fogFactor = whiteCompliment( exp2( - fogDensity * fogDensity * depth * depth * LOG2 ) );\n#else\nfloat fogFactor = smoothstep( fogNear, fogFar, depth );\n#endif\ngl_FragColor.rgb = mix( gl_FragColor.rgb, fogColor, fogFactor );\n#endif"),Mm.add("shader/chunk/matrix_scale.glsl","float matrixScale( in mat4 m ){\nvec4 r = m[ 0 ];\nreturn sqrt( r[ 0 ] * r[ 0 ] + r[ 1 ] * r[ 1 ] + r[ 2 ] * r[ 2 ] );\n}"),Mm.add("shader/chunk/nearclip_vertex.glsl","#ifdef NEAR_CLIP\nif( vViewPosition.z < nearClip - 5.0 )\ngl_Position.z = 2.0 * gl_Position.w;\n#endif"),Mm.add("shader/chunk/nearclip_fragment.glsl","#ifdef NEAR_CLIP\nif( vViewPosition.z < nearClip )\ndiscard;\n#endif"),Mm.add("shader/chunk/opaque_back_fragment.glsl","#ifdef OPAQUE_BACK\n#ifdef FLIP_SIDED\nif( gl_FrontFacing == true ){\ngl_FragColor.a = 1.0;\n}\n#else\nif( gl_FrontFacing == false ){\ngl_FragColor.a = 1.0;\n}\n#endif\n#endif"),Mm.add("shader/chunk/radiusclip_vertex.glsl","#ifdef RADIUS_CLIP\nif( distance( vViewPosition, vClipCenter ) > clipRadius + 5.0 )\ngl_Position.z = 2.0 * gl_Position.w;\n#endif"),Mm.add("shader/chunk/radiusclip_fragment.glsl","#ifdef RADIUS_CLIP\nif( distance( vViewPosition, vClipCenter ) > clipRadius )\ndiscard;\n#endif"),Mm.add("shader/chunk/unpack_color.glsl","vec3 unpackColor(float f) {\nvec3 color;\ncolor.r = floor(f / 256.0 / 256.0);\ncolor.g = floor((f - color.r * 256.0 * 256.0) / 256.0);\ncolor.b = floor(f - color.r * 256.0 * 256.0 - color.g * 256.0);\nreturn color / 255.0;\n}");var Zm=/^(?!\/\/)\s*#include\s+(\S+)/gim,Km={};if("undefined"!=typeof window&&window.WebGLRenderingContext){var Qm=window.WebGLRenderingContext.prototype,Jm=Qm.getShaderParameter;Qm.getShaderParameter=function(){return!t.Debug||Jm.apply(this,arguments)};var tg=Qm.getShaderInfoLog;Qm.getShaderInfoLog=function(){return t.Debug?tg.apply(this,arguments):""};var eg=Qm.getProgramParameter;Qm.getProgramParameter=function(e,i){return!t.Debug&&i===Qm.LINK_STATUS||eg.apply(this,arguments)};var ig=Qm.getProgramInfoLog;Qm.getProgramInfoLog=function(){return t.Debug?ig.apply(this,arguments):""}}var rg=[[[0,0]],[[4,4],[-4,-4]],[[-2,-6],[6,-2],[-6,2],[2,6]],[[1,-3],[-1,3],[5,1],[-3,-5],[-5,5],[-7,-1],[3,7],[7,-7]],[[1,1],[-1,-3],[-3,2],[4,-1],[-5,-2],[2,5],[5,3],[3,-5],[-2,6],[0,-7],[-4,-6],[-6,4],[-8,0],[7,-4],[6,7],[-7,-8]],[[-4,-7],[-7,-5],[-3,-5],[-5,-4],[-1,-4],[-2,-2],[-6,-1],[-4,0],[-7,1],[-1,2],[-6,3],[-3,3],[-7,6],[-3,6],[-5,7],[-1,7],[5,-7],[1,-6],[6,-5],[4,-4],[2,-3],[7,-2],[1,-1],[4,-1],[2,1],[6,2],[0,4],[4,4],[2,5],[7,5],[5,6],[3,7]]];rg.forEach(function(t){t.forEach(function(t){t[0]*=.0625,t[1]*=.0625})}),Yo.prototype.constructor=Yo;var ng=2*Math.PI,og=180/Math.PI,ag=new v,sg=new y,cg=new y,ug=new h,lg=new y,hg=new y,pg=new Float32Array(4),dg=new Uint8Array(4),fg=new y;ya.prototype.constructor=ya;var mg=function(t,e){this.signals={moved:new So,scrolled:new So,dragged:new So,dropped:new So,clicked:new So,hovered:new So,doubleClicked:new So};var i=Object.assign({},e);this.hoverTimeout=Nn(i.hoverTimeout,50),this.handleScroll=Nn(i.handleScroll,!0),this.doubleClickSpeed=Nn(i.doubleClickSpeed,500),this.domElement=t,this.domElement.style.touchAction="none",this.position=new h,this.prevPosition=new h,this.down=new h,this.canvasPosition=new h,this.moving=!1,this.hovering=!0,this.scrolled=!1,this.lastMoved=1/0,this.which=void 0,this.buttons=void 0,this.pressed=void 0,this.altKey=void 0,this.ctrlKey=void 0,this.metaKey=void 0,this.shiftKey=void 0,this._listen=this._listen.bind(this),this._onMousewheel=this._onMousewheel.bind(this),this._onMousemove=this._onMousemove.bind(this),this._onMousedown=this._onMousedown.bind(this),this._onMouseup=this._onMouseup.bind(this),this._onContextmenu=this._onContextmenu.bind(this),this._onTouchstart=this._onTouchstart.bind(this),this._onTouchend=this._onTouchend.bind(this),this._onTouchmove=this._onTouchmove.bind(this),this._listen(),document.addEventListener("mousewheel",this._onMousewheel),document.addEventListener("wheel",this._onMousewheel),document.addEventListener("MozMousePixelScroll",this._onMousewheel),document.addEventListener("mousemove",this._onMousemove),document.addEventListener("mousedown",this._onMousedown),document.addEventListener("mouseup",this._onMouseup),document.addEventListener("contextmenu",this._onContextmenu),document.addEventListener("touchstart",this._onTouchstart),document.addEventListener("touchend",this._onTouchend),document.addEventListener("touchmove",this._onTouchmove),this.prevClickCP=new h},gg={key:{configurable:!0}};gg.key.get=function(){var t=0;return this.altKey&&(t+=1),this.ctrlKey&&(t+=2),this.metaKey&&(t+=4),this.shiftKey&&(t+=8),t},mg.prototype.setParameters=function(t){var e=Object.assign({},t);this.hoverTimeout=Nn(e.hoverTimeout,this.hoverTimeout)},mg.prototype._listen=function(){var t=window.performance.now(),e=this.canvasPosition;this.doubleClickPending&&t-this.lastClicked>this.doubleClickSpeed&&(this.doubleClickPending=!1),t-this.lastMoved>this.hoverTimeout&&(this.moving=!1),(this.scrolled||!this.moving&&!this.hovering)&&(this.scrolled=!1,-1!==this.hoverTimeout&&this.overElement&&(this.hovering=!0,this.signals.hovered.dispatch(e.x,e.y))),window.requestAnimationFrame(this._listen)},mg.prototype._onMousewheel=function(t){var e=this;if(t.target===this.domElement&&this.handleScroll){t.preventDefault(),this._setKeys(t);var i=0;i=t.wheelDelta?t.wheelDelta/40:t.detail?-t.detail/3:-t.deltaY/(t.deltaMode?.33:30),this.signals.scrolled.dispatch(i),setTimeout(function(){e.scrolled=!0},this.hoverTimeout)}},mg.prototype._onMousemove=function(t){t.target===this.domElement?(t.preventDefault(),this.overElement=!0):this.overElement=!1,this._setKeys(t),this.moving=!0,this.hovering=!1,this.lastMoved=window.performance.now(),this.prevPosition.copy(this.position),this.position.set(t.clientX,t.clientY),this._setCanvasPosition(t);var e=this.prevPosition.x-this.position.x,i=this.prevPosition.y-this.position.y;this.signals.moved.dispatch(e,i),this.pressed&&this.signals.dragged.dispatch(e,i)},mg.prototype._onMousedown=function(t){t.target===this.domElement&&(t.preventDefault(),this._setKeys(t),this.moving=!1,this.hovering=!1,this.down.set(t.clientX,t.clientY),this.position.set(t.clientX,t.clientY),this.which=t.which,this.buttons=xa(t),this.pressed=!0,this._setCanvasPosition(t))},mg.prototype._onMouseup=function(t){t.target===this.domElement&&t.preventDefault(),this._setKeys(t);var e=this.canvasPosition;this._distance()<4&&(this.lastClicked=window.performance.now(),this.doubleClickPending&&this.prevClickCP.distanceTo(e)<4?(this.signals.doubleClicked.dispatch(e.x,e.y),this.doubleClickPending=!1):(this.signals.clicked.dispatch(e.x,e.y),this.doubleClickPending=!0),this.prevClickCP.copy(e)),this.which=void 0,this.buttons=void 0,this.pressed=void 0},mg.prototype._onContextmenu=function(t){t.target===this.domElement&&t.preventDefault()},mg.prototype._onTouchstart=function(t){if(t.target===this.domElement)switch(t.preventDefault(),this.pressed=!0,t.touches.length){case 1:this.moving=!1,this.hovering=!1,this.down.set(t.touches[0].pageX,t.touches[0].pageY),this.position.set(t.touches[0].pageX,t.touches[0].pageY),this._setCanvasPosition(t.touches[0]);break;case 2:this.down.set((t.touches[0].pageX+t.touches[1].pageX)/2,(t.touches[0].pageY+t.touches[1].pageY)/2),this.position.set((t.touches[0].pageX+t.touches[1].pageX)/2,(t.touches[0].pageY+t.touches[1].pageY)/2),this.lastTouchDistance=ba(t)}},mg.prototype._onTouchend=function(t){t.target===this.domElement&&t.preventDefault(),this.which=void 0,this.buttons=void 0,this.pressed=void 0},mg.prototype._onTouchmove=function(t){switch(t.target===this.domElement?(t.preventDefault(),this.overElement=!0):this.overElement=!1,t.touches.length){case 1:this._setKeys(t),this.which=1,this.buttons=1,this.moving=!0,this.hovering=!1,this.lastMoved=window.performance.now(),this.prevPosition.copy(this.position),this.position.set(t.touches[0].pageX,t.touches[0].pageY),this._setCanvasPosition(t.touches[0]);var e=this.prevPosition.x-this.position.x,i=this.prevPosition.y-this.position.y;this.signals.moved.dispatch(e,i),this.pressed&&this.signals.dragged.dispatch(e,i);break;case 2:var r=ba(t),n=r-this.lastTouchDistance;if(this.lastTouchDistance=r,this.prevPosition.copy(this.position),this.position.set((t.touches[0].pageX+t.touches[1].pageX)/2,(t.touches[0].pageY+t.touches[1].pageY)/2),Math.abs(n)>2&&this.handleScroll&&this.position.distanceTo(this.prevPosition)<2)this.which=0,this.buttons=0,this.signals.scrolled.dispatch(n/2);else{this.which=3,this.buttons=2;var o=this.prevPosition.x-this.position.x,a=this.prevPosition.y-this.position.y;this.signals.moved.dispatch(o,a),this.pressed&&this.signals.dragged.dispatch(o,a)}}},mg.prototype._distance=function(){return this.position.distanceTo(this.down)},mg.prototype._setCanvasPosition=function(t){var e,i,r=this.domElement.getBoundingClientRect();"offsetX"in t&&"offsetY"in t?(e=t.offsetX,i=t.offsetY):(e=t.clientX-r.left,i=t.clientY-r.top),this.canvasPosition.set(e,r.height-i)},mg.prototype._setKeys=function(t){this.altKey=t.altKey,this.ctrlKey=t.ctrlKey,this.metaKey=t.metaKey,this.shiftKey=t.shiftKey},mg.prototype.dispose=function(){document.removeEventListener("mousewheel",this._onMousewheel),document.removeEventListener("wheel",this._onMousewheel),document.removeEventListener("MozMousePixelScroll",this._onMousewheel),document.removeEventListener("mousemove",this._onMousemove),document.removeEventListener("mousedown",this._onMousedown),document.removeEventListener("mouseup",this._onMouseup),document.removeEventListener("contextmenu",this._onContextmenu),document.removeEventListener("touchstart",this._onTouchstart),document.removeEventListener("touchend",this._onTouchend),document.removeEventListener("touchmove",this._onTouchmove)},Object.defineProperties(mg.prototype,gg);var vg=new y,yg=new y,bg=new y,xg=new v,_g=new g,wg=new y,Sg=new v,Ag=new v,Mg=function(t,e){var i=e||{};this.rotateSpeed=Nn(i.rotateSpeed,2),this.zoomSpeed=Nn(i.zoomSpeed,1.2),this.panSpeed=Nn(i.panSpeed,1),this.stage=t,this.viewer=t.viewer,this.mouse=t.mouseObserver,this.controls=t.viewerControls},Pg={component:{configurable:!0},atom:{configurable:!0}};Pg.component.get=function(){return this.stage.transformComponent},Pg.atom.get=function(){return this.stage.transformAtom},Mg.prototype._setPanVector=function(t,e,i){var r,n=this.viewer.camera;if(i=-i||0,i+=n.position.z,"OrthographicCamera"===n.type)r=1/n.zoom;else{var o=co(n.fov);r=-2*i*Math.tan(o/2)/this.viewer.height}Sg.set(t,e,0),Sg.multiplyScalar(this.panSpeed*r)},Mg.prototype._getRotateXY=function(t,e){return[this.rotateSpeed*-t*.01,this.rotateSpeed*e*.01]},Mg.prototype._transformPanVector=function(){wg.extractRotation(this.component.transform),wg.premultiply(this.viewer.rotationGroup.matrix),wg.getInverse(wg),Sg.applyMatrix4(wg)},Mg.prototype.zoom=function(t){this.controls.zoom(this.zoomSpeed*t*.02)},Mg.prototype.pan=function(t,e){this._setPanVector(t,e),wg.getInverse(this.viewer.rotationGroup.matrix),Sg.applyMatrix4(wg),this.controls.translate(Sg)},Mg.prototype.panComponent=function(t,e){this.component&&(this._setPanVector(t,e),this._transformPanVector(),this.component.position.add(Sg),this.component.updateMatrix())},Mg.prototype.panAtom=function(t,e){this.atom&&this.component&&(this.atom.positionToVector3(Ag),Ag.add(this.viewer.translationGroup.position),Ag.applyMatrix4(this.viewer.rotationGroup.matrix),this._setPanVector(t,e,Ag.z),this._transformPanVector(),this.atom.positionAdd(Sg),this.component.updateRepresentations({position:!0}))},Mg.prototype.rotate=function(t,e){var i=this._getRotateXY(t,e),r=i[0],n=i[1];vg.makeRotationX(n),yg.makeRotationY(r),vg.multiply(yg),this.controls.applyMatrix(vg)},Mg.prototype.rotateComponent=function(t,e){if(this.component){var i=this._getRotateXY(t,e),r=i[0],n=i[1];bg.extractRotation(this.component.transform),bg.premultiply(this.viewer.rotationGroup.matrix),bg.getInverse(bg),xg.set(1,0,0),xg.applyMatrix4(bg),vg.makeRotationAxis(xg,n),xg.set(0,1,0),xg.applyMatrix4(bg),yg.makeRotationAxis(xg,r),vg.multiply(yg),_g.setFromRotationMatrix(vg),this.component.quaternion.premultiply(_g),this.component.updateMatrix()}},Object.defineProperties(Mg.prototype,Pg);var Eg=function(t,e){this.pid=t.pid,this.picker=t.picker,this.instance=t.instance,this.stage=e,this.controls=e.viewerControls,this.mouse=e.mouseObserver},Tg={type:{configurable:!0},altKey:{configurable:!0},ctrlKey:{configurable:!0},metaKey:{configurable:!0},shiftKey:{configurable:!0},canvasPosition:{configurable:!0},component:{configurable:!0},object:{configurable:!0},position:{configurable:!0},closestBondAtom:{configurable:!0},arrow:{configurable:!0},atom:{configurable:!0},axes:{configurable:!0},bond:{configurable:!0},box:{configurable:!0},cone:{configurable:!0},clash:{configurable:!0},contact:{configurable:!0},cylinder:{configurable:!0},distance:{configurable:!0},ellipsoid:{configurable:!0},octahedron:{configurable:!0},mesh:{configurable:!0},slice:{configurable:!0},sphere:{configurable:!0},tetrahedron:{configurable:!0},torus:{configurable:!0},surface:{configurable:!0},unitcell:{configurable:!0},unknown:{configurable:!0},volume:{configurable:!0}};Tg.type.get=function(){return this.picker.type},Tg.altKey.get=function(){return this.mouse.altKey},Tg.ctrlKey.get=function(){return this.mouse.ctrlKey},Tg.metaKey.get=function(){return this.mouse.metaKey},Tg.shiftKey.get=function(){return this.mouse.shiftKey},Tg.canvasPosition.get=function(){return this.mouse.canvasPosition},Tg.component.get=function(){return this.stage.getComponentsByObject(this.picker.data).list[0]},Tg.object.get=function(){return this.picker.getObject(this.pid)},Tg.position.get=function(){return this.picker.getPosition(this.pid,this.instance,this.component)},Tg.closestBondAtom.get=function(){if("bond"===this.type){var t=this.bond,e=this.controls;return _a(this.canvasPosition,e.getPositionOnCanvas(t.atom1),e.getPositionOnCanvas(t.atom2))?t.atom1:t.atom2}},Tg.arrow.get=function(){return this._objectIfType("arrow")},Tg.atom.get=function(){return this._objectIfType("atom")},Tg.axes.get=function(){return this._objectIfType("axes")},Tg.bond.get=function(){return this._objectIfType("bond")},Tg.box.get=function(){return this._objectIfType("box")},Tg.cone.get=function(){return this._objectIfType("cone")},Tg.clash.get=function(){return this._objectIfType("clash")},Tg.contact.get=function(){return this._objectIfType("contact")},Tg.cylinder.get=function(){return this._objectIfType("cylinder")},Tg.distance.get=function(){return this._objectIfType("distance")},Tg.ellipsoid.get=function(){return this._objectIfType("ellipsoid")},Tg.octahedron.get=function(){return this._objectIfType("octahedron")},Tg.mesh.get=function(){return this._objectIfType("mesh")},Tg.slice.get=function(){return this._objectIfType("slice")},Tg.sphere.get=function(){return this._objectIfType("sphere")},Tg.tetrahedron.get=function(){return this._objectIfType("tetrahedron")},Tg.torus.get=function(){return this._objectIfType("torus")},Tg.surface.get=function(){return this._objectIfType("surface")},Tg.unitcell.get=function(){return this._objectIfType("unitcell")},Tg.unknown.get=function(){return this._objectIfType("unknown")},Tg.volume.get=function(){return this._objectIfType("volume")},Eg.prototype._objectIfType=function(t){return this.type===t?this.object:void 0},Eg.prototype.getLabel=function(){var t="nothing";return this.arrow?t="arrow: "+(this.arrow.name||this.pid)+" ("+this.arrow.shape.name+")":this.atom?t="atom: "+this.atom.qualifiedName()+" ("+this.atom.structure.name+")":this.axes?t="axes":this.bond?t="bond: "+this.bond.atom1.qualifiedName()+" - "+this.bond.atom2.qualifiedName()+" ("+this.bond.structure.name+")":this.box?t="box: "+(this.box.name||this.pid)+" ("+this.box.shape.name+")":this.cone?t="cone: "+(this.cone.name||this.pid)+" ("+this.cone.shape.name+")":this.clash?t="clash: "+this.clash.clash.sele1+" - "+this.clash.clash.sele2:this.contact?t="contact: "+this.contact.atom1.qualifiedName()+" - "+this.contact.atom2.qualifiedName()+" ("+this.contact.structure.name+")":this.cylinder?t="cylinder: "+(this.cylinder.name||this.pid)+" ("+this.cylinder.shape.name+")":this.distance?t="distance: "+this.distance.atom1.qualifiedName()+" - "+this.distance.atom2.qualifiedName()+" ("+this.distance.structure.name+")":this.ellipsoid?t="ellipsoid: "+(this.ellipsoid.name||this.pid)+" ("+this.ellipsoid.shape.name+")":this.octahedron?t="octahedron: "+(this.octahedron.name||this.pid)+" ("+this.octahedron.shape.name+")":this.mesh?t="mesh: "+(this.mesh.name||this.mesh.serial)+" ("+this.mesh.shape.name+")":this.slice?t="slice: "+this.slice.value.toPrecision(3)+" ("+this.slice.volume.name+")":this.sphere?t="sphere: "+(this.sphere.name||this.pid)+" ("+this.sphere.shape.name+")":this.surface?t="surface: "+this.surface.surface.name:this.tetrahedron?t="tetrahedron: "+(this.tetrahedron.name||this.pid)+" ("+this.tetrahedron.shape.name+")":this.torus?t="torus: "+(this.torus.name||this.pid)+" ("+this.torus.shape.name+")":this.unitcell?t="unitcell: "+this.unitcell.unitcell.spacegroup+" ("+this.unitcell.structure.name+")":this.unknown?t="unknown":this.volume&&(t="volume: "+this.volume.value.toPrecision(3)+" ("+this.volume.volume.name+")"),t},Object.defineProperties(Eg.prototype,Tg);var Cg=function(t){this.stage=t,this.viewer=t.viewer};Cg.prototype.pick=function(t,e){var i=this.viewer.pick(t,e);if(i.picker&&"ignore"!==i.picker.type&&void 0!==i.pid){var r=i.picker.array;if(!(r&&i.pid>=r.length))return new Eg(i,this.stage);console.error("pid >= picker.array.length")}};var Ig=new g,Rg=new v,Lg=new v,Og=new v,Dg=new v,Ng=new y,kg=new v,Bg=new y,Fg=function(t){this.stage=t,this.viewer=t.viewer,this.signals={changed:new So}},zg={position:{configurable:!0},rotation:{configurable:!0}};zg.position.get=function(){return this.viewer.translationGroup.position},zg.rotation.get=function(){return this.viewer.rotationGroup.quaternion},Fg.prototype.changed=function(){this.viewer.requestRender(),this.signals.changed.dispatch()},Fg.prototype.getPositionOnCanvas=function(t,e){var i=io(e),r=this.viewer;return Og.copy(t).add(r.translationGroup.position).applyMatrix4(r.rotationGroup.matrix).project(r.camera),i.set((Og.x+1)*r.width/2,(Og.y+1)*r.height/2)},Fg.prototype.getOrientation=function(t){var e=no(t);e.copy(this.viewer.rotationGroup.matrix);var i=-this.viewer.camera.position.z;return e.scale(Dg.set(i,i,i)),e.setPosition(this.viewer.translationGroup.position),e},Fg.prototype.orient=function(t){no(t).decompose(Rg,Ig,Lg);var e=this.viewer;e.rotationGroup.setRotationFromQuaternion(Ig),e.translationGroup.position.copy(Rg),e.camera.position.z=-Lg.z,e.updateZoom(),this.changed()},Fg.prototype.translate=function(t){this.viewer.translationGroup.position.add(ro(t)),this.changed()},Fg.prototype.center=function(t){this.viewer.translationGroup.position.copy(ro(t)).negate(),this.changed()},Fg.prototype.zoom=function(t){this.distance(this.viewer.camera.position.z*(1-t))},Fg.prototype.distance=function(t){this.viewer.camera.position.z=t,this.viewer.updateZoom(),this.changed()},Fg.prototype.spin=function(t,e){Ng.getInverse(this.viewer.rotationGroup.matrix),kg.copy(ro(t)).applyMatrix4(Ng),this.viewer.rotationGroup.rotateOnAxis(kg,e),this.changed()},Fg.prototype.rotate=function(t){this.viewer.rotationGroup.setRotationFromQuaternion(oo(t)),this.changed()},Fg.prototype.align=function(t){Bg.getInverse(no(t)),this.viewer.rotationGroup.setRotationFromMatrix(Bg),this.changed()},Fg.prototype.applyMatrix=function(t){this.viewer.rotationGroup.applyMatrix(no(t)),this.changed()},Object.defineProperties(Fg.prototype,zg);var Ug=function(t,e){for(var i=[],r=arguments.length-2;r-- >0;)i[r]=arguments[r+2];this.duration=Nn(t,1e3),this.controls=e,this.startTime=window.performance.now(),this.pausedTime=-1,this.elapsedDuration=0,this.pausedDuration=0,this.ignoreGlobalToggle=!1,this._paused=!1,this._resolveList=[],(n=this)._init.apply(n,i);var n},jg={done:{configurable:!0},paused:{configurable:!0}};jg.done.get=function(){return 1===this.alpha},jg.paused.get=function(){return this._paused},Ug.prototype._init=function(){},Ug.prototype._tick=function(){},Ug.prototype.tick=function(t){if(!this._paused)return this.elapsedDuration=t.currentTime-this.startTime-this.pausedDuration,0===this.duration?this.alpha=1:this.alpha=bo(0,1,this.elapsedDuration/this.duration),this._tick(t),this.done&&this._resolveList.forEach(function(t){return t()}),this.done},Ug.prototype.pause=function(t){t&&(this._hold=!0),-1===this.pausedTime&&(this.pausedTime=window.performance.now()),this._paused=!0},Ug.prototype.resume=function(t){!t&&this._hold||(this.pausedDuration+=window.performance.now()-this.pausedTime,this._paused=!1,this._hold=!1,this.pausedTime=-1)},Ug.prototype.toggle=function(){this._paused?this.resume():this.pause()},Ug.prototype.then=function(t){var e=this;return(this.done?Promise.resolve():new Promise(function(t){return e._resolveList.push(t)})).then(t)},Object.defineProperties(Ug.prototype,jg);var Vg=function(t){function e(e){for(var i=[],r=arguments.length-1;r-- >0;)i[r]=arguments[r+1];t.apply(this,[Nn(e,1/0)].concat(i))}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype._init=function(t,e){Array.isArray(t)?this.axis=(new v).fromArray(t):this.axis=Nn(t,new v(0,1,0)),this.angle=Nn(e,.01)},e.prototype._tick=function(t){this.axis&&this.angle&&this.controls.spin(this.axis,this.angle*t.lastDuration/16)},e}(Ug),Gg=function(t){function e(e){for(var i=[],r=arguments.length-1;r-- >0;)i[r]=arguments[r+1];t.apply(this,[Nn(e,1/0)].concat(i))}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype._init=function(t,e,i){Array.isArray(t)?this.axis=(new v).fromArray(t):this.axis=Nn(t,new v(0,1,0)),this.angleStep=Nn(e,.01),this.angleEnd=Nn(i,.2),this.angleSum=0,this.direction=1},e.prototype._tick=function(t){if(this.axis&&this.angleStep&&this.angleEnd){var e=bo(0,1,Math.abs(this.angleSum)/this.angleEnd),i=this.angleStep*this.direction*(1.1-e);this.controls.spin(this.axis,i*t.lastDuration/16),this.angleSum+=this.angleStep,this.angleSum>=this.angleEnd&&(this.direction*=-1,this.angleSum=-this.angleEnd)}},e}(Ug),$g=function(t){function e(){t.apply(this,arguments)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype._init=function(t,e){this.moveFrom=ro(Nn(t,new v)),this.moveTo=ro(Nn(e,new v))},e.prototype._tick=function(){this.controls.position.lerpVectors(this.moveFrom,this.moveTo,this.alpha).negate(),this.controls.changed()},e}(Ug),Hg=function(t){function e(){t.apply(this,arguments)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype._init=function(t,e){this.zoomFrom=t,this.zoomTo=e},e.prototype._tick=function(){this.controls.distance(vo(this.zoomFrom,this.zoomTo,this.alpha))},e}(Ug),Wg=function(t){function e(){t.apply(this,arguments)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype._init=function(t,e){this.rotateFrom=oo(t),this.rotateTo=oo(e),this._currentRotation=new g},e.prototype._tick=function(){this._currentRotation.copy(this.rotateFrom).slerp(this.rotateTo,this.alpha),this.controls.rotate(this._currentRotation)},e}(Ug),Xg=function(t){function e(){t.apply(this,arguments)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype._init=function(t,e,i){this.valueFrom=t,this.valueTo=e,this.callback=i},e.prototype._tick=function(){this.callback(vo(this.valueFrom,this.valueTo,this.alpha))},e}(Ug),qg=function(t){function e(){t.apply(this,arguments)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype._init=function(t){this.callback=t},e.prototype._tick=function(){1===this.alpha&&this.callback()},e}(Ug),Yg=function(t){this._list=t||[],this._resolveList=[]},Zg={done:{configurable:!0}};Zg.done.get=function(){return this._list.every(function(t){return t.done})},Yg.prototype.then=function(t){var e=this;return(this.done?Promise.resolve():new Promise(function(t){e._resolveList.push(t),e._list.forEach(function(t){t.then(function(){e._resolveList.forEach(function(t){t()}),e._resolveList.length=0})})})).then(t)},Object.defineProperties(Yg.prototype,Zg);var Kg=function(t){this.stage=t,this.viewer=t.viewer,this.controls=t.viewerControls,this.animationList=[],this.finishedList=[]},Qg={paused:{configurable:!0}};Qg.paused.get=function(){return this.animationList.every(function(t){return t.paused})},Kg.prototype.add=function(t){return 0===t.duration?t.tick(this.viewer.stats):this.animationList.push(t),t},Kg.prototype.remove=function(t){var e=this.animationList,i=e.indexOf(t);i>-1&&e.splice(i,1)},Kg.prototype.run=function(t){for(var e=this,i=this.finishedList,r=this.animationList,n=r.length,o=0;o<n;++o){var a=r[o];a.tick(t)&&i.push(a)}var s=i.length;if(s){for(var c=0;c<s;++c)e.remove(i[c]);i.length=0}},Kg.prototype.spin=function(t,e,i){return this.add(new Vg(i,this.controls,t,e))},Kg.prototype.rock=function(t,e,i,r){return this.add(new Gg(r,this.controls,t,e,i))},Kg.prototype.rotate=function(t,e){var i=this.viewer.rotationGroup.quaternion.clone();return this.add(new Wg(e,this.controls,i,t))},Kg.prototype.move=function(t,e){var i=this.controls.position.clone().negate();return this.add(new $g(e,this.controls,i,t))},Kg.prototype.zoom=function(t,e){var i=this.viewer.camera.position.z;return this.add(new Hg(e,this.controls,i,t))},Kg.prototype.zoomMove=function(t,e,i){return new Yg([this.move(t,i),this.zoom(e,i)])},Kg.prototype.orient=function(t,e){var i=new v,r=new g,n=new v;return no(t).decompose(i,r,n),new Yg([this.move(i.negate(),e),this.rotate(r,e),this.zoom(-n.x,e)])},Kg.prototype.value=function(t,e,i,r){return this.add(new Xg(r,this.controls,t,e,i))},Kg.prototype.timeout=function(t,e){return this.add(new qg(e,this.controls,t))},Kg.prototype.spinComponent=function(t,e,i,r){return this.add(new Vg(r,t.controls,e,i))},Kg.prototype.rockComponent=function(t,e,i,r,n){return this.add(new Gg(n,t.controls,e,i,r))},Kg.prototype.moveComponent=function(t,e,i){var r=t.controls.position.clone().negate();return this.add(new $g(i,t.controls,r,e))},Kg.prototype.pause=function(){this.animationList.forEach(function(t){return t.pause()})},Kg.prototype.resume=function(){this.animationList.forEach(function(t){return t.resume()})},Kg.prototype.toggle=function(){this.paused?this.resume():this.pause()},Kg.prototype.clear=function(){this.animationList.length=0},Kg.prototype.dispose=function(){this.clear()},Object.defineProperties(Kg.prototype,Qg);var Jg=function(){};Jg.zoomScroll=function(t,e){t.trackballControls.zoom(e)},Jg.clipNearScroll=function(t,e){var i=t.getParameters();t.setParameters({clipNear:i.clipNear+e/10})},Jg.focusScroll=function(t,e){var i=2*t.getParameters().clipNear,r=Math.sign(e)*xo((100-i)/10,5,.2);t.setFocus(i+r)},Jg.isolevelScroll=function(t,e){var i=Math.sign(e)/5;t.eachRepresentation(function(t){if("surface"===t.repr.type){var e=t.getParameters().isolevel;t.setParameters({isolevel:e+i})}},"volume")},Jg.panDrag=function(t,e,i){t.trackballControls.pan(e,i)},Jg.rotateDrag=function(t,e,i){t.trackballControls.rotate(e,i)},Jg.zoomDrag=function(t,e,i){t.trackballControls.zoom((e+i)/-2)},Jg.zoomFocusDrag=function(t,e,i){t.trackballControls.zoom((e+i)/-2);var r=t.viewer.camera.position.z;t.setFocus(100-Math.abs(r/8))},Jg.panComponentDrag=function(t,e,i){t.trackballControls.panComponent(e,i)},Jg.panAtomDrag=function(t,e,i){t.trackballControls.panAtom(e,i)},Jg.rotateComponentDrag=function(t,e,i){t.trackballControls.rotateComponent(e,i)},Jg.movePick=function(t,e){e&&t.animationControls.move(e.position.clone())},Jg.tooltipPick=function(t,e){var i=t.tooltip;if(t.getParameters().tooltip&&e){var r=e.mouse.position;i.innerText=e.getLabel(),i.style.bottom=window.innerHeight-r.y+3+"px",i.style.left=r.x+3+"px",i.style.display="block"}else i.style.display="none"};var tv={default:[["scroll",Jg.zoomScroll],["scroll-ctrl",Jg.clipNearScroll],["scroll-shift",Jg.focusScroll],["scroll-alt",Jg.isolevelScroll],["drag-right",Jg.panDrag],["drag-left",Jg.rotateDrag],["drag-middle",Jg.zoomDrag],["drag-shift-right",Jg.zoomDrag],["drag-left+right",Jg.zoomDrag],["drag-ctrl-right",Jg.panComponentDrag],["drag-ctrl-left",Jg.rotateComponentDrag],["clickPick-middle",Jg.movePick],["clickPick-shift-left",Jg.movePick],["hoverPick",Jg.tooltipPick]],pymol:[["drag-left",Jg.rotateDrag],["drag-middle",Jg.panDrag],["drag-right",Jg.zoomDrag],["drag-shift-right",Jg.focusScroll],["clickPick-ctrl+shift-middle",Jg.movePick],["hoverPick",Jg.tooltipPick]],coot:[["scroll",Jg.isolevelScroll],["drag-left",Jg.rotateDrag],["drag-middle",Jg.panDrag],["drag-ctrl-left",Jg.panDrag],["drag-right",Jg.zoomFocusDrag],["drag-ctrl-right",Jg.focusScroll],["clickPick-middle",Jg.movePick],["hoverPick",Jg.tooltipPick]]},ev=function(t,e){var i=e||{};this.stage=t,this.mouse=t.mouseObserver,this.actionList=[],this.disabled=i.disabled||!1,this.preset(i.preset||"default")};ev.prototype.run=function(t){for(var e=this,i=[],r=arguments.length-1;r-- >0;)i[r]=arguments[r+1];if(!this.disabled){var n=this.mouse.key||0,o=this.mouse.buttons||0;this.actionList.forEach(function(r){r.type===t&&r.key===n&&r.button===o&&r.callback.apply(r,[e.stage].concat(i))})}},ev.prototype.add=function(t,e){var i=wa(t),r=i[0],n=i[1],o=i[2];this.actionList.push({type:r,key:n,button:o,callback:e})},ev.prototype.remove=function(t,e){var i=t.includes("*"),r=wa(t),n=r[0],o=r[1],a=r[2],s=this.actionList.filter(function(t){return!((t.type===n||i&&""===n)&&(t.key===o||i&&0===o)&&(t.button===a||i&&0===a)&&(t.callback===e||void 0===e))});this.actionList=s},ev.prototype.preset=function(t){var e=this;this.clear(),(tv[t]||[]).forEach(function(t){return(i=e).add.apply(i,t);var i})},ev.prototype.clear=function(){this.actionList.length=0};var iv=function(){};iv.autoView=function(t){t.autoView(1e3)},iv.toggleAnimations=function(t){t.animationControls.toggle()},iv.toggleRock=function(t){t.toggleRock()};var rv={default:[["i",iv.toggleSpin=function(t){t.toggleSpin()}],["k",iv.toggleRock],["p",iv.toggleAnimations],["r",iv.autoView]]},nv=function(t,e){var i=e||{};this.stage=t,this.actionList=[],this.disabled=i.disabled||!1,this.preset(i.preset||"default")};nv.prototype.run=function(t){var e=this;this.disabled||this.actionList.forEach(function(i){i.keyCode===t&&i.callback(e.stage)})},nv.prototype.add=function(t,e){var i=t.charCodeAt(0);this.actionList.push({keyCode:i,callback:e})},nv.prototype.remove=function(t,e){var i=t.charCodeAt(0),r=this.actionList.filter(function(t){return!(t.keyCode===i&&(t.callback===e||void 0===e))});this.actionList=r},nv.prototype.preset=function(t){var e=this;this.clear(),(rv[t]||[]).forEach(function(t){return(i=e).add.apply(i,t);var i})},nv.prototype.clear=function(){this.actionList.length=0};var ov=function(t){this.stage=t,this.mouse=t.mouseObserver,this.controls=t.mouseControls,this.mouse.signals.clicked.add(this._onClick,this),this.mouse.signals.hovered.add(this._onHover,this)};ov.prototype._onClick=function(t,e){var i=this.stage.pickingControls.pick(t,e);this.stage.signals.clicked.dispatch(i),this.controls.run("clickPick",i)},ov.prototype._onHover=function(t,e){var i=this.stage.pickingControls.pick(t,e);i&&this.mouse.down.equals(this.mouse.position)&&(this.stage.transformComponent=i.component,this.stage.transformAtom=i.atom),this.stage.signals.hovered.dispatch(i),this.controls.run("hoverPick",i)},ov.prototype.dispose=function(){this.mouse.signals.clicked.remove(this._onClick,this),this.mouse.signals.hovered.remove(this._onHover,this)};var av=function(t){this.stage=t,this.mouse=t.mouseObserver,this.controls=t.mouseControls,this.mouse.signals.moved.add(this._onMove,this),this.mouse.signals.scrolled.add(this._onScroll,this),this.mouse.signals.dragged.add(this._onDrag,this),this.mouse.signals.clicked.add(this._onClick,this),this.mouse.signals.hovered.add(this._onHover,this),this.mouse.signals.doubleClicked.add(this._onDblclick,this)};av.prototype._onMove=function(){this.stage.tooltip.style.display="none"},av.prototype._onScroll=function(t){this.controls.run("scroll",t)},av.prototype._onDrag=function(t,e){this.controls.run("drag",t,e)},av.prototype._onClick=function(t,e){this.controls.run("click",t,e)},av.prototype._onDblclick=function(t,e){this.controls.run("doubleClick",t,e)},av.prototype._onHover=function(t,e){this.controls.run("hover",t,e)},av.prototype.dispose=function(){this.mouse.signals.moved.remove(this._onMove,this),this.mouse.signals.scrolled.remove(this._onScroll,this),this.mouse.signals.dragged.remove(this._onDrag,this),this.mouse.signals.clicked.remove(this._onClick,this),this.mouse.signals.hovered.remove(this._onHover,this)};var sv=function(t){this.viewer=t.viewer,this.animationControls=t.animationControls,this.viewer.signals.ticked.add(this._onTick,this)};sv.prototype._onTick=function(t){this.animationControls.run(t)},sv.prototype.dispose=function(){this.viewer.signals.ticked.remove(this._onTick,this)};var cv=!!pm&&{passive:!0},uv=function(t){this.stage=t,this.controls=t.keyControls,this.domElement=t.viewer.renderer.domElement,this.domElement.setAttribute("tabIndex","-1"),this.domElement.style.outline="none",this.domElement.autofocus=!0,this.domElement.focus(),this._focusDomElement=this._focusDomElement.bind(this),this._onKeydown=this._onKeydown.bind(this),this._onKeyup=this._onKeyup.bind(this),this._onKeypress=this._onKeypress.bind(this),this.domElement.addEventListener("mousedown",this._focusDomElement),this.domElement.addEventListener("touchstart",this._focusDomElement,cv),this.domElement.addEventListener("keydown",this._onKeydown),this.domElement.addEventListener("keyup",this._onKeyup),this.domElement.addEventListener("keypress",this._onKeypress)};uv.prototype._onKeydown=function(){},uv.prototype._onKeyup=function(){},uv.prototype._onKeypress=function(t){this.controls.run(t.keyCode)},uv.prototype._focusDomElement=function(){this.domElement.focus()},uv.prototype.dispose=function(){this.domElement.removeEventListener("mousedown",this._focusDomElement),this.domElement.removeEventListener("touchstart",this._focusDomElement,cv),this.domElement.removeEventListener("keydown",this._onKeypress),this.domElement.removeEventListener("keyup",this._onKeypress),this.domElement.removeEventListener("keypress",this._onKeypress)};var lv=function(t,e,i,r){var n=r||{};this.offsetX=Nn(n.offsetX,0),this.offsetY=Nn(n.offsetY,0),this.visible=Nn(n.visible,!0),this.component=t,this.stage=t.stage,this.viewer=this.stage.viewer,this.position=e,this._viewerPosition=new v,this._updateViewerPosition(),this._canvasPosition=new v,this._cameraPosition=new v,this.element=document.createElement("div"),Object.assign(this.element.style,{display:"block",position:"fixed",zIndex:1+(parseInt(this.viewer.container.style.zIndex)||0),pointerEvents:"none",backgroundColor:"rgba( 0, 0, 0, 0.6 )",color:"lightgrey",padding:"8px",fontFamily:"sans-serif",left:"-10000px"}),this.viewer.container.appendChild(this.element),this.setContent(i),this.updateVisibility(),this.viewer.signals.ticked.add(this._update,this),this.component.signals.matrixChanged.add(this._updateViewerPosition,this)};lv.prototype.setContent=function(t){var e=this.element.style.display;"none"===e&&(this.element.style.left="-10000px",this.element.style.display="block"),t instanceof window.Element?(this.element.innerHTML="",this.element.appendChild(t)):this.element.innerHTML=t,this._clientRect=this.element.getBoundingClientRect(),"none"===e&&(this.element.style.display=e)},lv.prototype.setVisibility=function(t){this.visible=t,this.updateVisibility()},lv.prototype.getVisibility=function(){return this.visible&&this.component.visible},lv.prototype.updateVisibility=function(){this.element.style.display=this.getVisibility()?"block":"none"},lv.prototype._updateViewerPosition=function(){this._viewerPosition.copy(this.position).applyMatrix4(this.component.matrix)},lv.prototype._update=function(){if(this.getVisibility()){var t=this.element.style,e=this._canvasPosition,i=this._viewerPosition,r=this._clientRect;this._cameraPosition.copy(i).add(this.viewer.translationGroup.position).applyMatrix4(this.viewer.rotationGroup.matrix).sub(this.viewer.camera.position),this._cameraPosition.z<0?t.display="none":(t.display="block",t.opacity=1-bo(this.viewer.scene.fog.near,this.viewer.scene.fog.far,this._cameraPosition.length()),this.stage.viewerControls.getPositionOnCanvas(i,e),t.bottom=this.offsetX+e.y+r.height/2+"px",t.left=this.offsetY+e.x-r.width/2+"px")}},lv.prototype.dispose=function(){this.viewer.container.removeChild(this.element),this.viewer.signals.ticked.remove(this._update,this),this.component.signals.matrixChanged.remove(this._updateViewerPosition,this)};var hv=new y,pv=new v,dv=new g,fv=function(t){this.component=t,this.stage=t.stage,this.viewer=t.stage.viewer,this.signals={changed:new So}},mv={position:{configurable:!0},rotation:{configurable:!0}};mv.position.get=function(){return this.component.position},mv.rotation.get=function(){return this.component.quaternion},fv.prototype.changed=function(){this.component.updateMatrix(),this.viewer.requestRender(),this.signals.changed.dispatch()},fv.prototype.spin=function(t,e){hv.getInverse(this.viewer.rotationGroup.matrix),pv.copy(ro(t)).applyMatrix4(hv),hv.extractRotation(this.component.transform),hv.premultiply(this.viewer.rotationGroup.matrix),hv.getInverse(hv),pv.copy(ro(t)),pv.applyMatrix4(hv),hv.makeRotationAxis(pv,e),dv.setFromRotationMatrix(hv),this.component.quaternion.premultiply(dv),this.changed()},Object.defineProperties(fv.prototype,mv),Ba.__deps=[Fa],za.__deps=[Fa,ka];var gv=new v,vv=function(){},yv={Picker:{configurable:!0},Buffer:{configurable:!0}};yv.Picker.get=function(){return Cm.get(this.type)},yv.Buffer.get=function(){return Tm.get(this.type)},vv.getShapeKey=function(t){return this.type+t[0].toUpperCase()+t.substr(1)},vv.valueToShape=function(t,e,i){var r=t[this.getShapeKey(e)];switch(this.fields[e]){case"v3":case"c":Ha(i,r);break;default:r.push(i)}},vv.objectToShape=function(t,e){var i=this;Object.keys(this.fields).forEach(function(r){i.valueToShape(t,r,e[r])}),this.valueToShape(t,"name",e.name),this.expandBoundingBox(t.boundingBox,e)},vv.valueFromShape=function(t,e,i){var r=t[this.getShapeKey(i)];switch(this.fields[i]){case"v3":return(new v).fromArray(r,3*e);case"c":return(new et).fromArray(r,3*e);default:return r[e]}},vv.objectFromShape=function(t,e){var i=this,r={shape:t,name:this.valueFromShape(t,e,"name")};return Object.keys(this.fields).forEach(function(n){r[n]=i.valueFromShape(t,e,n)}),r},vv.arrayFromShape=function(t,e){var i=t[this.getShapeKey(e)];switch(this.fields[e]){case"s":return i;default:return new Float32Array(i)}},vv.dataFromShape=function(t){var e=this,i={};return this.Picker&&(i.picking=new this.Picker(t)),Object.keys(this.fields).forEach(function(r){i[r]=e.arrayFromShape(t,r)}),i},vv.bufferFromShape=function(t,e){return new this.Buffer(this.dataFromShape(t),e)},Object.defineProperties(vv,yv);var bv=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={type:{configurable:!0},fields:{configurable:!0}};return i.type.get=function(){return"sphere"},i.fields.get=function(){return{position:"v3",color:"c",radius:"f"}},e.positionFromShape=function(t,e){return this.valueFromShape(t,e,"position")},e.expandBoundingBox=function(t,e){t.expandByPoint(gv.fromArray(e.position))},Object.defineProperties(e,i),e}(vv),xv=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={type:{configurable:!0},fields:{configurable:!0}};return i.type.get=function(){return"box"},i.fields.get=function(){return{position:"v3",color:"c",size:"f",heightAxis:"v3",depthAxis:"v3"}},Object.defineProperties(e,i),e}(bv),_v=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={type:{configurable:!0}};return i.type.get=function(){return"octahedron"},Object.defineProperties(e,i),e}(xv),wv=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={type:{configurable:!0}};return i.type.get=function(){return"tetrahedron"},Object.defineProperties(e,i),e}(xv),Sv=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={type:{configurable:!0},fields:{configurable:!0}};return i.type.get=function(){return"cylinder"},i.fields.get=function(){return{position1:"v3",position2:"v3",color:"c",radius:"f"}},e.positionFromShape=function(t,e){var i=this.valueFromShape(t,e,"position1"),r=this.valueFromShape(t,e,"position2");return i.add(r).multiplyScalar(.5)},e.expandBoundingBox=function(t,e){t.expandByPoint(gv.fromArray(e.position1)),t.expandByPoint(gv.fromArray(e.position2))},Object.defineProperties(e,i),e}(vv),Av=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={type:{configurable:!0}};return i.type.get=function(){return"arrow"},Object.defineProperties(e,i),e}(Sv),Mv=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={type:{configurable:!0}};return i.type.get=function(){return"cone"},Object.defineProperties(e,i),e}(Sv),Pv=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={type:{configurable:!0},fields:{configurable:!0}};return i.type.get=function(){return"ellipsoid"},i.fields.get=function(){return{position:"v3",color:"c",radius:"f",majorAxis:"v3",minorAxis:"v3"}},Object.defineProperties(e,i),e}(bv),Ev=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={type:{configurable:!0}};return i.type.get=function(){return"torus"},Object.defineProperties(e,i),e}(Pv),Tv=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={type:{configurable:!0},fields:{configurable:!0}};return i.type.get=function(){return"text"},i.fields.get=function(){return{position:"v3",color:"c",size:"f",text:"s"}},Object.defineProperties(e,i),e}(bv),Cv=function(t){this.array=t};Cv.prototype.getIndex=function(t){return this.array?this.array[t]:t},Cv.prototype.getObject=function(){return{}},Cv.prototype._applyTransformations=function(t,e,i){return e&&t.applyMatrix4(e.matrix),i&&t.applyMatrix4(i.matrix),t},Cv.prototype._getPosition=function(){return new v},Cv.prototype.getPosition=function(t,e,i){return this._applyTransformations(this._getPosition(t),e,i)};var Iv=function(t){function e(e){t.call(this),this.shape=e}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={primitive:{configurable:!0},data:{configurable:!0},type:{configurable:!0}};return i.primitive.get=function(){},i.data.get=function(){return this.shape},i.type.get=function(){return this.primitive.type},e.prototype.getObject=function(t){return this.primitive.objectFromShape(this.shape,t)},e.prototype._getPosition=function(t){return this.primitive.positionFromShape(this.shape,t)},Object.defineProperties(e.prototype,i),e}(Cv),Rv=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={primitive:{configurable:!0}};return i.primitive.get=function(){return Sv},Object.defineProperties(e.prototype,i),e}(Iv),Lv=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={primitive:{configurable:!0}};return i.primitive.get=function(){return Av},Object.defineProperties(e.prototype,i),e}(Iv),Ov=function(t){function e(e,i){t.call(this,e),this.structure=i}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={type:{configurable:!0},data:{configurable:!0}};return i.type.get=function(){return"atom"},i.data.get=function(){return this.structure},e.prototype.getObject=function(t){return this.structure.getAtomProxy(this.getIndex(t))},e.prototype._getPosition=function(t){return(new v).copy(this.getObject(t))},Object.defineProperties(e.prototype,i),e}(Cv),Dv=function(t){function e(e){t.call(this),this.axes=e}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={type:{configurable:!0},data:{configurable:!0}};return i.type.get=function(){return"axes"},i.data.get=function(){return this.axes},e.prototype.getObject=function(){return{axes:this.axes}},e.prototype._getPosition=function(){return this.axes.center.clone()},Object.defineProperties(e.prototype,i),e}(Cv),Nv=function(t){function e(e,i,r){t.call(this,e),this.structure=i,this.bondStore=r||i.bondStore}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={type:{configurable:!0},data:{configurable:!0}};return i.type.get=function(){return"bond"},i.data.get=function(){return this.structure},e.prototype.getObject=function(t){var e=this.structure.getBondProxy(this.getIndex(t));return e.bondStore=this.bondStore,e},e.prototype._getPosition=function(t){var e=this.getObject(t);return(new v).copy(e.atom1).add(e.atom2).multiplyScalar(.5)},Object.defineProperties(e.prototype,i),e}(Cv),kv=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={type:{configurable:!0}};return i.type.get=function(){return"contact"},Object.defineProperties(e.prototype,i),e}(Nv),Bv=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={primitive:{configurable:!0}};return i.primitive.get=function(){return Mv},Object.defineProperties(e.prototype,i),e}(Iv),Fv=function(t){function e(e,i,r){t.call(this,e),this.validation=i,this.structure=r}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={type:{configurable:!0},data:{configurable:!0}};return i.type.get=function(){return"clash"},i.data.get=function(){return this.validation},e.prototype.getObject=function(t){var e=this.validation,i=this.getIndex(t);return{validation:e,index:i,clash:e.clashArray[i]}},e.prototype._getAtomProxyFromSele=function(t){var e=new rm(t),i=this.structure.getAtomIndices(e)[0];return this.structure.getAtomProxy(i)},e.prototype._getPosition=function(t){var e=this.getObject(t).clash,i=this._getAtomProxyFromSele(e.sele1),r=this._getAtomProxyFromSele(e.sele2);return(new v).copy(i).add(r).multiplyScalar(.5)},Object.defineProperties(e.prototype,i),e}(Cv),zv=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={type:{configurable:!0}};return i.type.get=function(){return"distance"},Object.defineProperties(e.prototype,i),e}(Nv),Uv=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={primitive:{configurable:!0}};return i.primitive.get=function(){return Pv},Object.defineProperties(e.prototype,i),e}(Iv),jv=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={primitive:{configurable:!0}};return i.primitive.get=function(){return _v},Object.defineProperties(e.prototype,i),e}(Iv),Vv=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={primitive:{configurable:!0}};return i.primitive.get=function(){return xv},Object.defineProperties(e.prototype,i),e}(Iv),Gv=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={type:{configurable:!0}};return i.type.get=function(){return"ignore"},Object.defineProperties(e.prototype,i),e}(Cv),$v=function(t){function e(e,i){t.call(this,e),this.mesh=i}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={type:{configurable:!0}};return i.type.get=function(){return"mesh"},e.prototype.getObject=function(){var t=this.mesh;return{shape:this.shape,name:t.name,serial:t.serial}},e.prototype._getPosition=function(){return this.__position||(this.__position=Sa(this.mesh.position)),this.__position},Object.defineProperties(e.prototype,i),e}(Iv),Hv=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={primitive:{configurable:!0}};return i.primitive.get=function(){return bv},Object.defineProperties(e.prototype,i),e}(Iv),Wv=function(t){function e(e,i){t.call(this,e),this.surface=i}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={type:{configurable:!0},data:{configurable:!0}};return i.type.get=function(){return"surface"},i.data.get=function(){return this.surface},e.prototype.getObject=function(t){return{surface:this.surface,index:this.getIndex(t)}},e.prototype._getPosition=function(){return this.surface.center.clone()},Object.defineProperties(e.prototype,i),e}(Cv),Xv=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={primitive:{configurable:!0}};return i.primitive.get=function(){return wv},Object.defineProperties(e.prototype,i),e}(Iv),qv=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={primitive:{configurable:!0}};return i.primitive.get=function(){return Ev},Object.defineProperties(e.prototype,i),e}(Iv),Yv=function(t){function e(e,i){t.call(this),this.unitcell=e,this.structure=i}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={type:{configurable:!0},data:{configurable:!0}};return i.type.get=function(){return"unitcell"},i.data.get=function(){return this.unitcell},e.prototype.getObject=function(){return{unitcell:this.unitcell,structure:this.structure}},e.prototype._getPosition=function(){return this.unitcell.getCenter(this.structure)},Object.defineProperties(e.prototype,i),e}(Cv),Zv=(function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={type:{configurable:!0}};i.type.get=function(){return"unknown"},Object.defineProperties(e.prototype,i)}(Cv),function(t){function e(e,i){t.call(this,e),this.volume=i}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={type:{configurable:!0},data:{configurable:!0}};return i.type.get=function(){return"volume"},i.data.get=function(){return this.volume},e.prototype.getObject=function(t){var e=this.volume,i=this.getIndex(t);return{volume:e,index:i,value:e.data[i]}},e.prototype._getPosition=function(t){var e=this.volume.position,i=this.getIndex(t);return new v(e[3*i],e[3*i+1],e[3*i+2])},Object.defineProperties(e.prototype,i),e}(Cv)),Kv=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={type:{configurable:!0}};return i.type.get=function(){return"slice"},Object.defineProperties(e.prototype,i),e}(Zv);Cm.add("arrow",Lv),Cm.add("box",Vv),Cm.add("cone",Bv),Cm.add("cylinder",Rv),Cm.add("ellipsoid",Uv),Cm.add("octahedron",jv),Cm.add("sphere",Hv),Cm.add("tetrahedron",Xv),Cm.add("torus",qv);var Qv=function(t,e){this.length=t,this._words=new Uint32Array(t+32>>>5),!0===e&&this.setAll()};Qv.prototype.get=function(t){return 0!=(this._words[t>>>5]&1<<t)},Qv.prototype.set=function(t){this._words[t>>>5]|=1<<t},Qv.prototype.clear=function(t){this._words[t>>>5]&=~(1<<t)},Qv.prototype.flip=function(t){this._words[t>>>5]^=1<<t},Qv.prototype._assignRange=function(t,e,i){for(var r=this._words,n=!0===i?4294967295:0,o=t>>>5,a=e>>>5,s=o;s<a;++s)r[s]=n;var c=o<<5,u=a<<5;if(!0===i)if(e-t<32)for(var l=t,h=e+1;l<h;++l)r[l>>>5]|=1<<l;else{for(var p=t,d=c;p<d;++p)r[p>>>5]|=1<<p;for(var f=u,m=e+1;f<m;++f)r[f>>>5]|=1<<f}else if(e-t<32)for(var g=t,v=e+1;g<v;++g)r[g>>>5]&=~(1<<g);else{for(var y=t,b=c;y<b;++y)r[y>>>5]&=~(1<<y);for(var x=u,_=e+1;x<_;++x)r[x>>>5]&=~(1<<x)}return this},Qv.prototype.setRange=function(t,e){return this._assignRange(t,e,!0)},Qv.prototype.clearRange=function(t,e){return this._assignRange(t,e,!1)},Qv.prototype.setBits=function(){for(var t=arguments,e=this._words,i=arguments.length,r=0;r<i;++r){var n=t[r];e[n>>>5]|=1<<n}return this},Qv.prototype.clearBits=function(){for(var t=arguments,e=this._words,i=arguments.length,r=0;r<i;++r){var n=t[r];e[n>>>5]&=~(1<<n)}return this},Qv.prototype.setAll=function(){return this._assignRange(0,this.length-1,!0)},Qv.prototype.clearAll=function(){return this._assignRange(0,this.length-1,!1)},Qv.prototype.flipAll=function(){for(var t=this._words.length,e=this._words,i=32-this.length%32,r=0;r<t-1;++r)e[r]=~e[r];return e[t-1]=~(e[t-1]<<i)>>>i,this},Qv.prototype._isRangeValue=function(t,e,i){for(var r=this._words,n=!0===i?4294967295:0,o=t>>>5,a=e>>>5,s=o;s<a;++s)if(r[s]!==n)return!1;if(e-t<32){for(var c=t,u=e+1;c<u;++c)if(!!(r[c>>>5]&1<<c)!==i)return!1}else{for(var l=a<<5,h=t,p=o<<5<<5;h<p;++h)if(!!(r[h>>>5]&1<<h)!==i)return!1;for(var d=l,f=e+1;d<f;++d)if(!!(r[d>>>5]&1<<d)!==i)return!1}return!0},Qv.prototype.isRangeSet=function(t,e){return this._isRangeValue(t,e,!0)},Qv.prototype.isRangeClear=function(t,e){return this._isRangeValue(t,e,!1)},Qv.prototype.isAllSet=function(){return this._isRangeValue(0,this.length-1,!0)},Qv.prototype.isAllClear=function(){return this._isRangeValue(0,this.length-1,!1)},Qv.prototype.isSet=function(){for(var t=arguments,e=this._words,i=arguments.length,r=0;r<i;++r){var n=t[r];if(0==(e[n>>>5]&1<<n))return!1}return!0},Qv.prototype.isClear=function(){for(var t=arguments,e=this._words,i=arguments.length,r=0;r<i;++r){var n=t[r];if(0!=(e[n>>>5]&1<<n))return!1}return!0},Qv.prototype.isEqualTo=function(t){for(var e=this._words,i=t._words,r=Math.min(e.length,i.length),n=0;n<r;++n)if(e[n]!==i[n])return!1;return!0},Qv.prototype.getSize=function(){for(var t=this._words.length,e=this._words,i=0,r=0;r<t;++r)i+=Wa(e[r]);return i},Qv.prototype.difference=function(t){for(var e=this._words,i=t._words,r=Math.min(e.length,i.length),n=0;n<r;++n)e[n]=e[n]&~i[n];for(var o=e.length;o<r;++o)e[o]=0;return this},Qv.prototype.union=function(t){for(var e=this._words,i=t._words,r=Math.min(e.length,i.length),n=0;n<r;++n)e[n]|=i[n];for(var o=e.length;o<r;++o)e[o]=0;return this},Qv.prototype.intersection=function(t){for(var e=this._words,i=t._words,r=Math.min(e.length,i.length),n=0;n<r;++n)e[n]&=i[n];for(var o=e.length;o<r;++o)e[o]=0;return this},Qv.prototype.intersects=function(t){for(var e=this._words,i=t._words,r=Math.min(e.length,i.length),n=0;n<r;++n)if(0!=(e[n]&i[n]))return!0;return!1},Qv.prototype.getIntersectionSize=function(t){for(var e=this._words,i=t._words,r=Math.min(e.length,i.length),n=0,o=0;o<r;++o)n+=Wa(e[o]&i[o]);return n},Qv.prototype.makeIntersection=function(t){var e=this._words,i=t._words,r=Math.min(e.length,i.length),n=new Uint32Array(r),o=Object.create(Qv.prototype);o._words=n,o.length=Math.min(this.length,t.length);for(var a=0;a<r;++a)n[a]=e[a]&i[a];return o},Qv.prototype.forEach=function(t){for(var e=this._words.length,i=this._words,r=0,n=0;n<e;++n)for(var o=i[n];0!==o;){var a=o&-o;t((n<<5)+Wa(a-1),r),o^=a,++r}},Qv.prototype.toArray=function(){for(var t=this._words,e=new Array(this.getSize()),i=this._words.length,r=0,n=0;n<i;++n)for(var o=t[n];0!==o;){var a=o&-o;e[r++]=(n<<5)+Wa(a-1),o^=a}return e},Qv.prototype.toString=function(){return"{"+this.toArray().join(",")+"}"},Qv.prototype.toSeleString=function(){var t=this.toArray().join(",");return t?"@"+t:"NONE"},Qv.prototype.clone=function(){var t=Object.create(Qv.prototype);return t.length=this.length,t._words=new Uint32Array(this._words),t};var Jv=0,ty=1,ey=2,iy=3,ry=4,ny=0,oy=["D-BETA-PEPTIDE, C-GAMMA LINKING","D-GAMMA-PEPTIDE, C-DELTA LINKING","D-PEPTIDE COOH CARBOXY TERMINUS","D-PEPTIDE NH3 AMINO TERMINUS","D-PEPTIDE LINKING","L-BETA-PEPTIDE, C-GAMMA LINKING","L-GAMMA-PEPTIDE, C-DELTA LINKING","L-PEPTIDE COOH CARBOXY TERMINUS","L-PEPTIDE NH3 AMINO TERMINUS","L-PEPTIDE LINKING","PEPTIDE LINKING","PEPTIDE-LIKE"],ay=["RNA OH 3 PRIME TERMINUS","RNA OH 5 PRIME TERMINUS","RNA LINKING"],sy=["DNA OH 3 PRIME TERMINUS","DNA OH 5 PRIME TERMINUS","DNA LINKING","L-DNA LINKING","L-RNA LINKING"],cy=["D-SACCHARIDE","D-SACCHARIDE 1,4 AND 1,4 LINKING","D-SACCHARIDE 1,4 AND 1,6 LINKING","L-SACCHARIDE","L-SACCHARIDE 1,4 AND 1,4 LINKING","L-SACCHARIDE 1,4 AND 1,6 LINKING","SACCHARIDE"],uy=["OTHER"],ly=["NON-POLYMER"].concat(uy,cy),hy=["h","g","i"],py=["e","b"],dy=["s","t","l",""],fy={H:1.1,HE:1.4,LI:1.81,BE:1.53,B:1.92,C:1.7,N:1.55,O:1.52,F:1.47,NE:1.54,NA:2.27,MG:1.73,AL:1.84,SI:2.1,P:1.8,S:1.8,CL:1.75,AR:1.88,K:2.75,CA:2.31,SC:2.3,TI:2.15,V:2.05,CR:2.05,MN:2.05,FE:2.05,CO:2,NI:2,CU:2,ZN:2.1,GA:1.87,GE:2.11,AS:1.85,SE:1.9,BR:1.83,KR:2.02,RB:3.03,SR:2.49,Y:2.4,ZR:2.3,NB:2.15,MO:2.1,TC:2.05,RU:2.05,RH:2,PD:2.05,AG:2.1,CD:2.2,IN:2.2,SN:1.93,SB:2.17,TE:2.06,I:1.98,XE:2.16,CS:3.43,BA:2.68,LA:2.5,CE:2.48,PR:2.47,ND:2.45,PM:2.43,SM:2.42,EU:2.4,GD:2.38,TB:2.37,DY:2.35,HO:2.33,ER:2.32,TM:2.3,YB:2.28,LU:2.27,HF:2.25,TA:2.2,W:2.1,RE:2.05,OS:2,IR:2,PT:2.05,AU:2.1,HG:2.05,TL:1.96,PB:2.02,BI:2.07,PO:1.97,AT:2.02,RN:2.2,FR:3.48,RA:2.83,AC:2,TH:2.4,PA:2,U:2.3,NP:2,PU:2,AM:2,CM:2,BK:2,CF:2,ES:2,FM:2,MD:2,NO:2,LR:2,RF:2,DB:2,SG:2,BH:2,HS:2,MT:2,DS:2,RG:2,CN:2,UUT:2,FL:2,UUP:2,LV:2,UUH:2},my={H:.31,HE:.28,LI:1.28,BE:.96,B:.84,C:.76,N:.71,O:.66,F:.57,NE:.58,NA:1.66,MG:1.41,AL:1.21,SI:1.11,P:1.07,S:1.05,CL:1.02,AR:1.06,K:2.03,CA:1.76,SC:1.7,TI:1.6,V:1.53,CR:1.39,MN:1.39,FE:1.32,CO:1.26,NI:1.24,CU:1.32,ZN:1.22,GA:1.22,GE:1.2,AS:1.19,SE:1.2,BR:1.2,KR:1.16,RB:2.2,SR:1.95,Y:1.9,ZR:1.75,NB:1.64,MO:1.54,TC:1.47,RU:1.46,RH:1.42,PD:1.39,AG:1.45,CD:1.44,IN:1.42,SN:1.39,SB:1.39,TE:1.38,I:1.39,XE:1.4,CS:2.44,BA:2.15,LA:2.07,CE:2.04,PR:2.03,ND:2.01,PM:1.99,SM:1.98,EU:1.98,GD:1.96,TB:1.94,DY:1.92,HO:1.92,ER:1.89,TM:1.9,YB:1.87,LU:1.87,HF:1.75,TA:1.7,W:1.62,RE:1.51,OS:1.44,IR:1.41,PT:1.36,AU:1.36,HG:1.32,TL:1.45,PB:1.46,BI:1.48,PO:1.4,AT:1.5,RN:1.5,FR:2.6,RA:2.21,AC:2.15,TH:2.06,PA:2,U:1.96,NP:1.9,PU:1.87,AM:1.8,CM:1.69,BK:1.6,CF:1.6,ES:1.6,FM:1.6,MD:1.6,NO:1.6,LR:1.6,RF:1.6,DB:1.6,SG:1.6,BH:1.6,HS:1.6,MT:1.6,DS:1.6,RG:1.6,CN:1.6,UUT:1.6,FL:1.6,UUP:1.6,LV:1.6,UUH:1.6},gy={ALA:[.17,.5,.33],ARG:[.81,1.81,1],ASN:[.42,.85,.43],ASP:[1.23,3.64,2.41],ASH:[-.07,.43,.5],CYS:[-.24,-.02,.22],GLN:[.58,.77,.19],GLU:[2.02,3.63,1.61],GLH:[-.01,.11,.12],GLY:[.01,1.15,1.14],HIS:[.17,.11,-.06],ILE:[-.31,-1.12,-.81],LEU:[-.56,-1.25,-.69],LYS:[.99,2.8,1.81],MET:[-.23,-.67,-.44],PHE:[-1.13,-1.71,-.58],PRO:[.45,.14,-.31],SER:[.13,.46,.33],THR:[.14,.25,.11],TRP:[-1.85,-2.09,-.24],TYR:[-.94,-.71,.23],VAL:[.07,-.46,-.53]},vy=[0,0,0],yy={HIS:"H",ARG:"R",LYS:"K",ILE:"I",PHE:"F",LEU:"L",TRP:"W",ALA:"A",MET:"M",PRO:"P",CYS:"C",ASN:"N",VAL:"V",GLY:"G",SER:"S",GLN:"Q",TYR:"Y",ASP:"D",GLU:"E",THR:"T",ASH:"D",GLH:"E",UNK:""},by=Object.keys(yy),xy=["A","C","T","G","U"],_y=["DA","DC","DT","DG","DU","TCY","MCY","5CM"],wy=["A","G","DA","DG"],Sy=["SOL","WAT","HOH","H2O","W","DOD","D3O","TIP3","TIP4","SPC"],Ay=["118","119","1AL","1CU","2FK","2HP","2OF","3CO","3MT","3NI","3OF","3P8","4MO","4PU","543","6MO","ACT","AG","AL","ALF","AM","ATH","AU","AU3","AUC","AZI","BA","BCT","BEF","BF4","BO4","BR","BS3","BSY","CA","CAC","CD","CD1","CD3","CD5","CE","CHT","CL","CO","CO3","CO5","CON","CR","CS","CSB","CU","CU1","CU3","CUA","CUZ","CYN","DME","DMI","DSC","DTI","DY","E4N","EDR","EMC","ER3","EU","EU3","F","FE","FE2","FPO","GA","GD3","GEP","HAI","HG","HGC","IN","IOD","IR","IR3","IRI","IUM","K","KO4","LA","LCO","LCP","LI","LU","MAC","MG","MH2","MH3","MLI","MLT","MMC","MN","MN3","MN5","MN6","MO1","MO2","MO3","MO4","MO5","MO6","MOO","MOS","MOW","MW1","MW2","MW3","NA","NA2","NA5","NA6","NAO","NAW","NCO","NET","NH4","NI","NI1","NI2","NI3","NO2","NO3","NRU","O4M","OAA","OC1","OC2","OC3","OC4","OC5","OC6","OC7","OC8","OCL","OCM","OCN","OCO","OF1","OF2","OF3","OH","OS","OS4","OXL","PB","PBM","PD","PDV","PER","PI","PO3","PO4","PR","PT","PT4","PTN","RB","RH3","RHD","RU","SB","SCN","SE4","SEK","SM","SMO","SO3","SO4","SR","T1A","TB","TBA","TCN","TEA","TH","THE","TL","TMA","TRA","UNX","V","VN3","VO4","W","WO5","Y1","YB","YB2","YH","YT3","ZCM","ZN","ZN2","ZN3","ZNO","ZO3","OHX"],My=["045","0AT","0BD","0MK","0NZ","0TS","0V4","0XY","0YT","10M","147","149","14T","15L","16G","18T","18Y","1AR","1BW","1GL","1GN","1JB","1LL","1NA","1S3","26M","26Q","26R","26V","26W","26Y","27C","289","291","293","2DG","2F8","2FG","2FL","2FP","2GL","2M4","2M5","32O","34V","3CM","3DO","3DY","3FM","3LR","3MF","3MG","3SA","3ZW","46D","46M","46Z","48Z","4CQ","4GC","4NN","50A","5DI","5GF","5MM","5RP","5SA","5SP","64K","6PG","6SA","7JZ","7SA","A1Q","A2G","AAB","AAL","AAO","ABC","ABD","ABE","ABF","ABL","ACG","ACI","ACR","ACX","ADA","ADG","ADR","AF1","AFD","AFL","AFO","AFP","AFR","AGC","AGH","AGL","AHR","AIG","ALL","ALX","AMU","AOG","AOS","ARA","ARB","ARE","ARI","ASG","ASO","AXP","AXR","B0D","B16","B2G","B4G","B6D","B8D","B9D","BBK","BCD","BDG","BDP","BDR","BEM","BFP","BGC","BGL","BGP","BGS","BHG","BMA","BMX","BNG","BNX","BOG","BRI","BXF","BXP","BXX","BXY","C3X","C4X","C5X","CAP","CBI","CBK","CBS","CDR","CEG","CGF","CHO","CR1","CR6","CRA","CT3","CTO","CTR","CTT","D6G","DAF","DAG","DDA","DDB","DDL","DEL","DFR","DFX","DG0","DGC","DGD","DGM","DGS","DIG","DLF","DLG","DMU","DNO","DOM","DP5","DQQ","DQR","DR2","DR3","DR4","DRI","DSR","DT6","DVC","E4P","E5G","EAG","EBG","EBQ","EGA","EJT","EPG","ERE","ERI","F1P","F1X","F6P","FBP","FCA","FCB","FCT","FDP","FDQ","FFC","FIX","FMO","FRU","FSI","FU4","FUB","FUC","FUD","FUL","FXP","G16","G1P","G2F","G3I","G4D","G4S","G6D","G6P","G6S","GAC","GAD","GAL","GC1","GC4","GCD","GCN","GCO","GCS","GCT","GCU","GCV","GCW","GCX","GE1","GFG","GFP","GIV","GL0","GL2","GL5","GL6","GL7","GL9","GLA","GLB","GLC","GLD","GLF","GLG","GLO","GLP","GLS","GLT","GLW","GMH","GN1","GNX","GP1","GP4","GPH","GPM","GQ1","GQ2","GQ4","GS1","GS4","GSA","GSD","GTE","GTH","GTK","GTR","GTZ","GU0","GU1","GU2","GU3","GU4","GU5","GU6","GU8","GU9","GUF","GUP","GUZ","GYP","GYV","H2P","HDL","HMS","HS2","HSD","HSG","HSH","HSJ","HSQ","HSR","HSU","HSX","HSY","HSZ","IAB","IDG","IDR","IDS","IDT","IDU","IDX","IDY","IMK","IN1","IPT","ISL","KBG","KD2","KDA","KDM","KDO","KFN","KO1","KO2","KTU","L6S","LAG","LAI","LAK","LAO","LAT","LB2","LBT","LCN","LDY","LGC","LGU","LM2","LMT","LMU","LOG","LOX","LPK","LSM","LTM","LVZ","LXB","LXZ","M1F","M3M","M6P","M8C","MA1","MA2","MA3","MAB","MAG","MAL","MAN","MAT","MAV","MAW","MBG","MCU","MDA","MDM","MDP","MFA","MFB","MFU","MG5","MGA","MGL","MLB","MMA","MMN","MN0","MRP","MTT","MUG","MVP","MXY","N1L","N9S","NAA","NAG","NBG","NDG","NED","NG1","NG6","NGA","NGB","NGC","NGE","NGF","NGL","NGS","NGY","NHF","NM6","NM9","NTF","NTO","NTP","NXD","NYT","OPG","OPM","ORP","OX2","P3M","P53","P6P","PA5","PNA","PNG","PNW","PRP","PSJ","PSV","PTQ","QDK","QPS","QV4","R1P","R1X","R2B","R5P","RAA","RAE","RAF","RAM","RAO","RAT","RB5","RBL","RCD","RDP","REL","RER","RF5","RG1","RGG","RHA","RIB","RIP","RNS","RNT","ROB","ROR","RPA","RST","RUB","RUU","RZM","S6P","S7P","SA0","SCR","SDD","SF6","SF9","SG4","SG5","SG6","SG7","SGA","SGC","SGD","SGN","SGS","SHB","SHG","SI3","SIO","SOE","SOL","SSG","SUC","SUP","SUS","T6P","T6T","TAG","TCB","TDG","TGK","TGY","TH1","TIA","TM5","TM6","TM9","TMR","TMX","TOA","TOC","TRE","TYV","UCD","UDC","VG1","X0X","X1X","X2F","X4S","X5S","X6X","XBP","XDN","XDP","XIF","XIM","XLF","XLS","XMM","XUL","XXR","XYP","XYS","YO5","Z3Q","Z6J","Z9M","ZDC","ZDM"],Py=["CA","C","N","O","O1","O2","OC1","OC2","OX1","OXT","H","H1","H2","H3","HA","HN","BB"],Ey=["P","O3'","O5'","C5'","C4'","C3'","OP1","OP2","O3*","O5*","C5*","C4*","C3*"],Ty={};Ty[1]={trace:"CA",direction1:"C",direction2:["O","OC1","O1","OX1","OXT"],backboneStart:"N",backboneEnd:"C"},Ty[2]={trace:["C4'","C4*"],direction1:["C1'","C1*"],direction2:["C3'","C3*"],backboneStart:"P",backboneEnd:["O3'","O3*"]},Ty[3]={trace:["C3'","C3*"],direction1:["C2'","C2*"],direction2:["O4'","O4*"],backboneStart:"P",backboneEnd:["O3'","O3*"]},Ty[4]={trace:["CA","BB"],backboneStart:["CA","BB"],backboneEnd:["CA","BB"]},Ty[5]={trace:["C4'","C4*","P"],backboneStart:["C4'","C4*","P"],backboneEnd:["C4'","C4*","P"]},Ty[6]={trace:["C3'","C3*","C2'","P"],backboneStart:["C3'","C3*","C2'","P"],backboneEnd:["C3'","C3*","C2'","P"]},Ty[ny]={},Xa.prototype={constructor:Xa,atomRadius:function(t){var e,i=this.type,r=this.scale;switch(i){case"vdw":e=fy[t.element]||2;break;case"covalent":e=my[t.element]||1.6;break;case"bfactor":e=t.bfactor||1;break;case"sstruc":var n=t.sstruc;e="h"===n?.25:"g"===n?.25:"i"===n?.25:"e"===n?.25:"b"===n?.25:Ey.includes(t.atomname)?.4:.1;break;default:e=i||1}return Math.min(e*r,this.max)}},Xa.types={"":"",vdw:"by vdW radius",covalent:"by covalent radius",sstruc:"by secondary structure",bfactor:"by bfactor",size:"size"},qa.prototype={copyTo:function(t){t.data.set(this.data)}};var Cy=1.192092896e-7,Iy=1e-37;ls.__deps=[cs],hs.__deps=[cs],ps.__deps=[cs],fs.__deps=[Ca,Ia];var Ry=new v(-1,-1,-1),Ly=new y,Oy=function(t){var e=t.rows,i=e/3,r=new qa(e,3),n=new qa(3,3),o=new qa(1,3),a=new qa(3,3),s=new qa(3,3),c=ts(t);es(t,c),Ya(r,t),Za(n,r,r),as(n,o,a,s);var u=new v(c[0],c[1],c[2]),l=new v(a.data[0],a.data[3],a.data[6]),h=new v(a.data[1],a.data[4],a.data[7]),p=new v(a.data[2],a.data[5],a.data[8]),d=l.clone().multiplyScalar(Math.sqrt(o.data[0]/i)),f=h.clone().multiplyScalar(Math.sqrt(o.data[1]/i)),m=p.clone().multiplyScalar(Math.sqrt(o.data[2]/i));this.begA=u.clone().sub(d),this.endA=u.clone().add(d),this.begB=u.clone().sub(f),this.endB=u.clone().add(f),this.begC=u.clone().sub(m),this.endC=u.clone().add(m),this.center=u,this.vecA=d,this.vecB=f,this.vecC=m,this.normVecA=l,this.normVecB=h,this.normVecC=p};Oy.prototype.getBasisMatrix=function(t){var e=t||new y;return e.makeBasis(this.normVecB,this.normVecA,this.normVecC),e.determinant()<0&&e.scale(Ry),e},Oy.prototype.getRotationQuaternion=function(t){var e=t||new g;return e.setFromRotationMatrix(this.getBasisMatrix(Ly)),e.inverse()},Oy.prototype.getProjectedScaleForAtoms=function(t){var e=-1/0,i=-1/0,r=-1/0,n=-1/0,o=-1/0,a=-1/0,s=new v,c=new v,u=this.center,l=this.normVecA,h=this.normVecB,p=this.normVecC;return t.eachAtom(function(t){Aa(s.copy(t),l,u);var d=c.subVectors(s,u).normalize().dot(l),f=s.distanceTo(u);d>0?f>e&&(e=f):f>i&&(i=f),Aa(s.copy(t),h,u);var m=c.subVectors(s,u).normalize().dot(h),g=s.distanceTo(u);m>0?g>r&&(r=g):g>n&&(n=g),Aa(s.copy(t),p,u);var v=c.subVectors(s,u).normalize().dot(p),y=s.distanceTo(u);v>0?y>o&&(o=y):y>a&&(a=y)}),{d1a:e,d2a:r,d3a:o,d1b:-i,d2b:-n,d3b:-a}},gs.prototype.constructor=gs,vs.prototype.constructor=vs,_s.__deps=[ys,bs,xs,Kn],ws.__deps=[Ss],Ss.__deps=[La,Ia,Da,Ta],Ms.__deps=[co,Ua,ja,Ba,Fa,Va,Ga,La,$a,ss,us,hs,ls,ps];var Dy=function(t,e,i){this.name=t||"",this.path=e||"",this.info={},this.center=new v,this.boundingBox=new lt,i instanceof Mt||i instanceof Ft||i instanceof qe?this.fromGeometry(i):i&&(this.set(i.position,i.index,i.normal,i.color,i.atomindex,i.contour),this.boundingBox.setFromArray(i.position),this.boundingBox.getCenter(this.center))},Ny={type:{configurable:!0}};Ny.type.get=function(){return"Surface"},Dy.prototype.set=function(t,e,i,r,n,o){this.position=t,this.index=e,this.normal=i,this.color=r,this.atomindex=n,this.size=t.length/3,this.contour=o},Dy.prototype.fromGeometry=function(e){t.Debug&&vm.time("GeometrySurface.fromGeometry");var i;e instanceof Mt?(e.computeVertexNormals(!0),i=(new Ft).fromGeometry(e)):i=e instanceof Ft?e:e[0],i.boundingBox||i.computeBoundingBox(),this.boundingBox.copy(i.boundingBox),this.boundingBox.getCenter(this.center);var r,n,o;if(i instanceof Ft){var a=i.attributes,s=!!a.normal&&a.normal.array;(!s||0===s[0]&&0===s[1]&&0===s[2])&&i.computeVertexNormals(),r=a.position.array,n=a.index?a.index.array:null,o=a.normal.array}this.set(r,n,o,void 0,void 0),t.Debug&&vm.timeEnd("GeometrySurface.setGeometry")},Dy.prototype.getPosition=function(){return this.position},Dy.prototype.getColor=function(t){var e=t||{};e.surface=this;var i=this.size,r=new Float32Array(3*i),n=_m.getScheme(e);if(n.volumeColor||"random"===e.scheme)for(var o=0;o<i;++o)n.volumeColorToArray(o,r,3*o);else if(n.positionColor)for(var a=new v,s=this.position,c=0;c<i;++c){var u=3*c;a.set(s[u],s[u+1],s[u+2]),n.positionColorToArray(a,r,u)}else if(n.atomColor&&this.atomindex)for(var l=e.structure.getAtomProxy(),h=this.atomindex,p=0;p<i;++p)l.index=h[p],n.atomColorToArray(l,r,3*p);else{var d=new et(e.value);Jo(i,d.r,d.g,d.b,r)}return r},Dy.prototype.getPicking=function(t){return this.atomindex&&t?new Ov(this.atomindex,t):new Wv(ea(this.size),this)},Dy.prototype.getNormal=function(){return this.normal},Dy.prototype.getSize=function(t,e){return Qo(this.size,t*e)},Dy.prototype.getIndex=function(){return this.index},Dy.prototype.getFilteredIndex=function(t,e){if(t&&this.atomindex){for(var i=new rm(t),r=e.getAtomSet(i),n=[],o=this.atomindex,a=this.index,s=a.length,c=this.contour?2:3,u=0,l=0;l<s;l+=c){for(var h=!0,p=0;p<c;p++){var d=o[a[l+p]];if(!r.get(d)){h=!1;break}}if(h)for(var f=0;f<c;f++,u++)n[u]=a[l+f]}return Kn(n,this.position.length/3)}return this.index},Dy.prototype.getAtomindex=function(){return this.atomindex},Dy.prototype.dispose=function(){},Object.defineProperties(Dy.prototype,Ny),Ps.__deps=[ws,Ss,_s,Pa,Ea,ds,fs],xm.add("surf",function(t,e){var i=t.data.args,r=t.data.params;if(i&&(self.volsurf=new Ps(i[0],i[1],i[2],i[3],i[4])),r){var n=self.volsurf.getSurface(r.isolevel,r.smooth,r.box,r.matrix,r.contour,r.wrap),o=[n.position.buffer,n.index.buffer];n.normal&&o.push(n.normal.buffer),n.atomindex&&o.push(n.atomindex.buffer),e({sd:n,p:r},o)}},[Ps]);var ky=function(t,e,i,r,n,o,a){this.name=t,this.path=e,this.matrix=new y,this.normalMatrix=new pt,this.inverseMatrix=new y,this.center=new v,this.boundingBox=new lt,this.setData(i,r,n,o,a)},By={type:{configurable:!0},position:{configurable:!0},min:{configurable:!0},max:{configurable:!0},sum:{configurable:!0},mean:{configurable:!0},rms:{configurable:!0}};By.type.get=function(){return"Volume"},ky.prototype.setData=function(t,e,i,r,n){this.nx=e||1,this.ny=i||1,this.nz=r||1,this.data=t||new Float32Array(1),this.setAtomindex(n),delete this._position,delete this._min,delete this._max,delete this._mean,delete this._rms,this.worker&&this.worker.terminate()},ky.prototype.setStats=function(t,e,i,r){this._min=t,this._max=e,this._mean=i,this._rms=r},ky.prototype.setMatrix=function(t){this.matrix.copy(t);var e=this.boundingBox,i=this.center,r=this.nx-1,n=this.ny-1,o=this.nz-1;e.makeEmpty(),e.expandByPoint(i.set(r,n,o)),e.expandByPoint(i.set(r,n,0)),e.expandByPoint(i.set(r,0,o)),e.expandByPoint(i.set(r,0,0)),e.expandByPoint(i.set(0,n,o)),e.expandByPoint(i.set(0,0,o)),e.expandByPoint(i.set(0,n,0)),e.expandByPoint(i.set(0,0,0)),e.applyMatrix4(this.matrix),e.getCenter(this.center);var a=this.matrix.elements,s=new v(a[0],a[1],a[2]),c=new v(a[4],a[5],a[6]),u=new v(a[8],a[9],a[10]),l=new v,h=this.normalMatrix.elements;l.crossVectors(c,u),h[0]=l.x,h[1]=l.y,h[2]=l.z,l.crossVectors(u,s),h[3]=l.x,h[4]=l.y,h[5]=l.z,l.crossVectors(s,c),h[6]=l.x,h[7]=l.y,h[8]=l.z,this.inverseMatrix.getInverse(this.matrix)},ky.prototype.setAtomindex=function(t){this.atomindex=t},ky.prototype.getBox=function(t,e,i){return i||(i=new lt),i.set(t,t),i.expandByScalar(e),i.applyMatrix4(this.inverseMatrix),i.min.round(),i.max.round(),i},ky.prototype._getBox=function(t,e){if(t&&e){this.__box||(this.__box=new lt);var i=this.getBox(t,e,this.__box);return[i.min.toArray(),i.max.toArray()]}},ky.prototype._makeSurface=function(t,e,i){var r=this.name+"@"+e.toPrecision(2),n=new Dy(r,"",t);return n.info.isolevel=e,n.info.smooth=i,n.info.volume=this,n},ky.prototype.getSurface=function(t,e,i,r,n,o){t=isNaN(t)?this.getValueForSigma(2):t,e=Nn(e,0),void 0===this.volsurf&&(this.volsurf=new Ps(this.data,this.nx,this.ny,this.nz,this.atomindex));var a=this._getBox(i,r),s=this.volsurf.getSurface(t,e,a,this.matrix.elements,n,o);return this._makeSurface(s,t,e)},ky.prototype.getSurfaceWorker=function(t,e,i,r,n,o,a){var s=this;if(t=isNaN(t)?this.getValueForSigma(2):t,e=e||0,window.Worker){void 0===this.workerPool&&(this.workerPool=new vs("surf",2));var c={},u=this.workerPool.getNextWorker();0===u.postCount&&(c.args=[this.data,this.nx,this.ny,this.nz,this.atomindex]),c.params={isolevel:t,smooth:e,box:this._getBox(i,r),matrix:this.matrix.elements,contour:n,wrap:o},u.post(c,void 0,function(t){var e=t.data.sd,i=t.data.p;a(s._makeSurface(e,i.isolevel,i.smooth))},function(c){console.warn("Volume.getSurfaceWorker error - trying without worker",c);var u=s.getSurface(t,e,i,r,n,o);a(u)})}else{var l=this.getSurface(t,e,i,r,n,o);a(l)}},ky.prototype.getValueForSigma=function(t){return this.mean+Nn(t,2)*this.rms},ky.prototype.getSigmaForValue=function(t){return(Nn(t,0)-this.mean)/this.rms},By.position.get=function(){if(!this._position){for(var t=this.nz,e=this.ny,i=this.nx,r=new Float32Array(i*e*t*3),n=0,o=0;o<t;++o)for(var a=0;a<e;++a)for(var s=0;s<i;++s)r[n+0]=s,r[n+1]=a,r[n+2]=o,n+=3;Pa(this.matrix.elements,r),this._position=r}return this._position},ky.prototype.getDataAtomindex=function(){return this.atomindex},ky.prototype.getDataPosition=function(){return this.position},ky.prototype.getDataColor=function(t){var e=t||{};e.volume=this,e.scale=e.scale||"Spectral",e.domain=e.domain||[this.min,this.max];for(var i=_m.getScheme(e),r=this.position.length/3,n=new Float32Array(3*r),o=0;o<r;++o)i.volumeColorToArray(o,n,3*o);return n},ky.prototype.getDataPicking=function(){var t=ea(this.position.length/3);return new Zv(t,this)},ky.prototype.getDataSize=function(t,e){var i,r=this.data,n=this.position.length/3;switch(t){case"value":i=new Float32Array(r);break;case"abs-value":i=new Float32Array(r);for(var o=0;o<n;++o)i[o]=Math.abs(i[o]);break;case"value-min":i=new Float32Array(r);for(var a=this.min,s=0;s<n;++s)i[s]-=a;break;case"deviation":i=new Float32Array(r);break;default:i=Qo(n,t)}if(1!==e)for(var c=0;c<n;++c)i[c]*=e;return i},By.min.get=function(){return void 0===this._min&&(this._min=ca(this.data)),this._min},By.max.get=function(){return void 0===this._max&&(this._max=sa(this.data)),this._max},By.sum.get=function(){return void 0===this._sum&&(this._sum=ua(this.data)),this._sum},By.mean.get=function(){return void 0===this._mean&&(this._mean=la(this.data)),this._mean},By.rms.get=function(){return void 0===this._rms&&(this._rms=ha(this.data)),this._rms},ky.prototype.clone=function(){var t=new ky(this.name,this.path,this.data,this.nx,this.ny,this.nz,this.atomindex);return t.matrix.copy(this.matrix),t.header=Object.assign({},this.header),t},ky.prototype.dispose=function(){this.workerPool&&this.workerPool.terminate()},Object.defineProperties(ky.prototype,By);var Fy=function(t,e,i,r){this.volume=t,this.setFilter(e,i,r)},zy={header:{configurable:!0},matrix:{configurable:!0},normalMatrix:{configurable:!0},inverseMatrix:{configurable:!0},center:{configurable:!0},boundingBox:{configurable:!0},min:{configurable:!0},max:{configurable:!0},mean:{configurable:!0},rms:{configurable:!0}};zy.header.get=function(){return this.volume.header},zy.matrix.get=function(){return this.volume.matrix},zy.normalMatrix.get=function(){return this.volume.normalMatrix},zy.inverseMatrix.get=function(){return this.volume.inverseMatrix},zy.center.get=function(){return this.volume.center},zy.boundingBox.get=function(){return this.volume.boundingBox},zy.min.get=function(){return this.volume.min},zy.max.get=function(){return this.volume.max},zy.mean.get=function(){return this.volume.mean},zy.rms.get=function(){return this.volume.rms},Fy.prototype._getFilterHash=function(t,e,i){return JSON.stringify([t,e,i])},Fy.prototype.setFilter=function(t,e,i){isNaN(t)&&this.header&&(t=this.header.DMEAN+2*this.header.ARMS),t=void 0===t||isNaN(t)?-1/0:t,e=Nn(e,1/0),i=Nn(i,!1);var r=this.volume.data,n=this.volume.position,o=this.volume.atomindex,a=this._getFilterHash(t,e,i);if(a!==this._filterHash){if(t===-1/0&&e===1/0)this.data=r,this.position=n,this.atomindex=o;else{var s=r.length;this._dataBuffer||(this._dataBuffer=new ArrayBuffer(4*s),this._positionBuffer=new ArrayBuffer(3*s*4),o&&(this._atomindexBuffer=new ArrayBuffer(4*s)));var c,u=new Float32Array(this._dataBuffer),l=new Float32Array(this._positionBuffer);o&&(c=new Uint32Array(this._atomindexBuffer));for(var h=0,p=0;p<s;++p){var d=3*p,f=r[p];if(!i&&f>=t&&f<=e||i&&(f<t||f>e)){var m=3*h;u[h]=f,l[m+0]=n[d+0],l[m+1]=n[d+1],l[m+2]=n[d+2],o&&(c[h]=o[p]),h+=1}}this.data=new Float32Array(this._dataBuffer,0,h),this.position=new Float32Array(this._positionBuffer,0,3*h),o&&(this.atomindex=new Float32Array(this._atomindexBuffer,0,h))}this._filterHash=a}},Object.defineProperties(Fy.prototype,zy),Fy.prototype.getValueForSigma=ky.prototype.getValueForSigma,Fy.prototype.getSigmaForValue=ky.prototype.getSigmaForValue,Fy.prototype.getDataAtomindex=ky.prototype.getDataAtomindex,Fy.prototype.getDataPosition=ky.prototype.getDataPosition,Fy.prototype.getDataColor=ky.prototype.getDataColor,Fy.prototype.getDataPicking=ky.prototype.getDataPicking,Fy.prototype.getDataSize=ky.prototype.getDataSize;var Uy=function(e,i){t.Debug&&vm.time("BondHash init");for(var r=e.count,n=e.atomIndex1,o=e.atomIndex2,a=new Uint8Array(i),s=new Int32Array(i),c=0;c<r;++c)a[n[c]]+=1,a[o[c]]+=1;for(var u=1;u<i;++u)s[u]+=s[u-1]+a[u-1];for(var l=2*r,h=new Int32Array(l),p=0;p<l;++p)h[p]=-1;for(var d=0;d<r;++d){for(var f=n[d],m=o[d],g=s[f];-1!==h[g];)g+=1;h[g]=d;for(var v=s[m];-1!==h[v];)v+=1;h[v]=d}t.Debug&&vm.timeEnd("BondHash init"),this.countArray=a,this.offsetArray=s,this.indexArray=h},jy=function(t){this._fields=this._defaultFields,Number.isInteger(t)?this._init(t):this._init(0)};jy.prototype._init=function(t){var e=this;this.length=t,this.count=0;for(var i=0,r=this._fields.length;i<r;++i)(n=e)._initField.apply(n,e._fields[i]);var n},jy.prototype._initField=function(t,e,i){this[t]=Zn(i,this.length*e)},jy.prototype.addField=function(t,e,i){this._fields.push([t,e,i]),this._initField(t,e,i)},jy.prototype.resize=function(t){var e=this;this.length=Math.round(t||0),this.count=Math.min(this.count,this.length);for(var i=0,r=this._fields.length;i<r;++i){var n=e._fields[i][0],o=e._fields[i][1],a=e.length*o,s=new e[n].constructor(a);e[n].length>a?s.set(e[n].subarray(0,a)):s.set(e[n]),e[n]=s}},jy.prototype.growIfFull=function(){if(this.count>=this.length){var t=Math.round(1.5*this.length);this.resize(Math.max(256,t))}},jy.prototype.copyFrom=function(t,e,i,r){for(var n=this,o=0,a=this._fields.length;o<a;++o)for(var s=n._fields[o][0],c=n._fields[o][1],u=n[s],l=t[s],h=0;h<r;++h)for(var p=c*(e+h),d=c*(i+h),f=0;f<c;++f)u[p+f]=l[d+f]},jy.prototype.copyWithin=function(t,e,i){for(var r=this,n=0,o=this._fields.length;n<o;++n)for(var a=r._fields[n][0],s=r._fields[n][1],c=r[a],u=0;u<i;++u)for(var l=s*(t+u),h=s*(e+u),p=0;p<s;++p)c[l+p]=c[h+p]},jy.prototype.sort=function(t){function e(t,e){t!==e&&(n.copyFrom(r,0,t,1),r.copyWithin(t,e,1),r.copyFrom(n,e,0,1))}function i(r,n){if(r<n){var o=Math.floor((r+n)/2),a=r,s=n;do{for(;t(a,o)<0;)a+=1;for(;t(s,o)>0;)s-=1;a<=s&&(a===o?o=s:s===o&&(o=a),e(a,s),a+=1,s-=1)}while(a<=s);i(r,s),i(a,n)}}vm.time("Store.sort");var r=this,n=new this.constructor(1);i(0,this.count-1),vm.timeEnd("Store.sort")},jy.prototype.clear=function(){this.count=0},jy.prototype.dispose=function(){var t=this;delete this.length,delete this.count;for(var e=0,i=this._fields.length;e<i;++e)delete t[t._fields[e][0]]};var Vy=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={_defaultFields:{configurable:!0}};return i._defaultFields.get=function(){return[["atomIndex1",1,"int32"],["atomIndex2",1,"int32"],["bondOrder",1,"int8"]]},e.prototype.addBond=function(t,e,i){this.growIfFull();var r=this.count,n=t.index,o=e.index;n<o?(this.atomIndex1[r]=n,this.atomIndex2[r]=o):(this.atomIndex2[r]=n,this.atomIndex1[r]=o),i&&(this.bondOrder[r]=i),this.count+=1},e.prototype.addBondIfConnected=function(t,e,i){return!!t.connectedTo(e)&&(this.addBond(t,e,i),!0)},Object.defineProperties(e.prototype,i),e}(jy),Gy=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={_defaultFields:{configurable:!0}};return i._defaultFields.get=function(){return[["residueIndex",1,"uint32"],["atomTypeId",1,"uint16"],["x",1,"float32"],["y",1,"float32"],["z",1,"float32"],["serial",1,"int32"],["bfactor",1,"float32"],["altloc",1,"uint8"],["occupancy",1,"float32"]]},e.prototype.setAltloc=function(t,e){this.altloc[t]=e.charCodeAt(0)},e.prototype.getAltloc=function(t){var e=this.altloc[t];return e?String.fromCharCode(e):""},Object.defineProperties(e.prototype,i),e}(jy),$y=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={_defaultFields:{configurable:!0}};return i._defaultFields.get=function(){return[["chainIndex",1,"uint32"],["atomOffset",1,"uint32"],["atomCount",1,"uint16"],["residueTypeId",1,"uint16"],["resno",1,"int32"],["sstruc",1,"uint8"],["inscode",1,"uint8"]]},e.prototype.setSstruc=function(t,e){this.sstruc[t]=e.charCodeAt(0)},e.prototype.getSstruc=function(t){var e=this.sstruc[t];return e?String.fromCharCode(e):""},e.prototype.setInscode=function(t,e){this.inscode[t]=e.charCodeAt(0)},e.prototype.getInscode=function(t){var e=this.inscode[t];return e?String.fromCharCode(e):""},Object.defineProperties(e.prototype,i),e}(jy),Hy=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={_defaultFields:{configurable:!0}};return i._defaultFields.get=function(){return[["entityIndex",1,"uint16"],["modelIndex",1,"uint16"],["residueOffset",1,"uint32"],["residueCount",1,"uint32"],["chainname",4,"uint8"],["chainid",4,"uint8"]]},e.prototype.setChainname=function(t,e){var i=4*t;this.chainname[i]=e.charCodeAt(0),this.chainname[i+1]=e.charCodeAt(1),this.chainname[i+2]=e.charCodeAt(2),this.chainname[i+3]=e.charCodeAt(3)},e.prototype.getChainname=function(t){for(var e=this,i="",r=0;r<4;++r){var n=e.chainname[4*t+r];if(!n)break;i+=String.fromCharCode(n)}return i},e.prototype.setChainid=function(t,e){var i=4*t;this.chainid[i]=e.charCodeAt(0),this.chainid[i+1]=e.charCodeAt(1),this.chainid[i+2]=e.charCodeAt(2),this.chainid[i+3]=e.charCodeAt(3)},e.prototype.getChainid=function(t){for(var e=this,i="",r=0;r<4;++r){var n=e.chainid[4*t+r];if(!n)break;i+=String.fromCharCode(n)}return i},Object.defineProperties(e.prototype,i),e}(jy),Wy=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={_defaultFields:{configurable:!0}};return i._defaultFields.get=function(){return[["chainOffset",1,"uint32"],["chainCount",1,"uint32"]]},Object.defineProperties(e.prototype,i),e}(jy);Es.prototype={constructor:Es,getCenterIterator:function(t){var e=this.getPosition().center,i=e.length/3,r=0,n=-1,o=[new v,new v,new v,new v];return{size:i,next:function(){var t=this.get(n);return n+=1,t},get:function(n){n=Math.min(i-1,Math.max(0,n));var a=o[r%4],s=3*n;if(a.fromArray(e,s),t){var c,u,l,h=Math.min(t,n,i-n-1);for(u=1;u<=h;++u)c=3*u,l=(h+1-u)/(h+1),a.x+=l*e[s-c+0]+l*e[s+c+0],a.y+=l*e[s-c+1]+l*e[s+c+1],a.z+=l*e[s-c+2]+l*e[s+c+2];a.x/=h+1,a.y/=h+1,a.z/=h+1}return r+=1,a},reset:function(){r=0,n=-1}}},getColor:function(t){var e=this.polymer,i=e.structure,r=e.residueCount,n=e.residueIndexStart,o=new Float32Array(3*r),a=t||{};a.structure=i;for(var s=_m.getScheme(a),c=i.getResidueProxy(),u=i.getAtomProxy(),l=0;l<r;++l)c.index=n+l,u.index=c.traceAtomIndex,s.atomColorToArray(u,o,3*l);return{color:o}},getPicking:function(){for(var t=this.polymer,e=t.structure,i=t.residueCount,r=t.residueIndexStart,n=new Float32Array(i),o=e.getResidueProxy(),a=0;a<i;++a)o.index=r+a,n[a]=o.traceAtomIndex;return{picking:new Ov(n,e)}},getSize:function(t,e){for(var i=this.polymer,r=i.structure,n=i.residueCount,o=i.residueIndexStart,a=new Float32Array(n),s=new Xa(t,e),c=r.getResidueProxy(),u=r.getAtomProxy(),l=0;l<n;++l)c.index=o+l,u.index=c.traceAtomIndex,a[l]=s.atomRadius(u);return{size:a}},getPosition:function(){var t,e,i,r,n,o=this.polymer,a=o.structure,s=o.residueCount,c=s-3,u=new Float32Array(3*s),l=new Float32Array(3*s),h=new Float32Array(s),p=new Float32Array(s),d=new Float32Array(s),f=new Float32Array(s),m=new Float32Array(3*s),g=new v,y=new v,b=new v,x=new v,_=new v,w=new v,S=new v,A=new v,M=new v,P=new v,E=new v,T=new v(0,0,0),C="trace",I=a.getAtomProxy(),R=a.getAtomProxy(o.getAtomIndexByType(0,C)),L=a.getAtomProxy(o.getAtomIndexByType(1,C)),O=a.getAtomProxy(o.getAtomIndexByType(2,C));for(i=0;i<c;++i)I.index=R.index,R.index=L.index,L.index=O.index,O.index=o.getAtomIndexByType(i+3,C),e=3*i,g.subVectors(R,I),y.subVectors(L,R),b.subVectors(O,L),x.subVectors(g,y),_.subVectors(y,b),M.crossVectors(x,_).normalize(),M.toArray(l,e),i>0&&(h[i]=M.angleTo(P)),t=Math.cos(x.angleTo(_)),f[i]=180/Math.PI*Math.acos(t),r=x.length(),n=_.length(),p[i]=Math.sqrt(n*r)/Math.max(2,2*(1-t)),d[i]=Math.abs(y.dot(M)),w.copy(x).multiplyScalar(p[i]/r),S.copy(_).multiplyScalar(p[i]/n),w.subVectors(R,w),S.subVectors(L,S),w.toArray(u,e+3),S.toArray(u,e+6),E.subVectors(I,T),E.toArray(m,e),P.copy(M),T.copy(w);for(w.fromArray(u,3),S.fromArray(u,6),M.subVectors(w,S).normalize(),I.index=o.getAtomIndexByType(0,C),T.copy(I),A.copy(I),Aa(A,M,w),A.toArray(u,0),E.subVectors(T,w),E.toArray(m,0),w.fromArray(u,3*s-6),S.fromArray(u,3*s-9),M.subVectors(w,S).normalize(),I.index=o.getAtomIndexByType(s-1,C),T.copy(I),A.copy(I),Aa(A,M,w),A.toArray(u,3*s-3),i=s-3;i<s;++i)w.fromArray(u,3*i),I.index=o.getAtomIndexByType(i,C),T.copy(I),E.subVectors(T,w),E.toArray(m,3*i);var D=new Float32Array(s),N=new Float32Array(s),k=new Float32Array(s),B=new Float32Array(s);for(D[1]=p[0],N[1]=f[0],k[1]=p[0],i=2;i<s-2;++i)D[i]=.5*(p[i-2]+p[i-1]),N[i]=.5*(f[i-2]+f[i-1]),k[i]=.5*(d[i-2]+d[i-1]),w.fromArray(l,3*(i-2)),S.fromArray(l,3*(i-1)),B[i]=180/Math.PI*Math.acos(Math.cos(w.angleTo(S)));D[s-2]=p[s-4],N[s-2]=f[s-4],k[s-2]=d[s-4];var F=new Float32Array(3*s);for(na(l,F,0,0,3),na(l,F,0,3,3),i=2;i<s-2;++i)w.fromArray(l,3*(i-2)),S.fromArray(l,3*(i-1)),M.addVectors(S,w).multiplyScalar(.5).normalize(),M.toArray(F,3*i);return na(l,F,3*s-12,3*s-6,3),na(l,F,3*s-12,3*s-3,3),{center:u,axis:F,bending:B,radius:D,rise:k,twist:N,resdir:m}}},Ts.prototype={constructor:Ts,getAxis:function(t,e,i,r,n,o){t=t||30,e=e||2.5,i=void 0!==i&&i;var a=this.polymer,s=a.structure,c=a.residueCount,u=a.residueIndexStart,l=this.position,h=r||{};h.structure=s;for(var p,d,f=_m.getScheme(h),m=new Xa(n,o),g=0,y=0,b=[],x=[],_=[],w=[],S=[],A=[],M=[],P=[],E=[],T=[],C=[],I=new v,R=new v,L=s.getResidueProxy(),O=s.getResidueProxy(),D=s.getAtomProxy(),N=new v,k=new v,B=!1,F=0;F<c;++F)if(L.index=u+F,N.fromArray(l.center,3*F),F===c-1?B=!0:(O.index=u+F+1,k.fromArray(l.center,3*F+3),i&&L.sstruc!==O.sstruc?B=!0:N.distanceTo(k)>e?B=!0:l.bending[F]>t&&(B=!0)),B){if(F-g<4){g=F,B=!1;continue}D.index=L.traceAtomIndex,T=l.axis.subarray(3*g+3,3*F),C=l.center.subarray(3*g,3*F+3),p=Sa(T).normalize(),d=Sa(C),I.fromArray(C),Aa(I,p,d),R.fromArray(C,C.length-3),Aa(R,p,d),p.subVectors(R,I),p.toArray(b,y),d.toArray(x,y),I.toArray(_,y),R.toArray(w,y),f.atomColorToArray(D,S,y),A.push(D.index),M.push(m.atomRadius(D)),P.push(u+g),E.push(u+F+1-g),y+=3,g=F,B=!1}var z=new Float32Array(A);return{axis:new Float32Array(b),center:new Float32Array(x),begin:new Float32Array(_),end:new Float32Array(w),color:new Float32Array(S),picking:new Ov(z,s),size:new Float32Array(M),residueOffset:P,residueCount:E}}},Cs.prototype={push:function(t){this.content.push(t),this.bubbleUp(this.content.length-1)},pop:function(){var t=this.content[0],e=this.content.pop();return this.content.length>0&&(this.content[0]=e,this.sinkDown(0)),t},peek:function(){return this.content[0]},remove:function(t){for(var e=this,i=this.content.length,r=0;r<i;r++)if(e.content[r]===t){var n=e.content.pop();return void(r!==i-1&&(e.content[r]=n,e.scoreFunction(n)<e.scoreFunction(t)?e.bubbleUp(r):e.sinkDown(r)))}throw new Error("Node not found.")},size:function(){return this.content.length},bubbleUp:function(t){for(var e=this,i=this.content[t];t>0;){var r=Math.floor((t+1)/2)-1,n=e.content[r];if(!(e.scoreFunction(i)<e.scoreFunction(n)))break;e.content[r]=i,e.content[t]=n,t=r}},sinkDown:function(t){for(var e,i=this,r=this.content.length,n=this.content[t],o=this.scoreFunction(n);;){var a=2*(t+1),s=a-1,c=null;if(s<r){var u=i.content[s];(e=i.scoreFunction(u))<o&&(c=s)}if(a<r){var l=i.content[a];i.scoreFunction(l)<(null===c?o:e)&&(c=a)}if(null===c)break;i.content[t]=i.content[c],i.content[c]=n,t=c}}},Rs.prototype={nearest:function(){var t=new Float32Array(3);return function(e,i,r){e.toArray?e.toArray(t):e.positionToArray&&e.positionToArray(t);for(var n=this.kdtree.nearest(t,i,r),o=this.kdtree.indices,a=this.kdtree.nodes,s=this.atomIndices,c=[],u=0,l=n.length;u<l;++u){var h=n[u],p=h[0],d=h[1];c.push({index:s[o[a[p]]],distance:d})}return c}}()};var Xy={" ":"X","!":"Y","#":"Z",$:"-X","%":"-Y","&":"-Z","'":"Y+1/2","(":"1/2+X",")":"1/2+Y","*":"1/2-X","+":"1/2+Z",",":"1/2-Y","-":"1/2-Z",".":"X+1/2","/":"Z+1/2",0:"-X+1/2",1:"-Y+1/2",2:"-Z+1/2",3:"1/4+X",4:"1/4-Y",5:"1/4+Z",6:"1/4-X",7:"1/4+Y",8:"3/4-Y",9:"3/4+Z",":":"3/4+Y",";":"3/4+X","<":"3/4-X","=":"1/4-Z",">":"3/4-Z","?":"X-Y","@":"Y-X",A:"Z+1/3",B:"Z+2/3",C:"X+2/3",D:"Y+1/3",E:"-Y+2/3",F:"X-Y+1/3",G:"Y-X+2/3",H:"-X+1/3",I:"X+1/3",J:"Y+2/3",K:"-Y+1/3",L:"X-Y+2/3",M:"Y-X+1/3",N:"-X+2/3",O:"2/3+X",P:"1/3+Y",Q:"1/3+Z",R:"2/3-Y",S:"1/3+X-Y",T:"2/3+Y-X",U:"1/3-X",V:"2/3-X",W:"1/3-Y",X:"1/3-Z",Y:"2/3+Y",Z:"1/3+Y-X","[":"2/3+X-Y","]":"1/3+X","^":"2/3+Z",_:"2/3-Z","`":"5/6+Z",a:"1/6+Z",b:"5/6-Z",c:"1/6-Z",d:"Z+5/6",e:"Z+1/6",f:"Z+1/4",g:"+Y"},qy={"P 1":" !#","P -1":" !#$%&","P 1 2 1":" !#$!&","P 1 21 1":" !#$'&","C 1 2 1":" !#$!&()#*)&","P 1 m 1":" !# %#","P 1 c 1":" !# %+","C 1 m 1":" !# %#()#(,#","C 1 c 1":" !# %+()#(,+","P 1 2/m 1":" !# %#$!&$%&","P 1 21/m 1":" !#$)&$%& ,#","C 1 2/m 1":" !# %#$!&$%&()#(,#*)&*,&","P 1 2/c 1":" !#$!-$%& %+","P 1 21/c 1":" !#$%&$)- ,+","C 1 2/c 1":" !#$!-$%& %+()#*)-*,&(,+","P 2 2 2":" !#$%#$!& %&","P 2 2 21":" !#$%+$!- %&","P 21 21 2":" !#$%#*)&(,&","P 21 21 21":" !#*%+$)-(,&","C 2 2 21":" !#$%+$!- %&()#*,+*)-(,&","C 2 2 2":" !#$%#$!& %&()#*,#*)&(,&","F 2 2 2":" !#$%#$!& %& )+$,+$)- ,-(!+*%+*!-(%-()#*,#*)&(,&","I 2 2 2":" !#$%# %&$!&.'/01/.120'2","I 21 21 21":" !#*%+$)-(,&()+$,#*!& %-","P m m 2":" !#$%# %#$!#","P m c 21":" !#$%+ %+$!#","P c c 2":" !#$%# %+$!+","P m a 2":" !#$%#(%#*!#","P c a 21":" !#$%+(%#*!+","P n c 2":" !#$%# ,+$)+","P m n 21":" !#*%+(%+$!#","P b a 2":" !#$%#(,#*)#","P n a 21":" !#$%+(,#*)+","P n n 2":" !#$%#(,+*)+","C m m 2":" !#$%# %#$!#()#*,#(,#*)#","C m c 21":" !#$%+ %+$!#()#*,+(,+*)#","C c c 2":" !#$%# %+$!+()#*,#(,+*)+","A m m 2":" !#$%# %#$!# )+$,+ ,+$)+","A b m 2":" !#$%# ,#$)# )+$,+ %+$!+","A m a 2":" !#$%#(%#*!# )+$,+(,+*)+","A b a 2":" !#$%#(,#*)# )+$,+(%+*!+","F m m 2":" !#$%# %#$!# )+$,+ ,+$)+(!+*%+(%+*!+()#*,#(,#*)#","F d d 2":" !#$%#345675 )+$,+3896:9(!+*%+;49<79()#*,#;85<:5","I m m 2":" !#$%# %#$!#()+*,+(,+*)+","I b a 2":" !#$%#(,#*)#()+*,+ %+$!+","I m a 2":" !#$%#(%#*!#()+*,+ ,+$)+","P 2/m 2/m 2/m":" !#$%#$!& %&$%& !& %#$!#","P 2/n 2/n 2/n":" !#$%#$!& %&*,-()-(,+*)+","P 2/c 2/c 2/m":" !#$%#$!- %-$%& !& %+$!+","P 2/b 2/a 2/n":" !#$%#$!& %&*,&()&(,#*)#","P 21/m 2/m 2/a":" !#*%#$!&(%&$%&(!& %#*!#","P 2/n 21/n 2/a":" !#*%#*)- ,-$%&(!&(,+$)+","P 2/m 2/n 21/a":" !#*%+*!- %&$%&(!-(%+$!#","P 21/c 2/c 2/a":" !#*%#$!-(%-$%&(!& %+*!+","P 21/b 21/a 2/m":" !#$%#*)&(,&$%& !&(,#*)#","P 21/c 21/c 2/n":" !#*,#$)-(%-$%&()& ,+*!+","P 2/b 21/c 21/m":" !#$%+$)- ,&$%& !- ,+$)#","P 21/n 21/n 2/m":" !#$%#*)-(,-$%& !&(,+*)+","P 21/m 21/m 2/n":" !#$%#*'&.,&*,&.'& %#$!#","P 21/b 2/c 21/n":" !#*,+$!-(,&$%&()- %+*)#","P 21/b 21/c 21/a":" !#*%+$)-(,&$%&(!- ,+*)#","P 21/n 21/m 21/a":" !#0%/$'&.12$%&.!2 1#0'/","C 2/m 2/c 21/m":" !#$%+$!- %&$%& !- %+$!#()#*,+*)-(,&*,&()-(,+*)#","C 2/m 2/c 21/a":" !#$,+$)- %&$%& )- ,+$!#()#*%+*!-(,&*,&(!-(%+*)#","C 2/m 2/m 2/m":" !#$%#$!& %&$%& !& %#$!#()#*,#*)&(,&*,&()&(,#*)#","C 2/c 2/c 2/m":" !#$%#$!- %-$%& !& %+$!+()#*,#*)-(,-*,&()&(,+*)+","C 2/m 2/m 2/a":" !#$,#$)& %&$%& )& ,#$!#()#*%#*!&(,&*,&(!&(%#*)#","C 2/c 2/c 2/a":" !#*,#$!&(,&$,-(!- ,+*!+()#$%#*)& %&*%- )-(%+$)+","F 2/m 2/m 2/m":" !#$%#$!& %&$%& !& %#$!# )+$,+$)- ,-$,- )- ,+$)+(!+*%+*!-(%-*%-(!-(%+*!+()#*,#*)&(,&*,&()&(,#*)#","F 2/d 2/d 2/d":" !#$%#$!& %&64=37=345675 )+$,+$)- ,-68>3:>3896:9(!+*%+*!-(%-<4>;7>;49<79()#*,#*)&(,&<8=;:=;85<:5","I 2/m 2/m 2/m":" !#$%#$!& %&$%& !& %#$!#()+*,+*)-(,-*,-()-(,+*)+","I 2/b 2/a 2/m":" !#$%#*)&(,&$%& !&(,#*)#()+*,+$!- %-*,-()- %+$!+","I 21/b 21/c 21/a":" !#*%+$)-(,&$%&(!- ,+*)#()+$,#*!& %-*,- )&(%#$!+","I 21/m 21/m 21/a":" !#$,#$)& %&$%& )& ,#$!#()+*%+*!-(,-*,-(!-(%+*)+","P 4":" !#$%#% #!$#","P 41":" !#$%+% 5!$9","P 42":" !#$%#% +!$+","P 43":" !#$%+% 9!$5","I 4":" !#$%#% #!$#()+*,+,(+)*+","I 41":" !#*,+%(5)$9()+$%#, 9!*5","P -4":" !#$%#!$&% &","I -4":" !#$%#!$&% &()+*,+)*-,(-","P 4/m":" !#$%#% #!$#$%& !&!$&% &","P 42/m":" !#$%#% +!$+$%& !&!$-% -","P 4/n":" !#$%#,(#)*#*,&()&!$&% &","P 42/n":" !#$%#,(+)*+*,-()-!$&% &","I 4/m":" !#$%#% #!$#$%& !&!$&% &()+*,+,(+)*+*,-()-)*-,(-","I 41/a":" !#*,+%(5)$9$,=(!>!$&,(-()+$%#, 9!*5*%> )=)*-% &","P 4 2 2":" !#$%#% #!$#$!& %&! &%$&","P 4 21 2":" !#$%#,(#)*#*)&(,&! &%$&","P 41 2 2":" !#$%+% 5!$9$!& %-! >%$=","P 41 21 2":" !#$%+,(5)*9*)=(,>! &%$-","P 42 2 2":" !#$%#% +!$+$!& %&! -%$-","P 42 21 2":" !#$%#,(+)*+*)-(,-! &%$&","P 43 2 2":" !#$%+% 9!$5$!& %-! =%$>","P 43 21 2":" !#$%+,(9)*5*)>(,=! &%$-","I 4 2 2":" !#$%#% #!$#$!& %&! &%$&()+*,+,(+)*+*)-(,-)(-,*-","I 41 2 2":" !#*,+%(5)$9*!> ,=)(-%$&()+$%#, 9!*5$)=(%>! &,*-","P 4 m m":" !#$%#% #!$# %#$!#%$#! #","P 4 b m":" !#$%#% #!$#(,#*)#,*#)(#","P 42 c m":" !#$%#% +!$+ %+$!+%$#! #","P 42 n m":" !#$%#,(+)*+(,+*)+%$#! #","P 4 c c":" !#$%#% #!$# %+$!+%$+! +","P 4 n c":" !#$%#% #!$#(,+*)+,*+)(+","P 42 m c":" !#$%#% +!$+ %#$!#%$+! +","P 42 b c":" !#$%#% +!$+(,#*)#,*+)(+","I 4 m m":" !#$%#% #!$# %#$!#%$#! #()+*,+,(+)*+(,+*)+,*+)(+","I 4 c m":" !#$%#% #!$# %+$!+%$+! +()+*,+,(+)*+(,#*)#,*#)(#","I 41 m d":" !#*,+%(5)$9 %#*)+%*5) 9()+$%#, 9!*5(,+$!#,$9!(5","I 41 c d":" !#*,+%(5)$9 %+*)#%*9) 5()+$%#, 9!*5(,#$!+,$5!(9","P -4 2 m":" !#$%#% &!$&$!& %&%$#! #","P -4 2 c":" !#$%#% &!$&$!- %-%$+! +","P -4 21 m":" !#$%#% &!$&*)&(,&,*#)(#","P -4 21 c":" !#$%#% &!$&*)-(,-,*+)(+","P -4 m 2":" !#$%#!$&% & %#$!#! &%$&","P -4 c 2":" !#$%#% &!$& %+$!+! -%$-","P -4 b 2":" !#$%#% &!$&(,#*)#)(&,*&","P -4 n 2":" !#$%#% &!$&(,+*)+)(-,*-","I -4 m 2":" !#$%#% &!$& %#$!#! &%$&()+*,+,(-)*-(,+*)+)(-,*-","I -4 c 2":" !#$%#% &!$& %+$!+! -%$-()+*,+,(-)*-(,#*)#)(&,*&","I -4 2 m":" !#$%#% &!$&$!& %&%$#! #()+*,+,(-)*-*)-(,-,*+)(+","I -4 2 d":" !#$%#% &!$&*!>(%>,$9) 9()+*,+,(-)*-$)= ,=%*5!(5","P 4/m 2/m 2/m":" !#$%#% #!$#$!& %&! &%$&$%& !&!$&% & %#$!#%$#! #","P 4/m 2/c 2/c":" !#$%#% #!$#$!- %-! -%$-$%& !&!$&% & %+$!+%$+! +","P 4/n 2/b 2/m":" !#$%#% #!$#$!& %&! &%$&*,&()&)*&,(&(,#*)#,*#)(#","P 4/n 2/n 2/c":" !#$%#% #!$#$!& %&! &%$&*,-()-)*-,(-(,+*)+,*+)(+","P 4/m 21/b 2/m":" !#$%#% #!$#*)&(,&)(&,*&$%& !&!$&% &(,#*)#,*#)(#","P 4/m 21/n 2/c":" !#$%#% #!$#*)-(,-)(-,*-$%& !&!$&% &(,+*)+,*+)(+","P 4/n 21/m 2/m":" !#$%#,(#)*#*)&(,&! &%$&*,&()&!$&% & %#$!#,*#)(#","P 4/n 2/c 2/c":" !#$%#,(#)*#*)-(,-! -%$-*,&()&!$&% & %+$!+,*+)(+","P 42/m 2/m 2/c":" !#$%#% +!$+$!& %&! -%$-$%& !&!$-% - %#$!#%$+! +","P 42/m 2/c 2/m":" !#$%#% +!$+$!- %-! &%$&$%& !&!$-% - %+$!+%$#! #","P 42/n 2/b 2/c":" !#$%#,(+)*+$!- %-)(&,*&*,-()-!$&% &(,#*)#%$+! +","P 42/n 2/n 2/m":" !#$%#,(+)*+$!& %&)(-,*-*,-()-!$&% &(,+*)+%$#! #","P 42/m 21/b 2/c":" !#$%#% +!$+*)&(,&)(-,*-$%& !&!$-% -(,#*)#,*+)(+","P 42/m 21/n 2/m":" !#$%#,./'*/*'-.,-! &%$&$%& !&'*-,.-.,/*'/%$#! #","P 42/n 21/m 2/c":" !#$%#,(+)*+*)-(,-! &%$&*,-()-!$&% & %#$!#,*+)(+","P 42/n 21/c 2/m":" !#$%#,(+)*+*)&(,&! -%$-*,-()-!$&% & %+$!+,*#)(#","I 4/m 2/m 2/m":" !#$%#% #!$#$!& %&! &%$&$%& !&!$&% & %#$!#%$#! #()+*,+,(+)*+*)-(,-)(-,*-*,-()-)*-,(-(,+*)+,*+)(+","I 4/m 2/c 2/m":" !#$%#% #!$#$!- %-! -%$-$%& !&!$&% & %+$!+%$+! +()+*,+,(+)*+*)&(,&)(&,*&*,-()-)*-,(-(,#*)#,*#)(#","I 41/a 2/m 2/d":" !#*,+%(5)$9*!> ,=)(-%$&$,=(!>!$&,(-(,+$!#,$9!(5()+$%#, 9!*5$)=(%>! &,*-*%> )=)*-% & %#*)+%*5) 9","I 41/a 2/c 2/d":" !#*,+%(5)$9*!= ,>)(&%$-$,=(!>!$&,(-(,#$!+,$5!(9()+$%#, 9!*5$)>(%=! -,*&*%> )=)*-% & %+*)#%*9) 5","P 3":" !#%?#@$#","P 31":" !#%?A@$B","P 32":" !#%?B@$A","H 3":" !#%?#@$#CDAEFAGHAIJBKLBMNB","R 3":" !## !!# ","P -3":" !#%?#@$#$%&!@&? &","H -3":" !#%?#@$#$%&!@&? &OPQRSQTUQVWXYZX[]X]Y^W[^ZV^UR_PT_SO_","R -3":" !## !!# $%&&$%%&$","P 3 1 2":" !#%?#@$#%$&@!& ?&","P 3 2 1":" !#%?#@$#! &?%&$@&","P 31 1 2":" !#%?Q@$^%$_@!X ?&","P 31 2 1":" !#%?A@$B! &?%_$@X","P 32 1 2":" !#%?^@$Q%$X@!_ ?&","P 32 2 1":" !#%?B@$A! &?%X$@_","H 3 2":" !#%?#@$#! &?%&$@&OPQRSQTUQY]X[WXVZX]Y^W[^ZV^PO_SR_UT_","R 3 2":" !## !!# %$&$&%&%$","P 3 m 1":" !#%?#@$#%$#@!# ?#","P 3 1 m":" !#%?#@$#! #?%#$@#","P 3 c 1":" !#%?#@$#%$+@!+ ?+","P 3 1 c":" !#%?#@$#! +?%+$@+","H 3 m":" !#%?#@$#%$#@!# ?#OPQRSQTUQRUQTPQOSQ]Y^W[^ZV^WV^ZY^][^","R 3 m":" !## !!# ! # #!#! ","H 3 c":" !#%?#@$#%$+@!+ ?+OPQRSQTUQRU`TP`OS`]Y^W[^ZV^WVaZYa][a","R 3 c":" !## !!# '././'/'.","P -3 1 2/m":" !#%?#@$#%$&@!& ?&$%&!@&? &! #?%#$@#","P -3 1 2/c":" !#%?#@$#%$-@!- ?-$%&!@&? &! +?%+$@+","P -3 2/m 1":" !#%?#@$#! &?%&$@&$%&!@&? &%$#@!# ?#","P -3 2/c 1":" !#%?#@$#! -?%-$@-$%&!@&? &%$+@!+ ?+","H -3 2/m":" !#%?#@$#! &?%&$@&$%&!@&? &%$#@!# ?#OPQRSQTUQY]X[WXVZXVWXYZX[]XRUQTPQOSQ]Y^W[^ZV^PO_SR_UT_UR_PT_SO_WV^ZY^][^","R -3 2/m":" !## !!# %$&$&%&%$$%&&$%%&$! # #!#! ","H -3 2/c":" !#%?#@$#! -?%-$@-$%&!@&? &%$+@!+ ?+OPQRSQTUQY]b[WbVZbVWXYZX[]XRU`TP`OS`]Y^W[^ZV^POcSRcUTcUR_PT_SO_WVaZYa][a","R -3 2/c":" !## !!# 102021210$%&&$%%&$'././'/'.","P 6":" !#%?#@$#$%#!@#? #","P 61":" !#%?A@$B$%/!@d? e","P 65":" !#%?B@$A$%/!@e? d","P 62":" !#%?^@$Q$%#!@^? Q","P 64":" !#%?Q@$^$%#!@Q? ^","P 63":" !#%?#@$#$%+!@+? +","P -6":" !#%?#@$# !&%?&@$&","P 6/m":" !#%?#@$#$%#!@#? #$%&!@&? & !&%?&@$&","P 63/m":" !#%?#@$#$%+!@+? +$%&!@&? & !-%?-@$-","P 6 2 2":" !#%?#@$#$%#!@#? #! &?%&$@&%$&@!& ?&","P 61 2 2":" !#%?Q@$^$%+!@`? a! X?%&$@_%$b@!- ?c","P 65 2 2":" !#%?^@$Q$%+!@a? `! _?%&$@X%$c@!- ?b","P 62 2 2":" !#%?^@$Q$%#!@^? Q! _?%&$@X%$_@!& ?X","P 64 2 2":" !#%?Q@$^$%#!@Q? ^! X?%&$@_%$X@!& ?_","P 63 2 2":" !#%?#@$#$%+!@+? +! &?%&$@&%$-@!- ?-","P 6 m m":" !#%?#@$#$%#!@#? #%$#@!# ?#! #?%#$@#","P 6 c c":" !#%?#@$#$%#!@#? #%$+@!+ ?+! +?%+$@+","P 63 c m":" !#%?#@$#$%+!@+? +%$+@!+ ?+! #?%#$@#","P 63 m c":" !#%?#@$#$%+!@+? +%$#@!# ?#! +?%+$@+","P -6 m 2":" !#%?#@$# !&%?&@$&%$#@!# ?#%$&@!& ?&","P -6 c 2":" !#%?#@$# !-%?-@$-%$+@!+ ?+%$&@!& ?&","P -6 2 m":" !#%?#@$# !&%?&@$&! &?%&$@&! #?%#$@#","P -6 2 c":" !#%?#@$# !-%?-@$-! &?%&$@&! +?%+$@+","P 6/m 2/m 2/m":" !#%?#@$#$%#!@#? #! &?%&$@&%$&@!& ?&$%&!@&? & !&@$&%?&%$#@!# ?#! #?%#$@#","P 6/m 2/c 2/c":" !#%?#@$#$%#!@#? #! -?%-$@-%$-@!- ?-$%&!@&? & !&@$&%?&%$+@!+ ?+! +?%+$@+","P 63/m 2/c 2/m":" !#%?#@$#$%+!@+? +! -?%-$@-%$&@!& ?&$%&!@&? & !-@$-%?-%$+@!+ ?+! #?%#$@#","P 63/m 2/m 2/c":" !#%?#@$#$%+!@+? +! &?%&$@&%$-@!- ?-$%&!@&? & !-@$-%?-%$#@!# ?#! +?%+$@+","P 2 3":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& ","F 2 3":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%&  )+$,+$)- ,-#()#*,&*)&(,!+(%+*!-*%-((!+*%+*!-(%-+ )+$,-$)- ,)#(,#*)&*,&(()#*,#*)&(,&+(!+*%-*!-(%)+ ,+$)-$,- ","I 2 3":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& ()+*,+*)-(,-+()+*,-*)-(,)+(,+*)-*,-(","P 21 3":" !#*%+$)-(,&# !+*%-$)&(,!# %+*)-$,&(","I 21 3":" !#*%+$)-(,&# !+*%-$)&(,!# %+*)-$,&(()+$,#*!& %-+()#$,&*!- %)+(,#$!&*%- ","P 2/m -3":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& $%& !& %#$!#&$%& !# %#$!%&$!& %# !#$","P 2/n -3":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& *,-()-(,+*)+-*,-()+(,+*),-*)-(,+()+*","F 2/m -3":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& $%& !& %#$!#&$%& !# %#$!%&$!& %# !#$ )+$,+$)- ,-#()#*,&*)&(,!+(%+*!-*%-($,- )- ,+$)+&*,&()#(,#*)%-*!-(%+(!+*(!+*%+*!-(%-+ )+$,-$)- ,)#(,#*)&*,&(*%-(!-(%+*!+-$,- )+ ,+$),&*)&(,#()#*()#*,#*)&(,&+(!+*%-*!-(%)+ ,+$)-$,- *,&()&(,#*)#-*%-(!+(%+*!,-$)- ,+ )+$","F 2/d -3":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& 64=37=345675=64=375345674=67=3453756 )+$,+$)- ,-#()#*,&*)&(,!+(%+*!-*%-(68>3:>3896:9=<8=;:5;85<:4><7>;49;79<(!+*%+*!-(%-+ )+$,-$)- ,)#(,#*)&*,&(<4>;7>;49<79>68>3:93896:8=<:=;85;:5<()#*,#*)&(,&+(!+*%-*!-(%)+ ,+$)-$,- <8=;:=;8f<:f><4>;79;49<78>6:>3893:96","I 2/m -3":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& $%& !& %#$!#&$%& !# %#$!%&$!& %# !#$()+*,+*)-(,-+()+*,-*)-(,)+(,+*)-*,-(*,-()-(,+*)+-*,-()+(,+*),-*)-(,+()+*","P 21/a -3":" !#*%+$)-(,&# !+*%-$)&(,!# %+*)-$,&($%&(!- ,+*)#&$%-(!+ ,#*)%&$!-(,+ )#*","I 21/a -3":" !#*%+$)-(,&# !+*%-$)&(,!# %+*)-$,&($%&(!- ,+*)#&$%-(!+ ,#*)%&$!-(,+ )#*()+$,#*g& %-+()#$,&*!- %)+(,#$!&*%- *,- )&(%#$!+-*,& )#(%+$!,-*)& %#(!+$","P 4 3 2":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& ! &%$&!$#% # #%$#!$&% &!#!$#% &! &%$","P 42 3 2":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& )(-,*-)*+,(+(+,*+)*-,(-)+)*+,(-)(-,*","F 4 3 2":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& ! &%$&!$#% # #%$#!$&% &!#!$#% &! &%$ )+$,+$)- ,-#()#*,&*)&(,!+(%+*!-*%-(!(-%*-!*+%(+ +,$+)$-, -)#)*#,(&)(&,*(!+*%+*!-(%-+ )+$,-$)- ,)#(,#*)&*,&() -,$-)$+, +(#,*#)*&,(&)+!*+%(-!(-%*()#*,#*)&(,&+(!+*%-*!-(%)+ ,+$)-$,- )(&,*&)*#,(#(+%*+!*-%(-!+)$+, -) -,$","F 41 3 2":" !#$,+*)&(%-# !+$,&*)-(%!# ,+$)&*%-(:3>46=7<98;5;58<976=43>:97<58;>:3=46 )+$%#*!-(,&#()+*%&$!- ,!+(,#*)-$%& :;=4<>765839;94<5:6>83=79:6543>7;=8<(!+*,#$)- %&+ )#$%-*!&(,)#(%+*!&$,- 73=86>:<54;935469:<=8;>7576983=:;>4<()#*%+$!& ,-+(!#*,-$)& %)+ %#$!-*,&(7;>8<=:69435398657<>4;=:5:<94;=73>86","I 4 3 2":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& ! &%$&!$#% # #%$#!$&% &!#!$#% &! &%$()+*,+*)-(,-+()+*,-*)-(,)+(,+*)-*,-()(-,*-)*+,(+(+,*+)*-,(-)+)*+,(-)(-,*","P 43 3 2":" !#*%+$)-(,&# !+*%-$)&(,!# %+*)-$,&(7;>46=:<5839398<5:6=4;>75:<983>7;=46","P 41 3 2":" !#*%+$)-(,&# !+*%-$)&(,!# %+*)-$,&(:3=8<>7694;5;54697<>83=:97654;=:3>8<","I 41 3 2":" !#*%+$)-(,&# !+*%-$)&(,!# %+*)-$,&(:3=8<>7694;5;54697<>83=:97654;=:3>8<()+$,#*!& %-+()#$,&*!- %)+(,#$!&*%- 7;>46=:<5839398<5:6=4;>75:<983>7;=46","P -4 3 m":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& ! #%$#!$&% & #!$#%$&! &%#! #%$&!$&% ","F -4 3 m":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& ! #%$#!$&% & #!$#%$&! &%#! #%$&!$&%  )+$,+$)- ,-#()#*,&*)&(,!+(%+*!-*%-(!(+%*+!*-%(- +)$+,$-) -,#)(#,*&)*&,((!+*%+*!-(%-+ )+$,-$)- ,)#(,#*)&*,&() +,$+)$-, -(#)*#,*&)(&,+!(+%*-!*-%(()#*,#*)&(,&+(!+*%-*!-(%)+ ,+$)-$,- )(#,*#)*&,(&(+!*+%*-!(-%+) +,$-)$-, ","I -4 3 m":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& ! #%$#!$&% & #!$#%$&! &%#! #%$&!$&% ()+*,+*)-(,-+()+*,-*)-(,)+(,+*)-*,-()(+,*+)*-,(-(+)*+,*-)(-,+)(+,*-)*-,(","P -4 3 n":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& )(+,*+)*-,(-(+)*+,*-)(-,+)(+,*-)*-,(","F -4 3 c":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& )(+,*+)*-,(-(+)*+,*-)(-,+)(+,*-)*-,( )+$,+$)- ,-#()#*,&*)&(,!+(%+*!-*%-() #,$#)$&, &(#!*#%*&!(&%+! +%$-!$-% (!+*%+*!-(%-+ )+$,-$)- ,)#(,#*)&*,&(!(#%*#!*&%(& +!$+%$-! -%#) #,$&)$&, ()#*,#*)&(,&+(!+*%-*!-(%)+ ,+$)-$,- ! +%$+!$-% - #)$#,$&) &,#!(#%*&!*&%(","I -4 3 d":" !#*%+$)-(,&# !+*%-$)&(,!# %+*)-$,&(7354<9:6>8;=357<946>:;=857394<>:6=8;()+$,#*!& %-+()#$,&*!- %)+(,#$!&*%- :;98657<=43>;9:658<=73>49:;586=7<>43","P 4/m -3 2/m":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& ! &%$&!$#% # #%$#!$&% &!#!$#% &! &%$$%& !& %#$!#&$%& !# %#$!%&$!& %# !#$%$#! #% &!$&$&! &% #!$#%&% &!$#%$#! ","P 4/n -3 2/n":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& ! &%$&!$#% # #%$#!$&% &!#!$#% &! &%$*,-()-(,+*)+-*,-()+(,+*),-*)-(,+()+*,*+)(+,(-)*-*-)(-,(+)*+,-,(-)*+,*+)(","P 42/m -3 2/n":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& )(-,*-)*+,(+(+,*+)*-,(-)+)*+,(-)(-,*$%& !& %#$!#&$%& !# %#$!%&$!& %# !#$,*+)(+,(-)*-*-)(-,(+)*+,-,(-)*+,*+)(","P 42/n -3 2/m":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& )(-,*-)*+,(+(+,*+)*-,(-)+)*+,(-)(-,**,-()-(,+*)+-*,-()+(,+*),-*)-(,+()+*%$#! #% &!$&$&! &% #!$#%&% &!$#%$#! ","F 4/m -3 2/m":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& ! &%$&!$#% # #%$#!$&% &!#!$#% &! &%$$%& !& %#$!#&$%& !# %#$!%&$!& %# !#$%$#! #% &!$&$&! &% #!$#%&% &!$#%$#!  )+$,+$)- ,-#()#*,&*)&(,!+(%+*!-*%-(!(-%*-!*+%(+ +,$+)$-, -)#)*#,(&)(&,*$,- )- ,+$)+&*,&()#(,#*)%-*!-(%+(!+*%*+!(+%(-!*-$-) -, +)$+,&,(&)*#,*#)((!+*%+*!-(%-+ )+$,-$)- ,)#(,#*)&*,&() -,$-)$+, +(#,*#)*&,(&)+!*+%(-!(-%**%-(!-(%+*!+-$,- )+ ,+$),&*)&(,#()#*,$+) +, -)$-*&)(&,(#)*#,-%(-!*+%*+!(()#*,#*)&(,&+(!+*%-*!-(%)+ ,+$)-$,- )(&,*&)*#,(#(+%*+!*-%(-!+)$+, -) -,$*,&()&(,#*)#-*%-(!+(%+*!,-$)- ,+ )+$,*#)(#,(&)*&*-!(-%(+!*+%-, -)$+,$+) ","F 4/m -3 2/c":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& )(-,*-)*+,(+(+,*+)*-,(-)+)*+,(-)(-,*$%& !& %#$!#&$%& !# %#$!%&$!& %# !#$,*+)(+,(-)*-*-)(-,(+)*+,-,(-)*+,*+)( )+$,+$)- ,-#()#*,&*)&(,!+(%+*!-*%-() &,$&)$#, #(#%*#!*&%(&!+!$+% -! -%$$,- )- ,+$)+&*,&()#(,#*)%-*!-(%+(!+*,$#) #, &)$&*&!(&%(#!*#%-% -!$+%$+! (!+*%+*!-(%-+ )+$,-$)- ,)#(,#*)&*,&(!(&%*&!*#%(# +%$+!$-% -!#)$#, &) &,$*%-(!-(%+*!+-$,- )+ ,+$),&*)&(,#()#*%*#!(#%(&!*&$-! -% +!$+%&, &)$#,$#) ()#*,#*)&(,&+(!+*%-*!-(%)+ ,+$)-$,- ! -%$-!$+% + #,$#)$&, &)#!*#%(&!(&%**,&()&(,#*)#-*%-(!+(%+*!,-$)- ,+ )+$%$+! +% -!$-$&) &, #)$#,&%(&!*#%*#!(","F 41/d -3 2/m":" !#$,+*)&(%-# !+$,&*)-(%!# ,+$)&*%-(:3>46=7<98;5;58<976=43>:97<58;>:3=4664=3:>;85<79=64>3:5;89<74=6:>385;79<,$+! #%(-)*&*&)(-% #!$+,-%(&)*+,$#!  )+$%#*!-(,&#()+*%&$!- ,!+(,#*)-$%& :;=4<>765839;94<5:6>83=79:6543>7;=8<68>37=;49<:5=<8>;753496:4><:=;893756,*#!(+% &)$-*-!(&, +)$#%-, &!$+%*#)((!+*,#$)- %&+ )#$%-*!&(,)#(%+*!&$,- 73=86>:<54;935469:<=8;>7576983=:;>4<<4>;:=389675>68=379;45<:8=<7>;453:96%$#) +,(&!*-$&! -,(#)*+%&% -)$#,*+!(()#*%+$!& ,-+(!#*,-$)& %)+ %#$!-*,&(7;>8<=:69435398657<>4;=:5:<94;=73>86<8=;7>3456:9><4=;:9385678>67=349;:5<%*+)(#, -!$&$-) &%(+!*#,&,(-!*#%$+) ","F 41/d -3 2/c":" !#$,+*)&(%-# !+$,&*)-(%!# ,+$)&*%-(:3>46=7<98;5;58<976=43>:97<58;>:3=46<8>;7=3496:5><8=;793456:8><7=;493:56%*#)(+, &!$-$-! &,(+)*#%&, -!$#%*+)( )+$%#*!-(,&#()+*%&$!- ,!+(,#*)-$%& :;=4<>765839;94<5:6>83=79:6543>7;=8<<4=;:>385679>64=3:9;85<78=67>345;:9<%$+) #,(-!*&$&) -%(#!*+,&%(-)*#,$+! (!+*,#$)- %&+ )#$%-*!&(,)#(%+*!&$,- 73=86>:<54;935469:<=8;>7576983=:;>4<68=37>;45<:9=<4>;:5389674>6:=389;75<,*+!(#% -)$&*-)(&% +!$#,-,(&!*+%$#) ()#*%+$!& ,-+(!#*,-$)& %)+ %#$!-*,&(7;>8<=:69435398657<>4;=:5:<94;=73>8664>3:=;89<75=68>375;49<:4=<:>;853796,$#! +%(&)*-*&!(-, #)$+%-% &)$+,*#!(","I 4/m -3 2/m":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& ! &%$&!$#% # #%$#!$&% &!#!$#% &! &%$$%& !& %#$!#&$%& !# %#$!%&$!& %# !#$%$#! #% &!$&$&! &% #!$#%&% &!$#%$#! ()+*,+*)-(,-+()+*,-*)-(,)+(,+*)-*,-()(-,*-)*+,(+(+,*+)*-,(-)+)*+,(-)(-,**,-()-(,+*)+-*,-()+(,+*),-*)-(,+()+*,*+)(+,(-)*-*-)(-,(+)*+,-,(-)*+,*+)(","I 41/a -3 2/d":" !#*%+$)-(,&# !+*%-$)&(,!# %+*)-$,&(:3=8<>7694;5;54697<>83=:97654;=:3>8<$%&(!- ,+*)#&$%-(!+ ,#*)%&$!-(,+ )#*4<97358;=:6>6>:;=8357<94=8;>:694<573()+$,#*!& %-+()#$,&*!- %)+(,#$!&*%- 7;>46=:<5839398<5:6=4;>75:<983>7;=46*,- )&(%#$!+-*,& )#(%+$!,-*)& %#(!+$865:;943>7<=<=73>4;9:658>43=7<5869:;","P 1 1 2":" !#$%#","P 1 1 21":" !#$%+","B 1 1 2":" !#$%#(g+*%+","A 1 2 1":" !#$!& )+$)-","C 1 21 1":" !#$)&()#*!&","I 1 2 1":" !#$!&.'/0'2","I 1 21 1":" !#$)&.'/0!-","P 1 1 m":" !# !&","P 1 1 b":" !# )&","B 1 1 m":" !# !&(!+(!-","B 1 1 b":" !# )&(!+()-","P 1 1 2/m":" !# !&$%#$%&","P 1 1 21/m":" !#$%+$%& !-","B 1 1 2/m":" !# !&$%#$%&(!+(!-*%+*%-","P 1 1 2/b":" !#$,#$%& )&","P 1 1 21/b":" !#$%&$,+ )-","B 1 1 2/b":" !#$,#$%& )&(!+*,+*%-()-","P 21 2 2":" !#$!&(%&*%#","P 2 21 2":" !# ,&$)&$%#","P 21 21 2 (a)":" !#*,#.%&$'&","P 21 2 21":" !#$!&(%-*%+","P 2 21 21":" !# %&$)-$,+","C 2 2 21a)":" !#*%+(,&$)-()#$,+ %&*!-","C 2 2 2a":" !#*,#.%&$'&()#$%# ,&*!&","F 2 2 2a":" !#*,#.%&$'& '/*%/.12$!2.!/$,/ %20'2.'#$%# 1&0!&","I 2 2 2a":" !#*,#.%&$'&()+$%+*!- ,-","P 21/m 21/m 2/n a":" !#*,#$)&(%&$%&.'& ,#*!#","P 42 21 2a":" !#*,#%.+'$+$'&.%&! -,*-","I 2 3a":" !#*,#.%&$'&!# ,- '&$%/$# !-*!/$%&.%()+$%+ ,-*!-)+(%&(!-*,#*+()&$)#*,- ,"},Yy=function(t){this.name=t||"",this.partList=[]},Zy={type:{configurable:!0}};Zy.type.get=function(){return"Assembly"},Yy.prototype.addPart=function(t,e){var i=new Ky(t,e);return this.partList.push(i),i},Yy.prototype._getCount=function(t,e){var i=0;return this.partList.forEach(function(r){i+=r[e](t)}),i},Yy.prototype.getAtomCount=function(t){return this._getCount(t,"getAtomCount")},Yy.prototype.getResidueCount=function(t){return this._getCount(t,"getResidueCount")},Yy.prototype.getInstanceCount=function(){var t=0;return this.partList.forEach(function(e){t+=e.matrixList.length}),t},Yy.prototype.isIdentity=function(t){if(1!==this.partList.length)return!1;var e=this.partList[0];if(1!==e.matrixList.length)return!1;if(!(new y).equals(e.matrixList[0]))return!1;var i=[];return t.eachChain(function(t){i.push(t.chainname)}),i=Xn(i),e.chainList.length===i.length},Yy.prototype.getBoundingBox=function(t){var e=new lt;return this.partList.forEach(function(i){var r=i.getBoundingBox(t);e.expandByPoint(r.min),e.expandByPoint(r.max)}),e},Yy.prototype.getCenter=function(t){return this.getBoundingBox(t).getCenter()},Yy.prototype.getSelection=function(){var t=[];return this.partList.forEach(function(e){t=t.concat(e.chainList)}),Os(t)},Object.defineProperties(Yy.prototype,Zy);var Ky=function(t,e){this.matrixList=t||[],this.chainList=e||[]},Qy={type:{configurable:!0}};Qy.type.get=function(){return"AssemblyPart"},Ky.prototype._getCount=function(t,e){var i=0,r=this.chainList;return t.eachChain(function(t){(0===r.length||r.includes(t.chainname))&&(i+=t[e])}),this.matrixList.length*i},Ky.prototype.getAtomCount=function(t){return this._getCount(t,"atomCount")},Ky.prototype.getResidueCount=function(t){return this._getCount(t,"residueCount")},Ky.prototype.getBoundingBox=function(t){var e=new lt,i=new lt,r=this.getSelection(),n=t.getBoundingBox(r);return this.matrixList.forEach(function(t){i.copy(n).applyMatrix4(t),e.expandByPoint(i.min),e.expandByPoint(i.max)}),e},Ky.prototype.getSelection=function(){return Os(this.chainList)},Ky.prototype.getView=function(t){var e=this.getSelection();return e?t.getView(e):t},Ky.prototype.getInstanceList=function(){for(var t=this,e=[],i=0,r=this.matrixList.length;i<r;++i)e.push({id:i+1,name:i,matrix:t.matrixList[i]});return e},Object.defineProperties(Ky.prototype,Qy);var Jy=function(){var e=function(t,e,i,r){for(var n=t.structure,o=t.residueIndexStart,a=n.getResidueProxy(),s=n.getResidueProxy(),c=n.getAtomProxy(),u=n.getAtomProxy(),l=Math.max(0,e-2);l<=e;++l)for(var h=2;h<5;++h)if(!(l+h>=t.residueCount)){a.index=o+l,s.index=o+l+h,c.index=a.traceAtomIndex,u.index=s.traceAtomIndex;var p=c.distanceTo(u);if(Math.abs(p-i[h-2])>r)return!1}return!0},i=function(t,i){return e(t,i,[5.45,5.18,6.37],2.1)},r=function(t,i){return e(t,i,[6.1,10.4,13],1.42)},n=function(t){for(var e=t.residueStore,n=t.residueIndexStart,o=0,a=t.residueCount;o<a;++o){var s="c";i(t,o)?s="h":r(t,o)&&(s="s"),e.sstruc[n+o]=s.charCodeAt(0)}},o=function(t){for(var e=t.residueStore,i=t.residueIndexStart,r=new Ts(t).position,n=new v,o=new v,a=0,s=t.residueCount;a<s;++a){n.fromArray(r.center,3*a),o.fromArray(r.center,3*a+3);var c=n.distanceTo(o);c<2&&c>1&&r.bending[a]<20&&(e.sstruc[i+a]="h".charCodeAt(0),e.sstruc[i+a+1]="h".charCodeAt(0))}};return function(e){t.Debug&&vm.time("calculateSecondaryStructure"),e.eachPolymer(function(t){if(!(t.residueCount<4)){if(t.isCg())o(t);else{if(!t.isProtein())return;n(t)}var e,i=0;t.eachResidue(function(t){t.sstruc===e?i+=1:(1===i&&(t.index-=1,t.sstruc="c"),i=1,e=t.sstruc)})}}),t.Debug&&vm.timeEnd("calculateSecondaryStructure")}}(),tb="ABCDEFGHIJKLMNOPQRSTUVWXYZ",eb=["H","C","O","N","S","P"],ib=["NA","CL","FE"],rb=function(t,e,i){this.structure=t,i=i||Gs(e),this.atomname=e,this.element=i,this.vdw=fy[i],this.covalent=my[i]},nb=function(t){this.structure=t,this.dict={},this.list=[]};nb.prototype.add=function(t,e){var i=Hs(t=t.toUpperCase(),e=e?e.toUpperCase():Gs(t)),r=this.dict[i];if(void 0===r){var n=new rb(this.structure,t,e);r=this.list.length,this.dict[i]=r,this.list.push(n)}return r},nb.prototype.get=function(t){return this.list[t]};var ob=function(t,e,i,r,n,o){this.structure=t,this.resname=e,this.atomTypeIdList=i,this.hetero=r?1:0,this.chemCompType=n,this.bonds=o,this.rings=void 0,this.atomCount=i.length,this.moleculeType=this.getMoleculeType(),this.backboneType=this.getBackboneType(0),this.backboneEndType=this.getBackboneType(-1),this.backboneStartType=this.getBackboneType(1),this.backboneIndexList=this.getBackboneIndexList();var a=Ty[this.backboneType],s=Ty[this.backboneStartType],c=Ty[this.backboneEndType],u=this.getAtomIndexByName(a.trace);this.traceAtomIndex=void 0!==u?u:-1;var l=this.getAtomIndexByName(a.direction1);this.direction1AtomIndex=void 0!==l?l:-1;var h=this.getAtomIndexByName(a.direction2);this.direction2AtomIndex=void 0!==h?h:-1;var p=this.getAtomIndexByName(s.backboneStart);this.backboneStartAtomIndex=void 0!==p?p:-1;var d=this.getAtomIndexByName(c.backboneEnd);this.backboneEndAtomIndex=void 0!==d?d:-1;var f;f=wy.includes(e)?this.getAtomIndexByName("N1"):this.getAtomIndexByName("N3"),this.rungEndAtomIndex=void 0!==f?f:-1,this.bondReferenceAtomIndices=[]};ob.prototype.getBackboneIndexList=function(){var t,e=[];switch(this.moleculeType){case 3:t=Py;break;case 4:case 5:t=Ey;break;default:return e}for(var i=this.structure.atomMap,r=this.atomTypeIdList,n=0,o=this.atomCount;n<o;++n){var a=i.get(r[n]);t.includes(a.atomname)&&e.push(n)}return e},ob.prototype.getMoleculeType=function(){return this.isProtein()?3:this.isRna()?4:this.isDna()?5:this.isWater()?1:this.isIon()?2:this.isSaccharide()?6:0},ob.prototype.getBackboneType=function(t){return this.hasProteinBackbone(t)?1:this.hasRnaBackbone(t)?2:this.hasDnaBackbone(t)?3:this.hasCgProteinBackbone(t)?4:this.hasCgRnaBackbone(t)?5:this.hasCgDnaBackbone(t)?6:ny},ob.prototype.isProtein=function(){return this.chemCompType?oy.includes(this.chemCompType):this.hasAtomWithName("CA","C","N")||by.includes(this.resname)},ob.prototype.isCg=function(){var t=this.backboneType;return 4===t||5===t||6===t},ob.prototype.isNucleic=function(){return this.isRna()||this.isDna()},ob.prototype.isRna=function(){return this.chemCompType?ay.includes(this.chemCompType):this.hasAtomWithName(["P","O3'","O3*"],["C4'","C4*"],["O2'","O2*","F2'","F2*"])||xy.includes(this.resname)&&this.hasAtomWithName(["O2'","O2*","F2'","F2*"])},ob.prototype.isDna=function(){return this.chemCompType?sy.includes(this.chemCompType):this.hasAtomWithName(["P","O3'","O3*"],["C3'","C3*"])&&!this.hasAtomWithName(["O2'","O2*","F2'","F2*"])||_y.includes(this.resname)},ob.prototype.isHetero=function(){return 1===this.hetero},ob.prototype.isIon=function(){return Ay.includes(this.resname)},ob.prototype.isWater=function(){return Sy.includes(this.resname)},ob.prototype.isSaccharide=function(){return this.chemCompType?cy.includes(this.chemCompType):My.includes(this.resname)},ob.prototype.hasBackboneAtoms=function(t,e){var i=Ty[e];return-1===t?this.hasAtomWithName(i.trace,i.backboneEnd,i.direction1,i.direction2):0===t?this.hasAtomWithName(i.trace,i.direction1,i.direction2):1===t?this.hasAtomWithName(i.trace,i.backboneStart,i.direction1,i.direction2):this.hasAtomWithName(i.trace,i.backboneStart,i.backboneEnd,i.direction1,i.direction2)},ob.prototype.hasProteinBackbone=function(t){return this.isProtein()&&this.hasBackboneAtoms(t,1)},ob.prototype.hasRnaBackbone=function(t){return this.isRna()&&this.hasBackboneAtoms(t,2)},ob.prototype.hasDnaBackbone=function(t){return this.isDna()&&this.hasBackboneAtoms(t,3)},ob.prototype.hasCgProteinBackbone=function(t){return this.atomCount<7&&this.isProtein()&&this.hasBackboneAtoms(t,4)},ob.prototype.hasCgRnaBackbone=function(t){return this.atomCount<11&&this.isRna()&&this.hasBackboneAtoms(t,5)},ob.prototype.hasCgDnaBackbone=function(t){return this.atomCount<11&&this.isDna()&&this.hasBackboneAtoms(t,6)},ob.prototype.hasBackbone=function(t){return this.hasProteinBackbone(t)||this.hasRnaBackbone(t)||this.hasDnaBackbone(t)||this.hasCgProteinBackbone(t)||this.hasCgRnaBackbone(t)||this.hasCgDnaBackbone(t)},ob.prototype.getAtomIndexByName=function(t){var e=this.atomCount,i=this.structure.atomMap,r=this.atomTypeIdList;if(Array.isArray(t))for(var n=0;n<e;++n){var o=r[n];if(t.includes(i.get(o).atomname))return n}else for(var a=0;a<e;++a){var s=r[a];if(t===i.get(s).atomname)return a}},ob.prototype.hasAtomWithName=function(){for(var t=arguments,e=this,i=arguments.length,r=0;r<i;++r)if(void 0!==t[r]&&void 0===e.getAtomIndexByName(t[r]))return!1;return!0},ob.prototype.getBonds=function(t){return void 0===this.bonds&&(this.bonds=Fs(t)),this.bonds},ob.prototype.getRings=function(){return void 0===this.rings&&this.calculateRings(),this.rings},ob.prototype.getBondGraph=function(){return void 0===this.bondGraph&&this.calculateBondGraph(),this.bondGraph},ob.prototype.calculateBondGraph=function(){for(var t=this.bondGraph={},e=this.getBonds(),i=e.atomIndices1.length,r=e.atomIndices1,n=e.atomIndices2,o=0;o<i;++o){var a=r[o],s=n[o];(t[a]=t[a]||[]).push(s),(t[s]=t[s]||[]).push(a)}},ob.prototype.calculateRings=function(){function t(a,s,c){if(i[a])throw new Error("DFS revisited atom");i[a]=1,o.push(a);for(var u=s.length,l=0;l<u;++l){var h=s[l];if(0===i[h])e[h]&&e[h].length>=2?t(h,e[h],a):i[h]=2;else if(1===i[h]&&c&&c!==h){var p=[h];r[h]=1,n.push(p);for(var d=o.length-1;d>=0;--d){var f=o[d];if(f===h)break;p.push(f),r[f]=1}}}i[a]=2,o.pop()}for(var e=this.getBondGraph(),i=new Int8Array(this.atomCount),r=new Int8Array(this.atomCount),n=[],o=[],a=0;a<this.atomCount;++a)if(!i[a]){var s=e[a];!s||s.length<2?i[a]=2:(o.length=0,t(a,s))}this.rings={flags:r,rings:n}},ob.prototype.assignBondReferenceAtomIndices=function(){var t=this.getBondGraph(),e=this.getRings(),i=e.flags,r=e.rings,n=this.bonds.atomIndices1,o=this.bonds.atomIndices2,a=this.bonds.bondOrders,s=this.bondReferenceAtomIndices,c=this.bonds.atomIndices1.length;s.length=0;for(var u=0;u<c;++u)if(!(a[u]<=1)){var l=n[u],h=o[u];if(i[l]&&i[h]){for(var p=0;p<r.length&&void 0===s[u];++p)for(var d=r[p],f=null,m=!1,g=0;g<d.length;++g){var v=d[g];if(v===l||v===h?m=!0:f=v,m&&null!==f){s[u]=f;break}}if(void 0!==s[u])continue}if(t[l].length>1)for(var y=0;y<t[l].length;++y){var b=t[l][y];if(b!==h){s[u]=b;break}}else if(t[h].length>1)for(var x=0;x<t[h].length;++x){var _=t[h][x];if(_!==l){s[u]=_;break}}else;}},ob.prototype.getBondIndex=function(t,e){for(var i=this.bonds,r=i.atomIndices1,n=i.atomIndices2,o=r.indexOf(t),a=n.indexOf(e),s=a;-1!==o;){for(;-1!==a;){if(o===a)return o;a=n.indexOf(e,a+1)}o=r.indexOf(t,o+1),a=s}},ob.prototype.getBondReferenceAtomIndex=function(t,e){var i=this.getBondIndex(t,e);if(void 0!==i)return 0===this.bondReferenceAtomIndices.length&&this.assignBondReferenceAtomIndices(),this.bondReferenceAtomIndices[i]};var ab=function(t){this.structure=t,this.dict={},this.list=[]};ab.prototype.add=function(t,e,i,r,n){var o=Ws(t=t.toUpperCase(),e,i,r),a=this.dict[o];if(void 0===a){var s=new ob(this.structure,t,e,i,r,n);a=this.list.length,this.dict[o]=a,this.list.push(s)}return a},ab.prototype.get=function(t){return this.list[t]};var sb=function(t,e){this.structure=t,this.bondStore=t.bondStore,this.index=e,this._v12=new v,this._v13=new v,this._ap1=this.structure.getAtomProxy(),this._ap2=this.structure.getAtomProxy(),this._ap3=this.structure.getAtomProxy()},cb={atom1:{configurable:!0},atom2:{configurable:!0},atomIndex1:{configurable:!0},atomIndex2:{configurable:!0},bondOrder:{configurable:!0}};cb.atom1.get=function(){return this.structure.getAtomProxy(this.atomIndex1)},cb.atom2.get=function(){return this.structure.getAtomProxy(this.atomIndex2)},cb.atomIndex1.get=function(){return this.bondStore.atomIndex1[this.index]},cb.atomIndex1.set=function(t){this.bondStore.atomIndex1[this.index]=t},cb.atomIndex2.get=function(){return this.bondStore.atomIndex2[this.index]},cb.atomIndex2.set=function(t){this.bondStore.atomIndex2[this.index]=t},cb.bondOrder.get=function(){return this.bondStore.bondOrder[this.index]},cb.bondOrder.set=function(t){this.bondStore.bondOrder[this.index]=t},sb.prototype.getReferenceAtomIndex=function(){var t=this._ap1,e=this._ap2;if(t.index=this.atomIndex1,e.index=this.atomIndex2,t.residueIndex===e.residueIndex){var i=t.index-t.residueAtomOffset,r=e.index-e.residueAtomOffset,n=t.residueType.getBondReferenceAtomIndex(i,r);if(void 0!==n)return n+t.residueAtomOffset;console.warn("No reference atom found",t.index,e.index)}},sb.prototype.calculateShiftDir=function(t){t||(t=new v);var e=this._ap1,i=this._ap2,r=this._ap3,n=this._v12,o=this._v13;e.index=this.atomIndex1,i.index=this.atomIndex2;var a=this.getReferenceAtomIndex();n.subVectors(e,i).normalize(),void 0!==a?(r.index=a,o.subVectors(e,r)):o.copy(e),o.normalize();var s=n.dot(o);return 1-Math.abs(s)<1e-5&&(o.set(1,0,0),s=n.dot(o),1-Math.abs(s)<1e-5&&(o.set(0,1,0),s=n.dot(o))),t.copy(o.sub(n.multiplyScalar(s))).normalize()},sb.prototype.qualifiedName=function(){return this.atomIndex1+"="+this.atomIndex2},sb.prototype.clone=function(){return new this.constructor(this.structure,this.index)},sb.prototype.toObject=function(){return{atomIndex1:this.atomIndex1,atomIndex2:this.atomIndex2,bondOrder:this.bondOrder}},Object.defineProperties(sb.prototype,cb);var ub=function(t,e){this.structure=t,this.chainStore=t.chainStore,this.residueStore=t.residueStore,this.atomStore=t.atomStore,this.residueMap=t.residueMap,this.atomMap=t.atomMap,this.index=e},lb={bondHash:{configurable:!0},entity:{configurable:!0},entityIndex:{configurable:!0},modelIndex:{configurable:!0},chainIndex:{configurable:!0},residue:{configurable:!0},residueIndex:{configurable:!0},sstruc:{configurable:!0},inscode:{configurable:!0},resno:{configurable:!0},chainname:{configurable:!0},chainid:{configurable:!0},residueType:{configurable:!0},atomType:{configurable:!0},residueAtomOffset:{configurable:!0},resname:{configurable:!0},hetero:{configurable:!0},atomname:{configurable:!0},element:{configurable:!0},vdw:{configurable:!0},covalent:{configurable:!0},x:{configurable:!0},y:{configurable:!0},z:{configurable:!0},serial:{configurable:!0},bfactor:{configurable:!0},occupancy:{configurable:!0},altloc:{configurable:!0},partialCharge:{configurable:!0},formalCharge:{configurable:!0}};lb.bondHash.get=function(){return this.structure.bondHash},lb.entity.get=function(){return this.structure.entityList[this.entityIndex]},lb.entityIndex.get=function(){return this.chainStore.entityIndex[this.chainIndex]},lb.modelIndex.get=function(){return this.chainStore.modelIndex[this.chainIndex]},lb.chainIndex.get=function(){return this.residueStore.chainIndex[this.residueIndex]},lb.residue.get=function(){return console.warn("residue - might be expensive"),this.structure.getResidueProxy(this.residueIndex)},lb.residueIndex.get=function(){return this.atomStore.residueIndex[this.index]},lb.residueIndex.set=function(t){this.atomStore.residueIndex[this.index]=t},lb.sstruc.get=function(){return this.residueStore.getSstruc(this.residueIndex)},lb.inscode.get=function(){return this.residueStore.getInscode(this.residueIndex)},lb.resno.get=function(){return this.residueStore.resno[this.residueIndex]},lb.chainname.get=function(){return this.chainStore.getChainname(this.chainIndex)},lb.chainid.get=function(){return this.chainStore.getChainid(this.chainIndex)},lb.residueType.get=function(){return this.residueMap.get(this.residueStore.residueTypeId[this.residueIndex])},lb.atomType.get=function(){return this.atomMap.get(this.atomStore.atomTypeId[this.index])},lb.residueAtomOffset.get=function(){return this.residueStore.atomOffset[this.residueIndex]},lb.resname.get=function(){return this.residueType.resname},lb.hetero.get=function(){return this.residueType.hetero},lb.atomname.get=function(){return this.atomType.atomname},lb.element.get=function(){return this.atomType.element},lb.vdw.get=function(){return this.atomType.vdw},lb.covalent.get=function(){return this.atomType.covalent},lb.x.get=function(){return this.atomStore.x[this.index]},lb.x.set=function(t){this.atomStore.x[this.index]=t},lb.y.get=function(){return this.atomStore.y[this.index]},lb.y.set=function(t){this.atomStore.y[this.index]=t},lb.z.get=function(){return this.atomStore.z[this.index]},lb.z.set=function(t){this.atomStore.z[this.index]=t},lb.serial.get=function(){return this.atomStore.serial[this.index]},lb.serial.set=function(t){this.atomStore.serial[this.index]=t},lb.bfactor.get=function(){return this.atomStore.bfactor[this.index]},lb.bfactor.set=function(t){this.atomStore.bfactor[this.index]=t},lb.occupancy.get=function(){return this.atomStore.occupancy[this.index]},lb.occupancy.set=function(t){this.atomStore.occupancy[this.index]=t},lb.altloc.get=function(){return this.atomStore.getAltloc(this.index)},lb.altloc.set=function(t){this.atomStore.setAltloc(this.index,t)},lb.partialCharge.get=function(){return this.atomStore.partialCharge?this.atomStore.partialCharge[this.index]:null},lb.partialCharge.set=function(t){this.atomStore.partialCharge&&(this.atomStore.partialCharge[this.index]=t)},lb.formalCharge.get=function(){return this.atomStore.formalCharge?this.atomStore.formalCharge[this.index]:null},lb.formalCharge.set=function(t){this.atomStore.formalCharge&&(this.atomStore.formalCharge[this.index]=t)},ub.prototype.eachBond=function(t,e){e=e||this.structure._bp;for(var i=this.index,r=this.bondHash,n=r.indexArray,o=r.countArray[i],a=r.offsetArray[i],s=0;s<o;++s)e.index=n[a+s],t(e)},ub.prototype.eachBondedAtom=function(t,e){e=e||this.structure._ap;var i=this.index;this.eachBond(function(r){i!==r.atomIndex1?e.index=r.atomIndex1:e.index=r.atomIndex2,t(e)})},ub.prototype.hasBondTo=function(t){var e=!1;return this.eachBondedAtom(function(i){t.index===i.index&&(e=!0)}),e},ub.prototype.isBackbone=function(){var t=this.residueType.backboneIndexList;if(t.length>0){var e=this.residueStore.atomOffset[this.residueIndex];return t.includes(this.index-e)}return!1},ub.prototype.isPolymer=function(){if(this.structure.entityList.length>0)return this.entity.isPolymer();var t=this.residueType.moleculeType;return 3===t||4===t||5===t},ub.prototype.isSidechain=function(){return this.isPolymer()&&!this.isBackbone()},ub.prototype.isCg=function(){var t=this.residueType.backboneType;return 4===t||5===t||6===t},ub.prototype.isHetero=function(){return 1===this.residueType.hetero},ub.prototype.isProtein=function(){return 3===this.residueType.moleculeType},ub.prototype.isNucleic=function(){var t=this.residueType.moleculeType;return 4===t||5===t},ub.prototype.isRna=function(){return 4===this.residueType.moleculeType},ub.prototype.isDna=function(){return 5===this.residueType.moleculeType},ub.prototype.isWater=function(){return 1===this.residueType.moleculeType},ub.prototype.isIon=function(){return 2===this.residueType.moleculeType},ub.prototype.isSaccharide=function(){return 6===this.residueType.moleculeType},ub.prototype.isHelix=function(){return hy.includes(this.sstruc)},ub.prototype.isSheet=function(){return py.includes(this.sstruc)},ub.prototype.isTurn=function(){return dy.includes(this.sstruc)&&this.isProtein()},ub.prototype.isBonded=function(){return 0!==this.bondHash.countArray[this.index]},ub.prototype.isRing=function(){return 1===this.residueType.getRings().flags[this.index-this.residueAtomOffset]},ub.prototype.distanceTo=function(t){var e=this.atomStore,i=t.atomStore,r=this.index,n=t.index,o=e.x[r]-i.x[n],a=e.y[r]-i.y[n],s=e.z[r]-i.z[n],c=o*o+a*a+s*s;return Math.sqrt(c)},ub.prototype.connectedTo=function(t){var e=this.atomStore,i=t.atomStore,r=this.index,n=t.index;if(e.altloc&&i.altloc){var o=e.altloc[r],a=i.altloc[n];if(0!==o&&0!==a&&32!==o&&32!==a&&o!==a)return!1}var s=e.x[r]-i.x[n],c=e.y[r]-i.y[n],u=e.z[r]-i.z[n],l=s*s+c*c+u*u;if(l<64&&this.isCg())return!0;if(isNaN(l))return!1;var h=this.covalent+t.covalent,p=h+.3,d=h-.5;return l<p*p&&l>d*d},ub.prototype.positionFromArray=function(t,e){return void 0===e&&(e=0),this.x=t[e+0],this.y=t[e+1],this.z=t[e+2],this},ub.prototype.positionToArray=function(t,e){void 0===t&&(t=[]),void 0===e&&(e=0);var i=this.index,r=this.atomStore;return t[e+0]=r.x[i],t[e+1]=r.y[i],t[e+2]=r.z[i],t},ub.prototype.positionToVector3=function(t){return void 0===t&&(t=new v),t.x=this.x,t.y=this.y,t.z=this.z,t},ub.prototype.positionFromVector3=function(t){return this.x=t.x,this.y=t.y,this.z=t.z,this},ub.prototype.positionAdd=function(t){return this.x+=t.x,this.y+=t.y,this.z+=t.z,this},ub.prototype.positionSub=function(t){return this.x-=t.x,this.y-=t.y,this.z-=t.z,this},ub.prototype.getResidueBonds=function(t){var e,i,r,n,o=this.residueAtomOffset,a=this.index-this.residueAtomOffset,s=this.residueType.getBonds(),c=s.atomIndices1,u=s.atomIndices2;for(t||(n=[]),e=c.indexOf(a);-1!==e;){if(r=u[e]+o,t)return r;n.push(r),e=c.indexOf(a,e+1)}for(i=u.indexOf(a);-1!==i;){if(r=c[i]+o,t)return r;n.push(r),i=u.indexOf(a,i+1)}return n},ub.prototype.qualifiedName=function(t){var e="";return this.resname&&!t&&(e+="["+this.resname+"]"),void 0!==this.resno&&(e+=this.resno),this.inscode&&(e+="^"+this.inscode),this.chainname&&(e+=":"+this.chainname),this.atomname&&(e+="."+this.atomname),this.altloc&&(e+="%"+this.altloc),this.structure.modelStore.count>1&&(e+="/"+this.modelIndex),e},ub.prototype.clone=function(){return new this.constructor(this.structure,this.index)},ub.prototype.toObject=function(){return{index:this.index,residueIndex:this.residueIndex,atomno:this.atomno,resname:this.resname,x:this.x,y:this.y,z:this.z,element:this.element,chainname:this.chainname,resno:this.resno,serial:this.serial,vdw:this.vdw,covalent:this.covalent,hetero:this.hetero,bfactor:this.bfactor,altloc:this.altloc,atomname:this.atomname,modelindex:this.modelindex}},Object.defineProperties(ub.prototype,lb);var hb=function(t,e){this.structure=t,this.chainStore=t.chainStore,this.residueStore=t.residueStore,this.atomStore=t.atomStore,this.residueMap=t.residueMap,this.atomMap=t.atomMap,this.index=e},pb={entity:{configurable:!0},entityIndex:{configurable:!0},chain:{configurable:!0},chainIndex:{configurable:!0},atomOffset:{configurable:!0},atomCount:{configurable:!0},atomEnd:{configurable:!0},modelIndex:{configurable:!0},chainname:{configurable:!0},chainid:{configurable:!0},resno:{configurable:!0},sstruc:{configurable:!0},inscode:{configurable:!0},residueType:{configurable:!0},resname:{configurable:!0},hetero:{configurable:!0},moleculeType:{configurable:!0},backboneType:{configurable:!0},backboneStartType:{configurable:!0},backboneEndType:{configurable:!0},traceAtomIndex:{configurable:!0},direction1AtomIndex:{configurable:!0},direction2AtomIndex:{configurable:!0},backboneStartAtomIndex:{configurable:!0},backboneEndAtomIndex:{configurable:!0},rungEndAtomIndex:{configurable:!0}};pb.entity.get=function(){return this.structure.entityList[this.entityIndex]},pb.entityIndex.get=function(){return this.chainStore.entityIndex[this.chainIndex]},pb.chain.get=function(){return this.structure.getChainProxy(this.chainIndex)},pb.chainIndex.get=function(){return this.residueStore.chainIndex[this.index]},pb.chainIndex.set=function(t){this.residueStore.chainIndex[this.index]=t},pb.atomOffset.get=function(){return this.residueStore.atomOffset[this.index]},pb.atomOffset.set=function(t){this.residueStore.atomOffset[this.index]=t},pb.atomCount.get=function(){return this.residueStore.atomCount[this.index]},pb.atomCount.set=function(t){this.residueStore.atomCount[this.index]=t},pb.atomEnd.get=function(){return this.atomOffset+this.atomCount-1},pb.modelIndex.get=function(){return this.chainStore.modelIndex[this.chainIndex]},pb.chainname.get=function(){return this.chainStore.getChainname(this.chainIndex)},pb.chainid.get=function(){return this.chainStore.getChainid(this.chainIndex)},pb.resno.get=function(){return this.residueStore.resno[this.index]},pb.resno.set=function(t){this.residueStore.resno[this.index]=t},pb.sstruc.get=function(){return this.residueStore.getSstruc(this.index)},pb.sstruc.set=function(t){this.residueStore.setSstruc(this.index,t)},pb.inscode.get=function(){return this.residueStore.getInscode(this.index)},pb.inscode.set=function(t){this.residueStore.getInscode(this.index,t)},pb.residueType.get=function(){return this.residueMap.get(this.residueStore.residueTypeId[this.index])},pb.resname.get=function(){return this.residueType.resname},pb.hetero.get=function(){return this.residueType.hetero},pb.moleculeType.get=function(){return this.residueType.moleculeType},pb.backboneType.get=function(){return this.residueType.backboneType},pb.backboneStartType.get=function(){return this.residueType.backboneStartType},pb.backboneEndType.get=function(){return this.residueType.backboneEndType},pb.traceAtomIndex.get=function(){return this.residueType.traceAtomIndex+this.atomOffset},pb.direction1AtomIndex.get=function(){return this.residueType.direction1AtomIndex+this.atomOffset},pb.direction2AtomIndex.get=function(){return this.residueType.direction2AtomIndex+this.atomOffset},pb.backboneStartAtomIndex.get=function(){return this.residueType.backboneStartAtomIndex+this.atomOffset},pb.backboneEndAtomIndex.get=function(){return this.residueType.backboneEndAtomIndex+this.atomOffset},pb.rungEndAtomIndex.get=function(){return this.residueType.rungEndAtomIndex+this.atomOffset},hb.prototype.eachAtom=function(t,e){var i,r=this.atomCount,n=this.atomOffset,o=this.structure._ap,a=n+r;if(e&&e.atomOnlyTest){var s=e.atomOnlyTest;for(i=n;i<a;++i)o.index=i,s(o)&&t(o)}else for(i=n;i<a;++i)o.index=i,t(o)},hb.prototype.isProtein=function(){return 3===this.residueType.moleculeType},hb.prototype.isNucleic=function(){var t=this.residueType.moleculeType;return 4===t||5===t},hb.prototype.isRna=function(){return 4===this.residueType.moleculeType},hb.prototype.isDna=function(){return 5===this.residueType.moleculeType},hb.prototype.isCg=function(){var t=this.residueType.backboneType;return 4===t||5===t||6===t},hb.prototype.isPolymer=function(){if(this.structure.entityList.length>0)return this.entity.isPolymer();var t=this.residueType.moleculeType;return 3===t||4===t||5===t},hb.prototype.isHetero=function(){return 1===this.residueType.hetero},hb.prototype.isWater=function(){return 1===this.residueType.moleculeType},hb.prototype.isIon=function(){return 2===this.residueType.moleculeType},hb.prototype.isSaccharide=function(){return 6===this.residueType.moleculeType},hb.prototype.isHelix=function(){return hy.includes(this.sstruc)},hb.prototype.isSheet=function(){return py.includes(this.sstruc)},hb.prototype.isTurn=function(){return dy.includes(this.sstruc)&&this.isProtein()},hb.prototype.getAtomType=function(t){return this.atomMap.get(this.atomStore.atomTypeId[t])},hb.prototype.getResname1=function(){return yy[this.resname.toUpperCase()]||"X"},hb.prototype.getBackboneType=function(t){switch(t){case-1:return this.residueType.backboneStartType;case 1:return this.residueType.backboneEndType;default:return this.residueType.backboneType}},hb.prototype.getAtomIndexByName=function(t){var e=this.residueType.getAtomIndexByName(t);return void 0!==e&&(e+=this.atomOffset),e},hb.prototype.getAtomByName=function(t){return this.residueType.getAtomByName(t)},hb.prototype.hasAtomWithName=function(t){return this.residueType.hasAtomWithName(t)},hb.prototype.getAtomnameList=function(){var t=this;console.warn("getAtomnameList - might be expensive");for(var e=this.atomCount,i=this.atomOffset,r=new Array(e),n=0;n<e;++n)r[n]=t.getAtomType(i+n).atomname;return r},hb.prototype.connectedTo=function(t){var e=this.structure.getAtomProxy(this.backboneEndAtomIndex),i=this.structure.getAtomProxy(t.backboneStartAtomIndex);return!(!e||!i)&&e.connectedTo(i)},hb.prototype.getNextConnectedResidue=function(){var t=this.chainStore.residueOffset[this.chainIndex],e=this.chainStore.residueCount[this.chainIndex],i=this.index+1;if(i<t+e){var r=this.structure.getResidueProxy(i);if(this.connectedTo(r))return r}else if(i===t+e){var n=this.structure.getResidueProxy(t);if(this.connectedTo(n))return n}},hb.prototype.getPreviousConnectedResidue=function(){var t=this.chainStore.residueOffset[this.chainIndex],e=this.index-1;if(e>=t){var i=this.structure.getResidueProxy(e);if(i.connectedTo(this))return i}else if(e===t-1){var r=this.chainStore.residueCount[this.chainIndex],n=this.structure.getResidueProxy(t+r-1);if(n.connectedTo(this))return n}},hb.prototype.getBonds=function(){return this.residueType.getBonds(this)},hb.prototype.getRings=function(){return this.residueType.getRings()},hb.prototype.qualifiedName=function(t){var e="";return this.resname&&!t&&(e+="["+this.resname+"]"),void 0!==this.resno&&(e+=this.resno),this.inscode&&(e+="^"+this.inscode),this.chain&&(e+=":"+this.chainname),e+="/"+this.modelIndex},hb.prototype.clone=function(){return new this.constructor(this.structure,this.index)},hb.prototype.toObject=function(){return{index:this.index,chainIndex:this.chainIndex,atomOffset:this.atomOffset,atomCount:this.atomCount,resno:this.resno,resname:this.resname,sstruc:this.sstruc}},Object.defineProperties(hb.prototype,pb);var db=function(t,e,i){this.structure=t,this.chainStore=t.chainStore,this.residueStore=t.residueStore,this.atomStore=t.atomStore,this.residueIndexStart=e,this.residueIndexEnd=i,this.residueCount=i-e+1;var r=this.structure.getResidueProxy(this.residueIndexStart),n=this.structure.getResidueProxy(this.residueIndexEnd);this.isPrevConnected=void 0!==r.getPreviousConnectedResidue();var o=n.getNextConnectedResidue();this.isNextConnected=void 0!==o,this.isNextNextConnected=this.isNextConnected&&void 0!==o.getNextConnectedResidue(),this.isCyclic=n.connectedTo(r),this.__residueProxy=this.structure.getResidueProxy()},fb={chainIndex:{configurable:!0},modelIndex:{configurable:!0},chainname:{configurable:!0}};fb.chainIndex.get=function(){return this.residueStore.chainIndex[this.residueIndexStart]},fb.modelIndex.get=function(){return this.chainStore.modelIndex[this.chainIndex]},fb.chainname.get=function(){return this.chainStore.getChainname(this.chainIndex)},db.prototype.isProtein=function(){return this.__residueProxy.index=this.residueIndexStart,this.__residueProxy.isProtein()},db.prototype.isCg=function(){return this.__residueProxy.index=this.residueIndexStart,this.__residueProxy.isCg()},db.prototype.isNucleic=function(){return this.__residueProxy.index=this.residueIndexStart,this.__residueProxy.isNucleic()},db.prototype.getMoleculeType=function(){return this.__residueProxy.index=this.residueIndexStart,this.__residueProxy.moleculeType},db.prototype.getBackboneType=function(t){return this.__residueProxy.index=this.residueIndexStart,this.__residueProxy.getBackboneType(t)},db.prototype.getAtomIndexByType=function(t,e){this.isCyclic?-1===t?t=this.residueCount-1:t===this.residueCount&&(t=0):(-1!==t||this.isPrevConnected||(t+=1),t!==this.residueCount||this.isNextNextConnected||(t-=1));var i=this.__residueProxy;i.index=this.residueIndexStart+t;var r;switch(e){case"trace":r=i.traceAtomIndex;break;case"direction1":r=i.direction1AtomIndex;break;case"direction2":r=i.direction2AtomIndex;break;default:var n=i.getAtomByName(e);r=n?n.index:void 0}return r},db.prototype.eachAtom=function(t,e){this.eachResidue(function(i){i.eachAtom(t,e)},e)},db.prototype.eachAtomN=function(t,e,i){var r,n=this,o=this.residueCount,a=new Array(t);for(r=0;r<t;++r)a[r]=n.structure.getAtomProxy(n.getAtomIndexByType(r,i));e.apply(this,a);for(var s=t;s<o;++s){for(r=1;r<t;++r)a[r-1].index=a[r].index;a[t-1].index=n.getAtomIndexByType(s,i),e.apply(n,a)}},db.prototype.eachAtomN2=function(t,e,i){var r=this,n=this.atomOffset,o=this.atomCount,a=n+o;if(!(o<t)){for(var s=new Array(t),c=0;c<t;++c)s[c]=r.structure.getAtomProxy();var u=this.structure.atomSetCache["__"+i];void 0===u&&(vm.warn("no precomputed atomSet for: "+i),u=this.structure.getAtomSet(!1),this.eachResidue(function(t){var e=t.getAtomByName(i);u.set(e.index)}));var l=0;u.forEach(function(i){if(i>=n&&i<a){for(var r=1;r<t;++r)s[r-1].index=s[r].index;s[t-1].index=i,(l+=1)>=t&&e.apply(this,s)}})}},db.prototype.eachResidue=function(t){for(var e=this.structure.getResidueProxy(),i=this.residueCount,r=this.residueIndexStart,n=0;n<i;++n)e.index=r+n,t(e)},db.prototype.qualifiedName=function(){var t=this.structure.getResidueProxy(this.residueIndexStart),e=this.structure.getResidueProxy(this.residueIndexEnd);return t.qualifiedName()+" - "+e.qualifiedName()},Object.defineProperties(db.prototype,fb);var mb=function(t,e){this.structure=t,this.chainStore=t.chainStore,this.residueStore=t.residueStore,this.index=e},gb={entity:{configurable:!0},model:{configurable:!0},entityIndex:{configurable:!0},modelIndex:{configurable:!0},residueOffset:{configurable:!0},residueCount:{configurable:!0},residueEnd:{configurable:!0},atomOffset:{configurable:!0},atomEnd:{configurable:!0},atomCount:{configurable:!0},chainname:{configurable:!0},chainid:{configurable:!0}};gb.entity.get=function(){return this.structure.entityList[this.entityIndex]},gb.model.get=function(){return this.structure.getModelProxy(this.modelIndex)},gb.entityIndex.get=function(){return this.chainStore.entityIndex[this.index]},gb.entityIndex.set=function(t){this.chainStore.entityIndex[this.index]=t},gb.modelIndex.get=function(){return this.chainStore.modelIndex[this.index]},gb.modelIndex.set=function(t){this.chainStore.modelIndex[this.index]=t},gb.residueOffset.get=function(){return this.chainStore.residueOffset[this.index]},gb.residueOffset.set=function(t){this.chainStore.residueOffset[this.index]=t},gb.residueCount.get=function(){return this.chainStore.residueCount[this.index]},gb.residueCount.set=function(t){this.chainStore.residueCount[this.index]=t},gb.residueEnd.get=function(){return this.residueOffset+this.residueCount-1},gb.atomOffset.get=function(){return this.residueStore.atomOffset[this.residueOffset]},gb.atomEnd.get=function(){return this.residueStore.atomOffset[this.residueEnd]+this.residueStore.atomCount[this.residueEnd]-1},gb.atomCount.get=function(){return 0===this.residueCount?0:this.atomEnd-this.atomOffset+1},gb.chainname.get=function(){return this.chainStore.getChainname(this.index)},gb.chainname.set=function(t){this.chainStore.setChainname(this.index,t)},gb.chainid.get=function(){return this.chainStore.getChainid(this.index)},gb.chainid.set=function(t){this.chainStore.setChainid(this.index,t)},mb.prototype.eachAtom=function(t,e){this.eachResidue(function(i){i.eachAtom(t,e)},e)},mb.prototype.eachResidue=function(t,e){var i,r=this.residueCount,n=this.residueOffset,o=this.structure._rp,a=n+r;if(e&&e.test){var s=e.residueOnlyTest;if(s)for(i=n;i<a;++i)o.index=i,s(o)&&t(o,e);else for(i=n;i<a;++i)o.index=i,t(o,e)}else for(i=n;i<a;++i)o.index=i,t(o)},mb.prototype.eachResidueN=function(t,e){var i,r=this,n=this.residueCount,o=this.residueOffset,a=o+n;if(!(n<t)){var s=new Array(t);for(i=0;i<t;++i)s[i]=r.structure.getResidueProxy(o+i);e.apply(this,s);for(var c=o+t;c<a;++c){for(i=0;i<t;++i)s[i].index+=1;e.apply(r,s)}}},mb.prototype.eachPolymer=function(t,e){for(var i,r,n=e?e.residueOnlyTest:void 0,o=this.model.structure,a=this.residueCount,s=this.residueOffset,c=s+a,u=this.structure.getResidueProxy(),l=this.structure.getResidueProxy(s),h=this.structure.getAtomProxy(),p=this.structure.getAtomProxy(),d=!0,f=s+1;f<c;++f){u.index=l.index,l.index=f;var m=d?u.backboneEndType:u.backboneType,g=l.backboneType;d&&(i=u.index,d=!1),r=l.index,m!==ny&&m===g?(h.index=u.backboneEndAtomIndex,p.index=l.backboneStartAtomIndex,h&&p&&h.connectedTo(p)&&(!n||n(u)&&n(l))||(u.index-i>1&&t(new db(o,i,u.index)),i=r)):(m!==ny&&u.index-i>1&&t(new db(o,i,u.index)),i=r)}r-i>1&&this.structure.getResidueProxy(i).backboneEndType&&t(new db(o,i,r))},mb.prototype.qualifiedName=function(){return":"+this.chainname+"/"+this.modelIndex},mb.prototype.clone=function(){return new this.constructor(this.structure,this.index)},mb.prototype.toObject=function(){return{index:this.index,residueOffset:this.residueOffset,residueCount:this.residueCount,chainname:this.chainname}},Object.defineProperties(mb.prototype,gb);var vb=function(t,e){this.structure=t,this.modelStore=t.modelStore,this.chainStore=t.chainStore,this.residueStore=t.residueStore,this.index=e},yb={chainOffset:{configurable:!0},chainCount:{configurable:!0},residueOffset:{configurable:!0},atomOffset:{configurable:!0},chainEnd:{configurable:!0},residueEnd:{configurable:!0},atomEnd:{configurable:!0},residueCount:{configurable:!0},atomCount:{configurable:!0}};yb.chainOffset.get=function(){return this.modelStore.chainOffset[this.index]},yb.chainOffset.set=function(t){this.modelStore.chainOffset[this.index]=t},yb.chainCount.get=function(){return this.modelStore.chainCount[this.index]},yb.chainCount.set=function(t){this.modelStore.chainCount[this.index]=t},yb.residueOffset.get=function(){return this.chainStore.residueOffset[this.chainOffset]},yb.atomOffset.get=function(){return this.residueStore.atomOffset[this.residueOffset]},yb.chainEnd.get=function(){return this.chainOffset+this.chainCount-1},yb.residueEnd.get=function(){return this.chainStore.residueOffset[this.chainEnd]+this.chainStore.residueCount[this.chainEnd]-1},yb.atomEnd.get=function(){return this.residueStore.atomOffset[this.residueEnd]+this.residueStore.atomCount[this.residueEnd]-1},yb.residueCount.get=function(){return 0===this.chainCount?0:this.residueEnd-this.residueOffset+1},yb.atomCount.get=function(){return 0===this.residueCount?0:this.atomEnd-this.atomOffset+1},vb.prototype.eachAtom=function(t,e){this.eachChain(function(i){i.eachAtom(t,e)},e)},vb.prototype.eachResidue=function(t,e){this.eachChain(function(i){i.eachResidue(t,e)},e)},vb.prototype.eachPolymer=function(t,e){if(e&&e.chainOnlyTest){var i=e.chainOnlyTest;this.eachChain(function(r){i(r)&&r.eachPolymer(t,e)})}else this.eachChain(function(i){i.eachPolymer(t,e)})},vb.prototype.eachChain=function(t,e){var i,r=this.chainCount,n=this.chainOffset,o=this.structure._cp,a=n+r;if(e&&e.test){var s=e.chainOnlyTest;if(s)for(i=n;i<a;++i)o.index=i,s(o)&&t(o,e);else for(i=n;i<a;++i)o.index=i,t(o,e)}else for(i=n;i<a;++i)o.index=i,t(o)},vb.prototype.qualifiedName=function(){return"/"+this.index},vb.prototype.clone=function(){return new this.constructor(this.structure,this.index)},vb.prototype.toObject=function(){return{index:this.index,chainOffset:this.chainOffset,chainCount:this.chainCount}},Object.defineProperties(vb.prototype,yb);var bb=function(t,e){this.signals={refreshed:new So},this.init(t,e)},xb={type:{configurable:!0}};bb.prototype.init=function(t,e){this.name=t,this.path=e,this.title="",this.id="",this.header={},this.extraData={},this.atomSetCache=void 0,this.atomSetDict={},this.biomolDict={},this.entityList=[],this.unitcell=void 0,this.frames=[],this.boxes=[],this.validation=void 0,this.bondStore=new Vy(0),this.backboneBondStore=new Vy(0),this.rungBondStore=new Vy(0),this.atomStore=new Gy(0),this.residueStore=new $y(0),this.chainStore=new Hy(0),this.modelStore=new Wy(0),this.atomMap=new nb(this),this.residueMap=new ab(this),this.bondHash=void 0,this.spatialHash=void 0,this.atomSet=void 0,this.bondSet=void 0,this.center=void 0,this.boundingBox=void 0,this._bp=this.getBondProxy(),this._ap=this.getAtomProxy(),this._rp=this.getResidueProxy(),this._cp=this.getChainProxy()},xb.type.get=function(){return"Structure"},bb.prototype.finalizeAtoms=function(){this.atomSet=this.getAtomSet(),this.atomCount=this.atomStore.count,this.boundingBox=this.getBoundingBox(),this.center=this.boundingBox.getCenter(),this.spatialHash=new ms(this.atomStore,this.boundingBox)},bb.prototype.finalizeBonds=function(){var t=this;this.bondSet=this.getBondSet(),this.bondCount=this.bondStore.count,this.bondHash=new Uy(this.bondStore,this.atomStore.count),this.atomSetCache={},this.atomSetDict.rung||(this.atomSetDict.rung=this.getAtomSet(!1));for(var e in t.atomSetDict)t.atomSetCache["__"+e]=t.atomSetDict[e].clone()},bb.prototype.getBondProxy=function(t){return new sb(this,t)},bb.prototype.getAtomProxy=function(t){return new ub(this,t)},bb.prototype.getResidueProxy=function(t){return new hb(this,t)},bb.prototype.getChainProxy=function(t){return new mb(this,t)},bb.prototype.getModelProxy=function(t){return new vb(this,t)},bb.prototype.getBondSet=function(){var t=this.bondStore.count,e=new Qv(t),i=this.atomSet;if(i)for(var r=this.getBondProxy(),n=0;n<t;++n)r.index=n,i.isSet(r.atomIndex1,r.atomIndex2)&&e.set(r.index);else e.setAll();return e},bb.prototype.getBackboneBondSet=function(){var t=this.backboneBondStore.count,e=new Qv(t),i=this.atomSetCache.__backbone;if(i){var r=this.getBondProxy();r.bondStore=this.backboneBondStore;for(var n=0;n<t;++n)r.index=n,i.isSet(r.atomIndex1,r.atomIndex2)&&e.set(r.index)}else e.set_all(!0);return e},bb.prototype.getRungBondSet=function(){var t=this.rungBondStore.count,e=new Qv(t),i=this.atomSetCache.__rung;if(i){var r=this.getBondProxy();r.bondStore=this.rungBondStore;for(var n=0;n<t;++n)r.index=n,i.isSet(r.atomIndex1,r.atomIndex2)&&e.set(r.index)}else e.set_all(!0);return e},bb.prototype.getAtomSet=function(t){var e,i=this.atomStore.count;if(t instanceof Qv)e=t;else if(t&&t.test){var r=t.string;r in this.atomSetCache?e=this.atomSetCache[r]:(e=new Qv(i),this.eachAtom(function(t){e.set(t.index)},t),this.atomSetCache[r]=e)}else e=!1===t?new Qv(i):new Qv(i,!0);return e},bb.prototype.getAtomSetWithinSelection=function(t,e){var i=this.spatialHash,r=this.getAtomSet(!1),n=this.getAtomProxy();return this.getAtomSet(t).forEach(function(t){n.index=t,i.within(n.x,n.y,n.z,e).forEach(function(t){r.set(t)})}),r},bb.prototype.getAtomSetWithinPoint=function(t,e){var i=t,r=this.getAtomSet(!1);return this.spatialHash.within(i.x,i.y,i.z,e).forEach(function(t){r.set(t)}),r},bb.prototype.getAtomSetWithinVolume=function(t,e,i,r,n){for(var o=this,a=new Fy(t,i,r,n),s=a.getDataPosition(),c=s.length,u=a.matrix.getMaxScaleOnAxis(),l=this.getAtomSet(!1),h=0;h<c;h+=3)o.spatialHash.within(s[h],s[h+1],s[h+2],u).forEach(function(t){l.set(t)});return l},bb.prototype.getAtomSetWithinGroup=function(t){var e=this.atomStore.residueIndex,i=this.getAtomSet(!1),r=this.getResidueProxy();return this.getAtomSet(t).forEach(function(t){r.index=e[t];for(var n=r.atomOffset;n<=r.atomEnd;++n)i.set(n)}),i},bb.prototype.getSelection=function(){return!1},bb.prototype.getStructure=function(){return this},bb.prototype.eachEntity=function(t,e){this.entityList.forEach(function(i){void 0!==e&&i.getEntityType()!==e||t(i)})},bb.prototype.eachBond=function(t,e){var i,r=this.getBondProxy();if(e&&e.test&&(i=this.getBondSet(e),this.bondSet&&i.intersection(this.bondSet)),i)i.forEach(function(e){r.index=e,t(r)});else for(var n=this.bondStore.count,o=0;o<n;++o)r.index=o,t(r)},bb.prototype.eachAtom=function(t,e){if(e&&e.test)this.eachModel(function(i){i.eachAtom(t,e)},e);else for(var i=this.atomStore.count,r=this.getAtomProxy(),n=0;n<i;++n)r.index=n,t(r)},bb.prototype.eachResidue=function(t,e){if(e&&e.test){var i=this.modelStore.count,r=this.getModelProxy(),n=e.modelOnlyTest;if(n)for(var o=0;o<i;++o)r.index=o,n(r)&&r.eachResidue(t,e);else for(var a=0;a<i;++a)r.index=a,r.eachResidue(t,e)}else for(var s=this.residueStore.count,c=this.getResidueProxy(),u=0;u<s;++u)c.index=u,t(c)},bb.prototype.eachResidueN=function(t,e){var i=this,r=this.residueStore.count;if(!(r<t)){for(var n=new Array(t),o=0;o<t;++o)n[o]=i.getResidueProxy(o);e.apply(this,n);for(var a=t;a<r;++a){for(var s=0;s<t;++s)n[s].index+=1;e.apply(i,n)}}},bb.prototype.eachPolymer=function(t,e){if(e&&e.modelOnlyTest){var i=e.modelOnlyTest;this.eachModel(function(r){i(r)&&r.eachPolymer(t,e)})}else this.eachModel(function(i){i.eachPolymer(t,e)})},bb.prototype.eachChain=function(t,e){if(e&&e.test)this.eachModel(function(i){i.eachChain(t,e)});else for(var i=this.chainStore.count,r=this.getChainProxy(),n=0;n<i;++n)r.index=n,t(r)},bb.prototype.eachModel=function(t,e){var i=this.modelStore.count,r=this.getModelProxy();if(e&&e.test){var n=e.modelOnlyTest;if(n)for(var o=0;o<i;++o)r.index=o,n(r)&&t(r,e);else for(var a=0;a<i;++a)r.index=a,t(r,e)}else for(var s=0;s<i;++s)r.index=s,t(r)},bb.prototype.getAtomData=function(t){var e=Object.assign({},t);e.colorParams&&(e.colorParams.structure=this.getStructure());var i,r,n,o,a,s,c,u=e.what,l=Nn(e.atomSet,this.atomSet),h={},p=this.getAtomProxy(),d=l.getSize();return u&&!u.position||(n=new Float32Array(3*d),h.position=n),u&&!u.color||(o=new Float32Array(3*d),h.color=o,r=_m.getScheme(e.colorParams)),u&&!u.picking||(a=new Float32Array(d),h.picking=new Ov(a,this.getStructure())),u&&!u.radius||(s=new Float32Array(d),h.radius=s,i=new Xa(e.radiusParams.radius,e.radiusParams.scale)),u&&!u.index||(c=new Float32Array(d),h.index=c),l.forEach(function(t,e){var u=3*e;p.index=t,n&&p.positionToArray(n,u),o&&r.atomColorToArray(p,o,u),a&&(a[e]=t),s&&(s[e]=i.atomRadius(p)),c&&(c[e]=t)}),h},bb.prototype.getBondData=function(t){var e=Object.assign({},t);e.colorParams&&(e.colorParams.structure=this.getStructure());var i,r,n,o,a,s,c,u,l,h=e.what,p=Nn(e.bondSet,this.bondSet),d=Nn(e.multipleBond,"off"),f="off"!==d,m="offset"===d,g=Nn(e.bondScale,.4),y=Nn(e.bondSpacing,1),b={},x=this.getBondProxy();e.bondStore&&(x.bondStore=e.bondStore);var _,w=this.getAtomProxy(),S=this.getAtomProxy();if(f){var A=x.bondStore.bondOrder;_=0,p.forEach(function(t){_+=A[t]})}else _=p.getSize();h&&!h.position||(n=new Float32Array(3*_),o=new Float32Array(3*_),b.position1=n,b.position2=o),h&&!h.color||(a=new Float32Array(3*_),s=new Float32Array(3*_),b.color=a,b.color2=s,r=_m.getScheme(e.colorParams)),h&&!h.picking||(c=new Float32Array(_),b.picking=new Nv(c,this.getStructure(),e.bondStore)),(!h||h.radius||f&&h.position)&&(i=new Xa(e.radiusParams.radius,e.radiusParams.scale)),h&&!h.radius||(u=new Float32Array(_),b.radius=u,e.radius2&&(l=new Float32Array(_),b.radius2=l));var M,P,E,T,C,I,R,L=0,O=new v,D=new v,N=new v;return p.forEach(function(t){if(P=3*L,x.index=t,w.index=x.atomIndex1,S.index=x.atomIndex2,T=x.bondOrder,n&&(f&&T>1?(C=i.atomRadius(w),I=C*g/(.5*T),x.calculateShiftDir(N),m?(R=2*y*C,N.multiplyScalar(R),N.negate(),D.subVectors(S,w).multiplyScalar(Math.max(.1,R/1.88)),w.positionToArray(n,P),S.positionToArray(o,P),T>=2&&(O.addVectors(w,N).add(D).toArray(n,P+3),O.addVectors(S,N).sub(D).toArray(o,P+3),T>=3&&(O.subVectors(w,N).add(D).toArray(n,P+6),O.subVectors(S,N).sub(D).toArray(o,P+6)))):(R=(y-g)*C,N.multiplyScalar(R),2===T?(O.addVectors(w,N).toArray(n,P),O.subVectors(w,N).toArray(n,P+3),O.addVectors(S,N).toArray(o,P),O.subVectors(S,N).toArray(o,P+3)):3===T?(w.positionToArray(n,P),O.addVectors(w,N).toArray(n,P+3),O.subVectors(w,N).toArray(n,P+6),S.positionToArray(o,P),O.addVectors(S,N).toArray(o,P+3),O.subVectors(S,N).toArray(o,P+6)):(w.positionToArray(n,P),S.positionToArray(o,P)))):(w.positionToArray(n,P),S.positionToArray(o,P))),a&&(r.bondColorToArray(x,1,a,P),r.bondColorToArray(x,0,s,P),f&&T>1))for(M=1;M<T;++M)oa(a,P,E=3*M+P,3),oa(s,P,E,3);if(c&&(c[L]=t,f&&T>1))for(M=1;M<T;++M)c[L+M]=t;if(u&&(u[L]=i.atomRadius(w),f&&T>1))for(I=u[L]*g/(m?1:.5*T),M=m?1:0;M<T;++M)u[L+M]=I;if(l&&(l[L]=i.atomRadius(S),f&&T>1))for(I=l[L]*g/(m?1:.5*T),M=m?1:0;M<T;++M)l[L+M]=I;L+=f?T:1}),b},bb.prototype.getBackboneAtomData=function(t){return t=Object.assign({atomSet:this.atomSetCache.__backbone},t),this.getAtomData(t)},bb.prototype.getBackboneBondData=function(t){return t=Object.assign({bondSet:this.getBackboneBondSet(),bondStore:this.backboneBondStore},t),this.getBondData(t)},bb.prototype.getRungAtomData=function(t){return t=Object.assign({atomSet:this.atomSetCache.__rung},t),this.getAtomData(t)},bb.prototype.getRungBondData=function(t){return t=Object.assign({bondSet:this.getRungBondSet(),bondStore:this.rungBondStore},t),this.getBondData(t)},bb.prototype.getBoundingBox=function(e,i){t.Debug&&vm.time("getBoundingBox"),i=i||new lt;var r=1/0,n=1/0,o=1/0,a=-1/0,s=-1/0,c=-1/0;return this.eachAtom(function(t){var e=t.x,i=t.y,u=t.z;e<r&&(r=e),i<n&&(n=i),u<o&&(o=u),e>a&&(a=e),i>s&&(s=i),u>c&&(c=u)},e),i.min.set(r,n,o),i.max.set(a,s,c),t.Debug&&vm.timeEnd("getBoundingBox"),i},bb.prototype.getPrincipalAxes=function(e){t.Debug&&vm.time("getPrincipalAxes");var i=0,r=new qa(3,this.atomCount),n=r.data;return this.eachAtom(function(t){n[i+0]=t.x,n[i+1]=t.y,n[i+2]=t.z,i+=3},e),t.Debug&&vm.timeEnd("getPrincipalAxes"),new Oy(r)},bb.prototype.atomCenter=function(t){return t?this.getBoundingBox(t).getCenter():this.center.clone()},bb.prototype.hasCoords=function(){var t=this.atomStore;return 0!==ca(t.x)||0!==sa(t.x)||0!==ca(t.y)||0!==sa(t.y)||0!==ca(t.z)||0!==sa(t.z)},bb.prototype.getSequence=function(t){var e=[],i=this.getResidueProxy();return this.eachAtom(function(t){i.index=t.residueIndex,t.index===i.traceAtomIndex&&e.push(i.getResname1())},t),e},bb.prototype.getAtomIndices=function(t){var e;if(t&&t.string)e=[],this.eachAtom(function(t){e.push(t.index)},t);else{var i={what:{index:!0}};e=this.getAtomData(i).index}return e},bb.prototype.getChainnameCount=function(t){var e=new Set;return this.eachChain(function(t){t.residueCount&&e.add(t.chainname)},t),e.size},bb.prototype.updatePosition=function(t){var e=0;this.eachAtom(function(i){i.positionFromArray(t,e),e+=3})},bb.prototype.refreshPosition=function(){this.getBoundingBox(void 0,this.boundingBox),this.boundingBox.getCenter(this.center),this.spatialHash=new ms(this.atomStore,this.boundingBox)},bb.prototype.dispose=function(){this.frames&&(this.frames.length=0),this.boxes&&(this.boxes.length=0),this.bondStore.dispose(),this.backboneBondStore.dispose(),this.rungBondStore.dispose(),this.atomStore.dispose(),this.residueStore.dispose(),this.chainStore.dispose(),this.modelStore.dispose(),delete this.bondStore,delete this.atomStore,delete this.residueStore,delete this.chainStore,delete this.modelStore,delete this.frames,delete this.boxes,delete this.cif,delete this.bondSet,delete this.atomSet},Object.defineProperties(bb.prototype,xb);var _b=function(t,e){var i;"function"==typeof t.eachAtom?i=t.atomCount:t instanceof Float32Array&&(i=t.length/3);var r;"function"==typeof e.eachAtom?r=e.atomCount:t instanceof Float32Array&&(r=e.length/3);var n=Math.min(i,r),o=new qa(3,n),a=new qa(3,n);this.coords1t=new qa(n,3),this.coords2t=new qa(n,3),this.A=new qa(3,3),this.W=new qa(1,3),this.U=new qa(3,3),this.V=new qa(3,3),this.VH=new qa(3,3),this.R=new qa(3,3),this.tmp=new qa(3,3),this.c=new qa(3,3),this.c.data.set([1,0,0,0,1,0,0,0,-1]),this.prepCoords(t,o,n),this.prepCoords(e,a,n),this._superpose(o,a)};_b.prototype._superpose=function(e,i){this.mean1=ts(e),this.mean2=ts(i),es(e,this.mean1),es(i,this.mean2),Ya(this.coords1t,e),Ya(this.coords2t,i),Za(this.A,this.coords2t,this.coords1t),as(this.A,this.W,this.U,this.V),Ka(this.V,this.VH),Ja(this.R,this.U,this.VH),Qa(this.R)<0&&(t.Debug&&vm.log("R not a right handed system"),Ja(this.tmp,this.c,this.VH),Ja(this.R,this.U,this.tmp))},_b.prototype.prepCoords=function(t,e,i){var r=0,n=3*i,o=e.data;"function"==typeof t.eachAtom?t.eachAtom(function(t){r<n&&(o[r+0]=t.x,o[r+1]=t.y,o[r+2]=t.z,r+=3)}):t instanceof Float32Array?o.set(t.subarray(0,n)):vm.warn("prepCoords: input type unknown")},_b.prototype.transform=function(t){var e;"function"==typeof t.eachAtom?e=t.atomCount:t instanceof Float32Array&&(e=t.length/3);var i=new qa(3,e),r=new qa(e,3);this.prepCoords(t,i,e),es(i,this.mean1),Za(r,this.R,i),Ya(i,r),is(i,this.mean2);var n=0,o=i.data;"function"==typeof t.eachAtom?t.eachAtom(function(t){t.x=o[n+0],t.y=o[n+1],t.z=o[n+2],n+=3}):t instanceof Float32Array?t.set(o.subarray(0,3*e)):vm.warn("transform: input type unknown")};var wb=function(t,e){this.signals={startedRunning:new So,haltedRunning:new So},t.signals.playerChanged.add(function(t){t!==this&&this.pause()},this);var i=Object.assign({},e),r=Nn(t.frameCount,1);this.traj=t,this.start=Nn(i.start,0),this.end=Math.min(Nn(i.end,r-1),r-1),this.step=Nn(i.step,Math.ceil((r+1)/100)),this.timeout=Nn(i.timeout,50),this.interpolateType=Nn(i.interpolateType,""),this.interpolateStep=Nn(i.interpolateStep,5),this.mode=Nn(i.mode,"loop"),this.direction=Nn(i.direction,"forward"),this._run=!1,this._previousTime=0,this._currentTime=0,this._currentStep=1,this._currentFrame=this.start,this._direction="bounce"===this.direction?"forward":this.direction,t.signals.countChanged.add(function(t){this.end=Math.min(Nn(this.end,t-1),t-1)},this),this._animate=this._animate.bind(this)},Sb={isRunning:{configurable:!0}};Sb.isRunning.get=function(){return this._run},wb.prototype.setParameters=function(t){var e=Object.assign({},t);void 0!==e.start&&(this.start=e.start),void 0!==e.end&&(this.end=e.end),void 0!==e.step&&(this.step=e.step),void 0!==e.timeout&&(this.timeout=e.timeout),void 0!==e.interpolateType&&(this.interpolateType=e.interpolateType),void 0!==e.interpolateStep&&(this.interpolateStep=e.interpolateStep),void 0!==e.mode&&(this.mode=e.mode),void 0!==e.direction&&(this.direction=e.direction,"bounce"!==this.direction&&(this._direction=this.direction))},wb.prototype._animate=function(){if(this._run){this._currentTime=window.performance.now();var t=this._currentTime-this._previousTime,e=this.interpolateType?this.interpolateStep:1,i=this.timeout/e,r=this.traj;if(r&&r.frameCount&&!r.inProgress&&t>=i)if(this.interpolateType)if(this._currentStep>this.interpolateStep&&(this._currentStep=1),1===this._currentStep&&(this._currentFrame=this._nextInterpolated()),r.hasFrame(this._currentFrame)){this._currentStep+=1;var n=this._currentStep/(this.interpolateStep+1);r.setFrameInterpolated.apply(r,this._currentFrame.concat([n],[this.interpolateType])),this._previousTime=this._currentTime}else r.loadFrame(this._currentFrame);else{var o=this._next();r.hasFrame(o)?(r.setFrame(o),this._previousTime=this._currentTime):r.loadFrame(o)}window.requestAnimationFrame(this._animate)}},wb.prototype._next=function(){var t;return((t="forward"===this._direction?this.traj.currentFrame+this.step:this.traj.currentFrame-this.step)>this.end||t<this.start)&&("bounce"===this.direction&&("forward"===this._direction?this._direction="backward":this._direction="forward"),"once"===this.mode?(this.pause(),t="forward"===this.direction?this.end:"backward"===this.direction?this.start:"forward"===this._direction?this.start:this.end):"forward"===this._direction?(t=this.start,this.interpolateType&&(t=Math.min(this.end,t+this.step))):(t=this.end,this.interpolateType&&(t=Math.max(this.start,t-this.step)))),t},wb.prototype._nextInterpolated=function(){var t,e,i,r=this._next();return"forward"===this._direction?(t=Math.max(this.start,r-this.step),e=Math.max(this.start,r-2*this.step),i=Math.max(this.start,r-3*this.step)):(t=Math.min(this.end,r+this.step),e=Math.min(this.end,r+2*this.step),i=Math.min(this.end,r+3*this.step)),[r,t,e,i]},wb.prototype.toggle=function(){this._run?this.pause():this.play()},wb.prototype.play=function(){if(!this._run){this.traj.player!==this&&this.traj.setPlayer(this),this._currentStep=1;var t=this.traj.currentFrame,e=Math.ceil(t/this.step)*this.step;"forward"===this.direction&&t>=this.end?e=this.start:"backward"===this.direction&&t<=this.start&&(e=this.end),this.traj.setFrame(e),this._run=!0,this._animate(),this.signals.startedRunning.dispatch()}},wb.prototype.pause=function(){this._run=!1,this.signals.haltedRunning.dispatch()},wb.prototype.stop=function(){this.pause(),this.traj.setFrame(this.start)},Object.defineProperties(wb.prototype,Sb);var Ab=function(t,e,i){this.signals={countChanged:new So,frameChanged:new So,playerChanged:new So};var r=i||{};this.deltaTime=Nn(r.deltaTime,0),this.timeOffset=Nn(r.timeOffset,0),this.centerPbc=Nn(r.centerPbc,!1),this.removePbc=Nn(r.removePbc,!1),this.removePeriodicity=Nn(r.removePeriodicity,!1),this.superpose=Nn(r.superpose,!1),this.name=t.replace(/^.*[\\/]/,""),this.trajPath=t,this.initialCoords=null,this.structureCoords=null,this.selection=new rm(Nn(r.sele,"backbone and not hydrogen")),this.selection.signals.stringChanged.add(function(){this.selectionIndices=this.structure.getAtomIndices(this.selection),this._resetCache(),this._saveInitialCoords(),this.setFrame(this._currentFrame)},this),this._frameCount=0,this._currentFrame=-1},Mb={frameCount:{configurable:!0},currentFrame:{configurable:!0}};Mb.frameCount.get=function(){return this._frameCount},Mb.currentFrame.get=function(){return this._currentFrame},Ab.prototype._init=function(t){this.setStructure(t),this._loadFrameCount(),this.setPlayer(new wb(this))},Ab.prototype.setStructure=function(t){this.structure=t,this.atomCount=t.atomCount,this.backboneIndices=this._getIndices(new rm("backbone and not hydrogen")),this._makeAtomIndices(),this._saveStructureCoords(),this.selectionIndices=this._getIndices(this.selection),this._resetCache(),this._saveInitialCoords(),this.setFrame(this._currentFrame)},Ab.prototype._saveInitialCoords=function(){var t=this;this.structure.hasCoords()?(this.initialCoords=new Float32Array(this.structureCoords),this._makeSuperposeCoords()):this.frameCache[0]?(this.initialCoords=new Float32Array(this.frameCache[0]),this._makeSuperposeCoords()):this.loadFrame(0,function(){return t._saveInitialCoords()})},Ab.prototype._saveStructureCoords=function(){var t={what:{position:!0}};this.structureCoords=this.structure.getAtomData(t).position},Ab.prototype.setSelection=function(t){return this.selection.setString(t),this},Ab.prototype._getIndices=function(t){var e=0,i=t.test,r=[];return this.structure.eachAtom(function(t){i(t)&&r.push(e),e+=1}),r},Ab.prototype._makeSuperposeCoords=function(){var t=this,e=3*this.selectionIndices.length;this.coords1=new Float32Array(e),this.coords2=new Float32Array(e);for(var i=this.initialCoords,r=this.coords2,n=0;n<e;n+=3){var o=3*t.selectionIndices[n/3];r[n+0]=i[o+0],r[n+1]=i[o+1],r[n+2]=i[o+2]}},Ab.prototype._makeAtomIndices=function(){vm.error("Trajectory._makeAtomIndices not implemented")},Ab.prototype._resetCache=function(){this.frameCache={},this.loadQueue={},this.boxCache={},this.pathCache={},this.frameCacheSize=0,this.initialCoords=null},Ab.prototype.setParameters=function(t){var e=t||{},i=!1;void 0!==e.centerPbc&&e.centerPbc!==this.centerPbc&&(this.centerPbc=e.centerPbc,i=!0),void 0!==e.removePeriodicity&&e.removePeriodicity!==this.removePeriodicity&&(this.removePeriodicity=e.removePeriodicity,i=!0),void 0!==e.removePbc&&e.removePbc!==this.removePbc&&(this.removePbc=e.removePbc,i=!0),void 0!==e.superpose&&e.superpose!==this.superpose&&(this.superpose=e.superpose,i=!0),this.deltaTime=Nn(e.deltaTime,this.deltaTime),this.timeOffset=Nn(e.timeOffset,this.timeOffset),i&&(this._resetCache(),this.setFrame(this._currentFrame))},Ab.prototype.hasFrame=function(t){var e=this;return Array.isArray(t)?t.every(function(t){return!!e.frameCache[t]}):!!this.frameCache[t]},Ab.prototype.setFrame=function(t,e){var i=this;return void 0===t?this:(this.inProgress=!0,-1===(t=parseInt(t))||this.frameCache[t]?(this._updateStructure(t),e&&e()):this.loadFrame(t,function(){i._updateStructure(t),e&&e()}),this)},Ab.prototype._interpolate=function(t,e,i,r,n,o){var a,s=this.frameCache;a="spline"===o?Qs(s[t],s[e],s[i],s[r],n):Js(s[t],s[e],n),this.structure.updatePosition(a),this._currentFrame=t,this.signals.frameChanged.dispatch(t)},Ab.prototype.setFrameInterpolated=function(t,e,i,r,n,o,a){var s=this;if(void 0===t)return this;var c=this.frameCache,u=[];return c[r]||u.push(r),c[i]||u.push(i),c[e]||u.push(e),c[t]||u.push(t),u.length?this.loadFrame(u,function(){s._interpolate(t,e,i,r,n,o),a&&a()}):(this._interpolate(t,e,i,r,n,o),a&&a()),this},Ab.prototype.loadFrame=function(t,e){var i=this;Array.isArray(t)?t.forEach(function(t){i.loadQueue[t]||i.frameCache[t]||(i.loadQueue[t]=!0,i._loadFrame(t,function(){delete i.loadQueue[t]}))}):this.loadQueue[t]||this.frameCache[t]||(this.loadQueue[t]=!0,this._loadFrame(t,function(){delete i.loadQueue[t],e&&e()}))},Ab.prototype._loadFrame=function(t,e){vm.error("Trajectory._loadFrame not implemented",t,e)},Ab.prototype._updateStructure=function(t){this._disposed?console.error("updateStructure: traj disposed"):(-1===t?this.structureCoords&&this.structure.updatePosition(this.structureCoords):this.structure.updatePosition(this.frameCache[t]),this.structure.trajectory={name:this.trajPath,frame:t},this._currentFrame=t,this.inProgress=!1,this.signals.frameChanged.dispatch(t))},Ab.prototype._doSuperpose=function(t){for(var e=this,i=3*this.selectionIndices.length,r=this.coords1,n=this.coords2,o=0;o<i;o+=3){var a=3*e.selectionIndices[o/3];r[o+0]=t[a+0],r[o+1]=t[a+1],r[o+2]=t[a+2]}new _b(r,n).transform(t)},Ab.prototype._process=function(t,e,i,r){if(this._setFrameCount(r),e){if(this.backboneIndices.length>0&&this.centerPbc){var n=[e[0],e[4],e[8]];Xs(i,Zs(this.backboneIndices,i,n),n)}this.removePeriodicity&&Ys(i,e,Ks(i)),this.removePbc&&qs(i,e)}this.selectionIndices.length>0&&this.coords1&&this.superpose&&this._doSuperpose(i),this.frameCache[t]=i,this.boxCache[t]=e,this.frameCacheSize+=1},Ab.prototype._setFrameCount=function(t){t!==this._frameCount&&(this._frameCount=t,this.signals.countChanged.dispatch(t))},Ab.prototype.dispose=function(){this._resetCache(),this._disposed=!0,this.player&&this.player.stop()},Ab.prototype.setPlayer=function(t){this.player=t,this.signals.playerChanged.dispatch(t)},Ab.prototype.getPath=function(t,e){vm.error("Trajectory.getPath not implemented",t,e)},Ab.prototype.getFrameTime=function(t){return this.timeOffset+t*this.deltaTime},Object.defineProperties(Ab.prototype,Mb),Mm.add("shader/Mesh.vert","#define STANDARD\nuniform float nearClip;\nuniform vec3 clipCenter;\n#if defined( NEAR_CLIP ) || defined( RADIUS_CLIP ) || ( !defined( PICKING ) && !defined( NOLIGHT ) )\nvarying vec3 vViewPosition;\n#endif\n#if defined( RADIUS_CLIP )\nvarying vec3 vClipCenter;\n#endif\n#if defined( PICKING )\n#include unpack_color\nattribute float primitiveId;\nvarying vec3 vPickingColor;\n#elif defined( NOLIGHT )\nvarying vec3 vColor;\n#else\n#include color_pars_vertex\n#ifndef FLAT_SHADED\nvarying vec3 vNormal;\n#endif\n#endif\n#include common\nvoid main(){\n#if defined( PICKING )\nvPickingColor = unpackColor( primitiveId );\n#elif defined( NOLIGHT )\nvColor = color;\n#else\n#include color_vertex\n#include beginnormal_vertex\n#include defaultnormal_vertex\n#ifndef FLAT_SHADED\nvNormal = normalize( transformedNormal );\n#endif\n#endif\n#include begin_vertex\n#include project_vertex\n#if defined( NEAR_CLIP ) || defined( RADIUS_CLIP ) || ( !defined( PICKING ) && !defined( NOLIGHT ) )\nvViewPosition = -mvPosition.xyz;\n#endif\n#if defined( RADIUS_CLIP )\nvClipCenter = -( modelViewMatrix * vec4( clipCenter, 1.0 ) ).xyz;\n#endif\n#include nearclip_vertex\n}"),Mm.add("shader/Mesh.frag","#define STANDARD\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float roughness;\nuniform float metalness;\nuniform float opacity;\nuniform float nearClip;\nuniform float clipRadius;\n#if defined( NEAR_CLIP ) || defined( RADIUS_CLIP ) || ( !defined( PICKING ) && !defined( NOLIGHT ) )\nvarying vec3 vViewPosition;\n#endif\n#if defined( RADIUS_CLIP )\nvarying vec3 vClipCenter;\n#endif\n#if defined( PICKING )\nuniform float objectId;\nvarying vec3 vPickingColor;\n#elif defined( NOLIGHT )\nvarying vec3 vColor;\n#else\n#ifndef FLAT_SHADED\nvarying vec3 vNormal;\n#endif\n#include common\n#include color_pars_fragment\n#include fog_pars_fragment\n#include bsdfs\n#include lights_pars\n#include lights_physical_pars_fragment\n#endif\nvoid main(){\n#include nearclip_fragment\n#include radiusclip_fragment\n#if defined( PICKING )\nif( opacity < 0.7 )\ndiscard;\ngl_FragColor = vec4( vPickingColor, objectId );\n#elif defined( NOLIGHT )\ngl_FragColor = vec4( vColor, opacity );\n#else\nvec4 diffuseColor = vec4( diffuse, opacity );\nReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\nvec3 totalEmissiveLight = emissive;\n#include color_fragment\n#include roughnessmap_fragment\n#include metalnessmap_fragment\n#include normal_flip\n#include normal_fragment\n#include dull_interior_fragment\n#include lights_physical_fragment\n#include lights_template\nvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveLight;\ngl_FragColor = vec4( outgoingLight, diffuseColor.a );\n#include premultiplied_alpha_fragment\n#include tonemapping_fragment\n#include encodings_fragment\n#include fog_fragment\n#include opaque_back_fragment\n#endif\n}");var Pb={f:1,v2:2,v3:3,c:3},Eb=function(t,e){var i=t||{},r=e||{};this.opaqueBack=Nn(r.opaqueBack,!1),this.dullInterior=Nn(r.dullInterior,!1),this.side=Nn(r.side,"double"),this.opacity=Nn(r.opacity,1),this.depthWrite=Nn(r.depthWrite,!0),this.clipNear=Nn(r.clipNear,0),this.clipRadius=Nn(r.clipRadius,0),this.clipCenter=Nn(r.clipCenter,new v),this.flatShaded=Nn(r.flatShaded,!1),this.background=Nn(r.background,!1),this.wireframe=Nn(r.wireframe,!1),this.roughness=Nn(r.roughness,.4),this.metalness=Nn(r.metalness,0),this.diffuse=Nn(r.diffuse,16777215),this.forceTransparent=Nn(r.forceTransparent,!1),this.disablePicking=Nn(r.disablePicking,!1),this.geometry=new Ft,this.indexVersion=0,this.wireframeIndexVersion=-1,this.uniforms=Np.merge([Dp.common,{fogColor:{value:null},fogNear:{value:0},fogFar:{value:0},opacity:{value:this.opacity},nearClip:{value:0},clipRadius:{value:this.clipRadius},clipCenter:{value:this.clipCenter}},{emissive:{value:new et(0)},roughness:{value:this.roughness},metalness:{value:this.metalness}},Dp.ambient,Dp.lights]),this.uniforms.diffuse.value.set(this.diffuse),this.pickingUniforms={nearClip:{value:0},objectId:{value:0},opacity:{value:this.opacity}},this.group=new qe,this.wireframeGroup=new qe,this.pickingGroup=new qe,this.matrix=Nn(r.matrix,new y);var n=i.position||i.position1;this._positionDataSize=n?n.length/3:0,this.addAttributes({position:{type:"v3",value:i.position},color:{type:"c",value:i.color},primitiveId:{type:"f",value:i.primitiveId}}),i.index&&this.initIndex(i.index),this.picking=i.picking,this.makeWireframeGeometry()},Tb={parameters:{configurable:!0},matrix:{configurable:!0},transparent:{configurable:!0},size:{configurable:!0},attributeSize:{configurable:!0},pickable:{configurable:!0},dynamic:{configurable:!0},vertexShader:{configurable:!0},fragmentShader:{configurable:!0}};Tb.parameters.get=function(){return{opaqueBack:{updateShader:!0},dullInterior:{updateShader:!0},side:{updateShader:!0,property:!0},opacity:{uniform:!0},depthWrite:{property:!0},clipNear:{updateShader:!0,property:!0},clipRadius:{updateShader:!0,property:!0,uniform:!0},clipCenter:{uniform:!0},flatShaded:{updateShader:!0},background:{updateShader:!0},wireframe:{updateVisibility:!0},roughness:{uniform:!0},metalness:{uniform:!0},diffuse:{uniform:!0},matrix:{}}},Tb.matrix.set=function(t){this.setMatrix(t)},Tb.matrix.get=function(){return this.group.matrix.clone()},Tb.transparent.get=function(){return this.opacity<1||this.forceTransparent},Tb.size.get=function(){return this._positionDataSize},Tb.attributeSize.get=function(){return this.size},Tb.pickable.get=function(){return!!this.picking&&!this.disablePicking},Tb.dynamic.get=function(){return!0},Tb.vertexShader.get=function(){},Tb.fragmentShader.get=function(){},Eb.prototype.setMatrix=function(t){ec(this.group,t),ec(this.wireframeGroup,t),ec(this.pickingGroup,t)},Eb.prototype.initIndex=function(t){this.geometry.setIndex(new Pt(t,1)),this.geometry.getIndex().setDynamic(this.dynamic)},Eb.prototype.makeMaterial=function(){var t=tc(this.side),e=new st({uniforms:this.uniforms,vertexShader:"",fragmentShader:"",depthTest:!0,transparent:this.transparent,depthWrite:this.depthWrite,lights:!0,fog:!0,side:t});e.vertexColors=Nl,e.extensions.derivatives=this.flatShaded,e.extensions.fragDepth=this.isImpostor,e.clipNear=this.clipNear;var i=new st({uniforms:this.uniforms,vertexShader:"",fragmentShader:"",depthTest:!0,transparent:this.transparent,depthWrite:this.depthWrite,lights:!1,fog:!0,side:t});i.vertexColors=Nl,i.clipNear=this.clipNear;var r=new st({uniforms:this.pickingUniforms,vertexShader:"",fragmentShader:"",depthTest:!0,transparent:!1,depthWrite:this.depthWrite,lights:!1,fog:!1,side:t,blending:kl});r.vertexColors=Nl,r.extensions.fragDepth=this.isImpostor,r.clipNear=this.clipNear,this.material=e,this.wireframeMaterial=i,this.pickingMaterial=r,this.updateShader()},Eb.prototype.makeWireframeGeometry=function(){this.makeWireframeIndex();var t=this.geometry,e=this.wireframeIndex,i=new Ft;i.attributes=t.attributes,e&&(i.setIndex(new Pt(e,1).setDynamic(this.dynamic)),i.setDrawRange(0,this.wireframeIndexCount)),this.wireframeGeometry=i},Eb.prototype.makeWireframeIndex=function(){function t(t,i){if(t>i){var r=t;t=i,i=r}var n=e[t];return void 0===n?(e[t]=[i],!0):!n.includes(i)&&(n.push(i),!0)}var e=[],i=this.geometry,r=i.index;if(this.wireframe)if(r){var n=r.array,o=n.length;i.drawRange.count!==1/0&&(o=i.drawRange.count);var a;a=this.wireframeIndex&&this.wireframeIndex.length>2*o?this.wireframeIndex:Kn(2*o,i.attributes.position.count);var s=0;e.length=0;for(var c=0;c<o;c+=3){var u=n[c+0],l=n[c+1],h=n[c+2];t(u,l)&&(a[s+0]=u,a[s+1]=l,s+=2),t(l,h)&&(a[s+0]=l,a[s+1]=h,s+=2),t(h,u)&&(a[s+0]=h,a[s+1]=u,s+=2)}this.wireframeIndex=a,this.wireframeIndexCount=s,this.wireframeIndexVersion=this.indexVersion}else{var p,d=i.attributes.position.count;p=this.wireframeIndex&&this.wireframeIndex.length>2*d?this.wireframeIndex:Kn(2*d,d);for(var f=0,m=0;f<d;f+=3)p[m+0]=f,p[m+1]=f+1,p[m+2]=f+1,p[m+3]=f+2,p[m+4]=f+2,p[m+5]=f,m+=6;this.wireframeIndex=p,this.wireframeIndexCount=2*d,this.wireframeIndexVersion=this.indexVersion}else this.wireframeIndex=new Uint16Array(0),this.wireframeIndexCount=0},Eb.prototype.updateWireframeIndex=function(){if(this.wireframeGeometry.setDrawRange(0,1/0),this.wireframeIndexVersion<this.indexVersion&&this.makeWireframeIndex(),this.wireframeIndex.length>this.wireframeGeometry.index.array.length)this.wireframeGeometry.setIndex(new Pt(this.wireframeIndex,1).setDynamic(this.dynamic));else{var t=this.wireframeGeometry.getIndex();t.set(this.wireframeIndex),t.needsUpdate=this.wireframeIndexCount>0,t.updateRange.count=this.wireframeIndexCount}this.wireframeGeometry.setDrawRange(0,this.wireframeIndexCount)},Eb.prototype.getRenderOrder=function(){var t=0;return this.isText?t=1:this.transparent&&(t=this.isSurface?3:2),t},Eb.prototype._getMesh=function(t){this.material||this.makeMaterial();var e,i=this.geometry,r=this[t];return this.isLine?e=new $e(i,r):this.isPoint?(e=new Xe(i,r),this.sortParticles&&(e.sortParticles=!0)):e=new Xt(i,r),e.frustumCulled=!1,e.renderOrder=this.getRenderOrder(),e},Eb.prototype.getMesh=function(){return this._getMesh("material")},Eb.prototype.getWireframeMesh=function(){var t;return this.material||this.makeMaterial(),this.wireframeGeometry||this.makeWireframeGeometry(),t=new $e(this.wireframeGeometry,this.wireframeMaterial),t.frustumCulled=!1,t.renderOrder=this.getRenderOrder(),t},Eb.prototype.getPickingMesh=function(){return this._getMesh("pickingMaterial")},Eb.prototype.getShader=function(t,e){return qo(t,this.getDefines(e))},Eb.prototype.getVertexShader=function(t){return this.getShader(this.vertexShader,t)},Eb.prototype.getFragmentShader=function(t){return this.getShader(this.fragmentShader,t)},Eb.prototype.getDefines=function(t){var e={};return this.clipNear&&(e.NEAR_CLIP=1),this.clipRadius&&(e.RADIUS_CLIP=1),"picking"===t?e.PICKING=1:(("background"===t||this.background)&&(e.NOLIGHT=1),this.flatShaded&&(e.FLAT_SHADED=1),this.opaqueBack&&(e.OPAQUE_BACK=1),this.dullInterior&&(e.DULL_INTERIOR=1)),e},Eb.prototype.getParameters=function(){var t=this,e={};for(var i in t.parameters)e[i]=t[i];return e},Eb.prototype.addUniforms=function(t){this.uniforms=Np.merge([this.uniforms,t]),this.pickingUniforms=Np.merge([this.pickingUniforms,t])},Eb.prototype.addAttributes=function(t){var e=this;for(var i in t){var r=void 0,n=t[i],o=e.attributeSize*Pb[n.type];n.value?(o!==n.value.length&&vm.error("attribute value has wrong length",i),r=n.value):r=Zn("float32",o),e.geometry.addAttribute(i,new Pt(r,Pb[n.type]).setDynamic(e.dynamic))}},Eb.prototype.updateRenderOrder=function(){function t(t){t.renderOrder=e}var e=this.getRenderOrder();this.group.children.forEach(t),this.pickingGroup&&this.pickingGroup.children.forEach(t)},Eb.prototype.updateShader=function(){var t=this.material,e=this.wireframeMaterial,i=this.pickingMaterial;t.vertexShader=this.getVertexShader(),t.fragmentShader=this.getFragmentShader(),t.needsUpdate=!0,e.vertexShader=this.getShader("Line.vert"),e.fragmentShader=this.getShader("Line.frag"),e.needsUpdate=!0,i.vertexShader=this.getVertexShader("picking"),i.fragmentShader=this.getFragmentShader("picking"),i.needsUpdate=!0},Eb.prototype.setParameters=function(t){var e=this;if(t){var i=t,r=this.parameters,n={},o={},a=!1,s=!1;for(var c in i){var u=i[c];void 0!==u&&(void 0!==r[c]&&(e[c]=u,r[c].property&&(!0!==r[c].property?n[r[c].property]=u:n[c]=u),r[c].uniform&&(!0!==r[c].uniform?o[r[c].uniform]=u:o[c]=u),r[c].updateShader&&(a=!0),r[c].updateVisibility&&(s=!0),e.dynamic&&"wireframe"===c&&!0===u&&e.updateWireframeIndex(),"flatShaded"===c&&(e.material.extensions.derivatives=e.flatShaded),"forceTransparent"===c&&(n.transparent=e.transparent)))}this.setProperties(n),this.setUniforms(o),a&&this.updateShader(),s&&this.setVisibility(this.visible)}},Eb.prototype.setAttributes=function(t){var e=this,i=this.geometry,r=i.attributes;for(var n in t)if("picking"!==n){var o=t[n],a=o.length;if("index"===n){var s=i.getIndex();i.setDrawRange(0,1/0),a>s.array.length?i.setIndex(new Pt(o,1).setDynamic(e.dynamic)):(s.set(o),s.needsUpdate=a>0,s.updateRange.count=a,i.setDrawRange(0,a)),e.indexVersion++,e.wireframe&&e.updateWireframeIndex()}else{var c=r[n];a>c.array.length?i.addAttribute(n,new Pt(o,c.itemSize).setDynamic(e.dynamic)):(r[n].set(o),r[n].needsUpdate=a>0,r[n].updateRange.count=a)}}},Eb.prototype.setUniforms=function(t){var e=this;if(t){var i=this.material.uniforms,r=this.wireframeMaterial.uniforms,n=this.pickingMaterial.uniforms;for(var o in t)"opacity"===o&&e.setProperties({transparent:e.transparent}),void 0!==i[o]&&(i[o].value.isVector3?i[o].value.copy(t[o]):i[o].value.set?i[o].value.set(t[o]):i[o].value=t[o]),void 0!==r[o]&&(r[o].value.isVector3?r[o].value.copy(t[o]):r[o].value.set?r[o].value.set(t[o]):r[o].value=t[o]),void 0!==n[o]&&(n[o].value.isVector3?n[o].value.copy(t[o]):n[o].value.set?n[o].value.set(t[o]):n[o].value=t[o])}},Eb.prototype.setProperties=function(t){var e=this;if(t){var i=this.material,r=this.wireframeMaterial,n=this.pickingMaterial;for(var o in t){var a=t[o];"transparent"===o?e.updateRenderOrder():"side"===o&&(a=tc(a)),void 0!==i[o]&&(i[o]=a),void 0!==r[o]&&(r[o]=a),void 0!==n[o]&&(n[o]=a)}i.needsUpdate=!0,r.needsUpdate=!0,n.needsUpdate=!0}},Eb.prototype.setVisibility=function(t){this.visible=t,this.wireframe?(this.group.visible=!1,this.wireframeGroup.visible=t,this.pickable&&(this.pickingGroup.visible=!1)):(this.group.visible=t,this.wireframeGroup.visible=!1,this.pickable&&(this.pickingGroup.visible=t))},Eb.prototype.dispose=function(){this.material&&this.material.dispose(),this.wireframeMaterial&&this.wireframeMaterial.dispose(),this.pickingMaterial&&this.pickingMaterial.dispose(),this.geometry.dispose(),this.wireframeGeometry&&this.wireframeGeometry.dispose()},Object.defineProperties(Eb.prototype,Tb);var Cb=function(t){function e(e,i){var r=e||{};!r.primitiveId&&r.position&&(r.primitiveId=ea(r.position.length/3)),t.call(this,r,i),this.addAttributes({normal:{type:"v3",value:r.normal}}),void 0===r.normal&&this.geometry.computeVertexNormals()}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={vertexShader:{configurable:!0},fragmentShader:{configurable:!0}};return i.vertexShader.get=function(){return"Mesh.vert"},i.fragmentShader.get=function(){return"Mesh.frag"},Object.defineProperties(e.prototype,i),e}(Eb),Ib=new lt,Rb=[Av,xv,Mv,Sv,Pv,_v,bv,wv,Tv,Ev],Lb=function(t,e){var i=this;this.name=Nn(t,"shape");var r=e||{};this.aspectRatio=Nn(r.aspectRatio,1.5),this.sphereDetail=Nn(r.sphereDetail,2),this.radialSegments=Nn(r.radialSegments,50),this.disableImpostor=Nn(r.disableImpostor,!1),this.openEnded=Nn(r.openEnded,!1),this.labelParams=Nn(r.labelParams,{}),this.boundingBox=new lt,this.bufferList=[],this.meshCount=0,Rb.forEach(function(t){Object.keys(t.fields).forEach(function(e){i[t.getShapeKey(e)]=[]}),i[t.getShapeKey("name")]=[]})},Ob={center:{configurable:!0},type:{configurable:!0}};Lb.prototype.addBuffer=function(t){this.bufferList.push(t);var e=t.geometry;return e.boundingBox||e.computeBoundingBox(),this.boundingBox.union(e.boundingBox),this},Lb.prototype.addMesh=function(t,e,i,r,n){t=ao(t),e=ao(e),Array.isArray(i)&&(i=Kn(i,t.length)),r&&(r=ao(r));var o={position:t,color:e,index:i,normal:r},a=new $v(this,Object.assign({serial:this.meshCount,name:n},o)),s=new Cb(Object.assign({picking:a},o));return this.bufferList.push(s),Ib.setFromArray(t),this.boundingBox.union(Ib),this.meshCount+=1,this},Lb.prototype.addSphere=function(t,e,i,r){return bv.objectToShape(this,{position:t,color:e,radius:i,name:r}),this},Lb.prototype.addEllipsoid=function(t,e,i,r,n,o){return Pv.objectToShape(this,{position:t,color:e,radius:i,majorAxis:r,minorAxis:n,name:o}),this},Lb.prototype.addTorus=function(t,e,i,r,n,o){return Ev.objectToShape(this,{position:t,color:e,radius:i,majorAxis:r,minorAxis:n,name:o}),this},Lb.prototype.addCylinder=function(t,e,i,r,n){return Sv.objectToShape(this,{position1:t,position2:e,color:i,radius:r,name:n}),this},Lb.prototype.addCone=function(t,e,i,r,n){return Mv.objectToShape(this,{position1:t,position2:e,color:i,radius:r,name:n}),this},Lb.prototype.addArrow=function(t,e,i,r,n){return Av.objectToShape(this,{position1:t,position2:e,color:i,radius:r,name:n}),this},Lb.prototype.addBox=function(t,e,i,r,n,o){return xv.objectToShape(this,{position:t,color:e,size:i,heightAxis:r,depthAxis:n,name:o}),this},Lb.prototype.addOctahedron=function(t,e,i,r,n,o){return _v.objectToShape(this,{position:t,color:e,size:i,heightAxis:r,depthAxis:n,name:o}),this},Lb.prototype.addTetrahedron=function(t,e,i,r,n,o){return wv.objectToShape(this,{position:t,color:e,size:i,heightAxis:r,depthAxis:n,name:o}),this},Lb.prototype.addText=function(t,e,i,r){return Tv.objectToShape(this,{position:t,color:e,size:i,text:r}),this},Lb.prototype.addLabel=function(t,e,i,r){return console.warn("Shape.addLabel is deprecated, use .addText instead"),this.addText(t,e,i,r)},Lb.prototype.getBufferList=function(){var t=this,e=[],i={aspectRatio:this.aspectRatio,sphereDetail:this.sphereDetail,radialSegments:this.radialSegments,disableImpostor:this.disableImpostor,openEnded:this.openEnded,labelParams:this.labelParams};return Rb.forEach(function(r){t[r.getShapeKey("color")].length&&e.push(r.bufferFromShape(t,i))}),this.bufferList.concat(e)},Lb.prototype.dispose=function(){var t=this;this.bufferList.forEach(function(t){t.dispose()}),this.bufferList.length=0,Rb.forEach(function(e){Object.keys(e.fields).forEach(function(i){t[e.getShapeKey(i)].length=0}),t[e.getShapeKey("name")].length=0})},Ob.center.get=function(){return this._center||(this._center=this.boundingBox.getCenter()),this._center},Ob.type.get=function(){return"Shape"},Object.defineProperties(Lb.prototype,Ob);var Db=function(t,e,i){this.type="",this.parameters={lazy:{type:"boolean"},clipNear:{type:"range",step:1,max:100,min:0,buffer:!0},clipRadius:{type:"number",precision:1,max:1e3,min:0,buffer:!0},clipCenter:{type:"vector3",precision:1,buffer:!0},flatShaded:{type:"boolean",buffer:!0},opacity:{type:"range",step:.01,max:1,min:0,buffer:!0},depthWrite:{type:"boolean",buffer:!0},side:{type:"select",buffer:!0,options:{front:"front",back:"back",double:"double"}},wireframe:{type:"boolean",buffer:!0},colorScheme:{type:"select",update:"color",options:{}},colorScale:{type:"select",update:"color",options:_m.getScales()},colorReverse:{type:"boolean",update:"color"},colorValue:{type:"color",update:"color"},colorDomain:{type:"hidden",update:"color"},colorMode:{type:"select",update:"color",options:_m.getModes()},roughness:{type:"range",step:.01,max:1,min:0,buffer:!0},metalness:{type:"range",step:.01,max:1,min:0,buffer:!0},diffuse:{type:"color",buffer:!0},matrix:{type:"hidden",buffer:!0},disablePicking:{type:"boolean",rebuild:!0}},this.viewer=e,this.tasks=new Ym,this.queue=new ic(this.make.bind(this)),this.bufferList=[],this.parameters.colorScheme&&(this.parameters.colorScheme.options=_m.getSchemes())};Db.prototype.init=function(t){var e=t||{};this.clipNear=Nn(e.clipNear,0),this.clipRadius=Nn(e.clipRadius,0),this.clipCenter=Nn(e.clipCenter,new v),this.flatShaded=Nn(e.flatShaded,!1),this.side=Nn(e.side,"double"),this.opacity=Nn(e.opacity,1),this.depthWrite=Nn(e.depthWrite,!0),this.wireframe=Nn(e.wireframe,!1),this.setColor(e.color,e),this.colorScheme=Nn(e.colorScheme,"uniform"),this.colorScale=Nn(e.colorScale,""),this.colorReverse=Nn(e.colorReverse,!1),this.colorValue=Nn(e.colorValue,9474192),this.colorDomain=Nn(e.colorDomain,void 0),this.colorMode=Nn(e.colorMode,"hcl"),this.visible=Nn(e.visible,!0),this.quality=Nn(e.quality,void 0),this.roughness=Nn(e.roughness,.4),this.metalness=Nn(e.metalness,0),this.diffuse=Nn(e.diffuse,16777215),this.lazy=Nn(e.lazy,!1),this.lazyProps={build:!1,bufferParams:{},what:{}},this.matrix=Nn(e.matrix,new y),this.disablePicking=Nn(e.disablePicking,!1);var i=this.parameters;!0===i.sphereDetail&&(i.sphereDetail={type:"integer",max:3,min:0,rebuild:"impostor"}),!0===i.radialSegments&&(i.radialSegments={type:"integer",max:25,min:5,rebuild:"impostor"}),!0===i.openEnded&&(i.openEnded={type:"boolean",rebuild:"impostor",buffer:!0}),!0===i.disableImpostor&&(i.disableImpostor={type:"boolean",rebuild:!0}),"low"===e.quality?(i.sphereDetail&&(this.sphereDetail=0),i.radialSegments&&(this.radialSegments=5)):"medium"===e.quality?(i.sphereDetail&&(this.sphereDetail=1),i.radialSegments&&(this.radialSegments=10)):"high"===e.quality?(i.sphereDetail&&(this.sphereDetail=2),i.radialSegments&&(this.radialSegments=20)):(i.sphereDetail&&(this.sphereDetail=Nn(e.sphereDetail,1)),i.radialSegments&&(this.radialSegments=Nn(e.radialSegments,10))),i.openEnded&&(this.openEnded=Nn(e.openEnded,!0)),i.disableImpostor&&(this.disableImpostor=Nn(e.disableImpostor,!1))},Db.prototype.getColorParams=function(t){return Object.assign({scheme:this.colorScheme,scale:this.colorScale,reverse:this.colorReverse,value:this.colorValue,domain:this.colorDomain,mode:this.colorMode},t)},Db.prototype.getBufferParams=function(t){return Object.assign({clipNear:this.clipNear,clipRadius:this.clipRadius,clipCenter:this.clipCenter,flatShaded:this.flatShaded,opacity:this.opacity,depthWrite:this.depthWrite,side:this.side,wireframe:this.wireframe,roughness:this.roughness,metalness:this.metalness,diffuse:this.diffuse,matrix:this.matrix,disablePicking:this.disablePicking},t)},Db.prototype.setColor=function(t,e){var i=Object.keys(_m.getSchemes());return"string"==typeof t&&i.includes(t.toLowerCase())?e?e.colorScheme=t:this.setParameters({colorScheme:t}):void 0!==t&&(t=new et(t).getHex(),e?(e.colorScheme="uniform",e.colorValue=t):this.setParameters({colorScheme:"uniform",colorValue:t})),this},Db.prototype.create=function(){},Db.prototype.update=function(){this.build()},Db.prototype.build=function(t){if(!this.lazy||this.visible){if(!this.prepare)return this.tasks.increment(),void this.make();this.queue.length()>0?(this.tasks.change(1-this.queue.length()),this.queue.kill()):this.tasks.increment(),this.queue.push(t||!1)}else this.lazyProps.build=!0},Db.prototype.make=function(e,i){t.Debug&&vm.time("Representation.make "+this.type);var r=function(){e?(this.update(e),this.viewer.requestRender(),this.tasks.decrement(),i&&i()):(this.clear(),this.create(),this.manualAttach||this.disposed||(t.Debug&&vm.time("Representation.attach "+this.type),this.attach(function(){t.Debug&&vm.timeEnd("Representation.attach "+this.type),this.tasks.decrement(),i&&i()}.bind(this)))),t.Debug&&vm.timeEnd("Representation.make "+this.type)}.bind(this);this.prepare?this.prepare(r):r()},Db.prototype.attach=function(t){this.setVisibility(this.visible),t()},Db.prototype.setVisibility=function(t,e){if(this.visible=t,this.visible){var i=this.lazyProps,r=i.bufferParams,n=i.what;if(i.build)return i.build=!1,void this.build();(Object.keys(r).length||Object.keys(n).length)&&(i.bufferParams={},i.what={},this.updateParameters(r,n))}return this.bufferList.forEach(function(e){e.setVisibility(t)}),e||this.viewer.requestRender(),this},Db.prototype.setParameters=function(t,e,i){var r=this,n=t||{},o=this.parameters;this.setColor(n.color,n),e=e||{},i=i||!1;var a={};for(var s in n)void 0!==n[s]&&void 0!==o[s]&&(o[s].int&&(n[s]=parseInt(n[s])),o[s].float&&(n[s]=parseFloat(n[s])),(n[s]!==r[s]||n[s].equals&&!n[s].equals(r[s]))&&(r[s]&&r[s].set?r[s].set(n[s]):r[s]=n[s],o[s].buffer&&(!0===o[s].buffer?a[s]=n[s]:a[o[s].buffer]=n[s]),o[s].update&&(e[o[s].update]=!0),!o[s].rebuild||"impostor"===o[s].rebuild&&gm&&!r.disableImpostor||(i=!0)));return i?this.build():this.updateParameters(a,e),this},Db.prototype.updateParameters=function(t,e){if(this.lazy&&!this.visible)return Object.assign(this.lazyProps.bufferParams,t),void Object.assign(this.lazyProps.what,e);this.bufferList.forEach(function(e){e.setParameters(t)}),Object.keys(e).length&&this.update(e),this.viewer.requestRender()},Db.prototype.getParameters=function(){var t=this,e={lazy:this.lazy,visible:this.visible,quality:this.quality};return Object.keys(this.parameters).forEach(function(i){null!==t.parameters[i]&&(e[i]=t[i])}),e},Db.prototype.clear=function(){var t=this;this.bufferList.forEach(function(e){t.viewer.remove(e),e.dispose()}),this.bufferList.length=0,this.viewer.requestRender()},Db.prototype.dispose=function(){this.disposed=!0,this.queue.kill(),this.tasks.dispose(),this.clear()};var Nb=function(t){function e(e,i,r){Array.isArray(e)||(e=[e]),t.call(this,e,i,r),this.type="buffer",this.parameters=Object.assign({},this.parameters,{colorScheme:null,colorScale:null,colorValue:null,colorDomain:null,colorMode:null}),this.buffer=e,this.init(r)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.init=function(e){t.prototype.init.call(this,e),this.build()},e.prototype.create=function(){this.bufferList.push.apply(this.bufferList,this.buffer)},e.prototype.attach=function(t){var e=this;this.bufferList.forEach(function(t){e.viewer.add(t),t.setParameters(e.getBufferParams())}),this.setVisibility(this.visible),t()},e}(Db),kb=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={isSurface:{configurable:!0}};return i.isSurface.get=function(){return!0},Object.defineProperties(e.prototype,i),e}(Cb),Bb=function(t){this.size=t.size,this.side=t.side,this.wireframe=t.wireframe,this.visible=t.visible,this.geometry=t.geometry,this.picking=t.picking,this.background=t.background,this.disablePicking=t.disablePicking,this.group=new qe,this.wireframeGroup=new qe,this.pickingGroup=new qe,this.matrix=t.matrix,this.frontMeshes=[],this.backMeshes=[];var e=t,i=new t.constructor;e.makeMaterial(),i.makeMaterial(),i.picking=t.picking,i.geometry=t.geometry,i.wireframeGeometry=t.wireframeGeometry,i.setParameters(t.getParameters()),i.updateShader(),e.setParameters({side:"front"}),i.setParameters({side:"back",opacity:i.opacity}),this.buffer=t,this.frontBuffer=e,this.backBuffer=i},Fb={matrix:{configurable:!0},pickable:{configurable:!0}};Fb.matrix.set=function(t){Eb.prototype.setMatrix.call(this,t)},Fb.matrix.get=function(){return this.group.matrix.clone()},Fb.pickable.get=function(){return!!this.picking&&!this.disablePicking},Bb.prototype.getMesh=function(t){var e,i;return t?(i=this.backBuffer.getPickingMesh(),e=this.frontBuffer.getPickingMesh()):(i=this.backBuffer.getMesh(),e=this.frontBuffer.getMesh()),this.frontMeshes.push(e),this.backMeshes.push(i),this.setParameters({side:this.side}),(new qe).add(i,e)},Bb.prototype.getWireframeMesh=function(){return this.buffer.getWireframeMesh()},Bb.prototype.getPickingMesh=function(){return this.getMesh(!0)},Bb.prototype.setAttributes=function(t){this.buffer.setAttributes(t)},Bb.prototype.setParameters=function(t){"front"===(t=Object.assign({},t)).side?(this.frontMeshes.forEach(rc),this.backMeshes.forEach(nc)):"back"===t.side?(this.frontMeshes.forEach(nc),this.backMeshes.forEach(rc)):"double"===t.side&&(this.frontMeshes.forEach(rc),this.backMeshes.forEach(rc)),void 0!==t.matrix&&(this.matrix=t.matrix),delete t.matrix,void 0!==t.side&&(this.side=t.side),delete t.side,this.frontBuffer.setParameters(t),void 0!==t.wireframe&&(this.wireframe=t.wireframe,this.setVisibility(this.visible)),delete t.wireframe,this.backBuffer.setParameters(t)},Bb.prototype.dispose=function(){this.frontBuffer.dispose(),this.backBuffer.dispose()},Object.defineProperties(Bb.prototype,Fb),Bb.prototype.setVisibility=Eb.prototype.setVisibility,Mm.add("shader/Line.vert","uniform float nearClip;\nuniform vec3 clipCenter;\nvarying vec3 vViewPosition;\n#if defined( RADIUS_CLIP )\nvarying vec3 vClipCenter;\n#endif\n#include color_pars_vertex\nvoid main(){\n#include color_vertex\n#include begin_vertex\n#include project_vertex\nvViewPosition = -mvPosition.xyz;\n#if defined( RADIUS_CLIP )\nvClipCenter = -( modelViewMatrix * vec4( clipCenter, 1.0 ) ).xyz;\n#endif\n#include nearclip_vertex\n}"),Mm.add("shader/Line.frag","uniform float opacity;\nuniform float nearClip;\nuniform float clipRadius;\nvarying vec3 vViewPosition;\n#if defined( RADIUS_CLIP )\nvarying vec3 vClipCenter;\n#endif\n#include common\n#include color_pars_fragment\n#include fog_pars_fragment\nvoid main(){\n#include nearclip_fragment\n#include radiusclip_fragment\ngl_FragColor = vec4( vColor, opacity );\n#include premultiplied_alpha_fragment\n#include tonemapping_fragment\n#include encodings_fragment\n#include fog_fragment\n}");var zb=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={isLine:{configurable:!0},vertexShader:{configurable:!0},fragmentShader:{configurable:!0}};return i.isLine.get=function(){return!0},i.vertexShader.get=function(){return"Line.vert"},i.fragmentShader.get=function(){return"Line.frag"},Object.defineProperties(e.prototype,i),e}(Eb),Ub=function(t){function e(e,i,r){t.call(this,e,i,r),this.type="surface",this.parameters=Object.assign({isolevelType:{type:"select",options:{value:"value",sigma:"sigma"}},isolevel:{type:"number",precision:2,max:1e3,min:-1e3},negateIsolevel:{type:"boolean"},smooth:{type:"integer",precision:1,max:10,min:0},background:{type:"boolean",rebuild:!0},opaqueBack:{type:"boolean",buffer:!0},boxSize:{type:"integer",precision:1,max:100,min:0},colorVolume:{type:"hidden"},contour:{type:"boolean",rebuild:!0},useWorker:{type:"boolean",rebuild:!0},wrap:{type:"boolean",rebuild:!0}},this.parameters),e instanceof ky?(this.surface=void 0,this.volume=e):(this.surface=e,this.volume=void 0),this.boxCenter=new v,this.__boxCenter=new v,this.box=new lt,this.__box=new lt,this._position=new v,this.setBox=function(){this._position.copy(i.translationGroup.position).negate(),this._position.equals(this.boxCenter)||this.setParameters({boxCenter:this._position})},this.viewer.signals.ticked.add(this.setBox,this),this.init(r)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.init=function(e){var i=e||{};i.colorScheme=Nn(i.colorScheme,"uniform"),i.colorValue=Nn(i.colorValue,14540253),this.isolevelType=Nn(i.isolevelType,"sigma"),this.isolevel=Nn(i.isolevel,2),this.negateIsolevel=Nn(i.negateIsolevel,!1),this.smooth=Nn(i.smooth,0),this.background=Nn(i.background,!1),this.opaqueBack=Nn(i.opaqueBack,!0),this.boxSize=Nn(i.boxSize,0),this.colorVolume=Nn(i.colorVolume,void 0),this.contour=Nn(i.contour,!1),this.useWorker=Nn(i.useWorker,!0),this.wrap=Nn(i.wrap,!1),t.prototype.init.call(this,i),this.build()},e.prototype.attach=function(t){var e=this;this.bufferList.forEach(function(t){e.viewer.add(t)}),this.setVisibility(this.visible),t()},e.prototype.prepare=function(t){var e=this;if(this.volume){var i;if(i="sigma"===this.isolevelType?this.volume.getValueForSigma(this.isolevel):this.isolevel,this.negateIsolevel&&(i*=-1),!this.surface||this.__isolevel!==i||this.__smooth!==this.smooth||this.__contour!==this.contour||this.__wrap!==this.wrap||this.__boxSize!==this.boxSize||this.boxSize>0&&!this.__boxCenter.equals(this.boxCenter)){this.__isolevel=i,this.__smooth=this.smooth,this.__contour=this.contour,this.__wrap=this.wrap,this.__boxSize=this.boxSize,this.__boxCenter.copy(this.boxCenter),this.__box.copy(this.box);var r=function(i){e.surface=i,t()};this.useWorker?this.volume.getSurfaceWorker(i,this.smooth,this.boxCenter,this.boxSize,this.contour,this.wrap,r):r(this.volume.getSurface(i,this.smooth,this.boxCenter,this.boxSize,this.contour,this.wrap))}else t()}else t()},e.prototype.create=function(){var t,e={position:this.surface.getPosition(),color:this.surface.getColor(this.getColorParams()),index:this.surface.getIndex()};if(this.contour)t=new zb(e,this.getBufferParams({wireframe:!1}));else{e.normal=this.surface.getNormal(),e.picking=this.surface.getPicking();var i=new kb(e,this.getBufferParams({background:this.background,opaqueBack:this.opaqueBack,dullInterior:!1}));t=new Bb(i)}this.bufferList.push(t)},e.prototype.update=function(t){if(0!==this.bufferList.length){var e={};(t=t||{}).position&&(e.position=this.surface.getPosition()),t.color&&(e.color=this.surface.getColor(this.getColorParams())),t.index&&(e.index=this.surface.getIndex()),t.normal&&(e.normal=this.surface.getNormal()),this.bufferList.forEach(function(t){t.setAttributes(e)})}},e.prototype.setParameters=function(e,i,r){return e&&void 0!==e.isolevelType&&this.volume&&("value"===this.isolevelType&&"sigma"===e.isolevelType?this.isolevel=this.volume.getSigmaForValue(this.isolevel):"sigma"===this.isolevelType&&"value"===e.isolevelType&&(this.isolevel=this.volume.getValueForSigma(this.isolevel)),this.isolevelType=e.isolevelType),e&&e.boxCenter&&(this.boxCenter.copy(e.boxCenter),delete e.boxCenter),e&&e.wireframe&&(e.contour||void 0===e.contour&&this.contour)&&(e.wireframe=!1),t.prototype.setParameters.call(this,e,i,r),this.volume&&this.volume.getBox(this.boxCenter,this.boxSize,this.box),e&&void 0!==e.colorVolume&&(i.color=!0),this.surface&&(void 0!==e.isolevel||void 0!==e.negateIsolevel||void 0!==e.smooth||void 0!==e.wrap||void 0!==e.boxSize||this.boxSize>0&&!this.__box.equals(this.box))&&this.build({position:!0,color:!0,index:!0,normal:!this.contour}),this},e.prototype.getColorParams=function(){var e=t.prototype.getColorParams.call(this);return e.volume=this.colorVolume,e},e.prototype.dispose=function(){this.viewer.signals.ticked.remove(this.setBox,this),t.prototype.dispose.call(this)},e}(Db),jb=new y,Vb=new pt,Gb=function(t){function e(e,i,r){var n,o=e||{},a=i||{},s=r.attributes.position.array,c=r.attributes.normal.array,u=r.index?r.index.array:void 0,l=o.position.length/3,h=s.length/3,p=l*h,d=new Float32Array(3*p),f=new Float32Array(3*p),m=new Float32Array(3*p);u&&(n=Kn(l*u.length,p)),t.call(this,{position:d,color:m,index:n,normal:f,primitiveId:o.primitiveId||ia(l,h),picking:o.picking},a),this.setAttributes(o),this.geoPosition=s,this.geoNormal=c,this.geoIndex=u,this.positionCount=l,this.geoPositionCount=h,this.transformedGeoPosition=new Float32Array(3*h),this.transformedGeoNormal=new Float32Array(3*h),this.meshPosition=d,this.meshColor=m,this.meshIndex=n,this.meshNormal=f,this.meshIndex=n,this.makeIndex()}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={updateNormals:{configurable:!0}};return e.prototype.applyPositionTransform=function(){},e.prototype.setAttributes=function(t,e){var i,r,n,o,a,s,c,u,l,h=this,p=this.geometry.attributes,d=this.updateNormals;t.position&&(i=t.position,n=this.geoPosition,c=this.meshPosition,a=this.transformedGeoPosition,p.position.needsUpdate=!0,(d||e)&&(o=this.geoNormal,l=this.meshNormal,s=this.transformedGeoNormal,p.normal.needsUpdate=!0)),t.color&&(r=t.color,u=this.meshColor,p.color.needsUpdate=!0);for(var f=this.positionCount,m=this.geoPositionCount,g=0;g<f;++g){var v=void 0,y=void 0,b=g*m*3,x=3*g;if(i&&(a.set(n),jb.makeTranslation(i[x],i[x+1],i[x+2]),h.applyPositionTransform(jb,g,x),Pa(jb.elements,a),c.set(a,b),d?(s.set(o),Vb.getNormalMatrix(jb),Ea(Vb.elements,s),l.set(s,b)):e&&l.set(o,b)),r)for(v=0;v<m;++v)u[y=b+3*v]=r[x],u[y+1]=r[x+1],u[y+2]=r[x+2]}},e.prototype.makeIndex=function(){var t=this.geoIndex,e=this.meshIndex;if(t)for(var i=this.positionCount,r=this.geoPositionCount,n=3*(t.length/3),o=0;o<i;++o){var a=o*n,s=a+n;e.set(t,a);for(var c=a;c<s;++c)e[c]+=o*r}},i.updateNormals.get=function(){return!1},Object.defineProperties(e.prototype,i),e}(Cb),$b=new v,Hb=function(t){function e(e,i){var r=i||{},n=new ci(1,Nn(r.sphereDetail,1));t.call(this,e,r,n),this.setAttributes(e,!0)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.applyPositionTransform=function(t,e){var i=this._radius[e];$b.set(i,i,i),t.scale($b)},e.prototype.setAttributes=function(e,i){e.radius&&(this._radius=e.radius),t.prototype.setAttributes.call(this,e,i)},e}(Gb);Mm.add("shader/SphereImpostor.vert","uniform mat4 projectionMatrixInverse;\nuniform float nearClip;\nvarying float vRadius;\nvarying float vRadiusSq;\nvarying vec3 vPoint;\nvarying vec3 vPointViewPosition;\nattribute vec2 mapping;\nattribute float radius;\n#ifdef PICKING\n#include unpack_color\nattribute float primitiveId;\nvarying vec3 vPickingColor;\n#else\n#include color_pars_vertex\n#endif\n#include matrix_scale\nconst mat4 D = mat4(\n1.0, 0.0, 0.0, 0.0,\n0.0, 1.0, 0.0, 0.0,\n0.0, 0.0, 1.0, 0.0,\n0.0, 0.0, 0.0, -1.0\n);\nmat4 transpose( in mat4 inMatrix ) {\nvec4 i0 = inMatrix[0];\nvec4 i1 = inMatrix[1];\nvec4 i2 = inMatrix[2];\nvec4 i3 = inMatrix[3];\nmat4 outMatrix = mat4(\nvec4(i0.x, i1.x, i2.x, i3.x),\nvec4(i0.y, i1.y, i2.y, i3.y),\nvec4(i0.z, i1.z, i2.z, i3.z),\nvec4(i0.w, i1.w, i2.w, i3.w)\n);\nreturn outMatrix;\n}\nvoid ComputePointSizeAndPositionInClipCoordSphere(){\nvec2 xbc;\nvec2 ybc;\nmat4 T = mat4(\nradius, 0.0, 0.0, 0.0,\n0.0, radius, 0.0, 0.0,\n0.0, 0.0, radius, 0.0,\nposition.x, position.y, position.z, 1.0\n);\nmat4 R = transpose( projectionMatrix * modelViewMatrix * T );\nfloat A = dot( R[ 3 ], D * R[ 3 ] );\nfloat B = -2.0 * dot( R[ 0 ], D * R[ 3 ] );\nfloat C = dot( R[ 0 ], D * R[ 0 ] );\nxbc[ 0 ] = ( -B - sqrt( B * B - 4.0 * A * C ) ) / ( 2.0 * A );\nxbc[ 1 ] = ( -B + sqrt( B * B - 4.0 * A * C ) ) / ( 2.0 * A );\nfloat sx = abs( xbc[ 0 ] - xbc[ 1 ] ) * 0.5;\nA = dot( R[ 3 ], D * R[ 3 ] );\nB = -2.0 * dot( R[ 1 ], D * R[ 3 ] );\nC = dot( R[ 1 ], D * R[ 1 ] );\nybc[ 0 ] = ( -B - sqrt( B * B - 4.0 * A * C ) ) / ( 2.0 * A );\nybc[ 1 ] = ( -B + sqrt( B * B - 4.0 * A * C ) ) / ( 2.0 * A );\nfloat sy = abs( ybc[ 0 ] - ybc[ 1 ] ) * 0.5;\ngl_Position.xy = vec2( 0.5 * ( xbc.x + xbc.y ), 0.5 * ( ybc.x + ybc.y ) );\ngl_Position.xy -= mapping * vec2( sx, sy );\ngl_Position.xy *= gl_Position.w;\n}\nvoid main(void){\n#ifdef PICKING\nvPickingColor = unpackColor( primitiveId );\n#else\n#include color_vertex\n#endif\nvRadius = radius * matrixScale( modelViewMatrix );\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nmvPosition.z -= vRadius;\ngl_Position = projectionMatrix * vec4( mvPosition.xyz, 1.0 );\nComputePointSizeAndPositionInClipCoordSphere();\nvRadiusSq = vRadius * vRadius;\nvec4 vPoint4 = projectionMatrixInverse * gl_Position;\nvPoint = vPoint4.xyz / vPoint4.w;\nvPointViewPosition = -mvPosition.xyz / mvPosition.w;\n}"),Mm.add("shader/SphereImpostor.frag","#define STANDARD\n#define IMPOSTOR\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float roughness;\nuniform float metalness;\nuniform float opacity;\nuniform float nearClip;\nuniform mat4 projectionMatrix;\nuniform float ortho;\nvarying float vRadius;\nvarying float vRadiusSq;\nvarying vec3 vPoint;\nvarying vec3 vPointViewPosition;\n#ifdef PICKING\nuniform float objectId;\nvarying vec3 vPickingColor;\n#else\n#include common\n#include color_pars_fragment\n#include fog_pars_fragment\n#include bsdfs\n#include lights_pars\n#include lights_physical_pars_fragment\n#endif\nbool flag2 = false;\nbool interior = false;\nvec3 cameraPos;\nvec3 cameraNormal;\nfloat calcDepth( in vec3 cameraPos ){\nvec2 clipZW = cameraPos.z * projectionMatrix[2].zw + projectionMatrix[3].zw;\nreturn 0.5 + 0.5 * clipZW.x / clipZW.y;\n}\nfloat calcClip( vec3 cameraPos ){\nreturn dot( vec4( cameraPos, 1.0 ), vec4( 0.0, 0.0, 1.0, nearClip - 0.5 ) );\n}\nbool Impostor( out vec3 cameraPos, out vec3 cameraNormal ){\nvec3 cameraSpherePos = -vPointViewPosition;\ncameraSpherePos.z += vRadius;\nvec3 rayOrigin = mix( vec3( 0.0, 0.0, 0.0 ), vPoint, ortho );\nvec3 rayDirection = mix( normalize( vPoint ), vec3( 0.0, 0.0, 1.0 ), ortho );\nvec3 cameraSphereDir = mix( cameraSpherePos, rayOrigin - cameraSpherePos, ortho );\nfloat B = dot( rayDirection, cameraSphereDir );\nfloat det = B * B + vRadiusSq - dot( cameraSphereDir, cameraSphereDir );\nif( det < 0.0 ){\ndiscard;\nreturn false;\n}else{\nfloat sqrtDet = sqrt( det );\nfloat posT = mix( B + sqrtDet, B + sqrtDet, ortho );\nfloat negT = mix( B - sqrtDet, sqrtDet - B, ortho );\ncameraPos = rayDirection * negT + rayOrigin;\n#ifdef NEAR_CLIP\nif( calcDepth( cameraPos ) <= 0.0 ){\ncameraPos = rayDirection * posT + rayOrigin;\ninterior = true;\nreturn false;\n}else if( calcClip( cameraPos ) > 0.0 ){\ncameraPos = rayDirection * posT + rayOrigin;\ninterior = true;\nflag2 = true;\nreturn false;\n}else{\ncameraNormal = normalize( cameraPos - cameraSpherePos );\n}\n#else\nif( calcDepth( cameraPos ) <= 0.0 ){\ncameraPos = rayDirection * posT + rayOrigin;\ninterior = true;\nreturn false;\n}else{\ncameraNormal = normalize( cameraPos - cameraSpherePos );\n}\n#endif\nreturn true;\n}\nreturn false;\n}\nvoid main(void){\nbool flag = Impostor( cameraPos, cameraNormal );\n#ifdef NEAR_CLIP\nif( calcClip( cameraPos ) > 0.0 )\ndiscard;\n#endif\ngl_FragDepthEXT = calcDepth( cameraPos );\nif( !flag ){\n#ifdef NEAR_CLIP\nif( flag2 ){\ngl_FragDepthEXT = max( 0.0, calcDepth( vec3( - ( nearClip - 0.5 ) ) ) + ( 0.0000001 / vRadius ) );\n}else if( gl_FragDepthEXT >= 0.0 ){\ngl_FragDepthEXT = 0.0 + ( 0.0000001 / vRadius );\n}\n#else\nif( gl_FragDepthEXT >= 0.0 ){\ngl_FragDepthEXT = 0.0 + ( 0.0000001 / vRadius );\n}\n#endif\n}\nif (gl_FragDepthEXT < 0.0)\ndiscard;\nif (gl_FragDepthEXT > 1.0)\ndiscard;\n#ifdef PICKING\ngl_FragColor = vec4( vPickingColor, objectId );\n#else\nvec3 vNormal = cameraNormal;\nvec3 vViewPosition = -cameraPos;\nvec4 diffuseColor = vec4( diffuse, opacity );\nReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\nvec3 totalEmissiveLight = emissive;\n#include color_fragment\n#include roughnessmap_fragment\n#include metalnessmap_fragment\n#include normal_flip\n#include normal_fragment\nif( interior ){\nnormal = vec3( 0.0, 0.0, 0.4 );\n}\n#include lights_physical_fragment\n#include lights_template\nvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveLight;\ngl_FragColor = vec4( outgoingLight, diffuseColor.a );\n#include premultiplied_alpha_fragment\n#include tonemapping_fragment\n#include encodings_fragment\n#include fog_fragment\n#endif\n}");var Wb=function(t){function e(e,i){t.call(this,e,i),this.index=Kn(this.indexSize,this.attributeSize),this.makeIndex(),this.initIndex(this.index,1),this.addAttributes({mapping:{type:this.mappingType,value:null}}),this.setAttributes({primitiveId:ea(this.size)})}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={attributeSize:{configurable:!0},indexSize:{configurable:!0},mapping:{configurable:!0},mappingIndices:{configurable:!0},mappingIndicesSize:{configurable:!0},mappingType:{configurable:!0},mappingSize:{configurable:!0},mappingItemSize:{configurable:!0}};return i.attributeSize.get=function(){return this.size*this.mappingSize},i.indexSize.get=function(){return this.size*this.mappingIndicesSize},i.mapping.get=function(){},i.mappingIndices.get=function(){},i.mappingIndicesSize.get=function(){},i.mappingType.get=function(){},i.mappingSize.get=function(){},i.mappingItemSize.get=function(){},e.prototype.addAttributes=function(e){var i={};for(var r in e){var n=e[r];i[r]={type:n.type,value:null}}t.prototype.addAttributes.call(this,i)},e.prototype.getAttributeIndex=function(t){return 3*t*this.mappingSize},e.prototype.setAttributes=function(t){t&&!t.position&&t.position1&&t.position2&&(t.position=Ko(t.position1,t.position2));var e,i,r,n,o,a,s,c=this.size,u=this.mappingSize,l=this.geometry.attributes;for(var h in t)if("index"!==h&&"picking"!==h){i=t[h],r=(e=l[h]).itemSize,n=e.array;for(var p=0;p<c;++p){a=(o=p*r)*u;for(var d=0;d<u;++d){s=a+r*d;for(var f=0;f<r;++f)n[s+f]=i[o+f]}}e.needsUpdate=!0}},e.prototype.makeMapping=function(){for(var t=this.size,e=this.mapping,i=this.mappingSize,r=this.mappingItemSize,n=this.geometry.attributes.mapping.array,o=0;o<t;o++)n.set(e,o*r*i)},e.prototype.makeIndex=function(){for(var t,e,i=this.size,r=this.mappingSize,n=this.mappingIndices,o=this.mappingIndicesSize,a=this.index,s=0;s<i;s++){t=s*o,e=s*r,a.set(n,t);for(var c=0;c<o;++c)a[t+c]+=e}},Object.defineProperties(e.prototype,i),e}(Eb),Xb=new Float32Array([-1,1,-1,-1,1,1,1,-1]),qb=new Uint16Array([0,1,2,1,3,2]),Yb=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={mapping:{configurable:!0},mappingIndices:{configurable:!0},mappingIndicesSize:{configurable:!0},mappingType:{configurable:!0},mappingSize:{configurable:!0},mappingItemSize:{configurable:!0}};return i.mapping.get=function(){return Xb},i.mappingIndices.get=function(){return qb},i.mappingIndicesSize.get=function(){return 6},i.mappingType.get=function(){return"v2"},i.mappingSize.get=function(){return 4},i.mappingItemSize.get=function(){return 2},Object.defineProperties(e.prototype,i),e}(Wb),Zb=function(t){function e(e,i){t.call(this,e,i),this.addUniforms({projectionMatrixInverse:{value:new y},ortho:{value:0}}),this.addAttributes({radius:{type:"f",value:null}}),this.setAttributes(e),this.makeMapping()}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={isImpostor:{configurable:!0},vertexShader:{configurable:!0},fragmentShader:{configurable:!0}};return i.isImpostor.get=function(){return!0},i.vertexShader.get=function(){return"SphereImpostor.vert"},i.fragmentShader.get=function(){return"SphereImpostor.frag"},Object.defineProperties(e.prototype,i),e}(Yb),Kb=function(t,e){return!gm||e&&e.disableImpostor?new Hb(t,e):new Zb(t,e)};Tm.add("sphere",Kb),Mm.add("shader/Point.vert","uniform float nearClip;\nuniform float clipRadius;\nuniform vec3 clipCenter;\nuniform float size;\nuniform float canvasHeight;\nuniform float pixelRatio;\n#if defined( RADIUS_CLIP )\nvarying vec3 vClipCenter;\n#endif\n#if defined( PICKING )\n#include unpack_color\nattribute float primitiveId;\nvarying vec3 vPickingColor;\n#else\n#include color_pars_vertex\nvarying vec3 vViewPosition;\n#endif\n#include common\nvoid main(){\n#if defined( PICKING )\nvPickingColor = unpackColor( primitiveId );\n#else\n#include color_vertex\n#endif\n#include begin_vertex\n#include project_vertex\n#ifdef USE_SIZEATTENUATION\ngl_PointSize = size * pixelRatio * ( ( canvasHeight / 2.0 ) / -mvPosition.z );\n#else\ngl_PointSize = size * pixelRatio;\n#endif\n#ifndef PICKING\nvViewPosition = -mvPosition.xyz;\n#endif\n#if defined( RADIUS_CLIP )\nvClipCenter = -( modelViewMatrix * vec4( clipCenter, 1.0 ) ).xyz;\n#endif\n#include nearclip_vertex\n#include radiusclip_vertex\n}"),Mm.add("shader/Point.frag","uniform vec3 diffuse;\nuniform float opacity;\nuniform float nearClip;\nuniform float clipRadius;\n#if defined( RADIUS_CLIP )\nvarying vec3 vClipCenter;\n#endif\n#ifdef USE_MAP\nuniform sampler2D map;\n#endif\n#if defined( PICKING )\nuniform float objectId;\nvarying vec3 vPickingColor;\n#else\n#include common\n#include color_pars_fragment\n#include fog_pars_fragment\nvarying vec3 vViewPosition;\n#endif\nvoid main(){\n#include nearclip_fragment\n#include radiusclip_fragment\n#if defined( PICKING )\n#ifdef USE_MAP\nif( texture2D( map, vec2( gl_PointCoord.x, 1.0 - gl_PointCoord.y ) ).a < 0.5 )\ndiscard;\n#endif\ngl_FragColor = vec4( vPickingColor, objectId );\n#else\nvec3 outgoingLight = vec3( 0.0 );\nvec4 diffuseColor = vec4( diffuse, 1.0 );\n#ifdef USE_MAP\ndiffuseColor *= texture2D( map, vec2( gl_PointCoord.x, 1.0 - gl_PointCoord.y ) );\n#endif\n#include color_fragment\n#include alphatest_fragment\noutgoingLight = diffuseColor.rgb;\ngl_FragColor = vec4( outgoingLight, diffuseColor.a * opacity );\n#include premultiplied_alpha_fragment\n#include tonemapping_fragment\n#include encodings_fragment\n#include fog_fragment\n#endif\n}");var Qb=function(t){function e(e,i){var r=e||{},n=i||{};r.primitiveId||(r.primitiveId=ea(r.position.length/3)),t.call(this,r,n),this.pointSize=Nn(n.pointSize,1),this.sizeAttenuation=Nn(n.sizeAttenuation,!0),this.sortParticles=Nn(n.sortParticles,!1),this.alphaTest=Nn(n.alphaTest,.5),this.useTexture=Nn(n.useTexture,!1),this.forceTransparent=Nn(n.forceTransparent,!1),this.edgeBleach=Nn(n.edgeBleach,0),this.addUniforms({size:{value:this.pointSize},canvasHeight:{value:1},pixelRatio:{value:1},map:{value:null}})}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={parameters:{configurable:!0},isPoint:{configurable:!0},vertexShader:{configurable:!0},fragmentShader:{configurable:!0}};return i.parameters.get=function(){return Object.assign.call(this,{pointSize:{uniform:"size"},sizeAttenuation:{updateShader:!0},sortParticles:{},alphaTest:{updateShader:!0},useTexture:{updateShader:!0},forceTransparent:{},edgeBleach:{uniform:!0}},t.prototype.parameters)},e.prototype.makeMaterial=function(){t.prototype.makeMaterial.call(this),this.makeTexture();var e=this.material,i=this.wireframeMaterial,r=this.pickingMaterial;e.uniforms.map.value=this.tex,e.needsUpdate=!0,i.uniforms.map.value=this.tex,i.needsUpdate=!0,r.uniforms.map.value=this.tex,r.needsUpdate=!0},e.prototype.makeTexture=function(){this.tex&&this.tex.dispose(),this.tex=ac({delta:this.edgeBleach})},e.prototype.getDefines=function(e){var i=t.prototype.getDefines.call(this,e);return this.sizeAttenuation&&(i.USE_SIZEATTENUATION=1),this.useTexture&&(i.USE_MAP=1),this.alphaTest>0&&this.alphaTest<=1&&(i.ALPHATEST=this.alphaTest.toPrecision(2)),i},e.prototype.setUniforms=function(e){e&&void 0!==e.edgeBleach&&(this.makeTexture(),e.map=this.tex),t.prototype.setUniforms.call(this,e)},e.prototype.dispose=function(){t.prototype.dispose.call(this),this.tex&&this.tex.dispose()},i.isPoint.get=function(){return!0},i.vertexShader.get=function(){return"Point.vert"},i.fragmentShader.get=function(){return"Point.frag"},Object.defineProperties(e.prototype,i),e}(Eb),Jb=function(t){function e(e,i,r){t.call(this,e,i,r),this.type="dot",this.parameters=Object.assign({thresholdType:{type:"select",rebuild:!0,options:{value:"value",sigma:"sigma"}},thresholdMin:{type:"number",precision:3,max:1/0,min:-1/0,rebuild:!0},thresholdMax:{type:"number",precision:3,max:1/0,min:-1/0,rebuild:!0},thresholdOut:{type:"boolean",rebuild:!0},dotType:{type:"select",rebuild:!0,options:{"":"",sphere:"sphere",point:"point"}},radiusType:{type:"select",options:{"":"",value:"value","abs-value":"abs-value","value-min":"value-min",deviation:"deviation",size:"size"}},radius:{type:"number",precision:3,max:10,min:.001,property:"size"},scale:{type:"number",precision:3,max:10,min:.001},sphereDetail:!0,disableImpostor:!0,pointSize:{type:"number",precision:1,max:100,min:0,buffer:!0},sizeAttenuation:{type:"boolean",buffer:!0},sortParticles:{type:"boolean",rebuild:!0},useTexture:{type:"boolean",buffer:!0},alphaTest:{type:"range",step:.001,max:1,min:0,buffer:!0},forceTransparent:{type:"boolean",buffer:!0},edgeBleach:{type:"range",step:.001,max:1,min:0,buffer:!0}},this.parameters,{colorScheme:{type:"select",update:"color",options:{"":"",value:"value",uniform:"uniform",random:"random"}}}),e instanceof ky?(this.surface=void 0,this.volume=new Fy(e)):(this.surface=e,this.volume=void 0),this.init(r)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.init=function(e){var i=e||{};i.colorScheme=Nn(i.colorScheme,"uniform"),i.colorValue=Nn(i.colorValue,14540253),this.thresholdType=Nn(i.thresholdType,"sigma"),this.thresholdMin=Nn(i.thresholdMin,2),this.thresholdMax=Nn(i.thresholdMax,1/0),this.thresholdOut=Nn(i.thresholdOut,!1),this.dotType=Nn(i.dotType,"point"),this.radius=Nn(i.radius,.1),this.scale=Nn(i.scale,1),this.pointSize=Nn(i.pointSize,1),this.sizeAttenuation=Nn(i.sizeAttenuation,!0),this.sortParticles=Nn(i.sortParticles,!1),this.useTexture=Nn(i.useTexture,!1),this.alphaTest=Nn(i.alphaTest,.5),this.forceTransparent=Nn(i.forceTransparent,!1),this.edgeBleach=Nn(i.edgeBleach,0),t.prototype.init.call(this,i),this.build()},e.prototype.attach=function(t){var e=this;this.bufferList.forEach(function(t){e.viewer.add(t)}),this.setVisibility(this.visible),t()},e.prototype.create=function(){var t={};if(this.volume){var e,i,r=this.volume;"sigma"===this.thresholdType?(e=r.getValueForSigma(this.thresholdMin),i=r.getValueForSigma(this.thresholdMax)):(e=this.thresholdMin,i=this.thresholdMax),r.setFilter(e,i,this.thresholdOut),t.position=r.getDataPosition(),t.color=r.getDataColor(this.getColorParams()),"sphere"===this.dotType&&(t.radius=r.getDataSize(this.radius,this.scale),t.picking=r.getDataPicking())}else{var n=this.surface;t.position=n.getPosition(),t.color=n.getColor(this.getColorParams()),"sphere"===this.dotType&&(t.radius=n.getSize(this.radius,this.scale),t.picking=n.getPicking())}"sphere"===this.dotType?this.dotBuffer=new Kb(t,this.getBufferParams({sphereDetail:this.sphereDetail,disableImpostor:this.disableImpostor,dullInterior:!1})):this.dotBuffer=new Qb(t,this.getBufferParams({pointSize:this.pointSize,sizeAttenuation:this.sizeAttenuation,sortParticles:this.sortParticles,useTexture:this.useTexture,alphaTest:this.alphaTest,forceTransparent:this.forceTransparent,edgeBleach:this.edgeBleach})),this.bufferList.push(this.dotBuffer)},e.prototype.update=function(t){if(0!==this.bufferList.length){var e={};(t=t||{}).color&&(this.volume?e.color=this.volume.getDataColor(this.getColorParams()):e.color=this.surface.getColor(this.getColorParams())),"sphere"===this.dotType&&(t.radius||t.scale)&&(this.volume?e.radius=this.volume.getDataSize(this.radius,this.scale):e.radius=this.surface.getSize(this.radius,this.scale)),this.dotBuffer.setAttributes(e)}},e.prototype.setParameters=function(e,i,r){return i=i||{},e&&void 0!==e.thresholdType&&this.volume instanceof ky&&("value"===this.thresholdType&&"sigma"===e.thresholdType?(this.thresholdMin=this.volume.getSigmaForValue(this.thresholdMin),this.thresholdMax=this.volume.getSigmaForValue(this.thresholdMax)):"sigma"===this.thresholdType&&"value"===e.thresholdType&&(this.thresholdMin=this.volume.getValueForSigma(this.thresholdMin),this.thresholdMax=this.volume.getValueForSigma(this.thresholdMax)),this.thresholdType=e.thresholdType),e&&void 0!==e.radiusType&&("radius"===e.radiusType?this.radius=.1:this.radius=e.radiusType,i.radius=!0,"sphere"!==this.dotType||gm&&!this.disableImpostor||(r=!0)),e&&void 0!==e.radius&&(i.radius=!0,"sphere"!==this.dotType||gm&&!this.disableImpostor||(r=!0)),e&&void 0!==e.scale&&(i.scale=!0,"sphere"!==this.dotType||gm&&!this.disableImpostor||(r=!0)),t.prototype.setParameters.call(this,e,i,r),this},e}(Db);Mm.add("shader/Image.vert","uniform float clipRadius;\nuniform vec3 clipCenter;\nvarying vec2 vUv;\n#if defined( NEAR_CLIP ) || defined( RADIUS_CLIP ) || !defined( PICKING )\nvarying vec3 vViewPosition;\n#endif\n#if defined( RADIUS_CLIP )\nvarying vec3 vClipCenter;\n#endif\nvoid main() {\n#include begin_vertex\n#include project_vertex\nvUv = uv;\n#if defined( NEAR_CLIP ) || defined( RADIUS_CLIP ) || !defined( PICKING )\nvViewPosition = -mvPosition.xyz;\n#endif\n#if defined( RADIUS_CLIP )\nvClipCenter = -( modelViewMatrix * vec4( clipCenter, 1.0 ) ).xyz;\n#endif\n}"),Mm.add("shader/Image.frag","uniform sampler2D map;\nuniform float opacity;\nuniform vec2 mapSize;\nuniform float nearClip;\nuniform float clipRadius;\nvarying vec2 vUv;\n#if defined( NEAR_CLIP ) || defined( RADIUS_CLIP ) || !defined( PICKING )\nvarying vec3 vViewPosition;\n#endif\n#if defined( RADIUS_CLIP )\nvarying vec3 vClipCenter;\n#endif\n#if defined( PICKING )\nuniform sampler2D pickingMap;\nuniform float objectId;\n#else\n#include fog_pars_fragment\n#endif\n#if defined( CUBIC_INTERPOLATION )\n#if defined( CATMULROM_FILTER ) || defined( MITCHELL_FILTER )\n#if defined( CATMULROM_FILTER )\nconst float B = 0.0;\nconst float C = 0.5;\n#elif defined( MITCHELL_FILTER )\nconst float B = 0.333;\nconst float C = 0.333;\n#endif\nfloat filter( float x ){\nfloat f = x;\nif( f < 0.0 ){\nf = -f;\n}\nif( f < 1.0 ){\nreturn ( ( 12.0 - 9.0 * B - 6.0 * C ) * ( f * f * f ) +\n( -18.0 + 12.0 * B + 6.0 *C ) * ( f * f ) +\n( 6.0 - 2.0 * B ) ) / 6.0;\n}else if( f >= 1.0 && f < 2.0 ){\nreturn ( ( -B - 6.0 * C ) * ( f * f * f )\n+ ( 6.0 * B + 30.0 * C ) * ( f *f ) +\n( - ( 12.0 * B ) - 48.0 * C ) * f +\n8.0 * B + 24.0 * C ) / 6.0;\n}else{\nreturn 0.0;\n}\n}\n#elif defined( BSPLINE_FILTER )\nfloat filter( float x ){\nfloat f = x;\nif( f < 0.0 ){\nf = -f;\n}\nif( f >= 0.0 && f <= 1.0 ){\nreturn ( 2.0 / 3.0 ) + ( 0.5 ) * ( f * f * f ) - ( f * f );\n}else if( f > 1.0 && f <= 2.0 ){\nreturn 1.0 / 6.0 * pow( ( 2.0 - f ), 3.0 );\n}\nreturn 1.0;\n}\n#else\nfloat filter( float x ){\nreturn 1.0;\n}\n#endif\nvec4 biCubic( sampler2D tex, vec2 texCoord ){\nvec2 texelSize = 1.0 / mapSize;\ntexCoord -= texelSize / 2.0;\nvec4 nSum = vec4( 0.0 );\nfloat nDenom = 0.0;\nvec2 cell = fract( texCoord * mapSize );\nfor( float m = -1.0; m <= 2.0; ++m ){\nfor( float n = -1.0; n <= 2.0; ++n ){\nvec4 vecData = texture2D(\ntex, texCoord + texelSize * vec2( m, n )\n);\nfloat c = filter( m - cell.x ) * filter( -n + cell.y );\nnSum += vecData * c;\nnDenom += c;\n}\n}\nreturn nSum / nDenom;\n}\n#endif\nvoid main(){\n#include nearclip_fragment\n#include radiusclip_fragment\n#if defined( CUBIC_INTERPOLATION )\ngl_FragColor = biCubic( map, vUv );\n#else\ngl_FragColor = texture2D( map, vUv );\n#endif\n#if defined( PICKING )\nif( gl_FragColor.a < 0.7 )\ndiscard;\ngl_FragColor = vec4( texture2D( pickingMap, vUv ).xyz, objectId );\n#else\nif( gl_FragColor.a < 0.01 )\ndiscard;\ngl_FragColor.a *= opacity;\n#include fog_fragment\n#endif\n}");var tx=new Uint16Array([0,1,2,1,3,2]),ex=new Float32Array([0,1,0,0,1,1,1,0]),ix=function(t){function e(e,i){var r=e||{},n=i||{};t.call(this,{position:r.position,index:tx,picking:r.picking},n),this.forceTransparent=!0,this.filter=Nn(n.filter,"nearest");var o=new b(r.imageData,r.width,r.height);o.flipY=!0,this.tex=o;for(var a=r.imageData.length,s=new Uint8Array(a),c=0;c<a;c+=4){var u=c/4;s[c]=u>>16&255,s[c+1]=u>>8&255,s[c+2]=255&u}var l=new b(s,r.width,r.height);l.flipY=!0,l.minFilter=Ih,l.magFilter=Ih,this.pickingTex=l,this.addUniforms({map:{value:o},pickingMap:{value:l},mapSize:{value:new h(r.width,r.height)}}),this.geometry.addAttribute("uv",new Pt(ex,2))}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={parameters:{configurable:!0},vertexShader:{configurable:!0},fragmentShader:{configurable:!0}};return i.parameters.get=function(){return Object.assign.call(this,{filter:{updateShader:!0,uniform:!0}},t.prototype.parameters)},e.prototype.getDefines=function(e){var i=t.prototype.getDefines.call(this,e);return this.filter.startsWith("cubic")&&(i.CUBIC_INTERPOLATION=1,this.filter.endsWith("bspline")?i.BSPLINE_FILTER=1:this.filter.endsWith("catmulrom")?i.CATMULROM_FILTER=1:this.filter.endsWith("mitchell")&&(i.MITCHELL_FILTER=1)),i},e.prototype.updateTexture=function(){var t=this.tex;this.filter.startsWith("cubic")?(t.minFilter=Ih,t.magFilter=Ih):"linear"===this.filter?(t.minFilter=Oh,t.magFilter=Oh):(t.minFilter=Ih,t.magFilter=Ih),t.needsUpdate=!0,this.pickingTex.needsUpdate=!0},e.prototype.makeMaterial=function(){t.prototype.makeMaterial.call(this),this.updateTexture();var e=this.material;e.uniforms.map.value=this.tex,e.blending=Bl,e.needsUpdate=!0;var i=this.wireframeMaterial;i.uniforms.map.value=this.tex,i.blending=Bl,i.needsUpdate=!0;var r=this.pickingMaterial;r.uniforms.map.value=this.tex,r.uniforms.pickingMap.value=this.pickingTex,r.blending=Bl,r.needsUpdate=!0},e.prototype.setUniforms=function(e){e&&void 0!==e.filter&&(this.updateTexture(),e.map=this.tex),t.prototype.setUniforms.call(this,e)},i.vertexShader.get=function(){return"Image.vert"},i.fragmentShader.get=function(){return"Image.frag"},Object.defineProperties(e.prototype,i),e}(Eb),rx=function(t,e){var i=e||{};this.dimension=Nn(i.dimension,"x"),this.positionType=Nn(i.positionType,"percent"),this.position=Nn(i.position,30),this.thresholdType=Nn(i.thresholdType,"sigma"),this.thresholdMin=Nn(i.thresholdMin,-1/0),this.thresholdMax=Nn(i.thresholdMax,1/0),this.normalize=Nn(i.normalize,!1),this.volume=t};rx.prototype.getPositionFromCoordinate=function(t){var e,i=this.dimension,r=this.volume,n=r.matrix,o=(new v).setFromMatrixPosition(n)[i],a=(new v).setFromMatrixScale(n)[i];return e="x"===i?r.nx:"y"===i?r.ny:r.nz,Math.round(((t-o)/(e/100)+1)/a)},rx.prototype.getData=function(t){function e(t){return Math.round(t/100*(o-1))}function i(t,e,i,r){return 3*(i*a.ny*a.nx+e*a.nx+t)+r}function r(t,e,i,r){m.set(t,e,i).applyMatrix4(c).toArray(f,r)}var n=this;t=t||{};var o,a=this.volume,s=a.data,c=a.matrix;o="coordinate"===this.positionType?this.getPositionFromCoordinate(this.position):this.position;var u,l,h,p,d,f=new Float32Array(12),m=new v,g=0,y=0,b=0,x=a.nx,_=a.ny,w=a.nz;"x"===this.dimension?(h=e(a.nx),p=a.ny-1,d=a.nz-1,u=a.nz,l=a.ny,x=(g=h)+1,r(h,0,0,0),r(h,p,0,3),r(h,0,d,6),r(h,p,d,9)):"y"===this.dimension?(h=a.nx-1,p=e(a.ny),d=a.nz-1,u=a.nz,l=a.nx,_=(y=p)+1,r(0,p,0,0),r(h,p,0,3),r(0,p,d,6),r(h,p,d,9)):"z"===this.dimension&&(h=a.nx-1,p=a.ny-1,d=e(a.nz),u=a.nx,l=a.ny,w=(b=d)+1,r(0,0,d,0),r(0,p,d,3),r(h,0,d,6),r(h,p,d,9));var S,A,M=0,P=0,E=new Uint8Array(u*l*4),T=new Float32Array(u*l);"sigma"===this.thresholdType?(S=a.getValueForSigma(this.thresholdMin),A=a.getValueForSigma(this.thresholdMax)):(S=this.thresholdMin,A=this.thresholdMax);var C=Object.assign({},t.colorParams,{volume:a});this.normalize&&(C.domain=[0,1]);var I,R,L,O=_m.getScheme(C),D=new Float32Array(3),N=O.getScale();if(this.normalize){I=1/0,R=-1/0;for(var k=y;k<_;++k)for(var B=g;B<x;++B)for(var F=b;F<w;++F){var z=s[i(B,k,F,0)/3];z<I&&(I=z),z>R&&(R=z)}L=R-I}for(var U=y;U<_;++U)for(var j=g;j<x;++j)for(var V=b;V<w;++V){var G=i(j,U,V,0)/3,$=s[G];n.normalize&&($=($-I)/L),O.colorToArray(N($),D),E[M]=Math.round(255*D[0]),E[M+1]=Math.round(255*D[1]),E[M+2]=Math.round(255*D[2]),E[M+3]=$>S&&$<A?255:0,T[P]=G,++P,M+=4}var H=new Kv(T,a);return{position:f,imageData:E,width:u,height:l,picking:H}};var nx=function(t){function e(e,i,r){t.call(this,e,i,r),this.type="slice",this.parameters=Object.assign({filter:{type:"select",buffer:!0,options:{nearest:"nearest",linear:"linear","cubic-bspline":"cubic-bspline","cubic-catmulrom":"cubic-catmulrom","cubic-mitchell":"cubic-mitchell"}},positionType:{type:"select",rebuild:!0,options:{percent:"percent",coordinate:"coordinate"}},position:{type:"range",step:.1,max:100,min:1,rebuild:!0},dimension:{type:"select",rebuild:!0,options:{x:"x",y:"y",z:"z"}},thresholdType:{type:"select",rebuild:!0,options:{value:"value",sigma:"sigma"}},thresholdMin:{type:"number",precision:3,max:1/0,min:-1/0,rebuild:!0},thresholdMax:{type:"number",precision:3,max:1/0,min:-1/0,rebuild:!0},normalize:{type:"boolean",rebuild:!0}},this.parameters,{flatShaded:null,side:null,wireframe:null,linewidth:null,colorScheme:null,roughness:null,metalness:null,diffuse:null}),this.volume=e,this.init(r)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.init=function(e){var i=this.volume,r=e||{};r.colorDomain=Nn(r.colorDomain,[i.min,i.max]),r.colorScheme=Nn(r.colorScheme,"value"),r.colorScale=Nn(r.colorScale,"Spectral"),this.colorScheme="value",this.dimension=Nn(r.dimension,"x"),this.filter=Nn(r.filter,"cubic-bspline"),this.positionType=Nn(r.positionType,"percent"),this.position=Nn(r.position,30),this.thresholdType=Nn(r.thresholdType,"sigma"),this.thresholdMin=Nn(r.thresholdMin,-1/0),this.thresholdMax=Nn(r.thresholdMax,1/0),this.normalize=Nn(r.normalize,!1),t.prototype.init.call(this,r),this.build()},e.prototype.attach=function(t){var e=this;this.bufferList.forEach(function(t){e.viewer.add(t)}),this.setVisibility(this.visible),t()},e.prototype.create=function(){var t=new rx(this.volume,{positionType:this.positionType,position:this.position,dimension:this.dimension,thresholdType:this.thresholdType,thresholdMin:this.thresholdMin,thresholdMax:this.thresholdMax,normalize:this.normalize}),e=new ix(t.getData({colorParams:this.getColorParams()}),this.getBufferParams({filter:this.filter}));this.bufferList.push(e)},e}(Db),ox=function(t){function e(e,i,r){var n=r||{};if(t.call(this,e,i,n),this.type="structure",this.parameters=Object.assign({radiusType:{type:"select",options:Xa.types},radius:{type:"number",precision:3,max:10,min:.001},scale:{type:"number",precision:3,max:10,min:.001},assembly:null,defaultAssembly:{type:"hidden"}},this.parameters),this.selection=new rm(n.sele),this.dataList=[],this.structure=e,this.structureView=this.structure.getView(this.selection),e.biomolDict){var o={default:"default","":e.unitcell?"AU":"FULL"};Object.keys(e.biomolDict).forEach(function(t){o[t]=t}),this.parameters.assembly={type:"select",options:o,rebuild:!0}}else this.parameters.assembly=null}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={defaultScale:{configurable:!0}};return i.defaultScale.get=function(){return{vdw:1,covalent:1,bfactor:.01,sstruc:1}},e.prototype.init=function(e){var i=e||{};i.colorScheme=Nn(i.colorScheme,"element"),this.radius=Nn(i.radius,"vdw"),this.scale=Nn(i.scale,1),this.assembly=Nn(i.assembly,"default"),this.defaultAssembly=Nn(i.defaultAssembly,""),"auto"===i.quality&&(i.quality=this.getQuality()),t.prototype.init.call(this,i),this.selection.signals.stringChanged.add(function(){this.build()},this),this.build()},e.prototype.getAssembly=function(){var t="default"===this.assembly?this.defaultAssembly:this.assembly;return this.structure.biomolDict[t]},e.prototype.getQuality=function(){var t,e=this.structureView,i=this.getAssembly();return t=i?i.getAtomCount(e):e.atomCount,fm&&(t*=4),e.atomStore.count/e.residueStore.count<2&&(t*=10),t<15e3?"high":t<8e4?"medium":"low"},e.prototype.create=function(){if(0!==this.structureView.atomCount)if(this.structureView.hasCoords()){this.needsBuild=!1;var t=this.getAssembly();if(t)t.partList.forEach(function(t,e){var i=t.getView(this.structureView);if(0!==i.atomCount){var r=this.createData(i,e);r&&(r.sview=i,r.instanceList=t.getInstanceList(),this.dataList.push(r))}},this);else{var e=this.createData(this.structureView,0);e&&(e.sview=this.structureView,this.dataList.push(e))}}else this.needsBuild=!0},e.prototype.createData=function(){console.error("createData not implemented")},e.prototype.update=function(t){!this.lazy||this.visible?this.needsBuild?this.build():this.dataList.forEach(function(e){e.bufferList.length>0&&this.updateData(t,e)},this):Object.assign(this.lazyProps.what,t)},e.prototype.updateData=function(){this.build()},e.prototype.getColorParams=function(){var e=t.prototype.getColorParams.call(this);return e.structure=this.structure,e},e.prototype.getAtomParams=function(t,e){return Object.assign({what:t,colorParams:this.getColorParams(),radiusParams:{radius:this.radius,scale:this.scale}},e)},e.prototype.getBondParams=function(t,e){return Object.assign({what:t,colorParams:this.getColorParams(),radiusParams:{radius:this.radius,scale:this.scale}},e)},e.prototype.setSelection=function(t,e){return this.selection.setString(t,e),this},e.prototype.setParameters=function(e,i,r){return i=i||{},e&&void 0!==e.radiusType&&("size"===e.radiusType?this.radius=1:this.radius=e.radiusType,delete e.radiusType,i.radius=!0,gm&&!this.disableImpostor||(r=!0)),e&&void 0!==e.radius&&(i.radius=!0,gm&&!this.disableImpostor||(r=!0)),e&&void 0!==e.scale&&(i.radius=!0,gm&&!this.disableImpostor||(r=!0)),e&&void 0!==e.defaultAssembly&&(r=!0),t.prototype.setParameters.call(this,e,i,r),this},e.prototype.getParameters=function(){return Object.assign(t.prototype.getParameters.call(this),{sele:this.selection?this.selection.string:void 0,defaultAssembly:this.defaultAssembly})},e.prototype.attach=function(t){var e=this.viewer,i=this.bufferList;this.dataList.forEach(function(t){t.bufferList.forEach(function(r){i.push(r),e.add(r,t.instanceList)})}),this.setVisibility(this.visible),t()},e.prototype.clear=function(){this.dataList.length=0,t.prototype.clear.call(this)},e.prototype.dispose=function(){this.structureView.dispose(),delete this.structure,delete this.structureView,t.prototype.dispose.call(this)},Object.defineProperties(e.prototype,i),e}(Db),ax=new v,sx=new v,cx=new v,ux=new v(0,1,0),lx=function(t){function e(e,i){var r=e||{},n=i||{},o=Nn(n.radialSegments,10),a=Nn(n.openEnded,!0),s=(new y).makeRotationX(Math.PI/2),c=new Ri(1,1,1,o,1,a);c.applyMatrix(s);var u=r.position1.length,l=r.radius.length,h=c.attributes.position.array.length/3,p=u/3,d=new Float32Array(2*p*h);ia(p,h,0,d),ia(p,h,p*h,d);var f=new Float32Array(2*u),m=new Float32Array(2*u);t.call(this,{position:f,color:m,primitiveId:d,picking:r.picking},n,c),this.__center=new Float32Array(u),this._position=f,this._color=m,this._from=new Float32Array(2*u),this._to=new Float32Array(2*u),this._radius=new Float32Array(2*l),this.setAttributes(r,!0)}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var i={updateNormals:{configurable:!0}};return e.prototype.applyPositionTransform=function(t,e,i){sx.fromArray(this._from,i),cx.fromArray(this._to,i),t.lookAt(sx,cx,ux);var r=this._radius[e];ax.set(r,r,sx.distanceTo(cx)),t.scale(ax)},e.prototype.setAttributes=function(e,i){var r={};e.position1&&e.position2&&(Ko(e.position1,e.position2,this.__center),Ko(e.position1,this.__center,this._position),Ko(this.__center,e.position2,this._position,e.position1.length),this._from.set(e.position1),this._from.set(this.__center,e.position1.length),this._to.set(this.__center),this._to.set(e.position2,this.__center.length),r.position=this._position),e.color&&e.color2&&(this._color.set(e.color),this._color.set(e.color2,e.color.length),r.color=this._color),e.radius&&(this._radius.set(e.radius),this._radius.set(e.radius,e.radius.length),r.radius=this._radius),t.prototype.setAttributes.call(this,r,i)},i.updateNormals.get=function(){return!0},Object.defineProperties(e.prototype,i),e}(Gb);Mm.add("shader/CylinderImpostor.vert","\nattribute vec3 mapping;\nattribute vec3 position1;\nattribute vec3 position2;\nattribute float radius;\nvarying vec3 axis;\nvarying vec4 base_radius;\nvarying vec4 end_b;\nvarying vec3 U;\nvarying vec3 V;\nvarying vec4 w;\n#ifdef PICKING\n#include unpack_color\nattribute float primitiveId;\nvarying vec3 vPickingColor;\n#else\nattribute vec3 color2;\nvarying vec3 vColor1;\nvarying vec3 vColor2;\n#endif\nuniform mat4 modelViewMatrixInverse;\nuniform float ortho;\n#include matrix_scale\nvoid main(){\n#ifdef PICKING\nvPickingColor = unpackColor( primitiveId );\n#else\nvColor1 = color;\nvColor2 = color2;\n#endif\nbase_radius.w = radius * matrixScale( modelViewMatrix );\nvec3 center = position;\nvec3 dir = normalize( position2 - position1 );\nfloat ext = length( position2 - position1 ) / 2.0;\nvec3 cam_dir;\nif( ortho == 0.0 ){\ncam_dir = ( modelViewMatrixInverse * vec4( 0, 0, 0, 1 ) ).xyz - center;\n}else{\ncam_di