define(["jupyter-js-widgets"], function(__WEBPACK_EXTERNAL_MODULE_2__) { return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;
/******/
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = {};
	
	var loadedModules = [
	    __webpack_require__(1),
	    //require("./ngl.js"),
	]
	
	for (var i in loadedModules) {
	    if (loadedModules.hasOwnProperty(i)) {
	        var loadedModule = loadedModules[i];
	        for (var target_name in loadedModule) {
	            if (loadedModule.hasOwnProperty(target_name)) {
	                module.exports[target_name] = loadedModule[target_name];
	            }
	        }
	    }
	}
	
	module.exports['version'] = __webpack_require__(34).version;


/***/ },
/* 1 */
/***/ function(module, exports, __webpack_require__) {

	var widgets = __webpack_require__(2);
	var NGL = __webpack_require__(3);
	var $ = __webpack_require__(7);
	__webpack_require__(8);
	__webpack_require__(18);
	__webpack_require__(20);
	// require('jquery-ui');
	
	var NGLView = widgets.DOMWidgetView.extend({
	
	    render: function() {
	
	        // init representations handling
	        this.model.on("change:_init_representations", this.representationsChanged, this);
	
	        // init structure loading
	        this.model.on("change:_init_structures_sync", this.structureChanged, this);
	
	        // init setting of frame
	        this.model.on("change:frame", this.frameChanged, this);
	
	        // init setting of frame
	        this.model.on("change:count", this.countChanged, this);
	
	        // init _parameters handling
	        this.model.on("change:_parameters", this.parametersChanged, this);
	
	        // init orientation handling
	        this.model.on("change:orientation", this.orientationChanged, this);
	
	        // for player
	        this.delay = 100;
	        this.sync_frame = false;
	        this.sync_camera = false;
	
	        // get message from Python
	        this.model.on("msg:custom", function(msg) {
	            this.on_msg(msg);
	        }, this);
	
	        if (this.model.comm) {
	            // for embeding in website
	            this.model.comm.on_msg(function(msg) {
	                var buffers = msg.buffers;
	                var content = msg.content.data.content;
	                if (buffers.length && content) {
	                    content.buffers = buffers;
	                }
	                this.model._handle_comm_msg.call(this.model, msg);
	            }.bind(this));
	        }
	
	        // init NGL stage
	        NGL.useWorker = false;
	        this.stage = new NGL.Stage(undefined, {
	            backgroundColor: "white"
	        });
	        this.structureComponent = undefined;
	        this.$container = $(this.stage.viewer.container);
	        this.$el.append(this.$container);
	        this.$container.resizable({
	            resize: function(event, ui) {
	                this.setSize(ui.size.width + "px", ui.size.height + "px");
	            }.bind(this)
	        });
	        this.displayed.then(function() {
	            var width = this.$el.parent().width() + "px";
	            var height = "300px";
	
	            this.setSize(width, height);
	            this.$container.resizable(
	                "option", "maxWidth", this.$el.parent().width()
	            );
	            this.requestUpdateStageParameters();
	        }.bind(this));
	
	        this.stage.viewer.controls.addEventListener("change", function() {
	            if (this.sync_camera) {
	                this.model.set('camera_str', JSON.stringify(this.stage.viewer.camera));
	                this.model.set('orientation', this.stage.viewer.getOrientation());
	                this.touch();
	            }
	        }.bind(this));
	
	        // init toggle fullscreen
	        $(this.stage.viewer.container).dblclick(function() {
	            this.stage.toggleFullscreen();
	        }.bind(this));
	
	        // init model data
	        this.structureChanged();
	
	        // init picking handling
	        this.$pickingInfo = $("<div></div>")
	            .css("position", "absolute")
	            .css("top", "5%")
	            .css("left", "3%")
	            .css("background-color", "white")
	            .css("padding", "2px 5px 2px 5px")
	            .css("opacity", "0.7")
	            .appendTo(this.$container);
	
	        $inputNotebookCommand = $('<input id="input_notebook_command" type="text"></input>');
	        var that = this;
	
	        $inputNotebookCommand.keypress(function(e) {
	            var command = $("#input_notebook_command").val();
	            if (e.which == 13) {
	                $("#input_notebook_command").val("")
	                Jupyter.notebook.kernel.execute(command);
	            }
	        });
	
	        this.$notebook_text = $("<div></div>")
	            .css("position", "absolute")
	            .css("bottom", "5%")
	            .css("left", "3%")
	            .css("padding", "2px 5px 2px 5px")
	            .css("opacity", "0.7")
	            .append($inputNotebookCommand)
	            .appendTo(this.$container);
	        this.$notebook_text.hide();
	
	        this.stage.signals.clicked.add(function(pd) {
	            var pd2 = {};
	            if (pd.atom) pd2.atom = pd.atom.toObject();
	            if (pd.bond) pd2.bond = pd.bond.toObject();
	            if (pd.instance) pd2.instance = pd.instance;
	            this.model.set("picked", pd2);
	            this.touch();
	            var pickingText = "";
	            if (pd.atom) {
	                pickingText = "Atom: " + pd.atom.qualifiedName();
	            } else if (pd.bond) {
	                pickingText = "Bond: " + pd.bond.atom1.qualifiedName() + " - " + pd.bond.atom2.qualifiedName();
	            }
	            this.$pickingInfo.text(pickingText);
	        }, this);
	
	        this.initPlayer();
	
	        var container = this.stage.viewer.container;
	        var that = this;
	        container.addEventListener('dragover', function(e) {
	            e.stopPropagation();
	            e.preventDefault();
	            e.dataTransfer.dropEffect = 'copy';
	        }, false);
	
	        container.addEventListener('drop', function(e) {
	            e.stopPropagation();
	            e.preventDefault();
	            var file = e.dataTransfer.files[0];
	
	            that.stage.loadFile(file).then(function(o){
	                that.makeDefaultRepr(o);
	                that._handle_loading_file_finished();
	            });
	            var numDroppedFiles = that.model.get("_n_dragged_files");
	            that.model.set("_n_dragged_files", numDroppedFiles + 1);
	            that.touch();
	        }, false);
	
	        var that = this;
	        this.stage.signals.componentAdded.add(function() {
	            var len = this.stage.compList.length;
	            this.model.set("n_components", len);
	            this.touch();
	            var comp = this.stage.compList[len - 1];
	            comp.signals.representationRemoved.add(function() {
	                that.requestReprsInfo();
	            });
	            comp.signals.representationAdded.add(function() {
	                that.requestReprsInfo();
	            });
	        }, this);
	
	        this.stage.signals.componentRemoved.add(function() {
	            this.model.set("n_components", this.stage.compList.length);
	            this.touch();
	        }, this);
	
	        // for callbacks from Python
	        // must be after initializing NGL.Stage
	        this.model.send({
	            'type': 'request_loaded',
	            'data': true
	        })
	        var state_params = this.stage.getParameters();
	        this.model.set('_original_stage_parameters', state_params);
	        this.touch();
	    },
	
	    setSelector: function(selector_id) {
	        // id is uuid that will be set from Python
	        var selector = "<div class='" + selector_id + "'></div>";
	        console.log('selector', selector);
	        this.$ngl_selector = $(selector)
	            .css("position", "absolute")
	            .css("bottom", "5%")
	            .css("left", "3%")
	            .css("padding", "2px 5px 2px 5px")
	            .css("opacity", "0.7")
	            .appendTo(this.$container);
	    },
	
	    setIPythonLikeCell: function() {
	        var cell = Jupyter.notebook.insert_cell_at_bottom();
	
	        var handler = function(event) {
	            var selected_cell = Jupyter.notebook.get_selected_cell();
	            if (selected_cell.cell_id === cell.cell_id) {
	                selected_cell.execute();
	                selected_cell.set_text('');
	            }
	            return false;
	        };
	
	        var action = {
	            help: 'run cell',
	            help_index: 'zz',
	            handler: handler
	        };
	
	        Jupyter.keyboard_manager.edit_shortcuts.add_shortcut('enter', action);
	    },
	
	    hideNotebookCommandBox: function() {
	        this.$notebook_text.hide();
	    },
	
	    showNotebookCommandBox: function() {
	        this.$notebook_text.show();
	    },
	
	    requestFrame: function() {
	        this.send({
	            'type': 'request_frame',
	            'data': 'frame'
	        });
	    },
	
	    requestUpdateStageParameters: function() {
	        var updated_params = this.stage.getParameters();
	        this.model.set('_full_stage_parameters', updated_params);
	        this.touch();
	    },
	
	    requestReprParameters: function(component_index, repr_index) {
	        var comp = this.stage.compList[component_index];
	        var repr = comp.reprList[repr_index];
	        var msg = repr.repr.getParameters();
	
	        if (msg) {
	            msg['name'] = repr.name;
	            this.send({
	                'type': 'repr_parameters',
	                'data': msg
	            });
	        }
	    },
	
	    requestReprsInfo: function() {
	        var n_components = this.stage.compList.length;
	        var msg = {};
	
	        for (var i = 0; i < n_components; i++) {
	            var comp = this.stage.compList[i];
	            msg['c' + i] = {};
	            var msgi = msg['c' + i];
	            for (var j = 0; j < comp.reprList.length; j++) {
	                var repr = comp.reprList[j];
	                msgi[j] = {};
	                msgi[j]['name'] = repr.name;
	                msgi[j]['parameters'] = repr.repr.getParameters();
	            }
	        }
	        this.send({
	            'type': 'all_reprs_info',
	            'data': msg
	        });
	    },
	
	    // setDraggable: function(params) {
	    //     if (params) {
	    //         this.$container.draggable(params);
	    //     } else {
	    //         this.$container.draggable();
	    //     }
	    // },
	    setDelay: function(delay) {
	        this.delay = delay;
	    },
	
	    setSyncFrame: function() {
	        this.sync_frame = true;
	    },
	
	    setUnSyncFrame: function() {
	        this.sync_frame = false;
	    },
	
	    setSyncCamera: function() {
	        this.sync_camera = true;
	    },
	
	    setUnSyncCamera: function() {
	        this.sync_camera = false;
	    },
	
	    makeDefaultRepr: function(o) {
	        var reprDefList = this.model.get("_init_representations");
	        reprDefList.forEach(function(reprDef) {
	            o.addRepresentation(reprDef.type, reprDef.params);
	        });
	
	        if (this.stage.compList.length < 2) {
	            o.centerView();
	        }
	    },
	
	
	    initPlayer: function() {
	        // init player
	        if (this.model.get("count")) {
	            var play = function() {
	                this.$playerButton.text("pause");
	                this.playerInterval = setInterval(function() {
	                    var frame = this.model.get("frame") + 1;
	                    var count = this.model.get("count");
	                    if (frame >= count) frame = 0;
	
	                    if (this.sync_frame) {
	                        this.model.set("frame", frame);
	                        this.touch();
	                    } else {
	                        this.requestFrame();
	                    }
	                }.bind(this), this.delay);
	            }.bind(this);
	            var pause = function() {
	                this.$playerButton.text("play");
	                if (this.playerInterval !== undefined) {
	                    clearInterval(this.playerInterval);
	                }
	            }.bind(this);
	            this.$playerButton = $("<button>play</button>")
	                .css("float", "left")
	                .css("width", "55px")
	                .css("opacity", "0.7")
	                .click(function(event) {
	                    if (this.$playerButton.text() === "play") {
	                        play();
	                    } else if (this.$playerButton.text() === "pause") {
	                        pause();
	                    }
	                }.bind(this));
	            this.$playerSlider = $("<div></div>")
	                .css("margin-left", "70px")
	                .css("position", "relative")
	                .css("bottom", "-7px")
	                .slider({
	                    min: 0,
	                    max: this.model.get("count") - 1,
	                    slide: function(event, ui) {
	                        pause();
	                        this.model.set("frame", ui.value);
	                        this.touch();
	                    }.bind(this)
	                });
	            this.$player = $("<div></div>")
	                .css("position", "absolute")
	                .css("bottom", "5%")
	                .css("width", "94%")
	                .css("margin-left", "3%")
	                .css("opacity", "0.7")
	                .append(this.$playerButton)
	                .append(this.$playerSlider)
	                .appendTo(this.$container);
	            this.model.on("change:frame", function() {
	                this.$playerSlider.slider("value", this.model.get("frame"));
	            }, this);
	
	            if (this.model.get("count") < 2) {
	                this.$player.hide()
	            };
	        }
	    },
	
	    countChanged: function() {
	        var count = this.model.get("count");
	        this.$playerSlider.slider({
	            max: count - 1
	        });
	        if (this.model.get("count") > 1) {
	            this.$player.show()
	        };
	    },
	
	    representationsChanged: function() {
	        var representations = this.model.get("_init_representations");
	
	        for (var i = 0; i < this.stage.compList.length; i++) {
	            component = this.stage.compList[i];
	            if (representations && component) {
	                component.clearRepresentations();
	                representations.forEach(function(repr) {
	                    component.addRepresentation(repr.type, repr.params);
	                });
	            }
	        }
	    },
	
	    setVisibilityForRepr: function(component_index, repr_index, value) {
	        // value = True/False
	        var component = this.stage.compList[component_index];
	        var repr = component.reprList[repr_index];
	
	        if (repr) {
	            repr.setVisibility(value);
	        }
	    },
	
	    removeRepresentation: function(component_index, repr_index) {
	        var component = this.stage.compList[component_index];
	        var repr = component.reprList[repr_index]
	
	        if (repr) {
	            component.removeRepresentation(repr);
	            repr.dispose();
	        }
	    },
	
	    removeRepresentationsByName: function(repr_name, component_index) {
	        var component = this.stage.compList[component_index];
	
	        if (component) {
	            component.reprList.forEach(function(repr) {
	                if (repr.name == repr_name) {
	                    component.removeRepresentation(repr);
	                    repr.dispose();
	                }
	            })
	        }
	    },
	
	    updateRepresentationForComponent: function(repr_index, component_index, params) {
	        var component = this.stage.compList[component_index];
	        var repr = component.reprList[repr_index];
	        if (repr) {
	            repr.setParameters(params);
	        }
	    },
	
	    updateRepresentationsByName: function(repr_name, component_index, params) {
	        var component = this.stage.compList[component_index];
	
	        if (component) {
	            component.reprList.forEach(function(repr) {
	                if (repr.name == repr_name) {
	                    repr.setParameters(params);
	                }
	            })
	        }
	    },
	
	    setRepresentation: function(name, params, component_index, repr_index) {
	        var component = this.stage.compList[component_index];
	        var repr = component.reprList[repr_index];
	
	        if (repr) {
	            params['useWorker'] = false;
	            var new_repr = NGL.makeRepresentation(name, component.structure,
	                this.stage.viewer, params);
	            if (new_repr) {
	                repr.setRepresentation(new_repr);
	                repr.name = name;
	                component.reprList[repr_index] = repr;
	                this.requestReprsInfo();
	            }
	        }
	    },
	
	    setColorByResidue: function(colors, component_index, repr_index){
	        var repr = this.stage.compList[component_index].reprList[repr_index];
	        var schemeId = NGL.ColorMakerRegistry.addScheme(function(params){
	            this.atomColor = function(atom){
	                 var color = colors[atom.residueIndex];
	                 return color
	            };
	        });
	        repr.setColor(schemeId);
	    },
	
	    addShape: function(name, shapes) {
	        // shapes: list of tuple
	        // e.g: [('sphere', ...), ('cone', ...)]
	        var shape = new NGL.Shape(name);
	        var shape_dict = {
	            'sphere': shape.addSphere,
	            'ellipsoid': shape.addEllipsoid,
	            'cylinder': shape.addCylinder,
	            'cone': shape.addCone,
	            'mesh': shape.addMesh,
	            'arrow': shape.addArrow
	        };
	        for (var i = 0; i < shapes.length; i++) {
	            var shapes_i = shapes[i]
	            var shape_type = shapes_i[0];
	            var params = shapes_i.slice(1, shapes_i.length);
	            // e.g params = ('sphere', [ 0, 0, 9 ], [ 1, 0, 0 ], 1.5)
	
	            var func = shape_dict[shape_type];
	            func.apply(this, params);
	        }
	        var shapeComp = this.stage.addComponentFromObject(shape);
	        shapeComp.addRepresentation("buffer");
	    },
	
	    structureChanged: function() {
	        if (!this.model.get("loaded")) {
	            var structureList = this.model.get("_init_structures_sync");
	            for (var i = 0; i < Object.keys(structureList).length; i++) {
	                var structure = structureList[i];
	                if (structure.data && structure.ext) {
	                    var blob = new Blob([structure.data], {
	                        type: "text/plain"
	                    });
	                    var params = structure.params || {};
	                    params.ext = structure.ext;
	                    params.defaultRepresentation = false;
	                    var that = this;
	                    this.stage.loadFile(blob, params).then(function(component) {
	                        component.centerView();
	                        // this.structureComponent = component;
	                        this.representationsChanged();
	
	                        // for small peptide
	                        if (component.structure) {
	                            var structure = component.structure;
	                            if (structure.biomolDict.BU1) {
	                                var assembly = structure.biomolDict.BU1;
	                                atomCount = assembly.getAtomCount(structure);
	                                instanceCount = assembly.getInstanceCount();
	                            } else {
	                                atomCount = structure.getModelProxy(0).atomCount;
	                            }
	
	                            if (atomCount < 50) {
	                                // why 50? arbitrary number
	                                component.addRepresentation('licorice');
	                            }
	                        }
	                        that._handle_loading_file_finished();
	                    }.bind(this));
	                }
	            }
	            // only use _init_structures_sync before Widget is loaded.
	        }
	    },
	
	    superpose: function(cindex0, cindex1, align, sele0, sele1) {
	        // superpose two components with given params
	        var component0 = this.stage.compList[cindex0];
	        var component1 = this.stage.compList[cindex1];
	        component1.superpose(component0, align, sele0, sele1);
	    },
	
	    decode_base64: function(base64) {
	        // lightly adapted from Niklas
	
	        /*
	         * base64-arraybuffer
	         * https://github.com/niklasvh/base64-arraybuffer
	         *
	         * Copyright (c) 2012 Niklas von Hertzen
	         * Licensed under the MIT license.
	         */
	        var chars =
	            "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
	        var bufferLength = base64.length * 0.75,
	            len = base64.length,
	            i, p = 0,
	            encoded1, encoded2, encoded3, encoded4;
	
	        if (base64[base64.length - 1] === "=") {
	            bufferLength--;
	            if (base64[base64.length - 2] === "=") {
	                bufferLength--;
	            }
	        }
	
	        var arraybuffer = new ArrayBuffer(bufferLength),
	            bytes = new Uint8Array(arraybuffer);
	
	        for (i = 0; i < len; i += 4) {
	            encoded1 = chars.indexOf(base64[i]);
	            encoded2 = chars.indexOf(base64[i + 1]);
	            encoded3 = chars.indexOf(base64[i + 2]);
	            encoded4 = chars.indexOf(base64[i + 3]);
	
	            bytes[p++] = (encoded1 << 2) | (encoded2 >> 4);
	            bytes[p++] = ((encoded2 & 15) << 4) | (encoded3 >> 2);
	            bytes[p++] = ((encoded3 & 3) << 6) | (encoded4 & 63);
	        }
	
	        return arraybuffer;
	    },
	
	    updateCoordinates: function(coordinates, model) {
	        // coordinates must be ArrayBuffer (use this.decode_base64)
	        var component = this.stage.compList[model];
	        if (coordinates && component) {
	            var coords = new Float32Array(coordinates);
	            component.structure.updatePosition(coords);
	            component.updateRepresentations({
	                "position": true
	            });
	        }
	    },
	
	    handleResize: function() {
	        this.$container.resizable({
	            resize: function(event, ui) {
	                this.setSize(ui.size.width + "px", ui.size.height + "px");
	            }.bind(this)
	        })
	    },
	
	    setSize: function(width, height) {
	        this.stage.viewer.container.style.width = width;
	        this.stage.viewer.container.style.height = height;
	        this.stage.handleResize();
	    },
	
	    openNotebookCommandDialog: function() {
	        var that = this;
	        dialog = this.$notebook_text.dialog({
	            draggable: true,
	            resizable: true,
	            modal: false,
	            show: {
	                effect: "blind",
	                duration: 150
	            },
	            close: function(event, ui) {
	                that.$container.append(that.$notebook_text);
	                that.$notebook_text.dialog('destroy');
	            },
	        });
	        dialog.css({
	            overflow: 'hidden'
	        });
	        dialog.prev('.ui-dialog-titlebar')
	            .css({
	                'background': 'transparent',
	                'border': 'none'
	            });
	        Jupyter.keyboard_manager.register_events(dialog);
	    },
	
	    setDialog: function() {
	        var $nb_container = Jupyter.notebook.container;
	        var that = this;
	        dialog = this.$container.dialog({
	            title: "NGLView",
	            draggable: true,
	            resizable: true,
	            modal: false,
	            width: window.innerWidth - $nb_container.width() - $nb_container.offset().left - 50,
	            height: 'auto',
	            position: {
	                my: 'right',
	                at: 'right',
	                of: window
	            },
	            show: {
	                effect: "blind",
	                duration: 150
	            },
	            close: function(event, ui) {
	                that.$el.append(that.$container);
	                that.$container.dialog('destroy');
	                that.handleResize();
	            },
	            resize: function(event, ui) {
	                that.stage.handleResize();
	                that.setSize(ui.size.width + "px", ui.size.height + "px");
	            }.bind(that),
	        });
	        dialog.css({
	            overflow: 'hidden'
	        });
	        dialog.prev('.ui-dialog-titlebar')
	            .css({
	                'background': 'transparent',
	                'border': 'none'
	            });
	    },
	
	    resizeNotebook: function(width) {
	        var $nb_container = Jupyter.notebook.container;
	        $nb_container.width(width);
	
	        if (this.$container.dialog) {
	            this.$container.dialog({
	                width: $nb_container.offset().left
	            });
	        }
	    },
	
	    parametersChanged: function() {
	        var _parameters = this.model.get("_parameters");
	        this.setParameters(_parameters);
	    },
	
	    setParameters: function(parameters) {
	        this.stage.setParameters(parameters);
	
	        // do not set _full_stage_parameters here
	        // or parameters will be never updated (not sure why) 
	        // use observe in python side
	        var updated_params = this.stage.getParameters();
	        this.send({
	            'type': 'stage_parameters',
	            'data': updated_params
	        })
	    },
	
	    orientationChanged: function() {
	        var orientation = this.model.get("orientation");
	        this.stage.viewer.setOrientation(orientation);
	    },
	
	    _downloadImage: function(filename, params) {
	        this.stage.makeImage(params).then(function(blob) {
	            NGL.download(blob, filename);
	        })
	    },
	
	    _exportImage: function(params) {
	        this.stage.makeImage(params).then(function(blob) {
	            var reader = new FileReader();
	            var arr_str;
	            reader.onload = function() {
	                arr_str = reader.result.replace("data:image/png;base64,", "");
	                this.model.set("_image_data", arr_str);
	                this.touch();
	            }.bind(this);
	            reader.readAsDataURL(blob);
	        }.bind(this));
	    },
	
	    cleanOutput: function() {
	
	        var cells = Jupyter.notebook.get_cells();
	
	        for (var i = 0; i < cells.length; i++) {
	            var cell = cells[i];
	            if (cell.output_area.outputs.length > 0) {
	                var out = cell.output_area.outputs[0];
	                if (out.output_type == 'display_data') {
	                    cell.clear_output();
	                }
	            }
	        }
	    },
	
	    _handle_loading_file_finished: function() {
	        this.send({'type': 'async_message', 'data': 'ok'});
	    },
	
	    on_msg: function(msg) {
	        // TODO: re-organize
	        if (msg.type == 'call_method') {
	            var new_args = msg.args.slice();
	            new_args.push(msg.kwargs);
	
	            switch (msg.target) {
	                case 'Stage':
	                    var stage_func = this.stage[msg.methodName];
	                    var stage = this.stage;
	                    if (msg.methodName == 'screenshot') {
	                        NGL.screenshot(this.stage.viewer, msg.kwargs);
	                    } else if (msg.methodName == 'removeComponent') {
	                        var index = msg.args[0];
	                        var component = this.stage.compList[index];
	                        this.stage.removeComponent(component);
	                    } else {
	                        if (msg.methodName == 'loadFile') {
	                            // args = [{'type': ..., 'data': ...}]
	                            var args0 = msg.args[0];
	                            var that = this;
	                            if (args0.type == 'blob') {
	                                var blob;
	                                if (args0.binary) {
	                                    var decoded_data = this.decode_base64(args0.data);
	                                    blob = new Blob([decoded_data], {
	                                        type: "application/octet-binary"
	                                    });
	                                } else {
	                                    blob = new Blob([args0.data], {
	                                        type: "text/plain"
	                                    });
	                                }
	                                this.stage.loadFile(blob, msg.kwargs).then(function(o){
	                                     that._handle_loading_file_finished();
	                                });
	                            } else {
	                                this.stage.loadFile(msg.args[0].data, msg.kwargs).then(function(o){
	                                     that._handle_loading_file_finished();
	                                });
	                            }
	                        } else {
	                            stage_func.apply(stage, new_args);
	                        }
	                    }
	                    break;
	                case 'Viewer':
	                    var viewer = this.stage.viewer;
	                    var func = this.stage.viewer[msg.methodName];
	                    func.apply(viewer, new_args);
	                    break;
	                case 'compList':
	                    var index = msg['component_index'];
	                    var component = this.stage.compList[index];
	                    var func = component[msg.methodName];
	                    func.apply(component, new_args);
	                    break;
	                case 'StructureComponent':
	                    var component = this.structureComponent;
	                    var func = component[msg.methodName];
	                    func.apply(component, new_args);
	                    break;
	                case 'Widget':
	                    var func = this[msg.methodName];
	                    if (func) {
	                        func.apply(this, new_args);
	                    } else {
	                        console.log('can not create func for ' + msg.methodName);
	                    }
	                    break;
	                case 'Representation':
	                    var component_index = msg['component_index'];
	                    var repr_index = msg['repr_index'];
	                    var component = this.stage.compList[component_index];
	                    var repr = component.reprList[repr_index];
	                    var func = repr[msg.methodName];
	                    if (repr && func) {
	                        func.apply(repr, new_args);
	                    }
	                    break;
	                default:
	                    console.log('there is no method for ' + msg.target);
	                    break;
	            }
	        } else if (msg.type == 'base64_single') {
	            // TODO: remove time
	            var time0 = Date.now();
	
	            var coordinatesDict = msg.data;
	            var keys = Object.keys(coordinatesDict);
	
	            for (var i = 0; i < keys.length; i++) {
	                var traj_index = keys[i];
	                var coordinates = this.decode_base64(coordinatesDict[traj_index]);
	                if (coordinates.byteLength > 0) {
	                    this.updateCoordinates(coordinates, traj_index);
	                }
	            }
	            var time1 = Date.now();
	        } else if (msg.type == 'binary_single') {
	            // TODO: remove time
	            var time0 = Date.now();
	
	            var coordinateMeta = msg.data;
	            var keys = Object.keys(coordinateMeta);
	
	            for (var i = 0; i < keys.length; i++) {
	                var traj_index = keys[i];
	                var coordinates = new Float32Array(msg.buffers[i].buffer);
	                if (coordinates.byteLength > 0) {
	                    this.updateCoordinates(coordinates, traj_index);
	                }
	            }
	            var time1 = Date.now();
	        } else if (msg.type == 'get') {
	            if (msg.data == 'camera') {
	                this.send(JSON.stringify(this.stage.viewer.camera));
	            } else if (msg.data == 'parameters') {
	                this.send(JSON.stringify(this.stage.parameters));
	            } else {
	                for (var i = 0; i < this.stage.compList.length; i++) {
	                    console.log(this.stage.compList[i]);
	                }
	            }
	        }
	    },
	});
	
	var NGLBox = widgets.BoxView.extend({
	    initialize: function(parameters) {
	        widgets.BoxView.prototype.initialize.call(this, parameters);
	        this.$dialog = undefined;
	    },
	
	    render: function() {
	        this.model.on('change:_dialog', this.dialogCommandChanged, this);
	        this.model.on('change:_ngl_command', this.commandChanged, this);
	        widgets.BoxView.prototype.render.call(this);
	    },
	
	    dialogCommandChanged: function() {
	        var _dialog = this.model.get('_dialog');
	        if (_dialog == 'on') {
	            this.setDialog();
	        }
	    },
	
	    merge: function() {
	        // TODO: rename and add doc
	        console.log('calling merge');
	        var v0 = this.children_views.views[0];
	        var v1 = this.children_views.views[1];
	
	        v0.then(function(v00) {
	            v1.then(function(v11) {
	                v11.$el.appendTo(v00.$container)
	                    .css("position", "absolute")
	                    .css("bottom", "5%")
	                    .css("left", "3%")
	                    .css("padding", "2px 5px 2px 5px")
	            });
	        });
	    },
	
	    commandChanged: function() {
	        var cm = this.model.get('_ngl_command');
	        if (cm == 'merge') {
	            this.merge();
	        } else {
	            console.log("place holder");
	        }
	    },
	
	    setDialog: function() {
	        //var $node = $(this.$el.parent()[0]);
	        var $node = $(this.$el);
	        $node.addClass('jupyter-widgets');
	        $node.addClass('widget-container');
	        $node.addClass('widget-box');
	        var that = this;
	        dialog = $node.dialog({
	            draggable: true,
	            resizable: true,
	            modal: false,
	            height: 'auto',
	            show: {
	                effect: "blind",
	                duration: 150
	            },
	        });
	        dialog.css({
	            overflow: 'hidden'
	        });
	        dialog.prev('.ui-dialog-titlebar')
	            .css({
	                'background': 'transparent',
	                'border': 'none'
	            });
	    },
	});
	
	module.exports = {
	    'NGLView': NGLView,
	    'NGL': NGL,
	    'NGLBox': NGLBox
	};


/***/ },
/* 2 */
/***/ function(module, exports) {

	module.exports = __WEBPACK_EXTERNAL_MODULE_2__;

/***/ },
/* 3 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(setImmediate) {!function(t,e){ true?e(exports):"function"==typeof define&&define.amd?define(["exports"],e):e(t.NGL=t.NGL||{})}(this,function(t){"use strict";function e(){}function i(t,e){return function(){t.apply(e,arguments)}}function n(t){if("object"!=typeof this)throw new TypeError("Promises must be constructed via new");if("function"!=typeof t)throw new TypeError("not a function");this._state=0,this._handled=!1,this._value=void 0,this._deferreds=[],u(t,this)}function r(t,e){for(;3===t._state;)t=t._value;return 0===t._state?void t._deferreds.push(e):(t._handled=!0,void Qu(function(){var i=1===t._state?e.onFulfilled:e.onRejected;if(null===i)return void(1===t._state?o:a)(e.promise,t._value);var n;try{n=i(t._value)}catch(t){return void a(e.promise,t)}o(e.promise,n)}))}function o(t,e){try{if(e===t)throw new TypeError("A promise cannot be resolved with itself.");if(e&&("object"==typeof e||"function"==typeof e)){var r=e.then;if(e instanceof n)return t._state=3,t._value=e,void s(t);if("function"==typeof r)return void u(i(r,e),t)}t._state=1,t._value=e,s(t)}catch(e){a(t,e)}}function a(t,e){t._state=2,t._value=e,s(t)}function s(t){2===t._state&&0===t._deferreds.length&&Qu(function(){t._handled||Ju(t._value)});for(var e=0,i=t._deferreds.length;e<i;e++)r(t,t._deferreds[e]);t._deferreds=null}function c(t,e,i){this.onFulfilled="function"==typeof t?t:null,this.onRejected="function"==typeof e?e:null,this.promise=i}function u(t,e){var i=!1;try{t(function(t){i||(i=!0,o(e,t))},function(t){i||(i=!0,a(e,t))})}catch(t){if(i)return;i=!0,a(e,t)}}function h(t){if("undefined"!=typeof window){var e=new RegExp(t+"=([^&#=]*)"),i=e.exec(window.location.search);return i?decodeURIComponent(i[1]):void 0}}function l(t){return!!t&&("string"!=typeof t||/^1|true|t|yes|y$/i.test(t))}function d(t,e){return void 0!==t?t:e}function f(){var t=window.location.protocol;return null===t.match(/http(s)?:/gi)?"http:":t}function p(){if("undefined"==typeof window)return!1;var t=window.navigator.userAgent;return/Opera|OPR/.test(t)?"Opera":/Chrome/i.test(t)?"Chrome":/Firefox/i.test(t)?"Firefox":/Mobile(\/.*)? Safari/i.test(t)?"Mobile Safari":/MSIE/i.test(t)?"Internet Explorer":!!/Safari/i.test(t)&&"Safari"}function m(t){var e=window.location,i=e.pathname,n=i.substring(0,i.lastIndexOf("/")+1);return e.origin+n+t}function g(t){if("object"!=typeof t)return t;var e=Array.isArray(t)?[]:{};for(var i in t)e[i]=g(t[i]);return e}function v(t,e){function i(t){var e=window.open(t,"_blank");e||(window.location.href=t)}function n(t){i(o?t:t.replace(/^data:[^;]*;/,"data:attachment/file;"))}if(t){e=e||"download";var r="Safari"===p(),o=/CriOS\/[\d]+/.test(window.navigator.userAgent),a=document.createElement("a");if("undefined"!=typeof navigator&&navigator.msSaveOrOpenBlob)navigator.msSaveOrOpenBlob(t,e);else if((r||o)&&window.FileReader)if(t instanceof Blob){var s=new FileReader;s.onloadend=function(){n(s.result)},s.readAsDataURL(t)}else n(t);else t instanceof Blob&&(t=URL.createObjectURL(t)),"download"in a?(a.style.display="hidden",document.body.appendChild(a),a.href=t,a.download=e,a.target="_blank",a.click(),document.body.removeChild(a)):i(t),t instanceof Blob&&URL.revokeObjectURL(t)}}function y(t){var e,i,n,r=["gz"];e="undefined"!=typeof File&&t instanceof File||"undefined"!=typeof Blob&&t instanceof Blob?t.name||"":t;var o=e.lastIndexOf("?");e=e.substring(0,o===-1?e.length:o);var a=e.replace(/^.*[\\\/]/,""),s=a.substring(0,a.lastIndexOf(".")),c=a.split("."),u=c.length>1?c.pop().toLowerCase():"",h=e.match(/^(.+):\/\/(.+)$/);h&&(n=h[1].toLowerCase(),e=h[2]);var l=e.substring(0,e.lastIndexOf("/")+1);if(r.includes(u)){i=u;var d=e.length-u.length-1;u=e.substr(0,d).split(".").pop().toLowerCase();var f=s.length-u.length-1;s=s.substr(0,f)}else i=!1;return{path:e,name:a,ext:u,base:s,dir:l,compressed:i,protocol:n,src:t}}function b(t,e,i){var n,r,o,a=null,s=0;i||(i={});var c=function(){s=i.leading===!1?0:Date.now(),a=null,o=t.apply(n,r),a||(n=r=null)};return function(){var u=Date.now();s||i.leading!==!1||(s=u);var h=e-(u-s);return n=this,r=arguments,h<=0||h>e?(a&&(clearTimeout(a),a=null),s=u,o=t.apply(n,r),a||(n=r=null)):a||i.trailing===!1||(a=setTimeout(c,h)),o}}function x(t){return t.sort().filter(function(t,e,i){return 0===e||t!==i[e-1]})}function _(t){var e=28672;if(t.length>e){for(var i=[],n=0;n<t.length;n+=e)i.push(String.fromCharCode.apply(null,t.subarray(n,n+e)));return i.join("")}return String.fromCharCode.apply(null,t)}function w(t,e,i){e=void 0!==e?e:10485760,i=void 0!==i?i:"\n";for(var n="",r=[],o=0;o<t.length;o+=e){var a=_(t.subarray(o,o+e)),s=a.lastIndexOf(i);if(s===-1)n+=a;else{var c=n+a.substr(0,s);r=r.concat(c.split(i)),n=s===a.length-i.length?"":a.substr(s+i.length)}}return""!==n&&r.push(n),r}function S(t){var e={};this.name=t,this.add=function(t,i){e[d(t,"").toString().toLowerCase()]=i},this.get=function(t){return e[d(t,"").toString().toLowerCase()]},Object.defineProperties(this,{names:{get:function(){return Object.keys(e)}}})}function A(t){var e=t;return t.forEach(function(t){t.__deps&&Array.prototype.push.apply(e,A(t.__deps))}),e}function M(t){var e=x(A(t));return e.map(function(t){return t.toString()}).join("\n\n\n")}function C(t){var e=t.data.__name,i=t.data.__postId;if(void 0===e)console.error("message __name undefined");else if(void 0===self.func)console.error("worker func undefined",e);else{var n=function(t,e){t=t||{},void 0!==i&&(t.__postId=i);try{self.postMessage(t,e)}catch(e){console.error("self.postMessage:",e),self.postMessage(t)}};self.func(t,n)}}function P(t,e){var i="'use strict';\n\n"+M(e);return i+="\n\n\nself.func = "+t.toString()+";",i+="\n\n\nself.onmessage = "+C.toString()+";",new Blob([i],{type:"application/javascript"})}function T(){this.activeWorkerCount=0;var t={},e={},i={};this.add=function(i,n,r){t[i]=n,e[i]=r},this.get=function(n){return i[n]||(i[n]=P(t[n],e[n])),i[n]}}function E(){}function I(t,e){this.x=t||0,this.y=e||0}function L(t,e,i,n,r,o,a,s,c,u){Object.defineProperty(this,"id",{value:R()}),this.uuid=dd.generateUUID(),this.name="",this.sourceFile="",this.image=void 0!==t?t:L.DEFAULT_IMAGE,this.mipmaps=[],this.mapping=void 0!==e?e:L.DEFAULT_MAPPING,this.wrapS=void 0!==i?i:ul,this.wrapT=void 0!==n?n:ul,this.magFilter=void 0!==r?r:pl,this.minFilter=void 0!==o?o:gl,this.anisotropy=void 0!==c?c:1,this.format=void 0!==a?a:Ll,this.type=void 0!==s?s:vl,this.offset=new I(0,0),this.repeat=new I(1,1),this.generateMipmaps=!0,this.premultiplyAlpha=!1,this.flipY=!0,this.unpackAlignment=4,this.encoding=void 0!==u?u:nd,this.version=0,this.onUpdate=null}function R(){return fd++}function O(){this.elements=new Float32Array([1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1]),arguments.length>0&&console.error("THREE.Matrix4: the constructor no longer reads arguments. use .set() instead.")}function D(t,e,i,n){this._x=t||0,this._y=e||0,this._z=i||0,this._w=void 0!==n?n:1}function N(t,e,i){this.x=t||0,this.y=e||0,this.z=i||0}function k(t,e){function i(){var t=new Float32Array([-.5,-.5,0,0,.5,-.5,1,0,.5,.5,1,1,-.5,.5,0,1]),e=new Uint16Array([0,1,2,0,2,3]);o=l.createBuffer(),a=l.createBuffer(),l.bindBuffer(l.ARRAY_BUFFER,o),l.bufferData(l.ARRAY_BUFFER,t,l.STATIC_DRAW),l.bindBuffer(l.ELEMENT_ARRAY_BUFFER,a),l.bufferData(l.ELEMENT_ARRAY_BUFFER,e,l.STATIC_DRAW),s=n(),c={position:l.getAttribLocation(s,"position"),uv:l.getAttribLocation(s,"uv")},u={uvOffset:l.getUniformLocation(s,"uvOffset"),uvScale:l.getUniformLocation(s,"uvScale"),rotation:l.getUniformLocation(s,"rotation"),scale:l.getUniformLocation(s,"scale"),color:l.getUniformLocation(s,"color"),map:l.getUniformLocation(s,"map"),opacity:l.getUniformLocation(s,"opacity"),modelViewMatrix:l.getUniformLocation(s,"modelViewMatrix"),projectionMatrix:l.getUniformLocation(s,"projectionMatrix"),fogType:l.getUniformLocation(s,"fogType"),fogDensity:l.getUniformLocation(s,"fogDensity"),fogNear:l.getUniformLocation(s,"fogNear"),fogFar:l.getUniformLocation(s,"fogFar"),fogColor:l.getUniformLocation(s,"fogColor"),alphaTest:l.getUniformLocation(s,"alphaTest")};var i=document.createElementNS("http://www.w3.org/1999/xhtml","canvas");i.width=8,i.height=8;var r=i.getContext("2d");r.fillStyle="white",r.fillRect(0,0,8,8),h=new L(i),h.needsUpdate=!0}function n(){var e=l.createProgram(),i=l.createShader(l.VERTEX_SHADER),n=l.createShader(l.FRAGMENT_SHADER);return l.shaderSource(i,["precision "+t.getPrecision()+" float;","uniform mat4 modelViewMatrix;","uniform mat4 projectionMatrix;","uniform float rotation;","uniform vec2 scale;","uniform vec2 uvOffset;","uniform vec2 uvScale;","attribute vec2 position;","attribute vec2 uv;","varying vec2 vUV;","void main() {","vUV = uvOffset + uv * uvScale;","vec2 alignedPosition = position * scale;","vec2 rotatedPosition;","rotatedPosition.x = cos( rotation ) * alignedPosition.x - sin( rotation ) * alignedPosition.y;","rotatedPosition.y = sin( rotation ) * alignedPosition.x + cos( rotation ) * alignedPosition.y;","vec4 finalPosition;","finalPosition = modelViewMatrix * vec4( 0.0, 0.0, 0.0, 1.0 );","finalPosition.xy += rotatedPosition;","finalPosition = projectionMatrix * finalPosition;","gl_Position = finalPosition;","}"].join("\n")),l.shaderSource(n,["precision "+t.getPrecision()+" float;","uniform vec3 color;","uniform sampler2D map;","uniform float opacity;","uniform int fogType;","uniform vec3 fogColor;","uniform float fogDensity;","uniform float fogNear;","uniform float fogFar;","uniform float alphaTest;","varying vec2 vUV;","void main() {","vec4 texture = texture2D( map, vUV );","if ( texture.a < alphaTest ) discard;","gl_FragColor = vec4( color * texture.xyz, texture.a * opacity );","if ( fogType > 0 ) {","float depth = gl_FragCoord.z / gl_FragCoord.w;","float fogFactor = 0.0;","if ( fogType == 1 ) {","fogFactor = smoothstep( fogNear, fogFar, depth );","} else {","const float LOG2 = 1.442695;","fogFactor = exp2( - fogDensity * fogDensity * depth * depth * LOG2 );","fogFactor = 1.0 - clamp( fogFactor, 0.0, 1.0 );","}","gl_FragColor = mix( gl_FragColor, vec4( fogColor, gl_FragColor.w ), fogFactor );","}","}"].join("\n")),l.compileShader(i),l.compileShader(n),l.attachShader(e,i),l.attachShader(e,n),l.linkProgram(e),e}function r(t,e){return t.renderOrder!==e.renderOrder?t.renderOrder-e.renderOrder:t.z!==e.z?e.z-t.z:e.id-t.id}var o,a,s,c,u,h,l=t.context,d=t.state,f=new N,p=new D,m=new N;this.render=function(n,g){if(0!==e.length){void 0===s&&i(),l.useProgram(s),d.initAttributes(),d.enableAttribute(c.position),d.enableAttribute(c.uv),d.disableUnusedAttributes(),d.disable(l.CULL_FACE),d.enable(l.BLEND),l.bindBuffer(l.ARRAY_BUFFER,o),l.vertexAttribPointer(c.position,2,l.FLOAT,!1,16,0),l.vertexAttribPointer(c.uv,2,l.FLOAT,!1,16,8),l.bindBuffer(l.ELEMENT_ARRAY_BUFFER,a),l.uniformMatrix4fv(u.projectionMatrix,!1,g.projectionMatrix.elements),d.activeTexture(l.TEXTURE0),l.uniform1i(u.map,0);var v=0,y=0,b=n.fog;b?(l.uniform3f(u.fogColor,b.color.r,b.color.g,b.color.b),b&&b.isFog?(l.uniform1f(u.fogNear,b.near),l.uniform1f(u.fogFar,b.far),l.uniform1i(u.fogType,1),v=1,y=1):b&&b.isFogExp2&&(l.uniform1f(u.fogDensity,b.density),l.uniform1i(u.fogType,2),v=2,y=2)):(l.uniform1i(u.fogType,0),v=0,y=0);for(var x=0,_=e.length;x<_;x++){var w=e[x];w.modelViewMatrix.multiplyMatrices(g.matrixWorldInverse,w.matrixWorld),w.z=-w.modelViewMatrix.elements[14]}e.sort(r);for(var S=[],x=0,_=e.length;x<_;x++){var w=e[x],A=w.material;if(A.visible!==!1){l.uniform1f(u.alphaTest,A.alphaTest),l.uniformMatrix4fv(u.modelViewMatrix,!1,w.modelViewMatrix.elements),w.matrixWorld.decompose(f,p,m),S[0]=m.x,S[1]=m.y;var M=0;n.fog&&A.fog&&(M=y),v!==M&&(l.uniform1i(u.fogType,M),v=M),null!==A.map?(l.uniform2f(u.uvOffset,A.map.offset.x,A.map.offset.y),l.uniform2f(u.uvScale,A.map.repeat.x,A.map.repeat.y)):(l.uniform2f(u.uvOffset,0,0),l.uniform2f(u.uvScale,1,1)),l.uniform1f(u.opacity,A.opacity),l.uniform3f(u.color,A.color.r,A.color.g,A.color.b),l.uniform1f(u.rotation,A.rotation),l.uniform2fv(u.scale,S),d.setBlending(A.blending,A.blendEquation,A.blendSrc,A.blendDst),d.setDepthTest(A.depthTest),d.setDepthWrite(A.depthWrite),A.map?t.setTexture2D(A.map,0):t.setTexture2D(h,0),l.drawElements(l.TRIANGLES,6,l.UNSIGNED_SHORT,0)}}d.enable(l.CULL_FACE),t.resetGLState()}}}function F(t,e){this.min=void 0!==t?t:new I(+(1/0),+(1/0)),this.max=void 0!==e?e:new I(-(1/0),-(1/0))}function z(t,e){function i(){var t=new Float32Array([-1,-1,0,0,1,-1,1,0,1,1,1,1,-1,1,0,1]),e=new Uint16Array([0,1,2,0,2,3]);r=d.createBuffer(),o=d.createBuffer(),d.bindBuffer(d.ARRAY_BUFFER,r),d.bufferData(d.ARRAY_BUFFER,t,d.STATIC_DRAW),d.bindBuffer(d.ELEMENT_ARRAY_BUFFER,o),d.bufferData(d.ELEMENT_ARRAY_BUFFER,e,d.STATIC_DRAW),h=d.createTexture(),l=d.createTexture(),f.bindTexture(d.TEXTURE_2D,h),d.texImage2D(d.TEXTURE_2D,0,d.RGB,16,16,0,d.RGB,d.UNSIGNED_BYTE,null),d.texParameteri(d.TEXTURE_2D,d.TEXTURE_WRAP_S,d.CLAMP_TO_EDGE),d.texParameteri(d.TEXTURE_2D,d.TEXTURE_WRAP_T,d.CLAMP_TO_EDGE),d.texParameteri(d.TEXTURE_2D,d.TEXTURE_MAG_FILTER,d.NEAREST),d.texParameteri(d.TEXTURE_2D,d.TEXTURE_MIN_FILTER,d.NEAREST),f.bindTexture(d.TEXTURE_2D,l),d.texImage2D(d.TEXTURE_2D,0,d.RGBA,16,16,0,d.RGBA,d.UNSIGNED_BYTE,null),d.texParameteri(d.TEXTURE_2D,d.TEXTURE_WRAP_S,d.CLAMP_TO_EDGE),d.texParameteri(d.TEXTURE_2D,d.TEXTURE_WRAP_T,d.CLAMP_TO_EDGE),d.texParameteri(d.TEXTURE_2D,d.TEXTURE_MAG_FILTER,d.NEAREST),d.texParameteri(d.TEXTURE_2D,d.TEXTURE_MIN_FILTER,d.NEAREST),a={vertexShader:["uniform lowp int renderType;","uniform vec3 screenPosition;","uniform vec2 scale;","uniform float rotation;","uniform sampler2D occlusionMap;","attribute vec2 position;","attribute vec2 uv;","varying vec2 vUV;","varying float vVisibility;","void main() {","vUV = uv;","vec2 pos = position;","if ( renderType == 2 ) {","vec4 visibility = texture2D( occlusionMap, vec2( 0.1, 0.1 ) );","visibility += texture2D( occlusionMap, vec2( 0.5, 0.1 ) );","visibility += texture2D( occlusionMap, vec2( 0.9, 0.1 ) );","visibility += texture2D( occlusionMap, vec2( 0.9, 0.5 ) );","visibility += texture2D( occlusionMap, vec2( 0.9, 0.9 ) );","visibility += texture2D( occlusionMap, vec2( 0.5, 0.9 ) );","visibility += texture2D( occlusionMap, vec2( 0.1, 0.9 ) );","visibility += texture2D( occlusionMap, vec2( 0.1, 0.5 ) );","visibility += texture2D( occlusionMap, vec2( 0.5, 0.5 ) );","vVisibility =        visibility.r / 9.0;","vVisibility *= 1.0 - visibility.g / 9.0;","vVisibility *=       visibility.b / 9.0;","vVisibility *= 1.0 - visibility.a / 9.0;","pos.x = cos( rotation ) * position.x - sin( rotation ) * position.y;","pos.y = sin( rotation ) * position.x + cos( rotation ) * position.y;","}","gl_Position = vec4( ( pos * scale + screenPosition.xy ).xy, screenPosition.z, 1.0 );","}"].join("\n"),fragmentShader:["uniform lowp int renderType;","uniform sampler2D map;","uniform float opacity;","uniform vec3 color;","varying vec2 vUV;","varying float vVisibility;","void main() {","if ( renderType == 0 ) {","gl_FragColor = vec4( 1.0, 0.0, 1.0, 0.0 );","} else if ( renderType == 1 ) {","gl_FragColor = texture2D( map, vUV );","} else {","vec4 texture = texture2D( map, vUV );","texture.a *= opacity * vVisibility;","gl_FragColor = texture;","gl_FragColor.rgb *= color;","}","}"].join("\n")},s=n(a),c={vertex:d.getAttribLocation(s,"position"),uv:d.getAttribLocation(s,"uv")},u={renderType:d.getUniformLocation(s,"renderType"),map:d.getUniformLocation(s,"map"),occlusionMap:d.getUniformLocation(s,"occlusionMap"),opacity:d.getUniformLocation(s,"opacity"),color:d.getUniformLocation(s,"color"),scale:d.getUniformLocation(s,"scale"),rotation:d.getUniformLocation(s,"rotation"),screenPosition:d.getUniformLocation(s,"screenPosition")}}function n(e){var i=d.createProgram(),n=d.createShader(d.FRAGMENT_SHADER),r=d.createShader(d.VERTEX_SHADER),o="precision "+t.getPrecision()+" float;\n";return d.shaderSource(n,o+e.fragmentShader),d.shaderSource(r,o+e.vertexShader),d.compileShader(n),d.compileShader(r),d.attachShader(i,n),d.attachShader(i,r),d.linkProgram(i),i}var r,o,a,s,c,u,h,l,d=t.context,f=t.state;this.render=function(n,a,p){if(0!==e.length){var m=new N,g=p.w/p.z,v=.5*p.z,y=.5*p.w,b=16/p.w,x=new I(b*g,b),_=new N(1,1,0),w=new I(1,1),S=new F;S.min.set(0,0),S.max.set(p.z-16,p.w-16),void 0===s&&i(),d.useProgram(s),f.initAttributes(),f.enableAttribute(c.vertex),f.enableAttribute(c.uv),f.disableUnusedAttributes(),d.uniform1i(u.occlusionMap,0),d.uniform1i(u.map,1),d.bindBuffer(d.ARRAY_BUFFER,r),d.vertexAttribPointer(c.vertex,2,d.FLOAT,!1,16,0),d.vertexAttribPointer(c.uv,2,d.FLOAT,!1,16,8),d.bindBuffer(d.ELEMENT_ARRAY_BUFFER,o),f.disable(d.CULL_FACE),f.setDepthWrite(!1);for(var A=0,M=e.length;A<M;A++){b=16/p.w,x.set(b*g,b);var C=e[A];if(m.set(C.matrixWorld.elements[12],C.matrixWorld.elements[13],C.matrixWorld.elements[14]),m.applyMatrix4(a.matrixWorldInverse),m.applyProjection(a.projectionMatrix),_.copy(m),w.x=p.x+_.x*v+v-8,w.y=p.y+_.y*y+y-8,S.containsPoint(w)===!0){f.activeTexture(d.TEXTURE0),f.bindTexture(d.TEXTURE_2D,null),f.activeTexture(d.TEXTURE1),f.bindTexture(d.TEXTURE_2D,h),d.copyTexImage2D(d.TEXTURE_2D,0,d.RGB,w.x,w.y,16,16,0),d.uniform1i(u.renderType,0),d.uniform2f(u.scale,x.x,x.y),d.uniform3f(u.screenPosition,_.x,_.y,_.z),f.disable(d.BLEND),f.enable(d.DEPTH_TEST),d.drawElements(d.TRIANGLES,6,d.UNSIGNED_SHORT,0),f.activeTexture(d.TEXTURE0),f.bindTexture(d.TEXTURE_2D,l),d.copyTexImage2D(d.TEXTURE_2D,0,d.RGBA,w.x,w.y,16,16,0),d.uniform1i(u.renderType,1),f.disable(d.DEPTH_TEST),f.activeTexture(d.TEXTURE1),f.bindTexture(d.TEXTURE_2D,h),d.drawElements(d.TRIANGLES,6,d.UNSIGNED_SHORT,0),C.positionScreen.copy(_),C.customUpdateCallback?C.customUpdateCallback(C):C.updateLensFlares(),d.uniform1i(u.renderType,2),f.enable(d.BLEND);for(var P=0,T=C.lensFlares.length;P<T;P++){var E=C.lensFlares[P];E.opacity>.001&&E.scale>.001&&(_.x=E.x,_.y=E.y,_.z=E.z,b=E.size*E.scale/p.w,x.x=b*g,x.y=b,d.uniform3f(u.screenPosition,_.x,_.y,_.z),d.uniform2f(u.scale,x.x,x.y),d.uniform1f(u.rotation,E.rotation),d.uniform1f(u.opacity,E.opacity),d.uniform3f(u.color,E.color.r,E.color.g,E.color.b),f.setBlending(E.blending,E.blendEquation,E.blendSrc,E.blendDst),t.setTexture2D(E.texture,1),d.drawElements(d.TRIANGLES,6,d.UNSIGNED_SHORT,0))}}}f.enable(d.CULL_FACE),f.enable(d.DEPTH_TEST),f.setDepthWrite(!0),t.resetGLState()}}}function B(t,e,i,n,r,o,a,s,c,u){t=void 0!==t?t:[],e=void 0!==e?e:el,L.call(this,t,e,i,n,r,o,a,s,c,u),this.flipY=!1}function U(){this.seq=[],this.map={}}function j(t,e,i){var n=t[0];if(n<=0||n>0)return t;var r=e*i,o=gd[r];if(void 0===o&&(o=new Float32Array(r),gd[r]=o),0!==e){n.toArray(o,0);for(var a=1,s=0;a!==e;++a)s+=i,t[a].toArray(o,s)}return o}function $(t,e){var i=vd[e];void 0===i&&(i=new Int32Array(e),vd[e]=i);for(var n=0;n!==e;++n)i[n]=t.allocTextureUnit();return i}function V(t,e){t.uniform1f(this.addr,e)}function G(t,e){t.uniform1i(this.addr,e)}function H(t,e){void 0===e.x?t.uniform2fv(this.addr,e):t.uniform2f(this.addr,e.x,e.y)}function W(t,e){void 0!==e.x?t.uniform3f(this.addr,e.x,e.y,e.z):void 0!==e.r?t.uniform3f(this.addr,e.r,e.g,e.b):t.uniform3fv(this.addr,e)}function X(t,e){void 0===e.x?t.uniform4fv(this.addr,e):t.uniform4f(this.addr,e.x,e.y,e.z,e.w)}function q(t,e){t.uniformMatrix2fv(this.addr,!1,e.elements||e)}function Y(t,e){t.uniformMatrix3fv(this.addr,!1,e.elements||e)}function Z(t,e){t.uniformMatrix4fv(this.addr,!1,e.elements||e)}function K(t,e,i){var n=i.allocTextureUnit();t.uniform1i(this.addr,n),i.setTexture2D(e||pd,n)}function Q(t,e,i){var n=i.allocTextureUnit();t.uniform1i(this.addr,n),i.setTextureCube(e||md,n)}function J(t,e){t.uniform2iv(this.addr,e)}function tt(t,e){t.uniform3iv(this.addr,e)}function et(t,e){t.uniform4iv(this.addr,e)}function it(t){switch(t){case 5126:return V;case 35664:return H;case 35665:return W;case 35666:return X;case 35674:return q;case 35675:return Y;case 35676:return Z;case 35678:return K;case 35680:return Q;case 5124:case 35670:return G;case 35667:case 35671:return J;case 35668:case 35672:return tt;case 35669:case 35673:return et}}function nt(t,e){t.uniform1fv(this.addr,e)}function rt(t,e){t.uniform1iv(this.addr,e)}function ot(t,e){t.uniform2fv(this.addr,j(e,this.size,2))}function at(t,e){t.uniform3fv(this.addr,j(e,this.size,3))}function st(t,e){t.uniform4fv(this.addr,j(e,this.size,4))}function ct(t,e){t.uniformMatrix2fv(this.addr,!1,j(e,this.size,4))}function ut(t,e){t.uniformMatrix3fv(this.addr,!1,j(e,this.size,9))}function ht(t,e){t.uniformMatrix4fv(this.addr,!1,j(e,this.size,16))}function lt(t,e,i){var n=e.length,r=$(i,n);t.uniform1iv(this.addr,r);for(var o=0;o!==n;++o)i.setTexture2D(e[o]||pd,r[o])}function dt(t,e,i){var n=e.length,r=$(i,n);t.uniform1iv(this.addr,r);for(var o=0;o!==n;++o)i.setTextureCube(e[o]||md,r[o])}function ft(t){switch(t){case 5126:return nt;case 35664:return ot;case 35665:return at;case 35666:return st;case 35674:return ct;case 35675:return ut;case 35676:return ht;case 35678:return lt;case 35680:return dt;case 5124:case 35670:return rt;case 35667:case 35671:return J;case 35668:case 35672:return tt;case 35669:case 35673:return et}}function pt(t,e,i){this.id=t,this.addr=i,this.setValue=it(e.type)}function mt(t,e,i){this.id=t,this.addr=i,this.size=e.size,this.setValue=ft(e.type)}function gt(t){this.id=t,U.call(this)}function vt(t,e){t.seq.push(e),t.map[e.id]=e}function yt(t,e,i){var n=t.name,r=n.length;for(yd.lastIndex=0;;){var o=yd.exec(n),a=yd.lastIndex,s=o[1],c="]"===o[2],u=o[3];if(c&&(s=0|s),void 0===u||"["===u&&a+2===r){vt(i,void 0===u?new pt(s,t,e):new mt(s,t,e));break}var h=i.map,l=h[s];void 0===l&&(l=new gt(s),vt(i,l)),i=l}}function bt(t,e,i){U.call(this),this.renderer=i;for(var n=t.getProgramParameter(e,t.ACTIVE_UNIFORMS),r=0;r!==n;++r){var o=t.getActiveUniform(e,r),a=o.name,s=t.getUniformLocation(e,a);yt(o,s,this)}}function xt(t,e,i,n,r,o,a){function s(t,e){if(t.width>e||t.height>e){var i=e/Math.max(t.width,t.height),n=document.createElementNS("http://www.w3.org/1999/xhtml","canvas");n.width=Math.floor(t.width*i),n.height=Math.floor(t.height*i);var r=n.getContext("2d");return r.drawImage(t,0,0,t.width,t.height,0,0,n.width,n.height),console.warn("THREE.WebGLRenderer: image is too big ("+t.width+"x"+t.height+"). Resized to "+n.width+"x"+n.height,t),n}return t}function c(t){return dd.isPowerOfTwo(t.width)&&dd.isPowerOfTwo(t.height)}function u(t){if(t instanceof HTMLImageElement||t instanceof HTMLCanvasElement){var e=document.createElementNS("http://www.w3.org/1999/xhtml","canvas");e.width=dd.nearestPowerOfTwo(t.width),e.height=dd.nearestPowerOfTwo(t.height);var i=e.getContext("2d");return i.drawImage(t,0,0,e.width,e.height),console.warn("THREE.WebGLRenderer: image is not power of two ("+t.width+"x"+t.height+"). Resized to "+e.width+"x"+e.height,t),e}return t}function h(t){return t.wrapS!==ul||t.wrapT!==ul||t.minFilter!==ll&&t.minFilter!==pl}function l(e){return e===ll||e===dl||e===fl?t.NEAREST:t.LINEAR}function d(t){var e=t.target;e.removeEventListener("dispose",d),p(e),P.textures--}function f(t){var e=t.target;e.removeEventListener("dispose",f),m(e),P.textures--}function p(e){var i=n.get(e);if(e.image&&i.__image__webglTextureCube)t.deleteTexture(i.__image__webglTextureCube);else{if(void 0===i.__webglInit)return;t.deleteTexture(i.__webglTexture)}n.delete(e)}function m(e){var i=n.get(e),r=n.get(e.texture);if(e){if(void 0!==r.__webglTexture&&t.deleteTexture(r.__webglTexture),e.depthTexture&&e.depthTexture.dispose(),e&&e.isWebGLRenderTargetCube)for(var o=0;o<6;o++)t.deleteFramebuffer(i.__webglFramebuffer[o]),i.__webglDepthbuffer&&t.deleteRenderbuffer(i.__webglDepthbuffer[o]);else t.deleteFramebuffer(i.__webglFramebuffer),i.__webglDepthbuffer&&t.deleteRenderbuffer(i.__webglDepthbuffer);n.delete(e.texture),n.delete(e)}}function g(e,r){var o=n.get(e);if(e.version>0&&o.__version!==e.version){var a=e.image;if(void 0===a)console.warn("THREE.WebGLRenderer: Texture marked for update but image is undefined",e);else{if(a.complete!==!1)return void x(o,e,r);console.warn("THREE.WebGLRenderer: Texture marked for update but image is incomplete",e)}}i.activeTexture(t.TEXTURE0+r),i.bindTexture(t.TEXTURE_2D,o.__webglTexture)}function v(e,a){var u=n.get(e);if(6===e.image.length)if(e.version>0&&u.__version!==e.version){u.__image__webglTextureCube||(e.addEventListener("dispose",d),u.__image__webglTextureCube=t.createTexture(),P.textures++),i.activeTexture(t.TEXTURE0+a),i.bindTexture(t.TEXTURE_CUBE_MAP,u.__image__webglTextureCube),t.pixelStorei(t.UNPACK_FLIP_Y_WEBGL,e.flipY);for(var h=e&&e.isCompressedTexture,l=e.image[0]&&e.image[0].isDataTexture,f=[],p=0;p<6;p++)h||l?f[p]=l?e.image[p].image:e.image[p]:f[p]=s(e.image[p],r.maxCubemapSize);var m=f[0],g=c(m),v=o(e.format),y=o(e.type);b(t.TEXTURE_CUBE_MAP,e,g);for(var p=0;p<6;p++)if(h)for(var x,_=f[p].mipmaps,w=0,S=_.length;w<S;w++)x=_[w],e.format!==Ll&&e.format!==Il?i.getCompressedTextureFormats().indexOf(v)>-1?i.compressedTexImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+p,w,v,x.width,x.height,0,x.data):console.warn("THREE.WebGLRenderer: Attempt to load unsupported compressed texture format in .setTextureCube()"):i.texImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+p,w,v,x.width,x.height,0,v,y,x.data);else l?i.texImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+p,0,v,f[p].width,f[p].height,0,v,y,f[p].data):i.texImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+p,0,v,v,y,f[p]);e.generateMipmaps&&g&&t.generateMipmap(t.TEXTURE_CUBE_MAP),u.__version=e.version,e.onUpdate&&e.onUpdate(e)}else i.activeTexture(t.TEXTURE0+a),i.bindTexture(t.TEXTURE_CUBE_MAP,u.__image__webglTextureCube)}function y(e,r){i.activeTexture(t.TEXTURE0+r),i.bindTexture(t.TEXTURE_CUBE_MAP,n.get(e).__webglTexture)}function b(i,a,s){var c;if(s?(t.texParameteri(i,t.TEXTURE_WRAP_S,o(a.wrapS)),t.texParameteri(i,t.TEXTURE_WRAP_T,o(a.wrapT)),t.texParameteri(i,t.TEXTURE_MAG_FILTER,o(a.magFilter)),t.texParameteri(i,t.TEXTURE_MIN_FILTER,o(a.minFilter))):(t.texParameteri(i,t.TEXTURE_WRAP_S,t.CLAMP_TO_EDGE),t.texParameteri(i,t.TEXTURE_WRAP_T,t.CLAMP_TO_EDGE),a.wrapS===ul&&a.wrapT===ul||console.warn("THREE.WebGLRenderer: Texture is not power of two. Texture.wrapS and Texture.wrapT should be set to THREE.ClampToEdgeWrapping.",a),t.texParameteri(i,t.TEXTURE_MAG_FILTER,l(a.magFilter)),t.texParameteri(i,t.TEXTURE_MIN_FILTER,l(a.minFilter)),a.minFilter!==ll&&a.minFilter!==pl&&console.warn("THREE.WebGLRenderer: Texture is not power of two. Texture.minFilter should be set to THREE.NearestFilter or THREE.LinearFilter.",a)),c=e.get("EXT_texture_filter_anisotropic")){if(a.type===Sl&&null===e.get("OES_texture_float_linear"))return;if(a.type===Al&&null===e.get("OES_texture_half_float_linear"))return;(a.anisotropy>1||n.get(a).__currentAnisotropy)&&(t.texParameterf(i,c.TEXTURE_MAX_ANISOTROPY_EXT,Math.min(a.anisotropy,r.getMaxAnisotropy())),n.get(a).__currentAnisotropy=a.anisotropy)}}function x(e,n,a){void 0===e.__webglInit&&(e.__webglInit=!0,n.addEventListener("dispose",d),e.__webglTexture=t.createTexture(),P.textures++),i.activeTexture(t.TEXTURE0+a),i.bindTexture(t.TEXTURE_2D,e.__webglTexture),t.pixelStorei(t.UNPACK_FLIP_Y_WEBGL,n.flipY),t.pixelStorei(t.UNPACK_PREMULTIPLY_ALPHA_WEBGL,n.premultiplyAlpha),t.pixelStorei(t.UNPACK_ALIGNMENT,n.unpackAlignment);var l=s(n.image,r.maxTextureSize);h(n)&&c(l)===!1&&(l=u(l));var f=c(l),p=o(n.format),m=o(n.type);b(t.TEXTURE_2D,n,f);var g,v=n.mipmaps;if(n&&n.isDepthTexture){var y=t.DEPTH_COMPONENT;if(n.type===Sl){if(!T)throw new Error("Float Depth Texture only supported in WebGL2.0");y=t.DEPTH_COMPONENT32F}else T&&(y=t.DEPTH_COMPONENT16);n.format===Nl&&(y=t.DEPTH_STENCIL),i.texImage2D(t.TEXTURE_2D,0,y,l.width,l.height,0,p,m,null)}else if(n&&n.isDataTexture)if(v.length>0&&f){for(var x=0,_=v.length;x<_;x++)g=v[x],i.texImage2D(t.TEXTURE_2D,x,p,g.width,g.height,0,p,m,g.data);n.generateMipmaps=!1}else i.texImage2D(t.TEXTURE_2D,0,p,l.width,l.height,0,p,m,l.data);else if(n&&n.isCompressedTexture)for(var x=0,_=v.length;x<_;x++)g=v[x],n.format!==Ll&&n.format!==Il?i.getCompressedTextureFormats().indexOf(p)>-1?i.compressedTexImage2D(t.TEXTURE_2D,x,p,g.width,g.height,0,g.data):console.warn("THREE.WebGLRenderer: Attempt to load unsupported compressed texture format in .uploadTexture()"):i.texImage2D(t.TEXTURE_2D,x,p,g.width,g.height,0,p,m,g.data);else if(v.length>0&&f){for(var x=0,_=v.length;x<_;x++)g=v[x],i.texImage2D(t.TEXTURE_2D,x,p,p,m,g);n.generateMipmaps=!1}else i.texImage2D(t.TEXTURE_2D,0,p,p,m,l);n.generateMipmaps&&f&&t.generateMipmap(t.TEXTURE_2D),e.__version=n.version,n.onUpdate&&n.onUpdate(n)}function _(e,r,a,s){var c=o(r.texture.format),u=o(r.texture.type);i.texImage2D(s,0,c,r.width,r.height,0,c,u,null),t.bindFramebuffer(t.FRAMEBUFFER,e),t.framebufferTexture2D(t.FRAMEBUFFER,a,s,n.get(r.texture).__webglTexture,0),t.bindFramebuffer(t.FRAMEBUFFER,null)}function w(e,i){t.bindRenderbuffer(t.RENDERBUFFER,e),i.depthBuffer&&!i.stencilBuffer?(t.renderbufferStorage(t.RENDERBUFFER,t.DEPTH_COMPONENT16,i.width,i.height),t.framebufferRenderbuffer(t.FRAMEBUFFER,t.DEPTH_ATTACHMENT,t.RENDERBUFFER,e)):i.depthBuffer&&i.stencilBuffer?(t.renderbufferStorage(t.RENDERBUFFER,t.DEPTH_STENCIL,i.width,i.height),t.framebufferRenderbuffer(t.FRAMEBUFFER,t.DEPTH_STENCIL_ATTACHMENT,t.RENDERBUFFER,e)):t.renderbufferStorage(t.RENDERBUFFER,t.RGBA4,i.width,i.height),t.bindRenderbuffer(t.RENDERBUFFER,null)}function S(e,i){var r=i&&i.isWebGLRenderTargetCube;if(r)throw new Error("Depth Texture with cube render targets is not supported!");if(t.bindFramebuffer(t.FRAMEBUFFER,e),!i.depthTexture||!i.depthTexture.isDepthTexture)throw new Error("renderTarget.depthTexture must be an instance of THREE.DepthTexture");n.get(i.depthTexture).__webglTexture&&i.depthTexture.image.width===i.width&&i.depthTexture.image.height===i.height||(i.depthTexture.image.width=i.width,i.depthTexture.image.height=i.height,i.depthTexture.needsUpdate=!0),g(i.depthTexture,0);var o=n.get(i.depthTexture).__webglTexture;if(i.depthTexture.format===Dl)t.framebufferTexture2D(t.FRAMEBUFFER,t.DEPTH_ATTACHMENT,t.TEXTURE_2D,o,0);else{if(i.depthTexture.format!==Nl)throw new Error("Unknown depthTexture format");t.framebufferTexture2D(t.FRAMEBUFFER,t.DEPTH_STENCIL_ATTACHMENT,t.TEXTURE_2D,o,0)}}function A(e){var i=n.get(e),r=e&&e.isWebGLRenderTargetCube;if(e.depthTexture){if(r)throw new Error("target.depthTexture not supported in Cube render targets");S(i.__webglFramebuffer,e)}else if(r){i.__webglDepthbuffer=[];for(var o=0;o<6;o++)t.bindFramebuffer(t.FRAMEBUFFER,i.__webglFramebuffer[o]),i.__webglDepthbuffer[o]=t.createRenderbuffer(),w(i.__webglDepthbuffer[o],e)}else t.bindFramebuffer(t.FRAMEBUFFER,i.__webglFramebuffer),i.__webglDepthbuffer=t.createRenderbuffer(),w(i.__webglDepthbuffer,e);t.bindFramebuffer(t.FRAMEBUFFER,null)}function M(e){var r=n.get(e),o=n.get(e.texture);e.addEventListener("dispose",f),o.__webglTexture=t.createTexture(),P.textures++;var a=e&&e.isWebGLRenderTargetCube,s=c(e);if(a){r.__webglFramebuffer=[];for(var u=0;u<6;u++)r.__webglFramebuffer[u]=t.createFramebuffer()}else r.__webglFramebuffer=t.createFramebuffer();if(a){i.bindTexture(t.TEXTURE_CUBE_MAP,o.__webglTexture),b(t.TEXTURE_CUBE_MAP,e.texture,s);for(var u=0;u<6;u++)_(r.__webglFramebuffer[u],e,t.COLOR_ATTACHMENT0,t.TEXTURE_CUBE_MAP_POSITIVE_X+u);e.texture.generateMipmaps&&s&&t.generateMipmap(t.TEXTURE_CUBE_MAP),i.bindTexture(t.TEXTURE_CUBE_MAP,null)}else i.bindTexture(t.TEXTURE_2D,o.__webglTexture),b(t.TEXTURE_2D,e.texture,s),_(r.__webglFramebuffer,e,t.COLOR_ATTACHMENT0,t.TEXTURE_2D),e.texture.generateMipmaps&&s&&t.generateMipmap(t.TEXTURE_2D),i.bindTexture(t.TEXTURE_2D,null);e.depthBuffer&&A(e)}function C(e){var r=e.texture;if(r.generateMipmaps&&c(e)&&r.minFilter!==ll&&r.minFilter!==pl){var o=e&&e.isWebGLRenderTargetCube?t.TEXTURE_CUBE_MAP:t.TEXTURE_2D,a=n.get(r).__webglTexture;i.bindTexture(o,a),t.generateMipmap(o),i.bindTexture(o,null)}}var P=a.memory,T="undefined"!=typeof WebGL2RenderingContext&&t instanceof WebGL2RenderingContext;this.setTexture2D=g,this.setTextureCube=v,this.setTextureCubeDynamic=y,this.setupRenderTarget=M,this.updateRenderTargetMipmap=C}function _t(t,e,i,n){this.x=t||0,this.y=e||0,this.z=i||0,this.w=void 0!==n?n:1}function wt(t,e,i){function n(){var e=!1,i=new _t,n=null,r=new _t;return{setMask:function(i){
	n===i||e||(t.colorMask(i,i,i,i),n=i)},setLocked:function(t){e=t},setClear:function(e,n,o,a){i.set(e,n,o,a),r.equals(i)===!1&&(t.clearColor(e,n,o,a),r.copy(i))},reset:function(){e=!1,n=null,r.set(0,0,0,1)}}}function r(){var e=!1,i=null,n=null,r=null;return{setTest:function(e){e?d(t.DEPTH_TEST):f(t.DEPTH_TEST)},setMask:function(n){i===n||e||(t.depthMask(n),i=n)},setFunc:function(e){if(n!==e){if(e)switch(e){case zh:t.depthFunc(t.NEVER);break;case Bh:t.depthFunc(t.ALWAYS);break;case Uh:t.depthFunc(t.LESS);break;case jh:t.depthFunc(t.LEQUAL);break;case $h:t.depthFunc(t.EQUAL);break;case Vh:t.depthFunc(t.GEQUAL);break;case Gh:t.depthFunc(t.GREATER);break;case Hh:t.depthFunc(t.NOTEQUAL);break;default:t.depthFunc(t.LEQUAL)}else t.depthFunc(t.LEQUAL);n=e}},setLocked:function(t){e=t},setClear:function(e){r!==e&&(t.clearDepth(e),r=e)},reset:function(){e=!1,i=null,n=null,r=null}}}function o(){var e=!1,i=null,n=null,r=null,o=null,a=null,s=null,c=null,u=null;return{setTest:function(e){e?d(t.STENCIL_TEST):f(t.STENCIL_TEST)},setMask:function(n){i===n||e||(t.stencilMask(n),i=n)},setFunc:function(e,i,a){n===e&&r===i&&o===a||(t.stencilFunc(e,i,a),n=e,r=i,o=a)},setOp:function(e,i,n){a===e&&s===i&&c===n||(t.stencilOp(e,i,n),a=e,s=i,c=n)},setLocked:function(t){e=t},setClear:function(e){u!==e&&(t.clearStencil(e),u=e)},reset:function(){e=!1,i=null,n=null,r=null,o=null,a=null,s=null,c=null,u=null}}}function a(e,i,n){var r=new Uint8Array(4),o=t.createTexture();t.bindTexture(e,o),t.texParameteri(e,t.TEXTURE_MIN_FILTER,t.NEAREST),t.texParameteri(e,t.TEXTURE_MAG_FILTER,t.NEAREST);for(var a=0;a<n;a++)t.texImage2D(i+a,0,t.RGBA,1,1,0,t.RGBA,t.UNSIGNED_BYTE,r);return o}function s(){D(0,0,0,1),N(1),k(0),d(t.DEPTH_TEST),b(jh),A(!1),M(nh),d(t.CULL_FACE),d(t.BLEND),m(vh)}function c(){for(var t=0,e=G.length;t<e;t++)G[t]=0}function u(i){if(G[i]=1,0===H[i]&&(t.enableVertexAttribArray(i),H[i]=1),0!==W[i]){var n=e.get("ANGLE_instanced_arrays");n.vertexAttribDivisorANGLE(i,0),W[i]=0}}function h(e,i,n){G[e]=1,0===H[e]&&(t.enableVertexAttribArray(e),H[e]=1),W[e]!==i&&(n.vertexAttribDivisorANGLE(e,i),W[e]=i)}function l(){for(var e=0,i=H.length;e!==i;++e)H[e]!==G[e]&&(t.disableVertexAttribArray(e),H[e]=0)}function d(e){X[e]!==!0&&(t.enable(e),X[e]=!0)}function f(e){X[e]!==!1&&(t.disable(e),X[e]=!1)}function p(){if(null===q&&(q=[],e.get("WEBGL_compressed_texture_pvrtc")||e.get("WEBGL_compressed_texture_s3tc")||e.get("WEBGL_compressed_texture_etc1")))for(var i=t.getParameter(t.COMPRESSED_TEXTURE_FORMATS),n=0;n<i.length;n++)q.push(i[n]);return q}function m(e,n,r,o,a,s,c,u){return e===gh?(f(t.BLEND),void(Y=e)):(d(t.BLEND),e===Y&&u===it||(e===yh?u?(t.blendEquationSeparate(t.FUNC_ADD,t.FUNC_ADD),t.blendFuncSeparate(t.ONE,t.ONE,t.ONE,t.ONE)):(t.blendEquation(t.FUNC_ADD),t.blendFunc(t.SRC_ALPHA,t.ONE)):e===bh?u?(t.blendEquationSeparate(t.FUNC_ADD,t.FUNC_ADD),t.blendFuncSeparate(t.ZERO,t.ZERO,t.ONE_MINUS_SRC_COLOR,t.ONE_MINUS_SRC_ALPHA)):(t.blendEquation(t.FUNC_ADD),t.blendFunc(t.ZERO,t.ONE_MINUS_SRC_COLOR)):e===xh?u?(t.blendEquationSeparate(t.FUNC_ADD,t.FUNC_ADD),t.blendFuncSeparate(t.ZERO,t.SRC_COLOR,t.ZERO,t.SRC_ALPHA)):(t.blendEquation(t.FUNC_ADD),t.blendFunc(t.ZERO,t.SRC_COLOR)):u?(t.blendEquationSeparate(t.FUNC_ADD,t.FUNC_ADD),t.blendFuncSeparate(t.ONE,t.ONE_MINUS_SRC_ALPHA,t.ONE,t.ONE_MINUS_SRC_ALPHA)):(t.blendEquationSeparate(t.FUNC_ADD,t.FUNC_ADD),t.blendFuncSeparate(t.SRC_ALPHA,t.ONE_MINUS_SRC_ALPHA,t.ONE,t.ONE_MINUS_SRC_ALPHA)),Y=e,it=u),void(e===_h?(a=a||n,s=s||r,c=c||o,n===Z&&a===J||(t.blendEquationSeparate(i(n),i(a)),Z=n,J=a),r===K&&o===Q&&s===tt&&c===et||(t.blendFuncSeparate(i(r),i(o),i(s),i(c)),K=r,Q=o,tt=s,et=c)):(Z=null,K=null,Q=null,J=null,tt=null,et=null)))}function g(t){U.setMask(t)}function v(t){j.setTest(t)}function y(t){j.setMask(t)}function b(t){j.setFunc(t)}function x(t){$.setTest(t)}function _(t){$.setMask(t)}function w(t,e,i){$.setFunc(t,e,i)}function S(t,e,i){$.setOp(t,e,i)}function A(e){nt!==e&&(e?t.frontFace(t.CW):t.frontFace(t.CCW),nt=e)}function M(e){e!==ih?(d(t.CULL_FACE),e!==rt&&(e===nh?t.cullFace(t.BACK):e===rh?t.cullFace(t.FRONT):t.cullFace(t.FRONT_AND_BACK))):f(t.CULL_FACE),rt=e}function C(e){e!==ot&&(t.lineWidth(e),ot=e)}function P(e,i,n){e?(d(t.POLYGON_OFFSET_FILL),at===i&&st===n||(t.polygonOffset(i,n),at=i,st=n)):f(t.POLYGON_OFFSET_FILL)}function T(){return ct}function E(e){ct=e,e?d(t.SCISSOR_TEST):f(t.SCISSOR_TEST)}function I(e){void 0===e&&(e=t.TEXTURE0+ut-1),ht!==e&&(t.activeTexture(e),ht=e)}function L(e,i){null===ht&&I();var n=lt[ht];void 0===n&&(n={type:void 0,texture:void 0},lt[ht]=n),n.type===e&&n.texture===i||(t.bindTexture(e,i||pt[e]),n.type=e,n.texture=i)}function R(){try{t.compressedTexImage2D.apply(t,arguments)}catch(t){console.error(t)}}function O(){try{t.texImage2D.apply(t,arguments)}catch(t){console.error(t)}}function D(t,e,i,n){U.setClear(t,e,i,n)}function N(t){j.setClear(t)}function k(t){$.setClear(t)}function F(e){dt.equals(e)===!1&&(t.scissor(e.x,e.y,e.z,e.w),dt.copy(e))}function z(e){ft.equals(e)===!1&&(t.viewport(e.x,e.y,e.z,e.w),ft.copy(e))}function B(){for(var e=0;e<H.length;e++)1===H[e]&&(t.disableVertexAttribArray(e),H[e]=0);X={},q=null,ht=null,lt={},Y=null,nt=null,rt=null,U.reset(),j.reset(),$.reset()}var U=new n,j=new r,$=new o,V=t.getParameter(t.MAX_VERTEX_ATTRIBS),G=new Uint8Array(V),H=new Uint8Array(V),W=new Uint8Array(V),X={},q=null,Y=null,Z=null,K=null,Q=null,J=null,tt=null,et=null,it=!1,nt=null,rt=null,ot=null,at=null,st=null,ct=null,ut=t.getParameter(t.MAX_TEXTURE_IMAGE_UNITS),ht=null,lt={},dt=new _t,ft=new _t,pt={};return pt[t.TEXTURE_2D]=a(t.TEXTURE_2D,t.TEXTURE_2D,1),pt[t.TEXTURE_CUBE_MAP]=a(t.TEXTURE_CUBE_MAP,t.TEXTURE_CUBE_MAP_POSITIVE_X,6),{buffers:{color:U,depth:j,stencil:$},init:s,initAttributes:c,enableAttribute:u,enableAttributeAndDivisor:h,disableUnusedAttributes:l,enable:d,disable:f,getCompressedTextureFormats:p,setBlending:m,setColorWrite:g,setDepthTest:v,setDepthWrite:y,setDepthFunc:b,setStencilTest:x,setStencilWrite:_,setStencilFunc:w,setStencilOp:S,setFlipSided:A,setCullFace:M,setLineWidth:C,setPolygonOffset:P,getScissorTest:T,setScissorTest:E,activeTexture:I,bindTexture:L,compressedTexImage2D:R,texImage2D:O,clearColor:D,clearDepth:N,clearStencil:k,scissor:F,viewport:z,reset:B}}function St(t,e,i){this.uuid=dd.generateUUID(),this.width=t,this.height=e,this.scissor=new _t(0,0,t,e),this.scissorTest=!1,this.viewport=new _t(0,0,t,e),i=i||{},void 0===i.minFilter&&(i.minFilter=pl),this.texture=new L(void 0,void 0,i.wrapS,i.wrapT,i.magFilter,i.minFilter,i.format,i.type,i.anisotropy,i.encoding),this.depthBuffer=void 0===i.depthBuffer||i.depthBuffer,this.stencilBuffer=void 0===i.stencilBuffer||i.stencilBuffer,this.depthTexture=void 0!==i.depthTexture?i.depthTexture:null}function At(){Object.defineProperty(this,"id",{value:Mt()}),this.uuid=dd.generateUUID(),this.name="",this.type="Material",this.fog=!0,this.lights=!0,this.blending=vh,this.side=ch,this.shading=dh,this.vertexColors=fh,this.opacity=1,this.transparent=!1,this.blendSrc=Lh,this.blendDst=Rh,this.blendEquation=wh,this.blendSrcAlpha=null,this.blendDstAlpha=null,this.blendEquationAlpha=null,this.depthFunc=jh,this.depthTest=!0,this.depthWrite=!0,this.clippingPlanes=null,this.clipShadows=!1,this.colorWrite=!0,this.precision=null,this.polygonOffset=!1,this.polygonOffsetFactor=0,this.polygonOffsetUnits=0,this.alphaTest=0,this.premultipliedAlpha=!1,this.overdraw=0,this.visible=!0,this._needsUpdate=!0}function Mt(){return bd++}function Ct(t){At.call(this),this.type="ShaderMaterial",this.defines={},this.uniforms={},this.vertexShader="void main() {\n\tgl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",this.fragmentShader="void main() {\n\tgl_FragColor = vec4( 1.0, 0.0, 0.0, 1.0 );\n}",this.linewidth=1,this.wireframe=!1,this.wireframeLinewidth=1,this.fog=!1,this.lights=!1,this.clipping=!1,this.skinning=!1,this.morphTargets=!1,this.morphNormals=!1,this.extensions={derivatives:!1,fragDepth:!1,drawBuffers:!1,shaderTextureLOD:!1},this.defaultAttributeValues={color:[1,1,1],uv:[0,0],uv2:[0,0]},this.index0AttributeName=void 0,void 0!==t&&(void 0!==t.attributes&&console.error("THREE.ShaderMaterial: attributes should now be defined in THREE.BufferGeometry instead."),this.setValues(t))}function Pt(t,e,i){return void 0===e&&void 0===i?this.set(t):this.setRGB(t,e,i)}function Tt(t){At.call(this),this.type="MeshDepthMaterial",this.depthPacking=hd,this.skinning=!1,this.morphTargets=!1,this.map=null,this.alphaMap=null,this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.wireframe=!1,this.wireframeLinewidth=1,this.fog=!1,this.lights=!1,this.setValues(t)}function Et(t,e){this.min=void 0!==t?t:new N(+(1/0),+(1/0),+(1/0)),this.max=void 0!==e?e:new N(-(1/0),-(1/0),-(1/0))}function It(t,e){this.center=void 0!==t?t:new N,this.radius=void 0!==e?e:0}function Lt(){this.elements=new Float32Array([1,0,0,0,1,0,0,0,1]),arguments.length>0&&console.error("THREE.Matrix3: the constructor no longer reads arguments. use .set() instead.")}function Rt(t,e){this.normal=void 0!==t?t:new N(1,0,0),this.constant=void 0!==e?e:0}function Ot(t,e,i,n,r,o){this.planes=[void 0!==t?t:new Rt,void 0!==e?e:new Rt,void 0!==i?i:new Rt,void 0!==n?n:new Rt,void 0!==r?r:new Rt,void 0!==o?o:new Rt]}function Dt(t,e,i,n){function r(e,i,n,r){var o=e.geometry,a=null,s=b,c=e.customDepthMaterial;if(n&&(s=x,c=e.customDistanceMaterial),c)a=c;else{var u=!1;i.morphTargets&&(o&&o.isBufferGeometry?u=o.morphAttributes&&o.morphAttributes.position&&o.morphAttributes.position.length>0:o&&o.isGeometry&&(u=o.morphTargets&&o.morphTargets.length>0));var h=e.isSkinnedMesh&&i.skinning,l=0;u&&(l|=g),h&&(l|=v),a=s[l]}if(t.localClippingEnabled&&i.clipShadows===!0&&0!==i.clippingPlanes.length){var d=a.uuid,f=i.uuid,p=_[d];void 0===p&&(p={},_[d]=p);var m=p[f];void 0===m&&(m=a.clone(),p[f]=m),a=m}a.visible=i.visible,a.wireframe=i.wireframe;var y=i.side;return k.renderSingleSided&&y==hh&&(y=ch),k.renderReverseSided&&(y===ch?y=uh:y===uh&&(y=ch)),a.side=y,a.clipShadows=i.clipShadows,a.clippingPlanes=i.clippingPlanes,a.wireframeLinewidth=i.wireframeLinewidth,a.linewidth=i.linewidth,n&&void 0!==a.uniforms.lightPos&&a.uniforms.lightPos.value.copy(r),a}function o(t,e,i){if(t.visible!==!1){var n=0!==(t.layers.mask&e.layers.mask);if(n&&(t.isMesh||t.isLine||t.isPoints)&&t.castShadow&&(t.frustumCulled===!1||c.intersectsObject(t)===!0)){var r=t.material;r.visible===!0&&(t.modelViewMatrix.multiplyMatrices(i.matrixWorldInverse,t.matrixWorld),m.push(t))}for(var a=t.children,s=0,u=a.length;s<u;s++)o(a[s],e,i)}}var a=t.context,s=t.state,c=new Ot,u=new O,h=e.shadows,l=new I,d=new I(n.maxTextureSize,n.maxTextureSize),f=new N,p=new N,m=[],g=1,v=2,y=(g|v)+1,b=new Array(y),x=new Array(y),_={},w=[new N(1,0,0),new N(-1,0,0),new N(0,0,1),new N(0,0,-1),new N(0,1,0),new N(0,-1,0)],S=[new N(0,1,0),new N(0,1,0),new N(0,1,0),new N(0,1,0),new N(0,0,1),new N(0,0,-1)],A=[new _t,new _t,new _t,new _t,new _t,new _t],M=new Tt;M.depthPacking=ld,M.clipping=!0;for(var C=wp.distanceRGBA,P=xd.clone(C.uniforms),T=0;T!==y;++T){var E=0!==(T&g),L=0!==(T&v),R=M.clone();R.morphTargets=E,R.skinning=L,b[T]=R;var D=new Ct({defines:{USE_SHADOWMAP:""},uniforms:P,vertexShader:C.vertexShader,fragmentShader:C.fragmentShader,morphTargets:E,skinning:L,clipping:!0});x[T]=D}var k=this;this.enabled=!1,this.autoUpdate=!0,this.needsUpdate=!1,this.type=ah,this.renderReverseSided=!0,this.renderSingleSided=!0,this.render=function(e,n){if(k.enabled!==!1&&(k.autoUpdate!==!1||k.needsUpdate!==!1)&&0!==h.length){s.clearColor(1,1,1,1),s.disable(a.BLEND),s.setDepthTest(!0),s.setScissorTest(!1);for(var g,v,y=0,b=h.length;y<b;y++){var x=h[y],_=x.shadow;if(void 0!==_){var M=_.camera;if(l.copy(_.mapSize),l.min(d),x&&x.isPointLight){g=6,v=!0;var C=l.x,P=l.y;A[0].set(2*C,P,C,P),A[1].set(0,P,C,P),A[2].set(3*C,P,C,P),A[3].set(C,P,C,P),A[4].set(3*C,0,C,P),A[5].set(C,0,C,P),l.x*=4,l.y*=2}else g=1,v=!1;if(null===_.map){var T={minFilter:ll,magFilter:ll,format:Ll};_.map=new St(l.x,l.y,T),M.updateProjectionMatrix()}_&&_.isSpotLightShadow&&_.update(x);var E=_.map,I=_.matrix;p.setFromMatrixPosition(x.matrixWorld),M.position.copy(p),t.setRenderTarget(E),t.clear();for(var L=0;L<g;L++){if(v){f.copy(M.position),f.add(w[L]),M.up.copy(S[L]),M.lookAt(f);var R=A[L];s.viewport(R)}else f.setFromMatrixPosition(x.target.matrixWorld),M.lookAt(f);M.updateMatrixWorld(),M.matrixWorldInverse.getInverse(M.matrixWorld),I.set(.5,0,0,.5,0,.5,0,.5,0,0,.5,.5,0,0,0,1),I.multiply(M.projectionMatrix),I.multiply(M.matrixWorldInverse),u.multiplyMatrices(M.projectionMatrix,M.matrixWorldInverse),c.setFromMatrix(u),m.length=0,o(e,n,M);for(var O=0,D=m.length;O<D;O++){var N=m[O],F=i.update(N),z=N.material;if(z&&z.isMultiMaterial)for(var B=F.groups,U=z.materials,j=0,$=B.length;j<$;j++){var V=B[j],G=U[V.materialIndex];if(G.visible===!0){var H=r(N,G,v,p);t.renderBufferDirect(M,null,F,H,N,V)}}else{var H=r(N,z,v,p);t.renderBufferDirect(M,null,F,H,N,null)}}}}else console.warn("THREE.WebGLShadowMap:",x,"has no shadow.")}var W=t.getClearColor(),X=t.getClearAlpha();t.setClearColor(W,X),k.needsUpdate=!1}}}function Nt(t){for(var e=t.split("\n"),i=0;i<e.length;i++)e[i]=i+1+": "+e[i];return e.join("\n")}function kt(t,e,i){var n=t.createShader(e);return t.shaderSource(n,i),t.compileShader(n),t.getShaderParameter(n,t.COMPILE_STATUS)===!1&&console.error("THREE.WebGLShader: Shader couldn't compile."),""!==t.getShaderInfoLog(n)&&console.warn("THREE.WebGLShader: gl.getShaderInfoLog()",e===t.VERTEX_SHADER?"vertex":"fragment",t.getShaderInfoLog(n),Nt(i)),n}function Ft(){var t={};return{get:function(e){var i=e.uuid,n=t[i];return void 0===n&&(n={},t[i]=n),n},delete:function(e){delete t[e.uuid]},clear:function(){t={}}}}function zt(t){switch(t){case nd:return["Linear","( value )"];case rd:return["sRGB","( value )"];case ad:return["RGBE","( value )"];case sd:return["RGBM","( value, 7.0 )"];case cd:return["RGBM","( value, 16.0 )"];case ud:return["RGBD","( value, 256.0 )"];case od:return["Gamma","( value, float( GAMMA_FACTOR ) )"];default:throw new Error("unsupported encoding: "+t)}}function Bt(t,e){var i=zt(e);return"vec4 "+t+"( vec4 value ) { return "+i[0]+"ToLinear"+i[1]+"; }"}function Ut(t,e){var i=zt(e);return"vec4 "+t+"( vec4 value ) { return LinearTo"+i[0]+i[1]+"; }"}function jt(t,e){var i;switch(e){case Zh:i="Linear";break;case Kh:i="Reinhard";break;case Qh:i="Uncharted2";break;case Jh:i="OptimizedCineon";break;default:throw new Error("unsupported toneMapping: "+e)}return"vec3 "+t+"( vec3 color ) { return "+i+"ToneMapping( color ); }"}function $t(t,e,i){t=t||{};var n=[t.derivatives||e.envMapCubeUV||e.bumpMap||e.normalMap||e.flatShading?"#extension GL_OES_standard_derivatives : enable":"",(t.fragDepth||e.logarithmicDepthBuffer)&&i.get("EXT_frag_depth")?"#extension GL_EXT_frag_depth : enable":"",t.drawBuffers&&i.get("WEBGL_draw_buffers")?"#extension GL_EXT_draw_buffers : require":"",(t.shaderTextureLOD||e.envMap)&&i.get("EXT_shader_texture_lod")?"#extension GL_EXT_shader_texture_lod : enable":""];return n.filter(Ht).join("\n")}function Vt(t){var e=[];for(var i in t){var n=t[i];n!==!1&&e.push("#define "+i+" "+n)}return e.join("\n")}function Gt(t,e,i){for(var n={},r=t.getProgramParameter(e,t.ACTIVE_ATTRIBUTES),o=0;o<r;o++){var a=t.getActiveAttrib(e,o),s=a.name;n[s]=t.getAttribLocation(e,s)}return n}function Ht(t){return""!==t}function Wt(t,e){return t.replace(/NUM_DIR_LIGHTS/g,e.numDirLights).replace(/NUM_SPOT_LIGHTS/g,e.numSpotLights).replace(/NUM_POINT_LIGHTS/g,e.numPointLights).replace(/NUM_HEMI_LIGHTS/g,e.numHemiLights)}function Xt(t){function e(t,e){var i=bp[e];if(void 0===i)throw new Error("Can not resolve #include <"+e+">");return Xt(i)}var i=/#include +<([\w\d.]+)>/g;return t.replace(i,e)}function qt(t){function e(t,e,i,n){for(var r="",o=parseInt(e);o<parseInt(i);o++)r+=n.replace(/\[ i \]/g,"[ "+o+" ]");return r}var i=/for \( int i \= (\d+)\; i < (\d+)\; i \+\+ \) \{([\s\S]+?)(?=\})\}/g;return t.replace(i,e)}function Yt(t,e,i,n){var r=t.context,o=i.extensions,a=i.defines,s=i.__webglShader.vertexShader,c=i.__webglShader.fragmentShader,u="SHADOWMAP_TYPE_BASIC";n.shadowMapType===ah?u="SHADOWMAP_TYPE_PCF":n.shadowMapType===sh&&(u="SHADOWMAP_TYPE_PCF_SOFT");var h="ENVMAP_TYPE_CUBE",l="ENVMAP_MODE_REFLECTION",d="ENVMAP_BLENDING_MULTIPLY";if(n.envMap){switch(i.envMap.mapping){case el:case il:h="ENVMAP_TYPE_CUBE";break;case al:case sl:h="ENVMAP_TYPE_CUBE_UV";break;case nl:case rl:h="ENVMAP_TYPE_EQUIREC";break;case ol:h="ENVMAP_TYPE_SPHERE"}switch(i.envMap.mapping){case il:case rl:l="ENVMAP_MODE_REFRACTION"}switch(i.combine){case Wh:d="ENVMAP_BLENDING_MULTIPLY";break;case Xh:d="ENVMAP_BLENDING_MIX";break;case qh:d="ENVMAP_BLENDING_ADD"}}var f,p,m=t.gammaFactor>0?t.gammaFactor:1,g=$t(o,n,t.extensions),v=Vt(a),y=r.createProgram();i.isRawShaderMaterial?(f=[v,"\n"].filter(Ht).join("\n"),p=[g,v,"\n"].filter(Ht).join("\n")):(f=["precision "+n.precision+" float;","precision "+n.precision+" int;","#define SHADER_NAME "+i.__webglShader.name,v,n.supportsVertexTextures?"#define VERTEX_TEXTURES":"","#define GAMMA_FACTOR "+m,"#define MAX_BONES "+n.maxBones,n.map?"#define USE_MAP":"",n.envMap?"#define USE_ENVMAP":"",n.envMap?"#define "+l:"",n.lightMap?"#define USE_LIGHTMAP":"",n.aoMap?"#define USE_AOMAP":"",n.emissiveMap?"#define USE_EMISSIVEMAP":"",n.bumpMap?"#define USE_BUMPMAP":"",n.normalMap?"#define USE_NORMALMAP":"",n.displacementMap&&n.supportsVertexTextures?"#define USE_DISPLACEMENTMAP":"",n.specularMap?"#define USE_SPECULARMAP":"",n.roughnessMap?"#define USE_ROUGHNESSMAP":"",n.metalnessMap?"#define USE_METALNESSMAP":"",n.alphaMap?"#define USE_ALPHAMAP":"",n.vertexColors?"#define USE_COLOR":"",n.flatShading?"#define FLAT_SHADED":"",n.skinning?"#define USE_SKINNING":"",n.useVertexTexture?"#define BONE_TEXTURE":"",n.morphTargets?"#define USE_MORPHTARGETS":"",n.morphNormals&&n.flatShading===!1?"#define USE_MORPHNORMALS":"",n.doubleSided?"#define DOUBLE_SIDED":"",n.flipSided?"#define FLIP_SIDED":"","#define NUM_CLIPPING_PLANES "+n.numClippingPlanes,n.shadowMapEnabled?"#define USE_SHADOWMAP":"",n.shadowMapEnabled?"#define "+u:"",n.sizeAttenuation?"#define USE_SIZEATTENUATION":"",n.logarithmicDepthBuffer?"#define USE_LOGDEPTHBUF":"",n.logarithmicDepthBuffer&&t.extensions.get("EXT_frag_depth")?"#define USE_LOGDEPTHBUF_EXT":"","uniform mat4 modelMatrix;","uniform mat4 modelViewMatrix;","uniform mat4 projectionMatrix;","uniform mat4 viewMatrix;","uniform mat3 normalMatrix;","uniform vec3 cameraPosition;","attribute vec3 position;","attribute vec3 normal;","attribute vec2 uv;","#ifdef USE_COLOR","   attribute vec3 color;","#endif","#ifdef USE_MORPHTARGETS","   attribute vec3 morphTarget0;","   attribute vec3 morphTarget1;","   attribute vec3 morphTarget2;","   attribute vec3 morphTarget3;","   #ifdef USE_MORPHNORMALS","       attribute vec3 morphNormal0;","       attribute vec3 morphNormal1;","       attribute vec3 morphNormal2;","       attribute vec3 morphNormal3;","   #else","       attribute vec3 morphTarget4;","       attribute vec3 morphTarget5;","       attribute vec3 morphTarget6;","       attribute vec3 morphTarget7;","   #endif","#endif","#ifdef USE_SKINNING","   attribute vec4 skinIndex;","   attribute vec4 skinWeight;","#endif","\n"].filter(Ht).join("\n"),p=[g,"precision "+n.precision+" float;","precision "+n.precision+" int;","#define SHADER_NAME "+i.__webglShader.name,v,n.alphaTest?"#define ALPHATEST "+n.alphaTest:"","#define GAMMA_FACTOR "+m,n.useFog&&n.fog?"#define USE_FOG":"",n.useFog&&n.fogExp?"#define FOG_EXP2":"",n.map?"#define USE_MAP":"",n.envMap?"#define USE_ENVMAP":"",n.envMap?"#define "+h:"",n.envMap?"#define "+l:"",n.envMap?"#define "+d:"",n.lightMap?"#define USE_LIGHTMAP":"",n.aoMap?"#define USE_AOMAP":"",n.emissiveMap?"#define USE_EMISSIVEMAP":"",n.bumpMap?"#define USE_BUMPMAP":"",n.normalMap?"#define USE_NORMALMAP":"",n.specularMap?"#define USE_SPECULARMAP":"",n.roughnessMap?"#define USE_ROUGHNESSMAP":"",n.metalnessMap?"#define USE_METALNESSMAP":"",n.alphaMap?"#define USE_ALPHAMAP":"",n.vertexColors?"#define USE_COLOR":"",n.flatShading?"#define FLAT_SHADED":"",n.doubleSided?"#define DOUBLE_SIDED":"",n.flipSided?"#define FLIP_SIDED":"","#define NUM_CLIPPING_PLANES "+n.numClippingPlanes,n.shadowMapEnabled?"#define USE_SHADOWMAP":"",n.shadowMapEnabled?"#define "+u:"",n.premultipliedAlpha?"#define PREMULTIPLIED_ALPHA":"",n.physicallyCorrectLights?"#define PHYSICALLY_CORRECT_LIGHTS":"",n.logarithmicDepthBuffer?"#define USE_LOGDEPTHBUF":"",n.logarithmicDepthBuffer&&t.extensions.get("EXT_frag_depth")?"#define USE_LOGDEPTHBUF_EXT":"",n.envMap&&t.extensions.get("EXT_shader_texture_lod")?"#define TEXTURE_LOD_EXT":"","uniform mat4 viewMatrix;","uniform vec3 cameraPosition;",n.toneMapping!==Yh?"#define TONE_MAPPING":"",n.toneMapping!==Yh?bp.tonemapping_pars_fragment:"",n.toneMapping!==Yh?jt("toneMapping",n.toneMapping):"",n.outputEncoding||n.mapEncoding||n.envMapEncoding||n.emissiveMapEncoding?bp.encodings_pars_fragment:"",n.mapEncoding?Bt("mapTexelToLinear",n.mapEncoding):"",n.envMapEncoding?Bt("envMapTexelToLinear",n.envMapEncoding):"",n.emissiveMapEncoding?Bt("emissiveMapTexelToLinear",n.emissiveMapEncoding):"",n.outputEncoding?Ut("linearToOutputTexel",n.outputEncoding):"",n.depthPacking?"#define DEPTH_PACKING "+i.depthPacking:"","\n"].filter(Ht).join("\n")),s=Xt(s,n),s=Wt(s,n),c=Xt(c,n),c=Wt(c,n),i.isShaderMaterial||(s=qt(s),c=qt(c));var b=f+s,x=p+c,_=kt(r,r.VERTEX_SHADER,b),w=kt(r,r.FRAGMENT_SHADER,x);r.attachShader(y,_),r.attachShader(y,w),void 0!==i.index0AttributeName?r.bindAttribLocation(y,0,i.index0AttributeName):n.morphTargets===!0&&r.bindAttribLocation(y,0,"position"),r.linkProgram(y);var S=r.getProgramInfoLog(y),A=r.getShaderInfoLog(_),M=r.getShaderInfoLog(w),C=!0,P=!0;r.getProgramParameter(y,r.LINK_STATUS)===!1?(C=!1,console.error("THREE.WebGLProgram: shader error: ",r.getError(),"gl.VALIDATE_STATUS",r.getProgramParameter(y,r.VALIDATE_STATUS),"gl.getProgramInfoLog",S,A,M)):""!==S?console.warn("THREE.WebGLProgram: gl.getProgramInfoLog()",S):""!==A&&""!==M||(P=!1),P&&(this.diagnostics={runnable:C,material:i,programLog:S,vertexShader:{log:A,prefix:f},fragmentShader:{log:M,prefix:p}}),r.deleteShader(_),r.deleteShader(w);var T;this.getUniforms=function(){return void 0===T&&(T=new bt(r,y,t)),T};var E;return this.getAttributes=function(){return void 0===E&&(E=Gt(r,y)),E},this.destroy=function(){r.deleteProgram(y),this.program=void 0},Object.defineProperties(this,{uniforms:{get:function(){return console.warn("THREE.WebGLProgram: .uniforms is now .getUniforms()."),this.getUniforms()}},attributes:{get:function(){return console.warn("THREE.WebGLProgram: .attributes is now .getAttributes()."),this.getAttributes()}}}),this.id=Sp++,this.code=e,this.usedTimes=1,this.program=y,this.vertexShader=_,this.fragmentShader=w,this}function Zt(t,e){function i(t){if(e.floatVertexTextures&&t&&t.skeleton&&t.skeleton.useVertexTexture)return 1024;var i=e.maxVertexUniforms,n=Math.floor((i-20)/4),r=n;return void 0!==t&&t&&t.isSkinnedMesh&&(r=Math.min(t.skeleton.bones.length,r),r<t.skeleton.bones.length&&console.warn("WebGLRenderer: too many bones - "+t.skeleton.bones.length+", this GPU supports just "+r+" (try OpenGL instead of ANGLE)")),r}function n(t,e){var i;return t?t&&t.isTexture?i=t.encoding:t&&t.isWebGLRenderTarget&&(console.warn("THREE.WebGLPrograms.getTextureEncodingFromMap: don't use render targets as textures. Use their .texture property instead."),i=t.texture.encoding):i=nd,i===nd&&e&&(i=od),i}var r=[],o={MeshDepthMaterial:"depth",MeshNormalMaterial:"normal",MeshBasicMaterial:"basic",MeshLambertMaterial:"lambert",MeshPhongMaterial:"phong",MeshStandardMaterial:"physical",MeshPhysicalMaterial:"physical",LineBasicMaterial:"basic",LineDashedMaterial:"dashed",PointsMaterial:"points"},a=["precision","supportsVertexTextures","map","mapEncoding","envMap","envMapMode","envMapEncoding","lightMap","aoMap","emissiveMap","emissiveMapEncoding","bumpMap","normalMap","displacementMap","specularMap","roughnessMap","metalnessMap","alphaMap","combine","vertexColors","fog","useFog","fogExp","flatShading","sizeAttenuation","logarithmicDepthBuffer","skinning","maxBones","useVertexTexture","morphTargets","morphNormals","maxMorphTargets","maxMorphNormals","premultipliedAlpha","numDirLights","numPointLights","numSpotLights","numHemiLights","shadowMapEnabled","shadowMapType","toneMapping","physicallyCorrectLights","alphaTest","doubleSided","flipSided","numClippingPlanes","depthPacking"];this.getParameters=function(r,a,s,c,u){var h=o[r.type],l=i(u),d=t.getPrecision();null!==r.precision&&(d=e.getMaxPrecision(r.precision),d!==r.precision&&console.warn("THREE.WebGLProgram.getParameters:",r.precision,"not supported, using",d,"instead."));var f=t.getCurrentRenderTarget(),p={shaderID:h,precision:d,supportsVertexTextures:e.vertexTextures,outputEncoding:n(f?f.texture:null,t.gammaOutput),map:!!r.map,mapEncoding:n(r.map,t.gammaInput),envMap:!!r.envMap,envMapMode:r.envMap&&r.envMap.mapping,envMapEncoding:n(r.envMap,t.gammaInput),envMapCubeUV:!!r.envMap&&(r.envMap.mapping===al||r.envMap.mapping===sl),lightMap:!!r.lightMap,aoMap:!!r.aoMap,emissiveMap:!!r.emissiveMap,emissiveMapEncoding:n(r.emissiveMap,t.gammaInput),bumpMap:!!r.bumpMap,normalMap:!!r.normalMap,displacementMap:!!r.displacementMap,roughnessMap:!!r.roughnessMap,metalnessMap:!!r.metalnessMap,specularMap:!!r.specularMap,alphaMap:!!r.alphaMap,combine:r.combine,vertexColors:r.vertexColors,fog:!!s,useFog:r.fog,fogExp:s&&s.isFogExp2,flatShading:r.shading===lh,sizeAttenuation:r.sizeAttenuation,logarithmicDepthBuffer:e.logarithmicDepthBuffer,skinning:r.skinning,maxBones:l,useVertexTexture:e.floatVertexTextures&&u&&u.skeleton&&u.skeleton.useVertexTexture,morphTargets:r.morphTargets,morphNormals:r.morphNormals,maxMorphTargets:t.maxMorphTargets,maxMorphNormals:t.maxMorphNormals,numDirLights:a.directional.length,numPointLights:a.point.length,numSpotLights:a.spot.length,numHemiLights:a.hemi.length,numClippingPlanes:c,shadowMapEnabled:t.shadowMap.enabled&&u.receiveShadow&&a.shadows.length>0,shadowMapType:t.shadowMap.type,toneMapping:t.toneMapping,physicallyCorrectLights:t.physicallyCorrectLights,premultipliedAlpha:r.premultipliedAlpha,alphaTest:r.alphaTest,doubleSided:r.side===hh,flipSided:r.side===uh,depthPacking:void 0!==r.depthPacking&&r.depthPacking};return p},this.getProgramCode=function(t,e){var i=[];if(e.shaderID?i.push(e.shaderID):(i.push(t.fragmentShader),i.push(t.vertexShader)),void 0!==t.defines)for(var n in t.defines)i.push(n),i.push(t.defines[n]);for(var r=0;r<a.length;r++)i.push(e[a[r]]);return i.join()},this.acquireProgram=function(e,i,n){for(var o,a=0,s=r.length;a<s;a++){var c=r[a];if(c.code===n){o=c,++o.usedTimes;break}}return void 0===o&&(o=new Yt(t,n,e,i),r.push(o)),o},this.releaseProgram=function(t){if(0===--t.usedTimes){var e=r.indexOf(t);r[e]=r[r.length-1],r.pop(),t.destroy()}},this.programs=r}function Kt(t,e,i){if(Array.isArray(t))throw new TypeError("THREE.BufferAttribute: array should be a Typed Array.");this.uuid=dd.generateUUID(),this.array=t,this.itemSize=e,this.normalized=i===!0,this.dynamic=!1,this.updateRange={offset:0,count:-1},this.version=0}function Qt(t,e){return new Kt(new Uint16Array(t),e)}function Jt(t,e){return new Kt(new Uint32Array(t),e)}function te(t,e){return new Kt(new Float32Array(t),e)}function ee(t,e,i,n,r,o){this.a=t,this.b=e,this.c=i,this.normal=n&&n.isVector3?n:new N,this.vertexNormals=Array.isArray(n)?n:[],this.color=r&&r.isColor?r:new Pt,this.vertexColors=Array.isArray(r)?r:[],this.materialIndex=void 0!==o?o:0}function ie(t,e,i,n){this._x=t||0,this._y=e||0,this._z=i||0,this._order=n||ie.DefaultOrder}function ne(){this.mask=1}function re(){function t(){r.setFromEuler(n,!1)}function e(){n.setFromQuaternion(r,void 0,!1)}Object.defineProperty(this,"id",{value:oe()}),this.uuid=dd.generateUUID(),this.name="",this.type="Object3D",this.parent=null,this.children=[],this.up=re.DefaultUp.clone();var i=new N,n=new ie,r=new D,o=new N(1,1,1);n.onChange(t),r.onChange(e),Object.defineProperties(this,{position:{enumerable:!0,value:i},rotation:{enumerable:!0,value:n},quaternion:{enumerable:!0,value:r},scale:{enumerable:!0,value:o},modelViewMatrix:{value:new O},normalMatrix:{value:new Lt}}),this.matrix=new O,this.matrixWorld=new O,this.matrixAutoUpdate=re.DefaultMatrixAutoUpdate,this.matrixWorldNeedsUpdate=!1,this.layers=new ne,this.visible=!0,this.castShadow=!1,this.receiveShadow=!1,this.frustumCulled=!0,this.renderOrder=0,this.userData={}}function oe(){return Ap++}function ae(){Object.defineProperty(this,"id",{value:se()}),this.uuid=dd.generateUUID(),this.name="",this.type="Geometry",this.vertices=[],this.colors=[],this.faces=[],this.faceVertexUvs=[[]],this.morphTargets=[],this.morphNormals=[],this.skinWeights=[],this.skinIndices=[],this.lineDistances=[],this.boundingBox=null,this.boundingSphere=null,this.elementsNeedUpdate=!1,this.verticesNeedUpdate=!1,this.uvsNeedUpdate=!1,this.normalsNeedUpdate=!1,this.colorsNeedUpdate=!1,this.lineDistancesNeedUpdate=!1,this.groupsNeedUpdate=!1}function se(){return Mp++}function ce(){Object.defineProperty(this,"id",{value:se()}),this.uuid=dd.generateUUID(),this.name="",this.type="DirectGeometry",this.indices=[],this.vertices=[],this.normals=[],this.colors=[],this.uvs=[],this.uvs2=[],this.groups=[],this.morphTargets={},this.skinWeights=[],this.skinIndices=[],this.boundingBox=null,this.boundingSphere=null,this.verticesNeedUpdate=!1,this.normalsNeedUpdate=!1,this.colorsNeedUpdate=!1,this.uvsNeedUpdate=!1,this.groupsNeedUpdate=!1}function ue(){Object.defineProperty(this,"id",{value:se()}),this.uuid=dd.generateUUID(),this.name="",this.type="BufferGeometry",this.index=null,this.attributes={},this.morphAttributes={},this.groups=[],this.boundingBox=null,this.boundingSphere=null,this.drawRange={start:0,count:1/0}}function he(t,e,i){function n(t){var r=t.target,s=c[r.id];null!==s.index&&o(s.index),a(s.attributes),r.removeEventListener("dispose",n),delete c[r.id];var u=e.get(r);u.wireframe&&o(u.wireframe),e.delete(r);var h=e.get(s);h.wireframe&&o(h.wireframe),e.delete(s),i.memory.geometries--}function r(t){return t.isInterleavedBufferAttribute?e.get(t.data).__webglBuffer:e.get(t).__webglBuffer}function o(e){var i=r(e);void 0!==i&&(t.deleteBuffer(i),s(e))}function a(t){for(var e in t)o(t[e])}function s(t){t.isInterleavedBufferAttribute?e.delete(t.data):e.delete(t)}var c={};return{get:function(t){var e=t.geometry;if(void 0!==c[e.id])return c[e.id];e.addEventListener("dispose",n);var r;return e.isBufferGeometry?r=e:e.isGeometry&&(void 0===e._bufferGeometry&&(e._bufferGeometry=(new ue).setFromObject(t)),r=e._bufferGeometry),c[e.id]=r,i.memory.geometries++,r}}}function le(t,e,i){function n(e){var i=h.get(e);e.geometry.isGeometry&&i.updateFromObject(e);var n=i.index,o=i.attributes;null!==n&&r(n,t.ELEMENT_ARRAY_BUFFER);for(var a in o)r(o[a],t.ARRAY_BUFFER);var s=i.morphAttributes;for(var a in s)for(var c=s[a],u=0,l=c.length;u<l;u++)r(c[u],t.ARRAY_BUFFER);return i}function r(t,i){var n=t.isInterleavedBufferAttribute?t.data:t,r=e.get(n);void 0===r.__webglBuffer?o(r,n,i):r.version!==n.version&&a(r,n,i)}function o(e,i,n){e.__webglBuffer=t.createBuffer(),t.bindBuffer(n,e.__webglBuffer);var r=i.dynamic?t.DYNAMIC_DRAW:t.STATIC_DRAW;t.bufferData(n,i.array,r),e.version=i.version}function a(e,i,n){t.bindBuffer(n,e.__webglBuffer),i.dynamic===!1||i.updateRange.count===-1?t.bufferSubData(n,0,i.array):0===i.updateRange.count?console.error("THREE.WebGLObjects.updateBuffer: dynamic THREE.BufferAttribute marked as needsUpdate but updateRange.count is 0, ensure you are using set methods or updating manually."):(t.bufferSubData(n,i.updateRange.offset*i.array.BYTES_PER_ELEMENT,i.array.subarray(i.updateRange.offset,i.updateRange.offset+i.updateRange.count)),i.updateRange.count=0),e.version=i.version}function s(t){return t.isInterleavedBufferAttribute?e.get(t.data).__webglBuffer:e.get(t).__webglBuffer}function c(i){var n=e.get(i);if(void 0!==n.wireframe)return n.wireframe;var o=[],a=i.index,s=i.attributes,c=s.position;if(null!==a)for(var h={},l=a.array,d=0,f=l.length;d<f;d+=3){
	var p=l[d+0],m=l[d+1],g=l[d+2];u(h,p,m)&&o.push(p,m),u(h,m,g)&&o.push(m,g),u(h,g,p)&&o.push(g,p)}else for(var l=s.position.array,d=0,f=l.length/3-1;d<f;d+=3){var p=d+0,m=d+1,g=d+2;o.push(p,m,m,g,g,p)}var v=c.count>65535?Uint32Array:Uint16Array,y=new Kt(new v(o),1);return r(y,t.ELEMENT_ARRAY_BUFFER),n.wireframe=y,y}function u(t,e,i){if(e>i){var n=e;e=i,i=n}var r=t[e];return void 0===r?(t[e]=[i],!0):r.indexOf(i)===-1&&(r.push(i),!0)}var h=new he(t,e,i);return{getAttributeBuffer:s,getWireframeAttribute:c,update:n}}function de(){var t={};return{get:function(e){if(void 0!==t[e.id])return t[e.id];var i;switch(e.type){case"DirectionalLight":i={direction:new N,color:new Pt,shadow:!1,shadowBias:0,shadowRadius:1,shadowMapSize:new I};break;case"SpotLight":i={position:new N,direction:new N,color:new Pt,distance:0,coneCos:0,penumbraCos:0,decay:0,shadow:!1,shadowBias:0,shadowRadius:1,shadowMapSize:new I};break;case"PointLight":i={position:new N,color:new Pt,distance:0,decay:0,shadow:!1,shadowBias:0,shadowRadius:1,shadowMapSize:new I};break;case"HemisphereLight":i={direction:new N,skyColor:new Pt,groundColor:new Pt}}return t[e.id]=i,i}}}function fe(t,e,i){function n(){if(void 0!==o)return o;var i=e.get("EXT_texture_filter_anisotropic");return o=null!==i?t.getParameter(i.MAX_TEXTURE_MAX_ANISOTROPY_EXT):0}function r(e){if("highp"===e){if(t.getShaderPrecisionFormat(t.VERTEX_SHADER,t.HIGH_FLOAT).precision>0&&t.getShaderPrecisionFormat(t.FRAGMENT_SHADER,t.HIGH_FLOAT).precision>0)return"highp";e="mediump"}return"mediump"===e&&t.getShaderPrecisionFormat(t.VERTEX_SHADER,t.MEDIUM_FLOAT).precision>0&&t.getShaderPrecisionFormat(t.FRAGMENT_SHADER,t.MEDIUM_FLOAT).precision>0?"mediump":"lowp"}var o,a=void 0!==i.precision?i.precision:"highp",s=r(a);s!==a&&(console.warn("THREE.WebGLRenderer:",a,"not supported, using",s,"instead."),a=s);var c=i.logarithmicDepthBuffer===!0&&!!e.get("EXT_frag_depth"),u=t.getParameter(t.MAX_TEXTURE_IMAGE_UNITS),h=t.getParameter(t.MAX_VERTEX_TEXTURE_IMAGE_UNITS),l=t.getParameter(t.MAX_TEXTURE_SIZE),d=t.getParameter(t.MAX_CUBE_MAP_TEXTURE_SIZE),f=t.getParameter(t.MAX_VERTEX_ATTRIBS),p=t.getParameter(t.MAX_VERTEX_UNIFORM_VECTORS),m=t.getParameter(t.MAX_VARYING_VECTORS),g=t.getParameter(t.MAX_FRAGMENT_UNIFORM_VECTORS),v=h>0,y=!!e.get("OES_texture_float"),b=v&&y;return{getMaxAnisotropy:n,getMaxPrecision:r,precision:a,logarithmicDepthBuffer:c,maxTextures:u,maxVertexTextures:h,maxTextureSize:l,maxCubemapSize:d,maxAttributes:f,maxVertexUniforms:p,maxVaryings:m,maxFragmentUniforms:g,vertexTextures:v,floatFragmentTextures:y,floatVertexTextures:b}}function pe(t){var e={};return{get:function(i){if(void 0!==e[i])return e[i];var n;switch(i){case"WEBGL_depth_texture":n=t.getExtension("WEBGL_depth_texture")||t.getExtension("MOZ_WEBGL_depth_texture")||t.getExtension("WEBKIT_WEBGL_depth_texture");break;case"EXT_texture_filter_anisotropic":n=t.getExtension("EXT_texture_filter_anisotropic")||t.getExtension("MOZ_EXT_texture_filter_anisotropic")||t.getExtension("WEBKIT_EXT_texture_filter_anisotropic");break;case"WEBGL_compressed_texture_s3tc":n=t.getExtension("WEBGL_compressed_texture_s3tc")||t.getExtension("MOZ_WEBGL_compressed_texture_s3tc")||t.getExtension("WEBKIT_WEBGL_compressed_texture_s3tc");break;case"WEBGL_compressed_texture_pvrtc":n=t.getExtension("WEBGL_compressed_texture_pvrtc")||t.getExtension("WEBKIT_WEBGL_compressed_texture_pvrtc");break;case"WEBGL_compressed_texture_etc1":n=t.getExtension("WEBGL_compressed_texture_etc1");break;default:n=t.getExtension(i)}return null===n&&console.warn("THREE.WebGLRenderer: "+i+" extension not supported."),e[i]=n,n}}}function me(t,e,i){function n(t){s=t}function r(i){i.array instanceof Uint32Array&&e.get("OES_element_index_uint")?(c=t.UNSIGNED_INT,u=4):(c=t.UNSIGNED_SHORT,u=2)}function o(e,n){t.drawElements(s,n,c,e*u),i.calls++,i.vertices+=n,s===t.TRIANGLES&&(i.faces+=n/3)}function a(n,r,o){var a=e.get("ANGLE_instanced_arrays");return null===a?void console.error("THREE.WebGLBufferRenderer: using THREE.InstancedBufferGeometry but hardware does not support extension ANGLE_instanced_arrays."):(a.drawElementsInstancedANGLE(s,o,c,r*u,n.maxInstancedCount),i.calls++,i.vertices+=o*n.maxInstancedCount,void(s===t.TRIANGLES&&(i.faces+=n.maxInstancedCount*o/3)))}var s,c,u;return{setMode:n,setIndex:r,render:o,renderInstances:a}}function ge(){function t(){u.value!==n&&(u.value=n,u.needsUpdate=r>0),i.numPlanes=r}function e(t,e,n,r){var o=null!==t?t.length:0,a=null;if(0!==o){if(a=u.value,r!==!0||null===a){var h=n+4*o,l=e.matrixWorldInverse;c.getNormalMatrix(l),(null===a||a.length<h)&&(a=new Float32Array(h));for(var d=0,f=n;d!==o;++d,f+=4)s.copy(t[d]).applyMatrix4(l,c),s.normal.toArray(a,f),a[f+3]=s.constant}u.value=a,u.needsUpdate=!0}return i.numPlanes=o,a}var i=this,n=null,r=0,o=!1,a=!1,s=new Rt,c=new Lt,u={value:null,needsUpdate:!1};this.uniform=u,this.numPlanes=0,this.init=function(t,i,a){var s=0!==t.length||i||0!==r||o;return o=i,n=e(t,a,0),r=t.length,s},this.beginShadows=function(){a=!0,e(null)},this.endShadows=function(){a=!1,t()},this.setState=function(i,s,c,h,l){if(!o||null===i||0===i.length||a&&!s)a?e(null):t();else{var d=a?0:r,f=4*d,p=h.clippingState||null;u.value=p,p=e(i,c,f,l);for(var m=0;m!==f;++m)p[m]=n[m];h.clippingState=p,this.numPlanes+=d}}}function ve(t,e,i){function n(t){a=t}function r(e,n){t.drawArrays(a,e,n),i.calls++,i.vertices+=n,a===t.TRIANGLES&&(i.faces+=n/3)}function o(n){var r=e.get("ANGLE_instanced_arrays");if(null===r)return void console.error("THREE.WebGLBufferRenderer: using THREE.InstancedBufferGeometry but hardware does not support extension ANGLE_instanced_arrays.");var o=n.attributes.position,s=0;o&&o.isInterleavedBufferAttribute?(s=o.data.count,r.drawArraysInstancedANGLE(a,0,s,n.maxInstancedCount)):(s=o.count,r.drawArraysInstancedANGLE(a,0,s,n.maxInstancedCount)),i.calls++,i.vertices+=s*n.maxInstancedCount,a===t.TRIANGLES&&(i.faces+=n.maxInstancedCount*s/3)}var a;return{setMode:n,render:r,renderInstances:o}}function ye(t,e,i,n,r,o){function a(t,e,i){var n=0;return n+=(t+1)*(e+1)*2,n+=(t+1)*(i+1)*2,n+=(i+1)*(e+1)*2}function s(t,e,i){var n=0;return n+=t*e*2,n+=t*i*2,n+=i*e*2,6*n}function c(t,e,i,n,r,o,a,s,c,h,l){for(var _=o/c,w=a/h,S=o/2,A=a/2,M=s/2,C=c+1,P=h+1,T=0,E=0,I=new N,L=0;L<P;L++)for(var R=L*w-A,O=0;O<C;O++){var D=O*_-S;I[t]=D*n,I[e]=R*r,I[i]=M,f[g]=I.x,f[g+1]=I.y,f[g+2]=I.z,I[t]=0,I[e]=0,I[i]=s>0?1:-1,p[g]=I.x,p[g+1]=I.y,p[g+2]=I.z,m[v]=O/c,m[v+1]=1-L/h,g+=3,v+=2,T+=1}for(L=0;L<h;L++)for(O=0;O<c;O++){var k=b+O+C*L,F=b+O+C*(L+1),z=b+(O+1)+C*(L+1),B=b+(O+1)+C*L;d[y]=k,d[y+1]=F,d[y+2]=B,d[y+3]=F,d[y+4]=z,d[y+5]=B,y+=6,E+=6}u.addGroup(x,E,l),x+=E,b+=T}ue.call(this),this.type="BoxBufferGeometry",this.parameters={width:t,height:e,depth:i,widthSegments:n,heightSegments:r,depthSegments:o};var u=this;n=Math.floor(n)||1,r=Math.floor(r)||1,o=Math.floor(o)||1;var h=a(n,r,o),l=s(n,r,o),d=new(l>65535?Uint32Array:Uint16Array)(l),f=new Float32Array(3*h),p=new Float32Array(3*h),m=new Float32Array(2*h),g=0,v=0,y=0,b=0,x=0;c("z","y","x",-1,-1,i,e,t,o,r,0),c("z","y","x",1,-1,i,e,-t,o,r,1),c("x","z","y",1,1,t,i,e,n,o,2),c("x","z","y",1,-1,t,i,-e,n,o,3),c("x","y","z",1,-1,t,e,i,n,r,4),c("x","y","z",-1,-1,t,e,-i,n,r,5),this.setIndex(new Kt(d,1)),this.addAttribute("position",new Kt(f,3)),this.addAttribute("normal",new Kt(p,3)),this.addAttribute("uv",new Kt(m,2))}function be(t,e){this.origin=void 0!==t?t:new N,this.direction=void 0!==e?e:new N}function xe(t,e){this.start=void 0!==t?t:new N,this.end=void 0!==e?e:new N}function _e(t,e,i){this.a=void 0!==t?t:new N,this.b=void 0!==e?e:new N,this.c=void 0!==i?i:new N}function we(t){At.call(this),this.type="MeshBasicMaterial",this.color=new Pt(16777215),this.map=null,this.aoMap=null,this.aoMapIntensity=1,this.specularMap=null,this.alphaMap=null,this.envMap=null,this.combine=Wh,this.reflectivity=1,this.refractionRatio=.98,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinecap="round",this.wireframeLinejoin="round",this.skinning=!1,this.morphTargets=!1,this.lights=!1,this.setValues(t)}function Se(t,e){re.call(this),this.type="Mesh",this.geometry=void 0!==t?t:new ue,this.material=void 0!==e?e:new we({color:16777215*Math.random()}),this.drawMode=td,this.updateMorphTargets()}function Ae(t,e,i,n){ue.call(this),this.type="PlaneBufferGeometry",this.parameters={width:t,height:e,widthSegments:i,heightSegments:n};for(var r=t/2,o=e/2,a=Math.floor(i)||1,s=Math.floor(n)||1,c=a+1,u=s+1,h=t/a,l=e/s,d=new Float32Array(c*u*3),f=new Float32Array(c*u*3),p=new Float32Array(c*u*2),m=0,g=0,v=0;v<u;v++)for(var y=v*l-o,b=0;b<c;b++){var x=b*h-r;d[m]=x,d[m+1]=-y,f[m+2]=1,p[g]=b/a,p[g+1]=1-v/s,m+=3,g+=2}m=0;for(var _=new(d.length/3>65535?Uint32Array:Uint16Array)(a*s*6),v=0;v<s;v++)for(var b=0;b<a;b++){var w=b+c*v,S=b+c*(v+1),A=b+1+c*(v+1),M=b+1+c*v;_[m]=w,_[m+1]=S,_[m+2]=M,_[m+3]=S,_[m+4]=A,_[m+5]=M,m+=6}this.setIndex(new Kt(_,1)),this.addAttribute("position",new Kt(d,3)),this.addAttribute("normal",new Kt(f,3)),this.addAttribute("uv",new Kt(p,2))}function Me(){re.call(this),this.type="Camera",this.matrixWorldInverse=new O,this.projectionMatrix=new O}function Ce(t,e,i,n){Me.call(this),this.type="PerspectiveCamera",this.fov=void 0!==t?t:50,this.zoom=1,this.near=void 0!==i?i:.1,this.far=void 0!==n?n:2e3,this.focus=10,this.aspect=void 0!==e?e:1,this.view=null,this.filmGauge=35,this.filmOffset=0,this.updateProjectionMatrix()}function Pe(t,e,i,n,r,o){Me.call(this),this.type="OrthographicCamera",this.zoom=1,this.view=null,this.left=t,this.right=e,this.top=i,this.bottom=n,this.near=void 0!==r?r:.1,this.far=void 0!==o?o:2e3,this.updateProjectionMatrix()}function Te(t){function e(){return null===rt?vt:1}function i(t,e,i,n){W===!0&&(t*=n,e*=n,i*=n),Gt.clearColor(t,e,i,n)}function n(){Gt.init(),Gt.scissor(ut.copy(yt).multiplyScalar(vt)),Gt.viewport(lt.copy(At).multiplyScalar(vt)),i(ft.r,ft.g,ft.b,pt)}function r(){nt=null,ct=null,st="",at=-1,Gt.reset()}function o(t){t.preventDefault(),r(),n(),Ht.clear()}function a(t){var e=t.target;e.removeEventListener("dispose",a),s(e)}function s(t){c(t),Ht.delete(t)}function c(t){var e=Ht.get(t).program;t.program=void 0,void 0!==e&&qt.releaseProgram(e)}function u(t,e,i,n){var r;if(i&&i.isInstancedBufferGeometry&&(r=$t.get("ANGLE_instanced_arrays"),null===r))return void console.error("THREE.WebGLRenderer.setupVertexAttributes: using THREE.InstancedBufferGeometry but hardware does not support extension ANGLE_instanced_arrays.");void 0===n&&(n=0),Gt.initAttributes();var o=i.attributes,a=e.getAttributes(),s=t.defaultAttributeValues;for(var c in a){var u=a[c];if(u>=0){var h=o[c];if(void 0!==h){var l=Ut.FLOAT,d=h.array,f=h.normalized;d instanceof Float32Array?l=Ut.FLOAT:d instanceof Float64Array?console.warn("Unsupported data buffer format: Float64Array"):d instanceof Uint16Array?l=Ut.UNSIGNED_SHORT:d instanceof Int16Array?l=Ut.SHORT:d instanceof Uint32Array?l=Ut.UNSIGNED_INT:d instanceof Int32Array?l=Ut.INT:d instanceof Int8Array?l=Ut.BYTE:d instanceof Uint8Array&&(l=Ut.UNSIGNED_BYTE);var p=h.itemSize,m=Xt.getAttributeBuffer(h);if(h&&h.isInterleavedBufferAttribute){var g=h.data,v=g.stride,y=h.offset;g&&g.isInstancedInterleavedBuffer?(Gt.enableAttributeAndDivisor(u,g.meshPerAttribute,r),void 0===i.maxInstancedCount&&(i.maxInstancedCount=g.meshPerAttribute*g.count)):Gt.enableAttribute(u),Ut.bindBuffer(Ut.ARRAY_BUFFER,m),Ut.vertexAttribPointer(u,p,l,f,v*g.array.BYTES_PER_ELEMENT,(n*v+y)*g.array.BYTES_PER_ELEMENT)}else h&&h.isInstancedBufferAttribute?(Gt.enableAttributeAndDivisor(u,h.meshPerAttribute,r),void 0===i.maxInstancedCount&&(i.maxInstancedCount=h.meshPerAttribute*h.count)):Gt.enableAttribute(u),Ut.bindBuffer(Ut.ARRAY_BUFFER,m),Ut.vertexAttribPointer(u,p,l,f,0,n*p*h.array.BYTES_PER_ELEMENT)}else if(void 0!==s){var b=s[c];if(void 0!==b)switch(b.length){case 2:Ut.vertexAttrib2fv(u,b);break;case 3:Ut.vertexAttrib3fv(u,b);break;case 4:Ut.vertexAttrib4fv(u,b);break;default:Ut.vertexAttrib1fv(u,b)}}}}Gt.disableUnusedAttributes()}function h(t,e){return Math.abs(e[0])-Math.abs(t[0])}function l(t,e){return t.object.renderOrder!==e.object.renderOrder?t.object.renderOrder-e.object.renderOrder:t.material.program&&e.material.program&&t.material.program!==e.material.program?t.material.program.id-e.material.program.id:t.material.id!==e.material.id?t.material.id-e.material.id:t.z!==e.z?t.z-e.z:t.id-e.id}function d(t,e){return t.object.renderOrder!==e.object.renderOrder?t.object.renderOrder-e.object.renderOrder:t.z!==e.z?e.z-t.z:t.id-e.id}function f(t,e,i,n,r){var o,a;i.transparent?(o=K,a=++Q):(o=Y,a=++Z);var s=o[a];void 0!==s?(s.id=t.id,s.object=t,s.geometry=e,s.material=i,s.z=kt.z,s.group=r):(s={id:t.id,object:t,geometry:e,material:i,z:kt.z,group:r},o.push(s))}function p(t){var e=t.geometry;return null===e.boundingSphere&&e.computeBoundingSphere(),Rt.copy(e.boundingSphere).applyMatrix4(t.matrixWorld),g(Rt)}function m(t){return Rt.center.set(0,0,0),Rt.radius=.7071067811865476,Rt.applyMatrix4(t.matrixWorld),g(Rt)}function g(t){if(!Mt.intersectsSphere(t))return!1;var e=Tt.numPlanes;if(0===e)return!0;var i=it.clippingPlanes,n=t.center,r=-t.radius,o=0;do if(i[o].distanceToPoint(n)<r)return!1;while(++o!==e);return!0}function v(t,e){if(t.visible!==!1){var i=0!==(t.layers.mask&e.layers.mask);if(i)if(t.isLight)q.push(t);else if(t.isSprite)t.frustumCulled!==!1&&m(t)!==!0||tt.push(t);else if(t.isLensFlare)et.push(t);else if(t.isImmediateRenderObject)it.sortObjects===!0&&(kt.setFromMatrixPosition(t.matrixWorld),kt.applyProjection(Nt)),f(t,null,t.material,kt.z,null);else if((t.isMesh||t.isLine||t.isPoints)&&(t.isSkinnedMesh&&t.skeleton.update(),t.frustumCulled===!1||p(t)===!0)){var n=t.material;if(n.visible===!0){it.sortObjects===!0&&(kt.setFromMatrixPosition(t.matrixWorld),kt.applyProjection(Nt));var r=Xt.update(t);if(n.isMultiMaterial)for(var o=r.groups,a=n.materials,s=0,c=o.length;s<c;s++){var u=o[s],h=a[u.materialIndex];h.visible===!0&&f(t,r,h,kt.z,u)}else f(t,r,n,kt.z,null)}}for(var l=t.children,s=0,c=l.length;s<c;s++)v(l[s],e)}}function y(t,e,i,n){for(var r=0,o=t.length;r<o;r++){var a=t[r],s=a.object,c=a.geometry,u=void 0===n?a.material:n,h=a.group;if(s.modelViewMatrix.multiplyMatrices(e.matrixWorldInverse,s.matrixWorld),s.normalMatrix.getNormalMatrix(s.modelViewMatrix),s.isImmediateRenderObject){x(u);var l=_(e,i,u,s);st="",s.render(function(t){it.renderBufferImmediate(t,l,u)})}else it.renderBufferDirect(e,i,c,u,s,h)}}function b(t,e,i){var n=Ht.get(t),r=qt.getParameters(t,zt,e,Tt.numPlanes,i),o=qt.getProgramCode(t,r),s=n.program,u=!0;if(void 0===s)t.addEventListener("dispose",a);else if(s.code!==o)c(t);else{if(void 0!==r.shaderID)return;u=!1}if(u){if(r.shaderID){var h=wp[r.shaderID];n.__webglShader={name:t.type,uniforms:xd.clone(h.uniforms),vertexShader:h.vertexShader,fragmentShader:h.fragmentShader}}else n.__webglShader={name:t.type,uniforms:t.uniforms,vertexShader:t.vertexShader,fragmentShader:t.fragmentShader};t.__webglShader=n.__webglShader,s=qt.acquireProgram(t,r,o),n.program=s,t.program=s}var l=s.getAttributes();if(t.morphTargets){t.numSupportedMorphTargets=0;for(var d=0;d<it.maxMorphTargets;d++)l["morphTarget"+d]>=0&&t.numSupportedMorphTargets++}if(t.morphNormals){t.numSupportedMorphNormals=0;for(var d=0;d<it.maxMorphNormals;d++)l["morphNormal"+d]>=0&&t.numSupportedMorphNormals++}var f=n.__webglShader.uniforms;!t.isShaderMaterial&&!t.isRawShaderMaterial|t.clipping===!0&&(n.numClippingPlanes=Tt.numPlanes,f.clippingPlanes=Tt.uniform),n.fog=e,n.lightsHash=zt.hash,t.lights&&(f.ambientLightColor.value=zt.ambient,f.directionalLights.value=zt.directional,f.spotLights.value=zt.spot,f.pointLights.value=zt.point,f.hemisphereLights.value=zt.hemi,f.directionalShadowMap.value=zt.directionalShadowMap,f.directionalShadowMatrix.value=zt.directionalShadowMatrix,f.spotShadowMap.value=zt.spotShadowMap,f.spotShadowMatrix.value=zt.spotShadowMatrix,f.pointShadowMap.value=zt.pointShadowMap,f.pointShadowMatrix.value=zt.pointShadowMatrix);var p=n.program.getUniforms(),m=bt.seqWithValue(p.seq,f);n.uniformsList=m,n.dynamicUniforms=bt.splitDynamic(m,f)}function x(t){t.side===hh?Gt.disable(Ut.CULL_FACE):Gt.enable(Ut.CULL_FACE),Gt.setFlipSided(t.side===uh),t.transparent===!0?Gt.setBlending(t.blending,t.blendEquation,t.blendSrc,t.blendDst,t.blendEquationAlpha,t.blendSrcAlpha,t.blendDstAlpha,t.premultipliedAlpha):Gt.setBlending(gh),Gt.setDepthFunc(t.depthFunc),Gt.setDepthTest(t.depthTest),Gt.setDepthWrite(t.depthWrite),Gt.setColorWrite(t.colorWrite),Gt.setPolygonOffset(t.polygonOffset,t.polygonOffsetFactor,t.polygonOffsetUnits)}function _(t,e,i,n){dt=0;var r=Ht.get(i);if(Et&&(Lt||t!==ct)){var o=t===ct&&i.id===at;Tt.setState(i.clippingPlanes,i.clipShadows,t,r,o)}i.needsUpdate===!1&&(void 0===r.program?i.needsUpdate=!0:i.fog&&r.fog!==e?i.needsUpdate=!0:i.lights&&r.lightsHash!==zt.hash?i.needsUpdate=!0:void 0!==r.numClippingPlanes&&r.numClippingPlanes!==Tt.numPlanes&&(i.needsUpdate=!0)),i.needsUpdate&&(b(i,e,n),i.needsUpdate=!1);var a=!1,s=!1,c=!1,u=r.program,h=u.getUniforms(),l=r.__webglShader.uniforms;if(u.id!==nt&&(Ut.useProgram(u.program),nt=u.id,a=!0,s=!0,c=!0),i.id!==at&&(at=i.id,s=!0),a||t!==ct){if(h.set(Ut,t,"projectionMatrix"),Vt.logarithmicDepthBuffer&&h.setValue(Ut,"logDepthBufFC",2/(Math.log(t.far+1)/Math.LN2)),t!==ct&&(ct=t,s=!0,c=!0),i.isShaderMaterial||i.isMeshPhongMaterial||i.isMeshStandardMaterial||i.envMap){var d=h.map.cameraPosition;void 0!==d&&d.setValue(Ut,kt.setFromMatrixPosition(t.matrixWorld))}(i.isMeshPhongMaterial||i.isMeshLambertMaterial||i.isMeshBasicMaterial||i.isMeshStandardMaterial||i.isShaderMaterial||i.skinning)&&h.setValue(Ut,"viewMatrix",t.matrixWorldInverse),h.set(Ut,it,"toneMappingExposure"),h.set(Ut,it,"toneMappingWhitePoint")}if(i.skinning){h.setOptional(Ut,n,"bindMatrix"),h.setOptional(Ut,n,"bindMatrixInverse");var f=n.skeleton;f&&(Vt.floatVertexTextures&&f.useVertexTexture?(h.set(Ut,f,"boneTexture"),h.set(Ut,f,"boneTextureWidth"),h.set(Ut,f,"boneTextureHeight")):h.setOptional(Ut,f,"boneMatrices"))}s&&(i.lights&&L(l,c),e&&i.fog&&C(l,e),(i.isMeshBasicMaterial||i.isMeshLambertMaterial||i.isMeshPhongMaterial||i.isMeshStandardMaterial||i.isMeshDepthMaterial)&&w(l,i),i.isLineBasicMaterial?S(l,i):i.isLineDashedMaterial?(S(l,i),A(l,i)):i.isPointsMaterial?M(l,i):i.isMeshLambertMaterial?P(l,i):i.isMeshPhongMaterial?T(l,i):i.isMeshPhysicalMaterial?I(l,i):i.isMeshStandardMaterial?E(l,i):i.isMeshDepthMaterial?i.displacementMap&&(l.displacementMap.value=i.displacementMap,l.displacementScale.value=i.displacementScale,l.displacementBias.value=i.displacementBias):i.isMeshNormalMaterial&&(l.opacity.value=i.opacity),bt.upload(Ut,r.uniformsList,l,it)),h.set(Ut,n,"modelViewMatrix"),h.set(Ut,n,"normalMatrix"),h.setValue(Ut,"modelMatrix",n.matrixWorld);var p=r.dynamicUniforms;return null!==p&&(bt.evalDynamic(p,l,n,t),bt.upload(Ut,p,l,it)),u}function w(t,e){t.opacity.value=e.opacity,t.diffuse.value=e.color,e.emissive&&t.emissive.value.copy(e.emissive).multiplyScalar(e.emissiveIntensity),t.map.value=e.map,t.specularMap.value=e.specularMap,t.alphaMap.value=e.alphaMap,e.aoMap&&(t.aoMap.value=e.aoMap,t.aoMapIntensity.value=e.aoMapIntensity);var i;if(e.map?i=e.map:e.specularMap?i=e.specularMap:e.displacementMap?i=e.displacementMap:e.normalMap?i=e.normalMap:e.bumpMap?i=e.bumpMap:e.roughnessMap?i=e.roughnessMap:e.metalnessMap?i=e.metalnessMap:e.alphaMap?i=e.alphaMap:e.emissiveMap&&(i=e.emissiveMap),void 0!==i){i.isWebGLRenderTarget&&(i=i.texture);var n=i.offset,r=i.repeat;t.offsetRepeat.value.set(n.x,n.y,r.x,r.y)}t.envMap.value=e.envMap,t.flipEnvMap.value=e.envMap&&e.envMap.isCubeTexture?-1:1,t.reflectivity.value=e.reflectivity,t.refractionRatio.value=e.refractionRatio}function S(t,e){t.diffuse.value=e.color,t.opacity.value=e.opacity}function A(t,e){t.dashSize.value=e.dashSize,t.totalSize.value=e.dashSize+e.gapSize,t.scale.value=e.scale}function M(t,e){if(t.diffuse.value=e.color,t.opacity.value=e.opacity,t.size.value=e.size*vt,t.scale.value=.5*U.clientHeight,t.map.value=e.map,null!==e.map){var i=e.map.offset,n=e.map.repeat;t.offsetRepeat.value.set(i.x,i.y,n.x,n.y)}}function C(t,e){t.fogColor.value=e.color,e.isFog?(t.fogNear.value=e.near,t.fogFar.value=e.far):e.isFogExp2&&(t.fogDensity.value=e.density)}function P(t,e){e.lightMap&&(t.lightMap.value=e.lightMap,t.lightMapIntensity.value=e.lightMapIntensity),e.emissiveMap&&(t.emissiveMap.value=e.emissiveMap)}function T(t,e){t.specular.value=e.specular,t.shininess.value=Math.max(e.shininess,1e-4),e.lightMap&&(t.lightMap.value=e.lightMap,t.lightMapIntensity.value=e.lightMapIntensity),e.emissiveMap&&(t.emissiveMap.value=e.emissiveMap),e.bumpMap&&(t.bumpMap.value=e.bumpMap,t.bumpScale.value=e.bumpScale),e.normalMap&&(t.normalMap.value=e.normalMap,t.normalScale.value.copy(e.normalScale)),e.displacementMap&&(t.displacementMap.value=e.displacementMap,t.displacementScale.value=e.displacementScale,t.displacementBias.value=e.displacementBias)}function E(t,e){t.roughness.value=e.roughness,t.metalness.value=e.metalness,e.roughnessMap&&(t.roughnessMap.value=e.roughnessMap),e.metalnessMap&&(t.metalnessMap.value=e.metalnessMap),e.lightMap&&(t.lightMap.value=e.lightMap,t.lightMapIntensity.value=e.lightMapIntensity),e.emissiveMap&&(t.emissiveMap.value=e.emissiveMap),e.bumpMap&&(t.bumpMap.value=e.bumpMap,t.bumpScale.value=e.bumpScale),e.normalMap&&(t.normalMap.value=e.normalMap,t.normalScale.value.copy(e.normalScale)),e.displacementMap&&(t.displacementMap.value=e.displacementMap,t.displacementScale.value=e.displacementScale,t.displacementBias.value=e.displacementBias),e.envMap&&(t.envMapIntensity.value=e.envMapIntensity)}function I(t,e){t.clearCoat.value=e.clearCoat,t.clearCoatRoughness.value=e.clearCoatRoughness,E(t,e)}function L(t,e){t.ambientLightColor.needsUpdate=e,t.directionalLights.needsUpdate=e,t.pointLights.needsUpdate=e,t.spotLights.needsUpdate=e,t.hemisphereLights.needsUpdate=e}function R(t){for(var e=0,i=0,n=t.length;i<n;i++){var r=t[i];r.castShadow&&(zt.shadows[e++]=r)}zt.shadows.length=e}function D(t,e){var i,n,r,o,a,s,c,u=0,h=0,l=0,d=e.matrixWorldInverse,f=0,p=0,m=0,g=0;for(i=0,n=t.length;i<n;i++)if(r=t[i],o=r.color,a=r.intensity,s=r.distance,c=r.shadow&&r.shadow.map?r.shadow.map.texture:null,r.isAmbientLight)u+=o.r*a,h+=o.g*a,l+=o.b*a;else if(r.isDirectionalLight){var v=Yt.get(r);v.color.copy(r.color).multiplyScalar(r.intensity),v.direction.setFromMatrixPosition(r.matrixWorld),kt.setFromMatrixPosition(r.target.matrixWorld),v.direction.sub(kt),v.direction.transformDirection(d),v.shadow=r.castShadow,r.castShadow&&(v.shadowBias=r.shadow.bias,v.shadowRadius=r.shadow.radius,v.shadowMapSize=r.shadow.mapSize),zt.directionalShadowMap[f]=c,zt.directionalShadowMatrix[f]=r.shadow.matrix,zt.directional[f++]=v}else if(r.isSpotLight){var v=Yt.get(r);v.position.setFromMatrixPosition(r.matrixWorld),v.position.applyMatrix4(d),v.color.copy(o).multiplyScalar(a),v.distance=s,v.direction.setFromMatrixPosition(r.matrixWorld),kt.setFromMatrixPosition(r.target.matrixWorld),v.direction.sub(kt),v.direction.transformDirection(d),v.coneCos=Math.cos(r.angle),v.penumbraCos=Math.cos(r.angle*(1-r.penumbra)),v.decay=0===r.distance?0:r.decay,v.shadow=r.castShadow,r.castShadow&&(v.shadowBias=r.shadow.bias,v.shadowRadius=r.shadow.radius,v.shadowMapSize=r.shadow.mapSize),zt.spotShadowMap[m]=c,zt.spotShadowMatrix[m]=r.shadow.matrix,zt.spot[m++]=v}else if(r.isPointLight){var v=Yt.get(r);v.position.setFromMatrixPosition(r.matrixWorld),v.position.applyMatrix4(d),v.color.copy(r.color).multiplyScalar(r.intensity),v.distance=r.distance,v.decay=0===r.distance?0:r.decay,v.shadow=r.castShadow,r.castShadow&&(v.shadowBias=r.shadow.bias,v.shadowRadius=r.shadow.radius,v.shadowMapSize=r.shadow.mapSize),zt.pointShadowMap[p]=c,void 0===zt.pointShadowMatrix[p]&&(zt.pointShadowMatrix[p]=new O),kt.setFromMatrixPosition(r.matrixWorld).negate(),zt.pointShadowMatrix[p].identity().setPosition(kt),zt.point[p++]=v}else if(r.isHemisphereLight){var v=Yt.get(r);v.direction.setFromMatrixPosition(r.matrixWorld),v.direction.transformDirection(d),v.direction.normalize(),v.skyColor.copy(r.color).multiplyScalar(a),v.groundColor.copy(r.groundColor).multiplyScalar(a),zt.hemi[g++]=v}zt.ambient[0]=u,zt.ambient[1]=h,zt.ambient[2]=l,zt.directional.length=f,zt.spot.length=m,zt.point.length=p,zt.hemi.length=g,zt.hash=f+","+p+","+m+","+g+","+zt.shadows.length}function F(){var t=dt;return t>=Vt.maxTextures&&console.warn("WebGLRenderer: trying to use "+t+" texture units while this GPU supports only "+Vt.maxTextures),dt+=1,t}function B(t){var e;if(t===cl)return Ut.REPEAT;if(t===ul)return Ut.CLAMP_TO_EDGE;if(t===hl)return Ut.MIRRORED_REPEAT;if(t===ll)return Ut.NEAREST;if(t===dl)return Ut.NEAREST_MIPMAP_NEAREST;if(t===fl)return Ut.NEAREST_MIPMAP_LINEAR;if(t===pl)return Ut.LINEAR;if(t===ml)return Ut.LINEAR_MIPMAP_NEAREST;if(t===gl)return Ut.LINEAR_MIPMAP_LINEAR;if(t===vl)return Ut.UNSIGNED_BYTE;if(t===Ml)return Ut.UNSIGNED_SHORT_4_4_4_4;if(t===Cl)return Ut.UNSIGNED_SHORT_5_5_5_1;if(t===Pl)return Ut.UNSIGNED_SHORT_5_6_5;if(t===yl)return Ut.BYTE;if(t===bl)return Ut.SHORT;if(t===xl)return Ut.UNSIGNED_SHORT;if(t===_l)return Ut.INT;if(t===wl)return Ut.UNSIGNED_INT;if(t===Sl)return Ut.FLOAT;if(e=$t.get("OES_texture_half_float"),null!==e&&t===Al)return e.HALF_FLOAT_OES;if(t===El)return Ut.ALPHA;if(t===Il)return Ut.RGB;if(t===Ll)return Ut.RGBA;if(t===Rl)return Ut.LUMINANCE;if(t===Ol)return Ut.LUMINANCE_ALPHA;if(t===Dl)return Ut.DEPTH_COMPONENT;if(t===Nl)return Ut.DEPTH_STENCIL;if(t===wh)return Ut.FUNC_ADD;if(t===Sh)return Ut.FUNC_SUBTRACT;if(t===Ah)return Ut.FUNC_REVERSE_SUBTRACT;if(t===Ph)return Ut.ZERO;if(t===Th)return Ut.ONE;if(t===Eh)return Ut.SRC_COLOR;if(t===Ih)return Ut.ONE_MINUS_SRC_COLOR;if(t===Lh)return Ut.SRC_ALPHA;if(t===Rh)return Ut.ONE_MINUS_SRC_ALPHA;if(t===Oh)return Ut.DST_ALPHA;if(t===Dh)return Ut.ONE_MINUS_DST_ALPHA;if(t===Nh)return Ut.DST_COLOR;if(t===kh)return Ut.ONE_MINUS_DST_COLOR;if(t===Fh)return Ut.SRC_ALPHA_SATURATE;if(e=$t.get("WEBGL_compressed_texture_s3tc"),null!==e){if(t===kl)return e.COMPRESSED_RGB_S3TC_DXT1_EXT;if(t===Fl)return e.COMPRESSED_RGBA_S3TC_DXT1_EXT;if(t===zl)return e.COMPRESSED_RGBA_S3TC_DXT3_EXT;if(t===Bl)return e.COMPRESSED_RGBA_S3TC_DXT5_EXT}if(e=$t.get("WEBGL_compressed_texture_pvrtc"),null!==e){if(t===Ul)return e.COMPRESSED_RGB_PVRTC_4BPPV1_IMG;if(t===jl)return e.COMPRESSED_RGB_PVRTC_2BPPV1_IMG;if(t===$l)return e.COMPRESSED_RGBA_PVRTC_4BPPV1_IMG;if(t===Vl)return e.COMPRESSED_RGBA_PVRTC_2BPPV1_IMG}if(e=$t.get("WEBGL_compressed_texture_etc1"),null!==e&&t===Gl)return e.COMPRESSED_RGB_ETC1_WEBGL;if(e=$t.get("EXT_blend_minmax"),null!==e){if(t===Mh)return e.MIN_EXT;if(t===Ch)return e.MAX_EXT}return e=$t.get("WEBGL_depth_texture"),null!==e&&t===Tl?e.UNSIGNED_INT_24_8_WEBGL:0}console.log("THREE.WebGLRenderer",eh),t=t||{};var U=void 0!==t.canvas?t.canvas:document.createElementNS("http://www.w3.org/1999/xhtml","canvas"),j=void 0!==t.context?t.context:null,$=void 0!==t.alpha&&t.alpha,V=void 0===t.depth||t.depth,G=void 0===t.stencil||t.stencil,H=void 0!==t.antialias&&t.antialias,W=void 0===t.premultipliedAlpha||t.premultipliedAlpha,X=void 0!==t.preserveDrawingBuffer&&t.preserveDrawingBuffer,q=[],Y=[],Z=-1,K=[],Q=-1,J=new Float32Array(8),tt=[],et=[];this.domElement=U,this.context=null,this.autoClear=!0,this.autoClearColor=!0,this.autoClearDepth=!0,this.autoClearStencil=!0,this.sortObjects=!0,this.clippingPlanes=[],this.localClippingEnabled=!1,this.gammaFactor=2,this.gammaInput=!1,this.gammaOutput=!1,this.physicallyCorrectLights=!1,this.toneMapping=Zh,this.toneMappingExposure=1,this.toneMappingWhitePoint=1,this.maxMorphTargets=8,this.maxMorphNormals=4;var it=this,nt=null,rt=null,ot=null,at=-1,st="",ct=null,ut=new _t,ht=null,lt=new _t,dt=0,ft=new Pt(0),pt=0,mt=U.width,gt=U.height,vt=1,yt=new _t(0,0,mt,gt),St=!1,At=new _t(0,0,mt,gt),Mt=new Ot,Tt=new ge,Et=!1,Lt=!1,Rt=new It,Nt=new O,kt=new N,zt={hash:"",ambient:[0,0,0],directional:[],directionalShadowMap:[],directionalShadowMatrix:[],spot:[],spotShadowMap:[],spotShadowMatrix:[],point:[],pointShadowMap:[],pointShadowMatrix:[],hemi:[],shadows:[]},Bt={calls:0,vertices:0,faces:0,points:0};this.info={render:Bt,memory:{geometries:0,textures:0},programs:null};var Ut;try{var jt={alpha:$,depth:V,stencil:G,antialias:H,premultipliedAlpha:W,preserveDrawingBuffer:X};if(Ut=j||U.getContext("webgl",jt)||U.getContext("experimental-webgl",jt),null===Ut)throw null!==U.getContext("webgl")?"Error creating WebGL context with your selected attributes.":"Error creating WebGL context.";void 0===Ut.getShaderPrecisionFormat&&(Ut.getShaderPrecisionFormat=function(){return{rangeMin:1,rangeMax:1,precision:1}}),U.addEventListener("webglcontextlost",o,!1)}catch(t){console.error("THREE.WebGLRenderer: "+t)}var $t=new pe(Ut);$t.get("WEBGL_depth_texture"),$t.get("OES_texture_float"),$t.get("OES_texture_float_linear"),$t.get("OES_texture_half_float"),$t.get("OES_texture_half_float_linear"),$t.get("OES_standard_derivatives"),$t.get("ANGLE_instanced_arrays"),$t.get("OES_element_index_uint")&&(ue.MaxIndex=4294967296);var Vt=new fe(Ut,$t,t),Gt=new wt(Ut,$t,B),Ht=new Ft,Wt=new xt(Ut,$t,Gt,Ht,Vt,B,this.info),Xt=new le(Ut,Ht,this.info),qt=new Zt(this,Vt),Yt=new de;this.info.programs=qt.programs;var Kt=new ve(Ut,$t,Bt),Qt=new me(Ut,$t,Bt),Jt=new Pe(-1,1,1,-1,0,1),te=new Ce,ee=new Se(new Ae(2,2),new we({depthTest:!1,depthWrite:!1,fog:!1})),ie=wp.cube,ne=new Se(new ye(5,5,5),new Ct({uniforms:ie.uniforms,vertexShader:ie.vertexShader,fragmentShader:ie.fragmentShader,side:uh,depthTest:!1,depthWrite:!1,fog:!1}));n(),this.context=Ut,this.capabilities=Vt,this.extensions=$t,this.properties=Ht,this.state=Gt;var re=new Dt(this,zt,Xt,Vt);this.shadowMap=re;var oe=new k(this,tt),ae=new z(this,et);this.getContext=function(){return Ut},this.getContextAttributes=function(){return Ut.getContextAttributes()},this.forceContextLoss=function(){$t.get("WEBGL_lose_context").loseContext()},this.getMaxAnisotropy=function(){return Vt.getMaxAnisotropy()},this.getPrecision=function(){return Vt.precision},this.getPixelRatio=function(){return vt},this.setPixelRatio=function(t){void 0!==t&&(vt=t,this.setSize(At.z,At.w,!1))},this.getSize=function(){return{width:mt,height:gt}},this.setSize=function(t,e,i){mt=t,gt=e,U.width=t*vt,U.height=e*vt,i!==!1&&(U.style.width=t+"px",U.style.height=e+"px"),this.setViewport(0,0,t,e)},this.setViewport=function(t,e,i,n){Gt.viewport(At.set(t,e,i,n))},this.setScissor=function(t,e,i,n){Gt.scissor(yt.set(t,e,i,n))},this.setScissorTest=function(t){Gt.setScissorTest(St=t)},this.getClearColor=function(){return ft},this.setClearColor=function(t,e){ft.set(t),pt=void 0!==e?e:1,i(ft.r,ft.g,ft.b,pt)},this.getClearAlpha=function(){return pt},this.setClearAlpha=function(t){pt=t,i(ft.r,ft.g,ft.b,pt)},this.clear=function(t,e,i){var n=0;(void 0===t||t)&&(n|=Ut.COLOR_BUFFER_BIT),(void 0===e||e)&&(n|=Ut.DEPTH_BUFFER_BIT),(void 0===i||i)&&(n|=Ut.STENCIL_BUFFER_BIT),Ut.clear(n)},this.clearColor=function(){this.clear(!0,!1,!1)},this.clearDepth=function(){this.clear(!1,!0,!1)},this.clearStencil=function(){this.clear(!1,!1,!0)},this.clearTarget=function(t,e,i,n){this.setRenderTarget(t),this.clear(e,i,n)},this.resetGLState=r,this.dispose=function(){K=[],Q=-1,Y=[],Z=-1,U.removeEventListener("webglcontextlost",o,!1)},this.renderBufferImmediate=function(t,e,i){Gt.initAttributes();var n=Ht.get(t);t.hasPositions&&!n.position&&(n.position=Ut.createBuffer()),t.hasNormals&&!n.normal&&(n.normal=Ut.createBuffer()),t.hasUvs&&!n.uv&&(n.uv=Ut.createBuffer()),t.hasColors&&!n.color&&(n.color=Ut.createBuffer());var r=e.getAttributes();if(t.hasPositions&&(Ut.bindBuffer(Ut.ARRAY_BUFFER,n.position),Ut.bufferData(Ut.ARRAY_BUFFER,t.positionArray,Ut.DYNAMIC_DRAW),Gt.enableAttribute(r.position),Ut.vertexAttribPointer(r.position,3,Ut.FLOAT,!1,0,0)),t.hasNormals){if(Ut.bindBuffer(Ut.ARRAY_BUFFER,n.normal),!i.isMeshPhongMaterial&&!i.isMeshStandardMaterial&&i.shading===lh)for(var o=0,a=3*t.count;o<a;o+=9){var s=t.normalArray,c=(s[o+0]+s[o+3]+s[o+6])/3,u=(s[o+1]+s[o+4]+s[o+7])/3,h=(s[o+2]+s[o+5]+s[o+8])/3;s[o+0]=c,s[o+1]=u,s[o+2]=h,s[o+3]=c,s[o+4]=u,s[o+5]=h,s[o+6]=c,s[o+7]=u,s[o+8]=h}Ut.bufferData(Ut.ARRAY_BUFFER,t.normalArray,Ut.DYNAMIC_DRAW),
	Gt.enableAttribute(r.normal),Ut.vertexAttribPointer(r.normal,3,Ut.FLOAT,!1,0,0)}t.hasUvs&&i.map&&(Ut.bindBuffer(Ut.ARRAY_BUFFER,n.uv),Ut.bufferData(Ut.ARRAY_BUFFER,t.uvArray,Ut.DYNAMIC_DRAW),Gt.enableAttribute(r.uv),Ut.vertexAttribPointer(r.uv,2,Ut.FLOAT,!1,0,0)),t.hasColors&&i.vertexColors!==fh&&(Ut.bindBuffer(Ut.ARRAY_BUFFER,n.color),Ut.bufferData(Ut.ARRAY_BUFFER,t.colorArray,Ut.DYNAMIC_DRAW),Gt.enableAttribute(r.color),Ut.vertexAttribPointer(r.color,3,Ut.FLOAT,!1,0,0)),Gt.disableUnusedAttributes(),Ut.drawArrays(Ut.TRIANGLES,0,t.count),t.count=0},this.renderBufferDirect=function(t,i,n,r,o,a){x(r);var s=_(t,i,r,o),c=!1,l=n.id+"_"+s.id+"_"+r.wireframe;l!==st&&(st=l,c=!0);var d=o.morphTargetInfluences;if(void 0!==d){for(var f=[],p=0,m=d.length;p<m;p++){var g=d[p];f.push([g,p])}f.sort(h),f.length>8&&(f.length=8);for(var v=n.morphAttributes,p=0,m=f.length;p<m;p++){var g=f[p];if(J[p]=g[0],0!==g[0]){var y=g[1];r.morphTargets===!0&&v.position&&n.addAttribute("morphTarget"+p,v.position[y]),r.morphNormals===!0&&v.normal&&n.addAttribute("morphNormal"+p,v.normal[y])}else r.morphTargets===!0&&n.removeAttribute("morphTarget"+p),r.morphNormals===!0&&n.removeAttribute("morphNormal"+p)}s.getUniforms().setValue(Ut,"morphTargetInfluences",J),c=!0}var y=n.index,b=n.attributes.position;r.wireframe===!0&&(y=Xt.getWireframeAttribute(n));var w;null!==y?(w=Qt,w.setIndex(y)):w=Kt,c&&(u(r,s,n),null!==y&&Ut.bindBuffer(Ut.ELEMENT_ARRAY_BUFFER,Xt.getAttributeBuffer(y)));var S=0,A=1/0;null!==y?A=y.count:void 0!==b&&(A=b.count);var M=n.drawRange.start,C=n.drawRange.count,P=null!==a?a.start:0,T=null!==a?a.count:1/0,E=Math.max(S,M,P),I=Math.min(S+A,M+C,P+T)-1,L=Math.max(0,I-E+1);if(o.isMesh)if(r.wireframe===!0)Gt.setLineWidth(r.wireframeLinewidth*e()),w.setMode(Ut.LINES);else switch(o.drawMode){case td:w.setMode(Ut.TRIANGLES);break;case ed:w.setMode(Ut.TRIANGLE_STRIP);break;case id:w.setMode(Ut.TRIANGLE_FAN)}else if(o.isLine){var R=r.linewidth;void 0===R&&(R=1),Gt.setLineWidth(R*e()),o.isLineSegments?w.setMode(Ut.LINES):w.setMode(Ut.LINE_STRIP)}else o.isPoints&&w.setMode(Ut.POINTS);n&&n.isInstancedBufferGeometry?n.maxInstancedCount>0&&w.renderInstances(n,E,L):w.render(E,L)},this.render=function(t,e,n,r){if((e&&e.isCamera)===!1)return void console.error("THREE.WebGLRenderer.render: camera is not an instance of THREE.Camera.");var o=t.fog;st="",at=-1,ct=null,t.autoUpdate===!0&&t.updateMatrixWorld(),null===e.parent&&e.updateMatrixWorld(),e.matrixWorldInverse.getInverse(e.matrixWorld),Nt.multiplyMatrices(e.projectionMatrix,e.matrixWorldInverse),Mt.setFromMatrix(Nt),q.length=0,Z=-1,Q=-1,tt.length=0,et.length=0,Lt=this.localClippingEnabled,Et=Tt.init(this.clippingPlanes,Lt,e),v(t,e),Y.length=Z+1,K.length=Q+1,it.sortObjects===!0&&(Y.sort(l),K.sort(d)),Et&&Tt.beginShadows(),R(q),re.render(t,e),D(q,e),Et&&Tt.endShadows(),Bt.calls=0,Bt.vertices=0,Bt.faces=0,Bt.points=0,void 0===n&&(n=null),this.setRenderTarget(n);var a=t.background;if(null===a?i(ft.r,ft.g,ft.b,pt):a&&a.isColor&&(i(a.r,a.g,a.b,1),r=!0),(this.autoClear||r)&&this.clear(this.autoClearColor,this.autoClearDepth,this.autoClearStencil),a&&a.isCubeTexture?(te.projectionMatrix.copy(e.projectionMatrix),te.matrixWorld.extractRotation(e.matrixWorld),te.matrixWorldInverse.getInverse(te.matrixWorld),ne.material.uniforms.tCube.value=a,ne.modelViewMatrix.multiplyMatrices(te.matrixWorldInverse,ne.matrixWorld),Xt.update(ne),it.renderBufferDirect(te,null,ne.geometry,ne.material,ne,null)):a&&a.isTexture&&(ee.material.map=a,Xt.update(ee),it.renderBufferDirect(Jt,null,ee.geometry,ee.material,ee,null)),t.overrideMaterial){var s=t.overrideMaterial;y(Y,e,o,s),y(K,e,o,s)}else Gt.setBlending(gh),y(Y,e,o),y(K,e,o);oe.render(t,e),ae.render(t,e,lt),n&&Wt.updateRenderTargetMipmap(n),Gt.setDepthTest(!0),Gt.setDepthWrite(!0),Gt.setColorWrite(!0)},this.setFaceCulling=function(t,e){Gt.setCullFace(t),Gt.setFlipSided(e===oh)},this.allocTextureUnit=F,this.setTexture2D=function(){var t=!1;return function(e,i){e&&e.isWebGLRenderTarget&&(t||(console.warn("THREE.WebGLRenderer.setTexture2D: don't use render targets as textures. Use their .texture property instead."),t=!0),e=e.texture),Wt.setTexture2D(e,i)}}(),this.setTexture=function(){var t=!1;return function(e,i){t||(console.warn("THREE.WebGLRenderer: .setTexture is deprecated, use setTexture2D instead."),t=!0),Wt.setTexture2D(e,i)}}(),this.setTextureCube=function(){var t=!1;return function(e,i){e&&e.isWebGLRenderTargetCube&&(t||(console.warn("THREE.WebGLRenderer.setTextureCube: don't use cube render targets as textures. Use their .texture property instead."),t=!0),e=e.texture),e&&e.isCubeTexture||Array.isArray(e.image)&&6===e.image.length?Wt.setTextureCube(e,i):Wt.setTextureCubeDynamic(e,i)}}(),this.getCurrentRenderTarget=function(){return rt},this.setRenderTarget=function(t){rt=t,t&&void 0===Ht.get(t).__webglFramebuffer&&Wt.setupRenderTarget(t);var e,i=t&&t.isWebGLRenderTargetCube;if(t){var n=Ht.get(t);e=i?n.__webglFramebuffer[t.activeCubeFace]:n.__webglFramebuffer,ut.copy(t.scissor),ht=t.scissorTest,lt.copy(t.viewport)}else e=null,ut.copy(yt).multiplyScalar(vt),ht=St,lt.copy(At).multiplyScalar(vt);if(ot!==e&&(Ut.bindFramebuffer(Ut.FRAMEBUFFER,e),ot=e),Gt.scissor(ut),Gt.setScissorTest(ht),Gt.viewport(lt),i){var r=Ht.get(t.texture);Ut.framebufferTexture2D(Ut.FRAMEBUFFER,Ut.COLOR_ATTACHMENT0,Ut.TEXTURE_CUBE_MAP_POSITIVE_X+t.activeCubeFace,r.__webglTexture,t.activeMipMapLevel)}},this.readRenderTargetPixels=function(t,e,i,n,r,o){if((t&&t.isWebGLRenderTarget)===!1)return void console.error("THREE.WebGLRenderer.readRenderTargetPixels: renderTarget is not THREE.WebGLRenderTarget.");var a=Ht.get(t).__webglFramebuffer;if(a){var s=!1;a!==ot&&(Ut.bindFramebuffer(Ut.FRAMEBUFFER,a),s=!0);try{var c=t.texture,u=c.format,h=c.type;if(u!==Ll&&B(u)!==Ut.getParameter(Ut.IMPLEMENTATION_COLOR_READ_FORMAT))return void console.error("THREE.WebGLRenderer.readRenderTargetPixels: renderTarget is not in RGBA or implementation defined format.");if(!(h===vl||B(h)===Ut.getParameter(Ut.IMPLEMENTATION_COLOR_READ_TYPE)||h===Sl&&($t.get("OES_texture_float")||$t.get("WEBGL_color_buffer_float"))||h===Al&&$t.get("EXT_color_buffer_half_float")))return void console.error("THREE.WebGLRenderer.readRenderTargetPixels: renderTarget is not in UnsignedByteType or implementation defined type.");Ut.checkFramebufferStatus(Ut.FRAMEBUFFER)===Ut.FRAMEBUFFER_COMPLETE?e>=0&&e<=t.width-n&&i>=0&&i<=t.height-r&&Ut.readPixels(e,i,n,r,B(u),B(h),o):console.error("THREE.WebGLRenderer.readRenderTargetPixels: readPixels from renderTarget failed. Framebuffer not complete.")}finally{s&&Ut.bindFramebuffer(Ut.FRAMEBUFFER,ot)}}}}function Ee(t,e){this.name="",this.color=new Pt(t),this.density=void 0!==e?e:25e-5}function Ie(t,e,i){this.name="",this.color=new Pt(t),this.near=void 0!==e?e:1,this.far=void 0!==i?i:1e3}function Le(){re.call(this),this.type="Scene",this.background=null,this.fog=null,this.overrideMaterial=null,this.autoUpdate=!0}function Re(t,e,i,n,r){re.call(this),this.lensFlares=[],this.positionScreen=new N,this.customUpdateCallback=void 0,void 0!==t&&this.add(t,e,i,n,r)}function Oe(t){At.call(this),this.type="SpriteMaterial",this.color=new Pt(16777215),this.map=null,this.rotation=0,this.fog=!1,this.lights=!1,this.setValues(t)}function De(t){re.call(this),this.type="Sprite",this.material=void 0!==t?t:new Oe}function Ne(){re.call(this),this.type="LOD",Object.defineProperties(this,{levels:{enumerable:!0,value:[]}})}function ke(t,e,i,n,r,o,a,s,c,u,h,l){L.call(this,null,o,a,s,c,u,n,r,h,l),this.image={data:t,width:e,height:i},this.magFilter=void 0!==c?c:ll,this.minFilter=void 0!==u?u:ll,this.flipY=!1,this.generateMipmaps=!1}function Fe(t,e,i){if(this.useVertexTexture=void 0===i||i,this.identityMatrix=new O,t=t||[],this.bones=t.slice(0),this.useVertexTexture){var n=Math.sqrt(4*this.bones.length);n=dd.nextPowerOfTwo(Math.ceil(n)),n=Math.max(n,4),this.boneTextureWidth=n,this.boneTextureHeight=n,this.boneMatrices=new Float32Array(this.boneTextureWidth*this.boneTextureHeight*4),this.boneTexture=new ke(this.boneMatrices,this.boneTextureWidth,this.boneTextureHeight,Ll,Sl)}else this.boneMatrices=new Float32Array(16*this.bones.length);if(void 0===e)this.calculateInverses();else if(this.bones.length===e.length)this.boneInverses=e.slice(0);else{console.warn("THREE.Skeleton bonInverses is the wrong length."),this.boneInverses=[];for(var r=0,o=this.bones.length;r<o;r++)this.boneInverses.push(new O)}}function ze(t){re.call(this),this.type="Bone",this.skin=t}function Be(t,e,i){Se.call(this,t,e),this.type="SkinnedMesh",this.bindMode="attached",this.bindMatrix=new O,this.bindMatrixInverse=new O;var n=[];if(this.geometry&&void 0!==this.geometry.bones){for(var r,o,a=0,s=this.geometry.bones.length;a<s;++a)o=this.geometry.bones[a],r=new ze(this),n.push(r),r.name=o.name,r.position.fromArray(o.pos),r.quaternion.fromArray(o.rotq),void 0!==o.scl&&r.scale.fromArray(o.scl);for(var a=0,s=this.geometry.bones.length;a<s;++a)o=this.geometry.bones[a],o.parent!==-1&&null!==o.parent&&void 0!==n[o.parent]?n[o.parent].add(n[a]):this.add(n[a])}this.normalizeSkinWeights(),this.updateMatrixWorld(!0),this.bind(new Fe(n,void 0,i),this.matrixWorld)}function Ue(t){At.call(this),this.type="LineBasicMaterial",this.color=new Pt(16777215),this.linewidth=1,this.linecap="round",this.linejoin="round",this.lights=!1,this.setValues(t)}function je(t,e,i){return 1===i?(console.warn("THREE.Line: parameter THREE.LinePieces no longer supported. Created THREE.LineSegments instead."),new $e(t,e)):(re.call(this),this.type="Line",this.geometry=void 0!==t?t:new ue,void(this.material=void 0!==e?e:new Ue({color:16777215*Math.random()})))}function $e(t,e){je.call(this,t,e),this.type="LineSegments"}function Ve(t){At.call(this),this.type="PointsMaterial",this.color=new Pt(16777215),this.map=null,this.size=1,this.sizeAttenuation=!0,this.lights=!1,this.setValues(t)}function Ge(t,e){re.call(this),this.type="Points",this.geometry=void 0!==t?t:new ue,this.material=void 0!==e?e:new Ve({color:16777215*Math.random()})}function He(){re.call(this),this.type="Group"}function We(t,e,i,n,r,o,a,s,c,u,h,l){L.call(this,null,o,a,s,c,u,n,r,h,l),this.image={width:e,height:i},this.mipmaps=t,this.flipY=!1,this.generateMipmaps=!1}function Xe(t,e,i,n,r,o,a,s,c){L.call(this,t,e,i,n,r,o,a,s,c),this.needsUpdate=!0}function qe(t,e,i){var n=this,r=!1,o=0,a=0;this.onStart=void 0,this.onLoad=t,this.onProgress=e,this.onError=i,this.itemStart=function(t){a++,r===!1&&void 0!==n.onStart&&n.onStart(t,o,a),r=!0},this.itemEnd=function(t){o++,void 0!==n.onProgress&&n.onProgress(t,o,a),o===a&&(r=!1,void 0!==n.onLoad&&n.onLoad())},this.itemError=function(t){void 0!==n.onError&&n.onError(t)}}function Ye(t){this.manager=void 0!==t?t:Pp}function Ze(t){this.manager=void 0!==t?t:Pp,this._parser=null}function Ke(t){this.manager=void 0!==t?t:Pp,this._parser=null}function Qe(t){this.manager=void 0!==t?t:Pp}function Je(t){this.manager=void 0!==t?t:Pp}function ti(t){this.manager=void 0!==t?t:Pp}function ei(t,e){re.call(this),this.type="Light",this.color=new Pt(t),this.intensity=void 0!==e?e:1,this.receiveShadow=void 0}function ii(t,e,i){ei.call(this,t,i),this.type="HemisphereLight",this.castShadow=void 0,this.position.copy(re.DefaultUp),this.updateMatrix(),this.groundColor=new Pt(e)}function ni(t){this.camera=t,this.bias=0,this.radius=1,this.mapSize=new I(512,512),this.map=null,this.matrix=new O}function ri(){ni.call(this,new Ce(50,1,.5,500))}function oi(t,e,i,n,r,o){ei.call(this,t,e),this.type="SpotLight",this.position.copy(re.DefaultUp),this.updateMatrix(),this.target=new re,Object.defineProperty(this,"power",{get:function(){return this.intensity*Math.PI},set:function(t){this.intensity=t/Math.PI}}),this.distance=void 0!==i?i:0,this.angle=void 0!==n?n:Math.PI/3,this.penumbra=void 0!==r?r:0,this.decay=void 0!==o?o:1,this.shadow=new ri}function ai(t,e,i,n){ei.call(this,t,e),this.type="PointLight",Object.defineProperty(this,"power",{get:function(){return 4*this.intensity*Math.PI},set:function(t){this.intensity=t/(4*Math.PI)}}),this.distance=void 0!==i?i:0,this.decay=void 0!==n?n:1,this.shadow=new ni(new Ce(90,1,.5,500))}function si(t){ni.call(this,new Pe(-5,5,5,-5,.5,500))}function ci(t,e){ei.call(this,t,e),this.type="DirectionalLight",this.position.copy(re.DefaultUp),this.updateMatrix(),this.target=new re,this.shadow=new si}function ui(t,e){ei.call(this,t,e),this.type="AmbientLight",this.castShadow=void 0}function hi(t,e,i,n){this.parameterPositions=t,this._cachedIndex=0,this.resultBuffer=void 0!==n?n:new e.constructor(i),this.sampleValues=e,this.valueSize=i}function li(t,e,i,n){hi.call(this,t,e,i,n),this._weightPrev=-0,this._offsetPrev=-0,this._weightNext=-0,this._offsetNext=-0}function di(t,e,i,n){hi.call(this,t,e,i,n)}function fi(t,e,i,n){hi.call(this,t,e,i,n)}function pi(t,e,i,n){if(void 0===t)throw new Error("track name is undefined");if(void 0===e||0===e.length)throw new Error("no keyframes in track named "+t);this.name=t,this.times=Tp.convertArray(e,this.TimeBufferType),this.values=Tp.convertArray(i,this.ValueBufferType),this.setInterpolation(n||this.DefaultInterpolation),this.validate(),this.optimize()}function mi(t,e,i,n){pi.call(this,t,e,i,n)}function gi(t,e,i,n){hi.call(this,t,e,i,n)}function vi(t,e,i,n){pi.call(this,t,e,i,n)}function yi(t,e,i,n){pi.call(this,t,e,i,n)}function bi(t,e,i,n){pi.call(this,t,e,i,n)}function xi(t,e,i){pi.call(this,t,e,i)}function _i(t,e,i,n){pi.call(this,t,e,i,n)}function wi(t,e,i,n){pi.apply(this,arguments)}function Si(t,e,i){this.name=t,this.tracks=i,this.duration=void 0!==e?e:-1,this.uuid=dd.generateUUID(),this.duration<0&&this.resetDuration(),this.trim(),this.optimize()}function Ai(t){this.manager=void 0!==t?t:Pp,this.textures={}}function Mi(t){this.manager=void 0!==t?t:Pp}function Ci(){this.onLoadStart=function(){},this.onLoadProgress=function(){},this.onLoadComplete=function(){}}function Pi(t){"boolean"==typeof t&&(console.warn("THREE.JSONLoader: showStatus parameter has been removed from constructor."),t=void 0),this.manager=void 0!==t?t:Pp,this.withCredentials=!1}function Ti(t){this.manager=void 0!==t?t:Pp,this.texturePath=""}function Ei(){}function Ii(t,e){this.v1=t,this.v2=e}function Li(){this.curves=[],this.autoClose=!1}function Ri(t,e,i,n,r,o,a,s){this.aX=t,this.aY=e,this.xRadius=i,this.yRadius=n,this.aStartAngle=r,this.aEndAngle=o,this.aClockwise=a,this.aRotation=s||0}function Oi(t){this.points=void 0===t?[]:t}function Di(t,e,i,n){this.v0=t,this.v1=e,this.v2=i,this.v3=n}function Ni(t,e,i){this.v0=t,this.v1=e,this.v2=i}function ki(t,e,i,n,r,o){function a(t,e,i){return E.vertices.push(new N(t,e,i))-1}ae.call(this),this.type="TubeGeometry",this.parameters={path:t,segments:e,radius:i,radialSegments:n,closed:r,taper:o},e=e||64,i=i||1,n=n||8,r=r||!1,o=o||ki.NoTaper;var s,c,u,h,l,d,f,p,m,g,v,y,b,x,_,w,S,A,M,C,P,T=[],E=this,L=e+1,R=new N,O=new ki.FrenetFrames(t,e,r),D=O.tangents,k=O.normals,F=O.binormals;for(this.tangents=D,this.normals=k,this.binormals=F,g=0;g<L;g++)for(T[g]=[],h=g/(L-1),m=t.getPointAt(h),s=D[g],c=k[g],u=F[g],d=i*o(h),v=0;v<n;v++)l=v/n*2*Math.PI,f=-d*Math.cos(l),p=d*Math.sin(l),R.copy(m),R.x+=f*c.x+p*u.x,R.y+=f*c.y+p*u.y,R.z+=f*c.z+p*u.z,T[g][v]=a(R.x,R.y,R.z);for(g=0;g<e;g++)for(v=0;v<n;v++)y=r?(g+1)%e:g+1,b=(v+1)%n,x=T[g][v],_=T[y][v],w=T[y][b],S=T[g][b],A=new I(g/e,v/n),M=new I((g+1)/e,v/n),C=new I((g+1)/e,(v+1)/n),P=new I(g/e,(v+1)/n),this.faces.push(new ee(x,_,S)),this.faceVertexUvs[0].push([A,M,P]),this.faces.push(new ee(_,w,S)),this.faceVertexUvs[0].push([M.clone(),C,P.clone()]);this.computeFaceNormals(),this.computeVertexNormals()}function Fi(t,e){return"undefined"==typeof t?void(t=[]):(ae.call(this),this.type="ExtrudeGeometry",t=Array.isArray(t)?t:[t],this.addShapeList(t,e),void this.computeFaceNormals())}function zi(t,e){ae.call(this),this.type="ShapeGeometry",Array.isArray(t)===!1&&(t=[t]),this.addShapeList(t,e),this.computeFaceNormals()}function Bi(){Ui.apply(this,arguments),this.holes=[]}function Ui(t){Li.call(this),this.currentPoint=new I,t&&this.fromPoints(t)}function ji(){this.subPaths=[],this.currentPath=null}function $i(t){this.data=t}function Vi(t){this.manager=void 0!==t?t:Pp}function Gi(){return void 0===Op&&(Op=new(window.AudioContext||window.webkitAudioContext)),Op}function Hi(t){this.manager=void 0!==t?t:Pp}function Wi(){this.type="StereoCamera",this.aspect=1,this.eyeSep=.064,this.cameraL=new Ce,this.cameraL.layers.enable(1),this.cameraL.matrixAutoUpdate=!1,this.cameraR=new Ce,this.cameraR.layers.enable(2),this.cameraR.matrixAutoUpdate=!1}function Xi(){re.call(this),this.type="AudioListener",this.context=Gi(),this.gain=this.context.createGain(),this.gain.connect(this.context.destination),this.filter=null}function qi(t){re.call(this),this.type="Audio",this.context=t.context,this.source=this.context.createBufferSource(),this.source.onended=this.onEnded.bind(this),this.gain=this.context.createGain(),this.gain.connect(t.getInput()),this.autoplay=!1,this.startTime=0,this.playbackRate=1,this.isPlaying=!1,this.hasPlaybackControl=!0,this.sourceType="empty",this.filters=[]}function Yi(t){qi.call(this,t),this.panner=this.context.createPanner(),this.panner.connect(this.gain)}function Zi(t,e){this.analyser=t.context.createAnalyser(),this.analyser.fftSize=void 0!==e?e:2048,this.data=new Uint8Array(this.analyser.frequencyBinCount),t.getOutput().connect(this.analyser)}function Ki(t,e,i){this.binding=t,this.valueSize=i;var n,r=Float64Array;switch(e){case"quaternion":n=this._slerp;break;case"string":case"bool":r=Array,n=this._select;break;default:n=this._lerp}this.buffer=new r(4*i),this._mixBufferRegion=n,this.cumulativeWeight=0,this.useCount=0,this.referenceCount=0}function Qi(t,e,i){this.path=e,this.parsedPath=i||Qi.parseTrackName(e),this.node=Qi.findNode(t,this.parsedPath.nodeName)||t,this.rootNode=t}function Ji(t,e,i){this._mixer=t,this._clip=e,this._localRoot=i||null;for(var n=e.tracks,r=n.length,o=new Array(r),a={endingStart:Kl,endingEnd:Kl},s=0;s!==r;++s){var c=n[s].createInterpolant(null);o[s]=c,c.settings=a}this._interpolantSettings=a,this._interpolants=o,this._propertyBindings=new Array(r),this._cacheIndex=null,this._byClipCacheIndex=null,this._timeScaleInterpolant=null,this._weightInterpolant=null,this.loop=Wl,this._loopCount=-1,this._startTime=null,this.time=0,this.timeScale=1,this._effectiveTimeScale=1,this.weight=1,this._effectiveWeight=1,this.repetitions=1/0,this.paused=!1,this.enabled=!0,this.clampWhenFinished=!1,this.zeroSlopeAtStart=!0,this.zeroSlopeAtEnd=!0}function tn(t){this._root=t,this._initMemoryManager(),this._accuIndex=0,this.time=0,this.timeScale=1}function en(t){"string"==typeof t&&(console.warn("THREE.Uniform: Type parameter is no longer needed."),t=arguments[1]),this.value=t,this.dynamic=!1}function nn(t,e,i,n){this.object=t,this.size=void 0!==e?e:1;var r=void 0!==i?i:16711680,o=void 0!==n?n:1,a=0,s=this.object.geometry;s&&s.isGeometry?a=3*s.faces.length:s&&s.isBufferGeometry&&(a=s.attributes.normal.count);var c=new ue,u=new te(2*a*3,3);c.addAttribute("position",u),$e.call(this,c,new Ue({color:r,linewidth:o})),this.matrixAutoUpdate=!1,this.update()}function rn(t){re.call(this),this.light=t,this.light.updateMatrixWorld(),this.matrix=t.matrixWorld,this.matrixAutoUpdate=!1;for(var e=new ue,i=[0,0,0,0,0,1,0,0,0,1,0,1,0,0,0,-1,0,1,0,0,0,0,1,1,0,0,0,0,-1,1],n=0,r=1,o=32;n<o;n++,r++){var a=n/o*Math.PI*2,s=r/o*Math.PI*2;i.push(Math.cos(a),Math.sin(a),1,Math.cos(s),Math.sin(s),1)}e.addAttribute("position",new te(i,3));var c=new Ue({fog:!1});this.cone=new $e(e,c),this.add(this.cone),this.update()}function on(t,e,i,n,r,o,a){ue.call(this),this.type="SphereBufferGeometry",this.parameters={radius:t,widthSegments:e,heightSegments:i,phiStart:n,phiLength:r,thetaStart:o,thetaLength:a},t=t||50,e=Math.max(3,Math.floor(e)||8),i=Math.max(2,Math.floor(i)||6),n=void 0!==n?n:0,r=void 0!==r?r:2*Math.PI,o=void 0!==o?o:0,a=void 0!==a?a:Math.PI;for(var s=o+a,c=(e+1)*(i+1),u=new Kt(new Float32Array(3*c),3),h=new Kt(new Float32Array(3*c),3),l=new Kt(new Float32Array(2*c),2),d=0,f=[],p=new N,m=0;m<=i;m++){for(var g=[],v=m/i,y=0;y<=e;y++){var b=y/e,x=-t*Math.cos(n+b*r)*Math.sin(o+v*a),_=t*Math.cos(o+v*a),w=t*Math.sin(n+b*r)*Math.sin(o+v*a);p.set(x,_,w).normalize(),u.setXYZ(d,x,_,w),h.setXYZ(d,p.x,p.y,p.z),l.setXY(d,b,1-v),g.push(d),d++}f.push(g)}for(var S=[],m=0;m<i;m++)for(var y=0;y<e;y++){var A=f[m][y+1],M=f[m][y],C=f[m+1][y],P=f[m+1][y+1];(0!==m||o>0)&&S.push(A,M,P),(m!==i-1||s<Math.PI)&&S.push(M,C,P)}this.setIndex(new(u.count>65535?Jt:Qt)(S,1)),this.addAttribute("position",u),this.addAttribute("normal",h),this.addAttribute("uv",l),this.boundingSphere=new It(new N,t)}function an(t,e,i,n,r,o,a){ae.call(this),this.type="SphereGeometry",this.parameters={radius:t,widthSegments:e,heightSegments:i,phiStart:n,phiLength:r,thetaStart:o,thetaLength:a},this.fromBufferGeometry(new on(t,e,i,n,r,o,a))}function sn(t,e){re.call(this),this.light=t,this.light.updateMatrixWorld(),this.matrix=t.matrixWorld,this.matrixAutoUpdate=!1,this.colors=[new Pt,new Pt];var i=new an(e,4,2);i.rotateX(-Math.PI/2);for(var n=0,r=8;n<r;n++)i.faces[n].color=this.colors[n<4?0:1];var o=new we({vertexColors:ph,wireframe:!0});this.lightSphere=new Se(i,o),this.add(this.lightSphere),this.update()}function cn(t,e,i,n){this.object=t,this.size=void 0!==e?e:1;var r=void 0!==i?i:16776960,o=void 0!==n?n:1,a=0,s=this.object.geometry;s&&s.isGeometry?a=s.faces.length:console.warn("THREE.FaceNormalsHelper: only THREE.Geometry is supported. Use THREE.VertexNormalsHelper, instead.");var c=new ue,u=new te(2*a*3,3);c.addAttribute("position",u),$e.call(this,c,new Ue({color:r,linewidth:o})),this.matrixAutoUpdate=!1,this.update()}function un(t,e){re.call(this),this.light=t,this.light.updateMatrixWorld(),this.matrix=t.matrixWorld,this.matrixAutoUpdate=!1,void 0===e&&(e=1);var i=new ue;i.addAttribute("position",new te([-e,e,0,e,e,0,e,-e,0,-e,-e,0,-e,e,0],3));var n=new Ue({fog:!1});this.add(new je(i,n)),i=new ue,i.addAttribute("position",new te([0,0,0,0,0,1],3)),this.add(new je(i,n)),this.update()}function hn(t){function e(t,e,n){i(t,n),i(e,n)}function i(t,e){n.vertices.push(new N),n.colors.push(new Pt(e)),void 0===o[t]&&(o[t]=[]),o[t].push(n.vertices.length-1)}var n=new ae,r=new Ue({color:16777215,vertexColors:ph}),o={},a=16755200,s=16711680,c=43775,u=16777215,h=3355443;e("n1","n2",a),e("n2","n4",a),e("n4","n3",a),e("n3","n1",a),e("f1","f2",a),e("f2","f4",a),e("f4","f3",a),e("f3","f1",a),e("n1","f1",a),e("n2","f2",a),e("n3","f3",a),e("n4","f4",a),e("p","n1",s),e("p","n2",s),e("p","n3",s),e("p","n4",s),e("u1","u2",c),e("u2","u3",c),e("u3","u1",c),e("c","t",u),e("p","c",h),e("cn1","cn2",h),e("cn3","cn4",h),e("cf1","cf2",h),e("cf3","cf4",h),$e.call(this,n,r),this.camera=t,this.camera.updateProjectionMatrix&&this.camera.updateProjectionMatrix(),this.matrix=t.matrixWorld,this.matrixAutoUpdate=!1,this.pointMap=o,this.update()}function ln(t,e){void 0===e&&(e=16776960);var i=new Uint16Array([0,1,1,2,2,3,3,0,4,5,5,6,6,7,7,4,0,4,1,5,2,6,3,7]),n=new Float32Array(24),r=new ue;r.setIndex(new Kt(i,1)),r.addAttribute("position",new Kt(n,3)),$e.call(this,r,new Ue({color:e})),void 0!==t&&this.update(t)}function dn(t,e,i,n,r,o,a,s){function c(){var t=(n+1)*(r+1);return o===!1&&(t+=(n+1)*f+n*f),t}function u(){var t=n*r*2*3;return o===!1&&(t+=n*f*3),t}function h(){var o,c,u=new N,h=new N,l=0,f=(e-t)/i;for(c=0;c<=r;c++){var p=[],m=c/r,M=m*(e-t)+t;for(o=0;o<=n;o++){var C=o/n;h.x=M*Math.sin(C*s+a),h.y=-m*i+S,h.z=M*Math.cos(C*s+a),v.setXYZ(x,h.x,h.y,h.z),u.copy(h),(0===t&&0===c||0===e&&c===r)&&(u.x=Math.sin(C*s+a),u.z=Math.cos(C*s+a)),u.setY(Math.sqrt(u.x*u.x+u.z*u.z)*f).normalize(),y.setXYZ(x,u.x,u.y,u.z),b.setXY(x,C,1-m),p.push(x),x++}w.push(p)}for(o=0;o<n;o++)for(c=0;c<r;c++){var P=w[c][o],T=w[c+1][o],E=w[c+1][o+1],I=w[c][o+1];g.setX(_,P),_++,g.setX(_,T),_++,g.setX(_,I),_++,g.setX(_,T),_++,g.setX(_,E),_++,g.setX(_,I),_++,l+=6}d.addGroup(A,l,0),A+=l}function l(i){var r,o,c,u=new I,h=new N,l=0,f=i===!0?t:e,p=i===!0?1:-1;for(o=x,r=1;r<=n;r++)v.setXYZ(x,0,S*p,0),y.setXYZ(x,0,p,0),u.x=.5,u.y=.5,b.setXY(x,u.x,u.y),x++;for(c=x,r=0;r<=n;r++){var m=r/n,w=m*s+a,M=Math.cos(w),C=Math.sin(w);h.x=f*C,h.y=S*p,h.z=f*M,v.setXYZ(x,h.x,h.y,h.z),y.setXYZ(x,0,p,0),u.x=.5*M+.5,u.y=.5*C*p+.5,b.setXY(x,u.x,u.y),x++}for(r=0;r<n;r++){var P=o+r,T=c+r;i===!0?(g.setX(_,T),_++,g.setX(_,T+1),_++,g.setX(_,P),_++):(g.setX(_,T+1),_++,g.setX(_,T),_++,g.setX(_,P),_++),l+=3}d.addGroup(A,l,i===!0?1:2),A+=l}ue.call(this),this.type="CylinderBufferGeometry",this.parameters={radiusTop:t,radiusBottom:e,height:i,radialSegments:n,heightSegments:r,openEnded:o,thetaStart:a,thetaLength:s};var d=this;t=void 0!==t?t:20,e=void 0!==e?e:20,i=void 0!==i?i:100,n=Math.floor(n)||8,r=Math.floor(r)||1,o=void 0!==o&&o,a=void 0!==a?a:0,s=void 0!==s?s:2*Math.PI;var f=0;o===!1&&(t>0&&f++,e>0&&f++);var p=c(),m=u(),g=new Kt(new(m>65535?Uint32Array:Uint16Array)(m),1),v=new Kt(new Float32Array(3*p),3),y=new Kt(new Float32Array(3*p),3),b=new Kt(new Float32Array(2*p),2),x=0,_=0,w=[],S=i/2,A=0;h(),o===!1&&(t>0&&l(!0),e>0&&l(!1)),this.setIndex(g),this.addAttribute("position",v),this.addAttribute("normal",y),this.addAttribute("uv",b)}function fn(t,e,i,n,r,o){re.call(this),void 0===n&&(n=16776960),void 0===i&&(i=1),void 0===r&&(r=.2*i),void 0===o&&(o=.2*r),this.position.copy(e),this.line=new je(Dp,new Ue({color:n})),this.line.matrixAutoUpdate=!1,this.add(this.line),this.cone=new Se(Np,new we({color:n})),this.cone.matrixAutoUpdate=!1,this.add(this.cone),this.setDirection(t),this.setLength(i,r,o)}function pn(t,e,i,n){function r(t){var e=t.normalize().clone();e.index=h.vertices.push(e)-1;var i=s(t)/2/Math.PI+.5,n=c(t)/Math.PI+.5;return e.uv=new I(i,1-n),e}function o(t,e,i){var n=new ee(t.index,e.index,i.index,[t.clone(),e.clone(),i.clone()]);h.faces.push(n),b.copy(t).add(e).add(i).divideScalar(3);var r=s(b);h.faceVertexUvs[0].push([u(t.uv,t,r),u(e.uv,e,r),u(i.uv,i,r)])}function a(t,e){for(var i=Math.pow(2,e),n=r(h.vertices[t.a]),a=r(h.vertices[t.b]),s=r(h.vertices[t.c]),c=[],u=0;u<=i;u++){c[u]=[];for(var l=r(n.clone().lerp(s,u/i)),d=r(a.clone().lerp(s,u/i)),f=i-u,p=0;p<=f;p++)0===p&&u===i?c[u][p]=l:c[u][p]=r(l.clone().lerp(d,p/f))}for(var u=0;u<i;u++)for(var p=0;p<2*(i-u)-1;p++){var m=Math.floor(p/2);p%2===0?o(c[u][m+1],c[u+1][m],c[u][m]):o(c[u][m+1],c[u+1][m+1],c[u+1][m])}}function s(t){return Math.atan2(t.z,-t.x)}function c(t){return Math.atan2(-t.y,Math.sqrt(t.x*t.x+t.z*t.z))}function u(t,e,i){return i<0&&1===t.x&&(t=new I(t.x-1,t.y)),0===e.x&&0===e.z&&(t=new I(i/2/Math.PI+.5,t.y)),t.clone()}ae.call(this),this.type="PolyhedronGeometry",this.parameters={vertices:t,indices:e,radius:i,detail:n},i=i||1,n=n||0;for(var h=this,l=0,d=t.length;l<d;l+=3)r(new N(t[l],t[l+1],t[l+2]));for(var f=this.vertices,p=[],l=0,m=0,d=e.length;l<d;l+=3,m++){var g=f[e[l]],v=f[e[l+1]],y=f[e[l+2]];p[m]=new ee(g.index,v.index,y.index,[g.clone(),v.clone(),y.clone()])}for(var b=new N,l=0,d=p.length;l<d;l++)a(p[l],n);for(var l=0,d=this.faceVertexUvs[0].length;l<d;l++){var x=this.faceVertexUvs[0][l],_=x[0].x,w=x[1].x,S=x[2].x,A=Math.max(_,w,S),M=Math.min(_,w,S);A>.9&&M<.1&&(_<.2&&(x[0].x+=1),w<.2&&(x[1].x+=1),S<.2&&(x[2].x+=1))}for(var l=0,d=this.vertices.length;l<d;l++)this.vertices[l].multiplyScalar(i);this.mergeVertices(),this.computeFaceNormals(),this.boundingSphere=new It(new N,i)}function mn(t,e){var i=(1+Math.sqrt(5))/2,n=[-1,i,0,1,i,0,-1,-i,0,1,-i,0,0,-1,i,0,1,i,0,-1,-i,0,1,-i,i,0,-1,i,0,1,-i,0,-1,-i,0,1],r=[0,11,5,0,5,1,0,1,7,0,7,10,0,10,11,1,5,9,5,11,4,11,10,2,10,7,6,7,1,8,3,9,4,3,4,2,3,2,6,3,6,8,3,8,9,4,9,5,2,4,11,6,2,10,8,6,7,9,8,1];pn.call(this,n,r,t,e),this.type="IcosahedronGeometry",this.parameters={radius:t,detail:e}}function gn(t,e,i,n){ae.call(this),this.type="PlaneGeometry",this.parameters={width:t,height:e,widthSegments:i,heightSegments:n},this.fromBufferGeometry(new Ae(t,e,i,n))}function vn(t,e,i,n,r,o,a){dn.call(this,0,t,e,i,n,r,o,a),this.type="ConeBufferGeometry",this.parameters={radius:t,height:e,radialSegments:i,heightSegments:n,thetaStart:o,thetaLength:a}}function yn(t,e,i,n,r){this._listener=e,this._isOnce=i,this.context=n,this._signal=t,this._priority=r||0}function bn(t,e){if("function"!=typeof t)throw new Error("listener is a required param of {fn}() and should be a Function.".replace("{fn}",e))}function xn(){this._bindings=[],this._prevParams=null;var t=this;this.dispatch=function(){xn.prototype.dispatch.apply(t,arguments)}}function _n(t){this.signals={stringChanged:new xn},this.setString(t)}function wn(t){return.01745*t}function Sn(t){return 57.29578*t}function An(){}function Mn(t){var e=t||{};this.scale=d(e.scale,"uniform"),this.mode=d(e.mode,"hcl"),this.domain=d(e.domain,[0,1]),this.value=new Pt(d(e.value,16777215)).getHex(),this.structure=e.structure,this.volume=e.volume,this.surface=e.surface,this.gidPool=e.gidPool,this.structure&&(this.atomProxy=this.structure.getAtomProxy())}function Cn(t){Mn.call(this,t);var e=this.getScale(),i=this.volume,n=i.inverseMatrix,r=i.__data,o=i.nx,a=i.ny,s=new N;this.positionColor=function(t){s.copy(t),s.applyMatrix4(n),s.round();var i=(s.z*a+s.y)*o+s.x;return e(r[i])}}function Pn(t){Mn.call(this,t);var e=this.getScale();this.volumeColor=function(t){return e(this.volume.data[t])}}function Tn(t){Mn.call(this,t);var e;this.structure&&(e=this.structure.atomStore.count,t.backbone?e+=this.structure.bondStore.count:t.rung&&(e+=this.structure.bondStore.count,e+=this.structure.backboneBondStore.count)),this.gidPool||(console.warn("no gidPool"),this.gidPool={getGid:function(){return 0}}),this.atomColor=function(t){return this.gidPool.getGid(this.structure,t.index)},this.bondColor=function(t){return this.gidPool.getGid(this.structure,e+t.index)},this.volumeColor=function(t){return this.gidPool.getGid(this.volume,t)}}function En(t){Mn.call(this,t),this.atomColor=function(){return 16777215*Math.random()}}function In(t){Mn.call(this,t);var e=this.value;this.atomColor=function(){return e},this.bondColor=function(){return e},this.valueColor=function(){return e}}function Ln(t){if(Mn.call(this,t),t.scale||(this.scale="roygb"),t.domain){var e=this.getScale();this.atomColor=function(t){return e(t.index)}}else{var i={};this.structure.eachModel(function(t){this.domain=[t.atomOffset,t.atomEnd],i[t.index]=this.getScale()}.bind(this)),this.atomColor=function(t){return i[t.modelIndex](t.index)}}}function Rn(t){if(Mn.call(this,t),t.scale||(this.scale="roygb"),t.domain){var e=this.getScale();this.atomColor=function(t){return e(t.residueIndex)}}else{var i={};this.structure.eachChain(function(t){this.domain=[t.residueOffset,t.residueEnd],i[t.index]=this.getScale()}.bind(this)),this.atomColor=function(t){return i[t.chainIndex](t.residueIndex)}}}function On(t){if(Mn.call(this,t),t.scale||(this.scale="Spectral"),t.domain){var e=this.getScale();this.atomColor=function(t){return e(t.chainIndex)}}else{var i={};this.structure.eachModel(function(t){this.domain=[t.chainOffset,t.chainEnd],i[t.index]=this.getScale()}.bind(this)),this.atomColor=function(t){return i[t.modelIndex](t.chainIndex)}}}function Dn(t){Mn.call(this,t),t.scale||(this.scale="Spectral");var e={},i={};this.structure.eachModel(function(t){var n=0,r={};t.eachChain(function(t){void 0===r[t.chainname]&&(r[t.chainname]=n,n+=1)}),this.domain=[0,n-1],e[t.index]=r,i[t.index]=this.getScale()}.bind(this)),this.atomColor=function(t){var n=e[t.modelIndex];return i[t.modelIndex](n[t.chainname])}}function Nn(t){Mn.call(this,t),t.scale||(this.scale="Spectral");var e={},i={};this.structure.eachModel(function(t){var n=0,r={};t.eachChain(function(t){void 0===r[t.chainid]&&(r[t.chainid]=n,n+=1)}),this.domain=[0,n-1],e[t.index]=r,i[t.index]=this.getScale()}.bind(this)),this.atomColor=function(t){var n=e[t.modelIndex];return i[t.modelIndex](n[t.chainid])}}function kn(t){Mn.call(this,t),t.scale||(this.scale="Spectral"),t.domain||(this.domain=[0,this.structure.entityList.length-1]);var e=this.getScale();this.atomColor=function(t){return e(t.entityIndex)}}function Fn(t){Mn.call(this,t),t.scale||(this.scale="roygb"),t.domain||(this.domain=[0,this.structure.modelStore.count]);
	var e=this.getScale();this.atomColor=function(t){return e(t.modelIndex)}}function zn(t){Mn.call(this,t),this.atomColor=function(t){var e=t.entity,i=e?e.entityType:void 0;switch(i){case Bp:return 8374655;case Up:return 16629894;case jp:return 12496596;case $p:return 3697840;default:return 16777113}}}function Bn(t){Mn.call(this,t),this.atomColor=function(t){switch(t.residueType.moleculeType){case Gp:return 3697840;case Hp:return 15729279;case Wp:return 12496596;case Xp:return 16629894;case qp:return 12540695;case Yp:return 8374655;default:return 16777113}}}function Un(t){Mn.call(this,t);var e=this.structure.getResidueProxy();this.atomColor=function(t){var i=t.sstruc;return"h"===i?nv.alphaHelix:"g"===i?nv.threeTenHelix:"i"===i?nv.piHelix:"e"===i||"b"===i?nv.betaStrand:(e.index=t.residueIndex,e.isNucleic()?nv.dna:e.isProtein()||"s"===i||"t"===i||"l"===i?nv.coil:rv)}}function jn(t){Mn.call(this,t);var e=this.value;void 0===t.value&&(e=Jg.C),this.atomColor=function(t){var i=t.element;return"C"===i?e:Jg[i]||tv}}function $n(t){Mn.call(this,t),this.atomColor=function(t){return ev[t.resname]||iv}}function Vn(t){if(Mn.call(this,t),t.scale||(this.scale="OrRd"),!t.domain){var e,i=1/0,n=-(1/0);t.sele&&(e=new _n(t.sele)),this.structure.eachAtom(function(t){var e=t.bfactor;i=Math.min(i,e),n=Math.max(n,e)},e),this.domain=[i,n]}var r=this.getScale();this.atomColor=function(t){return r(t.bfactor)}}function Gn(t){Mn.call(this,t),t.scale||(this.scale="PuBu"),t.domain||(this.domain=[0,1]);var e=this.getScale();this.atomColor=function(t){return e(t.occupancy)}}function Hn(t){Mn.call(this,t),t.scale||(this.scale="RdYlGn");var e,i=0,n={};for(e in pm)n[e]=pm[e][i];if(!t.domain){var r,o=1/0,a=-(1/0);for(e in n)r=n[e],o=Math.min(o,r),a=Math.max(a,r);this.domain=[o,0,a]}var s=this.getScale();this.atomColor=function(t){return s(n[t.resname]||mm)}}function Wn(t){sv=t}function Xn(t){cv=t}function qn(e){t.Debug=e}function Yn(t,e){var i=e||{};this.compressed=d(i.compressed,!1),this.binary=d(i.binary,!1),this.json=d(i.json,!1),this.xml=d(i.xml,!1),this.src=t,this.chunkSize=10485760,this.newline="\n",this.__pointer=0,this.__partialLine="",this.__srcName&&(this[this.__srcName]=t)}function Zn(t,e){Yn.call(this,t,e)}function Kn(t,e){Yn.call(this,t,e)}function Qn(t,e){var i=Object.assign({},e),n=["mmtf","dcd","mrc","ccp4","map","dxbin"].includes(i.ext);this.compressed=d(i.compressed,!1),this.binary=d(i.binary,n),this.name=d(i.name,""),this.ext=d(i.ext,""),this.dir=d(i.dir,""),this.path=d(i.path,""),this.protocol=d(i.protocol,""),this.params=e;var r={compressed:this.compressed,binary:this.binary,json:"json"===this.ext,xml:"xml"===this.ext};"undefined"!=typeof File&&t instanceof File||"undefined"!=typeof Blob&&t instanceof Blob?this.streamer=new Zn(t,r):this.streamer=new Kn(t,r),"function"==typeof i.onProgress&&(this.streamer.onprogress=i.onprogress)}function Jn(t,e){Qn.call(this,t,e)}function tr(t,e,i){this.signals={elementAdded:new xn,elementRemoved:new xn,nameChanged:new xn},this.name=e,this.path=i,this.dir=i.substring(0,i.lastIndexOf("/")+1);try{this.fn=new Function("stage","panel","__name__","__path__","__dir__",t)}catch(t){uv.error("Script compilation failed",t),this.fn=null}}function er(t,e){Qn.call(this,t,e)}function ir(t,e){Qn.call(this,t,e)}function nr(t){var e=y(t),i=fv.get(e.protocol);return i&&(e=y(i.getUrl(e.src)),!e.ext&&i.getExt&&(e.ext=i.getExt(t))),e}function rr(t,e){var i,n=Object.assign(nr(t),e);if(mv.names.includes(n.ext)?i=Jn:"ngl"===n.ext?i=er:"plugin"===n.ext&&(i=ir),i){var r=new i(n.src,n);return r.load()}return Promise.reject("autoLoad: ext '"+n.ext+"' unknown")}function or(){var t=arguments[0],e=or.cache;return e[t]&&e.hasOwnProperty(t)||(e[t]=or.parse(t)),or.format.call(null,e[t],arguments)}function ar(t){return"number"==typeof t?"number":"string"==typeof t?"string":Object.prototype.toString.call(t).slice(8,-1).toLowerCase()}function sr(t,e){return e>=0&&e<=7&&xv[t]?xv[t][e]:Array(e+1).join(t)}function cr(t,e){function i(){f=[],r(),o(),a()}function n(t,e){return void 0!==t?t:e}function r(){f.push(or("TITEL %-74s",t.name))}function o(){d.forEach(function(t){f.push(or("REMARK %-73s",t))}),t.trajectory&&(f.push(or("REMARK %-73s","Trajectory '"+t.trajectory.name+"'")),f.push(or("REMARK %-73s","Frame "+t.trajectory.frame)))}function a(){var e=1,i=1;t.eachModel(function(t){f.push(or("MODEL %-74d",i++)),t.eachAtom(function(t){var i=t.hetero?m:p,r=l?e:t.serial,o=t.atomname;1===o.length&&(o=" "+o),f.push(or(i,r,o,t.resname,n(t.chainname," "),t.resno,t.x,t.y,t.z,n(t.occurence,1),n(t.bfactor,0),n(t.segid,""),n(t.element,""))),e+=1}),f.push(or("%-80s","ENDMDL")),i+=1}),f.push(or("%-80s","END"))}function s(){return i(),f.join("\n")}function c(){return new Blob([s()],{type:"text/plain"})}function u(t,e){t=t||"structure",e=e||"pdb";var i=t+"."+e,n=c();v(n,i)}var h=Object.assign({},e),l=void 0===h.renumberSerial||h.renumberSerial,d=h.remarks||[];Array.isArray(d)||(d=[d]);var f,p="ATOM  %5d %-4s %3s %1s%4d    %8.3f%8.3f%8.3f%6.2f%6.2f      %4s%2s",m="HETATM%5d %-4s %3s %1s%4d    %8.3f%8.3f%8.3f%6.2f%6.2f      %4s%2s";this.getString=s,this.getBlob=c,this.download=u}function ur(){this.count=0,this.signals={countChanged:new xn}}function hr(t){this.name=t||"",this.nextGid=1,this.objectList=[],this.rangeList=[]}function lr(){this.signals={updated:new xn},this.begin(),this.maxDuration=-(1/0),this.minDuration=1/0,this.avgDuration=14,this.lastDuration=1/0,this.prevFpsTime=0,this.lastFps=1/0,this.lastFrames=1,this.frames=0,this.count=0}function dr(t,e){function i(t){d.enabled!==!1&&(v=g,g===f.NONE&&(t.keyCode!==d.keys[f.ROTATE]||d.noRotate?t.keyCode!==d.keys[f.ZOOM]||d.noZoom?t.keyCode!==d.keys[f.PAN]||d.noPan||(g=f.PAN):g=f.ZOOM:g=f.ROTATE))}function n(){d.enabled!==!1&&(g=v)}function r(t){d.enabled!==!1&&(g===f.NONE&&(g=t.button),g!==f.ROTATE||d.noRotate?g!==f.ZOOM||d.noZoom?g!==f.PAN||d.noPan||(P.copy(O(t.pageX,t.pageY)),T.copy(P)):(S.copy(O(t.pageX,t.pageY)),A.copy(S)):(x.copy(k(t.pageX,t.pageY)),b.copy(x)),document.addEventListener("mousemove",o,!1),document.addEventListener("mouseup",a,!1),d.dispatchEvent(L))}function o(t){d.enabled!==!1&&(g!==f.ROTATE||d.noRotate?g!==f.ZOOM||d.noZoom?g!==f.PAN||d.noPan||T.copy(O(t.pageX,t.pageY)):A.copy(O(t.pageX,t.pageY)):(b.copy(x),x.copy(k(t.pageX,t.pageY))))}function a(){d.enabled!==!1&&(g=f.NONE,document.removeEventListener("mousemove",o),document.removeEventListener("mouseup",a),d.dispatchEvent(R))}function s(t){if(d.enabled!==!1){var e=0;e=t.wheelDelta?t.wheelDelta/40:t.detail?-t.detail/3:3*-t.deltaY,S.y+=.01*e,d.dispatchEvent(L),d.dispatchEvent(R)}}function c(t){if(d.enabled!==!1){switch(t.touches.length){case 1:g=f.TOUCH_ROTATE,x.copy(k(t.touches[0].pageX,t.touches[0].pageY)),b.copy(x);break;default:g=f.TOUCH_ZOOM_PAN;var e=t.touches[0].pageX-t.touches[1].pageX,i=t.touches[0].pageY-t.touches[1].pageY;C=M=Math.sqrt(e*e+i*i);var n=(t.touches[0].pageX+t.touches[1].pageX)/2,r=(t.touches[0].pageY+t.touches[1].pageY)/2;P.copy(O(n,r)),T.copy(P)}d.dispatchEvent(L)}}function u(t){if(d.enabled!==!1)switch(t.touches.length){case 1:b.copy(x),x.copy(k(t.touches[0].pageX,t.touches[0].pageY));break;default:var e=t.touches[0].pageX-t.touches[1].pageX,i=t.touches[0].pageY-t.touches[1].pageY;C=Math.sqrt(e*e+i*i);var n=(t.touches[0].pageX+t.touches[1].pageX)/2,r=(t.touches[0].pageY+t.touches[1].pageY)/2;T.copy(O(n,r))}}function h(t){if(d.enabled!==!1){switch(t.touches.length){case 0:g=f.NONE;break;case 1:g=f.TOUCH_ROTATE,x.copy(k(t.touches[0].pageX,t.touches[0].pageY)),b.copy(x)}d.dispatchEvent(R)}}function l(t){t.preventDefault()}var d=this,f={NONE:-1,ROTATE:0,ZOOM:1,PAN:2,TOUCH_ROTATE:3,TOUCH_ZOOM_PAN:4};this.object=t,this.domElement=void 0!==e?e:document,this.enabled=!0,this.screen={left:0,top:0,width:0,height:0},this.rotateSpeed=1,this.zoomSpeed=1.2,this.panSpeed=.3,this.noRotate=!1,this.noZoom=!1,this.noPan=!1,this.staticMoving=!1,this.dynamicDampingFactor=.2,this.minDistance=0,this.maxDistance=1/0,this.keys=[65,83,68],this.target=new N;var p=1e-6,m=new N,g=f.NONE,v=f.NONE,y=new N,b=new I,x=new I,_=new N,w=0,S=new I,A=new I,M=0,C=0,P=new I,T=new I;this.target0=this.target.clone(),this.position0=this.object.position.clone(),this.up0=this.object.up.clone();var E={type:"change"},L={type:"start"},R={type:"end"};this.handleResize=function(){if(this.domElement===document)this.screen.left=0,this.screen.top=0,this.screen.width=window.innerWidth,this.screen.height=window.innerHeight;else{var t=this.domElement.getBoundingClientRect(),e=this.domElement.ownerDocument.documentElement;this.screen.left=t.left+window.pageXOffset-e.clientLeft,this.screen.top=t.top+window.pageYOffset-e.clientTop,this.screen.width=t.width,this.screen.height=t.height}},this.handleEvent=function(t){"function"==typeof this[t.type]&&this[t.type](t)};var O=function(){var t=new I;return function(e,i){return t.set((e-d.screen.left)/d.screen.width,(i-d.screen.top)/d.screen.height),t}}(),k=function(){var t=new I;return function(e,i){return t.set((e-.5*d.screen.width-d.screen.left)/(.5*d.screen.width),(d.screen.height+2*(d.screen.top-i))/d.screen.width),t}}();this.rotateCamera=function(){var t,e=new N,i=new D,n=new N,r=new N,o=new N,a=new N;return function(){a.set(x.x-b.x,x.y-b.y,0),t=a.length(),t?(y.copy(d.object.position).sub(d.target),n.copy(y).normalize(),r.copy(d.object.up).normalize(),o.crossVectors(r,n).normalize(),r.setLength(x.y-b.y),o.setLength(x.x-b.x),a.copy(r.add(o)),e.crossVectors(a,y).normalize(),t*=d.rotateSpeed,i.setFromAxisAngle(e,t),y.applyQuaternion(i),d.object.up.applyQuaternion(i),_.copy(e),w=t):!d.staticMoving&&w&&(w*=Math.sqrt(1-d.dynamicDampingFactor),y.copy(d.object.position).sub(d.target),i.setFromAxisAngle(_,w),y.applyQuaternion(i),d.object.up.applyQuaternion(i)),b.copy(x)}}(),this.zoomCamera=function(){var t;g===f.TOUCH_ZOOM_PAN?(t=M/C,M=C,y.multiplyScalar(t),void 0===d.object.fov&&(d.object.zoom*=t)):(t=1+(A.y-S.y)*d.zoomSpeed,1!==t&&t>0&&(y.multiplyScalar(t),void 0===d.object.fov&&(d.object.zoom/=t),d.staticMoving?S.copy(A):S.y+=(A.y-S.y)*this.dynamicDampingFactor))},this.panCamera=function(){var t=new I,e=new N,i=new N;return function(){if(t.copy(T).sub(P),t.lengthSq()){if(void 0===d.object.fov){var n=(d.object.right-d.object.left)/d.object.zoom,r=(d.object.top-d.object.bottom)/d.object.zoom;t.x*=n,t.y*=r}else t.multiplyScalar(y.length()*d.panSpeed);i.copy(y).cross(d.object.up).setLength(t.x),i.add(e.copy(d.object.up).setLength(t.y)),d.object.position.add(i),d.target.add(i),d.staticMoving?P.copy(T):P.add(t.subVectors(T,P).multiplyScalar(d.dynamicDampingFactor))}}}(),this.checkDistances=function(){d.noZoom&&d.noPan||(y.lengthSq()>d.maxDistance*d.maxDistance&&(d.object.position.addVectors(d.target,y.setLength(d.maxDistance)),S.copy(A)),y.lengthSq()<d.minDistance*d.minDistance&&(d.object.position.addVectors(d.target,y.setLength(d.minDistance)),S.copy(A)))},this.update=function(){y.subVectors(d.object.position,d.target),d.noRotate||d.rotateCamera(),d.noZoom||d.zoomCamera(),d.noPan||d.panCamera(),d.object.position.addVectors(d.target,y),d.checkDistances(),d.object.lookAt(d.target),m.distanceToSquared(d.object.position)>p&&(d.dispatchEvent(E),m.copy(d.object.position))},this.reset=function(){g=f.NONE,v=f.NONE,d.target.copy(d.target0),d.object.position.copy(d.position0),d.object.up.copy(d.up0),y.subVectors(d.object.position,d.target),d.object.lookAt(d.target),d.dispatchEvent(E),m.copy(d.object.position)},this.dispose=function(){this.domElement.removeEventListener("contextmenu",l,!1),this.domElement.removeEventListener("mousedown",r,!1),this.domElement.removeEventListener("mousewheel",s,!1),this.domElement.removeEventListener("wheel",s,!1),this.domElement.removeEventListener("MozMousePixelScroll",s,!1),this.domElement.removeEventListener("touchstart",c,!1),this.domElement.removeEventListener("touchend",h,!1),this.domElement.removeEventListener("touchmove",u,!1),document.removeEventListener("mousemove",o,!1),document.removeEventListener("mouseup",a,!1),window.removeEventListener("keydown",i,!1),window.removeEventListener("keyup",n,!1)},this.domElement.addEventListener("contextmenu",l,!1),this.domElement.addEventListener("mousedown",r,!1),this.domElement.addEventListener("mousewheel",s,!1),this.domElement.addEventListener("wheel",s,!1),this.domElement.addEventListener("MozMousePixelScroll",s,!1),this.domElement.addEventListener("touchstart",c,!1),this.domElement.addEventListener("touchend",h,!1),this.domElement.addEventListener("touchmove",u,!1),window.addEventListener("keydown",i,!1),window.addEventListener("keyup",n,!1),this.handleResize(),this.update()}function fr(t){if(void 0===t)return"";var e=[];for(var i in t){var n=t[i];n!==!1&&e.push("#define "+i+" "+n)}return e.join("\n")+"\n"}function pr(t,e){e=e||{};var i=t+"|";for(var n in e)i+=n+":"+e[n];if(!wv[i]){var r=fr(e),o=gv.get("shader/"+t);if(!o)throw"empty shader, '"+t+"'";o=o.replace(_v,function(t,e){var i="shader/chunk/"+e+".glsl",n=gv.get(i)||bp[e];return n?n:""}),wv[i]=r+o}return wv[i]}function mr(t,e,i,n){function r(e){var n=e%u,r=Math.floor(e/u),o=n*m,a=r*g;i.camera.setViewOffset(m*u,g*u,o,a,m,g),i.render(),h?v.drawImage(t.domElement,Math.floor(o/2),Math.floor(a/2),Math.ceil(m/2),Math.ceil(g/2)):v.drawImage(t.domElement,Math.floor(o),Math.floor(a),Math.ceil(m),Math.ceil(g)),"function"==typeof l&&l(e+1,f,!1)}function o(){i.setSampling(y),i.camera.view=null,"function"==typeof d&&d(f+1,f,!1)}function a(){for(var t=0;t<=f;++t)t===f?o():r(t)}function s(){function t(){e===f?o():r(e),e+=1}for(var e=0,i=0;i<=f;++i)setTimeout(t,0,i)}var c=n||{},u=void 0!==c.factor?c.factor:2,h=void 0!==c.antialias&&c.antialias,l=c.onProgress,d=c.onFinish;h&&(u*=2);var f=u*u,p=document.createElement("canvas"),m=i.width,g=i.height;h?(p.width=m*u/2,p.height=g*u/2):(p.width=m*u,p.height=g*u);var v=p.getContext("2d"),y=i.sampleLevel;i.setSampling(-1),this.render=a,this.renderAsync=s,this.canvas=p}function gr(t,e,i,n,r){i=i||1,n=n||0;var o,a,s,c=r?r.length:t.length/i,u=0,h=0;if(r)for(a=0;a<c;++a)s=(t[r[a]*i+n]+e)%e,o=s/e*Sv-Math.PI,u+=Math.cos(o),h+=Math.sin(o);else for(a=n;a<c;a+=i)s=(t[a]+e)%e,o=s/e*Sv-Math.PI,u+=Math.cos(o),h+=Math.sin(o);u/=c,h/=c;var l=Math.atan2(h,u),d=(l+Math.PI)/Sv*e;return d}function vr(t,e,i,n){var r=t.length;i=i||new Float32Array(r),n=n||0;for(var o=0;o<r;o+=3)i[n+o+0]=(t[o+0]+e[o+0])/2,i[n+o+1]=(t[o+1]+e[o+1])/2,i[n+o+2]=(t[o+2]+e[o+2])/2;return i}function yr(t,e){for(var i=new Float32Array(t),n=0;n<t;++n)i[n]=e;return i}function br(t,e,i,n){for(var r,o=new Float32Array(3*t),a=0;a<t;++a)r=3*a,o[r+0]=e,o[r+1]=i,o[r+2]=n;return o}function xr(t,e){for(var i=t.length,n=new Float32Array(i),r=0;r<i;r++)n[r]=Math.min(t[r],e[r]);return n}function _r(t,e,i,n,r){for(var o=0;o<r;++o)e[n+o]=t[i+o]}function wr(t,e,i,n){_r(t,t,e,i,n)}function Sr(t,e,i,n){function r(e,i){d=t[e],t[e]=t[i],t[i]=d}e=e||function(t,e){return t>e?1:t<e?-1:0},i=i||0,n=(n||t.length)-1;for(var o,a,s=[],c=-1,u=i,h=n,l=0,d=0;;)if(h-u<=25){for(a=u+1;a<=h;++a){for(l=t[a],o=a-1;o>=u&&e(t[o],l)>0;)t[o+1]=t[o],--o;t[o+1]=l}if(c===-1)break;h=s[c--],u=s[c--]}else{var f=u+h>>1;for(o=u+1,a=h,r(f,o),e(t[u],t[h])>0&&r(u,h),e(t[o],t[h])>0&&r(o,h),e(t[u],t[o])>0&&r(u,o),l=t[o];;){do o++;while(e(t[o],l)<0);do a--;while(e(t[a],l)>0);if(a<o)break;r(o,a)}t[u+1]=t[a],t[a]=l,h-o+1>=a-u?(s[++c]=o,s[++c]=h,h=a-1):(s[++c]=u,s[++c]=a-1,u=o)}return t}function Ar(t,e,i,n,r){var o,a,s,c,u=t.height,h=t.width,l=t.getContext("2d"),d=l.getImageData(0,0,h,u).data;for(s=!1,a=0;a<u;a++){for(o=0;o<h;o++)if(c=4*(a*h+o),d[c]!==e||d[c+1]!==i||d[c+2]!==n||d[c+3]!==r){s=!0;break}if(s)break}var f=a;for(s=!1,o=0;o<h;o++){for(a=0;a<u;a++)if(c=4*(a*h+o),d[c]!==e||d[c+1]!==i||d[c+2]!==n||d[c+3]!==r){s=!0;break}if(s)break}var p=o;for(s=!1,a=u-1;a>=0;a--){for(o=h-1;o>=0;o--)if(c=4*(a*h+o),d[c]!==e||d[c+1]!==i||d[c+2]!==n||d[c+3]!==r){s=!0;break}if(s)break}var m=a;for(s=!1,o=h-1;o>=0;o--){for(a=u-1;a>=0;a--)if(c=4*(a*h+o),d[c]!==e||d[c+1]!==i||d[c+2]!==n||d[c+3]!==r){s=!0;break}if(s)break}var g=o,v=document.createElement("canvas");v.width=g-p,v.height=m-f;var y=v.getContext("2d");return y.drawImage(t,p,f,v.width,v.height,0,0,v.width,v.height),v}function Mr(t,e){function i(e){var i=s;c&&(i*=2),e&&(i=1/i),t.scene.traverse(function(t){var e=t.material;e&&e.linewidth&&(e.linewidth*=i),e&&e.uniforms&&e.uniforms.size&&void 0===e.uniforms.size.__seen&&(e.uniforms.size.value*=i,e.uniforms.size.__seen=!0)}),t.scene.traverse(function(t){var e=t.material;e&&e.uniforms&&e.uniforms.size&&delete e.uniforms.size.__seen})}function n(t){if(a){var e=f,i=0|(u?0:255*e.r),n=0|(u?0:255*e.g),r=0|(u?0:255*e.b),o=0|(u?0:255);return Ar(t,i,n,r,o)}return t}function r(t,e,i){"function"==typeof o.onProgress&&o.onProgress(t,e,i)}var o=e||{},a=void 0!==o.trim&&o.trim,s=void 0!==o.factor?o.factor:1,c=void 0!==o.antialias&&o.antialias,u=void 0!==o.transparent&&o.transparent,h=t.renderer,l=t.camera,d=h.getClearAlpha(),f=h.getClearColor();return new Promise(function(e){function o(o,s){var c=n(a.canvas);c.toBlob(function(n){h.setClearAlpha(d),i(!0),t.requestRender(),r(s,s,!0),e(n)},"image/png")}var a=new mr(h,l,t,{factor:s,antialias:c,onProgress:r,onFinish:o});h.setClearAlpha(u?0:1),i(),a.renderAsync()})}function Cr(t,e){var i;t.traverseVisible(function(t){if(t instanceof Ge&&t.sortParticles){var n=t.geometry.attributes,r=n.position.count;if(0!==r){Mv.multiplyMatrices(e.matrixWorldInverse,t.matrixWorld),Cv.multiplyMatrices(e.projectionMatrix,Mv);var o,a,s,c;for(t.userData.sortData?(o=t.userData.sortData,s=o.__zArray,a=o.__sortArray,c=o.__cmpFn):(s=new Float32Array(r),a=new Uint32Array(r),c=function(t,e){var i=s[t],n=s[e];return i>n?1:i<n?-1:0},o={__zArray:s,__sortArray:a,__cmpFn:c},t.userData.sortData=o),i=0;i<r;++i)Av.fromArray(n.position.array,3*i),Av.applyProjection(Cv),s[i]=-Av.z,a[i]=i;Sr(a,c);var u,h,l,d;for(var f in n){var p=n[f],m=p.array,g=p.itemSize;for(o[f]||(o[f]=new Float32Array(g*r)),d=o[f],o[f]=m,i=0;i<r;++i){u=a[i];for(var v=0;v<g;++v)h=u*g+v,l=i*g+v,d[l]=m[h]}n[f].array=d,n[f].needsUpdate=!0}}}})}function Pr(t,e,i,n,r){var o=i.getSize().height,a=i.getPixelRatio(),s="OrthographicCamera"===e.type;Pv.getInverse(e.projectionMatrix),Tv.copy(e.projectionMatrix).transpose(),t.traverse(function(t){var e=t.material;if(e){var i=t.material.uniforms;if(i){if(e.clipNear){var c=(50-e.clipNear)/50,u=n-r*c;i.nearClip.value=u}i.canvasHeight&&(i.canvasHeight.value=o),i.pixelRatio&&(i.pixelRatio.value=a),i.projectionMatrixInverse&&i.projectionMatrixInverse.value.copy(Pv),i.projectionMatrixTranspose&&i.projectionMatrixTranspose.value.copy(Tv),i.ortho&&(i.ortho.value=s)}}})}function Tr(e){function i(){et={fogColor:new Pt(0),fogNear:50,fogFar:100,backgroundColor:new Pt(0),cameraType:"perspective",cameraFov:40,cameraZ:-80,clipNear:0,clipFar:100,clipDist:10,spinAxis:null,spinAngle:.01,lightColor:new Pt(14540253),lightIntensity:1,ambientColor:new Pt(14540253),ambientIntensity:.2,sampleLevel:0}}function n(){var t=new N(0,0,0);nt=new Ce(et.cameraFov,W/X,.1,1e4),nt.position.z=et.cameraZ,nt.lookAt(t),rt=new Pe(W/-2,W/2,X/2,X/-2,.1,1e4),rt.position.z=et.cameraZ,rt.lookAt(t),ot="orthographic"===et.cameraType?rt:nt,ot.updateProjectionMatrix()}function r(){var t=window.devicePixelRatio;try{pt=new Te({preserveDrawingBuffer:!0,alpha:!0,antialias:!0})}catch(t){return G.innerHTML=hv,!1}pt.setPixelRatio(t),pt.setSize(W,X),pt.autoClear=!1,pt.sortObjects=!0,Xn(pt.extensions.get("EXT_frag_depth")),pt.extensions.get("OES_element_index_uint"),Wn(pt.extensions.get("OES_texture_float")&&pt.extensions.get("WEBGL_color_buffer_float")||"Chrome"===ov&&pt.extensions.get("OES_texture_float")),G.appendChild(pt.domElement);var e=W*t,i=X*t;pt.extensions.get("OES_texture_float"),mt=pt.extensions.get("OES_texture_half_float"),pt.extensions.get("WEBGL_color_buffer_float"),gt=new St(e,i,{minFilter:ll,magFilter:ll,stencilBuffer:!1,format:Ll,type:sv?Sl:vl}),gt.texture.generateMipmaps=!1,vt=new St(e,i,{minFilter:ll,magFilter:ll,format:Ll}),yt=new St(e,i,{minFilter:ll,magFilter:ll,format:Ll,type:av?vl:mt?Al:sv?Sl:vl}),bt={tForeground:{type:"t",value:null},scale:{type:"f",value:1}},xt=new Ct({uniforms:bt,vertexShader:pr("Quad.vert"),fragmentShader:pr("Quad.frag"),premultipliedAlpha:!0,transparent:!0,blending:yh,depthTest:!1,depthWrite:!1}),_t=new Pe(-1,1,1,-1,0,1),wt=(new Le).add(new Se(new gn(2,2),xt))}function o(){at||(at=new Le),ut=new He,ut.name="rotationGroup",at.add(ut),ht=new He,ht.name="modelGroup",ut.add(ht),lt=new He,lt.name="pickingGroup",ut.add(lt),dt=new He,dt.name="backgroundGroup",ut.add(dt),ft=new He,ft.name="helperGroup",ut.add(ft),at.fog=new Ie,st=new oi(et.lightColor,et.lightIntensity),at.add(st),ct=new ui(et.ambientLight,et.ambientIntensity),at.add(ct)}function a(){var t=new Uint16Array([0,1,1,2,2,3,3,0,4,5,5,6,6,7,7,4,0,4,1,5,2,6,3,7]),e=new Float32Array(24),i=new ue;i.setIndex(new Kt(t,1)),i.addAttribute("position",new Kt(e,3));var n=new Ct({uniforms:{uColor:{value:new Pt("skyblue")}},vertexShader:pr("BasicLine.vert"),fragmentShader:pr("BasicLine.frag"),linewidth:2});Mt=new $e(i,n),ft.add(Mt)}function s(){var t=Mt.geometry.attributes.position,e=t.array,i=Tt.min,n=Tt.max;e[0]=n.x,e[1]=n.y,e[2]=n.z,e[3]=i.x,e[4]=n.y,e[5]=n.z,e[6]=i.x,e[7]=i.y,e[8]=n.z,e[9]=n.x,e[10]=i.y,e[11]=n.z,e[12]=n.x,e[13]=n.y,e[14]=i.z,e[15]=i.x,e[16]=n.y,e[17]=i.z,e[18]=i.x,e[19]=i.y,e[20]=i.z,e[21]=n.x,e[22]=i.y,e[23]=i.z,t.needsUpdate=!0,Tt.isEmpty()||Mt.geometry.computeBoundingSphere()}function c(){function t(t){t.preventDefault()}At=new dr(ot,pt.domElement),At.rotateSpeed=2,At.zoomSpeed=1.2,At.panSpeed=.8,At.staticMoving=!0,At.keys=[65,83,68],At.addEventListener("change",T,!1),pt.domElement.addEventListener("mousewheel",t,!1),pt.domElement.addEventListener("wheel",t,!1),pt.domElement.addEventListener("MozMousePixelScroll",t,!1),pt.domElement.addEventListener("touchmove",t,!1),document.addEventListener("mousemove",At.update.bind(At),!1),document.addEventListener("touchmove",At.update.bind(At),!1),At.addEventListener("change",function(){H.orientationChanged.dispatch()},!1)}function u(){it=new lr}function h(e,i){i?i.forEach(function(t){l(e,t)}):l(e),e.background?(dt.add(e.group),dt.add(e.wireframeGroup)):(ht.add(e.group),ht.add(e.wireframeGroup)),e.pickable&&lt.add(e.pickingGroup),t.Debug&&s()}function l(t,e){function i(t){"Group"===t.type?t.children.forEach(function(t){t.userData.instance=e}):t.userData.instance=e}var n=t.getMesh();n.userData.buffer=t,e&&(n.applyMatrix(e.matrix),i(n)),t.group.add(n);var r=t.getWireframeMesh();if(r.userData.buffer=t,e&&(r.matrix.copy(n.matrix),r.position.copy(n.position),r.quaternion.copy(n.quaternion),r.scale.copy(n.scale),i(r)),t.wireframeGroup.add(r),t.pickable){var o=t.getPickingMesh();o.userData.buffer=t,e&&(o.matrix.copy(n.matrix),o.position.copy(n.position),o.quaternion.copy(n.quaternion),o.scale.copy(n.scale),i(o)),t.pickingGroup.add(o)}e?f(t.geometry,e.matrix):f(t.geometry)}function d(e){ut.children.forEach(function(t){t.remove(e.group),t.remove(e.wireframeGroup)}),e.pickable&&lt.remove(e.pickingGroup),f(),t.Debug&&s()}function f(t,e){function i(t,e){if(0!==t.attributes.position.count){t.boundingBox||t.computeBoundingBox();var i;e?(i=t.boundingBox.clone(),i.applyMatrix4(e)):i=t.boundingBox,i.min.equals(i.max)&&i.expandByScalar(5),Tt.expandByPoint(i.min),Tt.expandByPoint(i.max)}}function n(t){if(void 0!==t.geometry){var e;t.userData.instance&&(e=t.userData.instance.matrix),i(t.geometry,e)}}t?Array.isArray(t)?t.forEach(function(t){i(t,e)}):i(t,e):(Tt.makeEmpty(),ht.traverse(n),dt.traverse(n)),Tt.size(It),Lt=It.length(),At.maxDistance=10*Lt}function p(){return new Promise(function(t){pt.domElement.toBlob(t,"image/png")})}function m(t){return Mr(this,t)}function g(t,e,i,n){var r=et;void 0!==t&&r.lightColor.set(t),void 0!==e&&(r.lightIntensity=e),void 0!==i&&r.ambientColor.set(i),void 0!==n&&(r.ambientIntensity=n),T()}function v(t,e,i){var n=et;void 0!==t&&n.fogColor.set(t),void 0!==e&&(n.fogNear=e),void 0!==i&&(n.fogFar=i),T()}function y(t){var e=et;t&&e.backgroundColor.set(t),v(e.backgroundColor),pt.setClearColor(e.backgroundColor,0),pt.domElement.style.backgroundColor=e.backgroundColor.getStyle(),T()}function b(t){void 0!==t&&(et.sampleLevel=t,K=t),T()}function x(t,e){var i=et;t&&(i.cameraType=t),e&&(i.cameraFov=e),"orthographic"===i.cameraType?ot!==rt&&(ot=rt,ot.position.copy(nt.position),ot.up.copy(nt.up),I()):ot!==nt&&(ot=nt,ot.position.copy(rt.position),ot.up.copy(rt.up)),nt.fov=i.cameraFov,At.object=ot,ot.lookAt(At.target),ot.updateProjectionMatrix(),T()}function _(t,e,i){var n=et;void 0!==t&&(n.clipNear=t),void 0!==e&&(n.clipFar=e),void 0!==i&&(n.clipDist=i),T()}function w(t,e){void 0!==t&&(et.spinAxis=t),void 0!==e&&(et.spinAngle=e)}function S(t,e){W=t||1,X=e||1,nt.aspect=W/X,rt.left=-W/2,rt.right=W/2,rt.top=X/2,rt.bottom=-X/2,ot.updateProjectionMatrix();var i=window.devicePixelRatio;pt.setPixelRatio(i),pt.setSize(W,X);var n=W*i,r=X*i;gt.setSize(n,r),vt.setSize(n,r),yt.setSize(n,r),At.handleResize(),T()}function A(){if(G===document)S(window.innerWidth,window.innerHeight);else{var t=G.getBoundingClientRect();S(t.width,t.height)}}function M(t){var e=Ot.memory,i=Ot.render;if(t)e.programs=0,e.geometries=0,e.textures=0,i.calls=0,i.vertices=0,i.faces=0,i.points=0;else{var n=pt.info,r=n.memory,o=n.render;e.programs=r.programs,e.geometries=r.geometries,e.textures=r.textures,i.calls+=o.calls,i.vertices+=o.vertices,i.faces+=o.faces,i.points+=o.points}}function C(t){At.target.add(t),ot.position.add(t)}function P(){At.update();var e=performance.now()-it.startTime;if(e>500&&!Q&&K<3&&K!==-1){var i=K;K=3,Z=!0,B(),Q=!0,K=i,t.Debug&&uv.log("rendered still frame")}var n=et;n.spinAxis&&n.spinAngle&&(Dt(n.spinAxis,n.spinAngle*it.lastDuration/16),T()),requestAnimationFrame(P)}function T(){Z||(performance.now()-it.startTime>22&&(it.begin(),Q=!1),Z=!0,requestAnimationFrame(function(){B(),it.update()}))}function E(){var t=et;J=Rt.copy(ot.position).sub(At.target).length(),J||(ot.position.set(0,0,t.cameraZ),J=Math.abs(t.cameraZ)),tt=Math.max(10,.5*Lt),tt+=Tt.center(Rt).length(),(tt===1/0||tt===-(1/0)||isNaN(tt))&&(tt=50);var e=(50-t.clipNear)/50,i=-(50-t.clipFar)/50;ot.near=Math.max(.1,t.clipDist,J-tt*e),ot.far=Math.max(1,J+tt*i);var n=(50-t.fogNear)/50,r=-(50-t.fogFar)/50,o=at.fog;o.color.set(t.fogColor),o.near=Math.max(.1,J-tt*n),o.far=Math.max(1,J+tt*r)}function I(){E();var t=wn(nt.fov),e=(ot.near+ot.far)/2,i=2*Math.tan(t/2)*e;rt.zoom=X/i}function L(){ot.updateMatrix(),ot.updateMatrixWorld(!0),ot.matrixWorldInverse.getInverse(ot.matrixWorld),ot.updateProjectionMatrix(),Pr(at,ot,pt,J,tt),Cr(at,ot)}function R(t,e,i,n){ht.visible=t,lt.visible=e,dt.visible=i,ft.visible=n}function O(){Rt.copy(ot.position).sub(At.target).setLength(100*Lt),st.position.copy(ot.position).add(Rt),st.color.set(et.lightColor),st.intensity=et.lightIntensity,ct.color.set(et.ambientColor),ct.intensity=et.ambientIntensity}function k(){pt.clearTarget(gt),R(!1,!0,!1,!1),pt.render(at,ot,gt),M(),pt.setRenderTarget(null)}function F(e){e?pt.clearTarget(e):pt.clear(),R(!1,!1,!0,!1),pt.render(at,ot,e),e?pt.clearTarget(e,!1,!0,!1):pt.clearDepth(),M(),R(!0,!1,!1,t.Debug),pt.render(at,ot,e),M()}function z(){var t=Ev[Math.max(0,Math.min(K,5))],e=1/t.length,i=1/32;bt.tForeground.value=vt.texture;for(var n=vt.width,r=vt.height,o=0;o<t.length;++o){var a=t[o];ot.setViewOffset(n,r,a[0],a[1],n,r),L();var s=e,c=-.5+(o+.5)/t.length;s+=i*c,bt.scale.value=s,F(vt),pt.render(wt,_t,yt,0===o)}bt.scale.value=1,bt.tForeground.value=yt.texture,pt.render(wt,_t,null,!0),ot.view=null}function B(t){return Y?void uv.warn("tried to call 'render' from within 'render'"):(Y=!0,E(),L(),O(),M(!0),t?k():K>0?z():F(),Y=!1,void(Z=!1))}function U(){uv.log("scene cleared"),at.remove(ut),o(),pt.clear()}function j(t,e){if(void 0===e?Tt.isEmpty()||kt(Tt.center()):kt(e),t){var i;if(t===!0){var n=It,r=Math.max(n.x,n.y,n.z),o=Math.min(n.x,n.y,n.z);i=r+Math.sqrt(o)}else i=t;var a=wn(nt.fov),s=W/X,c=X<W?1:s;i=Math.abs(.5*i/c/Math.sin(a/2)),i+=et.clipDist,Nt(i,!0)}T(),H.orientationChanged.dispatch()}function $(){return[At.target.toArray(),ot.position.toArray(),ot.up.toArray()]}function V(t){At.target.fromArray(t[0]),ot.position.fromArray(t[1]),ot.up.fromArray(t[2]),T(),H.orientationChanged.dispatch()}var G,H={orientationChanged:new xn};G=e?document.getElementById(e):document.createElement("div");var W,X;if(G===document)W=window.innerWidth||1,X=window.innerHeight||1;else{var q=G.getBoundingClientRect();W=q.width||1,X=q.height||1}var Y,Z,K,Q,J,tt,et;i();var it;u();var nt,rt,ot;n();var at,st,ct,ut,ht,lt,dt,ft;o();var pt,mt,gt,vt,yt,bt,xt,_t,wt;if(r()===!1)return this.container=G,void uv.error("Viewer: could not initialize renderer");var At;c();var Mt,Tt=new Et,It=new N,Lt=0;a(),y(),v();var Rt=new N,Ot={memory:{programs:0,geometries:0,textures:0},render:{calls:0,vertices:0,faces:0,points:0}},Dt=function(){var t=new N,e=new D,i=new N,n=new N,r=new N,o=new N;return function(a,s){t.copy(ot.position).sub(At.target),i.copy(t).normalize(),n.copy(ot.up).normalize(),r.crossVectors(n,i).normalize(),i.setLength(a.z),n.setLength(a.y),r.setLength(a.x),o.copy(r.sub(n).add(i)),e.setFromAxisAngle(o.normalize(),s),t.applyQuaternion(e),ot.up.applyQuaternion(e),ot.position.addVectors(At.target,t),ot.lookAt(At.target)}}(),Nt=function(){var t=new N,e=new N;return function(i,n){t.copy(ot.position).sub(At.target),e.copy(t).normalize(),e.setLength(i),n?t.copy(e):t.add(e),ot.position.addVectors(At.target,t),ot.lookAt(At.target),I()}}(),kt=function(){var t=new N;return function(e){t.copy(e).sub(At.target),C(t)}}(),Ft=function(){var t=new Float32Array(4),e=new Uint8Array(4);return function(i,n){i*=window.devicePixelRatio,n*=window.devicePixelRatio;var r,o,a,s=sv?t:e;return B(!0),pt.readRenderTargetPixels(gt,i,n,1,1,s),r=sv?Math.round(255*s[0])<<16&16711680|Math.round(255*s[1])<<8&65280|255&Math.round(255*s[2]):s[0]<<16|s[1]<<8|s[2],o=lt.getObjectById(Math.round(s[3])),o&&o.userData.instance&&(a=o.userData.instance),{gid:r,instance:a}}}(),zt=function(){var t=new N,e=new N,i=new N,n=new N,r=new N(0,0,1);return function(o,a,s,c){At.reset(),j(c,s),t.copy(ot.position).sub(At.target).normalize(),i.crossVectors(t,o),Dt(i,-t.angleTo(o)),e.copy(ot.up).normalize(),n.crossVectors(e,a).normalize();var u=e.angleTo(a);r.dot(n)<0&&(u*=-1),t.copy(ot.position).sub(At.target).normalize(),t.dot(r)<0&&(u*=-1),Dt(r,u)}}();this.container=G,this.stats=it,this.signals=H,this.rotationGroup=ut,this.add=h,this.remove=d,this.clear=U,this.getImage=p,this.makeImage=m,this.setLight=g,this.setFog=v,this.setBackground=y,this.setSampling=b,this.setCamera=x,this.setClip=_,this.setSpin=w,this.setSize=S,this.handleResize=A,this.rotate=Dt,this.zoom=Nt,this.center=kt,this.centerView=j,this.alignView=zt,this.getOrientation=$,this.setOrientation=V,this.boundingBox=Tt,this.pick=Ft,this.requestRender=T,this.render=B,this.animate=P,this.updateHelper=s,this.controls=At,this.renderer=pt,this.scene=at,Object.defineProperties(this,{camera:{get:function(){return ot}},width:{get:function(){return W}},height:{get:function(){return X}},sampleLevel:{get:function(){return K}}})}function Er(t,e){this.count=0,this.words=new Uint32Array(8),this.resize(t),e&&this.flip_all()}function Ir(t,e){this.type=t,this.scale=e||1,this.max=10}function Lr(t){var e,i=t.length,n=t.length/3,r=0,o=0,a=0;for(e=0;e<i;e+=3)r+=t[e+0],o+=t[e+1],a+=t[e+2];return new N(r/n,o/n,a/n)}function Rr(t,e,i){return i?t.sub(i).projectOnVector(e).add(i):t.projectOnVector(e),t}function Or(t){for(var e=+(1/0),i=+(1/0),n=+(1/0),r=-(1/0),o=-(1/0),a=-(1/0),s=0,c=t.length;s<c;s+=3){var u=t[s],h=t[s+1],l=t[s+2];u<e&&(e=u),h<i&&(i=h),l<n&&(n=l),u>r&&(r=u),h>o&&(o=h),l>a&&(a=l)}return[Fr([e,i,n]),Fr([r,o,a])]}function Dr(t,e){for(var i=0,n=e.length;i<n;i+=3){var r=e[i],o=e[i+1],a=e[i+2];e[i]=t[0]*r+t[4]*o+t[8]*a+t[12],e[i+1]=t[1]*r+t[5]*o+t[9]*a+t[13],e[i+2]=t[2]*r+t[6]*o+t[10]*a+t[14]}}function Nr(t,e){for(var i=0,n=e.length;i<n;i+=3){var r=e[i],o=e[i+1],a=e[i+2];e[i]=t[0]*r+t[3]*o+t[6]*a,e[i+1]=t[1]*r+t[4]*o+t[7]*a,e[i+2]=t[2]*r+t[5]*o+t[8]*a}}function kr(t){for(var e=0,i=t.length;e<i;e+=3){var n=t[e],r=t[e+1],o=t[e+2],a=1/Math.sqrt(n*n+r*r+o*o);
	t[e]=n*a,t[e+1]=r*a,t[e+2]=o*a}}function Fr(t){return new Float32Array(t||3)}function zr(t,e,i){var n=e[0],r=e[1],o=e[2],a=i[0],s=i[1],c=i[2];t[0]=r*c-o*s,t[1]=o*a-n*c,t[2]=n*s-r*a}function Br(t,e,i){t[0]=e[0]-i[0],t[1]=e[1]-i[1],t[2]=e[2]-i[2]}function Ur(t,e,i){t[0]=e[i],t[1]=e[i+1],t[2]=e[i+2]}function jr(t){return Math.sqrt(t[0]*t[0]+t[1]*t[1]+t[2]*t[2])}function $r(t,e,i){Vr(t,e,1/i)}function Vr(t,e,i){t[0]=e[0]*i,t[1]=e[1]*i,t[2]=e[2]*i}function Gr(t,e){Vr(t,e,1/jr(e))}function Hr(t,e,i){t[0]=e[0]-i,t[1]=e[1]-i,t[2]=e[2]-i}function Wr(t,e,i){t[0]=e[0]+i,t[1]=e[1]+i,t[2]=e[2]+i}function Xr(t,e){t[0]=Math.floor(e[0]),t[1]=Math.floor(e[1]),t[2]=Math.floor(e[2])}function qr(t,e){t[0]=Math.ceil(e[0]),t[1]=Math.ceil(e[1]),t[2]=Math.ceil(e[2])}function Yr(t,e){t[0]=-e[0],t[1]=-e[1],t[2]=-e[2]}function Zr(t,e){this.cols=t,this.rows=e,this.size=this.cols*this.rows,this.data=new Float32Array(this.size)}function Kr(t,e){for(var i=0,n=0,r=e.rows,o=e.cols,a=0,s=0,c=0,u=e.data,h=t.data;i<r;s+=1,a+=o,i++)for(c=s,n=0;n<o;c+=r,n++)h[c]=u[a+n]}function Qr(t,e,i){for(var n=0,r=0,o=0,a=0,s=0,c=0,u=0,h=e.cols,l=e.rows,d=i.rows,f=e.data,p=i.data,m=t.data,g=0;n<l;a+=h,n++)for(c=0,r=0;r<d;u++,r++){for(s=a,g=0,o=0;o<h;s++,c++,o++)g+=f[s]*p[c];m[u]=g}}function Jr(t,e){var i=t.data,n=e.data,r=i[4],o=i[8],a=i[5],s=i[7],c=i[0],u=c*r,h=c*a,l=i[3],d=i[1],f=l*d,p=i[2],m=l*p,g=i[6],v=g*d,y=g*p,b=1/(u*o-h*s-f*o+m*s+v*a-y*r);n[0]=(r*o-a*s)*b,n[1]=-(d*o-p*s)*b,n[2]=-(-d*a+p*r)*b,n[3]=-(l*o-a*g)*b,n[4]=(c*o-y)*b,n[5]=-(h-m)*b,n[6]=-(-l*s+r*g)*b,n[7]=-(c*s-v)*b,n[8]=(u-f)*b}function to(t){var e=t.data;return e[0]*e[4]*e[8]-e[0]*e[5]*e[7]-e[3]*e[1]*e[8]+e[3]*e[2]*e[7]+e[6]*e[1]*e[5]-e[6]*e[2]*e[4]}function eo(t,e,i){var n=t.data,r=e.data,o=i.data,a=r[0],s=r[1],c=r[2],u=r[3],h=r[4],l=r[5],d=r[6],f=r[7],p=r[8],m=o[0],g=o[1],v=o[2],y=o[3],b=o[4],x=o[5],_=o[6],w=o[7],S=o[8];n[0]=a*m+s*y+c*_,n[1]=a*g+s*b+c*w,n[2]=a*v+s*x+c*S,n[3]=u*m+h*y+l*_,n[4]=u*g+h*b+l*w,n[5]=u*v+h*x+l*S,n[6]=d*m+f*y+p*_,n[7]=d*g+f*b+p*w,n[8]=d*v+f*x+p*S}function io(t){var e,i,n=0,r=t.rows,o=t.cols,a=t.data,s=new Array(o);for(i=0;i<o;++i)s[i]=0;for(e=0;e<r;++e)for(i=0;i<o;++i,++n)s[i]+=a[n];for(i=0;i<o;++i)s[i]/=r;return s}function no(t,e){var i,n,r=0,o=t.rows,a=t.cols,s=t.data;for(i=0;i<o;++i)for(n=0;n<a;++n,++r)s[r]-=e[n]}function ro(t,e){var i,n,r=0,o=t.rows,a=t.cols,s=t.data;for(i=0;i<o;++i)for(n=0;n<a;++n,++r)s[r]+=e[n]}function oo(t,e,i,n){n=t[e],t[e]=t[i],t[i]=n}function ao(t,e){return t=Math.abs(t),e=Math.abs(e),t>e?(e/=t,t*Math.sqrt(1+e*e)):e>0?(t/=e,e*Math.sqrt(1+t*t)):0}function so(t,e,i,n,r,o,a,s){for(var c=2*Dv,u=Nv,h=0,l=0,d=0,f=0,p=Math.max(o,30),m=0,g=0,v=0,y=0,b=0,x=0,_=0,w=0,S=0,A=0,M=0,C=0,P=0,T=0,E=0,I=0,L=0,R=4660,O=0,D=0,N=0,k=new Float64Array(a<<3);h<a;h++){for(d=0,M=0;d<o;d++)w=t[h*e+d],M+=w*w;if(k[h]=M,n){for(d=0;d<a;d++)n[h*r+d]=0;n[h*r+h]=1}}for(;f<p;f++){for(b=0,h=0;h<a-1;h++)for(l=h+1;l<a;l++){for(m=h*e|0,g=l*e|0,E=k[h],I=0,L=k[l],d=2,I+=t[m]*t[g],I+=t[m+1]*t[g+1];d<o;d++)I+=t[m+d]*t[g+d];if(!(Math.abs(I)<=c*Math.sqrt(E*L))){for(I*=2,C=E-L,P=ao(I,C),C<0?(T=.5*(P-C),_=Math.sqrt(T/P),x=I/(P*_*2)):(x=Math.sqrt((P+C)/(2*P)),_=I/(P*x*2)),E=0,L=0,d=2,S=x*t[m]+_*t[g],A=-_*t[m]+x*t[g],t[m]=S,t[g]=A,E+=S*S,L+=A*A,S=x*t[m+1]+_*t[g+1],A=-_*t[m+1]+x*t[g+1],t[m+1]=S,t[g+1]=A,E+=S*S,L+=A*A;d<o;d++)S=x*t[m+d]+_*t[g+d],A=-_*t[m+d]+x*t[g+d],t[m+d]=S,t[g+d]=A,E+=S*S,L+=A*A;if(k[h]=E,k[l]=L,b=1,n)for(v=h*r|0,y=l*r|0,d=2,S=x*n[v]+_*n[y],A=-_*n[v]+x*n[y],n[v]=S,n[y]=A,S=x*n[v+1]+_*n[y+1],A=-_*n[v+1]+x*n[y+1],n[v+1]=S,n[y+1]=A;d<a;d++)S=x*n[v+d]+_*n[y+d],A=-_*n[v+d]+x*n[y+d],n[v+d]=S,n[y+d]=A}}if(0===b)break}for(h=0;h<a;h++){for(d=0,M=0;d<o;d++)w=t[h*e+d],M+=w*w;k[h]=Math.sqrt(M)}for(h=0;h<a-1;h++){for(l=h,d=h+1;d<a;d++)k[l]<k[d]&&(l=d);if(h!=l&&(oo(k,h,l,M),n)){for(d=0;d<o;d++)oo(t,h*e+d,l*e+d,w);for(d=0;d<a;d++)oo(n,h*r+d,l*r+d,w)}}for(h=0;h<a;h++)i[h]=k[h];if(n)for(h=0;h<s;h++){for(M=h<a?k[h]:0;M<=u;){for(D=1/o,d=0;d<o;d++)R=214013*R+2531011,O=0!==(R>>16&32767&256)?D:-D,t[h*e+d]=O;for(f=0;f<2;f++)for(l=0;l<h;l++){for(M=0,d=0;d<o;d++)M+=t[h*e+d]*t[l*e+d];for(N=0,d=0;d<o;d++)w=t[h*e+d]-M*t[l*e+d],t[h*e+d]=w,N+=Math.abs(w);for(N=N?1/N:0,d=0;d<o;d++)t[h*e+d]*=N}for(M=0,d=0;d<o;d++)w=t[h*e+d],M+=w*w;M=Math.sqrt(M)}for(_=1/M,d=0;d<o;d++)t[h*e+d]*=_}}function co(t,e,i,n){var r=0,o=0,a=t.rows,s=t.cols,c=a,u=s;c<u&&(r=1,o=c,c=u,u=o);var h=new Zr(c,c),l=new Zr(1,u),d=new Zr(u,u);if(0===r)Kr(h,t);else{for(o=0;o<s*a;o++)h.data[o]=t.data[o];for(;o<u*c;o++)h.data[o]=0}if(so(h.data,c,l.data,d.data,u,c,u,c),e){for(o=0;o<u;o++)e.data[o]=l.data[o];for(;o<s;o++)e.data[o]=0}0===r?(i&&Kr(i,h),n&&Kr(n,d)):(i&&Kr(i,d),n&&Kr(n,h))}function uo(t){var e=t.rows,i=new Zr(e,3),n=new Zr(3,3),r=new Zr(1,3),o=new Zr(3,3),a=new Zr(3,3),s=io(t);no(t,s),Kr(i,t),Qr(n,i,i),co(n,r,o,a);var c=new N(s[0],s[1],s[2]),u=new N(o.data[0],o.data[3],o.data[6]),h=new N(o.data[1],o.data[4],o.data[7]),l=new N(o.data[2],o.data[5],o.data[8]);u.multiplyScalar(Math.sqrt(r.data[0]/(e/3))),h.multiplyScalar(Math.sqrt(r.data[1]/(e/3))),l.multiplyScalar(Math.sqrt(r.data[2]/(e/3)));var d=(new N).copy(c).sub(u),f=(new N).copy(c).add(u),p=(new N).copy(c).sub(h),m=(new N).copy(c).add(h),g=(new N).copy(c).sub(l),v=(new N).copy(c).add(l);return[[d,f],[p,m],[g,v],c]}function ho(){return new Float32Array([1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1])}function lo(t,e,i,n,r,o,a,s,c,u,h,l,d,f,p,m,g){t[0]=e,t[4]=i,t[8]=n,t[12]=r,t[1]=o,t[5]=a,t[9]=s,t[13]=c,t[2]=u,t[6]=h,t[10]=l,t[14]=d,t[3]=f,t[7]=p,t[11]=m,t[15]=g}function fo(t,e,i){var n=e[0],r=e[4],o=e[8],a=e[12],s=e[1],c=e[5],u=e[9],h=e[13],l=e[2],d=e[6],f=e[10],p=e[14],m=e[3],g=e[7],v=e[11],y=e[15],b=i[0],x=i[4],_=i[8],w=i[12],S=i[1],A=i[5],M=i[9],C=i[13],P=i[2],T=i[6],E=i[10],I=i[14],L=i[3],R=i[7],O=i[11],D=i[15];t[0]=n*b+r*S+o*P+a*L,t[4]=n*x+r*A+o*T+a*R,t[8]=n*_+r*M+o*E+a*O,t[12]=n*w+r*C+o*I+a*D,t[1]=s*b+c*S+u*P+h*L,t[5]=s*x+c*A+u*T+h*R,t[9]=s*_+c*M+u*E+h*O,t[13]=s*w+c*C+u*I+h*D,t[2]=l*b+d*S+f*P+p*L,t[6]=l*x+d*A+f*T+p*R,t[10]=l*_+d*M+f*E+p*O,t[14]=l*w+d*C+f*I+p*D,t[3]=m*b+g*S+v*P+y*L,t[7]=m*x+g*A+v*T+y*R,t[11]=m*_+g*M+v*E+y*O,t[15]=m*w+g*C+v*I+y*D}function po(t,e,i,n){lo(t,e,0,0,0,0,i,0,0,0,0,n,0,0,0,0,1)}function mo(t,e,i,n){lo(t,1,0,0,e,0,1,0,i,0,0,1,n,0,0,0,1)}function go(t,e){var i=Math.cos(e),n=Math.sin(e);lo(t,i,0,n,0,0,1,0,0,-n,0,i,0,0,0,0,1)}function vo(){return new Float32Array([1,0,0,0,1,0,0,0,1])}function yo(t,e){var i=Fr([e[0],e[1],e[2]]),n=Fr([e[4],e[5],e[6]]),r=Fr([e[8],e[9],e[10]]),o=Fr();zr(o,n,r),t[0]=o[0],t[1]=o[1],t[2]=o[2],zr(o,r,i),t[3]=o[0],t[4]=o[1],t[5]=o[2],zr(o,i,n),t[6]=o[0],t[7]=o[1],t[8]=o[2]}function bo(t,e){function i(t,e,i,n){for(var r=n*n,a=Math.max(0,t-n-s>>o),f=Math.max(0,e-n-c>>o),p=Math.max(0,i-n-u>>o),y=Math.min(h,t+n-s>>o),x=Math.min(l,e+n-c>>o),_=Math.min(d,i+n-u>>o),w=[],S=a;S<=y;++S)for(var A=f;A<=x;++A)for(var C=p;C<=_;++C){var T=(S*l+A)*d+C,I=b[T];if(I>0)for(var L=I-1,R=P[L],O=M[L],D=R+O,N=R;N<D;++N){var k=E[N],F=m[k]-t,z=g[k]-e,B=v[k]-i;F*F+z*z+B*B<=r&&w.push(k)}}return w}var n,r,o=3,a=e,s=a.min.x,c=a.min.y,u=a.min.z,h=(a.max.x-s>>o)+1,l=(a.max.y-c>>o)+1,d=(a.max.z-u>>o)+1,f=h*l*d,p=t.count,m=t.x,g=t.y,v=t.z,y=0,b=new Uint32Array(f),x=new Int32Array(p);for(n=0;n<p;++n){var _=m[n]-s>>o,w=g[n]-c>>o,S=v[n]-u>>o,A=(_*l+w)*d+S;1===(b[A]+=1)&&(y+=1),x[n]=A}var M=new Uint16Array(y);for(n=0,r=0;n<f;++n){var C=b[n];C>0&&(b[n]=r+1,M[r]=C,r+=1)}var P=new Uint32Array(y);for(n=1;n<y;++n)P[n]+=P[n-1]+M[n-1];var T=new Uint16Array(y),E=new Int32Array(p);for(n=0;n<p;++n){var I=b[x[n]];if(I>0){var L=I-1;E[P[L]+T[L]]=n,T[L]+=1}}this.within=i}function xo(e,i){t.Debug&&uv.time("BondHash init");var n,r=e.count,o=e.atomIndex1,a=e.atomIndex2,s=new Uint8Array(i),c=new Int32Array(i);for(n=0;n<r;++n)s[o[n]]+=1,s[a[n]]+=1;for(n=1;n<i;++n)c[n]+=c[n-1]+s[n-1];for(var u=2*r,h=new Int32Array(u),l=0;l<u;++l)h[l]=-1;for(n=0;n<r;++n){for(var d=o[n],f=a[n],p=c[d];h[p]!==-1;)p+=1;h[p]=n;for(var m=c[f];h[m]!==-1;)m+=1;h[m]=n}t.Debug&&uv.timeEnd("BondHash init"),this.countArray=s,this.offsetArray=c,this.indexArray=h}function _o(t){void 0===t?this.init(0):Number.isInteger(t)?this.init(t):this.fromJSON(t)}function wo(t){_o.call(this,t)}function So(t){_o.call(this,t)}function Ao(t){_o.call(this,t)}function Mo(t){_o.call(this,t)}function Co(t){_o.call(this,t)}function Po(t){this.polymer=t,this.size=t.residueCount}function To(t){this.polymer=t,this.helixorient=new Po(t),this.position=this.helixorient.getPosition()}function Eo(t){this.content=[],this.scoreFunction=t}function Io(t,e){function i(e,n,r,o){e>s&&(s=e);var a=o-r;if(0===a)return-1;var u=4*l;if(l+=1,1===a)return h[u]=r,h[u+1]=-1,h[u+2]=-1,h[u+3]=n,u;var f=r+Math.floor(a/2);d=e%3;for(var p,m,g,v,y,b=r,x=o-1;x>b;){for(g=b+x>>1,v=t[3*c[g]+d],m=c[g],c[g]=c[x],c[x]=m,y=b,p=b;p<x;++p)t[3*c[p]+d]<v&&(m=c[y],c[y]=c[p],c[p]=m,++y);if(m=c[x],c[x]=c[y],c[y]=m,g=y,f===g)break;f<g?x=g-1:b=g+1}return h[u]=f,h[u+1]=i(e+1,u,r,f),h[u+2]=i(e+1,u,f+1,o),h[u+3]=n,u}function n(t){var e=h[t+3];return e===-1?0:n(e)+1}function r(i,r,o){function a(u){function l(t,e){s.push([t,e]),s.size()>r&&s.pop()}var d,f,p=n(u)%3,m=3*c[h[u]],g=[t[m+0],t[m+1],t[m+2]],v=e(i,g),y=h[u+1],b=h[u+2];if(b===-1&&y===-1)return void((s.size()<r||v<s.peek()[1])&&v<=o&&l(u,v));d=b===-1?y:y===-1?b:i[p]<=t[m+p]?y:b,a(d),(s.size()<r||v<s.peek()[1])&&v<=o&&l(u,v);for(var x=[],_=0;_<3;_+=1)_===p?x[_]=i[_]:x[_]=t[m+_];var w=e(x,g);(s.size()<r||Math.abs(w)<s.peek()[1])&&Math.abs(w)<=o&&(f=d===y?b:y,f!==-1&&a(f))}var s=new Eo(function(t){return-t[1]});a(f);for(var u=[],l=0,d=Math.min(s.size(),r);l<d;l+=1)u.push(s.content[l]);return u}function o(e,i){var n=1;if(void 0===e&&(e=f,i=0),e===-1)throw"node is null";var r=i%3,a=h[e+1],s=h[e+2];if(a!==-1){if(t[3*c[h[a]]+r]>t[3*c[h[e]]+r])throw"left child is > parent!";n+=o(a,i+1)}if(s!==-1){if(t[3*c[h[s]]+r]<t[3*c[h[e]]+r])throw"right child is < parent!";n+=o(s,i+1)}return n}for(var a=t.length/3,s=0,c=new Uint32Array(a),u=0;u<a;++u)c[u]=u;var h=new Int32Array(4*a),l=0,d=0,f=i(0,-1,0,a);this.rootIndex=f,this.maxDepth=s,this.nearest=r,this.indices=c,this.nodes=h,this.verify=o}function Lo(e,i){t.Debug&&uv.time("Kdtree build");var n;n=i?function(t,e){var i=t[0]-e[0],n=t[1]-e[1],r=t[2]-e[2];return i*i+n*n+r*r}:function(t,e){var i=t[0]-e[0],n=t[1]-e[1],r=t[2]-e[2];return Math.sqrt(i*i+n*n+r*r)};var r=new Float32Array(3*e.atomCount),o=new Uint32Array(e.atomCount),a=0;e.eachAtom(function(t){r[a+0]=t.x,r[a+1]=t.y,r[a+2]=t.z,o[a/3]=t.index,a+=3}),this.atomIndices=o,this.points=r,this.kdtree=new Io(r,n),t.Debug&&uv.timeEnd("Kdtree build")}function Ro(t){var e=Fv[t],i={};if(void 0===e)return console.warn("getSymmetryOperations: spacegroup '"+t+"' not found in symop library"),i;for(var n=[],r=0,o=e.length;r<o;r+=3){for(var a=[],s=0;s<3;++s)a.push(kv[e[r+s]]);n.push(a)}var c=/^[1-9]$/;return n.forEach(function(t){var e=0,n=(new O).set(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1),r=n.elements;i[t]=n,t.forEach(function(t){for(var i=!1,n=!1,o=0,a=t.length;o<a;++o){var s=t[o];if("-"===s)i=!0;else if("+"===s)i=!1;else if("/"===s)n=!0;else if("X"===s)r[0+e]=i?-1:1;else if("Y"===s)r[4+e]=i?-1:1;else if("Z"===s)r[8+e]=i?-1:1;else if(c.test(s)){var u=parseInt(s);n?r[12+e]/=u:r[12+e]=u}else uv.warn("getSymmetryOperations: unknown token '"+s+"'")}e+=1})}),i}function Oo(t){var e="";return t.length>0&&(e=":"+x(t).join(" OR :")),new _n(e)}function Do(t){this.name=t||"",this.partList=[]}function No(t,e){this.matrixList=t||[],this.chainList=e||[]}function ko(e,i){if(i){t.Debug&&uv.time("assignSecondaryStructure");var n=[];e.eachModel(function(t){t.eachChain(function(t){n.push(t.chainname)})});var r=n.slice().sort(),o=[];r.forEach(function(t){o.push(n.indexOf(t))});var a=i.helices;a=a.filter(function(t){return th(r,t[0])>=0}),a.sort(function(t,e){var i=t[0],n=e[0],a=t[1],s=e[1];if(i===n)return a===s?0:a<s?-1:1;var c=th(r,i),u=th(r,n);return o[c]<o[u]?-1:1});var s=e.residueStore;e.eachModel(function(t){var e=0,i=a.length;if(0!==i){var n=a[e],r=!1,o=!1;t.eachChain(function(t){var c=!1;if(t.chainname===n[0])for(var u=t.residueCount,h=t.residueOffset,l=h+u,d=h;d<l;++d)if(s.resno[d]===n[1]&&s.getInscode(d)===n[2]&&(r=!0),r&&(s.sstruc[d]=n[6],s.resno[d]===n[4]&&s.getInscode(d)===n[5]&&(r=!1,e+=1,e<i?(d=h-1,n=a[e],c=t.chainname!==n[0]):o=!0)),c||o)return})}});var c=i.sheets;c=c.filter(function(t){return th(r,t[0])>=0}),c.sort(function(t,e){var i=t[0],n=e[0];if(i===n)return 0;var a=th(r,i),s=th(r,n);return o[a]<o[s]?-1:1});var u="e".charCodeAt(0);e.eachModel(function(t){var e=0,i=c.length;if(0!==i){var n=c[e],r=!1,o=!1;t.eachChain(function(t){var a=!1;if(t.chainname===n[0])for(var h=t.residueCount,l=t.residueOffset,d=l+h,f=l;f<d;++f)if(s.resno[f]===n[1]&&s.getInscode(f)===n[2]&&(r=!0),r&&(s.sstruc[f]=u,s.resno[f]===n[4]&&s.getInscode(f)===n[5]&&(r=!1,e+=1,e<i?(f=l-1,n=c[e],a=t.chainname!==n[0]):o=!0)),a||o)return})}}),t.Debug&&uv.timeEnd("assignSecondaryStructure")}}function Fo(e){t.Debug&&uv.time("calculateChainnames");var i=!0;if(e.eachChain(function(t){t.chainname&&(i=!1)}),i){var n="ABCDEFGHIJKLMNOPQRSTUVWXYZ",r=n.length,o=e.modelStore,a=e.chainStore,s=e.residueStore,c=function(t,e,i,n){for(var r=a.count,c=0;c<n;++c)s.chainIndex[i+c]=r;a.growIfFull(),a.modelIndex[r]=t,a.setChainname(r,e),a.setChainid(r,e),a.residueOffset[r]=i,a.residueCount[r]=n,a.count+=1,o.chainCount[t]+=1},u=function(t){for(var e=t,i=0,o=n[e%r];e>=r;)e=Math.floor(e/r),o+=n[e%r],i+=1;return i>=5&&uv.warn("chainname overflow"),o},h=e.getAtomProxy(),l=e.getAtomProxy(),d=0,f=0,p=0,m=0,g=[];1===s.count?g.push({mIndex:0,chainname:"A",rStart:0,rCount:1}):e.eachResidueN(2,function(t,e){var i=!1,n=t.backboneType,r=e.backboneType,o=Zp;m=t.index,t.modelIndex!==e.modelIndex?i=!0:t.moleculeType!==e.moleculeType?i=!0:n!==o&&n===r&&(h.index=t.backboneEndAtomIndex,l.index=e.backboneStartAtomIndex,h.connectedTo(l)||(i=!0)),i||e.index!==s.count-1||(i=!0,m=e.index),i&&(g.push({mIndex:f,chainname:u(d),rStart:p,rCount:m-p+1}),d+=1,t.modelIndex!==e.modelIndex&&(d=0,f+=1),e.index===s.count-1&&m!==e.index&&g.push({mIndex:f,chainname:u(d),rStart:s.count-1,rCount:1}),p=e.index,m=e.index)}),a.count=0,g.forEach(function(t){c(t.mIndex,t.chainname,t.rStart,t.rCount)});var v=0;e.eachModel(function(t){o.chainOffset[t.index]=v,o.chainCount[t.index]-=1,v+=o.chainCount[t.index]})}t.Debug&&uv.timeEnd("calculateChainnames")}function zo(e){t.Debug&&uv.time("calculateBonds"),jo(e),$o(e),t.Debug&&uv.timeEnd("calculateBonds")}function Bo(e){var i=e.structure,n=i.getAtomProxy(),r=i.getAtomProxy(),o=e.atomCount,a=e.atomOffset,s=a+o,c=s-1;if(o>500)return void(t.Debug&&uv.warn("more than 500 atoms, skip residue for auto-bonding",e.qualifiedName()));var u,h,l=[],d=[],f=[];if(o>50){var p=new Lo(e,!0),m=e.isCg()?1.2:2.3;for(u=a;u<c;++u){n.index=u;var g=n.covalent+m+.3,v=p.nearest(n,1/0,g*g),y=v.length;for(h=0;h<y;++h)r.index=v[h].index,n.index<r.index&&n.connectedTo(r)&&(l.push(n.index-a),d.push(r.index-a),f.push(1))}}else for(u=a;u<c;++u)for(n.index=u,h=u+1;h<=c;++h)r.index=h,n.connectedTo(r)&&(l.push(u-a),d.push(h-a),f.push(1));return{atomIndices1:l,atomIndices2:d,bondOrders:f}}function Uo(e){t.Debug&&uv.time("calculateAtomBondMap");var i=[];return e.eachBond(function(t){var e=t.atomIndex1,n=t.atomIndex2;void 0===i[e]&&(i[e]=[]),i[e][n]=t.index}),t.Debug&&uv.timeEnd("calculateAtomBondMap"),i}function jo(e,i){t.Debug&&uv.time("calculateBondsWithin");var n=e.bondStore,r=e.rungBondStore,o=e.getAtomSet(!1),a=e.getAtomProxy(),s=e.getAtomProxy(),c=e.getBondProxy(),u=Uo(e);e.eachResidue(function(t){if(!i){var e=t.atomCount,h=t.atomOffset;if(e>500)return void uv.warn("more than 500 atoms, skip residue for auto-bonding",t.qualifiedName());for(var l=t.getBonds(),d=l.atomIndices1,f=l.atomIndices2,p=l.bondOrders,m=d.length,g=0;g<m;++g){var v=d[g]+h,y=f[g]+h,b=u[v];if(void 0!==b&&void 0!==(b=b[y])){c.index=b;var x=t.residueType.getBondIndex(v,y);p[x]=c.bondOrder}else a.index=v,s.index=y,n.addBond(a,s,p[g])}}var _=t.residueType.traceAtomIndex,w=t.residueType.rungEndAtomIndex;_!==-1&&w!==-1&&(a.index=t.traceAtomIndex,s.index=t.rungEndAtomIndex,r.addBond(a,s),o.add_unsafe(a.index),o.add_unsafe(s.index))}),e.atomSetDict.rung=o,t.Debug&&uv.timeEnd("calculateBondsWithin")}function $o(e,i){function n(t,e){var n=t.backboneType,u=e.backboneType;n!==Zp&&n===u&&(s.index=t.backboneEndAtomIndex,c.index=e.backboneStartAtomIndex,s.connectedTo(c)&&(i||r.addBond(s,c,1),s.index=t.traceAtomIndex,c.index=e.traceAtomIndex,o.addBond(s,c),a.add_unsafe(s.index),a.add_unsafe(c.index)))}t.Debug&&uv.time("calculateBondsBetween");var r=e.bondStore,o=e.backboneBondStore,a=e.getAtomSet(!1),s=e.getAtomProxy(),c=e.getAtomProxy();0===o.count&&o.resize(e.residueStore.count),e.eachResidueN(2,n);var u=e.getResidueProxy(),h=e.getResidueProxy();e.eachChain(function(t){0!==t.residueCount&&(u.index=t.residueOffset,h.index=t.residueOffset+t.residueCount-1,n(h,u))}),e.atomSetDict.backbone=a,t.Debug&&uv.timeEnd("calculateBondsBetween")}function Vo(e){function i(t){var e=[];return Object.keys(o).forEach(function(i){var u=o[i].clone();s.copy(r).applyMatrix4(u),c.setFromMatrixPosition(u),c.sub(a),s.x>1&&(c.x-=1),s.x<0&&(c.x+=1),s.y>1&&(c.y-=1),s.y<0&&(c.y+=1),s.z>1&&(c.z-=1),s.z<0&&(c.z+=1),t&&c.add(t),u.setPosition(c),u.multiplyMatrices(n.fracToCart,u),u.multiply(n.cartToFrac),e.push(u)}),e}if(e.unitcell){t.Debug&&uv.time("buildUnitcellAssembly");var n=e.unitcell,r=e.center.clone().applyMatrix4(n.cartToFrac),o=Ro(n.spacegroup),a=new N,s=new N,c=new N;r.x>1&&(a.x-=1),r.x<0&&(a.x+=1),r.y>1&&(a.y-=1),r.y<0&&(a.y+=1),r.z>1&&(a.z-=1),r.z<0&&(a.z+=1);var u,h=new Do("UNITCELL"),l=i();if(e.biomolDict.NCS){u=[new O].concat(e.biomolDict.NCS.partList[0].matrixList);var d=[];l.forEach(function(t){u.forEach(function(e){d.push(t.clone().multiply(e))})}),h.addPart(d)}else h.addPart(l);var f=new N,p=new Do("SUPERCELL"),m=Array.prototype.concat.call(i(),i(f.set(1,1,1)),i(f.set(-1,-1,-1)),i(f.set(1,0,0)),i(f.set(1,1,0)),i(f.set(1,0,1)),i(f.set(0,1,0)),i(f.set(0,1,1)),i(f.set(0,0,1)),i(f.set(-1,0,0)),i(f.set(-1,-1,0)),i(f.set(-1,0,-1)),i(f.set(0,-1,0)),i(f.set(0,-1,-1)),i(f.set(0,0,-1)),i(f.set(1,-1,-1)),i(f.set(1,1,-1)),i(f.set(1,-1,1)),i(f.set(-1,1,1)),i(f.set(-1,-1,1)),i(f.set(-1,1,-1)),i(f.set(0,1,-1)),i(f.set(0,-1,1)),i(f.set(1,0,-1)),i(f.set(-1,0,1)),i(f.set(1,-1,0)),i(f.set(-1,1,0)));if(e.biomolDict.NCS){var g=[];m.forEach(function(t){u.forEach(function(e){g.push(t.clone().multiply(e))})}),p.addPart(g)}else p.addPart(m);e.biomolDict.UNITCELL=h,e.biomolDict.SUPERCELL=p,t.Debug&&uv.timeEnd("buildUnitcellAssembly")}}function Go(t){var e=t.bondHash,i=e.countArray,n=e.offsetArray,r=e.indexArray,o=t.getBondProxy();t.eachResidue(function(t){var e=t.residueType;if(void 0===e.bonds){var a=t.atomOffset,s=[],c=[],u=[],h={};t.eachAtom(function(t){for(var e=t.index,l=n[e],d=i[e],f=0,p=d;f<p;++f){o.index=r[l+f];var m=o.atomIndex1,g=o.atomIndex2;if(m>g){var v=g;g=m,m=v}var y=m+"|"+g;void 0===h[y]&&(h[y]=!0,s.push(m-a),c.push(g-a),u.push(o.bondOrder))}}),e.bonds={atomIndices1:s,atomIndices2:c,bondOrders:u}}})}function Ho(t,e,i){this.structure=t,i=i||Bv(e),this.atomname=e,this.element=i,this.vdw=hm[i],this.covalent=dm[i]}function Wo(t){function e(t,e){return t+"|"+e}function i(i,n){n=n||Bv(i);var a=e(i,n),s=r[a];if(void 0===s){var c=new Ho(t,i,n);s=o.length,r[a]=s,o.push(c)}return s}function n(t){return o[t]}var r={},o=[];this.add=i,this.get=n,this.list=o,this.dict=r,this.toJSON=function(){var t={metadata:{version:.1,type:"AtomMap",generator:"AtomMapExporter"},idDict:r,typeList:o.map(function(t){return t.toJSON()})};return t},this.fromJSON=function(e){r=e.idDict,o=e.typeList.map(function(e){return new Ho(t,e.atomname,e.element)}),this.list=o,this.dict=r}}function Xo(t,e,i,n,r,o){this.structure=t,this.resname=e,this.atomTypeIdList=i,this.hetero=n?1:0,this.chemCompType=r,this.bonds=o,this.rings=void 0,this.atomCount=i.length,this.moleculeType=this.getMoleculeType(),this.backboneType=this.getBackboneType(0),this.backboneEndType=this.getBackboneType(-1),this.backboneStartType=this.getBackboneType(1),this.backboneIndexList=this.getBackboneIndexList();var a=Cm[this.backboneType],s=Cm[this.backboneStartType],c=Cm[this.backboneEndType],u=this.getAtomIndexByName(a.trace);this.traceAtomIndex=void 0!==u?u:-1;var h=this.getAtomIndexByName(a.direction1);this.direction1AtomIndex=void 0!==h?h:-1;var l=this.getAtomIndexByName(a.direction2);this.direction2AtomIndex=void 0!==l?l:-1;var d=this.getAtomIndexByName(s.backboneStart);this.backboneStartAtomIndex=void 0!==d?d:-1;var f=this.getAtomIndexByName(c.backboneEnd);this.backboneEndAtomIndex=void 0!==f?f:-1;var p;p=xm.includes(e)?this.getAtomIndexByName("N1"):this.getAtomIndexByName("N3"),this.rungEndAtomIndex=void 0!==p?p:-1,this.bondReferenceAtomIndices=[]}function qo(t){function e(t,e,i,n){return t+"|"+e.join(",")+"|"+(i?1:0)+"|"+(n?n:"")}function i(i,n,a,s,c){i=i.toUpperCase();var u=e(i,n,a,s),h=r[u];if(void 0===h){var l=new Xo(t,i,n,a,s,c);h=o.length,r[u]=h,o.push(l)}return h}function n(t){return o[t]}var r={},o=[];this.add=i,this.get=n,this.list=o,this.dict=r}function Yo(t,e){this.structure=t,this.bondStore=t.bondStore,this.index=e,this._v12=new N,this._v13=new N,this._ap1=this.structure.getAtomProxy(),this._ap2=this.structure.getAtomProxy(),this._ap3=this.structure.getAtomProxy()}function Zo(t,e){this.structure=t,this.chainStore=t.chainStore,this.residueStore=t.residueStore,this.atomStore=t.atomStore,this.residueMap=t.residueMap,this.atomMap=t.atomMap,this.bondHash=t.bondHash,this.index=e}function Ko(t,e){this.structure=t,this.chainStore=t.chainStore,this.residueStore=t.residueStore,this.atomStore=t.atomStore,this.residueMap=t.residueMap,this.atomMap=t.atomMap,this.index=e}function Qo(t,e,i){this.structure=t,this.chainStore=t.chainStore,this.residueStore=t.residueStore,this.atomStore=t.atomStore,this.residueIndexStart=e,this.residueIndexEnd=i,this.residueCount=i-e+1;var n=this.structure.getResidueProxy(this.residueIndexStart),r=this.structure.getResidueProxy(this.residueIndexEnd);this.isPrevConnected=void 0!==n.getPreviousConnectedResidue();var o=r.getNextConnectedResidue();this.isNextConnected=void 0!==o,this.isNextNextConnected=this.isNextConnected&&void 0!==o.getNextConnectedResidue(),this.isCyclic=r.connectedTo(n),this.__residueProxy=this.structure.getResidueProxy()}function Jo(t,e){this.structure=t,this.chainStore=t.chainStore,this.residueStore=t.residueStore,this.index=e}function ta(t,e){this.structure=t,this.modelStore=t.modelStore,this.chainStore=t.chainStore,this.residueStore=t.residueStore,this.index=e}function ea(t,e){this.signals={refreshed:new xn},this.name=t,this.path=e,this.title="",this.id="",this.header={},this.atomSetCache=void 0,this.atomSetDict={},this.biomolDict={},this.entityList=[],this.unitcell=void 0,this.frames=[],this.boxes=[],this.bondStore=new wo(0),this.backboneBondStore=new wo(0),this.rungBondStore=new wo(0),this.atomStore=new So(0),this.residueStore=new Ao(0),this.chainStore=new Mo(0),this.modelStore=new Co(0),this.atomMap=new Wo(this),this.residueMap=new qo(this),this.bondHash=void 0,this.spatialHash=void 0,this.atomSet=void 0,this.bondSet=void 0,this.center=void 0,this.boundingBox=void 0,this._bp=this.getBondProxy(),this._ap=this.getAtomProxy(),this._rp=this.getResidueProxy(),this._cp=this.getChainProxy()}function ia(t,e,i){this.name=t,this.path=e,this.info={},this.center=new N,this.boundingBox=new Et,i instanceof ae||i instanceof ue||i instanceof He?this.fromGeometry(i):i&&this.set(i.position,i.index,i.normal,i.color,i.atomindex)}function na(e){var i=0,n=0,r={},o={},a=URL.createObjectURL(lv.get(e)),s=new window.Worker(a);lv.activeWorkerCount+=1,s.onmessage=function(n){i-=1;var a=n.data.__postId;t.Debug&&uv.timeEnd("Worker.postMessage "+e+" #"+a),r[a]&&r[a].call(s,n),delete r[a],delete o[a]},s.onerror=function(t){if(i-=1,t.data){var n=t.data.__postId;o[n]?o[n].call(s,t):uv.error("Worker.onerror",n,e,t),delete r[n],delete o[n]}else uv.error("Worker.onerror",e,t)},this.name=e,this.post=function(a,c,u,h){r[n]=u,o[n]=h,a=a||{},a.__name=e,a.__postId=n,a.__debug=t.Debug,t.Debug&&uv.time("Worker.postMessage "+e+" #"+n);try{s.postMessage(a,c)}catch(t){uv.error("worker.post:",t),s.postMessage(a)}return i+=1,n+=1,this},this.terminate=function(){s?(s.terminate(),URL.revokeObjectURL(a),lv.activeWorkerCount-=1):uv.log("no worker to terminate")},Object.defineProperties(this,{postCount:{get:function(){return n}},pending:{get:function(){return i}}})}function ra(t,e){e=Math.min(8,e||2);var i=[],n=0;this.name=t,this.maxCount=e,this.post=function(t,e,i,n){var r=this.getNextWorker();return r.post(t,e,i,n),this},this.terminate=function(){i.forEach(function(t){t.terminate()})},this.getNextWorker=function(){for(var r,o=1/0,a=0;a<e;++a){if(a>=n){r=new na(t),i.push(r),n+=1;break}var s=i[a];if(0===s.pending){o=s.pending,r=s;break}s.pending<o&&(o=s.pending,r=s)}return r},Object.defineProperties(this,{count:{get:function(){return n}}})}function oa(){return new Uint32Array([0,265,515,778,1030,1295,1541,1804,2060,2309,2575,2822,3082,3331,3593,3840,400,153,915,666,1430,1183,1941,1692,2460,2197,2975,2710,3482,3219,3993,3728,560,825,51,314,1590,1855,1077,1340,2620,2869,2111,2358,3642,3891,3129,3376,928,681,419,170,1958,1711,1445,1196,2988,2725,2479,2214,4010,3747,3497,3232,1120,1385,1635,1898,102,367,613,876,3180,3429,3695,3942,2154,2403,2665,2912,1520,1273,2035,1786,502,255,1013,764,3580,3317,4095,3830,2554,2291,3065,2800,1616,1881,1107,1370,598,863,85,348,3676,3925,3167,3414,2650,2899,2137,2384,1984,1737,1475,1226,966,719,453,204,4044,3781,3535,3270,3018,2755,2505,2240,2240,2505,2755,3018,3270,3535,3781,4044,204,453,719,966,1226,1475,1737,1984,2384,2137,2899,2650,3414,3167,3925,3676,348,85,863,598,1370,1107,1881,1616,2800,3065,2291,2554,3830,4095,3317,3580,764,1013,255,502,1786,2035,1273,1520,2912,2665,2403,2154,3942,3695,3429,3180,876,613,367,102,1898,1635,1385,1120,3232,3497,3747,4010,2214,2479,2725,2988,1196,1445,1711,1958,170,419,681,928,3376,3129,3891,3642,2358,2111,2869,2620,1340,1077,1855,1590,314,51,825,560,3728,3993,3219,3482,2710,2975,2197,2460,1692,1941,1183,1430,666,915,153,400,3840,3593,3331,3082,2822,2575,2309,2060,1804,1541,1295,1030,778,515,265,0])}function aa(){return new Int32Array([-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,8,3,9,8,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,1,2,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,2,10,0,2,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,8,3,2,10,8,10,9,8,-1,-1,-1,-1,-1,-1,-1,3,11,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,11,2,8,11,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,9,0,2,3,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,11,2,1,9,11,9,8,11,-1,-1,-1,-1,-1,-1,-1,3,10,1,11,10,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,10,1,0,8,10,8,11,10,-1,-1,-1,-1,-1,-1,-1,3,9,0,3,11,9,11,10,9,-1,-1,-1,-1,-1,-1,-1,9,8,10,10,8,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,7,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,3,0,7,3,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,8,4,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,1,9,4,7,1,7,3,1,-1,-1,-1,-1,-1,-1,-1,1,2,10,8,4,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,4,7,3,0,4,1,2,10,-1,-1,-1,-1,-1,-1,-1,9,2,10,9,0,2,8,4,7,-1,-1,-1,-1,-1,-1,-1,2,10,9,2,9,7,2,7,3,7,9,4,-1,-1,-1,-1,8,4,7,3,11,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,4,7,11,2,4,2,0,4,-1,-1,-1,-1,-1,-1,-1,9,0,1,8,4,7,2,3,11,-1,-1,-1,-1,-1,-1,-1,4,7,11,9,4,11,9,11,2,9,2,1,-1,-1,-1,-1,3,10,1,3,11,10,7,8,4,-1,-1,-1,-1,-1,-1,-1,1,11,10,1,4,11,1,0,4,7,11,4,-1,-1,-1,-1,4,7,8,9,0,11,9,11,10,11,0,3,-1,-1,-1,-1,4,7,11,4,11,9,9,11,10,-1,-1,-1,-1,-1,-1,-1,9,5,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,5,4,0,8,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,5,4,1,5,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,5,4,8,3,5,3,1,5,-1,-1,-1,-1,-1,-1,-1,1,2,10,9,5,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,8,1,2,10,4,9,5,-1,-1,-1,-1,-1,-1,-1,5,2,10,5,4,2,4,0,2,-1,-1,-1,-1,-1,-1,-1,2,10,5,3,2,5,3,5,4,3,4,8,-1,-1,-1,-1,9,5,4,2,3,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,11,2,0,8,11,4,9,5,-1,-1,-1,-1,-1,-1,-1,0,5,4,0,1,5,2,3,11,-1,-1,-1,-1,-1,-1,-1,2,1,5,2,5,8,2,8,11,4,8,5,-1,-1,-1,-1,10,3,11,10,1,3,9,5,4,-1,-1,-1,-1,-1,-1,-1,4,9,5,0,8,1,8,10,1,8,11,10,-1,-1,-1,-1,5,4,0,5,0,11,5,11,10,11,0,3,-1,-1,-1,-1,5,4,8,5,8,10,10,8,11,-1,-1,-1,-1,-1,-1,-1,9,7,8,5,7,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,3,0,9,5,3,5,7,3,-1,-1,-1,-1,-1,-1,-1,0,7,8,0,1,7,1,5,7,-1,-1,-1,-1,-1,-1,-1,1,5,3,3,5,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,7,8,9,5,7,10,1,2,-1,-1,-1,-1,-1,-1,-1,10,1,2,9,5,0,5,3,0,5,7,3,-1,-1,-1,-1,8,0,2,8,2,5,8,5,7,10,5,2,-1,-1,-1,-1,2,10,5,2,5,3,3,5,7,-1,-1,-1,-1,-1,-1,-1,7,9,5,7,8,9,3,11,2,-1,-1,-1,-1,-1,-1,-1,9,5,7,9,7,2,9,2,0,2,7,11,-1,-1,-1,-1,2,3,11,0,1,8,1,7,8,1,5,7,-1,-1,-1,-1,11,2,1,11,1,7,7,1,5,-1,-1,-1,-1,-1,-1,-1,9,5,8,8,5,7,10,1,3,10,3,11,-1,-1,-1,-1,5,7,0,5,0,9,7,11,0,1,0,10,11,10,0,-1,11,10,0,11,0,3,10,5,0,8,0,7,5,7,0,-1,11,10,5,7,11,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,10,6,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,5,10,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,0,1,5,10,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,8,3,1,9,8,5,10,6,-1,-1,-1,-1,-1,-1,-1,1,6,5,2,6,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,6,5,1,2,6,3,0,8,-1,-1,-1,-1,-1,-1,-1,9,6,5,9,0,6,0,2,6,-1,-1,-1,-1,-1,-1,-1,5,9,8,5,8,2,5,2,6,3,2,8,-1,-1,-1,-1,2,3,11,10,6,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,0,8,11,2,0,10,6,5,-1,-1,-1,-1,-1,-1,-1,0,1,9,2,3,11,5,10,6,-1,-1,-1,-1,-1,-1,-1,5,10,6,1,9,2,9,11,2,9,8,11,-1,-1,-1,-1,6,3,11,6,5,3,5,1,3,-1,-1,-1,-1,-1,-1,-1,0,8,11,0,11,5,0,5,1,5,11,6,-1,-1,-1,-1,3,11,6,0,3,6,0,6,5,0,5,9,-1,-1,-1,-1,6,5,9,6,9,11,11,9,8,-1,-1,-1,-1,-1,-1,-1,5,10,6,4,7,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,3,0,4,7,3,6,5,10,-1,-1,-1,-1,-1,-1,-1,1,9,0,5,10,6,8,4,7,-1,-1,-1,-1,-1,-1,-1,10,6,5,1,9,7,1,7,3,7,9,4,-1,-1,-1,-1,6,1,2,6,5,1,4,7,8,-1,-1,-1,-1,-1,-1,-1,1,2,5,5,2,6,3,0,4,3,4,7,-1,-1,-1,-1,8,4,7,9,0,5,0,6,5,0,2,6,-1,-1,-1,-1,7,3,9,7,9,4,3,2,9,5,9,6,2,6,9,-1,3,11,2,7,8,4,10,6,5,-1,-1,-1,-1,-1,-1,-1,5,10,6,4,7,2,4,2,0,2,7,11,-1,-1,-1,-1,0,1,9,4,7,8,2,3,11,5,10,6,-1,-1,-1,-1,9,2,1,9,11,2,9,4,11,7,11,4,5,10,6,-1,8,4,7,3,11,5,3,5,1,5,11,6,-1,-1,-1,-1,5,1,11,5,11,6,1,0,11,7,11,4,0,4,11,-1,0,5,9,0,6,5,0,3,6,11,6,3,8,4,7,-1,6,5,9,6,9,11,4,7,9,7,11,9,-1,-1,-1,-1,10,4,9,6,4,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,10,6,4,9,10,0,8,3,-1,-1,-1,-1,-1,-1,-1,10,0,1,10,6,0,6,4,0,-1,-1,-1,-1,-1,-1,-1,8,3,1,8,1,6,8,6,4,6,1,10,-1,-1,-1,-1,1,4,9,1,2,4,2,6,4,-1,-1,-1,-1,-1,-1,-1,3,0,8,1,2,9,2,4,9,2,6,4,-1,-1,-1,-1,0,2,4,4,2,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,3,2,8,2,4,4,2,6,-1,-1,-1,-1,-1,-1,-1,10,4,9,10,6,4,11,2,3,-1,-1,-1,-1,-1,-1,-1,0,8,2,2,8,11,4,9,10,4,10,6,-1,-1,-1,-1,3,11,2,0,1,6,0,6,4,6,1,10,-1,-1,-1,-1,6,4,1,6,1,10,4,8,1,2,1,11,8,11,1,-1,9,6,4,9,3,6,9,1,3,11,6,3,-1,-1,-1,-1,8,11,1,8,1,0,11,6,1,9,1,4,6,4,1,-1,3,11,6,3,6,0,0,6,4,-1,-1,-1,-1,-1,-1,-1,6,4,8,11,6,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,10,6,7,8,10,8,9,10,-1,-1,-1,-1,-1,-1,-1,0,7,3,0,10,7,0,9,10,6,7,10,-1,-1,-1,-1,10,6,7,1,10,7,1,7,8,1,8,0,-1,-1,-1,-1,10,6,7,10,7,1,1,7,3,-1,-1,-1,-1,-1,-1,-1,1,2,6,1,6,8,1,8,9,8,6,7,-1,-1,-1,-1,2,6,9,2,9,1,6,7,9,0,9,3,7,3,9,-1,7,8,0,7,0,6,6,0,2,-1,-1,-1,-1,-1,-1,-1,7,3,2,6,7,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,11,10,6,8,10,8,9,8,6,7,-1,-1,-1,-1,2,0,7,2,7,11,0,9,7,6,7,10,9,10,7,-1,1,8,0,1,7,8,1,10,7,6,7,10,2,3,11,-1,11,2,1,11,1,7,10,6,1,6,7,1,-1,-1,-1,-1,8,9,6,8,6,7,9,1,6,11,6,3,1,3,6,-1,0,9,1,11,6,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,8,0,7,0,6,3,11,0,11,6,0,-1,-1,-1,-1,7,11,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,6,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,8,11,7,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,11,7,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,1,9,8,3,1,11,7,6,-1,-1,-1,-1,-1,-1,-1,10,1,2,6,11,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,10,3,0,8,6,11,7,-1,-1,-1,-1,-1,-1,-1,2,9,0,2,10,9,6,11,7,-1,-1,-1,-1,-1,-1,-1,6,11,7,2,10,3,10,8,3,10,9,8,-1,-1,-1,-1,7,2,3,6,2,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,0,8,7,6,0,6,2,0,-1,-1,-1,-1,-1,-1,-1,2,7,6,2,3,7,0,1,9,-1,-1,-1,-1,-1,-1,-1,1,6,2,1,8,6,1,9,8,8,7,6,-1,-1,-1,-1,10,7,6,10,1,7,1,3,7,-1,-1,-1,-1,-1,-1,-1,10,7,6,1,7,10,1,8,7,1,0,8,-1,-1,-1,-1,0,3,7,0,7,10,0,10,9,6,10,7,-1,-1,-1,-1,7,6,10,7,10,8,8,10,9,-1,-1,-1,-1,-1,-1,-1,6,8,4,11,8,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,6,11,3,0,6,0,4,6,-1,-1,-1,-1,-1,-1,-1,8,6,11,8,4,6,9,0,1,-1,-1,-1,-1,-1,-1,-1,9,4,6,9,6,3,9,3,1,11,3,6,-1,-1,-1,-1,6,8,4,6,11,8,2,10,1,-1,-1,-1,-1,-1,-1,-1,1,2,10,3,0,11,0,6,11,0,4,6,-1,-1,-1,-1,4,11,8,4,6,11,0,2,9,2,10,9,-1,-1,-1,-1,10,9,3,10,3,2,9,4,3,11,3,6,4,6,3,-1,8,2,3,8,4,2,4,6,2,-1,-1,-1,-1,-1,-1,-1,0,4,2,4,6,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,9,0,2,3,4,2,4,6,4,3,8,-1,-1,-1,-1,1,9,4,1,4,2,2,4,6,-1,-1,-1,-1,-1,-1,-1,8,1,3,8,6,1,8,4,6,6,10,1,-1,-1,-1,-1,10,1,0,10,0,6,6,0,4,-1,-1,-1,-1,-1,-1,-1,4,6,3,4,3,8,6,10,3,0,3,9,10,9,3,-1,10,9,4,6,10,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,9,5,7,6,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,4,9,5,11,7,6,-1,-1,-1,-1,-1,-1,-1,5,0,1,5,4,0,7,6,11,-1,-1,-1,-1,-1,-1,-1,11,7,6,8,3,4,3,5,4,3,1,5,-1,-1,-1,-1,9,5,4,10,1,2,7,6,11,-1,-1,-1,-1,-1,-1,-1,6,11,7,1,2,10,0,8,3,4,9,5,-1,-1,-1,-1,7,6,11,5,4,10,4,2,10,4,0,2,-1,-1,-1,-1,3,4,8,3,5,4,3,2,5,10,5,2,11,7,6,-1,7,2,3,7,6,2,5,4,9,-1,-1,-1,-1,-1,-1,-1,9,5,4,0,8,6,0,6,2,6,8,7,-1,-1,-1,-1,3,6,2,3,7,6,1,5,0,5,4,0,-1,-1,-1,-1,6,2,8,6,8,7,2,1,8,4,8,5,1,5,8,-1,9,5,4,10,1,6,1,7,6,1,3,7,-1,-1,-1,-1,1,6,10,1,7,6,1,0,7,8,7,0,9,5,4,-1,4,0,10,4,10,5,0,3,10,6,10,7,3,7,10,-1,7,6,10,7,10,8,5,4,10,4,8,10,-1,-1,-1,-1,6,9,5,6,11,9,11,8,9,-1,-1,-1,-1,-1,-1,-1,3,6,11,0,6,3,0,5,6,0,9,5,-1,-1,-1,-1,0,11,8,0,5,11,0,1,5,5,6,11,-1,-1,-1,-1,6,11,3,6,3,5,5,3,1,-1,-1,-1,-1,-1,-1,-1,1,2,10,9,5,11,9,11,8,11,5,6,-1,-1,-1,-1,0,11,3,0,6,11,0,9,6,5,6,9,1,2,10,-1,11,8,5,11,5,6,8,0,5,10,5,2,0,2,5,-1,6,11,3,6,3,5,2,10,3,10,5,3,-1,-1,-1,-1,5,8,9,5,2,8,5,6,2,3,8,2,-1,-1,-1,-1,9,5,6,9,6,0,0,6,2,-1,-1,-1,-1,-1,-1,-1,1,5,8,1,8,0,5,6,8,3,8,2,6,2,8,-1,1,5,6,2,1,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,3,6,1,6,10,3,8,6,5,6,9,8,9,6,-1,10,1,0,10,0,6,9,5,0,5,6,0,-1,-1,-1,-1,0,3,8,5,6,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,10,5,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,5,10,7,5,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,5,10,11,7,5,8,3,0,-1,-1,-1,-1,-1,-1,-1,5,11,7,5,10,11,1,9,0,-1,-1,-1,-1,-1,-1,-1,10,7,5,10,11,7,9,8,1,8,3,1,-1,-1,-1,-1,11,1,2,11,7,1,7,5,1,-1,-1,-1,-1,-1,-1,-1,0,8,3,1,2,7,1,7,5,7,2,11,-1,-1,-1,-1,9,7,5,9,2,7,9,0,2,2,11,7,-1,-1,-1,-1,7,5,2,7,2,11,5,9,2,3,2,8,9,8,2,-1,2,5,10,2,3,5,3,7,5,-1,-1,-1,-1,-1,-1,-1,8,2,0,8,5,2,8,7,5,10,2,5,-1,-1,-1,-1,9,0,1,5,10,3,5,3,7,3,10,2,-1,-1,-1,-1,9,8,2,9,2,1,8,7,2,10,2,5,7,5,2,-1,1,3,5,3,7,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,7,0,7,1,1,7,5,-1,-1,-1,-1,-1,-1,-1,9,0,3,9,3,5,5,3,7,-1,-1,-1,-1,-1,-1,-1,9,8,7,5,9,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5,8,4,5,10,8,10,11,8,-1,-1,-1,-1,-1,-1,-1,5,0,4,5,11,0,5,10,11,11,3,0,-1,-1,-1,-1,0,1,9,8,4,10,8,10,11,10,4,5,-1,-1,-1,-1,10,11,4,10,4,5,11,3,4,9,4,1,3,1,4,-1,2,5,1,2,8,5,2,11,8,4,5,8,-1,-1,-1,-1,0,4,11,0,11,3,4,5,11,2,11,1,5,1,11,-1,0,2,5,0,5,9,2,11,5,4,5,8,11,8,5,-1,9,4,5,2,11,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,5,10,3,5,2,3,4,5,3,8,4,-1,-1,-1,-1,5,10,2,5,2,4,4,2,0,-1,-1,-1,-1,-1,-1,-1,3,10,2,3,5,10,3,8,5,4,5,8,0,1,9,-1,5,10,2,5,2,4,1,9,2,9,4,2,-1,-1,-1,-1,8,4,5,8,5,3,3,5,1,-1,-1,-1,-1,-1,-1,-1,0,4,5,1,0,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,4,5,8,5,3,9,0,5,0,3,5,-1,-1,-1,-1,9,4,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,11,7,4,9,11,9,10,11,-1,-1,-1,-1,-1,-1,-1,0,8,3,4,9,7,9,11,7,9,10,11,-1,-1,-1,-1,1,10,11,1,11,4,1,4,0,7,4,11,-1,-1,-1,-1,3,1,4,3,4,8,1,10,4,7,4,11,10,11,4,-1,4,11,7,9,11,4,9,2,11,9,1,2,-1,-1,-1,-1,9,7,4,9,11,7,9,1,11,2,11,1,0,8,3,-1,11,7,4,11,4,2,2,4,0,-1,-1,-1,-1,-1,-1,-1,11,7,4,11,4,2,8,3,4,3,2,4,-1,-1,-1,-1,2,9,10,2,7,9,2,3,7,7,4,9,-1,-1,-1,-1,9,10,7,9,7,4,10,2,7,8,7,0,2,0,7,-1,3,7,10,3,10,2,7,4,10,1,10,0,4,0,10,-1,1,10,2,8,7,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,9,1,4,1,7,7,1,3,-1,-1,-1,-1,-1,-1,-1,4,9,1,4,1,7,0,8,1,8,7,1,-1,-1,-1,-1,4,0,3,7,4,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,8,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,10,8,10,11,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,9,3,9,11,11,9,10,-1,-1,-1,-1,-1,-1,-1,0,1,10,0,10,8,8,10,11,-1,-1,-1,-1,-1,-1,-1,3,1,10,11,3,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,11,1,11,9,9,11,8,-1,-1,-1,-1,-1,-1,-1,3,0,9,3,9,11,1,2,9,2,11,9,-1,-1,-1,-1,0,2,11,8,0,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,2,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,8,2,8,10,10,8,9,-1,-1,-1,-1,-1,-1,-1,9,10,2,0,9,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,8,2,8,10,0,1,8,1,10,8,-1,-1,-1,-1,1,10,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,3,8,9,1,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,9,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,3,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1]);
	}function sa(t,e,i,n,r){function o(t,e,i){return t+(e-t)*i}function a(t,e,i,n,a,s,c){if(f[t]<0){var u=(g-s)/(c-s),h=d,l=3*p;if(w[l+0]=i+u,w[l+1]=n,w[l+2]=a,!v){var m=3*t;S[l]=-o(h[m],h[m+3],u),S[l+1]=-o(h[m+1],h[m+4],u),S[l+2]=-o(h[m+2],h[m+5],u)}r&&(M[p]=r[t+u]),f[t]=p,_[e]=p,p+=1}else _[e]=f[t]}function s(t,e,i,n,a,s,c){if(f[t]<0){var u=(g-s)/(c-s),h=d,l=3*p;if(w[l]=i,w[l+1]=n+u,w[l+2]=a,!v){var m=3*t,y=m+3*b;S[l]=-o(h[m],h[y],u),S[l+1]=-o(h[m+1],h[y+1],u),S[l+2]=-o(h[m+2],h[y+2],u)}r&&(M[p]=r[t+u*b]),f[t]=p,_[e]=p,p+=1}else _[e]=f[t]}function c(t,e,i,n,a,s,c){if(f[t]<0){var u=(g-s)/(c-s),h=d,l=3*p;if(w[l]=i,w[l+1]=n,w[l+2]=a+u,!v){var m=3*t,y=m+3*x;S[l]=-o(h[m],h[y],u),S[l+1]=-o(h[m+1],h[y+1],u),S[l+2]=-o(h[m+2],h[y+2],u)}r&&(M[p]=r[t+u*x]),f[t]=p,_[e]=p,p+=1}else _[e]=f[t]}function u(e){var i=3*e;0===d[i]&&(d[i]=t[e-1]-t[e+1],d[i+1]=t[e-b]-t[e+b],d[i+2]=t[e-x]-t[e+x])}function h(e,i,n,r){var o=r+1,h=r+b,l=r+x,d=o+b,f=o+x,p=r+b+x,y=o+b+x,w=0,S=t[r],M=t[o],T=t[h],E=t[d],I=t[l],L=t[f],R=t[p],O=t[y];S<g&&(w|=1),M<g&&(w|=2),T<g&&(w|=8),E<g&&(w|=4),I<g&&(w|=16),L<g&&(w|=32),R<g&&(w|=128),O<g&&(w|=64);var D=C[w];if(0===D)return 0;var N=e+1,k=i+1,F=n+1;1&D&&(v||(u(r),u(o)),a(r,0,e,i,n,S,M)),2&D&&(v||(u(o),u(d)),s(o,1,N,i,n,M,E)),4&D&&(v||(u(h),u(d)),a(h,2,e,k,n,T,E)),8&D&&(v||(u(r),u(h)),s(r,3,e,i,n,S,T)),16&D&&(v||(u(l),u(f)),a(l,4,e,i,F,I,L)),32&D&&(v||(u(f),u(y)),s(f,5,N,i,F,L,O)),64&D&&(v||(u(p),u(y)),a(p,6,e,k,F,R,O)),128&D&&(v||(u(l),u(p)),s(l,7,e,i,F,I,R)),256&D&&(v||(u(r),u(l)),c(r,8,e,i,n,S,I)),512&D&&(v||(u(o),u(f)),c(o,9,N,i,n,M,L)),1024&D&&(v||(u(d),u(y)),c(d,10,N,k,n,E,O)),2048&D&&(v||(u(h),u(p)),c(h,11,e,k,n,T,R)),w<<=4;for(var z,B,U,j=0;P[w+j]!=-1;)z=w+j,B=z+1,U=z+2,A[m]=_[P[B]],A[m+1]=_[P[z]],A[m+2]=_[P[U]],m+=3,j+=3}function l(r,o,a,s,c,u){var l,d,p,m,y,_;r=void 0!==r?r:0,o=void 0!==o?o:0,a=void 0!==a?a:0,s=void 0!==s?s:e-1,c=void 0!==c?c:i-1,u=void 0!==u?u:n-1,v?(r=Math.max(0,r),o=Math.max(0,o),a=Math.max(0,a),s=Math.min(e-1,s),c=Math.min(i-1,c),u=Math.min(n-1,u)):(r=Math.max(1,r),o=Math.max(1,o),a=Math.max(1,a),s=Math.min(e-2,s),c=Math.min(i-2,c),u=Math.min(n-2,u));var w=Math.max(0,r-2),S=Math.max(0,o-2),A=Math.max(0,a-2),M=Math.min(e,s+2),C=Math.min(i,c+2),P=Math.min(n,u+2);for(m=A;m<P;++m)for(_=x*m,p=S;p<C;++p)for(y=_+b*p,d=w;d<M;++d)l=y+d,f[l]=-1;var T,E=r,I=o,L=a,R=s,O=c,D=u;for(T=!1,m=a;m<u;++m){for(p=o;p<c;++p){for(d=r;d<s;++d)if(l=e*i*m+e*p+d,t[l]>=g){L=m,T=!0;break}if(T)break}if(T)break}for(T=!1,p=o;p<c;++p){for(m=L;m<u;++m){for(d=r;d<s;++d)if(l=e*i*m+e*p+d,t[l]>=g){I=p,T=!0;break}if(T)break}if(T)break}for(T=!1,d=r;d<s;++d){for(p=I;p<c;++p){for(m=L;m<u;++m)if(l=e*i*m+e*p+d,t[l]>=g){E=d,T=!0;break}if(T)break}if(T)break}for(T=!1,m=u;m>=a;--m){for(p=c;p>=o;--p){for(d=s;d>=r;--d)if(l=e*i*m+e*p+d,t[l]>=g){D=m,T=!0;break}if(T)break}if(T)break}for(T=!1,p=c;p>=o;--p){for(m=D;m>=a;--m){for(d=s;d>=r;--d)if(l=e*i*m+e*p+d,t[l]>=g){O=p,T=!0;break}if(T)break}if(T)break}for(T=!1,d=s;d>=r;--d){for(p=O;p>=o;--p){for(m=D;m>=a;--m)if(l=e*i*m+e*p+d,t[l]>=g){R=d,T=!0;break}if(T)break}if(T)break}for(v?(r=Math.max(0,E-1),o=Math.max(0,I-1),a=Math.max(0,L-1),s=Math.min(e-1,R+1),c=Math.min(i-1,O+1),u=Math.min(n-1,D+1)):(r=Math.max(1,E-1),o=Math.max(1,I-1),a=Math.max(1,L-1),s=Math.min(e-2,R+1),c=Math.min(i-2,O+1),u=Math.min(n-2,D+1)),m=a;m<u;++m)for(_=x*m,p=o;p<c;++p)for(y=_+b*p,d=r;d<s;++d)l=y+d,h(d,p,m,l)}var d,f,p,m,g=0,v=!1,y=e*i*n,b=e,x=e*i,_=new Int32Array(12),w=[],S=[],A=[],M=[],C=oa(),P=aa();this.triangulate=function(t,e,i){if(g=t,v=e,v||d||(d=new Float32Array(3*y)),f||(f=new Int32Array(y)),p=0,m=0,void 0!==i){var n=i[0].map(Math.round),o=i[1].map(Math.round);l(n[0],n[1],n[2],o[0],o[1],o[2])}else l();w.length=3*p,v||(S.length=3*p),A.length=m,r&&(M.length=p);var a=w.length/3>65535?Uint32Array:Uint16Array;return{position:new Float32Array(w),normal:v?void 0:new Float32Array(S),index:new a(A),atomindex:r?new Int32Array(M):void 0}}}function ca(t,e,i,n){i=i||1,n=n||!0;var r,o=t.length/3,a=e.length/3;n&&(r=new Float32Array(3*o));var s,c=new Float32Array(3*o),u=20,h=new Array(u);for(s=0;s<u;++s)h[s]=new Uint32Array(o);for(s=0;s<o;++s)h[0][s]=0;var l,d,f;for(s=0;s<a;++s){var p=3*s,m=3*s+1,g=3*s+2;for(f=!0,l=0,d=h[0][e[p]];l<d;++l)if(e[m]==h[l+1][e[p]]){f=!1;break}for(f&&(h[0][e[p]]++,h[h[0][e[p]]][e[p]]=e[m]),f=!0,l=0,d=h[0][e[p]];l<d;++l)if(e[g]==h[l+1][e[p]]){f=!1;break}for(f&&(h[0][e[p]]++,h[h[0][e[p]]][e[p]]=e[g]),f=!0,l=0,d=h[0][e[m]];l<d;++l)if(e[p]==h[l+1][e[m]]){f=!1;break}for(f&&(h[0][e[m]]++,h[h[0][e[m]]][e[m]]=e[p]),f=!0,l=0,d=h[0][e[m]];l<d;++l)if(e[g]==h[l+1][e[m]]){f=!1;break}for(f&&(h[0][e[m]]++,h[h[0][e[m]]][e[m]]=e[g]),f=!0,l=0;l<h[0][e[g]];++l)if(e[p]==h[l+1][e[g]]){f=!1;break}for(f&&(h[0][e[g]]++,h[h[0][e[g]]][e[g]]=e[p]),f=!0,l=0,d=h[0][e[g]];l<d;++l)if(e[m]==h[l+1][e[g]]){f=!1;break}f&&(h[0][e[g]]++,h[h[0][e[g]]][e[g]]=e[m])}for(var v,y,b,x,_,w=1,S=.5,A=-1,M=1,C=.75/(M+3.5),P=0;P<i;++P){for(s=0;s<o;++s)if(v=3*s,b=h[0][s],b<3)c[v]=t[v],c[v+1]=t[v+1],c[v+2]=t[v+2];else if(3===b||4===b){for(c[v]=0,c[v+1]=0,c[v+2]=0,l=0;l<b;++l)y=3*h[l+1][s],c[v]+=t[y],c[v+1]+=t[y+1],c[v+2]+=t[y+2];c[v]+=S*t[v],c[v+1]+=S*t[v+1],c[v+2]+=S*t[v+2],_=S+b,c[v]/=_,c[v+1]/=_,c[v+2]/=_}else{for(c[v]=0,c[v+1]=0,c[v+2]=0,l=0;l<b;++l)y=3*h[l+1][s],c[v]+=t[y],c[v+1]+=t[y+1],c[v+2]+=t[y+2];c[v]+=w*t[v],c[v+1]+=w*t[v+1],c[v+2]+=w*t[v+2],x=w+b,c[v]/=x,c[v+1]/=x,c[v+2]/=x}if(t.set(c),n){ua(t,e,r);var T=3*o;for(v=0;v<T;v+=3)t[v]+=A*C*r[v],t[v+1]+=A*C*r[v+1],t[v+2]+=A*C*r[v+2]}}}function ua(t,e,i){var n,r;if(void 0===i)i=new Float32Array(t.length);else for(n=0,r=i.length;n<r;n++)i[n]=0;var o=new Float32Array(3),a=new Float32Array(3),s=new Float32Array(3),c=new Float32Array(3),u=new Float32Array(3);if(e)for(n=0,r=e.length;n<r;n+=3){var h=3*e[n],l=3*e[n+1],d=3*e[n+2];Ur(o,t,h),Ur(a,t,l),Ur(s,t,d),Br(c,s,a),Br(u,o,a),zr(c,c,u),i[h]+=c[0],i[h+1]+=c[1],i[h+2]+=c[2],i[l]+=c[0],i[l+1]+=c[1],i[l+2]+=c[2],i[d]+=c[0],i[d+1]+=c[1],i[d+2]+=c[2]}else for(n=0,r=t.length;n<r;n+=9)Ur(o,t,n),Ur(a,t,n+3),Ur(s,t,n+6),Br(c,s,a),Br(u,o,a),zr(c,c,u),i[n]=c[0],i[n+1]=c[1],i[n+2]=c[2],i[n+3]=c[0],i[n+4]=c[1],i[n+5]=c[2],i[n+6]=c[0],i[n+7]=c[1],i[n+8]=c[2];return kr(i),i}function ha(t){for(var e={},i=0,n=t.length;i<n;++i)e[t[i]]=!0;return e}function la(t,e,i,n,r){var o=1/n*3;o+=i,Hr(t,t,r+o),Wr(e,e,r+o),Vr(t,t,n),Xr(t,t),$r(t,t,n),Vr(e,e,n),qr(e,e),$r(e,e,n);var a=new Float32Array(3);Br(a,e,t),Vr(a,a,n),qr(a,a),Wr(a,a,1);var s=256*Math.pow(10,6),c=a[0]*a[1]*a[2]*3;s<=c&&(n*=Math.pow(s/c,1/3),Vr(t,t,n),Xr(t,t),$r(t,t,n),Vr(e,e,n),qr(e,e),$r(e,e,n),Br(a,e,t),Vr(a,a,n),qr(a,a),Wr(a,a,1));var u=new Float32Array(t);Yr(u,u);var h=ho(),l=ho();go(l,wn(90)),fo(h,h,l);var d=ho();po(d,-1/n,1/n,1/n),fo(h,h,d);var f=ho();return mo(f,-n*u[2],-n*u[1],-n*u[0]),fo(h,h,f),{dim:a,tran:u,matrix:h,scaleFactor:n}}function da(t,e,i,n,r){function o(t,e,i,n){var r=a.triangulate(t,e,i);if(e&&(ca(r.position,r.index,e,!0),r.normal=ua(r.position,r.index)),n&&(Dr(n,r.position),r.normal)){var o=vo();yo(o,n),Nr(o,r.normal)}return r}var a=new sa(t,e,i,n,r);this.getSurface=o}function fa(t,e,i,n,r,o,a){this.name=t,this.path=e,this.matrix=new O,this.normalMatrix=new Lt,this.inverseMatrix=new O,this.center=new N,this.boundingBox=new Et,this.setData(i,n,r,o,a)}function pa(t,e){function i(e){t(e,n)}function n(){var t=r.shift();void 0!==t?(o=!0,setTimeout(function(){i(t)})):o=!1}var r=[],o=!1;if(e){for(var a=0,s=e.length;a<s;++a)r.push(e[a]);n()}this.push=function(t){r.push(t),o||n()},this.kill=function(){r.length=0},this.length=function(){return r.length}}function ma(t,e){var i;"function"==typeof t.eachAtom?i=t.atomCount:t instanceof Float32Array&&(i=t.length/3);var n=new Zr(3,i),r=new Zr(3,i);this.coords1t=new Zr(i,3),this.coords2t=new Zr(i,3),this.A=new Zr(3,3),this.W=new Zr(1,3),this.U=new Zr(3,3),this.V=new Zr(3,3),this.VH=new Zr(3,3),this.R=new Zr(3,3),this.tmp=new Zr(3,3),this.c=new Zr(3,3),this.c.data.set([1,0,0,0,1,0,0,0,-1]),this.prepCoords(t,n),this.prepCoords(e,r),this._superpose(n,r)}function ga(t,e,i){this.signals={gotNumframes:new xn,frameChanged:new xn,selectionChanged:new xn,playerChanged:new xn},this.params={centerPbc:!0,removePbc:!0,superpose:!0},this.name=t.replace(/^.*[\\\/]/,""),this.selection=new _n(i||"backbone and not hydrogen"),this.selection.signals.stringChanged.add(function(){this.makeIndices(),this.resetCache()},this),this.setStructure(e),this.trajPath=t,this.numframes=void 0,this.getNumframes()}function va(t){return"front"===t?ch:"back"===t?uh:"double"===t?hh:hh}function ya(t,e,i,n,r){var o=r||{};this.pickable=!1,this.dynamic=!0,this.opaqueBack=d(o.opaqueBack,!1),this.dullInterior=d(o.dullInterior,!1),this.side=d(o.side,"double"),this.opacity=d(o.opacity,1),this.clipNear=d(o.clipNear,0),this.clipRadius=d(o.clipRadius,0),this.clipCenter=d(o.clipCenter,new N),this.flatShaded=d(o.flatShaded,!1),this.background=d(o.background,!1),this.linewidth=d(o.linewidth,1),this.wireframe=d(o.wireframe,!1),this.wireframeLinewidth=d(o.wireframeLinewidth,1),this.roughness=d(o.roughness,.4),this.metalness=d(o.metalness,0),this.diffuse=d(o.diffuse,16777215),this.forceTransparent=d(o.forceTransparent,!1),this.geometry=new ue,this.addAttributes({position:{type:"v3",value:t},color:{type:"c",value:e}}),this.indexVersion=0,this.wireframeIndexVersion=-1,i&&(this.geometry.setIndex(new Kt(i,1)),this.geometry.getIndex().setDynamic(this.dynamic)),n&&(this.addAttributes({pickingColor:{type:"c",value:n}}),this.pickable=!0),this.uniforms=xd.merge([_p.common,{fogColor:{value:null},fogNear:{value:0},fogFar:{value:0},opacity:{value:this.opacity},nearClip:{value:0},clipRadius:{value:this.clipRadius},clipCenter:{value:this.clipCenter}},{emissive:{value:new Pt(0)},roughness:{value:this.roughness},metalness:{value:this.metalness}},_p.ambient,_p.lights]),this.uniforms.diffuse.value.set(this.diffuse);var a=new en(0).onUpdate(function(t){this.value=sv?t.id:t.id/255});this.pickingUniforms={nearClip:{value:0},objectId:a},this.group=new He,this.wireframeGroup=new He,this.pickingGroup=new He,this.makeWireframeGeometry()}function ba(t,e,i,n,r,o){var a=o||{};this.size=t?t.length/3:0,this.attributeSize=this.size,this.vertexShader="Mesh.vert",this.fragmentShader="Mesh.frag",ya.call(this,t,e,i,r,a),this.addAttributes({normal:{type:"v3",value:n}}),void 0===n&&this.geometry.computeVertexNormals()}function xa(t){for(var e,i,n=t.vertices,r=n.length,o=new Float32Array(3*r),a=0;a<r;a++)e=3*a,i=n[a],o[e+0]=i.x,o[e+1]=i.y,o[e+2]=i.z;return o}function _a(t){for(var e,i,n=t.faces,r=n.length,o=3*r>65535?Uint32Array:Uint16Array,a=new o(3*r),s=0;s<r;s++)e=3*s,i=n[s],a[e+0]=i.a,a[e+1]=i.b,a[e+2]=i.c;return a}function wa(t){for(var e,i,n,r,o,a,s=t.faces,c=t.vertices.length,u=s.length,h=new Float32Array(3*c),l=0;l<u;l++)i=s[l],n=i.vertexNormals,r=n[0],o=n[1],a=n[2],e=3*i.a,h[e+0]=r.x,h[e+1]=r.y,h[e+2]=r.z,e=3*i.b,h[e+0]=o.x,h[e+1]=o.y,h[e+2]=o.z,e=3*i.c,h[e+0]=a.x,h[e+1]=a.y,h[e+2]=a.z;return h}function Sa(t,e,i,n){var r,o,a=n||{},s=this.geo,c=t.length/3;s.vertices&&s.faces?(this.geoPosition=xa(s),this.geoNormal=wa(s),this.geoIndex=_a(s),r=s.vertices.length,o=s.faces.length):(this.geoPosition=s.attributes.position.array,this.geoNormal=s.attributes.normal.array,this.geoIndex=s.index.array,r=this.geoPosition.length/3,o=this.geoIndex.length/3),this.size=c*r,this.positionCount=c,this.geoPositionCount=r,this.geoFacesCount=o,this.transformedGeoPosition=new Float32Array(3*r),this.transformedGeoNormal=new Float32Array(3*r),this.meshPosition=new Float32Array(3*this.size),this.meshNormal=new Float32Array(3*this.size),this.meshColor=new Float32Array(3*this.size),this.meshPickingColor=new Float32Array(3*this.size);var u=this.meshPosition.length/3>65535?Uint32Array:Uint16Array;this.meshIndex=new u(c*o*3),this.makeIndex(),ba.call(this,this.meshPosition,this.meshColor,this.meshIndex,this.meshNormal,this.meshPickingColor,a),this.initNormals=!0,this.setAttributes({position:t,color:e,pickingColor:i}),this.initNormals=!1}function Aa(t,e,i,n,r){var o=r||{},a=d(o.sphereDetail,1);this.geo=new mn(1,a),this._radius=i,Sa.call(this,t,e,n,o)}function Ma(t){this.size=this.count,this.attributeSize=this.count*this.mappingSize;var e=this.count*this.mappingIndicesSize,i=this.attributeSize>65535?Uint32Array:Uint16Array;this.index=new i(e),this.makeIndex(),ya.call(this,null,null,this.index,null,t),this.addAttributes({mapping:{type:this.mappingType,value:null}})}function Ca(t){this.mapping=new Float32Array([-1,1,-1,-1,1,1,1,-1]),this.mappingIndices=new Uint16Array([0,1,2,1,3,2]),this.mappingIndicesSize=6,this.mappingType="v2",this.mappingSize=4,this.mappingItemSize=2,Ma.call(this,t)}function Pa(t,e,i,n,r){this.impostor=!0,this.count=t.length/3,this.vertexShader="SphereImpostor.vert",this.fragmentShader="SphereImpostor.frag",Ca.call(this,r),this.addUniforms({projectionMatrixInverse:{value:new O},ortho:{value:0}}),this.addAttributes({radius:{type:"f",value:null}}),this.setAttributes({position:t,color:e,radius:i}),n&&(this.addAttributes({pickingColor:{type:"c",value:null}}),this.setAttributes({pickingColor:n}),this.pickable=!0),this.makeMapping()}function Ta(t,e,i,n,r){var o=r||{};return!cv||o.disableImpostor?new Aa(t,e,i,n,r):new Pa(t,e,i,n,r)}function Ea(t,e,i,n,r,o,a){var s=a||{},c=d(s.sphereDetail,2);this.updateNormals=!0,this.geo=new mn(1,c),this._radius=i,this._majorAxis=n,this._minorAxis=r,Sa.call(this,t,e,o,s)}function Ia(t,e,i,n,r,o,a){return new Ea(t,e,i,n,r,o,a)}function La(t,e,i,n,r,o,a,s){var c=s||{},u=d(c.radialSegments,10),h=d(c.openEnded,!0);this.updateNormals=!0;var l=(new O).makeRotationX(Math.PI/2);this.geo=new dn(1,1,1,u,1,h),this.geo.applyMatrix(l);var f=t.length,p=r.length;this._position=new Float32Array(2*f),this._color=new Float32Array(2*f),this._pickingColor=new Float32Array(2*f),this._from=new Float32Array(2*f),this._to=new Float32Array(2*f),this._radius=new Float32Array(2*p),this.__center=new Float32Array(f),Sa.call(this,this._position,this._color,this._pickingColor,c),this.setAttributes({position1:t,position2:e,color:i,color2:n,radius:r,pickingColor:o,pickingColor2:a})}function Ra(t){this.mapping=new Float32Array([-1,1,-1,-1,-1,-1,1,1,-1,1,1,1,1,-1,-1,1,-1,1]),this.mappingIndices=new Uint16Array([0,1,2,1,4,2,2,4,3,4,5,3]),this.mappingIndicesSize=12,this.mappingType="v3",this.mappingSize=6,this.mappingItemSize=3,Ma.call(this,t)}function Oa(t,e,i,n,r,o,a,s){var c=s||{};this.openEnded=d(c.openEnded,!1),this.impostor=!0,this.count=t.length/3,this.vertexShader="CylinderImpostor.vert",this.fragmentShader="CylinderImpostor.frag",Ra.call(this,c);var u=new en(new O).onUpdate(function(t){this.value.getInverse(t.modelViewMatrix)});this.addUniforms({modelViewMatrixInverse:u,ortho:{value:0}}),this.addAttributes({position1:{type:"v3",value:null},position2:{type:"v3",value:null},color2:{type:"c",value:null},radius:{type:"f",value:null}}),this.setAttributes({position1:t,position2:e,color:i,color2:n,radius:r}),o&&(this.addAttributes({pickingColor:{type:"c",value:null},pickingColor2:{type:"c",value:null}}),this.setAttributes({pickingColor:o,pickingColor2:a}),this.pickable=!0),this.makeMapping()}function Da(t,e,i,n,r,o,a,s){var c=s||{};return!cv||c.disableImpostor?new La(t,e,i,n,r,o,a,s):new Oa(t,e,i,n,r,o,a,s)}function Na(t,e,i,n,r,o){var a=o||{},s=d(a.radialSegments,60),c=d(a.openEnded,!1);this.updateNormals=!0;var u=(new O).makeRotationX(-Math.PI/2);this.geo=new vn(1,1,s,1,c),this.geo.applyMatrix(u);var h=t.length,l=n.length;this._position=new Float32Array(h),this._from=new Float32Array(h),this._to=new Float32Array(h),this._radius=new Float32Array(l),Sa.call(this,this._position,i,r,a),this.setAttributes({position1:t,position2:e,color:i,radius:n,pickingColor:r})}function ka(t,e,i,n,r,o){return new Na(t,e,i,n,r,o)}function Fa(t,e,i,n,r,o){function a(t){var e,i,n={};if(t.radius){for(e=0,i=p.length;e<i;++e)p[e]=t.radius[e]/c;n.cylinderRadius=p,n.coneRadius=t.radius}if(t.from&&t.to){var r=new N,o=new N,a=new N,s=new N;for(e=0,i=f.length;e<i;e+=3){r.fromArray(t.from,e),o.fromArray(t.to,e),a.subVectors(r,o);var u=a.length(),h=p[e/3]*c*2,l=Math.min(u,h);a.setLength(l),s.copy(o).add(a),s.toArray(f,e)}n.cylinderFrom=t.from,n.cylinderTo=f,n.coneFrom=f,n.coneTo=t.to}return t.color&&(n.cylinderColor=t.color,n.cylinderColor2=t.color,n.coneColor=t.color),t.pickingColor&&(n.cylinderPickingColor=t.pickingColor,n.cylinderPickingColor2=t.pickingColor,n.conePickingColor=t.pickingColor),n}var s=o||{},c=d(s.aspectRatio,1.5),u=d(s.radialSegments,50),h=d(s.openEnded,!1),l=d(s.disableImpostor,!1),f=new Float32Array(t.length),p=new Float32Array(n.length),m=a({from:t,to:e,color:i,radius:n,pickingColor:r}),g=new Da(m.cylinderFrom,m.cylinderTo,m.cylinderColor,m.cylinderColor2,m.cylinderRadius,m.cylinderPickingColor,m.cylinderPickingColor2,{radialSegments:u,openEnded:h,disableImpostor:l}),v=new ka(m.coneFrom,m.coneTo,m.coneColor,m.coneRadius,m.conePickingColor,{radialSegments:u,openEnded:h,disableImpostor:l});this.geometry=[g.geometry,v.geometry],this.wireframe=d(s.wireframe,!1),this.group=new He,this.wireframeGroup=new He,this.pickingGroup=new He,this.getMesh=function(t){return(new He).add(g.getMesh(t),v.getMesh(t))},this.getWireframeMesh=function(){return(new He).add(g.getWireframeMesh(),v.getWireframeMesh())},this.getPickingMesh=function(){return(new He).add(g.getPickingMesh(),v.getPickingMesh())},this.setAttributes=function(t){var e=a(t);g.setAttributes({position1:e.cylinderFrom,position2:e.cylinderTo,color:e.cylinderColor,color2:e.cylinderColor2,radius:e.radius,pickingColor:e.cylinderPickingColor,pickingColor2:e.cylinderPickingColor2}),v.setAttributes({position1:e.coneFrom,position2:e.coneTo,color:e.coneColor,radius:e.coneRadius.radius,pickingColor:e.conePickingColor})},this.setParameters=function(t){g.setParameters(t),v.setParameters(t),t&&void 0!==t.wireframe&&(this.wireframe=t.wireframe,this.setVisibility(this.visible))},this.setVisibility=ya.prototype.setVisibility,this.dispose=function(){g.dispose(),v.dispose()}}function za(t,e){function i(t,e){void 0!==t.toArray?t=t.toArray():void 0!==t.x?t=[t.x,t.y,t.z]:void 0!==t.r&&(t=[t.r,t.g,t.b]),e.push.apply(e,t)}function n(t){S.push(t)}function r(t,e,i,n){if(Array.isArray(t)&&(t=new Float32Array(t)),Array.isArray(e)&&(e=new Float32Array(e)),Array.isArray(i)){var r=(t&&t.length)>65535?Uint32Array:Uint16Array;i=new r(i)}Array.isArray(n)&&(n=new Float32Array(n));var o=new ba(t,e,i,n);S.push(o),w.setFromArray(t),x.union(w)}function o(t,e,n){i(t,A),i(e,M),C.push(n),x.expandByPoint(_.fromArray(t))}function a(t,e,n,r,o){i(t,P),i(e,T),E.push(n),i(r,I),i(o,L),x.expandByPoint(_.fromArray(t))}function s(t,e,n,r){i(t,R),i(e,O),i(n,D),k.push(r),x.expandByPoint(_.fromArray(t)),x.expandByPoint(_.fromArray(e))}function c(t,e,n,r){i(t,F),i(e,z),i(n,B),U.push(r),x.expandByPoint(_.fromArray(t)),x.expandByPoint(_.fromArray(e))}function u(t,e,n,r){i(t,j),i(e,$),i(n,V),G.push(r),x.expandByPoint(_.fromArray(t)),x.expandByPoint(_.fromArray(e))}function h(){var t=[];if(A.length){var e=new Ta(new Float32Array(A),new Float32Array(M),new Float32Array(C),void 0,{sphereDetail:m,disableImpostor:v});t.push(e)}if(P.length){var i=new Ia(new Float32Array(P),new Float32Array(T),new Float32Array(E),new Float32Array(I),new Float32Array(L),void 0,{sphereDetail:m,disableImpostor:v});t.push(i)}if(R.length){var n=new Da(new Float32Array(R),new Float32Array(O),new Float32Array(D),new Float32Array(D),new Float32Array(k),void 0,void 0,{radialSegments:g,disableImpostor:v,openEnded:y});t.push(n)}if(F.length){var r=new ka(new Float32Array(F),new Float32Array(z),new Float32Array(B),new Float32Array(U),void 0,{radialSegments:g,disableImpostor:v,openEnded:y});t.push(r)}if(j.length){var o=new Fa(new Float32Array(j),new Float32Array($),new Float32Array(V),new Float32Array(G),void 0,{aspectRatio:p,radialSegments:g,disableImpostor:v,openEnded:y});t.push(o)}return S.concat(t)}function l(){S.forEach(function(t){t.dispose()}),S.length=0,A.length=0,M.length=0,C.length=0,P.length=0,T.length=0,E.length=0,I.length=0,L.length=0,R.length=0,O.length=0,D.length=0,k.length=0,F.length=0,z.length=0,B.length=0,U.length=0,j.length=0,$.length=0,V.length=0,G.length=0}this.name=d(t,"shape");var f=e||{},p=d(f.aspectRatio,1.5),m=d(f.sphereDetail,2),g=d(f.radialSegments,50),v=d(f.disableImpostor,!1),y=d(f.openEnded,!1),b=new N,x=new Et,_=new N,w=new Et,S=[],A=[],M=[],C=[],P=[],T=[],E=[],I=[],L=[],R=[],O=[],D=[],k=[],F=[],z=[],B=[],U=[],j=[],$=[],V=[],G=[];Object.defineProperties(this,{center:{get:function(){return x.center(b)}}}),this.boundingBox=x,this.addBuffer=n,this.addMesh=r,this.addSphere=o,this.addEllipsoid=a,this.addCylinder=s,this.addCone=c,this.addArrow=u,this.getBufferList=h,this.dispose=l}function Ba(t,e,i){this.viewer=e,this.gidPool=i?i.gidPool:void 0,this.tasks=new ur,this.queue=new pa(this.make.bind(this)),this.bufferList=[],this.init(i)}function Ua(t,e,i){Array.isArray(t)||(t=[t]),Ba.call(this,t,e,i),this.buffer=t,this.build()}function ja(){ba.apply(this,arguments)}function $a(t){this.size=t.size,this.side=t.side,this.wireframe=t.wireframe,this.visible=t.visible,this.geometry=t.geometry,this.pickable=t.pickable,this.background=t.background,this.group=new He,this.wireframeGroup=new He,this.pickingGroup=new He;var e=[],i=[],n=t,r=new t.constructor;n.makeMaterial(),r.makeMaterial(),r.geometry=t.geometry,r.wireframeGeometry=t.wireframeGeometry,r.size=t.size,r.attributeSize=t.attributeSize,r.pickable=t.pickable,r.setParameters(t.getParameters()),r.updateShader(),n.setParameters({side:"front"}),r.setParameters({side:"back",opacity:r.opacity}),this.getMesh=function(t){var o,a;return t?(a=r.getPickingMesh(),o=n.getPickingMesh()):(a=r.getMesh(),o=n.getMesh()),e.push(o),i.push(a),this.setParameters({side:this.side}),(new He).add(a,o)},this.getWireframeMesh=function(){return t.getWireframeMesh()},this.getPickingMesh=function(){return this.getMesh(!0)},this.setAttributes=function(e){t.setAttributes(e)},this.setParameters=function(t){t=Object.assign({},t),"front"===t.side?(e.forEach(function(t){t.visible=!0}),i.forEach(function(t){t.visible=!1})):"back"===t.side?(e.forEach(function(t){t.visible=!1}),i.forEach(function(t){t.visible=!0})):"double"===t.side&&(e.forEach(function(t){t.visible=!0}),i.forEach(function(t){t.visible=!0})),void 0!==t.side&&(this.side=t.side),delete t.side,n.setParameters(t),void 0!==t.wireframe&&(this.wireframe=t.wireframe,this.setVisibility(this.visible)),delete t.wireframe,r.setParameters(t)},this.setVisibility=ya.prototype.setVisibility,this.dispose=function(){n.dispose(),r.dispose()}}function Va(t,e,i){Ba.call(this,t,e,i),t instanceof fa?(this.surface=void 0,this.volume=t):(this.surface=t,this.volume=void 0),this.boxCenter=new N,this.__boxCenter=new N,this.box=new Et,this.__box=new Et,this.setBox=function(){var t=new N;return function(){var i=e.controls.target,n=e.rotationGroup.position;t.copy(n).negate().add(i),t.equals(this.boxCenter)||this.setParameters({boxCenter:t})}.bind(this)}.bind(this)(),this.viewer.signals.orientationChanged.add(this.setBox),this.build()}function Ga(t){function e(t,e,i){return Math.min(Math.max(t,e),i)}function i(t,e,i,n){var r=i-t,o=n-e;return Math.sqrt(r*r+o*o)}function n(t,i,n){return n=e((n-t)/(i-t),0,1),n*n*(3-2*n)}for(var r=Object.assign({},t),o=d(r.width,256),a=d(r.height,256),s=[o/2,a/2],c=Math.min(o/2,a/2),u=d(r.delta,1/(c+1))*c,h=0,l=0,f=new Uint8Array(o*a*4),p=0,m=f.length;p<m;p+=4){var g=i(h,l,s[0],s[1]),v=1-n(c-u,c,g);f[p]=255*v,f[p+1]=255*v,f[p+2]=255*v,f[p+3]=255*v,++h===o&&(h=0,l++)}var y=new ke(f,o,a);return y.needsUpdate=!0,y}function Ha(t,e,i){var n=i||{};this.point=!0,this.pointSize=d(n.pointSize,1),this.sizeAttenuation=d(n.sizeAttenuation,!0),this.sortParticles=d(n.sortParticles,!1),this.alphaTest=d(n.alphaTest,.5),this.useTexture=d(n.useTexture,!1),this.forceTransparent=d(n.forceTransparent,!1),this.edgeBleach=d(n.edgeBleach,0),this.size=t.length/3,this.attributeSize=this.size,this.vertexShader="Point.vert",this.fragmentShader="Point.frag",ya.call(this,t,e,void 0,void 0,n),this.addUniforms({size:{value:this.pointSize},canvasHeight:{value:1},pixelRatio:{value:1},map:{value:null}})}function Wa(t,e,i){Ba.call(this,t,e,i),t instanceof fa?(this.surface=void 0,this.volume=t):(this.surface=t,this.volume=void 0),this.build()}function Xa(t,e,i,n,r){var o=r||{};this.size=4,this.attributeSize=this.size,this.vertexShader="Image.vert",this.fragmentShader="Image.frag",ya.call(this,t,void 0,Uv,void 0,o),this.forceTransparent=!0,this.filter=d(o.filter,"nearest"),this.tex=new ke(e,i,n),this.tex.flipY=!0,this.addUniforms({map:{value:null},mapSize:{value:new I(i,n)}}),this.geometry.addAttribute("uv",new Kt(jv,2))}function qa(t,e,i){Ba.call(this,t,e,i),this.volume=t,this.build()}function Ya(t,e,i){var n=i||{};if(this.selection=new _n(n.sele),this.dataList=[],this.structure=t,this.structureView=this.structure.getView(this.selection),Ba.call(this,t,e,n),t.biomolDict){var r={default:"default","":t.unitcell?"AU":"FULL"};Object.keys(t.biomolDict).forEach(function(t){r[t]=t}),this.parameters.assembly={type:"select",options:r,rebuild:!0}}else this.parameters.assembly=null;this.selection.signals.stringChanged.add(function(){this.build()}.bind(this)),this.build()}function Za(t,e,i,n,r){var o=r||{};this.size=t.length/3,this.vertexShader="Line.vert",this.fragmentShader="Line.frag",this.line=!0;var a=this.size,s=2*a*2;this.attributeSize=s,this.linePosition=new Float32Array(3*s),this.lineColor=new Float32Array(3*s),ya.call(this,this.linePosition,this.lineColor,void 0,void 0,o),this.setAttributes({from:t,to:e,color:i,color2:n})}function Ka(t,e,i){this.manualAttach=!0,this.trajectory=t,Ya.call(this,t.structure,e,i)}function Qa(t){uv.error("makeRepresentation: representation type "+t+" unknown")}function Ja(e,i,n,r){t.Debug&&uv.time("makeRepresentation "+e);var o;if(i instanceof ea){if(o=pv.get(e),!o)return void Qa(e)}else if(i instanceof ia)if("surface"===e)o=Va;else{if("dot"!==e)return void Qa(e);o=Wa}else if(i instanceof fa)if("surface"===e)o=Va;else if("dot"===e)o=Wa;else{if("slice"!==e)return void Qa(e);o=qa}else if(i instanceof ga)o=Ka;else if(i instanceof za)o=Ua,i=i.getBufferList();else{if("buffer"!==e)return void uv.error("makeRepresentation: object "+i+" unknown");o=Ua}var a=new o(i,n,r);return t.Debug&&uv.timeEnd("makeRepresentation "+e),a}function ts(t,e){Object.defineProperty(this,"id",{value:$v++});var i=e||{};this.name=i.name,this.uuid=Fp(),this.visible=void 0===i.visible||i.visible;var n=Object.keys(this.signals);this.signals={},n.forEach(function(t){this.signals[t]=new xn},this),this.stage=t,this.viewer=t.viewer,this.reprList=[]}function es(t,e,i,n){var r=i||{};r.name=d(r.name,e.type),ts.call(this,t,r),this.parent=n,this.setRepresentation(e)}function is(t){this.list=t||[];for(var e=this.list.length,i=0;i<e;++i){var n=this.list[i];n.signals.disposed.add(this._remove,this)}}function ns(t){is.call(this,t)}function rs(t){is.call(this,t)}function os(t,e){if(this.signals={parametersChanged:new xn,fullscreenChanged:new xn,componentAdded:new xn,componentRemoved:new xn,clicked:new xn,hovered:new xn},this.tasks=new ur,this.gidPool=new hr,this.compList=[],this.defaultFileParams={},this.viewer=new Tr(t),this.viewer.renderer){this.pickingControls=new Rv(this),this.pickingControls.signals.clicked.add(this.signals.clicked.dispatch),this.pickingControls.signals.hovered.add(this.signals.hovered.dispatch);var i=Object.assign({impostor:!0,quality:"medium",sampleLevel:0,backgroundColor:"black",rotateSpeed:2,zoomSpeed:1.2,panSpeed:.8,clipNear:0,clipFar:100,clipDist:10,fogNear:50,fogFar:100,cameraFov:40,cameraType:"perspective",lightColor:14540253,lightIntensity:1,ambientColor:14540253,ambientIntensity:.2,hoverTimeout:500},e);this.parameters=g(os.prototype.parameters),this.setParameters(i),this.viewer.animate()}}function as(t,e,i,n,r){this.signals={startedRunning:new xn,haltedRunning:new xn},t.signals.playerChanged.add(function(t){t!==this&&this.pause()},this),this.traj=t,this.step=e||Math.ceil((t.numframes+1)/100),this.timeout=i||50,this.start=n||0,this.end=r||t.numframes-1,this.end=Math.min(this.end,t.numframes-1),this.interpolateType="",this.interpolateStep=5,this.mode="loop",this.direction="forward",this._stopFlag=!1,this._running=!1}function ss(t,e,i,n,r){this.seq1=t,this.seq2=e,this.gapPenalty=i||-10,this.gapExtensionPenalty=n||-1,this.substMatrix=r||"blosum62",this.substMatrix&&(this.substMatrix=Vv[this.substMatrix])}function cs(t,e,i,n,r){i=d(i,!1),n=d(n,""),r=d(r,"");var o,a,s,c,u;if(i){var h=t,l=e;n&&r&&(h=t.getView(new _n(n)),l=e.getView(new _n(r)));var f=h.getSequence(),p=l.getSequence(),m=new ss(f.join(""),p.join(""));m.calc(),m.trace();var g,v,y,b,x;o=0,a=0,s=m.ali1.length;var _=[],w=[];for(g=0;g<s;++g)b=m.ali1[g],x=m.ali2[g],v=0,y=0,"-"===b?w[a]=!1:(w[a]=!0,v=1),"-"===x?_[o]=!1:(_[o]=!0,y=1),o+=v,a+=y;var S=[],A=[],M=h.getAtomProxy(),C=l.getAtomProxy();o=0,h.eachResidue(function(t){void 0!==t.traceAtomIndex&&t.traceAtomIndex===t.getAtomIndexByName("CA")&&(_[o]&&(M.index=t.getAtomIndexByName("CA"),S.push(M.x,M.y,M.z)),o+=1)}),o=0,l.eachResidue(function(t){void 0!==t.traceAtomIndex&&t.traceAtomIndex===t.getAtomIndexByName("CA")&&(w[o]&&(C.index=t.getAtomIndexByName("CA"),A.push(C.x,C.y,C.z)),o+=1)}),c=new Float32Array(S),u=new Float32Array(A)}else{var P=t.getView(new _n(n+" and .CA")),T=e.getView(new _n(r+" and .CA"));c=P,u=T}var E=new ma(c,u);E.transform(t),t.refreshPosition()}function us(t,e,i){var n=i||{};n.name=d(n.name,e.name),ts.call(this,t,n),this.script=e,this.status="loaded",this.script.signals.nameChanged.add(function(t){this.setName(t)},this)}function hs(t,e,i){var n=i||{};n.name=d(n.name,e.name),ts.call(this,t,n),this.shape=e}function ls(t,e,i,n){var r=i||{};r.name=void 0!==r.name?r.name:e.name,ts.call(this,t,r),this.trajectory=e,this.parent=n,this.status="loaded",e.signals.frameChanged.add(function(t){this.signals.frameChanged.dispatch(t)},this),e.signals.playerChanged.add(function(t){this.signals.playerChanged.dispatch(t)},this),e.signals.gotNumframes.add(function(t){this.signals.gotNumframes.dispatch(t)},this),void 0!==r.i&&this.setFrame(r.i)}function ds(t,e,i){t instanceof Promise?t.then(function(t){this.setFrames(t),this.getNumframes()}.bind(this)):this.setFrames(t),ga.call(this,"",e,i)}function fs(t,e,i){t="",ga.call(this,t,e,i)}function ps(t,e,i){ga.call(this,t,e,i)}function ms(t,e,i){var n;return n=t&&"frames"===t.type||t instanceof Promise?new ds(t,e,i):!t&&e.frames?new fs(t,e,i):new ps(t,e,i)}function gs(t,e){this.signals={refreshed:new xn},this.structure=t,this.selection=e,this.center=new N,this.boundingBox=new Et,this.init(),this.refresh()}function vs(t,e,i){var n=i||{};n.name=d(n.name,e.name),ts.call(this,t,n),this.structure=e,this.trajList=[],this.initSelection(n.sele),this.setDefaultAssembly(n.assembly||""),this.stage.gidPool.addObject(this.structure)}function ys(t,e,i){var n=i||{};n.name=d(n.name,e.name),ts.call(this,t,n),this.surface=e}function bs(t,e,i){var n=i||{};n.name=d(n.name,e.name),ts.call(this,t,n),this.volume=e,this.stage.gidPool.addObject(this.volume)}function xs(t,e,i){Ya.call(this,t,e,i)}function _s(t,e,i){Ya.call(this,t,e,i)}function ws(t,e,i){_s.call(this,t,e,i)}function Ss(t,e,i){_s.call(this,t,e,i)}function As(t,e){function i(t,i,n,r,o){var a=(n-t)*e,s=(r-i)*e,c=o*o,u=o*c;return(2*i-2*n+a+s)*u+(-3*i+3*n-2*a-s)*c+a*o+i}function n(t,e,n,r,o,a,s){a[s+0]=i(t.x,e.x,n.x,r.x,o),a[s+1]=i(t.y,e.y,n.y,r.y,o),a[s+2]=i(t.z,e.z,n.z,r.z,o)}function r(t,e,n,r,o,a){a.x=i(t.x,e.x,n.x,r.x,o),a.y=i(t.y,e.y,n.y,r.y,o),a.z=i(t.z,e.z,n.z,r.z,o)}function o(e,i,r,o,a,s){for(var c=0;c<t;++c){var u=s+3*c,h=d*c;n(e,i,r,o,h,a,u)}}function a(e,i,n,o,a,s){for(var c=0;c<t;++c){var u=d*c,h=u-f,l=u+f,g=s+3*c;h<0&&(h=0),l>1&&(l=1),r(e,i,n,o,h,p),r(e,i,n,o,l,m),m.sub(p).normalize(),m.toArray(a,g)}}function s(e,i,n,r,o){for(var a,s=i.next(),c=i.next(),u=i.next(),h=i.size,l=h-1,d=r||0,f=0;f<l;++f)a=s,s=c,c=u,u=i.next(),e(a,s,c,u,n,d),d+=3*t;o&&(a=i.get(h-2),s=i.get(h-1),c=i.get(0),u=i.get(1),e(a,s,c,u,n,d),d+=3*t)}function c(e,i,n,o,a,s,c,u,h,l,f,_,w){for(var S=0;S<t;++S){var A=_+3*S;w&&(A+=3*x);var M=d*S;r(e,i,n,o,M,p),
	r(a,s,c,u,M,m),g.subVectors(m,p).normalize(),v.fromArray(h,A),b.crossVectors(g,v).normalize(),b.toArray(f,A),y.crossVectors(v,b).normalize(),y.toArray(l,A)}}function u(e,i,n,r,o){for(var a=0;a<t;++a){var s=o+3*a;e.copy(y),v.fromArray(i,s),b.crossVectors(e,v).normalize(),b.toArray(r,s),y.crossVectors(v,b).normalize(),y.toArray(n,s)}}function h(e,i,n,r,o,a,s){var c,u;for(c=0;c<x;++c)u=s+3*c,n(e,o,u),r(e,a,u);for(c=x;c<t;++c)u=s+3*c,n(i,o,u),r(i,a,u)}function l(e,i,n,r,o){for(var a=n(e),s=n(i),c=0;c<t;++c){var u=c/t;r[o+c]=(1-u)*a+u*s}}var d=1/t,f=1e-4,p=new N,m=new N;this.getPosition=function(e,i,n,r){e.reset(),s(o,e,i,n,r);var a=e.size-1,c=a*t*3;r&&(c+=3*t);var u=e.get(r?0:a);i[c]=u.x,i[c+1]=u.y,i[c+2]=u.z},this.getTangent=function(e,i,n,r){e.reset(),s(a,e,i,n,r);var o=e.size-1,c=o*t*3;r&&(c+=3*t),_r(i,i,c-3,c,3)};var g=new N,v=new N,y=new N,b=new N,x=Math.ceil(t/2);this.getNormal=function(e,i,n,r,o,a){y.set(0,0,1);for(var s=e,c=s-1,h=o||0,l=0;l<c;++l)u(g,i,n,r,h),h+=3*t;a&&(u(g,i,n,r,h),h+=3*t),b.toArray(r,h),y.toArray(n,h)},this.getNormalDir=function(e,i,n,r,o,a,s,u){e.reset(),i.reset();var h=new N,l=new N,d=new N,f=new N,p=new N,m=(new N).copy(e.next()),g=(new N).copy(e.next()),v=(new N).copy(e.next()),_=new N,w=(new N).copy(i.next()),S=(new N).copy(i.next()),A=(new N).copy(i.next());y.set(0,0,1);for(var M=e.size,C=M-1,P=a||0,T=0;T<C;++T)p.copy(m),m.copy(g),g.copy(v),v.copy(e.next()),_.copy(w),w.copy(S),S.copy(A),A.copy(i.next()),0===T?(h.subVectors(_,p),l.subVectors(w,m),h.dot(l)<0&&(l.multiplyScalar(-1),w.addVectors(m,l)),d.subVectors(S,g),l.dot(d)<0&&(d.multiplyScalar(-1),S.addVectors(g,d))):d.copy(f),f.subVectors(A,v),d.dot(f)<0&&(f.multiplyScalar(-1),A.addVectors(v,f)),c(p,m,g,v,_,w,S,A,n,r,o,P,u),P+=3*t;if(s&&(p.copy(e.get(M-2)),m.copy(e.get(M-1)),g.copy(e.get(0)),v.copy(e.get(1)),_.copy(i.get(M-2)),w.copy(i.get(M-1)),S.copy(i.get(0)),A.copy(i.get(1)),d.copy(f),f.subVectors(A,v),d.dot(f)<0&&(f.multiplyScalar(-1),A.addVectors(v,f)),c(p,m,g,v,_,w,S,A,n,r,o,P,u),P+=3*t),u){b.fromArray(o,3*x),y.fromArray(r,3*x);for(var E=0;E<x;++E)b.toArray(o,3*E),y.toArray(r,3*E)}else b.toArray(o,P),y.toArray(r,P)},this.getColor=function(e,i,n,r,o,a,s){e.reset();for(var c=e.next(),u=e.next(),l=e.size,d=l-1,f=a||0,p=0;p<d;++p)c=u,u=e.next(),h(c,u,i,n,r,o,f),f+=3*t;s&&(c=e.get(l-1),u=e.get(0),h(c,u,i,n,r,o,f),f+=3*t),r[f]=r[f-3],r[f+1]=r[f-2],r[f+2]=r[f-1],o[f]=o[f-3],o[f+1]=o[f-2],o[f+2]=o[f-1]},this.getSize=function(e,i,n,r,o){e.reset();for(var a=e.next(),s=e.next(),c=e.size,u=c-1,h=r||0,d=0;d<u;++d)a=s,s=e.next(),l(a,s,i,n,h),h+=t;o&&(a=e.get(c-1),s=e.get(0),l(a,s,i,n,h),h+=t),n[h]=n[h-1]}}function Ms(t,e){this.polymer=t,this.size=t.residueCount;var i=e||{};this.directional=i.directional||!1,this.positionIterator=i.positionIterator||!1,this.subdiv=i.subdiv||1,this.smoothSheet=i.smoothSheet||!1,isNaN(i.tension)?this.tension=this.polymer.isNucleic()?.5:.9:this.tension=i.tension||.5,this.interpolator=new As(this.subdiv,this.tension)}function Cs(t,e,i,n,r,o,a,s){var c=s||{};this.aspectRatio=d(c.aspectRatio,1),this.radialSegments=d(c.radialSegments,4),this.capped=d(c.capped,!1),this.capVertices=this.capped?this.radialSegments:0,this.capTriangles=this.capped?this.radialSegments-2:0;var u=t.length/3,h=u-1,l=u*this.radialSegments*3+2*this.capVertices*3;this.size2=u,this.meshPosition=new Float32Array(l),this.meshColor=new Float32Array(l),this.meshNormal=new Float32Array(l),this.meshPickingColor=a?new Float32Array(l):void 0;var f=2*h*this.radialSegments*3+2*this.capTriangles*3,p=this.meshPosition.length/3>65535?Uint32Array:Uint16Array;this.meshIndex=new p(f),this.makeIndex(),ba.call(this,this.meshPosition,this.meshColor,this.meshIndex,this.meshNormal,this.meshPickingColor,c),this.setAttributes({position:t,normal:e,binormal:i,tangent:n,color:r,size:o,pickingColor:a})}function Ps(t,e,i){Ya.call(this,t,e,i)}function Ts(t,e){this.sview1=t,this.sview2=e,this.kdtree2=new Lo(e)}function Es(t,e,i){e=e||3.5,i=i||40;for(var n=new _n("( ARG and ( .NE or .NH1 or .NH2 ) ) or ( ASP and .ND2 ) or ( GLN and .NE2 ) or ( HIS and ( .ND1 or .NE2 ) ) or ( LYS and .NZ ) or ( SER and .OG ) or ( THR and .OG1 ) or ( TRP and .NE1 ) or ( TYR and .OH ) or ( PROTEIN and .N )"),r=new _n("( ASN and .OD1 ) or ( ASP and ( OD1 or .OD2 ) ) or ( GLN and .OE1 ) or ( GLU and ( .OE1 or .OE2 ) ) or ( HIS and ( .ND1 or .NE2 ) ) or ( SER and .OG ) or ( THR and .OG1 ) or ( TYR and .OH ) or ( PROTEIN and .O )"),o=t.getView(n),a=t.getView(r),s=new Ts(o,a),c=s.within(e),u=c.bondStore,h=t.getAtomProxy(),l=t.getAtomProxy(),d=t.getAtomProxy(),f=t.getAtomProxy(),p=t.getResidueProxy(),m=t.getResidueProxy(),g=new N,v=new N,y=function(t,e,n,r){var o,a;t.atomname===n?(o=t,a=e):(o=e,a=t),p.index=o.residueIndex;var s=p.getAtomIndexByName(r);return g.subVectors(s,o),v.subVectors(s,a),Sn(g.angleTo(v))<i},b=0,x=u.count;b<x;++b)if(h.index=u.atomIndex1[b],l.index=u.atomIndex2[b],"O"===h.atomname&&"N"===l.atomname||"N"===h.atomname&&"O"===l.atomname)c.bondSet.flip_unsafe(b);else if("N"===h.atomname||"N"===l.atomname){var _,w;if("N"===h.atomname?(_=h,w=l):(_=l,w=h),p.index=_.residueIndex,d.index=p.getAtomIndexByName("CA"),void 0===d.index)continue;var S=p.getPreviousConnectedResidue(m);if(void 0===S)continue;if(f.index=S.getAtomIndexByName("C"),void 0===f.index)continue;g.subVectors(_,f),v.subVectors(_,d),g.add(v).multiplyScalar(.5),v.subVectors(w,_),Sn(g.angleTo(v))>i&&c.bondSet.flip_unsafe(b)}else("OH"===h.atomname&&"TYR"===h.resname||"OH"===l.atomname&&"TYR"===l.resname)&&(y(h,l,"OH","CZ")||c.bondSet.flip_unsafe(b));return{atomSet:c.atomSet,bondSet:c.bondSet,bondStore:c.bondStore}}function Is(t,e,i){e=e||3.5,i=i||40;for(var n=new _n("( PROTEIN and .N )"),r=new _n("( PROTEIN and .O )"),o=t.getView(n),a=t.getView(r),s=new Ts(o,a),c=s.within(e),u=c.bondStore,h=t.getAtomProxy(),l=t.getAtomProxy(),d=t.getAtomProxy(),f=t.getAtomProxy(),p=t.getResidueProxy(),m=t.getResidueProxy(),g=new N,v=new N,y=0,b=u.count;y<b;++y){h.index=u.atomIndex1[y],l.index=u.atomIndex2[y];var x,_;if("N"===h.atomname?(x=h,_=l):(x=l,_=h),p.index=x.residueIndex,d.index=p.getAtomIndexByName("CA"),void 0!==d.index){var w=p.getPreviousConnectedResidue(m);void 0!==w&&(f.index=w.getAtomIndexByName("C"),void 0!==f.index&&(g.subVectors(x,f),v.subVectors(x,d),g.add(v).multiplyScalar(.5),v.subVectors(_,x),Sn(g.angleTo(v))>i&&c.bondSet.flip_unsafe(y)))}}return{atomSet:c.atomSet,bondSet:c.bondSet,bondStore:c.bondStore}}function Ls(t,e,i){Ya.call(this,t,e,i)}function Rs(t){var e=Object.assign({},t);if(this.font=d(e.font,["sans-serif"]),this.size=d(e.size,36),this.style=d(e.style,"normal"),this.variant=d(e.variant,"normal"),this.weight=d(e.weight,"normal"),this.outline=d(e.outline,0),this.width=d(e.width,1024),this.height=d(e.height,1024),this.gamma=1,"undefined"!=typeof navigator){var i=navigator.userAgent;i.match(/Chrome/)&&i.match(/OS X/)&&(this.gamma=.5)}this.mapped={},this.scratchW=0,this.scratchH=0,this.currentX=0,this.currentY=0,this.build(),this.populate(),this.texture=new Xe(this.canvas2),this.texture.flipY=!1,this.texture.needsUpdate=!0}function Os(t,e,i,n,r){var o=r||{};o.forceTransparent=!0,this.fontFamily=d(o.fontFamily,"sans-serif"),this.fontStyle=d(o.fontStyle,"normal"),this.fontWeight=d(o.fontWeight,"bold"),this.fontSize=d(o.fontSize,48),this.sdf=d(o.sdf,"Chrome"===ov),this.xOffset=d(o.xOffset,0),this.yOffset=d(o.yOffset,0),this.zOffset=d(o.zOffset,.5),this.attachment=d(o.attachment,"bottom-left"),this.showBorder=d(o.showBorder,!1),this.borderColor=d(o.borderColor,"lightgrey"),this.borderWidth=d(o.borderWidth,.15),this.showBackground=d(o.showBackground,!1),this.backgroundColor=d(o.backgroundColor,"lightgrey"),this.backgroundMargin=d(o.backgroundMargin,.5),this.backgroundOpacity=d(o.backgroundOpacity,1);for(var a=t.length/3,s=0,c=0;c<a;++c)s+=n[c].length;this.text=n,this.count=s,this.showBackground&&(this.count+=a),this.positionCount=a,this.vertexShader="SDFFont.vert",this.fragmentShader="SDFFont.frag",Ca.call(this,o),this.addUniforms({fontTexture:{value:null},xOffset:{value:this.xOffset},yOffset:{value:this.yOffset},zOffset:{value:this.zOffset},ortho:{value:!1},showBorder:{value:this.showBorder},borderColor:{value:new Pt(this.borderColor)},borderWidth:{value:this.borderWidth},backgroundColor:{value:new Pt(this.backgroundColor)},backgroundOpacity:{value:this.backgroundOpacity}}),this.addAttributes({inputTexCoord:{type:"v2",value:null},inputSize:{type:"f",value:null}}),this.setAttributes({position:t,size:e,color:i}),this.makeTexture(),this.makeMapping()}function Ds(t,e,i){Ya.call(this,t,e,i)}function Ns(t,e,i){var n=i||{};this.size=t.length/3,this.vertexShader="Line.vert",this.fragmentShader="Line.frag",this.line=!0;var r=this.size,o=2*r;this.attributeSize=o,this.scale=n.scale||1;var a=new Pt(n.color||"grey");this.linePosition=new Float32Array(3*o),this.lineColor=br(o,a.r,a.g,a.b),ya.call(this,this.linePosition,this.lineColor,void 0,void 0,n),this.setAttributes({position:t,vector:e})}function ks(t,e,i){Ya.call(this,t,e,i)}function Fs(t,e,i){_s.call(this,t,e,i)}function zs(t){this.mapping=new Float32Array([-1,-1,-1,1,-1,-1,1,-1,1,-1,-1,1,-1,1,-1,1,1,-1,1,1,1,-1,1,1]),this.mappingIndices=new Uint16Array([0,1,2,0,2,3,1,5,6,1,6,2,4,6,5,4,7,6,0,7,4,0,3,7,0,5,1,0,4,5,3,2,6,3,6,7]),this.mappingIndicesSize=36,this.mappingType="v3",this.mappingSize=8,this.mappingItemSize=3,Ma.call(this,t)}function Bs(t,e){var i=t.material.uniforms;i.modelViewMatrixInverse&&i.modelViewMatrixInverse.value.getInverse(t.modelViewMatrix),i.modelViewMatrixInverseTranspose&&(i.modelViewMatrixInverse?i.modelViewMatrixInverseTranspose.value.copy(i.modelViewMatrixInverse.value).transpose():i.modelViewMatrixInverseTranspose.value.getInverse(t.modelViewMatrix).transpose()),i.modelViewProjectionMatrix&&i.modelViewProjectionMatrix.value.multiplyMatrices(e.projectionMatrix,t.modelViewMatrix),i.modelViewProjectionMatrixInverse&&(i.modelViewProjectionMatrix?(Hv.copy(i.modelViewProjectionMatrix.value),i.modelViewProjectionMatrixInverse.value.getInverse(Hv)):(Hv.multiplyMatrices(e.projectionMatrix,t.modelViewMatrix),i.modelViewProjectionMatrixInverse.value.getInverse(Hv)))}function Us(t,e,i,n,r,o,a,s,c){var u=c||{},h=d(u.shrink,.14);this.impostor=!0,this.count=t.length/3,this.vertexShader="HyperballStickImpostor.vert",this.fragmentShader="HyperballStickImpostor.frag",zs.call(this,u);var l=new en(new O).onUpdate(Bs),f=new en(new O).onUpdate(Bs),p=new en(new O).onUpdate(Bs);this.addUniforms({modelViewProjectionMatrix:l,modelViewProjectionMatrixInverse:f,modelViewMatrixInverseTranspose:p,shrink:{value:h}}),this.addAttributes({color:{type:"c",value:null},color2:{type:"c",value:null},radius:{type:"f",value:null},radius2:{type:"f",value:null},position1:{type:"v3",value:null},position2:{type:"v3",value:null}}),this.setAttributes({color:i,color2:n,radius:r,radius2:o,position1:t,position2:e,position:vr(t,e)}),a&&(this.addAttributes({pickingColor:{type:"c",value:null},pickingColor2:{type:"c",value:null}}),this.setAttributes({pickingColor:a,pickingColor2:s}),this.pickable=!0),this.makeMapping()}function js(t,e,i,n,r,o,a,s,c){var u=c||{};return!cv||u.disableImpostor?new La(t,e,i,n,xr(r,o),a,s,c):new Us(t,e,i,n,r,o,a,s,c)}function $s(t,e,i){Fs.call(this,t,e,i),this.defaultScale.vdw=.2}function Vs(t,e){this.type=t,this.text=e||{}}function Gs(t,e,i){Ya.call(this,t,e,i)}function Hs(t,e,i){Ya.call(this,t,e,i)}function Ws(t,e,i,n,r){function o(t,n,o){return((t*e+n)*i+o)*r}n=n||Int32Array,r=r||1;var a,s=new n(t*e*i*r);this.data=s,this.index=o,this.set=function(t,e,i){var n=o(t,e,i);for(a=0;a<r;++a)s[n+a]=arguments[3+a]},this.toArray=function(t,e,i,n,c){var u=o(t,e,i);for(void 0===n&&(n=[]),void 0===c&&(c=0),a=0;a<r;++a)n[a]=s[u+a]},this.fromArray=function(t,e,i,n,c){var u=o(t,e,i);for(void 0===c&&(c=0),a=0;a<r;++a)s[u+a]=n[c+a]},this.copy=function(t){this.data.set(t.data)},this.clone=function(){return new Ws(t,e,i,n,r).copy(this)}}function Xs(t,e,i){function n(t,e,i,n,o){m=e||1.4,g=i||2,C=o||!0;var a=0;for(var s in f)a=Math.max(a,s);var c=la(I,L,a,g,t?m:0);y=c.dim[0],b=c.dim[1],x=c.dim[2],_=c.matrix,w=c.tran,g=c.scaleFactor,S={},A={},r(t),M=m*g,v=n?n:m/g,P=new Uint8Array(y*b*x),t&&(T=new Float64Array(y*b*x)),C&&(E=new Int32Array(y*b*x))}function r(t){var e,i,n,r,o,a,s,c,u,h;for(var l in f)if(e=f[l],!S[l]){for(s=t?(e+m)*g+.5:e*g+.5,a=s*s,c=Math.floor(s)+1,u=new Int32Array(c*c),h=0,i=0;i<c;++i)for(n=0;n<c;++n)r=i*i+n*n,r>a?u[h]=-1:(o=Math.sqrt(a-r),u[h]=Math.floor(o)),++h;A[l]=c,S[l]=u}}function o(i){var n,r,o,a,s,c,u,h,l,d,f,p,m,v,_,M,T,I,L=3*i,O=i;n=Math.floor(.5+g*(t[L]+w[0])),r=Math.floor(.5+g*(t[L+1]+w[1])),o=Math.floor(.5+g*(t[L+2]+w[2]));var D,N=e[O],k=S[N],F=0,z=b*x,B=A[N];for(d=0;d<B;++d)for(f=0;f<B;++f){if(D=k[F],D!=-1)for(M=-1;M<2;++M)for(T=-1;T<2;++T)for(I=-1;I<2;++I)if(0!==M&&0!==T&&0!==I)for(u=M*d,l=I*f,p=0;p<=D;++p)if(h=p*T,m=n+u,v=r+h,_=o+l,!(m<0||v<0||_<0||m>=y||v>=b||_>=x)){var U=m*z+v*x+_;if(C)if(P[U]&R){if(P[U]&R){var j=E[U];j!==L&&(a=n+u-Math.floor(.5+g*(t[j]+w[0])),s=r+h-Math.floor(.5+g*(t[j+1]+w[1])),c=o+l-Math.floor(.5+g*(t[j+2]+w[2])),u*u+h*h+l*l<a*a+s*s+c*c&&(E[U]=i))}}else P[U]|=R,E[U]=i;else P[U]|=R}F++}}function a(e){console.time("EDTSurface fillvoxels");var i,n;for(i=0,n=P.length;i<n;++i)P[i]=0,e&&(T[i]=-1),C&&(E[i]=-1);for(i=0,n=t.length/3;i<n;++i)o(i);for(i=0,n=P.length;i<n;++i)P[i]&R&&(P[i]|=O);console.timeEnd("EDTSurface fillvoxels")}function s(i){var n,r,o,a,s,c,u,h,l,d,f,p,m,v,_,M,T,I,L,R=3*i,D=i,N=0;n=Math.floor(.5+g*(t[R]+w[0])),r=Math.floor(.5+g*(t[R+1]+w[1])),o=Math.floor(.5+g*(t[R+2]+w[2]));var k=e[D],F=b*x;for(m=0,L=A[k];m<L;++m)for(v=0;v<L;++v){if(S[k][N]!=-1)for(M=-1;M<2;++M)for(T=-1;T<2;++T)for(I=-1;I<2;++I)if(0!==M&&0!==T&&0!==I)for(u=M*m,l=I*v,_=0;_<=S[k][N];++_)if(h=_*T,d=n+u,f=r+h,p=o+l,!(d<0||f<0||p<0||d>=y||f>=b||p>=x)){var z=d*F+f*x+p;if(P[z]&O){if(C){var B=E[z];a=Math.floor(.5+g*(t[B]+w[0])),s=Math.floor(.5+g*(t[B+1]+w[1])),c=Math.floor(.5+g*(t[B+2]+w[2])),u*u+h*h+l*l<a*a+s*s+c*c&&(E[z]=i)}}else P[z]|=O,C&&(E[z]=i)}N++}}function c(){var e,i;for(e=0,i=P.length;e<i;++e)P[e]&=~O;for(e=0,i=t.length/3;e<i;++e)s(e)}function u(){var t,e,i,n=b*x;for(t=0;t<y;++t)for(e=0;e<x;++e)for(i=0;i<b;++i){var r=t*n+i*x+e;if(P[r]&R)for(var o=0;o<26;){var a=t+N[o][0],s=e+N[o][2],c=i+N[o][1];if(a>-1&&a<y&&c>-1&&c<b&&s>-1&&s<x&&!(P[a*n+c*x+s]&R)){P[r]|=D;break}o++}}}function h(){console.time("EDTSurface fastdistancemap");var t,e,i,n,r,o=new Ws(y,b,x,Uint16Array,3),a=b*x,s=M*M,c=0;for(t=0;t<y;++t)for(e=0;e<b;++e)for(i=0;i<x;++i)r=t*a+e*x+i,P[r]&=~O,P[r]&R&&P[r]&D&&(o.set(t,e,i,t,e,i),T[r]=0,P[r]|=O,c+=1);var u=new Int32Array(3*c),h=0,d=new Int32Array(3*c),f=0;for(t=0;t<y;++t)for(e=0;e<b;++e)for(i=0;i<x;++i)r=t*a+e*x+i,P[r]&D&&(u[h]=t,u[h+1]=e,u[h+2]=i,h+=3,P[r]&=~D);do for(f=l(u,o,h,d),h=0,t=0,n=f;t<n;t+=3)r=a*d[t]+x*d[t+1]+d[t+2],P[r]&=~D,T[r]<=1.0404*s&&(u[h]=d[t],u[h+1]=d[t+1],u[h+2]=d[t+2],h+=3);while(h>0);var p,m=v*v,g=new Uint16Array(3);for(t=0;t<y;++t)for(e=0;e<b;++e)for(i=0;i<x;++i)r=t*a+e*x+i,P[r]&=~D,P[r]&R&&(P[r]&O&&!(P[r]&O&&T[r]>=m)||(P[r]|=D,C&&P[r]&O&&(o.toArray(t,e,i,g),p=g[0]*a+g[1]*x+g[2],E[r]=E[p])));console.timeEnd("EDTSurface fastdistancemap")}function l(t,e,i,n){var r,o,a,s,c,u,h,l,d,f,p,m,g=new Uint16Array(3),v=0;if(0===i)return v;var _=-1,w=-1,S=-1,A=b*x;for(h=0,d=i;h<d;h+=3)for(r=t[h],o=t[h+1],a=t[h+2],e.toArray(r,o,a,g),l=0;l<6;++l)m=N[l],_=r+m[0],w=o+m[1],S=a+m[2],_<y&&_>-1&&w<b&&w>-1&&S<x&&S>-1&&(p=_*A+x*w+S,P[p]&R&&!(P[p]&O)?(e.fromArray(_,w,S,g),s=_-g[0],c=w-g[1],u=S-g[2],f=s*s+c*c+u*u,T[p]=f,P[p]|=O,P[p]|=D,n[v]=_,n[v+1]=w,n[v+2]=S,v+=3):P[p]&R&&P[p]&O&&(s=_-g[0],c=w-g[1],u=S-g[2],f=s*s+c*c+u*u,f<T[p]&&(e.fromArray(_,w,S,g),T[p]=f,P[p]&D||(P[p]|=D,n[v]=_,n[v+1]=w,n[v+2]=S,v+=3))));for(h=0,d=i;h<d;h+=3)for(r=t[h],o=t[h+1],a=t[h+2],e.toArray(r,o,a,g),l=6;l<18;l++)m=N[l],_=r+m[0],w=o+m[1],S=a+m[2],_<y&&_>-1&&w<b&&w>-1&&S<x&&S>-1&&(p=_*A+x*w+S,P[p]&R&&!(P[p]&O)?(e.fromArray(_,w,S,g),s=_-g[0],c=w-g[1],u=S-g[2],f=s*s+c*c+u*u,T[p]=f,P[p]|=O,P[p]|=D,n[v]=_,n[v+1]=w,n[v+2]=S,v+=3):P[p]&R&&P[p]&O&&(s=_-g[0],c=w-g[1],u=S-g[2],f=s*s+c*c+u*u,f<T[p]&&(e.fromArray(_,w,S,g),T[p]=f,P[p]&D||(P[p]|=D,n[v]=_,n[v+1]=w,n[v+2]=S,v+=3))));for(h=0,d=i;h<d;h+=3)for(r=t[h],o=t[h+1],a=t[h+2],e.toArray(r,o,a,g),l=18;l<26;l++)m=N[l],_=r+m[0],w=o+m[1],S=a+m[2],_<y&&_>-1&&w<b&&w>-1&&S<x&&S>-1&&(p=_*A+x*w+S,P[p]&R&&!(P[p]&O)?(e.fromArray(_,w,S,g),s=_-g[0],c=w-g[1],u=S-g[2],f=s*s+c*c+u*u,T[p]=f,P[p]|=O,P[p]|=D,n[v]=_,n[v+1]=w,n[v+2]=S,v+=3):P[p]&R&&P[p]&O&&(s=_-g[0],c=w-g[1],u=S-g[2],f=s*s+c*c+u*u,f<T[p]&&(e.fromArray(_,w,S,g),T[p]=f,P[p]&D||(P[p]|=D,n[v]=_,n[v+1]=w,n[v+2]=S,v+=3))));return v}function d(t){var e,i=P.length;if("vws"===t)for(e=0;e<i;++e)P[e]&=~D,P[e]=P[e]&O?1:0;else if("ms"===t)for(e=0;e<i;++e)P[e]&=~O,P[e]&D&&(P[e]|=O),P[e]&=~D,P[e]=P[e]&O?1:0;else if("ses"===t)for(e=0;e<i;++e)P[e]&D&&P[e]&O?P[e]&=~D:P[e]&D&&!(P[e]&O)&&(P[e]|=O),P[e]=P[e]&O?1:0;else if("sas"===t)for(e=0;e<i;++e)P[e]&=~D,P[e]=P[e]&O?1:0}var f=ha(e),p=Or(t);0===t.length&&(p[0].set([0,0,0]),p[1].set([0,0,0]));var m,g,v,y,b,x,_,w,S,A,M,C,P,T,E,I=p[0],L=p[1],R=1,O=2,D=4,N=[new Int32Array([1,0,0]),new Int32Array([-1,0,0]),new Int32Array([0,1,0]),new Int32Array([0,-1,0]),new Int32Array([0,0,1]),new Int32Array([0,0,-1]),new Int32Array([1,1,0]),new Int32Array([1,-1,0]),new Int32Array([-1,1,0]),new Int32Array([-1,-1,0]),new Int32Array([1,0,1]),new Int32Array([1,0,-1]),new Int32Array([-1,0,1]),new Int32Array([-1,0,-1]),new Int32Array([0,1,1]),new Int32Array([0,1,-1]),new Int32Array([0,-1,1]),new Int32Array([0,-1,-1]),new Int32Array([1,1,1]),new Int32Array([1,1,-1]),new Int32Array([1,-1,1]),new Int32Array([-1,1,1]),new Int32Array([1,-1,-1]),new Int32Array([-1,-1,1]),new Int32Array([-1,1,-1]),new Int32Array([-1,-1,-1])];this.getVolume=function(t,e,o,s,l){console.time("EDTSurface.getVolume");var f="vws"!==t;n(f,e,o,s,l),a(f),u(),"ms"!==t&&"ses"!==t||h(),"ses"===t&&(r(!1),c()),d(t);for(var p=0,m=E.length;p<m;++p)E[p]=i[E[p]];return console.timeEnd("EDTSurface.getVolume"),{data:P,nx:x,ny:b,nz:y,atomindex:E}},this.getSurface=function(t,e,i,n,r,o){var a=this.getVolume(t,e,i,n,r),s=new da(a.data,a.nx,a.ny,a.nz,a.atomindex);return s.getSurface(1,o,void 0,_)}}function qs(t,e,i,n,r,o,a){function s(t,e){return Math.floor((t-e)/a)}for(var c=t.length,u=r[0],h=r[1],l=r[2],d=o[0],f=o[1],p=o[2],m=s(d,u)+1,g=s(f,h)+1,v=s(p,l)+1,y=m*g*v,b=m*g,x=function(t,e,i){return s(t,u)*b+s(e,h)*g+s(i,l)},_=[],w=0;w<c;w++){var S=x(t[w],e[w],i[w]);void 0===_[S]?_[S]=[w]:_[S].push(w)}var A=new Uint32Array(y),M=new Uint16Array(y),C=new Uint32Array(c),P=0,T=0;for(w=0;w<y;w++){var E=A[w]=P,I=_[w];if(void 0!==I)for(var L=0;L<I.length;L++)C[P]=I[L],P++;var R=P-E;M[w]=R,R>T&&(T=R)}this.neighbourListLength=27*T+1,this.withinRadii=function(r,o,a,c,d){for(var f=0,p=s(r,u),y=s(o,h),x=s(a,l),_=Math.max(0,p-1),w=Math.max(0,y-1),S=Math.max(0,x-1),P=Math.min(m,p+1),T=Math.min(g,y+1),E=Math.min(v,x+1),I=_;I<=P;++I)for(var L=I*b,R=w;R<=T;++R)for(var O=R*g,D=S;D<=E;++D)for(var N=L+O+D,k=A[N],F=k+M[N],z=k;z<F;z++){var B=C[z],U=t[B]-r,j=e[B]-o,$=i[B]-a,V=n[B]+c;U*U+j*j+$*$<=V*V&&(d[f++]=C[z])}d[f]=-1}}function Ys(t,e,i){function n(t,i,n,r){T=d(t,1.4),E=d(i,2),I=d(n,!0),L=d(r,30),M=new Float32Array(y),C=new Float32Array(y);for(var c=0;c<M.length;++c){var u=e[c]+T;M[c]=u,C[c]=u*u}P=0;for(var h=0;h<M.length;++h)M[h]>P&&(P=M[h]);o(),a(),s(),W=-1}function r(t,e,i){for(var n=0;n<t.length;n++)t[n]=e+i*n}function o(){var t=la(G,H,P,E,0);E=t.scaleFactor,R=t.dim,O=t.matrix,V=Math.min(5,2+Math.floor(T*E)),D=yr(R[0]*R[1]*R[2],-1001),N=new Int32Array(D.length),k=new Float32Array(R[0]),F=new Float32Array(R[1]),z=new Float32Array(R[2]),r(k,G[0],1/E),r(F,G[1],1/E),r(z,G[2],1/E)}function a(){var t=0,e=2*Math.PI/L;U=new Float32Array(L),B=new Float32Array(L);for(var i=0;i<L;i++)U[i]=Math.cos(t),B[i]=Math.sin(t),t+=e}function s(){j=new qs(b,x,_,M,G,H,2.01*P),$=new Int32Array(j.neighbourListLength)}function c(t,e,i,n,r){var o;if(W!==-1){if(o=W,o!==n&&o!==r&&u(o,t,e,i))return o;W=-1}var a=0;for(o=$[a];o>=0;){if(o!==n&&o!==r&&u(o,t,e,i))return W=o,o;o=$[++a]}return W=-1,-1}function u(e,i,n,r){var o=3*e,a=C[e],s=t[o]-i,c=t[o+1]-n,u=t[o+2]-r,h=s*s+c*c+u*u;return h<a}function h(){for(var t=0;t<y;t++){var e=b[t],i=x[t],n=_[t],r=M[t],o=C[t];j.withinRadii(e,i,n,r,$);for(var a=Math.ceil(r*E),s=Math.floor(E*(e-G[0])),u=Math.floor(E*(i-G[1])),h=Math.floor(E*(n-G[2])),l=Math.max(0,s-a),d=Math.max(0,u-a),f=Math.max(0,h-a),p=Math.min(R[0],s+a+2),m=Math.min(R[1],u+a+2),g=Math.min(R[2],h+a+2),v=l;v<p;v++)for(var w=k[v]-e,S=R[1]*R[2]*v,A=d;A<m;A++)for(var P=F[A]-i,T=w*w+P*P,L=S+R[2]*A,O=f;O<g;O++){var B=z[O]-n,U=T+B*B;if(U<o){var V=O+L;D[V]<0&&(D[V]=-D[V]);var H=Math.sqrt(U),W=r/H,X=w*W,q=P*W,Y=B*W;if(X+=e,q+=i,Y+=n,c(X,q,Y,t,-1)===-1){var Z=r-H;Z<D[V]&&(D[V]=Z,I&&(N[V]=t))}}}}}function l(){for(var t=0;t<y;t++){j.withinRadii(b[t],x[t],_[t],M[t],$);for(var e=0,i=$[e];i>=0;)t<i&&f(t,i),i=$[++e]}}function f(t,e){var i=M[t],n=M[e],r=X[0]=b[e]-b[t],o=X[1]=x[e]-x[t],a=X[2]=_[e]-_[t],s=r*r+o*o+a*a,u=Math.sqrt(s),h=(i*i+u*u-n*n)/(2*i*u),l=i*h;Gr(X,X),p(q,X),Gr(q,q),zr(Y,X,q),Gr(Y,Y);var d=Math.sqrt(i*i-l*l);Vr(q,q,d),Vr(Y,Y,d),Vr(X,X,l),X[0]+=b[t],X[1]+=x[t],X[2]+=_[t],W=-1;for(var f=V,m=0;m<L;m++){var g=U[m],v=B[m],y=X[0]+g*q[0]+v*Y[0],w=X[1]+g*q[1]+v*Y[1],S=X[2]+g*q[2]+v*Y[2];if(c(y,w,S,t,e)==-1)for(var A=Math.floor(E*(y-G[0])),C=Math.floor(E*(w-G[1])),P=Math.floor(E*(S-G[2])),T=Math.max(0,A-f),O=Math.max(0,C-f),j=Math.max(0,P-f),$=Math.min(R[0],A+f+2),H=Math.min(R[1],C+f+2),Z=Math.min(R[2],P+f+2),K=T;K<$;K++){r=y-k[K];for(var Q=R[1]*R[2]*K,J=O;J<H;J++){o=w-F[J];for(var tt=r*r+o*o,et=Q+R[2]*J,it=j;it<Z;it++){a=S-z[it],s=tt+a*a;var nt=it+et,rt=D[nt];rt>0&&s<rt*rt&&(D[nt]=Math.sqrt(s),I&&(N[nt]=t))}}}}}function p(t,e){return t[0]=t[1]=t[2]=1,0!=e[0]?t[0]=(e[1]+e[2])/-e[0]:0!=e[1]?t[1]=(e[0]+e[2])/-e[1]:0!=e[2]&&(t[2]=(e[0]+e[1])/-e[2]),t}function m(){for(var t=0;t<D.length;t++)D[t]<0&&(D[t]=0)}function g(){for(var t=0;t<N.length;t++)N[t]=i[N[t]]}function v(t,e,i){console.time("AVSurface.getVolume"),console.time("AVSurface.init"),n(t,e,i),console.timeEnd("AVSurface.init"),console.time("AVSurface.projectPoints"),h(),console.timeEnd("AVSurface.projectPoints"),console.time("AVSurface.projectTorii"),l(),console.timeEnd("AVSurface.projectTorii"),m(),g(),console.timeEnd("AVSurface.getVolume")}for(var y=e.length,b=new Float32Array(y),x=new Float32Array(y),_=new Float32Array(y),w=0;w<y;w++){var S=3*w;b[w]=t[S],x[w]=t[S+1],_[w]=t[S+2]}var A=Or(t);0===t.length&&(A[0].set([0,0,0]),A[1].set([0,0,0]));var M,C,P,T,E,I,L,R,O,D,N,k,F,z,B,U,j,$,V,G=A[0],H=A[1],W=-1,X=new Float32Array([0,0,0]),q=new Float32Array([0,0,0]),Y=new Float32Array([0,0,0]);this.getSurface=function(t,e,i,n,r){v(e,i,r);var o=new da(D,R[2],R[1],R[0],N);return o.getSurface(e,!1,void 0,O)}}function Zs(t){this.structure=t}function Ks(t,e,i){this.__infoList=[],Ya.call(this,t,e,i),this.structure.signals.refreshed.add(function(){this.__forceNewMolsurf=!0},this)}function Qs(t,e,i){Ya.call(this,t,e,i)}function Js(t,e,i,n,r,o,a){var s=a||{},c=t.length/3-1,u=4*c,h=3*u;this.meshPosition=new Float32Array(h),this.meshColor=new Float32Array(h),this.meshNormal=new Float32Array(h),this.meshPickingColor=o?new Float32Array(h):void 0;var l=this.meshPosition.length/3>65535?Uint32Array:Uint16Array;this.meshIndex=new l(h),this.makeIndex(),ba.call(this,this.meshPosition,this.meshColor,this.meshIndex,this.meshNormal,this.meshPickingColor,s),this.vertexShader="Ribbon.vert",this.fragmentShader="Mesh.frag",this.geometry.addAttribute("dir",new Kt(new Float32Array(h),3)),this.geometry.addAttribute("size",new Kt(new Float32Array(u),1)),this.setAttributes({position:t,normal:e,dir:i,color:n,size:r,pickingColor:o})}function tc(t,e,i){Ya.call(this,t,e,i),this.defaultScale.sstruc*=3}function ec(t,e,i){this.helixbundleList=[],Ya.call(this,t,e,i)}function ic(t,e,i){Ps.call(this,t,e,i)}function nc(t,e,i){Ya.call(this,t,e,i)}function rc(t,e,i){var n=i||{};this.size=t.length/3,this.vertexShader="Line.vert",this.fragmentShader="Line.frag",this.line=!0;var r=this.size,o=r-1;this.attributeSize=2*o,this.linePosition=new Float32Array(3*o*2),this.lineColor=new Float32Array(3*o*2),ya.call(this,this.linePosition,this.lineColor,void 0,void 0,n),this.setAttributes({position:t,color:e})}function oc(t,e,i){Ya.call(this,t,e,i)}function ac(t,e,i){Ps.call(this,t,e,i)}function sc(t,e,i){Ya.call(this,t,e,i)}function cc(t,e){var i=e||{};this.streamer=t,this.name=d(i.name,""),this.path=d(i.path,"")}function uc(t){function e(t){for(var e=l.atomCount[t],r=l.atomOffset[t],o=new Array(e),a=0;a<e;++a)o[a]=h.atomTypeId[r+a];l.residueTypeId[t]=p.add(i,o,n)}var i,n,r=null,o=null,a=null,s=null,c=null,u=null,h=t.atomStore,l=t.residueStore,d=t.chainStore,f=t.modelStore,p=t.residueMap,m=-1,g=-1,v=-1,y=-1;this.addAtom=function(t,p,b,x,_,w,S,A){var M=!1,C=!1,P=!1;r!==t?(M=!0,C=!0,P=!0,y+=1,v+=1,g+=1):o!==b?(C=!0,P=!0,v+=1,g+=1):s===_&&a===x&&c===A||(P=!0,g+=1),m+=1,M&&(f.growIfFull(),f.chainOffset[y]=v,f.chainCount[y]=0,f.count+=1,d.modelIndex[v]=y),C&&(d.growIfFull(),d.setChainname(v,p),d.setChainid(v,b),d.residueOffset[v]=g,d.residueCount[v]=0,d.count+=1,d.modelIndex[v]=y,f.chainCount[y]+=1,l.chainIndex[g]=v),P&&(i=a,n=u,g>0&&e(g-1),l.growIfFull(),l.resno[g]=_,void 0!==S&&(l.sstruc[g]=S.charCodeAt(0)),void 0!==A&&(l.inscode[g]=A.charCodeAt(0)),l.atomOffset[g]=m,l.atomCount[g]=0,l.count+=1,l.chainIndex[g]=v,d.residueCount[v]+=1),h.count+=1,h.residueIndex[m]=g,l.atomCount[g]+=1,r=t,o=b,a=x,s=_,c=A,u=w},this.finalize=function(){i=a,n=u,g>-1&&e(g)}}function hc(t,e){var i=e||{};this.firstModelOnly=d(i.firstModelOnly,!1),this.asTrajectory=d(i.asTrajectory,!1),this.cAlphaOnly=d(i.cAlphaOnly,!1),cc.call(this,t,i),this.structure=new ea(this.name,this.path),this.structureBuilder=new uc(this.structure)}function lc(t,e,i,n,r,o,a,s){this.a=t||1,this.b=e||1,this.c=i||1,this.alpha=n||90,this.beta=r||90,this.gamma=o||90,this.spacegroup=a||"P 1";var c=wn(this.alpha),u=wn(this.beta),h=wn(this.gamma),l=Math.cos(c),d=Math.cos(u),f=Math.cos(h),p=Math.sin(u),m=Math.sin(h);if(this.volume=this.a*this.b*this.c*Math.sqrt(1-l*l-d*d-f*f+2*l*d*f),void 0===s){var g=this.a*this.b*m/this.volume,v=(d*f-l)/(p*m);this.fracToCart=(new O).set(this.a,0,0,0,this.b*f,this.b*m,0,0,this.c*d,-this.c*p*v,1/g,0,0,0,0,1).transpose(),this.cartToFrac=(new O).getInverse(this.fracToCart)}else this.cartToFrac=s,this.fracToCart=(new O).getInverse(this.cartToFrac)}function dc(t,e){hc.call(this,t,e)}function fc(t){switch(t=t.toLowerCase()){case"polymer":return Bp;case"non-polymer":return Up;case"macrolide":return jp;case"water":return $p;default:return zp}}function pc(t,e,i,n,r){this.structure=t,this.index=e,this.description=i||"",this.entityType=fc(n||""),this.chainIndexList=r||[],r.forEach(function(i){t.chainStore.entityIndex[i]=e})}function mc(t,e){hc.call(this,t,e)}function gc(t,e){hc.call(this,t,e)}function vc(t,e){Array.isArray(t[e])||Object.keys(t).forEach(function(e){t[e]=[t[e]]})}function yc(t){return"?"!==t}function bc(t,e){return yc(t)?t:e}function xc(t){switch(t.toLowerCase()){case"?":case"sing":return 1;case"doub":return 2;case"trip":return 3;case"quad":return 4}return 0}function _c(t,e,i){var n,r,o=e.atomStore,a=e.atomMap,s=t.chem_comp,c=t.chem_comp_atom,u=t.chem_comp_bond;s&&(s.name&&(e.title=s.name.trim().replace(Zv,"")),s.id&&(e.id=s.id.trim().replace(Zv,"")));var h={};if(c){var l,d,f,p;for(r=c.comp_id.length,n=0;n<r;++n)o.growIfFull(),l=c.atom_id[n].replace(Yv,""),d=c.type_symbol[n],h[l]=n,o.atomTypeId[n]=a.add(l,d),o.x[n]=c.model_Cartn_x[n],o.y[n]=c.model_Cartn_y[n],o.z[n]=c.model_Cartn_z[n],o.serial[n]=n,f=c.pdbx_component_comp_id[n],p=c.pdbx_residue_numbering?c.pdbx_residue_numbering[n]:1,i.addAtom(0,"","",f,p,1);for(n=0;n<r;++n){var m=n+r;o.growIfFull(),l=c.atom_id[n].replace(Yv,""),d=c.type_symbol[n],o.atomTypeId[m]=a.add(l,d),o.x[m]=c.pdbx_model_Cartn_x_ideal[n],o.y[m]=c.pdbx_model_Cartn_y_ideal[n],o.z[m]=c.pdbx_model_Cartn_z_ideal[n],o.serial[m]=m,f=c.pdbx_component_comp_id[n],p=c.pdbx_residue_numbering?c.pdbx_residue_numbering[n]:1,i.addAtom(1,"","",f,p,1)}}if(c&&u){var g,v,y;r=u.comp_id.length;var b=c.comp_id.length,x=e.getAtomProxy(),_=e.getAtomProxy();for(n=0;n<r;++n)g=u.atom_id_1[n].replace(Yv,""),v=u.atom_id_2[n].replace(Yv,""),y=xc(u.value_order[n]),x.index=h[g],_.index=h[v],e.bondStore.growIfFull(),e.bondStore.addBond(x,_,y),x.index+=b,_.index+=b,e.bondStore.growIfFull(),e.bondStore.addBond(x,_,y)}}function wc(t,e,i){var n,r,o,a,s=[],c=[],u=t.struct_conf;if(u)for(vc(u,"id"),n=0,r=u.beg_auth_seq_id.length;n<r;++n){var h=parseInt(u.pdbx_PDB_helix_class[n]);Number.isNaN(h)||(o=u.pdbx_beg_PDB_ins_code[n],a=u.pdbx_end_PDB_ins_code[n],s.push([i[u.beg_label_asym_id[n]],parseInt(u.beg_auth_seq_id[n]),bc(o,""),i[u.end_label_asym_id[n]],parseInt(u.end_auth_seq_id[n]),bc(a,""),(Wv[h]||Wv[""]).charCodeAt(0)]))}var l=t.struct_sheet_range;if(l)for(vc(l,"id"),n=0,r=l.beg_auth_seq_id.length;n<r;++n)o=l.pdbx_beg_PDB_ins_code[n],a=l.pdbx_end_PDB_ins_code[n],c.push([i[l.beg_label_asym_id[n]],parseInt(l.beg_auth_seq_id[n]),bc(o,""),i[l.end_label_asym_id[n]],parseInt(l.end_auth_seq_id[n]),bc(a,"")]);return!(!u&&!l)&&{helices:s,sheets:c}}function Sc(t,e,i){var n={},r=e.biomolDict;if(t.pdbx_struct_oper_list){var o=t.pdbx_struct_oper_list;vc(o,"id"),o.id.forEach(function(t,e){var i=new O,r=i.elements;r[0]=parseFloat(o["matrix[1][1]"][e]),r[1]=parseFloat(o["matrix[1][2]"][e]),r[2]=parseFloat(o["matrix[1][3]"][e]),r[4]=parseFloat(o["matrix[2][1]"][e]),r[5]=parseFloat(o["matrix[2][2]"][e]),r[6]=parseFloat(o["matrix[2][3]"][e]),r[8]=parseFloat(o["matrix[3][1]"][e]),r[9]=parseFloat(o["matrix[3][2]"][e]),r[10]=parseFloat(o["matrix[3][3]"][e]),r[3]=parseFloat(o["vector[1]"][e]),r[7]=parseFloat(o["vector[2]"][e]),r[11]=parseFloat(o["vector[3]"][e]),i.transpose(),n[t]=i})}if(t.pdbx_struct_assembly_gen){var a=t.pdbx_struct_assembly_gen;vc(a,"assembly_id");var s=function(t){var e={},i=t.replace(/[\(\)']/g,"").split(",");return i.forEach(function(t){if(t.includes("-"))for(var i=t.split("-"),r=parseInt(i[0]),o=parseInt(i[1]);r<=o;++r)e[r]=n[r];else e[t]=n[t]}),e};a.assembly_id.forEach(function(t,e){var n={},o=a.oper_expression[e].replace(/'\(|'/g,"");if(o.includes(")(")||o.indexOf("(")>0){o=o.split("(");var c=s(o[0]),u=s(o[1]);Object.keys(c).forEach(function(t){Object.keys(u).forEach(function(e){var i=new O;i.multiplyMatrices(c[t],u[e]),n[t+"x"+e]=i})})}else n=s(o);var h=[];for(var l in n)h.push(n[l]);var d=t;/^(0|[1-9][0-9]*)$/.test(d)&&(d="BU"+d);for(var f=a.asym_id_list[e].split(","),p=0,m=f.length;p<m;++p)f[p]=i[f[p]];void 0===r[d]&&(r[d]=new Do(d)),r[d].addPart(h,f)})}if(t.struct_ncs_oper){var c=t.struct_ncs_oper;vc(c,"id");var u="NCS";r[u]=new Do(u);var h=r[u].addPart();c.id.forEach(function(t,e){if("given"!==c.code[e]){var i=new O,n=i.elements;n[0]=parseFloat(c["matrix[1][1]"][e]),n[1]=parseFloat(c["matrix[1][2]"][e]),n[2]=parseFloat(c["matrix[1][3]"][e]),n[4]=parseFloat(c["matrix[2][1]"][e]),n[5]=parseFloat(c["matrix[2][2]"][e]),n[6]=parseFloat(c["matrix[2][3]"][e]),n[8]=parseFloat(c["matrix[3][1]"][e]),n[9]=parseFloat(c["matrix[3][2]"][e]),n[10]=parseFloat(c["matrix[3][3]"][e]),n[3]=parseFloat(c["vector[1]"][e]),n[7]=parseFloat(c["vector[2]"][e]),n[11]=parseFloat(c["vector[3]"][e]),i.transpose(),h.matrixList.push(i)}}),0===h.matrixList.length&&delete r[u]}var l={};if(t.cell){var d=t.cell,f=parseFloat(d.length_a),p=parseFloat(d.length_b),m=parseFloat(d.length_c),g=new Float32Array(9);g[0]=f,g[4]=p,g[8]=m,e.boxes.push(g),l.a=f,l.b=p,l.c=m,l.alpha=parseFloat(d.angle_alpha),l.beta=parseFloat(d.angle_beta),l.gamma=parseFloat(d.angle_gamma)}if(t.symmetry){var v=t.symmetry,y=v["space_group_name_H-M"];y[0]!==y[y.length-1]||"'"!==y[0]&&'"'!==y[0]||(y=y.substring(1,y.length-1)),l.spacegroup=y}var b=new O;if(t.database_PDB_matrix){var x=t.database_PDB_matrix,_=b.elements;_[0]=parseFloat(x["origx[1][1]"]),_[1]=parseFloat(x["origx[1][2]"]),_[2]=parseFloat(x["origx[1][3]"]),_[4]=parseFloat(x["origx[2][1]"]),_[5]=parseFloat(x["origx[2][2]"]),_[6]=parseFloat(x["origx[2][3]"]),_[8]=parseFloat(x["origx[3][1]"]),_[9]=parseFloat(x["origx[3][2]"]),
	_[10]=parseFloat(x["origx[3][3]"]),_[3]=parseFloat(x["origx_vector[1]"]),_[7]=parseFloat(x["origx_vector[2]"]),_[11]=parseFloat(x["origx_vector[3]"]),b.transpose(),l.origx=b}var w=new O;if(t.atom_sites){var S=t.atom_sites,A=w.elements;A[0]=parseFloat(S["fract_transf_matrix[1][1]"]),A[1]=parseFloat(S["fract_transf_matrix[1][2]"]),A[2]=parseFloat(S["fract_transf_matrix[1][3]"]),A[4]=parseFloat(S["fract_transf_matrix[2][1]"]),A[5]=parseFloat(S["fract_transf_matrix[2][2]"]),A[6]=parseFloat(S["fract_transf_matrix[2][3]"]),A[8]=parseFloat(S["fract_transf_matrix[3][1]"]),A[9]=parseFloat(S["fract_transf_matrix[3][2]"]),A[10]=parseFloat(S["fract_transf_matrix[3][3]"]),A[3]=parseFloat(S["fract_transf_vector[1]"]),A[7]=parseFloat(S["fract_transf_vector[2]"]),A[11]=parseFloat(S["fract_transf_vector[3]"]),w.transpose(),l.scale=w}void 0!==l.a?e.unitcell=new lc(l.a,l.b,l.c,l.alpha,l.beta,l.gamma,l.spacegroup,l.scale):e.unitcell=void 0}function Ac(t,e,i){var n=t.struct_conn;if(n){vc(n,"id");for(var r=/"/g,o=e.getAtomProxy(),a=e.getAtomProxy(),s={},c=0,u=n.id.length;c<u;++c){var h=n.conn_type_id[c];if("hydrog"!==h&&"mismat"!==h&&"saltbr"!==h&&"1_555"===n.ptnr1_symmetry[c]&&"1_555"===n.ptnr2_symmetry[c]){var l=n.pdbx_ptnr1_PDB_ins_code[c],d=n.pdbx_ptnr1_label_alt_id[c],f=n.ptnr1_auth_seq_id[c]+(yc(l)?"^"+l:"")+":"+i[n.ptnr1_label_asym_id[c]]+"."+n.ptnr1_label_atom_id[c].replace(r,"")+(yc(d)?"%"+d:""),p=s[f];if(!p){var m=new _n(f);if(m.selection.error){uv.warn("invalid selection for connection",f);continue}p=e.getAtomIndices(m),s[f]=p}var g=n.pdbx_ptnr2_PDB_ins_code[c],v=n.pdbx_ptnr2_label_alt_id[c],y=n.ptnr2_auth_seq_id[c]+(yc(g)?"^"+g:"")+":"+i[n.ptnr2_label_asym_id[c]]+"."+n.ptnr2_label_atom_id[c].replace(r,"")+(yc(v)?"%"+v:""),b=s[y];if(!b){var x=new _n(y);if(x.selection.error){uv.warn("invalid selection for connection",y);continue}b=e.getAtomIndices(x),s[y]=b}var _=p.length,w=b.length;if(_>w){var S=_;_=w,w=S;var A=p;p=b,b=A}if(0!==_&&0!==w)for(var M=0;M<w;++M)o.index=p[M%_],a.index=b[M],o&&a?e.bondStore.addBond(o,a,xc(n.pdbx_value_order[c])):uv.log("atoms for connection not found");else uv.warn("no atoms found for",f,y)}}}}function Mc(t,e,i){if(t.entity){vc(t.entity,"id");for(var n=t.entity,r=n.id.length,o=0;o<r;++o){var a=n.pdbx_description[o],s=n.type[o],c=Array.from(i[n.id[o]]);e.entityList[o]=new pc(e,o,a,s,c)}}}function Cc(t,e){hc.call(this,t,e)}function Pc(t,e){hc.call(this,t,e)}function Tc(t,e){hc.call(this,t,e)}function Ec(t,e,i){return e?new t(e.buffer,e.byteOffset,e.byteLength/(i||1)):void 0}function Ic(t){return Ec(DataView,t)}function Lc(t){return Ec(Uint8Array,t)}function Rc(t){return Ec(Int8Array,t)}function Oc(t){return Ec(Int32Array,t,4)}function Dc(t){return Ec(Float32Array,t,4)}function Nc(t,e){var i=t.length/2;e||(e=new Int16Array(i));for(var n=0,r=0;n<i;++n,r+=2)e[n]=t[r]<<8^t[r+1]<<0;return e}function kc(t,e){var i=t.length/4;e||(e=new Int32Array(i));for(var n=0,r=0;n<i;++n,r+=4)e[n]=t[r]<<24^t[r+1]<<16^t[r+2]<<8^t[r+3]<<0;return e}function Fc(t,e){var i=t.length;e||(e=new Float32Array(i/4));for(var n=Ic(e),r=Ic(t),o=0,a=0,s=i/4;o<s;++o,a+=4)n.setFloat32(a,r.getFloat32(a),!0);return e}function zc(t,e,i){var n=t.length,r=1/e;i||(i=new Float32Array(n));for(var o=0;o<n;++o)i[o]=t[o]*r;return i}function Bc(t,e){var i,n;if(!e){var r=0;for(i=0,n=t.length;i<n;i+=2)r+=t[i+1];e=new t.constructor(r)}var o=0;for(i=0,n=t.length;i<n;i+=2)for(var a=t[i],s=t[i+1],c=0;c<s;++c)e[o]=a,++o;return e}function Uc(t,e){var i=t.length;e||(e=new t.constructor(i)),i&&(e[0]=t[0]);for(var n=1;n<i;++n)e[n]=t[n]+e[n-1];return e}function jc(t,e){var i,n,r=t instanceof Int8Array?127:32767,o=-r-1,a=t.length;if(!e){var s=0;for(i=0;i<a;++i)t[i]<r&&t[i]>o&&++s;e=new Int32Array(s)}for(i=0,n=0;i<a;){for(var c=0;t[i]===r||t[i]===o;)c+=t[i],++i;c+=t[i],++i,e[n]=c,++n}return e}function $c(t,e){return Uc(Bc(t),e)}function Vc(t,e,i){return zc(Bc(t,Oc(i)),e,i)}function Gc(t,e,i){return zc(Uc(t,Oc(i)),e,i)}function Hc(t,e,i){return zc(jc(t,Oc(i)),e,i)}function Wc(t,e,i){var n=jc(t,Oc(i));return Gc(n,e,Dc(n))}function Xc(t){var e=Ic(t),i=e.getInt32(0),n=e.getInt32(4),r=t.subarray(8,12),t=t.subarray(12);return[i,t,n,r]}function qc(t){function e(t){for(var e={},i=0;i<t;i++){var n=o();e[n]=o()}return e}function i(e){var i=t.subarray(a,a+e);return a+=e,i}function n(e){var i=t.subarray(a,a+e);a+=e;var n=65535;if(e>n){for(var r=[],o=0;o<i.length;o+=n)r.push(String.fromCharCode.apply(null,i.subarray(o,o+n)));return r.join("")}return String.fromCharCode.apply(null,i)}function r(t){for(var e=new Array(t),i=0;i<t;i++)e[i]=o();return e}function o(){var o,c,u=t[a];if(0===(128&u))return a++,u;if(128===(240&u))return c=15&u,a++,e(c);if(144===(240&u))return c=15&u,a++,r(c);if(160===(224&u))return c=31&u,a++,n(c);if(224===(224&u))return o=s.getInt8(a),a++,o;switch(u){case 192:return a++,null;case 194:return a++,!1;case 195:return a++,!0;case 196:return c=s.getUint8(a+1),a+=2,i(c);case 197:return c=s.getUint16(a+1),a+=3,i(c);case 198:return c=s.getUint32(a+1),a+=5,i(c);case 202:return o=s.getFloat32(a+1),a+=5,o;case 203:return o=s.getFloat64(a+1),a+=9,o;case 204:return o=t[a+1],a+=2,o;case 205:return o=s.getUint16(a+1),a+=3,o;case 206:return o=s.getUint32(a+1),a+=5,o;case 208:return o=s.getInt8(a+1),a+=2,o;case 209:return o=s.getInt16(a+1),a+=3,o;case 210:return o=s.getInt32(a+1),a+=5,o;case 217:return c=s.getUint8(a+1),a+=2,n(c);case 218:return c=s.getUint16(a+1),a+=3,n(c);case 219:return c=s.getUint32(a+1),a+=5,n(c);case 220:return c=s.getUint16(a+1),a+=3,r(c);case 221:return c=s.getUint32(a+1),a+=5,r(c);case 222:return c=s.getUint16(a+1),a+=3,e(c);case 223:return c=s.getUint32(a+1),a+=5,e(c)}throw new Error("Unknown type 0x"+u.toString(16))}var a=0,s=new DataView(t.buffer);return o()}function Yc(t,e,i,n){switch(t){case 1:return Fc(e);case 2:return Rc(e);case 3:return Nc(e);case 4:return kc(e);case 5:return Lc(e);case 6:return Bc(kc(e),new Uint8Array(i));case 7:return Bc(kc(e));case 8:return $c(kc(e));case 9:return Vc(kc(e),kc(n)[0]);case 10:return Wc(Nc(e),kc(n)[0]);case 11:return zc(Nc(e),kc(n)[0]);case 12:return Hc(Nc(e),kc(n)[0]);case 13:return Hc(Rc(e),kc(n)[0]);case 14:return jc(Nc(e));case 15:return jc(Rc(e))}}function Zc(t,e){e=e||{};var i=e.ignoreFields,n={};return Jv.forEach(function(e){var r=!!i&&i.indexOf(e)!==-1,o=t[e];r||void 0===o||(o instanceof Uint8Array?n[e]=Yc.apply(null,Xc(o)):n[e]=o)}),n}function Kc(t,e){hc.call(this,t,e)}function Qc(t,e){this.name=t,this.path=e,this.coordinates=[],this.boxes=[]}function Jc(t,e){cc.call(this,t,e),this.frames=new Qc(this.name,this.path)}function tu(t,e){Jc.call(this,t,e)}function eu(t,e){cc.call(this,t,e),this.volume=new fa(this.name,this.path)}function iu(t,e){eu.call(this,t,e)}function nu(t,e){eu.call(this,t,e)}function ru(t,e){eu.call(this,t,e)}function ou(t,e){ru.call(this,t,e)}function au(t,e){eu.call(this,t,e)}function su(t,e){cc.call(this,t,e),this.loader=void 0,this.surface=new ia(this.name,this.path)}function cu(){this.propertyNameMapping={}}function uu(t,e){su.call(this,t,e),this.loader=new cu}function hu(){this.regexp={vertex_pattern:/^v\s+([\d|\.|\+|\-|e|E]+)\s+([\d|\.|\+|\-|e|E]+)\s+([\d|\.|\+|\-|e|E]+)/,normal_pattern:/^vn\s+([\d|\.|\+|\-|e|E]+)\s+([\d|\.|\+|\-|e|E]+)\s+([\d|\.|\+|\-|e|E]+)/,uv_pattern:/^vt\s+([\d|\.|\+|\-|e|E]+)\s+([\d|\.|\+|\-|e|E]+)/,face_vertex:/^f\s+(-?\d+)\s+(-?\d+)\s+(-?\d+)(?:\s+(-?\d+))?/,face_vertex_uv:/^f\s+(-?\d+)\/(-?\d+)\s+(-?\d+)\/(-?\d+)\s+(-?\d+)\/(-?\d+)(?:\s+(-?\d+)\/(-?\d+))?/,face_vertex_uv_normal:/^f\s+(-?\d+)\/(-?\d+)\/(-?\d+)\s+(-?\d+)\/(-?\d+)\/(-?\d+)\s+(-?\d+)\/(-?\d+)\/(-?\d+)(?:\s+(-?\d+)\/(-?\d+)\/(-?\d+))?/,face_vertex_normal:/^f\s+(-?\d+)\/\/(-?\d+)\s+(-?\d+)\/\/(-?\d+)\s+(-?\d+)\/\/(-?\d+)(?:\s+(-?\d+)\/\/(-?\d+))?/,object_pattern:/^[og]\s*(.+)?/,smoothing_pattern:/^s\s+(\d+|on|off)/,material_library_pattern:/^mtllib /,material_use_pattern:/^usemtl /}}function lu(t,e){su.call(this,t,e),this.loader=new hu}function du(t,e){cc.call(this,t,e),this.text={name:this.name,path:this.path,data:""}}function fu(t,e){cc.call(this,t,e),this.table={name:this.name,path:this.path,colNames:[],data:[]}}function pu(t,e){var i=e||{};cc.call(this,t,i),this.string=d(i.string,!1),this.json={name:this.name,path:this.path,data:{}}}function mu(t,e){var i=e||{};this.useDomParser=d(i.useDomParser,!1),cc.call(this,t,i),this.xml={name:this.name,path:this.path,data:{}}}function gu(t){for(var e=Array.prototype.slice.call(arguments,1);e.length;){var i=e.shift();if(i){if("object"!=typeof i)throw new TypeError(i+"must be non-object");for(var n in i)i.hasOwnProperty(n)&&(t[n]=i[n])}}return t}function vu(t,e){return t.length===e?t:t.subarray?t.subarray(0,e):(t.length=e,t)}function yu(t,e,i,n,r){if(e.subarray&&t.subarray)return void t.set(e.subarray(i,i+n),r);for(var o=0;o<n;o++)t[r+o]=e[i+o]}function bu(t){var e,i,n,r,o,a;for(n=0,e=0,i=t.length;e<i;e++)n+=t[e].length;for(a=new Uint8Array(n),r=0,e=0,i=t.length;e<i;e++)o=t[e],a.set(o,r),r+=o.length;return a}function xu(t,e,i,n){for(var r=65535&t|0,o=t>>>16&65535|0,a=0;0!==i;){a=i>2e3?2e3:i,i-=a;do r=r+e[n++]|0,o=o+r|0;while(--a);r%=65521,o%=65521}return r|o<<16|0}function _u(){for(var t,e=[],i=0;i<256;i++){t=i;for(var n=0;n<8;n++)t=1&t?3988292384^t>>>1:t>>>1;e[i]=t}return e}function wu(t,e,i,n){var r=ny,o=n+i;t^=-1;for(var a=n;a<o;a++)t=t>>>8^r[255&(t^e[a])];return t^-1}function Su(t,e){var i,n,r,o,a,s,c,u,h,l,d,f,p,m,g,v,y,b,x,_,w,S,A,M,C;i=t.state,n=t.next_in,M=t.input,r=n+(t.avail_in-5),o=t.next_out,C=t.output,a=o-(e-t.avail_out),s=o+(t.avail_out-257),c=i.dmax,u=i.wsize,h=i.whave,l=i.wnext,d=i.window,f=i.hold,p=i.bits,m=i.lencode,g=i.distcode,v=(1<<i.lenbits)-1,y=(1<<i.distbits)-1;t:do{p<15&&(f+=M[n++]<<p,p+=8,f+=M[n++]<<p,p+=8),b=m[f&v];e:for(;;){if(x=b>>>24,f>>>=x,p-=x,x=b>>>16&255,0===x)C[o++]=65535&b;else{if(!(16&x)){if(0===(64&x)){b=m[(65535&b)+(f&(1<<x)-1)];continue e}if(32&x){i.mode=oy;break t}t.msg="invalid literal/length code",i.mode=ry;break t}_=65535&b,x&=15,x&&(p<x&&(f+=M[n++]<<p,p+=8),_+=f&(1<<x)-1,f>>>=x,p-=x),p<15&&(f+=M[n++]<<p,p+=8,f+=M[n++]<<p,p+=8),b=g[f&y];i:for(;;){if(x=b>>>24,f>>>=x,p-=x,x=b>>>16&255,!(16&x)){if(0===(64&x)){b=g[(65535&b)+(f&(1<<x)-1)];continue i}t.msg="invalid distance code",i.mode=ry;break t}if(w=65535&b,x&=15,p<x&&(f+=M[n++]<<p,p+=8,p<x&&(f+=M[n++]<<p,p+=8)),w+=f&(1<<x)-1,w>c){t.msg="invalid distance too far back",i.mode=ry;break t}if(f>>>=x,p-=x,x=o-a,w>x){if(x=w-x,x>h&&i.sane){t.msg="invalid distance too far back",i.mode=ry;break t}if(S=0,A=d,0===l){if(S+=u-x,x<_){_-=x;do C[o++]=d[S++];while(--x);S=o-w,A=C}}else if(l<x){if(S+=u+l-x,x-=l,x<_){_-=x;do C[o++]=d[S++];while(--x);if(S=0,l<_){x=l,_-=x;do C[o++]=d[S++];while(--x);S=o-w,A=C}}}else if(S+=l-x,x<_){_-=x;do C[o++]=d[S++];while(--x);S=o-w,A=C}for(;_>2;)C[o++]=A[S++],C[o++]=A[S++],C[o++]=A[S++],_-=3;_&&(C[o++]=A[S++],_>1&&(C[o++]=A[S++]))}else{S=o-w;do C[o++]=C[S++],C[o++]=C[S++],C[o++]=C[S++],_-=3;while(_>2);_&&(C[o++]=C[S++],_>1&&(C[o++]=C[S++]))}break}}break}}while(n<r&&o<s);_=p>>3,n-=_,p-=_<<3,f&=(1<<p)-1,t.next_in=n,t.next_out=o,t.avail_in=n<r?5+(r-n):5-(n-r),t.avail_out=o<s?257+(s-o):257-(o-s),i.hold=f,i.bits=p}function Au(t,e,i,n,r,o,a,s){var c,u,h,l,d,f,p,m,g,v=s.bits,y=0,b=0,x=0,_=0,w=0,S=0,A=0,M=0,C=0,P=0,T=null,E=0,I=new Uint16Array(ay+1),L=new Uint16Array(ay+1),R=null,O=0;for(y=0;y<=ay;y++)I[y]=0;for(b=0;b<n;b++)I[e[i+b]]++;for(w=v,_=ay;_>=1&&0===I[_];_--);if(w>_&&(w=_),0===_)return r[o++]=20971520,r[o++]=20971520,s.bits=1,0;for(x=1;x<_&&0===I[x];x++);for(w<x&&(w=x),M=1,y=1;y<=ay;y++)if(M<<=1,M-=I[y],M<0)return-1;if(M>0&&(t===uy||1!==_))return-1;for(L[1]=0,y=1;y<ay;y++)L[y+1]=L[y]+I[y];for(b=0;b<n;b++)0!==e[i+b]&&(a[L[e[i+b]]++]=b);if(t===uy?(T=R=a,f=19):t===hy?(T=dy,E-=257,R=fy,O-=257,f=256):(T=py,R=my,f=-1),P=0,b=0,y=x,d=o,S=w,A=0,h=-1,C=1<<w,l=C-1,t===hy&&C>sy||t===ly&&C>cy)return 1;for(var D=0;;){D++,p=y-A,a[b]<f?(m=0,g=a[b]):a[b]>f?(m=R[O+a[b]],g=T[E+a[b]]):(m=96,g=0),c=1<<y-A,u=1<<S,x=u;do u-=c,r[d+(P>>A)+u]=p<<24|m<<16|g|0;while(0!==u);for(c=1<<y-1;P&c;)c>>=1;if(0!==c?(P&=c-1,P+=c):P=0,b++,0===--I[y]){if(y===_)break;y=e[i+a[b]]}if(y>w&&(P&l)!==h){for(0===A&&(A=w),d+=x,S=y-A,M=1<<S;S+A<_&&(M-=I[S+A],!(M<=0));)S++,M<<=1;if(C+=1<<S,t===hy&&C>sy||t===ly&&C>cy)return 1;h=P&l,r[h]=w<<24|S<<16|d-o|0}}return 0!==P&&(r[d+P]=y-A<<24|64<<16|0),s.bits=w,0}function Mu(t){return(t>>>24&255)+(t>>>8&65280)+((65280&t)<<8)+((255&t)<<24)}function Cu(){this.mode=0,this.last=!1,this.wrap=0,this.havedict=!1,this.flags=0,this.dmax=0,this.check=0,this.total=0,this.head=null,this.wbits=0,this.wsize=0,this.whave=0,this.wnext=0,this.window=null,this.hold=0,this.bits=0,this.length=0,this.offset=0,this.extra=0,this.lencode=null,this.distcode=null,this.lenbits=0,this.distbits=0,this.ncode=0,this.nlen=0,this.ndist=0,this.have=0,this.next=null,this.lens=new Uint16Array(320),this.work=new Uint16Array(288),this.lendyn=null,this.distdyn=null,this.sane=0,this.back=0,this.was=0}function Pu(t){var e;return t&&t.state?(e=t.state,t.total_in=t.total_out=e.total=0,t.msg="",e.wrap&&(t.adler=1&e.wrap),e.mode=Iy,e.last=0,e.havedict=0,e.dmax=32768,e.head=null,e.hold=0,e.bits=0,e.lencode=e.lendyn=new Int32Array(cb),e.distcode=e.distdyn=new Int32Array(ub),e.sane=1,e.back=-1,wy):My}function Tu(t){var e;return t&&t.state?(e=t.state,e.wsize=0,e.whave=0,e.wnext=0,Pu(t)):My}function Eu(t,e){var i,n;return t&&t.state?(n=t.state,e<0?(i=0,e=-e):(i=(e>>4)+1,e<48&&(e&=15)),e&&(e<8||e>15)?My:(null!==n.window&&n.wbits!==e&&(n.window=null),n.wrap=i,n.wbits=e,Tu(t))):My}function Iu(t,e){var i,n;return t?(n=new Cu,t.state=n,n.window=null,i=Eu(t,e),i!==wy&&(t.state=null),i):My}function Lu(t){if(hb){var e;for(ey=new Int32Array(512),iy=new Int32Array(32),e=0;e<144;)t.lens[e++]=8;for(;e<256;)t.lens[e++]=9;for(;e<280;)t.lens[e++]=7;for(;e<288;)t.lens[e++]=8;for(Au(vy,t.lens,0,288,ey,0,t.work,{bits:9}),e=0;e<32;)t.lens[e++]=5;Au(yy,t.lens,0,32,iy,0,t.work,{bits:5}),hb=!1}t.lencode=ey,t.lenbits=9,t.distcode=iy,t.distbits=5}function Ru(t,e,i,n){var r,o=t.state;return null===o.window&&(o.wsize=1<<o.wbits,o.wnext=0,o.whave=0,o.window=new Uint8Array(o.wsize)),n>=o.wsize?(yu(o.window,e,i-o.wsize,o.wsize,0),o.wnext=0,o.whave=o.wsize):(r=o.wsize-o.wnext,r>n&&(r=n),yu(o.window,e,i-n,r,o.wnext),n-=r,n?(yu(o.window,e,i-n,n,0),o.wnext=n,o.whave=o.wsize):(o.wnext+=r,o.wnext===o.wsize&&(o.wnext=0),o.whave<o.wsize&&(o.whave+=r))),0}function Ou(t,e){var i,n,r,o,a,s,c,u,h,l,d,f,p,m,g,v,y,b,x,_,w,S,A,M,C=0,P=new Uint8Array(4),T=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15];if(!t||!t.state||!t.output||!t.input&&0!==t.avail_in)return My;i=t.state,i.mode===jy&&(i.mode=$y),a=t.next_out,r=t.output,c=t.avail_out,o=t.next_in,n=t.input,s=t.avail_in,u=i.hold,h=i.bits,l=s,d=c,S=wy;t:for(;;)switch(i.mode){case Iy:if(0===i.wrap){i.mode=$y;break}for(;h<16;){if(0===s)break t;s--,u+=n[o++]<<h,h+=8}if(2&i.wrap&&35615===u){i.check=0,P[0]=255&u,P[1]=u>>>8&255,i.check=wu(i.check,P,2,0),u=0,h=0,i.mode=Ly;break}if(i.flags=0,i.head&&(i.head.done=!1),!(1&i.wrap)||(((255&u)<<8)+(u>>8))%31){t.msg="incorrect header check",i.mode=ob;break}if((15&u)!==Ey){t.msg="unknown compression method",i.mode=ob;break}if(u>>>=4,h-=4,w=(15&u)+8,0===i.wbits)i.wbits=w;else if(w>i.wbits){t.msg="invalid window size",i.mode=ob;break}i.dmax=1<<w,t.adler=i.check=1,i.mode=512&u?By:jy,u=0,h=0;break;case Ly:for(;h<16;){if(0===s)break t;s--,u+=n[o++]<<h,h+=8}if(i.flags=u,(255&i.flags)!==Ey){t.msg="unknown compression method",i.mode=ob;break}if(57344&i.flags){t.msg="unknown header flags set",i.mode=ob;break}i.head&&(i.head.text=u>>8&1),512&i.flags&&(P[0]=255&u,P[1]=u>>>8&255,i.check=wu(i.check,P,2,0)),u=0,h=0,i.mode=Ry;case Ry:for(;h<32;){if(0===s)break t;s--,u+=n[o++]<<h,h+=8}i.head&&(i.head.time=u),512&i.flags&&(P[0]=255&u,P[1]=u>>>8&255,P[2]=u>>>16&255,P[3]=u>>>24&255,i.check=wu(i.check,P,4,0)),u=0,h=0,i.mode=Oy;case Oy:for(;h<16;){if(0===s)break t;s--,u+=n[o++]<<h,h+=8}i.head&&(i.head.xflags=255&u,i.head.os=u>>8),512&i.flags&&(P[0]=255&u,P[1]=u>>>8&255,i.check=wu(i.check,P,2,0)),u=0,h=0,i.mode=Dy;case Dy:if(1024&i.flags){for(;h<16;){if(0===s)break t;s--,u+=n[o++]<<h,h+=8}i.length=u,i.head&&(i.head.extra_len=u),512&i.flags&&(P[0]=255&u,P[1]=u>>>8&255,i.check=wu(i.check,P,2,0)),u=0,h=0}else i.head&&(i.head.extra=null);i.mode=Ny;case Ny:if(1024&i.flags&&(f=i.length,f>s&&(f=s),f&&(i.head&&(w=i.head.extra_len-i.length,i.head.extra||(i.head.extra=new Array(i.head.extra_len)),yu(i.head.extra,n,o,f,w)),512&i.flags&&(i.check=wu(i.check,n,f,o)),s-=f,o+=f,i.length-=f),i.length))break t;i.length=0,i.mode=ky;case ky:if(2048&i.flags){if(0===s)break t;f=0;do w=n[o+f++],i.head&&w&&i.length<65536&&(i.head.name+=String.fromCharCode(w));while(w&&f<s);if(512&i.flags&&(i.check=wu(i.check,n,f,o)),s-=f,o+=f,w)break t}else i.head&&(i.head.name=null);i.length=0,i.mode=Fy;case Fy:if(4096&i.flags){if(0===s)break t;f=0;do w=n[o+f++],i.head&&w&&i.length<65536&&(i.head.comment+=String.fromCharCode(w));while(w&&f<s);if(512&i.flags&&(i.check=wu(i.check,n,f,o)),s-=f,o+=f,w)break t}else i.head&&(i.head.comment=null);i.mode=zy;case zy:if(512&i.flags){for(;h<16;){if(0===s)break t;s--,u+=n[o++]<<h,h+=8}if(u!==(65535&i.check)){t.msg="header crc mismatch",i.mode=ob;break}u=0,h=0}i.head&&(i.head.hcrc=i.flags>>9&1,i.head.done=!0),t.adler=i.check=0,i.mode=jy;break;case By:for(;h<32;){if(0===s)break t;s--,u+=n[o++]<<h,h+=8}t.adler=i.check=Mu(u),u=0,h=0,i.mode=Uy;case Uy:if(0===i.havedict)return t.next_out=a,t.avail_out=c,t.next_in=o,t.avail_in=s,i.hold=u,i.bits=h,Ay;t.adler=i.check=1,i.mode=jy;case jy:if(e===xy||e===_y)break t;case $y:if(i.last){u>>>=7&h,h-=7&h,i.mode=ib;break}for(;h<3;){if(0===s)break t;s--,u+=n[o++]<<h,h+=8}switch(i.last=1&u,u>>>=1,h-=1,3&u){case 0:i.mode=Vy;break;case 1:if(Lu(i),i.mode=Yy,e===_y){u>>>=2,h-=2;break t}break;case 2:i.mode=Wy;break;case 3:t.msg="invalid block type",i.mode=ob}u>>>=2,h-=2;break;case Vy:for(u>>>=7&h,h-=7&h;h<32;){if(0===s)break t;s--,u+=n[o++]<<h,h+=8}if((65535&u)!==(u>>>16^65535)){t.msg="invalid stored block lengths",i.mode=ob;break}if(i.length=65535&u,u=0,h=0,i.mode=Gy,e===_y)break t;case Gy:i.mode=Hy;case Hy:if(f=i.length){if(f>s&&(f=s),f>c&&(f=c),0===f)break t;yu(r,n,o,f,a),s-=f,o+=f,c-=f,a+=f,i.length-=f;break}i.mode=jy;break;case Wy:for(;h<14;){if(0===s)break t;s--,u+=n[o++]<<h,h+=8}if(i.nlen=(31&u)+257,u>>>=5,h-=5,i.ndist=(31&u)+1,u>>>=5,h-=5,i.ncode=(15&u)+4,u>>>=4,h-=4,i.nlen>286||i.ndist>30){t.msg="too many length or distance symbols",i.mode=ob;break}i.have=0,i.mode=Xy;case Xy:for(;i.have<i.ncode;){for(;h<3;){if(0===s)break t;s--,u+=n[o++]<<h,h+=8}i.lens[T[i.have++]]=7&u,u>>>=3,h-=3}for(;i.have<19;)i.lens[T[i.have++]]=0;if(i.lencode=i.lendyn,i.lenbits=7,A={bits:i.lenbits},S=Au(gy,i.lens,0,19,i.lencode,0,i.work,A),i.lenbits=A.bits,S){t.msg="invalid code lengths set",i.mode=ob;break}i.have=0,i.mode=qy;case qy:for(;i.have<i.nlen+i.ndist;){for(;C=i.lencode[u&(1<<i.lenbits)-1],g=C>>>24,v=C>>>16&255,y=65535&C,!(g<=h);){if(0===s)break t;s--,u+=n[o++]<<h,h+=8}if(y<16)u>>>=g,h-=g,i.lens[i.have++]=y;else{if(16===y){for(M=g+2;h<M;){if(0===s)break t;s--,u+=n[o++]<<h,h+=8}if(u>>>=g,h-=g,0===i.have){t.msg="invalid bit length repeat",i.mode=ob;break}w=i.lens[i.have-1],f=3+(3&u),u>>>=2,h-=2}else if(17===y){for(M=g+3;h<M;){if(0===s)break t;s--,u+=n[o++]<<h,h+=8}u>>>=g,h-=g,w=0,f=3+(7&u),u>>>=3,h-=3}else{for(M=g+7;h<M;){if(0===s)break t;s--,u+=n[o++]<<h,h+=8}u>>>=g,h-=g,w=0,f=11+(127&u),u>>>=7,h-=7}if(i.have+f>i.nlen+i.ndist){t.msg="invalid bit length repeat",i.mode=ob;break}for(;f--;)i.lens[i.have++]=w}}if(i.mode===ob)break;if(0===i.lens[256]){t.msg="invalid code -- missing end-of-block",i.mode=ob;break}if(i.lenbits=9,A={bits:i.lenbits},S=Au(vy,i.lens,0,i.nlen,i.lencode,0,i.work,A),i.lenbits=A.bits,S){t.msg="invalid literal/lengths set",i.mode=ob;break}if(i.distbits=6,i.distcode=i.distdyn,A={bits:i.distbits},S=Au(yy,i.lens,i.nlen,i.ndist,i.distcode,0,i.work,A),i.distbits=A.bits,S){t.msg="invalid distances set",i.mode=ob;break}if(i.mode=Yy,e===_y)break t;case Yy:i.mode=Zy;case Zy:if(s>=6&&c>=258){t.next_out=a,t.avail_out=c,t.next_in=o,t.avail_in=s,i.hold=u,i.bits=h,Su(t,d),a=t.next_out,r=t.output,c=t.avail_out,o=t.next_in,n=t.input,s=t.avail_in,u=i.hold,h=i.bits,i.mode===jy&&(i.back=-1);break}for(i.back=0;C=i.lencode[u&(1<<i.lenbits)-1],g=C>>>24,v=C>>>16&255,y=65535&C,!(g<=h);){if(0===s)break t;s--,u+=n[o++]<<h,h+=8}if(v&&0===(240&v)){for(b=g,x=v,_=y;C=i.lencode[_+((u&(1<<b+x)-1)>>b)],g=C>>>24,v=C>>>16&255,y=65535&C,!(b+g<=h);){if(0===s)break t;s--,u+=n[o++]<<h,h+=8}u>>>=b,h-=b,i.back+=b}if(u>>>=g,h-=g,i.back+=g,i.length=y,0===v){i.mode=eb;break}if(32&v){i.back=-1,i.mode=jy;break}if(64&v){t.msg="invalid literal/length code",i.mode=ob;break}i.extra=15&v,i.mode=Ky;case Ky:if(i.extra){for(M=i.extra;h<M;){if(0===s)break t;s--,u+=n[o++]<<h,h+=8}i.length+=u&(1<<i.extra)-1,u>>>=i.extra,h-=i.extra,i.back+=i.extra}i.was=i.length,i.mode=Qy;case Qy:for(;C=i.distcode[u&(1<<i.distbits)-1],g=C>>>24,v=C>>>16&255,y=65535&C,!(g<=h);){if(0===s)break t;s--,u+=n[o++]<<h,h+=8}if(0===(240&v)){for(b=g,x=v,_=y;C=i.distcode[_+((u&(1<<b+x)-1)>>b)],g=C>>>24,v=C>>>16&255,y=65535&C,!(b+g<=h);){if(0===s)break t;s--,u+=n[o++]<<h,h+=8}u>>>=b,h-=b,i.back+=b}if(u>>>=g,h-=g,i.back+=g,64&v){t.msg="invalid distance code",i.mode=ob;break}i.offset=y,i.extra=15&v,i.mode=Jy;case Jy:if(i.extra){for(M=i.extra;h<M;){if(0===s)break t;s--,u+=n[o++]<<h,h+=8}i.offset+=u&(1<<i.extra)-1,u>>>=i.extra,h-=i.extra,i.back+=i.extra}if(i.offset>i.dmax){t.msg="invalid distance too far back",i.mode=ob;break}i.mode=tb;case tb:if(0===c)break t;if(f=d-c,i.offset>f){if(f=i.offset-f,f>i.whave&&i.sane){t.msg="invalid distance too far back",i.mode=ob;break}f>i.wnext?(f-=i.wnext,p=i.wsize-f):p=i.wnext-f,f>i.length&&(f=i.length),m=i.window}else m=r,p=a-i.offset,f=i.length;f>c&&(f=c),c-=f,i.length-=f;do r[a++]=m[p++];while(--f);0===i.length&&(i.mode=Zy);break;case eb:if(0===c)break t;r[a++]=i.length,c--,i.mode=Zy;break;case ib:if(i.wrap){for(;h<32;){if(0===s)break t;s--,u|=n[o++]<<h,h+=8}if(d-=c,t.total_out+=d,i.total+=d,d&&(t.adler=i.check=i.flags?wu(i.check,r,d,a-d):xu(i.check,r,d,a-d)),d=c,(i.flags?u:Mu(u))!==i.check){t.msg="incorrect data check",i.mode=ob;break}u=0,h=0}i.mode=nb;case nb:if(i.wrap&&i.flags){for(;h<32;){if(0===s)break t;s--,u+=n[o++]<<h,h+=8}if(u!==(4294967295&i.total)){t.msg="incorrect length check",i.mode=ob;break}u=0,h=0}i.mode=rb;case rb:S=Sy;break t;case ob:S=Cy;break t;case ab:return Py;case sb:default:return My}return t.next_out=a,t.avail_out=c,t.next_in=o,t.avail_in=s,i.hold=u,i.bits=h,(i.wsize||d!==t.avail_out&&i.mode<ob&&(i.mode<ib||e!==by))&&Ru(t,t.output,t.next_out,d-t.avail_out)?(i.mode=ab,Py):(l-=t.avail_in,d-=t.avail_out,t.total_in+=l,t.total_out+=d,i.total+=d,i.wrap&&d&&(t.adler=i.check=i.flags?wu(i.check,r,d,t.next_out-d):xu(i.check,r,d,t.next_out-d)),t.data_type=i.bits+(i.last?64:0)+(i.mode===jy?128:0)+(i.mode===Yy||i.mode===Gy?256:0),(0===l&&0===d||e===by)&&S===wy&&(S=Ty),S)}function Du(t){if(!t||!t.state)return My;var e=t.state;return e.window&&(e.window=null),t.state=null,wy}function Nu(t,e){var i;return t&&t.state?(i=t.state,0===(2&i.wrap)?My:(i.head=e,e.done=!1,wy)):My}function ku(t,e){var i,n,r,o=e.length;return t&&t.state?(i=t.state,0!==i.wrap&&i.mode!==Uy?My:i.mode===Uy&&(n=1,n=xu(n,e,o,0),n!==i.check)?Cy:(r=Ru(t,e,o,o))?(i.mode=ab,Py):(i.havedict=1,wy)):My}function Fu(t){var e,i,n,r,o,a=t.length,s=0;for(r=0;r<a;r++)i=t.charCodeAt(r),55296===(64512&i)&&r+1<a&&(n=t.charCodeAt(r+1),56320===(64512&n)&&(i=65536+(i-55296<<10)+(n-56320),r++)),s+=i<128?1:i<2048?2:i<65536?3:4;for(e=new Uint8Array(s),o=0,r=0;o<s;r++)i=t.charCodeAt(r),55296===(64512&i)&&r+1<a&&(n=t.charCodeAt(r+1),56320===(64512&n)&&(i=65536+(i-55296<<10)+(n-56320),r++)),i<128?e[o++]=i:i<2048?(e[o++]=192|i>>>6,e[o++]=128|63&i):i<65536?(e[o++]=224|i>>>12,e[o++]=128|i>>>6&63,e[o++]=128|63&i):(e[o++]=240|i>>>18,e[o++]=128|i>>>12&63,e[o++]=128|i>>>6&63,e[o++]=128|63&i);return e}function zu(t,e){if(e<65537&&(t.subarray&&db||!t.subarray&&lb))return String.fromCharCode.apply(null,vu(t,e));for(var i="",n=0;n<e;n++)i+=String.fromCharCode(t[n]);return i}function Bu(t){for(var e=new Uint8Array(t.length),i=0,n=e.length;i<n;i++)e[i]=t.charCodeAt(i);return e}function Uu(t,e){var i,n,r,o,a=e||t.length,s=new Array(2*a);for(n=0,i=0;i<a;)if(r=t[i++],r<128)s[n++]=r;else if(o=fb[r],o>4)s[n++]=65533,i+=o-1;else{for(r&=2===o?31:3===o?15:7;o>1&&i<a;)r=r<<6|63&t[i++],o--;o>1?s[n++]=65533:r<65536?s[n++]=r:(r-=65536,s[n++]=55296|r>>10&1023,s[n++]=56320|1023&r)}return zu(s,n)}function ju(t,e){var i;for(e=e||t.length,e>t.length&&(e=t.length),i=e-1;i>=0&&128===(192&t[i]);)i--;return i<0?e:0===i?e:i+fb[t[i]]>e?i:e}function $u(){this.input=null,this.next_in=0,this.avail_in=0,this.total_in=0,this.output=null,this.next_out=0,this.avail_out=0,this.total_out=0,this.msg="",this.state=null,this.data_type=2,this.adler=0}function Vu(){this.text=0,this.time=0,this.xflags=0,this.os=0,this.extra=null,this.extra_len=0,this.name="",this.comment="",this.hcrc=0,this.done=!1}function Gu(t){if(!(this instanceof Gu))return new Gu(t);this.options=gu({chunkSize:16384,windowBits:0,to:""},t||{});var e=this.options;e.raw&&e.windowBits>=0&&e.windowBits<16&&(e.windowBits=-e.windowBits,0===e.windowBits&&(e.windowBits=-15)),!(e.windowBits>=0&&e.windowBits<16)||t&&t.windowBits||(e.windowBits+=32),e.windowBits>15&&e.windowBits<48&&0===(15&e.windowBits)&&(e.windowBits|=15),this.err=0,this.msg="",this.ended=!1,this.chunks=[],this.strm=new $u,this.strm.avail_out=0;var i=Iu(this.strm,e.windowBits);if(i!==yb)throw new Error(wb[i]);this.header=new Vu,Nu(this.strm,this.header)}function Hu(t,e){var i=new Gu(e);if(i.push(t,!0),i.err)throw i.msg;return i.result}function Wu(t){var e;t instanceof ArrayBuffer&&(t=new Uint8Array(t));try{e=Hu(t)}catch(i){e=t}return e}function Xu(){this.getUrl=function(t){var e,i=y(t),n=i.name.substr(0,4);return!["pdb","cif"].includes(i.ext)||i.compressed!==!1&&"gz"!==i.compressed?"mmtf"===i.ext?e=i.base.endsWith(".bb")?Pb+n:Cb+n:i.ext?(uv.warn("unsupported ext",i.ext),e=Cb+n):e=Cb+n:e=Ab+i.path,f()+e},this.getExt=function(t){var e=y(t);if("mmtf"===e.ext||!e.ext)return"mmtf"}}function qu(){this.getUrl=function(t){var e,i=y(t),n=i.name;return i.ext&&"sdf"!==i.ext?(uv.warn("unsupported ext",i.ext),e=Tb+n+Eb):e=Tb+n+Eb,f()+e},this.getExt=function(t){var e=y(t);if(!e.ext||"sdf"===e.ext)return"sdf"}}function Yu(){this.getUrl=function(t){return t}}function Zu(t){t=t||"",this.getUrl=function(e){var i=y(e);return m(t+i.path)}}!function(t){t.console=t.console||{};for(var e,i,n=t.console,r={},o=function(){},a="memory".split(","),s="assert,clear,count,debug,dir,dirxml,error,exception,group,groupCollapsed,groupEnd,info,log,markTimeline,profile,profiles,profileEnd,show,table,time,timeEnd,timeline,timelineEnd,timeStamp,trace,warn".split(",");e=a.pop();)n[e]||(n[e]=r);for(;i=s.pop();)n[i]||(n[i]=o)}("undefined"==typeof window?self:window),HTMLCanvasElement.prototype.toBlob||Object.defineProperty(HTMLCanvasElement.prototype,"toBlob",{value:function(t,e,i){for(var n=window.atob(this.toDataURL(e,i).split(",")[1]),r=n.length,o=r>>2,a=new Uint8Array(r),s=new Uint32Array(a.buffer,0,o),c=0,u=0;c<o;c++)s[c]=n.charCodeAt(u++)|n.charCodeAt(u++)<<8|n.charCodeAt(u++)<<16|n.charCodeAt(u++)<<24;for(var h=3&r;h--;)a[u]=n.charCodeAt(u++);t(new Blob([a],{type:e||"image/png"}))}}),Math.cbrt=Math.cbrt||function(t){var e=Math.pow(Math.abs(t),1/3);return t<0?-e:e},Number.isInteger||(Number.isInteger=function(t){return"number"==typeof t&&isFinite(t)&&t>-9007199254740992&&t<9007199254740992&&Math.floor(t)===t}),Number.isNaN||(Number.isNaN=function(t){return t!==t}),Object.assign||Object.defineProperty(Object,"assign",{enumerable:!1,configurable:!0,writable:!0,value:function(t){if(void 0===t||null===t)throw new TypeError("Cannot convert first argument to object");for(var e,i=Object(t),n=!1,r=1;r<arguments.length;r++){var o=arguments[r];if(void 0!==o&&null!==o){for(var a=Object.keys(Object(o)),s=0,c=a.length;s<c;s++){var u=a[s];try{var h=Object.getOwnPropertyDescriptor(o,u);void 0!==h&&h.enumerable&&(i[u]=o[u])}catch(t){n||(n=!0,e=t)}}if(n)throw e}}return i}}),String.prototype.startsWith||!function(){var t=function(){var t;try{var e={},i=Object.defineProperty;t=i(e,e,e)&&i}catch(t){}return t}(),e={}.toString,i=function(t){if(null===this)throw TypeError();var i=String(this);if(t&&"[object RegExp]"==e.call(t))throw TypeError();var n=i.length,r=String(t),o=r.length,a=arguments.length>1?arguments[1]:void 0,s=a?Number(a):0;s!=s&&(s=0);var c=Math.min(Math.max(s,0),n);if(o+c>n)return!1;for(var u=-1;++u<o;)if(i.charCodeAt(c+u)!=r.charCodeAt(u))return!1;return!0};t?t(String.prototype,"startsWith",{value:i,configurable:!0,writable:!0}):String.prototype.startsWith=i}(),String.prototype.endsWith||(String.prototype.endsWith=function(t,e){var i=this.toString();("number"!=typeof e||!isFinite(e)||Math.floor(e)!==e||e>i.length)&&(e=i.length),e-=t.length;var n=i.indexOf(t,e);return n!==-1&&n===e}),String.prototype.includes||(String.prototype.includes=function(t,e){return"number"!=typeof e&&(e=0),!(e+t.length>this.length)&&this.indexOf(t,e)!==-1}),Array.prototype.includes||(Array.prototype.includes=function(t){if(null==this)throw new TypeError("Array.prototype.includes called on null or undefined");var e=Object(this),i=parseInt(e.length,10)||0;if(0===i)return!1;var n,r=parseInt(arguments[1],10)||0;r>=0?n=r:(n=i+r,n<0&&(n=0));for(var o;n<i;){if(o=e[n],t===o||t!==t&&o!==o)return!0;n++}return!1}),Array.from||(Array.from=function(){var t=Object.prototype.toString,e=function(e){return"function"==typeof e||"[object Function]"===t.call(e)},i=function(t){var e=Number(t);return isNaN(e)?0:0!==e&&isFinite(e)?(e>0?1:-1)*Math.floor(Math.abs(e)):e},n=Math.pow(2,53)-1,r=function(t){var e=i(t);return Math.min(Math.max(e,0),n)};return function(t){var i=this,n=Object(t);if(null==t)throw new TypeError("Array.from requires an array-like object - not null or undefined");var o,a=arguments.length>1?arguments[1]:void 0;if("undefined"!=typeof a){if(!e(a))throw new TypeError("Array.from: when provided, the second argument must be a function");arguments.length>2&&(o=arguments[2])}for(var s,c=r(n.length),u=e(i)?Object(new i(c)):new Array(c),h=0;h<c;)s=n[h],a?u[h]="undefined"==typeof o?a(s,h):a.call(o,s,h):u[h]=s,h+=1;return u.length=c,u}}()),function(){for(var t=0,e=["ms","moz","webkit","o"],i=0;i<e.length&&!window.requestAnimationFrame;++i)window.requestAnimationFrame=window[e[i]+"RequestAnimationFrame"],window.cancelAnimationFrame=window[e[i]+"CancelAnimationFrame"]||window[e[i]+"CancelRequestAnimationFrame"];window.requestAnimationFrame||(window.requestAnimationFrame=function(e){var i=(new Date).getTime(),n=Math.max(0,16-(i-t)),r=window.setTimeout(function(){e(i+n)},n);return t=i+n,r}),window.cancelAnimationFrame||(window.cancelAnimationFrame=function(t){clearTimeout(t)})}(),void 0===Function.prototype.name&&void 0!==Object.defineProperty&&Object.defineProperty(Function.prototype,"name",{get:function(){return this.toString().match(/^\s*function\s*(\S*)\s*\(/)[1]}}),void 0===self.performance&&(self.performance={}),void 0===self.performance.now&&!function(){var t=Date.now();self.performance.now=function(){return Date.now()-t}}();var Ku=setTimeout,Qu="function"==typeof setImmediate&&setImmediate||function(t){Ku(t,0)},Ju=function(t){"undefined"!=typeof console&&console&&console.warn("Possible Unhandled Promise Rejection:",t)};n.prototype.catch=function(t){return this.then(null,t)},n.prototype.then=function(t,i){var n=new this.constructor(e);return r(this,new c(t,i,n)),n},n.all=function(t){var e=Array.prototype.slice.call(t);return new n(function(t,i){function n(o,a){try{if(a&&("object"==typeof a||"function"==typeof a)){var s=a.then;if("function"==typeof s)return void s.call(a,function(t){n(o,t)},i)}e[o]=a,0===--r&&t(e)}catch(t){i(t)}}if(0===e.length)return t([]);for(var r=e.length,o=0;o<e.length;o++)n(o,e[o])})},n.resolve=function(t){return t&&"object"==typeof t&&t.constructor===n?t:new n(function(e){e(t)})},n.reject=function(t){return new n(function(e,i){i(t)})},n.race=function(t){return new n(function(e,i){for(var n=0,r=t.length;n<r;n++)t[n].then(e,i);
	})},n._setImmediateFn=function(t){Qu=t},n._setUnhandledRejectionFn=function(t){Ju=t};var th=function(){function t(t,e){return t<e?-1:t>e?1:0}return function(e,i,n){var r=0,o=e.length-1;for(n||(n=t);r<=o;){var a=r+o>>1,s=n(i,e[a]);if(s>0)r=a+1;else{if(!(s<0))return a;o=a-1}}return-r-1}}();void 0===Number.EPSILON&&(Number.EPSILON=Math.pow(2,-52)),void 0===Math.sign&&(Math.sign=function(t){return t<0?-1:t>0?1:+t}),void 0===Function.prototype.name&&Object.defineProperty(Function.prototype,"name",{get:function(){return this.toString().match(/^\s*function\s*(\S*)\s*\(/)[1]}}),void 0===Object.assign&&!function(){Object.assign=function(t){if(void 0===t||null===t)throw new TypeError("Cannot convert undefined or null to object");for(var e=Object(t),i=1;i<arguments.length;i++){var n=arguments[i];if(void 0!==n&&null!==n)for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e}}(),Object.assign(E.prototype,{addEventListener:function(t,e){void 0===this._listeners&&(this._listeners={});var i=this._listeners;void 0===i[t]&&(i[t]=[]),i[t].indexOf(e)===-1&&i[t].push(e)},hasEventListener:function(t,e){if(void 0===this._listeners)return!1;var i=this._listeners;return void 0!==i[t]&&i[t].indexOf(e)!==-1},removeEventListener:function(t,e){if(void 0!==this._listeners){var i=this._listeners,n=i[t];if(void 0!==n){var r=n.indexOf(e);r!==-1&&n.splice(r,1)}}},dispatchEvent:function(t){if(void 0!==this._listeners){var e=this._listeners,i=e[t.type];if(void 0!==i){t.target=this;var n=[],r=0,o=i.length;for(r=0;r<o;r++)n[r]=i[r];for(r=0;r<o;r++)n[r].call(this,t)}}}});var eh="80",ih=0,nh=1,rh=2,oh=0,ah=1,sh=2,ch=0,uh=1,hh=2,lh=1,dh=2,fh=0,ph=1,mh=2,gh=0,vh=1,yh=2,bh=3,xh=4,_h=5,wh=100,Sh=101,Ah=102,Mh=103,Ch=104,Ph=200,Th=201,Eh=202,Ih=203,Lh=204,Rh=205,Oh=206,Dh=207,Nh=208,kh=209,Fh=210,zh=0,Bh=1,Uh=2,jh=3,$h=4,Vh=5,Gh=6,Hh=7,Wh=0,Xh=1,qh=2,Yh=0,Zh=1,Kh=2,Qh=3,Jh=4,tl=300,el=301,il=302,nl=303,rl=304,ol=305,al=306,sl=307,cl=1e3,ul=1001,hl=1002,ll=1003,dl=1004,fl=1005,pl=1006,ml=1007,gl=1008,vl=1009,yl=1010,bl=1011,xl=1012,_l=1013,wl=1014,Sl=1015,Al=1016,Ml=1017,Cl=1018,Pl=1019,Tl=1020,El=1021,Il=1022,Ll=1023,Rl=1024,Ol=1025,Dl=1026,Nl=1027,kl=2001,Fl=2002,zl=2003,Bl=2004,Ul=2100,jl=2101,$l=2102,Vl=2103,Gl=2151,Hl=2200,Wl=2201,Xl=2202,ql=2300,Yl=2301,Zl=2302,Kl=2400,Ql=2401,Jl=2402,td=0,ed=1,id=2,nd=3e3,rd=3001,od=3007,ad=3002,sd=3004,cd=3005,ud=3006,hd=3200,ld=3201,dd={DEG2RAD:Math.PI/180,RAD2DEG:180/Math.PI,generateUUID:function(){var t,e="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".split(""),i=new Array(36),n=0;return function(){for(var r=0;r<36;r++)8===r||13===r||18===r||23===r?i[r]="-":14===r?i[r]="4":(n<=2&&(n=33554432+16777216*Math.random()|0),t=15&n,n>>=4,i[r]=e[19===r?3&t|8:t]);return i.join("")}}(),clamp:function(t,e,i){return Math.max(e,Math.min(i,t))},euclideanModulo:function(t,e){return(t%e+e)%e},mapLinear:function(t,e,i,n,r){return n+(t-e)*(r-n)/(i-e)},smoothstep:function(t,e,i){return t<=e?0:t>=i?1:(t=(t-e)/(i-e),t*t*(3-2*t))},smootherstep:function(t,e,i){return t<=e?0:t>=i?1:(t=(t-e)/(i-e),t*t*t*(t*(6*t-15)+10))},random16:function(){return console.warn("THREE.Math.random16() has been deprecated. Use Math.random() instead."),Math.random()},randInt:function(t,e){return t+Math.floor(Math.random()*(e-t+1))},randFloat:function(t,e){return t+Math.random()*(e-t)},randFloatSpread:function(t){return t*(.5-Math.random())},degToRad:function(t){return t*dd.DEG2RAD},radToDeg:function(t){return t*dd.RAD2DEG},isPowerOfTwo:function(t){return 0===(t&t-1)&&0!==t},nearestPowerOfTwo:function(t){return Math.pow(2,Math.round(Math.log(t)/Math.LN2))},nextPowerOfTwo:function(t){return t--,t|=t>>1,t|=t>>2,t|=t>>4,t|=t>>8,t|=t>>16,t++,t}};I.prototype={constructor:I,isVector2:!0,get width(){return this.x},set width(t){this.x=t},get height(){return this.y},set height(t){this.y=t},set:function(t,e){return this.x=t,this.y=e,this},setScalar:function(t){return this.x=t,this.y=t,this},setX:function(t){return this.x=t,this},setY:function(t){return this.y=t,this},setComponent:function(t,e){switch(t){case 0:this.x=e;break;case 1:this.y=e;break;default:throw new Error("index is out of range: "+t)}},getComponent:function(t){switch(t){case 0:return this.x;case 1:return this.y;default:throw new Error("index is out of range: "+t)}},clone:function(){return new this.constructor(this.x,this.y)},copy:function(t){return this.x=t.x,this.y=t.y,this},add:function(t,e){return void 0!==e?(console.warn("THREE.Vector2: .add() now only accepts one argument. Use .addVectors( a, b ) instead."),this.addVectors(t,e)):(this.x+=t.x,this.y+=t.y,this)},addScalar:function(t){return this.x+=t,this.y+=t,this},addVectors:function(t,e){return this.x=t.x+e.x,this.y=t.y+e.y,this},addScaledVector:function(t,e){return this.x+=t.x*e,this.y+=t.y*e,this},sub:function(t,e){return void 0!==e?(console.warn("THREE.Vector2: .sub() now only accepts one argument. Use .subVectors( a, b ) instead."),this.subVectors(t,e)):(this.x-=t.x,this.y-=t.y,this)},subScalar:function(t){return this.x-=t,this.y-=t,this},subVectors:function(t,e){return this.x=t.x-e.x,this.y=t.y-e.y,this},multiply:function(t){return this.x*=t.x,this.y*=t.y,this},multiplyScalar:function(t){return isFinite(t)?(this.x*=t,this.y*=t):(this.x=0,this.y=0),this},divide:function(t){return this.x/=t.x,this.y/=t.y,this},divideScalar:function(t){return this.multiplyScalar(1/t)},min:function(t){return this.x=Math.min(this.x,t.x),this.y=Math.min(this.y,t.y),this},max:function(t){return this.x=Math.max(this.x,t.x),this.y=Math.max(this.y,t.y),this},clamp:function(t,e){return this.x=Math.max(t.x,Math.min(e.x,this.x)),this.y=Math.max(t.y,Math.min(e.y,this.y)),this},clampScalar:function(){var t,e;return function(i,n){return void 0===t&&(t=new I,e=new I),t.set(i,i),e.set(n,n),this.clamp(t,e)}}(),clampLength:function(t,e){var i=this.length();return this.multiplyScalar(Math.max(t,Math.min(e,i))/i)},floor:function(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this},ceil:function(){return this.x=Math.ceil(this.x),this.y=Math.ceil(this.y),this},round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this},roundToZero:function(){return this.x=this.x<0?Math.ceil(this.x):Math.floor(this.x),this.y=this.y<0?Math.ceil(this.y):Math.floor(this.y),this},negate:function(){return this.x=-this.x,this.y=-this.y,this},dot:function(t){return this.x*t.x+this.y*t.y},lengthSq:function(){return this.x*this.x+this.y*this.y},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},lengthManhattan:function(){return Math.abs(this.x)+Math.abs(this.y)},normalize:function(){return this.divideScalar(this.length())},angle:function(){var t=Math.atan2(this.y,this.x);return t<0&&(t+=2*Math.PI),t},distanceTo:function(t){return Math.sqrt(this.distanceToSquared(t))},distanceToSquared:function(t){var e=this.x-t.x,i=this.y-t.y;return e*e+i*i},distanceToManhattan:function(t){return Math.abs(this.x-t.x)+Math.abs(this.y-t.y)},setLength:function(t){return this.multiplyScalar(t/this.length())},lerp:function(t,e){return this.x+=(t.x-this.x)*e,this.y+=(t.y-this.y)*e,this},lerpVectors:function(t,e,i){return this.subVectors(e,t).multiplyScalar(i).add(t)},equals:function(t){return t.x===this.x&&t.y===this.y},fromArray:function(t,e){return void 0===e&&(e=0),this.x=t[e],this.y=t[e+1],this},toArray:function(t,e){return void 0===t&&(t=[]),void 0===e&&(e=0),t[e]=this.x,t[e+1]=this.y,t},fromAttribute:function(t,e,i){return void 0===i&&(i=0),e=e*t.itemSize+i,this.x=t.array[e],this.y=t.array[e+1],this},rotateAround:function(t,e){var i=Math.cos(e),n=Math.sin(e),r=this.x-t.x,o=this.y-t.y;return this.x=r*i-o*n+t.x,this.y=r*n+o*i+t.y,this}},L.DEFAULT_IMAGE=void 0,L.DEFAULT_MAPPING=tl,L.prototype={constructor:L,isTexture:!0,set needsUpdate(t){t===!0&&this.version++},clone:function(){return(new this.constructor).copy(this)},copy:function(t){return this.image=t.image,this.mipmaps=t.mipmaps.slice(0),this.mapping=t.mapping,this.wrapS=t.wrapS,this.wrapT=t.wrapT,this.magFilter=t.magFilter,this.minFilter=t.minFilter,this.anisotropy=t.anisotropy,this.format=t.format,this.type=t.type,this.offset.copy(t.offset),this.repeat.copy(t.repeat),this.generateMipmaps=t.generateMipmaps,this.premultiplyAlpha=t.premultiplyAlpha,this.flipY=t.flipY,this.unpackAlignment=t.unpackAlignment,this.encoding=t.encoding,this},toJSON:function(t){function e(t){var e;return void 0!==t.toDataURL?e=t:(e=document.createElementNS("http://www.w3.org/1999/xhtml","canvas"),e.width=t.width,e.height=t.height,e.getContext("2d").drawImage(t,0,0,t.width,t.height)),e.width>2048||e.height>2048?e.toDataURL("image/jpeg",.6):e.toDataURL("image/png")}if(void 0!==t.textures[this.uuid])return t.textures[this.uuid];var i={metadata:{version:4.4,type:"Texture",generator:"Texture.toJSON"},uuid:this.uuid,name:this.name,mapping:this.mapping,repeat:[this.repeat.x,this.repeat.y],offset:[this.offset.x,this.offset.y],wrap:[this.wrapS,this.wrapT],minFilter:this.minFilter,magFilter:this.magFilter,anisotropy:this.anisotropy,flipY:this.flipY};if(void 0!==this.image){var n=this.image;void 0===n.uuid&&(n.uuid=dd.generateUUID()),void 0===t.images[n.uuid]&&(t.images[n.uuid]={uuid:n.uuid,url:e(n)}),i.image=n.uuid}return t.textures[this.uuid]=i,i},dispose:function(){this.dispatchEvent({type:"dispose"})},transformUv:function(t){if(this.mapping===tl){if(t.multiply(this.repeat),t.add(this.offset),t.x<0||t.x>1)switch(this.wrapS){case cl:t.x=t.x-Math.floor(t.x);break;case ul:t.x=t.x<0?0:1;break;case hl:1===Math.abs(Math.floor(t.x)%2)?t.x=Math.ceil(t.x)-t.x:t.x=t.x-Math.floor(t.x)}if(t.y<0||t.y>1)switch(this.wrapT){case cl:t.y=t.y-Math.floor(t.y);break;case ul:t.y=t.y<0?0:1;break;case hl:1===Math.abs(Math.floor(t.y)%2)?t.y=Math.ceil(t.y)-t.y:t.y=t.y-Math.floor(t.y)}this.flipY&&(t.y=1-t.y)}}},Object.assign(L.prototype,E.prototype);var fd=0;O.prototype={constructor:O,isMatrix4:!0,set:function(t,e,i,n,r,o,a,s,c,u,h,l,d,f,p,m){var g=this.elements;return g[0]=t,g[4]=e,g[8]=i,g[12]=n,g[1]=r,g[5]=o,g[9]=a,g[13]=s,g[2]=c,g[6]=u,g[10]=h,g[14]=l,g[3]=d,g[7]=f,g[11]=p,g[15]=m,this},identity:function(){return this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1),this},clone:function(){return(new O).fromArray(this.elements)},copy:function(t){return this.elements.set(t.elements),this},copyPosition:function(t){var e=this.elements,i=t.elements;return e[12]=i[12],e[13]=i[13],e[14]=i[14],this},extractBasis:function(t,e,i){return t.setFromMatrixColumn(this,0),e.setFromMatrixColumn(this,1),i.setFromMatrixColumn(this,2),this},makeBasis:function(t,e,i){return this.set(t.x,e.x,i.x,0,t.y,e.y,i.y,0,t.z,e.z,i.z,0,0,0,0,1),this},extractRotation:function(){var t;return function(e){void 0===t&&(t=new N);var i=this.elements,n=e.elements,r=1/t.setFromMatrixColumn(e,0).length(),o=1/t.setFromMatrixColumn(e,1).length(),a=1/t.setFromMatrixColumn(e,2).length();return i[0]=n[0]*r,i[1]=n[1]*r,i[2]=n[2]*r,i[4]=n[4]*o,i[5]=n[5]*o,i[6]=n[6]*o,i[8]=n[8]*a,i[9]=n[9]*a,i[10]=n[10]*a,this}}(),makeRotationFromEuler:function(t){(t&&t.isEuler)===!1&&console.error("THREE.Matrix: .makeRotationFromEuler() now expects a Euler rotation rather than a Vector3 and order.");var e=this.elements,i=t.x,n=t.y,r=t.z,o=Math.cos(i),a=Math.sin(i),s=Math.cos(n),c=Math.sin(n),u=Math.cos(r),h=Math.sin(r);if("XYZ"===t.order){var l=o*u,d=o*h,f=a*u,p=a*h;e[0]=s*u,e[4]=-s*h,e[8]=c,e[1]=d+f*c,e[5]=l-p*c,e[9]=-a*s,e[2]=p-l*c,e[6]=f+d*c,e[10]=o*s}else if("YXZ"===t.order){var m=s*u,g=s*h,v=c*u,y=c*h;e[0]=m+y*a,e[4]=v*a-g,e[8]=o*c,e[1]=o*h,e[5]=o*u,e[9]=-a,e[2]=g*a-v,e[6]=y+m*a,e[10]=o*s}else if("ZXY"===t.order){var m=s*u,g=s*h,v=c*u,y=c*h;e[0]=m-y*a,e[4]=-o*h,e[8]=v+g*a,e[1]=g+v*a,e[5]=o*u,e[9]=y-m*a,e[2]=-o*c,e[6]=a,e[10]=o*s}else if("ZYX"===t.order){var l=o*u,d=o*h,f=a*u,p=a*h;e[0]=s*u,e[4]=f*c-d,e[8]=l*c+p,e[1]=s*h,e[5]=p*c+l,e[9]=d*c-f,e[2]=-c,e[6]=a*s,e[10]=o*s}else if("YZX"===t.order){var b=o*s,x=o*c,_=a*s,w=a*c;e[0]=s*u,e[4]=w-b*h,e[8]=_*h+x,e[1]=h,e[5]=o*u,e[9]=-a*u,e[2]=-c*u,e[6]=x*h+_,e[10]=b-w*h}else if("XZY"===t.order){var b=o*s,x=o*c,_=a*s,w=a*c;e[0]=s*u,e[4]=-h,e[8]=c*u,e[1]=b*h+w,e[5]=o*u,e[9]=x*h-_,e[2]=_*h-x,e[6]=a*u,e[10]=w*h+b}return e[3]=0,e[7]=0,e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,this},makeRotationFromQuaternion:function(t){var e=this.elements,i=t.x,n=t.y,r=t.z,o=t.w,a=i+i,s=n+n,c=r+r,u=i*a,h=i*s,l=i*c,d=n*s,f=n*c,p=r*c,m=o*a,g=o*s,v=o*c;return e[0]=1-(d+p),e[4]=h-v,e[8]=l+g,e[1]=h+v,e[5]=1-(u+p),e[9]=f-m,e[2]=l-g,e[6]=f+m,e[10]=1-(u+d),e[3]=0,e[7]=0,e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,this},lookAt:function(){var t,e,i;return function(n,r,o){void 0===t&&(t=new N,e=new N,i=new N);var a=this.elements;return i.subVectors(n,r).normalize(),0===i.lengthSq()&&(i.z=1),t.crossVectors(o,i).normalize(),0===t.lengthSq()&&(i.z+=1e-4,t.crossVectors(o,i).normalize()),e.crossVectors(i,t),a[0]=t.x,a[4]=e.x,a[8]=i.x,a[1]=t.y,a[5]=e.y,a[9]=i.y,a[2]=t.z,a[6]=e.z,a[10]=i.z,this}}(),multiply:function(t,e){return void 0!==e?(console.warn("THREE.Matrix4: .multiply() now only accepts one argument. Use .multiplyMatrices( a, b ) instead."),this.multiplyMatrices(t,e)):this.multiplyMatrices(this,t)},premultiply:function(t){return this.multiplyMatrices(t,this)},multiplyMatrices:function(t,e){var i=t.elements,n=e.elements,r=this.elements,o=i[0],a=i[4],s=i[8],c=i[12],u=i[1],h=i[5],l=i[9],d=i[13],f=i[2],p=i[6],m=i[10],g=i[14],v=i[3],y=i[7],b=i[11],x=i[15],_=n[0],w=n[4],S=n[8],A=n[12],M=n[1],C=n[5],P=n[9],T=n[13],E=n[2],I=n[6],L=n[10],R=n[14],O=n[3],D=n[7],N=n[11],k=n[15];return r[0]=o*_+a*M+s*E+c*O,r[4]=o*w+a*C+s*I+c*D,r[8]=o*S+a*P+s*L+c*N,r[12]=o*A+a*T+s*R+c*k,r[1]=u*_+h*M+l*E+d*O,r[5]=u*w+h*C+l*I+d*D,r[9]=u*S+h*P+l*L+d*N,r[13]=u*A+h*T+l*R+d*k,r[2]=f*_+p*M+m*E+g*O,r[6]=f*w+p*C+m*I+g*D,r[10]=f*S+p*P+m*L+g*N,r[14]=f*A+p*T+m*R+g*k,r[3]=v*_+y*M+b*E+x*O,r[7]=v*w+y*C+b*I+x*D,r[11]=v*S+y*P+b*L+x*N,r[15]=v*A+y*T+b*R+x*k,this},multiplyToArray:function(t,e,i){var n=this.elements;return this.multiplyMatrices(t,e),i[0]=n[0],i[1]=n[1],i[2]=n[2],i[3]=n[3],i[4]=n[4],i[5]=n[5],i[6]=n[6],i[7]=n[7],i[8]=n[8],i[9]=n[9],i[10]=n[10],i[11]=n[11],i[12]=n[12],i[13]=n[13],i[14]=n[14],i[15]=n[15],this},multiplyScalar:function(t){var e=this.elements;return e[0]*=t,e[4]*=t,e[8]*=t,e[12]*=t,e[1]*=t,e[5]*=t,e[9]*=t,e[13]*=t,e[2]*=t,e[6]*=t,e[10]*=t,e[14]*=t,e[3]*=t,e[7]*=t,e[11]*=t,e[15]*=t,this},applyToVector3Array:function(){var t;return function(e,i,n){void 0===t&&(t=new N),void 0===i&&(i=0),void 0===n&&(n=e.length);for(var r=0,o=i;r<n;r+=3,o+=3)t.fromArray(e,o),t.applyMatrix4(this),t.toArray(e,o);return e}}(),applyToBuffer:function(){var t;return function(e,i,n){void 0===t&&(t=new N),void 0===i&&(i=0),void 0===n&&(n=e.length/e.itemSize);for(var r=0,o=i;r<n;r++,o++)t.x=e.getX(o),t.y=e.getY(o),t.z=e.getZ(o),t.applyMatrix4(this),e.setXYZ(t.x,t.y,t.z);return e}}(),determinant:function(){var t=this.elements,e=t[0],i=t[4],n=t[8],r=t[12],o=t[1],a=t[5],s=t[9],c=t[13],u=t[2],h=t[6],l=t[10],d=t[14],f=t[3],p=t[7],m=t[11],g=t[15];return f*(+r*s*h-n*c*h-r*a*l+i*c*l+n*a*d-i*s*d)+p*(+e*s*d-e*c*l+r*o*l-n*o*d+n*c*u-r*s*u)+m*(+e*c*h-e*a*d-r*o*h+i*o*d+r*a*u-i*c*u)+g*(-n*a*u-e*s*h+e*a*l+n*o*h-i*o*l+i*s*u)},transpose:function(){var t,e=this.elements;return t=e[1],e[1]=e[4],e[4]=t,t=e[2],e[2]=e[8],e[8]=t,t=e[6],e[6]=e[9],e[9]=t,t=e[3],e[3]=e[12],e[12]=t,t=e[7],e[7]=e[13],e[13]=t,t=e[11],e[11]=e[14],e[14]=t,this},flattenToArrayOffset:function(t,e){return console.warn("THREE.Matrix3: .flattenToArrayOffset is deprecated - just use .toArray instead."),this.toArray(t,e)},getPosition:function(){var t;return function(){return void 0===t&&(t=new N),console.warn("THREE.Matrix4: .getPosition() has been removed. Use Vector3.setFromMatrixPosition( matrix ) instead."),t.setFromMatrixColumn(this,3)}}(),setPosition:function(t){var e=this.elements;return e[12]=t.x,e[13]=t.y,e[14]=t.z,this},getInverse:function(t,e){var i=this.elements,n=t.elements,r=n[0],o=n[1],a=n[2],s=n[3],c=n[4],u=n[5],h=n[6],l=n[7],d=n[8],f=n[9],p=n[10],m=n[11],g=n[12],v=n[13],y=n[14],b=n[15],x=f*y*l-v*p*l+v*h*m-u*y*m-f*h*b+u*p*b,_=g*p*l-d*y*l-g*h*m+c*y*m+d*h*b-c*p*b,w=d*v*l-g*f*l+g*u*m-c*v*m-d*u*b+c*f*b,S=g*f*h-d*v*h-g*u*p+c*v*p+d*u*y-c*f*y,A=r*x+o*_+a*w+s*S;if(0===A){var M="THREE.Matrix4.getInverse(): can't invert matrix, determinant is 0";if(e===!0)throw new Error(M);return console.warn(M),this.identity()}var C=1/A;return i[0]=x*C,i[1]=(v*p*s-f*y*s-v*a*m+o*y*m+f*a*b-o*p*b)*C,i[2]=(u*y*s-v*h*s+v*a*l-o*y*l-u*a*b+o*h*b)*C,i[3]=(f*h*s-u*p*s-f*a*l+o*p*l+u*a*m-o*h*m)*C,i[4]=_*C,i[5]=(d*y*s-g*p*s+g*a*m-r*y*m-d*a*b+r*p*b)*C,i[6]=(g*h*s-c*y*s-g*a*l+r*y*l+c*a*b-r*h*b)*C,i[7]=(c*p*s-d*h*s+d*a*l-r*p*l-c*a*m+r*h*m)*C,i[8]=w*C,i[9]=(g*f*s-d*v*s-g*o*m+r*v*m+d*o*b-r*f*b)*C,i[10]=(c*v*s-g*u*s+g*o*l-r*v*l-c*o*b+r*u*b)*C,i[11]=(d*u*s-c*f*s-d*o*l+r*f*l+c*o*m-r*u*m)*C,i[12]=S*C,i[13]=(d*v*a-g*f*a+g*o*p-r*v*p-d*o*y+r*f*y)*C,i[14]=(g*u*a-c*v*a-g*o*h+r*v*h+c*o*y-r*u*y)*C,i[15]=(c*f*a-d*u*a+d*o*h-r*f*h-c*o*p+r*u*p)*C,this},scale:function(t){var e=this.elements,i=t.x,n=t.y,r=t.z;return e[0]*=i,e[4]*=n,e[8]*=r,e[1]*=i,e[5]*=n,e[9]*=r,e[2]*=i,e[6]*=n,e[10]*=r,e[3]*=i,e[7]*=n,e[11]*=r,this},getMaxScaleOnAxis:function(){var t=this.elements,e=t[0]*t[0]+t[1]*t[1]+t[2]*t[2],i=t[4]*t[4]+t[5]*t[5]+t[6]*t[6],n=t[8]*t[8]+t[9]*t[9]+t[10]*t[10];return Math.sqrt(Math.max(e,i,n))},makeTranslation:function(t,e,i){return this.set(1,0,0,t,0,1,0,e,0,0,1,i,0,0,0,1),this},makeRotationX:function(t){var e=Math.cos(t),i=Math.sin(t);return this.set(1,0,0,0,0,e,-i,0,0,i,e,0,0,0,0,1),this},makeRotationY:function(t){var e=Math.cos(t),i=Math.sin(t);return this.set(e,0,i,0,0,1,0,0,-i,0,e,0,0,0,0,1),this},makeRotationZ:function(t){var e=Math.cos(t),i=Math.sin(t);return this.set(e,-i,0,0,i,e,0,0,0,0,1,0,0,0,0,1),this},makeRotationAxis:function(t,e){var i=Math.cos(e),n=Math.sin(e),r=1-i,o=t.x,a=t.y,s=t.z,c=r*o,u=r*a;return this.set(c*o+i,c*a-n*s,c*s+n*a,0,c*a+n*s,u*a+i,u*s-n*o,0,c*s-n*a,u*s+n*o,r*s*s+i,0,0,0,0,1),this},makeScale:function(t,e,i){return this.set(t,0,0,0,0,e,0,0,0,0,i,0,0,0,0,1),this},compose:function(t,e,i){return this.makeRotationFromQuaternion(e),this.scale(i),this.setPosition(t),this},decompose:function(){var t,e;return function(i,n,r){void 0===t&&(t=new N,e=new O);var o=this.elements,a=t.set(o[0],o[1],o[2]).length(),s=t.set(o[4],o[5],o[6]).length(),c=t.set(o[8],o[9],o[10]).length(),u=this.determinant();u<0&&(a=-a),i.x=o[12],i.y=o[13],i.z=o[14],e.elements.set(this.elements);var h=1/a,l=1/s,d=1/c;return e.elements[0]*=h,e.elements[1]*=h,e.elements[2]*=h,e.elements[4]*=l,e.elements[5]*=l,e.elements[6]*=l,e.elements[8]*=d,e.elements[9]*=d,e.elements[10]*=d,n.setFromRotationMatrix(e),r.x=a,r.y=s,r.z=c,this}}(),makeFrustum:function(t,e,i,n,r,o){var a=this.elements,s=2*r/(e-t),c=2*r/(n-i),u=(e+t)/(e-t),h=(n+i)/(n-i),l=-(o+r)/(o-r),d=-2*o*r/(o-r);return a[0]=s,a[4]=0,a[8]=u,a[12]=0,a[1]=0,a[5]=c,a[9]=h,a[13]=0,a[2]=0,a[6]=0,a[10]=l,a[14]=d,a[3]=0,a[7]=0,a[11]=-1,a[15]=0,this},makePerspective:function(t,e,i,n){var r=i*Math.tan(dd.DEG2RAD*t*.5),o=-r,a=o*e,s=r*e;return this.makeFrustum(a,s,o,r,i,n)},makeOrthographic:function(t,e,i,n,r,o){var a=this.elements,s=1/(e-t),c=1/(i-n),u=1/(o-r),h=(e+t)*s,l=(i+n)*c,d=(o+r)*u;return a[0]=2*s,a[4]=0,a[8]=0,a[12]=-h,a[1]=0,a[5]=2*c,a[9]=0,a[13]=-l,a[2]=0,a[6]=0,a[10]=-2*u,a[14]=-d,a[3]=0,a[7]=0,a[11]=0,a[15]=1,this},equals:function(t){for(var e=this.elements,i=t.elements,n=0;n<16;n++)if(e[n]!==i[n])return!1;return!0},fromArray:function(t){return this.elements.set(t),this},toArray:function(t,e){void 0===t&&(t=[]),void 0===e&&(e=0);var i=this.elements;return t[e]=i[0],t[e+1]=i[1],t[e+2]=i[2],t[e+3]=i[3],t[e+4]=i[4],t[e+5]=i[5],t[e+6]=i[6],t[e+7]=i[7],t[e+8]=i[8],t[e+9]=i[9],t[e+10]=i[10],t[e+11]=i[11],t[e+12]=i[12],t[e+13]=i[13],t[e+14]=i[14],t[e+15]=i[15],t}},D.prototype={constructor:D,get x(){return this._x},set x(t){this._x=t,this.onChangeCallback()},get y(){return this._y},set y(t){this._y=t,this.onChangeCallback()},get z(){return this._z},set z(t){this._z=t,this.onChangeCallback()},get w(){return this._w},set w(t){this._w=t,this.onChangeCallback()},set:function(t,e,i,n){return this._x=t,this._y=e,this._z=i,this._w=n,this.onChangeCallback(),this},clone:function(){return new this.constructor(this._x,this._y,this._z,this._w)},copy:function(t){return this._x=t.x,this._y=t.y,this._z=t.z,this._w=t.w,this.onChangeCallback(),this},setFromEuler:function(t,e){if((t&&t.isEuler)===!1)throw new Error("THREE.Quaternion: .setFromEuler() now expects a Euler rotation rather than a Vector3 and order.");var i=Math.cos(t._x/2),n=Math.cos(t._y/2),r=Math.cos(t._z/2),o=Math.sin(t._x/2),a=Math.sin(t._y/2),s=Math.sin(t._z/2),c=t.order;return"XYZ"===c?(this._x=o*n*r+i*a*s,this._y=i*a*r-o*n*s,this._z=i*n*s+o*a*r,this._w=i*n*r-o*a*s):"YXZ"===c?(this._x=o*n*r+i*a*s,this._y=i*a*r-o*n*s,this._z=i*n*s-o*a*r,this._w=i*n*r+o*a*s):"ZXY"===c?(this._x=o*n*r-i*a*s,this._y=i*a*r+o*n*s,this._z=i*n*s+o*a*r,this._w=i*n*r-o*a*s):"ZYX"===c?(this._x=o*n*r-i*a*s,this._y=i*a*r+o*n*s,this._z=i*n*s-o*a*r,this._w=i*n*r+o*a*s):"YZX"===c?(this._x=o*n*r+i*a*s,this._y=i*a*r+o*n*s,this._z=i*n*s-o*a*r,this._w=i*n*r-o*a*s):"XZY"===c&&(this._x=o*n*r-i*a*s,this._y=i*a*r-o*n*s,this._z=i*n*s+o*a*r,this._w=i*n*r+o*a*s),e!==!1&&this.onChangeCallback(),this},setFromAxisAngle:function(t,e){var i=e/2,n=Math.sin(i);return this._x=t.x*n,this._y=t.y*n,this._z=t.z*n,this._w=Math.cos(i),this.onChangeCallback(),this},setFromRotationMatrix:function(t){var e,i=t.elements,n=i[0],r=i[4],o=i[8],a=i[1],s=i[5],c=i[9],u=i[2],h=i[6],l=i[10],d=n+s+l;return d>0?(e=.5/Math.sqrt(d+1),this._w=.25/e,this._x=(h-c)*e,this._y=(o-u)*e,this._z=(a-r)*e):n>s&&n>l?(e=2*Math.sqrt(1+n-s-l),this._w=(h-c)/e,this._x=.25*e,this._y=(r+a)/e,this._z=(o+u)/e):s>l?(e=2*Math.sqrt(1+s-n-l),this._w=(o-u)/e,this._x=(r+a)/e,this._y=.25*e,this._z=(c+h)/e):(e=2*Math.sqrt(1+l-n-s),this._w=(a-r)/e,this._x=(o+u)/e,this._y=(c+h)/e,this._z=.25*e),this.onChangeCallback(),this},setFromUnitVectors:function(){var t,e,i=1e-6;return function(n,r){return void 0===t&&(t=new N),e=n.dot(r)+1,e<i?(e=0,Math.abs(n.x)>Math.abs(n.z)?t.set(-n.y,n.x,0):t.set(0,-n.z,n.y)):t.crossVectors(n,r),this._x=t.x,this._y=t.y,this._z=t.z,this._w=e,this.normalize()}}(),inverse:function(){return this.conjugate().normalize()},conjugate:function(){return this._x*=-1,this._y*=-1,this._z*=-1,this.onChangeCallback(),this},dot:function(t){return this._x*t._x+this._y*t._y+this._z*t._z+this._w*t._w},lengthSq:function(){return this._x*this._x+this._y*this._y+this._z*this._z+this._w*this._w},length:function(){return Math.sqrt(this._x*this._x+this._y*this._y+this._z*this._z+this._w*this._w)},normalize:function(){var t=this.length();return 0===t?(this._x=0,this._y=0,this._z=0,this._w=1):(t=1/t,this._x=this._x*t,this._y=this._y*t,this._z=this._z*t,this._w=this._w*t),this.onChangeCallback(),this},multiply:function(t,e){return void 0!==e?(console.warn("THREE.Quaternion: .multiply() now only accepts one argument. Use .multiplyQuaternions( a, b ) instead."),this.multiplyQuaternions(t,e)):this.multiplyQuaternions(this,t)},premultiply:function(t){return this.multiplyQuaternions(t,this)},multiplyQuaternions:function(t,e){var i=t._x,n=t._y,r=t._z,o=t._w,a=e._x,s=e._y,c=e._z,u=e._w;return this._x=i*u+o*a+n*c-r*s,this._y=n*u+o*s+r*a-i*c,this._z=r*u+o*c+i*s-n*a,this._w=o*u-i*a-n*s-r*c,this.onChangeCallback(),this},slerp:function(t,e){if(0===e)return this;if(1===e)return this.copy(t);var i=this._x,n=this._y,r=this._z,o=this._w,a=o*t._w+i*t._x+n*t._y+r*t._z;if(a<0?(this._w=-t._w,this._x=-t._x,this._y=-t._y,this._z=-t._z,a=-a):this.copy(t),a>=1)return this._w=o,this._x=i,this._y=n,this._z=r,this;var s=Math.sqrt(1-a*a);if(Math.abs(s)<.001)return this._w=.5*(o+this._w),this._x=.5*(i+this._x),this._y=.5*(n+this._y),this._z=.5*(r+this._z),this;var c=Math.atan2(s,a),u=Math.sin((1-e)*c)/s,h=Math.sin(e*c)/s;return this._w=o*u+this._w*h,this._x=i*u+this._x*h,this._y=n*u+this._y*h,this._z=r*u+this._z*h,this.onChangeCallback(),this},equals:function(t){return t._x===this._x&&t._y===this._y&&t._z===this._z&&t._w===this._w},fromArray:function(t,e){return void 0===e&&(e=0),this._x=t[e],this._y=t[e+1],this._z=t[e+2],this._w=t[e+3],this.onChangeCallback(),this},toArray:function(t,e){return void 0===t&&(t=[]),void 0===e&&(e=0),t[e]=this._x,t[e+1]=this._y,t[e+2]=this._z,t[e+3]=this._w,t},onChange:function(t){return this.onChangeCallback=t,this},onChangeCallback:function(){}},Object.assign(D,{slerp:function(t,e,i,n){return i.copy(t).slerp(e,n)},slerpFlat:function(t,e,i,n,r,o,a){var s=i[n+0],c=i[n+1],u=i[n+2],h=i[n+3],l=r[o+0],d=r[o+1],f=r[o+2],p=r[o+3];if(h!==p||s!==l||c!==d||u!==f){var m=1-a,g=s*l+c*d+u*f+h*p,v=g>=0?1:-1,y=1-g*g;if(y>Number.EPSILON){var b=Math.sqrt(y),x=Math.atan2(b,g*v);m=Math.sin(m*x)/b,a=Math.sin(a*x)/b}var _=a*v;if(s=s*m+l*_,c=c*m+d*_,u=u*m+f*_,h=h*m+p*_,m===1-a){var w=1/Math.sqrt(s*s+c*c+u*u+h*h);s*=w,c*=w,u*=w,h*=w}}t[e]=s,t[e+1]=c,t[e+2]=u,t[e+3]=h}}),N.prototype={constructor:N,isVector3:!0,set:function(t,e,i){return this.x=t,this.y=e,this.z=i,this},setScalar:function(t){return this.x=t,this.y=t,this.z=t,this},setX:function(t){return this.x=t,this},setY:function(t){return this.y=t,this},setZ:function(t){return this.z=t,this},setComponent:function(t,e){switch(t){case 0:this.x=e;break;case 1:this.y=e;break;case 2:this.z=e;break;default:throw new Error("index is out of range: "+t)}},getComponent:function(t){switch(t){case 0:return this.x;case 1:return this.y;case 2:return this.z;default:throw new Error("index is out of range: "+t)}},clone:function(){return new this.constructor(this.x,this.y,this.z)},copy:function(t){return this.x=t.x,this.y=t.y,this.z=t.z,this},add:function(t,e){return void 0!==e?(console.warn("THREE.Vector3: .add() now only accepts one argument. Use .addVectors( a, b ) instead."),this.addVectors(t,e)):(this.x+=t.x,this.y+=t.y,this.z+=t.z,this)},addScalar:function(t){return this.x+=t,this.y+=t,this.z+=t,this},addVectors:function(t,e){return this.x=t.x+e.x,this.y=t.y+e.y,this.z=t.z+e.z,this},addScaledVector:function(t,e){return this.x+=t.x*e,this.y+=t.y*e,this.z+=t.z*e,this},sub:function(t,e){return void 0!==e?(console.warn("THREE.Vector3: .sub() now only accepts one argument. Use .subVectors( a, b ) instead."),this.subVectors(t,e)):(this.x-=t.x,this.y-=t.y,this.z-=t.z,this)},subScalar:function(t){return this.x-=t,this.y-=t,this.z-=t,this},subVectors:function(t,e){return this.x=t.x-e.x,this.y=t.y-e.y,this.z=t.z-e.z,this},multiply:function(t,e){return void 0!==e?(console.warn("THREE.Vector3: .multiply() now only accepts one argument. Use .multiplyVectors( a, b ) instead."),this.multiplyVectors(t,e)):(this.x*=t.x,this.y*=t.y,this.z*=t.z,this)},multiplyScalar:function(t){return isFinite(t)?(this.x*=t,this.y*=t,this.z*=t):(this.x=0,this.y=0,this.z=0),this},multiplyVectors:function(t,e){return this.x=t.x*e.x,this.y=t.y*e.y,this.z=t.z*e.z,this},applyEuler:function(){var t;return function(e){return(e&&e.isEuler)===!1&&console.error("THREE.Vector3: .applyEuler() now expects an Euler rotation rather than a Vector3 and order."),void 0===t&&(t=new D),this.applyQuaternion(t.setFromEuler(e))}}(),applyAxisAngle:function(){var t;return function(e,i){return void 0===t&&(t=new D),this.applyQuaternion(t.setFromAxisAngle(e,i))}}(),applyMatrix3:function(t){var e=this.x,i=this.y,n=this.z,r=t.elements;return this.x=r[0]*e+r[3]*i+r[6]*n,this.y=r[1]*e+r[4]*i+r[7]*n,this.z=r[2]*e+r[5]*i+r[8]*n,this},applyMatrix4:function(t){var e=this.x,i=this.y,n=this.z,r=t.elements;return this.x=r[0]*e+r[4]*i+r[8]*n+r[12],this.y=r[1]*e+r[5]*i+r[9]*n+r[13],this.z=r[2]*e+r[6]*i+r[10]*n+r[14],this},applyProjection:function(t){var e=this.x,i=this.y,n=this.z,r=t.elements,o=1/(r[3]*e+r[7]*i+r[11]*n+r[15]);return this.x=(r[0]*e+r[4]*i+r[8]*n+r[12])*o,this.y=(r[1]*e+r[5]*i+r[9]*n+r[13])*o,this.z=(r[2]*e+r[6]*i+r[10]*n+r[14])*o,this},applyQuaternion:function(t){var e=this.x,i=this.y,n=this.z,r=t.x,o=t.y,a=t.z,s=t.w,c=s*e+o*n-a*i,u=s*i+a*e-r*n,h=s*n+r*i-o*e,l=-r*e-o*i-a*n;return this.x=c*s+l*-r+u*-a-h*-o,this.y=u*s+l*-o+h*-r-c*-a,this.z=h*s+l*-a+c*-o-u*-r,this},project:function(){var t;return function(e){return void 0===t&&(t=new O),t.multiplyMatrices(e.projectionMatrix,t.getInverse(e.matrixWorld)),this.applyProjection(t)}}(),unproject:function(){var t;return function(e){return void 0===t&&(t=new O),t.multiplyMatrices(e.matrixWorld,t.getInverse(e.projectionMatrix)),this.applyProjection(t)}}(),transformDirection:function(t){var e=this.x,i=this.y,n=this.z,r=t.elements;return this.x=r[0]*e+r[4]*i+r[8]*n,this.y=r[1]*e+r[5]*i+r[9]*n,this.z=r[2]*e+r[6]*i+r[10]*n,this.normalize()},divide:function(t){return this.x/=t.x,this.y/=t.y,this.z/=t.z,this},divideScalar:function(t){return this.multiplyScalar(1/t)},min:function(t){return this.x=Math.min(this.x,t.x),this.y=Math.min(this.y,t.y),this.z=Math.min(this.z,t.z),this},max:function(t){return this.x=Math.max(this.x,t.x),this.y=Math.max(this.y,t.y),this.z=Math.max(this.z,t.z),this},clamp:function(t,e){return this.x=Math.max(t.x,Math.min(e.x,this.x)),this.y=Math.max(t.y,Math.min(e.y,this.y)),this.z=Math.max(t.z,Math.min(e.z,this.z)),this},clampScalar:function(){var t,e;return function(i,n){return void 0===t&&(t=new N,e=new N),t.set(i,i,i),e.set(n,n,n),this.clamp(t,e)}}(),clampLength:function(t,e){var i=this.length();return this.multiplyScalar(Math.max(t,Math.min(e,i))/i)},floor:function(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this.z=Math.floor(this.z),this},ceil:function(){return this.x=Math.ceil(this.x),this.y=Math.ceil(this.y),this.z=Math.ceil(this.z),this},round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this.z=Math.round(this.z),this},roundToZero:function(){return this.x=this.x<0?Math.ceil(this.x):Math.floor(this.x),this.y=this.y<0?Math.ceil(this.y):Math.floor(this.y),this.z=this.z<0?Math.ceil(this.z):Math.floor(this.z),this},negate:function(){return this.x=-this.x,this.y=-this.y,this.z=-this.z,this},dot:function(t){return this.x*t.x+this.y*t.y+this.z*t.z},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z)},lengthManhattan:function(){return Math.abs(this.x)+Math.abs(this.y)+Math.abs(this.z)},normalize:function(){return this.divideScalar(this.length())},setLength:function(t){return this.multiplyScalar(t/this.length())},lerp:function(t,e){return this.x+=(t.x-this.x)*e,this.y+=(t.y-this.y)*e,this.z+=(t.z-this.z)*e,this},lerpVectors:function(t,e,i){return this.subVectors(e,t).multiplyScalar(i).add(t)},cross:function(t,e){if(void 0!==e)return console.warn("THREE.Vector3: .cross() now only accepts one argument. Use .crossVectors( a, b ) instead."),this.crossVectors(t,e);var i=this.x,n=this.y,r=this.z;return this.x=n*t.z-r*t.y,this.y=r*t.x-i*t.z,this.z=i*t.y-n*t.x,this},crossVectors:function(t,e){var i=t.x,n=t.y,r=t.z,o=e.x,a=e.y,s=e.z;return this.x=n*s-r*a,this.y=r*o-i*s,this.z=i*a-n*o,this},projectOnVector:function(t){var e=t.dot(this)/t.lengthSq();return this.copy(t).multiplyScalar(e)},projectOnPlane:function(){var t;return function(e){return void 0===t&&(t=new N),t.copy(this).projectOnVector(e),this.sub(t)}}(),reflect:function(){var t;return function(e){return void 0===t&&(t=new N),this.sub(t.copy(e).multiplyScalar(2*this.dot(e)))}}(),angleTo:function(t){var e=this.dot(t)/Math.sqrt(this.lengthSq()*t.lengthSq());return Math.acos(dd.clamp(e,-1,1))},distanceTo:function(t){return Math.sqrt(this.distanceToSquared(t))},distanceToSquared:function(t){var e=this.x-t.x,i=this.y-t.y,n=this.z-t.z;return e*e+i*i+n*n},distanceToManhattan:function(t){return Math.abs(this.x-t.x)+Math.abs(this.y-t.y)+Math.abs(this.z-t.z)},setFromSpherical:function(t){var e=Math.sin(t.phi)*t.radius;return this.x=e*Math.sin(t.theta),this.y=Math.cos(t.phi)*t.radius,this.z=e*Math.cos(t.theta),this},setFromMatrixPosition:function(t){return this.setFromMatrixColumn(t,3)},setFromMatrixScale:function(t){var e=this.setFromMatrixColumn(t,0).length(),i=this.setFromMatrixColumn(t,1).length(),n=this.setFromMatrixColumn(t,2).length();return this.x=e,this.y=i,this.z=n,this},setFromMatrixColumn:function(t,e){if("number"==typeof t){console.warn("THREE.Vector3: setFromMatrixColumn now expects ( matrix, index ).");
	var i=t;t=e,e=i}return this.fromArray(t.elements,4*e)},equals:function(t){return t.x===this.x&&t.y===this.y&&t.z===this.z},fromArray:function(t,e){return void 0===e&&(e=0),this.x=t[e],this.y=t[e+1],this.z=t[e+2],this},toArray:function(t,e){return void 0===t&&(t=[]),void 0===e&&(e=0),t[e]=this.x,t[e+1]=this.y,t[e+2]=this.z,t},fromAttribute:function(t,e,i){return void 0===i&&(i=0),e=e*t.itemSize+i,this.x=t.array[e],this.y=t.array[e+1],this.z=t.array[e+2],this}},F.prototype={constructor:F,set:function(t,e){return this.min.copy(t),this.max.copy(e),this},setFromPoints:function(t){this.makeEmpty();for(var e=0,i=t.length;e<i;e++)this.expandByPoint(t[e]);return this},setFromCenterAndSize:function(){var t=new I;return function(e,i){var n=t.copy(i).multiplyScalar(.5);return this.min.copy(e).sub(n),this.max.copy(e).add(n),this}}(),clone:function(){return(new this.constructor).copy(this)},copy:function(t){return this.min.copy(t.min),this.max.copy(t.max),this},makeEmpty:function(){return this.min.x=this.min.y=+(1/0),this.max.x=this.max.y=-(1/0),this},isEmpty:function(){return this.max.x<this.min.x||this.max.y<this.min.y},center:function(t){var e=t||new I;return e.addVectors(this.min,this.max).multiplyScalar(.5)},size:function(t){var e=t||new I;return e.subVectors(this.max,this.min)},expandByPoint:function(t){return this.min.min(t),this.max.max(t),this},expandByVector:function(t){return this.min.sub(t),this.max.add(t),this},expandByScalar:function(t){return this.min.addScalar(-t),this.max.addScalar(t),this},containsPoint:function(t){return!(t.x<this.min.x||t.x>this.max.x||t.y<this.min.y||t.y>this.max.y)},containsBox:function(t){return this.min.x<=t.min.x&&t.max.x<=this.max.x&&this.min.y<=t.min.y&&t.max.y<=this.max.y},getParameter:function(t,e){var i=e||new I;return i.set((t.x-this.min.x)/(this.max.x-this.min.x),(t.y-this.min.y)/(this.max.y-this.min.y))},intersectsBox:function(t){return!(t.max.x<this.min.x||t.min.x>this.max.x||t.max.y<this.min.y||t.min.y>this.max.y)},clampPoint:function(t,e){var i=e||new I;return i.copy(t).clamp(this.min,this.max)},distanceToPoint:function(){var t=new I;return function(e){var i=t.copy(e).clamp(this.min,this.max);return i.sub(e).length()}}(),intersect:function(t){return this.min.max(t.min),this.max.min(t.max),this},union:function(t){return this.min.min(t.min),this.max.max(t.max),this},translate:function(t){return this.min.add(t),this.max.add(t),this},equals:function(t){return t.min.equals(this.min)&&t.max.equals(this.max)}},B.prototype=Object.create(L.prototype),B.prototype.constructor=B,B.prototype.isCubeTexture=!0,Object.defineProperty(B.prototype,"images",{get:function(){return this.image},set:function(t){this.image=t}});var pd=new L,md=new B,gd=[],vd=[];gt.prototype.setValue=function(t,e){for(var i=this.seq,n=0,r=i.length;n!==r;++n){var o=i[n];o.setValue(t,e[o.id])}};var yd=/([\w\d_]+)(\])?(\[|\.)?/g;bt.prototype.setValue=function(t,e,i){var n=this.map[e];void 0!==n&&n.setValue(t,i,this.renderer)},bt.prototype.set=function(t,e,i){var n=this.map[i];void 0!==n&&n.setValue(t,e[i],this.renderer)},bt.prototype.setOptional=function(t,e,i){var n=e[i];void 0!==n&&this.setValue(t,i,n)},bt.upload=function(t,e,i,n){for(var r=0,o=e.length;r!==o;++r){var a=e[r],s=i[a.id];s.needsUpdate!==!1&&a.setValue(t,s.value,n)}},bt.seqWithValue=function(t,e){for(var i=[],n=0,r=t.length;n!==r;++n){var o=t[n];o.id in e&&i.push(o)}return i},bt.splitDynamic=function(t,e){for(var i=null,n=t.length,r=0,o=0;o!==n;++o){var a=t[o],s=e[a.id];s&&s.dynamic===!0?(null===i&&(i=[]),i.push(a)):(r<o&&(t[r]=a),++r)}return r<n&&(t.length=r),i},bt.evalDynamic=function(t,e,i,n){for(var r=0,o=t.length;r!==o;++r){var a=e[t[r].id],s=a.onUpdateCallback;void 0!==s&&s.call(a,i,n)}},_t.prototype={constructor:_t,isVector4:!0,set:function(t,e,i,n){return this.x=t,this.y=e,this.z=i,this.w=n,this},setScalar:function(t){return this.x=t,this.y=t,this.z=t,this.w=t,this},setX:function(t){return this.x=t,this},setY:function(t){return this.y=t,this},setZ:function(t){return this.z=t,this},setW:function(t){return this.w=t,this},setComponent:function(t,e){switch(t){case 0:this.x=e;break;case 1:this.y=e;break;case 2:this.z=e;break;case 3:this.w=e;break;default:throw new Error("index is out of range: "+t)}},getComponent:function(t){switch(t){case 0:return this.x;case 1:return this.y;case 2:return this.z;case 3:return this.w;default:throw new Error("index is out of range: "+t)}},clone:function(){return new this.constructor(this.x,this.y,this.z,this.w)},copy:function(t){return this.x=t.x,this.y=t.y,this.z=t.z,this.w=void 0!==t.w?t.w:1,this},add:function(t,e){return void 0!==e?(console.warn("THREE.Vector4: .add() now only accepts one argument. Use .addVectors( a, b ) instead."),this.addVectors(t,e)):(this.x+=t.x,this.y+=t.y,this.z+=t.z,this.w+=t.w,this)},addScalar:function(t){return this.x+=t,this.y+=t,this.z+=t,this.w+=t,this},addVectors:function(t,e){return this.x=t.x+e.x,this.y=t.y+e.y,this.z=t.z+e.z,this.w=t.w+e.w,this},addScaledVector:function(t,e){return this.x+=t.x*e,this.y+=t.y*e,this.z+=t.z*e,this.w+=t.w*e,this},sub:function(t,e){return void 0!==e?(console.warn("THREE.Vector4: .sub() now only accepts one argument. Use .subVectors( a, b ) instead."),this.subVectors(t,e)):(this.x-=t.x,this.y-=t.y,this.z-=t.z,this.w-=t.w,this)},subScalar:function(t){return this.x-=t,this.y-=t,this.z-=t,this.w-=t,this},subVectors:function(t,e){return this.x=t.x-e.x,this.y=t.y-e.y,this.z=t.z-e.z,this.w=t.w-e.w,this},multiplyScalar:function(t){return isFinite(t)?(this.x*=t,this.y*=t,this.z*=t,this.w*=t):(this.x=0,this.y=0,this.z=0,this.w=0),this},applyMatrix4:function(t){var e=this.x,i=this.y,n=this.z,r=this.w,o=t.elements;return this.x=o[0]*e+o[4]*i+o[8]*n+o[12]*r,this.y=o[1]*e+o[5]*i+o[9]*n+o[13]*r,this.z=o[2]*e+o[6]*i+o[10]*n+o[14]*r,this.w=o[3]*e+o[7]*i+o[11]*n+o[15]*r,this},divideScalar:function(t){return this.multiplyScalar(1/t)},setAxisAngleFromQuaternion:function(t){this.w=2*Math.acos(t.w);var e=Math.sqrt(1-t.w*t.w);return e<1e-4?(this.x=1,this.y=0,this.z=0):(this.x=t.x/e,this.y=t.y/e,this.z=t.z/e),this},setAxisAngleFromRotationMatrix:function(t){var e,i,n,r,o=.01,a=.1,s=t.elements,c=s[0],u=s[4],h=s[8],l=s[1],d=s[5],f=s[9],p=s[2],m=s[6],g=s[10];if(Math.abs(u-l)<o&&Math.abs(h-p)<o&&Math.abs(f-m)<o){if(Math.abs(u+l)<a&&Math.abs(h+p)<a&&Math.abs(f+m)<a&&Math.abs(c+d+g-3)<a)return this.set(1,0,0,0),this;e=Math.PI;var v=(c+1)/2,y=(d+1)/2,b=(g+1)/2,x=(u+l)/4,_=(h+p)/4,w=(f+m)/4;return v>y&&v>b?v<o?(i=0,n=.707106781,r=.707106781):(i=Math.sqrt(v),n=x/i,r=_/i):y>b?y<o?(i=.707106781,n=0,r=.707106781):(n=Math.sqrt(y),i=x/n,r=w/n):b<o?(i=.707106781,n=.707106781,r=0):(r=Math.sqrt(b),i=_/r,n=w/r),this.set(i,n,r,e),this}var S=Math.sqrt((m-f)*(m-f)+(h-p)*(h-p)+(l-u)*(l-u));return Math.abs(S)<.001&&(S=1),this.x=(m-f)/S,this.y=(h-p)/S,this.z=(l-u)/S,this.w=Math.acos((c+d+g-1)/2),this},min:function(t){return this.x=Math.min(this.x,t.x),this.y=Math.min(this.y,t.y),this.z=Math.min(this.z,t.z),this.w=Math.min(this.w,t.w),this},max:function(t){return this.x=Math.max(this.x,t.x),this.y=Math.max(this.y,t.y),this.z=Math.max(this.z,t.z),this.w=Math.max(this.w,t.w),this},clamp:function(t,e){return this.x=Math.max(t.x,Math.min(e.x,this.x)),this.y=Math.max(t.y,Math.min(e.y,this.y)),this.z=Math.max(t.z,Math.min(e.z,this.z)),this.w=Math.max(t.w,Math.min(e.w,this.w)),this},clampScalar:function(){var t,e;return function(i,n){return void 0===t&&(t=new _t,e=new _t),t.set(i,i,i,i),e.set(n,n,n,n),this.clamp(t,e)}}(),floor:function(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this.z=Math.floor(this.z),this.w=Math.floor(this.w),this},ceil:function(){return this.x=Math.ceil(this.x),this.y=Math.ceil(this.y),this.z=Math.ceil(this.z),this.w=Math.ceil(this.w),this},round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this.z=Math.round(this.z),this.w=Math.round(this.w),this},roundToZero:function(){return this.x=this.x<0?Math.ceil(this.x):Math.floor(this.x),this.y=this.y<0?Math.ceil(this.y):Math.floor(this.y),this.z=this.z<0?Math.ceil(this.z):Math.floor(this.z),this.w=this.w<0?Math.ceil(this.w):Math.floor(this.w),this},negate:function(){return this.x=-this.x,this.y=-this.y,this.z=-this.z,this.w=-this.w,this},dot:function(t){return this.x*t.x+this.y*t.y+this.z*t.z+this.w*t.w},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)},lengthManhattan:function(){return Math.abs(this.x)+Math.abs(this.y)+Math.abs(this.z)+Math.abs(this.w)},normalize:function(){return this.divideScalar(this.length())},setLength:function(t){return this.multiplyScalar(t/this.length())},lerp:function(t,e){return this.x+=(t.x-this.x)*e,this.y+=(t.y-this.y)*e,this.z+=(t.z-this.z)*e,this.w+=(t.w-this.w)*e,this},lerpVectors:function(t,e,i){return this.subVectors(e,t).multiplyScalar(i).add(t)},equals:function(t){return t.x===this.x&&t.y===this.y&&t.z===this.z&&t.w===this.w},fromArray:function(t,e){return void 0===e&&(e=0),this.x=t[e],this.y=t[e+1],this.z=t[e+2],this.w=t[e+3],this},toArray:function(t,e){return void 0===t&&(t=[]),void 0===e&&(e=0),t[e]=this.x,t[e+1]=this.y,t[e+2]=this.z,t[e+3]=this.w,t},fromAttribute:function(t,e,i){return void 0===i&&(i=0),e=e*t.itemSize+i,this.x=t.array[e],this.y=t.array[e+1],this.z=t.array[e+2],this.w=t.array[e+3],this}},Object.assign(St.prototype,E.prototype,{isWebGLRenderTarget:!0,setSize:function(t,e){this.width===t&&this.height===e||(this.width=t,this.height=e,this.dispose()),this.viewport.set(0,0,t,e),this.scissor.set(0,0,t,e)},clone:function(){return(new this.constructor).copy(this)},copy:function(t){return this.width=t.width,this.height=t.height,this.viewport.copy(t.viewport),this.texture=t.texture.clone(),this.depthBuffer=t.depthBuffer,this.stencilBuffer=t.stencilBuffer,this.depthTexture=t.depthTexture,this},dispose:function(){this.dispatchEvent({type:"dispose"})}}),At.prototype={constructor:At,isMaterial:!0,get needsUpdate(){return this._needsUpdate},set needsUpdate(t){t===!0&&this.update(),this._needsUpdate=t},setValues:function(t){if(void 0!==t)for(var e in t){var i=t[e];if(void 0!==i){var n=this[e];void 0!==n?n&&n.isColor?n.set(i):n&&n.isVector3&&i&&i.isVector3?n.copy(i):"overdraw"===e?this[e]=Number(i):this[e]=i:console.warn("THREE."+this.type+": '"+e+"' is not a property of this material.")}else console.warn("THREE.Material: '"+e+"' parameter is undefined.")}},toJSON:function(t){function e(t){var e=[];for(var i in t){var n=t[i];delete n.metadata,e.push(n)}return e}var i=void 0===t;i&&(t={textures:{},images:{}});var n={metadata:{version:4.4,type:"Material",generator:"Material.toJSON"}};if(n.uuid=this.uuid,n.type=this.type,""!==this.name&&(n.name=this.name),this.color&&this.color.isColor&&(n.color=this.color.getHex()),void 0!==this.roughness&&(n.roughness=this.roughness),void 0!==this.metalness&&(n.metalness=this.metalness),this.emissive&&this.emissive.isColor&&(n.emissive=this.emissive.getHex()),this.specular&&this.specular.isColor&&(n.specular=this.specular.getHex()),void 0!==this.shininess&&(n.shininess=this.shininess),this.map&&this.map.isTexture&&(n.map=this.map.toJSON(t).uuid),this.alphaMap&&this.alphaMap.isTexture&&(n.alphaMap=this.alphaMap.toJSON(t).uuid),this.lightMap&&this.lightMap.isTexture&&(n.lightMap=this.lightMap.toJSON(t).uuid),this.bumpMap&&this.bumpMap.isTexture&&(n.bumpMap=this.bumpMap.toJSON(t).uuid,n.bumpScale=this.bumpScale),this.normalMap&&this.normalMap.isTexture&&(n.normalMap=this.normalMap.toJSON(t).uuid,n.normalScale=this.normalScale.toArray()),this.displacementMap&&this.displacementMap.isTexture&&(n.displacementMap=this.displacementMap.toJSON(t).uuid,n.displacementScale=this.displacementScale,n.displacementBias=this.displacementBias),this.roughnessMap&&this.roughnessMap.isTexture&&(n.roughnessMap=this.roughnessMap.toJSON(t).uuid),this.metalnessMap&&this.metalnessMap.isTexture&&(n.metalnessMap=this.metalnessMap.toJSON(t).uuid),this.emissiveMap&&this.emissiveMap.isTexture&&(n.emissiveMap=this.emissiveMap.toJSON(t).uuid),this.specularMap&&this.specularMap.isTexture&&(n.specularMap=this.specularMap.toJSON(t).uuid),this.envMap&&this.envMap.isTexture&&(n.envMap=this.envMap.toJSON(t).uuid,n.reflectivity=this.reflectivity),void 0!==this.size&&(n.size=this.size),void 0!==this.sizeAttenuation&&(n.sizeAttenuation=this.sizeAttenuation),this.blending!==vh&&(n.blending=this.blending),this.shading!==dh&&(n.shading=this.shading),this.side!==ch&&(n.side=this.side),this.vertexColors!==fh&&(n.vertexColors=this.vertexColors),this.opacity<1&&(n.opacity=this.opacity),this.transparent===!0&&(n.transparent=this.transparent),n.depthFunc=this.depthFunc,n.depthTest=this.depthTest,n.depthWrite=this.depthWrite,this.alphaTest>0&&(n.alphaTest=this.alphaTest),this.premultipliedAlpha===!0&&(n.premultipliedAlpha=this.premultipliedAlpha),this.wireframe===!0&&(n.wireframe=this.wireframe),this.wireframeLinewidth>1&&(n.wireframeLinewidth=this.wireframeLinewidth),"round"!==this.wireframeLinecap&&(n.wireframeLinecap=this.wireframeLinecap),"round"!==this.wireframeLinejoin&&(n.wireframeLinejoin=this.wireframeLinejoin),n.skinning=this.skinning,n.morphTargets=this.morphTargets,i){var r=e(t.textures),o=e(t.images);r.length>0&&(n.textures=r),o.length>0&&(n.images=o)}return n},clone:function(){return(new this.constructor).copy(this)},copy:function(t){this.name=t.name,this.fog=t.fog,this.lights=t.lights,this.blending=t.blending,this.side=t.side,this.shading=t.shading,this.vertexColors=t.vertexColors,this.opacity=t.opacity,this.transparent=t.transparent,this.blendSrc=t.blendSrc,this.blendDst=t.blendDst,this.blendEquation=t.blendEquation,this.blendSrcAlpha=t.blendSrcAlpha,this.blendDstAlpha=t.blendDstAlpha,this.blendEquationAlpha=t.blendEquationAlpha,this.depthFunc=t.depthFunc,this.depthTest=t.depthTest,this.depthWrite=t.depthWrite,this.colorWrite=t.colorWrite,this.precision=t.precision,this.polygonOffset=t.polygonOffset,this.polygonOffsetFactor=t.polygonOffsetFactor,this.polygonOffsetUnits=t.polygonOffsetUnits,this.alphaTest=t.alphaTest,this.premultipliedAlpha=t.premultipliedAlpha,this.overdraw=t.overdraw,this.visible=t.visible,this.clipShadows=t.clipShadows;var e=t.clippingPlanes,i=null;if(null!==e){var n=e.length;i=new Array(n);for(var r=0;r!==n;++r)i[r]=e[r].clone()}return this.clippingPlanes=i,this},update:function(){this.dispatchEvent({type:"update"})},dispose:function(){this.dispatchEvent({type:"dispose"})}},Object.assign(At.prototype,E.prototype);var bd=0,xd={merge:function(t){for(var e={},i=0;i<t.length;i++){var n=this.clone(t[i]);for(var r in n)e[r]=n[r]}return e},clone:function(t){var e={};for(var i in t){e[i]={};for(var n in t[i]){var r=t[i][n];r&&r.isColor||r&&r.isVector2||r&&r.isVector3||r&&r.isVector4||r&&r.isMatrix3||r&&r.isMatrix4||r&&r.isTexture?e[i][n]=r.clone():Array.isArray(r)?e[i][n]=r.slice():e[i][n]=r}}return e}};Ct.prototype=Object.create(At.prototype),Ct.prototype.constructor=Ct,Ct.prototype.isShaderMaterial=!0,Ct.prototype.copy=function(t){return At.prototype.copy.call(this,t),this.fragmentShader=t.fragmentShader,this.vertexShader=t.vertexShader,this.uniforms=xd.clone(t.uniforms),this.defines=t.defines,this.wireframe=t.wireframe,this.wireframeLinewidth=t.wireframeLinewidth,this.lights=t.lights,this.clipping=t.clipping,this.skinning=t.skinning,this.morphTargets=t.morphTargets,this.morphNormals=t.morphNormals,this.extensions=t.extensions,this},Ct.prototype.toJSON=function(t){var e=At.prototype.toJSON.call(this,t);return e.uniforms=this.uniforms,e.vertexShader=this.vertexShader,e.fragmentShader=this.fragmentShader,e};var _d="#ifdef USE_ALPHAMAP\n\tdiffuseColor.a *= texture2D( alphaMap, vUv ).g;\n#endif\n",wd="#ifdef USE_ALPHAMAP\n\tuniform sampler2D alphaMap;\n#endif\n",Sd="#ifdef ALPHATEST\n\tif ( diffuseColor.a < ALPHATEST ) discard;\n#endif\n",Ad="#ifdef USE_AOMAP\n\tfloat ambientOcclusion = ( texture2D( aoMap, vUv2 ).r - 1.0 ) * aoMapIntensity + 1.0;\n\treflectedLight.indirectDiffuse *= ambientOcclusion;\n\t#if defined( USE_ENVMAP ) && defined( PHYSICAL )\n\t\tfloat dotNV = saturate( dot( geometry.normal, geometry.viewDir ) );\n\t\treflectedLight.indirectSpecular *= computeSpecularOcclusion( dotNV, ambientOcclusion, material.specularRoughness );\n\t#endif\n#endif\n",Md="#ifdef USE_AOMAP\n\tuniform sampler2D aoMap;\n\tuniform float aoMapIntensity;\n#endif",Cd="\nvec3 transformed = vec3( position );\n",Pd="\nvec3 objectNormal = vec3( normal );\n",Td="bool testLightInRange( const in float lightDistance, const in float cutoffDistance ) {\n\treturn any( bvec2( cutoffDistance == 0.0, lightDistance < cutoffDistance ) );\n}\nfloat punctualLightIntensityToIrradianceFactor( const in float lightDistance, const in float cutoffDistance, const in float decayExponent ) {\n\t\tif( decayExponent > 0.0 ) {\n#if defined ( PHYSICALLY_CORRECT_LIGHTS )\n\t\t\tfloat distanceFalloff = 1.0 / max( pow( lightDistance, decayExponent ), 0.01 );\n\t\t\tfloat maxDistanceCutoffFactor = pow2( saturate( 1.0 - pow4( lightDistance / cutoffDistance ) ) );\n\t\t\treturn distanceFalloff * maxDistanceCutoffFactor;\n#else\n\t\t\treturn pow( saturate( -lightDistance / cutoffDistance + 1.0 ), decayExponent );\n#endif\n\t\t}\n\t\treturn 1.0;\n}\nvec3 BRDF_Diffuse_Lambert( const in vec3 diffuseColor ) {\n\treturn RECIPROCAL_PI * diffuseColor;\n}\nvec3 F_Schlick( const in vec3 specularColor, const in float dotLH ) {\n\tfloat fresnel = exp2( ( -5.55473 * dotLH - 6.98316 ) * dotLH );\n\treturn ( 1.0 - specularColor ) * fresnel + specularColor;\n}\nfloat G_GGX_Smith( const in float alpha, const in float dotNL, const in float dotNV ) {\n\tfloat a2 = pow2( alpha );\n\tfloat gl = dotNL + sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNL ) );\n\tfloat gv = dotNV + sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNV ) );\n\treturn 1.0 / ( gl * gv );\n}\nfloat G_GGX_SmithCorrelated( const in float alpha, const in float dotNL, const in float dotNV ) {\n\tfloat a2 = pow2( alpha );\n\tfloat gv = dotNL * sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNV ) );\n\tfloat gl = dotNV * sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNL ) );\n\treturn 0.5 / max( gv + gl, EPSILON );\n}\nfloat D_GGX( const in float alpha, const in float dotNH ) {\n\tfloat a2 = pow2( alpha );\n\tfloat denom = pow2( dotNH ) * ( a2 - 1.0 ) + 1.0;\n\treturn RECIPROCAL_PI * a2 / pow2( denom );\n}\nvec3 BRDF_Specular_GGX( const in IncidentLight incidentLight, const in GeometricContext geometry, const in vec3 specularColor, const in float roughness ) {\n\tfloat alpha = pow2( roughness );\n\tvec3 halfDir = normalize( incidentLight.direction + geometry.viewDir );\n\tfloat dotNL = saturate( dot( geometry.normal, incidentLight.direction ) );\n\tfloat dotNV = saturate( dot( geometry.normal, geometry.viewDir ) );\n\tfloat dotNH = saturate( dot( geometry.normal, halfDir ) );\n\tfloat dotLH = saturate( dot( incidentLight.direction, halfDir ) );\n\tvec3 F = F_Schlick( specularColor, dotLH );\n\tfloat G = G_GGX_SmithCorrelated( alpha, dotNL, dotNV );\n\tfloat D = D_GGX( alpha, dotNH );\n\treturn F * ( G * D );\n}\nvec3 BRDF_Specular_GGX_Environment( const in GeometricContext geometry, const in vec3 specularColor, const in float roughness ) {\n\tfloat dotNV = saturate( dot( geometry.normal, geometry.viewDir ) );\n\tconst vec4 c0 = vec4( - 1, - 0.0275, - 0.572, 0.022 );\n\tconst vec4 c1 = vec4( 1, 0.0425, 1.04, - 0.04 );\n\tvec4 r = roughness * c0 + c1;\n\tfloat a004 = min( r.x * r.x, exp2( - 9.28 * dotNV ) ) * r.x + r.y;\n\tvec2 AB = vec2( -1.04, 1.04 ) * a004 + r.zw;\n\treturn specularColor * AB.x + AB.y;\n}\nfloat G_BlinnPhong_Implicit( ) {\n\treturn 0.25;\n}\nfloat D_BlinnPhong( const in float shininess, const in float dotNH ) {\n\treturn RECIPROCAL_PI * ( shininess * 0.5 + 1.0 ) * pow( dotNH, shininess );\n}\nvec3 BRDF_Specular_BlinnPhong( const in IncidentLight incidentLight, const in GeometricContext geometry, const in vec3 specularColor, const in float shininess ) {\n\tvec3 halfDir = normalize( incidentLight.direction + geometry.viewDir );\n\tfloat dotNH = saturate( dot( geometry.normal, halfDir ) );\n\tfloat dotLH = saturate( dot( incidentLight.direction, halfDir ) );\n\tvec3 F = F_Schlick( specularColor, dotLH );\n\tfloat G = G_BlinnPhong_Implicit( );\n\tfloat D = D_BlinnPhong( shininess, dotNH );\n\treturn F * ( G * D );\n}\nfloat GGXRoughnessToBlinnExponent( const in float ggxRoughness ) {\n\treturn ( 2.0 / pow2( ggxRoughness + 0.0001 ) - 2.0 );\n}\nfloat BlinnExponentToGGXRoughness( const in float blinnExponent ) {\n\treturn sqrt( 2.0 / ( blinnExponent + 2.0 ) );\n}\n",Ed="#ifdef USE_BUMPMAP\n\tuniform sampler2D bumpMap;\n\tuniform float bumpScale;\n\tvec2 dHdxy_fwd() {\n\t\tvec2 dSTdx = dFdx( vUv );\n\t\tvec2 dSTdy = dFdy( vUv );\n\t\tfloat Hll = bumpScale * texture2D( bumpMap, vUv ).x;\n\t\tfloat dBx = bumpScale * texture2D( bumpMap, vUv + dSTdx ).x - Hll;\n\t\tfloat dBy = bumpScale * texture2D( bumpMap, vUv + dSTdy ).x - Hll;\n\t\treturn vec2( dBx, dBy );\n\t}\n\tvec3 perturbNormalArb( vec3 surf_pos, vec3 surf_norm, vec2 dHdxy ) {\n\t\tvec3 vSigmaX = dFdx( surf_pos );\n\t\tvec3 vSigmaY = dFdy( surf_pos );\n\t\tvec3 vN = surf_norm;\n\t\tvec3 R1 = cross( vSigmaY, vN );\n\t\tvec3 R2 = cross( vN, vSigmaX );\n\t\tfloat fDet = dot( vSigmaX, R1 );\n\t\tvec3 vGrad = sign( fDet ) * ( dHdxy.x * R1 + dHdxy.y * R2 );\n\t\treturn normalize( abs( fDet ) * surf_norm - vGrad );\n\t}\n#endif\n",Id="#if NUM_CLIPPING_PLANES > 0\n\tfor ( int i = 0; i < NUM_CLIPPING_PLANES; ++ i ) {\n\t\tvec4 plane = clippingPlanes[ i ];\n\t\tif ( dot( vViewPosition, plane.xyz ) > plane.w ) discard;\n\t}\n#endif\n",Ld="#if NUM_CLIPPING_PLANES > 0\n\t#if ! defined( PHYSICAL ) && ! defined( PHONG )\n\t\tvarying vec3 vViewPosition;\n\t#endif\n\tuniform vec4 clippingPlanes[ NUM_CLIPPING_PLANES ];\n#endif\n",Rd="#if NUM_CLIPPING_PLANES > 0 && ! defined( PHYSICAL ) && ! defined( PHONG )\n\tvarying vec3 vViewPosition;\n#endif\n",Od="#if NUM_CLIPPING_PLANES > 0 && ! defined( PHYSICAL ) && ! defined( PHONG )\n\tvViewPosition = - mvPosition.xyz;\n#endif\n",Dd="#ifdef USE_COLOR\n\tdiffuseColor.rgb *= vColor;\n#endif",Nd="#ifdef USE_COLOR\n\tvarying vec3 vColor;\n#endif\n",kd="#ifdef USE_COLOR\n\tvarying vec3 vColor;\n#endif",Fd="#ifdef USE_COLOR\n\tvColor.xyz = color.xyz;\n#endif",zd="#define PI 3.14159265359\n#define PI2 6.28318530718\n#define RECIPROCAL_PI 0.31830988618\n#define RECIPROCAL_PI2 0.15915494\n#define LOG2 1.442695\n#define EPSILON 1e-6\n#define saturate(a) clamp( a, 0.0, 1.0 )\n#define whiteCompliment(a) ( 1.0 - saturate( a ) )\nfloat pow2( const in float x ) { return x*x; }\nfloat pow3( const in float x ) { return x*x*x; }\nfloat pow4( const in float x ) { float x2 = x*x; return x2*x2; }\nfloat average( const in vec3 color ) { return dot( color, vec3( 0.3333 ) ); }\nhighp float rand( const in vec2 uv ) {\n\tconst highp float a = 12.9898, b = 78.233, c = 43758.5453;\n\thighp float dt = dot( uv.xy, vec2( a,b ) ), sn = mod( dt, PI );\n\treturn fract(sin(sn) * c);\n}\nstruct IncidentLight {\n\tvec3 color;\n\tvec3 direction;\n\tbool visible;\n};\nstruct ReflectedLight {\n\tvec3 directDiffuse;\n\tvec3 directSpecular;\n\tvec3 indirectDiffuse;\n\tvec3 indirectSpecular;\n};\nstruct GeometricContext {\n\tvec3 position;\n\tvec3 normal;\n\tvec3 viewDir;\n};\nvec3 transformDirection( in vec3 dir, in mat4 matrix ) {\n\treturn normalize( ( matrix * vec4( dir, 0.0 ) ).xyz );\n}\nvec3 inverseTransformDirection( in vec3 dir, in mat4 matrix ) {\n\treturn normalize( ( vec4( dir, 0.0 ) * matrix ).xyz );\n}\nvec3 projectOnPlane(in vec3 point, in vec3 pointOnPlane, in vec3 planeNormal ) {\n\tfloat distance = dot( planeNormal, point - pointOnPlane );\n\treturn - distance * planeNormal + point;\n}\nfloat sideOfPlane( in vec3 point, in vec3 pointOnPlane, in vec3 planeNormal ) {\n\treturn sign( dot( point - pointOnPlane, planeNormal ) );\n}\nvec3 linePlaneIntersect( in vec3 pointOnLine, in vec3 lineDirection, in vec3 pointOnPlane, in vec3 planeNormal ) {\n\treturn lineDirection * ( dot( planeNormal, pointOnPlane - pointOnLine ) / dot( planeNormal, lineDirection ) ) + pointOnLine;\n}\n",Bd="#ifdef ENVMAP_TYPE_CUBE_UV\n#define cubeUV_textureSize (1024.0)\nint getFaceFromDirection(vec3 direction) {\n\tvec3 absDirection = abs(direction);\n\tint face = -1;\n\tif( absDirection.x > absDirection.z ) {\n\t\tif(absDirection.x > absDirection.y )\n\t\t\tface = direction.x > 0.0 ? 0 : 3;\n\t\telse\n\t\t\tface = direction.y > 0.0 ? 1 : 4;\n\t}\n\telse {\n\t\tif(absDirection.z > absDirection.y )\n\t\t\tface = direction.z > 0.0 ? 2 : 5;\n\t\telse\n\t\t\tface = direction.y > 0.0 ? 1 : 4;\n\t}\n\treturn face;\n}\n#define cubeUV_maxLods1  (log2(cubeUV_textureSize*0.25) - 1.0)\n#define cubeUV_rangeClamp (exp2((6.0 - 1.0) * 2.0))\nvec2 MipLevelInfo( vec3 vec, float roughnessLevel, float roughness ) {\n\tfloat scale = exp2(cubeUV_maxLods1 - roughnessLevel);\n\tfloat dxRoughness = dFdx(roughness);\n\tfloat dyRoughness = dFdy(roughness);\n\tvec3 dx = dFdx( vec * scale * dxRoughness );\n\tvec3 dy = dFdy( vec * scale * dyRoughness );\n\tfloat d = max( dot( dx, dx ), dot( dy, dy ) );\n\td = clamp(d, 1.0, cubeUV_rangeClamp);\n\tfloat mipLevel = 0.5 * log2(d);\n\treturn vec2(floor(mipLevel), fract(mipLevel));\n}\n#define cubeUV_maxLods2 (log2(cubeUV_textureSize*0.25) - 2.0)\n#define cubeUV_rcpTextureSize (1.0 / cubeUV_textureSize)\nvec2 getCubeUV(vec3 direction, float roughnessLevel, float mipLevel) {\n\tmipLevel = roughnessLevel > cubeUV_maxLods2 - 3.0 ? 0.0 : mipLevel;\n\tfloat a = 16.0 * cubeUV_rcpTextureSize;\n\tvec2 exp2_packed = exp2( vec2( roughnessLevel, mipLevel ) );\n\tvec2 rcp_exp2_packed = vec2( 1.0 ) / exp2_packed;\n\tfloat powScale = exp2_packed.x * exp2_packed.y;\n\tfloat scale = rcp_exp2_packed.x * rcp_exp2_packed.y * 0.25;\n\tfloat mipOffset = 0.75*(1.0 - rcp_exp2_packed.y) * rcp_exp2_packed.x;\n\tbool bRes = mipLevel == 0.0;\n\tscale =  bRes && (scale < a) ? a : scale;\n\tvec3 r;\n\tvec2 offset;\n\tint face = getFaceFromDirection(direction);\n\tfloat rcpPowScale = 1.0 / powScale;\n\tif( face == 0) {\n\t\tr = vec3(direction.x, -direction.z, direction.y);\n\t\toffset = vec2(0.0+mipOffset,0.75 * rcpPowScale);\n\t\toffset.y = bRes && (offset.y < 2.0*a) ?  a : offset.y;\n\t}\n\telse if( face == 1) {\n\t\tr = vec3(direction.y, direction.x, direction.z);\n\t\toffset = vec2(scale+mipOffset, 0.75 * rcpPowScale);\n\t\toffset.y = bRes && (offset.y < 2.0*a) ?  a : offset.y;\n\t}\n\telse if( face == 2) {\n\t\tr = vec3(direction.z, direction.x, direction.y);\n\t\toffset = vec2(2.0*scale+mipOffset, 0.75 * rcpPowScale);\n\t\toffset.y = bRes && (offset.y < 2.0*a) ?  a : offset.y;\n\t}\n\telse if( face == 3) {\n\t\tr = vec3(direction.x, direction.z, direction.y);\n\t\toffset = vec2(0.0+mipOffset,0.5 * rcpPowScale);\n\t\toffset.y = bRes && (offset.y < 2.0*a) ?  0.0 : offset.y;\n\t}\n\telse if( face == 4) {\n\t\tr = vec3(direction.y, direction.x, -direction.z);\n\t\toffset = vec2(scale+mipOffset, 0.5 * rcpPowScale);\n\t\toffset.y = bRes && (offset.y < 2.0*a) ?  0.0 : offset.y;\n\t}\n\telse {\n\t\tr = vec3(direction.z, -direction.x, direction.y);\n\t\toffset = vec2(2.0*scale+mipOffset, 0.5 * rcpPowScale);\n\t\toffset.y = bRes && (offset.y < 2.0*a) ?  0.0 : offset.y;\n\t}\n\tr = normalize(r);\n\tfloat texelOffset = 0.5 * cubeUV_rcpTextureSize;\n\tvec2 s = ( r.yz / abs( r.x ) + vec2( 1.0 ) ) * 0.5;\n\tvec2 base = offset + vec2( texelOffset );\n\treturn base + s * ( scale - 2.0 * texelOffset );\n}\n#define cubeUV_maxLods3 (log2(cubeUV_textureSize*0.25) - 3.0)\nvec4 textureCubeUV(vec3 reflectedDirection, float roughness ) {\n\tfloat roughnessVal = roughness* cubeUV_maxLods3;\n\tfloat r1 = floor(roughnessVal);\n\tfloat r2 = r1 + 1.0;\n\tfloat t = fract(roughnessVal);\n\tvec2 mipInfo = MipLevelInfo(reflectedDirection, r1, roughness);\n\tfloat s = mipInfo.y;\n\tfloat level0 = mipInfo.x;\n\tfloat level1 = level0 + 1.0;\n\tlevel1 = level1 > 5.0 ? 5.0 : level1;\n\tlevel0 += min( floor( s + 0.5 ), 5.0 );\n\tvec2 uv_10 = getCubeUV(reflectedDirection, r1, level0);\n\tvec4 color10 = envMapTexelToLinear(texture2D(envMap, uv_10));\n\tvec2 uv_20 = getCubeUV(reflectedDirection, r2, level0);\n\tvec4 color20 = envMapTexelToLinear(texture2D(envMap, uv_20));\n\tvec4 result = mix(color10, color20, t);\n\treturn vec4(result.rgb, 1.0);\n}\n#endif\n",Ud="#ifdef FLIP_SIDED\n\tobjectNormal = -objectNormal;\n#endif\nvec3 transformedNormal = normalMatrix * objectNormal;\n",jd="#ifdef USE_DISPLACEMENTMAP\n\tuniform sampler2D displacementMap;\n\tuniform float displacementScale;\n\tuniform float displacementBias;\n#endif\n",$d="#ifdef USE_DISPLACEMENTMAP\n\ttransformed += normal * ( texture2D( displacementMap, uv ).x * displacementScale + displacementBias );\n#endif\n",Vd="#ifdef USE_EMISSIVEMAP\n\tvec4 emissiveColor = texture2D( emissiveMap, vUv );\n\temissiveColor.rgb = emissiveMapTexelToLinear( emissiveColor ).rgb;\n\ttotalEmissiveRadiance *= emissiveColor.rgb;\n#endif\n",Gd="#ifdef USE_EMISSIVEMAP\n\tuniform sampler2D emissiveMap;\n#endif\n",Hd="  gl_FragColor = linearToOutputTexel( gl_FragColor );\n",Wd="\nvec4 LinearToLinear( in vec4 value ) {\n  return value;\n}\nvec4 GammaToLinear( in vec4 value, in float gammaFactor ) {\n  return vec4( pow( value.xyz, vec3( gammaFactor ) ), value.w );\n}\nvec4 LinearToGamma( in vec4 value, in float gammaFactor ) {\n  return vec4( pow( value.xyz, vec3( 1.0 / gammaFactor ) ), value.w );\n}\nvec4 sRGBToLinear( in vec4 value ) {\n  return vec4( mix( pow( value.rgb * 0.9478672986 + vec3( 0.0521327014 ), vec3( 2.4 ) ), value.rgb * 0.0773993808, vec3( lessThanEqual( value.rgb, vec3( 0.04045 ) ) ) ), value.w );\n}\nvec4 LinearTosRGB( in vec4 value ) {\n  return vec4( mix( pow( value.rgb, vec3( 0.41666 ) ) * 1.055 - vec3( 0.055 ), value.rgb * 12.92, vec3( lessThanEqual( value.rgb, vec3( 0.0031308 ) ) ) ), value.w );\n}\nvec4 RGBEToLinear( in vec4 value ) {\n  return vec4( value.rgb * exp2( value.a * 255.0 - 128.0 ), 1.0 );\n}\nvec4 LinearToRGBE( in vec4 value ) {\n  float maxComponent = max( max( value.r, value.g ), value.b );\n  float fExp = clamp( ceil( log2( maxComponent ) ), -128.0, 127.0 );\n  return vec4( value.rgb / exp2( fExp ), ( fExp + 128.0 ) / 255.0 );\n}\nvec4 RGBMToLinear( in vec4 value, in float maxRange ) {\n  return vec4( value.xyz * value.w * maxRange, 1.0 );\n}\nvec4 LinearToRGBM( in vec4 value, in float maxRange ) {\n  float maxRGB = max( value.x, max( value.g, value.b ) );\n  float M      = clamp( maxRGB / maxRange, 0.0, 1.0 );\n  M            = ceil( M * 255.0 ) / 255.0;\n  return vec4( value.rgb / ( M * maxRange ), M );\n}\nvec4 RGBDToLinear( in vec4 value, in float maxRange ) {\n    return vec4( value.rgb * ( ( maxRange / 255.0 ) / value.a ), 1.0 );\n}\nvec4 LinearToRGBD( in vec4 value, in float maxRange ) {\n    float maxRGB = max( value.x, max( value.g, value.b ) );\n    float D      = max( maxRange / maxRGB, 1.0 );\n    D            = min( floor( D ) / 255.0, 1.0 );\n    return vec4( value.rgb * ( D * ( 255.0 / maxRange ) ), D );\n}\nconst mat3 cLogLuvM = mat3( 0.2209, 0.3390, 0.4184, 0.1138, 0.6780, 0.7319, 0.0102, 0.1130, 0.2969 );\nvec4 LinearToLogLuv( in vec4 value )  {\n  vec3 Xp_Y_XYZp = value.rgb * cLogLuvM;\n  Xp_Y_XYZp = max(Xp_Y_XYZp, vec3(1e-6, 1e-6, 1e-6));\n  vec4 vResult;\n  vResult.xy = Xp_Y_XYZp.xy / Xp_Y_XYZp.z;\n  float Le = 2.0 * log2(Xp_Y_XYZp.y) + 127.0;\n  vResult.w = fract(Le);\n  vResult.z = (Le - (floor(vResult.w*255.0))/255.0)/255.0;\n  return vResult;\n}\nconst mat3 cLogLuvInverseM = mat3( 6.0014, -2.7008, -1.7996, -1.3320, 3.1029, -5.7721, 0.3008, -1.0882, 5.6268 );\nvec4 LogLuvToLinear( in vec4 value ) {\n  float Le = value.z * 255.0 + value.w;\n  vec3 Xp_Y_XYZp;\n  Xp_Y_XYZp.y = exp2((Le - 127.0) / 2.0);\n  Xp_Y_XYZp.z = Xp_Y_XYZp.y / value.y;\n  Xp_Y_XYZp.x = value.x * Xp_Y_XYZp.z;\n  vec3 vRGB = Xp_Y_XYZp.rgb * cLogLuvInverseM;\n  return vec4( max(vRGB, 0.0), 1.0 );\n}\n",Xd="#ifdef USE_ENVMAP\n\t#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG )\n\t\tvec3 cameraToVertex = normalize( vWorldPosition - cameraPosition );\n\t\tvec3 worldNormal = inverseTransformDirection( normal, viewMatrix );\n\t\t#ifdef ENVMAP_MODE_REFLECTION\n\t\t\tvec3 reflectVec = reflect( cameraToVertex, worldNormal );\n\t\t#else\n\t\t\tvec3 reflectVec = refract( cameraToVertex, worldNormal, refractionRatio );\n\t\t#endif\n\t#else\n\t\tvec3 reflectVec = vReflect;\n\t#endif\n\t#ifdef ENVMAP_TYPE_CUBE\n\t\tvec4 envColor = textureCube( envMap, flipNormal * vec3( flipEnvMap * reflectVec.x, reflectVec.yz ) );\n\t#elif defined( ENVMAP_TYPE_EQUIREC )\n\t\tvec2 sampleUV;\n\t\tsampleUV.y = saturate( flipNormal * reflectVec.y * 0.5 + 0.5 );\n\t\tsampleUV.x = atan( flipNormal * reflectVec.z, flipNormal * reflectVec.x ) * RECIPROCAL_PI2 + 0.5;\n\t\tvec4 envColor = texture2D( envMap, sampleUV );\n\t#elif defined( ENVMAP_TYPE_SPHERE )\n\t\tvec3 reflectView = flipNormal * normalize( ( viewMatrix * vec4( reflectVec, 0.0 ) ).xyz + vec3( 0.0, 0.0, 1.0 ) );\n\t\tvec4 envColor = texture2D( envMap, reflectView.xy * 0.5 + 0.5 );\n\t#else\n\t\tvec4 envColor = vec4( 0.0 );\n\t#endif\n\tenvColor = envMapTexelToLinear( envColor );\n\t#ifdef ENVMAP_BLENDING_MULTIPLY\n\t\toutgoingLight = mix( outgoingLight, outgoingLight * envColor.xyz, specularStrength * reflectivity );\n\t#elif defined( ENVMAP_BLENDING_MIX )\n\t\toutgoingLight = mix( outgoingLight, envColor.xyz, specularStrength * reflectivity );\n\t#elif defined( ENVMAP_BLENDING_ADD )\n\t\toutgoingLight += envColor.xyz * specularStrength * reflectivity;\n\t#endif\n#endif\n",qd="#if defined( USE_ENVMAP ) || defined( PHYSICAL )\n\tuniform float reflectivity;\n\tuniform float envMapIntenstiy;\n#endif\n#ifdef USE_ENVMAP\n\t#if ! defined( PHYSICAL ) && ( defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG ) )\n\t\tvarying vec3 vWorldPosition;\n\t#endif\n\t#ifdef ENVMAP_TYPE_CUBE\n\t\tuniform samplerCube envMap;\n\t#else\n\t\tuniform sampler2D envMap;\n\t#endif\n\tuniform float flipEnvMap;\n\t#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG ) || defined( PHYSICAL )\n\t\tuniform float refractionRatio;\n\t#else\n\t\tvarying vec3 vReflect;\n\t#endif\n#endif\n",Yd="#ifdef USE_ENVMAP\n\t#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG )\n\t\tvarying vec3 vWorldPosition;\n\t#else\n\t\tvarying vec3 vReflect;\n\t\tuniform float refractionRatio;\n\t#endif\n#endif\n",Zd="#ifdef USE_ENVMAP\n\t#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG )\n\t\tvWorldPosition = worldPosition.xyz;\n\t#else\n\t\tvec3 cameraToVertex = normalize( worldPosition.xyz - cameraPosition );\n\t\tvec3 worldNormal = inverseTransformDirection( transformedNormal, viewMatrix );\n\t\t#ifdef ENVMAP_MODE_REFLECTION\n\t\t\tvReflect = reflect( cameraToVertex, worldNormal );\n\t\t#else\n\t\t\tvReflect = refract( cameraToVertex, worldNormal, refractionRatio );\n\t\t#endif\n\t#endif\n#endif\n",Kd="#ifdef USE_FOG\n\t#ifdef USE_LOGDEPTHBUF_EXT\n\t\tfloat depth = gl_FragDepthEXT / gl_FragCoord.w;\n\t#else\n\t\tfloat depth = gl_FragCoord.z / gl_FragCoord.w;\n\t#endif\n\t#ifdef FOG_EXP2\n\t\tfloat fogFactor = whiteCompliment( exp2( - fogDensity * fogDensity * depth * depth * LOG2 ) );\n\t#else\n\t\tfloat fogFactor = smoothstep( fogNear, fogFar, depth );\n\t#endif\n\tgl_FragColor.rgb = mix( gl_FragColor.rgb, fogColor, fogFactor );\n#endif\n",Qd="#ifdef USE_FOG\n\tuniform vec3 fogColor;\n\t#ifdef FOG_EXP2\n\t\tuniform float fogDensity;\n\t#else\n\t\tuniform float fogNear;\n\t\tuniform float fogFar;\n\t#endif\n#endif",Jd="#ifdef USE_LIGHTMAP\n\treflectedLight.indirectDiffuse += PI * texture2D( lightMap, vUv2 ).xyz * lightMapIntensity;\n#endif\n",tf="#ifdef USE_LIGHTMAP\n\tuniform sampler2D lightMap;\n\tuniform float lightMapIntensity;\n#endif",ef="vec3 diffuse = vec3( 1.0 );\nGeometricContext geometry;\ngeometry.position = mvPosition.xyz;\ngeometry.normal = normalize( transformedNormal );\ngeometry.viewDir = normalize( -mvPosition.xyz );\nGeometricContext backGeometry;\nbackGeometry.position = geometry.position;\nbackGeometry.normal = -geometry.normal;\nbackGeometry.viewDir = geometry.viewDir;\nvLightFront = vec3( 0.0 );\n#ifdef DOUBLE_SIDED\n\tvLightBack = vec3( 0.0 );\n#endif\nIncidentLight directLight;\nfloat dotNL;\nvec3 directLightColor_Diffuse;\n#if NUM_POINT_LIGHTS > 0\n\tfor ( int i = 0; i < NUM_POINT_LIGHTS; i ++ ) {\n\t\tgetPointDirectLightIrradiance( pointLights[ i ], geometry, directLight );\n\t\tdotNL = dot( geometry.normal, directLight.direction );\n\t\tdirectLightColor_Diffuse = PI * directLight.color;\n\t\tvLightFront += saturate( dotNL ) * directLightColor_Diffuse;\n\t\t#ifdef DOUBLE_SIDED\n\t\t\tvLightBack += saturate( -dotNL ) * directLightColor_Diffuse;\n\t\t#endif\n\t}\n#endif\n#if NUM_SPOT_LIGHTS > 0\n\tfor ( int i = 0; i < NUM_SPOT_LIGHTS; i ++ ) {\n\t\tgetSpotDirectLightIrradiance( spotLights[ i ], geometry, directLight );\n\t\tdotNL = dot( geometry.normal, directLight.direction );\n\t\tdirectLightColor_Diffuse = PI * directLight.color;\n\t\tvLightFront += saturate( dotNL ) * directLightColor_Diffuse;\n\t\t#ifdef DOUBLE_SIDED\n\t\t\tvLightBack += saturate( -dotNL ) * directLightColor_Diffuse;\n\t\t#endif\n\t}\n#endif\n#if NUM_DIR_LIGHTS > 0\n\tfor ( int i = 0; i < NUM_DIR_LIGHTS; i ++ ) {\n\t\tgetDirectionalDirectLightIrradiance( directionalLights[ i ], geometry, directLight );\n\t\tdotNL = dot( geometry.normal, directLight.direction );\n\t\tdirectLightColor_Diffuse = PI * directLight.color;\n\t\tvLightFront += saturate( dotNL ) * directLightColor_Diffuse;\n\t\t#ifdef DOUBLE_SIDED\n\t\t\tvLightBack += saturate( -dotNL ) * directLightColor_Diffuse;\n\t\t#endif\n\t}\n#endif\n#if NUM_HEMI_LIGHTS > 0\n\tfor ( int i = 0; i < NUM_HEMI_LIGHTS; i ++ ) {\n\t\tvLightFront += getHemisphereLightIrradiance( hemisphereLights[ i ], geometry );\n\t\t#ifdef DOUBLE_SIDED\n\t\t\tvLightBack += getHemisphereLightIrradiance( hemisphereLights[ i ], backGeometry );\n\t\t#endif\n\t}\n#endif\n",nf="uniform vec3 ambientLightColor;\nvec3 getAmbientLightIrradiance( const in vec3 ambientLightColor ) {\n\tvec3 irradiance = ambientLightColor;\n\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\tirradiance *= PI;\n\t#endif\n\treturn irradiance;\n}\n#if NUM_DIR_LIGHTS > 0\n\tstruct DirectionalLight {\n\t\tvec3 direction;\n\t\tvec3 color;\n\t\tint shadow;\n\t\tfloat shadowBias;\n\t\tfloat shadowRadius;\n\t\tvec2 shadowMapSize;\n\t};\n\tuniform DirectionalLight directionalLights[ NUM_DIR_LIGHTS ];\n\tvoid getDirectionalDirectLightIrradiance( const in DirectionalLight directionalLight, const in GeometricContext geometry, out IncidentLight directLight ) {\n\t\tdirectLight.color = directionalLight.color;\n\t\tdirectLight.direction = directionalLight.direction;\n\t\tdirectLight.visible = true;\n\t}\n#endif\n#if NUM_POINT_LIGHTS > 0\n\tstruct PointLight {\n\t\tvec3 position;\n\t\tvec3 color;\n\t\tfloat distance;\n\t\tfloat decay;\n\t\tint shadow;\n\t\tfloat shadowBias;\n\t\tfloat shadowRadius;\n\t\tvec2 shadowMapSize;\n\t};\n\tuniform PointLight pointLights[ NUM_POINT_LIGHTS ];\n\tvoid getPointDirectLightIrradiance( const in PointLight pointLight, const in GeometricContext geometry, out IncidentLight directLight ) {\n\t\tvec3 lVector = pointLight.position - geometry.position;\n\t\tdirectLight.direction = normalize( lVector );\n\t\tfloat lightDistance = length( lVector );\n\t\tif ( testLightInRange( lightDistance, pointLight.distance ) ) {\n\t\t\tdirectLight.color = pointLight.color;\n\t\t\tdirectLight.color *= punctualLightIntensityToIrradianceFactor( lightDistance, pointLight.distance, pointLight.decay );\n\t\t\tdirectLight.visible = true;\n\t\t} else {\n\t\t\tdirectLight.color = vec3( 0.0 );\n\t\t\tdirectLight.visible = false;\n\t\t}\n\t}\n#endif\n#if NUM_SPOT_LIGHTS > 0\n\tstruct SpotLight {\n\t\tvec3 position;\n\t\tvec3 direction;\n\t\tvec3 color;\n\t\tfloat distance;\n\t\tfloat decay;\n\t\tfloat coneCos;\n\t\tfloat penumbraCos;\n\t\tint shadow;\n\t\tfloat shadowBias;\n\t\tfloat shadowRadius;\n\t\tvec2 shadowMapSize;\n\t};\n\tuniform SpotLight spotLights[ NUM_SPOT_LIGHTS ];\n\tvoid getSpotDirectLightIrradiance( const in SpotLight spotLight, const in GeometricContext geometry, out IncidentLight directLight  ) {\n\t\tvec3 lVector = spotLight.position - geometry.position;\n\t\tdirectLight.direction = normalize( lVector );\n\t\tfloat lightDistance = length( lVector );\n\t\tfloat angleCos = dot( directLight.direction, spotLight.direction );\n\t\tif ( all( bvec2( angleCos > spotLight.coneCos, testLightInRange( lightDistance, spotLight.distance ) ) ) ) {\n\t\t\tfloat spotEffect = smoothstep( spotLight.coneCos, spotLight.penumbraCos, angleCos );\n\t\t\tdirectLight.color = spotLight.color;\n\t\t\tdirectLight.color *= spotEffect * punctualLightIntensityToIrradianceFactor( lightDistance, spotLight.distance, spotLight.decay );\n\t\t\tdirectLight.visible = true;\n\t\t} else {\n\t\t\tdirectLight.color = vec3( 0.0 );\n\t\t\tdirectLight.visible = false;\n\t\t}\n\t}\n#endif\n#if NUM_HEMI_LIGHTS > 0\n\tstruct HemisphereLight {\n\t\tvec3 direction;\n\t\tvec3 skyColor;\n\t\tvec3 groundColor;\n\t};\n\tuniform HemisphereLight hemisphereLights[ NUM_HEMI_LIGHTS ];\n\tvec3 getHemisphereLightIrradiance( const in HemisphereLight hemiLight, const in GeometricContext geometry ) {\n\t\tfloat dotNL = dot( geometry.normal, hemiLight.direction );\n\t\tfloat hemiDiffuseWeight = 0.5 * dotNL + 0.5;\n\t\tvec3 irradiance = mix( hemiLight.groundColor, hemiLight.skyColor, hemiDiffuseWeight );\n\t\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\t\tirradiance *= PI;\n\t\t#endif\n\t\treturn irradiance;\n\t}\n#endif\n#if defined( USE_ENVMAP ) && defined( PHYSICAL )\n\tvec3 getLightProbeIndirectIrradiance( const in GeometricContext geometry, const in int maxMIPLevel ) {\n\t\t#include <normal_flip>\n\t\tvec3 worldNormal = inverseTransformDirection( geometry.normal, viewMatrix );\n\t\t#ifdef ENVMAP_TYPE_CUBE\n\t\t\tvec3 queryVec = flipNormal * vec3( flipEnvMap * worldNormal.x, worldNormal.yz );\n\t\t\t#ifdef TEXTURE_LOD_EXT\n\t\t\t\tvec4 envMapColor = textureCubeLodEXT( envMap, queryVec, float( maxMIPLevel ) );\n\t\t\t#else\n\t\t\t\tvec4 envMapColor = textureCube( envMap, queryVec, float( maxMIPLevel ) );\n\t\t\t#endif\n\t\t\tenvMapColor.rgb = envMapTexelToLinear( envMapColor ).rgb;\n\t\t#elif defined( ENVMAP_TYPE_CUBE_UV )\n\t\t\tvec3 queryVec = flipNormal * vec3( flipEnvMap * worldNormal.x, worldNormal.yz );\n\t\t\tvec4 envMapColor = textureCubeUV( queryVec, 1.0 );\n\t\t#else\n\t\t\tvec4 envMapColor = vec4( 0.0 );\n\t\t#endif\n\t\treturn PI * envMapColor.rgb * envMapIntensity;\n\t}\n\tfloat getSpecularMIPLevel( const in float blinnShininessExponent, const in int maxMIPLevel ) {\n\t\tfloat maxMIPLevelScalar = float( maxMIPLevel );\n\t\tfloat desiredMIPLevel = maxMIPLevelScalar - 0.79248 - 0.5 * log2( pow2( blinnShininessExponent ) + 1.0 );\n\t\treturn clamp( desiredMIPLevel, 0.0, maxMIPLevelScalar );\n\t}\n\tvec3 getLightProbeIndirectRadiance( const in GeometricContext geometry, const in float blinnShininessExponent, const in int maxMIPLevel ) {\n\t\t#ifdef ENVMAP_MODE_REFLECTION\n\t\t\tvec3 reflectVec = reflect( -geometry.viewDir, geometry.normal );\n\t\t#else\n\t\t\tvec3 reflectVec = refract( -geometry.viewDir, geometry.normal, refractionRatio );\n\t\t#endif\n\t\t#include <normal_flip>\n\t\treflectVec = inverseTransformDirection( reflectVec, viewMatrix );\n\t\tfloat specularMIPLevel = getSpecularMIPLevel( blinnShininessExponent, maxMIPLevel );\n\t\t#ifdef ENVMAP_TYPE_CUBE\n\t\t\tvec3 queryReflectVec = flipNormal * vec3( flipEnvMap * reflectVec.x, reflectVec.yz );\n\t\t\t#ifdef TEXTURE_LOD_EXT\n\t\t\t\tvec4 envMapColor = textureCubeLodEXT( envMap, queryReflectVec, specularMIPLevel );\n\t\t\t#else\n\t\t\t\tvec4 envMapColor = textureCube( envMap, queryReflectVec, specularMIPLevel );\n\t\t\t#endif\n\t\t\tenvMapColor.rgb = envMapTexelToLinear( envMapColor ).rgb;\n\t\t#elif defined( ENVMAP_TYPE_CUBE_UV )\n\t\t\tvec3 queryReflectVec = flipNormal * vec3( flipEnvMap * reflectVec.x, reflectVec.yz );\n\t\t\tvec4 envMapColor = textureCubeUV(queryReflectVec, BlinnExponentToGGXRoughness(blinnShininessExponent));\n\t\t#elif defined( ENVMAP_TYPE_EQUIREC )\n\t\t\tvec2 sampleUV;\n\t\t\tsampleUV.y = saturate( flipNormal * reflectVec.y * 0.5 + 0.5 );\n\t\t\tsampleUV.x = atan( flipNormal * reflectVec.z, flipNormal * reflectVec.x ) * RECIPROCAL_PI2 + 0.5;\n\t\t\t#ifdef TEXTURE_LOD_EXT\n\t\t\t\tvec4 envMapColor = texture2DLodEXT( envMap, sampleUV, specularMIPLevel );\n\t\t\t#else\n\t\t\t\tvec4 envMapColor = texture2D( envMap, sampleUV, specularMIPLevel );\n\t\t\t#endif\n\t\t\tenvMapColor.rgb = envMapTexelToLinear( envMapColor ).rgb;\n\t\t#elif defined( ENVMAP_TYPE_SPHERE )\n\t\t\tvec3 reflectView = flipNormal * normalize( ( viewMatrix * vec4( reflectVec, 0.0 ) ).xyz + vec3( 0.0,0.0,1.0 ) );\n\t\t\t#ifdef TEXTURE_LOD_EXT\n\t\t\t\tvec4 envMapColor = texture2DLodEXT( envMap, reflectView.xy * 0.5 + 0.5, specularMIPLevel );\n\t\t\t#else\n\t\t\t\tvec4 envMapColor = texture2D( envMap, reflectView.xy * 0.5 + 0.5, specularMIPLevel );\n\t\t\t#endif\n\t\t\tenvMapColor.rgb = envMapTexelToLinear( envMapColor ).rgb;\n\t\t#endif\n\t\treturn envMapColor.rgb * envMapIntensity;\n\t}\n#endif\n",rf="BlinnPhongMaterial material;\nmaterial.diffuseColor = diffuseColor.rgb;\nmaterial.specularColor = specular;\nmaterial.specularShininess = shininess;\nmaterial.specularStrength = specularStrength;\n",of="varying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\nstruct BlinnPhongMaterial {\n\tvec3\tdiffuseColor;\n\tvec3\tspecularColor;\n\tfloat\tspecularShininess;\n\tfloat\tspecularStrength;\n};\nvoid RE_Direct_BlinnPhong( const in IncidentLight directLight, const in GeometricContext geometry, const in BlinnPhongMaterial material, inout ReflectedLight reflectedLight ) {\n\tfloat dotNL = saturate( dot( geometry.normal, directLight.direction ) );\n\tvec3 irradiance = dotNL * directLight.color;\n\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\tirradiance *= PI;\n\t#endif\n\treflectedLight.directDiffuse += irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\n\treflectedLight.directSpecular += irradiance * BRDF_Specular_BlinnPhong( directLight, geometry, material.specularColor, material.specularShininess ) * material.specularStrength;\n}\nvoid RE_IndirectDiffuse_BlinnPhong( const in vec3 irradiance, const in GeometricContext geometry, const in BlinnPhongMaterial material, inout ReflectedLight reflectedLight ) {\n\treflectedLight.indirectDiffuse += irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\n}\n#define RE_Direct\t\t\t\tRE_Direct_BlinnPhong\n#define RE_IndirectDiffuse\t\tRE_IndirectDiffuse_BlinnPhong\n#define Material_LightProbeLOD( material )\t(0)\n",af="PhysicalMaterial material;\nmaterial.diffuseColor = diffuseColor.rgb * ( 1.0 - metalnessFactor );\nmaterial.specularRoughness = clamp( roughnessFactor, 0.04, 1.0 );\n#ifdef STANDARD\n\tmaterial.specularColor = mix( vec3( DEFAULT_SPECULAR_COEFFICIENT ), diffuseColor.rgb, metalnessFactor );\n#else\n\tmaterial.specularColor = mix( vec3( MAXIMUM_SPECULAR_COEFFICIENT * pow2( reflectivity ) ), diffuseColor.rgb, metalnessFactor );\n\tmaterial.clearCoat = saturate( clearCoat );\tmaterial.clearCoatRoughness = clamp( clearCoatRoughness, 0.04, 1.0 );\n#endif\n",sf="struct PhysicalMaterial {\n\tvec3\tdiffuseColor;\n\tfloat\tspecularRoughness;\n\tvec3\tspecularColor;\n\t#ifndef STANDARD\n\t\tfloat clearCoat;\n\t\tfloat clearCoatRoughness;\n\t#endif\n};\n#define MAXIMUM_SPECULAR_COEFFICIENT 0.16\n#define DEFAULT_SPECULAR_COEFFICIENT 0.04\nfloat clearCoatDHRApprox( const in float roughness, const in float dotNL ) {\n\treturn DEFAULT_SPECULAR_COEFFICIENT + ( 1.0 - DEFAULT_SPECULAR_COEFFICIENT ) * ( pow( 1.0 - dotNL, 5.0 ) * pow( 1.0 - roughness, 2.0 ) );\n}\nvoid RE_Direct_Physical( const in IncidentLight directLight, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n\tfloat dotNL = saturate( dot( geometry.normal, directLight.direction ) );\n\tvec3 irradiance = dotNL * directLight.color;\n\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\tirradiance *= PI;\n\t#endif\n\t#ifndef STANDARD\n\t\tfloat clearCoatDHR = material.clearCoat * clearCoatDHRApprox( material.clearCoatRoughness, dotNL );\n\t#else\n\t\tfloat clearCoatDHR = 0.0;\n\t#endif\n\treflectedLight.directSpecular += ( 1.0 - clearCoatDHR ) * irradiance * BRDF_Specular_GGX( directLight, geometry, material.specularColor, material.specularRoughness );\n\treflectedLight.directDiffuse += ( 1.0 - clearCoatDHR ) * irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\n\t#ifndef STANDARD\n\t\treflectedLight.directSpecular += irradiance * material.clearCoat * BRDF_Specular_GGX( directLight, geometry, vec3( DEFAULT_SPECULAR_COEFFICIENT ), material.clearCoatRoughness );\n\t#endif\n}\nvoid RE_IndirectDiffuse_Physical( const in vec3 irradiance, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n\treflectedLight.indirectDiffuse += irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\n}\nvoid RE_IndirectSpecular_Physical( const in vec3 radiance, const in vec3 clearCoatRadiance, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n\t#ifndef STANDARD\n\t\tfloat dotNV = saturate( dot( geometry.normal, geometry.viewDir ) );\n\t\tfloat dotNL = dotNV;\n\t\tfloat clearCoatDHR = material.clearCoat * clearCoatDHRApprox( material.clearCoatRoughness, dotNL );\n\t#else\n\t\tfloat clearCoatDHR = 0.0;\n\t#endif\n\treflectedLight.indirectSpecular += ( 1.0 - clearCoatDHR ) * radiance * BRDF_Specular_GGX_Environment( geometry, material.specularColor, material.specularRoughness );\n\t#ifndef STANDARD\n\t\treflectedLight.indirectSpecular += clearCoatRadiance * material.clearCoat * BRDF_Specular_GGX_Environment( geometry, vec3( DEFAULT_SPECULAR_COEFFICIENT ), material.clearCoatRoughness );\n\t#endif\n}\n#define RE_Direct\t\t\t\tRE_Direct_Physical\n#define RE_IndirectDiffuse\t\tRE_IndirectDiffuse_Physical\n#define RE_IndirectSpecular\t\tRE_IndirectSpecular_Physical\n#define Material_BlinnShininessExponent( material )   GGXRoughnessToBlinnExponent( material.specularRoughness )\n#define Material_ClearCoat_BlinnShininessExponent( material )   GGXRoughnessToBlinnExponent( material.clearCoatRoughness )\nfloat computeSpecularOcclusion( const in float dotNV, const in float ambientOcclusion, const in float roughness ) {\n\treturn saturate( pow( dotNV + ambientOcclusion, exp2( - 16.0 * roughness - 1.0 ) ) - 1.0 + ambientOcclusion );\n}\n",cf="\nGeometricContext geometry;\ngeometry.position = - vViewPosition;\ngeometry.normal = normal;\ngeometry.viewDir = normalize( vViewPosition );\nIncidentLight directLight;\n#if ( NUM_POINT_LIGHTS > 0 ) && defined( RE_Direct )\n\tPointLight pointLight;\n\tfor ( int i = 0; i < NUM_POINT_LIGHTS; i ++ ) {\n\t\tpointLight = pointLights[ i ];\n\t\tgetPointDirectLightIrradiance( pointLight, geometry, directLight );\n\t\t#ifdef USE_SHADOWMAP\n\t\tdirectLight.color *= all( bvec2( pointLight.shadow, directLight.visible ) ) ? getPointShadow( pointShadowMap[ i ], pointLight.shadowMapSize, pointLight.shadowBias, pointLight.shadowRadius, vPointShadowCoord[ i ] ) : 1.0;\n\t\t#endif\n\t\tRE_Direct( directLight, geometry, material, reflectedLight );\n\t}\n#endif\n#if ( NUM_SPOT_LIGHTS > 0 ) && defined( RE_Direct )\n\tSpotLight spotLight;\n\tfor ( int i = 0; i < NUM_SPOT_LIGHTS; i ++ ) {\n\t\tspotLight = spotLights[ i ];\n\t\tgetSpotDirectLightIrradiance( spotLight, geometry, directLight );\n\t\t#ifdef USE_SHADOWMAP\n\t\tdirectLight.color *= all( bvec2( spotLight.shadow, directLight.visible ) ) ? getShadow( spotShadowMap[ i ], spotLight.shadowMapSize, spotLight.shadowBias, spotLight.shadowRadius, vSpotShadowCoord[ i ] ) : 1.0;\n\t\t#endif\n\t\tRE_Direct( directLight, geometry, material, reflectedLight );\n\t}\n#endif\n#if ( NUM_DIR_LIGHTS > 0 ) && defined( RE_Direct )\n\tDirectionalLight directionalLight;\n\tfor ( int i = 0; i < NUM_DIR_LIGHTS; i ++ ) {\n\t\tdirectionalLight = directionalLights[ i ];\n\t\tgetDirectionalDirectLightIrradiance( directionalLight, geometry, directLight );\n\t\t#ifdef USE_SHADOWMAP\n\t\tdirectLight.color *= all( bvec2( directionalLight.shadow, directLight.visible ) ) ? getShadow( directionalShadowMap[ i ], directionalLight.shadowMapSize, directionalLight.shadowBias, directionalLight.shadowRadius, vDirectionalShadowCoord[ i ] ) : 1.0;\n\t\t#endif\n\t\tRE_Direct( directLight, geometry, material, reflectedLight );\n\t}\n#endif\n#if defined( RE_IndirectDiffuse )\n\tvec3 irradiance = getAmbientLightIrradiance( ambientLightColor );\n\t#ifdef USE_LIGHTMAP\n\t\tvec3 lightMapIrradiance = texture2D( lightMap, vUv2 ).xyz * lightMapIntensity;\n\t\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\t\tlightMapIrradiance *= PI;\n\t\t#endif\n\t\tirradiance += lightMapIrradiance;\n\t#endif\n\t#if ( NUM_HEMI_LIGHTS > 0 )\n\t\tfor ( int i = 0; i < NUM_HEMI_LIGHTS; i ++ ) {\n\t\t\tirradiance += getHemisphereLightIrradiance( hemisphereLights[ i ], geometry );\n\t\t}\n\t#endif\n\t#if defined( USE_ENVMAP ) && defined( PHYSICAL ) && defined( ENVMAP_TYPE_CUBE_UV )\n\t \tirradiance += getLightProbeIndirectIrradiance( geometry, 8 );\n\t#endif\n\tRE_IndirectDiffuse( irradiance, geometry, material, reflectedLight );\n#endif\n#if defined( USE_ENVMAP ) && defined( RE_IndirectSpecular )\n\tvec3 radiance = getLightProbeIndirectRadiance( geometry, Material_BlinnShininessExponent( material ), 8 );\n\t#ifndef STANDARD\n\t\tvec3 clearCoatRadiance = getLightProbeIndirectRadiance( geometry, Material_ClearCoat_BlinnShininessExponent( material ), 8 );\n\t#else\n\t\tvec3 clearCoatRadiance = vec3( 0.0 );\n\t#endif\n\t\t\n\tRE_IndirectSpecular( radiance, clearCoatRadiance, geometry, material, reflectedLight );\n#endif\n",uf="#if defined(USE_LOGDEPTHBUF) && defined(USE_LOGDEPTHBUF_EXT)\n\tgl_FragDepthEXT = log2(vFragDepth) * logDepthBufFC * 0.5;\n#endif",hf="#ifdef USE_LOGDEPTHBUF\n\tuniform float logDepthBufFC;\n\t#ifdef USE_LOGDEPTHBUF_EXT\n\t\tvarying float vFragDepth;\n\t#endif\n#endif\n",lf="#ifdef USE_LOGDEPTHBUF\n\t#ifdef USE_LOGDEPTHBUF_EXT\n\t\tvarying float vFragDepth;\n\t#endif\n\tuniform float logDepthBufFC;\n#endif",df="#ifdef USE_LOGDEPTHBUF\n\tgl_Position.z = log2(max( EPSILON, gl_Position.w + 1.0 )) * logDepthBufFC;\n\t#ifdef USE_LOGDEPTHBUF_EXT\n\t\tvFragDepth = 1.0 + gl_Position.w;\n\t#else\n\t\tgl_Position.z = (gl_Position.z - 1.0) * gl_Position.w;\n\t#endif\n#endif\n",ff="#ifdef USE_MAP\n\tvec4 texelColor = texture2D( map, vUv );\n\ttexelColor = mapTexelToLinear( texelColor );\n\tdiffuseColor *= texelColor;\n#endif\n",pf="#ifdef USE_MAP\n\tuniform sampler2D map;\n#endif\n",mf="#ifdef USE_MAP\n\tvec4 mapTexel = texture2D( map, vec2( gl_PointCoord.x, 1.0 - gl_PointCoord.y ) * offsetRepeat.zw + offsetRepeat.xy );\n\tdiffuseColor *= mapTexelToLinear( mapTexel );\n#endif\n",gf="#ifdef USE_MAP\n\tuniform vec4 offsetRepeat;\n\tuniform sampler2D map;\n#endif\n",vf="float metalnessFactor = metalness;\n#ifdef USE_METALNESSMAP\n\tvec4 texelMetalness = texture2D( metalnessMap, vUv );\n\tmetalnessFactor *= texelMetalness.r;\n#endif\n",yf="#ifdef USE_METALNESSMAP\n\tuniform sampler2D metalnessMap;\n#endif",bf="#ifdef USE_MORPHNORMALS\n\tobjectNormal += ( morphNormal0 - normal ) * morphTargetInfluences[ 0 ];\n\tobjectNormal += ( morphNormal1 - normal ) * morphTargetInfluences[ 1 ];\n\tobjectNormal += ( morphNormal2 - normal ) * morphTargetInfluences[ 2 ];\n\tobjectNormal += ( morphNormal3 - normal ) * morphTargetInfluences[ 3 ];\n#endif\n",xf="#ifdef USE_MORPHTARGETS\n\t#ifndef USE_MORPHNORMALS\n\tuniform float morphTargetInfluences[ 8 ];\n\t#else\n\tuniform float morphTargetInfluences[ 4 ];\n\t#endif\n#endif",_f="#ifdef USE_MORPHTARGETS\n\ttransformed += ( morphTarget0 - position ) * morphTargetInfluences[ 0 ];\n\ttransformed += ( morphTarget1 - position ) * morphTargetInfluences[ 1 ];\n\ttransformed += ( morphTarget2 - position ) * morphTargetInfluences[ 2 ];\n\ttransformed += ( morphTarget3 - position ) * morphTargetInfluences[ 3 ];\n\t#ifndef USE_MORPHNORMALS\n\ttransformed += ( morphTarget4 - position ) * morphTargetInfluences[ 4 ];\n\ttransformed += ( morphTarget5 - position ) * morphTargetInfluences[ 5 ];\n\ttransformed += ( morphTarget6 - position ) * morphTargetInfluences[ 6 ];\n\ttransformed += ( morphTarget7 - position ) * morphTargetInfluences[ 7 ];\n\t#endif\n#endif\n",wf="#ifdef DOUBLE_SIDED\n\tfloat flipNormal = ( float( gl_FrontFacing ) * 2.0 - 1.0 );\n#else\n\tfloat flipNormal = 1.0;\n#endif\n",Sf="#ifdef FLAT_SHADED\n\tvec3 fdx = vec3( dFdx( vViewPosition.x ), dFdx( vViewPosition.y ), dFdx( vViewPosition.z ) );\n\tvec3 fdy = vec3( dFdy( vViewPosition.x ), dFdy( vViewPosition.y ), dFdy( vViewPosition.z ) );\n\tvec3 normal = normalize( cross( fdx, fdy ) );\n#else\n\tvec3 normal = normalize( vNormal ) * flipNormal;\n#endif\n#ifdef USE_NORMALMAP\n\tnormal = perturbNormal2Arb( -vViewPosition, normal );\n#elif defined( USE_BUMPMAP )\n\tnormal = perturbNormalArb( -vViewPosition, normal, dHdxy_fwd() );\n#endif\n",Af="#ifdef USE_NORMALMAP\n\tuniform sampler2D normalMap;\n\tuniform vec2 normalScale;\n\tvec3 perturbNormal2Arb( vec3 eye_pos, vec3 surf_norm ) {\n\t\tvec3 q0 = dFdx( eye_pos.xyz );\n\t\tvec3 q1 = dFdy( eye_pos.xyz );\n\t\tvec2 st0 = dFdx( vUv.st );\n\t\tvec2 st1 = dFdy( vUv.st );\n\t\tvec3 S = normalize( q0 * st1.t - q1 * st0.t );\n\t\tvec3 T = normalize( -q0 * st1.s + q1 * st0.s );\n\t\tvec3 N = normalize( surf_norm );\n\t\tvec3 mapN = texture2D( normalMap, vUv ).xyz * 2.0 - 1.0;\n\t\tmapN.xy = normalScale * mapN.xy;\n\t\tmat3 tsn = mat3( S, T, N );\n\t\treturn normalize( tsn * mapN );\n\t}\n#endif\n",Mf="vec3 packNormalToRGB( const in vec3 normal ) {\n  return normalize( normal ) * 0.5 + 0.5;\n}\nvec3 unpackRGBToNormal( const in vec3 rgb ) {\n  return 1.0 - 2.0 * rgb.xyz;\n}\nconst float PackUpscale = 256. / 255.;const float UnpackDownscale = 255. / 256.;\nconst vec3 PackFactors = vec3( 256. * 256. * 256., 256. * 256.,  256. );\nconst vec4 UnpackFactors = UnpackDownscale / vec4( PackFactors, 1. );\nconst float ShiftRight8 = 1. / 256.;\nvec4 packDepthToRGBA( const in float v ) {\n\tvec4 r = vec4( fract( v * PackFactors ), v );\n\tr.yzw -= r.xyz * ShiftRight8;\treturn r * PackUpscale;\n}\nfloat unpackRGBAToDepth( const in vec4 v ) {\n\treturn dot( v, UnpackFactors );\n}\nfloat viewZToOrthographicDepth( const in float viewZ, const in float near, const in float far ) {\n  return ( viewZ + near ) / ( near - far );\n}\nfloat orthographicDepthToViewZ( const in float linearClipZ, const in float near, const in float far ) {\n  return linearClipZ * ( near - far ) - near;\n}\nfloat viewZToPerspectiveDepth( const in float viewZ, const in float near, const in float far ) {\n  return (( near + viewZ ) * far ) / (( far - near ) * viewZ );\n}\nfloat perspectiveDepthToViewZ( const in float invClipZ, const in float near, const in float far ) {\n  return ( near * far ) / ( ( far - near ) * invClipZ - far );\n}\n",Cf="#ifdef PREMULTIPLIED_ALPHA\n\tgl_FragColor.rgb *= gl_FragColor.a;\n#endif\n",Pf="#ifdef USE_SKINNING\n\tvec4 mvPosition = modelViewMatrix * skinned;\n#else\n\tvec4 mvPosition = modelViewMatrix * vec4( transformed, 1.0 );\n#endif\ngl_Position = projectionMatrix * mvPosition;\n",Tf="float roughnessFactor = roughness;\n#ifdef USE_ROUGHNESSMAP\n\tvec4 texelRoughness = texture2D( roughnessMap, vUv );\n\troughnessFactor *= texelRoughness.r;\n#endif\n",Ef="#ifdef USE_ROUGHNESSMAP\n\tuniform sampler2D roughnessMap;\n#endif",If="#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHTS > 0\n\t\tuniform sampler2D directionalShadowMap[ NUM_DIR_LIGHTS ];\n\t\tvarying vec4 vDirectionalShadowCoord[ NUM_DIR_LIGHTS ];\n\t#endif\n\t#if NUM_SPOT_LIGHTS > 0\n\t\tuniform sampler2D spotShadowMap[ NUM_SPOT_LIGHTS ];\n\t\tvarying vec4 vSpotShadowCoord[ NUM_SPOT_LIGHTS ];\n\t#endif\n\t#if NUM_POINT_LIGHTS > 0\n\t\tuniform sampler2D pointShadowMap[ NUM_POINT_LIGHTS ];\n\t\tvarying vec4 vPointShadowCoord[ NUM_POINT_LIGHTS ];\n\t#endif\n\tfloat texture2DCompare( sampler2D depths, vec2 uv, float compare ) {\n\t\treturn step( compare, unpackRGBAToDepth( texture2D( depths, uv ) ) );\n\t}\n\tfloat texture2DShadowLerp( sampler2D depths, vec2 size, vec2 uv, float compare ) {\n\t\tconst vec2 offset = vec2( 0.0, 1.0 );\n\t\tvec2 texelSize = vec2( 1.0 ) / size;\n\t\tvec2 centroidUV = floor( uv * size + 0.5 ) / size;\n\t\tfloat lb = texture2DCompare( depths, centroidUV + texelSize * offset.xx, compare );\n\t\tfloat lt = texture2DCompare( depths, centroidUV + texelSize * offset.xy, compare );\n\t\tfloat rb = texture2DCompare( depths, centroidUV + texelSize * offset.yx, compare );\n\t\tfloat rt = texture2DCompare( depths, centroidUV + texelSize * offset.yy, compare );\n\t\tvec2 f = fract( uv * size + 0.5 );\n\t\tfloat a = mix( lb, lt, f.y );\n\t\tfloat b = mix( rb, rt, f.y );\n\t\tfloat c = mix( a, b, f.x );\n\t\treturn c;\n\t}\n\tfloat getShadow( sampler2D shadowMap, vec2 shadowMapSize, float shadowBias, float shadowRadius, vec4 shadowCoord ) {\n\t\tshadowCoord.xyz /= shadowCoord.w;\n\t\tshadowCoord.z += shadowBias;\n\t\tbvec4 inFrustumVec = bvec4 ( shadowCoord.x >= 0.0, shadowCoord.x <= 1.0, shadowCoord.y >= 0.0, shadowCoord.y <= 1.0 );\n\t\tbool inFrustum = all( inFrustumVec );\n\t\tbvec2 frustumTestVec = bvec2( inFrustum, shadowCoord.z <= 1.0 );\n\t\tbool frustumTest = all( frustumTestVec );\n\t\tif ( frustumTest ) {\n\t\t#if defined( SHADOWMAP_TYPE_PCF )\n\t\t\tvec2 texelSize = vec2( 1.0 ) / shadowMapSize;\n\t\t\tfloat dx0 = - texelSize.x * shadowRadius;\n\t\t\tfloat dy0 = - texelSize.y * shadowRadius;\n\t\t\tfloat dx1 = + texelSize.x * shadowRadius;\n\t\t\tfloat dy1 = + texelSize.y * shadowRadius;\n\t\t\treturn (\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy, shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, dy1 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy1 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, dy1 ), shadowCoord.z )\n\t\t\t) * ( 1.0 / 9.0 );\n\t\t#elif defined( SHADOWMAP_TYPE_PCF_SOFT )\n\t\t\tvec2 texelSize = vec2( 1.0 ) / shadowMapSize;\n\t\t\tfloat dx0 = - texelSize.x * shadowRadius;\n\t\t\tfloat dy0 = - texelSize.y * shadowRadius;\n\t\t\tfloat dx1 = + texelSize.x * shadowRadius;\n\t\t\tfloat dy1 = + texelSize.y * shadowRadius;\n\t\t\treturn (\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx0, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( 0.0, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx1, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx0, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy, shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx1, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx0, dy1 ), shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( 0.0, dy1 ), shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx1, dy1 ), shadowCoord.z )\n\t\t\t) * ( 1.0 / 9.0 );\n\t\t#else\n\t\t\treturn texture2DCompare( shadowMap, shadowCoord.xy, shadowCoord.z );\n\t\t#endif\n\t\t}\n\t\treturn 1.0;\n\t}\n\tvec2 cubeToUV( vec3 v, float texelSizeY ) {\n\t\tvec3 absV = abs( v );\n\t\tfloat scaleToCube = 1.0 / max( absV.x, max( absV.y, absV.z ) );\n\t\tabsV *= scaleToCube;\n\t\tv *= scaleToCube * ( 1.0 - 2.0 * texelSizeY );\n\t\tvec2 planar = v.xy;\n\t\tfloat almostATexel = 1.5 * texelSizeY;\n\t\tfloat almostOne = 1.0 - almostATexel;\n\t\tif ( absV.z >= almostOne ) {\n\t\t\tif ( v.z > 0.0 )\n\t\t\t\tplanar.x = 4.0 - v.x;\n\t\t} else if ( absV.x >= almostOne ) {\n\t\t\tfloat signX = sign( v.x );\n\t\t\tplanar.x = v.z * signX + 2.0 * signX;\n\t\t} else if ( absV.y >= almostOne ) {\n\t\t\tfloat signY = sign( v.y );\n\t\t\tplanar.x = v.x + 2.0 * signY + 2.0;\n\t\t\tplanar.y = v.z * signY - 2.0;\n\t\t}\n\t\treturn vec2( 0.125, 0.25 ) * planar + vec2( 0.375, 0.75 );\n\t}\n\tfloat getPointShadow( sampler2D shadowMap, vec2 shadowMapSize, float shadowBias, float shadowRadius, vec4 shadowCoord ) {\n\t\tvec2 texelSize = vec2( 1.0 ) / ( shadowMapSize * vec2( 4.0, 2.0 ) );\n\t\tvec3 lightToPosition = shadowCoord.xyz;\n\t\tvec3 bd3D = normalize( lightToPosition );\n\t\tfloat dp = ( length( lightToPosition ) - shadowBias ) / 1000.0;\n\t\t#if defined( SHADOWMAP_TYPE_PCF ) || defined( SHADOWMAP_TYPE_PCF_SOFT )\n\t\t\tvec2 offset = vec2( - 1, 1 ) * shadowRadius * texelSize.y;\n\t\t\treturn (\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xyy, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yyy, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xyx, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yyx, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xxy, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yxy, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xxx, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yxx, texelSize.y ), dp )\n\t\t\t) * ( 1.0 / 9.0 );\n\t\t#else\n\t\t\treturn texture2DCompare( shadowMap, cubeToUV( bd3D, texelSize.y ), dp );\n\t\t#endif\n\t}\n#endif\n",Lf="#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHTS > 0\n\t\tuniform mat4 directionalShadowMatrix[ NUM_DIR_LIGHTS ];\n\t\tvarying vec4 vDirectionalShadowCoord[ NUM_DIR_LIGHTS ];\n\t#endif\n\t#if NUM_SPOT_LIGHTS > 0\n\t\tuniform mat4 spotShadowMatrix[ NUM_SPOT_LIGHTS ];\n\t\tvarying vec4 vSpotShadowCoord[ NUM_SPOT_LIGHTS ];\n\t#endif\n\t#if NUM_POINT_LIGHTS > 0\n\t\tuniform mat4 pointShadowMatrix[ NUM_POINT_LIGHTS ];\n\t\tvarying vec4 vPointShadowCoord[ NUM_POINT_LIGHTS ];\n\t#endif\n#endif\n",Rf="#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHTS > 0\n\tfor ( int i = 0; i < NUM_DIR_LIGHTS; i ++ ) {\n\t\tvDirectionalShadowCoord[ i ] = directionalShadowMatrix[ i ] * worldPosition;\n\t}\n\t#endif\n\t#if NUM_SPOT_LIGHTS > 0\n\tfor ( int i = 0; i < NUM_SPOT_LIGHTS; i ++ ) {\n\t\tvSpotShadowCoord[ i ] = spotShadowMatrix[ i ] * worldPosition;\n\t}\n\t#endif\n\t#if NUM_POINT_LIGHTS > 0\n\tfor ( int i = 0; i < NUM_POINT_LIGHTS; i ++ ) {\n\t\tvPointShadowCoord[ i ] = pointShadowMatrix[ i ] * worldPosition;\n\t}\n\t#endif\n#endif\n",Of="float getShadowMask() {\n\tfloat shadow = 1.0;\n\t#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHTS > 0\n\tDirectionalLight directionalLight;\n\tfor ( int i = 0; i < NUM_DIR_LIGHTS; i ++ ) {\n\t\tdirectionalLight = directionalLights[ i ];\n\t\tshadow *= bool( directionalLight.shadow ) ? getShadow( directionalShadowMap[ i ], directionalLight.shadowMapSize, directionalLight.shadowBias, directionalLight.shadowRadius, vDirectionalShadowCoord[ i ] ) : 1.0;\n\t}\n\t#endif\n\t#if NUM_SPOT_LIGHTS > 0\n\tSpotLight spotLight;\n\tfor ( int i = 0; i < NUM_SPOT_LIGHTS; i ++ ) {\n\t\tspotLight = spotLights[ i ];\n\t\tshadow *= bool( spotLight.shadow ) ? getShadow( spotShadowMap[ i ], spotLight.shadowMapSize, spotLight.shadowBias, spotLight.shadowRadius, vSpotShadowCoord[ i ] ) : 1.0;\n\t}\n\t#endif\n\t#if NUM_POINT_LIGHTS > 0\n\tPointLight pointLight;\n\tfor ( int i = 0; i < NUM_POINT_LIGHTS; i ++ ) {\n\t\tpointLight = pointLights[ i ];\n\t\tshadow *= bool( pointLight.shadow ) ? getPointShadow( pointShadowMap[ i ], pointLight.shadowMapSize, pointLight.shadowBias, pointLight.shadowRadius, vPointShadowCoord[ i ] ) : 1.0;\n\t}\n\t#endif\n\t#endif\n\treturn shadow;\n}\n",Df="#ifdef USE_SKINNING\n\tmat4 boneMatX = getBoneMatrix( skinIndex.x );\n\tmat4 boneMatY = getBoneMatrix( skinIndex.y );\n\tmat4 boneMatZ = getBoneMatrix( skinIndex.z );\n\tmat4 boneMatW = getBoneMatrix( skinIndex.w );\n#endif",Nf="#ifdef USE_SKINNING\n\tuniform mat4 bindMatrix;\n\tuniform mat4 bindMatrixInverse;\n\t#ifdef BONE_TEXTURE\n\t\tuniform sampler2D boneTexture;\n\t\tuniform int boneTextureWidth;\n\t\tuniform int boneTextureHeight;\n\t\tmat4 getBoneMatrix( const in float i ) {\n\t\t\tfloat j = i * 4.0;\n\t\t\tfloat x = mod( j, float( boneTextureWidth ) );\n\t\t\tfloat y = floor( j / float( boneTextureWidth ) );\n\t\t\tfloat dx = 1.0 / float( boneTextureWidth );\n\t\t\tfloat dy = 1.0 / float( boneTextureHeight );\n\t\t\ty = dy * ( y + 0.5 );\n\t\t\tvec4 v1 = texture2D( boneTexture, vec2( dx * ( x + 0.5 ), y ) );\n\t\t\tvec4 v2 = texture2D( boneTexture, vec2( dx * ( x + 1.5 ), y ) );\n\t\t\tvec4 v3 = texture2D( boneTexture, vec2( dx * ( x + 2.5 ), y ) );\n\t\t\tvec4 v4 = texture2D( boneTexture, vec2( dx * ( x + 3.5 ), y ) );\n\t\t\tmat4 bone = mat4( v1, v2, v3, v4 );\n\t\t\treturn bone;\n\t\t}\n\t#else\n\t\tuniform mat4 boneMatrices[ MAX_BONES ];\n\t\tmat4 getBoneMatrix( const in float i ) {\n\t\t\tmat4 bone = boneMatrices[ int(i) ];\n\t\t\treturn bone;\n\t\t}\n\t#endif\n#endif\n",kf="#ifdef USE_SKINNING\n\tvec4 skinVertex = bindMatrix * vec4( transformed, 1.0 );\n\tvec4 skinned = vec4( 0.0 );\n\tskinned += boneMatX * skinVertex * skinWeight.x;\n\tskinned += boneMatY * skinVertex * skinWeight.y;\n\tskinned += boneMatZ * skinVertex * skinWeight.z;\n\tskinned += boneMatW * skinVertex * skinWeight.w;\n\tskinned  = bindMatrixInverse * skinned;\n#endif\n",Ff="#ifdef USE_SKINNING\n\tmat4 skinMatrix = mat4( 0.0 );\n\tskinMatrix += skinWeight.x * boneMatX;\n\tskinMatrix += skinWeight.y * boneMatY;\n\tskinMatrix += skinWeight.z * boneMatZ;\n\tskinMatrix += skinWeight.w * boneMatW;\n\tskinMatrix  = bindMatrixInverse * skinMatrix * bindMatrix;\n\tobjectNormal = vec4( skinMatrix * vec4( objectNormal, 0.0 ) ).xyz;\n#endif\n",zf="float specularStrength;\n#ifdef USE_SPECULARMAP\n\tvec4 texelSpecular = texture2D( specularMap, vUv );\n\tspecularStrength = texelSpecular.r;\n#else\n\tspecularStrength = 1.0;\n#endif",Bf="#ifdef USE_SPECULARMAP\n\tuniform sampler2D specularMap;\n#endif",Uf="#if defined( TONE_MAPPING )\n  gl_FragColor.rgb = toneMapping( gl_FragColor.rgb );\n#endif\n",jf="#define saturate(a) clamp( a, 0.0, 1.0 )\nuniform float toneMappingExposure;\nuniform float toneMappingWhitePoint;\nvec3 LinearToneMapping( vec3 color ) {\n  return toneMappingExposure * color;\n}\nvec3 ReinhardToneMapping( vec3 color ) {\n  color *= toneMappingExposure;\n  return saturate( color / ( vec3( 1.0 ) + color ) );\n}\n#define Uncharted2Helper( x ) max( ( ( x * ( 0.15 * x + 0.10 * 0.50 ) + 0.20 * 0.02 ) / ( x * ( 0.15 * x + 0.50 ) + 0.20 * 0.30 ) ) - 0.02 / 0.30, vec3( 0.0 ) )\nvec3 Uncharted2ToneMapping( vec3 color ) {\n  color *= toneMappingExposure;\n  return saturate( Uncharted2Helper( color ) / Uncharted2Helper( vec3( toneMappingWhitePoint ) ) );\n}\nvec3 OptimizedCineonToneMapping( vec3 color ) {\n  color *= toneMappingExposure;\n  color = max( vec3( 0.0 ), color - 0.004 );\n  return pow( ( color * ( 6.2 * color + 0.5 ) ) / ( color * ( 6.2 * color + 1.7 ) + 0.06 ), vec3( 2.2 ) );\n}\n",$f="#if defined( USE_MAP ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( USE_SPECULARMAP ) || defined( USE_ALPHAMAP ) || defined( USE_EMISSIVEMAP ) || defined( USE_ROUGHNESSMAP ) || defined( USE_METALNESSMAP )\n\tvarying vec2 vUv;\n#endif",Vf="#if defined( USE_MAP ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( USE_SPECULARMAP ) || defined( USE_ALPHAMAP ) || defined( USE_EMISSIVEMAP ) || defined( USE_ROUGHNESSMAP ) || defined( USE_METALNESSMAP )\n\tvarying vec2 vUv;\n\tuniform vec4 offsetRepeat;\n#endif\n",Gf="#if defined( USE_MAP ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( USE_SPECULARMAP ) || defined( USE_ALPHAMAP ) || defined( USE_EMISSIVEMAP ) || defined( USE_ROUGHNESSMAP ) || defined( USE_METALNESSMAP )\n\tvUv = uv * offsetRepeat.zw + offsetRepeat.xy;\n#endif",Hf="#if defined( USE_LIGHTMAP ) || defined( USE_AOMAP )\n\tvarying vec2 vUv2;\n#endif",Wf="#if defined( USE_LIGHTMAP ) || defined( USE_AOMAP )\n\tattribute vec2 uv2;\n\tvarying vec2 vUv2;\n#endif",Xf="#if defined( USE_LIGHTMAP ) || defined( USE_AOMAP )\n\tvUv2 = uv2;\n#endif",qf="#if defined( USE_ENVMAP ) || defined( PHONG ) || defined( PHYSICAL ) || defined( LAMBERT ) || defined ( USE_SHADOWMAP )\n\t#ifdef USE_SKINNING\n\t\tvec4 worldPosition = modelMatrix * skinned;\n\t#else\n\t\tvec4 worldPosition = modelMatrix * vec4( transformed, 1.0 );\n\t#endif\n#endif\n",Yf="uniform samplerCube tCube;\nuniform float tFlip;\nuniform float opacity;\nvarying vec3 vWorldPosition;\n#include <common>\nvoid main() {\n\tgl_FragColor = textureCube( tCube, vec3( tFlip * vWorldPosition.x, vWorldPosition.yz ) );\n\tgl_FragColor.a *= opacity;\n}\n",Zf="varying vec3 vWorldPosition;\n#include <common>\nvoid main() {\n\tvWorldPosition = transformDirection( position, modelMatrix );\n\t#include <begin_vertex>\n\t#include <project_vertex>\n}\n",Kf="#if DEPTH_PACKING == 3200\n\tuniform float opacity;\n#endif\n#include <common>\n#include <packing>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( 1.0 );\n\t#if DEPTH_PACKING == 3200\n\t\tdiffuseColor.a = opacity;\n\t#endif\n\t#include <map_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <logdepthbuf_fragment>\n\t#if DEPTH_PACKING == 3200\n\t\tgl_FragColor = vec4( vec3( gl_FragCoord.z ), opacity );\n\t#elif DEPTH_PACKING == 3201\n\t\tgl_FragColor = packDepthToRGBA( gl_FragCoord.z );\n\t#endif\n}\n",Qf="#include <common>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <skinbase_vertex>\n\t#include <begin_vertex>\n\t#include <displacementmap_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n}\n",Jf="uniform vec3 lightPos;\nvarying vec4 vWorldPosition;\n#include <common>\n#include <packing>\n#include <clipping_planes_pars_fragment>\nvoid main () {\n\t#include <clipping_planes_fragment>\n\tgl_FragColor = packDepthToRGBA( length( vWorldPosition.xyz - lightPos.xyz ) / 1000.0 );\n}\n",tp="varying vec4 vWorldPosition;\n#include <common>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <skinbase_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <project_vertex>\n\t#include <worldpos_vertex>\n\t#include <clipping_planes_vertex>\n\tvWorldPosition = worldPosition;\n}\n",ep="uniform sampler2D tEquirect;\nuniform float tFlip;\nvarying vec3 vWorldPosition;\n#include <common>\nvoid main() {\n\tvec3 direction = normalize( vWorldPosition );\n\tvec2 sampleUV;\n\tsampleUV.y = saturate( tFlip * direction.y * -0.5 + 0.5 );\n\tsampleUV.x = atan( direction.z, direction.x ) * RECIPROCAL_PI2 + 0.5;\n\tgl_FragColor = texture2D( tEquirect, sampleUV );\n}\n",ip="varying vec3 vWorldPosition;\n#include <common>\nvoid main() {\n\tvWorldPosition = transformDirection( position, modelMatrix );\n\t#include <begin_vertex>\n\t#include <project_vertex>\n}\n",np="uniform vec3 diffuse;\nuniform float opacity;\nuniform float dashSize;\nuniform float totalSize;\nvarying float vLineDistance;\n#include <common>\n#include <color_pars_fragment>\n#include <fog_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tif ( mod( vLineDistance, totalSize ) > dashSize ) {\n\t\tdiscard;\n\t}\n\tvec3 outgoingLight = vec3( 0.0 );\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <logdepthbuf_fragment>\n\t#include <color_fragment>\n\toutgoingLight = diffuseColor.rgb;\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <premultiplied_alpha_fragment>\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n}\n",rp="uniform float scale;\nattribute float lineDistance;\nvarying float vLineDistance;\n#include <common>\n#include <color_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <color_vertex>\n\tvLineDistance = scale * lineDistance;\n\tvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\n\tgl_Position = projectionMatrix * mvPosition;\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n}\n",op="uniform vec3 diffuse;\nuniform float opacity;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <common>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <aomap_pars_fragment>\n#include <envmap_pars_fragment>\n#include <fog_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <specularmap_fragment>\n\tReflectedLight reflectedLight;\n\treflectedLight.directDiffuse = vec3( 0.0 );\n\treflectedLight.directSpecular = vec3( 0.0 );\n\treflectedLight.indirectDiffuse = diffuseColor.rgb;\n\treflectedLight.indirectSpecular = vec3( 0.0 );\n\t#include <aomap_fragment>\n\tvec3 outgoingLight = reflectedLight.indirectDiffuse;\n\t#include <normal_flip>\n\t#include <envmap_fragment>\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <premultiplied_alpha_fragment>\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n}\n",ap="#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <envmap_pars_vertex>\n#include <color_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <uv2_vertex>\n\t#include <color_vertex>\n\t#include <skinbase_vertex>\n\t#ifdef USE_ENVMAP\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <worldpos_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <envmap_vertex>\n}\n",sp="uniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float opacity;\nvarying vec3 vLightFront;\n#ifdef DOUBLE_SIDED\n\tvarying vec3 vLightBack;\n#endif\n#include <common>\n#include <packing>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <envmap_pars_fragment>\n#include <bsdfs>\n#include <lights_pars>\n#include <fog_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <shadowmask_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <specularmap_fragment>\n\t#include <emissivemap_fragment>\n\treflectedLight.indirectDiffuse = getAmbientLightIrradiance( ambientLightColor );\n\t#include <lightmap_fragment>\n\treflectedLight.indirectDiffuse *= BRDF_Diffuse_Lambert( diffuseColor.rgb );\n\t#ifdef DOUBLE_SIDED\n\t\treflectedLight.directDiffuse = ( gl_FrontFacing ) ? vLightFront : vLightBack;\n\t#else\n\t\treflectedLight.directDiffuse = vLightFront;\n\t#endif\n\treflectedLight.directDiffuse *= BRDF_Diffuse_Lambert( diffuseColor.rgb ) * getShadowMask();\n\t#include <aomap_fragment>\n\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + totalEmissiveRadiance;\n\t#include <normal_flip>\n\t#include <envmap_fragment>\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <premultiplied_alpha_fragment>\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n}\n",cp="#define LAMBERT\nvarying vec3 vLightFront;\n#ifdef DOUBLE_SIDED\n\tvarying vec3 vLightBack;\n#endif\n#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <envmap_pars_vertex>\n#include <bsdfs>\n#include <lights_pars>\n#include <color_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <uv2_vertex>\n\t#include <color_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <worldpos_vertex>\n\t#include <envmap_vertex>\n\t#include <lights_lambert_vertex>\n\t#include <shadowmap_vertex>\n}\n",up="#define PHONG\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform vec3 specular;\nuniform float shininess;\nuniform float opacity;\n#include <common>\n#include <packing>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <envmap_pars_fragment>\n#include <fog_pars_fragment>\n#include <bsdfs>\n#include <lights_pars>\n#include <lights_phong_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <specularmap_fragment>\n\t#include <normal_flip>\n\t#include <normal_fragment>\n\t#include <emissivemap_fragment>\n\t#include <lights_phong_fragment>\n\t#include <lights_template>\n\t#include <aomap_fragment>\n\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveRadiance;\n\t#include <envmap_fragment>\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <premultiplied_alpha_fragment>\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n}\n",hp="#define PHONG\nvarying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <envmap_pars_vertex>\n#include <color_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <uv2_vertex>\n\t#include <color_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n#ifndef FLAT_SHADED\n\tvNormal = normalize( transformedNormal );\n#endif\n\t#include <begin_vertex>\n\t#include <displacementmap_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\tvViewPosition = - mvPosition.xyz;\n\t#include <worldpos_vertex>\n\t#include <envmap_vertex>\n\t#include <shadowmap_vertex>\n}\n",lp="#define PHYSICAL\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float roughness;\nuniform float metalness;\nuniform float opacity;\n#ifndef STANDARD\n\tuniform float clearCoat;\n\tuniform float clearCoatRoughness;\n#endif\nuniform float envMapIntensity;\nvarying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <common>\n#include <packing>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <envmap_pars_fragment>\n#include <fog_pars_fragment>\n#include <bsdfs>\n#include <cube_uv_reflection_fragment>\n#include <lights_pars>\n#include <lights_physical_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <roughnessmap_pars_fragment>\n#include <metalnessmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <specularmap_fragment>\n\t#include <roughnessmap_fragment>\n\t#include <metalnessmap_fragment>\n\t#include <normal_flip>\n\t#include <normal_fragment>\n\t#include <emissivemap_fragment>\n\t#include <lights_physical_fragment>\n\t#include <lights_template>\n\t#include <aomap_fragment>\n\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveRadiance;\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <premultiplied_alpha_fragment>\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n}\n",dp="#define PHYSICAL\nvarying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <color_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <uv2_vertex>\n\t#include <color_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n#ifndef FLAT_SHADED\n\tvNormal = normalize( transformedNormal );\n#endif\n\t#include <begin_vertex>\n\t#include <displacementmap_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\tvViewPosition = - mvPosition.xyz;\n\t#include <worldpos_vertex>\n\t#include <shadowmap_vertex>\n}\n",fp="uniform float opacity;\nvarying vec3 vNormal;\n#include <common>\n#include <packing>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tgl_FragColor = vec4( packNormalToRGB( vNormal ), opacity );\n\t#include <logdepthbuf_fragment>\n}\n",pp="varying vec3 vNormal;\n#include <common>\n#include <morphtarget_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\tvNormal = normalize( normalMatrix * normal );\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n}\n",mp="uniform vec3 diffuse;\nuniform float opacity;\n#include <common>\n#include <packing>\n#include <color_pars_fragment>\n#include <map_particle_pars_fragment>\n#include <fog_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec3 outgoingLight = vec3( 0.0 );\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <logdepthbuf_fragment>\n\t#include <map_particle_fragment>\n\t#include <color_fragment>\n\t#include <alphatest_fragment>\n\toutgoingLight = diffuseColor.rgb;\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <premultiplied_alpha_fragment>\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n}\n",gp="uniform float size;\nuniform float scale;\n#include <common>\n#include <color_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <color_vertex>\n\t#include <begin_vertex>\n\t#include <project_vertex>\n\t#ifdef USE_SIZEATTENUATION\n\t\tgl_PointSize = size * ( scale / - mvPosition.z );\n\t#else\n\t\tgl_PointSize = size;\n\t#endif\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <worldpos_vertex>\n\t#include <shadowmap_vertex>\n}\n",vp="uniform float opacity;\n#include <common>\n#include <packing>\n#include <bsdfs>\n#include <lights_pars>\n#include <shadowmap_pars_fragment>\n#include <shadowmask_pars_fragment>\nvoid main() {\n\tgl_FragColor = vec4( 0.0, 0.0, 0.0, opacity * ( 1.0  - getShadowMask() ) );\n}\n",yp="#include <shadowmap_pars_vertex>\nvoid main() {\n\t#include <begin_vertex>\n\t#include <project_vertex>\n\t#include <worldpos_vertex>\n\t#include <shadowmap_vertex>\n}\n",bp={
	alphamap_fragment:_d,alphamap_pars_fragment:wd,alphatest_fragment:Sd,aomap_fragment:Ad,aomap_pars_fragment:Md,begin_vertex:Cd,beginnormal_vertex:Pd,bsdfs:Td,bumpmap_pars_fragment:Ed,clipping_planes_fragment:Id,clipping_planes_pars_fragment:Ld,clipping_planes_pars_vertex:Rd,clipping_planes_vertex:Od,color_fragment:Dd,color_pars_fragment:Nd,color_pars_vertex:kd,color_vertex:Fd,common:zd,cube_uv_reflection_fragment:Bd,defaultnormal_vertex:Ud,displacementmap_pars_vertex:jd,displacementmap_vertex:$d,emissivemap_fragment:Vd,emissivemap_pars_fragment:Gd,encodings_fragment:Hd,encodings_pars_fragment:Wd,envmap_fragment:Xd,envmap_pars_fragment:qd,envmap_pars_vertex:Yd,envmap_vertex:Zd,fog_fragment:Kd,fog_pars_fragment:Qd,lightmap_fragment:Jd,lightmap_pars_fragment:tf,lights_lambert_vertex:ef,lights_pars:nf,lights_phong_fragment:rf,lights_phong_pars_fragment:of,lights_physical_fragment:af,lights_physical_pars_fragment:sf,lights_template:cf,logdepthbuf_fragment:uf,logdepthbuf_pars_fragment:hf,logdepthbuf_pars_vertex:lf,logdepthbuf_vertex:df,map_fragment:ff,map_pars_fragment:pf,map_particle_fragment:mf,map_particle_pars_fragment:gf,metalnessmap_fragment:vf,metalnessmap_pars_fragment:yf,morphnormal_vertex:bf,morphtarget_pars_vertex:xf,morphtarget_vertex:_f,normal_flip:wf,normal_fragment:Sf,normalmap_pars_fragment:Af,packing:Mf,premultiplied_alpha_fragment:Cf,project_vertex:Pf,roughnessmap_fragment:Tf,roughnessmap_pars_fragment:Ef,shadowmap_pars_fragment:If,shadowmap_pars_vertex:Lf,shadowmap_vertex:Rf,shadowmask_pars_fragment:Of,skinbase_vertex:Df,skinning_pars_vertex:Nf,skinning_vertex:kf,skinnormal_vertex:Ff,specularmap_fragment:zf,specularmap_pars_fragment:Bf,tonemapping_fragment:Uf,tonemapping_pars_fragment:jf,uv_pars_fragment:$f,uv_pars_vertex:Vf,uv_vertex:Gf,uv2_pars_fragment:Hf,uv2_pars_vertex:Wf,uv2_vertex:Xf,worldpos_vertex:qf,cube_frag:Yf,cube_vert:Zf,depth_frag:Kf,depth_vert:Qf,distanceRGBA_frag:Jf,distanceRGBA_vert:tp,equirect_frag:ep,equirect_vert:ip,linedashed_frag:np,linedashed_vert:rp,meshbasic_frag:op,meshbasic_vert:ap,meshlambert_frag:sp,meshlambert_vert:cp,meshphong_frag:up,meshphong_vert:hp,meshphysical_frag:lp,meshphysical_vert:dp,normal_frag:fp,normal_vert:pp,points_frag:mp,points_vert:gp,shadow_frag:vp,shadow_vert:yp};Pt.prototype={constructor:Pt,isColor:!0,r:1,g:1,b:1,set:function(t){return t&&t.isColor?this.copy(t):"number"==typeof t?this.setHex(t):"string"==typeof t&&this.setStyle(t),this},setScalar:function(t){this.r=t,this.g=t,this.b=t},setHex:function(t){return t=Math.floor(t),this.r=(t>>16&255)/255,this.g=(t>>8&255)/255,this.b=(255&t)/255,this},setRGB:function(t,e,i){return this.r=t,this.g=e,this.b=i,this},setHSL:function(){function t(t,e,i){return i<0&&(i+=1),i>1&&(i-=1),i<1/6?t+6*(e-t)*i:i<.5?e:i<2/3?t+6*(e-t)*(2/3-i):t}return function(e,i,n){if(e=dd.euclideanModulo(e,1),i=dd.clamp(i,0,1),n=dd.clamp(n,0,1),0===i)this.r=this.g=this.b=n;else{var r=n<=.5?n*(1+i):n+i-n*i,o=2*n-r;this.r=t(o,r,e+1/3),this.g=t(o,r,e),this.b=t(o,r,e-1/3)}return this}}(),setStyle:function(t){function e(e){void 0!==e&&parseFloat(e)<1&&console.warn("THREE.Color: Alpha component of "+t+" will be ignored.")}var i;if(i=/^((?:rgb|hsl)a?)\(\s*([^\)]*)\)/.exec(t)){var n,r=i[1],o=i[2];switch(r){case"rgb":case"rgba":if(n=/^(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*(,\s*([0-9]*\.?[0-9]+)\s*)?$/.exec(o))return this.r=Math.min(255,parseInt(n[1],10))/255,this.g=Math.min(255,parseInt(n[2],10))/255,this.b=Math.min(255,parseInt(n[3],10))/255,e(n[5]),this;if(n=/^(\d+)\%\s*,\s*(\d+)\%\s*,\s*(\d+)\%\s*(,\s*([0-9]*\.?[0-9]+)\s*)?$/.exec(o))return this.r=Math.min(100,parseInt(n[1],10))/100,this.g=Math.min(100,parseInt(n[2],10))/100,this.b=Math.min(100,parseInt(n[3],10))/100,e(n[5]),this;break;case"hsl":case"hsla":if(n=/^([0-9]*\.?[0-9]+)\s*,\s*(\d+)\%\s*,\s*(\d+)\%\s*(,\s*([0-9]*\.?[0-9]+)\s*)?$/.exec(o)){var a=parseFloat(n[1])/360,s=parseInt(n[2],10)/100,c=parseInt(n[3],10)/100;return e(n[5]),this.setHSL(a,s,c)}}}else if(i=/^\#([A-Fa-f0-9]+)$/.exec(t)){var u=i[1],h=u.length;if(3===h)return this.r=parseInt(u.charAt(0)+u.charAt(0),16)/255,this.g=parseInt(u.charAt(1)+u.charAt(1),16)/255,this.b=parseInt(u.charAt(2)+u.charAt(2),16)/255,this;if(6===h)return this.r=parseInt(u.charAt(0)+u.charAt(1),16)/255,this.g=parseInt(u.charAt(2)+u.charAt(3),16)/255,this.b=parseInt(u.charAt(4)+u.charAt(5),16)/255,this}if(t&&t.length>0){var u=xp[t];void 0!==u?this.setHex(u):console.warn("THREE.Color: Unknown color "+t)}return this},clone:function(){return new this.constructor(this.r,this.g,this.b)},copy:function(t){return this.r=t.r,this.g=t.g,this.b=t.b,this},copyGammaToLinear:function(t,e){return void 0===e&&(e=2),this.r=Math.pow(t.r,e),this.g=Math.pow(t.g,e),this.b=Math.pow(t.b,e),this},copyLinearToGamma:function(t,e){void 0===e&&(e=2);var i=e>0?1/e:1;return this.r=Math.pow(t.r,i),this.g=Math.pow(t.g,i),this.b=Math.pow(t.b,i),this},convertGammaToLinear:function(){var t=this.r,e=this.g,i=this.b;return this.r=t*t,this.g=e*e,this.b=i*i,this},convertLinearToGamma:function(){return this.r=Math.sqrt(this.r),this.g=Math.sqrt(this.g),this.b=Math.sqrt(this.b),this},getHex:function(){return 255*this.r<<16^255*this.g<<8^255*this.b<<0},getHexString:function(){return("000000"+this.getHex().toString(16)).slice(-6)},getHSL:function(t){var e,i,n=t||{h:0,s:0,l:0},r=this.r,o=this.g,a=this.b,s=Math.max(r,o,a),c=Math.min(r,o,a),u=(c+s)/2;if(c===s)e=0,i=0;else{var h=s-c;switch(i=u<=.5?h/(s+c):h/(2-s-c),s){case r:e=(o-a)/h+(o<a?6:0);break;case o:e=(a-r)/h+2;break;case a:e=(r-o)/h+4}e/=6}return n.h=e,n.s=i,n.l=u,n},getStyle:function(){return"rgb("+(255*this.r|0)+","+(255*this.g|0)+","+(255*this.b|0)+")"},offsetHSL:function(t,e,i){var n=this.getHSL();return n.h+=t,n.s+=e,n.l+=i,this.setHSL(n.h,n.s,n.l),this},add:function(t){return this.r+=t.r,this.g+=t.g,this.b+=t.b,this},addColors:function(t,e){return this.r=t.r+e.r,this.g=t.g+e.g,this.b=t.b+e.b,this},addScalar:function(t){return this.r+=t,this.g+=t,this.b+=t,this},sub:function(t){return this.r=Math.max(0,this.r-t.r),this.g=Math.max(0,this.g-t.g),this.b=Math.max(0,this.b-t.b),this},multiply:function(t){return this.r*=t.r,this.g*=t.g,this.b*=t.b,this},multiplyScalar:function(t){return this.r*=t,this.g*=t,this.b*=t,this},lerp:function(t,e){return this.r+=(t.r-this.r)*e,this.g+=(t.g-this.g)*e,this.b+=(t.b-this.b)*e,this},equals:function(t){return t.r===this.r&&t.g===this.g&&t.b===this.b},fromArray:function(t,e){return void 0===e&&(e=0),this.r=t[e],this.g=t[e+1],this.b=t[e+2],this},toArray:function(t,e){return void 0===t&&(t=[]),void 0===e&&(e=0),t[e]=this.r,t[e+1]=this.g,t[e+2]=this.b,t},toJSON:function(){return this.getHex()}};var xp={aliceblue:15792383,antiquewhite:16444375,aqua:65535,aquamarine:8388564,azure:15794175,beige:16119260,bisque:16770244,black:0,blanchedalmond:16772045,blue:255,blueviolet:9055202,brown:10824234,burlywood:14596231,cadetblue:6266528,chartreuse:8388352,chocolate:13789470,coral:16744272,cornflowerblue:6591981,cornsilk:16775388,crimson:14423100,cyan:65535,darkblue:139,darkcyan:35723,darkgoldenrod:12092939,darkgray:11119017,darkgreen:25600,darkgrey:11119017,darkkhaki:12433259,darkmagenta:9109643,darkolivegreen:5597999,darkorange:16747520,darkorchid:10040012,darkred:9109504,darksalmon:15308410,darkseagreen:9419919,darkslateblue:4734347,darkslategray:3100495,darkslategrey:3100495,darkturquoise:52945,darkviolet:9699539,deeppink:16716947,deepskyblue:49151,dimgray:6908265,dimgrey:6908265,dodgerblue:2003199,firebrick:11674146,floralwhite:16775920,forestgreen:2263842,fuchsia:16711935,gainsboro:14474460,ghostwhite:16316671,gold:16766720,goldenrod:14329120,gray:8421504,green:32768,greenyellow:11403055,grey:8421504,honeydew:15794160,hotpink:16738740,indianred:13458524,indigo:4915330,ivory:16777200,khaki:15787660,lavender:15132410,lavenderblush:16773365,lawngreen:8190976,lemonchiffon:16775885,lightblue:11393254,lightcoral:15761536,lightcyan:14745599,lightgoldenrodyellow:16448210,lightgray:13882323,lightgreen:9498256,lightgrey:13882323,lightpink:16758465,lightsalmon:16752762,lightseagreen:2142890,lightskyblue:8900346,lightslategray:7833753,lightslategrey:7833753,lightsteelblue:11584734,lightyellow:16777184,lime:65280,limegreen:3329330,linen:16445670,magenta:16711935,maroon:8388608,mediumaquamarine:6737322,mediumblue:205,mediumorchid:12211667,mediumpurple:9662683,mediumseagreen:3978097,mediumslateblue:8087790,mediumspringgreen:64154,mediumturquoise:4772300,mediumvioletred:13047173,midnightblue:1644912,mintcream:16121850,mistyrose:16770273,moccasin:16770229,navajowhite:16768685,navy:128,oldlace:16643558,olive:8421376,olivedrab:7048739,orange:16753920,orangered:16729344,orchid:14315734,palegoldenrod:15657130,palegreen:10025880,paleturquoise:11529966,palevioletred:14381203,papayawhip:16773077,peachpuff:16767673,peru:13468991,pink:16761035,plum:14524637,powderblue:11591910,purple:8388736,red:16711680,rosybrown:12357519,royalblue:4286945,saddlebrown:9127187,salmon:16416882,sandybrown:16032864,seagreen:3050327,seashell:16774638,sienna:10506797,silver:12632256,skyblue:8900331,slateblue:6970061,slategray:7372944,slategrey:7372944,snow:16775930,springgreen:65407,steelblue:4620980,tan:13808780,teal:32896,thistle:14204888,tomato:16737095,turquoise:4251856,violet:15631086,wheat:16113331,white:16777215,whitesmoke:16119285,yellow:16776960,yellowgreen:10145074},_p={common:{diffuse:{value:new Pt(15658734)},opacity:{value:1},map:{value:null},offsetRepeat:{value:new _t(0,0,1,1)},specularMap:{value:null},alphaMap:{value:null},envMap:{value:null},flipEnvMap:{value:-1},reflectivity:{value:1},refractionRatio:{value:.98}},aomap:{aoMap:{value:null},aoMapIntensity:{value:1}},lightmap:{lightMap:{value:null},lightMapIntensity:{value:1}},emissivemap:{emissiveMap:{value:null}},bumpmap:{bumpMap:{value:null},bumpScale:{value:1}},normalmap:{normalMap:{value:null},normalScale:{value:new I(1,1)}},displacementmap:{displacementMap:{value:null},displacementScale:{value:1},displacementBias:{value:0}},roughnessmap:{roughnessMap:{value:null}},metalnessmap:{metalnessMap:{value:null}},fog:{fogDensity:{value:25e-5},fogNear:{value:1},fogFar:{value:2e3},fogColor:{value:new Pt(16777215)}},lights:{ambientLightColor:{value:[]},directionalLights:{value:[],properties:{direction:{},color:{},shadow:{},shadowBias:{},shadowRadius:{},shadowMapSize:{}}},directionalShadowMap:{value:[]},directionalShadowMatrix:{value:[]},spotLights:{value:[],properties:{color:{},position:{},direction:{},distance:{},coneCos:{},penumbraCos:{},decay:{},shadow:{},shadowBias:{},shadowRadius:{},shadowMapSize:{}}},spotShadowMap:{value:[]},spotShadowMatrix:{value:[]},pointLights:{value:[],properties:{color:{},position:{},decay:{},distance:{},shadow:{},shadowBias:{},shadowRadius:{},shadowMapSize:{}}},pointShadowMap:{value:[]},pointShadowMatrix:{value:[]},hemisphereLights:{value:[],properties:{direction:{},skyColor:{},groundColor:{}}}},points:{diffuse:{value:new Pt(15658734)},opacity:{value:1},size:{value:1},scale:{value:1},map:{value:null},offsetRepeat:{value:new _t(0,0,1,1)}}},wp={basic:{uniforms:xd.merge([_p.common,_p.aomap,_p.fog]),vertexShader:bp.meshbasic_vert,fragmentShader:bp.meshbasic_frag},lambert:{uniforms:xd.merge([_p.common,_p.aomap,_p.lightmap,_p.emissivemap,_p.fog,_p.lights,{emissive:{value:new Pt(0)}}]),vertexShader:bp.meshlambert_vert,fragmentShader:bp.meshlambert_frag},phong:{uniforms:xd.merge([_p.common,_p.aomap,_p.lightmap,_p.emissivemap,_p.bumpmap,_p.normalmap,_p.displacementmap,_p.fog,_p.lights,{emissive:{value:new Pt(0)},specular:{value:new Pt(1118481)},shininess:{value:30}}]),vertexShader:bp.meshphong_vert,fragmentShader:bp.meshphong_frag},standard:{uniforms:xd.merge([_p.common,_p.aomap,_p.lightmap,_p.emissivemap,_p.bumpmap,_p.normalmap,_p.displacementmap,_p.roughnessmap,_p.metalnessmap,_p.fog,_p.lights,{emissive:{value:new Pt(0)},roughness:{value:.5},metalness:{value:0},envMapIntensity:{value:1}}]),vertexShader:bp.meshphysical_vert,fragmentShader:bp.meshphysical_frag},points:{uniforms:xd.merge([_p.points,_p.fog]),vertexShader:bp.points_vert,fragmentShader:bp.points_frag},dashed:{uniforms:xd.merge([_p.common,_p.fog,{scale:{value:1},dashSize:{value:1},totalSize:{value:2}}]),vertexShader:bp.linedashed_vert,fragmentShader:bp.linedashed_frag},depth:{uniforms:xd.merge([_p.common,_p.displacementmap]),vertexShader:bp.depth_vert,fragmentShader:bp.depth_frag},normal:{uniforms:{opacity:{value:1}},vertexShader:bp.normal_vert,fragmentShader:bp.normal_frag},cube:{uniforms:{tCube:{value:null},tFlip:{value:-1},opacity:{value:1}},vertexShader:bp.cube_vert,fragmentShader:bp.cube_frag},equirect:{uniforms:{tEquirect:{value:null},tFlip:{value:-1}},vertexShader:bp.equirect_vert,fragmentShader:bp.equirect_frag},distanceRGBA:{uniforms:{lightPos:{value:new N}},vertexShader:bp.distanceRGBA_vert,fragmentShader:bp.distanceRGBA_frag}};wp.physical={uniforms:xd.merge([wp.standard.uniforms,{clearCoat:{value:0},clearCoatRoughness:{value:0}}]),vertexShader:bp.meshphysical_vert,fragmentShader:bp.meshphysical_frag},Tt.prototype=Object.create(At.prototype),Tt.prototype.constructor=Tt,Tt.prototype.isMeshDepthMaterial=!0,Tt.prototype.copy=function(t){return At.prototype.copy.call(this,t),this.depthPacking=t.depthPacking,this.skinning=t.skinning,this.morphTargets=t.morphTargets,this.map=t.map,this.alphaMap=t.alphaMap,this.displacementMap=t.displacementMap,this.displacementScale=t.displacementScale,this.displacementBias=t.displacementBias,this.wireframe=t.wireframe,this.wireframeLinewidth=t.wireframeLinewidth,this},Et.prototype={constructor:Et,isBox3:!0,set:function(t,e){return this.min.copy(t),this.max.copy(e),this},setFromArray:function(t){for(var e=+(1/0),i=+(1/0),n=+(1/0),r=-(1/0),o=-(1/0),a=-(1/0),s=0,c=t.length;s<c;s+=3){var u=t[s],h=t[s+1],l=t[s+2];u<e&&(e=u),h<i&&(i=h),l<n&&(n=l),u>r&&(r=u),h>o&&(o=h),l>a&&(a=l)}this.min.set(e,i,n),this.max.set(r,o,a)},setFromPoints:function(t){this.makeEmpty();for(var e=0,i=t.length;e<i;e++)this.expandByPoint(t[e]);return this},setFromCenterAndSize:function(){var t=new N;return function(e,i){var n=t.copy(i).multiplyScalar(.5);return this.min.copy(e).sub(n),this.max.copy(e).add(n),this}}(),setFromObject:function(){var t=new N;return function(e){var i=this;return e.updateMatrixWorld(!0),this.makeEmpty(),e.traverse(function(e){var n=e.geometry;if(void 0!==n)if(n&&n.isGeometry)for(var r=n.vertices,o=0,a=r.length;o<a;o++)t.copy(r[o]),t.applyMatrix4(e.matrixWorld),i.expandByPoint(t);else if(n&&n.isBufferGeometry){var s=n.attributes.position;if(void 0!==s){var c,u,h;s&&s.isInterleavedBufferAttribute?(c=s.data.array,u=s.offset,h=s.data.stride):(c=s.array,u=0,h=3);for(var o=u,a=c.length;o<a;o+=h)t.fromArray(c,o),t.applyMatrix4(e.matrixWorld),i.expandByPoint(t)}}}),this}}(),clone:function(){return(new this.constructor).copy(this)},copy:function(t){return this.min.copy(t.min),this.max.copy(t.max),this},makeEmpty:function(){return this.min.x=this.min.y=this.min.z=+(1/0),this.max.x=this.max.y=this.max.z=-(1/0),this},isEmpty:function(){return this.max.x<this.min.x||this.max.y<this.min.y||this.max.z<this.min.z},center:function(t){var e=t||new N;return e.addVectors(this.min,this.max).multiplyScalar(.5)},size:function(t){var e=t||new N;return e.subVectors(this.max,this.min)},expandByPoint:function(t){return this.min.min(t),this.max.max(t),this},expandByVector:function(t){return this.min.sub(t),this.max.add(t),this},expandByScalar:function(t){return this.min.addScalar(-t),this.max.addScalar(t),this},containsPoint:function(t){return!(t.x<this.min.x||t.x>this.max.x||t.y<this.min.y||t.y>this.max.y||t.z<this.min.z||t.z>this.max.z)},containsBox:function(t){return this.min.x<=t.min.x&&t.max.x<=this.max.x&&this.min.y<=t.min.y&&t.max.y<=this.max.y&&this.min.z<=t.min.z&&t.max.z<=this.max.z},getParameter:function(t,e){var i=e||new N;return i.set((t.x-this.min.x)/(this.max.x-this.min.x),(t.y-this.min.y)/(this.max.y-this.min.y),(t.z-this.min.z)/(this.max.z-this.min.z))},intersectsBox:function(t){return!(t.max.x<this.min.x||t.min.x>this.max.x||t.max.y<this.min.y||t.min.y>this.max.y||t.max.z<this.min.z||t.min.z>this.max.z)},intersectsSphere:function(){var t;return function(e){return void 0===t&&(t=new N),this.clampPoint(e.center,t),t.distanceToSquared(e.center)<=e.radius*e.radius}}(),intersectsPlane:function(t){var e,i;return t.normal.x>0?(e=t.normal.x*this.min.x,i=t.normal.x*this.max.x):(e=t.normal.x*this.max.x,i=t.normal.x*this.min.x),t.normal.y>0?(e+=t.normal.y*this.min.y,i+=t.normal.y*this.max.y):(e+=t.normal.y*this.max.y,i+=t.normal.y*this.min.y),t.normal.z>0?(e+=t.normal.z*this.min.z,i+=t.normal.z*this.max.z):(e+=t.normal.z*this.max.z,i+=t.normal.z*this.min.z),e<=t.constant&&i>=t.constant},clampPoint:function(t,e){var i=e||new N;return i.copy(t).clamp(this.min,this.max)},distanceToPoint:function(){var t=new N;return function(e){var i=t.copy(e).clamp(this.min,this.max);return i.sub(e).length()}}(),getBoundingSphere:function(){var t=new N;return function(e){var i=e||new It;return i.center=this.center(),i.radius=.5*this.size(t).length(),i}}(),intersect:function(t){return this.min.max(t.min),this.max.min(t.max),this.isEmpty()&&this.makeEmpty(),this},union:function(t){return this.min.min(t.min),this.max.max(t.max),this},applyMatrix4:function(){var t=[new N,new N,new N,new N,new N,new N,new N,new N];return function(e){return this.isEmpty()?this:(t[0].set(this.min.x,this.min.y,this.min.z).applyMatrix4(e),t[1].set(this.min.x,this.min.y,this.max.z).applyMatrix4(e),t[2].set(this.min.x,this.max.y,this.min.z).applyMatrix4(e),t[3].set(this.min.x,this.max.y,this.max.z).applyMatrix4(e),t[4].set(this.max.x,this.min.y,this.min.z).applyMatrix4(e),t[5].set(this.max.x,this.min.y,this.max.z).applyMatrix4(e),t[6].set(this.max.x,this.max.y,this.min.z).applyMatrix4(e),t[7].set(this.max.x,this.max.y,this.max.z).applyMatrix4(e),this.setFromPoints(t),this)}}(),translate:function(t){return this.min.add(t),this.max.add(t),this},equals:function(t){return t.min.equals(this.min)&&t.max.equals(this.max)}},It.prototype={constructor:It,set:function(t,e){return this.center.copy(t),this.radius=e,this},setFromPoints:function(){var t=new Et;return function(e,i){var n=this.center;void 0!==i?n.copy(i):t.setFromPoints(e).center(n);for(var r=0,o=0,a=e.length;o<a;o++)r=Math.max(r,n.distanceToSquared(e[o]));return this.radius=Math.sqrt(r),this}}(),clone:function(){return(new this.constructor).copy(this)},copy:function(t){return this.center.copy(t.center),this.radius=t.radius,this},empty:function(){return this.radius<=0},containsPoint:function(t){return t.distanceToSquared(this.center)<=this.radius*this.radius},distanceToPoint:function(t){return t.distanceTo(this.center)-this.radius},intersectsSphere:function(t){var e=this.radius+t.radius;return t.center.distanceToSquared(this.center)<=e*e},intersectsBox:function(t){return t.intersectsSphere(this)},intersectsPlane:function(t){return Math.abs(this.center.dot(t.normal)-t.constant)<=this.radius},clampPoint:function(t,e){var i=this.center.distanceToSquared(t),n=e||new N;return n.copy(t),i>this.radius*this.radius&&(n.sub(this.center).normalize(),n.multiplyScalar(this.radius).add(this.center)),n},getBoundingBox:function(t){var e=t||new Et;return e.set(this.center,this.center),e.expandByScalar(this.radius),e},applyMatrix4:function(t){return this.center.applyMatrix4(t),this.radius=this.radius*t.getMaxScaleOnAxis(),this},translate:function(t){return this.center.add(t),this},equals:function(t){return t.center.equals(this.center)&&t.radius===this.radius}},Lt.prototype={constructor:Lt,isMatrix3:!0,set:function(t,e,i,n,r,o,a,s,c){var u=this.elements;return u[0]=t,u[1]=n,u[2]=a,u[3]=e,u[4]=r,u[5]=s,u[6]=i,u[7]=o,u[8]=c,this},identity:function(){return this.set(1,0,0,0,1,0,0,0,1),this},clone:function(){return(new this.constructor).fromArray(this.elements)},copy:function(t){var e=t.elements;return this.set(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]),this},setFromMatrix4:function(t){var e=t.elements;return this.set(e[0],e[4],e[8],e[1],e[5],e[9],e[2],e[6],e[10]),this},applyToVector3Array:function(){var t;return function(e,i,n){void 0===t&&(t=new N),void 0===i&&(i=0),void 0===n&&(n=e.length);for(var r=0,o=i;r<n;r+=3,o+=3)t.fromArray(e,o),t.applyMatrix3(this),t.toArray(e,o);return e}}(),applyToBuffer:function(){var t;return function(e,i,n){void 0===t&&(t=new N),void 0===i&&(i=0),void 0===n&&(n=e.length/e.itemSize);for(var r=0,o=i;r<n;r++,o++)t.x=e.getX(o),t.y=e.getY(o),t.z=e.getZ(o),t.applyMatrix3(this),e.setXYZ(t.x,t.y,t.z);return e}}(),multiplyScalar:function(t){var e=this.elements;return e[0]*=t,e[3]*=t,e[6]*=t,e[1]*=t,e[4]*=t,e[7]*=t,e[2]*=t,e[5]*=t,e[8]*=t,this},determinant:function(){var t=this.elements,e=t[0],i=t[1],n=t[2],r=t[3],o=t[4],a=t[5],s=t[6],c=t[7],u=t[8];return e*o*u-e*a*c-i*r*u+i*a*s+n*r*c-n*o*s},getInverse:function(t,e){t&&t.isMatrix4&&console.error("THREE.Matrix3.getInverse no longer takes a Matrix4 argument.");var i=t.elements,n=this.elements,r=i[0],o=i[1],a=i[2],s=i[3],c=i[4],u=i[5],h=i[6],l=i[7],d=i[8],f=d*c-u*l,p=u*h-d*s,m=l*s-c*h,g=r*f+o*p+a*m;if(0===g){var v="THREE.Matrix3.getInverse(): can't invert matrix, determinant is 0";if(e===!0)throw new Error(v);return console.warn(v),this.identity()}var y=1/g;return n[0]=f*y,n[1]=(a*l-d*o)*y,n[2]=(u*o-a*c)*y,n[3]=p*y,n[4]=(d*r-a*h)*y,n[5]=(a*s-u*r)*y,n[6]=m*y,n[7]=(o*h-l*r)*y,n[8]=(c*r-o*s)*y,this},transpose:function(){var t,e=this.elements;return t=e[1],e[1]=e[3],e[3]=t,t=e[2],e[2]=e[6],e[6]=t,t=e[5],e[5]=e[7],e[7]=t,this},flattenToArrayOffset:function(t,e){return console.warn("THREE.Matrix3: .flattenToArrayOffset is deprecated - just use .toArray instead."),this.toArray(t,e)},getNormalMatrix:function(t){return this.setFromMatrix4(t).getInverse(this).transpose()},transposeIntoArray:function(t){var e=this.elements;return t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],this},fromArray:function(t){return this.elements.set(t),this},toArray:function(t,e){void 0===t&&(t=[]),void 0===e&&(e=0);var i=this.elements;return t[e]=i[0],t[e+1]=i[1],t[e+2]=i[2],t[e+3]=i[3],t[e+4]=i[4],t[e+5]=i[5],t[e+6]=i[6],t[e+7]=i[7],t[e+8]=i[8],t}},Rt.prototype={constructor:Rt,set:function(t,e){return this.normal.copy(t),this.constant=e,this},setComponents:function(t,e,i,n){return this.normal.set(t,e,i),this.constant=n,this},setFromNormalAndCoplanarPoint:function(t,e){return this.normal.copy(t),this.constant=-e.dot(this.normal),this},setFromCoplanarPoints:function(){var t=new N,e=new N;return function(i,n,r){var o=t.subVectors(r,n).cross(e.subVectors(i,n)).normalize();return this.setFromNormalAndCoplanarPoint(o,i),this}}(),clone:function(){return(new this.constructor).copy(this)},copy:function(t){return this.normal.copy(t.normal),this.constant=t.constant,this},normalize:function(){var t=1/this.normal.length();return this.normal.multiplyScalar(t),this.constant*=t,this},negate:function(){return this.constant*=-1,this.normal.negate(),this},distanceToPoint:function(t){return this.normal.dot(t)+this.constant},distanceToSphere:function(t){return this.distanceToPoint(t.center)-t.radius},projectPoint:function(t,e){return this.orthoPoint(t,e).sub(t).negate()},orthoPoint:function(t,e){var i=this.distanceToPoint(t),n=e||new N;return n.copy(this.normal).multiplyScalar(i)},intersectLine:function(){var t=new N;return function(e,i){var n=i||new N,r=e.delta(t),o=this.normal.dot(r);if(0!==o){var a=-(e.start.dot(this.normal)+this.constant)/o;if(!(a<0||a>1))return n.copy(r).multiplyScalar(a).add(e.start)}else if(0===this.distanceToPoint(e.start))return n.copy(e.start)}}(),intersectsLine:function(t){var e=this.distanceToPoint(t.start),i=this.distanceToPoint(t.end);return e<0&&i>0||i<0&&e>0},intersectsBox:function(t){return t.intersectsPlane(this)},intersectsSphere:function(t){return t.intersectsPlane(this)},coplanarPoint:function(t){var e=t||new N;return e.copy(this.normal).multiplyScalar(-this.constant)},applyMatrix4:function(){var t=new N,e=new Lt;return function(i,n){var r=this.coplanarPoint(t).applyMatrix4(i),o=n||e.getNormalMatrix(i),a=this.normal.applyMatrix3(o).normalize();return this.constant=-r.dot(a),this}}(),translate:function(t){return this.constant=this.constant-t.dot(this.normal),this},equals:function(t){return t.normal.equals(this.normal)&&t.constant===this.constant}},Ot.prototype={constructor:Ot,set:function(t,e,i,n,r,o){var a=this.planes;return a[0].copy(t),a[1].copy(e),a[2].copy(i),a[3].copy(n),a[4].copy(r),a[5].copy(o),this},clone:function(){return(new this.constructor).copy(this)},copy:function(t){for(var e=this.planes,i=0;i<6;i++)e[i].copy(t.planes[i]);return this},setFromMatrix:function(t){var e=this.planes,i=t.elements,n=i[0],r=i[1],o=i[2],a=i[3],s=i[4],c=i[5],u=i[6],h=i[7],l=i[8],d=i[9],f=i[10],p=i[11],m=i[12],g=i[13],v=i[14],y=i[15];return e[0].setComponents(a-n,h-s,p-l,y-m).normalize(),e[1].setComponents(a+n,h+s,p+l,y+m).normalize(),e[2].setComponents(a+r,h+c,p+d,y+g).normalize(),e[3].setComponents(a-r,h-c,p-d,y-g).normalize(),e[4].setComponents(a-o,h-u,p-f,y-v).normalize(),e[5].setComponents(a+o,h+u,p+f,y+v).normalize(),this},intersectsObject:function(){var t=new It;return function(e){var i=e.geometry;return null===i.boundingSphere&&i.computeBoundingSphere(),t.copy(i.boundingSphere).applyMatrix4(e.matrixWorld),this.intersectsSphere(t)}}(),intersectsSprite:function(){var t=new It;return function(e){return t.center.set(0,0,0),t.radius=.7071067811865476,t.applyMatrix4(e.matrixWorld),this.intersectsSphere(t)}}(),intersectsSphere:function(t){for(var e=this.planes,i=t.center,n=-t.radius,r=0;r<6;r++){var o=e[r].distanceToPoint(i);if(o<n)return!1}return!0},intersectsBox:function(){var t=new N,e=new N;return function(i){for(var n=this.planes,r=0;r<6;r++){var o=n[r];t.x=o.normal.x>0?i.min.x:i.max.x,e.x=o.normal.x>0?i.max.x:i.min.x,t.y=o.normal.y>0?i.min.y:i.max.y,e.y=o.normal.y>0?i.max.y:i.min.y,t.z=o.normal.z>0?i.min.z:i.max.z,e.z=o.normal.z>0?i.max.z:i.min.z;var a=o.distanceToPoint(t),s=o.distanceToPoint(e);if(a<0&&s<0)return!1}return!0}}(),containsPoint:function(t){for(var e=this.planes,i=0;i<6;i++)if(e[i].distanceToPoint(t)<0)return!1;return!0}};var Sp=0;Kt.prototype={constructor:Kt,isBufferAttribute:!0,get count(){return this.array.length/this.itemSize},set needsUpdate(t){t===!0&&this.version++},setDynamic:function(t){return this.dynamic=t,this},copy:function(t){return this.array=new t.array.constructor(t.array),this.itemSize=t.itemSize,this.normalized=t.normalized,this.dynamic=t.dynamic,this},copyAt:function(t,e,i){t*=this.itemSize,i*=e.itemSize;for(var n=0,r=this.itemSize;n<r;n++)this.array[t+n]=e.array[i+n];return this},copyArray:function(t){return this.array.set(t),this},copyColorsArray:function(t){for(var e=this.array,i=0,n=0,r=t.length;n<r;n++){var o=t[n];void 0===o&&(console.warn("THREE.BufferAttribute.copyColorsArray(): color is undefined",n),o=new Pt),e[i++]=o.r,e[i++]=o.g,e[i++]=o.b}return this},copyIndicesArray:function(t){for(var e=this.array,i=0,n=0,r=t.length;n<r;n++){var o=t[n];e[i++]=o.a,e[i++]=o.b,e[i++]=o.c}return this},copyVector2sArray:function(t){for(var e=this.array,i=0,n=0,r=t.length;n<r;n++){var o=t[n];void 0===o&&(console.warn("THREE.BufferAttribute.copyVector2sArray(): vector is undefined",n),o=new I),e[i++]=o.x,e[i++]=o.y}return this},copyVector3sArray:function(t){for(var e=this.array,i=0,n=0,r=t.length;n<r;n++){var o=t[n];void 0===o&&(console.warn("THREE.BufferAttribute.copyVector3sArray(): vector is undefined",n),o=new N),e[i++]=o.x,e[i++]=o.y,e[i++]=o.z}return this},copyVector4sArray:function(t){for(var e=this.array,i=0,n=0,r=t.length;n<r;n++){var o=t[n];void 0===o&&(console.warn("THREE.BufferAttribute.copyVector4sArray(): vector is undefined",n),o=new _t),e[i++]=o.x,e[i++]=o.y,e[i++]=o.z,e[i++]=o.w}return this},set:function(t,e){return void 0===e&&(e=0),this.array.set(t,e),this},getX:function(t){return this.array[t*this.itemSize]},setX:function(t,e){return this.array[t*this.itemSize]=e,this},getY:function(t){return this.array[t*this.itemSize+1]},setY:function(t,e){return this.array[t*this.itemSize+1]=e,this},getZ:function(t){return this.array[t*this.itemSize+2]},setZ:function(t,e){return this.array[t*this.itemSize+2]=e,this},getW:function(t){return this.array[t*this.itemSize+3]},setW:function(t,e){return this.array[t*this.itemSize+3]=e,this},setXY:function(t,e,i){return t*=this.itemSize,this.array[t+0]=e,this.array[t+1]=i,this},setXYZ:function(t,e,i,n){return t*=this.itemSize,this.array[t+0]=e,this.array[t+1]=i,this.array[t+2]=n,this},setXYZW:function(t,e,i,n,r){return t*=this.itemSize,this.array[t+0]=e,this.array[t+1]=i,this.array[t+2]=n,this.array[t+3]=r,this},clone:function(){return(new this.constructor).copy(this)}},ee.prototype={constructor:ee,clone:function(){return(new this.constructor).copy(this)},copy:function(t){this.a=t.a,this.b=t.b,this.c=t.c,this.normal.copy(t.normal),this.color.copy(t.color),this.materialIndex=t.materialIndex;for(var e=0,i=t.vertexNormals.length;e<i;e++)this.vertexNormals[e]=t.vertexNormals[e].clone();for(var e=0,i=t.vertexColors.length;e<i;e++)this.vertexColors[e]=t.vertexColors[e].clone();return this}},ie.RotationOrders=["XYZ","YZX","ZXY","XZY","YXZ","ZYX"],ie.DefaultOrder="XYZ",ie.prototype={constructor:ie,isEuler:!0,get x(){return this._x},set x(t){this._x=t,this.onChangeCallback()},get y(){return this._y},set y(t){this._y=t,this.onChangeCallback()},get z(){return this._z},set z(t){this._z=t,this.onChangeCallback()},get order(){return this._order},set order(t){this._order=t,this.onChangeCallback()},set:function(t,e,i,n){return this._x=t,this._y=e,this._z=i,this._order=n||this._order,this.onChangeCallback(),this},clone:function(){return new this.constructor(this._x,this._y,this._z,this._order)},copy:function(t){return this._x=t._x,this._y=t._y,this._z=t._z,this._order=t._order,this.onChangeCallback(),this},setFromRotationMatrix:function(t,e,i){var n=dd.clamp,r=t.elements,o=r[0],a=r[4],s=r[8],c=r[1],u=r[5],h=r[9],l=r[2],d=r[6],f=r[10];return e=e||this._order,"XYZ"===e?(this._y=Math.asin(n(s,-1,1)),Math.abs(s)<.99999?(this._x=Math.atan2(-h,f),this._z=Math.atan2(-a,o)):(this._x=Math.atan2(d,u),this._z=0)):"YXZ"===e?(this._x=Math.asin(-n(h,-1,1)),Math.abs(h)<.99999?(this._y=Math.atan2(s,f),this._z=Math.atan2(c,u)):(this._y=Math.atan2(-l,o),this._z=0)):"ZXY"===e?(this._x=Math.asin(n(d,-1,1)),Math.abs(d)<.99999?(this._y=Math.atan2(-l,f),this._z=Math.atan2(-a,u)):(this._y=0,this._z=Math.atan2(c,o))):"ZYX"===e?(this._y=Math.asin(-n(l,-1,1)),Math.abs(l)<.99999?(this._x=Math.atan2(d,f),this._z=Math.atan2(c,o)):(this._x=0,this._z=Math.atan2(-a,u))):"YZX"===e?(this._z=Math.asin(n(c,-1,1)),Math.abs(c)<.99999?(this._x=Math.atan2(-h,u),this._y=Math.atan2(-l,o)):(this._x=0,this._y=Math.atan2(s,f))):"XZY"===e?(this._z=Math.asin(-n(a,-1,1)),Math.abs(a)<.99999?(this._x=Math.atan2(d,u),this._y=Math.atan2(s,o)):(this._x=Math.atan2(-h,f),this._y=0)):console.warn("THREE.Euler: .setFromRotationMatrix() given unsupported order: "+e),this._order=e,i!==!1&&this.onChangeCallback(),this},setFromQuaternion:function(){var t;return function(e,i,n){return void 0===t&&(t=new O),t.makeRotationFromQuaternion(e),this.setFromRotationMatrix(t,i,n)}}(),setFromVector3:function(t,e){return this.set(t.x,t.y,t.z,e||this._order)},reorder:function(){var t=new D;return function(e){return t.setFromEuler(this),this.setFromQuaternion(t,e)}}(),equals:function(t){return t._x===this._x&&t._y===this._y&&t._z===this._z&&t._order===this._order},fromArray:function(t){return this._x=t[0],this._y=t[1],this._z=t[2],void 0!==t[3]&&(this._order=t[3]),this.onChangeCallback(),this},toArray:function(t,e){return void 0===t&&(t=[]),void 0===e&&(e=0),t[e]=this._x,t[e+1]=this._y,t[e+2]=this._z,t[e+3]=this._order,t},toVector3:function(t){return t?t.set(this._x,this._y,this._z):new N(this._x,this._y,this._z)},onChange:function(t){return this.onChangeCallback=t,this},onChangeCallback:function(){}},ne.prototype={constructor:ne,set:function(t){this.mask=1<<t},enable:function(t){this.mask|=1<<t},toggle:function(t){this.mask^=1<<t},disable:function(t){this.mask&=~(1<<t)},test:function(t){return 0!==(this.mask&t.mask)}},re.DefaultUp=new N(0,1,0),
	re.DefaultMatrixAutoUpdate=!0,Object.assign(re.prototype,E.prototype,{isObject3D:!0,applyMatrix:function(t){this.matrix.multiplyMatrices(t,this.matrix),this.matrix.decompose(this.position,this.quaternion,this.scale)},setRotationFromAxisAngle:function(t,e){this.quaternion.setFromAxisAngle(t,e)},setRotationFromEuler:function(t){this.quaternion.setFromEuler(t,!0)},setRotationFromMatrix:function(t){this.quaternion.setFromRotationMatrix(t)},setRotationFromQuaternion:function(t){this.quaternion.copy(t)},rotateOnAxis:function(){var t=new D;return function(e,i){return t.setFromAxisAngle(e,i),this.quaternion.multiply(t),this}}(),rotateX:function(){var t=new N(1,0,0);return function(e){return this.rotateOnAxis(t,e)}}(),rotateY:function(){var t=new N(0,1,0);return function(e){return this.rotateOnAxis(t,e)}}(),rotateZ:function(){var t=new N(0,0,1);return function(e){return this.rotateOnAxis(t,e)}}(),translateOnAxis:function(){var t=new N;return function(e,i){return t.copy(e).applyQuaternion(this.quaternion),this.position.add(t.multiplyScalar(i)),this}}(),translateX:function(){var t=new N(1,0,0);return function(e){return this.translateOnAxis(t,e)}}(),translateY:function(){var t=new N(0,1,0);return function(e){return this.translateOnAxis(t,e)}}(),translateZ:function(){var t=new N(0,0,1);return function(e){return this.translateOnAxis(t,e)}}(),localToWorld:function(t){return t.applyMatrix4(this.matrixWorld)},worldToLocal:function(){var t=new O;return function(e){return e.applyMatrix4(t.getInverse(this.matrixWorld))}}(),lookAt:function(){var t=new O;return function(e){t.lookAt(e,this.position,this.up),this.quaternion.setFromRotationMatrix(t)}}(),add:function(t){if(arguments.length>1){for(var e=0;e<arguments.length;e++)this.add(arguments[e]);return this}return t===this?(console.error("THREE.Object3D.add: object can't be added as a child of itself.",t),this):(t&&t.isObject3D?(null!==t.parent&&t.parent.remove(t),t.parent=this,t.dispatchEvent({type:"added"}),this.children.push(t)):console.error("THREE.Object3D.add: object not an instance of THREE.Object3D.",t),this)},remove:function(t){if(arguments.length>1)for(var e=0;e<arguments.length;e++)this.remove(arguments[e]);var i=this.children.indexOf(t);i!==-1&&(t.parent=null,t.dispatchEvent({type:"removed"}),this.children.splice(i,1))},getObjectById:function(t){return this.getObjectByProperty("id",t)},getObjectByName:function(t){return this.getObjectByProperty("name",t)},getObjectByProperty:function(t,e){if(this[t]===e)return this;for(var i=0,n=this.children.length;i<n;i++){var r=this.children[i],o=r.getObjectByProperty(t,e);if(void 0!==o)return o}},getWorldPosition:function(t){var e=t||new N;return this.updateMatrixWorld(!0),e.setFromMatrixPosition(this.matrixWorld)},getWorldQuaternion:function(){var t=new N,e=new N;return function(i){var n=i||new D;return this.updateMatrixWorld(!0),this.matrixWorld.decompose(t,n,e),n}}(),getWorldRotation:function(){var t=new D;return function(e){var i=e||new ie;return this.getWorldQuaternion(t),i.setFromQuaternion(t,this.rotation.order,!1)}}(),getWorldScale:function(){var t=new N,e=new D;return function(i){var n=i||new N;return this.updateMatrixWorld(!0),this.matrixWorld.decompose(t,e,n),n}}(),getWorldDirection:function(){var t=new D;return function(e){var i=e||new N;return this.getWorldQuaternion(t),i.set(0,0,1).applyQuaternion(t)}}(),raycast:function(){},traverse:function(t){t(this);for(var e=this.children,i=0,n=e.length;i<n;i++)e[i].traverse(t)},traverseVisible:function(t){if(this.visible!==!1){t(this);for(var e=this.children,i=0,n=e.length;i<n;i++)e[i].traverseVisible(t)}},traverseAncestors:function(t){var e=this.parent;null!==e&&(t(e),e.traverseAncestors(t))},updateMatrix:function(){this.matrix.compose(this.position,this.quaternion,this.scale),this.matrixWorldNeedsUpdate=!0},updateMatrixWorld:function(t){this.matrixAutoUpdate===!0&&this.updateMatrix(),this.matrixWorldNeedsUpdate!==!0&&t!==!0||(null===this.parent?this.matrixWorld.copy(this.matrix):this.matrixWorld.multiplyMatrices(this.parent.matrixWorld,this.matrix),this.matrixWorldNeedsUpdate=!1,t=!0);for(var e=this.children,i=0,n=e.length;i<n;i++)e[i].updateMatrixWorld(t)},toJSON:function(t){function e(t){var e=[];for(var i in t){var n=t[i];delete n.metadata,e.push(n)}return e}var i=void 0===t||""===t,n={};i&&(t={geometries:{},materials:{},textures:{},images:{}},n.metadata={version:4.4,type:"Object",generator:"Object3D.toJSON"});var r={};if(r.uuid=this.uuid,r.type=this.type,""!==this.name&&(r.name=this.name),"{}"!==JSON.stringify(this.userData)&&(r.userData=this.userData),this.castShadow===!0&&(r.castShadow=!0),this.receiveShadow===!0&&(r.receiveShadow=!0),this.visible===!1&&(r.visible=!1),r.matrix=this.matrix.toArray(),void 0!==this.geometry&&(void 0===t.geometries[this.geometry.uuid]&&(t.geometries[this.geometry.uuid]=this.geometry.toJSON(t)),r.geometry=this.geometry.uuid),void 0!==this.material&&(void 0===t.materials[this.material.uuid]&&(t.materials[this.material.uuid]=this.material.toJSON(t)),r.material=this.material.uuid),this.children.length>0){r.children=[];for(var o=0;o<this.children.length;o++)r.children.push(this.children[o].toJSON(t).object)}if(i){var a=e(t.geometries),s=e(t.materials),c=e(t.textures),u=e(t.images);a.length>0&&(n.geometries=a),s.length>0&&(n.materials=s),c.length>0&&(n.textures=c),u.length>0&&(n.images=u)}return n.object=r,n},clone:function(t){return(new this.constructor).copy(this,t)},copy:function(t,e){if(void 0===e&&(e=!0),this.name=t.name,this.up.copy(t.up),this.position.copy(t.position),this.quaternion.copy(t.quaternion),this.scale.copy(t.scale),this.matrix.copy(t.matrix),this.matrixWorld.copy(t.matrixWorld),this.matrixAutoUpdate=t.matrixAutoUpdate,this.matrixWorldNeedsUpdate=t.matrixWorldNeedsUpdate,this.visible=t.visible,this.castShadow=t.castShadow,this.receiveShadow=t.receiveShadow,this.frustumCulled=t.frustumCulled,this.renderOrder=t.renderOrder,this.userData=JSON.parse(JSON.stringify(t.userData)),e===!0)for(var i=0;i<t.children.length;i++){var n=t.children[i];this.add(n.clone())}return this}});var Ap=0;Object.assign(ae.prototype,E.prototype,{isGeometry:!0,applyMatrix:function(t){for(var e=(new Lt).getNormalMatrix(t),i=0,n=this.vertices.length;i<n;i++){var r=this.vertices[i];r.applyMatrix4(t)}for(var i=0,n=this.faces.length;i<n;i++){var o=this.faces[i];o.normal.applyMatrix3(e).normalize();for(var a=0,s=o.vertexNormals.length;a<s;a++)o.vertexNormals[a].applyMatrix3(e).normalize()}return null!==this.boundingBox&&this.computeBoundingBox(),null!==this.boundingSphere&&this.computeBoundingSphere(),this.verticesNeedUpdate=!0,this.normalsNeedUpdate=!0,this},rotateX:function(){var t;return function(e){return void 0===t&&(t=new O),t.makeRotationX(e),this.applyMatrix(t),this}}(),rotateY:function(){var t;return function(e){return void 0===t&&(t=new O),t.makeRotationY(e),this.applyMatrix(t),this}}(),rotateZ:function(){var t;return function(e){return void 0===t&&(t=new O),t.makeRotationZ(e),this.applyMatrix(t),this}}(),translate:function(){var t;return function(e,i,n){return void 0===t&&(t=new O),t.makeTranslation(e,i,n),this.applyMatrix(t),this}}(),scale:function(){var t;return function(e,i,n){return void 0===t&&(t=new O),t.makeScale(e,i,n),this.applyMatrix(t),this}}(),lookAt:function(){var t;return function(e){void 0===t&&(t=new re),t.lookAt(e),t.updateMatrix(),this.applyMatrix(t.matrix)}}(),fromBufferGeometry:function(t){function e(t,e,n,r){var o=void 0!==a?[h[t].clone(),h[e].clone(),h[n].clone()]:[],f=void 0!==s?[i.colors[t].clone(),i.colors[e].clone(),i.colors[n].clone()]:[],p=new ee(t,e,n,o,f,r);i.faces.push(p),void 0!==c&&i.faceVertexUvs[0].push([l[t].clone(),l[e].clone(),l[n].clone()]),void 0!==u&&i.faceVertexUvs[1].push([d[t].clone(),d[e].clone(),d[n].clone()])}var i=this,n=null!==t.index?t.index.array:void 0,r=t.attributes,o=r.position.array,a=void 0!==r.normal?r.normal.array:void 0,s=void 0!==r.color?r.color.array:void 0,c=void 0!==r.uv?r.uv.array:void 0,u=void 0!==r.uv2?r.uv2.array:void 0;void 0!==u&&(this.faceVertexUvs[1]=[]);for(var h=[],l=[],d=[],f=0,p=0;f<o.length;f+=3,p+=2)i.vertices.push(new N(o[f],o[f+1],o[f+2])),void 0!==a&&h.push(new N(a[f],a[f+1],a[f+2])),void 0!==s&&i.colors.push(new Pt(s[f],s[f+1],s[f+2])),void 0!==c&&l.push(new I(c[p],c[p+1])),void 0!==u&&d.push(new I(u[p],u[p+1]));if(void 0!==n){var m=t.groups;if(m.length>0)for(var f=0;f<m.length;f++)for(var g=m[f],v=g.start,y=g.count,p=v,b=v+y;p<b;p+=3)e(n[p],n[p+1],n[p+2],g.materialIndex);else for(var f=0;f<n.length;f+=3)e(n[f],n[f+1],n[f+2])}else for(var f=0;f<o.length/3;f+=3)e(f,f+1,f+2);return this.computeFaceNormals(),null!==t.boundingBox&&(this.boundingBox=t.boundingBox.clone()),null!==t.boundingSphere&&(this.boundingSphere=t.boundingSphere.clone()),this},center:function(){this.computeBoundingBox();var t=this.boundingBox.center().negate();return this.translate(t.x,t.y,t.z),t},normalize:function(){this.computeBoundingSphere();var t=this.boundingSphere.center,e=this.boundingSphere.radius,i=0===e?1:1/e,n=new O;return n.set(i,0,0,-i*t.x,0,i,0,-i*t.y,0,0,i,-i*t.z,0,0,0,1),this.applyMatrix(n),this},computeFaceNormals:function(){for(var t=new N,e=new N,i=0,n=this.faces.length;i<n;i++){var r=this.faces[i],o=this.vertices[r.a],a=this.vertices[r.b],s=this.vertices[r.c];t.subVectors(s,a),e.subVectors(o,a),t.cross(e),t.normalize(),r.normal.copy(t)}},computeVertexNormals:function(t){void 0===t&&(t=!0);var e,i,n,r,o,a;for(a=new Array(this.vertices.length),e=0,i=this.vertices.length;e<i;e++)a[e]=new N;if(t){var s,c,u,h=new N,l=new N;for(n=0,r=this.faces.length;n<r;n++)o=this.faces[n],s=this.vertices[o.a],c=this.vertices[o.b],u=this.vertices[o.c],h.subVectors(u,c),l.subVectors(s,c),h.cross(l),a[o.a].add(h),a[o.b].add(h),a[o.c].add(h)}else for(n=0,r=this.faces.length;n<r;n++)o=this.faces[n],a[o.a].add(o.normal),a[o.b].add(o.normal),a[o.c].add(o.normal);for(e=0,i=this.vertices.length;e<i;e++)a[e].normalize();for(n=0,r=this.faces.length;n<r;n++){o=this.faces[n];var d=o.vertexNormals;3===d.length?(d[0].copy(a[o.a]),d[1].copy(a[o.b]),d[2].copy(a[o.c])):(d[0]=a[o.a].clone(),d[1]=a[o.b].clone(),d[2]=a[o.c].clone())}this.faces.length>0&&(this.normalsNeedUpdate=!0)},computeMorphNormals:function(){var t,e,i,n,r;for(i=0,n=this.faces.length;i<n;i++)for(r=this.faces[i],r.__originalFaceNormal?r.__originalFaceNormal.copy(r.normal):r.__originalFaceNormal=r.normal.clone(),r.__originalVertexNormals||(r.__originalVertexNormals=[]),t=0,e=r.vertexNormals.length;t<e;t++)r.__originalVertexNormals[t]?r.__originalVertexNormals[t].copy(r.vertexNormals[t]):r.__originalVertexNormals[t]=r.vertexNormals[t].clone();var o=new ae;for(o.faces=this.faces,t=0,e=this.morphTargets.length;t<e;t++){if(!this.morphNormals[t]){this.morphNormals[t]={},this.morphNormals[t].faceNormals=[],this.morphNormals[t].vertexNormals=[];var a,s,c=this.morphNormals[t].faceNormals,u=this.morphNormals[t].vertexNormals;for(i=0,n=this.faces.length;i<n;i++)a=new N,s={a:new N,b:new N,c:new N},c.push(a),u.push(s)}var h=this.morphNormals[t];o.vertices=this.morphTargets[t].vertices,o.computeFaceNormals(),o.computeVertexNormals();var a,s;for(i=0,n=this.faces.length;i<n;i++)r=this.faces[i],a=h.faceNormals[i],s=h.vertexNormals[i],a.copy(r.normal),s.a.copy(r.vertexNormals[0]),s.b.copy(r.vertexNormals[1]),s.c.copy(r.vertexNormals[2])}for(i=0,n=this.faces.length;i<n;i++)r=this.faces[i],r.normal=r.__originalFaceNormal,r.vertexNormals=r.__originalVertexNormals},computeTangents:function(){console.warn("THREE.Geometry: .computeTangents() has been removed.")},computeLineDistances:function(){for(var t=0,e=this.vertices,i=0,n=e.length;i<n;i++)i>0&&(t+=e[i].distanceTo(e[i-1])),this.lineDistances[i]=t},computeBoundingBox:function(){null===this.boundingBox&&(this.boundingBox=new Et),this.boundingBox.setFromPoints(this.vertices)},computeBoundingSphere:function(){null===this.boundingSphere&&(this.boundingSphere=new It),this.boundingSphere.setFromPoints(this.vertices)},merge:function(t,e,i){if((t&&t.isGeometry)===!1)return void console.error("THREE.Geometry.merge(): geometry not an instance of THREE.Geometry.",t);var n,r=this.vertices.length,o=this.vertices,a=t.vertices,s=this.faces,c=t.faces,u=this.faceVertexUvs[0],h=t.faceVertexUvs[0];void 0===i&&(i=0),void 0!==e&&(n=(new Lt).getNormalMatrix(e));for(var l=0,d=a.length;l<d;l++){var f=a[l],p=f.clone();void 0!==e&&p.applyMatrix4(e),o.push(p)}for(l=0,d=c.length;l<d;l++){var m,g,v,y=c[l],b=y.vertexNormals,x=y.vertexColors;m=new ee(y.a+r,y.b+r,y.c+r),m.normal.copy(y.normal),void 0!==n&&m.normal.applyMatrix3(n).normalize();for(var _=0,w=b.length;_<w;_++)g=b[_].clone(),void 0!==n&&g.applyMatrix3(n).normalize(),m.vertexNormals.push(g);m.color.copy(y.color);for(var _=0,w=x.length;_<w;_++)v=x[_],m.vertexColors.push(v.clone());m.materialIndex=y.materialIndex+i,s.push(m)}for(l=0,d=h.length;l<d;l++){var S=h[l],A=[];if(void 0!==S){for(var _=0,w=S.length;_<w;_++)A.push(S[_].clone());u.push(A)}}},mergeMesh:function(t){return(t&&t.isMesh)===!1?void console.error("THREE.Geometry.mergeMesh(): mesh not an instance of THREE.Mesh.",t):(t.matrixAutoUpdate&&t.updateMatrix(),void this.merge(t.geometry,t.matrix))},mergeVertices:function(){var t,e,i,n,r,o,a,s,c={},u=[],h=[],l=4,d=Math.pow(10,l);for(i=0,n=this.vertices.length;i<n;i++)t=this.vertices[i],e=Math.round(t.x*d)+"_"+Math.round(t.y*d)+"_"+Math.round(t.z*d),void 0===c[e]?(c[e]=i,u.push(this.vertices[i]),h[i]=u.length-1):h[i]=h[c[e]];var f=[];for(i=0,n=this.faces.length;i<n;i++){r=this.faces[i],r.a=h[r.a],r.b=h[r.b],r.c=h[r.c],o=[r.a,r.b,r.c];for(var p=-1,m=0;m<3;m++)if(o[m]===o[(m+1)%3]){p=m,f.push(i);break}}for(i=f.length-1;i>=0;i--){var g=f[i];for(this.faces.splice(g,1),a=0,s=this.faceVertexUvs.length;a<s;a++)this.faceVertexUvs[a].splice(g,1)}var v=this.vertices.length-u.length;return this.vertices=u,v},sortFacesByMaterialIndex:function(){function t(t,e){return t.materialIndex-e.materialIndex}for(var e=this.faces,i=e.length,n=0;n<i;n++)e[n]._id=n;e.sort(t);var r,o,a=this.faceVertexUvs[0],s=this.faceVertexUvs[1];a&&a.length===i&&(r=[]),s&&s.length===i&&(o=[]);for(var n=0;n<i;n++){var c=e[n]._id;r&&r.push(a[c]),o&&o.push(s[c])}r&&(this.faceVertexUvs[0]=r),o&&(this.faceVertexUvs[1]=o)},toJSON:function(){function t(t,e,i){return i?t|1<<e:t&~(1<<e)}function e(t){var e=t.x.toString()+t.y.toString()+t.z.toString();return void 0!==d[e]?d[e]:(d[e]=l.length/3,l.push(t.x,t.y,t.z),d[e])}function i(t){var e=t.r.toString()+t.g.toString()+t.b.toString();return void 0!==p[e]?p[e]:(p[e]=f.length,f.push(t.getHex()),p[e])}function n(t){var e=t.x.toString()+t.y.toString();return void 0!==g[e]?g[e]:(g[e]=m.length/2,m.push(t.x,t.y),g[e])}var r={metadata:{version:4.4,type:"Geometry",generator:"Geometry.toJSON"}};if(r.uuid=this.uuid,r.type=this.type,""!==this.name&&(r.name=this.name),void 0!==this.parameters){var o=this.parameters;for(var a in o)void 0!==o[a]&&(r[a]=o[a]);return r}for(var s=[],c=0;c<this.vertices.length;c++){var u=this.vertices[c];s.push(u.x,u.y,u.z)}for(var h=[],l=[],d={},f=[],p={},m=[],g={},c=0;c<this.faces.length;c++){var v=this.faces[c],y=!0,b=!1,x=void 0!==this.faceVertexUvs[0][c],_=v.normal.length()>0,w=v.vertexNormals.length>0,S=1!==v.color.r||1!==v.color.g||1!==v.color.b,A=v.vertexColors.length>0,M=0;if(M=t(M,0,0),M=t(M,1,y),M=t(M,2,b),M=t(M,3,x),M=t(M,4,_),M=t(M,5,w),M=t(M,6,S),M=t(M,7,A),h.push(M),h.push(v.a,v.b,v.c),h.push(v.materialIndex),x){var C=this.faceVertexUvs[0][c];h.push(n(C[0]),n(C[1]),n(C[2]))}if(_&&h.push(e(v.normal)),w){var P=v.vertexNormals;h.push(e(P[0]),e(P[1]),e(P[2]))}if(S&&h.push(i(v.color)),A){var T=v.vertexColors;h.push(i(T[0]),i(T[1]),i(T[2]))}}return r.data={},r.data.vertices=s,r.data.normals=l,f.length>0&&(r.data.colors=f),m.length>0&&(r.data.uvs=[m]),r.data.faces=h,r},clone:function(){return(new ae).copy(this)},copy:function(t){this.vertices=[],this.faces=[],this.faceVertexUvs=[[]];for(var e=t.vertices,i=0,n=e.length;i<n;i++)this.vertices.push(e[i].clone());for(var r=t.faces,i=0,n=r.length;i<n;i++)this.faces.push(r[i].clone());for(var i=0,n=t.faceVertexUvs.length;i<n;i++){var o=t.faceVertexUvs[i];void 0===this.faceVertexUvs[i]&&(this.faceVertexUvs[i]=[]);for(var a=0,s=o.length;a<s;a++){for(var c=o[a],u=[],h=0,l=c.length;h<l;h++){var d=c[h];u.push(d.clone())}this.faceVertexUvs[i].push(u)}}return this},dispose:function(){this.dispatchEvent({type:"dispose"})}});var Mp=0;Object.assign(ce.prototype,E.prototype,{computeBoundingBox:ae.prototype.computeBoundingBox,computeBoundingSphere:ae.prototype.computeBoundingSphere,computeFaceNormals:function(){console.warn("THREE.DirectGeometry: computeFaceNormals() is not a method of this type of geometry.")},computeVertexNormals:function(){console.warn("THREE.DirectGeometry: computeVertexNormals() is not a method of this type of geometry.")},computeGroups:function(t){for(var e,i,n=[],r=t.faces,o=0;o<r.length;o++){var a=r[o];a.materialIndex!==i&&(i=a.materialIndex,void 0!==e&&(e.count=3*o-e.start,n.push(e)),e={start:3*o,materialIndex:i})}void 0!==e&&(e.count=3*o-e.start,n.push(e)),this.groups=n},fromGeometry:function(t){var e,i=t.faces,n=t.vertices,r=t.faceVertexUvs,o=r[0]&&r[0].length>0,a=r[1]&&r[1].length>0,s=t.morphTargets,c=s.length;if(c>0){e=[];for(var u=0;u<c;u++)e[u]=[];this.morphTargets.position=e}var h,l=t.morphNormals,d=l.length;if(d>0){h=[];for(var u=0;u<d;u++)h[u]=[];this.morphTargets.normal=h}for(var f=t.skinIndices,p=t.skinWeights,m=f.length===n.length,g=p.length===n.length,u=0;u<i.length;u++){var v=i[u];this.vertices.push(n[v.a],n[v.b],n[v.c]);var y=v.vertexNormals;if(3===y.length)this.normals.push(y[0],y[1],y[2]);else{var b=v.normal;this.normals.push(b,b,b)}var x=v.vertexColors;if(3===x.length)this.colors.push(x[0],x[1],x[2]);else{var _=v.color;this.colors.push(_,_,_)}if(o===!0){var w=r[0][u];void 0!==w?this.uvs.push(w[0],w[1],w[2]):(console.warn("THREE.DirectGeometry.fromGeometry(): Undefined vertexUv ",u),this.uvs.push(new I,new I,new I))}if(a===!0){var w=r[1][u];void 0!==w?this.uvs2.push(w[0],w[1],w[2]):(console.warn("THREE.DirectGeometry.fromGeometry(): Undefined vertexUv2 ",u),this.uvs2.push(new I,new I,new I))}for(var S=0;S<c;S++){var A=s[S].vertices;e[S].push(A[v.a],A[v.b],A[v.c])}for(var S=0;S<d;S++){var M=l[S].vertexNormals[u];h[S].push(M.a,M.b,M.c)}m&&this.skinIndices.push(f[v.a],f[v.b],f[v.c]),g&&this.skinWeights.push(p[v.a],p[v.b],p[v.c])}return this.computeGroups(t),this.verticesNeedUpdate=t.verticesNeedUpdate,this.normalsNeedUpdate=t.normalsNeedUpdate,this.colorsNeedUpdate=t.colorsNeedUpdate,this.uvsNeedUpdate=t.uvsNeedUpdate,this.groupsNeedUpdate=t.groupsNeedUpdate,this},dispose:function(){this.dispatchEvent({type:"dispose"})}}),Object.assign(ue.prototype,E.prototype,{isBufferGeometry:!0,getIndex:function(){return this.index},setIndex:function(t){this.index=t},addAttribute:function(t,e){return(e&&e.isBufferAttribute)===!1&&(e&&e.isInterleavedBufferAttribute)===!1?(console.warn("THREE.BufferGeometry: .addAttribute() now expects ( name, attribute )."),void this.addAttribute(t,new Kt(arguments[1],arguments[2]))):"index"===t?(console.warn("THREE.BufferGeometry.addAttribute: Use .setIndex() for index attribute."),void this.setIndex(e)):(this.attributes[t]=e,this)},getAttribute:function(t){return this.attributes[t]},removeAttribute:function(t){return delete this.attributes[t],this},addGroup:function(t,e,i){this.groups.push({start:t,count:e,materialIndex:void 0!==i?i:0})},clearGroups:function(){this.groups=[]},setDrawRange:function(t,e){this.drawRange.start=t,this.drawRange.count=e},applyMatrix:function(t){var e=this.attributes.position;void 0!==e&&(t.applyToVector3Array(e.array),e.needsUpdate=!0);var i=this.attributes.normal;if(void 0!==i){var n=(new Lt).getNormalMatrix(t);n.applyToVector3Array(i.array),i.needsUpdate=!0}return null!==this.boundingBox&&this.computeBoundingBox(),null!==this.boundingSphere&&this.computeBoundingSphere(),this},rotateX:function(){var t;return function(e){return void 0===t&&(t=new O),t.makeRotationX(e),this.applyMatrix(t),this}}(),rotateY:function(){var t;return function(e){return void 0===t&&(t=new O),t.makeRotationY(e),this.applyMatrix(t),this}}(),rotateZ:function(){var t;return function(e){return void 0===t&&(t=new O),t.makeRotationZ(e),this.applyMatrix(t),this}}(),translate:function(){var t;return function(e,i,n){return void 0===t&&(t=new O),t.makeTranslation(e,i,n),this.applyMatrix(t),this}}(),scale:function(){var t;return function(e,i,n){return void 0===t&&(t=new O),t.makeScale(e,i,n),this.applyMatrix(t),this}}(),lookAt:function(){var t;return function(e){void 0===t&&(t=new re),t.lookAt(e),t.updateMatrix(),this.applyMatrix(t.matrix)}}(),center:function(){this.computeBoundingBox();var t=this.boundingBox.center().negate();return this.translate(t.x,t.y,t.z),t},setFromObject:function(t){var e=t.geometry;if(t&&t.isPoints||t&&t.isLine){var i=new te(3*e.vertices.length,3),n=new te(3*e.colors.length,3);if(this.addAttribute("position",i.copyVector3sArray(e.vertices)),this.addAttribute("color",n.copyColorsArray(e.colors)),e.lineDistances&&e.lineDistances.length===e.vertices.length){var r=new te(e.lineDistances.length,1);this.addAttribute("lineDistance",r.copyArray(e.lineDistances))}null!==e.boundingSphere&&(this.boundingSphere=e.boundingSphere.clone()),null!==e.boundingBox&&(this.boundingBox=e.boundingBox.clone())}else t&&t.isMesh&&e&&e.isGeometry&&this.fromGeometry(e);return this},updateFromObject:function(t){var e=t.geometry;if(t&&t.isMesh){var i=e.__directGeometry;if(e.elementsNeedUpdate===!0&&(i=void 0,e.elementsNeedUpdate=!1),void 0===i)return this.fromGeometry(e);i.verticesNeedUpdate=e.verticesNeedUpdate,i.normalsNeedUpdate=e.normalsNeedUpdate,i.colorsNeedUpdate=e.colorsNeedUpdate,i.uvsNeedUpdate=e.uvsNeedUpdate,i.groupsNeedUpdate=e.groupsNeedUpdate,e.verticesNeedUpdate=!1,e.normalsNeedUpdate=!1,e.colorsNeedUpdate=!1,e.uvsNeedUpdate=!1,e.groupsNeedUpdate=!1,e=i}var n;return e.verticesNeedUpdate===!0&&(n=this.attributes.position,void 0!==n&&(n.copyVector3sArray(e.vertices),n.needsUpdate=!0),e.verticesNeedUpdate=!1),e.normalsNeedUpdate===!0&&(n=this.attributes.normal,void 0!==n&&(n.copyVector3sArray(e.normals),n.needsUpdate=!0),e.normalsNeedUpdate=!1),e.colorsNeedUpdate===!0&&(n=this.attributes.color,void 0!==n&&(n.copyColorsArray(e.colors),n.needsUpdate=!0),e.colorsNeedUpdate=!1),e.uvsNeedUpdate&&(n=this.attributes.uv,void 0!==n&&(n.copyVector2sArray(e.uvs),n.needsUpdate=!0),e.uvsNeedUpdate=!1),e.lineDistancesNeedUpdate&&(n=this.attributes.lineDistance,void 0!==n&&(n.copyArray(e.lineDistances),n.needsUpdate=!0),e.lineDistancesNeedUpdate=!1),e.groupsNeedUpdate&&(e.computeGroups(t.geometry),this.groups=e.groups,e.groupsNeedUpdate=!1),this},fromGeometry:function(t){return t.__directGeometry=(new ce).fromGeometry(t),this.fromDirectGeometry(t.__directGeometry)},fromDirectGeometry:function(t){var e=new Float32Array(3*t.vertices.length);if(this.addAttribute("position",new Kt(e,3).copyVector3sArray(t.vertices)),t.normals.length>0){var i=new Float32Array(3*t.normals.length);this.addAttribute("normal",new Kt(i,3).copyVector3sArray(t.normals))}if(t.colors.length>0){var n=new Float32Array(3*t.colors.length);this.addAttribute("color",new Kt(n,3).copyColorsArray(t.colors))}if(t.uvs.length>0){var r=new Float32Array(2*t.uvs.length);this.addAttribute("uv",new Kt(r,2).copyVector2sArray(t.uvs))}if(t.uvs2.length>0){var o=new Float32Array(2*t.uvs2.length);this.addAttribute("uv2",new Kt(o,2).copyVector2sArray(t.uvs2))}if(t.indices.length>0){var a=t.vertices.length>65535?Uint32Array:Uint16Array,s=new a(3*t.indices.length);this.setIndex(new Kt(s,1).copyIndicesArray(t.indices))}this.groups=t.groups;for(var c in t.morphTargets){for(var u=[],h=t.morphTargets[c],l=0,d=h.length;l<d;l++){var f=h[l],p=new te(3*f.length,3);u.push(p.copyVector3sArray(f))}this.morphAttributes[c]=u}if(t.skinIndices.length>0){var m=new te(4*t.skinIndices.length,4);this.addAttribute("skinIndex",m.copyVector4sArray(t.skinIndices))}if(t.skinWeights.length>0){var g=new te(4*t.skinWeights.length,4);this.addAttribute("skinWeight",g.copyVector4sArray(t.skinWeights))}return null!==t.boundingSphere&&(this.boundingSphere=t.boundingSphere.clone()),null!==t.boundingBox&&(this.boundingBox=t.boundingBox.clone()),this},computeBoundingBox:function(){null===this.boundingBox&&(this.boundingBox=new Et);var t=this.attributes.position.array;void 0!==t?this.boundingBox.setFromArray(t):this.boundingBox.makeEmpty(),(isNaN(this.boundingBox.min.x)||isNaN(this.boundingBox.min.y)||isNaN(this.boundingBox.min.z))&&console.error('THREE.BufferGeometry.computeBoundingBox: Computed min/max have NaN values. The "position" attribute is likely to have NaN values.',this)},computeBoundingSphere:function(){var t=new Et,e=new N;return function(){null===this.boundingSphere&&(this.boundingSphere=new It);var i=this.attributes.position;if(i){var n=i.array,r=this.boundingSphere.center;t.setFromArray(n),t.center(r);for(var o=0,a=0,s=n.length;a<s;a+=3)e.fromArray(n,a),o=Math.max(o,r.distanceToSquared(e));this.boundingSphere.radius=Math.sqrt(o),isNaN(this.boundingSphere.radius)&&console.error('THREE.BufferGeometry.computeBoundingSphere(): Computed radius is NaN. The "position" attribute is likely to have NaN values.',this)}}}(),computeFaceNormals:function(){},computeVertexNormals:function(){var t=this.index,e=this.attributes,i=this.groups;if(e.position){var n=e.position.array;if(void 0===e.normal)this.addAttribute("normal",new Kt(new Float32Array(n.length),3));else for(var r=e.normal.array,o=0,a=r.length;o<a;o++)r[o]=0;var s,c,u,h=e.normal.array,l=new N,d=new N,f=new N,p=new N,m=new N;if(t){var g=t.array;0===i.length&&this.addGroup(0,g.length);for(var v=0,y=i.length;v<y;++v)for(var b=i[v],x=b.start,_=b.count,o=x,a=x+_;o<a;o+=3)s=3*g[o+0],c=3*g[o+1],u=3*g[o+2],l.fromArray(n,s),d.fromArray(n,c),f.fromArray(n,u),p.subVectors(f,d),m.subVectors(l,d),p.cross(m),h[s]+=p.x,h[s+1]+=p.y,h[s+2]+=p.z,h[c]+=p.x,h[c+1]+=p.y,h[c+2]+=p.z,h[u]+=p.x,h[u+1]+=p.y,h[u+2]+=p.z}else for(var o=0,a=n.length;o<a;o+=9)l.fromArray(n,o),d.fromArray(n,o+3),f.fromArray(n,o+6),p.subVectors(f,d),m.subVectors(l,d),p.cross(m),h[o]=p.x,h[o+1]=p.y,h[o+2]=p.z,h[o+3]=p.x,h[o+4]=p.y,h[o+5]=p.z,h[o+6]=p.x,h[o+7]=p.y,h[o+8]=p.z;this.normalizeNormals(),e.normal.needsUpdate=!0}},merge:function(t,e){if((t&&t.isBufferGeometry)===!1)return void console.error("THREE.BufferGeometry.merge(): geometry not an instance of THREE.BufferGeometry.",t);void 0===e&&(e=0);var i=this.attributes;for(var n in i)if(void 0!==t.attributes[n])for(var r=i[n],o=r.array,a=t.attributes[n],s=a.array,c=a.itemSize,u=0,h=c*e;u<s.length;u++,h++)o[h]=s[u];return this},normalizeNormals:function(){for(var t,e,i,n,r=this.attributes.normal.array,o=0,a=r.length;o<a;o+=3)t=r[o],e=r[o+1],i=r[o+2],n=1/Math.sqrt(t*t+e*e+i*i),r[o]*=n,r[o+1]*=n,r[o+2]*=n},toNonIndexed:function(){if(null===this.index)return console.warn("THREE.BufferGeometry.toNonIndexed(): Geometry is already non-indexed."),this;var t=new ue,e=this.index.array,i=this.attributes;for(var n in i){for(var r=i[n],o=r.array,a=r.itemSize,s=new o.constructor(e.length*a),c=0,u=0,h=0,l=e.length;h<l;h++){c=e[h]*a;for(var d=0;d<a;d++)s[u++]=o[c++]}t.addAttribute(n,new Kt(s,a))}return t},toJSON:function(){var t={metadata:{version:4.4,type:"BufferGeometry",generator:"BufferGeometry.toJSON"}};if(t.uuid=this.uuid,t.type=this.type,""!==this.name&&(t.name=this.name),void 0!==this.parameters){var e=this.parameters;for(var i in e)void 0!==e[i]&&(t[i]=e[i]);return t}t.data={attributes:{}};var n=this.index;if(null!==n){var r=Array.prototype.slice.call(n.array);t.data.index={type:n.array.constructor.name,array:r}}var o=this.attributes;for(var i in o){var a=o[i],r=Array.prototype.slice.call(a.array);t.data.attributes[i]={itemSize:a.itemSize,type:a.array.constructor.name,array:r,normalized:a.normalized}}var s=this.groups;s.length>0&&(t.data.groups=JSON.parse(JSON.stringify(s)));var c=this.boundingSphere;return null!==c&&(t.data.boundingSphere={center:c.center.toArray(),radius:c.radius}),t},clone:function(){return(new ue).copy(this)},copy:function(t){var e=t.index;null!==e&&this.setIndex(e.clone());var i=t.attributes;for(var n in i){var r=i[n];this.addAttribute(n,r.clone())}for(var o=t.groups,a=0,s=o.length;a<s;a++){var c=o[a];this.addGroup(c.start,c.count,c.materialIndex)}return this},dispose:function(){this.dispatchEvent({type:"dispose"})}}),ue.MaxIndex=65535,ye.prototype=Object.create(ue.prototype),ye.prototype.constructor=ye,be.prototype={constructor:be,set:function(t,e){return this.origin.copy(t),this.direction.copy(e),this},clone:function(){return(new this.constructor).copy(this)},copy:function(t){return this.origin.copy(t.origin),this.direction.copy(t.direction),this},at:function(t,e){var i=e||new N;return i.copy(this.direction).multiplyScalar(t).add(this.origin)},lookAt:function(t){return this.direction.copy(t).sub(this.origin).normalize(),this},recast:function(){var t=new N;return function(e){return this.origin.copy(this.at(e,t)),this}}(),closestPointToPoint:function(t,e){var i=e||new N;i.subVectors(t,this.origin);var n=i.dot(this.direction);return n<0?i.copy(this.origin):i.copy(this.direction).multiplyScalar(n).add(this.origin)},distanceToPoint:function(t){return Math.sqrt(this.distanceSqToPoint(t))},distanceSqToPoint:function(){var t=new N;return function(e){var i=t.subVectors(e,this.origin).dot(this.direction);return i<0?this.origin.distanceToSquared(e):(t.copy(this.direction).multiplyScalar(i).add(this.origin),t.distanceToSquared(e))}}(),distanceSqToSegment:function(){var t=new N,e=new N,i=new N;return function(n,r,o,a){t.copy(n).add(r).multiplyScalar(.5),e.copy(r).sub(n).normalize(),i.copy(this.origin).sub(t);var s,c,u,h,l=.5*n.distanceTo(r),d=-this.direction.dot(e),f=i.dot(this.direction),p=-i.dot(e),m=i.lengthSq(),g=Math.abs(1-d*d);if(g>0)if(s=d*p-f,c=d*f-p,h=l*g,s>=0)if(c>=-h)if(c<=h){var v=1/g;s*=v,c*=v,u=s*(s+d*c+2*f)+c*(d*s+c+2*p)+m}else c=l,s=Math.max(0,-(d*c+f)),u=-s*s+c*(c+2*p)+m;else c=-l,s=Math.max(0,-(d*c+f)),u=-s*s+c*(c+2*p)+m;else c<=-h?(s=Math.max(0,-(-d*l+f)),c=s>0?-l:Math.min(Math.max(-l,-p),l),u=-s*s+c*(c+2*p)+m):c<=h?(s=0,c=Math.min(Math.max(-l,-p),l),u=c*(c+2*p)+m):(s=Math.max(0,-(d*l+f)),c=s>0?l:Math.min(Math.max(-l,-p),l),u=-s*s+c*(c+2*p)+m);else c=d>0?-l:l,s=Math.max(0,-(d*c+f)),u=-s*s+c*(c+2*p)+m;return o&&o.copy(this.direction).multiplyScalar(s).add(this.origin),a&&a.copy(e).multiplyScalar(c).add(t),u}}(),intersectSphere:function(){var t=new N;return function(e,i){t.subVectors(e.center,this.origin);var n=t.dot(this.direction),r=t.dot(t)-n*n,o=e.radius*e.radius;if(r>o)return null;var a=Math.sqrt(o-r),s=n-a,c=n+a;return s<0&&c<0?null:s<0?this.at(c,i):this.at(s,i)}}(),intersectsSphere:function(t){return this.distanceToPoint(t.center)<=t.radius},distanceToPlane:function(t){var e=t.normal.dot(this.direction);if(0===e)return 0===t.distanceToPoint(this.origin)?0:null;var i=-(this.origin.dot(t.normal)+t.constant)/e;return i>=0?i:null},intersectPlane:function(t,e){var i=this.distanceToPlane(t);return null===i?null:this.at(i,e)},intersectsPlane:function(t){var e=t.distanceToPoint(this.origin);if(0===e)return!0;var i=t.normal.dot(this.direction);return i*e<0},intersectBox:function(t,e){var i,n,r,o,a,s,c=1/this.direction.x,u=1/this.direction.y,h=1/this.direction.z,l=this.origin;return c>=0?(i=(t.min.x-l.x)*c,n=(t.max.x-l.x)*c):(i=(t.max.x-l.x)*c,n=(t.min.x-l.x)*c),u>=0?(r=(t.min.y-l.y)*u,o=(t.max.y-l.y)*u):(r=(t.max.y-l.y)*u,o=(t.min.y-l.y)*u),i>o||r>n?null:((r>i||i!==i)&&(i=r),(o<n||n!==n)&&(n=o),h>=0?(a=(t.min.z-l.z)*h,s=(t.max.z-l.z)*h):(a=(t.max.z-l.z)*h,s=(t.min.z-l.z)*h),i>s||a>n?null:((a>i||i!==i)&&(i=a),(s<n||n!==n)&&(n=s),n<0?null:this.at(i>=0?i:n,e)))},intersectsBox:function(){var t=new N;return function(e){return null!==this.intersectBox(e,t)}}(),intersectTriangle:function(){var t=new N,e=new N,i=new N,n=new N;return function(r,o,a,s,c){e.subVectors(o,r),i.subVectors(a,r),n.crossVectors(e,i);var u,h=this.direction.dot(n);if(h>0){if(s)return null;u=1}else{if(!(h<0))return null;u=-1,h=-h}t.subVectors(this.origin,r);var l=u*this.direction.dot(i.crossVectors(t,i));if(l<0)return null;
	var d=u*this.direction.dot(e.cross(t));if(d<0)return null;if(l+d>h)return null;var f=-u*t.dot(n);return f<0?null:this.at(f/h,c)}}(),applyMatrix4:function(t){return this.direction.add(this.origin).applyMatrix4(t),this.origin.applyMatrix4(t),this.direction.sub(this.origin),this.direction.normalize(),this},equals:function(t){return t.origin.equals(this.origin)&&t.direction.equals(this.direction)}},xe.prototype={constructor:xe,set:function(t,e){return this.start.copy(t),this.end.copy(e),this},clone:function(){return(new this.constructor).copy(this)},copy:function(t){return this.start.copy(t.start),this.end.copy(t.end),this},center:function(t){var e=t||new N;return e.addVectors(this.start,this.end).multiplyScalar(.5)},delta:function(t){var e=t||new N;return e.subVectors(this.end,this.start)},distanceSq:function(){return this.start.distanceToSquared(this.end)},distance:function(){return this.start.distanceTo(this.end)},at:function(t,e){var i=e||new N;return this.delta(i).multiplyScalar(t).add(this.start)},closestPointToPointParameter:function(){var t=new N,e=new N;return function(i,n){t.subVectors(i,this.start),e.subVectors(this.end,this.start);var r=e.dot(e),o=e.dot(t),a=o/r;return n&&(a=dd.clamp(a,0,1)),a}}(),closestPointToPoint:function(t,e,i){var n=this.closestPointToPointParameter(t,e),r=i||new N;return this.delta(r).multiplyScalar(n).add(this.start)},applyMatrix4:function(t){return this.start.applyMatrix4(t),this.end.applyMatrix4(t),this},equals:function(t){return t.start.equals(this.start)&&t.end.equals(this.end)}},_e.normal=function(){var t=new N;return function(e,i,n,r){var o=r||new N;o.subVectors(n,i),t.subVectors(e,i),o.cross(t);var a=o.lengthSq();return a>0?o.multiplyScalar(1/Math.sqrt(a)):o.set(0,0,0)}}(),_e.barycoordFromPoint=function(){var t=new N,e=new N,i=new N;return function(n,r,o,a,s){t.subVectors(a,r),e.subVectors(o,r),i.subVectors(n,r);var c=t.dot(t),u=t.dot(e),h=t.dot(i),l=e.dot(e),d=e.dot(i),f=c*l-u*u,p=s||new N;if(0===f)return p.set(-2,-1,-1);var m=1/f,g=(l*h-u*d)*m,v=(c*d-u*h)*m;return p.set(1-g-v,v,g)}}(),_e.containsPoint=function(){var t=new N;return function(e,i,n,r){var o=_e.barycoordFromPoint(e,i,n,r,t);return o.x>=0&&o.y>=0&&o.x+o.y<=1}}(),_e.prototype={constructor:_e,set:function(t,e,i){return this.a.copy(t),this.b.copy(e),this.c.copy(i),this},setFromPointsAndIndices:function(t,e,i,n){return this.a.copy(t[e]),this.b.copy(t[i]),this.c.copy(t[n]),this},clone:function(){return(new this.constructor).copy(this)},copy:function(t){return this.a.copy(t.a),this.b.copy(t.b),this.c.copy(t.c),this},area:function(){var t=new N,e=new N;return function(){return t.subVectors(this.c,this.b),e.subVectors(this.a,this.b),.5*t.cross(e).length()}}(),midpoint:function(t){var e=t||new N;return e.addVectors(this.a,this.b).add(this.c).multiplyScalar(1/3)},normal:function(t){return _e.normal(this.a,this.b,this.c,t)},plane:function(t){var e=t||new Rt;return e.setFromCoplanarPoints(this.a,this.b,this.c)},barycoordFromPoint:function(t,e){return _e.barycoordFromPoint(t,this.a,this.b,this.c,e)},containsPoint:function(t){return _e.containsPoint(t,this.a,this.b,this.c)},closestPointToPoint:function(){var t,e,i,n;return function(r,o){void 0===t&&(t=new Rt,e=[new xe,new xe,new xe],i=new N,n=new N);var a=o||new N,s=1/0;if(t.setFromCoplanarPoints(this.a,this.b,this.c),t.projectPoint(r,i),this.containsPoint(i)===!0)a.copy(i);else{e[0].set(this.a,this.b),e[1].set(this.b,this.c),e[2].set(this.c,this.a);for(var c=0;c<e.length;c++){e[c].closestPointToPoint(i,!0,n);var u=i.distanceToSquared(n);u<s&&(s=u,a.copy(n))}}return a}}(),equals:function(t){return t.a.equals(this.a)&&t.b.equals(this.b)&&t.c.equals(this.c)}},we.prototype=Object.create(At.prototype),we.prototype.constructor=we,we.prototype.isMeshBasicMaterial=!0,we.prototype.copy=function(t){return At.prototype.copy.call(this,t),this.color.copy(t.color),this.map=t.map,this.aoMap=t.aoMap,this.aoMapIntensity=t.aoMapIntensity,this.specularMap=t.specularMap,this.alphaMap=t.alphaMap,this.envMap=t.envMap,this.combine=t.combine,this.reflectivity=t.reflectivity,this.refractionRatio=t.refractionRatio,this.wireframe=t.wireframe,this.wireframeLinewidth=t.wireframeLinewidth,this.wireframeLinecap=t.wireframeLinecap,this.wireframeLinejoin=t.wireframeLinejoin,this.skinning=t.skinning,this.morphTargets=t.morphTargets,this},Se.prototype=Object.assign(Object.create(re.prototype),{constructor:Se,isMesh:!0,setDrawMode:function(t){this.drawMode=t},copy:function(t){return re.prototype.copy.call(this,t),this.drawMode=t.drawMode,this},updateMorphTargets:function(){if(void 0!==this.geometry.morphTargets&&this.geometry.morphTargets.length>0){this.morphTargetBase=-1,this.morphTargetInfluences=[],this.morphTargetDictionary={};for(var t=0,e=this.geometry.morphTargets.length;t<e;t++)this.morphTargetInfluences.push(0),this.morphTargetDictionary[this.geometry.morphTargets[t].name]=t}},getMorphTargetIndexByName:function(t){return void 0!==this.morphTargetDictionary[t]?this.morphTargetDictionary[t]:(console.warn("THREE.Mesh.getMorphTargetIndexByName: morph target "+t+" does not exist. Returning 0."),0)},raycast:function(){function t(t,e,i,n,r,o,a){return _e.barycoordFromPoint(t,e,i,n,m),r.multiplyScalar(m.x),o.multiplyScalar(m.y),a.multiplyScalar(m.z),r.add(o).add(a),r.clone()}function e(t,e,i,n,r,o,a){var s,c=t.material;if(s=c.side===uh?i.intersectTriangle(o,r,n,!0,a):i.intersectTriangle(n,r,o,c.side!==hh,a),null===s)return null;v.copy(a),v.applyMatrix4(t.matrixWorld);var u=e.ray.origin.distanceTo(v);return u<e.near||u>e.far?null:{distance:u,point:v.clone(),object:t}}function i(i,n,r,o,u,h,l,m){a.fromArray(o,3*h),s.fromArray(o,3*l),c.fromArray(o,3*m);var v=e(i,n,r,a,s,c,g);return v&&(u&&(d.fromArray(u,2*h),f.fromArray(u,2*l),p.fromArray(u,2*m),v.uv=t(g,a,s,c,d,f,p)),v.face=new ee(h,l,m,_e.normal(a,s,c)),v.faceIndex=h),v}var n=new O,r=new be,o=new It,a=new N,s=new N,c=new N,u=new N,h=new N,l=new N,d=new I,f=new I,p=new I,m=new N,g=new N,v=new N;return function(m,v){var y=this.geometry,b=this.material,x=this.matrixWorld;if(void 0!==b&&(null===y.boundingSphere&&y.computeBoundingSphere(),o.copy(y.boundingSphere),o.applyMatrix4(x),m.ray.intersectsSphere(o)!==!1&&(n.getInverse(x),r.copy(m.ray).applyMatrix4(n),null===y.boundingBox||r.intersectsBox(y.boundingBox)!==!1))){var _,w;if(y&&y.isBufferGeometry){var S,A,M,C=y.index,P=y.attributes,T=P.position.array;if(void 0!==P.uv&&(_=P.uv.array),null!==C)for(var E=C.array,I=0,L=E.length;I<L;I+=3)S=E[I],A=E[I+1],M=E[I+2],w=i(this,m,r,T,_,S,A,M),w&&(w.faceIndex=Math.floor(I/3),v.push(w));else for(var I=0,L=T.length;I<L;I+=9)S=I/3,A=S+1,M=S+2,w=i(this,m,r,T,_,S,A,M),w&&(w.index=S,v.push(w))}else if(y&&y.isGeometry){var R,O,D,N=b&&b.isMultiMaterial,k=N===!0?b.materials:null,F=y.vertices,z=y.faces,B=y.faceVertexUvs[0];B.length>0&&(_=B);for(var U=0,j=z.length;U<j;U++){var $=z[U],V=N===!0?k[$.materialIndex]:b;if(void 0!==V){if(R=F[$.a],O=F[$.b],D=F[$.c],V.morphTargets===!0){var G=y.morphTargets,H=this.morphTargetInfluences;a.set(0,0,0),s.set(0,0,0),c.set(0,0,0);for(var W=0,X=G.length;W<X;W++){var q=H[W];if(0!==q){var Y=G[W].vertices;a.addScaledVector(u.subVectors(Y[$.a],R),q),s.addScaledVector(h.subVectors(Y[$.b],O),q),c.addScaledVector(l.subVectors(Y[$.c],D),q)}}a.add(R),s.add(O),c.add(D),R=a,O=s,D=c}if(w=e(this,m,r,R,O,D,g)){if(_){var Z=_[U];d.copy(Z[0]),f.copy(Z[1]),p.copy(Z[2]),w.uv=t(g,R,O,D,d,f,p)}w.face=$,w.faceIndex=U,v.push(w)}}}}}}}(),clone:function(){return new this.constructor(this.geometry,this.material).copy(this)}}),Ae.prototype=Object.create(ue.prototype),Ae.prototype.constructor=Ae,Me.prototype=Object.create(re.prototype),Me.prototype.constructor=Me,Me.prototype.isCamera=!0,Me.prototype.getWorldDirection=function(){var t=new D;return function(e){var i=e||new N;return this.getWorldQuaternion(t),i.set(0,0,-1).applyQuaternion(t)}}(),Me.prototype.lookAt=function(){var t=new O;return function(e){t.lookAt(this.position,e,this.up),this.quaternion.setFromRotationMatrix(t)}}(),Me.prototype.clone=function(){return(new this.constructor).copy(this)},Me.prototype.copy=function(t){return re.prototype.copy.call(this,t),this.matrixWorldInverse.copy(t.matrixWorldInverse),this.projectionMatrix.copy(t.projectionMatrix),this},Ce.prototype=Object.assign(Object.create(Me.prototype),{constructor:Ce,isPerspectiveCamera:!0,copy:function(t){return Me.prototype.copy.call(this,t),this.fov=t.fov,this.zoom=t.zoom,this.near=t.near,this.far=t.far,this.focus=t.focus,this.aspect=t.aspect,this.view=null===t.view?null:Object.assign({},t.view),this.filmGauge=t.filmGauge,this.filmOffset=t.filmOffset,this},setFocalLength:function(t){var e=.5*this.getFilmHeight()/t;this.fov=2*dd.RAD2DEG*Math.atan(e),this.updateProjectionMatrix()},getFocalLength:function(){var t=Math.tan(.5*dd.DEG2RAD*this.fov);return.5*this.getFilmHeight()/t},getEffectiveFOV:function(){return 2*dd.RAD2DEG*Math.atan(Math.tan(.5*dd.DEG2RAD*this.fov)/this.zoom)},getFilmWidth:function(){return this.filmGauge*Math.min(this.aspect,1)},getFilmHeight:function(){return this.filmGauge/Math.max(this.aspect,1)},setViewOffset:function(t,e,i,n,r,o){this.aspect=t/e,this.view={fullWidth:t,fullHeight:e,offsetX:i,offsetY:n,width:r,height:o},this.updateProjectionMatrix()},clearViewOffset:function(){this.view=null,this.updateProjectionMatrix()},updateProjectionMatrix:function(){var t=this.near,e=t*Math.tan(.5*dd.DEG2RAD*this.fov)/this.zoom,i=2*e,n=this.aspect*i,r=-.5*n,o=this.view;if(null!==o){var a=o.fullWidth,s=o.fullHeight;r+=o.offsetX*n/a,e-=o.offsetY*i/s,n*=o.width/a,i*=o.height/s}var c=this.filmOffset;0!==c&&(r+=t*c/this.getFilmWidth()),this.projectionMatrix.makeFrustum(r,r+n,e-i,e,t,this.far)},toJSON:function(t){var e=re.prototype.toJSON.call(this,t);return e.object.fov=this.fov,e.object.zoom=this.zoom,e.object.near=this.near,e.object.far=this.far,e.object.focus=this.focus,e.object.aspect=this.aspect,null!==this.view&&(e.object.view=Object.assign({},this.view)),e.object.filmGauge=this.filmGauge,e.object.filmOffset=this.filmOffset,e}}),Pe.prototype=Object.assign(Object.create(Me.prototype),{constructor:Pe,isOrthographicCamera:!0,copy:function(t){return Me.prototype.copy.call(this,t),this.left=t.left,this.right=t.right,this.top=t.top,this.bottom=t.bottom,this.near=t.near,this.far=t.far,this.zoom=t.zoom,this.view=null===t.view?null:Object.assign({},t.view),this},setViewOffset:function(t,e,i,n,r,o){this.view={fullWidth:t,fullHeight:e,offsetX:i,offsetY:n,width:r,height:o},this.updateProjectionMatrix()},clearViewOffset:function(){this.view=null,this.updateProjectionMatrix()},updateProjectionMatrix:function(){var t=(this.right-this.left)/(2*this.zoom),e=(this.top-this.bottom)/(2*this.zoom),i=(this.right+this.left)/2,n=(this.top+this.bottom)/2,r=i-t,o=i+t,a=n+e,s=n-e;if(null!==this.view){var c=this.zoom/(this.view.width/this.view.fullWidth),u=this.zoom/(this.view.height/this.view.fullHeight),h=(this.right-this.left)/this.view.width,l=(this.top-this.bottom)/this.view.height;r+=h*(this.view.offsetX/c),o=r+h*(this.view.width/c),a-=l*(this.view.offsetY/u),s=a-l*(this.view.height/u)}this.projectionMatrix.makeOrthographic(r,o,a,s,this.near,this.far)},toJSON:function(t){var e=re.prototype.toJSON.call(this,t);return e.object.zoom=this.zoom,e.object.left=this.left,e.object.right=this.right,e.object.top=this.top,e.object.bottom=this.bottom,e.object.near=this.near,e.object.far=this.far,null!==this.view&&(e.object.view=Object.assign({},this.view)),e}}),Ee.prototype.isFogExp2=!0,Ee.prototype.clone=function(){return new Ee(this.color.getHex(),this.density)},Ee.prototype.toJSON=function(t){return{type:"FogExp2",color:this.color.getHex(),density:this.density}},Ie.prototype.isFog=!0,Ie.prototype.clone=function(){return new Ie(this.color.getHex(),this.near,this.far)},Ie.prototype.toJSON=function(t){return{type:"Fog",color:this.color.getHex(),near:this.near,far:this.far}},Le.prototype=Object.create(re.prototype),Le.prototype.constructor=Le,Le.prototype.copy=function(t,e){return re.prototype.copy.call(this,t,e),null!==t.background&&(this.background=t.background.clone()),null!==t.fog&&(this.fog=t.fog.clone()),null!==t.overrideMaterial&&(this.overrideMaterial=t.overrideMaterial.clone()),this.autoUpdate=t.autoUpdate,this.matrixAutoUpdate=t.matrixAutoUpdate,this},Le.prototype.toJSON=function(t){var e=re.prototype.toJSON.call(this,t);return null!==this.background&&(e.object.background=this.background.toJSON(t)),null!==this.fog&&(e.object.fog=this.fog.toJSON()),e},Re.prototype=Object.assign(Object.create(re.prototype),{constructor:Re,isLensFlare:!0,copy:function(t){re.prototype.copy.call(this,t),this.positionScreen.copy(t.positionScreen),this.customUpdateCallback=t.customUpdateCallback;for(var e=0,i=t.lensFlares.length;e<i;e++)this.lensFlares.push(t.lensFlares[e]);return this},add:function(t,e,i,n,r,o){void 0===e&&(e=-1),void 0===i&&(i=0),void 0===o&&(o=1),void 0===r&&(r=new Pt(16777215)),void 0===n&&(n=vh),i=Math.min(i,Math.max(0,i)),this.lensFlares.push({texture:t,size:e,distance:i,x:0,y:0,z:0,scale:1,rotation:0,opacity:o,color:r,blending:n})},updateLensFlares:function(){var t,e,i=this.lensFlares.length,n=2*-this.positionScreen.x,r=2*-this.positionScreen.y;for(t=0;t<i;t++)e=this.lensFlares[t],e.x=this.positionScreen.x+n*e.distance,e.y=this.positionScreen.y+r*e.distance,e.wantedRotation=e.x*Math.PI*.25,e.rotation+=.25*(e.wantedRotation-e.rotation)}}),Oe.prototype=Object.create(At.prototype),Oe.prototype.constructor=Oe,Oe.prototype.copy=function(t){return At.prototype.copy.call(this,t),this.color.copy(t.color),this.map=t.map,this.rotation=t.rotation,this},De.prototype=Object.assign(Object.create(re.prototype),{constructor:De,isSprite:!0,raycast:function(){var t=new N;return function(e,i){t.setFromMatrixPosition(this.matrixWorld);var n=e.ray.distanceSqToPoint(t),r=this.scale.x*this.scale.y/4;n>r||i.push({distance:Math.sqrt(n),point:this.position,face:null,object:this})}}(),clone:function(){return new this.constructor(this.material).copy(this)}}),Ne.prototype=Object.assign(Object.create(re.prototype),{constructor:Ne,copy:function(t){re.prototype.copy.call(this,t,!1);for(var e=t.levels,i=0,n=e.length;i<n;i++){var r=e[i];this.addLevel(r.object.clone(),r.distance)}return this},addLevel:function(t,e){void 0===e&&(e=0),e=Math.abs(e);for(var i=this.levels,n=0;n<i.length&&!(e<i[n].distance);n++);i.splice(n,0,{distance:e,object:t}),this.add(t)},getObjectForDistance:function(t){for(var e=this.levels,i=1,n=e.length;i<n&&!(t<e[i].distance);i++);return e[i-1].object},raycast:function(){var t=new N;return function(e,i){t.setFromMatrixPosition(this.matrixWorld);var n=e.ray.origin.distanceTo(t);this.getObjectForDistance(n).raycast(e,i)}}(),update:function(){var t=new N,e=new N;return function(i){var n=this.levels;if(n.length>1){t.setFromMatrixPosition(i.matrixWorld),e.setFromMatrixPosition(this.matrixWorld);var r=t.distanceTo(e);n[0].object.visible=!0;for(var o=1,a=n.length;o<a&&r>=n[o].distance;o++)n[o-1].object.visible=!1,n[o].object.visible=!0;for(;o<a;o++)n[o].object.visible=!1}}}(),toJSON:function(t){var e=re.prototype.toJSON.call(this,t);e.object.levels=[];for(var i=this.levels,n=0,r=i.length;n<r;n++){var o=i[n];e.object.levels.push({object:o.object.uuid,distance:o.distance})}return e}}),ke.prototype=Object.create(L.prototype),ke.prototype.constructor=ke,ke.prototype.isDataTexture=!0,Object.assign(Fe.prototype,{calculateInverses:function(){this.boneInverses=[];for(var t=0,e=this.bones.length;t<e;t++){var i=new O;this.bones[t]&&i.getInverse(this.bones[t].matrixWorld),this.boneInverses.push(i)}},pose:function(){for(var t,e=0,i=this.bones.length;e<i;e++)t=this.bones[e],t&&t.matrixWorld.getInverse(this.boneInverses[e]);for(var e=0,i=this.bones.length;e<i;e++)t=this.bones[e],t&&(t.parent&&t.parent.isBone?(t.matrix.getInverse(t.parent.matrixWorld),t.matrix.multiply(t.matrixWorld)):t.matrix.copy(t.matrixWorld),t.matrix.decompose(t.position,t.quaternion,t.scale))},update:function(){var t=new O;return function(){for(var e=0,i=this.bones.length;e<i;e++){var n=this.bones[e]?this.bones[e].matrixWorld:this.identityMatrix;t.multiplyMatrices(n,this.boneInverses[e]),t.toArray(this.boneMatrices,16*e)}this.useVertexTexture&&(this.boneTexture.needsUpdate=!0)}}(),clone:function(){return new Fe(this.bones,this.boneInverses,this.useVertexTexture)}}),ze.prototype=Object.assign(Object.create(re.prototype),{constructor:ze,isBone:!0,copy:function(t){return re.prototype.copy.call(this,t),this.skin=t.skin,this}}),Be.prototype=Object.assign(Object.create(Se.prototype),{constructor:Be,isSkinnedMesh:!0,bind:function(t,e){this.skeleton=t,void 0===e&&(this.updateMatrixWorld(!0),this.skeleton.calculateInverses(),e=this.matrixWorld),this.bindMatrix.copy(e),this.bindMatrixInverse.getInverse(e)},pose:function(){this.skeleton.pose()},normalizeSkinWeights:function(){if(this.geometry&&this.geometry.isGeometry)for(var t=0;t<this.geometry.skinWeights.length;t++){var e=this.geometry.skinWeights[t],i=1/e.lengthManhattan();i!==1/0?e.multiplyScalar(i):e.set(1,0,0,0)}else if(this.geometry&&this.geometry.isBufferGeometry)for(var n=new _t,r=this.geometry.attributes.skinWeight,t=0;t<r.count;t++){n.x=r.getX(t),n.y=r.getY(t),n.z=r.getZ(t),n.w=r.getW(t);var i=1/n.lengthManhattan();i!==1/0?n.multiplyScalar(i):n.set(1,0,0,0),r.setXYZW(t,n.x,n.y,n.z,n.w)}},updateMatrixWorld:function(t){Se.prototype.updateMatrixWorld.call(this,!0),"attached"===this.bindMode?this.bindMatrixInverse.getInverse(this.matrixWorld):"detached"===this.bindMode?this.bindMatrixInverse.getInverse(this.bindMatrix):console.warn("THREE.SkinnedMesh unrecognized bindMode: "+this.bindMode)},clone:function(){return new this.constructor(this.geometry,this.material,this.skeleton.useVertexTexture).copy(this)}}),Ue.prototype=Object.create(At.prototype),Ue.prototype.constructor=Ue,Ue.prototype.isLineBasicMaterial=!0,Ue.prototype.copy=function(t){return At.prototype.copy.call(this,t),this.color.copy(t.color),this.linewidth=t.linewidth,this.linecap=t.linecap,this.linejoin=t.linejoin,this},je.prototype=Object.assign(Object.create(re.prototype),{constructor:je,isLine:!0,raycast:function(){var t=new O,e=new be,i=new It;return function(n,r){var o=n.linePrecision,a=o*o,s=this.geometry,c=this.matrixWorld;if(null===s.boundingSphere&&s.computeBoundingSphere(),i.copy(s.boundingSphere),i.applyMatrix4(c),n.ray.intersectsSphere(i)!==!1){t.getInverse(c),e.copy(n.ray).applyMatrix4(t);var u=new N,h=new N,l=new N,d=new N,f=this&&this.isLineSegments?2:1;if(s&&s.isBufferGeometry){var p=s.index,m=s.attributes,g=m.position.array;if(null!==p)for(var v=p.array,y=0,b=v.length-1;y<b;y+=f){var x=v[y],_=v[y+1];u.fromArray(g,3*x),h.fromArray(g,3*_);var w=e.distanceSqToSegment(u,h,d,l);if(!(w>a)){d.applyMatrix4(this.matrixWorld);var S=n.ray.origin.distanceTo(d);S<n.near||S>n.far||r.push({distance:S,point:l.clone().applyMatrix4(this.matrixWorld),index:y,face:null,faceIndex:null,object:this})}}else for(var y=0,b=g.length/3-1;y<b;y+=f){u.fromArray(g,3*y),h.fromArray(g,3*y+3);var w=e.distanceSqToSegment(u,h,d,l);if(!(w>a)){d.applyMatrix4(this.matrixWorld);var S=n.ray.origin.distanceTo(d);S<n.near||S>n.far||r.push({distance:S,point:l.clone().applyMatrix4(this.matrixWorld),index:y,face:null,faceIndex:null,object:this})}}}else if(s&&s.isGeometry)for(var A=s.vertices,M=A.length,y=0;y<M-1;y+=f){var w=e.distanceSqToSegment(A[y],A[y+1],d,l);if(!(w>a)){d.applyMatrix4(this.matrixWorld);var S=n.ray.origin.distanceTo(d);S<n.near||S>n.far||r.push({distance:S,point:l.clone().applyMatrix4(this.matrixWorld),index:y,face:null,faceIndex:null,object:this})}}}}}(),clone:function(){return new this.constructor(this.geometry,this.material).copy(this)}}),$e.prototype=Object.assign(Object.create(je.prototype),{constructor:$e,isLineSegments:!0}),Ve.prototype=Object.create(At.prototype),Ve.prototype.constructor=Ve,Ve.prototype.isPointsMaterial=!0,Ve.prototype.copy=function(t){return At.prototype.copy.call(this,t),this.color.copy(t.color),this.map=t.map,this.size=t.size,this.sizeAttenuation=t.sizeAttenuation,this},Ge.prototype=Object.assign(Object.create(re.prototype),{constructor:Ge,isPoints:!0,raycast:function(){var t=new O,e=new be,i=new It;return function(n,r){function o(t,i){var o=e.distanceSqToPoint(t);if(o<l){var s=e.closestPointToPoint(t);s.applyMatrix4(c);var u=n.ray.origin.distanceTo(s);if(u<n.near||u>n.far)return;r.push({distance:u,distanceToRay:Math.sqrt(o),point:s.clone(),index:i,face:null,object:a})}}var a=this,s=this.geometry,c=this.matrixWorld,u=n.params.Points.threshold;if(null===s.boundingSphere&&s.computeBoundingSphere(),i.copy(s.boundingSphere),i.applyMatrix4(c),n.ray.intersectsSphere(i)!==!1){t.getInverse(c),e.copy(n.ray).applyMatrix4(t);var h=u/((this.scale.x+this.scale.y+this.scale.z)/3),l=h*h,d=new N;if(s&&s.isBufferGeometry){var f=s.index,p=s.attributes,m=p.position.array;if(null!==f)for(var g=f.array,v=0,y=g.length;v<y;v++){var b=g[v];d.fromArray(m,3*b),o(d,b)}else for(var v=0,x=m.length/3;v<x;v++)d.fromArray(m,3*v),o(d,v)}else for(var _=s.vertices,v=0,x=_.length;v<x;v++)o(_[v],v)}}}(),clone:function(){return new this.constructor(this.geometry,this.material).copy(this)}}),He.prototype=Object.assign(Object.create(re.prototype),{constructor:He}),We.prototype=Object.create(L.prototype),We.prototype.constructor=We,We.prototype.isCompressedTexture=!0,Xe.prototype=Object.create(L.prototype),Xe.prototype.constructor=Xe;var Cp={enabled:!1,files:{},add:function(t,e){this.enabled!==!1&&(this.files[t]=e)},get:function(t){if(this.enabled!==!1)return this.files[t]},remove:function(t){delete this.files[t]},clear:function(){this.files={}}},Pp=new qe;Object.assign(Ye.prototype,{load:function(t,e,i,n){void 0!==this.path&&(t=this.path+t);var r=this,o=Cp.get(t);if(void 0!==o)return r.manager.itemStart(t),setTimeout(function(){e&&e(o),r.manager.itemEnd(t)},0),o;var a=new XMLHttpRequest;return a.open("GET",t,!0),a.addEventListener("load",function(i){var o=i.target.response;Cp.add(t,o),200===this.status?(e&&e(o),r.manager.itemEnd(t)):0===this.status?(console.warn("THREE.XHRLoader: HTTP Status 0 received."),e&&e(o),r.manager.itemEnd(t)):(n&&n(i),r.manager.itemError(t))},!1),void 0!==i&&a.addEventListener("progress",function(t){i(t)},!1),a.addEventListener("error",function(e){n&&n(e),r.manager.itemError(t)},!1),void 0!==this.responseType&&(a.responseType=this.responseType),void 0!==this.withCredentials&&(a.withCredentials=this.withCredentials),a.overrideMimeType&&a.overrideMimeType("text/plain"),a.send(null),r.manager.itemStart(t),a},setPath:function(t){return this.path=t,this},setResponseType:function(t){return this.responseType=t,this},setWithCredentials:function(t){return this.withCredentials=t,this}}),Object.assign(Ze.prototype,{load:function(t,e,i,n){function r(r){c.load(t[r],function(t){var i=o._parser(t,!0);a[r]={width:i.width,height:i.height,format:i.format,mipmaps:i.mipmaps},u+=1,6===u&&(1===i.mipmapCount&&(s.minFilter=pl),s.format=i.format,s.needsUpdate=!0,e&&e(s))},i,n)}var o=this,a=[],s=new We;s.image=a;var c=new Ye(this.manager);if(c.setPath(this.path),c.setResponseType("arraybuffer"),Array.isArray(t))for(var u=0,h=0,l=t.length;h<l;++h)r(h);else c.load(t,function(t){var i=o._parser(t,!0);if(i.isCubemap)for(var n=i.mipmaps.length/i.mipmapCount,r=0;r<n;r++){a[r]={mipmaps:[]};for(var c=0;c<i.mipmapCount;c++)a[r].mipmaps.push(i.mipmaps[r*i.mipmapCount+c]),a[r].format=i.format,a[r].width=i.width,a[r].height=i.height}else s.image.width=i.width,s.image.height=i.height,s.mipmaps=i.mipmaps;1===i.mipmapCount&&(s.minFilter=pl),s.format=i.format,s.needsUpdate=!0,e&&e(s)},i,n);return s},setPath:function(t){return this.path=t,this}});Object.assign(Ke.prototype,{load:function(t,e,i,n){var r=this,o=new ke,a=new Ye(this.manager);return a.setResponseType("arraybuffer"),a.load(t,function(t){var i=r._parser(t);i&&(void 0!==i.image?o.image=i.image:void 0!==i.data&&(o.image.width=i.width,o.image.height=i.height,o.image.data=i.data),o.wrapS=void 0!==i.wrapS?i.wrapS:ul,o.wrapT=void 0!==i.wrapT?i.wrapT:ul,o.magFilter=void 0!==i.magFilter?i.magFilter:pl,o.minFilter=void 0!==i.minFilter?i.minFilter:gl,o.anisotropy=void 0!==i.anisotropy?i.anisotropy:1,void 0!==i.format&&(o.format=i.format),void 0!==i.type&&(o.type=i.type),void 0!==i.mipmaps&&(o.mipmaps=i.mipmaps),1===i.mipmapCount&&(o.minFilter=pl),o.needsUpdate=!0,e&&e(o,i))},i,n),o}}),Object.assign(Qe.prototype,{load:function(t,e,i,n){var r=this,o=document.createElementNS("http://www.w3.org/1999/xhtml","img");if(o.onload=function(){URL.revokeObjectURL(o.src),e&&e(o),r.manager.itemEnd(t)},0===t.indexOf("data:"))o.src=t;else{var a=new Ye;a.setPath(this.path),a.setResponseType("blob"),a.setWithCredentials(this.withCredentials),a.load(t,function(t){o.src=URL.createObjectURL(t)},i,n)}return r.manager.itemStart(t),o},setCrossOrigin:function(t){return this.crossOrigin=t,this},setWithCredentials:function(t){return this.withCredentials=t,this},setPath:function(t){return this.path=t,this}}),Object.assign(Je.prototype,{load:function(t,e,i,n){function r(i){a.load(t[i],function(t){o.images[i]=t,s++,6===s&&(o.needsUpdate=!0,e&&e(o))},void 0,n)}var o=new B,a=new Qe(this.manager);a.setCrossOrigin(this.crossOrigin),a.setPath(this.path);for(var s=0,c=0;c<t.length;++c)r(c);return o},setCrossOrigin:function(t){return this.crossOrigin=t,this},setPath:function(t){return this.path=t,this}}),Object.assign(ti.prototype,{load:function(t,e,i,n){var r=new L,o=new Qe(this.manager);return o.setCrossOrigin(this.crossOrigin),o.setWithCredentials(this.withCredentials),o.setPath(this.path),o.load(t,function(i){var n=t.search(/\.(jpg|jpeg)$/)>0||0===t.search(/^data\:image\/jpeg/);r.format=n?Il:Ll,r.image=i,r.needsUpdate=!0,void 0!==e&&e(r)},i,n),r},setCrossOrigin:function(t){return this.crossOrigin=t,this},setWithCredentials:function(t){return this.withCredentials=t,this},setPath:function(t){return this.path=t,this}}),ei.prototype=Object.assign(Object.create(re.prototype),{constructor:ei,isLight:!0,copy:function(t){return re.prototype.copy.call(this,t),this.color.copy(t.color),this.intensity=t.intensity,this},toJSON:function(t){var e=re.prototype.toJSON.call(this,t);return e.object.color=this.color.getHex(),e.object.intensity=this.intensity,void 0!==this.groundColor&&(e.object.groundColor=this.groundColor.getHex()),void 0!==this.distance&&(e.object.distance=this.distance),void 0!==this.angle&&(e.object.angle=this.angle),void 0!==this.decay&&(e.object.decay=this.decay),void 0!==this.penumbra&&(e.object.penumbra=this.penumbra),void 0!==this.shadow&&(e.object.shadow=this.shadow.toJSON()),e}}),ii.prototype=Object.assign(Object.create(ei.prototype),{constructor:ii,isHemisphereLight:!0,copy:function(t){return ei.prototype.copy.call(this,t),this.groundColor.copy(t.groundColor),this}}),Object.assign(ni.prototype,{copy:function(t){return this.camera=t.camera.clone(),this.bias=t.bias,this.radius=t.radius,this.mapSize.copy(t.mapSize),this},clone:function(){return(new this.constructor).copy(this)},toJSON:function(){var t={};return 0!==this.bias&&(t.bias=this.bias),1!==this.radius&&(t.radius=this.radius),512===this.mapSize.x&&512===this.mapSize.y||(t.mapSize=this.mapSize.toArray()),t.camera=this.camera.toJSON(!1).object,delete t.camera.matrix,t}}),ri.prototype=Object.assign(Object.create(ni.prototype),{constructor:ri,isSpotLightShadow:!0,update:function(t){var e=2*dd.RAD2DEG*t.angle,i=this.mapSize.width/this.mapSize.height,n=t.distance||500,r=this.camera;e===r.fov&&i===r.aspect&&n===r.far||(r.fov=e,r.aspect=i,r.far=n,r.updateProjectionMatrix())}}),oi.prototype=Object.assign(Object.create(ei.prototype),{constructor:oi,isSpotLight:!0,copy:function(t){return ei.prototype.copy.call(this,t),this.distance=t.distance,this.angle=t.angle,this.penumbra=t.penumbra,this.decay=t.decay,this.target=t.target.clone(),this.shadow=t.shadow.clone(),this}}),ai.prototype=Object.assign(Object.create(ei.prototype),{constructor:ai,isPointLight:!0,copy:function(t){return ei.prototype.copy.call(this,t),this.distance=t.distance,this.decay=t.decay,this.shadow=t.shadow.clone(),this}}),si.prototype=Object.assign(Object.create(ni.prototype),{constructor:si}),ci.prototype=Object.assign(Object.create(ei.prototype),{constructor:ci,isDirectionalLight:!0,copy:function(t){return ei.prototype.copy.call(this,t),this.target=t.target.clone(),this.shadow=t.shadow.clone(),this}}),ui.prototype=Object.assign(Object.create(ei.prototype),{constructor:ui,isAmbientLight:!0});var Tp={arraySlice:function(t,e,i){return Tp.isTypedArray(t)?new t.constructor(t.subarray(e,i)):t.slice(e,i)},convertArray:function(t,e,i){return!t||!i&&t.constructor===e?t:"number"==typeof e.BYTES_PER_ELEMENT?new e(t):Array.prototype.slice.call(t)},isTypedArray:function(t){return ArrayBuffer.isView(t)&&!(t instanceof DataView)},getKeyframeOrder:function(t){function e(e,i){return t[e]-t[i]}for(var i=t.length,n=new Array(i),r=0;r!==i;++r)n[r]=r;return n.sort(e),n},sortedArray:function(t,e,i){for(var n=t.length,r=new t.constructor(n),o=0,a=0;a!==n;++o)for(var s=i[o]*e,c=0;c!==e;++c)r[a++]=t[s+c];return r},flattenJSON:function(t,e,i,n){for(var r=1,o=t[0];void 0!==o&&void 0===o[n];)o=t[r++];if(void 0!==o){var a=o[n];if(void 0!==a)if(Array.isArray(a)){do a=o[n],void 0!==a&&(e.push(o.time),i.push.apply(i,a)),o=t[r++];while(void 0!==o)}else if(void 0!==a.toArray){do a=o[n],void 0!==a&&(e.push(o.time),a.toArray(i,i.length)),o=t[r++];while(void 0!==o)}else do a=o[n],void 0!==a&&(e.push(o.time),i.push(a)),o=t[r++];while(void 0!==o)}}};hi.prototype={constructor:hi,evaluate:function(t){var e=this.parameterPositions,i=this._cachedIndex,n=e[i],r=e[i-1];t:{e:{var o;i:{n:if(!(t<n)){for(var a=i+2;;){if(void 0===n){if(t<r)break n;return i=e.length,this._cachedIndex=i,this.afterEnd_(i-1,t,r)}if(i===a)break;if(r=n,n=e[++i],t<n)break e}o=e.length;break i}{if(t>=r)break t;var s=e[1];t<s&&(i=2,r=s);for(var a=i-2;;){if(void 0===r)return this._cachedIndex=0,this.beforeStart_(0,t,n);if(i===a)break;if(n=r,r=e[--i-1],t>=r)break e}o=i,i=0}}for(;i<o;){var c=i+o>>>1;t<e[c]?o=c:i=c+1}if(n=e[i],r=e[i-1],void 0===r)return this._cachedIndex=0,this.beforeStart_(0,t,n);if(void 0===n)return i=e.length,this._cachedIndex=i,this.afterEnd_(i-1,r,t)}this._cachedIndex=i,this.intervalChanged_(i,r,n)}return this.interpolate_(i,r,t,n)},settings:null,DefaultSettings_:{},getSettings_:function(){return this.settings||this.DefaultSettings_},copySampleValue_:function(t){for(var e=this.resultBuffer,i=this.sampleValues,n=this.valueSize,r=t*n,o=0;o!==n;++o)e[o]=i[r+o];return e},interpolate_:function(t,e,i,n){throw new Error("call to abstract method")},intervalChanged_:function(t,e,i){}},Object.assign(hi.prototype,{beforeStart_:hi.prototype.copySampleValue_,afterEnd_:hi.prototype.copySampleValue_}),li.prototype=Object.assign(Object.create(hi.prototype),{constructor:li,DefaultSettings_:{endingStart:Kl,endingEnd:Kl},intervalChanged_:function(t,e,i){var n=this.parameterPositions,r=t-2,o=t+1,a=n[r],s=n[o];if(void 0===a)switch(this.getSettings_().endingStart){case Ql:r=t,a=2*e-i;break;case Jl:r=n.length-2,a=e+n[r]-n[r+1];break;default:r=t,a=i}if(void 0===s)switch(this.getSettings_().endingEnd){case Ql:o=t,s=2*i-e;break;case Jl:o=1,s=i+n[1]-n[0];break;default:o=t-1,s=e}var c=.5*(i-e),u=this.valueSize;this._weightPrev=c/(e-a),this._weightNext=c/(s-i),this._offsetPrev=r*u,this._offsetNext=o*u},interpolate_:function(t,e,i,n){for(var r=this.resultBuffer,o=this.sampleValues,a=this.valueSize,s=t*a,c=s-a,u=this._offsetPrev,h=this._offsetNext,l=this._weightPrev,d=this._weightNext,f=(i-e)/(n-e),p=f*f,m=p*f,g=-l*m+2*l*p-l*f,v=(1+l)*m+(-1.5-2*l)*p+(-.5+l)*f+1,y=(-1-d)*m+(1.5+d)*p+.5*f,b=d*m-d*p,x=0;x!==a;++x)r[x]=g*o[u+x]+v*o[c+x]+y*o[s+x]+b*o[h+x];return r}}),di.prototype=Object.assign(Object.create(hi.prototype),{constructor:di,interpolate_:function(t,e,i,n){for(var r=this.resultBuffer,o=this.sampleValues,a=this.valueSize,s=t*a,c=s-a,u=(i-e)/(n-e),h=1-u,l=0;l!==a;++l)r[l]=o[c+l]*h+o[s+l]*u;return r}}),fi.prototype=Object.assign(Object.create(hi.prototype),{constructor:fi,interpolate_:function(t,e,i,n){return this.copySampleValue_(t-1)}});var Ep;Ep={TimeBufferType:Float32Array,
	ValueBufferType:Float32Array,DefaultInterpolation:Yl,InterpolantFactoryMethodDiscrete:function(t){return new fi(this.times,this.values,this.getValueSize(),t)},InterpolantFactoryMethodLinear:function(t){return new di(this.times,this.values,this.getValueSize(),t)},InterpolantFactoryMethodSmooth:function(t){return new li(this.times,this.values,this.getValueSize(),t)},setInterpolation:function(t){var e;switch(t){case ql:e=this.InterpolantFactoryMethodDiscrete;break;case Yl:e=this.InterpolantFactoryMethodLinear;break;case Zl:e=this.InterpolantFactoryMethodSmooth}if(void 0===e){var i="unsupported interpolation for "+this.ValueTypeName+" keyframe track named "+this.name;if(void 0===this.createInterpolant){if(t===this.DefaultInterpolation)throw new Error(i);this.setInterpolation(this.DefaultInterpolation)}return void console.warn(i)}this.createInterpolant=e},getInterpolation:function(){switch(this.createInterpolant){case this.InterpolantFactoryMethodDiscrete:return ql;case this.InterpolantFactoryMethodLinear:return Yl;case this.InterpolantFactoryMethodSmooth:return Zl}},getValueSize:function(){return this.values.length/this.times.length},shift:function(t){if(0!==t)for(var e=this.times,i=0,n=e.length;i!==n;++i)e[i]+=t;return this},scale:function(t){if(1!==t)for(var e=this.times,i=0,n=e.length;i!==n;++i)e[i]*=t;return this},trim:function(t,e){for(var i=this.times,n=i.length,r=0,o=n-1;r!==n&&i[r]<t;)++r;for(;o!==-1&&i[o]>e;)--o;if(++o,0!==r||o!==n){r>=o&&(o=Math.max(o,1),r=o-1);var a=this.getValueSize();this.times=Tp.arraySlice(i,r,o),this.values=Tp.arraySlice(this.values,r*a,o*a)}return this},validate:function(){var t=!0,e=this.getValueSize();e-Math.floor(e)!==0&&(console.error("invalid value size in track",this),t=!1);var i=this.times,n=this.values,r=i.length;0===r&&(console.error("track is empty",this),t=!1);for(var o=null,a=0;a!==r;a++){var s=i[a];if("number"==typeof s&&isNaN(s)){console.error("time is not a valid number",this,a,s),t=!1;break}if(null!==o&&o>s){console.error("out of order keys",this,a,s,o),t=!1;break}o=s}if(void 0!==n&&Tp.isTypedArray(n))for(var a=0,c=n.length;a!==c;++a){var u=n[a];if(isNaN(u)){console.error("value is not a valid number",this,a,u),t=!1;break}}return t},optimize:function(){for(var t=this.times,e=this.values,i=this.getValueSize(),n=1,r=1,o=t.length-1;r<=o;++r){var a=!1,s=t[r],c=t[r+1];if(s!==c&&(1!==r||s!==s[0]))for(var u=r*i,h=u-i,l=u+i,d=0;d!==i;++d){var f=e[u+d];if(f!==e[h+d]||f!==e[l+d]){a=!0;break}}if(a){if(r!==n){t[n]=t[r];for(var p=r*i,m=n*i,d=0;d!==i;++d)e[m+d]=e[p+d]}++n}}return n!==t.length&&(this.times=Tp.arraySlice(t,0,n),this.values=Tp.arraySlice(e,0,n*i)),this}},mi.prototype=Object.assign(Object.create(Ep),{constructor:mi,ValueTypeName:"vector"}),gi.prototype=Object.assign(Object.create(hi.prototype),{constructor:gi,interpolate_:function(t,e,i,n){for(var r=this.resultBuffer,o=this.sampleValues,a=this.valueSize,s=t*a,c=(i-e)/(n-e),u=s+a;s!==u;s+=4)D.slerpFlat(r,0,o,s-a,o,s,c);return r}}),vi.prototype=Object.assign(Object.create(Ep),{constructor:vi,ValueTypeName:"quaternion",DefaultInterpolation:Yl,InterpolantFactoryMethodLinear:function(t){return new gi(this.times,this.values,this.getValueSize(),t)},InterpolantFactoryMethodSmooth:void 0}),yi.prototype=Object.assign(Object.create(Ep),{constructor:yi,ValueTypeName:"number"}),bi.prototype=Object.assign(Object.create(Ep),{constructor:bi,ValueTypeName:"string",ValueBufferType:Array,DefaultInterpolation:ql,InterpolantFactoryMethodLinear:void 0,InterpolantFactoryMethodSmooth:void 0}),xi.prototype=Object.assign(Object.create(Ep),{constructor:xi,ValueTypeName:"bool",ValueBufferType:Array,DefaultInterpolation:ql,InterpolantFactoryMethodLinear:void 0,InterpolantFactoryMethodSmooth:void 0}),_i.prototype=Object.assign(Object.create(Ep),{constructor:_i,ValueTypeName:"color"}),wi.prototype=Ep,Ep.constructor=wi,Object.assign(wi,{parse:function(t){if(void 0===t.type)throw new Error("track type undefined, can not parse");var e=wi._getTrackTypeForValueTypeName(t.type);if(void 0===t.times){var i=[],n=[];Tp.flattenJSON(t.keys,i,n,"value"),t.times=i,t.values=n}return void 0!==e.parse?e.parse(t):new e(t.name,t.times,t.values,t.interpolation)},toJSON:function(t){var e,i=t.constructor;if(void 0!==i.toJSON)e=i.toJSON(t);else{e={name:t.name,times:Tp.convertArray(t.times,Array),values:Tp.convertArray(t.values,Array)};var n=t.getInterpolation();n!==t.DefaultInterpolation&&(e.interpolation=n)}return e.type=t.ValueTypeName,e},_getTrackTypeForValueTypeName:function(t){switch(t.toLowerCase()){case"scalar":case"double":case"float":case"number":case"integer":return yi;case"vector":case"vector2":case"vector3":case"vector4":return mi;case"color":return _i;case"quaternion":return vi;case"bool":case"boolean":return xi;case"string":return bi}throw new Error("Unsupported typeName: "+t)}}),Si.prototype={constructor:Si,resetDuration:function(){for(var t=this.tracks,e=0,i=0,n=t.length;i!==n;++i){var r=this.tracks[i];e=Math.max(e,r.times[r.times.length-1])}this.duration=e},trim:function(){for(var t=0;t<this.tracks.length;t++)this.tracks[t].trim(0,this.duration);return this},optimize:function(){for(var t=0;t<this.tracks.length;t++)this.tracks[t].optimize();return this}},Object.assign(Si,{parse:function(t){for(var e=[],i=t.tracks,n=1/(t.fps||1),r=0,o=i.length;r!==o;++r)e.push(wi.parse(i[r]).scale(n));return new Si(t.name,t.duration,e)},toJSON:function(t){for(var e=[],i=t.tracks,n={name:t.name,duration:t.duration,tracks:e},r=0,o=i.length;r!==o;++r)e.push(wi.toJSON(i[r]));return n},CreateFromMorphTargetSequence:function(t,e,i,n){for(var r=e.length,o=[],a=0;a<r;a++){var s=[],c=[];s.push((a+r-1)%r,a,(a+1)%r),c.push(0,1,0);var u=Tp.getKeyframeOrder(s);s=Tp.sortedArray(s,1,u),c=Tp.sortedArray(c,1,u),n||0!==s[0]||(s.push(r),c.push(c[0])),o.push(new yi(".morphTargetInfluences["+e[a].name+"]",s,c).scale(1/i))}return new Si(t,-1,o)},findByName:function(t,e){var i=t;if(!Array.isArray(t)){var n=t;i=n.geometry&&n.geometry.animations||n.animations}for(var r=0;r<i.length;r++)if(i[r].name===e)return i[r];return null},CreateClipsFromMorphTargetSequences:function(t,e,i){for(var n={},r=/^([\w-]*?)([\d]+)$/,o=0,a=t.length;o<a;o++){var s=t[o],c=s.name.match(r);if(c&&c.length>1){var u=c[1],h=n[u];h||(n[u]=h=[]),h.push(s)}}var l=[];for(var u in n)l.push(Si.CreateFromMorphTargetSequence(u,n[u],e,i));return l},parseAnimation:function(t,e,i){if(!t)return console.error("  no animation in JSONLoader data"),null;for(var n=function(t,e,i,n,r){if(0!==i.length){var o=[],a=[];Tp.flattenJSON(i,o,a,n),0!==o.length&&r.push(new t(e,o,a))}},r=[],o=t.name||"default",a=t.length||-1,s=t.fps||30,c=t.hierarchy||[],u=0;u<c.length;u++){var h=c[u].keys;if(h&&0!==h.length)if(h[0].morphTargets){for(var l={},d=0;d<h.length;d++)if(h[d].morphTargets)for(var f=0;f<h[d].morphTargets.length;f++)l[h[d].morphTargets[f]]=-1;for(var p in l){for(var m=[],g=[],f=0;f!==h[d].morphTargets.length;++f){var v=h[d];m.push(v.time),g.push(v.morphTarget===p?1:0)}r.push(new yi(".morphTargetInfluence["+p+"]",m,g))}a=l.length*(s||1)}else{var y=".bones["+e[u].name+"]";n(mi,y+".position",h,"pos",r),n(vi,y+".quaternion",h,"rot",r),n(mi,y+".scale",h,"scl",r)}}if(0===r.length)return null;var b=new Si(o,a,r);return b}}),Object.assign(Ai.prototype,{load:function(t,e,i,n){var r=this,o=new Ye(r.manager);o.load(t,function(t){e(r.parse(JSON.parse(t)))},i,n)},setTextures:function(t){this.textures=t},parse:function(t){function e(t){return void 0===i[t]&&console.warn("THREE.MaterialLoader: Undefined texture",t),i[t]}var i=this.textures,n=new THREE[t.type];if(void 0!==t.uuid&&(n.uuid=t.uuid),void 0!==t.name&&(n.name=t.name),void 0!==t.color&&n.color.setHex(t.color),void 0!==t.roughness&&(n.roughness=t.roughness),void 0!==t.metalness&&(n.metalness=t.metalness),void 0!==t.emissive&&n.emissive.setHex(t.emissive),void 0!==t.specular&&n.specular.setHex(t.specular),void 0!==t.shininess&&(n.shininess=t.shininess),void 0!==t.uniforms&&(n.uniforms=t.uniforms),void 0!==t.vertexShader&&(n.vertexShader=t.vertexShader),void 0!==t.fragmentShader&&(n.fragmentShader=t.fragmentShader),void 0!==t.vertexColors&&(n.vertexColors=t.vertexColors),void 0!==t.fog&&(n.fog=t.fog),void 0!==t.shading&&(n.shading=t.shading),void 0!==t.blending&&(n.blending=t.blending),void 0!==t.side&&(n.side=t.side),void 0!==t.opacity&&(n.opacity=t.opacity),void 0!==t.transparent&&(n.transparent=t.transparent),void 0!==t.alphaTest&&(n.alphaTest=t.alphaTest),void 0!==t.depthTest&&(n.depthTest=t.depthTest),void 0!==t.depthWrite&&(n.depthWrite=t.depthWrite),void 0!==t.colorWrite&&(n.colorWrite=t.colorWrite),void 0!==t.wireframe&&(n.wireframe=t.wireframe),void 0!==t.wireframeLinewidth&&(n.wireframeLinewidth=t.wireframeLinewidth),void 0!==t.wireframeLinecap&&(n.wireframeLinecap=t.wireframeLinecap),void 0!==t.wireframeLinejoin&&(n.wireframeLinejoin=t.wireframeLinejoin),void 0!==t.skinning&&(n.skinning=t.skinning),void 0!==t.morphTargets&&(n.morphTargets=t.morphTargets),void 0!==t.size&&(n.size=t.size),void 0!==t.sizeAttenuation&&(n.sizeAttenuation=t.sizeAttenuation),void 0!==t.map&&(n.map=e(t.map)),void 0!==t.alphaMap&&(n.alphaMap=e(t.alphaMap),n.transparent=!0),void 0!==t.bumpMap&&(n.bumpMap=e(t.bumpMap)),void 0!==t.bumpScale&&(n.bumpScale=t.bumpScale),void 0!==t.normalMap&&(n.normalMap=e(t.normalMap)),void 0!==t.normalScale){var r=t.normalScale;Array.isArray(r)===!1&&(r=[r,r]),n.normalScale=(new I).fromArray(r)}if(void 0!==t.displacementMap&&(n.displacementMap=e(t.displacementMap)),void 0!==t.displacementScale&&(n.displacementScale=t.displacementScale),void 0!==t.displacementBias&&(n.displacementBias=t.displacementBias),void 0!==t.roughnessMap&&(n.roughnessMap=e(t.roughnessMap)),void 0!==t.metalnessMap&&(n.metalnessMap=e(t.metalnessMap)),void 0!==t.emissiveMap&&(n.emissiveMap=e(t.emissiveMap)),void 0!==t.emissiveIntensity&&(n.emissiveIntensity=t.emissiveIntensity),void 0!==t.specularMap&&(n.specularMap=e(t.specularMap)),void 0!==t.envMap&&(n.envMap=e(t.envMap)),void 0!==t.reflectivity&&(n.reflectivity=t.reflectivity),void 0!==t.lightMap&&(n.lightMap=e(t.lightMap)),void 0!==t.lightMapIntensity&&(n.lightMapIntensity=t.lightMapIntensity),void 0!==t.aoMap&&(n.aoMap=e(t.aoMap)),void 0!==t.aoMapIntensity&&(n.aoMapIntensity=t.aoMapIntensity),void 0!==t.materials)for(var o=0,a=t.materials.length;o<a;o++)n.materials.push(this.parse(t.materials[o]));return n}}),Object.assign(Mi.prototype,{load:function(t,e,i,n){var r=this,o=new Ye(r.manager);o.load(t,function(t){e(r.parse(JSON.parse(t)))},i,n)},parse:function(t){var e=new ue,i=t.data.index,n={Int8Array:Int8Array,Uint8Array:Uint8Array,Uint8ClampedArray:Uint8ClampedArray,Int16Array:Int16Array,Uint16Array:Uint16Array,Int32Array:Int32Array,Uint32Array:Uint32Array,Float32Array:Float32Array,Float64Array:Float64Array};if(void 0!==i){var r=new n[i.type](i.array);e.setIndex(new Kt(r,1))}var o=t.data.attributes;for(var a in o){var s=o[a],r=new n[s.type](s.array);e.addAttribute(a,new Kt(r,s.itemSize,s.normalized))}var c=t.data.groups||t.data.drawcalls||t.data.offsets;if(void 0!==c)for(var u=0,h=c.length;u!==h;++u){var l=c[u];e.addGroup(l.start,l.count,l.materialIndex)}var d=t.data.boundingSphere;if(void 0!==d){var f=new N;void 0!==d.center&&f.fromArray(d.center),e.boundingSphere=new It(f,d.radius)}return e}}),Ci.prototype={constructor:Ci,crossOrigin:void 0,extractUrlBase:function(t){var e=t.split("/");return 1===e.length?"./":(e.pop(),e.join("/")+"/")},initMaterials:function(t,e,i){for(var n=[],r=0;r<t.length;++r)n[r]=this.createMaterial(t[r],e,i);return n},createMaterial:function(){var t,e,i;return function(n,r,o){function a(t,i,n,a,c){var u,h=r+t,l=Ci.Handlers.get(h);null!==l?u=l.load(h):(e.setCrossOrigin(o),u=e.load(h)),void 0!==i&&(u.repeat.fromArray(i),1!==i[0]&&(u.wrapS=cl),1!==i[1]&&(u.wrapT=cl)),void 0!==n&&u.offset.fromArray(n),void 0!==a&&("repeat"===a[0]&&(u.wrapS=cl),"mirror"===a[0]&&(u.wrapS=hl),"repeat"===a[1]&&(u.wrapT=cl),"mirror"===a[1]&&(u.wrapT=hl)),void 0!==c&&(u.anisotropy=c);var d=dd.generateUUID();return s[d]=u,d}void 0===t&&(t=new Pt),void 0===e&&(e=new ti),void 0===i&&(i=new Ai);var s={},c={uuid:dd.generateUUID(),type:"MeshLambertMaterial"};for(var u in n){var h=n[u];switch(u){case"DbgColor":case"DbgIndex":case"opticalDensity":case"illumination":break;case"DbgName":c.name=h;break;case"blending":c.blending=THREE[h];break;case"colorAmbient":case"mapAmbient":console.warn("THREE.Loader.createMaterial:",u,"is no longer supported.");break;case"colorDiffuse":c.color=t.fromArray(h).getHex();break;case"colorSpecular":c.specular=t.fromArray(h).getHex();break;case"colorEmissive":c.emissive=t.fromArray(h).getHex();break;case"specularCoef":c.shininess=h;break;case"shading":"basic"===h.toLowerCase()&&(c.type="MeshBasicMaterial"),"phong"===h.toLowerCase()&&(c.type="MeshPhongMaterial"),"standard"===h.toLowerCase()&&(c.type="MeshStandardMaterial");break;case"mapDiffuse":c.map=a(h,n.mapDiffuseRepeat,n.mapDiffuseOffset,n.mapDiffuseWrap,n.mapDiffuseAnisotropy);break;case"mapDiffuseRepeat":case"mapDiffuseOffset":case"mapDiffuseWrap":case"mapDiffuseAnisotropy":break;case"mapEmissive":c.emissiveMap=a(h,n.mapEmissiveRepeat,n.mapEmissiveOffset,n.mapEmissiveWrap,n.mapEmissiveAnisotropy);break;case"mapEmissiveRepeat":case"mapEmissiveOffset":case"mapEmissiveWrap":case"mapEmissiveAnisotropy":break;case"mapLight":c.lightMap=a(h,n.mapLightRepeat,n.mapLightOffset,n.mapLightWrap,n.mapLightAnisotropy);break;case"mapLightRepeat":case"mapLightOffset":case"mapLightWrap":case"mapLightAnisotropy":break;case"mapAO":c.aoMap=a(h,n.mapAORepeat,n.mapAOOffset,n.mapAOWrap,n.mapAOAnisotropy);break;case"mapAORepeat":case"mapAOOffset":case"mapAOWrap":case"mapAOAnisotropy":break;case"mapBump":c.bumpMap=a(h,n.mapBumpRepeat,n.mapBumpOffset,n.mapBumpWrap,n.mapBumpAnisotropy);break;case"mapBumpScale":c.bumpScale=h;break;case"mapBumpRepeat":case"mapBumpOffset":case"mapBumpWrap":case"mapBumpAnisotropy":break;case"mapNormal":c.normalMap=a(h,n.mapNormalRepeat,n.mapNormalOffset,n.mapNormalWrap,n.mapNormalAnisotropy);break;case"mapNormalFactor":c.normalScale=[h,h];break;case"mapNormalRepeat":case"mapNormalOffset":case"mapNormalWrap":case"mapNormalAnisotropy":break;case"mapSpecular":c.specularMap=a(h,n.mapSpecularRepeat,n.mapSpecularOffset,n.mapSpecularWrap,n.mapSpecularAnisotropy);break;case"mapSpecularRepeat":case"mapSpecularOffset":case"mapSpecularWrap":case"mapSpecularAnisotropy":break;case"mapMetalness":c.metalnessMap=a(h,n.mapMetalnessRepeat,n.mapMetalnessOffset,n.mapMetalnessWrap,n.mapMetalnessAnisotropy);break;case"mapMetalnessRepeat":case"mapMetalnessOffset":case"mapMetalnessWrap":case"mapMetalnessAnisotropy":break;case"mapRoughness":c.roughnessMap=a(h,n.mapRoughnessRepeat,n.mapRoughnessOffset,n.mapRoughnessWrap,n.mapRoughnessAnisotropy);break;case"mapRoughnessRepeat":case"mapRoughnessOffset":case"mapRoughnessWrap":case"mapRoughnessAnisotropy":break;case"mapAlpha":c.alphaMap=a(h,n.mapAlphaRepeat,n.mapAlphaOffset,n.mapAlphaWrap,n.mapAlphaAnisotropy);break;case"mapAlphaRepeat":case"mapAlphaOffset":case"mapAlphaWrap":case"mapAlphaAnisotropy":break;case"flipSided":c.side=uh;break;case"doubleSided":c.side=hh;break;case"transparency":console.warn("THREE.Loader.createMaterial: transparency has been renamed to opacity"),c.opacity=h;break;case"depthTest":case"depthWrite":case"colorWrite":case"opacity":case"reflectivity":case"transparent":case"visible":case"wireframe":c[u]=h;break;case"vertexColors":h===!0&&(c.vertexColors=mh),"face"===h&&(c.vertexColors=ph);break;default:console.error("THREE.Loader.createMaterial: Unsupported",u,h)}}return"MeshBasicMaterial"===c.type&&delete c.emissive,"MeshPhongMaterial"!==c.type&&delete c.specular,c.opacity<1&&(c.transparent=!0),i.setTextures(s),i.parse(c)}}()},Ci.Handlers={handlers:[],add:function(t,e){this.handlers.push(t,e)},get:function(t){for(var e=this.handlers,i=0,n=e.length;i<n;i+=2){var r=e[i],o=e[i+1];if(r.test(t))return o}return null}},Object.assign(Pi.prototype,{load:function(t,e,i,n){var r=this,o=this.texturePath&&"string"==typeof this.texturePath?this.texturePath:Ci.prototype.extractUrlBase(t),a=new Ye(this.manager);a.setWithCredentials(this.withCredentials),a.load(t,function(i){var n=JSON.parse(i),a=n.metadata;if(void 0!==a){var s=a.type;if(void 0!==s){if("object"===s.toLowerCase())return void console.error("THREE.JSONLoader: "+t+" should be loaded with THREE.ObjectLoader instead.");if("scene"===s.toLowerCase())return void console.error("THREE.JSONLoader: "+t+" should be loaded with THREE.SceneLoader instead.")}}var c=r.parse(n,o);e(c.geometry,c.materials)},i,n)},setTexturePath:function(t){this.texturePath=t},parse:function(t,e){function i(e){function i(t,e){return t&1<<e}var n,r,o,s,c,u,h,l,d,f,p,m,g,v,y,b,x,_,w,S,A,M,C,P,T,E,L,R=t.faces,O=t.vertices,D=t.normals,k=t.colors,F=0;if(void 0!==t.uvs){for(n=0;n<t.uvs.length;n++)t.uvs[n].length&&F++;for(n=0;n<F;n++)a.faceVertexUvs[n]=[]}for(s=0,c=O.length;s<c;)_=new N,_.x=O[s++]*e,_.y=O[s++]*e,_.z=O[s++]*e,a.vertices.push(_);for(s=0,c=R.length;s<c;)if(f=R[s++],p=i(f,0),m=i(f,1),g=i(f,3),v=i(f,4),y=i(f,5),b=i(f,6),x=i(f,7),p){if(S=new ee,S.a=R[s],S.b=R[s+1],S.c=R[s+3],A=new ee,A.a=R[s+1],A.b=R[s+2],A.c=R[s+3],s+=4,m&&(d=R[s++],S.materialIndex=d,A.materialIndex=d),o=a.faces.length,g)for(n=0;n<F;n++)for(P=t.uvs[n],a.faceVertexUvs[n][o]=[],a.faceVertexUvs[n][o+1]=[],r=0;r<4;r++)l=R[s++],E=P[2*l],L=P[2*l+1],T=new I(E,L),2!==r&&a.faceVertexUvs[n][o].push(T),0!==r&&a.faceVertexUvs[n][o+1].push(T);if(v&&(h=3*R[s++],S.normal.set(D[h++],D[h++],D[h]),A.normal.copy(S.normal)),y)for(n=0;n<4;n++)h=3*R[s++],C=new N(D[h++],D[h++],D[h]),2!==n&&S.vertexNormals.push(C),0!==n&&A.vertexNormals.push(C);if(b&&(u=R[s++],M=k[u],S.color.setHex(M),A.color.setHex(M)),x)for(n=0;n<4;n++)u=R[s++],M=k[u],2!==n&&S.vertexColors.push(new Pt(M)),0!==n&&A.vertexColors.push(new Pt(M));a.faces.push(S),a.faces.push(A)}else{if(w=new ee,w.a=R[s++],w.b=R[s++],w.c=R[s++],m&&(d=R[s++],w.materialIndex=d),o=a.faces.length,g)for(n=0;n<F;n++)for(P=t.uvs[n],a.faceVertexUvs[n][o]=[],r=0;r<3;r++)l=R[s++],E=P[2*l],L=P[2*l+1],T=new I(E,L),a.faceVertexUvs[n][o].push(T);if(v&&(h=3*R[s++],w.normal.set(D[h++],D[h++],D[h])),y)for(n=0;n<3;n++)h=3*R[s++],C=new N(D[h++],D[h++],D[h]),w.vertexNormals.push(C);if(b&&(u=R[s++],w.color.setHex(k[u])),x)for(n=0;n<3;n++)u=R[s++],w.vertexColors.push(new Pt(k[u]));a.faces.push(w)}}function n(){var e=void 0!==t.influencesPerVertex?t.influencesPerVertex:2;if(t.skinWeights)for(var i=0,n=t.skinWeights.length;i<n;i+=e){var r=t.skinWeights[i],o=e>1?t.skinWeights[i+1]:0,s=e>2?t.skinWeights[i+2]:0,c=e>3?t.skinWeights[i+3]:0;a.skinWeights.push(new _t(r,o,s,c))}if(t.skinIndices)for(var i=0,n=t.skinIndices.length;i<n;i+=e){var u=t.skinIndices[i],h=e>1?t.skinIndices[i+1]:0,l=e>2?t.skinIndices[i+2]:0,d=e>3?t.skinIndices[i+3]:0;a.skinIndices.push(new _t(u,h,l,d))}a.bones=t.bones,a.bones&&a.bones.length>0&&(a.skinWeights.length!==a.skinIndices.length||a.skinIndices.length!==a.vertices.length)&&console.warn("When skinning, number of vertices ("+a.vertices.length+"), skinIndices ("+a.skinIndices.length+"), and skinWeights ("+a.skinWeights.length+") should match.")}function r(e){if(void 0!==t.morphTargets)for(var i=0,n=t.morphTargets.length;i<n;i++){a.morphTargets[i]={},a.morphTargets[i].name=t.morphTargets[i].name,a.morphTargets[i].vertices=[];for(var r=a.morphTargets[i].vertices,o=t.morphTargets[i].vertices,s=0,c=o.length;s<c;s+=3){var u=new N;u.x=o[s]*e,u.y=o[s+1]*e,u.z=o[s+2]*e,r.push(u)}}if(void 0!==t.morphColors&&t.morphColors.length>0){console.warn('THREE.JSONLoader: "morphColors" no longer supported. Using them as face colors.');for(var h=a.faces,l=t.morphColors[0].colors,i=0,n=h.length;i<n;i++)h[i].color.fromArray(l,3*i)}}function o(){var e=[],i=[];void 0!==t.animation&&i.push(t.animation),void 0!==t.animations&&(t.animations.length?i=i.concat(t.animations):i.push(t.animations));for(var n=0;n<i.length;n++){var r=Si.parseAnimation(i[n],a.bones);r&&e.push(r)}if(a.morphTargets){var o=Si.CreateClipsFromMorphTargetSequences(a.morphTargets,10);e=e.concat(o)}e.length>0&&(a.animations=e)}var a=new ae,s=void 0!==t.scale?1/t.scale:1;if(i(s),n(),r(s),o(),a.computeFaceNormals(),a.computeBoundingSphere(),void 0===t.materials||0===t.materials.length)return{geometry:a};var c=Ci.prototype.initMaterials(t.materials,e,this.crossOrigin);return{geometry:a,materials:c}}}),Object.assign(Ti.prototype,{load:function(t,e,i,n){""===this.texturePath&&(this.texturePath=t.substring(0,t.lastIndexOf("/")+1));var r=this,o=new Ye(r.manager);o.load(t,function(t){r.parse(JSON.parse(t),e)},i,n)},setTexturePath:function(t){this.texturePath=t},setCrossOrigin:function(t){this.crossOrigin=t},parse:function(t,e){var i=this.parseGeometries(t.geometries),n=this.parseImages(t.images,function(){void 0!==e&&e(a)}),r=this.parseTextures(t.textures,n),o=this.parseMaterials(t.materials,r),a=this.parseObject(t.object,i,o);return t.animations&&(a.animations=this.parseAnimations(t.animations)),void 0!==t.images&&0!==t.images.length||void 0!==e&&e(a),a},parseGeometries:function(t){var e={};if(void 0!==t)for(var i=new Pi,n=new Mi,r=0,o=t.length;r<o;r++){var a,s=t[r];switch(s.type){case"PlaneGeometry":case"PlaneBufferGeometry":a=new THREE[s.type](s.width,s.height,s.widthSegments,s.heightSegments);break;case"BoxGeometry":case"BoxBufferGeometry":case"CubeGeometry":a=new THREE[s.type](s.width,s.height,s.depth,s.widthSegments,s.heightSegments,s.depthSegments);break;case"CircleGeometry":case"CircleBufferGeometry":a=new THREE[s.type](s.radius,s.segments,s.thetaStart,s.thetaLength);break;case"CylinderGeometry":case"CylinderBufferGeometry":a=new THREE[s.type](s.radiusTop,s.radiusBottom,s.height,s.radialSegments,s.heightSegments,s.openEnded,s.thetaStart,s.thetaLength);break;case"ConeGeometry":case"ConeBufferGeometry":a=new THREE[s.type](s.radius,s.height,s.radialSegments,s.heightSegments,s.openEnded,s.thetaStart,s.thetaLength);break;case"SphereGeometry":case"SphereBufferGeometry":a=new THREE[s.type](s.radius,s.widthSegments,s.heightSegments,s.phiStart,s.phiLength,s.thetaStart,s.thetaLength);break;case"DodecahedronGeometry":case"IcosahedronGeometry":case"OctahedronGeometry":case"TetrahedronGeometry":a=new THREE[s.type](s.radius,s.detail);break;case"RingGeometry":case"RingBufferGeometry":a=new THREE[s.type](s.innerRadius,s.outerRadius,s.thetaSegments,s.phiSegments,s.thetaStart,s.thetaLength);break;case"TorusGeometry":case"TorusBufferGeometry":a=new THREE[s.type](s.radius,s.tube,s.radialSegments,s.tubularSegments,s.arc);break;case"TorusKnotGeometry":case"TorusKnotBufferGeometry":a=new THREE[s.type](s.radius,s.tube,s.tubularSegments,s.radialSegments,s.p,s.q);break;case"LatheGeometry":case"LatheBufferGeometry":a=new THREE[s.type](s.points,s.segments,s.phiStart,s.phiLength);break;case"BufferGeometry":a=n.parse(s);break;case"Geometry":a=i.parse(s.data,this.texturePath).geometry;break;default:console.warn('THREE.ObjectLoader: Unsupported geometry type "'+s.type+'"');continue}a.uuid=s.uuid,void 0!==s.name&&(a.name=s.name),e[s.uuid]=a}return e},parseMaterials:function(t,e){var i={};if(void 0!==t){var n=new Ai;n.setTextures(e);for(var r=0,o=t.length;r<o;r++){var a=n.parse(t[r]);i[a.uuid]=a}}return i},parseAnimations:function(t){for(var e=[],i=0;i<t.length;i++){var n=Si.parse(t[i]);e.push(n)}return e},parseImages:function(t,e){function i(t){return n.manager.itemStart(t),a.load(t,function(){n.manager.itemEnd(t)},void 0,function(){n.manager.itemError(t)})}var n=this,r={};if(void 0!==t&&t.length>0){var o=new qe(e),a=new Qe(o);a.setCrossOrigin(this.crossOrigin);for(var s=0,c=t.length;s<c;s++){var u=t[s],h=/^(\/\/)|([a-z]+:(\/\/)?)/i.test(u.url)?u.url:n.texturePath+u.url;r[u.uuid]=i(h)}}return r},parseTextures:function(t,e){function i(t){return"number"==typeof t?t:(console.warn("THREE.ObjectLoader.parseTexture: Constant should be in numeric form.",t),THREE[t])}var n={};if(void 0!==t)for(var r=0,o=t.length;r<o;r++){var a=t[r];void 0===a.image&&console.warn('THREE.ObjectLoader: No "image" specified for',a.uuid),void 0===e[a.image]&&console.warn("THREE.ObjectLoader: Undefined image",a.image);var s=new L(e[a.image]);s.needsUpdate=!0,s.uuid=a.uuid,void 0!==a.name&&(s.name=a.name),void 0!==a.mapping&&(s.mapping=i(a.mapping)),void 0!==a.offset&&s.offset.fromArray(a.offset),void 0!==a.repeat&&s.repeat.fromArray(a.repeat),void 0!==a.wrap&&(s.wrapS=i(a.wrap[0]),s.wrapT=i(a.wrap[1])),void 0!==a.minFilter&&(s.minFilter=i(a.minFilter)),void 0!==a.magFilter&&(s.magFilter=i(a.magFilter)),void 0!==a.anisotropy&&(s.anisotropy=a.anisotropy),void 0!==a.flipY&&(s.flipY=a.flipY),n[a.uuid]=s}return n},parseObject:function(){var t=new O;return function(e,i,n){function r(t){return void 0===i[t]&&console.warn("THREE.ObjectLoader: Undefined geometry",t),i[t]}function o(t){if(void 0!==t)return void 0===n[t]&&console.warn("THREE.ObjectLoader: Undefined material",t),n[t]}var a;switch(e.type){case"Scene":a=new Le,void 0!==e.background&&Number.isInteger(e.background)&&(a.background=new THREE.Color(e.background)),void 0!==e.fog&&("Fog"===e.fog.type?a.fog=new Ie(e.fog.color,e.fog.near,e.fog.far):"FogExp2"===e.fog.type&&(a.fog=new Ee(e.fog.color,e.fog.density)));break;case"PerspectiveCamera":a=new Ce(e.fov,e.aspect,e.near,e.far),void 0!==e.focus&&(a.focus=e.focus),void 0!==e.zoom&&(a.zoom=e.zoom),void 0!==e.filmGauge&&(a.filmGauge=e.filmGauge),void 0!==e.filmOffset&&(a.filmOffset=e.filmOffset),void 0!==e.view&&(a.view=Object.assign({},e.view));break;case"OrthographicCamera":a=new Pe(e.left,e.right,e.top,e.bottom,e.near,e.far);break;case"AmbientLight":a=new ui(e.color,e.intensity);break;case"DirectionalLight":a=new ci(e.color,e.intensity);break;case"PointLight":a=new ai(e.color,e.intensity,e.distance,e.decay);break;case"SpotLight":a=new oi(e.color,e.intensity,e.distance,e.angle,e.penumbra,e.decay);break;case"HemisphereLight":a=new ii(e.color,e.groundColor,e.intensity);break;case"Mesh":var s=r(e.geometry),c=o(e.material);a=s.bones&&s.bones.length>0?new Be(s,c):new Se(s,c);break;case"LOD":a=new Ne;break;case"Line":a=new je(r(e.geometry),o(e.material),e.mode);break;case"LineSegments":a=new $e(r(e.geometry),o(e.material));break;case"PointCloud":case"Points":a=new Ge(r(e.geometry),o(e.material));break;case"Sprite":a=new De(o(e.material));break;case"Group":a=new He;break;default:a=new re}if(a.uuid=e.uuid,void 0!==e.name&&(a.name=e.name),void 0!==e.matrix?(t.fromArray(e.matrix),t.decompose(a.position,a.quaternion,a.scale)):(void 0!==e.position&&a.position.fromArray(e.position),void 0!==e.rotation&&a.rotation.fromArray(e.rotation),void 0!==e.quaternion&&a.quaternion.fromArray(e.quaternion),void 0!==e.scale&&a.scale.fromArray(e.scale)),void 0!==e.castShadow&&(a.castShadow=e.castShadow),void 0!==e.receiveShadow&&(a.receiveShadow=e.receiveShadow),e.shadow&&(void 0!==e.shadow.bias&&(a.shadow.bias=e.shadow.bias),void 0!==e.shadow.radius&&(a.shadow.radius=e.shadow.radius),void 0!==e.shadow.mapSize&&a.shadow.mapSize.fromArray(e.shadow.mapSize),void 0!==e.shadow.camera&&(a.shadow.camera=this.parseObject(e.shadow.camera))),void 0!==e.visible&&(a.visible=e.visible),void 0!==e.userData&&(a.userData=e.userData),void 0!==e.children)for(var u in e.children)a.add(this.parseObject(e.children[u],i,n));if("LOD"===e.type)for(var h=e.levels,l=0;l<h.length;l++){var d=h[l],u=a.getObjectByProperty("uuid",d.object);void 0!==u&&a.addLevel(u,d.distance)}return a}}()});var Ip={area:function(t){for(var e=t.length,i=0,n=e-1,r=0;r<e;n=r++)i+=t[n].x*t[r].y-t[r].x*t[n].y;return.5*i},triangulate:function(){function t(t,e,i,n,r,o){var a,s,c,u,h,l,d,f,p;if(s=t[o[e]].x,c=t[o[e]].y,u=t[o[i]].x,h=t[o[i]].y,l=t[o[n]].x,d=t[o[n]].y,Number.EPSILON>(u-s)*(d-c)-(h-c)*(l-s))return!1;var m,g,v,y,b,x,_,w,S,A,M,C,P,T,E;for(m=l-u,g=d-h,v=s-l,y=c-d,b=u-s,x=h-c,a=0;a<r;a++)if(f=t[o[a]].x,p=t[o[a]].y,!(f===s&&p===c||f===u&&p===h||f===l&&p===d)&&(_=f-s,w=p-c,S=f-u,A=p-h,M=f-l,C=p-d,E=m*A-g*S,P=b*w-x*_,T=v*C-y*M,E>=-Number.EPSILON&&T>=-Number.EPSILON&&P>=-Number.EPSILON))return!1;return!0}return function(e,i){var n=e.length;if(n<3)return null;var r,o,a,s=[],c=[],u=[];if(Ip.area(e)>0)for(o=0;o<n;o++)c[o]=o;else for(o=0;o<n;o++)c[o]=n-1-o;var h=n,l=2*h;for(o=h-1;h>2;){if(l--<=0)return console.warn("THREE.ShapeUtils: Unable to triangulate polygon! in triangulate()"),i?u:s;if(r=o,h<=r&&(r=0),o=r+1,h<=o&&(o=0),a=o+1,h<=a&&(a=0),t(e,r,o,a,h,c)){var d,f,p,m,g;for(d=c[r],f=c[o],p=c[a],s.push([e[d],e[f],e[p]]),u.push([c[r],c[o],c[a]]),m=o,g=o+1;g<h;m++,g++)c[m]=c[g];h--,l=2*h}}return i?u:s}}(),triangulateShape:function(t,e){function i(t){var e=t.length;e>2&&t[e-1].equals(t[0])&&t.pop()}function n(t,e,i){return t.x!==e.x?t.x<e.x?t.x<=i.x&&i.x<=e.x:e.x<=i.x&&i.x<=t.x:t.y<e.y?t.y<=i.y&&i.y<=e.y:e.y<=i.y&&i.y<=t.y}function r(t,e,i,r,o){var a=e.x-t.x,s=e.y-t.y,c=r.x-i.x,u=r.y-i.y,h=t.x-i.x,l=t.y-i.y,d=s*c-a*u,f=s*h-a*l;if(Math.abs(d)>Number.EPSILON){var p;if(d>0){if(f<0||f>d)return[];if(p=u*h-c*l,p<0||p>d)return[]}else{if(f>0||f<d)return[];if(p=u*h-c*l,p>0||p<d)return[]}if(0===p)return!o||0!==f&&f!==d?[t]:[];if(p===d)return!o||0!==f&&f!==d?[e]:[];if(0===f)return[i];if(f===d)return[r];var m=p/d;return[{x:t.x+m*a,y:t.y+m*s}]}if(0!==f||u*h!==c*l)return[];var g=0===a&&0===s,v=0===c&&0===u;if(g&&v)return t.x!==i.x||t.y!==i.y?[]:[t];if(g)return n(i,r,t)?[t]:[];if(v)return n(t,e,i)?[i]:[];var y,b,x,_,w,S,A,M;return 0!==a?(t.x<e.x?(y=t,x=t.x,b=e,_=e.x):(y=e,x=e.x,b=t,_=t.x),i.x<r.x?(w=i,A=i.x,S=r,M=r.x):(w=r,A=r.x,S=i,M=i.x)):(t.y<e.y?(y=t,x=t.y,b=e,_=e.y):(y=e,x=e.y,b=t,_=t.y),i.y<r.y?(w=i,A=i.y,S=r,M=r.y):(w=r,A=r.y,S=i,M=i.y)),x<=A?_<A?[]:_===A?o?[]:[w]:_<=M?[w,b]:[w,S]:x>M?[]:x===M?o?[]:[y]:_<=M?[y,b]:[y,S]}function o(t,e,i,n){var r=e.x-t.x,o=e.y-t.y,a=i.x-t.x,s=i.y-t.y,c=n.x-t.x,u=n.y-t.y,h=r*s-o*a,l=r*u-o*c;if(Math.abs(h)>Number.EPSILON){var d=c*s-u*a;return h>0?l>=0&&d>=0:l>=0||d>=0}return l>0}function a(t,e){function i(t,e){var i=y.length-1,n=t-1;n<0&&(n=i);var r=t+1;r>i&&(r=0);var a=o(y[t],y[n],y[r],s[e]);if(!a)return!1;var c=s.length-1,u=e-1;u<0&&(u=c);var h=e+1;return h>c&&(h=0),a=o(s[e],s[u],s[h],y[t]),!!a}function n(t,e){var i,n,o;for(i=0;i<y.length;i++)if(n=i+1,n%=y.length,o=r(t,e,y[i],y[n],!0),o.length>0)return!0;return!1}function a(t,i){var n,o,a,s,c;for(n=0;n<b.length;n++)for(o=e[b[n]],a=0;a<o.length;a++)if(s=a+1,s%=o.length,c=r(t,i,o[a],o[s],!0),c.length>0)return!0;return!1}for(var s,c,u,h,l,d,f,p,m,g,v,y=t.concat(),b=[],x=[],_=0,w=e.length;_<w;_++)b.push(_);for(var S=0,A=2*b.length;b.length>0;){if(A--,A<0){console.log("Infinite Loop! Holes left:"+b.length+", Probably Hole outside Shape!");break}for(u=S;u<y.length;u++){h=y[u],c=-1;for(var _=0;_<b.length;_++)if(d=b[_],f=h.x+":"+h.y+":"+d,void 0===x[f]){s=e[d];for(var M=0;M<s.length;M++)if(l=s[M],i(u,M)&&!n(h,l)&&!a(h,l)){c=M,b.splice(_,1),p=y.slice(0,u+1),m=y.slice(u),g=s.slice(c),v=s.slice(0,c+1),y=p.concat(g).concat(v).concat(m),S=u;break}if(c>=0)break;x[f]=!0}if(c>=0)break}}return y}i(t),e.forEach(i);for(var s,c,u,h,l,d,f={},p=t.concat(),m=0,g=e.length;m<g;m++)Array.prototype.push.apply(p,e[m]);for(s=0,c=p.length;s<c;s++)l=p[s].x+":"+p[s].y,void 0!==f[l]&&console.warn("THREE.ShapeUtils: Duplicate point",l,s),f[l]=s;var v=a(t,e),y=Ip.triangulate(v,!1);for(s=0,c=y.length;s<c;s++)for(h=y[s],u=0;u<3;u++)l=h[u].x+":"+h[u].y,d=f[l],void 0!==d&&(h[u]=d);return y.concat()},isClockWise:function(t){return Ip.area(t)<0},b2:function(){function t(t,e){var i=1-t;return i*i*e}function e(t,e){return 2*(1-t)*t*e}function i(t,e){return t*t*e}return function(n,r,o,a){return t(n,r)+e(n,o)+i(n,a)}}(),b3:function(){function t(t,e){var i=1-t;return i*i*i*e}function e(t,e){var i=1-t;return 3*i*i*t*e}function i(t,e){var i=1-t;return 3*i*t*t*e}function n(t,e){return t*t*t*e}return function(r,o,a,s,c){return t(r,o)+e(r,a)+i(r,s)+n(r,c)}}()};Ei.prototype={constructor:Ei,getPoint:function(t){return console.warn("THREE.Curve: Warning, getPoint() not implemented!"),null},getPointAt:function(t){var e=this.getUtoTmapping(t);return this.getPoint(e)},getPoints:function(t){t||(t=5);for(var e=[],i=0;i<=t;i++)e.push(this.getPoint(i/t));return e},getSpacedPoints:function(t){t||(t=5);
	for(var e=[],i=0;i<=t;i++)e.push(this.getPointAt(i/t));return e},getLength:function(){var t=this.getLengths();return t[t.length-1]},getLengths:function(t){if(t||(t=this.__arcLengthDivisions?this.__arcLengthDivisions:200),this.cacheArcLengths&&this.cacheArcLengths.length===t+1&&!this.needsUpdate)return this.cacheArcLengths;this.needsUpdate=!1;var e,i,n=[],r=this.getPoint(0),o=0;for(n.push(0),i=1;i<=t;i++)e=this.getPoint(i/t),o+=e.distanceTo(r),n.push(o),r=e;return this.cacheArcLengths=n,n},updateArcLengths:function(){this.needsUpdate=!0,this.getLengths()},getUtoTmapping:function(t,e){var i,n=this.getLengths(),r=0,o=n.length;i=e?e:t*n[o-1];for(var a,s=0,c=o-1;s<=c;)if(r=Math.floor(s+(c-s)/2),a=n[r]-i,a<0)s=r+1;else{if(!(a>0)){c=r;break}c=r-1}if(r=c,n[r]===i){var u=r/(o-1);return u}var h=n[r],l=n[r+1],d=l-h,f=(i-h)/d,u=(r+f)/(o-1);return u},getTangent:function(t){var e=1e-4,i=t-e,n=t+e;i<0&&(i=0),n>1&&(n=1);var r=this.getPoint(i),o=this.getPoint(n),a=o.clone().sub(r);return a.normalize()},getTangentAt:function(t){var e=this.getUtoTmapping(t);return this.getTangent(e)}},Ei.create=function(t,e){return t.prototype=Object.create(Ei.prototype),t.prototype.constructor=t,t.prototype.getPoint=e,t},Ii.prototype=Object.create(Ei.prototype),Ii.prototype.constructor=Ii,Ii.prototype.isLineCurve=!0,Ii.prototype.getPoint=function(t){if(1===t)return this.v2.clone();var e=this.v2.clone().sub(this.v1);return e.multiplyScalar(t).add(this.v1),e},Ii.prototype.getPointAt=function(t){return this.getPoint(t)},Ii.prototype.getTangent=function(t){var e=this.v2.clone().sub(this.v1);return e.normalize()},Li.prototype=Object.assign(Object.create(Ei.prototype),{constructor:Li,add:function(t){this.curves.push(t)},closePath:function(){var t=this.curves[0].getPoint(0),e=this.curves[this.curves.length-1].getPoint(1);t.equals(e)||this.curves.push(new Ii(e,t))},getPoint:function(t){for(var e=t*this.getLength(),i=this.getCurveLengths(),n=0;n<i.length;){if(i[n]>=e){var r=i[n]-e,o=this.curves[n],a=o.getLength(),s=0===a?0:1-r/a;return o.getPointAt(s)}n++}return null},getLength:function(){var t=this.getCurveLengths();return t[t.length-1]},updateArcLengths:function(){this.needsUpdate=!0,this.cacheLengths=null,this.getLengths()},getCurveLengths:function(){if(this.cacheLengths&&this.cacheLengths.length===this.curves.length)return this.cacheLengths;for(var t=[],e=0,i=0,n=this.curves.length;i<n;i++)e+=this.curves[i].getLength(),t.push(e);return this.cacheLengths=t,t},getSpacedPoints:function(t){t||(t=40);for(var e=[],i=0;i<=t;i++)e.push(this.getPoint(i/t));return this.autoClose&&e.push(e[0]),e},getPoints:function(t){t=t||12;for(var e,i=[],n=0,r=this.curves;n<r.length;n++)for(var o=r[n],a=o&&o.isEllipseCurve?2*t:o&&o.isLineCurve?1:o&&o.isSplineCurve?t*o.points.length:t,s=o.getPoints(a),c=0;c<s.length;c++){var u=s[c];e&&e.equals(u)||(i.push(u),e=u)}return this.autoClose&&i.length>1&&!i[i.length-1].equals(i[0])&&i.push(i[0]),i},createPointsGeometry:function(t){var e=this.getPoints(t);return this.createGeometry(e)},createSpacedPointsGeometry:function(t){var e=this.getSpacedPoints(t);return this.createGeometry(e)},createGeometry:function(t){for(var e=new ae,i=0,n=t.length;i<n;i++){var r=t[i];e.vertices.push(new N(r.x,r.y,r.z||0))}return e}}),Ri.prototype=Object.create(Ei.prototype),Ri.prototype.constructor=Ri,Ri.prototype.isEllipseCurve=!0,Ri.prototype.getPoint=function(t){for(var e=2*Math.PI,i=this.aEndAngle-this.aStartAngle,n=Math.abs(i)<Number.EPSILON;i<0;)i+=e;for(;i>e;)i-=e;i<Number.EPSILON&&(i=n?0:e),this.aClockwise!==!0||n||(i===e?i=-e:i-=e);var r=this.aStartAngle+t*i,o=this.aX+this.xRadius*Math.cos(r),a=this.aY+this.yRadius*Math.sin(r);if(0!==this.aRotation){var s=Math.cos(this.aRotation),c=Math.sin(this.aRotation),u=o-this.aX,h=a-this.aY;o=u*s-h*c+this.aX,a=u*c+h*s+this.aY}return new I(o,a)};var Lp={tangentQuadraticBezier:function(t,e,i,n){return 2*(1-t)*(i-e)+2*t*(n-i)},tangentCubicBezier:function(t,e,i,n,r){return-3*e*(1-t)*(1-t)+3*i*(1-t)*(1-t)-6*t*i*(1-t)+6*t*n*(1-t)-3*t*t*n+3*t*t*r},tangentSpline:function(t,e,i,n,r){var o=6*t*t-6*t,a=3*t*t-4*t+1,s=-6*t*t+6*t,c=3*t*t-2*t;return o+a+s+c},interpolate:function(t,e,i,n,r){var o=.5*(i-t),a=.5*(n-e),s=r*r,c=r*s;return(2*e-2*i+o+a)*c+(-3*e+3*i-2*o-a)*s+o*r+e}};Oi.prototype=Object.create(Ei.prototype),Oi.prototype.constructor=Oi,Oi.prototype.isSplineCurve=!0,Oi.prototype.getPoint=function(t){var e=this.points,i=(e.length-1)*t,n=Math.floor(i),r=i-n,o=e[0===n?n:n-1],a=e[n],s=e[n>e.length-2?e.length-1:n+1],c=e[n>e.length-3?e.length-1:n+2],u=Lp.interpolate;return new I(u(o.x,a.x,s.x,c.x,r),u(o.y,a.y,s.y,c.y,r))},Di.prototype=Object.create(Ei.prototype),Di.prototype.constructor=Di,Di.prototype.getPoint=function(t){var e=Ip.b3;return new I(e(t,this.v0.x,this.v1.x,this.v2.x,this.v3.x),e(t,this.v0.y,this.v1.y,this.v2.y,this.v3.y))},Di.prototype.getTangent=function(t){var e=Lp.tangentCubicBezier;return new I(e(t,this.v0.x,this.v1.x,this.v2.x,this.v3.x),e(t,this.v0.y,this.v1.y,this.v2.y,this.v3.y)).normalize()},Ni.prototype=Object.create(Ei.prototype),Ni.prototype.constructor=Ni,Ni.prototype.getPoint=function(t){var e=Ip.b2;return new I(e(t,this.v0.x,this.v1.x,this.v2.x),e(t,this.v0.y,this.v1.y,this.v2.y))},Ni.prototype.getTangent=function(t){var e=Lp.tangentQuadraticBezier;return new I(e(t,this.v0.x,this.v1.x,this.v2.x),e(t,this.v0.y,this.v1.y,this.v2.y)).normalize()};var Rp=Object.assign(Object.create(Li.prototype),{fromPoints:function(t){this.moveTo(t[0].x,t[0].y);for(var e=1,i=t.length;e<i;e++)this.lineTo(t[e].x,t[e].y)},moveTo:function(t,e){this.currentPoint.set(t,e)},lineTo:function(t,e){var i=new Ii(this.currentPoint.clone(),new I(t,e));this.curves.push(i),this.currentPoint.set(t,e)},quadraticCurveTo:function(t,e,i,n){var r=new Ni(this.currentPoint.clone(),new I(t,e),new I(i,n));this.curves.push(r),this.currentPoint.set(i,n)},bezierCurveTo:function(t,e,i,n,r,o){var a=new Di(this.currentPoint.clone(),new I(t,e),new I(i,n),new I(r,o));this.curves.push(a),this.currentPoint.set(r,o)},splineThru:function(t){var e=[this.currentPoint.clone()].concat(t),i=new Oi(e);this.curves.push(i),this.currentPoint.copy(t[t.length-1])},arc:function(t,e,i,n,r,o){var a=this.currentPoint.x,s=this.currentPoint.y;this.absarc(t+a,e+s,i,n,r,o)},absarc:function(t,e,i,n,r,o){this.absellipse(t,e,i,i,n,r,o)},ellipse:function(t,e,i,n,r,o,a,s){var c=this.currentPoint.x,u=this.currentPoint.y;this.absellipse(t+c,e+u,i,n,r,o,a,s)},absellipse:function(t,e,i,n,r,o,a,s){var c=new Ri(t,e,i,n,r,o,a,s);if(this.curves.length>0){var u=c.getPoint(0);u.equals(this.currentPoint)||this.lineTo(u.x,u.y)}this.curves.push(c);var h=c.getPoint(1);this.currentPoint.copy(h)}});ki.prototype=Object.create(ae.prototype),ki.prototype.constructor=ki,ki.NoTaper=function(t){return 1},ki.SinusoidalTaper=function(t){return Math.sin(Math.PI*t)},ki.FrenetFrames=function(t,e,i){function n(){f[0]=new N,p[0]=new N,o=Number.MAX_VALUE,a=Math.abs(d[0].x),s=Math.abs(d[0].y),c=Math.abs(d[0].z),a<=o&&(o=a,l.set(1,0,0)),s<=o&&(o=s,l.set(0,1,0)),c<=o&&l.set(0,0,1),m.crossVectors(d[0],l).normalize(),f[0].crossVectors(d[0],m),p[0].crossVectors(d[0],f[0])}var r,o,a,s,c,u,h,l=new N,d=[],f=[],p=[],m=new N,g=new O,v=e+1;for(this.tangents=d,this.normals=f,this.binormals=p,u=0;u<v;u++)h=u/(v-1),d[u]=t.getTangentAt(h),d[u].normalize();for(n(),u=1;u<v;u++)f[u]=f[u-1].clone(),p[u]=p[u-1].clone(),m.crossVectors(d[u-1],d[u]),m.length()>Number.EPSILON&&(m.normalize(),r=Math.acos(dd.clamp(d[u-1].dot(d[u]),-1,1)),f[u].applyMatrix4(g.makeRotationAxis(m,r))),p[u].crossVectors(d[u],f[u]);if(i)for(r=Math.acos(dd.clamp(f[0].dot(f[v-1]),-1,1)),r/=v-1,d[0].dot(m.crossVectors(f[0],f[v-1]))>0&&(r=-r),u=1;u<v;u++)f[u].applyMatrix4(g.makeRotationAxis(d[u],r*u)),p[u].crossVectors(d[u],f[u])},Fi.prototype=Object.create(ae.prototype),Fi.prototype.constructor=Fi,Fi.prototype.addShapeList=function(t,e){for(var i=t.length,n=0;n<i;n++){var r=t[n];this.addShape(r,e)}},Fi.prototype.addShape=function(t,e){function i(t,e,i){return e||console.error("THREE.ExtrudeGeometry: vec does not exist"),e.clone().multiplyScalar(i).add(t)}function n(t,e,i){var n,r,o=1,a=t.x-e.x,s=t.y-e.y,c=i.x-t.x,u=i.y-t.y,h=a*a+s*s,l=a*u-s*c;if(Math.abs(l)>Number.EPSILON){var d=Math.sqrt(h),f=Math.sqrt(c*c+u*u),p=e.x-s/d,m=e.y+a/d,g=i.x-u/f,v=i.y+c/f,y=((g-p)*u-(v-m)*c)/(a*u-s*c);n=p+a*y-t.x,r=m+s*y-t.y;var b=n*n+r*r;if(b<=2)return new I(n,r);o=Math.sqrt(b/2)}else{var x=!1;a>Number.EPSILON?c>Number.EPSILON&&(x=!0):a<-Number.EPSILON?c<-Number.EPSILON&&(x=!0):Math.sign(s)===Math.sign(u)&&(x=!0),x?(n=-s,r=a,o=Math.sqrt(h)):(n=a,r=s,o=Math.sqrt(h/2))}return new I(n/o,r/o)}function r(){if(b){var t=0,e=G*t;for(X=0;X<H;X++)V=k[X],c(V[2]+e,V[1]+e,V[0]+e);for(t=_+2*y,e=G*t,X=0;X<H;X++)V=k[X],c(V[0]+e,V[1]+e,V[2]+e)}else{for(X=0;X<H;X++)V=k[X],c(V[2],V[1],V[0]);for(X=0;X<H;X++)V=k[X],c(V[0]+G*_,V[1]+G*_,V[2]+G*_)}}function o(){var t=0;for(a(F,t),t+=F.length,C=0,P=O.length;C<P;C++)M=O[C],a(M,t),t+=M.length}function a(t,e){var i,n;for(X=t.length;--X>=0;){i=X,n=X-1,n<0&&(n=t.length-1);var r=0,o=_+2*y;for(r=0;r<o;r++){var a=G*r,s=G*(r+1),c=e+i+a,h=e+n+a,l=e+n+s,d=e+i+s;u(c,h,l,d,t,r,o,i,n)}}}function s(t,e,i){T.vertices.push(new N(t,e,i))}function c(t,e,i){t+=E,e+=E,i+=E,T.faces.push(new ee(t,e,i,null,null,0));var n=A.generateTopUV(T,t,e,i);T.faceVertexUvs[0].push(n)}function u(t,e,i,n,r,o,a,s,c){t+=E,e+=E,i+=E,n+=E,T.faces.push(new ee(t,e,n,null,null,1)),T.faces.push(new ee(e,i,n,null,null,1));var u=A.generateSideWallUV(T,t,e,i,n);T.faceVertexUvs[0].push([u[0],u[1],u[3]]),T.faceVertexUvs[0].push([u[1],u[2],u[3]])}var h,l,d,f,p,m=void 0!==e.amount?e.amount:100,g=void 0!==e.bevelThickness?e.bevelThickness:6,v=void 0!==e.bevelSize?e.bevelSize:g-2,y=void 0!==e.bevelSegments?e.bevelSegments:3,b=void 0===e.bevelEnabled||e.bevelEnabled,x=void 0!==e.curveSegments?e.curveSegments:12,_=void 0!==e.steps?e.steps:1,w=e.extrudePath,S=!1,A=void 0!==e.UVGenerator?e.UVGenerator:Fi.WorldUVGenerator;w&&(h=w.getSpacedPoints(_),S=!0,b=!1,l=void 0!==e.frames?e.frames:new ki.FrenetFrames(w,_,!1),d=new N,f=new N,p=new N),b||(y=0,g=0,v=0);var M,C,P,T=this,E=this.vertices.length,L=t.extractPoints(x),R=L.shape,O=L.holes,D=!Ip.isClockWise(R);if(D){for(R=R.reverse(),C=0,P=O.length;C<P;C++)M=O[C],Ip.isClockWise(M)&&(O[C]=M.reverse());D=!1}var k=Ip.triangulateShape(R,O),F=R;for(C=0,P=O.length;C<P;C++)M=O[C],R=R.concat(M);for(var z,B,U,j,$,V,G=R.length,H=k.length,W=[],X=0,q=F.length,Y=q-1,Z=X+1;X<q;X++,Y++,Z++)Y===q&&(Y=0),Z===q&&(Z=0),W[X]=n(F[X],F[Y],F[Z]);var K,Q=[],J=W.concat();for(C=0,P=O.length;C<P;C++){for(M=O[C],K=[],X=0,q=M.length,Y=q-1,Z=X+1;X<q;X++,Y++,Z++)Y===q&&(Y=0),Z===q&&(Z=0),K[X]=n(M[X],M[Y],M[Z]);Q.push(K),J=J.concat(K)}for(z=0;z<y;z++){for(U=z/y,j=g*Math.cos(U*Math.PI/2),B=v*Math.sin(U*Math.PI/2),X=0,q=F.length;X<q;X++)$=i(F[X],W[X],B),s($.x,$.y,-j);for(C=0,P=O.length;C<P;C++)for(M=O[C],K=Q[C],X=0,q=M.length;X<q;X++)$=i(M[X],K[X],B),s($.x,$.y,-j)}for(B=v,X=0;X<G;X++)$=b?i(R[X],J[X],B):R[X],S?(f.copy(l.normals[0]).multiplyScalar($.x),d.copy(l.binormals[0]).multiplyScalar($.y),p.copy(h[0]).add(f).add(d),s(p.x,p.y,p.z)):s($.x,$.y,0);var tt;for(tt=1;tt<=_;tt++)for(X=0;X<G;X++)$=b?i(R[X],J[X],B):R[X],S?(f.copy(l.normals[tt]).multiplyScalar($.x),d.copy(l.binormals[tt]).multiplyScalar($.y),p.copy(h[tt]).add(f).add(d),s(p.x,p.y,p.z)):s($.x,$.y,m/_*tt);for(z=y-1;z>=0;z--){for(U=z/y,j=g*Math.cos(U*Math.PI/2),B=v*Math.sin(U*Math.PI/2),X=0,q=F.length;X<q;X++)$=i(F[X],W[X],B),s($.x,$.y,m+j);for(C=0,P=O.length;C<P;C++)for(M=O[C],K=Q[C],X=0,q=M.length;X<q;X++)$=i(M[X],K[X],B),S?s($.x,$.y+h[_-1].y,h[_-1].x+j):s($.x,$.y,m+j)}r(),o()},Fi.WorldUVGenerator={generateTopUV:function(t,e,i,n){var r=t.vertices,o=r[e],a=r[i],s=r[n];return[new I(o.x,o.y),new I(a.x,a.y),new I(s.x,s.y)]},generateSideWallUV:function(t,e,i,n,r){var o=t.vertices,a=o[e],s=o[i],c=o[n],u=o[r];return Math.abs(a.y-s.y)<.01?[new I(a.x,1-a.z),new I(s.x,1-s.z),new I(c.x,1-c.z),new I(u.x,1-u.z)]:[new I(a.y,1-a.z),new I(s.y,1-s.z),new I(c.y,1-c.z),new I(u.y,1-u.z)]}},zi.prototype=Object.create(ae.prototype),zi.prototype.constructor=zi,zi.prototype.addShapeList=function(t,e){for(var i=0,n=t.length;i<n;i++)this.addShape(t[i],e);return this},zi.prototype.addShape=function(t,e){void 0===e&&(e={});var i,n,r,o=void 0!==e.curveSegments?e.curveSegments:12,a=e.material,s=void 0===e.UVGenerator?Fi.WorldUVGenerator:e.UVGenerator,c=this.vertices.length,u=t.extractPoints(o),h=u.shape,l=u.holes,d=!Ip.isClockWise(h);if(d){for(h=h.reverse(),i=0,n=l.length;i<n;i++)r=l[i],Ip.isClockWise(r)&&(l[i]=r.reverse());d=!1}var f=Ip.triangulateShape(h,l);for(i=0,n=l.length;i<n;i++)r=l[i],h=h.concat(r);var p,m,g=h.length,v=f.length;for(i=0;i<g;i++)p=h[i],this.vertices.push(new N(p.x,p.y,0));for(i=0;i<v;i++){m=f[i];var y=m[0]+c,b=m[1]+c,x=m[2]+c;this.faces.push(new ee(y,b,x,null,null,a)),this.faceVertexUvs[0].push(s.generateTopUV(this,y,b,x))}},Bi.prototype=Object.assign(Object.create(Rp),{constructor:Bi,extrude:function(t){return new Fi(this,t)},makeGeometry:function(t){return new zi(this,t)},getPointsHoles:function(t){for(var e=[],i=0,n=this.holes.length;i<n;i++)e[i]=this.holes[i].getPoints(t);return e},extractAllPoints:function(t){return{shape:this.getPoints(t),holes:this.getPointsHoles(t)}},extractPoints:function(t){return this.extractAllPoints(t)}}),Ui.prototype=Rp,Rp.constructor=Ui,ji.prototype={moveTo:function(t,e){this.currentPath=new Ui,this.subPaths.push(this.currentPath),this.currentPath.moveTo(t,e)},lineTo:function(t,e){this.currentPath.lineTo(t,e)},quadraticCurveTo:function(t,e,i,n){this.currentPath.quadraticCurveTo(t,e,i,n)},bezierCurveTo:function(t,e,i,n,r,o){this.currentPath.bezierCurveTo(t,e,i,n,r,o)},splineThru:function(t){this.currentPath.splineThru(t)},toShapes:function(t,e){function i(t){for(var e=[],i=0,n=t.length;i<n;i++){var r=t[i],o=new Bi;o.curves=r.curves,e.push(o)}return e}function n(t,e){for(var i=e.length,n=!1,r=i-1,o=0;o<i;r=o++){var a=e[r],s=e[o],c=s.x-a.x,u=s.y-a.y;if(Math.abs(u)>Number.EPSILON){if(u<0&&(a=e[o],c=-c,s=e[r],u=-u),t.y<a.y||t.y>s.y)continue;if(t.y===a.y){if(t.x===a.x)return!0}else{var h=u*(t.x-a.x)-c*(t.y-a.y);if(0===h)return!0;if(h<0)continue;n=!n}}else{if(t.y!==a.y)continue;if(s.x<=t.x&&t.x<=a.x||a.x<=t.x&&t.x<=s.x)return!0}}return n}var r=Ip.isClockWise,o=this.subPaths;if(0===o.length)return[];if(e===!0)return i(o);var a,s,c,u=[];if(1===o.length)return s=o[0],c=new Bi,c.curves=s.curves,u.push(c),u;var h=!r(o[0].getPoints());h=t?!h:h;var l,d=[],f=[],p=[],m=0;f[m]=void 0,p[m]=[];for(var g=0,v=o.length;g<v;g++)s=o[g],l=s.getPoints(),a=r(l),a=t?!a:a,a?(!h&&f[m]&&m++,f[m]={s:new Bi,p:l},f[m].s.curves=s.curves,h&&m++,p[m]=[]):p[m].push({h:s,p:l[0]});if(!f[0])return i(o);if(f.length>1){for(var y=!1,b=[],x=0,_=f.length;x<_;x++)d[x]=[];for(var x=0,_=f.length;x<_;x++)for(var w=p[x],S=0;S<w.length;S++){for(var A=w[S],M=!0,C=0;C<f.length;C++)n(A.p,f[C].p)&&(x!==C&&b.push({froms:x,tos:C,hole:S}),M?(M=!1,d[C].push(A)):y=!0);M&&d[x].push(A)}b.length>0&&(y||(p=d))}for(var P,g=0,T=f.length;g<T;g++){c=f[g].s,u.push(c),P=p[g];for(var E=0,I=P.length;E<I;E++)c.holes.push(P[E].h)}return u}},Object.assign($i.prototype,{isFont:!0,generateShapes:function(t,e,i){function n(t){for(var i=String(t).split(""),n=e/o.resolution,a=0,s=[],c=0;c<i.length;c++){var u=r(i[c],n,a);a+=u.offset,s.push(u.path)}return s}function r(t,e,n){var r=o.glyphs[t]||o.glyphs["?"];if(r){var a,s,c,u,h,l,d,f,p,m,g,v=new ji,y=[],b=Ip.b2,x=Ip.b3;if(r.o)for(var _=r._cachedOutline||(r._cachedOutline=r.o.split(" ")),w=0,S=_.length;w<S;){var A=_[w++];switch(A){case"m":a=_[w++]*e+n,s=_[w++]*e,v.moveTo(a,s);break;case"l":a=_[w++]*e+n,s=_[w++]*e,v.lineTo(a,s);break;case"q":if(c=_[w++]*e+n,u=_[w++]*e,d=_[w++]*e+n,f=_[w++]*e,v.quadraticCurveTo(d,f,c,u),g=y[y.length-1]){h=g.x,l=g.y;for(var M=1;M<=i;M++){var C=M/i;b(C,h,d,c),b(C,l,f,u)}}break;case"b":if(c=_[w++]*e+n,u=_[w++]*e,d=_[w++]*e+n,f=_[w++]*e,p=_[w++]*e+n,m=_[w++]*e,v.bezierCurveTo(d,f,p,m,c,u),g=y[y.length-1]){h=g.x,l=g.y;for(var M=1;M<=i;M++){var C=M/i;x(C,h,d,p,c),x(C,l,f,m,u)}}}}return{offset:r.ha*e,path:v}}}void 0===e&&(e=100),void 0===i&&(i=4);for(var o=this.data,a=n(t),s=[],c=0,u=a.length;c<u;c++)Array.prototype.push.apply(s,a[c].toShapes());return s}}),Object.assign(Vi.prototype,{load:function(t,e,i,n){var r=this,o=new Ye(this.manager);o.load(t,function(t){var i;try{i=JSON.parse(t)}catch(e){console.warn("THREE.FontLoader: typeface.js support is being deprecated. Use typeface.json instead."),i=JSON.parse(t.substring(65,t.length-2))}var n=r.parse(i);e&&e(n)},i,n)},parse:function(t){return new $i(t)}});var Op;Object.assign(Hi.prototype,{load:function(t,e,i,n){var r=new Ye(this.manager);r.setResponseType("arraybuffer"),r.load(t,function(t){var i=Gi();i.decodeAudioData(t,function(t){e(t)})},i,n)}}),Object.assign(Wi.prototype,{update:function(){var t,e,i,n,r,o=new O,a=new O;return function(s){var c=t!==s.focus||e!==s.fov||i!==s.aspect*this.aspect||n!==s.near||r!==s.far;if(c){t=s.focus,e=s.fov,i=s.aspect*this.aspect,n=s.near,r=s.far;var u,h,l=s.projectionMatrix.clone(),d=this.eyeSep/2,f=d*n/t,p=n*Math.tan(dd.DEG2RAD*e*.5);a.elements[12]=-d,o.elements[12]=d,u=-p*i+f,h=p*i+f,l.elements[0]=2*n/(h-u),l.elements[8]=(h+u)/(h-u),this.cameraL.projectionMatrix.copy(l),u=-p*i-f,h=p*i-f,l.elements[0]=2*n/(h-u),l.elements[8]=(h+u)/(h-u),this.cameraR.projectionMatrix.copy(l)}this.cameraL.matrixWorld.copy(s.matrixWorld).multiply(a),this.cameraR.matrixWorld.copy(s.matrixWorld).multiply(o)}}()}),Xi.prototype=Object.assign(Object.create(re.prototype),{constructor:Xi,getInput:function(){return this.gain},removeFilter:function(){null!==this.filter&&(this.gain.disconnect(this.filter),this.filter.disconnect(this.context.destination),this.gain.connect(this.context.destination),this.filter=null)},getFilter:function(){return this.filter},setFilter:function(t){null!==this.filter?(this.gain.disconnect(this.filter),this.filter.disconnect(this.context.destination)):this.gain.disconnect(this.context.destination),this.filter=t,this.gain.connect(this.filter),this.filter.connect(this.context.destination)},getMasterVolume:function(){return this.gain.gain.value},setMasterVolume:function(t){this.gain.gain.value=t},updateMatrixWorld:function(){var t=new N,e=new D,i=new N,n=new N;return function(r){re.prototype.updateMatrixWorld.call(this,r);var o=this.context.listener,a=this.up;this.matrixWorld.decompose(t,e,i),n.set(0,0,-1).applyQuaternion(e),o.setPosition(t.x,t.y,t.z),o.setOrientation(n.x,n.y,n.z,a.x,a.y,a.z)}}()}),qi.prototype=Object.assign(Object.create(re.prototype),{constructor:qi,getOutput:function(){return this.gain},setNodeSource:function(t){return this.hasPlaybackControl=!1,this.sourceType="audioNode",this.source=t,this.connect(),this},setBuffer:function(t){return this.source.buffer=t,this.sourceType="buffer",this.autoplay&&this.play(),this},play:function(){if(this.isPlaying===!0)return void console.warn("THREE.Audio: Audio is already playing.");if(this.hasPlaybackControl===!1)return void console.warn("THREE.Audio: this Audio has no playback control.");var t=this.context.createBufferSource();return t.buffer=this.source.buffer,t.loop=this.source.loop,t.onended=this.source.onended,t.start(0,this.startTime),t.playbackRate.value=this.playbackRate,this.isPlaying=!0,this.source=t,this.connect()},pause:function(){return this.hasPlaybackControl===!1?void console.warn("THREE.Audio: this Audio has no playback control."):(this.source.stop(),this.startTime=this.context.currentTime,this.isPlaying=!1,this)},stop:function(){return this.hasPlaybackControl===!1?void console.warn("THREE.Audio: this Audio has no playback control."):(this.source.stop(),this.startTime=0,this.isPlaying=!1,this)},connect:function(){if(this.filters.length>0){this.source.connect(this.filters[0]);for(var t=1,e=this.filters.length;t<e;t++)this.filters[t-1].connect(this.filters[t]);this.filters[this.filters.length-1].connect(this.getOutput())}else this.source.connect(this.getOutput());return this},disconnect:function(){if(this.filters.length>0){this.source.disconnect(this.filters[0]);for(var t=1,e=this.filters.length;t<e;t++)this.filters[t-1].disconnect(this.filters[t]);this.filters[this.filters.length-1].disconnect(this.getOutput())}else this.source.disconnect(this.getOutput());return this},getFilters:function(){return this.filters},setFilters:function(t){return t||(t=[]),this.isPlaying===!0?(this.disconnect(),this.filters=t,this.connect()):this.filters=t,this},getFilter:function(){return this.getFilters()[0]},setFilter:function(t){return this.setFilters(t?[t]:[])},setPlaybackRate:function(t){return this.hasPlaybackControl===!1?void console.warn("THREE.Audio: this Audio has no playback control."):(this.playbackRate=t,this.isPlaying===!0&&(this.source.playbackRate.value=this.playbackRate),this)},getPlaybackRate:function(){return this.playbackRate},onEnded:function(){this.isPlaying=!1},getLoop:function(){return this.hasPlaybackControl===!1?(console.warn("THREE.Audio: this Audio has no playback control."),!1):this.source.loop},setLoop:function(t){return this.hasPlaybackControl===!1?void console.warn("THREE.Audio: this Audio has no playback control."):void(this.source.loop=t)},getVolume:function(){return this.gain.gain.value},setVolume:function(t){return this.gain.gain.value=t,this}}),Yi.prototype=Object.assign(Object.create(qi.prototype),{constructor:Yi,getOutput:function(){return this.panner},getRefDistance:function(){return this.panner.refDistance},setRefDistance:function(t){this.panner.refDistance=t},getRolloffFactor:function(){return this.panner.rolloffFactor},setRolloffFactor:function(t){this.panner.rolloffFactor=t},getDistanceModel:function(){return this.panner.distanceModel},setDistanceModel:function(t){this.panner.distanceModel=t},getMaxDistance:function(){return this.panner.maxDistance},setMaxDistance:function(t){this.panner.maxDistance=t},updateMatrixWorld:function(){var t=new N;return function(e){re.prototype.updateMatrixWorld.call(this,e),t.setFromMatrixPosition(this.matrixWorld),this.panner.setPosition(t.x,t.y,t.z)}}()}),Object.assign(Zi.prototype,{getFrequencyData:function(){return this.analyser.getByteFrequencyData(this.data),this.data},getAverageFrequency:function(){for(var t=0,e=this.getFrequencyData(),i=0;i<e.length;i++)t+=e[i];return t/e.length}}),Ki.prototype={constructor:Ki,accumulate:function(t,e){var i=this.buffer,n=this.valueSize,r=t*n+n,o=this.cumulativeWeight;if(0===o){for(var a=0;a!==n;++a)i[r+a]=i[a];o=e}else{o+=e;var s=e/o;this._mixBufferRegion(i,r,0,s,n)}this.cumulativeWeight=o},apply:function(t){var e=this.valueSize,i=this.buffer,n=t*e+e,r=this.cumulativeWeight,o=this.binding;if(this.cumulativeWeight=0,r<1){var a=3*e;this._mixBufferRegion(i,n,a,1-r,e)}for(var s=e,c=e+e;s!==c;++s)if(i[s]!==i[s+e]){o.setValue(i,n);break}},saveOriginalState:function(){var t=this.binding,e=this.buffer,i=this.valueSize,n=3*i;t.getValue(e,n);for(var r=i,o=n;r!==o;++r)e[r]=e[n+r%i];this.cumulativeWeight=0},restoreOriginalState:function(){var t=3*this.valueSize;this.binding.setValue(this.buffer,t)},_select:function(t,e,i,n,r){if(n>=.5)for(var o=0;o!==r;++o)t[e+o]=t[i+o]},_slerp:function(t,e,i,n,r){D.slerpFlat(t,e,t,e,t,i,n)},_lerp:function(t,e,i,n,r){for(var o=1-n,a=0;a!==r;++a){var s=e+a;t[s]=t[s]*o+t[i+a]*n}}},Qi.prototype={constructor:Qi,getValue:function(t,e){this.bind(),this.getValue(t,e)},setValue:function(t,e){this.bind(),this.setValue(t,e)},bind:function(){var t=this.node,e=this.parsedPath,i=e.objectName,n=e.propertyName,r=e.propertyIndex;if(t||(t=Qi.findNode(this.rootNode,e.nodeName)||this.rootNode,this.node=t),this.getValue=this._getValue_unavailable,this.setValue=this._setValue_unavailable,!t)return void console.error("  trying to update node for track: "+this.path+" but it wasn't found.");if(i){var o=e.objectIndex;switch(i){case"materials":if(!t.material)return void console.error("  can not bind to material as node does not have a material",this);if(!t.material.materials)return void console.error("  can not bind to material.materials as node.material does not have a materials array",this);t=t.material.materials;break;case"bones":if(!t.skeleton)return void console.error("  can not bind to bones as node does not have a skeleton",this);t=t.skeleton.bones;for(var a=0;a<t.length;a++)if(t[a].name===o){o=a;break}break;default:if(void 0===t[i])return void console.error("  can not bind to objectName of node, undefined",this);t=t[i]}if(void 0!==o){if(void 0===t[o])return void console.error("  trying to bind to objectIndex of objectName, but is undefined:",this,t);t=t[o]}}var s=t[n];if(void 0===s){var c=e.nodeName;return void console.error("  trying to update property for track: "+c+"."+n+" but it wasn't found.",t)}var u=this.Versioning.None;void 0!==t.needsUpdate?(u=this.Versioning.NeedsUpdate,this.targetObject=t):void 0!==t.matrixWorldNeedsUpdate&&(u=this.Versioning.MatrixWorldNeedsUpdate,this.targetObject=t);var h=this.BindingType.Direct;if(void 0!==r){if("morphTargetInfluences"===n){if(!t.geometry)return void console.error("  can not bind to morphTargetInfluences becasuse node does not have a geometry",this);if(!t.geometry.morphTargets)return void console.error("  can not bind to morphTargetInfluences becasuse node does not have a geometry.morphTargets",this);for(var a=0;a<this.node.geometry.morphTargets.length;a++)if(t.geometry.morphTargets[a].name===r){r=a;break}}h=this.BindingType.ArrayElement,this.resolvedProperty=s,this.propertyIndex=r}else void 0!==s.fromArray&&void 0!==s.toArray?(h=this.BindingType.HasFromToArray,this.resolvedProperty=s):void 0!==s.length?(h=this.BindingType.EntireArray,this.resolvedProperty=s):this.propertyName=n;this.getValue=this.GetterByBindingType[h],this.setValue=this.SetterByBindingTypeAndVersioning[h][u]},unbind:function(){this.node=null,this.getValue=this._getValue_unbound,this.setValue=this._setValue_unbound}},Object.assign(Qi.prototype,{_getValue_unavailable:function(){},_setValue_unavailable:function(){},_getValue_unbound:Qi.prototype.getValue,_setValue_unbound:Qi.prototype.setValue,BindingType:{Direct:0,EntireArray:1,ArrayElement:2,HasFromToArray:3},Versioning:{None:0,NeedsUpdate:1,MatrixWorldNeedsUpdate:2},GetterByBindingType:[function(t,e){t[e]=this.node[this.propertyName]},function(t,e){for(var i=this.resolvedProperty,n=0,r=i.length;n!==r;++n)t[e++]=i[n]},function(t,e){t[e]=this.resolvedProperty[this.propertyIndex]},function(t,e){this.resolvedProperty.toArray(t,e)}],SetterByBindingTypeAndVersioning:[[function(t,e){this.node[this.propertyName]=t[e]},function(t,e){this.node[this.propertyName]=t[e],this.targetObject.needsUpdate=!0},function(t,e){this.node[this.propertyName]=t[e],this.targetObject.matrixWorldNeedsUpdate=!0}],[function(t,e){for(var i=this.resolvedProperty,n=0,r=i.length;n!==r;++n)i[n]=t[e++]},function(t,e){for(var i=this.resolvedProperty,n=0,r=i.length;n!==r;++n)i[n]=t[e++];this.targetObject.needsUpdate=!0},function(t,e){for(var i=this.resolvedProperty,n=0,r=i.length;n!==r;++n)i[n]=t[e++];this.targetObject.matrixWorldNeedsUpdate=!0}],[function(t,e){this.resolvedProperty[this.propertyIndex]=t[e]},function(t,e){this.resolvedProperty[this.propertyIndex]=t[e],this.targetObject.needsUpdate=!0},function(t,e){this.resolvedProperty[this.propertyIndex]=t[e],this.targetObject.matrixWorldNeedsUpdate=!0}],[function(t,e){this.resolvedProperty.fromArray(t,e)},function(t,e){this.resolvedProperty.fromArray(t,e),this.targetObject.needsUpdate=!0},function(t,e){this.resolvedProperty.fromArray(t,e),this.targetObject.matrixWorldNeedsUpdate=!0}]]}),Qi.Composite=function(t,e,i){var n=i||Qi.parseTrackName(e);this._targetGroup=t,this._bindings=t.subscribe_(e,n)},Qi.Composite.prototype={constructor:Qi.Composite,getValue:function(t,e){this.bind();var i=this._targetGroup.nCachedObjects_,n=this._bindings[i];void 0!==n&&n.getValue(t,e)},setValue:function(t,e){for(var i=this._bindings,n=this._targetGroup.nCachedObjects_,r=i.length;n!==r;++n)i[n].setValue(t,e)},bind:function(){for(var t=this._bindings,e=this._targetGroup.nCachedObjects_,i=t.length;e!==i;++e)t[e].bind()},unbind:function(){for(var t=this._bindings,e=this._targetGroup.nCachedObjects_,i=t.length;e!==i;++e)t[e].unbind()}},Qi.create=function(t,e,i){return t&&t.isAnimationObjectGroup?new Qi.Composite(t,e,i):new Qi(t,e,i)},Qi.parseTrackName=function(t){var e=/^((?:\w+\/)*)(\w+)?(?:\.(\w+)(?:\[(.+)\])?)?\.(\w+)(?:\[(.+)\])?$/,i=e.exec(t);if(!i)throw new Error("cannot parse trackName at all: "+t);var n={nodeName:i[2],objectName:i[3],objectIndex:i[4],propertyName:i[5],propertyIndex:i[6]};if(null===n.propertyName||0===n.propertyName.length)throw new Error("can not parse propertyName from trackName: "+t);return n},Qi.findNode=function(t,e){if(!e||""===e||"root"===e||"."===e||e===-1||e===t.name||e===t.uuid)return t;if(t.skeleton){var i=function(t){for(var i=0;i<t.bones.length;i++){var n=t.bones[i];if(n.name===e)return n}return null},n=i(t.skeleton);if(n)return n}if(t.children){var r=function(t){for(var i=0;i<t.length;i++){var n=t[i];if(n.name===e||n.uuid===e)return n;var o=r(n.children);if(o)return o}return null},o=r(t.children);if(o)return o}return null},Ji.prototype={constructor:Ji,play:function(){return this._mixer._activateAction(this),this},stop:function(){return this._mixer._deactivateAction(this),this.reset()},reset:function(){return this.paused=!1,this.enabled=!0,this.time=0,this._loopCount=-1,this._startTime=null,this.stopFading().stopWarping()},isRunning:function(){return this.enabled&&!this.paused&&0!==this.timeScale&&null===this._startTime&&this._mixer._isActiveAction(this)},isScheduled:function(){return this._mixer._isActiveAction(this)},startAt:function(t){return this._startTime=t,this},setLoop:function(t,e){return this.loop=t,this.repetitions=e,this},setEffectiveWeight:function(t){return this.weight=t,this._effectiveWeight=this.enabled?t:0,this.stopFading()},getEffectiveWeight:function(){return this._effectiveWeight},fadeIn:function(t){return this._scheduleFading(t,0,1)},fadeOut:function(t){return this._scheduleFading(t,1,0)},crossFadeFrom:function(t,e,i){if(t.fadeOut(e),this.fadeIn(e),i){var n=this._clip.duration,r=t._clip.duration,o=r/n,a=n/r;t.warp(1,o,e),this.warp(a,1,e)}return this},crossFadeTo:function(t,e,i){return t.crossFadeFrom(this,e,i)},stopFading:function(){var t=this._weightInterpolant;return null!==t&&(this._weightInterpolant=null,this._mixer._takeBackControlInterpolant(t)),this},setEffectiveTimeScale:function(t){return this.timeScale=t,this._effectiveTimeScale=this.paused?0:t,this.stopWarping()},getEffectiveTimeScale:function(){return this._effectiveTimeScale},setDuration:function(t){return this.timeScale=this._clip.duration/t,this.stopWarping()},syncWith:function(t){return this.time=t.time,this.timeScale=t.timeScale,this.stopWarping()},halt:function(t){return this.warp(this._effectiveTimeScale,0,t)},warp:function(t,e,i){var n=this._mixer,r=n.time,o=this._timeScaleInterpolant,a=this.timeScale;null===o&&(o=n._lendControlInterpolant(),this._timeScaleInterpolant=o);var s=o.parameterPositions,c=o.sampleValues;return s[0]=r,s[1]=r+i,c[0]=t/a,c[1]=e/a,this},stopWarping:function(){var t=this._timeScaleInterpolant;return null!==t&&(this._timeScaleInterpolant=null,this._mixer._takeBackControlInterpolant(t)),this},getMixer:function(){return this._mixer},getClip:function(){return this._clip},getRoot:function(){return this._localRoot||this._mixer._root},_update:function(t,e,i,n){var r=this._startTime;if(null!==r){var o=(t-r)*i;if(o<0||0===i)return;this._startTime=null,e=i*o}e*=this._updateTimeScale(t);var a=this._updateTime(e),s=this._updateWeight(t);if(s>0)for(var c=this._interpolants,u=this._propertyBindings,h=0,l=c.length;h!==l;++h)c[h].evaluate(a),u[h].accumulate(n,s)},_updateWeight:function(t){var e=0;if(this.enabled){e=this.weight;var i=this._weightInterpolant;if(null!==i){var n=i.evaluate(t)[0];e*=n,t>i.parameterPositions[1]&&(this.stopFading(),0===n&&(this.enabled=!1))}}return this._effectiveWeight=e,e},_updateTimeScale:function(t){var e=0;if(!this.paused){e=this.timeScale;var i=this._timeScaleInterpolant;if(null!==i){var n=i.evaluate(t)[0];e*=n,t>i.parameterPositions[1]&&(this.stopWarping(),
	0===e?this.paused=!0:this.timeScale=e)}}return this._effectiveTimeScale=e,e},_updateTime:function(t){var e=this.time+t;if(0===t)return e;var i=this._clip.duration,n=this.loop,r=this._loopCount;if(n===Hl){r===-1&&(this.loopCount=0,this._setEndings(!0,!0,!1));t:{if(e>=i)e=i;else{if(!(e<0))break t;e=0}this.clampWhenFinished?this.paused=!0:this.enabled=!1,this._mixer.dispatchEvent({type:"finished",action:this,direction:t<0?-1:1})}}else{var o=n===Xl;if(r===-1&&(t>=0?(r=0,this._setEndings(!0,0===this.repetitions,o)):this._setEndings(0===this.repetitions,!0,o)),e>=i||e<0){var a=Math.floor(e/i);e-=i*a,r+=Math.abs(a);var s=this.repetitions-r;if(s<0)this.clampWhenFinished?this.paused=!0:this.enabled=!1,e=t>0?i:0,this._mixer.dispatchEvent({type:"finished",action:this,direction:t>0?1:-1});else{if(0===s){var c=t<0;this._setEndings(c,!c,o)}else this._setEndings(!1,!1,o);this._loopCount=r,this._mixer.dispatchEvent({type:"loop",action:this,loopDelta:a})}}if(o&&1===(1&r))return this.time=e,i-e}return this.time=e,e},_setEndings:function(t,e,i){var n=this._interpolantSettings;i?(n.endingStart=Ql,n.endingEnd=Ql):(t?n.endingStart=this.zeroSlopeAtStart?Ql:Kl:n.endingStart=Jl,e?n.endingEnd=this.zeroSlopeAtEnd?Ql:Kl:n.endingEnd=Jl)},_scheduleFading:function(t,e,i){var n=this._mixer,r=n.time,o=this._weightInterpolant;null===o&&(o=n._lendControlInterpolant(),this._weightInterpolant=o);var a=o.parameterPositions,s=o.sampleValues;return a[0]=r,s[0]=e,a[1]=r+t,s[1]=i,this}},Object.assign(tn.prototype,E.prototype,{clipAction:function(t,e){var i=e||this._root,n=i.uuid,r="string"==typeof t?Si.findByName(i,t):t,o=null!==r?r.uuid:t,a=this._actionsByClip[o],s=null;if(void 0!==a){var c=a.actionByRoot[n];if(void 0!==c)return c;s=a.knownActions[0],null===r&&(r=s._clip)}if(null===r)return null;var u=new Ji(this,r,e);return this._bindAction(u,s),this._addInactiveAction(u,o,n),u},existingAction:function(t,e){var i=e||this._root,n=i.uuid,r="string"==typeof t?Si.findByName(i,t):t,o=r?r.uuid:t,a=this._actionsByClip[o];return void 0!==a?a.actionByRoot[n]||null:null},stopAllAction:function(){var t=this._actions,e=this._nActiveActions,i=this._bindings,n=this._nActiveBindings;this._nActiveActions=0,this._nActiveBindings=0;for(var r=0;r!==e;++r)t[r].reset();for(var r=0;r!==n;++r)i[r].useCount=0;return this},update:function(t){t*=this.timeScale;for(var e=this._actions,i=this._nActiveActions,n=this.time+=t,r=Math.sign(t),o=this._accuIndex^=1,a=0;a!==i;++a){var s=e[a];s.enabled&&s._update(n,t,r,o)}for(var c=this._bindings,u=this._nActiveBindings,a=0;a!==u;++a)c[a].apply(o);return this},getRoot:function(){return this._root},uncacheClip:function(t){var e=this._actions,i=t.uuid,n=this._actionsByClip,r=n[i];if(void 0!==r){for(var o=r.knownActions,a=0,s=o.length;a!==s;++a){var c=o[a];this._deactivateAction(c);var u=c._cacheIndex,h=e[e.length-1];c._cacheIndex=null,c._byClipCacheIndex=null,h._cacheIndex=u,e[u]=h,e.pop(),this._removeInactiveBindingsForAction(c)}delete n[i]}},uncacheRoot:function(t){var e=t.uuid,i=this._actionsByClip;for(var n in i){var r=i[n].actionByRoot,o=r[e];void 0!==o&&(this._deactivateAction(o),this._removeInactiveAction(o))}var a=this._bindingsByRootAndName,s=a[e];if(void 0!==s)for(var c in s){var u=s[c];u.restoreOriginalState(),this._removeInactiveBinding(u)}},uncacheAction:function(t,e){var i=this.existingAction(t,e);null!==i&&(this._deactivateAction(i),this._removeInactiveAction(i))}}),Object.assign(tn.prototype,{_bindAction:function(t,e){var i=t._localRoot||this._root,n=t._clip.tracks,r=n.length,o=t._propertyBindings,a=t._interpolants,s=i.uuid,c=this._bindingsByRootAndName,u=c[s];void 0===u&&(u={},c[s]=u);for(var h=0;h!==r;++h){var l=n[h],d=l.name,f=u[d];if(void 0!==f)o[h]=f;else{if(f=o[h],void 0!==f){null===f._cacheIndex&&(++f.referenceCount,this._addInactiveBinding(f,s,d));continue}var p=e&&e._propertyBindings[h].binding.parsedPath;f=new Ki(Qi.create(i,d,p),l.ValueTypeName,l.getValueSize()),++f.referenceCount,this._addInactiveBinding(f,s,d),o[h]=f}a[h].resultBuffer=f.buffer}},_activateAction:function(t){if(!this._isActiveAction(t)){if(null===t._cacheIndex){var e=(t._localRoot||this._root).uuid,i=t._clip.uuid,n=this._actionsByClip[i];this._bindAction(t,n&&n.knownActions[0]),this._addInactiveAction(t,i,e)}for(var r=t._propertyBindings,o=0,a=r.length;o!==a;++o){var s=r[o];0===s.useCount++&&(this._lendBinding(s),s.saveOriginalState())}this._lendAction(t)}},_deactivateAction:function(t){if(this._isActiveAction(t)){for(var e=t._propertyBindings,i=0,n=e.length;i!==n;++i){var r=e[i];0===--r.useCount&&(r.restoreOriginalState(),this._takeBackBinding(r))}this._takeBackAction(t)}},_initMemoryManager:function(){this._actions=[],this._nActiveActions=0,this._actionsByClip={},this._bindings=[],this._nActiveBindings=0,this._bindingsByRootAndName={},this._controlInterpolants=[],this._nActiveControlInterpolants=0;var t=this;this.stats={actions:{get total(){return t._actions.length},get inUse(){return t._nActiveActions}},bindings:{get total(){return t._bindings.length},get inUse(){return t._nActiveBindings}},controlInterpolants:{get total(){return t._controlInterpolants.length},get inUse(){return t._nActiveControlInterpolants}}}},_isActiveAction:function(t){var e=t._cacheIndex;return null!==e&&e<this._nActiveActions},_addInactiveAction:function(t,e,i){var n=this._actions,r=this._actionsByClip,o=r[e];if(void 0===o)o={knownActions:[t],actionByRoot:{}},t._byClipCacheIndex=0,r[e]=o;else{var a=o.knownActions;t._byClipCacheIndex=a.length,a.push(t)}t._cacheIndex=n.length,n.push(t),o.actionByRoot[i]=t},_removeInactiveAction:function(t){var e=this._actions,i=e[e.length-1],n=t._cacheIndex;i._cacheIndex=n,e[n]=i,e.pop(),t._cacheIndex=null;var r=t._clip.uuid,o=this._actionsByClip,a=o[r],s=a.knownActions,c=s[s.length-1],u=t._byClipCacheIndex;c._byClipCacheIndex=u,s[u]=c,s.pop(),t._byClipCacheIndex=null;var h=a.actionByRoot,l=(e._localRoot||this._root).uuid;delete h[l],0===s.length&&delete o[r],this._removeInactiveBindingsForAction(t)},_removeInactiveBindingsForAction:function(t){for(var e=t._propertyBindings,i=0,n=e.length;i!==n;++i){var r=e[i];0===--r.referenceCount&&this._removeInactiveBinding(r)}},_lendAction:function(t){var e=this._actions,i=t._cacheIndex,n=this._nActiveActions++,r=e[n];t._cacheIndex=n,e[n]=t,r._cacheIndex=i,e[i]=r},_takeBackAction:function(t){var e=this._actions,i=t._cacheIndex,n=--this._nActiveActions,r=e[n];t._cacheIndex=n,e[n]=t,r._cacheIndex=i,e[i]=r},_addInactiveBinding:function(t,e,i){var n=this._bindingsByRootAndName,r=n[e],o=this._bindings;void 0===r&&(r={},n[e]=r),r[i]=t,t._cacheIndex=o.length,o.push(t)},_removeInactiveBinding:function(t){var e=this._bindings,i=t.binding,n=i.rootNode.uuid,r=i.path,o=this._bindingsByRootAndName,a=o[n],s=e[e.length-1],c=t._cacheIndex;s._cacheIndex=c,e[c]=s,e.pop(),delete a[r];t:{for(var u in a)break t;delete o[n]}},_lendBinding:function(t){var e=this._bindings,i=t._cacheIndex,n=this._nActiveBindings++,r=e[n];t._cacheIndex=n,e[n]=t,r._cacheIndex=i,e[i]=r},_takeBackBinding:function(t){var e=this._bindings,i=t._cacheIndex,n=--this._nActiveBindings,r=e[n];t._cacheIndex=n,e[n]=t,r._cacheIndex=i,e[i]=r},_lendControlInterpolant:function(){var t=this._controlInterpolants,e=this._nActiveControlInterpolants++,i=t[e];return void 0===i&&(i=new di(new Float32Array(2),new Float32Array(2),1,this._controlInterpolantsResultBuffer),i.__cacheIndex=e,t[e]=i),i},_takeBackControlInterpolant:function(t){var e=this._controlInterpolants,i=t.__cacheIndex,n=--this._nActiveControlInterpolants,r=e[n];t.__cacheIndex=n,e[n]=t,r.__cacheIndex=i,e[i]=r},_controlInterpolantsResultBuffer:new Float32Array(1)}),en.prototype={constructor:en,onUpdate:function(t){return this.dynamic=!0,this.onUpdateCallback=t,this}},nn.prototype=Object.create($e.prototype),nn.prototype.constructor=nn,nn.prototype.update=function(){var t=new N,e=new N,i=new Lt;return function(){var n=["a","b","c"];this.object.updateMatrixWorld(!0),i.getNormalMatrix(this.object.matrixWorld);var r=this.object.matrixWorld,o=this.geometry.attributes.position,a=this.object.geometry;if(a&&a.isGeometry)for(var s=a.vertices,c=a.faces,u=0,h=0,l=c.length;h<l;h++)for(var d=c[h],f=0,p=d.vertexNormals.length;f<p;f++){var m=s[d[n[f]]],g=d.vertexNormals[f];t.copy(m).applyMatrix4(r),e.copy(g).applyMatrix3(i).normalize().multiplyScalar(this.size).add(t),o.setXYZ(u,t.x,t.y,t.z),u+=1,o.setXYZ(u,e.x,e.y,e.z),u+=1}else if(a&&a.isBufferGeometry)for(var v=a.attributes.position,y=a.attributes.normal,u=0,f=0,p=v.count;f<p;f++)t.set(v.getX(f),v.getY(f),v.getZ(f)).applyMatrix4(r),e.set(y.getX(f),y.getY(f),y.getZ(f)),e.applyMatrix3(i).normalize().multiplyScalar(this.size).add(t),o.setXYZ(u,t.x,t.y,t.z),u+=1,o.setXYZ(u,e.x,e.y,e.z),u+=1;return o.needsUpdate=!0,this}}(),rn.prototype=Object.create(re.prototype),rn.prototype.constructor=rn,rn.prototype.dispose=function(){this.cone.geometry.dispose(),this.cone.material.dispose()},rn.prototype.update=function(){var t=new N,e=new N;return function(){var i=this.light.distance?this.light.distance:1e3,n=i*Math.tan(this.light.angle);this.cone.scale.set(n,n,i),t.setFromMatrixPosition(this.light.matrixWorld),e.setFromMatrixPosition(this.light.target.matrixWorld),this.cone.lookAt(e.sub(t)),this.cone.material.color.copy(this.light.color).multiplyScalar(this.light.intensity)}}(),on.prototype=Object.create(ue.prototype),on.prototype.constructor=on,an.prototype=Object.create(ae.prototype),an.prototype.constructor=an,sn.prototype=Object.create(re.prototype),sn.prototype.constructor=sn,sn.prototype.dispose=function(){this.lightSphere.geometry.dispose(),this.lightSphere.material.dispose()},sn.prototype.update=function(){var t=new N;return function(){this.colors[0].copy(this.light.color).multiplyScalar(this.light.intensity),this.colors[1].copy(this.light.groundColor).multiplyScalar(this.light.intensity),this.lightSphere.lookAt(t.setFromMatrixPosition(this.light.matrixWorld).negate()),this.lightSphere.geometry.colorsNeedUpdate=!0}}(),cn.prototype=Object.create($e.prototype),cn.prototype.constructor=cn,cn.prototype.update=function(){var t=new N,e=new N,i=new Lt;return function(){this.object.updateMatrixWorld(!0),i.getNormalMatrix(this.object.matrixWorld);for(var n=this.object.matrixWorld,r=this.geometry.attributes.position,o=this.object.geometry,a=o.vertices,s=o.faces,c=0,u=0,h=s.length;u<h;u++){var l=s[u],d=l.normal;t.copy(a[l.a]).add(a[l.b]).add(a[l.c]).divideScalar(3).applyMatrix4(n),e.copy(d).applyMatrix3(i).normalize().multiplyScalar(this.size).add(t),r.setXYZ(c,t.x,t.y,t.z),c+=1,r.setXYZ(c,e.x,e.y,e.z),c+=1}return r.needsUpdate=!0,this}}(),un.prototype=Object.create(re.prototype),un.prototype.constructor=un,un.prototype.dispose=function(){var t=this.children[0],e=this.children[1];t.geometry.dispose(),t.material.dispose(),e.geometry.dispose(),e.material.dispose()},un.prototype.update=function(){var t=new N,e=new N,i=new N;return function(){t.setFromMatrixPosition(this.light.matrixWorld),e.setFromMatrixPosition(this.light.target.matrixWorld),i.subVectors(e,t);var n=this.children[0],r=this.children[1];n.lookAt(i),n.material.color.copy(this.light.color).multiplyScalar(this.light.intensity),r.lookAt(i),r.scale.z=i.length()}}(),hn.prototype=Object.create($e.prototype),hn.prototype.constructor=hn,hn.prototype.update=function(){function t(t,o,a,s){n.set(o,a,s).unproject(r);var c=i[t];if(void 0!==c)for(var u=0,h=c.length;u<h;u++)e.vertices[c[u]].copy(n)}var e,i,n=new N,r=new Me;return function(){e=this.geometry,i=this.pointMap;var n=1,o=1;r.projectionMatrix.copy(this.camera.projectionMatrix),t("c",0,0,-1),t("t",0,0,1),t("n1",-n,-o,-1),t("n2",n,-o,-1),t("n3",-n,o,-1),t("n4",n,o,-1),t("f1",-n,-o,1),t("f2",n,-o,1),t("f3",-n,o,1),t("f4",n,o,1),t("u1",.7*n,1.1*o,-1),t("u2",.7*-n,1.1*o,-1),t("u3",0,2*o,-1),t("cf1",-n,0,1),t("cf2",n,0,1),t("cf3",0,-o,1),t("cf4",0,o,1),t("cn1",-n,0,-1),t("cn2",n,0,-1),t("cn3",0,-o,-1),t("cn4",0,o,-1),e.verticesNeedUpdate=!0}}(),ln.prototype=Object.create($e.prototype),ln.prototype.constructor=ln,ln.prototype.update=function(){var t=new Et;return function(e){if(e&&e.isBox3?t.copy(e):t.setFromObject(e),!t.isEmpty()){var i=t.min,n=t.max,r=this.geometry.attributes.position,o=r.array;o[0]=n.x,o[1]=n.y,o[2]=n.z,o[3]=i.x,o[4]=n.y,o[5]=n.z,o[6]=i.x,o[7]=i.y,o[8]=n.z,o[9]=n.x,o[10]=i.y,o[11]=n.z,o[12]=n.x,o[13]=n.y,o[14]=i.z,o[15]=i.x,o[16]=n.y,o[17]=i.z,o[18]=i.x,o[19]=i.y,o[20]=i.z,o[21]=n.x,o[22]=i.y,o[23]=i.z,r.needsUpdate=!0,this.geometry.computeBoundingSphere()}}}(),dn.prototype=Object.create(ue.prototype),dn.prototype.constructor=dn;var Dp=new ue;Dp.addAttribute("position",new te([0,0,0,0,1,0],3));var Np=new dn(0,.5,1,5,1);Np.translate(0,-.5,0),fn.prototype=Object.create(re.prototype),fn.prototype.constructor=fn,fn.prototype.setDirection=function(){var t,e=new N;return function(i){i.y>.99999?this.quaternion.set(0,0,0,1):i.y<-.99999?this.quaternion.set(1,0,0,0):(e.set(i.z,0,-i.x).normalize(),t=Math.acos(i.y),this.quaternion.setFromAxisAngle(e,t))}}(),fn.prototype.setLength=function(t,e,i){void 0===e&&(e=.2*t),void 0===i&&(i=.2*e),this.line.scale.set(1,Math.max(0,t-e),1),this.line.updateMatrix(),this.cone.scale.set(i,e,i),this.cone.position.y=t,this.cone.updateMatrix()},fn.prototype.setColor=function(t){this.line.material.color.copy(t),this.cone.material.color.copy(t)},pn.prototype=Object.create(ae.prototype),pn.prototype.constructor=pn,mn.prototype=Object.create(pn.prototype),mn.prototype.constructor=mn,gn.prototype=Object.create(ae.prototype),gn.prototype.constructor=gn,vn.prototype=Object.create(ue.prototype),vn.prototype.constructor=vn;(function(){function t(){}var e=new N,i=new t,n=new t,r=new t;return t.prototype.init=function(t,e,i,n){this.c0=t,this.c1=i,this.c2=-3*t+3*e-2*i-n,this.c3=2*t-2*e+i+n},t.prototype.initNonuniformCatmullRom=function(t,e,i,n,r,o,a){var s=(e-t)/r-(i-t)/(r+o)+(i-e)/o,c=(i-e)/o-(n-e)/(o+a)+(n-i)/a;s*=o,c*=o,this.init(e,i,s,c)},t.prototype.initCatmullRom=function(t,e,i,n,r){this.init(e,i,r*(i-t),r*(n-e))},t.prototype.calc=function(t){var e=t*t,i=e*t;return this.c0+this.c1*t+this.c2*e+this.c3*i},Ei.create(function(t){this.points=t||[],this.closed=!1},function(t){var o,a,s,c,u=this.points;c=u.length,c<2&&console.log("duh, you need at least 2 points"),o=(c-(this.closed?0:1))*t,a=Math.floor(o),s=o-a,this.closed?a+=a>0?0:(Math.floor(Math.abs(a)/u.length)+1)*u.length:0===s&&a===c-1&&(a=c-2,s=1);var h,l,d,f;if(this.closed||a>0?h=u[(a-1)%c]:(e.subVectors(u[0],u[1]).add(u[0]),h=e),l=u[a%c],d=u[(a+1)%c],this.closed||a+2<c?f=u[(a+2)%c]:(e.subVectors(u[c-1],u[c-2]).add(u[c-1]),f=e),void 0===this.type||"centripetal"===this.type||"chordal"===this.type){var p="chordal"===this.type?.5:.25,m=Math.pow(h.distanceToSquared(l),p),g=Math.pow(l.distanceToSquared(d),p),v=Math.pow(d.distanceToSquared(f),p);g<1e-4&&(g=1),m<1e-4&&(m=g),v<1e-4&&(v=g),i.initNonuniformCatmullRom(h.x,l.x,d.x,f.x,m,g,v),n.initNonuniformCatmullRom(h.y,l.y,d.y,f.y,m,g,v),r.initNonuniformCatmullRom(h.z,l.z,d.z,f.z,m,g,v)}else if("catmullrom"===this.type){var y=void 0!==this.tension?this.tension:.5;i.initCatmullRom(h.x,l.x,d.x,f.x,y),n.initCatmullRom(h.y,l.y,d.y,f.y,y),r.initCatmullRom(h.z,l.z,d.z,f.z,y)}var b=new N(i.calc(s),n.calc(s),r.calc(s));return b})})(),Ei.create(function(t){console.warn("THREE.SplineCurve3 will be deprecated. Please use THREE.CatmullRomCurve3"),this.points=void 0===t?[]:t},function(t){var e=this.points,i=(e.length-1)*t,n=Math.floor(i),r=i-n,o=e[0==n?n:n-1],a=e[n],s=e[n>e.length-2?e.length-1:n+1],c=e[n>e.length-3?e.length-1:n+2],u=Lp.interpolate;return new N(u(o.x,a.x,s.x,c.x,r),u(o.y,a.y,s.y,c.y,r),u(o.z,a.z,s.z,c.z,r))}),Ei.create(function(t,e,i,n){this.v0=t,this.v1=e,this.v2=i,this.v3=n},function(t){var e=Ip.b3;return new N(e(t,this.v0.x,this.v1.x,this.v2.x,this.v3.x),e(t,this.v0.y,this.v1.y,this.v2.y,this.v3.y),e(t,this.v0.z,this.v1.z,this.v2.z,this.v3.z))}),Ei.create(function(t,e,i){this.v0=t,this.v1=e,this.v2=i},function(t){var e=Ip.b2;return new N(e(t,this.v0.x,this.v1.x,this.v2.x),e(t,this.v0.y,this.v1.y,this.v2.y),e(t,this.v0.z,this.v1.z,this.v2.z))}),Ei.create(function(t,e){this.v1=t,this.v2=e},function(t){if(1===t)return this.v2.clone();var e=new N;return e.subVectors(this.v2,this.v1),e.multiplyScalar(t),e.add(this.v1),e});Object.defineProperty(t,"AudioContext",{get:function(){return t.getAudioContext()}}),yn.prototype={active:!0,params:null,execute:function(t){var e,i;return this.active&&this._listener&&(i=this.params?this.params.concat(t):t,e=this._listener.apply(this.context,i),this._isOnce&&this.detach()),e},detach:function(){return this.isBound()?this._signal.remove(this._listener,this.context):null},isBound:function(){return!!this._signal&&!!this._listener},isOnce:function(){return this._isOnce},getListener:function(){return this._listener},getSignal:function(){return this._signal},_destroy:function(){delete this._signal,delete this._listener,delete this.context},toString:function(){return"[SignalBinding isOnce:"+this._isOnce+", isBound:"+this.isBound()+", active:"+this.active+"]"}},xn.prototype={VERSION:"1.0.0",memorize:!1,_shouldPropagate:!0,active:!0,_registerListener:function(t,e,i,n){var r,o=this._indexOfListener(t,i);if(o!==-1){if(r=this._bindings[o],r.isOnce()!==e)throw new Error("You cannot add"+(e?"":"Once")+"() then add"+(e?"Once":"")+"() the same listener without removing the relationship first.")}else r=new yn(this,t,e,i,n),this._addBinding(r);return this.memorize&&this._prevParams&&r.execute(this._prevParams),r},_addBinding:function(t){var e=this._bindings.length;do--e;while(this._bindings[e]&&t._priority<=this._bindings[e]._priority);this._bindings.splice(e+1,0,t)},_indexOfListener:function(t,e){for(var i,n=this._bindings.length;n--;)if(i=this._bindings[n],i._listener===t&&i.context===e)return n;return-1},has:function(t,e){return this._indexOfListener(t,e)!==-1},add:function(t,e,i){return bn(t,"add"),this._registerListener(t,!1,e,i)},addOnce:function(t,e,i){return bn(t,"addOnce"),this._registerListener(t,!0,e,i)},remove:function(t,e){bn(t,"remove");var i=this._indexOfListener(t,e);return i!==-1&&(this._bindings[i]._destroy(),this._bindings.splice(i,1)),t},removeAll:function(){for(var t=this._bindings.length;t--;)this._bindings[t]._destroy();this._bindings.length=0},getNumListeners:function(){return this._bindings.length},halt:function(){this._shouldPropagate=!1},dispatch:function(t){if(this.active){var e,i=Array.prototype.slice.call(arguments),n=this._bindings.length;if(this.memorize&&(this._prevParams=i),n){e=this._bindings.slice(),this._shouldPropagate=!0;do n--;while(e[n]&&this._shouldPropagate&&e[n].execute(i)!==!1)}}},forget:function(){this._prevParams=null},dispose:function(){this.removeAll(),delete this._bindings,delete this._prevParams},toString:function(){return"[Signal active:"+this.active+" numListeners:"+this.getNumListeners()+"]"}};var kp={PROTEIN:1,NUCLEIC:2,RNA:3,DNA:4,POLYMER:5,WATER:6,HELIX:7,SHEET:8,BACKBONE:9,SIDECHAIN:10,ALL:11,HETERO:12,ION:13,SACCHARIDE:14};_n.prototype={constructor:_n,type:"selection",setString:function(t,e){if(void 0===t&&(t=this.string||""),t!==this.string){try{this.parse(t)}catch(t){this.selection={error:t.message}}this.string=t,this.test=this.makeAtomTest(),this.residueTest=this.makeResidueTest(),this.chainTest=this.makeChainTest(),this.modelTest=this.makeModelTest(),this.atomOnlyTest=this.makeAtomTest(!0),this.residueOnlyTest=this.makeResidueTest(!0),this.chainOnlyTest=this.makeChainTest(!0),this.modelOnlyTest=this.makeModelTest(!0),e||this.signals.stringChanged.dispatch(this.string)}},parse:function(t){if(this.selection={operator:void 0,rules:[]},t){var e,i,n=this,r=this.selection,o=[];t=t.replace(/\(/g," ( ").replace(/\)/g," ) ").trim(),"("===t.charAt(0)&&")"===t.substr(-1)&&(t=t.slice(1,-1).trim());var a,s,c,u,h,l,d,f,p,m,g=t.split(/\s+/),v=["*","","ALL"],y=function(t){e={operator:t,rules:[]},void 0===r?(r=e,n.selection=e):(r.rules.push(e),o.push(r),r=e)},b=function(t){i=r,r=o.pop(),void 0===r&&(y(t),x(i))},x=function(t){r.rules.push(t)};for(c=0;c<g.length;++c)if(a=g[c],"("!==a)if(")"!==a){if(u>0)if("NOT"===a.toUpperCase())u=1;else if(1===u)u=2;else{if(2!==u)throw new Error("something went wrong with 'not'");u=!1,b()}if("AND"!==a.toUpperCase())if("OR"!==a.toUpperCase())if("NOT"!==a.toUpperCase())if(s={},"HETERO"!==a.toUpperCase())if("WATER"!==a.toUpperCase())if("PROTEIN"!==a.toUpperCase())if("NUCLEIC"!==a.toUpperCase())if("RNA"!==a.toUpperCase())if("DNA"!==a.toUpperCase())if("POLYMER"!==a.toUpperCase())if("ION"!==a.toUpperCase())if("SACCHARIDE"!==a.toUpperCase()&&"SUGAR"!==a.toUpperCase())if("HYDROGEN"!==a.toUpperCase())if("SMALL"!==a.toUpperCase())if("NUCLEOPHILIC"!==a.toUpperCase())if("HYDROPHOBIC"!==a.toUpperCase())if("AROMATIC"!==a.toUpperCase())if("AMIDE"!==a.toUpperCase())if("ACIDIC"!==a.toUpperCase())if("BASIC"!==a.toUpperCase())if("CHARGED"!==a.toUpperCase())if("POLAR"!==a.toUpperCase())if("NONPOLAR"!==a.toUpperCase())if("HELIX"!==a.toUpperCase())if("SHEET"!==a.toUpperCase())if("TURN"!==a.toUpperCase())if("BACKBONE"!==a.toUpperCase())if("SIDECHAIN"!==a.toUpperCase())if("SIDECHAINATTACHED"!==a.toUpperCase())if(v.indexOf(a.toUpperCase())===-1)if("@"!==a.charAt(0))if("#"!==a.charAt(0))if("["!==a[0]||"]"!==a[a.length-1])if(a.length>=1&&a.length<=4&&"^"!==a[0]&&":"!==a[0]&&"."!==a[0]&&"%"!==a[0]&&"/"!==a[0]&&isNaN(parseInt(a)))s.resname=a.toUpperCase(),x(s);else{if(s={operator:"AND",rules:[]},d=a.split("/"),d.length>1&&d[1]){if(isNaN(parseInt(d[1])))throw new Error("model must be an integer");s.rules.push({model:parseInt(d[1])})}if(p=d[0].split("%"),p.length>1&&s.rules.push({altloc:p[1]}),h=p[0].split("."),h.length>1&&h[1]){if(h[1].length>4)throw new Error("atomname must be one to four characters");s.rules.push({atomname:h[1].substring(0,4).toUpperCase()})}if(l=h[0].split(":"),l.length>1&&l[1]&&s.rules.push({chainname:l[1]}),m=l[0].split("^"),m.length>1&&s.rules.push({inscode:m[1]}),m[0]){var _,w;if("-"===m[0][0]&&(m[0]=m[0].substr(1),_=!0),m[0].includes("--")&&(m[0]=m[0].replace("--","-"),w=!0),f=m[0].split("-"),1===f.length){if(f=parseInt(f[0]),isNaN(f))throw new Error("resi must be an integer");_&&(f*=-1),s.rules.push({resno:f})}else{if(2!==f.length)throw new Error("resi range must contain one '-'");_&&(f[0]*=-1),w&&(f[1]*=-1),s.rules.push({resno:[parseInt(f[0]),parseInt(f[1])]})}}if(1===s.rules.length)x(s.rules[0]);else{if(!(s.rules.length>1))throw new Error("empty selection chunk");x(s)}}else s.resname=a.substr(1,a.length-2).toUpperCase(),x(s);else s.element=a.substr(1).toUpperCase(),x(s);else{for(var S=a.substr(1).split(","),A=0,M=S.length;A<M;++A)S[A]=parseInt(S[A]);S.sort(function(t,e){return t-e}),s.atomindex=S,s.atomindexFirst=S[0],s.atomindexLast=S[S.length-1],x(s)}else s.keyword=kp.ALL,x(s);else s={operator:"OR",rules:[{keyword:kp.SIDECHAIN},{operator:"AND",negate:!1,rules:[{keyword:kp.PROTEIN},{operator:"OR",negate:!1,rules:[{atomname:"CA"},{atomname:"BB"}]}]},{operator:"AND",negate:!1,rules:[{resname:"PRO"},{atomname:"N"}]},{operator:"AND",negate:!1,rules:[{keyword:kp.NUCLEIC},{operator:"OR",negate:!0,rules:[{atomname:"P"},{atomname:"OP1"},{atomname:"OP2"},{atomname:"O3'"},{atomname:"O3*"},{atomname:"O5'"},{atomname:"O5*"},{atomname:"C5'"},{atomname:"C5*"}]}]}]},x(s);else s.keyword=kp.SIDECHAIN,x(s);else s.keyword=kp.BACKBONE,x(s);else s={operator:"AND",rules:[{operator:"OR",negate:!0,rules:[{keyword:kp.HELIX},{keyword:kp.SHEET}]},{operator:"OR",rules:[{keyword:kp.PROTEIN},{sstruc:"s"},{sstruc:"t"},{sstruc:"l"}]}]},x(s);else s.keyword=kp.SHEET,x(s);else s.keyword=kp.HELIX,x(s);else s={operator:"OR",rules:[{resname:"ALA"},{resname:"CYS"},{resname:"GLY"},{resname:"ILE"},{resname:"LEU"},{resname:"MET"},{resname:"PHE"},{resname:"PRO"},{resname:"VAL"},{resname:"TRP"}]},x(s);else s={operator:"OR",rules:[{resname:"ASP"},{resname:"GLU"},{resname:"HIS"},{resname:"LYS"},{resname:"ARG"},{resname:"ASN"},{resname:"GLN"},{resname:"SER"},{resname:"THR"},{resname:"TYR"}]},x(s);else s={operator:"OR",rules:[{resname:"ASP"},{resname:"GLU"},{resname:"HIS"},{resname:"LYS"},{resname:"ARG"}]},x(s);else s={operator:"OR",rules:[{resname:"HIS"},{resname:"LYS"},{resname:"ARG"}]},x(s);else s={operator:"OR",rules:[{resname:"ASP"},{resname:"GLU"}]},x(s);else s={operator:"OR",rules:[{resname:"ASN"},{resname:"GLN"}]},x(s);else s={operator:"OR",rules:[{resname:"PHE"},{resname:"TYR"},{resname:"TRP"}]},x(s);else s={operator:"OR",rules:[{resname:"VAL"},{resname:"LEU"},{resname:"ILE"},{resname:"MET"},{resname:"PRO"}]},x(s);else s={operator:"OR",rules:[{resname:"SER"},{resname:"THR"},{resname:"CYS"}]},x(s);else s={operator:"OR",rules:[{resname:"GLY"},{resname:"ALA"}]},x(s);else s.element="H",x(s);else s.keyword=kp.SACCHARIDE,x(s);else s.keyword=kp.ION,x(s);else s.keyword=kp.POLYMER,x(s);else s.keyword=kp.DNA,x(s);else s.keyword=kp.RNA,x(s);else s.keyword=kp.NUCLEIC,x(s);else s.keyword=kp.PROTEIN,x(s);else s.keyword=kp.WATER,x(s);else s.keyword=kp.HETERO,x(s);else u=1,y(),r.negate=!0;else"AND"===r.operator?b("OR"):r.operator="OR";else if("OR"===r.operator){var C=r.rules.pop();y("AND"),x(C)}else r.operator="AND"}else b(),r.negate&&b();else u=!1,y();void 0===this.selection.operator&&1===this.selection.rules.length&&this.selection.rules[0].hasOwnProperty("operator")&&(this.selection=this.selection.rules[0])}},_makeTest:function(t,e){if(void 0===e&&(e=this.selection),null===e)return!1;if(e.error)return!1;var i=e.rules.length;if(0===i)return!1;for(var n,r,o,a,s=!e.negate,c=!!e.negate,u=[],h=0;h<i;++h)n=e.rules[h],n.hasOwnProperty("operator")&&(u[h]=this._makeTest(t,n));return function(h){r="AND"===e.operator,a=!1;for(var l=0;l<i;++l)if(n=e.rules[l],n.hasOwnProperty("operator")){if(o=u[l]?u[l](h):-1,o===-1){a=!0;continue}if(o===!0){if(r)continue;return s}if(r)return c}else{if(n.keyword===kp.ALL){if(r)continue;return s}if(o=t(h,n),o!==-1){if(o===!0){if(r)continue;return s}if(r)return c}else a=!0}return a?-1:r?s:c}},_filter:function(t,e){if(void 0===e&&(e=this.selection),e.error)return e;var i=e.rules.length;if(0===i)return e;var n={operator:e.operator,rules:[]};e.hasOwnProperty("negate")&&(n.negate=e.negate);for(var r=0;r<i;++r){var o=e.rules[r];if(o.hasOwnProperty("operator")){var a=this._filter(t,o);null!==a&&n.rules.push(a)}else t(o)||n.rules.push(o)}return n.rules.length>0?e:null},makeAtomTest:function(t){var e,i=["h","g","i"],n=["e","b"];e=t?this._filter(function(t){return void 0!==t.keyword&&t.keyword!==kp.BACKBONE&&t.keyword!==kp.SIDECHAIN||(void 0!==t.model||(void 0!==t.chainname||(void 0!==t.resname||(void 0!==t.resno||void 0!==t.sstruc))))}):this.selection;var r=function(t,e){if(void 0===e.atomname&&void 0===e.element&&void 0===e.altloc&&void 0===e.atomindex&&void 0===e.keyword&&void 0===e.inscode&&void 0===e.resname&&void 0===e.sstruc&&void 0===e.resno&&void 0===e.chainname&&void 0===e.model)return-1;if(void 0!==e.keyword){if(e.keyword===kp.BACKBONE&&!t.isBackbone())return!1;if(e.keyword===kp.SIDECHAIN&&!t.isSidechain())return!1;if(e.keyword===kp.HETERO&&!t.isHetero())return!1;if(e.keyword===kp.PROTEIN&&!t.isProtein())return!1;if(e.keyword===kp.NUCLEIC&&!t.isNucleic())return!1;if(e.keyword===kp.RNA&&!t.isRna())return!1;if(e.keyword===kp.DNA&&!t.isDna())return!1;if(e.keyword===kp.POLYMER&&!t.isPolymer())return!1;if(e.keyword===kp.WATER&&!t.isWater())return!1;if(e.keyword===kp.HELIX&&i.indexOf(t.sstruc)===-1)return!1;if(e.keyword===kp.SHEET&&n.indexOf(t.sstruc)===-1)return!1;if(e.keyword===kp.ION&&!t.isIon())return!1;if(e.keyword===kp.SACCHARIDE&&!t.isSaccharide())return!1}if(void 0!==e.atomname&&e.atomname!==t.atomname)return!1;if(void 0!==e.element&&e.element!==t.element)return!1;if(void 0!==e.altloc&&e.altloc!==t.altloc)return!1;if(void 0!==e.atomindex&&th(e.atomindex,t.index)<0)return!1;if(void 0!==e.resname&&e.resname!==t.resname)return!1;if(void 0!==e.sstruc&&e.sstruc!==t.sstruc)return!1;if(void 0!==e.resno)if(Array.isArray(e.resno)&&2===e.resno.length){if(e.resno[0]>t.resno||e.resno[1]<t.resno)return!1}else if(e.resno!==t.resno)return!1;return(void 0===e.inscode||e.inscode===t.inscode)&&((void 0===e.chainname||e.chainname===t.chainname)&&(void 0===e.model||e.model===t.modelIndex))};return this._makeTest(r,e)},makeResidueTest:function(t){var e,i=["h","g","i"],n=["e","b"];e=t?this._filter(function(t){return t.keyword===kp.BACKBONE||t.keyword===kp.SIDECHAIN||(void 0!==t.model||(void 0!==t.chainname||(void 0!==t.atomname||(void 0!==t.element||void 0!==t.altloc))))}):this.selection;var r=function(t,e){if(void 0===e.resname&&void 0===e.resno&&void 0===e.inscode&&void 0===e.sstruc&&void 0===e.model&&void 0===e.chainname&&void 0===e.atomindex&&(void 0===e.keyword||e.keyword===kp.BACKBONE||e.keyword===kp.SIDECHAIN))return-1;if(void 0!==e.keyword){if(e.keyword===kp.HETERO&&!t.isHetero())return!1;if(e.keyword===kp.PROTEIN&&!t.isProtein())return!1;if(e.keyword===kp.NUCLEIC&&!t.isNucleic())return!1;if(e.keyword===kp.RNA&&!t.isRna())return!1;if(e.keyword===kp.DNA&&!t.isDna())return!1;if(e.keyword===kp.POLYMER&&!t.isPolymer())return!1;if(e.keyword===kp.WATER&&!t.isWater())return!1;if(e.keyword===kp.HELIX&&i.indexOf(t.sstruc)===-1)return!1;if(e.keyword===kp.SHEET&&n.indexOf(t.sstruc)===-1)return!1;if(e.keyword===kp.ION&&!t.isIon())return!1;if(e.keyword===kp.SACCHARIDE&&!t.isSaccharide())return!1}if(void 0!==e.atomindex&&(t.atomOffset>e.atomindexLast||t.atomEnd<e.atomindexFirst))return!1;if(void 0!==e.resname&&e.resname!==t.resname)return!1;if(void 0!==e.sstruc&&e.sstruc!==t.sstruc)return!1;if(void 0!==e.resno)if(Array.isArray(e.resno)&&2===e.resno.length){if(e.resno[0]>t.resno||e.resno[1]<t.resno)return!1}else if(e.resno!==t.resno)return!1;return(void 0===e.inscode||e.inscode===t.inscode)&&((void 0===e.chainname||e.chainname===t.chainname)&&(void 0===e.model||e.model===t.modelIndex))};return this._makeTest(r,e)},makeChainTest:function(t){var e;e=t?this._filter(function(t){return void 0!==t.keyword||(void 0!==t.resname||(void 0!==t.resno||(void 0!==t.atomname||(void 0!==t.element||(void 0!==t.altloc||(void 0!==t.sstruc||void 0!==t.inscode))))))}):this.selection;var i=function(t,e){return void 0===e.chainname&&void 0===e.model&&void 0===e.atomindex?-1:(void 0===e.atomindex||!(t.atomOffset>e.atomindexLast||t.atomEnd<e.atomindexFirst))&&((void 0===e.chainname||e.chainname===t.chainname)&&(void 0===e.model||e.model===t.modelIndex))};return this._makeTest(i,e)},makeModelTest:function(t){var e;e=t?this._filter(function(t){return void 0!==t.keyword||(void 0!==t.chainname||(void 0!==t.resname||(void 0!==t.resno||(void 0!==t.atomname||(void 0!==t.element||(void 0!==t.altloc||(void 0!==t.sstruc||void 0!==t.inscode)))))))}):this.selection;var i=function(t,e){return void 0===e.model&&void 0===e.atomindex?-1:(void 0===e.atomindex||!(t.atomOffset>e.atomindexLast||t.atomEnd<e.atomindexFirst))&&(void 0===e.model||e.model===t.index)};return this._makeTest(i,e)}};var Fp=function(){var t,e="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".split(""),i=new Array(36),n=0;return function(){for(var r=0;r<36;r++)8===r||13===r||18===r||23===r?i[r]="-":14===r?i[r]="4":(n<=2&&(n=33554432+16777216*Math.random()|0),t=15&n,n>>=4,i[r]=e[19===r?3&t|8:t]);return i.join("")}}(),zp=0,Bp=1,Up=2,jp=3,$p=4,Vp=0,Gp=1,Hp=2,Wp=3,Xp=4,qp=5,Yp=6,Zp=0,Kp=1,Qp=2,Jp=3,tm=4,em=5,im=6,nm=["D-BETA-PEPTIDE, C-GAMMA LINKING","D-GAMMA-PEPTIDE, C-DELTA LINKING","D-PEPTIDE COOH CARBOXY TERMINUS","D-PEPTIDE NH3 AMINO TERMINUS","D-PEPTIDE LINKING","L-BETA-PEPTIDE, C-GAMMA LINKING","L-GAMMA-PEPTIDE, C-DELTA LINKING","L-PEPTIDE COOH CARBOXY TERMINUS","L-PEPTIDE NH3 AMINO TERMINUS","L-PEPTIDE LINKING","PEPTIDE LINKING","PEPTIDE-LIKE"],rm=["RNA OH 3 PRIME TERMINUS","RNA OH 5 PRIME TERMINUS","RNA LINKING"],om=["DNA OH 3 PRIME TERMINUS","DNA OH 5 PRIME TERMINUS","DNA LINKING","L-DNA LINKING","L-RNA LINKING"],am=["D-SACCHARIDE","D-SACCHARIDE 1,4 AND 1,4 LINKING","D-SACCHARIDE 1,4 AND 1,6 LINKING","L-SACCHARIDE","L-SACCHARIDE 1,4 AND 1,4 LINKING","L-SACCHARIDE 1,4 AND 1,6 LINKING","SACCHARIDE"],sm=["OTHER"],cm=["NON-POLYMER"],um=cm.concat(sm,am),hm={H:1.1,HE:1.4,LI:1.81,BE:1.53,B:1.92,C:1.7,N:1.55,O:1.52,F:1.47,NE:1.54,NA:2.27,MG:1.73,
	AL:1.84,SI:2.1,P:1.8,S:1.8,CL:1.75,AR:1.88,K:2.75,CA:2.31,SC:2.3,TI:2.15,V:2.05,CR:2.05,MN:2.05,FE:2.05,CO:2,NI:2,CU:2,ZN:2.1,GA:1.87,GE:2.11,AS:1.85,SE:1.9,BR:1.83,KR:2.02,RB:3.03,SR:2.49,Y:2.4,ZR:2.3,NB:2.15,MO:2.1,TC:2.05,RU:2.05,RH:2,PD:2.05,AG:2.1,CD:2.2,IN:2.2,SN:1.93,SB:2.17,TE:2.06,I:1.98,XE:2.16,CS:3.43,BA:2.68,LA:2.5,CE:2.48,PR:2.47,ND:2.45,PM:2.43,SM:2.42,EU:2.4,GD:2.38,TB:2.37,DY:2.35,HO:2.33,ER:2.32,TM:2.3,YB:2.28,LU:2.27,HF:2.25,TA:2.2,W:2.1,RE:2.05,OS:2,IR:2,PT:2.05,AU:2.1,HG:2.05,TL:1.96,PB:2.02,BI:2.07,PO:1.97,AT:2.02,RN:2.2,FR:3.48,RA:2.83,AC:2,TH:2.4,PA:2,U:2.3,NP:2,PU:2,AM:2,CM:2,BK:2,CF:2,ES:2,FM:2,MD:2,NO:2,LR:2,RF:2,DB:2,SG:2,BH:2,HS:2,MT:2,DS:2,RG:2,CN:2,UUT:2,FL:2,UUP:2,LV:2,UUH:2},lm=2,dm={H:.31,HE:.28,LI:1.28,BE:.96,B:.84,C:.76,N:.71,O:.66,F:.57,NE:.58,NA:1.66,MG:1.41,AL:1.21,SI:1.11,P:1.07,S:1.05,CL:1.02,AR:1.06,K:2.03,CA:1.76,SC:1.7,TI:1.6,V:1.53,CR:1.39,MN:1.39,FE:1.32,CO:1.26,NI:1.24,CU:1.32,ZN:1.22,GA:1.22,GE:1.2,AS:1.19,SE:1.2,BR:1.2,KR:1.16,RB:2.2,SR:1.95,Y:1.9,ZR:1.75,NB:1.64,MO:1.54,TC:1.47,RU:1.46,RH:1.42,PD:1.39,AG:1.45,CD:1.44,IN:1.42,SN:1.39,SB:1.39,TE:1.38,I:1.39,XE:1.4,CS:2.44,BA:2.15,LA:2.07,CE:2.04,PR:2.03,ND:2.01,PM:1.99,SM:1.98,EU:1.98,GD:1.96,TB:1.94,DY:1.92,HO:1.92,ER:1.89,TM:1.9,YB:1.87,LU:1.87,HF:1.75,TA:1.7,W:1.62,RE:1.51,OS:1.44,IR:1.41,PT:1.36,AU:1.36,HG:1.32,TL:1.45,PB:1.46,BI:1.48,PO:1.4,AT:1.5,RN:1.5,FR:2.6,RA:2.21,AC:2.15,TH:2.06,PA:2,U:1.96,NP:1.9,PU:1.87,AM:1.8,CM:1.69,BK:1.6,CF:1.6,ES:1.6,FM:1.6,MD:1.6,NO:1.6,LR:1.6,RF:1.6,DB:1.6,SG:1.6,BH:1.6,HS:1.6,MT:1.6,DS:1.6,RG:1.6,CN:1.6,UUT:1.6,FL:1.6,UUP:1.6,LV:1.6,UUH:1.6},fm=1.6,pm={ALA:[.17,.5,.33],ARG:[.81,1.81,1],ASN:[.42,.85,.43],ASP:[1.23,3.64,2.41],ASH:[-.07,.43,.5],CYS:[-.24,-.02,.22],GLN:[.58,.77,.19],GLU:[2.02,3.63,1.61],GLH:[-.01,.11,.12],GLY:[.01,1.15,1.14],HIS:[.17,.11,-.06],ILE:[-.31,-1.12,-.81],LEU:[-.56,-1.25,-.69],LYS:[.99,2.8,1.81],MET:[-.23,-.67,-.44],PHE:[-1.13,-1.71,-.58],PRO:[.45,.14,-.31],SER:[.13,.46,.33],THR:[.14,.25,.11],TRP:[-1.85,-2.09,-.24],TYR:[-.94,-.71,.23],VAL:[.07,-.46,-.53]},mm=[0,0,0],gm={HIS:"H",ARG:"R",LYS:"K",ILE:"I",PHE:"F",LEU:"L",TRP:"W",ALA:"A",MET:"M",PRO:"P",CYS:"C",ASN:"N",VAL:"V",GLY:"G",SER:"S",GLN:"Q",TYR:"Y",ASP:"D",GLU:"E",THR:"T",ASH:"D",GLH:"E",UNK:""},vm=Object.keys(gm),ym=["A","C","T","G","U"],bm=["DA","DC","DT","DG","DU","TCY","MCY","5CM"],xm=["A","G","DA","DG"],_m=["SOL","WAT","HOH","H2O","W","DOD","D3O","TIP3","TIP4"],wm=["118","119","1AL","1CU","2FK","2HP","2OF","3CO","3MT","3NI","3OF","3P8","4MO","4PU","543","6MO","ACT","AG","AL","ALF","AM","ATH","AU","AU3","AUC","AZI","BA","BCT","BEF","BF4","BO4","BR","BS3","BSY","CA","CAC","CD","CD1","CD3","CD5","CE","CHT","CL","CO","CO3","CO5","CON","CR","CS","CSB","CU","CU1","CU3","CUA","CUZ","CYN","DME","DMI","DSC","DTI","DY","E4N","EDR","EMC","ER3","EU","EU3","F","FE","FE2","FPO","GA","GD3","GEP","HAI","HG","HGC","IN","IOD","IR","IR3","IRI","IUM","K","KO4","LA","LCO","LCP","LI","LU","MAC","MG","MH2","MH3","MLI","MLT","MMC","MN","MN3","MN5","MN6","MO1","MO2","MO3","MO4","MO5","MO6","MOO","MOS","MOW","MW1","MW2","MW3","NA","NA2","NA5","NA6","NAO","NAW","NCO","NET","NH4","NI","NI1","NI2","NI3","NO2","NO3","NRU","O4M","OAA","OC1","OC2","OC3","OC4","OC5","OC6","OC7","OC8","OCL","OCM","OCN","OCO","OF1","OF2","OF3","OH","OS","OS4","OXL","PB","PBM","PD","PDV","PER","PI","PO3","PO4","PR","PT","PT4","PTN","RB","RH3","RHD","RU","SB","SCN","SE4","SEK","SM","SMO","SO3","SO4","SR","T1A","TB","TBA","TCN","TEA","TH","THE","TL","TMA","TRA","UNX","V","VN3","VO4","W","WO5","Y1","YB","YB2","YH","YT3","ZCM","ZN","ZN2","ZN3","ZNO","ZO3"],Sm=["045","0AT","0BD","0MK","0NZ","0TS","0V4","0XY","0YT","10M","147","149","14T","15L","16G","18T","18Y","1AR","1BW","1GL","1GN","1JB","1LL","1NA","1S3","26M","26Q","26R","26V","26W","26Y","27C","289","291","293","2DG","2F8","2FG","2FL","2FP","2GL","2M4","2M5","32O","34V","3CM","3DO","3DY","3FM","3LR","3MF","3MG","3SA","3ZW","46D","46M","46Z","48Z","4CQ","4GC","4NN","50A","5DI","5GF","5MM","5RP","5SA","5SP","64K","6PG","6SA","7JZ","7SA","A1Q","A2G","AAB","AAL","AAO","ABC","ABD","ABE","ABF","ABL","ACG","ACI","ACR","ACX","ADA","ADG","ADR","AF1","AFD","AFL","AFO","AFP","AFR","AGC","AGH","AGL","AHR","AIG","ALL","ALX","AMU","AOG","AOS","ARA","ARB","ARE","ARI","ASG","ASO","AXP","AXR","B0D","B16","B2G","B4G","B6D","B8D","B9D","BBK","BCD","BDG","BDP","BDR","BEM","BFP","BGC","BGL","BGP","BGS","BHG","BMA","BMX","BNG","BNX","BOG","BRI","BXF","BXP","BXX","BXY","C3X","C4X","C5X","CAP","CBI","CBK","CBS","CDR","CEG","CGF","CHO","CR1","CR6","CRA","CT3","CTO","CTR","CTT","D6G","DAF","DAG","DDA","DDB","DDL","DEL","DFR","DFX","DG0","DGC","DGD","DGM","DGS","DIG","DLF","DLG","DMU","DNO","DOM","DP5","DQQ","DQR","DR2","DR3","DR4","DRI","DSR","DT6","DVC","E4P","E5G","EAG","EBG","EBQ","EGA","EJT","EPG","ERE","ERI","F1P","F1X","F6P","FBP","FCA","FCB","FCT","FDP","FDQ","FFC","FIX","FMO","FRU","FSI","FU4","FUB","FUC","FUD","FUL","FXP","G16","G1P","G2F","G3I","G4D","G4S","G6D","G6P","G6S","GAC","GAD","GAL","GC1","GC4","GCD","GCN","GCO","GCS","GCT","GCU","GCV","GCW","GCX","GE1","GFG","GFP","GIV","GL0","GL2","GL5","GL6","GL7","GL9","GLA","GLB","GLC","GLD","GLF","GLG","GLO","GLP","GLS","GLT","GLW","GMH","GN1","GNX","GP1","GP4","GPH","GPM","GQ1","GQ2","GQ4","GS1","GS4","GSA","GSD","GTE","GTH","GTK","GTR","GTZ","GU0","GU1","GU2","GU3","GU4","GU5","GU6","GU8","GU9","GUF","GUP","GUZ","GYP","GYV","H2P","HDL","HMS","HS2","HSD","HSG","HSH","HSJ","HSQ","HSR","HSU","HSX","HSY","HSZ","IAB","IDG","IDR","IDS","IDT","IDU","IDX","IDY","IMK","IN1","IPT","ISL","KBG","KD2","KDA","KDM","KDO","KFN","KO1","KO2","KTU","L6S","LAG","LAI","LAK","LAO","LAT","LB2","LBT","LCN","LDY","LGC","LGU","LM2","LMT","LMU","LOG","LOX","LPK","LSM","LTM","LVZ","LXB","LXZ","M1F","M3M","M6P","M8C","MA1","MA2","MA3","MAB","MAG","MAL","MAN","MAT","MAV","MAW","MBG","MCU","MDA","MDM","MDP","MFA","MFB","MFU","MG5","MGA","MGL","MLB","MMA","MMN","MN0","MRP","MTT","MUG","MVP","MXY","N1L","N9S","NAA","NAG","NBG","NDG","NED","NG1","NG6","NGA","NGB","NGC","NGE","NGF","NGL","NGS","NGY","NHF","NM6","NM9","NTF","NTO","NTP","NXD","NYT","OPG","OPM","ORP","OX2","P3M","P53","P6P","PA5","PNA","PNG","PNW","PRP","PSJ","PSV","PTQ","QDK","QPS","QV4","R1P","R1X","R2B","R5P","RAA","RAE","RAF","RAM","RAO","RAT","RB5","RBL","RCD","RDP","REL","RER","RF5","RG1","RGG","RHA","RIB","RIP","RNS","RNT","ROB","ROR","RPA","RST","RUB","RUU","RZM","S6P","S7P","SA0","SCR","SDD","SF6","SF9","SG4","SG5","SG6","SG7","SGA","SGC","SGD","SGN","SGS","SHB","SHG","SI3","SIO","SOE","SOL","SSG","SUC","SUP","SUS","T6P","T6T","TAG","TCB","TDG","TGK","TGY","TH1","TIA","TM5","TM6","TM9","TMR","TMX","TOA","TOC","TRE","TYV","UCD","UDC","VG1","X0X","X1X","X2F","X4S","X5S","X6X","XBP","XDN","XDP","XIF","XIM","XLF","XLS","XMM","XUL","XXR","XYP","XYS","YO5","Z3Q","Z6J","Z9M","ZDC","ZDM"],Am=["CA","C","N","O","O1","O2","OC1","OC2","OX1","OXT","H","H1","H2","H3","HA","BB"],Mm=["P","O3'","O5'","C5'","C4'","C3'","OP1","OP2","O3*","O5*","C5*","C4*","C3*"],Cm={};Cm[Kp]={trace:"CA",direction1:"C",direction2:["O","OC1","O1","OX1","OXT"],backboneStart:"N",backboneEnd:"C"},Cm[Qp]={trace:["C4'","C4*"],direction1:["C1'","C1*"],direction2:["C3'","C3*"],backboneStart:"P",backboneEnd:["O3'","O3*"]},Cm[Jp]={trace:["C3'","C3*"],direction1:["C2'","C2*"],direction2:["O4'","O4*"],backboneStart:"P",backboneEnd:["O3'","O3*"]},Cm[tm]={trace:["CA","BB"],backboneStart:["CA","BB"],backboneEnd:["CA","BB"]},Cm[em]={trace:["C4'","C4*","P"],backboneStart:["C4'","C4*","P"],backboneEnd:["C4'","C4*","P"]},Cm[im]={trace:["C3'","C3*","C2'","P"],backboneStart:["C3'","C3*","C2'","P"],backboneEnd:["C3'","C3*","C2'","P"]},Cm[Zp]={};var Pm,Tm,Em,Im,Lm,Rm,Om,Dm,Nm,km,Fm,zm,Bm,Um,jm,$m,Vm,Gm,Hm,Wm,Xm,qm,Ym,Zm,Km,Qm,Jm,tg,eg,ig,ng,rg,og,ag,sg,cg,ug,hg,lg,dg,fg,pg,mg,gg,vg,yg,bg,xg,_g,wg,Sg,Ag,Mg,Cg,Pg,Tg,Eg,Ig,Lg,Rg,Og,Dg,Ng,kg,Fg,zg,Bg,Ug,jg,$g,Vg,Gg,Hg,Wg,Xg,qg,Yg,Zg,Kg=[].slice;Wg=function(){var t,e,i,n,r;for(t={},r="Boolean Number String Function Array Date RegExp Undefined Null".split(" "),n=0,e=r.length;n<e;n++)i=r[n],t["[object "+i+"]"]=i.toLowerCase();return function(e){var i;return i=Object.prototype.toString.call(e),t[i]||"object"}}(),vg=function(t,e,i){return null==e&&(e=0),null==i&&(i=1),t<e&&(t=e),t>i&&(t=i),t},Xg=function(t){return t.length>=3?[].slice.call(t):t[0]},Wm=function(t){var e;for(e in t)e<3?(t[e]<0&&(t[e]=0),t[e]>255&&(t[e]=255)):3===e&&(t[e]<0&&(t[e]=0),t[e]>1&&(t[e]=1));return t},Im=Math.PI,jg=Math.round,Ym=Math.cos,tg=Math.floor,Cg=Math.pow,yg=Math.log,Vg=Math.sin,Gg=Math.sqrt,Bm=Math.atan2,_g=Math.max,zm=Math.abs,Om=2*Im,Lm=Im/3,Tm=Im/180,Rm=180/Im,Hm=function(){return arguments[0]instanceof Pm?arguments[0]:function(t,e,i){i.prototype=t.prototype;var n=new i,r=t.apply(n,e);return Object(r)===r?r:n}(Pm,arguments,function(){})},Fm=[],Hm.version="1.1.1",km={},Dm=[],Nm=!1,Pm=function(){function t(){var t,e,i,n,r,o,a,s,c;for(o=this,e=[],s=0,n=arguments.length;s<n;s++)t=arguments[s],null!=t&&e.push(t);if(a=e[e.length-1],null!=km[a])o._rgb=Wm(km[a](Xg(e.slice(0,-1))));else{for(Nm||(Dm=Dm.sort(function(t,e){return e.p-t.p}),Nm=!0),c=0,r=Dm.length;c<r&&(i=Dm[c],!(a=i.test.apply(i,e)));c++);a&&(o._rgb=Wm(km[a].apply(km,e)))}null==o._rgb&&console.warn("unknown format: "+e),null==o._rgb&&(o._rgb=[0,0,0]),3===o._rgb.length&&o._rgb.push(1)}return t.prototype.alpha=function(t){return arguments.length?(this._rgb[3]=t,this):this._rgb[3]},t.prototype.toString=function(){return this.name()},t}(),Hm._input=km,Hm.brewer=Vm={OrRd:["#fff7ec","#fee8c8","#fdd49e","#fdbb84","#fc8d59","#ef6548","#d7301f","#b30000","#7f0000"],PuBu:["#fff7fb","#ece7f2","#d0d1e6","#a6bddb","#74a9cf","#3690c0","#0570b0","#045a8d","#023858"],BuPu:["#f7fcfd","#e0ecf4","#bfd3e6","#9ebcda","#8c96c6","#8c6bb1","#88419d","#810f7c","#4d004b"],Oranges:["#fff5eb","#fee6ce","#fdd0a2","#fdae6b","#fd8d3c","#f16913","#d94801","#a63603","#7f2704"],BuGn:["#f7fcfd","#e5f5f9","#ccece6","#99d8c9","#66c2a4","#41ae76","#238b45","#006d2c","#00441b"],YlOrBr:["#ffffe5","#fff7bc","#fee391","#fec44f","#fe9929","#ec7014","#cc4c02","#993404","#662506"],YlGn:["#ffffe5","#f7fcb9","#d9f0a3","#addd8e","#78c679","#41ab5d","#238443","#006837","#004529"],Reds:["#fff5f0","#fee0d2","#fcbba1","#fc9272","#fb6a4a","#ef3b2c","#cb181d","#a50f15","#67000d"],RdPu:["#fff7f3","#fde0dd","#fcc5c0","#fa9fb5","#f768a1","#dd3497","#ae017e","#7a0177","#49006a"],Greens:["#f7fcf5","#e5f5e0","#c7e9c0","#a1d99b","#74c476","#41ab5d","#238b45","#006d2c","#00441b"],YlGnBu:["#ffffd9","#edf8b1","#c7e9b4","#7fcdbb","#41b6c4","#1d91c0","#225ea8","#253494","#081d58"],Purples:["#fcfbfd","#efedf5","#dadaeb","#bcbddc","#9e9ac8","#807dba","#6a51a3","#54278f","#3f007d"],GnBu:["#f7fcf0","#e0f3db","#ccebc5","#a8ddb5","#7bccc4","#4eb3d3","#2b8cbe","#0868ac","#084081"],Greys:["#ffffff","#f0f0f0","#d9d9d9","#bdbdbd","#969696","#737373","#525252","#252525","#000000"],YlOrRd:["#ffffcc","#ffeda0","#fed976","#feb24c","#fd8d3c","#fc4e2a","#e31a1c","#bd0026","#800026"],PuRd:["#f7f4f9","#e7e1ef","#d4b9da","#c994c7","#df65b0","#e7298a","#ce1256","#980043","#67001f"],Blues:["#f7fbff","#deebf7","#c6dbef","#9ecae1","#6baed6","#4292c6","#2171b5","#08519c","#08306b"],PuBuGn:["#fff7fb","#ece2f0","#d0d1e6","#a6bddb","#67a9cf","#3690c0","#02818a","#016c59","#014636"],Spectral:["#9e0142","#d53e4f","#f46d43","#fdae61","#fee08b","#ffffbf","#e6f598","#abdda4","#66c2a5","#3288bd","#5e4fa2"],RdYlGn:["#a50026","#d73027","#f46d43","#fdae61","#fee08b","#ffffbf","#d9ef8b","#a6d96a","#66bd63","#1a9850","#006837"],RdBu:["#67001f","#b2182b","#d6604d","#f4a582","#fddbc7","#f7f7f7","#d1e5f0","#92c5de","#4393c3","#2166ac","#053061"],PiYG:["#8e0152","#c51b7d","#de77ae","#f1b6da","#fde0ef","#f7f7f7","#e6f5d0","#b8e186","#7fbc41","#4d9221","#276419"],PRGn:["#40004b","#762a83","#9970ab","#c2a5cf","#e7d4e8","#f7f7f7","#d9f0d3","#a6dba0","#5aae61","#1b7837","#00441b"],RdYlBu:["#a50026","#d73027","#f46d43","#fdae61","#fee090","#ffffbf","#e0f3f8","#abd9e9","#74add1","#4575b4","#313695"],BrBG:["#543005","#8c510a","#bf812d","#dfc27d","#f6e8c3","#f5f5f5","#c7eae5","#80cdc1","#35978f","#01665e","#003c30"],RdGy:["#67001f","#b2182b","#d6604d","#f4a582","#fddbc7","#ffffff","#e0e0e0","#bababa","#878787","#4d4d4d","#1a1a1a"],PuOr:["#7f3b08","#b35806","#e08214","#fdb863","#fee0b6","#f7f7f7","#d8daeb","#b2abd2","#8073ac","#542788","#2d004b"],Set2:["#66c2a5","#fc8d62","#8da0cb","#e78ac3","#a6d854","#ffd92f","#e5c494","#b3b3b3"],Accent:["#7fc97f","#beaed4","#fdc086","#ffff99","#386cb0","#f0027f","#bf5b17","#666666"],Set1:["#e41a1c","#377eb8","#4daf4a","#984ea3","#ff7f00","#ffff33","#a65628","#f781bf","#999999"],Set3:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3","#fdb462","#b3de69","#fccde5","#d9d9d9","#bc80bd","#ccebc5","#ffed6f"],Dark2:["#1b9e77","#d95f02","#7570b3","#e7298a","#66a61e","#e6ab02","#a6761d","#666666"],Paired:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99","#e31a1c","#fdbf6f","#ff7f00","#cab2d6","#6a3d9a","#ffff99","#b15928"],Pastel2:["#b3e2cd","#fdcdac","#cbd5e8","#f4cae4","#e6f5c9","#fff2ae","#f1e2cc","#cccccc"],Pastel1:["#fbb4ae","#b3cde3","#ccebc5","#decbe4","#fed9a6","#ffffcc","#e5d8bd","#fddaec","#f2f2f2"]},qg={indigo:"#4b0082",gold:"#ffd700",hotpink:"#ff69b4",firebrick:"#b22222",indianred:"#cd5c5c",yellow:"#ffff00",mistyrose:"#ffe4e1",darkolivegreen:"#556b2f",olive:"#808000",darkseagreen:"#8fbc8f",pink:"#ffc0cb",tomato:"#ff6347",lightcoral:"#f08080",orangered:"#ff4500",navajowhite:"#ffdead",lime:"#00ff00",palegreen:"#98fb98",darkslategrey:"#2f4f4f",greenyellow:"#adff2f",burlywood:"#deb887",seashell:"#fff5ee",mediumspringgreen:"#00fa9a",fuchsia:"#ff00ff",papayawhip:"#ffefd5",blanchedalmond:"#ffebcd",chartreuse:"#7fff00",dimgray:"#696969",black:"#000000",peachpuff:"#ffdab9",springgreen:"#00ff7f",aquamarine:"#7fffd4",white:"#ffffff",orange:"#ffa500",lightsalmon:"#ffa07a",darkslategray:"#2f4f4f",brown:"#a52a2a",ivory:"#fffff0",dodgerblue:"#1e90ff",peru:"#cd853f",lawngreen:"#7cfc00",chocolate:"#d2691e",crimson:"#dc143c",forestgreen:"#228b22",darkgrey:"#a9a9a9",lightseagreen:"#20b2aa",cyan:"#00ffff",mintcream:"#f5fffa",silver:"#c0c0c0",antiquewhite:"#faebd7",mediumorchid:"#ba55d3",skyblue:"#87ceeb",gray:"#808080",darkturquoise:"#00ced1",goldenrod:"#daa520",darkgreen:"#006400",floralwhite:"#fffaf0",darkviolet:"#9400d3",darkgray:"#a9a9a9",moccasin:"#ffe4b5",saddlebrown:"#8b4513",grey:"#808080",darkslateblue:"#483d8b",lightskyblue:"#87cefa",lightpink:"#ffb6c1",mediumvioletred:"#c71585",slategrey:"#708090",red:"#ff0000",deeppink:"#ff1493",limegreen:"#32cd32",darkmagenta:"#8b008b",palegoldenrod:"#eee8aa",plum:"#dda0dd",turquoise:"#40e0d0",lightgrey:"#d3d3d3",lightgoldenrodyellow:"#fafad2",darkgoldenrod:"#b8860b",lavender:"#e6e6fa",maroon:"#800000",yellowgreen:"#9acd32",sandybrown:"#f4a460",thistle:"#d8bfd8",violet:"#ee82ee",navy:"#000080",magenta:"#ff00ff",dimgrey:"#696969",tan:"#d2b48c",rosybrown:"#bc8f8f",olivedrab:"#6b8e23",blue:"#0000ff",lightblue:"#add8e6",ghostwhite:"#f8f8ff",honeydew:"#f0fff0",cornflowerblue:"#6495ed",slateblue:"#6a5acd",linen:"#faf0e6",darkblue:"#00008b",powderblue:"#b0e0e6",seagreen:"#2e8b57",darkkhaki:"#bdb76b",snow:"#fffafa",sienna:"#a0522d",mediumblue:"#0000cd",royalblue:"#4169e1",lightcyan:"#e0ffff",green:"#008000",mediumpurple:"#9370db",midnightblue:"#191970",cornsilk:"#fff8dc",paleturquoise:"#afeeee",bisque:"#ffe4c4",slategray:"#708090",darkcyan:"#008b8b",khaki:"#f0e68c",wheat:"#f5deb3",teal:"#008080",darkorchid:"#9932cc",deepskyblue:"#00bfff",salmon:"#fa8072",darkred:"#8b0000",steelblue:"#4682b4",palevioletred:"#db7093",lightslategray:"#778899",aliceblue:"#f0f8ff",lightslategrey:"#778899",lightgreen:"#90ee90",orchid:"#da70d6",gainsboro:"#dcdcdc",mediumseagreen:"#3cb371",lightgray:"#d3d3d3",mediumturquoise:"#48d1cc",lemonchiffon:"#fffacd",cadetblue:"#5f9ea0",lightyellow:"#ffffe0",lavenderblush:"#fff0f5",coral:"#ff7f50",purple:"#800080",aqua:"#00ffff",whitesmoke:"#f5f5f5",mediumslateblue:"#7b68ee",darkorange:"#ff8c00",mediumaquamarine:"#66cdaa",darksalmon:"#e9967a",beige:"#f5f5dc",blueviolet:"#8a2be2",azure:"#f0ffff",lightsteelblue:"#b0c4de",oldlace:"#fdf5e6",rebeccapurple:"#663399"},Hm.colors=qm=qg,dg=function(){var t,e,i,n,r,o,a,s,c;return e=Xg(arguments),r=e[0],t=e[1],i=e[2],s=(r+16)/116,a=isNaN(t)?s:s+t/500,c=isNaN(i)?s:s-i/200,s=Em.Yn*fg(s),a=Em.Xn*fg(a),c=Em.Zn*fg(c),o=Zg(3.2404542*a-1.5371385*s-.4985314*c),n=Zg(-.969266*a+1.8760108*s+.041556*c),i=Zg(.0556434*a-.2040259*s+1.0572252*c),o=vg(o,0,255),n=vg(n,0,255),i=vg(i,0,255),[o,n,i,e.length>3?e[3]:1]},Zg=function(t){return jg(255*(t<=.00304?12.92*t:1.055*Cg(t,1/2.4)-.055))},fg=function(t){return t>Em.t1?t*t*t:Em.t2*(t-Em.t0)},Em={Kn:18,Xn:.95047,Yn:1,Zn:1.08883,t0:.137931034,t1:.206896552,t2:.12841855,t3:.008856452},Og=function(){var t,e,i,n,r,o,a,s;return n=Xg(arguments),i=n[0],e=n[1],t=n[2],r=zg(i,e,t),o=r[0],a=r[1],s=r[2],[116*a-16,500*(o-a),200*(a-s)]},Bg=function(t){return(t/=255)<=.04045?t/12.92:Cg((t+.055)/1.055,2.4)},Yg=function(t){return t>Em.t3?Cg(t,1/3):t/Em.t2+Em.t0},zg=function(){var t,e,i,n,r,o,a;return n=Xg(arguments),i=n[0],e=n[1],t=n[2],i=Bg(i),e=Bg(e),t=Bg(t),r=Yg((.4124564*i+.3575761*e+.1804375*t)/Em.Xn),o=Yg((.2126729*i+.7151522*e+.072175*t)/Em.Yn),a=Yg((.0193339*i+.119192*e+.9503041*t)/Em.Zn),[r,o,a]},Hm.lab=function(){return function(t,e,i){i.prototype=t.prototype;var n=new i,r=t.apply(n,e);return Object(r)===r?r:n}(Pm,Kg.call(arguments).concat(["lab"]),function(){})},km.lab=dg,Pm.prototype.lab=function(){return Og(this._rgb)},Um=function(t){var e,i,n,r,o,a,s,c,u,h,l;return t=function(){var e,i,n;for(n=[],i=0,e=t.length;i<e;i++)r=t[i],n.push(Hm(r));return n}(),2===t.length?(u=function(){var e,i,n;for(n=[],i=0,e=t.length;i<e;i++)r=t[i],n.push(r.lab());return n}(),o=u[0],a=u[1],e=function(t){var e,i;return i=function(){var i,n;for(n=[],e=i=0;i<=2;e=++i)n.push(o[e]+t*(a[e]-o[e]));return n}(),Hm.lab.apply(Hm,i)}):3===t.length?(h=function(){var e,i,n;for(n=[],i=0,e=t.length;i<e;i++)r=t[i],n.push(r.lab());return n}(),o=h[0],a=h[1],s=h[2],e=function(t){var e,i;return i=function(){var i,n;for(n=[],e=i=0;i<=2;e=++i)n.push((1-t)*(1-t)*o[e]+2*(1-t)*t*a[e]+t*t*s[e]);return n}(),Hm.lab.apply(Hm,i)}):4===t.length?(l=function(){var e,i,n;for(n=[],i=0,e=t.length;i<e;i++)r=t[i],n.push(r.lab());return n}(),o=l[0],a=l[1],s=l[2],c=l[3],e=function(t){var e,i;return i=function(){var i,n;for(n=[],e=i=0;i<=2;e=++i)n.push((1-t)*(1-t)*(1-t)*o[e]+3*(1-t)*(1-t)*t*a[e]+3*(1-t)*t*t*s[e]+t*t*t*c[e]);return n}(),Hm.lab.apply(Hm,i)}):5===t.length&&(i=Um(t.slice(0,3)),n=Um(t.slice(2,5)),e=function(t){return t<.5?i(2*t):n(2*(t-.5))}),e},Hm.bezier=function(t){var e;return e=Um(t),e.scale=function(){return Hm.scale(e)},e},Hm.cubehelix=function(t,e,i,n,r){var o,a,s;return null==t&&(t=300),null==e&&(e=-1.5),null==i&&(i=1),null==n&&(n=1),null==r&&(r=[0,1]),a=r[1]-r[0],o=0,s=function(s){var c,u,h,l,d,f,p,m,g;return c=Om*((t+120)/360+e*s),p=Cg(r[0]+a*s,n),f=0!==o?i[0]+s*o:i,u=f*p*(1-p)/2,l=Ym(c),g=Vg(c),m=p+u*(-.14861*l+1.78277*g),d=p+u*(-.29227*l-.90649*g),h=p+u*(1.97294*l),Hm(Wm([255*m,255*d,255*h]))},s.start=function(e){return null==e?t:(t=e,s)},s.rotations=function(t){return null==t?e:(e=t,s)},s.gamma=function(t){return null==t?n:(n=t,s)},s.hue=function(t){return null==t?i:(i=t,"array"===Wg(i)?(o=i[1]-i[0],0===o&&(i=i[1])):o=0,s)},s.lightness=function(t){return null==t?r:(r=t,"array"===Wg(r)?(a=r[1]-r[0],0===a&&(r=r[1])):a=0,s)},s.scale=function(){return Hm.scale(s)},s.hue(i),s},Hm.random=function(){var t,e,i,n;for(e="0123456789abcdef",t="#",i=n=0;n<6;i=++n)t+=e.charAt(tg(16*Math.random()));return new Pm(t)},km.rgb=function(){var t,e,i,n;e=Xg(arguments),i=[];for(t in e)n=e[t],i.push(n);return i},Hm.rgb=function(){return function(t,e,i){i.prototype=t.prototype;var n=new i,r=t.apply(n,e);return Object(r)===r?r:n}(Pm,Kg.call(arguments).concat(["rgb"]),function(){})},Pm.prototype.rgb=function(){return this._rgb.slice(0,3)},Pm.prototype.rgba=function(){return this._rgb},Dm.push({p:15,test:function(t){var e;return e=Xg(arguments),"array"===Wg(e)&&3===e.length?"rgb":4===e.length&&"number"===Wg(e[3])&&e[3]>=0&&e[3]<=1?"rgb":void 0}}),eg=function(t){var e,i,n,r,o,a;if(t.match(/^#?([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/))return 4!==t.length&&7!==t.length||(t=t.substr(1)),3===t.length&&(t=t.split(""),t=t[0]+t[0]+t[1]+t[1]+t[2]+t[2]),a=parseInt(t,16),r=a>>16,n=a>>8&255,i=255&a,[r,n,i,1];if(t.match(/^#?([A-Fa-f0-9]{8})$/))return 9===t.length&&(t=t.substr(1)),a=parseInt(t,16),r=a>>24&255,n=a>>16&255,i=a>>8&255,e=jg((255&a)/255*100)/100,[r,n,i,e];if(null!=km.css&&(o=km.css(t)))return o;throw"unknown color: "+t},Eg=function(t,e){var i,n,r,o,a,s,c;return null==e&&(e="rgb"),a=t[0],r=t[1],n=t[2],i=t[3],c=a<<16|r<<8|n,s="000000"+c.toString(16),s=s.substr(s.length-6),o="0"+jg(255*i).toString(16),o=o.substr(o.length-2),"#"+function(){switch(e.toLowerCase()){case"rgba":return s+o;case"argb":return o+s;default:return s}}()},km.hex=function(t){return eg(t)},Hm.hex=function(){return function(t,e,i){i.prototype=t.prototype;var n=new i,r=t.apply(n,e);return Object(r)===r?r:n}(Pm,Kg.call(arguments).concat(["hex"]),function(){})},Pm.prototype.hex=function(t){return null==t&&(t="rgb"),Eg(this._rgb,t)},Dm.push({p:10,test:function(t){if(1===arguments.length&&"string"===Wg(t))return"hex"}}),rg=function(){var t,e,i,n,r,o,a,s,c,u,h,l,d,f;if(t=Xg(arguments),r=t[0],h=t[1],a=t[2],0===h)c=n=e=255*a;else{for(f=[0,0,0],i=[0,0,0],d=a<.5?a*(1+h):a+h-a*h,l=2*a-d,r/=360,f[0]=r+1/3,f[1]=r,f[2]=r-1/3,o=s=0;s<=2;o=++s)f[o]<0&&(f[o]+=1),f[o]>1&&(f[o]-=1),6*f[o]<1?i[o]=l+6*(d-l)*f[o]:2*f[o]<1?i[o]=d:3*f[o]<2?i[o]=l+(d-l)*(2/3-f[o])*6:i[o]=l;u=[jg(255*i[0]),jg(255*i[1]),jg(255*i[2])],c=u[0],n=u[1],e=u[2]}return t.length>3?[c,n,e,t[3]]:[c,n,e]},Lg=function(t,e,i){var n,r,o,a,s;return void 0!==t&&t.length>=3&&(a=t,t=a[0],e=a[1],i=a[2]),t/=255,e/=255,i/=255,o=Math.min(t,e,i),_g=Math.max(t,e,i),r=(_g+o)/2,_g===o?(s=0,n=Number.NaN):s=r<.5?(_g-o)/(_g+o):(_g-o)/(2-_g-o),t===_g?n=(e-i)/(_g-o):e===_g?n=2+(i-t)/(_g-o):i===_g&&(n=4+(t-e)/(_g-o)),n*=60,n<0&&(n+=360),[n,s,r]},Hm.hsl=function(){return function(t,e,i){i.prototype=t.prototype;var n=new i,r=t.apply(n,e);return Object(r)===r?r:n}(Pm,Kg.call(arguments).concat(["hsl"]),function(){})},km.hsl=rg,Pm.prototype.hsl=function(){return Lg(this._rgb)},og=function(){var t,e,i,n,r,o,a,s,c,u,h,l,d,f,p,m,g,v;if(t=Xg(arguments),r=t[0],m=t[1],v=t[2],v*=255,0===m)c=n=e=v;else switch(360===r&&(r=0),r>360&&(r-=360),r<0&&(r+=360),r/=60,o=tg(r),i=r-o,a=v*(1-m),s=v*(1-m*i),g=v*(1-m*(1-i)),o){case 0:u=[v,g,a],c=u[0],n=u[1],e=u[2];break;case 1:h=[s,v,a],c=h[0],n=h[1],e=h[2];break;case 2:l=[a,v,g],c=l[0],n=l[1],e=l[2];break;case 3:d=[a,s,v],c=d[0],n=d[1],e=d[2];break;case 4:f=[g,a,v],c=f[0],n=f[1],e=f[2];break;case 5:p=[v,a,s],c=p[0],n=p[1],e=p[2]}return c=jg(c),n=jg(n),e=jg(e),[c,n,e,t.length>3?t[3]:1]},Rg=function(){var t,e,i,n,r,o,a,s,c;return a=Xg(arguments),o=a[0],i=a[1],t=a[2],r=Math.min(o,i,t),_g=Math.max(o,i,t),e=_g-r,c=_g/255,0===_g?(n=Number.NaN,s=0):(s=e/_g,o===_g&&(n=(i-t)/e),i===_g&&(n=2+(t-o)/e),t===_g&&(n=4+(o-i)/e),n*=60,n<0&&(n+=360)),[n,s,c]},Hm.hsv=function(){return function(t,e,i){i.prototype=t.prototype;var n=new i,r=t.apply(n,e);return Object(r)===r?r:n}(Pm,Kg.call(arguments).concat(["hsv"]),function(){})},km.hsv=og,Pm.prototype.hsv=function(){return Rg(this._rgb)},Ag=function(t){var e,i,n;return"number"===Wg(t)&&t>=0&&t<=16777215?(n=t>>16,i=t>>8&255,e=255&t,[n,i,e,1]):(console.warn("unknown num color: "+t),[0,0,0,1])},kg=function(){var t,e,i,n;return n=Xg(arguments),i=n[0],e=n[1],t=n[2],(i<<16)+(e<<8)+t},Hm.num=function(t){return new Pm(t,"num")},Pm.prototype.num=function(t){return null==t&&(t="rgb"),kg(this._rgb,t)},km.num=Ag,Dm.push({p:10,test:function(t){if(1===arguments.length&&"number"===Wg(t)&&t>=0&&t<=16777215)return"num"}}),Zm=function(t){var e,i,n,r,o,a,s,c;if(t=t.toLowerCase(),null!=Hm.colors&&Hm.colors[t])return eg(Hm.colors[t]);if(o=t.match(/rgb\(\s*(\-?\d+),\s*(\-?\d+)\s*,\s*(\-?\d+)\s*\)/)){for(s=o.slice(1,4),r=a=0;a<=2;r=++a)s[r]=+s[r];s[3]=1}else if(o=t.match(/rgba\(\s*(\-?\d+),\s*(\-?\d+)\s*,\s*(\-?\d+)\s*,\s*([01]|[01]?\.\d+)\)/))for(s=o.slice(1,5),r=c=0;c<=3;r=++c)s[r]=+s[r];else if(o=t.match(/rgb\(\s*(\-?\d+(?:\.\d+)?)%,\s*(\-?\d+(?:\.\d+)?)%\s*,\s*(\-?\d+(?:\.\d+)?)%\s*\)/)){for(s=o.slice(1,4),r=e=0;e<=2;r=++e)s[r]=jg(2.55*s[r]);s[3]=1}else if(o=t.match(/rgba\(\s*(\-?\d+(?:\.\d+)?)%,\s*(\-?\d+(?:\.\d+)?)%\s*,\s*(\-?\d+(?:\.\d+)?)%\s*,\s*([01]|[01]?\.\d+)\)/)){for(s=o.slice(1,5),r=i=0;i<=2;r=++i)s[r]=jg(2.55*s[r]);s[3]=+s[3]}else(o=t.match(/hsl\(\s*(\-?\d+(?:\.\d+)?),\s*(\-?\d+(?:\.\d+)?)%\s*,\s*(\-?\d+(?:\.\d+)?)%\s*\)/))?(n=o.slice(1,4),n[1]*=.01,n[2]*=.01,s=rg(n),s[3]=1):(o=t.match(/hsla\(\s*(\-?\d+(?:\.\d+)?),\s*(\-?\d+(?:\.\d+)?)%\s*,\s*(\-?\d+(?:\.\d+)?)%\s*,\s*([01]|[01]?\.\d+)\)/))&&(n=o.slice(1,4),n[1]*=.01,n[2]*=.01,s=rg(n),s[3]=+o[4]);return s},Tg=function(t){var e;return e=t[3]<1?"rgba":"rgb","rgb"===e?e+"("+t.slice(0,3).map(jg).join(",")+")":"rgba"===e?e+"("+t.slice(0,3).map(jg).join(",")+","+t[3]+")":void 0},Ug=function(t){return jg(100*t)/100},ng=function(t,e){var i;return i=e<1?"hsla":"hsl",t[0]=Ug(t[0]||0),t[1]=Ug(100*t[1])+"%",t[2]=Ug(100*t[2])+"%","hsla"===i&&(t[3]=e),i+"("+t.join(",")+")"},km.css=function(t){return Zm(t)},Hm.css=function(){return function(t,e,i){i.prototype=t.prototype;var n=new i,r=t.apply(n,e);return Object(r)===r?r:n}(Pm,Kg.call(arguments).concat(["css"]),function(){})},Pm.prototype.css=function(t){return null==t&&(t="rgb"),"rgb"===t.slice(0,3)?Tg(this._rgb):"hsl"===t.slice(0,3)?ng(this.hsl(),this.alpha()):void 0},km.named=function(t){return eg(qg[t])},Dm.push({p:20,test:function(t){if(1===arguments.length&&null!=qg[t])return"named"}}),Pm.prototype.name=function(t){var e,i;arguments.length&&(qg[t]&&(this._rgb=eg(qg[t])),this._rgb[3]=1),e=this.hex();for(i in qg)if(e===qg[i])return i;return e},pg=function(){var t,e,i,n;return n=Xg(arguments),i=n[0],t=n[1],e=n[2],e*=Tm,[i,Ym(e)*t,Vg(e)*t]},mg=function(){var t,e,i,n,r,o,a,s,c,u,h;return i=Xg(arguments),s=i[0],r=i[1],a=i[2],u=pg(s,r,a),t=u[0],e=u[1],n=u[2],h=dg(t,e,n),c=h[0],o=h[1],n=h[2],[vg(c,0,255),vg(o,0,255),vg(n,0,255),i.length>3?i[3]:1]},lg=function(){var t,e,i,n,r,o;return o=Xg(arguments),r=o[0],t=o[1],e=o[2],i=Gg(t*t+e*e),n=(Bm(e,t)*Rm+360)%360,0===jg(1e4*i)&&(n=Number.NaN),[r,i,n]},Dg=function(){var t,e,i,n,r,o,a;return o=Xg(arguments),r=o[0],i=o[1],e=o[2],a=Og(r,i,e),n=a[0],t=a[1],e=a[2],lg(n,t,e)},Hm.lch=function(){var t;return t=Xg(arguments),new Pm(t,"lch")},Hm.hcl=function(){var t;return t=Xg(arguments),new Pm(t,"hcl")},km.lch=mg,km.hcl=function(){var t,e,i,n;return n=Xg(arguments),e=n[0],t=n[1],i=n[2],mg([i,t,e])},Pm.prototype.lch=function(){return Dg(this._rgb)},Pm.prototype.hcl=function(){return Dg(this._rgb).reverse()},Pg=function(t){var e,i,n,r,o,a,s,c,u;return null==t&&(t="rgb"),c=Xg(arguments),s=c[0],r=c[1],e=c[2],s/=255,r/=255,e/=255,o=1-Math.max(s,Math.max(r,e)),n=o<1?1/(1-o):0,i=(1-s-o)*n,a=(1-r-o)*n,u=(1-e-o)*n,[i,a,u,o]},Xm=function(){var t,e,i,n,r,o,a,s,c;return e=Xg(arguments),n=e[0],a=e[1],c=e[2],o=e[3],t=e.length>4?e[4]:1,1===o?[0,0,0,t]:(s=n>=1?0:jg(255*(1-n)*(1-o)),r=a>=1?0:jg(255*(1-a)*(1-o)),i=c>=1?0:jg(255*(1-c)*(1-o)),[s,r,i,t])},km.cmyk=function(){return Xm(Xg(arguments))},Hm.cmyk=function(){return function(t,e,i){i.prototype=t.prototype;var n=new i,r=t.apply(n,e);return Object(r)===r?r:n}(Pm,Kg.call(arguments).concat(["cmyk"]),function(){})},Pm.prototype.cmyk=function(){return Pg(this._rgb)},km.gl=function(){var t,e,i,n,r;for(n=function(){var t,i;t=Xg(arguments),i=[];for(e in t)r=t[e],i.push(r);return i}.apply(this,arguments),t=i=0;i<=2;t=++i)n[t]*=255;return n},Hm.gl=function(){return function(t,e,i){i.prototype=t.prototype;var n=new i,r=t.apply(n,e);return Object(r)===r?r:n}(Pm,Kg.call(arguments).concat(["gl"]),function(){})},Pm.prototype.gl=function(){var t;return t=this._rgb,[t[0]/255,t[1]/255,t[2]/255,t[3]]},Ng=function(t,e,i){var n;return n=Xg(arguments),t=n[0],e=n[1],i=n[2],t=bg(t),e=bg(e),i=bg(i),.2126*t+.7152*e+.0722*i},bg=function(t){return t/=255,t<=.03928?t/12.92:Cg((t+.055)/1.055,2.4)},Fm=[],ag=function(t,e,i,n){var r,o,a,s;for(null==i&&(i=.5),null==n&&(n="rgb"),"object"!==Wg(t)&&(t=Hm(t)),"object"!==Wg(e)&&(e=Hm(e)),a=0,o=Fm.length;a<o;a++)if(r=Fm[a],n===r[0]){s=r[1](t,e,i,n);break}if(null==s)throw"color mode "+n+" is not supported";return s.alpha(t.alpha()+i*(e.alpha()-t.alpha())),s},Hm.interpolate=ag,Pm.prototype.interpolate=function(t,e,i){return ag(this,t,e,i)},Hm.mix=ag,Pm.prototype.mix=Pm.prototype.interpolate,hg=function(t,e,i,n){var r,o;return r=t._rgb,o=e._rgb,new Pm(r[0]+i*(o[0]-r[0]),r[1]+i*(o[1]-r[1]),r[2]+i*(o[2]-r[2]),n)},Fm.push(["rgb",hg]),Pm.prototype.luminance=function(t,e){var i,n,r,o;return null==e&&(e="rgb"),arguments.length?(0===t?this._rgb=[0,0,0,this._rgb[3]]:1===t?this._rgb=[255,255,255,this._rgb[3]]:(n=1e-7,r=20,o=function(i,a){var s,c;return c=i.interpolate(a,.5,e),s=c.luminance(),Math.abs(t-s)<n||!r--?c:s>t?o(i,c):o(c,a)},i=Ng(this._rgb),this._rgb=(i>t?o(Hm("black"),this):o(this,Hm("white"))).rgba()),this):Ng(this._rgb)},Hg=function(t){var e,i,n,r;return r=t/100,r<66?(n=255,i=-155.25485562709179-.44596950469579133*(i=r-2)+104.49216199393888*yg(i),e=r<20?0:-254.76935184120902+.8274096064007395*(e=r-10)+115.67994401066147*yg(e)):(n=351.97690566805693+.114206453784165*(n=r-55)-40.25366309332127*yg(n),i=325.4494125711974+.07943456536662342*(i=r-50)-28.0852963507957*yg(i),e=255),Wm([n,i,e])},Fg=function(){var t,e,i,n,r,o,a,s,c;for(a=Xg(arguments),o=a[0],i=a[1],t=a[2],r=1e3,n=4e4,e=.4;n-r>e;)c=.5*(n+r),s=Hg(c),s[2]/s[0]>=t/o?n=c:r=c;return jg(c)},Hm.temperature=Hm.kelvin=function(){return function(t,e,i){i.prototype=t.prototype;var n=new i,r=t.apply(n,e);return Object(r)===r?r:n}(Pm,Kg.call(arguments).concat(["temperature"]),function(){})},km.temperature=km.kelvin=km.K=Hg,Pm.prototype.temperature=function(){return Fg(this._rgb)},Pm.prototype.kelvin=Pm.prototype.temperature,Hm.contrast=function(t,e){var i,n,r,o;return"string"!==(r=Wg(t))&&"number"!==r||(t=new Pm(t)),"string"!==(o=Wg(e))&&"number"!==o||(e=new Pm(e)),i=t.luminance(),n=e.luminance(),i>n?(i+.05)/(n+.05):(n+.05)/(i+.05)},Pm.prototype.get=function(t){var e,i,n,r,o,a;return n=this,o=t.split("."),r=o[0],e=o[1],a=n[r](),e?(i=r.indexOf(e),i>-1?a[i]:console.warn("unknown channel "+e+" in mode "+r)):a},Pm.prototype.set=function(t,e){var i,n,r,o,a,s;if(r=this,a=t.split("."),o=a[0],i=a[1],i)if(s=r[o](),n=o.indexOf(i),n>-1)if("string"===Wg(e))switch(e.charAt(0)){case"+":s[n]+=+e;break;case"-":s[n]+=+e;break;case"*":s[n]*=+e.substr(1);break;case"/":s[n]/=+e.substr(1);break;default:s[n]=+e}else s[n]=e;else console.warn("unknown channel "+i+" in mode "+o);else s=e;return r._rgb=Hm(s,o).alpha(r.alpha())._rgb,r},Pm.prototype.darken=function(t){var e,i;return null==t&&(t=1),i=this,e=i.lab(),e[0]-=Em.Kn*t,Hm.lab(e).alpha(i.alpha())},Pm.prototype.brighten=function(t){return null==t&&(t=1),this.darken(-t)},Pm.prototype.darker=Pm.prototype.darken,Pm.prototype.brighter=Pm.prototype.brighten,Pm.prototype.saturate=function(t){var e,i;return null==t&&(t=1),i=this,e=i.lch(),e[1]+=t*Em.Kn,e[1]<0&&(e[1]=0),Hm.lch(e).alpha(i.alpha())},Pm.prototype.desaturate=function(t){return null==t&&(t=1),this.saturate(-t)},Pm.prototype.premultiply=function(){var t,e;return e=this.rgb(),t=this.alpha(),Hm(e[0]*t,e[1]*t,e[2]*t,t)},jm=function(t,e,i){if(!jm[i])throw"unknown blend mode "+i;return jm[i](t,e)},$m=function(t){return function(e,i){var n,r;return n=Hm(i).rgb(),r=Hm(e).rgb(),Hm(t(n,r),"rgb")}},Jm=function(t){return function(e,i){var n,r,o;for(o=[],n=r=0;r<=3;n=++r)o[n]=t(e[n],i[n]);return o}},Sg=function(t,e){return t},wg=function(t,e){return t*e/255},Km=function(t,e){return t>e?e:t},gg=function(t,e){return t>e?t:e},$g=function(t,e){return 255*(1-(1-t/255)*(1-e/255))},Mg=function(t,e){return e<128?2*t*e/255:255*(1-2*(1-t/255)*(1-e/255))},Gm=function(t,e){return 255*(1-(1-e/255)/(t/255))},Qm=function(t,e){return 255===t?255:(t=255*(e/255)/(1-t/255),t>255?255:t)},jm.normal=$m(Jm(Sg)),jm.multiply=$m(Jm(wg)),jm.screen=$m(Jm($g)),jm.overlay=$m(Jm(Mg)),jm.darken=$m(Jm(Km)),jm.lighten=$m(Jm(gg)),jm.dodge=$m(Jm(Qm)),
	jm.burn=$m(Jm(Gm)),Hm.blend=jm,Hm.analyze=function(t){var e,i,n,r;for(n={min:Number.MAX_VALUE,max:Number.MAX_VALUE*-1,sum:0,values:[],count:0},i=0,e=t.length;i<e;i++)r=t[i],null==r||isNaN(r)||(n.values.push(r),n.sum+=r,r<n.min&&(n.min=r),r>n.max&&(n.max=r),n.count+=1);return n.domain=[n.min,n.max],n.limits=function(t,e){return Hm.limits(n,t,e)},n},Hm.scale=function(t,e){var i,n,r,o,a,s,c,u,h,l,d,f,p,m,g,v,y,b,x,_,w;return h="rgb",l=Hm("#ccc"),m=0,s=!1,a=[0,1],p=[],f=[0,0],i=!1,r=[],d=!1,u=0,c=1,o=!1,n={},_=function(t){var e,i,n,o,a,s,c;if(null==t&&(t=["#fff","#000"]),null!=t&&"string"===Wg(t)&&null!=(null!=(o=Hm.brewer)?o[t]:void 0)&&(t=Hm.brewer[t]),"array"===Wg(t)){for(t=t.slice(0),e=n=0,a=t.length-1;0<=a?n<=a:n>=a;e=0<=a?++n:--n)i=t[e],"string"===Wg(i)&&(t[e]=Hm(i));for(p.length=0,e=c=0,s=t.length-1;0<=s?c<=s:c>=s;e=0<=s?++c:--c)p.push(e/(t.length-1))}return x(),r=t},y=function(t){var e,n;if(null!=i){for(n=i.length-1,e=0;e<n&&t>=i[e];)e++;return e-1}return 0},w=function(t){return t},g=function(t){var e,n,r,o,a;return a=t,i.length>2&&(o=i.length-1,e=y(t),r=i[0]+(i[1]-i[0])*(0+.5*m),n=i[o-1]+(i[o]-i[o-1])*(1-.5*m),a=u+(i[e]+.5*(i[e+1]-i[e])-r)/(n-r)*(c-u)),a},b=function(t,e){var o,a,s,d,m,g,v,b;if(null==e&&(e=!1),isNaN(t))return l;if(e?b=t:i&&i.length>2?(o=y(t),b=o/(i.length-2),b=f[0]+b*(1-f[0]-f[1])):c!==u?(b=(t-u)/(c-u),b=f[0]+b*(1-f[0]-f[1]),b=Math.min(1,Math.max(0,b))):b=1,e||(b=w(b)),d=Math.floor(1e4*b),n[d])a=n[d];else{if("array"===Wg(r))for(s=m=0,v=p.length-1;0<=v?m<=v:m>=v;s=0<=v?++m:--m){if(g=p[s],b<=g){a=r[s];break}if(b>=g&&s===p.length-1){a=r[s];break}if(b>g&&b<p[s+1]){b=(b-g)/(p[s+1]-g),a=Hm.interpolate(r[s],r[s+1],b,h);break}}else"function"===Wg(r)&&(a=r(b));n[d]=a}return a},x=function(){return n={}},_(t),v=function(t){var e;return e=Hm(b(t)),d&&e[d]?e[d]():e},v.classes=function(t){var e;return null!=t?("array"===Wg(t)?(i=t,a=[t[0],t[t.length-1]]):(e=Hm.analyze(a),i=0===t?[e.min,e.max]:Hm.limits(e,"e",t)),v):i},v.domain=function(t){var e,i,n,o,s,h,l;if(!arguments.length)return a;if(u=t[0],c=t[t.length-1],p=[],n=r.length,t.length===n&&u!==c)for(s=0,o=t.length;s<o;s++)i=t[s],p.push((i-u)/(c-u));else for(e=l=0,h=n-1;0<=h?l<=h:l>=h;e=0<=h?++l:--l)p.push(e/(n-1));return a=[u,c],v},v.mode=function(t){return arguments.length?(h=t,x(),v):h},v.range=function(t,e){return _(t,e),v},v.out=function(t){return d=t,v},v.spread=function(t){return arguments.length?(m=t,v):m},v.correctLightness=function(t){return null==t&&(t=!0),o=t,x(),w=o?function(t){var e,i,n,r,o,a,s,c,u;for(e=b(0,!0).lab()[0],i=b(1,!0).lab()[0],s=e>i,n=b(t,!0).lab()[0],o=e+(i-e)*t,r=n-o,c=0,u=1,a=20;Math.abs(r)>.01&&a-- >0;)!function(){return s&&(r*=-1),r<0?(c=t,t+=.5*(u-t)):(u=t,t+=.5*(c-t)),n=b(t,!0).lab()[0],r=n-o}();return t}:function(t){return t},v},v.padding=function(t){return null!=t?("number"===Wg(t)&&(t=[t,t]),f=t,v):f},v.colors=function(){var e,n,r,o,s,c,u,h,l;if(o=0,s="hex",1===arguments.length&&("string"===Wg(arguments[0])?s=arguments[0]:o=arguments[0]),2===arguments.length&&(o=arguments[0],s=arguments[1]),o)return n=a[0],e=a[1]-n,function(){u=[];for(var t=0;0<=o?t<o:t>o;0<=o?t++:t--)u.push(t);return u}.apply(this).map(function(t){return v(n+t/(o-1)*e)[s]()});if(t=[],h=[],i&&i.length>2)for(r=l=1,c=i.length;1<=c?l<c:l>c;r=1<=c?++l:--l)h.push(.5*(i[r-1]+i[r]));else h=a;return h.map(function(t){return v(t)[s]()})},v},null==Hm.scales&&(Hm.scales={}),Hm.scales.cool=function(){return Hm.scale([Hm.hsl(180,1,.9),Hm.hsl(250,.7,.4)])},Hm.scales.hot=function(){return Hm.scale(["#000","#f00","#ff0","#fff"],[0,.25,.75,1]).mode("rgb")},Hm.analyze=function(t,e,i){var n,r,o,a,s,c,u;if(s={min:Number.MAX_VALUE,max:Number.MAX_VALUE*-1,sum:0,values:[],count:0},null==i&&(i=function(){return!0}),n=function(t){null==t||isNaN(t)||(s.values.push(t),s.sum+=t,t<s.min&&(s.min=t),t>s.max&&(s.max=t),s.count+=1)},u=function(t,r){if(i(t,r))return n(null!=e&&"function"===Wg(e)?e(t):null!=e&&"string"===Wg(e)||"number"===Wg(e)?t[e]:t)},"array"===Wg(t))for(a=0,o=t.length;a<o;a++)c=t[a],u(c);else for(r in t)c=t[r],u(c,r);return s.domain=[s.min,s.max],s.limits=function(t,e){return Hm.limits(s,t,e)},s},Hm.limits=function(t,e,i){var n,r,o,a,s,c,u,h,l,d,f,p,m,g,v,y,b,x,_,w,S,A,M,C,P,T,E,I,L,R,O,D,N,k,F,z,B,U,j,$,V,G,H,W,X,q,Y,Z,K,Q,J,tt,et,it,nt;if(null==e&&(e="equal"),null==i&&(i=7),"array"===Wg(t)&&(t=Hm.analyze(t)),P=t.min,_g=t.max,J=t.sum,it=t.values.sort(function(t,e){return t-e}),M=[],"c"===e.substr(0,1)&&(M.push(P),M.push(_g)),"e"===e.substr(0,1)){for(M.push(P),w=O=1,F=i-1;1<=F?O<=F:O>=F;w=1<=F?++O:--O)M.push(P+w/i*(_g-P));M.push(_g)}else if("l"===e.substr(0,1)){if(P<=0)throw"Logarithmic scales are only possible for values > 0";for(T=Math.LOG10E*yg(P),C=Math.LOG10E*yg(_g),M.push(P),w=nt=1,z=i-1;1<=z?nt<=z:nt>=z;w=1<=z?++nt:--nt)M.push(Cg(10,T+w/i*(C-T)));M.push(_g)}else if("q"===e.substr(0,1)){for(M.push(P),w=n=1,G=i-1;1<=G?n<=G:n>=G;w=1<=G?++n:--n)D=it.length*w/i,N=tg(D),N===D?M.push(it[N]):(k=D-N,M.push(it[N]*k+it[N+1]*(1-k)));M.push(_g)}else if("k"===e.substr(0,1)){for(I=it.length,g=new Array(I),x=new Array(i),Q=!0,L=0,y=null,y=[],y.push(P),w=r=1,H=i-1;1<=H?r<=H:r>=H;w=1<=H?++r:--r)y.push(P+w/i*(_g-P));for(y.push(_g);Q;){for(S=o=0,W=i-1;0<=W?o<=W:o>=W;S=0<=W?++o:--o)x[S]=0;for(w=a=0,X=I-1;0<=X?a<=X:a>=X;w=0<=X?++a:--a){for(et=it[w],E=Number.MAX_VALUE,S=s=0,q=i-1;0<=q?s<=q:s>=q;S=0<=q?++s:--s)_=zm(y[S]-et),_<E&&(E=_,v=S);x[v]++,g[w]=v}for(R=new Array(i),S=c=0,Y=i-1;0<=Y?c<=Y:c>=Y;S=0<=Y?++c:--c)R[S]=null;for(w=u=0,Z=I-1;0<=Z?u<=Z:u>=Z;w=0<=Z?++u:--u)b=g[w],null===R[b]?R[b]=it[w]:R[b]+=it[w];for(S=h=0,K=i-1;0<=K?h<=K:h>=K;S=0<=K?++h:--h)R[S]*=1/x[S];for(Q=!1,S=l=0,B=i-1;0<=B?l<=B:l>=B;S=0<=B?++l:--l)if(R[S]!==y[w]){Q=!0;break}y=R,L++,L>200&&(Q=!1)}for(A={},S=d=0,U=i-1;0<=U?d<=U:d>=U;S=0<=U?++d:--d)A[S]=[];for(w=f=0,j=I-1;0<=j?f<=j:f>=j;w=0<=j?++f:--f)b=g[w],A[b].push(it[w]);for(tt=[],S=p=0,$=i-1;0<=$?p<=$:p>=$;S=0<=$?++p:--p)tt.push(A[S][0]),tt.push(A[S][A[S].length-1]);for(tt=tt.sort(function(t,e){return t-e}),M.push(tt[0]),w=m=1,V=tt.length-1;m<=V;w=m+=2)isNaN(tt[w])||M.push(tt[w])}return M},ig=function(t,e,i){var n,r,o,a;return n=Xg(arguments),t=n[0],e=n[1],i=n[2],t/=360,t<1/3?(r=(1-e)/3,a=(1+e*Ym(Om*t)/Ym(Lm-Om*t))/3,o=1-(r+a)):t<2/3?(t-=1/3,a=(1-e)/3,o=(1+e*Ym(Om*t)/Ym(Lm-Om*t))/3,r=1-(a+o)):(t-=2/3,o=(1-e)/3,r=(1+e*Ym(Om*t)/Ym(Lm-Om*t))/3,a=1-(o+r)),a=vg(i*a*3),o=vg(i*o*3),r=vg(i*r*3),[255*a,255*o,255*r,n.length>3?n[3]:1]},Ig=function(){var t,e,i,n,r,o,a,s;return a=Xg(arguments),o=a[0],e=a[1],t=a[2],Om=2*Math.PI,o/=255,e/=255,t/=255,r=Math.min(o,e,t),n=(o+e+t)/3,s=1-r/n,0===s?i=0:(i=(o-e+(o-t))/2,i/=Math.sqrt((o-e)*(o-e)+(o-t)*(e-t)),i=Math.acos(i),t>e&&(i=Om-i),i/=Om),[360*i,s,n]},Hm.hsi=function(){return function(t,e,i){i.prototype=t.prototype;var n=new i,r=t.apply(n,e);return Object(r)===r?r:n}(Pm,Kg.call(arguments).concat(["hsi"]),function(){})},km.hsi=ig,Pm.prototype.hsi=function(){return Ig(this._rgb)},sg=function(t,e,i,n){var r,o,a,s,c,u,h,l,d,f,p,m,g;return"hsl"===n?(m=t.hsl(),g=e.hsl()):"hsv"===n?(m=t.hsv(),g=e.hsv()):"hsi"===n?(m=t.hsi(),g=e.hsi()):"lch"!==n&&"hcl"!==n||(n="hcl",m=t.hcl(),g=e.hcl()),"h"===n.substr(0,1)&&(a=m[0],f=m[1],u=m[2],s=g[0],p=g[1],h=g[2]),isNaN(a)||isNaN(s)?isNaN(a)?isNaN(s)?o=Number.NaN:(o=s,1!==u&&0!==u||"hsv"===n||(d=p)):(o=a,1!==h&&0!==h||"hsv"===n||(d=f)):(r=s>a&&s-a>180?s-(a+360):s<a&&a-s>180?s+360-a:s-a,o=a+i*r),null==d&&(d=f+i*(p-f)),c=u+i*(h-u),l=Hm[n](o,d,c)},Fm=Fm.concat(function(){var t,e,i,n;for(i=["hsv","hsl","hsi","hcl","lch"],n=[],e=0,t=i.length;e<t;e++)xg=i[e],n.push([xg,sg]);return n}()),ug=function(t,e,i,n){var r,o;return r=t.num(),o=e.num(),Hm.num(r+(o-r)*i,"num")},Fm.push(["num",ug]),cg=function(t,e,i,n){var r,o,a;return o=t.lab(),a=e.lab(),r=new Pm(o[0]+i*(a[0]-o[0]),o[1]+i*(a[1]-o[1]),o[2]+i*(a[2]-o[2]),n)},Fm.push(["lab",cg]);var Qg=Hm,Jg={H:16777215,HE:14286847,LI:13402367,BE:12779264,B:16758197,C:9474192,N:3166456,O:16715021,F:9494608,NE:11789301,NA:11230450,MG:9109248,AL:12560038,SI:1578e4,P:16744448,S:16777008,CL:2093087,AR:8442339,K:9388244,CA:4062976,SC:15132390,TI:12567239,V:10921643,CR:9083335,MN:10255047,FE:14706227,CO:15765664,NI:5296208,CU:13140019,ZN:8224944,GA:12750735,GE:6721423,AS:12419299,SE:16752896,BR:10889513,KR:6076625,RB:7351984,SR:65280,Y:9764863,ZR:9756896,NB:7586505,MO:5551541,TC:3907230,RU:2396047,RH:687500,PD:27013,AG:12632256,CD:16767375,IN:10909043,SN:6717568,SB:10380213,TE:13924864,I:9699476,XE:9699476,CS:5707663,BA:51456,LA:7394559,CE:16777159,PR:14286791,ND:13107143,PM:10747847,SM:9437127,EU:6422471,GD:4587463,TB:3211207,DY:2097095,HO:65436,ER:58997,TM:54354,YB:48952,LU:43812,HF:5096191,TA:5089023,W:2200790,RE:2522539,OS:2516630,IR:1528967,PT:13684960,AU:16765219,HG:12105936,TL:10900557,PB:5724513,BI:10375093,PO:11230208,AT:7688005,RN:4358806,FR:4325478,RA:32e3,AC:7384058,TH:47871,PA:41471,U:36863,NP:33023,PU:27647,AM:5528818,CM:7888099,BK:9064419,CF:10565332,ES:11739092,FM:11739066,MD:11734438,NO:12389767,LR:13041766,RF:13369433,DB:13697103,SG:14221381,BH:14680120,HS:15073326,MT:15400998,DS:16777215,RG:16777215,CN:16777215,UUT:16777215,FL:16777215,UUP:16777215,LV:16777215,UUH:16777215,D:16777152,T:16777120},tv=16777215,ev={ALA:9240460,ARG:124,ASN:16743536,ASP:10485826,CYS:16777072,GLN:16731212,GLU:6684672,GLY:16777215,HIS:7368959,ILE:19456,LEU:4546117,LYS:4671416,MET:12099650,PHE:5459026,PRO:5395026,SER:16740418,THR:12078080,TRP:5195264,TYR:9203788,VAL:16747775,ASX:16711935,GLX:16711935,ASH:16711935,GLH:16711935,A:10526975,G:16740464,I:8454143,C:16747595,T:10551200,U:16744576,DA:10526975,DG:16740464,DI:8454143,DC:16747595,DT:10551200,DU:16744576},iv=16711935,nv={alphaHelix:16711808,threeTenHelix:10485888,piHelix:6291584,betaStrand:16762880,betaTurn:6324479,coil:16777215,dna:11403518,rna:16580962,carbohydrate:10921722},rv=8421504;An.prototype={signals:{},scales:{"":"",OrRd:"[S] Orange-Red",PuBu:"[S] Purple-Blue",BuPu:"[S] Blue-Purple",Oranges:"[S] Oranges",BuGn:"[S] Blue-Green",YlOrBr:"[S] Yellow-Orange-Brown",YlGn:"[S] Yellow-Green",Reds:"[S] Reds",RdPu:"[S] Red-Purple",Greens:"[S] Greens",YlGnBu:"[S] Yellow-Green-Blue",Purples:"[S] Purples",GnBu:"[S] Green-Blue",Greys:"[S] Greys",YlOrRd:"[S] Yellow-Orange-Red",PuRd:"[S] Purple-Red",Blues:"[S] Blues",PuBuGn:"[S] Purple-Blue-Green",Spectral:"[D] Spectral",RdYlGn:"[D] Red-Yellow-Green",RdBu:"[D] Red-Blue",PiYG:"[D] Pink-Yellowgreen",PRGn:"[D] Purplered-Green",RdYlBu:"[D] Red-Yellow-Blue",BrBG:"[D] Brown-Bluegreen",RdGy:"[D] Red-Grey",PuOr:"[D] Purple-Orange",Set1:"[Q] Set1",Set2:"[Q] Set2",Set3:"[Q] Set3",Dark2:"[Q] Dark2",Paired:"[Q] Paired",Pastel1:"[Q] Pastel1",Pastel2:"[Q] Pastel2",Accent:"[Q] Accent",roygb:"[?] Rainbow",rwb:"[?] Red-White-Blue"},modes:{"":"",rgb:"Red Green Blue",hsv:"Hue Saturation Value",hsl:"Hue Saturation Lightness",hsi:"Hue Saturation Intensity",lab:"CIE L*a*b*",hcl:"Hue Chroma Lightness"},userSchemes:{},getScheme:function(t){var e,i=t||{},n=i.scheme||"";return new(e=n in An.types?An.types[n]:n in this.userSchemes?this.userSchemes[n]:Mn)(t)},getPickingScheme:function(t){var e=Object.assign(t||{});return e.scheme="picking",this.getScheme(e)},getTypes:function(){var t={};return Object.keys(An.types).forEach(function(e){t[e]=e}),Object.keys(this.userSchemes).forEach(function(e){t[e]=e.split("|")[1]}),t},getScales:function(){return this.scales},getModes:function(){return this.modes},addScheme:function(t,e){t instanceof Mn||(t=this.createScheme(t,e)),e=e||"";var i=""+Fp()+"|"+e;return this.userSchemes[i]=t,i},removeScheme:function(t){delete this.userSchemes[t]},createScheme:function(t,e){var i=function(i){Mn.call(this,i),this.label=e||"",t.call(this,i)};return i.prototype=Mn.prototype,i.prototype.constructor=Mn,i},addSelectionScheme:function(t,e){return this.addScheme(function(){var e=[],i=[];t.forEach(function(t){e.push(new Pt(t[0]).getHex()),i.push(new _n(t[1]))});var n=t.length;this.atomColor=function(t){for(var r=0;r<n;++r)if(i[r].test(t))return e[r];return 16777215}},e)}},Mn.prototype={constructor:Mn,getScale:function(t){var e=t||{},i=d(e.scale,this.scale);return"rainbow"===i||"roygb"===i?i=["red","orange","yellow","green","blue"]:"rwb"===i&&(i=["red","white","blue"]),Qg.scale(i).mode(d(e.mode,this.mode)).domain(d(e.domain,this.domain)).out("num")},colorToArray:function(t,e,i){return void 0===e&&(e=[]),void 0===i&&(i=0),e[i+0]=(t>>16&255)/255,e[i+1]=(t>>8&255)/255,e[i+2]=(255&t)/255,e},atomColor:function(){return 16777215},atomColorToArray:function(t,e,i){return this.colorToArray(this.atomColor(t),e,i)},bondColor:function(t,e){return this.atomProxy.index=e?t.atomIndex1:t.atomIndex2,this.atomColor(this.atomProxy)},bondColorToArray:function(t,e,i,n){return this.colorToArray(this.bondColor(t,e),i,n)},volumeColor:function(){return 16777215},volumeColorToArray:function(t,e,i){return this.colorToArray(this.volumeColor(t),e,i)},positionColor:function(){return 16777215},positionColorToArray:function(t,e,i){return this.colorToArray(this.positionColor(t),e,i)}},Cn.prototype=Mn.prototype,Cn.prototype.constructor=Cn,Pn.prototype=Mn.prototype,Pn.prototype.constructor=Pn,Tn.prototype=Mn.prototype,Tn.prototype.constructor=Tn,En.prototype=Mn.prototype,En.prototype.constructor=En,In.prototype=Mn.prototype,In.prototype.constructor=In,Ln.prototype=Mn.prototype,Ln.prototype.constructor=Ln,Rn.prototype=Mn.prototype,Rn.prototype.constructor=Rn,On.prototype=Mn.prototype,On.prototype.constructor=On,Dn.prototype=Mn.prototype,Dn.prototype.constructor=Dn,Nn.prototype=Mn.prototype,Nn.prototype.constructor=Nn,kn.prototype=Mn.prototype,kn.prototype.constructor=kn,Fn.prototype=Mn.prototype,Fn.prototype.constructor=Fn,zn.prototype=Mn.prototype,zn.prototype.constructor=zn,Bn.prototype=Mn.prototype,Bn.prototype.constructor=Bn,Un.prototype=Mn.prototype,Un.prototype.constructor=Un,jn.prototype=Mn.prototype,jn.prototype.constructor=jn,$n.prototype=Mn.prototype,$n.prototype.constructor=$n,Vn.prototype=Mn.prototype,Vn.prototype.constructor=Vn,Gn.prototype=Mn.prototype,Gn.prototype.constructor=Gn,Hn.prototype=Mn.prototype,Hn.prototype.constructor=Hn,An.types={"":Mn,picking:Tn,random:En,uniform:In,atomindex:Ln,residueindex:Rn,chainindex:On,chainname:Dn,chainid:Nn,entityindex:kn,modelindex:Fn,entitytype:zn,moleculetype:Bn,sstruc:Un,element:jn,resname:$n,bfactor:Vn,hydrophobicity:Hn,value:Pn,volume:Cn,occupancy:Gn};var ov=p(),av="undefined"!=typeof window&&"undefined"!=typeof window.orientation,sv=!1,cv=!1,uv={log:Function.prototype.bind.call(console.log,console),info:Function.prototype.bind.call(console.info,console),warn:Function.prototype.bind.call(console.warn,console),error:Function.prototype.bind.call(console.error,console),time:Function.prototype.bind.call(console.time,console),timeEnd:Function.prototype.bind.call(console.timeEnd,console)};t.Debug=l(h("debug"));var hv='<div style="display:flex;align-items:center;justify-content:center;height:100%;"><p style="padding:15px;text-align:center;">Your browser/graphics card does not seem to support <a target="_blank" href="https://en.wikipedia.org/wiki/WebGL">WebGL</a>.<br/><br/>Find out how to get it <a target="_blank" href="http://get.webgl.org/">here</a>.</p></div>',lv=new T,dv=new An,fv=new S("datasource"),pv=new S("representatation"),mv=new S("parser"),gv=new S("shader"),vv=new S("decompressor"),yv=new S("component");Yn.prototype={constructor:Yn,type:"",__srcName:void 0,isBinary:function(){return this.binary||this.compressed},onload:function(){},onprogress:function(){},onerror:function(){},read:function(t){this._read(function(e){var i=vv.get(this.compressed);this.compressed&&i?this.data=i(e):((this.binary||this.compressed)&&e instanceof ArrayBuffer&&(e=new Uint8Array(e)),this.data=e),"function"==typeof this.onload&&this.onload(this.data),t()}.bind(this))},_read:function(t){t(this.src)},_chunk:function(t,e){return e=Math.min(this.data.length,e),0===t&&this.data.length===e?this.data:this.isBinary()?this.data.subarray(t,e):this.data.substring(t,e)},chunk:function(t){var e=t+this.chunkSize;return this._chunk(t,e)},peekLines:function(t){var e,i=this.data,n=i.length,r=this.isBinary()?this.newline.charCodeAt(0):this.newline,o=0;for(e=0;e<n&&(i[e]===r&&++o,o!==t);++e);var a=this._chunk(0,e+1),s=this.chunkToLines(a,"",e>n);return s.lines},lineCount:function(){console.warn("lineCount - deprecated");for(var t=this.data,e=t.length,i=this.isBinary()?this.newline.charCodeAt(0):this.newline,n=0,r=0;r<e;++r)t[r]===i&&++n;return t[e-1]!==i&&++n,n},chunkCount:function(){return Math.floor(this.data.length/this.chunkSize)+1},asText:function(){return this.isBinary()?_(this.data):this.data},chunkToLines:function(t,e,i){var n=this.newline;if(!this.isBinary()&&t.length===this.data.length)return{lines:t.split(n),partialLine:""};var r=this.isBinary()?_(t):t,o=[],a=r.lastIndexOf(n);if(a===-1)e+=r;else{var s=e+r.substr(0,a);o=o.concat(s.split(n)),e=a===r.length-n.length?"":r.substr(a+n.length)}return i&&""!==e&&o.push(e),{lines:o,partialLine:e}},nextChunk:function(){var t=this.__pointer;if(!(t>this.data.length))return this.__pointer+=this.chunkSize,this.chunk(t)},nextChunkOfLines:function(){var t=this.nextChunk();if(void 0!==t){var e=this.__pointer>this.data.length,i=this.chunkToLines(t,this.__partialLine,e);return this.__partialLine=i.partialLine,i.lines}},eachChunk:function(t){for(var e=this.chunkSize,i=this.data.length,n=this.chunkCount(),r=0;r<i;r+=e){var o=this.chunk(r),a=Math.round(r/e);t(o,a,n)}},eachChunkOfLines:function(t){this.eachChunk(function(e,i,n){var r=i===n+1,o=this.chunkToLines(e,this.__partialLine,r);this.__partialLine=o.partialLine,t(o.lines,i,n)}.bind(this))},dispose:function(){delete this.src,this.__srcName&&delete this[this.__srcName]}},Zn.prototype=Object.assign(Object.create(Yn.prototype),{constructor:Zn,type:"file",__srcName:"file",_read:function(t){var e;if("function"==typeof importScripts){e=new FileReaderSync;var i;i=this.binary||this.compressed?e.readAsArrayBuffer(this.file):e.readAsText(this.file),t(i)}else e=new FileReader,e.onload=function(e){t(e.target.result)}.bind(this),"function"==typeof this.onprogress&&(e.onprogress=function(t){this.onprogress(t)}.bind(this)),"function"==typeof this.onerror&&(e.onerror=function(t){this.onerror(t)}.bind(this)),this.binary||this.compressed?e.readAsArrayBuffer(this.file):e.readAsText(this.file)}}),Kn.prototype=Object.assign(Object.create(Yn.prototype),{constructor:Kn,type:"network",__srcName:"url",_read:function(t){var e=this.src;"function"==typeof importScripts&&"../"===e.substr(0,3)&&(e="../"+e);var i=new XMLHttpRequest;i.open("GET",e,!0),i.addEventListener("load",function(){if(200!==i.status&&304!==i.status&&0!==i.status)throw"function"==typeof this.onerror&&this.onerror(i.status),"NetworkStreamer._read: status code "+i.status;t(i.response)}.bind(this),!1),"function"==typeof this.onerror&&i.addEventListener("error",function(t){this.onerror(t)}.bind(this),!1),this.isBinary()?i.responseType="arraybuffer":this.json?i.responseType="json":this.xml&&(i.responseType="document"),i.send(null)}}),Qn.prototype={constructor:Qn,load:function(){return new Promise(function(t,e){this.streamer.onerror=e;try{this._load(t,e)}catch(t){e(t)}}.bind(this))},_load:function(t,e){e("not implemented")}},Jn.prototype=Object.assign(Object.create(Qn.prototype),{constructor:Jn,_load:function(t){var e=mv.get(this.ext),i=new e(this.streamer,this.params);i.parse(t)}}),tr.prototype={constructor:tr,type:"Script",call:function(t,e){function i(){"function"==typeof e&&e()}function n(){uv.error("Script: Error executing script"),i()}var r={add:function(){this.signals.elementAdded.dispatch(arguments)}.bind(this),remove:function(){this.signals.elementRemoved.dispatch(arguments)}.bind(this),setName:function(t){this.signals.nameChanged.dispatch(t)}.bind(this)};if(this.fn){var o=[t,r,this.name,this.path,this.dir];try{this.fn.apply(null,o),i()}catch(t){uv.error("Script.fn",t),n()}}else uv.log("Script.call no function available"),i()}},er.prototype=Object.assign(Object.create(Qn.prototype),{constructor:er,_load:function(t){this.streamer.read(function(){var e=this.streamer.asText(),i=new tr(e,this.name,this.path);t(i)}.bind(this))}}),ir.prototype=Object.assign(Object.create(Qn.prototype),{constructor:ir,_load:function(t){var e;e=this.protocol?this.protocol+"://"+this.dir:this.dir,this.streamer.read(function(){var i=JSON.parse(this.streamer.asText()),n=[];i.files.map(function(t){n.push(rr(e+t,{ext:"text",useWorker:!1}))}),Promise.all(n).then(function(e){var n=e.reduce(function(t,e){return t+"\n\n"+e.data},"");n+=i.source||"";var r=new tr(n,this.name,this.path);t(r)}.bind(this))}.bind(this))}});var bv={not_string:/[^s]/,not_bool:/[^t]/,not_type:/[^T]/,not_primitive:/[^v]/,number:/[diefg]/,numeric_arg:/bcdiefguxX/,json:/[j]/,not_json:/[^j]/,text:/^[^\x25]+/,modulo:/^\x25{2}/,placeholder:/^\x25(?:([1-9]\d*)\$|\(([^\)]+)\))?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-gijostTuvxX])/,key:/^([a-z_][a-z_\d]*)/i,key_access:/^\.([a-z_][a-z_\d]*)/i,index_access:/^\[(\d+)\]/,sign:/^[\+\-]/};or.format=function(t,e){var i,n,r,o,a,s,c,u=1,h=t.length,l="",d=[],f=!0,p="";for(n=0;n<h;n++)if(l=ar(t[n]),"string"===l)d[d.length]=t[n];else if("array"===l){if(o=t[n],o[2])for(i=e[u],r=0;r<o[2].length;r++){if(!i.hasOwnProperty(o[2][r]))throw new Error(or('[sprintf] property "%s" does not exist',o[2][r]));i=i[o[2][r]]}else i=o[1]?e[o[1]]:e[u++];if(bv.not_type.test(o[8])&&bv.not_primitive.test(o[8])&&"function"==ar(i)&&(i=i()),bv.numeric_arg.test(o[8])&&"number"!=ar(i)&&isNaN(i))throw new TypeError(or("[sprintf] expecting number but found %s",ar(i)));switch(bv.number.test(o[8])&&(f=i>=0),o[8]){case"b":i=parseInt(i,10).toString(2);break;case"c":i=String.fromCharCode(parseInt(i,10));break;case"d":case"i":i=parseInt(i,10);break;case"j":i=JSON.stringify(i,null,o[6]?parseInt(o[6]):0);break;case"e":i=o[7]?parseFloat(i).toExponential(o[7]):parseFloat(i).toExponential();break;case"f":i=o[7]?parseFloat(i).toFixed(o[7]):parseFloat(i);break;case"g":i=o[7]?parseFloat(i).toPrecision(o[7]):parseFloat(i);break;case"o":i=i.toString(8);break;case"s":i=String(i),i=o[7]?i.substring(0,o[7]):i;break;case"t":i=String(!!i),i=o[7]?i.substring(0,o[7]):i;break;case"T":i=ar(i),i=o[7]?i.substring(0,o[7]):i;break;case"u":i=parseInt(i,10)>>>0;break;case"v":i=i.valueOf(),i=o[7]?i.substring(0,o[7]):i;break;case"x":i=parseInt(i,10).toString(16);break;case"X":i=parseInt(i,10).toString(16).toUpperCase()}bv.json.test(o[8])?d[d.length]=i:(!bv.number.test(o[8])||f&&!o[3]?p="":(p=f?"+":"-",i=i.toString().replace(bv.sign,"")),s=o[4]?"0"===o[4]?"0":o[4].charAt(1):" ",c=o[6]-(p+i).length,a=o[6]&&c>0?sr(s,c):"",d[d.length]=o[5]?p+i+a:"0"===s?p+a+i:a+p+i)}return d.join("")},or.cache={},or.parse=function(t){for(var e=t,i=[],n=[],r=0;e;){if(null!==(i=bv.text.exec(e)))n[n.length]=i[0];else if(null!==(i=bv.modulo.exec(e)))n[n.length]="%";else{if(null===(i=bv.placeholder.exec(e)))throw new SyntaxError("[sprintf] unexpected placeholder");if(i[2]){r|=1;var o=[],a=i[2],s=[];if(null===(s=bv.key.exec(a)))throw new SyntaxError("[sprintf] failed to parse named argument key");for(o[o.length]=s[1];""!==(a=a.substring(s[0].length));)if(null!==(s=bv.key_access.exec(a)))o[o.length]=s[1];else{if(null===(s=bv.index_access.exec(a)))throw new SyntaxError("[sprintf] failed to parse named argument key");o[o.length]=s[1]}i[2]=o}else r|=2;if(3===r)throw new Error("[sprintf] mixing positional and named placeholders is not (yet) supported");n[n.length]=i}e=e.substring(i[0].length)}return n};var xv={0:["","0","00","000","0000","00000","000000","0000000"]," ":[""," ","  ","   ","    ","     ","      ","       "],_:["","_","__","___","____","_____","______","_______"]};ur.prototype={clear:function(){this.change(-this.count)},change:function(t){this.count+=t,this.signals.countChanged.dispatch(t,this.count),this.count<0&&uv.warn("Counter.count below zero",this.count)},increment:function(){this.change(1)},decrement:function(){this.change(-1)},listen:function(t){this.change(t.count),t.signals.countChanged.add(this.change,this)},unlisten:function(t){var e=t.signals.countChanged;e.has(this.change,this)&&e.remove(this.change,this)},onZeroOnce:function(t,e){if(0===this.count)t.call(e,0,0);else{var i=function(){0===this.count&&(this.signals.countChanged.remove(i,this),t.apply(e,arguments))};this.signals.countChanged.add(i,this)}},dispose:function(){this.clear(),this.signals.countChanged.dispose()}},hr.prototype={constructor:hr,getBaseObject:function(t){return"StructureView"===t.type&&(t=t.getStructure()),t},addObject:function(t){t=this.getBaseObject(t);var e=this.allocateGidRange(t);return e&&(this.objectList.push(t),this.rangeList.push(e)),this},removeObject:function(t){t=this.getBaseObject(t);var e=this.objectList.indexOf(t);return e!==-1&&(this.objectList.splice(e,1),this.rangeList.splice(e,1),0===this.objectList.length&&(this.nextGid=1)),this},updateObject:function(t,e){t=this.getBaseObject(t);var i=this.objectList.indexOf(t);if(i!==-1){var n=this.rangeList[i];if(n[1]===this.nextGid){var r=this.getGidCount(t);this.nextGid+=r-(n[1]-n[0]),n[1]=this.nextGid}else this.rangeList[i]=this.allocateGidRange(t)}else e||uv.warn("GidPool.updateObject: object not found.");return this},getGidCount:function(t){t=this.getBaseObject(t);var e=0;return"Structure"===t.type?e=t.atomStore.count+t.bondStore.count+t.backboneBondStore.count+t.rungBondStore.count:"Volume"===t.type?e=t.__data.length:uv.warn("GidPool.getGidCount: unknown object type"),e},allocateGidRange:function(t){t=this.getBaseObject(t);var e=this.getGidCount(t);if(e>Math.pow(10,7))return uv.warn("GidPool.allocateGidRange: gidCount too large"),null;var i=this.nextGid;return this.nextGid+=e,this.nextGid>Math.pow(2,24)&&uv.error("GidPool.allocateGidRange: GidPool overflown"),[i,this.nextGid]},getNextGid:function(){return this.nextGid++},getGid:function(t,e){t=this.getBaseObject(t),e=e||0;var i=0,n=this.objectList.indexOf(t);if(n!==-1){var r=this.rangeList[n],o=r[0];i=o+e}else uv.warn("GidPool.getGid: object not found.");return i},getByGid:function(t){var e;return this.objectList.forEach(function(i,n){var r=this.rangeList[n];if(!(t<r[0]||t>=r[1])){var o=t-r[0];"Structure"===i.type?o<i.atomStore.count?e=i.getAtomProxy(o):o<i.atomStore.count+i.bondStore.count?(o-=i.atomStore.count,e=i.getBondProxy(o)):o<i.atomStore.count+i.bondStore.count+i.backboneBondStore.count?(o-=i.atomStore.count+i.bondStore.count,e=i.getBondProxy(o),e.bondStore=i.backboneBondStore):o<i.atomStore.count+i.bondStore.count+i.backboneBondStore.count+i.rungBondStore.count?(o-=i.atomStore.count+i.bondStore.count+i.backboneBondStore.count,e=i.getBondProxy(o),e.bondStore=i.rungBondStore):uv.warn("GidPool.getByGid: invalid Structure gid",t):"Volume"===i.type?e={volume:i,index:o,value:i.data[o],x:i.dataPosition[3*o],y:i.dataPosition[3*o+1],z:i.dataPosition[3*o+2]}:uv.warn("GidPool.getByGid: unknown object type for gid",t)}},this),e}},gv.add("shader/BasicLine.vert","void main(){\n#include begin_vertex\n#include project_vertex\n}"),gv.add("shader/BasicLine.frag","uniform vec3 uColor;\n#include common\n#include fog_pars_fragment\nvoid main(){\ngl_FragColor = vec4( uColor, 1.0 );\n#include premultiplied_alpha_fragment\n#include tonemapping_fragment\n#include encodings_fragment\n#include fog_fragment\n}"),gv.add("shader/Quad.vert","varying vec2 vUv;\nvoid main() {\nvUv = uv;\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}"),gv.add("shader/Quad.frag","varying vec2 vUv;\nuniform sampler2D tForeground;\nuniform float scale;\nvoid main() {\nvec4 foreground = texture2D( tForeground, vUv );\ngl_FragColor = foreground * scale;\n}"),lr.prototype={update:function(){this.startTime=this.end(),this.signals.updated.dispatch()},begin:function(){this.startTime=performance.now(),this.lastFrames=this.frames},end:function(){var t=performance.now();return this.count+=1,this.frames+=1,this.lastDuration=t-this.startTime,this.minDuration=Math.min(this.minDuration,this.lastDuration),this.maxDuration=Math.max(this.maxDuration,this.lastDuration),this.avgDuration-=this.avgDuration/30,this.avgDuration+=this.lastDuration/30,t>this.prevFpsTime+1e3&&(this.lastFps=this.frames,this.prevFpsTime=t,this.frames=0),t}},dr.prototype=Object.create(E.prototype),dr.prototype.constructor=dr,gv.add("shader/chunk/dull_interior_fragment.glsl","#ifdef DULL_INTERIOR\nif( gl_FrontFacing == false ){\nnormal = vec3( 0.0, 0.0, 0.4 );\n}\n#endif"),gv.add("shader/chunk/fog_fragment.glsl","#ifdef USE_FOG\nfloat depth = length( vViewPosition );\n#ifdef FOG_EXP2\nfloat fogFactor = whiteCompliment( exp2( - fogDensity * fogDensity * depth * depth * LOG2 ) );\n#else\nfloat fogFactor = smoothstep( fogNear, fogFar, depth );\n#endif\ngl_FragColor.rgb = mix( gl_FragColor.rgb, fogColor, fogFactor );\n#endif"),gv.add("shader/chunk/nearclip_vertex.glsl","#ifdef NEAR_CLIP\nif( vViewPosition.z < nearClip - 5.0 )\ngl_Position.z = 2.0 * gl_Position.w;\n#endif"),gv.add("shader/chunk/nearclip_fragment.glsl","#ifdef NEAR_CLIP\nif( vViewPosition.z < nearClip )\ndiscard;\n#endif"),gv.add("shader/chunk/radiusclip_vertex.glsl","#ifdef RADIUS_CLIP\nif( distance( vViewPosition, vClipCenter ) > clipRadius + 5.0 )\ngl_Position.z = 2.0 * gl_Position.w;\n#endif"),gv.add("shader/chunk/radiusclip_fragment.glsl","#ifdef RADIUS_CLIP\nif( distance( vViewPosition, vClipCenter ) > clipRadius )\ndiscard;\n#endif"),gv.add("shader/chunk/opaque_back_fragment.glsl","#ifdef OPAQUE_BACK\n#ifdef FLIP_SIDED\nif( gl_FrontFacing == true ){\ngl_FragColor.a = 1.0;\n}\n#else\nif( gl_FrontFacing == false ){\ngl_FragColor.a = 1.0;\n}\n#endif\n#endif");var _v=/^(?!\/\/)\s*#include\s+(\S+)/gim,wv={};mr.prototype.constructor=mr;var Sv=2*Math.PI,Av=new N,Mv=new O,Cv=new O,Pv=new O,Tv=new O;WebGLRenderingContext&&(WebGLRenderingContext.prototype.getShaderParameter=function(){var e=WebGLRenderingContext.prototype.getShaderParameter;return function(){return!t.Debug||e.apply(this,arguments)}}(),WebGLRenderingContext.prototype.getShaderInfoLog=function(){var e=WebGLRenderingContext.prototype.getShaderInfoLog;return function(){return t.Debug?e.apply(this,arguments):""}}(),WebGLRenderingContext.prototype.getProgramParameter=function(){var e=WebGLRenderingContext.prototype.getProgramParameter;return function(i,n){return!t.Debug&&n===WebGLRenderingContext.prototype.LINK_STATUS||e.apply(this,arguments)}}(),WebGLRenderingContext.prototype.getProgramInfoLog=function(){var e=WebGLRenderingContext.prototype.getProgramInfoLog;return function(){return t.Debug?e.apply(this,arguments):""}}());var Ev=[[[0,0]],[[4,4],[-4,-4]],[[-2,-6],[6,-2],[-6,2],[2,6]],[[1,-3],[-1,3],[5,1],[-3,-5],[-5,5],[-7,-1],[3,7],[7,-7]],[[1,1],[-1,-3],[-3,2],[4,-1],[-5,-2],[2,5],[5,3],[3,-5],[-2,6],[0,-7],[-4,-6],[-6,4],[-8,0],[7,-4],[6,7],[-7,-8]],[[-4,-7],[-7,-5],[-3,-5],[-5,-4],[-1,-4],[-2,-2],[-6,-1],[-4,0],[-7,1],[-1,2],[-6,3],[-3,3],[-7,6],[-3,6],[-5,7],[-1,7],[5,-7],[1,-6],[6,-5],[4,-4],[2,-3],[7,-2],[1,-1],[4,-1],[2,1],[6,2],[0,4],[4,4],[2,5],[7,5],[5,6],[3,7]]];Ev.forEach(function(t){t.forEach(function(t){t[0]*=.0625,t[1]*=.0625})}),Tr.prototype.constructor=Tr;var Iv=2,Lv=3,Rv=function(e,i){function n(t){var e=Object.assign({},t);c=d(e.hoverTimeout,c)}function r(t,e){var i,n,r,o=a.pick(t.canvasPosition.x,t.canvasPosition.y),c=o.instance,u=s.getByGid(o.gid);return u&&"AtomProxy"===u.type?i=u:u&&"BondProxy"===u.type?n=u:u&&"Volume"===u.volume.type&&(r=u),(i||n||r)&&t.which===Iv&&e&&(i?h.copy(i):n?h.copy(n.atom1).add(n.atom2).multiplyScalar(.5):r&&h.copy(r),c&&h.applyProjection(c.matrix),a.centerView(!1,h)),{atom:i,bond:n,volume:r,instance:c}}function o(){if(performance.now()-l.lastMoved>c&&(l.moving=!1),!l.moving&&!l.hovering){l.hovering=!0;var t=r(l);u.hovered.dispatch(t)}requestAnimationFrame(o)}var a=e.viewer,s=e.gidPool,c=50;n(i);var u={clicked:new xn,hovered:new xn},h=new N,l={position:new I,down:new I,canvasPosition:new I,moving:!1,hovering:!0,lastMoved:1/0,which:void 0,distance:function(){return l.position.distanceTo(l.down)},setCanvasPosition:function(t){var e=a.renderer.domElement.getBoundingClientRect(),i=t.clientX-e.left,n=t.clientY-e.top;l.canvasPosition.set(i,e.height-n)}
	};o(),a.renderer.domElement.addEventListener("mousemove",function(t){t.preventDefault(),l.moving=!0,l.hovering=!1,l.lastMoved=performance.now(),l.position.set(t.layerX,t.layerY),l.setCanvasPosition(t)}),a.renderer.domElement.addEventListener("mousedown",function(t){t.preventDefault(),l.moving=!1,l.hovering=!1,l.down.set(t.layerX,t.layerY),l.which=t.which,l.setCanvasPosition(t)}),a.renderer.domElement.addEventListener("mouseup",function(e){if(e.preventDefault(),!(l.distance()>3||e.which===Lv)){var i=r(l,!0);l.which=void 0,u.clicked.dispatch(i),t.Debug&&uv.log("clicked",i)}}),this.signals=u,this.setParameters=n};Er.prototype.add=function(t){this.count<<5<=t&&this.resize(t),this.words[t>>>5]|=1<<t},Er.prototype.add_unsafe=function(t){this.words[t>>>5]|=1<<t},Er.prototype.flip=function(t){this.count<<5<=t&&this.resize(t),this.words[t>>>5]^=1<<t},Er.prototype.flip_unsafe=function(t){this.words[t>>>5]^=1<<t},Er.prototype.flip_all=function(){for(var t=this.count,e=0;e+7<t;e+=8)this.words[e]=~this.words[e],this.words[e+1]=~this.words[e+1],this.words[e+2]=~this.words[e+2],this.words[e+3]=~this.words[e+3],this.words[e+4]=~this.words[e+4],this.words[e+5]=~this.words[e+5],this.words[e+6]=~this.words[e+6],this.words[e+7]=~this.words[e+7];for(;e<t;++e)this.words[e]=~this.words[e];return this},Er.prototype.set_all=function(t){return this.length<=0?this:(this.set_range(0,this.length-1,t),this)},Er.prototype.set_range=function(t,e,i){i=i?4294967295:0;for(var n=(t>>>5)+1,r=(e>>>5)-1,o=0|n;o+7<r;o+=8)this.words[o]=i,this.words[o+1]=i,this.words[o+2]=i,this.words[o+3]=i,this.words[o+4]=i,this.words[o+5]=i,this.words[o+6]=i,this.words[o+7]=i;for(;o<r;++o)this.words[o]=i;var a,s;if(i){for(a=t,s=(n<<5)+1;a<s;++a)this.words[a>>>5]|=1<<a;for(a=r<<5,s=e+1;a<s;++a)this.words[a>>>5]|=1<<a}else{for(a=t,s=(n<<5)+1;a<s;++a)this.words[a>>>5]&=~(1<<a);for(a=r<<5,s=e+1;a<s;++a)this.words[a>>>5]&=~(1<<a)}return this},Er.prototype.clear=function(){return this.count=0,this.length=0,this.words=new Uint32Array(this.count),this},Er.prototype.remove=function(t){this.count<<5<=t&&this.resize(t),this.words[t>>>5]&=~(1<<t)},Er.prototype.remove_unsafe=function(t){this.words[t>>>5]&=~(1<<t)},Er.prototype.isEmpty=function(){for(var t=this.count,e=0;e<t;e++)if(0!==this.words[e])return!1;return!0},Er.prototype.has=function(t){return 0!==(this.words[t>>>5]&1<<t)},Er.prototype.trim=function(){for(;this.count>0;)0===this.words[this.count-1]&&this.count--;this.words=this.words.slice(0,this.count)},Er.prototype.resize=function(t){if(this.length=t,!(this.count<<5>t)&&(this.count=t+32>>>5,this.words.length<<5<=t)){var e=new Uint32Array(this.count<<1);e.set(this.words),this.words=e}},Er.prototype.hammingWeight=function(t){return t-=t>>>1&1431655765,t=(858993459&t)+(t>>>2&858993459),16843009*(t+(t>>>4)&252645135)>>>24},Er.prototype.size=function(){for(var t=0,e=this.count,i=0;i<e;i++)t+=this.hammingWeight(0|this.words[i]);return Math.min(t,this.length)},Er.prototype.sizeRange=function(t,e){var i=0,n=t+e;return this.forEach(function(e){e>=t&&e<n&&++i}),i},Er.prototype.array=function(){for(var t=new Array(this.size()),e=0,i=0|this.count,n=0;n<i;++n)for(var r=this.words[n];0!==r;){var o=r&-r;t[e++]=(n<<5)+this.hammingWeight(o-1|0),r^=o}return t},Er.prototype.forEach=function(t){for(var e=0|this.count,i=0,n=0;n<e;++n)for(var r=this.words[n];0!==r;){var o=r&-r,a=(n<<5)+this.hammingWeight(o-1|0);a<this.length&&t(a,i),r^=o,i+=1}},Er.forEach=function(t,e,i){for(var n=0|Math.min(e.count,i.count),r=0;r<n;++r)for(var o=e.words[r],a=i.words[r];0!==o&&0!==a;){var s=o&-o,c=a&-a,u=r<<5;t(u+e.hammingWeight(s-1|0),u+i.hammingWeight(c-1|0)),o^=s,a^=c}},Er.prototype.clone=function(){var t=Object.create(Er.prototype);return t.count=this.count,t.length=this.length,t.words=new Uint32Array(this.words),t},Er.prototype.intersects=function(t){for(var e=Math.min(this.count,t.count),i=0;i<e;++i)if(0!==(this.words[i]&t.words[i]))return!0;return!1},Er.prototype.intersection=function(t){for(var e=Math.min(this.count,t.count),i=0;i+7<e;i+=8)this.words[i]&=t.words[i],this.words[i+1]&=t.words[i+1],this.words[i+2]&=t.words[i+2],this.words[i+3]&=t.words[i+3],this.words[i+4]&=t.words[i+4],this.words[i+5]&=t.words[i+5],this.words[i+6]&=t.words[i+6],this.words[i+7]&=t.words[i+7];for(;i<e;++i)this.words[i]&=t.words[i];var n=this.count;for(i=e;i<n;++i)this.words[i]=0;return this.count=e,this},Er.prototype.intersection_size=function(t){for(var e=Math.min(this.count,t.count),i=0,n=0;n<e;++n)i+=this.hammingWeight(this.words[n]&t.words[n]);return i},Er.prototype.new_intersection=function(t){var e=Object.create(Er.prototype);e.count=Math.min(this.count,t.count),e.words=new Uint32Array(e.count),e.length=Math.min(this.length,t.length);for(var i=e.count,n=0;n<i;++n)e.words[n]=this.words[n]&t.words[n];return e},Er.prototype.equals=function(t){var e,i,n=Math.min(this.count,t.count);for(e=0;e<n;++e)if(this.words[e]!=t.words[e])return!1;if(this.count<t.count){for(i=t.count,e=this.count;e<i;++e)if(0!==t.words[e])return!1}else if(t.count<this.count)for(i=this.count,e=t.count;e<i;++e)if(0!==this.words[e])return!1;return!0},Er.prototype.difference=function(t){for(var e=Math.min(this.count,t.count),i=0;i+7<e;i+=8)this.words[i]&=~t.words[i],this.words[i+1]&=~t.words[i+1],this.words[i+2]&=~t.words[i+2],this.words[i+3]&=~t.words[i+3],this.words[i+4]&=~t.words[i+4],this.words[i+5]&=~t.words[i+5],this.words[i+6]&=~t.words[i+6],this.words[i+7]&=~t.words[i+7];for(;i<e;++i)this.words[i]&=~t.words[i];return this},Er.prototype.difference_size=function(t){for(var e=Math.min(this.count,t.count),i=0,n=0;n<e;++n)i+=this.hammingWeight(this.words[n]&~t.words[n]);for(var r=this.count;n<r;++n)i+=this.hammingWeight(this.words[n]);return i},Er.prototype.toString=function(){return"{"+this.array().join(",")+"}"},Er.prototype.union=function(t){for(var e=Math.min(this.count,t.count),i=0;i+7<e;i+=8)this.words[i]|=t.words[i],this.words[i+1]|=t.words[i+1],this.words[i+2]|=t.words[i+2],this.words[i+3]|=t.words[i+3],this.words[i+4]|=t.words[i+4],this.words[i+5]|=t.words[i+5],this.words[i+6]|=t.words[i+6],this.words[i+7]|=t.words[i+7];for(;i<e;++i)this.words[i]|=t.words[i];if(this.count<t.count){this.resize((t.count<<5)-1);var n=t.count;for(i=e;i<n;++i)this.words[i]=t.words[i];this.count=t.count}return this},Er.prototype.new_union=function(t){var e=Object.create(Er.prototype);e.count=Math.max(this.count,t.count),e.words=new Uint32Array(e.count);var i,n=Math.min(this.count,t.count);for(i=0;i<n;++i)e.words[i]=this.words[i]|t.words[i];var r=this.count;for(i=n;i<r;++i)e.words[i]=this.words[i];var o=t.count;for(i=n;i<o;++i)e.words[i]=t.words[i];return e},Er.prototype.new_difference=function(t){return this.clone().difference(t)},Er.prototype.union_size=function(t){var e,i,n=Math.min(this.count,t.count),r=0;for(e=0;e<n;++e)r+=this.hammingWeight(this.words[e]|t.words[e]);if(this.count<t.count)for(i=t.count,e=this.count;e<i;++e)r+=this.hammingWeight(0|t.words[e]);else for(i=this.count,e=t.count;e<i;++e)r+=this.hammingWeight(0|this.words[e]);return r},Er.prototype.getTransferable=function(){return[this.words]},Er.prototype.toJSON=function(){return{count:this.count,length:this.length,words:this.words}},Er.prototype.fromJSON=function(t){return this.count=t.count,this.length=t.length,this.words=t.words,this},Er.prototype.toSeleString=function(){var t=this.array().join(",");return t?"@"+t:"NONE"},Er.prototype.type="Bitset";var Ov=Er;Ir.prototype={constructor:Ir,atomRadius:function(t){var e,i=this.type,n=this.scale;switch(i){case"vdw":e=hm[t.element]||lm;break;case"covalent":e=dm[t.element]||fm;break;case"bfactor":e=t.bfactor||1;break;case"sstruc":var r=t.sstruc;e="h"===r?.25:"g"===r?.25:"i"===r?.25:"e"===r?.25:"b"===r?.25:Mm.includes(t.atomname)?.4:.1;break;default:e=i||1}return Math.min(e*n,this.max)}},Ir.types={"":"",vdw:"by vdW radius",covalent:"by covalent radius",sstruc:"by secondary structure",bfactor:"by bfactor",size:"size"},$r.__deps=[Vr],Gr.__deps=[Vr,jr],Zr.prototype={copyTo:function(t){t.data.set(this.data)}};var Dv=1.192092896e-7,Nv=1e-37;po.__deps=[lo],mo.__deps=[lo],go.__deps=[lo],yo.__deps=[Fr,zr],_o.prototype={constructor:_o,type:"Store",init:function(t){this.length=t,this.count=0;for(var e=0,i=this.__fields.length;e<i;++e){var n=this.__fields[e][0],r=this.__fields[e][1],o=this.__fields[e][2],a=this.length*r;switch(o){case"int8":this[n]=new Int8Array(a);break;case"int16":this[n]=new Int16Array(a);break;case"int32":this[n]=new Int32Array(a);break;case"uint8":this[n]=new Uint8Array(a);break;case"uint16":this[n]=new Uint16Array(a);break;case"uint32":this[n]=new Uint32Array(a);break;case"float32":this[n]=new Float32Array(a);break;default:uv.warn("arrayType unknown: "+o)}}},resize:function(t){this.length=Math.round(t||0),this.count=Math.min(this.count,this.length);for(var e=0,i=this.__fields.length;e<i;++e){var n=this.__fields[e][0],r=this.__fields[e][1],o=this.length*r,a=new this[n].constructor(o);this[n].length>o?a.set(this[n].subarray(0,o)):a.set(this[n]),this[n]=a}},growIfFull:function(){if(this.count>=this.length){var t=Math.round(1.5*this.length);this.resize(Math.max(256,t))}},copyFrom:function(t,e,i,n){for(var r=0,o=this.__fields.length;r<o;++r)for(var a=this.__fields[r][0],s=this.__fields[r][1],c=this[a],u=t[a],h=0;h<n;++h)for(var l=s*(e+h),d=s*(i+h),f=0;f<s;++f)c[l+f]=u[d+f]},copyWithin:function(t,e,i){for(var n=0,r=this.__fields.length;n<r;++n)for(var o=this.__fields[n][0],a=this.__fields[n][1],s=this[o],c=0;c<i;++c)for(var u=a*(t+c),h=a*(e+c),l=0;l<a;++l)s[u+l]=s[h+l]},sort:function(t){function e(t,e){t!==e&&(r.copyFrom(n,0,t,1),n.copyWithin(t,e,1),n.copyFrom(r,e,0,1))}function i(n,r){if(n<r){var o=Math.floor((n+r)/2),a=n,s=r;do{for(;t(a,o)<0;)a+=1;for(;t(s,o)>0;)s-=1;a<=s&&(a===o?o=s:s===o&&(o=a),e(a,s),a+=1,s-=1)}while(a<=s);i(n,s),i(a,r)}}uv.time("Store.sort");var n=this,r=new this.constructor(1);i(0,this.count-1),uv.timeEnd("Store.sort")},clear:function(){this.count=0},dispose:function(){delete this.length,delete this.count;for(var t=0,e=this.__fields.length;t<e;++t){var i=this.__fields[t][0];delete this[i]}}},wo.prototype=Object.assign(Object.create(_o.prototype),{constructor:wo,type:"BondStore",__fields:[["atomIndex1",1,"int32"],["atomIndex2",1,"int32"],["bondOrder",1,"int8"]],addBond:function(t,e,i){this.growIfFull();var n=this.count,r=t.index,o=e.index;r<o?(this.atomIndex1[n]=r,this.atomIndex2[n]=o):(this.atomIndex2[n]=r,this.atomIndex1[n]=o),i&&(this.bondOrder[n]=i),this.count+=1},addBondIfConnected:function(t,e,i){return!!t.connectedTo(e)&&(this.addBond(t,e,i),!0)}}),So.prototype=Object.assign(Object.create(_o.prototype),{constructor:So,type:"AtomStore",__fields:[["residueIndex",1,"uint32"],["atomTypeId",1,"uint16"],["x",1,"float32"],["y",1,"float32"],["z",1,"float32"],["serial",1,"int32"],["bfactor",1,"float32"],["altloc",1,"uint8"],["occupancy",1,"float32"]],setAltloc:function(t,e){this.altloc[t]=e.charCodeAt(0)},getAltloc:function(t){var e=this.altloc[t];return e?String.fromCharCode(e):""}}),Ao.prototype=Object.assign(Object.create(_o.prototype),{constructor:Ao,type:"ResidueStore",__fields:[["chainIndex",1,"uint32"],["atomOffset",1,"uint32"],["atomCount",1,"uint16"],["residueTypeId",1,"uint16"],["resno",1,"int32"],["sstruc",1,"uint8"],["inscode",1,"uint8"]],setSstruc:function(t,e){this.sstruc[t]=e.charCodeAt(0)},getSstruc:function(t){var e=this.sstruc[t];return e?String.fromCharCode(e):""},setInscode:function(t,e){this.inscode[t]=e.charCodeAt(0)},getInscode:function(t){var e=this.inscode[t];return e?String.fromCharCode(e):""}}),Mo.prototype=Object.assign(Object.create(_o.prototype),{constructor:Mo,type:"ChainStore",__fields:[["entityIndex",1,"uint16"],["modelIndex",1,"uint16"],["residueOffset",1,"uint32"],["residueCount",1,"uint32"],["chainname",4,"uint8"],["chainid",4,"uint8"]],setChainname:function(t,e){var i=4*t;this.chainname[i]=e.charCodeAt(0),this.chainname[i+1]=e.charCodeAt(1),this.chainname[i+2]=e.charCodeAt(2),this.chainname[i+3]=e.charCodeAt(3)},getChainname:function(t){for(var e="",i=0;i<4;++i){var n=this.chainname[4*t+i];if(!n)break;e+=String.fromCharCode(n)}return e},setChainid:function(t,e){var i=4*t;this.chainid[i]=e.charCodeAt(0),this.chainid[i+1]=e.charCodeAt(1),this.chainid[i+2]=e.charCodeAt(2),this.chainid[i+3]=e.charCodeAt(3)},getChainid:function(t){for(var e="",i=0;i<4;++i){var n=this.chainid[4*t+i];if(!n)break;e+=String.fromCharCode(n)}return e}}),Co.prototype=Object.assign(Object.create(_o.prototype),{constructor:Co,type:"ModelStore",__fields:[["chainOffset",1,"uint32"],["chainCount",1,"uint32"]]}),Po.prototype={constructor:Po,getCenterIterator:function(t){function e(){var t=this.get(s);return s+=1,t}function i(e){e=Math.min(o-1,Math.max(0,e));var i=c[a%4],n=3*e;if(i.fromArray(r,n),t){var s,u,h,l=Math.min(t,e,o-e-1);for(u=1;u<=l;++u)s=3*u,h=(l+1-u)/(l+1),i.x+=h*r[n-s+0]+h*r[n+s+0],i.y+=h*r[n-s+1]+h*r[n+s+1],i.z+=h*r[n-s+2]+h*r[n+s+2];i.x/=l+1,i.y/=l+1,i.z/=l+1}return a+=1,i}function n(){a=0,s=-1}var r=this.getPosition().center,o=r.length/3,a=0,s=-1,c=[new N,new N,new N,new N];return{size:o,next:e,get:i,reset:n}},getColor:function(t){var e=this.polymer,i=e.structure,n=e.residueCount,r=e.residueIndexStart,o=new Float32Array(3*n),a=new Float32Array(3*n),s=t||{};s.structure=i;for(var c=dv.getScheme(s),u=dv.getPickingScheme(s),h=i.getResidueProxy(),l=i.getAtomProxy(),d=0;d<n;++d){h.index=r+d,l.index=h.traceAtomIndex;var f=3*d;c.atomColorToArray(l,o,f),u.atomColorToArray(l,a,f)}return{color:o,pickingColor:a}},getSize:function(t,e){for(var i=this.polymer,n=i.structure,r=i.residueCount,o=i.residueIndexStart,a=new Float32Array(r),s=new Ir(t,e),c=n.getResidueProxy(),u=n.getAtomProxy(),h=0;h<r;++h)c.index=o+h,u.index=c.traceAtomIndex,a[h]=s.atomRadius(u);return{size:a}},getPosition:function(){var t,e,i,n,r,o=this.polymer,a=o.structure,s=o.residueCount,c=s-3,u=new Float32Array(3*s),h=new Float32Array(3*s),l=new Float32Array(s),d=new Float32Array(s),f=new Float32Array(s),p=new Float32Array(s),m=new Float32Array(3*s),g=new N,v=new N,y=new N,b=new N,x=new N,_=new N,w=new N,S=new N,A=new N,M=new N,C=new N,P=new N(0,0,0),T="trace",E=a.getAtomProxy(),I=a.getAtomProxy(o.getAtomIndexByType(0,T)),L=a.getAtomProxy(o.getAtomIndexByType(1,T)),R=a.getAtomProxy(o.getAtomIndexByType(2,T));for(i=0;i<c;++i)E.index=I.index,I.index=L.index,L.index=R.index,R.index=o.getAtomIndexByType(i+3,T),e=3*i,g.subVectors(I,E),v.subVectors(L,I),y.subVectors(R,L),b.subVectors(g,v),x.subVectors(v,y),A.crossVectors(b,x).normalize(),A.toArray(h,e),i>0&&(l[i]=A.angleTo(M)),t=Math.cos(b.angleTo(x)),p[i]=180/Math.PI*Math.acos(t),n=b.length(),r=x.length(),d[i]=Math.sqrt(r*n)/Math.max(2,2*(1-t)),f[i]=Math.abs(v.dot(A)),_.copy(b).multiplyScalar(d[i]/n),w.copy(x).multiplyScalar(d[i]/r),_.subVectors(I,_),w.subVectors(L,w),_.toArray(u,e+3),w.toArray(u,e+6),C.subVectors(E,P),C.toArray(m,e),M.copy(A),P.copy(_);for(_.fromArray(u,3),w.fromArray(u,6),A.subVectors(_,w).normalize(),E.index=o.getAtomIndexByType(0,T),P.copy(E),S.copy(E),Rr(S,A,_),S.toArray(u,0),C.subVectors(P,_),C.toArray(m,0),_.fromArray(u,3*s-6),w.fromArray(u,3*s-9),A.subVectors(_,w).normalize(),E.index=o.getAtomIndexByType(s-1,T),P.copy(E),S.copy(E),Rr(S,A,_),S.toArray(u,3*s-3),i=s-3;i<s;++i)_.fromArray(u,3*i),E.index=o.getAtomIndexByType(i,T),P.copy(E),C.subVectors(P,_),C.toArray(m,3*i);var O=new Float32Array(s),D=new Float32Array(s),k=new Float32Array(s),F=new Float32Array(s);for(O[1]=d[0],D[1]=p[0],k[1]=d[0],i=2;i<s-2;++i)O[i]=.5*(d[i-2]+d[i-1]),D[i]=.5*(p[i-2]+p[i-1]),k[i]=.5*(f[i-2]+f[i-1]),_.fromArray(h,3*(i-2)),w.fromArray(h,3*(i-1)),F[i]=180/Math.PI*Math.acos(Math.cos(_.angleTo(w)));O[s-2]=d[s-4],D[s-2]=p[s-4],k[s-2]=f[s-4];var z=new Float32Array(3*s);for(_r(h,z,0,0,3),_r(h,z,0,3,3),i=2;i<s-2;++i)_.fromArray(h,3*(i-2)),w.fromArray(h,3*(i-1)),A.addVectors(w,_).multiplyScalar(.5).normalize(),A.toArray(z,3*i);return _r(h,z,3*s-12,3*s-6,3),_r(h,z,3*s-12,3*s-3,3),{center:u,axis:z,bending:F,radius:O,rise:k,twist:D,resdir:m}}},To.prototype={constructor:To,getAxis:function(t,e,i,n,r,o){t=t||30,e=e||2.5,i=void 0!==i&&i;var a=this.polymer,s=a.structure,c=a.residueCount,u=a.residueIndexStart,h=this.position,l=n||{};l.structure=s;for(var d,f,p=dv.getScheme(l),m=dv.getPickingScheme(l),g=new Ir(r,o),v=0,y=0,b=[],x=[],_=[],w=[],S=[],A=[],M=[],C=[],P=[],T=[],E=[],I=new N,L=new N,R=s.getResidueProxy(),O=s.getResidueProxy(),D=s.getAtomProxy(),k=new N,F=new N,z=!1,B=0;B<c;++B)if(R.index=u+B,k.fromArray(h.center,3*B),B===c-1?z=!0:(O.index=u+B+1,F.fromArray(h.center,3*B+3),i&&R.sstruc!==O.sstruc?z=!0:k.distanceTo(F)>e?z=!0:h.bending[B]>t&&(z=!0)),z){if(B-v<4){v=B,z=!1;continue}D.index=R.traceAtomIndex,T=h.axis.subarray(3*v+3,3*B),E=h.center.subarray(3*v,3*B+3),d=Lr(T).normalize(),f=Lr(E),I.fromArray(E),Rr(I,d,f),L.fromArray(E,E.length-3),Rr(L,d,f),d.subVectors(L,I),d.toArray(b,y),f.toArray(x,y),I.toArray(_,y),L.toArray(w,y),p.atomColorToArray(D,S,y),m.atomColorToArray(D,A,y),M.push(g.atomRadius(D)),C.push(u+v),P.push(u+B+1-v),y+=3,v=B,z=!1}return{axis:new Float32Array(b),center:new Float32Array(x),begin:new Float32Array(_),end:new Float32Array(w),color:new Float32Array(S),pickingColor:new Float32Array(A),size:new Float32Array(M),residueOffset:C,residueCount:P}}},Eo.prototype={push:function(t){this.content.push(t),this.bubbleUp(this.content.length-1)},pop:function(){var t=this.content[0],e=this.content.pop();return this.content.length>0&&(this.content[0]=e,this.sinkDown(0)),t},peek:function(){return this.content[0]},remove:function(t){for(var e=this.content.length,i=0;i<e;i++)if(this.content[i]==t){var n=this.content.pop();return void(i!=e-1&&(this.content[i]=n,this.scoreFunction(n)<this.scoreFunction(t)?this.bubbleUp(i):this.sinkDown(i)))}throw new Error("Node not found.")},size:function(){return this.content.length},bubbleUp:function(t){for(var e=this.content[t];t>0;){var i=Math.floor((t+1)/2)-1,n=this.content[i];if(!(this.scoreFunction(e)<this.scoreFunction(n)))break;this.content[i]=e,this.content[t]=n,t=i}},sinkDown:function(t){for(var e,i,n=this.content.length,r=this.content[t],o=this.scoreFunction(r);;){var a=2*(t+1),s=a-1,c=null;if(s<n){var u=this.content[s];e=this.scoreFunction(u),e<o&&(c=s)}if(a<n){var h=this.content[a];i=this.scoreFunction(h),i<(null===c?o:e)&&(c=a)}if(null===c)break;this.content[t]=this.content[c],this.content[c]=r,t=c}}},Lo.prototype={nearest:function(){var t=new Float32Array(3);return function(e,i,n){e instanceof N?e.toArray(t):"AtomProxy"===e.type&&e.positionToArray(t);for(var r=this.kdtree.nearest(t,i,n),o=this.kdtree.indices,a=this.kdtree.nodes,s=this.atomIndices,c=[],u=0,h=r.length;u<h;++u){var l=r[u],d=l[0],f=l[1];c.push({index:s[o[a[d]]],distance:f})}return c}}()};var kv={" ":"X","!":"Y","#":"Z",$:"-X","%":"-Y","&":"-Z","'":"Y+1/2","(":"1/2+X",")":"1/2+Y","*":"1/2-X","+":"1/2+Z",",":"1/2-Y","-":"1/2-Z",".":"X+1/2","/":"Z+1/2",0:"-X+1/2",1:"-Y+1/2",2:"-Z+1/2",3:"1/4+X",4:"1/4-Y",5:"1/4+Z",6:"1/4-X",7:"1/4+Y",8:"3/4-Y",9:"3/4+Z",":":"3/4+Y",";":"3/4+X","<":"3/4-X","=":"1/4-Z",">":"3/4-Z","?":"X-Y","@":"Y-X",A:"Z+1/3",B:"Z+2/3",C:"X+2/3",D:"Y+1/3",E:"-Y+2/3",F:"X-Y+1/3",G:"Y-X+2/3",H:"-X+1/3",I:"X+1/3",J:"Y+2/3",K:"-Y+1/3",L:"X-Y+2/3",M:"Y-X+1/3",N:"-X+2/3",O:"2/3+X",P:"1/3+Y",Q:"1/3+Z",R:"2/3-Y",S:"1/3+X-Y",T:"2/3+Y-X",U:"1/3-X",V:"2/3-X",W:"1/3-Y",X:"1/3-Z",Y:"2/3+Y",Z:"1/3+Y-X","[":"2/3+X-Y","]":"1/3+X","^":"2/3+Z",_:"2/3-Z","`":"5/6+Z",a:"1/6+Z",b:"5/6-Z",c:"1/6-Z",d:"Z+5/6",e:"Z+1/6",f:"Z+1/4",g:"+Y"},Fv={"P 1":" !#","P -1":" !#$%&","P 1 2 1":" !#$!&","P 1 21 1":" !#$'&","C 1 2 1":" !#$!&()#*)&","P 1 m 1":" !# %#","P 1 c 1":" !# %+","C 1 m 1":" !# %#()#(,#","C 1 c 1":" !# %+()#(,+","P 1 2/m 1":" !# %#$!&$%&","P 1 21/m 1":" !#$)&$%& ,#","C 1 2/m 1":" !# %#$!&$%&()#(,#*)&*,&","P 1 2/c 1":" !#$!-$%& %+","P 1 21/c 1":" !#$%&$)- ,+","C 1 2/c 1":" !#$!-$%& %+()#*)-*,&(,+","P 2 2 2":" !#$%#$!& %&","P 2 2 21":" !#$%+$!- %&","P 21 21 2":" !#$%#*)&(,&","P 21 21 21":" !#*%+$)-(,&","C 2 2 21":" !#$%+$!- %&()#*,+*)-(,&","C 2 2 2":" !#$%#$!& %&()#*,#*)&(,&","F 2 2 2":" !#$%#$!& %& )+$,+$)- ,-(!+*%+*!-(%-()#*,#*)&(,&","I 2 2 2":" !#$%# %&$!&.'/01/.120'2","I 21 21 21":" !#*%+$)-(,&()+$,#*!& %-","P m m 2":" !#$%# %#$!#","P m c 21":" !#$%+ %+$!#","P c c 2":" !#$%# %+$!+","P m a 2":" !#$%#(%#*!#","P c a 21":" !#$%+(%#*!+","P n c 2":" !#$%# ,+$)+","P m n 21":" !#*%+(%+$!#","P b a 2":" !#$%#(,#*)#","P n a 21":" !#$%+(,#*)+","P n n 2":" !#$%#(,+*)+","C m m 2":" !#$%# %#$!#()#*,#(,#*)#","C m c 21":" !#$%+ %+$!#()#*,+(,+*)#","C c c 2":" !#$%# %+$!+()#*,#(,+*)+","A m m 2":" !#$%# %#$!# )+$,+ ,+$)+","A b m 2":" !#$%# ,#$)# )+$,+ %+$!+","A m a 2":" !#$%#(%#*!# )+$,+(,+*)+","A b a 2":" !#$%#(,#*)# )+$,+(%+*!+","F m m 2":" !#$%# %#$!# )+$,+ ,+$)+(!+*%+(%+*!+()#*,#(,#*)#","F d d 2":" !#$%#345675 )+$,+3896:9(!+*%+;49<79()#*,#;85<:5","I m m 2":" !#$%# %#$!#()+*,+(,+*)+","I b a 2":" !#$%#(,#*)#()+*,+ %+$!+","I m a 2":" !#$%#(%#*!#()+*,+ ,+$)+","P 2/m 2/m 2/m":" !#$%#$!& %&$%& !& %#$!#","P 2/n 2/n 2/n":" !#$%#$!& %&*,-()-(,+*)+","P 2/c 2/c 2/m":" !#$%#$!- %-$%& !& %+$!+","P 2/b 2/a 2/n":" !#$%#$!& %&*,&()&(,#*)#","P 21/m 2/m 2/a":" !#*%#$!&(%&$%&(!& %#*!#","P 2/n 21/n 2/a":" !#*%#*)- ,-$%&(!&(,+$)+","P 2/m 2/n 21/a":" !#*%+*!- %&$%&(!-(%+$!#","P 21/c 2/c 2/a":" !#*%#$!-(%-$%&(!& %+*!+","P 21/b 21/a 2/m":" !#$%#*)&(,&$%& !&(,#*)#","P 21/c 21/c 2/n":" !#*,#$)-(%-$%&()& ,+*!+","P 2/b 21/c 21/m":" !#$%+$)- ,&$%& !- ,+$)#","P 21/n 21/n 2/m":" !#$%#*)-(,-$%& !&(,+*)+","P 21/m 21/m 2/n":" !#$%#*'&.,&*,&.'& %#$!#","P 21/b 2/c 21/n":" !#*,+$!-(,&$%&()- %+*)#","P 21/b 21/c 21/a":" !#*%+$)-(,&$%&(!- ,+*)#","P 21/n 21/m 21/a":" !#0%/$'&.12$%&.!2 1#0'/","C 2/m 2/c 21/m":" !#$%+$!- %&$%& !- %+$!#()#*,+*)-(,&*,&()-(,+*)#","C 2/m 2/c 21/a":" !#$,+$)- %&$%& )- ,+$!#()#*%+*!-(,&*,&(!-(%+*)#","C 2/m 2/m 2/m":" !#$%#$!& %&$%& !& %#$!#()#*,#*)&(,&*,&()&(,#*)#","C 2/c 2/c 2/m":" !#$%#$!- %-$%& !& %+$!+()#*,#*)-(,-*,&()&(,+*)+","C 2/m 2/m 2/a":" !#$,#$)& %&$%& )& ,#$!#()#*%#*!&(,&*,&(!&(%#*)#","C 2/c 2/c 2/a":" !#*,#$!&(,&$,-(!- ,+*!+()#$%#*)& %&*%- )-(%+$)+","F 2/m 2/m 2/m":" !#$%#$!& %&$%& !& %#$!# )+$,+$)- ,-$,- )- ,+$)+(!+*%+*!-(%-*%-(!-(%+*!+()#*,#*)&(,&*,&()&(,#*)#","F 2/d 2/d 2/d":" !#$%#$!& %&64=37=345675 )+$,+$)- ,-68>3:>3896:9(!+*%+*!-(%-<4>;7>;49<79()#*,#*)&(,&<8=;:=;85<:5","I 2/m 2/m 2/m":" !#$%#$!& %&$%& !& %#$!#()+*,+*)-(,-*,-()-(,+*)+","I 2/b 2/a 2/m":" !#$%#*)&(,&$%& !&(,#*)#()+*,+$!- %-*,-()- %+$!+","I 21/b 21/c 21/a":" !#*%+$)-(,&$%&(!- ,+*)#()+$,#*!& %-*,- )&(%#$!+","I 21/m 21/m 21/a":" !#$,#$)& %&$%& )& ,#$!#()+*%+*!-(,-*,-(!-(%+*)+","P 4":" !#$%#% #!$#","P 41":" !#$%+% 5!$9","P 42":" !#$%#% +!$+","P 43":" !#$%+% 9!$5","I 4":" !#$%#% #!$#()+*,+,(+)*+","I 41":" !#*,+%(5)$9()+$%#, 9!*5","P -4":" !#$%#!$&% &","I -4":" !#$%#!$&% &()+*,+)*-,(-","P 4/m":" !#$%#% #!$#$%& !&!$&% &","P 42/m":" !#$%#% +!$+$%& !&!$-% -","P 4/n":" !#$%#,(#)*#*,&()&!$&% &","P 42/n":" !#$%#,(+)*+*,-()-!$&% &","I 4/m":" !#$%#% #!$#$%& !&!$&% &()+*,+,(+)*+*,-()-)*-,(-","I 41/a":" !#*,+%(5)$9$,=(!>!$&,(-()+$%#, 9!*5*%> )=)*-% &","P 4 2 2":" !#$%#% #!$#$!& %&! &%$&","P 4 21 2":" !#$%#,(#)*#*)&(,&! &%$&","P 41 2 2":" !#$%+% 5!$9$!& %-! >%$=","P 41 21 2":" !#$%+,(5)*9*)=(,>! &%$-","P 42 2 2":" !#$%#% +!$+$!& %&! -%$-","P 42 21 2":" !#$%#,(+)*+*)-(,-! &%$&","P 43 2 2":" !#$%+% 9!$5$!& %-! =%$>","P 43 21 2":" !#$%+,(9)*5*)>(,=! &%$-","I 4 2 2":" !#$%#% #!$#$!& %&! &%$&()+*,+,(+)*+*)-(,-)(-,*-","I 41 2 2":" !#*,+%(5)$9*!> ,=)(-%$&()+$%#, 9!*5$)=(%>! &,*-","P 4 m m":" !#$%#% #!$# %#$!#%$#! #","P 4 b m":" !#$%#% #!$#(,#*)#,*#)(#","P 42 c m":" !#$%#% +!$+ %+$!+%$#! #","P 42 n m":" !#$%#,(+)*+(,+*)+%$#! #","P 4 c c":" !#$%#% #!$# %+$!+%$+! +","P 4 n c":" !#$%#% #!$#(,+*)+,*+)(+","P 42 m c":" !#$%#% +!$+ %#$!#%$+! +","P 42 b c":" !#$%#% +!$+(,#*)#,*+)(+","I 4 m m":" !#$%#% #!$# %#$!#%$#! #()+*,+,(+)*+(,+*)+,*+)(+","I 4 c m":" !#$%#% #!$# %+$!+%$+! +()+*,+,(+)*+(,#*)#,*#)(#","I 41 m d":" !#*,+%(5)$9 %#*)+%*5) 9()+$%#, 9!*5(,+$!#,$9!(5","I 41 c d":" !#*,+%(5)$9 %+*)#%*9) 5()+$%#, 9!*5(,#$!+,$5!(9","P -4 2 m":" !#$%#% &!$&$!& %&%$#! #","P -4 2 c":" !#$%#% &!$&$!- %-%$+! +","P -4 21 m":" !#$%#% &!$&*)&(,&,*#)(#","P -4 21 c":" !#$%#% &!$&*)-(,-,*+)(+","P -4 m 2":" !#$%#!$&% & %#$!#! &%$&","P -4 c 2":" !#$%#% &!$& %+$!+! -%$-","P -4 b 2":" !#$%#% &!$&(,#*)#)(&,*&","P -4 n 2":" !#$%#% &!$&(,+*)+)(-,*-","I -4 m 2":" !#$%#% &!$& %#$!#! &%$&()+*,+,(-)*-(,+*)+)(-,*-","I -4 c 2":" !#$%#% &!$& %+$!+! -%$-()+*,+,(-)*-(,#*)#)(&,*&","I -4 2 m":" !#$%#% &!$&$!& %&%$#! #()+*,+,(-)*-*)-(,-,*+)(+","I -4 2 d":" !#$%#% &!$&*!>(%>,$9) 9()+*,+,(-)*-$)= ,=%*5!(5","P 4/m 2/m 2/m":" !#$%#% #!$#$!& %&! &%$&$%& !&!$&% & %#$!#%$#! #","P 4/m 2/c 2/c":" !#$%#% #!$#$!- %-! -%$-$%& !&!$&% & %+$!+%$+! +","P 4/n 2/b 2/m":" !#$%#% #!$#$!& %&! &%$&*,&()&)*&,(&(,#*)#,*#)(#","P 4/n 2/n 2/c":" !#$%#% #!$#$!& %&! &%$&*,-()-)*-,(-(,+*)+,*+)(+","P 4/m 21/b 2/m":" !#$%#% #!$#*)&(,&)(&,*&$%& !&!$&% &(,#*)#,*#)(#","P 4/m 21/n 2/c":" !#$%#% #!$#*)-(,-)(-,*-$%& !&!$&% &(,+*)+,*+)(+","P 4/n 21/m 2/m":" !#$%#,(#)*#*)&(,&! &%$&*,&()&!$&% & %#$!#,*#)(#","P 4/n 2/c 2/c":" !#$%#,(#)*#*)-(,-! -%$-*,&()&!$&% & %+$!+,*+)(+","P 42/m 2/m 2/c":" !#$%#% +!$+$!& %&! -%$-$%& !&!$-% - %#$!#%$+! +","P 42/m 2/c 2/m":" !#$%#% +!$+$!- %-! &%$&$%& !&!$-% - %+$!+%$#! #","P 42/n 2/b 2/c":" !#$%#,(+)*+$!- %-)(&,*&*,-()-!$&% &(,#*)#%$+! +","P 42/n 2/n 2/m":" !#$%#,(+)*+$!& %&)(-,*-*,-()-!$&% &(,+*)+%$#! #","P 42/m 21/b 2/c":" !#$%#% +!$+*)&(,&)(-,*-$%& !&!$-% -(,#*)#,*+)(+","P 42/m 21/n 2/m":" !#$%#,./'*/*'-.,-! &%$&$%& !&'*-,.-.,/*'/%$#! #","P 42/n 21/m 2/c":" !#$%#,(+)*+*)-(,-! &%$&*,-()-!$&% & %#$!#,*+)(+","P 42/n 21/c 2/m":" !#$%#,(+)*+*)&(,&! -%$-*,-()-!$&% & %+$!+,*#)(#","I 4/m 2/m 2/m":" !#$%#% #!$#$!& %&! &%$&$%& !&!$&% & %#$!#%$#! #()+*,+,(+)*+*)-(,-)(-,*-*,-()-)*-,(-(,+*)+,*+)(+","I 4/m 2/c 2/m":" !#$%#% #!$#$!- %-! -%$-$%& !&!$&% & %+$!+%$+! +()+*,+,(+)*+*)&(,&)(&,*&*,-()-)*-,(-(,#*)#,*#)(#","I 41/a 2/m 2/d":" !#*,+%(5)$9*!> ,=)(-%$&$,=(!>!$&,(-(,+$!#,$9!(5()+$%#, 9!*5$)=(%>! &,*-*%> )=)*-% & %#*)+%*5) 9","I 41/a 2/c 2/d":" !#*,+%(5)$9*!= ,>)(&%$-$,=(!>!$&,(-(,#$!+,$5!(9()+$%#, 9!*5$)>(%=! -,*&*%> )=)*-% & %+*)#%*9) 5","P 3":" !#%?#@$#","P 31":" !#%?A@$B","P 32":" !#%?B@$A","H 3":" !#%?#@$#CDAEFAGHAIJBKLBMNB","R 3":" !## !!# ","P -3":" !#%?#@$#$%&!@&? &","H -3":" !#%?#@$#$%&!@&? &OPQRSQTUQVWXYZX[]X]Y^W[^ZV^UR_PT_SO_","R -3":" !## !!# $%&&$%%&$","P 3 1 2":" !#%?#@$#%$&@!& ?&","P 3 2 1":" !#%?#@$#! &?%&$@&","P 31 1 2":" !#%?Q@$^%$_@!X ?&","P 31 2 1":" !#%?A@$B! &?%_$@X","P 32 1 2":" !#%?^@$Q%$X@!_ ?&","P 32 2 1":" !#%?B@$A! &?%X$@_","H 3 2":" !#%?#@$#! &?%&$@&OPQRSQTUQY]X[WXVZX]Y^W[^ZV^PO_SR_UT_","R 3 2":" !## !!# %$&$&%&%$","P 3 m 1":" !#%?#@$#%$#@!# ?#","P 3 1 m":" !#%?#@$#! #?%#$@#","P 3 c 1":" !#%?#@$#%$+@!+ ?+","P 3 1 c":" !#%?#@$#! +?%+$@+","H 3 m":" !#%?#@$#%$#@!# ?#OPQRSQTUQRUQTPQOSQ]Y^W[^ZV^WV^ZY^][^","R 3 m":" !## !!# ! # #!#! ","H 3 c":" !#%?#@$#%$+@!+ ?+OPQRSQTUQRU`TP`OS`]Y^W[^ZV^WVaZYa][a","R 3 c":" !## !!# '././'/'.","P -3 1 2/m":" !#%?#@$#%$&@!& ?&$%&!@&? &! #?%#$@#","P -3 1 2/c":" !#%?#@$#%$-@!- ?-$%&!@&? &! +?%+$@+","P -3 2/m 1":" !#%?#@$#! &?%&$@&$%&!@&? &%$#@!# ?#","P -3 2/c 1":" !#%?#@$#! -?%-$@-$%&!@&? &%$+@!+ ?+","H -3 2/m":" !#%?#@$#! &?%&$@&$%&!@&? &%$#@!# ?#OPQRSQTUQY]X[WXVZXVWXYZX[]XRUQTPQOSQ]Y^W[^ZV^PO_SR_UT_UR_PT_SO_WV^ZY^][^","R -3 2/m":" !## !!# %$&$&%&%$$%&&$%%&$! # #!#! ","H -3 2/c":" !#%?#@$#! -?%-$@-$%&!@&? &%$+@!+ ?+OPQRSQTUQY]b[WbVZbVWXYZX[]XRU`TP`OS`]Y^W[^ZV^POcSRcUTcUR_PT_SO_WVaZYa][a","R -3 2/c":" !## !!# 102021210$%&&$%%&$'././'/'.","P 6":" !#%?#@$#$%#!@#? #","P 61":" !#%?A@$B$%/!@d? e","P 65":" !#%?B@$A$%/!@e? d","P 62":" !#%?^@$Q$%#!@^? Q","P 64":" !#%?Q@$^$%#!@Q? ^","P 63":" !#%?#@$#$%+!@+? +","P -6":" !#%?#@$# !&%?&@$&","P 6/m":" !#%?#@$#$%#!@#? #$%&!@&? & !&%?&@$&","P 63/m":" !#%?#@$#$%+!@+? +$%&!@&? & !-%?-@$-","P 6 2 2":" !#%?#@$#$%#!@#? #! &?%&$@&%$&@!& ?&","P 61 2 2":" !#%?Q@$^$%+!@`? a! X?%&$@_%$b@!- ?c","P 65 2 2":" !#%?^@$Q$%+!@a? `! _?%&$@X%$c@!- ?b","P 62 2 2":" !#%?^@$Q$%#!@^? Q! _?%&$@X%$_@!& ?X","P 64 2 2":" !#%?Q@$^$%#!@Q? ^! X?%&$@_%$X@!& ?_","P 63 2 2":" !#%?#@$#$%+!@+? +! &?%&$@&%$-@!- ?-","P 6 m m":" !#%?#@$#$%#!@#? #%$#@!# ?#! #?%#$@#","P 6 c c":" !#%?#@$#$%#!@#? #%$+@!+ ?+! +?%+$@+","P 63 c m":" !#%?#@$#$%+!@+? +%$+@!+ ?+! #?%#$@#","P 63 m c":" !#%?#@$#$%+!@+? +%$#@!# ?#! +?%+$@+","P -6 m 2":" !#%?#@$# !&%?&@$&%$#@!# ?#%$&@!& ?&","P -6 c 2":" !#%?#@$# !-%?-@$-%$+@!+ ?+%$&@!& ?&","P -6 2 m":" !#%?#@$# !&%?&@$&! &?%&$@&! #?%#$@#","P -6 2 c":" !#%?#@$# !-%?-@$-! &?%&$@&! +?%+$@+","P 6/m 2/m 2/m":" !#%?#@$#$%#!@#? #! &?%&$@&%$&@!& ?&$%&!@&? & !&@$&%?&%$#@!# ?#! #?%#$@#","P 6/m 2/c 2/c":" !#%?#@$#$%#!@#? #! -?%-$@-%$-@!- ?-$%&!@&? & !&@$&%?&%$+@!+ ?+! +?%+$@+","P 63/m 2/c 2/m":" !#%?#@$#$%+!@+? +! -?%-$@-%$&@!& ?&$%&!@&? & !-@$-%?-%$+@!+ ?+! #?%#$@#","P 63/m 2/m 2/c":" !#%?#@$#$%+!@+? +! &?%&$@&%$-@!- ?-$%&!@&? & !-@$-%?-%$#@!# ?#! +?%+$@+","P 2 3":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& ","F 2 3":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%&  )+$,+$)- ,-#()#*,&*)&(,!+(%+*!-*%-((!+*%+*!-(%-+ )+$,-$)- ,)#(,#*)&*,&(()#*,#*)&(,&+(!+*%-*!-(%)+ ,+$)-$,- ","I 2 3":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& ()+*,+*)-(,-+()+*,-*)-(,)+(,+*)-*,-(","P 21 3":" !#*%+$)-(,&# !+*%-$)&(,!# %+*)-$,&(","I 21 3":" !#*%+$)-(,&# !+*%-$)&(,!# %+*)-$,&(()+$,#*!& %-+()#$,&*!- %)+(,#$!&*%- ","P 2/m -3":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& $%& !& %#$!#&$%& !# %#$!%&$!& %# !#$","P 2/n -3":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& *,-()-(,+*)+-*,-()+(,+*),-*)-(,+()+*","F 2/m -3":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& $%& !& %#$!#&$%& !# %#$!%&$!& %# !#$ )+$,+$)- ,-#()#*,&*)&(,!+(%+*!-*%-($,- )- ,+$)+&*,&()#(,#*)%-*!-(%+(!+*(!+*%+*!-(%-+ )+$,-$)- ,)#(,#*)&*,&(*%-(!-(%+*!+-$,- )+ ,+$),&*)&(,#()#*()#*,#*)&(,&+(!+*%-*!-(%)+ ,+$)-$,- *,&()&(,#*)#-*%-(!+(%+*!,-$)- ,+ )+$","F 2/d -3":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& 64=37=345675=64=375345674=67=3453756 )+$,+$)- ,-#()#*,&*)&(,!+(%+*!-*%-(68>3:>3896:9=<8=;:5;85<:4><7>;49;79<(!+*%+*!-(%-+ )+$,-$)- ,)#(,#*)&*,&(<4>;7>;49<79>68>3:93896:8=<:=;85;:5<()#*,#*)&(,&+(!+*%-*!-(%)+ ,+$)-$,- <8=;:=;8f<:f><4>;79;49<78>6:>3893:96","I 2/m -3":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& $%& !& %#$!#&$%& !# %#$!%&$!& %# !#$()+*,+*)-(,-+()+*,-*)-(,)+(,+*)-*,-(*,-()-(,+*)+-*,-()+(,+*),-*)-(,+()+*","P 21/a -3":" !#*%+$)-(,&# !+*%-$)&(,!# %+*)-$,&($%&(!- ,+*)#&$%-(!+ ,#*)%&$!-(,+ )#*","I 21/a -3":" !#*%+$)-(,&# !+*%-$)&(,!# %+*)-$,&($%&(!- ,+*)#&$%-(!+ ,#*)%&$!-(,+ )#*()+$,#*g& %-+()#$,&*!- %)+(,#$!&*%- *,- )&(%#$!+-*,& )#(%+$!,-*)& %#(!+$","P 4 3 2":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& ! &%$&!$#% # #%$#!$&% &!#!$#% &! &%$","P 42 3 2":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& )(-,*-)*+,(+(+,*+)*-,(-)+)*+,(-)(-,*","F 4 3 2":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& ! &%$&!$#% # #%$#!$&% &!#!$#% &! &%$ )+$,+$)- ,-#()#*,&*)&(,!+(%+*!-*%-(!(-%*-!*+%(+ +,$+)$-, -)#)*#,(&)(&,*(!+*%+*!-(%-+ )+$,-$)- ,)#(,#*)&*,&() -,$-)$+, +(#,*#)*&,(&)+!*+%(-!(-%*()#*,#*)&(,&+(!+*%-*!-(%)+ ,+$)-$,- )(&,*&)*#,(#(+%*+!*-%(-!+)$+, -) -,$","F 41 3 2":" !#$,+*)&(%-# !+$,&*)-(%!# ,+$)&*%-(:3>46=7<98;5;58<976=43>:97<58;>:3=46 )+$%#*!-(,&#()+*%&$!- ,!+(,#*)-$%& :;=4<>765839;94<5:6>83=79:6543>7;=8<(!+*,#$)- %&+ )#$%-*!&(,)#(%+*!&$,- 73=86>:<54;935469:<=8;>7576983=:;>4<()#*%+$!& ,-+(!#*,-$)& %)+ %#$!-*,&(7;>8<=:69435398657<>4;=:5:<94;=73>86","I 4 3 2":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& ! &%$&!$#% # #%$#!$&% &!#!$#% &! &%$()+*,+*)-(,-+()+*,-*)-(,)+(,+*)-*,-()(-,*-)*+,(+(+,*+)*-,(-)+)*+,(-)(-,*","P 43 3 2":" !#*%+$)-(,&# !+*%-$)&(,!# %+*)-$,&(7;>46=:<5839398<5:6=4;>75:<983>7;=46","P 41 3 2":" !#*%+$)-(,&# !+*%-$)&(,!# %+*)-$,&(:3=8<>7694;5;54697<>83=:97654;=:3>8<","I 41 3 2":" !#*%+$)-(,&# !+*%-$)&(,!# %+*)-$,&(:3=8<>7694;5;54697<>83=:97654;=:3>8<()+$,#*!& %-+()#$,&*!- %)+(,#$!&*%- 7;>46=:<5839398<5:6=4;>75:<983>7;=46","P -4 3 m":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& ! #%$#!$&% & #!$#%$&! &%#! #%$&!$&% ","F -4 3 m":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& ! #%$#!$&% & #!$#%$&! &%#! #%$&!$&%  )+$,+$)- ,-#()#*,&*)&(,!+(%+*!-*%-(!(+%*+!*-%(- +)$+,$-) -,#)(#,*&)*&,((!+*%+*!-(%-+ )+$,-$)- ,)#(,#*)&*,&() +,$+)$-, -(#)*#,*&)(&,+!(+%*-!*-%(()#*,#*)&(,&+(!+*%-*!-(%)+ ,+$)-$,- )(#,*#)*&,(&(+!*+%*-!(-%+) +,$-)$-, ","I -4 3 m":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& ! #%$#!$&% & #!$#%$&! &%#! #%$&!$&% ()+*,+*)-(,-+()+*,-*)-(,)+(,+*)-*,-()(+,*+)*-,(-(+)*+,*-)(-,+)(+,*-)*-,(",
	"P -4 3 n":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& )(+,*+)*-,(-(+)*+,*-)(-,+)(+,*-)*-,(","F -4 3 c":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& )(+,*+)*-,(-(+)*+,*-)(-,+)(+,*-)*-,( )+$,+$)- ,-#()#*,&*)&(,!+(%+*!-*%-() #,$#)$&, &(#!*#%*&!(&%+! +%$-!$-% (!+*%+*!-(%-+ )+$,-$)- ,)#(,#*)&*,&(!(#%*#!*&%(& +!$+%$-! -%#) #,$&)$&, ()#*,#*)&(,&+(!+*%-*!-(%)+ ,+$)-$,- ! +%$+!$-% - #)$#,$&) &,#!(#%*&!*&%(","I -4 3 d":" !#*%+$)-(,&# !+*%-$)&(,!# %+*)-$,&(7354<9:6>8;=357<946>:;=857394<>:6=8;()+$,#*!& %-+()#$,&*!- %)+(,#$!&*%- :;98657<=43>;9:658<=73>49:;586=7<>43","P 4/m -3 2/m":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& ! &%$&!$#% # #%$#!$&% &!#!$#% &! &%$$%& !& %#$!#&$%& !# %#$!%&$!& %# !#$%$#! #% &!$&$&! &% #!$#%&% &!$#%$#! ","P 4/n -3 2/n":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& ! &%$&!$#% # #%$#!$&% &!#!$#% &! &%$*,-()-(,+*)+-*,-()+(,+*),-*)-(,+()+*,*+)(+,(-)*-*-)(-,(+)*+,-,(-)*+,*+)(","P 42/m -3 2/n":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& )(-,*-)*+,(+(+,*+)*-,(-)+)*+,(-)(-,*$%& !& %#$!#&$%& !# %#$!%&$!& %# !#$,*+)(+,(-)*-*-)(-,(+)*+,-,(-)*+,*+)(","P 42/n -3 2/m":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& )(-,*-)*+,(+(+,*+)*-,(-)+)*+,(-)(-,**,-()-(,+*)+-*,-()+(,+*),-*)-(,+()+*%$#! #% &!$&$&! &% #!$#%&% &!$#%$#! ","F 4/m -3 2/m":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& ! &%$&!$#% # #%$#!$&% &!#!$#% &! &%$$%& !& %#$!#&$%& !# %#$!%&$!& %# !#$%$#! #% &!$&$&! &% #!$#%&% &!$#%$#!  )+$,+$)- ,-#()#*,&*)&(,!+(%+*!-*%-(!(-%*-!*+%(+ +,$+)$-, -)#)*#,(&)(&,*$,- )- ,+$)+&*,&()#(,#*)%-*!-(%+(!+*%*+!(+%(-!*-$-) -, +)$+,&,(&)*#,*#)((!+*%+*!-(%-+ )+$,-$)- ,)#(,#*)&*,&() -,$-)$+, +(#,*#)*&,(&)+!*+%(-!(-%**%-(!-(%+*!+-$,- )+ ,+$),&*)&(,#()#*,$+) +, -)$-*&)(&,(#)*#,-%(-!*+%*+!(()#*,#*)&(,&+(!+*%-*!-(%)+ ,+$)-$,- )(&,*&)*#,(#(+%*+!*-%(-!+)$+, -) -,$*,&()&(,#*)#-*%-(!+(%+*!,-$)- ,+ )+$,*#)(#,(&)*&*-!(-%(+!*+%-, -)$+,$+) ","F 4/m -3 2/c":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& )(-,*-)*+,(+(+,*+)*-,(-)+)*+,(-)(-,*$%& !& %#$!#&$%& !# %#$!%&$!& %# !#$,*+)(+,(-)*-*-)(-,(+)*+,-,(-)*+,*+)( )+$,+$)- ,-#()#*,&*)&(,!+(%+*!-*%-() &,$&)$#, #(#%*#!*&%(&!+!$+% -! -%$$,- )- ,+$)+&*,&()#(,#*)%-*!-(%+(!+*,$#) #, &)$&*&!(&%(#!*#%-% -!$+%$+! (!+*%+*!-(%-+ )+$,-$)- ,)#(,#*)&*,&(!(&%*&!*#%(# +%$+!$-% -!#)$#, &) &,$*%-(!-(%+*!+-$,- )+ ,+$),&*)&(,#()#*%*#!(#%(&!*&$-! -% +!$+%&, &)$#,$#) ()#*,#*)&(,&+(!+*%-*!-(%)+ ,+$)-$,- ! -%$-!$+% + #,$#)$&, &)#!*#%(&!(&%**,&()&(,#*)#-*%-(!+(%+*!,-$)- ,+ )+$%$+! +% -!$-$&) &, #)$#,&%(&!*#%*#!(","F 41/d -3 2/m":" !#$,+*)&(%-# !+$,&*)-(%!# ,+$)&*%-(:3>46=7<98;5;58<976=43>:97<58;>:3=4664=3:>;85<79=64>3:5;89<74=6:>385;79<,$+! #%(-)*&*&)(-% #!$+,-%(&)*+,$#!  )+$%#*!-(,&#()+*%&$!- ,!+(,#*)-$%& :;=4<>765839;94<5:6>83=79:6543>7;=8<68>37=;49<:5=<8>;753496:4><:=;893756,*#!(+% &)$-*-!(&, +)$#%-, &!$+%*#)((!+*,#$)- %&+ )#$%-*!&(,)#(%+*!&$,- 73=86>:<54;935469:<=8;>7576983=:;>4<<4>;:=389675>68=379;45<:8=<7>;453:96%$#) +,(&!*-$&! -,(#)*+%&% -)$#,*+!(()#*%+$!& ,-+(!#*,-$)& %)+ %#$!-*,&(7;>8<=:69435398657<>4;=:5:<94;=73>86<8=;7>3456:9><4=;:9385678>67=349;:5<%*+)(#, -!$&$-) &%(+!*#,&,(-!*#%$+) ","F 41/d -3 2/c":" !#$,+*)&(%-# !+$,&*)-(%!# ,+$)&*%-(:3>46=7<98;5;58<976=43>:97<58;>:3=46<8>;7=3496:5><8=;793456:8><7=;493:56%*#)(+, &!$-$-! &,(+)*#%&, -!$#%*+)( )+$%#*!-(,&#()+*%&$!- ,!+(,#*)-$%& :;=4<>765839;94<5:6>83=79:6543>7;=8<<4=;:>385679>64=3:9;85<78=67>345;:9<%$+) #,(-!*&$&) -%(#!*+,&%(-)*#,$+! (!+*,#$)- %&+ )#$%-*!&(,)#(%+*!&$,- 73=86>:<54;935469:<=8;>7576983=:;>4<68=37>;45<:9=<4>;:5389674>6:=389;75<,*+!(#% -)$&*-)(&% +!$#,-,(&!*+%$#) ()#*%+$!& ,-+(!#*,-$)& %)+ %#$!-*,&(7;>8<=:69435398657<>4;=:5:<94;=73>8664>3:=;89<75=68>375;49<:4=<:>;853796,$#! +%(&)*-*&!(-, #)$+%-% &)$+,*#!(","I 4/m -3 2/m":" !#$%#$!& %&# !#$%&$!& %!# %#$!&$%& ! &%$&!$#% # #%$#!$&% &!#!$#% &! &%$$%& !& %#$!#&$%& !# %#$!%&$!& %# !#$%$#! #% &!$&$&! &% #!$#%&% &!$#%$#! ()+*,+*)-(,-+()+*,-*)-(,)+(,+*)-*,-()(-,*-)*+,(+(+,*+)*-,(-)+)*+,(-)(-,**,-()-(,+*)+-*,-()+(,+*),-*)-(,+()+*,*+)(+,(-)*-*-)(-,(+)*+,-,(-)*+,*+)(","I 41/a -3 2/d":" !#*%+$)-(,&# !+*%-$)&(,!# %+*)-$,&(:3=8<>7694;5;54697<>83=:97654;=:3>8<$%&(!- ,+*)#&$%-(!+ ,#*)%&$!-(,+ )#*4<97358;=:6>6>:;=8357<94=8;>:694<573()+$,#*!& %-+()#$,&*!- %)+(,#$!&*%- 7;>46=:<5839398<5:6=4;>75:<983>7;=46*,- )&(%#$!+-*,& )#(%+$!,-*)& %#(!+$865:;943>7<=<=73>4;9:658>43=7<5869:;","P 1 1 2":" !#$%#","P 1 1 21":" !#$%+","B 1 1 2":" !#$%#(g+*%+","A 1 2 1":" !#$!& )+$)-","C 1 21 1":" !#$)&()#*!&","I 1 2 1":" !#$!&.'/0'2","I 1 21 1":" !#$)&.'/0!-","P 1 1 m":" !# !&","P 1 1 b":" !# )&","B 1 1 m":" !# !&(!+(!-","B 1 1 b":" !# )&(!+()-","P 1 1 2/m":" !# !&$%#$%&","P 1 1 21/m":" !#$%+$%& !-","B 1 1 2/m":" !# !&$%#$%&(!+(!-*%+*%-","P 1 1 2/b":" !#$,#$%& )&","P 1 1 21/b":" !#$%&$,+ )-","B 1 1 2/b":" !#$,#$%& )&(!+*,+*%-()-","P 21 2 2":" !#$!&(%&*%#","P 2 21 2":" !# ,&$)&$%#","P 21 21 2 (a)":" !#*,#.%&$'&","P 21 2 21":" !#$!&(%-*%+","P 2 21 21":" !# %&$)-$,+","C 2 2 21a)":" !#*%+(,&$)-()#$,+ %&*!-","C 2 2 2a":" !#*,#.%&$'&()#$%# ,&*!&","F 2 2 2a":" !#*,#.%&$'& '/*%/.12$!2.!/$,/ %20'2.'#$%# 1&0!&","I 2 2 2a":" !#*,#.%&$'&()+$%+*!- ,-","P 21/m 21/m 2/n a":" !#*,#$)&(%&$%&.'& ,#*!#","P 42 21 2a":" !#*,#%.+'$+$'&.%&! -,*-","I 2 3a":" !#*,#.%&$'&!# ,- '&$%/$# !-*!/$%&.%()+$%+ ,-*!-)+(%&(!-*,#*+()&$)#*,- ,"};Do.prototype={constructor:Do,type:"Assembly",addPart:function(t,e){var i=new No(t,e);return this.partList.push(i),i},getAtomCount:function(t){var e=0;return this.partList.forEach(function(i){e+=i.getAtomCount(t)}),e},getInstanceCount:function(){var t=0;return this.partList.forEach(function(e){t+=e.matrixList.length}),t},isIdentity:function(t){if(1!==this.partList.length)return!1;var e=this.partList[0];if(1!==e.matrixList.length)return!1;var i=new O;if(!i.equals(e.matrixList[0]))return!1;var n=[];return t.eachChain(function(t){n.push(t.chainname)}),n=x(n),e.chainList.length===n.length},getBoundingBox:function(t){var e=new Et;return this.partList.forEach(function(i){var n=i.getBoundingBox(t);e.expandByPoint(n.min),e.expandByPoint(n.max)}),e},getSelection:function(){var t=[];return this.partList.forEach(function(e){t=t.concat(e.chainList)}),Oo(t)}},No.prototype={constructor:No,type:"AssemblyPart",getAtomCount:function(t){var e=0,i=this.chainList;return t.eachChain(function(t){(0===i.length||i.includes(t.chainname))&&(e+=t.atomCount)}),this.matrixList.length*e},getBoundingBox:function(t){var e=new Et,i=new Et,n=this.getSelection(),r=t.getBoundingBox(n);return this.matrixList.forEach(function(t){i.copy(r).applyMatrix4(t),e.expandByPoint(i.min),e.expandByPoint(i.max)}),e},getSelection:function(){return Oo(this.chainList)},getView:function(t){var e=this.getSelection();return e?t.getView(e):t},getInstanceList:function(){for(var t=[],e=0,i=this.matrixList.length;e<i;++e)t.push({id:e+1,name:e,matrix:this.matrixList[e]});return t}};var zv=function(){var e=function(t,e,i,n){for(var r=t.structure,o=t.residueIndexStart,a=r.getResidueProxy(),s=r.getResidueProxy(),c=r.getAtomProxy(),u=r.getAtomProxy(),h=Math.max(0,e-2);h<=e;++h)for(var l=2;l<5;++l)if(!(h+l>=t.residueCount)){a.index=o+h,s.index=o+h+l,c.index=a.traceAtomIndex,u.index=s.traceAtomIndex;var d=c.distanceTo(u);if(Math.abs(d-i[l-2])>n)return!1}return!0},i=function(t,i){var n=[5.45,5.18,6.37],r=2.1;return e(t,i,n,r)},n=function(t,i){var n=[6.1,10.4,13],r=1.42;return e(t,i,n,r)},r=function(t){for(var e=t.residueStore,r=t.residueIndexStart,o=0,a=t.residueCount;o<a;++o){var s="c";i(t,o)?s="h":n(t,o)&&(s="s"),e.sstruc[r+o]=s.charCodeAt(0)}},o=function(t){for(var e=20,i=2,n=t.residueStore,r=t.residueIndexStart,o=new To(t),a=o.position,s=new N,c=new N,u=0,h=t.residueCount;u<h;++u){s.fromArray(a.center,3*u),c.fromArray(a.center,3*u+3);var l=s.distanceTo(c);l<i&&l>1&&a.bending[u]<e&&(n.sstruc[r+u]="h".charCodeAt(0),n.sstruc[r+u+1]="h".charCodeAt(0))}};return function(e){t.Debug&&uv.time("calculateSecondaryStructure"),e.eachPolymer(function(t){if(!(t.residueCount<4)){if(t.isCg())o(t);else{if(!t.isProtein())return;r(t)}var e,i=0;t.eachResidue(function(t){t.sstruc===e?i+=1:(1===i&&(t.index-=1,t.sstruc="c"),i=1,e=t.sstruc)})}}),t.Debug&&uv.timeEnd("calculateSecondaryStructure")}}(),Bv=function(){var t=["H","C","O","N","S","P"],e=["NA","CL"];return function(i){var n=i.trim().toUpperCase();parseInt(n.charAt(0))&&(n=n.substr(1)),parseInt(n.charAt(0))&&(n=n.substr(1));var r=n.length;if(0===r)return"";if(1===r)return n;if(2===r){if(e.indexOf(n)!==-1)return n;if(t.indexOf(n[0])!==-1)return n[0]}return r>=3&&t.indexOf(n[0])!==-1?n[0]:""}}();Ho.prototype={constructor:Ho,type:"AtomType",atomname:void 0,element:void 0,vdw:void 0,covalent:void 0},Xo.prototype={constructor:Xo,type:"ResidueType",resname:void 0,atomTypeIdList:void 0,atomCount:void 0,getBackboneIndexList:function(){var t,e=[];switch(this.moleculeType){case Wp:t=Am;break;case Xp:case qp:t=Mm;break;default:return e}for(var i=this.structure.atomMap,n=this.atomTypeIdList,r=0,o=this.atomCount;r<o;++r){var a=i.get(n[r]);t.includes(a.atomname)&&e.push(r)}return e},getMoleculeType:function(){return this.isProtein()?Wp:this.isRna()?Xp:this.isDna()?qp:this.isWater()?Gp:this.isIon()?Hp:this.isSaccharide()?Yp:Vp},getBackboneType:function(t){return this.hasProteinBackbone(t)?Kp:this.hasRnaBackbone(t)?Qp:this.hasDnaBackbone(t)?Jp:this.hasCgProteinBackbone(t)?tm:this.hasCgRnaBackbone(t)?em:this.hasCgDnaBackbone(t)?im:Zp},isProtein:function(){return this.chemCompType?nm.includes(this.chemCompType):this.hasAtomWithName("CA","C","N")||vm.includes(this.resname)},isCg:function(){var t=this.backboneType;return t===tm||t===em||t===im},isNucleic:function(){return this.isRna()||this.isDna()},isRna:function(){return this.chemCompType?rm.includes(this.chemCompType):this.hasAtomWithName(["P","O3'","O3*"],["C4'","C4*"],["O2'","O2*","F2'","F2*"])||ym.includes(this.resname)&&this.hasAtomWithName(["O2'","O2*","F2'","F2*"])},isDna:function(){return this.chemCompType?om.includes(this.chemCompType):this.hasAtomWithName(["P","O3'","O3*"],["C3'","C3*"])&&!this.hasAtomWithName(["O2'","O2*","F2'","F2*"])||bm.includes(this.resname)},isHetero:function(){return 1===this.hetero},isIon:function(){return wm.includes(this.resname)},isWater:function(){return _m.includes(this.resname)},isSaccharide:function(){return this.chemCompType?am.includes(this.chemCompType):Sm.includes(this.resname)},hasBackboneAtoms:function(t,e){var i=Cm[e];return t===-1?this.hasAtomWithName(i.trace,i.backboneEnd,i.direction1,i.direction2):0===t?this.hasAtomWithName(i.trace,i.direction1,i.direction2):1===t?this.hasAtomWithName(i.trace,i.backboneStart,i.direction1,i.direction2):this.hasAtomWithName(i.trace,i.backboneStart,i.backboneEnd,i.direction1,i.direction2)},hasProteinBackbone:function(t){return this.isProtein()&&this.hasBackboneAtoms(t,Kp)},hasRnaBackbone:function(t){return this.isRna()&&this.hasBackboneAtoms(t,Qp)},hasDnaBackbone:function(t){return this.isDna()&&this.hasBackboneAtoms(t,Jp)},hasCgProteinBackbone:function(t){return this.isProtein()&&this.hasBackboneAtoms(t,tm)},hasCgRnaBackbone:function(t){return this.isRna()&&this.hasBackboneAtoms(t,em)},hasCgDnaBackbone:function(t){return this.isDna()&&this.hasBackboneAtoms(t,im)},hasBackbone:function(t){return this.hasProteinBackbone(t)||this.hasRnaBackbone(t)||this.hasDnaBackbone(t)||this.hasCgProteinBackbone(t)||this.hasCgRnaBackbone(t)||this.hasCgDnaBackbone(t)},getAtomIndexByName:function(t){var e,i,n=this.atomCount,r=this.structure.atomMap,o=this.atomTypeIdList;if(Array.isArray(t)){for(e=0;e<n;++e)if(i=o[e],t.includes(r.get(i).atomname))return e}else for(e=0;e<n;++e)if(i=o[e],t===r.get(i).atomname)return e},hasAtomWithName:function(){for(var t=arguments.length,e=0;e<t;++e)if(void 0!==arguments[e]&&void 0===this.getAtomIndexByName(arguments[e]))return!1;return!0},getBonds:function(t){return void 0===this.bonds&&(this.bonds=Bo(t)),this.bonds},getRings:function(){return void 0===this.rings&&this.calculateRings(),this.rings},getBondGraph:function(){return void 0===this.bondGraph&&this.calculateBondGraph(),this.bondGraph},calculateBondGraph:function(){for(var t,e,i=this.bondGraph={},n=this.getBonds(),r=n.atomIndices1.length,o=n.atomIndices1,a=n.atomIndices2,s=0;s<r;++s){t=o[s],e=a[s];var c=i[t]=i[t]||[];c.push(e);var u=i[e]=i[e]||[];u.push(t)}},calculateRings:function(){function t(a,s,c){if(i[a])throw Error("DFS revisited atom");i[a]=1,o.push(a);for(var u=s.length,h=0;h<u;++h){var l=s[h];if(0===i[l])e[l]&&e[l].length>=2?t(l,e[l],a):i[l]=2;else if(1===i[l]&&c&&c!=l){var d=[l];n[l]=1,r.push(d);for(var f=o.length-1;f>=0;--f){var p=o[f];if(p===l)break;d.push(p),n[p]=1}}}i[a]=2,o.pop()}for(var e=this.getBondGraph(),i=new Int8Array(this.atomCount),n=new Int8Array(this.atomCount),r=[],o=[],a=0;a<this.atomCount;++a)if(!i[a]){var s=e[a];!s||s.length<2?i[a]=2:(o.length=0,t(a,s))}this.rings={flags:n,rings:r}},assignBondReferenceAtomIndices:function(){var t,e,i,n,r,o=this.getBondGraph(),a=this.getRings(),s=a.flags,c=a.rings,u=this.bonds.atomIndices1,h=this.bonds.atomIndices2,l=this.bonds.bondOrders,d=this.bondReferenceAtomIndices,f=this.bonds.atomIndices1.length;for(d.length=0,t=0;t<f;++t)if(!(l[t]<=1)){if(i=u[t],n=h[t],s[i]&&s[n]){for(var p=0;p<c.length&&void 0===d[t];++p)for(var m=c[p],g=null,v=!1,y=0;y<m.length;++y)if(r=m[y],r===i||r===n?v=!0:g=r,v&&null!==g){d[t]=g;break}if(void 0!==d[t])continue}if(o[i].length>1){for(e=0;e<o[i].length;++e)if(r=o[i][e],r!==n){d[t]=r;break}}else if(o[n].length>1){for(e=0;e<o[n].length;++e)if(r=o[n][e],r!==i){d[t]=r;break}}else;}},getBondIndex:function(t,e){for(var i=this.bonds,n=i.atomIndices1,r=i.atomIndices2,o=n.indexOf(t),a=r.indexOf(e),s=a;o!==-1;){for(;a!==-1;){if(o===a)return o;a=r.indexOf(e,a+1)}o=n.indexOf(t,o+1),a=s}},getBondReferenceAtomIndex:function(t,e){var i=this.getBondIndex(t,e);if(void 0!==i)return 0===this.bondReferenceAtomIndices.length&&this.assignBondReferenceAtomIndices(),this.bondReferenceAtomIndices[i]}},Yo.prototype={constructor:Yo,type:"BondProxy",structure:void 0,bondStore:void 0,index:void 0,get atom1(){return this.structure.getAtomProxy(this.atomIndex1)},get atom2(){return this.structure.getAtomProxy(this.atomIndex2)},get atomIndex1(){return this.bondStore.atomIndex1[this.index]},set atomIndex1(t){this.bondStore.atomIndex1[this.index]=t},get atomIndex2(){return this.bondStore.atomIndex2[this.index]},set atomIndex2(t){this.bondStore.atomIndex2[this.index]=t},get bondOrder(){return this.bondStore.bondOrder[this.index]},set bondOrder(t){this.bondStore.bondOrder[this.index]=t},getReferenceAtomIndex:function(){var t=this._ap1,e=this._ap2;if(t.index=this.atomIndex1,e.index=this.atomIndex2,t.residueIndex===e.residueIndex){var i=t.index-t.residueAtomOffset,n=e.index-e.residueAtomOffset,r=t.residueType,o=r.getBondReferenceAtomIndex(i,n);return void 0!==o?o+t.residueAtomOffset:void console.warn("No reference atom found",t.index,e.index)}},calculateShiftDir:function(t){t||(t=new N);var e=this._ap1,i=this._ap2,n=this._ap3,r=this._v12,o=this._v13;e.index=this.atomIndex1,i.index=this.atomIndex2;var a=this.getReferenceAtomIndex();r.subVectors(e,i).normalize(),void 0!==a?(n.index=a,o.subVectors(e,n)):o.copy(e),o.normalize();var s=r.dot(o);return 1-Math.abs(s)<1e-5&&(o.set(1,0,0),s=r.dot(o),1-Math.abs(s)<1e-5&&(o.set(0,1,0),s=r.dot(o))),t.copy(o.sub(r.multiplyScalar(s))).normalize()},qualifiedName:function(){return this.atomIndex1+"="+this.atomIndex2},clone:function(){return new this.constructor(this.structure,this.index)},toObject:function(){return{atomIndex1:this.atomIndex1,atomIndex2:this.atomIndex2,bondOrder:this.bondOrder}}},Zo.prototype={constructor:Zo,type:"AtomProxy",structure:void 0,chainStore:void 0,residueStore:void 0,atomStore:void 0,index:void 0,get entity(){return this.structure.entityList[this.entityIndex]},get entityIndex(){return this.chainStore.entityIndex[this.chainIndex]},get modelIndex(){return this.chainStore.modelIndex[this.chainIndex]},get chainIndex(){return this.residueStore.chainIndex[this.residueIndex]},get residue(){return console.warn("residue - might be expensive"),this.structure.getResidueProxy(this.residueIndex)},get residueIndex(){return this.atomStore.residueIndex[this.index]},set residueIndex(t){this.atomStore.residueIndex[this.index]=t},get sstruc(){return this.residueStore.getSstruc(this.residueIndex)},get inscode(){return this.residueStore.getInscode(this.residueIndex)},get resno(){return this.residueStore.resno[this.residueIndex]},get chainname(){return this.chainStore.getChainname(this.chainIndex)},get chainid(){return this.chainStore.getChainid(this.chainIndex)},get residueType(){return this.residueMap.get(this.residueStore.residueTypeId[this.residueIndex])},get atomType(){return this.atomMap.get(this.atomStore.atomTypeId[this.index])},get residueAtomOffset(){return this.residueStore.atomOffset[this.residueIndex]},get resname(){return this.residueType.resname},get hetero(){return this.residueType.hetero},get atomname(){return this.atomType.atomname},get element(){return this.atomType.element},get vdw(){return this.atomType.vdw},get covalent(){return this.atomType.covalent},get x(){return this.atomStore.x[this.index]},set x(t){this.atomStore.x[this.index]=t},get y(){return this.atomStore.y[this.index]},set y(t){this.atomStore.y[this.index]=t},get z(){return this.atomStore.z[this.index]},set z(t){this.atomStore.z[this.index]=t},get serial(){return this.atomStore.serial[this.index]},set serial(t){this.atomStore.serial[this.index]=t},get bfactor(){return this.atomStore.bfactor[this.index]},set bfactor(t){this.atomStore.bfactor[this.index]=t},get occupancy(){return this.atomStore.occupancy[this.index]},set occupancy(t){this.atomStore.occupancy[this.index]=t},get altloc(){return this.atomStore.getAltloc(this.index)},set altloc(t){this.atomStore.setAltloc(this.index,t)},eachBond:function(t){for(var e=this.structure._bp,i=this.index,n=this.bondHash,r=n.indexArray,o=n.countArray[i],a=n.offsetArray[i],s=0;s<o;++s)e.index=r[a+s],t(e)},eachBondedAtom:function(t){var e=this.structure._ap,i=this.index;this.eachBond(function(n){i!==n.atomIndex1?e.index=n.atomIndex1:e.index=n.atomIndex2,t(e)})},isBackbone:function(){var t=this.residueType.backboneIndexList;if(t.length>0){var e=this.residueStore.atomOffset[this.residueIndex];return t.includes(this.index-e)}return!1},isPolymer:function(){if(this.structure.entityList.length>0)return this.entity.isPolymer();var t=this.residueType.moleculeType;return t===Wp||t===Xp||t===qp},isSidechain:function(){return this.isPolymer()&&!this.isBackbone()},isCg:function(){var t=this.residueType.backboneType;return t===tm||t===em||t===im},isHetero:function(){return 1===this.residueType.hetero},isProtein:function(){return this.residueType.moleculeType===Wp},isNucleic:function(){var t=this.residueType.moleculeType;return t===Xp||t===qp},isRna:function(){return this.residueType.moleculeType===Xp},isDna:function(){return this.residueType.moleculeType===qp},isWater:function(){return this.residueType.moleculeType===Gp},isIon:function(){return this.residueType.moleculeType===Hp},isSaccharide:function(){return this.residueType.moleculeType===Yp},isRing:function(){var t=this.residueType.getRings().flags;return 1===t[this.index-this.residueAtomOffset]},distanceTo:function(t){var e=this.atomStore,i=t.atomStore,n=this.index,r=t.index,o=e.x[n]-i.x[r],a=e.y[n]-i.y[r],s=e.z[n]-i.z[r],c=o*o+a*a+s*s;return Math.sqrt(c)},connectedTo:function(t){var e=this.atomStore,i=t.atomStore,n=this.index,r=t.index;if(e.altloc&&i.altloc){var o=e.altloc[n],a=i.altloc[r];if(0!==o&&0!==a&&32!==o&&32!==a&&o!==a)return!1}var s=e.x[n]-i.x[r],c=e.y[n]-i.y[r],u=e.z[n]-i.z[r],h=s*s+c*c+u*u;if(h<64&&this.isCg())return!0;if(isNaN(h))return!1;var l=this.covalent+t.covalent,d=l+.3,f=l-.5;return h<d*d&&h>f*f},positionFromArray:function(t,e){return void 0===e&&(e=0),this.x=t[e+0],this.y=t[e+1],this.z=t[e+2],this},positionToArray:function(t,e){void 0===t&&(t=[]),void 0===e&&(e=0);var i=this.index,n=this.atomStore;return t[e+0]=n.x[i],t[e+1]=n.y[i],t[e+2]=n.z[i],t},positionToVector3:function(t){return void 0===t&&(t=new N),t.x=this.x,t.y=this.y,t.z=this.z,t},positionFromVector3:function(t){return this.x=t.x,this.y=t.y,this.z=t.z,this},getResidueBonds:function(t){var e,i,n,r,o=this.residueAtomOffset,a=this.index-this.residueAtomOffset,s=this.residueType.getBonds(),c=s.atomIndices1,u=s.atomIndices2;for(t||(r=[]),e=c.indexOf(a);e!==-1;){if(n=u[e]+o,t)return n;r.push(n),e=c.indexOf(a,e+1)}for(i=u.indexOf(a);i!==-1;){if(n=c[i]+o,t)return n;r.push(n),i=u.indexOf(a,i+1)}return r},qualifiedName:function(t){var e="";return this.resname&&!t&&(e+="["+this.resname+"]"),void 0!==this.resno&&(e+=this.resno),this.inscode&&(e+="^"+this.inscode),this.chainname&&(e+=":"+this.chainname),this.atomname&&(e+="."+this.atomname),this.altloc&&(e+="%"+this.altloc),this.structure.modelStore.count>1&&(e+="/"+this.modelIndex),e},clone:function(){return new this.constructor(this.structure,this.index)},toObject:function(){return{index:this.index,residueIndex:this.residueIndex,atomno:this.atomno,resname:this.resname,x:this.x,y:this.y,z:this.z,element:this.element,chainname:this.chainname,resno:this.resno,serial:this.serial,vdw:this.vdw,covalent:this.covalent,hetero:this.hetero,bfactor:this.bfactor,altloc:this.altloc,atomname:this.atomname,modelindex:this.modelindex}}},Ko.prototype={constructor:Ko,type:"ResidueProxy",structure:void 0,chainStore:void 0,residueStore:void 0,atomStore:void 0,index:void 0,get entity(){return this.structure.entityList[this.entityIndex]},get entityIndex(){return this.chainStore.entityIndex[this.chainIndex]},get chain(){return this.structure.getChainProxy(this.chainIndex)},get chainIndex(){return this.residueStore.chainIndex[this.index]},set chainIndex(t){this.residueStore.chainIndex[this.index]=t},get atomOffset(){return this.residueStore.atomOffset[this.index]},set atomOffset(t){this.residueStore.atomOffset[this.index]=t},get atomCount(){return this.residueStore.atomCount[this.index]},set atomCount(t){this.residueStore.atomCount[this.index]=t},get atomEnd(){return this.atomOffset+this.atomCount-1},get modelIndex(){return this.chainStore.modelIndex[this.chainIndex]},get chainname(){return this.chainStore.getChainname(this.chainIndex)},get chainid(){return this.chainStore.getChainid(this.chainIndex)},get resno(){return this.residueStore.resno[this.index]},set resno(t){this.residueStore.resno[this.index]=t},get sstruc(){return this.residueStore.getSstruc(this.index)},set sstruc(t){this.residueStore.setSstruc(this.index,t)},get inscode(){return this.residueStore.getInscode(this.index)},set inscode(t){this.residueStore.getInscode(this.index,t)},get residueType(){return this.residueMap.get(this.residueStore.residueTypeId[this.index])},get resname(){return this.residueType.resname},get hetero(){return this.residueType.hetero},get moleculeType(){return this.residueType.moleculeType},get backboneType(){return this.residueType.backboneType},get backboneStartType(){return this.residueType.backboneStartType},get backboneEndType(){return this.residueType.backboneEndType},get traceAtomIndex(){return this.residueType.traceAtomIndex+this.atomOffset},get direction1AtomIndex(){return this.residueType.direction1AtomIndex+this.atomOffset},get direction2AtomIndex(){return this.residueType.direction2AtomIndex+this.atomOffset},get backboneStartAtomIndex(){return this.residueType.backboneStartAtomIndex+this.atomOffset},get backboneEndAtomIndex(){return this.residueType.backboneEndAtomIndex+this.atomOffset},get rungEndAtomIndex(){return this.residueType.rungEndAtomIndex+this.atomOffset},eachAtom:function(t,e){var i,n=this.atomCount,r=this.atomOffset,o=this.structure._ap,a=r+n;if(e&&e.atomOnlyTest){var s=e.atomOnlyTest;for(i=r;i<a;++i)o.index=i,s(o)&&t(o)}else for(i=r;i<a;++i)o.index=i,t(o)},isProtein:function(){return this.residueType.moleculeType===Wp},isNucleic:function(){var t=this.residueType.moleculeType;return t===Xp||t===qp},isRna:function(){return this.residueType.moleculeType===Xp},isDna:function(){return this.residueType.moleculeType===qp},isCg:function(){var t=this.residueType.backboneType;return t===tm||t===em||t===im},isPolymer:function(){if(this.structure.entityList.length>0)return this.entity.isPolymer();var t=this.residueType.moleculeType;return t===Wp||t===Xp||t===qp},isHetero:function(){return 1===this.residueType.hetero},isWater:function(){return this.residueType.moleculeType===Gp},isIon:function(){return this.residueType.moleculeType===Hp},isSaccharide:function(){return this.residueType.moleculeType===Yp},getAtomType:function(t){return this.atomMap.get(this.atomStore.atomTypeId[t])},getResname1:function(){return gm[this.resname.toUpperCase()]||"X"},getBackboneType:function(t){switch(t){case-1:return this.residueType.backboneStartType;case 1:return this.residueType.backboneEndType;default:return this.residueType.backboneType}},getAtomIndexByName:function(t){var e=this.residueType.getAtomIndexByName(t);return void 0!==e&&(e+=this.atomOffset),e},getAtomByName:function(t){return this.residueType.getAtomByName(t)},hasAtomWithName:function(t){return this.residueType.hasAtomWithName(t)},getAtomnameList:function(){console.warn("getAtomnameList - might be expensive");for(var t=this.atomCount,e=this.atomOffset,i=new Array(t),n=0;n<t;++n)i[n]=this.getAtomType(e+n).atomname;return i},connectedTo:function(t){var e=this.structure.getAtomProxy(this.backboneEndAtomIndex),i=this.structure.getAtomProxy(t.backboneStartAtomIndex);return!(!e||!i)&&e.connectedTo(i)},getNextConnectedResidue:function(){var t=this.chainStore.residueOffset[this.chainIndex],e=this.chainStore.residueCount[this.chainIndex],i=this.index+1;if(i<t+e){var n=this.structure.getResidueProxy(i);if(this.connectedTo(n))return n}else if(i===t+e){var r=this.structure.getResidueProxy(t);if(this.connectedTo(r))return r}},getPreviousConnectedResidue:function(t){var e=this.chainStore.residueOffset[this.chainIndex],i=this.index-1;if(i>=e){if(void 0===t&&(t=this.structure.getResidueProxy()),t.index=i,t.connectedTo(this))return t}else if(i===e-1){void 0===t&&(t=this.structure.getResidueProxy());var n=this.chainStore.residueCount[this.chainIndex];if(t.index=e+n-1,t.connectedTo(this))return t}},getBonds:function(){return this.residueType.getBonds(this)},getRings:function(){return this.residueType.getRings()},qualifiedName:function(t){var e="";return this.resname&&!t&&(e+="["+this.resname+"]"),void 0!==this.resno&&(e+=this.resno),this.inscode&&(e+="^"+this.inscode),this.chain&&(e+=":"+this.chainname),e+="/"+this.modelIndex},clone:function(){return new this.constructor(this.structure,this.index)},toObject:function(){return{index:this.index,chainIndex:this.chainIndex,atomOffset:this.atomOffset,atomCount:this.atomCount,resno:this.resno,resname:this.resname,sstruc:this.sstruc}}},Qo.prototype={constructor:Qo,type:"Polymer",structure:void 0,residueStore:void 0,atomStore:void 0,residueIndexStart:void 0,residueIndexEnd:void 0,residueCount:void 0,get chainIndex(){return this.residueStore.chainIndex[this.residueIndexStart]},get modelIndex(){return this.chainStore.modelIndex[this.chainIndex]},get chainname(){return this.chainStore.getChainname(this.chainIndex)},isProtein:function(){return this.__residueProxy.index=this.residueIndexStart,this.__residueProxy.isProtein()},isCg:function(){return this.__residueProxy.index=this.residueIndexStart,this.__residueProxy.isCg()},isNucleic:function(){return this.__residueProxy.index=this.residueIndexStart,this.__residueProxy.isNucleic()},getMoleculeType:function(){return this.__residueProxy.index=this.residueIndexStart,this.__residueProxy.moleculeType},getBackboneType:function(t){return this.__residueProxy.index=this.residueIndexStart,this.__residueProxy.getBackboneType(t)},getAtomIndexByType:function(t,e){this.isCyclic?t===-1?t=this.residueCount-1:t===this.residueCount&&(t=0):(t!==-1||this.isPrevConnected||(t+=1),t!==this.residueCount||this.isNextNextConnected||(t-=1));var i=this.__residueProxy;i.index=this.residueIndexStart+t;var n;switch(e){case"trace":n=i.traceAtomIndex;break;case"direction1":n=i.direction1AtomIndex;break;case"direction2":n=i.direction2AtomIndex;break;default:var r=i.getAtomByName(e);n=r?r.index:void 0}return n},eachAtom:function(t,e){this.eachResidue(function(i){i.eachAtom(t,e)},e)},eachAtomN:function(t,e,i){var n,r=this.residueCount,o=new Array(t);for(n=0;n<t;++n)o[n]=this.structure.getAtomProxy(this.getAtomIndexByType(n,i));e.apply(this,o);for(var a=t;a<r;++a){for(n=1;n<t;++n)o[n-1].index=o[n].index;o[t-1].index=this.getAtomIndexByType(a,i),e.apply(this,o)}},eachAtomN2:function(t,e,i){var n=this.atomOffset,r=this.atomCount,o=n+r;if(!(r<t)){for(var a=new Array(t),s=0;s<t;++s)a[s]=this.structure.getAtomProxy();var c=this.structure.atomSetCache["__"+i];void 0===c&&(uv.warn("no precomputed atomSet for: "+i),c=this.structure.getAtomSet(!1),this.eachResidue(function(t){var e=t.getAtomByName(i);c.add_unsafe(e.index)}));var u=0;c.forEach(function(i){if(i>=n&&i<o){for(var r=1;r<t;++r)a[r-1].index=a[r].index;a[t-1].index=i,u+=1,u>=t&&e.apply(this,a)}})}},eachDirectionAtomsN:function(t,e){var i=2*t,n=this.atomOffset,r=this.atomCount,o=n+r;if(!(r<t)){for(var a=new Array(i),s=0;s<i;++s)a[s]=this.structure.getAtomProxy();var c=this.structure.atomSetCache.__direction1,u=this.structure.atomSetCache.__direction2;if(void 0===c||void 0===u)return void uv.error("no precomputed atomSet for direction1 or direction2");var h=0;Ov.forEach(function(i,r){if(i>=n&&i<o&&r>=n&&r<o){for(var s=1;s<t;++s)a[s-1].index=a[s].index,a[s-1+t].index=a[s+t].index;a[t-1].index=i,a[t-1+t].index=r,h+=1,h>=t&&e.apply(this,a)}},c,u)}},eachResidue:function(t){for(var e=this.structure.getResidueProxy(),i=this.residueCount,n=this.residueIndexStart,r=0;r<i;++r)e.index=n+r,t(e)},qualifiedName:function(){var t=this.structure.getResidueProxy(this.residueIndexStart),e=this.structure.getResidueProxy(this.residueIndexEnd);return t.qualifiedName()+" - "+e.qualifiedName()}},Jo.prototype={constructor:Jo,type:"ChainProxy",structure:void 0,chainStore:void 0,index:void 0,get entity(){return this.structure.entityList[this.entityIndex]},get model(){return this.structure.getModelProxy(this.modelIndex)},get entityIndex(){return this.chainStore.entityIndex[this.index]},set entityIndex(t){this.chainStore.entityIndex[this.index]=t},get modelIndex(){return this.chainStore.modelIndex[this.index]},set modelIndex(t){this.chainStore.modelIndex[this.index]=t},get residueOffset(){return this.chainStore.residueOffset[this.index]},set residueOffset(t){this.chainStore.residueOffset[this.index]=t},get residueCount(){return this.chainStore.residueCount[this.index]},set residueCount(t){this.chainStore.residueCount[this.index]=t},get residueEnd(){return this.residueOffset+this.residueCount-1},get atomOffset(){return this.residueStore.atomOffset[this.residueOffset]},get atomEnd(){return this.residueStore.atomOffset[this.residueEnd]+this.residueStore.atomCount[this.residueEnd]-1},get atomCount(){return 0===this.residueCount?0:this.atomEnd-this.atomOffset+1},get chainname(){return this.chainStore.getChainname(this.index)},set chainname(t){this.chainStore.setChainname(this.index,t)},get chainid(){return this.chainStore.getChainid(this.index)},set chainid(t){this.chainStore.setChainid(this.index,t)},eachAtom:function(t,e){this.eachResidue(function(i){i.eachAtom(t,e)},e)},eachResidue:function(t,e){var i,n=this.residueCount,r=this.residueOffset,o=this.structure._rp,a=r+n;if(e&&e.test){var s=e.residueOnlyTest;if(s)for(i=r;i<a;++i)o.index=i,s(o)&&t(o,e);else for(i=r;i<a;++i)o.index=i,t(o,e)}else for(i=r;i<a;++i)o.index=i,t(o)},eachResidueN:function(t,e){var i,n=this.residueCount,r=this.residueOffset,o=r+n;if(!(n<t)){var a=new Array(t);for(i=0;i<t;++i)a[i]=this.structure.getResidueProxy(r+i);e.apply(this,a);for(var s=r+t;s<o;++s){for(i=0;i<t;++i)a[i].index+=1;e.apply(this,a)}}},eachPolymer:function(t,e){for(var i,n,r=e?e.residueOnlyTest:void 0,o=this.model.structure,a=this.residueCount,s=this.residueOffset,c=s+a,u=this.structure.getResidueProxy(),h=this.structure.getResidueProxy(s),l=this.structure.getAtomProxy(),d=this.structure.getAtomProxy(),f=!0,p=s+1;p<c;++p){u.index=h.index,h.index=p,f&&(i=u.index,f=!1),n=h.index;var m=f?u.backboneEndType:u.backboneType,g=h.backboneType;
	m!==Zp&&m===g?(l.index=u.backboneEndAtomIndex,d.index=h.backboneStartAtomIndex,l&&d&&l.connectedTo(d)&&(!r||r(u)&&r(h))||(u.index-i>1&&t(new Qo(o,i,u.index)),i=n)):(m!==Zp&&u.index-i>1&&t(new Qo(o,i,u.index)),i=n)}n-i>1&&this.structure.getResidueProxy(i).backboneStartType&&t(new Qo(o,i,n))},qualifiedName:function(){var t=":"+this.chainname+"/"+this.modelIndex;return t},clone:function(){return new this.constructor(this.structure,this.index)},toObject:function(){return{index:this.index,residueOffset:this.residueOffset,residueCount:this.residueCount,chainname:this.chainname}}},ta.prototype={constructor:ta,type:"ModelProxy",structure:void 0,modelStore:void 0,index:void 0,get chainOffset(){return this.modelStore.chainOffset[this.index]},set chainOffset(t){this.modelStore.chainOffset[this.index]=t},get chainCount(){return this.modelStore.chainCount[this.index]},set chainCount(t){this.modelStore.chainCount[this.index]=t},get residueOffset(){return this.chainStore.residueOffset[this.chainOffset]},get atomOffset(){return this.residueStore.atomOffset[this.residueOffset]},get chainEnd(){return this.chainOffset+this.chainCount-1},get residueEnd(){return this.chainStore.residueOffset[this.chainEnd]+this.chainStore.residueCount[this.chainEnd]-1},get atomEnd(){return this.residueStore.atomOffset[this.residueEnd]+this.residueStore.atomCount[this.residueEnd]-1},get residueCount(){return 0===this.chainCount?0:this.residueEnd-this.residueOffset+1},get atomCount(){return 0===this.residueCount?0:this.atomEnd-this.atomOffset+1},eachAtom:function(t,e){this.eachChain(function(i){i.eachAtom(t,e)},e)},eachResidue:function(t,e){this.eachChain(function(i){i.eachResidue(t,e)},e)},eachPolymer:function(t,e){if(e&&e.chainOnlyTest){var i=e.chainOnlyTest;this.eachChain(function(n){i(n)&&n.eachPolymer(t,e)})}else this.eachChain(function(i){i.eachPolymer(t,e)})},eachChain:function(t,e){var i,n=this.chainCount,r=this.chainOffset,o=this.structure._cp,a=r+n;if(e&&e.test){var s=e.chainOnlyTest;if(s)for(i=r;i<a;++i)o.index=i,s(o)&&t(o,e);else for(i=r;i<a;++i)o.index=i,t(o,e)}else for(i=r;i<a;++i)o.index=i,t(o)},qualifiedName:function(){var t="/"+this.index;return t},clone:function(){return new this.constructor(this.structure,this.index)},toObject:function(){return{index:this.index,chainOffset:this.chainOffset,chainCount:this.chainCount}}},ea.prototype={constructor:ea,type:"Structure",finalizeAtoms:function(){this.atomSet=this.getAtomSet(),this.atomCount=this.atomStore.count,this.boundingBox=this.getBoundingBox(),this.center=this.boundingBox.center(),this.spatialHash=new bo(this.atomStore,this.boundingBox)},finalizeBonds:function(){this.bondSet=this.getBondSet(),this.bondCount=this.bondStore.count,this.bondHash=new xo(this.bondStore,this.atomStore.count),this.atomSetCache={},this.atomSetDict.rung||(this.atomSetDict.rung=this.getAtomSet(!1));for(var t in this.atomSetDict){var e=this.atomSetDict[t],i=this.getAtomSet(!1);this.atomSetCache["__"+t]=i.intersection(e)}},getBondProxy:function(t){return new Yo(this,t)},getAtomProxy:function(t){return new Zo(this,t)},getResidueProxy:function(t){return new Ko(this,t)},getChainProxy:function(t){return new Jo(this,t)},getModelProxy:function(t){return new ta(this,t)},getBondSet:function(){t.Debug&&uv.time("Structure.getBondSet");var e=this.bondStore.count,i=new Ov(e),n=this.atomSet;if(n)for(var r=this.getBondProxy(),o=0;o<e;++o)r.index=o,n.has(r.atomIndex1)&&n.has(r.atomIndex2)&&i.add_unsafe(r.index);else i.set_all(!0);return t.Debug&&uv.timeEnd("Structure.getBondSet"),i},getBackboneBondSet:function(){t.Debug&&uv.time("Structure.getBackboneBondSet");var e=this.backboneBondStore.count,i=new Ov(e),n=this.atomSetCache.__backbone;if(n){var r=this.getBondProxy();r.bondStore=this.backboneBondStore;for(var o=0;o<e;++o)r.index=o,n.has(r.atomIndex1)&&n.has(r.atomIndex2)&&i.add_unsafe(r.index)}else i.set_all(!0);return t.Debug&&uv.timeEnd("Structure.getBackboneBondSet"),i},getRungBondSet:function(){t.Debug&&uv.time("Structure.getRungBondSet");var e=this.rungBondStore.count,i=new Ov(e),n=this.atomSetCache.__rung;if(n){var r=this.getBondProxy();r.bondStore=this.rungBondStore;for(var o=0;o<e;++o)r.index=o,n.has(r.atomIndex1)&&n.has(r.atomIndex2)&&i.add_unsafe(r.index)}else i.set_all(!0);return t.Debug&&uv.timeEnd("Structure.getRungBondSet"),i},getAtomSet:function(e){t.Debug&&uv.time("Structure.getAtomSet");var i,n=this.atomStore.count;if(e&&"Bitset"===e.type)i=e;else if(e===!1)i=new Ov(n);else if(e===!0)i=new Ov(n),i.set_all(!0);else if(e&&e.test){var r=e.string;r in this.atomSetCache?i=this.atomSetCache[r]:(i=new Ov(n),this.eachAtom(function(t){i.add_unsafe(t.index)},e),this.atomSetCache[r]=i)}else i=new Ov(n),i.set_all(!0);return t.Debug&&uv.timeEnd("Structure.getAtomSet"),i},getAtomSetWithinSelection:function(t,e){var i=this.spatialHash,n=this.getAtomSet(!1),r=this.getAtomProxy();return this.getAtomSet(t).forEach(function(t){r.index=t,i.within(r.x,r.y,r.z,e).forEach(function(t){n.add_unsafe(t)})}),n},getAtomSetWithinPoint:function(t,e){var i=t,n=this.getAtomSet(!1);return this.spatialHash.within(i.x,i.y,i.z,e).forEach(function(t){n.add_unsafe(t)}),n},getAtomSetWithinVolume:function(t,e,i,n,r){t.filterData(i,n,r);for(var o=t.dataPosition,a=o.length,s=t.matrix.getMaxScaleOnAxis(),c=this.getAtomSet(!1),u=0;u<a;u+=3)this.spatialHash.within(o[u],o[u+1],o[u+2],s).forEach(function(t){c.add_unsafe(t)});return c},getAtomSetWithinGroup:function(t){var e=this.atomStore.residueIndex,i=this.getAtomSet(!1),n=this.getResidueProxy();return this.getAtomSet(t).forEach(function(t){n.index=e[t];for(var r=n.atomOffset;r<=n.atomEnd;++r)i.add_unsafe(r)}),i},getSelection:function(){return!1},getStructure:function(){return this},eachEntity:function(t,e){this.entityList.forEach(function(i){void 0!==e&&i.getEntityType()!==e||t(i)})},eachBond:function(t,e){var i=this.getBondProxy(),n=this.bondSet;if(e&&e.test&&(n=n?n.new_intersection(this.getBondSet(e)):this.getBondSet(e)),n)n.forEach(function(e){i.index=e,t(i)});else for(var r=this.bondStore.count,o=0;o<r;++o)i.index=o,t(i)},eachAtom:function(t,e){if(e&&e.test)this.eachModel(function(i){i.eachAtom(t,e)},e);else for(var i=this.atomStore.count,n=this.getAtomProxy(),r=0;r<i;++r)n.index=r,t(n)},eachResidue:function(t,e){var i;if(e&&e.test){var n=this.modelStore.count,r=this.getModelProxy();if(e.modelOnlyTest){var o=e.modelOnlyTest;for(i=0;i<n;++i)r.index=i,o(r)&&r.eachResidue(t,e)}else for(i=0;i<n;++i)r.index=i,r.eachResidue(t,e)}else{var a=this.residueStore.count,s=this.getResidueProxy();for(i=0;i<a;++i)s.index=i,t(s)}},eachResidueN:function(t,e){var i,n,r=this.residueStore.count;if(!(r<t)){var o=new Array(t);for(i=0;i<t;++i)o[i]=this.getResidueProxy(i);for(e.apply(this,o),n=t;n<r;++n){for(i=0;i<t;++i)o[i].index+=1;e.apply(this,o)}}},eachPolymer:function(t,e){if(e&&e.modelOnlyTest){var i=e.modelOnlyTest;this.eachModel(function(n){i(n)&&n.eachPolymer(t,e)})}else this.eachModel(function(i){i.eachPolymer(t,e)})},eachChain:function(t,e){if(e&&e.test)this.eachModel(function(i){i.eachChain(t,e)});else for(var i=this.chainStore.count,n=this.getChainProxy(),r=0;r<i;++r)n.index=r,t(n)},eachModel:function(t,e){var i,n=this.modelStore.count,r=this.getModelProxy();if(e&&e.test){var o=e.modelOnlyTest;if(o)for(i=0;i<n;++i)r.index=i,o(r)&&t(r,e);else for(i=0;i<n;++i)r.index=i,t(r,e)}else for(i=0;i<n;++i)r.index=i,t(r)},getAtomData:function(t){var e=Object.assign({},t);e.colorParams&&(e.colorParams.structure=this.getStructure());var i,n,r,o,a,s,c,u,h=e.what,l=d(e.atomSet,this.atomSet),f={},p=this.getAtomProxy(),m=l.size();if(h&&!h.position||(o=new Float32Array(3*m),f.position=o),h&&!h.color||(a=new Float32Array(3*m),f.color=a,n=dv.getScheme(e.colorParams)),!h||h.pickingColor){s=new Float32Array(3*m),f.pickingColor=s;var g=Object.assign(e.colorParams,{scheme:"picking"});r=dv.getScheme(g)}return h&&!h.radius||(c=new Float32Array(m),f.radius=c,i=new Ir(e.radiusParams.radius,e.radiusParams.scale)),h&&!h.index||(u=new Float32Array(m),f.index=u),l.forEach(function(t,e){var h=3*e;p.index=t,o&&p.positionToArray(o,h),a&&n.atomColorToArray(p,a,h),s&&r.atomColorToArray(p,s,h),c&&(c[e]=i.atomRadius(p)),u&&(u[e]=t)}),f},getBondData:function(t){var e=Object.assign({},t);e.colorParams&&(e.colorParams.structure=this.getStructure());var i,n,r,o,a,s,c,u,h,l,f,p=e.what,m=d(e.bondSet,this.bondSet),g=d(e.multipleBond,"off"),v="off"!==g,y="offset"===g,b=d(e.bondScale,.4),x=d(e.bondSpacing,1),_={},w=this.getBondProxy();e.bondStore&&(w.bondStore=e.bondStore);var S,A=this.getAtomProxy(),M=this.getAtomProxy();if(v){var C=w.bondStore.bondOrder;S=0,m.forEach(function(t){S+=C[t]})}else S=m.size();if(p&&!p.position||(o=new Float32Array(3*S),a=new Float32Array(3*S),_.position1=o,_.position2=a),p&&!p.color||(s=new Float32Array(3*S),c=new Float32Array(3*S),_.color1=s,_.color2=c,n=dv.getScheme(e.colorParams)),!p||p.pickingColor){u=new Float32Array(3*S),h=new Float32Array(3*S),_.pickingColor1=u,_.pickingColor2=h;var P=Object.assign(e.colorParams,{scheme:"picking"});r=dv.getScheme(P)}(!p||p.radius||v&&p.position)&&(i=new Ir(e.radiusParams.radius,e.radiusParams.scale)),p&&!p.radius||(l=new Float32Array(S),e.radius2?(f=new Float32Array(S),_.radius1=l,_.radius2=f):_.radius=l);var T,E,I,L,R,O,D,k=0,F=new N,z=new N,B=new N;return m.forEach(function(t){if(E=3*k,w.index=t,A.index=w.atomIndex1,M.index=w.atomIndex2,L=w.bondOrder,o&&(v&&L>1?(R=i.atomRadius(A),O=R*b/(.5*L),w.calculateShiftDir(B),y?(D=2*x*R,B.multiplyScalar(D),B.negate(),z.subVectors(M,A).multiplyScalar(Math.max(.1,D/1.88)),A.positionToArray(o,E),M.positionToArray(a,E),L>=2&&(F.addVectors(A,B).add(z).toArray(o,E+3),F.addVectors(M,B).sub(z).toArray(a,E+3),L>=3&&(F.subVectors(A,B).add(z).toArray(o,E+6),F.subVectors(M,B).sub(z).toArray(a,E+6)))):(D=(x-b)*R,B.multiplyScalar(D),2===L?(F.addVectors(A,B).toArray(o,E),F.subVectors(A,B).toArray(o,E+3),F.addVectors(M,B).toArray(a,E),F.subVectors(M,B).toArray(a,E+3)):3===L?(A.positionToArray(o,E),F.addVectors(A,B).toArray(o,E+3),F.subVectors(A,B).toArray(o,E+6),M.positionToArray(a,E),F.addVectors(M,B).toArray(a,E+3),F.subVectors(M,B).toArray(a,E+6)):(A.positionToArray(o,E),M.positionToArray(a,E)))):(A.positionToArray(o,E),M.positionToArray(a,E))),s&&(n.bondColorToArray(w,1,s,E),n.bondColorToArray(w,0,c,E),v&&L>1))for(T=1;T<L;++T)I=3*T+E,wr(s,E,I,3),wr(c,E,I,3);if(u&&(r.bondColorToArray(w,1,u,E),r.bondColorToArray(w,0,h,E),v&&L>1))for(T=1;T<L;++T)I=3*T+E,wr(u,E,I,3),wr(h,E,I,3);if(l&&(l[k]=i.atomRadius(A),v&&L>1))for(O=l[k]*b/(y?1:.5*L),T=y?1:0;T<L;++T)l[k+T]=O;if(f&&(f[k]=i.atomRadius(M),v&&L>1))for(O=f[k]*b/(y?1:.5*L),T=y?1:0;T<L;++T)f[k+T]=O;k+=v?L:1}),_},getBackboneAtomData:function(t){return t=Object.assign({atomSet:this.atomSetCache.__backbone},t),this.getAtomData(t)},getBackboneBondData:function(t){return t=Object.assign({bondSet:this.getBackboneBondSet(),bondStore:this.backboneBondStore},t),this.getBondData(t)},getRungAtomData:function(t){return t=Object.assign({atomSet:this.atomSetCache.__rung},t),this.getAtomData(t)},getRungBondData:function(t){return t=Object.assign({bondSet:this.getRungBondSet(),bondStore:this.rungBondStore},t),this.getBondData(t)},getBoundingBox:function(e,i){t.Debug&&uv.time("getBoundingBox"),i=i||new Et;var n=+(1/0),r=+(1/0),o=+(1/0),a=-(1/0),s=-(1/0),c=-(1/0);return this.eachAtom(function(t){var e=t.x,i=t.y,u=t.z;e<n&&(n=e),i<r&&(r=i),u<o&&(o=u),e>a&&(a=e),i>s&&(s=i),u>c&&(c=u)},e),i.min.set(n,r,o),i.max.set(a,s,c),t.Debug&&uv.timeEnd("getBoundingBox"),i},getPrincipalAxes:function(e){t.Debug&&uv.time("getPrincipalAxes");var i=0,n=new Zr(3,this.atomCount),r=n.data;return this.eachAtom(function(t){r[i+0]=t.x,r[i+1]=t.y,r[i+2]=t.z,i+=3},e),t.Debug&&uv.timeEnd("getPrincipalAxes"),uo(n)},atomCenter:function(t){return t?this.getBoundingBox(t).center():this.center.clone()},getSequence:function(t){var e=[],i=this.getResidueProxy();return this.eachAtom(function(t){i.index=t.residueIndex,t.index===i.traceAtomIndex&&e.push(i.getResname1())},t),e},getAtomIndices:function(t){var e;if(t&&t.string)e=[],this.eachAtom(function(t){e.push(t.index)},t);else{var i={what:{index:!0}};e=this.getAtomData(i).index}return e},getChainnameCount:function(t){var e=new Set;return this.eachChain(function(t){t.residueCount&&e.add(t.chainname)},t),e.size},updatePosition:function(t){var e=0;this.eachAtom(function(i){i.positionFromArray(t,e),e+=3})},refreshPosition:function(){this.getBoundingBox(void 0,this.boundingBox),this.boundingBox.center(this.center),this.spatialHash=new bo(this.atomStore,this.boundingBox)},dispose:function(){this.frames&&(this.frames.length=0),this.boxes&&(this.boxes.length=0),this.bondStore.dispose(),this.backboneBondStore.dispose(),this.rungBondStore.dispose(),this.atomStore.dispose(),this.residueStore.dispose(),this.chainStore.dispose(),this.modelStore.dispose(),delete this.bondStore,delete this.atomStore,delete this.residueStore,delete this.chainStore,delete this.modelStore,delete this.frames,delete this.boxes,delete this.cif,delete this.bondSet,delete this.atomSet}},ia.prototype={constructor:ia,type:"Surface",set:function(t,e,i,n,r){this.position=t,this.index=e,this.normal=i,this.color=n,this.atomindex=r,this.size=t.length/3},fromGeometry:function(e){t.Debug&&uv.time("GeometrySurface.fromGeometry");var i;e instanceof ae?(e.computeVertexNormals(!0),i=(new ue).fromGeometry(e)):i=e instanceof ue?e:e[0],i.boundingBox||i.computeBoundingBox(),this.center.copy(i.boundingBox.center()),this.boundingBox.copy(i.boundingBox);var n,r,o,a;if(i instanceof ue){var s=i.attributes,c=!!s.normal&&s.normal.array;(!c||0===c[0]&&0===c[1]&&0===c[2])&&i.computeVertexNormals(),n=s.position.array,o=s.index?s.index.array:null,a=s.normal.array}this.set(n,o,a,r,void 0),t.Debug&&uv.timeEnd("GeometrySurface.setGeometry")},getPosition:function(){return this.position},getColor:function(t){var e,i,n,r=t||{},o=this.size;if("volume"===r.scheme){var a=new N,s=this.position;for(n=dv.getScheme(r),i=new Float32Array(3*o),e=0;e<o;++e){var c=3*e;a.set(s[c],s[c+1],s[c+2]),n.positionColorToArray(a,i,c)}}else if(this.atomindex){r.surface=this,i=new Float32Array(3*o),n=dv.getScheme(r);var u=r.structure.getAtomProxy(),h=this.atomindex;for(e=0;e<o;++e)u.index=h[e],n.atomColorToArray(u,i,3*e)}else{var l=new Pt(r.value);i=br(o,l.r,l.g,l.b)}return i},getPickingColor:function(t){var e=Object.assign(t||{});return e.scheme="picking",this.getColor(e)},getNormal:function(){return this.normal},getSize:function(t){return yr(this.size,t)},getIndex:function(){return this.index},getFilteredIndex:function(t,e){if(t&&this.atomindex){for(var i=new _n(t),n=e.getAtomSet(i),r=[],o=this.atomindex,a=this.index,s=a.length,c=0,u=0;u<s;u+=3){var h=a[u],l=a[u+1],d=a[u+2],f=o[h],p=o[l],m=o[d];n.has(f)&&n.has(p)&&n.has(m)&&(r[c]=h,r[c+1]=l,r[c+2]=d,c+=3)}var g=this.position.length/3>65535?Uint32Array:Uint16Array;return new g(r)}return this.index},getAtomindex:function(){return this.atomindex},dispose:function(){}},na.prototype.constructor=na,ra.prototype.constructor=ra,sa.__deps=[oa,aa],ca.__deps=[ua],ua.__deps=[Br,zr,Ur,kr],la.__deps=[wn,Hr,Wr,$r,Vr,Xr,qr,Br,Yr,ho,fo,mo,po,go],da.__deps=[ca,ua,sa,Dr,Nr,vo,yo],lv.add("surf",function(t,e){var i=t.data.args,n=t.data.params;if(i&&(self.volsurf=new da(i[0],i[1],i[2],i[3],i[4])),n){var r=self.volsurf.getSurface(n.isolevel,n.smooth,n.box,n.matrix),o=[r.position.buffer,r.index.buffer];r.normal&&o.push(r.normal.buffer),r.atomindex&&o.push(r.atomindex.buffer),e({sd:r,p:n},o)}},[da]),fa.prototype={constructor:fa,type:"Volume",setData:function(t,e,i,n,r){this.nx=e||1,this.ny=i||1,this.nz=n||1,this.data=t||new Float32Array(1),this.__data=this.data,this.setDataAtomindex(r),delete this.mc,delete this.__isolevel,delete this.__smooth,delete this.__minValue,delete this.__maxValue,delete this.__dataPositionBuffer,delete this.__dataPosition,delete this.__dataBuffer,delete this.__dataMin,delete this.__dataMax,delete this.__dataMean,delete this.__dataRms,this.worker&&this.worker.terminate()},setMatrix:function(t){this.matrix.copy(t);var e=this.boundingBox,i=this.center,n=this.nx-1,r=this.ny-1,o=this.nz-1;e.makeEmpty(),e.expandByPoint(i.set(n,r,o)),e.expandByPoint(i.set(n,r,0)),e.expandByPoint(i.set(n,0,o)),e.expandByPoint(i.set(n,0,0)),e.expandByPoint(i.set(0,r,o)),e.expandByPoint(i.set(0,0,o)),e.expandByPoint(i.set(0,r,0)),e.expandByPoint(i.set(0,0,0)),e.applyMatrix4(this.matrix),e.center(this.center);var a=this.matrix.elements,s=new N(a[0],a[1],a[2]),c=new N(a[4],a[5],a[6]),u=new N(a[8],a[9],a[10]),h=new N,l=this.normalMatrix.elements;h.crossVectors(c,u),l[0]=h.x,l[1]=h.y,l[2]=h.z,h.crossVectors(u,s),l[3]=h.x,l[4]=h.y,l[5]=h.z,h.crossVectors(s,c),l[6]=h.x,l[7]=h.y,l[8]=h.z,this.inverseMatrix.getInverse(this.matrix)},setDataAtomindex:function(t){this.dataAtomindex=t,this.__dataAtomindex=this.dataAtomindex,delete this.__dataAtomindexBuffer},getBox:function(t,e,i){return i||(i=new Et),i.set(t,t),i.expandByScalar(e),i.applyMatrix4(this.inverseMatrix),i.min.round(),i.max.round(),i},__getBox:function(t,e){if(t&&e){this.__box||(this.__box=new Et);var i=this.getBox(t,e,this.__box);return[i.min.toArray(),i.max.toArray()]}},makeSurface:function(t,e,i){var n=new ia("","",t);return n.info.isolevel=e,n.info.smooth=i,n},getSurface:function(t,e,i,n){t=isNaN(t)?this.getValueForSigma(2):t,e=e||0,void 0===this.volsurf&&(this.volsurf=new da(this.__data,this.nx,this.ny,this.nz,this.__dataAtomindex));var r=this.__getBox(i,n),o=this.volsurf.getSurface(t,e,r,this.matrix.elements);return this.makeSurface(o,t,e)},getSurfaceWorker:function(t,e,i,n,r){if(t=isNaN(t)?this.getValueForSigma(2):t,e=e||0,window.Worker){void 0===this.workerPool&&(this.workerPool=new ra("surf",2));var o={},a=this.workerPool.getNextWorker();0===a.postCount&&(o.args=[this.__data,this.nx,this.ny,this.nz,this.__dataAtomindex]),o.params={isolevel:t,smooth:e,box:this.__getBox(i,n),matrix:this.matrix.elements},a.post(o,void 0,function(t){var e=t.data.sd,i=t.data.p;r(this.makeSurface(e,i.isolevel,i.smooth))}.bind(this),function(o){console.warn("Volume.getSurfaceWorker error - trying without worker",o);var a=this.getSurface(t,e,i,n);r(a)}.bind(this))}else{var s=this.getSurface(t,e,i,n);r(s)}},getValueForSigma:function(t){return t=void 0!==t?t:2,this.getDataMean()+t*this.getDataRms()},getSigmaForValue:function(t){return t=void 0!==t?t:0,(t-this.getDataMean())/this.getDataRms()},filterData:function(t,e,i){isNaN(t)&&this.header&&(t=this.header.DMEAN+2*this.header.ARMS),t=void 0===t||isNaN(t)?-(1/0):t,e=void 0!==e?e:1/0,i=i||!1,this.dataPosition||this.makeDataPosition();var n=this.__dataPosition,r=this.__data;if(t!==this.__minValue||e!=this.__maxValue||i!==this.__outside){if(t===-(1/0)&&e===1/0)this.dataPosition=n,this.data=r;else{var o=r.length;this.__dataBuffer||(this.__dataPositionBuffer=new ArrayBuffer(3*o*4),this.__dataBuffer=new ArrayBuffer(4*o));for(var a=new Float32Array(this.__dataPositionBuffer),s=new Float32Array(this.__dataBuffer),c=0,u=0;u<o;++u){var h=3*u,l=r[u];if(!i&&l>=t&&l<=e||i&&(l<t||l>e)){var d=3*c;a[d+0]=n[h+0],a[d+1]=n[h+1],a[d+2]=n[h+2],s[c]=l,c+=1}}this.dataPosition=new Float32Array(this.__dataPositionBuffer,0,3*c),this.data=new Float32Array(this.__dataBuffer,0,c)}this.__minValue=t,this.__maxValue=e,this.__outside=i}},makeDataPosition:function(){for(var t=this.nz,e=this.ny,i=this.nx,n=new Float32Array(i*e*t*3),r=0,o=0;o<t;++o)for(var a=0;a<e;++a)for(var s=0;s<i;++s)n[r+0]=s,n[r+1]=a,n[r+2]=o,r+=3;this.matrix.applyToVector3Array(n),this.dataPosition=n,this.__dataPosition=n},getDataAtomindex:function(){return this.dataAtomindex},getDataPosition:function(){return this.dataPosition},getDataColor:function(t){var e=t||{};e.volume=this,e.scale=e.scale||"Spectral",e.domain=e.domain||[this.getDataMin(),this.getDataMax()];for(var i=dv.getScheme(e),n=this.dataPosition.length/3,r=new Float32Array(3*n),o=0;o<n;++o)i.volumeColorToArray(o,r,3*o);return r},getPickingDataColor:function(t){var e=Object.assign(t||{});return e.scheme="picking",this.getDataColor(e)},getDataSize:function(t,e){var i,n,r=this.dataPosition.length/3;switch(t){case"value":n=new Float32Array(this.data);break;case"abs-value":for(n=new Float32Array(this.data),i=0;i<r;++i)n[i]=Math.abs(n[i]);break;case"value-min":n=new Float32Array(this.data);var o=this.getDataMin();for(i=0;i<r;++i)n[i]-=o;break;case"deviation":n=new Float32Array(this.data);break;default:n=yr(r,t)}if(1!==e)for(i=0;i<r;++i)n[i]*=e;return n},getDataMin:function(){if(void 0===this.__dataMin){for(var t=this.__data,e=t.length,i=1/0,n=0;n<e;++n)i=Math.min(i,t[n]);this.__dataMin=i}return this.__dataMin},getDataMax:function(){if(void 0===this.__dataMax){for(var t=this.__data,e=t.length,i=-(1/0),n=0;n<e;++n)i=Math.max(i,t[n]);this.__dataMax=i}return this.__dataMax},getDataMean:function(){if(void 0===this.__dataMean){for(var t=this.__data,e=t.length,i=0,n=0;n<e;++n)i+=t[n];this.__dataMean=i/e}return this.__dataMean},getDataRms:function(){if(void 0===this.__dataRms){var t,e,i=this.__data,n=i.length,r=0;for(e=0;e<n;++e)t=i[e],r+=t*t;this.__dataRms=Math.sqrt(r/n)}return this.__dataRms},clone:function(){var t=new fa(this.name,this.path,this.__data,this.nx,this.ny,this.nz,this.__dataAtomindex);return t.matrix.copy(this.matrix),this.header&&(t.header=Object.assign({},this.header)),t},dispose:function(){this.workerPool&&this.workerPool.terminate()}},ma.prototype={constructor:ma,_superpose:function(e,i){this.mean1=io(e),this.mean2=io(i),no(e,this.mean1),no(i,this.mean2),Kr(this.coords1t,e),Kr(this.coords2t,i),Qr(this.A,this.coords2t,this.coords1t),co(this.A,this.W,this.U,this.V),Jr(this.V,this.VH),eo(this.R,this.U,this.VH),to(this.R)<0&&(t.Debug&&uv.log("R not a right handed system"),eo(this.tmp,this.c,this.VH),eo(this.R,this.U,this.tmp))},prepCoords:function(t,e){var i=0,n=e.data;"function"==typeof t.eachAtom?t.eachAtom(function(t){n[i+0]=t.x,n[i+1]=t.y,n[i+2]=t.z,i+=3}):t instanceof Float32Array?n.set(t):uv.warn("prepCoords: input type unknown")},transform:function(t){var e;"function"==typeof t.eachAtom?e=t.atomCount:t instanceof Float32Array&&(e=t.length/3);var i=new Zr(3,e),n=new Zr(e,3);this.prepCoords(t,i),no(i,this.mean1),Qr(n,this.R,i),Kr(i,n),ro(i,this.mean2);var r=0,o=i.data;"function"==typeof t.eachAtom?t.eachAtom(function(t){t.x=o[r+0],t.y=o[r+1],t.z=o[r+2],r+=3}):t instanceof Float32Array?t.set(o.subarray(0,3*e)):uv.warn("transform: input type unknown")}},ga.prototype={constructor:ga,setStructure:function(t){this.structure=t,this.atomCount=t.atomCount,this.makeAtomIndices(),this.saveInitialStructure(),this.backboneIndices=this.getIndices(new _n("backbone and not hydrogen")),this.makeIndices(),this.frameCache=[],this.boxCache=[],this.pathCache=[],this.frameCacheSize=0,this.currentFrame=-1},saveInitialStructure:function(){var t=0,e=new Float32Array(3*this.atomCount);this.structure.eachAtom(function(i){e[t+0]=i.x,e[t+1]=i.y,e[t+2]=i.z,t+=3}),this.initialStructure=e},setSelection:function(t){return this.selection.setString(t),this},getIndices:function(t){var e;if(t&&t.test){var i=0,n=t.test;e=[],this.structure.eachAtom(function(t){n(t)&&e.push(i),i+=1})}else e=this.structure.getAtomIndices(this.selection);return e},makeIndices:function(){this.indices=this.getIndices(this.selection);var t,e,i=3*this.indices.length;this.coords1=new Float32Array(i),this.coords2=new Float32Array(i);var n=this.initialStructure,r=this.coords2;for(t=0;t<i;t+=3)e=3*this.indices[t/3],r[t+0]=n[e+0],r[t+1]=n[e+1],r[t+2]=n[e+2]},makeAtomIndices:function(){uv.error("Trajectory.makeAtomIndices not implemented")},getNumframes:function(){uv.error("Trajectory.loadFrame not implemented")},resetCache:function(){return this.frameCache=[],this.boxCache=[],this.pathCache=[],this.frameCacheSize=0,this.setFrame(this.currentFrame),this},setParameters:function(t){var e=t,i=this.params,n=!1;void 0!==e.centerPbc&&e.centerPbc!==i.centerPbc&&(i.centerPbc=e.centerPbc,n=!0),void 0!==e.removePbc&&e.removePbc!==i.removePbc&&(i.removePbc=e.removePbc,n=!0),void 0!==e.superpose&&e.superpose!==i.superpose&&(i.superpose=e.superpose,n=!0),n&&this.resetCache()},setFrame:function(t,e){return void 0===t?this:(this.inProgress=!0,t=parseInt(t),t===-1||this.frameCache[t]?this.updateStructure(t,e):this.loadFrame(t,function(){this.updateStructure(t,e)}.bind(this)),this)},interpolate:function(){var t=function(t,e,i,n,r,o){var a=(i-t)*o,s=(n-e)*o,c=r*r,u=r*c;return(2*e-2*i+a+s)*u+(-3*e+3*i-2*a-s)*c+a*r+e},e=function(t,e,i){return t+(e-t)*i};return function(i,n,r,o,a,s,c){var u,h=this.frameCache,l=h[i],d=h[n],f=h[r],p=h[o],m=l.length,g=new Float32Array(m);if("spline"===s)for(u=0;u<m;u+=3)g[u+0]=t(p[u+0],f[u+0],d[u+0],l[u+0],a,1),g[u+1]=t(p[u+1],f[u+1],d[u+1],l[u+1],a,1),g[u+2]=t(p[u+2],f[u+2],d[u+2],l[u+2],a,1);else for(u=0;u<m;u+=3)g[u+0]=e(d[u+0],l[u+0],a),g[u+1]=e(d[u+1],l[u+1],a),g[u+2]=e(d[u+2],l[u+2],a);this.structure.updatePosition(g),this.currentFrame=i,this.signals.frameChanged.dispatch(i),"function"==typeof c&&c()}}(),setFrameInterpolated:function(t,e,i,n,r,o,a){if(void 0===t)return this;var s=this.frameCache,c=[];return s[n]||c.push(n),s[i]||c.push(i),s[e]||c.push(e),s[t]||c.push(t),c.length?this.loadFrame(c,function(){this.interpolate(t,e,i,n,r,o,a)}.bind(this)):this.interpolate(t,e,i,n,r,o,a),this},loadFrame:function(t,e){if(Array.isArray(t)){var i,n=function(t,n){this._loadFrame(t,n),0===i.length()&&"function"==typeof e&&e()}.bind(this);i=new pa(n,t)}else this._loadFrame(t,e)},_loadFrame:function(t,e){uv.error("Trajectory._loadFrame not implemented",t,e)},updateStructure:function(t,e){this._disposed||(t===-1?this.structure.updatePosition(this.initialStructure):this.structure.updatePosition(this.frameCache[t]),this.structure.trajectory={name:this.trajPath,frame:t},"function"==typeof e&&e(),this.currentFrame=t,this.inProgress=!1,this.signals.frameChanged.dispatch(t))},getCircularMean:function(t,e,i){return[gr(e,i[0],3,0,t),gr(e,i[1],3,1,t),gr(e,i[2],3,2,t)]},centerPbc:function(t,e,i){if(0!==i[0]&&0!==i[8]&&0!==i[4]){var n,r=t.length,o=i[0],a=i[1],s=i[2],c=e[0],u=e[1],h=e[2],l=-c+o+o/2,d=-u+a+a/2,f=-h+s+s/2;for(n=0;n<r;n+=3)t[n+0]=(t[n+0]+l)%o,t[n+1]=(t[n+1]+d)%a,t[n+2]=(t[n+2]+f)%s}},removePbc:function(t,e){if(0!==e[0]&&0!==e[8]&&0!==e[4]){var i,n,r,o,a=t.length;for(i=3;i<a;i+=3)for(n=0;n<3;++n)if(o=t[i+n]-t[i-3+n],Math.abs(o)>.9*e[3*n+n])if(o>0)for(r=0;r<3;++r)t[i+r]-=e[3*n+r];else for(r=0;r<3;++r)t[i+r]+=e[3*n+r];return t}},superpose:function(t){var e,i,n=3*this.indices.length,r=this.coords1,o=this.coords2;for(e=0;e<n;e+=3)i=3*this.indices[e/3],r[e+0]=t[i+0],r[e+1]=t[i+1],r[e+2]=t[i+2];var a=new ma(r,o);a.transform(t)},process:function(t,e,i,n){if(this.setNumframes(n),e){if(this.backboneIndices.length>0&&this.params.centerPbc){var r=[e[0],e[4],e[8]],o=this.getCircularMean(this.backboneIndices,i,r);this.centerPbc(i,o,r)}this.params.removePbc&&this.removePbc(i,e)}this.indices.length>0&&this.params.superpose&&this.superpose(i),this.frameCache[t]=i,this.boxCache[t]=e,this.frameCacheSize+=1},setNumframes:function(t){t!==this.numframes&&(this.numframes=t,this.signals.gotNumframes.dispatch(t))},dispose:function(){this.frameCache=[],this._disposed=!0,this.player&&this.player.stop()},setPlayer:function(t){this.player=t,this.signals.playerChanged.dispatch(t)},getPath:function(t,e){uv.error("Trajectory.getPath not implemented",t,e)}},gv.add("shader/Mesh.vert","#define STANDARD\nuniform float nearClip;\nuniform vec3 clipCenter;\n#if defined( NEAR_CLIP ) || defined( RADIUS_CLIP ) || ( !defined( PICKING ) && !defined( NOLIGHT ) )\nvarying vec3 vViewPosition;\n#endif\n#if defined( RADIUS_CLIP )\nvarying vec3 vClipCenter;\n#endif\n#if defined( PICKING )\nattribute vec3 pickingColor;\nvarying vec3 vPickingColor;\n#elif defined( NOLIGHT )\nvarying vec3 vColor;\n#else\n#include color_pars_vertex\n#ifndef FLAT_SHADED\nvarying vec3 vNormal;\n#endif\n#endif\n#include common\nvoid main(){\n#if defined( PICKING )\nvPickingColor = pickingColor;\n#elif defined( NOLIGHT )\nvColor = color;\n#else\n#include color_vertex\n#include beginnormal_vertex\n#include defaultnormal_vertex\n#ifndef FLAT_SHADED\nvNormal = normalize( transformedNormal );\n#endif\n#endif\n#include begin_vertex\n#include project_vertex\n#if defined( NEAR_CLIP ) || defined( RADIUS_CLIP ) || ( !defined( PICKING ) && !defined( NOLIGHT ) )\nvViewPosition = -mvPosition.xyz;\n#endif\n#if defined( RADIUS_CLIP )\nvClipCenter = -( modelViewMatrix * vec4( clipCenter, 1.0 ) ).xyz;\n#endif\n#include nearclip_vertex\n}"),gv.add("shader/Mesh.frag","#define STANDARD\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float roughness;\nuniform float metalness;\nuniform float opacity;\nuniform float nearClip;\nuniform float clipRadius;\n#if defined( NEAR_CLIP ) || defined( RADIUS_CLIP ) || ( !defined( PICKING ) && !defined( NOLIGHT ) )\nvarying vec3 vViewPosition;\n#endif\n#if defined( RADIUS_CLIP )\nvarying vec3 vClipCenter;\n#endif\n#if defined( PICKING )\nuniform float objectId;\nvarying vec3 vPickingColor;\n#elif defined( NOLIGHT )\nvarying vec3 vColor;\n#else\n#ifndef FLAT_SHADED\nvarying vec3 vNormal;\n#endif\n#include common\n#include color_pars_fragment\n#include fog_pars_fragment\n#include bsdfs\n#include lights_pars\n#include lights_physical_pars_fragment\n#endif\nvoid main(){\n#include nearclip_fragment\n#include radiusclip_fragment\n#if defined( PICKING )\ngl_FragColor = vec4( vPickingColor, objectId );\n#elif defined( NOLIGHT )\ngl_FragColor = vec4( vColor, opacity );\n#else\nvec4 diffuseColor = vec4( diffuse, opacity );\nReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\nvec3 totalEmissiveLight = emissive;\n#include color_fragment\n#include roughnessmap_fragment\n#include metalnessmap_fragment\n#include normal_flip\n#include normal_fragment\n#include dull_interior_fragment\n#include lights_physical_fragment\n#include lights_template\nvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveLight;\ngl_FragColor = vec4( outgoingLight, diffuseColor.a );\n#include premultiplied_alpha_fragment\n#include tonemapping_fragment\n#include encodings_fragment\n#include fog_fragment\n#include opaque_back_fragment\n#endif\n}"),ya.prototype={constructor:ya,parameters:{opaqueBack:{updateShader:!0},dullInterior:{updateShader:!0},side:{updateShader:!0,property:!0},opacity:{uniform:!0},clipNear:{updateShader:!0,property:!0},clipRadius:{updateShader:!0,property:!0,uniform:!0},clipCenter:{uniform:!0},flatShaded:{updateShader:!0},background:{updateShader:!0},linewidth:{property:!0},wireframe:{updateVisibility:!0},roughness:{uniform:!0},metalness:{uniform:!0},diffuse:{uniform:!0}},get transparent(){return this.opacity<1||this.forceTransparent},makeMaterial:function(){var t=va(this.side);this.material=new Ct({uniforms:this.uniforms,vertexShader:"",fragmentShader:"",depthTest:!0,transparent:this.transparent,depthWrite:!0,lights:!0,fog:!0,side:t,linewidth:this.linewidth}),this.material.vertexColors=mh,this.material.extensions.derivatives=this.flatShaded,this.material.extensions.fragDepth=this.impostor,this.material.clipNear=this.clipNear,this.wireframeMaterial=new Ct({uniforms:this.uniforms,vertexShader:"",fragmentShader:"",depthTest:!0,transparent:this.transparent,depthWrite:!0,lights:!1,fog:!0,side:t,linewidth:this.linewidth}),this.wireframeMaterial.vertexColors=mh,this.wireframeMaterial.clipNear=this.clipNear,this.pickingMaterial=new Ct({uniforms:this.pickingUniforms,vertexShader:"",fragmentShader:"",depthTest:!0,transparent:!1,depthWrite:!0,lights:!1,fog:!1,side:t,linewidth:this.linewidth}),this.pickingMaterial.vertexColors=mh,this.pickingMaterial.extensions.fragDepth=this.impostor,this.pickingMaterial.clipNear=this.clipNear,this.updateShader()},makeWireframeGeometry:function(){this.makeWireframeIndex();var t=this.geometry,e=this.wireframeIndex,i=new ue;i.attributes=t.attributes,e&&(i.setIndex(new Kt(e,1).setDynamic(this.dynamic)),i.setDrawRange(0,this.wireframeIndexCount)),this.wireframeGeometry=i},makeWireframeIndex:function(){function t(t,i){if(t>i){var n=t;
	t=i,i=n}var r=e[t];return void 0===r?(e[t]=[i],!0):!r.includes(i)&&(r.push(i),!0)}var e=[];return function(){var i=this.geometry.index;if(this.wireframe){if(i){var n=i.array,r=n.length;this.geometry.drawRange.count!==1/0&&(r=this.geometry.drawRange.count);var o;if(this.wireframeIndex&&this.wireframeIndex.length>2*r)o=this.wireframeIndex;else{var a=this.geometry.attributes.position.count,s=a>65535?Uint32Array:Uint16Array;o=new s(2*r)}var c=0;e.length=0;for(var u=0;u<r;u+=3){var h=n[u+0],l=n[u+1],d=n[u+2];t(h,l)&&(o[c+0]=h,o[c+1]=l,c+=2),t(l,d)&&(o[c+0]=l,o[c+1]=d,c+=2),t(d,h)&&(o[c+0]=d,o[c+1]=h,c+=2)}this.wireframeIndex=o,this.wireframeIndexCount=c,this.wireframeIndexVersion=this.indexVersion}}else this.wireframeIndex=new Uint16Array(0),this.wireframeIndexCount=0}}(),updateWireframeIndex:function(){if(this.wireframeGeometry.setDrawRange(0,1/0),this.wireframeIndexVersion<this.indexVersion&&this.makeWireframeIndex(),this.wireframeIndex.length>this.wireframeGeometry.index.array.length)this.wireframeGeometry.setIndex(new Kt(this.wireframeIndex,1).setDynamic(this.dynamic));else{var t=this.wireframeGeometry.getIndex();t.set(this.wireframeIndex),t.needsUpdate=this.wireframeIndexCount>0,t.updateRange.count=this.wireframeIndexCount}this.wireframeGeometry.setDrawRange(0,this.wireframeIndexCount)},getRenderOrder:function(){var t=0;return"text"===this.type?t=1:this.transparent&&(t="surface"===this.type?3:2),t},getMesh:function(){var t;return this.material||this.makeMaterial(),this.line?t=new $e(this.geometry,this.material):this.point?(t=new Ge(this.geometry,this.material),this.sortParticles&&(t.sortParticles=!0)):t=new Se(this.geometry,this.material),t.frustumCulled=!1,t.renderOrder=this.getRenderOrder(),t},getWireframeMesh:function(){var t;return this.material||this.makeMaterial(),this.wireframeGeometry||this.makeWireframeGeometry(),t=new $e(this.wireframeGeometry,this.wireframeMaterial),t.frustumCulled=!1,t.renderOrder=this.getRenderOrder(),t},getPickingMesh:function(){var t;return this.material||this.makeMaterial(),t=new Se(this.geometry,this.pickingMaterial),t.frustumCulled=!1,t.renderOrder=this.getRenderOrder(),t},getShader:function(t,e){return pr(t,this.getDefines(e))},getVertexShader:function(t){return this.getShader(this.vertexShader,t)},getFragmentShader:function(t){return this.getShader(this.fragmentShader,t)},getDefines:function(t){var e={};return this.clipNear&&(e.NEAR_CLIP=1),this.clipRadius&&(e.RADIUS_CLIP=1),"picking"===t?e.PICKING=1:(("background"===t||this.background)&&(e.NOLIGHT=1),this.flatShaded&&(e.FLAT_SHADED=1),this.opaqueBack&&(e.OPAQUE_BACK=1),this.dullInterior&&(e.DULL_INTERIOR=1)),e},getParameters:function(){var t={};for(var e in this.parameters)t[e]=this[e];return t},addUniforms:function(t){this.uniforms=xd.merge([this.uniforms,t]),this.pickingUniforms=xd.merge([this.pickingUniforms,t])},addAttributes:function(t){var e={f:1,v2:2,v3:3,c:3};for(var i in t){var n,r=t[i];r.value?(this.attributeSize*e[r.type]!==r.value.length&&uv.error("attribute value has wrong length",i),n=r.value):n=new Float32Array(this.attributeSize*e[r.type]),this.geometry.addAttribute(i,new Kt(n,e[r.type]).setDynamic(this.dynamic))}},updateRenderOrder:function(){function t(t){t.renderOrder=e}var e=this.getRenderOrder();this.group.children.forEach(t),this.pickingGroup&&this.pickingGroup.children.forEach(t)},updateShader:function(){var t=this.material,e=this.wireframeMaterial,i=this.pickingMaterial;t.vertexShader=this.getVertexShader(),t.fragmentShader=this.getFragmentShader(),t.needsUpdate=!0,e.vertexShader=this.getShader("Line.vert"),e.fragmentShader=this.getShader("Line.frag"),e.needsUpdate=!0,i.vertexShader=this.getVertexShader("picking"),i.fragmentShader=this.getFragmentShader("picking"),i.needsUpdate=!0},setParameters:function(t){if(t){var e=t,i=this.parameters,n={},r={},o=!1,a=!1;for(var s in e)void 0!==e[s]&&void 0!==i[s]&&(this[s]=e[s],i[s].property&&(i[s].property!==!0?n[i[s].property]=e[s]:n[s]=e[s]),i[s].uniform&&(i[s].uniform!==!0?r[i[s].uniform]=e[s]:r[s]=e[s]),i[s].updateShader&&(o=!0),i[s].updateVisibility&&(a=!0),this.dynamic&&"wireframe"===s&&e[s]===!0&&this.updateWireframeIndex(),"flatShaded"===s&&(this.material.extensions.derivatives=this.flatShaded),"forceTransparent"===s&&(n.transparent=this.transparent));this.setProperties(n),this.setUniforms(r),o&&this.updateShader(),a&&this.setVisibility(this.visible)}},setAttributes:function(t){var e=this.geometry,i=e.attributes;for(var n in t){var r=t[n],o=r.length;if("index"===n){var a=e.getIndex();e.setDrawRange(0,1/0),o>a.array.length?e.setIndex(new Kt(r,1).setDynamic(this.dynamic)):(a.set(r),a.needsUpdate=o>0,a.updateRange.count=o,e.setDrawRange(0,o)),this.indexVersion++,this.wireframe&&this.updateWireframeIndex()}else{var s=i[n];o>s.array.length?e.addAttribute(n,new Kt(r,s.itemSize).setDynamic(this.dynamic)):(i[n].set(r),i[n].needsUpdate=o>0,i[n].updateRange.count=o)}}},setUniforms:function(t){if(t){var e=this.material.uniforms,i=this.wireframeMaterial.uniforms,n=this.pickingMaterial.uniforms;for(var r in t)"opacity"===r&&this.setProperties({transparent:this.transparent}),void 0!==e[r]&&(e[r].value.isVector3?e[r].value.copy(t[r]):e[r].value.set?e[r].value.set(t[r]):e[r].value=t[r]),void 0!==i[r]&&(i[r].value.isVector3?i[r].value.copy(t[r]):i[r].value.set?i[r].value.set(t[r]):i[r].value=t[r]),void 0!==n[r]&&(n[r].value.isVector3?n[r].value.copy(t[r]):n[r].value.set?n[r].value.set(t[r]):n[r].value=t[r])}},setProperties:function(t){if(t){var e=this.material,i=this.wireframeMaterial,n=this.pickingMaterial;for(var r in t){var o=t[r];"transparent"===r?this.updateRenderOrder():"side"===r&&(o=va(o)),void 0!==e[r]&&(e[r]=o),void 0!==i[r]&&(i[r]=o),void 0!==n[r]&&(n[r]=o)}e.needsUpdate=!0,i.needsUpdate=!0,n.needsUpdate=!0}},setVisibility:function(t){this.visible=t,this.wireframe?(this.group.visible=!1,this.wireframeGroup.visible=t,this.pickable&&(this.pickingGroup.visible=!1)):(this.group.visible=t,this.wireframeGroup.visible=!1,this.pickable&&(this.pickingGroup.visible=t))},dispose:function(){this.material&&this.material.dispose(),this.wireframeMaterial&&this.wireframeMaterial.dispose(),this.pickingMaterial&&this.pickingMaterial.dispose(),this.geometry.dispose(),this.wireframeGeometry&&this.wireframeGeometry.dispose()}},ba.prototype=Object.assign(Object.create(ya.prototype),{constructor:ba}),Sa.prototype=Object.assign(Object.create(ba.prototype),{constructor:Sa,applyPositionTransform:function(){},setAttributes:function(){var t=new O,e=new Lt;return function(i){var n,r,o,a,s,c,u,h,l,d,f,p=this.geometry.attributes;i.position&&(n=i.position,a=this.geoPosition,h=this.meshPosition,c=this.transformedGeoPosition,p.position.needsUpdate=!0),i.color&&(r=i.color,l=this.meshColor,p.color.needsUpdate=!0),i.pickingColor&&(o=i.pickingColor,d=this.meshPickingColor,p.pickingColor.needsUpdate=!0);var m=!(!this.updateNormals||!n),g=!(!this.initNormals||!n);(m||g)&&(s=this.geoNormal,f=this.meshNormal,u=this.transformedGeoNormal,p.normal.needsUpdate=!0);for(var v=this.positionCount,y=this.geoPositionCount,b=0;b<v;++b){var x,_,w=b*y*3,S=3*b;if(n&&(c.set(a),t.makeTranslation(n[S],n[S+1],n[S+2]),this.applyPositionTransform(t,b,S),t.applyToVector3Array(c),h.set(c,w)),m?(u.set(s),e.getNormalMatrix(t),e.applyToVector3Array(u),f.set(u,w)):g&&f.set(s,w),r)for(x=0;x<y;++x)_=w+3*x,l[_]=r[S],l[_+1]=r[S+1],l[_+2]=r[S+2];if(o)for(x=0;x<y;++x)_=w+3*x,d[_]=o[S],d[_+1]=o[S+1],d[_+2]=o[S+2]}}}(),makeIndex:function(){var t,e,i,n,r=this.geoIndex,o=this.meshIndex,a=this.positionCount,s=this.geoPositionCount,c=this.geoFacesCount,u=3*c;for(e=0;e<a;++e)for(i=e*u,n=i+u,o.set(r,i),t=i;t<n;++t)o[t]+=e*s}}),Aa.prototype=Object.assign(Object.create(Sa.prototype),{constructor:Aa,applyPositionTransform:function(){var t,e=new N;return function(i,n){t=this._radius[n],e.set(t,t,t),i.scale(e)}}(),setAttributes:function(t){t.radius&&(this._radius=t.radius),Sa.prototype.setAttributes.call(this,t)}}),gv.add("shader/SphereImpostor.vert","uniform mat4 projectionMatrixInverse;\nuniform float nearClip;\nvarying float vRadius;\nvarying float vRadiusSq;\nvarying vec3 vPoint;\nvarying vec3 vPointViewPosition;\nattribute vec2 mapping;\nattribute float radius;\n#ifdef PICKING\nattribute vec3 pickingColor;\nvarying vec3 vPickingColor;\n#else\n#include color_pars_vertex\n#endif\nconst mat4 D = mat4(\n1.0, 0.0, 0.0, 0.0,\n0.0, 1.0, 0.0, 0.0,\n0.0, 0.0, 1.0, 0.0,\n0.0, 0.0, 0.0, -1.0\n);\nmat4 transpose( in mat4 inMatrix ) {\nvec4 i0 = inMatrix[0];\nvec4 i1 = inMatrix[1];\nvec4 i2 = inMatrix[2];\nvec4 i3 = inMatrix[3];\nmat4 outMatrix = mat4(\nvec4(i0.x, i1.x, i2.x, i3.x),\nvec4(i0.y, i1.y, i2.y, i3.y),\nvec4(i0.z, i1.z, i2.z, i3.z),\nvec4(i0.w, i1.w, i2.w, i3.w)\n);\nreturn outMatrix;\n}\nvoid ComputePointSizeAndPositionInClipCoordSphere(){\nvec2 xbc;\nvec2 ybc;\nmat4 T = mat4(\nradius, 0.0, 0.0, 0.0,\n0.0, radius, 0.0, 0.0,\n0.0, 0.0, radius, 0.0,\nposition.x, position.y, position.z, 1.0\n);\nmat4 R = transpose( projectionMatrix * modelViewMatrix * T );\nfloat A = dot( R[ 3 ], D * R[ 3 ] );\nfloat B = -2.0 * dot( R[ 0 ], D * R[ 3 ] );\nfloat C = dot( R[ 0 ], D * R[ 0 ] );\nxbc[ 0 ] = ( -B - sqrt( B * B - 4.0 * A * C ) ) / ( 2.0 * A );\nxbc[ 1 ] = ( -B + sqrt( B * B - 4.0 * A * C ) ) / ( 2.0 * A );\nfloat sx = abs( xbc[ 0 ] - xbc[ 1 ] ) * 0.5;\nA = dot( R[ 3 ], D * R[ 3 ] );\nB = -2.0 * dot( R[ 1 ], D * R[ 3 ] );\nC = dot( R[ 1 ], D * R[ 1 ] );\nybc[ 0 ] = ( -B - sqrt( B * B - 4.0 * A * C ) ) / ( 2.0 * A );\nybc[ 1 ] = ( -B + sqrt( B * B - 4.0 * A * C ) ) / ( 2.0 * A );\nfloat sy = abs( ybc[ 0 ] - ybc[ 1 ] ) * 0.5;\ngl_Position.xy = vec2( 0.5 * ( xbc.x + xbc.y ), 0.5 * ( ybc.x + ybc.y ) );\ngl_Position.xy -= mapping * vec2( sx, sy );\ngl_Position.xy *= gl_Position.w;\n}\nvoid main(void){\n#ifdef PICKING\nvPickingColor = pickingColor;\n#else\n#include color_vertex\n#endif\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nmvPosition.z -= radius;\ngl_Position = projectionMatrix * vec4( mvPosition.xyz, 1.0 );\nComputePointSizeAndPositionInClipCoordSphere();\nvRadius = radius;\nvRadiusSq = radius * radius;\nvec4 vPoint4 = projectionMatrixInverse * gl_Position;\nvPoint = vPoint4.xyz / vPoint4.w;\nvPointViewPosition = -mvPosition.xyz / mvPosition.w;\n}"),gv.add("shader/SphereImpostor.frag","#define STANDARD\n#define IMPOSTOR\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float roughness;\nuniform float metalness;\nuniform float opacity;\nuniform float nearClip;\nuniform mat4 projectionMatrix;\nuniform float ortho;\nvarying float vRadius;\nvarying float vRadiusSq;\nvarying vec3 vPoint;\nvarying vec3 vPointViewPosition;\n#ifdef PICKING\nuniform float objectId;\nvarying vec3 vPickingColor;\n#else\n#include common\n#include color_pars_fragment\n#include fog_pars_fragment\n#include bsdfs\n#include lights_pars\n#include lights_physical_pars_fragment\n#endif\nbool flag2 = false;\nbool interior = false;\nvec3 cameraPos;\nvec3 cameraNormal;\nfloat calcDepth( in vec3 cameraPos ){\nvec2 clipZW = cameraPos.z * projectionMatrix[2].zw + projectionMatrix[3].zw;\nreturn 0.5 + 0.5 * clipZW.x / clipZW.y;\n}\nfloat calcClip( vec3 cameraPos ){\nreturn dot( vec4( cameraPos, 1.0 ), vec4( 0.0, 0.0, 1.0, nearClip - 0.5 ) );\n}\nbool Impostor( out vec3 cameraPos, out vec3 cameraNormal ){\nvec3 cameraSpherePos = -vPointViewPosition;\ncameraSpherePos.z += vRadius;\nvec3 rayOrigin = mix( vec3( 0.0, 0.0, 0.0 ), vPoint, ortho );\nvec3 rayDirection = mix( normalize( vPoint ), vec3( 0.0, 0.0, 1.0 ), ortho );\nvec3 cameraSphereDir = mix( cameraSpherePos, rayOrigin - cameraSpherePos, ortho );\nfloat B = dot( rayDirection, cameraSphereDir );\nfloat det = B * B + vRadiusSq - dot( cameraSphereDir, cameraSphereDir );\nif( det < 0.0 ){\ndiscard;\nreturn false;\n}else{\nfloat sqrtDet = sqrt( det );\nfloat posT = mix( B + sqrtDet, B + sqrtDet, ortho );\nfloat negT = mix( B - sqrtDet, sqrtDet - B, ortho );\ncameraPos = rayDirection * negT + rayOrigin;\n#ifdef NEAR_CLIP\nif( calcDepth( cameraPos ) <= 0.0 ){\ncameraPos = rayDirection * posT + rayOrigin;\ninterior = true;\nreturn false;\n}else if( calcClip( cameraPos ) > 0.0 ){\ncameraPos = rayDirection * posT + rayOrigin;\ninterior = true;\nflag2 = true;\nreturn false;\n}else{\ncameraNormal = normalize( cameraPos - cameraSpherePos );\n}\n#else\nif( calcDepth( cameraPos ) <= 0.0 ){\ncameraPos = rayDirection * posT + rayOrigin;\ninterior = true;\nreturn false;\n}else{\ncameraNormal = normalize( cameraPos - cameraSpherePos );\n}\n#endif\nreturn true;\n}\nreturn false;\n}\nvoid main(void){\nbool flag = Impostor( cameraPos, cameraNormal );\n#ifdef NEAR_CLIP\nif( calcClip( cameraPos ) > 0.0 )\ndiscard;\n#endif\ngl_FragDepthEXT = calcDepth( cameraPos );\nif( !flag ){\n#ifdef NEAR_CLIP\nif( flag2 ){\ngl_FragDepthEXT = max( 0.0, calcDepth( vec3( - ( nearClip - 0.5 ) ) ) + ( 0.0000001 / vRadius ) );\n}else if( gl_FragDepthEXT >= 0.0 ){\ngl_FragDepthEXT = 0.0 + ( 0.0000001 / vRadius );\n}\n#else\nif( gl_FragDepthEXT >= 0.0 ){\ngl_FragDepthEXT = 0.0 + ( 0.0000001 / vRadius );\n}\n#endif\n}\nif (gl_FragDepthEXT < 0.0)\ndiscard;\nif (gl_FragDepthEXT > 1.0)\ndiscard;\n#ifdef PICKING\ngl_FragColor = vec4( vPickingColor, objectId );\n#else\nvec3 vNormal = cameraNormal;\nvec3 vViewPosition = -cameraPos;\nvec4 diffuseColor = vec4( diffuse, opacity );\nReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\nvec3 totalEmissiveLight = emissive;\n#include color_fragment\n#include roughnessmap_fragment\n#include metalnessmap_fragment\n#include normal_flip\n#include normal_fragment\nif( interior ){\nnormal = vec3( 0.0, 0.0, 0.4 );\n}\n#include lights_physical_fragment\n#include lights_template\nvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveLight;\ngl_FragColor = vec4( outgoingLight, diffuseColor.a );\n#include premultiplied_alpha_fragment\n#include tonemapping_fragment\n#include encodings_fragment\n#include fog_fragment\n#endif\n}"),Ma.prototype=Object.assign(Object.create(ya.prototype),{constructor:Ma,setAttributes:function(t){var e,i,n,r,o,a,s,c=this.count,u=this.mappingSize,h=this.geometry.attributes;for(var l in t){i=t[l],e=h[l],n=e.itemSize,r=e.array;for(var d=0;d<c;++d){o=d*n,a=o*u;for(var f=0;f<u;++f){s=a+n*f;for(var p=0;p<n;++p)r[s+p]=i[o+p]}}e.needsUpdate=!0}},makeMapping:function(){for(var t=this.count,e=this.mapping,i=this.mappingSize,n=this.mappingItemSize,r=this.geometry.attributes.mapping.array,o=0;o<t;o++)r.set(e,o*n*i)},makeIndex:function(){for(var t,e,i=this.count,n=this.mappingSize,r=this.mappingIndices,o=this.mappingIndicesSize,a=this.index,s=0;s<i;s++){t=s*o,e=s*n,a.set(r,t);for(var c=0;c<o;++c)a[t+c]+=e}}}),Ca.prototype=Object.assign(Object.create(Ma.prototype),{constructor:Ca}),Pa.prototype=Object.assign(Object.create(Ca.prototype),{constructor:Pa}),Ea.prototype=Object.assign(Object.create(Sa.prototype),{constructor:Ea,applyPositionTransform:function(){var t=new N,e=new N,i=new N,n=new N(0,0,0);return function(r,o,a){e.fromArray(this._majorAxis,a),i.fromArray(this._minorAxis,a),r.lookAt(n,e,i),t.set(this._radius[o],i.length(),e.length()),r.scale(t)}}(),setAttributes:function(t){t.majorAxis&&(this.majorAxis=t.majorAxis),t.minorAxis&&(this._minorAxis=t.minorAxis),Sa.prototype.setAttributes.call(this,t)}}),La.prototype=Object.assign(Object.create(Sa.prototype),{constructor:La,applyPositionTransform:function(){var t,e=new N,i=new N,n=new N,r=new N(0,1,0);return function(o,a,s){i.fromArray(this._from,s),n.fromArray(this._to,s),o.lookAt(i,n,r),t=this._radius[a],e.set(t,t,i.distanceTo(n)),o.scale(e)}}(),setAttributes:function(t){var e=this._position.length/2,i=this._radius.length/2,n={};t.position1&&t.position2&&(vr(t.position1,t.position2,this.__center),vr(t.position1,this.__center,this._position),vr(this.__center,t.position2,this._position,e),this._from.set(t.position1),this._from.set(this.__center,e),this._to.set(this.__center),this._to.set(t.position2,e),n.position=this._position),t.color&&t.color2&&(this._color.set(t.color),this._color.set(t.color2,e),n.color=this._color),t.pickingColor&&t.pickingColor2&&(this._pickingColor.set(t.pickingColor),this._pickingColor.set(t.pickingColor2,e),n.pickingColor=this._pickingColor),t.radius&&(this._radius.set(t.radius),this._radius.set(t.radius,i)),Sa.prototype.setAttributes.call(this,n)}}),gv.add("shader/CylinderImpostor.vert","\nattribute vec3 mapping;\nattribute vec3 position1;\nattribute vec3 position2;\nattribute float radius;\nvarying vec3 axis;\nvarying vec4 base_radius;\nvarying vec4 end_b;\nvarying vec3 U;\nvarying vec3 V;\nvarying vec4 w;\n#ifdef PICKING\nattribute vec3 pickingColor;\nattribute vec3 pickingColor2;\nvarying vec3 vPickingColor;\nvarying vec3 vPickingColor2;\n#else\nattribute vec3 color2;\nvarying vec3 vColor1;\nvarying vec3 vColor2;\n#endif\nuniform mat4 modelViewMatrixInverse;\nuniform float ortho;\nvoid main(){\n#ifdef PICKING\nvPickingColor = pickingColor;\nvPickingColor2 = pickingColor2;\n#else\nvColor1 = color;\nvColor2 = color2;\n#endif\nbase_radius.w = radius;\nvec3 center = position;\nvec3 dir = normalize( position2 - position1 );\nfloat ext = length( position2 - position1 ) / 2.0;\nvec3 cam_dir;\nif( ortho == 0.0 ){\ncam_dir = ( modelViewMatrixInverse * vec4( 0, 0, 0, 1 ) ).xyz - center;\n}else{\ncam_dir = ( modelViewMatrixInverse * vec4( 0, 0, 1, 0 ) ).xyz;\n}\ncam_dir = normalize( cam_dir );\nvec3 ldir;\nfloat b = dot( cam_dir, dir );\nend_b.w = b;\nif( b < 0.0 )\nldir = -ext * dir;\nelse\nldir = ext * dir;\nvec3 left = normalize( cross( cam_dir, ldir ) );\nleft = radius * left;\nvec3 up = radius * normalize( cross( left, ldir ) );\naxis = normalize( normalMatrix * ldir );\nU = normalize( normalMatrix * up );\nV = normalize( normalMatrix * left );\nvec4 base4 = modelViewMatrix * vec4( center - ldir, 1.0 );\nbase_radius.xyz = base4.xyz / base4.w;\nvec4 top_position = modelViewMatrix * vec4( center + ldir, 1.0 );\nvec4 end4 = top_position;\nend_b.xyz = end4.xyz / end4.w;\nw = modelViewMatrix * vec4(\ncenter + mapping.x*ldir + mapping.y*left + mapping.z*up, 1.0\n);\ngl_Position = projectionMatrix * w;\ngl_Position.z = 0.99;\n}"),gv.add("shader/CylinderImpostor.frag","#define STANDARD\n#define IMPOSTOR\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float roughness;\nuniform float metalness;\nuniform float opacity;\nuniform float nearClip;\nuniform mat4 projectionMatrix;\nuniform float ortho;\nvarying vec3 axis;\nvarying vec4 base_radius;\nvarying vec4 end_b;\nvarying vec3 U;\nvarying vec3 V;\nvarying vec4 w;\n#ifdef PICKING\nuniform float objectId;\nvarying vec3 vPickingColor;\nvarying vec3 vPickingColor2;\n#else\nvarying vec3 vColor1;\nvarying vec3 vColor2;\n#include common\n#include fog_pars_fragment\n#include bsdfs\n#include lights_pars\n#include lights_physical_pars_fragment\n#endif\nbool interior = false;\nfloat distSq3( vec3 v3a, vec3 v3b ){\nreturn (\n( v3a.x - v3b.x ) * ( v3a.x - v3b.x ) +\n( v3a.y - v3b.y ) * ( v3a.y - v3b.y ) +\n( v3a.z - v3b.z ) * ( v3a.z - v3b.z )\n);\n}\nfloat calcDepth( in vec3 cameraPos ){\nvec2 clipZW = cameraPos.z * projectionMatrix[2].zw + projectionMatrix[3].zw;\nreturn 0.5 + 0.5 * clipZW.x / clipZW.y;\n}\nfloat calcClip( vec3 cameraPos ){\nreturn dot( vec4( cameraPos, 1.0 ), vec4( 0.0, 0.0, 1.0, nearClip - 0.5 ) );\n}\nvoid main(){\nvec3 point = w.xyz / w.w;\nvec3 base = base_radius.xyz;\nfloat vRadius = base_radius.w;\nvec3 end = end_b.xyz;\nfloat b = end_b.w;\nvec3 end_cyl = end;\nvec3 surface_point = point;\nvec3 ray_target = surface_point;\nvec3 ray_origin = vec3(0.0);\nvec3 ray_direction = mix(normalize(ray_origin - ray_target), vec3(0.0, 0.0, 1.0), ortho);\nmat3 basis = mat3( U, V, axis );\nvec3 diff = ray_target - 0.5 * (base + end_cyl);\nvec3 P = diff * basis;\nfloat dz = dot( axis, ray_direction );\nfloat radius2 = vRadius*vRadius;\nvec3 D = vec3(dot(U, ray_direction),\ndot(V, ray_direction),\ndz);\nfloat a0 = P.x*P.x + P.y*P.y - radius2;\nfloat a1 = P.x*D.x + P.y*D.y;\nfloat a2 = D.x*D.x + D.y*D.y;\nfloat d = a1*a1 - a0*a2;\nif (d < 0.0)\ndiscard;\nfloat dist = (-a1 + sqrt(d)) / a2;\nvec3 new_point = ray_target + dist * ray_direction;\nvec3 tmp_point = new_point - base;\nvec3 _normal = normalize( tmp_point - axis * dot(tmp_point, axis) );\nray_origin = mix( ray_origin, surface_point, ortho );\nfloat front_cap_test = dot( tmp_point, axis );\nfloat end_cap_test = dot((new_point - end_cyl), axis);\n#ifndef CAP\nvec3 new_point2 = ray_target + ( (-a1 - sqrt(d)) / a2 ) * ray_direction;\nvec3 tmp_point2 = new_point2 - base;\n#endif\nif (front_cap_test < 0.0)\n{\nfloat dNV = dot(-axis, ray_direction);\nif (dNV < 0.0)\ndiscard;\nfloat near = dot(-axis, (base)) / dNV;\nvec3 front_point = ray_direction * near + ray_origin;\nif (dot(front_point - base, front_point-base) > radius2)\ndiscard;\n#ifdef CAP\nnew_point = front_point;\n_normal = axis;\n#else\nnew_point = ray_target + ( (-a1 - sqrt(d)) / a2 ) * ray_direction;\ndNV = dot(-axis, ray_direction);\nnear = dot(axis, end_cyl) / dNV;\nnew_point2 = ray_direction * near + ray_origin;\nif (dot(new_point2 - end_cyl, new_point2-base) < radius2)\ndiscard;\ninterior = true;\n#endif\n}\nif( end_cap_test > 0.0 )\n{\nfloat dNV = dot(axis, ray_direction);\nif (dNV < 0.0)\ndiscard;\nfloat near = dot(axis, end_cyl) / dNV;\nvec3 end_point = ray_direction * near + ray_origin;\nif( dot(end_point - end_cyl, end_point-base) > radius2 )\ndiscard;\n#ifdef CAP\nnew_point = end_point;\n_normal = axis;\n#else\nnew_point = ray_target + ( (-a1 - sqrt(d)) / a2 ) * ray_direction;\ndNV = dot(-axis, ray_direction);\nnear = dot(-axis, (base)) / dNV;\nnew_point2 = ray_direction * near + ray_origin;\nif (dot(new_point2 - base, new_point2-base) < radius2)\ndiscard;\ninterior = true;\n#endif\n}\ngl_FragDepthEXT = calcDepth( new_point );\n#ifdef NEAR_CLIP\nif( calcClip( new_point ) > 0.0 ){\ndist = (-a1 - sqrt(d)) / a2;\nnew_point = ray_target + dist * ray_direction;\nif( calcClip( new_point ) > 0.0 )\ndiscard;\ninterior = true;\ngl_FragDepthEXT = calcDepth( new_point );\nif( gl_FragDepthEXT >= 0.0 ){\ngl_FragDepthEXT = max( 0.0, calcDepth( vec3( - ( nearClip - 0.5 ) ) ) + ( 0.0000001 / vRadius ) );\n}\n}else if( gl_FragDepthEXT <= 0.0 ){\ndist = (-a1 - sqrt(d)) / a2;\nnew_point = ray_target + dist * ray_direction;\ninterior = true;\ngl_FragDepthEXT = calcDepth( new_point );\nif( gl_FragDepthEXT >= 0.0 ){\ngl_FragDepthEXT = 0.0 + ( 0.0000001 / vRadius );\n}\n}\n#else\nif( gl_FragDepthEXT <= 0.0 ){\ndist = (-a1 - sqrt(d)) / a2;\nnew_point = ray_target + dist * ray_direction;\ninterior = true;\ngl_FragDepthEXT = calcDepth( new_point );\nif( gl_FragDepthEXT >= 0.0 ){\ngl_FragDepthEXT = 0.0 + ( 0.0000001 / vRadius );\n}\n}\n#endif\nif (gl_FragDepthEXT < 0.0)\ndiscard;\nif (gl_FragDepthEXT > 1.0)\ndiscard;\n#ifdef PICKING\nif( distSq3( new_point, end_cyl ) < distSq3( new_point, base ) ){\nif( b < 0.0 ){\ngl_FragColor = vec4( vPickingColor, objectId );\n}else{\ngl_FragColor = vec4( vPickingColor2, objectId );\n}\n}else{\nif( b > 0.0 ){\ngl_FragColor = vec4( vPickingColor, objectId );\n}else{\ngl_FragColor = vec4( vPickingColor2, objectId );\n}\n}\n#else\nvec3 vViewPosition = -new_point;\nvec3 vNormal = _normal;\nvec3 vColor;\nif( distSq3( new_point, end_cyl ) < distSq3( new_point, base ) ){\nif( b < 0.0 ){\nvColor = vColor1;\n}else{\nvColor = vColor2;\n}\n}else{\nif( b > 0.0 ){\nvColor = vColor1;\n}else{\nvColor = vColor2;\n}\n}\nvec4 diffuseColor = vec4( diffuse, opacity );\nReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\nvec3 totalEmissiveLight = emissive;\n#include color_fragment\n#include roughnessmap_fragment\n#include metalnessmap_fragment\nvec3 normal = normalize( vNormal );\nif( interior ){\nnormal = vec3( 0.0, 0.0, 0.4 );\n}\n#include lights_physical_fragment\n#include lights_template\nvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveLight;\ngl_FragColor = vec4( outgoingLight, diffuseColor.a );\n#include premultiplied_alpha_fragment\n#include tonemapping_fragment\n#include encodings_fragment\n#include fog_fragment\n#endif\n}"),Ra.prototype=Object.assign(Object.create(Ma.prototype),{constructor:Ra}),Oa.prototype=Object.assign(Object.create(Ra.prototype),{constructor:Oa,parameters:Object.assign({openEnded:{updateShader:!0}},Ra.prototype.parameters),getDefines:function(t){var e=Ra.prototype.getDefines.call(this,t);return this.openEnded||(e.CAP=1),e},setAttributes:function(t){t&&t.position1&&t.position2&&(t.position=vr(t.position1,t.position2)),Ra.prototype.setAttributes.call(this,t)}}),Na.prototype=Object.assign(Object.create(Sa.prototype),{constructor:Na,applyPositionTransform:function(){var t,e=new N,i=new N,n=new N,r=new N(0,1,0);return function(o,a,s){i.fromArray(this._from,s),n.fromArray(this._to,s),o.lookAt(i,n,r),t=this._radius[a],e.set(t,t,i.distanceTo(n)),o.scale(e)}}(),setAttributes:function(t){var e={};t.position1&&t.position2&&(vr(t.position1,t.position2,this._position),this._from.set(t.position1),this._to.set(t.position2),e.position=this._position),t.color&&(e.color=t.color),t.pickingColor&&(e.pickingColor=t.pickingColor),t.radius&&this._radius.set(t.radius),Sa.prototype.setAttributes.call(this,e)}}),za.prototype.constructor=za,za.prototype.type="Shape",Ba.prototype={constructor:Ba,type:"",parameters:{lazy:{type:"boolean"},clipNear:{type:"range",step:1,max:100,min:0,buffer:!0},clipRadius:{type:"number",precision:1,max:1e3,min:0,buffer:!0},clipCenter:{type:"vector3",precision:1,buffer:!0},flatShaded:{type:"boolean",buffer:!0},opacity:{type:"range",step:.01,max:1,min:0,buffer:!0},side:{type:"select",buffer:!0,options:{front:"front",back:"back",double:"double"}},wireframe:{type:"boolean",buffer:!0},linewidth:{type:"integer",max:50,min:1,buffer:!0},colorScheme:{type:"select",update:"color",options:dv.getTypes()},colorScale:{type:"select",update:"color",options:dv.getScales()},colorValue:{type:"color",update:"color"},colorDomain:{type:"hidden",update:"color"},colorMode:{type:"select",update:"color",options:dv.getModes()},roughness:{type:"range",step:.01,max:1,min:0,buffer:!0},metalness:{type:"range",step:.01,max:1,min:0,buffer:!0},diffuse:{type:"color",buffer:!0}},init:function(t){var e=t||{};this.clipNear=d(e.clipNear,0),this.clipRadius=d(e.clipRadius,0),this.clipCenter=d(e.clipCenter,new N),this.flatShaded=d(e.flatShaded,!1),this.side=d(e.side,"double"),this.opacity=d(e.opacity,1),this.wireframe=d(e.wireframe,!1),this.linewidth=d(e.linewidth,2),this.setColor(e.color,e),this.colorScheme=d(e.colorScheme,"uniform"),this.colorScale=d(e.colorScale,""),this.colorValue=d(e.colorValue,9474192),this.colorDomain=d(e.colorDomain,""),this.colorMode=d(e.colorMode,"hcl"),this.visible=d(e.visible,!0),this.quality=d(e.quality,void 0),this.roughness=d(e.roughness,.4),this.metalness=d(e.metalness,0),this.diffuse=d(e.diffuse,16777215),this.lazy=d(e.lazy,!1),this.lazyProps={build:!1,bufferParams:{},what:{}};var i=this.parameters;i.sphereDetail===!0&&(i.sphereDetail={type:"integer",max:3,min:0,rebuild:"impostor"}),i.radialSegments===!0&&(i.radialSegments={type:"integer",max:25,min:5,rebuild:"impostor"}),i.openEnded===!0&&(i.openEnded={type:"boolean",rebuild:"impostor",buffer:!0}),i.disableImpostor===!0&&(i.disableImpostor={type:"boolean",rebuild:!0}),"low"===e.quality?(i.sphereDetail&&(this.sphereDetail=0),i.radialSegments&&(this.radialSegments=5)):"medium"===e.quality?(i.sphereDetail&&(this.sphereDetail=1),i.radialSegments&&(this.radialSegments=10)):"high"===e.quality?(i.sphereDetail&&(this.sphereDetail=2),i.radialSegments&&(this.radialSegments=20)):(i.sphereDetail&&(this.sphereDetail=d(e.sphereDetail,1)),i.radialSegments&&(this.radialSegments=d(e.radialSegments,10))),i.openEnded&&(this.openEnded=d(e.openEnded,!0)),i.disableImpostor&&(this.disableImpostor=d(e.disableImpostor,!1))},getColorParams:function(t){return Object.assign({gidPool:this.gidPool,scheme:this.colorScheme,scale:this.colorScale,value:this.colorValue,domain:this.colorDomain,mode:this.colorMode},t)},getBufferParams:function(t){return Object.assign({clipNear:this.clipNear,clipRadius:this.clipRadius,clipCenter:this.clipCenter,flatShaded:this.flatShaded,opacity:this.opacity,side:this.side,wireframe:this.wireframe,linewidth:this.linewidth,roughness:this.roughness,metalness:this.metalness,diffuse:this.diffuse},t)},setColor:function(t,e){var i=Object.keys(dv.getTypes());return i.includes(t)?e?e.colorScheme=t:this.setParameters({colorScheme:t}):void 0!==t&&(t=new Pt(t).getHex(),e?(e.colorScheme="uniform",e.colorValue=t):this.setParameters({colorScheme:"uniform",colorValue:t})),this},prepare:!1,create:function(){},update:function(){this.build()},build:function(t){return this.lazy&&!this.visible?void(this.lazyProps.build=!0):this.prepare?(this.queue.length()>0?(this.tasks.change(1-this.queue.length()),this.queue.kill()):this.tasks.increment(),void this.queue.push(t||!1)):(this.tasks.increment(),void this.make())},make:function(e,i){t.Debug&&uv.time("Representation.make "+this.type);var n=function(){e?(this.update(e),this.viewer.requestRender(),this.tasks.decrement(),i&&i()):(this.clear(),this.create(),this.manualAttach||this.disposed||(t.Debug&&uv.time("Representation.attach "+this.type),this.attach(function(){t.Debug&&uv.timeEnd("Representation.attach "+this.type),this.tasks.decrement(),i&&i()}.bind(this)))),t.Debug&&uv.timeEnd("Representation.make "+this.type)}.bind(this);this.prepare?this.prepare(n):n()},attach:function(t){this.setVisibility(this.visible),t()},setVisibility:function(t,e){if(this.visible=t,this.visible){var i=this.lazyProps;if(i.build)return i.build=!1,void this.build();(i.bufferParams||i.what)&&this.updateParameters(i.bufferParams,i.what)}return this.bufferList.forEach(function(e){e.setVisibility(t)}),e||this.viewer.requestRender(),this},setParameters:function(t,e,i){var n=t||{},r=this.parameters;e=e||{},i=i||!1;var o={};for(var a in n)void 0!==n[a]&&void 0!==r[a]&&(r[a].int&&(n[a]=parseInt(n[a])),r[a].float&&(n[a]=parseFloat(n[a])),n[a]!==this[a]&&(this[a]=n[a],r[a].buffer&&(r[a].buffer===!0?o[a]=n[a]:o[r[a].buffer]=n[a]),r[a].update&&(e[r[a].update]=!0),!r[a].rebuild||"impostor"===r[a].rebuild&&cv&&!this.disableImpostor||(i=!0)));return i?this.build():this.updateParameters(o,e),this},updateParameters:function(t,e){return this.lazy&&!this.visible?(Object.assign(this.lazyProps.bufferParams,t),void Object.assign(this.lazyProps.what,e)):(this.bufferList.forEach(function(e){e.setParameters(t)}),Object.keys(e).length&&this.update(e),void this.viewer.requestRender())},getParameters:function(){var t={lazy:this.lazy,visible:this.visible,quality:this.quality};return Object.keys(this.parameters).forEach(function(e){"button"===this.parameters.type?t[e]=this[e].bind(this):t[e]=this[e]},this),t},clear:function(){this.bufferList.forEach(function(t){this.viewer.remove(t),t.dispose()},this),this.bufferList.length=0,this.viewer.requestRender()},dispose:function(){this.disposed=!0,this.queue.kill(),this.tasks.dispose(),this.clear()}},Ua.prototype=Object.assign(Object.create(Ba.prototype),{constructor:Ua,type:"buffer",parameters:Object.assign({},Ba.prototype.parameters,{colorScheme:null,colorScale:null,colorValue:null,colorDomain:null,colorMode:null}),create:function(){this.bufferList.push.apply(this.bufferList,this.buffer)},attach:function(t){this.bufferList.forEach(function(t){this.viewer.add(t),t.setParameters(this.getBufferParams())},this),this.setVisibility(this.visible),t()}}),ja.prototype=Object.assign(Object.create(ba.prototype),{constructor:ja,type:"surface"}),$a.prototype.constructor=$a,Va.prototype=Object.assign(Object.create(Ba.prototype),{constructor:Va,type:"surface",parameters:Object.assign({isolevelType:{type:"select",options:{value:"value",sigma:"sigma"}},isolevel:{type:"number",precision:2,max:1e3,min:-1e3},smooth:{type:"integer",precision:1,max:10,min:0},background:{type:"boolean",
	rebuild:!0},opaqueBack:{type:"boolean",buffer:!0},boxSize:{type:"integer",precision:1,max:100,min:0},useWorker:{type:"boolean",rebuild:!0}},Ba.prototype.parameters),init:function(t){var e=t||{};e.colorScheme=d(e.colorScheme,"uniform"),e.colorValue=d(e.colorValue,14540253),this.isolevelType=d(e.isolevelType,"sigma"),this.isolevel=d(e.isolevel,2),this.smooth=d(e.smooth,0),this.background=d(e.background,!1),this.opaqueBack=d(e.opaqueBack,!0),this.boxSize=d(e.boxSize,0),this.useWorker=d(e.useWorker,!0),Ba.prototype.init.call(this,e)},attach:function(t){this.bufferList.forEach(function(t){this.viewer.add(t)},this),this.setVisibility(this.visible),t()},prepare:function(t){if(this.volume){var e;if(e="sigma"===this.isolevelType?this.volume.getValueForSigma(this.isolevel):this.isolevel,!this.surface||this.__isolevel!==e||this.__smooth!==this.smooth||this.__boxSize!==this.boxSize||this.boxSize>0&&!this.__boxCenter.equals(this.boxCenter)){this.__isolevel=e,this.__smooth=this.smooth,this.__boxSize=this.boxSize,this.__boxCenter.copy(this.boxCenter),this.__box.copy(this.box);var i=function(e){this.surface=e,t()}.bind(this);this.useWorker?this.volume.getSurfaceWorker(e,this.smooth,this.boxCenter,this.boxSize,i):i(this.volume.getSurface(e,this.smooth,this.boxCenter,this.boxSize))}else t()}else t()},create:function(){var t=new ja(this.surface.getPosition(),this.surface.getColor(this.getColorParams()),this.surface.getIndex(),this.surface.getNormal(),void 0,this.getBufferParams({background:this.background,opaqueBack:this.opaqueBack,dullInterior:!1})),e=new $a(t);this.bufferList.push(e)},update:function(t){if(0!==this.bufferList.length){t=t||{};var e={};t.position&&(e.position=this.surface.getPosition()),t.color&&(e.color=this.surface.getColor(this.getColorParams())),t.index&&(e.index=this.surface.getIndex()),t.normal&&(e.normal=this.surface.getNormal()),this.bufferList.forEach(function(t){t.setAttributes(e)})}},setParameters:function(t,e,i){return t&&void 0!==t.isolevelType&&this.volume&&("value"===this.isolevelType&&"sigma"===t.isolevelType?this.isolevel=this.volume.getSigmaForValue(this.isolevel):"sigma"===this.isolevelType&&"value"===t.isolevelType&&(this.isolevel=this.volume.getValueForSigma(this.isolevel)),this.isolevelType=t.isolevelType),t&&t.boxCenter&&(this.boxCenter.copy(t.boxCenter),delete t.boxCenter),Ba.prototype.setParameters.call(this,t,e,i),this.volume&&this.volume.getBox(this.boxCenter,this.boxSize,this.box),this.surface&&(void 0!==t.isolevel||void 0!==t.smooth||void 0!==t.boxSize||this.boxSize>0&&!this.__box.equals(this.box))&&this.build({position:!0,color:!0,index:!0,normal:!0}),this},dispose:function(){this.viewer.signals.orientationChanged.remove(this.setBox),Ba.prototype.dispose.call(this)}}),gv.add("shader/Point.vert","uniform float nearClip;\nuniform float clipRadius;\nuniform vec3 clipCenter;\nuniform float size;\nuniform float canvasHeight;\nuniform float pixelRatio;\nvarying vec3 vViewPosition;\n#if defined( RADIUS_CLIP )\nvarying vec3 vClipCenter;\n#endif\n#include color_pars_vertex\n#include common\nvoid main(){\n#include color_vertex\n#include begin_vertex\n#include project_vertex\n#ifdef USE_SIZEATTENUATION\ngl_PointSize = size * pixelRatio * ( ( canvasHeight / 2.0 ) / -mvPosition.z );\n#else\ngl_PointSize = size * pixelRatio;\n#endif\nvViewPosition = -mvPosition.xyz;\n#if defined( RADIUS_CLIP )\nvClipCenter = -( modelViewMatrix * vec4( clipCenter, 1.0 ) ).xyz;\n#endif\n#include nearclip_vertex\n#include radiusclip_vertex\n}"),gv.add("shader/Point.frag","uniform vec3 diffuse;\nuniform float opacity;\nuniform float nearClip;\nuniform float clipRadius;\nvarying vec3 vViewPosition;\n#if defined( RADIUS_CLIP )\nvarying vec3 vClipCenter;\n#endif\n#ifdef USE_MAP\nuniform sampler2D map;\n#endif\n#include common\n#include color_pars_fragment\n#include fog_pars_fragment\nvoid main(){\n#include nearclip_fragment\n#include radiusclip_fragment\nvec3 outgoingLight = vec3( 0.0 );\nvec4 diffuseColor = vec4( diffuse, 1.0 );\n#ifdef USE_MAP\ndiffuseColor *= texture2D( map, vec2( gl_PointCoord.x, 1.0 - gl_PointCoord.y ) );\n#endif\n#include color_fragment\n#include alphatest_fragment\noutgoingLight = diffuseColor.rgb;\ngl_FragColor = vec4( outgoingLight, diffuseColor.a * opacity );\n#include premultiplied_alpha_fragment\n#include tonemapping_fragment\n#include encodings_fragment\n#include fog_fragment\n}"),Ha.prototype=Object.assign(Object.create(ya.prototype),{constructor:Ha,parameters:Object.assign({pointSize:{uniform:"size"},sizeAttenuation:{updateShader:!0},sortParticles:{},alphaTest:{updateShader:!0},useTexture:{updateShader:!0},forceTransparent:{},edgeBleach:{uniform:!0}},ya.prototype.parameters),makeMaterial:function(){ya.prototype.makeMaterial.call(this),this.makeTexture(),this.material.uniforms.map.value=this.tex,this.material.blending=vh,this.material.needsUpdate=!0,this.wireframeMaterial.uniforms.map.value=this.tex,this.wireframeMaterial.blending=vh,this.wireframeMaterial.needsUpdate=!0,this.pickingMaterial.uniforms.map.value=this.tex,this.pickingMaterial.blending=vh,this.pickingMaterial.needsUpdate=!0},makeTexture:function(){this.tex&&this.tex.dispose(),this.tex=Ga({delta:this.edgeBleach})},getDefines:function(t){var e=ya.prototype.getDefines.call(this,t);return this.sizeAttenuation&&(e.USE_SIZEATTENUATION=1),this.useTexture&&(e.USE_MAP=1),this.alphaTest>0&&this.alphaTest<=1&&(e.ALPHATEST=this.alphaTest.toPrecision(2)),e},setUniforms:function(t){t&&void 0!==t.edgeBleach&&(this.makeTexture(),t.map=this.tex),ya.prototype.setUniforms.call(this,t)},dispose:function(){ya.prototype.dispose.call(this),this.tex&&this.tex.dispose()}}),Wa.prototype=Object.assign(Object.create(Ba.prototype),{constructor:Wa,type:"dot",parameters:Object.assign({thresholdType:{type:"select",rebuild:!0,options:{value:"value",sigma:"sigma"}},thresholdMin:{type:"number",precision:3,max:1/0,min:-(1/0),rebuild:!0},thresholdMax:{type:"number",precision:3,max:1/0,min:-(1/0),rebuild:!0},thresholdOut:{type:"boolean",rebuild:!0},dotType:{type:"select",rebuild:!0,options:{"":"",sphere:"sphere",point:"point"}},radiusType:{type:"select",options:{"":"",value:"value","abs-value":"abs-value","value-min":"value-min",deviation:"deviation",size:"size"}},radius:{type:"number",precision:3,max:10,min:.001,property:"size"},scale:{type:"number",precision:3,max:10,min:.001},sphereDetail:!0,disableImpostor:!0,pointSize:{type:"number",precision:1,max:100,min:0,buffer:!0},sizeAttenuation:{type:"boolean",buffer:!0},sortParticles:{type:"boolean",rebuild:!0},useTexture:{type:"boolean",buffer:!0},alphaTest:{type:"range",step:.001,max:1,min:0,buffer:!0},forceTransparent:{type:"boolean",buffer:!0},edgeBleach:{type:"range",step:.001,max:1,min:0,buffer:!0}},Ba.prototype.parameters,{colorScheme:{type:"select",update:"color",options:{"":"",value:"value",uniform:"uniform"}}}),defaultSize:.1,init:function(t){var e=t||{};e.colorScheme=d(e.colorScheme,"uniform"),e.colorValue=d(e.colorValue,14540253),this.thresholdType=d(e.thresholdType,"sigma"),this.thresholdMin=d(e.thresholdMin,2),this.thresholdMax=d(e.thresholdMax,1/0),this.thresholdOut=d(e.thresholdOut,!1),this.dotType=d(e.dotType,"point"),this.radius=d(e.radius,.1),this.scale=d(e.scale,1),this.pointSize=d(e.pointSize,1),this.sizeAttenuation=d(e.sizeAttenuation,!0),this.sortParticles=d(e.sortParticles,!1),this.useTexture=d(e.useTexture,!1),this.alphaTest=d(e.alphaTest,.5),this.forceTransparent=d(e.forceTransparent,!1),this.edgeBleach=d(e.edgeBleach,0),Ba.prototype.init.call(this,e)},attach:function(t){this.bufferList.forEach(function(t){this.viewer.add(t)},this),this.setVisibility(this.visible),t()},create:function(){var t,e,i,n;if(this.volume){var r,o,a=this.volume;"sigma"===this.thresholdType?(r=a.getValueForSigma(this.thresholdMin),o=a.getValueForSigma(this.thresholdMax)):(r=this.thresholdMin,o=this.thresholdMax),a.filterData(r,o,this.thresholdOut),t=a.getDataPosition(),e=a.getDataColor(this.getColorParams()),i=a.getDataSize(this.radius,this.scale),n=a.getPickingDataColor(this.getColorParams())}else{var s=this.surface;t=s.getPosition(),e=s.getColor(this.getColorParams()),i=s.getSize(this.radius,this.scale),n=s.getPickingColor(this.getColorParams())}"sphere"===this.dotType?this.dotBuffer=new Ta(t,e,i,n,this.getBufferParams({sphereDetail:this.sphereDetail,disableImpostor:this.disableImpostor,dullInterior:!1})):this.dotBuffer=new Ha(t,e,this.getBufferParams({pointSize:this.pointSize,sizeAttenuation:this.sizeAttenuation,sortParticles:this.sortParticles,useTexture:this.useTexture,alphaTest:this.alphaTest,forceTransparent:this.forceTransparent,edgeBleach:this.edgeBleach})),this.bufferList.push(this.dotBuffer)},update:function(t){if(0!==this.bufferList.length){t=t||{};var e={};t.color&&(this.volume?e.color=this.volume.getDataColor(this.getColorParams()):e.color=this.surface.getColor(this.getColorParams())),"sphere"===this.dotType&&(t.radius||t.scale)&&(this.volume?e.radius=this.volume.getDataSize(this.radius,this.scale):e.radius=this.surface.getSize(this.radius,this.scale)),this.dotBuffer.setAttributes(e)}},setParameters:function(t,e,i){return e=e||{},t&&void 0!==t.thresholdType&&this.volume instanceof fa&&("value"===this.thresholdType&&"sigma"===t.thresholdType?(this.thresholdMin=this.volume.getSigmaForValue(this.thresholdMin),this.thresholdMax=this.volume.getSigmaForValue(this.thresholdMax)):"sigma"===this.thresholdType&&"value"===t.thresholdType&&(this.thresholdMin=this.volume.getValueForSigma(this.thresholdMin),this.thresholdMax=this.volume.getValueForSigma(this.thresholdMax)),this.thresholdType=t.thresholdType),t&&void 0!==t.radiusType&&("radius"===t.radiusType?this.radius=this.defaultSize:this.radius=t.radiusType,e.radius=!0,"sphere"!==this.dotType||cv&&!this.disableImpostor||(i=!0)),t&&void 0!==t.radius&&(e.radius=!0,"sphere"!==this.dotType||cv&&!this.disableImpostor||(i=!0)),t&&void 0!==t.scale&&(e.scale=!0,"sphere"!==this.dotType||cv&&!this.disableImpostor||(i=!0)),Ba.prototype.setParameters.call(this,t,e,i),this}}),gv.add("shader/Image.vert","uniform float clipRadius;\nuniform vec3 clipCenter;\nvarying vec2 vUv;\nvarying vec3 vViewPosition;\n#if defined( RADIUS_CLIP )\nvarying vec3 vClipCenter;\n#endif\nvoid main() {\n#include begin_vertex\n#include project_vertex\nvUv = uv;\nvViewPosition = -mvPosition.xyz;\n#if defined( RADIUS_CLIP )\nvClipCenter = -( modelViewMatrix * vec4( clipCenter, 1.0 ) ).xyz;\n#endif\n}"),gv.add("shader/Image.frag","uniform sampler2D map;\nuniform float opacity;\nuniform vec2 mapSize;\nuniform float nearClip;\nuniform float clipRadius;\nvarying vec2 vUv;\nvarying vec3 vViewPosition;\n#if defined( RADIUS_CLIP )\nvarying vec3 vClipCenter;\n#endif\n#include fog_pars_fragment\n#if defined( CUBIC_INTERPOLATION )\n#if defined( CATMULROM_FILTER ) || defined( MITCHELL_FILTER )\n#if defined( CATMULROM_FILTER )\nconst float B = 0.0;\nconst float C = 0.5;\n#elif defined( MITCHELL_FILTER )\nconst float B = 0.333;\nconst float C = 0.333;\n#endif\nfloat filter( float x ){\nfloat f = x;\nif( f < 0.0 )\n{\nf = -f;\n}\nif( f < 1.0 )\n{\nreturn ( ( 12.0 - 9.0 * B - 6.0 * C ) * ( f * f * f ) +\n( -18.0 + 12.0 * B + 6.0 *C ) * ( f * f ) +\n( 6.0 - 2.0 * B ) ) / 6.0;\n}\nelse if( f >= 1.0 && f < 2.0 )\n{\nreturn ( ( -B - 6.0 * C ) * ( f * f * f )\n+ ( 6.0 * B + 30.0 * C ) * ( f *f ) +\n( - ( 12.0 * B ) - 48.0 * C ) * f +\n8.0 * B + 24.0 * C)/ 6.0;\n}\nelse\n{\nreturn 0.0;\n}\n}\n#elif defined( BSPLINE_FILTER )\nfloat filter( float x ){\nfloat f = x;\nif( f < 0.0 ){\nf = -f;\n}\nif( f >= 0.0 && f <= 1.0 ){\nreturn ( 2.0 / 3.0 ) + ( 0.5 ) * ( f*f*f ) - ( f*f );\n}else if( f > 1.0 && f <= 2.0 ){\nreturn 1.0 / 6.0 * pow( ( 2.0 - f ), 3.0 );\n}\nreturn 1.0;\n}\n#else\nfloat filter( float x ){\nreturn 1.0;\n}\n#endif\nvec4 biCubic( sampler2D tex, vec2 texCoord ){\nvec2 texelSize = 1.0 / mapSize;\ntexCoord -= texelSize / 2.0;\nvec4 nSum = vec4( 0.0 );\nfloat nDenom = 0.0;\nvec2 cell = fract( texCoord * mapSize );\nfor( float m = -1.0; m <= 2.0; ++m ){\nfor( float n = -1.0; n <= 2.0; ++n ){\nvec4 vecData = texture2D(\ntex, texCoord + texelSize * vec2( m, n )\n);\nfloat c = filter( m - cell.x ) * filter( -n + cell.y );\nnSum += vecData * c;\nnDenom += c;\n}\n}\nreturn nSum / nDenom;\n}\n#endif\nvoid main(){\n#include nearclip_fragment\n#include radiusclip_fragment\n#if defined( CUBIC_INTERPOLATION )\ngl_FragColor = biCubic( map, vUv );\n#else\ngl_FragColor = texture2D( map, vUv );\n#endif\ngl_FragColor.a *= opacity;\nif( gl_FragColor.a < 0.01 )\ndiscard;\n#include fog_fragment\n}");var Uv=new Uint16Array([0,1,2,1,3,2]),jv=new Float32Array([0,1,0,0,1,1,1,0]);Xa.prototype=Object.assign(Object.create(ya.prototype),{constructor:Xa,parameters:Object.assign({filter:{updateShader:!0,uniform:!0}},ya.prototype.parameters),getDefines:function(t){var e=ya.prototype.getDefines.call(this,t);return this.filter.startsWith("cubic")&&(e.CUBIC_INTERPOLATION=1,this.filter.endsWith("bspline")?e.BSPLINE_FILTER=1:this.filter.endsWith("catmulrom")?e.CATMULROM_FILTER=1:this.filter.endsWith("mitchell")&&(e.MITCHELL_FILTER=1)),e},updateTexture:function(){var t=this.tex;this.filter.startsWith("cubic")?(t.minFilter=ll,t.magFilter=ll):"linear"===this.filter?(t.minFilter=pl,t.magFilter=pl):(t.minFilter=ll,t.magFilter=ll),t.needsUpdate=!0},makeMaterial:function(){ya.prototype.makeMaterial.call(this),this.updateTexture();var t=this.material;t.uniforms.map.value=this.tex,t.blending=vh,t.needsUpdate=!0;var e=this.wireframeMaterial;e.uniforms.map.value=this.tex,e.blending=vh,e.needsUpdate=!0;var i=this.pickingMaterial;i.uniforms.map.value=this.tex,i.blending=vh,i.needsUpdate=!0},setUniforms:function(t){t&&void 0!==t.filter&&(this.updateTexture(),t.map=this.tex),ya.prototype.setUniforms.call(this,t)}}),qa.prototype=Object.assign(Object.create(Ba.prototype),{constructor:qa,type:"slice",parameters:Object.assign({filter:{type:"select",buffer:!0,options:{nearest:"nearest",linear:"linear","cubic-bspline":"cubic-bspline","cubic-catmulrom":"cubic-catmulrom","cubic-mitchell":"cubic-mitchell"}},position:{type:"range",step:.1,max:100,min:1,rebuild:!0},dimension:{type:"select",rebuild:!0,options:{x:"x",y:"y",z:"z"}},thresholdType:{type:"select",rebuild:!0,options:{value:"value",sigma:"sigma"}},thresholdMin:{type:"number",precision:3,max:1/0,min:-(1/0),rebuild:!0},thresholdMax:{type:"number",precision:3,max:1/0,min:-(1/0),rebuild:!0}},Ba.prototype.parameters,{flatShaded:null,side:null,wireframe:null,linewidth:null,colorScheme:null,roughness:null,metalness:null,diffuse:null}),init:function(t){var e=t||{};e.colorScheme=d(e.colorScheme,"value"),e.colorScale=d(e.colorScale,"Spectral"),Ba.prototype.init.call(this,e),this.colorScheme="value",this.dimension=d(e.dimension,"x"),this.filter=d(e.filter,"cubic-bspline"),this.position=d(e.position,30),this.thresholdType=d(e.thresholdType,"sigma"),this.thresholdMin=d(e.thresholdMin,-(1/0)),this.thresholdMax=d(e.thresholdMax,1/0)},attach:function(t){this.bufferList.forEach(function(t){this.viewer.add(t)},this),this.setVisibility(this.visible),t()},create:function(){function t(t){return Math.round(t/100*(i-1))}function e(t,e,i,r){return 3*(i*n.ny*n.nx+e*n.nx+t)+r}var i=this.position,n=this.volume;n.filterData(-(1/0),1/0,!1);var r,o,a,s,c,u=n.data,h=n.matrix,l=new Float32Array(12),d=0,f=0,p=0,m=n.nx,g=n.ny,v=n.nz,y=new N;"x"===this.dimension?(a=t(n.nx),s=n.ny-1,c=n.nz-1,r=n.nz,o=n.ny,d=a,m=d+1,y.set(a,0,0).applyMatrix4(h).toArray(l,0),y.set(a,s,0).applyMatrix4(h).toArray(l,3),y.set(a,0,c).applyMatrix4(h).toArray(l,6),y.set(a,s,c).applyMatrix4(h).toArray(l,9)):"y"===this.dimension?(a=n.nx-1,s=t(n.ny),c=n.nz-1,r=n.nz,o=n.nx,f=s,g=f+1,y.set(0,s,0).applyMatrix4(h).toArray(l,0),y.set(a,s,0).applyMatrix4(h).toArray(l,3),y.set(0,s,c).applyMatrix4(h).toArray(l,6),y.set(a,s,c).applyMatrix4(h).toArray(l,9)):"z"===this.dimension&&(a=n.nx-1,s=n.ny-1,c=t(n.nz),r=n.nx,o=n.ny,p=c,v=p+1,y.set(0,0,c).applyMatrix4(h).toArray(l,0),y.set(0,s,c).applyMatrix4(h).toArray(l,3),y.set(a,0,c).applyMatrix4(h).toArray(l,6),y.set(a,s,c).applyMatrix4(h).toArray(l,9));var b,x,_=0,w=new Uint8Array(r*o*4);"sigma"===this.thresholdType?(b=n.getValueForSigma(this.thresholdMin),x=n.getValueForSigma(this.thresholdMax)):(b=this.thresholdMin,x=this.thresholdMax);var S=this.getColorParams({volume:n});S.domain=[n.getDataMin(),n.getDataMax()];for(var A=dv.getScheme(S),M=new Float32Array(3),C=f;C<g;++C)for(var P=d;P<m;++P)for(var T=p;T<v;++T){var E=e(P,C,T,0)/3,I=u[E];A.volumeColorToArray(E,M),w[_]=Math.round(255*M[0]),w[_+1]=Math.round(255*M[1]),w[_+2]=Math.round(255*M[2]),w[_+3]=I>b&&I<x?255:0,_+=4}var L=new Xa(l,w,r,o,this.getBufferParams({filter:this.filter}));this.bufferList.push(L)}}),Ya.prototype=Object.assign(Object.create(Ba.prototype),{constructor:Ya,type:"structure",parameters:Object.assign({radiusType:{type:"select",options:Ir.types},radius:{type:"number",precision:3,max:10,min:.001},scale:{type:"number",precision:3,max:10,min:.001},assembly:null,defaultAssembly:{type:"hidden"}},Ba.prototype.parameters),defaultScale:{vdw:1,covalent:1,bfactor:.01,sstruc:1},defaultSize:1,init:function(t){var e=t||{};if(e.colorScheme=d(e.colorScheme,"element"),this.radius=d(e.radius,"vdw"),this.scale=d(e.scale,1),this.assembly=d(e.assembly,"default"),this.defaultAssembly=d(e.defaultAssembly,""),"auto"===e.quality){var i,n=this.structureView,r=this.getAssembly();i=r?r.getAtomCount(n):n.atomCount,av&&(i*=4);var o=n.atomStore.count/n.residueStore.count<2;o&&(i*=10),i<15e3?e.quality="high":i<8e4?e.quality="medium":e.quality="low"}Ba.prototype.init.call(this,e)},getAssembly:function(){var t="default"===this.assembly?this.defaultAssembly:this.assembly;return this.structure.biomolDict[t]},create:function(){if(0!==this.structureView.atomCount){var t=this.getAssembly();if(t)t.partList.forEach(function(t,e){var i=t.getView(this.structureView);if(0!==i.atomCount){var n=this.createData(i,e);n&&(n.sview=i,n.instanceList=t.getInstanceList(),this.dataList.push(n))}},this);else{var e=this.createData(this.structureView,0);e&&(e.sview=this.structureView,this.dataList.push(e))}}},createData:function(){console.error("createData not implemented")},update:function(t){return this.lazy&&!this.visible?void Object.assign(this.lazyProps.what,t):void this.dataList.forEach(function(e){e.bufferList.length>0&&this.updateData(t,e)},this)},updateData:function(){console.error("updateData not implemented")},getColorParams:function(){var t=Ba.prototype.getColorParams.call(this);return t.structure=this.structure,t},getAtomParams:function(t,e){return Object.assign({what:t,colorParams:this.getColorParams(),radiusParams:{radius:this.radius,scale:this.scale}},e)},getBondParams:function(t,e){return Object.assign({what:t,colorParams:this.getColorParams(),radiusParams:{radius:this.radius,scale:this.scale}},e)},setSelection:function(t,e){return this.selection.setString(t,e),this},setParameters:function(t,e,i){return e=e||{},t&&void 0!==t.radiusType&&("size"===t.radiusType?this.radius=this.defaultSize:this.radius=t.radiusType,e.radius=!0,cv&&!this.disableImpostor||(i=!0)),t&&void 0!==t.radius&&(e.radius=!0,cv&&!this.disableImpostor||(i=!0)),t&&void 0!==t.scale&&(e.radius=!0,cv&&!this.disableImpostor||(i=!0)),t&&void 0!==t.defaultAssembly&&(i=!0),Ba.prototype.setParameters.call(this,t,e,i),this},getParameters:function(){var t=Object.assign(Ba.prototype.getParameters.call(this),{sele:this.selection?this.selection.string:void 0,defaultAssembly:this.defaultAssembly});return t},attach:function(t){var e=this.viewer,i=this.bufferList;this.dataList.forEach(function(t){t.bufferList.forEach(function(n){i.push(n),e.add(n,t.instanceList)})}),this.setVisibility(this.visible),t()},clear:function(){this.dataList.length=0,Ba.prototype.clear.call(this)},dispose:function(){this.structureView.dispose(),delete this.structure,delete this.structureView,Ba.prototype.dispose.call(this)}}),gv.add("shader/Line.vert","uniform float nearClip;\nuniform vec3 clipCenter;\nvarying vec3 vViewPosition;\n#if defined( RADIUS_CLIP )\nvarying vec3 vClipCenter;\n#endif\n#include color_pars_vertex\nvoid main(){\n#include color_vertex\n#include begin_vertex\n#include project_vertex\nvViewPosition = -mvPosition.xyz;\n#if defined( RADIUS_CLIP )\nvClipCenter = -( modelViewMatrix * vec4( clipCenter, 1.0 ) ).xyz;\n#endif\n#include nearclip_vertex\n}"),gv.add("shader/Line.frag","uniform float opacity;\nuniform float nearClip;\nuniform float clipRadius;\nvarying vec3 vViewPosition;\n#if defined( RADIUS_CLIP )\nvarying vec3 vClipCenter;\n#endif\n#include common\n#include color_pars_fragment\n#include fog_pars_fragment\nvoid main(){\n#include nearclip_fragment\n#include radiusclip_fragment\ngl_FragColor = vec4( vColor, opacity );\n#include premultiplied_alpha_fragment\n#include tonemapping_fragment\n#include encodings_fragment\n#include fog_fragment\n}"),Za.prototype=Object.assign(Object.create(ya.prototype),{constructor:Za,setAttributes:function(t){var e,i,n,r,o,a,s=this.geometry.attributes;t.from&&t.to&&(e=t.from,i=t.to,o=s.position.array,s.position.needsUpdate=!0),t.color&&t.color2&&(n=t.color,r=t.color2,a=s.color.array,s.color.needsUpdate=!0);for(var c,u,h,l,d,f,p,m,g,v,y,b,x=this.size,_=6*x,w=0;w<x;w++)u=3*w,c=2*w*3,h=c+_,e&&i&&(p=e[u],m=e[u+1],g=e[u+2],v=i[u],y=i[u+1],b=i[u+2],l=(p+v)/2,d=(m+y)/2,f=(g+b)/2,o[c]=p,o[c+1]=m,o[c+2]=g,o[c+3]=l,o[c+4]=d,o[c+5]=f,o[h]=l,o[h+1]=d,o[h+2]=f,o[h+3]=v,o[h+4]=y,o[h+5]=b),n&&r&&(a[c]=a[c+3]=n[u],a[c+1]=a[c+4]=n[u+1],a[c+2]=a[c+5]=n[u+2],a[h]=a[h+3]=r[u],a[h+1]=a[h+4]=r[u+1],a[h+2]=a[h+5]=r[u+2])}}),Ka.prototype=Object.assign(Object.create(Ya.prototype),{constructor:Ka,type:"",parameters:Object.assign({drawLine:{type:"boolean",rebuild:!0},drawCylinder:{type:"boolean",rebuild:!0},drawPoint:{type:"boolean",rebuild:!0},drawSphere:{type:"boolean",rebuild:!0},linewidth:{type:"integer",max:20,min:1,rebuild:!0},pointSize:{type:"integer",max:20,min:1,rebuild:!0},sizeAttenuation:{type:"boolean",rebuild:!0},sort:{type:"boolean",rebuild:!0}},Ba.prototype.parameters),init:function(t){var e=t||{};e.colorScheme=d(e.colorScheme,"uniform"),e.colorValue=d(e.colorValue,14540253),this.drawLine=d(e.drawLine,!0),this.drawCylinder=d(e.drawCylinder,!1),this.drawPoint=d(e.drawPoint,!1),this.drawSphere=d(e.drawSphere,!1),this.pointSize=d(e.pointSize,1),this.sizeAttenuation=d(e.sizeAttenuation,!1),this.sort=d(e.sort,!0),Ya.prototype.init.call(this,e)},attach:function(t){this.bufferList.forEach(function(t){this.viewer.add(t)},this),this.setVisibility(this.visible),t()},prepare:function(t){t()},create:function(){if(0!==this.atomSet.atomCount){var t=this,e=this.atomSet.atoms[0].index;this.trajectory.getPath(e,function(e){var i=e.length/3,n=new Pt(t.colorValue);if(t.drawSphere){var r=new Ta(e,br(i,n.r,n.g,n.b),yr(i,.2),br(i,n.r,n.g,n.b),t.getBufferParams({sphereDetail:t.sphereDetail,dullInterior:!0,disableImpostor:t.disableImpostor}));t.bufferList.push(r)}if(t.drawCylinder){var o=new Da(e.subarray(0,-3),e.subarray(3),br(i-1,n.r,n.g,n.b),br(i-1,n.r,n.g,n.b),yr(i,.05),br(i-1,n.r,n.g,n.b),br(i-1,n.r,n.g,n.b),t.getBufferParams({openEnded:!1,radialSegments:t.radialSegments,disableImpostor:t.disableImpostor,dullInterior:!0}));t.bufferList.push(o)}if(t.drawPoint){var a=new Ha(e,br(i,n.r,n.g,n.b),t.getBufferParams({pointSize:t.pointSize,sizeAttenuation:t.sizeAttenuation,sort:t.sort}));t.bufferList.push(a)}if(t.drawLine){var s=new Za(e.subarray(0,-3),e.subarray(3),br(i-1,n.r,n.g,n.b),br(i-1,n.r,n.g,n.b),t.getBufferParams());t.bufferList.push(s)}t.attach()})}}});var $v=0;ts.prototype={constructor:ts,type:"component",signals:{representationAdded:null,representationRemoved:null,visibilityChanged:null,statusChanged:null,nameChanged:null,disposed:null},addRepresentation:function(t,e,i){var n=i||{},r=this.stage.getParameters();n.quality=n.quality||r.quality,n.disableImpostor=d(n.disableImpostor,!r.impostor),n.visible=d(n.visible,!0),n.gidPool=this.stage.gidPool;var o=Object.assign({},n,{visible:this.visible&&n.visible}),a=Ja(t,e,this.viewer,o),s=this.__getRepresentationComponent(a,n);return this.reprList.push(s),this.signals.representationAdded.dispatch(s),s},addBufferRepresentation:function(t,e){return ts.prototype.addRepresentation.call(this,"buffer",t,e)},removeRepresentation:function(t){var e=this.reprList.indexOf(t);e!==-1&&this.reprList.splice(e,1),this.signals.representationRemoved.dispatch(t)},updateRepresentations:function(t){this.reprList.forEach(function(e){e.update(t)}),this.stage.viewer.requestRender()},clearRepresentations:function(){this.reprList.slice().forEach(function(t){t.dispose()})},dispose:function(){this.clearRepresentations(),delete this.reprList,this.signals.disposed.dispatch()},setVisibility:function(t){return this.visible=t,this.eachRepresentation(function(t){t.updateVisibility()}),this.signals.visibilityChanged.dispatch(t),this},setStatus:function(t){return this.status=t,this.signals.statusChanged.dispatch(t),this},setName:function(t){return this.name=t,this.signals.nameChanged.dispatch(t),this},getCenter:function(){},eachRepresentation:function(t){this.reprList.forEach(t)}},ts.prototype.__getRepresentationComponent=function(t,e){return new es(this.stage,t,e,this)},es.prototype=Object.assign(Object.create(ts.prototype),{constructor:es,type:"representation",signals:Object.assign({parametersChanged:null},ts.prototype.signals),getType:function(){return this.repr.type},setRepresentation:function(t){this.disposeRepresentation(),this.repr=t,this.stage.tasks.listen(this.repr.tasks),this.updateVisibility()},addRepresentation:function(){},removeRepresentation:function(){},disposeRepresentation:function(){this.repr&&(this.stage.tasks.unlisten(this.repr.tasks),this.repr.dispose())},dispose:function(){this.parent&&this.parent.removeRepresentation(this),this.disposeRepresentation(),delete this.reprArgs,this.signals.disposed.dispatch()},setVisibility:function(t){return this.visible=t,this.updateVisibility(),this.signals.visibilityChanged.dispatch(this.visible),this},getVisibility:function(){return this.parent?this.parent.visible&&this.visible:this.visible},updateVisibility:function(){this.repr.setVisibility(this.getVisibility())},update:function(t){return this.repr.update(t),this},build:function(t){return this.repr.build(t),this},setSelection:function(t){return this.repr.setSelection(t),this},setParameters:function(t){return this.repr.setParameters(t),this.signals.parametersChanged.dispatch(this.repr.getParameters()),this},getParameters:function(){return this.repr.getParameters()},setColor:function(t){return this.repr.setColor(t),this},getCenter:function(){}}),is.prototype={constructor:is,_remove:function(t){var e=this.list.indexOf(t);e!==-1&&this.list.splice(e,1)},_invoke:function(t,e){for(var i=this.list.length,n=0;n<i;++n){var r=this.list[n],o=r[t];"function"==typeof o&&o.apply(r,e)}return this},setVisibility:function(t){return this._invoke("setVisibility",[t])},setSelection:function(t){return this._invoke("setSelection",[t])},dispose:function(){return this._invoke("dispose")}},ns.prototype=Object.assign(Object.create(is.prototype),{constructor:ns,addRepresentation:function(t,e){return this._invoke("addRepresentation",[t,e])},centerView:function(t,e){return this._invoke("centerView",[t,e])}}),rs.prototype=Object.assign(Object.create(is.prototype),{constructor:rs,setParameters:function(t){return this._invoke("setParameters",[t])},setColor:function(t){return this._invoke("setColor",[t])}}),os.prototype={constructor:os,parameters:{backgroundColor:{type:"color"},quality:{type:"select",options:{auto:"auto",low:"low",medium:"medium",high:"high"}},sampleLevel:{type:"range",step:1,max:5,min:-1},impostor:{type:"boolean"},rotateSpeed:{type:"number",precision:1,max:10,min:0},zoomSpeed:{type:"number",precision:1,max:10,min:0},panSpeed:{type:"number",precision:1,max:10,min:0},clipNear:{type:"range",step:1,max:100,min:0},clipFar:{type:"range",step:1,max:100,min:0},clipDist:{type:"integer",max:200,min:0},fogNear:{type:"range",step:1,max:100,min:0},fogFar:{type:"range",step:1,max:100,min:0},cameraType:{type:"select",options:{perspective:"perspective",orthographic:"orthographic"}},cameraFov:{type:"range",step:1,max:120,min:15},lightColor:{type:"color"},lightIntensity:{type:"number",precision:2,max:10,min:0},ambientColor:{type:"color"},ambientIntensity:{type:"number",precision:2,max:10,min:0},hoverTimeout:{type:"integer",max:1e4,min:10}},setParameters:function(t){var e=Object.assign({},t),i=this.parameters,n=this.viewer,r=n.controls,o=this.pickingControls;for(var a in e)void 0!==e[a]&&i[a]&&(i[a].int&&(e[a]=parseInt(e[a])),i[a].float&&(e[a]=parseFloat(e[a])),i[a].value=e[a]);return void 0!==e.quality&&this.setQuality(e.quality),void 0!==e.impostor&&this.setImpostor(e.impostor),void 0!==e.rotateSpeed&&(r.rotateSpeed=e.rotateSpeed),void 0!==e.zoomSpeed&&(r.zoomSpeed=e.zoomSpeed),void 0!==e.panSpeed&&(r.panSpeed=e.panSpeed),o.setParameters({hoverTimeout:e.hoverTimeout}),n.setClip(e.clipNear,e.clipFar,e.clipDist),n.setFog(void 0,e.fogNear,e.fogFar),n.setCamera(e.cameraType,e.cameraFov),n.setSampling(e.sampleLevel),n.setBackground(e.backgroundColor),n.setLight(e.lightColor,e.lightIntensity,e.ambientColor,e.ambientIntensity),this.signals.parametersChanged.dispatch(this.getParameters()),this},getParameters:function(){var t={};for(var e in this.parameters)t[e]=this.parameters[e].value;return t},defaultFileRepresentation:function(e){if("structure"===e.type){e.setSelection("/0");var i,n,r=e.structure;if(r.biomolDict.BU1){var o=r.biomolDict.BU1;i=o.getAtomCount(r),n=o.getInstanceCount(),e.setDefaultAssembly("BU1")}else i=r.getModelProxy(0).atomCount,n=1;av&&(i*=4);var a=r.atomStore.count/r.residueStore.count<2;a&&(i*=10);var s="chainname";if(1===r.getChainnameCount("polymer and /0")&&(s="residueindex"),t.Debug&&console.log(i,n,a),n>5&&i>15e3||i>7e5){var c=Math.min(1.5,Math.max(.1,2e3/(i/n)));a&&(c=Math.min(c,.15)),e.addRepresentation("surface",{sele:"polymer",surfaceType:"sas",probeRadius:1.4,scaleFactor:c,colorScheme:s,colorScale:"RdYlBu",useWorker:!1})}else i>25e4?e.addRepresentation("backbone",{lineOnly:!0,colorScheme:s,colorScale:"RdYlBu"}):i>1e5?e.addRepresentation("backbone",{quality:"low",disableImpostor:!0,colorScheme:s,colorScale:"RdYlBu",scale:2}):i>8e4?e.addRepresentation("backbone",{colorScheme:s,colorScale:"RdYlBu",scale:2}):(e.addRepresentation("cartoon",{color:s,colorScale:"RdYlBu",scale:.7,aspectRatio:5,quality:"auto"}),i<5e4&&e.addRepresentation("base",{color:s,colorScale:"RdYlBu",quality:"auto"}),e.addRepresentation("ball+stick",{sele:"hetero and not ( water or ion )",colorScheme:"element",scale:2,aspectRatio:1.5,bondScale:.3,bondSpacing:.75,quality:"auto"}));this.centerView(),e.structure.frames.length&&e.addTrajectory()}else"surface"!==e.type&&"volume"!==e.type||(e.addRepresentation("surface"),this.centerView())},loadFile:function(t,e){var i=Object.assign({},this.defaultFileParams,e),n=new ts(this,i);n.name=y(t).name,this.addComponent(n);var r=this.tasks;r.increment();var o=function(t){return this.removeComponent(n),n=this.addComponentFromObject(t,i),"script"===n.type&&n.run(),i.defaultRepresentation&&this.defaultFileRepresentation(n),r.decrement(),n}.bind(this),a=function(t){throw n.setStatus(t),r.decrement(),t};return rr(t,i).then(o,a)},addComponent:function(t){return t?(this.compList.push(t),void this.signals.componentAdded.dispatch(t)):void uv.warn("Stage.addComponent: no component given")},addComponentFromObject:function(t,e){var i=yv.get(t.type);if(i){var n=new i(this,t,e);return this.addComponent(n),n}uv.warn("no component for object type",t.type)},removeComponent:function(t){var e=this.compList.indexOf(t);e!==-1&&this.compList.splice(e,1),t.dispose(),this.signals.componentRemoved.dispatch(t)},removeAllComponents:function(t){this.compList.slice().forEach(function(e){t&&e.type!==t||this.removeComponent(e)},this)},handleResize:function(){this.viewer.handleResize()},toggleFullscreen:function(t){function e(){return document.fullscreenElement||document.mozFullScreenElement||document.webkitFullscreenElement||document.msFullscreenElement}function i(){
	if(!e()&&n.lastFullscreenElement){var t=n.lastFullscreenElement;t.style.width=t.dataset.normalWidth,t.style.height=t.dataset.normalHeight,document.removeEventListener("fullscreenchange",i),document.removeEventListener("mozfullscreenchange",i),document.removeEventListener("webkitfullscreenchange",i),document.removeEventListener("MSFullscreenChange",i),n.handleResize(),n.signals.fullscreenChanged.dispatch(!1)}}if(!(document.fullscreenEnabled||document.mozFullScreenEnabled||document.webkitFullscreenEnabled||document.msFullscreenEnabled))return void uv.log("fullscreen mode (currently) not possible");var n=this;t=t||this.viewer.container,this.lastFullscreenElement=t,e()?document.exitFullscreen?document.exitFullscreen():document.msExitFullscreen?document.msExitFullscreen():document.mozCancelFullScreen?document.mozCancelFullScreen():document.webkitExitFullscreen&&document.webkitExitFullscreen():(t.dataset.normalWidth=t.style.width,t.dataset.normalHeight=t.style.height,t.style.width=screen.width+"px",t.style.height=screen.height+"px",t.requestFullscreen?t.requestFullscreen():t.msRequestFullscreen?t.msRequestFullscreen():t.mozRequestFullScreen?t.mozRequestFullScreen():t.webkitRequestFullscreen&&t.webkitRequestFullscreen(),document.addEventListener("fullscreenchange",i),document.addEventListener("mozfullscreenchange",i),document.addEventListener("webkitfullscreenchange",i),document.addEventListener("MSFullscreenChange",i),this.handleResize(),this.signals.fullscreenChanged.dispatch(!0),setTimeout(function(){n.handleResize()},100))},centerView:function(){if(this.tasks.count>0){var t=function(e,i){0===i&&this.tasks.signals.countChanged.remove(t,this),this.viewer.centerView(!0)};this.tasks.signals.countChanged.add(t,this)}this.viewer.centerView(!0)},setSpin:function(t,e){Array.isArray(t)&&(t=(new N).fromArray(t)),this.viewer.setSpin(t,e)},setOrientation:function(t){this.tasks.onZeroOnce(function(){this.viewer.setOrientation(t)},this)},getOrientation:function(){return this.viewer.getOrientation()},makeImage:function(t){var e=this.viewer,i=this.tasks;return new Promise(function(n,r){function o(){i.increment(),e.makeImage(t).then(function(t){i.decrement(),n(t)}).catch(function(t){i.decrement(),r(t)})}i.onZeroOnce(o)})},setImpostor:function(t){this.parameters.impostor.value=t;var e=["spacefill","ball+stick","licorice","hyperball","backbone","rocket","helixorient","contact","distance","dot"];this.eachRepresentation(function(i){if("script"!==i.type&&e.includes(i.getType())){var n=i.getParameters();n.disableImpostor=!t,i.build(n)}})},setQuality:function(t){this.parameters.quality.value=t;var e=["tube","cartoon","ribbon","trace","rope"],i=["spacefill","ball+stick","licorice","hyperball","backbone","rocket","helixorient","contact","distance","dot"];this.eachRepresentation(function(n){if("script"!==n.type){var r=n.getParameters();if(!e.includes(n.getType())){if(!i.includes(n.getType()))return;if(!r.disableImpostor)return void(n.repr.quality=t)}r.quality=t,n.build(r)}})},eachComponent:function(t,e){this.compList.forEach(function(i,n){e&&i.type!==e||t(i,n)})},eachRepresentation:function(t,e){this.eachComponent(function(e){e.reprList.forEach(function(i){t(i,e)})},e)},getComponentsByName:function(t,e){var i=[];return this.eachComponent(function(e){void 0!==t&&null===e.name.match(t)||i.push(e)},e),new ns(i)},getRepresentationsByName:function(t,e){var i,n;"object"!=typeof t?(i=void 0,n=t):(i=t.comp,n=t.repr);var r=[];return this.eachRepresentation(function(t,e){void 0!==i&&null===e.name.match(i)||void 0!==n&&null===t.name.match(n)||r.push(t)},e),new rs(r)},getAnythingByName:function(t){var e=this.getComponentsByName(t).list,i=this.getRepresentationsByName(t).list;return new is(e.concat(i))},dispose:function(){this.tasks.dispose()}},as.prototype={constructor:as,_animate:function(){var t;if(this._running=!0,this.traj.inProgress||this._stopFlag||(t="forward"===this.direction?this.traj.currentFrame+this.step:this.traj.currentFrame-this.step,(t>=this.end||t<this.start)&&("once"===this.mode?(this.pause(),t="forward"===this.direction?this.end:this.start):t="forward"===this.direction?this.start:this.end),this.interpolateType||this.traj.setFrame(t)),this._stopFlag)this._running=!1;else if(!this.traj.inProgress&&this.interpolateType){var e,i,n;"forward"===this.direction?(e=Math.max(this.start,t-this.step),i=Math.max(this.start,t-2*this.step),n=Math.max(this.start,t-3*this.step)):(e=Math.min(this.end,t+this.step),i=Math.min(this.end,t+2*this.step),n=Math.min(this.end,t+3*this.step)),this._interpolate(t,e,i,n,1/this.interpolateStep,0)}else setTimeout(this._animate.bind(this),this.timeout)},_interpolate:function(t,e,i,n,r,o){if(o+=r,o<=1){var a=Math.round(this.timeout*r);this.traj.setFrameInterpolated(t,e,i,n,o,this.interpolateType,function(){setTimeout(function(){this._interpolate(t,e,i,n,r,o)}.bind(this),a)}.bind(this))}else setTimeout(this._animate.bind(this),0)},toggle:function(){this._running?this.pause():this.play()},play:function(){if(!this._running){this.traj.player!==this&&this.traj.setPlayer(this);var t=this.traj.currentFrame,e=Math.ceil(t/this.step)*this.step;"forward"===this.direction&&t>=this.end?e=this.start:"backward"===this.direction&&t<=this.start&&(e=this.end),this.traj.setFrame(e),this._stopFlag=!1,this._animate(),this.signals.startedRunning.dispatch()}},pause:function(){this._running&&(this._stopFlag=!0,this.signals.haltedRunning.dispatch())},stop:function(){this.traj.setFrame(this.start),this.pause()}};var Vv=function(){function t(t,e){var i,n=0,r={};return e.forEach(function(e){i=0;var o={};e.forEach(function(e){o[t[i++]]=e}),r[t[n++]]=o}),r}var e=[[4,0,-2,-1,-2,0,-2,-1,-1,-1,-1,-2,-1,-1,-1,1,0,0,-3,-2],[0,9,-3,-4,-2,-3,-3,-1,-3,-1,-1,-3,-3,-3,-3,-1,-1,-1,-2,-2],[-2,-3,6,2,-3,-1,-1,-3,-1,-4,-3,1,-1,0,-2,0,-1,-3,-4,-3],[-1,-4,2,5,-3,-2,0,-3,1,-3,-2,0,-1,2,0,0,-1,-2,-3,-2],[-2,-2,-3,-3,6,-3,-1,0,-3,0,0,-3,-4,-3,-3,-2,-2,-1,1,3],[0,-3,-1,-2,-3,6,-2,-4,-2,-4,-3,0,-2,-2,-2,0,-2,-3,-2,-3],[-2,-3,-1,0,-1,-2,8,-3,-1,-3,-2,1,-2,0,0,-1,-2,-3,-2,2],[-1,-1,-3,-3,0,-4,-3,4,-3,2,1,-3,-3,-3,-3,-2,-1,3,-3,-1],[-1,-3,-1,1,-3,-2,-1,-3,5,-2,-1,0,-1,1,2,0,-1,-2,-3,-2],[-1,-1,-4,-3,0,-4,-3,2,-2,4,2,-3,-3,-2,-2,-2,-1,1,-2,-1],[-1,-1,-3,-2,0,-3,-2,1,-1,2,5,-2,-2,0,-1,-1,-1,1,-1,-1],[-2,-3,1,0,-3,0,1,-3,0,-3,-2,6,-2,0,0,1,0,-3,-4,-2],[-1,-3,-1,-1,-4,-2,-2,-3,-1,-3,-2,-2,7,-1,-2,-1,-1,-2,-4,-3],[-1,-3,0,2,-3,-2,0,-3,1,-2,0,0,-1,5,1,0,-1,-2,-2,-1],[-1,-3,-2,0,-3,-2,0,-3,2,-2,-1,0,-2,1,5,-1,-1,-3,-3,-2],[1,-1,0,0,-2,0,-1,-2,0,-2,-1,1,-1,0,-1,4,1,-2,-3,-2],[0,-1,-1,-1,-2,-2,-2,-1,-1,-1,-1,0,-1,-1,-1,1,5,0,-2,-2],[0,-1,-3,-2,-1,-3,-3,3,-2,1,1,-3,-2,-2,-3,-2,0,4,-3,-1],[-3,-2,-4,-3,1,-2,-2,-3,-3,-2,-1,-4,-4,-2,-3,-3,-2,-3,11,2],[-2,-2,-3,-2,3,-3,2,-1,-2,-1,-1,-2,-3,-1,-2,-2,-2,-1,2,7]],i=[[4,-1,-2,-2,0,-1,-1,0,-2,-1,-1,-1,-1,-2,-1,1,0,-3,-2,0,-2,-1,0],[-1,5,0,-2,-3,1,0,-2,0,-3,-2,2,-1,-3,-2,-1,-1,-3,-2,-3,-1,0,-1],[-2,0,6,1,-3,0,0,0,1,-3,-3,0,-2,-3,-2,1,0,-4,-2,-3,3,0,-1],[-2,-2,1,6,-3,0,2,-1,-1,-3,-4,-1,-3,-3,-1,0,-1,-4,-3,-3,4,1,-1],[0,-3,-3,-3,9,-3,-4,-3,-3,-1,-1,-3,-1,-2,-3,-1,-1,-2,-2,-1,-3,-3,-2],[-1,1,0,0,-3,5,2,-2,0,-3,-2,1,0,-3,-1,0,-1,-2,-1,-2,0,3,-1],[-1,0,0,2,-4,2,5,-2,0,-3,-3,1,-2,-3,-1,0,-1,-3,-2,-2,1,4,-1],[0,-2,0,-1,-3,-2,-2,6,-2,-4,-4,-2,-3,-3,-2,0,-2,-2,-3,-3,-1,-2,-1],[-2,0,1,-1,-3,0,0,-2,8,-3,-3,-1,-2,-1,-2,-1,-2,-2,2,-3,0,0,-1],[-1,-3,-3,-3,-1,-3,-3,-4,-3,4,2,-3,1,0,-3,-2,-1,-3,-1,3,-3,-3,-1],[-1,-2,-3,-4,-1,-2,-3,-4,-3,2,4,-2,2,0,-3,-2,-1,-2,-1,1,-4,-3,-1],[-1,2,0,-1,-3,1,1,-2,-1,-3,-2,5,-1,-3,-1,0,-1,-3,-2,-2,0,1,-1],[-1,-1,-2,-3,-1,0,-2,-3,-2,1,2,-1,5,0,-2,-1,-1,-1,-1,1,-3,-1,-1],[-2,-3,-3,-3,-2,-3,-3,-3,-1,0,0,-3,0,6,-4,-2,-2,1,3,-1,-3,-3,-1],[-1,-2,-2,-1,-3,-1,-1,-2,-2,-3,-3,-1,-2,-4,7,-1,-1,-4,-3,-2,-2,-1,-2],[1,-1,1,0,-1,0,0,0,-1,-2,-2,0,-1,-2,-1,4,1,-3,-2,-2,0,0,0],[0,-1,0,-1,-1,-1,-1,-2,-2,-1,-1,-1,-1,-2,-1,1,5,-2,-2,0,-1,-1,0],[-3,-3,-4,-4,-2,-2,-3,-2,-2,-3,-2,-3,-1,1,-4,-3,-2,11,2,-3,-4,-3,-2],[-2,-2,-2,-3,-2,-1,-2,-3,2,-1,-1,-2,-1,3,-3,-2,-2,2,7,-1,-3,-2,-1],[0,-3,-3,-3,-1,-2,-2,-3,-3,3,1,-2,1,-1,-2,-2,0,-3,-1,4,-3,-2,-1],[-2,-1,3,4,-3,0,1,-1,0,-3,-4,0,-3,-3,-2,0,-1,-4,-3,-3,4,1,-1],[-1,0,0,1,-3,3,4,-2,0,-3,-3,1,-1,-3,-1,0,-1,-3,-2,-2,1,4,-1],[0,-1,-1,-1,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,0,0,-2,-1,-1,-1,-1,-1]],n="ACDEFGHIKLMNPQRSTVWY",r="ARNDCQEGHILKMFPSTWYVBZ?";return{blosum62:t(r,i),blosum62x:t(n,e)}}();ss.prototype={constructor:ss,initMatrices:function(){this.n=this.seq1.length,this.m=this.seq2.length,this.score=void 0,this.ali="",this.S=[],this.V=[],this.H=[];var t,e;for(t=0;t<=this.n;++t)for(this.S[t]=[],this.V[t]=[],this.H[t]=[],e=0;e<=this.m;++e)this.S[t][e]=0,this.V[t][e]=0,this.H[t][e]=0;for(t=0;t<=this.n;++t)this.S[t][0]=this.gap(0),this.H[t][0]=-(1/0);for(e=0;e<=this.m;++e)this.S[0][e]=this.gap(0),this.V[0][e]=-(1/0);this.S[0][0]=0},gap:function(t){return this.gapPenalty+t*this.gapExtensionPenalty},makeScoreFn:function(){var t,e,i=this.seq1,n=this.seq2,r=this.substMatrix;return r?function(o,a){t=i[o],e=n[a];try{return r[t][e]}catch(t){return-4}}:(uv.warn("Alignment: no subst matrix"),function(r,o){return t=i[r],e=n[o],t===e?5:-3})},calc:function(){t.Debug&&uv.time("Alignment.calc"),this.initMatrices();var e,i,n,r,o,a,s,c=this.gap(0),u=this.makeScoreFn(),h=this.gapExtensionPenalty,l=this.V,d=this.H,f=this.S,p=this.n,m=this.m;for(a=1;a<=p;++a)for(i=f[a-1],e=l[a-1],n=l[a],r=d[a],o=f[a],s=1;s<=m;++s)n[s]=Math.max(i[s]+c,e[s]+h),r[s]=Math.max(o[s-1]+c,r[s-1]+h),o[s]=Math.max(i[s-1]+u(a-1,s-1),n[s],r[s]);t.Debug&&uv.timeEnd("Alignment.calc"),t.Debug&&uv.log(this.S,this.V,this.H)},trace:function(){t.Debug&&uv.time("Alignment.trace"),this.ali1="",this.ali2="";var e=this.makeScoreFn(),i=this.n,n=this.m,r="S";for(this.S[i][n]>=this.V[i][n]&&this.S[i][n]>=this.V[i][n]?(r="S",this.score=this.S[i][n]):this.V[i][n]>=this.H[i][n]?(r="V",this.score=this.V[i][n]):(r="H",this.score=this.H[i][n]),t.Debug&&uv.log("Alignment: SCORE",this.score),t.Debug&&uv.log("Alignment: S, V, H",this.S[i][n],this.V[i][n],this.H[i][n]);i>0&&n>0;)"S"===r?this.S[i][n]===this.S[i-1][n-1]+e(i-1,n-1)?(this.ali1=this.seq1[i-1]+this.ali1,this.ali2=this.seq2[n-1]+this.ali2,--i,--n,r="S"):this.S[i][n]===this.V[i][n]?r="V":this.S[i][n]===this.H[i][n]?r="H":(--i,--n):"V"===r?this.V[i][n]===this.V[i-1][n]+this.gapExtensionPenalty?(this.ali1=this.seq1[i-1]+this.ali1,this.ali2="-"+this.ali2,--i,r="V"):this.V[i][n]===this.S[i-1][n]+this.gap(0)?(this.ali1=this.seq1[i-1]+this.ali1,this.ali2="-"+this.ali2,--i,r="S"):--i:"H"===r?this.H[i][n]===this.H[i][n-1]+this.gapExtensionPenalty?(this.ali1="-"+this.ali1,this.ali2=this.seq2[n-1]+this.ali2,--n,r="H"):this.H[i][n]===this.S[i][n-1]+this.gap(0)?(this.ali1="-"+this.ali1,this.ali2=this.seq2[n-1]+this.ali2,--n,r="S"):--n:uv.error("Alignment: no matrix");for(;i>0;)this.ali1=this.seq1[i-1]+this.ali1,this.ali2="-"+this.ali2,--i;for(;n>0;)this.ali1="-"+this.ali1,this.ali2=this.seq2[n-1]+this.ali2,--n;t.Debug&&uv.timeEnd("Alignment.trace"),t.Debug&&uv.log([this.ali1,this.ali2])}},us.prototype=Object.assign(Object.create(ts.prototype),{constructor:us,type:"script",addRepresentation:function(){},removeRepresentation:function(){},run:function(){var t=this;this.setStatus("running"),this.script.call(this.stage,function(){t.setStatus("finished")}),this.setStatus("called")},dispose:function(){this.signals.disposed.dispatch()},setVisibility:function(){},getCenter:function(){}}),yv.add("script",us),hs.prototype=Object.assign(Object.create(ts.prototype),{constructor:hs,type:"shape",addRepresentation:function(t,e){return ts.prototype.addRepresentation.call(this,t,this.shape,e)},centerView:function(t){t=d(t,!0);var e=this.getCenter();if(t){var i=this.shape.boundingBox,n=i.size(),r=Math.max(n.x,n.y,n.z),o=Math.min(n.x,n.y,n.z);t=Math.max(1,r+o/2)}return this.viewer.centerView(t,e),this},getCenter:function(){return this.shape.center},dispose:function(){this.shape.dispose(),ts.prototype.dispose.call(this)}}),yv.add("shape",hs),ls.prototype=Object.assign(Object.create(ts.prototype),{constructor:ls,type:"trajectory",signals:Object.assign({frameChanged:null,playerChanged:null,gotNumframes:null,parametersChanged:null},ts.prototype.signals),addRepresentation:function(t,e){return ts.prototype.addRepresentation.call(this,t,this.trajectory,e)},setFrame:function(t){this.trajectory.setFrame(t)},setParameters:function(t){return this.trajectory.setParameters(t),this.signals.parametersChanged.dispatch(t),this},dispose:function(){this.trajectory.dispose(),ts.prototype.dispose.call(this)},getCenter:function(){}}),ds.prototype=Object.assign(Object.create(ga.prototype),{constructor:ds,type:"frames",setFrames:function(t){this.name=t.name,this.path=t.path,this.frames=t.coordinates,this.boxes=t.boxes},makeAtomIndices:function(){"StructureView"===this.structure.type?this.atomIndices=this.structure.getAtomIndices():this.atomIndices=null},_loadFrame:function(t,e){var i,n=this.frames[t];if(this.atomIndices){var r=this.atomIndices,o=r.length;i=new Float32Array(3*o);for(var a=0;a<o;++a){var s=3*a,c=3*r[a];i[s+0]=n[c+0],i[s+1]=n[c+1],i[s+2]=n[c+2]}}else i=new Float32Array(n);var u=this.boxes[t],h=this.frames.length;this.process(t,u,i,h),"function"==typeof e&&e()},getNumframes:function(){this.frames&&this.setNumframes(this.frames.length)},getPath:function(t,e){var i,n,r,o=this.numframes,a=3*t,s=new Float32Array(3*o);for(i=0;i<o;++i)n=3*i,r=this.frames[i],s[n+0]=r[a+0],s[n+1]=r[a+1],s[n+2]=r[a+2];e(s)}}),fs.prototype=Object.assign(Object.create(ga.prototype),{constructor:fs,type:"structure",makeAtomIndices:function(){this.structure.atomSet.size()<this.structure.atomStore.count?this.atomIndices=this.structure.getAtomIndices():this.atomIndices=null},_loadFrame:function(t,e){var i,n=this.structure,r=n.frames[t];if(this.atomIndices){var o=this.atomIndices,a=o.length;i=new Float32Array(3*a);for(var s=0;s<a;++s){var c=3*s,u=3*o[s];i[c+0]=r[u+0],i[c+1]=r[u+1],i[c+2]=r[u+2]}}else i=new Float32Array(r);var h=n.boxes[t],l=n.frames.length;this.process(t,h,i,l),"function"==typeof e&&e()},getNumframes:function(){this.setNumframes(this.structure.frames.length)},getPath:function(t,e){var i,n,r,o=this.numframes,a=3*t,s=new Float32Array(3*o);for(i=0;i<o;++i)n=3*i,r=this.structure.frames[i],s[n+0]=r[a+0],s[n+1]=r[a+1],s[n+2]=r[a+2];e(s)}}),ps.prototype=Object.assign(Object.create(ga.prototype),{constructor:ps,type:"remote",makeAtomIndices:function(){var t=[];if("StructureView"===this.structure.type){var e,i,n=this.structure.getAtomIndices(),r=n[0],o=n[0],a=n.length;for(e=1;e<a;++e)i=n[e],o+1<i&&(t.push([r,o+1]),r=i),o=i;t.push([r,o+1])}else t.push([0,this.atomCount]);this.atomIndices=t},_loadFrame:function(t,e){var i=new XMLHttpRequest,n=fv.trajectory,r=n.getFrameUrl(this.trajPath,t),o=n.getFrameParams(this.trajPath,this.atomIndices);i.open("POST",r,!0),i.responseType="arraybuffer",i.setRequestHeader("Content-type","application/x-www-form-urlencoded"),i.addEventListener("load",function(){var n=i.response;if(!n)return void uv.error("empty arrayBuffer for '"+r+"'");var o=new Int32Array(n,0,1)[0],a=new Float32Array(n,8,9),s=new Float32Array(n,44);this.process(t,a,s,o),"function"==typeof e&&e()}.bind(this),!1),i.send(o)},getNumframes:function(){var t=new XMLHttpRequest,e=fv.trajectory,i=e.getNumframesUrl(this.trajPath);t.open("GET",i,!0),t.addEventListener("load",function(){this.setNumframes(parseInt(t.response))}.bind(this),!1),t.send(null)},getPath:function(t,e){if(this.pathCache[t])return void e(this.pathCache[t]);uv.time("loadPath");var i=new XMLHttpRequest,n=fv.trajectory,r=n.getPathUrl(this.trajPath,t),o="";i.open("POST",r,!0),i.responseType="arraybuffer",i.setRequestHeader("Content-type","application/x-www-form-urlencoded"),i.addEventListener("load",function(){uv.timeEnd("loadPath");var n=i.response;if(!n)return void uv.error("empty arrayBuffer for '"+r+"'");var o=new Float32Array(n);this.pathCache[t]=o,e(o)}.bind(this),!1),i.send(o)}}),ea.prototype.getView=function(t){return new gs(this,t)},gs.prototype=Object.assign(Object.create(ea.prototype),{constructor:gs,type:"StructureView",init:function(){Object.defineProperties(this,{name:{get:function(){return this.structure.name}},path:{get:function(){return this.structure.path}},title:{get:function(){return this.structure.title}},id:{get:function(){return this.structure.id}},atomSetDict:{get:function(){return this.structure.atomSetDict}},biomolDict:{get:function(){return this.structure.biomolDict}},entityList:{get:function(){return this.structure.entityList}},unitcell:{get:function(){return this.structure.unitcell}},frames:{get:function(){return this.structure.frames}},boxes:{get:function(){return this.structure.boxes}},bondStore:{get:function(){return this.structure.bondStore}},backboneBondStore:{get:function(){return this.structure.backboneBondStore}},rungBondStore:{get:function(){return this.structure.rungBondStore}},atomStore:{get:function(){return this.structure.atomStore}},residueStore:{get:function(){return this.structure.residueStore}},chainStore:{get:function(){return this.structure.chainStore}},modelStore:{get:function(){return this.structure.modelStore}},atomMap:{get:function(){return this.structure.atomMap}},residueMap:{get:function(){return this.structure.residueMap}},bondHash:{get:function(){return this.structure.bondHash}},spatialHash:{get:function(){return this.structure.spatialHash}}}),this._ap=this.getAtomProxy(),this._rp=this.getResidueProxy(),this._cp=this.getChainProxy(),this.selection&&this.selection.signals.stringChanged.add(this.refresh,this),this.structure.signals.refreshed.add(this.refresh,this)},refresh:function(){t.Debug&&uv.time("StructureView.refresh"),this.atomSetCache={},this.atomSet=this.getAtomSet(this.selection,!0),this.structure.atomSet&&(t.Debug&&uv.time("StructureView.refresh#atomSet.intersection"),this.atomSet=this.atomSet.intersection(this.structure.atomSet),t.Debug&&uv.timeEnd("StructureView.refresh#atomSet.intersection")),this.bondSet=this.getBondSet(),t.Debug&&uv.time("StructureView.refresh#atomSetDict.new_intersection");for(var e in this.atomSetDict){var i=this.atomSetDict[e];this.atomSetCache["__"+e]=i.new_intersection(this.atomSet)}t.Debug&&uv.timeEnd("StructureView.refresh#atomSetDict.new_intersection"),t.Debug&&uv.time("StructureView.refresh#size"),this.atomCount=this.atomSet.size(),this.bondCount=this.bondSet.size(),t.Debug&&uv.timeEnd("StructureView.refresh#size"),this.boundingBox=this.getBoundingBox(),this.center=this.boundingBox.center(),t.Debug&&uv.timeEnd("StructureView.refresh"),this.signals.refreshed.dispatch()},setSelection:function(t){this.selection=t,this.refresh()},getSelection:function(t){var e=[];t&&t.string&&e.push(t.string);var i=this.structure.getSelection();i&&i.string&&e.push(i.string),this.selection&&this.selection.string&&e.push(this.selection.string);var n="";return e.length>0&&(n="( "+e.join(" ) AND ( ")+" )"),new _n(n)},getStructure:function(){return this.structure.getStructure()},eachBond:function(t,e){this.structure.eachBond(t,this.getSelection(e))},eachAtom:function(t,e){var i=this.getAtomProxy(),n=this.getAtomSet(e),r=this.atomStore.count;if(n&&n.size()<r)n.forEach(function(e){i.index=e,t(i)});else for(var o=0;o<r;++o)i.index=o,t(i)},eachResidue:function(t,e){this.structure.eachResidue(t,this.getSelection(e))},eachResidueN:function(){console.error("StructureView.eachResidueN() not implemented")},eachChain:function(t,e){this.structure.eachChain(t,this.getSelection(e))},eachModel:function(t,e){this.structure.eachModel(t,this.getSelection(e))},getAtomSet:function(e,i){t.Debug&&uv.time("StructureView.getAtomSet");var n=this.structure.getAtomSet(e);return!i&&this.atomSet&&(n=n.new_intersection(this.atomSet)),t.Debug&&uv.timeEnd("StructureView.getAtomSet"),n},getAtomIndices:function(t){return this.structure.getAtomIndices(this.getSelection(t))},dispose:function(){this.selection&&this.selection.signals.stringChanged.remove(this.refresh,this),this.structure.signals.refreshed.remove(this.refresh,this),delete this.structure,delete this.atomSet,delete this.bondSet,delete this.atomCount,delete this.bondCount}}),vs.prototype=Object.assign(Object.create(ts.prototype),{constructor:vs,type:"structure",signals:Object.assign({trajectoryAdded:null,trajectoryRemoved:null,defaultAssemblyChanged:null},ts.prototype.signals),initSelection:function(t){this.selection=new _n(t),this.structureView=new gs(this.structure,this.selection),this.selection.signals.stringChanged.add(function(){this.structureView.setSelection(this.selection),this.rebuildRepresentations(),this.rebuildTrajectories()},this)},setSelection:function(t){return this.selection.setString(t),this},setDefaultAssembly:function(t){this.defaultAssembly=t,this.reprList.forEach(function(t){t.setParameters({defaultAssembly:this.defaultAssembly})},this),this.signals.defaultAssemblyChanged.dispatch(t)},rebuildRepresentations:function(){this.reprList.forEach(function(t){t.build()})},rebuildTrajectories:function(){this.trajList.slice().forEach(function(t){t.trajectory.setStructure(this.structureView)},this)},addRepresentation:function(t,e){var i=e||{};return i.defaultAssembly=this.defaultAssembly,ts.prototype.addRepresentation.call(this,t,this.structureView,i)},addTrajectory:function(t,e,i){var n={i:i},r=ms(t,this.structureView,e);r.signals.frameChanged.add(function(){this.updateRepresentations({position:!0})},this);var o=new ls(this.stage,r,n,this);return this.trajList.push(o),this.signals.trajectoryAdded.dispatch(o),o},removeTrajectory:function(t){var e=this.trajList.indexOf(t);e!==-1&&this.trajList.splice(e,1),t.dispose(),this.signals.trajectoryRemoved.dispatch(t)},dispose:function(){this.stage.gidPool.removeObject(this.structure),this.trajList.slice().forEach(function(t){t.dispose()}),this.trajList.length=0,this.structure.dispose(),ts.prototype.dispose.call(this)},centerView:function(t,e){t=d(t,!0);var i=this.getCenter(e);if(t){var n;n=e?this.structureView.getBoundingBox(new _n(e)):this.structureView.boundingBox;var r=n.size(),o=Math.max(r.x,r.y,r.z),a=Math.min(r.x,r.y,r.z);t=Math.max(1,o+a/2)}return this.viewer.centerView(t,i),this},getCenter:function(t){return t?this.structure.atomCenter(new _n(t)):this.structure.center},superpose:function(t,e,i,n){return cs(this.structureView,t.structureView,e,i,n),this.updateRepresentations({position:!0}),this},setVisibility:function(t){return ts.prototype.setVisibility.call(this,t),this.trajList.forEach(function(e){e.setVisibility(t)}),this}}),yv.add("structure",vs),ys.prototype=Object.assign(Object.create(ts.prototype),{constructor:ys,type:"surface",addRepresentation:function(t,e){return ts.prototype.addRepresentation.call(this,t,this.surface,e)},dispose:function(){this.surface.dispose(),ts.prototype.dispose.call(this)},centerView:function(t){var e=this.surface.center;t&&(t=this.surface.boundingBox.size().length()),this.viewer.centerView(t,e)}}),yv.add("surface",ys),bs.prototype=Object.assign(Object.create(ts.prototype),{constructor:bs,type:"volume",addRepresentation:function(t,e){return ts.prototype.addRepresentation.call(this,t,this.volume,e)},dispose:function(){this.stage.gidPool.removeObject(this.volume),this.volume.dispose(),ts.prototype.dispose.call(this)},centerView:function(t){var e=this.volume.center;t&&(t=this.volume.boundingBox.size().length()),this.viewer.centerView(t,e)}}),yv.add("volume",bs),xs.prototype=Object.assign(Object.create(Ya.prototype),{constructor:xs,type:"axes",parameters:Object.assign({radius:{type:"number",precision:3,max:10,min:.001},sphereDetail:!0,radialSegments:!0,disableImpostor:!0,align:{type:"button"},showAxes:{type:"boolean",rebuild:!0},showBox:{type:"boolean",rebuild:!0}},Ba.prototype.parameters,{assembly:null}),init:function(t){var e=t||{};e.radius=d(e.radius,.5),e.colorValue=d(e.colorValue,"lightgreen"),Ya.prototype.init.call(this,e),this.showAxes=d(e.showAxes,!0),this.showBox=d(e.showBox,!1)},getPrincipalAxes:function(){var t,e=this.getAssembly();return e&&(t=e.partList[0].getSelection()),this.structureView.getView(t).getPrincipalAxes()},align:function(){var t=this.getPrincipalAxes(this.structureView),e=(new N).copy(t[0][1]).sub(t[0][0]).normalize(),i=(new N).copy(t[2][1]).sub(t[2][0]).normalize();this.viewer.alignView(i,e,t[3],!0)},getAxesData:function(t){var e=this.getPrincipalAxes(t),i=new Pt(this.colorValue),n=0,r=0;this.showAxes&&(n+=6,r+=3),this.showBox&&(n+=8,r+=12);var o=new Float32Array(3*n),a=br(n,i.r,i.g,i.b),s=yr(n,this.radius),c=new Float32Array(3*r),u=new Float32Array(3*r),h=br(r,i.r,i.g,i.b),l=yr(r,this.radius),d=0;if(this.showAxes){var f=function(t,e){t.toArray(o,2*d),e.toArray(o,2*d+3),t.toArray(c,d),e.toArray(u,d),d+=3};f(e[0][0],e[0][1]),f(e[1][0],e[1][1]),f(e[2][0],e[2][1])}if(this.showBox){var p=(new N).subVectors(e[0][0],e[0][1]).normalize(),m=(new N).subVectors(e[1][0],e[1][1]).normalize(),g=(new N).subVectors(e[2][0],e[2][1]).normalize(),v=new N,y=new N,b=new N,x=new N,_=new N,w=-(1/0),S=-(1/0),A=-(1/0),M=-(1/0),C=-(1/0),P=-(1/0);t.eachAtom(function(t){Rr(v.copy(t),p,e[3]);var i=x.subVectors(v,e[3]).normalize().dot(p),n=v.distanceTo(e[3]);i>0?n>w&&(w=n):n>S&&(S=n),Rr(y.copy(t),m,e[3]);var r=x.subVectors(y,e[3]).normalize().dot(m),o=y.distanceTo(e[3]);r>0?o>A&&(A=o):o>M&&(M=o),Rr(b.copy(t),g,e[3]);var a=x.subVectors(b,e[3]).normalize().dot(g),s=b.distanceTo(e[3]);a>0?s>C&&(C=s):s>P&&(P=s)});var T=2*d,E=function(t,i,n){_.copy(e[3]).addScaledVector(p,t).addScaledVector(m,i).addScaledVector(g,n),_.toArray(o,T),T+=3};E(w,A,C),E(w,A,-P),E(w,-M,-P),E(w,-M,C),E(-S,-M,-P),E(-S,-M,C),E(-S,A,C),E(-S,A,-P);var I=d,L=function(t,e){_.fromArray(o,2*d+3*t).toArray(c,I),_.fromArray(o,2*d+3*e).toArray(u,I),I+=3};L(0,1),L(0,3),L(0,6),L(1,2),L(1,7),L(2,3),L(2,4),L(3,5),L(4,5),L(4,7),L(5,6),L(6,7)}return{vertexPosition:o,vertexColor:a,vertexRadius:s,edgePosition1:c,edgePosition2:u,edgeColor:h,edgeRadius:l}},create:function(){var t=this.getAxesData(this.structureView);this.sphereBuffer=new Ta(t.vertexPosition,t.vertexColor,t.vertexRadius,void 0,this.getBufferParams({sphereDetail:this.sphereDetail,disableImpostor:this.disableImpostor,dullInterior:!0})),this.cylinderBuffer=new Da(t.edgePosition1,t.edgePosition2,t.edgeColor,t.edgeColor,t.edgeRadius,void 0,void 0,this.getBufferParams({openEnded:!0,radialSegments:this.radialSegments,disableImpostor:this.disableImpostor,dullInterior:!0})),this.dataList.push({sview:this.structureView,bufferList:[this.sphereBuffer,this.cylinderBuffer]})},updateData:function(t,e){var i=this.getAxesData(e.sview),n={},r={};t&&!t.position||(n.position=i.vertexPosition,r.position1=i.edgePosition1,r.position2=i.edgePosition2),t&&!t.color||(n.color=i.vertexColor,r.color=i.edgeColor,r.color2=i.edgeColor),t&&!t.radius||(n.radius=i.vertexRadius,r.radius=i.edgeRadius),this.sphereBuffer.setAttributes(n),this.cylinderBuffer.setAttributes(r)}}),pv.add("axes",xs),_s.prototype=Object.assign(Object.create(Ya.prototype),{constructor:_s,type:"ball+stick",defaultSize:.15,parameters:Object.assign({sphereDetail:!0,radialSegments:!0,openEnded:!0,disableImpostor:!0,aspectRatio:{type:"number",precision:1,max:10,min:1},lineOnly:{type:"boolean",rebuild:!0},cylinderOnly:{type:"boolean",rebuild:!0},multipleBond:{type:"select",rebuild:!0,options:{off:"off",symmetric:"symmetric",offset:"offset"}},bondScale:{type:"number",precision:2,max:1,min:.01},bondSpacing:{type:"number",precision:2,max:2,min:.5}},Ya.prototype.parameters),init:function(t){var e=t||{};e.radius=d(e.radius,this.defaultSize),this.aspectRatio=d(e.aspectRatio,2),this.lineOnly=d(e.lineOnly,!1),this.cylinderOnly=d(e.cylinderOnly,!1),this.multipleBond=d(e.multipleBond,"off"),this.bondSpacing=d(e.bondSpacing,1),this.bondScale=d(e.bondScale,.4),Ya.prototype.init.call(this,e)},getAtomParams:function(t,e){return e=Object.assign({radiusParams:{radius:this.radius,scale:this.scale*this.aspectRatio}},e),Ya.prototype.getAtomParams.call(this,t,e)},getAtomData:function(t,e,i){return t.getAtomData(this.getAtomParams(e,i))},getBondParams:function(t,e){return e=Object.assign({multipleBond:this.multipleBond,bondSpacing:this.bondSpacing,bondScale:this.bondScale},e),Ya.prototype.getBondParams.call(this,t,e)},getBondData:function(t,e,i){return t.getBondData(this.getBondParams(e,i))},createData:function(t){var e=this.getBondData(t),i=[];if(this.lineOnly)this.lineBuffer=new Za(e.position1,e.position2,e.color1,e.color2,this.getBufferParams()),i.push(this.lineBuffer);else{var n=new Da(e.position1,e.position2,e.color1,e.color2,e.radius,e.pickingColor1,e.pickingColor2,this.getBufferParams({openEnded:this.openEnded,radialSegments:this.radialSegments,disableImpostor:this.disableImpostor,dullInterior:!0}));if(i.push(n),!this.cylinderOnly){var r=this.getAtomData(t),o=new Ta(r.position,r.color,r.radius,r.pickingColor,this.getBufferParams({sphereDetail:this.sphereDetail,disableImpostor:this.disableImpostor,dullInterior:!0}));i.push(o)}}return{bufferList:i}},updateData:function(t,e){"off"!==this.multipleBond&&t&&t.radius&&(t.position=!0);var i=this.getBondData(e.sview,t);if(this.lineOnly){var n={};t&&!t.position||(n.from=i.position1,n.to=i.position2),t&&!t.color||(n.color=i.color1,n.color2=i.color2),e.bufferList[0].setAttributes(n)}else{var r={};if(t&&!t.position||(r.position1=i.position1,r.position2=i.position2),t&&!t.color||(r.color=i.color1,r.color2=i.color2),t&&!t.radius||(r.radius=i.radius),e.bufferList[0].setAttributes(r),!this.cylinderOnly){var o=this.getAtomData(e.sview,t),a={};t&&!t.position||(a.position=o.position),t&&!t.color||(a.color=o.color),t&&!t.radius||(a.radius=o.radius),e.bufferList[1].setAttributes(a)}}},setParameters:function(t){var e=!1,i={};return t&&(t.aspectRatio||t.bondSpacing||t.bondScale)&&(i.radius=!0,cv&&!this.disableImpostor||(e=!0)),Ya.prototype.setParameters.call(this,t,i,e),this}}),pv.add("ball+stick",_s),ws.prototype=Object.assign(Object.create(_s.prototype),{constructor:ws,type:"backbone",defaultSize:.25,parameters:Object.assign({},_s.prototype.parameters,{multipleBond:null,bondSpacing:null}),init:function(t){var e=t||{};e.aspectRatio=d(e.aspectRatio,1),_s.prototype.init.call(this,e)},getAtomData:function(t,e,i){return t.getBackboneAtomData(this.getAtomParams(e,i))},getBondData:function(t,e,i){var n=this.getBondParams(e,i);return n.colorParams.backbone=!0,t.getBackboneBondData(n)}}),pv.add("backbone",ws),Ss.prototype=Object.assign(Object.create(_s.prototype),{constructor:Ss,type:"base",defaultSize:.3,parameters:Object.assign({},_s.prototype.parameters,{multipleBond:null,bondSpacing:null}),init:function(t){var e=t||{};e.aspectRatio=d(e.aspectRatio,1),_s.prototype.init.call(this,e)},getAtomData:function(t,e,i){return t.getRungAtomData(this.getAtomParams(e,i))},getBondData:function(t,e,i){var n=this.getBondParams(e,i);return n.colorParams.rung=!0,t.getRungBondData(n)}}),pv.add("base",Ss),Ms.prototype={constructor:Ms,getAtomIterator:function(t,e){function i(){var t=this.get(u);return u+=1,t}function n(i){var n=h[c%4];if(n.index=o.getAtomIndexByType(i,t),e&&i>0&&i<s&&"e"===n.sstruc){var r=l[c%4];return d.index=o.getAtomIndexByType(i+1,t),f.index=o.getAtomIndexByType(i-1,t),r.addVectors(d,f).add(n).add(n).multiplyScalar(.25),c+=1,r}return c+=1,n}function r(){c=0,u=-1}var o=this.polymer,a=o.structure,s=o.residueCount,c=0,u=-1,h=[a.getAtomProxy(),a.getAtomProxy(),a.getAtomProxy(),a.getAtomProxy()],l=[new N,new N,new N,new N],d=a.getAtomProxy(),f=a.getAtomProxy();return{size:s,next:i,get:n,reset:r}},getSubdividedColor:function(t){function e(t,e,i){d.atomColorToArray(t,e,i)}function i(t,e,i){f.atomColorToArray(t,e,i)}var n=this.subdiv,r=this.polymer,o=r.residueCount,a=o-1,s=a*n*3+3;r.isCyclic&&(s+=3*n);var c=new Float32Array(s),u=new Float32Array(s),h=this.getAtomIterator("trace"),l=t||{};l.structure=r.structure;var d=dv.getScheme(l),f=dv.getPickingScheme(l);return this.interpolator.getColor(h,e,i,c,u,0,r.isCyclic),{color:c,pickingColor:u}},getSubdividedPosition:function(){var t=this.getPosition();return{position:t}},getSubdividedOrientation:function(){var t=this.getTangent(),e=this.getNormals(t);return{tangent:t,normal:e.normal,binormal:e.binormal}},getSubdividedSize:function(t,e){
	function i(t){return h.atomRadius(t)}var n=this.subdiv,r=this.polymer,o=r.residueCount,a=o-1,s=a*n+1;r.isCyclic&&(s+=n);var c=new Float32Array(s),u=this.getAtomIterator("trace"),h=new Ir(t,e);return this.interpolator.getSize(u,i,c,0,r.isCyclic),{size:c}},getPosition:function(){var t=this.subdiv,e=this.polymer,i=e.residueCount,n=i-1,r=n*t*3+3;e.isCyclic&&(r+=3*t);var o=new Float32Array(r),a=this.positionIterator||this.getAtomIterator("trace",this.smoothSheet);return this.interpolator.getPosition(a,o,0,e.isCyclic),o},getTangent:function(){var t=this.subdiv,e=this.polymer,i=this.size,n=i-1,r=n*t*3+3;e.isCyclic&&(r+=3*t);var o=new Float32Array(r),a=this.positionIterator||this.getAtomIterator("trace",this.smoothSheet);return this.interpolator.getTangent(a,o,0,e.isCyclic),o},getNormals:function(t){var e=this.subdiv,i=this.polymer,n=i.isProtein(),r=this.size,o=r-1,a=o*e*3+3;i.isCyclic&&(a+=3*e);var s=new Float32Array(a),c=new Float32Array(a);if(this.directional&&!this.polymer.isCg()){var u=this.getAtomIterator("direction1"),h=this.getAtomIterator("direction2");this.interpolator.getNormalDir(u,h,t,s,c,0,i.isCyclic,n)}else this.interpolator.getNormal(r,t,s,c,0,i.isCyclic,n);return{normal:s,binormal:c}}},Cs.prototype=Object.assign(Object.create(ya.prototype),{constructor:Cs,setAttributes:function(){var t=new N,e=new N;return function(i){var n,r,o,a,s,c,u,h,l,d,f,p=this.aspectRatio,m=this.size2,g=m-1,v=this.radialSegments,y=this.geometry.attributes;i.position&&(n=i.position,r=i.normal,o=i.binormal,a=i.tangent,c=i.size,h=y.position.array,d=y.normal.array,y.position.needsUpdate=!0,y.normal.needsUpdate=!0),i.color&&(s=i.color,l=y.color.array,y.color.needsUpdate=!0),i.pickingColor&&(u=i.pickingColor,f=y.pickingColor.array,y.pickingColor.needsUpdate=!0);var b,x,_,w,S,A,M,C,P,T,E,I,L,R,O,D,N,k,F,z,B,U,j,$=[],V=[],G=[],H=[],W=[],X=[];if(n)for(x=0;x<v;++x)M=x/v*2*Math.PI,$[x]=p*Math.cos(M),V[x]=Math.sin(M),G[x]=p*Math.cos(M-.01),H[x]=Math.sin(M-.01),W[x]=p*Math.cos(M+.01),X[x]=Math.sin(M+.01);for(b=0;b<m;++b)for(_=3*b,w=_*v,n&&(t.set(a[_],a[_+1],a[_+2]),O=r[_],D=r[_+1],N=r[_+2],k=o[_],F=o[_+1],z=o[_+2],B=n[_],U=n[_+1],j=n[_+2],R=c[b]),x=0;x<v;++x)S=w+3*x,n&&(C=-R*$[x],P=R*V[x],T=-R*G[x],E=R*H[x],I=-R*W[x],L=R*X[x],h[S]=B+C*O+P*k,h[S+1]=U+C*D+P*F,h[S+2]=j+C*N+P*z,e.set(I*O+L*k-(T*O+E*k),I*D+L*F-(T*D+E*F),I*N+L*z-(T*N+E*z)).cross(t),d[S]=e.x,d[S+1]=e.y,d[S+2]=e.z),s&&(l[S]=s[_],l[S+1]=s[_+1],l[S+2]=s[_+2]),u&&(f[S]=u[_],f[S+1]=u[_+1],f[S+2]=u[_+2]);for(_=0,w=3*m*v,x=0;x<v;++x)S=_+3*x,A=w+3*x,n&&(h[A]=h[S],h[A+1]=h[S+1],h[A+2]=h[S+2],d[A]=a[_],d[A+1]=a[_+1],d[A+2]=a[_+2]),s&&(l[A]=l[S],l[A+1]=l[S+1],l[A+2]=l[S+2]),u&&(f[A]=f[S],f[A+1]=f[S+1],f[A+2]=f[S+2]);for(_=3*(m-1)*v,w=3*(m+1)*v,x=0;x<v;++x)S=_+3*x,A=w+3*x,n&&(h[A]=h[S],h[A+1]=h[S+1],h[A+2]=h[S+2],d[A]=a[3*g],d[A+1]=a[3*g+1],d[A+2]=a[3*g+2]),s&&(l[A]=l[S],l[A+1]=l[S+1],l[A+2]=l[S+2]),u&&(f[A]=f[S],f[A+1]=f[S+1],f[A+2]=f[S+2])}}(),makeIndex:function(){var t,e,i,n,r,o,a=this.meshIndex,s=this.size2,c=s-1,u=this.capTriangles,h=this.radialSegments,l=this.radialSegments+1;for(t=0;t<c;++t)for(e=t*h*3*2,i=t*h,n=(t+1)*h,o=0;o<h;++o)r=e+3*o*2,a[r]=i+o,a[r+1]=i+(o+1)%h,a[r+2]=n+o,a[r+3]=n+o,a[r+4]=i+(o+1)%h,a[r+5]=n+(o+1)%h;var d=[0];for(o=1;o<l/2;++o)d.push(o),h-o!==o&&d.push(h-o);for(r=c*h*3*2,e=s*h,o=0;o<d.length-2;++o)o%2===0?(a[r+3*o+0]=e+d[o+0],a[r+3*o+1]=e+d[o+1],a[r+3*o+2]=e+d[o+2]):(a[r+3*o+0]=e+d[o+2],a[r+3*o+1]=e+d[o+1],a[r+3*o+2]=e+d[o+0]);for(r=c*h*3*2+3*u,e=s*h+h,o=0;o<d.length-2;++o)o%2===0?(a[r+3*o+0]=e+d[o+0],a[r+3*o+1]=e+d[o+1],a[r+3*o+2]=e+d[o+2]):(a[r+3*o+0]=e+d[o+2],a[r+3*o+1]=e+d[o+1],a[r+3*o+2]=e+d[o+0])}}),Ps.prototype=Object.assign(Object.create(Ya.prototype),{constructor:Ps,type:"cartoon",parameters:Object.assign({aspectRatio:{type:"number",precision:1,max:10,min:1},subdiv:{type:"integer",max:50,min:1,rebuild:!0},radialSegments:{type:"integer",max:50,min:1,rebuild:!0},tension:{type:"number",precision:1,max:1,min:.1},capped:{type:"boolean",rebuild:!0},smoothSheet:{type:"boolean",rebuild:!0}},Ya.prototype.parameters),init:function(t){var e=t||{};e.colorScheme=d(e.colorScheme,"chainname"),e.colorScale=d(e.colorScale,"RdYlBu"),e.radius=d(e.radius,"sstruc"),e.scale=d(e.scale,.7),this.aspectRatio=d(e.aspectRatio,5),this.tension=d(e.tension,NaN),this.capped=d(e.capped,!0),this.smoothSheet=d(e.smoothSheet,!1),Ya.prototype.init.call(this,e),"low"===e.quality?(this.subdiv=3,this.radialSegments=6):"medium"===e.quality?this.subdiv=6:"high"===e.quality?this.subdiv=12:this.subdiv=d(e.subdiv,6)},getSplineParams:function(t){return Object.assign({subdiv:this.subdiv,tension:this.tension,directional:1!==this.aspectRatio,smoothSheet:this.smoothSheet},t)},getSpline:function(t){return new Ms(t,this.getSplineParams())},getScale:function(t){return t.isCg()?this.scale*this.aspectRatio:this.scale},getAspectRatio:function(t){return t.isCg()?1:this.aspectRatio},createData:function(t){var e=[],i=[];return this.structure.eachPolymer(function(t){if(!(t.residueCount<4)){i.push(t);var n=this.getSpline(t),r=n.getSubdividedPosition(),o=n.getSubdividedOrientation(),a=n.getSubdividedColor(this.getColorParams()),s=n.getSubdividedSize(this.radius,this.getScale(t));e.push(new Cs(r.position,o.normal,o.binormal,o.tangent,a.color,s.size,a.pickingColor,this.getBufferParams({radialSegments:this.radialSegments,aspectRatio:this.getAspectRatio(t),capped:this.capped,dullInterior:!0})))}}.bind(this),t.getSelection()),{bufferList:e,polymerList:i}},updateData:function(e,i){t.Debug&&uv.time(this.type+" repr update"),e=e||{};for(var n=0,r=i.polymerList.length;n<r;++n){var o={},a=i.polymerList[n],s=this.getSpline(a);if(i.bufferList[n].aspectRatio=this.getAspectRatio(a),e.position||e.radius){var c=s.getSubdividedPosition(),u=s.getSubdividedOrientation(),h=s.getSubdividedSize(this.radius,this.getScale(a));o.position=c.position,o.normal=u.normal,o.binormal=u.binormal,o.tangent=u.tangent,o.size=h.size}if(e.color){var l=s.getSubdividedColor(this.getColorParams());o.color=l.color,o.pickingColor=l.pickingColor}i.bufferList[n].setAttributes(o)}t.Debug&&uv.timeEnd(this.type+" repr update")},setParameters:function(t){var e=!1,i={};return t&&t.aspectRatio&&(i.radius=!0),t&&t.tension&&(i.position=!0),Ya.prototype.setParameters.call(this,t,i,e),this}}),pv.add("cartoon",Ps),Ts.prototype={within:function(t,e){uv.time("Contact within");var i=this.kdtree2,n=this.sview1.getAtomProxy(),r=this.sview1.getAtomSet(!1),o=new wo;this.sview1.eachAtom(function(a){for(var s=!1,c=i.nearest(a,1/0,t),u=0,h=c.length;u<h;++u){var l=c[u];n.index=l.index,a.residueIndex!==n.residueIndex&&(!e||l.distance>e)&&(s=!0,r.add_unsafe(n.index),o.addBond(a,n,1))}s&&r.add_unsafe(a.index)});var a=new Ov(o.count);return a.set_all(!0),uv.timeEnd("Contact within"),{atomSet:r,bondSet:a,bondStore:o}}},Ls.prototype=Object.assign(Object.create(Ya.prototype),{constructor:Ls,type:"contact",defaultSize:.25,parameters:Object.assign({contactType:{type:"select",rebuild:!0,options:{polar:"polar",polarBackbone:"polar backbone"}},maxDistance:{type:"number",precision:1,max:10,min:.1,rebuild:!0},maxAngle:{type:"integer",max:180,min:0,rebuild:!0},radialSegments:!0,disableImpostor:!0},Ya.prototype.parameters),init:function(t){var e=t||{};e.radius=d(e.radius,this.defaultSize),this.contactType=d(e.contactType,"polarBackbone"),this.maxDistance=d(e.maxDistance,3.5),this.maxAngle=d(e.maxAngle,40),Ya.prototype.init.call(this,e)},getContactData:function(t){var e={polar:Es,polarBackbone:Is},i=e[this.contactType](t,this.maxDistance,this.maxAngle);return i},getBondData:function(t,e,i){return t.getBondData(this.getBondParams(e,i))},createData:function(t){var e=this.getContactData(t),i={bondSet:e.bondSet,bondStore:e.bondStore},n=this.getBondData(t,void 0,i),r=new Da(n.position1,n.position2,n.color1,n.color2,n.radius,n.pickingColor1,n.pickingColor2,this.getBufferParams({openEnded:!1,radialSegments:this.radialSegments,disableImpostor:this.disableImpostor,dullInterior:!0}));return{bufferList:[r],bondSet:e.bondSet,bondStore:e.bondStore}},updateData:function(t,e){if(!t||t.position){var i=this.getContactData(e.sview);e.bondSet=i.bondSet,e.bondStore=i.bondStore}var n={bondSet:e.bondSet,bondStore:e.bondStore},r=this.getBondData(e.sview,t,n),o={};t&&!t.position||(o.position=vr(r.position1,r.position2),o.position1=r.position1,o.position2=r.position2),t&&!t.color||(o.color=r.color1,o.color2=r.color2),t&&!t.radius||(o.radius=r.radius),e.bufferList[0].setAttributes(o)}}),pv.add("contact",Ls),gv.add("shader/SDFFont.vert","uniform float nearClip;\nuniform float clipRadius;\nuniform vec3 clipCenter;\nuniform float xOffset;\nuniform float yOffset;\nuniform float zOffset;\nuniform bool ortho;\nvarying vec3 vViewPosition;\nvarying vec2 texCoord;\n#if defined( RADIUS_CLIP )\nvarying vec3 vClipCenter;\n#endif\nattribute vec2 mapping;\nattribute vec2 inputTexCoord;\nattribute float inputSize;\n#include color_pars_vertex\n#include common\nvoid main(void){\n#include color_vertex\ntexCoord = inputTexCoord;\nfloat _zOffset = zOffset;\nif( texCoord.x == 10.0 ){\n_zOffset -= 0.001;\n}\nvec3 pos = position;\nif( ortho ){\npos += normalize( cameraPosition ) * _zOffset;\n}\nvec4 cameraPos = modelViewMatrix * vec4( pos, 1.0 );\nvec4 cameraCornerPos = vec4( cameraPos.xyz, 1.0 );\ncameraCornerPos.xy += mapping * inputSize * 0.01;\ncameraCornerPos.x += xOffset;\ncameraCornerPos.y += yOffset;\nif( !ortho ){\ncameraCornerPos.xyz += normalize( -cameraCornerPos.xyz ) * _zOffset;\n}\ngl_Position = projectionMatrix * cameraCornerPos;\nvViewPosition = -cameraCornerPos.xyz;\n#if defined( RADIUS_CLIP )\nvClipCenter = -( modelViewMatrix * vec4( clipCenter, 1.0 ) ).xyz;\n#endif\n#include nearclip_vertex\n#include radiusclip_vertex\n}"),gv.add("shader/SDFFont.frag","uniform sampler2D fontTexture;\nuniform float opacity;\nuniform bool showBorder;\nuniform vec3 borderColor;\nuniform float borderWidth;\nuniform vec3 backgroundColor;\nuniform float backgroundOpacity;\nuniform float nearClip;\nuniform float clipRadius;\nvarying vec3 vViewPosition;\nvarying vec2 texCoord;\n#if defined( RADIUS_CLIP )\nvarying vec3 vClipCenter;\n#endif\n#include common\n#include color_pars_fragment\n#include fog_pars_fragment\n#ifdef SDF\nconst float smoothness = 16.0;\n#else\nconst float smoothness = 256.0;\n#endif\nconst float gamma = 2.2;\nvoid main(){\n#include nearclip_fragment\n#include radiusclip_fragment\nif( texCoord.x > 1.0 ){\ngl_FragColor = vec4( backgroundColor, backgroundOpacity );\n}else{\nfloat sdf = texture2D( fontTexture, texCoord ).a;\nif( showBorder ) sdf += borderWidth;\nfloat w = clamp(\nsmoothness * ( abs( dFdx( texCoord.x ) ) + abs( dFdy( texCoord.y ) ) ),\n0.0,\n0.5\n);\nfloat a = smoothstep( 0.5 - w, 0.5 + w, sdf );\na = pow( a, 1.0 / gamma );\nif( a < 0.2 ) discard;\na *= opacity;\nvec3 outgoingLight = vColor;\nif( showBorder && sdf < ( 0.5 + borderWidth ) ){\noutgoingLight = borderColor;\n}\ngl_FragColor = vec4( outgoingLight, a );\n}\n#include premultiplied_alpha_fragment\n#include tonemapping_fragment\n#include encodings_fragment\n#include fog_fragment\n}");var Gv=function(){var t={};return function(e){var i=JSON.stringify(e);return void 0===t[i]&&(t[i]=new Rs(e)),t[i]}}();Rs.prototype={constructor:Rs,build:function(){var t=this.size+2*this.outline+Math.round(this.size/4),e=this.width/4,i=document.createElement("canvas");i.width=e,i.height=t;var n=i.getContext("2d");n.font=this.style+" "+this.variant+" "+this.weight+" "+this.size+"px "+this.font,n.fillStyle="#FF0000",n.textAlign="left",n.textBaseline="bottom",n.lineJoin="round";for(var r=[],o=3*this.outline,a=0;a<o;++a){var s=Math.max(0,8*-a+128-8*!a),c=("00"+s.toString(16)).slice(-2);r.push("#"+c+c+c)}var u=new Uint8Array(e*t*2);this.canvas=i,this.context=n,this.lineHeight=t,this.maxWidth=e,this.colors=r,this.scratch=u,this.data=new Uint8Array(this.width*this.height*4),this.canvas2=document.createElement("canvas"),this.canvas2.width=this.width,this.canvas2.height=this.height,this.context2=this.canvas2.getContext("2d")},map:function(t){return void 0===this.mapped[t]&&(this.draw(t),this.currentX+this.scratchW>this.width&&(this.currentX=0,this.currentY+=this.scratchH),this.currentY+this.scratchH>this.height&&console.warn("canvas to small"),this.mapped[t]={x:this.currentX,y:this.currentY,w:this.scratchW,h:this.scratchH},this.context2.drawImage(this.canvas,0,0,this.scratchW,this.scratchH,this.currentX,this.currentY,this.scratchW,this.scratchH),this.currentX+=this.scratchW),this.mapped[t]},draw:function(t){var e=this.lineHeight,i=this.outline,n=this.context,r=this.scratch,o=this.maxWidth,a=this.colors,s=i,c=e-this.outline,u=n.measureText(t),h=Math.min(o,Math.ceil(u.width+2*s+1));n.clearRect(0,0,h,e);var l,d,f,p,m;if(0===this.outline)for(n.fillText(t,s,c),p=n.getImageData(0,0,h,e),m=p.data,f=3,l=0,d=m.length/4;l<d;++l)r[l]=m[f],f+=4;else{for(n.globalCompositeOperation="source-over",l=i+1;l>0;--l)f=l>1?2*l-2:l,n.strokeStyle=a[f-1],n.lineWidth=f,n.strokeText(t,s,c);n.globalCompositeOperation="multiply",n.fillStyle="#FF00FF",n.fillText(t,s,c),p=n.getImageData(0,0,h,e),m=p.data,f=0;var g=this.gamma;for(l=0,d=m.length/4;l<d;++l){var v=m[f],y=v?m[f+1]/v:1;.5===g&&(y=Math.sqrt(y)),y=Math.min(1,Math.max(0,y));var b=256-v,x=b+(v-b)*y;r[l]=Math.max(0,Math.min(255,x+2)),m[f+3]=r[l],f+=4}}n.putImageData(p,0,0),this.scratchW=h,this.scratchH=e},populate:function(){for(var t=0;t<256;++t)this.map(String.fromCharCode(t))}},Os.prototype=Object.assign(Object.create(Ca.prototype),{constructor:Os,type:"text",parameters:Object.assign({fontFamily:{uniform:!0},fontStyle:{uniform:!0},fontWeight:{uniform:!0},fontSize:{uniform:!0},sdf:{updateShader:!0,uniform:!0},xOffset:{uniform:!0},yOffset:{uniform:!0},zOffset:{uniform:!0},showBorder:{uniform:!0},borderColor:{uniform:!0},borderWidth:{uniform:!0},backgroundColor:{uniform:!0},backgroundOpacity:{uniform:!0}},ya.prototype.parameters),makeMaterial:function(){ya.prototype.makeMaterial.call(this);var t=this.texture,e=this.material;e.extensions.derivatives=!0,e.lights=!1,e.uniforms.fontTexture.value=t,e.needsUpdate=!0;var i=this.wireframeMaterial;i.extensions.derivatives=!0,i.lights=!1,i.uniforms.fontTexture.value=t,i.needsUpdate=!0;var n=this.pickingMaterial;n.extensions.derivatives=!0,n.lights=!1,n.uniforms.fontTexture.value=t,n.needsUpdate=!0},setAttributes:function(t){var e,i,n,r,o,a,s=this.text,c=this.geometry.attributes;t.position&&(e=t.position,r=c.position.array,c.position.needsUpdate=!0),t.size&&(i=t.size,o=c.inputSize.array,c.inputSize.needsUpdate=!0),t.color&&(n=t.color,a=c.color.array,c.color.needsUpdate=!0);for(var u,h,l,d,f,p=this.positionCount,m=0,g=0;g<p;++g)for(h=3*g,l=s[g],f=l.length,this.showBackground&&(f+=1),d=0;d<f;++d,++m)for(var v=0;v<4;v++)u=4*m*3+3*v,e&&(r[u]=e[h],r[u+1]=e[h+1],r[u+2]=e[h+2]),i&&(o[4*m+v]=i[g]),n&&(a[u]=n[h],a[u+1]=n[h+1],a[u+2]=n[h+2])},makeTexture:function(){this.textAtlas=Gv({font:[this.fontFamily],style:this.fontStyle,weight:this.fontWeight,size:this.fontSize,outline:this.sdf?5:0}),this.texture=this.textAtlas.texture},makeMapping:function(){for(var t,e,i,n,r,o,a,s,c=this.textAtlas,u=this.text,h=this.attachment,l=c.lineHeight*this.backgroundMargin*.1-10,d=this.geometry.attributes.inputTexCoord.array,f=this.geometry.attributes.mapping.array,p=this.positionCount,m=0,g=0;g<p;++g){for(i=u[g],n=0,o=i.length,r=0;r<o;++r)t=c.mapped[i[r]],n+=t.w-2*c.outline;for(s=h.startsWith("top")?c.lineHeight/1.25:h.startsWith("middle")?c.lineHeight/2.5:0,a=h.endsWith("right")?n:h.endsWith("center")?n/2:0,a+=c.outline,s+=c.outline,this.showBackground&&(e=2*m*4,f[e+0]=-c.lineHeight/6-a-l,f[e+1]=c.lineHeight-s+l,f[e+2]=-c.lineHeight/6-a-l,f[e+3]=0-s-l,f[e+4]=n+c.lineHeight/6-a+2*c.outline+l,f[e+5]=c.lineHeight-s+l,f[e+6]=n+c.lineHeight/6-a+2*c.outline+l,f[e+7]=0-s-l,d[e+0]=10,d[e+2]=10,d[e+4]=10,d[e+6]=10,m+=1),n=0,r=0;r<o;++r,++m){t=c.mapped[i[r]],e=2*m*4,f[e+0]=n-a,f[e+1]=t.h-s,f[e+2]=n-a,f[e+3]=0-s,f[e+4]=n+t.w-a,f[e+5]=t.h-s,f[e+6]=n+t.w-a,f[e+7]=0-s;var v=c.width,y=c.height,b=[t.x/v,t.y/y,t.x/v,(t.y+t.h)/y,(t.x+t.w)/v,t.y/y,(t.x+t.w)/v,(t.y+t.h)/y];d.set(b,e),n+=t.w-2*c.outline}}this.geometry.attributes.inputTexCoord.needsUpdate=!0,this.geometry.attributes.mapping.needsUpdate=!0},getDefines:function(t){var e=ya.prototype.getDefines.call(this,t);return this.sdf&&(e.SDF=1),e},setUniforms:function(t){!t||void 0===t.fontFamily&&void 0===t.fontStyle&&void 0===t.fontWeight&&void 0===t.fontSize&&void 0===t.sdf||(this.makeTexture(),this.makeMapping(),this.texture.needsUpdate=!0,t.fontTexture=this.texture),ya.prototype.setUniforms.call(this,t)}}),Ds.prototype=Object.assign(Object.create(Ya.prototype),{constructor:Ds,type:"distance",defaultSize:.15,parameters:Object.assign({labelSize:{type:"number",precision:3,max:10,min:.001},labelColor:{type:"color"},labelVisible:{type:"boolean"},labelZOffset:{type:"number",precision:1,max:20,min:-20,buffer:"zOffset"},atomPair:{type:"hidden",rebuild:!0},radialSegments:!0,disableImpostor:!0},Ya.prototype.parameters,{flatShaded:null,assembly:null}),init:function(t){var e=t||{};e.radius=d(e.radius,this.defaultSize),this.fontFamily=d(e.fontFamily,"sans-serif"),this.fontStyle=d(e.fontStyle,"normal"),this.fontWeight=d(e.fontWeight,"bold"),this.sdf=d(e.sdf,"Firefox"!==ov),this.labelSize=d(e.labelSize,2),this.labelColor=d(e.labelColor,16777215),this.labelVisible=d(e.labelVisible,!0),this.labelZOffset=d(e.labelZOffset,.5),this.atomPair=d(e.atomPair,[]),Ya.prototype.init.call(this,e)},getDistanceData:function(t,e){var i=e.length,n=new Array(i),r=new Float32Array(3*i),o=new _n,a=new _n,s=new wo,c=t.getAtomProxy(),u=t.getAtomProxy(),h=0;e.forEach(function(e,i){var l=e[0],d=e[1];if(Number.isInteger(l)&&Number.isInteger(d))c.index=l,u.index=d;else{o.setString(l),a.setString(d);var f=t.getAtomIndices(o),p=t.getAtomIndices(a);if(!f.length||!p.length)return void(h+=1);c.index=f[0],u.index=p[0]}s.addBond(c,u,1),i-=h,n[i]=c.distanceTo(u).toFixed(2);var m=3*i;r[m+0]=(c.x+u.x)/2,r[m+1]=(c.y+u.y)/2,r[m+2]=(c.z+u.z)/2},this),h>0&&(i-=h,r=r.subarray(0,3*i));var l=new Ov(s.count);return l.set_all(!0),{text:n,position:r,bondSet:l,bondStore:s}},getBondData:function(t,e,i){return t.getBondData(this.getBondParams(e,i))},create:function(){if(0!==this.structureView.atomCount){var t=this.atomPair.length;if(0!==t){var e=this.getDistanceData(this.structureView,this.atomPair),i=new Pt(this.labelColor);this.textBuffer=new Os(e.position,yr(t,this.labelSize),br(t,i.r,i.g,i.b),e.text,this.getBufferParams({fontFamily:this.fontFamily,fontStyle:this.fontStyle,fontWeight:this.fontWeight,sdf:this.sdf,zOffset:this.labelZOffset,opacity:1,visible:this.labelVisible}));var n={bondSet:e.bondSet,bondStore:e.bondStore},r=this.getBondData(this.structureView,void 0,n);this.cylinderBuffer=new Da(r.position1,r.position2,r.color1,r.color2,r.radius,void 0,void 0,this.getBufferParams({openEnded:!1,radialSegments:this.radialSegments,disableImpostor:this.disableImpostor,dullInterior:!0})),this.dataList.push({sview:this.structureView,bondSet:e.bondSet,bondStore:e.bondStore,position:e.position,bufferList:[this.textBuffer,this.cylinderBuffer]})}}},update:function(t){t.position?this.build():Ya.prototype.update.call(this,t)},updateData:function(t,e){var i={bondSet:e.bondSet,bondStore:e.bondStore},n=this.getBondData(e.sview,t,i),r={},o={},a=this.atomPair.length;if(t.labelSize&&(o.size=yr(a,this.labelSize)),t.labelColor){var s=new Pt(this.labelColor);o.color=br(a,s.r,s.g,s.b)}t.color&&(r.color=n.color1,r.color2=n.color2),(t.radius||t.scale)&&(r.radius=n.radius),this.textBuffer.setAttributes(o),this.cylinderBuffer.setAttributes(r)},setVisibility:function(t,e){return Ya.prototype.setVisibility.call(this,t,!0),this.textBuffer&&this.textBuffer.setVisibility(this.labelVisible&&this.visible),e||this.viewer.requestRender(),this},setParameters:function(t){var e=!1,i={};return t&&t.labelSize&&(i.labelSize=!0),t&&t.labelColor&&(i.labelColor=!0),Ya.prototype.setParameters.call(this,t,i,e),t&&void 0!==t.labelVisible&&this.setVisibility(this.visible),this}}),pv.add("distance",Ds),Ns.prototype=Object.assign(Object.create(ya.prototype),{constructor:Ns,setAttributes:function(t){var e,i,n,r=this.geometry.attributes;t.position&&t.vector&&(e=t.position,i=t.vector,n=r.position.array,r.position.needsUpdate=!0);var o,a,s=this.size,c=this.scale;if(t.position&&t.vector)for(var u=0;u<s;u++)o=2*u*3,a=3*u,n[o+0]=e[a+0],n[o+1]=e[a+1],n[o+2]=e[a+2],n[o+3]=e[a+0]+i[a+0]*c,n[o+4]=e[a+1]+i[a+1]*c,n[o+5]=e[a+2]+i[a+2]*c}}),ks.prototype=Object.assign(Object.create(Ya.prototype),{constructor:ks,type:"helixorient",parameters:Object.assign({sphereDetail:!0,disableImpostor:!0},Ya.prototype.parameters),init:function(t){var e=t||{};e.colorScheme=d(e.colorScheme,"sstruc"),e.radius=d(e.radius,.15),e.scale=d(e.scale,1),Ya.prototype.init.call(this,e)},createData:function(t){var e=[],i=[];return this.structure.eachPolymer(function(t){if(!(t.residueCount<4)){i.push(t);var n=new Po(t),r=n.getPosition(),o=n.getColor(this.getColorParams()),a=n.getSize(this.radius,this.scale);e.push(new Ta(r.center,o.color,a.size,o.pickingColor,this.getBufferParams({sphereDetail:this.sphereDetail,disableImpostor:this.disableImpostor,dullInterior:!0})),new Ns(r.center,r.axis,this.getBufferParams({color:"skyblue",scale:1})),new Ns(r.center,r.resdir,this.getBufferParams({color:"lightgreen",scale:1})))}}.bind(this),t.getSelection()),{bufferList:e,polymerList:i}},updateData:function(e,i){t.Debug&&uv.time(this.type+" repr update"),e=e||{};for(var n=0,r=i.polymerList.length;n<r;++n){var o=3*n,a={},s=i.polymerList[n],c=new Po(s);if(e.position){var u=c.getPosition();a.position=u.center,i.bufferList[o+1].setAttributes({position:u.center,vector:u.axis}),i.bufferList[o+2].setAttributes({position:u.center,vector:u.resdir})}i.bufferList[o].setAttributes(a)}t.Debug&&uv.timeEnd(this.type+" repr update")}}),pv.add("helixorient",ks),Fs.prototype=Object.assign(Object.create(_s.prototype),{constructor:Fs,type:"licorice",parameters:Object.assign({},_s.prototype.parameters,{aspectRatio:null}),init:function(t){var e=t||{};e.aspectRatio=1,_s.prototype.init.call(this,e)}}),pv.add("licorice",Fs),gv.add("shader/HyperballStickImpostor.vert","\nattribute vec3 mapping;\nattribute float radius;\nattribute float radius2;\nattribute vec3 position1;\nattribute vec3 position2;\nvarying mat4 matrix_near;\nvarying vec4 prime1;\nvarying vec4 prime2;\nvarying float vRadius;\nvarying float vRadius2;\n#ifdef PICKING\nattribute vec3 pickingColor;\nattribute vec3 pickingColor2;\nvarying vec3 vPickingColor;\nvarying vec3 vPickingColor2;\n#else\nattribute vec3 color2;\nvarying vec3 vColor1;\nvarying vec3 vColor2;\n#endif\nuniform float shrink;\nuniform mat4 modelViewProjectionMatrix;\nuniform mat4 modelViewProjectionMatrixInverse;\nvoid main(){\nvRadius = radius;\nvRadius2 = radius2;\nvec4 spaceposition;\nvec3 position_atom1;\nvec3 position_atom2;\nvec4 vertex_position;\n#ifdef PICKING\nvPickingColor = pickingColor;\nvPickingColor2 = pickingColor2;\n#else\nvColor1 = color;\nvColor2 = color2;\n#endif\nfloat radius1 = radius;\nposition_atom1 = position1;\nposition_atom2 = position2;\nfloat distance = distance( position_atom1, position_atom2 );\nspaceposition.z = mapping.z * distance;\nif (radius1 > radius2) {\nspaceposition.y = mapping.y * 1.5 * radius1;\nspaceposition.x = mapping.x * 1.5 * radius1;\n} else {\nspaceposition.y = mapping.y * 1.5 * radius2;\nspaceposition.x = mapping.x * 1.5 * radius2;\n}\nspaceposition.w = 1.0;\nvec4 e3 = vec4( 1.0 );\nvec3 e1, e1_temp, e2, e2_temp;\ne3.xyz = normalize(position_atom1-position_atom2);\nif (e3.z == 0.0) { e3.z = 0.0000000000001;}\nif ( (position_atom1.x - position_atom2.x) == 0.0) { position_atom1.x += 0.001;}\nif ( (position_atom1.y - position_atom2.y) == 0.0) { position_atom1.y += 0.001;}\nif ( (position_atom1.z - position_atom2.z) == 0.0) { position_atom1.z += 0.001;}\nvec4 focus = vec4( 1.0 );\nfocus.x = ( position_atom1.x*position_atom1.x - position_atom2.x*position_atom2.x +\n( radius2*radius2 - radius1*radius1 )*e3.x*e3.x/shrink )/(2.0*(position_atom1.x - position_atom2.x));\nfocus.y = ( position_atom1.y*position_atom1.y - position_atom2.y*position_atom2.y +\n( radius2*radius2 - radius1*radius1 )*e3.y*e3.y/shrink )/(2.0*(position_atom1.y - position_atom2.y));\nfocus.z = ( position_atom1.z*position_atom1.z - position_atom2.z*position_atom2.z +\n( radius2*radius2 - radius1*radius1 )*e3.z*e3.z/shrink )/(2.0*(position_atom1.z - position_atom2.z));\ne1.x = 1.0;\ne1.y = 1.0;\ne1.z = ( (e3.x*focus.x + e3.y*focus.y + e3.z*focus.z) - e1.x*e3.x - e1.y*e3.y)/e3.z;\ne1_temp = e1 - focus.xyz;\ne1 = normalize(e1_temp);\ne2_temp = e1.yzx * e3.zxy - e1.zxy * e3.yzx;\ne2 = normalize(e2_temp);\nmat3 R= mat3( e1.xyz, e2.xyz, e3.xyz );\nvertex_position.xyz = R * spaceposition.xyz;\nvertex_position.w = 1.0;\nvertex_position.x += (position_atom1.x+position_atom2.x) / 2.0;\nvertex_position.y += (position_atom1.y+position_atom2.y) / 2.0;\nvertex_position.z += (position_atom1.z+position_atom2.z) / 2.0;\ngl_Position = modelViewProjectionMatrix * vertex_position;\nvec4 i_near, i_far;\nvec4 near = gl_Position;\nnear.z = 0.0 ;\nnear = modelViewProjectionMatrixInverse * near;\ni_near = near;\nvec4 far = gl_Position;\nfar.z = far.w ;\ni_far = modelViewProjectionMatrixInverse * far;\nprime1 = vec4( position_atom1 - (position_atom1 - focus.xyz)*shrink, 1.0 );\nprime2 = vec4( position_atom2 - (position_atom2 - focus.xyz)*shrink, 1.0 );\nfloat Rsquare = (radius1*radius1/shrink) - (\n(position_atom1.x - focus.x)*(position_atom1.x - focus.x) +\n(position_atom1.y - focus.y)*(position_atom1.y - focus.y) +\n(position_atom1.z - focus.z)*(position_atom1.z - focus.z)\n);\nfocus.w = Rsquare;\nmatrix_near = mat4( i_near, i_far, focus, e3 );\ngl_Position.z = 1.0;\n}"),gv.add("shader/HyperballStickImpostor.frag","#define STANDARD\n#define IMPOSTOR\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float roughness;\nuniform float metalness;\nuniform float opacity;\nuniform float nearClip;\nuniform float shrink;\nuniform mat4 modelViewMatrix;\nuniform mat4 modelViewProjectionMatrix;\nuniform mat4 modelViewMatrixInverseTranspose;\nuniform mat4 projectionMatrix;\nvarying mat4 matrix_near;\nvarying vec4 prime1;\nvarying vec4 prime2;\nvarying float vRadius;\nvarying float vRadius2;\n#ifdef PICKING\nuniform float objectId;\nvarying vec3 vPickingColor;\nvarying vec3 vPickingColor2;\n#else\nvarying vec3 vColor1;\nvarying vec3 vColor2;\n#include common\n#include fog_pars_fragment\n#include bsdfs\n#include lights_pars\n#include lights_physical_pars_fragment\n#endif\nbool interior = false;\nfloat calcClip( vec4 cameraPos ){\nreturn dot( cameraPos, vec4( 0.0, 0.0, 1.0, nearClip - 0.5 ) );\n}\nfloat calcClip( vec3 cameraPos ){\nreturn calcClip( vec4( cameraPos, 1.0 ) );\n}\nfloat calcDepth( in vec3 cameraPos ){\nvec2 clipZW = cameraPos.z * projectionMatrix[2].zw + projectionMatrix[3].zw;\nreturn 0.5 + 0.5 * clipZW.x / clipZW.y;\n}\nstruct Ray {\nvec3 origin ;\nvec3 direction ;\n};\nbool cutoff_plane (vec3 M, vec3 cutoff, vec3 x3){\nfloat a = x3.x;\nfloat b = x3.y;\nfloat c = x3.z;\nfloat d = -x3.x*cutoff.x-x3.y*cutoff.y-x3.z*cutoff.z;\nfloat l = a*M.x+b*M.y+c*M.z+d;\nif (l<0.0) {return true;}\nelse{return false;}\n}\nvec3 isect_surf(Ray r, mat4 matrix_coef){\nvec4 direction = vec4(r.direction, 0.0);\nvec4 origin = vec4(r.origin, 1.0);\nfloat a = dot(direction,(matrix_coef*direction));\nfloat b = dot(origin,(matrix_coef*direction));\nfloat c = dot(origin,(matrix_coef*origin));\nfloat delta =b*b-a*c;\ngl_FragColor.a = 1.0;\nif (delta<0.0){\ndiscard;\n}\nfloat t1 =(-b-sqrt(delta))/a;\nreturn r.origin+t1*r.direction;\n}\nvec3 isect_surf2(Ray r, mat4 matrix_coef){\nvec4 direction = vec4(r.direction, 0.0);\nvec4 origin = vec4(r.origin, 1.0);\nfloat a = dot(direction,(matrix_coef*direction));\nfloat b = dot(origin,(matrix_coef*direction));\nfloat c = dot(origin,(matrix_coef*origin));\nfloat delta =b*b-a*c;\ngl_FragColor.a = 1.0;\nif (delta<0.0){\ndiscard;\n}\nfloat t2 =(-b+sqrt(delta))/a;\nreturn r.origin+t2*r.direction;\n}\nRay primary_ray(vec4 near1, vec4 far1){\nvec3 near=near1.xyz/near1.w;\nvec3 far=far1.xyz/far1.w;\nreturn Ray(near,far-near);\n}\nfloat update_z_buffer(vec3 M, mat4 ModelViewP){\nfloat depth1;\nvec4 Ms=(ModelViewP*vec4(M,1.0));\nreturn depth1=(1.0+Ms.z/Ms.w)/2.0;\n}\nvoid main(){\nfloat radius = max( vRadius, vRadius2 );\nvec4 i_near, i_far, focus;\nvec3 e3, e1, e1_temp, e2;\ni_near = vec4(matrix_near[0][0],matrix_near[0][1],matrix_near[0][2],matrix_near[0][3]);\ni_far = vec4(matrix_near[1][0],matrix_near[1][1],matrix_near[1][2],matrix_near[1][3]);\nfocus = vec4(matrix_near[2][0],matrix_near[2][1],matrix_near[2][2],matrix_near[2][3]);\ne3 = vec3(matrix_near[3][0],matrix_near[3][1],matrix_near[3][2]);\ne1.x = 1.0;\ne1.y = 1.0;\ne1.z = ( (e3.x*focus.x + e3.y*focus.y + e3.z*focus.z) - e1.x*e3.x - e1.y*e3.y)/e3.z;\ne1_temp = e1 - focus.xyz;\ne1 = normalize(e1_temp);\ne2 = normalize(cross(e1,e3));\nvec4 equation = focus;\nfloat shrinkfactor = shrink;\nfloat t1 = -1.0/(1.0-shrinkfactor);\nfloat t2 = 1.0/(shrinkfactor);\nvec4 colonne1, colonne2, colonne3, colonne4;\nmat4 mat;\nvec3 equation1 = vec3(t2,t2,t1);\nfloat A1 = - e1.x*equation.x - e1.y*equation.y - e1.z*equation.z;\nfloat A2 = - e2.x*equation.x - e2.y*equation.y - e2.z*equation.z;\nfloat A3 = - e3.x*equation.x - e3.y*equation.y - e3.z*equation.z;\nfloat A11 = equation1.x*e1.x*e1.x + equation1.y*e2.x*e2.x + equation1.z*e3.x*e3.x;\nfloat A21 = equation1.x*e1.x*e1.y + equation1.y*e2.x*e2.y + equation1.z*e3.x*e3.y;\nfloat A31 = equation1.x*e1.x*e1.z + equation1.y*e2.x*e2.z + equation1.z*e3.x*e3.z;\nfloat A41 = equation1.x*e1.x*A1 + equation1.y*e2.x*A2 + equation1.z*e3.x*A3;\nfloat A22 = equation1.x*e1.y*e1.y + equation1.y*e2.y*e2.y + equation1.z*e3.y*e3.y;\nfloat A32 = equation1.x*e1.y*e1.z + equation1.y*e2.y*e2.z + equation1.z*e3.y*e3.z;\nfloat A42 = equation1.x*e1.y*A1 + equation1.y*e2.y*A2 + equation1.z*e3.y*A3;\nfloat A33 = equation1.x*e1.z*e1.z + equation1.y*e2.z*e2.z + equation1.z*e3.z*e3.z;\nfloat A43 = equation1.x*e1.z*A1 + equation1.y*e2.z*A2 + equation1.z*e3.z*A3;\nfloat A44 = equation1.x*A1*A1 + equation1.y*A2*A2 + equation1.z*A3*A3 - equation.w;\ncolonne1 = vec4(A11,A21,A31,A41);\ncolonne2 = vec4(A21,A22,A32,A42);\ncolonne3 = vec4(A31,A32,A33,A43);\ncolonne4 = vec4(A41,A42,A43,A44);\nmat = mat4(colonne1,colonne2,colonne3,colonne4);\nRay ray = primary_ray(i_near,i_far) ;\nvec3 M;\nM = isect_surf(ray, mat);\nif (cutoff_plane(M, prime1.xyz, -e3) || cutoff_plane(M, prime2.xyz, e3)){ discard; }\nvec4 M1 = vec4(M,1.0);\nvec4 M2 = mat*M1;\nvec3 _normal = ( modelViewMatrixInverseTranspose * M2 ).xyz;\ngl_FragDepthEXT = update_z_buffer(M, modelViewProjectionMatrix) ;\n#ifdef NEAR_CLIP\nif( calcClip( modelViewMatrix * vec4( M, 1.0 ) ) > 0.0 ){\nM = isect_surf2(ray, mat);\nif( calcClip( modelViewMatrix * vec4( M, 1.0 ) ) > 0.0 )\ndiscard;\ninterior = true;\ngl_FragDepthEXT = update_z_buffer(M, modelViewProjectionMatrix) ;\nif( gl_FragDepthEXT >= 0.0 ){\ngl_FragDepthEXT = max( 0.0, calcDepth( vec3( - ( nearClip - 0.5 ) ) ) + ( 0.0000001 / radius ) );\n}\n}else if( gl_FragDepthEXT <= 0.0 ){\nM = isect_surf2(ray, mat);\ninterior = true;\ngl_FragDepthEXT = update_z_buffer(M, modelViewProjectionMatrix);\nif( gl_FragDepthEXT >= 0.0 ){\ngl_FragDepthEXT = 0.0 + ( 0.0000001 / radius );\n}\n}\n#else\nif( gl_FragDepthEXT <= 0.0 ){\nM = isect_surf2(ray, mat);\ninterior = true;\ngl_FragDepthEXT = update_z_buffer(M, modelViewProjectionMatrix) ;\nif( gl_FragDepthEXT >= 0.0 ){\ngl_FragDepthEXT = 0.0 + ( 0.0000001 / radius );\n}\n}\n#endif\nif (cutoff_plane(M, prime1.xyz, -e3) || cutoff_plane(M, prime2.xyz, e3)){ discard; }\nif (gl_FragDepthEXT < 0.0)\ndiscard;\nif (gl_FragDepthEXT > 1.0)\ndiscard;\nfloat distance_ratio = ((M.x-prime2.x)*e3.x + (M.y-prime2.y)*e3.y +(M.z-prime2.z)*e3.z) /\ndistance(prime2.xyz,prime1.xyz);\n#ifdef PICKING\nif( distance_ratio > 0.5 ){\ngl_FragColor = vec4( vPickingColor, objectId );\n}else{\ngl_FragColor = vec4( vPickingColor2, objectId );\n}\n#else\nvec3 vViewPosition = -( modelViewMatrix * vec4( M, 1.0 ) ).xyz;\nvec3 vNormal = _normal;\nvec3 vColor;\nif( distance_ratio>0.5 ){\nvColor = vColor1;\n}else{\nvColor = vColor2;\n}\nvec4 diffuseColor = vec4( diffuse, opacity );\nReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\nvec3 totalEmissiveLight = emissive;\n#include color_fragment\n#include roughnessmap_fragment\n#include metalnessmap_fragment\nvec3 normal = normalize( vNormal );\nif( interior ){\nnormal = vec3( 0.0, 0.0, 0.4 );\n}\n#include lights_physical_fragment\n#include lights_template\nvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveLight;\ngl_FragColor = vec4( outgoingLight, diffuseColor.a );\n#include premultiplied_alpha_fragment\n#include tonemapping_fragment\n#include encodings_fragment\n#include fog_fragment\n#endif\n}"),
	zs.prototype=Object.assign(Object.create(Ma.prototype),{constructo:zs});var Hv=new O;Us.prototype=Object.assign(Object.create(zs.prototype),{constructor:Us,parameters:Object.assign({shrink:{uniform:!0}},zs.prototype.parameters)}),$s.prototype=Object.assign(Object.create(Fs.prototype),{constructor:$s,type:"hyperball",defaultSize:1,parameters:Object.assign({shrink:{type:"number",precision:3,max:1,min:.001,buffer:!0}},Fs.prototype.parameters,{multipleBond:null,bondSpacing:null}),init:function(t){var e=t||{};e.scale=d(e.scale,.2),e.radius=d(e.radius,"vdw"),this.shrink=d(e.shrink,.12),Fs.prototype.init.call(this,e)},getBondParams:function(t,e){return t&&!t.radius||(e=Object.assign({radius2:!0},e)),Fs.prototype.getBondParams.call(this,t,e)},createData:function(t){var e=t.getAtomData(this.getAtomParams()),i=t.getBondData(this.getBondParams()),n=new Ta(e.position,e.color,e.radius,e.pickingColor,this.getBufferParams({sphereDetail:this.sphereDetail,disableImpostor:this.disableImpostor,dullInterior:!0}));this.__center=new Float32Array(3*t.bondCount);var r=new js(i.position1,i.position2,i.color1,i.color2,i.radius1,i.radius2,i.pickingColor1,i.pickingColor2,this.getBufferParams({shrink:this.shrink,radialSegments:this.radialSegments,dullInterior:!0}),this.disableImpostor);return{bufferList:[n,r]}},updateData:function(t,e){var i=e.sview.getAtomData(this.getAtomParams()),n=e.sview.getBondData(this.getBondParams()),r={},o={};if(!t||t.position){r.position=i.position;var a=n.position1,s=n.position2;o.position=vr(a,s,this.__center),o.position1=a,o.position2=s}t&&!t.color||(r.color=i.color,o.color=n.color1,o.color2=n.color2),t&&!t.radius||(r.radius=i.radius,o.radius=n.radius1,o.radius2=n.radius2),e.bufferList[0].setAttributes(r),e.bufferList[1].setAttributes(o)}}),pv.add("hyperball",$s),Vs.prototype={constructor:Vs,atomLabel:function(t){var e,i=this.type;switch(i){case"atomname":e=t.atomname;break;case"atomindex":e=""+t.index;break;case"occupancy":e=t.occupancy.toFixed(2);break;case"bfactor":e=t.bfactor.toFixed(2);break;case"serial":e=""+t.serial;break;case"element":e=t.element;break;case"atom":e=t.atomname+"|"+t.index;break;case"resname":e=t.resname;break;case"resno":e=""+t.resno;break;case"res":var n=t.resname.toUpperCase();e=(gm[n]||n)+t.resno;break;case"text":e=this.text[t.index];break;default:e=t.qualifiedName()}return void 0===e?"":e}},Vs.types={"":"",atomname:"atom name",atomindex:"atom index",occupancy:"occupancy",bfactor:"b-factor",serial:"serial",element:"element",atom:"atom name + index",resname:"residue name",resno:"residue no",res:"residue name + no",text:"text",qualified:"qualified name"},Gs.prototype=Object.assign(Object.create(Ya.prototype),{constructor:Gs,type:"label",parameters:Object.assign({labelType:{type:"select",options:Vs.types,rebuild:!0},labelText:{type:"hidden",rebuild:!0},fontFamily:{type:"select",options:{"sans-serif":"sans-serif",monospace:"monospace",serif:"serif"},buffer:!0},fontStyle:{type:"select",options:{normal:"normal",italic:"italic"},buffer:!0},fontWeight:{type:"select",options:{normal:"normal",bold:"bold"},buffer:!0},sdf:{type:"boolean",buffer:!0},xOffset:{type:"number",precision:1,max:20,min:-20,buffer:!0},yOffset:{type:"number",precision:1,max:20,min:-20,buffer:!0},zOffset:{type:"number",precision:1,max:20,min:-20,buffer:!0},attachment:{type:"select",options:{"bottom-left":"bottom-left","bottom-center":"bottom-center","bottom-right":"bottom-right","middle-left":"middle-left","middle-center":"middle-center","middle-right":"middle-right","top-left":"top-left","top-center":"top-center","top-right":"top-right"},rebuild:!0},showBorder:{type:"boolean",buffer:!0},borderColor:{type:"color",buffer:!0},borderWidth:{type:"number",precision:2,max:.3,min:0,buffer:!0},showBackground:{type:"boolean",rebuild:!0},backgroundColor:{type:"color",buffer:!0},backgroundMargin:{type:"number",precision:2,max:2,min:0,rebuild:!0},backgroundOpacity:{type:"range",step:.01,max:1,min:0,buffer:!0}},Ya.prototype.parameters,{side:null,flatShaded:null,wireframe:null,linewidth:null,roughness:null,metalness:null,diffuse:null}),init:function(t){var e=t||{};this.labelType=d(e.labelType,"res"),this.labelText=d(e.labelText,{}),this.fontFamily=d(e.fontFamily,"sans-serif"),this.fontStyle=d(e.fontStyle,"normal"),this.fontWeight=d(e.fontWeight,"bold"),this.sdf=d(e.sdf,"Chrome"===ov),this.xOffset=d(e.xOffset,0),this.yOffset=d(e.yOffset,0),this.zOffset=d(e.zOffset,.5),this.attachment=d(e.attachment,"bottom-left"),this.showBorder=d(e.showBorder,!1),this.borderColor=d(e.borderColor,"lightgrey"),this.borderWidth=d(e.borderWidth,.15),this.showBackground=d(e.showBackground,!1),this.backgroundColor=d(e.backgroundColor,"lightgrey"),this.backgroundMargin=d(e.backgroundMargin,.5),this.backgroundOpacity=d(e.backgroundOpacity,1),Ya.prototype.init.call(this,e)},createData:function(t){var e={position:!0,color:!0,radius:!0},i=t.getAtomData(this.getAtomParams(e)),n=[],r=new Vs(this.labelType,this.labelText);t.eachAtom(function(t){n.push(r.atomLabel(t))});var o=new Os(i.position,i.radius,i.color,n,this.getBufferParams({fontFamily:this.fontFamily,fontStyle:this.fontStyle,fontWeight:this.fontWeight,sdf:this.sdf,xOffset:this.xOffset,yOffset:this.yOffset,zOffset:this.zOffset,attachment:this.attachment,showBorder:this.showBorder,borderColor:this.borderColor,borderWidth:this.borderWidth,showBackground:this.showBackground,backgroundColor:this.backgroundColor,backgroundMargin:this.backgroundMargin,backgroundOpacity:this.backgroundOpacity}));return{bufferList:[o]}},updateData:function(t,e){var i=e.sview.getAtomData(this.getAtomParams(t)),n={};t&&!t.position||(n.position=i.position),t&&!t.radius||(n.size=i.radius),t&&!t.color||(n.color=i.color),e.bufferList[0].setAttributes(n)}}),pv.add("label",Gs),Hs.prototype=Object.assign(Object.create(Ya.prototype),{constructor:Hs,type:"line",parameters:Object.assign({multipleBond:{type:"select",rebuild:!0,options:{off:"off",symmetric:"symmetric",offset:"offset"}},bondSpacing:{type:"number",precision:2,max:2,min:.5}},Ba.prototype.parameters,{flatShaded:null,side:null,wireframe:null,roughness:null,metalness:null,diffuse:null}),init:function(t){var e=t||{};this.multipleBond=d(e.multipleBond,"off"),this.bondSpacing=d(e.bondSpacing,1),Ya.prototype.init.call(this,e)},getBondParams:function(t,e){return e=Object.assign({multipleBond:this.multipleBond,bondSpacing:this.bondSpacing,radiusParams:{radius:.1,scale:1}},e),Ya.prototype.getBondParams.call(this,t,e)},createData:function(t){var e={position:!0,color:!0},i=t.getBondData(this.getBondParams(e)),n=new Za(i.position1,i.position2,i.color1,i.color2,this.getBufferParams());return{bufferList:[n]}},updateData:function(t,e){var i=e.sview.getBondData(this.getBondParams(t)),n={};t&&!t.position||(n.from=i.position1,n.to=i.position2),t&&!t.color||(n.color=i.color1,n.color2=i.color2),e.bufferList[0].setAttributes(n)},setParameters:function(t){var e=!1,i={};return t&&t.bondSpacing&&(i.position=!0),Ya.prototype.setParameters.call(this,t,i,e),this}}),pv.add("line",Hs),Xs.__deps=[la,ha,da,Or,Ws],Ys.__deps=[la,da,yr,Or,Vr,zr,Gr,qs,d],lv.add("molsurf",function(t,e){var i=t.data.args,n=t.data.params;if(i&&n){var r="av"===n.type?Ys:Xs,o=new r(i.coordList,i.radiusList,i.indexList),a=o.getSurface(n.type,n.probeRadius,n.scaleFactor,n.cutoff,!0,n.smooth),s=[a.position.buffer,a.index.buffer];a.normal&&s.push(a.normal.buffer),a.atomindex&&s.push(a.atomindex.buffer),e({sd:a,p:n},s)}},[Xs,Ys]),Zs.prototype={getAtomData:function(){return this.structure.getAtomData({what:{position:!0,radius:!0,index:!0},radiusParams:{radius:"vdw",scale:1}})},makeSurface:function(t,e){var i=new ia("","",t);return i.info.type=e.type,i.info.probeRadius=e.probeRadius,i.info.scaleFactor=e.scaleFactor,i.info.smooth=e.smooth,i.info.cutoff=e.cutoff,i},getSurface:function(t){var e=t||{},i=this.getAtomData(),n=i.position,r=i.radius,o=i.index,a="av"===e.type?Ys:Xs,s=new a(n,r,o),c=s.getSurface(e.type,e.probeRadius,e.scaleFactor,e.cutoff,!0,e.smooth);return this.makeSurface(c,e)},getSurfaceWorker:function(t,e){var i=Object.assign({},t);if(window.Worker){void 0===this.worker&&(this.worker=new na("molsurf"));var n=this.getAtomData(),r=n.position,o=n.radius,a=n.index,s={args:{coordList:r,radiusList:o,indexList:a},params:i},c=[r.buffer,o.buffer,a.buffer];this.worker.post(s,c,function(t){var n=t.data.sd;e(this.makeSurface(n,i))}.bind(this),function(t){console.warn("MolecularSurface.getSurfaceWorker error - trying without worker",t),this.worker.terminate(),this.worker=void 0;var n=this.getSurface(i);e(n)}.bind(this))}else{var u=this.getSurface(i);e(u)}},dispose:function(){this.worker&&this.worker.terminate()}},Ks.prototype=Object.assign(Object.create(Ya.prototype),{constructor:Ks,type:"surface",parameters:Object.assign({surfaceType:{type:"select",rebuild:!0,options:{vws:"vws",sas:"sas",ms:"ms",ses:"ses",av:"av"}},probeRadius:{type:"number",precision:1,max:20,min:0,rebuild:!0},smooth:{type:"integer",precision:1,max:10,min:0,rebuild:!0},scaleFactor:{type:"number",precision:1,max:5,min:0,rebuild:!0},cutoff:{type:"number",precision:2,max:50,min:0,rebuild:!0},background:{type:"boolean",rebuild:!0},opaqueBack:{type:"boolean",buffer:!0},filterSele:{type:"text",rebuild:!0},volume:{type:"hidden"},useWorker:{type:"boolean",rebuild:!0}},Ya.prototype.parameters,{radiusType:null,radius:null,scale:null}),init:function(t){var e=t||{};e.colorScheme=d(e.colorScheme,"uniform"),e.colorValue=d(e.colorValue,14540253),this.surfaceType=d(e.surfaceType,"ms"),this.probeRadius=d(e.probeRadius,1.4),this.smooth=d(e.smooth,2),this.scaleFactor=d(e.scaleFactor,2),this.cutoff=d(e.cutoff,0),this.background=d(e.background,!1),this.opaqueBack=d(e.opaqueBack,!0),this.filterSele=d(e.filterSele,""),this.volume=d(e.volume,void 0),this.useWorker=d(e.useWorker,!0),Ya.prototype.init.call(this,t)},prepareData:function(t,e,i){var n=this.__infoList[e];if(n||(n={},this.__infoList[e]=n),n.molsurf&&n.sele===t.selection.string)i(e);else{if(this.filterSele){var r=t.structure.getView(new _n(this.filterSele)),o=r.boundingBox.size(),a=Math.max(o.x,o.y,o.z),s=t.getAtomSetWithinPoint(r.center,a/2);t=t.getView(new _n(t.getAtomSetWithinSelection(s,3).toSeleString()))}n.sele=t.selection.string,n.molsurf=new Zs(t);var c=this.getSurfaceParams(),u=function(t){n.surface=t,i(e)};this.useWorker?n.molsurf.getSurfaceWorker(c,u):u(n.molsurf.getSurface(c))}},prepare:function(t){if((this.__forceNewMolsurf||this.__sele!==this.selection.string||this.__surfaceParams!==JSON.stringify(this.getSurfaceParams()))&&(this.__infoList.forEach(function(t){t.molsurf.dispose()}.bind(this)),this.__infoList.length=0),0===this.structureView.atomCount)return void t();var e=function(){this.__sele=this.selection.string,this.__surfaceParams=JSON.stringify(this.getSurfaceParams()),this.__forceNewMolsurf=!1,t()}.bind(this),i="default"===this.assembly?this.defaultAssembly:this.assembly,n=this.structure.biomolDict[i];n?n.partList.forEach(function(t,i){var r=t.getView(this.structureView);this.prepareData(r,i,function(t){t===n.partList.length-1&&e()}.bind(this))},this):this.prepareData(this.structureView,0,e)},createData:function(t,e){var i=this.__infoList[e],n=new ja(i.surface.getPosition(),i.surface.getColor(this.getColorParams()),i.surface.getFilteredIndex(this.filterSele,t),i.surface.getNormal(),i.surface.getPickingColor(this.getColorParams()),this.getBufferParams({background:this.background,opaqueBack:this.opaqueBack,dullInterior:!1})),r=new $a(n);return{bufferList:[r],info:i}},updateData:function(t,e){var i={};return t.position?(this.__forceNewMolsurf=!0,void this.build()):(t.color&&(i.color=e.info.surface.getColor(this.getColorParams())),t.index&&(i.index=e.info.surface.getFilteredIndex(this.filterSele,e.sview)),void e.bufferList[0].setAttributes(i))},setParameters:function(t,e,i){return e=e||{},t&&t.filterSele&&(e.index=!0),t&&void 0!==t.volume&&(e.color=!0),Ya.prototype.setParameters.call(this,t,e,i),this},getSurfaceParams:function(t){var e=Object.assign({type:this.surfaceType,probeRadius:this.probeRadius,scaleFactor:this.scaleFactor,smooth:this.smooth,cutoff:this.cutoff,useWorker:this.useWorker},t);return e},getColorParams:function(){var t=Ya.prototype.getColorParams.call(this);return t.volume=this.volume,t},clear:function(){Ya.prototype.clear.call(this)},dispose:function(){this.__infoList.forEach(function(t){t.molsurf.dispose()}.bind(this)),this.__infoList.length=0,Ya.prototype.dispose.call(this)}}),pv.add("surface",Ks),Qs.prototype=Object.assign(Object.create(Ya.prototype),{constructor:Qs,type:"point",parameters:Object.assign({pointSize:{type:"number",precision:1,max:100,min:0,buffer:!0},sizeAttenuation:{type:"boolean",buffer:!0},sortParticles:{type:"boolean",rebuild:!0},useTexture:{type:"boolean",buffer:!0},alphaTest:{type:"range",step:.001,max:1,min:0,buffer:!0},forceTransparent:{type:"boolean",buffer:!0},edgeBleach:{type:"range",step:.001,max:1,min:0,buffer:!0}},Ba.prototype.parameters,{flatShaded:null,wireframe:null,linewidth:null,roughness:null,metalness:null}),init:function(t){var e=t||{};this.pointSize=d(e.pointSize,1),this.sizeAttenuation=d(e.sizeAttenuation,!0),this.sortParticles=d(e.sortParticles,!1),this.useTexture=d(e.useTexture,!1),this.alphaTest=d(e.alphaTest,.5),this.forceTransparent=d(e.forceTransparent,!1),this.edgeBleach=d(e.edgeBleach,0),Ya.prototype.init.call(this,e)},createData:function(t){var e={position:!0,color:!0},i=t.getAtomData(this.getAtomParams(e)),n=new Ha(i.position,i.color,this.getBufferParams({pointSize:this.pointSize,sizeAttenuation:this.sizeAttenuation,sortParticles:this.sortParticles,useTexture:this.useTexture,alphaTest:this.alphaTest,forceTransparent:this.forceTransparent,edgeBleach:this.edgeBleach}));return{bufferList:[n]}},updateData:function(t,e){var i=e.sview.getAtomData(this.getAtomParams(t)),n={};t&&!t.position||(n.position=i.position),t&&!t.color||(n.color=i.color),e.bufferList[0].setAttributes(n)}}),pv.add("point",Qs),gv.add("shader/Ribbon.vert","#define STANDARD\nuniform float nearClip;\nuniform vec3 clipCenter;\n#if defined( NEAR_CLIP ) || defined( RADIUS_CLIP ) || !defined( PICKING )\nvarying vec3 vViewPosition;\n#endif\n#if defined( RADIUS_CLIP )\nvarying vec3 vClipCenter;\n#endif\nattribute vec3 dir;\nattribute float size;\n#ifdef PICKING\nattribute vec3 pickingColor;\nvarying vec3 vPickingColor;\n#else\n#include color_pars_vertex\n#ifndef FLAT_SHADED\nvarying vec3 vNormal;\n#endif\n#endif\n#include common\nvoid main(void){\n#ifdef PICKING\nvPickingColor = pickingColor;\n#else\n#include color_vertex\n#include beginnormal_vertex\n#include defaultnormal_vertex\n#ifndef FLAT_SHADED\nvNormal = normalize( transformedNormal );\n#endif\n#endif\n#include begin_vertex\ntransformed += normalize( dir ) * size;\n#include project_vertex\n#if defined( NEAR_CLIP ) || defined( RADIUS_CLIP ) || !defined( PICKING )\nvViewPosition = -mvPosition.xyz;\n#endif\n#if defined( RADIUS_CLIP )\nvClipCenter = -( modelViewMatrix * vec4( clipCenter, 1.0 ) ).xyz;\n#endif\n#include nearclip_vertex\n}"),Js.prototype=Object.assign(Object.create(ya.prototype),{constructor:Js,setAttributes:function(t){var e,i,n,r,o,a,s,c,u,h,l,d,f=this.size,p=f/4,m=this.geometry.attributes;t.position&&(e=t.position,s=m.position.array,m.position.needsUpdate=!0),t.normal&&(i=t.normal,c=m.normal.array,m.normal.needsUpdate=!0),t.size&&(n=t.size,u=m.size.array,m.size.needsUpdate=!0),t.dir&&(r=t.dir,h=m.dir.array,m.dir.needsUpdate=!0),t.color&&(o=t.color,l=m.color.array,m.color.needsUpdate=!0),t.pickingColor&&(a=t.pickingColor,d=m.pickingColor.array,m.pickingColor.needsUpdate=!0);var g,v,y,b,x,_,w,S=n?n[0]:null;for(g=0;g<p;++g){for(_=3*g,y=3*g*4,x=4*g,e&&(s[y]=s[y+3]=e[_],s[y+1]=s[y+4]=e[_+1],s[y+2]=s[y+5]=e[_+2],s[y+6]=s[y+9]=e[_+3],s[y+7]=s[y+10]=e[_+4],s[y+8]=s[y+11]=e[_+5]),i&&(c[y]=c[y+3]=-i[_],c[y+1]=c[y+4]=-i[_+1],c[y+2]=c[y+5]=-i[_+2],c[y+6]=c[y+9]=-i[_+3],c[y+7]=c[y+10]=-i[_+4],c[y+8]=c[y+11]=-i[_+5]),v=0;v<4;++v)b=y+3*v,o&&(l[b]=o[_],l[b+1]=o[_+1],l[b+2]=o[_+2]),a&&(d[b]=a[_],d[b+1]=a[_+1],d[b+2]=a[_+2]);n&&(w=n[g],S!==n[g]?(u[x]=S,u[x+1]=S,u[x+2]=w,u[x+3]=w):(u[x]=w,u[x+1]=w,u[x+2]=w,u[x+3]=w),S=w),r&&(h[y]=r[_],h[y+1]=r[_+1],h[y+2]=r[_+2],h[y+3]=-r[_],h[y+4]=-r[_+1],h[y+5]=-r[_+2],h[y+6]=r[_+3],h[y+7]=r[_+4],h[y+8]=r[_+5],h[y+9]=-r[_+3],h[y+10]=-r[_+4],h[y+11]=-r[_+5])}},makeIndex:function(){var t,e,i,n,r=this.meshIndex,o=r.length/4/3,a=new Uint16Array([0,1,2,1,3,2]);for(e=0;e<o;++e)for(i=6*e,n=4*e,r.set(a,i),t=0;t<6;++t)r[i+t]+=n}}),tc.prototype=Object.assign(Object.create(Ya.prototype),{constructor:tc,type:"ribbon",parameters:Object.assign({subdiv:{type:"integer",max:50,min:1,rebuild:!0},tension:{type:"number",precision:1,max:1,min:.1},smoothSheet:{type:"boolean",rebuild:!0}},Ya.prototype.parameters,{side:null,wireframe:null,linewidth:null}),init:function(t){var e=t||{};e.colorScheme=d(e.colorScheme,"chainname"),e.colorScale=d(e.colorScale,"RdYlBu"),e.radius=d(e.radius,"sstruc"),e.scale=d(e.scale,4),"low"===e.quality?this.subdiv=3:"medium"===e.quality?this.subdiv=6:"high"===e.quality?this.subdiv=12:this.subdiv=d(e.subdiv,6),this.tension=d(e.tension,NaN),this.smoothSheet=d(e.smoothSheet,!1),Ya.prototype.init.call(this,e)},getSplineParams:function(t){return Object.assign({subdiv:this.subdiv,tension:this.tension,directional:!0,smoothSheet:this.smoothSheet},t)},createData:function(t){var e=[],i=[];return this.structure.eachPolymer(function(t){if(!(t.residueCount<4)){i.push(t);var n=new Ms(t,this.getSplineParams()),r=n.getSubdividedPosition(),o=n.getSubdividedOrientation(),a=n.getSubdividedColor(this.getColorParams()),s=n.getSubdividedSize(this.radius,this.scale);e.push(new Js(r.position,o.binormal,o.normal,a.color,s.size,a.pickingColor,this.getBufferParams()))}}.bind(this),t.getSelection()),{bufferList:e,polymerList:i}},updateData:function(t,e){t=t||{};var i=0,n=e.polymerList.length;for(i=0;i<n;++i){var r={},o=new Ms(e.polymerList[i],this.getSplineParams());if(t.position){var a=o.getSubdividedPosition(),s=o.getSubdividedOrientation();r.position=a.position,r.normal=s.binormal,r.dir=s.normal}if(t.radius||t.scale){var c=o.getSubdividedSize(this.radius,this.scale);r.size=c.size}if(t.color){var u=o.getSubdividedColor(this.getColorParams());r.color=u.color}e.bufferList[i].setAttributes(r)}},setParameters:function(t){var e=!1,i={};return t&&t.tension&&(i.position=!0),Ya.prototype.setParameters.call(this,t,i,e),this}}),pv.add("ribbon",tc),ec.prototype=Object.assign(Object.create(Ya.prototype),{constructor:ec,type:"rocket",parameters:Object.assign({localAngle:{type:"integer",max:180,min:0,rebuild:!0},centerDist:{type:"number",precision:1,max:10,min:0,rebuild:!0},ssBorder:{type:"boolean",rebuild:!0},radialSegments:!0,openEnded:!0,disableImpostor:!0},Ya.prototype.parameters),init:function(t){var e=t||{};e.colorScheme=d(e.colorScheme,"sstruc"),e.radius=d(e.radius,1.5),e.scale=d(e.scale,1),e.openEnded=d(e.openEnded,!1),this.localAngle=d(e.localAngle,30),this.centerDist=d(e.centerDist,2.5),this.ssBorder=d(e.ssBorder,!1),Ya.prototype.init.call(this,e)},createData:function(t){var e=0,i=[],n=[];this.structure.eachPolymer(function(t){if(!(t.residueCount<4||t.isNucleic())){var r=new To(t),o=r.getAxis(this.localAngle,this.centerDist,this.ssBorder,this.getColorParams(),this.radius,this.scale);e+=o.size.length,i.push(o),n.push(r)}}.bind(this),t.getSelection());var r={begin:new Float32Array(3*e),end:new Float32Array(3*e),size:new Float32Array(e),color:new Float32Array(3*e),pickingColor:new Float32Array(3*e)},o=0;i.forEach(function(t){r.begin.set(t.begin,3*o),r.end.set(t.end,3*o),r.size.set(t.size,o),r.color.set(t.color,3*o),r.pickingColor.set(t.pickingColor,3*o),o+=t.size.length});var a=new Da(r.begin,r.end,r.color,r.color,r.size,r.pickingColor,r.pickingColor,this.getBufferParams({openEnded:this.openEnded,radialSegments:this.radialSegments,disableImpostor:this.disableImpostor,dullInterior:!0}));return{bufferList:[a],axisList:i,helixbundleList:n,axisData:r}},updateData:function(t,e){if(t=t||{},t.position)return void this.build();var i={};if(t.color||t.radius){var n=0;e.helixbundleList.forEach(function(i){var r=i.getAxis(this.localAngle,this.centerDist,this.ssBorder,this.getColorParams(),this.radius,this.scale);t.color&&e.axisData.color.set(r.color,3*n),(t.radius||t.scale)&&e.axisData.size.set(r.size,n),n+=r.size.length}.bind(this)),t.color&&(i.color=e.axisData.color,i.color2=e.axisData.color),(t.radius||t.scale)&&(i.radius=e.axisData.size)}e.bufferList[0].setAttributes(i)}}),pv.add("rocket",ec),ic.prototype=Object.assign(Object.create(Ps.prototype),{constructor:ic,type:"rope",parameters:Object.assign({smooth:{type:"integer",max:15,min:0,rebuild:!0}},Ps.prototype.parameters,{aspectRatio:null,smoothSheet:null}),init:function(t){var e=t||{};e.aspectRatio=1,e.tension=d(e.tension,.5),e.scale=d(e.scale,5),e.smoothSheet=!1,this.smooth=d(e.smooth,2),Ps.prototype.init.call(this,e)},getSpline:function(t){var e=new Po(t);return new Ms(t,this.getSplineParams({directional:!1,positionIterator:e.getCenterIterator(this.smooth)}))}}),pv.add("rope",ic),nc.prototype=Object.assign(Object.create(Ya.prototype),{constructor:nc,type:"spacefill",parameters:Object.assign({sphereDetail:!0,disableImpostor:!0},Ya.prototype.parameters),init:function(t){var e=t||{};Ya.prototype.init.call(this,e)},createData:function(t){var e=t.getAtomData(this.getAtomParams()),i=new Ta(e.position,e.color,e.radius,e.pickingColor,this.getBufferParams({sphereDetail:this.sphereDetail,dullInterior:!0,disableImpostor:this.disableImpostor}));return{bufferList:[i]}},updateData:function(t,e){var i=e.sview.getAtomData(this.getAtomParams(t)),n={};t&&!t.position||(n.position=i.position),t&&!t.color||(n.color=i.color),t&&!t.radius||(n.radius=i.radius),e.bufferList[0].setAttributes(n)}}),pv.add("spacefill",nc),rc.prototype=Object.assign(Object.create(ya.prototype),{constructor:rc,setAttributes:function(t){var e,i,n,r,o=this.geometry.attributes;if(t.position&&(e=t.position,n=o.position.array,o.position.needsUpdate=!0),t.color&&(i=t.color,r=o.color.array,o.color.needsUpdate=!0),!e&&!i)return void uv.warn("TraceBuffer.prototype.setAttributes no data");for(var a,s,c=this.size,u=c-1,h=0;h<u;++h)a=3*h,s=3*h*2,e&&(n[s]=e[a],n[s+1]=e[a+1],n[s+2]=e[a+2],n[s+3]=e[a+3],n[s+4]=e[a+4],n[s+5]=e[a+5]),i&&(r[s]=i[a],r[s+1]=i[a+1],r[s+2]=i[a+2],r[s+3]=i[a+3],r[s+4]=i[a+4],r[s+5]=i[a+5])}}),oc.prototype=Object.assign(Object.create(Ya.prototype),{constructor:oc,type:"trace",parameters:Object.assign({subdiv:{type:"integer",max:50,min:1,rebuild:!0},tension:{type:"number",precision:1,max:1,min:.1},smoothSheet:{type:"boolean",rebuild:!0}},Ba.prototype.parameters,{flatShaded:null,side:null,wireframe:null}),init:function(t){var e=t||{};e.colorScheme=d(e.colorScheme,"chainname"),e.colorScale=d(e.colorScale,"RdYlBu"),"low"===e.quality?this.subdiv=3:"medium"===e.quality?this.subdiv=6:"high"===e.quality?this.subdiv=12:this.subdiv=d(e.subdiv,6),this.tension=d(e.tension,NaN),this.smoothSheet=d(e.smoothSheet,!1),Ya.prototype.init.call(this,e)},getSplineParams:function(t){return Object.assign({subdiv:this.subdiv,tension:this.tension,directional:!1,smoothSheet:this.smoothSheet},t)},createData:function(t){var e=[],i=[];return this.structure.eachPolymer(function(t){if(!(t.residueCount<4)){i.push(t);var n=new Ms(t,this.getSplineParams()),r=n.getSubdividedPosition(),o=n.getSubdividedColor(this.getColorParams());e.push(new rc(r.position,o.color,this.getBufferParams()))}}.bind(this),t.getSelection()),{bufferList:e,polymerList:i}},updateData:function(t,e){t=t||{};var i=0,n=e.polymerList.length;for(i=0;i<n;++i){var r={},o=new Ms(e.polymerList[i],this.getSplineParams());if(t.position){var a=o.getSubdividedPosition();r.position=a.position}if(t.color){var s=o.getSubdividedColor(this.getColorParams());r.color=s.color}e.bufferList[i].setAttributes(r)}},setParameters:function(t){var e=!1,i={};return t&&t.tension&&(i.position=!0),Ya.prototype.setParameters.call(this,t,i,e),this}}),pv.add("trace",oc),ac.prototype=Object.assign(Object.create(Ps.prototype),{constructor:ac,type:"tube",parameters:Object.assign({},Ps.prototype.parameters,{aspectRatio:null}),init:function(t){var e=t||{};e.aspectRatio=1,e.scale=d(e.scale,2),Ps.prototype.init.call(this,e),"low"===e.quality&&(this.radialSegments=5)},getSplineParams:function(){return Ps.prototype.getSplineParams.call(this,{directional:!1})}}),pv.add("tube",ac),sc.prototype=Object.assign(Object.create(Ya.prototype),{constructor:sc,type:"unitcell",parameters:Object.assign({radius:{type:"number",precision:3,max:10,min:.001},sphereDetail:!0,radialSegments:!0,disableImpostor:!0},Ba.prototype.parameters,{assembly:null}),init:function(t){var e=t||{},i=.5;this.structure.unitcell&&(i=Math.cbrt(this.structure.unitcell.volume)/200),e.radius=d(e.radius,i),e.colorValue=d(e.colorValue,"orange"),Ya.prototype.init.call(this,e)},getUnitcellData:function(t){function e(t,e,i){f.set(t,e,i).multiply(d).applyMatrix4(l.fracToCart).toArray(r,p),p+=3}function i(t,e){f.fromArray(r,3*t).toArray(s,m),f.fromArray(r,3*e).toArray(c,m),m+=3}var n=new Pt(this.colorValue),r=new Float32Array(24),o=br(8,n.r,n.g,n.b),a=yr(8,this.radius),s=new Float32Array(36),c=new Float32Array(36),u=br(12,n.r,n.g,n.b),h=yr(12,this.radius),l=t.unitcell,d=t.center.clone().applyMatrix4(l.cartToFrac).floor().multiplyScalar(2).addScalar(1),f=new N,p=0;e(0,0,0),e(1,0,0),e(0,1,0),e(0,0,1),e(1,1,0),e(1,0,1),e(0,1,1),e(1,1,1);var m=0;return i(0,1),i(0,2),i(0,3),i(1,4),i(1,5),i(2,6),i(3,5),i(4,7),i(5,7),i(2,4),i(7,6),i(3,6),{vertexPosition:r,vertexColor:o,vertexRadius:a,edgePosition1:s,edgePosition2:c,edgeColor:u,edgeRadius:h}},create:function(){var t=this.structureView.getStructure();if(t.unitcell){var e=this.getUnitcellData(t);this.sphereBuffer=new Ta(e.vertexPosition,e.vertexColor,e.vertexRadius,void 0,this.getBufferParams({sphereDetail:this.sphereDetail,disableImpostor:this.disableImpostor,dullInterior:!0})),this.cylinderBuffer=new Da(e.edgePosition1,e.edgePosition2,e.edgeColor,e.edgeColor,e.edgeRadius,void 0,void 0,this.getBufferParams({openEnded:!0,radialSegments:this.radialSegments,disableImpostor:this.disableImpostor,dullInterior:!0})),this.dataList.push({sview:this.structureView,bufferList:[this.sphereBuffer,this.cylinderBuffer]})}},updateData:function(t,e){var i=e.sview.getStructure(),n=this.getUnitcellData(i),r={},o={};t&&!t.position||(r.position=n.vertexPosition,o.position1=n.edgePosition1,o.position2=n.edgePosition2),t&&!t.color||(r.color=n.vertexColor,o.color=n.edgeColor,o.color2=n.edgeColor),t&&!t.radius||(r.radius=n.vertexRadius,o.radius=n.edgeRadius),this.sphereBuffer.setAttributes(r),this.cylinderBuffer.setAttributes(o)}}),pv.add("unitcell",sc),cc.prototype={constructor:cc,type:"",__objName:"",parse:function(t){return this.streamer.read(function(){this._beforeParse(),this._parse(),this._afterParse(),t(this[this.__objName])}.bind(this)),this[this.__objName]},_parse:function(){},_beforeParse:function(){},_afterParse:function(){t.Debug&&uv.log(this[this.__objName])}},hc.prototype=Object.assign(Object.create(cc.prototype),{constructor:hc,type:"structure",__objName:"structure"}),lc.prototype={constructor:lc},dc.prototype=Object.assign(Object.create(hc.prototype),{constructor:dc,type:"gro",_parse:function(){function e(t,e,r){for(var l=t;l<e;++l){++P;var g=P-1,T=r[l];if(T)if(g%w===0)s&&(i=new Float32Array(3*_),u.push(i),n=0);else if(g%w===1);else if(g%w===w-1){var E=T.trim().split(/\s+/),I=new Float32Array(9);if(I[0]=10*parseFloat(E[0]),I[4]=10*parseFloat(E[1]),I[8]=10*parseFloat(E[2]),h.push(I),a)return!0;C+=1}else{if(d=T.substr(10,5).trim(),c&&"CA"!==d)continue;var L=10*parseFloat(T.substr(y,v)),R=10*parseFloat(T.substr(b,v)),O=10*parseFloat(T.substr(x,v));if(s){var D=3*n;if(i[D+0]=L,i[D+1]=R,i[D+2]=O,n+=1,g>w)continue}f=T.substr(5,5).trim(),p=parseInt(T.substr(0,5)),m=parseInt(T.substr(15,5)),A.growIfFull(),A.atomTypeId[M]=S.add(d),A.x[M]=L,A.y[M]=R,A.z[M]=O,A.serial[M]=m,o.addAtom(C,"","",f,p,0,"l"),M+=1}}}t.Debug&&uv.time("GroParser._parse "+this.name);var i,n,r=this.structure,o=this.structureBuilder,a=this.firstModelOnly,s=this.asTrajectory,c=this.cAlphaOnly,u=r.frames,h=r.boxes,l=this.streamer.peekLines(3);r.title=l[0].trim();var d,f,p,m,g=l[2].length-l[2].lastIndexOf(".")-1,v=5+g,y=20,b=20+v,x=20+2*v,_=parseInt(l[1]),w=_+3,S=r.atomMap,A=r.atomStore;A.resize(_);var M=0,C=0,P=0;this.streamer.eachChunkOfLines(function(t){e(0,t.length,t)}),r.unitcell=new lc(h[0][0],h[0][4],h[0][8],90,90,90,"P 1"),o.finalize(),r.finalizeAtoms(),Fo(r),zo(r),r.finalizeBonds(),zv(r),Vo(r),t.Debug&&uv.timeEnd("GroParser._parse "+this.name)}}),mv.add("gro",dc),pc.prototype={constructor:pc,type:"Entity",getEntityType:function(){return this.entityType},isPolymer:function(){return this.entityType===Bp},isNonPolymer:function(){return this.entityType===Up},isMacrolide:function(){return this.entityType===jp},isWater:function(){return this.entityType===$p},eachChain:function(t){var e=this.structure.getChainProxy();this.chainIndexList.forEach(function(i){e.index=i,t(e)})}};var Wv={1:"h",2:"h",3:"i",4:"h",5:"g",6:"h",7:"h",8:"h",9:"h",10:"h","":"h"};mc.prototype=Object.assign(Object.create(hc.prototype),{constructor:mc,type:"pdb",_parse:function(){function e(t,e,J){for(var ut,ht,lt=t;lt<e;++lt)if(s=J[lt],c=s.substr(0,6),"ATOM  "===c||"HETATM"===c){if(ct&&(U?(G?(i=new Float32Array(3*nt.count),$.push(i)):i=[],n=0):B||(W={}),P=1,T=P.toString(),E=!0,ct=!1),B&&st>0)continue;var dt,ft,pt,mt,gt;if(N){if(mt=s.split(k),gt=10===mt.length?1:0,m=mt[2],j&&"CA"!==m)continue;dt=parseFloat(mt[6-gt]),ft=parseFloat(mt[7-gt]),pt=parseFloat(mt[8-gt])}else{if(m=s.substr(12,4).trim(),j&&"CA"!==m)continue;dt=parseFloat(s.substr(30,8)),ft=parseFloat(s.substr(38,8)),pt=parseFloat(s.substr(46,8))}if(U&&(ut=3*n,i[ut+0]=dt,i[ut+1]=ft,i[ut+2]=pt,n+=1,G))continue;var vt;N?(u=parseInt(mt[1]),vt="",g="H"===s[0]?1:0,h=gt?"":mt[4],l=parseInt(mt[5-gt]),p="",d=mt[3],v=parseFloat(mt[9-gt]),y="",f=0):(u=parseInt(s.substr(6,5)),vt=s.substr(76,2).trim(),g="H"===s[0]?1:0,h=s[21].trim()||s.substr(72,4).trim(),l=parseInt(s.substr(22,4)),p=s[26].trim(),d=s.substr(17,4).trim(),v=parseFloat(s.substr(60,6)),y=s[16].trim(),f=parseFloat(s.substr(54,6))),nt.growIfFull(),nt.atomTypeId[at]=it.add(m,vt),nt.x[at]=dt,nt.y[at]=ft,nt.z[at]=pt,nt.serial[at]=u,nt.bfactor[at]=isNaN(v)?0:v,nt.altloc[at]=y.charCodeAt(0),nt.occupancy[at]=isNaN(f)?0:f,g?I===h&&R===d&&(_m.includes(d)||L===l&&D===p)||(P+=1,T=P.toString(),L=l,R=d,D=p):E||I===h||(P+=1,T=P.toString()),z.addAtom(st,h,T,d,l,g,void 0,p),W[u]=at,at+=1,E=!1,I=h}else if("CONECT"===c){var yt=W[parseInt(s.substr(6,5))],bt=[11,16,21,26],xt={};if(void 0===yt)continue;for(ut=0;ut<4;++ut){var _t=parseInt(s.substr(bt[ut],5));if(!Number.isNaN(_t)&&(_t=W[_t],void 0!==_t))if(yt<_t?(rt.index=yt,ot.index=_t):(rt.index=_t,ot.index=yt),void 0!==xt[_t])F.bondStore.bondOrder[xt[_t]]+=1;else{var wt=rt.index+"|"+ot.index;void 0===q[wt]&&(q[wt]=!0,xt[_t]=F.bondStore.count,F.bondStore.addBond(rt,ot,1))}}}else if("HELIX "===c){b=s[19].trim(),x=parseInt(s.substr(21,4)),_=s[25].trim(),w=s[31].trim(),S=parseInt(s.substr(33,4)),A=s[37].trim();var St=parseInt(s.substr(39,1));St=(Wv[St]||Wv[""]).charCodeAt(0),tt.push([b,x,_,w,S,A,St])}else if("SHEET "===c)b=s[21].trim(),x=parseInt(s.substr(22,4)),_=s[26].trim(),w=s[32].trim(),S=parseInt(s.substr(33,4)),A=s[37].trim(),et.push([b,x,_,w,S,A]);else if("HETNAM"===c)Q[s.substr(11,3)]=s.substr(15).trim();else if("COMPND"===c){var At,Mt=s.substr(10,70).trim(),Ct=Mt.indexOf(":"),Pt=Mt.substring(0,Ct);Z.includes(Pt)?(C=Pt,At=Mt.substring(Ct+2)):At=Mt,At=At.replace(/;$/,""),"MOL_ID"===C?(M={chainList:[],name:""},Y.push(M)):"MOLECULE"===C?(M.name&&(M.name+=" "),M.name+=At):"CHAIN"===C&&Array.prototype.push.apply(M.chainList,At.split(/\s*,\s*/))}else if(s.startsWith("TER")){var Tt=F.getChainProxy(F.chainStore.count-1);K[Tt.chainname]=Tt.index,P+=1,T=P.toString(),E=!0}else if("REMARK"===c&&"350"===s.substr(7,3)){if("BIOMOLECULE:"===s.substr(11,12)){var Et=s.substr(23).trim();/^(0|[1-9][0-9]*)$/.test(Et)&&(Et="BU"+Et),r=new Do(Et),H[Et]=r}else if("BIOMT"===s.substr(13,5)){
	var It=s.split(/\s+/),Lt=parseInt(s[18])-1;0===Lt&&(a=new O,o.matrixList.push(a));var Rt=a.elements;Rt[0+Lt]=parseFloat(It[4]),Rt[4+Lt]=parseFloat(It[5]),Rt[8+Lt]=parseFloat(It[6]),Rt[12+Lt]=parseFloat(It[7])}else if("APPLY THE FOLLOWING TO CHAINS:"===s.substr(11,30)||"                   AND CHAINS:"===s.substr(11,30)){"APPLY"===s.substr(11,5)&&(o=r.addPart());var Ot=s.substr(41,30).split(",");for(ht=Ot.length;ut<ht;++ut){var Dt=Ot[ut].trim();Dt&&o.chainList.push(Dt)}}}else if("HEADER"===c)F.id=s.substr(62,4);else if("TITLE "===c)F.title+=(F.title?" ":"")+s.substr(10,70).trim();else if("MODEL "===c)ct=!0;else if("ENDMDL"===c||s.startsWith("END")){if(ct)continue;U&&!G&&($.push(new Float32Array(i)),G=!0),st+=1,ct=!0}else if("MTRIX"===s.substr(0,5)){if("1"===s[59])continue;var Nt=s.split(/\s+/),kt=Nt[1].trim();if("1"===s[5]&&"1"===kt){var Ft="NCS";r=new Do(Ft),H[Ft]=r,o=r.addPart()}var zt=parseInt(s[5])-1;0===zt&&(a=new O,o.matrixList.push(a));var Bt=a.elements;Bt[0+zt]=parseFloat(Nt[2]),Bt[4+zt]=parseFloat(Nt[3]),Bt[8+zt]=parseFloat(Nt[4]),Bt[12+zt]=parseFloat(Nt[5])}else if("ORIGX"===s.substr(0,5)){X.origx||(X.origx=new O);var Ut=s.split(/\s+/),jt=parseInt(s[5])-1,$t=X.origx.elements;$t[0+jt]=parseFloat(Ut[1]),$t[4+jt]=parseFloat(Ut[2]),$t[8+jt]=parseFloat(Ut[3]),$t[12+jt]=parseFloat(Ut[4])}else if("SCALE"===s.substr(0,5)){X.scale||(X.scale=new O);var Vt=s.split(/\s+/),Gt=parseInt(s[5])-1,Ht=X.scale.elements;Ht[0+Gt]=parseFloat(Vt[1]),Ht[4+Gt]=parseFloat(Vt[2]),Ht[8+Gt]=parseFloat(Vt[3]),Ht[12+Gt]=parseFloat(Vt[4])}else if("CRYST1"===c){var Wt=parseFloat(s.substr(6,9)),Xt=parseFloat(s.substr(15,9)),qt=parseFloat(s.substr(24,9)),Yt=parseFloat(s.substr(33,7)),Zt=parseFloat(s.substr(40,7)),Kt=parseFloat(s.substr(47,7)),Qt=s.substr(55,11).trim(),Jt=new Float32Array(9);Jt[0]=Wt,Jt[4]=Xt,Jt[8]=qt,V.push(Jt),0===st&&(X.a=Wt,X.b=Xt,X.c=qt,X.alpha=Yt,X.beta=Zt,X.gamma=Kt,X.spacegroup=Qt)}}t.Debug&&uv.time("PdbParser._parse "+this.name);var i,n,r,o,a,s,c,u,h,l,d,f,p,m,g,v,y,b,x,_,w,S,A,M,C,P,T,E,I,L,R,D,N="pqr"===this.type,k=/\s+/,F=this.structure,z=this.structureBuilder,B=this.firstModelOnly,U=this.asTrajectory,j=this.cAlphaOnly,$=F.frames,V=F.boxes,G=!1,H=F.biomolDict,W={},X={},q={},Y=[],Z=["MOL_ID","MOLECULE","CHAIN","FRAGMENT","SYNONYM","EC","ENGINEERED","MUTATION","OTHER_DETAILS"],K={},Q={},J={helices:[],sheets:[]},tt=J.helices,et=J.sheets,it=F.atomMap,nt=F.atomStore;nt.resize(Math.round(this.streamer.data.length/80));var rt=F.getAtomProxy(),ot=F.getAtomProxy(),at=0,st=0,ct=!0;this.streamer.eachChunkOfLines(function(t){e(0,t.length,t)});var ut=Y.length;if(Y.length){F.eachChain(function(t){t.entityIndex=ut}),Y.forEach(function(t,e){var i=t.chainList.map(function(t){return K[t]});F.entityList.push(new pc(F,e,t.name,"polymer",i))});var ht=Y.length,lt=F.getResidueProxy(),dt={};F.eachChain(function(t){t.entityIndex===ut&&(lt.index=t.residueOffset,dt[lt.resname]||(dt[lt.resname]=[]),dt[lt.resname].push(t.index))}),Object.keys(dt).forEach(function(t){var e=dt[t],i="non-polymer",n=Q[t]||t;_m.includes(t)&&(n="water",i="water"),F.entityList.push(new pc(F,ht,n,i,e)),ht+=1})}void 0!==X.a?F.unitcell=new lc(X.a,X.b,X.c,X.alpha,X.beta,X.gamma,X.spacegroup,X.scale):F.unitcell=void 0,z.finalize(),F.finalizeAtoms(),Fo(F),zo(F),F.finalizeBonds(),tt.length||et.length?ko(F,J):zv(F),Vo(F),t.Debug&&uv.timeEnd("PdbParser._parse "+this.name)}}),mv.add("pdb",mc),mv.add("pdb1",mc),mv.add("ent",mc),gc.prototype=Object.assign(Object.create(mc.prototype),{constructor:gc,type:"pqr"}),mv.add("pqr",gc);var Xv=/\s+/,qv=/'((?:(?!'\s).)*)'|"((?:(?!"\s).)*)"|(\S+)/g,Yv=/"/g,Zv=/^['"]+|['"]+$/g;Cc.prototype=Object.assign(Object.create(hc.prototype),{constructor:Cc,type:"cif",_parse:function(){function e(e,q,Y){for(var Z=e;Z<q;++Z)if(r=Y[Z],o=r.trim(),(o||R||N)&&"#"!==o[0])if("data_"===o.substring(0,5));else if(";"===o[0])R?(N?(z===F.length&&(z=0),F[z].push(O),z+=1):U===!1?E[B]=O:E[B][U]=O,R=!1,O=null):(R=!0,O=o.substring(1));else if("loop_"===o)N=!0,k=!0,F.length=0,$.length=0,z=0;else if("_"===o[0]){var K,Q,J;if(N&&!k&&(N=!1),N)K=o.split("."),Q=K[0].substring(1),J=K[1],1===K.length?(J=!1,E[Q]||(E[Q]=[]),F.push(E[Q])):(E[Q]||(E[Q]={}),E[Q][J]?uv.warn(Q,J,"already exists"):(E[Q][J]=[],F.push(E[Q][J]),$.push(J))),B=Q,U=J,j=!0;else{var tt=o.match(qv),et=tt[0],it=tt[1];K=et.split("."),Q=K[0].substring(1),J=K[1],1===K.length?(J=!1,E[Q]=it):(E[Q]||(E[Q]={}),E[Q][J]?uv.warn(Q,J,"already exists"):E[Q][J]=it),it||(D=!0),B=Q,U=J}}else if(R)O+=r;else if(N){var nt,rt;if(!o)continue;if("atom_site"===B){nt=$.length,rt=o.split(Xv),j&&(a=$.indexOf("auth_asym_id"),s=$.indexOf("auth_seq_id"),c=$.indexOf("label_atom_id"),u=$.indexOf("label_comp_id"),h=$.indexOf("label_asym_id"),l=$.indexOf("label_entity_id"),d=$.indexOf("label_alt_id"),y=$.indexOf("Cartn_x"),b=$.indexOf("Cartn_y"),x=$.indexOf("Cartn_z"),p=$.indexOf("id"),m=$.indexOf("type_symbol"),f=$.indexOf("group_PDB"),_=$.indexOf("B_iso_or_equiv"),g=$.indexOf("pdbx_PDB_model_num"),v=$.indexOf("pdbx_PDB_ins_code"),w=$.indexOf("occupancy"),j=!1,H=parseInt(rt[g]),C&&(i=[],n=0));var ot=parseInt(rt[g]);if(H!==ot&&(C&&(0===X&&T.push(new Float32Array(i)),i=new Float32Array(3*G.count),T.push(i),n=0),X+=1),H=ot,M&&X>0)continue;var at=rt[c].replace(Yv,"");if(P&&"CA"!==at)continue;var st=parseFloat(rt[y]),ct=parseFloat(rt[b]),ut=parseFloat(rt[x]);if(C){var ht=3*n;if(i[ht+0]=st,i[ht+1]=ct,i[ht+2]=ut,n+=1,X>0)continue}var lt=rt[u],dt=parseInt(rt[s]),ft=rt[v];ft="?"===ft?"":ft;var pt=rt[a],mt=rt[h],gt="H"===rt[f][0]?1:0,vt=rt[m],yt=parseFloat(rt[_]),bt=parseFloat(rt[w]),xt=rt[d];if(xt="."===xt?"":xt,G.growIfFull(),G.atomTypeId[W]=V.add(at,vt),G.x[W]=st,G.y[W]=ct,G.z[W]=ut,G.serial[W]=parseInt(rt[p]),G.bfactor[W]=isNaN(yt)?0:yt,G.occupancy[W]=isNaN(bt)?0:bt,G.altloc[W]=xt.charCodeAt(0),A.addAtom(X,pt,mt,lt,dt,gt,void 0,ft),t.Debug){var _t=I[mt];void 0!==_t&&_t!==pt&&uv.warn(_t,pt)}I[mt]=pt;var wt=rt[l];L[wt]||(L[wt]=new Set),L[wt].add(S.chainStore.count-1),W+=1}else{rt=o.match(qv),nt=rt.length,z===F.length&&(z=0);for(var St=0;St<nt;++St)F[z+St].push(rt[St]);z+=nt}k=!1}else if("'"===o[0]&&"'"===o[o.length-1]){var At=o.substring(1,o.length-1);U===!1?E[B]=At:E[B][U]=At}else D?U===!1?E[B]=o:E[B][U]=o:t.Debug&&uv.log("CifParser._parse: unknown state",o);else R=!1,N=!1,D=!1,F.length=0,z=null,B=null,U=null,j=null,$.length=0}uv.time("CifParser._parse "+this.name);var i,n,r,o,a,s,c,u,h,l,d,f,p,m,g,v,y,b,x,_,w,S=this.structure,A=this.structureBuilder,M=this.firstModelOnly,C=this.asTrajectory,P=this.cAlphaOnly,T=S.frames,E={},I={},L={},R=!1,O=null,D=!1,N=!1,k=!1,F=[],z=null,B=null,U=null,j=null,$=[],V=S.atomMap,G=S.atomStore;G.resize(this.streamer.data.length/100);var H,W=0,X=0;if(this.streamer.eachChunkOfLines(function(t){e(0,t.length,t)}),E.chem_comp&&E.chem_comp_atom)_c(E,S,A),A.finalize(),S.finalizeAtoms(),S.finalizeBonds(),Go(S);else{var q=wc(E,S,I);if(Sc(E,S,I),Ac(E,S,I),Mc(E,S,L),E.struct&&E.struct.title&&(S.title=E.struct.title.trim().replace(Zv,"")),E.entry&&E.entry.id&&(S.id=E.entry.id.trim().replace(Zv,"")),E.database_PDB_rev){if(E.database_PDB_rev.date){vc(E.database_PDB_rev,"date");var Y=E.database_PDB_rev.date.filter(yc);Y.length&&(S.header.releaseDate=Y[Y.length-1])}if(E.database_PDB_rev.date_original){vc(E.database_PDB_rev,"date_original");var Z=E.database_PDB_rev.date_original.filter(yc);Z.length&&(S.header.depositionDate=Z[Z.length-1])}}E.reflns&&E.reflns.d_resolution_high?yc(E.reflns.d_resolution_high)&&(S.header.resolution=parseFloat(E.reflns.d_resolution_high)):E.refine&&E.refine.ls_d_res_high&&yc(E.refine.ls_d_res_high)&&(S.header.resolution=parseFloat(E.refine.ls_d_res_high)),E.refine&&E.refine.ls_R_factor_R_free&&yc(E.refine.ls_R_factor_R_free)&&(S.header.rFree=parseFloat(E.refine.ls_R_factor_R_free)),E.refine&&E.refine.ls_R_factor_R_work&&yc(E.refine.ls_R_factor_R_work)&&(S.header.rWork=parseFloat(E.refine.ls_R_factor_R_work)),E.exptl&&E.exptl.method&&(vc(E.exptl,"method"),S.header.experimentalMethods=E.exptl.method.map(function(t){return t.replace(Zv,"")})),A.finalize(),S.finalizeAtoms(),zo(S),S.finalizeBonds(),q?ko(S,q):zv(S),Vo(S)}t.Debug&&uv.timeEnd("CifParser._parse "+this.name)}}),mv.add("cif",Cc),mv.add("mcif",Cc),mv.add("mmcif",Cc),Pc.prototype=Object.assign(Object.create(hc.prototype),{constructor:Pc,type:"sdf",_parse:function(){function e(t,e,a){for(var M=t;M<e;++M){var C=a[M];if("$$$$"===C.substr(0,4)&&(w=-1,++S,A=d.count),3===w&&(f=parseInt(C.substr(0,3)),p=parseInt(C.substr(3,3)),m=4,g=m+f,v=g,y=v+p,o&&(c=0,s=new Float32Array(3*f),u.push(s),S>0&&(h=!0))),w>=m&&w<g){if(r&&S>0)continue;var P=parseFloat(C.substr(0,10)),T=parseFloat(C.substr(10,10)),E=parseFloat(C.substr(20,10));if(o){var I=3*c;if(s[I+0]=P,s[I+1]=T,s[I+2]=E,c+=1,h)continue}var L=C.substr(31,3).trim(),R=L+(_+1);d.growIfFull(),d.atomTypeId[_]=l.add(R,L),d.x[_]=P,d.y[_]=T,d.z[_]=E,d.serial[_]=_,n.addAtom(S,"","","HET",1,1),_+=1}if(w>=v&&w<y){if(r&&S>0)continue;if(o&&S>0)continue;b.index=parseInt(C.substr(0,3))-1+A,x.index=parseInt(C.substr(3,3))-1+A;var O=parseInt(C.substr(6,3));i.bondStore.addBond(b,x,O)}++w}}t.Debug&&uv.time("SdfParser._parse "+this.name);var i=this.structure,n=this.structureBuilder,r=this.firstModelOnly,o=this.asTrajectory,a=this.streamer.peekLines(2);i.id=a[0].trim(),i.title=a[1].trim();var s,c,u=i.frames,h=!1,l=i.atomMap,d=i.atomStore;d.resize(Math.round(this.streamer.data.length/50));var f,p,m,g,v,y,b=i.getAtomProxy(),x=i.getAtomProxy(),_=0,w=0,S=0,A=0;this.streamer.eachChunkOfLines(function(t){e(0,t.length,t)}),n.finalize(),i.finalizeAtoms(),i.finalizeBonds(),Go(i),t.Debug&&uv.timeEnd("SdfParser._parse "+this.name)},_postProcess:function(){Go(this.structure)}}),mv.add("sdf",Pc),Tc.prototype=Object.assign(Object.create(hc.prototype),{constructor:Tc,type:"mol2",_parse:function(){function e(t,e,M){for(var C,P=t;P<e;++P){var T=M[P].trim();if(""!==T&&"#"!==T[0])if("@"===T[0])"@<TRIPOS>MOLECULE"===T?(y=b,p=0,++g):"@<TRIPOS>ATOM"===T?(y=x,m=d.count,c&&(n=0,i=new Float32Array(3*v),u.push(i),g>0&&(h=!0))):y="@<TRIPOS>BOND"===T?_:0;else if(y===b)0===p?(o.title=T,o.id=T):1===p&&(C=T.split(r),v=parseInt(C[0])),++p;else if(y===x){if(C=T.split(r),s&&g>0)continue;var E=parseFloat(C[2]),I=parseFloat(C[3]),L=parseFloat(C[4]);if(c){var R=3*n;if(i[R+0]=E,i[R+1]=I,i[R+2]=L,n+=1,h)continue}var O=C[0],D=C[1],N=C[5].split(".")[0],k=C[6]?parseInt(C[6]):1,F=C[7]?C[7]:"",z=C[8]?parseFloat(C[8]):0;d.growIfFull(),d.atomTypeId[f]=l.add(D,N),d.x[f]=E,d.y[f]=I,d.z[f]=L,d.serial[f]=O,d.bfactor[f]=z,a.addAtom(g,"","",F,k,1),f+=1}else if(y===_){if(s&&g>0)continue;if(c&&g>0)continue;C=T.split(r),w.index=parseInt(C[1])-1+m,S.index=parseInt(C[2])-1+m;var B=A[C[3]];o.bondStore.addBond(w,S,B)}}}t.Debug&&uv.time("Mol2Parser._parse "+this.name);var i,n,r=/\s+/,o=this.structure,a=this.structureBuilder,s=this.firstModelOnly,c=this.asTrajectory,u=o.frames,h=!1,l=o.atomMap,d=o.atomStore;d.resize(Math.round(this.streamer.data.length/60));var f=0,p=0,m=0,g=-1,v=0,y=0,b=1,x=2,_=3,w=o.getAtomProxy(),S=o.getAtomProxy(),A={1:1,2:2,3:3,am:1,ar:1,du:1,un:1,nc:0};this.streamer.eachChunkOfLines(function(t){e(0,t.length,t)}),a.finalize(),o.finalizeAtoms(),Fo(o),jo(o,!0),$o(o,!0),o.finalizeBonds(),Go(o),zv(o),t.Debug&&uv.timeEnd("Mol2Parser._parse "+this.name)}}),mv.add("mol2",Tc);var Kv=["mmtfVersion","mmtfProducer","unitCell","spaceGroup","structureId","title","depositionDate","releaseDate","experimentalMethods","resolution","rFree","rWork","bioAssemblyList","ncsOperatorList","entityList","groupList","numBonds","numAtoms","numGroups","numChains","numModels","groupsPerChain","chainsPerModel"],Qv=["xCoordList","yCoordList","zCoordList","groupIdList","groupTypeList","chainIdList","bFactorList","atomIdList","altLocList","occupancyList","secStructList","insCodeList","sequenceIndexList","chainNameList","bondAtomList","bondOrderList"],Jv=Kv.concat(Qv),ty={0:"i".charCodeAt(0),1:"s".charCodeAt(0),2:"h".charCodeAt(0),3:"e".charCodeAt(0),4:"g".charCodeAt(0),5:"b".charCodeAt(0),6:"t".charCodeAt(0),7:"l".charCodeAt(0),"-1":"".charCodeAt(0)};Kc.prototype=Object.assign(Object.create(hc.prototype),{constructor:Kc,type:"mmtf",_parse:function(){t.Debug&&uv.time("MmtfParser._parse "+this.name);var e,i,n,r,o,a=this.structure,s=Zc(qc(this.streamer.data)),c=["depositionDate","releaseDate","resolution","rFree","rWork","experimentalMethods"];c.forEach(function(t){void 0!==s[t]&&(a.header[t]=s[t])});var u,h,l,d,f,p;if(a.id=s.structureId,a.title=s.title,this.firstModelOnly||this.asTrajectory){for(f=1,d=s.chainsPerModel[0],l=0,e=0,i=d;e<i;++e)l+=s.groupsPerChain[e];for(h=0,e=0,i=l;e<i;++e)o=s.groupList[s.groupTypeList[e]],h+=o.atomNameList.length;u=s.numBonds,p=[d]}else u=s.numBonds,h=s.numAtoms,l=s.numGroups,d=s.numChains,f=s.numModels,p=s.chainsPerModel;if(u+=l,this.asTrajectory)for(e=0,i=s.numModels;e<i;++e){var m=new Float32Array(3*h),g=h*e;for(n=0;n<h;++n){var v=3*n,y=n+g;m[v]=s.xCoordList[y],m[v+1]=s.yCoordList[y],m[v+2]=s.zCoordList[y]}a.frames.push(m)}var b=new Uint32Array(u),x=new Uint32Array(u),_=new Uint8Array(u),w=new Uint32Array(h),S=new Uint32Array(l),A=new Uint32Array(l),M=new Uint16Array(l),C=new Uint16Array(d),P=new Uint32Array(d),T=new Uint32Array(d),E=new Uint32Array(f),I=new Uint32Array(f),L=0;for(e=0,i=f;e<i;++e){var R=p[e];for(E[e]=L,I[e]=R,n=0;n<R;++n)C[n+L]=e;L+=R}var D=s.groupsPerChain,N=0;for(e=0,i=d;e<i;++e){var k=D[e];for(P[e]=N,T[e]=k,n=0;n<k;++n)S[n+N]=e;N+=k}var F=0,z=0;for(e=0,i=l;e<i;++e){o=s.groupList[s.groupTypeList[e]];var B=o.atomNameList.length,U=o.bondAtomList,j=o.bondOrderList;for(n=0,r=j.length;n<r;++n)b[z]=F+U[2*n],x[z]=F+U[2*n+1],_[z]=j[n],z+=1;for(A[e]=F,M[e]=B,n=0;n<B;++n)w[F]=e,F+=1}var $=s.bondAtomList;if($)for(s.bondOrderList&&_.set(s.bondOrderList,z),e=0,i=$.length;e<i;e+=2){var V=$[e],G=$[e+1];V<h&&G<h&&(b[z]=V,x[z]=G,z+=1)}a.bondStore.length=_.length,a.bondStore.count=z,a.bondStore.atomIndex1=b,a.bondStore.atomIndex2=x,a.bondStore.bondOrder=_,a.atomStore.length=h,a.atomStore.count=h,a.atomStore.residueIndex=w,a.atomStore.atomTypeId=new Uint16Array(h),a.atomStore.x=s.xCoordList.subarray(0,h),a.atomStore.y=s.yCoordList.subarray(0,h),a.atomStore.z=s.zCoordList.subarray(0,h),a.atomStore.serial=s.atomIdList.subarray(0,h),a.atomStore.bfactor=s.bFactorList.subarray(0,h),a.atomStore.altloc=s.altLocList.subarray(0,h),a.atomStore.occupancy=s.occupancyList.subarray(0,h),a.residueStore.length=l,a.residueStore.count=l,a.residueStore.chainIndex=S,a.residueStore.residueTypeId=s.groupTypeList,a.residueStore.atomOffset=A,a.residueStore.atomCount=M,a.residueStore.resno=s.groupIdList.subarray(0,l),a.residueStore.sstruc=s.secStructList.subarray(0,l),a.residueStore.inscode=s.insCodeList.subarray(0,l),a.chainStore.length=d,a.chainStore.count=d,a.chainStore.entityIndex=new Uint16Array(d),a.chainStore.modelIndex=C,a.chainStore.residueOffset=P,a.chainStore.residueCount=T,a.chainStore.chainname=s.chainNameList.subarray(0,4*d),a.chainStore.chainid=s.chainIdList.subarray(0,4*d),a.modelStore.length=f,a.modelStore.count=f,a.modelStore.chainOffset=E,a.modelStore.chainCount=I;var H={};for(e=0,i=s.groupList.length;e<i;++e){var W=s.groupList[e],X=[];for(n=0,r=W.atomNameList.length;n<r;++n){var q=W.elementList[n].toUpperCase(),Y=W.atomNameList[n];X.push(a.atomMap.add(Y,q))}var Z=W.chemCompType.toUpperCase(),K=um.includes(Z),Q=W.bondOrderList.length,J=new Array(Q),tt=new Array(Q);for(n=0;n<Q;++n)J[n]=W.bondAtomList[2*n],tt[n]=W.bondAtomList[2*n+1];var et={atomIndices1:J,atomIndices2:tt,bondOrders:W.bondOrderList};H[e]=a.residueMap.add(W.groupName,X,K,Z,et)}for(e=0,i=l;e<i;++e)a.residueStore.residueTypeId[e]=H[a.residueStore.residueTypeId[e]];for(e=0,i=a.atomStore.count;e<i;++e){var it=a.atomStore.residueIndex[e],nt=a.residueMap.list[a.residueStore.residueTypeId[it]],rt=a.residueStore.atomOffset[it];a.atomStore.atomTypeId[e]=nt.atomTypeIdList[e-rt]}if(s.secStructList){var ot=s.secStructList.length;for(e=0,i=a.residueStore.count;e<i;++e){var at=ty[a.residueStore.sstruc[e%ot]];void 0!==at&&(a.residueStore.sstruc[e]=at)}}if(s.entityList&&s.entityList.forEach(function(t,e){a.entityList[e]=new pc(a,e,t.description,t.type,t.chainIndexList)}),s.bioAssemblyList&&s.bioAssemblyList.forEach(function(t,e){var i=e+1,n=new Do(i);a.biomolDict["BU"+i]=n;var r={};t.transformList.forEach(function(t){var e=(new O).fromArray(t.matrix).transpose(),i=t.chainIndexList.map(function(t){for(var e="",i=0;i<4;++i){var n=s.chainNameList[4*t+i];if(!n)break;e+=String.fromCharCode(n)}return e}),o=r[i];o?o.matrixList.push(e):r[i]=n.addPart([e],i)})}),s.ncsOperatorList){var st="NCS",ct=new Do(st),ut=ct.addPart();s.ncsOperatorList.forEach(function(t){var e=(new O).fromArray(t).transpose();ut.matrixList.push(e)}),ut.matrixList.length>0&&(a.biomolDict[st]=ct)}s.unitCell&&Array.isArray(s.unitCell)&&s.unitCell[0]?a.unitcell=new lc(s.unitCell[0],s.unitCell[1],s.unitCell[2],s.unitCell[3],s.unitCell[4],s.unitCell[5],s.spaceGroup):a.unitcell=void 0,t.Debug&&uv.timeEnd("MmtfParser._parse "+this.name),$o(a,!0),jo(a,!0),a.finalizeAtoms(),a.finalizeBonds(),Vo(a)}}),mv.add("mmtf",Kc),Qc.prototype={constructor:Qc},Jc.prototype=Object.assign(Object.create(cc.prototype),{constructor:Jc,type:"trajectory",__objName:"frames"}),tu.prototype=Object.assign(Object.create(Jc.prototype),{constructor:tu,type:"dcd",_parse:function(){t.Debug&&uv.time("DcdParser._parse "+this.name);var e=this.streamer.data;e instanceof Uint8Array&&(e=e.buffer);var i,n,r=new DataView(e),o=this.frames,a=o.coordinates,s=o.boxes,c={},u=0,h=new Int32Array(e,0,23),l=h[0]!==r.getInt32(0);if(84!==h[0])for(n=e.byteLength,i=0;i<n;i+=4)r.setFloat32(i,r.getFloat32(i),!0);84!==h[0]&&uv.error("dcd bad format, header block start");var d=String.fromCharCode(r.getUint8(4),r.getUint8(5),r.getUint8(6),r.getUint8(7));"CORD"!==d&&uv.error("dcd bad format, format string");var f=!1,p=!1,m=!1;0!==h[22]&&(f=!0,0!==h[12]&&(p=!0),1===h[13]&&(m=!0)),c.NSET=h[2],c.ISTART=h[3],c.NSAVC=h[4],c.NAMNF=h[10],f?c.DELTA=r.getFloat32(44,l):c.DELTA=r.getFloat64(44,l),84!==h[22]&&uv.error("dcd bad format, header block end"),u=u+84+8;var g=r.getInt32(u,l),v=u+1;if((g-4)%80!==0&&uv.error("dcd bad format, title block start"),c.TITLE=_(new Uint8Array(e,v,g)),r.getInt32(v+g+4-1,l)!==g&&uv.error("dcd bad format, title block end"),u=u+g+8,4!==r.getInt32(u,l)&&uv.error("dcd bad format, natom block start"),c.NATOM=r.getInt32(u+4,l),4!==r.getInt32(u+8,l)&&uv.error("dcd bad format, natom block end"),u=u+4+8,c.NAMNF>0)return void uv.error("dcd format with fixed atoms unsupported, aborting");var y=c.NATOM,b=4*y;for(i=0,n=c.NSET;i<n;++i){if(p){u+=4;var x=new Float32Array(9);x[0]=r.getFloat64(u,l),x[4]=r.getFloat64(u+16,l),x[8]=r.getFloat64(u+40,l),s.push(x),u+=48,u+=4}for(var w=new Float32Array(3*y),S=0;S<3;++S){r.getInt32(u,l)!==b&&uv.error("dcd bad format, coord block start",i,S),u+=4;for(var A=new Float32Array(e,u,y),M=0;M<y;++M)w[3*M+S]=A[M];u+=b,r.getInt32(u,l)!==b&&uv.error("dcd bad format, coord block end",i,S),u+=4}if(a.push(w),m){var C=r.getInt32(u,l);u+=4+C+4}}t.Debug&&uv.timeEnd("DcdParser._parse "+this.name)}}),mv.add("dcd",tu),eu.prototype=Object.assign(Object.create(cc.prototype),{constructor:eu,type:"volume",__objName:"volume",_afterParse:function(){this.volume.setMatrix(this.getMatrix())},getMatrix:function(){return new O}}),iu.prototype=Object.assign(Object.create(eu.prototype),{constructor:iu,type:"mrc",_parse:function(){t.Debug&&uv.time("MrcParser._parse "+this.name);var e=this.streamer.data;e instanceof Uint8Array&&(e=e.buffer);var i=this.volume,n={},r=new Int32Array(e,0,56),o=new Float32Array(e,0,56),a=new DataView(e);if(n.MAP=String.fromCharCode(a.getUint8(208),a.getUint8(209),a.getUint8(210),a.getUint8(211)),n.MACHST=[a.getUint8(212),a.getUint8(213)],17===n.MACHST[0]&&17===n.MACHST[1])for(var s=e.byteLength,c=0;c<s;c+=4)a.setFloat32(c,a.getFloat32(c),!0);n.NX=r[0],n.NY=r[1],n.NZ=r[2],n.MODE=r[3],n.NXSTART=r[4],n.NYSTART=r[5],n.NZSTART=r[6],n.MX=r[7],n.MY=r[8],n.MZ=r[9],n.xlen=o[10],n.ylen=o[11],n.zlen=o[12],n.alpha=o[13],n.beta=o[14],n.gamma=o[15],n.MAPC=r[16],n.MAPR=r[17],n.MAPS=r[18],n.DMIN=o[19],n.DMAX=o[20],n.DMEAN=o[21],n.ISPG=r[22],n.NSYMBT=r[23],n.LSKFLG=r[24],n.originX=o[49],n.originY=o[50],n.originZ=o[51],n.ARMS=o[54],i.header=n;var u=new Float32Array(e,1024+n.NSYMBT,n.NX*n.NY*n.NZ);i.setData(u,n.NX,n.NY,n.NZ),t.Debug&&uv.timeEnd("MrcParser._parse "+this.name)},getMatrix:function(){var t=this.volume.header,e=[t.xlen,0,0],i=[t.ylen*Math.cos(Math.PI/180*t.gamma),t.ylen*Math.sin(Math.PI/180*t.gamma),0],n=[t.zlen*Math.cos(Math.PI/180*t.beta),t.zlen*(Math.cos(Math.PI/180*t.alpha)-Math.cos(Math.PI/180*t.gamma)*Math.cos(Math.PI/180*t.beta))/Math.sin(Math.PI/180*t.gamma),0];n[2]=Math.sqrt(t.zlen*t.zlen*Math.sin(Math.PI/180*t.beta)*Math.sin(Math.PI/180*t.beta)-n[1]*n[1]);var r=[0,e,i,n],o=[0,t.MX,t.MY,t.MZ],a=[0,t.MAPC,t.MAPR,t.MAPS],s=new O;return s.set(r[a[1]][0]/o[a[1]],r[a[2]][0]/o[a[2]],r[a[3]][0]/o[a[3]],0,r[a[1]][1]/o[a[1]],r[a[2]][1]/o[a[2]],r[a[3]][1]/o[a[3]],0,r[a[1]][2]/o[a[1]],r[a[2]][2]/o[a[2]],r[a[3]][2]/o[a[3]],0,0,0,0,1),s.setPosition(new N(t.originX,t.originY,t.originZ)),s.multiply((new O).makeTranslation(t.NXSTART,t.NYSTART,t.NZSTART)),s}}),mv.add("mrc",iu),mv.add("ccp4",iu),mv.add("map",iu),nu.prototype=Object.assign(Object.create(eu.prototype),{constructor:nu,type:"cube",_parse:function(){function e(t,e){var i=r[t].trim().split(a)[e];return parseFloat(i)}function i(t,e,i){for(var n=t;n<e;++n){var r=i[n].trim();if(""!==r&&h>=o.atomCount+6){r=r.split(a);for(var s=0,l=r.length;s<l;++s)1!==r.length&&(c[u]=parseFloat(r[s]),++u)}++h}}t.Debug&&uv.time("CubeParser._parse "+this.name);var n=this.volume,r=this.streamer.peekLines(6),o={},a=/\s+/,s=.529177210859;o.atomCount=Math.abs(e(2,0)),o.originX=e(2,1)*s,o.originY=e(2,2)*s,o.originZ=e(2,3)*s,o.NVX=e(3,0),o.NVY=e(4,0),o.NVZ=e(5,0),o.AVX=e(3,1)*s,o.AVY=e(4,2)*s,o.AVZ=e(5,3)*s;var c=new Float32Array(o.NVX*o.NVY*o.NVZ),u=0,h=0;this.streamer.eachChunkOfLines(function(t){i(0,t.length,t)}),n.header=o,n.setData(c,o.NVZ,o.NVY,o.NVX),t.Debug&&uv.timeEnd("CubeParser._parse "+this.name)},getMatrix:function(){var t=this.volume.header,e=new O;return e.multiply((new O).makeRotationY(wn(90))),e.multiply((new O).makeTranslation(-t.originZ,t.originY,t.originX)),e.multiply((new O).makeScale(-t.AVZ,t.AVY,t.AVX)),e}}),mv.add("cub",nu),mv.add("cube",nu),ru.prototype=Object.assign(Object.create(eu.prototype),{constructor:ru,type:"dx",_parse:function(){function e(t,e,i){for(var n=t;n<e;++n){if(h<c&&l>a){var r=i[n].trim();if(""!==r)for(var o=r.split(s),d=0,f=o.length;d<f;++d)u[h]=parseFloat(o[d]),++h}++l}}t.Debug&&uv.time("DxParser._parse "+this.name);var i=this.volume,n=this.streamer.peekLines(30),r=this.parseHeaderLines(n),o=this.volume.header,a=r.dataLineStart,s=/\s+/,c=o.nx*o.ny*o.nz,u=new Float32Array(c),h=0,l=0;this.streamer.eachChunkOfLines(function(t){e(0,t.length,t)}),i.setData(u,o.nz,o.ny,o.nx),t.Debug&&uv.timeEnd("DxParser._parse "+this.name)},parseHeaderLines:function(t){for(var e={},i=/\s+/,n=t.length,r=0,o=0,a=0,s=0;s<n;++s){var c,u=t[s];if(u.startsWith("object 1"))c=u.split(i),e.nx=parseInt(c[5]),e.ny=parseInt(c[6]),e.nz=parseInt(c[7]);else if(u.startsWith("origin"))c=u.split(i),e.xmin=parseFloat(c[1]),e.ymin=parseFloat(c[2]),e.zmin=parseFloat(c[3]);else if(u.startsWith("delta"))c=u.split(i),0===a?e.hx=parseFloat(c[1]):1===a?e.hy=parseFloat(c[2]):2===a&&(e.hz=parseFloat(c[3])),a+=1;else if(u.startsWith("object 3")){r=s,o+=u.length+1;break}o+=u.length+1}return this.volume.header=e,{dataLineStart:r,headerByteCount:o}},getMatrix:function(){var t=this.volume.header,e=new O;return e.multiply((new O).makeRotationY(wn(90))),e.multiply((new O).makeTranslation(-t.zmin,t.ymin,t.xmin)),e.multiply((new O).makeScale(-t.hz,t.hy,t.hx)),e}}),mv.add("dx",ru),ou.prototype=Object.assign(Object.create(ru.prototype),{constructor:ou,type:"dxbin",_parse:function(){t.Debug&&uv.time("DxbinParser._parse "+this.name);var e=this.streamer.data;e instanceof Uint8Array&&(e=e.buffer);for(var i=w(new Uint8Array(e,0,1e3)),n=this.parseHeaderLines(i),r=this.volume.header,o=n.headerByteCount,a=r.nx*r.ny*r.nz,s=new DataView(e),c=new Float32Array(a),u=0;u<a;++u)c[u]=s.getFloat64(8*u+o,!0);this.volume.setData(c,r.nz,r.ny,r.nx),t.Debug&&uv.timeEnd("DxbinParser._parse "+this.name)}}),mv.add("dxbin",ou),au.prototype=Object.assign(Object.create(eu.prototype),{constructor:au,type:"xplor",_parse:function(){function e(t){return t.trim().split(s).map(parseFloat)}function i(t,e,i){for(var n=t;n<e;++n){var r=i[n];if(v>=c&&(v-c)%y!==0&&g<p)for(var o=0,a=6;o<a;++o)m[g]=parseFloat(r.substr(12*o,12)),++g;++v}}t.Debug&&uv.time("XplorParser._parse "+this.name);var n,r=this.volume,o=this.streamer.peekLines(8),a={},s=/\s+/;n=o[2].startsWith("REMARKS")?parseInt(o[1].substring(0,8))+2:5;var c=n+3,u=e(o[n]);a.NA=u[0],a.AMIN=u[1],a.AMAX=u[2],a.NB=u[3],a.BMIN=u[4],a.BMAX=u[5],a.NC=u[6],a.CMIN=u[7],a.CMAX=u[8];var h=e(o[n+1]);a.a=h[0],a.b=h[1],a.c=h[2],a.alpha=h[3],a.beta=h[4],a.gamma=h[5];var l=a.AMAX-a.AMIN+1,d=a.BMAX-a.BMIN+1,f=a.CMAX-a.CMIN+1,p=l*d*f,m=new Float32Array(p),g=0,v=0,y=1+l*d/6;this.streamer.eachChunkOfLines(function(t){i(0,t.length,t)}),r.header=a,r.setData(m,l,d,f),t.Debug&&uv.timeEnd("XplorParser._parse "+this.name)},getMatrix:function(){var t=this.volume.header,e=[t.a,0,0],i=[t.b*Math.cos(Math.PI/180*t.gamma),t.b*Math.sin(Math.PI/180*t.gamma),0],n=[t.c*Math.cos(Math.PI/180*t.beta),t.c*(Math.cos(Math.PI/180*t.alpha)-Math.cos(Math.PI/180*t.gamma)*Math.cos(Math.PI/180*t.beta))/Math.sin(Math.PI/180*t.gamma),0];n[2]=Math.sqrt(t.c*t.c*Math.sin(Math.PI/180*t.beta)*Math.sin(Math.PI/180*t.beta)-n[1]*n[1]);var r=[0,e,i,n],o=[0,t.NA,t.NB,t.NC],a=[0,1,2,3],s=new O;return s.set(r[a[1]][0]/o[a[1]],r[a[2]][0]/o[a[2]],r[a[3]][0]/o[a[3]],0,r[a[1]][1]/o[a[1]],r[a[2]][1]/o[a[2]],r[a[3]][1]/o[a[3]],0,r[a[1]][2]/o[a[1]],r[a[2]][2]/o[a[2]],r[a[3]][2]/o[a[3]],0,0,0,0,1),s.multiply((new O).makeTranslation(t.AMIN,t.BMIN,t.CMIN)),s}}),mv.add("xplor",au),mv.add("cns",au),su.prototype=Object.assign(Object.create(cc.prototype),{constructor:su,type:"surface",__objName:"surface",_parse:function(){var t=this.loader.parse(this.streamer.asText());this.surface.fromGeometry(t)}}),cu.prototype={constructor:cu,setPropertyNameMapping:function(t){this.propertyNameMapping=t},bin2str:function(t){for(var e=new Uint8Array(t),i="",n=0;n<t.byteLength;n++)i+=String.fromCharCode(e[n]);return i},isASCII:function(t){var e=this.parseHeader(this.bin2str(t));return"ascii"===e.format},parse:function(t){return t instanceof ArrayBuffer?this.isASCII(t)?this.parseASCII(this.bin2str(t)):this.parseBinary(t):this.parseASCII(t)},parseHeader:function(t){function e(t,e){var i={type:t[0]};return"list"===i.type?(i.name=t[3],i.countType=t[1],i.itemType=t[2]):i.name=t[1],i.name in e&&(i.name=e[i.name]),i}var i=/ply([\s\S]*)end_header\s/,n="",r=0,o=i.exec(t);null!==o&&(n=o[1],r=o[0].length);for(var a,s,c,u={comments:[],elements:[],headerLength:r},h=n.split("\n"),l=0;l<h.length;l++){var d=h[l];if(d=d.trim(),""!==d)switch(c=d.split(/\s+/),s=c.shift(),d=c.join(" "),s){case"format":u.format=c[0],u.version=c[1];break;case"comment":u.comments.push(d);break;case"element":void 0!==a&&u.elements.push(a),a={},a.name=c[0],a.count=parseInt(c[1]),a.properties=[];break;case"property":a.properties.push(e(c,this.propertyNameMapping));break;default:console.log("unhandled",s,c)}}return void 0!==a&&u.elements.push(a),u},parseASCIINumber:function(t,e){switch(e){case"char":case"uchar":case"short":case"ushort":case"int":case"uint":case"int8":case"uint8":case"int16":case"uint16":case"int32":case"uint32":return parseInt(t);case"float":case"double":case"float32":case"float64":return parseFloat(t)}},parseASCIIElement:function(t,e){for(var i=e.split(/\s+/),n={},r=0;r<t.length;r++)if("list"===t[r].type){for(var o=[],a=this.parseASCIINumber(i.shift(),t[r].countType),s=0;s<a;s++)o.push(this.parseASCIINumber(i.shift(),t[r].itemType));n[t[r].name]=o}else n[t[r].name]=this.parseASCIINumber(i.shift(),t[r].type);return n},parseASCII:function(t){var e,i=new ae,n=this.parseHeader(t),r=/end_header\s([\s\S]*)$/,o="";null!==(e=r.exec(t))&&(o=e[1]);var a=o.split("\n"),s=0,c=0;i.useColor=!1;for(var u=0;u<a.length;u++){var h=a[u];if(h=h.trim(),""!==h){c>=n.elements[s].count&&(s++,c=0);var l=this.parseASCIIElement(n.elements[s].properties,h);this.handleElement(i,n.elements[s].name,l),c++}}return this.postProcess(i)},postProcess:function(t){if(t.useColor){for(var e=0;e<t.faces.length;e++)t.faces[e].vertexColors=[t.colors[t.faces[e].a],t.colors[t.faces[e].b],t.colors[t.faces[e].c]];t.elementsNeedUpdate=!0}return t.computeBoundingSphere(),t},handleElement:function(t,e,i){if("vertex"===e){if(t.vertices.push(new N(i.x,i.y,i.z)),"red"in i&&"green"in i&&"blue"in i){t.useColor=!0;var n=new Pt;n.setRGB(i.red/255,i.green/255,i.blue/255),t.colors.push(n)}}else if("face"===e){var r=i.vertex_indices;3===r.length?t.faces.push(new ee(r[0],r[1],r[2])):4===r.length&&t.faces.push(new ee(r[0],r[1],r[3]),new ee(r[1],r[2],r[3]))}},binaryRead:function(t,e,i,n){switch(i){case"int8":case"char":return[t.getInt8(e),1];case"uint8":case"uchar":return[t.getUint8(e),1];case"int16":case"short":return[t.getInt16(e,n),2];case"uint16":case"ushort":return[t.getUint16(e,n),2];case"int32":case"int":return[t.getInt32(e,n),4];case"uint32":case"uint":return[t.getUint32(e,n),4];case"float32":case"float":return[t.getFloat32(e,n),4];case"float64":case"double":return[t.getFloat64(e,n),8]}},binaryReadElement:function(t,e,i,n){for(var r,o={},a=0,s=0;s<i.length;s++)if("list"===i[s].type){var c=[];r=this.binaryRead(t,e+a,i[s].countType,n);var u=r[0];a+=r[1];for(var h=0;h<u;h++)r=this.binaryRead(t,e+a,i[s].itemType,n),c.push(r[0]),a+=r[1];o[i[s].name]=c}else r=this.binaryRead(t,e+a,i[s].type,n),o[i[s].name]=r[0],a+=r[1];return[o,a]},parseBinary:function(t){for(var e,i=new ae,n=this.parseHeader(this.bin2str(t)),r="binary_little_endian"===n.format,o=new DataView(t,n.headerLength),a=0,s=0;s<n.elements.length;s++)for(var c=0;c<n.elements[s].count;c++){e=this.binaryReadElement(o,a,n.elements[s].properties,r),a+=e[1];var u=e[0];this.handleElement(i,n.elements[s].name,u)}return this.postProcess(i)}},uu.prototype=Object.assign(Object.create(su.prototype),{constructor:uu,type:"ply"}),mv.add("ply",uu),hu.prototype={constructor:hu,setPath:function(t){this.path=t},_createParserState:function(){var t={objects:[],object:{},vertices:[],normals:[],startObject:function(t,e){return this.object&&this.object.fromDeclaration===!1?(this.object.name=t,void(this.object.fromDeclaration=e!==!1)):(this.object={name:t||"",geometry:{vertices:[],normals:[]},fromDeclaration:e!==!1},void this.objects.push(this.object))},parseVertexIndex:function(t,e){var i=parseInt(t,10);return 3*(i>=0?i-1:i+e/3)},parseNormalIndex:function(t,e){var i=parseInt(t,10);return 3*(i>=0?i-1:i+e/3)},addVertex:function(t,e,i){var n=this.vertices,r=this.object.geometry.vertices;r.push(n[t+0]),r.push(n[t+1]),r.push(n[t+2]),r.push(n[e+0]),r.push(n[e+1]),r.push(n[e+2]),r.push(n[i+0]),r.push(n[i+1]),r.push(n[i+2])},addVertexLine:function(t){var e=this.vertices,i=this.object.geometry.vertices;i.push(e[t+0]),i.push(e[t+1]),i.push(e[t+2])},addNormal:function(t,e,i){var n=this.normals,r=this.object.geometry.normals;r.push(n[t+0]),r.push(n[t+1]),r.push(n[t+2]),r.push(n[e+0]),r.push(n[e+1]),r.push(n[e+2]),r.push(n[i+0]),r.push(n[i+1]),r.push(n[i+2])},addFace:function(t,e,i,n,r,o,a,s){var c,u=this.vertices.length,h=this.parseVertexIndex(t,u),l=this.parseVertexIndex(e,u),d=this.parseVertexIndex(i,u);if(void 0===n?this.addVertex(h,l,d):(c=this.parseVertexIndex(n,u),this.addVertex(h,l,c),this.addVertex(l,d,c)),void 0!==r){var f=this.normals.length;h=this.parseNormalIndex(r,f),l=r===o?h:this.parseNormalIndex(o,f),d=r===a?h:this.parseNormalIndex(a,f),void 0===n?this.addNormal(h,l,d):(c=this.parseNormalIndex(s,f),this.addNormal(h,l,c),this.addNormal(l,d,c))}},addLineGeometry:function(t){this.object.geometry.type="Line";for(var e=this.vertices.length,i=0,n=t.length;i<n;i++)this.addVertexLine(this.parseVertexIndex(t[i],e))}};return t.startObject("",!1),t},parse:function(t){var e=this._createParserState();
	t.indexOf("\r\n")!==-1&&(t=t.replace(/\r\n/g,"\n")),t.indexOf("\\\n")!==-1&&(t=t.replace(/\\\n/g,""));var i,n,r=t.split("\n"),o="",a="",s="",c=0,u=[],h="function"==typeof"".trimLeft;for(i=0,n=r.length;i<n;i++)if(o=r[i],o=h?o.trimLeft():o.trim(),c=o.length,0!==c&&(a=o.charAt(0),"#"!==a))if("v"===a){if(s=o.charAt(1)," "===s&&null!==(u=this.regexp.vertex_pattern.exec(o)))e.vertices.push(parseFloat(u[1]),parseFloat(u[2]),parseFloat(u[3]));else if("n"===s&&null!==(u=this.regexp.normal_pattern.exec(o)))e.normals.push(parseFloat(u[1]),parseFloat(u[2]),parseFloat(u[3]));else if("t"!==s||null===(u=this.regexp.uv_pattern.exec(o)))throw new Error("Unexpected vertex/normal/uv line: '"+o+"'")}else if("f"===a)if(null!==(u=this.regexp.face_vertex_uv_normal.exec(o)))e.addFace(u[1],u[4],u[7],u[10],u[3],u[6],u[9],u[12]);else if(null!==(u=this.regexp.face_vertex_uv.exec(o)));else if(null!==(u=this.regexp.face_vertex_normal.exec(o)))e.addFace(u[1],u[3],u[5],u[7],u[2],u[4],u[6],u[8]);else{if(null===(u=this.regexp.face_vertex.exec(o)))throw new Error("Unexpected face line: '"+o+"'");e.addFace(u[1],u[2],u[3],u[4])}else if("l"===a){var l=o.substring(1).trim().split(" "),d=[],f=[];if(o.indexOf("/")===-1)d=l;else for(var p=0,m=l.length;p<m;p++){var g=l[p].split("/");""!==g[0]&&d.push(g[0]),""!==g[1]&&f.push(g[1])}e.addLineGeometry(d,f)}else if(null!==(u=this.regexp.object_pattern.exec(o))){var v=u[0].substr(1).trim();e.startObject(v)}else if(this.regexp.material_use_pattern.test(o));else if(this.regexp.material_library_pattern.test(o));else if(null===(u=this.regexp.smoothing_pattern.exec(o))){if("\0"===o)continue;throw new Error("Unexpected line: '"+o+"'")}