# nbgrader

Linux: [![TravisCI](https://travis-ci.org/jupyter/nbgrader.svg?branch=master)](https://travis-ci.org/jupyter/nbgrader)
Windows: [![AppVeyor](https://ci.appveyor.com/api/projects/status/github/jupyter/nbgrader?svg=True)](https://ci.appveyor.com/project/jupyter/nbgrader/branch/master)
Forum: [![Google Group](https://img.shields.io/badge/-Google%20Group-lightgrey.svg)](https://groups.google.com/forum/#!forum/jupyter)
Coverage: [![codecov.io](http://codecov.io/github/jupyter/nbgrader/coverage.svg?branch=master)](http://codecov.io/github/jupyter/nbgrader?branch=master)

A system for assigning and grading Jupyter notebooks.

[Documentation can be found on Read the Docs.](https://nbgrader.readthedocs.io)

## Highlights of nbgrader

### Instructor toolbar extension for Jupyter notebooks
The nbgrader toolbar extension for Jupyter notebooks guides the instructor through
assignment and grading tasks using the familiar Jupyter notebook interface.

![Creating assignment](nbgrader/docs/source/user_guide/images/creating_assignment.gif "Creating assignment")

### Instructor "formgrader" extension for Jupyter notebooks

The formgrader extension for the Jupyter notebook allows instructors to use
the core functionality of nbgrader---generating the student version of an
assignment, releasing assignments to students, collecting assignments,
autograding submissions, and manually grading submissions.

![Formgrader extension](nbgrader/docs/source/user_guide/images/formgrader.gif "Formgrader extension")

### Student assignment list extension for Jupyter notebooks
Using the assignment list extension, students may conveniently view, fetch,
submit, and validate their assignments.

![nbgrader assignment list](nbgrader/docs/source/user_guide/images/student_assignment.gif "nbgrader assignment list")

### The command line tools of nbgrader

[Command line tools](https://nbgrader.readthedocs.io/en/latest/command_line_tools/index.html)
offer an efficient way for the instructor to generate, assign, release, collect,
and grade notebooks.

### SciPy 2017 overview talk (click to view on YouTube)

[![nbgrader: A Tool for Creating and Grading Assignments in the Jupyter Notebook | SciPy 2017 ](http://img.youtube.com/vi/5WUm0QuJdFw/0.jpg)](http://www.youtube.com/watch?v=5WUm0QuJdFw "nbgrader: A Tool for Creating and Grading Assignments in the Jupyter Notebook | SciPy 2017 ")

## Installation

For detailed instructions on installing nbgrader and the nbgrader extensions
for Jupyter notebook, please see [Installation](https://nbgrader.readthedocs.io/en/latest/user_guide/installation.html)
section in the User Guide.


## Contributing
Please see the [contributing guidelines and documentation](https://nbgrader.readthedocs.io/en/latest/contributor_guide/overview.html).

If you want to develop features for nbgrader, please follow the
[development installation instructions](https://nbgrader.readthedocs.io/en/latest/contributor_guide/installation_developer.html).
