"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var coreutils_1 = require("@jupyterlab/coreutils");
var services_1 = require("@jupyterlab/services");
var widgets_1 = require("@phosphor/widgets");
var model_1 = require("nbdime/lib/diff/model");
var widget_1 = require("nbdime/lib/diff/widget");
var common_1 = require("nbdime/lib/diff/widget/common");
var request_1 = require("nbdime/lib/request");
var utils_1 = require("./utils");
/**
 * Class of the outermost widget, the draggable tab
 */
var NBDIME_CLASS = 'nbdime-Widget';
/**
 * Class of the root of the actual diff, the scroller element
 */
var ROOT_CLASS = 'nbdime-root';
/**
 * DOM class for whether or not to hide unchanged cells
 */
var HIDE_UNCHANGED_CLASS = 'jp-mod-hideUnchanged';
var NbdimeWidget = /** @class */ (function (_super) {
    __extends(NbdimeWidget, _super);
    /**
     *
     */
    function NbdimeWidget(options) {
        var _this = _super.call(this) || this;
        _this.addClass(NBDIME_CLASS);
        _this.base = options.base;
        _this.remote = options.remote;
        _this.rendermime = options.rendermime;
        var header = Private.diffHeader(options);
        _this.addWidget(header);
        _this.scroller = new widgets_1.Panel();
        _this.scroller.addClass(ROOT_CLASS);
        _this.scroller.node.tabIndex = -1;
        _this.addWidget(_this.scroller);
        var hideUnchangedChk = header.node.getElementsByClassName('nbdime-hide-unchanged')[0];
        hideUnchangedChk.onchange = function () {
            Private.toggleShowUnchanged(_this.scroller.node, !hideUnchangedChk.checked);
        };
        var args;
        if (_this.remote) {
            args = { base: _this.base, remote: _this.remote };
        }
        else if (options.baseLabel === 'Checkpoint') {
            args = { base: "checkpoint:" + _this.base };
        }
        else {
            args = { base: "git:" + _this.base };
        }
        var url = coreutils_1.URLExt.join(utils_1.urlRStrip(services_1.ServerConnection.defaultSettings.baseUrl), 'nbdime/api/diff');
        var promise = request_1.requestJsonPromise(url, args);
        promise.then(_this.onData.bind(_this)).catch(_this.onError.bind(_this));
        _this.id = "nbdime-" + JSON.stringify(args);
        _this.title.closable = true;
        return _this;
    }
    NbdimeWidget.prototype.dispose = function () {
        _super.prototype.dispose.call(this);
        this.rendermime = null;
        this.header = null;
        this.scroller = null;
    };
    /**
     * Handle `'activate-request'` messages.
     */
    NbdimeWidget.prototype.onActivateRequest = function (msg) {
        this.scroller.node.focus();
    };
    NbdimeWidget.prototype.onData = function (data) {
        var _this = this;
        if (this.isDisposed) {
            return;
        }
        var base = data['base'];
        var diff = data['diff'];
        var nbdModel = new model_1.NotebookDiffModel(base, diff);
        var nbdWidget = new widget_1.NotebookDiffWidget(nbdModel, this.rendermime);
        this.scroller.addWidget(nbdWidget);
        var work = nbdWidget.init();
        work.then(function () {
            Private.markUnchangedRanges(_this.scroller.node);
        });
        return work;
    };
    NbdimeWidget.prototype.onError = function (error) {
        if (this.isDisposed) {
            return;
        }
        var widget = new widgets_1.Widget();
        widget.node.innerHTML = "Failed to fetch diff: " + error.message;
        this.scroller.addWidget(widget);
    };
    return NbdimeWidget;
}(widgets_1.Panel));
exports.NbdimeWidget = NbdimeWidget;
var Private;
(function (Private) {
    /**
     * Create a header widget for the diff view.
     */
    function diffHeader(options) {
        var base = options.base, remote = options.remote, baseLabel = options.baseLabel, remoteLabel = options.remoteLabel;
        if (remote) {
            if (baseLabel === undefined) {
                baseLabel = base;
            }
            if (remoteLabel === undefined) {
                remoteLabel = remote;
            }
        }
        else {
            if (!baseLabel) {
                baseLabel = 'git HEAD';
            }
            remoteLabel = base;
        }
        var node = document.createElement('div');
        node.className = 'nbdime-Diff';
        node.innerHTML = "\n      <div class=\"nbdime-header-buttonrow\">\n        <label><input class=\"nbdime-hide-unchanged\" type=\"checkbox\">Hide unchanged cells</label>\n        <button class=\"nbdime-export\" style=\"display: none\">Export diff</button>\n      </div>\n      <div class=nbdime-header-banner>\n        <span class=\"nbdime-header-base\">" + baseLabel + "</span>\n        <span class=\"nbdime-header-remote\">" + remoteLabel + "</span>\n      </div>";
        return new widgets_1.Widget({ node: node });
    }
    Private.diffHeader = diffHeader;
    /**
     * Toggle whether to show or hide unchanged cells.
     *
     * This simply marks with a class, real work is done by CSS.
     */
    function toggleShowUnchanged(root, show) {
        var hiding = root.classList.contains(HIDE_UNCHANGED_CLASS);
        if (show === undefined) {
            show = hiding;
        }
        else if (hiding !== show) {
            // Nothing to do
            return;
        }
        if (show) {
            root.classList.remove(HIDE_UNCHANGED_CLASS);
        }
        else {
            markUnchangedRanges(root);
            root.classList.add(HIDE_UNCHANGED_CLASS);
        }
    }
    Private.toggleShowUnchanged = toggleShowUnchanged;
    /**
     * Marks certain cells with
     */
    function markUnchangedRanges(root) {
        var children = root.querySelectorAll("." + widget_1.CELLDIFF_CLASS);
        var rangeStart = -1;
        for (var i = 0; i < children.length; ++i) {
            var child = children[i];
            if (!child.classList.contains(common_1.UNCHANGED_DIFF_CLASS)) {
                // Visible
                if (rangeStart !== -1) {
                    // Previous was hidden
                    var N = i - rangeStart;
                    child.setAttribute('data-nbdime-NCellsHiddenBefore', N.toString());
                    rangeStart = -1;
                }
            }
            else if (rangeStart === -1) {
                rangeStart = i;
            }
        }
        if (rangeStart !== -1) {
            // Last element was part of a hidden range, need to mark
            // the last cell that will be visible.
            if (rangeStart === 0) {
                // All elements were hidden, nothing to mark
                return;
            }
            var N = children.length - rangeStart;
            var lastVisible = children[rangeStart - 1];
            lastVisible.setAttribute('data-nbdime-NCellsHiddenAfter', N.toString());
        }
    }
    Private.markUnchangedRanges = markUnchangedRanges;
})(Private || (Private = {}));
//# sourceMappingURL=widget.js.map