"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var coreutils_1 = require("@jupyterlab/coreutils");
var services_1 = require("@jupyterlab/services");
var widget_1 = require("./widget");
var utils_1 = require("./utils");
function diffNotebook(args) {
    var base = args.base, remote = args.remote;
    var widget = new widget_1.NbdimeWidget(args);
    widget.title.label = "Diff: " + base + " \u2194 " + remote;
    widget.title.caption = "Local: " + base + "\nRemote: '" + remote + "'";
    return widget;
}
exports.diffNotebook = diffNotebook;
function diffNotebookCheckpoint(args) {
    var path = args.path, rendermime = args.rendermime;
    var nb_dir = coreutils_1.PathExt.dirname(path);
    var name = coreutils_1.PathExt.basename(path, '.ipynb');
    var base = coreutils_1.PathExt.join(nb_dir, name + '.ipynb');
    var widget = new widget_1.NbdimeWidget({ base: base, rendermime: rendermime, baseLabel: 'Checkpoint' });
    widget.title.label = "Diff checkpoint: " + name;
    widget.title.caption = "Local: latest checkpoint\nRemote: '" + path + "'";
    widget.title.iconClass = 'fa fa-clock-o jp-fa-tabIcon';
    return widget;
}
exports.diffNotebookCheckpoint = diffNotebookCheckpoint;
function diffNotebookGit(args) {
    var path = args.path, rendermime = args.rendermime;
    var name = coreutils_1.PathExt.basename(path, '.ipynb');
    var widget = new widget_1.NbdimeWidget({ base: path, rendermime: rendermime });
    widget.title.label = "Diff git: " + name;
    widget.title.caption = "Local: git HEAD\nRemote: '" + path + "'";
    widget.title.iconClass = 'fa fa-git jp-fa-tabIcon';
    return widget;
}
exports.diffNotebookGit = diffNotebookGit;
function isNbInGit(args) {
    var request = {
        method: 'POST',
        body: JSON.stringify(args),
    };
    var settings = services_1.ServerConnection.makeSettings();
    return services_1.ServerConnection.makeRequest(coreutils_1.URLExt.join(utils_1.urlRStrip(settings.baseUrl), '/nbdime/api/isgit'), request, settings).then(function (response) {
        if (!response.ok) {
            return Promise.reject(response);
        }
        return response.json();
    }).then(function (data) {
        return data['is_git'];
    });
}
exports.isNbInGit = isNbInGit;
//# sourceMappingURL=actions.js.map