#
# Analog to gdal_translate for Nansat datasets.
# Any gdal_translate-options can be used, 
# but band number refers to the Nansat dataset

import sys
import os
from os.path import dirname, abspath

try:
    from nansat import Nansat
except ImportError: # development
    sys.path.append(dirname(dirname(abspath(__file__))))
    from nansat import Nansat

tmpfile = 'nansat_translate_test.VRT'

if (len(sys.argv) <= 2):
    sys.exit('Usage: nansat_translate <input_file> <output_file> <gdal_translate options>')

outfile = sys.argv[2]
options = " ".join(sys.argv[3:])

n = Nansat(sys.argv[1])
n.vrt.export(tmpfile)
os.system('gdal_translate ' + tmpfile + ' ' + outfile + ' ' + options)
os.remove(tmpfile)
