# -*- coding: utf-8 -*-

# Copyright (c) 2013, 2020, Oracle and/or its affiliates. All rights reserved.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License, version 2.0, as
# published by the Free Software Foundation.
#
# This program is also distributed with certain software (including
# but not limited to OpenSSL) that is licensed under separate terms,
# as designated in a particular file or component or in included license
# documentation.  The authors of MySQL hereby grant you an
# additional permission to link the program and your derivative works
# with the separately licensed software that they have included with
# MySQL.
#
# Without limiting anything contained in the foregoing, this file,
# which is part of MySQL Connector/Python, is also subject to the
# Universal FOSS Exception, version 1.0, a copy of which can be found at
# http://oss.oracle.com/licenses/universal-foss-exception.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License, version 2.0, for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA

# This file was auto-generated.
_GENERATED_ON = '2020-09-29'
_MYSQL_VERSION = (8, 0, 23)

"""This module contains the MySQL Server and Client error codes"""

# Start MySQL Errors
OBSOLETE_ER_HASHCHK = 1000
OBSOLETE_ER_NISAMCHK = 1001
ER_NO = 1002
ER_YES = 1003
ER_CANT_CREATE_FILE = 1004
ER_CANT_CREATE_TABLE = 1005
ER_CANT_CREATE_DB = 1006
ER_DB_CREATE_EXISTS = 1007
ER_DB_DROP_EXISTS = 1008
OBSOLETE_ER_DB_DROP_DELETE = 1009
ER_DB_DROP_RMDIR = 1010
OBSOLETE_ER_CANT_DELETE_FILE = 1011
ER_CANT_FIND_SYSTEM_REC = 1012
ER_CANT_GET_STAT = 1013
OBSOLETE_ER_CANT_GET_WD = 1014
ER_CANT_LOCK = 1015
ER_CANT_OPEN_FILE = 1016
ER_FILE_NOT_FOUND = 1017
ER_CANT_READ_DIR = 1018
OBSOLETE_ER_CANT_SET_WD = 1019
ER_CHECKREAD = 1020
OBSOLETE_ER_DISK_FULL = 1021
ER_DUP_KEY = 1022
OBSOLETE_ER_ERROR_ON_CLOSE = 1023
ER_ERROR_ON_READ = 1024
ER_ERROR_ON_RENAME = 1025
ER_ERROR_ON_WRITE = 1026
ER_FILE_USED = 1027
OBSOLETE_ER_FILSORT_ABORT = 1028
OBSOLETE_ER_FORM_NOT_FOUND = 1029
ER_GET_ERRNO = 1030
ER_ILLEGAL_HA = 1031
ER_KEY_NOT_FOUND = 1032
ER_NOT_FORM_FILE = 1033
ER_NOT_KEYFILE = 1034
ER_OLD_KEYFILE = 1035
ER_OPEN_AS_READONLY = 1036
ER_OUTOFMEMORY = 1037
ER_OUT_OF_SORTMEMORY = 1038
OBSOLETE_ER_UNEXPECTED_EOF = 1039
ER_CON_COUNT_ERROR = 1040
ER_OUT_OF_RESOURCES = 1041
ER_BAD_HOST_ERROR = 1042
ER_HANDSHAKE_ERROR = 1043
ER_DBACCESS_DENIED_ERROR = 1044
ER_ACCESS_DENIED_ERROR = 1045
ER_NO_DB_ERROR = 1046
ER_UNKNOWN_COM_ERROR = 1047
ER_BAD_NULL_ERROR = 1048
ER_BAD_DB_ERROR = 1049
ER_TABLE_EXISTS_ERROR = 1050
ER_BAD_TABLE_ERROR = 1051
ER_NON_UNIQ_ERROR = 1052
ER_SERVER_SHUTDOWN = 1053
ER_BAD_FIELD_ERROR = 1054
ER_WRONG_FIELD_WITH_GROUP = 1055
ER_WRONG_GROUP_FIELD = 1056
ER_WRONG_SUM_SELECT = 1057
ER_WRONG_VALUE_COUNT = 1058
ER_TOO_LONG_IDENT = 1059
ER_DUP_FIELDNAME = 1060
ER_DUP_KEYNAME = 1061
ER_DUP_ENTRY = 1062
ER_WRONG_FIELD_SPEC = 1063
ER_PARSE_ERROR = 1064
ER_EMPTY_QUERY = 1065
ER_NONUNIQ_TABLE = 1066
ER_INVALID_DEFAULT = 1067
ER_MULTIPLE_PRI_KEY = 1068
ER_TOO_MANY_KEYS = 1069
ER_TOO_MANY_KEY_PARTS = 1070
ER_TOO_LONG_KEY = 1071
ER_KEY_COLUMN_DOES_NOT_EXITS = 1072
ER_BLOB_USED_AS_KEY = 1073
ER_TOO_BIG_FIELDLENGTH = 1074
ER_WRONG_AUTO_KEY = 1075
ER_READY = 1076
OBSOLETE_ER_NORMAL_SHUTDOWN = 1077
OBSOLETE_ER_GOT_SIGNAL = 1078
ER_SHUTDOWN_COMPLETE = 1079
ER_FORCING_CLOSE = 1080
ER_IPSOCK_ERROR = 1081
ER_NO_SUCH_INDEX = 1082
ER_WRONG_FIELD_TERMINATORS = 1083
ER_BLOBS_AND_NO_TERMINATED = 1084
ER_TEXTFILE_NOT_READABLE = 1085
ER_FILE_EXISTS_ERROR = 1086
ER_LOAD_INFO = 1087
ER_ALTER_INFO = 1088
ER_WRONG_SUB_KEY = 1089
ER_CANT_REMOVE_ALL_FIELDS = 1090
ER_CANT_DROP_FIELD_OR_KEY = 1091
ER_INSERT_INFO = 1092
ER_UPDATE_TABLE_USED = 1093
ER_NO_SUCH_THREAD = 1094
ER_KILL_DENIED_ERROR = 1095
ER_NO_TABLES_USED = 1096
ER_TOO_BIG_SET = 1097
ER_NO_UNIQUE_LOGFILE = 1098
ER_TABLE_NOT_LOCKED_FOR_WRITE = 1099
ER_TABLE_NOT_LOCKED = 1100
ER_BLOB_CANT_HAVE_DEFAULT = 1101
ER_WRONG_DB_NAME = 1102
ER_WRONG_TABLE_NAME = 1103
ER_TOO_BIG_SELECT = 1104
ER_UNKNOWN_ERROR = 1105
ER_UNKNOWN_PROCEDURE = 1106
ER_WRONG_PARAMCOUNT_TO_PROCEDURE = 1107
ER_WRONG_PARAMETERS_TO_PROCEDURE = 1108
ER_UNKNOWN_TABLE = 1109
ER_FIELD_SPECIFIED_TWICE = 1110
ER_INVALID_GROUP_FUNC_USE = 1111
ER_UNSUPPORTED_EXTENSION = 1112
ER_TABLE_MUST_HAVE_COLUMNS = 1113
ER_RECORD_FILE_FULL = 1114
ER_UNKNOWN_CHARACTER_SET = 1115
ER_TOO_MANY_TABLES = 1116
ER_TOO_MANY_FIELDS = 1117
ER_TOO_BIG_ROWSIZE = 1118
ER_STACK_OVERRUN = 1119
ER_WRONG_OUTER_JOIN_UNUSED = 1120
ER_NULL_COLUMN_IN_INDEX = 1121
ER_CANT_FIND_UDF = 1122
ER_CANT_INITIALIZE_UDF = 1123
ER_UDF_NO_PATHS = 1124
ER_UDF_EXISTS = 1125
ER_CANT_OPEN_LIBRARY = 1126
ER_CANT_FIND_DL_ENTRY = 1127
ER_FUNCTION_NOT_DEFINED = 1128
ER_HOST_IS_BLOCKED = 1129
ER_HOST_NOT_PRIVILEGED = 1130
ER_PASSWORD_ANONYMOUS_USER = 1131
ER_PASSWORD_NOT_ALLOWED = 1132
ER_PASSWORD_NO_MATCH = 1133
ER_UPDATE_INFO = 1134
ER_CANT_CREATE_THREAD = 1135
ER_WRONG_VALUE_COUNT_ON_ROW = 1136
ER_CANT_REOPEN_TABLE = 1137
ER_INVALID_USE_OF_NULL = 1138
ER_REGEXP_ERROR = 1139
ER_MIX_OF_GROUP_FUNC_AND_FIELDS = 1140
ER_NONEXISTING_GRANT = 1141
ER_TABLEACCESS_DENIED_ERROR = 1142
ER_COLUMNACCESS_DENIED_ERROR = 1143
ER_ILLEGAL_GRANT_FOR_TABLE = 1144
ER_GRANT_WRONG_HOST_OR_USER = 1145
ER_NO_SUCH_TABLE = 1146
ER_NONEXISTING_TABLE_GRANT = 1147
ER_NOT_ALLOWED_COMMAND = 1148
ER_SYNTAX_ERROR = 1149
OBSOLETE_ER_UNUSED1 = 1150
OBSOLETE_ER_UNUSED2 = 1151
ER_ABORTING_CONNECTION = 1152
ER_NET_PACKET_TOO_LARGE = 1153
ER_NET_READ_ERROR_FROM_PIPE = 1154
ER_NET_FCNTL_ERROR = 1155
ER_NET_PACKETS_OUT_OF_ORDER = 1156
ER_NET_UNCOMPRESS_ERROR = 1157
ER_NET_READ_ERROR = 1158
ER_NET_READ_INTERRUPTED = 1159
ER_NET_ERROR_ON_WRITE = 1160
ER_NET_WRITE_INTERRUPTED = 1161
ER_TOO_LONG_STRING = 1162
ER_TABLE_CANT_HANDLE_BLOB = 1163
ER_TABLE_CANT_HANDLE_AUTO_INCREMENT = 1164
OBSOLETE_ER_UNUSED3 = 1165
ER_WRONG_COLUMN_NAME = 1166
ER_WRONG_KEY_COLUMN = 1167
ER_WRONG_MRG_TABLE = 1168
ER_DUP_UNIQUE = 1169
ER_BLOB_KEY_WITHOUT_LENGTH = 1170
ER_PRIMARY_CANT_HAVE_NULL = 1171
ER_TOO_MANY_ROWS = 1172
ER_REQUIRES_PRIMARY_KEY = 1173
OBSOLETE_ER_NO_RAID_COMPILED = 1174
ER_UPDATE_WITHOUT_KEY_IN_SAFE_MODE = 1175
ER_KEY_DOES_NOT_EXITS = 1176
ER_CHECK_NO_SUCH_TABLE = 1177
ER_CHECK_NOT_IMPLEMENTED = 1178
ER_CANT_DO_THIS_DURING_AN_TRANSACTION = 1179
ER_ERROR_DURING_COMMIT = 1180
ER_ERROR_DURING_ROLLBACK = 1181
ER_ERROR_DURING_FLUSH_LOGS = 1182
OBSOLETE_ER_ERROR_DURING_CHECKPOINT = 1183
ER_NEW_ABORTING_CONNECTION = 1184
OBSOLETE_ER_DUMP_NOT_IMPLEMENTED = 1185
OBSOLETE_ER_FLUSH_SOURCE_BINLOG_CLOSED = 1186
OBSOLETE_ER_INDEX_REBUILD = 1187
OBSOLETE_ER_MASTER = 1188
OBSOLETE_ER_MASTER_NET_READ = 1189
OBSOLETE_ER_MASTER_NET_WRITE = 1190
ER_SOURCE = 1188
ER_SOURCE_NET_READ = 1189
ER_SOURCE_NET_WRITE = 1190
ER_FT_MATCHING_KEY_NOT_FOUND = 1191
ER_LOCK_OR_ACTIVE_TRANSACTION = 1192
ER_UNKNOWN_SYSTEM_VARIABLE = 1193
ER_CRASHED_ON_USAGE = 1194
ER_CRASHED_ON_REPAIR = 1195
ER_WARNING_NOT_COMPLETE_ROLLBACK = 1196
ER_TRANS_CACHE_FULL = 1197
OBSOLETE_ER_REPLICA_MUST_STOP = 1198
OBSOLETE_ER_SLAVE_NOT_RUNNING = 1199
OBSOLETE_ER_BAD_SLAVE = 1200
OBSOLETE_ER_MASTER_INFO = 1201
OBSOLETE_ER_SLAVE_THREAD = 1202
ER_REPLICA_NOT_RUNNING = 1199
ER_BAD_REPLICA = 1200
ER_SOURCE_INFO = 1201
ER_REPLICA_THREAD = 1202
ER_TOO_MANY_USER_CONNECTIONS = 1203
ER_SET_CONSTANTS_ONLY = 1204
ER_LOCK_WAIT_TIMEOUT = 1205
ER_LOCK_TABLE_FULL = 1206
ER_READ_ONLY_TRANSACTION = 1207
OBSOLETE_ER_DROP_DB_WITH_READ_LOCK = 1208
OBSOLETE_ER_CREATE_DB_WITH_READ_LOCK = 1209
ER_WRONG_ARGUMENTS = 1210
ER_NO_PERMISSION_TO_CREATE_USER = 1211
OBSOLETE_ER_UNION_TABLES_IN_DIFFERENT_DIR = 1212
ER_LOCK_DEADLOCK = 1213
ER_TABLE_CANT_HANDLE_FT = 1214
ER_CANNOT_ADD_FOREIGN = 1215
ER_NO_REFERENCED_ROW = 1216
ER_ROW_IS_REFERENCED = 1217
OBSOLETE_ER_CONNECT_TO_MASTER = 1218
OBSOLETE_ER_QUERY_ON_MASTER = 1219
ER_CONNECT_TO_SOURCE = 1218
OBSOLETE_ER_QUERY_ON_SOURCE = 1219
ER_ERROR_WHEN_EXECUTING_COMMAND = 1220
ER_WRONG_USAGE = 1221
ER_WRONG_NUMBER_OF_COLUMNS_IN_SELECT = 1222
ER_CANT_UPDATE_WITH_READLOCK = 1223
ER_MIXING_NOT_ALLOWED = 1224
ER_DUP_ARGUMENT = 1225
ER_USER_LIMIT_REACHED = 1226
ER_SPECIFIC_ACCESS_DENIED_ERROR = 1227
ER_LOCAL_VARIABLE = 1228
ER_GLOBAL_VARIABLE = 1229
ER_NO_DEFAULT = 1230
ER_WRONG_VALUE_FOR_VAR = 1231
ER_WRONG_TYPE_FOR_VAR = 1232
ER_VAR_CANT_BE_READ = 1233
ER_CANT_USE_OPTION_HERE = 1234
ER_NOT_SUPPORTED_YET = 1235
OBSOLETE_ER_MASTER_FATAL_ERROR_READING_BINLOG = 1236
OBSOLETE_ER_SLAVE_IGNORED_TABLE = 1237
ER_SOURCE_FATAL_ERROR_READING_BINLOG = 1236
ER_REPLICA_IGNORED_TABLE = 1237
ER_INCORRECT_GLOBAL_LOCAL_VAR = 1238
ER_WRONG_FK_DEF = 1239
ER_KEY_REF_DO_NOT_MATCH_TABLE_REF = 1240
ER_OPERAND_COLUMNS = 1241
ER_SUBQUERY_NO_1_ROW = 1242
ER_UNKNOWN_STMT_HANDLER = 1243
ER_CORRUPT_HELP_DB = 1244
OBSOLETE_ER_CYCLIC_REFERENCE = 1245
ER_AUTO_CONVERT = 1246
ER_ILLEGAL_REFERENCE = 1247
ER_DERIVED_MUST_HAVE_ALIAS = 1248
ER_SELECT_REDUCED = 1249
ER_TABLENAME_NOT_ALLOWED_HERE = 1250
ER_NOT_SUPPORTED_AUTH_MODE = 1251
ER_SPATIAL_CANT_HAVE_NULL = 1252
ER_COLLATION_CHARSET_MISMATCH = 1253
OBSOLETE_ER_SLAVE_WAS_RUNNING = 1254
OBSOLETE_ER_SLAVE_WAS_NOT_RUNNING = 1255
OBSOLETE_ER_REPLICA_WAS_RUNNING = 1254
OBSOLETE_ER_REPLICA_WAS_NOT_RUNNING = 1255
ER_TOO_BIG_FOR_UNCOMPRESS = 1256
ER_ZLIB_Z_MEM_ERROR = 1257
ER_ZLIB_Z_BUF_ERROR = 1258
ER_ZLIB_Z_DATA_ERROR = 1259
ER_CUT_VALUE_GROUP_CONCAT = 1260
ER_WARN_TOO_FEW_RECORDS = 1261
ER_WARN_TOO_MANY_RECORDS = 1262
ER_WARN_NULL_TO_NOTNULL = 1263
ER_WARN_DATA_OUT_OF_RANGE = 1264
WARN_DATA_TRUNCATED = 1265
ER_WARN_USING_OTHER_HANDLER = 1266
ER_CANT_AGGREGATE_2COLLATIONS = 1267
OBSOLETE_ER_DROP_USER = 1268
ER_REVOKE_GRANTS = 1269
ER_CANT_AGGREGATE_3COLLATIONS = 1270
ER_CANT_AGGREGATE_NCOLLATIONS = 1271
ER_VARIABLE_IS_NOT_STRUCT = 1272
ER_UNKNOWN_COLLATION = 1273
OBSOLETE_ER_SLAVE_IGNORED_SSL_PARAMS = 1274
ER_REPLICA_IGNORED_SSL_PARAMS = 1274
OBSOLETE_ER_SERVER_IS_IN_SECURE_AUTH_MODE = 1275
ER_WARN_FIELD_RESOLVED = 1276
OBSOLETE_ER_BAD_SLAVE_UNTIL_COND = 1277
OBSOLETE_ER_MISSING_SKIP_SLAVE = 1278
ER_BAD_REPLICA_UNTIL_COND = 1277
ER_MISSING_SKIP_REPLICA = 1278
ER_UNTIL_COND_IGNORED = 1279
ER_WRONG_NAME_FOR_INDEX = 1280
ER_WRONG_NAME_FOR_CATALOG = 1281
OBSOLETE_ER_WARN_QC_RESIZE = 1282
ER_BAD_FT_COLUMN = 1283
ER_UNKNOWN_KEY_CACHE = 1284
ER_WARN_HOSTNAME_WONT_WORK = 1285
ER_UNKNOWN_STORAGE_ENGINE = 1286
ER_WARN_DEPRECATED_SYNTAX = 1287
ER_NON_UPDATABLE_TABLE = 1288
ER_FEATURE_DISABLED = 1289
ER_OPTION_PREVENTS_STATEMENT = 1290
ER_DUPLICATED_VALUE_IN_TYPE = 1291
ER_TRUNCATED_WRONG_VALUE = 1292
OBSOLETE_ER_TOO_MUCH_AUTO_TIMESTAMP_COLS = 1293
ER_INVALID_ON_UPDATE = 1294
ER_UNSUPPORTED_PS = 1295
ER_GET_ERRMSG = 1296
ER_GET_TEMPORARY_ERRMSG = 1297
ER_UNKNOWN_TIME_ZONE = 1298
ER_WARN_INVALID_TIMESTAMP = 1299
ER_INVALID_CHARACTER_STRING = 1300
ER_WARN_ALLOWED_PACKET_OVERFLOWED = 1301
ER_CONFLICTING_DECLARATIONS = 1302
ER_SP_NO_RECURSIVE_CREATE = 1303
ER_SP_ALREADY_EXISTS = 1304
ER_SP_DOES_NOT_EXIST = 1305
ER_SP_DROP_FAILED = 1306
ER_SP_STORE_FAILED = 1307
ER_SP_LILABEL_MISMATCH = 1308
ER_SP_LABEL_REDEFINE = 1309
ER_SP_LABEL_MISMATCH = 1310
ER_SP_UNINIT_VAR = 1311
ER_SP_BADSELECT = 1312
ER_SP_BADRETURN = 1313
ER_SP_BADSTATEMENT = 1314
ER_UPDATE_LOG_DEPRECATED_IGNORED = 1315
ER_UPDATE_LOG_DEPRECATED_TRANSLATED = 1316
ER_QUERY_INTERRUPTED = 1317
ER_SP_WRONG_NO_OF_ARGS = 1318
ER_SP_COND_MISMATCH = 1319
ER_SP_NORETURN = 1320
ER_SP_NORETURNEND = 1321
ER_SP_BAD_CURSOR_QUERY = 1322
ER_SP_BAD_CURSOR_SELECT = 1323
ER_SP_CURSOR_MISMATCH = 1324
ER_SP_CURSOR_ALREADY_OPEN = 1325
ER_SP_CURSOR_NOT_OPEN = 1326
ER_SP_UNDECLARED_VAR = 1327
ER_SP_WRONG_NO_OF_FETCH_ARGS = 1328
ER_SP_FETCH_NO_DATA = 1329
ER_SP_DUP_PARAM = 1330
ER_SP_DUP_VAR = 1331
ER_SP_DUP_COND = 1332
ER_SP_DUP_CURS = 1333
ER_SP_CANT_ALTER = 1334
ER_SP_SUBSELECT_NYI = 1335
ER_STMT_NOT_ALLOWED_IN_SF_OR_TRG = 1336
ER_SP_VARCOND_AFTER_CURSHNDLR = 1337
ER_SP_CURSOR_AFTER_HANDLER = 1338
ER_SP_CASE_NOT_FOUND = 1339
ER_FPARSER_TOO_BIG_FILE = 1340
ER_FPARSER_BAD_HEADER = 1341
ER_FPARSER_EOF_IN_COMMENT = 1342
ER_FPARSER_ERROR_IN_PARAMETER = 1343
ER_FPARSER_EOF_IN_UNKNOWN_PARAMETER = 1344
ER_VIEW_NO_EXPLAIN = 1345
OBSOLETE_ER_FRM_UNKNOWN_TYPE = 1346
ER_WRONG_OBJECT = 1347
ER_NONUPDATEABLE_COLUMN = 1348
OBSOLETE_ER_VIEW_SELECT_DERIVED_UNUSED = 1349
ER_VIEW_SELECT_CLAUSE = 1350
ER_VIEW_SELECT_VARIABLE = 1351
ER_VIEW_SELECT_TMPTABLE = 1352
ER_VIEW_WRONG_LIST = 1353
ER_WARN_VIEW_MERGE = 1354
ER_WARN_VIEW_WITHOUT_KEY = 1355
ER_VIEW_INVALID = 1356
ER_SP_NO_DROP_SP = 1357
OBSOLETE_ER_SP_GOTO_IN_HNDLR = 1358
ER_TRG_ALREADY_EXISTS = 1359
ER_TRG_DOES_NOT_EXIST = 1360
ER_TRG_ON_VIEW_OR_TEMP_TABLE = 1361
ER_TRG_CANT_CHANGE_ROW = 1362
ER_TRG_NO_SUCH_ROW_IN_TRG = 1363
ER_NO_DEFAULT_FOR_FIELD = 1364
ER_DIVISION_BY_ZERO = 1365
ER_TRUNCATED_WRONG_VALUE_FOR_FIELD = 1366
ER_ILLEGAL_VALUE_FOR_TYPE = 1367
ER_VIEW_NONUPD_CHECK = 1368
ER_VIEW_CHECK_FAILED = 1369
ER_PROCACCESS_DENIED_ERROR = 1370
ER_RELAY_LOG_FAIL = 1371
OBSOLETE_ER_PASSWD_LENGTH = 1372
ER_UNKNOWN_TARGET_BINLOG = 1373
ER_IO_ERR_LOG_INDEX_READ = 1374
ER_BINLOG_PURGE_PROHIBITED = 1375
ER_FSEEK_FAIL = 1376
ER_BINLOG_PURGE_FATAL_ERR = 1377
ER_LOG_IN_USE = 1378
ER_LOG_PURGE_UNKNOWN_ERR = 1379
ER_RELAY_LOG_INIT = 1380
ER_NO_BINARY_LOGGING = 1381
ER_RESERVED_SYNTAX = 1382
OBSOLETE_ER_WSAS_FAILED = 1383
OBSOLETE_ER_DIFF_GROUPS_PROC = 1384
OBSOLETE_ER_NO_GROUP_FOR_PROC = 1385
OBSOLETE_ER_ORDER_WITH_PROC = 1386
OBSOLETE_ER_LOGGING_PROHIBIT_CHANGING_OF = 1387
OBSOLETE_ER_NO_FILE_MAPPING = 1388
OBSOLETE_ER_WRONG_MAGIC = 1389
ER_PS_MANY_PARAM = 1390
ER_KEY_PART_0 = 1391
ER_VIEW_CHECKSUM = 1392
ER_VIEW_MULTIUPDATE = 1393
ER_VIEW_NO_INSERT_FIELD_LIST = 1394
ER_VIEW_DELETE_MERGE_VIEW = 1395
ER_CANNOT_USER = 1396
ER_XAER_NOTA = 1397
ER_XAER_INVAL = 1398
ER_XAER_RMFAIL = 1399
ER_XAER_OUTSIDE = 1400
ER_XAER_RMERR = 1401
ER_XA_RBROLLBACK = 1402
ER_NONEXISTING_PROC_GRANT = 1403
ER_PROC_AUTO_GRANT_FAIL = 1404
ER_PROC_AUTO_REVOKE_FAIL = 1405
ER_DATA_TOO_LONG = 1406
ER_SP_BAD_SQLSTATE = 1407
ER_STARTUP = 1408
ER_LOAD_FROM_FIXED_SIZE_ROWS_TO_VAR = 1409
ER_CANT_CREATE_USER_WITH_GRANT = 1410
ER_WRONG_VALUE_FOR_TYPE = 1411
ER_TABLE_DEF_CHANGED = 1412
ER_SP_DUP_HANDLER = 1413
ER_SP_NOT_VAR_ARG = 1414
ER_SP_NO_RETSET = 1415
ER_CANT_CREATE_GEOMETRY_OBJECT = 1416
OBSOLETE_ER_FAILED_ROUTINE_BREAK_BINLOG = 1417
ER_BINLOG_UNSAFE_ROUTINE = 1418
ER_BINLOG_CREATE_ROUTINE_NEED_SUPER = 1419
OBSOLETE_ER_EXEC_STMT_WITH_OPEN_CURSOR = 1420
ER_STMT_HAS_NO_OPEN_CURSOR = 1421
ER_COMMIT_NOT_ALLOWED_IN_SF_OR_TRG = 1422
ER_NO_DEFAULT_FOR_VIEW_FIELD = 1423
ER_SP_NO_RECURSION = 1424
ER_TOO_BIG_SCALE = 1425
ER_TOO_BIG_PRECISION = 1426
ER_M_BIGGER_THAN_D = 1427
ER_WRONG_LOCK_OF_SYSTEM_TABLE = 1428
ER_CONNECT_TO_FOREIGN_DATA_SOURCE = 1429
ER_QUERY_ON_FOREIGN_DATA_SOURCE = 1430
ER_FOREIGN_DATA_SOURCE_DOESNT_EXIST = 1431
ER_FOREIGN_DATA_STRING_INVALID_CANT_CREATE = 1432
ER_FOREIGN_DATA_STRING_INVALID = 1433
OBSOLETE_ER_CANT_CREATE_FEDERATED_TABLE = 1434
ER_TRG_IN_WRONG_SCHEMA = 1435
ER_STACK_OVERRUN_NEED_MORE = 1436
ER_TOO_LONG_BODY = 1437
ER_WARN_CANT_DROP_DEFAULT_KEYCACHE = 1438
ER_TOO_BIG_DISPLAYWIDTH = 1439
ER_XAER_DUPID = 1440
ER_DATETIME_FUNCTION_OVERFLOW = 1441
ER_CANT_UPDATE_USED_TABLE_IN_SF_OR_TRG = 1442
ER_VIEW_PREVENT_UPDATE = 1443
ER_PS_NO_RECURSION = 1444
ER_SP_CANT_SET_AUTOCOMMIT = 1445
OBSOLETE_ER_MALFORMED_DEFINER = 1446
ER_VIEW_FRM_NO_USER = 1447
ER_VIEW_OTHER_USER = 1448
ER_NO_SUCH_USER = 1449
ER_FORBID_SCHEMA_CHANGE = 1450
ER_ROW_IS_REFERENCED_2 = 1451
ER_NO_REFERENCED_ROW_2 = 1452
ER_SP_BAD_VAR_SHADOW = 1453
ER_TRG_NO_DEFINER = 1454
ER_OLD_FILE_FORMAT = 1455
ER_SP_RECURSION_LIMIT = 1456
OBSOLETE_ER_SP_PROC_TABLE_CORRUPT = 1457
ER_SP_WRONG_NAME = 1458
ER_TABLE_NEEDS_UPGRADE = 1459
ER_SP_NO_AGGREGATE = 1460
ER_MAX_PREPARED_STMT_COUNT_REACHED = 1461
ER_VIEW_RECURSIVE = 1462
ER_NON_GROUPING_FIELD_USED = 1463
ER_TABLE_CANT_HANDLE_SPKEYS = 1464
ER_NO_TRIGGERS_ON_SYSTEM_SCHEMA = 1465
ER_REMOVED_SPACES = 1466
ER_AUTOINC_READ_FAILED = 1467
ER_USERNAME = 1468
ER_HOSTNAME = 1469
ER_WRONG_STRING_LENGTH = 1470
ER_NON_INSERTABLE_TABLE = 1471
ER_ADMIN_WRONG_MRG_TABLE = 1472
ER_TOO_HIGH_LEVEL_OF_NESTING_FOR_SELECT = 1473
ER_NAME_BECOMES_EMPTY = 1474
ER_AMBIGUOUS_FIELD_TERM = 1475
ER_FOREIGN_SERVER_EXISTS = 1476
ER_FOREIGN_SERVER_DOESNT_EXIST = 1477
ER_ILLEGAL_HA_CREATE_OPTION = 1478
ER_PARTITION_REQUIRES_VALUES_ERROR = 1479
ER_PARTITION_WRONG_VALUES_ERROR = 1480
ER_PARTITION_MAXVALUE_ERROR = 1481
OBSOLETE_ER_PARTITION_SUBPARTITION_ERROR = 1482
OBSOLETE_ER_PARTITION_SUBPART_MIX_ERROR = 1483
ER_PARTITION_WRONG_NO_PART_ERROR = 1484
ER_PARTITION_WRONG_NO_SUBPART_ERROR = 1485
ER_WRONG_EXPR_IN_PARTITION_FUNC_ERROR = 1486
OBSOLETE_ER_NO_CONST_EXPR_IN_RANGE_OR_LIST_ERROR = 1487
ER_FIELD_NOT_FOUND_PART_ERROR = 1488
OBSOLETE_ER_LIST_OF_FIELDS_ONLY_IN_HASH_ERROR = 1489
ER_INCONSISTENT_PARTITION_INFO_ERROR = 1490
ER_PARTITION_FUNC_NOT_ALLOWED_ERROR = 1491
ER_PARTITIONS_MUST_BE_DEFINED_ERROR = 1492
ER_RANGE_NOT_INCREASING_ERROR = 1493
ER_INCONSISTENT_TYPE_OF_FUNCTIONS_ERROR = 1494
ER_MULTIPLE_DEF_CONST_IN_LIST_PART_ERROR = 1495
ER_PARTITION_ENTRY_ERROR = 1496
ER_MIX_HANDLER_ERROR = 1497
ER_PARTITION_NOT_DEFINED_ERROR = 1498
ER_TOO_MANY_PARTITIONS_ERROR = 1499
ER_SUBPARTITION_ERROR = 1500
ER_CANT_CREATE_HANDLER_FILE = 1501
ER_BLOB_FIELD_IN_PART_FUNC_ERROR = 1502
ER_UNIQUE_KEY_NEED_ALL_FIELDS_IN_PF = 1503
ER_NO_PARTS_ERROR = 1504
ER_PARTITION_MGMT_ON_NONPARTITIONED = 1505
ER_FOREIGN_KEY_ON_PARTITIONED = 1506
ER_DROP_PARTITION_NON_EXISTENT = 1507
ER_DROP_LAST_PARTITION = 1508
ER_COALESCE_ONLY_ON_HASH_PARTITION = 1509
ER_REORG_HASH_ONLY_ON_SAME_NO = 1510
ER_REORG_NO_PARAM_ERROR = 1511
ER_ONLY_ON_RANGE_LIST_PARTITION = 1512
ER_ADD_PARTITION_SUBPART_ERROR = 1513
ER_ADD_PARTITION_NO_NEW_PARTITION = 1514
ER_COALESCE_PARTITION_NO_PARTITION = 1515
ER_REORG_PARTITION_NOT_EXIST = 1516
ER_SAME_NAME_PARTITION = 1517
ER_NO_BINLOG_ERROR = 1518
ER_CONSECUTIVE_REORG_PARTITIONS = 1519
ER_REORG_OUTSIDE_RANGE = 1520
ER_PARTITION_FUNCTION_FAILURE = 1521
OBSOLETE_ER_PART_STATE_ERROR = 1522
ER_LIMITED_PART_RANGE = 1523
ER_PLUGIN_IS_NOT_LOADED = 1524
ER_WRONG_VALUE = 1525
ER_NO_PARTITION_FOR_GIVEN_VALUE = 1526
ER_FILEGROUP_OPTION_ONLY_ONCE = 1527
ER_CREATE_FILEGROUP_FAILED = 1528
ER_DROP_FILEGROUP_FAILED = 1529
ER_TABLESPACE_AUTO_EXTEND_ERROR = 1530
ER_WRONG_SIZE_NUMBER = 1531
ER_SIZE_OVERFLOW_ERROR = 1532
ER_ALTER_FILEGROUP_FAILED = 1533
ER_BINLOG_ROW_LOGGING_FAILED = 1534
OBSOLETE_ER_BINLOG_ROW_WRONG_TABLE_DEF = 1535
OBSOLETE_ER_BINLOG_ROW_RBR_TO_SBR = 1536
ER_EVENT_ALREADY_EXISTS = 1537
OBSOLETE_ER_EVENT_STORE_FAILED = 1538
ER_EVENT_DOES_NOT_EXIST = 1539
OBSOLETE_ER_EVENT_CANT_ALTER = 1540
OBSOLETE_ER_EVENT_DROP_FAILED = 1541
ER_EVENT_INTERVAL_NOT_POSITIVE_OR_TOO_BIG = 1542
ER_EVENT_ENDS_BEFORE_STARTS = 1543
ER_EVENT_EXEC_TIME_IN_THE_PAST = 1544
OBSOLETE_ER_EVENT_OPEN_TABLE_FAILED = 1545
OBSOLETE_ER_EVENT_NEITHER_M_EXPR_NOR_M_AT = 1546
OBSOLETE_ER_COL_COUNT_DOESNT_MATCH_CORRUPTED = 1547
OBSOLETE_ER_CANNOT_LOAD_FROM_TABLE = 1548
OBSOLETE_ER_EVENT_CANNOT_DELETE = 1549
OBSOLETE_ER_EVENT_COMPILE_ERROR = 1550
ER_EVENT_SAME_NAME = 1551
OBSOLETE_ER_EVENT_DATA_TOO_LONG = 1552
ER_DROP_INDEX_FK = 1553
ER_WARN_DEPRECATED_SYNTAX_WITH_VER = 1554
OBSOLETE_ER_CANT_WRITE_LOCK_LOG_TABLE = 1555
ER_CANT_LOCK_LOG_TABLE = 1556
ER_FOREIGN_DUPLICATE_KEY_OLD_UNUSED = 1557
ER_COL_COUNT_DOESNT_MATCH_PLEASE_UPDATE = 1558
OBSOLETE_ER_TEMP_TABLE_PREVENTS_SWITCH_OUT_OF_RBR = 1559
ER_STORED_FUNCTION_PREVENTS_SWITCH_BINLOG_FORMAT = 1560
OBSOLETE_ER_NDB_CANT_SWITCH_BINLOG_FORMAT = 1561
ER_PARTITION_NO_TEMPORARY = 1562
ER_PARTITION_CONST_DOMAIN_ERROR = 1563
ER_PARTITION_FUNCTION_IS_NOT_ALLOWED = 1564
OBSOLETE_ER_DDL_LOG_ERROR_UNUSED = 1565
ER_NULL_IN_VALUES_LESS_THAN = 1566
ER_WRONG_PARTITION_NAME = 1567
ER_CANT_CHANGE_TX_CHARACTERISTICS = 1568
ER_DUP_ENTRY_AUTOINCREMENT_CASE = 1569
OBSOLETE_ER_EVENT_MODIFY_QUEUE_ERROR = 1570
ER_EVENT_SET_VAR_ERROR = 1571
ER_PARTITION_MERGE_ERROR = 1572
OBSOLETE_ER_CANT_ACTIVATE_LOG = 1573
OBSOLETE_ER_RBR_NOT_AVAILABLE = 1574
ER_BASE64_DECODE_ERROR = 1575
ER_EVENT_RECURSION_FORBIDDEN = 1576
OBSOLETE_ER_EVENTS_DB_ERROR = 1577
ER_ONLY_INTEGERS_ALLOWED = 1578
ER_UNSUPORTED_LOG_ENGINE = 1579
ER_BAD_LOG_STATEMENT = 1580
ER_CANT_RENAME_LOG_TABLE = 1581
ER_WRONG_PARAMCOUNT_TO_NATIVE_FCT = 1582
ER_WRONG_PARAMETERS_TO_NATIVE_FCT = 1583
ER_WRONG_PARAMETERS_TO_STORED_FCT = 1584
ER_NATIVE_FCT_NAME_COLLISION = 1585
ER_DUP_ENTRY_WITH_KEY_NAME = 1586
ER_BINLOG_PURGE_EMFILE = 1587
ER_EVENT_CANNOT_CREATE_IN_THE_PAST = 1588
ER_EVENT_CANNOT_ALTER_IN_THE_PAST = 1589
OBSOLETE_ER_SLAVE_INCIDENT = 1590
OBSOLETE_ER_REPLICA_INCIDENT = 1590
ER_NO_PARTITION_FOR_GIVEN_VALUE_SILENT = 1591
ER_BINLOG_UNSAFE_STATEMENT = 1592
ER_BINLOG_FATAL_ERROR = 1593
OBSOLETE_ER_SLAVE_RELAY_LOG_READ_FAILURE = 1594
OBSOLETE_ER_SLAVE_RELAY_LOG_WRITE_FAILURE = 1595
OBSOLETE_ER_SLAVE_CREATE_EVENT_FAILURE = 1596
OBSOLETE_ER_SLAVE_MASTER_COM_FAILURE = 1597
OBSOLETE_ER_REPLICA_RELAY_LOG_READ_FAILURE = 1594
OBSOLETE_ER_REPLICA_RELAY_LOG_WRITE_FAILURE = 1595
OBSOLETE_ER_REPLICA_CREATE_EVENT_FAILURE = 1596
OBSOLETE_ER_REPLICA_SOURCE_COM_FAILURE = 1597
ER_BINLOG_LOGGING_IMPOSSIBLE = 1598
ER_VIEW_NO_CREATION_CTX = 1599
ER_VIEW_INVALID_CREATION_CTX = 1600
OBSOLETE_ER_SR_INVALID_CREATION_CTX = 1601
ER_TRG_CORRUPTED_FILE = 1602
ER_TRG_NO_CREATION_CTX = 1603
ER_TRG_INVALID_CREATION_CTX = 1604
ER_EVENT_INVALID_CREATION_CTX = 1605
ER_TRG_CANT_OPEN_TABLE = 1606
OBSOLETE_ER_CANT_CREATE_SROUTINE = 1607
OBSOLETE_ER_NEVER_USED = 1608
ER_NO_FORMAT_DESCRIPTION_EVENT_BEFORE_BINLOG_STATEMENT = 1609
OBSOLETE_ER_SLAVE_CORRUPT_EVENT = 1610
ER_REPLICA_CORRUPT_EVENT = 1610
OBSOLETE_ER_LOAD_DATA_INVALID_COLUMN_UNUSED = 1611
ER_LOG_PURGE_NO_FILE = 1612
ER_XA_RBTIMEOUT = 1613
ER_XA_RBDEADLOCK = 1614
ER_NEED_REPREPARE = 1615
OBSOLETE_ER_DELAYED_NOT_SUPPORTED = 1616
OBSOLETE_WARN_NO_MASTER_INFO = 1617
WARN_NO_SOURCE_INFO = 1617
WARN_OPTION_IGNORED = 1618
ER_PLUGIN_DELETE_BUILTIN = 1619
WARN_PLUGIN_BUSY = 1620
ER_VARIABLE_IS_READONLY = 1621
ER_WARN_ENGINE_TRANSACTION_ROLLBACK = 1622
OBSOLETE_ER_SLAVE_HEARTBEAT_FAILURE = 1623
OBSOLETE_ER_SLAVE_HEARTBEAT_VALUE_OUT_OF_RANGE = 1624
OBSOLETE_ER_REPLICA_HEARTBEAT_FAILURE = 1623
ER_REPLICA_HEARTBEAT_VALUE_OUT_OF_RANGE = 1624
ER_NDB_REPLICATION_SCHEMA_ERROR = 1625
ER_CONFLICT_FN_PARSE_ERROR = 1626
ER_EXCEPTIONS_WRITE_ERROR = 1627
ER_TOO_LONG_TABLE_COMMENT = 1628
ER_TOO_LONG_FIELD_COMMENT = 1629
ER_FUNC_INEXISTENT_NAME_COLLISION = 1630
ER_DATABASE_NAME = 1631
ER_TABLE_NAME = 1632
ER_PARTITION_NAME = 1633
ER_SUBPARTITION_NAME = 1634
ER_TEMPORARY_NAME = 1635
ER_RENAMED_NAME = 1636
ER_TOO_MANY_CONCURRENT_TRXS = 1637
WARN_NON_ASCII_SEPARATOR_NOT_IMPLEMENTED = 1638
ER_DEBUG_SYNC_TIMEOUT = 1639
ER_DEBUG_SYNC_HIT_LIMIT = 1640
ER_DUP_SIGNAL_SET = 1641
ER_SIGNAL_WARN = 1642
ER_SIGNAL_NOT_FOUND = 1643
ER_SIGNAL_EXCEPTION = 1644
ER_RESIGNAL_WITHOUT_ACTIVE_HANDLER = 1645
ER_SIGNAL_BAD_CONDITION_TYPE = 1646
WARN_COND_ITEM_TRUNCATED = 1647
ER_COND_ITEM_TOO_LONG = 1648
ER_UNKNOWN_LOCALE = 1649
OBSOLETE_ER_SLAVE_IGNORE_SERVER_IDS = 1650
ER_REPLICA_IGNORE_SERVER_IDS = 1650
OBSOLETE_ER_QUERY_CACHE_DISABLED = 1651
ER_SAME_NAME_PARTITION_FIELD = 1652
ER_PARTITION_COLUMN_LIST_ERROR = 1653
ER_WRONG_TYPE_COLUMN_VALUE_ERROR = 1654
ER_TOO_MANY_PARTITION_FUNC_FIELDS_ERROR = 1655
ER_MAXVALUE_IN_VALUES_IN = 1656
ER_TOO_MANY_VALUES_ERROR = 1657
ER_ROW_SINGLE_PARTITION_FIELD_ERROR = 1658
ER_FIELD_TYPE_NOT_ALLOWED_AS_PARTITION_FIELD = 1659
ER_PARTITION_FIELDS_TOO_LONG = 1660
ER_BINLOG_ROW_ENGINE_AND_STMT_ENGINE = 1661
ER_BINLOG_ROW_MODE_AND_STMT_ENGINE = 1662
ER_BINLOG_UNSAFE_AND_STMT_ENGINE = 1663
ER_BINLOG_ROW_INJECTION_AND_STMT_ENGINE = 1664
ER_BINLOG_STMT_MODE_AND_ROW_ENGINE = 1665
ER_BINLOG_ROW_INJECTION_AND_STMT_MODE = 1666
ER_BINLOG_MULTIPLE_ENGINES_AND_SELF_LOGGING_ENGINE = 1667
ER_BINLOG_UNSAFE_LIMIT = 1668
OBSOLETE_ER_UNUSED4 = 1669
ER_BINLOG_UNSAFE_SYSTEM_TABLE = 1670
ER_BINLOG_UNSAFE_AUTOINC_COLUMNS = 1671
ER_BINLOG_UNSAFE_UDF = 1672
ER_BINLOG_UNSAFE_SYSTEM_VARIABLE = 1673
ER_BINLOG_UNSAFE_SYSTEM_FUNCTION = 1674
ER_BINLOG_UNSAFE_NONTRANS_AFTER_TRANS = 1675
ER_MESSAGE_AND_STATEMENT = 1676
OBSOLETE_ER_SLAVE_CONVERSION_FAILED = 1677
OBSOLETE_ER_SLAVE_CANT_CREATE_CONVERSION = 1678
OBSOLETE_ER_REPLICA_CONVERSION_FAILED = 1677
ER_REPLICA_CANT_CREATE_CONVERSION = 1678
ER_INSIDE_TRANSACTION_PREVENTS_SWITCH_BINLOG_FORMAT = 1679
ER_PATH_LENGTH = 1680
ER_WARN_DEPRECATED_SYNTAX_NO_REPLACEMENT = 1681
ER_WRONG_NATIVE_TABLE_STRUCTURE = 1682
ER_WRONG_PERFSCHEMA_USAGE = 1683
ER_WARN_I_S_SKIPPED_TABLE = 1684
ER_INSIDE_TRANSACTION_PREVENTS_SWITCH_BINLOG_DIRECT = 1685
ER_STORED_FUNCTION_PREVENTS_SWITCH_BINLOG_DIRECT = 1686
ER_SPATIAL_MUST_HAVE_GEOM_COL = 1687
ER_TOO_LONG_INDEX_COMMENT = 1688
ER_LOCK_ABORTED = 1689
ER_DATA_OUT_OF_RANGE = 1690
OBSOLETE_ER_WRONG_SPVAR_TYPE_IN_LIMIT = 1691
ER_BINLOG_UNSAFE_MULTIPLE_ENGINES_AND_SELF_LOGGING_ENGINE = 1692
ER_BINLOG_UNSAFE_MIXED_STATEMENT = 1693
ER_INSIDE_TRANSACTION_PREVENTS_SWITCH_SQL_LOG_BIN = 1694
ER_STORED_FUNCTION_PREVENTS_SWITCH_SQL_LOG_BIN = 1695
ER_FAILED_READ_FROM_PAR_FILE = 1696
ER_VALUES_IS_NOT_INT_TYPE_ERROR = 1697
ER_ACCESS_DENIED_NO_PASSWORD_ERROR = 1698
ER_SET_PASSWORD_AUTH_PLUGIN = 1699
OBSOLETE_ER_GRANT_PLUGIN_USER_EXISTS = 1700
ER_TRUNCATE_ILLEGAL_FK = 1701
ER_PLUGIN_IS_PERMANENT = 1702
OBSOLETE_ER_SLAVE_HEARTBEAT_VALUE_OUT_OF_RANGE_MIN = 1703
OBSOLETE_ER_SLAVE_HEARTBEAT_VALUE_OUT_OF_RANGE_MAX = 1704
ER_REPLICA_HEARTBEAT_VALUE_OUT_OF_RANGE_MIN = 1703
ER_REPLICA_HEARTBEAT_VALUE_OUT_OF_RANGE_MAX = 1704
ER_STMT_CACHE_FULL = 1705
ER_MULTI_UPDATE_KEY_CONFLICT = 1706
ER_TABLE_NEEDS_REBUILD = 1707
WARN_OPTION_BELOW_LIMIT = 1708
ER_INDEX_COLUMN_TOO_LONG = 1709
ER_ERROR_IN_TRIGGER_BODY = 1710
ER_ERROR_IN_UNKNOWN_TRIGGER_BODY = 1711
ER_INDEX_CORRUPT = 1712
ER_UNDO_RECORD_TOO_BIG = 1713
ER_BINLOG_UNSAFE_INSERT_IGNORE_SELECT = 1714
ER_BINLOG_UNSAFE_INSERT_SELECT_UPDATE = 1715
ER_BINLOG_UNSAFE_REPLACE_SELECT = 1716
ER_BINLOG_UNSAFE_CREATE_IGNORE_SELECT = 1717
ER_BINLOG_UNSAFE_CREATE_REPLACE_SELECT = 1718
ER_BINLOG_UNSAFE_UPDATE_IGNORE = 1719
ER_PLUGIN_NO_UNINSTALL = 1720
ER_PLUGIN_NO_INSTALL = 1721
ER_BINLOG_UNSAFE_WRITE_AUTOINC_SELECT = 1722
ER_BINLOG_UNSAFE_CREATE_SELECT_AUTOINC = 1723
ER_BINLOG_UNSAFE_INSERT_TWO_KEYS = 1724
ER_TABLE_IN_FK_CHECK = 1725
ER_UNSUPPORTED_ENGINE = 1726
ER_BINLOG_UNSAFE_AUTOINC_NOT_FIRST = 1727
ER_CANNOT_LOAD_FROM_TABLE_V2 = 1728
OBSOLETE_ER_MASTER_DELAY_VALUE_OUT_OF_RANGE = 1729
ER_SOURCE_DELAY_VALUE_OUT_OF_RANGE = 1729
ER_ONLY_FD_AND_RBR_EVENTS_ALLOWED_IN_BINLOG_STATEMENT = 1730
ER_PARTITION_EXCHANGE_DIFFERENT_OPTION = 1731
ER_PARTITION_EXCHANGE_PART_TABLE = 1732
ER_PARTITION_EXCHANGE_TEMP_TABLE = 1733
ER_PARTITION_INSTEAD_OF_SUBPARTITION = 1734
ER_UNKNOWN_PARTITION = 1735
ER_TABLES_DIFFERENT_METADATA = 1736
ER_ROW_DOES_NOT_MATCH_PARTITION = 1737
ER_BINLOG_CACHE_SIZE_GREATER_THAN_MAX = 1738
ER_WARN_INDEX_NOT_APPLICABLE = 1739
ER_PARTITION_EXCHANGE_FOREIGN_KEY = 1740
OBSOLETE_ER_NO_SUCH_KEY_VALUE = 1741
ER_RPL_INFO_DATA_TOO_LONG = 1742
OBSOLETE_ER_NETWORK_READ_EVENT_CHECKSUM_FAILURE = 1743
OBSOLETE_ER_BINLOG_READ_EVENT_CHECKSUM_FAILURE = 1744
ER_BINLOG_STMT_CACHE_SIZE_GREATER_THAN_MAX = 1745
ER_CANT_UPDATE_TABLE_IN_CREATE_TABLE_SELECT = 1746
ER_PARTITION_CLAUSE_ON_NONPARTITIONED = 1747
ER_ROW_DOES_NOT_MATCH_GIVEN_PARTITION_SET = 1748
OBSOLETE_ER_NO_SUCH_PARTITION__UNUSED = 1749
ER_CHANGE_RPL_INFO_REPOSITORY_FAILURE = 1750
ER_WARNING_NOT_COMPLETE_ROLLBACK_WITH_CREATED_TEMP_TABLE = 1751
ER_WARNING_NOT_COMPLETE_ROLLBACK_WITH_DROPPED_TEMP_TABLE = 1752
ER_MTS_FEATURE_IS_NOT_SUPPORTED = 1753
ER_MTS_UPDATED_DBS_GREATER_MAX = 1754
ER_MTS_CANT_PARALLEL = 1755
ER_MTS_INCONSISTENT_DATA = 1756
ER_FULLTEXT_NOT_SUPPORTED_WITH_PARTITIONING = 1757
ER_DA_INVALID_CONDITION_NUMBER = 1758
ER_INSECURE_PLAIN_TEXT = 1759
OBSOLETE_ER_INSECURE_CHANGE_MASTER = 1760
ER_INSECURE_CHANGE_SOURCE = 1760
ER_FOREIGN_DUPLICATE_KEY_WITH_CHILD_INFO = 1761
ER_FOREIGN_DUPLICATE_KEY_WITHOUT_CHILD_INFO = 1762
OBSOLETE_ER_SQLTHREAD_WITH_SECURE_SLAVE = 1763
ER_SQLTHREAD_WITH_SECURE_REPLICA = 1763
ER_TABLE_HAS_NO_FT = 1764
ER_VARIABLE_NOT_SETTABLE_IN_SF_OR_TRIGGER = 1765
ER_VARIABLE_NOT_SETTABLE_IN_TRANSACTION = 1766
OBSOLETE_ER_GTID_NEXT_IS_NOT_IN_GTID_NEXT_LIST = 1767
OBSOLETE_ER_CANT_CHANGE_GTID_NEXT_IN_TRANSACTION = 1768
ER_SET_STATEMENT_CANNOT_INVOKE_FUNCTION = 1769
ER_GTID_NEXT_CANT_BE_AUTOMATIC_IF_GTID_NEXT_LIST_IS_NON_NULL = 1770
OBSOLETE_ER_SKIPPING_LOGGED_TRANSACTION = 1771
ER_MALFORMED_GTID_SET_SPECIFICATION = 1772
ER_MALFORMED_GTID_SET_ENCODING = 1773
ER_MALFORMED_GTID_SPECIFICATION = 1774
ER_GNO_EXHAUSTED = 1775
OBSOLETE_ER_BAD_SLAVE_AUTO_POSITION = 1776
ER_BAD_REPLICA_AUTO_POSITION = 1776
ER_AUTO_POSITION_REQUIRES_GTID_MODE_NOT_OFF = 1777
ER_CANT_DO_IMPLICIT_COMMIT_IN_TRX_WHEN_GTID_NEXT_IS_SET = 1778
ER_GTID_MODE_ON_REQUIRES_ENFORCE_GTID_CONSISTENCY_ON = 1779
OBSOLETE_ER_GTID_MODE_REQUIRES_BINLOG = 1780
ER_CANT_SET_GTID_NEXT_TO_GTID_WHEN_GTID_MODE_IS_OFF = 1781
ER_CANT_SET_GTID_NEXT_TO_ANONYMOUS_WHEN_GTID_MODE_IS_ON = 1782
ER_CANT_SET_GTID_NEXT_LIST_TO_NON_NULL_WHEN_GTID_MODE_IS_OFF = 1783
OBSOLETE_ER_FOUND_GTID_EVENT_WHEN_GTID_MODE_IS_OFF__UNUSED = 1784
ER_GTID_UNSAFE_NON_TRANSACTIONAL_TABLE = 1785
ER_GTID_UNSAFE_CREATE_SELECT = 1786
OBSOLETE_ER_GTID_UNSAFE_CREATE_DROP_TEMP_TABLE_IN_TRANSACTION = 1787
ER_GTID_MODE_CAN_ONLY_CHANGE_ONE_STEP_AT_A_TIME = 1788
OBSOLETE_ER_MASTER_HAS_PURGED_REQUIRED_GTIDS = 1789
ER_SOURCE_HAS_PURGED_REQUIRED_GTIDS = 1789
ER_CANT_SET_GTID_NEXT_WHEN_OWNING_GTID = 1790
ER_UNKNOWN_EXPLAIN_FORMAT = 1791
ER_CANT_EXECUTE_IN_READ_ONLY_TRANSACTION = 1792
ER_TOO_LONG_TABLE_PARTITION_COMMENT = 1793
OBSOLETE_ER_SLAVE_CONFIGURATION = 1794
ER_REPLICA_CONFIGURATION = 1794
ER_INNODB_FT_LIMIT = 1795
ER_INNODB_NO_FT_TEMP_TABLE = 1796
ER_INNODB_FT_WRONG_DOCID_COLUMN = 1797
ER_INNODB_FT_WRONG_DOCID_INDEX = 1798
ER_INNODB_ONLINE_LOG_TOO_BIG = 1799
ER_UNKNOWN_ALTER_ALGORITHM = 1800
ER_UNKNOWN_ALTER_LOCK = 1801
OBSOLETE_ER_MTS_CHANGE_MASTER_CANT_RUN_WITH_GAPS = 1802
ER_MTS_CHANGE_SOURCE_CANT_RUN_WITH_GAPS = 1802
ER_MTS_RECOVERY_FAILURE = 1803
ER_MTS_RESET_WORKERS = 1804
ER_COL_COUNT_DOESNT_MATCH_CORRUPTED_V2 = 1805
OBSOLETE_ER_SLAVE_SILENT_RETRY_TRANSACTION = 1806
ER_REPLICA_SILENT_RETRY_TRANSACTION = 1806
ER_DISCARD_FK_CHECKS_RUNNING = 1807
ER_TABLE_SCHEMA_MISMATCH = 1808
ER_TABLE_IN_SYSTEM_TABLESPACE = 1809
ER_IO_READ_ERROR = 1810
ER_IO_WRITE_ERROR = 1811
ER_TABLESPACE_MISSING = 1812
ER_TABLESPACE_EXISTS = 1813
ER_TABLESPACE_DISCARDED = 1814
ER_INTERNAL_ERROR = 1815
ER_INNODB_IMPORT_ERROR = 1816
ER_INNODB_INDEX_CORRUPT = 1817
ER_INVALID_YEAR_COLUMN_LENGTH = 1818
ER_NOT_VALID_PASSWORD = 1819
ER_MUST_CHANGE_PASSWORD = 1820
ER_FK_NO_INDEX_CHILD = 1821
ER_FK_NO_INDEX_PARENT = 1822
ER_FK_FAIL_ADD_SYSTEM = 1823
ER_FK_CANNOT_OPEN_PARENT = 1824
ER_FK_INCORRECT_OPTION = 1825
ER_FK_DUP_NAME = 1826
ER_PASSWORD_FORMAT = 1827
ER_FK_COLUMN_CANNOT_DROP = 1828
ER_FK_COLUMN_CANNOT_DROP_CHILD = 1829
ER_FK_COLUMN_NOT_NULL = 1830
ER_DUP_INDEX = 1831
ER_FK_COLUMN_CANNOT_CHANGE = 1832
ER_FK_COLUMN_CANNOT_CHANGE_CHILD = 1833
OBSOLETE_ER_UNUSED5 = 1834
ER_MALFORMED_PACKET = 1835
ER_READ_ONLY_MODE = 1836
ER_GTID_NEXT_TYPE_UNDEFINED_GTID = 1837
ER_VARIABLE_NOT_SETTABLE_IN_SP = 1838
OBSOLETE_ER_CANT_SET_GTID_PURGED_WHEN_GTID_MODE_IS_OFF = 1839
ER_CANT_SET_GTID_PURGED_WHEN_GTID_EXECUTED_IS_NOT_EMPTY = 1840
ER_CANT_SET_GTID_PURGED_WHEN_OWNED_GTIDS_IS_NOT_EMPTY = 1841
ER_GTID_PURGED_WAS_CHANGED = 1842
ER_GTID_EXECUTED_WAS_CHANGED = 1843
ER_BINLOG_STMT_MODE_AND_NO_REPL_TABLES = 1844
ER_ALTER_OPERATION_NOT_SUPPORTED = 1845
ER_ALTER_OPERATION_NOT_SUPPORTED_REASON = 1846
ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_COPY = 1847
ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_PARTITION = 1848
ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_FK_RENAME = 1849
ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_COLUMN_TYPE = 1850
ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_FK_CHECK = 1851
OBSOLETE_ER_UNUSED6 = 1852
ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_NOPK = 1853
ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_AUTOINC = 1854
ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_HIDDEN_FTS = 1855
ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_CHANGE_FTS = 1856
ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_FTS = 1857
OBSOLETE_ER_SQL_SLAVE_SKIP_COUNTER_NOT_SETTABLE_IN_GTID_MODE = 1858
ER_SQL_REPLICA_SKIP_COUNTER_NOT_SETTABLE_IN_GTID_MODE = 1858
ER_DUP_UNKNOWN_IN_INDEX = 1859
ER_IDENT_CAUSES_TOO_LONG_PATH = 1860
ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_NOT_NULL = 1861
ER_MUST_CHANGE_PASSWORD_LOGIN = 1862
ER_ROW_IN_WRONG_PARTITION = 1863
ER_MTS_EVENT_BIGGER_PENDING_JOBS_SIZE_MAX = 1864
OBSOLETE_ER_INNODB_NO_FT_USES_PARSER = 1865
ER_BINLOG_LOGICAL_CORRUPTION = 1866
ER_WARN_PURGE_LOG_IN_USE = 1867
ER_WARN_PURGE_LOG_IS_ACTIVE = 1868
ER_AUTO_INCREMENT_CONFLICT = 1869
WARN_ON_BLOCKHOLE_IN_RBR = 1870
OBSOLETE_ER_SLAVE_MI_INIT_REPOSITORY = 1871
OBSOLETE_ER_SLAVE_RLI_INIT_REPOSITORY = 1872
ER_REPLICA_MI_INIT_REPOSITORY = 1871
ER_REPLICA_RLI_INIT_REPOSITORY = 1872
ER_ACCESS_DENIED_CHANGE_USER_ERROR = 1873
ER_INNODB_READ_ONLY = 1874
OBSOLETE_ER_STOP_SLAVE_SQL_THREAD_TIMEOUT = 1875
OBSOLETE_ER_STOP_SLAVE_IO_THREAD_TIMEOUT = 1876
ER_STOP_REPLICA_SQL_THREAD_TIMEOUT = 1875
ER_STOP_REPLICA_IO_THREAD_TIMEOUT = 1876
ER_TABLE_CORRUPT = 1877
ER_TEMP_FILE_WRITE_FAILURE = 1878
ER_INNODB_FT_AUX_NOT_HEX_ID = 1879
ER_OLD_TEMPORALS_UPGRADED = 1880
ER_INNODB_FORCED_RECOVERY = 1881
ER_AES_INVALID_IV = 1882
ER_PLUGIN_CANNOT_BE_UNINSTALLED = 1883
ER_GTID_UNSAFE_BINLOG_SPLITTABLE_STATEMENT_AND_ASSIGNED_GTID = 1884
OBSOLETE_ER_SLAVE_HAS_MORE_GTIDS_THAN_MASTER = 1885
ER_REPLICA_HAS_MORE_GTIDS_THAN_SOURCE = 1885
ER_MISSING_KEY = 1886
WARN_NAMED_PIPE_ACCESS_EVERYONE = 1887
ER_FILE_CORRUPT = 3000
OBSOLETE_ER_ERROR_ON_MASTER = 3001
ER_ERROR_ON_SOURCE = 3001
OBSOLETE_ER_INCONSISTENT_ERROR = 3002
ER_STORAGE_ENGINE_NOT_LOADED = 3003
ER_GET_STACKED_DA_WITHOUT_ACTIVE_HANDLER = 3004
ER_WARN_LEGACY_SYNTAX_CONVERTED = 3005
ER_BINLOG_UNSAFE_FULLTEXT_PLUGIN = 3006
ER_CANNOT_DISCARD_TEMPORARY_TABLE = 3007
ER_FK_DEPTH_EXCEEDED = 3008
ER_COL_COUNT_DOESNT_MATCH_PLEASE_UPDATE_V2 = 3009
ER_WARN_TRIGGER_DOESNT_HAVE_CREATED = 3010
ER_REFERENCED_TRG_DOES_NOT_EXIST = 3011
ER_EXPLAIN_NOT_SUPPORTED = 3012
ER_INVALID_FIELD_SIZE = 3013
ER_MISSING_HA_CREATE_OPTION = 3014
ER_ENGINE_OUT_OF_MEMORY = 3015
ER_PASSWORD_EXPIRE_ANONYMOUS_USER = 3016
OBSOLETE_ER_SLAVE_SQL_THREAD_MUST_STOP = 3017
ER_REPLICA_SQL_THREAD_MUST_STOP = 3017
ER_NO_FT_MATERIALIZED_SUBQUERY = 3018
ER_INNODB_UNDO_LOG_FULL = 3019
ER_INVALID_ARGUMENT_FOR_LOGARITHM = 3020
OBSOLETE_ER_SLAVE_CHANNEL_IO_THREAD_MUST_STOP = 3021
ER_REPLICA_CHANNEL_IO_THREAD_MUST_STOP = 3021
ER_WARN_OPEN_TEMP_TABLES_MUST_BE_ZERO = 3022
OBSOLETE_ER_WARN_ONLY_MASTER_LOG_FILE_NO_POS = 3023
ER_WARN_ONLY_SOURCE_LOG_FILE_NO_POS = 3023
ER_QUERY_TIMEOUT = 3024
ER_NON_RO_SELECT_DISABLE_TIMER = 3025
ER_DUP_LIST_ENTRY = 3026
OBSOLETE_ER_SQL_MODE_NO_EFFECT = 3027
ER_AGGREGATE_ORDER_FOR_UNION = 3028
ER_AGGREGATE_ORDER_NON_AGG_QUERY = 3029
OBSOLETE_ER_SLAVE_WORKER_STOPPED_PREVIOUS_THD_ERROR = 3030
OBSOLETE_ER_DONT_SUPPORT_SLAVE_PRESERVE_COMMIT_ORDER = 3031
ER_REPLICA_WORKER_STOPPED_PREVIOUS_THD_ERROR = 3030
ER_DONT_SUPPORT_REPLICA_PRESERVE_COMMIT_ORDER = 3031
ER_SERVER_OFFLINE_MODE = 3032
ER_GIS_DIFFERENT_SRIDS = 3033
ER_GIS_UNSUPPORTED_ARGUMENT = 3034
ER_GIS_UNKNOWN_ERROR = 3035
ER_GIS_UNKNOWN_EXCEPTION = 3036
ER_GIS_INVALID_DATA = 3037
ER_BOOST_GEOMETRY_EMPTY_INPUT_EXCEPTION = 3038
ER_BOOST_GEOMETRY_CENTROID_EXCEPTION = 3039
ER_BOOST_GEOMETRY_OVERLAY_INVALID_INPUT_EXCEPTION = 3040
ER_BOOST_GEOMETRY_TURN_INFO_EXCEPTION = 3041
ER_BOOST_GEOMETRY_SELF_INTERSECTION_POINT_EXCEPTION = 3042
ER_BOOST_GEOMETRY_UNKNOWN_EXCEPTION = 3043
ER_STD_BAD_ALLOC_ERROR = 3044
ER_STD_DOMAIN_ERROR = 3045
ER_STD_LENGTH_ERROR = 3046
ER_STD_INVALID_ARGUMENT = 3047
ER_STD_OUT_OF_RANGE_ERROR = 3048
ER_STD_OVERFLOW_ERROR = 3049
ER_STD_RANGE_ERROR = 3050
ER_STD_UNDERFLOW_ERROR = 3051
ER_STD_LOGIC_ERROR = 3052
ER_STD_RUNTIME_ERROR = 3053
ER_STD_UNKNOWN_EXCEPTION = 3054
ER_GIS_DATA_WRONG_ENDIANESS = 3055
OBSOLETE_ER_CHANGE_MASTER_PASSWORD_LENGTH = 3056
ER_CHANGE_SOURCE_PASSWORD_LENGTH = 3056
ER_USER_LOCK_WRONG_NAME = 3057
ER_USER_LOCK_DEADLOCK = 3058
ER_REPLACE_INACCESSIBLE_ROWS = 3059
ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_GIS = 3060
ER_ILLEGAL_USER_VAR = 3061
ER_GTID_MODE_OFF = 3062
OBSOLETE_ER_UNSUPPORTED_BY_REPLICATION_THREAD = 3063
ER_INCORRECT_TYPE = 3064
ER_FIELD_IN_ORDER_NOT_SELECT = 3065
ER_AGGREGATE_IN_ORDER_NOT_SELECT = 3066
ER_INVALID_RPL_WILD_TABLE_FILTER_PATTERN = 3067
ER_NET_OK_PACKET_TOO_LARGE = 3068
ER_INVALID_JSON_DATA = 3069
ER_INVALID_GEOJSON_MISSING_MEMBER = 3070
ER_INVALID_GEOJSON_WRONG_TYPE = 3071
ER_INVALID_GEOJSON_UNSPECIFIED = 3072
ER_DIMENSION_UNSUPPORTED = 3073
OBSOLETE_ER_SLAVE_CHANNEL_DOES_NOT_EXIST = 3074
OBSOLETE_ER_SLAVE_MULTIPLE_CHANNELS_HOST_PORT = 3075
OBSOLETE_ER_SLAVE_CHANNEL_NAME_INVALID_OR_TOO_LONG = 3076
OBSOLETE_ER_SLAVE_NEW_CHANNEL_WRONG_REPOSITORY = 3077
OBSOLETE_ER_SLAVE_CHANNEL_DELETE = 3078
OBSOLETE_ER_SLAVE_MULTIPLE_CHANNELS_CMD = 3079
OBSOLETE_ER_SLAVE_MAX_CHANNELS_EXCEEDED = 3080
OBSOLETE_ER_SLAVE_CHANNEL_MUST_STOP = 3081
OBSOLETE_ER_SLAVE_CHANNEL_NOT_RUNNING = 3082
OBSOLETE_ER_SLAVE_CHANNEL_WAS_RUNNING = 3083
OBSOLETE_ER_SLAVE_CHANNEL_WAS_NOT_RUNNING = 3084
OBSOLETE_ER_SLAVE_CHANNEL_SQL_THREAD_MUST_STOP = 3085
OBSOLETE_ER_SLAVE_CHANNEL_SQL_SKIP_COUNTER = 3086
ER_REPLICA_CHANNEL_DOES_NOT_EXIST = 3074
OBSOLETE_ER_REPLICA_MULTIPLE_CHANNELS_HOST_PORT = 3075
ER_REPLICA_CHANNEL_NAME_INVALID_OR_TOO_LONG = 3076
ER_REPLICA_NEW_CHANNEL_WRONG_REPOSITORY = 3077
OBSOLETE_ER_REPLICA_CHANNEL_DELETE = 3078
ER_REPLICA_MULTIPLE_CHANNELS_CMD = 3079
ER_REPLICA_MAX_CHANNELS_EXCEEDED = 3080
ER_REPLICA_CHANNEL_MUST_STOP = 3081
ER_REPLICA_CHANNEL_NOT_RUNNING = 3082
ER_REPLICA_CHANNEL_WAS_RUNNING = 3083
ER_REPLICA_CHANNEL_WAS_NOT_RUNNING = 3084
ER_REPLICA_CHANNEL_SQL_THREAD_MUST_STOP = 3085
ER_REPLICA_CHANNEL_SQL_SKIP_COUNTER = 3086
ER_WRONG_FIELD_WITH_GROUP_V2 = 3087
ER_MIX_OF_GROUP_FUNC_AND_FIELDS_V2 = 3088
ER_WARN_DEPRECATED_SYSVAR_UPDATE = 3089
ER_WARN_DEPRECATED_SQLMODE = 3090
ER_CANNOT_LOG_PARTIAL_DROP_DATABASE_WITH_GTID = 3091
ER_GROUP_REPLICATION_CONFIGURATION = 3092
ER_GROUP_REPLICATION_RUNNING = 3093
ER_GROUP_REPLICATION_APPLIER_INIT_ERROR = 3094
ER_GROUP_REPLICATION_STOP_APPLIER_THREAD_TIMEOUT = 3095
ER_GROUP_REPLICATION_COMMUNICATION_LAYER_SESSION_ERROR = 3096
ER_GROUP_REPLICATION_COMMUNICATION_LAYER_JOIN_ERROR = 3097
ER_BEFORE_DML_VALIDATION_ERROR = 3098
ER_PREVENTS_VARIABLE_WITHOUT_RBR = 3099
ER_RUN_HOOK_ERROR = 3100
ER_TRANSACTION_ROLLBACK_DURING_COMMIT = 3101
ER_GENERATED_COLUMN_FUNCTION_IS_NOT_ALLOWED = 3102
ER_UNSUPPORTED_ALTER_INPLACE_ON_VIRTUAL_COLUMN = 3103
ER_WRONG_FK_OPTION_FOR_GENERATED_COLUMN = 3104
ER_NON_DEFAULT_VALUE_FOR_GENERATED_COLUMN = 3105
ER_UNSUPPORTED_ACTION_ON_GENERATED_COLUMN = 3106
ER_GENERATED_COLUMN_NON_PRIOR = 3107
ER_DEPENDENT_BY_GENERATED_COLUMN = 3108
ER_GENERATED_COLUMN_REF_AUTO_INC = 3109
ER_FEATURE_NOT_AVAILABLE = 3110
ER_CANT_SET_GTID_MODE = 3111
ER_CANT_USE_AUTO_POSITION_WITH_GTID_MODE_OFF = 3112
OBSOLETE_ER_CANT_REPLICATE_ANONYMOUS_WITH_AUTO_POSITION = 3113
OBSOLETE_ER_CANT_REPLICATE_ANONYMOUS_WITH_GTID_MODE_ON = 3114
OBSOLETE_ER_CANT_REPLICATE_GTID_WITH_GTID_MODE_OFF = 3115
ER_CANT_ENFORCE_GTID_CONSISTENCY_WITH_ONGOING_GTID_VIOLATING_TX = 3116
ER_ENFORCE_GTID_CONSISTENCY_WARN_WITH_ONGOING_GTID_VIOLATING_TX = 3117
ER_ACCOUNT_HAS_BEEN_LOCKED = 3118
ER_WRONG_TABLESPACE_NAME = 3119
ER_TABLESPACE_IS_NOT_EMPTY = 3120
ER_WRONG_FILE_NAME = 3121
ER_BOOST_GEOMETRY_INCONSISTENT_TURNS_EXCEPTION = 3122
ER_WARN_OPTIMIZER_HINT_SYNTAX_ERROR = 3123
ER_WARN_BAD_MAX_EXECUTION_TIME = 3124
ER_WARN_UNSUPPORTED_MAX_EXECUTION_TIME = 3125
ER_WARN_CONFLICTING_HINT = 3126
ER_WARN_UNKNOWN_QB_NAME = 3127
ER_UNRESOLVED_HINT_NAME = 3128
ER_WARN_ON_MODIFYING_GTID_EXECUTED_TABLE = 3129
ER_PLUGGABLE_PROTOCOL_COMMAND_NOT_SUPPORTED = 3130
ER_LOCKING_SERVICE_WRONG_NAME = 3131
ER_LOCKING_SERVICE_DEADLOCK = 3132
ER_LOCKING_SERVICE_TIMEOUT = 3133
ER_GIS_MAX_POINTS_IN_GEOMETRY_OVERFLOWED = 3134
ER_SQL_MODE_MERGED = 3135
ER_VTOKEN_PLUGIN_TOKEN_MISMATCH = 3136
ER_VTOKEN_PLUGIN_TOKEN_NOT_FOUND = 3137
ER_CANT_SET_VARIABLE_WHEN_OWNING_GTID = 3138
OBSOLETE_ER_SLAVE_CHANNEL_OPERATION_NOT_ALLOWED = 3139
ER_REPLICA_CHANNEL_OPERATION_NOT_ALLOWED = 3139
ER_INVALID_JSON_TEXT = 3140
ER_INVALID_JSON_TEXT_IN_PARAM = 3141
ER_INVALID_JSON_BINARY_DATA = 3142
ER_INVALID_JSON_PATH = 3143
ER_INVALID_JSON_CHARSET = 3144
ER_INVALID_JSON_CHARSET_IN_FUNCTION = 3145
ER_INVALID_TYPE_FOR_JSON = 3146
ER_INVALID_CAST_TO_JSON = 3147
ER_INVALID_JSON_PATH_CHARSET = 3148
ER_INVALID_JSON_PATH_WILDCARD = 3149
ER_JSON_VALUE_TOO_BIG = 3150
ER_JSON_KEY_TOO_BIG = 3151
ER_JSON_USED_AS_KEY = 3152
ER_JSON_VACUOUS_PATH = 3153
ER_JSON_BAD_ONE_OR_ALL_ARG = 3154
ER_NUMERIC_JSON_VALUE_OUT_OF_RANGE = 3155
ER_INVALID_JSON_VALUE_FOR_CAST = 3156
ER_JSON_DOCUMENT_TOO_DEEP = 3157
ER_JSON_DOCUMENT_NULL_KEY = 3158
ER_SECURE_TRANSPORT_REQUIRED = 3159
ER_NO_SECURE_TRANSPORTS_CONFIGURED = 3160
ER_DISABLED_STORAGE_ENGINE = 3161
ER_USER_DOES_NOT_EXIST = 3162
ER_USER_ALREADY_EXISTS = 3163
ER_AUDIT_API_ABORT = 3164
ER_INVALID_JSON_PATH_ARRAY_CELL = 3165
ER_BUFPOOL_RESIZE_INPROGRESS = 3166
ER_FEATURE_DISABLED_SEE_DOC = 3167
ER_SERVER_ISNT_AVAILABLE = 3168
ER_SESSION_WAS_KILLED = 3169
ER_CAPACITY_EXCEEDED = 3170
ER_CAPACITY_EXCEEDED_IN_RANGE_OPTIMIZER = 3171
OBSOLETE_ER_TABLE_NEEDS_UPG_PART = 3172
ER_CANT_WAIT_FOR_EXECUTED_GTID_SET_WHILE_OWNING_A_GTID = 3173
ER_CANNOT_ADD_FOREIGN_BASE_COL_VIRTUAL = 3174
ER_CANNOT_CREATE_VIRTUAL_INDEX_CONSTRAINT = 3175
ER_ERROR_ON_MODIFYING_GTID_EXECUTED_TABLE = 3176
ER_LOCK_REFUSED_BY_ENGINE = 3177
ER_UNSUPPORTED_ALTER_ONLINE_ON_VIRTUAL_COLUMN = 3178
OBSOLETE_ER_MASTER_KEY_ROTATION_NOT_SUPPORTED_BY_SE = 3179
OBSOLETE_ER_MASTER_KEY_ROTATION_ERROR_BY_SE = 3180
OBSOLETE_ER_MASTER_KEY_ROTATION_BINLOG_FAILED = 3181
OBSOLETE_ER_MASTER_KEY_ROTATION_SE_UNAVAILABLE = 3182
ER_SOURCE_KEY_ROTATION_NOT_SUPPORTED_BY_SE = 3179
OBSOLETE_ER_SOURCE_KEY_ROTATION_ERROR_BY_SE = 3180
ER_SOURCE_KEY_ROTATION_BINLOG_FAILED = 3181
ER_SOURCE_KEY_ROTATION_SE_UNAVAILABLE = 3182
ER_TABLESPACE_CANNOT_ENCRYPT = 3183
ER_INVALID_ENCRYPTION_OPTION = 3184
ER_CANNOT_FIND_KEY_IN_KEYRING = 3185
ER_CAPACITY_EXCEEDED_IN_PARSER = 3186
ER_UNSUPPORTED_ALTER_ENCRYPTION_INPLACE = 3187
ER_KEYRING_UDF_KEYRING_SERVICE_ERROR = 3188
ER_USER_COLUMN_OLD_LENGTH = 3189
OBSOLETE_ER_CANT_RESET_MASTER = 3190
ER_CANT_RESET_SOURCE = 3190
ER_GROUP_REPLICATION_MAX_GROUP_SIZE = 3191
ER_CANNOT_ADD_FOREIGN_BASE_COL_STORED = 3192
ER_TABLE_REFERENCED = 3193
OBSOLETE_ER_PARTITION_ENGINE_DEPRECATED_FOR_TABLE = 3194
OBSOLETE_ER_WARN_USING_GEOMFROMWKB_TO_SET_SRID_ZERO = 3195
OBSOLETE_ER_WARN_USING_GEOMFROMWKB_TO_SET_SRID = 3196
ER_XA_RETRY = 3197
ER_KEYRING_AWS_UDF_AWS_KMS_ERROR = 3198
ER_BINLOG_UNSAFE_XA = 3199
ER_UDF_ERROR = 3200
ER_KEYRING_MIGRATION_FAILURE = 3201
ER_KEYRING_ACCESS_DENIED_ERROR = 3202
ER_KEYRING_MIGRATION_STATUS = 3203
OBSOLETE_ER_PLUGIN_FAILED_TO_OPEN_TABLES = 3204
OBSOLETE_ER_PLUGIN_FAILED_TO_OPEN_TABLE = 3205
OBSOLETE_ER_AUDIT_LOG_NO_KEYRING_PLUGIN_INSTALLED = 3206
OBSOLETE_ER_AUDIT_LOG_ENCRYPTION_PASSWORD_HAS_NOT_BEEN_SET = 3207
OBSOLETE_ER_AUDIT_LOG_COULD_NOT_CREATE_AES_KEY = 3208
OBSOLETE_ER_AUDIT_LOG_ENCRYPTION_PASSWORD_CANNOT_BE_FETCHED = 3209
OBSOLETE_ER_AUDIT_LOG_JSON_FILTERING_NOT_ENABLED = 3210
OBSOLETE_ER_AUDIT_LOG_UDF_INSUFFICIENT_PRIVILEGE = 3211
OBSOLETE_ER_AUDIT_LOG_SUPER_PRIVILEGE_REQUIRED = 3212
OBSOLETE_ER_COULD_NOT_REINITIALIZE_AUDIT_LOG_FILTERS = 3213
OBSOLETE_ER_AUDIT_LOG_UDF_INVALID_ARGUMENT_TYPE = 3214
OBSOLETE_ER_AUDIT_LOG_UDF_INVALID_ARGUMENT_COUNT = 3215
OBSOLETE_ER_AUDIT_LOG_HAS_NOT_BEEN_INSTALLED = 3216
OBSOLETE_ER_AUDIT_LOG_UDF_READ_INVALID_MAX_ARRAY_LENGTH_ARG_TYPE = 3217
ER_AUDIT_LOG_UDF_READ_INVALID_MAX_ARRAY_LENGTH_ARG_VALUE = 3218
OBSOLETE_ER_AUDIT_LOG_JSON_FILTER_PARSING_ERROR = 3219
OBSOLETE_ER_AUDIT_LOG_JSON_FILTER_NAME_CANNOT_BE_EMPTY = 3220
OBSOLETE_ER_AUDIT_LOG_JSON_USER_NAME_CANNOT_BE_EMPTY = 3221
OBSOLETE_ER_AUDIT_LOG_JSON_FILTER_DOES_NOT_EXISTS = 3222
OBSOLETE_ER_AUDIT_LOG_USER_FIRST_CHARACTER_MUST_BE_ALPHANUMERIC = 3223
OBSOLETE_ER_AUDIT_LOG_USER_NAME_INVALID_CHARACTER = 3224
OBSOLETE_ER_AUDIT_LOG_HOST_NAME_INVALID_CHARACTER = 3225
ER_UNSUPPORT_COMPRESSED_TEMPORARY_TABLE = 3500
ER_ACL_OPERATION_FAILED = 3501
ER_UNSUPPORTED_INDEX_ALGORITHM = 3502
ER_NO_SUCH_DB = 3503
ER_TOO_BIG_ENUM = 3504
ER_TOO_LONG_SET_ENUM_VALUE = 3505
ER_INVALID_DD_OBJECT = 3506
ER_UPDATING_DD_TABLE = 3507
ER_INVALID_DD_OBJECT_ID = 3508
ER_INVALID_DD_OBJECT_NAME = 3509
ER_TABLESPACE_MISSING_WITH_NAME = 3510
ER_TOO_LONG_ROUTINE_COMMENT = 3511
ER_SP_LOAD_FAILED = 3512
ER_INVALID_BITWISE_OPERANDS_SIZE = 3513
ER_INVALID_BITWISE_AGGREGATE_OPERANDS_SIZE = 3514
ER_WARN_UNSUPPORTED_HINT = 3515
ER_UNEXPECTED_GEOMETRY_TYPE = 3516
ER_SRS_PARSE_ERROR = 3517
ER_SRS_PROJ_PARAMETER_MISSING = 3518
ER_WARN_SRS_NOT_FOUND = 3519
ER_SRS_NOT_CARTESIAN = 3520
ER_SRS_NOT_CARTESIAN_UNDEFINED = 3521
ER_PK_INDEX_CANT_BE_INVISIBLE = 3522
ER_UNKNOWN_AUTHID = 3523
ER_FAILED_ROLE_GRANT = 3524
ER_OPEN_ROLE_TABLES = 3525
ER_FAILED_DEFAULT_ROLES = 3526
ER_COMPONENTS_NO_SCHEME = 3527
ER_COMPONENTS_NO_SCHEME_SERVICE = 3528
ER_COMPONENTS_CANT_LOAD = 3529
ER_ROLE_NOT_GRANTED = 3530
ER_FAILED_REVOKE_ROLE = 3531
ER_RENAME_ROLE = 3532
ER_COMPONENTS_CANT_ACQUIRE_SERVICE_IMPLEMENTATION = 3533
ER_COMPONENTS_CANT_SATISFY_DEPENDENCY = 3534
ER_COMPONENTS_LOAD_CANT_REGISTER_SERVICE_IMPLEMENTATION = 3535
ER_COMPONENTS_LOAD_CANT_INITIALIZE = 3536
ER_COMPONENTS_UNLOAD_NOT_LOADED = 3537
ER_COMPONENTS_UNLOAD_CANT_DEINITIALIZE = 3538
ER_COMPONENTS_CANT_RELEASE_SERVICE = 3539
ER_COMPONENTS_UNLOAD_CANT_UNREGISTER_SERVICE = 3540
ER_COMPONENTS_CANT_UNLOAD = 3541
ER_WARN_UNLOAD_THE_NOT_PERSISTED = 3542
ER_COMPONENT_TABLE_INCORRECT = 3543
ER_COMPONENT_MANIPULATE_ROW_FAILED = 3544
ER_COMPONENTS_UNLOAD_DUPLICATE_IN_GROUP = 3545
ER_CANT_SET_GTID_PURGED_DUE_SETS_CONSTRAINTS = 3546
ER_CANNOT_LOCK_USER_MANAGEMENT_CACHES = 3547
ER_SRS_NOT_FOUND = 3548
ER_VARIABLE_NOT_PERSISTED = 3549
ER_IS_QUERY_INVALID_CLAUSE = 3550
ER_UNABLE_TO_STORE_STATISTICS = 3551
ER_NO_SYSTEM_SCHEMA_ACCESS = 3552
ER_NO_SYSTEM_TABLESPACE_ACCESS = 3553
ER_NO_SYSTEM_TABLE_ACCESS = 3554
ER_NO_SYSTEM_TABLE_ACCESS_FOR_DICTIONARY_TABLE = 3555
ER_NO_SYSTEM_TABLE_ACCESS_FOR_SYSTEM_TABLE = 3556
ER_NO_SYSTEM_TABLE_ACCESS_FOR_TABLE = 3557
ER_INVALID_OPTION_KEY = 3558
ER_INVALID_OPTION_VALUE = 3559
ER_INVALID_OPTION_KEY_VALUE_PAIR = 3560
ER_INVALID_OPTION_START_CHARACTER = 3561
ER_INVALID_OPTION_END_CHARACTER = 3562
ER_INVALID_OPTION_CHARACTERS = 3563
ER_DUPLICATE_OPTION_KEY = 3564
ER_WARN_SRS_NOT_FOUND_AXIS_ORDER = 3565
ER_NO_ACCESS_TO_NATIVE_FCT = 3566
OBSOLETE_ER_RESET_MASTER_TO_VALUE_OUT_OF_RANGE = 3567
ER_RESET_SOURCE_TO_VALUE_OUT_OF_RANGE = 3567
ER_UNRESOLVED_TABLE_LOCK = 3568
ER_DUPLICATE_TABLE_LOCK = 3569
ER_BINLOG_UNSAFE_SKIP_LOCKED = 3570
ER_BINLOG_UNSAFE_NOWAIT = 3571
ER_LOCK_NOWAIT = 3572
ER_CTE_RECURSIVE_REQUIRES_UNION = 3573
ER_CTE_RECURSIVE_REQUIRES_NONRECURSIVE_FIRST = 3574
ER_CTE_RECURSIVE_FORBIDS_AGGREGATION = 3575
ER_CTE_RECURSIVE_FORBIDDEN_JOIN_ORDER = 3576
ER_CTE_RECURSIVE_REQUIRES_SINGLE_REFERENCE = 3577
ER_SWITCH_TMP_ENGINE = 3578
ER_WINDOW_NO_SUCH_WINDOW = 3579
ER_WINDOW_CIRCULARITY_IN_WINDOW_GRAPH = 3580
ER_WINDOW_NO_CHILD_PARTITIONING = 3581
ER_WINDOW_NO_INHERIT_FRAME = 3582
ER_WINDOW_NO_REDEFINE_ORDER_BY = 3583
ER_WINDOW_FRAME_START_ILLEGAL = 3584
ER_WINDOW_FRAME_END_ILLEGAL = 3585
ER_WINDOW_FRAME_ILLEGAL = 3586
ER_WINDOW_RANGE_FRAME_ORDER_TYPE = 3587
ER_WINDOW_RANGE_FRAME_TEMPORAL_TYPE = 3588
ER_WINDOW_RANGE_FRAME_NUMERIC_TYPE = 3589
ER_WINDOW_RANGE_BOUND_NOT_CONSTANT = 3590
ER_WINDOW_DUPLICATE_NAME = 3591
ER_WINDOW_ILLEGAL_ORDER_BY = 3592
ER_WINDOW_INVALID_WINDOW_FUNC_USE = 3593
ER_WINDOW_INVALID_WINDOW_FUNC_ALIAS_USE = 3594
ER_WINDOW_NESTED_WINDOW_FUNC_USE_IN_WINDOW_SPEC = 3595
ER_WINDOW_ROWS_INTERVAL_USE = 3596
ER_WINDOW_NO_GROUP_ORDER_UNUSED = 3597
ER_WINDOW_EXPLAIN_JSON = 3598
ER_WINDOW_FUNCTION_IGNORES_FRAME = 3599
ER_WL9236_NOW_UNUSED = 3600
ER_INVALID_NO_OF_ARGS = 3601
ER_FIELD_IN_GROUPING_NOT_GROUP_BY = 3602
ER_TOO_LONG_TABLESPACE_COMMENT = 3603
ER_ENGINE_CANT_DROP_TABLE = 3604
ER_ENGINE_CANT_DROP_MISSING_TABLE = 3605
ER_TABLESPACE_DUP_FILENAME = 3606
ER_DB_DROP_RMDIR2 = 3607
ER_IMP_NO_FILES_MATCHED = 3608
ER_IMP_SCHEMA_DOES_NOT_EXIST = 3609
ER_IMP_TABLE_ALREADY_EXISTS = 3610
ER_IMP_INCOMPATIBLE_MYSQLD_VERSION = 3611
ER_IMP_INCOMPATIBLE_DD_VERSION = 3612
ER_IMP_INCOMPATIBLE_SDI_VERSION = 3613
ER_WARN_INVALID_HINT = 3614
ER_VAR_DOES_NOT_EXIST = 3615
ER_LONGITUDE_OUT_OF_RANGE = 3616
ER_LATITUDE_OUT_OF_RANGE = 3617
ER_NOT_IMPLEMENTED_FOR_GEOGRAPHIC_SRS = 3618
ER_ILLEGAL_PRIVILEGE_LEVEL = 3619
ER_NO_SYSTEM_VIEW_ACCESS = 3620
ER_COMPONENT_FILTER_FLABBERGASTED = 3621
ER_PART_EXPR_TOO_LONG = 3622
ER_UDF_DROP_DYNAMICALLY_REGISTERED = 3623
ER_UNABLE_TO_STORE_COLUMN_STATISTICS = 3624
ER_UNABLE_TO_UPDATE_COLUMN_STATISTICS = 3625
ER_UNABLE_TO_DROP_COLUMN_STATISTICS = 3626
ER_UNABLE_TO_BUILD_HISTOGRAM = 3627
ER_MANDATORY_ROLE = 3628
ER_MISSING_TABLESPACE_FILE = 3629
ER_PERSIST_ONLY_ACCESS_DENIED_ERROR = 3630
ER_CMD_NEED_SUPER = 3631
ER_PATH_IN_DATADIR = 3632
ER_CLONE_DDL_IN_PROGRESS = 3633
ER_CLONE_TOO_MANY_CONCURRENT_CLONES = 3634
ER_APPLIER_LOG_EVENT_VALIDATION_ERROR = 3635
ER_CTE_MAX_RECURSION_DEPTH = 3636
ER_NOT_HINT_UPDATABLE_VARIABLE = 3637
ER_CREDENTIALS_CONTRADICT_TO_HISTORY = 3638
ER_WARNING_PASSWORD_HISTORY_CLAUSES_VOID = 3639
ER_CLIENT_DOES_NOT_SUPPORT = 3640
ER_I_S_SKIPPED_TABLESPACE = 3641
ER_TABLESPACE_ENGINE_MISMATCH = 3642
ER_WRONG_SRID_FOR_COLUMN = 3643
ER_CANNOT_ALTER_SRID_DUE_TO_INDEX = 3644
ER_WARN_BINLOG_PARTIAL_UPDATES_DISABLED = 3645
ER_WARN_BINLOG_V1_ROW_EVENTS_DISABLED = 3646
ER_WARN_BINLOG_PARTIAL_UPDATES_SUGGESTS_PARTIAL_IMAGES = 3647
ER_COULD_NOT_APPLY_JSON_DIFF = 3648
ER_CORRUPTED_JSON_DIFF = 3649
ER_RESOURCE_GROUP_EXISTS = 3650
ER_RESOURCE_GROUP_NOT_EXISTS = 3651
ER_INVALID_VCPU_ID = 3652
ER_INVALID_VCPU_RANGE = 3653
ER_INVALID_THREAD_PRIORITY = 3654
ER_DISALLOWED_OPERATION = 3655
ER_RESOURCE_GROUP_BUSY = 3656
ER_RESOURCE_GROUP_DISABLED = 3657
ER_FEATURE_UNSUPPORTED = 3658
ER_ATTRIBUTE_IGNORED = 3659
ER_INVALID_THREAD_ID = 3660
ER_RESOURCE_GROUP_BIND_FAILED = 3661
ER_INVALID_USE_OF_FORCE_OPTION = 3662
ER_GROUP_REPLICATION_COMMAND_FAILURE = 3663
ER_SDI_OPERATION_FAILED = 3664
ER_MISSING_JSON_TABLE_VALUE = 3665
ER_WRONG_JSON_TABLE_VALUE = 3666
ER_TF_MUST_HAVE_ALIAS = 3667
ER_TF_FORBIDDEN_JOIN_TYPE = 3668
ER_JT_VALUE_OUT_OF_RANGE = 3669
ER_JT_MAX_NESTED_PATH = 3670
ER_PASSWORD_EXPIRATION_NOT_SUPPORTED_BY_AUTH_METHOD = 3671
ER_INVALID_GEOJSON_CRS_NOT_TOP_LEVEL = 3672
ER_BAD_NULL_ERROR_NOT_IGNORED = 3673
WARN_USELESS_SPATIAL_INDEX = 3674
ER_DISK_FULL_NOWAIT = 3675
ER_PARSE_ERROR_IN_DIGEST_FN = 3676
ER_UNDISCLOSED_PARSE_ERROR_IN_DIGEST_FN = 3677
ER_SCHEMA_DIR_EXISTS = 3678
ER_SCHEMA_DIR_MISSING = 3679
ER_SCHEMA_DIR_CREATE_FAILED = 3680
ER_SCHEMA_DIR_UNKNOWN = 3681
ER_ONLY_IMPLEMENTED_FOR_SRID_0_AND_4326 = 3682
ER_BINLOG_EXPIRE_LOG_DAYS_AND_SECS_USED_TOGETHER = 3683
ER_REGEXP_BUFFER_OVERFLOW = 3684
ER_REGEXP_ILLEGAL_ARGUMENT = 3685
ER_REGEXP_INDEX_OUTOFBOUNDS_ERROR = 3686
ER_REGEXP_INTERNAL_ERROR = 3687
ER_REGEXP_RULE_SYNTAX = 3688
ER_REGEXP_BAD_ESCAPE_SEQUENCE = 3689
ER_REGEXP_UNIMPLEMENTED = 3690
ER_REGEXP_MISMATCHED_PAREN = 3691
ER_REGEXP_BAD_INTERVAL = 3692
ER_REGEXP_MAX_LT_MIN = 3693
ER_REGEXP_INVALID_BACK_REF = 3694
ER_REGEXP_LOOK_BEHIND_LIMIT = 3695
ER_REGEXP_MISSING_CLOSE_BRACKET = 3696
ER_REGEXP_INVALID_RANGE = 3697
ER_REGEXP_STACK_OVERFLOW = 3698
ER_REGEXP_TIME_OUT = 3699
ER_REGEXP_PATTERN_TOO_BIG = 3700
ER_CANT_SET_ERROR_LOG_SERVICE = 3701
ER_EMPTY_PIPELINE_FOR_ERROR_LOG_SERVICE = 3702
ER_COMPONENT_FILTER_DIAGNOSTICS = 3703
ER_NOT_IMPLEMENTED_FOR_CARTESIAN_SRS = 3704
ER_NOT_IMPLEMENTED_FOR_PROJECTED_SRS = 3705
ER_NONPOSITIVE_RADIUS = 3706
ER_RESTART_SERVER_FAILED = 3707
ER_SRS_MISSING_MANDATORY_ATTRIBUTE = 3708
ER_SRS_MULTIPLE_ATTRIBUTE_DEFINITIONS = 3709
ER_SRS_NAME_CANT_BE_EMPTY_OR_WHITESPACE = 3710
ER_SRS_ORGANIZATION_CANT_BE_EMPTY_OR_WHITESPACE = 3711
ER_SRS_ID_ALREADY_EXISTS = 3712
ER_WARN_SRS_ID_ALREADY_EXISTS = 3713
ER_CANT_MODIFY_SRID_0 = 3714
ER_WARN_RESERVED_SRID_RANGE = 3715
ER_CANT_MODIFY_SRS_USED_BY_COLUMN = 3716
ER_SRS_INVALID_CHARACTER_IN_ATTRIBUTE = 3717
ER_SRS_ATTRIBUTE_STRING_TOO_LONG = 3718
ER_DEPRECATED_UTF8_ALIAS = 3719
ER_DEPRECATED_NATIONAL = 3720
ER_INVALID_DEFAULT_UTF8MB4_COLLATION = 3721
ER_UNABLE_TO_COLLECT_LOG_STATUS = 3722
ER_RESERVED_TABLESPACE_NAME = 3723
ER_UNABLE_TO_SET_OPTION = 3724
OBSOLETE_ER_SLAVE_POSSIBLY_DIVERGED_AFTER_DDL = 3725
ER_REPLICA_POSSIBLY_DIVERGED_AFTER_DDL = 3725
ER_SRS_NOT_GEOGRAPHIC = 3726
ER_POLYGON_TOO_LARGE = 3727
ER_SPATIAL_UNIQUE_INDEX = 3728
ER_INDEX_TYPE_NOT_SUPPORTED_FOR_SPATIAL_INDEX = 3729
ER_FK_CANNOT_DROP_PARENT = 3730
ER_GEOMETRY_PARAM_LONGITUDE_OUT_OF_RANGE = 3731
ER_GEOMETRY_PARAM_LATITUDE_OUT_OF_RANGE = 3732
ER_FK_CANNOT_USE_VIRTUAL_COLUMN = 3733
ER_FK_NO_COLUMN_PARENT = 3734
ER_CANT_SET_ERROR_SUPPRESSION_LIST = 3735
ER_SRS_GEOGCS_INVALID_AXES = 3736
ER_SRS_INVALID_SEMI_MAJOR_AXIS = 3737
ER_SRS_INVALID_INVERSE_FLATTENING = 3738
ER_SRS_INVALID_ANGULAR_UNIT = 3739
ER_SRS_INVALID_PRIME_MERIDIAN = 3740
ER_TRANSFORM_SOURCE_SRS_NOT_SUPPORTED = 3741
ER_TRANSFORM_TARGET_SRS_NOT_SUPPORTED = 3742
ER_TRANSFORM_SOURCE_SRS_MISSING_TOWGS84 = 3743
ER_TRANSFORM_TARGET_SRS_MISSING_TOWGS84 = 3744
ER_TEMP_TABLE_PREVENTS_SWITCH_SESSION_BINLOG_FORMAT = 3745
ER_TEMP_TABLE_PREVENTS_SWITCH_GLOBAL_BINLOG_FORMAT = 3746
ER_RUNNING_APPLIER_PREVENTS_SWITCH_GLOBAL_BINLOG_FORMAT = 3747
ER_CLIENT_GTID_UNSAFE_CREATE_DROP_TEMP_TABLE_IN_TRX_IN_SBR = 3748
OBSOLETE_ER_XA_CANT_CREATE_MDL_BACKUP = 3749
ER_TABLE_WITHOUT_PK = 3750
ER_WARN_DATA_TRUNCATED_FUNCTIONAL_INDEX = 3751
ER_WARN_DATA_OUT_OF_RANGE_FUNCTIONAL_INDEX = 3752
ER_FUNCTIONAL_INDEX_ON_JSON_OR_GEOMETRY_FUNCTION = 3753
ER_FUNCTIONAL_INDEX_REF_AUTO_INCREMENT = 3754
ER_CANNOT_DROP_COLUMN_FUNCTIONAL_INDEX = 3755
ER_FUNCTIONAL_INDEX_PRIMARY_KEY = 3756
ER_FUNCTIONAL_INDEX_ON_LOB = 3757
ER_FUNCTIONAL_INDEX_FUNCTION_IS_NOT_ALLOWED = 3758
ER_FULLTEXT_FUNCTIONAL_INDEX = 3759
ER_SPATIAL_FUNCTIONAL_INDEX = 3760
ER_WRONG_KEY_COLUMN_FUNCTIONAL_INDEX = 3761
ER_FUNCTIONAL_INDEX_ON_FIELD = 3762
ER_GENERATED_COLUMN_NAMED_FUNCTION_IS_NOT_ALLOWED = 3763
ER_GENERATED_COLUMN_ROW_VALUE = 3764
ER_GENERATED_COLUMN_VARIABLES = 3765
ER_DEPENDENT_BY_DEFAULT_GENERATED_VALUE = 3766
ER_DEFAULT_VAL_GENERATED_NON_PRIOR = 3767
ER_DEFAULT_VAL_GENERATED_REF_AUTO_INC = 3768
ER_DEFAULT_VAL_GENERATED_FUNCTION_IS_NOT_ALLOWED = 3769
ER_DEFAULT_VAL_GENERATED_NAMED_FUNCTION_IS_NOT_ALLOWED = 3770
ER_DEFAULT_VAL_GENERATED_ROW_VALUE = 3771
ER_DEFAULT_VAL_GENERATED_VARIABLES = 3772
ER_DEFAULT_AS_VAL_GENERATED = 3773
ER_UNSUPPORTED_ACTION_ON_DEFAULT_VAL_GENERATED = 3774
ER_GTID_UNSAFE_ALTER_ADD_COL_WITH_DEFAULT_EXPRESSION = 3775
ER_FK_CANNOT_CHANGE_ENGINE = 3776
ER_WARN_DEPRECATED_USER_SET_EXPR = 3777
ER_WARN_DEPRECATED_UTF8MB3_COLLATION = 3778
ER_WARN_DEPRECATED_NESTED_COMMENT_SYNTAX = 3779
ER_FK_INCOMPATIBLE_COLUMNS = 3780
ER_GR_HOLD_WAIT_TIMEOUT = 3781
ER_GR_HOLD_KILLED = 3782
ER_GR_HOLD_MEMBER_STATUS_ERROR = 3783
ER_RPL_ENCRYPTION_FAILED_TO_FETCH_KEY = 3784
ER_RPL_ENCRYPTION_KEY_NOT_FOUND = 3785
ER_RPL_ENCRYPTION_KEYRING_INVALID_KEY = 3786
ER_RPL_ENCRYPTION_HEADER_ERROR = 3787
ER_RPL_ENCRYPTION_FAILED_TO_ROTATE_LOGS = 3788
ER_RPL_ENCRYPTION_KEY_EXISTS_UNEXPECTED = 3789
ER_RPL_ENCRYPTION_FAILED_TO_GENERATE_KEY = 3790
ER_RPL_ENCRYPTION_FAILED_TO_STORE_KEY = 3791
ER_RPL_ENCRYPTION_FAILED_TO_REMOVE_KEY = 3792
ER_RPL_ENCRYPTION_UNABLE_TO_CHANGE_OPTION = 3793
ER_RPL_ENCRYPTION_SOURCE_KEY_RECOVERY_FAILED = 3794
ER_SLOW_LOG_MODE_IGNORED_WHEN_NOT_LOGGING_TO_FILE = 3795
ER_GRP_TRX_CONSISTENCY_NOT_ALLOWED = 3796
ER_GRP_TRX_CONSISTENCY_BEFORE = 3797
ER_GRP_TRX_CONSISTENCY_AFTER_ON_TRX_BEGIN = 3798
ER_GRP_TRX_CONSISTENCY_BEGIN_NOT_ALLOWED = 3799
ER_FUNCTIONAL_INDEX_ROW_VALUE_IS_NOT_ALLOWED = 3800
ER_RPL_ENCRYPTION_FAILED_TO_ENCRYPT = 3801
ER_PAGE_TRACKING_NOT_STARTED = 3802
ER_PAGE_TRACKING_RANGE_NOT_TRACKED = 3803
ER_PAGE_TRACKING_CANNOT_PURGE = 3804
ER_RPL_ENCRYPTION_CANNOT_ROTATE_BINLOG_SOURCE_KEY = 3805
ER_BINLOG_SOURCE_KEY_RECOVERY_OUT_OF_COMBINATION = 3806
ER_BINLOG_SOURCE_KEY_ROTATION_FAIL_TO_OPERATE_KEY = 3807
ER_BINLOG_SOURCE_KEY_ROTATION_FAIL_TO_ROTATE_LOGS = 3808
ER_BINLOG_SOURCE_KEY_ROTATION_FAIL_TO_REENCRYPT_LOG = 3809
ER_BINLOG_SOURCE_KEY_ROTATION_FAIL_TO_CLEANUP_UNUSED_KEYS = 3810
ER_BINLOG_SOURCE_KEY_ROTATION_FAIL_TO_CLEANUP_AUX_KEY = 3811
ER_NON_BOOLEAN_EXPR_FOR_CHECK_CONSTRAINT = 3812
ER_COLUMN_CHECK_CONSTRAINT_REFERENCES_OTHER_COLUMN = 3813
ER_CHECK_CONSTRAINT_NAMED_FUNCTION_IS_NOT_ALLOWED = 3814
ER_CHECK_CONSTRAINT_FUNCTION_IS_NOT_ALLOWED = 3815
ER_CHECK_CONSTRAINT_VARIABLES = 3816
ER_CHECK_CONSTRAINT_ROW_VALUE = 3817
ER_CHECK_CONSTRAINT_REFERS_AUTO_INCREMENT_COLUMN = 3818
ER_CHECK_CONSTRAINT_VIOLATED = 3819
ER_CHECK_CONSTRAINT_REFERS_UNKNOWN_COLUMN = 3820
ER_CHECK_CONSTRAINT_NOT_FOUND = 3821
ER_CHECK_CONSTRAINT_DUP_NAME = 3822
ER_CHECK_CONSTRAINT_CLAUSE_USING_FK_REFER_ACTION_COLUMN = 3823
WARN_UNENCRYPTED_TABLE_IN_ENCRYPTED_DB = 3824
ER_INVALID_ENCRYPTION_REQUEST = 3825
ER_CANNOT_SET_TABLE_ENCRYPTION = 3826
ER_CANNOT_SET_DATABASE_ENCRYPTION = 3827
ER_CANNOT_SET_TABLESPACE_ENCRYPTION = 3828
ER_TABLESPACE_CANNOT_BE_ENCRYPTED = 3829
ER_TABLESPACE_CANNOT_BE_DECRYPTED = 3830
ER_TABLESPACE_TYPE_UNKNOWN = 3831
ER_TARGET_TABLESPACE_UNENCRYPTED = 3832
ER_CANNOT_USE_ENCRYPTION_CLAUSE = 3833
ER_INVALID_MULTIPLE_CLAUSES = 3834
ER_UNSUPPORTED_USE_OF_GRANT_AS = 3835
ER_UKNOWN_AUTH_ID_OR_ACCESS_DENIED_FOR_GRANT_AS = 3836
ER_DEPENDENT_BY_FUNCTIONAL_INDEX = 3837
ER_PLUGIN_NOT_EARLY = 3838
ER_INNODB_REDO_LOG_ARCHIVE_START_SUBDIR_PATH = 3839
ER_INNODB_REDO_LOG_ARCHIVE_START_TIMEOUT = 3840
ER_INNODB_REDO_LOG_ARCHIVE_DIRS_INVALID = 3841
ER_INNODB_REDO_LOG_ARCHIVE_LABEL_NOT_FOUND = 3842
ER_INNODB_REDO_LOG_ARCHIVE_DIR_EMPTY = 3843
ER_INNODB_REDO_LOG_ARCHIVE_NO_SUCH_DIR = 3844
ER_INNODB_REDO_LOG_ARCHIVE_DIR_CLASH = 3845
ER_INNODB_REDO_LOG_ARCHIVE_DIR_PERMISSIONS = 3846
ER_INNODB_REDO_LOG_ARCHIVE_FILE_CREATE = 3847
ER_INNODB_REDO_LOG_ARCHIVE_ACTIVE = 3848
ER_INNODB_REDO_LOG_ARCHIVE_INACTIVE = 3849
ER_INNODB_REDO_LOG_ARCHIVE_FAILED = 3850
ER_INNODB_REDO_LOG_ARCHIVE_SESSION = 3851
ER_STD_REGEX_ERROR = 3852
ER_INVALID_JSON_TYPE = 3853
ER_CANNOT_CONVERT_STRING = 3854
ER_DEPENDENT_BY_PARTITION_FUNC = 3855
ER_WARN_DEPRECATED_FLOAT_AUTO_INCREMENT = 3856
ER_RPL_CANT_STOP_REPLICA_WHILE_LOCKED_BACKUP = 3857
ER_WARN_DEPRECATED_FLOAT_DIGITS = 3858
ER_WARN_DEPRECATED_FLOAT_UNSIGNED = 3859
ER_WARN_DEPRECATED_INTEGER_DISPLAY_WIDTH = 3860
ER_WARN_DEPRECATED_ZEROFILL = 3861
ER_CLONE_DONOR = 3862
ER_CLONE_PROTOCOL = 3863
ER_CLONE_DONOR_VERSION = 3864
ER_CLONE_OS = 3865
ER_CLONE_PLATFORM = 3866
ER_CLONE_CHARSET = 3867
ER_CLONE_CONFIG = 3868
ER_CLONE_SYS_CONFIG = 3869
ER_CLONE_PLUGIN_MATCH = 3870
ER_CLONE_LOOPBACK = 3871
ER_CLONE_ENCRYPTION = 3872
ER_CLONE_DISK_SPACE = 3873
ER_CLONE_IN_PROGRESS = 3874
ER_CLONE_DISALLOWED = 3875
ER_CANNOT_GRANT_ROLES_TO_ANONYMOUS_USER = 3876
ER_SECONDARY_ENGINE_PLUGIN = 3877
ER_SECOND_PASSWORD_CANNOT_BE_EMPTY = 3878
ER_DB_ACCESS_DENIED = 3879
ER_DA_AUTH_ID_WITH_SYSTEM_USER_PRIV_IN_MANDATORY_ROLES = 3880
ER_DA_RPL_GTID_TABLE_CANNOT_OPEN = 3881
ER_GEOMETRY_IN_UNKNOWN_LENGTH_UNIT = 3882
ER_DA_PLUGIN_INSTALL_ERROR = 3883
ER_NO_SESSION_TEMP = 3884
ER_DA_UNKNOWN_ERROR_NUMBER = 3885
ER_COLUMN_CHANGE_SIZE = 3886
ER_REGEXP_INVALID_CAPTURE_GROUP_NAME = 3887
ER_DA_SSL_LIBRARY_ERROR = 3888
ER_SECONDARY_ENGINE = 3889
ER_SECONDARY_ENGINE_DDL = 3890
ER_INCORRECT_CURRENT_PASSWORD = 3891
ER_MISSING_CURRENT_PASSWORD = 3892
ER_CURRENT_PASSWORD_NOT_REQUIRED = 3893
ER_PASSWORD_CANNOT_BE_RETAINED_ON_PLUGIN_CHANGE = 3894
ER_CURRENT_PASSWORD_CANNOT_BE_RETAINED = 3895
ER_PARTIAL_REVOKES_EXIST = 3896
ER_CANNOT_GRANT_SYSTEM_PRIV_TO_MANDATORY_ROLE = 3897
ER_XA_REPLICATION_FILTERS = 3898
ER_UNSUPPORTED_SQL_MODE = 3899
ER_REGEXP_INVALID_FLAG = 3900
ER_PARTIAL_REVOKE_AND_DB_GRANT_BOTH_EXISTS = 3901
ER_UNIT_NOT_FOUND = 3902
ER_INVALID_JSON_VALUE_FOR_FUNC_INDEX = 3903
ER_JSON_VALUE_OUT_OF_RANGE_FOR_FUNC_INDEX = 3904
ER_EXCEEDED_MV_KEYS_NUM = 3905
ER_EXCEEDED_MV_KEYS_SPACE = 3906
ER_FUNCTIONAL_INDEX_DATA_IS_TOO_LONG = 3907
ER_WRONG_MVI_VALUE = 3908
ER_WARN_FUNC_INDEX_NOT_APPLICABLE = 3909
ER_GRP_RPL_UDF_ERROR = 3910
ER_UPDATE_GTID_PURGED_WITH_GR = 3911
ER_GROUPING_ON_TIMESTAMP_IN_DST = 3912
ER_TABLE_NAME_CAUSES_TOO_LONG_PATH = 3913
ER_AUDIT_LOG_INSUFFICIENT_PRIVILEGE = 3914
OBSOLETE_ER_AUDIT_LOG_PASSWORD_HAS_BEEN_COPIED = 3915
ER_DA_GRP_RPL_STARTED_AUTO_REJOIN = 3916
ER_SYSVAR_CHANGE_DURING_QUERY = 3917
ER_GLOBSTAT_CHANGE_DURING_QUERY = 3918
ER_GRP_RPL_MESSAGE_SERVICE_INIT_FAILURE = 3919
ER_CHANGE_SOURCE_WRONG_COMPRESSION_ALGORITHM_CLIENT = 3920
ER_CHANGE_SOURCE_WRONG_COMPRESSION_LEVEL_CLIENT = 3921
ER_WRONG_COMPRESSION_ALGORITHM_CLIENT = 3922
ER_WRONG_COMPRESSION_LEVEL_CLIENT = 3923
ER_CHANGE_SOURCE_WRONG_COMPRESSION_ALGORITHM_LIST_CLIENT = 3924
ER_CLIENT_PRIVILEGE_CHECKS_USER_CANNOT_BE_ANONYMOUS = 3925
ER_CLIENT_PRIVILEGE_CHECKS_USER_DOES_NOT_EXIST = 3926
ER_CLIENT_PRIVILEGE_CHECKS_USER_CORRUPT = 3927
ER_CLIENT_PRIVILEGE_CHECKS_USER_NEEDS_RPL_APPLIER_PRIV = 3928
ER_WARN_DA_PRIVILEGE_NOT_REGISTERED = 3929
ER_CLIENT_KEYRING_UDF_KEY_INVALID = 3930
ER_CLIENT_KEYRING_UDF_KEY_TYPE_INVALID = 3931
ER_CLIENT_KEYRING_UDF_KEY_TOO_LONG = 3932
ER_CLIENT_KEYRING_UDF_KEY_TYPE_TOO_LONG = 3933
ER_JSON_SCHEMA_VALIDATION_ERROR_WITH_DETAILED_REPORT = 3934
ER_DA_UDF_INVALID_CHARSET_SPECIFIED = 3935
ER_DA_UDF_INVALID_CHARSET = 3936
ER_DA_UDF_INVALID_COLLATION = 3937
ER_DA_UDF_INVALID_EXTENSION_ARGUMENT_TYPE = 3938
ER_MULTIPLE_CONSTRAINTS_WITH_SAME_NAME = 3939
ER_CONSTRAINT_NOT_FOUND = 3940
ER_ALTER_CONSTRAINT_ENFORCEMENT_NOT_SUPPORTED = 3941
ER_TABLE_VALUE_CONSTRUCTOR_MUST_HAVE_COLUMNS = 3942
ER_TABLE_VALUE_CONSTRUCTOR_CANNOT_HAVE_DEFAULT = 3943
ER_CLIENT_QUERY_FAILURE_INVALID_NON_ROW_FORMAT = 3944
ER_REQUIRE_ROW_FORMAT_INVALID_VALUE = 3945
ER_FAILED_TO_DETERMINE_IF_ROLE_IS_MANDATORY = 3946
ER_FAILED_TO_FETCH_MANDATORY_ROLE_LIST = 3947
ER_CLIENT_LOCAL_FILES_DISABLED = 3948
ER_IMP_INCOMPATIBLE_CFG_VERSION = 3949
ER_DA_OOM = 3950
ER_DA_UDF_INVALID_ARGUMENT_TO_SET_CHARSET = 3951
ER_DA_UDF_INVALID_RETURN_TYPE_TO_SET_CHARSET = 3952
ER_MULTIPLE_INTO_CLAUSES = 3953
ER_MISPLACED_INTO = 3954
ER_USER_ACCESS_DENIED_FOR_USER_ACCOUNT_BLOCKED_BY_PASSWORD_LOCK = 3955
ER_WARN_DEPRECATED_YEAR_UNSIGNED = 3956
ER_CLONE_NETWORK_PACKET = 3957
ER_SDI_OPERATION_FAILED_MISSING_RECORD = 3958
ER_DEPENDENT_BY_CHECK_CONSTRAINT = 3959
ER_GRP_OPERATION_NOT_ALLOWED_GR_MUST_STOP = 3960
ER_WARN_DEPRECATED_JSON_TABLE_ON_ERROR_ON_EMPTY = 3961
ER_WARN_DEPRECATED_INNER_INTO = 3962
ER_WARN_DEPRECATED_VALUES_FUNCTION_ALWAYS_NULL = 3963
ER_WARN_DEPRECATED_SQL_CALC_FOUND_ROWS = 3964
ER_WARN_DEPRECATED_FOUND_ROWS = 3965
ER_MISSING_JSON_VALUE = 3966
ER_MULTIPLE_JSON_VALUES = 3967
ER_HOSTNAME_TOO_LONG = 3968
ER_WARN_CLIENT_DEPRECATED_PARTITION_PREFIX_KEY = 3969
ER_GROUP_REPLICATION_USER_EMPTY_MSG = 3970
ER_GROUP_REPLICATION_USER_MANDATORY_MSG = 3971
ER_GROUP_REPLICATION_PASSWORD_LENGTH = 3972
ER_SUBQUERY_TRANSFORM_REJECTED = 3973
ER_DA_GRP_RPL_RECOVERY_ENDPOINT_FORMAT = 3974
ER_DA_GRP_RPL_RECOVERY_ENDPOINT_INVALID = 3975
ER_WRONG_VALUE_FOR_VAR_PLUS_ACTIONABLE_PART = 3976
ER_STATEMENT_NOT_ALLOWED_AFTER_START_TRANSACTION = 3977
ER_FOREIGN_KEY_WITH_ATOMIC_CREATE_SELECT = 3978
ER_NOT_ALLOWED_WITH_START_TRANSACTION = 3979
ER_INVALID_JSON_ATTRIBUTE = 3980
ER_ENGINE_ATTRIBUTE_NOT_SUPPORTED = 3981
ER_INVALID_USER_ATTRIBUTE_JSON = 3982
ER_INNODB_REDO_DISABLED = 3983
ER_INNODB_REDO_ARCHIVING_ENABLED = 3984
ER_MDL_OUT_OF_RESOURCES = 3985
ER_IMPLICIT_COMPARISON_FOR_JSON = 3986
ER_FUNCTION_DOES_NOT_SUPPORT_CHARACTER_SET = 3987
ER_IMPOSSIBLE_STRING_CONVERSION = 3988
ER_SCHEMA_READ_ONLY = 3989
ER_RPL_ASYNC_RECONNECT_GTID_MODE_OFF = 3990
ER_RPL_ASYNC_RECONNECT_AUTO_POSITION_OFF = 3991
ER_DISABLE_GTID_MODE_REQUIRES_ASYNC_RECONNECT_OFF = 3992
ER_DISABLE_AUTO_POSITION_REQUIRES_ASYNC_RECONNECT_OFF = 3993
ER_INVALID_PARAMETER_USE = 3994
ER_CHARACTER_SET_MISMATCH = 3995
ER_WARN_VAR_VALUE_CHANGE_NOT_SUPPORTED = 3996
ER_INVALID_TIME_ZONE_INTERVAL = 3997
ER_INVALID_CAST = 3998
ER_HYPERGRAPH_NOT_SUPPORTED_YET = 3999
ER_WARN_HYPERGRAPH_EXPERIMENTAL = 4000
ER_DA_NO_ERROR_LOG_PARSER_CONFIGURED = 4001
ER_DA_ERROR_LOG_TABLE_DISABLED = 4002
ER_DA_ERROR_LOG_MULTIPLE_FILTERS = 4003
ER_DA_CANT_OPEN_ERROR_LOG = 4004
ER_USER_REFERENCED_AS_DEFINER = 4005
ER_CANNOT_USER_REFERENCED_AS_DEFINER = 4006
ER_REGEX_NUMBER_TOO_BIG = 4007
ER_SPVAR_NONINTEGER_TYPE = 4008
WARN_UNSUPPORTED_ACL_TABLES_READ = 4009
ER_BINLOG_UNSAFE_ACL_TABLE_READ_IN_DML_DDL = 4010
ER_PARSER_TRACE = 10000
ER_BOOTSTRAP_CANT_THREAD = 10001
ER_TRIGGER_INVALID_VALUE = 10002
ER_OPT_WRONG_TREE = 10003
ER_DD_FAILSAFE = 10004
ER_DD_NO_WRITES_NO_REPOPULATION = 10005
ER_DD_VERSION_FOUND = 10006
ER_DD_VERSION_INSTALLED = 10007
ER_DD_VERSION_UNSUPPORTED = 10008
ER_LOG_SYSLOG_FACILITY_FAIL = 10009
ER_LOG_SYSLOG_CANNOT_OPEN = 10010
ER_LOG_SLOW_CANNOT_OPEN = 10011
ER_LOG_GENERAL_CANNOT_OPEN = 10012
ER_LOG_CANNOT_WRITE = 10013
ER_RPL_ZOMBIE_ENCOUNTERED = 10014
ER_RPL_GTID_TABLE_CANNOT_OPEN = 10015
ER_SYSTEM_SCHEMA_NOT_FOUND = 10016
ER_DD_INIT_UPGRADE_FAILED = 10017
ER_VIEW_UNKNOWN_CHARSET_OR_COLLATION = 10018
ER_DD_VIEW_CANT_ALLOC_CHARSET = 10019
ER_DD_INIT_FAILED = 10020
ER_DD_UPDATING_PLUGIN_MD_FAILED = 10021
ER_DD_POPULATING_TABLES_FAILED = 10022
ER_DD_VIEW_CANT_CREATE = 10023
ER_DD_METADATA_NOT_FOUND = 10024
ER_DD_CACHE_NOT_EMPTY_AT_SHUTDOWN = 10025
ER_DD_OBJECT_REMAINS = 10026
ER_DD_OBJECT_REMAINS_IN_RELEASER = 10027
ER_DD_OBJECT_RELEASER_REMAINS = 10028
ER_DD_CANT_GET_OBJECT_KEY = 10029
ER_DD_CANT_CREATE_OBJECT_KEY = 10030
ER_CANT_CREATE_HANDLE_MGR_THREAD = 10031
ER_RPL_REPO_HAS_GAPS = 10032
ER_INVALID_VALUE_FOR_ENFORCE_GTID_CONSISTENCY = 10033
ER_CHANGED_ENFORCE_GTID_CONSISTENCY = 10034
ER_CHANGED_GTID_MODE = 10035
ER_DISABLED_STORAGE_ENGINE_AS_DEFAULT = 10036
ER_DEBUG_SYNC_HIT = 10037
ER_DEBUG_SYNC_EXECUTED = 10038
ER_DEBUG_SYNC_THREAD_MAX = 10039
ER_DEBUG_SYNC_OOM = 10040
ER_CANT_INIT_TC_LOG = 10041
ER_EVENT_CANT_INIT_QUEUE = 10042
ER_EVENT_PURGING_QUEUE = 10043
ER_EVENT_LAST_EXECUTION = 10044
ER_EVENT_MESSAGE_STACK = 10045
ER_EVENT_EXECUTION_FAILED = 10046
ER_CANT_INIT_SCHEDULER_THREAD = 10047
ER_SCHEDULER_STOPPED = 10048
ER_CANT_CREATE_SCHEDULER_THREAD = 10049
ER_SCHEDULER_WAITING = 10050
ER_SCHEDULER_STARTED = 10051
ER_SCHEDULER_STOPPING_FAILED_TO_GET_EVENT = 10052
ER_SCHEDULER_STOPPING_FAILED_TO_CREATE_WORKER = 10053
ER_SCHEDULER_KILLING = 10054
ER_UNABLE_TO_RESOLVE_IP = 10055
ER_UNABLE_TO_RESOLVE_HOSTNAME = 10056
ER_HOSTNAME_RESEMBLES_IPV4 = 10057
ER_HOSTNAME_DOESNT_RESOLVE_TO = 10058
ER_ADDRESSES_FOR_HOSTNAME_HEADER = 10059
ER_ADDRESSES_FOR_HOSTNAME_LIST_ITEM = 10060
ER_TRG_WITHOUT_DEFINER = 10061
ER_TRG_NO_CLIENT_CHARSET = 10062
ER_PARSING_VIEW = 10063
ER_COMPONENTS_INFRASTRUCTURE_BOOTSTRAP = 10064
ER_COMPONENTS_INFRASTRUCTURE_SHUTDOWN = 10065
ER_COMPONENTS_PERSIST_LOADER_BOOTSTRAP = 10066
ER_DEPART_WITH_GRACE = 10067
ER_CA_SELF_SIGNED = 10068
ER_SSL_LIBRARY_ERROR = 10069
ER_NO_THD_NO_UUID = 10070
ER_UUID_SALT = 10071
ER_UUID_IS = 10072
ER_UUID_INVALID = 10073
ER_UUID_SCRUB = 10074
ER_CREATING_NEW_UUID = 10075
ER_CANT_CREATE_UUID = 10076
ER_UNKNOWN_UNSUPPORTED_STORAGE_ENGINE = 10077
ER_SECURE_AUTH_VALUE_UNSUPPORTED = 10078
ER_INVALID_INSTRUMENT = 10079
ER_INNODB_MANDATORY = 10080
OBSOLETE_ER_INNODB_CANNOT_BE_IGNORED = 10081
ER_OLD_PASSWORDS_NO_MIDDLE_GROUND = 10082
ER_VERBOSE_REQUIRES_HELP = 10083
ER_POINTLESS_WITHOUT_SLOWLOG = 10084
ER_WASTEFUL_NET_BUFFER_SIZE = 10085
ER_DEPRECATED_TIMESTAMP_IMPLICIT_DEFAULTS = 10086
ER_FT_BOOL_SYNTAX_INVALID = 10087
ER_CREDENTIALLESS_AUTO_USER_BAD = 10088
ER_CONNECTION_HANDLING_OOM = 10089
ER_THREAD_HANDLING_OOM = 10090
ER_CANT_CREATE_TEST_FILE = 10091
ER_CANT_CREATE_PID_FILE = 10092
ER_CANT_REMOVE_PID_FILE = 10093
ER_CANT_CREATE_SHUTDOWN_THREAD = 10094
ER_SEC_FILE_PRIV_CANT_ACCESS_DIR = 10095
ER_SEC_FILE_PRIV_IGNORED = 10096
ER_SEC_FILE_PRIV_EMPTY = 10097
ER_SEC_FILE_PRIV_NULL = 10098
ER_SEC_FILE_PRIV_DIRECTORY_INSECURE = 10099
ER_SEC_FILE_PRIV_CANT_STAT = 10100
ER_SEC_FILE_PRIV_DIRECTORY_PERMISSIONS = 10101
ER_SEC_FILE_PRIV_ARGUMENT_TOO_LONG = 10102
ER_CANT_CREATE_NAMED_PIPES_THREAD = 10103
ER_CANT_CREATE_TCPIP_THREAD = 10104
ER_CANT_CREATE_SHM_THREAD = 10105
ER_CANT_CREATE_INTERRUPT_THREAD = 10106
ER_WRITABLE_CONFIG_REMOVED = 10107
ER_CORE_VALUES = 10108
ER_WRONG_DATETIME_SPEC = 10109
ER_RPL_BINLOG_FILTERS_OOM = 10110
ER_KEYCACHE_OOM = 10111
ER_CONFIRMING_THE_FUTURE = 10112
ER_BACK_IN_TIME = 10113
ER_FUTURE_DATE = 10114
ER_UNSUPPORTED_DATE = 10115
ER_STARTING_AS = 10116
OBSOLETE_ER_SHUTTING_DOWN_SLAVE_THREADS = 10117
ER_SHUTTING_DOWN_REPLICA_THREADS = 10117
ER_DISCONNECTING_REMAINING_CLIENTS = 10118
ER_ABORTING = 10119
ER_BINLOG_END = 10120
ER_CALL_ME_LOCALHOST = 10121
ER_USER_REQUIRES_ROOT = 10122
ER_REALLY_RUN_AS_ROOT = 10123
ER_USER_WHAT_USER = 10124
ER_TRANSPORTS_WHAT_TRANSPORTS = 10125
ER_FAIL_SETGID = 10126
ER_FAIL_SETUID = 10127
ER_FAIL_SETREGID = 10128
ER_FAIL_SETREUID = 10129
ER_FAIL_CHROOT = 10130
ER_WIN_LISTEN_BUT_HOW = 10131
ER_NOT_RIGHT_NOW = 10132
ER_FIXING_CLIENT_CHARSET = 10133
ER_OOM = 10134
ER_FAILED_TO_LOCK_MEM = 10135
ER_MYINIT_FAILED = 10136
ER_BEG_INITFILE = 10137
ER_END_INITFILE = 10138
ER_CHANGED_MAX_OPEN_FILES = 10139
ER_CANT_INCREASE_MAX_OPEN_FILES = 10140
ER_CHANGED_MAX_CONNECTIONS = 10141
ER_CHANGED_TABLE_OPEN_CACHE = 10142
ER_THE_USER_ABIDES = 10143
ER_RPL_CANT_ADD_DO_TABLE = 10144
ER_RPL_CANT_ADD_IGNORE_TABLE = 10145
ER_TRACK_VARIABLES_BOGUS = 10146
ER_EXCESS_ARGUMENTS = 10147
ER_VERBOSE_HINT = 10148
ER_CANT_READ_ERRMSGS = 10149
ER_CANT_INIT_DBS = 10150
ER_LOG_OUTPUT_CONTRADICTORY = 10151
ER_NO_CSV_NO_LOG_TABLES = 10152
ER_RPL_REWRITEDB_MISSING_ARROW = 10153
ER_RPL_REWRITEDB_EMPTY_FROM = 10154
ER_RPL_REWRITEDB_EMPTY_TO = 10155
ER_LOG_FILES_GIVEN_LOG_OUTPUT_IS_TABLE = 10156
ER_LOG_FILE_INVALID = 10157
ER_LOWER_CASE_TABLE_NAMES_CS_DD_ON_CI_FS_UNSUPPORTED = 10158
ER_LOWER_CASE_TABLE_NAMES_USING_2 = 10159
ER_LOWER_CASE_TABLE_NAMES_USING_0 = 10160
ER_NEED_LOG_BIN = 10161
ER_NEED_FILE_INSTEAD_OF_DIR = 10162
ER_LOG_BIN_BETTER_WITH_NAME = 10163
ER_BINLOG_NEEDS_SERVERID = 10164
ER_RPL_CANT_MAKE_PATHS = 10165
ER_CANT_INITIALIZE_GTID = 10166
ER_CANT_INITIALIZE_EARLY_PLUGINS = 10167
ER_CANT_INITIALIZE_BUILTIN_PLUGINS = 10168
ER_CANT_INITIALIZE_DYNAMIC_PLUGINS = 10169
ER_PERFSCHEMA_INIT_FAILED = 10170
ER_STACKSIZE_UNEXPECTED = 10171
ER_CANT_SET_DATADIR = 10172
ER_CANT_STAT_DATADIR = 10173
ER_CANT_CHOWN_DATADIR = 10174
ER_CANT_SET_UP_PERSISTED_VALUES = 10175
ER_CANT_SAVE_GTIDS = 10176
ER_AUTH_CANT_SET_DEFAULT_PLUGIN = 10177
ER_CANT_JOIN_SHUTDOWN_THREAD = 10178
ER_CANT_HASH_DO_AND_IGNORE_RULES = 10179
ER_CANT_OPEN_CA = 10180
ER_CANT_ACCESS_CAPATH = 10181
ER_SSL_TRYING_DATADIR_DEFAULTS = 10182
ER_AUTO_OPTIONS_FAILED = 10183
ER_CANT_INIT_TIMER = 10184
ER_SERVERID_TOO_LARGE = 10185
ER_DEFAULT_SE_UNAVAILABLE = 10186
ER_CANT_OPEN_ERROR_LOG = 10187
ER_INVALID_ERROR_LOG_NAME = 10188
ER_RPL_INFINITY_DENIED = 10189
ER_RPL_INFINITY_IGNORED = 10190
ER_NDB_TABLES_NOT_READY = 10191
ER_TABLE_CHECK_INTACT = 10192
ER_DD_TABLESPACE_NOT_FOUND = 10193
ER_DD_TRG_CONNECTION_COLLATION_MISSING = 10194
ER_DD_TRG_DB_COLLATION_MISSING = 10195
ER_DD_TRG_DEFINER_OOM = 10196
ER_DD_TRG_FILE_UNREADABLE = 10197
ER_TRG_CANT_PARSE = 10198
ER_DD_TRG_CANT_ADD = 10199
ER_DD_CANT_RESOLVE_VIEW = 10200
ER_DD_VIEW_WITHOUT_DEFINER = 10201
ER_PLUGIN_INIT_FAILED = 10202
ER_RPL_TRX_DELEGATES_INIT_FAILED = 10203
ER_RPL_BINLOG_STORAGE_DELEGATES_INIT_FAILED = 10204
ER_RPL_BINLOG_TRANSMIT_DELEGATES_INIT_FAILED = 10205
ER_RPL_BINLOG_RELAY_DELEGATES_INIT_FAILED = 10206
ER_RPL_PLUGIN_FUNCTION_FAILED = 10207
ER_SQL_HA_READ_FAILED = 10208
ER_SR_BOGUS_VALUE = 10209
ER_SR_INVALID_CONTEXT = 10210
ER_READING_TABLE_FAILED = 10211
ER_DES_FILE_WRONG_KEY = 10212
ER_CANT_SET_PERSISTED = 10213
ER_JSON_PARSE_ERROR = 10214
ER_CONFIG_OPTION_WITHOUT_GROUP = 10215
ER_VALGRIND_DO_QUICK_LEAK_CHECK = 10216
ER_VALGRIND_COUNT_LEAKS = 10217
ER_LOAD_DATA_INFILE_FAILED_IN_UNEXPECTED_WAY = 10218
ER_UNKNOWN_ERROR_NUMBER = 10219
ER_UDF_CANT_ALLOC_FOR_STRUCTURES = 10220
ER_UDF_CANT_ALLOC_FOR_FUNCTION = 10221
ER_UDF_INVALID_ROW_IN_FUNCTION_TABLE = 10222
ER_UDF_CANT_OPEN_FUNCTION_TABLE = 10223
ER_XA_RECOVER_FOUND_TRX_IN_SE = 10224
ER_XA_RECOVER_FOUND_XA_TRX = 10225
ER_XA_IGNORING_XID = 10226
ER_XA_COMMITTING_XID = 10227
ER_XA_ROLLING_BACK_XID = 10228
ER_XA_STARTING_RECOVERY = 10229
ER_XA_NO_MULTI_2PC_HEURISTIC_RECOVER = 10230
ER_XA_RECOVER_EXPLANATION = 10231
ER_XA_RECOVERY_DONE = 10232
ER_TRX_GTID_COLLECT_REJECT = 10233
ER_SQL_AUTHOR_DEFAULT_ROLES_FAIL = 10234
ER_SQL_USER_TABLE_CREATE_WARNING = 10235
ER_SQL_USER_TABLE_ALTER_WARNING = 10236
ER_ROW_IN_WRONG_PARTITION_PLEASE_REPAIR = 10237
ER_MYISAM_CRASHED_ERROR_IN_THREAD = 10238
ER_MYISAM_CRASHED_ERROR_IN = 10239
ER_TOO_MANY_STORAGE_ENGINES = 10240
ER_SE_TYPECODE_CONFLICT = 10241
ER_TRX_WRITE_SET_OOM = 10242
ER_HANDLERTON_OOM = 10243
ER_CONN_SHM_LISTENER = 10244
ER_CONN_SHM_CANT_CREATE_SERVICE = 10245
ER_CONN_SHM_CANT_CREATE_CONNECTION = 10246
ER_CONN_PIP_CANT_CREATE_EVENT = 10247
ER_CONN_PIP_CANT_CREATE_PIPE = 10248
ER_CONN_PER_THREAD_NO_THREAD = 10249
ER_CONN_TCP_NO_SOCKET = 10250
ER_CONN_TCP_CREATED = 10251
ER_CONN_TCP_ADDRESS = 10252
ER_CONN_TCP_IPV6_AVAILABLE = 10253
ER_CONN_TCP_IPV6_UNAVAILABLE = 10254
ER_CONN_TCP_ERROR_WITH_STRERROR = 10255
ER_CONN_TCP_CANT_RESOLVE_HOSTNAME = 10256
ER_CONN_TCP_IS_THERE_ANOTHER_USING_PORT = 10257
ER_CONN_UNIX_IS_THERE_ANOTHER_USING_SOCKET = 10258
ER_CONN_UNIX_PID_CLAIMED_SOCKET_FILE = 10259
ER_CONN_TCP_CANT_RESET_V6ONLY = 10260
ER_CONN_TCP_BIND_RETRY = 10261
ER_CONN_TPC_BIND_FAIL = 10262
ER_CONN_TCP_IP_NOT_LOGGED = 10263
ER_CONN_TCP_RESOLVE_INFO = 10264
ER_CONN_TCP_START_FAIL = 10265
ER_CONN_TCP_LISTEN_FAIL = 10266
ER_CONN_UNIX_PATH_TOO_LONG = 10267
ER_CONN_UNIX_LOCK_FILE_FAIL = 10268
ER_CONN_UNIX_NO_FD = 10269
ER_CONN_UNIX_NO_BIND_NO_START = 10270
ER_CONN_UNIX_LISTEN_FAILED = 10271
ER_CONN_UNIX_LOCK_FILE_GIVING_UP = 10272
ER_CONN_UNIX_LOCK_FILE_CANT_CREATE = 10273
ER_CONN_UNIX_LOCK_FILE_CANT_OPEN = 10274
ER_CONN_UNIX_LOCK_FILE_CANT_READ = 10275
ER_CONN_UNIX_LOCK_FILE_EMPTY = 10276
ER_CONN_UNIX_LOCK_FILE_PIDLESS = 10277
ER_CONN_UNIX_LOCK_FILE_CANT_WRITE = 10278
ER_CONN_UNIX_LOCK_FILE_CANT_DELETE = 10279
ER_CONN_UNIX_LOCK_FILE_CANT_SYNC = 10280
ER_CONN_UNIX_LOCK_FILE_CANT_CLOSE = 10281
ER_CONN_SOCKET_SELECT_FAILED = 10282
ER_CONN_SOCKET_ACCEPT_FAILED = 10283
ER_AUTH_RSA_CANT_FIND = 10284
ER_AUTH_RSA_CANT_PARSE = 10285
ER_AUTH_RSA_CANT_READ = 10286
ER_AUTH_RSA_FILES_NOT_FOUND = 10287
ER_CONN_ATTR_TRUNCATED = 10288
ER_X509_CIPHERS_MISMATCH = 10289
ER_X509_ISSUER_MISMATCH = 10290
ER_X509_SUBJECT_MISMATCH = 10291
ER_AUTH_CANT_ACTIVATE_ROLE = 10292
ER_X509_NEEDS_RSA_PRIVKEY = 10293
ER_X509_CANT_WRITE_KEY = 10294
ER_X509_CANT_CHMOD_KEY = 10295
ER_X509_CANT_READ_CA_KEY = 10296
ER_X509_CANT_READ_CA_CERT = 10297
ER_X509_CANT_CREATE_CERT = 10298
ER_X509_CANT_WRITE_CERT = 10299
ER_AUTH_CANT_CREATE_RSA_PAIR = 10300
ER_AUTH_CANT_WRITE_PRIVKEY = 10301
ER_AUTH_CANT_WRITE_PUBKEY = 10302
ER_AUTH_SSL_CONF_PREVENTS_CERT_GENERATION = 10303
ER_AUTH_USING_EXISTING_CERTS = 10304
ER_AUTH_CERTS_SAVED_TO_DATADIR = 10305
ER_AUTH_CERT_GENERATION_DISABLED = 10306
ER_AUTH_RSA_CONF_PREVENTS_KEY_GENERATION = 10307
ER_AUTH_KEY_GENERATION_SKIPPED_PAIR_PRESENT = 10308
ER_AUTH_KEYS_SAVED_TO_DATADIR = 10309
ER_AUTH_KEY_GENERATION_DISABLED = 10310
ER_AUTHCACHE_PROXIES_PRIV_SKIPPED_NEEDS_RESOLVE = 10311
ER_AUTHCACHE_PLUGIN_MISSING = 10312
ER_AUTHCACHE_PLUGIN_CONFIG = 10313
OBSOLETE_ER_AUTHCACHE_ROLE_TABLES_DODGY = 10314
ER_AUTHCACHE_USER_SKIPPED_NEEDS_RESOLVE = 10315
ER_AUTHCACHE_USER_TABLE_DODGY = 10316
ER_AUTHCACHE_USER_IGNORED_DEPRECATED_PASSWORD = 10317
ER_AUTHCACHE_USER_IGNORED_NEEDS_PLUGIN = 10318
ER_AUTHCACHE_USER_IGNORED_INVALID_PASSWORD = 10319
ER_AUTHCACHE_EXPIRED_PASSWORD_UNSUPPORTED = 10320
ER_NO_SUPER_WITHOUT_USER_PLUGIN = 10321
ER_AUTHCACHE_DB_IGNORED_EMPTY_NAME = 10322
ER_AUTHCACHE_DB_SKIPPED_NEEDS_RESOLVE = 10323
ER_AUTHCACHE_DB_ENTRY_LOWERCASED_REVOKE_WILL_FAIL = 10324
ER_AUTHCACHE_TABLE_PROXIES_PRIV_MISSING = 10325
ER_AUTHCACHE_CANT_OPEN_AND_LOCK_PRIVILEGE_TABLES = 10326
ER_AUTHCACHE_CANT_INIT_GRANT_SUBSYSTEM = 10327
ER_AUTHCACHE_PROCS_PRIV_SKIPPED_NEEDS_RESOLVE = 10328
ER_AUTHCACHE_PROCS_PRIV_ENTRY_IGNORED_BAD_ROUTINE_TYPE = 10329
ER_AUTHCACHE_TABLES_PRIV_SKIPPED_NEEDS_RESOLVE = 10330
ER_USER_NOT_IN_EXTRA_USERS_BINLOG_POSSIBLY_INCOMPLETE = 10331
ER_DD_SCHEMA_NOT_FOUND = 10332
ER_DD_TABLE_NOT_FOUND = 10333
ER_DD_SE_INIT_FAILED = 10334
ER_DD_ABORTING_PARTIAL_UPGRADE = 10335
ER_DD_FRM_EXISTS_FOR_TABLE = 10336
ER_DD_CREATED_FOR_UPGRADE = 10337
ER_ERRMSG_CANT_FIND_FILE = 10338
ER_ERRMSG_LOADING_55_STYLE = 10339
ER_ERRMSG_MISSING_IN_FILE = 10340
ER_ERRMSG_OOM = 10341
ER_ERRMSG_CANT_READ = 10342
ER_TABLE_INCOMPATIBLE_DECIMAL_FIELD = 10343
ER_TABLE_INCOMPATIBLE_YEAR_FIELD = 10344
ER_INVALID_CHARSET_AND_DEFAULT_IS_MB = 10345
ER_TABLE_WRONG_KEY_DEFINITION = 10346
ER_CANT_OPEN_FRM_FILE = 10347
ER_CANT_READ_FRM_FILE = 10348
ER_TABLE_CREATED_WITH_DIFFERENT_VERSION = 10349
ER_VIEW_UNPARSABLE = 10350
ER_FILE_TYPE_UNKNOWN = 10351
ER_INVALID_INFO_IN_FRM = 10352
ER_CANT_OPEN_AND_LOCK_PRIVILEGE_TABLES = 10353
ER_AUDIT_PLUGIN_DOES_NOT_SUPPORT_AUDIT_AUTH_EVENTS = 10354
ER_AUDIT_PLUGIN_HAS_INVALID_DATA = 10355
ER_TZ_OOM_INITIALIZING_TIME_ZONES = 10356
ER_TZ_CANT_OPEN_AND_LOCK_TIME_ZONE_TABLE = 10357
ER_TZ_OOM_LOADING_LEAP_SECOND_TABLE = 10358
ER_TZ_TOO_MANY_LEAPS_IN_LEAP_SECOND_TABLE = 10359
ER_TZ_ERROR_LOADING_LEAP_SECOND_TABLE = 10360
ER_TZ_UNKNOWN_OR_ILLEGAL_DEFAULT_TIME_ZONE = 10361
ER_TZ_CANT_FIND_DESCRIPTION_FOR_TIME_ZONE = 10362
ER_TZ_CANT_FIND_DESCRIPTION_FOR_TIME_ZONE_ID = 10363
ER_TZ_TRANSITION_TYPE_TABLE_TYPE_TOO_LARGE = 10364
ER_TZ_TRANSITION_TYPE_TABLE_ABBREVIATIONS_EXCEED_SPACE = 10365
ER_TZ_TRANSITION_TYPE_TABLE_LOAD_ERROR = 10366
ER_TZ_TRANSITION_TABLE_TOO_MANY_TRANSITIONS = 10367
ER_TZ_TRANSITION_TABLE_BAD_TRANSITION_TYPE = 10368
ER_TZ_TRANSITION_TABLE_LOAD_ERROR = 10369
ER_TZ_NO_TRANSITION_TYPES_IN_TIME_ZONE = 10370
ER_TZ_OOM_LOADING_TIME_ZONE_DESCRIPTION = 10371
ER_TZ_CANT_BUILD_MKTIME_MAP = 10372
ER_TZ_OOM_WHILE_LOADING_TIME_ZONE = 10373
ER_TZ_OOM_WHILE_SETTING_TIME_ZONE = 10374
OBSOLETE_ER_SLAVE_SQL_THREAD_STOPPED_UNTIL_CONDITION_BAD = 10375
OBSOLETE_ER_SLAVE_SQL_THREAD_STOPPED_UNTIL_POSITION_REACHED = 10376
OBSOLETE_ER_SLAVE_SQL_THREAD_STOPPED_BEFORE_GTIDS_ALREADY_APPLIED = 10377
OBSOLETE_ER_SLAVE_SQL_THREAD_STOPPED_BEFORE_GTIDS_REACHED = 10378
OBSOLETE_ER_SLAVE_SQL_THREAD_STOPPED_AFTER_GTIDS_REACHED = 10379
OBSOLETE_ER_SLAVE_SQL_THREAD_STOPPED_GAP_TRX_PROCESSED = 10380
ER_REPLICA_SQL_THREAD_STOPPED_UNTIL_CONDITION_BAD = 10375
ER_REPLICA_SQL_THREAD_STOPPED_UNTIL_POSITION_REACHED = 10376
ER_REPLICA_SQL_THREAD_STOPPED_BEFORE_GTIDS_ALREADY_APPLIED = 10377
ER_REPLICA_SQL_THREAD_STOPPED_BEFORE_GTIDS_REACHED = 10378
ER_REPLICA_SQL_THREAD_STOPPED_AFTER_GTIDS_REACHED = 10379
ER_REPLICA_SQL_THREAD_STOPPED_GAP_TRX_PROCESSED = 10380
ER_GROUP_REPLICATION_PLUGIN_NOT_INSTALLED = 10381
ER_GTID_ALREADY_ADDED_BY_USER = 10382
ER_FAILED_TO_DELETE_FROM_GTID_EXECUTED_TABLE = 10383
ER_FAILED_TO_COMPRESS_GTID_EXECUTED_TABLE = 10384
ER_FAILED_TO_COMPRESS_GTID_EXECUTED_TABLE_OOM = 10385
ER_FAILED_TO_INIT_THREAD_ATTR_FOR_GTID_TABLE_COMPRESSION = 10386
ER_FAILED_TO_CREATE_GTID_TABLE_COMPRESSION_THREAD = 10387
ER_FAILED_TO_JOIN_GTID_TABLE_COMPRESSION_THREAD = 10388
ER_NPIPE_FAILED_TO_INIT_SECURITY_DESCRIPTOR = 10389
ER_NPIPE_FAILED_TO_SET_SECURITY_DESCRIPTOR = 10390
ER_NPIPE_PIPE_ALREADY_IN_USE = 10391
OBSOLETE_ER_NDB_SLAVE_SAW_EPOCH_LOWER_THAN_PREVIOUS_ON_START = 10392
OBSOLETE_ER_NDB_SLAVE_SAW_EPOCH_LOWER_THAN_PREVIOUS = 10393
OBSOLETE_ER_NDB_SLAVE_SAW_ALREADY_COMMITTED_EPOCH = 10394
OBSOLETE_ER_NDB_SLAVE_PREVIOUS_EPOCH_NOT_COMMITTED = 10395
OBSOLETE_ER_NDB_SLAVE_MISSING_DATA_FOR_TIMESTAMP_COLUMN = 10396
OBSOLETE_ER_NDB_SLAVE_LOGGING_EXCEPTIONS_TO = 10397
OBSOLETE_ER_NDB_SLAVE_LOW_EPOCH_RESOLUTION = 10398
ER_NDB_REPLICA_SAW_EPOCH_LOWER_THAN_PREVIOUS_ON_START = 10392
ER_NDB_REPLICA_SAW_EPOCH_LOWER_THAN_PREVIOUS = 10393
ER_NDB_REPLICA_SAW_ALREADY_COMMITTED_EPOCH = 10394
ER_NDB_REPLICA_PREVIOUS_EPOCH_NOT_COMMITTED = 10395
ER_NDB_REPLICA_MISSING_DATA_FOR_TIMESTAMP_COLUMN = 10396
ER_NDB_REPLICA_LOGGING_EXCEPTIONS_TO = 10397
ER_NDB_REPLICA_LOW_EPOCH_RESOLUTION = 10398
ER_NDB_INFO_FOUND_UNEXPECTED_FIELD_TYPE = 10399
ER_NDB_INFO_FAILED_TO_CREATE_NDBINFO = 10400
ER_NDB_INFO_FAILED_TO_INIT_NDBINFO = 10401
ER_NDB_CLUSTER_WRONG_NUMBER_OF_FUNCTION_ARGUMENTS = 10402
ER_NDB_CLUSTER_SCHEMA_INFO = 10403
ER_NDB_CLUSTER_GENERIC_MESSAGE = 10404
ER_RPL_CANT_OPEN_INFO_TABLE = 10405
ER_RPL_CANT_SCAN_INFO_TABLE = 10406
ER_RPL_CORRUPTED_INFO_TABLE = 10407
ER_RPL_CORRUPTED_KEYS_IN_INFO_TABLE = 10408
ER_RPL_WORKER_ID_IS = 10409
ER_RPL_INCONSISTENT_TIMESTAMPS_IN_TRX = 10410
ER_RPL_INCONSISTENT_SEQUENCE_NO_IN_TRX = 10411
ER_RPL_CHANNELS_REQUIRE_TABLES_AS_INFO_REPOSITORIES = 10412
ER_RPL_CHANNELS_REQUIRE_NON_ZERO_SERVER_ID = 10413
ER_RPL_REPO_SHOULD_BE_TABLE = 10414
OBSOLETE_ER_RPL_ERROR_CREATING_MASTER_INFO = 10415
OBSOLETE_ER_RPL_ERROR_CHANGING_MASTER_INFO_REPO_TYPE = 10416
ER_RPL_ERROR_CREATING_SOURCE_INFO = 10415
ER_RPL_ERROR_CHANGING_SOURCE_INFO_REPO_TYPE = 10416
ER_RPL_CHANGING_RELAY_LOG_INFO_REPO_TYPE_FAILED_DUE_TO_GAPS = 10417
ER_RPL_ERROR_CREATING_RELAY_LOG_INFO = 10418
ER_RPL_ERROR_CHANGING_RELAY_LOG_INFO_REPO_TYPE = 10419
OBSOLETE_ER_RPL_FAILED_TO_DELETE_FROM_SLAVE_WORKERS_INFO_REPOSITORY = 10420
OBSOLETE_ER_RPL_FAILED_TO_RESET_STATE_IN_SLAVE_INFO_REPOSITORY = 10421
ER_RPL_FAILED_TO_DELETE_FROM_REPLICA_WORKERS_INFO_REPOSITORY = 10420
ER_RPL_FAILED_TO_RESET_STATE_IN_REPLICA_INFO_REPOSITORY = 10421
OBSOLETE_ER_RPL_SLAVE_GENERIC_MESSAGE = 10423
OBSOLETE_ER_RPL_SLAVE_COULD_NOT_CREATE_CHANNEL_LIST = 10424
ER_RPL_ERROR_CHECKING_REPOSITORY = 10422
ER_RPL_REPLICA_GENERIC_MESSAGE = 10423
ER_RPL_REPLICA_COULD_NOT_CREATE_CHANNEL_LIST = 10424
ER_RPL_MULTISOURCE_REQUIRES_TABLE_TYPE_REPOSITORIES = 10425
OBSOLETE_ER_RPL_SLAVE_FAILED_TO_INIT_A_MASTER_INFO_STRUCTURE = 10426
OBSOLETE_ER_RPL_SLAVE_FAILED_TO_INIT_MASTER_INFO_STRUCTURE = 10427
OBSOLETE_ER_RPL_SLAVE_FAILED_TO_CREATE_CHANNEL_FROM_MASTER_INFO = 10428
ER_RPL_REPLICA_FAILED_TO_INIT_A_SOURCE_INFO_STRUCTURE = 10426
ER_RPL_REPLICA_FAILED_TO_INIT_SOURCE_INFO_STRUCTURE = 10427
ER_RPL_REPLICA_FAILED_TO_CREATE_CHANNEL_FROM_SOURCE_INFO = 10428
ER_RPL_FAILED_TO_CREATE_NEW_INFO_FILE = 10429
ER_RPL_FAILED_TO_CREATE_CACHE_FOR_INFO_FILE = 10430
ER_RPL_FAILED_TO_OPEN_INFO_FILE = 10431
ER_RPL_GTID_MEMORY_FINALLY_AVAILABLE = 10432
ER_SERVER_COST_UNKNOWN_COST_CONSTANT = 10433
ER_SERVER_COST_INVALID_COST_CONSTANT = 10434
ER_ENGINE_COST_UNKNOWN_COST_CONSTANT = 10435
ER_ENGINE_COST_UNKNOWN_STORAGE_ENGINE = 10436
ER_ENGINE_COST_INVALID_DEVICE_TYPE_FOR_SE = 10437
ER_ENGINE_COST_INVALID_CONST_CONSTANT_FOR_SE_AND_DEVICE = 10438
ER_SERVER_COST_FAILED_TO_READ = 10439
ER_ENGINE_COST_FAILED_TO_READ = 10440
ER_FAILED_TO_OPEN_COST_CONSTANT_TABLES = 10441
ER_RPL_UNSUPPORTED_UNIGNORABLE_EVENT_IN_STREAM = 10442
ER_RPL_GTID_LOG_EVENT_IN_STREAM = 10443
ER_RPL_UNEXPECTED_BEGIN_IN_STREAM = 10444
ER_RPL_UNEXPECTED_COMMIT_ROLLBACK_OR_XID_LOG_EVENT_IN_STREAM = 10445
ER_RPL_UNEXPECTED_XA_ROLLBACK_IN_STREAM = 10446
ER_EVENT_EXECUTION_FAILED_CANT_AUTHENTICATE_USER = 10447
ER_EVENT_EXECUTION_FAILED_USER_LOST_EVEN_PRIVILEGE = 10448
ER_EVENT_ERROR_DURING_COMPILATION = 10449
ER_EVENT_DROPPING = 10450
ER_NDB_SCHEMA_GENERIC_MESSAGE = 10451
ER_RPL_INCOMPATIBLE_DECIMAL_IN_RBR = 10452
ER_INIT_ROOT_WITHOUT_PASSWORD = 10453
ER_INIT_GENERATING_TEMP_PASSWORD_FOR_ROOT = 10454
ER_INIT_CANT_OPEN_BOOTSTRAP_FILE = 10455
ER_INIT_BOOTSTRAP_COMPLETE = 10456
ER_INIT_DATADIR_NOT_EMPTY_WONT_INITIALIZE = 10457
ER_INIT_DATADIR_EXISTS_WONT_INITIALIZE = 10458
ER_INIT_DATADIR_EXISTS_AND_PATH_TOO_LONG_WONT_INITIALIZE = 10459
ER_INIT_DATADIR_EXISTS_AND_NOT_WRITABLE_WONT_INITIALIZE = 10460
ER_INIT_CREATING_DD = 10461
ER_RPL_BINLOG_STARTING_DUMP = 10462
OBSOLETE_ER_RPL_BINLOG_MASTER_SENDS_HEARTBEAT = 10463
ER_RPL_BINLOG_SOURCE_SENDS_HEARTBEAT = 10463
ER_RPL_BINLOG_SKIPPING_REMAINING_HEARTBEAT_INFO = 10464
OBSOLETE_ER_RPL_BINLOG_MASTER_USES_CHECKSUM_AND_SLAVE_CANT = 10465
ER_RPL_BINLOG_SOURCE_USES_CHECKSUM_AND_REPLICA_CANT = 10465
ER_NDB_QUERY_FAILED = 10466
ER_KILLING_THREAD = 10467
ER_DETACHING_SESSION_LEFT_BY_PLUGIN = 10468
ER_CANT_DETACH_SESSION_LEFT_BY_PLUGIN = 10469
ER_DETACHED_SESSIONS_LEFT_BY_PLUGIN = 10470
ER_FAILED_TO_DECREMENT_NUMBER_OF_THREADS = 10471
ER_PLUGIN_DID_NOT_DEINITIALIZE_THREADS = 10472
ER_KILLED_THREADS_OF_PLUGIN = 10473
OBSOLETE_ER_NDB_SLAVE_MAX_REPLICATED_EPOCH_UNKNOWN = 10474
OBSOLETE_ER_NDB_SLAVE_MAX_REPLICATED_EPOCH_SET_TO = 10475
ER_NDB_REPLICA_MAX_REPLICATED_EPOCH_UNKNOWN = 10474
ER_NDB_REPLICA_MAX_REPLICATED_EPOCH_SET_TO = 10475
ER_NDB_NODE_ID_AND_MANAGEMENT_SERVER_INFO = 10476
ER_NDB_DISCONNECT_INFO = 10477
ER_NDB_COLUMN_DEFAULTS_DIFFER = 10478
ER_NDB_COLUMN_SHOULD_NOT_HAVE_NATIVE_DEFAULT = 10479
ER_NDB_FIELD_INFO = 10480
ER_NDB_COLUMN_INFO = 10481
ER_NDB_OOM_IN_FIX_UNIQUE_INDEX_ATTR_ORDER = 10482
OBSOLETE_ER_NDB_SLAVE_MALFORMED_EVENT_RECEIVED_ON_TABLE = 10483
OBSOLETE_ER_NDB_SLAVE_CONFLICT_FUNCTION_REQUIRES_ROLE = 10484
OBSOLETE_ER_NDB_SLAVE_CONFLICT_DETECTION_REQUIRES_TRANSACTION_IDS = 10485
OBSOLETE_ER_NDB_SLAVE_BINLOG_MISSING_INFO_FOR_CONFLICT_DETECTION = 10486
ER_NDB_REPLICA_MALFORMED_EVENT_RECEIVED_ON_TABLE = 10483
ER_NDB_REPLICA_CONFLICT_FUNCTION_REQUIRES_ROLE = 10484
ER_NDB_REPLICA_CONFLICT_DETECTION_REQUIRES_TRANSACTION_IDS = 10485
ER_NDB_REPLICA_BINLOG_MISSING_INFO_FOR_CONFLICT_DETECTION = 10486
ER_NDB_ERROR_IN_READAUTOINCREMENTVALUE = 10487
ER_NDB_FOUND_UNCOMMITTED_AUTOCOMMIT = 10488
OBSOLETE_ER_NDB_SLAVE_TOO_MANY_RETRIES = 10489
OBSOLETE_ER_NDB_SLAVE_ERROR_IN_UPDATE_CREATE_INFO = 10490
OBSOLETE_ER_NDB_SLAVE_CANT_ALLOCATE_TABLE_SHARE = 10491
ER_NDB_REPLICA_TOO_MANY_RETRIES = 10489
ER_NDB_REPLICA_ERROR_IN_UPDATE_CREATE_INFO = 10490
ER_NDB_REPLICA_CANT_ALLOCATE_TABLE_SHARE = 10491
ER_NDB_BINLOG_ERROR_INFO_FROM_DA = 10492
ER_NDB_BINLOG_CREATE_TABLE_EVENT = 10493
ER_NDB_BINLOG_FAILED_CREATE_TABLE_EVENT_OPERATIONS = 10494
ER_NDB_BINLOG_RENAME_EVENT = 10495
ER_NDB_BINLOG_FAILED_CREATE_EVENT_OPERATIONS_DURING_RENAME = 10496
ER_NDB_UNEXPECTED_RENAME_TYPE = 10497
ER_NDB_ERROR_IN_GET_AUTO_INCREMENT = 10498
ER_NDB_CREATING_SHARE_IN_OPEN = 10499
ER_NDB_TABLE_OPENED_READ_ONLY = 10500
ER_NDB_INITIALIZE_GIVEN_CLUSTER_PLUGIN_DISABLED = 10501
ER_NDB_BINLOG_FORMAT_CHANGED_FROM_STMT_TO_MIXED = 10502
ER_NDB_TRAILING_SHARE_RELEASED_BY_CLOSE_CACHED_TABLES = 10503
ER_NDB_SHARE_ALREADY_EXISTS = 10504
ER_NDB_HANDLE_TRAILING_SHARE_INFO = 10505
ER_NDB_CLUSTER_GET_SHARE_INFO = 10506
ER_NDB_CLUSTER_REAL_FREE_SHARE_INFO = 10507
ER_NDB_CLUSTER_REAL_FREE_SHARE_DROP_FAILED = 10508
ER_NDB_CLUSTER_FREE_SHARE_INFO = 10509
ER_NDB_CLUSTER_MARK_SHARE_DROPPED_INFO = 10510
ER_NDB_CLUSTER_MARK_SHARE_DROPPED_DESTROYING_SHARE = 10511
ER_NDB_CLUSTER_OOM_THD_NDB = 10512
ER_NDB_BINLOG_NDB_TABLES_INITIALLY_READ_ONLY = 10513
ER_NDB_UTIL_THREAD_OOM = 10514
ER_NDB_ILLEGAL_VALUE_FOR_NDB_RECV_THREAD_CPU_MASK = 10515
ER_NDB_TOO_MANY_CPUS_IN_NDB_RECV_THREAD_CPU_MASK = 10516
ER_DBUG_CHECK_SHARES_OPEN = 10517
ER_DBUG_CHECK_SHARES_INFO = 10518
ER_DBUG_CHECK_SHARES_DROPPED = 10519
ER_INVALID_OR_OLD_TABLE_OR_DB_NAME = 10520
ER_TC_RECOVERING_AFTER_CRASH_USING = 10521
ER_TC_CANT_AUTO_RECOVER_WITH_TC_HEURISTIC_RECOVER = 10522
ER_TC_BAD_MAGIC_IN_TC_LOG = 10523
ER_TC_NEED_N_SE_SUPPORTING_2PC_FOR_RECOVERY = 10524
ER_TC_RECOVERY_FAILED_THESE_ARE_YOUR_OPTIONS = 10525
ER_TC_HEURISTIC_RECOVERY_MODE = 10526
ER_TC_HEURISTIC_RECOVERY_FAILED = 10527
ER_TC_RESTART_WITHOUT_TC_HEURISTIC_RECOVER = 10528
OBSOLETE_ER_RPL_SLAVE_FAILED_TO_CREATE_OR_RECOVER_INFO_REPOSITORIES = 10529
OBSOLETE_ER_RPL_SLAVE_AUTO_POSITION_IS_1_AND_GTID_MODE_IS_OFF = 10530
OBSOLETE_ER_RPL_SLAVE_CANT_START_SLAVE_FOR_CHANNEL = 10531
OBSOLETE_ER_RPL_SLAVE_CANT_STOP_SLAVE_FOR_CHANNEL = 10532
OBSOLETE_ER_RPL_RECOVERY_NO_ROTATE_EVENT_FROM_MASTER = 10533
ER_RPL_REPLICA_FAILED_TO_CREATE_OR_RECOVER_INFO_REPOSITORIES = 10529
ER_RPL_REPLICA_AUTO_POSITION_IS_1_AND_GTID_MODE_IS_OFF = 10530
ER_RPL_REPLICA_CANT_START_REPLICA_FOR_CHANNEL = 10531
ER_RPL_REPLICA_CANT_STOP_REPLICA_FOR_CHANNEL = 10532
ER_RPL_RECOVERY_NO_ROTATE_EVENT_FROM_SOURCE = 10533
ER_RPL_RECOVERY_ERROR_READ_RELAY_LOG = 10534
ER_RPL_RECOVERY_ERROR_FREEING_IO_CACHE = 10535
ER_RPL_RECOVERY_SKIPPED_GROUP_REPLICATION_CHANNEL = 10536
ER_RPL_RECOVERY_ERROR = 10537
ER_RPL_RECOVERY_IO_ERROR_READING_RELAY_LOG_INDEX = 10538
OBSOLETE_ER_RPL_RECOVERY_FILE_MASTER_POS_INFO = 10539
ER_RPL_RECOVERY_FILE_SOURCE_POS_INFO = 10539
ER_RPL_RECOVERY_REPLICATE_SAME_SERVER_ID_REQUIRES_POSITION = 10540
ER_RPL_MTS_RECOVERY_STARTING_COORDINATOR = 10541
ER_RPL_MTS_RECOVERY_FAILED_TO_START_COORDINATOR = 10542
ER_RPL_MTS_AUTOMATIC_RECOVERY_FAILED = 10543
ER_RPL_MTS_RECOVERY_CANT_OPEN_RELAY_LOG = 10544
ER_RPL_MTS_RECOVERY_SUCCESSFUL = 10545
ER_RPL_SERVER_ID_MISSING = 10546
OBSOLETE_ER_RPL_CANT_CREATE_SLAVE_THREAD = 10547
OBSOLETE_ER_RPL_SLAVE_IO_THREAD_WAS_KILLED = 10548
OBSOLETE_ER_RPL_SLAVE_MASTER_UUID_HAS_CHANGED = 10549
OBSOLETE_ER_RPL_SLAVE_USES_CHECKSUM_AND_MASTER_PRE_50 = 10550
OBSOLETE_ER_RPL_SLAVE_SECONDS_BEHIND_MASTER_DUBIOUS = 10551
OBSOLETE_ER_RPL_SLAVE_CANT_FLUSH_MASTER_INFO_FILE = 10552
OBSOLETE_ER_RPL_SLAVE_REPORT_HOST_TOO_LONG = 10553
OBSOLETE_ER_RPL_SLAVE_REPORT_USER_TOO_LONG = 10554
OBSOLETE_ER_RPL_SLAVE_REPORT_PASSWORD_TOO_LONG = 10555
OBSOLETE_ER_RPL_SLAVE_ERROR_RETRYING = 10556
OBSOLETE_ER_RPL_SLAVE_ERROR_READING_FROM_SERVER = 10557
OBSOLETE_ER_RPL_SLAVE_DUMP_THREAD_KILLED_BY_MASTER = 10558
ER_RPL_CANT_CREATE_REPLICA_THREAD = 10547
ER_RPL_REPLICA_IO_THREAD_WAS_KILLED = 10548
ER_RPL_REPLICA_SOURCE_UUID_HAS_CHANGED = 10549
ER_RPL_REPLICA_USES_CHECKSUM_AND_SOURCE_PRE_50 = 10550
ER_RPL_REPLICA_SECONDS_BEHIND_SOURCE_DUBIOUS = 10551
ER_RPL_REPLICA_CANT_FLUSH_SOURCE_INFO_FILE = 10552
ER_RPL_REPLICA_REPORT_HOST_TOO_LONG = 10553
ER_RPL_REPLICA_REPORT_USER_TOO_LONG = 10554
ER_RPL_REPLICA_REPORT_PASSWORD_TOO_LONG = 10555
ER_RPL_REPLICA_ERROR_RETRYING = 10556
ER_RPL_REPLICA_ERROR_READING_FROM_SERVER = 10557
ER_RPL_REPLICA_DUMP_THREAD_KILLED_BY_SOURCE = 10558
ER_RPL_MTS_STATISTICS = 10559
ER_RPL_MTS_RECOVERY_COMPLETE = 10560
OBSOLETE_ER_RPL_SLAVE_CANT_INIT_RELAY_LOG_POSITION = 10561
OBSOLETE_ER_RPL_SLAVE_CONNECTED_TO_MASTER_REPLICATION_STARTED = 10562
OBSOLETE_ER_RPL_SLAVE_IO_THREAD_KILLED = 10563
OBSOLETE_ER_RPL_SLAVE_IO_THREAD_CANT_REGISTER_ON_MASTER = 10564
OBSOLETE_ER_RPL_SLAVE_FORCING_TO_RECONNECT_IO_THREAD = 10565
OBSOLETE_ER_RPL_SLAVE_ERROR_REQUESTING_BINLOG_DUMP = 10566
OBSOLETE_ER_RPL_LOG_ENTRY_EXCEEDS_SLAVE_MAX_ALLOWED_PACKET = 10567
OBSOLETE_ER_RPL_SLAVE_STOPPING_AS_MASTER_OOM = 10568
OBSOLETE_ER_RPL_SLAVE_IO_THREAD_ABORTED_WAITING_FOR_RELAY_LOG_SPACE = 10569
OBSOLETE_ER_RPL_SLAVE_IO_THREAD_EXITING = 10570
OBSOLETE_ER_RPL_SLAVE_CANT_INITIALIZE_SLAVE_WORKER = 10571
ER_RPL_REPLICA_CANT_INIT_RELAY_LOG_POSITION = 10561
ER_RPL_REPLICA_CONNECTED_TO_SOURCE_REPLICATION_STARTED = 10562
ER_RPL_REPLICA_IO_THREAD_KILLED = 10563
ER_RPL_REPLICA_IO_THREAD_CANT_REGISTER_ON_SOURCE = 10564
ER_RPL_REPLICA_FORCING_TO_RECONNECT_IO_THREAD = 10565
ER_RPL_REPLICA_ERROR_REQUESTING_BINLOG_DUMP = 10566
ER_RPL_LOG_ENTRY_EXCEEDS_REPLICA_MAX_ALLOWED_PACKET = 10567
ER_RPL_REPLICA_STOPPING_AS_SOURCE_OOM = 10568
ER_RPL_REPLICA_IO_THREAD_ABORTED_WAITING_FOR_RELAY_LOG_SPACE = 10569
ER_RPL_REPLICA_IO_THREAD_EXITING = 10570
ER_RPL_REPLICA_CANT_INITIALIZE_REPLICA_WORKER = 10571
ER_RPL_MTS_GROUP_RECOVERY_RELAY_LOG_INFO_FOR_WORKER = 10572
ER_RPL_ERROR_LOOKING_FOR_LOG = 10573
ER_RPL_MTS_GROUP_RECOVERY_RELAY_LOG_INFO = 10574
ER_RPL_CANT_FIND_FOLLOWUP_FILE = 10575
ER_RPL_MTS_CHECKPOINT_PERIOD_DIFFERS_FROM_CNT = 10576
OBSOLETE_ER_RPL_SLAVE_WORKER_THREAD_CREATION_FAILED = 10577
OBSOLETE_ER_RPL_SLAVE_WORKER_THREAD_CREATION_FAILED_WITH_ERRNO = 10578
OBSOLETE_ER_RPL_SLAVE_FAILED_TO_INIT_PARTITIONS_HASH = 10579
OBSOLETE_ER_RPL_SLAVE_NDB_TABLES_NOT_AVAILABLE = 10580
OBSOLETE_ER_RPL_SLAVE_SQL_THREAD_STARTING = 10581
OBSOLETE_ER_RPL_SLAVE_SKIP_COUNTER_EXECUTED = 10582
OBSOLETE_ER_RPL_SLAVE_ADDITIONAL_ERROR_INFO_FROM_DA = 10583
OBSOLETE_ER_RPL_SLAVE_ERROR_INFO_FROM_DA = 10584
OBSOLETE_ER_RPL_SLAVE_ERROR_LOADING_USER_DEFINED_LIBRARY = 10585
OBSOLETE_ER_RPL_SLAVE_ERROR_RUNNING_QUERY = 10586
OBSOLETE_ER_RPL_SLAVE_SQL_THREAD_EXITING = 10587
OBSOLETE_ER_RPL_SLAVE_READ_INVALID_EVENT_FROM_MASTER = 10588
OBSOLETE_ER_RPL_SLAVE_QUEUE_EVENT_FAILED_INVALID_CONFIGURATION = 10589
OBSOLETE_ER_RPL_SLAVE_IO_THREAD_DETECTED_UNEXPECTED_EVENT_SEQUENCE = 10590
OBSOLETE_ER_RPL_SLAVE_CANT_USE_CHARSET = 10591
OBSOLETE_ER_RPL_SLAVE_CONNECTED_TO_MASTER_REPLICATION_RESUMED = 10592
OBSOLETE_ER_RPL_SLAVE_NEXT_LOG_IS_ACTIVE = 10593
OBSOLETE_ER_RPL_SLAVE_NEXT_LOG_IS_INACTIVE = 10594
OBSOLETE_ER_RPL_SLAVE_SQL_THREAD_IO_ERROR_READING_EVENT = 10595
OBSOLETE_ER_RPL_SLAVE_ERROR_READING_RELAY_LOG_EVENTS = 10596
OBSOLETE_ER_SLAVE_CHANGE_MASTER_TO_EXECUTED = 10597
OBSOLETE_ER_RPL_SLAVE_NEW_MASTER_INFO_NEEDS_REPOS_TYPE_OTHER_THAN_FILE = 10598
ER_RPL_REPLICA_WORKER_THREAD_CREATION_FAILED = 10577
ER_RPL_REPLICA_WORKER_THREAD_CREATION_FAILED_WITH_ERRNO = 10578
ER_RPL_REPLICA_FAILED_TO_INIT_PARTITIONS_HASH = 10579
ER_RPL_REPLICA_NDB_TABLES_NOT_AVAILABLE = 10580
ER_RPL_REPLICA_SQL_THREAD_STARTING = 10581
ER_RPL_REPLICA_SKIP_COUNTER_EXECUTED = 10582
ER_RPL_REPLICA_ADDITIONAL_ERROR_INFO_FROM_DA = 10583
ER_RPL_REPLICA_ERROR_INFO_FROM_DA = 10584
ER_RPL_REPLICA_ERROR_LOADING_USER_DEFINED_LIBRARY = 10585
ER_RPL_REPLICA_ERROR_RUNNING_QUERY = 10586
ER_RPL_REPLICA_SQL_THREAD_EXITING = 10587
ER_RPL_REPLICA_READ_INVALID_EVENT_FROM_SOURCE = 10588
ER_RPL_REPLICA_QUEUE_EVENT_FAILED_INVALID_CONFIGURATION = 10589
ER_RPL_REPLICA_IO_THREAD_DETECTED_UNEXPECTED_EVENT_SEQUENCE = 10590
ER_RPL_REPLICA_CANT_USE_CHARSET = 10591
ER_RPL_REPLICA_CONNECTED_TO_SOURCE_REPLICATION_RESUMED = 10592
ER_RPL_REPLICA_NEXT_LOG_IS_ACTIVE = 10593
ER_RPL_REPLICA_NEXT_LOG_IS_INACTIVE = 10594
ER_RPL_REPLICA_SQL_THREAD_IO_ERROR_READING_EVENT = 10595
ER_RPL_REPLICA_ERROR_READING_RELAY_LOG_EVENTS = 10596
ER_REPLICA_CHANGE_SOURCE_TO_EXECUTED = 10597
ER_RPL_REPLICA_NEW_SOURCE_INFO_NEEDS_REPOS_TYPE_OTHER_THAN_FILE = 10598
ER_RPL_FAILED_TO_STAT_LOG_IN_INDEX = 10599
ER_RPL_LOG_NOT_FOUND_WHILE_COUNTING_RELAY_LOG_SPACE = 10600
OBSOLETE_ER_SLAVE_CANT_USE_TEMPDIR = 10601
ER_REPLICA_CANT_USE_TEMPDIR = 10601
ER_RPL_RELAY_LOG_NEEDS_FILE_NOT_DIRECTORY = 10602
ER_RPL_RELAY_LOG_INDEX_NEEDS_FILE_NOT_DIRECTORY = 10603
ER_RPL_PLEASE_USE_OPTION_RELAY_LOG = 10604
ER_RPL_OPEN_INDEX_FILE_FAILED = 10605
ER_RPL_CANT_INITIALIZE_GTID_SETS_IN_RLI_INIT_INFO = 10606
ER_RPL_CANT_OPEN_LOG_IN_RLI_INIT_INFO = 10607
ER_RPL_ERROR_WRITING_RELAY_LOG_CONFIGURATION = 10608
ER_NDB_OOM_GET_NDB_BLOBS_VALUE = 10609
ER_NDB_THREAD_TIMED_OUT = 10610
ER_NDB_TABLE_IS_NOT_DISTRIBUTED = 10611
ER_NDB_CREATING_TABLE = 10612
ER_NDB_FLUSHING_TABLE_INFO = 10613
ER_NDB_CLEANING_STRAY_TABLES = 10614
ER_NDB_DISCOVERED_MISSING_DB = 10615
ER_NDB_DISCOVERED_REMAINING_DB = 10616
ER_NDB_CLUSTER_FIND_ALL_DBS_RETRY = 10617
ER_NDB_CLUSTER_FIND_ALL_DBS_FAIL = 10618
ER_NDB_SKIPPING_SETUP_TABLE = 10619
ER_NDB_FAILED_TO_SET_UP_TABLE = 10620
ER_NDB_MISSING_FRM_DISCOVERING = 10621
ER_NDB_MISMATCH_IN_FRM_DISCOVERING = 10622
ER_NDB_BINLOG_CLEANING_UP_SETUP_LEFTOVERS = 10623
ER_NDB_WAITING_INFO = 10624
ER_NDB_WAITING_INFO_WITH_MAP = 10625
ER_NDB_TIMEOUT_WHILE_DISTRIBUTING = 10626
ER_NDB_NOT_WAITING_FOR_DISTRIBUTING = 10627
ER_NDB_DISTRIBUTED_INFO = 10628
ER_NDB_DISTRIBUTION_COMPLETE = 10629
ER_NDB_SCHEMA_DISTRIBUTION_FAILED = 10630
ER_NDB_SCHEMA_DISTRIBUTION_REPORTS_SUBSCRIBE = 10631
ER_NDB_SCHEMA_DISTRIBUTION_REPORTS_UNSUBSCRIBE = 10632
ER_NDB_BINLOG_CANT_DISCOVER_TABLE_FROM_SCHEMA_EVENT = 10633
ER_NDB_BINLOG_SIGNALLING_UNKNOWN_VALUE = 10634
ER_NDB_BINLOG_REPLY_TO = 10635
ER_NDB_BINLOG_CANT_RELEASE_SLOCK = 10636
ER_NDB_CANT_FIND_TABLE = 10637
ER_NDB_DISCARDING_EVENT_NO_OBJ = 10638
ER_NDB_DISCARDING_EVENT_ID_VERSION_MISMATCH = 10639
ER_NDB_CLEAR_SLOCK_INFO = 10640
ER_NDB_BINLOG_SKIPPING_LOCAL_TABLE = 10641
ER_NDB_BINLOG_ONLINE_ALTER_RENAME = 10642
ER_NDB_BINLOG_CANT_REOPEN_SHADOW_TABLE = 10643
ER_NDB_BINLOG_ONLINE_ALTER_RENAME_COMPLETE = 10644
ER_NDB_BINLOG_SKIPPING_DROP_OF_LOCAL_TABLE = 10645
ER_NDB_BINLOG_SKIPPING_RENAME_OF_LOCAL_TABLE = 10646
ER_NDB_BINLOG_SKIPPING_DROP_OF_DB_CONTAINING_LOCAL_TABLES = 10647
ER_NDB_BINLOG_GOT_DIST_PRIV_EVENT_FLUSHING_PRIVILEGES = 10648
ER_NDB_BINLOG_GOT_SCHEMA_EVENT = 10649
ER_NDB_BINLOG_SKIPPING_OLD_SCHEMA_OPERATION = 10650
ER_NDB_CLUSTER_FAILURE = 10651
ER_NDB_TABLES_INITIALLY_READ_ONLY_ON_RECONNECT = 10652
ER_NDB_IGNORING_UNKNOWN_EVENT = 10653
ER_NDB_BINLOG_OPENING_INDEX = 10654
ER_NDB_BINLOG_CANT_LOCK_NDB_BINLOG_INDEX = 10655
ER_NDB_BINLOG_INJECTING_RANDOM_WRITE_FAILURE = 10656
ER_NDB_BINLOG_CANT_WRITE_TO_NDB_BINLOG_INDEX = 10657
ER_NDB_BINLOG_WRITING_TO_NDB_BINLOG_INDEX = 10658
ER_NDB_BINLOG_CANT_COMMIT_TO_NDB_BINLOG_INDEX = 10659
ER_NDB_BINLOG_WRITE_TO_NDB_BINLOG_INDEX_FAILED_AFTER_KILL = 10660
OBSOLETE_ER_NDB_BINLOG_USING_SERVER_ID_0_SLAVES_WILL_NOT = 10661
ER_NDB_BINLOG_USING_SERVER_ID_0_REPLICAS_WILL_NOT = 10661
ER_NDB_SERVER_ID_RESERVED_OR_TOO_LARGE = 10662
ER_NDB_BINLOG_NDB_LOG_TRANSACTION_ID_REQUIRES_V2_ROW_EVENTS = 10663
ER_NDB_BINLOG_NDB_LOG_APPLY_STATUS_FORCING_FULL_USE_WRITE = 10664
ER_NDB_BINLOG_GENERIC_MESSAGE = 10665
ER_NDB_CONFLICT_GENERIC_MESSAGE = 10666
ER_NDB_TRANS_DEPENDENCY_TRACKER_ERROR = 10667
ER_NDB_CONFLICT_FN_PARSE_ERROR = 10668
ER_NDB_CONFLICT_FN_SETUP_ERROR = 10669
ER_NDB_BINLOG_FAILED_TO_GET_TABLE = 10670
ER_NDB_BINLOG_NOT_LOGGING = 10671
ER_NDB_BINLOG_CREATE_TABLE_EVENT_FAILED = 10672
ER_NDB_BINLOG_CREATE_TABLE_EVENT_INFO = 10673
ER_NDB_BINLOG_DISCOVER_TABLE_EVENT_INFO = 10674
ER_NDB_BINLOG_BLOB_REQUIRES_PK = 10675
ER_NDB_BINLOG_CANT_CREATE_EVENT_IN_DB = 10676
ER_NDB_BINLOG_CANT_CREATE_EVENT_IN_DB_AND_CANT_DROP = 10677
ER_NDB_BINLOG_CANT_CREATE_EVENT_IN_DB_DROPPED = 10678
ER_NDB_BINLOG_DISCOVER_REUSING_OLD_EVENT_OPS = 10679
ER_NDB_BINLOG_CREATING_NDBEVENTOPERATION_FAILED = 10680
ER_NDB_BINLOG_CANT_CREATE_BLOB = 10681
ER_NDB_BINLOG_NDBEVENT_EXECUTE_FAILED = 10682
ER_NDB_CREATE_EVENT_OPS_LOGGING_INFO = 10683
ER_NDB_BINLOG_CANT_DROP_EVENT_FROM_DB = 10684
ER_NDB_TIMED_OUT_IN_DROP_TABLE = 10685
ER_NDB_BINLOG_UNHANDLED_ERROR_FOR_TABLE = 10686
ER_NDB_BINLOG_CLUSTER_FAILURE = 10687
ER_NDB_BINLOG_UNKNOWN_NON_DATA_EVENT = 10688
ER_NDB_BINLOG_INJECTOR_DISCARDING_ROW_EVENT_METADATA = 10689
ER_NDB_REMAINING_OPEN_TABLES = 10690
ER_NDB_REMAINING_OPEN_TABLE_INFO = 10691
ER_NDB_COULD_NOT_GET_APPLY_STATUS_SHARE = 10692
ER_NDB_BINLOG_SERVER_SHUTDOWN_DURING_NDB_CLUSTER_START = 10693
OBSOLETE_ER_NDB_BINLOG_CLUSTER_RESTARTED_RESET_MASTER_SUGGESTED = 10694
ER_NDB_BINLOG_CLUSTER_RESTARTED_RESET_SOURCE_SUGGESTED = 10694
ER_NDB_BINLOG_CLUSTER_HAS_RECONNECTED = 10695
ER_NDB_BINLOG_STARTING_LOG_AT_EPOCH = 10696
ER_NDB_BINLOG_NDB_TABLES_WRITABLE = 10697
ER_NDB_BINLOG_SHUTDOWN_DETECTED = 10698
ER_NDB_BINLOG_LOST_SCHEMA_CONNECTION_WAITING = 10699
ER_NDB_BINLOG_LOST_SCHEMA_CONNECTION_CONTINUING = 10700
ER_NDB_BINLOG_ERROR_HANDLING_SCHEMA_EVENT = 10701
ER_NDB_BINLOG_CANT_INJECT_APPLY_STATUS_WRITE_ROW = 10702
ER_NDB_BINLOG_ERROR_DURING_GCI_ROLLBACK = 10703
ER_NDB_BINLOG_ERROR_DURING_GCI_COMMIT = 10704
ER_NDB_BINLOG_LATEST_TRX_IN_EPOCH_NOT_IN_BINLOG = 10705
ER_NDB_BINLOG_RELEASING_EXTRA_SHARE_REFERENCES = 10706
ER_NDB_BINLOG_REMAINING_OPEN_TABLES = 10707
ER_NDB_BINLOG_REMAINING_OPEN_TABLE_INFO = 10708
ER_TREE_CORRUPT_PARENT_SHOULD_POINT_AT_PARENT = 10709
ER_TREE_CORRUPT_ROOT_SHOULD_BE_BLACK = 10710
ER_TREE_CORRUPT_2_CONSECUTIVE_REDS = 10711
ER_TREE_CORRUPT_RIGHT_IS_LEFT = 10712
ER_TREE_CORRUPT_INCORRECT_BLACK_COUNT = 10713
ER_WRONG_COUNT_FOR_ORIGIN = 10714
ER_WRONG_COUNT_FOR_KEY = 10715
ER_WRONG_COUNT_OF_ELEMENTS = 10716
OBSOLETE_ER_RPL_ERROR_READING_SLAVE_WORKER_CONFIGURATION = 10717
OBSOLETE_ER_RPL_ERROR_WRITING_SLAVE_WORKER_CONFIGURATION = 10718
ER_RPL_ERROR_READING_REPLICA_WORKER_CONFIGURATION = 10717
ER_RPL_ERROR_WRITING_REPLICA_WORKER_CONFIGURATION = 10718
ER_RPL_FAILED_TO_OPEN_RELAY_LOG = 10719
ER_RPL_WORKER_CANT_READ_RELAY_LOG = 10720
ER_RPL_WORKER_CANT_FIND_NEXT_RELAY_LOG = 10721
OBSOLETE_ER_RPL_MTS_SLAVE_COORDINATOR_HAS_WAITED = 10722
ER_RPL_MTS_REPLICA_COORDINATOR_HAS_WAITED = 10722
ER_BINLOG_FAILED_TO_WRITE_DROP_FOR_TEMP_TABLES = 10723
ER_BINLOG_OOM_WRITING_DELETE_WHILE_OPENING_HEAP_TABLE = 10724
ER_FAILED_TO_REPAIR_TABLE = 10725
ER_FAILED_TO_REMOVE_TEMP_TABLE = 10726
ER_SYSTEM_TABLE_NOT_TRANSACTIONAL = 10727
OBSOLETE_ER_RPL_ERROR_WRITING_MASTER_CONFIGURATION = 10728
OBSOLETE_ER_RPL_ERROR_READING_MASTER_CONFIGURATION = 10729
OBSOLETE_ER_RPL_SSL_INFO_IN_MASTER_INFO_IGNORED = 10730
ER_RPL_ERROR_WRITING_SOURCE_CONFIGURATION = 10728
ER_RPL_ERROR_READING_SOURCE_CONFIGURATION = 10729
ER_RPL_SSL_INFO_IN_SOURCE_INFO_IGNORED = 10730
ER_PLUGIN_FAILED_DEINITIALIZATION = 10731
ER_PLUGIN_HAS_NONZERO_REFCOUNT_AFTER_DEINITIALIZATION = 10732
ER_PLUGIN_SHUTTING_DOWN_PLUGIN = 10733
ER_PLUGIN_REGISTRATION_FAILED = 10734
ER_PLUGIN_CANT_OPEN_PLUGIN_TABLE = 10735
ER_PLUGIN_CANT_LOAD = 10736
ER_PLUGIN_LOAD_PARAMETER_TOO_LONG = 10737
ER_PLUGIN_FORCING_SHUTDOWN = 10738
ER_PLUGIN_HAS_NONZERO_REFCOUNT_AFTER_SHUTDOWN = 10739
ER_PLUGIN_UNKNOWN_VARIABLE_TYPE = 10740
ER_PLUGIN_VARIABLE_SET_READ_ONLY = 10741
ER_PLUGIN_VARIABLE_MISSING_NAME = 10742
ER_PLUGIN_VARIABLE_NOT_ALLOCATED_THREAD_LOCAL = 10743
ER_PLUGIN_OOM = 10744
ER_PLUGIN_BAD_OPTIONS = 10745
ER_PLUGIN_PARSING_OPTIONS_FAILED = 10746
ER_PLUGIN_DISABLED = 10747
ER_PLUGIN_HAS_CONFLICTING_SYSTEM_VARIABLES = 10748
ER_PLUGIN_CANT_SET_PERSISTENT_OPTIONS = 10749
ER_MY_NET_WRITE_FAILED_FALLING_BACK_ON_STDERR = 10750
ER_RETRYING_REPAIR_WITHOUT_QUICK = 10751
ER_RETRYING_REPAIR_WITH_KEYCACHE = 10752
ER_FOUND_ROWS_WHILE_REPAIRING = 10753
ER_ERROR_DURING_OPTIMIZE_TABLE = 10754
ER_ERROR_ENABLING_KEYS = 10755
ER_CHECKING_TABLE = 10756
ER_RECOVERING_TABLE = 10757
ER_CANT_CREATE_TABLE_SHARE_FROM_FRM = 10758
ER_CANT_LOCK_TABLE = 10759
ER_CANT_ALLOC_TABLE_OBJECT = 10760
ER_CANT_CREATE_HANDLER_OBJECT_FOR_TABLE = 10761
ER_CANT_SET_HANDLER_REFERENCE_FOR_TABLE = 10762
ER_CANT_LOCK_TABLESPACE = 10763
ER_CANT_UPGRADE_GENERATED_COLUMNS_TO_DD = 10764
ER_DD_ERROR_CREATING_ENTRY = 10765
ER_DD_CANT_FETCH_TABLE_DATA = 10766
ER_DD_CANT_FIX_SE_DATA = 10767
ER_DD_CANT_CREATE_SP = 10768
ER_CANT_OPEN_DB_OPT_USING_DEFAULT_CHARSET = 10769
ER_CANT_CREATE_CACHE_FOR_DB_OPT = 10770
ER_CANT_IDENTIFY_CHARSET_USING_DEFAULT = 10771
ER_DB_OPT_NOT_FOUND_USING_DEFAULT_CHARSET = 10772
ER_EVENT_CANT_GET_TIMEZONE_FROM_FIELD = 10773
ER_EVENT_CANT_FIND_TIMEZONE = 10774
ER_EVENT_CANT_GET_CHARSET = 10775
ER_EVENT_CANT_GET_COLLATION = 10776
ER_EVENT_CANT_OPEN_TABLE_MYSQL_EVENT = 10777
ER_CANT_PARSE_STORED_ROUTINE_BODY = 10778
ER_CANT_OPEN_TABLE_MYSQL_PROC = 10779
ER_CANT_READ_TABLE_MYSQL_PROC = 10780
ER_FILE_EXISTS_DURING_UPGRADE = 10781
ER_CANT_OPEN_DATADIR_AFTER_UPGRADE_FAILURE = 10782
ER_CANT_SET_PATH_FOR = 10783
ER_CANT_OPEN_DIR = 10784
ER_NDB_EMPTY_NODEID_IN_NDB_CLUSTER_CONNECTION_POOL_NODEIDS = 10785
ER_NDB_CANT_PARSE_NDB_CLUSTER_CONNECTION_POOL_NODEIDS = 10786
ER_NDB_INVALID_NODEID_IN_NDB_CLUSTER_CONNECTION_POOL_NODEIDS = 10787
ER_NDB_DUPLICATE_NODEID_IN_NDB_CLUSTER_CONNECTION_POOL_NODEIDS = 10788
ER_NDB_POOL_SIZE_MUST_MATCH_NDB_CLUSTER_CONNECTION_POOL_NODEIDS = 10789
ER_NDB_NODEID_NOT_FIRST_IN_NDB_CLUSTER_CONNECTION_POOL_NODEIDS = 10790
ER_NDB_USING_NODEID = 10791
ER_NDB_CANT_ALLOC_GLOBAL_NDB_CLUSTER_CONNECTION = 10792
ER_NDB_CANT_ALLOC_GLOBAL_NDB_OBJECT = 10793
ER_NDB_USING_NODEID_LIST = 10794
ER_NDB_CANT_ALLOC_NDB_CLUSTER_CONNECTION = 10795
ER_NDB_STARTING_CONNECT_THREAD = 10796
ER_NDB_NODE_INFO = 10797
ER_NDB_CANT_START_CONNECT_THREAD = 10798
ER_NDB_GENERIC_ERROR = 10799
ER_NDB_CPU_MASK_TOO_SHORT = 10800
ER_EVENT_ERROR_CREATING_QUERY_TO_WRITE_TO_BINLOG = 10801
ER_EVENT_SCHEDULER_ERROR_LOADING_FROM_DB = 10802
ER_EVENT_SCHEDULER_ERROR_GETTING_EVENT_OBJECT = 10803
ER_EVENT_SCHEDULER_GOT_BAD_DATA_FROM_TABLE = 10804
ER_EVENT_CANT_GET_LOCK_FOR_DROPPING_EVENT = 10805
ER_EVENT_UNABLE_TO_DROP_EVENT = 10806
ER_BINLOG_ATTACHING_THREAD_MEMORY_FINALLY_AVAILABLE = 10807
ER_BINLOG_CANT_RESIZE_CACHE = 10808
ER_BINLOG_FILE_BEING_READ_NOT_PURGED = 10809
ER_BINLOG_IO_ERROR_READING_HEADER = 10810
ER_BINLOG_CANT_OPEN_LOG = 10811
ER_BINLOG_CANT_CREATE_CACHE_FOR_LOG = 10812
ER_BINLOG_FILE_EXTENSION_NUMBER_EXHAUSTED = 10813
ER_BINLOG_FILE_NAME_TOO_LONG = 10814
ER_BINLOG_FILE_EXTENSION_NUMBER_RUNNING_LOW = 10815
ER_BINLOG_CANT_OPEN_FOR_LOGGING = 10816
ER_BINLOG_FAILED_TO_SYNC_INDEX_FILE = 10817
ER_BINLOG_ERROR_READING_GTIDS_FROM_RELAY_LOG = 10818
ER_BINLOG_EVENTS_READ_FROM_RELAY_LOG_INFO = 10819
ER_BINLOG_ERROR_READING_GTIDS_FROM_BINARY_LOG = 10820
ER_BINLOG_EVENTS_READ_FROM_BINLOG_INFO = 10821
ER_BINLOG_CANT_GENERATE_NEW_FILE_NAME = 10822
ER_BINLOG_FAILED_TO_SYNC_INDEX_FILE_IN_OPEN = 10823
ER_BINLOG_CANT_USE_FOR_LOGGING = 10824
ER_BINLOG_FAILED_TO_CLOSE_INDEX_FILE_WHILE_REBUILDING = 10825
ER_BINLOG_FAILED_TO_DELETE_INDEX_FILE_WHILE_REBUILDING = 10826
ER_BINLOG_FAILED_TO_RENAME_INDEX_FILE_WHILE_REBUILDING = 10827
ER_BINLOG_FAILED_TO_OPEN_INDEX_FILE_AFTER_REBUILDING = 10828
ER_BINLOG_CANT_APPEND_LOG_TO_TMP_INDEX = 10829
ER_BINLOG_CANT_LOCATE_OLD_BINLOG_OR_RELAY_LOG_FILES = 10830
ER_BINLOG_CANT_DELETE_FILE = 10831
ER_BINLOG_CANT_SET_TMP_INDEX_NAME = 10832
ER_BINLOG_FAILED_TO_OPEN_TEMPORARY_INDEX_FILE = 10833
ER_BINLOG_ERROR_GETTING_NEXT_LOG_FROM_INDEX = 10834
ER_BINLOG_CANT_OPEN_TMP_INDEX = 10835
ER_BINLOG_CANT_COPY_INDEX_TO_TMP = 10836
ER_BINLOG_CANT_CLOSE_TMP_INDEX = 10837
ER_BINLOG_CANT_MOVE_TMP_TO_INDEX = 10838
ER_BINLOG_PURGE_LOGS_CALLED_WITH_FILE_NOT_IN_INDEX = 10839
ER_BINLOG_PURGE_LOGS_CANT_SYNC_INDEX_FILE = 10840
ER_BINLOG_PURGE_LOGS_CANT_COPY_TO_REGISTER_FILE = 10841
ER_BINLOG_PURGE_LOGS_CANT_FLUSH_REGISTER_FILE = 10842
ER_BINLOG_PURGE_LOGS_CANT_UPDATE_INDEX_FILE = 10843
ER_BINLOG_PURGE_LOGS_FAILED_TO_PURGE_LOG = 10844
ER_BINLOG_FAILED_TO_SET_PURGE_INDEX_FILE_NAME = 10845
ER_BINLOG_FAILED_TO_OPEN_REGISTER_FILE = 10846
ER_BINLOG_FAILED_TO_REINIT_REGISTER_FILE = 10847
ER_BINLOG_FAILED_TO_READ_REGISTER_FILE = 10848
ER_CANT_STAT_FILE = 10849
ER_BINLOG_CANT_DELETE_LOG_FILE_DOES_INDEX_MATCH_FILES = 10850
ER_BINLOG_CANT_DELETE_FILE_AND_READ_BINLOG_INDEX = 10851
ER_BINLOG_FAILED_TO_DELETE_LOG_FILE = 10852
OBSOLETE_ER_BINLOG_LOGGING_INCIDENT_TO_STOP_SLAVES = 10853
ER_BINLOG_LOGGING_INCIDENT_TO_STOP_REPLICAS = 10853
ER_BINLOG_CANT_FIND_LOG_IN_INDEX = 10854
ER_BINLOG_RECOVERING_AFTER_CRASH_USING = 10855
ER_BINLOG_CANT_OPEN_CRASHED_BINLOG = 10856
ER_BINLOG_CANT_TRIM_CRASHED_BINLOG = 10857
ER_BINLOG_CRASHED_BINLOG_TRIMMED = 10858
ER_BINLOG_CANT_CLEAR_IN_USE_FLAG_FOR_CRASHED_BINLOG = 10859
ER_BINLOG_FAILED_TO_RUN_AFTER_SYNC_HOOK = 10860
ER_TURNING_LOGGING_OFF_FOR_THE_DURATION = 10861
ER_BINLOG_FAILED_TO_RUN_AFTER_FLUSH_HOOK = 10862
ER_BINLOG_CRASH_RECOVERY_FAILED = 10863
ER_BINLOG_WARNING_SUPPRESSED = 10864
ER_NDB_LOG_ENTRY = 10865
ER_NDB_LOG_ENTRY_WITH_PREFIX = 10866
ER_NDB_BINLOG_CANT_CREATE_PURGE_THD = 10867
ER_INNODB_UNKNOWN_COLLATION = 10868
ER_INNODB_INVALID_LOG_GROUP_HOME_DIR = 10869
ER_INNODB_INVALID_INNODB_UNDO_DIRECTORY = 10870
ER_INNODB_ILLEGAL_COLON_IN_POOL = 10871
ER_INNODB_INVALID_PAGE_SIZE = 10872
ER_INNODB_DIRTY_WATER_MARK_NOT_LOW = 10873
ER_INNODB_IO_CAPACITY_EXCEEDS_MAX = 10874
ER_INNODB_FILES_SAME = 10875
ER_INNODB_UNREGISTERED_TRX_ACTIVE = 10876
ER_INNODB_CLOSING_CONNECTION_ROLLS_BACK = 10877
ER_INNODB_TRX_XLATION_TABLE_OOM = 10878
ER_INNODB_CANT_FIND_INDEX_IN_INNODB_DD = 10879
ER_INNODB_INDEX_COLUMN_INFO_UNLIKE_MYSQLS = 10880
ER_INNODB_CANT_OPEN_TABLE = 10881
ER_INNODB_CANT_BUILD_INDEX_XLATION_TABLE_FOR = 10882
ER_INNODB_PK_NOT_IN_MYSQL = 10883
ER_INNODB_PK_ONLY_IN_MYSQL = 10884
ER_INNODB_CLUSTERED_INDEX_PRIVATE = 10885
ER_INNODB_PARTITION_TABLE_LOWERCASED = 10886
ER_ERRMSG_REPLACEMENT_DODGY = 10887
ER_ERRMSG_REPLACEMENTS_FAILED = 10888
ER_NPIPE_CANT_CREATE = 10889
ER_PARTITION_MOVE_CREATED_DUPLICATE_ROW_PLEASE_FIX = 10890
ER_AUDIT_CANT_ABORT_COMMAND = 10891
ER_AUDIT_CANT_ABORT_EVENT = 10892
ER_AUDIT_WARNING = 10893
ER_NDB_NUMBER_OF_CHANNELS = 10894
OBSOLETE_ER_NDB_SLAVE_PARALLEL_WORKERS = 10895
ER_NDB_REPLICA_PARALLEL_WORKERS = 10895
ER_NDB_DISTRIBUTING_ERR = 10896
OBSOLETE_ER_RPL_SLAVE_INSECURE_CHANGE_MASTER = 10897
OBSOLETE_ER_RPL_SLAVE_FLUSH_RELAY_LOGS_NOT_ALLOWED = 10898
OBSOLETE_ER_RPL_SLAVE_INCORRECT_CHANNEL = 10899
ER_RPL_REPLICA_INSECURE_CHANGE_SOURCE = 10897
ER_RPL_REPLICA_FLUSH_RELAY_LOGS_NOT_ALLOWED = 10898
ER_RPL_REPLICA_INCORRECT_CHANNEL = 10899
ER_FAILED_TO_FIND_DL_ENTRY = 10900
ER_FAILED_TO_OPEN_SHARED_LIBRARY = 10901
ER_THREAD_PRIORITY_IGNORED = 10902
ER_BINLOG_CACHE_SIZE_TOO_LARGE = 10903
ER_BINLOG_STMT_CACHE_SIZE_TOO_LARGE = 10904
ER_FAILED_TO_GENERATE_UNIQUE_LOGFILE = 10905
ER_FAILED_TO_READ_FILE = 10906
ER_FAILED_TO_WRITE_TO_FILE = 10907
ER_BINLOG_UNSAFE_MESSAGE_AND_STATEMENT = 10908
ER_FORCE_CLOSE_THREAD = 10909
ER_SERVER_SHUTDOWN_COMPLETE = 10910
ER_RPL_CANT_HAVE_SAME_BASENAME = 10911
ER_RPL_GTID_MODE_REQUIRES_ENFORCE_GTID_CONSISTENCY_ON = 10912
ER_WARN_NO_SERVERID_SPECIFIED = 10913
ER_ABORTING_USER_CONNECTION = 10914
ER_SQL_MODE_MERGED_WITH_STRICT_MODE = 10915
ER_GTID_PURGED_WAS_UPDATED = 10916
ER_GTID_EXECUTED_WAS_UPDATED = 10917
ER_DEPRECATE_MSG_WITH_REPLACEMENT = 10918
ER_TRG_CREATION_CTX_NOT_SET = 10919
ER_FILE_HAS_OLD_FORMAT = 10920
ER_VIEW_CREATION_CTX_NOT_SET = 10921
ER_TABLE_NAME_CAUSES_TOO_LONG_PATH = 10922
ER_TABLE_UPGRADE_REQUIRED = 10923
ER_GET_ERRNO_FROM_STORAGE_ENGINE = 10924
ER_ACCESS_DENIED_ERROR_WITHOUT_PASSWORD = 10925
ER_ACCESS_DENIED_ERROR_WITH_PASSWORD = 10926
ER_ACCESS_DENIED_FOR_USER_ACCOUNT_LOCKED = 10927
ER_MUST_CHANGE_EXPIRED_PASSWORD = 10928
ER_SYSTEM_TABLES_NOT_SUPPORTED_BY_STORAGE_ENGINE = 10929
ER_FILESORT_TERMINATED = 10930
ER_SERVER_STARTUP_MSG = 10931
ER_FAILED_TO_FIND_LOCALE_NAME = 10932
ER_FAILED_TO_FIND_COLLATION_NAME = 10933
ER_SERVER_OUT_OF_RESOURCES = 10934
ER_SERVER_OUTOFMEMORY = 10935
ER_INVALID_COLLATION_FOR_CHARSET = 10936
ER_CANT_START_ERROR_LOG_SERVICE = 10937
ER_CREATING_NEW_UUID_FIRST_START = 10938
ER_FAILED_TO_GET_ABSOLUTE_PATH = 10939
ER_PERFSCHEMA_COMPONENTS_INFRASTRUCTURE_BOOTSTRAP = 10940
ER_PERFSCHEMA_COMPONENTS_INFRASTRUCTURE_SHUTDOWN = 10941
ER_DUP_FD_OPEN_FAILED = 10942
ER_SYSTEM_VIEW_INIT_FAILED = 10943
ER_RESOURCE_GROUP_POST_INIT_FAILED = 10944
ER_RESOURCE_GROUP_SUBSYSTEM_INIT_FAILED = 10945
ER_FAILED_START_MYSQLD_DAEMON = 10946
ER_CANNOT_CHANGE_TO_ROOT_DIR = 10947
ER_PERSISTENT_PRIVILEGES_BOOTSTRAP = 10948
ER_BASEDIR_SET_TO = 10949
ER_RPL_FILTER_ADD_WILD_DO_TABLE_FAILED = 10950
ER_RPL_FILTER_ADD_WILD_IGNORE_TABLE_FAILED = 10951
ER_PRIVILEGE_SYSTEM_INIT_FAILED = 10952
ER_CANNOT_SET_LOG_ERROR_SERVICES = 10953
ER_PERFSCHEMA_TABLES_INIT_FAILED = 10954
ER_TX_EXTRACTION_ALGORITHM_FOR_BINLOG_TX_DEPEDENCY_TRACKING = 10955
ER_INVALID_REPLICATION_TIMESTAMPS = 10956
ER_RPL_TIMESTAMPS_RETURNED_TO_NORMAL = 10957
ER_BINLOG_FILE_OPEN_FAILED = 10958
ER_BINLOG_EVENT_WRITE_TO_STMT_CACHE_FAILED = 10959
OBSOLETE_ER_SLAVE_RELAY_LOG_TRUNCATE_INFO = 10960
OBSOLETE_ER_SLAVE_RELAY_LOG_PURGE_FAILED = 10961
OBSOLETE_ER_RPL_SLAVE_FILTER_CREATE_FAILED = 10962
OBSOLETE_ER_RPL_SLAVE_GLOBAL_FILTERS_COPY_FAILED = 10963
OBSOLETE_ER_RPL_SLAVE_RESET_FILTER_OPTIONS = 10964
ER_REPLICA_RELAY_LOG_TRUNCATE_INFO = 10960
ER_REPLICA_RELAY_LOG_PURGE_FAILED = 10961
ER_RPL_REPLICA_FILTER_CREATE_FAILED = 10962
ER_RPL_REPLICA_GLOBAL_FILTERS_COPY_FAILED = 10963
ER_RPL_REPLICA_RESET_FILTER_OPTIONS = 10964
ER_MISSING_GRANT_SYSTEM_TABLE = 10965
ER_MISSING_ACL_SYSTEM_TABLE = 10966
ER_ANONYMOUS_AUTH_ID_NOT_ALLOWED_IN_MANDATORY_ROLES = 10967
ER_UNKNOWN_AUTH_ID_IN_MANDATORY_ROLE = 10968
ER_WRITE_ROW_TO_PARTITION_FAILED = 10969
ER_RESOURCE_GROUP_METADATA_UPDATE_SKIPPED = 10970
ER_FAILED_TO_PERSIST_RESOURCE_GROUP_METADATA = 10971
ER_FAILED_TO_DESERIALIZE_RESOURCE_GROUP = 10972
ER_FAILED_TO_UPDATE_RESOURCE_GROUP = 10973
ER_RESOURCE_GROUP_VALIDATION_FAILED = 10974
ER_FAILED_TO_ALLOCATE_MEMORY_FOR_RESOURCE_GROUP = 10975
ER_FAILED_TO_ALLOCATE_MEMORY_FOR_RESOURCE_GROUP_HASH = 10976
ER_FAILED_TO_ADD_RESOURCE_GROUP_TO_MAP = 10977
ER_RESOURCE_GROUP_IS_DISABLED = 10978
ER_FAILED_TO_APPLY_RESOURCE_GROUP_CONTROLLER = 10979
ER_FAILED_TO_ACQUIRE_LOCK_ON_RESOURCE_GROUP = 10980
ER_PFS_NOTIFICATION_FUNCTION_REGISTER_FAILED = 10981
ER_RES_GRP_SET_THR_AFFINITY_FAILED = 10982
ER_RES_GRP_SET_THR_AFFINITY_TO_CPUS_FAILED = 10983
ER_RES_GRP_THD_UNBIND_FROM_CPU_FAILED = 10984
ER_RES_GRP_SET_THREAD_PRIORITY_FAILED = 10985
ER_RES_GRP_FAILED_TO_DETERMINE_NICE_CAPABILITY = 10986
ER_RES_GRP_FAILED_TO_GET_THREAD_HANDLE = 10987
ER_RES_GRP_GET_THREAD_PRIO_NOT_SUPPORTED = 10988
ER_RES_GRP_FAILED_DETERMINE_CPU_COUNT = 10989
ER_RES_GRP_FEATURE_NOT_AVAILABLE = 10990
ER_RES_GRP_INVALID_THREAD_PRIORITY = 10991
ER_RES_GRP_SOLARIS_PROCESSOR_BIND_TO_CPUID_FAILED = 10992
ER_RES_GRP_SOLARIS_PROCESSOR_BIND_TO_THREAD_FAILED = 10993
ER_RES_GRP_SOLARIS_PROCESSOR_AFFINITY_FAILED = 10994
ER_DD_UPGRADE_RENAME_IDX_STATS_FILE_FAILED = 10995
ER_DD_UPGRADE_DD_OPEN_FAILED = 10996
ER_DD_UPGRADE_FAILED_TO_FETCH_TABLESPACES = 10997
ER_DD_UPGRADE_FAILED_TO_ACQUIRE_TABLESPACE = 10998
ER_DD_UPGRADE_FAILED_TO_RESOLVE_TABLESPACE_ENGINE = 10999
ER_FAILED_TO_CREATE_SDI_FOR_TABLESPACE = 11000
ER_FAILED_TO_STORE_SDI_FOR_TABLESPACE = 11001
ER_DD_UPGRADE_FAILED_TO_FETCH_TABLES = 11002
ER_DD_UPGRADE_DD_POPULATED = 11003
ER_DD_UPGRADE_INFO_FILE_OPEN_FAILED = 11004
ER_DD_UPGRADE_INFO_FILE_CLOSE_FAILED = 11005
ER_DD_UPGRADE_TABLESPACE_MIGRATION_FAILED = 11006
ER_DD_UPGRADE_FAILED_TO_CREATE_TABLE_STATS = 11007
ER_DD_UPGRADE_TABLE_STATS_MIGRATE_COMPLETED = 11008
ER_DD_UPGRADE_FAILED_TO_CREATE_INDEX_STATS = 11009
ER_DD_UPGRADE_INDEX_STATS_MIGRATE_COMPLETED = 11010
ER_DD_UPGRADE_FAILED_FIND_VALID_DATA_DIR = 11011
ER_DD_UPGRADE_START = 11012
ER_DD_UPGRADE_FAILED_INIT_DD_SE = 11013
ER_DD_UPGRADE_FOUND_PARTIALLY_UPGRADED_DD_ABORT = 11014
ER_DD_UPGRADE_FOUND_PARTIALLY_UPGRADED_DD_CONTINUE = 11015
ER_DD_UPGRADE_SE_LOGS_FAILED = 11016
ER_DD_UPGRADE_SDI_INFO_UPDATE_FAILED = 11017
ER_SKIP_UPDATING_METADATA_IN_SE_RO_MODE = 11018
ER_CREATED_SYSTEM_WITH_VERSION = 11019
ER_UNKNOWN_ERROR_DETECTED_IN_SE = 11020
ER_READ_LOG_EVENT_FAILED = 11021
ER_ROW_DATA_TOO_BIG_TO_WRITE_IN_BINLOG = 11022
ER_FAILED_TO_CONSTRUCT_DROP_EVENT_QUERY = 11023
ER_FAILED_TO_BINLOG_DROP_EVENT = 11024
OBSOLETE_ER_FAILED_TO_START_SLAVE_THREAD = 11025
ER_FAILED_TO_START_REPLICA_THREAD = 11025
ER_RPL_IO_THREAD_KILLED = 11026
OBSOLETE_ER_SLAVE_RECONNECT_FAILED = 11027
OBSOLETE_ER_SLAVE_KILLED_AFTER_RECONNECT = 11028
OBSOLETE_ER_SLAVE_NOT_STARTED_ON_SOME_CHANNELS = 11029
ER_REPLICA_RECONNECT_FAILED = 11027
ER_REPLICA_KILLED_AFTER_RECONNECT = 11028
ER_REPLICA_NOT_STARTED_ON_SOME_CHANNELS = 11029
ER_FAILED_TO_ADD_RPL_FILTER = 11030
ER_PER_CHANNEL_RPL_FILTER_CONF_FOR_GRP_RPL = 11031
ER_RPL_FILTERS_NOT_ATTACHED_TO_CHANNEL = 11032
ER_FAILED_TO_BUILD_DO_AND_IGNORE_TABLE_HASHES = 11033
ER_CLONE_PLUGIN_NOT_LOADED = 11034
ER_CLONE_HANDLER_EXISTS = 11035
ER_FAILED_TO_CREATE_CLONE_HANDLER = 11036
ER_CYCLE_TIMER_IS_NOT_AVAILABLE = 11037
ER_NANOSECOND_TIMER_IS_NOT_AVAILABLE = 11038
ER_MICROSECOND_TIMER_IS_NOT_AVAILABLE = 11039
ER_PFS_MALLOC_ARRAY_OVERFLOW = 11040
ER_PFS_MALLOC_ARRAY_OOM = 11041
OBSOLETE_ER_SEMISYNC_RPL_ENABLED_ON_MASTER = 11142
OBSOLETE_ER_SEMISYNC_MASTER_OOM = 11143
OBSOLETE_ER_SEMISYNC_DISABLED_ON_MASTER = 11144
ER_INNODB_FAILED_TO_FIND_IDX_WITH_KEY_NO = 11042
ER_INNODB_FAILED_TO_FIND_IDX = 11043
ER_INNODB_FAILED_TO_FIND_IDX_FROM_DICT_CACHE = 11044
ER_INNODB_ACTIVE_INDEX_CHANGE_FAILED = 11045
OBSOLETE_ER_SEMISYNC_MASTER_GOT_REPLY_AT_POS = 11146
OBSOLETE_ER_SEMISYNC_MASTER_SIGNAL_ALL_WAITING_THREADS = 11147
OBSOLETE_ER_SEMISYNC_MASTER_TRX_WAIT_POS = 11148
ER_INNODB_DIFF_IN_REF_LEN = 11046
ER_WRONG_TYPE_FOR_COLUMN_PREFIX_IDX_FLD = 11047
ER_INNODB_CANNOT_CREATE_TABLE = 11048
ER_INNODB_INTERNAL_INDEX = 11049
ER_INNODB_IDX_CNT_MORE_THAN_DEFINED_IN_MYSQL = 11050
ER_INNODB_IDX_CNT_FEWER_THAN_DEFINED_IN_MYSQL = 11051
ER_INNODB_IDX_COLUMN_CNT_DIFF = 11052
ER_INNODB_USE_MONITOR_GROUP_NAME = 11053
ER_INNODB_MONITOR_DEFAULT_VALUE_NOT_DEFINED = 11054
ER_INNODB_MONITOR_IS_ENABLED = 11055
ER_INNODB_INVALID_MONITOR_COUNTER_NAME = 11056
ER_WIN_LOAD_LIBRARY_FAILED = 11057
ER_PARTITION_HANDLER_ADMIN_MSG = 11058
ER_RPL_RLI_INIT_INFO_MSG = 11059
ER_DD_UPGRADE_TABLE_INTACT_ERROR = 11060
ER_SERVER_INIT_COMPILED_IN_COMMANDS = 11061
ER_MYISAM_CHECK_METHOD_ERROR = 11062
ER_MYISAM_CRASHED_ERROR = 11063
ER_WAITPID_FAILED = 11064
ER_FAILED_TO_FIND_MYSQLD_STATUS = 11065
ER_INNODB_ERROR_LOGGER_MSG = 11066
ER_INNODB_ERROR_LOGGER_FATAL_MSG = 11067
ER_DEPRECATED_SYNTAX_WITH_REPLACEMENT = 11068
ER_DEPRECATED_SYNTAX_NO_REPLACEMENT = 11069
ER_DEPRECATE_MSG_NO_REPLACEMENT = 11070
ER_LOG_PRINTF_MSG = 11071
ER_BINLOG_LOGGING_NOT_POSSIBLE = 11072
ER_FAILED_TO_SET_PERSISTED_OPTIONS = 11073
ER_COMPONENTS_FAILED_TO_ACQUIRE_SERVICE_IMPLEMENTATION = 11074
ER_RES_GRP_INVALID_VCPU_RANGE = 11075
ER_RES_GRP_INVALID_VCPU_ID = 11076
ER_ERROR_DURING_FLUSH_LOG_COMMIT_PHASE = 11077
ER_DROP_DATABASE_FAILED_RMDIR_MANUALLY = 11078
ER_EXPIRE_LOGS_DAYS_IGNORED = 11079
ER_BINLOG_MALFORMED_OR_OLD_RELAY_LOG = 11080
ER_DD_UPGRADE_VIEW_COLUMN_NAME_TOO_LONG = 11081
ER_TABLE_NEEDS_DUMP_UPGRADE = 11082
ER_DD_UPGRADE_FAILED_TO_UPDATE_VER_NO_IN_TABLESPACE = 11083
ER_KEYRING_MIGRATION_FAILED = 11084
ER_KEYRING_MIGRATION_SUCCESSFUL = 11085
ER_RESTART_RECEIVED_INFO = 11086
ER_LCTN_CHANGED = 11087
ER_DD_INITIALIZE = 11088
ER_DD_RESTART = 11089
ER_DD_UPGRADE = 11090
ER_DD_UPGRADE_OFF = 11091
ER_DD_UPGRADE_VERSION_NOT_SUPPORTED = 11092
ER_DD_UPGRADE_SCHEMA_UNAVAILABLE = 11093
ER_DD_MINOR_DOWNGRADE = 11094
ER_DD_MINOR_DOWNGRADE_VERSION_NOT_SUPPORTED = 11095
ER_DD_NO_VERSION_FOUND = 11096
ER_THREAD_POOL_NOT_SUPPORTED_ON_PLATFORM = 11097
ER_THREAD_POOL_SIZE_TOO_LOW = 11098
ER_THREAD_POOL_SIZE_TOO_HIGH = 11099
ER_THREAD_POOL_ALGORITHM_INVALID = 11100
ER_THREAD_POOL_INVALID_STALL_LIMIT = 11101
ER_THREAD_POOL_INVALID_PRIO_KICKUP_TIMER = 11102
ER_THREAD_POOL_MAX_UNUSED_THREADS_INVALID = 11103
ER_THREAD_POOL_CON_HANDLER_INIT_FAILED = 11104
ER_THREAD_POOL_INIT_FAILED = 11105
ER_THREAD_POOL_PLUGIN_STARTED = 11106
ER_THREAD_POOL_CANNOT_SET_THREAD_SPECIFIC_DATA = 11107
ER_THREAD_POOL_FAILED_TO_CREATE_CONNECT_HANDLER_THD = 11108
ER_THREAD_POOL_FAILED_TO_CREATE_THD_AND_AUTH_CONN = 11109
ER_THREAD_POOL_FAILED_PROCESS_CONNECT_EVENT = 11110
ER_THREAD_POOL_FAILED_TO_CREATE_POOL = 11111
ER_THREAD_POOL_RATE_LIMITED_ERROR_MSGS = 11112
ER_TRHEAD_POOL_LOW_LEVEL_INIT_FAILED = 11113
ER_THREAD_POOL_LOW_LEVEL_REARM_FAILED = 11114
ER_THREAD_POOL_BUFFER_TOO_SMALL = 11115
ER_MECAB_NOT_SUPPORTED = 11116
ER_MECAB_NOT_VERIFIED = 11117
ER_MECAB_CREATING_MODEL = 11118
ER_MECAB_FAILED_TO_CREATE_MODEL = 11119
ER_MECAB_FAILED_TO_CREATE_TRIGGER = 11120
ER_MECAB_UNSUPPORTED_CHARSET = 11121
ER_MECAB_CHARSET_LOADED = 11122
ER_MECAB_PARSE_FAILED = 11123
ER_MECAB_OOM_WHILE_PARSING_TEXT = 11124
ER_MECAB_CREATE_LATTICE_FAILED = 11125
ER_SEMISYNC_TRACE_ENTER_FUNC = 11126
ER_SEMISYNC_TRACE_EXIT_WITH_INT_EXIT_CODE = 11127
ER_SEMISYNC_TRACE_EXIT_WITH_BOOL_EXIT_CODE = 11128
ER_SEMISYNC_TRACE_EXIT = 11129
ER_SEMISYNC_RPL_INIT_FOR_TRX = 11130
ER_SEMISYNC_FAILED_TO_ALLOCATE_TRX_NODE = 11131
ER_SEMISYNC_BINLOG_WRITE_OUT_OF_ORDER = 11132
ER_SEMISYNC_INSERT_LOG_INFO_IN_ENTRY = 11133
ER_SEMISYNC_PROBE_LOG_INFO_IN_ENTRY = 11134
ER_SEMISYNC_CLEARED_ALL_ACTIVE_TRANSACTION_NODES = 11135
ER_SEMISYNC_CLEARED_ACTIVE_TRANSACTION_TILL_POS = 11136
ER_SEMISYNC_REPLY_MAGIC_NO_ERROR = 11137
ER_SEMISYNC_REPLY_PKT_LENGTH_TOO_SMALL = 11138
ER_SEMISYNC_REPLY_BINLOG_FILE_TOO_LARGE = 11139
ER_SEMISYNC_SERVER_REPLY = 11140
ER_SEMISYNC_FUNCTION_CALLED_TWICE = 11141
ER_SEMISYNC_RPL_ENABLED_ON_SOURCE = 11142
ER_SEMISYNC_SOURCE_OOM = 11143
ER_SEMISYNC_DISABLED_ON_SOURCE = 11144
ER_SEMISYNC_FORCED_SHUTDOWN = 11145
ER_SEMISYNC_SOURCE_GOT_REPLY_AT_POS = 11146
ER_SEMISYNC_SOURCE_SIGNAL_ALL_WAITING_THREADS = 11147
ER_SEMISYNC_SOURCE_TRX_WAIT_POS = 11148
ER_SEMISYNC_BINLOG_REPLY_IS_AHEAD = 11149
ER_SEMISYNC_MOVE_BACK_WAIT_POS = 11150
ER_SEMISYNC_INIT_WAIT_POS = 11151
ER_SEMISYNC_WAIT_TIME_FOR_BINLOG_SENT = 11152
ER_SEMISYNC_WAIT_FOR_BINLOG_TIMEDOUT = 11153
ER_SEMISYNC_WAIT_TIME_ASSESSMENT_FOR_COMMIT_TRX_FAILED = 11154
ER_SEMISYNC_RPL_SWITCHED_OFF = 11155
ER_SEMISYNC_RPL_SWITCHED_ON = 11156
ER_SEMISYNC_NO_SPACE_IN_THE_PKT = 11157
ER_SEMISYNC_SYNC_HEADER_UPDATE_INFO = 11158
ER_SEMISYNC_FAILED_TO_INSERT_TRX_NODE = 11159
ER_SEMISYNC_TRX_SKIPPED_AT_POS = 11160
OBSOLETE_ER_SEMISYNC_MASTER_FAILED_ON_NET_FLUSH = 11161
ER_SEMISYNC_SOURCE_FAILED_ON_NET_FLUSH = 11161
ER_SEMISYNC_RECEIVED_ACK_IS_SMALLER = 11162
ER_SEMISYNC_ADD_ACK_TO_SLOT = 11163
OBSOLETE_ER_SEMISYNC_UPDATE_EXISTING_SLAVE_ACK = 11164
ER_SEMISYNC_UPDATE_EXISTING_REPLICA_ACK = 11164
ER_SEMISYNC_FAILED_TO_START_ACK_RECEIVER_THD = 11165
ER_SEMISYNC_STARTING_ACK_RECEIVER_THD = 11166
ER_SEMISYNC_FAILED_TO_WAIT_ON_DUMP_SOCKET = 11167
ER_SEMISYNC_STOPPING_ACK_RECEIVER_THREAD = 11168
OBSOLETE_ER_SEMISYNC_FAILED_REGISTER_SLAVE_TO_RECEIVER = 11169
OBSOLETE_ER_SEMISYNC_START_BINLOG_DUMP_TO_SLAVE = 11170
OBSOLETE_ER_SEMISYNC_STOP_BINLOG_DUMP_TO_SLAVE = 11171
ER_SEMISYNC_FAILED_REGISTER_REPLICA_TO_RECEIVER = 11169
ER_SEMISYNC_START_BINLOG_DUMP_TO_REPLICA = 11170
ER_SEMISYNC_STOP_BINLOG_DUMP_TO_REPLICA = 11171
ER_SEMISYNC_UNREGISTER_TRX_OBSERVER_FAILED = 11172
ER_SEMISYNC_UNREGISTER_BINLOG_STORAGE_OBSERVER_FAILED = 11173
ER_SEMISYNC_UNREGISTER_BINLOG_TRANSMIT_OBSERVER_FAILED = 11174
ER_SEMISYNC_UNREGISTERED_REPLICATOR = 11175
ER_SEMISYNC_SOCKET_FD_TOO_LARGE = 11176
OBSOLETE_ER_SEMISYNC_SLAVE_REPLY = 11177
ER_SEMISYNC_REPLICA_REPLY = 11177
ER_SEMISYNC_MISSING_MAGIC_NO_FOR_SEMISYNC_PKT = 11178
OBSOLETE_ER_SEMISYNC_SLAVE_START = 11179
OBSOLETE_ER_SEMISYNC_SLAVE_REPLY_WITH_BINLOG_INFO = 11180
OBSOLETE_ER_SEMISYNC_SLAVE_NET_FLUSH_REPLY_FAILED = 11181
OBSOLETE_ER_SEMISYNC_SLAVE_SEND_REPLY_FAILED = 11182
OBSOLETE_ER_SEMISYNC_EXECUTION_FAILED_ON_MASTER = 11183
OBSOLETE_ER_SEMISYNC_NOT_SUPPORTED_BY_MASTER = 11184
OBSOLETE_ER_SEMISYNC_SLAVE_SET_FAILED = 11185
ER_SEMISYNC_REPLICA_START = 11179
ER_SEMISYNC_REPLICA_REPLY_WITH_BINLOG_INFO = 11180
ER_SEMISYNC_REPLICA_NET_FLUSH_REPLY_FAILED = 11181
ER_SEMISYNC_REPLICA_SEND_REPLY_FAILED = 11182
ER_SEMISYNC_EXECUTION_FAILED_ON_SOURCE = 11183
ER_SEMISYNC_NOT_SUPPORTED_BY_SOURCE = 11184
ER_SEMISYNC_REPLICA_SET_FAILED = 11185
ER_SEMISYNC_FAILED_TO_STOP_ACK_RECEIVER_THD = 11186
ER_FIREWALL_FAILED_TO_READ_FIREWALL_TABLES = 11187
ER_FIREWALL_FAILED_TO_REG_DYNAMIC_PRIVILEGES = 11188
ER_FIREWALL_RECORDING_STMT_WAS_TRUNCATED = 11189
ER_FIREWALL_RECORDING_STMT_WITHOUT_TEXT = 11190
ER_FIREWALL_SUSPICIOUS_STMT = 11191
ER_FIREWALL_ACCESS_DENIED = 11192
ER_FIREWALL_SKIPPED_UNKNOWN_USER_MODE = 11193
ER_FIREWALL_RELOADING_CACHE = 11194
ER_FIREWALL_RESET_FOR_USER = 11195
ER_FIREWALL_STATUS_FLUSHED = 11196
ER_KEYRING_LOGGER_ERROR_MSG = 11197
ER_AUDIT_LOG_FILTER_IS_NOT_INSTALLED = 11198
ER_AUDIT_LOG_SWITCHING_TO_INCLUDE_LIST = 11199
ER_AUDIT_LOG_CANNOT_SET_LOG_POLICY_WITH_OTHER_POLICIES = 11200
ER_AUDIT_LOG_ONLY_INCLUDE_LIST_USED = 11201
ER_AUDIT_LOG_INDEX_MAP_CANNOT_ACCESS_DIR = 11202
ER_AUDIT_LOG_WRITER_RENAME_FILE_FAILED = 11203
ER_AUDIT_LOG_WRITER_DEST_FILE_ALREADY_EXISTS = 11204
ER_AUDIT_LOG_WRITER_RENAME_FILE_FAILED_REMOVE_FILE_MANUALLY = 11205
ER_AUDIT_LOG_WRITER_INCOMPLETE_FILE_RENAMED = 11206
ER_AUDIT_LOG_WRITER_FAILED_TO_WRITE_TO_FILE = 11207
ER_AUDIT_LOG_EC_WRITER_FAILED_TO_INIT_ENCRYPTION = 11208
ER_AUDIT_LOG_EC_WRITER_FAILED_TO_INIT_COMPRESSION = 11209
ER_AUDIT_LOG_EC_WRITER_FAILED_TO_CREATE_FILE = 11210
ER_AUDIT_LOG_RENAME_LOG_FILE_BEFORE_FLUSH = 11211
ER_AUDIT_LOG_FILTER_RESULT_MSG = 11212
ER_AUDIT_LOG_JSON_READER_FAILED_TO_PARSE = 11213
ER_AUDIT_LOG_JSON_READER_BUF_TOO_SMALL = 11214
ER_AUDIT_LOG_JSON_READER_FAILED_TO_OPEN_FILE = 11215
ER_AUDIT_LOG_JSON_READER_FILE_PARSING_ERROR = 11216
ER_AUDIT_LOG_FILTER_INVALID_COLUMN_COUNT = 11217
ER_AUDIT_LOG_FILTER_INVALID_COLUMN_DEFINITION = 11218
ER_AUDIT_LOG_FILTER_FAILED_TO_STORE_TABLE_FLDS = 11219
ER_AUDIT_LOG_FILTER_FAILED_TO_UPDATE_TABLE = 11220
ER_AUDIT_LOG_FILTER_FAILED_TO_INSERT_INTO_TABLE = 11221
ER_AUDIT_LOG_FILTER_FAILED_TO_DELETE_FROM_TABLE = 11222
ER_AUDIT_LOG_FILTER_FAILED_TO_INIT_TABLE_FOR_READ = 11223
ER_AUDIT_LOG_FILTER_FAILED_TO_READ_TABLE = 11224
ER_AUDIT_LOG_FILTER_FAILED_TO_CLOSE_TABLE_AFTER_READING = 11225
ER_AUDIT_LOG_FILTER_USER_AND_HOST_CANNOT_BE_EMPTY = 11226
ER_AUDIT_LOG_FILTER_FLD_FILTERNAME_CANNOT_BE_EMPTY = 11227
ER_VALIDATE_PWD_DICT_FILE_NOT_SPECIFIED = 11228
ER_VALIDATE_PWD_DICT_FILE_NOT_LOADED = 11229
ER_VALIDATE_PWD_DICT_FILE_TOO_BIG = 11230
ER_VALIDATE_PWD_FAILED_TO_READ_DICT_FILE = 11231
ER_VALIDATE_PWD_FAILED_TO_GET_FLD_FROM_SECURITY_CTX = 11232
ER_VALIDATE_PWD_FAILED_TO_GET_SECURITY_CTX = 11233
ER_VALIDATE_PWD_LENGTH_CHANGED = 11234
ER_REWRITER_QUERY_ERROR_MSG = 11235
ER_REWRITER_QUERY_FAILED = 11236
ER_XPLUGIN_STARTUP_FAILED = 11237
ER_XPLUGIN_SERVER_EXITING = 11238
ER_XPLUGIN_SERVER_EXITED = 11239
ER_XPLUGIN_USING_SSL_CONF_FROM_SERVER = 11240
ER_XPLUGIN_USING_SSL_CONF_FROM_MYSQLX = 11241
ER_XPLUGIN_FAILED_TO_USE_SSL_CONF = 11242
ER_XPLUGIN_USING_SSL_FOR_TLS_CONNECTION = 11243
ER_XPLUGIN_REFERENCE_TO_SECURE_CONN_WITH_XPLUGIN = 11244
ER_XPLUGIN_ERROR_MSG = 11245
ER_SHA_PWD_FAILED_TO_PARSE_AUTH_STRING = 11246
ER_SHA_PWD_FAILED_TO_GENERATE_MULTI_ROUND_HASH = 11247
ER_SHA_PWD_AUTH_REQUIRES_RSA_OR_SSL = 11248
ER_SHA_PWD_RSA_KEY_TOO_LONG = 11249
ER_PLUGIN_COMMON_FAILED_TO_OPEN_FILTER_TABLES = 11250
ER_PLUGIN_COMMON_FAILED_TO_OPEN_TABLE = 11251
ER_AUTH_LDAP_ERROR_LOGGER_ERROR_MSG = 11252
ER_CONN_CONTROL_ERROR_MSG = 11253
ER_GRP_RPL_ERROR_MSG = 11254
ER_SHA_PWD_SALT_FOR_USER_CORRUPT = 11255
ER_SYS_VAR_COMPONENT_OOM = 11256
ER_SYS_VAR_COMPONENT_VARIABLE_SET_READ_ONLY = 11257
ER_SYS_VAR_COMPONENT_UNKNOWN_VARIABLE_TYPE = 11258
ER_SYS_VAR_COMPONENT_FAILED_TO_PARSE_VARIABLE_OPTIONS = 11259
ER_SYS_VAR_COMPONENT_FAILED_TO_MAKE_VARIABLE_PERSISTENT = 11260
ER_COMPONENT_FILTER_CONFUSED = 11261
OBSOLETE_ER_STOP_SLAVE_IO_THREAD_DISK_SPACE = 11262
ER_STOP_REPLICA_IO_THREAD_DISK_SPACE = 11262
ER_LOG_FILE_CANNOT_OPEN = 11263
OBSOLETE_ER_UNABLE_TO_COLLECT_INSTANCE_LOG_STATUS = 11264
OBSOLETE_ER_DEPRECATED_UTF8_ALIAS = 11265
OBSOLETE_ER_DEPRECATED_NATIONAL = 11266
OBSOLETE_ER_SLAVE_POSSIBLY_DIVERGED_AFTER_DDL = 11267
OBSOLETE_ER_REPLICA_POSSIBLY_DIVERGED_AFTER_DDL = 11267
ER_PERSIST_OPTION_STATUS = 11268
ER_NOT_IMPLEMENTED_GET_TABLESPACE_STATISTICS = 11269
OBSOLETE_ER_UNABLE_TO_SET_OPTION = 11270
OBSOLETE_ER_RESERVED_TABLESPACE_NAME = 11271
ER_SSL_FIPS_MODE_ERROR = 11272
ER_CONN_INIT_CONNECT_IGNORED = 11273
ER_UNSUPPORTED_SQL_MODE = 11274
ER_REWRITER_OOM = 11275
ER_REWRITER_TABLE_MALFORMED_ERROR = 11276
ER_REWRITER_LOAD_FAILED = 11277
ER_REWRITER_READ_FAILED = 11278
ER_CONN_CONTROL_EVENT_COORDINATOR_INIT_FAILED = 11279
ER_CONN_CONTROL_STAT_CONN_DELAY_TRIGGERED_UPDATE_FAILED = 11280
ER_CONN_CONTROL_STAT_CONN_DELAY_TRIGGERED_RESET_FAILED = 11281
ER_CONN_CONTROL_INVALID_CONN_DELAY_TYPE = 11282
ER_CONN_CONTROL_DELAY_ACTION_INIT_FAILED = 11283
ER_CONN_CONTROL_FAILED_TO_SET_CONN_DELAY = 11284
ER_CONN_CONTROL_FAILED_TO_UPDATE_CONN_DELAY_HASH = 11285
ER_XPLUGIN_FORCE_STOP_CLIENT = 11286
ER_XPLUGIN_MAX_AUTH_ATTEMPTS_REACHED = 11287
ER_XPLUGIN_BUFFER_PAGE_ALLOC_FAILED = 11288
ER_XPLUGIN_DETECTED_HANGING_CLIENTS = 11289
ER_XPLUGIN_FAILED_TO_ACCEPT_CLIENT = 11290
ER_XPLUGIN_FAILED_TO_SCHEDULE_CLIENT = 11291
ER_XPLUGIN_FAILED_TO_PREPARE_IO_INTERFACES = 11292
ER_XPLUGIN_SRV_SESSION_INIT_THREAD_FAILED = 11293
ER_XPLUGIN_UNABLE_TO_USE_USER_SESSION_ACCOUNT = 11294
ER_XPLUGIN_REFERENCE_TO_USER_ACCOUNT_DOC_SECTION = 11295
ER_XPLUGIN_UNEXPECTED_EXCEPTION_DISPATCHING_CMD = 11296
ER_XPLUGIN_EXCEPTION_IN_TASK_SCHEDULER = 11297
ER_XPLUGIN_TASK_SCHEDULING_FAILED = 11298
ER_XPLUGIN_EXCEPTION_IN_EVENT_LOOP = 11299
ER_XPLUGIN_LISTENER_SETUP_FAILED = 11300
ER_XPLUING_NET_STARTUP_FAILED = 11301
ER_XPLUGIN_FAILED_AT_SSL_CONF = 11302
ER_XPLUGIN_CLIENT_SSL_HANDSHAKE_FAILED = 11303
ER_XPLUGIN_SSL_HANDSHAKE_WITH_SERVER_FAILED = 11304
ER_XPLUGIN_FAILED_TO_CREATE_SESSION_FOR_CONN = 11305
ER_XPLUGIN_FAILED_TO_INITIALIZE_SESSION = 11306
ER_XPLUGIN_MESSAGE_TOO_LONG = 11307
ER_XPLUGIN_UNINITIALIZED_MESSAGE = 11308
ER_XPLUGIN_FAILED_TO_SET_MIN_NUMBER_OF_WORKERS = 11309
ER_XPLUGIN_UNABLE_TO_ACCEPT_CONNECTION = 11310
ER_XPLUGIN_ALL_IO_INTERFACES_DISABLED = 11311
ER_XPLUGIN_INVALID_MSG_DURING_CLIENT_INIT = 11312
ER_XPLUGIN_CLOSING_CLIENTS_ON_SHUTDOWN = 11313
ER_XPLUGIN_ERROR_READING_SOCKET = 11314
ER_XPLUGIN_PEER_DISCONNECTED_WHILE_READING_MSG_BODY = 11315
ER_XPLUGIN_READ_FAILED_CLOSING_CONNECTION = 11316
ER_XPLUGIN_INVALID_AUTH_METHOD = 11317
ER_XPLUGIN_UNEXPECTED_MSG_DURING_AUTHENTICATION = 11318
ER_XPLUGIN_ERROR_WRITING_TO_CLIENT = 11319
ER_XPLUGIN_SCHEDULER_STARTED = 11320
ER_XPLUGIN_SCHEDULER_STOPPED = 11321
ER_XPLUGIN_LISTENER_SYS_VARIABLE_ERROR = 11322
ER_XPLUGIN_LISTENER_STATUS_MSG = 11323
ER_XPLUGIN_RETRYING_BIND_ON_PORT = 11324
ER_XPLUGIN_SHUTDOWN_TRIGGERED = 11325
ER_XPLUGIN_USER_ACCOUNT_WITH_ALL_PERMISSIONS = 11326
ER_XPLUGIN_EXISTING_USER_ACCOUNT_WITH_INCOMPLETE_GRANTS = 11327
ER_XPLUGIN_SERVER_STARTS_HANDLING_CONNECTIONS = 11328
ER_XPLUGIN_SERVER_STOPPED_HANDLING_CONNECTIONS = 11329
ER_XPLUGIN_FAILED_TO_INTERRUPT_SESSION = 11330
ER_XPLUGIN_CLIENT_RELEASE_TRIGGERED = 11331
ER_XPLUGIN_IPv6_AVAILABLE = 11332
ER_XPLUGIN_UNIX_SOCKET_NOT_CONFIGURED = 11333
ER_XPLUGIN_CLIENT_KILL_MSG = 11334
ER_XPLUGIN_FAILED_TO_GET_SECURITY_CTX = 11335
ER_XPLUGIN_FAILED_TO_SWITCH_SECURITY_CTX_TO_ROOT = 11336
ER_XPLUGIN_FAILED_TO_CLOSE_SQL_SESSION = 11337
ER_XPLUGIN_FAILED_TO_EXECUTE_ADMIN_CMD = 11338
ER_XPLUGIN_EMPTY_ADMIN_CMD = 11339
ER_XPLUGIN_FAILED_TO_GET_SYS_VAR = 11340
ER_XPLUGIN_FAILED_TO_GET_CREATION_STMT = 11341
ER_XPLUGIN_FAILED_TO_GET_ENGINE_INFO = 11342
ER_XPLUGIN_FAIL_TO_GET_RESULT_DATA = 11343
ER_XPLUGIN_CAPABILITY_EXPIRED_PASSWORD = 11344
ER_XPLUGIN_FAILED_TO_SET_SO_REUSEADDR_FLAG = 11345
ER_XPLUGIN_FAILED_TO_OPEN_INTERNAL_SESSION = 11346
ER_XPLUGIN_FAILED_TO_SWITCH_CONTEXT = 11347
ER_XPLUGIN_FAILED_TO_UNREGISTER_UDF = 11348
ER_XPLUGIN_GET_PEER_ADDRESS_FAILED = 11349
ER_XPLUGIN_CAPABILITY_CLIENT_INTERACTIVE_FAILED = 11350
ER_XPLUGIN_FAILED_TO_RESET_IPV6_V6ONLY_FLAG = 11351
ER_KEYRING_INVALID_KEY_TYPE = 11352
ER_KEYRING_INVALID_KEY_LENGTH = 11353
ER_KEYRING_FAILED_TO_CREATE_KEYRING_DIR = 11354
ER_KEYRING_FILE_INIT_FAILED = 11355
ER_KEYRING_INTERNAL_EXCEPTION_FAILED_FILE_INIT = 11356
ER_KEYRING_FAILED_TO_GENERATE_KEY = 11357
ER_KEYRING_CHECK_KEY_FAILED_DUE_TO_INVALID_KEY = 11358
ER_KEYRING_CHECK_KEY_FAILED_DUE_TO_EMPTY_KEY_ID = 11359
ER_KEYRING_OPERATION_FAILED_DUE_TO_INTERNAL_ERROR = 11360
ER_KEYRING_INCORRECT_FILE = 11361
ER_KEYRING_FOUND_MALFORMED_BACKUP_FILE = 11362
ER_KEYRING_FAILED_TO_RESTORE_FROM_BACKUP_FILE = 11363
ER_KEYRING_FAILED_TO_FLUSH_KEYRING_TO_FILE = 11364
ER_KEYRING_FAILED_TO_GET_FILE_STAT = 11365
ER_KEYRING_FAILED_TO_REMOVE_FILE = 11366
ER_KEYRING_FAILED_TO_TRUNCATE_FILE = 11367
ER_KEYRING_UNKNOWN_ERROR = 11368
ER_KEYRING_FAILED_TO_SET_KEYRING_FILE_DATA = 11369
ER_KEYRING_FILE_IO_ERROR = 11370
ER_KEYRING_FAILED_TO_LOAD_KEYRING_CONTENT = 11371
ER_KEYRING_FAILED_TO_FLUSH_KEYS_TO_KEYRING = 11372
ER_KEYRING_FAILED_TO_FLUSH_KEYS_TO_KEYRING_BACKUP = 11373
ER_KEYRING_KEY_FETCH_FAILED_DUE_TO_EMPTY_KEY_ID = 11374
ER_KEYRING_FAILED_TO_REMOVE_KEY_DUE_TO_EMPTY_ID = 11375
ER_KEYRING_OKV_INCORRECT_KEY_VAULT_CONFIGURED = 11376
ER_KEYRING_OKV_INIT_FAILED_DUE_TO_INCORRECT_CONF = 11377
ER_KEYRING_OKV_INIT_FAILED_DUE_TO_INTERNAL_ERROR = 11378
ER_KEYRING_OKV_INVALID_KEY_TYPE = 11379
ER_KEYRING_OKV_INVALID_KEY_LENGTH_FOR_CIPHER = 11380
ER_KEYRING_OKV_FAILED_TO_GENERATE_KEY_DUE_TO_INTERNAL_ERROR = 11381
ER_KEYRING_OKV_FAILED_TO_FIND_SERVER_ENTRY = 11382
ER_KEYRING_OKV_FAILED_TO_FIND_STANDBY_SERVER_ENTRY = 11383
ER_KEYRING_OKV_FAILED_TO_PARSE_CONF_FILE = 11384
ER_KEYRING_OKV_FAILED_TO_LOAD_KEY_UID = 11385
ER_KEYRING_OKV_FAILED_TO_INIT_SSL_LAYER = 11386
ER_KEYRING_OKV_FAILED_TO_INIT_CLIENT = 11387
ER_KEYRING_OKV_CONNECTION_TO_SERVER_FAILED = 11388
ER_KEYRING_OKV_FAILED_TO_REMOVE_KEY = 11389
ER_KEYRING_OKV_FAILED_TO_ADD_ATTRIBUTE = 11390
ER_KEYRING_OKV_FAILED_TO_GENERATE_KEY = 11391
ER_KEYRING_OKV_FAILED_TO_STORE_KEY = 11392
ER_KEYRING_OKV_FAILED_TO_ACTIVATE_KEYS = 11393
ER_KEYRING_OKV_FAILED_TO_FETCH_KEY = 11394
ER_KEYRING_OKV_FAILED_TO_STORE_OR_GENERATE_KEY = 11395
ER_KEYRING_OKV_FAILED_TO_RETRIEVE_KEY_SIGNATURE = 11396
ER_KEYRING_OKV_FAILED_TO_RETRIEVE_KEY = 11397
ER_KEYRING_OKV_FAILED_TO_LOAD_SSL_TRUST_STORE = 11398
ER_KEYRING_OKV_FAILED_TO_SET_CERTIFICATE_FILE = 11399
ER_KEYRING_OKV_FAILED_TO_SET_KEY_FILE = 11400
ER_KEYRING_OKV_KEY_MISMATCH = 11401
ER_KEYRING_ENCRYPTED_FILE_INCORRECT_KEYRING_FILE = 11402
ER_KEYRING_ENCRYPTED_FILE_DECRYPTION_FAILED = 11403
ER_KEYRING_ENCRYPTED_FILE_FOUND_MALFORMED_BACKUP_FILE = 11404
ER_KEYRING_ENCRYPTED_FILE_FAILED_TO_RESTORE_KEYRING = 11405
ER_KEYRING_ENCRYPTED_FILE_FAILED_TO_FLUSH_KEYRING = 11406
ER_KEYRING_ENCRYPTED_FILE_ENCRYPTION_FAILED = 11407
ER_KEYRING_ENCRYPTED_FILE_INVALID_KEYRING_DIR = 11408
ER_KEYRING_ENCRYPTED_FILE_FAILED_TO_CREATE_KEYRING_DIR = 11409
ER_KEYRING_ENCRYPTED_FILE_PASSWORD_IS_INVALID = 11410
ER_KEYRING_ENCRYPTED_FILE_PASSWORD_IS_TOO_LONG = 11411
ER_KEYRING_ENCRYPTED_FILE_INIT_FAILURE = 11412
ER_KEYRING_ENCRYPTED_FILE_INIT_FAILED_DUE_TO_INTERNAL_ERROR = 11413
ER_KEYRING_ENCRYPTED_FILE_GEN_KEY_FAILED_DUE_TO_INTERNAL_ERROR = 11414
ER_KEYRING_AWS_FAILED_TO_SET_CMK_ID = 11415
ER_KEYRING_AWS_FAILED_TO_SET_REGION = 11416
ER_KEYRING_AWS_FAILED_TO_OPEN_CONF_FILE = 11417
ER_KEYRING_AWS_FAILED_TO_ACCESS_KEY_ID_FROM_CONF_FILE = 11418
ER_KEYRING_AWS_FAILED_TO_ACCESS_KEY_FROM_CONF_FILE = 11419
ER_KEYRING_AWS_INVALID_CONF_FILE_PATH = 11420
ER_KEYRING_AWS_INVALID_DATA_FILE_PATH = 11421
ER_KEYRING_AWS_FAILED_TO_ACCESS_OR_CREATE_KEYRING_DIR = 11422
ER_KEYRING_AWS_FAILED_TO_ACCESS_OR_CREATE_KEYRING_DATA_FILE = 11423
ER_KEYRING_AWS_FAILED_TO_INIT_DUE_TO_INTERNAL_ERROR = 11424
ER_KEYRING_AWS_FAILED_TO_ACCESS_DATA_FILE = 11425
ER_KEYRING_AWS_CMK_ID_NOT_SET = 11426
ER_KEYRING_AWS_FAILED_TO_GET_KMS_CREDENTIAL_FROM_CONF_FILE = 11427
ER_KEYRING_AWS_INIT_FAILURE = 11428
ER_KEYRING_AWS_FAILED_TO_INIT_DUE_TO_PLUGIN_INTERNAL_ERROR = 11429
ER_KEYRING_AWS_INVALID_KEY_LENGTH_FOR_CIPHER = 11430
ER_KEYRING_AWS_FAILED_TO_GENERATE_KEY_DUE_TO_INTERNAL_ERROR = 11431
ER_KEYRING_AWS_INCORRECT_FILE = 11432
ER_KEYRING_AWS_FOUND_MALFORMED_BACKUP_FILE = 11433
ER_KEYRING_AWS_FAILED_TO_RESTORE_FROM_BACKUP_FILE = 11434
ER_KEYRING_AWS_FAILED_TO_FLUSH_KEYRING_TO_FILE = 11435
ER_KEYRING_AWS_INCORRECT_REGION = 11436
ER_KEYRING_AWS_FAILED_TO_CONNECT_KMS = 11437
ER_KEYRING_AWS_FAILED_TO_GENERATE_NEW_KEY = 11438
ER_KEYRING_AWS_FAILED_TO_ENCRYPT_KEY = 11439
ER_KEYRING_AWS_FAILED_TO_RE_ENCRYPT_KEY = 11440
ER_KEYRING_AWS_FAILED_TO_DECRYPT_KEY = 11441
ER_KEYRING_AWS_FAILED_TO_ROTATE_CMK = 11442
ER_GRP_RPL_GTID_ALREADY_USED = 11443
ER_GRP_RPL_APPLIER_THD_KILLED = 11444
ER_GRP_RPL_EVENT_HANDLING_ERROR = 11445
ER_GRP_RPL_ERROR_GTID_EXECUTION_INFO = 11446
ER_GRP_RPL_CERTIFICATE_SIZE_ERROR = 11447
ER_GRP_RPL_CREATE_APPLIER_CACHE_ERROR = 11448
ER_GRP_RPL_UNBLOCK_WAITING_THD = 11449
ER_GRP_RPL_APPLIER_PIPELINE_NOT_DISPOSED = 11450
ER_GRP_RPL_APPLIER_THD_EXECUTION_ABORTED = 11451
ER_GRP_RPL_APPLIER_EXECUTION_FATAL_ERROR = 11452
ER_GRP_RPL_ERROR_STOPPING_CHANNELS = 11453
ER_GRP_RPL_ERROR_SENDING_SINGLE_PRIMARY_MSSG = 11454
ER_GRP_RPL_UPDATE_TRANS_SNAPSHOT_VER_ERROR = 11455
ER_GRP_RPL_SIDNO_FETCH_ERROR = 11456
ER_GRP_RPL_BROADCAST_COMMIT_TRANS_MSSG_FAILED = 11457
ER_GRP_RPL_GROUP_NAME_PARSE_ERROR = 11458
ER_GRP_RPL_ADD_GRPSID_TO_GRPGTIDSID_MAP_ERROR = 11459
ER_GRP_RPL_UPDATE_GRPGTID_EXECUTED_ERROR = 11460
ER_GRP_RPL_DONOR_TRANS_INFO_ERROR = 11461
ER_GRP_RPL_SERVER_CONN_ERROR = 11462
ER_GRP_RPL_ERROR_FETCHING_GTID_EXECUTED_SET = 11463
ER_GRP_RPL_ADD_GTID_TO_GRPGTID_EXECUTED_ERROR = 11464
ER_GRP_RPL_ERROR_FETCHING_GTID_SET = 11465
ER_GRP_RPL_ADD_RETRIEVED_SET_TO_GRP_GTID_EXECUTED_ERROR = 11466
ER_GRP_RPL_CERTIFICATION_INITIALIZATION_FAILURE = 11467
ER_GRP_RPL_UPDATE_LAST_CONFLICT_FREE_TRANS_ERROR = 11468
ER_GRP_RPL_UPDATE_TRANS_SNAPSHOT_REF_VER_ERROR = 11469
ER_GRP_RPL_FETCH_TRANS_SIDNO_ERROR = 11470
ER_GRP_RPL_ERROR_VERIFYING_SIDNO = 11471
ER_GRP_RPL_CANT_GENERATE_GTID = 11472
ER_GRP_RPL_INVALID_GTID_SET = 11473
ER_GRP_RPL_UPDATE_GTID_SET_ERROR = 11474
ER_GRP_RPL_RECEIVED_SET_MISSING_GTIDS = 11475
ER_GRP_RPL_SKIP_COMPUTATION_TRANS_COMMITTED = 11476
ER_GRP_RPL_NULL_PACKET = 11477
ER_GRP_RPL_CANT_READ_GTID = 11478
ER_GRP_RPL_PROCESS_GTID_SET_ERROR = 11479
ER_GRP_RPL_PROCESS_INTERSECTION_GTID_SET_ERROR = 11480
ER_GRP_RPL_SET_STABLE_TRANS_ERROR = 11481
ER_GRP_RPL_CANT_READ_GRP_GTID_EXTRACTED = 11482
ER_GRP_RPL_CANT_READ_WRITE_SET_ITEM = 11483
ER_GRP_RPL_INIT_CERTIFICATION_INFO_FAILURE = 11484
ER_GRP_RPL_CONFLICT_DETECTION_DISABLED = 11485
ER_GRP_RPL_MSG_DISCARDED = 11486
ER_GRP_RPL_MISSING_GRP_RPL_APPLIER = 11487
ER_GRP_RPL_CERTIFIER_MSSG_PROCESS_ERROR = 11488
ER_GRP_RPL_SRV_NOT_ONLINE = 11489
ER_GRP_RPL_SRV_ONLINE = 11490
ER_GRP_RPL_DISABLE_SRV_READ_MODE_RESTRICTED = 11491
ER_GRP_RPL_MEM_ONLINE = 11492
ER_GRP_RPL_MEM_UNREACHABLE = 11493
ER_GRP_RPL_MEM_REACHABLE = 11494
ER_GRP_RPL_SRV_BLOCKED = 11495
ER_GRP_RPL_SRV_BLOCKED_FOR_SECS = 11496
ER_GRP_RPL_CHANGE_GRP_MEM_NOT_PROCESSED = 11497
ER_GRP_RPL_MEMBER_CONTACT_RESTORED = 11498
ER_GRP_RPL_MEMBER_REMOVED = 11499
ER_GRP_RPL_PRIMARY_MEMBER_LEFT_GRP = 11500
ER_GRP_RPL_MEMBER_ADDED = 11501
ER_GRP_RPL_MEMBER_EXIT_PLUGIN_ERROR = 11502
ER_GRP_RPL_MEMBER_CHANGE = 11503
ER_GRP_RPL_MEMBER_LEFT_GRP = 11504
ER_GRP_RPL_MEMBER_EXPELLED = 11505
ER_GRP_RPL_SESSION_OPEN_FAILED = 11506
ER_GRP_RPL_NEW_PRIMARY_ELECTED = 11507
ER_GRP_RPL_DISABLE_READ_ONLY_FAILED = 11508
ER_GRP_RPL_ENABLE_READ_ONLY_FAILED = 11509
ER_GRP_RPL_SRV_PRIMARY_MEM = 11510
ER_GRP_RPL_SRV_SECONDARY_MEM = 11511
ER_GRP_RPL_NO_SUITABLE_PRIMARY_MEM = 11512
ER_GRP_RPL_SUPER_READ_ONLY_ACTIVATE_ERROR = 11513
ER_GRP_RPL_EXCEEDS_AUTO_INC_VALUE = 11514
ER_GRP_RPL_DATA_NOT_PROVIDED_BY_MEM = 11515
ER_GRP_RPL_MEMBER_ALREADY_EXISTS = 11516
ER_GRP_RPL_GRP_CHANGE_INFO_EXTRACT_ERROR = 11517
ER_GRP_RPL_GTID_EXECUTED_EXTRACT_ERROR = 11518
ER_GRP_RPL_GTID_SET_EXTRACT_ERROR = 11519
ER_GRP_RPL_START_FAILED = 11520
ER_GRP_RPL_MEMBER_VER_INCOMPATIBLE = 11521
ER_GRP_RPL_TRANS_NOT_PRESENT_IN_GRP = 11522
ER_GRP_RPL_TRANS_GREATER_THAN_GRP = 11523
ER_GRP_RPL_MEMBER_VERSION_LOWER_THAN_GRP = 11524
ER_GRP_RPL_LOCAL_GTID_SETS_PROCESS_ERROR = 11525
ER_GRP_RPL_MEMBER_TRANS_GREATER_THAN_GRP = 11526
ER_GRP_RPL_BLOCK_SIZE_DIFF_FROM_GRP = 11527
ER_GRP_RPL_TRANS_WRITE_SET_EXTRACT_DIFF_FROM_GRP = 11528
ER_GRP_RPL_MEMBER_CFG_INCOMPATIBLE_WITH_GRP_CFG = 11529
ER_GRP_RPL_MEMBER_STOP_RPL_CHANNELS_ERROR = 11530
ER_GRP_RPL_PURGE_APPLIER_LOGS = 11531
ER_GRP_RPL_RESET_APPLIER_MODULE_LOGS_ERROR = 11532
ER_GRP_RPL_APPLIER_THD_SETUP_ERROR = 11533
ER_GRP_RPL_APPLIER_THD_START_ERROR = 11534
ER_GRP_RPL_APPLIER_THD_STOP_ERROR = 11535
ER_GRP_RPL_FETCH_TRANS_DATA_FAILED = 11536
OBSOLETE_ER_GRP_RPL_SLAVE_IO_THD_PRIMARY_UNKNOWN = 11537
ER_GRP_RPL_REPLICA_IO_THD_PRIMARY_UNKNOWN = 11537
ER_GRP_RPL_SALVE_IO_THD_ON_SECONDARY_MEMBER = 11538
OBSOLETE_ER_GRP_RPL_SLAVE_SQL_THD_PRIMARY_UNKNOWN = 11539
OBSOLETE_ER_GRP_RPL_SLAVE_SQL_THD_ON_SECONDARY_MEMBER = 11540
ER_GRP_RPL_REPLICA_SQL_THD_PRIMARY_UNKNOWN = 11539
ER_GRP_RPL_REPLICA_SQL_THD_ON_SECONDARY_MEMBER = 11540
ER_GRP_RPL_NEEDS_INNODB_TABLE = 11541
ER_GRP_RPL_PRIMARY_KEY_NOT_DEFINED = 11542
ER_GRP_RPL_FK_WITH_CASCADE_UNSUPPORTED = 11543
ER_GRP_RPL_AUTO_INC_RESET = 11544
ER_GRP_RPL_AUTO_INC_OFFSET_RESET = 11545
ER_GRP_RPL_AUTO_INC_SET = 11546
ER_GRP_RPL_AUTO_INC_OFFSET_SET = 11547
ER_GRP_RPL_FETCH_TRANS_CONTEXT_FAILED = 11548
ER_GRP_RPL_FETCH_FORMAT_DESC_LOG_EVENT_FAILED = 11549
ER_GRP_RPL_FETCH_TRANS_CONTEXT_LOG_EVENT_FAILED = 11550
ER_GRP_RPL_FETCH_SNAPSHOT_VERSION_FAILED = 11551
ER_GRP_RPL_FETCH_GTID_LOG_EVENT_FAILED = 11552
ER_GRP_RPL_UPDATE_SERV_CERTIFICATE_FAILED = 11553
ER_GRP_RPL_ADD_GTID_INFO_WITH_LOCAL_GTID_FAILED = 11554
ER_GRP_RPL_ADD_GTID_INFO_WITHOUT_LOCAL_GTID_FAILED = 11555
ER_GRP_RPL_NOTIFY_CERTIFICATION_OUTCOME_FAILED = 11556
ER_GRP_RPL_ADD_GTID_INFO_WITH_REMOTE_GTID_FAILED = 11557
ER_GRP_RPL_ADD_GTID_INFO_WITHOUT_REMOTE_GTID_FAILED = 11558
ER_GRP_RPL_FETCH_VIEW_CHANGE_LOG_EVENT_FAILED = 11559
ER_GRP_RPL_CONTACT_WITH_SRV_FAILED = 11560
ER_GRP_RPL_SRV_WAIT_TIME_OUT = 11561
ER_GRP_RPL_FETCH_LOG_EVENT_FAILED = 11562
ER_GRP_RPL_START_GRP_RPL_FAILED = 11563
ER_GRP_RPL_CONN_INTERNAL_PLUGIN_FAIL = 11564
ER_GRP_RPL_SUPER_READ_ON = 11565
ER_GRP_RPL_SUPER_READ_OFF = 11566
ER_GRP_RPL_KILLED_SESSION_ID = 11567
ER_GRP_RPL_KILLED_FAILED_ID = 11568
ER_GRP_RPL_INTERNAL_QUERY = 11569
ER_GRP_RPL_COPY_FROM_EMPTY_STRING = 11570
ER_GRP_RPL_QUERY_FAIL = 11571
ER_GRP_RPL_CREATE_SESSION_UNABLE = 11572
ER_GRP_RPL_MEMBER_NOT_FOUND = 11573
ER_GRP_RPL_MAXIMUM_CONNECTION_RETRIES_REACHED = 11574
ER_GRP_RPL_ALL_DONORS_LEFT_ABORT_RECOVERY = 11575
ER_GRP_RPL_ESTABLISH_RECOVERY_WITH_DONOR = 11576
ER_GRP_RPL_ESTABLISH_RECOVERY_WITH_ANOTHER_DONOR = 11577
ER_GRP_RPL_NO_VALID_DONOR = 11578
ER_GRP_RPL_CONFIG_RECOVERY = 11579
ER_GRP_RPL_ESTABLISHING_CONN_GRP_REC_DONOR = 11580
ER_GRP_RPL_CREATE_GRP_RPL_REC_CHANNEL = 11581
ER_GRP_RPL_DONOR_SERVER_CONN = 11582
ER_GRP_RPL_CHECK_STATUS_TABLE = 11583
ER_GRP_RPL_STARTING_GRP_REC = 11584
ER_GRP_RPL_DONOR_CONN_TERMINATION = 11585
ER_GRP_RPL_STOPPING_GRP_REC = 11586
ER_GRP_RPL_PURGE_REC = 11587
ER_GRP_RPL_UNABLE_TO_KILL_CONN_REC_DONOR_APPLIER = 11588
ER_GRP_RPL_UNABLE_TO_KILL_CONN_REC_DONOR_FAILOVER = 11589
ER_GRP_RPL_FAILED_TO_NOTIFY_GRP_MEMBERSHIP_EVENT = 11590
ER_GRP_RPL_FAILED_TO_BROADCAST_GRP_MEMBERSHIP_NOTIFICATION = 11591
ER_GRP_RPL_FAILED_TO_BROADCAST_MEMBER_STATUS_NOTIFICATION = 11592
ER_GRP_RPL_OOM_FAILED_TO_GENERATE_IDENTIFICATION_HASH = 11593
ER_GRP_RPL_WRITE_IDENT_HASH_BASE64_ENCODING_FAILED = 11594
ER_GRP_RPL_INVALID_BINLOG_FORMAT = 11595
ER_GRP_RPL_BINLOG_CHECKSUM_SET = 11596
ER_GRP_RPL_TRANS_WRITE_SET_EXTRACTION_NOT_SET = 11597
ER_GRP_RPL_UNSUPPORTED_TRANS_ISOLATION = 11598
ER_GRP_RPL_CANNOT_EXECUTE_TRANS_WHILE_STOPPING = 11599
ER_GRP_RPL_CANNOT_EXECUTE_TRANS_WHILE_RECOVERING = 11600
ER_GRP_RPL_CANNOT_EXECUTE_TRANS_IN_ERROR_STATE = 11601
ER_GRP_RPL_CANNOT_EXECUTE_TRANS_IN_OFFLINE_MODE = 11602
ER_GRP_RPL_MULTIPLE_CACHE_TYPE_NOT_SUPPORTED_FOR_SESSION = 11603
ER_GRP_RPL_FAILED_TO_REINIT_BINLOG_CACHE_FOR_READ = 11604
ER_GRP_RPL_FAILED_TO_CREATE_TRANS_CONTEXT = 11605
ER_GRP_RPL_FAILED_TO_EXTRACT_TRANS_WRITE_SET = 11606
ER_GRP_RPL_FAILED_TO_GATHER_TRANS_WRITE_SET = 11607
ER_GRP_RPL_TRANS_SIZE_EXCEEDS_LIMIT = 11608
ER_GRP_RPL_REINIT_OF_INTERNAL_CACHE_FOR_READ_FAILED = 11609
ER_GRP_RPL_APPENDING_DATA_TO_INTERNAL_CACHE_FAILED = 11610
ER_GRP_RPL_WRITE_TO_BINLOG_CACHE_FAILED = 11611
ER_GRP_RPL_FAILED_TO_REGISTER_TRANS_OUTCOME_NOTIFICTION = 11612
ER_GRP_RPL_MSG_TOO_LONG_BROADCASTING_TRANS_FAILED = 11613
ER_GRP_RPL_BROADCASTING_TRANS_TO_GRP_FAILED = 11614
ER_GRP_RPL_ERROR_WHILE_WAITING_FOR_CONFLICT_DETECTION = 11615
ER_GRP_RPL_REINIT_OF_INTERNAL_CACHE_FOR_WRITE_FAILED = 11616
ER_GRP_RPL_FAILED_TO_CREATE_COMMIT_CACHE = 11617
ER_GRP_RPL_REINIT_OF_COMMIT_CACHE_FOR_WRITE_FAILED = 11618
ER_GRP_RPL_PREV_REC_SESSION_RUNNING = 11619
ER_GRP_RPL_FATAL_REC_PROCESS = 11620
ER_GRP_RPL_WHILE_STOPPING_REP_CHANNEL = 11621
ER_GRP_RPL_UNABLE_TO_EVALUATE_APPLIER_STATUS = 11622
ER_GRP_RPL_ONLY_ONE_SERVER_ALIVE = 11623
ER_GRP_RPL_CERTIFICATION_REC_PROCESS = 11624
ER_GRP_RPL_UNABLE_TO_ENSURE_EXECUTION_REC = 11625
ER_GRP_RPL_WHILE_SENDING_MSG_REC = 11626
ER_GRP_RPL_READ_UNABLE_FOR_SUPER_READ_ONLY = 11627
ER_GRP_RPL_READ_UNABLE_FOR_READ_ONLY_SUPER_READ_ONLY = 11628
ER_GRP_RPL_UNABLE_TO_RESET_SERVER_READ_MODE = 11629
ER_GRP_RPL_UNABLE_TO_CERTIFY_PLUGIN_TRANS = 11630
ER_GRP_RPL_UNBLOCK_CERTIFIED_TRANS = 11631
ER_GRP_RPL_SERVER_WORKING_AS_SECONDARY = 11632
ER_GRP_RPL_FAILED_TO_START_WITH_INVALID_SERVER_ID = 11633
ER_GRP_RPL_FORCE_MEMBERS_MUST_BE_EMPTY = 11634
ER_GRP_RPL_PLUGIN_STRUCT_INIT_NOT_POSSIBLE_ON_SERVER_START = 11635
ER_GRP_RPL_FAILED_TO_ENABLE_SUPER_READ_ONLY_MODE = 11636
ER_GRP_RPL_FAILED_TO_INIT_COMMUNICATION_ENGINE = 11637
ER_GRP_RPL_FAILED_TO_START_ON_SECONDARY_WITH_ASYNC_CHANNELS = 11638
ER_GRP_RPL_FAILED_TO_START_COMMUNICATION_ENGINE = 11639
ER_GRP_RPL_TIMEOUT_ON_VIEW_AFTER_JOINING_GRP = 11640
ER_GRP_RPL_FAILED_TO_CALL_GRP_COMMUNICATION_INTERFACE = 11641
ER_GRP_RPL_MEMBER_SERVER_UUID_IS_INCOMPATIBLE_WITH_GRP = 11642
ER_GRP_RPL_MEMBER_CONF_INFO = 11643
ER_GRP_RPL_FAILED_TO_CONFIRM_IF_SERVER_LEFT_GRP = 11644
ER_GRP_RPL_SERVER_IS_ALREADY_LEAVING = 11645
ER_GRP_RPL_SERVER_ALREADY_LEFT = 11646
ER_GRP_RPL_WAITING_FOR_VIEW_UPDATE = 11647
ER_GRP_RPL_TIMEOUT_RECEIVING_VIEW_CHANGE_ON_SHUTDOWN = 11648
ER_GRP_RPL_REQUESTING_NON_MEMBER_SERVER_TO_LEAVE = 11649
ER_GRP_RPL_IS_STOPPING = 11650
ER_GRP_RPL_IS_STOPPED = 11651
ER_GRP_RPL_FAILED_TO_ENABLE_READ_ONLY_MODE_ON_SHUTDOWN = 11652
ER_GRP_RPL_RECOVERY_MODULE_TERMINATION_TIMED_OUT_ON_SHUTDOWN = 11653
ER_GRP_RPL_APPLIER_TERMINATION_TIMED_OUT_ON_SHUTDOWN = 11654
ER_GRP_RPL_FAILED_TO_SHUTDOWN_REGISTRY_MODULE = 11655
ER_GRP_RPL_FAILED_TO_INIT_HANDLER = 11656
ER_GRP_RPL_FAILED_TO_REGISTER_SERVER_STATE_OBSERVER = 11657
ER_GRP_RPL_FAILED_TO_REGISTER_TRANS_STATE_OBSERVER = 11658
ER_GRP_RPL_FAILED_TO_REGISTER_BINLOG_STATE_OBSERVER = 11659
ER_GRP_RPL_FAILED_TO_START_ON_BOOT = 11660
ER_GRP_RPL_FAILED_TO_STOP_ON_PLUGIN_UNINSTALL = 11661
ER_GRP_RPL_FAILED_TO_UNREGISTER_SERVER_STATE_OBSERVER = 11662
ER_GRP_RPL_FAILED_TO_UNREGISTER_TRANS_STATE_OBSERVER = 11663
ER_GRP_RPL_FAILED_TO_UNREGISTER_BINLOG_STATE_OBSERVER = 11664
ER_GRP_RPL_ALL_OBSERVERS_UNREGISTERED = 11665
ER_GRP_RPL_FAILED_TO_PARSE_THE_GRP_NAME = 11666
ER_GRP_RPL_FAILED_TO_GENERATE_SIDNO_FOR_GRP = 11667
ER_GRP_RPL_APPLIER_NOT_STARTED_DUE_TO_RUNNING_PREV_SHUTDOWN = 11668
ER_GRP_RPL_FAILED_TO_INIT_APPLIER_MODULE = 11669
ER_GRP_RPL_APPLIER_INITIALIZED = 11670
ER_GRP_RPL_COMMUNICATION_SSL_CONF_INFO = 11671
ER_GRP_RPL_ABORTS_AS_SSL_NOT_SUPPORTED_BY_MYSQLD = 11672
ER_GRP_RPL_SSL_DISABLED = 11673
ER_GRP_RPL_UNABLE_TO_INIT_COMMUNICATION_ENGINE = 11674
ER_GRP_RPL_BINLOG_DISABLED = 11675
ER_GRP_RPL_GTID_MODE_OFF = 11676
OBSOLETE_ER_GRP_RPL_LOG_SLAVE_UPDATES_NOT_SET = 11677
ER_GRP_RPL_LOG_REPLICA_UPDATES_NOT_SET = 11677
ER_GRP_RPL_INVALID_TRANS_WRITE_SET_EXTRACTION_VALUE = 11678
ER_GRP_RPL_RELAY_LOG_INFO_REPO_MUST_BE_TABLE = 11679
OBSOLETE_ER_GRP_RPL_MASTER_INFO_REPO_MUST_BE_TABLE = 11680
ER_GRP_RPL_SOURCE_INFO_REPO_MUST_BE_TABLE = 11680
ER_GRP_RPL_INCORRECT_TYPE_SET_FOR_PARALLEL_APPLIER = 11681
OBSOLETE_ER_GRP_RPL_SLAVE_PRESERVE_COMMIT_ORDER_NOT_SET = 11682
ER_GRP_RPL_REPLICA_PRESERVE_COMMIT_ORDER_NOT_SET = 11682
ER_GRP_RPL_SINGLE_PRIM_MODE_NOT_ALLOWED_WITH_UPDATE_EVERYWHERE = 11683
ER_GRP_RPL_MODULE_TERMINATE_ERROR = 11684
ER_GRP_RPL_GRP_NAME_OPTION_MANDATORY = 11685
ER_GRP_RPL_GRP_NAME_IS_TOO_LONG = 11686
ER_GRP_RPL_GRP_NAME_IS_NOT_VALID_UUID = 11687
ER_GRP_RPL_FLOW_CTRL_MIN_QUOTA_GREATER_THAN_MAX_QUOTA = 11688
ER_GRP_RPL_FLOW_CTRL_MIN_RECOVERY_QUOTA_GREATER_THAN_MAX_QUOTA = 11689
ER_GRP_RPL_FLOW_CTRL_MAX_QUOTA_SMALLER_THAN_MIN_QUOTAS = 11690
ER_GRP_RPL_INVALID_SSL_RECOVERY_STRING = 11691
ER_GRP_RPL_SUPPORTS_ONLY_ONE_FORCE_MEMBERS_SET = 11692
ER_GRP_RPL_FORCE_MEMBERS_SET_UPDATE_NOT_ALLOWED = 11693
ER_GRP_RPL_GRP_COMMUNICATION_INIT_WITH_CONF = 11694
ER_GRP_RPL_UNKNOWN_GRP_RPL_APPLIER_PIPELINE_REQUESTED = 11695
ER_GRP_RPL_FAILED_TO_BOOTSTRAP_EVENT_HANDLING_INFRASTRUCTURE = 11696
ER_GRP_RPL_APPLIER_HANDLER_NOT_INITIALIZED = 11697
ER_GRP_RPL_APPLIER_HANDLER_IS_IN_USE = 11698
ER_GRP_RPL_APPLIER_HANDLER_ROLE_IS_IN_USE = 11699
ER_GRP_RPL_FAILED_TO_INIT_APPLIER_HANDLER = 11700
ER_GRP_RPL_SQL_SERVICE_FAILED_TO_INIT_SESSION_THREAD = 11701
ER_GRP_RPL_SQL_SERVICE_COMM_SESSION_NOT_INITIALIZED = 11702
ER_GRP_RPL_SQL_SERVICE_SERVER_SESSION_KILLED = 11703
ER_GRP_RPL_SQL_SERVICE_FAILED_TO_RUN_SQL_QUERY = 11704
ER_GRP_RPL_SQL_SERVICE_SERVER_INTERNAL_FAILURE = 11705
ER_GRP_RPL_SQL_SERVICE_RETRIES_EXCEEDED_ON_SESSION_STATE = 11706
ER_GRP_RPL_SQL_SERVICE_FAILED_TO_FETCH_SECURITY_CTX = 11707
ER_GRP_RPL_SQL_SERVICE_SERVER_ACCESS_DENIED_FOR_USER = 11708
ER_GRP_RPL_SQL_SERVICE_MAX_CONN_ERROR_FROM_SERVER = 11709
ER_GRP_RPL_SQL_SERVICE_SERVER_ERROR_ON_CONN = 11710
ER_GRP_RPL_UNREACHABLE_MAJORITY_TIMEOUT_FOR_MEMBER = 11711
ER_GRP_RPL_SERVER_SET_TO_READ_ONLY_DUE_TO_ERRORS = 11712
ER_GRP_RPL_GMS_LISTENER_FAILED_TO_LOG_NOTIFICATION = 11713
ER_GRP_RPL_GRP_COMMUNICATION_ENG_INIT_FAILED = 11714
ER_GRP_RPL_SET_GRP_COMMUNICATION_ENG_LOGGER_FAILED = 11715
ER_GRP_RPL_DEBUG_OPTIONS = 11716
ER_GRP_RPL_INVALID_DEBUG_OPTIONS = 11717
ER_GRP_RPL_EXIT_GRP_GCS_ERROR = 11718
ER_GRP_RPL_GRP_MEMBER_OFFLINE = 11719
ER_GRP_RPL_GCS_INTERFACE_ERROR = 11720
ER_GRP_RPL_FORCE_MEMBER_VALUE_SET_ERROR = 11721
ER_GRP_RPL_FORCE_MEMBER_VALUE_SET = 11722
ER_GRP_RPL_FORCE_MEMBER_VALUE_TIME_OUT = 11723
ER_GRP_RPL_BROADCAST_COMMIT_MSSG_TOO_BIG = 11724
ER_GRP_RPL_SEND_STATS_ERROR = 11725
ER_GRP_RPL_MEMBER_STATS_INFO = 11726
ER_GRP_RPL_FLOW_CONTROL_STATS = 11727
ER_GRP_RPL_UNABLE_TO_CONVERT_PACKET_TO_EVENT = 11728
ER_GRP_RPL_PIPELINE_CREATE_FAILED = 11729
ER_GRP_RPL_PIPELINE_REINIT_FAILED_WRITE = 11730
ER_GRP_RPL_UNABLE_TO_CONVERT_EVENT_TO_PACKET = 11731
ER_GRP_RPL_PIPELINE_FLUSH_FAIL = 11732
ER_GRP_RPL_PIPELINE_REINIT_FAILED_READ = 11733
ER_GRP_RPL_STOP_REP_CHANNEL = 11734
ER_GRP_RPL_GCS_GR_ERROR_MSG = 11735
OBSOLETE_ER_GRP_RPL_SLAVE_IO_THREAD_UNBLOCKED = 11736
OBSOLETE_ER_GRP_RPL_SLAVE_IO_THREAD_ERROR_OUT = 11737
OBSOLETE_ER_GRP_RPL_SLAVE_APPLIER_THREAD_UNBLOCKED = 11738
OBSOLETE_ER_GRP_RPL_SLAVE_APPLIER_THREAD_ERROR_OUT = 11739
ER_GRP_RPL_REPLICA_IO_THREAD_UNBLOCKED = 11736
ER_GRP_RPL_REPLICA_IO_THREAD_ERROR_OUT = 11737
ER_GRP_RPL_REPLICA_APPLIER_THREAD_UNBLOCKED = 11738
ER_GRP_RPL_REPLICA_APPLIER_THREAD_ERROR_OUT = 11739
ER_LDAP_AUTH_FAILED_TO_CREATE_OR_GET_CONNECTION = 11740
ER_LDAP_AUTH_DEINIT_FAILED = 11741
ER_LDAP_AUTH_SKIPPING_USER_GROUP_SEARCH = 11742
ER_LDAP_AUTH_POOL_DISABLE_MAX_SIZE_ZERO = 11743
ER_LDAP_AUTH_FAILED_TO_CREATE_LDAP_OBJECT_CREATOR = 11744
ER_LDAP_AUTH_FAILED_TO_CREATE_LDAP_OBJECT = 11745
ER_LDAP_AUTH_TLS_CONF = 11746
ER_LDAP_AUTH_TLS_CONNECTION = 11747
ER_LDAP_AUTH_CONN_POOL_NOT_CREATED = 11748
ER_LDAP_AUTH_CONN_POOL_INITIALIZING = 11749
ER_LDAP_AUTH_CONN_POOL_DEINITIALIZING = 11750
ER_LDAP_AUTH_ZERO_MAX_POOL_SIZE_UNCHANGED = 11751
ER_LDAP_AUTH_POOL_REINITIALIZING = 11752
ER_LDAP_AUTH_FAILED_TO_WRITE_PACKET = 11753
ER_LDAP_AUTH_SETTING_USERNAME = 11754
ER_LDAP_AUTH_USER_AUTH_DATA = 11755
ER_LDAP_AUTH_INFO_FOR_USER = 11756
ER_LDAP_AUTH_USER_GROUP_SEARCH_INFO = 11757
ER_LDAP_AUTH_GRP_SEARCH_SPECIAL_HDL = 11758
ER_LDAP_AUTH_GRP_IS_FULL_DN = 11759
ER_LDAP_AUTH_USER_NOT_FOUND_IN_ANY_GRP = 11760
ER_LDAP_AUTH_USER_FOUND_IN_MANY_GRPS = 11761
ER_LDAP_AUTH_USER_HAS_MULTIPLE_GRP_NAMES = 11762
ER_LDAP_AUTH_SEARCHED_USER_GRP_NAME = 11763
ER_LDAP_AUTH_OBJECT_CREATE_TIMESTAMP = 11764
ER_LDAP_AUTH_CERTIFICATE_NAME = 11765
ER_LDAP_AUTH_FAILED_TO_POOL_DEINIT = 11766
ER_LDAP_AUTH_FAILED_TO_INITIALIZE_POOL_IN_RECONSTRUCTING = 11767
ER_LDAP_AUTH_FAILED_TO_INITIALIZE_POOL_IN_INIT_STATE = 11768
ER_LDAP_AUTH_FAILED_TO_INITIALIZE_POOL_IN_DEINIT_STATE = 11769
ER_LDAP_AUTH_FAILED_TO_DEINITIALIZE_POOL_IN_RECONSTRUCT_STATE = 11770
ER_LDAP_AUTH_FAILED_TO_DEINITIALIZE_NOT_READY_POOL = 11771
ER_LDAP_AUTH_FAILED_TO_GET_CONNECTION_AS_PLUGIN_NOT_READY = 11772
ER_LDAP_AUTH_CONNECTION_POOL_INIT_FAILED = 11773
ER_LDAP_AUTH_MAX_ALLOWED_CONNECTION_LIMIT_HIT = 11774
ER_LDAP_AUTH_MAX_POOL_SIZE_SET_FAILED = 11775
ER_LDAP_AUTH_PLUGIN_FAILED_TO_READ_PACKET = 11776
ER_LDAP_AUTH_CREATING_LDAP_CONNECTION = 11777
ER_LDAP_AUTH_GETTING_CONNECTION_FROM_POOL = 11778
ER_LDAP_AUTH_RETURNING_CONNECTION_TO_POOL = 11779
ER_LDAP_AUTH_SEARCH_USER_GROUP_ATTR_NOT_FOUND = 11780
ER_LDAP_AUTH_LDAP_INFO_NULL = 11781
ER_LDAP_AUTH_FREEING_CONNECTION = 11782
ER_LDAP_AUTH_CONNECTION_PUSHED_TO_POOL = 11783
ER_LDAP_AUTH_CONNECTION_CREATOR_ENTER = 11784
ER_LDAP_AUTH_STARTING_TLS = 11785
ER_LDAP_AUTH_CONNECTION_GET_LDAP_INFO_NULL = 11786
ER_LDAP_AUTH_DELETING_CONNECTION_KEY = 11787
ER_LDAP_AUTH_POOLED_CONNECTION_KEY = 11788
ER_LDAP_AUTH_CREATE_CONNECTION_KEY = 11789
ER_LDAP_AUTH_COMMUNICATION_HOST_INFO = 11790
ER_LDAP_AUTH_METHOD_TO_CLIENT = 11791
ER_LDAP_AUTH_SASL_REQUEST_FROM_CLIENT = 11792
ER_LDAP_AUTH_SASL_PROCESS_SASL = 11793
ER_LDAP_AUTH_SASL_BIND_SUCCESS_INFO = 11794
ER_LDAP_AUTH_STARTED_FOR_USER = 11795
ER_LDAP_AUTH_DISTINGUISHED_NAME = 11796
ER_LDAP_AUTH_INIT_FAILED = 11797
ER_LDAP_AUTH_OR_GROUP_RETRIEVAL_FAILED = 11798
ER_LDAP_AUTH_USER_GROUP_SEARCH_FAILED = 11799
ER_LDAP_AUTH_USER_BIND_FAILED = 11800
ER_LDAP_AUTH_POOL_GET_FAILED_TO_CREATE_CONNECTION = 11801
ER_LDAP_AUTH_FAILED_TO_CREATE_LDAP_CONNECTION = 11802
ER_LDAP_AUTH_FAILED_TO_ESTABLISH_TLS_CONNECTION = 11803
ER_LDAP_AUTH_FAILED_TO_SEARCH_DN = 11804
ER_LDAP_AUTH_CONNECTION_POOL_REINIT_ENTER = 11805
ER_SYSTEMD_NOTIFY_PATH_TOO_LONG = 11806
ER_SYSTEMD_NOTIFY_CONNECT_FAILED = 11807
ER_SYSTEMD_NOTIFY_WRITE_FAILED = 11808
ER_FOUND_MISSING_GTIDS = 11809
ER_PID_FILE_PRIV_DIRECTORY_INSECURE = 11810
ER_CANT_CHECK_PID_PATH = 11811
ER_VALIDATE_PWD_STATUS_VAR_REGISTRATION_FAILED = 11812
ER_VALIDATE_PWD_STATUS_VAR_UNREGISTRATION_FAILED = 11813
ER_VALIDATE_PWD_DICT_FILE_OPEN_FAILED = 11814
ER_VALIDATE_PWD_COULD_BE_NULL = 11815
ER_VALIDATE_PWD_STRING_CONV_TO_LOWERCASE_FAILED = 11816
ER_VALIDATE_PWD_STRING_CONV_TO_BUFFER_FAILED = 11817
ER_VALIDATE_PWD_STRING_HANDLER_MEM_ALLOCATION_FAILED = 11818
ER_VALIDATE_PWD_STRONG_POLICY_DICT_FILE_UNSPECIFIED = 11819
ER_VALIDATE_PWD_CONVERT_TO_BUFFER_FAILED = 11820
ER_VALIDATE_PWD_VARIABLE_REGISTRATION_FAILED = 11821
ER_VALIDATE_PWD_VARIABLE_UNREGISTRATION_FAILED = 11822
ER_KEYRING_MIGRATION_EXTRA_OPTIONS = 11823
OBSOLETE_ER_INVALID_DEFAULT_UTF8MB4_COLLATION = 11824
ER_IB_MSG_0 = 11825
ER_IB_MSG_1 = 11826
ER_IB_MSG_2 = 11827
ER_IB_MSG_3 = 11828
ER_IB_MSG_4 = 11829
ER_IB_MSG_5 = 11830
ER_IB_MSG_6 = 11831
ER_IB_MSG_7 = 11832
ER_IB_MSG_8 = 11833
ER_IB_MSG_9 = 11834
ER_IB_MSG_10 = 11835
ER_IB_MSG_11 = 11836
ER_IB_MSG_12 = 11837
ER_IB_MSG_13 = 11838
ER_IB_MSG_14 = 11839
ER_IB_MSG_15 = 11840
ER_IB_MSG_16 = 11841
ER_IB_MSG_17 = 11842
ER_IB_MSG_18 = 11843
ER_IB_MSG_19 = 11844
ER_IB_MSG_20 = 11845
ER_IB_MSG_21 = 11846
ER_IB_MSG_22 = 11847
ER_IB_MSG_23 = 11848
ER_IB_MSG_24 = 11849
ER_IB_MSG_25 = 11850
ER_IB_MSG_26 = 11851
ER_IB_MSG_27 = 11852
ER_IB_MSG_28 = 11853
ER_IB_MSG_29 = 11854
ER_IB_MSG_30 = 11855
ER_IB_MSG_31 = 11856
ER_IB_MSG_32 = 11857
ER_IB_MSG_33 = 11858
ER_IB_MSG_34 = 11859
ER_IB_MSG_35 = 11860
ER_IB_MSG_36 = 11861
ER_IB_MSG_37 = 11862
ER_IB_MSG_38 = 11863
ER_IB_MSG_39 = 11864
ER_IB_MSG_40 = 11865
ER_IB_MSG_41 = 11866
ER_IB_MSG_42 = 11867
ER_IB_MSG_43 = 11868
ER_IB_MSG_44 = 11869
ER_IB_MSG_45 = 11870
ER_IB_MSG_46 = 11871
ER_IB_MSG_47 = 11872
ER_IB_MSG_48 = 11873
ER_IB_MSG_49 = 11874
ER_IB_MSG_50 = 11875
ER_IB_MSG_51 = 11876
ER_IB_MSG_52 = 11877
ER_IB_MSG_53 = 11878
ER_IB_MSG_54 = 11879
ER_IB_MSG_55 = 11880
ER_IB_MSG_56 = 11881
ER_IB_MSG_57 = 11882
ER_IB_MSG_58 = 11883
ER_IB_MSG_59 = 11884
ER_IB_MSG_60 = 11885
ER_IB_MSG_61 = 11886
ER_IB_MSG_62 = 11887
ER_IB_MSG_63 = 11888
ER_IB_MSG_64 = 11889
ER_IB_MSG_65 = 11890
ER_IB_MSG_66 = 11891
ER_IB_MSG_67 = 11892
ER_IB_MSG_68 = 11893
ER_IB_MSG_69 = 11894
ER_IB_MSG_70 = 11895
ER_IB_MSG_71 = 11896
ER_IB_MSG_72 = 11897
ER_IB_MSG_73 = 11898
ER_IB_MSG_74 = 11899
ER_IB_MSG_75 = 11900
ER_IB_MSG_76 = 11901
ER_IB_MSG_77 = 11902
ER_IB_MSG_78 = 11903
ER_IB_MSG_79 = 11904
ER_IB_MSG_80 = 11905
ER_IB_MSG_81 = 11906
ER_IB_MSG_82 = 11907
ER_IB_MSG_83 = 11908
ER_IB_MSG_84 = 11909
ER_IB_MSG_85 = 11910
ER_IB_MSG_86 = 11911
ER_IB_MSG_87 = 11912
ER_IB_MSG_88 = 11913
ER_IB_MSG_89 = 11914
ER_IB_MSG_90 = 11915
ER_IB_MSG_91 = 11916
ER_IB_MSG_92 = 11917
ER_IB_MSG_93 = 11918
ER_IB_MSG_94 = 11919
ER_IB_MSG_95 = 11920
ER_IB_MSG_96 = 11921
ER_IB_MSG_97 = 11922
ER_IB_MSG_98 = 11923
ER_IB_MSG_99 = 11924
ER_IB_MSG_100 = 11925
ER_IB_MSG_101 = 11926
ER_IB_MSG_102 = 11927
ER_IB_MSG_103 = 11928
ER_IB_MSG_104 = 11929
ER_IB_MSG_105 = 11930
ER_IB_MSG_106 = 11931
ER_IB_MSG_107 = 11932
ER_IB_MSG_108 = 11933
ER_IB_MSG_109 = 11934
ER_IB_MSG_110 = 11935
ER_IB_MSG_111 = 11936
ER_IB_MSG_112 = 11937
ER_IB_MSG_113 = 11938
ER_IB_MSG_114 = 11939
ER_IB_MSG_115 = 11940
ER_IB_MSG_116 = 11941
ER_IB_MSG_117 = 11942
ER_IB_MSG_118 = 11943
ER_IB_MSG_119 = 11944
ER_IB_MSG_120 = 11945
ER_IB_MSG_121 = 11946
ER_IB_MSG_122 = 11947
ER_IB_MSG_123 = 11948
ER_IB_MSG_124 = 11949
ER_IB_MSG_125 = 11950
ER_IB_MSG_126 = 11951
ER_IB_MSG_127 = 11952
ER_IB_MSG_128 = 11953
ER_IB_MSG_129 = 11954
ER_IB_MSG_130 = 11955
ER_IB_MSG_131 = 11956
ER_IB_MSG_132 = 11957
ER_IB_MSG_133 = 11958
ER_IB_MSG_134 = 11959
ER_IB_MSG_135 = 11960
ER_IB_MSG_136 = 11961
ER_IB_MSG_137 = 11962
ER_IB_MSG_138 = 11963
ER_IB_MSG_139 = 11964
ER_IB_MSG_140 = 11965
ER_IB_MSG_141 = 11966
ER_IB_MSG_142 = 11967
ER_IB_MSG_143 = 11968
ER_IB_MSG_144 = 11969
ER_IB_MSG_145 = 11970
ER_IB_MSG_146 = 11971
ER_IB_MSG_147 = 11972
ER_IB_MSG_148 = 11973
ER_IB_MSG_149 = 11974
ER_IB_MSG_150 = 11975
ER_IB_MSG_151 = 11976
ER_IB_MSG_152 = 11977
ER_IB_MSG_153 = 11978
ER_IB_MSG_154 = 11979
ER_IB_MSG_155 = 11980
ER_IB_MSG_156 = 11981
ER_IB_MSG_157 = 11982
ER_IB_MSG_158 = 11983
ER_IB_MSG_159 = 11984
ER_IB_MSG_160 = 11985
ER_IB_MSG_161 = 11986
ER_IB_MSG_162 = 11987
ER_IB_MSG_163 = 11988
ER_IB_MSG_164 = 11989
ER_IB_MSG_165 = 11990
ER_IB_MSG_166 = 11991
ER_IB_MSG_167 = 11992
ER_IB_MSG_168 = 11993
ER_IB_MSG_169 = 11994
ER_IB_MSG_170 = 11995
ER_IB_MSG_171 = 11996
ER_IB_MSG_172 = 11997
ER_IB_MSG_173 = 11998
ER_IB_MSG_174 = 11999
ER_IB_MSG_175 = 12000
ER_IB_MSG_176 = 12001
ER_IB_MSG_177 = 12002
ER_IB_MSG_178 = 12003
ER_IB_MSG_179 = 12004
ER_IB_MSG_180 = 12005
ER_IB_MSG_181 = 12006
ER_IB_MSG_182 = 12007
ER_IB_MSG_183 = 12008
ER_IB_MSG_184 = 12009
ER_IB_MSG_185 = 12010
ER_IB_MSG_186 = 12011
ER_IB_MSG_187 = 12012
ER_IB_MSG_188 = 12013
ER_IB_MSG_189 = 12014
ER_IB_MSG_190 = 12015
ER_IB_MSG_191 = 12016
ER_IB_MSG_192 = 12017
ER_IB_MSG_193 = 12018
ER_IB_MSG_194 = 12019
ER_IB_MSG_195 = 12020
ER_IB_MSG_196 = 12021
ER_IB_MSG_197 = 12022
ER_IB_MSG_198 = 12023
ER_IB_MSG_199 = 12024
ER_IB_MSG_200 = 12025
ER_IB_MSG_201 = 12026
ER_IB_MSG_202 = 12027
ER_IB_MSG_203 = 12028
ER_IB_MSG_204 = 12029
ER_IB_MSG_205 = 12030
ER_IB_MSG_206 = 12031
ER_IB_MSG_207 = 12032
ER_IB_MSG_208 = 12033
ER_IB_MSG_209 = 12034
ER_IB_MSG_210 = 12035
ER_IB_MSG_211 = 12036
ER_IB_MSG_212 = 12037
ER_IB_MSG_213 = 12038
ER_IB_MSG_214 = 12039
ER_IB_MSG_215 = 12040
ER_IB_MSG_216 = 12041
ER_IB_MSG_217 = 12042
ER_IB_MSG_218 = 12043
ER_IB_MSG_219 = 12044
ER_IB_MSG_220 = 12045
ER_IB_MSG_221 = 12046
ER_IB_MSG_222 = 12047
ER_IB_MSG_223 = 12048
ER_IB_MSG_224 = 12049
ER_IB_MSG_225 = 12050
ER_IB_MSG_226 = 12051
ER_IB_MSG_227 = 12052
ER_IB_MSG_228 = 12053
ER_IB_MSG_229 = 12054
ER_IB_MSG_230 = 12055
ER_IB_MSG_231 = 12056
ER_IB_MSG_232 = 12057
ER_IB_MSG_233 = 12058
ER_IB_MSG_234 = 12059
ER_IB_MSG_235 = 12060
ER_IB_MSG_236 = 12061
ER_IB_MSG_237 = 12062
ER_IB_MSG_238 = 12063
ER_IB_MSG_239 = 12064
ER_IB_MSG_240 = 12065
ER_IB_MSG_241 = 12066
ER_IB_MSG_242 = 12067
ER_IB_MSG_243 = 12068
ER_IB_MSG_244 = 12069
ER_IB_MSG_245 = 12070
ER_IB_MSG_246 = 12071
ER_IB_MSG_247 = 12072
ER_IB_MSG_248 = 12073
ER_IB_MSG_249 = 12074
ER_IB_MSG_250 = 12075
ER_IB_MSG_251 = 12076
ER_IB_MSG_252 = 12077
ER_IB_MSG_253 = 12078
ER_IB_MSG_254 = 12079
ER_IB_MSG_255 = 12080
ER_IB_MSG_256 = 12081
ER_IB_MSG_257 = 12082
ER_IB_MSG_258 = 12083
ER_IB_MSG_259 = 12084
ER_IB_MSG_260 = 12085
ER_IB_MSG_261 = 12086
ER_IB_MSG_262 = 12087
ER_IB_MSG_263 = 12088
ER_IB_MSG_264 = 12089
ER_IB_MSG_265 = 12090
ER_IB_MSG_266 = 12091
ER_IB_MSG_267 = 12092
ER_IB_MSG_268 = 12093
ER_IB_MSG_269 = 12094
ER_IB_MSG_270 = 12095
ER_IB_MSG_271 = 12096
ER_IB_MSG_272 = 12097
ER_IB_MSG_273 = 12098
ER_IB_MSG_274 = 12099
ER_IB_MSG_275 = 12100
ER_IB_MSG_276 = 12101
ER_IB_MSG_277 = 12102
ER_IB_MSG_278 = 12103
ER_IB_MSG_279 = 12104
ER_IB_MSG_280 = 12105
ER_IB_MSG_281 = 12106
ER_IB_MSG_282 = 12107
ER_IB_MSG_283 = 12108
ER_IB_MSG_284 = 12109
ER_IB_MSG_285 = 12110
ER_IB_MSG_286 = 12111
ER_IB_MSG_287 = 12112
ER_IB_MSG_288 = 12113
ER_IB_MSG_289 = 12114
ER_IB_MSG_290 = 12115
ER_IB_MSG_291 = 12116
ER_IB_MSG_292 = 12117
ER_IB_MSG_293 = 12118
ER_IB_MSG_294 = 12119
ER_IB_MSG_295 = 12120
ER_IB_MSG_296 = 12121
ER_IB_MSG_297 = 12122
ER_IB_MSG_298 = 12123
ER_IB_MSG_299 = 12124
ER_IB_MSG_300 = 12125
ER_IB_MSG_301 = 12126
ER_IB_MSG_302 = 12127
ER_IB_MSG_303 = 12128
ER_IB_MSG_304 = 12129
ER_IB_MSG_305 = 12130
ER_IB_MSG_306 = 12131
ER_IB_MSG_307 = 12132
ER_IB_MSG_308 = 12133
ER_IB_MSG_309 = 12134
ER_IB_MSG_310 = 12135
ER_IB_MSG_311 = 12136
ER_IB_MSG_312 = 12137
ER_IB_MSG_313 = 12138
ER_IB_MSG_314 = 12139
ER_IB_MSG_315 = 12140
ER_IB_MSG_316 = 12141
ER_IB_MSG_317 = 12142
ER_IB_MSG_318 = 12143
ER_IB_MSG_319 = 12144
ER_IB_MSG_320 = 12145
ER_IB_MSG_321 = 12146
ER_IB_MSG_322 = 12147
ER_IB_MSG_323 = 12148
ER_IB_MSG_324 = 12149
ER_IB_MSG_325 = 12150
ER_IB_MSG_326 = 12151
ER_IB_MSG_327 = 12152
ER_IB_MSG_328 = 12153
ER_IB_MSG_329 = 12154
ER_IB_MSG_330 = 12155
ER_IB_MSG_331 = 12156
ER_IB_MSG_332 = 12157
ER_IB_MSG_333 = 12158
ER_IB_MSG_334 = 12159
ER_IB_MSG_335 = 12160
ER_IB_MSG_336 = 12161
ER_IB_MSG_337 = 12162
ER_IB_MSG_338 = 12163
ER_IB_MSG_339 = 12164
ER_IB_MSG_340 = 12165
ER_IB_MSG_341 = 12166
ER_IB_MSG_342 = 12167
ER_IB_MSG_343 = 12168
ER_IB_MSG_344 = 12169
ER_IB_MSG_345 = 12170
ER_IB_MSG_346 = 12171
ER_IB_MSG_347 = 12172
ER_IB_MSG_348 = 12173
ER_IB_MSG_349 = 12174
ER_IB_MSG_350 = 12175
ER_IB_MSG_351 = 12176
ER_IB_MSG_352 = 12177
ER_IB_MSG_353 = 12178
ER_IB_MSG_354 = 12179
ER_IB_MSG_355 = 12180
ER_IB_MSG_356 = 12181
ER_IB_MSG_357 = 12182
ER_IB_MSG_358 = 12183
ER_IB_MSG_359 = 12184
ER_IB_MSG_360 = 12185
ER_IB_MSG_361 = 12186
ER_IB_MSG_362 = 12187
ER_IB_MSG_363 = 12188
ER_IB_MSG_364 = 12189
ER_IB_MSG_365 = 12190
ER_IB_MSG_366 = 12191
ER_IB_MSG_367 = 12192
ER_IB_MSG_368 = 12193
ER_IB_MSG_369 = 12194
ER_IB_MSG_370 = 12195
ER_IB_MSG_371 = 12196
ER_IB_MSG_372 = 12197
ER_IB_MSG_373 = 12198
ER_IB_MSG_374 = 12199
ER_IB_MSG_375 = 12200
ER_IB_MSG_376 = 12201
ER_IB_MSG_377 = 12202
ER_IB_MSG_378 = 12203
ER_IB_MSG_379 = 12204
ER_IB_MSG_380 = 12205
ER_IB_MSG_381 = 12206
ER_IB_MSG_382 = 12207
ER_IB_MSG_383 = 12208
ER_IB_MSG_384 = 12209
ER_IB_MSG_385 = 12210
ER_IB_MSG_386 = 12211
ER_IB_MSG_387 = 12212
ER_IB_MSG_388 = 12213
ER_IB_MSG_389 = 12214
ER_IB_MSG_390 = 12215
ER_IB_MSG_391 = 12216
ER_IB_MSG_392 = 12217
ER_IB_MSG_393 = 12218
ER_IB_MSG_394 = 12219
ER_IB_MSG_395 = 12220
ER_IB_MSG_396 = 12221
ER_IB_MSG_397 = 12222
ER_IB_MSG_398 = 12223
ER_IB_MSG_399 = 12224
ER_IB_MSG_400 = 12225
ER_IB_MSG_401 = 12226
ER_IB_MSG_402 = 12227
ER_IB_MSG_403 = 12228
ER_IB_MSG_404 = 12229
ER_IB_MSG_405 = 12230
ER_IB_MSG_406 = 12231
ER_IB_MSG_407 = 12232
ER_IB_MSG_408 = 12233
ER_IB_MSG_409 = 12234
ER_IB_MSG_410 = 12235
ER_IB_MSG_411 = 12236
ER_IB_MSG_412 = 12237
ER_IB_MSG_413 = 12238
ER_IB_MSG_414 = 12239
ER_IB_MSG_415 = 12240
ER_IB_MSG_416 = 12241
ER_IB_MSG_417 = 12242
ER_IB_MSG_418 = 12243
ER_IB_MSG_419 = 12244
ER_IB_MSG_420 = 12245
ER_IB_MSG_421 = 12246
ER_IB_MSG_422 = 12247
ER_IB_MSG_423 = 12248
ER_IB_MSG_424 = 12249
ER_IB_MSG_425 = 12250
ER_IB_MSG_426 = 12251
ER_IB_MSG_427 = 12252
ER_IB_MSG_428 = 12253
ER_IB_MSG_429 = 12254
ER_IB_MSG_430 = 12255
ER_IB_MSG_431 = 12256
ER_IB_MSG_432 = 12257
ER_IB_MSG_433 = 12258
ER_IB_MSG_434 = 12259
ER_IB_MSG_435 = 12260
ER_IB_MSG_436 = 12261
ER_IB_MSG_437 = 12262
ER_IB_MSG_438 = 12263
ER_IB_MSG_439 = 12264
ER_IB_MSG_440 = 12265
ER_IB_MSG_441 = 12266
ER_IB_MSG_442 = 12267
ER_IB_MSG_443 = 12268
ER_IB_MSG_444 = 12269
ER_IB_MSG_445 = 12270
ER_IB_MSG_446 = 12271
ER_IB_MSG_447 = 12272
ER_IB_MSG_448 = 12273
ER_IB_MSG_449 = 12274
ER_IB_MSG_450 = 12275
ER_IB_MSG_451 = 12276
ER_IB_MSG_452 = 12277
ER_IB_MSG_453 = 12278
ER_IB_MSG_454 = 12279
ER_IB_MSG_455 = 12280
ER_IB_MSG_456 = 12281
ER_IB_MSG_457 = 12282
ER_IB_MSG_458 = 12283
ER_IB_MSG_459 = 12284
ER_IB_MSG_460 = 12285
ER_IB_MSG_461 = 12286
ER_IB_MSG_462 = 12287
ER_IB_MSG_463 = 12288
ER_IB_MSG_464 = 12289
ER_IB_MSG_465 = 12290
ER_IB_MSG_466 = 12291
ER_IB_MSG_467 = 12292
ER_IB_MSG_468 = 12293
ER_IB_MSG_469 = 12294
ER_IB_MSG_470 = 12295
ER_IB_MSG_471 = 12296
ER_IB_MSG_472 = 12297
ER_IB_MSG_473 = 12298
ER_IB_MSG_474 = 12299
ER_IB_MSG_475 = 12300
ER_IB_MSG_476 = 12301
ER_IB_MSG_477 = 12302
ER_IB_MSG_478 = 12303
ER_IB_MSG_479 = 12304
ER_IB_MSG_480 = 12305
ER_IB_MSG_481 = 12306
ER_IB_MSG_482 = 12307
ER_IB_MSG_483 = 12308
ER_IB_MSG_484 = 12309
ER_IB_MSG_485 = 12310
ER_IB_MSG_486 = 12311
ER_IB_MSG_487 = 12312
ER_IB_MSG_488 = 12313
ER_IB_MSG_489 = 12314
ER_IB_MSG_490 = 12315
ER_IB_MSG_491 = 12316
ER_IB_MSG_492 = 12317
ER_IB_MSG_493 = 12318
ER_IB_MSG_494 = 12319
ER_IB_MSG_495 = 12320
ER_IB_MSG_496 = 12321
ER_IB_MSG_497 = 12322
ER_IB_MSG_498 = 12323
ER_IB_MSG_499 = 12324
ER_IB_MSG_500 = 12325
ER_IB_MSG_501 = 12326
ER_IB_MSG_502 = 12327
ER_IB_MSG_503 = 12328
ER_IB_MSG_504 = 12329
ER_IB_MSG_505 = 12330
ER_IB_MSG_506 = 12331
ER_IB_MSG_507 = 12332
ER_IB_MSG_508 = 12333
ER_IB_MSG_509 = 12334
ER_IB_MSG_510 = 12335
ER_IB_MSG_511 = 12336
ER_IB_MSG_512 = 12337
ER_IB_MSG_513 = 12338
ER_IB_MSG_514 = 12339
ER_IB_MSG_515 = 12340
ER_IB_MSG_516 = 12341
ER_IB_MSG_517 = 12342
ER_IB_MSG_518 = 12343
ER_IB_MSG_519 = 12344
ER_IB_MSG_520 = 12345
ER_IB_MSG_521 = 12346
ER_IB_MSG_522 = 12347
ER_IB_MSG_523 = 12348
ER_IB_MSG_524 = 12349
ER_IB_MSG_525 = 12350
ER_IB_MSG_526 = 12351
ER_IB_MSG_527 = 12352
ER_IB_MSG_528 = 12353
ER_IB_MSG_529 = 12354
ER_IB_MSG_530 = 12355
ER_IB_MSG_531 = 12356
ER_IB_MSG_532 = 12357
ER_IB_MSG_533 = 12358
ER_IB_MSG_534 = 12359
ER_IB_MSG_535 = 12360
ER_IB_MSG_536 = 12361
ER_IB_MSG_537 = 12362
ER_IB_MSG_538 = 12363
ER_IB_MSG_539 = 12364
ER_IB_MSG_540 = 12365
ER_IB_MSG_541 = 12366
ER_IB_MSG_542 = 12367
ER_IB_MSG_543 = 12368
ER_IB_MSG_544 = 12369
ER_IB_MSG_545 = 12370
ER_IB_MSG_546 = 12371
ER_IB_MSG_547 = 12372
ER_IB_MSG_548 = 12373
ER_IB_MSG_549 = 12374
ER_IB_MSG_550 = 12375
ER_IB_MSG_551 = 12376
ER_IB_MSG_552 = 12377
ER_IB_MSG_553 = 12378
ER_IB_MSG_554 = 12379
ER_IB_MSG_555 = 12380
ER_IB_MSG_556 = 12381
ER_IB_MSG_557 = 12382
ER_IB_MSG_558 = 12383
ER_IB_MSG_559 = 12384
ER_IB_MSG_560 = 12385
ER_IB_MSG_561 = 12386
ER_IB_MSG_562 = 12387
ER_IB_MSG_563 = 12388
ER_IB_MSG_564 = 12389
ER_IB_MSG_565 = 12390
ER_IB_MSG_566 = 12391
ER_IB_MSG_567 = 12392
ER_IB_MSG_568 = 12393
ER_IB_MSG_569 = 12394
ER_IB_MSG_570 = 12395
ER_IB_MSG_571 = 12396
ER_IB_MSG_572 = 12397
ER_IB_MSG_573 = 12398
ER_IB_MSG_574 = 12399
ER_IB_MSG_575 = 12400
ER_IB_MSG_576 = 12401
ER_IB_MSG_577 = 12402
ER_IB_MSG_578 = 12403
ER_IB_MSG_579 = 12404
ER_IB_MSG_580 = 12405
ER_IB_MSG_581 = 12406
ER_IB_MSG_582 = 12407
ER_IB_MSG_583 = 12408
ER_IB_MSG_584 = 12409
ER_IB_MSG_585 = 12410
ER_IB_MSG_586 = 12411
ER_IB_MSG_587 = 12412
ER_IB_MSG_588 = 12413
ER_IB_MSG_589 = 12414
ER_IB_MSG_590 = 12415
ER_IB_MSG_591 = 12416
ER_IB_MSG_592 = 12417
ER_IB_MSG_593 = 12418
ER_IB_MSG_594 = 12419
ER_IB_MSG_595 = 12420
ER_IB_MSG_596 = 12421
ER_IB_MSG_597 = 12422
ER_IB_MSG_598 = 12423
ER_IB_MSG_599 = 12424
ER_IB_MSG_600 = 12425
ER_IB_MSG_601 = 12426
ER_IB_MSG_602 = 12427
ER_IB_MSG_603 = 12428
ER_IB_MSG_604 = 12429
ER_IB_MSG_605 = 12430
ER_IB_MSG_606 = 12431
ER_IB_MSG_607 = 12432
ER_IB_MSG_608 = 12433
ER_IB_MSG_609 = 12434
ER_IB_MSG_610 = 12435
ER_IB_MSG_611 = 12436
ER_IB_MSG_612 = 12437
ER_IB_MSG_613 = 12438
ER_IB_MSG_614 = 12439
ER_IB_MSG_615 = 12440
ER_IB_MSG_616 = 12441
ER_IB_MSG_617 = 12442
ER_IB_MSG_618 = 12443
ER_IB_MSG_619 = 12444
ER_IB_MSG_620 = 12445
ER_IB_MSG_621 = 12446
ER_IB_MSG_622 = 12447
ER_IB_MSG_623 = 12448
ER_IB_MSG_624 = 12449
ER_IB_MSG_625 = 12450
ER_IB_MSG_626 = 12451
ER_IB_MSG_627 = 12452
ER_IB_MSG_628 = 12453
ER_IB_MSG_629 = 12454
ER_IB_MSG_630 = 12455
ER_IB_MSG_631 = 12456
ER_IB_MSG_632 = 12457
ER_IB_MSG_633 = 12458
ER_IB_MSG_634 = 12459
ER_IB_MSG_635 = 12460
ER_IB_MSG_636 = 12461
ER_IB_MSG_637 = 12462
ER_IB_MSG_638 = 12463
ER_IB_MSG_639 = 12464
ER_IB_MSG_640 = 12465
ER_IB_MSG_641 = 12466
ER_IB_MSG_642 = 12467
ER_IB_MSG_643 = 12468
ER_IB_MSG_644 = 12469
ER_IB_MSG_645 = 12470
ER_IB_MSG_646 = 12471
ER_IB_MSG_647 = 12472
ER_IB_MSG_648 = 12473
ER_IB_MSG_649 = 12474
ER_IB_MSG_650 = 12475
ER_IB_MSG_651 = 12476
ER_IB_MSG_652 = 12477
ER_IB_MSG_653 = 12478
ER_IB_MSG_654 = 12479
ER_IB_MSG_655 = 12480
ER_IB_MSG_656 = 12481
ER_IB_MSG_657 = 12482
ER_IB_MSG_658 = 12483
ER_IB_MSG_659 = 12484
ER_IB_MSG_660 = 12485
ER_IB_MSG_661 = 12486
ER_IB_MSG_662 = 12487
ER_IB_MSG_663 = 12488
ER_IB_MSG_664 = 12489
ER_IB_MSG_665 = 12490
ER_IB_MSG_666 = 12491
ER_IB_MSG_667 = 12492
ER_IB_MSG_668 = 12493
ER_IB_MSG_669 = 12494
ER_IB_MSG_670 = 12495
ER_IB_MSG_671 = 12496
ER_IB_MSG_672 = 12497
ER_IB_MSG_673 = 12498
ER_IB_MSG_674 = 12499
ER_IB_MSG_675 = 12500
ER_IB_MSG_676 = 12501
ER_IB_MSG_677 = 12502
ER_IB_MSG_678 = 12503
ER_IB_MSG_679 = 12504
ER_IB_MSG_680 = 12505
ER_IB_MSG_681 = 12506
ER_IB_MSG_682 = 12507
ER_IB_MSG_683 = 12508
ER_IB_MSG_684 = 12509
ER_IB_MSG_685 = 12510
ER_IB_MSG_686 = 12511
ER_IB_MSG_687 = 12512
ER_IB_MSG_688 = 12513
ER_IB_MSG_689 = 12514
ER_IB_MSG_690 = 12515
ER_IB_MSG_691 = 12516
ER_IB_MSG_692 = 12517
ER_IB_MSG_693 = 12518
ER_IB_MSG_694 = 12519
ER_IB_MSG_695 = 12520
ER_IB_MSG_696 = 12521
ER_IB_MSG_697 = 12522
ER_IB_MSG_698 = 12523
ER_IB_MSG_699 = 12524
ER_IB_MSG_700 = 12525
ER_IB_MSG_701 = 12526
ER_IB_MSG_702 = 12527
ER_IB_MSG_703 = 12528
ER_IB_MSG_704 = 12529
ER_IB_MSG_705 = 12530
ER_IB_MSG_706 = 12531
ER_IB_MSG_707 = 12532
ER_IB_MSG_708 = 12533
ER_IB_MSG_709 = 12534
ER_IB_MSG_710 = 12535
ER_IB_MSG_711 = 12536
ER_IB_MSG_712 = 12537
ER_IB_MSG_713 = 12538
ER_IB_MSG_714 = 12539
ER_IB_MSG_715 = 12540
ER_IB_MSG_716 = 12541
ER_IB_MSG_717 = 12542
ER_IB_MSG_718 = 12543
ER_IB_MSG_719 = 12544
ER_IB_MSG_720 = 12545
ER_IB_MSG_721 = 12546
ER_IB_MSG_722 = 12547
ER_IB_MSG_723 = 12548
ER_IB_MSG_724 = 12549
ER_IB_MSG_725 = 12550
ER_IB_MSG_726 = 12551
ER_IB_MSG_727 = 12552
ER_IB_MSG_728 = 12553
ER_IB_MSG_729 = 12554
ER_IB_MSG_730 = 12555
ER_IB_MSG_731 = 12556
ER_IB_MSG_732 = 12557
ER_IB_MSG_733 = 12558
ER_IB_MSG_734 = 12559
ER_IB_MSG_735 = 12560
ER_IB_MSG_736 = 12561
ER_IB_MSG_737 = 12562
ER_IB_MSG_738 = 12563
ER_IB_MSG_739 = 12564
ER_IB_MSG_740 = 12565
ER_IB_MSG_741 = 12566
ER_IB_MSG_742 = 12567
ER_IB_MSG_743 = 12568
ER_IB_MSG_744 = 12569
ER_IB_MSG_745 = 12570
ER_IB_MSG_746 = 12571
ER_IB_MSG_747 = 12572
ER_IB_MSG_748 = 12573
ER_IB_MSG_749 = 12574
ER_IB_MSG_750 = 12575
ER_IB_MSG_751 = 12576
ER_IB_MSG_752 = 12577
ER_IB_MSG_753 = 12578
ER_IB_MSG_754 = 12579
ER_IB_MSG_755 = 12580
ER_IB_MSG_756 = 12581
ER_IB_MSG_757 = 12582
ER_IB_MSG_758 = 12583
ER_IB_MSG_759 = 12584
ER_IB_MSG_760 = 12585
ER_IB_MSG_761 = 12586
ER_IB_MSG_762 = 12587
ER_IB_MSG_763 = 12588
ER_IB_MSG_764 = 12589
ER_IB_MSG_765 = 12590
ER_IB_MSG_766 = 12591
ER_IB_MSG_767 = 12592
ER_IB_MSG_768 = 12593
ER_IB_MSG_769 = 12594
ER_IB_MSG_770 = 12595
ER_IB_MSG_771 = 12596
ER_IB_MSG_772 = 12597
ER_IB_MSG_773 = 12598
ER_IB_MSG_774 = 12599
ER_IB_MSG_775 = 12600
ER_IB_MSG_776 = 12601
ER_IB_MSG_777 = 12602
ER_IB_MSG_778 = 12603
ER_IB_MSG_779 = 12604
ER_IB_MSG_780 = 12605
ER_IB_MSG_781 = 12606
ER_IB_MSG_782 = 12607
ER_IB_MSG_783 = 12608
ER_IB_MSG_784 = 12609
ER_IB_MSG_785 = 12610
ER_IB_MSG_786 = 12611
ER_IB_MSG_787 = 12612
ER_IB_MSG_788 = 12613
ER_IB_MSG_789 = 12614
ER_IB_MSG_790 = 12615
ER_IB_MSG_791 = 12616
ER_IB_MSG_792 = 12617
ER_IB_MSG_793 = 12618
ER_IB_MSG_794 = 12619
ER_IB_MSG_795 = 12620
ER_IB_MSG_796 = 12621
ER_IB_MSG_797 = 12622
ER_IB_MSG_798 = 12623
ER_IB_MSG_799 = 12624
ER_IB_MSG_800 = 12625
ER_IB_MSG_801 = 12626
ER_IB_MSG_802 = 12627
ER_IB_MSG_803 = 12628
ER_IB_MSG_804 = 12629
ER_IB_MSG_805 = 12630
ER_IB_MSG_806 = 12631
ER_IB_MSG_807 = 12632
ER_IB_MSG_808 = 12633
ER_IB_MSG_809 = 12634
ER_IB_MSG_810 = 12635
ER_IB_MSG_811 = 12636
ER_IB_MSG_812 = 12637
ER_IB_MSG_813 = 12638
ER_IB_MSG_814 = 12639
ER_IB_MSG_815 = 12640
ER_IB_MSG_816 = 12641
ER_IB_MSG_817 = 12642
ER_IB_MSG_818 = 12643
ER_IB_MSG_819 = 12644
ER_IB_MSG_820 = 12645
ER_IB_MSG_821 = 12646
ER_IB_MSG_822 = 12647
ER_IB_MSG_823 = 12648
ER_IB_MSG_824 = 12649
ER_IB_MSG_825 = 12650
ER_IB_MSG_826 = 12651
ER_IB_MSG_827 = 12652
ER_IB_MSG_828 = 12653
ER_IB_MSG_829 = 12654
ER_IB_MSG_830 = 12655
ER_IB_MSG_831 = 12656
ER_IB_MSG_832 = 12657
ER_IB_MSG_833 = 12658
ER_IB_MSG_834 = 12659
ER_IB_MSG_835 = 12660
ER_IB_MSG_836 = 12661
ER_IB_MSG_837 = 12662
ER_IB_MSG_838 = 12663
ER_IB_MSG_839 = 12664
ER_IB_MSG_840 = 12665
ER_IB_MSG_841 = 12666
ER_IB_MSG_842 = 12667
ER_IB_MSG_843 = 12668
ER_IB_MSG_844 = 12669
ER_IB_MSG_845 = 12670
ER_IB_MSG_846 = 12671
ER_IB_MSG_847 = 12672
ER_IB_MSG_848 = 12673
ER_IB_MSG_849 = 12674
ER_IB_MSG_850 = 12675
ER_IB_MSG_851 = 12676
ER_IB_MSG_852 = 12677
ER_IB_MSG_853 = 12678
ER_IB_MSG_854 = 12679
ER_IB_MSG_855 = 12680
ER_IB_MSG_856 = 12681
ER_IB_MSG_857 = 12682
ER_IB_MSG_858 = 12683
ER_IB_MSG_859 = 12684
ER_IB_MSG_860 = 12685
ER_IB_MSG_861 = 12686
ER_IB_MSG_862 = 12687
ER_IB_MSG_863 = 12688
ER_IB_MSG_864 = 12689
ER_IB_MSG_865 = 12690
ER_IB_MSG_866 = 12691
ER_IB_MSG_867 = 12692
ER_IB_MSG_868 = 12693
ER_IB_MSG_869 = 12694
ER_IB_MSG_870 = 12695
ER_IB_MSG_871 = 12696
ER_IB_MSG_872 = 12697
ER_IB_MSG_873 = 12698
ER_IB_MSG_874 = 12699
ER_IB_MSG_875 = 12700
ER_IB_MSG_876 = 12701
ER_IB_MSG_877 = 12702
ER_IB_MSG_878 = 12703
ER_IB_MSG_879 = 12704
ER_IB_MSG_880 = 12705
ER_IB_MSG_881 = 12706
ER_IB_MSG_882 = 12707
ER_IB_MSG_883 = 12708
ER_IB_MSG_884 = 12709
ER_IB_MSG_885 = 12710
ER_IB_MSG_886 = 12711
ER_IB_MSG_887 = 12712
ER_IB_MSG_888 = 12713
ER_IB_MSG_889 = 12714
ER_IB_MSG_890 = 12715
ER_IB_MSG_891 = 12716
ER_IB_MSG_892 = 12717
ER_IB_MSG_893 = 12718
ER_IB_MSG_894 = 12719
ER_IB_MSG_895 = 12720
ER_IB_MSG_896 = 12721
ER_IB_MSG_897 = 12722
ER_IB_MSG_898 = 12723
ER_IB_MSG_899 = 12724
ER_IB_MSG_900 = 12725
ER_IB_MSG_901 = 12726
ER_IB_MSG_902 = 12727
ER_IB_MSG_903 = 12728
ER_IB_MSG_904 = 12729
ER_IB_MSG_905 = 12730
ER_IB_MSG_906 = 12731
ER_IB_MSG_907 = 12732
ER_IB_MSG_908 = 12733
ER_IB_MSG_909 = 12734
ER_IB_MSG_910 = 12735
ER_IB_MSG_911 = 12736
ER_IB_MSG_912 = 12737
ER_IB_MSG_913 = 12738
ER_IB_MSG_914 = 12739
ER_IB_MSG_915 = 12740
ER_IB_MSG_916 = 12741
ER_IB_MSG_917 = 12742
ER_IB_MSG_918 = 12743
ER_IB_MSG_919 = 12744
ER_IB_MSG_920 = 12745
ER_IB_MSG_921 = 12746
ER_IB_MSG_922 = 12747
ER_IB_MSG_923 = 12748
ER_IB_MSG_924 = 12749
ER_IB_MSG_925 = 12750
ER_IB_MSG_926 = 12751
ER_IB_MSG_927 = 12752
ER_IB_MSG_928 = 12753
ER_IB_MSG_929 = 12754
ER_IB_MSG_930 = 12755
ER_IB_MSG_931 = 12756
ER_IB_MSG_932 = 12757
ER_IB_MSG_933 = 12758
ER_IB_MSG_934 = 12759
ER_IB_MSG_935 = 12760
ER_IB_MSG_936 = 12761
ER_IB_MSG_937 = 12762
ER_IB_MSG_938 = 12763
ER_IB_MSG_939 = 12764
ER_IB_MSG_940 = 12765
ER_IB_MSG_941 = 12766
ER_IB_MSG_942 = 12767
ER_IB_MSG_943 = 12768
ER_IB_MSG_944 = 12769
ER_IB_MSG_945 = 12770
ER_IB_MSG_946 = 12771
ER_IB_MSG_947 = 12772
ER_IB_MSG_948 = 12773
ER_IB_MSG_949 = 12774
ER_IB_MSG_950 = 12775
ER_IB_MSG_951 = 12776
ER_IB_MSG_952 = 12777
ER_IB_MSG_953 = 12778
ER_IB_MSG_954 = 12779
ER_IB_MSG_955 = 12780
ER_IB_MSG_956 = 12781
ER_IB_MSG_957 = 12782
ER_IB_MSG_958 = 12783
ER_IB_MSG_959 = 12784
ER_IB_MSG_960 = 12785
ER_IB_MSG_961 = 12786
ER_IB_MSG_962 = 12787
ER_IB_MSG_963 = 12788
ER_IB_MSG_964 = 12789
ER_IB_MSG_965 = 12790
ER_IB_MSG_966 = 12791
ER_IB_MSG_967 = 12792
ER_IB_MSG_968 = 12793
ER_IB_MSG_969 = 12794
ER_IB_MSG_970 = 12795
ER_IB_MSG_971 = 12796
ER_IB_MSG_972 = 12797
ER_IB_MSG_973 = 12798
ER_IB_MSG_974 = 12799
ER_IB_MSG_975 = 12800
ER_IB_MSG_976 = 12801
ER_IB_MSG_977 = 12802
ER_IB_MSG_978 = 12803
ER_IB_MSG_979 = 12804
ER_IB_MSG_980 = 12805
ER_IB_MSG_981 = 12806
ER_IB_MSG_982 = 12807
ER_IB_MSG_983 = 12808
ER_IB_MSG_984 = 12809
ER_IB_MSG_985 = 12810
ER_IB_MSG_986 = 12811
ER_IB_MSG_987 = 12812
ER_IB_MSG_988 = 12813
ER_IB_MSG_989 = 12814
ER_IB_MSG_990 = 12815
ER_IB_MSG_991 = 12816
ER_IB_MSG_992 = 12817
ER_IB_MSG_993 = 12818
ER_IB_MSG_994 = 12819
ER_IB_MSG_995 = 12820
ER_IB_MSG_996 = 12821
ER_IB_MSG_997 = 12822
ER_IB_MSG_998 = 12823
ER_IB_MSG_999 = 12824
ER_IB_MSG_1000 = 12825
ER_IB_MSG_1001 = 12826
ER_IB_MSG_1002 = 12827
ER_IB_MSG_1003 = 12828
ER_IB_MSG_1004 = 12829
ER_IB_MSG_1005 = 12830
ER_IB_MSG_1006 = 12831
ER_IB_MSG_1007 = 12832
ER_IB_MSG_1008 = 12833
ER_IB_MSG_1009 = 12834
ER_IB_MSG_1010 = 12835
ER_IB_MSG_1011 = 12836
ER_IB_MSG_1012 = 12837
ER_IB_MSG_1013 = 12838
ER_IB_MSG_1014 = 12839
ER_IB_MSG_1015 = 12840
ER_IB_MSG_1016 = 12841
ER_IB_MSG_1017 = 12842
ER_IB_MSG_1018 = 12843
ER_IB_MSG_1019 = 12844
ER_IB_MSG_1020 = 12845
ER_IB_MSG_1021 = 12846
ER_IB_MSG_1022 = 12847
ER_IB_MSG_1023 = 12848
ER_IB_MSG_1024 = 12849
ER_IB_MSG_1025 = 12850
ER_IB_MSG_1026 = 12851
ER_IB_MSG_1027 = 12852
ER_IB_MSG_1028 = 12853
ER_IB_MSG_1029 = 12854
ER_IB_MSG_1030 = 12855
ER_IB_MSG_1031 = 12856
ER_IB_MSG_1032 = 12857
ER_IB_MSG_1033 = 12858
ER_IB_MSG_1034 = 12859
ER_IB_MSG_1035 = 12860
ER_IB_MSG_1036 = 12861
ER_IB_MSG_1037 = 12862
ER_IB_MSG_1038 = 12863
ER_IB_MSG_1039 = 12864
ER_IB_MSG_1040 = 12865
ER_IB_MSG_1041 = 12866
ER_IB_MSG_1042 = 12867
ER_IB_MSG_1043 = 12868
ER_IB_MSG_1044 = 12869
ER_IB_MSG_1045 = 12870
ER_IB_MSG_1046 = 12871
ER_IB_MSG_1047 = 12872
ER_IB_MSG_1048 = 12873
ER_IB_MSG_1049 = 12874
ER_IB_MSG_1050 = 12875
ER_IB_MSG_1051 = 12876
ER_IB_MSG_1052 = 12877
ER_IB_MSG_1053 = 12878
ER_IB_MSG_1054 = 12879
ER_IB_MSG_1055 = 12880
ER_IB_MSG_1056 = 12881
ER_IB_MSG_1057 = 12882
ER_IB_MSG_1058 = 12883
ER_IB_MSG_1059 = 12884
ER_IB_MSG_1060 = 12885
ER_IB_MSG_1061 = 12886
ER_IB_MSG_1062 = 12887
ER_IB_MSG_1063 = 12888
ER_IB_MSG_1064 = 12889
ER_IB_MSG_1065 = 12890
ER_IB_MSG_1066 = 12891
ER_IB_MSG_1067 = 12892
ER_IB_MSG_1068 = 12893
ER_IB_MSG_1069 = 12894
ER_IB_MSG_1070 = 12895
ER_IB_MSG_1071 = 12896
ER_IB_MSG_1072 = 12897
ER_IB_MSG_1073 = 12898
ER_IB_MSG_1074 = 12899
ER_IB_MSG_1075 = 12900
ER_IB_MSG_1076 = 12901
ER_IB_MSG_1077 = 12902
ER_IB_MSG_1078 = 12903
ER_IB_MSG_1079 = 12904
ER_IB_MSG_1080 = 12905
ER_IB_MSG_1081 = 12906
ER_IB_MSG_1082 = 12907
ER_IB_MSG_1083 = 12908
ER_IB_MSG_1084 = 12909
ER_IB_MSG_1085 = 12910
ER_IB_MSG_1086 = 12911
ER_IB_MSG_1087 = 12912
ER_IB_MSG_1088 = 12913
ER_IB_MSG_1089 = 12914
ER_IB_MSG_1090 = 12915
ER_IB_MSG_1091 = 12916
ER_IB_MSG_1092 = 12917
ER_IB_MSG_1093 = 12918
ER_IB_MSG_1094 = 12919
ER_IB_MSG_1095 = 12920
ER_IB_MSG_1096 = 12921
ER_IB_MSG_1097 = 12922
ER_IB_MSG_1098 = 12923
ER_IB_MSG_1099 = 12924
ER_IB_MSG_1100 = 12925
ER_IB_MSG_1101 = 12926
ER_IB_MSG_1102 = 12927
ER_IB_MSG_1103 = 12928
ER_IB_MSG_1104 = 12929
ER_IB_MSG_1105 = 12930
ER_IB_MSG_1106 = 12931
ER_IB_MSG_1107 = 12932
ER_IB_MSG_1108 = 12933
ER_IB_MSG_1109 = 12934
ER_IB_MSG_1110 = 12935
ER_IB_MSG_1111 = 12936
ER_IB_MSG_1112 = 12937
ER_IB_MSG_1113 = 12938
ER_IB_MSG_1114 = 12939
ER_IB_MSG_1115 = 12940
ER_IB_MSG_1116 = 12941
ER_IB_MSG_1117 = 12942
ER_IB_MSG_1118 = 12943
ER_IB_MSG_1119 = 12944
ER_IB_MSG_1120 = 12945
ER_IB_MSG_1121 = 12946
ER_IB_MSG_1122 = 12947
ER_IB_MSG_1123 = 12948
ER_IB_MSG_1124 = 12949
ER_IB_MSG_1125 = 12950
ER_IB_MSG_1126 = 12951
ER_IB_MSG_1127 = 12952
ER_IB_MSG_1128 = 12953
ER_IB_MSG_1129 = 12954
ER_IB_MSG_1130 = 12955
ER_IB_MSG_1131 = 12956
ER_IB_MSG_1132 = 12957
ER_IB_MSG_1133 = 12958
ER_IB_MSG_1134 = 12959
ER_IB_MSG_1135 = 12960
ER_IB_MSG_1136 = 12961
ER_IB_MSG_1137 = 12962
ER_IB_MSG_1138 = 12963
ER_IB_MSG_1139 = 12964
ER_IB_MSG_1140 = 12965
ER_IB_MSG_1141 = 12966
ER_IB_MSG_1142 = 12967
ER_IB_MSG_1143 = 12968
ER_IB_MSG_1144 = 12969
ER_IB_MSG_1145 = 12970
ER_IB_MSG_1146 = 12971
ER_IB_MSG_1147 = 12972
ER_IB_MSG_1148 = 12973
ER_IB_MSG_1149 = 12974
ER_IB_MSG_1150 = 12975
ER_IB_MSG_1151 = 12976
ER_IB_MSG_1152 = 12977
ER_IB_MSG_1153 = 12978
ER_IB_MSG_1154 = 12979
ER_IB_MSG_1155 = 12980
ER_IB_MSG_1156 = 12981
ER_IB_MSG_1157 = 12982
ER_IB_MSG_1158 = 12983
ER_IB_MSG_1159 = 12984
ER_IB_MSG_1160 = 12985
ER_IB_MSG_1161 = 12986
ER_IB_MSG_1162 = 12987
ER_IB_MSG_1163 = 12988
ER_IB_MSG_1164 = 12989
ER_IB_MSG_1165 = 12990
ER_IB_MSG_1166 = 12991
ER_IB_MSG_1167 = 12992
ER_IB_MSG_1168 = 12993
ER_IB_MSG_1169 = 12994
ER_IB_MSG_1170 = 12995
ER_IB_MSG_1171 = 12996
ER_IB_MSG_1172 = 12997
ER_IB_MSG_1173 = 12998
ER_IB_MSG_1174 = 12999
ER_IB_MSG_1175 = 13000
ER_IB_MSG_1176 = 13001
ER_IB_MSG_1177 = 13002
ER_IB_MSG_1178 = 13003
ER_IB_MSG_1179 = 13004
ER_IB_MSG_1180 = 13005
ER_IB_MSG_1181 = 13006
ER_IB_MSG_1182 = 13007
ER_IB_MSG_1183 = 13008
ER_IB_MSG_1184 = 13009
ER_IB_MSG_1185 = 13010
ER_IB_MSG_1186 = 13011
ER_IB_MSG_1187 = 13012
ER_IB_MSG_1188 = 13013
ER_IB_MSG_1189 = 13014
ER_IB_MSG_1190 = 13015
ER_IB_MSG_1191 = 13016
ER_IB_MSG_1192 = 13017
ER_IB_MSG_1193 = 13018
ER_IB_MSG_1194 = 13019
ER_IB_MSG_1195 = 13020
ER_IB_MSG_1196 = 13021
ER_IB_MSG_1197 = 13022
ER_IB_MSG_1198 = 13023
ER_IB_MSG_1199 = 13024
ER_IB_MSG_1200 = 13025
ER_IB_MSG_1201 = 13026
ER_IB_MSG_1202 = 13027
ER_IB_MSG_1203 = 13028
ER_IB_MSG_1204 = 13029
ER_IB_MSG_1205 = 13030
ER_IB_MSG_1206 = 13031
ER_IB_MSG_1207 = 13032
ER_IB_MSG_1208 = 13033
ER_IB_MSG_1209 = 13034
ER_IB_MSG_1210 = 13035
ER_IB_MSG_1211 = 13036
ER_IB_MSG_1212 = 13037
ER_IB_MSG_1213 = 13038
ER_IB_MSG_1214 = 13039
ER_IB_MSG_1215 = 13040
ER_IB_MSG_1216 = 13041
ER_IB_MSG_1217 = 13042
ER_IB_MSG_1218 = 13043
ER_IB_MSG_1219 = 13044
ER_IB_MSG_1220 = 13045
ER_IB_MSG_1221 = 13046
ER_IB_MSG_1222 = 13047
ER_IB_MSG_1223 = 13048
ER_IB_MSG_1224 = 13049
ER_IB_MSG_1225 = 13050
ER_IB_MSG_1226 = 13051
ER_IB_MSG_1227 = 13052
ER_IB_MSG_1228 = 13053
ER_IB_MSG_1229 = 13054
ER_IB_MSG_1230 = 13055
ER_IB_MSG_1231 = 13056
ER_IB_MSG_1232 = 13057
ER_IB_MSG_1233 = 13058
ER_IB_MSG_1234 = 13059
ER_IB_MSG_1235 = 13060
ER_IB_MSG_1236 = 13061
ER_IB_MSG_1237 = 13062
ER_IB_MSG_1238 = 13063
ER_IB_MSG_1239 = 13064
ER_IB_MSG_1240 = 13065
ER_IB_MSG_1241 = 13066
ER_IB_MSG_1242 = 13067
ER_IB_MSG_1243 = 13068
ER_IB_MSG_1244 = 13069
ER_IB_MSG_1245 = 13070
ER_IB_MSG_1246 = 13071
ER_IB_MSG_1247 = 13072
ER_IB_MSG_1248 = 13073
ER_IB_MSG_1249 = 13074
ER_IB_MSG_1250 = 13075
ER_IB_MSG_1251 = 13076
ER_IB_MSG_1252 = 13077
ER_IB_MSG_1253 = 13078
ER_IB_MSG_1254 = 13079
ER_IB_MSG_1255 = 13080
ER_IB_MSG_1256 = 13081
ER_IB_MSG_1257 = 13082
ER_IB_MSG_1258 = 13083
ER_IB_MSG_1259 = 13084
ER_IB_MSG_1260 = 13085
ER_IB_MSG_1261 = 13086
ER_IB_MSG_1262 = 13087
ER_IB_MSG_1263 = 13088
ER_IB_MSG_1264 = 13089
ER_IB_MSG_1265 = 13090
ER_IB_MSG_1266 = 13091
ER_IB_MSG_1267 = 13092
ER_IB_MSG_1268 = 13093
ER_IB_MSG_1269 = 13094
ER_IB_MSG_1270 = 13095
OBSOLETE_ER_RPL_SLAVE_SQL_THREAD_STOP_CMD_EXEC_TIMEOUT = 13096
OBSOLETE_ER_RPL_SLAVE_IO_THREAD_STOP_CMD_EXEC_TIMEOUT = 13097
ER_RPL_REPLICA_SQL_THREAD_STOP_CMD_EXEC_TIMEOUT = 13096
ER_RPL_REPLICA_IO_THREAD_STOP_CMD_EXEC_TIMEOUT = 13097
ER_RPL_GTID_UNSAFE_STMT_ON_NON_TRANS_TABLE = 13098
ER_RPL_GTID_UNSAFE_STMT_CREATE_SELECT = 13099
ER_RPL_GTID_UNSAFE_STMT_ON_TEMPORARY_TABLE = 13100
ER_BINLOG_ROW_VALUE_OPTION_IGNORED = 13101
ER_BINLOG_USE_V1_ROW_EVENTS_IGNORED = 13102
ER_BINLOG_ROW_VALUE_OPTION_USED_ONLY_FOR_AFTER_IMAGES = 13103
ER_CONNECTION_ABORTED = 13104
ER_NORMAL_SERVER_SHUTDOWN = 13105
ER_KEYRING_MIGRATE_FAILED = 13106
ER_GRP_RPL_LOWER_CASE_TABLE_NAMES_DIFF_FROM_GRP = 13107
ER_OOM_SAVE_GTIDS = 13108
ER_LCTN_NOT_FOUND = 13109
ER_REGEXP_INVALID_CAPTURE_GROUP_NAME = 13110
ER_COMPONENT_FILTER_WRONG_VALUE = 13111
ER_XPLUGIN_FAILED_TO_STOP_SERVICES = 13112
ER_INCONSISTENT_ERROR = 13113
OBSOLETE_ER_SERVER_MASTER_FATAL_ERROR_READING_BINLOG = 13114
ER_SERVER_SOURCE_FATAL_ERROR_READING_BINLOG = 13114
ER_NETWORK_READ_EVENT_CHECKSUM_FAILURE = 13115
OBSOLETE_ER_SLAVE_CREATE_EVENT_FAILURE = 13116
OBSOLETE_ER_SLAVE_FATAL_ERROR = 13117
OBSOLETE_ER_SLAVE_HEARTBEAT_FAILURE = 13118
OBSOLETE_ER_SLAVE_INCIDENT = 13119
OBSOLETE_ER_SLAVE_MASTER_COM_FAILURE = 13120
OBSOLETE_ER_SLAVE_RELAY_LOG_READ_FAILURE = 13121
OBSOLETE_ER_SLAVE_RELAY_LOG_WRITE_FAILURE = 13122
OBSOLETE_ER_SERVER_SLAVE_MI_INIT_REPOSITORY = 13123
OBSOLETE_ER_SERVER_SLAVE_RLI_INIT_REPOSITORY = 13124
ER_REPLICA_CREATE_EVENT_FAILURE = 13116
ER_REPLICA_FATAL_ERROR = 13117
ER_REPLICA_HEARTBEAT_FAILURE = 13118
ER_REPLICA_INCIDENT = 13119
ER_REPLICA_SOURCE_COM_FAILURE = 13120
ER_REPLICA_RELAY_LOG_READ_FAILURE = 13121
ER_REPLICA_RELAY_LOG_WRITE_FAILURE = 13122
ER_SERVER_REPLICA_MI_INIT_REPOSITORY = 13123
ER_SERVER_REPLICA_RLI_INIT_REPOSITORY = 13124
ER_SERVER_NET_PACKET_TOO_LARGE = 13125
ER_SERVER_NO_SYSTEM_TABLE_ACCESS = 13126
ER_SERVER_UNKNOWN_ERROR = 13127
ER_SERVER_UNKNOWN_SYSTEM_VARIABLE = 13128
ER_SERVER_NO_SESSION_TO_SEND_TO = 13129
ER_SERVER_NEW_ABORTING_CONNECTION = 13130
ER_SERVER_OUT_OF_SORTMEMORY = 13131
ER_SERVER_RECORD_FILE_FULL = 13132
ER_SERVER_DISK_FULL_NOWAIT = 13133
ER_SERVER_HANDLER_ERROR = 13134
ER_SERVER_NOT_FORM_FILE = 13135
ER_SERVER_CANT_OPEN_FILE = 13136
ER_SERVER_FILE_NOT_FOUND = 13137
ER_SERVER_FILE_USED = 13138
ER_SERVER_CANNOT_LOAD_FROM_TABLE_V2 = 13139
ER_ERROR_INFO_FROM_DA = 13140
ER_SERVER_TABLE_CHECK_FAILED = 13141
ER_SERVER_COL_COUNT_DOESNT_MATCH_PLEASE_UPDATE_V2 = 13142
ER_SERVER_COL_COUNT_DOESNT_MATCH_CORRUPTED_V2 = 13143
ER_SERVER_ACL_TABLE_ERROR = 13144
OBSOLETE_ER_SERVER_SLAVE_INIT_QUERY_FAILED = 13145
OBSOLETE_ER_SERVER_SLAVE_CONVERSION_FAILED = 13146
OBSOLETE_ER_SERVER_SLAVE_IGNORED_TABLE = 13147
ER_SERVER_REPLICA_INIT_QUERY_FAILED = 13145
ER_SERVER_REPLICA_CONVERSION_FAILED = 13146
ER_SERVER_REPLICA_IGNORED_TABLE = 13147
ER_CANT_REPLICATE_ANONYMOUS_WITH_AUTO_POSITION = 13148
ER_CANT_REPLICATE_ANONYMOUS_WITH_GTID_MODE_ON = 13149
ER_CANT_REPLICATE_GTID_WITH_GTID_MODE_OFF = 13150
ER_SERVER_TEST_MESSAGE = 13151
ER_AUDIT_LOG_JSON_FILTER_PARSING_ERROR = 13152
ER_AUDIT_LOG_JSON_FILTERING_NOT_ENABLED = 13153
ER_PLUGIN_FAILED_TO_OPEN_TABLES = 13154
ER_PLUGIN_FAILED_TO_OPEN_TABLE = 13155
ER_AUDIT_LOG_JSON_FILTER_NAME_CANNOT_BE_EMPTY = 13156
ER_AUDIT_LOG_USER_NAME_INVALID_CHARACTER = 13157
ER_AUDIT_LOG_UDF_INSUFFICIENT_PRIVILEGE = 13158
ER_AUDIT_LOG_NO_KEYRING_PLUGIN_INSTALLED = 13159
ER_AUDIT_LOG_HOST_NAME_INVALID_CHARACTER = 13160
ER_AUDIT_LOG_ENCRYPTION_PASSWORD_HAS_NOT_BEEN_SET = 13161
ER_AUDIT_LOG_COULD_NOT_CREATE_AES_KEY = 13162
ER_AUDIT_LOG_ENCRYPTION_PASSWORD_CANNOT_BE_FETCHED = 13163
ER_COULD_NOT_REINITIALIZE_AUDIT_LOG_FILTERS = 13164
ER_AUDIT_LOG_JSON_USER_NAME_CANNOT_BE_EMPTY = 13165
ER_AUDIT_LOG_USER_FIRST_CHARACTER_MUST_BE_ALPHANUMERIC = 13166
ER_AUDIT_LOG_JSON_FILTER_DOES_NOT_EXIST = 13167
CR_UNKNOWN_ERROR = 2000
CR_SOCKET_CREATE_ERROR = 2001
CR_CONNECTION_ERROR = 2002
CR_CONN_HOST_ERROR = 2003
CR_IPSOCK_ERROR = 2004
CR_UNKNOWN_HOST = 2005
CR_SERVER_GONE_ERROR = 2006
CR_VERSION_ERROR = 2007
CR_OUT_OF_MEMORY = 2008
CR_WRONG_HOST_INFO = 2009
CR_LOCALHOST_CONNECTION = 2010
CR_TCP_CONNECTION = 2011
CR_SERVER_HANDSHAKE_ERR = 2012
CR_SERVER_LOST = 2013
CR_COMMANDS_OUT_OF_SYNC = 2014
CR_NAMEDPIPE_CONNECTION = 2015
CR_NAMEDPIPEWAIT_ERROR = 2016
CR_NAMEDPIPEOPEN_ERROR = 2017
CR_NAMEDPIPESETSTATE_ERROR = 2018
CR_CANT_READ_CHARSET = 2019
CR_NET_PACKET_TOO_LARGE = 2020
CR_EMBEDDED_CONNECTION = 2021
OBSOLETE_CR_PROBE_SLAVE_STATUS = 2022
OBSOLETE_CR_PROBE_SLAVE_HOSTS = 2023
OBSOLETE_CR_PROBE_SLAVE_CONNECT = 2024
OBSOLETE_CR_PROBE_MASTER_CONNECT = 2025
CR_PROBE_REPLICA_STATUS = 2022
CR_PROBE_REPLICA_HOSTS = 2023
CR_PROBE_REPLICA_CONNECT = 2024
CR_PROBE_SOURCE_CONNECT = 2025
CR_SSL_CONNECTION_ERROR = 2026
CR_MALFORMED_PACKET = 2027
CR_WRONG_LICENSE = 2028
CR_NULL_POINTER = 2029
CR_NO_PREPARE_STMT = 2030
CR_PARAMS_NOT_BOUND = 2031
CR_DATA_TRUNCATED = 2032
CR_NO_PARAMETERS_EXISTS = 2033
CR_INVALID_PARAMETER_NO = 2034
CR_INVALID_BUFFER_USE = 2035
CR_UNSUPPORTED_PARAM_TYPE = 2036
CR_SHARED_MEMORY_CONNECTION = 2037
CR_SHARED_MEMORY_CONNECT_REQUEST_ERROR = 2038
CR_SHARED_MEMORY_CONNECT_ANSWER_ERROR = 2039
CR_SHARED_MEMORY_CONNECT_FILE_MAP_ERROR = 2040
CR_SHARED_MEMORY_CONNECT_MAP_ERROR = 2041
CR_SHARED_MEMORY_FILE_MAP_ERROR = 2042
CR_SHARED_MEMORY_MAP_ERROR = 2043
CR_SHARED_MEMORY_EVENT_ERROR = 2044
CR_SHARED_MEMORY_CONNECT_ABANDONED_ERROR = 2045
CR_SHARED_MEMORY_CONNECT_SET_ERROR = 2046
CR_CONN_UNKNOW_PROTOCOL = 2047
CR_INVALID_CONN_HANDLE = 2048
CR_UNUSED_1 = 2049
CR_FETCH_CANCELED = 2050
CR_NO_DATA = 2051
CR_NO_STMT_METADATA = 2052
CR_NO_RESULT_SET = 2053
CR_NOT_IMPLEMENTED = 2054
CR_SERVER_LOST_EXTENDED = 2055
CR_STMT_CLOSED = 2056
CR_NEW_STMT_METADATA = 2057
CR_ALREADY_CONNECTED = 2058
CR_AUTH_PLUGIN_CANNOT_LOAD = 2059
CR_DUPLICATE_CONNECTION_ATTR = 2060
CR_AUTH_PLUGIN_ERR = 2061
CR_INSECURE_API_ERR = 2062
CR_FILE_NAME_TOO_LONG = 2063
CR_SSL_FIPS_MODE_ERR = 2064
CR_DEPRECATED_COMPRESSION_NOT_SUPPORTED = 2065
CR_COMPRESSION_WRONGLY_CONFIGURED = 2066
CR_KERBEROS_USER_NOT_FOUND = 2067
CR_LOAD_DATA_LOCAL_INFILE_REJECTED = 2068
CR_LOAD_DATA_LOCAL_INFILE_REALPATH_FAIL = 2069
CR_DNS_SRV_LOOKUP_FAILED = 2070
# End MySQL Errors

# Start X Plugin Errors
ER_X_BAD_MESSAGE = 5000
ER_X_CAPABILITIES_PREPARE_FAILED = 5001
ER_X_CAPABILITY_NOT_FOUND = 5002
ER_X_INVALID_PROTOCOL_DATA = 5003
ER_X_BAD_CONNECTION_SESSION_ATTRIBUTE_VALUE_LENGTH = 5004
ER_X_BAD_CONNECTION_SESSION_ATTRIBUTE_KEY_LENGTH = 5005
ER_X_BAD_CONNECTION_SESSION_ATTRIBUTE_EMPTY_KEY = 5006
ER_X_BAD_CONNECTION_SESSION_ATTRIBUTE_LENGTH = 5007
ER_X_BAD_CONNECTION_SESSION_ATTRIBUTE_TYPE = 5008
ER_X_CAPABILITY_SET_NOT_ALLOWED = 5009
ER_X_SERVICE_ERROR = 5010
ER_X_SESSION = 5011
ER_X_INVALID_ARGUMENT = 5012
ER_X_MISSING_ARGUMENT = 5013
ER_X_BAD_INSERT_DATA = 5014
ER_X_CMD_NUM_ARGUMENTS = 5015
ER_X_CMD_ARGUMENT_TYPE = 5016
ER_X_CMD_ARGUMENT_VALUE = 5017
ER_X_BAD_UPSERT_DATA = 5018
ER_X_DUPLICATED_CAPABILITIES = 5019
ER_X_CMD_ARGUMENT_OBJECT_EMPTY = 5020
ER_X_CMD_INVALID_ARGUMENT = 5021
ER_X_BAD_UPDATE_DATA = 5050
ER_X_BAD_TYPE_OF_UPDATE = 5051
ER_X_BAD_COLUMN_TO_UPDATE = 5052
ER_X_BAD_MEMBER_TO_UPDATE = 5053
ER_X_BAD_STATEMENT_ID = 5110
ER_X_BAD_CURSOR_ID = 5111
ER_X_BAD_SCHEMA = 5112
ER_X_BAD_TABLE = 5113
ER_X_BAD_PROJECTION = 5114
ER_X_DOC_ID_MISSING = 5115
ER_X_DUPLICATE_ENTRY = 5116
ER_X_DOC_REQUIRED_FIELD_MISSING = 5117
ER_X_PROJ_BAD_KEY_NAME = 5120
ER_X_BAD_DOC_PATH = 5121
ER_X_CURSOR_EXISTS = 5122
ER_X_CURSOR_REACHED_EOF = 5123
ER_X_PREPARED_STATMENT_CAN_HAVE_ONE_CURSOR = 5131
ER_X_PREPARED_EXECUTE_ARGUMENT_NOT_SUPPORTED = 5133
ER_X_PREPARED_EXECUTE_ARGUMENT_CONSISTENCY = 5134
ER_X_EXPR_BAD_OPERATOR = 5150
ER_X_EXPR_BAD_NUM_ARGS = 5151
ER_X_EXPR_MISSING_ARG = 5152
ER_X_EXPR_BAD_TYPE_VALUE = 5153
ER_X_EXPR_BAD_VALUE = 5154
ER_X_INVALID_COLLECTION = 5156
ER_X_INVALID_ADMIN_COMMAND = 5157
ER_X_EXPECT_NOT_OPEN = 5158
ER_X_EXPECT_NO_ERROR_FAILED = 5159
ER_X_EXPECT_BAD_CONDITION = 5160
ER_X_EXPECT_BAD_CONDITION_VALUE = 5161
ER_X_INVALID_NAMESPACE = 5162
ER_X_BAD_NOTICE = 5163
ER_X_CANNOT_DISABLE_NOTICE = 5164
ER_X_BAD_CONFIGURATION = 5165
ER_X_MYSQLX_ACCOUNT_MISSING_PERMISSIONS = 5167
ER_X_EXPECT_FIELD_EXISTS_FAILED = 5168
ER_X_BAD_LOCKING = 5169
ER_X_FRAME_COMPRESSION_DISABLED = 5170
ER_X_DECOMPRESSION_FAILED = 5171
ER_X_BAD_COMPRESSED_FRAME = 5174
ER_X_CAPABILITY_COMPRESSION_INVALID_ALGORITHM = 5175
ER_X_CAPABILITY_COMPRESSION_INVALID_SERVER_STYLE = 5176
ER_X_CAPABILITY_COMPRESSION_INVALID_CLIENT_STYLE = 5177
ER_X_CAPABILITY_COMPRESSION_INVALID_OPTION = 5178
ER_X_CAPABILITY_COMPRESSION_MISSING_REQUIRED_FIELDS = 5179
ER_X_DOCUMENT_DOESNT_MATCH_EXPECTED_SCHEMA = 5180
ER_X_COLLECTION_OPTION_DOESNT_EXISTS = 5181
ER_X_INVALID_VALIDATION_SCHEMA = 5182
# End X Plugin Errors
