from __future__ import absolute_import
# GENERATED by modepy/contrib/weights-from-fortran.py
# DO NOT EDIT

import numpy as np
import six

points = "points"
weights = "weights"
quad_degree = "quad_degree"

def process_rule(table):
    result = {}
    for order, kv in six.iteritems(table):
        result[order] = order_tbl = {}
        for k, v in six.iteritems(kv):
            if isinstance(v, list):
                v = [i for i in v if not isinstance(i, list) or len(i)]
                v = np.array(v)

            order_tbl[k] = v

    return result

triangle_data = process_rule({0: {points: [[0.00000000000000000000000000000000e+00],
                [0.00000000000000000000000000000000e+00],
                []],
     quad_degree: 1,
     weights: [0.45590141139095552839871265039273e+01]},
 1: {points: [[0.50000000000000000000000000000000e+00,
                 0.00000000000000000000000000000000e+00,
                 -0.50000000000000000000000000000000e+00],
                [-0.28867513459481288225457439025098e+00,
                 0.57735026918962576450914878050196e+00,
                 -0.28867513459481288225457439025098e+00],
                []],
     quad_degree: 2,
     weights: [0.15196713713031850946623755013091e+01,
                 0.15196713713031850946623755013091e+01,
                 0.15196713713031850946623755013091e+01]},
 2: {points: [[0.00000000000000000000000000000000e+00,
                 -0.72527135947068776962128560979340e+00,
                 0.00000000000000000000000000000000e+00,
                 -0.33784547274789465895498776164916e+00,
                 0.72527135947068776962128560979340e+00,
                 0.33784547274789465895498776164916e+00],
                [0.83747122925185483484415621413487e+00,
                 -0.41873561462592741742207810706744e+00,
                 -0.39011034927098671317419951524681e+00,
                 0.19505517463549335658709975762341e+00,
                 -0.41873561462592741742207810706744e+00,
                 0.19505517463549335658709975762340e+00],
                []],
     quad_degree: 4,
     weights: [0.50127155117357779154594371101053e+00,
                 0.50127155117357779154594371101054e+00,
                 0.10183998201296073031164317902986e+01,
                 0.10183998201296073031164317902986e+01,
                 0.50127155117357779154594371101053e+00,
                 0.10183998201296073031164317902986e+01]},
 3: {points: [[0.00000000000000000000000000000000e+00,
                 0.78666101639967696838369807741827e+00,
                 0.00000000000000000000000000000000e+00,
                 0.30094676896614446173661526090005e+00,
                 -0.78666101639967696838369807741827e+00,
                 0.24288496199708743989786878437904e+00,
                 0.54383173096323190163448404527909e+00,
                 -0.24288496199708743989786878437904e+00,
                 -0.30094676896614446173661526090005e+00,
                 -0.54383173096323190163448404527909e+00],
                [0.00000000000000000000000000000000e+00,
                 -0.45417894957933810585376535186351e+00,
                 0.90835789915867621170753070372702e+00,
                 -0.45421109445661253251431660004936e+00,
                 -0.45417894957933810585376535186351e+00,
                 0.48773309433983369328454581322934e+00,
                 -0.33521999883221160770229213179975e-01,
                 0.48773309433983369328454581322934e+00,
                 -0.45421109445661253251431660004936e+00,
                 -0.33521999883221160770229213179975e-01],
                []],
     quad_degree: 5,
     weights: [0.90708593210472630247407787570254e+00,
                 0.27481272244823141968358523316723e+00,
                 0.27481272244823141968358523316723e+00,
                 0.47124833574335578707704882145384e+00,
                 0.27481272244823141968358523316723e+00,
                 0.47124833574335578707704882145384e+00,
                 0.47124833574335578707704882145384e+00,
                 0.47124833574335578707704882145384e+00,
                 0.47124833574335578707704882145384e+00,
                 0.47124833574335578707704882145384e+00]},
 4: {points: [[0.00000000000000000000000000000000e+00,
                 -0.27344573096654179666874290539477e+00,
                 0.27344573096654179666874290539477e+00,
                 -0.42233238215340581924615566001252e+00,
                 0.42233238215340581924615566001252e+00,
                 0.00000000000000000000000000000000e+00,
                 -0.18517708686734435661867105631915e+00,
                 -0.67031349478008169894818481229504e+00,
                 0.18517708686734435661867105631914e+00,
                 -0.48513640791273734232951375597590e+00,
                 0.67031349478008169894818481229504e+00,
                 0.48513640791273734232951375597590e+00,
                 0.00000000000000000000000000000000e+00,
                 -0.84624076047564449367313431517587e+00,
                 0.84624076047564449367313431517587e+00],
                [0.31574793276457378418547105481567e+00,
                 -0.15787396638228689209273552740784e+00,
                 -0.15787396638228689209273552740784e+00,
                 0.24383371452376474985074290854059e+00,
                 0.24383371452376474985074290854059e+00,
                 -0.48766742904752949970148581708119e+00,
                 0.66709931235482596900014874899532e+00,
                 -0.17318159475149501708574603496963e+00,
                 0.66709931235482596900014874899532e+00,
                 -0.49391771760333095191440271402570e+00,
                 -0.17318159475149501708574603496963e+00,
                 -0.49391771760333095191440271402570e+00,
                 0.97715466171969393506910087330460e+00,
                 -0.48857733085984696753455043665230e+00,
                 -0.48857733085984696753455043665230e+00],
                []],
     quad_degree: 7,
     weights: [0.57903548483294591423542964237399e+00,
                 0.57903548483294591423542964237399e+00,
                 0.57903548483294591423542964237399e+00,
                 0.29578809508516787711856076890140e+00,
                 0.29578809508516787711856076890141e+00,
                 0.29578809508516787711856076890141e+00,
                 0.24944927325911940024010038068926e+00,
                 0.24944927325911940024010038068926e+00,
                 0.24944927325911940024010038068926e+00,
                 0.24944927325911940024010038068926e+00,
                 0.24944927325911940024010038068926e+00,
                 0.24944927325911940024010038068926e+00,
                 0.14594924486683250282818432865517e+00,
                 0.14594924486683250282818432865517e+00,
                 0.14594924486683250282818432865517e+00]},
 5: {points: [[0.41194192657853010982865870129986e+00,
                 -0.41194192657853010982865870129986e+00,
                 0.21338599921749440268499811887570e+00,
                 0.00000000000000000000000000000000e+00,
                 0.00000000000000000000000000000000e+00,
                 -0.21338599921749440268499811887570e+00,
                 0.20857398496582545094850354093101e+00,
                 -0.20857398496582545094850354093101e+00,
                 0.54532428466503419131050832984425e+00,
                 -0.54532428466503419131050832984426e+00,
                 0.33675029969920874036200478891324e+00,
                 -0.33675029969920874036200478891324e+00,
                 0.61651198554323269517089684287530e+00,
                 0.74641524507499706560581304184834e+00,
                 -0.61651198554323269517089684287530e+00,
                 -0.74641524507499706560581304184834e+00,
                 0.12990325953176437043491619897304e+00,
                 -0.12990325953176437043491619897303e+00,
                 0.90578275359714536457244798934681e+00,
                 -0.90578275359714536457244798934681e+00,
                 0.00000000000000000000000000000000e+00],
                [-0.23783478220060741129500105273301e+00,
                 -0.23783478220060741129500105273301e+00,
                 0.12319846408951766613334398575003e+00,
                 -0.24639692817903533226668797150005e+00,
                 0.47566956440121482259000210546603e+00,
                 0.12319846408951766613334398575003e+00,
                 -0.50926599872802291799663328816150e+00,
                 -0.50926599872802291799663328816149e+00,
                 0.74002629815053037096272874649981e-01,
                 0.74002629815053037096272874649981e-01,
                 0.43526336891296988090036041351151e+00,
                 0.43526336891296988090036041351151e+00,
                 -0.50594272453056402070651247697118e+00,
                 -0.28094367895274208605804537200598e+00,
                 -0.50594272453056402070651247697118e+00,
                 -0.28094367895274208605804537200598e+00,
                 0.78688640348330610676455784897716e+00,
                 0.78688640348330610676455784897716e+00,
                 -0.52295391661663234099806653900769e+00,
                 -0.52295391661663234099806653900769e+00,
                 0.10459078332332646819961330780154e+01],
                []],
     quad_degree: 8,
     weights: [0.33917974956253817294776592406612e+00,
                 0.33917974956253817294776592406612e+00,
                 0.38758245225341608248421340887676e+00,
                 0.38758245225341608248421340887676e+00,
                 0.33917974956253817294776592406612e+00,
                 0.38758245225341608248421340887676e+00,
                 0.19009947908771557475880531795232e+00,
                 0.19009947908771557475880531795232e+00,
                 0.19009947908771557475880531795232e+00,
                 0.19009947908771557475880531795232e+00,
                 0.19009947908771557475880531795232e+00,
                 0.19009947908771557475880531795232e+00,
                 0.17509278958533358190105932301112e+00,
                 0.17509278958533358190105932301112e+00,
                 0.17509278958533358190105932301112e+00,
                 0.17509278958533358190105932301112e+00,
                 0.17509278958533358190105932301111e+00,
                 0.17509278958533358190105932301112e+00,
                 0.62524632141132525910666886439333e-01,
                 0.62524632141132525910666886439334e-01,
                 0.62524632141132525910666886439333e-01]},
 6: {points: [[-0.00000000000000000000000000000000e+00,
                 0.18198879794064935596162112438012e+00,
                 -0.18984606011787978345060759355777e+00,
                 -0.18198879794064935596162112438013e+00,
                 -0.37183485805852913941222871793789e+00,
                 0.37183485805852913941222871793789e+00,
                 0.18984606011787978345060759355777e+00,
                 -0.45604440912430706100423731491474e+00,
                 0.45604440912430706100423731491474e+00,
                 -0.00000000000000000000000000000000e+00,
                 0.27250079579468194023884839447403e+00,
                 -0.00000000000000000000000000000000e+00,
                 -0.27250079579468194023884839447403e+00,
                 -0.53495344799133098730940442584470e+00,
                 -0.63663129948675283473474306980112e+00,
                 -0.36413050369207089449589467532709e+00,
                 0.63663129948675283473474306980112e+00,
                 0.53495344799133098730940442584470e+00,
                 0.36413050369207089449589467532709e+00,
                 0.98658608416716666569522426444706e-01,
                 -0.98658608416716666569522426444706e-01,
                 -0.80715686527894965687110506529034e+00,
                 -0.70849825686223299030158263884563e+00,
                 0.80715686527894965687110506529034e+00,
                 0.70849825686223299030158263884563e+00,
                 0.00000000000000000000000000000000e+00,
                 -0.93188007906144489152796614894753e+00,
                 0.93188007906144489152796614894753e+00],
                [0.00000000000000000000000000000000e+00,
                 0.32428662930782585458826097784001e+00,
                 -0.31975023687470840225520350665067e+00,
                 0.32428662930782585458826097784001e+00,
                 -0.45363924331174523330574711893403e-02,
                 -0.45363924331174523330574711893396e-02,
                 -0.31975023687470840225520350665067e+00,
                 0.26329736237034250583971557607976e+00,
                 0.26329736237034250583971557607976e+00,
                 -0.52659472474068501167943115215952e+00,
                 0.57779009645998915719423059512945e+00,
                 0.61771103440342682348656306201350e+00,
                 0.57779009645998915719423059512945e+00,
                 -0.30885551720171341174328153100675e+00,
                 -0.52902436520324290549726733485822e-01,
                 -0.52488765993966486664450386164363e+00,
                 -0.52902436520324290549726733485822e-01,
                 -0.30885551720171341174328153100675e+00,
                 -0.52488765993966486664450386164363e+00,
                 0.87506389276684691859151236786929e+00,
                 0.87506389276684691859151236786929e+00,
                 -0.35209108519252559091506760612381e+00,
                 -0.52297280757432132767644476174547e+00,
                 -0.35209108519252559091506760612381e+00,
                 -0.52297280757432132767644476174547e+00,
                 0.10760424289971498961504391468917e+01,
                 -0.53802121449857494807521957344584e+00,
                 -0.53802121449857494807521957344584e+00],
                []],
     quad_degree: 10,
     weights: [0.36844247020518171223852083756008e+00,
                 0.26982135907071677972322120367243e+00,
                 0.26982135907071677972322120367243e+00,
                 0.26982135907071677972322120367243e+00,
                 0.26982135907071677972322120367243e+00,
                 0.26982135907071677972322120367244e+00,
                 0.26982135907071677972322120367243e+00,
                 0.12071761500142762867789653052100e+00,
                 0.12071761500142762867789653052100e+00,
                 0.12071761500142762867789653052100e+00,
                 0.13005099621234030030287697777114e+00,
                 0.22844907081688871224481751077453e+00,
                 0.13005099621234030030287697777114e+00,
                 0.22844907081688871224481751077453e+00,
                 0.13005099621234030030287697777114e+00,
                 0.13005099621234030030287697777114e+00,
                 0.13005099621234030030287697777114e+00,
                 0.22844907081688871224481751077453e+00,
                 0.13005099621234030030287697777114e+00,
                 0.10714642481311585857700622750153e+00,
                 0.10714642481311585857700622750153e+00,
                 0.10714642481311585857700622750153e+00,
                 0.10714642481311585857700622750153e+00,
                 0.10714642481311585857700622750153e+00,
                 0.10714642481311585857700622750153e+00,
                 0.33652968557462305787279029603334e-01,
                 0.33652968557462305787279029603335e-01,
                 0.33652968557462305787279029603334e-01]},
 7: {points: [[0.00000000000000000000000000000000e+00,
                 -0.18542610399850690980043697691631e+00,
                 0.18542610399850690980043697691631e+00,
                 -0.32001707063130681698349074886935e+00,
                 0.32001707063130681698349074886935e+00,
                 0.00000000000000000000000000000000e+00,
                 -0.14963262045752818798418957602781e+00,
                 -0.50093564750874300428223517244129e+00,
                 0.14963262045752818798418957602781e+00,
                 -0.35130302705121481629804559641348e+00,
                 0.50093564750874300428223517244128e+00,
                 0.35130302705121481629804559641348e+00,
                 -0.39075754928485943925742379730586e+00,
                 -0.53872893815831736574837198749508e+00,
                 0.39075754928485943925742379730586e+00,
                 -0.14797138887345792649094819018922e+00,
                 0.53872893815831736574837198749508e+00,
                 0.14797138887345792649094819018922e+00,
                 -0.22913152507304476183051871327667e+00,
                 -0.70222079033847928511493675220401e+00,
                 0.00000000000000000000000000000000e+00,
                 -0.63870750529242832977965961630583e+00,
                 0.22913152507304476183051871327667e+00,
                 -0.47308926526543452328441803892734e+00,
                 0.70222079033847928511493675220401e+00,
                 0.47308926526543452328441803892735e+00,
                 0.63870750529242832977965961630582e+00,
                 -0.82189759681889653376892056483208e-01,
                 -0.84515568016436411951015152604368e+00,
                 0.82189759681889653376892056483208e-01,
                 -0.76296592048247446613325946956047e+00,
                 0.84515568016436411951015152604368e+00,
                 0.76296592048247446613325946956047e+00,
                 -0.00000000000000000000000000000000e+00,
                 -0.94190436729271690210274071303830e+00,
                 0.94190436729271690210274071303830e+00],
                [0.21411162211664301340462165458887e+00,
                 -0.10705581105832150670231082729443e+00,
                 -0.10705581105832150670231082729443e+00,
                 0.18476194187426047228139197115937e+00,
                 0.18476194187426047228139197115937e+00,
                 -0.36952388374852094456278394231874e+00,
                 0.49204022817100151454837448537794e+00,
                 -0.11643446353444625358790649584804e+00,
                 0.49204022817100151454837448537794e+00,
                 -0.37560576463655526096046798952990e+00,
                 -0.11643446353444625358790649584804e+00,
                 -0.37560576463655526096046798952990e+00,
                 0.39646661866439951102400799310888e+00,
                 0.14017265506903832534298446961604e+00,
                 0.39646661866439951102400799310889e+00,
                 -0.53663927373343783636699246272493e+00,
                 0.14017265506903832534298446961605e+00,
                 -0.53663927373343783636699246272493e+00,
                 0.67856557698419366256136426691643e+00,
                 -0.14084906697096901352016080817778e+00,
                 0.73751590022803563770063020613881e+00,
                 -0.36875795011401781885031510306941e+00,
                 0.67856557698419366256136426691643e+00,
                 -0.53771651001322464904120345873865e+00,
                 -0.14084906697096901352016080817778e+00,
                 -0.53771651001322464904120345873865e+00,
                 -0.36875795011401781885031510306940e+00,
                 0.92844943902310411936713568924512e+00,
                 -0.39304629969609759695361745623513e+00,
                 0.92844943902310411936713568924512e+00,
                 -0.53540313932700652241351823300998e+00,
                 -0.39304629969609759695361745623514e+00,
                 -0.53540313932700652241351823300998e+00,
                 0.10876174800146684818245030609268e+01,
                 -0.54380874000733424091225153046341e+00,
                 -0.54380874000733424091225153046342e+00],
                []],
     quad_degree: 12,
     weights: [0.28474610815323103371641290149729e+00,
                 0.28474610815323103371641290149729e+00,
                 0.28474610815323103371641290149729e+00,
                 0.21309588386816800893218613125093e+00,
                 0.21309588386816800893218613125093e+00,
                 0.21309588386816800893218613125093e+00,
                 0.18932173287103399765087014583837e+00,
                 0.18932173287103399765087014583837e+00,
                 0.18932173287103399765087014583837e+00,
                 0.18932173287103399765087014583837e+00,
                 0.18932173287103399765087014583837e+00,
                 0.18932173287103399765087014583837e+00,
                 0.83472459547732161224281747699623e-01,
                 0.83472459547732161224281747699623e-01,
                 0.83472459547732161224281747699623e-01,
                 0.83472459547732161224281747699623e-01,
                 0.83472459547732161224281747699624e-01,
                 0.83472459547732161224281747699624e-01,
                 0.86739116268053511337316251692937e-01,
                 0.86739116268053511337316251692936e-01,
                 0.14424557730230049875552919231962e+00,
                 0.14424557730230049875552919231962e+00,
                 0.86739116268053511337316251692937e-01,
                 0.86739116268053511337316251692936e-01,
                 0.86739116268053511337316251692937e-01,
                 0.86739116268053511337316251692937e-01,
                 0.14424557730230049875552919231962e+00,
                 0.67538848194875641139479507014826e-01,
                 0.67538848194875641139479507014826e-01,
                 0.67538848194875641139479507014825e-01,
                 0.67538848194875641139479507014825e-01,
                 0.67538848194875641139479507014825e-01,
                 0.67538848194875641139479507014825e-01,
                 0.23439488216094930554351971749745e-01,
                 0.23439488216094930554351971749746e-01,
                 0.23439488216094930554351971749745e-01]},
 8: {points: [[0.33840749330282616276614803727603e+00,
                 -0.33840749330282616276614803727604e+00,
                 -0.00000000000000000000000000000000e+00,
                 -0.15837256783487402385429961651910e+00,
                 -0.00000000000000000000000000000000e+00,
                 0.15837256783487402385429961651909e+00,
                 -0.18003748919109069233633444728547e+00,
                 0.18003748919109069233633444728547e+00,
                 -0.44411215529327639172957918743676e+00,
                 0.44411215529327639172957918743676e+00,
                 -0.26407466610218569939324474015130e+00,
                 0.26407466610218569939324474015129e+00,
                 0.00000000000000000000000000000000e+00,
                 0.47074732981511676359820069717112e+00,
                 -0.47074732981511676359820069717112e+00,
                 0.50691100281912485182864141364046e+00,
                 -0.50691100281912485182864141364047e+00,
                 0.61574805258036049546697922568789e+00,
                 -0.61574805258036049546697922568789e+00,
                 0.28520479247065339231926648775766e+00,
                 -0.28520479247065339231926648775766e+00,
                 0.61484502537664123353119996207596e+00,
                 -0.61484502537664123353119996207596e+00,
                 0.10883704976123564363833781204742e+00,
                 -0.10883704976123564363833781204743e+00,
                 0.32964023290598784121193347431830e+00,
                 -0.32964023290598784121193347431830e+00,
                 0.55280800592112062772924427272673e+00,
                 -0.55280800592112062772924427272674e+00,
                 0.75408237504506300730322177299697e+00,
                 -0.75408237504506300730322177299698e+00,
                 0.74905048380485682434739851366433e+00,
                 -0.74905048380485682434739851366434e+00,
                 0.19624247788373619661815424093760e+00,
                 -0.19624247788373619661815424093760e+00,
                 -0.00000000000000000000000000000000e+00,
                 0.87243682719949148181118784089772e+00,
                 0.79103149889354115500914178391097e+00,
                 -0.79103149889354115500914178391098e+00,
                 -0.87243682719949148181118784089772e+00,
                 0.94352470249122517030426883532403e+00,
                 0.81405328305950326802046056986742e-01,
                 -0.81405328305950326802046056986742e-01,
                 -0.94352470249122517030426883532403e+00,
                 0.00000000000000000000000000000000e+00],
                [-0.19537965735417316316644641041672e+00,
                 -0.19537965735417316316644641041672e+00,
                 -0.18287288934343356901271462559822e+00,
                 0.91436444671716784506357312799112e-01,
                 0.39075931470834632633289282083344e+00,
                 0.91436444671716784506357312799113e-01,
                 -0.40887185196921546111148340827586e+00,
                 -0.40887185196921546111148340827586e+00,
                 0.48518886711556905327821032825818e-01,
                 0.48518886711556905327821032825820e-01,
                 0.36035296525765855578366237545005e+00,
                 0.36035296525765855578366237545005e+00,
                 -0.54357219517811041207332500874834e+00,
                 0.27178609758905520603666250437417e+00,
                 0.27178609758905520603666250437417e+00,
                 -0.41833940388771306478528118915117e+00,
                 -0.41833940388771306478528118915117e+00,
                 -0.22982810395535078460065003265087e+00,
                 -0.22982810395535078460065003265087e+00,
                 -0.54529881811510911349963357908858e+00,
                 -0.54529881811510911349963357908858e+00,
                 0.25654813496899925536999074593718e-01,
                 0.25654813496899925536999074593715e-01,
                 0.64816750784306384938593122180205e+00,
                 0.64816750784306384938593122180204e+00,
                 0.51964400461820918796263450449486e+00,
                 0.51964400461820918796263450449486e+00,
                 -0.54576514589396777543130146294961e+00,
                 -0.54576514589396777543130146294961e+00,
                 -0.43536966222341946125925878404668e+00,
                 -0.43536966222341946125925878404668e+00,
                 -0.20586320359612495421009714581709e+00,
                 -0.20586320359612495421009714581710e+00,
                 0.75162834949009272964139860876670e+00,
                 0.75162834949009272964139860876670e+00,
                 0.87073932444683892251851756809337e+00,
                 -0.40970286061274885784067104473356e+00,
                 -0.55070102524547970712547088728629e+00,
                 -0.55070102524547970712547088728629e+00,
                 -0.40970286061274885784067104473357e+00,
                 -0.54474424097037041525790615178450e+00,
                 0.96040388585822856496614193201986e+00,
                 0.96040388585822856496614193201986e+00,
                 -0.54474424097037041525790615178450e+00,
                 0.10894884819407408305158123035690e+01],
                []],
     quad_degree: 14,
     weights: [0.20691581470544605371895271697260e+00,
                 0.20691581470544605371895271697260e+00,
                 0.23794539985980616400797361789076e+00,
                 0.23794539985980616400797361789076e+00,
                 0.20691581470544605371895271697260e+00,
                 0.23794539985980616400797361789076e+00,
                 0.17114863030303046419207015040627e+00,
                 0.17114863030303046419207015040627e+00,
                 0.17114863030303046419207015040627e+00,
                 0.17114863030303046419207015040627e+00,
                 0.17114863030303046419207015040627e+00,
                 0.17114863030303046419207015040627e+00,
                 0.65389423521675711134061363589965e-01,
                 0.65389423521675711134061363589964e-01,
                 0.65389423521675711134061363589964e-01,
                 0.13189788805206353370873193804624e+00,
                 0.13189788805206353370873193804624e+00,
                 0.13189788805206353370873193804624e+00,
                 0.13189788805206353370873193804624e+00,
                 0.59840938977801931223902387229158e-01,
                 0.59840938977801931223902387229159e-01,
                 0.59840938977801931223902387229158e-01,
                 0.59840938977801931223902387229160e-01,
                 0.13189788805206353370873193804624e+00,
                 0.13189788805206353370873193804624e+00,
                 0.59840938977801931223902387229158e-01,
                 0.59840938977801931223902387229158e-01,
                 0.54223053491964243471547265804864e-01,
                 0.54223053491964243471547265804863e-01,
                 0.79318743937949617852448639008659e-01,
                 0.79318743937949617852448639008657e-01,
                 0.54223053491964243471547265804864e-01,
                 0.54223053491964243471547265804864e-01,
                 0.54223053491964243471547265804864e-01,
                 0.54223053491964243471547265804863e-01,
                 0.79318743937949617852448639008657e-01,
                 0.37402525175974735657181658621826e-01,
                 0.37402525175974735657181658621826e-01,
                 0.37402525175974735657181658621825e-01,
                 0.37402525175974735657181658621824e-01,
                 0.21075917276637731442072363630395e-01,
                 0.37402525175974735657181658621826e-01,
                 0.37402525175974735657181658621824e-01,
                 0.21075917276637731442072363630395e-01,
                 0.21075917276637731442072363630395e-01]},
 9: {points: [[0.00000000000000000000000000000000e+00,
                 0.37811539285214573105632000025031e+00,
                 -0.00000000000000000000000000000000e+00,
                 0.28060976678934036420039639714517e+00,
                 -0.28060976678934036420039639714517e+00,
                 -0.37811539285214573105632000025031e+00,
                 0.13612645795137144022275064544358e+00,
                 -0.13612645795137144022275064544358e+00,
                 0.38523130723366368854885150368032e+00,
                 0.14448330883796892397764575170159e+00,
                 -0.14448330883796892397764575170159e+00,
                 0.50199922907959865394668431471380e+00,
                 0.25143652303055032384653087127271e+00,
                 0.00000000000000000000000000000000e+00,
                 -0.38523130723366368854885150368032e+00,
                 0.25056270604904833010015344344108e+00,
                 -0.25143652303055032384653087127271e+00,
                 -0.25056270604904833010015344344109e+00,
                 -0.50199922907959865394668431471380e+00,
                 0.54873803112611292080239030575457e+00,
                 0.14517136292570846629519516527345e+00,
                 0.40356666820040445450719514048112e+00,
                 -0.14517136292570846629519516527346e+00,
                 -0.40356666820040445450719514048112e+00,
                 -0.54873803112611292080239030575457e+00,
                 0.62657493845800257036694631667822e+00,
                 0.42221236730845991783894824568658e+00,
                 0.68647162444028217694604041543579e+00,
                 0.52451761844040940597972356337355e+00,
                 0.26425925713182225910709216974921e+00,
                 -0.42221236730845991783894824568658e+00,
                 0.10205732001759316438722275330467e+00,
                 -0.52451761844040940597972356337355e+00,
                 -0.10205732001759316438722275330467e+00,
                 -0.62657493845800257036694631667822e+00,
                 -0.26425925713182225910709216974921e+00,
                 -0.68647162444028217694604041543579e+00,
                 0.79151680103462485387156047337526e+00,
                 0.63964292679575040433963909286056e+00,
                 0.76848884734188719390457335364592e+00,
                 -0.63964292679575040433963909286056e+00,
                 -0.76848884734188719390457335364592e+00,
                 -0.79151680103462485387156047337526e+00,
                 0.15187387423887444953192138051470e+00,
                 -0.15187387423887444953192138051470e+00,
                 -0.00000000000000000000000000000000e+00,
                 0.89037304390288533172340646363686e+00,
                 0.81991605544320127351297764941668e+00,
                 -0.81991605544320127351297764941668e+00,
                 -0.89037304390288533172340646363685e+00,
                 0.70456988459684058210428814220177e-01,
                 -0.70456988459684058210428814220178e-01,
                 0.94704402112766222486169064973683e+00,
                 -0.00000000000000000000000000000000e+00,
                 -0.94704402112766222486169064973683e+00],
                [0.00000000000000000000000000000000e+00,
                 0.21830502384792743549483327074518e+00,
                 -0.43661004769585487098966654149036e+00,
                 0.48248301089546199788718253200950e-02,
                 0.48248301089546199788718253200910e-02,
                 0.21830502384792743549483327074518e+00,
                 -0.24542760164407296072916507862054e+00,
                 -0.24542760164407296072916507862054e+00,
                 -0.22241339893162715758625388904021e+00,
                 0.24060277153511834075029325330045e+00,
                 0.24060277153511834075029325330045e+00,
                 -0.50449846949264232666571801631269e-03,
                 -0.43449183582839001813473460242920e+00,
                 0.44482679786325431517250777808043e+00,
                 -0.22241339893162715758625388904022e+00,
                 0.43499633429788266046140032044551e+00,
                 -0.43449183582839001813473460242920e+00,
                 0.43499633429788266046140032044551e+00,
                 -0.50449846949264232666571801631078e-03,
                 0.14918459905768125499570812591462e+00,
                 -0.54981337450671043212360903474340e+00,
                 0.40062877544902917712790090882878e+00,
                 -0.54981337450671043212360903474340e+00,
                 0.40062877544902917712790090882878e+00,
                 0.14918459905768125499570812591461e+00,
                 -0.24390756701634258988418900167204e+00,
                 -0.54890473040254470931193669006158e+00,
                 -0.91194270679820369058210028722852e-01,
                 -0.42067603057113017645503470382124e+00,
                 0.64009900108236507837014671878442e+00,
                 -0.54890473040254470931193669006158e+00,
                 0.66458359758747276633922370549328e+00,
                 -0.42067603057113017645503470382124e+00,
                 0.66458359758747276633922370549328e+00,
                 -0.24390756701634258988418900167204e+00,
                 0.64009900108236507837014671878443e+00,
                 -0.91194270679820369058210028722850e-01,
                 -0.28161359379608104980286843915852e+00,
                 -0.54466686032013764942085229009376e+00,
                 -0.44368724288206379156242047385715e+00,
                 -0.54466686032013764942085229009376e+00,
                 -0.44368724288206379156242047385715e+00,
                 -0.28161359379608104980286843915852e+00,
                 0.82628045411621869922372072925228e+00,
                 0.82628045411621869922372072925228e+00,
                 0.88737448576412758312484094771430e+00,
                 -0.43270039406953943136612028373603e+00,
                 -0.55473547783000627225956807468872e+00,
                 -0.55473547783000627225956807468872e+00,
                 -0.43270039406953943136612028373603e+00,
                 0.98743587189954570362568835842475e+00,
                 0.98743587189954570362568835842475e+00,
                 -0.54677612053248141539518698378250e+00,
                 0.10935522410649628307903739675650e+01,
                 -0.54677612053248141539518698378250e+00],
                []],
     quad_degree: 15,
     weights: [0.20413121641456104921146010905766e+00,
                 0.93990779330357746327627611645808e-01,
                 0.93990779330357746327627611645808e-01,
                 0.15752650466200850672413820594880e+00,
                 0.15752650466200850672413820594880e+00,
                 0.93990779330357746327627611645807e-01,
                 0.15752650466200850672413820594880e+00,
                 0.15752650466200850672413820594880e+00,
                 0.14573070396618360905603329055864e+00,
                 0.15752650466200850672413820594880e+00,
                 0.15752650466200850672413820594880e+00,
                 0.11499818271760449118004500167037e+00,
                 0.11499818271760449118004500167037e+00,
                 0.14573070396618360905603329055864e+00,
                 0.14573070396618360905603329055863e+00,
                 0.11499818271760449118004500167037e+00,
                 0.11499818271760449118004500167037e+00,
                 0.11499818271760449118004500167037e+00,
                 0.11499818271760449118004500167037e+00,
                 0.53447968647332307977565597233823e-01,
                 0.53447968647332307977565597233823e-01,
                 0.53447968647332307977565597233823e-01,
                 0.53447968647332307977565597233822e-01,
                 0.53447968647332307977565597233823e-01,
                 0.53447968647332307977565597233823e-01,
                 0.11771363102141070112915130214051e+00,
                 0.48857116316770811080479043011544e-01,
                 0.48857116316770811080479043011545e-01,
                 0.11771363102141070112915130214051e+00,
                 0.48857116316770811080479043011544e-01,
                 0.48857116316770811080479043011543e-01,
                 0.11771363102141070112915130214051e+00,
                 0.11771363102141070112915130214051e+00,
                 0.11771363102141070112915130214051e+00,
                 0.11771363102141070112915130214051e+00,
                 0.48857116316770811080479043011544e-01,
                 0.48857116316770811080479043011544e-01,
                 0.40935744387354011212656820972623e-01,
                 0.40935744387354011212656820972623e-01,
                 0.75377488535339108800012563051937e-01,
                 0.40935744387354011212656820972623e-01,
                 0.75377488535339108800012563051937e-01,
                 0.40935744387354011212656820972622e-01,
                 0.40935744387354011212656820972623e-01,
                 0.40935744387354011212656820972623e-01,
                 0.75377488535339108800012563051937e-01,
                 0.25867522097673042036235639597699e-01,
                 0.25867522097673042036235639597699e-01,
                 0.25867522097673042036235639597700e-01,
                 0.25867522097673042036235639597700e-01,
                 0.25867522097673042036235639597700e-01,
                 0.25867522097673042036235639597700e-01,
                 0.17835320966143204727672111882754e-01,
                 0.17835320966143204727672111882754e-01,
                 0.17835320966143204727672111882754e-01]},
 10: {points: [[0.14053768755130206658828618391664e+00,
                  -0.14053768755130206658828618391664e+00,
                  -0.00000000000000000000000000000000e+00,
                  0.00000000000000000000000000000000e+00,
                  0.25253108180892151157510287230937e+00,
                  -0.25253108180892151157510287230937e+00,
                  0.27653066905149215797530175701768e+00,
                  -0.27653066905149215797530175701768e+00,
                  0.39639932929578666884731093942653e+00,
                  -0.39639932929578666884731093942653e+00,
                  0.11986866024429451087200918240886e+00,
                  -0.11986866024429451087200918240886e+00,
                  0.10468787213559627193812897063098e+00,
                  -0.10468787213559627193812897063097e+00,
                  0.44730168313757441375993348512807e+00,
                  0.34261381100197814182180451449712e+00,
                  -0.34261381100197814182180451449712e+00,
                  -0.44730168313757441375993348512808e+00,
                  0.47881252626134275156553235337071e+00,
                  0.00000000000000000000000000000000e+00,
                  0.51015615497435863868326775030967e+00,
                  0.34878244540743420308578801206349e+00,
                  0.57391276258635003910951681880859e+00,
                  0.25702375453663387322606113059203e+00,
                  0.60931331831206290975267860508589e+00,
                  -0.34878244540743420308578801206350e+00,
                  -0.51015615497435863868326775030966e+00,
                  -0.25702375453663387322606113059203e+00,
                  -0.57391276258635003910951681880860e+00,
                  -0.47881252626134275156553235337071e+00,
                  0.22513031717891583602372880674511e+00,
                  0.00000000000000000000000000000000e+00,
                  0.35228956377542903652661747449388e+00,
                  -0.22513031717891583602372880674511e+00,
                  -0.35228956377542903652661747449388e+00,
                  -0.60931331831206290975267860508590e+00,
                  0.50029442031897347474165480909485e+00,
                  -0.50029442031897347474165480909484e+00,
                  0.59623504472920704718527558494493e+00,
                  -0.59623504472920704718527558494494e+00,
                  0.69154830009040688619749981905490e+00,
                  0.73005468624972210976461526427474e+00,
                  -0.69154830009040688619749981905490e+00,
                  -0.73005468624972210976461526427475e+00,
                  0.22976026593074863502296045517988e+00,
                  0.95313255361199839012224234109949e-01,
                  -0.95313255361199839012224234109951e-01,
                  -0.22976026593074863502296045517989e+00,
                  0.69914099608928100469333013513085e+00,
                  -0.69914099608928100469333013513084e+00,
                  0.82853927736516455073423784206057e+00,
                  0.79419074530456794800392879888610e+00,
                  -0.79419074530456794800392879888610e+00,
                  -0.82853927736516455073423784206057e+00,
                  0.12939828127588354604090770692968e+00,
                  -0.12939828127588354604090770692969e+00,
                  -0.00000000000000000000000000000000e+00,
                  0.90915805900265182902891027226230e+00,
                  0.85693828482943123575327237914906e+00,
                  -0.85693828482943123575327237914906e+00,
                  -0.90915805900265182902891027226229e+00,
                  0.95985867197873597318174667753933e+00,
                  -0.95985867197873597318174667753933e+00,
                  0.52219774173220593275637893113207e-01,
                  -0.52219774173220593275637893113214e-01,
                  -0.00000000000000000000000000000000e+00],
                 [-0.81139471739031765889266476336151e-01,
                  -0.81139471739031765889266476336156e-01,
                  0.16227894347806353177853295267229e+00,
                  -0.29159777612225648151622278604161e+00,
                  0.14579888806112824075811139302080e+00,
                  0.14579888806112824075811139302080e+00,
                  -0.29806746273495276760092593645161e+00,
                  -0.29806746273495276760092593645161e+00,
                  -0.90448852956623083880856892002223e-01,
                  -0.90448852956623083880856892002227e-01,
                  0.38851631569157585148178282845383e+00,
                  0.38851631569157585148178282845384e+00,
                  -0.45605792317852692097858857208222e+00,
                  -0.45605792317852692097858857208222e+00,
                  0.13736660485170001568815773157590e+00,
                  0.31869131832682690529043084050633e+00,
                  0.31869131832682690529043084050632e+00,
                  0.13736660485170001568815773157588e+00,
                  0.27644254092835099326642427211329e+00,
                  -0.55288508185670198653284854422657e+00,
                  -0.29453879340319039905231898288137e+00,
                  -0.46132773719658386474093306462279e+00,
                  -0.71390589518605202043236714120694e-01,
                  -0.55518168282673343838972665057510e+00,
                  0.55001740608585924675964394879239e-01,
                  -0.46132773719658386474093306462279e+00,
                  -0.29453879340319039905231898288138e+00,
                  -0.55518168282673343838972665057510e+00,
                  -0.71390589518605202043236714120707e-01,
                  0.27644254092835099326642427211329e+00,
                  0.53271832671518906678416977874346e+00,
                  0.58907758680638079810463796576277e+00,
                  0.50017994221814751371376225569586e+00,
                  0.53271832671518906678416977874346e+00,
                  0.50017994221814751371376225569586e+00,
                  0.55001740608585924675964394879227e-01,
                  -0.55414942101362256514427103275521e+00,
                  -0.55414942101362256514427103275522e+00,
                  -0.45429473085495278329741215518797e+00,
                  -0.45429473085495278329741215518797e+00,
                  -0.28920732993456797890084935814631e+00,
                  -0.15619296686102938749577329218793e+00,
                  -0.28920732993456797890084935814631e+00,
                  -0.15619296686102938749577329218794e+00,
                  0.71034238787465195264004432494313e+00,
                  0.74350206078952076219826151333427e+00,
                  0.74350206078952076219826151333426e+00,
                  0.71034238787465195264004432494311e+00,
                  -0.55306550734826203502440460211451e+00,
                  -0.55306550734826203502440460211451e+00,
                  -0.32894110976634320542690088540335e+00,
                  -0.45852624058950181895331566438166e+00,
                  -0.45852624058950181895331566438166e+00,
                  -0.32894110976634320542690088540335e+00,
                  0.88200661711460524045130548751787e+00,
                  0.88200661711460524045130548751784e+00,
                  0.91705248117900363790663132876330e+00,
                  -0.46460444874923794375297262976920e+00,
                  -0.55505175077702907392533618901215e+00,
                  -0.55505175077702907392533618901215e+00,
                  -0.46460444874923794375297262976919e+00,
                  -0.55417466265091991089116230312826e+00,
                  -0.55417466265091991089116230312826e+00,
                  0.10196561995262670176783088187814e+01,
                  0.10196561995262670176783088187813e+01,
                  0.11083493253018398217823246062565e+01],
                 []],
      quad_degree: 17,
      weights: [0.16782939961798108499438738634663e+00,
                  0.16782939961798108499438738634663e+00,
                  0.16782939961798108499438738634663e+00,
                  0.14254062876910436908239752699873e+00,
                  0.14254062876910436908239752699873e+00,
                  0.14254062876910436908239752699873e+00,
                  0.13166869135483947298903608241799e+00,
                  0.13166869135483947298903608241799e+00,
                  0.13166869135483947298903608241798e+00,
                  0.13166869135483947298903608241798e+00,
                  0.13166869135483947298903608241798e+00,
                  0.13166869135483947298903608241799e+00,
                  0.76747637827468254538745833384154e-01,
                  0.76747637827468254538745833384159e-01,
                  0.76747637827468254538745833384154e-01,
                  0.76747637827468254538745833384144e-01,
                  0.76747637827468254538745833384148e-01,
                  0.76747637827468254538745833384157e-01,
                  0.41963949105632020343858279212035e-01,
                  0.41963949105632020343858279212041e-01,
                  0.10186792965144759595425818984437e+00,
                  0.88406274241315645108981812745072e-01,
                  0.88406274241315645108981812745083e-01,
                  0.38346382208019033548904778370161e-01,
                  0.38346382208019033548904778370165e-01,
                  0.88406274241315645108981812745073e-01,
                  0.10186792965144759595425818984437e+00,
                  0.38346382208019033548904778370161e-01,
                  0.88406274241315645108981812745080e-01,
                  0.41963949105632020343858279212038e-01,
                  0.88406274241315645108981812745082e-01,
                  0.10186792965144759595425818984437e+00,
                  0.38346382208019033548904778370162e-01,
                  0.88406274241315645108981812745078e-01,
                  0.38346382208019033548904778370159e-01,
                  0.38346382208019033548904778370167e-01,
                  0.34856798335121714834433454027135e-01,
                  0.34856798335121714834433454027133e-01,
                  0.80970506647286595504466417792703e-01,
                  0.80970506647286595504466417792702e-01,
                  0.80970506647286595504466417792698e-01,
                  0.34856798335121714834433454027143e-01,
                  0.80970506647286595504466417792698e-01,
                  0.34856798335121714834433454027140e-01,
                  0.34856798335121714834433454027144e-01,
                  0.80970506647286595504466417792701e-01,
                  0.80970506647286595504466417792704e-01,
                  0.34856798335121714834433454027140e-01,
                  0.28772971808839619224359703753687e-01,
                  0.28772971808839619224359703753686e-01,
                  0.28772971808839619224359703753683e-01,
                  0.54956946970422908106200915010050e-01,
                  0.54956946970422908106200915010048e-01,
                  0.28772971808839619224359703753681e-01,
                  0.28772971808839619224359703753687e-01,
                  0.28772971808839619224359703753689e-01,
                  0.54956946970422908106200915010055e-01,
                  0.20320322306118681005689765041846e-01,
                  0.20320322306118681005689765041849e-01,
                  0.20320322306118681005689765041849e-01,
                  0.20320322306118681005689765041847e-01,
                  0.10333347730579082672037508831777e-01,
                  0.10333347730579082672037508831778e-01,
                  0.20320322306118681005689765041847e-01,
                  0.20320322306118681005689765041849e-01,
                  0.10333347730579082672037508831774e-01]},
 11: {points: [[0.26427360326405010146944426135061e+00,
                  0.12385718874820048153057341962848e+00,
                  -0.00000000000000000000000000000000e+00,
                  0.00000000000000000000000000000000e+00,
                  -0.26427360326405010146944426135057e+00,
                  -0.12385718874820048153057341962842e+00,
                  -0.22435291528717072984873190791939e+00,
                  0.35024091737596575505863208124883e+00,
                  0.22435291528717072984873190791942e+00,
                  0.12588800208879502520990017332938e+00,
                  -0.35024091737596575505863208124879e+00,
                  -0.12588800208879502520990017332953e+00,
                  0.40024901695833349658264281308061e+00,
                  -0.40024901695833349658264281308072e+00,
                  0.00000000000000000000000000000000e+00,
                  0.11848933195933342726862023439310e+00,
                  -0.11848933195933342726862023439310e+00,
                  0.32817940932664234478994293415356e+00,
                  -0.32817940932664234478994293415350e+00,
                  0.49980478728492652297900636435619e+00,
                  0.47849651664057497478767011944564e+00,
                  0.36000718468124154751904988505254e+00,
                  0.42973424315451816610387061667737e+00,
                  0.53557483012590380926039063368404e+00,
                  0.17162537795828417818906343020262e+00,
                  -0.36000718468124154751904988505260e+00,
                  -0.47849651664057497478767011944560e+00,
                  -0.17162537795828417818906343020264e+00,
                  -0.49980478728492652297900636435616e+00,
                  -0.42973424315451816610387061667738e+00,
                  -0.53557483012590380926039063368409e+00,
                  0.19764779125324695357946027527752e+00,
                  0.10584058697138564315652001700665e+00,
                  0.31253435676428121474523260921346e+00,
                  -0.10584058697138564315652001700661e+00,
                  -0.00000000000000000000000000000000e+00,
                  -0.19764779125324695357946027527739e+00,
                  -0.31253435676428121474523260921340e+00,
                  0.65510088708884485906819932175334e+00,
                  0.63127235592854168598776007870309e+00,
                  0.55151615620594722099419816509822e+00,
                  0.43362456467529473240829980342554e+00,
                  0.34256653032456364432296671253983e+00,
                  -0.63127235592854168598776007870304e+00,
                  -0.65510088708884485906819932175332e+00,
                  -0.55151615620594722099419816509827e+00,
                  -0.43362456467529473240829980342556e+00,
                  -0.34256653032456364432296671253988e+00,
                  0.19683392048703377872521398434811e+00,
                  0.75173014745603402282539206324715e-01,
                  -0.75173014745603402282539206324633e-01,
                  -0.19683392048703377872521398434815e+00,
                  0.76878478113352564525353333489535e+00,
                  -0.76878478113352564525353333489531e+00,
                  -0.73313220231134685326138576176554e+00,
                  0.73313220231134685326138576176556e+00,
                  -0.65795918756574345097884655544085e+00,
                  0.65795918756574345097884655544079e+00,
                  -0.57195086064649186652831935054729e+00,
                  0.57195086064649186652831935054725e+00,
                  0.10867373265998159031179892326019e+00,
                  -0.10867373265998159031179892326038e+00,
                  0.00000000000000000000000000000000e+00,
                  0.85272952548451568827878036327761e+00,
                  0.74405579282453409796698144001758e+00,
                  0.83674834256361682127180672571251e+00,
                  -0.74405579282453409796698144001756e+00,
                  -0.85272952548451568827878036327764e+00,
                  -0.83674834256361682127180672571250e+00,
                  0.47566109682335816268368790499835e-01,
                  -0.47566109682335816268368790499991e-01,
                  0.92442948739249250047565381868294e+00,
                  0.87686337771015668420728502818325e+00,
                  -0.87686337771015668420728502818320e+00,
                  -0.92442948739249250047565381868299e+00,
                  -0.00000000000000000000000000000000e+00,
                  0.96428268978304975291755042105045e+00,
                  -0.96428268978304975291755042105045e+00],
                 [-0.15257843598421168817139391661751e+00,
                  0.71508981264843835383937552089602e-01,
                  -0.14301796252968767076787510417936e+00,
                  0.30515687196842337634278783323477e+00,
                  -0.15257843598421168817139391661739e+00,
                  0.71508981264843835383937552089681e-01,
                  0.27489315982194528286710718215879e+00,
                  0.56848744140815347878863016839593e-01,
                  0.27489315982194528286710718215877e+00,
                  -0.33174190396276063074597019899842e+00,
                  0.56848744140815347878863016839718e-01,
                  -0.33174190396276063074597019899839e+00,
                  0.23108387768377693187845865320082e+00,
                  0.23108387768377693187845865320072e+00,
                  -0.46216775536755386375691730640146e+00,
                  0.48411033767464833012932969998934e+00,
                  0.48411033767464833012932969998919e+00,
                  0.38765038664520260714181163494703e+00,
                  0.38765038664520260714181163494709e+00,
                  0.90386512153242703460578774163780e-01,
                  -0.13944039728309404288486973319682e+00,
                  -0.34466994039155428724445996679253e+00,
                  0.37032136372349615335879411647920e+00,
                  0.18700008958614365755969143019232e+00,
                  -0.47803689879844531060239040911093e+00,
                  -0.34466994039155428724445996679242e+00,
                  -0.13944039728309404288486973319677e+00,
                  -0.47803689879844531060239040911090e+00,
                  0.90386512153242703460578774163841e-01,
                  0.37032136372349615335879411647919e+00,
                  0.18700008958614365755969143019223e+00,
                  0.61481852376982849128590251214206e+00,
                  -0.55732145330963981091848554667149e+00,
                  0.57600355200535013039266276234502e+00,
                  -0.55732145330963981091848554667148e+00,
                  0.63683600249586264040100523908576e+00,
                  0.61481852376982849128590251214220e+00,
                  0.57600355200535013039266276234510e+00,
                  -0.17339083489378622303918341274538e-01,
                  -0.13624125365771861170424099745380e+00,
                  -0.31841800124793132020050261954281e+00,
                  -0.47857727011210987958166151468851e+00,
                  -0.55866446851597150808874442107058e+00,
                  -0.13624125365771861170424099745369e+00,
                  -0.17339083489378622303918341274506e-01,
                  -0.31841800124793132020050261954281e+00,
                  -0.47857727011210987958166151468847e+00,
                  -0.55866446851597150808874442107057e+00,
                  0.77407408369381877032916337485145e+00,
                  0.80314698841290873239792756872275e+00,
                  0.80314698841290873239792756872292e+00,
                  0.77407408369381877032916337485141e+00,
                  -0.21657386637865186644541835656385e+00,
                  -0.21657386637865186644541835656378e+00,
                  -0.33647175375769961929886610782473e+00,
                  -0.33647175375769961929886610782481e+00,
                  -0.46667523465520911309906146089810e+00,
                  -0.46667523465520911309906146089810e+00,
                  -0.55750021731516690388374501828760e+00,
                  -0.55750021731516690388374501828761e+00,
                  0.92190443336377215596472112861392e+00,
                  0.92190443336377215596472112861357e+00,
                  0.96619376164615473106918298349265e+00,
                  -0.36683800347426338347344542136154e+00,
                  -0.55506642988950877249127570725207e+00,
                  -0.48309688082307736553459149174639e+00,
                  -0.55506642988950877249127570725207e+00,
                  -0.36683800347426338347344542136155e+00,
                  -0.48309688082307736553459149174633e+00,
                  0.10399769205563667560392902786123e+01,
                  0.10399769205563667560392902786119e+01,
                  -0.47879500093408360604347076342275e+00,
                  -0.56118191962228314999581951518923e+00,
                  -0.56118191962228314999581951518921e+00,
                  -0.47879500093408360604347076342282e+00,
                  0.11134577410422803374807608592475e+01,
                  -0.55672887052114016874038042962369e+00,
                  -0.55672887052114016874038042962371e+00],
                 []],
      quad_degree: 19,
      weights: [0.13555215451378844655798556896040e+00,
                  0.14543140675710730378911493028871e+00,
                  0.14543140675710730378911493028871e+00,
                  0.13555215451378844655798556896038e+00,
                  0.13555215451378844655798556896039e+00,
                  0.14543140675710730378911493028870e+00,
                  0.10849621150538757062394596896860e+00,
                  0.10849621150538757062394596896862e+00,
                  0.10849621150538757062394596896865e+00,
                  0.10849621150538757062394596896866e+00,
                  0.10849621150538757062394596896861e+00,
                  0.10849621150538757062394596896865e+00,
                  0.32898279993571760562493672779819e-01,
                  0.32898279993571760562493672779807e-01,
                  0.32898279993571760562493672779827e-01,
                  0.93407975544186974215944461961104e-01,
                  0.93407975544186974215944461961074e-01,
                  0.74595006934715661646180126364160e-01,
                  0.74595006934715661646180126364220e-01,
                  0.74595006934715661646180126364227e-01,
                  0.93407975544186974215944461961042e-01,
                  0.93407975544186974215944461961071e-01,
                  0.29502825009403207944738012654177e-01,
                  0.29502825009403207944738012654187e-01,
                  0.74595006934715661646180126364177e-01,
                  0.93407975544186974215944461961067e-01,
                  0.93407975544186974215944461961080e-01,
                  0.74595006934715661646180126364201e-01,
                  0.74595006934715661646180126364184e-01,
                  0.29502825009403207944738012654201e-01,
                  0.29502825009403207944738012654176e-01,
                  0.72961518376921263695388435242539e-01,
                  0.29502825009403207944738012654164e-01,
                  0.30851301643317909664852824145611e-01,
                  0.29502825009403207944738012654189e-01,
                  0.85996339207901148075194967850656e-01,
                  0.72961518376921263695388435242584e-01,
                  0.30851301643317909664852824145628e-01,
                  0.30851301643317909664852824145627e-01,
                  0.72961518376921263695388435242550e-01,
                  0.85996339207901148075194967850681e-01,
                  0.72961518376921263695388435242511e-01,
                  0.30851301643317909664852824145610e-01,
                  0.72961518376921263695388435242549e-01,
                  0.30851301643317909664852824145608e-01,
                  0.85996339207901148075194967850665e-01,
                  0.72961518376921263695388435242548e-01,
                  0.30851301643317909664852824145628e-01,
                  0.27360580654059264445023332214054e-01,
                  0.64990923040120982373371975368357e-01,
                  0.64990923040120982373371975368316e-01,
                  0.27360580654059264445023332214006e-01,
                  0.27360580654059264445023332214002e-01,
                  0.27360580654059264445023332214008e-01,
                  0.64990923040120982373371975368326e-01,
                  0.64990923040120982373371975368325e-01,
                  0.64990923040120982373371975368352e-01,
                  0.64990923040120982373371975368356e-01,
                  0.27360580654059264445023332214042e-01,
                  0.27360580654059264445023332214038e-01,
                  0.21786329143033082541691103064740e-01,
                  0.21786329143033082541691103064711e-01,
                  0.38063320676460999592018145826503e-01,
                  0.21786329143033082541691103064716e-01,
                  0.21786329143033082541691103064740e-01,
                  0.38063320676460999592018145826496e-01,
                  0.21786329143033082541691103064728e-01,
                  0.21786329143033082541691103064726e-01,
                  0.38063320676460999592018145826500e-01,
                  0.12842218606220511469471667400655e-01,
                  0.12842218606220511469471667400716e-01,
                  0.12842218606220511469471667400702e-01,
                  0.12842218606220511469471667400653e-01,
                  0.12842218606220511469471667400670e-01,
                  0.12842218606220511469471667400694e-01,
                  0.81400892396225788443524008349648e-02,
                  0.81400892396225788443524008349700e-02,
                  0.81400892396225788443524008349671e-02]},
 12: {points: [[0.00000000000000000000000000000000e+00,
                  0.31197743874682493316405952658346e+00,
                  0.00000000000000000000000000000000e+00,
                  0.23159249092173243693844953226525e+00,
                  -0.23159249092173243693844953226523e+00,
                  -0.31197743874682493316405952658347e+00,
                  0.10902548045336982508174156740459e+00,
                  -0.12256701046836261185670796486065e+00,
                  0.35428352696617444247363819061472e+00,
                  0.12256701046836261185670796486065e+00,
                  -0.10902548045336982508174156740459e+00,
                  0.00000000000000000000000000000000e+00,
                  -0.35428352696617444247363819061471e+00,
                  0.20192321888374872888245356280351e+00,
                  0.21511093020495858840316962954555e+00,
                  0.41703414908870731728562319234907e+00,
                  -0.21511093020495858840316962954556e+00,
                  -0.20192321888374872888245356280351e+00,
                  -0.41703414908870731728562319234906e+00,
                  0.47168531101549306272128193341125e+00,
                  0.36955814642657920310176847152291e+00,
                  0.10212716458891385961951346188836e+00,
                  -0.10212716458891385961951346188834e+00,
                  -0.36955814642657920310176847152291e+00,
                  -0.47168531101549306272128193341126e+00,
                  0.48397802124170036239897643758983e+00,
                  0.52558118038968623864706766090148e+00,
                  0.58170567905854028823342845906758e+00,
                  0.41108795785253488485424621903712e+00,
                  0.61194663749155227693925263160327e+00,
                  0.31091521248698760641177287694349e+00,
                  0.27079046657155268182165558212408e+00,
                  0.00000000000000000000000000000000e+00,
                  0.11449322253715135379282144186437e+00,
                  0.36016658714765728409846176543126e+00,
                  -0.11449322253715135379282144186437e+00,
                  0.25178005034389499284079086617200e+00,
                  -0.27079046657155268182165558212408e+00,
                  -0.48397802124170036239897643758982e+00,
                  -0.31091521248698760641177287694350e+00,
                  -0.41108795785253488485424621903711e+00,
                  -0.52558118038968623864706766090148e+00,
                  -0.58170567905854028823342845906757e+00,
                  -0.25178005034389499284079086617199e+00,
                  -0.36016658714765728409846176543126e+00,
                  -0.61194663749155227693925263160326e+00,
                  0.71435255336334824271645194891381e+00,
                  0.68297991412123155511041213786393e+00,
                  0.60311801385665041051794124615185e+00,
                  0.52352900749669709543064960570673e+00,
                  0.45893184271021049643254223379124e+00,
                  0.25542071065313774628390971512255e+00,
                  0.15945090662453445967976253215718e+00,
                  0.00000000000000000000000000000000e+00,
                  -0.15945090662453445967976253215718e+00,
                  -0.25542071065313774628390971512256e+00,
                  -0.45893184271021049643254223379122e+00,
                  -0.52352900749669709543064960570675e+00,
                  -0.60311801385665041051794124615185e+00,
                  -0.68297991412123155511041213786393e+00,
                  -0.71435255336334824271645194891379e+00,
                  0.78501366469091053184283119523698e+00,
                  0.60058594477866687376002099318240e+00,
                  0.76800049932334971818122874161051e+00,
                  0.70185198807733322953661687541315e+00,
                  0.18442771991224365808281020205458e+00,
                  -0.18442771991224365808281020205457e+00,
                  0.66148511246016488644611866197344e-01,
                  -0.66148511246016488644611866197351e-01,
                  -0.60058594477866687376002099318238e+00,
                  -0.78501366469091053184283119523697e+00,
                  -0.70185198807733322953661687541317e+00,
                  -0.76800049932334971818122874161051e+00,
                  0.86443598587491174965776690739321e+00,
                  0.76091705943256581163958252966516e+00,
                  0.84540837848462116186610531085402e+00,
                  0.10351892644234593801818437772806e+00,
                  -0.00000000000000000000000000000000e+00,
                  -0.10351892644234593801818437772804e+00,
                  -0.76091705943256581163958252966517e+00,
                  -0.86443598587491174965776690739321e+00,
                  -0.84540837848462116186610531085403e+00,
                  0.93343806211458257947747327243320e+00,
                  0.89678637617904398640856480325155e+00,
                  0.97428768284410257985451821378170e+00,
                  0.36651685935538593068908469181666e-01,
                  -0.36651685935538593068908469181653e-01,
                  -0.89678637617904398640856480325155e+00,
                  -0.93343806211458257947747327243320e+00,
                  0.00000000000000000000000000000000e+00,
                  -0.97428768284410257985451821378170e+00],
                 [0.00000000000000000000000000000000e+00,
                  0.18012025824156935839014960181255e+00,
                  -0.36024051648313871678029920362507e+00,
                  -0.78182059993954824593030841771777e-02,
                  -0.78182059993954824593030841771719e-02,
                  0.18012025824156935839014960181253e+00,
                  0.20447408346363501656672802075934e+00,
                  -0.19665587746423953410742493658218e+00,
                  -0.20454568966337085291703849127819e+00,
                  -0.19665587746423953410742493658217e+00,
                  0.20447408346363501656672802075935e+00,
                  0.40909137932674170583407698255636e+00,
                  -0.20454568966337085291703849127817e+00,
                  -0.36496913169709533458731103995580e+00,
                  0.35735520301579974694616303159691e+00,
                  0.76139286812955876411480083589005e-02,
                  0.35735520301579974694616303159690e+00,
                  -0.36496913169709533458731103995581e+00,
                  0.76139286812955876411480083588993e-02,
                  0.15440134935362200477585689954436e+00,
                  0.33129078725456990357029327775675e+00,
                  -0.48569213660819190834615017730109e+00,
                  -0.48569213660819190834615017730109e+00,
                  0.33129078725456990357029327775675e+00,
                  0.15440134935362200477585689954435e+00,
                  0.27942484084575812053202901075108e+00,
                  -0.17123905027456248493005168144362e+00,
                  -0.23166032855441690584048627324026e-01,
                  -0.36954712883119866931222085606309e+00,
                  0.62576996200183438973585057591392e-01,
                  -0.49218887916265258411252072976751e+00,
                  0.51535491201809427469656935709153e+00,
                  -0.55884968169151624106405802150218e+00,
                  0.54078617910576115424227253750670e+00,
                  0.49867283572805934245057526888441e+00,
                  0.54078617910576115424227253750670e+00,
                  -0.56124983192824278142416032647581e+00,
                  0.51535491201809427469656935709154e+00,
                  0.27942484084575812053202901075109e+00,
                  -0.49218887916265258411252072976751e+00,
                  -0.36954712883119866931222085606308e+00,
                  -0.17123905027456248493005168144361e+00,
                  -0.23166032855441690584048627324024e-01,
                  -0.56124983192824278142416032647581e+00,
                  0.49867283572805934245057526888442e+00,
                  0.62576996200183438973585057591402e-01,
                  -0.11749720687623642965332753119146e+00,
                  -0.21020058954459082058144649610552e+00,
                  -0.34821034765324955641830052962122e+00,
                  -0.48637766113120537768015087965347e+00,
                  -0.55989885503282020277374858682557e+00,
                  0.67739606190905663242707611801704e+00,
                  0.69657825067579619826159737575897e+00,
                  0.69642069530649911283660105924244e+00,
                  0.69657825067579619826159737575896e+00,
                  0.67739606190905663242707611801704e+00,
                  -0.55989885503282020277374858682557e+00,
                  -0.48637766113120537768015087965346e+00,
                  -0.34821034765324955641830052962122e+00,
                  -0.21020058954459082058144649610551e+00,
                  -0.11749720687623642965332753119144e+00,
                  -0.24026906315210625418614842033408e+00,
                  -0.55970724436419459350422699953710e+00,
                  -0.36702357347334174577346477812726e+00,
                  -0.48159615579648356651417480452243e+00,
                  0.79997630751630084769037541987117e+00,
                  0.79997630751630084769037541987118e+00,
                  0.84861972926982531228763958264969e+00,
                  0.84861972926982531228763958264967e+00,
                  -0.55970724436419459350422699953709e+00,
                  -0.24026906315210625418614842033406e+00,
                  -0.48159615579648356651417480452243e+00,
                  -0.36702357347334174577346477812726e+00,
                  -0.37954898904666084195961773295668e+00,
                  -0.55884902918978932958057452189329e+00,
                  -0.48809675489326105025907453820491e+00,
                  0.93839801823645017154019225484994e+00,
                  0.97619350978652210051814907640982e+00,
                  0.93839801823645017154019225484997e+00,
                  -0.55884902918978932958057452189329e+00,
                  -0.37954898904666084195961773295667e+00,
                  -0.48809675489326105025907453820491e+00,
                  -0.49659899495142321256586597769787e+00,
                  -0.56008157717483369456874066333188e+00,
                  -0.56250525595817935625376010176970e+00,
                  0.10566805721262569071346066410297e+01,
                  0.10566805721262569071346066410298e+01,
                  -0.56008157717483369456874066333188e+00,
                  -0.49659899495142321256586597769787e+00,
                  0.11250105119163587125075202035394e+01,
                  -0.56250525595817935625376010176970e+00],
                 []],
      quad_degree: 20,
      weights: [0.12738549441256562814034707748279e+00,
                  0.76014293823409287046342395951623e-01,
                  0.76014293823409287046342395951620e-01,
                  0.11666988683188333661770319927333e+00,
                  0.11666988683188333661770319927332e+00,
                  0.76014293823409287046342395951617e-01,
                  0.11666988683188333661770319927332e+00,
                  0.11666988683188333661770319927332e+00,
                  0.10223907344734270977466584574959e+00,
                  0.11666988683188333661770319927332e+00,
                  0.11666988683188333661770319927332e+00,
                  0.10223907344734270977466584574959e+00,
                  0.10223907344734270977466584574959e+00,
                  0.80546443555011216094910523558369e-01,
                  0.80546443555011216094910523558361e-01,
                  0.80546443555011216094910523558372e-01,
                  0.80546443555011216094910523558369e-01,
                  0.80546443555011216094910523558367e-01,
                  0.80546443555011216094910523558366e-01,
                  0.54017164379517715120296578928411e-01,
                  0.54017164379517715120296578928404e-01,
                  0.54017164379517715120296578928406e-01,
                  0.54017164379517715120296578928410e-01,
                  0.54017164379517715120296578928409e-01,
                  0.54017164379517715120296578928410e-01,
                  0.31749029031704928691491965812313e-01,
                  0.78872328175585548911890286020425e-01,
                  0.55199580865492352076752255038801e-01,
                  0.78872328175585548911890286020422e-01,
                  0.26325473344694177951633398656074e-01,
                  0.55199580865492352076752255038796e-01,
                  0.55199580865492352076752255038797e-01,
                  0.31749029031704928691491965812313e-01,
                  0.78872328175585548911890286020420e-01,
                  0.26325473344694177951633398656076e-01,
                  0.78872328175585548911890286020426e-01,
                  0.26325473344694177951633398656074e-01,
                  0.55199580865492352076752255038797e-01,
                  0.31749029031704928691491965812313e-01,
                  0.55199580865492352076752255038801e-01,
                  0.78872328175585548911890286020425e-01,
                  0.78872328175585548911890286020425e-01,
                  0.55199580865492352076752255038800e-01,
                  0.26325473344694177951633398656073e-01,
                  0.26325473344694177951633398656075e-01,
                  0.26325473344694177951633398656074e-01,
                  0.18948328557377300311498537786600e-01,
                  0.52604781473330174009683604306044e-01,
                  0.76370045879361257176018458958366e-01,
                  0.52604781473330174009683604306041e-01,
                  0.18948328557377300311498537786601e-01,
                  0.18948328557377300311498537786604e-01,
                  0.52604781473330174009683604306047e-01,
                  0.76370045879361257176018458958367e-01,
                  0.52604781473330174009683604306042e-01,
                  0.18948328557377300311498537786603e-01,
                  0.18948328557377300311498537786599e-01,
                  0.52604781473330174009683604306046e-01,
                  0.76370045879361257176018458958368e-01,
                  0.52604781473330174009683604306045e-01,
                  0.18948328557377300311498537786599e-01,
                  0.17649023796193195581441984711836e-01,
                  0.17649023796193195581441984711835e-01,
                  0.45589221984417358983234881697521e-01,
                  0.45589221984417358983234881697523e-01,
                  0.17649023796193195581441984711830e-01,
                  0.17649023796193195581441984711836e-01,
                  0.45589221984417358983234881697523e-01,
                  0.45589221984417358983234881697523e-01,
                  0.17649023796193195581441984711840e-01,
                  0.17649023796193195581441984711838e-01,
                  0.45589221984417358983234881697522e-01,
                  0.45589221984417358983234881697522e-01,
                  0.19666443532211699346161038976631e-01,
                  0.19666443532211699346161038976631e-01,
                  0.29216413001563124640276033200942e-01,
                  0.19666443532211699346161038976630e-01,
                  0.29216413001563124640276033200941e-01,
                  0.19666443532211699346161038976630e-01,
                  0.19666443532211699346161038976632e-01,
                  0.19666443532211699346161038976632e-01,
                  0.29216413001563124640276033200940e-01,
                  0.12463681522202634796195355312546e-01,
                  0.12463681522202634796195355312545e-01,
                  0.45159686131151583506618206088391e-02,
                  0.12463681522202634796195355312548e-01,
                  0.12463681522202634796195355312544e-01,
                  0.12463681522202634796195355312545e-01,
                  0.12463681522202634796195355312545e-01,
                  0.45159686131151583506618206088404e-02,
                  0.45159686131151583506618206088395e-02]},
 13: {points: [[-.9825425959875156e+00,
                  -.9279159694806831e+00,
                  -.8331291383910357e+00,
                  -.7021632691023338e+00,
                  -.5360569324096675e+00,
                  -.3362552646035682e+00,
                  -.1144273322270078e+00,
                  0.1144273322270153e+00,
                  0.3362552646035705e+00,
                  0.5360569324096654e+00,
                  0.7021632691023329e+00,
                  0.8331291383910360e+00,
                  0.9279159694806717e+00,
                  0.9825425959875129e+00,
                  -.9531454473237611e+00,
                  -.8889272412955139e+00,
                  -.7803754479323956e+00,
                  -.6275212659185905e+00,
                  -.4401353758135459e+00,
                  -.2267143428046406e+00,
                  0.8938917188650806e-16,
                  0.2267143428046396e+00,
                  0.4401353758135431e+00,
                  0.6275212659185897e+00,
                  0.7803754479324088e+00,
                  0.8889272412955204e+00,
                  0.9531454473237707e+00,
                  -.9051799681643390e+00,
                  -.8291863198470316e+00,
                  -.6995801072700498e+00,
                  -.5321791232334823e+00,
                  -.3353104853918589e+00,
                  -.1147531434044246e+00,
                  0.1147531434044263e+00,
                  0.3353104853918582e+00,
                  0.5321791232334743e+00,
                  0.6995801072700447e+00,
                  0.8291863198470180e+00,
                  0.9051799681643370e+00,
                  -.8386295197357204e+00,
                  -.7484812422289556e+00,
                  -.6090918724988131e+00,
                  -.4364798983369578e+00,
                  -.2291502560103772e+00,
                  0.4215111672713349e-15,
                  0.2291502560103789e+00,
                  0.4364798983369575e+00,
                  0.6090918724988169e+00,
                  0.7484812422289550e+00,
                  0.8386295197357210e+00,
                  -.7553456262980742e+00,
                  -.6539608855877995e+00,
                  -.5080577820743343e+00,
                  -.3261895572925157e+00,
                  -.1125404899394593e+00,
                  0.1125404899394596e+00,
                  0.3261895572925122e+00,
                  0.5080577820743336e+00,
                  0.6539608855878011e+00,
                  0.7553456262980772e+00,
                  -.6553067244554373e+00,
                  -.5460505678908963e+00,
                  -.3947384160459905e+00,
                  -.2082797591646160e+00,
                  0.1650889308488639e-14,
                  0.2082797591646145e+00,
                  0.3947384160459889e+00,
                  0.5460505678908972e+00,
                  0.6553067244554393e+00,
                  -.5441393706467022e+00,
                  -.4318500843322787e+00,
                  -.2799852726415643e+00,
                  -.9703930128213939e-01,
                  0.9703930128213846e-01,
                  0.2799852726415643e+00,
                  0.4318500843322786e+00,
                  0.5441393706467017e+00,
                  -.4297120384196906e+00,
                  -.3193362250862562e+00,
                  -.1727472966824697e+00,
                  -.3919721698724594e-14,
                  0.1727472966824728e+00,
                  0.3193362250862564e+00,
                  0.4297120384196897e+00,
                  -.3190514598518672e+00,
                  -.2138255097742529e+00,
                  -.7691274926532071e-01,
                  0.7691274926532407e-01,
                  0.2138255097742526e+00,
                  0.3190514598518688e+00,
                  -.2192886938884063e+00,
                  -.1209599763103660e+00,
                  0.7959390969365006e-14,
                  0.1209599763103612e+00,
                  0.2192886938884099e+00,
                  -.1364662506333881e+00,
                  -.4881087191464658e-01,
                  0.4881087191464119e-01,
                  0.1364662506333899e+00,
                  -.7205082977330277e-01,
                  -.1501836395852960e-13,
                  0.7205082977330659e-01,
                  -.2522947784306911e-01,
                  0.2522947784307261e-01,
                  0.5376558853537703e-14],
                 [-.5672712322836677e+00,
                  -.5648650264134480e+00,
                  -.5642044642496930e+00,
                  -.5629718055082698e+00,
                  -.5627053871211118e+00,
                  -.5625459599969370e+00,
                  -.5622533731751780e+00,
                  -.5622533731751781e+00,
                  -.5625459599969373e+00,
                  -.5627053871211120e+00,
                  -.5629718055082698e+00,
                  -.5642044642496942e+00,
                  -.5648650264134431e+00,
                  -.5672712322836715e+00,
                  -.5211662889408181e+00,
                  -.5132223820519531e+00,
                  -.5069119150113438e+00,
                  -.5019721215682301e+00,
                  -.5010167089613743e+00,
                  -.4996312978785062e+00,
                  -.4986575248776085e+00,
                  -.4996312978785076e+00,
                  -.5010167089613759e+00,
                  -.5019721215682300e+00,
                  -.5069119150113488e+00,
                  -.5132223820519409e+00,
                  -.5211662889408247e+00,
                  -.4394087663548314e+00,
                  -.4223690048934392e+00,
                  -.4039027632520731e+00,
                  -.3960649530408457e+00,
                  -.3930629954859036e+00,
                  -.3895519032923774e+00,
                  -.3895519032923791e+00,
                  -.3930629954859074e+00,
                  -.3960649530408455e+00,
                  -.4039027632520786e+00,
                  -.4223690048934283e+00,
                  -.4394087663548313e+00,
                  -.3266053258928140e+00,
                  -.2924632969163533e+00,
                  -.2628481635635045e+00,
                  -.2520017868006980e+00,
                  -.2443512954268930e+00,
                  -.2405007500408841e+00,
                  -.2443512954268975e+00,
                  -.2520017868006985e+00,
                  -.2628481635635107e+00,
                  -.2924632969163528e+00,
                  -.3266053258928154e+00,
                  -.1828862277809739e+00,
                  -.1306600620780524e+00,
                  -.9385590076168800e-01,
                  -.7627429527524318e-01,
                  -.6497528216127921e-01,
                  -.6497528216128187e-01,
                  -.7627429527524277e-01,
                  -.9385590076169102e-01,
                  -.1306600620780567e+00,
                  -.1828862277809794e+00,
                  -.9932621304481306e-02,
                  0.5347526866814350e-01,
                  0.9539681429383898e-01,
                  0.1202503750204398e+00,
                  0.1299505643225554e+00,
                  0.1202503750204438e+00,
                  0.9539681429383982e-01,
                  0.5347526866814024e-01,
                  -.9932621304485118e-02,
                  0.1820297099917149e+00,
                  0.2493287624388051e+00,
                  0.2941550889985390e+00,
                  0.3206255907021339e+00,
                  0.3206255907021422e+00,
                  0.2941550889985421e+00,
                  0.2493287624388056e+00,
                  0.1820297099917156e+00,
                  0.3802236631834622e+00,
                  0.4461560292103645e+00,
                  0.4869188962475950e+00,
                  0.5040035736014014e+00,
                  0.4869188962475929e+00,
                  0.4461560292103665e+00,
                  0.3802236631834641e+00,
                  0.5724785813014180e+00,
                  0.6316767710394283e+00,
                  0.6589131166043619e+00,
                  0.6589131166043422e+00,
                  0.6316767710394284e+00,
                  0.5724785813014156e+00,
                  0.7455916149020857e+00,
                  0.7944354184845834e+00,
                  0.8078055265041430e+00,
                  0.7944354184845860e+00,
                  0.7455916149020788e+00,
                  0.8895771314010835e+00,
                  0.9292809199047640e+00,
                  0.9292809199048019e+00,
                  0.8895771314010798e+00,
                  0.1003613230604524e+01,
                  0.1026444764103913e+01,
                  0.1003613230604525e+01,
                  0.1086031315354281e+01,
                  0.1086031315354253e+01,
                  0.1134542464567334e+01],
                 []],
      quad_degree: 22,
      weights: [0.2136522852572769e-02,
                  0.6256961579111999e-02,
                  0.1002850344631184e-01,
                  0.1430579772532512e-01,
                  0.1814627863116503e-01,
                  0.2126781817964112e-01,
                  0.2314482496409111e-01,
                  0.2314482496409053e-01,
                  0.2126781817963999e-01,
                  0.1814627863116457e-01,
                  0.1430579772532544e-01,
                  0.1002850344631053e-01,
                  0.6256961579113827e-02,
                  0.2136522852572835e-02,
                  0.6256961579111185e-02,
                  0.1522288958798713e-01,
                  0.2683567162881997e-01,
                  0.3758541016429025e-01,
                  0.4525212264149067e-01,
                  0.5067341109316087e-01,
                  0.5279285518281329e-01,
                  0.5067341109315953e-01,
                  0.4525212264148970e-01,
                  0.3758541016429198e-01,
                  0.2683567162882085e-01,
                  0.1522288958798741e-01,
                  0.6256961579109348e-02,
                  0.1002850344631337e-01,
                  0.2683567162882019e-01,
                  0.4602106505669317e-01,
                  0.5975771771828680e-01,
                  0.7080355942521726e-01,
                  0.7811959201388597e-01,
                  0.7811959201388512e-01,
                  0.7080355942521471e-01,
                  0.5975771771828566e-01,
                  0.4602106505669305e-01,
                  0.2683567162881975e-01,
                  0.1002850344631489e-01,
                  0.1430579772532468e-01,
                  0.3758541016428882e-01,
                  0.5975771771828660e-01,
                  0.7873658000752331e-01,
                  0.9489828540747137e-01,
                  0.1009624272742807e+00,
                  0.9489828540747140e-01,
                  0.7873658000752363e-01,
                  0.5975771771828717e-01,
                  0.3758541016428670e-01,
                  0.1430579772532427e-01,
                  0.1814627863116408e-01,
                  0.4525212264148985e-01,
                  0.7080355942521741e-01,
                  0.9489828540746970e-01,
                  0.1096471221047843e+00,
                  0.1096471221047845e+00,
                  0.9489828540747060e-01,
                  0.7080355942521960e-01,
                  0.4525212264148989e-01,
                  0.1814627863116402e-01,
                  0.2126781817964041e-01,
                  0.5067341109316018e-01,
                  0.7811959201388544e-01,
                  0.1009624272742783e+00,
                  0.1096471221047841e+00,
                  0.1009624272742795e+00,
                  0.7811959201388666e-01,
                  0.5067341109316147e-01,
                  0.2126781817964116e-01,
                  0.2314482496409079e-01,
                  0.5279285518281303e-01,
                  0.7811959201388603e-01,
                  0.9489828540746975e-01,
                  0.9489828540747050e-01,
                  0.7811959201388504e-01,
                  0.5279285518281366e-01,
                  0.2314482496409137e-01,
                  0.2314482496409109e-01,
                  0.5067341109316084e-01,
                  0.7080355942521932e-01,
                  0.7873658000752322e-01,
                  0.7080355942521524e-01,
                  0.5067341109316000e-01,
                  0.2314482496409063e-01,
                  0.2126781817964101e-01,
                  0.4525212264149032e-01,
                  0.5975771771828729e-01,
                  0.5975771771828619e-01,
                  0.4525212264149043e-01,
                  0.2126781817964008e-01,
                  0.1814627863116444e-01,
                  0.3758541016428754e-01,
                  0.4602106505669299e-01,
                  0.3758541016429198e-01,
                  0.1814627863116470e-01,
                  0.1430579772532476e-01,
                  0.2683567162881992e-01,
                  0.2683567162882044e-01,
                  0.1430579772532575e-01,
                  0.1002850344631470e-01,
                  0.1522288958798709e-01,
                  0.1002850344631105e-01,
                  0.6256961579109350e-02,
                  0.6256961579113495e-02,
                  0.2136522852572517e-02]},
 14: {points: [[-.9859586567845876e+00,
                  -.9339480708382410e+00,
                  -.8515364672484503e+00,
                  -.7373904342281085e+00,
                  -.5937725010484597e+00,
                  -.4138120395258084e+00,
                  -.2109850789338238e+00,
                  -.6289809743618028e-15,
                  0.2109850789338226e+00,
                  0.4138120395258079e+00,
                  0.5937725010484609e+00,
                  0.7373904342281083e+00,
                  0.8515364672484444e+00,
                  0.9339480708382383e+00,
                  0.9859586567845870e+00,
                  -.9558266549685945e+00,
                  -.8924452752147827e+00,
                  -.8192638712956546e+00,
                  -.6824108451023607e+00,
                  -.5138889262206081e+00,
                  -.3179822756356984e+00,
                  -.1072899754799716e+00,
                  0.1072899754799672e+00,
                  0.3179822756356936e+00,
                  0.5138889262206046e+00,
                  0.6824108451023609e+00,
                  0.8192638712956548e+00,
                  0.8924452752147826e+00,
                  0.9558266549685941e+00,
                  -.9188292218463335e+00,
                  -.8656972799921448e+00,
                  -.7567080936347805e+00,
                  -.5967589980567139e+00,
                  -.4179073900111859e+00,
                  -.2155272535619442e+00,
                  0.1346354477786078e-14,
                  0.2155272535619453e+00,
                  0.4179073900111847e+00,
                  0.5967589980567136e+00,
                  0.7567080936347807e+00,
                  0.8656972799921462e+00,
                  0.9188292218463381e+00,
                  -.8577961152130768e+00,
                  -.7836362472132090e+00,
                  -.6592612172386821e+00,
                  -.4981516212507552e+00,
                  -.3165535858832276e+00,
                  -.1087526896421105e+00,
                  0.1087526896421119e+00,
                  0.3165535858832258e+00,
                  0.4981516212507511e+00,
                  0.6592612172386771e+00,
                  0.7836362472132038e+00,
                  0.8577961152130766e+00,
                  -.7856755658388399e+00,
                  -.6986793585430978e+00,
                  -.5685648368444979e+00,
                  -.4043730517221430e+00,
                  -.2124245714648165e+00,
                  0.3208727475196736e-14,
                  0.2124245714648222e+00,
                  0.4043730517221479e+00,
                  0.5685648368445014e+00,
                  0.6986793585430981e+00,
                  0.7856755658388388e+00,
                  -.6956905417364665e+00,
                  -.6002159703840300e+00,
                  -.4652369100706387e+00,
                  -.2960814896256622e+00,
                  -.1019565801090090e+00,
                  0.1019565801090105e+00,
                  0.2960814896256639e+00,
                  0.4652369100706415e+00,
                  0.6002159703840323e+00,
                  0.6956905417364659e+00,
                  -.5940942361723113e+00,
                  -.4938967992132740e+00,
                  -.3559130666663906e+00,
                  -.1873287999835536e+00,
                  -.8912456948141817e-15,
                  0.1873287999835524e+00,
                  0.3559130666663909e+00,
                  0.4938967992132759e+00,
                  0.5940942361723113e+00,
                  -.4884913799931887e+00,
                  -.3866068237333056e+00,
                  -.2497096565086977e+00,
                  -.8781946583892241e-01,
                  0.8781946583891979e-01,
                  0.2497096565086966e+00,
                  0.3866068237333067e+00,
                  0.4884913799931890e+00,
                  -.3831091572384891e+00,
                  -.2822336947483356e+00,
                  -.1506574468333163e+00,
                  -.1019071959132476e-14,
                  0.1506574468333144e+00,
                  0.2822336947483357e+00,
                  0.3831091572384891e+00,
                  -.2818785022106577e+00,
                  -.1847904323224886e+00,
                  -.6250221918196253e-01,
                  0.6250221918196113e-01,
                  0.1847904323224880e+00,
                  0.2818785022106572e+00,
                  -.1919030647903752e+00,
                  -.1012254021108377e+00,
                  -.8060644739879229e-15,
                  0.1012254021108371e+00,
                  0.1919030647903743e+00,
                  -.1204056809849647e+00,
                  -.4643340869648831e-01,
                  0.4643340869648813e-01,
                  0.1204056809849638e+00,
                  -.6729275459789318e-01,
                  0.1912538155151479e-14,
                  0.6729275459789113e-01,
                  -.2187858413035581e-01,
                  0.2187858413035478e-01,
                  -.5386732877601518e-15],
                 [-.5692434959044235e+00,
                  -.5644783829818853e+00,
                  -.5693377885538829e+00,
                  -.5647650703567143e+00,
                  -.5644052855478030e+00,
                  -.5643997506743176e+00,
                  -.5641886422387411e+00,
                  -.5640612594717579e+00,
                  -.5641886422387411e+00,
                  -.5643997506743175e+00,
                  -.5644052855478030e+00,
                  -.5647650703567143e+00,
                  -.5693377885538821e+00,
                  -.5644783829818861e+00,
                  -.5692434959044232e+00,
                  -.5265835636704392e+00,
                  -.5152535198822665e+00,
                  -.5266188986505037e+00,
                  -.5108751114328099e+00,
                  -.5100715215771487e+00,
                  -.5094825517104679e+00,
                  -.5083590037306493e+00,
                  -.5083590037306492e+00,
                  -.5094825517104674e+00,
                  -.5100715215771482e+00,
                  -.5108751114328103e+00,
                  -.5266188986505021e+00,
                  -.5152535198822668e+00,
                  -.5265835636704406e+00,
                  -.4527833186090652e+00,
                  -.4461938756195775e+00,
                  -.4368856215580110e+00,
                  -.4167103143086820e+00,
                  -.4152431790885650e+00,
                  -.4127745926707803e+00,
                  -.4109730096958922e+00,
                  -.4127745926707797e+00,
                  -.4152431790885636e+00,
                  -.4167103143086823e+00,
                  -.4368856215580100e+00,
                  -.4461938756195759e+00,
                  -.4527833186090699e+00,
                  -.3562163133708256e+00,
                  -.3355475719602546e+00,
                  -.3084532950997225e+00,
                  -.2876079726263676e+00,
                  -.2841674825070052e+00,
                  -.2790970608349187e+00,
                  -.2790970608349181e+00,
                  -.2841674825070034e+00,
                  -.2876079726263667e+00,
                  -.3084532950997214e+00,
                  -.3355475719602510e+00,
                  -.3562163133708264e+00,
                  -.2320194272026907e+00,
                  -.1900051040419803e+00,
                  -.1542968266346533e+00,
                  -.1320597057804273e+00,
                  -.1226433835177065e+00,
                  -.1177293179431822e+00,
                  -.1226433835177047e+00,
                  -.1320597057804259e+00,
                  -.1542968266346539e+00,
                  -.1900051040419794e+00,
                  -.2320194272026887e+00,
                  -.7617186328404182e-01,
                  -.2063945279846321e-01,
                  0.1973521954285725e-01,
                  0.4536593845750682e-01,
                  0.5886465897158658e-01,
                  0.5886465897158809e-01,
                  0.4536593845750900e-01,
                  0.1973521954285707e-01,
                  -.2063945279846460e-01,
                  -.7617186328404025e-01,
                  0.9937588294321486e-01,
                  0.1612636575282626e+00,
                  0.2054865048479446e+00,
                  0.2337311223774097e+00,
                  0.2452867670354037e+00,
                  0.2337311223774119e+00,
                  0.2054865048479453e+00,
                  0.1612636575282604e+00,
                  0.9937588294321524e-01,
                  0.2820306297358779e+00,
                  0.3470953462023870e+00,
                  0.3930393731279204e+00,
                  0.4162271882874323e+00,
                  0.4162271882874328e+00,
                  0.3930393731279213e+00,
                  0.3470953462023850e+00,
                  0.2820306297358775e+00,
                  0.4648127592955250e+00,
                  0.5301220045089315e+00,
                  0.5695400057232176e+00,
                  0.5752159452527457e+00,
                  0.5695400057232177e+00,
                  0.5301220045089304e+00,
                  0.4648127592955248e+00,
                  0.6405716139583596e+00,
                  0.7000766256191295e+00,
                  0.7251636094084096e+00,
                  0.7251636094084107e+00,
                  0.7000766256191290e+00,
                  0.6405716139583603e+00,
                  0.7964247127504945e+00,
                  0.8464226833930654e+00,
                  0.8737712431160211e+00,
                  0.8464226833930661e+00,
                  0.7964247127504958e+00,
                  0.9209813837275408e+00,
                  0.9728127742700782e+00,
                  0.9728127742700750e+00,
                  0.9209813837275428e+00,
                  0.1022121107162950e+01,
                  0.1030507039764527e+01,
                  0.1022121107162951e+01,
                  0.1091061946652324e+01,
                  0.1091061946652328e+01,
                  0.1138486991808847e+01],
                 []],
      quad_degree: 24,
      weights: [0.1540556143560955e-02,
                  0.5961783247021258e-02,
                  0.5746819899875396e-02,
                  0.1058549229776579e-01,
                  0.1420648249390866e-01,
                  0.1694963731153820e-01,
                  0.1850816826880023e-01,
                  0.1897566336448255e-01,
                  0.1850816826880029e-01,
                  0.1694963731153848e-01,
                  0.1420648249390879e-01,
                  0.1058549229776542e-01,
                  0.5746819899875648e-02,
                  0.5961783247021246e-02,
                  0.1540556143561047e-02,
                  0.5961783247021253e-02,
                  0.1105564953945464e-01,
                  0.1730958282987375e-01,
                  0.2927081620744745e-01,
                  0.3639636942956808e-01,
                  0.4099383565430112e-01,
                  0.4340405474280182e-01,
                  0.4340405474280178e-01,
                  0.4099383565430139e-01,
                  0.3639636942956890e-01,
                  0.2927081620744784e-01,
                  0.1730958282987368e-01,
                  0.1105564953945456e-01,
                  0.5961783247021338e-02,
                  0.5746819899876535e-02,
                  0.1730958282987309e-01,
                  0.3569141070733967e-01,
                  0.4836706771502406e-01,
                  0.5703270538345387e-01,
                  0.6382713310111043e-01,
                  0.6654628035026888e-01,
                  0.6382713310110990e-01,
                  0.5703270538345391e-01,
                  0.4836706771502444e-01,
                  0.3569141070733997e-01,
                  0.1730958282987383e-01,
                  0.5746819899875787e-02,
                  0.1058549229776458e-01,
                  0.2927081620744680e-01,
                  0.4836706771502410e-01,
                  0.6208540728799279e-01,
                  0.7503044602815588e-01,
                  0.8391663703305283e-01,
                  0.8391663703305235e-01,
                  0.7503044602815482e-01,
                  0.6208540728799259e-01,
                  0.4836706771502411e-01,
                  0.2927081620744755e-01,
                  0.1058549229776549e-01,
                  0.1420648249390865e-01,
                  0.3639636942956972e-01,
                  0.5703270538345507e-01,
                  0.7503044602815513e-01,
                  0.9146215357625047e-01,
                  0.9730018704643734e-01,
                  0.9146215357625031e-01,
                  0.7503044602815462e-01,
                  0.5703270538345388e-01,
                  0.3639636942956859e-01,
                  0.1420648249390875e-01,
                  0.1694963731153879e-01,
                  0.4099383565430213e-01,
                  0.6382713310110992e-01,
                  0.8391663703305160e-01,
                  0.9730018704643719e-01,
                  0.9730018704643722e-01,
                  0.8391663703305176e-01,
                  0.6382713310110968e-01,
                  0.4099383565430108e-01,
                  0.1694963731153834e-01,
                  0.1850816826880038e-01,
                  0.4340405474280176e-01,
                  0.6654628035026823e-01,
                  0.8391663703305207e-01,
                  0.9146215357625052e-01,
                  0.8391663703305213e-01,
                  0.6654628035026845e-01,
                  0.4340405474280142e-01,
                  0.1850816826880002e-01,
                  0.1897566336448252e-01,
                  0.4340405474280183e-01,
                  0.6382713310111034e-01,
                  0.7503044602815600e-01,
                  0.7503044602815592e-01,
                  0.6382713310111059e-01,
                  0.4340405474280207e-01,
                  0.1897566336448244e-01,
                  0.1850816826880050e-01,
                  0.4099383565430194e-01,
                  0.5703270538345487e-01,
                  0.6208540728799271e-01,
                  0.5703270538345529e-01,
                  0.4099383565430244e-01,
                  0.1850816826880065e-01,
                  0.1694963731153876e-01,
                  0.3639636942956906e-01,
                  0.4836706771502384e-01,
                  0.4836706771502417e-01,
                  0.3639636942956961e-01,
                  0.1694963731153899e-01,
                  0.1420648249390866e-01,
                  0.2927081620744674e-01,
                  0.3569141070733962e-01,
                  0.2927081620744681e-01,
                  0.1420648249390889e-01,
                  0.1058549229776476e-01,
                  0.1730958282987322e-01,
                  0.1730958282987254e-01,
                  0.1058549229776467e-01,
                  0.5746819899875356e-02,
                  0.1105564953945472e-01,
                  0.5746819899875902e-02,
                  0.5961783247021613e-02,
                  0.5961783247021232e-02,
                  0.1540556143561009e-02]},
 15: {points: [[-.9828569834252944e+00,
                  -.9422997138612665e+00,
                  -.8776724000399618e+00,
                  -.7777797466915631e+00,
                  -.6405356140312989e+00,
                  -.4748718214082883e+00,
                  -.2902477629736029e+00,
                  -.9724225887213769e-01,
                  0.9724225887213799e-01,
                  0.2902477629736013e+00,
                  0.4748718214082880e+00,
                  0.6405356140313012e+00,
                  0.7777797466915603e+00,
                  0.8776724000399537e+00,
                  0.9422997138612651e+00,
                  0.9828569834252944e+00,
                  -.9639157296835477e+00,
                  -.9182517141987618e+00,
                  -.8304444192486729e+00,
                  -.7073043091828405e+00,
                  -.5549260024081961e+00,
                  -.3807615176079554e+00,
                  -.1929188912547799e+00,
                  -.2589439295557781e-14,
                  0.1929188912547731e+00,
                  0.3807615176079504e+00,
                  0.5549260024081997e+00,
                  0.7073043091828463e+00,
                  0.8304444192486770e+00,
                  0.9182517141987608e+00,
                  0.9639157296835477e+00,
                  -.9300709967353243e+00,
                  -.8685745048404347e+00,
                  -.7700330026868825e+00,
                  -.6352132092080558e+00,
                  -.4745864823526536e+00,
                  -.2937771840155956e+00,
                  -.9947676468812618e-01,
                  0.9947676468812877e-01,
                  0.2937771840155924e+00,
                  0.4745864823526503e+00,
                  0.6352132092080527e+00,
                  0.7700330026868829e+00,
                  0.8685745048404306e+00,
                  0.9300709967353288e+00,
                  -.8794325150240040e+00,
                  -.8029599285358476e+00,
                  -.6939462291945384e+00,
                  -.5514302266139028e+00,
                  -.3868384488427142e+00,
                  -.2002678253364635e+00,
                  0.2669348630733586e-14,
                  0.2002678253364667e+00,
                  0.3868384488427168e+00,
                  0.5514302266139029e+00,
                  0.6939462291945413e+00,
                  0.8029599285358416e+00,
                  0.8794325150240055e+00,
                  -.8102835225283573e+00,
                  -.7251304600178632e+00,
                  -.6112570691713974e+00,
                  -.4659776836532520e+00,
                  -.2949470081733491e+00,
                  -.1010314015505754e+00,
                  0.1010314015505701e+00,
                  0.2949470081733437e+00,
                  0.4659776836532432e+00,
                  0.6112570691713934e+00,
                  0.7251304600178527e+00,
                  0.8102835225283528e+00,
                  -.7273629759403750e+00,
                  -.6378746453133168e+00,
                  -.5198925525531858e+00,
                  -.3695435652623997e+00,
                  -.1928928446529371e+00,
                  0.1370324722860368e-14,
                  0.1928928446529416e+00,
                  0.3695435652624020e+00,
                  0.5198925525531904e+00,
                  0.6378746453133160e+00,
                  0.7273629759403732e+00,
                  -.6350131700375503e+00,
                  -.5433801159337577e+00,
                  -.4210769153452890e+00,
                  -.2675910941186692e+00,
                  -.9186144310236617e-01,
                  0.9186144310236670e-01,
                  0.2675910941186695e+00,
                  0.4210769153452911e+00,
                  0.5433801159337621e+00,
                  0.6350131700375533e+00,
                  -.5383628790116354e+00,
                  -.4464070530944503e+00,
                  -.3216001506571641e+00,
                  -.1692757399259417e+00,
                  -.9806844075165197e-15,
                  0.1692757399259386e+00,
                  0.3216001506571607e+00,
                  0.4464070530944526e+00,
                  0.5383628790116402e+00,
                  -.4411206201394943e+00,
                  -.3504612246789842e+00,
                  -.2261153685375975e+00,
                  -.7913923481054134e-01,
                  0.7913923481054092e-01,
                  0.2261153685375928e+00,
                  0.3504612246789840e+00,
                  0.4411206201394980e+00,
                  -.3447654070639419e+00,
                  -.2571131277053684e+00,
                  -.1366705868187449e+00,
                  0.2218246659617388e-14,
                  0.1366705868187429e+00,
                  0.2571131277053677e+00,
                  0.3447654070639446e+00,
                  -.2524911545320824e+00,
                  -.1702044576096658e+00,
                  -.5873301998647497e-01,
                  0.5873301998647471e-01,
                  0.1702044576096656e+00,
                  0.2524911545320846e+00,
                  -.1697479084970549e+00,
                  -.9565561935300174e-01,
                  -.3247556007505294e-14,
                  0.9565561935300220e-01,
                  0.1697479084970567e+00,
                  -.1016527683324407e+00,
                  -.3813008559176926e-01,
                  0.3813008559176809e-01,
                  0.1016527683324433e+00,
                  -.5239859669536701e-01,
                  0.3440404557980889e-14,
                  0.5239859669536901e-01,
                  -.2161601582227183e-01,
                  0.2161601582227079e-01,
                  -.1881805065862662e-14],
                 [-.5674527439554999e+00,
                  -.5689970185627022e+00,
                  -.5672290842378366e+00,
                  -.5664298524438254e+00,
                  -.5658214105168153e+00,
                  -.5657190459948397e+00,
                  -.5656754252357741e+00,
                  -.5655050619016993e+00,
                  -.5655050619016992e+00,
                  -.5656754252357739e+00,
                  -.5657190459948398e+00,
                  -.5658214105168158e+00,
                  -.5664298524438248e+00,
                  -.5672290842378364e+00,
                  -.5689970185627025e+00,
                  -.5674527439554986e+00,
                  -.5315569809013205e+00,
                  -.5301528743764877e+00,
                  -.5234861393615067e+00,
                  -.5188159284716055e+00,
                  -.5169218557071216e+00,
                  -.5167214316737625e+00,
                  -.5160595386155843e+00,
                  -.5154664645444581e+00,
                  -.5160595386155836e+00,
                  -.5167214316737620e+00,
                  -.5169218557071236e+00,
                  -.5188159284716053e+00,
                  -.5234861393615056e+00,
                  -.5301528743764866e+00,
                  -.5315569809013210e+00,
                  -.4764720525161410e+00,
                  -.4574428938196112e+00,
                  -.4445787613861698e+00,
                  -.4345595671280966e+00,
                  -.4318162335202727e+00,
                  -.4307078740593590e+00,
                  -.4287848039774783e+00,
                  -.4287848039774774e+00,
                  -.4307078740593573e+00,
                  -.4318162335202751e+00,
                  -.4345595671280972e+00,
                  -.4445787613861700e+00,
                  -.4574428938196028e+00,
                  -.4764720525161489e+00,
                  -.3903620929620036e+00,
                  -.3531355357227437e+00,
                  -.3328309924295670e+00,
                  -.3183683897748268e+00,
                  -.3147233996148908e+00,
                  -.3110874708950588e+00,
                  -.3089875804443212e+00,
                  -.3110874708950562e+00,
                  -.3147233996148920e+00,
                  -.3183683897748276e+00,
                  -.3328309924295714e+00,
                  -.3531355357227317e+00,
                  -.3903620929620045e+00,
                  -.2718094085213632e+00,
                  -.2221190874524821e+00,
                  -.1950958332499522e+00,
                  -.1776502240509063e+00,
                  -.1702877345655585e+00,
                  -.1644029646884267e+00,
                  -.1644029646884244e+00,
                  -.1702877345655575e+00,
                  -.1776502240509040e+00,
                  -.1950958332499579e+00,
                  -.2221190874524714e+00,
                  -.2718094085213568e+00,
                  -.1283915378835490e+00,
                  -.7138843119511875e-01,
                  -.3906456738007864e-01,
                  -.1789328885451292e-01,
                  -.5294277978531789e-02,
                  0.7305431074051443e-16,
                  -.5294277978530638e-02,
                  -.1789328885450859e-01,
                  -.3906456738008296e-01,
                  -.7138843119511754e-01,
                  -.1283915378835465e+00,
                  0.3147577649113589e-01,
                  0.9095710861123058e-01,
                  0.1282429966825328e+00,
                  0.1544937902221598e+00,
                  0.1696972426669553e+00,
                  0.1696972426669546e+00,
                  0.1544937902221643e+00,
                  0.1282429966825352e+00,
                  0.9095710861122631e-01,
                  0.3147577649113125e-01,
                  0.1985382644461893e+00,
                  0.2577332322722302e+00,
                  0.3005418072949424e+00,
                  0.3289807597495710e+00,
                  0.3405754691311120e+00,
                  0.3289807597495714e+00,
                  0.3005418072949481e+00,
                  0.2577332322722277e+00,
                  0.1985382644461816e+00,
                  0.3669667974555035e+00,
                  0.4251024300043566e+00,
                  0.4697724414394385e+00,
                  0.4923736236657991e+00,
                  0.4923736236657976e+00,
                  0.4697724414394416e+00,
                  0.4251024300043554e+00,
                  0.3669667974554970e+00,
                  0.5341996487446351e+00,
                  0.5881098628688821e+00,
                  0.6269120667702253e+00,
                  0.6367367795496609e+00,
                  0.6269120667702305e+00,
                  0.5881098628688810e+00,
                  0.5341996487446298e+00,
                  0.6941105838783878e+00,
                  0.7390409431595986e+00,
                  0.7673905595576619e+00,
                  0.7673905595576718e+00,
                  0.7390409431596019e+00,
                  0.6941105838783838e+00,
                  0.8376308190381789e+00,
                  0.8719514641943438e+00,
                  0.8891575227723361e+00,
                  0.8719514641943474e+00,
                  0.8376308190381769e+00,
                  0.9567919454058349e+00,
                  0.9809290331811194e+00,
                  0.9809290331811091e+00,
                  0.9567919454058305e+00,
                  0.1043701136753987e+01,
                  0.1060305748752979e+01,
                  0.1043701136753979e+01,
                  0.1100553999464017e+01,
                  0.1100553999464027e+01,
                  0.1134905487910995e+01],
                 []],
      quad_degree: 25,
      weights: [0.1839001120440604e-02,
                  0.2990649652355081e-02,
                  0.5387629431651609e-02,
                  0.8806545447597718e-02,
                  0.1186515677502570e-01,
                  0.1385878279106105e-01,
                  0.1498516395902358e-01,
                  0.1550859725249790e-01,
                  0.1550859725249786e-01,
                  0.1498516395902373e-01,
                  0.1385878279106116e-01,
                  0.1186515677502524e-01,
                  0.8806545447597535e-02,
                  0.5387629431651744e-02,
                  0.2990649652355477e-02,
                  0.1839001120440701e-02,
                  0.2990649652354691e-02,
                  0.9341173994789262e-02,
                  0.1639241944671086e-01,
                  0.2372041342204075e-01,
                  0.2915928996951518e-01,
                  0.3257539269458767e-01,
                  0.3457095885268818e-01,
                  0.3522405450530094e-01,
                  0.3457095885268830e-01,
                  0.3257539269458890e-01,
                  0.2915928996951569e-01,
                  0.2372041342204079e-01,
                  0.1639241944671025e-01,
                  0.9341173994789658e-02,
                  0.2990649652354204e-02,
                  0.5387629431653337e-02,
                  0.1639241944671058e-01,
                  0.2760738411384256e-01,
                  0.3849036589072855e-01,
                  0.4579220023168446e-01,
                  0.5109241094278086e-01,
                  0.5423767359723752e-01,
                  0.5423767359723667e-01,
                  0.5109241094277996e-01,
                  0.4579220023168441e-01,
                  0.3849036589072913e-01,
                  0.2760738411384234e-01,
                  0.1639241944671186e-01,
                  0.5387629431653255e-02,
                  0.8806545447596883e-02,
                  0.2372041342203910e-01,
                  0.3849036589072871e-01,
                  0.5086915027915862e-01,
                  0.6033991753726089e-01,
                  0.6827797472043587e-01,
                  0.7130547233124261e-01,
                  0.6827797472043520e-01,
                  0.6033991753726063e-01,
                  0.5086915027915885e-01,
                  0.3849036589072779e-01,
                  0.2372041342203940e-01,
                  0.8806545447597212e-02,
                  0.1186515677502447e-01,
                  0.2915928996951533e-01,
                  0.4579220023168514e-01,
                  0.6033991753725954e-01,
                  0.7396329144663179e-01,
                  0.8217105601384368e-01,
                  0.8217105601384339e-01,
                  0.7396329144663158e-01,
                  0.6033991753726029e-01,
                  0.4579220023168589e-01,
                  0.2915928996951551e-01,
                  0.1186515677502531e-01,
                  0.1385878279106077e-01,
                  0.3257539269458897e-01,
                  0.5109241094278015e-01,
                  0.6827797472043399e-01,
                  0.8217105601384375e-01,
                  0.8722993876298772e-01,
                  0.8217105601384393e-01,
                  0.6827797472043400e-01,
                  0.5109241094278085e-01,
                  0.3257539269458692e-01,
                  0.1385878279106055e-01,
                  0.1498516395902379e-01,
                  0.3457095885268837e-01,
                  0.5423767359723649e-01,
                  0.7130547233124173e-01,
                  0.8217105601384404e-01,
                  0.8217105601384408e-01,
                  0.7130547233124150e-01,
                  0.5423767359723799e-01,
                  0.3457095885268735e-01,
                  0.1498516395902292e-01,
                  0.1550859725249844e-01,
                  0.3522405450530087e-01,
                  0.5423767359723704e-01,
                  0.6827797472043501e-01,
                  0.7396329144663208e-01,
                  0.6827797472043384e-01,
                  0.5423767359723749e-01,
                  0.3522405450530120e-01,
                  0.1550859725249807e-01,
                  0.1550859725249846e-01,
                  0.3457095885268772e-01,
                  0.5109241094278031e-01,
                  0.6033991753726045e-01,
                  0.6033991753725940e-01,
                  0.5109241094278013e-01,
                  0.3457095885268822e-01,
                  0.1550859725249864e-01,
                  0.1498516395902362e-01,
                  0.3257539269458734e-01,
                  0.4579220023168456e-01,
                  0.5086915027915828e-01,
                  0.4579220023168487e-01,
                  0.3257539269458815e-01,
                  0.1498516395902405e-01,
                  0.1385878279106092e-01,
                  0.2915928996951552e-01,
                  0.3849036589072869e-01,
                  0.3849036589072852e-01,
                  0.2915928996951540e-01,
                  0.1385878279106115e-01,
                  0.1186515677502568e-01,
                  0.2372041342204114e-01,
                  0.2760738411384267e-01,
                  0.2372041342203977e-01,
                  0.1186515677502517e-01,
                  0.8806545447597743e-02,
                  0.1639241944671107e-01,
                  0.1639241944671111e-01,
                  0.8806545447597347e-02,
                  0.5387629431651538e-02,
                  0.9341173994789503e-02,
                  0.5387629431653128e-02,
                  0.2990649652354960e-02,
                  0.2990649652354337e-02,
                  0.1839001120440659e-02]},
 16: {points: [[-.9819138246793522e+00,
                  -.9469364483158933e+00,
                  -.8958095720537448e+00,
                  -.8057698872090226e+00,
                  -.6777483625377876e+00,
                  -.5290053483539901e+00,
                  -.3645388888293968e+00,
                  -.1864078773029425e+00,
                  -.8955321313498144e-14,
                  0.1864078773029339e+00,
                  0.3645388888294043e+00,
                  0.5290053483540018e+00,
                  0.6777483625377863e+00,
                  0.8057698872090168e+00,
                  0.8958095720538293e+00,
                  0.9469364483158936e+00,
                  0.9819138246793466e+00,
                  -.9707962833433683e+00,
                  -.9322586558077184e+00,
                  -.8457260312848339e+00,
                  -.7364026518302949e+00,
                  -.6003942339983585e+00,
                  -.4483511269451505e+00,
                  -.2787235715918145e+00,
                  -.9455955274002762e-01,
                  0.9455955274003159e-01,
                  0.2787235715918155e+00,
                  0.4483511269451280e+00,
                  0.6003942339982754e+00,
                  0.7364026518301794e+00,
                  0.8457260312848583e+00,
                  0.9322586558077159e+00,
                  0.9707962833433744e+00,
                  -.9384627139161896e+00,
                  -.8787168873106360e+00,
                  -.7907638405521696e+00,
                  -.6774504958545562e+00,
                  -.5339848131934304e+00,
                  -.3703639659122039e+00,
                  -.1895284664973598e+00,
                  0.5157119618603573e-14,
                  0.1895284664973791e+00,
                  0.3703639659122455e+00,
                  0.5339848131934525e+00,
                  0.6774504958544475e+00,
                  0.7907638405521215e+00,
                  0.8787168873105624e+00,
                  0.9384627139161207e+00,
                  -.8946504503980864e+00,
                  -.8239209696300878e+00,
                  -.7299310506886745e+00,
                  -.6003310282037274e+00,
                  -.4481271755498713e+00,
                  -.2791169325438485e+00,
                  -.9493048955172643e-01,
                  0.9493048955172949e-01,
                  0.2791169325438958e+00,
                  0.4481271755499794e+00,
                  0.6003310282037674e+00,
                  0.7299310506887887e+00,
                  0.8239209696301753e+00,
                  0.8946504503980949e+00,
                  -.8300315592022227e+00,
                  -.7532907694837442e+00,
                  -.6536468506499540e+00,
                  -.5192878037596618e+00,
                  -.3658029696694198e+00,
                  -.1901196986988824e+00,
                  -.4352756771803228e-13,
                  0.1901196986988062e+00,
                  0.3658029696693842e+00,
                  0.5192878037595685e+00,
                  0.6536468506499259e+00,
                  0.7532907694837843e+00,
                  0.8300315592022268e+00,
                  -.7554601476215260e+00,
                  -.6772085185197662e+00,
                  -.5718219579095628e+00,
                  -.4336544361413932e+00,
                  -.2739607531376311e+00,
                  -.9377799851807074e-01,
                  0.9377799851806070e-01,
                  0.2739607531376608e+00,
                  0.4336544361413608e+00,
                  0.5718219579095273e+00,
                  0.6772085185197665e+00,
                  0.7554601476215175e+00,
                  -.6732856849456812e+00,
                  -.5922644711661959e+00,
                  -.4803154560900301e+00,
                  -.3391543216670886e+00,
                  -.1765381923720221e+00,
                  0.4186347832657209e-14,
                  0.1765381923720612e+00,
                  0.3391543216670901e+00,
                  0.4803154560900229e+00,
                  0.5922644711661948e+00,
                  0.6732856849456748e+00,
                  -.5841134612801482e+00,
                  -.4995994788050245e+00,
                  -.3846077319855144e+00,
                  -.2442238321153661e+00,
                  -.8384105443878242e-01,
                  0.8384105443882010e-01,
                  0.2442238321153593e+00,
                  0.3846077319855091e+00,
                  0.4995994788050248e+00,
                  0.5841134612801519e+00,
                  -.4908444877275481e+00,
                  -.4050399260649949e+00,
                  -.2907869895926637e+00,
                  -.1545375035975178e+00,
                  0.3365103725798454e-13,
                  0.1545375035975018e+00,
                  0.2907869895926518e+00,
                  0.4050399260649935e+00,
                  0.4908444877275581e+00,
                  -.3977055839772075e+00,
                  -.3135408995743787e+00,
                  -.2014579919973246e+00,
                  -.7116062820970284e-01,
                  0.7116062820969220e-01,
                  0.2014579919973201e+00,
                  0.3135408995743792e+00,
                  0.3977055839772127e+00,
                  -.3087467961162784e+00,
                  -.2288573915746183e+00,
                  -.1196620374564933e+00,
                  -.3660502080806324e-13,
                  0.1196620374565046e+00,
                  0.2288573915746370e+00,
                  0.3087467961162737e+00,
                  -.2264547992675303e+00,
                  -.1528965354854284e+00,
                  -.5248055483422171e-01,
                  0.5248055483421986e-01,
                  0.1528965354854672e+00,
                  0.2264547992675224e+00,
                  -.1522831966644404e+00,
                  -.8751831779987986e-01,
                  0.4948708344972005e-13,
                  0.8751831779990450e-01,
                  0.1522831966644358e+00,
                  -.8888056318907052e-01,
                  -.3299085602573462e-01,
                  0.3299085602578422e-01,
                  0.8888056318906934e-01,
                  -.4265314186237629e-01,
                  0.2887058510115772e-14,
                  0.4265314186236573e-01,
                  -.2385983502747716e-01,
                  0.2385983502746954e-01,
                  0.5017279286346052e-14],
                 [-.5669082109996325e+00,
                  -.5742649776925225e+00,
                  -.5664475034399276e+00,
                  -.5678418954508946e+00,
                  -.5671396887285605e+00,
                  -.5669088589077084e+00,
                  -.5669767172940753e+00,
                  -.5668534900748383e+00,
                  -.5667783942394929e+00,
                  -.5668534900748375e+00,
                  -.5669767172940757e+00,
                  -.5669088589077107e+00,
                  -.5671396887285578e+00,
                  -.5678418954508890e+00,
                  -.5664475034399597e+00,
                  -.5742649776925112e+00,
                  -.5669082109996426e+00,
                  -.5329385311647175e+00,
                  -.5382397858849445e+00,
                  -.5263747110374789e+00,
                  -.5262197179477399e+00,
                  -.5231874844601951e+00,
                  -.5231173970965378e+00,
                  -.5229669746304811e+00,
                  -.5222938039212501e+00,
                  -.5222938039212475e+00,
                  -.5229669746304791e+00,
                  -.5231173970965477e+00,
                  -.5231874844601963e+00,
                  -.5262197179477043e+00,
                  -.5263747110375512e+00,
                  -.5382397858849435e+00,
                  -.5329385311647121e+00,
                  -.4925700946319020e+00,
                  -.4692328722157036e+00,
                  -.4565477162081621e+00,
                  -.4517255510657945e+00,
                  -.4464700947149736e+00,
                  -.4464533872376647e+00,
                  -.4451962045876796e+00,
                  -.4441067551884931e+00,
                  -.4451962045876731e+00,
                  -.4464533872376775e+00,
                  -.4464700947149935e+00,
                  -.4517255510657259e+00,
                  -.4565477162082500e+00,
                  -.4692328722157172e+00,
                  -.4925700946318445e+00,
                  -.4138962442020863e+00,
                  -.3746335449253116e+00,
                  -.3608265636834550e+00,
                  -.3466012807363480e+00,
                  -.3408955611400521e+00,
                  -.3395927747434103e+00,
                  -.3368135341256471e+00,
                  -.3368135341256412e+00,
                  -.3395927747434172e+00,
                  -.3408955611400992e+00,
                  -.3466012807362814e+00,
                  -.3608265636835150e+00,
                  -.3746335449253918e+00,
                  -.4138962442020900e+00,
                  -.3033774549667480e+00,
                  -.2583629166981075e+00,
                  -.2392093661031206e+00,
                  -.2176417375823950e+00,
                  -.2111964430089649e+00,
                  -.2065769699207942e+00,
                  -.2038487457764948e+00,
                  -.2065769699207968e+00,
                  -.2111964430090237e+00,
                  -.2176417375823268e+00,
                  -.2392093661031095e+00,
                  -.2583629166981779e+00,
                  -.3033774549667496e+00,
                  -.1746776409585463e+00,
                  -.1267247672015894e+00,
                  -.9751790950751960e-01,
                  -.7192596683768898e-01,
                  -.6136000387261218e-01,
                  -.5414275268846330e-01,
                  -.5414275268847256e-01,
                  -.6136000387267627e-01,
                  -.7192596683765228e-01,
                  -.9751790950748634e-01,
                  -.1267247672016103e+00,
                  -.1746776409585361e+00,
                  -.3221157974658025e-01,
                  0.2010179368319543e-01,
                  0.5846163556679839e-01,
                  0.8619455151733102e-01,
                  0.1019243728882855e+00,
                  0.1082855053769415e+00,
                  0.1019243728882139e+00,
                  0.8619455151733668e-01,
                  0.5846163556682090e-01,
                  0.2010179368319989e-01,
                  -.3221157974657028e-01,
                  0.1219927878275425e+00,
                  0.1792559271172632e+00,
                  0.2220533775942438e+00,
                  0.2506189826083124e+00,
                  0.2679369737934741e+00,
                  0.2679369737934125e+00,
                  0.2506189826083111e+00,
                  0.2220533775942519e+00,
                  0.1792559271172667e+00,
                  0.1219927878275374e+00,
                  0.2833891971197545e+00,
                  0.3430378768039883e+00,
                  0.3867345690208657e+00,
                  0.4115187415810644e+00,
                  0.4223928860179894e+00,
                  0.4115187415811049e+00,
                  0.3867345690208728e+00,
                  0.3430378768039855e+00,
                  0.2833891971197369e+00,
                  0.4448607022473027e+00,
                  0.5028651809472883e+00,
                  0.5439712967451601e+00,
                  0.5585372987223794e+00,
                  0.5585372987224911e+00,
                  0.5439712967451922e+00,
                  0.5028651809472831e+00,
                  0.4448607022472921e+00,
                  0.5991882970406473e+00,
                  0.6498421642981513e+00,
                  0.6856794608180898e+00,
                  0.6932025614726278e+00,
                  0.6856794608181106e+00,
                  0.6498421642981380e+00,
                  0.5991882970406560e+00,
                  0.7415864998662428e+00,
                  0.7815504011583698e+00,
                  0.8125521147493109e+00,
                  0.8125521147491813e+00,
                  0.7815504011583060e+00,
                  0.7415864998662611e+00,
                  0.8705171436953067e+00,
                  0.9008532628731272e+00,
                  0.9130954324164142e+00,
                  0.9008532628730153e+00,
                  0.8705171436953097e+00,
                  0.9817381396529825e+00,
                  0.9956075832531994e+00,
                  0.9956075832532519e+00,
                  0.9817381396529736e+00,
                  0.1059017598071780e+01,
                  0.1076479571769885e+01,
                  0.1059017598071859e+01,
                  0.1107203508857236e+01,
                  0.1107203508857235e+01,
                  0.1133816421999275e+01],
                 []],
      quad_degree: 27,
      weights: [0.2020717421353036e-02,
                  0.1375512610167251e-02,
                  0.4714215608316735e-02,
                  0.7263419016910609e-02,
                  0.9610515899522782e-02,
                  0.1103663451870804e-01,
                  0.1201637924964604e-01,
                  0.1297990928502312e-01,
                  0.1338797413842334e-01,
                  0.1297990928502523e-01,
                  0.1201637924964638e-01,
                  0.1103663451870528e-01,
                  0.9610515899524319e-02,
                  0.7263419016916198e-02,
                  0.4714215608306395e-02,
                  0.1375512610164696e-02,
                  0.2020717421353002e-02,
                  0.1375512610164441e-02,
                  0.7788565106919831e-02,
                  0.1388359835401183e-01,
                  0.1874409362419806e-01,
                  0.2292548132352864e-01,
                  0.2566172195712609e-01,
                  0.2858890914676911e-01,
                  0.3056706335056018e-01,
                  0.3056706335056147e-01,
                  0.2858890914676817e-01,
                  0.2566172195711427e-01,
                  0.2292548132351950e-01,
                  0.1874409362421518e-01,
                  0.1388359835400676e-01,
                  0.7788565106919931e-02,
                  0.1375512610167476e-02,
                  0.4714215608307265e-02,
                  0.1388359835400734e-01,
                  0.2064510962488085e-01,
                  0.2980759691850479e-01,
                  0.3694617630360964e-01,
                  0.4201600489720669e-01,
                  0.4569094499773563e-01,
                  0.4707190148543825e-01,
                  0.4569094499774081e-01,
                  0.4201600489720527e-01,
                  0.3694617630358850e-01,
                  0.2980759691849738e-01,
                  0.2064510962488106e-01,
                  0.1388359835401224e-01,
                  0.4714215608316978e-02,
                  0.7263419016915924e-02,
                  0.1874409362421423e-01,
                  0.2980759691849740e-01,
                  0.4221826615852983e-01,
                  0.4965946462950055e-01,
                  0.5593351146043222e-01,
                  0.6010135328279537e-01,
                  0.6010135328280144e-01,
                  0.5593351146044709e-01,
                  0.4965946462949763e-01,
                  0.4221826615852952e-01,
                  0.2980759691850523e-01,
                  0.1874409362419707e-01,
                  0.7263419016910255e-02,
                  0.9610515899524156e-02,
                  0.2292548132351970e-01,
                  0.3694617630358897e-01,
                  0.4965946462949707e-01,
                  0.5996769617995813e-01,
                  0.6907681328154115e-01,
                  0.7237256267336401e-01,
                  0.6907681328154270e-01,
                  0.5996769617995901e-01,
                  0.4965946462950049e-01,
                  0.3694617630361064e-01,
                  0.2292548132352877e-01,
                  0.9610515899522586e-02,
                  0.1103663451870517e-01,
                  0.2566172195711412e-01,
                  0.4201600489720482e-01,
                  0.5593351146044541e-01,
                  0.6907681328154247e-01,
                  0.7699993908271188e-01,
                  0.7699993908271196e-01,
                  0.6907681328154170e-01,
                  0.5593351146043160e-01,
                  0.4201600489720686e-01,
                  0.2566172195712630e-01,
                  0.1103663451870822e-01,
                  0.1201637924964614e-01,
                  0.2858890914676807e-01,
                  0.4569094499774058e-01,
                  0.6010135328280041e-01,
                  0.7237256267336421e-01,
                  0.7699993908271194e-01,
                  0.7237256267336429e-01,
                  0.6010135328279454e-01,
                  0.4569094499773517e-01,
                  0.2858890914676886e-01,
                  0.1201637924964599e-01,
                  0.1297990928502526e-01,
                  0.3056706335056189e-01,
                  0.4707190148543858e-01,
                  0.6010135328279463e-01,
                  0.6907681328154132e-01,
                  0.6907681328154241e-01,
                  0.6010135328280005e-01,
                  0.4707190148543736e-01,
                  0.3056706335055999e-01,
                  0.1297990928502299e-01,
                  0.1338797413842352e-01,
                  0.3056706335056048e-01,
                  0.4569094499773589e-01,
                  0.5593351146043131e-01,
                  0.5996769617995804e-01,
                  0.5593351146044524e-01,
                  0.4569094499773965e-01,
                  0.3056706335056132e-01,
                  0.1338797413842332e-01,
                  0.1297990928502305e-01,
                  0.2858890914676846e-01,
                  0.4201600489720665e-01,
                  0.4965946462950010e-01,
                  0.4965946462949715e-01,
                  0.4201600489720489e-01,
                  0.2858890914676819e-01,
                  0.1297990928502532e-01,
                  0.1201637924964562e-01,
                  0.2566172195712483e-01,
                  0.3694617630360956e-01,
                  0.4221826615853020e-01,
                  0.3694617630358962e-01,
                  0.2566172195711463e-01,
                  0.1201637924964657e-01,
                  0.1103663451870791e-01,
                  0.2292548132352833e-01,
                  0.2980759691850501e-01,
                  0.2980759691849844e-01,
                  0.2292548132351930e-01,
                  0.1103663451870530e-01,
                  0.9610515899522973e-02,
                  0.1874409362419859e-01,
                  0.2064510962488093e-01,
                  0.1874409362421438e-01,
                  0.9610515899523993e-02,
                  0.7263419016910998e-02,
                  0.1388359835401229e-01,
                  0.1388359835400674e-01,
                  0.7263419016915951e-02,
                  0.4714215608316480e-02,
                  0.7788565106920069e-02,
                  0.4714215608306593e-02,
                  0.1375512610167440e-02,
                  0.1375512610164699e-02,
                  0.2020717421352824e-02]},
 17: {points: [[-.9894165559415557e+00,
                  -.9573403339036897e+00,
                  -.9038732469641226e+00,
                  -.8240169142351193e+00,
                  -.7131828067569843e+00,
                  -.5779655291940259e+00,
                  -.4259190230971662e+00,
                  -.2617218573187573e+00,
                  -.8846027949976127e-01,
                  0.8846027949976083e-01,
                  0.2617218573187572e+00,
                  0.4259190230971663e+00,
                  0.5779655291940257e+00,
                  0.7131828067569842e+00,
                  0.8240169142351199e+00,
                  0.9038732469641237e+00,
                  0.9573403339036890e+00,
                  0.9894165559415556e+00,
                  -.9718775027274527e+00,
                  -.9302365642009512e+00,
                  -.8639235891639995e+00,
                  -.7680996673746580e+00,
                  -.6444307735974454e+00,
                  -.5029409444132445e+00,
                  -.3470874397823064e+00,
                  -.1777724945282114e+00,
                  -.3618034488376328e-15,
                  0.1777724945282111e+00,
                  0.3470874397823068e+00,
                  0.5029409444132450e+00,
                  0.6444307735974454e+00,
                  0.7680996673746580e+00,
                  0.8639235891640004e+00,
                  0.9302365642009517e+00,
                  0.9718775027274537e+00,
                  -.9450048701291274e+00,
                  -.8949236406026028e+00,
                  -.8160814865528528e+00,
                  -.7083674652064831e+00,
                  -.5743868830220404e+00,
                  -.4249366538819102e+00,
                  -.2615243642641738e+00,
                  -.8825519634085994e-01,
                  0.8825519634085936e-01,
                  0.2615243642641738e+00,
                  0.4249366538819108e+00,
                  0.5743868830220410e+00,
                  0.7083674652064834e+00,
                  0.8160814865528525e+00,
                  0.8949236406026014e+00,
                  0.9450048701291268e+00,
                  -.9047094190281006e+00,
                  -.8444414634171342e+00,
                  -.7564648451239306e+00,
                  -.6412768609383893e+00,
                  -.5000709111973663e+00,
                  -.3449757158270758e+00,
                  -.1762482959800207e+00,
                  -.2720375099190034e-15,
                  0.1762482959800203e+00,
                  0.3449757158270756e+00,
                  0.5000709111973664e+00,
                  0.6412768609383898e+00,
                  0.7564648451239312e+00,
                  0.8444414634171343e+00,
                  0.9047094190281003e+00,
                  -.8486029935941342e+00,
                  -.7797370017794927e+00,
                  -.6838220799821093e+00,
                  -.5625300284325166e+00,
                  -.4185014507921662e+00,
                  -.2610282860962080e+00,
                  -.8885909722551076e-01,
                  0.8885909722551075e-01,
                  0.2610282860962080e+00,
                  0.4185014507921659e+00,
                  0.5625300284325164e+00,
                  0.6838220799821091e+00,
                  0.7797370017794926e+00,
                  0.8486029935941341e+00,
                  -.7807315617073254e+00,
                  -.7084080720323798e+00,
                  -.6086727152813497e+00,
                  -.4846713752068090e+00,
                  -.3385937121078464e+00,
                  -.1756399244354621e+00,
                  0.1546133115280780e-15,
                  0.1756399244354626e+00,
                  0.3385937121078467e+00,
                  0.4846713752068094e+00,
                  0.6086727152813498e+00,
                  0.7084080720323797e+00,
                  0.7807315617073254e+00,
                  -.7047356067387226e+00,
                  -.6306796450726373e+00,
                  -.5270212830614905e+00,
                  -.3995164399831464e+00,
                  -.2505066256714430e+00,
                  -.8566092377001593e-01,
                  0.8566092377001592e-01,
                  0.2505066256714429e+00,
                  0.3995164399831466e+00,
                  0.5270212830614907e+00,
                  0.6306796450726374e+00,
                  0.7047356067387226e+00,
                  -.6226426449573700e+00,
                  -.5458508233492731e+00,
                  -.4397740328710888e+00,
                  -.3105644774035786e+00,
                  -.1616475284459324e+00,
                  -.2512456557059834e-16,
                  0.1616475284459321e+00,
                  0.3105644774035785e+00,
                  0.4397740328710889e+00,
                  0.5458508233492732e+00,
                  0.6226426449573702e+00,
                  -.5359645733386291e+00,
                  -.4567920959495394e+00,
                  -.3515188365302293e+00,
                  -.2232681440031258e+00,
                  -.7756542601163845e-01,
                  0.7756542601163863e-01,
                  0.2232681440031260e+00,
                  0.3515188365302293e+00,
                  0.4567920959495396e+00,
                  0.5359645733386294e+00,
                  -.4475042938388683e+00,
                  -.3680783288210620e+00,
                  -.2654969187973169e+00,
                  -.1396956593797328e+00,
                  0.2812978795510994e-15,
                  0.1396956593797334e+00,
                  0.2654969187973169e+00,
                  0.3680783288210621e+00,
                  0.4475042938388685e+00,
                  -.3609207876386133e+00,
                  -.2835922052903310e+00,
                  -.1837360613994392e+00,
                  -.6245911723514966e-01,
                  0.6245911723515028e-01,
                  0.1837360613994392e+00,
                  0.2835922052903309e+00,
                  0.3609207876386133e+00,
                  -.2788165836415567e+00,
                  -.2054671276191353e+00,
                  -.1094351969600687e+00,
                  0.8173302986656238e-16,
                  0.1094351969600686e+00,
                  0.2054671276191351e+00,
                  0.2788165836415565e+00,
                  -.2027660325132996e+00,
                  -.1353062281820475e+00,
                  -.4809737991744767e-01,
                  0.4809737991744765e-01,
                  0.1353062281820474e+00,
                  0.2027660325132996e+00,
                  -.1354201868371496e+00,
                  -.7634179604247648e-01,
                  0.3031581292308192e-15,
                  0.7634179604247604e-01,
                  0.1354201868371495e+00,
                  -.8069250479298056e-01,
                  -.3100005143860299e-01,
                  0.3100005143860214e-01,
                  0.8069250479297999e-01,
                  -.4113162316500443e-01,
                  -.1353805196914248e-14,
                  0.4113162316500366e-01,
                  -.1453716882376390e-01,
                  0.1453716882376378e-01,
                  0.4800628012664950e-15],
                 [-.5712399149135294e+00,
                  -.5695067761526913e+00,
                  -.5693461698610805e+00,
                  -.5689220659780763e+00,
                  -.5681260481108335e+00,
                  -.5678226007706272e+00,
                  -.5678541218781002e+00,
                  -.5678606125743634e+00,
                  -.5678060152045447e+00,
                  -.5678060152045447e+00,
                  -.5678606125743634e+00,
                  -.5678541218781002e+00,
                  -.5678226007706272e+00,
                  -.5681260481108335e+00,
                  -.5689220659780764e+00,
                  -.5693461698610806e+00,
                  -.5695067761526908e+00,
                  -.5712399149135300e+00,
                  -.5443276611517261e+00,
                  -.5370723307514522e+00,
                  -.5345822928490418e+00,
                  -.5316144627143070e+00,
                  -.5283004551384399e+00,
                  -.5276260925245252e+00,
                  -.5278550989195570e+00,
                  -.5276572420257895e+00,
                  -.5274580791203200e+00,
                  -.5276572420257895e+00,
                  -.5278550989195570e+00,
                  -.5276260925245252e+00,
                  -.5283004551384400e+00,
                  -.5316144627143071e+00,
                  -.5345822928490420e+00,
                  -.5370723307514511e+00,
                  -.5443276611517268e+00,
                  -.4981041087415161e+00,
                  -.4808886287201338e+00,
                  -.4711648659419594e+00,
                  -.4645142172074441e+00,
                  -.4579873023791962e+00,
                  -.4574974205248754e+00,
                  -.4575605971808607e+00,
                  -.4568531511566827e+00,
                  -.4568531511566827e+00,
                  -.4575605971808607e+00,
                  -.4574974205248755e+00,
                  -.4579873023791962e+00,
                  -.4645142172074443e+00,
                  -.4711648659419596e+00,
                  -.4808886287201327e+00,
                  -.4981041087415154e+00,
                  -.4291585478866386e+00,
                  -.3993865932276777e+00,
                  -.3812071114794816e+00,
                  -.3702413682878573e+00,
                  -.3608376514918215e+00,
                  -.3604784754916682e+00,
                  -.3595648472116237e+00,
                  -.3586089692593836e+00,
                  -.3595648472116237e+00,
                  -.3604784754916684e+00,
                  -.3608376514918215e+00,
                  -.3702413682878576e+00,
                  -.3812071114794818e+00,
                  -.3993865932276774e+00,
                  -.4291585478866381e+00,
                  -.3335714041384199e+00,
                  -.2939431933466256e+00,
                  -.2684399811080495e+00,
                  -.2526552870446406e+00,
                  -.2416219252711059e+00,
                  -.2402695904190071e+00,
                  -.2379573118272895e+00,
                  -.2379573118272896e+00,
                  -.2402695904190074e+00,
                  -.2416219252711059e+00,
                  -.2526552870446408e+00,
                  -.2684399811080495e+00,
                  -.2939431933466256e+00,
                  -.3335714041384198e+00,
                  -.2166215304084294e+00,
                  -.1717465882029443e+00,
                  -.1392572269984518e+00,
                  -.1185184958491349e+00,
                  -.1059223316561248e+00,
                  -.1014057576532597e+00,
                  -.9891271479530190e-01,
                  -.1014057576532600e+00,
                  -.1059223316561249e+00,
                  -.1185184958491351e+00,
                  -.1392572269984517e+00,
                  -.1717465882029442e+00,
                  -.2166215304084294e+00,
                  -.8492963301814669e-01,
                  -.3665899072620031e-01,
                  0.2293555429080855e-02,
                  0.2714692191339537e-01,
                  0.4202442035900100e-01,
                  0.4945635739765079e-01,
                  0.4945635739765052e-01,
                  0.4202442035900088e-01,
                  0.2714692191339514e-01,
                  0.2293555429080685e-02,
                  -.3665899072620030e-01,
                  -.8492963301814676e-01,
                  0.5727252912349219e-01,
                  0.1098731246573339e+00,
                  0.1519953335311736e+00,
                  0.1793044846296918e+00,
                  0.1959328914682883e+00,
                  0.2028115153065196e+00,
                  0.1959328914682881e+00,
                  0.1793044846296914e+00,
                  0.1519953335311732e+00,
                  0.1098731246573336e+00,
                  0.5727252912349200e-01,
                  0.2072941583296080e+00,
                  0.2637290395601601e+00,
                  0.3048578176255092e+00,
                  0.3324179252982287e+00,
                  0.3461919220751323e+00,
                  0.3461919220751322e+00,
                  0.3324179252982279e+00,
                  0.3048578176255087e+00,
                  0.2637290395601595e+00,
                  0.2072941583296075e+00,
                  0.3605118568749373e+00,
                  0.4177841173684558e+00,
                  0.4552670417517801e+00,
                  0.4789969713408037e+00,
                  0.4832438505422116e+00,
                  0.4789969713408032e+00,
                  0.4552670417517800e+00,
                  0.4177841173684553e+00,
                  0.3605118568749369e+00,
                  0.5105880834508714e+00,
                  0.5645140896457575e+00,
                  0.5967546475233273e+00,
                  0.6134929385364620e+00,
                  0.6134929385364619e+00,
                  0.5967546475233280e+00,
                  0.5645140896457576e+00,
                  0.5105880834508714e+00,
                  0.6527837548962467e+00,
                  0.6993726807274694e+00,
                  0.7264272834872456e+00,
                  0.7404827365757150e+00,
                  0.7264272834872463e+00,
                  0.6993726807274700e+00,
                  0.6527837548962470e+00,
                  0.7844441311790565e+00,
                  0.8222436484850655e+00,
                  0.8457213286869265e+00,
                  0.8457213286869263e+00,
                  0.8222436484850658e+00,
                  0.7844441311790567e+00,
                  0.9016974522492538e+00,
                  0.9310010559419846e+00,
                  0.9423297318839193e+00,
                  0.9310010559419852e+00,
                  0.9016974522492539e+00,
                  0.9980806138647153e+00,
                  0.1015470921569174e+01,
                  0.1015470921569177e+01,
                  0.9980806138647163e+00,
                  0.1067450278602596e+01,
                  0.1074144661502904e+01,
                  0.1067450278602598e+01,
                  0.1113834437304418e+01,
                  0.1113834437304416e+01,
                  0.1142479829827059e+01],
                 []],
      quad_degree: 28,
      weights: [0.7696913857190751e-03,
                  0.2231979438841607e-02,
                  0.3512557611845694e-02,
                  0.5434581492748123e-02,
                  0.7715230362559516e-02,
                  0.9289441899388811e-02,
                  0.1015411110482608e-01,
                  0.1083215169920858e-01,
                  0.1134019488130374e-01,
                  0.1134019488130376e-01,
                  0.1083215169920860e-01,
                  0.1015411110482606e-01,
                  0.9289441899388785e-02,
                  0.7715230362559531e-02,
                  0.5434581492748154e-02,
                  0.3512557611845642e-02,
                  0.2231979438841664e-02,
                  0.7696913857190627e-03,
                  0.2231979438841643e-02,
                  0.5922326704588127e-02,
                  0.1015801854642465e-01,
                  0.1480317542227223e-01,
                  0.1920180732925396e-01,
                  0.2180883730324797e-01,
                  0.2380421312438687e-01,
                  0.2562940998568836e-01,
                  0.2639899599854081e-01,
                  0.2562940998568845e-01,
                  0.2380421312438693e-01,
                  0.2180883730324790e-01,
                  0.1920180732925390e-01,
                  0.1480317542227225e-01,
                  0.1015801854642474e-01,
                  0.5922326704588172e-02,
                  0.2231979438841572e-02,
                  0.3512557611845644e-02,
                  0.1015801854642468e-01,
                  0.1795532425666677e-01,
                  0.2493427350758664e-01,
                  0.3110246951186547e-01,
                  0.3481164466463276e-01,
                  0.3763914144618993e-01,
                  0.3934291623641073e-01,
                  0.3934291623641080e-01,
                  0.3763914144619007e-01,
                  0.3481164466463281e-01,
                  0.3110246951186540e-01,
                  0.2493427350758648e-01,
                  0.1795532425666670e-01,
                  0.1015801854642465e-01,
                  0.3512557611845769e-02,
                  0.5434581492748134e-02,
                  0.1480317542227231e-01,
                  0.2493427350758664e-01,
                  0.3432467363591304e-01,
                  0.4190045265327134e-01,
                  0.4674271113854350e-01,
                  0.5026802988408292e-01,
                  0.5158275586599082e-01,
                  0.5026802988408295e-01,
                  0.4674271113854355e-01,
                  0.4190045265327145e-01,
                  0.3432467363591309e-01,
                  0.2493427350758665e-01,
                  0.1480317542227215e-01,
                  0.5434581492748083e-02,
                  0.7715230362559548e-02,
                  0.1920180732925398e-01,
                  0.3110246951186541e-01,
                  0.4190045265327132e-01,
                  0.4993033706223587e-01,
                  0.5649417873770256e-01,
                  0.6080163024859269e-01,
                  0.6080163024859268e-01,
                  0.5649417873770249e-01,
                  0.4993033706223584e-01,
                  0.4190045265327135e-01,
                  0.3110246951186550e-01,
                  0.1920180732925400e-01,
                  0.7715230362559516e-02,
                  0.9289441899388801e-02,
                  0.2180883730324789e-01,
                  0.3481164466463274e-01,
                  0.4674271113854357e-01,
                  0.5649417873770258e-01,
                  0.6490344936467543e-01,
                  0.6797750056710522e-01,
                  0.6490344936467545e-01,
                  0.5649417873770255e-01,
                  0.4674271113854353e-01,
                  0.3481164466463267e-01,
                  0.2180883730324791e-01,
                  0.9289441899388813e-02,
                  0.1015411110482607e-01,
                  0.2380421312438687e-01,
                  0.3763914144619002e-01,
                  0.5026802988408302e-01,
                  0.6080163024859268e-01,
                  0.6797750056710521e-01,
                  0.6797750056710521e-01,
                  0.6080163024859268e-01,
                  0.5026802988408302e-01,
                  0.3763914144618996e-01,
                  0.2380421312438681e-01,
                  0.1015411110482606e-01,
                  0.1083215169920861e-01,
                  0.2562940998568842e-01,
                  0.3934291623641079e-01,
                  0.5158275586599091e-01,
                  0.6080163024859270e-01,
                  0.6490344936467545e-01,
                  0.6080163024859264e-01,
                  0.5158275586599085e-01,
                  0.3934291623641079e-01,
                  0.2562940998568837e-01,
                  0.1083215169920858e-01,
                  0.1134019488130376e-01,
                  0.2639899599854084e-01,
                  0.3934291623641078e-01,
                  0.5026802988408302e-01,
                  0.5649417873770251e-01,
                  0.5649417873770246e-01,
                  0.5026802988408294e-01,
                  0.3934291623641084e-01,
                  0.2639899599854086e-01,
                  0.1134019488130376e-01,
                  0.1134019488130374e-01,
                  0.2562940998568840e-01,
                  0.3763914144618996e-01,
                  0.4674271113854347e-01,
                  0.4993033706223578e-01,
                  0.4674271113854350e-01,
                  0.3763914144619011e-01,
                  0.2562940998568849e-01,
                  0.1134019488130378e-01,
                  0.1083215169920857e-01,
                  0.2380421312438685e-01,
                  0.3481164466463274e-01,
                  0.4190045265327135e-01,
                  0.4190045265327142e-01,
                  0.3481164466463279e-01,
                  0.2380421312438693e-01,
                  0.1083215169920861e-01,
                  0.1015411110482609e-01,
                  0.2180883730324797e-01,
                  0.3110246951186558e-01,
                  0.3432467363591311e-01,
                  0.3110246951186542e-01,
                  0.2180883730324788e-01,
                  0.1015411110482606e-01,
                  0.9289441899388869e-02,
                  0.1920180732925400e-01,
                  0.2493427350758667e-01,
                  0.2493427350758650e-01,
                  0.1920180732925396e-01,
                  0.9289441899388815e-02,
                  0.7715230362559545e-02,
                  0.1480317542227212e-01,
                  0.1795532425666667e-01,
                  0.1480317542227231e-01,
                  0.7715230362559589e-02,
                  0.5434581492748088e-02,
                  0.1015801854642463e-01,
                  0.1015801854642473e-01,
                  0.5434581492748154e-02,
                  0.3512557611845689e-02,
                  0.5922326704588122e-02,
                  0.3512557611845533e-02,
                  0.2231979438841511e-02,
                  0.2231979438841656e-02,
                  0.7696913857191295e-03]},
 18: {points: [[-.9921745269987048e+00,
                  -.9640139978951241e+00,
                  -.9161449171355905e+00,
                  -.8425019756647384e+00,
                  -.7433884553480406e+00,
                  -.6211771892046105e+00,
                  -.4811445620198281e+00,
                  -.3288466378253345e+00,
                  -.1673425172673105e+00,
                  -.1042838708912538e-14,
                  0.1673425172673089e+00,
                  0.3288466378253325e+00,
                  0.4811445620198235e+00,
                  0.6211771892046064e+00,
                  0.7433884553480418e+00,
                  0.8425019756647432e+00,
                  0.9161449171355940e+00,
                  0.9640139978951196e+00,
                  0.9921745269987015e+00,
                  -.9760784308435460e+00,
                  -.9402756354011692e+00,
                  -.8830519555382193e+00,
                  -.7930931032880754e+00,
                  -.6806957690803298e+00,
                  -.5505207290611155e+00,
                  -.4057761542557564e+00,
                  -.2494471089670774e+00,
                  -.8431299826079080e-01,
                  0.8431299826079289e-01,
                  0.2494471089670828e+00,
                  0.4057761542557617e+00,
                  0.5505207290611159e+00,
                  0.6806957690803241e+00,
                  0.7930931032880619e+00,
                  0.8830519555382040e+00,
                  0.9402756354011641e+00,
                  0.9760784308435457e+00,
                  -.9524858046220759e+00,
                  -.9099942886481345e+00,
                  -.8384368237687577e+00,
                  -.7368971049603896e+00,
                  -.6186255255623883e+00,
                  -.4827298011242270e+00,
                  -.3307149397240331e+00,
                  -.1680666148922602e+00,
                  -.3890526515631326e-14,
                  0.1680666148922561e+00,
                  0.3307149397240377e+00,
                  0.4827298011242419e+00,
                  0.6186255255624132e+00,
                  0.7368971049604061e+00,
                  0.8384368237687630e+00,
                  0.9099942886481434e+00,
                  0.9524858046220755e+00,
                  -.9144721580806204e+00,
                  -.8597306294127103e+00,
                  -.7780585974040574e+00,
                  -.6692961154728276e+00,
                  -.5452255693333429e+00,
                  -.4033160744557764e+00,
                  -.2472625197824129e+00,
                  -.8329818797589794e-01,
                  0.8329818797589266e-01,
                  0.2472625197824067e+00,
                  0.4033160744557701e+00,
                  0.5452255693333456e+00,
                  0.6692961154728305e+00,
                  0.7780585974040549e+00,
                  0.8597306294127170e+00,
                  0.9144721580806217e+00,
                  -.8644108845480327e+00,
                  -.8022218017481829e+00,
                  -.7171432138849911e+00,
                  -.6053894488902820e+00,
                  -.4789219968522058e+00,
                  -.3325258555809051e+00,
                  -.1703402019779322e+00,
                  -.1733708792902666e-14,
                  0.1703402019779276e+00,
                  0.3325258555808974e+00,
                  0.4789219968522029e+00,
                  0.6053894488902797e+00,
                  0.7171432138849816e+00,
                  0.8022218017481826e+00,
                  0.8644108845480352e+00,
                  -.8033086006146450e+00,
                  -.7372419766383337e+00,
                  -.6491415557298310e+00,
                  -.5333953742423676e+00,
                  -.4029062153384836e+00,
                  -.2513297290517578e+00,
                  -.8536485658569324e-01,
                  0.8536485658569082e-01,
                  0.2513297290517525e+00,
                  0.4029062153384829e+00,
                  0.5333953742423710e+00,
                  0.6491415557298298e+00,
                  0.7372419766383329e+00,
                  0.8033086006146485e+00,
                  -.7332765283855917e+00,
                  -.6645799774252725e+00,
                  -.5721180248081719e+00,
                  -.4532686949104888e+00,
                  -.3185082859276553e+00,
                  -.1643409434884207e+00,
                  -.2107699545914185e-14,
                  0.1643409434884136e+00,
                  0.3185082859276500e+00,
                  0.4532686949104872e+00,
                  0.5721180248081732e+00,
                  0.6645799774252719e+00,
                  0.7332765283855940e+00,
                  -.6570479519975494e+00,
                  -.5859811410308143e+00,
                  -.4898134487707675e+00,
                  -.3699028371982265e+00,
                  -.2320049571494728e+00,
                  -.7897608690272722e-01,
                  0.7897608690272231e-01,
                  0.2320049571494692e+00,
                  0.3699028371982234e+00,
                  0.4898134487707691e+00,
                  0.5859811410308147e+00,
                  0.6570479519975502e+00,
                  -.5762250080592750e+00,
                  -.5031335584126734e+00,
                  -.4053984679354699e+00,
                  -.2866046492223291e+00,
                  -.1481680839497229e+00,
                  -.3315962635182267e-14,
                  0.1481680839497211e+00,
                  0.2866046492223276e+00,
                  0.4053984679354708e+00,
                  0.5031335584126745e+00,
                  0.5762250080592757e+00,
                  -.4925261340236049e+00,
                  -.4188205601518808e+00,
                  -.3217468338785062e+00,
                  -.2060061751280771e+00,
                  -.7038035975758498e-01,
                  0.7038035975758152e-01,
                  0.2060061751280773e+00,
                  0.3217468338785050e+00,
                  0.4188205601518809e+00,
                  0.4925261340236056e+00,
                  -.4088824907919643e+00,
                  -.3365340320637339e+00,
                  -.2414030850841352e+00,
                  -.1300792997865979e+00,
                  0.1995931202058797e-14,
                  0.1300792997865980e+00,
                  0.2414030850841306e+00,
                  0.3365340320637324e+00,
                  0.4088824907919647e+00,
                  -.3282013141722166e+00,
                  -.2588038231695167e+00,
                  -.1664117546055972e+00,
                  -.6016387955693198e-01,
                  0.6016387955693833e-01,
                  0.1664117546055901e+00,
                  0.2588038231695153e+00,
                  0.3282013141722175e+00,
                  -.2521319663657694e+00,
                  -.1867212475772215e+00,
                  -.9851768832258237e-01,
                  0.2248438188826714e-14,
                  0.9851768832257789e-01,
                  0.1867212475772229e+00,
                  0.2521319663657716e+00,
                  -.1821314114100402e+00,
                  -.1215260326678548e+00,
                  -.4116149244365906e-01,
                  0.4116149244365333e-01,
                  0.1215260326678599e+00,
                  0.1821314114100424e+00,
                  -.1210224291999928e+00,
                  -.6663752612464568e-01,
                  -.3297155053537234e-14,
                  0.6663752612465043e-01,
                  0.1210224291999930e+00,
                  -.7197018241588042e-01,
                  -.2694233310992772e-01,
                  0.2694233310993136e-01,
                  0.7197018241587937e-01,
                  -.3634088748648224e-01,
                  0.4381756892894619e-14,
                  0.3634088748648171e-01,
                  -.1206443294842278e-01,
                  0.1206443294842400e-01,
                  0.6371008117124293e-15],
                 [-.5728322302457899e+00,
                  -.5705045484081017e+00,
                  -.5708993568707638e+00,
                  -.5695227508257004e+00,
                  -.5689401889608477e+00,
                  -.5689440562126804e+00,
                  -.5689258597064417e+00,
                  -.5688339290419947e+00,
                  -.5687520796424828e+00,
                  -.5687201921229100e+00,
                  -.5687520796424829e+00,
                  -.5688339290419948e+00,
                  -.5689258597064416e+00,
                  -.5689440562126806e+00,
                  -.5689401889608480e+00,
                  -.5695227508256998e+00,
                  -.5708993568707631e+00,
                  -.5705045484081017e+00,
                  -.5728322302457916e+00,
                  -.5496083375769233e+00,
                  -.5428683912113088e+00,
                  -.5409406107856427e+00,
                  -.5348389039681941e+00,
                  -.5333260608634321e+00,
                  -.5334504162221657e+00,
                  -.5331158858387414e+00,
                  -.5326143835176513e+00,
                  -.5322904585337303e+00,
                  -.5322904585337309e+00,
                  -.5326143835176520e+00,
                  -.5331158858387410e+00,
                  -.5334504162221659e+00,
                  -.5333260608634341e+00,
                  -.5348389039681919e+00,
                  -.5409406107856377e+00,
                  -.5428683912113113e+00,
                  -.5496083375769242e+00,
                  -.5079550933520322e+00,
                  -.4942751209647941e+00,
                  -.4840717259013923e+00,
                  -.4729769393991251e+00,
                  -.4709220414569869e+00,
                  -.4708599232606506e+00,
                  -.4696866317877679e+00,
                  -.4685545476511670e+00,
                  -.4681138291832117e+00,
                  -.4685545476511686e+00,
                  -.4696866317877680e+00,
                  -.4708599232606499e+00,
                  -.4709220414569916e+00,
                  -.4729769393991244e+00,
                  -.4840717259013866e+00,
                  -.4942751209647999e+00,
                  -.5079550933520303e+00,
                  -.4448667382513939e+00,
                  -.4194193230296013e+00,
                  -.4016831431713569e+00,
                  -.3864182924358064e+00,
                  -.3842573933390488e+00,
                  -.3830572816511297e+00,
                  -.3806325236867222e+00,
                  -.3790347740099094e+00,
                  -.3790347740099109e+00,
                  -.3806325236867235e+00,
                  -.3830572816511276e+00,
                  -.3842573933390544e+00,
                  -.3864182924358085e+00,
                  -.4016831431713472e+00,
                  -.4194193230296075e+00,
                  -.4448667382513946e+00,
                  -.3593231927310510e+00,
                  -.3228367978404291e+00,
                  -.3002843998380523e+00,
                  -.2800504971659806e+00,
                  -.2765057438034514e+00,
                  -.2732521315355564e+00,
                  -.2694357277731399e+00,
                  -.2678962489271487e+00,
                  -.2694357277731414e+00,
                  -.2732521315355539e+00,
                  -.2765057438034566e+00,
                  -.2800504971659855e+00,
                  -.3002843998380422e+00,
                  -.3228367978404312e+00,
                  -.3593231927310555e+00,
                  -.2534831979962594e+00,
                  -.2100397285657708e+00,
                  -.1826263093070758e+00,
                  -.1577533254077484e+00,
                  -.1513497725804402e+00,
                  -.1451052867233916e+00,
                  -.1404791529947459e+00,
                  -.1404791529947461e+00,
                  -.1451052867233887e+00,
                  -.1513497725804431e+00,
                  -.1577533254077555e+00,
                  -.1826263093070740e+00,
                  -.2100397285657699e+00,
                  -.2534831979962656e+00,
                  -.1322204837486841e+00,
                  -.8485451491606928e-01,
                  -.5156422331817216e-01,
                  -.2381936169195912e-01,
                  -.1280107831209319e-01,
                  -.3688557896257970e-02,
                  -.1506525179607164e-14,
                  -.3688557896253027e-02,
                  -.1280107831209274e-01,
                  -.2381936169196350e-01,
                  -.5156422331817780e-01,
                  -.8485451491606900e-01,
                  -.1322204837486881e+00,
                  -.3725777848429803e-03,
                  0.5027965849274903e-01,
                  0.8872731580083158e-01,
                  0.1173790401286141e+00,
                  0.1339481244635706e+00,
                  0.1441677108909916e+00,
                  0.1441677108909971e+00,
                  0.1339481244635744e+00,
                  0.1173790401286151e+00,
                  0.8872731580082449e-01,
                  0.5027965849274624e-01,
                  -.3725777848447978e-03,
                  0.1394531687345157e+00,
                  0.1931280309037876e+00,
                  0.2340569145916073e+00,
                  0.2616557338812892e+00,
                  0.2822368060852274e+00,
                  0.2902105734467691e+00,
                  0.2822368060852303e+00,
                  0.2616557338812932e+00,
                  0.2340569145916051e+00,
                  0.1931280309037845e+00,
                  0.1394531687345141e+00,
                  0.2843600960614580e+00,
                  0.3391624276299462e+00,
                  0.3798272318503382e+00,
                  0.4044518853786816e+00,
                  0.4246019041159929e+00,
                  0.4246019041159867e+00,
                  0.4044518853786800e+00,
                  0.3798272318503421e+00,
                  0.3391624276299468e+00,
                  0.2843600960614567e+00,
                  0.4292989109079697e+00,
                  0.4823347250249018e+00,
                  0.5212508551059395e+00,
                  0.5408106070588836e+00,
                  0.5530114876069080e+00,
                  0.5408106070588726e+00,
                  0.5212508551059447e+00,
                  0.4823347250249049e+00,
                  0.4292989109079692e+00,
                  0.5692065068268348e+00,
                  0.6179704007548075e+00,
                  0.6534862325677202e+00,
                  0.6643078905050395e+00,
                  0.6643078905050399e+00,
                  0.6534862325677271e+00,
                  0.6179704007548074e+00,
                  0.5692065068268332e+00,
                  0.7011463434551232e+00,
                  0.7434901447879359e+00,
                  0.7712064412950292e+00,
                  0.7728365848716234e+00,
                  0.7712064412950492e+00,
                  0.7434901447879327e+00,
                  0.7011463434551189e+00,
                  0.8224272542089413e+00,
                  0.8561628587038664e+00,
                  0.8746600825704744e+00,
                  0.8746600825704859e+00,
                  0.8561628587038640e+00,
                  0.8224272542089379e+00,
                  0.9282633816919012e+00,
                  0.9542582269978049e+00,
                  0.9681434518027777e+00,
                  0.9542582269977932e+00,
                  0.9282633816919020e+00,
                  0.1014389489077096e+01,
                  0.1035215731750442e+01,
                  0.1035215731750426e+01,
                  0.1014389489077096e+01,
                  0.1078854450222795e+01,
                  0.1085736782422617e+01,
                  0.1078854450222795e+01,
                  0.1120112885985025e+01,
                  0.1120112885985026e+01,
                  0.1145664460491582e+01],
                 []],
      quad_degree: 30,
      weights: [0.4743472960336915e-03,
                  0.1713941714851045e-02,
                  0.2632534323997526e-02,
                  0.4540133028177766e-02,
                  0.6304020390710663e-02,
                  0.7492693208612421e-02,
                  0.8341386313560213e-02,
                  0.9030216669348540e-02,
                  0.9577003980623624e-02,
                  0.9801034174631950e-02,
                  0.9577003980623478e-02,
                  0.9030216669348386e-02,
                  0.8341386313560186e-02,
                  0.7492693208612411e-02,
                  0.6304020390710796e-02,
                  0.4540133028178217e-02,
                  0.2632534323997551e-02,
                  0.1713941714850677e-02,
                  0.4743472960338288e-03,
                  0.1713941714850656e-02,
                  0.4278973827035431e-02,
                  0.7916032605362004e-02,
                  0.1259241290874229e-01,
                  0.1581526283993698e-01,
                  0.1790348537260168e-01,
                  0.1971087954353484e-01,
                  0.2131899566396174e-01,
                  0.2236559012425326e-01,
                  0.2236559012425335e-01,
                  0.2131899566396183e-01,
                  0.1971087954353461e-01,
                  0.1790348537260075e-01,
                  0.1581526283993534e-01,
                  0.1259241290874253e-01,
                  0.7916032605363065e-02,
                  0.4278973827035813e-02,
                  0.1713941714851114e-02,
                  0.2632534323997764e-02,
                  0.7916032605363444e-02,
                  0.1460453049042301e-01,
                  0.2075958191293315e-01,
                  0.2504647064094287e-01,
                  0.2865826239744238e-01,
                  0.3165611771665740e-01,
                  0.3363770292960962e-01,
                  0.3434895067984112e-01,
                  0.3363770292961071e-01,
                  0.3165611771665944e-01,
                  0.2865826239744465e-01,
                  0.2504647064094216e-01,
                  0.2075958191293123e-01,
                  0.1460453049042258e-01,
                  0.7916032605362330e-02,
                  0.2632534323997515e-02,
                  0.4540133028178520e-02,
                  0.1259241290874273e-01,
                  0.2075958191293140e-01,
                  0.2853840625847389e-01,
                  0.3417646575529255e-01,
                  0.3885101296900445e-01,
                  0.4222691310378054e-01,
                  0.4401867750359191e-01,
                  0.4401867750359176e-01,
                  0.4222691310378035e-01,
                  0.3885101296900567e-01,
                  0.3417646575529322e-01,
                  0.2853840625847347e-01,
                  0.2075958191293194e-01,
                  0.1259241290874233e-01,
                  0.4540133028177812e-02,
                  0.6304020390710562e-02,
                  0.1581526283993519e-01,
                  0.2504647064094251e-01,
                  0.3417646575529329e-01,
                  0.4164328749218054e-01,
                  0.4815412016015223e-01,
                  0.5271955863740355e-01,
                  0.5438569882720394e-01,
                  0.5271955863740335e-01,
                  0.4815412016015230e-01,
                  0.4164328749218120e-01,
                  0.3417646575529277e-01,
                  0.2504647064094206e-01,
                  0.1581526283993631e-01,
                  0.6304020390710441e-02,
                  0.7492693208612289e-02,
                  0.1790348537260130e-01,
                  0.2865826239744496e-01,
                  0.3885101296900474e-01,
                  0.4815412016015101e-01,
                  0.5592026908058544e-01,
                  0.6020994324521257e-01,
                  0.6020994324521272e-01,
                  0.5592026908058601e-01,
                  0.4815412016015261e-01,
                  0.3885101296900508e-01,
                  0.2865826239744295e-01,
                  0.1790348537260160e-01,
                  0.7492693208612442e-02,
                  0.8341386313560221e-02,
                  0.1971087954353484e-01,
                  0.3165611771665890e-01,
                  0.4222691310377889e-01,
                  0.5271955863740297e-01,
                  0.6020994324521291e-01,
                  0.6281112556851371e-01,
                  0.6020994324521334e-01,
                  0.5271955863740431e-01,
                  0.4222691310378092e-01,
                  0.3165611771665830e-01,
                  0.1971087954353466e-01,
                  0.8341386313560439e-02,
                  0.9030216669348509e-02,
                  0.2131899566396187e-01,
                  0.3363770292961047e-01,
                  0.4401867750359171e-01,
                  0.5438569882720457e-01,
                  0.6020994324521323e-01,
                  0.6020994324521346e-01,
                  0.5438569882720509e-01,
                  0.4401867750359321e-01,
                  0.3363770292961143e-01,
                  0.2131899566396197e-01,
                  0.9030216669348758e-02,
                  0.9577003980623701e-02,
                  0.2236559012425353e-01,
                  0.3434895067984170e-01,
                  0.4401867750359306e-01,
                  0.5271955863740448e-01,
                  0.5592026908058633e-01,
                  0.5271955863740382e-01,
                  0.4401867750359273e-01,
                  0.3434895067984313e-01,
                  0.2236559012425407e-01,
                  0.9577003980623903e-02,
                  0.9801034174632030e-02,
                  0.2236559012425328e-01,
                  0.3363770292961043e-01,
                  0.4222691310378180e-01,
                  0.4815412016015319e-01,
                  0.4815412016015202e-01,
                  0.4222691310377997e-01,
                  0.3363770292961131e-01,
                  0.2236559012425374e-01,
                  0.9801034174632099e-02,
                  0.9577003980623401e-02,
                  0.2131899566396141e-01,
                  0.3165611771665807e-01,
                  0.3885101296900571e-01,
                  0.4164328749218112e-01,
                  0.3885101296900566e-01,
                  0.3165611771665887e-01,
                  0.2131899566396139e-01,
                  0.9577003980623303e-02,
                  0.9030216669348272e-02,
                  0.1971087954353461e-01,
                  0.2865826239744295e-01,
                  0.3417646575529287e-01,
                  0.3417646575529347e-01,
                  0.2865826239744461e-01,
                  0.1971087954353450e-01,
                  0.9030216669348194e-02,
                  0.8341386313560279e-02,
                  0.1790348537260178e-01,
                  0.2504647064094248e-01,
                  0.2853840625847335e-01,
                  0.2504647064094192e-01,
                  0.1790348537260154e-01,
                  0.8341386313560437e-02,
                  0.7492693208612660e-02,
                  0.1581526283993677e-01,
                  0.2075958191293224e-01,
                  0.2075958191293059e-01,
                  0.1581526283993513e-01,
                  0.7492693208612642e-02,
                  0.6304020390710779e-02,
                  0.1259241290874214e-01,
                  0.1460453049042238e-01,
                  0.1259241290874209e-01,
                  0.6304020390710539e-02,
                  0.4540133028177791e-02,
                  0.7916032605362167e-02,
                  0.7916032605363000e-02,
                  0.4540133028178164e-02,
                  0.2632534323997612e-02,
                  0.4278973827035949e-02,
                  0.2632534323997811e-02,
                  0.1713941714851161e-02,
                  0.1713941714850610e-02,
                  0.4743472960337284e-03]},
 19: {points: [[-.9904256394816976e+00,
                  -.9605230488327409e+00,
                  -.9179050203010608e+00,
                  -.8634895018682717e+00,
                  -.7754067380668079e+00,
                  -.6595343539765489e+00,
                  -.5273264986768963e+00,
                  -.3866305176246266e+00,
                  -.2383840529840060e+00,
                  -.8093097777771794e-01,
                  0.8093097777706427e-01,
                  0.2383840529842243e+00,
                  0.3866305176252008e+00,
                  0.5273264986765308e+00,
                  0.6595343539757088e+00,
                  0.7754067380668604e+00,
                  0.8634895018689964e+00,
                  0.9179050203003471e+00,
                  0.9605230488318647e+00,
                  0.9904256394816424e+00,
                  -.9746607658633496e+00,
                  -.9506032932327854e+00,
                  -.9002958417738464e+00,
                  -.8199434611019921e+00,
                  -.7131007664213403e+00,
                  -.5870775973394936e+00,
                  -.4506071675716478e+00,
                  -.3085805642456947e+00,
                  -.1583017190678383e+00,
                  -.4408013868224158e-12,
                  0.1583017190678294e+00,
                  0.3085805642465469e+00,
                  0.4506071675714673e+00,
                  0.5870775973381755e+00,
                  0.7131007664208121e+00,
                  0.8199434611022849e+00,
                  0.9002958417751421e+00,
                  0.9506032932335547e+00,
                  0.9746607658639199e+00,
                  -.9542247780740522e+00,
                  -.9218117390941758e+00,
                  -.8504514650933881e+00,
                  -.7592302753266182e+00,
                  -.6462417343541447e+00,
                  -.5192227614616422e+00,
                  -.3828780685444871e+00,
                  -.2363348764900891e+00,
                  -.8004700387576616e-01,
                  0.8004700387510774e-01,
                  0.2363348764909225e+00,
                  0.3828780685451929e+00,
                  0.5192227614604535e+00,
                  0.6462417343529667e+00,
                  0.7592302753256477e+00,
                  0.8504514650931870e+00,
                  0.9218117390936451e+00,
                  0.9542247780744625e+00,
                  -.9257995484695600e+00,
                  -.8782607160085346e+00,
                  -.8017144817017791e+00,
                  -.7176554201781175e+00,
                  -.6036739996973286e+00,
                  -.4720896132551740e+00,
                  -.3250429286162026e+00,
                  -.1657354227545497e+00,
                  -.4047370175473558e-12,
                  0.1657354227545005e+00,
                  0.3250429286174033e+00,
                  0.4720896132561049e+00,
                  0.6036739996983864e+00,
                  0.7176554201784333e+00,
                  0.8017144817021843e+00,
                  0.8782607160082117e+00,
                  0.9257995484692946e+00,
                  -.8814368757708810e+00,
                  -.8232737207488019e+00,
                  -.7414092000835307e+00,
                  -.6526425379631303e+00,
                  -.5294891001853250e+00,
                  -.3931435099486461e+00,
                  -.2431689991747336e+00,
                  -.8237740629712396e-01,
                  0.8237740629600203e-01,
                  0.2431689991742344e+00,
                  0.3931435099480128e+00,
                  0.5294891001854767e+00,
                  0.6526425379628848e+00,
                  0.7414092000841958e+00,
                  0.8232737207489158e+00,
                  0.8814368757708191e+00,
                  -.8232804235196405e+00,
                  -.7592096542085920e+00,
                  -.6758437817024645e+00,
                  -.5833176103331118e+00,
                  -.4571227061438063e+00,
                  -.3179219184687215e+00,
                  -.1634394959526169e+00,
                  0.1440015032874087e-12,
                  0.1634394959530310e+00,
                  0.3179219184687686e+00,
                  0.4571227061443922e+00,
                  0.5833176103335226e+00,
                  0.6758437817038841e+00,
                  0.7592096542095396e+00,
                  0.8232804235200767e+00,
                  -.7570443430297013e+00,
                  -.6905717409476746e+00,
                  -.6070853043877500e+00,
                  -.5085232387587735e+00,
                  -.3796483470957696e+00,
                  -.2365091215959196e+00,
                  -.8035871987529573e-01,
                  0.8035871987521126e-01,
                  0.2365091215951292e+00,
                  0.3796483470951934e+00,
                  0.5085232387577348e+00,
                  0.6070853043873108e+00,
                  0.6905717409478730e+00,
                  0.7570443430298952e+00,
                  -.6866642174078031e+00,
                  -.6194086082348975e+00,
                  -.5331923609289879e+00,
                  -.4274057286277187e+00,
                  -.2971343032671493e+00,
                  -.1529498727722256e+00,
                  0.3673322599293325e-12,
                  0.1529498727722905e+00,
                  0.2971343032672404e+00,
                  0.4274057286272448e+00,
                  0.5331923609282725e+00,
                  0.6194086082343046e+00,
                  0.6866642174074781e+00,
                  -.6124976536612101e+00,
                  -.5439625587021166e+00,
                  -.4543811290799468e+00,
                  -.3437539247480297e+00,
                  -.2147568969701902e+00,
                  -.7306962564233021e-01,
                  0.7306962564307376e-01,
                  0.2147568969710394e+00,
                  0.3437539247483887e+00,
                  0.4543811290801573e+00,
                  0.5439625587020769e+00,
                  0.6124976536610643e+00,
                  -.5337174637054665e+00,
                  -.4646579730827667e+00,
                  -.3743341252043487e+00,
                  -.2616703058726489e+00,
                  -.1364793479205100e+00,
                  0.8874000083471761e-14,
                  0.1364793479213544e+00,
                  0.2616703058731229e+00,
                  0.3743341252047848e+00,
                  0.4646579730832236e+00,
                  0.5337174637057896e+00,
                  -.4527864859280761e+00,
                  -.3856608396341530e+00,
                  -.2968574844379914e+00,
                  -.1834803101413347e+00,
                  -.6397919619582282e-01,
                  0.6397919619549389e-01,
                  0.1834803101412013e+00,
                  0.2968574844380035e+00,
                  0.3856608396342764e+00,
                  0.4527864859283913e+00,
                  -.3741136006770560e+00,
                  -.3108280439885221e+00,
                  -.2242072358426881e+00,
                  -.1112279970781634e+00,
                  -.3737416234538919e-12,
                  0.1112279970768776e+00,
                  0.2242072358426297e+00,
                  0.3108280439883626e+00,
                  0.3741136006769809e+00,
                  -.3000336997828609e+00,
                  -.2399645733762777e+00,
                  -.1566210202423945e+00,
                  -.4896853826558405e-01,
                  0.4896853826490651e-01,
                  0.1566210202422527e+00,
                  0.2399645733762524e+00,
                  0.3000336997825706e+00,
                  -.2297178443530275e+00,
                  -.1721320568701896e+00,
                  -.9516746573033884e-01,
                  -.9566932461237383e-13,
                  0.9516746573083445e-01,
                  0.1721320568704678e+00,
                  0.2297178443531182e+00,
                  -.1637460695435296e+00,
                  -.1101729543276561e+00,
                  -.4248420637559659e-01,
                  0.4248420637620064e-01,
                  0.1101729543280279e+00,
                  0.1637460695439062e+00,
                  -.1060301377039355e+00,
                  -.5831725490609414e-01,
                  0.2386930286578258e-12,
                  0.5831725490612985e-01,
                  0.1060301377040183e+00,
                  -.6231004660092546e-01,
                  -.2151589731965197e-01,
                  0.2151589731897274e-01,
                  0.6231004660054057e-01,
                  -.3631975777349347e-01,
                  -.9575214046524965e-12,
                  0.3631975777380490e-01,
                  -.1413771703119468e-01,
                  0.1413771703143592e-01,
                  0.8328113976235097e-13],
                 [-.5718225095670032e+00,
                  -.5708830702738143e+00,
                  -.5718911544160363e+00,
                  -.5704853407026158e+00,
                  -.5701143460455190e+00,
                  -.5698600114675469e+00,
                  -.5697074145116579e+00,
                  -.5696703080986907e+00,
                  -.5696202732776391e+00,
                  -.5695583208777318e+00,
                  -.5695583208777309e+00,
                  -.5696202732776875e+00,
                  -.5696703080987128e+00,
                  -.5697074145115888e+00,
                  -.5698600114674987e+00,
                  -.5701143460456097e+00,
                  -.5704853407025947e+00,
                  -.5718911544160513e+00,
                  -.5708830702735845e+00,
                  -.5718225095671066e+00,
                  -.5463958260721216e+00,
                  -.5488310672413980e+00,
                  -.5446304648171534e+00,
                  -.5407335436244093e+00,
                  -.5389256891296004e+00,
                  -.5377103875993929e+00,
                  -.5372453915657504e+00,
                  -.5370723815708885e+00,
                  -.5367183192743723e+00,
                  -.5365408116811082e+00,
                  -.5367183192744785e+00,
                  -.5370723815711459e+00,
                  -.5372453915656117e+00,
                  -.5377103875989988e+00,
                  -.5389256891297516e+00,
                  -.5407335436246074e+00,
                  -.5446304648171667e+00,
                  -.5488310672400866e+00,
                  -.5463958260727207e+00,
                  -.5089834886333346e+00,
                  -.5073638374901637e+00,
                  -.4910083823040792e+00,
                  -.4873983398111196e+00,
                  -.4829977632058494e+00,
                  -.4806237774946636e+00,
                  -.4799469718771195e+00,
                  -.4792295016629398e+00,
                  -.4784589751425905e+00,
                  -.4784589751427369e+00,
                  -.4792295016633853e+00,
                  -.4799469718773365e+00,
                  -.4806237774937444e+00,
                  -.4829977632057761e+00,
                  -.4873983398112299e+00,
                  -.4910083823044739e+00,
                  -.5073638374891398e+00,
                  -.5089834886339501e+00,
                  -.4625611741683600e+00,
                  -.4397250951692564e+00,
                  -.4138135358486027e+00,
                  -.4143385500253392e+00,
                  -.4050753437271985e+00,
                  -.4009960934037188e+00,
                  -.3995284352369162e+00,
                  -.3978382340104134e+00,
                  -.3969328419765373e+00,
                  -.3978382340110004e+00,
                  -.3995284352374564e+00,
                  -.4009960934027043e+00,
                  -.4050753437269525e+00,
                  -.4143385500250967e+00,
                  -.4138135358494559e+00,
                  -.4397250951691154e+00,
                  -.4625611741678842e+00,
                  -.3864647604087278e+00,
                  -.3481005346137473e+00,
                  -.3181628773323430e+00,
                  -.3202593474793219e+00,
                  -.3057006745254600e+00,
                  -.3008583235911590e+00,
                  -.2979864636531166e+00,
                  -.2955405222524716e+00,
                  -.2955405222529425e+00,
                  -.2979864636539920e+00,
                  -.3008583235906056e+00,
                  -.3057006745248845e+00,
                  -.3202593474784432e+00,
                  -.3181628773333271e+00,
                  -.3481005346142208e+00,
                  -.3864647604087968e+00,
                  -.2862434994778557e+00,
                  -.2395689194881429e+00,
                  -.2093482129007237e+00,
                  -.2083435512412037e+00,
                  -.1900431051530695e+00,
                  -.1835523052091357e+00,
                  -.1787353730526741e+00,
                  -.1766113004349243e+00,
                  -.1787353730536156e+00,
                  -.1835523052091046e+00,
                  -.1900431051530584e+00,
                  -.2083435512399794e+00,
                  -.2093482129013897e+00,
                  -.2395689194890030e+00,
                  -.2862434994785118e+00,
                  -.1718244366868716e+00,
                  -.1216145584614105e+00,
                  -.9160864797321257e-01,
                  -.8173121588456378e-01,
                  -.6159729887113088e-01,
                  -.5217506894996591e-01,
                  -.4639512855118827e-01,
                  -.4639512855169350e-01,
                  -.5217506895016652e-01,
                  -.6159729887167263e-01,
                  -.8173121588374913e-01,
                  -.9160864797285858e-01,
                  -.1216145584614827e+00,
                  -.1718244366870714e+00,
                  -.4999669609239774e-01,
                  0.1297583033980034e-02,
                  0.3494274399026588e-01,
                  0.5538803059298578e-01,
                  0.7642933457595522e-01,
                  0.8830565021772766e-01,
                  0.9279025710377474e-01,
                  0.8830565021786792e-01,
                  0.7642933457507392e-01,
                  0.5538803059280890e-01,
                  0.3494274399071401e-01,
                  0.1297583034525267e-02,
                  -.4999669609187687e-01,
                  0.7836349089744030e-01,
                  0.1312658494617545e+00,
                  0.1699067487185982e+00,
                  0.1984664209885336e+00,
                  0.2191111876771975e+00,
                  0.2309104420034273e+00,
                  0.2309104420041731e+00,
                  0.2191111876768074e+00,
                  0.1984664209880228e+00,
                  0.1699067487180304e+00,
                  0.1312658494616563e+00,
                  0.7836349089760494e-01,
                  0.2146908777308036e+00,
                  0.2682704058409527e+00,
                  0.3085522264245802e+00,
                  0.3424502034176568e+00,
                  0.3595837625244657e+00,
                  0.3671046104184269e+00,
                  0.3595837625248616e+00,
                  0.3424502034180698e+00,
                  0.3085522264241517e+00,
                  0.2682704058401869e+00,
                  0.2146908777302530e+00,
                  0.3548674431474799e+00,
                  0.4054524698128031e+00,
                  0.4442867576723829e+00,
                  0.4812596511207493e+00,
                  0.4909014287436213e+00,
                  0.4909014287431594e+00,
                  0.4812596511221327e+00,
                  0.4442867576732847e+00,
                  0.4054524698128080e+00,
                  0.3548674431469347e+00,
                  0.4912567823800991e+00,
                  0.5357747985364700e+00,
                  0.5715556198501918e+00,
                  0.6093396446437598e+00,
                  0.6114013490496422e+00,
                  0.6093396446439455e+00,
                  0.5715556198507708e+00,
                  0.5357747985372821e+00,
                  0.4912567823803277e+00,
                  0.6196670041906056e+00,
                  0.6588599500271913e+00,
                  0.6899719903961146e+00,
                  0.7253346912058206e+00,
                  0.7253346912062797e+00,
                  0.6899719903944873e+00,
                  0.6588599500269694e+00,
                  0.6196670041911582e+00,
                  0.7415318511986667e+00,
                  0.7772793070882418e+00,
                  0.8011606405391045e+00,
                  0.8286771000509260e+00,
                  0.8011606405379782e+00,
                  0.7772793070869356e+00,
                  0.7415318511983679e+00,
                  0.8561035109459912e+00,
                  0.8870262237437315e+00,
                  0.9012118756605127e+00,
                  0.9012118756598338e+00,
                  0.8870262237433580e+00,
                  0.8561035109452344e+00,
                  0.9565791064542960e+00,
                  0.9804586387934703e+00,
                  0.9820167646086112e+00,
                  0.9804586387939059e+00,
                  0.9565791064543309e+00,
                  0.1033046514870404e+01,
                  0.1051994302306424e+01,
                  0.1051994302307648e+01,
                  0.1033046514871072e+01,
                  0.1080874643049933e+01,
                  0.1097662134481586e+01,
                  0.1080874643049408e+01,
                  0.1117278896346583e+01,
                  0.1117278896345555e+01,
                  0.1143645019134149e+01],
                 []],
      quad_degree: 32,
      weights: [0.6523307465903116e-03,
                  0.1665428466917971e-02,
                  0.1697926549306293e-02,
                  0.3218813991449317e-02,
                  0.5071282336131599e-02,
                  0.6345384014673819e-02,
                  0.7073841872222633e-02,
                  0.7458648056795123e-02,
                  0.7974235573077549e-02,
                  0.8462632029887704e-02,
                  0.8462632029915494e-02,
                  0.7974235573078371e-02,
                  0.7458648056751495e-02,
                  0.7073841872233551e-02,
                  0.6345384014723816e-02,
                  0.5071282336130859e-02,
                  0.3218813991442912e-02,
                  0.1697926549246161e-02,
                  0.1665428467025224e-02,
                  0.6523307465904334e-03,
                  0.1665428467022219e-02,
                  0.2530237495042963e-02,
                  0.6448116579026527e-02,
                  0.1007446386644781e-01,
                  0.1329009339913520e-01,
                  0.1551428661448465e-01,
                  0.1651447345208812e-01,
                  0.1732930201067814e-01,
                  0.1864545386043287e-01,
                  0.1930909253888154e-01,
                  0.1864545386054272e-01,
                  0.1732930201057888e-01,
                  0.1651447345195716e-01,
                  0.1551428661460109e-01,
                  0.1329009339919976e-01,
                  0.1007446386652261e-01,
                  0.6448116579074161e-02,
                  0.2530237495028355e-02,
                  0.1665428466926124e-02,
                  0.1697926549255138e-02,
                  0.6448116579065956e-02,
                  0.1298502354862214e-01,
                  0.1678913124636871e-01,
                  0.2103463134648213e-01,
                  0.2371912606166288e-01,
                  0.2561196632339163e-01,
                  0.2784051786046975e-01,
                  0.2942643935454983e-01,
                  0.2942643935469313e-01,
                  0.2784051786059235e-01,
                  0.2561196632309825e-01,
                  0.2371912606163362e-01,
                  0.2103463134651306e-01,
                  0.1678913124651485e-01,
                  0.1298502354863200e-01,
                  0.6448116579021551e-02,
                  0.1697926549292553e-02,
                  0.3218813991429790e-02,
                  0.1007446386650514e-01,
                  0.1678913124651023e-01,
                  0.2117050758056643e-01,
                  0.2783668123002127e-01,
                  0.3284492101324905e-01,
                  0.3674878917830867e-01,
                  0.3946501978088558e-01,
                  0.4044757251498786e-01,
                  0.3946501978108946e-01,
                  0.3674878917847820e-01,
                  0.3284492101322891e-01,
                  0.2783668122997893e-01,
                  0.2117050758054424e-01,
                  0.1678913124634770e-01,
                  0.1007446386643783e-01,
                  0.3218813991440470e-02,
                  0.5071282336127157e-02,
                  0.1329009339920679e-01,
                  0.2103463134656897e-01,
                  0.2783668122996234e-01,
                  0.3535459889584929e-01,
                  0.4057408388081932e-01,
                  0.4506308865705787e-01,
                  0.4779446928138926e-01,
                  0.4779446928146555e-01,
                  0.4506308865716773e-01,
                  0.4057408388089925e-01,
                  0.3535459889589548e-01,
                  0.2783668123003341e-01,
                  0.2103463134652690e-01,
                  0.1329009339914650e-01,
                  0.5071282336133728e-02,
                  0.6345384014726124e-02,
                  0.1551428661461730e-01,
                  0.2371912606163842e-01,
                  0.3284492101317082e-01,
                  0.4057408388086140e-01,
                  0.4738985453736429e-01,
                  0.5264302957180104e-01,
                  0.5452241244100795e-01,
                  0.5264302957184792e-01,
                  0.4738985453733955e-01,
                  0.4057408388080401e-01,
                  0.3284492101322997e-01,
                  0.2371912606165501e-01,
                  0.1551428661450095e-01,
                  0.6345384014679880e-02,
                  0.7073841872238434e-02,
                  0.1651447345195982e-01,
                  0.2561196632304381e-01,
                  0.3674878917843735e-01,
                  0.4506308865716684e-01,
                  0.5264302957185833e-01,
                  0.5695718608515374e-01,
                  0.5695718608514931e-01,
                  0.5264302957178254e-01,
                  0.4506308865704087e-01,
                  0.3674878917828970e-01,
                  0.2561196632333397e-01,
                  0.1651447345207727e-01,
                  0.7073841872227685e-02,
                  0.7458648056750597e-02,
                  0.1732930201056435e-01,
                  0.2784051786054409e-01,
                  0.3946501978107228e-01,
                  0.4779446928146156e-01,
                  0.5452241244099130e-01,
                  0.5695718608513758e-01,
                  0.5452241244098644e-01,
                  0.4779446928137659e-01,
                  0.3946501978087411e-01,
                  0.2784051786043875e-01,
                  0.1732930201065193e-01,
                  0.7458648056789426e-02,
                  0.7974235573073323e-02,
                  0.1864545386052885e-01,
                  0.2942643935468195e-01,
                  0.4044757251498481e-01,
                  0.4779446928136336e-01,
                  0.5264302957174777e-01,
                  0.5264302957180875e-01,
                  0.4779446928144365e-01,
                  0.4044757251497669e-01,
                  0.2942643935454391e-01,
                  0.1864545386041722e-01,
                  0.7974235573067829e-02,
                  0.8462632029909350e-02,
                  0.1930909253887676e-01,
                  0.2942643935456543e-01,
                  0.3946501978089309e-01,
                  0.4506308865701871e-01,
                  0.4738985453727846e-01,
                  0.4506308865713162e-01,
                  0.3946501978107383e-01,
                  0.2942643935468836e-01,
                  0.1930909253887108e-01,
                  0.8462632029878854e-02,
                  0.8462632029882008e-02,
                  0.1864545386042676e-01,
                  0.2784051786047387e-01,
                  0.3674878917833161e-01,
                  0.4057408388084098e-01,
                  0.4057408388089135e-01,
                  0.3674878917846030e-01,
                  0.2784051786056343e-01,
                  0.1864545386052779e-01,
                  0.8462632029908089e-02,
                  0.7974235573070362e-02,
                  0.1732930201064860e-01,
                  0.2561196632334758e-01,
                  0.3284492101329157e-01,
                  0.3535459889598715e-01,
                  0.3284492101322545e-01,
                  0.2561196632304120e-01,
                  0.1732930201054898e-01,
                  0.7974235573070670e-02,
                  0.7458648056788231e-02,
                  0.1651447345206498e-01,
                  0.2371912606163429e-01,
                  0.2783668123005096e-01,
                  0.2783668122999907e-01,
                  0.2371912606162619e-01,
                  0.1651447345194196e-01,
                  0.7458648056744191e-02,
                  0.7073841872223811e-02,
                  0.1551428661449443e-01,
                  0.2103463134648820e-01,
                  0.2117050758048889e-01,
                  0.2103463134655125e-01,
                  0.1551428661461808e-01,
                  0.7073841872234655e-02,
                  0.6345384014679200e-02,
                  0.1329009339915174e-01,
                  0.1678913124636116e-01,
                  0.1678913124649092e-01,
                  0.1329009339921754e-01,
                  0.6345384014728425e-02,
                  0.5071282336136078e-02,
                  0.1007446386646081e-01,
                  0.1298502354866266e-01,
                  0.1007446386652825e-01,
                  0.5071282336135480e-02,
                  0.3218813991447063e-02,
                  0.6448116579024134e-02,
                  0.6448116579086424e-02,
                  0.3218813991441084e-02,
                  0.1697926549292154e-02,
                  0.2530237494998103e-02,
                  0.1697926549226762e-02,
                  0.1665428466920318e-02,
                  0.1665428467045490e-02,
                  0.6523307465872451e-03]},
 20: {points: [[-.9914987061385606e+00,
                  -.9731849291712046e+00,
                  -.9336161666666045e+00,
                  -.8709366265025180e+00,
                  -.7890219330561955e+00,
                  -.6882507357614510e+00,
                  -.5709345042503457e+00,
                  -.4402661110237771e+00,
                  -.2993698506133705e+00,
                  -.1514531774825752e+00,
                  -.5394827193893844e-15,
                  0.1514531774825754e+00,
                  0.2993698506133702e+00,
                  0.4402661110237721e+00,
                  0.5709345042503414e+00,
                  0.6882507357614552e+00,
                  0.7890219330561985e+00,
                  0.8709366265025092e+00,
                  0.9336161666666036e+00,
                  0.9731849291712050e+00,
                  0.9914987061385615e+00,
                  -.9830828857023623e+00,
                  -.9554316851661159e+00,
                  -.9027782337016863e+00,
                  -.8308760682650729e+00,
                  -.7419202989769888e+00,
                  -.6316867298045830e+00,
                  -.5059470854092904e+00,
                  -.3697257780432263e+00,
                  -.2255316822283426e+00,
                  -.7583311963980857e-01,
                  0.7583311963980478e-01,
                  0.2255316822283443e+00,
                  0.3697257780432297e+00,
                  0.5059470854092942e+00,
                  0.6316867298045936e+00,
                  0.7419202989770022e+00,
                  0.8308760682650767e+00,
                  0.9027782337017025e+00,
                  0.9554316851661151e+00,
                  0.9830828857023662e+00,
                  -.9618267070367470e+00,
                  -.9239995559127758e+00,
                  -.8645068179401706e+00,
                  -.7846034119256160e+00,
                  -.6863887330759483e+00,
                  -.5673113198192923e+00,
                  -.4370254588981077e+00,
                  -.2983969068641189e+00,
                  -.1516098100658487e+00,
                  0.1523611008998239e-14,
                  0.1516098100658499e+00,
                  0.2983969068641131e+00,
                  0.4370254588980954e+00,
                  0.5673113198192841e+00,
                  0.6863887330759364e+00,
                  0.7846034119255868e+00,
                  0.8645068179401618e+00,
                  0.9239995559127548e+00,
                  0.9618267070367427e+00,
                  -.9297830281756335e+00,
                  -.8855442336982967e+00,
                  -.8193695144049993e+00,
                  -.7324040164793770e+00,
                  -.6277179424399427e+00,
                  -.5030553084683138e+00,
                  -.3689188206020265e+00,
                  -.2258626120832975e+00,
                  -.7600095256339588e-01,
                  0.7600095256340205e-01,
                  0.2258626120832939e+00,
                  0.3689188206020127e+00,
                  0.5030553084683106e+00,
                  0.6277179424399505e+00,
                  0.7324040164793802e+00,
                  0.8193695144050228e+00,
                  0.8855442336983011e+00,
                  0.9297830281756405e+00,
                  -.8888185851603309e+00,
                  -.8407421368036038e+00,
                  -.7686192430491448e+00,
                  -.6761284067154722e+00,
                  -.5645616944937807e+00,
                  -.4347084668152292e+00,
                  -.2973997138720624e+00,
                  -.1513923380373377e+00,
                  0.1099195418521473e-13,
                  0.1513923380373532e+00,
                  0.2973997138720616e+00,
                  0.4347084668152244e+00,
                  0.5645616944937721e+00,
                  0.6761284067154541e+00,
                  0.7686192430491409e+00,
                  0.8407421368035938e+00,
                  0.8888185851603311e+00,
                  -.8381520570119324e+00,
                  -.7839831193828528e+00,
                  -.7053601646846393e+00,
                  -.6080650829216628e+00,
                  -.4927658920603159e+00,
                  -.3630719650913432e+00,
                  -.2251754322292612e+00,
                  -.7648401051176164e-01,
                  0.7648401051175815e-01,
                  0.2251754322292528e+00,
                  0.3630719650913410e+00,
                  0.4927658920603135e+00,
                  0.6080650829216574e+00,
                  0.7053601646846360e+00,
                  0.7839831193828421e+00,
                  0.8381520570119299e+00,
                  -.7792538172624827e+00,
                  -.7203260583636952e+00,
                  -.6394325617328811e+00,
                  -.5408893538965944e+00,
                  -.4246620068583433e+00,
                  -.2941815883872542e+00,
                  -.1517370234941091e+00,
                  0.1548295310348331e-14,
                  0.1517370234941093e+00,
                  0.2941815883872603e+00,
                  0.4246620068583465e+00,
                  0.5408893538966036e+00,
                  0.6394325617328875e+00,
                  0.7203260583636919e+00,
                  0.7792538172624827e+00,
                  -.7139062422604249e+00,
                  -.6524599115146604e+00,
                  -.5708473779947076e+00,
                  -.4701130144012503e+00,
                  -.3515955664891516e+00,
                  -.2186339338226639e+00,
                  -.7441888402959237e-01,
                  0.7441888402958868e-01,
                  0.2186339338226648e+00,
                  0.3515955664891427e+00,
                  0.4701130144012509e+00,
                  0.5708473779947098e+00,
                  0.6524599115146584e+00,
                  0.7139062422604236e+00,
                  -.6435232782060199e+00,
                  -.5805490890310881e+00,
                  -.4974387049396102e+00,
                  -.3947010330394787e+00,
                  -.2752441175119213e+00,
                  -.1421499233109038e+00,
                  -.2817164376427763e-14,
                  0.1421499233109056e+00,
                  0.2752441175119113e+00,
                  0.3947010330394750e+00,
                  0.4974387049396087e+00,
                  0.5805490890310873e+00,
                  0.6435232782060163e+00,
                  -.5695624152141832e+00,
                  -.5055762268632077e+00,
                  -.4213904631077243e+00,
                  -.3187000804760786e+00,
                  -.2002032284518045e+00,
                  -.6900615615800021e-01,
                  0.6900615615800076e-01,
                  0.2002032284517988e+00,
                  0.3187000804760776e+00,
                  0.4213904631077241e+00,
                  0.5055762268632112e+00,
                  0.5695624152141811e+00,
                  -.4938146922883048e+00,
                  -.4297431072234001e+00,
                  -.3458288948737591e+00,
                  -.2442504023179537e+00,
                  -.1272622929862832e+00,
                  0.3540553681719405e-14,
                  0.1272622929862804e+00,
                  0.2442504023179558e+00,
                  0.3458288948737601e+00,
                  0.4297431072234035e+00,
                  0.4938146922883043e+00,
                  -.4181092377316062e+00,
                  -.3550174068027429e+00,
                  -.2724504711305912e+00,
                  -.1719705332945778e+00,
                  -.5805742524508234e-01,
                  0.5805742524509182e-01,
                  0.1719705332945802e+00,
                  0.2724504711305924e+00,
                  0.3550174068027418e+00,
                  0.4181092377316046e+00,
                  -.3441534275926473e+00,
                  -.2827341334714323e+00,
                  -.2024071028347807e+00,
                  -.1050097744533446e+00,
                  0.8364613905728534e-14,
                  0.1050097744533529e+00,
                  0.2024071028347844e+00,
                  0.2827341334714287e+00,
                  0.3441534275926459e+00,
                  -.2736401312366489e+00,
                  -.2143789729544029e+00,
                  -.1380488448653442e+00,
                  -.4841046427551292e-01,
                  0.4841046427552170e-01,
                  0.1380488448653555e+00,
                  0.2143789729544013e+00,
                  0.2736401312366512e+00,
                  -.2083193130121383e+00,
                  -.1522963895782599e+00,
                  -.8223050997319206e-01,
                  -.2896403324444997e-14,
                  0.8223050997320734e-01,
                  0.1522963895782601e+00,
                  0.2083193130121423e+00,
                  -.1499013212504784e+00,
                  -.9882183782660476e-01,
                  -.3476610247940627e-01,
                  0.3476610247941285e-01,
                  0.9882183782660088e-01,
                  0.1499013212504785e+00,
                  -.9979665210413433e-01,
                  -.5466816543322907e-01,
                  0.7432520885228033e-14,
                  0.5466816543322009e-01,
                  0.9979665210413277e-01,
                  -.5884640167312196e-01,
                  -.2122132221106886e-01,
                  0.2122132221107052e-01,
                  0.5884640167312515e-01,
                  -.2821054037013645e-01,
                  0.1990208366305177e-15,
                  0.2821054037014254e-01,
                  -.9897956531161672e-02,
                  0.9897956531158296e-02,
                  -.1284738952400959e-14],
                 [-.5724420448902635e+00,
                  -.5732977565636699e+00,
                  -.5715982712981176e+00,
                  -.5707854674519692e+00,
                  -.5707772733596045e+00,
                  -.5704528839135208e+00,
                  -.5701756126084950e+00,
                  -.5701601645757751e+00,
                  -.5702354119651825e+00,
                  -.5702324946992135e+00,
                  -.5702080910448900e+00,
                  -.5702324946992136e+00,
                  -.5702354119651824e+00,
                  -.5701601645757749e+00,
                  -.5701756126084955e+00,
                  -.5704528839135221e+00,
                  -.5707772733596046e+00,
                  -.5707854674519678e+00,
                  -.5715982712981228e+00,
                  -.5732977565636644e+00,
                  -.5724420448902632e+00,
                  -.5561539929605910e+00,
                  -.5516187406229556e+00,
                  -.5457235284284438e+00,
                  -.5428318817340133e+00,
                  -.5424575136736188e+00,
                  -.5405612265354223e+00,
                  -.5396522014443996e+00,
                  -.5399345336172544e+00,
                  -.5401495682144565e+00,
                  -.5400068693131663e+00,
                  -.5400068693131668e+00,
                  -.5401495682144569e+00,
                  -.5399345336172533e+00,
                  -.5396522014443998e+00,
                  -.5405612265354280e+00,
                  -.5424575136736226e+00,
                  -.5428318817340073e+00,
                  -.5457235284284570e+00,
                  -.5516187406229538e+00,
                  -.5561539929605884e+00,
                  -.5227361820680647e+00,
                  -.5089671201550916e+00,
                  -.4991232440540148e+00,
                  -.4931354283326729e+00,
                  -.4912383339473700e+00,
                  -.4869424187006372e+00,
                  -.4860363569526482e+00,
                  -.4868782401995252e+00,
                  -.4868607757511374e+00,
                  -.4865797946183709e+00,
                  -.4868607757511385e+00,
                  -.4868782401995241e+00,
                  -.4860363569526465e+00,
                  -.4869424187006456e+00,
                  -.4912383339473802e+00,
                  -.4931354283326645e+00,
                  -.4991232440540293e+00,
                  -.5089671201550831e+00,
                  -.5227361820680681e+00,
                  -.4688605099115074e+00,
                  -.4481438416470861e+00,
                  -.4329187724571729e+00,
                  -.4228536560699343e+00,
                  -.4183127122049813e+00,
                  -.4116939608578110e+00,
                  -.4115698477643141e+00,
                  -.4124379109420533e+00,
                  -.4118823249283838e+00,
                  -.4118823249283849e+00,
                  -.4124379109420533e+00,
                  -.4115698477643104e+00,
                  -.4116939608578204e+00,
                  -.4183127122049968e+00,
                  -.4228536560699308e+00,
                  -.4329187724571942e+00,
                  -.4481438416470802e+00,
                  -.4688605099115164e+00,
                  -.3979244014899689e+00,
                  -.3712930696606194e+00,
                  -.3488109127414877e+00,
                  -.3344633284617958e+00,
                  -.3259498462901255e+00,
                  -.3180179905221919e+00,
                  -.3186536430875911e+00,
                  -.3185811827976662e+00,
                  -.3178245306767312e+00,
                  -.3185811827976669e+00,
                  -.3186536430875867e+00,
                  -.3180179905222000e+00,
                  -.3259498462901397e+00,
                  -.3344633284617967e+00,
                  -.3488109127415024e+00,
                  -.3712930696606099e+00,
                  -.3979244014899695e+00,
                  -.3108161793859889e+00,
                  -.2767761419765814e+00,
                  -.2478348054676549e+00,
                  -.2298116962132621e+00,
                  -.2174595802410685e+00,
                  -.2096196967806885e+00,
                  -.2096865420795784e+00,
                  -.2082986570353376e+00,
                  -.2082986570353375e+00,
                  -.2096865420795739e+00,
                  -.2096196967806955e+00,
                  -.2174595802410772e+00,
                  -.2298116962132691e+00,
                  -.2478348054676646e+00,
                  -.2767761419765742e+00,
                  -.3108161793859871e+00,
                  -.2093559782736226e+00,
                  -.1683369282129447e+00,
                  -.1354569710299785e+00,
                  -.1137081466933807e+00,
                  -.9822888574763560e-01,
                  -.9016437357888584e-01,
                  -.8760541136035830e-01,
                  -.8593152545455114e-01,
                  -.8760541136035314e-01,
                  -.9016437357889154e-01,
                  -.9822888574763482e-01,
                  -.1137081466933900e+00,
                  -.1354569710299861e+00,
                  -.1683369282129392e+00,
                  -.2093559782736233e+00,
                  -.9620155428408154e-01,
                  -.5022464941077820e-01,
                  -.1498018165525905e-01,
                  0.1061619564178425e-01,
                  0.2818098072016364e-01,
                  0.3791223243117067e-01,
                  0.4296576272727459e-01,
                  0.4296576272727975e-01,
                  0.3791223243116796e-01,
                  0.2818098072017573e-01,
                  0.1061619564178137e-01,
                  -.1498018165526200e-01,
                  -.5022464941077290e-01,
                  -.9620155428407889e-01,
                  0.2585581022425696e-01,
                  0.7475861793924218e-01,
                  0.1121324408956089e+00,
                  0.1401224068324700e+00,
                  0.1589122653383552e+00,
                  0.1703864246041710e+00,
                  0.1752108227207152e+00,
                  0.1703864246041683e+00,
                  0.1589122653383730e+00,
                  0.1401224068324741e+00,
                  0.1121324408956088e+00,
                  0.7475861793924232e-01,
                  0.2585581022426319e-01,
                  0.1539539481658210e+00,
                  0.2043300266002883e+00,
                  0.2432898973091837e+00,
                  0.2717599180959087e+00,
                  0.2904002020774888e+00,
                  0.2998509156584717e+00,
                  0.2998509156584616e+00,
                  0.2904002020775010e+00,
                  0.2717599180959137e+00,
                  0.2432898973091847e+00,
                  0.2043300266002816e+00,
                  0.1539539481658244e+00,
                  0.2851040455224450e+00,
                  0.3356768427128836e+00,
                  0.3747283348555278e+00,
                  0.4018217153002729e+00,
                  0.4168825288352260e+00,
                  0.4192393935613831e+00,
                  0.4168825288352208e+00,
                  0.4018217153002694e+00,
                  0.3747283348555289e+00,
                  0.3356768427128787e+00,
                  0.2851040455224459e+00,
                  0.4162785465333907e+00,
                  0.4653909502752138e+00,
                  0.5018584218547899e+00,
                  0.5252779944577059e+00,
                  0.5354775707632690e+00,
                  0.5354775707632673e+00,
                  0.5252779944576926e+00,
                  0.5018584218547851e+00,
                  0.4653909502752166e+00,
                  0.4162785465333937e+00,
                  0.5443796017409231e+00,
                  0.5901591830280281e+00,
                  0.6214933279826383e+00,
                  0.6415056570710809e+00,
                  0.6518996925802677e+00,
                  0.6415056570710845e+00,
                  0.6214933279826273e+00,
                  0.5901591830280319e+00,
                  0.5443796017409255e+00,
                  0.6663617188598591e+00,
                  0.7079891296573392e+00,
                  0.7347772241683050e+00,
                  0.7527760406667792e+00,
                  0.7527760406667957e+00,
                  0.7347772241683018e+00,
                  0.7079891296573421e+00,
                  0.6663617188598545e+00,
                  0.7795315908821221e+00,
                  0.8173373685119958e+00,
                  0.8400492466888745e+00,
                  0.8457073121398620e+00,
                  0.8400492466888686e+00,
                  0.8173373685120068e+00,
                  0.7795315908821160e+00,
                  0.8812690632995090e+00,
                  0.9137505833342268e+00,
                  0.9260542007898644e+00,
                  0.9260542007898340e+00,
                  0.9137505833342410e+00,
                  0.8812690632995115e+00,
                  0.9687016748495727e+00,
                  0.9909757233810908e+00,
                  0.9982464881080446e+00,
                  0.9909757233810931e+00,
                  0.9687016748495755e+00,
                  0.1039645977363485e+01,
                  0.1054690648583530e+01,
                  0.1054690648583550e+01,
                  0.1039645977363476e+01,
                  0.1094334453366188e+01,
                  0.1103237481245912e+01,
                  0.1094334453366186e+01,
                  0.1129451749524257e+01,
                  0.1129451749524257e+01,
                  0.1144884089780528e+01],
                 []],
      quad_degree: 33,
      weights: [0.4038074242045579e-03,
                  0.7702153068307685e-03,
                  0.1981669814506859e-02,
                  0.3202372052766005e-02,
                  0.4058173986635276e-02,
                  0.5087747133031257e-02,
                  0.6022218667400390e-02,
                  0.6609045283599506e-02,
                  0.6956974143949554e-02,
                  0.7214151642671334e-02,
                  0.7323832578680970e-02,
                  0.7214151642671284e-02,
                  0.6956974143949440e-02,
                  0.6609045283599518e-02,
                  0.6022218667400281e-02,
                  0.5087747133030619e-02,
                  0.4058173986634829e-02,
                  0.3202372052766310e-02,
                  0.1981669814505755e-02,
                  0.7702153068314371e-03,
                  0.4038074242045142e-03,
                  0.7702153068313664e-03,
                  0.3057113443011862e-02,
                  0.5630991961860100e-02,
                  0.8085787412742301e-02,
                  0.1028616320645236e-01,
                  0.1287520315340830e-01,
                  0.1465709050187036e-01,
                  0.1556608416800232e-01,
                  0.1623974204538972e-01,
                  0.1672692718714403e-01,
                  0.1672692718714431e-01,
                  0.1623974204539013e-01,
                  0.1556608416800267e-01,
                  0.1465709050187044e-01,
                  0.1287520315340714e-01,
                  0.1028616320645137e-01,
                  0.8085787412742877e-02,
                  0.5630991961858309e-02,
                  0.3057113443011897e-02,
                  0.7702153068308498e-03,
                  0.1981669814505650e-02,
                  0.5630991961858400e-02,
                  0.9534654511785980e-02,
                  0.1369994796354988e-01,
                  0.1745537809875104e-01,
                  0.2100399459023692e-01,
                  0.2290877323724500e-01,
                  0.2419183293233439e-01,
                  0.2537390823544299e-01,
                  0.2586326278013549e-01,
                  0.2537390823544212e-01,
                  0.2419183293233326e-01,
                  0.2290877323724479e-01,
                  0.2100399459023527e-01,
                  0.1745537809874851e-01,
                  0.1369994796355013e-01,
                  0.9534654511785908e-02,
                  0.5630991961860129e-02,
                  0.1981669814506773e-02,
                  0.3202372052766569e-02,
                  0.8085787412743129e-02,
                  0.1369994796355007e-01,
                  0.1920220699859326e-01,
                  0.2430742486685139e-01,
                  0.2857915647737479e-01,
                  0.3091976823578473e-01,
                  0.3274602421745745e-01,
                  0.3383753574696337e-01,
                  0.3383753574696216e-01,
                  0.3274602421745495e-01,
                  0.3091976823578442e-01,
                  0.2857915647737567e-01,
                  0.2430742486685251e-01,
                  0.1920220699859343e-01,
                  0.1369994796354979e-01,
                  0.8085787412742270e-02,
                  0.3202372052766090e-02,
                  0.4058173986634832e-02,
                  0.1028616320645119e-01,
                  0.1745537809874853e-01,
                  0.2430742486685273e-01,
                  0.3086443400800901e-01,
                  0.3534152622451153e-01,
                  0.3803306405288837e-01,
                  0.4022748523361081e-01,
                  0.4106605533804509e-01,
                  0.4022748523360792e-01,
                  0.3803306405288473e-01,
                  0.3534152622450910e-01,
                  0.3086443400800886e-01,
                  0.2430742486685184e-01,
                  0.1745537809875134e-01,
                  0.1028616320645233e-01,
                  0.4058173986635281e-02,
                  0.5087747133030545e-02,
                  0.1287520315340715e-01,
                  0.2100399459023553e-01,
                  0.2857915647737573e-01,
                  0.3534152622450886e-01,
                  0.3975288936073518e-01,
                  0.4384400301738123e-01,
                  0.4669645206838966e-01,
                  0.4669645206838936e-01,
                  0.4384400301738093e-01,
                  0.3975288936073536e-01,
                  0.3534152622451101e-01,
                  0.2857915647737474e-01,
                  0.2100399459023720e-01,
                  0.1287520315340846e-01,
                  0.5087747133031369e-02,
                  0.6022218667400172e-02,
                  0.1465709050187035e-01,
                  0.2290877323724450e-01,
                  0.3091976823578387e-01,
                  0.3803306405288433e-01,
                  0.4384400301738064e-01,
                  0.4919209090625008e-01,
                  0.5113735821968909e-01,
                  0.4919209090625013e-01,
                  0.4384400301738154e-01,
                  0.3803306405288818e-01,
                  0.3091976823578434e-01,
                  0.2290877323724476e-01,
                  0.1465709050187032e-01,
                  0.6022218667400506e-02,
                  0.6609045283599354e-02,
                  0.1556608416800246e-01,
                  0.2419183293233287e-01,
                  0.3274602421745473e-01,
                  0.4022748523360788e-01,
                  0.4669645206838913e-01,
                  0.5113735821968895e-01,
                  0.5113735821968897e-01,
                  0.4669645206838955e-01,
                  0.4022748523361072e-01,
                  0.3274602421745710e-01,
                  0.2419183293233380e-01,
                  0.1556608416800194e-01,
                  0.6609045283599449e-02,
                  0.6956974143949367e-02,
                  0.1623974204539017e-01,
                  0.2537390823544211e-01,
                  0.3383753574696220e-01,
                  0.4106605533804512e-01,
                  0.4669645206838935e-01,
                  0.4919209090624984e-01,
                  0.4669645206838900e-01,
                  0.4106605533804497e-01,
                  0.3383753574696317e-01,
                  0.2537390823544262e-01,
                  0.1623974204538941e-01,
                  0.6956974143949386e-02,
                  0.7214151642671377e-02,
                  0.1672692718714456e-01,
                  0.2586326278013570e-01,
                  0.3383753574696340e-01,
                  0.4022748523361084e-01,
                  0.4384400301738083e-01,
                  0.4384400301738022e-01,
                  0.4022748523360785e-01,
                  0.3383753574696221e-01,
                  0.2586326278013565e-01,
                  0.1672692718714420e-01,
                  0.7214151642671281e-02,
                  0.7323832578681105e-02,
                  0.1672692718714416e-01,
                  0.2537390823544311e-01,
                  0.3274602421745727e-01,
                  0.3803306405288828e-01,
                  0.3975288936073509e-01,
                  0.3803306405288471e-01,
                  0.3274602421745510e-01,
                  0.2537390823544253e-01,
                  0.1672692718714475e-01,
                  0.7323832578681082e-02,
                  0.7214151642671367e-02,
                  0.1623974204538954e-01,
                  0.2419183293233427e-01,
                  0.3091976823578435e-01,
                  0.3534152622451169e-01,
                  0.3534152622450962e-01,
                  0.3091976823578446e-01,
                  0.2419183293233339e-01,
                  0.1623974204539023e-01,
                  0.7214151642671357e-02,
                  0.6956974143949503e-02,
                  0.1556608416800204e-01,
                  0.2290877323724489e-01,
                  0.2857915647737482e-01,
                  0.3086443400800938e-01,
                  0.2857915647737582e-01,
                  0.2290877323724462e-01,
                  0.1556608416800229e-01,
                  0.6956974143949314e-02,
                  0.6609045283599480e-02,
                  0.1465709050187027e-01,
                  0.2100399459023697e-01,
                  0.2430742486685137e-01,
                  0.2430742486685221e-01,
                  0.2100399459023515e-01,
                  0.1465709050187019e-01,
                  0.6609045283599350e-02,
                  0.6022218667400389e-02,
                  0.1287520315340826e-01,
                  0.1745537809875079e-01,
                  0.1920220699859300e-01,
                  0.1745537809874826e-01,
                  0.1287520315340717e-01,
                  0.6022218667400250e-02,
                  0.5087747133031184e-02,
                  0.1028616320645221e-01,
                  0.1369994796354976e-01,
                  0.1369994796355045e-01,
                  0.1028616320645155e-01,
                  0.5087747133030655e-02,
                  0.4058173986635252e-02,
                  0.8085787412742651e-02,
                  0.9534654511786123e-02,
                  0.8085787412743408e-02,
                  0.4058173986634886e-02,
                  0.3202372052766146e-02,
                  0.5630991961860152e-02,
                  0.5630991961858260e-02,
                  0.3202372052766471e-02,
                  0.1981669814506699e-02,
                  0.3057113443011740e-02,
                  0.1981669814505677e-02,
                  0.7702153068307515e-03,
                  0.7702153068313153e-03,
                  0.4038074242045246e-03]}})
