from __future__ import absolute_import
# GENERATED by modepy/contrib/weights-from-fortran.py
# DO NOT EDIT

import numpy as np
import six

points = "points"
weights = "weights"
quad_degree = "quad_degree"

def process_rule(table):
    result = {}
    for order, kv in six.iteritems(table):
        result[order] = order_tbl = {}
        for k, v in six.iteritems(kv):
            if isinstance(v, list):
                v = [i for i in v if not isinstance(i, list) or len(i)]
                v = np.array(v)

            order_tbl[k] = v

    return result

tetrahedron_data = process_rule({0: {points: [[0.00000000000000000000000000000000e+00],
                [0.00000000000000000000000000000000e+00],
                [0.00000000000000000000000000000000e+00]],
     quad_degree: 1,
     weights: [0.10000000000000000000000000000000e+01]},
 1: {points: [[-.4472135954999580e+00,
                 0.4472135954999579e+00,
                 -.3135285529035438e-16,
                 -.4478472582704850e-16],
                [-.2581988897471612e+00,
                 -.2581988897471611e+00,
                 0.5163977794943223e+00,
                 -.3040216472165524e-16],
                [-.1825741858350555e+00,
                 -.1825741858350554e+00,
                 -.1825741858350554e+00,
                 0.5477225575051660e+00]],
     quad_degree: 2,
     weights: [0.2427458858536616e+00,
                 0.2427458858536618e+00,
                 0.2427458858536617e+00,
                 0.2427458858536618e+00]},
 2: {points: [[-.6914363211612446e+00,
                 -.4462167352897876e-16,
                 0.6914363211612446e+00,
                 -.3119490417484892e+00,
                 0.3119490417484893e+00,
                 -.2335778428885781e-16,
                 -.3119490417484893e+00,
                 0.3119490417484892e+00,
                 0.8153254986008266e-17,
                 0.7647510516307385e-17],
                [-.3992009461499291e+00,
                 -.3602077264538721e+00,
                 -.3992009461499292e+00,
                 0.1801038632269361e+00,
                 0.1801038632269360e+00,
                 0.7984018922998582e+00,
                 -.1801038632269361e+00,
                 -.1801038632269361e+00,
                 0.3602077264538721e+00,
                 -.1216767918021078e-16],
                [-.2822776960787007e+00,
                 -.2547053260113219e+00,
                 -.2822776960787007e+00,
                 -.2547053260113220e+00,
                 -.2547053260113219e+00,
                 -.2822776960787007e+00,
                 0.2547053260113218e+00,
                 0.2547053260113218e+00,
                 0.2547053260113218e+00,
                 0.8468330882361020e+00]],
     quad_degree: 3,
     weights: [0.4895578863887126e-01,
                 0.1291933981431936e+00,
                 0.4895578863887128e-01,
                 0.1291933981431936e+00,
                 0.1291933981431936e+00,
                 0.4895578863887127e-01,
                 0.1291933981431937e+00,
                 0.1291933981431937e+00,
                 0.1291933981431937e+00,
                 0.4895578863887128e-01]},
 3: {points: [[-.7202288316869291e+00,
                 -.2909822974951497e+00,
                 0.2909822974951496e+00,
                 0.7202288316869292e+00,
                 -.5222022936850983e+00,
                 -.6535207742649487e-16,
                 0.5222022936850981e+00,
                 -.2312199961899486e+00,
                 0.2312199961899486e+00,
                 -.2767776134172990e-16,
                 -.5222022936850983e+00,
                 -.6454761695883611e-16,
                 0.5222022936850983e+00,
                 -.2389770206927570e+00,
                 0.2389770206927570e+00,
                 0.2012273386072096e-16,
                 -.2312199961899486e+00,
                 0.2312199961899485e+00,
                 -.2415554336713898e-16,
                 -.2409281425196882e-17],
                [-.4158243098525782e+00,
                 -.4349885618728225e+00,
                 -.4349885618728225e+00,
                 -.4158243098525782e+00,
                 -.3450378074594940e-01,
                 -.4955383938691938e-17,
                 -.3450378074594934e-01,
                 0.4694923426187719e+00,
                 0.4694923426187719e+00,
                 0.8316486197051564e+00,
                 -.3014936348305315e+00,
                 -.2759468944541961e+00,
                 -.3014936348305315e+00,
                 0.1379734472270981e+00,
                 0.1379734472270980e+00,
                 0.6029872696610630e+00,
                 -.1334949270422910e+00,
                 -.1334949270422910e+00,
                 0.2669898540845821e+00,
                 -.3363683815577664e-16],
                [-.2940321892789741e+00,
                 -.3075833618388569e+00,
                 -.3075833618388569e+00,
                 -.2940321892789742e+00,
                 -.3075833618388569e+00,
                 -.2926858804738958e+00,
                 -.3075833618388569e+00,
                 -.3075833618388570e+00,
                 -.3075833618388569e+00,
                 -.2940321892789742e+00,
                 0.6999731082357272e-01,
                 0.9756196015796521e-01,
                 0.6999731082357270e-01,
                 0.9756196015796513e-01,
                 0.9756196015796526e-01,
                 0.6999731082357274e-01,
                 0.5451694128541409e+00,
                 0.5451694128541410e+00,
                 0.5451694128541410e+00,
                 0.8820965678369226e+00]],
     quad_degree: 5,
     weights: [0.2656134314809884e-01,
                 0.3964370704405561e-01,
                 0.3964370704405563e-01,
                 0.2656134314809884e-01,
                 0.3964370704405561e-01,
                 0.9725342157339597e-01,
                 0.3964370704405565e-01,
                 0.3964370704405562e-01,
                 0.3964370704405562e-01,
                 0.2656134314809884e-01,
                 0.3964370704405562e-01,
                 0.9725342157339598e-01,
                 0.3964370704405564e-01,
                 0.9725342157339597e-01,
                 0.9725342157339598e-01,
                 0.3964370704405563e-01,
                 0.3964370704405565e-01,
                 0.3964370704405565e-01,
                 0.3964370704405565e-01,
                 0.2656134314809883e-01]},
 4: {points: [[-.8207249496392203e+00,
                 -.4905447520939444e+00,
                 -.3399986587548112e-16,
                 0.4905447520939444e+00,
                 0.8207249496392203e+00,
                 -.6566414083058262e+00,
                 -.2673296868944482e+00,
                 0.2673296868944482e+00,
                 0.6566414083058260e+00,
                 -.4070188183960818e+00,
                 0.2627856205102448e-16,
                 0.4070188183960819e+00,
                 -.1660966562118815e+00,
                 0.1660966562118814e+00,
                 0.6579949599920338e-16,
                 -.6566414083058259e+00,
                 -.2673296868944483e+00,
                 0.2673296868944482e+00,
                 0.6566414083058259e+00,
                 -.4434924050942820e+00,
                 0.8047312676894457e-16,
                 0.4434924050942820e+00,
                 -.1761627181998338e+00,
                 0.1761627181998339e+00,
                 0.3630550313766013e-16,
                 -.4070188183960819e+00,
                 0.5127163212679586e-16,
                 0.4070188183960819e+00,
                 -.1761627181998337e+00,
                 0.1761627181998338e+00,
                 -.8086285151871179e-16,
                 -.1660966562118814e+00,
                 0.1660966562118814e+00,
                 0.4826285338328022e-16,
                 -.3653226209218861e-18],
                [-.4738457706048460e+00,
                 -.4750080430218499e+00,
                 -.4699848487324428e+00,
                 -.4750080430218500e+00,
                 -.4738457706048459e+00,
                 -.1873201954955707e+00,
                 -.1543428666908882e+00,
                 -.1543428666908882e+00,
                 -.1873201954955706e+00,
                 0.2349924243662212e+00,
                 0.3086857333817762e+00,
                 0.2349924243662213e+00,
                 0.6623282385174208e+00,
                 0.6623282385174206e+00,
                 0.9476915412096917e+00,
                 -.3791120938464237e+00,
                 -.3577580522385884e+00,
                 -.3577580522385885e+00,
                 -.3791120938464237e+00,
                 -.5263527391703772e-01,
                 -.4716262792201506e-17,
                 -.5263527391703785e-01,
                 0.4103933261556264e+00,
                 0.4103933261556264e+00,
                 0.7582241876928472e+00,
                 -.2349924243662212e+00,
                 -.2034151855477005e+00,
                 -.2349924243662212e+00,
                 0.1017075927738502e+00,
                 0.1017075927738503e+00,
                 0.4699848487324426e+00,
                 -.9589594917542634e-01,
                 -.9589594917542646e-01,
                 0.1917918983508531e+00,
                 -.2677889515870966e-16],
                [-.3350595576312518e+00,
                 -.3358814083389016e+00,
                 -.3323294735936438e+00,
                 -.3358814083389015e+00,
                 -.3350595576312518e+00,
                 -.3358814083389014e+00,
                 -.3248912733105464e+00,
                 -.3248912733105465e+00,
                 -.3358814083389013e+00,
                 -.3323294735936440e+00,
                 -.3248912733105463e+00,
                 -.3323294735936440e+00,
                 -.3358814083389014e+00,
                 -.3358814083389016e+00,
                 -.3350595576312518e+00,
                 -.6464670453784325e-01,
                 -.3721875911634887e-01,
                 -.3721875911634891e-01,
                 -.6464670453784323e-01,
                 -.3721875911634884e-01,
                 0.5360051246284252e-17,
                 -.3721875911634894e-01,
                 -.3721875911634893e-01,
                 -.3721875911634893e-01,
                 -.6464670453784327e-01,
                 0.3323294735936440e+00,
                 0.3993287915432442e+00,
                 0.3323294735936439e+00,
                 0.3993287915432441e+00,
                 0.3993287915432442e+00,
                 0.3323294735936438e+00,
                 0.7364095212156461e+00,
                 0.7364095212156462e+00,
                 0.7364095212156461e+00,
                 0.1005178672893755e+01]],
     quad_degree: 6,
     weights: [0.8124348940692212e-02,
                 0.1565619348949876e-01,
                 0.2135765185301480e-01,
                 0.1565619348949876e-01,
                 0.8124348940692213e-02,
                 0.1565619348949876e-01,
                 0.4448246502187802e-01,
                 0.4448246502187801e-01,
                 0.1565619348949876e-01,
                 0.2135765185301483e-01,
                 0.4448246502187803e-01,
                 0.2135765185301482e-01,
                 0.1565619348949875e-01,
                 0.1565619348949875e-01,
                 0.8124348940692217e-02,
                 0.1565619348949876e-01,
                 0.4448246502187803e-01,
                 0.4448246502187801e-01,
                 0.1565619348949877e-01,
                 0.4448246502187802e-01,
                 0.8867633439726776e-01,
                 0.4448246502187802e-01,
                 0.4448246502187800e-01,
                 0.4448246502187800e-01,
                 0.1565619348949876e-01,
                 0.2135765185301483e-01,
                 0.4448246502187801e-01,
                 0.2135765185301484e-01,
                 0.4448246502187803e-01,
                 0.4448246502187801e-01,
                 0.2135765185301483e-01,
                 0.1565619348949876e-01,
                 0.1565619348949875e-01,
                 0.1565619348949874e-01,
                 0.8124348940692225e-02]},
 5: {points: [[-.8112888656268565e+00,
                 -.6040187271730633e+00,
                 -.2375979740927052e+00,
                 0.2375979740927050e+00,
                 0.6040187271730631e+00,
                 0.8112888656268566e+00,
                 -.7339446155024966e+00,
                 -.4059924902854578e+00,
                 -.4107892033117742e-16,
                 0.4059924902854579e+00,
                 0.7339446155024965e+00,
                 -.5382782139997801e+00,
                 -.1959131554581469e+00,
                 0.1959131554581469e+00,
                 0.5382782139997802e+00,
                 -.3006802399070749e+00,
                 -.2797061749636946e-16,
                 0.3006802399070748e+00,
                 -.1299258883294334e+00,
                 0.1299258883294332e+00,
                 -.1037315364893751e-15,
                 -.7339446155024969e+00,
                 -.4059924902854579e+00,
                 0.5547107947262673e-16,
                 0.4059924902854578e+00,
                 0.7339446155024968e+00,
                 -.5508378307266485e+00,
                 -.2185033807802497e+00,
                 0.2185033807802502e+00,
                 0.5508378307266484e+00,
                 -.3448246942440874e+00,
                 0.5080272902516048e-16,
                 0.3448246942440874e+00,
                 -.1448453404411909e+00,
                 0.1448453404411910e+00,
                 0.7277540011530281e-16,
                 -.5382782139997802e+00,
                 -.1959131554581470e+00,
                 0.1959131554581470e+00,
                 0.5382782139997803e+00,
                 -.3448246942440875e+00,
                 -.4572916149446541e-16,
                 0.3448246942440877e+00,
                 -.1489115387859404e+00,
                 0.1489115387859403e+00,
                 -.4801501737810156e-16,
                 -.3006802399070749e+00,
                 0.8271574858017233e-16,
                 0.3006802399070747e+00,
                 -.1448453404411909e+00,
                 0.1448453404411908e+00,
                 -.3778485737955602e-16,
                 -.1299258883294330e+00,
                 0.1299258883294337e+00,
                 0.3835389774484257e-15,
                 -.3730374604539777e-15],
                [-.4683978449602116e+00,
                 -.4987558679323429e+00,
                 -.4843728892020348e+00,
                 -.4843728892020349e+00,
                 -.4987558679323427e+00,
                 -.4683978449602119e+00,
                 -.2737176281272435e+00,
                 -.2343998735552757e+00,
                 -.2262210260831001e+00,
                 -.2343998735552757e+00,
                 -.2737176281272436e+00,
                 0.3642056314901796e-01,
                 0.1131105130415502e+00,
                 0.1131105130415502e+00,
                 0.3642056314901793e-01,
                 0.4479523260530169e+00,
                 0.4687997471105512e+00,
                 0.4479523260530170e+00,
                 0.7724734960595860e+00,
                 0.7724734960595862e+00,
                 0.9367956899204237e+00,
                 -.4237431213306430e+00,
                 -.4016528661444447e+00,
                 -.3981692600901086e+00,
                 -.4016528661444448e+00,
                 -.4237431213306427e+00,
                 -.1507733772606912e+00,
                 -.1261529857123204e+00,
                 -.1261529857123207e+00,
                 -.1507733772606911e+00,
                 0.1990846300450544e+00,
                 0.2523059714246410e+00,
                 0.1990846300450542e+00,
                 0.5524262434051359e+00,
                 0.5524262434051358e+00,
                 0.8474862426612859e+00,
                 -.3107750717516839e+00,
                 -.2850587470485584e+00,
                 -.2850587470485583e+00,
                 -.3107750717516841e+00,
                 -.2713639603804592e-01,
                 0.4020116993696106e-16,
                 -.2713639603804596e-01,
                 0.3121951430866044e+00,
                 0.3121951430866046e+00,
                 0.6215501435033679e+00,
                 -.1735978174503510e+00,
                 -.1672529925891691e+00,
                 -.1735978174503511e+00,
                 0.8362649629458479e-01,
                 0.8362649629458452e-01,
                 0.3471956349007021e+00,
                 -.7501274660169966e-01,
                 -.7501274660169949e-01,
                 0.1500254932033993e+00,
                 -.4727015379385593e-16],
                [-.3312072924645310e+00,
                 -.3526736563715415e+00,
                 -.3425033545776792e+00,
                 -.3425033545776793e+00,
                 -.3526736563715412e+00,
                 -.3312072924645311e+00,
                 -.3526736563715414e+00,
                 -.3431443279505221e+00,
                 -.3423410650094490e+00,
                 -.3431443279505223e+00,
                 -.3526736563715412e+00,
                 -.3425033545776791e+00,
                 -.3423410650094493e+00,
                 -.3423410650094495e+00,
                 -.3425033545776790e+00,
                 -.3425033545776793e+00,
                 -.3431443279505218e+00,
                 -.3425033545776793e+00,
                 -.3526736563715415e+00,
                 -.3526736563715414e+00,
                 -.3312072924645309e+00,
                 -.1405055691815817e+00,
                 -.1066128774834322e+00,
                 -.9916954045063580e-01,
                 -.1066128774834321e+00,
                 -.1405055691815818e+00,
                 -.1066128774834323e+00,
                 -.8920363166411133e-01,
                 -.8920363166411159e-01,
                 -.1066128774834321e+00,
                 -.9916954045063560e-01,
                 -.8920363166411138e-01,
                 -.9916954045063576e-01,
                 -.1066128774834323e+00,
                 -.1066128774834322e+00,
                 -.1405055691815815e+00,
                 0.1485054210956309e+00,
                 0.2207553027300425e+00,
                 0.2207553027300425e+00,
                 0.1485054210956309e+00,
                 0.2207553027300425e+00,
                 0.2676108949923344e+00,
                 0.2207553027300426e+00,
                 0.2207553027300426e+00,
                 0.2207553027300425e+00,
                 0.1485054210956309e+00,
                 0.5365012880597274e+00,
                 0.5563700829173862e+00,
                 0.5365012880597272e+00,
                 0.5563700829173865e+00,
                 0.5563700829173862e+00,
                 0.5365012880597272e+00,
                 0.8458528819246641e+00,
                 0.8458528819246650e+00,
                 0.8458528819246647e+00,
                 0.9936218773935927e+00]],
     quad_degree: 7,
     weights: [0.7173906931899787e-02,
                 0.6112286527395072e-02,
                 0.1328208854503779e-01,
                 0.1328208854503778e-01,
                 0.6112286527395097e-02,
                 0.7173906931899768e-02,
                 0.6112286527395103e-02,
                 0.2100612898927194e-01,
                 0.2230942960262554e-01,
                 0.2100612898927190e-01,
                 0.6112286527395125e-02,
                 0.1328208854503779e-01,
                 0.2230942960262554e-01,
                 0.2230942960262552e-01,
                 0.1328208854503778e-01,
                 0.1328208854503778e-01,
                 0.2100612898927191e-01,
                 0.1328208854503779e-01,
                 0.6112286527395109e-02,
                 0.6112286527395121e-02,
                 0.7173906931899760e-02,
                 0.6112286527395092e-02,
                 0.2100612898927193e-01,
                 0.2230942960262552e-01,
                 0.2100612898927191e-01,
                 0.6112286527395107e-02,
                 0.2100612898927194e-01,
                 0.4744217792877091e-01,
                 0.4744217792877094e-01,
                 0.2100612898927190e-01,
                 0.2230942960262554e-01,
                 0.4744217792877094e-01,
                 0.2230942960262556e-01,
                 0.2100612898927194e-01,
                 0.2100612898927190e-01,
                 0.6112286527395089e-02,
                 0.1328208854503778e-01,
                 0.2230942960262555e-01,
                 0.2230942960262554e-01,
                 0.1328208854503777e-01,
                 0.2230942960262551e-01,
                 0.4744217792877095e-01,
                 0.2230942960262550e-01,
                 0.2230942960262549e-01,
                 0.2230942960262552e-01,
                 0.1328208854503779e-01,
                 0.1328208854503780e-01,
                 0.2100612898927189e-01,
                 0.1328208854503780e-01,
                 0.2100612898927192e-01,
                 0.2100612898927196e-01,
                 0.1328208854503777e-01,
                 0.6112286527395128e-02,
                 0.6112286527395103e-02,
                 0.6112286527395104e-02,
                 0.7173906931899764e-02]},
 6: {points: [[-.8577347407634100e+00,
                 -.6687889784522106e+00,
                 -.4147999187574764e+00,
                 0.2411824538873946e-16,
                 0.4147999187574755e+00,
                 0.6687889784522112e+00,
                 0.8577347407634106e+00,
                 -.7794670358070163e+00,
                 -.5304094535941188e+00,
                 -.1878041968448056e+00,
                 0.1878041968448058e+00,
                 0.5304094535941186e+00,
                 0.7794670358070160e+00,
                 -.6482331735005599e+00,
                 -.3641463291785968e+00,
                 -.2099607077139752e-15,
                 0.3641463291785971e+00,
                 0.6482331735005595e+00,
                 -.4442206975038639e+00,
                 -.1763421323337914e+00,
                 0.1763421323337913e+00,
                 0.4442206975038638e+00,
                 -.2334332547430846e+00,
                 -.2282702787589616e-15,
                 0.2334332547430846e+00,
                 -.1106780573548052e+00,
                 0.1106780573548048e+00,
                 0.1912028231363894e-15,
                 -.7794670358070166e+00,
                 -.5304094535941186e+00,
                 -.1878041968448058e+00,
                 0.1878041968448056e+00,
                 0.5304094535941185e+00,
                 0.7794670358070163e+00,
                 -.6464544926272156e+00,
                 -.3951968471311533e+00,
                 -.2212683765669018e-15,
                 0.3951968471311528e+00,
                 0.6464544926272154e+00,
                 -.4764751914618191e+00,
                 -.1875953479682656e+00,
                 0.1875953479682653e+00,
                 0.4764751914618190e+00,
                 -.2886709946170134e+00,
                 -.2615013674270393e-15,
                 0.2886709946170132e+00,
                 -.1160450390330967e+00,
                 0.1160450390330966e+00,
                 -.1504084845134502e-15,
                 -.6482331735005597e+00,
                 -.3641463291785971e+00,
                 -.1534257007630181e-15,
                 0.3641463291785971e+00,
                 0.6482331735005595e+00,
                 -.4764751914618191e+00,
                 -.1875953479682653e+00,
                 0.1875953479682655e+00,
                 0.4764751914618188e+00,
                 -.2904471454713604e+00,
                 0.1256818178631322e-15,
                 0.2904471454713603e+00,
                 -.1123288622832221e+00,
                 0.1123288622832221e+00,
                 0.5140956318691328e-16,
                 -.4442206975038639e+00,
                 -.1763421323337913e+00,
                 0.1763421323337914e+00,
                 0.4442206975038638e+00,
                 -.2886709946170131e+00,
                 0.6361741393786283e-16,
                 0.2886709946170134e+00,
                 -.1123288622832221e+00,
                 0.1123288622832221e+00,
                 -.5720436603004886e-16,
                 -.2334332547430844e+00,
                 -.1714850890316642e-15,
                 0.2334332547430844e+00,
                 -.1160450390330968e+00,
                 0.1160450390330967e+00,
                 0.1290530611686366e-15,
                 -.1106780573548051e+00,
                 0.1106780573548051e+00,
                 -.1393761739716997e-15,
                 0.7751372149975728e-16],
                [-.4952133834730488e+00,
                 -.5139255091548017e+00,
                 -.5090303496819244e+00,
                 -.5129418785669179e+00,
                 -.5090303496819243e+00,
                 -.5139255091548016e+00,
                 -.4952133834730491e+00,
                 -.3222254905332569e+00,
                 -.3062320408132870e+00,
                 -.3120511587480640e+00,
                 -.3120511587480637e+00,
                 -.3062320408132870e+00,
                 -.3222254905332572e+00,
                 -.1047120922907333e+00,
                 -.6617626030902970e-02,
                 -.2244690942039970e-16,
                 -.6617626030903382e-02,
                 -.1047120922907325e+00,
                 0.2564709392834592e+00,
                 0.3186687847789669e+00,
                 0.3186687847789670e+00,
                 0.2564709392834591e+00,
                 0.6137424419726566e+00,
                 0.6124640816265739e+00,
                 0.6137424419726571e+00,
                 0.8361509996880599e+00,
                 0.8361509996880592e+00,
                 0.9904267669460978e+00,
                 -.4500255029476206e+00,
                 -.4402293098610450e+00,
                 -.4417573565020294e+00,
                 -.4417573565020291e+00,
                 -.4402293098610449e+00,
                 -.4500255029476206e+00,
                 -.2392334062894082e+00,
                 -.2281670060740631e+00,
                 -.2166164492963989e+00,
                 -.2281670060740627e+00,
                 -.2392334062894081e+00,
                 0.5823547284607937e-01,
                 0.1083082246481993e+00,
                 0.1083082246481995e+00,
                 0.5823547284607950e-01,
                 0.3835218836559498e+00,
                 0.4563340121481251e+00,
                 0.3835218836559496e+00,
                 0.6794627161504527e+00,
                 0.6794627161504526e+00,
                 0.9000510058952405e+00,
                 -.3742575972181937e+00,
                 -.3399461789296423e+00,
                 -.3353794752464966e+00,
                 -.3399461789296425e+00,
                 -.3742575972181934e+00,
                 -.1453868822986943e+00,
                 -.1083082246481995e+00,
                 -.1083082246481995e+00,
                 -.1453868822986941e+00,
                 0.1676897376232483e+00,
                 0.2166164492963991e+00,
                 0.1676897376232484e+00,
                 0.4853330612283366e+00,
                 0.4853330612283365e+00,
                 0.7485151944363875e+00,
                 -.2564709392834590e+00,
                 -.2315173753263522e+00,
                 -.2315173753263521e+00,
                 -.2564709392834590e+00,
                 -.3695807869540433e-01,
                 0.1941684044626462e-15,
                 -.3695807869540439e-01,
                 0.2684754540217565e+00,
                 0.2684754540217565e+00,
                 0.5129418785669179e+00,
                 -.1347727524637303e+00,
                 -.1339972690477580e+00,
                 -.1347727524637304e+00,
                 0.6699863452387905e-01,
                 0.6699863452387905e-01,
                 0.2695455049274606e+00,
                 -.6390000620718141e-01,
                 -.6390000620718130e-01,
                 0.1278000124143629e+00,
                 -.2312394128326298e-15],
                [-.3501687415881273e+00,
                 -.3634002125481091e+00,
                 -.3599388120898484e+00,
                 -.3627046806892343e+00,
                 -.3599388120898482e+00,
                 -.3634002125481093e+00,
                 -.3501687415881273e+00,
                 -.3634002125481094e+00,
                 -.3586643190818928e+00,
                 -.3582276884185041e+00,
                 -.3582276884185043e+00,
                 -.3586643190818927e+00,
                 -.3634002125481093e+00,
                 -.3599388120898481e+00,
                 -.3582276884185041e+00,
                 -.3557236518263754e+00,
                 -.3582276884185042e+00,
                 -.3599388120898480e+00,
                 -.3627046806892345e+00,
                 -.3582276884185042e+00,
                 -.3582276884185043e+00,
                 -.3627046806892344e+00,
                 -.3599388120898479e+00,
                 -.3586643190818927e+00,
                 -.3599388120898480e+00,
                 -.3634002125481097e+00,
                 -.3634002125481097e+00,
                 -.3501687415881268e+00,
                 -.1826637017202674e+00,
                 -.1691635638735968e+00,
                 -.1747954244309999e+00,
                 -.1747954244309997e+00,
                 -.1691635638735968e+00,
                 -.1826637017202676e+00,
                 -.1691635638735967e+00,
                 -.1613384372380019e+00,
                 -.1531709602140357e+00,
                 -.1613384372380021e+00,
                 -.1691635638735965e+00,
                 -.1747954244309999e+00,
                 -.1531709602140356e+00,
                 -.1531709602140358e+00,
                 -.1747954244309996e+00,
                 -.1747954244309998e+00,
                 -.1613384372380023e+00,
                 -.1747954244309997e+00,
                 -.1691635638735967e+00,
                 -.1691635638735967e+00,
                 -.1826637017202672e+00,
                 0.2125609665527079e-01,
                 0.1131700718170905e+00,
                 0.1185745506087918e+00,
                 0.1131700718170902e+00,
                 0.2125609665527132e-01,
                 0.1131700718170904e+00,
                 0.1531709602140356e+00,
                 0.1531709602140355e+00,
                 0.1131700718170902e+00,
                 0.1185745506087919e+00,
                 0.1531709602140355e+00,
                 0.1185745506087919e+00,
                 0.1131700718170902e+00,
                 0.1131700718170905e+00,
                 0.2125609665527088e-01,
                 0.3627046806892345e+00,
                 0.4198530410324135e+00,
                 0.4198530410324136e+00,
                 0.3627046806892344e+00,
                 0.4198530410324136e+00,
                 0.4840153117140054e+00,
                 0.4198530410324136e+00,
                 0.4198530410324137e+00,
                 0.4198530410324135e+00,
                 0.3627046806892346e+00,
                 0.6986215275244256e+00,
                 0.6969914468290862e+00,
                 0.6986215275244258e+00,
                 0.6969914468290860e+00,
                 0.6969914468290858e+00,
                 0.6986215275244253e+00,
                 0.9094641268164864e+00,
                 0.9094641268164860e+00,
                 0.9094641268164868e+00,
                 0.1050506224764381e+01]],
     quad_degree: 9,
     weights: [0.3497289424352544e-02,
                 0.3030044202810465e-02,
                 0.5260172022042248e-02,
                 0.6541223534852979e-02,
                 0.5260172022042267e-02,
                 0.3030044202810488e-02,
                 0.3497289424352505e-02,
                 0.3030044202810455e-02,
                 0.1027880726166938e-01,
                 0.1246347743139886e-01,
                 0.1246347743139883e-01,
                 0.1027880726166936e-01,
                 0.3030044202810500e-02,
                 0.5260172022042288e-02,
                 0.1246347743139885e-01,
                 0.1783957004657833e-01,
                 0.1246347743139884e-01,
                 0.5260172022042288e-02,
                 0.6541223534852940e-02,
                 0.1246347743139883e-01,
                 0.1246347743139887e-01,
                 0.6541223534852944e-02,
                 0.5260172022042286e-02,
                 0.1027880726166936e-01,
                 0.5260172022042281e-02,
                 0.3030044202810471e-02,
                 0.3030044202810476e-02,
                 0.3497289424352523e-02,
                 0.3030044202810465e-02,
                 0.1027880726166936e-01,
                 0.1246347743139884e-01,
                 0.1246347743139885e-01,
                 0.1027880726166937e-01,
                 0.3030044202810489e-02,
                 0.1027880726166938e-01,
                 0.2405889217649253e-01,
                 0.3333782559856899e-01,
                 0.2405889217649255e-01,
                 0.1027880726166940e-01,
                 0.1246347743139887e-01,
                 0.3333782559856901e-01,
                 0.3333782559856901e-01,
                 0.1246347743139886e-01,
                 0.1246347743139883e-01,
                 0.2405889217649256e-01,
                 0.1246347743139886e-01,
                 0.1027880726166937e-01,
                 0.1027880726166940e-01,
                 0.3030044202810473e-02,
                 0.5260172022042285e-02,
                 0.1246347743139883e-01,
                 0.1783957004657836e-01,
                 0.1246347743139883e-01,
                 0.5260172022042285e-02,
                 0.1246347743139885e-01,
                 0.3333782559856903e-01,
                 0.3333782559856903e-01,
                 0.1246347743139884e-01,
                 0.1783957004657834e-01,
                 0.3333782559856903e-01,
                 0.1783957004657832e-01,
                 0.1246347743139887e-01,
                 0.1246347743139885e-01,
                 0.5260172022042277e-02,
                 0.6541223534852947e-02,
                 0.1246347743139887e-01,
                 0.1246347743139889e-01,
                 0.6541223534852952e-02,
                 0.1246347743139885e-01,
                 0.2405889217649258e-01,
                 0.1246347743139884e-01,
                 0.1246347743139884e-01,
                 0.1246347743139882e-01,
                 0.6541223534852965e-02,
                 0.5260172022042267e-02,
                 0.1027880726166938e-01,
                 0.5260172022042259e-02,
                 0.1027880726166936e-01,
                 0.1027880726166938e-01,
                 0.5260172022042277e-02,
                 0.3030044202810473e-02,
                 0.3030044202810482e-02,
                 0.3030044202810483e-02,
                 0.3497289424352521e-02]},
 7: {points: [[-.9223551004279220e+00,
                 -.7223366783841648e+00,
                 -.5128523868358545e+00,
                 -.2157318049213586e+00,
                 0.2157318049213577e+00,
                 0.5128523868358534e+00,
                 0.7223366783841663e+00,
                 0.9223551004279245e+00,
                 -.8082038093669254e+00,
                 -.6163163542315515e+00,
                 -.3152788022829639e+00,
                 -.4296091137207246e-15,
                 0.3152788022829633e+00,
                 0.6163163542315515e+00,
                 0.8082038093669250e+00,
                 -.7023591766066746e+00,
                 -.4542246160156309e+00,
                 -.1503585815913811e+00,
                 0.1503585815913807e+00,
                 0.4542246160156315e+00,
                 0.7023591766066749e+00,
                 -.5631992424023121e+00,
                 -.3167956935940198e+00,
                 0.3124347421479945e-15,
                 0.3167956935940195e+00,
                 0.5631992424023115e+00,
                 -.3474674374809546e+00,
                 -.1389458137326690e+00,
                 0.1389458137326693e+00,
                 0.3474674374809551e+00,
                 -.1895067897708215e+00,
                 -.5085139710592270e-15,
                 0.1895067897708209e+00,
                 -.8586713098275741e-01,
                 0.8586713098275765e-01,
                 0.1285444234099701e-15,
                 -.8082038093669249e+00,
                 -.6163163542315518e+00,
                 -.3152788022829635e+00,
                 -.8730405794292767e-15,
                 0.3152788022829636e+00,
                 0.6163163542315519e+00,
                 0.8082038093669255e+00,
                 -.7146294276813617e+00,
                 -.4976647108982425e+00,
                 -.1655476329309719e+00,
                 0.1655476329309714e+00,
                 0.4976647108982434e+00,
                 0.7146294276813617e+00,
                 -.5537863145619202e+00,
                 -.3193705552342029e+00,
                 -.6832484358818424e-16,
                 0.3193705552342023e+00,
                 0.5537863145619198e+00,
                 -.4048861453560488e+00,
                 -.1538229223032315e+00,
                 0.1538229223032326e+00,
                 0.4048861453560491e+00,
                 -.2385075122789581e+00,
                 0.5333911354317198e-15,
                 0.2385075122789586e+00,
                 -.9831307344980803e-01,
                 0.9831307344980859e-01,
                 -.2190675334206966e-15,
                 -.7023591766066752e+00,
                 -.4542246160156310e+00,
                 -.1503585815913813e+00,
                 0.1503585815913811e+00,
                 0.4542246160156319e+00,
                 0.7023591766066744e+00,
                 -.5537863145619211e+00,
                 -.3193705552342027e+00,
                 -.4110168395201620e-16,
                 0.3193705552342019e+00,
                 0.5537863145619211e+00,
                 -.3983107316598014e+00,
                 -.1568442573170829e+00,
                 0.1568442573170836e+00,
                 0.3983107316598018e+00,
                 -.2479521500684200e+00,
                 -.5917334035232059e-16,
                 0.2479521500684202e+00,
                 -.9956169854628913e-01,
                 0.9956169854628882e-01,
                 0.2509159726481918e-16,
                 -.5631992424023114e+00,
                 -.3167956935940195e+00,
                 -.2066848605380875e-15,
                 0.3167956935940188e+00,
                 0.5631992424023123e+00,
                 -.4048861453560490e+00,
                 -.1538229223032318e+00,
                 0.1538229223032323e+00,
                 0.4048861453560490e+00,
                 -.2479521500684206e+00,
                 0.3977529497345564e-15,
                 0.2479521500684204e+00,
                 -.8809045176202959e-01,
                 0.8809045176202959e-01,
                 -.1129354043194182e-15,
                 -.3474674374809548e+00,
                 -.1389458137326690e+00,
                 0.1389458137326693e+00,
                 0.3474674374809545e+00,
                 -.2385075122789575e+00,
                 0.4923238386096424e-15,
                 0.2385075122789582e+00,
                 -.9956169854628907e-01,
                 0.9956169854628931e-01,
                 0.1613159204525424e-15,
                 -.1895067897708226e+00,
                 0.3794271657455067e-15,
                 0.1895067897708225e+00,
                 -.9831307344980847e-01,
                 0.9831307344980821e-01,
                 -.2639427257266701e-15,
                 -.8586713098275671e-01,
                 0.8586713098275778e-01,
                 -.3482046662102929e-16,
                 0.1977022815449524e-16],
                [-.5325219655204851e+00,
                 -.5161920980855138e+00,
                 -.5149190557691138e+00,
                 -.5257736527726266e+00,
                 -.5257736527726264e+00,
                 -.5149190557691141e+00,
                 -.5161920980855123e+00,
                 -.5325219655204863e+00,
                 -.3674658645232039e+00,
                 -.3558304130215583e+00,
                 -.3424671072905089e+00,
                 -.3658041579492418e+00,
                 -.3424671072905087e+00,
                 -.3558304130215568e+00,
                 -.3674658645232041e+00,
                 -.1866836675067773e+00,
                 -.1018058984065232e+00,
                 -.8680956755675479e-01,
                 -.8680956755675451e-01,
                 -.1018058984065237e+00,
                 -.1866836675067758e+00,
                 0.7605760292014909e-01,
                 0.1829020789746216e+00,
                 0.1736191351135079e+00,
                 0.1829020789746222e+00,
                 0.7605760292014961e-01,
                 0.4497160498524773e+00,
                 0.4442730056970297e+00,
                 0.4442730056970296e+00,
                 0.4497160498524770e+00,
                 0.7016027232758894e+00,
                 0.7116608260431103e+00,
                 0.7016027232758892e+00,
                 0.8836579626087155e+00,
                 0.8836579626087154e+00,
                 0.1065043931040973e+01,
                 -.4666166868980759e+00,
                 -.4693525718637681e+00,
                 -.4574310542038610e+00,
                 -.4675222500249283e+00,
                 -.4574310542038606e+00,
                 -.4693525718637683e+00,
                 -.4666166868980758e+00,
                 -.2990693336004484e+00,
                 -.2873268548032756e+00,
                 -.2731983816350134e+00,
                 -.2731983816350125e+00,
                 -.2873268548032767e+00,
                 -.2990693336004486e+00,
                 -.4432392494984629e-01,
                 -.6769264837097106e-02,
                 0.4486846482284115e-15,
                 -.6769264837096467e-02,
                 -.4432392494984625e-01,
                 0.2337611250124636e+00,
                 0.2799676464721086e+00,
                 0.2799676464721087e+00,
                 0.2337611250124641e+00,
                 0.5017549791537075e+00,
                 0.5746537096065563e+00,
                 0.5017549791537071e+00,
                 0.7684219054642180e+00,
                 0.7684219054642179e+00,
                 0.9332333737961510e+00,
                 -.4055072596816681e+00,
                 -.3772106512425324e+00,
                 -.3731200487330528e+00,
                 -.3731200487330526e+00,
                 -.3772106512425323e+00,
                 -.4055072596816677e+00,
                 -.2047647308725034e+00,
                 -.1843886760357077e+00,
                 -.1811081483657299e+00,
                 -.1843886760357074e+00,
                 -.2047647308725039e+00,
                 0.5634567303139509e-01,
                 0.9055407418286479e-01,
                 0.9055407418286482e-01,
                 0.5634567303139487e-01,
                 0.3167743757016580e+00,
                 0.3687773520714154e+00,
                 0.3167743757016582e+00,
                 0.5819753821150355e+00,
                 0.5819753821150357e+00,
                 0.8110145193633349e+00,
                 -.3251632342083681e+00,
                 -.2846201710503081e+00,
                 -.2863104811762985e+00,
                 -.2846201710503082e+00,
                 -.3251632342083688e+00,
                 -.1320430329367787e+00,
                 -.8880970559930575e-01,
                 -.8880970559930519e-01,
                 -.1320430329367784e+00,
                 0.1431552405881496e+00,
                 0.1776194111986113e+00,
                 0.1431552405881494e+00,
                 0.4166632039870861e+00,
                 0.4166632039870862e+00,
                 0.6503264684167376e+00,
                 -.2006104185642586e+00,
                 -.1951843498746808e+00,
                 -.1951843498746806e+00,
                 -.2006104185642581e+00,
                 -.2273842950465107e-01,
                 -.5379838119796143e-15,
                 -.2273842950465127e-01,
                 0.2179227793793320e+00,
                 0.2179227793793325e+00,
                 0.4012208371285153e+00,
                 -.1094117960874461e+00,
                 -.1135221588422145e+00,
                 -.1094117960874469e+00,
                 0.5676107942110784e-01,
                 0.5676107942110752e-01,
                 0.2188235921748915e+00,
                 -.4957541118743530e-01,
                 -.4957541118743524e-01,
                 0.9915082237487380e-01,
                 0.2540767844190894e-15],
                [-.3765498929503238e+00,
                 -.3650029329511783e+00,
                 -.3641027560965143e+00,
                 -.3717781152447454e+00,
                 -.3717781152447449e+00,
                 -.3641027560965152e+00,
                 -.3650029329511763e+00,
                 -.3765498929503250e+00,
                 -.3650029329511772e+00,
                 -.3720185304983482e+00,
                 -.3640984935800617e+00,
                 -.3665509296862581e+00,
                 -.3640984935800614e+00,
                 -.3720185304983494e+00,
                 -.3650029329511764e+00,
                 -.3641027560965139e+00,
                 -.3640984935800626e+00,
                 -.3650617580380684e+00,
                 -.3650617580380682e+00,
                 -.3640984935800626e+00,
                 -.3641027560965142e+00,
                 -.3717781152447452e+00,
                 -.3665509296862574e+00,
                 -.3650617580380682e+00,
                 -.3665509296862570e+00,
                 -.3717781152447453e+00,
                 -.3717781152447457e+00,
                 -.3640984935800619e+00,
                 -.3640984935800619e+00,
                 -.3717781152447455e+00,
                 -.3641027560965135e+00,
                 -.3720185304983501e+00,
                 -.3641027560965143e+00,
                 -.3650029329511764e+00,
                 -.3650029329511760e+00,
                 -.3765498929503248e+00,
                 -.2247824952281867e+00,
                 -.2114739538338215e+00,
                 -.2015149206712589e+00,
                 -.2226998243341052e+00,
                 -.2015149206712583e+00,
                 -.2114739538338195e+00,
                 -.2247824952281853e+00,
                 -.2114739538338184e+00,
                 -.2031707674483985e+00,
                 -.1931804282633083e+00,
                 -.1931804282633076e+00,
                 -.2031707674483997e+00,
                 -.2114739538338180e+00,
                 -.2015149206712575e+00,
                 -.1931804282633086e+00,
                 -.1920941997563194e+00,
                 -.1931804282633082e+00,
                 -.2015149206712575e+00,
                 -.2226998243341063e+00,
                 -.1931804282633076e+00,
                 -.1931804282633069e+00,
                 -.2226998243341062e+00,
                 -.2015149206712573e+00,
                 -.2031707674484007e+00,
                 -.2015149206712576e+00,
                 -.2114739538338179e+00,
                 -.2114739538338178e+00,
                 -.2247824952281845e+00,
                 -.5463946427558356e-01,
                 0.2538264302263163e-01,
                 0.3984240749101874e-01,
                 0.3984240749101926e-01,
                 0.2538264302263130e-01,
                 -.5463946427558414e-01,
                 0.2538264302263274e-01,
                 0.5801135199449195e-01,
                 0.6403139991877385e-01,
                 0.5801135199449232e-01,
                 0.2538264302263323e-01,
                 0.3984240749101937e-01,
                 0.6403139991877348e-01,
                 0.6403139991877312e-01,
                 0.3984240749101956e-01,
                 0.3984240749101981e-01,
                 0.5801135199449222e-01,
                 0.3984240749101960e-01,
                 0.2538264302263200e-01,
                 0.2538264302263280e-01,
                 -.5463946427558499e-01,
                 0.1956338341290903e+00,
                 0.2946253770101824e+00,
                 0.2853769430560289e+00,
                 0.2946253770101820e+00,
                 0.1956338341290895e+00,
                 0.2946253770101813e+00,
                 0.3283495045321227e+00,
                 0.3283495045321234e+00,
                 0.2946253770101805e+00,
                 0.2853769430560299e+00,
                 0.3283495045321242e+00,
                 0.2853769430560302e+00,
                 0.2946253770101813e+00,
                 0.2946253770101804e+00,
                 0.1956338341290884e+00,
                 0.5479223963604010e+00,
                 0.5402307712286866e+00,
                 0.5402307712286869e+00,
                 0.5479223963604006e+00,
                 0.5402307712286877e+00,
                 0.6095123023452018e+00,
                 0.5402307712286883e+00,
                 0.5402307712286876e+00,
                 0.5402307712286880e+00,
                 0.5479223963604018e+00,
                 0.7828449764686094e+00,
                 0.7949664381659878e+00,
                 0.7828449764686101e+00,
                 0.7949664381659881e+00,
                 0.7949664381659884e+00,
                 0.7828449764686115e+00,
                 0.9547883611305407e+00,
                 0.9547883611305404e+00,
                 0.9547883611305394e+00,
                 0.1129649678850977e+01]],
     quad_degree: 10,
     weights: [0.8928518513884954e-03,
                 0.2728461790986735e-02,
                 0.2698574163466656e-02,
                 0.3819275987016593e-02,
                 0.3819275987016598e-02,
                 0.2698574163466689e-02,
                 0.2728461790986877e-02,
                 0.8928518513884499e-03,
                 0.2728461790986848e-02,
                 0.4772450161957971e-02,
                 0.8285531027833892e-02,
                 0.7628709002547067e-02,
                 0.8285531027833955e-02,
                 0.4772450161957848e-02,
                 0.2728461790986912e-02,
                 0.2698574163466889e-02,
                 0.8285531027833944e-02,
                 0.9382154252740719e-02,
                 0.9382154252740764e-02,
                 0.8285531027833937e-02,
                 0.2698574163466843e-02,
                 0.3819275987016540e-02,
                 0.7628709002547065e-02,
                 0.9382154252740780e-02,
                 0.7628709002547129e-02,
                 0.3819275987016538e-02,
                 0.3819275987016543e-02,
                 0.8285531027833947e-02,
                 0.8285531027833924e-02,
                 0.3819275987016525e-02,
                 0.2698574163466859e-02,
                 0.4772450161957810e-02,
                 0.2698574163466874e-02,
                 0.2728461790986887e-02,
                 0.2728461790986884e-02,
                 0.8928518513884492e-03,
                 0.2728461790986862e-02,
                 0.4772450161957958e-02,
                 0.8285531027833844e-02,
                 0.7628709002547106e-02,
                 0.8285531027833961e-02,
                 0.4772450161957837e-02,
                 0.2728461790986854e-02,
                 0.4772450161957822e-02,
                 0.1534495609378168e-01,
                 0.1800286836440550e-01,
                 0.1800286836440545e-01,
                 0.1534495609378180e-01,
                 0.4772450161957780e-02,
                 0.8285531027833922e-02,
                 0.1800286836440532e-01,
                 0.2265378511397823e-01,
                 0.1800286836440531e-01,
                 0.8285531027834037e-02,
                 0.7628709002547097e-02,
                 0.1800286836440553e-01,
                 0.1800286836440543e-01,
                 0.7628709002546972e-02,
                 0.8285531027833990e-02,
                 0.1534495609378186e-01,
                 0.8285531027833968e-02,
                 0.4772450161957780e-02,
                 0.4772450161957782e-02,
                 0.2728461790986830e-02,
                 0.2698574163466819e-02,
                 0.8285531027833997e-02,
                 0.9382154252740682e-02,
                 0.9382154252740672e-02,
                 0.8285531027833949e-02,
                 0.2698574163466777e-02,
                 0.8285531027833862e-02,
                 0.1800286836440528e-01,
                 0.2265378511397818e-01,
                 0.1800286836440534e-01,
                 0.8285531027833885e-02,
                 0.9382154252740836e-02,
                 0.2265378511397831e-01,
                 0.2265378511397818e-01,
                 0.9382154252740782e-02,
                 0.9382154252740681e-02,
                 0.1800286836440537e-01,
                 0.9382154252740688e-02,
                 0.8285531027833858e-02,
                 0.8285531027833839e-02,
                 0.2698574163466754e-02,
                 0.3819275987016547e-02,
                 0.7628709002547012e-02,
                 0.9382154252740730e-02,
                 0.7628709002547075e-02,
                 0.3819275987016546e-02,
                 0.7628709002547132e-02,
                 0.1800286836440544e-01,
                 0.1800286836440537e-01,
                 0.7628709002547111e-02,
                 0.9382154252740669e-02,
                 0.1800286836440549e-01,
                 0.9382154252740689e-02,
                 0.7628709002547078e-02,
                 0.7628709002547073e-02,
                 0.3819275987016574e-02,
                 0.3819275987016516e-02,
                 0.8285531027834012e-02,
                 0.8285531027833972e-02,
                 0.3819275987016566e-02,
                 0.8285531027834013e-02,
                 0.1534495609378188e-01,
                 0.8285531027833929e-02,
                 0.8285531027833937e-02,
                 0.8285531027833886e-02,
                 0.3819275987016649e-02,
                 0.2698574163466852e-02,
                 0.4772450161957721e-02,
                 0.2698574163466797e-02,
                 0.4772450161957751e-02,
                 0.4772450161957782e-02,
                 0.2698574163466718e-02,
                 0.2728461790986958e-02,
                 0.2728461790986934e-02,
                 0.2728461790986876e-02,
                 0.8928518513884023e-03]},
 8: {points: [[-.8953158689081910e+00,
                 -.7888643809639553e+00,
                 -.6321612859079181e+00,
                 -.3131994208769926e+00,
                 0.2811428088761160e-15,
                 0.3131994208769926e+00,
                 0.6321612859079193e+00,
                 0.7888643809639549e+00,
                 0.8953158689081908e+00,
                 -.8466564327488375e+00,
                 -.6830576218509568e+00,
                 -.4687426154655973e+00,
                 -.1614432627798252e+00,
                 0.1614432627798251e+00,
                 0.4687426154655971e+00,
                 0.6830576218509541e+00,
                 0.8466564327488372e+00,
                 -.7780136540897251e+00,
                 -.5704063920163248e+00,
                 -.3033643570996020e+00,
                 0.1661932656601236e-15,
                 0.3033643570996014e+00,
                 0.5704063920163250e+00,
                 0.7780136540897250e+00,
                 -.6079015814142359e+00,
                 -.4153371410495298e+00,
                 -.1365908236757415e+00,
                 0.1365908236757413e+00,
                 0.4153371410495294e+00,
                 0.6079015814142360e+00,
                 -.4724952683622715e+00,
                 -.2538938782697047e+00,
                 0.4114924732586100e-16,
                 0.2538938782697047e+00,
                 0.4724952683622712e+00,
                 -.2947021605372432e+00,
                 -.1016637765507277e+00,
                 0.1016637765507277e+00,
                 0.2947021605372432e+00,
                 -.1458523681818065e+00,
                 -.2709635734318579e-15,
                 0.1458523681818081e+00,
                 -.5779205178488211e-01,
                 0.5779205178488374e-01,
                 -.4203547358126597e-15,
                 -.8466564327488366e+00,
                 -.6830576218509547e+00,
                 -.4687426154655976e+00,
                 -.1614432627798252e+00,
                 0.1614432627798254e+00,
                 0.4687426154655969e+00,
                 0.6830576218509554e+00,
                 0.8466564327488387e+00,
                 -.7695539132993963e+00,
                 -.5972549259770307e+00,
                 -.2766926232436492e+00,
                 -.2838064215917929e-17,
                 0.2766926232436492e+00,
                 0.5972549259770316e+00,
                 0.7695539132993976e+00,
                 -.6472829098025556e+00,
                 -.4040790613524974e+00,
                 -.1377341761844062e+00,
                 0.1377341761844063e+00,
                 0.4040790613524976e+00,
                 0.6472829098025554e+00,
                 -.4959219934777450e+00,
                 -.2763095025399597e+00,
                 0.2550898741907970e-15,
                 0.2763095025399595e+00,
                 0.4959219934777451e+00,
                 -.3344787306979198e+00,
                 -.1273864381088486e+00,
                 0.1273864381088483e+00,
                 0.3344787306979198e+00,
                 -.1785402943369587e+00,
                 0.8987966779557184e-16,
                 0.1785402943369585e+00,
                 -.8649629144844082e-01,
                 0.8649629144843972e-01,
                 -.1763458853612107e-14,
                 -.7780136540897252e+00,
                 -.5704063920163247e+00,
                 -.3033643570996016e+00,
                 -.4619123623515068e-16,
                 0.3033643570996014e+00,
                 0.5704063920163251e+00,
                 0.7780136540897239e+00,
                 -.6472829098025557e+00,
                 -.4040790613524974e+00,
                 -.1377341761844064e+00,
                 0.1377341761844064e+00,
                 0.4040790613524973e+00,
                 0.6472829098025557e+00,
                 -.5056002536991157e+00,
                 -.2820434058229077e+00,
                 0.7728180217143092e-16,
                 0.2820434058229079e+00,
                 0.5056002536991161e+00,
                 -.3508756896635370e+00,
                 -.1443092296385013e+00,
                 0.1443092296385015e+00,
                 0.3508756896635370e+00,
                 -.2022358965995142e+00,
                 -.4484039987089917e-16,
                 0.2022358965995140e+00,
                 -.7687651778623104e-01,
                 0.7687651778623104e-01,
                 0.8916286603997394e-16,
                 -.6079015814142359e+00,
                 -.4153371410495298e+00,
                 -.1365908236757414e+00,
                 0.1365908236757415e+00,
                 0.4153371410495294e+00,
                 0.6079015814142363e+00,
                 -.4959219934777449e+00,
                 -.2763095025399595e+00,
                 0.8820053010898188e-16,
                 0.2763095025399595e+00,
                 0.4959219934777449e+00,
                 -.3508756896635369e+00,
                 -.1443092296385013e+00,
                 0.1443092296385013e+00,
                 0.3508756896635369e+00,
                 -.2142848659877956e+00,
                 0.3417483826325515e-15,
                 0.2142848659877956e+00,
                 -.8058485242821514e-01,
                 0.8058485242821527e-01,
                 0.7992998381700989e-16,
                 -.4724952683622717e+00,
                 -.2538938782697047e+00,
                 0.1838763120018063e-15,
                 0.2538938782697046e+00,
                 0.4724952683622710e+00,
                 -.3344787306979200e+00,
                 -.1273864381088485e+00,
                 0.1273864381088485e+00,
                 0.3344787306979198e+00,
                 -.2022358965995140e+00,
                 0.1750871913796980e-15,
                 0.2022358965995142e+00,
                 -.8058485242821521e-01,
                 0.8058485242821525e-01,
                 0.6281841789969612e-17,
                 -.2947021605372432e+00,
                 -.1016637765507275e+00,
                 0.1016637765507278e+00,
                 0.2947021605372431e+00,
                 -.1785402943369584e+00,
                 -.1731463777929788e-15,
                 0.1785402943369586e+00,
                 -.7687651778623094e-01,
                 0.7687651778623084e-01,
                 -.7998454933621241e-16,
                 -.1458523681818067e+00,
                 -.3689174122508912e-15,
                 0.1458523681818069e+00,
                 -.8649629144844080e-01,
                 0.8649629144844022e-01,
                 -.3288432315381665e-16,
                 -.5779205178488232e-01,
                 0.5779205178488267e-01,
                 -.3610112033628794e-15,
                 -.1494143292610188e-15],
                [-.5169108579238874e+00,
                 -.5221835760136930e+00,
                 -.5333942966536176e+00,
                 -.5211185133872499e+00,
                 -.5455905407595639e+00,
                 -.5211185133872499e+00,
                 -.5333942966536183e+00,
                 -.5221835760136902e+00,
                 -.5169108579238880e+00,
                 -.4220848060486238e+00,
                 -.3943635018476749e+00,
                 -.3880198927365046e+00,
                 -.3863807091540075e+00,
                 -.3863807091540079e+00,
                 -.3880198927365050e+00,
                 -.3943635018476747e+00,
                 -.4220848060486241e+00,
                 -.2807705845584859e+00,
                 -.2119330664613154e+00,
                 -.1751474932339930e+00,
                 -.1577214976360441e+00,
                 -.1751474932339924e+00,
                 -.2119330664613152e+00,
                 -.2807705845584857e+00,
                 -.1067939823642499e-01,
                 0.5337638773982845e-01,
                 0.7886074881802214e-01,
                 0.7886074881802186e-01,
                 0.5337638773982845e-01,
                 -.1067939823642519e-01,
                 0.2727952703797820e+00,
                 0.3330043214141794e+00,
                 0.3502949864679856e+00,
                 0.3330043214141787e+00,
                 0.2727952703797817e+00,
                 0.5317979116236747e+00,
                 0.5999529591978199e+00,
                 0.5999529591978204e+00,
                 0.5317979116236753e+00,
                 0.8141648812121049e+00,
                 0.7887270036953496e+00,
                 0.8141648812121014e+00,
                 0.9442683820623158e+00,
                 0.9442683820623173e+00,
                 0.1033821715847775e+01,
                 -.4888173193586698e+00,
                 -.4942408161509975e+00,
                 -.4767892492129879e+00,
                 -.4794320816380801e+00,
                 -.4794320816380803e+00,
                 -.4767892492129875e+00,
                 -.4942408161509986e+00,
                 -.4888173193586707e+00,
                 -.3444248446960134e+00,
                 -.3448252922876687e+00,
                 -.3068417491790068e+00,
                 -.3190547313421944e+00,
                 -.3068417491790070e+00,
                 -.3448252922876691e+00,
                 -.3444248446960141e+00,
                 -.1675483882230740e+00,
                 -.8620196617925329e-01,
                 -.7952086369667828e-01,
                 -.7952086369667832e-01,
                 -.8620196617925341e-01,
                 -.1675483882230736e+00,
                 0.9990207398186490e-01,
                 0.1595273656710975e+00,
                 0.1590417273933566e+00,
                 0.1595273656710972e+00,
                 0.9990207398186481e-01,
                 0.3795300076562155e+00,
                 0.3930437153582605e+00,
                 0.3930437153582602e+00,
                 0.3795300076562152e+00,
                 0.6443376374360619e+00,
                 0.6896505845753373e+00,
                 0.6443376374360614e+00,
                 0.8386656608470093e+00,
                 0.8386656608470136e+00,
                 0.9776346387173395e+00,
                 -.4491863926219073e+00,
                 -.4180936404545914e+00,
                 -.4086693919170623e+00,
                 -.4051563477586773e+00,
                 -.4086693919170625e+00,
                 -.4180936404545913e+00,
                 -.4491863926219064e+00,
                 -.2849396057398668e+00,
                 -.2332951548457559e+00,
                 -.2461548088533510e+00,
                 -.2461548088533509e+00,
                 -.2332951548457557e+00,
                 -.2849396057398668e+00,
                 -.5838654389245797e-01,
                 0.3796108881658004e-02,
                 0.1690912202446459e-15,
                 0.3796108881658013e-02,
                 -.5838654389245814e-01,
                 0.2025781738793391e+00,
                 0.2423586999716929e+00,
                 0.2423586999716929e+00,
                 0.2025781738793386e+00,
                 0.4670559358095198e+00,
                 0.4665903096915113e+00,
                 0.4670559358095211e+00,
                 0.7030332461944585e+00,
                 0.7030332461944575e+00,
                 0.8983727852438142e+00,
                 -.3509721416703083e+00,
                 -.3328463826734682e+00,
                 -.3262955989406555e+00,
                 -.3262955989406553e+00,
                 -.3328463826734680e+00,
                 -.3509721416703087e+00,
                 -.1932693239473593e+00,
                 -.1595273656710975e+00,
                 -.1666339451566725e+00,
                 -.1595273656710967e+00,
                 -.1932693239473593e+00,
                 0.4485667624329466e-01,
                 0.8331697257833645e-01,
                 0.8331697257833636e-01,
                 0.4485667624329484e-01,
                 0.2814389226973609e+00,
                 0.3190547313421942e+00,
                 0.2814389226973605e+00,
                 0.5261157066208272e+00,
                 0.5261157066208275e+00,
                 0.7019442833406166e+00,
                 -.2727952703797821e+00,
                 -.2396370714486847e+00,
                 -.2335218986830696e+00,
                 -.2396370714486846e+00,
                 -.2727952703797815e+00,
                 -.1000600127225759e+00,
                 -.7354659433325097e-01,
                 -.7354659433325097e-01,
                 -.1000600127225755e+00,
                 0.1167609493415351e+00,
                 0.1470931886665023e+00,
                 0.1167609493415348e+00,
                 0.3396970841712601e+00,
                 0.3396970841712605e+00,
                 0.5455905407595638e+00,
                 -.1701463717169417e+00,
                 -.1474649652348795e+00,
                 -.1474649652348794e+00,
                 -.1701463717169416e+00,
                 -.1431093052015493e-01,
                 -.9462081284270685e-17,
                 -.1431093052015501e-01,
                 0.1617758957550346e+00,
                 0.1617758957550345e+00,
                 0.3402927434338834e+00,
                 -.8420790403171055e-01,
                 -.9987731430332329e-01,
                 -.8420790403171046e-01,
                 0.4993865715166155e-01,
                 0.4993865715166176e-01,
                 0.1684158080634210e+00,
                 -.3336625665502245e-01,
                 -.3336625665502341e-01,
                 0.6673251331004629e-01,
                 0.1666315056143941e-15],
                [-.3655111729069371e+00,
                 -.3692395476235224e+00,
                 -.3771667242100020e+00,
                 -.3684864346179772e+00,
                 -.3857907711223230e+00,
                 -.3684864346179770e+00,
                 -.3771667242100024e+00,
                 -.3692395476235216e+00,
                 -.3655111729069377e+00,
                 -.3692395476235228e+00,
                 -.3847929957548343e+00,
                 -.3685256182783900e+00,
                 -.3719083042857705e+00,
                 -.3719083042857707e+00,
                 -.3685256182783901e+00,
                 -.3847929957548340e+00,
                 -.3692395476235232e+00,
                 -.3771667242100020e+00,
                 -.3685256182783900e+00,
                 -.3715353573451158e+00,
                 -.3739702311527315e+00,
                 -.3715353573451156e+00,
                 -.3685256182783904e+00,
                 -.3771667242100022e+00,
                 -.3684864346179771e+00,
                 -.3719083042857705e+00,
                 -.3739702311527314e+00,
                 -.3739702311527315e+00,
                 -.3719083042857705e+00,
                 -.3684864346179771e+00,
                 -.3857907711223230e+00,
                 -.3719083042857707e+00,
                 -.3715353573451158e+00,
                 -.3719083042857705e+00,
                 -.3857907711223228e+00,
                 -.3684864346179770e+00,
                 -.3685256182783900e+00,
                 -.3685256182783901e+00,
                 -.3684864346179771e+00,
                 -.3771667242100023e+00,
                 -.3847929957548339e+00,
                 -.3771667242100020e+00,
                 -.3692395476235219e+00,
                 -.3692395476235250e+00,
                 -.3655111729069367e+00,
                 -.2748655222492140e+00,
                 -.2435451432936739e+00,
                 -.2429867904262157e+00,
                 -.2403137913213643e+00,
                 -.2403137913213644e+00,
                 -.2429867904262158e+00,
                 -.2435451432936749e+00,
                 -.2748655222492123e+00,
                 -.2435451432936742e+00,
                 -.2438283025012439e+00,
                 -.2169698815956174e+00,
                 -.2256057641017182e+00,
                 -.2169698815956177e+00,
                 -.2438283025012440e+00,
                 -.2435451432936755e+00,
                 -.2429867904262159e+00,
                 -.2169698815956175e+00,
                 -.2329717308599582e+00,
                 -.2329717308599579e+00,
                 -.2169698815956176e+00,
                 -.2429867904262157e+00,
                 -.2403137913213643e+00,
                 -.2256057641017179e+00,
                 -.2329717308599582e+00,
                 -.2256057641017175e+00,
                 -.2403137913213644e+00,
                 -.2403137913213643e+00,
                 -.2169698815956177e+00,
                 -.2169698815956175e+00,
                 -.2403137913213642e+00,
                 -.2429867904262159e+00,
                 -.2438283025012437e+00,
                 -.2429867904262159e+00,
                 -.2435451432936737e+00,
                 -.2435451432936754e+00,
                 -.2748655222492131e+00,
                 -.1389908043286878e+00,
                 -.7697053851047725e-01,
                 -.4128552111640288e-01,
                 -.2404451030554931e-01,
                 -.4128552111640304e-01,
                 -.7697053851047719e-01,
                 -.1389908043286864e+00,
                 -.7697053851047702e-01,
                 -.8948699250745431e-02,
                 0.2684254332342556e-02,
                 0.2684254332342700e-02,
                 -.8948699250745599e-02,
                 -.7697053851047687e-01,
                 -.4128552111640309e-01,
                 0.2684254332342715e-02,
                 0.1151873098462106e-15,
                 0.2684254332342919e-02,
                 -.4128552111640321e-01,
                 -.2404451030554927e-01,
                 0.2684254332342982e-02,
                 0.2684254332342853e-02,
                 -.2404451030554915e-01,
                 -.4128552111640282e-01,
                 -.8948699250745746e-02,
                 -.4128552111640333e-01,
                 -.7697053851047723e-01,
                 -.7697053851047680e-01,
                 -.1389908043286875e+00,
                 0.1127601783233686e+00,
                 0.1742931757300239e+00,
                 0.1990073707291402e+00,
                 0.1990073707291403e+00,
                 0.1742931757300238e+00,
                 0.1127601783233688e+00,
                 0.1742931757300239e+00,
                 0.2256057641017178e+00,
                 0.2276032221952725e+00,
                 0.2256057641017179e+00,
                 0.1742931757300237e+00,
                 0.1990073707291403e+00,
                 0.2276032221952725e+00,
                 0.2276032221952726e+00,
                 0.1990073707291402e+00,
                 0.1990073707291400e+00,
                 0.2256057641017178e+00,
                 0.1990073707291402e+00,
                 0.1742931757300240e+00,
                 0.1742931757300236e+00,
                 0.1127601783233687e+00,
                 0.3857907711223231e+00,
                 0.4379289198771112e+00,
                 0.4541063995779216e+00,
                 0.4379289198771111e+00,
                 0.3857907711223231e+00,
                 0.4379289198771113e+00,
                 0.4428884624419804e+00,
                 0.4428884624419804e+00,
                 0.4379289198771111e+00,
                 0.4541063995779217e+00,
                 0.4428884624419805e+00,
                 0.4541063995779222e+00,
                 0.4379289198771113e+00,
                 0.4379289198771113e+00,
                 0.3857907711223231e+00,
                 0.6242126909125854e+00,
                 0.6884829472150826e+00,
                 0.6884829472150830e+00,
                 0.6242126909125858e+00,
                 0.6884829472150832e+00,
                 0.7314849075037326e+00,
                 0.6884829472150824e+00,
                 0.6884829472150829e+00,
                 0.6884829472150826e+00,
                 0.6242126909125854e+00,
                 0.8933242527486929e+00,
                 0.8718832823421836e+00,
                 0.8933242527486921e+00,
                 0.8718832823421835e+00,
                 0.8718832823421847e+00,
                 0.8933242527486923e+00,
                 0.1013344617496258e+01,
                 0.1013344617496259e+01,
                 0.1013344617496259e+01,
                 0.1096533518720810e+01]],
     quad_degree: 11,
     weights: [0.1385861287412689e-02,
                 0.6855716948648167e-03,
                 0.1981802749239348e-02,
                 0.3086702153590131e-02,
                 0.1621215180459782e-02,
                 0.3086702153590128e-02,
                 0.1981802749239332e-02,
                 0.6855716948648163e-03,
                 0.1385861287412678e-02,
                 0.6855716948648021e-03,
                 0.2205033346028010e-02,
                 0.4207539340758652e-02,
                 0.5950699987392893e-02,
                 0.5950699987392876e-02,
                 0.4207539340758647e-02,
                 0.2205033346028006e-02,
                 0.6855716948648208e-03,
                 0.1981802749239340e-02,
                 0.4207539340758635e-02,
                 0.6704077724194005e-02,
                 0.6113189481229828e-02,
                 0.6704077724194035e-02,
                 0.4207539340758636e-02,
                 0.1981802749239334e-02,
                 0.3086702153590127e-02,
                 0.5950699987392910e-02,
                 0.6113189481229854e-02,
                 0.6113189481229805e-02,
                 0.5950699987392890e-02,
                 0.3086702153590126e-02,
                 0.1621215180459784e-02,
                 0.5950699987392866e-02,
                 0.6704077724194010e-02,
                 0.5950699987392919e-02,
                 0.1621215180459806e-02,
                 0.3086702153590135e-02,
                 0.4207539340758651e-02,
                 0.4207539340758648e-02,
                 0.3086702153590104e-02,
                 0.1981802749239341e-02,
                 0.2205033346028026e-02,
                 0.1981802749239316e-02,
                 0.6855716948648056e-03,
                 0.6855716948648310e-03,
                 0.1385861287412694e-02,
                 0.6855716948648295e-03,
                 0.2205033346027993e-02,
                 0.4207539340758640e-02,
                 0.5950699987392924e-02,
                 0.5950699987392876e-02,
                 0.4207539340758665e-02,
                 0.2205033346027979e-02,
                 0.6855716948648397e-03,
                 0.2205033346028005e-02,
                 0.9363547649225308e-02,
                 0.1277100684258647e-01,
                 0.1066951957613014e-01,
                 0.1277100684258650e-01,
                 0.9363547649225309e-02,
                 0.2205033346027989e-02,
                 0.4207539340758658e-02,
                 0.1277100684258648e-01,
                 0.1302897151529464e-01,
                 0.1302897151529459e-01,
                 0.1277100684258651e-01,
                 0.4207539340758669e-02,
                 0.5950699987392895e-02,
                 0.1066951957613015e-01,
                 0.1302897151529465e-01,
                 0.1066951957613013e-01,
                 0.5950699987392876e-02,
                 0.5950699987392883e-02,
                 0.1277100684258649e-01,
                 0.1277100684258648e-01,
                 0.5950699987392909e-02,
                 0.4207539340758632e-02,
                 0.9363547649225285e-02,
                 0.4207539340758660e-02,
                 0.2205033346028012e-02,
                 0.2205033346028036e-02,
                 0.6855716948648016e-03,
                 0.1981802749239337e-02,
                 0.4207539340758642e-02,
                 0.6704077724193989e-02,
                 0.6113189481229851e-02,
                 0.6704077724193999e-02,
                 0.4207539340758667e-02,
                 0.1981802749239329e-02,
                 0.4207539340758651e-02,
                 0.1277100684258647e-01,
                 0.1302897151529463e-01,
                 0.1302897151529464e-01,
                 0.1277100684258649e-01,
                 0.4207539340758662e-02,
                 0.6704077724194018e-02,
                 0.1302897151529467e-01,
                 0.2335298733600789e-01,
                 0.1302897151529462e-01,
                 0.6704077724193980e-02,
                 0.6113189481229799e-02,
                 0.1302897151529462e-01,
                 0.1302897151529462e-01,
                 0.6113189481229840e-02,
                 0.6704077724194015e-02,
                 0.1277100684258649e-01,
                 0.6704077724193981e-02,
                 0.4207539340758640e-02,
                 0.4207539340758648e-02,
                 0.1981802749239336e-02,
                 0.3086702153590130e-02,
                 0.5950699987392893e-02,
                 0.6113189481229834e-02,
                 0.6113189481229829e-02,
                 0.5950699987392931e-02,
                 0.3086702153590091e-02,
                 0.5950699987392900e-02,
                 0.1066951957613015e-01,
                 0.1302897151529464e-01,
                 0.1066951957613012e-01,
                 0.5950699987392921e-02,
                 0.6113189481229868e-02,
                 0.1302897151529459e-01,
                 0.1302897151529455e-01,
                 0.6113189481229841e-02,
                 0.6113189481229816e-02,
                 0.1066951957613014e-01,
                 0.6113189481229862e-02,
                 0.5950699987392929e-02,
                 0.5950699987392897e-02,
                 0.3086702153590126e-02,
                 0.1621215180459776e-02,
                 0.5950699987392884e-02,
                 0.6704077724194030e-02,
                 0.5950699987392893e-02,
                 0.1621215180459805e-02,
                 0.5950699987392888e-02,
                 0.1277100684258652e-01,
                 0.1277100684258650e-01,
                 0.5950699987392873e-02,
                 0.6704077724194020e-02,
                 0.1277100684258649e-01,
                 0.6704077724193977e-02,
                 0.5950699987392898e-02,
                 0.5950699987392889e-02,
                 0.1621215180459787e-02,
                 0.3086702153590131e-02,
                 0.4207539340758666e-02,
                 0.4207539340758666e-02,
                 0.3086702153590115e-02,
                 0.4207539340758654e-02,
                 0.9363547649225310e-02,
                 0.4207539340758667e-02,
                 0.4207539340758639e-02,
                 0.4207539340758660e-02,
                 0.3086702153590123e-02,
                 0.1981802749239333e-02,
                 0.2205033346027987e-02,
                 0.1981802749239339e-02,
                 0.2205033346027991e-02,
                 0.2205033346028005e-02,
                 0.1981802749239346e-02,
                 0.6855716948647998e-03,
                 0.6855716948648036e-03,
                 0.6855716948647769e-03,
                 0.1385861287412726e-02]},
 9: {points: [[-.9121980484114404e+00,
                 -.8306167813791091e+00,
                 -.6746110484265159e+00,
                 -.4328579328464431e+00,
                 -.1435639464804880e+00,
                 0.1435639464804877e+00,
                 0.4328579328464426e+00,
                 0.6746110484265149e+00,
                 0.8306167813791075e+00,
                 0.9121980484114401e+00,
                 -.8886979569877667e+00,
                 -.7285406174049753e+00,
                 -.5448372568349485e+00,
                 -.3010292552392125e+00,
                 -.1991419433169544e-15,
                 0.3010292552392123e+00,
                 0.5448372568349474e+00,
                 0.7285406174049751e+00,
                 0.8886979569877660e+00,
                 -.8019375322589145e+00,
                 -.6437874061368755e+00,
                 -.4137387022066464e+00,
                 -.1315424418326653e+00,
                 0.1315424418326650e+00,
                 0.4137387022066463e+00,
                 0.6437874061368754e+00,
                 0.8019375322589157e+00,
                 -.6858355427382172e+00,
                 -.5148828418125132e+00,
                 -.2574464966506416e+00,
                 -.4155441739045759e-15,
                 0.2574464966506412e+00,
                 0.5148828418125124e+00,
                 0.6858355427382163e+00,
                 -.5387038993844682e+00,
                 -.3601818451928158e+00,
                 -.1259040548179767e+00,
                 0.1259040548179767e+00,
                 0.3601818451928159e+00,
                 0.5387038993844688e+00,
                 -.3951399529039803e+00,
                 -.2138535865733003e+00,
                 -.1907908374306861e-15,
                 0.2138535865733001e+00,
                 0.3951399529039801e+00,
                 -.2529776098917742e+00,
                 -.9895014930192795e-01,
                 0.9895014930192718e-01,
                 0.2529776098917742e+00,
                 -.1273264838323989e+00,
                 -.7825724243703992e-15,
                 0.1273264838323978e+00,
                 -.5808117560865567e-01,
                 0.5808117560865728e-01,
                 -.7943334557788242e-16,
                 -.8886979569877649e+00,
                 -.7285406174049735e+00,
                 -.5448372568349472e+00,
                 -.3010292552392129e+00,
                 0.9982971871122978e-16,
                 0.3010292552392126e+00,
                 0.5448372568349478e+00,
                 0.7285406174049748e+00,
                 0.8886979569877659e+00,
                 -.7973827948127363e+00,
                 -.6626699113310480e+00,
                 -.3961780804613917e+00,
                 -.1146677642307420e+00,
                 0.1146677642307419e+00,
                 0.3961780804613917e+00,
                 0.6626699113310482e+00,
                 0.7973827948127366e+00,
                 -.7053865284798729e+00,
                 -.5065688635293497e+00,
                 -.2453075437221182e+00,
                 0.1284126380764863e-16,
                 0.2453075437221181e+00,
                 0.5065688635293499e+00,
                 0.7053865284798736e+00,
                 -.5801413170927292e+00,
                 -.3629350463651043e+00,
                 -.1308233218768091e+00,
                 0.1308233218768093e+00,
                 0.3629350463651044e+00,
                 0.5801413170927289e+00,
                 -.4275793308809335e+00,
                 -.2482672821343627e+00,
                 0.2357584797482795e-15,
                 0.2482672821343626e+00,
                 0.4275793308809334e+00,
                 -.2791120618535165e+00,
                 -.1103907830679575e+00,
                 0.1103907830679585e+00,
                 0.2791120618535170e+00,
                 -.1605492716449248e+00,
                 -.1588634300838128e-15,
                 0.1605492716449251e+00,
                 -.6884217740776287e-01,
                 0.6884217740776251e-01,
                 0.4225855166434987e-15,
                 -.8019375322589130e+00,
                 -.6437874061368753e+00,
                 -.4137387022066460e+00,
                 -.1315424418326649e+00,
                 0.1315424418326651e+00,
                 0.4137387022066458e+00,
                 0.6437874061368748e+00,
                 0.8019375322589132e+00,
                 -.7053865284798734e+00,
                 -.5065688635293500e+00,
                 -.2453075437221179e+00,
                 -.1359140798151450e-15,
                 0.2453075437221176e+00,
                 0.5065688635293497e+00,
                 0.7053865284798730e+00,
                 -.5839260007774761e+00,
                 -.3724748199285080e+00,
                 -.1453586782480421e+00,
                 0.1453586782480417e+00,
                 0.3724748199285079e+00,
                 0.5839260007774762e+00,
                 -.4384828671547906e+00,
                 -.2544919138990925e+00,
                 0.5226286374651878e-16,
                 0.2544919138990923e+00,
                 0.4384828671547906e+00,
                 -.3069404253221252e+00,
                 -.1271672762063904e+00,
                 0.1271672762063902e+00,
                 0.3069404253221252e+00,
                 -.1701872985708300e+00,
                 0.1859170816580892e-15,
                 0.1701872985708300e+00,
                 -.6159912234299805e-01,
                 0.6159912234299804e-01,
                 -.3047021551277493e-15,
                 -.6858355427382172e+00,
                 -.5148828418125124e+00,
                 -.2574464966506413e+00,
                 0.1417764127313128e-15,
                 0.2574464966506415e+00,
                 0.5148828418125126e+00,
                 0.6858355427382173e+00,
                 -.5801413170927287e+00,
                 -.3629350463651043e+00,
                 -.1308233218768096e+00,
                 0.1308233218768097e+00,
                 0.3629350463651036e+00,
                 0.5801413170927288e+00,
                 -.4384828671547905e+00,
                 -.2544919138990925e+00,
                 0.8675413555595385e-16,
                 0.2544919138990927e+00,
                 0.4384828671547905e+00,
                 -.3104707234435453e+00,
                 -.1236685920222826e+00,
                 0.1236685920222827e+00,
                 0.3104707234435453e+00,
                 -.1810363705041491e+00,
                 0.5302910071271341e-16,
                 0.1810363705041490e+00,
                 -.6525847528021659e-01,
                 0.6525847528021629e-01,
                 0.1676043969080771e-15,
                 -.5387038993844681e+00,
                 -.3601818451928155e+00,
                 -.1259040548179764e+00,
                 0.1259040548179763e+00,
                 0.3601818451928154e+00,
                 0.5387038993844678e+00,
                 -.4275793308809334e+00,
                 -.2482672821343633e+00,
                 -.1978579120261500e-15,
                 0.2482672821343631e+00,
                 0.4275793308809333e+00,
                 -.3069404253221253e+00,
                 -.1271672762063904e+00,
                 0.1271672762063906e+00,
                 0.3069404253221255e+00,
                 -.1810363705041492e+00,
                 0.1234253698182146e-15,
                 0.1810363705041492e+00,
                 -.6739748568811813e-01,
                 0.6739748568811792e-01,
                 -.3124304849348906e-15,
                 -.3951399529039801e+00,
                 -.2138535865733002e+00,
                 0.2508896779207184e-15,
                 0.2138535865733005e+00,
                 0.3951399529039803e+00,
                 -.2791120618535168e+00,
                 -.1103907830679582e+00,
                 0.1103907830679576e+00,
                 0.2791120618535168e+00,
                 -.1701872985708300e+00,
                 -.3121890414390991e-15,
                 0.1701872985708299e+00,
                 -.6525847528021644e-01,
                 0.6525847528021658e-01,
                 0.1008821727226567e-15,
                 -.2529776098917746e+00,
                 -.9895014930192725e-01,
                 0.9895014930192738e-01,
                 0.2529776098917743e+00,
                 -.1605492716449254e+00,
                 -.1087156697835477e-15,
                 0.1605492716449251e+00,
                 -.6159912234299806e-01,
                 0.6159912234299818e-01,
                 0.6425749817419117e-16,
                 -.1273264838323982e+00,
                 0.8040452641633015e-15,
                 0.1273264838323989e+00,
                 -.6884217740776248e-01,
                 0.6884217740776280e-01,
                 0.5122285048747255e-16,
                 -.5808117560865610e-01,
                 0.5808117560865495e-01,
                 -.1591332259917546e-15,
                 0.2663311397724117e-15],
                [-.5266577888045969e+00,
                 -.5466231870676634e+00,
                 -.5365108298385527e+00,
                 -.5420240263896865e+00,
                 -.5391549994998129e+00,
                 -.5391549994998127e+00,
                 -.5420240263896868e+00,
                 -.5365108298385517e+00,
                 -.5466231870676647e+00,
                 -.5266577888045962e+00,
                 -.4460236399501422e+00,
                 -.4206231215743382e+00,
                 -.4288197275698371e+00,
                 -.4207361730968356e+00,
                 -.4159021705585761e+00,
                 -.4207361730968357e+00,
                 -.4288197275698367e+00,
                 -.4206231215743378e+00,
                 -.4460236399501426e+00,
                 -.3159748906917410e+00,
                 -.2574330415623733e+00,
                 -.2388721510931736e+00,
                 -.2213275440843980e+00,
                 -.2213275440843978e+00,
                 -.2388721510931736e+00,
                 -.2574330415623737e+00,
                 -.3159748906917417e+00,
                 -.1038539528797947e+00,
                 -.5033089577105044e-01,
                 -.3255324260725849e-02,
                 -.4486979436119570e-15,
                 -.3255324260725722e-02,
                 -.5033089577105029e-01,
                 -.1038539528797952e+00,
                 0.1452474750302543e+00,
                 0.2079510852792885e+00,
                 0.2245828683451241e+00,
                 0.2245828683451236e+00,
                 0.2079510852792885e+00,
                 0.1452474750302543e+00,
                 0.3939075244695589e+00,
                 0.4710670688678857e+00,
                 0.4777443021863473e+00,
                 0.4710670688678857e+00,
                 0.3939075244695588e+00,
                 0.6458779792694809e+00,
                 0.6862527691322095e+00,
                 0.6862527691322095e+00,
                 0.6458779792694814e+00,
                 0.8524857205302939e+00,
                 0.8412462431486755e+00,
                 0.8524857205302929e+00,
                 0.9926468270178056e+00,
                 0.9926468270178054e+00,
                 0.1053315577609193e+01,
                 -.5130900046951561e+00,
                 -.5001152208902817e+00,
                 -.4999482673029862e+00,
                 -.4960901696367107e+00,
                 -.4937260835680537e+00,
                 -.4960901696367108e+00,
                 -.4999482673029863e+00,
                 -.5001152208902813e+00,
                 -.5130900046951572e+00,
                 -.3808770719163659e+00,
                 -.3825926516908465e+00,
                 -.3562018180420917e+00,
                 -.3528778288884933e+00,
                 -.3528778288884938e+00,
                 -.3562018180420919e+00,
                 -.3825926516908462e+00,
                 -.3808770719163662e+00,
                 -.2218687716957977e+00,
                 -.1649993730810747e+00,
                 -.1416283764022108e+00,
                 -.1510617602037136e+00,
                 -.1416283764022110e+00,
                 -.1649993730810745e+00,
                 -.2218687716957988e+00,
                 -.1265389750111267e-01,
                 0.7713371762525968e-01,
                 0.7553088010185681e-01,
                 0.7553088010185726e-01,
                 0.7713371762525965e-01,
                 -.1265389750111255e-01,
                 0.2468630417840267e+00,
                 0.2757441112632336e+00,
                 0.2832567528044215e+00,
                 0.2757441112632334e+00,
                 0.2468630417840271e+00,
                 0.5087440671378232e+00,
                 0.5212011911231663e+00,
                 0.5212011911231671e+00,
                 0.5087440671378229e+00,
                 0.7218170389987856e+00,
                 0.7651853033816919e+00,
                 0.7218170389987850e+00,
                 0.8809922928066483e+00,
                 0.8809922928066479e+00,
                 0.1026180009390315e+01,
                 -.4629988501229477e+00,
                 -.4428193719671650e+00,
                 -.4353875163782214e+00,
                 -.4303703385717646e+00,
                 -.4303703385717644e+00,
                 -.4353875163782214e+00,
                 -.4428193719671654e+00,
                 -.4629988501229475e+00,
                 -.3361265623674407e+00,
                 -.2924676697217527e+00,
                 -.2884684987019528e+00,
                 -.2938619499924476e+00,
                 -.2884684987019528e+00,
                 -.2924676697217529e+00,
                 -.3361265623674412e+00,
                 -.1406144684506495e+00,
                 -.6820831525233976e-01,
                 -.8392287201555508e-01,
                 -.8392287201555522e-01,
                 -.6820831525233970e-01,
                 -.1406144684506498e+00,
                 0.1012660729829570e+00,
                 0.1469309749962237e+00,
                 0.1678457440311101e+00,
                 0.1469309749962237e+00,
                 0.1012660729829572e+00,
                 0.3291042655888078e+00,
                 0.3566768139542922e+00,
                 0.3566768139542926e+00,
                 0.3291042655888072e+00,
                 0.5760019848288708e+00,
                 0.5849353394435052e+00,
                 0.5760019848288713e+00,
                 0.7789459343346067e+00,
                 0.7789459343346063e+00,
                 0.9259977002458952e+00,
                 -.3959673352197227e+00,
                 -.3726217438614487e+00,
                 -.3576795986305403e+00,
                 -.3585007115112572e+00,
                 -.3576795986305407e+00,
                 -.3726217438614483e+00,
                 -.3959673352197229e+00,
                 -.2595907490516358e+00,
                 -.2095406467172422e+00,
                 -.2183310698905910e+00,
                 -.2183310698905910e+00,
                 -.2095406467172421e+00,
                 -.2595907490516356e+00,
                 -.4411540689949064e-01,
                 -.4130785207490467e-02,
                 -.2801280024959657e-15,
                 -.4130785207489950e-02,
                 -.4411540689949067e-01,
                 0.1792503557556289e+00,
                 0.2224618550980812e+00,
                 0.2224618550980810e+00,
                 0.1792503557556286e+00,
                 0.4017950055300308e+00,
                 0.4190812934344849e+00,
                 0.4017950055300309e+00,
                 0.6322124929130847e+00,
                 0.6322124929130848e+00,
                 0.7919346704394460e+00,
                 -.3110208413231237e+00,
                 -.2857749982887656e+00,
                 -.2817335344285907e+00,
                 -.2817335344285905e+00,
                 -.2857749982887659e+00,
                 -.3110208413231235e+00,
                 -.1690391287745493e+00,
                 -.1433371821712515e+00,
                 -.1468401222997419e+00,
                 -.1433371821712511e+00,
                 -.1690391287745495e+00,
                 0.3183065730245936e-01,
                 0.7342006114987083e-01,
                 0.7342006114987096e-01,
                 0.3183065730245925e-01,
                 0.2499028771261316e+00,
                 0.2866743643425028e+00,
                 0.2499028771261316e+00,
                 0.4548141270633144e+00,
                 0.4548141270633152e+00,
                 0.6220416826462470e+00,
                 -.2281341581766890e+00,
                 -.1988224223151372e+00,
                 -.1965153652850480e+00,
                 -.1988224223151369e+00,
                 -.2281341581766891e+00,
                 -.8579142750532439e-01,
                 -.6373414832033959e-01,
                 -.6373414832033895e-01,
                 -.8579142750532416e-01,
                 0.9825768264252401e-01,
                 0.1274682966406778e+00,
                 0.9825768264252401e-01,
                 0.2846138498204616e+00,
                 0.2846138498204610e+00,
                 0.4562683163533782e+00,
                 -.1460566911699641e+00,
                 -.1282574350689704e+00,
                 -.1282574350689702e+00,
                 -.1460566911699642e+00,
                 -.2156462546924701e-01,
                 -.1436758024869523e-15,
                 -.2156462546924732e-01,
                 0.1498220605382171e+00,
                 0.1498220605382169e+00,
                 0.2921133823399277e+00,
                 -.7351197971560409e-01,
                 -.7949209931594354e-01,
                 -.7351197971560383e-01,
                 0.3974604965797181e-01,
                 0.3974604965797164e-01,
                 0.1470239594312079e+00,
                 -.3353318237250680e-01,
                 -.3353318237250682e-01,
                 0.6706636474501516e-01,
                 -.3650762918110961e-15],
                [-.3724032938284433e+00,
                 -.3865209623293474e+00,
                 -.3793704459588624e+00,
                 -.3832688646261837e+00,
                 -.3812401562569473e+00,
                 -.3812401562569472e+00,
                 -.3832688646261837e+00,
                 -.3793704459588623e+00,
                 -.3865209623293473e+00,
                 -.3724032938284435e+00,
                 -.3865209623293476e+00,
                 -.3817395653046556e+00,
                 -.3786645464430092e+00,
                 -.3774303840015296e+00,
                 -.3766319700533838e+00,
                 -.3774303840015293e+00,
                 -.3786645464430095e+00,
                 -.3817395653046559e+00,
                 -.3865209623293470e+00,
                 -.3793704459588626e+00,
                 -.3786645464430093e+00,
                 -.3773441389752139e+00,
                 -.3782255735957464e+00,
                 -.3782255735957464e+00,
                 -.3773441389752139e+00,
                 -.3786645464430089e+00,
                 -.3793704459588630e+00,
                 -.3832688646261835e+00,
                 -.3774303840015295e+00,
                 -.3782255735957464e+00,
                 -.3802474262547186e+00,
                 -.3782255735957464e+00,
                 -.3774303840015297e+00,
                 -.3832688646261830e+00,
                 -.3812401562569473e+00,
                 -.3766319700533836e+00,
                 -.3782255735957464e+00,
                 -.3782255735957465e+00,
                 -.3766319700533835e+00,
                 -.3812401562569474e+00,
                 -.3812401562569474e+00,
                 -.3774303840015294e+00,
                 -.3773441389752138e+00,
                 -.3774303840015294e+00,
                 -.3812401562569476e+00,
                 -.3832688646261833e+00,
                 -.3786645464430095e+00,
                 -.3786645464430100e+00,
                 -.3832688646261833e+00,
                 -.3793704459588632e+00,
                 -.3817395653046551e+00,
                 -.3793704459588623e+00,
                 -.3865209623293467e+00,
                 -.3865209623293475e+00,
                 -.3724032938284447e+00,
                 -.2916747997278858e+00,
                 -.2693207603505388e+00,
                 -.2780736008805961e+00,
                 -.2708637401158234e+00,
                 -.2665723367984364e+00,
                 -.2708637401158229e+00,
                 -.2780736008805966e+00,
                 -.2693207603505388e+00,
                 -.2916747997278855e+00,
                 -.2693207603505395e+00,
                 -.2705338584427399e+00,
                 -.2518727210085398e+00,
                 -.2495223057374405e+00,
                 -.2495223057374397e+00,
                 -.2518727210085398e+00,
                 -.2705338584427405e+00,
                 -.2693207603505392e+00,
                 -.2780736008805964e+00,
                 -.2518727210085398e+00,
                 -.2558938547050586e+00,
                 -.2582792688495318e+00,
                 -.2558938547050583e+00,
                 -.2518727210085401e+00,
                 -.2780736008805960e+00,
                 -.2708637401158229e+00,
                 -.2495223057374401e+00,
                 -.2582792688495322e+00,
                 -.2582792688495322e+00,
                 -.2495223057374402e+00,
                 -.2708637401158225e+00,
                 -.2665723367984366e+00,
                 -.2495223057374395e+00,
                 -.2558938547050583e+00,
                 -.2495223057374393e+00,
                 -.2665723367984371e+00,
                 -.2708637401158229e+00,
                 -.2518727210085399e+00,
                 -.2518727210085406e+00,
                 -.2708637401158229e+00,
                 -.2780736008805966e+00,
                 -.2705338584427399e+00,
                 -.2780736008805962e+00,
                 -.2693207603505397e+00,
                 -.2693207603505389e+00,
                 -.2916747997278892e+00,
                 -.1714471685374555e+00,
                 -.1164886837059732e+00,
                 -.9942944417439626e-01,
                 -.8259441851534097e-01,
                 -.8259441851534089e-01,
                 -.9942944417439615e-01,
                 -.1164886837059731e+00,
                 -.1714471685374560e+00,
                 -.1164886837059731e+00,
                 -.7160532712669608e-01,
                 -.4823056224823951e-01,
                 -.5632930374085233e-01,
                 -.4823056224823935e-01,
                 -.7160532712669644e-01,
                 -.1164886837059726e+00,
                 -.9942944417439639e-01,
                 -.4823056224823952e-01,
                 -.5934243189885030e-01,
                 -.5934243189884995e-01,
                 -.4823056224823968e-01,
                 -.9942944417439642e-01,
                 -.8259441851534096e-01,
                 -.5632930374085201e-01,
                 -.5934243189884990e-01,
                 -.5632930374085211e-01,
                 -.8259441851534093e-01,
                 -.8259441851534104e-01,
                 -.4823056224823946e-01,
                 -.4823056224823991e-01,
                 -.8259441851534109e-01,
                 -.9942944417439607e-01,
                 -.7160532712669627e-01,
                 -.9942944417439622e-01,
                 -.1164886837059741e+00,
                 -.1164886837059733e+00,
                 -.1714471685374554e+00,
                 0.2984184242961935e-01,
                 0.7835770439663918e-01,
                 0.1230060420522890e+00,
                 0.1267491420849066e+00,
                 0.1230060420522881e+00,
                 0.7835770439663955e-01,
                 0.2984184242961958e-01,
                 0.7835770439663954e-01,
                 0.1558964683004125e+00,
                 0.1573042862951921e+00,
                 0.1573042862951919e+00,
                 0.1558964683004126e+00,
                 0.7835770439663928e-01,
                 0.1230060420522882e+00,
                 0.1573042862951921e+00,
                 0.1780272956965494e+00,
                 0.1573042862951918e+00,
                 0.1230060420522881e+00,
                 0.1267491420849060e+00,
                 0.1573042862951919e+00,
                 0.1573042862951922e+00,
                 0.1267491420849064e+00,
                 0.1230060420522884e+00,
                 0.1558964683004127e+00,
                 0.1230060420522884e+00,
                 0.7835770439663919e-01,
                 0.7835770439663954e-01,
                 0.2984184242961952e-01,
                 0.2640206848111379e+00,
                 0.3216021534259102e+00,
                 0.3378139500587987e+00,
                 0.3378139500587990e+00,
                 0.3216021534259101e+00,
                 0.2640206848111382e+00,
                 0.3216021534259102e+00,
                 0.3431481431744671e+00,
                 0.3523549792015369e+00,
                 0.3431481431744676e+00,
                 0.3216021534259102e+00,
                 0.3378139500587990e+00,
                 0.3523549792015370e+00,
                 0.3523549792015367e+00,
                 0.3378139500587991e+00,
                 0.3378139500587986e+00,
                 0.3431481431744670e+00,
                 0.3378139500587988e+00,
                 0.3216021534259104e+00,
                 0.3216021534259104e+00,
                 0.2640206848111380e+00,
                 0.4984596277027568e+00,
                 0.5699364197207125e+00,
                 0.5762030273240061e+00,
                 0.5699364197207124e+00,
                 0.4984596277027570e+00,
                 0.5699364197207125e+00,
                 0.5753507691437761e+00,
                 0.5753507691437755e+00,
                 0.5699364197207129e+00,
                 0.5762030273240063e+00,
                 0.5753507691437760e+00,
                 0.5762030273240062e+00,
                 0.5699364197207125e+00,
                 0.5699364197207124e+00,
                 0.4984596277027566e+00,
                 0.7366958868227467e+00,
                 0.7732268310295799e+00,
                 0.7732268310295799e+00,
                 0.7366958868227466e+00,
                 0.7732268310295800e+00,
                 0.8116015753282209e+00,
                 0.7732268310295796e+00,
                 0.7732268310295795e+00,
                 0.7732268310295796e+00,
                 0.7366958868227474e+00,
                 0.9301880604551815e+00,
                 0.9203810860057337e+00,
                 0.9301880604551829e+00,
                 0.9203810860057335e+00,
                 0.9203810860057334e+00,
                 0.9301880604551805e+00,
                 0.1064716724386583e+01,
                 0.1064716724386583e+01,
                 0.1064716724386583e+01,
                 0.1117209881485329e+01]],
     quad_degree: 13,
     weights: [0.6977149874619009e-03,
                 0.4223778342607621e-03,
                 0.1082299060827297e-02,
                 0.1235435863184459e-02,
                 0.1473824795194248e-02,
                 0.1473824795194255e-02,
                 0.1235435863184455e-02,
                 0.1082299060827312e-02,
                 0.4223778342607571e-03,
                 0.6977149874619148e-03,
                 0.4223778342607482e-03,
                 0.1890659621184649e-02,
                 0.2189167863976616e-02,
                 0.3633154743454531e-02,
                 0.4044140294192150e-02,
                 0.3633154743454562e-02,
                 0.2189167863976585e-02,
                 0.1890659621184642e-02,
                 0.4223778342607468e-03,
                 0.1082299060827299e-02,
                 0.2189167863976589e-02,
                 0.4521396729167518e-02,
                 0.4529354656582298e-02,
                 0.4529354656582328e-02,
                 0.4521396729167515e-02,
                 0.2189167863976590e-02,
                 0.1082299060827287e-02,
                 0.1235435863184460e-02,
                 0.3633154743454545e-02,
                 0.4529354656582314e-02,
                 0.3893916236991681e-02,
                 0.4529354656582308e-02,
                 0.3633154743454535e-02,
                 0.1235435863184497e-02,
                 0.1473824795194245e-02,
                 0.4044140294192170e-02,
                 0.4529354656582325e-02,
                 0.4529354656582327e-02,
                 0.4044140294192174e-02,
                 0.1473824795194236e-02,
                 0.1473824795194237e-02,
                 0.3633154743454536e-02,
                 0.4521396729167517e-02,
                 0.3633154743454541e-02,
                 0.1473824795194236e-02,
                 0.1235435863184469e-02,
                 0.2189167863976574e-02,
                 0.2189167863976555e-02,
                 0.1235435863184473e-02,
                 0.1082299060827276e-02,
                 0.1890659621184689e-02,
                 0.1082299060827319e-02,
                 0.4223778342607576e-03,
                 0.4223778342607475e-03,
                 0.6977149874618904e-03,
                 0.4223778342607720e-03,
                 0.1890659621184661e-02,
                 0.2189167863976572e-02,
                 0.3633154743454554e-02,
                 0.4044140294192167e-02,
                 0.3633154743454528e-02,
                 0.2189167863976599e-02,
                 0.1890659621184666e-02,
                 0.4223778342607561e-03,
                 0.1890659621184688e-02,
                 0.4861843772460685e-02,
                 0.8844205377861949e-02,
                 0.7542776133303702e-02,
                 0.7542776133303687e-02,
                 0.8844205377861957e-02,
                 0.4861843772460686e-02,
                 0.1890659621184679e-02,
                 0.2189167863976573e-02,
                 0.8844205377861973e-02,
                 0.9928364791203819e-02,
                 0.8692334329786796e-02,
                 0.9928364791203881e-02,
                 0.8844205377861947e-02,
                 0.2189167863976571e-02,
                 0.3633154743454539e-02,
                 0.7542776133303691e-02,
                 0.8692334329786787e-02,
                 0.8692334329786767e-02,
                 0.7542776133303693e-02,
                 0.3633154743454550e-02,
                 0.4044140294192167e-02,
                 0.7542776133303709e-02,
                 0.9928364791203861e-02,
                 0.7542776133303681e-02,
                 0.4044140294192167e-02,
                 0.3633154743454555e-02,
                 0.8844205377861963e-02,
                 0.8844205377861945e-02,
                 0.3633154743454530e-02,
                 0.2189167863976603e-02,
                 0.4861843772460688e-02,
                 0.2189167863976586e-02,
                 0.1890659621184639e-02,
                 0.1890659621184663e-02,
                 0.4223778342607854e-03,
                 0.1082299060827304e-02,
                 0.2189167863976566e-02,
                 0.4521396729167534e-02,
                 0.4529354656582330e-02,
                 0.4529354656582306e-02,
                 0.4521396729167523e-02,
                 0.2189167863976572e-02,
                 0.1082299060827306e-02,
                 0.2189167863976569e-02,
                 0.8844205377861973e-02,
                 0.9928364791203875e-02,
                 0.8692334329786794e-02,
                 0.9928364791203822e-02,
                 0.8844205377862001e-02,
                 0.2189167863976573e-02,
                 0.4521396729167517e-02,
                 0.9928364791203826e-02,
                 0.1510527732401861e-01,
                 0.1510527732401860e-01,
                 0.9928364791203857e-02,
                 0.4521396729167516e-02,
                 0.4529354656582336e-02,
                 0.8692334329786787e-02,
                 0.1510527732401862e-01,
                 0.8692334329786781e-02,
                 0.4529354656582326e-02,
                 0.4529354656582304e-02,
                 0.9928364791203842e-02,
                 0.9928364791203858e-02,
                 0.4529354656582337e-02,
                 0.4521396729167531e-02,
                 0.8844205377861987e-02,
                 0.4521396729167515e-02,
                 0.2189167863976589e-02,
                 0.2189167863976575e-02,
                 0.1082299060827309e-02,
                 0.1235435863184467e-02,
                 0.3633154743454567e-02,
                 0.4529354656582301e-02,
                 0.3893916236991701e-02,
                 0.4529354656582301e-02,
                 0.3633154743454574e-02,
                 0.1235435863184464e-02,
                 0.3633154743454556e-02,
                 0.7542776133303675e-02,
                 0.8692334329786800e-02,
                 0.8692334329786804e-02,
                 0.7542776133303704e-02,
                 0.3633154743454556e-02,
                 0.4529354656582315e-02,
                 0.8692334329786802e-02,
                 0.1510527732401866e-01,
                 0.8692334329786781e-02,
                 0.4529354656582321e-02,
                 0.3893916236991695e-02,
                 0.8692334329786834e-02,
                 0.8692334329786829e-02,
                 0.3893916236991684e-02,
                 0.4529354656582300e-02,
                 0.7542776133303659e-02,
                 0.4529354656582330e-02,
                 0.3633154743454579e-02,
                 0.3633154743454568e-02,
                 0.1235435863184451e-02,
                 0.1473824795194258e-02,
                 0.4044140294192151e-02,
                 0.4529354656582298e-02,
                 0.4529354656582316e-02,
                 0.4044140294192145e-02,
                 0.1473824795194259e-02,
                 0.4044140294192145e-02,
                 0.7542776133303670e-02,
                 0.9928364791203864e-02,
                 0.7542776133303680e-02,
                 0.4044140294192164e-02,
                 0.4529354656582317e-02,
                 0.9928364791203900e-02,
                 0.9928364791203875e-02,
                 0.4529354656582306e-02,
                 0.4529354656582299e-02,
                 0.7542776133303699e-02,
                 0.4529354656582292e-02,
                 0.4044140294192143e-02,
                 0.4044140294192133e-02,
                 0.1473824795194264e-02,
                 0.1473824795194247e-02,
                 0.3633154743454531e-02,
                 0.4521396729167524e-02,
                 0.3633154743454547e-02,
                 0.1473824795194238e-02,
                 0.3633154743454549e-02,
                 0.8844205377861960e-02,
                 0.8844205377861970e-02,
                 0.3633154743454536e-02,
                 0.4521396729167530e-02,
                 0.8844205377861984e-02,
                 0.4521396729167532e-02,
                 0.3633154743454542e-02,
                 0.3633154743454559e-02,
                 0.1473824795194247e-02,
                 0.1235435863184466e-02,
                 0.2189167863976594e-02,
                 0.2189167863976605e-02,
                 0.1235435863184470e-02,
                 0.2189167863976589e-02,
                 0.4861843772460690e-02,
                 0.2189167863976605e-02,
                 0.2189167863976591e-02,
                 0.2189167863976589e-02,
                 0.1235435863184473e-02,
                 0.1082299060827299e-02,
                 0.1890659621184643e-02,
                 0.1082299060827272e-02,
                 0.1890659621184651e-02,
                 0.1890659621184652e-02,
                 0.1082299060827295e-02,
                 0.4223778342607620e-03,
                 0.4223778342607602e-03,
                 0.4223778342607663e-03,
                 0.6977149874618929e-03]},
 10: {points: [[-.9273734205583750e+00,
                  -.8820181165796095e+00,
                  -.7637918432934267e+00,
                  -.5392633539687360e+00,
                  -.2793190734148037e+00,
                  -.4426320290757633e-15,
                  0.2793190734148039e+00,
                  0.5392633539687357e+00,
                  0.7637918432934267e+00,
                  0.8820181165796092e+00,
                  0.9273734205583756e+00,
                  -.9233298497232088e+00,
                  -.7914226371451994e+00,
                  -.6435216717368489e+00,
                  -.4171808846025189e+00,
                  -.1400863604171239e+00,
                  0.1400863604171243e+00,
                  0.4171808846025183e+00,
                  0.6435216717368488e+00,
                  0.7914226371451991e+00,
                  0.9233298497232081e+00,
                  -.8624389149166895e+00,
                  -.7300954114384766e+00,
                  -.5243621341498332e+00,
                  -.2619354712985205e+00,
                  0.2863344291383565e-15,
                  0.2619354712985199e+00,
                  0.5243621341498331e+00,
                  0.7300954114384772e+00,
                  0.8624389149166919e+00,
                  -.7487998460248591e+00,
                  -.6034258394864093e+00,
                  -.3826665685127703e+00,
                  -.1341096683912318e+00,
                  0.1341096683912320e+00,
                  0.3826665685127697e+00,
                  0.6034258394864091e+00,
                  0.7487998460248587e+00,
                  -.6138407393050901e+00,
                  -.4628776233091726e+00,
                  -.2516806801665189e+00,
                  0.5653205781580339e-15,
                  0.2516806801665208e+00,
                  0.4628776233091735e+00,
                  0.6138407393050903e+00,
                  -.4762632885690433e+00,
                  -.3227912628920497e+00,
                  -.1207310972142498e+00,
                  0.1207310972142494e+00,
                  0.3227912628920495e+00,
                  0.4762632885690434e+00,
                  -.3345216658902875e+00,
                  -.1862449548838904e+00,
                  -.1404676251670500e-15,
                  0.1862449548838897e+00,
                  0.3345216658902873e+00,
                  -.2095364920561218e+00,
                  -.8657373970162846e-01,
                  0.8657373970162874e-01,
                  0.2095364920561223e+00,
                  -.9864707162326612e-01,
                  -.2712889132906832e-15,
                  0.9864707162326621e-01,
                  -.4131173314359964e-01,
                  0.4131173314359945e-01,
                  -.3659776277435322e-15,
                  -.9233298497232088e+00,
                  -.7914226371451996e+00,
                  -.6435216717368489e+00,
                  -.4171808846025190e+00,
                  -.1400863604171241e+00,
                  0.1400863604171244e+00,
                  0.4171808846025184e+00,
                  0.6435216717368486e+00,
                  0.7914226371452003e+00,
                  0.9233298497232083e+00,
                  -.8421103241034670e+00,
                  -.7202875565694331e+00,
                  -.5087919501924901e+00,
                  -.2556935945849893e+00,
                  0.1460163362698723e-16,
                  0.2556935945849887e+00,
                  0.5087919501924902e+00,
                  0.7202875565694337e+00,
                  0.8421103241034686e+00,
                  -.7723356222930916e+00,
                  -.5982377261431260e+00,
                  -.3609607715458237e+00,
                  -.1227696151543824e+00,
                  0.1227696151543826e+00,
                  0.3609607715458235e+00,
                  0.5982377261431256e+00,
                  0.7723356222930913e+00,
                  -.6537523969453232e+00,
                  -.4726106802484574e+00,
                  -.2555380580448678e+00,
                  -.8690161718154644e-15,
                  0.2555380580448670e+00,
                  0.4726106802484571e+00,
                  0.6537523969453228e+00,
                  -.5145851253746605e+00,
                  -.3489629932873329e+00,
                  -.1327684428904851e+00,
                  0.1327684428904849e+00,
                  0.3489629932873328e+00,
                  0.5145851253746607e+00,
                  -.3744987649575366e+00,
                  -.2169170856634693e+00,
                  -.2173042436808945e-15,
                  0.2169170856634688e+00,
                  0.3744987649575367e+00,
                  -.2365715123428040e+00,
                  -.8944577595063591e-01,
                  0.8944577595063532e-01,
                  0.2365715123428038e+00,
                  -.1288139505562426e+00,
                  0.4361974712768598e-15,
                  0.1288139505562426e+00,
                  -.5068768695826924e-01,
                  0.5068768695826914e-01,
                  0.2647255546343669e-16,
                  -.8624389149166896e+00,
                  -.7300954114384766e+00,
                  -.5243621341498333e+00,
                  -.2619354712985205e+00,
                  0.2973606170680436e-16,
                  0.2619354712985199e+00,
                  0.5243621341498330e+00,
                  0.7300954114384770e+00,
                  0.8624389149166908e+00,
                  -.7723356222930913e+00,
                  -.5982377261431260e+00,
                  -.3609607715458242e+00,
                  -.1227696151543826e+00,
                  0.1227696151543825e+00,
                  0.3609607715458240e+00,
                  0.5982377261431257e+00,
                  0.7723356222930911e+00,
                  -.6616094372847786e+00,
                  -.4666962851973860e+00,
                  -.2670669178200364e+00,
                  0.4678127826680380e-15,
                  0.2670669178200371e+00,
                  0.4666962851973866e+00,
                  0.6616094372847786e+00,
                  -.5277067607210687e+00,
                  -.3561305696810475e+00,
                  -.1327979393337321e+00,
                  0.1327979393337319e+00,
                  0.3561305696810472e+00,
                  0.5277067607210687e+00,
                  -.3973644291993387e+00,
                  -.2333609545266645e+00,
                  0.1362385686020090e-15,
                  0.2333609545266645e+00,
                  0.3973644291993388e+00,
                  -.2657712894225486e+00,
                  -.1057355136515626e+00,
                  0.1057355136515623e+00,
                  0.2657712894225483e+00,
                  -.1372473031349457e+00,
                  -.2642182096893611e-15,
                  0.1372473031349457e+00,
                  -.4224021085461430e-01,
                  0.4224021085461412e-01,
                  -.2149723520204236e-15,
                  -.7487998460248593e+00,
                  -.6034258394864095e+00,
                  -.3826665685127703e+00,
                  -.1341096683912313e+00,
                  0.1341096683912328e+00,
                  0.3826665685127704e+00,
                  0.6034258394864092e+00,
                  0.7487998460248592e+00,
                  -.6537523969453236e+00,
                  -.4726106802484573e+00,
                  -.2555380580448672e+00,
                  -.2163643881134258e-15,
                  0.2555380580448674e+00,
                  0.4726106802484576e+00,
                  0.6537523969453236e+00,
                  -.5277067607210689e+00,
                  -.3561305696810471e+00,
                  -.1327979393337319e+00,
                  0.1327979393337317e+00,
                  0.3561305696810469e+00,
                  0.5277067607210686e+00,
                  -.4024320818667430e+00,
                  -.2281183151859924e+00,
                  -.8290586215193652e-17,
                  0.2281183151859920e+00,
                  0.4024320818667435e+00,
                  -.2683224134755112e+00,
                  -.1005925116361796e+00,
                  0.1005925116361800e+00,
                  0.2683224134755117e+00,
                  -.1450401922082984e+00,
                  0.2120680412756729e-15,
                  0.1450401922082988e+00,
                  -.5032655745891373e-01,
                  0.5032655745891431e-01,
                  0.2601288609998201e-15,
                  -.6138407393050903e+00,
                  -.4628776233091731e+00,
                  -.2516806801665192e+00,
                  0.8878364202933523e-15,
                  0.2516806801665207e+00,
                  0.4628776233091738e+00,
                  0.6138407393050904e+00,
                  -.5145851253746603e+00,
                  -.3489629932873324e+00,
                  -.1327684428904848e+00,
                  0.1327684428904844e+00,
                  0.3489629932873329e+00,
                  0.5145851253746607e+00,
                  -.3973644291993382e+00,
                  -.2333609545266641e+00,
                  -.4211847414956555e-16,
                  0.2333609545266643e+00,
                  0.3973644291993387e+00,
                  -.2683224134755113e+00,
                  -.1005925116361803e+00,
                  0.1005925116361793e+00,
                  0.2683224134755114e+00,
                  -.1456837490328192e+00,
                  -.1416662241865022e-15,
                  0.1456837490328191e+00,
                  -.5170750206548725e-01,
                  0.5170750206548690e-01,
                  -.5226463409860180e-16,
                  -.4762632885690431e+00,
                  -.3227912628920498e+00,
                  -.1207310972142498e+00,
                  0.1207310972142496e+00,
                  0.3227912628920496e+00,
                  0.4762632885690431e+00,
                  -.3744987649575366e+00,
                  -.2169170856634690e+00,
                  0.2158683492253796e-16,
                  0.2169170856634689e+00,
                  0.3744987649575365e+00,
                  -.2657712894225484e+00,
                  -.1057355136515626e+00,
                  0.1057355136515629e+00,
                  0.2657712894225485e+00,
                  -.1450401922082988e+00,
                  -.4239373367606729e-15,
                  0.1450401922082986e+00,
                  -.5170750206548752e-01,
                  0.5170750206548741e-01,
                  -.7207012917095334e-16,
                  -.3345216658902877e+00,
                  -.1862449548838906e+00,
                  0.2004792158808277e-15,
                  0.1862449548838906e+00,
                  0.3345216658902874e+00,
                  -.2365715123428043e+00,
                  -.8944577595063568e-01,
                  0.8944577595063555e-01,
                  0.2365715123428039e+00,
                  -.1372473031349458e+00,
                  0.1457441608742581e-15,
                  0.1372473031349457e+00,
                  -.5032655745891412e-01,
                  0.5032655745891380e-01,
                  -.7476516959079628e-16,
                  -.2095364920561220e+00,
                  -.8657373970162807e-01,
                  0.8657373970162859e-01,
                  0.2095364920561223e+00,
                  -.1288139505562422e+00,
                  -.1087664870774307e-15,
                  0.1288139505562424e+00,
                  -.4224021085461366e-01,
                  0.4224021085461439e-01,
                  0.1701174532423812e-15,
                  -.9864707162326536e-01,
                  -.5549152097764523e-17,
                  0.9864707162326575e-01,
                  -.5068768695826988e-01,
                  0.5068768695826888e-01,
                  -.4101563434587982e-15,
                  -.4131173314359737e-01,
                  0.4131173314360018e-01,
                  0.1263377010776305e-14,
                  -.1498258782244998e-14],
                 [-.5354192939986848e+00,
                  -.5569360775396559e+00,
                  -.5548832530432229e+00,
                  -.5532957427652542e+00,
                  -.5475372899288723e+00,
                  -.5499414757209472e+00,
                  -.5475372899288728e+00,
                  -.5532957427652541e+00,
                  -.5548832530432226e+00,
                  -.5569360775396564e+00,
                  -.5354192939986834e+00,
                  -.4853820567862159e+00,
                  -.4569280725985445e+00,
                  -.4715041542496030e+00,
                  -.4559166457008779e+00,
                  -.4536061429421896e+00,
                  -.4536061429421907e+00,
                  -.4559166457008780e+00,
                  -.4715041542496030e+00,
                  -.4569280725985439e+00,
                  -.4853820567862162e+00,
                  -.3840215129738361e+00,
                  -.3215540384851400e+00,
                  -.3027406193042533e+00,
                  -.2906367778169238e+00,
                  -.2906158168879391e+00,
                  -.2906367778169242e+00,
                  -.3027406193042529e+00,
                  -.3215540384851398e+00,
                  -.3840215129738384e+00,
                  -.1903678924842991e+00,
                  -.1333309211886074e+00,
                  -.8152438338830639e-01,
                  -.7742825314661046e-01,
                  -.7742825314660949e-01,
                  -.8152438338830623e-01,
                  -.1333309211886068e+00,
                  -.1903678924842985e+00,
                  0.3187123162568605e-01,
                  0.1054847246261636e+00,
                  0.1453079084439681e+00,
                  0.1548565062932200e+00,
                  0.1453079084439685e+00,
                  0.1054847246261634e+00,
                  0.3187123162568611e-01,
                  0.2749707378604741e+00,
                  0.3481214183160263e+00,
                  0.3721611612052312e+00,
                  0.3721611612052307e+00,
                  0.3481214183160265e+00,
                  0.2749707378604741e+00,
                  0.5156660583031851e+00,
                  0.5892475668894844e+00,
                  0.6054812386085062e+00,
                  0.5892475668894851e+00,
                  0.5156660583031852e+00,
                  0.7436636352495536e+00,
                  0.7930581927347429e+00,
                  0.7930581927347431e+00,
                  0.7436636352495536e+00,
                  0.9389047660170613e+00,
                  0.9138561451970884e+00,
                  0.9389047660170606e+00,
                  0.1042318134325873e+01,
                  0.1042318134325873e+01,
                  0.1070838587997366e+01,
                  -.5330847372885083e+00,
                  -.5154571720184565e+00,
                  -.5202789484646788e+00,
                  -.5140287486934604e+00,
                  -.5133128234154538e+00,
                  -.5133128234154541e+00,
                  -.5140287486934602e+00,
                  -.5202789484646787e+00,
                  -.5154571720184567e+00,
                  -.5330847372885103e+00,
                  -.4276635228885880e+00,
                  -.4158582146793003e+00,
                  -.3970342550510973e+00,
                  -.3980990412629717e+00,
                  -.4029477562233173e+00,
                  -.3980990412629715e+00,
                  -.3970342550510974e+00,
                  -.4158582146793006e+00,
                  -.4276635228885889e+00,
                  -.2971666413776020e+00,
                  -.2421096265821743e+00,
                  -.2084007986188763e+00,
                  -.2241888628431068e+00,
                  -.2241888628431064e+00,
                  -.2084007986188766e+00,
                  -.2421096265821744e+00,
                  -.2971666413776024e+00,
                  -.1042748696923155e+00,
                  -.2238762786407370e-01,
                  0.5772825885019217e-02,
                  0.1435754823303778e-14,
                  0.5772825885018653e-02,
                  -.2238762786407421e-01,
                  -.1042748696923153e+00,
                  0.1353380648627950e+00,
                  0.2014738781116586e+00,
                  0.2184160369580893e+00,
                  0.2184160369580885e+00,
                  0.2014738781116581e+00,
                  0.1353380648627949e+00,
                  0.3779747585526585e+00,
                  0.4204866691270450e+00,
                  0.4168015972377526e+00,
                  0.4204866691270450e+00,
                  0.3779747585526587e+00,
                  0.6183036183857766e+00,
                  0.6391438816332723e+00,
                  0.6391438816332717e+00,
                  0.6183036183857765e+00,
                  0.8174455898422808e+00,
                  0.8317164293586006e+00,
                  0.8174455898422810e+00,
                  0.9431206949070434e+00,
                  0.9431206949070448e+00,
                  0.1066169474577020e+01,
                  -.4979293396867600e+00,
                  -.4702955765431911e+00,
                  -.4612201541252751e+00,
                  -.4581147658464766e+00,
                  -.4588369203292405e+00,
                  -.4581147658464767e+00,
                  -.4612201541252750e+00,
                  -.4702955765431914e+00,
                  -.4979293396867600e+00,
                  -.3971333852205769e+00,
                  -.3453927122281232e+00,
                  -.3304936531581426e+00,
                  -.3403430901863245e+00,
                  -.3403430901863245e+00,
                  -.3304936531581426e+00,
                  -.3453927122281233e+00,
                  -.3971333852205771e+00,
                  -.2235008518937414e+00,
                  -.1473543713492437e+00,
                  -.1541911568950422e+00,
                  -.1533418520443148e+00,
                  -.1541911568950421e+00,
                  -.1473543713492440e+00,
                  -.2235008518937416e+00,
                  0.2214610626470307e-02,
                  0.6384993955662835e-01,
                  0.7667092602215789e-01,
                  0.7667092602215803e-01,
                  0.6384993955662781e-01,
                  0.2214610626470484e-02,
                  0.2294184601646198e+00,
                  0.2764931506296976e+00,
                  0.3083823137900838e+00,
                  0.2764931506296976e+00,
                  0.2294184601646203e+00,
                  0.4559001552200062e+00,
                  0.4778480245073857e+00,
                  0.4778480245073857e+00,
                  0.4559001552200067e+00,
                  0.6847210060190167e+00,
                  0.6907854244562461e+00,
                  0.6847210060190169e+00,
                  0.8674289617637680e+00,
                  0.8674289617637679e+00,
                  0.9958586793735237e+00,
                  -.4323197926716029e+00,
                  -.4065001738560369e+00,
                  -.3884106343702709e+00,
                  -.3872602884460026e+00,
                  -.3872602884460025e+00,
                  -.3884106343702708e+00,
                  -.4065001738560365e+00,
                  -.4323197926716028e+00,
                  -.3193320193671636e+00,
                  -.2728619034633390e+00,
                  -.2636891939436166e+00,
                  -.2634083413594333e+00,
                  -.2636891939436165e+00,
                  -.2728619034633391e+00,
                  -.3193320193671636e+00,
                  -.1371936523259419e+00,
                  -.8945785292878877e-01,
                  -.7667092602215794e-01,
                  -.7667092602215776e-01,
                  -.8945785292878922e-01,
                  -.1371936523259417e+00,
                  0.7748776450308755e-01,
                  0.1317041706797172e+00,
                  0.1533418520443154e+00,
                  0.1317041706797172e+00,
                  0.7748776450308722e-01,
                  0.3097725239429154e+00,
                  0.3531470468724065e+00,
                  0.3531470468724064e+00,
                  0.3097725239429150e+00,
                  0.5256042866962133e+00,
                  0.5457238069266790e+00,
                  0.5256042866962131e+00,
                  0.7258321932232003e+00,
                  0.7258321932231995e+00,
                  0.8646395853432048e+00,
                  -.3544011160773529e+00,
                  -.3269492008926692e+00,
                  -.3135290118852716e+00,
                  -.3098320352993926e+00,
                  -.3135290118852714e+00,
                  -.3269492008926694e+00,
                  -.3544011160773530e+00,
                  -.2373891801827735e+00,
                  -.2014738781116591e+00,
                  -.1928081235859265e+00,
                  -.1928081235859265e+00,
                  -.2014738781116595e+00,
                  -.2373891801827742e+00,
                  -.6119735672331731e-01,
                  -.1857678257109984e-01,
                  0.5370910876094205e-15,
                  -.1857678257109990e-01,
                  -.6119735672331827e-01,
                  0.1549160176496957e+00,
                  0.2113849061570258e+00,
                  0.2113849061570271e+00,
                  0.1549160176496954e+00,
                  0.3747263686085871e+00,
                  0.4029477562233167e+00,
                  0.3747263686085875e+00,
                  0.5643383810754418e+00,
                  0.5643383810754425e+00,
                  0.7088022321547054e+00,
                  -.2749707378604732e+00,
                  -.2460703029960484e+00,
                  -.2371821195057585e+00,
                  -.2371821195057585e+00,
                  -.2460703029960485e+00,
                  -.2749707378604735e+00,
                  -.1565102822861517e+00,
                  -.1252371377996325e+00,
                  -.1220928545392658e+00,
                  -.1252371377996327e+00,
                  -.1565102822861518e+00,
                  0.1403486253857101e-01,
                  0.6104642726963333e-01,
                  0.6104642726963343e-01,
                  0.1403486253857078e-01,
                  0.2231472569671886e+00,
                  0.2504742755992661e+00,
                  0.2231472569671880e+00,
                  0.4025805852822006e+00,
                  0.4025805852822004e+00,
                  0.5499414757209472e+00,
                  -.1931361738515196e+00,
                  -.1656406778300062e+00,
                  -.1584795348210221e+00,
                  -.1656406778300059e+00,
                  -.1931361738515194e+00,
                  -.7847252334113224e-01,
                  -.5164154282297464e-01,
                  -.5164154282297456e-01,
                  -.7847252334113196e-01,
                  0.7923976741051103e-01,
                  0.1032830856459490e+00,
                  0.7923976741051094e-01,
                  0.2441132011711385e+00,
                  0.2441132011711387e+00,
                  0.3862723477030390e+00,
                  -.1209759500936521e+00,
                  -.9875816613656393e-01,
                  -.9875816613656384e-01,
                  -.1209759500936517e+00,
                  -.2559597481395029e-01,
                  0.7492650689364951e-15,
                  -.2559597481394986e-01,
                  0.1243541409505133e+00,
                  0.1243541409505131e+00,
                  0.2419519001873038e+00,
                  -.5695391335645994e-01,
                  -.5852909941991132e-01,
                  -.5695391335646058e-01,
                  0.2926454970995645e-01,
                  0.2926454970995561e-01,
                  0.1139078267129220e+00,
                  -.2385134025114841e-01,
                  -.2385134025114869e-01,
                  0.4770268050229269e-01,
                  0.1472940217638814e-14],
                 [-.3785986135645834e+00,
                  -.3938132771157278e+00,
                  -.3923617109937137e+00,
                  -.3912391717109589e+00,
                  -.3871673306612104e+00,
                  -.3888673467380190e+00,
                  -.3871673306612106e+00,
                  -.3912391717109588e+00,
                  -.3923617109937136e+00,
                  -.3938132771157285e+00,
                  -.3785986135645830e+00,
                  -.3938132771157271e+00,
                  -.3851764232937718e+00,
                  -.3851372664382100e+00,
                  -.3840189449735145e+00,
                  -.3840764776294717e+00,
                  -.3840764776294718e+00,
                  -.3840189449735145e+00,
                  -.3851372664382101e+00,
                  -.3851764232937718e+00,
                  -.3938132771157274e+00,
                  -.3923617109937134e+00,
                  -.3851372664382100e+00,
                  -.3821628754775038e+00,
                  -.3831484680093193e+00,
                  -.3839218393145716e+00,
                  -.3831484680093194e+00,
                  -.3821628754775037e+00,
                  -.3851372664382099e+00,
                  -.3923617109937139e+00,
                  -.3912391717109591e+00,
                  -.3840189449735145e+00,
                  -.3831484680093194e+00,
                  -.3833765426389418e+00,
                  -.3833765426389419e+00,
                  -.3831484680093194e+00,
                  -.3840189449735146e+00,
                  -.3912391717109587e+00,
                  -.3871673306612105e+00,
                  -.3840764776294718e+00,
                  -.3839218393145715e+00,
                  -.3833765426389418e+00,
                  -.3839218393145715e+00,
                  -.3840764776294719e+00,
                  -.3871673306612105e+00,
                  -.3888673467380189e+00,
                  -.3840764776294720e+00,
                  -.3831484680093193e+00,
                  -.3831484680093193e+00,
                  -.3840764776294719e+00,
                  -.3888673467380191e+00,
                  -.3871673306612098e+00,
                  -.3840189449735144e+00,
                  -.3821628754775037e+00,
                  -.3840189449735144e+00,
                  -.3871673306612099e+00,
                  -.3912391717109595e+00,
                  -.3851372664382104e+00,
                  -.3851372664382102e+00,
                  -.3912391717109596e+00,
                  -.3923617109937125e+00,
                  -.3851764232937715e+00,
                  -.3923617109937127e+00,
                  -.3938132771157308e+00,
                  -.3938132771157308e+00,
                  -.3785986135645801e+00,
                  -.3263514993878346e+00,
                  -.3024037771006487e+00,
                  -.3161592909572930e+00,
                  -.3018360207833822e+00,
                  -.2996384803399052e+00,
                  -.2996384803399059e+00,
                  -.3018360207833821e+00,
                  -.3161592909572926e+00,
                  -.3024037771006496e+00,
                  -.3263514993878330e+00,
                  -.3024037771006492e+00,
                  -.2940561636118640e+00,
                  -.2807456141099802e+00,
                  -.2814985316609102e+00,
                  -.2849270908894116e+00,
                  -.2814985316609102e+00,
                  -.2807456141099803e+00,
                  -.2940561636118636e+00,
                  -.3024037771006499e+00,
                  -.3161592909572927e+00,
                  -.2807456141099805e+00,
                  -.2768606459768065e+00,
                  -.2817256279096720e+00,
                  -.2817256279096724e+00,
                  -.2768606459768065e+00,
                  -.2807456141099802e+00,
                  -.3161592909572923e+00,
                  -.3018360207833826e+00,
                  -.2814985316609105e+00,
                  -.2817256279096719e+00,
                  -.2793867365945346e+00,
                  -.2817256279096721e+00,
                  -.2814985316609105e+00,
                  -.3018360207833821e+00,
                  -.2996384803399054e+00,
                  -.2849270908894122e+00,
                  -.2817256279096718e+00,
                  -.2817256279096717e+00,
                  -.2849270908894119e+00,
                  -.2996384803399060e+00,
                  -.2996384803399044e+00,
                  -.2814985316609105e+00,
                  -.2768606459768061e+00,
                  -.2814985316609102e+00,
                  -.2996384803399047e+00,
                  -.3018360207833821e+00,
                  -.2807456141099804e+00,
                  -.2807456141099799e+00,
                  -.3018360207833821e+00,
                  -.3161592909572935e+00,
                  -.2940561636118641e+00,
                  -.3161592909572936e+00,
                  -.3024037771006485e+00,
                  -.3024037771006489e+00,
                  -.3263514993878356e+00,
                  -.2312717175958520e+00,
                  -.1747849660282800e+00,
                  -.1580389679750352e+00,
                  -.1462988259389660e+00,
                  -.1460212733505161e+00,
                  -.1462988259389665e+00,
                  -.1580389679750348e+00,
                  -.1747849660282800e+00,
                  -.2312717175958534e+00,
                  -.1747849660282799e+00,
                  -.1346812736257375e+00,
                  -.1041952752185305e+00,
                  -.1174587442739248e+00,
                  -.1174587442739246e+00,
                  -.1041952752185307e+00,
                  -.1346812736257371e+00,
                  -.1747849660282803e+00,
                  -.1580389679750351e+00,
                  -.1041952752185308e+00,
                  -.1090296126394833e+00,
                  -.1084290634202400e+00,
                  -.1090296126394837e+00,
                  -.1041952752185307e+00,
                  -.1580389679750343e+00,
                  -.1462988259389666e+00,
                  -.1174587442739255e+00,
                  -.1084290634202395e+00,
                  -.1084290634202396e+00,
                  -.1174587442739248e+00,
                  -.1462988259389670e+00,
                  -.1460212733505146e+00,
                  -.1174587442739254e+00,
                  -.1090296126394828e+00,
                  -.1174587442739250e+00,
                  -.1460212733505157e+00,
                  -.1462988259389660e+00,
                  -.1041952752185308e+00,
                  -.1041952752185301e+00,
                  -.1462988259389660e+00,
                  -.1580389679750348e+00,
                  -.1346812736257367e+00,
                  -.1580389679750351e+00,
                  -.1747849660282798e+00,
                  -.1747849660282799e+00,
                  -.2312717175958556e+00,
                  -.4906751302413310e-01,
                  0.2300716972086855e-02,
                  0.5085423023520914e-01,
                  0.5479212373911804e-01,
                  0.5479212373911821e-01,
                  0.5085423023520931e-01,
                  0.2300716972087729e-02,
                  -.4906751302413288e-01,
                  0.2300716972087222e-02,
                  0.7272558591714696e-01,
                  0.9935121507643203e-01,
                  0.9312891219817895e-01,
                  0.9935121507643212e-01,
                  0.7272558591714687e-01,
                  0.2300716972087678e-02,
                  0.5085423023520880e-01,
                  0.9935121507643197e-01,
                  0.1084290634202396e+00,
                  0.1084290634202394e+00,
                  0.9935121507643204e-01,
                  0.5085423023520919e-01,
                  0.5479212373911932e-01,
                  0.9312891219817824e-01,
                  0.1084290634202397e+00,
                  0.9312891219817920e-01,
                  0.5479212373911853e-01,
                  0.5479212373911867e-01,
                  0.9935121507643204e-01,
                  0.9935121507643177e-01,
                  0.5479212373911810e-01,
                  0.5085423023520890e-01,
                  0.7272558591714695e-01,
                  0.5085423023520860e-01,
                  0.2300716972088008e-02,
                  0.2300716972087909e-02,
                  -.4906751302413295e-01,
                  0.1591042622301230e+00,
                  0.2274774446694988e+00,
                  0.2649715563325419e+00,
                  0.2737922951607043e+00,
                  0.2649715563325424e+00,
                  0.2274774446694984e+00,
                  0.1591042622301234e+00,
                  0.2274774446694980e+00,
                  0.2849270908894106e+00,
                  0.2998331571071661e+00,
                  0.2998331571071654e+00,
                  0.2849270908894110e+00,
                  0.2274774446694982e+00,
                  0.2649715563325429e+00,
                  0.2998331571071656e+00,
                  0.3270888379184492e+00,
                  0.2998331571071655e+00,
                  0.2649715563325428e+00,
                  0.2737922951607044e+00,
                  0.2998331571071654e+00,
                  0.2998331571071655e+00,
                  0.2737922951607044e+00,
                  0.2649715563325417e+00,
                  0.2849270908894107e+00,
                  0.2649715563325414e+00,
                  0.2274774446694982e+00,
                  0.2274774446694981e+00,
                  0.1591042622301235e+00,
                  0.3888673467380199e+00,
                  0.4562375132998782e+00,
                  0.4785930637130782e+00,
                  0.4785930637130780e+00,
                  0.4562375132998783e+00,
                  0.3888673467380198e+00,
                  0.4562375132998784e+00,
                  0.4902714774046743e+00,
                  0.4852511964138669e+00,
                  0.4902714774046733e+00,
                  0.4562375132998790e+00,
                  0.4785930637130771e+00,
                  0.4852511964138678e+00,
                  0.4852511964138672e+00,
                  0.4785930637130774e+00,
                  0.4785930637130773e+00,
                  0.4902714774046746e+00,
                  0.4785930637130786e+00,
                  0.4562375132998771e+00,
                  0.4562375132998775e+00,
                  0.3888673467380188e+00,
                  0.6152303990922962e+00,
                  0.6835542487848091e+00,
                  0.6982408114275738e+00,
                  0.6835542487848097e+00,
                  0.6152303990922963e+00,
                  0.6835542487848098e+00,
                  0.6961725018456978e+00,
                  0.6961725018456984e+00,
                  0.6835542487848093e+00,
                  0.6982408114275737e+00,
                  0.6961725018456970e+00,
                  0.6982408114275740e+00,
                  0.6835542487848105e+00,
                  0.6835542487848100e+00,
                  0.6152303990922964e+00,
                  0.8315458564460508e+00,
                  0.8760815234237831e+00,
                  0.8760815234237836e+00,
                  0.8315458564460513e+00,
                  0.8760815234237831e+00,
                  0.8821684908355937e+00,
                  0.8760815234237830e+00,
                  0.8760815234237824e+00,
                  0.8760815234237826e+00,
                  0.8315458564460514e+00,
                  0.1015995139583284e+01,
                  0.9899839774950701e+00,
                  0.1015995139583281e+01,
                  0.9899839774950694e+00,
                  0.9899839774950712e+00,
                  0.1015995139583282e+01,
                  0.1113978053619291e+01,
                  0.1113978053619293e+01,
                  0.1113978053619290e+01,
                  0.1135795840693746e+01]],
      quad_degree: 15,
      weights: [0.3521367632335424e-03,
                  0.1413161827715348e-03,
                  0.3456523266030488e-03,
                  0.5453877468193948e-03,
                  0.8292469614310042e-03,
                  0.7831726262173584e-03,
                  0.8292469614309855e-03,
                  0.5453877468193986e-03,
                  0.3456523266030496e-03,
                  0.1413161827715350e-03,
                  0.3521367632335600e-03,
                  0.1413161827715597e-03,
                  0.1033246082624046e-02,
                  0.1308980781976950e-02,
                  0.2080804700338810e-02,
                  0.2266026067975774e-02,
                  0.2266026067975758e-02,
                  0.2080804700338811e-02,
                  0.1308980781976954e-02,
                  0.1033246082624048e-02,
                  0.1413161827715458e-03,
                  0.3456523266030487e-03,
                  0.1308980781976945e-02,
                  0.3061517885688757e-02,
                  0.3308988096810712e-02,
                  0.3062151334579543e-02,
                  0.3308988096810710e-02,
                  0.3061517885688776e-02,
                  0.1308980781976951e-02,
                  0.3456523266030419e-03,
                  0.5453877468193884e-03,
                  0.2080804700338811e-02,
                  0.3308988096810710e-02,
                  0.3822889922946005e-02,
                  0.3822889922945995e-02,
                  0.3308988096810710e-02,
                  0.2080804700338814e-02,
                  0.5453877468193975e-03,
                  0.8292469614310157e-03,
                  0.2266026067975774e-02,
                  0.3062151334579574e-02,
                  0.3822889922946002e-02,
                  0.3062151334579555e-02,
                  0.2266026067975759e-02,
                  0.8292469614310039e-03,
                  0.7831726262173552e-03,
                  0.2266026067975755e-02,
                  0.3308988096810702e-02,
                  0.3308988096810715e-02,
                  0.2266026067975768e-02,
                  0.7831726262173501e-03,
                  0.8292469614310278e-03,
                  0.2080804700338807e-02,
                  0.3061517885688769e-02,
                  0.2080804700338819e-02,
                  0.8292469614310285e-03,
                  0.5453877468193907e-03,
                  0.1308980781976940e-02,
                  0.1308980781976945e-02,
                  0.5453877468193824e-03,
                  0.3456523266030458e-03,
                  0.1033246082624054e-02,
                  0.3456523266030449e-03,
                  0.1413161827715397e-03,
                  0.1413161827715447e-03,
                  0.3521367632335709e-03,
                  0.1413161827715592e-03,
                  0.1033246082624038e-02,
                  0.1308980781976956e-02,
                  0.2080804700338807e-02,
                  0.2266026067975768e-02,
                  0.2266026067975754e-02,
                  0.2080804700338811e-02,
                  0.1308980781976960e-02,
                  0.1033246082624033e-02,
                  0.1413161827715437e-03,
                  0.1033246082624060e-02,
                  0.2399966040969217e-02,
                  0.5033708098431246e-02,
                  0.5429317471235865e-02,
                  0.4801087458284609e-02,
                  0.5429317471235874e-02,
                  0.5033708098431251e-02,
                  0.2399966040969231e-02,
                  0.1033246082624032e-02,
                  0.1308980781976932e-02,
                  0.5033708098431252e-02,
                  0.7206625142122309e-02,
                  0.7004940861175833e-02,
                  0.7004940861175814e-02,
                  0.7206625142122276e-02,
                  0.5033708098431258e-02,
                  0.1308980781976956e-02,
                  0.2080804700338813e-02,
                  0.5429317471235834e-02,
                  0.7004940861175826e-02,
                  0.9118147425321130e-02,
                  0.7004940861175833e-02,
                  0.5429317471235854e-02,
                  0.2080804700338816e-02,
                  0.2266026067975761e-02,
                  0.4801087458284557e-02,
                  0.7004940861175811e-02,
                  0.7004940861175828e-02,
                  0.4801087458284591e-02,
                  0.2266026067975759e-02,
                  0.2266026067975765e-02,
                  0.5429317471235834e-02,
                  0.7206625142122318e-02,
                  0.5429317471235862e-02,
                  0.2266026067975761e-02,
                  0.2080804700338807e-02,
                  0.5033708098431265e-02,
                  0.5033708098431272e-02,
                  0.2080804700338820e-02,
                  0.1308980781976934e-02,
                  0.2399966040969233e-02,
                  0.1308980781976938e-02,
                  0.1033246082624052e-02,
                  0.1033246082624036e-02,
                  0.1413161827715318e-03,
                  0.3456523266030527e-03,
                  0.1308980781976939e-02,
                  0.3061517885688760e-02,
                  0.3308988096810719e-02,
                  0.3062151334579566e-02,
                  0.3308988096810720e-02,
                  0.3061517885688772e-02,
                  0.1308980781976944e-02,
                  0.3456523266030517e-03,
                  0.1308980781976935e-02,
                  0.5033708098431237e-02,
                  0.7206625142122299e-02,
                  0.7004940861175836e-02,
                  0.7004940861175843e-02,
                  0.7206625142122300e-02,
                  0.5033708098431228e-02,
                  0.1308980781976950e-02,
                  0.3061517885688775e-02,
                  0.7206625142122325e-02,
                  0.9651351165803155e-02,
                  0.1230176557200611e-01,
                  0.9651351165803150e-02,
                  0.7206625142122289e-02,
                  0.3061517885688771e-02,
                  0.3308988096810726e-02,
                  0.7004940861175846e-02,
                  0.1230176557200614e-01,
                  0.1230176557200613e-01,
                  0.7004940861175883e-02,
                  0.3308988096810728e-02,
                  0.3062151334579529e-02,
                  0.7004940861175814e-02,
                  0.9651351165803129e-02,
                  0.7004940861175818e-02,
                  0.3062151334579537e-02,
                  0.3308988096810711e-02,
                  0.7206625142122308e-02,
                  0.7206625142122294e-02,
                  0.3308988096810704e-02,
                  0.3061517885688772e-02,
                  0.5033708098431243e-02,
                  0.3061517885688774e-02,
                  0.1308980781976946e-02,
                  0.1308980781976962e-02,
                  0.3456523266030522e-03,
                  0.5453877468193839e-03,
                  0.2080804700338812e-02,
                  0.3308988096810713e-02,
                  0.3822889922946005e-02,
                  0.3822889922945998e-02,
                  0.3308988096810706e-02,
                  0.2080804700338810e-02,
                  0.5453877468193871e-03,
                  0.2080804700338808e-02,
                  0.5429317471235844e-02,
                  0.7004940861175821e-02,
                  0.9118147425321116e-02,
                  0.7004940861175849e-02,
                  0.5429317471235827e-02,
                  0.2080804700338803e-02,
                  0.3308988096810733e-02,
                  0.7004940861175856e-02,
                  0.1230176557200616e-01,
                  0.1230176557200616e-01,
                  0.7004940861175867e-02,
                  0.3308988096810727e-02,
                  0.3822889922946003e-02,
                  0.9118147425321132e-02,
                  0.1230176557200613e-01,
                  0.9118147425321138e-02,
                  0.3822889922946012e-02,
                  0.3822889922945992e-02,
                  0.7004940861175841e-02,
                  0.7004940861175789e-02,
                  0.3822889922945987e-02,
                  0.3308988096810714e-02,
                  0.5429317471235805e-02,
                  0.3308988096810699e-02,
                  0.2080804700338790e-02,
                  0.2080804700338782e-02,
                  0.5453877468193989e-03,
                  0.8292469614310169e-03,
                  0.2266026067975770e-02,
                  0.3062151334579567e-02,
                  0.3822889922946008e-02,
                  0.3062151334579553e-02,
                  0.2266026067975749e-02,
                  0.8292469614309996e-03,
                  0.2266026067975768e-02,
                  0.4801087458284595e-02,
                  0.7004940861175817e-02,
                  0.7004940861175815e-02,
                  0.4801087458284583e-02,
                  0.2266026067975759e-02,
                  0.3062151334579547e-02,
                  0.7004940861175826e-02,
                  0.9651351165803155e-02,
                  0.7004940861175814e-02,
                  0.3062151334579560e-02,
                  0.3822889922945975e-02,
                  0.7004940861175810e-02,
                  0.7004940861175820e-02,
                  0.3822889922946005e-02,
                  0.3062151334579542e-02,
                  0.4801087458284600e-02,
                  0.3062151334579577e-02,
                  0.2266026067975779e-02,
                  0.2266026067975783e-02,
                  0.8292469614310112e-03,
                  0.7831726262173506e-03,
                  0.2266026067975774e-02,
                  0.3308988096810716e-02,
                  0.3308988096810716e-02,
                  0.2266026067975765e-02,
                  0.7831726262173504e-03,
                  0.2266026067975777e-02,
                  0.5429317471235832e-02,
                  0.7206625142122302e-02,
                  0.5429317471235855e-02,
                  0.2266026067975767e-02,
                  0.3308988096810698e-02,
                  0.7206625142122267e-02,
                  0.7206625142122297e-02,
                  0.3308988096810692e-02,
                  0.3308988096810699e-02,
                  0.5429317471235821e-02,
                  0.3308988096810709e-02,
                  0.2266026067975781e-02,
                  0.2266026067975790e-02,
                  0.7831726262173622e-03,
                  0.8292469614310196e-03,
                  0.2080804700338802e-02,
                  0.3061517885688776e-02,
                  0.2080804700338811e-02,
                  0.8292469614310253e-03,
                  0.2080804700338800e-02,
                  0.5033708098431267e-02,
                  0.5033708098431278e-02,
                  0.2080804700338810e-02,
                  0.3061517885688782e-02,
                  0.5033708098431257e-02,
                  0.3061517885688761e-02,
                  0.2080804700338797e-02,
                  0.2080804700338799e-02,
                  0.8292469614310308e-03,
                  0.5453877468193944e-03,
                  0.1308980781976955e-02,
                  0.1308980781976942e-02,
                  0.5453877468193884e-03,
                  0.1308980781976954e-02,
                  0.2399966040969245e-02,
                  0.1308980781976945e-02,
                  0.1308980781976957e-02,
                  0.1308980781976958e-02,
                  0.5453877468193845e-03,
                  0.3456523266030455e-03,
                  0.1033246082624051e-02,
                  0.3456523266030462e-03,
                  0.1033246082624021e-02,
                  0.1033246082624031e-02,
                  0.3456523266030520e-03,
                  0.1413161827715346e-03,
                  0.1413161827715393e-03,
                  0.1413161827715380e-03,
                  0.3521367632335686e-03]}})
